#ifndef FW_FIVISITOR_HEADER
#define FW_FIVISITOR_HEADER

// --Basisklasse fuer eine FI-Besucher-Klasse

class fw_fi_tclOutput {
public:
   fw_fi_tclOutput();
   virtual ~fw_fi_tclOutput(){};

   virtual tVoid vPrintLine(tCString coszLine) = 0;
};

class fw_fi_tclFileOutput : public fw_fi_tclOutput 
{
public:
   fw_fi_tclFileOutput(OSAL_tIODescriptor rIOD):fd(rIOD) {}
   virtual tVoid vPrintLine(tCString coszLine);
protected:
   OSAL_tIODescriptor fd;
private:
   fw_fi_tclFileOutput(); //lint !e1704
   fw_fi_tclFileOutput& operator=(const fw_fi_tclFileOutput& coRef);
   fw_fi_tclFileOutput(const fw_fi_tclFileOutput& coRef); //lint !e1704
};

class fw_fi_tclMemOutput : public fw_fi_tclOutput
{
public:
   fw_fi_tclMemOutput(tU32 u32MemSize);
   virtual ~fw_fi_tclMemOutput();
   virtual tVoid vPrintLine(tCString coszLine);
   tString szGetBuffer();
protected:
   tChar* szBuf;
   tChar* szEndBuf;
   tChar* s8BufPos;
private:
   fw_fi_tclMemOutput(); //lint !e1704
   fw_fi_tclMemOutput(const fw_fi_tclMemOutput& coRef); //lint !e1704
   fw_fi_tclMemOutput& operator=(const fw_fi_tclMemOutput& coRef); //lint !e1704
};

class MY_DECL fw_fi_tclVisitorBase {
public:

   // --Konstruktor
   fw_fi_tclVisitorBase():bBreakNow(FALSE),bIsVisitorValid(FALSE) {}
   virtual ~fw_fi_tclVisitorBase() {}

   tBool bIsValid() const { return bIsVisitorValid; }
   tVoid vInvalidate() { bIsVisitorValid=FALSE; }
   tVoid vValidate() { bIsVisitorValid=TRUE; }
   tBool bBreak() const { return bBreakNow; }
   tVoid vReleaseBreak() { bBreakNow = FALSE; }
   // --Besuche allgemeine Objekte	
   virtual tVoid vVisitU8(fw_fi_tclU8& oU8);
   virtual tVoid vVisitS8(fw_fi_tclS8& oS8);
   virtual tVoid vVisitU16(fw_fi_tclU16& oU16);
   virtual tVoid vVisitS16(fw_fi_tclS16& oS16);
   virtual tVoid vVisitU24(fw_fi_tclU24& oU24);
   virtual tVoid vVisitS24(fw_fi_tclS24& oS24);
   virtual tVoid vVisitU32(fw_fi_tclU32& oU32);
   virtual tVoid vVisitS32(fw_fi_tclS32& oS32);
   virtual tVoid vVisitU64(fw_fi_tclU64& oU64);
   virtual tVoid vVisitS64(fw_fi_tclS64& oS64);
   virtual tVoid vVisitF32(fw_fi_tclF32& oF32);
   virtual tVoid vVisitF64(fw_fi_tclF64& oF64);
   virtual tVoid vVisitBool(fw_fi_tclBool& oBool);
   virtual tVoid vVisitString(fw_fi_tclString& oString);
   virtual tVoid vVisitMultiLanguageString(fw_fi_tclMultiLanguageString& oString);

   virtual tVoid vVisitList(fw_fi_tclList& oList);
   virtual tVoid vVisit_BinContainer(fw_fi_tcl_BinContainer& oBinContainer);

   virtual tVoid vVisit_Reserved(fw_fi_tcl_Reserved& oReserved);

   virtual tVoid vVisit_u8_Percent(fw_fi_tcl_u8_Percent& ou8_Percent);

   virtual tVoid vVisit_s16_PerThousand(fw_fi_tcl_s16_PerThousand& os16_PerThousand);

   virtual tVoid vVisit_u16_IndexInReferenceList(fw_fi_tcl_u16_IndexInReferenceList& ou16_IndexInReferenceList);

   virtual tVoid vVisit_u16_ErrorCode(fw_fi_tcl_u16_ErrorCode& ou16_ErrorCode);

   virtual tVoid vVisit_s32_Kilogram(fw_fi_tcl_s32_Kilogram& os32_Kilogram);

   virtual tVoid vVisit_s32_Pound(fw_fi_tcl_s32_Pound& os32_Pound);

   virtual tVoid vVisit_s16_Meter(fw_fi_tcl_s16_Meter& os16_Meter);

   virtual tVoid vVisit_s32_Meter(fw_fi_tcl_s32_Meter& os32_Meter);

   virtual tVoid vVisit_s32_Yards(fw_fi_tcl_s32_Yards& os32_Yards);

   virtual tVoid vVisit_s32_Centimeter(fw_fi_tcl_s32_Centimeter& os32_Centimeter);

   virtual tVoid vVisit_s32_Inch(fw_fi_tcl_s32_Inch& os32_Inch);

   virtual tVoid vVisit_s32_Millimeter(fw_fi_tcl_s32_Millimeter& os32_Millimeter);

   virtual tVoid vVisit_s32_Microliter(fw_fi_tcl_s32_Microliter& os32_Microliter);

   virtual tVoid vVisit_s32_Second(fw_fi_tcl_s32_Second& os32_Second);

   virtual tVoid vVisit_u16_MilliSecond(fw_fi_tcl_u16_MilliSecond& ou16_MilliSecond);

   virtual tVoid vVisit_s32_MilliSecond(fw_fi_tcl_s32_MilliSecond& os32_MilliSecond);

   virtual tVoid vVisit_POSIXTime(fw_fi_tcl_POSIXTime& oPOSIXTime);

   virtual tVoid vVisit_e8_DST_State(fw_fi_tcl_e8_DST_State& oe8_DST_State);

   virtual tVoid vVisit_TimeZoneElement(fw_fi_tcl_TimeZoneElement& oTimeZoneElement);

   virtual tVoid vVisit_s16_KmPerHour(fw_fi_tcl_s16_KmPerHour& os16_KmPerHour);

   virtual tVoid vVisit_s16_MilesPerHour(fw_fi_tcl_s16_MilesPerHour& os16_MilesPerHour);

   virtual tVoid vVisit_s16_Kelvin(fw_fi_tcl_s16_Kelvin& os16_Kelvin);

   virtual tVoid vVisit_s32_Pascal(fw_fi_tcl_s32_Pascal& os32_Pascal);

   virtual tVoid vVisit_FIVersion(fw_fi_tcl_FIVersion& oFIVersion);

   virtual tVoid vVisit_s32_Longitude(fw_fi_tcl_s32_Longitude& os32_Longitude);

   virtual tVoid vVisit_s32_Latitude(fw_fi_tcl_s32_Latitude& os32_Latitude);

   virtual tVoid vVisit_PositionWGS84(fw_fi_tcl_PositionWGS84& oPositionWGS84);

   virtual tVoid vVisit_RectangleWGS84(fw_fi_tcl_RectangleWGS84& oRectangleWGS84);

   virtual tVoid vVisit_e16_ISOCountryCode(fw_fi_tcl_e16_ISOCountryCode& oe16_ISOCountryCode);

   virtual tVoid vVisit_e16_ISOLanguageCode(fw_fi_tcl_e16_ISOLanguageCode& oe16_ISOLanguageCode);

   virtual tVoid vVisit_LanguageID(fw_fi_tcl_LanguageID& oLanguageID);

   virtual tVoid vVisit_u8_DirectionAbsolute(fw_fi_tcl_u8_DirectionAbsolute& ou8_DirectionAbsolute);

   virtual tVoid vVisit_u8_DirectionRelative(fw_fi_tcl_u8_DirectionRelative& ou8_DirectionRelative);

   virtual tVoid vVisit_s16_CentiDegree(fw_fi_tcl_s16_CentiDegree& os16_CentiDegree);

   virtual tVoid vVisit_s16_Degree(fw_fi_tcl_s16_Degree& os16_Degree);

   virtual tVoid vVisit_u16_DirectionAbsolute_CentiDegree(fw_fi_tcl_u16_DirectionAbsolute_CentiDegree& ou16_DirectionAbsolute_CentiDegree);

   virtual tVoid vVisit_s16_DirectionRelative_CentiDegree(fw_fi_tcl_s16_DirectionRelative_CentiDegree& os16_DirectionRelative_CentiDegree);

   virtual tVoid vVisit_e8_FuelType(fw_fi_tcl_e8_FuelType& oe8_FuelType);

   virtual tVoid vVisit_ServiceRegistry(fw_fi_tcl_ServiceRegistry& oServiceRegistry);

   virtual tVoid vVisit_ServiceReference(fw_fi_tcl_ServiceReference& oServiceReference);

   virtual tVoid vVisit_ServiceRequest(fw_fi_tcl_ServiceRequest& oServiceRequest);

   virtual tVoid vVisit_ServerApplication(fw_fi_tcl_ServerApplication& oServerApplication);


 	fi_tclTraversePath<fi_tclKnot>::tclIterator oIterator;		
	
protected:
	tBool bBreakNow;
	tBool bIsVisitorValid;
private:

};

#endif
