/************************************************************************
 
 *FILE:           navifitypes.h
 
 *SW-COMPONENT:   NaviFI, Navigation Functional Interface
 
 *DESCRIPTION:    Interface fuer NachrichtenStrukturTypdefinitionen des navifi
                  
 *AUTHOR:         Jochen Bruns (CM-DI/ENS41)
 
 *COPYRIGHT:      (c) 2001 Blaupunkt GmbH
 
 *HISTORY:
           (t.b.a)
 * 
 *    Rev 1.0   Oct 7 2001 17:16:00   bnj2hi
 * Initial revision
 *  
 ************************************************************************/

#ifndef FW_AILFITYPES_HEADER
#define FW_AILFITYPES_HEADER

#include <vector>



class fw_ailfi_tclVisitorBase;

/* --NaviFI-MessageStrukturtypen --*/

// base class for all ampfi messages

class fw_ailfi_tclMsgBaseMessage : public fw_fi_tclVisitableTypeBase, public fi_tclMessageBase
{
public:
   // common functions
   virtual tU16 u16GetServiceID() const;
   virtual tU16 u16GetFunctionID() const;
   virtual tU8 u8GetOpCode() const;
   virtual const fi_tclTypeBase& corfoGetTypeBase() const;
   virtual fi_tclTypeBase& rfoGetTypeBase();

   // default implementation directly applicable to all messages without paramenters
   fw_ailfi_tclMsgBaseMessage() { };
   virtual tU32 u32GetSize(tU16 u16MajorVersion) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
};

class fw_ailfi_tclMsgServiceRegistryListGet : public fw_ailfi_tclMsgBaseMessage
{
public:

   fw_ailfi_tclMsgServiceRegistryListGet() {}

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   fw_ailfi_tclMsgServiceRegistryListGet& operator=(const fw_ailfi_tclMsgServiceRegistryListGet& coRef);
   fw_ailfi_tclMsgServiceRegistryListGet(const fw_ailfi_tclMsgServiceRegistryListGet& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY


   virtual tBool operator==(const fw_ailfi_tclMsgServiceRegistryListGet& rfoCmp) const;
   virtual tS32 s32GetTypeId() const;
};

class fw_ailfi_tclMsgServiceRegistryListStatus : public fw_ailfi_tclMsgBaseMessage
{
public:

   fw_ailfi_tclMsgServiceRegistryListStatus() {}

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   fw_ailfi_tclMsgServiceRegistryListStatus& operator=(const fw_ailfi_tclMsgServiceRegistryListStatus& coRef);
   fw_ailfi_tclMsgServiceRegistryListStatus(const fw_ailfi_tclMsgServiceRegistryListStatus& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   std::vector<fw_fi_tcl_ServiceRegistry, std::allocator<fw_fi_tcl_ServiceRegistry> > oServiceRegistryList;

   virtual tVoid vDestroy();
   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   virtual tBool operator==(const fw_ailfi_tclMsgServiceRegistryListStatus& rfoCmp) const;
   virtual tS32 s32GetTypeId() const;
};

class fw_ailfi_tclMsgServiceReferenceListGet : public fw_ailfi_tclMsgBaseMessage
{
public:

   fw_ailfi_tclMsgServiceReferenceListGet() {}

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   fw_ailfi_tclMsgServiceReferenceListGet& operator=(const fw_ailfi_tclMsgServiceReferenceListGet& coRef);
   fw_ailfi_tclMsgServiceReferenceListGet(const fw_ailfi_tclMsgServiceReferenceListGet& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY


   virtual tBool operator==(const fw_ailfi_tclMsgServiceReferenceListGet& rfoCmp) const;
   virtual tS32 s32GetTypeId() const;
};

class fw_ailfi_tclMsgServiceReferenceListStatus : public fw_ailfi_tclMsgBaseMessage
{
public:

   fw_ailfi_tclMsgServiceReferenceListStatus() {}

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   fw_ailfi_tclMsgServiceReferenceListStatus& operator=(const fw_ailfi_tclMsgServiceReferenceListStatus& coRef);
   fw_ailfi_tclMsgServiceReferenceListStatus(const fw_ailfi_tclMsgServiceReferenceListStatus& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   std::vector<fw_fi_tcl_ServiceReference, std::allocator<fw_fi_tcl_ServiceReference> > oServiceReferenceList;

   virtual tVoid vDestroy();
   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   virtual tBool operator==(const fw_ailfi_tclMsgServiceReferenceListStatus& rfoCmp) const;
   virtual tS32 s32GetTypeId() const;
};

class fw_ailfi_tclMsgServerApplicationListGet : public fw_ailfi_tclMsgBaseMessage
{
public:

   fw_ailfi_tclMsgServerApplicationListGet() {}

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   fw_ailfi_tclMsgServerApplicationListGet& operator=(const fw_ailfi_tclMsgServerApplicationListGet& coRef);
   fw_ailfi_tclMsgServerApplicationListGet(const fw_ailfi_tclMsgServerApplicationListGet& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY


   virtual tBool operator==(const fw_ailfi_tclMsgServerApplicationListGet& rfoCmp) const;
   virtual tS32 s32GetTypeId() const;
};

class fw_ailfi_tclMsgServerApplicationListStatus : public fw_ailfi_tclMsgBaseMessage
{
public:

   fw_ailfi_tclMsgServerApplicationListStatus() {}

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   fw_ailfi_tclMsgServerApplicationListStatus& operator=(const fw_ailfi_tclMsgServerApplicationListStatus& coRef);
   fw_ailfi_tclMsgServerApplicationListStatus(const fw_ailfi_tclMsgServerApplicationListStatus& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   std::vector<fw_fi_tcl_ServerApplication, std::allocator<fw_fi_tcl_ServerApplication> > oServerApplicationList;

   virtual tVoid vDestroy();
   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   virtual tBool operator==(const fw_ailfi_tclMsgServerApplicationListStatus& rfoCmp) const;
   virtual tS32 s32GetTypeId() const;
};


#endif
