/************************************************************************
 
 *FILE:           navifitypes.cpp
 
 *SW-COMPONENT:   NaviFI, Navigation Functional Interface
 
 *DESCRIPTION:    Interface fuer allgemeine Typdefinitionen des Nafi
                  
 *AUTHOR:         Jochen Bruns (CM-DI/ENS41)
 
 *COPYRIGHT:      (c) 2001 Blaupunkt GmbH
 
 ************************************************************************/

#if (defined OSAL_OS) || (defined OSAL_CONF)
#define OSAL_S_IMPORT_INTERFACE_GENERIC
#include "osal_if.h"
#else
#include "myosal.h"
#endif

#define FW_FI_S_IMPORT_INTERFACE_FW_AILFI_TYPES
#define FW_FI_S_IMPORT_INTERFACE_FW_AILFI_FUNCTIONIDS
#define FW_FI_S_IMPORT_INTERFACE_FW_AILFI_SERVICEINFO
#include "fw_fi_if.h"

#define CCA_S_IMPORT_INTERFACE_GENERIC
#include "cca_if.h"

//=============================================================================

// base class for all fw_ailfifi messages

// common functions

tU16 fw_ailfi_tclMsgBaseMessage::u16GetServiceID() const
{
   return FW_AILFI_C_U16_SERVICE_ID;
}

tU16 fw_ailfi_tclMsgBaseMessage::u16GetFunctionID() const
{
   return (tU16) ((((tU32) s32GetTypeId()) >> 16) & 0xFFFF);
}

tU8 fw_ailfi_tclMsgBaseMessage::u8GetOpCode() const 
{
   return (tU8) ((((tU32) s32GetTypeId()) >> 8) & 0xFF);
}

const fi_tclTypeBase& fw_ailfi_tclMsgBaseMessage::corfoGetTypeBase() const
{
   return *this;
}

fi_tclTypeBase& fw_ailfi_tclMsgBaseMessage::rfoGetTypeBase()
{
   return *this;
}

// default implementation directly applicable to all messages without paramenters

tU32 fw_ailfi_tclMsgBaseMessage::u32GetSize(tU16 /* u16MajorVersion */ ) const
{
   return 0;
}

fi_tclOutContext& fw_ailfi_tclMsgBaseMessage::oWrite(fi_tclOutContext& rfoOut) const
{
   return rfoOut;
}

fi_tclInContext& fw_ailfi_tclMsgBaseMessage::oRead(fi_tclInContext& rfoIn)
{
   return rfoIn;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
fw_ailfi_tclMsgServiceRegistryListGet::fw_ailfi_tclMsgServiceRegistryListGet(const fw_ailfi_tclMsgServiceRegistryListGet& coRef)
   : fw_ailfi_tclMsgBaseMessage(coRef)
{
}
fw_ailfi_tclMsgServiceRegistryListGet& fw_ailfi_tclMsgServiceRegistryListGet::operator=(const fw_ailfi_tclMsgServiceRegistryListGet& coRef)
{
   (tVoid)coRef;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

tS32 fw_ailfi_tclMsgServiceRegistryListGet::s32GetTypeId() const
{
   return (tS32) fw_ailfi_tclToken::EN_MSG_SERVICEREGISTRYLISTGET;
}

tBool fw_ailfi_tclMsgServiceRegistryListGet::operator==(const fw_ailfi_tclMsgServiceRegistryListGet& /* rfoCmp */) const
{
   tBool bResult = true;
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
fw_ailfi_tclMsgServiceRegistryListStatus::fw_ailfi_tclMsgServiceRegistryListStatus(const fw_ailfi_tclMsgServiceRegistryListStatus& coRef)
   : fw_ailfi_tclMsgBaseMessage(coRef)
{
   oServiceRegistryList = coRef.oServiceRegistryList;
}
fw_ailfi_tclMsgServiceRegistryListStatus& fw_ailfi_tclMsgServiceRegistryListStatus::operator=(const fw_ailfi_tclMsgServiceRegistryListStatus& coRef)
{
   if (this == &coRef) return *this;
   oServiceRegistryList = coRef.oServiceRegistryList;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

tS32 fw_ailfi_tclMsgServiceRegistryListStatus::s32GetTypeId() const
{
   return (tS32) fw_ailfi_tclToken::EN_MSG_SERVICEREGISTRYLISTSTATUS;
}

tVoid fw_ailfi_tclMsgServiceRegistryListStatus::vDestroy()
{
   {
      for (tU32 u32Idx = 0; u32Idx < oServiceRegistryList.size(); ++u32Idx)
         oServiceRegistryList[u32Idx].vDestroy();
   }
   oServiceRegistryList.clear();
}

tU32 fw_ailfi_tclMsgServiceRegistryListStatus::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return (tU32)(4U+oServiceRegistryList.size()*15U);
}

fi_tclInContext& fw_ailfi_tclMsgServiceRegistryListStatus::oRead(fi_tclInContext& oIn)
{
   {
      tU32 u32Length;
      tU32 u32Idx;
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
      for (u32Idx = 0; u32Idx < oServiceRegistryList.size(); ++u32Idx)
      {
         oServiceRegistryList[u32Idx].vDestroy();
      }
#endif // !VARIANT_S_FTR_ENABLE_DEEP_COPY
      (tVoid) (oIn >> u32Length);
      oServiceRegistryList.resize(u32Length);
      for (u32Idx = 0; u32Idx < u32Length; ++u32Idx)
      {
         (tVoid) (oIn >> oServiceRegistryList[u32Idx]);
      }
   }
   return oIn;
}

fi_tclOutContext& fw_ailfi_tclMsgServiceRegistryListStatus::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << (tU32)oServiceRegistryList.size());
   {
      for (tU32 u32Idx = 0; u32Idx < oServiceRegistryList.size(); ++u32Idx)
         (tVoid) (oOut << oServiceRegistryList[u32Idx]);
   }
   return oOut;
}

tBool fw_ailfi_tclMsgServiceRegistryListStatus::operator==(const fw_ailfi_tclMsgServiceRegistryListStatus& rfoCmp) const
{
   tBool bResult = true;
      bResult = bResult && (oServiceRegistryList.size() == rfoCmp.oServiceRegistryList.size());
      if (bResult)
      {
         for (tU32 u32Idx = 0; bResult && (u32Idx < oServiceRegistryList.size()); ++u32Idx)
            bResult = bResult && (oServiceRegistryList[u32Idx] == rfoCmp.oServiceRegistryList[u32Idx]);
      }
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
fw_ailfi_tclMsgServiceReferenceListGet::fw_ailfi_tclMsgServiceReferenceListGet(const fw_ailfi_tclMsgServiceReferenceListGet& coRef)
   : fw_ailfi_tclMsgBaseMessage(coRef)
{
}
fw_ailfi_tclMsgServiceReferenceListGet& fw_ailfi_tclMsgServiceReferenceListGet::operator=(const fw_ailfi_tclMsgServiceReferenceListGet& coRef)
{
   (tVoid)coRef;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

tS32 fw_ailfi_tclMsgServiceReferenceListGet::s32GetTypeId() const
{
   return (tS32) fw_ailfi_tclToken::EN_MSG_SERVICEREFERENCELISTGET;
}

tBool fw_ailfi_tclMsgServiceReferenceListGet::operator==(const fw_ailfi_tclMsgServiceReferenceListGet& /* rfoCmp */) const
{
   tBool bResult = true;
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
fw_ailfi_tclMsgServiceReferenceListStatus::fw_ailfi_tclMsgServiceReferenceListStatus(const fw_ailfi_tclMsgServiceReferenceListStatus& coRef)
   : fw_ailfi_tclMsgBaseMessage(coRef)
{
   oServiceReferenceList = coRef.oServiceReferenceList;
}
fw_ailfi_tclMsgServiceReferenceListStatus& fw_ailfi_tclMsgServiceReferenceListStatus::operator=(const fw_ailfi_tclMsgServiceReferenceListStatus& coRef)
{
   if (this == &coRef) return *this;
   oServiceReferenceList = coRef.oServiceReferenceList;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

tS32 fw_ailfi_tclMsgServiceReferenceListStatus::s32GetTypeId() const
{
   return (tS32) fw_ailfi_tclToken::EN_MSG_SERVICEREFERENCELISTSTATUS;
}

tVoid fw_ailfi_tclMsgServiceReferenceListStatus::vDestroy()
{
   {
      for (tU32 u32Idx = 0; u32Idx < oServiceReferenceList.size(); ++u32Idx)
         oServiceReferenceList[u32Idx].vDestroy();
   }
   oServiceReferenceList.clear();
}

tU32 fw_ailfi_tclMsgServiceReferenceListStatus::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return (tU32)(4U+oServiceReferenceList.size()*15U);
}

fi_tclInContext& fw_ailfi_tclMsgServiceReferenceListStatus::oRead(fi_tclInContext& oIn)
{
   {
      tU32 u32Length;
      tU32 u32Idx;
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
      for (u32Idx = 0; u32Idx < oServiceReferenceList.size(); ++u32Idx)
      {
         oServiceReferenceList[u32Idx].vDestroy();
      }
#endif // !VARIANT_S_FTR_ENABLE_DEEP_COPY
      (tVoid) (oIn >> u32Length);
      oServiceReferenceList.resize(u32Length);
      for (u32Idx = 0; u32Idx < u32Length; ++u32Idx)
      {
         (tVoid) (oIn >> oServiceReferenceList[u32Idx]);
      }
   }
   return oIn;
}

fi_tclOutContext& fw_ailfi_tclMsgServiceReferenceListStatus::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << (tU32)oServiceReferenceList.size());
   {
      for (tU32 u32Idx = 0; u32Idx < oServiceReferenceList.size(); ++u32Idx)
         (tVoid) (oOut << oServiceReferenceList[u32Idx]);
   }
   return oOut;
}

tBool fw_ailfi_tclMsgServiceReferenceListStatus::operator==(const fw_ailfi_tclMsgServiceReferenceListStatus& rfoCmp) const
{
   tBool bResult = true;
      bResult = bResult && (oServiceReferenceList.size() == rfoCmp.oServiceReferenceList.size());
      if (bResult)
      {
         for (tU32 u32Idx = 0; bResult && (u32Idx < oServiceReferenceList.size()); ++u32Idx)
            bResult = bResult && (oServiceReferenceList[u32Idx] == rfoCmp.oServiceReferenceList[u32Idx]);
      }
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
fw_ailfi_tclMsgServerApplicationListGet::fw_ailfi_tclMsgServerApplicationListGet(const fw_ailfi_tclMsgServerApplicationListGet& coRef)
   : fw_ailfi_tclMsgBaseMessage(coRef)
{
}
fw_ailfi_tclMsgServerApplicationListGet& fw_ailfi_tclMsgServerApplicationListGet::operator=(const fw_ailfi_tclMsgServerApplicationListGet& coRef)
{
   (tVoid)coRef;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

tS32 fw_ailfi_tclMsgServerApplicationListGet::s32GetTypeId() const
{
   return (tS32) fw_ailfi_tclToken::EN_MSG_SERVERAPPLICATIONLISTGET;
}

tBool fw_ailfi_tclMsgServerApplicationListGet::operator==(const fw_ailfi_tclMsgServerApplicationListGet& /* rfoCmp */) const
{
   tBool bResult = true;
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
fw_ailfi_tclMsgServerApplicationListStatus::fw_ailfi_tclMsgServerApplicationListStatus(const fw_ailfi_tclMsgServerApplicationListStatus& coRef)
   : fw_ailfi_tclMsgBaseMessage(coRef)
{
   oServerApplicationList = coRef.oServerApplicationList;
}
fw_ailfi_tclMsgServerApplicationListStatus& fw_ailfi_tclMsgServerApplicationListStatus::operator=(const fw_ailfi_tclMsgServerApplicationListStatus& coRef)
{
   if (this == &coRef) return *this;
   oServerApplicationList = coRef.oServerApplicationList;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

tS32 fw_ailfi_tclMsgServerApplicationListStatus::s32GetTypeId() const
{
   return (tS32) fw_ailfi_tclToken::EN_MSG_SERVERAPPLICATIONLISTSTATUS;
}

tVoid fw_ailfi_tclMsgServerApplicationListStatus::vDestroy()
{
   {
      for (tU32 u32Idx = 0; u32Idx < oServerApplicationList.size(); ++u32Idx)
         oServerApplicationList[u32Idx].vDestroy();
   }
   oServerApplicationList.clear();
}

tU32 fw_ailfi_tclMsgServerApplicationListStatus::u32GetSize(tU16 u16MajorVersion) const
{
   tU32 u32DynamicSize = 0;
   tU32 u32ListIdx;
   for (u32ListIdx = 0; u32ListIdx < oServerApplicationList.size(); ++u32ListIdx)
      u32DynamicSize += oServerApplicationList[u32ListIdx].u32GetSize(u16MajorVersion);
   return u32DynamicSize+4;
}

fi_tclInContext& fw_ailfi_tclMsgServerApplicationListStatus::oRead(fi_tclInContext& oIn)
{
   {
      tU32 u32Length;
      tU32 u32Idx;
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
      for (u32Idx = 0; u32Idx < oServerApplicationList.size(); ++u32Idx)
      {
         oServerApplicationList[u32Idx].vDestroy();
      }
#endif // !VARIANT_S_FTR_ENABLE_DEEP_COPY
      (tVoid) (oIn >> u32Length);
      oServerApplicationList.resize(u32Length);
      for (u32Idx = 0; u32Idx < u32Length; ++u32Idx)
      {
         (tVoid) (oIn >> oServerApplicationList[u32Idx]);
      }
   }
   return oIn;
}

fi_tclOutContext& fw_ailfi_tclMsgServerApplicationListStatus::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << (tU32)oServerApplicationList.size());
   {
      for (tU32 u32Idx = 0; u32Idx < oServerApplicationList.size(); ++u32Idx)
         (tVoid) (oOut << oServerApplicationList[u32Idx]);
   }
   return oOut;
}

tBool fw_ailfi_tclMsgServerApplicationListStatus::operator==(const fw_ailfi_tclMsgServerApplicationListStatus& rfoCmp) const
{
   tBool bResult = true;
      bResult = bResult && (oServerApplicationList.size() == rfoCmp.oServerApplicationList.size());
      if (bResult)
      {
         for (tU32 u32Idx = 0; bResult && (u32Idx < oServerApplicationList.size()); ++u32Idx)
            bResult = bResult && (oServerApplicationList[u32Idx] == rfoCmp.oServerApplicationList[u32Idx]);
      }
   return bResult;
}

