#ifndef FW_AILFILANGUAGE_HEADER
#define FW_AILFILANGUAGE_HEADER

class fw_ailfi_tclInContext;
class fw_ailfi_tclOutContext;
class fw_ailfi_tclVisitorBase;

class MY_DECL fw_ailfi_tclDescription {
 public:
  enum tenType { EN_PARSING, EN_GENERATING };	
  
  fw_ailfi_tclDescription(fi_tclInContext* poIn, fw_ailfi_tclVisitorBase* poVisit);
  fw_ailfi_tclDescription(fi_tclOutContext* poOut, fw_ailfi_tclVisitorBase* poVisit);
  
  /* --Hier kommen nun die Methoden, die einzelne Nachrichten entspr. NaFI 
		erzeugen (EN_GENERATING) bzw. einlesen (EN_PARSING). */

  tBool bInitMessage(fw_ailfi_tclToken::tenType enMsgToken);
  tBool bProcessMessage();

  // tBool bProcessElement(); 

 public:
  tBool bDoIt(fw_fi_tclVisitableTypeBase& poBaseType);
#ifndef FI_S_EXTERNAL_FI
  void vEnableSpecialBinContainer() { bUseSpecialBinContainer = true; }
#endif
 private:
  tenType enType; //--Lesen oder Schreiben?

  union {
    fi_tclInContext* poInContext;
    fi_tclOutContext* poOutContext;
  };

  fw_ailfi_tclVisitorBase* poVisitor;

  // typedef navifi_tclTraversePath::tclKnot tclKnot;

  tBool bUseSpecialBinContainer;  
  
 public:
  
  // --Traversierungspfad
  fi_tclTraversePath<fw_ailfi_tclKnot> oPath;
  //   navifi_tclTraversePath oPath;
  fi_tclTraversePath<fw_ailfi_tclKnot> oCallStack;
   //  navifi_tclTraversePath oCallStack;
  
};

// --Inline-Implementierungen
inline fw_ailfi_tclDescription::fw_ailfi_tclDescription(fi_tclInContext* poIn, fw_ailfi_tclVisitorBase* poVisit):
  enType(EN_PARSING),poInContext(poIn),poVisitor(poVisit),bUseSpecialBinContainer(false) {}

inline fw_ailfi_tclDescription::fw_ailfi_tclDescription(fi_tclOutContext* poOut, fw_ailfi_tclVisitorBase* poVisit):
  enType(EN_GENERATING),poOutContext(poOut),poVisitor(poVisit),bUseSpecialBinContainer(false) {}

#endif

