#if (defined OSAL_OS) || (defined OSAL_CONF)
#define OSAL_S_IMPORT_INTERFACE_GENERIC
#include "osal_if.h"
#else
#include "myosal.h"
#endif

#define FW_FI_S_IMPORT_INTERFACE_FW_AILFI_STDVISITORS
#include "fw_fi_if.h"

tBool fw_ailfi_tclDescription::bInitMessage(fw_ailfi_tclToken::tenType enMsgToken) {
   tBool bResult = TRUE;
   switch (enMsgToken) {
   case fw_ailfi_tclToken::EN_LAST_TOKEN:
   case fw_ailfi_tclToken::EN_LIST:
   case fw_ailfi_tclToken::EN_END_OF_STRUCT:
   case fw_ailfi_tclToken::EN_UNKNOWN:
      bResult=FALSE;   
      break;

   // include the expansions for the messages
   case fw_ailfi_tclToken::EN_MSG_SERVICEREGISTRYLISTSTATUS:
   {
      bResult = bResult && oPath.bGoDown(fw_ailfi_tclKnot(fw_ailfi_tclToken::EN_SERVICEREGISTRY,fw_ailfi_tclSemanticDomain::EN_LIST_ELEMENT,0));
      bResult = bResult && oPath.bGoDown(fw_ailfi_tclKnot(fw_ailfi_tclToken::EN_LIST,fw_ailfi_tclSemanticDomain::EN_MSG_OSERVICEREGISTRYLIST));
   } break;
   case fw_ailfi_tclToken::EN_MSG_SERVICEREFERENCELISTSTATUS:
   {
      bResult = bResult && oPath.bGoDown(fw_ailfi_tclKnot(fw_ailfi_tclToken::EN_SERVICEREFERENCE,fw_ailfi_tclSemanticDomain::EN_LIST_ELEMENT,0));
      bResult = bResult && oPath.bGoDown(fw_ailfi_tclKnot(fw_ailfi_tclToken::EN_LIST,fw_ailfi_tclSemanticDomain::EN_MSG_OSERVICEREFERENCELIST));
   } break;
   case fw_ailfi_tclToken::EN_MSG_SERVERAPPLICATIONLISTSTATUS:
   {
      bResult = bResult && oPath.bGoDown(fw_ailfi_tclKnot(fw_ailfi_tclToken::EN_SERVERAPPLICATION,fw_ailfi_tclSemanticDomain::EN_LIST_ELEMENT,0));
      bResult = bResult && oPath.bGoDown(fw_ailfi_tclKnot(fw_ailfi_tclToken::EN_LIST,fw_ailfi_tclSemanticDomain::EN_MSG_OSERVERAPPLICATIONLIST));
   } break;
   case fw_ailfi_tclToken::EN_MSG_SERVICEREGISTRYLISTGET:
   case fw_ailfi_tclToken::EN_MSG_SERVICEREFERENCELISTGET:
   case fw_ailfi_tclToken::EN_MSG_SERVERAPPLICATIONLISTGET:
   case fw_ailfi_tclToken::EN_BINCONTAINER:
   case fw_ailfi_tclToken::EN_SERVICEREGISTRY:
   case fw_ailfi_tclToken::EN_SERVICEREFERENCE:
   case fw_ailfi_tclToken::EN_SERVICEREQUEST:
   case fw_ailfi_tclToken::EN_SERVERAPPLICATION:
   case fw_ailfi_tclToken::EN_U8:   
   case fw_ailfi_tclToken::EN_S8:   
   case fw_ailfi_tclToken::EN_U16:   
   case fw_ailfi_tclToken::EN_S16:   
   case fw_ailfi_tclToken::EN_U24:   
   case fw_ailfi_tclToken::EN_S24:   
   case fw_ailfi_tclToken::EN_U32:   
   case fw_ailfi_tclToken::EN_S32:   
   case fw_ailfi_tclToken::EN_U64:   
   case fw_ailfi_tclToken::EN_S64:   
   case fw_ailfi_tclToken::EN_F32:   
   case fw_ailfi_tclToken::EN_F64:   
   case fw_ailfi_tclToken::EN_BOOL:   
   case fw_ailfi_tclToken::EN_STRING:   
   case fw_ailfi_tclToken::EN_MULTILANGUAGESTRING:   
   default:
      (tVoid) oPath.bGoDown(fw_ailfi_tclKnot(enMsgToken,fw_ailfi_tclSemanticDomain::EN_UNKNOWN));
      bResult = TRUE;
   }	
   return bResult;
}

tBool fw_ailfi_tclDescription::bDoIt(fw_fi_tclVisitableTypeBase& oTypeBase)
{
   // --Lesen oder Schreiben?
   if (enType==EN_PARSING)
   {
     // --Erst einlesen, dann Besucher bergeben.
     (tVoid) ((*poInContext) >> oTypeBase);
     oTypeBase.vTakeVisitor(*poVisitor);
   }
   else
   {
     // --Erst Besucher bergeben, dann ausgeben
	 oTypeBase.vTakeVisitor(*poVisitor);
     (tVoid) ((*poOutContext) << oTypeBase);
   }
   return poVisitor->bIsValid();
}

tBool fw_ailfi_tclDescription::bProcessMessage() {
   tBool bResult = TRUE;
   tU16 u16MajorVersion;
   if (enType == EN_GENERATING)
   {
      u16MajorVersion = poOutContext->u16GetMajorVersion();
   }
   else
   {
      u16MajorVersion = poInContext->u16GetMajorVersion();
   }
   if (u16MajorVersion > 0x8000)
   {
      return FALSE;
   }
   tU16 u16SavedMajorVersion = u16MajorVersion;
   poVisitor->vReleaseBreak();
   while ((oPath.u32Position>0) && 
      bResult &&
      !poVisitor->bBreak() )    {
      // get current context (name, type, list index of next element)
      fw_ailfi_tclKnot oKnot = oPath.oGetIterator().oKnot();
      fw_ailfi_tclSemanticDomain::tenType enSemanticDomain = oKnot.enSemanticDomain;
      fw_ailfi_tclToken::tenType enToken = oKnot.enToken;
      tU32 u32Index = oKnot.u32Index;
      
      // lists need special handling
      if (enSemanticDomain == fw_ailfi_tclSemanticDomain::EN_LIST_ELEMENT) {
         (tVoid) oPath.bGoUp();
         // has list remaining elements?
         if (u32Index < oPath.oGetIterator().oKnot().u32Index) {
            // create next list element
            (tVoid) oPath.bGoDown(fw_ailfi_tclKnot(enToken,enSemanticDomain,u32Index+1));
            (tVoid) oPath.bGoDown(fw_ailfi_tclKnot(enToken,enSemanticDomain,u32Index));
         } else {
            // remove list, clean up
            (tVoid) oPath.bGoUp();
            (tVoid) oCallStack.bGoUp();
            continue;	
         }
      }
      // push current context on stack for visitor
      (tVoid) oCallStack.bGoDown(fw_ailfi_tclKnot(enToken,enSemanticDomain,u32Index));
      poVisitor->oIterator=oCallStack.oGetIterator();
      
      // now, process element
      switch (enToken) {
      case fw_ailfi_tclToken::EN_END_OF_STRUCT: 
      {
         // clean up after structures
         if (enSemanticDomain == fw_ailfi_tclSemanticDomain::EN_BINCONTAINER)
         {
            u16MajorVersion = u16SavedMajorVersion;
            if (enType == EN_GENERATING)
            {
               (tVoid) poOutContext->u16SetMajorVersion(u16MajorVersion);
            }
            else
            {
               (tVoid) poInContext->u16SetMajorVersion(u16MajorVersion);
            }
         }
         (tVoid) oPath.bGoUp();
         (tVoid) oCallStack.bGoUp();
         (tVoid) oCallStack.bGoUp();
      } break;
      case fw_ailfi_tclToken::EN_LIST: 
      {
         fw_fi_tclList oList;
         // get list size
         if (!bDoIt(oList)) {
            // rearrange LIST and LIST_ELEMENT knots
            // pop "old" LIST knot
            (tVoid) oPath.bGoUp();
            // pop and backup LIST_ELEMENT knot
            fw_ailfi_tclKnot saveKnot;
            (tVoid) oPath.bGoUp(saveKnot);
            // push LIST knot
            (tVoid) oPath.bGoDown(fw_ailfi_tclKnot(enToken,enSemanticDomain,oList.u32ListSize));
            // push LIST_ELEMENT knot
            (tVoid) oPath.bGoDown(saveKnot);
            return FALSE;
         } else {
            // rearrange LIST and LIST_ELEMENT knots
            // pop "old" LIST knot
            (tVoid) oPath.bGoUp();
            // pop and backup LIST_ELEMENT knot
            fw_ailfi_tclKnot saveKnot;
            (tVoid) oPath.bGoUp(saveKnot);
            // push LIST knot
            (tVoid) oPath.bGoDown(fw_ailfi_tclKnot(enToken,enSemanticDomain,oList.u32ListSize));
            // push LIST_ELEMENT knot
            (tVoid) oPath.bGoDown(saveKnot);
         }
      } break;
      case fw_ailfi_tclToken::EN_U8: 
      {
         fw_fi_tclU8 oU8;
         if (!bDoIt(oU8))
            return FALSE;
         (tVoid) oCallStack.bGoUp();
         (tVoid) oPath.bGoUp();
         /* Commented below code because this can never be reached due to above assignment of "bInsideBinContainerVersion = false;" in line 87. */
         /* Added by KSM2HI at 24.01.2017 due to Coverity report. */
         /*
         if (bInsideBinContainerVersion)
         {
            bInsideBinContainerVersion = false;
            u16SavedMajorVersion = u16MajorVersion;
            u16MajorVersion = oU8.u8Value;
            if (enType == EN_GENERATING)
            {
               (tVoid) poOutContext->u16SetMajorVersion(u16MajorVersion);
            }
            else
            {
               (tVoid) poInContext->u16SetMajorVersion(u16MajorVersion);
            }
         }
         */ 
      } break;
      case fw_ailfi_tclToken::EN_U16: 
      {
         fw_fi_tclU16 oU16;
         if (!bDoIt(oU16))
            return FALSE;
         (tVoid) oCallStack.bGoUp();
         (tVoid) oPath.bGoUp();
      } break;
      case fw_ailfi_tclToken::EN_U24: 
      {
         fw_fi_tclU24 oU24;
         if (!bDoIt(oU24))
            return FALSE;
         (tVoid) oCallStack.bGoUp();
         (tVoid) oPath.bGoUp();
      } break;
      case fw_ailfi_tclToken::EN_U32: 
      {
         fw_fi_tclU32 oU32;
         if (!bDoIt(oU32))
            return FALSE;
         (tVoid) oCallStack.bGoUp();
         (tVoid) oPath.bGoUp();
      } break;
      case fw_ailfi_tclToken::EN_U64: 
      {
         fw_fi_tclU64 oU64;
         if (!bDoIt(oU64))
            return FALSE;
         (tVoid) oCallStack.bGoUp();
         (tVoid) oPath.bGoUp();
      } break;
      case fw_ailfi_tclToken::EN_S8: 
      {
         fw_fi_tclS8 oS8;
         if (!bDoIt(oS8))
            return FALSE;
         (tVoid) oCallStack.bGoUp();
         (tVoid) oPath.bGoUp();
      } break;
      case fw_ailfi_tclToken::EN_S16: 
      {
         fw_fi_tclS16 oS16;
         if (!bDoIt(oS16))
            return FALSE;
         (tVoid) oCallStack.bGoUp();
         (tVoid) oPath.bGoUp();
      } break;
      case fw_ailfi_tclToken::EN_S24: 
      {
         fw_fi_tclS24 oS24;
         if (!bDoIt(oS24))
            return FALSE;
         (tVoid) oCallStack.bGoUp();
         (tVoid) oPath.bGoUp();
      } break;
      case fw_ailfi_tclToken::EN_S32: 
      {
         fw_fi_tclS32 oS32;
         if (!bDoIt(oS32))
            return FALSE;
         (tVoid) oCallStack.bGoUp();
         (tVoid) oPath.bGoUp();
      } break;
      case fw_ailfi_tclToken::EN_S64: 
      {
         fw_fi_tclS64 oS64;
         if (!bDoIt(oS64))
            return FALSE;
         (tVoid) oCallStack.bGoUp();
         (tVoid) oPath.bGoUp();
      } break;
      case fw_ailfi_tclToken::EN_F32: 
      {
         fw_fi_tclF32 oF32;
         if (!bDoIt(oF32))
            return FALSE;
         (tVoid) oCallStack.bGoUp();
         (tVoid) oPath.bGoUp();
      } break;
      case fw_ailfi_tclToken::EN_F64: 
      {
         fw_fi_tclF64 oF64;
         if (!bDoIt(oF64))
            return FALSE;
         (tVoid) oCallStack.bGoUp();
         (tVoid) oPath.bGoUp();
      } break;
      case fw_ailfi_tclToken::EN_BOOL: 
      {
         fw_fi_tclBool oBool;
         if (!bDoIt(oBool))
            return FALSE;
         (tVoid) oCallStack.bGoUp();
         (tVoid) oPath.bGoUp();
      } break;
      case fw_ailfi_tclToken::EN_STRING: 
      {
         fw_fi_tclString oString;
         if (!bDoIt(oString)) {
            oString.vDestroy();
            return FALSE;
         }
         oString.vDestroy();
         (tVoid) oCallStack.bGoUp();
         (tVoid) oPath.bGoUp();
      } break;
      case fw_ailfi_tclToken::EN_MULTILANGUAGESTRING: 
      {
         fw_fi_tclMultiLanguageString oString;
         if (!bDoIt(oString)) {
            oString.vDestroy();
            return FALSE;
         }
         oString.vDestroy();
         (tVoid) oCallStack.bGoUp();
         (tVoid) oPath.bGoUp();
      } break;
      // include rest of type expansions/processing
      case fw_ailfi_tclToken::EN_MSG_SERVICEREGISTRYLISTGET:
      case fw_ailfi_tclToken::EN_MSG_SERVICEREGISTRYLISTSTATUS:
      case fw_ailfi_tclToken::EN_MSG_SERVICEREFERENCELISTGET:
      case fw_ailfi_tclToken::EN_MSG_SERVICEREFERENCELISTSTATUS:
      case fw_ailfi_tclToken::EN_MSG_SERVERAPPLICATIONLISTGET:
      case fw_ailfi_tclToken::EN_MSG_SERVERAPPLICATIONLISTSTATUS:
         (tVoid) bInitMessage(enToken);
         break;
      case fw_ailfi_tclToken::EN_BINCONTAINER:
      {
      if (poVisitor->bDoExpand_BinContainer(enSemanticDomain))
      {
         (tVoid) oPath.bGoUp();
         (tVoid) oPath.bGoDown(fw_ailfi_tclKnot(fw_ailfi_tclToken::EN_END_OF_STRUCT,fw_ailfi_tclSemanticDomain::EN_UNKNOWN));
         (tVoid) oPath.bGoDown(fw_ailfi_tclKnot(fw_ailfi_tclToken::EN_U8,fw_ailfi_tclSemanticDomain::EN_LIST_ELEMENT,0));
         (tVoid) oPath.bGoDown(fw_ailfi_tclKnot(fw_ailfi_tclToken::EN_LIST,fw_ailfi_tclSemanticDomain::EN_CONTAINERDATALIST));
      }
      else
      {
         fw_fi_tcl_BinContainer o_BinContainer;
         if (!bDoIt(o_BinContainer))
         {
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
            o_BinContainer.vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
            return FALSE;
         }
         else
         {
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
            o_BinContainer.vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
            (tVoid) oCallStack.bGoUp();
            (tVoid) oPath.bGoUp();
         }
      }
      } break;
      case fw_ailfi_tclToken::EN_SERVICEREGISTRY:
      {
      if (poVisitor->bDoExpand_ServiceRegistry(enSemanticDomain))
      {
         (tVoid) oPath.bGoUp();
         (tVoid) oPath.bGoDown(fw_ailfi_tclKnot(fw_ailfi_tclToken::EN_END_OF_STRUCT,fw_ailfi_tclSemanticDomain::EN_UNKNOWN));
         (tVoid) oPath.bGoDown(fw_ailfi_tclKnot(fw_ailfi_tclToken::EN_U16,fw_ailfi_tclSemanticDomain::EN_U16PATCHVERSION));
         (tVoid) oPath.bGoDown(fw_ailfi_tclKnot(fw_ailfi_tclToken::EN_U16,fw_ailfi_tclSemanticDomain::EN_U16MINORVERSION));
         (tVoid) oPath.bGoDown(fw_ailfi_tclKnot(fw_ailfi_tclToken::EN_U16,fw_ailfi_tclSemanticDomain::EN_U16MAJORVERSION));
         (tVoid) oPath.bGoDown(fw_ailfi_tclKnot(fw_ailfi_tclToken::EN_U8,fw_ailfi_tclSemanticDomain::EN_U8SERVICESTATE));
         (tVoid) oPath.bGoDown(fw_ailfi_tclKnot(fw_ailfi_tclToken::EN_U16,fw_ailfi_tclSemanticDomain::EN_U16CLIENTSUBID));
         (tVoid) oPath.bGoDown(fw_ailfi_tclKnot(fw_ailfi_tclToken::EN_U16,fw_ailfi_tclSemanticDomain::EN_U16CLIENTAPPID));
         (tVoid) oPath.bGoDown(fw_ailfi_tclKnot(fw_ailfi_tclToken::EN_U16,fw_ailfi_tclSemanticDomain::EN_U16SERVICEID));
         (tVoid) oPath.bGoDown(fw_ailfi_tclKnot(fw_ailfi_tclToken::EN_U16,fw_ailfi_tclSemanticDomain::EN_U16REGISTERID));
      }
      else
      {
         fw_fi_tcl_ServiceRegistry o_ServiceRegistry;
         if (!bDoIt(o_ServiceRegistry))
         {
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
            o_ServiceRegistry.vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
            return FALSE;
         }
         else
         {
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
            o_ServiceRegistry.vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
            (tVoid) oCallStack.bGoUp();
            (tVoid) oPath.bGoUp();
         }
      }
      } break;
      case fw_ailfi_tclToken::EN_SERVICEREFERENCE:
      {
      if (poVisitor->bDoExpand_ServiceReference(enSemanticDomain))
      {
         (tVoid) oPath.bGoUp();
         (tVoid) oPath.bGoDown(fw_ailfi_tclKnot(fw_ailfi_tclToken::EN_END_OF_STRUCT,fw_ailfi_tclSemanticDomain::EN_UNKNOWN));
         (tVoid) oPath.bGoDown(fw_ailfi_tclKnot(fw_ailfi_tclToken::EN_U16,fw_ailfi_tclSemanticDomain::EN_U16PATCHVERSION));
         (tVoid) oPath.bGoDown(fw_ailfi_tclKnot(fw_ailfi_tclToken::EN_U16,fw_ailfi_tclSemanticDomain::EN_U16MINORVERSION));
         (tVoid) oPath.bGoDown(fw_ailfi_tclKnot(fw_ailfi_tclToken::EN_U16,fw_ailfi_tclSemanticDomain::EN_U16MAJORVERSION));
         (tVoid) oPath.bGoDown(fw_ailfi_tclKnot(fw_ailfi_tclToken::EN_U8,fw_ailfi_tclSemanticDomain::EN_U8SERVICESTATE));
         (tVoid) oPath.bGoDown(fw_ailfi_tclKnot(fw_ailfi_tclToken::EN_U16,fw_ailfi_tclSemanticDomain::EN_U16SERVERSUBID));
         (tVoid) oPath.bGoDown(fw_ailfi_tclKnot(fw_ailfi_tclToken::EN_U16,fw_ailfi_tclSemanticDomain::EN_U16SERVERAPPID));
         (tVoid) oPath.bGoDown(fw_ailfi_tclKnot(fw_ailfi_tclToken::EN_U16,fw_ailfi_tclSemanticDomain::EN_U16SERVICEID));
         (tVoid) oPath.bGoDown(fw_ailfi_tclKnot(fw_ailfi_tclToken::EN_U16,fw_ailfi_tclSemanticDomain::EN_U16REGISTERID));
      }
      else
      {
         fw_fi_tcl_ServiceReference o_ServiceReference;
         if (!bDoIt(o_ServiceReference))
         {
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
            o_ServiceReference.vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
            return FALSE;
         }
         else
         {
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
            o_ServiceReference.vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
            (tVoid) oCallStack.bGoUp();
            (tVoid) oPath.bGoUp();
         }
      }
      } break;
      case fw_ailfi_tclToken::EN_SERVICEREQUEST:
      {
      if (poVisitor->bDoExpand_ServiceRequest(enSemanticDomain))
      {
         (tVoid) oPath.bGoUp();
         (tVoid) oPath.bGoDown(fw_ailfi_tclKnot(fw_ailfi_tclToken::EN_END_OF_STRUCT,fw_ailfi_tclSemanticDomain::EN_UNKNOWN));
         (tVoid) oPath.bGoDown(fw_ailfi_tclKnot(fw_ailfi_tclToken::EN_U16,fw_ailfi_tclSemanticDomain::EN_U16SERVICEMINORVERSION));
         (tVoid) oPath.bGoDown(fw_ailfi_tclKnot(fw_ailfi_tclToken::EN_U16,fw_ailfi_tclSemanticDomain::EN_U16SERVICEMAJORVERSION));
         (tVoid) oPath.bGoDown(fw_ailfi_tclKnot(fw_ailfi_tclToken::EN_U16,fw_ailfi_tclSemanticDomain::EN_U16CLIENTSUBID));
      }
      else
      {
         fw_fi_tcl_ServiceRequest o_ServiceRequest;
         if (!bDoIt(o_ServiceRequest))
         {
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
            o_ServiceRequest.vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
            return FALSE;
         }
         else
         {
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
            o_ServiceRequest.vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
            (tVoid) oCallStack.bGoUp();
            (tVoid) oPath.bGoUp();
         }
      }
      } break;
      case fw_ailfi_tclToken::EN_SERVERAPPLICATION:
      {
      if (poVisitor->bDoExpand_ServerApplication(enSemanticDomain))
      {
         (tVoid) oPath.bGoUp();
         (tVoid) oPath.bGoDown(fw_ailfi_tclKnot(fw_ailfi_tclToken::EN_END_OF_STRUCT,fw_ailfi_tclSemanticDomain::EN_UNKNOWN));
         (tVoid) oPath.bGoDown(fw_ailfi_tclKnot(fw_ailfi_tclToken::EN_SERVICEREQUEST,fw_ailfi_tclSemanticDomain::EN_LIST_ELEMENT,0));
         (tVoid) oPath.bGoDown(fw_ailfi_tclKnot(fw_ailfi_tclToken::EN_LIST,fw_ailfi_tclSemanticDomain::EN_OSERVICEREQUESTLIST));
         (tVoid) oPath.bGoDown(fw_ailfi_tclKnot(fw_ailfi_tclToken::EN_U8,fw_ailfi_tclSemanticDomain::EN_U8SERVERAPPSTATE));
         (tVoid) oPath.bGoDown(fw_ailfi_tclKnot(fw_ailfi_tclToken::EN_BOOL,fw_ailfi_tclSemanticDomain::EN_BDEDICATEDSERVER));
         (tVoid) oPath.bGoDown(fw_ailfi_tclKnot(fw_ailfi_tclToken::EN_U16,fw_ailfi_tclSemanticDomain::EN_U16SERVICEID));
         (tVoid) oPath.bGoDown(fw_ailfi_tclKnot(fw_ailfi_tclToken::EN_U16,fw_ailfi_tclSemanticDomain::EN_U16APPID));
      }
      else
      {
         fw_fi_tcl_ServerApplication o_ServerApplication;
         if (!bDoIt(o_ServerApplication))
         {
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
            o_ServerApplication.vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
            return FALSE;
         }
         else
         {
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
            o_ServerApplication.vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
            (tVoid) oCallStack.bGoUp();
            (tVoid) oPath.bGoUp();
         }
      }
      } break;
      case fw_ailfi_tclToken::EN_UNKNOWN:
      case fw_ailfi_tclToken::EN_LAST_TOKEN:         
      default:
         return FALSE;
      }
   }
   return bResult;
}

