#ifndef ERR_ERRMEMBASE_HEADER
#define ERR_ERRMEMBASE_HEADER
/******************************************************************************

  FILE:           ErrMemBase.h
 
  SW-COMPONENT:   err
  
  AUTHOR:         CM-DI/ESP4 Wiedemann

  COPYRIGHT:      (c) 2006 Blaupunkt GmbH

******************************************************************************/

// virtual base class for error memory access
class err_tclErrMemBase
{
public:
   /*---------------------------------------------------------------------*//**
    * destructor just to make it virtual
    * 
    * @author  CM-DI/ESP4 Wiedemann
    * @date    20.01.2006
    *//*---------------------------------------------------------------------*/ 
   virtual ~err_tclErrMemBase() {};

   /*---------------------------------------------------------------------*//**
    * writes a new entry to the error memory. use this method if you have an
    * additional error string
    *
    * @param enErrType            type of error (info or normal)
    * @param u16TraceComp         trace comp identifier 
    * @param u8SpecificErrorCode  component specific error code
    * @param pcErrorText          null terminated error string
    * 
    * @return OSAL_OK or OSAL_ERROR
    *
    * @author  CM-DI/ESP4-Wiedemann
    * @date    20.01.2005
    *//*---------------------------------------------------------------------*/
   tS32 s32WriteErrorString(tenErrmemEntryType enErrType, 
                            tU16 u16TraceComp, tU8 u8SpecificErrorCode, 
                            const tChar* pcErrorText) const;

   /*---------------------------------------------------------------------*//**
    * writes a new entry to the error memory. use this method if you have 
    * a binary data stream as additional data or no additional data at all
    *
    * @param enErrType            type of error (info or normal)
    * @param u16TraceCom          trace comp identifier 
    * @param u8SpecificErrorCode  component specific error code
    * @param pu8Data              pointer to additional error data 
    *                             or NULL (optional)
    * @param u16DataSize          size of data where pu8Data points to 
    *                             or 0 (optional)
    * 
    * @return OSAL_OK or OSAL_ERROR
    *
    * @author  CM-DI/ESP4-Wiedemann
    * @date    20.01.2005
    *//*---------------------------------------------------------------------*/
   tS32 s32WriteError(tenErrmemEntryType enErrType, 
                      tU16 u16TraceComp, tU8 u8SpecificErrorCode, 
                      const tU8* pu8Data=NULL, 
                      tU16 u16DataSize=0) const;

   /*---------------------------------------------------------------------*//**
    * determines whether an error memory is available
    *
    * @return  TRUE or FALSE
    *
    * @author  CM-DI/ESP4-Wiedemann
    * @date    20.01.2005
    *//*---------------------------------------------------------------------*/
   tBool bIsActive() const {return ((OSAL_tIODescriptor)OSAL_C_INVALID_HANDLE != hErrmemDevice);};

   /*---------------------------------------------------------------------*//**
    * combines trace comp identifier with specific error code to get the 
    * error code for the error memory
    *
    * @param u16TraceComp             trace comp identifier 
    * @param u8CompSpecificErrorCode  component specific error code
    * 
    * @return error code (combination of trace comp 
    *         identifier and specific error code)
    *
    * @author  CM-DI/ESP4-Wiedemann
    * @date    20.01.2005
    *//*---------------------------------------------------------------------*/
   static tU16 u16GetErrorCode(tU16 u16TraceComp, tU8 u8CompSpecificErrorCode);

protected:
   //-- handle for error memory device
   OSAL_tIODescriptor hErrmemDevice; 

   //-- internal method to write the error memory
   tS32 s32IntWriteError(tenErrmemEntryType enErrType, 
                         tU16 u16ErrorCode, 
                         const tU8* pu8Data, 
                         tU16 u16DataSize) const;

   //-- this method writes the error struct to the error device
   virtual tS32 s32IntWriteError(trErrmemEntry& rfError) const;

   //-- getter for device handle
   OSAL_tIODescriptor hGetErrmemDevice() const {return hErrmemDevice;};

   //-- method to delimit the given data size 
   tU16 u16DelimitSize(tU16 u16DataSize) const;

   //-- delimited copy for error data
   tU16 u16FillData(tU8* pu8Dest, const tU8* pu8Source, tU16 u16Length) const;

   //-- fills the current osal time into the given time structure
   void vFillTime(OSAL_trTimeDate& rfoTimeDate) const;

   //-- fills the error structure
   tU16 u16FillErrorStruct(trErrmemEntry& rfrError, 
                           tenErrmemEntryType enErrType, 
                           tU16 u16ErrorCode, 
                           const tU8* pu8Data, 
                           tU16 u16DataSize) const;

   //-- opens the error device
   void vOpenDevice();

   //-- closes the error device
   void vCloseDevice();

   //-- default constructor to prevent instantiation of this base class
   err_tclErrMemBase()
      : hErrmemDevice((OSAL_tIODescriptor)OSAL_C_INVALID_HANDLE)
   {};
};

#endif // ERR_ERRMEMBASE_HEADER


