#ifndef ERR_HEADER
#define ERR_HEADER

// --Assert
#ifdef ERR_S_NDEBUG
#define ERR_M_ASSERT(Expression) \
   /*lint -save -e506 -e774 */ \
   if(!(Expression)) {/* do nothing but avoid lint w529... */} \
   /*lint -restore */
#else
#define ERR_M_ASSERT(Expression) \
             if(!(Expression)) err_vTraceAssertion(#Expression, __FILE__, __LINE__); \
             OSAL_vAssert(Expression)
#endif

/* --Error Handling

	The following file contains a C- and  a C++-interface for handling
	with error codes. The user should use the macro ERR_M_SET_ERROR
	(C) or ERR_M_SET_ERRORHANDLER resp. ERR_M_SET_ERRORHANDLER2 (C++)
	in order to set the error code (see below).

	The definition of error codes is not the intention of this file!

	*/

#define ERR_U32_C_BITS_NUMBER	         ((tU32)0x0000ffff)
#define ERR_U32_C_BITS_LEVEL		      (((tU32)0x003f) << 16)	
#define ERR_U32_C_BITS_GROUP	         (((tU32)0x00ff) << 22)
#define ERR_U32_C_BITS_ROOT		      (((tU32)0x0003) << 30)
#define ERR_U32_C_BITS_CODE		      (~ERR_U32_C_BITS_ROOT)

#define ERR_U32_C_BITS_LEVEL_ERROR		(((tU32)0x0003) << 16)
#define ERR_U32_C_BITS_LEVEL_WARNING	(((tU32)0x0002) << 16)
#define ERR_U32_C_BITS_LEVEL_INFO		(((tU32)0x0001) << 16)

#define ERR_U32_C_BITS_ROOT_ROOT			(((tU32)0x0002) << 30)
#define ERR_U32_C_BITS_ROOT_SUCCESSION	(((tU32)0x0001) << 30)

/* --C-Interface. */

#ifdef __cplusplus
extern "C" {
#endif

tVoid err_vTraceAssertion(tCString coszExpression, tCString coszFile, tU32 u32Line);

/* --err_vSetError()
	This function sets the error code with additional error, linenumber and file
	information. The user should use the macro below to simplify the setting of
	the line and file info. */
tVoid err_vSetError(tU32 u32ErrorCode, tBool bIsRoot, tCString coszErrorInfo, 
					tU32 u32Line, tCString coszFile);

/* --err_vSetErrorNoTrace()
	This function sets the error code (see above) without any trace output. */
tVoid err_vSetErrorNoTrace(tU32 u32ErrorCode, tBool bIsRoot);	


tVoid err_vFormatError(tChar chBuf[], tU32 u32BufLength,
	tU32 u32ErrorCode, tBool bIsRoot, tCString coszErrorInfo, tU32 u32Line, tCString coszFile);


/* --err_u32ErrorCodeDescriptor()
	This function returns the complete error code inclusive the root bits. */
tU32 err_u32ErrorCodeDescriptor(void);						

/* --err_u32ErrorCode()
	This function returns the error code without the root bits. */
tU32 err_u32ErrorCode(void);

/* --err_bIsRoot()
	This function returns TRUE if error descriptor has root bit set. */
tBool err_bIsRoot(void);

/* --err_u32Group()
	This function returns the group bits of the error descriptor. */
tU32 err_u32Group(void);

/* --err_u32Level()
	This function returns the level bits of the error descriptor. */
tU32 err_u32Level(void);

/* --err_u32Number()
	This function returns the error number (least 16 bits) of the error descriptor. */
tU32 err_u32Number(void);

/* --ERR_M_SET_ERROR (C-interface)
	This function sets the error code via the OSAL function and dumps
	some more information into the trace-device. 

	Parameter:
		u32ErrorCode: error code
		bIsRoot: TRUE/FALSE depending of error
		coszErrorInfo: additional error info (string)
	*/

#define ERR_M_SET_ERROR(u32ErrorCode,bIsRoot,coszErrorInfo) \
	err_vSetError(u32ErrorCode,bIsRoot,coszErrorInfo,__LINE__,__FILE__)

#define ERR_M_SET_ERROR_NOTRACE(u32ErrorCode,bIsRoot) \
	err_vSetErrorNoTrace(u32ErrorCode,bIsRoot);

#ifdef __cplusplus
}
#endif

/* --C++-interface. */

#ifdef __cplusplus

class err_tclErrorHandler { 
public:

	/* --constructor, destructor. */
	err_tclErrorHandler();
	virtual ~err_tclErrorHandler();

	/* --vSetError
		This method compares to the C-function err_vSetError(). You can define
		a specialized class and overload this method in order to implement a more
		intelligent error handler. If an error occured, this method is executed.

		Use the macros below to set the error code. */
	virtual tVoid vSetError(tU32 u32ErrorCode, tBool bIsRoot, 
						tCString coszErrorInfo, tU32 u32Line, tCString coszFile, tBool bTrace = TRUE); //lint !e1735

	/* --Some methods like the C-interface. */
	tU32 u32ErrorCodeDescriptor() const { return err_u32ErrorCodeDescriptor(); }
	tU32 u32ErrorCode() const { return err_u32ErrorCode(); }
	tBool bIsRoot() const { return err_bIsRoot(); }
	tU32 u32Group() const { return err_u32Group(); }
	tU32 u32Level() const { return err_u32Level(); }
	tU32 u32Number() const { return err_u32Number(); }

private:

	/* --Forbidding the assignment and copying of error handlers. */
   err_tclErrorHandler& operator=(const err_tclErrorHandler&) { return *this; } //lint !e1529 : do nothing because it is forbidden
   err_tclErrorHandler(const err_tclErrorHandler&) {} 
}; //lint !e1704

/* --err_vSetError
	This function takes a pointer to an error handler object and calls the
	vSetErrorCode()-method() if the pointer is not NULL. Otherwise the
	err_vSetErrorCode function is called (little bit tricky. */

tVoid err_vSetError(err_tclErrorHandler* poErrorHandler,tU32 u32ErrorCode, 
			tBool bIsRoot, tCString coszErrorInfo, tU32 u32Line, tCString coszFile);

tVoid err_vSetErrorNoTrace(err_tclErrorHandler* poErrorHandler,tU32 u32ErrorCode, 
			tBool bIsRoot, tCString coszErrorInfo, tU32 u32Line, tCString coszFile);

/* --ERR_M_SET_ERRORHANDLER (C++-interface)
	This function calls the vSetError() method of the errorhandler object. This function
	takes a reference to the object. */

#define ERR_M_SET_ERRORHANDLER(errorhandler,u32ErrorCode,bIsRoot,coszErrorInfo) \
	errorhandler.vSetError(u32ErrorCode,bIsRoot,coszErrorInfo,__LINE__,__FILE__)

/* --ERR_M_SET_ERRORHANDLER2 (C++-interface)
	This function checks if the pointer is NULL and calls the C-interface function instead
	of the object's method. This function takes a pointer to the object. */

#define ERR_M_SET_ERRORHANDLER2(poErrorhandler,u32ErrorCode,bIsRoot,coszErrorInfo) \
	err_vSetError(poErrorhandler,u32ErrorCode,bIsRoot,coszErrorInfo,__LINE__,__FILE__)

#define ERR_M_SET_ERRORHANDLER2_NOTRACE(poErrorhandler,u32ErrorCode,bIsRoot,coszErrorInfo) \
	err_vSetErrorNoTrace(poErrorhandler,u32ErrorCode,bIsRoot,coszErrorInfo,__LINE__,__FILE__)



#endif

#endif
