
#define OSAL_S_IMPORT_INTERFACE_GENERIC
#include "osal_if.h"

#include "err.h"


/* --This defines denote the output sizes. */
#define C_U32_TRACEWRITE_NAME                15
#define C_U32_TRACEWRITE_ELAPSED             10
#define C_U32_TRACEWRITE_LEVEL                  2
#define C_U32_TRACEWRITE_ROOT                   1
#define C_U32_TRACEWRITE_CODE                   10
#define C_U32_TRACEWRITE_INFO                50
#define C_U32_TRACEWRITE_LINE                4
#define C_U32_TRACEWRITE_FILE                25

#define C_U32_TRACEWRITE_LENGTH        \
   (C_U32_TRACEWRITE_NAME+C_U32_TRACEWRITE_ELAPSED+C_U32_TRACEWRITE_LEVEL+ \
      C_U32_TRACEWRITE_ROOT+1+C_U32_TRACEWRITE_CODE+C_U32_TRACEWRITE_INFO+\
      1+C_U32_TRACEWRITE_FILE+1+C_U32_TRACEWRITE_LINE+1+1)


/* This function determines the name of the file, given by path and filename. */
static tCString err_szGetFileName(tCString szFilePathName)
{
   tCString szFileName = OSAL_ps8StringRSearchChar(szFilePathName, '/');
   if (szFileName == OSAL_NULL)
      szFileName = OSAL_ps8StringRSearchChar(szFilePathName, '\\');
   return (tCString)((szFileName != OSAL_NULL) ? (szFileName + 1) : (szFilePathName));
}


extern "C" tVoid err_vTraceAssertion(tCString coszExpression, tCString coszFile, tU32 u32Line) //lint !e765
{
	/* --Open the trace device. */
	OSAL_trThreadControlBlock rTCB;
	OSAL_tIODescriptor io=OSAL_ERROR;
	tChar chBuf[C_U32_TRACEWRITE_LENGTH];
	tCString szThreadName = "unknown";	
   OSAL_tThreadID TID = OSAL_ThreadWhoAmI();

   if ((io=OSAL_IOOpen(OSAL_C_STRING_DEVICE_TRACE,OSAL_EN_WRITEONLY))!=OSAL_ERROR) 
   {	
		/* --Format and dump the information into trace output. */	
		if (OSAL_s32ThreadControlBlock(TID,&rTCB)==OSAL_OK)
      {
         szThreadName = rTCB.szName;
      }

      (void)OSALUTIL_s32NPrintFormat((tS8*)chBuf, 
                               C_U32_TRACEWRITE_LENGTH, 
                               "%s(%d)[%s %d]: assert(%s)",
                               err_szGetFileName(coszFile), 
                               u32Line,
                               szThreadName, TID,
                               coszExpression); 

		/* --Terminate the array (only protection). */
		chBuf[C_U32_TRACEWRITE_LENGTH-1]='\0';
		(void)OSALUTIL_s32TraceWrite(io,TR_LEVEL_FATAL,TR_CLASS_ERR,(tPCS8)chBuf,C_U32_TRACEWRITE_LENGTH); //lint !e641

		/* --Close it. */
		(void)OSAL_s32IOClose(io);
	}
}
   
extern "C" tVoid err_vSetError(tU32 u32ErrorCode, tBool bIsRoot, 
						tCString coszErrorInfo, tU32 u32Line, tCString coszFile) {
	/* --Open the trace device. */
   tCString coszErrInfo = "";
   tCString coszFileName = "";
	OSAL_trThreadControlBlock rTCB;
	OSAL_tIODescriptor io=OSAL_ERROR;
	tChar chBuf[C_U32_TRACEWRITE_LENGTH];
	tString szThreadName[80]={0};		
	tU32 u32StringLength=0, u32InfoLength=0;
	tChar chErrorLevel='-';
	rTCB.szName=szThreadName[0];
	if ((io=OSAL_IOOpen(OSAL_C_STRING_DEVICE_TRACE,OSAL_EN_READONLY))!=OSAL_ERROR) {	
		/* --Format and dump the information into trace output. */	
		if (OSAL_s32ThreadControlBlock(OSAL_ThreadWhoAmI(),&rTCB)==OSAL_ERROR)
			rTCB.szName=0;

      if(NULL != coszErrorInfo) coszErrInfo = coszErrorInfo;
      if(NULL != coszFile) coszFileName = coszFile;
      u32StringLength=(tU32)OSAL_u32StringLength(coszFileName);
	   u32InfoLength=(tU32)OSAL_u32StringLength(coszErrInfo);

		/* --Check the error level. */
		switch (u32ErrorCode&ERR_U32_C_BITS_LEVEL) {
			case ERR_U32_C_BITS_LEVEL_ERROR :
				chErrorLevel='E'; break;
			case ERR_U32_C_BITS_LEVEL_WARNING :
				chErrorLevel='W'; break;
			case ERR_U32_C_BITS_LEVEL_INFO :
				chErrorLevel='I'; break;
         default:
            chErrorLevel='-';
      }

		/* --Format: tread time level root ecode info line file. */
		(void)OSALUTIL_s32NPrintFormat((tPS8)chBuf,
         C_U32_TRACEWRITE_LENGTH,"%-*s%*d%*c%*c% #0*x%-*s[%-*s:%*d]",
         C_U32_TRACEWRITE_NAME,	(rTCB.szName ? 	rTCB.szName : "?"), 
         C_U32_TRACEWRITE_ELAPSED,OSAL_ClockGetElapsedTime(),
         C_U32_TRACEWRITE_LEVEL,chErrorLevel,
         C_U32_TRACEWRITE_ROOT,(bIsRoot==TRUE ? 'R' : '-'), 
         C_U32_TRACEWRITE_CODE,u32ErrorCode, 
			C_U32_TRACEWRITE_INFO,
            coszErrInfo+(u32InfoLength>C_U32_TRACEWRITE_INFO ? u32InfoLength-C_U32_TRACEWRITE_INFO : 0), 
         /* --Display only the tail of the file name. */
			C_U32_TRACEWRITE_FILE,
            coszFileName+(u32StringLength>C_U32_TRACEWRITE_FILE ? u32StringLength-C_U32_TRACEWRITE_FILE : 0),
         C_U32_TRACEWRITE_LINE,u32Line);						
		/* --Terminate the array (only protection). */
		chBuf[C_U32_TRACEWRITE_LENGTH-1]='\0';
		(void)OSALUTIL_s32TraceWrite(io,TR_LEVEL_ERRORS,TR_CLASS_ERR,(tPCS8)chBuf,C_U32_TRACEWRITE_LENGTH); //lint !e641
		/* --Close it. */
		(void)OSAL_s32IOClose(io);
	}
	/* --Set the OSAL error code. */
	OSAL_vSetErrorCode(bIsRoot ? u32ErrorCode|ERR_U32_C_BITS_ROOT_ROOT : u32ErrorCode);
}

extern "C" tVoid err_vFormatError(tChar chBuf[], tU32 u32BufLength,
								  tU32 u32ErrorCode, tBool bIsRoot, tCString coszErrorInfo, tU32 u32Line, tCString coszFile) {

   tCString coszErrInfo = "";
   tCString coszFileName = "";
	OSAL_trThreadControlBlock rTCB;
	tString szThreadName[80]={0};		
	tU32 u32StringLength=0, u32InfoLength=0;
	tChar chErrorLevel='-';
	rTCB.szName=szThreadName[0];
		
	/* --Format and dump the information into trace output. */	
	if (OSAL_s32ThreadControlBlock(OSAL_ThreadWhoAmI(),&rTCB)==OSAL_ERROR)
			rTCB.szName=0;

   if(NULL != coszErrorInfo) coszErrInfo = coszErrorInfo;
   if(NULL != coszFile) coszFileName = coszFile;
   u32StringLength=(tU32)OSAL_u32StringLength(coszFileName);
	u32InfoLength=(tU32)OSAL_u32StringLength(coszErrInfo);

	/* --Check the error level. */
	switch (u32ErrorCode&ERR_U32_C_BITS_LEVEL) {
		case ERR_U32_C_BITS_LEVEL_ERROR :
			chErrorLevel='E'; break;
		case ERR_U32_C_BITS_LEVEL_WARNING :
			chErrorLevel='W'; break;
		case ERR_U32_C_BITS_LEVEL_INFO :
			chErrorLevel='I'; break;
      default:
         chErrorLevel='-';
	}

	/* --Format: tread time level root ecode info line file. */
	(void)OSALUTIL_s32NPrintFormat((tPS8)chBuf,
        C_U32_TRACEWRITE_LENGTH,"%-*s%*d%*c%*c% #0*x%-*s[%-*s:%*d]",
        C_U32_TRACEWRITE_NAME,	(rTCB.szName ? 	rTCB.szName : "?"), 
        C_U32_TRACEWRITE_ELAPSED,OSAL_ClockGetElapsedTime(),
        C_U32_TRACEWRITE_LEVEL,chErrorLevel,
        C_U32_TRACEWRITE_ROOT,(bIsRoot==TRUE ? 'R' : '-'), 
        C_U32_TRACEWRITE_CODE,u32ErrorCode, 
		C_U32_TRACEWRITE_INFO,
           coszErrInfo+(u32InfoLength>C_U32_TRACEWRITE_INFO ? u32InfoLength-C_U32_TRACEWRITE_INFO : 0), 
        /* --Display only the tail of the file name. */
		C_U32_TRACEWRITE_FILE,
           coszFileName+(u32StringLength>C_U32_TRACEWRITE_FILE ? u32StringLength-C_U32_TRACEWRITE_FILE : 0),
        C_U32_TRACEWRITE_LINE,u32Line);						
	/* --Terminate the array (only protection). */
	chBuf[u32BufLength-1]='\0';
}

extern "C" tVoid err_vSetErrorNoTrace(tU32 u32ErrorCode, tBool bIsRoot) {
	OSAL_vSetErrorCode(bIsRoot ? u32ErrorCode|ERR_U32_C_BITS_ROOT_ROOT : u32ErrorCode);
}

extern "C" tU32 err_u32ErrorCodeDescriptor(void) {
	return OSAL_u32ErrorCode();
}
						
extern "C" tU32 err_u32ErrorCode(void) {  
	return OSAL_u32ErrorCode()&ERR_U32_C_BITS_CODE;
}  

extern "C" tBool err_bIsRoot(void) {
	return ((OSAL_u32ErrorCode()&ERR_U32_C_BITS_ROOT) ? TRUE : FALSE);
}

extern "C" tU32 err_u32Group(void) {
	return OSAL_u32ErrorCode()&ERR_U32_C_BITS_GROUP;
}

extern "C" tU32 err_u32Level(void) {
	return OSAL_u32ErrorCode()&ERR_U32_C_BITS_LEVEL;
}

extern "C" tU32 err_u32Number(void) {
	return OSAL_u32ErrorCode()&ERR_U32_C_BITS_NUMBER;
}

tVoid err_vSetError(err_tclErrorHandler* poErrorHandler,tU32 u32ErrorCode, 
						tBool bIsRoot, tCString coszErrorInfo, tU32 u32Line, tCString coszFile) {
	/* --Check if pointer is NULL. */
	if (poErrorHandler)
		poErrorHandler->vSetError(u32ErrorCode,bIsRoot,coszErrorInfo,u32Line,coszFile);
	else
		err_vSetError(u32ErrorCode,bIsRoot,coszErrorInfo,u32Line,coszFile);
}

tVoid err_vSetErrorNoTrace(err_tclErrorHandler* poErrorHandler,tU32 u32ErrorCode, 
						tBool bIsRoot, tCString coszErrorInfo, tU32 u32Line, tCString coszFile) {
	/* --Check if pointer is NULL. */
	if (poErrorHandler)
		poErrorHandler->vSetError(u32ErrorCode,bIsRoot,coszErrorInfo,u32Line,coszFile,FALSE);
	else
		err_vSetErrorNoTrace(u32ErrorCode,bIsRoot);
}



/* --err_tclErrorHandler. */

err_tclErrorHandler::err_tclErrorHandler() {}

err_tclErrorHandler::~err_tclErrorHandler() {}

tVoid err_tclErrorHandler::vSetError(tU32 u32NewErrorCode, tBool bIsErrorRoot, 
	tCString coszErrorInfo, tU32 u32Line, tCString coszFile,tBool bTrace) {
	/* --Set the error code. */
	if (bTrace==TRUE)
		err_vSetError(u32NewErrorCode, bIsErrorRoot, coszErrorInfo, u32Line, coszFile);
	else
		err_vSetErrorNoTrace(u32NewErrorCode,bIsErrorRoot);
}

