#ifndef CCA_HEADER
#define CCA_HEADER

/* --cca.h

   This file contains all defines of famous car computer architecture
   according to the document "CCA-Dienste".

   Author: Michael Uelschen, CM-DI/ESN2
   
   $Log:   //hi230124/projects/Vasco/swnavi/archives/components/cca/cca.h-arc  $
 * 
 *    Rev 1.3   Jul 10 2003 15:00:50   Wiedemann
 * new opcodes for message streaming added
 * 
 *    Rev 1.2   31 Oct 2002 13:11:14   UNM2HI
 * Update

*/

/* --IPC Header information. */
/* --Context byte. */
#define CCA_C_U8_CONTEXT_LOCAL            (tU8)IPC_CONTEXT_TYPE_LOCAL_CCA
/* --CCA message version. */
#define CCA_C_U16_VERSION                 (tU16)0x0002
/* --CCA message type. */
#define CCA_C_U8_TYPE_POWER               (tU8)IPC_CONTEXT_SUBTYPE_POWER_MESSAGE
#define CCA_C_U8_TYPE_SVCREGISTER         (tU8)IPC_CONTEXT_SUBTYPE_SERVICE_REGISTER
#define CCA_C_U8_TYPE_SVCUNREGISTER       (tU8)IPC_CONTEXT_SUBTYPE_SERVICE_UNREGISTER
#define CCA_C_U8_TYPE_UNKNOWNREGISTERID   (tU8)IPC_CONTEXT_SUBTYPE_UNKNOWN_REGISTER_ID
#define CCA_C_U8_TYPE_SVCCONF             (tU8)IPC_CONTEXT_SUBTYPE_SERVICE_REGISTER_CONFIRMATION
#define CCA_C_U8_TYPE_SVSSTATUS           (tU8)IPC_CONTEXT_SUBTYPE_SERVICE_STATUS
#define CCA_C_U8_TYPE_SVCDATA             (tU8)IPC_CONTEXT_SUBTYPE_SERVICE_DATA

#ifndef IPC_CONTEXT_SUBTYPE_SUPPLIER_STATE
#define CCA_C_U8_TYPE_SUPPLIER_STATE_REGISTER      (tU8)0x46
#define CCA_C_U8_TYPE_SUPPLIER_STATE               (tU8)0x47
#define CCA_C_U8_TYPE_SUPPLIER_STATE_UNREGISTER    (tU8)0x48
#define CCA_C_U8_TYPE_APPLICATION_INFO_REGISTER    (tU8)0x49
#define CCA_C_U8_TYPE_APPLICATION_INFO             (tU8)0x50
#define CCA_C_U8_TYPE_APPLICATION_INFO_UNREGISTER  (tU8)0x51
#else
#define CCA_C_U8_TYPE_SUPPLIER_STATE_REGISTER      (tU8)IPC_CONTEXT_SUBTYPE_SUPPLIER_STATE_REGISTER    
#define CCA_C_U8_TYPE_SUPPLIER_STATE               (tU8)IPC_CONTEXT_SUBTYPE_SUPPLIER_STATE             
#define CCA_C_U8_TYPE_SUPPLIER_STATE_UNREGISTER    (tU8)IPC_CONTEXT_SUBTYPE_SUPPLIER_STATE_UNREGISTER  
#define CCA_C_U8_TYPE_APPLICATION_INFO_REGISTER    (tU8)IPC_CONTEXT_SUBTYPE_APPLICATION_INFO_REGISTER  
#define CCA_C_U8_TYPE_APPLICATION_INFO             (tU8)IPC_CONTEXT_SUBTYPE_APPLICATION_INFO           
#define CCA_C_U8_TYPE_APPLICATION_INFO_UNREGISTER  (tU8)IPC_CONTEXT_SUBTYPE_APPLICATION_INFO_UNREGISTER
#endif                                                                  

#ifndef IPC_CONTEXT_SUBTYPE_DEBUG_APPLICATION
#define CCA_C_U8_TYPE_DEBUG_APPLICATION (tU8)0xFF
#else
#define CCA_C_U8_TYPE_DEBUG_APPLICATION (tU8)IPC_CONTEXT_SUBTYPE_DEBUG_APPLICATION
#endif

/* --Priorities of messages. */
#define CCA_C_U32_PRIORITY_POWER                      (tU32)0x00000000
#define CCA_C_U32_PRIORITY_SVCREGISTER                (tU32)0x00000002
#define CCA_C_U32_PRIORITY_SVCUNREGISTER              (tU32)0x00000002
#define CCA_C_U32_PRIORITY_SVCCONF                    (tU32)0x00000001
#define CCA_C_U32_PRIORITY_SVCSTATUS                  (tU32)0x00000001
#define CCA_C_U32_PRIORITY_SVCDATA_GET                (tU32)0x00000007
#define CCA_C_U32_PRIORITY_SVCDATA_SET                (tU32)0x00000007
#define CCA_C_U32_PRIORITY_SVCDATA_METHODSTART        (tU32)0x00000007
#define CCA_C_U32_PRIORITY_SVCDATA_UPREG              (tU32)0x00000007
#define CCA_C_U32_PRIORITY_SVCDATA_RELUPREG           (tU32)0x00000007
#define CCA_C_U32_PRIORITY_SVCDATA_METHODABORT        (tU32)0x00000007
#define CCA_C_U32_PRIORITY_SVCDATA_STATUS             (tU32)0x00000006
#define CCA_C_U32_PRIORITY_SVCDATA_ERROR              (tU32)0x00000006
#define CCA_C_U32_PRIORITY_SVCDATA_METHODRESULT       (tU32)0x00000006
#define CCA_C_U32_PRIORITY_SVCDATA_ABORTRESULT        (tU32)0x00000006
#define CCA_C_U32_PRIORITY_SVCDATA_METHODRESULTFIRST  (tU32)0x00000006
#define CCA_C_U32_PRIORITY_SVCDATA_METHODRESULTMIDDLE (tU32)0x00000006
#define CCA_C_U32_PRIORITY_SVCDATA_METHODRESULTLAST   (tU32)0x00000006
#define CCA_C_U32_PRIORITY_SVCSREGISTER               (tU32)0x00000002
#define CCA_C_U32_PRIORITY_SVCSUNREGISTER             (tU32)0x00000002
#define CCA_C_U32_PRIORITY_SVCSSTATUS                 (tU32)0x00000001
#define CCA_C_U32_PRIORITY_AIREGISTER                 (tU32)0x00000002
#define CCA_C_U32_PRIORITY_AIUNREGISTER               (tU32)0x00000002
#define CCA_C_U32_PRIORITY_AISTATUS                   (tU32)0x00000001

/* --ServiceConfirmation message. */

#define CCA_C_U8_SVCCONF_NO_SUCCESS                      (tU8)0x00 // Registration failed without a specified reason.
#define CCA_C_U8_SVCCONF_SUCCESS                         (tU8)0x01 // Registration successful.
#define CCA_C_U8_SVCCONF_SERVICE_ALREADY_REGISTERED      (tU8)0x02 // Registration failed because service is already registered.
#define CCA_C_U8_SVCCONF_SERVICE_VERSION_NOT_SUPPORTED   (tU8)0x03 // Registration failed because the server doesn't support the requested service version.
#define CCA_C_U8_SVCCONF_SERVICE_REGISTRATION_PENDING    (tU8)0x04 // Registration failed because service was already requested and the request is still pending.
#define CCA_C_U8_SVCCONF_SERVER_DOES_NOT_RESPOND_TIMEOUT (tU8)0x05 // Registration failed because the server exists but doesn't respond (timeout).
#define CCA_C_U8_SVCCONF_SERVICE_DOES_NOT_EXIST          (tU8)0x06 // Registration failed because am server which offers this service doesn't exist.

/* --ServiceStatus message. */

#define CCA_C_U8_SVCSTATUS_AVAILABLE            (tU8)0x00
#define CCA_C_U8_SVCSTATUS_NOT_AVAILABLE        (tU8)0x01
#define CCA_C_U8_SVCSTATUS_REG_DENIED           (tU8)0x02

/* --ServiceData message. */

/* --Stream type fields. */
#define CCA_C_U8_STREAMTYPE_NODATA              (tU8)0x00
#define CCA_C_U8_STREAMTYPE_FIRSTDATA           (tU8)0x01
#define CCA_C_U8_STREAMTYPE_MIDDLEDATA          (tU8)0x02
#define CCA_C_U8_STREAMTYPE_LASTDATA            (tU8)0x03
#define CCA_C_U8_STREAMTYPE_ABORTED             (tU8)0x04

/* --OpCodes. */
#define CCA_C_U8_OPCODE_SET                     (tU8)0x00
#define CCA_C_U8_OPCODE_GET                     (tU8)0x01
#define CCA_C_U8_OPCODE_METHODSTART             (tU8)0x02
#define CCA_C_U8_OPCODE_UPREG                   (tU8)0x03
#define CCA_C_U8_OPCODE_RELUPREG                (tU8)0x04
#define CCA_C_U8_OPCODE_METHODABORT             (tU8)0x05
#define CCA_C_U8_OPCODE_STATUS                  (tU8)0x06
#define CCA_C_U8_OPCODE_METHODRESULT            (tU8)0x07
#define CCA_C_U8_OPCODE_ERROR                   (tU8)0x08
#define CCA_C_U8_OPCODE_ABORTRESULT             (tU8)0x09
#define CCA_C_U8_OPCODE_METHODRESULTFIRST       (tU8)0x0A
#define CCA_C_U8_OPCODE_METHODRESULTMIDDLE      (tU8)0x0B
#define CCA_C_U8_OPCODE_METHODRESULTLAST        (tU8)0x0C
#define CCA_C_U8_OPCODE_CLIENT_PORT_ACK         (tU8)0x0D
#define CCA_C_U8_OPCODE_SERVER_PORT_ACK         (tU8)0x0E
#define CCA_C_U8_OPCODE_INCREMENT               (tU8)0x10
#define CCA_C_U8_OPCODE_DECREMENT               (tU8)0x11
#define CCA_C_U8_OPCODE_PURESET                 (tU8)0x12

/* --Error Codes. */
#define CCA_C_U16_ERROR_UNSPECIFIED             (tU16)0x0000
#define CCA_C_U16_ERROR_UNKNOWN_SVC_ID          (tU16)0x0001
#define CCA_C_U16_ERROR_UNKNOWN_FCT_ID          (tU16)0x0002
#define CCA_C_U16_ERROR_INVALID_OPCODE          (tU16)0x0003
#define CCA_C_U16_ERROR_INVALID_CCATYPE         (tU16)0x0004
#define CCA_C_U16_ERROR_PARAMETER_OUT_OF_RANGE  (tU16)0x0005
#define CCA_C_U16_ERROR_UNKNOWN_REG_ID          (tU16)0x0006
#define CCA_C_U16_ERROR_VERSION_NOT_SUPPORTED  	(tU16)0x0007
#define CCA_C_U16_ERROR_PARAMETER_MISSING       (tU16)0x0008
#define CCA_C_U16_ERROR_PARAMETER_TOO_MANY      (tU16)0x0009
#define CCA_C_U16_ERROR_FUNCTION_BUSY           (tU16)0x000a
#define CCA_C_U16_ERROR_TEMPORARY_NOT_AVAILABLE (tU16)0x000b
#define CCA_C_U16_ERROR_OPCODE_NOT_SUPPORTED    (tU16)0x000c
#define CCA_C_U16_ERROR_INTERNAL_FAILURE        (tU16)0x000d
#define CCA_C_U16_ERROR_UPREG_FAILURE           (tU16)0x000e
#define CCA_C_U16_ERROR_RELUPREG_FAILURE        (tU16)0x000f
#define CCA_C_U16_ERROR_RELUPREG_CONF_WITHOUT_STATUS (tU16)0x0010

#endif
