//*****************************************************************************
//** FILE:         amt_settings.h
//** PROJECT:      VASCO
//** SW-COMPONENT: 
//** --------------------------------------------------------------------------
//** DESCRIPTION:  (A)pplication (M)essage (T)emplate
//**               Settings for AMT module
//** --------------------------------------------------------------------------
//** COPYRIGHT:    (c) 2000 Robert Bosch GmbH, Hildesheim
//** HISTORY:      
//** Date      |   Modification                         | Author
//** 06.02.01  |   Initial revision                     | Bruns,EFG32
//**
//**---------------------------------------------------------------------------
//** REMARK: switches MUST be set in "amt_settings.h"
//*****************************************************************************

#ifndef AMT_SETTINGS_H
   #define AMT_SETTINGS_H


//-----------------------------------------------------------------------------
// AMT_USED_AS_LIBRARY
// The Framework is used as library. AMT's initialisation function must be
// called explicitly. Settings is automatically selected if "AMTDLL_EXPORTS"
// is defined (when building the DLL-project).
//-----------------------------------------------------------------------------
//#undef   AMT_USED_AS_LIBRARY    entfernt, damit ein Produkt doch diese Mglichkeit hat Tn


//-----------------------------------------------------------------------------
// AMT_ALIGNMENT_TEST
// The frameworks checks for aligned addresses in 
// "amt_tclMappedIntegralType<T>::nGetRefValue"
//-----------------------------------------------------------------------------
#undef   AMT_ALIGNMENT_TEST


//-----------------------------------------------------------------------------
// AMT Trace Settings
//-----------------------------------------------------------------------------

#define  AMT_MAX_TRACEBUF_LEN        255           // maximum buffer length for
                                                   // trace output

#define  AMT_TRACE_SIZE_DEFAULT      30            // default size for trace 
                                                   // output

#endif  // AMT_SETTINGS_H
