//## begin module%1.4%.codegen_version preserve=yes
//   Read the documentation to learn more about C++ code generator
//   versioning.
//## end module%1.4%.codegen_version

//## begin module%3A3E1DE200C6.cm preserve=no
//	  %X% %Q% %Z% %W%
//## end module%3A3E1DE200C6.cm

//## Module: amt_MMObj%3A3E1DE200C6; Subprogram specification
//## Subsystem: Amt::Include%3A7E97380302
//## Source file: e:\vasco\components\Amt\Include\amt_MMObj.h

#ifndef amt_MMObj_h
#define amt_MMObj_h 1

//## begin module%3A3E1DE200C6.includes preserve=yes
//## end module%3A3E1DE200C6.includes

//## begin module%3A3E1DE200C6.additionalDeclarations preserve=yes
//## end module%3A3E1DE200C6.additionalDeclarations


//## begin amt_tclMappableType%3A3DCC0703D2.preface preserve=yes
//***************************************************************************
//** FILE:         amt_MMObj.h
//** PROJECT:      VASCO
//** SW-COMPONENT: AMT
//**---------------------------------------------------------------------------
//** DESCRIPTION:  (A)pplication (M)essage (T)emplate
//**               Implementation of memory mapped datatypes
//**---------------------------------------------------------------------------
//** COPYRIGHT:    (c) 2000 Robert Bosch GmbH, Hildesheim
//** HISTORY:
//** Date       |  Modification                         | Author
//** < 19.03.01 |  Basic prototypes                     | Bruns,EFG32
//**  19.03.01  |  Updated ELL conventions              | Bruns,EFG32
//**
//**---------------------------------------------------------------------------
//** REMARK: switches MUST be set in "amt_settings.h"
//*****************************************************************************


// -------------------------------------------------------------------------
// REMARK: manually added forward declaration !
class amt_tclMappableMessage;
// -------------------------------------------------------------------------




//## end amt_tclMappableType%3A3DCC0703D2.preface

//## Class: amt_tclMappableType%3A3DCC0703D2
//	*********************************************************
//	***********************
//	DESCRIPTION:
//
//	This class represents the base class of all memory
//	mapped data types. All get and set methods are
//	undocumentated due to simplicity.
//
//
//	History:
//
//	19.03.01 EFG32-Bruns
//	InitialVersion
//
//	*********************************************************
//	***********************
//## Category: amt::amt_MemoryMappedObjects::amt_StandardTypes%3A8260810047
//## Subsystem: Amt::Include%3A7E97380302
//## Persistence: Transient
//## Cardinality/Multiplicity: n



class amt_tclMappableType
{
  //## begin amt_tclMappableType%3A3DCC0703D2.initialDeclarations preserve=yes
   // -------------------------------------------------------------------------
   // REMARK: manually added friendship !
   friend class amt_tclMappableMessage;
   // -------------------------------------------------------------------------
  //## end amt_tclMappableType%3A3DCC0703D2.initialDeclarations

  public:
    //## Constructors (specified)
      //## Operation: amt_tclMappableType%3A3DDC5B033C
      //	*********************************************************
      //	***********************
      //	DESCRIPTION:
      //	Default constructor. Initialises internal attributes.
      //
      //	PARAMETER:
      //
      //	RETURNVALUE:
      //	-
      //
      //	History:
      //	19.03.01 EFG32-Bruns
      //	InitialVersion
      //	*********************************************************
      //	***********************
      amt_tclMappableType ();

      virtual ~amt_tclMappableType (){};


    //## Other Operations (specified)
      //## Operation: u32GetSizeOfType%3A3DDBB702FA
      //	*********************************************************
      //	***********************
      //	DESCRIPTION:
      //	This virtual method must be overwritten by derived
      //	datatype classes to return the correct length of that
      //	datatype.
      //
      //	PARAMETER:
      //	-
      //
      //	RETURNVALUE:
      //	tU32   Length of the datatype in shared memory.
      //
      //	History:
      //	19.03.01 EFG32-Bruns
      //	InitialVersion
      //	*********************************************************
      //	***********************
      virtual tU32 u32GetSizeOfType () const;

    // Data Members for Class Attributes

      //## Attribute: u32Offset%3A3DDBA20169
      //	This attribute contains the offset from "u32SharedMem
      //	Base" to this message field.
      //## begin amt_tclMappableType::u32Offset%3A3DDBA20169.attr preserve=no  public: tU32 {UA}
      tU32 u32Offset;
      //## end amt_tclMappableType::u32Offset%3A3DDBA20169.attr

    // Additional Public Declarations
      //## begin amt_tclMappableType%3A3DCC0703D2.public preserve=yes
      //## end amt_tclMappableType%3A3DCC0703D2.public

};

//## begin amt_tclMappableType%3A3DCC0703D2.postscript preserve=yes
//## end amt_tclMappableType%3A3DCC0703D2.postscript

//## begin amt_tclMappableMessage%3A409563021A.preface preserve=yes
//## end amt_tclMappableMessage%3A409563021A.preface

//## Class: amt_tclMappableMessage%3A409563021A
//	*********************************************************
//	***********************
//	DESCRIPTION:
//
//	This class represents the base of all messages and
//	contains the basic elements like "pSharedMemBase" and
//	the dynamically calculated size of the message. All get
//	and set methods are undocumentated due to simplicity.
//
//
//	History:
//
//	19.03.01 EFG32-Bruns
//	InitialVersion
//	19.09.01 EFG32-Bruns
//	Updated to ipc_def.h and using static offsets for all
//	messages
//
//	*********************************************************
//	***********************
//## Category: amt::amt_MemoryMappedObjects::amt_StandardTypes%3A8260810047
//## Subsystem: Amt::Include%3A7E97380302
//## Persistence: Transient
//## Cardinality/Multiplicity: n



//## Uses: uses%3A4096370265;amt_tclMappableType { -> }

class amt_tclMappableMessage
{
  //## begin amt_tclMappableMessage%3A409563021A.initialDeclarations preserve=yes
//  friend class amt_tclMappedIntegralType<class T>;
//  friend tVoid amt_tclMappedIntegralType<T>::vSetValue(amt_tclMappableMessage* pMMsg, T value);
  //## end amt_tclMappableMessage%3A409563021A.initialDeclarations

  public:
    //## Constructors (specified)
      //## Operation: amt_tclMappableMessage%3A6E91A3010A
      //	*********************************************************
      //	***********************
      //	DESCRIPTION:
      //	Default constructor. Initialises internal attributes.
      //
      //	PARAMETER:
      //
      //	RETURNVALUE:
      //	-
      //
      //	History:
      //	19.03.01 EFG32-Bruns
      //	InitialVersion
      //	*********************************************************
      //	***********************
      amt_tclMappableMessage ();

      //## Operation: amt_tclMappableMessage%3A71258502E9
      //	*********************************************************
      //	***********************
      //	DESCRIPTION:
      //	Copy constructor.
      //
      //	PARAMETER:
      //	const amt_tclMappableMessage    &rfoMMsg
      //	Source message which will be copied
      //
      //	RETURNVALUE:
      //	-
      //
      //	History:
      //	19.03.01 EFG32-Bruns
      //	InitialVersion
      //	*********************************************************
      //	***********************
      amt_tclMappableMessage (const amt_tclMappableMessage& rfoMMsg);

      // assignment constructor
      // 19.05.2017, ksm2hi : Coverity blamed that there is a public copy constructor but no assignment constructor. So also added the assignment constructor to be consequent in this regard.
      amt_tclMappableMessage& operator=(const amt_tclMappableMessage&);

      //## Operation: amt_tclMappableMessage%3B023E5E038F
      //	*********************************************************
      //	***********************
      //	DESCRIPTION:
      //	Constructor - directly sets OSAL message handle to given
      //	value.
      //
      //	PARAMETER:
      //	const OSAL_trMessage*   pOSALHandle
      //	The handle of a message to which this class should point
      //	to.
      //	tU32   u32MsgSize
      //	Size of the specified message in SharedMemory.
      //
      //	RETURNVALUE:
      //	-
      //
      //	History:
      //	19.03.01 EFG32-Bruns
      //	InitialVersion
      //	*********************************************************
      //	***********************
      amt_tclMappableMessage (const OSAL_trMessage* pOSALHandle, tU32 u32MsgSize);

    //## Destructor (specified)
      //## Operation: ~amt_tclMappableMessage%3A71257A01DF
      //	*********************************************************
      //	***********************
      //	DESCRIPTION:
      //	Destructor - did not delete message's ressources. This
      //	must be done explicitly by calling "bDelete()".
      //
      //	PARAMETER:
      //	-
      //
      //	RETURNVALUE:
      //	-
      //
      //	History:
      //	19.03.01 EFG32-Bruns
      //	InitialVersion
      //	*********************************************************
      //	***********************
      virtual ~amt_tclMappableMessage ();


    //## Other Operations (specified)
      //## Operation: pu8GetSharedMemBase%3A715A9800D3
      tU8* pu8GetSharedMemBase () const;

      //## Operation: u32GetDynMsgSize%3A715B340381
      tU32 u32GetDynMsgSize () const;

      //## Operation: prGetOSALMsgHandle%3A715B9203C2
      OSAL_trMessage* prGetOSALMsgHandle ();

      //## Operation: bDelete%3A824730017E
      //	*********************************************************
      //	***********************
      //	DESCRIPTION:
      //	Deletes shared memory used for tis message. Must be
      //	called by owner of the message (receiver) to free all
      //	used ressources.
      //
      //	PARAMETER:
      //
      //	RETURNVALUE:
      //	TRUE on success else FALSE
      //
      //	History:
      //	19.03.01 EFG32-Bruns
      //	InitialVersion
      //	*********************************************************
      //	***********************
      tBool bDelete ();

      //## Operation: bIsValid%3AB9C2D50099
      //	*********************************************************
      //	***********************
      //	DESCRIPTION:
      //	Validates the message (checks pSharedMemBase != 0) for
      //	successful allocation/creation.
      //
      //	PARAMETER:
      //
      //	RETURNVALUE:
      //	TRUE on success else FALSE
      //
      //	History:
      //	19.03.01 EFG32-Bruns
      //	InitialVersion
      //	*********************************************************
      //	***********************
      tBool bIsValid () const;

      // Invalidate message by setting the pSharedMemBase to NULL.
      tVoid vInvalidate();

      //## Operation: vSetDynMsgSize%3AB9C8F80355
      tVoid vSetDynMsgSize (tU32 u32MsgSize);

      //## Operation: bEnableAccess%3AB9D6500338
      //	*********************************************************
      //	***********************
      //	DESCRIPTION:
      //	"Maps" the message handle in rOSALMsg to correct pointer
      //	to Shared Memory. Sets "pu8SharedMemBase".
      //
      //	PARAMETER:
      //
      //	RETURNVALUE:
      //	TRUE on success else FALSE
      //
      //	History:
      //	19.03.01 EFG32-Bruns
      //	InitialVersion
      //	*********************************************************
      //	***********************
      tBool bEnableAccess ();

      // *****************************************************************************
      //  DESCRIPTION:
      //  This Method provides a way to delegate further processing of our 
      //  message to any empty MappableMessage-derived object. 
      //
      //  Primary intended usage is separating 
      //     user data loading (impicitly creating the message) 
      //  from
      //     filling in mailing parameters and posting
      //
      //  Therefore we:
      //     - copy all handles to shared memory into the destination object
      //     - invalidate our own handles
      //
      //	 PARAMETER:
      //     - pointer to destination message
      //       NOTE: must be empty (created without shared memory allocation)
      //
      //  Return:  TRUE  if successful, 
      //           FALSE if the pointer to the destination message is not valid
      //                 or the destination message already owns a valid message
      //                 or we don't own a valid message
      //
      //  History:
      //  21.05.10  |  Martin Koch (Fa. ESE)   |  InitialVersion
      // *****************************************************************************
      tBool bHandOver (amt_tclMappableMessage* poDestinationMessage);

      //## Operation: poClone%3B0230DF01BA
      //	*********************************************************
      //	***********************
      //	DESCRIPTION:
      //	This virtual function must be overwritten and
      //	implemented in derived classes to support the dynamic
      //	construction (dynamic constructor) of messages. poClone
      //	can be called with a pointer to a base message and
      //	construct a copy of the actual message the pointer
      //	points to.
      //
      //	PARAMETER:
      //
      //	RETURNVALUE:
      //	Pointer to created message on success, else NULL.
      //
      //	History:
      //	19.03.01 EFG32-Bruns
      //	InitialVersion
      //	*********************************************************
      //	***********************
      virtual amt_tclMappableMessage* poClone () const = 0;

      //## Operation: vAddDynMsgSize%3B7A19DA02FE
      //	*********************************************************
      //	***********************
      //	DESCRIPTION:
      //	Adds the value of "u32AdditionalSize" to the class'
      //	attribute "u32DynMsgSize". This method is used for the
      //	definition of "static message classes" with fixed field
      //	offsets.
      //
      //	PARAMETER:
      //	tU32   u32AdditionalSize
      //	Additional message size to be added (-> I).
      //
      //	RETURNVALUE:
      //	tVoid
      //
      //	History:
      //	19.03.01 EFG32-Bruns
      //	InitialVersion
      //	*********************************************************
      //	***********************
      tVoid vAddDynMsgSize (tU32 u32AdditionalSize);

    // Data Members for Class Attributes

      //## Attribute: pu8SharedMemBase%3A40958C03D1
      //	Pointer to message in Shared Memory. This pointer is set
      //	internally by the framework by using the OSAL message
      //	handle "rOSALMsg" and an appropriate OSAL function.
      //## begin amt_tclMappableMessage::pu8SharedMemBase%3A40958C03D1.attr preserve=no  public: tU8* {UA}
      tU8* pu8SharedMemBase;
      //## end amt_tclMappableMessage::pu8SharedMemBase%3A40958C03D1.attr

    // Additional Public Declarations
      //## begin amt_tclMappableMessage%3A409563021A.public preserve=yes
      //## end amt_tclMappableMessage%3A409563021A.public

  protected:

    //## Other Operations (specified)
      //## Operation: vAddType%3A4095F000F0
      //	*********************************************************
      //	***********************
      //	DESCRIPTION:
      //	Dynamically add a memory mapped data type to a message
      //	class.
      //
      //	PARAMETER:
      //	amt_tclMappableType   *prNewType  (->I)
      //	Pointer to the memory mapped type to insert.
      //
      //	RETURNVALUE:
      //	tVoid
      //
      //	History:
      //	19.03.01 EFG32-Bruns
      //	InitialVersion
      //	*********************************************************
      //	***********************
      tVoid vAddType (amt_tclMappableType* prNewType);

      //## Operation: bAllocateMessage%3A40966F017F
      //	*********************************************************
      //	***********************
      //	DESCRIPTION:
      //	Allocate memory for all added datatypes (= represented
      //	by value "u32DynMsgSize").
      //
      //	PARAMETER:
      //
      //	RETURNVALUE:
      //	TRUE on success else FALSE
      //
      //	History:
      //	19.03.01 EFG32-Bruns
      //	InitialVersion
      //	*********************************************************
      //	***********************
      tBool bAllocateMessage ();

      //## Operation: vSetSharedMemBase%3A715B020176
      tVoid vSetSharedMemBase (tU8* pu8NewSharedBase);

    // Additional Protected Declarations
      //## begin amt_tclMappableMessage%3A409563021A.protected preserve=yes
      //## end amt_tclMappableMessage%3A409563021A.protected

  private:

    // Data Members for Class Attributes

      //## Attribute: u32DynMsgSize%3A4095BA0139
      //	Dynamically calculated message size.
      //## begin amt_tclMappableMessage::u32DynMsgSize%3A4095BA0139.attr preserve=no  private: tU32 {UA}
      tU32 u32DynMsgSize;
      //## end amt_tclMappableMessage::u32DynMsgSize%3A4095BA0139.attr

      //## Attribute: rOSALMsg%3A71260200FE
      //	"Handle" to the message in shared memory.
      //## begin amt_tclMappableMessage::rOSALMsg%3A71260200FE.attr preserve=no  private: OSAL_trMessage {UA}
      OSAL_trMessage rOSALMsg;
      //## end amt_tclMappableMessage::rOSALMsg%3A71260200FE.attr

    // Additional Private Declarations
      //## begin amt_tclMappableMessage%3A409563021A.private preserve=yes
      //## end amt_tclMappableMessage%3A409563021A.private

};

//## begin amt_tclMappableMessage%3A409563021A.postscript preserve=yes
//## end amt_tclMappableMessage%3A409563021A.postscript

//## begin amt_tclMappedIntegralType%3A3DE9C80013.preface preserve=yes
//## end amt_tclMappedIntegralType%3A3DE9C80013.preface

//## Class: amt_tclMappedIntegralType%3A3DE9C80013; Parameterized Class
//	*********************************************************
//	***********************
//	DESCRIPTION:
//
//	This class implements a template for memory mapped
//	datatypes with a fixed size which can be calculated by
//	calling "sizeof(T)" (of the template's parameter
//	T=type).  All get and set methods are undocumentated due
//	to simplicity.
//
//
//	History:
//
//	19.03.01 EFG32-Bruns
//	InitialVersion
//
//	*********************************************************
//	***********************
//## Category: amt::amt_MemoryMappedObjects::amt_StandardTypes%3A8260810047
//## Subsystem: Amt::Include%3A7E97380302
//## Persistence: Transient
//## Cardinality/Multiplicity: n



template <class T>
class amt_tclMappedIntegralType : public amt_tclMappableType  //## Inherits: <unnamed>%3A3DE9DD0117
{
  //## begin amt_tclMappedIntegralType%3A3DE9C80013.initialDeclarations preserve=yes
  friend class amt_tclMappableMessage;
  //## end amt_tclMappedIntegralType%3A3DE9C80013.initialDeclarations

  public:
    //## Constructors (specified)
      //## Operation: amt_tclMappedIntegralType%3A3DEA26014E
      //	*********************************************************
      //	***********************
      //	DESCRIPTION:
      //	Default constructor.
      //
      //	PARAMETER:
      //	-
      //
      //	RETURNVALUE:
      //	-
      //
      //	History:
      //	19.03.01 EFG32-Bruns
      //	InitialVersion
      //	*********************************************************
      //	***********************
      amt_tclMappedIntegralType ();
      virtual ~amt_tclMappedIntegralType (){};


    //## Other Operations (specified)
      //## Operation: u32GetSizeOfType%3A3DEA360198
      //	*********************************************************
      //	***********************
      //	DESCRIPTION:
      //	see amt_tclMappableType.
      //	Returns sizeof(T).
      //
      //	History:
      //	19.03.01 EFG32-Bruns
      //	InitialVersion
      //	*********************************************************
      //	***********************
      virtual tU32 u32GetSizeOfType () const;

      //## Operation: vSetValue%3A3DEA4D0046
      //	*********************************************************
      //	***********************
      //	DESCRIPTION:
      //	Access method for writing a value of type T to shared
      //	memory mapped object represented by this class.
      //
      //	PARAMETER:
      //	amt_tclMappableMessage   *poMMsg   (-> I)
      //	Pointer to the message class which contains this message
      //	field.
      //	T   value   (->I)
      //	Value which will be stored in this message field.
      //
      //	RETURNVALUE:
      //	tVoid
      //
      //	History:
      //	19.03.01 EFG32-Bruns
      //	InitialVersion
      //	*********************************************************
      //	***********************
      tVoid vSetValue (amt_tclMappableMessage* poMMsg, T value);

      //## Operation: nGetValue%3A3DEA760334
      //	*********************************************************
      //	***********************
      //	DESCRIPTION:
      //	Access method for reading a value of type T from shared
      //	memory mapped object represented by this class. Copyies
      //	field contents into a temporary variable by calling
      //	OSAL's memcpy function and returns that variable.
      //
      //	PARAMETER:
      //	amt_tclMappableMessage   *prMMsg   (-> I)
      //	Pointer to the message class which contains this message
      //	field.
      //
      //	RETURNVALUE:
      //	T   (the value stored in the message field represented
      //	by this class
      //
      //	History:
      //	19.03.01 EFG32-Bruns
      //	InitialVersion
      //	*********************************************************
      //	***********************
      T nGetValue (const amt_tclMappableMessage* prMMsg) const;

    // Additional Public Declarations
      //## begin amt_tclMappedIntegralType%3A3DE9C80013.public preserve=yes
      //## end amt_tclMappedIntegralType%3A3DE9C80013.public

};

//## begin amt_tclMappedIntegralType%3A3DE9C80013.postscript preserve=yes
//## end amt_tclMappedIntegralType%3A3DE9C80013.postscript

//## begin amt_tclMU16%3A3DFE8D0145.preface preserve=yes
//## end amt_tclMU16%3A3DFE8D0145.preface

//## Class: amt_tclMU16%3A3DFE8D0145; Instantiated Class
//	*********************************************************
//	***********************
//	DESCRIPTION:
//
//	This class implements a memory mapped datatype for tU16.
//
//	History:
//
//	19.03.01 EFG32-Bruns
//	InitialVersion
//
//	*********************************************************
//	***********************
//## Category: amt::amt_MemoryMappedObjects::amt_StandardTypes%3A8260810047
//## Subsystem: Amt::Include%3A7E97380302
//## Persistence: Transient
//## Cardinality/Multiplicity: n



//## begin amt_tclMU16%3A3DFE8D0145.postscript preserve=yes
//template class amt_tclMappedIntegralType< tU16  >;
//## end amt_tclMU16%3A3DFE8D0145.postscript

//## begin amt_tclMU32%3A3E01860275.preface preserve=yes
//## end amt_tclMU32%3A3E01860275.preface

//## Class: amt_tclMU32%3A3E01860275; Instantiated Class
//	*********************************************************
//	***********************
//	DESCRIPTION:
//
//	This class implements a memory mapped datatype for tU32.
//
//	History:
//
//	19.03.01 EFG32-Bruns
//	InitialVersion
//
//	*********************************************************
//	***********************
//## Category: amt::amt_MemoryMappedObjects::amt_StandardTypes%3A8260810047
//## Subsystem: Amt::Include%3A7E97380302
//## Persistence: Transient
//## Cardinality/Multiplicity: n



//## begin amt_tclMU32%3A3E01860275.postscript preserve=yes
//template class amt_tclMappedIntegralType< tU32  >;
//## end amt_tclMU32%3A3E01860275.postscript

//## begin amt_tclMU8%3A3DFE1701E5.preface preserve=yes
//## end amt_tclMU8%3A3DFE1701E5.preface

//## Class: amt_tclMU8%3A3DFE1701E5; Instantiated Class
//	*********************************************************
//	***********************
//	DESCRIPTION:
//
//	This class implements a memory mapped datatype for tU8.
//
//	History:
//
//	19.03.01 EFG32-Bruns
//	InitialVersion
//
//	*********************************************************
//	***********************
//## Category: amt::amt_MemoryMappedObjects::amt_StandardTypes%3A8260810047
//## Subsystem: Amt::Include%3A7E97380302
//## Persistence: Transient
//## Cardinality/Multiplicity: n



//## begin amt_tclMU8%3A3DFE1701E5.postscript preserve=yes
//template class amt_tclMappedIntegralType< tU8  >;
//## end amt_tclMU8%3A3DFE1701E5.postscript

//## begin amt_tclBufferN%3A83C94502D5.preface preserve=yes
//## end amt_tclBufferN%3A83C94502D5.preface

//## Class: amt_tclBufferN%3A83C94502D5
//	*********************************************************
//	***********************
//	DESCRIPTION:
//
//	This class implements a memory mapped datatype for
//	arrays with a maximum of N elements (finite) of type t
//	Char.
//
//	History:
//
//	19.03.01 EFG32-Bruns
//	InitialVersion
//
//	*********************************************************
//	***********************
//## Category: amt::amt_MemoryMappedObjects::amt_StandardTypes%3A8260810047
//## Subsystem: Amt::Include%3A7E97380302
//## Persistence: Transient
//## Cardinality/Multiplicity: n



class amt_tclBufferN : public amt_tclMappableType  //## Inherits: <unnamed>%3A83C999005E
{
  //## begin amt_tclBufferN%3A83C94502D5.initialDeclarations preserve=yes
  //## end amt_tclBufferN%3A83C94502D5.initialDeclarations

  public:
    //## Constructors (specified)
      //## Operation: amt_tclBufferN%3A83C9A70267
      //	*********************************************************
      //	***********************
      //	DESCRIPTION:
      //	Default constructor - inialise internal variables.
      //
      //	PARAMETER:
      //
      //	RETURNVALUE:
      //	-
      //
      //	History:
      //	19.03.01 EFG32-Bruns
      //	InitialVersion
      //	*********************************************************
      //	***********************
      amt_tclBufferN ();
      virtual ~amt_tclBufferN (){};


    //## Other Operations (specified)
      //## Operation: vSetValue%3A83C9BD03BD
      //	*********************************************************
      //	***********************
      //	DESCRIPTION:
      //	Access method for writing a buffer of "u32BufferSize"
      //	bytes into shared memory.
      //
      //	PARAMETER:
      //	amt_tclMappableMessage   *poMMsg   (-> I)
      //	Pointer to the message class which contains this message
      //	field.
      //	tChar    *pcBuffer   (->I)
      //	Pointer to buffer which will be stored in shared memory.
      //
      //	RETURNVALUE:
      //	tVoid
      //
      //	History:
      //	19.03.01 EFG32-Bruns
      //	InitialVersion
      //	*********************************************************
      //	***********************
      tVoid vSetValue (amt_tclMappableMessage* poMMsg, const tChar* pcocBuffer) const;

      //## Operation: bGetValue%3A83C9D003C5
      //	*********************************************************
      //	***********************
      //	DESCRIPTION:
      //	Access method for reading the data buffer of this
      //	message field into a buffer which is given by "pc
      //	Buffer". Retrieves buffer and sets last byte to 0.
      //
      //	PARAMETER:
      //	amt_tclMappableMessage   *prMMsg   (-> I)
      //	Pointer to the message class which contains this message
      //	field.
      //	tChar    *pcBuffer   (->I)
      //	Pointer to buffer which will be stored in shared memory.
      //	tU32   u32MaxLength  (->I)
      //	Maximum length of the buffer pointed to by "pcBuffer".
      //
      //	RETURNVALUE:
      //	TRUE on success, else FALSE
      //
      //	History:
      //	19.03.01 EFG32-Bruns
      //	InitialVersion
      //	*********************************************************
      //	***********************
      tBool bGetValue (const amt_tclMappableMessage* prMMsg, tChar* pcBuffer, tU32 u32MaxLength) const;

      //## Operation: u32Link%3A83C9EB02DD
      //	*********************************************************
      //	***********************
      //	DESCRIPTION:
      //	Reads the index field "u32MaxIndex" (hidden field) from
      //	the current message position (combination of u32Message
      //	Size of the message class and u32Offset from this
      //	message field).
      //
      //	PARAMETER:
      //	amt_tclMappableMessage   *poMMsg   (-> I)
      //	Pointer to the message class which contains this message
      //	field.
      //
      //	RETURNVALUE:
      //	tU32   maximum index stored in the hidden field of the
      //	message (in shared memory)
      //
      //	History:
      //	19.03.01 EFG32-Bruns
      //	InitialVersion
      //	*********************************************************
      //	***********************
      tU32 u32Link (amt_tclMappableMessage* poMMsg);

      //## Operation: vSetBufferSize%3A83C9FF01BA
      tVoid vSetBufferSize (tU32 u32BufferLen);

      //## Operation: u32GetSizeOfType%3A83D75F0023
      //	*********************************************************
      //	***********************
      //	DESCRIPTION:
      //	see amt_tclMappableType.
      //	Returns "u32BufferSize".
      //
      //	History:
      //	19.03.01 EFG32-Bruns
      //	InitialVersion
      //	*********************************************************
      //	***********************
      virtual tU32 u32GetSizeOfType () const;

      //## Operation: u32GetBufferSize%3AB9D20B0232
      tU32 u32GetBufferSize () const;

      //## Operation: vClone%3B14ECE6003A
      //	*********************************************************
      //	***********************
      //	DESCRIPTION:
      //	Copies the contents of this message field into a given
      //	message field which is specified by "pSourceMsg" and "p
      //	SourceBufferN".
      //	!!! Actual NO REALLOCATION is done. So source and target
      //	field must have the same length !!!
      //
      //	PARAMETER:
      //	amt_tclMappableMessage   *poDestiMsg   (-> I)
      //	Pointer to the message class which contains the target
      //	buffer
      //	const amt_tclMappableMessage   *pSourceMsg   (-> I)
      //	Pointer to the message class which contains the source
      //	buffer.
      //	amt_tclBufferN   *pSourceBufferN   (->I)
      //	Pointer to the source buffer field..
      //
      //	RETURNVALUE:
      //	tVoid
      //
      //	History:
      //	19.03.01 EFG32-Bruns
      //	InitialVersion
      //	*********************************************************
      //	***********************
      tVoid vClone (amt_tclMappableMessage* poDestiMsg, const amt_tclMappableMessage* pSourceMsg, const amt_tclBufferN* pSourceBufferN);

      //## Operation: bGetValueRaw%3B8B9C8A00A2
      //	*********************************************************
      //	***********************
      //	DESCRIPTION:
      //	Access method for reading the data buffer of this
      //	message field into a buffer which is given by "pc
      //	Buffer". Retrieves buffer and did not set last byte to 0
      //	(reads raw contents).
      //
      //	PARAMETER:
      //	const amt_tclMappableMessage   *prMMsg   (-> I)
      //	Pointer to the message class which contains this message
      //	field.
      //	tChar    *pcBuffer   (->I)
      //	Pointer to buffer which will be stored in shared memory.
      //	tU32   u32MaxLength  (->I)
      //	Maximum length of the buffer pointed to by "pcBuffer".
      //
      //	RETURNVALUE:
      //	TRUE on success, else FALSE
      //
      //	History:
      //	19.03.01 EFG32-Bruns
      //	InitialVersion
      //	*********************************************************
      //	***********************
      tBool bGetValueRaw (const amt_tclMappableMessage* prMMsg, tChar* pcBuffer, tU32 u32MaxLength) const;

    // Additional Public Declarations
      //## begin amt_tclBufferN%3A83C94502D5.public preserve=yes
      //## end amt_tclBufferN%3A83C94502D5.public

  protected:

    //## Other Operations (specified)
      //## Operation: pcGetDataPointer%3D3D23110238
      tChar * pcGetDataPointer (amt_tclMappableMessage *poMMsg) const;

    // Additional Protected Declarations
      //## begin amt_tclBufferN%3A83C94502D5.protected preserve=yes
      //## end amt_tclBufferN%3A83C94502D5.protected

  private:
    // Data Members for Class Attributes

      //## Attribute: u32BufferSize%3A83D846006B
      //	This attribute contains the length of this message field
      //	(buffer).
      //## begin amt_tclBufferN::u32BufferSize%3A83D846006B.attr preserve=no  private: tU32 {UA}
      tU32 u32BufferSize;
      //## end amt_tclBufferN::u32BufferSize%3A83D846006B.attr

    // Additional Private Declarations
      //## begin amt_tclBufferN%3A83C94502D5.private preserve=yes
      //## end amt_tclBufferN%3A83C94502D5.private

};

//## begin amt_tclBufferN%3A83C94502D5.postscript preserve=yes
//## end amt_tclBufferN%3A83C94502D5.postscript

//## begin amt_tclArrayN%3AB8953602C1.preface preserve=yes
//## end amt_tclArrayN%3AB8953602C1.preface

//## Class: amt_tclArrayN%3AB8953602C1; Parameterized Class
//	*********************************************************
//	***********************
//	DESCRIPTION:
//
//	This class implements a memory mapped datatype for
//	arrays with a maximum of N elements (finite) of type T
//	(container). For further documentation see "amt_tclBuffer
//	N"...
//
//	History:
//
//	19.03.01 EFG32-Bruns
//	InitialVersion
//
//	*********************************************************
//	***********************
//## Category: amt::amt_MemoryMappedObjects::amt_StandardTypes%3A8260810047
//## Subsystem: Amt::Include%3A7E97380302
//## Persistence: Transient
//## Cardinality/Multiplicity: n



template <class T>
class amt_tclArrayN : public amt_tclMappableType  //## Inherits: <unnamed>%3AB896A801AA
{
  //## begin amt_tclArrayN%3AB8953602C1.initialDeclarations preserve=yes
  //## end amt_tclArrayN%3AB8953602C1.initialDeclarations

  public:
    //## Constructors (specified)
      //## Operation: amt_tclArrayN%3AB895DC02A1
      //	*********************************************************
      //	***********************
      //	DESCRIPTION:
      //	Default constructor - inialise internal variables.
      //
      //	PARAMETER:
      //
      //	RETURNVALUE:
      //	-
      //
      //	History:
      //	19.03.01 EFG32-Bruns
      //	InitialVersion
      //	*********************************************************
      //	***********************
      amt_tclArrayN ();


    //## Other Operations (specified)
      //## Operation: u32GetSizeOfType%3AB895E8010E
      //	*********************************************************
      //	***********************
      //	DESCRIPTION:
      //	see amt_tclMappableType.
      //	(Returns: sizeof(tU32) (for hidden maxIndex field) +
      //	u32MaxIndex * sizeof(T))
      //
      //	History:
      //	19.03.01 EFG32-Bruns
      //	InitialVersion
      //	*********************************************************
      //	***********************
      virtual tU32 u32GetSizeOfType () const;

      //## Operation: bSetElement%3AB896240092
      //	*********************************************************
      //	***********************
      //	DESCRIPTION:
      //	Access method for writing into a specific array element
      //	in shared memory.
      //
      //	PARAMETER:
      //	amt_tclMappableMessage   *prMMsg   (-> I)
      //	Pointer to the message class which contains this message
      //	field.
      //	tU32   u32Index
      //	The index of the field in which to write to.
      //	T   value
      //	Value which should be written
      //
      //	RETURNVALUE:
      //	TRUE on success, else FALSE
      //
      //	History:
      //	19.03.01 EFG32-Bruns
      //	InitialVersion
      //	*********************************************************
      //	***********************
      tBool bSetElement (amt_tclMappableMessage* prMMsg, tU32 u32Index, T value);

      //## Operation: bGetElement%3AB8967300D2
      //	*********************************************************
      //	***********************
      //	DESCRIPTION:
      //	Access method for reading from a specific array element
      //	in shared memory.
      //
      //	PARAMETER:
      //	const amt_tclMappableMessage   *prMMsg   (-> I)
      //	Pointer to the message class which contains this message
      //	field.
      //	T   *pResult
      //	Pointer to Element or buffer of type T which will
      //	contain the contents of the shared memory field at index
      //	"u32Index".
      //	tU32   u32Index
      //	The index of the field from which to write to.
      //	T   value
      //	Value which should be written
      //
      //	RETURNVALUE:
      //	TRUE on success, else FALSE
      //
      //	History:
      //	19.03.01 EFG32-Bruns
      //	InitialVersion
      //	*********************************************************
      //	***********************
      tBool bGetElement (const amt_tclMappableMessage* prMMsg, T* pResult, const tU32 u32Index) const;

      //## Operation: u32Link%3AB89702034E
      //	*********************************************************
      //	***********************
      //	DESCRIPTION:
      //	Reads the length field "u32MaxIndex" (the hidden length)
      //	from the current message position (combination of
      //	u32MessageSize of the class and u32Offset from this
      //	message field).
      //
      //	PARAMETER:
      //	amt_tclMappableMessage   *prMMsg   (-> I)
      //	Pointer to the message class which contains this message
      //	field.
      //
      //	RETURNVALUE:
      //	tU32   length stored in the length field of the message
      //	(in shared memory)
      //
      //	History:
      //	19.03.01 EFG32-Bruns
      //	InitialVersion
      //	*********************************************************
      //	***********************
      tU32 u32Link (amt_tclMappableMessage* prMMsg);

      //## Operation: vSetMaxIndex%3AB89744008C
      tVoid vSetMaxIndex (tU32 u32NewMaxIndex);

      //## Operation: u32GetMaxIndex%3AB8A8580291
      tU32 u32GetMaxIndex () const;

      //	*********************************************************
      //	DESCRIPTION:
      //	Write the length field "u32MaxIndex" (the hidden length)
      //	into the message field.
      //
      //	PARAMETER:
      //	amt_tclMappableMessage   *prMMsg   (-> I)
      //	Pointer to the message class which contains this message
      //	field.
      //
      //	RETURNVALUE: tBool
      //	TRUE on success, else FALSE
      //
      //	History:
      //	28.05.04 CM-DI/ESA1-Fischer
      //	InitialVersion
      //	*********************************************************
      tBool bWriteMaxIndex (amt_tclMappableMessage* prMMsg);


      //## Operation: vClone%3BB9A80701BA
      //	*********************************************************
      //	***********************
      //	DESCRIPTION:
      //	Copies the contents of this message field into a given
      //	message field which is specified by "pSourceMsg" and "p
      //	SourceArrayN".
      //	!!! Actual NO REALLOCATION is done. So source and target
      //	field must have the same length !!!
      //
      //	PARAMETER:
      //	amt_tclMappableMessage   *pDestiMsg   (-> I)
      //	Pointer to the message class which contains the target
      //	buffer
      //	const amt_tclMappableMessage   *pSourceMsg   (-> I)
      //	Pointer to the message class which contains the source
      //	buffer.
      //	amt_tclArrayN   *pSourceArrayN   (->I)
      //	Pointer to the source buffer field..
      //
      //	RETURNVALUE:
      //	tVoid
      //
      //	History:
      //	19.03.01 EFG32-Bruns
      //	InitialVersion
      //	*********************************************************
      //	***********************
      tVoid vClone (amt_tclMappableMessage* pDestiMsg, const amt_tclMappableMessage* pSourceMsg, const amt_tclArrayN* pSourceArrayN);

    // Additional Public Declarations
      //## begin amt_tclArrayN%3AB8953602C1.public preserve=yes
      //## end amt_tclArrayN%3AB8953602C1.public

  private:
    // Data Members for Class Attributes

      //## Attribute: u32MaxIndex%3AB896E000C4
      //## begin amt_tclArrayN::u32MaxIndex%3AB896E000C4.attr preserve=no  private: tU32 {UA}
      tU32 u32MaxIndex;
      //## end amt_tclArrayN::u32MaxIndex%3AB896E000C4.attr

    // Additional Private Declarations
      //## begin amt_tclArrayN%3AB8953602C1.private preserve=yes
      //## end amt_tclArrayN%3AB8953602C1.private

};

//## begin amt_tclArrayN%3AB8953602C1.postscript preserve=yes
//## end amt_tclArrayN%3AB8953602C1.postscript

//## begin amt_tclMS8%3BB97DFB0126.preface preserve=yes
//## end amt_tclMS8%3BB97DFB0126.preface

//## Class: amt_tclMS8%3BB97DFB0126; Instantiated Class
//	*********************************************************
//	***********************
//	DESCRIPTION:
//
//	This class implements a memory mapped datatype for tS8.
//
//	History:
//
//	19.03.01 EFG32-Bruns
//	InitialVersion
//
//	*********************************************************
//	***********************
//## Category: amt::amt_MemoryMappedObjects::amt_StandardTypes%3A8260810047
//## Subsystem: Amt::Include%3A7E97380302
//## Persistence: Transient
//## Cardinality/Multiplicity: n



//## begin amt_tclMS8%3BB97DFB0126.postscript preserve=yes
//template class amt_tclMappedIntegralType< tS8  >;
//## end amt_tclMS8%3BB97DFB0126.postscript

//## begin amt_tclMS16%3BB97FE1005D.preface preserve=yes
//## end amt_tclMS16%3BB97FE1005D.preface

//## Class: amt_tclMS16%3BB97FE1005D; Instantiated Class
//	*********************************************************
//	***********************
//	DESCRIPTION:
//
//	This class implements a memory mapped datatype for tS16.
//
//	History:
//
//	19.03.01 EFG32-Bruns
//	InitialVersion
//
//	*********************************************************
//	***********************
//## Category: amt::amt_MemoryMappedObjects::amt_StandardTypes%3A8260810047
//## Subsystem: Amt::Include%3A7E97380302
//## Persistence: Transient
//## Cardinality/Multiplicity: n



//## begin amt_tclMS16%3BB97FE1005D.postscript preserve=yes
//template class amt_tclMappedIntegralType< tS16  >;
//## end amt_tclMS16%3BB97FE1005D.postscript

//## begin amt_tclMS32%3BB97FFF010A.preface preserve=yes
//## end amt_tclMS32%3BB97FFF010A.preface

//## Class: amt_tclMS32%3BB97FFF010A; Instantiated Class
//	*********************************************************
//	***********************
//	DESCRIPTION:
//
//	This class implements a memory mapped datatype for tS32.
//
//	History:
//
//	19.03.01 EFG32-Bruns
//	InitialVersion
//
//	*********************************************************
//	***********************
//## Category: amt::amt_MemoryMappedObjects::amt_StandardTypes%3A8260810047
//## Subsystem: Amt::Include%3A7E97380302
//## Persistence: Transient
//## Cardinality/Multiplicity: n



//## begin amt_tclMS32%3BB97FFF010A.postscript preserve=yes
//template class amt_tclMappedIntegralType< tS32  >;
//## end amt_tclMS32%3BB97FFF010A.postscript

//## begin amt_tclMF16%3BB9808100F3.preface preserve=yes
//## end amt_tclMF16%3BB9808100F3.preface

//## Class: amt_tclMF16%3BB9808100F3; Instantiated Class
//	*********************************************************
//	***********************
//	DESCRIPTION:
//
//	This class implements a memory mapped datatype for t
//	Float (16 Bit).
//
//	History:
//
//	19.03.01 EFG32-Bruns
//	InitialVersion
//
//	*********************************************************
//	***********************
//## Category: amt::amt_MemoryMappedObjects::amt_StandardTypes%3A8260810047
//## Subsystem: Amt::Include%3A7E97380302
//## Persistence: Transient
//## Cardinality/Multiplicity: n



//## begin amt_tclMF16%3BB9808100F3.postscript preserve=yes
//template class amt_tclMappedIntegralType< tFloat  >;
//## end amt_tclMF16%3BB9808100F3.postscript

//## begin amt_tclMF32%3BB980B301EF.preface preserve=yes
//## end amt_tclMF32%3BB980B301EF.preface

//## Class: amt_tclMF32%3BB980B301EF; Instantiated Class
//	*********************************************************
//	***********************
//	DESCRIPTION:
//
//	This class implements a memory mapped datatype for t
//	Double (32 Bit).
//
//	History:
//
//	19.03.01 EFG32-Bruns
//	InitialVersion
//
//	*********************************************************
//	***********************
//## Category: amt::amt_MemoryMappedObjects::amt_StandardTypes%3A8260810047
//## Subsystem: Amt::Include%3A7E97380302
//## Persistence: Transient
//## Cardinality/Multiplicity: n



//## begin amt_tclMF32%3BB980B301EF.postscript preserve=yes
//template class amt_tclMappedIntegralType< tDouble  >;
//## end amt_tclMF32%3BB980B301EF.postscript

//## begin amt_tclMF64%3BB980DA0155.preface preserve=yes
//## end amt_tclMF64%3BB980DA0155.preface

//## Class: amt_tclMF64%3BB980DA0155; Instantiated Class
//	*********************************************************
//	***********************
//	DESCRIPTION:
//
//	This class implements a memory mapped datatype for t
//	LDouble (64 Bit).
//
//	History:
//
//	19.03.01 EFG32-Bruns
//	InitialVersion
//
//	*********************************************************
//	***********************
//## Category: amt::amt_MemoryMappedObjects::amt_StandardTypes%3A8260810047
//## Subsystem: Amt::Include%3A7E97380302
//## Persistence: Transient
//## Cardinality/Multiplicity: n



//## begin amt_tclMF64%3BB980DA0155.postscript preserve=yes
//template class amt_tclMappedIntegralType< tLDouble  >;
//## end amt_tclMF64%3BB980DA0155.postscript

//## begin amt_tclMBool%3BB981CB0210.preface preserve=yes
//## end amt_tclMBool%3BB981CB0210.preface

//## Class: amt_tclMBool%3BB981CB0210; Instantiated Class
//	*********************************************************
//	***********************
//	DESCRIPTION:
//
//	This class implements a memory mapped datatype for tBool.
//
//	History:
//
//	19.03.01 EFG32-Bruns
//	InitialVersion
//
//	*********************************************************
//	***********************
//## Category: amt::amt_MemoryMappedObjects::amt_StandardTypes%3A8260810047
//## Subsystem: Amt::Include%3A7E97380302
//## Persistence: Transient
//## Cardinality/Multiplicity: n



//## begin amt_tclMBool%3BB981CB0210.postscript preserve=yes
//
// REMARK:
//---------
// Due to typedef of "tBool" to "unsigned char" the following line
// MUST NOT be coded. If coded warning "C4660: template-class
// specialization 'amt_tclMappedIntegralType<unsigned char>' is
// already instantiated" will be produced!!
//
// template class amt_tclMappedIntegralType< tBool  >;
//
//## end amt_tclMBool%3BB981CB0210.postscript

// Class amt_tclMappableType

// Class amt_tclMappableMessage


//## Other Operations (inline)
inline tU8* amt_tclMappableMessage::pu8GetSharedMemBase () const
{
  //## begin amt_tclMappableMessage::pu8GetSharedMemBase%3A715A9800D3.body preserve=yes
   return pu8SharedMemBase;
  //## end amt_tclMappableMessage::pu8GetSharedMemBase%3A715A9800D3.body
} //lint !e1763: Member function marked as const indirectly modifies class --> would need changes in all clients

inline tU32 amt_tclMappableMessage::u32GetDynMsgSize () const
{
  //## begin amt_tclMappableMessage::u32GetDynMsgSize%3A715B340381.body preserve=yes
   return u32DynMsgSize;
  //## end amt_tclMappableMessage::u32GetDynMsgSize%3A715B340381.body
}

inline tVoid amt_tclMappableMessage::vSetDynMsgSize (tU32 u32MsgSize)
{
  //## begin amt_tclMappableMessage::vSetDynMsgSize%3AB9C8F80355.body preserve=yes
  u32DynMsgSize = u32MsgSize;
  //## end amt_tclMappableMessage::vSetDynMsgSize%3AB9C8F80355.body
}

inline tVoid amt_tclMappableMessage::vAddDynMsgSize (tU32 u32AdditionalSize)
{
  //## begin amt_tclMappableMessage::vAddDynMsgSize%3B7A19DA02FE.body preserve=yes
   u32DynMsgSize +=u32AdditionalSize;
  //## end amt_tclMappableMessage::vAddDynMsgSize%3B7A19DA02FE.body
}

// Parameterized Class amt_tclMappedIntegralType

// Class amt_tclBufferN

// Parameterized Class amt_tclArrayN

// Parameterized Class amt_tclMappedIntegralType

template <class T>
amt_tclMappedIntegralType<T>::amt_tclMappedIntegralType ()
  //## begin amt_tclMappedIntegralType::amt_tclMappedIntegralType%3A3DEA26014E.hasinit preserve=no
  //## end amt_tclMappedIntegralType::amt_tclMappedIntegralType%3A3DEA26014E.hasinit
  //## begin amt_tclMappedIntegralType::amt_tclMappedIntegralType%3A3DEA26014E.initialization preserve=yes
  //## end amt_tclMappedIntegralType::amt_tclMappedIntegralType%3A3DEA26014E.initialization
{
  //## begin amt_tclMappedIntegralType::amt_tclMappedIntegralType%3A3DEA26014E.body preserve=yes
  //## end amt_tclMappedIntegralType::amt_tclMappedIntegralType%3A3DEA26014E.body
}



//## Other Operations (implementation)
template <class T>
tU32 amt_tclMappedIntegralType<T>::u32GetSizeOfType () const
{
  //## begin amt_tclMappedIntegralType::u32GetSizeOfType%3A3DEA360198.body preserve=yes
  return sizeof(T);
  //## end amt_tclMappedIntegralType::u32GetSizeOfType%3A3DEA360198.body
}

#ifdef __GNUC__
   #pragma GCC diagnostic push
   #pragma GCC diagnostic ignored "-Wmaybe-uninitialized"
   // ksm2hi, 16.07.2018, deactivated compiler warning
   // warning : 'oTemporaryObject' may be used uninitialized in this function [-Wmaybe-uninitialized]
   // The template class for amt_tclMappedIntegralTypecould consists of simple data types OR structs OR objects.
   // For each of these data types the way of initializing the data item oTemporaryObject would be different (constructor or assignment of 0) and therefore the way of initialization can not be defined in advance.
   // Decision : We keep the automatic variable oTemporaryObject of method amt_tclMappedIntegralType<T>::nGetValue() unititialized.
   // Hint : This warning was even reported by LINT and even there we had an exceptional deactivation of the LINT warning.
#endif

template <class T>
tVoid amt_tclMappedIntegralType<T>::vSetValue (amt_tclMappableMessage* poMMsg, T value)
{
  //## begin amt_tclMappedIntegralType::vSetValue%3A3DEA4D0046.body preserve=yes
   if (  poMMsg
      && poMMsg->pu8GetSharedMemBase())
   {
      // REMARK: do aligned copy of data --> use memcpy
      OSAL_pvMemoryCopy((tPVoid)((poMMsg->pu8GetSharedMemBase())+u32Offset), (tPCVoid)&value, sizeof(T)); //lint !e522: Expected void type, assignment, increment or decrement
   }
  //## end amt_tclMappedIntegralType::vSetValue%3A3DEA4D0046.body
} //lint !e818 !e1762: 818:Pointer parameter 'poMMsg' could be declared as pointing to const 1762: Member function could be made const


#ifdef _MSC_VER
#pragma warning(push)
#pragma warning( disable : 4701 ) // error C4701: potentially uninitialized local variable 'oTemporaryObject' used
// for some reason those pragmas cannot be inside nGetValue - possibly because it's a template
#endif

template <class T>
T amt_tclMappedIntegralType<T>::nGetValue (const amt_tclMappableMessage* prMMsg) const
{
  //## begin amt_tclMappedIntegralType::nGetValue%3A3DEA760334.body preserve=yes

   T oTemporaryObject;
   if (  prMMsg
      && prMMsg->pu8GetSharedMemBase())
   {
      // REMARK: do aligned copy of data --> use memcpy
      OSAL_pvMemoryCopy((tPVoid)&oTemporaryObject,
                        (tPCVoid)((prMMsg->pu8GetSharedMemBase())+u32Offset),
                        sizeof(T)); //lint !e522: Expected void type, assignment, increment or decrement
   }
   return oTemporaryObject;//lint !e644
                           //             Variable 'oTemporaryObject' may not have been initialized
                           //             This couldn't be done because T can be a structure/object
                           //             or a simple type (init with c'tor or with assignment of 0)
  //## end amt_tclMappedIntegralType::nGetValue%3A3DEA760334.body
}

#ifdef _MSC_VER
#pragma warning(pop)
#endif 

#ifdef __GNUC__
   #pragma GCC diagnostic pop
#endif

// Additional Declarations
  //## begin amt_tclMappedIntegralType%3A3DE9C80013.declarations preserve=yes
  //## end amt_tclMappedIntegralType%3A3DE9C80013.declarations

// Parameterized Class amt_tclArrayN

template <class T>
amt_tclArrayN<T>::amt_tclArrayN ()
  //## begin amt_tclArrayN::amt_tclArrayN%3AB895DC02A1.hasinit preserve=no
  //## end amt_tclArrayN::amt_tclArrayN%3AB895DC02A1.hasinit
  //## begin amt_tclArrayN::amt_tclArrayN%3AB895DC02A1.initialization preserve=yes
  //## end amt_tclArrayN::amt_tclArrayN%3AB895DC02A1.initialization
{
  //## begin amt_tclArrayN::amt_tclArrayN%3AB895DC02A1.body preserve=yes
   u32MaxIndex = 0;
  //## end amt_tclArrayN::amt_tclArrayN%3AB895DC02A1.body
}



//## Other Operations (implementation)
template <class T>
tU32 amt_tclArrayN<T>::u32GetSizeOfType () const
{
  //## begin amt_tclArrayN::u32GetSizeOfType%3AB895E8010E.body preserve=yes
   // The langth of the array is stored at the front of the buffer. If the
   // message is posted to a client this first field is read to determine
   // the lentgh of the data region for the string in the message.
   tU32 nLengthOverall = sizeof(tU32)              // first tU32 is used for
                                                   // string length
                       + u32MaxIndex * sizeof(T);  // length of data region
   return (nLengthOverall);
  //## end amt_tclArrayN::u32GetSizeOfType%3AB895E8010E.body
}

template <class T>
tBool amt_tclArrayN<T>::bSetElement (amt_tclMappableMessage* prMMsg, tU32 u32Index, T value)
{
  //## begin amt_tclArrayN::bSetElement%3AB896240092.body preserve=yes

   if (  prMMsg
      && prMMsg->pu8GetSharedMemBase())
   {
      // region check...
      if( u32Index < u32MaxIndex )
      {
         // first: set the length of the string in the first tU32 field
         tPU8 pu8MaxIndexField32 = (tPU8)(prMMsg->pu8GetSharedMemBase())+u32Offset;

         // REMARK: do aligned copy of data --> use memcpy

         OSAL_pvMemoryCopy((tPVoid)pu8MaxIndexField32, (tPCVoid)&u32MaxIndex, sizeof(tU32));

         // copy data to message's data region
         tPU8 pu8DataRegion = (tPU8)
                              ((prMMsg->pu8GetSharedMemBase())   // the base
                              + u32Offset
                              + sizeof(tU32)                   // the maxIndex
                              + (u32Index * sizeof(T)));       // move in array

         // REMARK: do aligned copy of data --> use memcpy

         OSAL_pvMemoryCopy((tPVoid)pu8DataRegion, (tPCVoid)&value, sizeof(T));
         return TRUE;
      }
   }
   // if index exceeds array size or NULL-pointer --> FALSE
   return FALSE;
  //## end amt_tclArrayN::bSetElement%3AB896240092.body
}

template <class T>
tBool amt_tclArrayN<T>::bWriteMaxIndex (amt_tclMappableMessage* prMMsg)
{
   tBool bSuccess = FALSE;
   if (  prMMsg
      && prMMsg->pu8GetSharedMemBase())
   {
      // set the length of the string in the first tU32 field
      tPU8 pu8MaxIndexField32 = (tPU8)(prMMsg->pu8GetSharedMemBase())+u32Offset;

      // REMARK: do aligned copy of data --> use memcpy

      OSAL_pvMemoryCopy((tPVoid)pu8MaxIndexField32, (tPCVoid)&u32MaxIndex, sizeof(tU32));

      bSuccess = TRUE;
   } // else NULL-pointer or msg-memory not allocated --> FALSE
   return (bSuccess);
}

template <class T>
tBool amt_tclArrayN<T>::bGetElement (const amt_tclMappableMessage* prMMsg, T* pResult, const tU32 u32Index) const
{
  //## begin amt_tclArrayN::bGetElement%3AB8967300D2.body preserve=yes
   if (  prMMsg
      && prMMsg->pu8GetSharedMemBase())
   {
      // region check...
      if( u32Index < u32MaxIndex )
      {
         // Simply read the data region. The maximum lentgh must have been set by
         // calling "u32Link" at the appropriate time. nLink ensures that
         // "u32MaxIndex" has the correct value.
         tPCU8 pcou8DataRegion = (tPCU8)(
                                    prMMsg->pu8GetSharedMemBase()  // the base
                                  + u32Offset                      // start of field
                                  + sizeof(tU32)                   // field "maxIndex"
                                  + (u32Index * sizeof(T)));       // move in array

         // REMARK: do aligned copy of data --> use memcpy

         OSAL_pvMemoryCopy((tPVoid)pResult, (tPCVoid)pcou8DataRegion, sizeof(T));
         return TRUE;
      }
   }

   // if index exceeds array size or NULL-pointer --> FALSE
   return FALSE;
  //## end amt_tclArrayN::bGetElement%3AB8967300D2.body
}

template <class T>
tU32 amt_tclArrayN<T>::u32Link (amt_tclMappableMessage* prMMsg)
{
  //## begin amt_tclArrayN::u32Link%3AB89702034E.body preserve=yes
   if (  prMMsg
      && prMMsg->pu8GetSharedMemBase())
   {
      // "u32Link" simply updates the u32MaxIndex field by reading the first tU32
      // of the atual message position.
      // Thus "u32Link" MUST (!!!) be called after all preceeding types have been
      // added to the message (by vAddType) and the message's actual size is at
      // the beginning of the String --> the string length is coded in the next
      // tU32 field of the message and can be read out.
      tPU8 pu8LengthField32 =   (tPU8)( (prMMsg->pu8GetSharedMemBase())
                              + (prMMsg->u32GetDynMsgSize()) );

      // REMARK: do aligned copy of data --> use memcpy

      tU32 u32StoredLength;
      OSAL_pvMemoryCopy((tPVoid)&u32StoredLength, (tPCVoid)pu8LengthField32, sizeof(tU32));

      u32MaxIndex = u32StoredLength;

      return u32StoredLength;
   }
   else
   {
      u32MaxIndex = 0;
      return 0;
   }
  //## end amt_tclArrayN::u32Link%3AB89702034E.body
}

template <class T>
tVoid amt_tclArrayN<T>::vSetMaxIndex (tU32 u32NewMaxIndex)
{
  //## begin amt_tclArrayN::vSetMaxIndex%3AB89744008C.body preserve=yes
   u32MaxIndex = u32NewMaxIndex;
  //## end amt_tclArrayN::vSetMaxIndex%3AB89744008C.body
}

template <class T>
tU32 amt_tclArrayN<T>::u32GetMaxIndex () const
{
  //## begin amt_tclArrayN::u32GetMaxIndex%3AB8A8580291.body preserve=yes
   return u32MaxIndex;
  //## end amt_tclArrayN::u32GetMaxIndex%3AB8A8580291.body
}

template <class T>
tVoid amt_tclArrayN<T>::vClone (amt_tclMappableMessage* pDestiMsg, const amt_tclMappableMessage* pSourceMsg, const amt_tclArrayN* pSourceArrayN)
{
  //## begin amt_tclArrayN::vClone%3BB9A80701BA.body preserve=yes

   if (  pDestiMsg
      && pSourceMsg
      && pSourceArrayN
      && pSourceMsg->pu8GetSharedMemBase() )
   {
      // copy size field, assumes correct length in source (!)
      u32MaxIndex          = pSourceArrayN->u32MaxIndex;
      tU32 u32FieldSize    =   sizeof(tU32)                               // first tU32 is used for "maxIndex"
                             + (pSourceArrayN->u32MaxIndex * sizeof(T));  // Rest is data region

      // copy whole data including size field
      tPCU8 pcou8SourceField = (tPCU8)( pSourceMsg->pu8GetSharedMemBase()
                                      + pSourceArrayN->u32Offset);
      tPU8  pu8DestiField  =   (tPU8) ( pDestiMsg->pu8GetSharedMemBase()
                                      + pSourceArrayN->u32Offset);

      // REMARK: do aligned copy of data --> use memcpy

      OSAL_pvMemoryCopy((tPVoid)pu8DestiField, (tPCVoid)pcou8SourceField, u32FieldSize);
   }
  //## end amt_tclArrayN::vClone%3BB9A80701BA.body
}

// Additional Declarations
  //## begin amt_tclArrayN%3AB8953602C1.declarations preserve=yes
  //## end amt_tclArrayN%3AB8953602C1.declarations

//## begin module%3A3E1DE200C6.epilog preserve=yes
//## end module%3A3E1DE200C6.epilog

typedef amt_tclMappedIntegralType< tU16  > amt_tclMU16;
typedef amt_tclMappedIntegralType< tU32  > amt_tclMU32;
typedef amt_tclMappedIntegralType< tU8  > amt_tclMU8;
typedef amt_tclMappedIntegralType< tS8  > amt_tclMS8;
typedef amt_tclMappedIntegralType< tS16  > amt_tclMS16;
typedef amt_tclMappedIntegralType< tS32  > amt_tclMS32;
typedef amt_tclMappedIntegralType< tFloat  > amt_tclMF16;
typedef amt_tclMappedIntegralType< tDouble  > amt_tclMF32;
typedef amt_tclMappedIntegralType< tLDouble  > amt_tclMF64;
typedef amt_tclMappedIntegralType< tBool  > amt_tclMBool;

#endif
