/******************************************************************************
 * FILE: ail_basics.h         
 * SW-COMPONENT:  AIL
 * DESCRIPTION:  
 * AUTHOR:        
 * COPYRIGHT:     (c) 2001 Robert Bosch GmbH, Hildesheim
 * HISTORY:      
 ******************************************************************************/

#ifndef AIL_BASICS_HEADER
#define AIL_BASICS_HEADER

#ifdef __cplusplus
extern "C"{
#endif

/******************************************************************************
| includes of component-internal interface, if necessary
| (scope: component-local)
|-----------------------------------------------------------------------------*/

/******************************************************************************
| defines and macros (scope: global)
|-----------------------------------------------------------------------------*/

/******************************************************************************
| typedefs (scope: global)
|-----------------------------------------------------------------------------*/

/******************************************************************************
| typedefs (scope: modul-local)
|-----------------------------------------------------------------------------*/

/*******************************************************************************
| variable declaration (scope: global)
|-----------------------------------------------------------------------------*/

/*******************************************************************************
| function prototypes (scope: global)
|-----------------------------------------------------------------------------*/


tU32 
ail_bIpcMessagePost
(
   tU16 u16MyAppId,
   OSAL_tMQueueHandle hMQ, 
   amt_tclBaseMessage* poMsgObject, 
   tU32 u32Prio
);


tBool 
ail_bIpcMessageWait
(
   tU16 u16MyAppId,
   OSAL_tMQueueHandle hMQ,
   amt_tclBaseMessage *poMsgObject,
   tU32 *pu32Prio,
   OSAL_tMSecond rTimeout
);

tBool 
ail_bConnectApplicationQueue
(
   tU16 u16MyAppId,
   OSAL_tMQueueHandle* phOutQueue,
   tU16 u16DestinationAppId
);

tVoid 
ail_vIpcClearMessageQueue
(
   tU16 u16MyAppId,
   OSAL_tMQueueHandle hMQ
);

tCString ail_coszServiceStatus( tU8 u8ServiceStatus );

tCString ail_coszServiceRegisterConf( tU8 u8ServiceRegisterConf );

tCString ail_coszAppStatus( tU32 u32AppStatus );

tCString ail_coszCVMStatus( tU32 u32CVMStatus );

tCString ail_coszCommunicationError( const ail_tenCommunicationError &corfenCommunicationError );

tCString ail_coszOSALError( tU32 u32OsalError );


#ifdef __cplusplus
}
#endif

#endif


