//## begin module%1.4%.codegen_version preserve=yes
//   Read the documentation to learn more about C++ code generator
//   versioning.
//## end module%1.4%.codegen_version

//## begin module%3A841CA6024A.cm preserve=no
//	  %X% %Q% %Z% %W%
//## end module%3A841CA6024A.cm

//## begin module%3A841CA6024A.cp preserve=no
//## end module%3A841CA6024A.cp

//## Module: ail_Storage%3A841CA6024A; Subprogram specification
//## Subsystem: Ail::Include%3A841A9E02B0
//## Source file: e:\vasco\components\Ail\Include\ail_Storage.h

#ifndef ail_Storage_h
#define ail_Storage_h 1

//## begin module%3A841CA6024A.additionalIncludes preserve=no
//## end module%3A841CA6024A.additionalIncludes

//## begin module%3A841CA6024A.includes preserve=yes
//## end module%3A841CA6024A.includes

//## begin module%3A841CA6024A.declarations preserve=no
//## end module%3A841CA6024A.declarations

//## begin module%3A841CA6024A.additionalDeclarations preserve=yes

/*****************************************************************************
 * SynchronAnswers types
 *****************************************************************************/
typedef enum {
               AIL_EN_U16_SYNC_MESSAGE_ANSWER = 0,
               AIL_EN_U16_SYNC_REGISTRATION_INVALID,
               AIL_EN_U16_SYNC_SERVICE_NOT_AVAILABLE,
               AIL_EN_U16_SYNC_UNDEFINED_ABORT,
               AIL_EN_U16_SYNC_UNINITIALIZED = 0xFF
} ail_tenSyncAnswerType;

typedef enum {
               AIL_EN_POOLSEM_UNINITIALIZED = 0,
               AIL_EN_POOLSEM_CREATED,
               AIL_EN_POOLSEM_USED,
               AIL_EN_POOLSEM_DELETED
} ail_tenPoolSemStatus;

typedef enum {
               AIL_EN_SERVER_APP_STATE_UNAVAILABLE = 0,      // AMT_C_U8_CCAMSG_SUPPLIER_STATE_UNAVAILABLE     (tU8)0
               AIL_EN_SERVER_APP_STATE_AVAILABLE,            // AMT_C_U8_CCAMSG_SUPPLIER_STATE_AVAILABLE       (tU8)1
               AIL_EN_SERVER_APP_STATE_UNKNOWN,              // AMT_C_U8_CCAMSG_SUPPLIER_STATE_UNKNOWN         (tU8)2
               AIL_EN_SERVER_APP_STATE_ERROR,                // AMT_C_U8_CCAMSG_SUPPLIER_STATE_ERROR           (tU8)3
               AIL_EN_SERVER_APP_STATE_DOES_NOT_EXIST,       // AMT_C_U8_CCAMSG_SUPPLIER_STATE_DOES_NOT_EXIST  (tU8)4
               AIL_EN_SERVER_APP_STATE_REQUESTED
} ail_tenServerAppState;

/*****************************************************************************
 * CallBack function type for service availability
 *****************************************************************************/
typedef tVoid (*ail_tpfCallBack)(tU8 u8ServiceAvailability);

/*****************************************************************************
 * handle for access to watchdog
 *****************************************************************************/
typedef tU32 ail_tWdgHandle;

//## end module%3A841CA6024A.additionalDeclarations

class ail_tclServiceRequest
{
  public:

    ail_tclServiceRequest();
    ail_tclServiceRequest(tU16 u16SourceSubId,
                          tU16 u16ServiceMajorVersion,
                          tU16 u16ServiceMinorVersion);

    tBool                  operator != (const ail_tclServiceRequest& oServiceRequest) const;
    ail_tclServiceRequest& operator  = (const ail_tclServiceRequest& oServiceRequest);

    tU16 u16GetClientSubId()         { return m_u16ClientSubId;         }
    tU16 u16GetServiceMajorVersion() { return m_u16ServiceMajorVersion; }
    tU16 u16GetServiceMinorVersion() { return m_u16ServiceMinorVersion; }
    tBool bIsRegistrationConfirmed()  { return m_bRegistrationConfirmed; }

    tVoid vSetRegistrationConfirmed(tBool bRegistrationConfirmed)
    {
      m_bRegistrationConfirmed = bRegistrationConfirmed;
    }

  private:

    tU16  m_u16ClientSubId;
    tU16  m_u16ServiceMajorVersion;
    tU16  m_u16ServiceMinorVersion;
    tBool m_bRegistrationConfirmed;
};

class ail_tclServerApplication
{
  public:

    ail_tclServerApplication();
    ail_tclServerApplication(tU16 u16ServerAppId,
                             tU16 u16ServiceId,
                             tBool bDedicatdedServer,
                             const ail_tclServiceRequest& roServiceRequest,
                             ail_tenServerAppState enServerAppState);

    ~ail_tclServerApplication();

    ail_tclServerApplication(const ail_tclServerApplication& roServerApplicationCopy);

    tBool                     operator != (const ail_tclServerApplication& roServerApplication) const;
    ail_tclServerApplication& operator  = (const ail_tclServerApplication& roServerApplication);

    tU16                          u16GetAppId()             const { return m_u16AppId; }
    tU16                          u16GetServiceId()         const { return m_u16ServiceId; }
    tBool                         bIsDedicatedServer()      const { return m_bDedicatedServer; }
    ail_tenServerAppState         enGetServerAppState()     const { return m_enServerAppState; }
    ail_tclServiceRequestList*    poGetServiceRequestList() const { return m_poServiceRequestList; }

    tVoid vSetServerAppState(ail_tenServerAppState enServerAppState)
    {
      m_enServerAppState = enServerAppState;
    }

    tVoid vSetAppId(tU16 u16AppId) { m_u16AppId  = u16AppId;  }

    tVoid vAddServiceRequest(const ail_tclServiceRequest& roServiceRequest);

  private:

    tU16                        m_u16AppId;
    tU16                        m_u16ServiceId;
    tBool                       m_bDedicatedServer;
    ail_tclServiceRequestList*  m_poServiceRequestList;
    ail_tenServerAppState       m_enServerAppState;
};

//## Class: ail_tclServiceReference%3A41D7DB00FE
//## Category: AIL::ListWorking%3A41C6070033
//## Subsystem: Ail::Include%3A841A9E02B0
//## Persistence: Transient
//## Cardinality/Multiplicity: n



class ail_tclServiceReference 
{
  public:
    //## Constructors (specified)
      //## Operation: ail_tclServiceReference%3A76A1890340
      ail_tclServiceReference (tU16 u16NewAppId, tU16 u16NewServiceId, tU16 u16NewRegisterId, tU16 u16NewSubId);

      //## Operation: ail_tclServiceReference%3AB07CDE037C
      ail_tclServiceReference ();


    //## Other Operations (specified)
      //## Operation: operator !=%3A76D3D60382
      tBool operator != (const ail_tclServiceReference& oServiceReference) const;

      //## Operation: operator =%3AB07D2301FE
      ail_tclServiceReference& operator = (const ail_tclServiceReference& oServiceReference);

      //## Operation: bIsDataSet%3A76CCB401D8
      tBool bIsDataSet (tU16 u16RefServiceId, tU16 u16RefSubId) const;

      //## Operation: bIsDataSet%3AB1E0B90296
      tBool bIsDataSet (tU16 u16RefAppId, tU16 u16RefRegisterId, tU16 u16RefSubId) const;

      //## Operation: bIsDataSet%3AB1E0D00311
      tBool bIsDataSet (tU16 u16RefServiceId, tU16 u16RefAppId, tU16 u16RefRegisterId, tU16 u16RefSubId) const;

      //## Operation: vSetServiceState%3A76CD3C0025
      tVoid vSetServiceState (tU8 u8NewServiceState);

      //## Operation: u8GetServiceState%3A76CDDB01BE
      tU8 u8GetServiceState () const;

      //## Operation: u16GetServiceId%3A76CE2103C8
      tU16 u16GetServiceId () const;

      //## Operation: u16GetServerAppId%3A76CE5601CF
      tU16 u16GetServerAppId () const;

      //## Operation: u16GetRegisterId%3A76CE6F033E
      tU16 u16GetRegisterId () const;

      //## Operation: u16GetSubId%3C92170D024B
      tU16 u16GetSubId () const;

      tBool bGetVersion(tU16& u16MajorVersion, tU16& u16MinorVersion, tU16& u16PatchVersion) const;
      tVoid vSetVersion(tU16 u16MajorVersion, tU16 u16MinorVersion, tU16 u16PatchVersion);
      tU16  u16GetMajorVersion() const;

  protected:
  private:
    // Data Members for Class Attributes

      //## Attribute: u16ServiceId%3A41D8370133
      //## begin ail_tclServiceReference::u16ServiceId%3A41D8370133.attr preserve=no  private: tU16 {UA} 
      tU16 u16ServiceId;
      //## end ail_tclServiceReference::u16ServiceId%3A41D8370133.attr

      //## Attribute: u16ServerAppId%3A41D86000D8
      //## begin ail_tclServiceReference::u16ServerAppId%3A41D86000D8.attr preserve=no  private: tU16 {UA} 
      tU16 u16ServerAppId;
      //## end ail_tclServiceReference::u16ServerAppId%3A41D86000D8.attr

      //## Attribute: u16RegisterId%3A41D8C6017E
      //## begin ail_tclServiceReference::u16RegisterId%3A41D8C6017E.attr preserve=no  private: tU16 {UA} 
      tU16 u16RegisterId;
      //## end ail_tclServiceReference::u16RegisterId%3A41D8C6017E.attr

      //## Attribute: u8ServiceState%3A41D8DE010B
      //## begin ail_tclServiceReference::u8ServiceState%3A41D8DE010B.attr preserve=no  private: tU8 {UA} 
      tU8 u8ServiceState;
      //## end ail_tclServiceReference::u8ServiceState%3A41D8DE010B.attr

      //## Attribute: u16SubId%3C92165F0287
      //## begin ail_tclServiceReference::u16SubId%3C92165F0287.attr preserve=no  private: tU16 {UA} 
      tU16 u16SubId;
      //## end ail_tclServiceReference::u16SubId%3C92165F0287.attr

      tU16 u16MajorVersion;
      tU16 u16MinorVersion;
      tU16 u16PatchVersion;
};

//## Class: ail_tclServiceSyncAnswer%3A41D9FD02EE
//## Category: AIL::ListWorking%3A41C6070033
//## Subsystem: Ail::Include%3A841A9E02B0
//## Persistence: Transient
//## Cardinality/Multiplicity: n



class ail_tclServiceSyncAnswer 
{
  public:
    //## Constructors (specified)
      //## Operation: ail_tclServiceSyncAnswer%3A76E48A0126
      ail_tclServiceSyncAnswer ();


    //## Other Operations (specified)
      //## Operation: bInitServiceSyncAnswerForReg%3AB080810104
      tBool bInitServiceSyncAnswerForReg (OSAL_tSemHandle hSyncSem, tU16 u16NewServerAppId, tU16 u16NewServiceId, tU16 u16NewClientSubId);

      //## Operation: bInitServiceSyncAnswerForData%3A783430003F
      tBool bInitServiceSyncAnswerForData (OSAL_tSemHandle hSyncSem, tU16 u16NewServerAppId, tU16 u16NewRegisterId, tU16 u16NewCmdCounter, tU16 u16NewServiceId, tU16 u16NewClientSubId, tU16 u16NewFunctionId, tU8 u8NewACT);

      //## Operation: vDeinitServiceSyncAnswer%3AA613BE011F
      tVoid vDeinitServiceSyncAnswer ();

      //## Operation: bIsWaitForRegister%3A7835BC00CB
      tBool bIsWaitForRegister (tU16 u16NewServerAppId, tU16 u16NewServiceId, tU16 u16NewClientSubId) const;

      //## Operation: bIsWaitForData%3CAD782B030B
      tBool bIsWaitForData () const;

      //## Operation: bIsWaitForData%3A7836240201
      tBool bIsWaitForData (tU16 u16NewServerAppId, tU16 u16NewRegisterId, tU16 u16NewCmdCounter, tU16 u16NewServiceId, tU16 u16NewClientSubId) const;
      tBool bIsWaitForData (tU16 u16NewServerAppId, tU16 u16NewRegisterId, tU16 u16NewCmdCounter, tU16 u16NewServiceId, tU16 u16NewClientSubId, tU16 u16NewFunctionId, tU8 u8NewAct) const;

      //## Operation: bIsWaitForData%3BAB286E0155
      tBool bIsWaitForData (tU16 u16NewServerAppId, tU16 u16NewRegisterId, tU16 u16NewServiceId, tU16 u16NewClientSubId) const;

      //## Operation: bIsAnswer%3A78367202DF
      tBool bIsAnswer (ail_tenSyncAnswerType* penAnswerType, amt_tclBaseMessage* poAnswerMessage, OSAL_tSemHandle hSyncSem) const;

      //## Operation: bForwardAnswer%3A78377801F6
      tBool bForwardAnswer (amt_tclBaseMessage* poNewMessage);

      //## Operation: vForwardAbort%3A783A1D038A
      tVoid vForwardAbort (ail_tenSyncAnswerType enAbortReason);

      //## Operation: operator !=%3A8BEB3F01E4
      tBool operator != (const ail_tclServiceSyncAnswer& oServiceSyncAnswer) const;

      //## Operation: operator =%3AB080AF00E2
      ail_tclServiceSyncAnswer& operator = (const ail_tclServiceSyncAnswer& oServiceSyncAnswer);

      void vDumpToString(tChar* szBuffer, tU16 u16Size) const;
      void vTraceDump(TR_tenTraceLevel enLevel) const;
      tU16 u16GetServerAppId() const;

  protected:
  private:
    // Data Members for Class Attributes

      //## Attribute: hAnswerEvent%3A41DA950257
      //## begin ail_tclServiceSyncAnswer::hAnswerEvent%3A41DA950257.attr preserve=no  private: OSAL_tSemHandle {UA} 
      OSAL_tSemHandle hAnswerEvent;
      //## end ail_tclServiceSyncAnswer::hAnswerEvent%3A41DA950257.attr

      //## Attribute: u8RequestType%3A41DB2303CD
      //## begin ail_tclServiceSyncAnswer::u8RequestType%3A41DB2303CD.attr preserve=no  private: tU8 {UA} 
      tU8 u8RequestType;
      //## end ail_tclServiceSyncAnswer::u8RequestType%3A41DB2303CD.attr

      //## Attribute: enAvailabilityType%3A41DCF203D3
      //## begin ail_tclServiceSyncAnswer::enAvailabilityType%3A41DCF203D3.attr preserve=no  private: ail_tenSyncAnswerType {UA} 
      ail_tenSyncAnswerType enAvailabilityType;
      //## end ail_tclServiceSyncAnswer::enAvailabilityType%3A41DCF203D3.attr

      //## Attribute: u16ServerAppId%3A41DB9202DD
      //## begin ail_tclServiceSyncAnswer::u16ServerAppId%3A41DB9202DD.attr preserve=no  private: tU16 {UA} 
      tU16 u16ServerAppId;
      //## end ail_tclServiceSyncAnswer::u16ServerAppId%3A41DB9202DD.attr

      //## Attribute: u16ServiceId%3A41DBE30293
      //## begin ail_tclServiceSyncAnswer::u16ServiceId%3A41DBE30293.attr preserve=no  private: tU16 {UA} 
      tU16 u16ServiceId;
      //## end ail_tclServiceSyncAnswer::u16ServiceId%3A41DBE30293.attr

      //## Attribute: u16ClientSubId%3C74E8B400C4
      //## begin ail_tclServiceSyncAnswer::u16ClientSubId%3C74E8B400C4.attr preserve=no  private: tU16 {UA} 
      tU16 u16ClientSubId;
      //## end ail_tclServiceSyncAnswer::u16ClientSubId%3C74E8B400C4.attr

      //## Attribute: u16RegisterId%3A41DC0C0093
      //## begin ail_tclServiceSyncAnswer::u16RegisterId%3A41DC0C0093.attr preserve=no  private: tU16 {UA} 
      tU16 u16RegisterId;
      //## end ail_tclServiceSyncAnswer::u16RegisterId%3A41DC0C0093.attr

      //## Attribute: u16CmdCounter%3A41DC2D004A
      //## begin ail_tclServiceSyncAnswer::u16CmdCounter%3A41DC2D004A.attr preserve=no  private: tU16 {UA} 
      tU16 u16CmdCounter;
      //## end ail_tclServiceSyncAnswer::u16CmdCounter%3A41DC2D004A.attr

      //## Attribute: hMessageHandle%3A41DC3F00A0
      //## begin ail_tclServiceSyncAnswer::hMessageHandle%3A41DC3F00A0.attr preserve=no  private: OSAL_trMessage {UA} 
      OSAL_trMessage hMessageHandle;
      //## end ail_tclServiceSyncAnswer::hMessageHandle%3A41DC3F00A0.attr

      //## Attribute: u16FunctionId%3CA998A302A4
      //## begin ail_tclServiceSyncAnswer::u16FunctionId%3CA998A302A4.attr preserve=no  private: tU16 {UA} 
      tU16 u16FunctionId;
      //## end ail_tclServiceSyncAnswer::u16FunctionId%3CA998A302A4.attr

      //## Attribute: u8ACT%3CA998C6005F
      //## begin ail_tclServiceSyncAnswer::u8ACT%3CA998C6005F.attr preserve=no  private: tU8 {UA} 
      tU8 u8ACT;
      //## end ail_tclServiceSyncAnswer::u8ACT%3CA998C6005F.attr

};

//## Class: ail_tclOpenedQueue%3A77BA530150
//## Category: AIL::ListWorking%3A41C6070033
//## Subsystem: Ail::Include%3A841A9E02B0
//## Persistence: Transient
//## Cardinality/Multiplicity: n



class ail_tclOpenedQueue 
{
  public:
    //## Constructors (specified)
      //## Operation: ail_tclOpenedQueue%3A77BB950370
      ail_tclOpenedQueue (OSAL_tMQueueHandle hNewQueue, tU16 u16NewAppId);

      //## Operation: ail_tclOpenedQueue%3AB07FB40195
      ail_tclOpenedQueue ();


    //## Other Operations (specified)
      //## Operation: operator !=%3A8BEA9B003A
      tBool operator != (const ail_tclOpenedQueue& oOpenedQueue) const;

      //## Operation: operator =%3AB07F5A0073
      ail_tclOpenedQueue& operator = (const ail_tclOpenedQueue& oOpenedQueue);

      //## Operation: u16GetAppId%3A78142800F4
      tU16 u16GetAppId () const;

      //## Operation: hGetQueue%3A7814400063
      OSAL_tMQueueHandle hGetQueue () const;

      //## Operation: bIsOpenedForApp%3A7814F501D5
      tBool bIsOpenedForApp (tU16 u16RefAppId, OSAL_tMQueueHandle* phQueue) const;

  protected:
  private:
    // Data Members for Class Attributes

      //## Attribute: hQueue%3A77BB06018A
      //## begin ail_tclOpenedQueue::hQueue%3A77BB06018A.attr preserve=no  private: OSAL_tMQueueHandle {UA} 
      OSAL_tMQueueHandle hQueue;
      //## end ail_tclOpenedQueue::hQueue%3A77BB06018A.attr

      //## Attribute: u16AppId%3A77BB46009B
      //## begin ail_tclOpenedQueue::u16AppId%3A77BB46009B.attr preserve=no  private: tU16 {UA} 
      tU16 u16AppId;
      //## end ail_tclOpenedQueue::u16AppId%3A77BB46009B.attr

};

//## Class: ail_tclServiceRegistry%3A41D9290380
//## Category: AIL::ListWorking%3A41C6070033
//## Subsystem: Ail::Include%3A841A9E02B0
//## Persistence: Transient
//## Cardinality/Multiplicity: n



class ail_tclServiceRegistry 
{
  public:
    //## Constructors (specified)
      //## Operation: ail_tclServiceRegistry%3A76D0E703D3
      ail_tclServiceRegistry (tU16 u16NewRegisterId, tU16 u16NewServiceId, tU16 u16NewClientId, tU16 u16NewClientSubId);

      //## Operation: ail_tclServiceRegistry%3AB07F89019D
      ail_tclServiceRegistry ();


    //## Other Operations (specified)
      //## Operation: operator !=%3A782F38028F
      tBool operator != (const ail_tclServiceRegistry& oServiceRegistry) const;

      //## Operation: operator =%3AB07F12005C
      ail_tclServiceRegistry& operator = (const ail_tclServiceRegistry& oServiceRegistry);

      //## Operation: bIsDataSet%3AC4720502DE
      tBool bIsDataSet (tU16 u16RefRegisterId) const;

      //## Operation: bIsDataSet%3A76D16F0021
      tBool bIsDataSet (tU16 u16RefRegisterId, tU16 u16RefServiceId) const;

      //## Operation: bIsDataSet%3AC472B40090
      tBool bIsDataSet (tU16 u16RefRegisterId, tU16 u16RefServiceId, tU16 u16RefAppId, tU16 u16RefSubId) const;

      //## Operation: vSetServiceState%3AD43F170318
      tVoid vSetServiceState (tU8 u8NewServiceState);

      //## Operation: u8GetServiceState%3AD43F4A019F
      tU8 u8GetServiceState () const;

      //## Operation: u16GetRegisterId%3A76D27B0026
      tU16 u16GetRegisterId () const;

      //## Operation: u16GetServiceId%3A76D28B0354
      tU16 u16GetServiceId () const;

      //## Operation: u16GetClientAppId%3A76D298035D
      tU16 u16GetClientAppId () const;

      //## Operation: u16GetClientSubId%3C751CBD00F1
      tU16 u16GetClientSubId () const;

      tBool bGetVersion(tU16& u16MajorVersion, tU16& u16MinorVersion, tU16& u16PatchVersion) const;
      tVoid vSetVersion(tU16 u16MajorVersion, tU16 u16MinorVersion, tU16 u16PatchVersion);
      tU16  u16GetMajorVersion() const;

  protected:
  private:
    // Data Members for Class Attributes

      //## Attribute: u16RegisterId%3A41D98700FA
      //## begin ail_tclServiceRegistry::u16RegisterId%3A41D98700FA.attr preserve=no  private: tU16 {UA} 
      tU16 u16RegisterId;
      //## end ail_tclServiceRegistry::u16RegisterId%3A41D98700FA.attr

      //## Attribute: u16ServiceId%3A41D9A103E6
      //## begin ail_tclServiceRegistry::u16ServiceId%3A41D9A103E6.attr preserve=no  private: tU16 {UA} 
      tU16 u16ServiceId;
      //## end ail_tclServiceRegistry::u16ServiceId%3A41D9A103E6.attr

      //## Attribute: u16ClientAppId%3A41D9B403D0
      //## begin ail_tclServiceRegistry::u16ClientAppId%3A41D9B403D0.attr preserve=no  private: tU16 {UA} 
      tU16 u16ClientAppId;
      //## end ail_tclServiceRegistry::u16ClientAppId%3A41D9B403D0.attr

      //## Attribute: u16ClientSubId%3C7519B300DE
      //## begin ail_tclServiceRegistry::u16ClientSubId%3C7519B300DE.attr preserve=no  private: tU16 {UA} 
      tU16 u16ClientSubId;
      //## end ail_tclServiceRegistry::u16ClientSubId%3C7519B300DE.attr

      //## Attribute: u8ServiceState%3AD43EA901B2
      //## begin ail_tclServiceRegistry::u8ServiceState%3AD43EA901B2.attr preserve=no  private: tU8 {UA} 
      tU8 u8ServiceState;
      //## end ail_tclServiceRegistry::u8ServiceState%3AD43EA901B2.attr

      tU16 u16MajorVersion;
      tU16 u16MinorVersion;
      tU16 u16PatchVersion;

};

//## Class: ail_tclAsyncRegisterReq%3D5CE9C801A8
//## Category: AIL::ListWorking%3A41C6070033
//## Subsystem: Ail::Include%3A841A9E02B0
//## Persistence: Transient
//## Cardinality/Multiplicity: n



class ail_tclAsyncRegisterReq 
{
  public:
    //## Constructors (specified)
      //## Operation: ail_tclAsyncRegisterReq%3D60D5D202D1
      ail_tclAsyncRegisterReq (tU16 u16RefServerAppId, tU16 u16RefServiceId, tU16 u16RefClientSubId, tU32 u32RefToutCounter);


    //## Other Operations (specified)
      //## Operation: bIsAnswer%3D5CEAA70070
      tBool bIsAnswer (tU16 u16RefServerAppId, tU16 u16RefServiceId, tU16 u16RefClientSubId) const;

      //## Operation: bIsObsolete%3D61080901BE
      tBool bIsObsolete () const;

      //## Operation: operator !=%3D5CEB19013A
      tBool operator != (const ail_tclAsyncRegisterReq& oAsyncRegisterReq) const;

      //## Operation: operator =%3D5CEBD70054
      ail_tclAsyncRegisterReq& operator = (const ail_tclAsyncRegisterReq& oAsyncRegisterReq);

      //## Operation: u32DecrementAndGetCounter%3D60FB0B036C
      tU32 u32DecrementAndGetCounter (tU32 u32DecValue);

      //## Operation: vGetAdressInfo%3D660E720044
      tVoid vGetAdressInfo (tU16* pu16ServerAppId, tU16* pu16ServiceId, tU16* pu16SubClient) const;

  protected:
  private:
      // declare private default-ctor to avoid uninitialized objects
      ail_tclAsyncRegisterReq (); //lint !e1704 Constructor has private access specification

    // Data Members for Class Attributes

      //## Attribute: u16ServerAppId%3D5CEA1E02C5
      //## begin ail_tclAsyncRegisterReq::u16ServerAppId%3D5CEA1E02C5.attr preserve=no  private: tU16 {UA} 
      tU16 u16ServerAppId;
      //## end ail_tclAsyncRegisterReq::u16ServerAppId%3D5CEA1E02C5.attr

      //## Attribute: u16ServiceId%3D5CEA4A02BF
      //## begin ail_tclAsyncRegisterReq::u16ServiceId%3D5CEA4A02BF.attr preserve=no  private: tU16 {UA} 
      tU16 u16ServiceId;
      //## end ail_tclAsyncRegisterReq::u16ServiceId%3D5CEA4A02BF.attr

      //## Attribute: u16ClientSubId%3D5CEA220322
      //## begin ail_tclAsyncRegisterReq::u16ClientSubId%3D5CEA220322.attr preserve=no  private: tU16 {UA} 
      tU16 u16ClientSubId;
      //## end ail_tclAsyncRegisterReq::u16ClientSubId%3D5CEA220322.attr

      //## Attribute: u32ToutCounter%3D60F89F0358
      //## begin ail_tclAsyncRegisterReq::u32ToutCounter%3D60F89F0358.attr preserve=no  private: tU32 {UA} 
      tU32 u32ToutCounter;
      //## end ail_tclAsyncRegisterReq::u32ToutCounter%3D60F89F0358.attr

};

//## Class: ail_tclPoolSemaphore%3EA900030394
//## Category: AIL::ListWorking%3A41C6070033
//## Subsystem: Ail::Include%3A841A9E02B0
//## Persistence: Transient
//## Cardinality/Multiplicity: n



class ail_tclPoolSemaphore 
{
  public:
    //## Constructors (specified)
      //## Operation: ail_tclPoolSemaphore%3EA903410123
      //	//
      //	********************************************************************************
      //	//	DESCRIPTION:
      //	//	Constructor
      //	//
      //	//	PARAMETER:
      //	//	tU16 u16SemId (I):
      //	//	id of created semaphore
      //	//	tCString coszSemName (I):
      //	//	name of created semaphore
      //	//	ail_tenPoolSemStatus enSemStatus (I):
      //	//	state of created semaphore
      //	//	OSAL_tSemHandle hSemId (I):
      //	//	handle to this semaphore
      //	//
      //	//	RETURNVALUE:
      //	//	none
      //	//
      //	//	History:
      //	//	25.04.03 CM-DI/ESA1-Fischer
      //	//	InitialVersion
      //	//
      //	//
      //	********************************************************************************
      ail_tclPoolSemaphore (tU16 u16NewSemId, tCString coszNewSemName, ail_tenPoolSemStatus enNewSemStatus, OSAL_tSemHandle hNewSemId);

      //## Operation: ail_tclPoolSemaphore%3EA9043D03E5
      //	//
      //	********************************************************************************
      //	//	DESCRIPTION:
      //	//	Copy-Constructor
      //	//
      //	//	PARAMETER:
      //	//	const ail_tclPoolSemaphore &corfoPoolSemaphore (I):
      //	//	reference to pool-semaphore to be copied
      //	//
      //	//	RETURNVALUE:
      //	//	none
      //	//
      //	//	History:
      //	//	25.04.03 CM-DI/ESA1-Fischer
      //	//	InitialVersion
      //	//
      //	//
      //	********************************************************************************
      ail_tclPoolSemaphore (const ail_tclPoolSemaphore &corfoPoolSemaphore);

    //## Destructor (specified)
      //## Operation: ~ail_tclPoolSemaphore%3EAE7366032E
      //	//
      //	********************************************************************************
      //	//	DESCRIPTION:
      //	//	Destructor
      //	//
      //	//	PARAMETER:
      //	//	none
      //	//
      //	//	RETURNVALUE:
      //	//	none
      //	//
      //	//	History:
      //	//	29.04.03 CM-DI/ESA1-Fischer
      //	//	InitialVersion
      //	//
      //	//
      //	********************************************************************************
      ~ail_tclPoolSemaphore ();


    //## Other Operations (specified)
      //## Operation: operator !=%3EA906CC01A2
      //	//
      //	********************************************************************************
      //	//	DESCRIPTION:
      //	//	operator !=, to compare two objects
      //	//
      //	//	PARAMETER:
      //	//	const ail_tclPoolSemaphore &corfoPoolSemaphore (I):
      //	//	reference to pool-semaphore to compared with
      //	//
      //	//	RETURNVALUE:
      //	//	tBool
      //	//	TRUE: not equal, FALSE: equal
      //	//
      //	//	History:
      //	//	25.04.03 CM-DI/ESA1-Fischer
      //	//	InitialVersion
      //	//
      //	//
      //	********************************************************************************
      tBool operator != (const ail_tclPoolSemaphore &corfoPoolSemaphore) const;

      //## Operation: operator =%3EA90792029C
      //	//
      //	********************************************************************************
      //	//	DESCRIPTION:
      //	//	operator =, to assign an object
      //	//
      //	//	PARAMETER:
      //	//	const ail_tclPoolSemaphore &corfoPoolSemaphore (I):
      //	//	reference to pool-semaphore to assign
      //	//
      //	//	RETURNVALUE:
      //	//	ail_tclPoolSemaphore &
      //	//	reference to this
      //	//
      //	//	History:
      //	//	25.04.03 CM-DI/ESA1-Fischer
      //	//	InitialVersion
      //	//
      //	//
      //	********************************************************************************
      ail_tclPoolSemaphore & operator = (const ail_tclPoolSemaphore &corfoPoolSemaphore);

      //## Operation: vSetId%3EA9088402AC
      //	//
      //	********************************************************************************
      //	//	DESCRIPTION:
      //	//	ail_tclPoolSemaphore::vSetId
      //	//	set new semaphore-id
      //	//
      //	//	PARAMETER:
      //	//	tU16 u16NewSemId (I):
      //	//	new semaphore-id
      //	//
      //	//	RETURNVALUE:
      //	//	tVoid
      //	//
      //	//	History:
      //	//	25.04.03 CM-DI/ESA1-Fischer
      //	//	InitialVersion
      //	//
      //	//
      //	********************************************************************************
      tVoid vSetId (tU16 u16NewSemId);

      //## Operation: u16GetId%3EA9126B0106
      //	//
      //	********************************************************************************
      //	//	DESCRIPTION:
      //	//	ail_tclPoolSemaphore::u16GetId
      //	//	get semaphore-id
      //	//
      //	//	PARAMETER:
      //	//	tVoid
      //	//
      //	//	RETURNVALUE:
      //	//	tU16
      //	//	semaphore-id
      //	//
      //	//	History:
      //	//	25.04.03 CM-DI/ESA1-Fischer
      //	//	InitialVersion
      //	//
      //	//
      //	********************************************************************************
      tU16 u16GetId () const;

      //## Operation: vSetName%3EA912B40106
      //	//
      //	********************************************************************************
      //	//	DESCRIPTION:
      //	//	ail_tclPoolSemaphore::vSetName
      //	//	set new semaphore-name
      //	//
      //	//	PARAMETER:
      //	//	tCString coszSemName (->I):
      //	//	new semaphore-name
      //	//
      //	//	RETURNVALUE:
      //	//	tVoid
      //	//
      //	//	History:
      //	//	25.04.03 CM-DI/ESA1-Fischer
      //	//	InitialVersion
      //	//
      //	//
      //	********************************************************************************
      tVoid vSetName (tCString coszSemName);

      //## Operation: szGetName%3EA912F00358
      //	//
      //	********************************************************************************
      //	//	DESCRIPTION:
      //	//	ail_tclPoolSemaphore::szGetName
      //	//	get semaphore-name
      //	//
      //	//	PARAMETER:
      //	//	tVoid
      //	//
      //	//	RETURNVALUE:
      //	//	tString
      //	//	semaphore-name, caller is responsible for the
      //	//	deleting of this string
      //	//
      //	//	History:
      //	//	25.04.03 CM-DI/ESA1-Fischer
      //	//	InitialVersion
      //	//
      //	//
      //	********************************************************************************
      tString szGetName () const;

      //## Operation: vSetStatus%3EA913A402DB
      //	//
      //	********************************************************************************
      //	//	DESCRIPTION:
      //	//	ail_tclPoolSemaphore::vSetStatus
      //	//	set new semaphore-status
      //	//
      //	//	PARAMETER:
      //	//	ail_tenPoolSemStatus enNewSemStatus (I):
      //	//	new semaphore-status
      //	//
      //	//	RETURNVALUE:
      //	//	tVoid
      //	//
      //	//	History:
      //	//	25.04.03 CM-DI/ESA1-Fischer
      //	//	InitialVersion
      //	//
      //	//
      //	********************************************************************************
      tVoid vSetStatus (ail_tenPoolSemStatus enNewSemStatus);

      //## Operation: enGetStatus%3EA913E80089
      //	//
      //	********************************************************************************
      //	//	DESCRIPTION:
      //	//	ail_tclPoolSemaphore::enGetStatus
      //	//	get semaphore-status
      //	//
      //	//	PARAMETER:
      //	//	tVoid
      //	//
      //	//	RETURNVALUE:
      //	//	ail_tenPoolSemStatus
      //	//	semaphore-status
      //	//
      //	//	History:
      //	//	25.04.03 CM-DI/ESA1-Fischer
      //	//	InitialVersion
      //	//
      //	//
      //	********************************************************************************
      ail_tenPoolSemStatus enGetStatus () const;

      //## Operation: vSetHandle%3EAD0EDE039D
      //	//
      //	********************************************************************************
      //	//	DESCRIPTION:
      //	//	ail_tclPoolSemaphore::vSetHandle
      //	//	set new semaphore-handle
      //	//
      //	//	PARAMETER:
      //	//	OSAL_tSemHandle hNewSemId (I):
      //	//	new semaphore-handle
      //	//
      //	//	RETURNVALUE:
      //	//	tVoid
      //	//
      //	//	History:
      //	//	28.04.03 CM-DI/ESA1-Fischer
      //	//	InitialVersion
      //	//
      //	//
      //	********************************************************************************
      tVoid vSetHandle (OSAL_tSemHandle hNewSemId);

      //## Operation: hGetHandle%3EAD0EDE03AD
      //	//
      //	********************************************************************************
      //	//	DESCRIPTION:
      //	//	ail_tclPoolSemaphore::hGetHandle
      //	//	get semaphore-handle
      //	//
      //	//	PARAMETER:
      //	//	tVoid
      //	//
      //	//	RETURNVALUE:
      //	//	OSAL_tSemHandle
      //	//	semaphore-handle
      //	//
      //	//	History:
      //	//	28.04.03 CM-DI/ESA1-Fischer
      //	//	InitialVersion
      //	//
      //	//
      //	********************************************************************************
      OSAL_tSemHandle hGetHandle () const;

  protected:
  private:
    //## Constructors (specified)
      //## Operation: ail_tclPoolSemaphore%3EA90041015F
      //	//
      //	********************************************************************************
      //	//	DESCRIPTION:
      //	//	Default-Constructor
      // //    declared private to avoid creation of object without a semaphore
      //	//
      //	//	PARAMETER:
      //	//	none
      //	//
      //	//	RETURNVALUE:
      //	//	none
      //	//
      //	//	History:
      //	//	25.04.03 CM-DI/ESA1-Fischer
      //	//	InitialVersion
      //	//
      //	//
      //	********************************************************************************
      ail_tclPoolSemaphore (); //lint !e1704 Constructor has private access specification

    // Data Members for Class Attributes

      //## Attribute: u16SemId%3EA901960087
      //## begin ail_tclPoolSemaphore::u16SemId%3EA901960087.attr preserve=no  private: tU16 {UA} 
      tU16 u16SemId;
      //## end ail_tclPoolSemaphore::u16SemId%3EA901960087.attr

      //## Attribute: szSemName%3EA901CC0095
      //## begin ail_tclPoolSemaphore::szSemName%3EA901CC0095.attr preserve=no  private: tString {UA} 
      tString szSemName;
      //## end ail_tclPoolSemaphore::szSemName%3EA901CC0095.attr

      //## Attribute: enSemStatus%3EA90297006E
      //## begin ail_tclPoolSemaphore::enSemStatus%3EA90297006E.attr preserve=no  private: ail_tenPoolSemStatus {UA} 
      ail_tenPoolSemStatus enSemStatus;
      //## end ail_tclPoolSemaphore::enSemStatus%3EA90297006E.attr

      //## Attribute: hSemId%3EAD0E87026F
      //## begin ail_tclPoolSemaphore::hSemId%3EAD0E87026F.attr preserve=no  private: OSAL_tSemHandle {UA} 
      OSAL_tSemHandle hSemId;
      //## end ail_tclPoolSemaphore::hSemId%3EAD0E87026F.attr

};

//## Class: ail_tclWatchdogInfo%3EF2C01B0204
//## Category: AIL::ListWorking%3A41C6070033
//## Subsystem: Ail::Include%3A841A9E02B0
//## Persistence: Transient
//## Cardinality/Multiplicity: n



class ail_tclWatchdogInfo 
{
  public:
    //## Constructors (specified)
      //## Operation: ail_tclWatchdogInfo%3EF2C242013B
      //	//
      //	********************************************************************************
      //	//	DESCRIPTION:
      //	//	Default-Constructor
      //	//
      //	//	PARAMETER:
      //	//	none
      //	//
      //	//	RETURNVALUE:
      //	//	none
      //	//
      //	//	History:
      //	//	26.06.03 CM-DI/ESA1-Fischer
      //	//	InitialVersion
      //	//
      //	//
      //	********************************************************************************
      ail_tclWatchdogInfo ();

    //## Destructor (specified)
      //## Operation: ~ail_tclWatchdogInfo%3EF2C24B0293
      //	//
      //	********************************************************************************
      //	//	DESCRIPTION:
      //	//	Destructor
      //	//
      //	//	PARAMETER:
      //	//	none
      //	//
      //	//	RETURNVALUE:
      //	//	none
      //	//
      //	//	History:
      //	//	26.06.03 CM-DI/ESA1-Fischer
      //	//	InitialVersion
      //	//
      //	//
      //	********************************************************************************
      ~ail_tclWatchdogInfo ();


    //## Other Operations (specified)
      //## Operation: operator !=%3EF6F133035A
      //	//
      //	********************************************************************************
      //	//	DESCRIPTION:
      //	//	operator !=, compares two objects of this type
      //	//
      //	//	PARAMETER:
      //	//	const ail_tclWatchdogInfo &corfoWatchdogInfo (->I):
      //	//                object to be compared
      //	//
      //	//	RETURNVALUE:
      //	//	tBool
      //	//	TRUE: not equal, FALSE: equal
      //	//
      //	//	History:
      //	//	26.06.03 CM-DI/ESA1-Fischer
      //	//	InitialVersion
      //	//
      //	//
      //	********************************************************************************
      tBool operator != (const ail_tclWatchdogInfo &corfoWatchdogInfo) const;

      //## Operation: operator =%3EF6F19D033B
      //	//
      //	********************************************************************************
      //	//	DESCRIPTION:
      //	//	operator =, assigns the values of an object to this object
      //	//
      //	//	PARAMETER:
      //	//	const ail_tclWatchdogInfo &corfoWatchdogInfo (->I):
      //	//                object to be assigned
      //	//
      //	//	RETURNVALUE:
      //	//	tBool
      //	//	TRUE: not equal, FALSE: equal
      //	//
      //	//	History:
      //	//	26.06.03 CM-DI/ESA1-Fischer
      //	//	InitialVersion
      //	//
      //	//
      //	********************************************************************************
      ail_tclWatchdogInfo & operator = (const ail_tclWatchdogInfo &corfoWatchdogInfo);

    // Data Members for Class Attributes

      //## Attribute: hWdgID%3EF2C0310169
      //## begin ail_tclWatchdogInfo::hWdgID%3EF2C0310169.attr preserve=no  public: ail_tWdgHandle {UA} OSAL_C_INVALID_HANDLE
      ail_tWdgHandle hWdgID;
      //## end ail_tclWatchdogInfo::hWdgID%3EF2C0310169.attr

      //## Attribute: ThreadID%3EF2C07200AF
      //## begin ail_tclWatchdogInfo::ThreadID%3EF2C07200AF.attr preserve=no  public: OSAL_tThreadID {UA} OSAL_ERROR
      OSAL_tThreadID ThreadID;
      //## end ail_tclWatchdogInfo::ThreadID%3EF2C07200AF.attr

      //## Attribute: bActive%3EF2C08D0285
      //## begin ail_tclWatchdogInfo::bActive%3EF2C08D0285.attr preserve=no  public: tBool {UA} FALSE
      tBool bActive;
      //## end ail_tclWatchdogInfo::bActive%3EF2C08D0285.attr

      //## Attribute: WdgInterval%3EF2C0980091
      //## begin ail_tclWatchdogInfo::WdgInterval%3EF2C0980091.attr preserve=no  public: OSAL_tMSecond {UA} 0
      OSAL_tMSecond WdgInterval;
      //## end ail_tclWatchdogInfo::WdgInterval%3EF2C0980091.attr

      //## Attribute: MaxInterval%3EF9B11F029A
      //## begin ail_tclWatchdogInfo::MaxInterval%3EF9B11F029A.attr preserve=no  public: OSAL_tMSecond {UA} 0
      OSAL_tMSecond MaxInterval;
      //## end ail_tclWatchdogInfo::MaxInterval%3EF9B11F029A.attr

      //## Attribute: NextTriggerTime%3EF2C0A502B4
      //## begin ail_tclWatchdogInfo::NextTriggerTime%3EF2C0A502B4.attr preserve=no  public: OSAL_tMSecond {UA} 0
      OSAL_tMSecond NextTriggerTime;
      //## end ail_tclWatchdogInfo::NextTriggerTime%3EF2C0A502B4.attr

      //## Attribute: MaxTriggerTime%3EF9B2A70182
      //## begin ail_tclWatchdogInfo::MaxTriggerTime%3EF9B2A70182.attr preserve=no  public: OSAL_tMSecond {UA} 0
      OSAL_tMSecond MaxTriggerTime;
      //## end ail_tclWatchdogInfo::MaxTriggerTime%3EF9B2A70182.attr

      //## Attribute: LastTriggerTime%3EF2C0B10322
      //## begin ail_tclWatchdogInfo::LastTriggerTime%3EF2C0B10322.attr preserve=no  public: OSAL_tMSecond {UA} 0
      OSAL_tMSecond LastTriggerTime;
      //## end ail_tclWatchdogInfo::LastTriggerTime%3EF2C0B10322.attr

      //## Attribute: enTraceClass%3EF85DC10230
      //## begin ail_tclWatchdogInfo::enTraceClass%3EF85DC10230.attr preserve=no  public: TR_tenTraceClass {UA} TR_CLASS_AIL
      TR_tenTraceClass enTraceClass;
      //## end ail_tclWatchdogInfo::enTraceClass%3EF85DC10230.attr

  protected:
  private:
};

// Class ail_tclServiceReference 

// Class ail_tclServiceSyncAnswer 

// Class ail_tclOpenedQueue 

// Class ail_tclServiceRegistry 

// Class ail_tclAsyncRegisterReq 

// Class ail_tclPoolSemaphore 

// Class ail_tclWatchdogInfo 

//## begin module%3A841CA6024A.epilog preserve=yes
//## end module%3A841CA6024A.epilog


#endif
