/******************************************************************************
 * FILE: ail_ListHelp.h         
 * SW-COMPONENT:  AIL
 * DESCRIPTION:  
 * AUTHOR:        
 * COPYRIGHT:     (c) 2001 Robert Bosch GmbH, Hildesheim
 * HISTORY:      
 ******************************************************************************/

#ifndef AIL_LISTHELP_HEADER
#define AIL_LISTHELP_HEADER

#ifdef __cplusplus
extern "C"{
#endif

/******************************************************************************
| includes of component-internal interface, if necessary
| (scope: component-local)
|-----------------------------------------------------------------------------*/

/******************************************************************************
| defines and macros (scope: global)
|-----------------------------------------------------------------------------*/


/******************************************************************************
| typedefs (scope: global)
|-----------------------------------------------------------------------------*/

/*******************************************************************************
| variable declaration (scope: global)
|-----------------------------------------------------------------------------*/

/*******************************************************************************
| function prototypes (scope: global)
|-----------------------------------------------------------------------------*/

tBool 
ail_bTakeListAccess
(
   OSAL_tSemHandle hSemId
);

tBool 
ail_bReleaseListAccess
(
   OSAL_tSemHandle hSemId
);

OSAL_tMQueueHandle 
ail_hGetReceiverQueue
(
   ail_tclOpenedQueueList*    poOpenedQueueList,
   OSAL_tSemHandle            hSemId,
   tU16                       u16AppId
);

tBool
ail_bDeleteFromOpenedQueueList
(
   ail_tclOpenedQueueList*    poOpenedQueueList,
   OSAL_tSemHandle            hSemId,
   tU16                       u16AppId
);

tBool
ail_bCheckRegistrationsToApp
(
   ail_tclServiceReferenceList *poServiceReferenceList,
   ail_tclServiceRegistryList  *poServiceRegistryList,
   OSAL_tSemHandle              hSemId,
   tU16                         u16AppId
);

ail_tenCommunicationError
ail_enCheckServerMailValidity
(
   tU16                          u16AppId,
   OSAL_tSemHandle               hSemId, 
   amt_tclServiceData*           poMessage,
   ail_tclServiceRegistryList*   poServiceRegistryList
);

ail_tenCommunicationError
ail_enCheckClientMailValidity
(
   tU16                             u16AppId,
   OSAL_tSemHandle                  hSemId, 
   amt_tclServiceData*              poMessage,
   ail_tclServiceReferenceList*     poServiceReferenceList
);

// get handle to semaphore from list or create new
OSAL_tSemHandle
ail_hGetSemaphoreFromList
(
   tU16                      u16AppId,             // application-id
   OSAL_tSemHandle           hGLA,                 // general list-access
   ail_tclPoolSemaphoreList *poPoolSemaphoreList   // list with created semaphores
);

// release semaphore in list
tBool
ail_bReleaseSemaphoreInList
(
   OSAL_tSemHandle           hGLA,                 // general list-access
   OSAL_tSemHandle           hSemId,               // release this semaphore from list
   ail_tclPoolSemaphoreList *poPoolSemaphoreList   // list with created semaphores
);

// delete all semaphores and remove them from list
tBool
ail_bDeleteSemaphoresFromList
(
   OSAL_tSemHandle           hGLA,                 // general list-access
   ail_tclPoolSemaphoreList *poPoolSemaphoreList   // list with created semaphores
);


#ifdef __cplusplus
}
#endif


#endif


