//## begin module%1.4%.codegen_version preserve=yes
//   Read the documentation to learn more about C++ code generator
//   versioning.
//## end module%1.4%.codegen_version

//## begin module%3A9B9A9B00D0.cm preserve=no
//   %X% %Q% %Z% %W%
//## end module%3A9B9A9B00D0.cm

//## begin module%3A9B9A9B00D0.cp preserve=no
//## end module%3A9B9A9B00D0.cp

//## Module: ail_InternalDispatch%3A9B9A9B00D0; Subprogram body
//## Subsystem: Ail%3A841A8D02DE
//## Source file: e:\vasco\components\Ail\ail_InternalDispatch.cpp

//## begin module%3A9B9A9B00D0.additionalIncludes preserve=no
//## end module%3A9B9A9B00D0.additionalIncludes

//## begin module%3A9B9A9B00D0.includes preserve=yes

// regular includes
#define OSAL_S_IMPORT_INTERFACE_GENERIC
#include "osal_if.h"

#ifndef TRACE_S_ALREADY_INCLUDE_TYPES
#define TRACE_S_IMPORT_INTERFACE_TYPES
#include "trace_if.h"
#endif

#include <vector>


#define SCD_S_IMPORT_INTERFACE_GENERIC
#include "scd_if.h"

#define AIL_S_IMPORT_INTERFACE_GENERIC 
#define AIL_S_IMPORT_INTERFACE_TRACE
#include "ail_if.h"

#define FI_S_IMPORT_INTERFACE_FI_MESSAGE
#define FW_FI_S_IMPORT_INTERFACE_FW_AILFI_TYPES
#define FW_FI_S_IMPORT_INTERFACE_FW_AILFI_FUNCTIONIDS
#define FW_FI_S_IMPORT_INTERFACE_FW_AILFI_ERRORCODES
#define FW_FI_S_IMPORT_INTERFACE_FW_AILFI_SERVICEINFO
#include "fw_fi_if.h"

//## end module%3A9B9A9B00D0.includes

//## begin module%3A9B9A9B00D0.declarations preserve=no
//## end module%3A9B9A9B00D0.declarations

//## begin module%3A9B9A9B00D0.additionalDeclarations preserve=yes
//## end module%3A9B9A9B00D0.additionalDeclarations

typedef struct
{
  tU16 u16StoredServiceId;
  tU16 u16StoredClientSubId;
} trServiceAndSubIdStorage;

// Class ail_tclInternalDispatch

ail_tclInternalDispatch::ail_tclInternalDispatch (ail_tclAppInterfaceRestricted* poMyAppInterface)
  //## begin ail_tclInternalDispatch::ail_tclInternalDispatch%3A9D1D6B016B.hasinit preserve=no
  //## end ail_tclInternalDispatch::ail_tclInternalDispatch%3A9D1D6B016B.hasinit
  //## begin ail_tclInternalDispatch::ail_tclInternalDispatch%3A9D1D6B016B.initialization preserve=yes
  //## end ail_tclInternalDispatch::ail_tclInternalDispatch%3A9D1D6B016B.initialization
{
  //## begin ail_tclInternalDispatch::ail_tclInternalDispatch%3A9D1D6B016B.body preserve=yes
  poAppInterface = poMyAppInterface;
  //## end ail_tclInternalDispatch::ail_tclInternalDispatch%3A9D1D6B016B.body
}


ail_tclInternalDispatch::~ail_tclInternalDispatch ()
{
  //## begin ail_tclInternalDispatch::~ail_tclInternalDispatch%3A9D1D78020A.body preserve=yes
   poAppInterface=NULL;
  //## end ail_tclInternalDispatch::~ail_tclInternalDispatch%3A9D1D78020A.body
}



//## Other Operations (implementation)
tBool ail_tclInternalDispatch::bDispatchCCAMessages (amt_tclBaseMessage* poMessage, OSAL_tMQueueHandle hRouteInfoQueue, tBool /*bPredecessorFiltering*/, tU32 u32Prio)
{
  //## begin ail_tclInternalDispatch::bDispatchCCAMessages%3A9D1DB902D6.body preserve=yes

   tBool                   bProcessed = FALSE;
   tBool                   bPassFilter = FALSE;
   tBool                   bContinueDispatching = TRUE;
   tBool                   bTraceCouldBeActiv = FALSE;
   OSAL_tThreadID          hCallerThreadID = OSAL_ThreadWhoAmI();

   /* get type and dispatch */
   tU8   u8Type = poMessage->u8GetType();
   tU8   u8Context = poMessage->u8GetContext();

   bTraceCouldBeActiv = ail_bIsTraceActive(TR_LEVEL_ERRORS);
   
   if ( u8Context == AMT_C_U8_CCACONTEXT_LOCAL )
   {
      if (bTraceCouldBeActiv)
      {
         // get current used poolspace
         TR_tenTraceLevel enTraceLevel = TR_LEVEL_USER_4;
         tS32 s32AbsolutePoolSpace = OSAL_s32MessagePoolGetAbsoluteSize();
         tS32 s32CurrentPoolSpace = OSAL_s32MessagePoolGetCurrentSize();
         tU8 u8MsgBufferInUse = 0;
   
         if ( s32AbsolutePoolSpace > 0 )
         {
            u8MsgBufferInUse = (tU8)(((tU8)100) - ((tU8)((s32CurrentPoolSpace * 100 ) / s32AbsolutePoolSpace)));
   
            if ( u8MsgBufferInUse > AIL_C_U8_TRACE_THRESHOLD_MSG_PRINT )
            /* more than xx% poolspace actually used */
            {
               enTraceLevel = TR_LEVEL_ERRORS;
            }
         }
   
         if (  hRouteInfoQueue != OSAL_C_INVALID_HANDLE
            || (  u8MsgBufferInUse > AIL_C_U8_TRACE_THRESHOLD_MSG_PRINT
               #ifdef AIL_MESSAGE_TRACE_EACH_MESSAGE
                                 && !ail_bIsTraceActive( TR_LEVEL_USER_4 ) 
               #endif
                  ))
         {
            ail_vTraceMsg( enTraceLevel,
               "Application 0x%04x,%d: %s is receiving %d bytes from app 0x%04x,%d, %d percent of MsgPool used, current poolspace: %d\n",
               poAppInterface->u16AppId,
               poMessage->u16GetTargetSubID(),
               (hCallerThreadID==poAppInterface->hEntryThreadID)?"ENTRY":"BODY",
               poMessage->u32GetSize(),
               poMessage->u16GetSourceAppID(),
               poMessage->u16GetSourceSubID(),
               u8MsgBufferInUse,
               s32CurrentPoolSpace );
         }
         else
         {
            #ifdef AIL_MESSAGE_TRACE_EACH_MESSAGE
            ail_vTraceHexMsg( TR_CLASS_AIL, enTraceLevel, FALSE,
               poMessage->u32GetSize(), poMessage->pu8GetSharedMemBase(),
               "Application 0x%04x,%d: %s is receiving %d bytes from app 0x%04x,%d, %d percent of MsgPool used, current poolspace: %d, Raw Data of the message:",
               poAppInterface->u16AppId,
               poMessage->u16GetTargetSubID(),
               (hCallerThreadID==poAppInterface->hEntryThreadID)?"ENTRY":"BODY",
               poMessage->u32GetSize(),
               poMessage->u16GetSourceAppID(),
               poMessage->u16GetSourceSubID(),
               u8MsgBufferInUse,
               s32CurrentPoolSpace );
            #endif
         }
      }

      /***************** start of feature service recording ******************/         

      if ((hRouteInfoQueue != OSAL_C_INVALID_HANDLE) || (poAppInterface->bHasBodyThread == FALSE))
      {
        ail_vTraceCcaMessage(poMessage, AIL_C_U8_TRACE_MSG_RECEIVED, u32Prio);
      }

      /****************** end of feature service recording *******************/         

      switch ( u8Type )
      {
         case AMT_C_U8_CCAMSGTYPE_POWER:
         {
            if ( poAppInterface->enInterfaceState >= AIL_EN_N_APPLICATION_REGISTERED )
            /* application is ready to accept POWER-messages */
            {
               /* wait for trigger to kill myself */
               bContinueDispatching = ail_bCheckExistenceRequirement( poMessage );

               if ( bContinueDispatching )
               {
                  // if thread is ENTRY-thread ...
                  if (  hRouteInfoQueue != OSAL_C_INVALID_HANDLE
                     || !poAppInterface->bHasBodyThread )
                  {
                     // if state-change-request and bSendRequest... returns TRUE,
                     //  send request for extra-time automatically (20s)
                     if ( !bPreActionOnStateChangeRequest(poMessage) )
                     {
                        // send request for extra-time failed
                        ail_vTraceMsg( TR_LEVEL_FATAL,
                              "Application 0x%04x: RequestErrorEnd, request extra-time for state-change-request failed", poAppInterface->u16AppId );
                        poAppInterface->vApplicationRequestErrorEnd(AIL_C_U32_ERROR_ONEXTRATIME_FAILED);
                     }
                  }

                  /* note: application register confirmation is also a power message */
                  if ( hRouteInfoQueue == OSAL_C_INVALID_HANDLE )
                  {
//                     if ( hCallerThreadID == poAppInterface->hEntryThreadID )
                     /* only a EntryThread exists */
//                     {
                        /* support for internal AIL administration structures */
                        bProcessed = ail_bExamineInfluenceToAdministration( AIL_EN_N_ADMIN_APPCLOSE_CHECK, poMessage );
//                     }
//                     if ( !bProcessed )
//                     {       
                        /* Call Handler for ServiceRegister */
                        bProcessed = ail_bHandleMsgPowerMessage(poMessage);
//                     }
                  }
                  else
                  /* only route this message */
                  {
                     // code in this block is comented off, because of message handling racing
                     // support for internal AIL administration structures 
                     // bProcessed = ail_bExamineInfluenceToAdministration 
                     //   ( AIL_EN_N_ADMIN_APPCLOSE_CHECK, poMessage ); 

                     // if ( !bProcessed )
                     // {
                        // message either will be deleted or send to body 
                        bProcessed = TRUE;

                        if ( 
                              !poAppInterface->bPostIpcMessage
                              (
                                 poAppInterface->u16AppId,
                                 hRouteInfoQueue, 
                                 poMessage, 
                                 AIL_C_U32_CCA_PRIO_MSG_POWER,
                                 FALSE
                              )
                           )
                        {
                           ail_vTraceMsg( TR_LEVEL_FATAL,
                                 "Application 0x%04x: RequestErrorEnd, forward power-msg to body-thread failed", poAppInterface->u16AppId );
                           poAppInterface->vApplicationRequestErrorEnd();
                        }
                     //}
                  }
               }
            }
            break;
         }
         case AMT_C_U8_CCAMSGTYPE_SVCREGISTER: 
         {
            if ( poAppInterface->enInterfaceState == AIL_EN_N_APPLICATION_INITIALIZED )
            /* registering only allowed, if normal operating */
            {
               /* Call Handler for ServiceRegister */
               bProcessed = ail_bHandleMsgServiceRegister(poMessage);
            }
            else
            /* reject the request */
            {
               /* Call ErrorHandler for ServiceRegister */
               bProcessed = ail_bErrorRejectMsgServiceRegister(poMessage);
            }
            break;
         }
         case AMT_C_U8_CCAMSGTYPE_SVSSTATUS:
         {
            if ( poAppInterface->enInterfaceState == AIL_EN_N_APPLICATION_INITIALIZED )
            {
               if ( hRouteInfoQueue == OSAL_C_INVALID_HANDLE )
               {
                  if ( hCallerThreadID == poAppInterface->hEntryThreadID )
                  /* only a EntryThread exists */
                  {
                     /* support for internal AIL administration structures */
                     bProcessed = ail_bExamineInfluenceToAdministration( AIL_EN_N_ADMIN_SVSSTATUS, poMessage );
                  }
                  if ( !bProcessed )
                  {       
                     /* Call Handler for ServiceRegister */
                     bProcessed = ail_bHandleMsgServiceStatus(poMessage);
                  }
               }
               else
               /* only route this message */
               {
                  /* support for internal AIL administration structures */
                  bProcessed = ail_bExamineInfluenceToAdministration( AIL_EN_N_ADMIN_SVSSTATUS, poMessage ); 

                  if ( !bProcessed )
                  {
                     /* message either will be deleted or send to body */
                     bProcessed = TRUE;

                     if ( !poAppInterface->bPostIpcMessage(poAppInterface->u16AppId, hRouteInfoQueue, poMessage, AIL_C_U32_CCA_PRIO_MSG_SERVICE_STATUS, FALSE) )
                     {
                        ail_vTraceMsg( TR_LEVEL_FATAL, "Application 0x%04x: RequestErrorEnd, forward service-state-msg to body-thread failed", poAppInterface->u16AppId );
                        poAppInterface->vApplicationRequestErrorEnd();
                     }
                  }
               }
            }
            break;
         }
         case AMT_C_U8_CCAMSGTYPE_SVCREGCONF:
         {
            if ( poAppInterface->enInterfaceState == AIL_EN_N_APPLICATION_INITIALIZED )
            /* note: the ApplicationCloseRequest automatically kills synchron waiting */
            {
               /* Call Handler for ServiceRegister */
               bProcessed = ail_bHandleMsgServiceRegisterConf(poMessage);
            }
            break;
          }
         case AMT_C_U8_CCAMSGTYPE_SVCUNREGISTER:
         {
            if ( poAppInterface->enInterfaceState == AIL_EN_N_APPLICATION_INITIALIZED )
            {
               /* support for internal AIL administration structures */
               bProcessed = ail_bExamineInfluenceToAdministration ( AIL_EN_N_ADMIN_SVCUNREGISTER, poMessage );

               if ( !bProcessed )
               {
                  /* Call Handler for ServiceUnregister */
                  bProcessed = ail_bHandleMsgServiceUnregister(poMessage);
               }
            }
            break;
         }
         case AMT_C_U8_CCAMSGTYPE_SVCDATA:
         {
            tBool bLoopBackIndication = FALSE;
            tU16  u16Sender = poMessage->u16GetSourceAppID();
            tU16  u16Receiver = poMessage->u16GetTargetAppID();

            if ( poAppInterface->u16AppId == u16Receiver && u16Sender == u16Receiver )
            {
               bLoopBackIndication = TRUE;  
            }
            if ( 
                  poAppInterface->enInterfaceState == AIL_EN_N_APPLICATION_INITIALIZED
                  ||
                  (
                     poAppInterface->enInterfaceState == AIL_EN_N_APPLICATION_CLOSE_REQ
                     &&
                     bLoopBackIndication
                  )
               )
            /* normally all, but in state application CLOSE_REQ only LoopBack-MSGs allowed */
            {
               if ( hRouteInfoQueue == OSAL_C_INVALID_HANDLE )
               {
                  if ( hCallerThreadID == poAppInterface->hEntryThreadID )
                  /* only a EntryThread exists */
                  {
                     if ( !bLoopBackIndication )
                     /* a message to myself is not allowed for synchron usage */
                     {
                        /* support for internal AIL administration structures */
                        bProcessed = ail_bExamineInfluenceToAdministration( AIL_EN_N_ADMIN_SVCDATA, poMessage ); 
                     }
                  }
                  if ( !bProcessed )
                  /* Call Handler for ServiceRegister */
                  {
                     if ( bLoopBackIndication )
                     /* LoopBack-message are directly forwarded to the application */
                     {
                        poAppInterface->vOnNewMessage ( poMessage );
                        bProcessed = TRUE;
                     }
                     else
                     {
                        bProcessed = ail_bHandleMsgServiceData(poMessage);
                     }
                  }
               }
               else
               /* only route this message */
               {
                  if ( !bLoopBackIndication )
                  /* a message to myself is not allowed for synchron usage */
                  {
                     /* support for internal AIL administration structures */
                     bProcessed = ail_bExamineInfluenceToAdministration( AIL_EN_N_ADMIN_SVCDATA, poMessage );
                  }       

                  if ( !bProcessed )
                  /* message not used to generate a synchronous answer */
                  {
                     tU32 u32MsgPrio = OSAL_C_U32_MQUEUE_PRIORITY_LOWEST;

                     amt_tclServiceData oServiceData(poMessage);   // Downcast Object

                     if (oServiceData.bIsServerMessage() == TRUE)
                     {
                       u32MsgPrio = AIL_C_U32_CCA_PRIO_MSG_SERVICE_DATA_SERVER;
                     }
                     else
                     {
                       u32MsgPrio = AIL_C_U32_CCA_PRIO_MSG_SERVICE_DATA_CLIENT;
                     }

                     if (!poAppInterface->bPostIpcMessage( poAppInterface->u16AppId, hRouteInfoQueue, poMessage, u32MsgPrio, FALSE) )
                     {
                        ail_vTraceMsg( TR_LEVEL_FATAL,"Application 0x%04x: RequestErrorEnd, forward service-data-msg to body-thread failed", poAppInterface->u16AppId );
                        poAppInterface->vApplicationRequestErrorEnd();
                     }

                     /* message either will be deleted or send to body */
                     bProcessed = TRUE;
                  }
               }
            }
            else if ( !bLoopBackIndication )
            /* outside of normal operating mode && not a LoopBack-Message */ 
            {           
               bProcessed = ail_bExamineInfluenceToAdministration( AIL_EN_N_ADMIN_OPERATION_LOCKED, poMessage ); 
            }
            break;
         }
         case AMT_C_U8_CCAMSGTYPE_SUPPLIER_STATE:
         {
            if ( poAppInterface->enInterfaceState == AIL_EN_N_APPLICATION_INITIALIZED )
            /* registering only allowed, if normal operating */
            {
               ail_bHandleMsgSupplierStateMessage(poMessage);
            }
            break;
         }
         case AMT_C_U8_CCAMSGTYPE_APPLICATION_INFO:
         {
            if ( poAppInterface->enInterfaceState == AIL_EN_N_APPLICATION_INITIALIZED )
            /* registering only allowed, if normal operating */
            {
               ail_bHandleMsgAppInfoMessage(poMessage);
            }
            break;
         }
         #ifdef AIL_DEBUG_APPLICATION
         case AMT_C_U8_TYPE_DEBUG_APPLICATION:
         {
            bProcessed = ail_bHandleMsgDebugApplication(poMessage);

            break;
         }
         #endif
         default:
         /* all unknown CCA-messages are killed */
         {
            break;
         }
       }
   }
   else
   /* all non CCA-Messages ( MOST, CAN, tbd. ) are not filtered */
   {
      bPassFilter = TRUE;
   }

   if ( bPassFilter )
   /* some message which is transparent given to ::onNewMessage()-function */
   {
      if ( poAppInterface->enInterfaceState == AIL_EN_N_APPLICATION_INITIALIZED )
      {
         if ( hRouteInfoQueue == OSAL_C_INVALID_HANDLE )
         {
            bProcessed = TRUE;
            /* the user is responsible to release the message */
            poAppInterface->vOnNewMessage ( poMessage );
         }
         else
         /* only route this message */
         {
            bProcessed = TRUE;

            if ( !poAppInterface->bPostIpcMessage( poAppInterface->u16AppId, hRouteInfoQueue, poMessage, OSAL_C_U32_MQUEUE_PRIORITY_LOWEST, FALSE) )
            {
               ail_vTraceMsg( TR_LEVEL_FATAL,"Application 0x%04x: RequestErrorEnd, forward non-CCA-msg to body-thread failed", poAppInterface->u16AppId );
               poAppInterface->vApplicationRequestErrorEnd();
            }
         }
      }
   }

   if ( !bProcessed )
   {
      /* release the message object */
      poMessage->bDelete();
   }

   #ifdef AIL_MESSAGE_TRACE_EACH_MESSAGE
   if (bTraceCouldBeActiv)
   {
      ail_vTraceMsg( TR_LEVEL_USER_4,
         "Application 0x%04x: %s data processed, current poolspace: %d\n",
         poAppInterface->u16AppId,
         (
            (  hRouteInfoQueue != OSAL_C_INVALID_HANDLE
            || !poAppInterface->bHasBodyThread )
            ? "ENTRY"
            : "BODY"
         ),
         OSAL_s32MessagePoolGetCurrentSize() );
   }
   #endif

   return ( bContinueDispatching );
 
  //## end ail_tclInternalDispatch::bDispatchCCAMessages%3A9D1DB902D6.body
}

tBool ail_tclInternalDispatch::ail_bHandleMsgServiceRegister (amt_tclBaseMessage* poMessage)
{
  //## begin ail_tclInternalDispatch::ail_bHandleMsgServiceRegister%3A9E0BD50316.body preserve=yes

// PDP3-Andres: moved position of message sending block because of message racing

   tBool                   bMessageReleased = FALSE;
   tBool                   bServiceInfoRequired = FALSE;
   tU16                    u16Client, u16ServiceId, u16ClientSub;
   tU16                    u16RegisterId = AMT_C_U16_REGID_INVALID;
   tU16                    u16MajorNumber, u16MinorNumber, u16PatchNumber;
   tU8                     u8RegisterState = AMT_C_U8_REGCONF_NO_SUCCESS;
   amt_tclServiceRegister  oServiceRegister(poMessage);
   tU8                     u8ServiceState = AMT_C_U8_SVCSTATE_NOT_AVAILABLE;

   /* get sender */
   u16Client = oServiceRegister.u16GetSourceAppID();
   // get sub sender
   u16ClientSub = oServiceRegister.u16GetSourceSubID();
   /* get the requested service */
   u16ServiceId = oServiceRegister.u16GetServiceID();

   u16MajorNumber = oServiceRegister.u16GetServiceMajorVersion();
   u16MinorNumber = oServiceRegister.u16GetServiceMinorVersion();
   u16PatchNumber = AMT_C_U16_SERVICE_VERSION_INVALID;

   #ifdef AIL_MESSAGE_TRACE_SVC_MESSAGES
   ail_vTraceMsg( TR_LEVEL_USER_2,
      "Application 0x%04x: ServiceRegister received! I've got request from client Application 0x%04x,%d for service 0x%04x",
      poAppInterface->u16AppId,
      u16Client,
      u16ClientSub,
      u16ServiceId );
   #endif

   if ( poAppInterface->bCheckVersionNumber( u16ServiceId, u16MajorNumber, u16MinorNumber, u16PatchNumber ) )
   /* the new registration request is accepted */
   {
      tBool bRegisterAccepted = FALSE;

      // Service CCA_C_U16_SRV_APPINFO is always available as it is offered by the AIL itself. 
      // Don't call bOnAcceptNewRegister() as the service CCA_C_U16_SRV_APPINFO must not be 
      // accepted by the user application. Directly call bCreateRegisterId() to generate a
      // register ID without going over bOnAcceptNewRegister().
      if (CCA_C_U16_SRV_APPINFO == u16ServiceId)
      {
        bRegisterAccepted = poAppInterface->bCreateRegisterId(u16ServiceId, u16Client, u16ClientSub, &u16RegisterId);
      }
      else
      {
        bRegisterAccepted = poAppInterface->bOnAcceptNewRegister(u16ServiceId, u16Client, u16ClientSub, &u16RegisterId);
      }

      if (TRUE == bRegisterAccepted)
      {
          if ( ail_bTakeListAccess( poAppInterface->hGeneralListAccess ) )
          /* list access is sheltered */
          {
             ail_tclServiceRegistry  oServiceRegistry(u16RegisterId, u16ServiceId, u16Client, u16ClientSub);
             /* set agreed version for this client to handle multi version FI */
             oServiceRegistry.vSetVersion(u16MajorNumber,u16MinorNumber,u16PatchNumber);
    
             ail_tclServiceRegistryIterator   iter(poAppInterface->poServiceRegistryList);
             tBool bHit = FALSE;
    
             for ( ; !iter.bIsDone() && !bHit; iter.vNext())
             /* check all list entries */
             {
                bHit = iter.oItem().bIsDataSet ( AMT_C_U16_REGID_INVALID, u16ServiceId, poAppInterface->u16AppId, AMT_C_U16_SUBID_INVALID );
    
                if ( bHit )
                /* the application has created a state entry for this service */
                {
                   u8ServiceState = iter.oItem().u8GetServiceState();
    
                   // client must automatically be informed about current service state
                   bServiceInfoRequired = TRUE;
                }
             }
    
             // if no state entry exists for this service, create it now
             if ( !bHit )
             {
                // Service CCA_C_U16_SRV_APPINFO is always available as it is offered by the AIL itself. 
                // So we can immediately set it to available.
                if (CCA_C_U16_SRV_APPINFO == u16ServiceId)
                {
                  u8ServiceState = AMT_C_U8_SVCSTATE_AVAILABLE;
                }
                else
                {
                  u8ServiceState = AMT_C_U8_SVCSTATE_NOT_AVAILABLE;
                }

                ail_tclServiceRegistry oOwnServiceRegistry( AMT_C_U16_REGID_INVALID, u16ServiceId, poAppInterface->u16AppId, AMT_C_U16_SUBID_INVALID);
                oOwnServiceRegistry.vSetServiceState( u8ServiceState );

                /* add the the element to the normal registration list */        
                (poAppInterface->poServiceRegistryList)->vAdd(oOwnServiceRegistry);
    
                // client must automatically be informed about current service state
                bServiceInfoRequired = TRUE;
             }
    
             oServiceRegistry.vSetServiceState(u8ServiceState);
    
             // add the new registration request to registration list         
             (poAppInterface->poServiceRegistryList)->vAdd(oServiceRegistry);
    
             
             u8RegisterState = AMT_C_U8_REGCONF_SUCCESS;

             // create a new message object 
             amt_tclServiceRegisterConf oMessageRegisterConf( poAppInterface->u16AppId
                                                            , u16Client
                                                            , u16ServiceId
                                                            , u16RegisterId
                                                            , u8RegisterState
                                                            , u16MajorNumber
                                                            , u16MinorNumber
                                                            , u16PatchNumber
                                                            , AMT_C_U16_DEFAULT_NULL   // source sub id
                                                            , u16ClientSub // target sub id
                                                            );
       
             if ( oMessageRegisterConf.bIsValid() )
             {
                // post this message to the waiting client   
                if ( !poAppInterface->bPostIpcMessage( poAppInterface->u16AppId
                                   , ail_hGetReceiverQueue( poAppInterface->poOpenedQueueList
                                                          , OSAL_C_INVALID_HANDLE
                                                          , u16Client
                                                          )
                                   , &oMessageRegisterConf
                                   , AIL_C_U32_CCA_PRIO_MSG_SERVICE_CONFIRMATION ) )
                {
                   oMessageRegisterConf.bDelete();
                   ail_vTraceMsg( TR_LEVEL_ERRORS, "Application 0x%04x: HandleMsgServiceRegister(): failed to send register-conf-msg(=SUCCESS)", poAppInterface->u16AppId );
                }
                else
                {
                  #ifdef AIL_MESSAGE_TRACE_SVC_MESSAGES
                  ail_vTraceMsg( TR_LEVEL_USER_2,
                     "Application 0x%04x: HandleMsgServiceRegister(): Evaluation done. Sent service register confirmation with ServiceId=0x%04x, ClientId=0x%04x, RegisterId=0x%04x, RegisterState=%d",
                     poAppInterface->u16AppId,
                     u16ServiceId,
                     u16Client,
                     u16RegisterId,
                     u8RegisterState
                  );
                  #endif
                }
             }
             else
             {
                ail_vTraceMsg( TR_LEVEL_ERRORS, "Application 0x%04x: HandleMsgServiceRegister(): register-conf-msg(=SUCCESS) invalid", poAppInterface->u16AppId );
             }
    
    
             if ( bServiceInfoRequired)
             // the application has created a state entry for this service 
             {
                #ifdef AIL_MESSAGE_TRACE_SVC_MESSAGES
                ail_vTraceMsg( TR_LEVEL_USER_2,
                   "Application 0x%04x: AutoInformation about ServiceState! " \
                   "service 0x%04x available for client 0x%04x,%d using RegisterId %d",
                   poAppInterface->u16AppId,
                   u16ServiceId,
                   u16Client,
                   u16ClientSub,
                   u16RegisterId );
                #endif
    
    
                // create a new message object 
                amt_tclServiceStatus oServiceStatus( poAppInterface->u16AppId
                                                   , u16Client
                                                   , u16ServiceId
                                                   , u16RegisterId
                                                   , u8ServiceState
                                                   , AMT_C_U16_DEFAULT_NULL   // source sub id
                                                   , u16ClientSub // target sub id
                                                   );
    
                if ( oServiceStatus.bIsValid() )
                {
                   if ( !poAppInterface->bPostIpcMessage( poAppInterface->u16AppId
                                      , ail_hGetReceiverQueue( poAppInterface->poOpenedQueueList
                                                             , OSAL_C_INVALID_HANDLE
                                                             , u16Client
                                                             )
                                      , &oServiceStatus
                                      , AIL_C_U32_CCA_PRIO_MSG_SERVICE_STATUS ) )
                   {
                      oServiceStatus.bDelete();
                      ail_vTraceMsg( TR_LEVEL_ERRORS, "Application 0x%04x: HandleMsgServiceRegister(): failed to send service-status-msg", poAppInterface->u16AppId );
                   }
                }
                else
                {
                   ail_vTraceMsg( TR_LEVEL_ERRORS, "Application 0x%04x: HandleMsgServiceRegister(): service-status-msg invalid", poAppInterface->u16AppId );
                }
             }
    
             /* release the list access */
             ail_bReleaseListAccess( poAppInterface->hGeneralListAccess ); //lint !e522: Expected void type, assignment, increment or decrement
    
          }
          /* else: send negative confirmation */
      }
      else
      {
          u8RegisterState = AMT_C_U8_REGCONF_SERVICE_ALREADY_REGISTERED;

          ail_vTraceMsg( TR_LEVEL_ERRORS,
             "Application 0x%04x: doesn't accept registration from client 0x%04x,%d for service 0x%04x, because the client is already registered for this service",
             poAppInterface->u16AppId,
             u16Client,
             u16ClientSub,
             u16ServiceId );
      }
   }
   /* else: send negative confirmation */
   else
   {
      u8RegisterState = AMT_C_U8_REGCONF_SERVICE_VERSION_NOT_SUPPORTED;

      ail_vTraceMsg( TR_LEVEL_ERRORS,
         "Application 0x%04x: couldn't accept registration from client 0x%04x,%d " \
         "for service 0x%04x, because wrong service-version",
         poAppInterface->u16AppId,
         u16Client,
         u16ClientSub,
         u16ServiceId );
   }

   if ( !( AMT_C_U8_REGCONF_SUCCESS == u8RegisterState ) )
   {
      /* create a new message object */
      amt_tclServiceRegisterConf oMessageRegisterConf
      (  
         poAppInterface->u16AppId,
         u16Client,
         u16ServiceId,
         u16RegisterId,
         u8RegisterState,
         u16MajorNumber,
         u16MinorNumber,
         u16PatchNumber,
         AMT_C_U16_DEFAULT_NULL, // source sub id
         u16ClientSub            // target sub id
      );
   
      if ( oMessageRegisterConf.bIsValid() )
      {
         // get message-queue to client
         OSAL_tMQueueHandle hMQ = OSAL_C_INVALID_HANDLE;
         hMQ = scd_OpenQueue(u16Client);  // do not use OpenedQueueList, 'cause this
                                          // is possibly the only message to this client
         if ( hMQ != OSAL_C_INVALID_HANDLE )
         {
            /* post this message to the waiting client */  
            if ( !poAppInterface->bPostIpcMessage(poAppInterface->u16AppId, hMQ, &oMessageRegisterConf, AIL_C_U32_CCA_PRIO_MSG_SERVICE_CONFIRMATION ) )
            {
               oMessageRegisterConf.bDelete();
               ail_vTraceMsg( TR_LEVEL_ERRORS, "Application 0x%04x: HandleMsgServiceRegister(): failed to send register-conf-msg(=NO_SUCCESS)", poAppInterface->u16AppId );
            }

            // close message-queue to client
            scd_s32CloseQueue(hMQ);
         }
         else
         {
            oMessageRegisterConf.bDelete();

            // else couldn't send message
            ail_vTraceMsg( TR_LEVEL_SYSTEM,
               "Application 0x%04x: couldn't send ServiceRegisterConf=NO_SUCCESS " \
               "to client 0x%04x for service 0x%04x",
               poAppInterface->u16AppId,
               u16Client,
               u16ServiceId );
         }
      }
      else
      {
         ail_vTraceMsg( TR_LEVEL_ERRORS, "Application 0x%04x: HandleMsgServiceRegister(): register-conf-msg(=NO_SUCCESS) invalid", poAppInterface->u16AppId );
      }
   }

   return(bMessageReleased);
   
  //## end ail_tclInternalDispatch::ail_bHandleMsgServiceRegister%3A9E0BD50316.body
}

tBool ail_tclInternalDispatch::ail_bErrorRejectMsgServiceRegister (amt_tclBaseMessage* poMessage) const
{
  //## begin ail_tclInternalDispatch::ail_bErrorRejectMsgServiceRegister%3B0921A702C1.body preserve=yes

   tBool bMessageForwarded = FALSE;

   // Downcast Object
   amt_tclServiceRegister  oServiceRegister(poMessage);

   /* get sender */
   tU16  u16Client = oServiceRegister.u16GetSourceAppID();
   /* get the requested service */
   tU16  u16ServiceId = oServiceRegister.u16GetServiceID();

   /* create a new message object */
   amt_tclServiceRegisterConf oMessageRegisterConf
   (  
      poAppInterface->u16AppId,
      u16Client,
      u16ServiceId,
      AMT_C_U16_REGID_INVALID,
      AMT_C_U8_REGCONF_NO_SUCCESS
      , AMT_C_U16_SERVICE_VERSION_INVALID
      , AMT_C_U16_SERVICE_VERSION_INVALID
      , AMT_C_U16_SERVICE_VERSION_INVALID
      , AMT_C_U16_DEFAULT_NULL   // source sub id
      , oServiceRegister.u16GetSourceSubID()   // target sub id
   );

   if ( oMessageRegisterConf.bIsValid() )
   {
      // get message-queue to client
      OSAL_tMQueueHandle hMQ = OSAL_C_INVALID_HANDLE;
      hMQ = scd_OpenQueue(u16Client);  // do not use OpenedQueueList, 'cause this
                                       // is possibly the only message to this client
      if ( hMQ != OSAL_C_INVALID_HANDLE )
      {
         /* post this message to the waiting client */  
         if ( !poAppInterface->bPostIpcMessage(poAppInterface->u16AppId, hMQ, &oMessageRegisterConf, AIL_C_U32_CCA_PRIO_MSG_SERVICE_CONFIRMATION ) )
         {
            oMessageRegisterConf.bDelete();
            ail_vTraceMsg( TR_LEVEL_ERRORS, "Application 0x%04x: ErrorRejectMsgServiceRegister(): failed to send register-conf-msg(=NO_SUCCESS)", poAppInterface->u16AppId );
         }

         // close message-queue to client
         scd_s32CloseQueue(hMQ);
      }
      else
      {
         // else couldn't send message
         oMessageRegisterConf.bDelete();

         ail_vTraceMsg( TR_LEVEL_SYSTEM,
            "Application 0x%04x: couldn't send ServiceRegisterConf=NO_SUCCESS " \
            "to client 0x%04x for service 0x%04x",
            poAppInterface->u16AppId,
            u16Client,
            u16ServiceId );
      }
   }
   else
   {
      ail_vTraceMsg( TR_LEVEL_ERRORS, "Application 0x%04x: ErrorRejectMsgServiceRegister(): register-conf-msg(=NO_SUCCESS) invalid", poAppInterface->u16AppId );
   }

   return(bMessageForwarded);

  //## end ail_tclInternalDispatch::ail_bErrorRejectMsgServiceRegister%3B0921A702C1.body
}

tBool ail_tclInternalDispatch::ail_bHandleMsgServiceRegisterConf (amt_tclBaseMessage* poMessage)
{
  //## begin ail_tclInternalDispatch::ail_bHandleMsgServiceRegisterConf%3AA345150140.body preserve=yes
   tBool bMessageForwarded = FALSE, bUnknownRegisterID = FALSE;
   tU16  u16Server, u16ServiceId, u16RegisterId, u16TargetSubId;
   tU8   u8RegisterState;


   // Downcast Object
   amt_tclServiceRegisterConf oServiceRegisterConf(poMessage);

   u8RegisterState = oServiceRegisterConf.u8GetRegisterState();
   u16RegisterId  = oServiceRegisterConf.u16GetRegisterID();
   u16ServiceId = oServiceRegisterConf.u16GetServiceID();
   u16Server = oServiceRegisterConf.u16GetSourceAppID();
   u16TargetSubId = oServiceRegisterConf.u16GetTargetSubID();

   #ifdef AIL_MESSAGE_TRACE_SVC_MESSAGES
   if ( ail_bIsTraceActive(TR_LEVEL_USER_2) )
   {
      ail_vTraceMsg( TR_LEVEL_USER_2, "Application 0x%04x: ServiceRegisterConf received! " \
         "I've got the register confirmation %d (%s) regarding RegisterId %d and service 0x%04x from Server Application 0x%04x",
         poAppInterface->u16AppId,
         u8RegisterState,
         ail_coszServiceRegisterConf(u8RegisterState),
         u16RegisterId,
         u16ServiceId,
         u16Server );
   }
   #endif

   if ( ail_bTakeListAccess( poAppInterface->hGeneralListAccess ) )
   /* list access is sheltered */
   {
      if ( (poAppInterface->poServiceSyncAnswerList)->nSize() )
      /* there is some thread waiting for an synchronous answer */
      {  
         ail_tclServiceSyncAnswerIterator iter(poAppInterface->poServiceSyncAnswerList);
         ail_tclServiceSyncAnswer*        poServiceSyncAnswer;

         for (; !iter.bIsDone() && !bMessageForwarded; iter.vNext())
         {
            if ( iter.oItem().bIsWaitForRegister( u16Server, u16ServiceId, u16TargetSubId ) )
            {
               poServiceSyncAnswer = &(iter.oItem());

               if ( u8RegisterState == AMT_C_U8_REGCONF_SUCCESS )
               /* fill the reference table first */
               {
                  ail_tclServiceReference oServiceReference( u16Server, u16ServiceId, u16RegisterId, u16TargetSubId);
                  oServiceReference.vSetVersion(oServiceRegisterConf.u16GetServiceMajorVersion(),
                     oServiceRegisterConf.u16GetServiceMinorVersion(),oServiceRegisterConf.u16GetServicePatchVersion());
                  /* add the new registration request to registration list */        
                  (poAppInterface->poServiceReferenceList)->vAdd(oServiceReference);
               }
               #ifndef AIL_KEEP_MSG_QUEUE_HANDLES_TO_OTHER_APPS_UNTIL_TERMINATION
               else
               {
                  // Service-Register failed, check whether this client have other
                  //  registrations for this server

                  // examine for other registrations to this server
                  tBool bFound = ail_bCheckRegistrationsToApp
                  (
                     poAppInterface->poServiceReferenceList,
                     poAppInterface->poServiceRegistryList,
                     OSAL_C_INVALID_HANDLE, // access already protected
                     u16Server
                  );

                  // if no other registration exists, close handle to
                  // messagequeue of this server
                  if (!bFound)
                  {
                     if ( poAppInterface->poOpenedQueueList )
                     {
                        ail_bDeleteFromOpenedQueueList
                        (
                           poAppInterface->poOpenedQueueList,
                           OSAL_C_INVALID_HANDLE, // access already protected
                           u16Server
                        );
                     } // else poOpenedQueueList doesn't exist
                  } // else other registrations to this server exists

               } // end else (register-state!=SUCCESS)
               #endif

               /* try to forward your message */
               /* if forwarding wasn't possible, then this message is asynchronously put into the message queue of the body thread */
               bMessageForwarded = poServiceSyncAnswer->bForwardAnswer(&oServiceRegisterConf);

            }
         }
         if ( !bMessageForwarded )
         /* it must be a message answer to an asynchronous register request */
         {
            bUnknownRegisterID = TRUE;
         }    
      }
      else
      /* no element in the synchron waiting list -> it's unknown for this class */
      {
         bUnknownRegisterID = TRUE;
      }
      /* release the list access */
      ail_bReleaseListAccess( poAppInterface->hGeneralListAccess ); //lint !e522: Expected void type, assignment, increment or decrement

      if ( bUnknownRegisterID == TRUE )
      {
         poAppInterface->vUnknownRegisterConf ( oServiceRegisterConf );
      }
   }  
   return(bMessageForwarded);

  //## end ail_tclInternalDispatch::ail_bHandleMsgServiceRegisterConf%3AA345150140.body
}

tBool ail_tclInternalDispatch::ail_bHandleMsgServiceUnregister (amt_tclBaseMessage* poMessage)
{
  //## begin ail_tclInternalDispatch::ail_bHandleMsgServiceUnregister%3AA344E2035A.body preserve=yes

   tBool                   bMessageReleased = FALSE;
   tU16                    u16ServiceId, u16RegisterId;

   // Downcast Object
   amt_tclServiceUnregister oServiceUnregister(poMessage);

   /* get the corresponding service */
   u16ServiceId = oServiceUnregister.u16GetServiceID();
   /* get the corresponding RegisterId */
   u16RegisterId = oServiceUnregister.u16GetRegisterID();

   #ifdef AIL_MESSAGE_TRACE_SVC_MESSAGES
   /* get sender */
   tU16 u16Client = oServiceUnregister.u16GetSourceAppID();

   ail_vTraceMsg( TR_LEVEL_USER_2,
      "Application 0x%04x: ServiceUnregister received! " \
      "I've got request from client Application 0x%04x for ServiceId 0x%04x and RegisterId %d",
      poAppInterface->u16AppId,
      u16Client,
      u16ServiceId,
      u16RegisterId );
   #endif

   poAppInterface->vOnUnregister (u16ServiceId, u16RegisterId);

   return(bMessageReleased);

  //## end ail_tclInternalDispatch::ail_bHandleMsgServiceUnregister%3AA344E2035A.body
}

tBool ail_tclInternalDispatch::ail_bHandleMsgServiceData (amt_tclBaseMessage* poMessage)
{
  //## begin ail_tclInternalDispatch::ail_bHandleMsgServiceData%3AA345BD0355.body preserve=yes

   tBool bMessageForwarded = FALSE;
   tBool bMessageValid = FALSE;
   tU16  u16ServiceId, u16RegisterId;
   tU16  u16SourceAppId;


   // Downcast Object
   amt_tclServiceData oServiceData(poMessage);

   u16ServiceId = oServiceData.u16GetServiceID();
   u16RegisterId = oServiceData.u16GetRegisterID();
   u16SourceAppId = oServiceData.u16GetSourceAppID();

   #ifdef AIL_MESSAGE_TRACE_SVC_DATA_MESSAGES
   tU16 u16FunctionId = oServiceData.u16GetFunctionID();
   ail_vTraceMsg( TR_LEVEL_USER_3,
      "Application 0x%04x: ServiceData with u32DynMsgSize = %d received! " \
      "Sender 0x%04x uses ServiceId 0x%04x with RegisterId %d for FunctionId %d having the OPTYPE %d",
      poAppInterface->u16AppId,
      oServiceData.u32GetDynMsgSize(),
      u16SourceAppId,
      u16ServiceId,
      u16RegisterId,
      u16FunctionId,
      oServiceData.u8GetOpCode() );
   #endif

   /* server and client role can be identified by the optype */
   if (  oServiceData.bIsServerMessage() )
   /* this is an server answer -> refer to service reference table */
   {
      if ( ail_bTakeListAccess( poAppInterface->hGeneralListAccess ) )
      /* list access is sheltered */
      {
         tBool bFound = FALSE;
         tU16  u16SubId = oServiceData.u16GetTargetSubID();
         tU8  u8OpType  = oServiceData.u8GetOpCode();

         amt_tclServiceDataError oErrorMsg(poMessage); //lint !e1774: Could use dynamic_cast

         if ((u8OpType == AMT_C_U8_CCAMSG_OPCODE_ERROR) && (oErrorMsg.u16GetErrorData() == AMT_C_U16_ERROR_UNKNOWN_REG_ID))
         {
           // framework has deleted entry in table -> entry will not be found, but message is still valid
           
           // Keep 'bFound' set to FALSE to always send an unregister message to force a drop of the service 
           // registration at server side if AMT_C_U16_ERROR_UNKNOWN_REG_ID might have been send by mistake. 
           // If the service regisration is not dropped at server side then it is not possible for this client 
           // to again register for the same service.

           /* message is allowed to pass the filter and user application is informed about that */
           bMessageValid = TRUE;
         }
         else
         {
            ail_tclServiceReferenceIterator  iter(poAppInterface->poServiceReferenceList);
   
            for ( ; !iter.bIsDone() && !bFound; iter.vNext())
            {
               /* check correctness */
               if ( iter.oItem().bIsDataSet( u16ServiceId, u16SourceAppId, u16RegisterId, u16SubId ) )
               {
                  bFound = TRUE;
   
                  /* message is allowed to pass the filter */
                  bMessageValid = TRUE;
               }
            }
         }
         /* release the list access */
         ail_bReleaseListAccess( poAppInterface->hGeneralListAccess ); //lint !e522: Expected void type, assignment, increment or decrement

         if ( !bFound )
         {
            /* connection to this server is not established anymore */
            /* registration is unknown, inform server to clear it from it's registration list */
            /* //// Send ServiceUnregister instead of UnknownRegisterID to the server /////// */

            /* create a new message object */
            amt_tclServiceUnregister oMessageServiceUnregister( poAppInterface->u16AppId, u16SourceAppId, u16ServiceId, u16RegisterId , oServiceData.u16GetTargetSubID() );

            if ( oMessageServiceUnregister.bIsValid() )
            {
               /* post this message to the server */  
               if ( !poAppInterface->bPostIpcMessage(poAppInterface->u16AppId,
                        ail_hGetReceiverQueue( poAppInterface->poOpenedQueueList, poAppInterface->hGeneralListAccess, u16SourceAppId),
                        (amt_tclBaseMessage*) &oMessageServiceUnregister, AIL_C_U32_CCA_PRIO_MSG_SERVICE_UNREGISTER ) )
               {
                  oMessageServiceUnregister.bDelete();
                  ail_vTraceMsg( TR_LEVEL_ERRORS, "Application 0x%04x: HandleMsgServiceData(): failed to send service-unregister-msg", poAppInterface->u16AppId );
               }
               else
               {
                    ail_vTraceMsg( TR_LEVEL_ERRORS, "Application 0x%04x: HandleMsgServiceData(): automatic service-unregister for service 0x%04x to client 0x%04x", poAppInterface->u16AppId, u16ServiceId, u16SourceAppId);
               }
            }
            else
            {
               ail_vTraceMsg( TR_LEVEL_ERRORS, "Application 0x%04x: HandleMsgServiceData(): service-unregister-msg invalid", poAppInterface->u16AppId );
            }

            #ifndef AIL_KEEP_MSG_QUEUE_HANDLES_TO_OTHER_APPS_UNTIL_TERMINATION
            // possibly last message to this server, close queue
            if ( ail_bTakeListAccess( poAppInterface->hGeneralListAccess ) )
            /* list access is sheltered */
            {
               // examine for other registrations to this server
               tBool bRegistrationFound = ail_bCheckRegistrationsToApp(poAppInterface->poServiceReferenceList, poAppInterface->poServiceRegistryList, OSAL_C_INVALID_HANDLE/* access already protected*/,  u16SourceAppId);

               // if no other registration exists, close handle to
               // messagequeue of this server
               if (!bRegistrationFound)
               {
                  if ( poAppInterface->poOpenedQueueList )
                  {
                     ail_bDeleteFromOpenedQueueList(poAppInterface->poOpenedQueueList, OSAL_C_INVALID_HANDLE/* access already protected */, u16SourceAppId);
                  } // else poOpenedQueueList doesn't exist
               } // else other registrations to this server exists

               /* release the list access */
               ail_bReleaseListAccess( poAppInterface->hGeneralListAccess ); //lint !e522: Expected void type, assignment, increment or decrement
            } // else no list-access
            #endif
         }

         /* +++
         => if ( !bMessageValid )
         if a message is not linked to the application, because the connection
         to this server is not established anymore and it must be deleted
         => this is done automatically, if !bMessageValid && !bMessageForwarded
         +++ */
      }
   }
   else
   /* some client has sent a command to the server -> refer to service registry */
   {
      if ( ail_bTakeListAccess( poAppInterface->hGeneralListAccess ) )
      /* list access is sheltered */
      {
         tBool bFound = FALSE;
         tU16  u16SubId = oServiceData.u16GetSourceSubID();

         ail_tclServiceRegistryIterator  iter(poAppInterface->poServiceRegistryList);

         for ( ; !iter.bIsDone() && !bFound; iter.vNext())
         {
            /* check correctness */
            if ( iter.oItem().bIsDataSet( u16RegisterId, u16ServiceId, u16SourceAppId, u16SubId ) )
            {
               bFound = TRUE;

               // allow relupreg and ClientPortAcknowledge even if servicestate is NOT_AVAILABLE
               if (  iter.oItem().u8GetServiceState() == AMT_C_U8_SVCSTATE_AVAILABLE
                  || (  iter.oItem().u8GetServiceState() == AMT_C_U8_SVCSTATE_NOT_AVAILABLE
                     && oServiceData.u8GetOpCode() == AMT_C_U8_CCAMSG_OPCODE_RELUPREG )
                  || (  iter.oItem().u8GetServiceState() == AMT_C_U8_SVCSTATE_NOT_AVAILABLE
                     && oServiceData.u8GetOpCode() == AMT_C_U8_CCAMSG_OPCODE_CLIENT_PORT_ACK ) )
               {
                  /* message is allowed to pass the filter */
                  bMessageValid = TRUE;
               }
               /* else: not available or waiting to be unregistered */
            }
         }
         /* release the list access */
         ail_bReleaseListAccess( poAppInterface->hGeneralListAccess ); //lint !e522: Expected void type, assignment, increment or decrement

         if ( !bFound )
         {
            /* registration is unknown, inform client to clear it from it's reference list */

            /* //// Send UnknownRegisterID to the client //// */

            /* create a new message object */
            amt_tclServiceDataError oMessageUnknownRegisterID( oServiceData, AMT_C_U16_ERROR_UNKNOWN_REG_ID);
 
            if ( oMessageUnknownRegisterID.bIsValid() )
            {
               // get message-queue to client
               OSAL_tMQueueHandle hMQ = OSAL_C_INVALID_HANDLE;
               hMQ = scd_OpenQueue(u16SourceAppId);   // do not use OpenedQueueList, 'cause this
                                                      // is possibly the only message to this client
               if ( hMQ != OSAL_C_INVALID_HANDLE )
               {
                  /* post this message to the client */  
                  if ( !poAppInterface->bPostIpcMessage(poAppInterface->u16AppId, hMQ, (amt_tclBaseMessage*) &oMessageUnknownRegisterID, AIL_C_U32_CCA_PRIO_MSG_SERVICE_DATA_SERVER ) )
                  {
                     oMessageUnknownRegisterID.bDelete();
                     ail_vTraceMsg( TR_LEVEL_ERRORS, "Application 0x%04x: HandleMsgServiceData(): failed to send error-msg (unknown register-id)", poAppInterface->u16AppId );
                  }
                  else
                  {
                     ail_vTraceMsg( TR_LEVEL_ERRORS, "Application 0x%04x: HandleMsgServiceData():" \
                                     " registration is unknown, inform client 0x%04x to clear it " \
                                     "from it's reference list for service 0x%04x", 
                                      poAppInterface->u16AppId, u16SourceAppId, u16ServiceId);
                  }

                  // close message-queue to client
                  scd_s32CloseQueue(hMQ);
               }
               else
               {
                  // else couldn't send message
                  oMessageUnknownRegisterID.bDelete();

                  ail_vTraceMsg( TR_LEVEL_SYSTEM,
                     "Application 0x%04x: couldn't send AMT_C_U16_ERROR_UNKNOWN_REG_ID " \
                     "to client 0x%04x,%d with unknown reg-id %d for service 0x%04x",
                     poAppInterface->u16AppId, u16SourceAppId, u16SubId, u16RegisterId,u16ServiceId );
               }
            }
            else
            {
               ail_vTraceMsg( TR_LEVEL_ERRORS, "Application 0x%04x: HandleMsgServiceData(): error-msg (unknown register-id) invalid", poAppInterface->u16AppId );
            }
         }
         else if ( !bMessageValid )
         /* connection is registered, but actually service isn't available */
         {
            amt_tclServiceDataError oErrorMsg( oServiceData, AMT_C_U16_ERROR_TEMPORARY_NOT_AVAILABLE);

            if ( oErrorMsg.bIsValid() )
            {
               /* post this message to the client */  
               if ( !poAppInterface->bPostIpcMessage(poAppInterface->u16AppId, 
                        ail_hGetReceiverQueue( poAppInterface->poOpenedQueueList, poAppInterface->hGeneralListAccess, oErrorMsg.u16GetTargetAppID()),
                        (amt_tclBaseMessage*) &oErrorMsg,  AIL_C_U32_CCA_PRIO_MSG_SERVICE_DATA_SERVER ) )
               {
                  oErrorMsg.bDelete();
                  ail_vTraceMsg( TR_LEVEL_ERRORS, "Application 0x%04x: HandleMsgServiceData(): failed to send error-msg (temp. not available)", poAppInterface->u16AppId );
               }
               else
               {
                  ail_vTraceMsg( TR_LEVEL_ERRORS, "Application 0x%04x: HandleMsgServiceData(): send error-msg (temp. not available)", poAppInterface->u16AppId );
               }
            }
            else
            {
               ail_vTraceMsg( TR_LEVEL_ERRORS, "Application 0x%04x: HandleMsgServiceData(): error-msg (temp. not available) invalid", poAppInterface->u16AppId );
            }

         }

         /* +++
         => if ( !bFound || !bMessageValid )
         if the connection is not established or the service status has become invalid,
         the message is not linked to the application and it must be deleted
         => this is done automatically, if !bMessageValid && !bMessageForwarded
         +++ */
      }
   }

   if ( bMessageValid )
   {
      // Special handling for service data messages of the internal AIL service CCA_C_U16_SRV_APPINFO.
      if ((u16ServiceId == CCA_C_U16_SRV_APPINFO) && (oServiceData.bIsClientMessage() == TRUE))
      {
        if (oServiceData.u8GetOpCode() == AMT_C_U8_CCAMSG_OPCODE_GET)
        {
          ail_vHandleServiceAppInfo(poMessage);
          bMessageForwarded = TRUE;
        }
        else
        {
          // Do nothing for Client OpCodes other than AMT_C_U8_CCAMSG_OPCODE_GET 
          // as only this OpCode is supported for service CCA_C_U16_SRV_APPINFO.
        }
      }
      else
      {
        poAppInterface->vOnNewMessage ( poMessage );
        bMessageForwarded = TRUE;
      }
   }

   return(bMessageForwarded);

  //## end ail_tclInternalDispatch::ail_bHandleMsgServiceData%3AA345BD0355.body
}


/*******************************************************************************
*
* FUNCTION: ail_tclInternalDispatch::ail_vHandleServiceAppInfo
*
* DESCRIPTION: Evaluate servica data messages of the CCA_C_U16_SRV_APPINFO 
*              service. Possible and handled functions IDs are :
*
*              - FW_AILFI_C_U16_SERVICEREGISTRYLIST
*
*                Get and return the content of the service registry list.
*
*              - FW_AILFI_C_U16_SERVICEREFERENCELIST
*
*                Get and return the content of the service reference list.
*
*              - FW_AILFI_C_U16_SERVERAPPLICATIONLIST
*
*                Get and return the content of the server application list.
*
* PARAMETER: [IN] poMessage = Pointer to the service data message.
*
* RETURNVALUE: None.
*
*******************************************************************************/
tVoid ail_tclInternalDispatch::ail_vHandleServiceAppInfo(amt_tclBaseMessage* poMessage)
{
  amt_tclServiceData oServiceData(poMessage);

  tU16 u16ServiceId   = oServiceData.u16GetServiceID();
  tU16 u16SourceAppId = oServiceData.u16GetSourceAppID();
  tU16 u16SourceSubId = oServiceData.u16GetSourceSubID();
  tU16 u16RegisterId  = oServiceData.u16GetRegisterID();
  tU16 u16FunctionId  = oServiceData.u16GetFunctionID();
  tU16 u16CmdCounter  = oServiceData.u16GetCmdCounter();

  tU16 u16MajorVersionNumber;
  tU16 u16MinorVersionNumber;
  tU16 u16PatchVersionNumber;

  ail_tenCommunicationError enResult = AIL_EN_N_NO_ERROR;

  switch (u16FunctionId)
  {
    /* -------------------------------------------------------------------------------- */

    case FW_AILFI_C_U16_SERVICEREGISTRYLIST :
    {
      fw_ailfi_tclMsgServiceRegistryListStatus oMsgServiceRegistryListStatus;

      if (ail_bTakeListAccess(poAppInterface->hGeneralListAccess))
      {
        ail_tclServiceRegistryIterator ServiceRegistryIterator(poAppInterface->poServiceRegistryList);

        for ( ; ServiceRegistryIterator.bIsDone() == FALSE; ServiceRegistryIterator.vNext())
        {
          fw_fi_tcl_ServiceRegistry oServiceRegistryEntry;

          oServiceRegistryEntry.u16ClientAppId = ServiceRegistryIterator.oItem().u16GetClientAppId();
          oServiceRegistryEntry.u16ClientSubId = ServiceRegistryIterator.oItem().u16GetClientSubId();
          oServiceRegistryEntry.u8ServiceState = ServiceRegistryIterator.oItem().u8GetServiceState();
          oServiceRegistryEntry.u16RegisterId  = ServiceRegistryIterator.oItem().u16GetRegisterId();
          oServiceRegistryEntry.u16ServiceId   = ServiceRegistryIterator.oItem().u16GetServiceId();

          ServiceRegistryIterator.oItem().bGetVersion(u16MajorVersionNumber, u16MinorVersionNumber, u16PatchVersionNumber);

          oServiceRegistryEntry.u16MajorVersion = u16MajorVersionNumber;
          oServiceRegistryEntry.u16MinorVersion = u16MinorVersionNumber;
          oServiceRegistryEntry.u16PatchVersion = u16PatchVersionNumber;

          oMsgServiceRegistryListStatus.oServiceRegistryList.push_back(oServiceRegistryEntry);
        }

        ail_bReleaseListAccess(poAppInterface->hGeneralListAccess);
      }

      fi_tclVisitorMessage oVisitorMsg(oMsgServiceRegistryListStatus, AIL_C_U16_FI_MAJOR_VERSION_SERVICE_APPINFO);

      oVisitorMsg.vInitServiceData(poAppInterface->u16AppId,             // Source AppID
                                   u16SourceAppId,                       // Target AppID
                                   AMT_C_U8_CCAMSG_STREAMTYPE_NODATA,    // StreamType
                                   0,                                    // StreamCounter
                                   u16RegisterId,                        // RegisterID
                                   u16CmdCounter,                        // CmdCounter,
                                   u16ServiceId,                         // ServiceID,
                                   u16FunctionId,                        // Function ID
                                   AMT_C_U8_CCAMSG_OPCODE_STATUS);       // Opcode

      oVisitorMsg.vSetTargetSubID(u16SourceSubId);

      enResult = poAppInterface->enPostMessage(&oVisitorMsg, TRUE);

      if (enResult != AIL_EN_N_NO_ERROR)
      {
        ail_vTraceMsg(TR_LEVEL_FATAL, "Application 0x%04x: ail_vHandleServiceAppInfo() => Call of enPostMessage() for service-registry-list failed", poAppInterface->u16AppId);
      }

      oMsgServiceRegistryListStatus.vDestroy();

      break;
    }

    /* -------------------------------------------------------------------------------- */

    case FW_AILFI_C_U16_SERVICEREFERENCELIST :
    {
      fw_ailfi_tclMsgServiceReferenceListStatus oMsgServiceReferenceListStatus;

      if (ail_bTakeListAccess(poAppInterface->hGeneralListAccess))
      {
        ail_tclServiceReferenceIterator ServiceReferenceIterator(poAppInterface->poServiceReferenceList);

        for ( ; ServiceReferenceIterator.bIsDone() == FALSE; ServiceReferenceIterator.vNext())
        {
          fw_fi_tcl_ServiceReference oServiceReferenceEntry;

          oServiceReferenceEntry.u16ServerAppId = ServiceReferenceIterator.oItem().u16GetServerAppId();
          oServiceReferenceEntry.u16ServerSubId = ServiceReferenceIterator.oItem().u16GetSubId();
          oServiceReferenceEntry.u8ServiceState = ServiceReferenceIterator.oItem().u8GetServiceState();
          oServiceReferenceEntry.u16RegisterId  = ServiceReferenceIterator.oItem().u16GetRegisterId();
          oServiceReferenceEntry.u16ServiceId   = ServiceReferenceIterator.oItem().u16GetServiceId();

          ServiceReferenceIterator.oItem().bGetVersion(u16MajorVersionNumber, u16MinorVersionNumber, u16PatchVersionNumber);

          oServiceReferenceEntry.u16MajorVersion = u16MajorVersionNumber;
          oServiceReferenceEntry.u16MinorVersion = u16MinorVersionNumber;
          oServiceReferenceEntry.u16PatchVersion = u16PatchVersionNumber;

          oMsgServiceReferenceListStatus.oServiceReferenceList.push_back(oServiceReferenceEntry);
        }

        ail_bReleaseListAccess(poAppInterface->hGeneralListAccess);
      }

      fi_tclVisitorMessage oVisitorMsg(oMsgServiceReferenceListStatus, AIL_C_U16_FI_MAJOR_VERSION_SERVICE_APPINFO);

      oVisitorMsg.vInitServiceData(poAppInterface->u16AppId,             // Source AppID
                                   u16SourceAppId,                       // Target AppID
                                   AMT_C_U8_CCAMSG_STREAMTYPE_NODATA,    // StreamType
                                   0,                                    // StreamCounter
                                   u16RegisterId,                        // RegisterID
                                   u16CmdCounter,                        // CmdCounter,
                                   u16ServiceId,                         // ServiceID,
                                   u16FunctionId,                        // Function ID
                                   AMT_C_U8_CCAMSG_OPCODE_STATUS);       // Opcode

      oVisitorMsg.vSetTargetSubID(u16SourceSubId);

      enResult = poAppInterface->enPostMessage(&oVisitorMsg, TRUE);

      if (enResult != AIL_EN_N_NO_ERROR)
      {
        ail_vTraceMsg(TR_LEVEL_FATAL, "Application 0x%04x: ail_vHandleServiceAppInfo() => Call of enPostMessage() for service-reference-list failed", poAppInterface->u16AppId);
      }

      oMsgServiceReferenceListStatus.vDestroy();

      break;
    }

    /* -------------------------------------------------------------------------------- */

    case FW_AILFI_C_U16_SERVERAPPLICATIONLIST :
    {
      fw_ailfi_tclMsgServerApplicationListStatus oMsgServerApplicationListStatus;

      if (ail_bTakeListAccess(poAppInterface->hGeneralListAccess))
      {
        ail_tclServerApplicationIterator ServerApplicationIterator(poAppInterface->m_poServerApplicationList);

        for ( ; ServerApplicationIterator.bIsDone() == FALSE; ServerApplicationIterator.vNext())
        {
          fw_fi_tcl_ServerApplication oServerApplicationEntry;

          oServerApplicationEntry.u16AppId         =      ServerApplicationIterator.oItem().u16GetAppId();
          oServerApplicationEntry.u16ServiceId     =      ServerApplicationIterator.oItem().u16GetServiceId();
          oServerApplicationEntry.bDedicatedServer =      ServerApplicationIterator.oItem().bIsDedicatedServer();
          oServerApplicationEntry.u8ServerAppState = (tU8)ServerApplicationIterator.oItem().enGetServerAppState();

          ail_tclServiceRequestList* poServiceRequestList = ServerApplicationIterator.oItem().poGetServiceRequestList();

          if (poServiceRequestList != NULL)
          {
            ail_tclServiceRequestIterator ServiceRequestIterator(poServiceRequestList);

            for ( ; ServiceRequestIterator.bIsDone() == FALSE; ServiceRequestIterator.vNext())
            {
              fw_fi_tcl_ServiceRequest oServiceRequestEntry;
    
              oServiceRequestEntry.u16ClientSubId         = ServiceRequestIterator.oItem().u16GetClientSubId();
              oServiceRequestEntry.u16ServiceMajorVersion = ServiceRequestIterator.oItem().u16GetServiceMajorVersion();
              oServiceRequestEntry.u16ServiceMinorVersion = ServiceRequestIterator.oItem().u16GetServiceMinorVersion();

              oServerApplicationEntry.oServiceRequestList.push_back(oServiceRequestEntry);
            }
          }

          oMsgServerApplicationListStatus.oServerApplicationList.push_back(oServerApplicationEntry);
        }

        ail_bReleaseListAccess(poAppInterface->hGeneralListAccess);
      }

      fi_tclVisitorMessage oVisitorMsg(oMsgServerApplicationListStatus, AIL_C_U16_FI_MAJOR_VERSION_SERVICE_APPINFO);

      oVisitorMsg.vInitServiceData(poAppInterface->u16AppId,             // Source AppID
                                   u16SourceAppId,                       // Target AppID
                                   AMT_C_U8_CCAMSG_STREAMTYPE_NODATA,    // StreamType
                                   0,                                    // StreamCounter
                                   u16RegisterId,                        // RegisterID
                                   u16CmdCounter,                        // CmdCounter,
                                   u16ServiceId,                         // ServiceID,
                                   u16FunctionId,                        // Function ID
                                   AMT_C_U8_CCAMSG_OPCODE_STATUS);       // Opcode

      oVisitorMsg.vSetTargetSubID(u16SourceSubId);

      enResult = poAppInterface->enPostMessage(&oVisitorMsg, TRUE);

      if (enResult != AIL_EN_N_NO_ERROR)
      {
        ail_vTraceMsg(TR_LEVEL_FATAL, "Application 0x%04x: ail_vHandleServiceAppInfo() => Call of enPostMessage() for server-application-list failed", poAppInterface->u16AppId);
      }

      oMsgServerApplicationListStatus.vDestroy();

      break;
    }

    /* -------------------------------------------------------------------------------- */

    default :

      ail_vTraceMsg(TR_LEVEL_FATAL, "Application 0x%04x: ail_vHandleServiceAppInfo() => Unknown function ID = 0x%04x",
                    poAppInterface->u16AppId, u16FunctionId);

    break;

    /* -------------------------------------------------------------------------------- */
  }

  poMessage->bDelete(); 
}

tBool ail_tclInternalDispatch::ail_bHandleMsgServiceStatus (amt_tclBaseMessage* poMessage)
{
  //## begin ail_tclInternalDispatch::ail_bHandleMsgServiceStatus%3AA343DB0320.body preserve=yes

   tBool                         bMessageReleased = FALSE;
   tU16                          u16ServiceId, u16RegisterId, u16SourceAppId, u16SubId;
   tU8                           u8ServiceState;

   // oHelpList is not required, because each SubId gets it's own ServiceStatus
   // ail_tclServiceReferenceList   oHelpList;


   // Downcast Object
   amt_tclServiceStatus oServiceStatus(poMessage);

   u16ServiceId = oServiceStatus.u16GetServiceID();
   u16RegisterId = oServiceStatus.u16GetRegisterID();
   u16SourceAppId = oServiceStatus.u16GetSourceAppID(); // server app id
   u8ServiceState = oServiceStatus.u8GetServiceState();
   u16SubId = oServiceStatus.u16GetTargetSubID(); // client sub id

   #ifdef AIL_MESSAGE_TRACE_SVC_MESSAGES
   if ( ail_bIsTraceActive(TR_LEVEL_USER_2) )
   {
      ail_vTraceMsg( TR_LEVEL_USER_2,
         "Application 0x%04x: ServiceStatus received! " \
         "service 0x%04x from Server 0x%04x using RegisterId %d has the new state %d (%s)",
         poAppInterface->u16AppId, u16ServiceId, u16SourceAppId, u16RegisterId, u8ServiceState, ail_coszServiceStatus(u8ServiceState) );
   }
   #endif

   /* work on reference list: Only a server uses this message to inform a client */

   if ( ail_bTakeListAccess( poAppInterface->hGeneralListAccess ) )
   /* list access is sheltered */
   {
      tBool bFound = FALSE;

      ail_tclServiceReferenceIterator  iter(poAppInterface->poServiceReferenceList);

      for ( ; !iter.bIsDone(); iter.vNext())
      {
         /* check correctness */
         if ( iter.oItem().bIsDataSet( u16ServiceId, u16SourceAppId, u16RegisterId, u16SubId ) )
         /* there is sent a ServiceState-Message for every registered connection */
         {
            bFound = TRUE;
            break;
         }
      }
      
      /* release the list access */
      ail_bReleaseListAccess( poAppInterface->hGeneralListAccess ); //lint !e522: Expected void type, assignment, increment or decrement


      if ( bFound || u8ServiceState == AMT_C_U8_SVCSTATE_REG_DENIED )
      /* not getting obsolete in the meantime or that was no information about denied sercive before */
      {
         poAppInterface->vOnServiceState( u16ServiceId, u16SourceAppId, u16RegisterId, u8ServiceState, u16SubId);
      }
   }

   return(bMessageReleased);

  //## end ail_tclInternalDispatch::ail_bHandleMsgServiceStatus%3AA343DB0320.body
}

tBool ail_tclInternalDispatch::ail_bHandleMsgPowerMessage (amt_tclBaseMessage* poMessage)
{
  //## begin ail_tclInternalDispatch::ail_bHandleMsgPowerMessage%3AA3469D032F.body preserve=yes

   tBool                   bMessageReleased = FALSE;
   tU16                    u16PowerType;
   tU32                    u32PowerData1;
   tU32                    u32PowerData2;

   // Downcast Object
   amt_tclPowerMessage oPowerMessage(poMessage);

   /* only for test purpose */
   // tU16 u16LPMAdress = oPowerMessage.u16GetSourceAppID();

   u16PowerType = oPowerMessage.u16GetPowerType();
   u32PowerData1 = oPowerMessage.u32GetPowerData1();
   u32PowerData2 = oPowerMessage.u32GetPowerData2();

   #ifdef AIL_MESSAGE_TRACE_POWER_MESSAGES
   ail_vTraceMsg( TR_LEVEL_USER_1,
      "Application 0x%04x: PowerMessage received! " \
      "PowerType = %d, PowerData1 = %d, PowerData2 = %d",
      poAppInterface->u16AppId, u16PowerType, u32PowerData1, u32PowerData2 );
   #endif

//#define START_CONF_FAILED_SIMULATION /*udo*/
#if defined START_CONF_FAILED_SIMULATION
   if ( u16PowerType = AMT_C_U16_PWR_PROXY_START_CONF )
   {
      u16PowerType = AMT_C_U16_PWR_PROXY_START_REJ;
   }
#endif  

   switch ( u16PowerType )
   {
      case AMT_C_U16_PWR_PROXY_START_CONF:
      {
         if ( poAppInterface->enInterfaceState < AIL_EN_N_APPLICATION_INITIALIZED )
         /* only accepted, if not initialized before */
         {
            /* store startup information from LPM-Proxy */
            poAppInterface->u32StartupInfo = u32PowerData2;
            if ( poAppInterface->bOnInit() )
            /* application ready initialized */
            {
               /* application is free now to process all message */
               poAppInterface->enInterfaceState = AIL_EN_N_APPLICATION_INITIALIZED;
               /* ApplicationPowerState == SY_STATE_INITIALIZED */
               
               poAppInterface->u32LastConfirmedAppState = AMT_C_U32_STATE_INITIALIZED; 

               /* note: not guarded by a semphore, because it's done in one instruction */

               tBool bSendSuccess = poAppInterface->bSendCCAPowerMsg (poAppInterface->u16LpmId, 
                                                 poAppInterface->hGetLpmInQueue(),
                                                 AIL_C_U32_CCA_PRIO_MSG_POWER,
                                                 AMT_C_U16_PWR_APP_INITIALIZED, 
                                                 poAppInterface->u32LastConfirmedAppState, 
                                                 (tU32) 0x00);

               if ( poAppInterface->u32WdgTime )
               /* a watchdog has to be installed */
               {
                  tS32 s32OsalError = OSAL_s32TimerCreate(ail_tclAppAdapt::vTriggerWdg,(tPVoid)poAppInterface,&poAppInterface->hWdgTimer);
                  if ( s32OsalError == OSAL_OK )
                  {
                     s32OsalError = OSAL_s32TimerSetTime( poAppInterface->hWdgTimer,poAppInterface->u32WdgTime,0);
                  }
                  if ( s32OsalError == OSAL_OK )
                  /* register application for supervising */
                  {
                     bSendSuccess = poAppInterface->bSendCCAPowerMsg (poAppInterface->u16LpmId, 
                                                                      poAppInterface->hGetLpmInQueue(),
                                                                      AIL_C_U32_CCA_PRIO_MSG_POWER,
                                                                      AMT_C_U16_PWR_SVM_APP_REGISTER, 
                                                                      AMT_C_U32_PWR_SVM_APPREG_ENTRYNOTIFY
                                                                        |AMT_C_U32_PWR_SVM_APPRECOVER_LOG, 
                                                                      poAppInterface->u32WdgTime);

                  } // else no watchdog-timer could be installed, wait for trigger to shutdown
                  else
                  {
                     ail_vTraceMsg( TR_LEVEL_ERRORS, "Application 0x%04x: failed to set wdg-timer", poAppInterface->u16AppId );
                  }
               }
               if ( !bSendSuccess )
               {
                  ail_vTraceMsg( TR_LEVEL_FATAL, "Application 0x%04x: PWR_PROXY_START_CONF: failed to send pwr-msg", poAppInterface->u16AppId );
                  poAppInterface->vApplicationRequestErrorEnd();
               }
               else
               {
                  #ifdef AIL_MESSAGE_TRACE_POWER_MESSAGES
                  ail_vTraceMsg( TR_LEVEL_USER_1, "Application 0x%04x: PWR_PROXY_START_CONF received, PWR_APP_INITIALIZED sent", poAppInterface->u16AppId );
                  #endif
               }
            }
            else
            {
               ail_vTraceMsg( TR_LEVEL_FATAL, "Application 0x%04x: PWR_PROXY_START_CONF: bOnInit failed", poAppInterface->u16AppId );
               poAppInterface->vApplicationRequestErrorEnd(AIL_C_U32_ERROR_ONINIT_FAILED);
            }
         }
         else
         {
            ail_vTraceMsg( TR_LEVEL_FATAL, "Application 0x%04x: PWR_PROXY_START_CONF: already initialized", poAppInterface->u16AppId );
            poAppInterface->vApplicationRequestErrorEnd(AIL_C_U32_ERROR_ONDOUBLE_INITIALIZED);
            /* run forever */
         }
         break;
      }
      case AMT_C_U16_PWR_WDOGTIMER:
      case AMT_C_U16_PWR_SVM_APP_NOTIFY_PROBLEM:
      {
         if ( poAppInterface->enInterfaceState == AIL_EN_N_APPLICATION_INITIALIZED )
         /* only the INITIALIZED state must be supervised, otherwise trigger is obsolete */
         {
            if (  u16PowerType == AMT_C_U16_PWR_WDOGTIMER
               && u32PowerData1 != 0 )
            {
               // supervise worker-threads
               if ( ail_bTakeListAccess( poAppInterface->hGeneralListAccess ) )
               {
                  ail_tWdgHandle hFailedWatchdog;
                  if (  ( hFailedWatchdog = poAppInterface->poWatchdogServer->hTimerEvent() ) != OSAL_C_INVALID_HANDLE )
                  {
                     ail_bReleaseListAccess( poAppInterface->hGeneralListAccess );

                     if ( poAppInterface->bOnWatchdogFailed( hFailedWatchdog ) )
                        poAppInterface->bWdgUntriggered = TRUE;
                  }
                  else
                  {
                     ail_bReleaseListAccess( poAppInterface->hGeneralListAccess );
                  }
               }
            }
            else
            {
               // supervise ail-threads
               tU16  u16PowerCode = AMT_C_U16_PWR_SVM_APP_NOTIFY;
               tU32  u32AnswerCode = 0x00;
               tBool bSendNecessary = FALSE;

               // if trigger of watchdog
               if (  poAppInterface->bOnWatchdog()
                  && !poAppInterface->bWdgUntriggered )
               /* application notifies all ok */
               {
                  bSendNecessary = TRUE;

                  /* re-trigger the watchdog timebase */
                  OSAL_s32TimerSetTime( poAppInterface->hWdgTimer,poAppInterface->u32WdgTime,0); //lint !e522: Expected void type, assignment, increment or decrement

                  if ( u16PowerType == AMT_C_U16_PWR_SVM_APP_NOTIFY_PROBLEM )
                  {
                     u16PowerCode = AMT_C_U16_PWR_SVM_APP_NOTIFY_PROBLEM_RESPONSE;
                     u32AnswerCode = AMT_C_U32_PWR_APP_STATE_OK;
                  }
               }
               else if ( u16PowerType == AMT_C_U16_PWR_SVM_APP_NOTIFY_PROBLEM )
               {
                  /* request the application end */
                  bSendNecessary = TRUE;

                  u16PowerCode = AMT_C_U16_PWR_SVM_APP_NOTIFY_PROBLEM_RESPONSE;
                  u32AnswerCode = AMT_C_U32_PWR_LPM_APP_STATE_RESTART;
               }
               /* else: wait for NOTIFY_PROBLEM-trigger */

               if ( bSendNecessary && poAppInterface->u16LpmId != AMT_C_U16_APPID_INVALID )
               /* note: if not running under LPX-control, no WDG-NOTIFY is sent */
               {
                  poAppInterface->bSendCCAPowerMsg (poAppInterface->u16LpmId, 
                                                    poAppInterface->hGetLpmInQueue(),
                                                    AIL_C_U32_CCA_PRIO_MSG_POWER,
                                                    u16PowerCode, 
                                                    u32AnswerCode, 
                                                    (tU32)0x00);

               }
            }
         }
         break;
      }
      case AMT_C_U16_PWR_PROXY_START_REJ:
      {
         /* not possible to register application 
            -> teminate yourself, request restart */
         if ( poAppInterface->enInterfaceState < AIL_EN_N_APPLICATION_INITIALIZED )
         {
            poAppInterface->vApplicationCloseAcknowledge (AIL_C_U8_APP_END_SUCCESSFUL);
         }
         else
         /* sequence error in LPX */
         {
            ail_vTraceMsg( TR_LEVEL_FATAL, "Application 0x%04x: RequestErrorEnd: PWR_PROXY_START_REJ received", poAppInterface->u16AppId );
            poAppInterface->vApplicationRequestErrorEnd(AIL_C_U32_ERROR_ONPROXYSTART_FAILED);
            /* run forever */
         }
         break;
      }
      case AMT_C_U16_PWR_PROXY_END_APP:
      {
         if ( poAppInterface->enInterfaceState > AIL_EN_N_APPLICATION_INITIALIZED )
         {
            if ( poAppInterface->hWdgTimer != OSAL_C_INVALID_HANDLE )
            /* a watchdog timer has been installed */
            {
               /* clear timer */
               OSAL_s32TimerDelete( poAppInterface->hWdgTimer ); //lint !e522: Expected void type, assignment, increment or decrement

               /* unregister application from CPM supervising */
               poAppInterface->bSendCCAPowerMsg (poAppInterface->u16LpmId, 
                                                 poAppInterface->hGetLpmInQueue(),
                                                 AIL_C_U32_CCA_PRIO_MSG_POWER,
                                                 AMT_C_U16_PWR_SVM_APP_UNREGISTER, 
                                                 (tU32)0x00, 
                                                 (tU32)0x00);

               /* now the system management is responsable to supervise the shutdown */
               poAppInterface->hWdgTimer = OSAL_C_INVALID_HANDLE;
               poAppInterface->u32WdgTime = 0x00;
            }
            poAppInterface->vOnApplicationClose();
         }
         else
         /* never been initialized before */
         {
            poAppInterface->vApplicationCloseAcknowledge (AIL_C_U8_APP_END_SUCCESSFUL);
         }
         break;
      }
      case AMT_C_U16_PWR_PROXY_STATE_CHANGE_IMMEDIATELY:
      /* some trouble detected from LPM, but there is a chance to react */
      {
         if ( poAppInterface->enInterfaceState == AIL_EN_N_APPLICATION_INITIALIZED )
         {
            /* trace list of all open synchronous communications */
            poAppInterface->vTracePendingSyncComm(TR_LEVEL_FATAL);

            poAppInterface->vOnAppStateAckFailed( poAppInterface->u32LastConfirmedAppState, poAppInterface->u32ActRequestedAppState);
         }
         break;
      }
      case AMT_C_U16_PWR_PROXY_STATE_CHANGE_REQ:
      /* normal request for application state change */
      {
         if ( poAppInterface->enInterfaceState == AIL_EN_N_APPLICATION_INITIALIZED )
         {
            #ifdef AIL_MESSAGE_TRACE_POWER_MESSAGES
            if ( ail_bIsTraceActive(TR_LEVEL_COMPONENT) )
            {
               ail_vTraceMsg( TR_LEVEL_COMPONENT, "Application 0x%04x: STATE_CHANGE_REQ from %s to %s",
                  poAppInterface->u16AppId, 
                  ail_coszAppStatus( poAppInterface->u32LastConfirmedAppState ),
                  ail_coszAppStatus( u32PowerData1 ));
            }
            #endif
            poAppInterface->u32ActRequestedAppState = u32PowerData1; 

            poAppInterface->vOnNewAppState( poAppInterface->u32LastConfirmedAppState,u32PowerData1);
         }
         break;
      }
      case AMT_C_U16_PWR_PROXY_CVM_SIGNAL_CHANGED:
      /* LPM signals an critical voltage event */
      {
         if ( poAppInterface->enInterfaceState == AIL_EN_N_APPLICATION_INITIALIZED )
         {
            if ( ail_bIsTraceActive(TR_LEVEL_SYSTEM_MIN) )
            {
               ail_vTraceMsg( TR_LEVEL_SYSTEM_MIN, "Application 0x%04x: CVM_SIGNAL_CHANGED to %s",  poAppInterface->u16AppId, ail_coszCVMStatus( u32PowerData2 ) );
            }
            poAppInterface->vOnCVMEvent( u32PowerData2);
         }
         break;
      }
      default:
      {
         break;
      }
   }
   return(bMessageReleased);

  //## end ail_tclInternalDispatch::ail_bHandleMsgPowerMessage%3AA3469D032F.body
}

tVoid ail_tclInternalDispatch::vOnServerApplicationStatus(tU16 u16ServiceId, tU16 u16NewServerAppId, tU8 u8ServerAppState)
{
  ail_tclServerApplication*               poServerApplication              = NULL;
  tU16                                    u16StoredAppId                   = AMT_C_U16_APPID_INVALID;
  tU16                                    u16StoredServiceId               = AMT_C_U16_SERVICE_UNDEF;
  tBool                                   bDedicatedServer                 = FALSE;
  tBool                                   bServerApplicationEntryFound     = FALSE;
  tBool                                   bServerApplicationEntryRemoved   = FALSE;
  tBool                                   bServiceDoesNotExistConfirmation = FALSE;
  tBool                                   bSendApplicationInfosStatus      = FALSE;
  std::vector<trServiceAndSubIdStorage> rServiceAndSubIdStorageList;

  #ifdef AIL_MESSAGE_TRACE_SVC_MESSAGES
    ail_vTraceMsg(TR_LEVEL_USER_2, "Application 0x%04x: vOnServerApplicationStatus() called. ServiceID=0x%04X, ServerAppID=0x%04X, ServerAppState=0x%04X", 
                  poAppInterface->u16AppId, u16ServiceId, u16NewServerAppId, u8ServerAppState);
  #endif

  if (ail_bTakeListAccess(poAppInterface->hGeneralListAccess)) /* list access is sheltered */
  {
    if (poAppInterface->bServerApplicationListAvailable() == TRUE)
    {
      do
      {
        ail_tclServerApplicationIterator  oServerApplicationIterator = ail_tclServerApplicationIterator(poAppInterface->m_poServerApplicationList);

        bServerApplicationEntryRemoved = FALSE;

        /* -------------------------------------------------------------------------- */
        /* The state of a server application has changed. Find the matching server    */
        /* application entries (it can be more than one => one is a dedicated server  */
        /* and the other is a none dedicated one) in the server application list by   */
        /* the indicated service-ID and application-ID.                               */
        /* -------------------------------------------------------------------------- */

        while ((FALSE == bServerApplicationEntryRemoved)      &&
               (oServerApplicationIterator.bIsDone() == FALSE)  )
        {
          u16StoredAppId     = oServerApplicationIterator.oItem().u16GetAppId();
          u16StoredServiceId = oServerApplicationIterator.oItem().u16GetServiceId();
          bDedicatedServer   = oServerApplicationIterator.oItem().bIsDedicatedServer();

          poServerApplication = NULL;

          /* ------------------------------------------------------------------------ */
          /* Find the matching server application entry by the indicated service-ID   */
          /* and application-ID.                                                      */
          /* ------------------------------------------------------------------------ */

          // Handling for 'Application Info' message (dedicated server).
          // Check for application ID.
          if (AMT_C_U16_SERVICE_UNDEF == u16ServiceId)
          {
            if (u16StoredAppId == u16NewServerAppId)
            {
              if (bDedicatedServer == TRUE)
              {
                poServerApplication = &(oServerApplicationIterator.oItem());

                bServerApplicationEntryFound = TRUE;
              }
            }
          }
          // Handling for 'Service Supplier' message (none dedicated server). 
          // Check for service ID.
          else
          {
            if (u16StoredServiceId == u16ServiceId)
            {
              if (bDedicatedServer == FALSE)
              {
                poServerApplication = &(oServerApplicationIterator.oItem());

                bServerApplicationEntryFound = TRUE;
              }
            }
          }

          /* -------------------------------------------------------------------------- */
          /* If a matching server application entry was found in the server application */
          /* list then react to the just indicated server application state.            */
          /* -------------------------------------------------------------------------- */

          if (poServerApplication != NULL) 
          {
            tU16 u16StoredServiceMajorVersion = 0x0001;
            tU16 u16StoredServiceMinorVersion = 0x0000;
            tU16 u16StoredClientSubId         = AMT_C_U16_SUBID_INVALID;

            /* -------------------------------------------------------------------------- */
            /* The server application state changed to AVAILABLE for this server          */
            /* application entry. Run through the service request list of this server     */
            /* application and perform the service registration for each entry            */
            /* of the service request list.                                               */
            /* -------------------------------------------------------------------------- */

            if (AMT_C_U8_CCAMSG_SUPPLIER_STATE_AVAILABLE == u8ServerAppState)
            {
              // Only react to a server application state change to AVAILABLE if this 
              // is not the current state.
              if (poServerApplication->enGetServerAppState() != AIL_EN_SERVER_APP_STATE_AVAILABLE)
              {
                #ifdef AIL_MESSAGE_TRACE_SVC_MESSAGES
                  ail_vTraceMsg(TR_LEVEL_USER_2, "Application 0x%04x: vOnServerApplicationStatus() => ServerAppState for ServerAppID=0x%04X changed to AVAILABLE.", poAppInterface->u16AppId, u16NewServerAppId);
                #endif

                poServerApplication->vSetServerAppState(AIL_EN_SERVER_APP_STATE_AVAILABLE);

                poServerApplication->vSetAppId(u16NewServerAppId);

                if (AMT_C_U16_SERVICE_UNDEF != u16StoredServiceId)
                {
                  ail_tclServiceRequestList* poServiceRequestList = poServerApplication->poGetServiceRequestList();

                  if (poServiceRequestList != NULL)
                  {
                    ail_tclServiceRequestIterator oServiceRequestIterator(poServiceRequestList);

                    // Check if there are service registrations pending and initiate the
                    // registration(s) by calling the method bRegisterAsyncExecute().
                    while (oServiceRequestIterator.bIsDone() == FALSE)
                    {
                      u16StoredServiceMajorVersion = oServiceRequestIterator.oItem().u16GetServiceMajorVersion();
                      u16StoredServiceMinorVersion = oServiceRequestIterator.oItem().u16GetServiceMinorVersion();
                      u16StoredClientSubId         = oServiceRequestIterator.oItem().u16GetClientSubId();

                      #ifdef AIL_MESSAGE_TRACE_SVC_MESSAGES
                        ail_vTraceMsg(TR_LEVEL_USER_2, "Application 0x%04x: vOnServerApplicationStatus() => Call bRegisterAsyncExecute()", poAppInterface->u16AppId);
                      #endif

                      if (poAppInterface->bRegisterAsyncExecute(u16StoredServiceId,
                                                                u16StoredServiceMajorVersion,
                                                                u16StoredServiceMinorVersion, 
                                                                u16StoredClientSubId,
                                                                u16NewServerAppId,
                                                                TRUE) == FALSE)
                      {
                        ail_vTraceMsg(TR_LEVEL_FATAL, "Application 0x%04x: bRegisterAsyncExecute() returned FALSE with ServiceId = 0x%04X, ServiceMajorVersion = 0x%04X, ServiceMinorVersion = 0x%04X, ClientSubId = 0x%04X, ServerAppId = 0x%04X",
                                      poAppInterface->u16AppId,
                                      u16StoredServiceId,
                                      u16StoredServiceMajorVersion,
                                      u16StoredServiceMinorVersion,
                                      u16StoredClientSubId,
                                      u16NewServerAppId);
                      }

                      oServiceRequestIterator.vNext();
                    }
                  }
                  else
                  {
                    ail_vTraceMsg(TR_LEVEL_FATAL, "Application 0x%04x: vOnServerApplicationStatus() with ServiceID=0x%04X, ServerAppID=0x%04X, ServerAppState=0x%04X => poServiceRequestList == NULL", 
                                  poAppInterface->u16AppId, u16ServiceId, u16NewServerAppId, u8ServerAppState);
                  }
                }
                else
                {
                  bSendApplicationInfosStatus = TRUE;
                }
              }
            }

            /* -------------------------------------------------------------------------- */
            /* The server application state changed to UNAVAILABLE for this server        */
            /* application entry. Run through the service request list of this server     */
            /* application and remove the service registration from the AIL               */
            /* service reference list for each entry of the service request list. Also    */
            /* indicate the removed service registration entry from the service reference */
            /* list to the AIL extension to give the derived object the chance to also    */
            /* reset registration related data like register ID, service availabilty      */
            /* state and property registration (UpRegs).                                  */
            /* -------------------------------------------------------------------------- */

            else if (AMT_C_U8_CCAMSG_SUPPLIER_STATE_UNAVAILABLE == u8ServerAppState)
            {
              // Only react to a server application state change to UNAVAILABLE if this 
              // is not the current state and if the passed application ID matches the already stored one.
              if ((poServerApplication->enGetServerAppState() != AIL_EN_SERVER_APP_STATE_UNAVAILABLE) &&
                  (u16StoredAppId == u16NewServerAppId)                                                 )
              {
                #ifdef AIL_MESSAGE_TRACE_SVC_MESSAGES
                  ail_vTraceMsg(TR_LEVEL_USER_2, "Application 0x%04x: vOnServerApplicationStatus() => ServerAppState for ServerAppID=0x%04X changed to UNAVAILABLE.", poAppInterface->u16AppId, u16NewServerAppId);
                #endif

                poServerApplication->vSetServerAppState(AIL_EN_SERVER_APP_STATE_UNAVAILABLE);

                if (FALSE == bDedicatedServer)
                {
                  poServerApplication->vSetAppId(AMT_C_U16_APPID_INVALID);
                }

                if (AMT_C_U16_SERVICE_UNDEF != u16StoredServiceId)
                {
                  ail_tclServiceRequestList* poServiceRequestList = poServerApplication->poGetServiceRequestList();

                  if (poServiceRequestList != NULL)
                  {
                    ail_tclServiceRequestIterator oServiceRequestIterator(poServiceRequestList);

                    while(oServiceRequestIterator.bIsDone() == FALSE)
                    {
                      u16StoredClientSubId = oServiceRequestIterator.oItem().u16GetClientSubId();

                      // Remove service registration from service-reference-list.

                      ail_tclServiceReferenceIterator oServiceReferenceListIterator(poAppInterface->poServiceReferenceList);

                      while (oServiceReferenceListIterator.bIsDone() == FALSE)
                      {
                        if (oServiceReferenceListIterator.oItem().bIsDataSet(u16StoredServiceId, u16NewServerAppId, AMT_C_U16_REGID_INVALID, u16StoredClientSubId) == TRUE)
                        {
                          poAppInterface->poServiceReferenceList->nRemove(oServiceReferenceListIterator.oItem());

                          // Indicate removed service registration to AIL extension.

                          #ifdef AIL_MESSAGE_TRACE_SVC_MESSAGES
                            ail_vTraceMsg(TR_LEVEL_USER_2, "Application 0x%04x: vOnServerApplicationStatus() => Call vOnRegistrationRemoved() with ServiceID = 0x%04X, ServerAppID = 0x%04X, ClientSubID = 0x%04X",
                                          poAppInterface->u16AppId, u16StoredServiceId, u16NewServerAppId, u16StoredClientSubId);
                          #endif

                          poAppInterface->vOnRegistrationRemoved(u16StoredServiceId, u16NewServerAppId, u16StoredClientSubId);

                          break;
                        }

                        oServiceReferenceListIterator.vNext();
                      }

                      oServiceRequestIterator.vNext();
                    }
                  }
                  else
                  {
                    ail_vTraceMsg(TR_LEVEL_FATAL, "Application 0x%04x: vOnServerApplicationStatus() with ServiceID=0x%04X, ServerAppID=0x%04X, ServerAppState=0x%04X => poServiceRequestList == NULL", 
                                  poAppInterface->u16AppId, u16ServiceId, u16NewServerAppId, u8ServerAppState);
                  }
                }
                else
                {
                  bSendApplicationInfosStatus = TRUE;
                }
              }
            }
            else if (AMT_C_U8_CCAMSG_SUPPLIER_STATE_UNKNOWN == u8ServerAppState)
            {
              // Intentionally do nothing. 
              //
              // Don't change the internal server application state to UNKNOWN as it might be set to REQUESTED and should 
              // stay with this value until AVAILABLE or UNAVAILABLE is indicated. The value UNKNOWN is the internal 
              // initial value of the application and should no be changed by a received UNKNOWN indication from the SPM.

              #ifdef AIL_MESSAGE_TRACE_SVC_MESSAGES
                ail_vTraceMsg(TR_LEVEL_USER_2, "Application 0x%04x: vOnServerApplicationStatus() => Receiced AMT_C_U8_CCAMSG_SUPPLIER_STATE_UNKNOWN from SPM. Don't change ServerAppState=0x%04X.", 
                                                poAppInterface->u16AppId, u8ServerAppState);
              #endif
            }
            else if (AMT_C_U8_CCAMSG_SUPPLIER_STATE_ERROR == u8ServerAppState)
            {
              if (AMT_C_U16_SERVICE_UNDEF == u16ServiceId)
              {
                ail_vTraceMsg(TR_LEVEL_FATAL, "Application 0x%04x: Received message ApplicationInfoStatus with state ERROR => Repeated registration without prior de-registration.", poAppInterface->u16AppId);
              }
              else
              {
                ail_vTraceMsg(TR_LEVEL_FATAL, "Application 0x%04x: Received message ServiceSupplierStatus with state ERROR => Repeated registration without prior de-registration.", poAppInterface->u16AppId);
              }
            }
            else if (AMT_C_U8_CCAMSG_SUPPLIER_STATE_DOES_NOT_EXIST == u8ServerAppState)
            {
              #ifdef AIL_MESSAGE_TRACE_SVC_MESSAGES
                  ail_vTraceMsg(TR_LEVEL_USER_2, "Application 0x%04x: vOnServerApplicationStatus() => ServerAppState changed to DOES_NOT_EXIST.", poAppInterface->u16AppId);
              #endif

              // Intentionally don't call 'poServerApplication->vSetServerAppState(AIL_EN_SERVER_APP_STATE_DOES_NOT_EXIST);'
              // at this position as we remove this server application entry at the end of this block.
              // If an application again tries to register for a service for this just rejected application a new server 
              // application entry will be created.

              // Get all pending service request entries from this server application entry and 
              // reject the service registration for each of the service requests by a call of 
              // vOnAsyncRegisterConf() with an invalid Register-ID and an invalid Application-ID.
              ail_tclServiceRequestList* poServiceRequestList = poServerApplication->poGetServiceRequestList();

              if (poServiceRequestList != NULL)
              {
                ail_tclServiceRequestIterator oServiceRequestIterator(poServiceRequestList);

                while(oServiceRequestIterator.bIsDone() == FALSE)
                {
                  u16StoredClientSubId = oServiceRequestIterator.oItem().u16GetClientSubId();

                  // We don't call vOnAsyncRegisterConf() at this place but only set a flag to perform 
                  // these method call(s) AFTER the critical path has been left and the actually occupied 
                  // semaphore 'hGeneralListAccess' has been released. The method vOnAsyncRegisterConf() 
                  // is overwritten by the user application and from there another AIL method which also 
                  // occupies the semaphore 'hGeneralListAccess '(e.g. bRegisterAsync()) might be called 
                  // which would lead to a semaphore lock.

                  // The found combinations of 'u16StoredServiceId' and 'u16StoredClientSubId' are stored
                  // in a temporary vector and these values will by used to perform the calls of 
                  // vOnAsyncRegisterConf() after the critical path is left and the semaphore 
                  // 'hGeneralListAccess' has been released

                  trServiceAndSubIdStorage rServiceAndSubIdStorage = {u16StoredServiceId, u16StoredClientSubId};

                  rServiceAndSubIdStorageList.push_back(rServiceAndSubIdStorage);

                  bServiceDoesNotExistConfirmation = TRUE;

                  oServiceRequestIterator.vNext();
                }
              }

              // The server application we asked for does not exist and will never appear. We don't need to be 
              // informed about state changes for this not existing server application so we can unregister for 
              // it from the SPM. Check for a just received ServiceSupplierStatus or ApplicationInfoStatus 
              // message and send the respective unregister message to the SPM.
              if (AMT_C_U16_SERVICE_UNDEF == u16ServiceId)
              {
                if (poAppInterface->bSendAppInfoMsg(u16NewServerAppId, FALSE, FALSE, TRUE) == FALSE)
                {
                  ail_vTraceMsg(TR_LEVEL_FATAL, "Application 0x%04x: vOnServerApplicationStatus() => Post message ApplicationInfoUnregister failed", poAppInterface->u16AppId);
                }

              }
              else
              {
                if (poAppInterface->bSendCCASrvSupplierMsg(u16ServiceId, FALSE, FALSE) == FALSE)
                {
                  ail_vTraceMsg(TR_LEVEL_FATAL, "Application 0x%04x: vOnServerApplicationStatus() => Post message ServiceSupplierUnregister failed", poAppInterface->u16AppId);
                }
              }

              poAppInterface->m_poServerApplicationList->nRemove(*poServerApplication);

              bServerApplicationEntryRemoved = TRUE;
            }
          }

          if (FALSE == bServerApplicationEntryRemoved)
          {
            oServerApplicationIterator.vNext();
          }
        }
      } while (TRUE == bServerApplicationEntryRemoved);
    }

    ail_bReleaseListAccess(poAppInterface->hGeneralListAccess);  /* release the list access */

    /* --------------------------------------------------------------------------- */
    /* Perform callbacks for user level indications AFTER the 'hGeneralListAccess' */
    /* semaphore was released and the critical path was left.                      */
    /* --------------------------------------------------------------------------- */

    // User level indication => vOnAsyncRegisterConf() and/or vOnAsyncRegisterConfExt().
    if (TRUE == bServiceDoesNotExistConfirmation)
    {
      std::vector<trServiceAndSubIdStorage>::const_iterator Iterator;

      for (Iterator = rServiceAndSubIdStorageList.begin(); Iterator != rServiceAndSubIdStorageList.end(); ++Iterator)
      {
        poAppInterface->vHandleAsyncRegisterConf(AMT_C_U16_REGID_INVALID, 
                                                 u16NewServerAppId, 
                                                 Iterator->u16StoredServiceId, 
                                                 Iterator->u16StoredClientSubId,
                                                 AMT_C_U8_REGCONF_SERVICE_DOES_NOT_EXIST);
      }

      rServiceAndSubIdStorageList.clear();
    }

    // User level indication => vOnApplicationInfoStatus().
    if (TRUE == bSendApplicationInfosStatus)
    {
      poAppInterface->vOnApplicationInfoStatus(u16NewServerAppId, u8ServerAppState);
    }

  }

  if (FALSE == bServerApplicationEntryFound)
  {
    // HWA => Todo , KSM2HI

    // Trace level should be TR_LEVEL_FATAL. Keep it as TR_LEVEL_USER_2 as long as it is not clarified if the SPM component
    // really removes the AppInfo or ServiceSupplier entry from its internal list when calling 
    // spm_tclCcaSupplierHandler::bRemoveNotificationEntry(tU16 u16SupplierAppId, tU16 u16AppIdToBeNotified, tU16 u16ServiceId)
    // which is initiated by sending the messages via a call of ail_tclAppInterfaceRestricted::bSendAppInfoMsg()
    // or ail_tclAppInterfaceRestricted::bSendCCAPowerMsg(). When switching a client application from
    // NORMAL => OFF => NORMAL => OFF => NORMAL then the final change to NORMAL producess to below FATAL traces. This
    // should be investigated later.
    //
    // At system shutdown it can really happen wihtout being an error that an ApplicationInfoStatus or a ServiceSupplierStatus
    // is received although it has been unregistered for it at the SPM before. This is the case when the unregister
    // message from the client is on the way to the SPM an in this time window the supervised server application is switched off.
    // Then the client receives the status update although it has just unregistered for the status update info message.

    if (AMT_C_U16_SERVICE_UNDEF == u16ServiceId)
    {
      ail_vTraceMsg(TR_LEVEL_USER_2, "Application 0x%04x: Received message ApplicationInfoStatus without having it requested.", poAppInterface->u16AppId);
    }
    else
    {
      ail_vTraceMsg(TR_LEVEL_USER_2, "Application 0x%04x: Received message ServiceSupplierStatus without having it requested.", poAppInterface->u16AppId);
    }
  }

  #ifdef AIL_MESSAGE_TRACE_SVC_MESSAGES
    ail_vTraceMsg(TR_LEVEL_USER_2, "Application 0x%04x: vOnServerApplicationStatus() done.", poAppInterface->u16AppId);
  #endif
}

//## Operation: ail_bHandleMsgSupplierStateMessage%3AA3469D032F
tBool ail_tclInternalDispatch::ail_bHandleMsgSupplierStateMessage (amt_tclBaseMessage* poMessage)
{
  amt_tclServiceSupplierStatus oSrvSupplierStatusMessage(poMessage);

  tU16 u16ServerAppId     = oSrvSupplierStatusMessage.u16GetAppID();
  tU16 u16ServiceId       = oSrvSupplierStatusMessage.u16GetServiceID();
  tU8  u8SrvSupplierState = oSrvSupplierStatusMessage.u8GetServiceSupplierState();

  #ifdef AIL_MESSAGE_TRACE_SVC_MESSAGES
  if ( ail_bIsTraceActive(TR_LEVEL_USER_2) )
  {
    ail_vTraceMsg(TR_LEVEL_USER_2,
                  "Application 0x%04x: ServiceSupplierStatus received, Srv = 0x%04x, App = 0x%04x, State = %d",
                  poAppInterface->u16AppId, 
                  u16ServiceId, 
                  u16ServerAppId, 
                  u8SrvSupplierState);
  }
  #endif

  vOnServerApplicationStatus(u16ServiceId, u16ServerAppId, u8SrvSupplierState);

  return TRUE;
}

//## Operation: ail_bHandleMsgAppInfoMessage%3AA3469D032F
tBool ail_tclInternalDispatch::ail_bHandleMsgAppInfoMessage (amt_tclBaseMessage* poMessage)
{
   amt_tclApplicationInfoStatus oAppInfoMessage(poMessage);

   tU16 u16ServerAppId = oAppInfoMessage.u16GetAppID();
   tU8  u8AppInfoState = oAppInfoMessage.u8GetApplicationInfoState();

  #ifdef AIL_MESSAGE_TRACE_SVC_MESSAGES
  if ( ail_bIsTraceActive(TR_LEVEL_USER_2) )
  {
    ail_vTraceMsg(TR_LEVEL_USER_2,
                  "Application 0x%04x: ApplicationInfo received, App = 0x%04x, State = %d",
                  poAppInterface->u16AppId, 
                  u16ServerAppId, 
                  u8AppInfoState);
  }
  #endif

   vOnServerApplicationStatus(AMT_C_U16_SERVICE_UNDEF, u16ServerAppId, u8AppInfoState);

   return TRUE;

   //## end ail_tclInternalDispatch::ail_bHandleMsgAppInfoMessage%3AA3469D032F.body
}

tBool ail_tclInternalDispatch::ail_bCheckExistenceRequirement (amt_tclBaseMessage* poMessage) const
{
  //## begin ail_tclInternalDispatch::ail_bCheckExistenceRequirement%3B98B833007C.body preserve=yes

   tBool bContinueExisting = TRUE;

   // Downcast Object
   amt_tclPowerMessage oPowerMessage(poMessage);

   if (  oPowerMessage.u16GetSourceAppID() == poAppInterface->u16AppId
      && (  oPowerMessage.u16GetPowerType() == AMT_C_U16_PWR_APP_END_SUCCESSFUL
         || oPowerMessage.u16GetPowerType() == AMT_C_U16_PWR_APP_END_FAILURE ) )
   {
      bContinueExisting = FALSE;
   }

   return(bContinueExisting);

  //## end ail_tclInternalDispatch::ail_bCheckExistenceRequirement%3B98B833007C.body
}

tBool ail_tclInternalDispatch::ail_bExamineInfluenceToAdministration (ail_tenAdminType enAdminType, amt_tclBaseMessage* poMessage)
{
  //## begin ail_tclInternalDispatch::ail_bExamineInfluenceToAdministration%3BAAFA740359.body preserve=yes

   /* return reason of synchronous functions */
   ail_tenSyncAnswerType   enForwardReason = AIL_EN_U16_SYNC_UNDEFINED_ABORT;

   tU16  u16ServiceId = AMT_C_U16_SERVICE_UNDEF;
   tU16  u16RegisterId = AMT_C_U16_REGID_INVALID; 
   tU16  u16SourceAppId = AMT_C_U16_APPID_INVALID;
   tU16  u16CmdCounter = 0;
   tU16  u16SubId = AMT_C_U16_SUBID_INVALID;
   tU16  u16FunctionId = 0;
   tU8   u8ServiceState = AMT_C_U8_SVCSTATE_NOT_AVAILABLE;
   tU8   u8Act = 0xFF;
   tBool bMessageProcessed = FALSE;

   /* to handle client role for registered connections  */
   tBool bSetStateOfRefTableEntry = FALSE;
   tBool bDelRefTableEntry = FALSE;
   tBool bDelRefTableAll = FALSE; 

   /* to handle the waiting synchron answer objects -only client role- */
   tBool bSyncSetAnswerToDataObj = FALSE;
   tBool bSyncAbortDataObj = FALSE;
   tBool bSyncAbortAll = FALSE;

   /* to handle server role for registered connections  */
   tBool bSendRegDeniedToAllClients = FALSE;
   tBool bDelRegTableEntry = FALSE;
   tBool bDelRegTableAll = FALSE; 

   /* to handle the openend queues of a client */
   tBool bCloseOpenedQueue = FALSE;
   tBool bCloseQueueIfNoOtherRegsExists = FALSE;

   /* default: get list access to administration lists */
   tBool bListAccessRequired = TRUE;

   switch ( enAdminType )
   {
      case AIL_EN_N_ADMIN_SVCDATA:
      /* role: only an answer of a server must be checked at client's entry */
      {
         /* Downcast Object */
         amt_tclServiceData* poServiceMsg = ((amt_tclServiceData*)poMessage); //lint !e1774: Could use dynamic_cast

         if ( poServiceMsg->bIsServerMessage() )
         /* only server allowed OpType can be awaited */
         {
            u16ServiceId   = poServiceMsg->u16GetServiceID();
            u16RegisterId  = poServiceMsg->u16GetRegisterID();
            u16SourceAppId = poServiceMsg->u16GetSourceAppID();
            u16CmdCounter  = poServiceMsg->u16GetCmdCounter();
            u16SubId       = poServiceMsg->u16GetTargetSubID();
            tU8 u8OpType   = poServiceMsg->u8GetOpCode();
            u16FunctionId  = poServiceMsg->u16GetFunctionID();
            u8Act          = poServiceMsg->u8GetACT();


            bSyncSetAnswerToDataObj = TRUE;
            enForwardReason = AIL_EN_U16_SYNC_MESSAGE_ANSWER;

            // if OpType==error and error-value is AMT_C_U16_ERROR_UNKNOWN_REG_ID
            //  then close queue to server if no other registrations exist,
            //  delete registration from service-reference-list
            if ( u8OpType == AMT_C_U8_CCAMSG_OPCODE_ERROR )
            {
               amt_tclServiceDataError *poErrorMsg = ((amt_tclServiceDataError*)poMessage); //lint !e1774: Could use dynamic_cast
               if ( poErrorMsg->u16GetErrorData() == AMT_C_U16_ERROR_UNKNOWN_REG_ID )
               {
                  bDelRefTableEntry = TRUE;

                  bCloseQueueIfNoOtherRegsExists = TRUE;

                  ail_vTraceMsg( TR_LEVEL_ERRORS, "Application 0x%04x, SubID %u: For service 0x%04x received service-data message with Opcode error and value AMT_C_U16_ERROR_UNKNOWN_REG_ID regarding register-ID 0x%04x", 
                                 poAppInterface->u16AppId, u16SubId, u16ServiceId, u16RegisterId);
               }
            }
         }
         break;
      }
      case AIL_EN_N_ADMIN_APPCLOSE_CHECK:
      /* AIL forbad any external communication */
      {
         // Downcast Object
         amt_tclPowerMessage oPowerMessage(poMessage);

         tU16 u16PowerType = oPowerMessage.u16GetPowerType();
         u16SubId = oPowerMessage.u16GetTargetSubID();

         if ( u16PowerType == AMT_C_U16_PWR_PROXY_END_APP )
         {
            if ( poAppInterface->enInterfaceState == AIL_EN_N_APPLICATION_INITIALIZED )
            /* list must only deleted, if initialized before */
            {
               tBool bServerApplicationListEmpty = TRUE;

               // send REG_DENIED to all registered clients
               // and set interface-state to CLOSE_REQ
               bSendRegDeniedToAllClients = TRUE;

               // delete service-registrations and service-references
               // abort all sync-communications
               bDelRefTableAll = TRUE;
               bDelRegTableAll = TRUE;
               bSyncAbortAll = TRUE;
               enForwardReason = AIL_EN_U16_SYNC_UNDEFINED_ABORT;

               // close all opened queues
               u16SourceAppId = AMT_C_U16_APPID_INVALID;
               // In respect to the newly introducted feature switch AIL_KEEP_MSG_QUEUE_HANDLES_TO_OTHER_APPS_UNTIL_TERMINATION
               // the below flag bCloseOpenedQueue set to TRUE now is the only trigger with inside the entire AIL code which leads
               // to a call of ail_bDeleteFromOpenedQueueList().
               bCloseOpenedQueue = TRUE;

               if (ail_bTakeListAccess(poAppInterface->hGeneralListAccess))
               {
                 if (poAppInterface->m_poServerApplicationList->nSize() > 0)
                 {
                   bServerApplicationListEmpty = FALSE;
                 }
 
                 ail_bReleaseListAccess(poAppInterface->hGeneralListAccess);
               }
               
               if (FALSE == bServerApplicationListEmpty)
               {
                 #ifdef AIL_MESSAGE_TRACE_SVC_MESSAGES
                   ail_vTraceMsg(TR_LEVEL_USER_2, "Application 0x%04x: ail_tclInternalDispatch::ail_bExamineInfluenceToAdministration => Cleanup service requests due to missing vUnregisterService() calls", poAppInterface->u16AppId);
                 #endif

                 poAppInterface->vRemoveAllServiceRequests();
               }
            }
         }
         else
         {
            bListAccessRequired = FALSE;
         }
         break;
      }
      case AIL_EN_N_ADMIN_SVCUNREGISTER:
      /* role: a server is informed by a client that this channel is not used any longer */
      {
         /* Downcast Object */
         amt_tclServiceUnregister oServiceUnregister(poMessage);

         /* preset all elements for reference search */
         u16SourceAppId = oServiceUnregister.u16GetSourceAppID();
         u16ServiceId = oServiceUnregister.u16GetServiceID();
         u16RegisterId = oServiceUnregister.u16GetRegisterID();
         u16SubId = oServiceUnregister.u16GetSourceSubID();

         /* to do */
         bDelRegTableEntry = TRUE;
         // close opened queue if no other registrations exist
         bCloseQueueIfNoOtherRegsExists = TRUE;

         break;
      }
      case AIL_EN_N_ADMIN_SVSSTATUS:
      /* role: a client is informed by a server access status to service has changed */
      {
         /* Downcast Object */
         amt_tclServiceStatus oServiceStatus(poMessage);

         /* preset all elements for reference search */
         u16SourceAppId = oServiceStatus.u16GetSourceAppID();
         u16RegisterId = oServiceStatus.u16GetRegisterID();
         u16ServiceId = oServiceStatus.u16GetServiceID();
         u8ServiceState = oServiceStatus.u8GetServiceState();
         u16SubId = oServiceStatus.u16GetTargetSubID();

         /* to do */
         bSetStateOfRefTableEntry = TRUE;
         if (  u8ServiceState == AMT_C_U8_SVCSTATE_NOT_AVAILABLE
            || u8ServiceState == AMT_C_U8_SVCSTATE_REG_DENIED )
         {
            bSyncAbortDataObj = TRUE;
            enForwardReason = AIL_EN_U16_SYNC_SERVICE_NOT_AVAILABLE;
         }
         break;
      }
      case AIL_EN_N_ADMIN_OPERATION_LOCKED:
      /* server role: UnknownRegisterId / client role: ServiceUnregister */
      {
         bListAccessRequired = FALSE;

         /* Downcast Object */
         amt_tclServiceData* poServiceMsg = ((amt_tclServiceData*)poMessage); //lint !e1774: Could use dynamic_cast

         u16ServiceId = poServiceMsg->u16GetServiceID();
         u16RegisterId = poServiceMsg->u16GetRegisterID();
         u16SourceAppId = poServiceMsg->u16GetSourceAppID();

         if ( poServiceMsg->bIsServerMessage() ) // client role
         // only server allowed OpType can be awaited
         {
            // //// Send ServiceUnregister to the server //// 

            // create a new message object 
            amt_tclServiceUnregister oMessageServiceUnregister(poAppInterface->u16AppId, u16SourceAppId, u16ServiceId, u16RegisterId, poServiceMsg->u16GetTargetSubID());

            if ( oMessageServiceUnregister.bIsValid() )
            {
               // post this message to the server 
               if ( !poAppInterface->bPostIpcMessage(
                        poAppInterface->u16AppId,
                        ail_hGetReceiverQueue
                        ( 
                           poAppInterface->poOpenedQueueList,
                           poAppInterface->hGeneralListAccess,
                           u16SourceAppId
                        ),
                        (amt_tclBaseMessage*) &oMessageServiceUnregister, 
                        AIL_C_U32_CCA_PRIO_MSG_SERVICE_UNREGISTER ) )
               {
                  oMessageServiceUnregister.bDelete();
                  ail_vTraceMsg( TR_LEVEL_ERRORS, "Application 0x%04x: ADMIN_OPERATION_LOCKED: failed to send service-unregister-msg", poAppInterface->u16AppId );
               }
               else
               {
                  ail_vTraceMsg( TR_LEVEL_ERRORS, "Application 0x%04x: ADMIN_OPERATION_LOCKED: send service-unregister to client 0x%04x for service 0x%04x", poAppInterface->u16AppId, u16SourceAppId,  u16ServiceId);
               }
            }
            else
            {
               ail_vTraceMsg( TR_LEVEL_ERRORS, "Application 0x%04x: ADMIN_OPERATION_LOCKED: service-unregister-msg invalid", poAppInterface->u16AppId );
            }

            // possibly last message to this server, close queue
            bCloseQueueIfNoOtherRegsExists = TRUE;

         }
         else
         {  
            // server role
            // //// Send UnknownRegisterID to the client //// 

            /* create a new message object */
            amt_tclServiceDataError oMessageUnknownRegisterID( *poServiceMsg, AMT_C_U16_ERROR_UNKNOWN_REG_ID );

            if ( oMessageUnknownRegisterID.bIsValid() )
            {
               // get message-queue to client
               OSAL_tMQueueHandle hMQ = OSAL_C_INVALID_HANDLE;
               hMQ = scd_OpenQueue(u16SourceAppId);   // do not use OpenedQueueList, 'cause this
                                                      // is possibly the only message to this client
               if ( hMQ != OSAL_C_INVALID_HANDLE )
               {
                  /* post this message to the client */  
                  if ( !poAppInterface->bPostIpcMessage(
                           poAppInterface->u16AppId,
                           hMQ,
                           (amt_tclBaseMessage*) &oMessageUnknownRegisterID, 
                           AIL_C_U32_CCA_PRIO_MSG_SERVICE_DATA_SERVER ) )
                  {
                     oMessageUnknownRegisterID.bDelete();
                     ail_vTraceMsg( TR_LEVEL_ERRORS, "Application 0x%04x: ADMIN_OPERATION_LOCKED: failed to send error-msg (unknown reg-id)", poAppInterface->u16AppId );
                  }
                  else
                  {
                     ail_vTraceMsg( TR_LEVEL_ERRORS, "Application 0x%04x: ADMIN_OPERATION_LOCKED: send error-msg (unknown reg-id)", poAppInterface->u16AppId );
                  }

                  // close message-queue to client
                  scd_s32CloseQueue(hMQ);
               }
               else
               {
                  // else couldn't send message
                  oMessageUnknownRegisterID.bDelete();

                  ail_vTraceMsg( TR_LEVEL_SYSTEM,
                     "Application 0x%04x: (InterfaceState!=INITIALIZED) " \
                     "couldn't send AMT_C_U16_ERROR_UNKNOWN_REG_ID " \
                     "to client 0x%04x with reg-id %d for service 0x%04x",
                     poAppInterface->u16AppId,
                     u16SourceAppId,
                     u16RegisterId,
                     u16ServiceId );
               }
            }
            else
            {
               ail_vTraceMsg( TR_LEVEL_ERRORS, "Application 0x%04x: ADMIN_OPERATION_LOCKED: error-msg (unknown reg-id) invalid", poAppInterface->u16AppId );
            }
         }
         break;
      }
      default:
      {
         break;
      }
   }

   if ( bListAccessRequired )
   {
      if ( ail_bTakeListAccess( poAppInterface->hGeneralListAccess ) )
      /* list access is sheltered */
      {
         if ( bSendRegDeniedToAllClients )
         {
            // send reg-denied-messages before interface-state is set to close_req
            ail_tclServiceRegistryIterator  
                  iter(poAppInterface->poServiceRegistryList);

            for ( ; !iter.bIsDone(); iter.vNext())
            {
               if ( iter.oItem().u16GetRegisterId() != AMT_C_U16_REGID_INVALID )
               {
                  // found an already registered client
                  u16ServiceId = iter.oItem().u16GetServiceId();
                  u16RegisterId = iter.oItem().u16GetRegisterId();
                  tU16 u16Receiver = iter.oItem().u16GetClientAppId();
                  tU16 u16ReceiverSubId = iter.oItem().u16GetClientSubId();

                  #ifdef AIL_MESSAGE_TRACE_SVC_MESSAGES
                  ail_vTraceMsg( TR_LEVEL_USER_2,
                     "Application 0x%04x: Registration denied for service 0x%04x to client 0x%04x,%d using RegisterId %d",
                     poAppInterface->u16AppId, u16ServiceId, u16Receiver, u16ReceiverSubId, u16RegisterId );
                  #endif

                  // send reg-denied-message to application
                  // create a new message object
                  amt_tclServiceStatus oServiceStatus(poAppInterface->u16AppId, u16Receiver, u16ServiceId,
                     u16RegisterId, AMT_C_U8_SVCSTATE_REG_DENIED,AMT_C_U16_SUBID_DEFAULT, u16ReceiverSubId);

                  if ( oServiceStatus.bIsValid() )
                  {
                     /* by force de-registration: post this message with highest prio to the client */  
                     if ( !poAppInterface->bPostIpcMessage( 
                              poAppInterface->u16AppId,
                              ail_hGetReceiverQueue( poAppInterface->poOpenedQueueList,OSAL_C_INVALID_HANDLE, /* access already protected */ u16Receiver),
                              &oServiceStatus,
                              AIL_C_U32_CCA_PRIO_MSG_SERVICE_STATUS ) )
                     {
                        oServiceStatus.bDelete();
                        ail_vTraceMsg( TR_LEVEL_ERRORS, "Application 0x%04x: ADMIN_APPCLOSE_CHECK: failed to send service-status-msg (reg denied)", poAppInterface->u16AppId );
                     }
                     else
                     {
                        ail_vTraceMsg( TR_LEVEL_SYSTEM_MIN, "Application 0x%04x: ADMIN_APPCLOSE_CHECK: send service-status-msg (reg denied)", poAppInterface->u16AppId );
                     }
                  }
                  else
                  {
                     ail_vTraceMsg( TR_LEVEL_ERRORS, "Application 0x%04x: ADMIN_APPCLOSE_CHECK: service-status-msg (reg denied) invalid", poAppInterface->u16AppId );
                  }
               } // else own state remembered by using a register-id with value = AMT_C_U16_REGID_INVALID, don't send message
            } // end for all registered clients

            // set new interface-state
            poAppInterface->enInterfaceState = AIL_EN_N_APPLICATION_CLOSE_REQ;

         } // end if send REG_DENIED for all registered clients

         if ( bSetStateOfRefTableEntry )
         /* update of status in reference table for outgoing client messages */
         {
            tBool bFound = FALSE;
            tBool bServerShutdownIndication = FALSE;

            ail_tclServiceReferenceIterator  iter(poAppInterface->poServiceReferenceList);

            for ( ; !iter.bIsDone(); iter.vNext())
            /* there is sent a ServiceState-Message for every registered connection */
            {
               if ( iter.oItem().bIsDataSet( u16ServiceId, u16SourceAppId, u16RegisterId, u16SubId ) )
               {
                  bFound = TRUE;

                  if ( u8ServiceState != AMT_C_U8_SVCSTATE_REG_DENIED )
                  {
                     /* there is sent a ServiceState-Message for every registered connection */
                     iter.oItem().vSetServiceState( u8ServiceState );
                     break;
                  }
                  else
                  {  
                     /* a trigger for the user application is required */
                     bServerShutdownIndication = TRUE;
                     break;
                  }
               }
            }

            if ( bServerShutdownIndication )
            /* delete this entry from reference list */
            {
               (poAppInterface->poServiceReferenceList)->nRemove(iter.oItem());
               bFound = FALSE;
            }

            if ( !bFound )
            {
               if ( !bServerShutdownIndication )
               {
                  /* don't give a trigger to the user client application */
                  bMessageProcessed = TRUE;
                  poMessage->bDelete();
               }

               if ( u8ServiceState != AMT_C_U8_SVCSTATE_REG_DENIED )
               /* AutoFunction: Unregister this connection */
               {

                  /* create a new message object */
                  amt_tclServiceUnregister oMessageServiceUnregister
                  (  
                     poAppInterface->u16AppId, 
                     u16SourceAppId, 
                     u16ServiceId, 
                     u16RegisterId,
                     u16SubId,
                     AMT_C_U16_SUBID_DEFAULT
                  );

                  if ( oMessageServiceUnregister.bIsValid() )
                  {
                     /* post this message to the server */  
                     if ( !poAppInterface->bPostIpcMessage(
                              poAppInterface->u16AppId,
                              ail_hGetReceiverQueue
                              ( 
                                 poAppInterface->poOpenedQueueList,
                                 OSAL_C_INVALID_HANDLE, // access already protected,
                                 u16SourceAppId
                              ),
                              (amt_tclBaseMessage*) &oMessageServiceUnregister, 
                              AIL_C_U32_CCA_PRIO_MSG_SERVICE_UNREGISTER
                           )
                        )
                     {
                        oMessageServiceUnregister.bDelete();
                        ail_vTraceMsg( TR_LEVEL_ERRORS, 
                           "Application 0x%04x: AutoFunctionUnregister(): failed to send service-unregister-msg",
                           poAppInterface->u16AppId
                        );
                     }
                     else
                     {
                        ail_vTraceMsg( TR_LEVEL_ERRORS, "Application 0x%04x: AutoFunctionUnregister(): send service-unregister for service 0x%04x to server 0x%04x",
                                       poAppInterface->u16AppId,u16ServiceId,u16SourceAppId);
                     }
                  }
                  else
                  {
                     ail_vTraceMsg( TR_LEVEL_ERRORS, 
                        "Application 0x%04x: AutoFunctionUnregister(): service-unregister-msg invalid",
                        poAppInterface->u16AppId
                     );
                  }
               }
               /* else: send no UnregisterService in case of AMT_C_U8_SVCSTATE_REG_DENIED  */

               // if no other registration exists, close handle to messagequeue of this server
               bCloseQueueIfNoOtherRegsExists = TRUE;
            }
         }

         if ( bDelRefTableEntry || bDelRefTableAll )
         /* delete registered connection in client reference table -> no more client output */
         {
            if ( bDelRefTableEntry )
            {
               ail_tclServiceReferenceIterator  iter(poAppInterface->poServiceReferenceList);
               tBool                            bFound = FALSE;

               for ( ; !iter.bIsDone(); iter.vNext())
               {
                  if ( bDelRefTableEntry )
                  {
                     /* check correctness */
                     if ( iter.oItem().bIsDataSet( u16SourceAppId, u16RegisterId, u16SubId ) )
                     {
                        bFound = TRUE;
                        break;
                     }
                  }
               }
               if ( bFound )
               /* "nRemove"-operation influences the validity of the iterator */
               {
                  #ifdef AIL_MESSAGE_TRACE_SVC_MESSAGES
                  ail_vTraceMsg(TR_LEVEL_USER_2,
                                "Application 0x%04x, SubID %d: Client removed registration with register ID 0x%04x for service 0x%04x from application 0x%04x due to UNKNOWN-REG-ID indication.",
                                poAppInterface->u16AppId, u16SubId, u16RegisterId, u16ServiceId, u16SourceAppId);
                  #endif

                  (poAppInterface->poServiceReferenceList)->nRemove( iter.oItem() );

                  // With removing the service registration reference we must also remove 
                  // the service-request entry from the Server-Application-List to allow another
                  // and this time valid registration for the same service.
                  poAppInterface->vRemoveServiceRequest(u16ServiceId, 
                                                        u16SourceAppId, 
                                                        u16SubId, 
                                                        (u16SourceAppId == AMT_C_U16_APPID_INVALID) ? FALSE : TRUE, 
                                                        TRUE);

                  // And we must indicate the removed service registration to AIL extension.
                  poAppInterface->vOnRegistrationRemoved(u16ServiceId, u16SourceAppId, u16SubId);
               }
            }
            else
            /* bDelRefTableAll */
            {
               tBool bElementsInList = TRUE;

               while ( bElementsInList )
               {
                  ail_tclServiceReferenceIterator iter(poAppInterface->poServiceReferenceList);

                  if ( !iter.bIsDone() )
                  /* connection is on longer allowed to be established. Also inform all servers! */
                  {
                     tU16  u16ServerAppId       = iter.oItem().u16GetServerAppId();
                     tU16  u16ServerServiceId   = iter.oItem().u16GetServiceId();
                     tU16  u16ServerRegisterId  = iter.oItem().u16GetRegisterId();
                     tU16  u16ServerSubId       = iter.oItem().u16GetSubId();
                    
                     #ifdef AIL_MESSAGE_TRACE_SVC_MESSAGES
                     ail_vTraceMsg( TR_LEVEL_USER_2,
                        "Application 0x%04x having SubId %d: By reason APP_END do an unregister for service 0x%04x at Server 0x%04x using RegisterId %d",
                        poAppInterface->u16AppId, u16ServerSubId, u16ServerServiceId, u16ServerAppId, u16ServerRegisterId );
                     #endif

                     /* create a new message object */
                     amt_tclServiceUnregister oMessageServiceUnregister
                     (  
                        poAppInterface->u16AppId,
                        u16ServerAppId,
                        u16ServerServiceId,
                        u16ServerRegisterId,
                        u16ServerSubId,
                        AMT_C_U16_SUBID_DEFAULT
                     );

                     if ( oMessageServiceUnregister.bIsValid() )
                     {
                        /* by force unregister: post this message with highest prio to the server */  
                        if ( !poAppInterface->bPostIpcMessage(
                                 poAppInterface->u16AppId,
                                 ail_hGetReceiverQueue
                                 ( 
                                    poAppInterface->poOpenedQueueList,
                                    OSAL_C_INVALID_HANDLE, // access already protected
                                    u16ServerAppId
                                 ),
                                 (amt_tclBaseMessage*) &oMessageServiceUnregister, 
                                 AIL_C_U32_CCA_PRIO_MSG_SERVICE_UNREGISTER ) )
                        {
                           oMessageServiceUnregister.bDelete();
                           ail_vTraceMsg( TR_LEVEL_ERRORS, "Application 0x%04x: AIL_EN_N_ADMIN_APPCLOSE_CHECK: failed to send service-unregister-msg", poAppInterface->u16AppId );
                        }
                        else
                        {
                           ail_vTraceMsg( TR_LEVEL_SYSTEM_MIN, "Application 0x%04x: AIL_EN_N_ADMIN_APPCLOSE_CHECK: send service-unregister-msg", poAppInterface->u16AppId );
                        }
                     }
                     else
                     {
                        ail_vTraceMsg( TR_LEVEL_ERRORS, "Application 0x%04x: AIL_EN_N_ADMIN_APPCLOSE_CHECK: service-unregister-msg invalid", poAppInterface->u16AppId );
                     }

                     /* last not least: Remove the connection from the reference list */
                     (poAppInterface->poServiceReferenceList)->nRemove(iter.oItem());
                  }
                  else
                  {
                     bElementsInList = FALSE;  
                  }   
               }
            }
         }

         if ( bDelRegTableEntry || bDelRegTableAll )
         /* delete registered connection in server register table -> no more server output */
         {
            if ( bDelRegTableEntry )
            /* work on registry: Only client is allowed to inform a server by this message */
            {
               ail_tclServiceRegistryIterator iter(poAppInterface->poServiceRegistryList);
               tBool bFound = FALSE;

               for ( ; !iter.bIsDone() && !bFound; iter.vNext())
               {
                  /* check correctness */
                  if ( iter.oItem().bIsDataSet( u16RegisterId, u16ServiceId, u16SourceAppId, u16SubId ) )
                  {
                     bFound = TRUE;
                  }
               }

               if ( bFound )
               /* this is an unregister on an established connection */
               {
                  ail_tclServiceRegistry  oServiceRegistry( u16RegisterId, u16ServiceId, u16SourceAppId, u16SubId );

                  /* remove the registration from the registration list */        
                  (poAppInterface->poServiceRegistryList)->nRemove(oServiceRegistry);

                  // An unregister for the AIL internal service CCA_C_U16_SRV_APPINFO 
                  // must not be indicated to the user appliaton. Therefore mark the
                  // unregister message as processed and delete it.
                  if (CCA_C_U16_SRV_APPINFO == u16ServiceId)
                  {
                    bMessageProcessed = TRUE;
                    poMessage->bDelete();
                  }
               }
               else
               /* the entry is already cleared from the registry table */
               {
                  /* don't give a trigger to the user server application */
                  bMessageProcessed = TRUE;
                  poMessage->bDelete();
               }
            }
            else
            /* bDelRegTableAll */
            {
               tBool bElementsInList = TRUE;

               while ( bElementsInList )
               {
                  ail_tclServiceRegistryIterator iter(poAppInterface->poServiceRegistryList);

                  if ( !iter.bIsDone() )
                  {
                     (poAppInterface->poServiceRegistryList)->nRemove(iter.oItem());
                  }
                  else
                  {
                     bElementsInList = FALSE;  
                  }   
               }
            }
         }

         if ( bSyncSetAnswerToDataObj || bSyncAbortDataObj || bSyncAbortAll )
         /* refer to the list of synchron waiting objects */
         {
            if ( (poAppInterface->poServiceSyncAnswerList)->nSize() )
            /* there is some thread waiting for an synchronous answer */
            {
               ail_tclServiceSyncAnswerIterator iter( poAppInterface->poServiceSyncAnswerList );

               for (; !iter.bIsDone() && !bMessageProcessed ; iter.vNext())
               {
                  if ( bSyncAbortAll )
                  {
                    iter.oItem().vForwardAbort ( enForwardReason );
                  }
                  else if ( bSyncAbortDataObj )
                  {
                     if (iter.oItem().bIsWaitForData(u16SourceAppId, u16RegisterId, u16ServiceId, u16SubId))
                     {
                        /* prevents hang up of "enSendMessage()" */
                        iter.oItem().vForwardAbort ( enForwardReason );
                     }
                  }
                  else if ( bSyncSetAnswerToDataObj )           
                  {
                     if (  iter.oItem().bIsWaitForData(u16SourceAppId, u16RegisterId, u16CmdCounter, u16ServiceId, u16SubId, u16FunctionId, u8Act ))
                     {
                        /* example for pointer accessing to the object in the list:
                           ail_tclServiceSyncAnswer*        poServiceSyncAnswer;
                           poServiceSyncAnswer = &(iter.oItem());
                           poServiceSyncAnswer->bForwardAnswer(poMessage);
                        */
                           
                        /* try to forward your message */
                        /* if forwarding wasn't possible, then this message is asynchronously put into the message queue of the body thread */
                        bMessageProcessed = iter.oItem().bForwardAnswer(poMessage);
                     }
                  }
               } 
               
            }
         }

         if (  bCloseQueueIfNoOtherRegsExists || bCloseOpenedQueue )
         {
            tBool bFound = FALSE;

            #ifndef AIL_KEEP_MSG_QUEUE_HANDLES_TO_OTHER_APPS_UNTIL_TERMINATION
            if ( bCloseQueueIfNoOtherRegsExists )
            {
               // examine for other registrations of this client
               bFound = ail_bCheckRegistrationsToApp
               (
                  poAppInterface->poServiceReferenceList,
                  poAppInterface->poServiceRegistryList,
                  OSAL_C_INVALID_HANDLE, // access already protected
                  u16SourceAppId
               );
            }
            #endif

            if ( !bFound )
            {
               if ( poAppInterface->poOpenedQueueList )
               {
                  // close handle to messagequeue of this server
                  ail_bDeleteFromOpenedQueueList
                  (
                     poAppInterface->poOpenedQueueList,
                     OSAL_C_INVALID_HANDLE, // access already protected
                     u16SourceAppId
                  );
               } // else poOpenedQueueList doesn't exist
            }
         }

         /* release the list access */
         ail_bReleaseListAccess( poAppInterface->hGeneralListAccess );
      }
   } 

   return (bMessageProcessed);

  //## end ail_tclInternalDispatch::ail_bExamineInfluenceToAdministration%3BAAFA740359.body
}

tBool ail_tclInternalDispatch::bPreActionOnStateChangeRequest(amt_tclBaseMessage* poMessage)
{
   tBool bSuccess = TRUE;
   
   if ( poAppInterface->bRequestTimeOnStateChangeAutomatically() )
   {
      // Downcast Object
      amt_tclPowerMessage oPowerMessage(poMessage);
      
      // get type of power msg
      tU16 u16PowerType = oPowerMessage.u16GetPowerType();
      tU32 u32PowerData1 = oPowerMessage.u32GetPowerData1();
      
      // if state-change-msg
      if (  u16PowerType == AMT_C_U16_PWR_PROXY_STATE_CHANGE_IMMEDIATELY
         || u16PowerType == AMT_C_U16_PWR_PROXY_STATE_CHANGE_REQ )
      {
         tBool bSendRequestForExtraTime = FALSE;

         // protect access to u32LastConfirmedAppState
         if ( ail_bTakeListAccess( poAppInterface->hGeneralListAccess ) )
         {
            // list access is sheltered
            // check if state not reached
            if ( u32PowerData1 != poAppInterface->u32LastConfirmedAppState )
            {
               bSendRequestForExtraTime = TRUE;
            }
            // release the list access
            ail_bReleaseListAccess( poAppInterface->hGeneralListAccess );
         }
         
         // request needed and LpmId known?
         if ( bSendRequestForExtraTime )
         {
            if ( poAppInterface->u16LpmId != AMT_C_U16_APPID_INVALID )
            {
               #ifdef AIL_MESSAGE_TRACE_POWER_MESSAGES
               ail_vTraceMsg( TR_LEVEL_USER_2, "Application 0x%04x: ENTRY sends request for extra time (20s) to Lpm\n", poAppInterface->u16AppId );
               #endif
               // send request for extra time to LPM
               bSuccess = poAppInterface->bSendCCAPowerMsg (
                  poAppInterface->u16LpmId,
                  poAppInterface->hLpmInQueue,
                  AIL_C_U32_CCA_PRIO_MSG_POWER,
                  AMT_C_U16_PWR_APP_STATE_ACK,
                  u32PowerData1,                      // new state
                  (tU32) 20000 );                     // 20s
            }
            else
            {
               // couldn't send msg to LPM
               bSuccess = FALSE;
            }
         }
      }
   }
   
   return (bSuccess);
}

/*******************************************************************************
*
* FUNCTION: ail_tclInternalDispatch::ail_vHandleMsgDebugApplication()
*
* DESCRIPTION: Decode and evaluate a received CCA message of type 
*              AMT_C_U8_TYPE_DEBUG_APPLICATION.
*
* PARAMETER: [IN] poMessage = Message object.
*
* RETURNVALUE: TRUE  = Message object processed and deleted.
*.             FALSE = Message object NOT processed and therefore not deleted.
*
*******************************************************************************/
tBool ail_tclInternalDispatch::ail_bHandleMsgDebugApplication(amt_tclBaseMessage* poMessage)
{
   amt_tclDebugAppInfo oDebugApplicationMessage(poMessage);

   tU8  u8Command = oDebugApplicationMessage.u8GetCommand();
   tU8* pu8Data   = oDebugApplicationMessage.pu8GetData();

   if (pu8Data != NULL)
   {
     switch (u8Command)
     {
       case AMT_C_U8_CCAMSG_DEBUG_APPLICATION_GET_APP_INFO :
       {
         poAppInterface->vTraceInternalState(TR_LEVEL_ERRORS); 

         break;
       }

       case AMT_C_U8_CCAMSG_DEBUG_APPLICATION_TRIGGER_USER_ACTION :
       {
         poAppInterface->vOnTriggerUserAction(pu8Data);

         break;
       }

       default :
       {
         ail_vTraceMsg(TR_LEVEL_ERRORS, "Application 0x%04x | ail_bHandleMsgDebugApplication() => Unknown content for message parameter 'u8Command'.", poAppInterface->u16AppId );

         break;
       }
     }
   }
   else
   {
     ail_vTraceMsg(TR_LEVEL_FATAL, "Application 0x%04x | ail_bHandleMsgDebugApplication() => Can't access content from message parameter 'pu8Data'.", poAppInterface->u16AppId);
   }

  // Message processed so delete message object.
  poMessage->bDelete();

  return (TRUE);
}

//## begin module%3A9B9A9B00D0.epilog preserve=yes
//## end module%3A9B9A9B00D0.epilog
