/*****************************************************************************
 * FILE:          FIUtil.h
 * SW-COMPONENT:  
 * DESCRIPTION:   
 *                
 * AUTHOR:        CM-DI/ESA2-Bruns
 * COPYRIGHT:     (c) 2004 Blaupunkt Werke GmbH
 * HISTORY:       
 *                19.04.04 Rev. 1.0 CM-DI/ESA2-Bruns
 *                         Initial Revision;
 *****************************************************************************/
#ifndef FIUTIL_H
   #define FIUTIL_H



 
 /*****************************************************************************
| includes of component-internal interfaces, if necessary
| (scope: component-local)
|----------------------------------------------------------------------------*/
#include "FISettings.h"
#include "DLLMain.h"

#include <vector>
#include <list>
#include <string>
using namespace std;

#include <xercesc/util/PlatformUtils.hpp>
#include <xercesc/parsers/XercesDOMParser.hpp>
#include <xercesc/sax/HandlerBase.hpp>
#include <xercesc/util/XMLString.hpp>
#include "xercesc/dom/DOM.hpp"
using namespace xercesc;




/*****************************************************************************
| typedefs (scope: global)
|----------------------------------------------------------------------------*/
#define X(str) XMLString::transcode(str)




/*****************************************************************************
| function prototypes (scope: global)
|----------------------------------------------------------------------------*/
void vSetVerbosity(bool bNewVerbosity);
void vWarning(const char *pcFormatString, ...);
void vError(const char *pcFormatString, ...);
void vPrintMsg(const char *pcText, ...);

void vPrintNode(int iIndex, DOMNode *pNode);

DOMNode *pGetFirstCommentSubNode(DOMElement *pNode);
DOMElement* poGetElementFromDoc(DOMDocument *poDOMDoc, const char *pcSourceTagString);
DOMNodeList* poGetNodeListFromDoc(DOMDocument *poDOMDoc, const char *pcSourceTagString);
DOMNodeList* poGetNodeListFromElement(DOMElement *poDOMElem, const char *pcSourceTagString);
DOMNodeList* poGetNodeListFromNode(DOMNode *poDOMNode, const char *pcSourceTagString);

//int         iGetNumSubNodesByTag(DOMElement *poDOMElem, char *pcSourceTagString);
bool        bGetElementAttribute(string &DestiValueString, DOMElement *poDOMElem, const char *pcSourceNameTag, int i);
bool        bGetElementAttribute(string &DestiValueString, DOMElement *poDOMElem, const char *pcSourceNameTag);
bool        _bGetElementFirstChildValue(string &orDestinationString, DOMElement *poDOMElem, const char *pcSourceTagString, int i);
// bool        _bGetElementFirstChildValue(string &orDestinationString, DOMNode *poDOMNode, char *pcSourceTagString, int i);

bool bGetElementAttribute(string &orDestinationString, DOMNode *poDOMNode, const char *pcSourceTagString);
// bool        bGetElementValueString(string &orDestinationString, DOMNode *poDOMNode, char *pcSourceTagString);

bool bGetSubNode1Attribute(string &oDestiString, DOMElement *poDOMElem, const char *pcSubNodeTagString, const char *pcAttributeTagString);



bool bHasAttribute(DOMElement *poDOMElem, const char *pcSourceTagString);

DOMElement *poGetSubNode1(DOMElement *poDOMElem, const char *pcSubNodeTagString);
DOMElement *poGetSubNode1(DOMNode *poDOMNode, const char *pcSubNodeTagString);
FIOBJECTTREEDLL_API string      oGetFileNameOfDOMNode(DOMNode* poNode);
// bool bHasSubNode1(DOMNode *poDOMNode, char *pcSubNodeTagString);
#endif   // FIUTIL_H
