/*****************************************************************************
 * FILE:          FIUtil.cpp
 * SW-COMPONENT:  
 * DESCRIPTION:   
 *                
 * AUTHOR:        CM-DI/ESA2-Bruns
 * COPYRIGHT:     (c) 2004 Blaupunkt Werke GmbH
 * HISTORY:       
 *                19.04.04 Rev. 1.0 CM-DI/ESA2-Bruns
 *                         Initial Revision;
 *****************************************************************************/




//-----------------------------------------------------------------------------
// General includes
//-----------------------------------------------------------------------------
#include "FIUtil.h"
#include "FISettings.h"
#include "stdarg.h"
//#include "stdio.h"
#include <iostream>
#include <fstream>




static bool  bBeVerbose = false;




/*****************************************************************************
| function implementation
|-----------------------------------------------------------------------------*/
void vWarning(const char *pcFormatString, ...)
{
   char pcBuffer[DEBUG_LINE_LEN] ="";
   va_list argList;
   va_start(argList, pcFormatString);
   vsnprintf(pcBuffer, DEBUG_LINE_LEN, pcFormatString, argList);

   cout << "WARNING: " << pcBuffer << endl;
}

void vError(const char *pcFormatString, ...)
{
   char pcBuffer[DEBUG_LINE_LEN] ="";
   va_list argList;
   va_start(argList, pcFormatString);
   vsnprintf(pcBuffer, DEBUG_LINE_LEN, pcFormatString, argList);

   cout << "ERROR: " << pcBuffer << endl;
}



void vSetVerbosity(bool bNewVerbosity)
{
   bBeVerbose = bNewVerbosity;
}




void vPrintMsg(const char *pcFormatString, ...)
{
   if(bBeVerbose)
   {
      char pcBuffer[DEBUG_LINE_LEN] ="";
      va_list argList;
      va_start(argList, pcFormatString);
      vsnprintf(pcBuffer, DEBUG_LINE_LEN, pcFormatString, argList);
      cout << pcBuffer;
   }
}




DOMNodeList* poGetNodeListFromElement(DOMElement *poDOMElem, const char *pcSourceTagString)
{
   DOMNodeList* poNodeList = poDOMElem->getElementsByTagName(X(pcSourceTagString));
   return poNodeList;
}



DOMNodeList* poGetNodeListFromNode(DOMNode *poDOMNode, const char *pcSourceTagString)
{
   DOMNodeList *pResultList = 0;
   if(poDOMNode->getNodeType() == DOMNode::ELEMENT_NODE)
   {
      DOMElement* poDOMElem = static_cast<DOMElement*>(poDOMNode);
      pResultList = poDOMElem->getElementsByTagName(X(pcSourceTagString));
   }
   return pResultList;
}




bool _bGetElementFirstChildValue(string &orDestinationString, DOMElement *poDOMElem, const char *pcSourceTagString, int i)
{
   bool bSuccess = false;

   DOMNodeList* poNodeList = poDOMElem->getElementsByTagName(X(pcSourceTagString));
   if(i < poNodeList->getLength())
   {
      DOMNode *poWantedNode = poNodeList->item(i);
      if(0 != poWantedNode)
      {
         DOMNode *poDataNode = poWantedNode->getFirstChild();
         if(0 != poDataNode)
         {
            orDestinationString = X(poDataNode->getNodeValue());
            bSuccess = true;
         }
      }
   }
   return bSuccess;
}




// toDo: check this routine!
DOMNodeList* poGetNodeListFromDoc(DOMDocument *poDOMDoc, const char *pcSourceTagString)
{
   DOMNodeList* poNodeList = poDOMDoc->getElementsByTagName(X(pcSourceTagString));
   return poNodeList;
}



/*
bool bGetElementValueString(string &orDestinationString, DOMNode *poDOMNode, char *pcSourceTagString)
{
   bool bSuccess = false;
   if(poDOMNode->getNodeType() == DOMNode::ELEMENT_NODE)
   {
      DOMElement* pElement = static_cast<DOMElement*>(poDOMNode);
      orDestinationString = X(pElement->getAttribute(X(pcSourceTagString)));
      bSuccess = true;
   }
   return bSuccess;
}
*/

/*
bool _bGetSubElementDataString(string &orDestinationString, DOMNode *poDOMNode, char *pcSourceTagString, int i)
{
   return false;
}
*/

bool bGetElementAttribute(string &orDestinationString, DOMElement *poDOMElem, const char *pcSourceTagString)
{
   bool bSuccess = false;
   if(poDOMElem->hasAttribute(X(pcSourceTagString)))
   {
      orDestinationString = X(poDOMElem->getAttribute(X(pcSourceTagString)));
      bSuccess = true;
   }
   return bSuccess;
}

bool bGetElementAttribute(string &orDestinationString, DOMNode *poDOMNode, const char *pcSourceTagString)
{
   bool bSuccess = false;

   if(poDOMNode->getNodeType() == DOMNode::ELEMENT_NODE)
   {
      DOMElement* poDOMElem = static_cast<DOMElement*>(poDOMNode);
      bSuccess = bGetElementAttribute(orDestinationString, poDOMElem, pcSourceTagString);
   }
   return bSuccess;
}





void vGetNodeData(string &oNodeTypeString, string &oNodeNameString, string &oNodeValueString, DOMNode *pNode)
{
   switch(pNode->getNodeType())
   {  
      case DOMNode::ELEMENT_NODE:
         oNodeTypeString = "ELEMENT";
         oNodeNameString = X(pNode->getNodeName());
         oNodeValueString= ""; //X(pNode->getNodeValue());
         break;
      case DOMNode::ATTRIBUTE_NODE:
         oNodeTypeString = "ATTRIBUTE";
         oNodeNameString = X(pNode->getNodeName());
         oNodeValueString= X(pNode->getNodeValue());
         break;
      case DOMNode::TEXT_NODE:
         oNodeTypeString = "TEXT";                      
         oNodeNameString = X(pNode->getNodeName());
         oNodeValueString= X(pNode->getNodeValue());
      case DOMNode::COMMENT_NODE:
         oNodeTypeString = "COMMENT";                   
         oNodeNameString = X(pNode->getNodeName());
         oNodeValueString= X(pNode->getNodeValue());
         break;
      case DOMNode::CDATA_SECTION_NODE:
         oNodeTypeString = "CDATA_SECTION";             break;
         oNodeNameString = X(pNode->getNodeName());
         oNodeValueString= X(pNode->getNodeValue());
      case DOMNode::ENTITY_REFERENCE_NODE:
         oNodeTypeString = "ENTITY_REF.";          break;
         oNodeNameString = X(pNode->getNodeName());
         oNodeValueString= X(pNode->getNodeValue());
      case DOMNode::ENTITY_NODE:
         oNodeTypeString = "ENTITY";                    break;
         oNodeNameString = X(pNode->getNodeName());
         oNodeValueString= X(pNode->getNodeValue());
      case DOMNode::PROCESSING_INSTRUCTION_NODE:
         oNodeTypeString = "PROC._INSTR.";    break;
         oNodeNameString = X(pNode->getNodeName());
         oNodeValueString= X(pNode->getNodeValue());
      case DOMNode::DOCUMENT_NODE:
         oNodeTypeString = "DOCUMENT";                  break;
         oNodeNameString = X(pNode->getNodeName());
         oNodeValueString= "";//X(pNode->getNodeValue());
      case DOMNode::DOCUMENT_TYPE_NODE:
         oNodeTypeString = "DOC._TYPE";             break;
         oNodeNameString = X(pNode->getNodeName());
         oNodeValueString= X(pNode->getNodeValue());
      case DOMNode::DOCUMENT_FRAGMENT_NODE:
         oNodeTypeString = "DOC._FRAGMENT";         break;
         oNodeNameString = X(pNode->getNodeName());
         oNodeValueString= X(pNode->getNodeValue());
      case DOMNode::NOTATION_NODE:
         oNodeTypeString = "NOTATION";                  break;
         oNodeNameString = X(pNode->getNodeName());
         oNodeValueString= X(pNode->getNodeValue());
      // XML_DECL_NODE:
      
      default:
         oNodeTypeString = "--- unknown ---";
         oNodeNameString = "--- unknown ---";
         oNodeValueString= "--- unknown ---";
   }

/*
   printf("%s  -  name=%s\n", oNodeTypeString.c_str());
   for(int i=0; i < iIndex+2; i++)
      printf(" ");
   printf("name = %s\n", oNodeNameString.c_str());

   for(i=0; i < iIndex+2; i++)
      printf(" ");
   printf("value= %s\n", oNodeValueString.c_str());
*/
}


DOMNode *pGetFirstCommentSubNode(DOMElement *pNode)
{
   DOMNode *pResult=0;
   DOMNodeList *poChildList = pNode->getChildNodes();
   int iCount = poChildList->getLength();

   // Iterate Childs
   for (int iChildIndex= 0; iChildIndex < iCount; iChildIndex++) 
   {
      DOMNode *pChild = poChildList->item(iChildIndex);
      // vPrintNode(0, pChild);
      //if(DOMNode::COMMENT_NODE == pNode->getNodeType())
      {
         pResult = pChild;
         break;
      }
   }
   return pResult;
}


void vPrintAttributes(int iIndex, DOMNode *pNode)
{
   if(pNode->hasAttributes())
   {
      DOMNamedNodeMap *poNodeMap = pNode->getAttributes();

      XMLSize_t len = poNodeMap ->getLength();
      for (XMLSize_t i = 0; i < len; i++) 
      {
         DOMNode* pAttrNode = poNodeMap->item(i);
         vPrintNode(iIndex, pAttrNode);
      }
   }
}


void vPrintNode(int iIndex, DOMNode *pNode)
{
   cout << endl;
   DOMNodeList *poChildList = pNode->getChildNodes();
   int iCount = poChildList->getLength();
   int i=0;

   for(i=0; i < iIndex; i++)
      printf(" ");
   printf("[%3d] ", iIndex);

   string oNodeTypeString, oNodeNameString, oNodeValueString;
   vGetNodeData(oNodeTypeString, oNodeNameString, oNodeValueString, pNode);

   printf("%s   (childs=%d)\n", oNodeTypeString.c_str(), iCount);
   for(i=0; i < iIndex; i++)
      printf(" ");
   printf("      name = %s\n", oNodeNameString.c_str());
   for(i=0; i < iIndex; i++)
      printf(" ");
   printf("      value= %s\n", oNodeValueString.c_str());

   vPrintAttributes(iIndex+2, pNode);

   // Iterate Childs
   for (int iChildIndex= 0; iChildIndex < iCount; iChildIndex++) 
   {
      DOMNode *pChild = poChildList->item(iChildIndex);
      vPrintNode(iIndex+2, pChild);
   }

   for(i=0; i < iIndex; i++)
      printf(" ");
   printf("[%3d] END\n", iIndex);

}




bool bGetSubNode1Attribute(string &oDestiString, DOMElement *poDOMElem, const char *pcSubNodeTagString, const char *pcAttributeTagString)
{
   bool bSuccess = false;
   DOMElement *poDOMWantedElement = 0;

   DOMNodeList* poNodeList = poGetNodeListFromElement(poDOMElem, pcSubNodeTagString);
   if(0 != poNodeList)
   {
      if(1 == poNodeList->getLength())
      {
         DOMNode *poWantedNode = poNodeList->item(0);
         bSuccess = bGetElementAttribute(oDestiString, poWantedNode, pcAttributeTagString);
      }
   }
   return bSuccess;
}



DOMElement *poGetSubNode1(DOMElement *poDOMElem, const char *pcSubNodeTagString)
{
   DOMElement *poDOMWantedElement = 0;

   DOMNodeList* poNodeList = poGetNodeListFromElement(poDOMElem, pcSubNodeTagString);
   if(0 != poNodeList)
   {
      if(1 == poNodeList->getLength())
      {
         DOMNode *poWantedNode = poNodeList->item(0);
         poDOMWantedElement = static_cast<DOMElement*>(poWantedNode);
      }
   }
   return poDOMWantedElement;
}


DOMElement *poGetSubNode1(DOMNode *poDOMNode, const char *pcSubNodeTagString)
{
   DOMElement *poDOMWantedElement = 0;

   DOMNodeList* poNodeList = poGetNodeListFromNode(poDOMNode, pcSubNodeTagString);
   if(0 != poNodeList)
   {
      if(1 == poNodeList->getLength())
      {
         DOMNode *poWantedNode = poNodeList->item(0);
         poDOMWantedElement = static_cast<DOMElement*>(poWantedNode);
      }
   }
   return poDOMWantedElement;
}
/*
bool bHasSubNode1(DOMNode *poDOMNode, char *pcSubNodeTagString)
{
   bool bSuccess = false;

   if(poDOMNode->getNodeType() == DOMNode::ELEMENT_NODE)
   {
      DOMElement* poDOMElem = static_cast<DOMElement*>(poDOMNode);

      // toDO: result if no element node found is omitted here! check this!
      DOMNodeList* poNodeList = poGetNodeListFromElement(poDOMElem, pcSubNodeTagString);
      if(0 != poNodeList)
      {
         bSuccess = (1 == poNodeList->getLength());
      }
   }
   return bSuccess;
}
*/



bool bHasAttribute(DOMElement *poDOMElem, const char *pcSourceTagString)
{
   return poDOMElem->hasAttribute(X(pcSourceTagString));
}




/*DOMElement* poGetSubNode1(DOMElement *poDOMElem, char *pcSourceTagString)
{
   DOMElement *poDOMWantedElement = 0;

   DOMNodeList* poNodeList = poDOMElem->getElementsByTagName(X(pcSourceTagString));
   if(1 == poNodeList->getLength())
   {
      DOMNode *poWantedNode = poNodeList->item(0);
      if(poWantedNode->getNodeType() == DOMNode::ELEMENT_NODE)
      {
         poDOMWantedElement = static_cast<DOMElement*>(poWantedNode);
      }
   }
   return poDOMWantedElement;
}
*/

string oGetFileNameOfDOMNode(DOMNode* poNode)
{
   string oRetName = "";
   // poNode = poNode->getParentNode();
   while (poNode != NULL)
   {
      // cout << "Node Type = " << poNode->getNodeType() << endl;
      switch (poNode->getNodeType())
      {
      case DOMNode::ENTITY_REFERENCE_NODE:
         {
            string oEntityName = X(poNode->getNodeName());
            DOMDocument* poDoc = poNode->getOwnerDocument();
            DOMDocumentType* poDocType = poDoc->getDoctype();
            DOMNamedNodeMap* poEntities = poDocType->getEntities();
            DOMEntity* poEntity = (DOMEntity*)poEntities->getNamedItem(X(oEntityName.c_str()));
            //string oFileName = X(poEntity->getSystemId());
            //return oFileName;
            return X(poEntity->getSystemId());
         } break;
      case DOMNode::ELEMENT_NODE:
         poNode = (DOMElement*)poNode->getParentNode();
         break;
      case DOMNode::DOCUMENT_NODE:
         return X(((DOMDocument*)poNode)->getDocumentURI());
         break;
      default:
         poNode = 0;
      }
   }
   return oRetName;
}
