/*****************************************************************************
 * FILE:          FIServiceTree.h
 * SW-COMPONENT:  
 * DESCRIPTION:   
 *                
 * AUTHOR:        CM-DI/ESA2-Bruns
 * COPYRIGHT:     (c) 2004 Blaupunkt Werke GmbH
 * HISTORY:       
 *                19.04.04 Rev. 1.0 CM-DI/ESA2-Bruns
 *                         Initial Revision;
 *****************************************************************************/

#ifndef FI_SERVICE_TREE_H
   #define FI_SERVICE_TREE_H




/*****************************************************************************
| includes of component-internal interfaces, if necessary
| (scope: component-local)
|----------------------------------------------------------------------------*/
#include "FISettings.h"
#include "DLLMain.h"
#include "FINode.h"
#include "FINodePool.h"
#include "FIDependency.h"
#include "FIDocumentation.h"
#include "FIVersion.h"
#include "FIParser.h"
#include "FIExtractor.h"


#include <xercesc/util/PlatformUtils.hpp>
#include <xercesc/parsers/XercesDOMParser.hpp>
#include <xercesc/sax/HandlerBase.hpp>
#include <xercesc/util/XMLString.hpp>
#include "xercesc/dom/DOM.hpp"

using namespace xercesc;




/*****************************************************************************
| typedefs (scope: global)
|----------------------------------------------------------------------------*/




/*****************************************************************************
| function prototypes (scope: global)
|----------------------------------------------------------------------------*/
//class tclFIServiceGroup;
class FIOBJECTTREEDLL_API tclFINodeList;
class FIOBJECTTREEDLL_API tclFIVersionList;
class FIOBJECTTREEDLL_API tclFIServiceTree
{
   // Catalogue data
   string                  oFilename;
   string                  oShortname;
   string                  oFullname;
   tclFIDocumentation      oDescription;
   int                     iServiceID;
   tclFIVersionList        oCatalogueVersionList;

   tclFIMessageNodePool    *poMessagePool;
   tclFITypeNodePool      *poUsedGlobalTypePool;
   tclFITypeNodePool      *poUsedGlobalErrorPool;

   // Used parser
   tclDOMParser            *poParser;

   // Pointer to DOM-root node of service (not for client use!)
   DOMElement              *poServiceRoot;

protected:

public:
                           tclFIServiceTree(tclFITypeNodePool *poGlobalTypePool, tclFITypeNodePool *poGlobalErrorPool);
                          ~tclFIServiceTree();
   bool                    bReadService(char *pcFilename);
   bool                    bValidate();

   // Standard-API
   bool                    bIsValid();

   // ServiceTree specific API
   string                  oGetFilename()                { return oFilename;              }
   string                  oGetShortname()               { return oShortname;             }
   void                    vSetShortname(string oShortName);
   string                  oGetFullname()                { return oFullname;              }
   void                    vSetFullname(string oFullName);
   int                     iGetServiceID()               { return iServiceID;             }
   void                    vSetServiceID(int iNewServiceID);
   DOMDocument            *poGetDOMDoc();
   tclFIMessageNodePool   *poGetMessagePool()            { return poMessagePool;          }
   tclFITypeNodePool      *poGetUsedGlobalTypePool()     { return poUsedGlobalTypePool;   }
   tclFITypeNodePool      *poGetUsedGlobalErrorPool()    { return poUsedGlobalErrorPool;  }

   tclFIVersionList       *poGetCatalogueVersionList()   { return &oCatalogueVersionList; }
   bool                    bAddCatalogueVersion(tclFIVersion &oNewVersion);
   int                     iGetNumMessages();
};



typedef list<tclFIServiceTree*>            _tclFIServiceTreeList;
typedef _tclFIServiceTreeList::const_iterator tclFIServiceTreeListIterator;


class tclFIServiceTreeList : public _tclFIServiceTreeList
{
public:
                           tclFIServiceTreeList();
                          ~tclFIServiceTreeList();
   // Standard-API
   bool                    bIsValid();
};


#endif // FI_SERVICE_TREE_H