/*****************************************************************************
 * FILE:          FINode.h
 * SW-COMPONENT:  
 * DESCRIPTION:   
 *                
 * AUTHOR:        CM-DI/ESA2-Bruns
 * COPYRIGHT:     (c) 2004 Blaupunkt Werke GmbH
 * HISTORY:       
 *                19.04.04 Rev. 1.0 CM-DI/ESA2-Bruns
 *                         Initial Revision;
 *****************************************************************************/

#ifndef FI_NODE_H
   #define FI_NODE_H





/*****************************************************************************
| includes of component-internal interfaces, if necessary
| (scope: component-local)
|----------------------------------------------------------------------------*/
#include "FISettings.h"
#include "DLLMain.h"
#include "FIVersion.h"
#include "FIDocumentation.h"
#include "FIDependency.h"

#include <vector>
#include <list>
#include <map>
#include <string>

using namespace std;

#include <xercesc/util/PlatformUtils.hpp>
#include <xercesc/parsers/XercesDOMParser.hpp>
#include <xercesc/sax/HandlerBase.hpp>
#include <xercesc/util/XMLString.hpp>
#include "xercesc/dom/DOM.hpp"

using namespace xercesc;



/*****************************************************************************
| typedefs (scope: global)
|----------------------------------------------------------------------------*/
// FORWARDS
#define FI_NODE_SIZE_NOTCALC  -2
#define FI_NODE_SIZE_DYNAMIC  -1


class FIOBJECTTREEDLL_API tclFITypeDependencyList;




// DEFINES / ENUMS
enum tenFINodeType{
   EN_OBJTYPE_UNDEFINED,
   EN_OBJTYPE_ATOM,
   EN_OBJTYPE_TYPE,
   EN_OBJTYPE_ENUMERATION,
   EN_OBJTYPE_BITFIELD,
   EN_OBJTYPE_STRUCTURE,
// MOST-compatible extensions (mkoch, 2010-03-03)
   EN_OBJTYPE_ARRAY,
   EN_OBJTYPE_FRAME,
   EN_OBJTYPE_UNION,
// ---------------------------(mkoch, 2010-03-03)
   EN_OBJTYPE_MESSAGE_METHOD,
   EN_OBJTYPE_MESSAGE_PROPERTY,
   EN_OBJTYPE_OPCODE,
   EN_OBJTYPE_ERRORDEF,
};




/*****************************************************************************
| function prototypes (scope: global)
|----------------------------------------------------------------------------*/
class FIOBJECTTREEDLL_API tclFINode
{
   // uesed as base
   DOMElement                *pDOMElement;

   // taken from DOM Node
   string                     oName;
   tenFINodeType              enType;
   string                     oDefaultValue;
   tclFIVersionRange          oVersionRange;
   tclFIDocumentation         oDescription;
                              
   // calculated at runtime   
   int                        iDataSize;      // <0: n.a.; >=0 ok.
   tclFITypeDependencyList    oParentList;
   tclFITypeDependencyList    oDependencyList;

public:                       
	// string oGetFileName();
                              tclFINode(DOMElement      *pElement,
                                       string            oName,
                                       tenFINodeType     enType,
                                       string            oDefaultValue,
                                       tclFIVersionRange oVersionRange,
                                       tclFIDocumentation  oDescription);
                              
   virtual                   ~tclFINode();
                              
   // Node Specific API       
   DOMElement                 *poGetDOMElement()       { return pDOMElement;      }
   const string&               oGetName()              { return oName;            }
   tenFINodeType               enGetType()             { return enType;           }
   string                      oGetDefaultValue()      { return oDefaultValue;    }
   tclFIVersionRange          *poGetVersionRange()     { return &oVersionRange;   }
   tclFIDocumentation           *poGetDescription()      { return &oDescription;    }
   int                         iGetDataSize()          { return iDataSize;        }
   void                        vSetDataSize(int iSize);
   tclFITypeDependencyList    *poGetDependencyList()   { return &oDependencyList; }
   tclFITypeDependencyList    *poGetParentList()       { return &oParentList; }
      
   string                      oGetNodeTypeString();
                              
   bool                        bAddDependency(tclFITypeDependency *pNewDependency);
   bool                        bAddParentLink(tclFITypeDependency *pNewDependency);
   tclFITypeDependency        *poFindDependency(string &oNameOfLink);



   bool                        bDependsOn(tclFINode *poNode);
   bool                        bHasVersionInformation();
};





#endif   // FI_NODE_H