/*****************************************************************************
 * FILE:          FINode.cpp
 * SW-COMPONENT:  
 * DESCRIPTION:   
 *                
 * AUTHOR:        CM-DI/ESA2-Bruns
 * COPYRIGHT:     (c) 2004 Blaupunkt Werke GmbH
 * HISTORY:       
 *                19.04.04 Rev. 1.0 CM-DI/ESA2-Bruns
 *                         Initial Revision;
 *****************************************************************************/



//-----------------------------------------------------------------------------
// General includes
//-----------------------------------------------------------------------------
#include "FISettings.h"
#include "FINode.h"
#include "FIDependency.h"
#include "FIUtil.h"

// needed for source file recognition
#include "xercesc/dom/DOM.hpp"
using namespace xercesc;
#include "iostream"
using namespace std;

#include "assert.h"              // temporary!



/*****************************************************************************
| function implementation
|-----------------------------------------------------------------------------*/




/*****************************************************************************
 * tclFINode
 *****************************************************************************/
tclFINode::tclFINode(
               DOMElement      *pThisElement,
               string            oThisName,
               tenFINodeType     enThisType,
               string            oThisDefaultValue,
               tclFIVersionRange oThisVersionRange,
               tclFIDocumentation  oThisDescription)
{
   pDOMElement   = pThisElement;
   oName         = oThisName; 
   enType        = enThisType;
   oDefaultValue = oThisDefaultValue;
   oVersionRange = oThisVersionRange;
   oDescription  = oThisDescription;

   iDataSize = FI_NODE_SIZE_NOTCALC;
   if(EN_OBJTYPE_ATOM == enType )
   {
      if ((oName == "tU8") ||
          (oName == "tS8") ||
          (oName == "tBool"))
         iDataSize = 1;
      if ((oName == "tU16") ||
          (oName == "tS16"))
         iDataSize = 2;
      if ((oName == "tU24") ||
          (oName == "tS24"))
         iDataSize = 3;
      if ((oName == "tU32") ||
          (oName == "tS32") ||
          (oName == "tF32"))
         iDataSize = 4;
      if((oName == "tS64") ||
         (oName == "tF64") ||
         (oName == "tU64") ||
         (oName == "tS64"))
         iDataSize = 8;
      if((oName == "tString") ||
         (oName == "tMultiLanguageString"))
         iDataSize = FI_NODE_SIZE_DYNAMIC;    // n.a.
   }
/*
   else if(EN_OBJTYPE_OPCODE == enType)
      iDataSize = 0;
      */
}






tclFINode::~tclFINode()
{
}


void tclFINode::vSetDataSize(int iSize)
{
   iDataSize = iSize;
}



bool tclFINode::bHasVersionInformation()
{
   return (!(oVersionRange.oGetMinVersion().bHasNoLimit() &&
       (oVersionRange.oGetMaxVersion().bHasNoLimit())));
}



string 
tclFINode::oGetNodeTypeString()
{
   string oNodeTypeString = "";
   switch(enType)
   {
      case EN_OBJTYPE_ATOM:            oNodeTypeString = "atom"; break;
      case EN_OBJTYPE_TYPE:            oNodeTypeString = "type"; break;
      case EN_OBJTYPE_ENUMERATION:     oNodeTypeString = "enumeration"; break;
      case EN_OBJTYPE_BITFIELD:        oNodeTypeString = "bitfield"; break;
      case EN_OBJTYPE_STRUCTURE:       oNodeTypeString = "struct"; break;
      case EN_OBJTYPE_MESSAGE_METHOD:  oNodeTypeString = "method"; break;
      case EN_OBJTYPE_MESSAGE_PROPERTY:oNodeTypeString = "property"; break;
      case EN_OBJTYPE_OPCODE:          oNodeTypeString = "opcode"; break;
      case EN_OBJTYPE_ERRORDEF:        oNodeTypeString = "errordef"; break;

      default:
         oNodeTypeString = "UNDEFINED"; 
   }
   return oNodeTypeString;
}




bool tclFINode::bAddDependency(tclFITypeDependency *pNewDependency)
{
   oDependencyList.push_back(pNewDependency);
   // toDO: Add return type check
   return true;
}



bool tclFINode::bAddParentLink(tclFITypeDependency *pNewDependency)
{
   oParentList.push_back(pNewDependency);
   // toDO: Add return type check
   return true;
}



tclFITypeDependency*
tclFINode::poFindDependency(string &oNameOfLink)
{
   tclFITypeDependency *poDepResult = 0;
   tclFITypeDependencyListIterator iter = oDependencyList.begin();
   while(iter != oDependencyList.end())
   {
      if (oNameOfLink == (*iter)->oGetName())
      {
         poDepResult = (*iter);
         break;
      }
      /*
      tclFINode* poReference = (*iter)->poGetTarget();
      if (poReference && (oNameOfLink == poReference->oGetName()))
      {
         poDepResult = (*iter);
         break;
      }
      */
      ++iter;
   }

   return poDepResult;
}




bool tclFINode::bDependsOn(tclFINode *poNode)
{
   bool bSuccess = false;
   tclFITypeDependencyListIterator iter = oDependencyList.begin();
   while(iter != oDependencyList.end())
   {
      tclFINode* poReference = (*iter)->poGetTarget();
      if(poReference && (poReference->oGetName() == poNode->oGetName()))
      {
         bSuccess = true;
         break;
      }
      ++iter;
   }
   return bSuccess;
}

/* moved to FIUtil.cpp
string tclFINode::oGetFileName()
{
   string oRetName = "";
   DOMNode* poNode = poGetDOMElement()->getParentNode();
   while (poNode != NULL)
   {
      cout << "Node Type = " << poNode->getNodeType() << endl;
      if (poNode->getNodeType() == DOMNode::ENTITY_REFERENCE_NODE)
      {
         string oEntityName = X(poNode->getNodeName());
         DOMDocument* poDoc = poNode->getOwnerDocument();
         DOMDocumentType* poDocType = poDoc->getDoctype();
         DOMNamedNodeMap* poEntities = poDocType->getEntities();
         DOMEntity* poEntity = (DOMEntity*)poEntities->getNamedItem(X(oEntityName.c_str()));
         string oFileName = X(poEntity->getSystemId());
         return oFileName;
      }
      if (poNode->getNodeType() == DOMNode::ELEMENT_NODE)
         poNode = (DOMElement*)poNode->getParentNode();
      else
         poNode = 0;
   }
   return oRetName;
}
*/
