/*****************************************************************************
 * FILE:          FIdependency.h
 * SW-COMPONENT:  
 * DESCRIPTION:   
 *                
 * AUTHOR:        CM-DI/ESA2-Bruns
 * COPYRIGHT:     (c) 2004 Blaupunkt Werke GmbH
 * HISTORY:       
 *                19.04.04 Rev. 1.0 CM-DI/ESA2-Bruns
 *                         Initial Revision;
 *****************************************************************************/

#ifndef FI_DEPENDENDY_H
   #define FI_DEPENDENDY_H



 
/*****************************************************************************
| includes of component-internal interfaces, if necessary
| (scope: component-local)
|----------------------------------------------------------------------------*/
#include "FISettings.h"
#include "DLLMain.h"
#include "FIVersion.h"
#include "FIDocumentation.h"

#include <vector>
#include <list>

#include <string>

using namespace std;



/*****************************************************************************
| typedefs (scope: global)
|----------------------------------------------------------------------------*/
// FORWARDS
enum tenFIDependencyClass{
   EN_DEPENDENCY_CLASS_UNDEFINED,
   EN_DEPENDENCY_CLASS_DERIVED,
   EN_DEPENDENCY_CLASS_BITFIELD,
   EN_DEPENDENCY_CLASS_ENUMERATION,
   EN_DEPENDENCY_CLASS_ERRORDEF,
   EN_DEPENDENCY_CLASS_FIELD,
   EN_DEPENDENCY_CLASS_LIST,
   EN_DEPENDENCY_CLASS_UNION,
   EN_DEPENDENCY_CLASS_PARAM,
   EN_DEPENDENCY_CLASS_OPCODE,
};


class tclFINode;;




/*****************************************************************************
| function prototypes (scope: global)
|----------------------------------------------------------------------------*/
class FIOBJECTTREEDLL_API tclFITypeDependency
{
   string                  oName;
   tenFIDependencyClass    enClass;
   string                  oDefaultValue;
   string                  oFallbackValue;
   tclFIVersionRange       oVersionRange;
   tclFINode               *poTarget;
   tclFIDocumentation        oDescription;


public:
                           tclFITypeDependency(
                                 string               oName,
                                 tenFIDependencyClass enClass,
                                 string               oDefaultValue,
                                 string               oFallbackValue,
                                 tclFIVersionRange    oVersionRange,
                                 tclFINode            *poTarget,
                                 tclFIDocumentation     &oDescription);

                          ~tclFITypeDependency();
   // Standard-API
   bool                    bIsValid();

   // Dependency Specific API
   const string&           oGetName()            { return oName;              }
   tenFIDependencyClass    enGetClass()          { return enClass;            }
   string                  oGetDefaultValue()    { return oDefaultValue;      }
   string                  oGetFallbackValue()   { return oFallbackValue;     }
   tclFIVersionRange      *poGetVersionRange()   { return &oVersionRange;     }
   tclFINode              *poGetTarget()         { return poTarget;           }
   tclFIDocumentation     *poGetDescription()    { return &oDescription;      }
   bool                    bHasVersionInformation();
   string                  oGetDependencyClassString();

};




typedef vector<tclFITypeDependency*>            _tclFITypeDependencyList;
typedef _tclFITypeDependencyList::const_iterator tclFITypeDependencyListIterator;
class tclFITypeDependencyList : public _tclFITypeDependencyList
{
public:
                           tclFITypeDependencyList();
                          ~tclFITypeDependencyList();
   // Standard-API
};



#endif   // FI_DEPENDENDY_H
