/*****************************************************************************
 * FILE:          FICodeGenMostExt.cpp
 * SW-COMPONENT:  
 * DESCRIPTION:   Generation of additional, MOST-compatible data types for use with
 *                FI code generator based on c++ fi tooling
 *                
 * AUTHOR:        CM-AI/PJ-GM54  Koch, Martin
 * COPYRIGHT:     (c) 2010 Robert Bosch Car Multimedia GmbH
 * HISTORY:       
 *                09.03.10 Rev. 1.0  CM-AI/PJ-GM54  Koch, Martin
 *                         Initial Version;
 *****************************************************************************/

bool bUseNonStandardOpcodeId(string oOpcode, int& iOpcodeId);
bool bUseNonStandardTypeMethods(tclFINode *poType, ostream &out);
bool bNeedsDestroyExt(tclFINode* poType);
bool bIsStandardErrorMessageExt(tclFINode* poType);


bool bGenerateExtendedTypeClass (tclFINode *poType, ostream &out, tclFIServiceTree* poServiceTree, bool& bNeedsDestroy, bool& bSuccess);
bool bGenerateExtendedTypeMembers (tclFINode* poType, ostream &out, string oPrefix);
bool bGenerateExtendedTypeCopyConstructor (tclFINode *poType, ostream &out, string oPrefix);
bool bGenerateExtendedTypeAssignmentOp (tclFINode *poType, ostream &out, string oPrefix);
bool bGenerateExtendedTypeGetSizeMethod (tclFINode* poType, ostream &out, tclFIServiceTree* poServiceTree);
bool bGenerateExtendedTypeCompareMethod (tclFINode* poType, ostream &out, string oPrefix);
bool bGenerateExtendedTypeReadMethod (tclFINode *poType, ostream &out, string oPrefix);
bool bGenerateExtendedTypeWriteMethod (tclFINode* poType, ostream &out, string oPrefix);
bool bGenerateExtendedTypeDestructor (tclFINode *poType, ostream &out, string oPrefix);
bool bGenerateExtendedDestroyMethod (tclFINode *poType, ostream &out, string oPrefix);

bool bGenerateExtendedDefaultErrorMessageDecl (ostream &out, tclFIServiceTree* poServiceTree);
bool bGenerateExtendedDefaultErrorMessageImp (ostream &out, tclFIServiceTree* poServiceTree);



