
#include "FIServiceGroup.h"
#include "FICodeGenUtil.h"
#include "FICodeGenCmdLine.h"

#include "FiCodeGenMostExt.h"

// provide default implementation for all functions called by FICodeGenMain.cpp 
// causing code generation to use standard if no extensions are enabled.

bool bUseNonStandardTypeMethods(tclFINode *poType, ostream &out)
{
   switch (enGeneratorExtension)
   {
      case EXTENSION_MOST:
         return b_MOST_UseNonStandardTypeMethods(poType, out);
      default:
         return false;
   }
}

bool bUseNonStandardOpcodeId(string oOpcode, int& iOpcodeId)
{
   switch (enGeneratorExtension)
   {
      case EXTENSION_MOST:
         return b_MOST_UseNonStandardOpcodeId (oOpcode, iOpcodeId);
      default:
         return false;
   }
}

bool bGenerateExtendedTypeClass (tclFINode *poType, ostream &out, tclFIServiceTree* poServiceTree, bool& bNeedsDestroy, bool& bSuccess)
{
   switch (enGeneratorExtension)
   {
      case EXTENSION_MOST:
         return b_MOST_GenerateTypeClass (poType, out, poServiceTree, bNeedsDestroy, bSuccess);
      default:
         return false;
   }
}

bool bGenerateExtendedTypeCopyConstructor (tclFINode *poType, ostream &out,string oPrefix)
{
   switch (enGeneratorExtension)
   {
      case EXTENSION_MOST:
         return b_MOST_GenerateTypeCopyConstructor (poType, out, oPrefix)  ;
      default:
         return false;
   }
}


bool bGenerateExtendedTypeAssignmentOp (tclFINode *poType, ostream &out,string oPrefix)
{
   switch (enGeneratorExtension)
   {
      case EXTENSION_MOST:
         return b_MOST_GenerateTypeAssignmentOp (poType, out, oPrefix);
      default:
         return false;
   }
}


bool bGenerateExtendedTypeGetSizeMethod (tclFINode* poType, ostream &out,tclFIServiceTree* poServiceTree)
{
   switch (enGeneratorExtension)
   {
      case EXTENSION_MOST:
         return b_MOST_GenerateTypeGetSizeMethod (poType, out, poServiceTree);
      default:
         return false;
   }
}


bool bGenerateExtendedTypeCompareMethod (tclFINode* poType, ostream &out,string oPrefix)
{
   switch (enGeneratorExtension)
   {
      case EXTENSION_MOST:
         return b_MOST_GenerateTypeCompareMethod (poType, out, oPrefix);
      default:
         return false;
   }
}


bool bGenerateExtendedTypeReadMethod (tclFINode *poType, ostream &out,string oPrefix)
{
   switch (enGeneratorExtension)
   {
      case EXTENSION_MOST:
         return b_MOST_GenerateTypeReadMethod (poType, out, oPrefix);
      default:
         return false;
   }
}


bool bGenerateExtendedTypeWriteMethod (tclFINode* poType, ostream &out,string oPrefix)
{
   switch (enGeneratorExtension)
   {
      case EXTENSION_MOST:
         return b_MOST_GenerateTypeWriteMethod (poType, out, oPrefix);
      default:
         return false;
   }
}


bool bGenerateExtendedTypeMembers (tclFINode* poType, ostream &out,string oPrefix)
{
   switch (enGeneratorExtension)
   {
      case EXTENSION_MOST:
         return b_MOST_GenerateTypeMembers (poType, out, oPrefix);
      default:
         return false;
   }
}



bool bNeedsDestroyExt(tclFINode* poType)
{
   switch (enGeneratorExtension)
   {
      case EXTENSION_MOST:
         return b_MOST_NeedsDestroy(poType);
      default:
         return false;
   }
}


bool bIsStandardErrorMessageExt(tclFINode* poType)
{
   if (poType->enGetType() != EN_OBJTYPE_OPCODE)
      return false;
//   if (poMsgNode->oGetName().find(".Error") == string::npos)
   string oTypeName = poType->oGetName();
   if (oTypeName.find(".Error") == string::npos)
      return false;

   switch (enGeneratorExtension)
   {
      case EXTENSION_MOST:
         return b_MOST_IsStandardErrorMessage(poType);
      default:
      {
         tclFITypeDependencyList* poDepList = poType->poGetDependencyList();
         if (poDepList->size() != 1)
            return false;

         return ((*poDepList->begin())->oGetName() == "u16ErrorCode");
      }
   }
}


bool bGenerateExtendedTypeDestructor( tclFINode *poType, ostream &out, string oPrefix )
{
   switch (enGeneratorExtension)
   {
      case EXTENSION_MOST:
         return b_MOST_GenerateTypeDestructor (poType, out,  oPrefix);
      default:
         return false;
   }
}


bool bGenerateExtendedDestroyMethod( tclFINode *poType, ostream &out, string oPrefix )
{
   switch ( enGeneratorExtension )
   {
   case EXTENSION_MOST:
      return b_MOST_GenerateDestroyMethod( poType, out, oPrefix );
   default:
      return false;
   }
}

bool bGenerateExtendedDefaultErrorMessageDecl (ostream &out, tclFIServiceTree* poServiceTree)
{
   switch (enGeneratorExtension)
   {
      case EXTENSION_MOST:
         return b_MOST_GenerateDefaultErrorMessageDecl(out, poServiceTree, false);
      default:
         return false;
   }
}

bool bGenerateExtendedDefaultErrorMessageImp (ostream &out, tclFIServiceTree* poServiceTree)
{
   switch (enGeneratorExtension)
   {
      case EXTENSION_MOST:
         return b_MOST_GenerateDefaultErrorMessage(out, poServiceTree, true);
      default:
         return false;
   }
}
