/* Utitlity functions for name handling */

#include <string>
using namespace std;

#include "FISettings.h"
#include "FINode.h"
#include "FICodeGenUtil.h"

extern bool                bMixedCaseTokens;

const string oToUpper(string oName)
{
   for (unsigned int idx = 0; idx < oName.size(); ++idx)
      oName[idx] = toupper(oName[idx]);
   return oName;
}

const string oToLower(string oName)
{
   for (unsigned int idx = 0; idx < oName.size(); ++idx)
      oName[idx] = tolower(oName[idx]);
   return oName;
}

const string oRemove(const string& oName,const char& oChar)
{
   string oTmp = "";
   for (unsigned int idx = 0; idx < oName.size(); ++idx)
      if (oName[idx] != oChar)
         oTmp += oName[idx];
   return oTmp;
}

   const string oGetEnumName(const string& oName)
{
   return "FI_EN_" + oToUpper(oName);
}

const string oGetClassName(const string& oName)
{
   if (oName == "tString")
      return oGetFIGroup() + "fi_tclString";
   if (oName == "tMultiLanguageString")
      return oGetFIGroup() + "fi_tclMultiLanguageString";
   if (oName[0] == FI_SCHEMA_TYPE_ATTR_SIMPLETYPEPREFIX)
      return oName;
   else
      if (oName.find(CG_MSGTYPE_PREFIX) == 0)
         return CG_CLASS_PREFIX + oName.substr(1);
      else
         return oGetFIGroup() + CG_CLASS_PREFIX + oName.substr(1);
}

const string oGetClassName(const string& oName, bool bIsListType)
{
   string oTypeName = oGetClassName(oName);
   if (bIsListType)
   {
      return CG_DATAFIELD_STRUCT_LIST_1 + oTypeName + CG_DATAFIELD_STRUCT_LIST_2 +
         oTypeName + CG_DATAFIELD_STRUCT_LIST_3;
   }
   else
      return oTypeName;
}

extern string goFIPrefix;
extern string goFIGroup;

const string oGetFIPrefix()
{
   return goFIPrefix;
}

const string oGetFIGroup()
{
   return goFIGroup;
}

const string oGetDataFieldName(const string& oTypeName)
{
   if (oTypeName[0] == FI_SCHEMA_TYPE_ATTR_SIMPLETYPEPREFIX)
   {
      if (oTypeName == "tBool")
         return "bValue";
      if ((oTypeName.length() > 6) && (oTypeName.substr(oTypeName.length() - 6) == "String"))
         return "szValue";
      return string(static_cast<char>(tolower(oTypeName[1])) + 
         oTypeName.substr(2) + "Value");
   }
   return "";
}

const string oGetDataFieldName(tclFINode* poType)
{
   if (poType->poGetDependencyList()->size() > 0)
   {
      if (poType->enGetType() == EN_OBJTYPE_ENUMERATION)
      {
#pragma message("Should be changed into \"enValue\"!")
         return "enType"; 
      }
      else
      {
         tclFINode* poBaseType = (*poType->poGetDependencyList()->begin())->poGetTarget();
         if (poBaseType->enGetType() == EN_OBJTYPE_ATOM)
         {
            return oGetDataFieldName(poBaseType->oGetName());
         }
         else
            return oGetClassName(poBaseType->oGetName());
      }
   }
   else
   {
      if (poType->enGetType() == EN_OBJTYPE_ATOM)
      {
         if (poType->oGetName() == "tBool")
            return "bValue";
         if (poType->oGetName() == "tString")
            return "szValue";
         return string(static_cast<char>(tolower(poType->oGetName()[1])) + 
            poType->oGetName().substr(2) + "Value");
      }
      else
      {
         return "";
      }
   }
}

const string oGetTokenName(const string& oTypeName)
{
   string oTokenName = bMixedCaseTokens ? oTypeName : oToUpper(oTypeName);
   if (oTypeName.find("Msg_") == 0)
      return /*oGetFIGroup() + oGetFIPrefix() +*/ "_tclToken::EN_" + oTokenName;
   if (oTypeName[0] == 't')
      return /*oGetFIGroup() + oGetFIPrefix() +*/ "_tclToken::EN_" + oTokenName.substr(1);
   else
      return /*oGetFIGroup() + oGetFIPrefix() +*/ "_tclToken::EN_" + oTokenName.substr(2);
}

const string oGetSemanticName(const string& oTypeName)
{
   return /*oGetFIGroup() + oGetFIPrefix() +*/ "_tclSemanticDomain::EN_"
      + (bMixedCaseTokens ? oTypeName : oToUpper(oTypeName));
}

bool bIsBinContainerType(const string& corfTypeName)
{
   return (corfTypeName.size() > (strlen(CG_BINCONTAINERNAME)+2)) && 
          (corfTypeName.substr(0,2) == "T_") &&
          (oToLower(corfTypeName.substr(corfTypeName.size() - strlen(CG_BINCONTAINERNAME)))
           == 
           oToLower(string(CG_BINCONTAINERNAME))
          );
}
