/************************************************************************

 *FILE:           fivisitoramtmsg.h

 *SW-COMPONENT:   fi, Functional Interface Framework

 *DESCRIPTION:    Interface for the AMT visitor message and the data type

 *AUTHOR:         Jochen Bruns (CM-DI/ENS41)

 *COPYRIGHT:      (c) 2001 Blaupunkt GmbH

 *HISTORY: $Log:   //hi230124/projects/Vasco/swnavi/archives/components/fi/msgfw/fivisitoramtmsg.h-arc  $
 *
 *    Rev 1.2   Apr 27 2004 11:24:22   bnj2hi
 * Update to MultiVersionFI.
 *
 *    Rev 1.1   May 14 2002 18:57:04   bnj2hi
 * New message s32GetData().
 *
 *    Rev 1.0   Apr 23 2002 17:20:10   bnj2hi
 * Initial revision.

 ************************************************************************/

#ifndef __FIVISITORAMTMSG_H__
#define __FIVISITORAMTMSG_H__

//-- special data class to access directly the message data region without
//-- an additional data copy
class fi_tclVisitorData : public amt_tclMappableType
{
public:
   //-- constructor
   fi_tclVisitorData():u32SizeOfData(0) {};
   /* start of new methods */
   tVoid vSetDataSize(tU32 u32Size) {u32SizeOfData = u32Size;}
   virtual tU32 u32GetSizeOfType () const;
   tU32 u32Link(const amt_tclServiceData& rfoMsg);
   /* end of new methods */
   tU8* pu8GetDataPointer(const amt_tclMappableMessage* const prMMsg) const;
private:
   tU32 u32SizeOfData;
};

//-- special message class to handle amt messages with direct access to the
//-- data region without an additional data copy
class fi_tclVisitorMessage : public amt_tclServiceData
{
public:
   //-- constructor for creating a sendmessage
   fi_tclVisitorMessage(tU32 u32MsgSize);
// #pragma message("default major version for VisitorMessage!")
   fi_tclVisitorMessage(const fi_tclTypeBase& oFIData, tU16 u16MajorVersion FI_DEFAULT_VERSION);

   //-- constructor for initializing a received message
   fi_tclVisitorMessage(amt_tclBaseMessage * poBaseMsg);

   //-- get a single nafi type object
   tS32 s32GetData(fi_tclTypeBase& oFIData, tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   //-- access to message data
   tU8* pu8GetDataPointer() const;

   //-- message data size
   tU32 u32GetDataSize() const;

private:
   fi_tclVisitorData oData;
   tBool bMsgValid;
   fi_tclVisitorMessage(); //lint !e1704 default constructor is not allowed!
};
// #endif
#endif


