#include "precompiled.hh"

tBool operator ==(const tS24& corfS24_1, const tS24& corfS24_2)
{ 
   return corfS24_1.s24Value == corfS24_2.s24Value; 
}

tBool operator ==(const tU24& corfU24_1, const tU24& corfU24_2)
{
   return corfU24_1.u24Value == corfU24_2.u24Value; 
}

tU24::tU24(const tS24& oS24)
{
   u24Value = (tU32)oS24.s24Value;
}

tS24::tS24(const tU24& oU24)
{
   s24Value = (tS32)oU24.u24Value;
}

#ifndef FI_S_FAST_WRITING
fi_tclOutContext& operator<<(fi_tclOutContext& oOutContext, 
			     const fi_tclTypeBase& oTypeBase) 
{
  return oTypeBase.oWrite(oOutContext);
}

fi_tclInContext& operator>>(fi_tclInContext& oInContext, 
			    fi_tclTypeBase& oTypeBase) 
{
  return oTypeBase.oRead(oInContext);
}
#endif

tBool fi_tclTypeBase::bClone(const fi_tclTypeBase& corfoInit, tU16 u16MajorVersion)
{
   tBool bSuccess = false;
   // the following check is temporarily disabled due to incompatibilities (24.03.09)
   // if (this->s32GetTypeId() == corfoInit.s32GetTypeId())
   {
      tU32 u32ObjSize = corfoInit.u32GetSize(u16MajorVersion);
      tU8* pu8Buf = OSAL_NEW tU8[u32ObjSize];
      if (pu8Buf)
      {
         fi_tclOutContext oOut(pu8Buf,pu8Buf + u32ObjSize,u16MajorVersion);
         oOut << corfoInit;
         if (oOut.bIsValid())
         {
            // the following is temporarily disabled due to incompatibilities (24.03.09)
            // vDestroy();
            fi_tclInContext oIn(pu8Buf, pu8Buf + u32ObjSize,u16MajorVersion);
            oIn >> *this;
            bSuccess = oIn.bIsValid();
            if (!bSuccess)
            {
               vDestroy();
            }
         }
         OSAL_DELETE[] pu8Buf;
      }
   }
   return bSuccess;
}

tU32 FI_u32StringLength(tCString coszValue)
{
   if (coszValue == OSAL_NULL)
   {
      return 0;
   }
   else
   {
#ifdef FI_S_UTFMODE_TRANSPARENT
      return OSAL_u32StringLength(coszValue);
#else
      return utfutil_SizeOfUTF8(coszValue);
#endif
   }
}

