#ifndef FISTACK_HEADER
#define FISTACK_HEADER

// #include <iostream>
// using namespace std;
// #include "fitoken.h"

// --Wenn die STL vorraetig ist, dann sollte dieses hier geaendert werden !!!
class MY_DECL fi_tclKnot {
public:

   fi_tclToken::tenType enToken;
   fi_tclSemanticDomain::tenType enSemanticDomain;
   tU32 u32Index; // --Index in der Liste bzw. OSAL_C_U32_MAX

   // --Konstruktoren
   fi_tclKnot():enToken(fi_tclToken::EN_UNKNOWN),
      enSemanticDomain(fi_tclSemanticDomain::EN_UNKNOWN),
      u32Index(OSAL_C_U32_MAX) {}
   fi_tclKnot(fi_tclToken::tenType enType,
      fi_tclSemanticDomain::tenType enSDomain, tU32 u32i =OSAL_C_U32_MAX):
   enToken(enType),enSemanticDomain(enSDomain),u32Index(u32i) {}
};

template <class TKnot> 
class MY_DECL fi_tclTraversePath {
 public:

    // --Konstruktor
    fi_tclTraversePath();

    class MY_DECL tclIterator {
    public:

       tclIterator():u32Index(0),poPointTo(0) {}

       TKnot oKnot() {
          return poPointTo->oStack[u32Index];
       }

       /*
       fi_tclToken::tenType enToken() {
          return poPointTo->oStack[u32Index].enToken;
       }

       fi_tclSemanticDomain::tenType enSemanticDomain() {
          return poPointTo->oStack[u32Index].enSemanticDomain;
       }

       tU32 u32ListIndex() {
          return poPointTo->oStack[u32Index].u32Index;
       }
       */

       tclIterator oUpper() const { return tclIterator(poPointTo,u32Index-1); }

       tU32 u32Position() const { return u32Index; }

       tVoid vDump() const { poPointTo->vDump(); }

    private:
       tU32 u32Index;
       fi_tclTraversePath* poPointTo;

       tclIterator(fi_tclTraversePath* poPath, tU32 u32i):
       u32Index(u32i),poPointTo(poPath) {} //lint !e1704 construction allowed only from outer class fi_tclTraversePath!

       friend class fi_tclTraversePath<TKnot>;
    };


    tBool bGoDown(TKnot/*tclKnot*/ oKnot); // --push
    tBool bGoUp(TKnot/*tclKnot*/& oKnot); // --pop
    tBool bGoUp();
    // tBool bGoRightSibling(fi_tclSemanticDomain::tenType enType);

    //koennte auch fr ARM uebernommen werden (Teil 1)
    tclIterator oGetIterator();
 

    tVoid vDump() const {
    /*
    for(tU32 u32i=0;u32i<u32Position;u32i++)
    cout << u32i << " "
	   << oStack[u32i].enToken << " "
      << oStack[u32i].enSemanticDomain << " "
      << oStack[u32i].u32Index << endl;
       */
    }

    tU32 u32Position; // --Position an der das nchste Element eingefgt werden mu.

    protected:
       // --Aufbau eines einfachen Stacks
       //  ATTENTION: make sure that this is enough (static analysis of hierarchy depth of fi)

       enum {EN_STACKSIZE = 50};
       TKnot/*fi_tclKnot*/ oStack[EN_STACKSIZE];

    private:

        friend class tclIterator;
};

template <class TKnot> fi_tclTraversePath<TKnot>::fi_tclTraversePath():u32Position(0) {}

// --Gehe eine Stufe tiefer im Syntaxbaum
template <class TKnot> tBool fi_tclTraversePath<TKnot>::bGoDown(TKnot/*tclKnot*/ oKnot) {
  tBool bReturnValue=FALSE;
  // --Noch Platz auf den Stack?
  if (u32Position<EN_STACKSIZE) {
    oStack[u32Position++]=oKnot;
    bReturnValue=TRUE;
  }
  return bReturnValue;
}

// --Gehe eine Stufe hoeher im Syntaxbaum
template <class TKnot> tBool fi_tclTraversePath<TKnot>::bGoUp(TKnot/*tclKnot*/& oKnot) {
  tBool bReturnValue=FALSE;
  if (u32Position>0) {
    oKnot=oStack[--u32Position];
    bReturnValue=TRUE;
  }
  return bReturnValue;
}

// --dito ohne Elementrueckgabe
template <class TKnot> tBool fi_tclTraversePath<TKnot>::bGoUp() {
  tBool bReturnValue=FALSE;
  if (u32Position>0) {
    u32Position--;
    bReturnValue=TRUE;
  }
  return bReturnValue;
}

// --Liefere einen Iterator
  template <class TKnot> typename fi_tclTraversePath<TKnot>::tclIterator fi_tclTraversePath<TKnot>::oGetIterator() {
  return tclIterator(this,u32Position>0 ? u32Position-1 : EN_STACKSIZE);
}


#endif
