/************************************************************************
 
 *FILE:           navifitypes.h
 
 *SW-COMPONENT:   NaviFI, Navigation Functional Interface
 
 *DESCRIPTION:    Interface fuer NachrichtenStrukturTypdefinitionen des navifi
                  
 *AUTHOR:         Jochen Bruns (CM-DI/ENS41)
 
 *COPYRIGHT:      (c) 2001 Blaupunkt GmbH
 
 *HISTORY:
           (t.b.a)
 * 
 *    Rev 1.0   Oct 7 2001 17:16:00   bnj2hi
 * Initial revision
 *  
 ************************************************************************/

#ifndef WEATHERTUNERFITYPES_HEADER
#define WEATHERTUNERFITYPES_HEADER

// #include <vector>
// 


class weathertunerfi_tclVisitorBase;

/* --NaviFI-MessageStrukturtypen --*/

class weathertunerfi_tclMsgGetMetarDataMethodStart : public fi_tclVisitableTypeBase, public fi_tclMessageBase
{
public:
   virtual tU16 u16GetServiceID() const;
   virtual tU16 u16GetFunctionID() const;
   virtual tU8  u8GetOpCode() const;
   virtual const fi_tclTypeBase& corfoGetTypeBase() const {return *this;};
   virtual fi_tclTypeBase& rfoGetTypeBase() {return *this;};
   weathertunerfi_tclMsgGetMetarDataMethodStart() {}
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   weathertunerfi_tclMsgGetMetarDataMethodStart& operator=(const weathertunerfi_tclMsgGetMetarDataMethodStart& coRef);
   weathertunerfi_tclMsgGetMetarDataMethodStart(const weathertunerfi_tclMsgGetMetarDataMethodStart& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual tBool operator==(const weathertunerfi_tclMsgGetMetarDataMethodStart& rfoCmp) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   virtual tS32 s32GetTypeId() const { return weathertunerfi_tclToken::EN_MSG_GETMETARDATAMETHODSTART;}
};

class weathertunerfi_tclMsgGetMetarDataMethodResult : public fi_tclVisitableTypeBase, public fi_tclMessageBase
{
public:
   virtual tU16 u16GetServiceID() const;
   virtual tU16 u16GetFunctionID() const;
   virtual tU8  u8GetOpCode() const;
   virtual const fi_tclTypeBase& corfoGetTypeBase() const {return *this;};
   virtual fi_tclTypeBase& rfoGetTypeBase() {return *this;};
   weathertunerfi_tclMsgGetMetarDataMethodResult():MetarBlockId(0),GenerationTime() {}
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   weathertunerfi_tclMsgGetMetarDataMethodResult& operator=(const weathertunerfi_tclMsgGetMetarDataMethodResult& coRef);
   weathertunerfi_tclMsgGetMetarDataMethodResult(const weathertunerfi_tclMsgGetMetarDataMethodResult& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
   tU32 MetarBlockId;
   fi_tcl_POSIXTime GenerationTime;
   std::vector<tU8, std::allocator<tU8> > MetarData;

   virtual tVoid vDestroy();
   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual tBool operator==(const weathertunerfi_tclMsgGetMetarDataMethodResult& rfoCmp) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   virtual tS32 s32GetTypeId() const { return weathertunerfi_tclToken::EN_MSG_GETMETARDATAMETHODRESULT;}
};

class weathertunerfi_tclMsgGetMetarDataMethodResultFirst : public fi_tclVisitableTypeBase, public fi_tclMessageBase
{
public:
   virtual tU16 u16GetServiceID() const;
   virtual tU16 u16GetFunctionID() const;
   virtual tU8  u8GetOpCode() const;
   virtual const fi_tclTypeBase& corfoGetTypeBase() const {return *this;};
   virtual fi_tclTypeBase& rfoGetTypeBase() {return *this;};
   weathertunerfi_tclMsgGetMetarDataMethodResultFirst():MetarBlockId(0),GenerationTime() {}
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   weathertunerfi_tclMsgGetMetarDataMethodResultFirst& operator=(const weathertunerfi_tclMsgGetMetarDataMethodResultFirst& coRef);
   weathertunerfi_tclMsgGetMetarDataMethodResultFirst(const weathertunerfi_tclMsgGetMetarDataMethodResultFirst& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
   tU32 MetarBlockId;
   fi_tcl_POSIXTime GenerationTime;

   virtual tVoid vDestroy();
   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual tBool operator==(const weathertunerfi_tclMsgGetMetarDataMethodResultFirst& rfoCmp) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   virtual tS32 s32GetTypeId() const { return weathertunerfi_tclToken::EN_MSG_GETMETARDATAMETHODRESULTFIRST;}
};

class weathertunerfi_tclMsgGetMetarDataMethodResultMiddle : public fi_tclVisitableTypeBase, public fi_tclMessageBase
{
public:
   virtual tU16 u16GetServiceID() const;
   virtual tU16 u16GetFunctionID() const;
   virtual tU8  u8GetOpCode() const;
   virtual const fi_tclTypeBase& corfoGetTypeBase() const {return *this;};
   virtual fi_tclTypeBase& rfoGetTypeBase() {return *this;};
   weathertunerfi_tclMsgGetMetarDataMethodResultMiddle() {}
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   weathertunerfi_tclMsgGetMetarDataMethodResultMiddle& operator=(const weathertunerfi_tclMsgGetMetarDataMethodResultMiddle& coRef);
   weathertunerfi_tclMsgGetMetarDataMethodResultMiddle(const weathertunerfi_tclMsgGetMetarDataMethodResultMiddle& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
   std::vector<tU8, std::allocator<tU8> > MetarData;

   virtual tVoid vDestroy();
   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual tBool operator==(const weathertunerfi_tclMsgGetMetarDataMethodResultMiddle& rfoCmp) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   virtual tS32 s32GetTypeId() const { return weathertunerfi_tclToken::EN_MSG_GETMETARDATAMETHODRESULTMIDDLE;}
};

class weathertunerfi_tclMsgGetMetarDataMethodResultLast : public fi_tclVisitableTypeBase, public fi_tclMessageBase
{
public:
   virtual tU16 u16GetServiceID() const;
   virtual tU16 u16GetFunctionID() const;
   virtual tU8  u8GetOpCode() const;
   virtual const fi_tclTypeBase& corfoGetTypeBase() const {return *this;};
   virtual fi_tclTypeBase& rfoGetTypeBase() {return *this;};
   weathertunerfi_tclMsgGetMetarDataMethodResultLast() {}
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   weathertunerfi_tclMsgGetMetarDataMethodResultLast& operator=(const weathertunerfi_tclMsgGetMetarDataMethodResultLast& coRef);
   weathertunerfi_tclMsgGetMetarDataMethodResultLast(const weathertunerfi_tclMsgGetMetarDataMethodResultLast& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual tBool operator==(const weathertunerfi_tclMsgGetMetarDataMethodResultLast& rfoCmp) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   virtual tS32 s32GetTypeId() const { return weathertunerfi_tclToken::EN_MSG_GETMETARDATAMETHODRESULTLAST;}
};

class weathertunerfi_tclMsgGetCCFDataMethodStart : public fi_tclVisitableTypeBase, public fi_tclMessageBase
{
public:
   virtual tU16 u16GetServiceID() const;
   virtual tU16 u16GetFunctionID() const;
   virtual tU8  u8GetOpCode() const;
   virtual const fi_tclTypeBase& corfoGetTypeBase() const {return *this;};
   virtual fi_tclTypeBase& rfoGetTypeBase() {return *this;};
   weathertunerfi_tclMsgGetCCFDataMethodStart() {}
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   weathertunerfi_tclMsgGetCCFDataMethodStart& operator=(const weathertunerfi_tclMsgGetCCFDataMethodStart& coRef);
   weathertunerfi_tclMsgGetCCFDataMethodStart(const weathertunerfi_tclMsgGetCCFDataMethodStart& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual tBool operator==(const weathertunerfi_tclMsgGetCCFDataMethodStart& rfoCmp) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   virtual tS32 s32GetTypeId() const { return weathertunerfi_tclToken::EN_MSG_GETCCFDATAMETHODSTART;}
};

class weathertunerfi_tclMsgGetCCFDataMethodResult : public fi_tclVisitableTypeBase, public fi_tclMessageBase
{
public:
   virtual tU16 u16GetServiceID() const;
   virtual tU16 u16GetFunctionID() const;
   virtual tU8  u8GetOpCode() const;
   virtual const fi_tclTypeBase& corfoGetTypeBase() const {return *this;};
   virtual fi_tclTypeBase& rfoGetTypeBase() {return *this;};
   weathertunerfi_tclMsgGetCCFDataMethodResult():CCFBlockId(0),GenerationTime() {}
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   weathertunerfi_tclMsgGetCCFDataMethodResult& operator=(const weathertunerfi_tclMsgGetCCFDataMethodResult& coRef);
   weathertunerfi_tclMsgGetCCFDataMethodResult(const weathertunerfi_tclMsgGetCCFDataMethodResult& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
   tU32 CCFBlockId;
   fi_tcl_POSIXTime GenerationTime;
   std::vector<tU8, std::allocator<tU8> > CCFData;

   virtual tVoid vDestroy();
   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual tBool operator==(const weathertunerfi_tclMsgGetCCFDataMethodResult& rfoCmp) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   virtual tS32 s32GetTypeId() const { return weathertunerfi_tclToken::EN_MSG_GETCCFDATAMETHODRESULT;}
};

class weathertunerfi_tclMsgMetarDataChangedGet : public fi_tclVisitableTypeBase, public fi_tclMessageBase
{
public:
   virtual tU16 u16GetServiceID() const;
   virtual tU16 u16GetFunctionID() const;
   virtual tU8  u8GetOpCode() const;
   virtual const fi_tclTypeBase& corfoGetTypeBase() const {return *this;};
   virtual fi_tclTypeBase& rfoGetTypeBase() {return *this;};
   weathertunerfi_tclMsgMetarDataChangedGet() {}
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   weathertunerfi_tclMsgMetarDataChangedGet& operator=(const weathertunerfi_tclMsgMetarDataChangedGet& coRef);
   weathertunerfi_tclMsgMetarDataChangedGet(const weathertunerfi_tclMsgMetarDataChangedGet& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual tBool operator==(const weathertunerfi_tclMsgMetarDataChangedGet& rfoCmp) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   virtual tS32 s32GetTypeId() const { return weathertunerfi_tclToken::EN_MSG_METARDATACHANGEDGET;}
};

class weathertunerfi_tclMsgMetarDataChangedUpReg : public fi_tclVisitableTypeBase, public fi_tclMessageBase
{
public:
   virtual tU16 u16GetServiceID() const;
   virtual tU16 u16GetFunctionID() const;
   virtual tU8  u8GetOpCode() const;
   virtual const fi_tclTypeBase& corfoGetTypeBase() const {return *this;};
   virtual fi_tclTypeBase& rfoGetTypeBase() {return *this;};
   weathertunerfi_tclMsgMetarDataChangedUpReg() {}
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   weathertunerfi_tclMsgMetarDataChangedUpReg& operator=(const weathertunerfi_tclMsgMetarDataChangedUpReg& coRef);
   weathertunerfi_tclMsgMetarDataChangedUpReg(const weathertunerfi_tclMsgMetarDataChangedUpReg& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual tBool operator==(const weathertunerfi_tclMsgMetarDataChangedUpReg& rfoCmp) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   virtual tS32 s32GetTypeId() const { return weathertunerfi_tclToken::EN_MSG_METARDATACHANGEDUPREG;}
};

class weathertunerfi_tclMsgMetarDataChangedRelUpReg : public fi_tclVisitableTypeBase, public fi_tclMessageBase
{
public:
   virtual tU16 u16GetServiceID() const;
   virtual tU16 u16GetFunctionID() const;
   virtual tU8  u8GetOpCode() const;
   virtual const fi_tclTypeBase& corfoGetTypeBase() const {return *this;};
   virtual fi_tclTypeBase& rfoGetTypeBase() {return *this;};
   weathertunerfi_tclMsgMetarDataChangedRelUpReg() {}
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   weathertunerfi_tclMsgMetarDataChangedRelUpReg& operator=(const weathertunerfi_tclMsgMetarDataChangedRelUpReg& coRef);
   weathertunerfi_tclMsgMetarDataChangedRelUpReg(const weathertunerfi_tclMsgMetarDataChangedRelUpReg& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual tBool operator==(const weathertunerfi_tclMsgMetarDataChangedRelUpReg& rfoCmp) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   virtual tS32 s32GetTypeId() const { return weathertunerfi_tclToken::EN_MSG_METARDATACHANGEDRELUPREG;}
};

class weathertunerfi_tclMsgMetarDataChangedStatus : public fi_tclVisitableTypeBase, public fi_tclMessageBase
{
public:
   virtual tU16 u16GetServiceID() const;
   virtual tU16 u16GetFunctionID() const;
   virtual tU8  u8GetOpCode() const;
   virtual const fi_tclTypeBase& corfoGetTypeBase() const {return *this;};
   virtual fi_tclTypeBase& rfoGetTypeBase() {return *this;};
   weathertunerfi_tclMsgMetarDataChangedStatus():MetarBlockId(0) {}
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   weathertunerfi_tclMsgMetarDataChangedStatus& operator=(const weathertunerfi_tclMsgMetarDataChangedStatus& coRef);
   weathertunerfi_tclMsgMetarDataChangedStatus(const weathertunerfi_tclMsgMetarDataChangedStatus& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
   tU32 MetarBlockId;

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual tBool operator==(const weathertunerfi_tclMsgMetarDataChangedStatus& rfoCmp) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   virtual tS32 s32GetTypeId() const { return weathertunerfi_tclToken::EN_MSG_METARDATACHANGEDSTATUS;}
};

class weathertunerfi_tclMsgCCFDataChangedGet : public fi_tclVisitableTypeBase, public fi_tclMessageBase
{
public:
   virtual tU16 u16GetServiceID() const;
   virtual tU16 u16GetFunctionID() const;
   virtual tU8  u8GetOpCode() const;
   virtual const fi_tclTypeBase& corfoGetTypeBase() const {return *this;};
   virtual fi_tclTypeBase& rfoGetTypeBase() {return *this;};
   weathertunerfi_tclMsgCCFDataChangedGet() {}
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   weathertunerfi_tclMsgCCFDataChangedGet& operator=(const weathertunerfi_tclMsgCCFDataChangedGet& coRef);
   weathertunerfi_tclMsgCCFDataChangedGet(const weathertunerfi_tclMsgCCFDataChangedGet& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual tBool operator==(const weathertunerfi_tclMsgCCFDataChangedGet& rfoCmp) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   virtual tS32 s32GetTypeId() const { return weathertunerfi_tclToken::EN_MSG_CCFDATACHANGEDGET;}
};

class weathertunerfi_tclMsgCCFDataChangedUpReg : public fi_tclVisitableTypeBase, public fi_tclMessageBase
{
public:
   virtual tU16 u16GetServiceID() const;
   virtual tU16 u16GetFunctionID() const;
   virtual tU8  u8GetOpCode() const;
   virtual const fi_tclTypeBase& corfoGetTypeBase() const {return *this;};
   virtual fi_tclTypeBase& rfoGetTypeBase() {return *this;};
   weathertunerfi_tclMsgCCFDataChangedUpReg() {}
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   weathertunerfi_tclMsgCCFDataChangedUpReg& operator=(const weathertunerfi_tclMsgCCFDataChangedUpReg& coRef);
   weathertunerfi_tclMsgCCFDataChangedUpReg(const weathertunerfi_tclMsgCCFDataChangedUpReg& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual tBool operator==(const weathertunerfi_tclMsgCCFDataChangedUpReg& rfoCmp) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   virtual tS32 s32GetTypeId() const { return weathertunerfi_tclToken::EN_MSG_CCFDATACHANGEDUPREG;}
};

class weathertunerfi_tclMsgCCFDataChangedRelUpReg : public fi_tclVisitableTypeBase, public fi_tclMessageBase
{
public:
   virtual tU16 u16GetServiceID() const;
   virtual tU16 u16GetFunctionID() const;
   virtual tU8  u8GetOpCode() const;
   virtual const fi_tclTypeBase& corfoGetTypeBase() const {return *this;};
   virtual fi_tclTypeBase& rfoGetTypeBase() {return *this;};
   weathertunerfi_tclMsgCCFDataChangedRelUpReg() {}
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   weathertunerfi_tclMsgCCFDataChangedRelUpReg& operator=(const weathertunerfi_tclMsgCCFDataChangedRelUpReg& coRef);
   weathertunerfi_tclMsgCCFDataChangedRelUpReg(const weathertunerfi_tclMsgCCFDataChangedRelUpReg& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual tBool operator==(const weathertunerfi_tclMsgCCFDataChangedRelUpReg& rfoCmp) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   virtual tS32 s32GetTypeId() const { return weathertunerfi_tclToken::EN_MSG_CCFDATACHANGEDRELUPREG;}
};

class weathertunerfi_tclMsgCCFDataChangedStatus : public fi_tclVisitableTypeBase, public fi_tclMessageBase
{
public:
   virtual tU16 u16GetServiceID() const;
   virtual tU16 u16GetFunctionID() const;
   virtual tU8  u8GetOpCode() const;
   virtual const fi_tclTypeBase& corfoGetTypeBase() const {return *this;};
   virtual fi_tclTypeBase& rfoGetTypeBase() {return *this;};
   weathertunerfi_tclMsgCCFDataChangedStatus():CCFBlockId(0) {}
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   weathertunerfi_tclMsgCCFDataChangedStatus& operator=(const weathertunerfi_tclMsgCCFDataChangedStatus& coRef);
   weathertunerfi_tclMsgCCFDataChangedStatus(const weathertunerfi_tclMsgCCFDataChangedStatus& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
   tU32 CCFBlockId;

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual tBool operator==(const weathertunerfi_tclMsgCCFDataChangedStatus& rfoCmp) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   virtual tS32 s32GetTypeId() const { return weathertunerfi_tclToken::EN_MSG_CCFDATACHANGEDSTATUS;}
};

class weathertunerfi_tclMsgCountyWarningDataChangedGet : public fi_tclVisitableTypeBase, public fi_tclMessageBase
{
public:
   virtual tU16 u16GetServiceID() const;
   virtual tU16 u16GetFunctionID() const;
   virtual tU8  u8GetOpCode() const;
   virtual const fi_tclTypeBase& corfoGetTypeBase() const {return *this;};
   virtual fi_tclTypeBase& rfoGetTypeBase() {return *this;};
   weathertunerfi_tclMsgCountyWarningDataChangedGet() {}
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   weathertunerfi_tclMsgCountyWarningDataChangedGet& operator=(const weathertunerfi_tclMsgCountyWarningDataChangedGet& coRef);
   weathertunerfi_tclMsgCountyWarningDataChangedGet(const weathertunerfi_tclMsgCountyWarningDataChangedGet& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual tBool operator==(const weathertunerfi_tclMsgCountyWarningDataChangedGet& rfoCmp) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   virtual tS32 s32GetTypeId() const { return weathertunerfi_tclToken::EN_MSG_COUNTYWARNINGDATACHANGEDGET;}
};

class weathertunerfi_tclMsgCountyWarningDataChangedUpReg : public fi_tclVisitableTypeBase, public fi_tclMessageBase
{
public:
   virtual tU16 u16GetServiceID() const;
   virtual tU16 u16GetFunctionID() const;
   virtual tU8  u8GetOpCode() const;
   virtual const fi_tclTypeBase& corfoGetTypeBase() const {return *this;};
   virtual fi_tclTypeBase& rfoGetTypeBase() {return *this;};
   weathertunerfi_tclMsgCountyWarningDataChangedUpReg() {}
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   weathertunerfi_tclMsgCountyWarningDataChangedUpReg& operator=(const weathertunerfi_tclMsgCountyWarningDataChangedUpReg& coRef);
   weathertunerfi_tclMsgCountyWarningDataChangedUpReg(const weathertunerfi_tclMsgCountyWarningDataChangedUpReg& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual tBool operator==(const weathertunerfi_tclMsgCountyWarningDataChangedUpReg& rfoCmp) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   virtual tS32 s32GetTypeId() const { return weathertunerfi_tclToken::EN_MSG_COUNTYWARNINGDATACHANGEDUPREG;}
};

class weathertunerfi_tclMsgCountyWarningDataChangedRelUpReg : public fi_tclVisitableTypeBase, public fi_tclMessageBase
{
public:
   virtual tU16 u16GetServiceID() const;
   virtual tU16 u16GetFunctionID() const;
   virtual tU8  u8GetOpCode() const;
   virtual const fi_tclTypeBase& corfoGetTypeBase() const {return *this;};
   virtual fi_tclTypeBase& rfoGetTypeBase() {return *this;};
   weathertunerfi_tclMsgCountyWarningDataChangedRelUpReg() {}
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   weathertunerfi_tclMsgCountyWarningDataChangedRelUpReg& operator=(const weathertunerfi_tclMsgCountyWarningDataChangedRelUpReg& coRef);
   weathertunerfi_tclMsgCountyWarningDataChangedRelUpReg(const weathertunerfi_tclMsgCountyWarningDataChangedRelUpReg& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual tBool operator==(const weathertunerfi_tclMsgCountyWarningDataChangedRelUpReg& rfoCmp) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   virtual tS32 s32GetTypeId() const { return weathertunerfi_tclToken::EN_MSG_COUNTYWARNINGDATACHANGEDRELUPREG;}
};

class weathertunerfi_tclMsgCountyWarningDataChangedStatus : public fi_tclVisitableTypeBase, public fi_tclMessageBase
{
public:
   virtual tU16 u16GetServiceID() const;
   virtual tU16 u16GetFunctionID() const;
   virtual tU8  u8GetOpCode() const;
   virtual const fi_tclTypeBase& corfoGetTypeBase() const {return *this;};
   virtual fi_tclTypeBase& rfoGetTypeBase() {return *this;};
   weathertunerfi_tclMsgCountyWarningDataChangedStatus():CountyWarningBlockId(0),GenerationTime() {}
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   weathertunerfi_tclMsgCountyWarningDataChangedStatus& operator=(const weathertunerfi_tclMsgCountyWarningDataChangedStatus& coRef);
   weathertunerfi_tclMsgCountyWarningDataChangedStatus(const weathertunerfi_tclMsgCountyWarningDataChangedStatus& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
   tU32 CountyWarningBlockId;
   fi_tcl_POSIXTime GenerationTime;
   std::vector<tU8, std::allocator<tU8> > CountyWarningData;

   virtual tVoid vDestroy();
   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual tBool operator==(const weathertunerfi_tclMsgCountyWarningDataChangedStatus& rfoCmp) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   virtual tS32 s32GetTypeId() const { return weathertunerfi_tclToken::EN_MSG_COUNTYWARNINGDATACHANGEDSTATUS;}
};


#endif
