#ifndef WEATHERTUNERFILANGUAGE_HEADER
#define WEATHERTUNERFILANGUAGE_HEADER

class weathertunerfi_tclInContext;
class weathertunerfi_tclOutContext;
class weathertunerfi_tclVisitorBase;

class MY_DECL weathertunerfi_tclDescription {
 public:
  enum tenType { EN_PARSING, EN_GENERATING };	
  
  weathertunerfi_tclDescription(fi_tclInContext* poIn, weathertunerfi_tclVisitorBase* poVisit);
  weathertunerfi_tclDescription(fi_tclOutContext* poOut, weathertunerfi_tclVisitorBase* poVisit);
  
  /* --Hier kommen nun die Methoden, die einzelne Nachrichten entspr. NaFI 
		erzeugen (EN_GENERATING) bzw. einlesen (EN_PARSING). */

  tBool bInitMessage(weathertunerfi_tclToken::tenType enMsgToken);
  tBool bProcessMessage();

  // tBool bProcessElement(); 

  tBool bDoIt(fi_tclVisitableTypeBase& poBaseType);
#ifndef FI_S_EXTERNAL_FI
  void vEnableSpecialBinContainer() { bUseSpecialBinContainer = true; }
#endif

 private:
  /* default constructor */ weathertunerfi_tclDescription();  //lint !e1704 // always use parameters
  tenType enType; //--read or write?

  union {
    fi_tclInContext* poInContext;
    fi_tclOutContext* poOutContext;
  };

  weathertunerfi_tclVisitorBase* poVisitor;

  // typedef navifi_tclTraversePath::tclKnot tclKnot;

  tBool bUseSpecialBinContainer;  
  
 public:
  
  // --Traversierungspfad
  fi_tclTraversePath<weathertunerfi_tclKnot> oPath;
  //   navifi_tclTraversePath oPath;
  fi_tclTraversePath<weathertunerfi_tclKnot> oCallStack;
   //  navifi_tclTraversePath oCallStack;
  
};

// --Inline-Implementierungen
inline weathertunerfi_tclDescription::weathertunerfi_tclDescription(fi_tclInContext* poIn, weathertunerfi_tclVisitorBase* poVisit):
  enType(EN_PARSING),poInContext(poIn),poVisitor(poVisit),bUseSpecialBinContainer(false) {}

inline weathertunerfi_tclDescription::weathertunerfi_tclDescription(fi_tclOutContext* poOut, weathertunerfi_tclVisitorBase* poVisit):
  enType(EN_GENERATING),poOutContext(poOut),poVisitor(poVisit),bUseSpecialBinContainer(false) {}

#endif

