#include "precompiled.hh"

tBool weathertunerfi_tclDescription::bInitMessage(weathertunerfi_tclToken::tenType enMsgToken) {
   tBool bResult = TRUE;
   switch (enMsgToken) {
   case weathertunerfi_tclToken::EN_LAST_TOKEN:
   case weathertunerfi_tclToken::EN_LIST:
   case weathertunerfi_tclToken::EN_END_OF_STRUCT:
   case weathertunerfi_tclToken::EN_UNKNOWN:
      bResult=FALSE;   
   break;
      // include the expansions for the messages
   case weathertunerfi_tclToken::EN_MSG_GETMETARDATAMETHODRESULT:
   {
      bResult &= oPath.bGoDown(weathertunerfi_tclKnot(weathertunerfi_tclToken::EN_U8,weathertunerfi_tclSemanticDomain::EN_LIST_ELEMENT,0));
      bResult &= oPath.bGoDown(weathertunerfi_tclKnot(weathertunerfi_tclToken::EN_LIST,weathertunerfi_tclSemanticDomain::EN_MSG_METARDATA));
      bResult &= oPath.bGoDown(weathertunerfi_tclKnot(weathertunerfi_tclToken::EN_POSIXTIME,weathertunerfi_tclSemanticDomain::EN_MSG_GENERATIONTIME));
      bResult &= oPath.bGoDown(weathertunerfi_tclKnot(weathertunerfi_tclToken::EN_U32,weathertunerfi_tclSemanticDomain::EN_MSG_METARBLOCKID));
   } break;
   case weathertunerfi_tclToken::EN_MSG_GETMETARDATAMETHODRESULTFIRST:
   {
      bResult &= oPath.bGoDown(weathertunerfi_tclKnot(weathertunerfi_tclToken::EN_POSIXTIME,weathertunerfi_tclSemanticDomain::EN_MSG_GENERATIONTIME));
      bResult &= oPath.bGoDown(weathertunerfi_tclKnot(weathertunerfi_tclToken::EN_U32,weathertunerfi_tclSemanticDomain::EN_MSG_METARBLOCKID));
   } break;
   case weathertunerfi_tclToken::EN_MSG_GETMETARDATAMETHODRESULTMIDDLE:
   {
      bResult &= oPath.bGoDown(weathertunerfi_tclKnot(weathertunerfi_tclToken::EN_U8,weathertunerfi_tclSemanticDomain::EN_LIST_ELEMENT,0));
      bResult &= oPath.bGoDown(weathertunerfi_tclKnot(weathertunerfi_tclToken::EN_LIST,weathertunerfi_tclSemanticDomain::EN_MSG_METARDATA));
   } break;
   case weathertunerfi_tclToken::EN_MSG_GETCCFDATAMETHODRESULT:
   {
      bResult &= oPath.bGoDown(weathertunerfi_tclKnot(weathertunerfi_tclToken::EN_U8,weathertunerfi_tclSemanticDomain::EN_LIST_ELEMENT,0));
      bResult &= oPath.bGoDown(weathertunerfi_tclKnot(weathertunerfi_tclToken::EN_LIST,weathertunerfi_tclSemanticDomain::EN_MSG_CCFDATA));
      bResult &= oPath.bGoDown(weathertunerfi_tclKnot(weathertunerfi_tclToken::EN_POSIXTIME,weathertunerfi_tclSemanticDomain::EN_MSG_GENERATIONTIME));
      bResult &= oPath.bGoDown(weathertunerfi_tclKnot(weathertunerfi_tclToken::EN_U32,weathertunerfi_tclSemanticDomain::EN_MSG_CCFBLOCKID));
   } break;
   case weathertunerfi_tclToken::EN_MSG_METARDATACHANGEDSTATUS:
   {
      bResult &= oPath.bGoDown(weathertunerfi_tclKnot(weathertunerfi_tclToken::EN_U32,weathertunerfi_tclSemanticDomain::EN_MSG_METARBLOCKID));
   } break;
   case weathertunerfi_tclToken::EN_MSG_CCFDATACHANGEDSTATUS:
   {
      bResult &= oPath.bGoDown(weathertunerfi_tclKnot(weathertunerfi_tclToken::EN_U32,weathertunerfi_tclSemanticDomain::EN_MSG_CCFBLOCKID));
   } break;
   case weathertunerfi_tclToken::EN_MSG_COUNTYWARNINGDATACHANGEDSTATUS:
   {
      bResult &= oPath.bGoDown(weathertunerfi_tclKnot(weathertunerfi_tclToken::EN_U8,weathertunerfi_tclSemanticDomain::EN_LIST_ELEMENT,0));
      bResult &= oPath.bGoDown(weathertunerfi_tclKnot(weathertunerfi_tclToken::EN_LIST,weathertunerfi_tclSemanticDomain::EN_MSG_COUNTYWARNINGDATA));
      bResult &= oPath.bGoDown(weathertunerfi_tclKnot(weathertunerfi_tclToken::EN_POSIXTIME,weathertunerfi_tclSemanticDomain::EN_MSG_GENERATIONTIME));
      bResult &= oPath.bGoDown(weathertunerfi_tclKnot(weathertunerfi_tclToken::EN_U32,weathertunerfi_tclSemanticDomain::EN_MSG_COUNTYWARNINGBLOCKID));
   } break;
   case weathertunerfi_tclToken::EN_BINCONTAINER:
   case weathertunerfi_tclToken::EN_POSIXTIME:
   case weathertunerfi_tclToken::EN_U8:   
   case weathertunerfi_tclToken::EN_S8:   
   case weathertunerfi_tclToken::EN_U16:   
   case weathertunerfi_tclToken::EN_S16:   
   case weathertunerfi_tclToken::EN_U24:   
   case weathertunerfi_tclToken::EN_S24:   
   case weathertunerfi_tclToken::EN_U32:   
   case weathertunerfi_tclToken::EN_S32:   
   case weathertunerfi_tclToken::EN_U64:   
   case weathertunerfi_tclToken::EN_S64:   
   case weathertunerfi_tclToken::EN_F32:   
   case weathertunerfi_tclToken::EN_F64:   
   case weathertunerfi_tclToken::EN_BOOL:   
   case weathertunerfi_tclToken::EN_STRING:   
   case weathertunerfi_tclToken::EN_MULTILANGUAGESTRING:   
   default:
      oPath.bGoDown(weathertunerfi_tclKnot(enMsgToken,weathertunerfi_tclSemanticDomain::EN_UNKNOWN));
      bResult = TRUE;
   }	
   return bResult;
}

tBool weathertunerfi_tclDescription::bDoIt(fi_tclVisitableTypeBase& oTypeBase)
{
   // --read or write?
   if (enType==EN_PARSING)
   {
     // --read first, then pass visitor
     (*poInContext) >> oTypeBase;
     oTypeBase.vTakeVisitor(*poVisitor);
   }
   else
   {
     // --first pass visitor, then stream 
	 oTypeBase.vTakeVisitor(*poVisitor);
     (*poOutContext) << oTypeBase;
   }
   return poVisitor->bIsValid();
}

tBool weathertunerfi_tclDescription::bProcessMessage() {
   tBool bResult = TRUE;
   tBool bInsideBinContainerVersion = false;
   tU16 u16MajorVersion;
   if (enType == EN_GENERATING)
   {
      u16MajorVersion = poOutContext->u16GetMajorVersion();
   }
   else
   {
      u16MajorVersion = poInContext->u16GetMajorVersion();
   }
   if (u16MajorVersion > 0x8000)
   {
      return FALSE;
   }
   tU16 u16SavedMajorVersion = u16MajorVersion;
   poVisitor->vReleaseBreak();
   while ((oPath.u32Position>0) && 
      bResult &&
      !poVisitor->bBreak() )    {
      // get current context (name, type, list index of next element)
      weathertunerfi_tclKnot oKnot = oPath.oGetIterator().oKnot();
      weathertunerfi_tclSemanticDomain::tenType enSemanticDomain = oKnot.enSemanticDomain;
      weathertunerfi_tclToken::tenType enToken = oKnot.enToken;
      tU32 u32Index = oKnot.u32Index;
      
      // lists need special handling
      if (enSemanticDomain == weathertunerfi_tclSemanticDomain::EN_LIST_ELEMENT) {
         oPath.bGoUp();
         // has list remaining elements?
         if (u32Index < oPath.oGetIterator().oKnot().u32Index) {
            // create next list element
            oPath.bGoDown(weathertunerfi_tclKnot(enToken,enSemanticDomain,u32Index+1));
            oPath.bGoDown(weathertunerfi_tclKnot(enToken,enSemanticDomain,u32Index));
         } else {
            // remove list, clean up
            oPath.bGoUp();
            oCallStack.bGoUp();
            continue;	
         }
      }
      // push current context on stack for visitor
      oCallStack.bGoDown(weathertunerfi_tclKnot(enToken,enSemanticDomain,u32Index));
      poVisitor->oIterator=oCallStack.oGetIterator();
      
      // now, process element
      switch (enToken) {
      case weathertunerfi_tclToken::EN_END_OF_STRUCT: 
      {
         // clean up after structures
         if (enSemanticDomain == weathertunerfi_tclSemanticDomain::EN_BINCONTAINER)
         {
            u16MajorVersion = u16SavedMajorVersion;
            if (enType == EN_GENERATING)
            {
               poOutContext->u16SetMajorVersion(u16MajorVersion);
            }
            else
            {
               poInContext->u16SetMajorVersion(u16MajorVersion);
            }
         }
         oPath.bGoUp();
         oCallStack.bGoUp();
         oCallStack.bGoUp();
      } break;
      case weathertunerfi_tclToken::EN_LIST: 
      {
         fi_tclList oList;
         // get list size
         if (!bDoIt(oList)) {
            // rearrange LIST and LIST_ELEMENT knots
            // pop "old" LIST knot
            oPath.bGoUp();
            // pop and backup LIST_ELEMENT knot
            weathertunerfi_tclKnot saveKnot;
            oPath.bGoUp(saveKnot);
            // push LIST knot
            oPath.bGoDown(weathertunerfi_tclKnot(enToken,enSemanticDomain,oList.u32ListSize));
            // push LIST_ELEMENT knot
            oPath.bGoDown(saveKnot);
            return FALSE;
         } else {
            // rearrange LIST and LIST_ELEMENT knots
            // pop "old" LIST knot
            oPath.bGoUp();
            // pop and backup LIST_ELEMENT knot
            weathertunerfi_tclKnot saveKnot;
            oPath.bGoUp(saveKnot);
            // push LIST knot
            oPath.bGoDown(weathertunerfi_tclKnot(enToken,enSemanticDomain,oList.u32ListSize));
            // push LIST_ELEMENT knot
            oPath.bGoDown(saveKnot);
         }
      } break;
      case weathertunerfi_tclToken::EN_U8: 
      {
         fi_tclU8 oU8;
         if (!bDoIt(oU8))
            return FALSE;
         oCallStack.bGoUp();
         oPath.bGoUp();
         if (bInsideBinContainerVersion)
         {
            bInsideBinContainerVersion = false;
            u16SavedMajorVersion = u16MajorVersion;
            u16MajorVersion = oU8.u8Value;
            if (enType == EN_GENERATING)
            {
               poOutContext->u16SetMajorVersion(u16MajorVersion);
            }
            else
            {
               poInContext->u16SetMajorVersion(u16MajorVersion);
            }
         }
      } break;
      case weathertunerfi_tclToken::EN_U16: 
      {
         fi_tclU16 oU16;
         if (!bDoIt(oU16))
            return FALSE;
         oCallStack.bGoUp();
         oPath.bGoUp();
      } break;
      case weathertunerfi_tclToken::EN_U24: 
      {
         fi_tclU24 oU24;
         if (!bDoIt(oU24))
            return FALSE;
         oCallStack.bGoUp();
         oPath.bGoUp();
      } break;
      case weathertunerfi_tclToken::EN_U32: 
      {
         fi_tclU32 oU32;
         if (!bDoIt(oU32))
            return FALSE;
         oCallStack.bGoUp();
         oPath.bGoUp();
      } break;
      case weathertunerfi_tclToken::EN_U64: 
      {
         fi_tclU64 oU64;
         if (!bDoIt(oU64))
            return FALSE;
         oCallStack.bGoUp();
         oPath.bGoUp();
      } break;
      case weathertunerfi_tclToken::EN_S8: 
      {
         fi_tclS8 oS8;
         if (!bDoIt(oS8))
            return FALSE;
         oCallStack.bGoUp();
         oPath.bGoUp();
      } break;
      case weathertunerfi_tclToken::EN_S16: 
      {
         fi_tclS16 oS16;
         if (!bDoIt(oS16))
            return FALSE;
         oCallStack.bGoUp();
         oPath.bGoUp();
      } break;
      case weathertunerfi_tclToken::EN_S24: 
      {
         fi_tclS24 oS24;
         if (!bDoIt(oS24))
            return FALSE;
         oCallStack.bGoUp();
         oPath.bGoUp();
      } break;
      case weathertunerfi_tclToken::EN_S32: 
      {
         fi_tclS32 oS32;
         if (!bDoIt(oS32))
            return FALSE;
         oCallStack.bGoUp();
         oPath.bGoUp();
      } break;
      case weathertunerfi_tclToken::EN_S64: 
      {
         fi_tclS64 oS64;
         if (!bDoIt(oS64))
            return FALSE;
         oCallStack.bGoUp();
         oPath.bGoUp();
      } break;
      case weathertunerfi_tclToken::EN_F32: 
      {
         fi_tclF32 oF32;
         if (!bDoIt(oF32))
            return FALSE;
         oCallStack.bGoUp();
         oPath.bGoUp();
      } break;
      case weathertunerfi_tclToken::EN_F64: 
      {
         fi_tclF64 oF64;
         if (!bDoIt(oF64))
            return FALSE;
         oCallStack.bGoUp();
         oPath.bGoUp();
      } break;
      case weathertunerfi_tclToken::EN_BOOL: 
      {
         fi_tclBool oBool;
         if (!bDoIt(oBool))
            return FALSE;
         oCallStack.bGoUp();
         oPath.bGoUp();
      } break;
      case weathertunerfi_tclToken::EN_STRING: 
      {
         fi_tclString oString;
         if (!bDoIt(oString)) {
            oString.vDestroy();
            return FALSE;
         }
         oString.vDestroy();
         oCallStack.bGoUp();
         oPath.bGoUp();
      } break;
      case weathertunerfi_tclToken::EN_MULTILANGUAGESTRING: 
      {
         fi_tclMultiLanguageString oString;
         if (!bDoIt(oString)) {
            oString.vDestroy();
            return FALSE;
         }
         oString.vDestroy();
         oCallStack.bGoUp();
         oPath.bGoUp();
      } break;
      // include rest of type expansions/processing
   case weathertunerfi_tclToken::EN_MSG_GETMETARDATAMETHODSTART:
   case weathertunerfi_tclToken::EN_MSG_GETMETARDATAMETHODRESULT:
   case weathertunerfi_tclToken::EN_MSG_GETMETARDATAMETHODRESULTFIRST:
   case weathertunerfi_tclToken::EN_MSG_GETMETARDATAMETHODRESULTMIDDLE:
   case weathertunerfi_tclToken::EN_MSG_GETMETARDATAMETHODRESULTLAST:
   case weathertunerfi_tclToken::EN_MSG_GETCCFDATAMETHODSTART:
   case weathertunerfi_tclToken::EN_MSG_GETCCFDATAMETHODRESULT:
   case weathertunerfi_tclToken::EN_MSG_METARDATACHANGEDGET:
   case weathertunerfi_tclToken::EN_MSG_METARDATACHANGEDUPREG:
   case weathertunerfi_tclToken::EN_MSG_METARDATACHANGEDRELUPREG:
   case weathertunerfi_tclToken::EN_MSG_METARDATACHANGEDSTATUS:
   case weathertunerfi_tclToken::EN_MSG_CCFDATACHANGEDGET:
   case weathertunerfi_tclToken::EN_MSG_CCFDATACHANGEDUPREG:
   case weathertunerfi_tclToken::EN_MSG_CCFDATACHANGEDRELUPREG:
   case weathertunerfi_tclToken::EN_MSG_CCFDATACHANGEDSTATUS:
   case weathertunerfi_tclToken::EN_MSG_COUNTYWARNINGDATACHANGEDGET:
   case weathertunerfi_tclToken::EN_MSG_COUNTYWARNINGDATACHANGEDUPREG:
   case weathertunerfi_tclToken::EN_MSG_COUNTYWARNINGDATACHANGEDRELUPREG:
   case weathertunerfi_tclToken::EN_MSG_COUNTYWARNINGDATACHANGEDSTATUS:
      bInitMessage(enToken);
      break;
   case weathertunerfi_tclToken::EN_BINCONTAINER:
   {
      if (poVisitor->bDoExpand_BinContainer(enSemanticDomain))
      {
         oPath.bGoUp();
         oPath.bGoDown(weathertunerfi_tclKnot(weathertunerfi_tclToken::EN_END_OF_STRUCT,weathertunerfi_tclSemanticDomain::EN_UNKNOWN));
         oPath.bGoDown(weathertunerfi_tclKnot(weathertunerfi_tclToken::EN_U8,weathertunerfi_tclSemanticDomain::EN_LIST_ELEMENT,0));
         oPath.bGoDown(weathertunerfi_tclKnot(weathertunerfi_tclToken::EN_LIST,weathertunerfi_tclSemanticDomain::EN_CONTAINERDATALIST));
      }
      else
      {
         fi_tcl_BinContainer o_BinContainer;
         if (!bDoIt(o_BinContainer))
         {
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
            o_BinContainer.vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
            return FALSE;
         }
         else
         {
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
            o_BinContainer.vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
            oCallStack.bGoUp();
            oPath.bGoUp();
         }
      }
   } break;
   case weathertunerfi_tclToken::EN_POSIXTIME:
   {
      if (poVisitor->bDoExpand_POSIXTime(enSemanticDomain))
      {
         oPath.bGoUp();
         oPath.bGoDown(weathertunerfi_tclKnot(weathertunerfi_tclToken::EN_END_OF_STRUCT,weathertunerfi_tclSemanticDomain::EN_UNKNOWN));
         oPath.bGoDown(weathertunerfi_tclKnot(weathertunerfi_tclToken::EN_S32,weathertunerfi_tclSemanticDomain::EN_TIME));
      }
      else
      {
         fi_tcl_POSIXTime o_POSIXTime;
         if (!bDoIt(o_POSIXTime))
         {
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
            o_POSIXTime.vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
            return FALSE;
         }
         else
         {
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
            o_POSIXTime.vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
            oCallStack.bGoUp();
            oPath.bGoUp();
         }
      }
   } break;
      case weathertunerfi_tclToken::EN_UNKNOWN:
      case weathertunerfi_tclToken::EN_LAST_TOKEN:         
      default:
         return FALSE;
      }
  }
  return bResult;
}

