/************************************************************************
 
 *FILE:           navifitypes.h
 
 *SW-COMPONENT:   NaviFI, Navigation Functional Interface
 
 *DESCRIPTION:    Interface fuer NachrichtenStrukturTypdefinitionen des navifi
                  
 *AUTHOR:         Jochen Bruns (CM-DI/ENS41)
 
 *COPYRIGHT:      (c) 2001 Blaupunkt GmbH
 
 *HISTORY:
           (t.b.a)
 * 
 *    Rev 1.0   Oct 7 2001 17:16:00   bnj2hi
 * Initial revision
 *  
 ************************************************************************/

#ifndef WEATHERFITYPES_HEADER
#define WEATHERFITYPES_HEADER

// #include <vector>
// 


class weatherfi_tclVisitorBase;

/* --NaviFI-MessageStrukturtypen --*/

class weatherfi_tclMsgGetCurrentWeatherDataMethodStart : public fi_tclVisitableTypeBase, public fi_tclMessageBase
{
public:
   virtual tU16 u16GetServiceID() const;
   virtual tU16 u16GetFunctionID() const;
   virtual tU8  u8GetOpCode() const;
   virtual const fi_tclTypeBase& corfoGetTypeBase() const {return *this;};
   virtual fi_tclTypeBase& rfoGetTypeBase() {return *this;};
   weatherfi_tclMsgGetCurrentWeatherDataMethodStart():MaxDistance(),MaxNumberOfStations(0) {}
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   weatherfi_tclMsgGetCurrentWeatherDataMethodStart& operator=(const weatherfi_tclMsgGetCurrentWeatherDataMethodStart& coRef);
   weatherfi_tclMsgGetCurrentWeatherDataMethodStart(const weatherfi_tclMsgGetCurrentWeatherDataMethodStart& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
   std::vector<fi_tcl_PositionWGS84, std::allocator<fi_tcl_PositionWGS84> > PositionList;
   fi_tcl_s32_Meter MaxDistance;
   tU8 MaxNumberOfStations;

   virtual tVoid vDestroy();
   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual tBool operator==(const weatherfi_tclMsgGetCurrentWeatherDataMethodStart& rfoCmp) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   virtual tS32 s32GetTypeId() const { return weatherfi_tclToken::EN_MSG_GETCURRENTWEATHERDATAMETHODSTART;}
};

class weatherfi_tclMsgGetCurrentWeatherDataMethodResult : public fi_tclVisitableTypeBase, public fi_tclMessageBase
{
public:
   virtual tU16 u16GetServiceID() const;
   virtual tU16 u16GetFunctionID() const;
   virtual tU8  u8GetOpCode() const;
   virtual const fi_tclTypeBase& corfoGetTypeBase() const {return *this;};
   virtual fi_tclTypeBase& rfoGetTypeBase() {return *this;};
   weatherfi_tclMsgGetCurrentWeatherDataMethodResult():MetarBlockId(0) {}
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   weatherfi_tclMsgGetCurrentWeatherDataMethodResult& operator=(const weatherfi_tclMsgGetCurrentWeatherDataMethodResult& coRef);
   weatherfi_tclMsgGetCurrentWeatherDataMethodResult(const weatherfi_tclMsgGetCurrentWeatherDataMethodResult& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
   tU32 MetarBlockId;
   std::vector<fi_tcl_WeatherForPosition, std::allocator<fi_tcl_WeatherForPosition> > WeatherForPosition;

   virtual tVoid vDestroy();
   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual tBool operator==(const weatherfi_tclMsgGetCurrentWeatherDataMethodResult& rfoCmp) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   virtual tS32 s32GetTypeId() const { return weatherfi_tclToken::EN_MSG_GETCURRENTWEATHERDATAMETHODRESULT;}
};

class weatherfi_tclMsgGetWeatherForecastDataMethodStart : public fi_tclVisitableTypeBase, public fi_tclMessageBase
{
public:
   virtual tU16 u16GetServiceID() const;
   virtual tU16 u16GetFunctionID() const;
   virtual tU8  u8GetOpCode() const;
   virtual const fi_tclTypeBase& corfoGetTypeBase() const {return *this;};
   virtual fi_tclTypeBase& rfoGetTypeBase() {return *this;};
   weatherfi_tclMsgGetWeatherForecastDataMethodStart():MaxDistance(),MaxNumberOfCities(0) {}
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   weatherfi_tclMsgGetWeatherForecastDataMethodStart& operator=(const weatherfi_tclMsgGetWeatherForecastDataMethodStart& coRef);
   weatherfi_tclMsgGetWeatherForecastDataMethodStart(const weatherfi_tclMsgGetWeatherForecastDataMethodStart& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
   std::vector<fi_tcl_PositionWGS84, std::allocator<fi_tcl_PositionWGS84> > PositionList;
   fi_tcl_s32_Meter MaxDistance;
   tU8 MaxNumberOfCities;

   virtual tVoid vDestroy();
   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual tBool operator==(const weatherfi_tclMsgGetWeatherForecastDataMethodStart& rfoCmp) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   virtual tS32 s32GetTypeId() const { return weatherfi_tclToken::EN_MSG_GETWEATHERFORECASTDATAMETHODSTART;}
};

class weatherfi_tclMsgGetWeatherForecastDataMethodResult : public fi_tclVisitableTypeBase, public fi_tclMessageBase
{
public:
   virtual tU16 u16GetServiceID() const;
   virtual tU16 u16GetFunctionID() const;
   virtual tU8  u8GetOpCode() const;
   virtual const fi_tclTypeBase& corfoGetTypeBase() const {return *this;};
   virtual fi_tclTypeBase& rfoGetTypeBase() {return *this;};
   weatherfi_tclMsgGetWeatherForecastDataMethodResult():CCFBlockId(0) {}
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   weatherfi_tclMsgGetWeatherForecastDataMethodResult& operator=(const weatherfi_tclMsgGetWeatherForecastDataMethodResult& coRef);
   weatherfi_tclMsgGetWeatherForecastDataMethodResult(const weatherfi_tclMsgGetWeatherForecastDataMethodResult& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
   tU32 CCFBlockId;
   std::vector<fi_tcl_WeatherForecastForPosition, std::allocator<fi_tcl_WeatherForecastForPosition> > WeatherForecastsForPosition;

   virtual tVoid vDestroy();
   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual tBool operator==(const weatherfi_tclMsgGetWeatherForecastDataMethodResult& rfoCmp) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   virtual tS32 s32GetTypeId() const { return weatherfi_tclToken::EN_MSG_GETWEATHERFORECASTDATAMETHODRESULT;}
};

class weatherfi_tclMsgGetCountyWarningDataMethodStart : public fi_tclVisitableTypeBase, public fi_tclMessageBase
{
public:
   virtual tU16 u16GetServiceID() const;
   virtual tU16 u16GetFunctionID() const;
   virtual tU8  u8GetOpCode() const;
   virtual const fi_tclTypeBase& corfoGetTypeBase() const {return *this;};
   virtual fi_tclTypeBase& rfoGetTypeBase() {return *this;};
   weatherfi_tclMsgGetCountyWarningDataMethodStart():Position(),MaxDistance() {}
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   weatherfi_tclMsgGetCountyWarningDataMethodStart& operator=(const weatherfi_tclMsgGetCountyWarningDataMethodStart& coRef);
   weatherfi_tclMsgGetCountyWarningDataMethodStart(const weatherfi_tclMsgGetCountyWarningDataMethodStart& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
   fi_tcl_PositionWGS84 Position;
   fi_tcl_s32_Meter MaxDistance;

   virtual tVoid vDestroy();
   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual tBool operator==(const weatherfi_tclMsgGetCountyWarningDataMethodStart& rfoCmp) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   virtual tS32 s32GetTypeId() const { return weatherfi_tclToken::EN_MSG_GETCOUNTYWARNINGDATAMETHODSTART;}
};

class weatherfi_tclMsgGetCountyWarningDataMethodResult : public fi_tclVisitableTypeBase, public fi_tclMessageBase
{
public:
   virtual tU16 u16GetServiceID() const;
   virtual tU16 u16GetFunctionID() const;
   virtual tU8  u8GetOpCode() const;
   virtual const fi_tclTypeBase& corfoGetTypeBase() const {return *this;};
   virtual fi_tclTypeBase& rfoGetTypeBase() {return *this;};
   weatherfi_tclMsgGetCountyWarningDataMethodResult():CountyWarningId(0),CountyWarningSubId(0) {}
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   weatherfi_tclMsgGetCountyWarningDataMethodResult& operator=(const weatherfi_tclMsgGetCountyWarningDataMethodResult& coRef);
   weatherfi_tclMsgGetCountyWarningDataMethodResult(const weatherfi_tclMsgGetCountyWarningDataMethodResult& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
   tU32 CountyWarningId;
   tU32 CountyWarningSubId;
   std::vector<fi_tcl_CountyWarning, std::allocator<fi_tcl_CountyWarning> > CountyWarnings;

   virtual tVoid vDestroy();
   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual tBool operator==(const weatherfi_tclMsgGetCountyWarningDataMethodResult& rfoCmp) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   virtual tS32 s32GetTypeId() const { return weatherfi_tclToken::EN_MSG_GETCOUNTYWARNINGDATAMETHODRESULT;}
};

class weatherfi_tclMsgGetForecastCityListMethodStart : public fi_tclVisitableTypeBase, public fi_tclMessageBase
{
public:
   virtual tU16 u16GetServiceID() const;
   virtual tU16 u16GetFunctionID() const;
   virtual tU8  u8GetOpCode() const;
   virtual const fi_tclTypeBase& corfoGetTypeBase() const {return *this;};
   virtual fi_tclTypeBase& rfoGetTypeBase() {return *this;};
   weatherfi_tclMsgGetForecastCityListMethodStart() {}
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   weatherfi_tclMsgGetForecastCityListMethodStart& operator=(const weatherfi_tclMsgGetForecastCityListMethodStart& coRef);
   weatherfi_tclMsgGetForecastCityListMethodStart(const weatherfi_tclMsgGetForecastCityListMethodStart& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual tBool operator==(const weatherfi_tclMsgGetForecastCityListMethodStart& rfoCmp) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   virtual tS32 s32GetTypeId() const { return weatherfi_tclToken::EN_MSG_GETFORECASTCITYLISTMETHODSTART;}
};

class weatherfi_tclMsgGetForecastCityListMethodResult : public fi_tclVisitableTypeBase, public fi_tclMessageBase
{
public:
   virtual tU16 u16GetServiceID() const;
   virtual tU16 u16GetFunctionID() const;
   virtual tU8  u8GetOpCode() const;
   virtual const fi_tclTypeBase& corfoGetTypeBase() const {return *this;};
   virtual fi_tclTypeBase& rfoGetTypeBase() {return *this;};
   weatherfi_tclMsgGetForecastCityListMethodResult() {}
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   weatherfi_tclMsgGetForecastCityListMethodResult& operator=(const weatherfi_tclMsgGetForecastCityListMethodResult& coRef);
   weatherfi_tclMsgGetForecastCityListMethodResult(const weatherfi_tclMsgGetForecastCityListMethodResult& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
   std::vector<fi_tcl_CodedCity, std::allocator<fi_tcl_CodedCity> > ForecastCities;

   virtual tVoid vDestroy();
   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual tBool operator==(const weatherfi_tclMsgGetForecastCityListMethodResult& rfoCmp) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   virtual tS32 s32GetTypeId() const { return weatherfi_tclToken::EN_MSG_GETFORECASTCITYLISTMETHODRESULT;}
};

class weatherfi_tclMsgGetForecastForCityMethodStart : public fi_tclVisitableTypeBase, public fi_tclMessageBase
{
public:
   virtual tU16 u16GetServiceID() const;
   virtual tU16 u16GetFunctionID() const;
   virtual tU8  u8GetOpCode() const;
   virtual const fi_tclTypeBase& corfoGetTypeBase() const {return *this;};
   virtual fi_tclTypeBase& rfoGetTypeBase() {return *this;};
   weatherfi_tclMsgGetForecastForCityMethodStart():CityCode(0) {}
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   weatherfi_tclMsgGetForecastForCityMethodStart& operator=(const weatherfi_tclMsgGetForecastForCityMethodStart& coRef);
   weatherfi_tclMsgGetForecastForCityMethodStart(const weatherfi_tclMsgGetForecastForCityMethodStart& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
   tU32 CityCode;

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual tBool operator==(const weatherfi_tclMsgGetForecastForCityMethodStart& rfoCmp) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   virtual tS32 s32GetTypeId() const { return weatherfi_tclToken::EN_MSG_GETFORECASTFORCITYMETHODSTART;}
};

class weatherfi_tclMsgGetForecastForCityMethodResult : public fi_tclVisitableTypeBase, public fi_tclMessageBase
{
public:
   virtual tU16 u16GetServiceID() const;
   virtual tU16 u16GetFunctionID() const;
   virtual tU8  u8GetOpCode() const;
   virtual const fi_tclTypeBase& corfoGetTypeBase() const {return *this;};
   virtual fi_tclTypeBase& rfoGetTypeBase() {return *this;};
   weatherfi_tclMsgGetForecastForCityMethodResult():WeatherForecastId(0),WeatherForecast() {}
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   weatherfi_tclMsgGetForecastForCityMethodResult& operator=(const weatherfi_tclMsgGetForecastForCityMethodResult& coRef);
   weatherfi_tclMsgGetForecastForCityMethodResult(const weatherfi_tclMsgGetForecastForCityMethodResult& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
   tU32 WeatherForecastId;
   fi_tcl_WeatherForecast WeatherForecast;

   virtual tVoid vDestroy();
   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual tBool operator==(const weatherfi_tclMsgGetForecastForCityMethodResult& rfoCmp) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   virtual tS32 s32GetTypeId() const { return weatherfi_tclToken::EN_MSG_GETFORECASTFORCITYMETHODRESULT;}
};

class weatherfi_tclMsgGetTabularWeatherDataMethodStart : public fi_tclVisitableTypeBase, public fi_tclMessageBase
{
public:
   virtual tU16 u16GetServiceID() const;
   virtual tU16 u16GetFunctionID() const;
   virtual tU8  u8GetOpCode() const;
   virtual const fi_tclTypeBase& corfoGetTypeBase() const {return *this;};
   virtual fi_tclTypeBase& rfoGetTypeBase() {return *this;};
   weatherfi_tclMsgGetTabularWeatherDataMethodStart():MaxDistance(),MaxNumber(0),ForecastType() {}
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   weatherfi_tclMsgGetTabularWeatherDataMethodStart& operator=(const weatherfi_tclMsgGetTabularWeatherDataMethodStart& coRef);
   weatherfi_tclMsgGetTabularWeatherDataMethodStart(const weatherfi_tclMsgGetTabularWeatherDataMethodStart& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
   std::vector<fi_tcl_PositionWGS84, std::allocator<fi_tcl_PositionWGS84> > PositionList;
   fi_tcl_s32_Meter MaxDistance;
   tU8 MaxNumber;
   fi_tcl_b16_ForecastType ForecastType;

   virtual tVoid vDestroy();
   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual tBool operator==(const weatherfi_tclMsgGetTabularWeatherDataMethodStart& rfoCmp) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   virtual tS32 s32GetTypeId() const { return weatherfi_tclToken::EN_MSG_GETTABULARWEATHERDATAMETHODSTART;}
};

class weatherfi_tclMsgGetTabularWeatherDataMethodResult : public fi_tclVisitableTypeBase, public fi_tclMessageBase
{
public:
   virtual tU16 u16GetServiceID() const;
   virtual tU16 u16GetFunctionID() const;
   virtual tU8  u8GetOpCode() const;
   virtual const fi_tclTypeBase& corfoGetTypeBase() const {return *this;};
   virtual fi_tclTypeBase& rfoGetTypeBase() {return *this;};
   weatherfi_tclMsgGetTabularWeatherDataMethodResult() {}
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   weatherfi_tclMsgGetTabularWeatherDataMethodResult& operator=(const weatherfi_tclMsgGetTabularWeatherDataMethodResult& coRef);
   weatherfi_tclMsgGetTabularWeatherDataMethodResult(const weatherfi_tclMsgGetTabularWeatherDataMethodResult& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
   std::vector<fi_tcl_VersionPerForecast, std::allocator<fi_tcl_VersionPerForecast> > VersionsForForecasts;
   std::vector<fi_tcl_TabularWeatherForPosition, std::allocator<fi_tcl_TabularWeatherForPosition> > TabularWeatherForPosition;

   virtual tVoid vDestroy();
   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual tBool operator==(const weatherfi_tclMsgGetTabularWeatherDataMethodResult& rfoCmp) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   virtual tS32 s32GetTypeId() const { return weatherfi_tclToken::EN_MSG_GETTABULARWEATHERDATAMETHODRESULT;}
};

class weatherfi_tclMsgGetTabularWeatherSkiConditionDataMethodStart : public fi_tclVisitableTypeBase, public fi_tclMessageBase
{
public:
   virtual tU16 u16GetServiceID() const;
   virtual tU16 u16GetFunctionID() const;
   virtual tU8  u8GetOpCode() const;
   virtual const fi_tclTypeBase& corfoGetTypeBase() const {return *this;};
   virtual fi_tclTypeBase& rfoGetTypeBase() {return *this;};
   weatherfi_tclMsgGetTabularWeatherSkiConditionDataMethodStart():MaxDistance(),MaxNumber(0) {}
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   weatherfi_tclMsgGetTabularWeatherSkiConditionDataMethodStart& operator=(const weatherfi_tclMsgGetTabularWeatherSkiConditionDataMethodStart& coRef);
   weatherfi_tclMsgGetTabularWeatherSkiConditionDataMethodStart(const weatherfi_tclMsgGetTabularWeatherSkiConditionDataMethodStart& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
   std::vector<fi_tcl_PositionWGS84, std::allocator<fi_tcl_PositionWGS84> > PositionList;
   fi_tcl_s32_Meter MaxDistance;
   tU8 MaxNumber;

   virtual tVoid vDestroy();
   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual tBool operator==(const weatherfi_tclMsgGetTabularWeatherSkiConditionDataMethodStart& rfoCmp) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   virtual tS32 s32GetTypeId() const { return weatherfi_tclToken::EN_MSG_GETTABULARWEATHERSKICONDITIONDATAMETHODSTART;}
};

class weatherfi_tclMsgGetTabularWeatherSkiConditionDataMethodResult : public fi_tclVisitableTypeBase, public fi_tclMessageBase
{
public:
   virtual tU16 u16GetServiceID() const;
   virtual tU16 u16GetFunctionID() const;
   virtual tU8  u8GetOpCode() const;
   virtual const fi_tclTypeBase& corfoGetTypeBase() const {return *this;};
   virtual fi_tclTypeBase& rfoGetTypeBase() {return *this;};
   weatherfi_tclMsgGetTabularWeatherSkiConditionDataMethodResult():TabularWeatherSkiConditionVersionId(0) {}
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   weatherfi_tclMsgGetTabularWeatherSkiConditionDataMethodResult& operator=(const weatherfi_tclMsgGetTabularWeatherSkiConditionDataMethodResult& coRef);
   weatherfi_tclMsgGetTabularWeatherSkiConditionDataMethodResult(const weatherfi_tclMsgGetTabularWeatherSkiConditionDataMethodResult& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
   tU32 TabularWeatherSkiConditionVersionId;
   std::vector<fi_tcl_SkiConditionForPosition, std::allocator<fi_tcl_SkiConditionForPosition> > SkiConditionForPosition;

   virtual tVoid vDestroy();
   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual tBool operator==(const weatherfi_tclMsgGetTabularWeatherSkiConditionDataMethodResult& rfoCmp) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   virtual tS32 s32GetTypeId() const { return weatherfi_tclToken::EN_MSG_GETTABULARWEATHERSKICONDITIONDATAMETHODRESULT;}
};

class weatherfi_tclMsgGetWeatherAlertDataMethodStart : public fi_tclVisitableTypeBase, public fi_tclMessageBase
{
public:
   virtual tU16 u16GetServiceID() const;
   virtual tU16 u16GetFunctionID() const;
   virtual tU8  u8GetOpCode() const;
   virtual const fi_tclTypeBase& corfoGetTypeBase() const {return *this;};
   virtual fi_tclTypeBase& rfoGetTypeBase() {return *this;};
   weatherfi_tclMsgGetWeatherAlertDataMethodStart():MaxDistance(),MaxNumber(0),TwelveHourTimePresentation(0) {}
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   weatherfi_tclMsgGetWeatherAlertDataMethodStart& operator=(const weatherfi_tclMsgGetWeatherAlertDataMethodStart& coRef);
   weatherfi_tclMsgGetWeatherAlertDataMethodStart(const weatherfi_tclMsgGetWeatherAlertDataMethodStart& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
   std::vector<fi_tcl_PositionWGS84, std::allocator<fi_tcl_PositionWGS84> > PositionList;
   fi_tcl_s32_Meter MaxDistance;
   tU8 MaxNumber;
   std::vector<tU32, std::allocator<tU32> > StateFilter;
   std::vector<fi_tcl_StateOrZone, std::allocator<fi_tcl_StateOrZone> > StateZoneFilter;
   tBool TwelveHourTimePresentation;

   virtual tVoid vDestroy();
   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual tBool operator==(const weatherfi_tclMsgGetWeatherAlertDataMethodStart& rfoCmp) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   virtual tS32 s32GetTypeId() const { return weatherfi_tclToken::EN_MSG_GETWEATHERALERTDATAMETHODSTART;}
};

class weatherfi_tclMsgGetWeatherAlertDataMethodResult : public fi_tclVisitableTypeBase, public fi_tclMessageBase
{
public:
   virtual tU16 u16GetServiceID() const;
   virtual tU16 u16GetFunctionID() const;
   virtual tU8  u8GetOpCode() const;
   virtual const fi_tclTypeBase& corfoGetTypeBase() const {return *this;};
   virtual fi_tclTypeBase& rfoGetTypeBase() {return *this;};
   weatherfi_tclMsgGetWeatherAlertDataMethodResult() {}
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   weatherfi_tclMsgGetWeatherAlertDataMethodResult& operator=(const weatherfi_tclMsgGetWeatherAlertDataMethodResult& coRef);
   weatherfi_tclMsgGetWeatherAlertDataMethodResult(const weatherfi_tclMsgGetWeatherAlertDataMethodResult& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
   std::vector<fi_tcl_StatesPerLanguage, std::allocator<fi_tcl_StatesPerLanguage> > StatesAndVersionPerLanguage;
   std::vector<fi_tcl_WeatherAlertsForPosition, std::allocator<fi_tcl_WeatherAlertsForPosition> > WeatherAlertsForPosition;

   virtual tVoid vDestroy();
   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual tBool operator==(const weatherfi_tclMsgGetWeatherAlertDataMethodResult& rfoCmp) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   virtual tS32 s32GetTypeId() const { return weatherfi_tclToken::EN_MSG_GETWEATHERALERTDATAMETHODRESULT;}
};

class weatherfi_tclMsgConfirmGraphicalWeatherRasterTileSharedMemoryMethodStart : public fi_tclVisitableTypeBase, public fi_tclMessageBase
{
public:
   virtual tU16 u16GetServiceID() const;
   virtual tU16 u16GetFunctionID() const;
   virtual tU8  u8GetOpCode() const;
   virtual const fi_tclTypeBase& corfoGetTypeBase() const {return *this;};
   virtual fi_tclTypeBase& rfoGetTypeBase() {return *this;};
   weatherfi_tclMsgConfirmGraphicalWeatherRasterTileSharedMemoryMethodStart():ProductType(),PictureType(),Open(0),SharedMemoryOverview() {}
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   weatherfi_tclMsgConfirmGraphicalWeatherRasterTileSharedMemoryMethodStart& operator=(const weatherfi_tclMsgConfirmGraphicalWeatherRasterTileSharedMemoryMethodStart& coRef);
   weatherfi_tclMsgConfirmGraphicalWeatherRasterTileSharedMemoryMethodStart(const weatherfi_tclMsgConfirmGraphicalWeatherRasterTileSharedMemoryMethodStart& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
   fi_tcl_e8_ProductType ProductType;
   fi_tcl_e8_PictureType PictureType;
   tBool Open;
   fi_tcl_TileAndRasterPictureSharedMemory SharedMemoryOverview;

   virtual tVoid vDestroy();
   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual tBool operator==(const weatherfi_tclMsgConfirmGraphicalWeatherRasterTileSharedMemoryMethodStart& rfoCmp) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   virtual tS32 s32GetTypeId() const { return weatherfi_tclToken::EN_MSG_CONFIRMGRAPHICALWEATHERRASTERTILESHAREDMEMORYMETHODSTART;}
};

class weatherfi_tclMsgConfirmGraphicalWeatherRasterTileSharedMemoryMethodResult : public fi_tclVisitableTypeBase, public fi_tclMessageBase
{
public:
   virtual tU16 u16GetServiceID() const;
   virtual tU16 u16GetFunctionID() const;
   virtual tU8  u8GetOpCode() const;
   virtual const fi_tclTypeBase& corfoGetTypeBase() const {return *this;};
   virtual fi_tclTypeBase& rfoGetTypeBase() {return *this;};
   weatherfi_tclMsgConfirmGraphicalWeatherRasterTileSharedMemoryMethodResult():ProductType(),PictureType() {}
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   weatherfi_tclMsgConfirmGraphicalWeatherRasterTileSharedMemoryMethodResult& operator=(const weatherfi_tclMsgConfirmGraphicalWeatherRasterTileSharedMemoryMethodResult& coRef);
   weatherfi_tclMsgConfirmGraphicalWeatherRasterTileSharedMemoryMethodResult(const weatherfi_tclMsgConfirmGraphicalWeatherRasterTileSharedMemoryMethodResult& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
   fi_tcl_e8_ProductType ProductType;
   fi_tcl_e8_PictureType PictureType;

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual tBool operator==(const weatherfi_tclMsgConfirmGraphicalWeatherRasterTileSharedMemoryMethodResult& rfoCmp) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   virtual tS32 s32GetTypeId() const { return weatherfi_tclToken::EN_MSG_CONFIRMGRAPHICALWEATHERRASTERTILESHAREDMEMORYMETHODRESULT;}
};

class weatherfi_tclMsgConfirmGraphicalWeatherTilePictureDataMethodStart : public fi_tclVisitableTypeBase, public fi_tclMessageBase
{
public:
   virtual tU16 u16GetServiceID() const;
   virtual tU16 u16GetFunctionID() const;
   virtual tU8  u8GetOpCode() const;
   virtual const fi_tclTypeBase& corfoGetTypeBase() const {return *this;};
   virtual fi_tclTypeBase& rfoGetTypeBase() {return *this;};
   weatherfi_tclMsgConfirmGraphicalWeatherTilePictureDataMethodStart():ProductType(),PictureType() {}
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   weatherfi_tclMsgConfirmGraphicalWeatherTilePictureDataMethodStart& operator=(const weatherfi_tclMsgConfirmGraphicalWeatherTilePictureDataMethodStart& coRef);
   weatherfi_tclMsgConfirmGraphicalWeatherTilePictureDataMethodStart(const weatherfi_tclMsgConfirmGraphicalWeatherTilePictureDataMethodStart& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
   fi_tcl_e8_ProductType ProductType;
   fi_tcl_e8_PictureType PictureType;
   std::vector<fi_tcl_VersionsOfTile, std::allocator<fi_tcl_VersionsOfTile> > UsedTiles;
   std::vector<fi_tcl_VersionsOfTile, std::allocator<fi_tcl_VersionsOfTile> > BackgroundTiles;

   virtual tVoid vDestroy();
   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual tBool operator==(const weatherfi_tclMsgConfirmGraphicalWeatherTilePictureDataMethodStart& rfoCmp) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   virtual tS32 s32GetTypeId() const { return weatherfi_tclToken::EN_MSG_CONFIRMGRAPHICALWEATHERTILEPICTUREDATAMETHODSTART;}
};

class weatherfi_tclMsgConfirmGraphicalWeatherTilePictureDataMethodResult : public fi_tclVisitableTypeBase, public fi_tclMessageBase
{
public:
   virtual tU16 u16GetServiceID() const;
   virtual tU16 u16GetFunctionID() const;
   virtual tU8  u8GetOpCode() const;
   virtual const fi_tclTypeBase& corfoGetTypeBase() const {return *this;};
   virtual fi_tclTypeBase& rfoGetTypeBase() {return *this;};
   weatherfi_tclMsgConfirmGraphicalWeatherTilePictureDataMethodResult():ProductType(),PictureType() {}
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   weatherfi_tclMsgConfirmGraphicalWeatherTilePictureDataMethodResult& operator=(const weatherfi_tclMsgConfirmGraphicalWeatherTilePictureDataMethodResult& coRef);
   weatherfi_tclMsgConfirmGraphicalWeatherTilePictureDataMethodResult(const weatherfi_tclMsgConfirmGraphicalWeatherTilePictureDataMethodResult& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
   fi_tcl_e8_ProductType ProductType;
   fi_tcl_e8_PictureType PictureType;

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual tBool operator==(const weatherfi_tclMsgConfirmGraphicalWeatherTilePictureDataMethodResult& rfoCmp) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   virtual tS32 s32GetTypeId() const { return weatherfi_tclToken::EN_MSG_CONFIRMGRAPHICALWEATHERTILEPICTUREDATAMETHODRESULT;}
};

class weatherfi_tclMsgGetSurfaceDataMethodStart : public fi_tclVisitableTypeBase, public fi_tclMessageBase
{
public:
   virtual tU16 u16GetServiceID() const;
   virtual tU16 u16GetFunctionID() const;
   virtual tU8  u8GetOpCode() const;
   virtual const fi_tclTypeBase& corfoGetTypeBase() const {return *this;};
   virtual fi_tclTypeBase& rfoGetTypeBase() {return *this;};
   weatherfi_tclMsgGetSurfaceDataMethodStart():FrontFilter(),IsobarFilter(),PressureCenterFilter(),RequestedBinContainerVersion(0) {}
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   weatherfi_tclMsgGetSurfaceDataMethodStart& operator=(const weatherfi_tclMsgGetSurfaceDataMethodStart& coRef);
   weatherfi_tclMsgGetSurfaceDataMethodStart(const weatherfi_tclMsgGetSurfaceDataMethodStart& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
   fi_tcl_b8_ShapeContent FrontFilter;
   fi_tcl_b8_ShapeContent IsobarFilter;
   fi_tcl_b8_ShapeContent PressureCenterFilter;
   tU8 RequestedBinContainerVersion;

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual tBool operator==(const weatherfi_tclMsgGetSurfaceDataMethodStart& rfoCmp) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   virtual tS32 s32GetTypeId() const { return weatherfi_tclToken::EN_MSG_GETSURFACEDATAMETHODSTART;}
};

class weatherfi_tclMsgGetSurfaceDataMethodResult : public fi_tclVisitableTypeBase, public fi_tclMessageBase
{
public:
   virtual tU16 u16GetServiceID() const;
   virtual tU16 u16GetFunctionID() const;
   virtual tU8  u8GetOpCode() const;
   virtual const fi_tclTypeBase& corfoGetTypeBase() const {return *this;};
   virtual fi_tclTypeBase& rfoGetTypeBase() {return *this;};
   weatherfi_tclMsgGetSurfaceDataMethodResult():UpdateCounter(0),SurfaceShapes() {}
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   weatherfi_tclMsgGetSurfaceDataMethodResult& operator=(const weatherfi_tclMsgGetSurfaceDataMethodResult& coRef);
   weatherfi_tclMsgGetSurfaceDataMethodResult(const weatherfi_tclMsgGetSurfaceDataMethodResult& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
   tU32 UpdateCounter;
   std::vector<fi_tcl_WeatherShapeTypeFront, std::allocator<fi_tcl_WeatherShapeTypeFront> > Fronts;
   std::vector<fi_tcl_WeatherShapeTypeIsobar, std::allocator<fi_tcl_WeatherShapeTypeIsobar> > Isobars;
   std::vector<fi_tcl_WeatherShapeTypePressureCenter, std::allocator<fi_tcl_WeatherShapeTypePressureCenter> > PressureCenters;
   fi_tcl_BinContainer SurfaceShapes;

   virtual tVoid vDestroy();
   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual tBool operator==(const weatherfi_tclMsgGetSurfaceDataMethodResult& rfoCmp) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   virtual tS32 s32GetTypeId() const { return weatherfi_tclToken::EN_MSG_GETSURFACEDATAMETHODRESULT;}
};

class weatherfi_tclMsgGetStormAttributesDataMethodStart : public fi_tclVisitableTypeBase, public fi_tclMessageBase
{
public:
   virtual tU16 u16GetServiceID() const;
   virtual tU16 u16GetFunctionID() const;
   virtual tU8  u8GetOpCode() const;
   virtual const fi_tclTypeBase& corfoGetTypeBase() const {return *this;};
   virtual fi_tclTypeBase& rfoGetTypeBase() {return *this;};
   weatherfi_tclMsgGetStormAttributesDataMethodStart():StormAttributesFilter(),RequestedBinContainerVersion(0) {}
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   weatherfi_tclMsgGetStormAttributesDataMethodStart& operator=(const weatherfi_tclMsgGetStormAttributesDataMethodStart& coRef);
   weatherfi_tclMsgGetStormAttributesDataMethodStart(const weatherfi_tclMsgGetStormAttributesDataMethodStart& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
   fi_tcl_b8_ShapeContent StormAttributesFilter;
   tU8 RequestedBinContainerVersion;

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual tBool operator==(const weatherfi_tclMsgGetStormAttributesDataMethodStart& rfoCmp) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   virtual tS32 s32GetTypeId() const { return weatherfi_tclToken::EN_MSG_GETSTORMATTRIBUTESDATAMETHODSTART;}
};

class weatherfi_tclMsgGetStormAttributesDataMethodResult : public fi_tclVisitableTypeBase, public fi_tclMessageBase
{
public:
   virtual tU16 u16GetServiceID() const;
   virtual tU16 u16GetFunctionID() const;
   virtual tU8  u8GetOpCode() const;
   virtual const fi_tclTypeBase& corfoGetTypeBase() const {return *this;};
   virtual fi_tclTypeBase& rfoGetTypeBase() {return *this;};
   weatherfi_tclMsgGetStormAttributesDataMethodResult():UpdateCounter(0),StormAttributeShapes() {}
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   weatherfi_tclMsgGetStormAttributesDataMethodResult& operator=(const weatherfi_tclMsgGetStormAttributesDataMethodResult& coRef);
   weatherfi_tclMsgGetStormAttributesDataMethodResult(const weatherfi_tclMsgGetStormAttributesDataMethodResult& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
   tU32 UpdateCounter;
   std::vector<fi_tcl_WeatherShapeTypeStormAttributes, std::allocator<fi_tcl_WeatherShapeTypeStormAttributes> > StormAttributes;
   fi_tcl_BinContainer StormAttributeShapes;

   virtual tVoid vDestroy();
   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual tBool operator==(const weatherfi_tclMsgGetStormAttributesDataMethodResult& rfoCmp) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   virtual tS32 s32GetTypeId() const { return weatherfi_tclToken::EN_MSG_GETSTORMATTRIBUTESDATAMETHODRESULT;}
};

class weatherfi_tclMsgGetStormTrackDataMethodStart : public fi_tclVisitableTypeBase, public fi_tclMessageBase
{
public:
   virtual tU16 u16GetServiceID() const;
   virtual tU16 u16GetFunctionID() const;
   virtual tU8  u8GetOpCode() const;
   virtual const fi_tclTypeBase& corfoGetTypeBase() const {return *this;};
   virtual fi_tclTypeBase& rfoGetTypeBase() {return *this;};
   weatherfi_tclMsgGetStormTrackDataMethodStart():StormPositionFilter(),WindRadiusFilter(),RequestedBinContainerVersion(0) {}
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   weatherfi_tclMsgGetStormTrackDataMethodStart& operator=(const weatherfi_tclMsgGetStormTrackDataMethodStart& coRef);
   weatherfi_tclMsgGetStormTrackDataMethodStart(const weatherfi_tclMsgGetStormTrackDataMethodStart& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
   fi_tcl_b8_ShapeContent StormPositionFilter;
   fi_tcl_b8_ShapeContent WindRadiusFilter;
   tU8 RequestedBinContainerVersion;

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual tBool operator==(const weatherfi_tclMsgGetStormTrackDataMethodStart& rfoCmp) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   virtual tS32 s32GetTypeId() const { return weatherfi_tclToken::EN_MSG_GETSTORMTRACKDATAMETHODSTART;}
};

class weatherfi_tclMsgGetStormTrackDataMethodResult : public fi_tclVisitableTypeBase, public fi_tclMessageBase
{
public:
   virtual tU16 u16GetServiceID() const;
   virtual tU16 u16GetFunctionID() const;
   virtual tU8  u8GetOpCode() const;
   virtual const fi_tclTypeBase& corfoGetTypeBase() const {return *this;};
   virtual fi_tclTypeBase& rfoGetTypeBase() {return *this;};
   weatherfi_tclMsgGetStormTrackDataMethodResult():UpdateCounter(0),StormTrackShapes() {}
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   weatherfi_tclMsgGetStormTrackDataMethodResult& operator=(const weatherfi_tclMsgGetStormTrackDataMethodResult& coRef);
   weatherfi_tclMsgGetStormTrackDataMethodResult(const weatherfi_tclMsgGetStormTrackDataMethodResult& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
   tU32 UpdateCounter;
   std::vector<fi_tcl_WeatherShapeTypeStormTrack, std::allocator<fi_tcl_WeatherShapeTypeStormTrack> > StormTracks;
   fi_tcl_BinContainer StormTrackShapes;

   virtual tVoid vDestroy();
   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual tBool operator==(const weatherfi_tclMsgGetStormTrackDataMethodResult& rfoCmp) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   virtual tS32 s32GetTypeId() const { return weatherfi_tclToken::EN_MSG_GETSTORMTRACKDATAMETHODRESULT;}
};

class weatherfi_tclMsgConfirmRasterTileSharedMemoryMethodStart : public fi_tclVisitableTypeBase, public fi_tclMessageBase
{
public:
   virtual tU16 u16GetServiceID() const;
   virtual tU16 u16GetFunctionID() const;
   virtual tU8  u8GetOpCode() const;
   virtual const fi_tclTypeBase& corfoGetTypeBase() const {return *this;};
   virtual fi_tclTypeBase& rfoGetTypeBase() {return *this;};
   weatherfi_tclMsgConfirmRasterTileSharedMemoryMethodStart() {}
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   weatherfi_tclMsgConfirmRasterTileSharedMemoryMethodStart& operator=(const weatherfi_tclMsgConfirmRasterTileSharedMemoryMethodStart& coRef);
   weatherfi_tclMsgConfirmRasterTileSharedMemoryMethodStart(const weatherfi_tclMsgConfirmRasterTileSharedMemoryMethodStart& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
   std::vector<fi_tcl_WeatherSharedMemoryDescription, std::allocator<fi_tcl_WeatherSharedMemoryDescription> > ConfirmedSharedMemories;

   virtual tVoid vDestroy();
   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual tBool operator==(const weatherfi_tclMsgConfirmRasterTileSharedMemoryMethodStart& rfoCmp) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   virtual tS32 s32GetTypeId() const { return weatherfi_tclToken::EN_MSG_CONFIRMRASTERTILESHAREDMEMORYMETHODSTART;}
};

class weatherfi_tclMsgConfirmRasterTileSharedMemoryMethodResult : public fi_tclVisitableTypeBase, public fi_tclMessageBase
{
public:
   virtual tU16 u16GetServiceID() const;
   virtual tU16 u16GetFunctionID() const;
   virtual tU8  u8GetOpCode() const;
   virtual const fi_tclTypeBase& corfoGetTypeBase() const {return *this;};
   virtual fi_tclTypeBase& rfoGetTypeBase() {return *this;};
   weatherfi_tclMsgConfirmRasterTileSharedMemoryMethodResult() {}
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   weatherfi_tclMsgConfirmRasterTileSharedMemoryMethodResult& operator=(const weatherfi_tclMsgConfirmRasterTileSharedMemoryMethodResult& coRef);
   weatherfi_tclMsgConfirmRasterTileSharedMemoryMethodResult(const weatherfi_tclMsgConfirmRasterTileSharedMemoryMethodResult& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
   std::vector<fi_tcl_TileIdentifier, std::allocator<fi_tcl_TileIdentifier> > ConfirmedSharedMemories;

   virtual tVoid vDestroy();
   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual tBool operator==(const weatherfi_tclMsgConfirmRasterTileSharedMemoryMethodResult& rfoCmp) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   virtual tS32 s32GetTypeId() const { return weatherfi_tclToken::EN_MSG_CONFIRMRASTERTILESHAREDMEMORYMETHODRESULT;}
};

class weatherfi_tclMsgConfirmRasterTilePicturesMethodStart : public fi_tclVisitableTypeBase, public fi_tclMessageBase
{
public:
   virtual tU16 u16GetServiceID() const;
   virtual tU16 u16GetFunctionID() const;
   virtual tU8  u8GetOpCode() const;
   virtual const fi_tclTypeBase& corfoGetTypeBase() const {return *this;};
   virtual fi_tclTypeBase& rfoGetTypeBase() {return *this;};
   weatherfi_tclMsgConfirmRasterTilePicturesMethodStart() {}
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   weatherfi_tclMsgConfirmRasterTilePicturesMethodStart& operator=(const weatherfi_tclMsgConfirmRasterTilePicturesMethodStart& coRef);
   weatherfi_tclMsgConfirmRasterTilePicturesMethodStart(const weatherfi_tclMsgConfirmRasterTilePicturesMethodStart& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
   std::vector<fi_tcl_TileIdentifier, std::allocator<fi_tcl_TileIdentifier> > ConfirmedTileTypes;

   virtual tVoid vDestroy();
   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual tBool operator==(const weatherfi_tclMsgConfirmRasterTilePicturesMethodStart& rfoCmp) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   virtual tS32 s32GetTypeId() const { return weatherfi_tclToken::EN_MSG_CONFIRMRASTERTILEPICTURESMETHODSTART;}
};

class weatherfi_tclMsgConfirmRasterTilePicturesMethodResult : public fi_tclVisitableTypeBase, public fi_tclMessageBase
{
public:
   virtual tU16 u16GetServiceID() const;
   virtual tU16 u16GetFunctionID() const;
   virtual tU8  u8GetOpCode() const;
   virtual const fi_tclTypeBase& corfoGetTypeBase() const {return *this;};
   virtual fi_tclTypeBase& rfoGetTypeBase() {return *this;};
   weatherfi_tclMsgConfirmRasterTilePicturesMethodResult() {}
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   weatherfi_tclMsgConfirmRasterTilePicturesMethodResult& operator=(const weatherfi_tclMsgConfirmRasterTilePicturesMethodResult& coRef);
   weatherfi_tclMsgConfirmRasterTilePicturesMethodResult(const weatherfi_tclMsgConfirmRasterTilePicturesMethodResult& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
   std::vector<fi_tcl_TileIdentifier, std::allocator<fi_tcl_TileIdentifier> > ConfirmedTileTypes;

   virtual tVoid vDestroy();
   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual tBool operator==(const weatherfi_tclMsgConfirmRasterTilePicturesMethodResult& rfoCmp) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   virtual tS32 s32GetTypeId() const { return weatherfi_tclToken::EN_MSG_CONFIRMRASTERTILEPICTURESMETHODRESULT;}
};

class weatherfi_tclMsgCurrentWeatherDataChangedGet : public fi_tclVisitableTypeBase, public fi_tclMessageBase
{
public:
   virtual tU16 u16GetServiceID() const;
   virtual tU16 u16GetFunctionID() const;
   virtual tU8  u8GetOpCode() const;
   virtual const fi_tclTypeBase& corfoGetTypeBase() const {return *this;};
   virtual fi_tclTypeBase& rfoGetTypeBase() {return *this;};
   weatherfi_tclMsgCurrentWeatherDataChangedGet() {}
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   weatherfi_tclMsgCurrentWeatherDataChangedGet& operator=(const weatherfi_tclMsgCurrentWeatherDataChangedGet& coRef);
   weatherfi_tclMsgCurrentWeatherDataChangedGet(const weatherfi_tclMsgCurrentWeatherDataChangedGet& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual tBool operator==(const weatherfi_tclMsgCurrentWeatherDataChangedGet& rfoCmp) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   virtual tS32 s32GetTypeId() const { return weatherfi_tclToken::EN_MSG_CURRENTWEATHERDATACHANGEDGET;}
};

class weatherfi_tclMsgCurrentWeatherDataChangedUpReg : public fi_tclVisitableTypeBase, public fi_tclMessageBase
{
public:
   virtual tU16 u16GetServiceID() const;
   virtual tU16 u16GetFunctionID() const;
   virtual tU8  u8GetOpCode() const;
   virtual const fi_tclTypeBase& corfoGetTypeBase() const {return *this;};
   virtual fi_tclTypeBase& rfoGetTypeBase() {return *this;};
   weatherfi_tclMsgCurrentWeatherDataChangedUpReg() {}
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   weatherfi_tclMsgCurrentWeatherDataChangedUpReg& operator=(const weatherfi_tclMsgCurrentWeatherDataChangedUpReg& coRef);
   weatherfi_tclMsgCurrentWeatherDataChangedUpReg(const weatherfi_tclMsgCurrentWeatherDataChangedUpReg& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual tBool operator==(const weatherfi_tclMsgCurrentWeatherDataChangedUpReg& rfoCmp) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   virtual tS32 s32GetTypeId() const { return weatherfi_tclToken::EN_MSG_CURRENTWEATHERDATACHANGEDUPREG;}
};

class weatherfi_tclMsgCurrentWeatherDataChangedRelUpReg : public fi_tclVisitableTypeBase, public fi_tclMessageBase
{
public:
   virtual tU16 u16GetServiceID() const;
   virtual tU16 u16GetFunctionID() const;
   virtual tU8  u8GetOpCode() const;
   virtual const fi_tclTypeBase& corfoGetTypeBase() const {return *this;};
   virtual fi_tclTypeBase& rfoGetTypeBase() {return *this;};
   weatherfi_tclMsgCurrentWeatherDataChangedRelUpReg() {}
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   weatherfi_tclMsgCurrentWeatherDataChangedRelUpReg& operator=(const weatherfi_tclMsgCurrentWeatherDataChangedRelUpReg& coRef);
   weatherfi_tclMsgCurrentWeatherDataChangedRelUpReg(const weatherfi_tclMsgCurrentWeatherDataChangedRelUpReg& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual tBool operator==(const weatherfi_tclMsgCurrentWeatherDataChangedRelUpReg& rfoCmp) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   virtual tS32 s32GetTypeId() const { return weatherfi_tclToken::EN_MSG_CURRENTWEATHERDATACHANGEDRELUPREG;}
};

class weatherfi_tclMsgCurrentWeatherDataChangedStatus : public fi_tclVisitableTypeBase, public fi_tclMessageBase
{
public:
   virtual tU16 u16GetServiceID() const;
   virtual tU16 u16GetFunctionID() const;
   virtual tU8  u8GetOpCode() const;
   virtual const fi_tclTypeBase& corfoGetTypeBase() const {return *this;};
   virtual fi_tclTypeBase& rfoGetTypeBase() {return *this;};
   weatherfi_tclMsgCurrentWeatherDataChangedStatus():CurrentWeatherId(0) {}
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   weatherfi_tclMsgCurrentWeatherDataChangedStatus& operator=(const weatherfi_tclMsgCurrentWeatherDataChangedStatus& coRef);
   weatherfi_tclMsgCurrentWeatherDataChangedStatus(const weatherfi_tclMsgCurrentWeatherDataChangedStatus& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
   tU32 CurrentWeatherId;

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual tBool operator==(const weatherfi_tclMsgCurrentWeatherDataChangedStatus& rfoCmp) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   virtual tS32 s32GetTypeId() const { return weatherfi_tclToken::EN_MSG_CURRENTWEATHERDATACHANGEDSTATUS;}
};

class weatherfi_tclMsgWeatherForecastDataChangedGet : public fi_tclVisitableTypeBase, public fi_tclMessageBase
{
public:
   virtual tU16 u16GetServiceID() const;
   virtual tU16 u16GetFunctionID() const;
   virtual tU8  u8GetOpCode() const;
   virtual const fi_tclTypeBase& corfoGetTypeBase() const {return *this;};
   virtual fi_tclTypeBase& rfoGetTypeBase() {return *this;};
   weatherfi_tclMsgWeatherForecastDataChangedGet() {}
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   weatherfi_tclMsgWeatherForecastDataChangedGet& operator=(const weatherfi_tclMsgWeatherForecastDataChangedGet& coRef);
   weatherfi_tclMsgWeatherForecastDataChangedGet(const weatherfi_tclMsgWeatherForecastDataChangedGet& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual tBool operator==(const weatherfi_tclMsgWeatherForecastDataChangedGet& rfoCmp) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   virtual tS32 s32GetTypeId() const { return weatherfi_tclToken::EN_MSG_WEATHERFORECASTDATACHANGEDGET;}
};

class weatherfi_tclMsgWeatherForecastDataChangedUpReg : public fi_tclVisitableTypeBase, public fi_tclMessageBase
{
public:
   virtual tU16 u16GetServiceID() const;
   virtual tU16 u16GetFunctionID() const;
   virtual tU8  u8GetOpCode() const;
   virtual const fi_tclTypeBase& corfoGetTypeBase() const {return *this;};
   virtual fi_tclTypeBase& rfoGetTypeBase() {return *this;};
   weatherfi_tclMsgWeatherForecastDataChangedUpReg() {}
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   weatherfi_tclMsgWeatherForecastDataChangedUpReg& operator=(const weatherfi_tclMsgWeatherForecastDataChangedUpReg& coRef);
   weatherfi_tclMsgWeatherForecastDataChangedUpReg(const weatherfi_tclMsgWeatherForecastDataChangedUpReg& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual tBool operator==(const weatherfi_tclMsgWeatherForecastDataChangedUpReg& rfoCmp) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   virtual tS32 s32GetTypeId() const { return weatherfi_tclToken::EN_MSG_WEATHERFORECASTDATACHANGEDUPREG;}
};

class weatherfi_tclMsgWeatherForecastDataChangedRelUpReg : public fi_tclVisitableTypeBase, public fi_tclMessageBase
{
public:
   virtual tU16 u16GetServiceID() const;
   virtual tU16 u16GetFunctionID() const;
   virtual tU8  u8GetOpCode() const;
   virtual const fi_tclTypeBase& corfoGetTypeBase() const {return *this;};
   virtual fi_tclTypeBase& rfoGetTypeBase() {return *this;};
   weatherfi_tclMsgWeatherForecastDataChangedRelUpReg() {}
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   weatherfi_tclMsgWeatherForecastDataChangedRelUpReg& operator=(const weatherfi_tclMsgWeatherForecastDataChangedRelUpReg& coRef);
   weatherfi_tclMsgWeatherForecastDataChangedRelUpReg(const weatherfi_tclMsgWeatherForecastDataChangedRelUpReg& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual tBool operator==(const weatherfi_tclMsgWeatherForecastDataChangedRelUpReg& rfoCmp) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   virtual tS32 s32GetTypeId() const { return weatherfi_tclToken::EN_MSG_WEATHERFORECASTDATACHANGEDRELUPREG;}
};

class weatherfi_tclMsgWeatherForecastDataChangedStatus : public fi_tclVisitableTypeBase, public fi_tclMessageBase
{
public:
   virtual tU16 u16GetServiceID() const;
   virtual tU16 u16GetFunctionID() const;
   virtual tU8  u8GetOpCode() const;
   virtual const fi_tclTypeBase& corfoGetTypeBase() const {return *this;};
   virtual fi_tclTypeBase& rfoGetTypeBase() {return *this;};
   weatherfi_tclMsgWeatherForecastDataChangedStatus():WeatherForecastId(0) {}
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   weatherfi_tclMsgWeatherForecastDataChangedStatus& operator=(const weatherfi_tclMsgWeatherForecastDataChangedStatus& coRef);
   weatherfi_tclMsgWeatherForecastDataChangedStatus(const weatherfi_tclMsgWeatherForecastDataChangedStatus& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
   tU32 WeatherForecastId;

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual tBool operator==(const weatherfi_tclMsgWeatherForecastDataChangedStatus& rfoCmp) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   virtual tS32 s32GetTypeId() const { return weatherfi_tclToken::EN_MSG_WEATHERFORECASTDATACHANGEDSTATUS;}
};

class weatherfi_tclMsgCountyWarningDataChangedGet : public fi_tclVisitableTypeBase, public fi_tclMessageBase
{
public:
   virtual tU16 u16GetServiceID() const;
   virtual tU16 u16GetFunctionID() const;
   virtual tU8  u8GetOpCode() const;
   virtual const fi_tclTypeBase& corfoGetTypeBase() const {return *this;};
   virtual fi_tclTypeBase& rfoGetTypeBase() {return *this;};
   weatherfi_tclMsgCountyWarningDataChangedGet() {}
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   weatherfi_tclMsgCountyWarningDataChangedGet& operator=(const weatherfi_tclMsgCountyWarningDataChangedGet& coRef);
   weatherfi_tclMsgCountyWarningDataChangedGet(const weatherfi_tclMsgCountyWarningDataChangedGet& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual tBool operator==(const weatherfi_tclMsgCountyWarningDataChangedGet& rfoCmp) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   virtual tS32 s32GetTypeId() const { return weatherfi_tclToken::EN_MSG_COUNTYWARNINGDATACHANGEDGET;}
};

class weatherfi_tclMsgCountyWarningDataChangedUpReg : public fi_tclVisitableTypeBase, public fi_tclMessageBase
{
public:
   virtual tU16 u16GetServiceID() const;
   virtual tU16 u16GetFunctionID() const;
   virtual tU8  u8GetOpCode() const;
   virtual const fi_tclTypeBase& corfoGetTypeBase() const {return *this;};
   virtual fi_tclTypeBase& rfoGetTypeBase() {return *this;};
   weatherfi_tclMsgCountyWarningDataChangedUpReg() {}
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   weatherfi_tclMsgCountyWarningDataChangedUpReg& operator=(const weatherfi_tclMsgCountyWarningDataChangedUpReg& coRef);
   weatherfi_tclMsgCountyWarningDataChangedUpReg(const weatherfi_tclMsgCountyWarningDataChangedUpReg& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual tBool operator==(const weatherfi_tclMsgCountyWarningDataChangedUpReg& rfoCmp) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   virtual tS32 s32GetTypeId() const { return weatherfi_tclToken::EN_MSG_COUNTYWARNINGDATACHANGEDUPREG;}
};

class weatherfi_tclMsgCountyWarningDataChangedRelUpReg : public fi_tclVisitableTypeBase, public fi_tclMessageBase
{
public:
   virtual tU16 u16GetServiceID() const;
   virtual tU16 u16GetFunctionID() const;
   virtual tU8  u8GetOpCode() const;
   virtual const fi_tclTypeBase& corfoGetTypeBase() const {return *this;};
   virtual fi_tclTypeBase& rfoGetTypeBase() {return *this;};
   weatherfi_tclMsgCountyWarningDataChangedRelUpReg() {}
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   weatherfi_tclMsgCountyWarningDataChangedRelUpReg& operator=(const weatherfi_tclMsgCountyWarningDataChangedRelUpReg& coRef);
   weatherfi_tclMsgCountyWarningDataChangedRelUpReg(const weatherfi_tclMsgCountyWarningDataChangedRelUpReg& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual tBool operator==(const weatherfi_tclMsgCountyWarningDataChangedRelUpReg& rfoCmp) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   virtual tS32 s32GetTypeId() const { return weatherfi_tclToken::EN_MSG_COUNTYWARNINGDATACHANGEDRELUPREG;}
};

class weatherfi_tclMsgCountyWarningDataChangedStatus : public fi_tclVisitableTypeBase, public fi_tclMessageBase
{
public:
   virtual tU16 u16GetServiceID() const;
   virtual tU16 u16GetFunctionID() const;
   virtual tU8  u8GetOpCode() const;
   virtual const fi_tclTypeBase& corfoGetTypeBase() const {return *this;};
   virtual fi_tclTypeBase& rfoGetTypeBase() {return *this;};
   weatherfi_tclMsgCountyWarningDataChangedStatus():CountyWarningId(0),CountyWarningSubId(0),SubstantialChange(0) {}
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   weatherfi_tclMsgCountyWarningDataChangedStatus& operator=(const weatherfi_tclMsgCountyWarningDataChangedStatus& coRef);
   weatherfi_tclMsgCountyWarningDataChangedStatus(const weatherfi_tclMsgCountyWarningDataChangedStatus& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
   tU32 CountyWarningId;
   tU32 CountyWarningSubId;
   tBool SubstantialChange;

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual tBool operator==(const weatherfi_tclMsgCountyWarningDataChangedStatus& rfoCmp) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   virtual tS32 s32GetTypeId() const { return weatherfi_tclToken::EN_MSG_COUNTYWARNINGDATACHANGEDSTATUS;}
};

class weatherfi_tclMsgTabularWeatherDataGet : public fi_tclVisitableTypeBase, public fi_tclMessageBase
{
public:
   virtual tU16 u16GetServiceID() const;
   virtual tU16 u16GetFunctionID() const;
   virtual tU8  u8GetOpCode() const;
   virtual const fi_tclTypeBase& corfoGetTypeBase() const {return *this;};
   virtual fi_tclTypeBase& rfoGetTypeBase() {return *this;};
   weatherfi_tclMsgTabularWeatherDataGet() {}
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   weatherfi_tclMsgTabularWeatherDataGet& operator=(const weatherfi_tclMsgTabularWeatherDataGet& coRef);
   weatherfi_tclMsgTabularWeatherDataGet(const weatherfi_tclMsgTabularWeatherDataGet& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual tBool operator==(const weatherfi_tclMsgTabularWeatherDataGet& rfoCmp) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   virtual tS32 s32GetTypeId() const { return weatherfi_tclToken::EN_MSG_TABULARWEATHERDATAGET;}
};

class weatherfi_tclMsgTabularWeatherDataUpReg : public fi_tclVisitableTypeBase, public fi_tclMessageBase
{
public:
   virtual tU16 u16GetServiceID() const;
   virtual tU16 u16GetFunctionID() const;
   virtual tU8  u8GetOpCode() const;
   virtual const fi_tclTypeBase& corfoGetTypeBase() const {return *this;};
   virtual fi_tclTypeBase& rfoGetTypeBase() {return *this;};
   weatherfi_tclMsgTabularWeatherDataUpReg() {}
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   weatherfi_tclMsgTabularWeatherDataUpReg& operator=(const weatherfi_tclMsgTabularWeatherDataUpReg& coRef);
   weatherfi_tclMsgTabularWeatherDataUpReg(const weatherfi_tclMsgTabularWeatherDataUpReg& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual tBool operator==(const weatherfi_tclMsgTabularWeatherDataUpReg& rfoCmp) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   virtual tS32 s32GetTypeId() const { return weatherfi_tclToken::EN_MSG_TABULARWEATHERDATAUPREG;}
};

class weatherfi_tclMsgTabularWeatherDataRelUpReg : public fi_tclVisitableTypeBase, public fi_tclMessageBase
{
public:
   virtual tU16 u16GetServiceID() const;
   virtual tU16 u16GetFunctionID() const;
   virtual tU8  u8GetOpCode() const;
   virtual const fi_tclTypeBase& corfoGetTypeBase() const {return *this;};
   virtual fi_tclTypeBase& rfoGetTypeBase() {return *this;};
   weatherfi_tclMsgTabularWeatherDataRelUpReg() {}
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   weatherfi_tclMsgTabularWeatherDataRelUpReg& operator=(const weatherfi_tclMsgTabularWeatherDataRelUpReg& coRef);
   weatherfi_tclMsgTabularWeatherDataRelUpReg(const weatherfi_tclMsgTabularWeatherDataRelUpReg& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual tBool operator==(const weatherfi_tclMsgTabularWeatherDataRelUpReg& rfoCmp) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   virtual tS32 s32GetTypeId() const { return weatherfi_tclToken::EN_MSG_TABULARWEATHERDATARELUPREG;}
};

class weatherfi_tclMsgTabularWeatherDataStatus : public fi_tclVisitableTypeBase, public fi_tclMessageBase
{
public:
   virtual tU16 u16GetServiceID() const;
   virtual tU16 u16GetFunctionID() const;
   virtual tU8  u8GetOpCode() const;
   virtual const fi_tclTypeBase& corfoGetTypeBase() const {return *this;};
   virtual fi_tclTypeBase& rfoGetTypeBase() {return *this;};
   weatherfi_tclMsgTabularWeatherDataStatus() {}
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   weatherfi_tclMsgTabularWeatherDataStatus& operator=(const weatherfi_tclMsgTabularWeatherDataStatus& coRef);
   weatherfi_tclMsgTabularWeatherDataStatus(const weatherfi_tclMsgTabularWeatherDataStatus& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
   std::vector<fi_tcl_VersionPerForecast, std::allocator<fi_tcl_VersionPerForecast> > VersionsForForecasts;

   virtual tVoid vDestroy();
   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual tBool operator==(const weatherfi_tclMsgTabularWeatherDataStatus& rfoCmp) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   virtual tS32 s32GetTypeId() const { return weatherfi_tclToken::EN_MSG_TABULARWEATHERDATASTATUS;}
};

class weatherfi_tclMsgTabularWeatherSkiConditionDataGet : public fi_tclVisitableTypeBase, public fi_tclMessageBase
{
public:
   virtual tU16 u16GetServiceID() const;
   virtual tU16 u16GetFunctionID() const;
   virtual tU8  u8GetOpCode() const;
   virtual const fi_tclTypeBase& corfoGetTypeBase() const {return *this;};
   virtual fi_tclTypeBase& rfoGetTypeBase() {return *this;};
   weatherfi_tclMsgTabularWeatherSkiConditionDataGet() {}
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   weatherfi_tclMsgTabularWeatherSkiConditionDataGet& operator=(const weatherfi_tclMsgTabularWeatherSkiConditionDataGet& coRef);
   weatherfi_tclMsgTabularWeatherSkiConditionDataGet(const weatherfi_tclMsgTabularWeatherSkiConditionDataGet& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual tBool operator==(const weatherfi_tclMsgTabularWeatherSkiConditionDataGet& rfoCmp) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   virtual tS32 s32GetTypeId() const { return weatherfi_tclToken::EN_MSG_TABULARWEATHERSKICONDITIONDATAGET;}
};

class weatherfi_tclMsgTabularWeatherSkiConditionDataUpReg : public fi_tclVisitableTypeBase, public fi_tclMessageBase
{
public:
   virtual tU16 u16GetServiceID() const;
   virtual tU16 u16GetFunctionID() const;
   virtual tU8  u8GetOpCode() const;
   virtual const fi_tclTypeBase& corfoGetTypeBase() const {return *this;};
   virtual fi_tclTypeBase& rfoGetTypeBase() {return *this;};
   weatherfi_tclMsgTabularWeatherSkiConditionDataUpReg() {}
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   weatherfi_tclMsgTabularWeatherSkiConditionDataUpReg& operator=(const weatherfi_tclMsgTabularWeatherSkiConditionDataUpReg& coRef);
   weatherfi_tclMsgTabularWeatherSkiConditionDataUpReg(const weatherfi_tclMsgTabularWeatherSkiConditionDataUpReg& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual tBool operator==(const weatherfi_tclMsgTabularWeatherSkiConditionDataUpReg& rfoCmp) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   virtual tS32 s32GetTypeId() const { return weatherfi_tclToken::EN_MSG_TABULARWEATHERSKICONDITIONDATAUPREG;}
};

class weatherfi_tclMsgTabularWeatherSkiConditionDataRelUpReg : public fi_tclVisitableTypeBase, public fi_tclMessageBase
{
public:
   virtual tU16 u16GetServiceID() const;
   virtual tU16 u16GetFunctionID() const;
   virtual tU8  u8GetOpCode() const;
   virtual const fi_tclTypeBase& corfoGetTypeBase() const {return *this;};
   virtual fi_tclTypeBase& rfoGetTypeBase() {return *this;};
   weatherfi_tclMsgTabularWeatherSkiConditionDataRelUpReg() {}
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   weatherfi_tclMsgTabularWeatherSkiConditionDataRelUpReg& operator=(const weatherfi_tclMsgTabularWeatherSkiConditionDataRelUpReg& coRef);
   weatherfi_tclMsgTabularWeatherSkiConditionDataRelUpReg(const weatherfi_tclMsgTabularWeatherSkiConditionDataRelUpReg& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual tBool operator==(const weatherfi_tclMsgTabularWeatherSkiConditionDataRelUpReg& rfoCmp) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   virtual tS32 s32GetTypeId() const { return weatherfi_tclToken::EN_MSG_TABULARWEATHERSKICONDITIONDATARELUPREG;}
};

class weatherfi_tclMsgTabularWeatherSkiConditionDataStatus : public fi_tclVisitableTypeBase, public fi_tclMessageBase
{
public:
   virtual tU16 u16GetServiceID() const;
   virtual tU16 u16GetFunctionID() const;
   virtual tU8  u8GetOpCode() const;
   virtual const fi_tclTypeBase& corfoGetTypeBase() const {return *this;};
   virtual fi_tclTypeBase& rfoGetTypeBase() {return *this;};
   weatherfi_tclMsgTabularWeatherSkiConditionDataStatus():TabularWeatherSkConditionVersionId(0) {}
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   weatherfi_tclMsgTabularWeatherSkiConditionDataStatus& operator=(const weatherfi_tclMsgTabularWeatherSkiConditionDataStatus& coRef);
   weatherfi_tclMsgTabularWeatherSkiConditionDataStatus(const weatherfi_tclMsgTabularWeatherSkiConditionDataStatus& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
   tU32 TabularWeatherSkConditionVersionId;

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual tBool operator==(const weatherfi_tclMsgTabularWeatherSkiConditionDataStatus& rfoCmp) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   virtual tS32 s32GetTypeId() const { return weatherfi_tclToken::EN_MSG_TABULARWEATHERSKICONDITIONDATASTATUS;}
};

class weatherfi_tclMsgWeatherAlertDataGet : public fi_tclVisitableTypeBase, public fi_tclMessageBase
{
public:
   virtual tU16 u16GetServiceID() const;
   virtual tU16 u16GetFunctionID() const;
   virtual tU8  u8GetOpCode() const;
   virtual const fi_tclTypeBase& corfoGetTypeBase() const {return *this;};
   virtual fi_tclTypeBase& rfoGetTypeBase() {return *this;};
   weatherfi_tclMsgWeatherAlertDataGet() {}
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   weatherfi_tclMsgWeatherAlertDataGet& operator=(const weatherfi_tclMsgWeatherAlertDataGet& coRef);
   weatherfi_tclMsgWeatherAlertDataGet(const weatherfi_tclMsgWeatherAlertDataGet& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual tBool operator==(const weatherfi_tclMsgWeatherAlertDataGet& rfoCmp) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   virtual tS32 s32GetTypeId() const { return weatherfi_tclToken::EN_MSG_WEATHERALERTDATAGET;}
};

class weatherfi_tclMsgWeatherAlertDataUpReg : public fi_tclVisitableTypeBase, public fi_tclMessageBase
{
public:
   virtual tU16 u16GetServiceID() const;
   virtual tU16 u16GetFunctionID() const;
   virtual tU8  u8GetOpCode() const;
   virtual const fi_tclTypeBase& corfoGetTypeBase() const {return *this;};
   virtual fi_tclTypeBase& rfoGetTypeBase() {return *this;};
   weatherfi_tclMsgWeatherAlertDataUpReg() {}
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   weatherfi_tclMsgWeatherAlertDataUpReg& operator=(const weatherfi_tclMsgWeatherAlertDataUpReg& coRef);
   weatherfi_tclMsgWeatherAlertDataUpReg(const weatherfi_tclMsgWeatherAlertDataUpReg& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual tBool operator==(const weatherfi_tclMsgWeatherAlertDataUpReg& rfoCmp) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   virtual tS32 s32GetTypeId() const { return weatherfi_tclToken::EN_MSG_WEATHERALERTDATAUPREG;}
};

class weatherfi_tclMsgWeatherAlertDataRelUpReg : public fi_tclVisitableTypeBase, public fi_tclMessageBase
{
public:
   virtual tU16 u16GetServiceID() const;
   virtual tU16 u16GetFunctionID() const;
   virtual tU8  u8GetOpCode() const;
   virtual const fi_tclTypeBase& corfoGetTypeBase() const {return *this;};
   virtual fi_tclTypeBase& rfoGetTypeBase() {return *this;};
   weatherfi_tclMsgWeatherAlertDataRelUpReg() {}
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   weatherfi_tclMsgWeatherAlertDataRelUpReg& operator=(const weatherfi_tclMsgWeatherAlertDataRelUpReg& coRef);
   weatherfi_tclMsgWeatherAlertDataRelUpReg(const weatherfi_tclMsgWeatherAlertDataRelUpReg& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual tBool operator==(const weatherfi_tclMsgWeatherAlertDataRelUpReg& rfoCmp) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   virtual tS32 s32GetTypeId() const { return weatherfi_tclToken::EN_MSG_WEATHERALERTDATARELUPREG;}
};

class weatherfi_tclMsgWeatherAlertDataStatus : public fi_tclVisitableTypeBase, public fi_tclMessageBase
{
public:
   virtual tU16 u16GetServiceID() const;
   virtual tU16 u16GetFunctionID() const;
   virtual tU8  u8GetOpCode() const;
   virtual const fi_tclTypeBase& corfoGetTypeBase() const {return *this;};
   virtual fi_tclTypeBase& rfoGetTypeBase() {return *this;};
   weatherfi_tclMsgWeatherAlertDataStatus() {}
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   weatherfi_tclMsgWeatherAlertDataStatus& operator=(const weatherfi_tclMsgWeatherAlertDataStatus& coRef);
   weatherfi_tclMsgWeatherAlertDataStatus(const weatherfi_tclMsgWeatherAlertDataStatus& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
   std::vector<fi_tcl_StatesAndAreasPerLanguage, std::allocator<fi_tcl_StatesAndAreasPerLanguage> > StatesAndAreasPerLanguage;

   virtual tVoid vDestroy();
   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual tBool operator==(const weatherfi_tclMsgWeatherAlertDataStatus& rfoCmp) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   virtual tS32 s32GetTypeId() const { return weatherfi_tclToken::EN_MSG_WEATHERALERTDATASTATUS;}
};

class weatherfi_tclMsgGraphicalWeatherRasterTileSharedMemoryGet : public fi_tclVisitableTypeBase, public fi_tclMessageBase
{
public:
   virtual tU16 u16GetServiceID() const;
   virtual tU16 u16GetFunctionID() const;
   virtual tU8  u8GetOpCode() const;
   virtual const fi_tclTypeBase& corfoGetTypeBase() const {return *this;};
   virtual fi_tclTypeBase& rfoGetTypeBase() {return *this;};
   weatherfi_tclMsgGraphicalWeatherRasterTileSharedMemoryGet() {}
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   weatherfi_tclMsgGraphicalWeatherRasterTileSharedMemoryGet& operator=(const weatherfi_tclMsgGraphicalWeatherRasterTileSharedMemoryGet& coRef);
   weatherfi_tclMsgGraphicalWeatherRasterTileSharedMemoryGet(const weatherfi_tclMsgGraphicalWeatherRasterTileSharedMemoryGet& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual tBool operator==(const weatherfi_tclMsgGraphicalWeatherRasterTileSharedMemoryGet& rfoCmp) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   virtual tS32 s32GetTypeId() const { return weatherfi_tclToken::EN_MSG_GRAPHICALWEATHERRASTERTILESHAREDMEMORYGET;}
};

class weatherfi_tclMsgGraphicalWeatherRasterTileSharedMemoryUpReg : public fi_tclVisitableTypeBase, public fi_tclMessageBase
{
public:
   virtual tU16 u16GetServiceID() const;
   virtual tU16 u16GetFunctionID() const;
   virtual tU8  u8GetOpCode() const;
   virtual const fi_tclTypeBase& corfoGetTypeBase() const {return *this;};
   virtual fi_tclTypeBase& rfoGetTypeBase() {return *this;};
   weatherfi_tclMsgGraphicalWeatherRasterTileSharedMemoryUpReg() {}
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   weatherfi_tclMsgGraphicalWeatherRasterTileSharedMemoryUpReg& operator=(const weatherfi_tclMsgGraphicalWeatherRasterTileSharedMemoryUpReg& coRef);
   weatherfi_tclMsgGraphicalWeatherRasterTileSharedMemoryUpReg(const weatherfi_tclMsgGraphicalWeatherRasterTileSharedMemoryUpReg& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual tBool operator==(const weatherfi_tclMsgGraphicalWeatherRasterTileSharedMemoryUpReg& rfoCmp) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   virtual tS32 s32GetTypeId() const { return weatherfi_tclToken::EN_MSG_GRAPHICALWEATHERRASTERTILESHAREDMEMORYUPREG;}
};

class weatherfi_tclMsgGraphicalWeatherRasterTileSharedMemoryRelUpReg : public fi_tclVisitableTypeBase, public fi_tclMessageBase
{
public:
   virtual tU16 u16GetServiceID() const;
   virtual tU16 u16GetFunctionID() const;
   virtual tU8  u8GetOpCode() const;
   virtual const fi_tclTypeBase& corfoGetTypeBase() const {return *this;};
   virtual fi_tclTypeBase& rfoGetTypeBase() {return *this;};
   weatherfi_tclMsgGraphicalWeatherRasterTileSharedMemoryRelUpReg() {}
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   weatherfi_tclMsgGraphicalWeatherRasterTileSharedMemoryRelUpReg& operator=(const weatherfi_tclMsgGraphicalWeatherRasterTileSharedMemoryRelUpReg& coRef);
   weatherfi_tclMsgGraphicalWeatherRasterTileSharedMemoryRelUpReg(const weatherfi_tclMsgGraphicalWeatherRasterTileSharedMemoryRelUpReg& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual tBool operator==(const weatherfi_tclMsgGraphicalWeatherRasterTileSharedMemoryRelUpReg& rfoCmp) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   virtual tS32 s32GetTypeId() const { return weatherfi_tclToken::EN_MSG_GRAPHICALWEATHERRASTERTILESHAREDMEMORYRELUPREG;}
};

class weatherfi_tclMsgGraphicalWeatherRasterTileSharedMemoryStatus : public fi_tclVisitableTypeBase, public fi_tclMessageBase
{
public:
   virtual tU16 u16GetServiceID() const;
   virtual tU16 u16GetFunctionID() const;
   virtual tU8  u8GetOpCode() const;
   virtual const fi_tclTypeBase& corfoGetTypeBase() const {return *this;};
   virtual fi_tclTypeBase& rfoGetTypeBase() {return *this;};
   weatherfi_tclMsgGraphicalWeatherRasterTileSharedMemoryStatus():ProductType(),PictureType(),FormatVersion(),Open(0),SharedMemoryOverview() {}
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   weatherfi_tclMsgGraphicalWeatherRasterTileSharedMemoryStatus& operator=(const weatherfi_tclMsgGraphicalWeatherRasterTileSharedMemoryStatus& coRef);
   weatherfi_tclMsgGraphicalWeatherRasterTileSharedMemoryStatus(const weatherfi_tclMsgGraphicalWeatherRasterTileSharedMemoryStatus& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
   fi_tcl_e8_ProductType ProductType;
   fi_tcl_e8_PictureType PictureType;
   fi_tcl_e8_FormatVersion FormatVersion;
   tBool Open;
   fi_tcl_TileAndRasterPictureSharedMemory SharedMemoryOverview;

   virtual tVoid vDestroy();
   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual tBool operator==(const weatherfi_tclMsgGraphicalWeatherRasterTileSharedMemoryStatus& rfoCmp) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   virtual tS32 s32GetTypeId() const { return weatherfi_tclToken::EN_MSG_GRAPHICALWEATHERRASTERTILESHAREDMEMORYSTATUS;}
};

class weatherfi_tclMsgGraphicalWeatherRadarAnimationSharedMemoryGet : public fi_tclVisitableTypeBase, public fi_tclMessageBase
{
public:
   virtual tU16 u16GetServiceID() const;
   virtual tU16 u16GetFunctionID() const;
   virtual tU8  u8GetOpCode() const;
   virtual const fi_tclTypeBase& corfoGetTypeBase() const {return *this;};
   virtual fi_tclTypeBase& rfoGetTypeBase() {return *this;};
   weatherfi_tclMsgGraphicalWeatherRadarAnimationSharedMemoryGet() {}
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   weatherfi_tclMsgGraphicalWeatherRadarAnimationSharedMemoryGet& operator=(const weatherfi_tclMsgGraphicalWeatherRadarAnimationSharedMemoryGet& coRef);
   weatherfi_tclMsgGraphicalWeatherRadarAnimationSharedMemoryGet(const weatherfi_tclMsgGraphicalWeatherRadarAnimationSharedMemoryGet& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual tBool operator==(const weatherfi_tclMsgGraphicalWeatherRadarAnimationSharedMemoryGet& rfoCmp) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   virtual tS32 s32GetTypeId() const { return weatherfi_tclToken::EN_MSG_GRAPHICALWEATHERRADARANIMATIONSHAREDMEMORYGET;}
};

class weatherfi_tclMsgGraphicalWeatherRadarAnimationSharedMemoryUpReg : public fi_tclVisitableTypeBase, public fi_tclMessageBase
{
public:
   virtual tU16 u16GetServiceID() const;
   virtual tU16 u16GetFunctionID() const;
   virtual tU8  u8GetOpCode() const;
   virtual const fi_tclTypeBase& corfoGetTypeBase() const {return *this;};
   virtual fi_tclTypeBase& rfoGetTypeBase() {return *this;};
   weatherfi_tclMsgGraphicalWeatherRadarAnimationSharedMemoryUpReg() {}
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   weatherfi_tclMsgGraphicalWeatherRadarAnimationSharedMemoryUpReg& operator=(const weatherfi_tclMsgGraphicalWeatherRadarAnimationSharedMemoryUpReg& coRef);
   weatherfi_tclMsgGraphicalWeatherRadarAnimationSharedMemoryUpReg(const weatherfi_tclMsgGraphicalWeatherRadarAnimationSharedMemoryUpReg& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual tBool operator==(const weatherfi_tclMsgGraphicalWeatherRadarAnimationSharedMemoryUpReg& rfoCmp) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   virtual tS32 s32GetTypeId() const { return weatherfi_tclToken::EN_MSG_GRAPHICALWEATHERRADARANIMATIONSHAREDMEMORYUPREG;}
};

class weatherfi_tclMsgGraphicalWeatherRadarAnimationSharedMemoryRelUpReg : public fi_tclVisitableTypeBase, public fi_tclMessageBase
{
public:
   virtual tU16 u16GetServiceID() const;
   virtual tU16 u16GetFunctionID() const;
   virtual tU8  u8GetOpCode() const;
   virtual const fi_tclTypeBase& corfoGetTypeBase() const {return *this;};
   virtual fi_tclTypeBase& rfoGetTypeBase() {return *this;};
   weatherfi_tclMsgGraphicalWeatherRadarAnimationSharedMemoryRelUpReg() {}
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   weatherfi_tclMsgGraphicalWeatherRadarAnimationSharedMemoryRelUpReg& operator=(const weatherfi_tclMsgGraphicalWeatherRadarAnimationSharedMemoryRelUpReg& coRef);
   weatherfi_tclMsgGraphicalWeatherRadarAnimationSharedMemoryRelUpReg(const weatherfi_tclMsgGraphicalWeatherRadarAnimationSharedMemoryRelUpReg& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual tBool operator==(const weatherfi_tclMsgGraphicalWeatherRadarAnimationSharedMemoryRelUpReg& rfoCmp) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   virtual tS32 s32GetTypeId() const { return weatherfi_tclToken::EN_MSG_GRAPHICALWEATHERRADARANIMATIONSHAREDMEMORYRELUPREG;}
};

class weatherfi_tclMsgGraphicalWeatherRadarAnimationSharedMemoryStatus : public fi_tclVisitableTypeBase, public fi_tclMessageBase
{
public:
   virtual tU16 u16GetServiceID() const;
   virtual tU16 u16GetFunctionID() const;
   virtual tU8  u8GetOpCode() const;
   virtual const fi_tclTypeBase& corfoGetTypeBase() const {return *this;};
   virtual fi_tclTypeBase& rfoGetTypeBase() {return *this;};
   weatherfi_tclMsgGraphicalWeatherRadarAnimationSharedMemoryStatus():ProductType(),PictureType(),FormatVersion(),Open(0),SharedMemoryOverview() {}
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   weatherfi_tclMsgGraphicalWeatherRadarAnimationSharedMemoryStatus& operator=(const weatherfi_tclMsgGraphicalWeatherRadarAnimationSharedMemoryStatus& coRef);
   weatherfi_tclMsgGraphicalWeatherRadarAnimationSharedMemoryStatus(const weatherfi_tclMsgGraphicalWeatherRadarAnimationSharedMemoryStatus& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
   fi_tcl_e8_ProductType ProductType;
   fi_tcl_e8_PictureType PictureType;
   fi_tcl_e8_FormatVersion FormatVersion;
   tBool Open;
   fi_tcl_TileAndRasterPictureSharedMemory SharedMemoryOverview;

   virtual tVoid vDestroy();
   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual tBool operator==(const weatherfi_tclMsgGraphicalWeatherRadarAnimationSharedMemoryStatus& rfoCmp) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   virtual tS32 s32GetTypeId() const { return weatherfi_tclToken::EN_MSG_GRAPHICALWEATHERRADARANIMATIONSHAREDMEMORYSTATUS;}
};

class weatherfi_tclMsgGraphicalWeatherTilePictureDataGet : public fi_tclVisitableTypeBase, public fi_tclMessageBase
{
public:
   virtual tU16 u16GetServiceID() const;
   virtual tU16 u16GetFunctionID() const;
   virtual tU8  u8GetOpCode() const;
   virtual const fi_tclTypeBase& corfoGetTypeBase() const {return *this;};
   virtual fi_tclTypeBase& rfoGetTypeBase() {return *this;};
   weatherfi_tclMsgGraphicalWeatherTilePictureDataGet() {}
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   weatherfi_tclMsgGraphicalWeatherTilePictureDataGet& operator=(const weatherfi_tclMsgGraphicalWeatherTilePictureDataGet& coRef);
   weatherfi_tclMsgGraphicalWeatherTilePictureDataGet(const weatherfi_tclMsgGraphicalWeatherTilePictureDataGet& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual tBool operator==(const weatherfi_tclMsgGraphicalWeatherTilePictureDataGet& rfoCmp) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   virtual tS32 s32GetTypeId() const { return weatherfi_tclToken::EN_MSG_GRAPHICALWEATHERTILEPICTUREDATAGET;}
};

class weatherfi_tclMsgGraphicalWeatherTilePictureDataUpReg : public fi_tclVisitableTypeBase, public fi_tclMessageBase
{
public:
   virtual tU16 u16GetServiceID() const;
   virtual tU16 u16GetFunctionID() const;
   virtual tU8  u8GetOpCode() const;
   virtual const fi_tclTypeBase& corfoGetTypeBase() const {return *this;};
   virtual fi_tclTypeBase& rfoGetTypeBase() {return *this;};
   weatherfi_tclMsgGraphicalWeatherTilePictureDataUpReg() {}
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   weatherfi_tclMsgGraphicalWeatherTilePictureDataUpReg& operator=(const weatherfi_tclMsgGraphicalWeatherTilePictureDataUpReg& coRef);
   weatherfi_tclMsgGraphicalWeatherTilePictureDataUpReg(const weatherfi_tclMsgGraphicalWeatherTilePictureDataUpReg& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual tBool operator==(const weatherfi_tclMsgGraphicalWeatherTilePictureDataUpReg& rfoCmp) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   virtual tS32 s32GetTypeId() const { return weatherfi_tclToken::EN_MSG_GRAPHICALWEATHERTILEPICTUREDATAUPREG;}
};

class weatherfi_tclMsgGraphicalWeatherTilePictureDataRelUpReg : public fi_tclVisitableTypeBase, public fi_tclMessageBase
{
public:
   virtual tU16 u16GetServiceID() const;
   virtual tU16 u16GetFunctionID() const;
   virtual tU8  u8GetOpCode() const;
   virtual const fi_tclTypeBase& corfoGetTypeBase() const {return *this;};
   virtual fi_tclTypeBase& rfoGetTypeBase() {return *this;};
   weatherfi_tclMsgGraphicalWeatherTilePictureDataRelUpReg() {}
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   weatherfi_tclMsgGraphicalWeatherTilePictureDataRelUpReg& operator=(const weatherfi_tclMsgGraphicalWeatherTilePictureDataRelUpReg& coRef);
   weatherfi_tclMsgGraphicalWeatherTilePictureDataRelUpReg(const weatherfi_tclMsgGraphicalWeatherTilePictureDataRelUpReg& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual tBool operator==(const weatherfi_tclMsgGraphicalWeatherTilePictureDataRelUpReg& rfoCmp) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   virtual tS32 s32GetTypeId() const { return weatherfi_tclToken::EN_MSG_GRAPHICALWEATHERTILEPICTUREDATARELUPREG;}
};

class weatherfi_tclMsgGraphicalWeatherTilePictureDataStatus : public fi_tclVisitableTypeBase, public fi_tclMessageBase
{
public:
   virtual tU16 u16GetServiceID() const;
   virtual tU16 u16GetFunctionID() const;
   virtual tU8  u8GetOpCode() const;
   virtual const fi_tclTypeBase& corfoGetTypeBase() const {return *this;};
   virtual fi_tclTypeBase& rfoGetTypeBase() {return *this;};
   weatherfi_tclMsgGraphicalWeatherTilePictureDataStatus():ProductType(),PictureType() {}
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   weatherfi_tclMsgGraphicalWeatherTilePictureDataStatus& operator=(const weatherfi_tclMsgGraphicalWeatherTilePictureDataStatus& coRef);
   weatherfi_tclMsgGraphicalWeatherTilePictureDataStatus(const weatherfi_tclMsgGraphicalWeatherTilePictureDataStatus& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
   fi_tcl_e8_ProductType ProductType;
   fi_tcl_e8_PictureType PictureType;
   std::vector<fi_tcl_VersionsOfTile, std::allocator<fi_tcl_VersionsOfTile> > UsedTiles;
   std::vector<fi_tcl_VersionsOfTile, std::allocator<fi_tcl_VersionsOfTile> > BackgroundTiles;
   std::vector<fi_tcl_GraphicalWeatherTilePicture, std::allocator<fi_tcl_GraphicalWeatherTilePicture> > PresentedPictures;

   virtual tVoid vDestroy();
   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual tBool operator==(const weatherfi_tclMsgGraphicalWeatherTilePictureDataStatus& rfoCmp) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   virtual tS32 s32GetTypeId() const { return weatherfi_tclToken::EN_MSG_GRAPHICALWEATHERTILEPICTUREDATASTATUS;}
};

class weatherfi_tclMsgGraphicalWeatherRadarAnimationPictureDataGet : public fi_tclVisitableTypeBase, public fi_tclMessageBase
{
public:
   virtual tU16 u16GetServiceID() const;
   virtual tU16 u16GetFunctionID() const;
   virtual tU8  u8GetOpCode() const;
   virtual const fi_tclTypeBase& corfoGetTypeBase() const {return *this;};
   virtual fi_tclTypeBase& rfoGetTypeBase() {return *this;};
   weatherfi_tclMsgGraphicalWeatherRadarAnimationPictureDataGet() {}
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   weatherfi_tclMsgGraphicalWeatherRadarAnimationPictureDataGet& operator=(const weatherfi_tclMsgGraphicalWeatherRadarAnimationPictureDataGet& coRef);
   weatherfi_tclMsgGraphicalWeatherRadarAnimationPictureDataGet(const weatherfi_tclMsgGraphicalWeatherRadarAnimationPictureDataGet& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual tBool operator==(const weatherfi_tclMsgGraphicalWeatherRadarAnimationPictureDataGet& rfoCmp) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   virtual tS32 s32GetTypeId() const { return weatherfi_tclToken::EN_MSG_GRAPHICALWEATHERRADARANIMATIONPICTUREDATAGET;}
};

class weatherfi_tclMsgGraphicalWeatherRadarAnimationPictureDataUpReg : public fi_tclVisitableTypeBase, public fi_tclMessageBase
{
public:
   virtual tU16 u16GetServiceID() const;
   virtual tU16 u16GetFunctionID() const;
   virtual tU8  u8GetOpCode() const;
   virtual const fi_tclTypeBase& corfoGetTypeBase() const {return *this;};
   virtual fi_tclTypeBase& rfoGetTypeBase() {return *this;};
   weatherfi_tclMsgGraphicalWeatherRadarAnimationPictureDataUpReg() {}
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   weatherfi_tclMsgGraphicalWeatherRadarAnimationPictureDataUpReg& operator=(const weatherfi_tclMsgGraphicalWeatherRadarAnimationPictureDataUpReg& coRef);
   weatherfi_tclMsgGraphicalWeatherRadarAnimationPictureDataUpReg(const weatherfi_tclMsgGraphicalWeatherRadarAnimationPictureDataUpReg& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual tBool operator==(const weatherfi_tclMsgGraphicalWeatherRadarAnimationPictureDataUpReg& rfoCmp) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   virtual tS32 s32GetTypeId() const { return weatherfi_tclToken::EN_MSG_GRAPHICALWEATHERRADARANIMATIONPICTUREDATAUPREG;}
};

class weatherfi_tclMsgGraphicalWeatherRadarAnimationPictureDataRelUpReg : public fi_tclVisitableTypeBase, public fi_tclMessageBase
{
public:
   virtual tU16 u16GetServiceID() const;
   virtual tU16 u16GetFunctionID() const;
   virtual tU8  u8GetOpCode() const;
   virtual const fi_tclTypeBase& corfoGetTypeBase() const {return *this;};
   virtual fi_tclTypeBase& rfoGetTypeBase() {return *this;};
   weatherfi_tclMsgGraphicalWeatherRadarAnimationPictureDataRelUpReg() {}
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   weatherfi_tclMsgGraphicalWeatherRadarAnimationPictureDataRelUpReg& operator=(const weatherfi_tclMsgGraphicalWeatherRadarAnimationPictureDataRelUpReg& coRef);
   weatherfi_tclMsgGraphicalWeatherRadarAnimationPictureDataRelUpReg(const weatherfi_tclMsgGraphicalWeatherRadarAnimationPictureDataRelUpReg& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual tBool operator==(const weatherfi_tclMsgGraphicalWeatherRadarAnimationPictureDataRelUpReg& rfoCmp) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   virtual tS32 s32GetTypeId() const { return weatherfi_tclToken::EN_MSG_GRAPHICALWEATHERRADARANIMATIONPICTUREDATARELUPREG;}
};

class weatherfi_tclMsgGraphicalWeatherRadarAnimationPictureDataStatus : public fi_tclVisitableTypeBase, public fi_tclMessageBase
{
public:
   virtual tU16 u16GetServiceID() const;
   virtual tU16 u16GetFunctionID() const;
   virtual tU8  u8GetOpCode() const;
   virtual const fi_tclTypeBase& corfoGetTypeBase() const {return *this;};
   virtual fi_tclTypeBase& rfoGetTypeBase() {return *this;};
   weatherfi_tclMsgGraphicalWeatherRadarAnimationPictureDataStatus():ProductType(),PictureType() {}
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   weatherfi_tclMsgGraphicalWeatherRadarAnimationPictureDataStatus& operator=(const weatherfi_tclMsgGraphicalWeatherRadarAnimationPictureDataStatus& coRef);
   weatherfi_tclMsgGraphicalWeatherRadarAnimationPictureDataStatus(const weatherfi_tclMsgGraphicalWeatherRadarAnimationPictureDataStatus& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
   fi_tcl_e8_ProductType ProductType;
   fi_tcl_e8_PictureType PictureType;
   std::vector<fi_tcl_VersionsOfTile, std::allocator<fi_tcl_VersionsOfTile> > UsedTiles;
   std::vector<fi_tcl_VersionsOfTile, std::allocator<fi_tcl_VersionsOfTile> > BackgroundTiles;
   std::vector<fi_tcl_GraphicalWeatherTilePicture, std::allocator<fi_tcl_GraphicalWeatherTilePicture> > PresentedPictures;

   virtual tVoid vDestroy();
   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual tBool operator==(const weatherfi_tclMsgGraphicalWeatherRadarAnimationPictureDataStatus& rfoCmp) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   virtual tS32 s32GetTypeId() const { return weatherfi_tclToken::EN_MSG_GRAPHICALWEATHERRADARANIMATIONPICTUREDATASTATUS;}
};

class weatherfi_tclMsgSurfaceDataUpReg : public fi_tclVisitableTypeBase, public fi_tclMessageBase
{
public:
   virtual tU16 u16GetServiceID() const;
   virtual tU16 u16GetFunctionID() const;
   virtual tU8  u8GetOpCode() const;
   virtual const fi_tclTypeBase& corfoGetTypeBase() const {return *this;};
   virtual fi_tclTypeBase& rfoGetTypeBase() {return *this;};
   weatherfi_tclMsgSurfaceDataUpReg() {}
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   weatherfi_tclMsgSurfaceDataUpReg& operator=(const weatherfi_tclMsgSurfaceDataUpReg& coRef);
   weatherfi_tclMsgSurfaceDataUpReg(const weatherfi_tclMsgSurfaceDataUpReg& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual tBool operator==(const weatherfi_tclMsgSurfaceDataUpReg& rfoCmp) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   virtual tS32 s32GetTypeId() const { return weatherfi_tclToken::EN_MSG_SURFACEDATAUPREG;}
};

class weatherfi_tclMsgSurfaceDataRelUpReg : public fi_tclVisitableTypeBase, public fi_tclMessageBase
{
public:
   virtual tU16 u16GetServiceID() const;
   virtual tU16 u16GetFunctionID() const;
   virtual tU8  u8GetOpCode() const;
   virtual const fi_tclTypeBase& corfoGetTypeBase() const {return *this;};
   virtual fi_tclTypeBase& rfoGetTypeBase() {return *this;};
   weatherfi_tclMsgSurfaceDataRelUpReg() {}
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   weatherfi_tclMsgSurfaceDataRelUpReg& operator=(const weatherfi_tclMsgSurfaceDataRelUpReg& coRef);
   weatherfi_tclMsgSurfaceDataRelUpReg(const weatherfi_tclMsgSurfaceDataRelUpReg& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual tBool operator==(const weatherfi_tclMsgSurfaceDataRelUpReg& rfoCmp) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   virtual tS32 s32GetTypeId() const { return weatherfi_tclToken::EN_MSG_SURFACEDATARELUPREG;}
};

class weatherfi_tclMsgSurfaceDataGet : public fi_tclVisitableTypeBase, public fi_tclMessageBase
{
public:
   virtual tU16 u16GetServiceID() const;
   virtual tU16 u16GetFunctionID() const;
   virtual tU8  u8GetOpCode() const;
   virtual const fi_tclTypeBase& corfoGetTypeBase() const {return *this;};
   virtual fi_tclTypeBase& rfoGetTypeBase() {return *this;};
   weatherfi_tclMsgSurfaceDataGet() {}
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   weatherfi_tclMsgSurfaceDataGet& operator=(const weatherfi_tclMsgSurfaceDataGet& coRef);
   weatherfi_tclMsgSurfaceDataGet(const weatherfi_tclMsgSurfaceDataGet& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual tBool operator==(const weatherfi_tclMsgSurfaceDataGet& rfoCmp) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   virtual tS32 s32GetTypeId() const { return weatherfi_tclToken::EN_MSG_SURFACEDATAGET;}
};

class weatherfi_tclMsgSurfaceDataStatus : public fi_tclVisitableTypeBase, public fi_tclMessageBase
{
public:
   virtual tU16 u16GetServiceID() const;
   virtual tU16 u16GetFunctionID() const;
   virtual tU8  u8GetOpCode() const;
   virtual const fi_tclTypeBase& corfoGetTypeBase() const {return *this;};
   virtual fi_tclTypeBase& rfoGetTypeBase() {return *this;};
   weatherfi_tclMsgSurfaceDataStatus():UpdateCounter(0) {}
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   weatherfi_tclMsgSurfaceDataStatus& operator=(const weatherfi_tclMsgSurfaceDataStatus& coRef);
   weatherfi_tclMsgSurfaceDataStatus(const weatherfi_tclMsgSurfaceDataStatus& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
   tU32 UpdateCounter;

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual tBool operator==(const weatherfi_tclMsgSurfaceDataStatus& rfoCmp) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   virtual tS32 s32GetTypeId() const { return weatherfi_tclToken::EN_MSG_SURFACEDATASTATUS;}
};

class weatherfi_tclMsgStormAttributesDataUpReg : public fi_tclVisitableTypeBase, public fi_tclMessageBase
{
public:
   virtual tU16 u16GetServiceID() const;
   virtual tU16 u16GetFunctionID() const;
   virtual tU8  u8GetOpCode() const;
   virtual const fi_tclTypeBase& corfoGetTypeBase() const {return *this;};
   virtual fi_tclTypeBase& rfoGetTypeBase() {return *this;};
   weatherfi_tclMsgStormAttributesDataUpReg() {}
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   weatherfi_tclMsgStormAttributesDataUpReg& operator=(const weatherfi_tclMsgStormAttributesDataUpReg& coRef);
   weatherfi_tclMsgStormAttributesDataUpReg(const weatherfi_tclMsgStormAttributesDataUpReg& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual tBool operator==(const weatherfi_tclMsgStormAttributesDataUpReg& rfoCmp) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   virtual tS32 s32GetTypeId() const { return weatherfi_tclToken::EN_MSG_STORMATTRIBUTESDATAUPREG;}
};

class weatherfi_tclMsgStormAttributesDataRelUpReg : public fi_tclVisitableTypeBase, public fi_tclMessageBase
{
public:
   virtual tU16 u16GetServiceID() const;
   virtual tU16 u16GetFunctionID() const;
   virtual tU8  u8GetOpCode() const;
   virtual const fi_tclTypeBase& corfoGetTypeBase() const {return *this;};
   virtual fi_tclTypeBase& rfoGetTypeBase() {return *this;};
   weatherfi_tclMsgStormAttributesDataRelUpReg() {}
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   weatherfi_tclMsgStormAttributesDataRelUpReg& operator=(const weatherfi_tclMsgStormAttributesDataRelUpReg& coRef);
   weatherfi_tclMsgStormAttributesDataRelUpReg(const weatherfi_tclMsgStormAttributesDataRelUpReg& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual tBool operator==(const weatherfi_tclMsgStormAttributesDataRelUpReg& rfoCmp) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   virtual tS32 s32GetTypeId() const { return weatherfi_tclToken::EN_MSG_STORMATTRIBUTESDATARELUPREG;}
};

class weatherfi_tclMsgStormAttributesDataGet : public fi_tclVisitableTypeBase, public fi_tclMessageBase
{
public:
   virtual tU16 u16GetServiceID() const;
   virtual tU16 u16GetFunctionID() const;
   virtual tU8  u8GetOpCode() const;
   virtual const fi_tclTypeBase& corfoGetTypeBase() const {return *this;};
   virtual fi_tclTypeBase& rfoGetTypeBase() {return *this;};
   weatherfi_tclMsgStormAttributesDataGet() {}
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   weatherfi_tclMsgStormAttributesDataGet& operator=(const weatherfi_tclMsgStormAttributesDataGet& coRef);
   weatherfi_tclMsgStormAttributesDataGet(const weatherfi_tclMsgStormAttributesDataGet& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual tBool operator==(const weatherfi_tclMsgStormAttributesDataGet& rfoCmp) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   virtual tS32 s32GetTypeId() const { return weatherfi_tclToken::EN_MSG_STORMATTRIBUTESDATAGET;}
};

class weatherfi_tclMsgStormAttributesDataStatus : public fi_tclVisitableTypeBase, public fi_tclMessageBase
{
public:
   virtual tU16 u16GetServiceID() const;
   virtual tU16 u16GetFunctionID() const;
   virtual tU8  u8GetOpCode() const;
   virtual const fi_tclTypeBase& corfoGetTypeBase() const {return *this;};
   virtual fi_tclTypeBase& rfoGetTypeBase() {return *this;};
   weatherfi_tclMsgStormAttributesDataStatus():UpdateCounter(0) {}
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   weatherfi_tclMsgStormAttributesDataStatus& operator=(const weatherfi_tclMsgStormAttributesDataStatus& coRef);
   weatherfi_tclMsgStormAttributesDataStatus(const weatherfi_tclMsgStormAttributesDataStatus& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
   tU32 UpdateCounter;

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual tBool operator==(const weatherfi_tclMsgStormAttributesDataStatus& rfoCmp) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   virtual tS32 s32GetTypeId() const { return weatherfi_tclToken::EN_MSG_STORMATTRIBUTESDATASTATUS;}
};

class weatherfi_tclMsgStormTrackDataUpReg : public fi_tclVisitableTypeBase, public fi_tclMessageBase
{
public:
   virtual tU16 u16GetServiceID() const;
   virtual tU16 u16GetFunctionID() const;
   virtual tU8  u8GetOpCode() const;
   virtual const fi_tclTypeBase& corfoGetTypeBase() const {return *this;};
   virtual fi_tclTypeBase& rfoGetTypeBase() {return *this;};
   weatherfi_tclMsgStormTrackDataUpReg() {}
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   weatherfi_tclMsgStormTrackDataUpReg& operator=(const weatherfi_tclMsgStormTrackDataUpReg& coRef);
   weatherfi_tclMsgStormTrackDataUpReg(const weatherfi_tclMsgStormTrackDataUpReg& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual tBool operator==(const weatherfi_tclMsgStormTrackDataUpReg& rfoCmp) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   virtual tS32 s32GetTypeId() const { return weatherfi_tclToken::EN_MSG_STORMTRACKDATAUPREG;}
};

class weatherfi_tclMsgStormTrackDataRelUpReg : public fi_tclVisitableTypeBase, public fi_tclMessageBase
{
public:
   virtual tU16 u16GetServiceID() const;
   virtual tU16 u16GetFunctionID() const;
   virtual tU8  u8GetOpCode() const;
   virtual const fi_tclTypeBase& corfoGetTypeBase() const {return *this;};
   virtual fi_tclTypeBase& rfoGetTypeBase() {return *this;};
   weatherfi_tclMsgStormTrackDataRelUpReg() {}
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   weatherfi_tclMsgStormTrackDataRelUpReg& operator=(const weatherfi_tclMsgStormTrackDataRelUpReg& coRef);
   weatherfi_tclMsgStormTrackDataRelUpReg(const weatherfi_tclMsgStormTrackDataRelUpReg& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual tBool operator==(const weatherfi_tclMsgStormTrackDataRelUpReg& rfoCmp) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   virtual tS32 s32GetTypeId() const { return weatherfi_tclToken::EN_MSG_STORMTRACKDATARELUPREG;}
};

class weatherfi_tclMsgStormTrackDataGet : public fi_tclVisitableTypeBase, public fi_tclMessageBase
{
public:
   virtual tU16 u16GetServiceID() const;
   virtual tU16 u16GetFunctionID() const;
   virtual tU8  u8GetOpCode() const;
   virtual const fi_tclTypeBase& corfoGetTypeBase() const {return *this;};
   virtual fi_tclTypeBase& rfoGetTypeBase() {return *this;};
   weatherfi_tclMsgStormTrackDataGet() {}
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   weatherfi_tclMsgStormTrackDataGet& operator=(const weatherfi_tclMsgStormTrackDataGet& coRef);
   weatherfi_tclMsgStormTrackDataGet(const weatherfi_tclMsgStormTrackDataGet& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual tBool operator==(const weatherfi_tclMsgStormTrackDataGet& rfoCmp) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   virtual tS32 s32GetTypeId() const { return weatherfi_tclToken::EN_MSG_STORMTRACKDATAGET;}
};

class weatherfi_tclMsgStormTrackDataStatus : public fi_tclVisitableTypeBase, public fi_tclMessageBase
{
public:
   virtual tU16 u16GetServiceID() const;
   virtual tU16 u16GetFunctionID() const;
   virtual tU8  u8GetOpCode() const;
   virtual const fi_tclTypeBase& corfoGetTypeBase() const {return *this;};
   virtual fi_tclTypeBase& rfoGetTypeBase() {return *this;};
   weatherfi_tclMsgStormTrackDataStatus():UpdateCounter(0) {}
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   weatherfi_tclMsgStormTrackDataStatus& operator=(const weatherfi_tclMsgStormTrackDataStatus& coRef);
   weatherfi_tclMsgStormTrackDataStatus(const weatherfi_tclMsgStormTrackDataStatus& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
   tU32 UpdateCounter;

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual tBool operator==(const weatherfi_tclMsgStormTrackDataStatus& rfoCmp) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   virtual tS32 s32GetTypeId() const { return weatherfi_tclToken::EN_MSG_STORMTRACKDATASTATUS;}
};

class weatherfi_tclMsgRasterTileSharedMemoriesGet : public fi_tclVisitableTypeBase, public fi_tclMessageBase
{
public:
   virtual tU16 u16GetServiceID() const;
   virtual tU16 u16GetFunctionID() const;
   virtual tU8  u8GetOpCode() const;
   virtual const fi_tclTypeBase& corfoGetTypeBase() const {return *this;};
   virtual fi_tclTypeBase& rfoGetTypeBase() {return *this;};
   weatherfi_tclMsgRasterTileSharedMemoriesGet() {}
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   weatherfi_tclMsgRasterTileSharedMemoriesGet& operator=(const weatherfi_tclMsgRasterTileSharedMemoriesGet& coRef);
   weatherfi_tclMsgRasterTileSharedMemoriesGet(const weatherfi_tclMsgRasterTileSharedMemoriesGet& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual tBool operator==(const weatherfi_tclMsgRasterTileSharedMemoriesGet& rfoCmp) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   virtual tS32 s32GetTypeId() const { return weatherfi_tclToken::EN_MSG_RASTERTILESHAREDMEMORIESGET;}
};

class weatherfi_tclMsgRasterTileSharedMemoriesUpReg : public fi_tclVisitableTypeBase, public fi_tclMessageBase
{
public:
   virtual tU16 u16GetServiceID() const;
   virtual tU16 u16GetFunctionID() const;
   virtual tU8  u8GetOpCode() const;
   virtual const fi_tclTypeBase& corfoGetTypeBase() const {return *this;};
   virtual fi_tclTypeBase& rfoGetTypeBase() {return *this;};
   weatherfi_tclMsgRasterTileSharedMemoriesUpReg() {}
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   weatherfi_tclMsgRasterTileSharedMemoriesUpReg& operator=(const weatherfi_tclMsgRasterTileSharedMemoriesUpReg& coRef);
   weatherfi_tclMsgRasterTileSharedMemoriesUpReg(const weatherfi_tclMsgRasterTileSharedMemoriesUpReg& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual tBool operator==(const weatherfi_tclMsgRasterTileSharedMemoriesUpReg& rfoCmp) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   virtual tS32 s32GetTypeId() const { return weatherfi_tclToken::EN_MSG_RASTERTILESHAREDMEMORIESUPREG;}
};

class weatherfi_tclMsgRasterTileSharedMemoriesRelUpReg : public fi_tclVisitableTypeBase, public fi_tclMessageBase
{
public:
   virtual tU16 u16GetServiceID() const;
   virtual tU16 u16GetFunctionID() const;
   virtual tU8  u8GetOpCode() const;
   virtual const fi_tclTypeBase& corfoGetTypeBase() const {return *this;};
   virtual fi_tclTypeBase& rfoGetTypeBase() {return *this;};
   weatherfi_tclMsgRasterTileSharedMemoriesRelUpReg() {}
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   weatherfi_tclMsgRasterTileSharedMemoriesRelUpReg& operator=(const weatherfi_tclMsgRasterTileSharedMemoriesRelUpReg& coRef);
   weatherfi_tclMsgRasterTileSharedMemoriesRelUpReg(const weatherfi_tclMsgRasterTileSharedMemoriesRelUpReg& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual tBool operator==(const weatherfi_tclMsgRasterTileSharedMemoriesRelUpReg& rfoCmp) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   virtual tS32 s32GetTypeId() const { return weatherfi_tclToken::EN_MSG_RASTERTILESHAREDMEMORIESRELUPREG;}
};

class weatherfi_tclMsgRasterTileSharedMemoriesStatus : public fi_tclVisitableTypeBase, public fi_tclMessageBase
{
public:
   virtual tU16 u16GetServiceID() const;
   virtual tU16 u16GetFunctionID() const;
   virtual tU8  u8GetOpCode() const;
   virtual const fi_tclTypeBase& corfoGetTypeBase() const {return *this;};
   virtual fi_tclTypeBase& rfoGetTypeBase() {return *this;};
   weatherfi_tclMsgRasterTileSharedMemoriesStatus() {}
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   weatherfi_tclMsgRasterTileSharedMemoriesStatus& operator=(const weatherfi_tclMsgRasterTileSharedMemoriesStatus& coRef);
   weatherfi_tclMsgRasterTileSharedMemoriesStatus(const weatherfi_tclMsgRasterTileSharedMemoriesStatus& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
   std::vector<fi_tcl_WeatherSharedMemoryDescription, std::allocator<fi_tcl_WeatherSharedMemoryDescription> > SharedMemories;

   virtual tVoid vDestroy();
   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual tBool operator==(const weatherfi_tclMsgRasterTileSharedMemoriesStatus& rfoCmp) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   virtual tS32 s32GetTypeId() const { return weatherfi_tclToken::EN_MSG_RASTERTILESHAREDMEMORIESSTATUS;}
};

class weatherfi_tclMsgRadarStaticPictureDataGet : public fi_tclVisitableTypeBase, public fi_tclMessageBase
{
public:
   virtual tU16 u16GetServiceID() const;
   virtual tU16 u16GetFunctionID() const;
   virtual tU8  u8GetOpCode() const;
   virtual const fi_tclTypeBase& corfoGetTypeBase() const {return *this;};
   virtual fi_tclTypeBase& rfoGetTypeBase() {return *this;};
   weatherfi_tclMsgRadarStaticPictureDataGet() {}
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   weatherfi_tclMsgRadarStaticPictureDataGet& operator=(const weatherfi_tclMsgRadarStaticPictureDataGet& coRef);
   weatherfi_tclMsgRadarStaticPictureDataGet(const weatherfi_tclMsgRadarStaticPictureDataGet& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual tBool operator==(const weatherfi_tclMsgRadarStaticPictureDataGet& rfoCmp) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   virtual tS32 s32GetTypeId() const { return weatherfi_tclToken::EN_MSG_RADARSTATICPICTUREDATAGET;}
};

class weatherfi_tclMsgRadarStaticPictureDataUpReg : public fi_tclVisitableTypeBase, public fi_tclMessageBase
{
public:
   virtual tU16 u16GetServiceID() const;
   virtual tU16 u16GetFunctionID() const;
   virtual tU8  u8GetOpCode() const;
   virtual const fi_tclTypeBase& corfoGetTypeBase() const {return *this;};
   virtual fi_tclTypeBase& rfoGetTypeBase() {return *this;};
   weatherfi_tclMsgRadarStaticPictureDataUpReg() {}
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   weatherfi_tclMsgRadarStaticPictureDataUpReg& operator=(const weatherfi_tclMsgRadarStaticPictureDataUpReg& coRef);
   weatherfi_tclMsgRadarStaticPictureDataUpReg(const weatherfi_tclMsgRadarStaticPictureDataUpReg& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual tBool operator==(const weatherfi_tclMsgRadarStaticPictureDataUpReg& rfoCmp) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   virtual tS32 s32GetTypeId() const { return weatherfi_tclToken::EN_MSG_RADARSTATICPICTUREDATAUPREG;}
};

class weatherfi_tclMsgRadarStaticPictureDataRelUpReg : public fi_tclVisitableTypeBase, public fi_tclMessageBase
{
public:
   virtual tU16 u16GetServiceID() const;
   virtual tU16 u16GetFunctionID() const;
   virtual tU8  u8GetOpCode() const;
   virtual const fi_tclTypeBase& corfoGetTypeBase() const {return *this;};
   virtual fi_tclTypeBase& rfoGetTypeBase() {return *this;};
   weatherfi_tclMsgRadarStaticPictureDataRelUpReg() {}
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   weatherfi_tclMsgRadarStaticPictureDataRelUpReg& operator=(const weatherfi_tclMsgRadarStaticPictureDataRelUpReg& coRef);
   weatherfi_tclMsgRadarStaticPictureDataRelUpReg(const weatherfi_tclMsgRadarStaticPictureDataRelUpReg& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual tBool operator==(const weatherfi_tclMsgRadarStaticPictureDataRelUpReg& rfoCmp) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   virtual tS32 s32GetTypeId() const { return weatherfi_tclToken::EN_MSG_RADARSTATICPICTUREDATARELUPREG;}
};

class weatherfi_tclMsgRadarStaticPictureDataStatus : public fi_tclVisitableTypeBase, public fi_tclMessageBase
{
public:
   virtual tU16 u16GetServiceID() const;
   virtual tU16 u16GetFunctionID() const;
   virtual tU8  u8GetOpCode() const;
   virtual const fi_tclTypeBase& corfoGetTypeBase() const {return *this;};
   virtual fi_tclTypeBase& rfoGetTypeBase() {return *this;};
   weatherfi_tclMsgRadarStaticPictureDataStatus():PresentedPicture() {}
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   weatherfi_tclMsgRadarStaticPictureDataStatus& operator=(const weatherfi_tclMsgRadarStaticPictureDataStatus& coRef);
   weatherfi_tclMsgRadarStaticPictureDataStatus(const weatherfi_tclMsgRadarStaticPictureDataStatus& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
   fi_tcl_RasterTilePicture PresentedPicture;

   virtual tVoid vDestroy();
   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual tBool operator==(const weatherfi_tclMsgRadarStaticPictureDataStatus& rfoCmp) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   virtual tS32 s32GetTypeId() const { return weatherfi_tclToken::EN_MSG_RADARSTATICPICTUREDATASTATUS;}
};

class weatherfi_tclMsgRadarAnimationDataGet : public fi_tclVisitableTypeBase, public fi_tclMessageBase
{
public:
   virtual tU16 u16GetServiceID() const;
   virtual tU16 u16GetFunctionID() const;
   virtual tU8  u8GetOpCode() const;
   virtual const fi_tclTypeBase& corfoGetTypeBase() const {return *this;};
   virtual fi_tclTypeBase& rfoGetTypeBase() {return *this;};
   weatherfi_tclMsgRadarAnimationDataGet() {}
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   weatherfi_tclMsgRadarAnimationDataGet& operator=(const weatherfi_tclMsgRadarAnimationDataGet& coRef);
   weatherfi_tclMsgRadarAnimationDataGet(const weatherfi_tclMsgRadarAnimationDataGet& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual tBool operator==(const weatherfi_tclMsgRadarAnimationDataGet& rfoCmp) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   virtual tS32 s32GetTypeId() const { return weatherfi_tclToken::EN_MSG_RADARANIMATIONDATAGET;}
};

class weatherfi_tclMsgRadarAnimationDataUpReg : public fi_tclVisitableTypeBase, public fi_tclMessageBase
{
public:
   virtual tU16 u16GetServiceID() const;
   virtual tU16 u16GetFunctionID() const;
   virtual tU8  u8GetOpCode() const;
   virtual const fi_tclTypeBase& corfoGetTypeBase() const {return *this;};
   virtual fi_tclTypeBase& rfoGetTypeBase() {return *this;};
   weatherfi_tclMsgRadarAnimationDataUpReg() {}
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   weatherfi_tclMsgRadarAnimationDataUpReg& operator=(const weatherfi_tclMsgRadarAnimationDataUpReg& coRef);
   weatherfi_tclMsgRadarAnimationDataUpReg(const weatherfi_tclMsgRadarAnimationDataUpReg& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual tBool operator==(const weatherfi_tclMsgRadarAnimationDataUpReg& rfoCmp) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   virtual tS32 s32GetTypeId() const { return weatherfi_tclToken::EN_MSG_RADARANIMATIONDATAUPREG;}
};

class weatherfi_tclMsgRadarAnimationDataRelUpReg : public fi_tclVisitableTypeBase, public fi_tclMessageBase
{
public:
   virtual tU16 u16GetServiceID() const;
   virtual tU16 u16GetFunctionID() const;
   virtual tU8  u8GetOpCode() const;
   virtual const fi_tclTypeBase& corfoGetTypeBase() const {return *this;};
   virtual fi_tclTypeBase& rfoGetTypeBase() {return *this;};
   weatherfi_tclMsgRadarAnimationDataRelUpReg() {}
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   weatherfi_tclMsgRadarAnimationDataRelUpReg& operator=(const weatherfi_tclMsgRadarAnimationDataRelUpReg& coRef);
   weatherfi_tclMsgRadarAnimationDataRelUpReg(const weatherfi_tclMsgRadarAnimationDataRelUpReg& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual tBool operator==(const weatherfi_tclMsgRadarAnimationDataRelUpReg& rfoCmp) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   virtual tS32 s32GetTypeId() const { return weatherfi_tclToken::EN_MSG_RADARANIMATIONDATARELUPREG;}
};

class weatherfi_tclMsgRadarAnimationDataStatus : public fi_tclVisitableTypeBase, public fi_tclMessageBase
{
public:
   virtual tU16 u16GetServiceID() const;
   virtual tU16 u16GetFunctionID() const;
   virtual tU8  u8GetOpCode() const;
   virtual const fi_tclTypeBase& corfoGetTypeBase() const {return *this;};
   virtual fi_tclTypeBase& rfoGetTypeBase() {return *this;};
   weatherfi_tclMsgRadarAnimationDataStatus() {}
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   weatherfi_tclMsgRadarAnimationDataStatus& operator=(const weatherfi_tclMsgRadarAnimationDataStatus& coRef);
   weatherfi_tclMsgRadarAnimationDataStatus(const weatherfi_tclMsgRadarAnimationDataStatus& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
   std::vector<fi_tcl_RasterTilePicture, std::allocator<fi_tcl_RasterTilePicture> > PresentedPictures;

   virtual tVoid vDestroy();
   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual tBool operator==(const weatherfi_tclMsgRadarAnimationDataStatus& rfoCmp) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   virtual tS32 s32GetTypeId() const { return weatherfi_tclToken::EN_MSG_RADARANIMATIONDATASTATUS;}
};

class weatherfi_tclMsgWindStaticPictureDataGet : public fi_tclVisitableTypeBase, public fi_tclMessageBase
{
public:
   virtual tU16 u16GetServiceID() const;
   virtual tU16 u16GetFunctionID() const;
   virtual tU8  u8GetOpCode() const;
   virtual const fi_tclTypeBase& corfoGetTypeBase() const {return *this;};
   virtual fi_tclTypeBase& rfoGetTypeBase() {return *this;};
   weatherfi_tclMsgWindStaticPictureDataGet() {}
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   weatherfi_tclMsgWindStaticPictureDataGet& operator=(const weatherfi_tclMsgWindStaticPictureDataGet& coRef);
   weatherfi_tclMsgWindStaticPictureDataGet(const weatherfi_tclMsgWindStaticPictureDataGet& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual tBool operator==(const weatherfi_tclMsgWindStaticPictureDataGet& rfoCmp) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   virtual tS32 s32GetTypeId() const { return weatherfi_tclToken::EN_MSG_WINDSTATICPICTUREDATAGET;}
};

class weatherfi_tclMsgWindStaticPictureDataUpReg : public fi_tclVisitableTypeBase, public fi_tclMessageBase
{
public:
   virtual tU16 u16GetServiceID() const;
   virtual tU16 u16GetFunctionID() const;
   virtual tU8  u8GetOpCode() const;
   virtual const fi_tclTypeBase& corfoGetTypeBase() const {return *this;};
   virtual fi_tclTypeBase& rfoGetTypeBase() {return *this;};
   weatherfi_tclMsgWindStaticPictureDataUpReg() {}
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   weatherfi_tclMsgWindStaticPictureDataUpReg& operator=(const weatherfi_tclMsgWindStaticPictureDataUpReg& coRef);
   weatherfi_tclMsgWindStaticPictureDataUpReg(const weatherfi_tclMsgWindStaticPictureDataUpReg& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual tBool operator==(const weatherfi_tclMsgWindStaticPictureDataUpReg& rfoCmp) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   virtual tS32 s32GetTypeId() const { return weatherfi_tclToken::EN_MSG_WINDSTATICPICTUREDATAUPREG;}
};

class weatherfi_tclMsgWindStaticPictureDataRelUpReg : public fi_tclVisitableTypeBase, public fi_tclMessageBase
{
public:
   virtual tU16 u16GetServiceID() const;
   virtual tU16 u16GetFunctionID() const;
   virtual tU8  u8GetOpCode() const;
   virtual const fi_tclTypeBase& corfoGetTypeBase() const {return *this;};
   virtual fi_tclTypeBase& rfoGetTypeBase() {return *this;};
   weatherfi_tclMsgWindStaticPictureDataRelUpReg() {}
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   weatherfi_tclMsgWindStaticPictureDataRelUpReg& operator=(const weatherfi_tclMsgWindStaticPictureDataRelUpReg& coRef);
   weatherfi_tclMsgWindStaticPictureDataRelUpReg(const weatherfi_tclMsgWindStaticPictureDataRelUpReg& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual tBool operator==(const weatherfi_tclMsgWindStaticPictureDataRelUpReg& rfoCmp) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   virtual tS32 s32GetTypeId() const { return weatherfi_tclToken::EN_MSG_WINDSTATICPICTUREDATARELUPREG;}
};

class weatherfi_tclMsgWindStaticPictureDataStatus : public fi_tclVisitableTypeBase, public fi_tclMessageBase
{
public:
   virtual tU16 u16GetServiceID() const;
   virtual tU16 u16GetFunctionID() const;
   virtual tU8  u8GetOpCode() const;
   virtual const fi_tclTypeBase& corfoGetTypeBase() const {return *this;};
   virtual fi_tclTypeBase& rfoGetTypeBase() {return *this;};
   weatherfi_tclMsgWindStaticPictureDataStatus():PresentedMagnitudePicture(),PresentedDirectionPicture() {}
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   weatherfi_tclMsgWindStaticPictureDataStatus& operator=(const weatherfi_tclMsgWindStaticPictureDataStatus& coRef);
   weatherfi_tclMsgWindStaticPictureDataStatus(const weatherfi_tclMsgWindStaticPictureDataStatus& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
   fi_tcl_RasterTilePicture PresentedMagnitudePicture;
   fi_tcl_RasterTilePicture PresentedDirectionPicture;

   virtual tVoid vDestroy();
   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual tBool operator==(const weatherfi_tclMsgWindStaticPictureDataStatus& rfoCmp) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   virtual tS32 s32GetTypeId() const { return weatherfi_tclToken::EN_MSG_WINDSTATICPICTUREDATASTATUS;}
};

class weatherfi_tclMsgEngineeringTextGet : public fi_tclVisitableTypeBase, public fi_tclMessageBase
{
public:
   virtual tU16 u16GetServiceID() const;
   virtual tU16 u16GetFunctionID() const;
   virtual tU8  u8GetOpCode() const;
   virtual const fi_tclTypeBase& corfoGetTypeBase() const {return *this;};
   virtual fi_tclTypeBase& rfoGetTypeBase() {return *this;};
   weatherfi_tclMsgEngineeringTextGet() {}
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   weatherfi_tclMsgEngineeringTextGet& operator=(const weatherfi_tclMsgEngineeringTextGet& coRef);
   weatherfi_tclMsgEngineeringTextGet(const weatherfi_tclMsgEngineeringTextGet& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual tBool operator==(const weatherfi_tclMsgEngineeringTextGet& rfoCmp) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   virtual tS32 s32GetTypeId() const { return weatherfi_tclToken::EN_MSG_ENGINEERINGTEXTGET;}
};

class weatherfi_tclMsgEngineeringTextUpReg : public fi_tclVisitableTypeBase, public fi_tclMessageBase
{
public:
   virtual tU16 u16GetServiceID() const;
   virtual tU16 u16GetFunctionID() const;
   virtual tU8  u8GetOpCode() const;
   virtual const fi_tclTypeBase& corfoGetTypeBase() const {return *this;};
   virtual fi_tclTypeBase& rfoGetTypeBase() {return *this;};
   weatherfi_tclMsgEngineeringTextUpReg() {}
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   weatherfi_tclMsgEngineeringTextUpReg& operator=(const weatherfi_tclMsgEngineeringTextUpReg& coRef);
   weatherfi_tclMsgEngineeringTextUpReg(const weatherfi_tclMsgEngineeringTextUpReg& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual tBool operator==(const weatherfi_tclMsgEngineeringTextUpReg& rfoCmp) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   virtual tS32 s32GetTypeId() const { return weatherfi_tclToken::EN_MSG_ENGINEERINGTEXTUPREG;}
};

class weatherfi_tclMsgEngineeringTextRelUpReg : public fi_tclVisitableTypeBase, public fi_tclMessageBase
{
public:
   virtual tU16 u16GetServiceID() const;
   virtual tU16 u16GetFunctionID() const;
   virtual tU8  u8GetOpCode() const;
   virtual const fi_tclTypeBase& corfoGetTypeBase() const {return *this;};
   virtual fi_tclTypeBase& rfoGetTypeBase() {return *this;};
   weatherfi_tclMsgEngineeringTextRelUpReg() {}
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   weatherfi_tclMsgEngineeringTextRelUpReg& operator=(const weatherfi_tclMsgEngineeringTextRelUpReg& coRef);
   weatherfi_tclMsgEngineeringTextRelUpReg(const weatherfi_tclMsgEngineeringTextRelUpReg& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual tBool operator==(const weatherfi_tclMsgEngineeringTextRelUpReg& rfoCmp) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   virtual tS32 s32GetTypeId() const { return weatherfi_tclToken::EN_MSG_ENGINEERINGTEXTRELUPREG;}
};

class weatherfi_tclMsgEngineeringTextStatus : public fi_tclVisitableTypeBase, public fi_tclMessageBase
{
public:
   virtual tU16 u16GetServiceID() const;
   virtual tU16 u16GetFunctionID() const;
   virtual tU8  u8GetOpCode() const;
   virtual const fi_tclTypeBase& corfoGetTypeBase() const {return *this;};
   virtual fi_tclTypeBase& rfoGetTypeBase() {return *this;};
   weatherfi_tclMsgEngineeringTextStatus():Message() {}
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   weatherfi_tclMsgEngineeringTextStatus& operator=(const weatherfi_tclMsgEngineeringTextStatus& coRef);
   weatherfi_tclMsgEngineeringTextStatus(const weatherfi_tclMsgEngineeringTextStatus& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
   fi_tclString Message;

   virtual tVoid vDestroy();
   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual tBool operator==(const weatherfi_tclMsgEngineeringTextStatus& rfoCmp) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   virtual tS32 s32GetTypeId() const { return weatherfi_tclToken::EN_MSG_ENGINEERINGTEXTSTATUS;}
};


#endif
