#include "precompiled.hh"

tBool weatherfi_tclDescription::bInitMessage(weatherfi_tclToken::tenType enMsgToken) {
   tBool bResult = TRUE;
   switch (enMsgToken) {
   case weatherfi_tclToken::EN_LAST_TOKEN:
   case weatherfi_tclToken::EN_LIST:
   case weatherfi_tclToken::EN_END_OF_STRUCT:
   case weatherfi_tclToken::EN_UNKNOWN:
      bResult=FALSE;   
   break;
      // include the expansions for the messages
   case weatherfi_tclToken::EN_MSG_GETCURRENTWEATHERDATAMETHODSTART:
   {
      bResult &= oPath.bGoDown(weatherfi_tclKnot(weatherfi_tclToken::EN_U8,weatherfi_tclSemanticDomain::EN_MSG_MAXNUMBEROFSTATIONS));
      bResult &= oPath.bGoDown(weatherfi_tclKnot(weatherfi_tclToken::EN_S32_METER,weatherfi_tclSemanticDomain::EN_MSG_MAXDISTANCE));
      bResult &= oPath.bGoDown(weatherfi_tclKnot(weatherfi_tclToken::EN_POSITIONWGS84,weatherfi_tclSemanticDomain::EN_LIST_ELEMENT,0));
      bResult &= oPath.bGoDown(weatherfi_tclKnot(weatherfi_tclToken::EN_LIST,weatherfi_tclSemanticDomain::EN_MSG_POSITIONLIST));
   } break;
   case weatherfi_tclToken::EN_MSG_GETCURRENTWEATHERDATAMETHODRESULT:
   {
      bResult &= oPath.bGoDown(weatherfi_tclKnot(weatherfi_tclToken::EN_WEATHERFORPOSITION,weatherfi_tclSemanticDomain::EN_LIST_ELEMENT,0));
      bResult &= oPath.bGoDown(weatherfi_tclKnot(weatherfi_tclToken::EN_LIST,weatherfi_tclSemanticDomain::EN_MSG_WEATHERFORPOSITION));
      bResult &= oPath.bGoDown(weatherfi_tclKnot(weatherfi_tclToken::EN_U32,weatherfi_tclSemanticDomain::EN_MSG_METARBLOCKID));
   } break;
   case weatherfi_tclToken::EN_MSG_GETWEATHERFORECASTDATAMETHODSTART:
   {
      bResult &= oPath.bGoDown(weatherfi_tclKnot(weatherfi_tclToken::EN_U8,weatherfi_tclSemanticDomain::EN_MSG_MAXNUMBEROFCITIES));
      bResult &= oPath.bGoDown(weatherfi_tclKnot(weatherfi_tclToken::EN_S32_METER,weatherfi_tclSemanticDomain::EN_MSG_MAXDISTANCE));
      bResult &= oPath.bGoDown(weatherfi_tclKnot(weatherfi_tclToken::EN_POSITIONWGS84,weatherfi_tclSemanticDomain::EN_LIST_ELEMENT,0));
      bResult &= oPath.bGoDown(weatherfi_tclKnot(weatherfi_tclToken::EN_LIST,weatherfi_tclSemanticDomain::EN_MSG_POSITIONLIST));
   } break;
   case weatherfi_tclToken::EN_MSG_GETWEATHERFORECASTDATAMETHODRESULT:
   {
      bResult &= oPath.bGoDown(weatherfi_tclKnot(weatherfi_tclToken::EN_WEATHERFORECASTFORPOSITION,weatherfi_tclSemanticDomain::EN_LIST_ELEMENT,0));
      bResult &= oPath.bGoDown(weatherfi_tclKnot(weatherfi_tclToken::EN_LIST,weatherfi_tclSemanticDomain::EN_MSG_WEATHERFORECASTSFORPOSITION));
      bResult &= oPath.bGoDown(weatherfi_tclKnot(weatherfi_tclToken::EN_U32,weatherfi_tclSemanticDomain::EN_MSG_CCFBLOCKID));
   } break;
   case weatherfi_tclToken::EN_MSG_GETCOUNTYWARNINGDATAMETHODSTART:
   {
      bResult &= oPath.bGoDown(weatherfi_tclKnot(weatherfi_tclToken::EN_S32_METER,weatherfi_tclSemanticDomain::EN_MSG_MAXDISTANCE));
      bResult &= oPath.bGoDown(weatherfi_tclKnot(weatherfi_tclToken::EN_POSITIONWGS84,weatherfi_tclSemanticDomain::EN_MSG_POSITION));
   } break;
   case weatherfi_tclToken::EN_MSG_GETCOUNTYWARNINGDATAMETHODRESULT:
   {
      bResult &= oPath.bGoDown(weatherfi_tclKnot(weatherfi_tclToken::EN_COUNTYWARNING,weatherfi_tclSemanticDomain::EN_LIST_ELEMENT,0));
      bResult &= oPath.bGoDown(weatherfi_tclKnot(weatherfi_tclToken::EN_LIST,weatherfi_tclSemanticDomain::EN_MSG_COUNTYWARNINGS));
      if (2 <= poOutContext->u16GetMajorVersion())
      {
         bResult &= oPath.bGoDown(weatherfi_tclKnot(weatherfi_tclToken::EN_U32,weatherfi_tclSemanticDomain::EN_MSG_COUNTYWARNINGSUBID));
      }
      bResult &= oPath.bGoDown(weatherfi_tclKnot(weatherfi_tclToken::EN_U32,weatherfi_tclSemanticDomain::EN_MSG_COUNTYWARNINGID));
   } break;
   case weatherfi_tclToken::EN_MSG_GETFORECASTCITYLISTMETHODRESULT:
   {
      bResult &= oPath.bGoDown(weatherfi_tclKnot(weatherfi_tclToken::EN_CODEDCITY,weatherfi_tclSemanticDomain::EN_LIST_ELEMENT,0));
      bResult &= oPath.bGoDown(weatherfi_tclKnot(weatherfi_tclToken::EN_LIST,weatherfi_tclSemanticDomain::EN_MSG_FORECASTCITIES));
   } break;
   case weatherfi_tclToken::EN_MSG_GETFORECASTFORCITYMETHODSTART:
   {
      bResult &= oPath.bGoDown(weatherfi_tclKnot(weatherfi_tclToken::EN_U32,weatherfi_tclSemanticDomain::EN_MSG_CITYCODE));
   } break;
   case weatherfi_tclToken::EN_MSG_GETFORECASTFORCITYMETHODRESULT:
   {
      bResult &= oPath.bGoDown(weatherfi_tclKnot(weatherfi_tclToken::EN_WEATHERFORECAST,weatherfi_tclSemanticDomain::EN_MSG_WEATHERFORECAST));
      bResult &= oPath.bGoDown(weatherfi_tclKnot(weatherfi_tclToken::EN_U32,weatherfi_tclSemanticDomain::EN_MSG_WEATHERFORECASTID));
   } break;
   case weatherfi_tclToken::EN_MSG_GETTABULARWEATHERDATAMETHODSTART:
   {
      bResult &= oPath.bGoDown(weatherfi_tclKnot(weatherfi_tclToken::EN_B16_FORECASTTYPE,weatherfi_tclSemanticDomain::EN_MSG_FORECASTTYPE));
      bResult &= oPath.bGoDown(weatherfi_tclKnot(weatherfi_tclToken::EN_U8,weatherfi_tclSemanticDomain::EN_MSG_MAXNUMBER));
      bResult &= oPath.bGoDown(weatherfi_tclKnot(weatherfi_tclToken::EN_S32_METER,weatherfi_tclSemanticDomain::EN_MSG_MAXDISTANCE));
      bResult &= oPath.bGoDown(weatherfi_tclKnot(weatherfi_tclToken::EN_POSITIONWGS84,weatherfi_tclSemanticDomain::EN_LIST_ELEMENT,0));
      bResult &= oPath.bGoDown(weatherfi_tclKnot(weatherfi_tclToken::EN_LIST,weatherfi_tclSemanticDomain::EN_MSG_POSITIONLIST));
   } break;
   case weatherfi_tclToken::EN_MSG_GETTABULARWEATHERDATAMETHODRESULT:
   {
      bResult &= oPath.bGoDown(weatherfi_tclKnot(weatherfi_tclToken::EN_TABULARWEATHERFORPOSITION,weatherfi_tclSemanticDomain::EN_LIST_ELEMENT,0));
      bResult &= oPath.bGoDown(weatherfi_tclKnot(weatherfi_tclToken::EN_LIST,weatherfi_tclSemanticDomain::EN_MSG_TABULARWEATHERFORPOSITION));
      bResult &= oPath.bGoDown(weatherfi_tclKnot(weatherfi_tclToken::EN_VERSIONPERFORECAST,weatherfi_tclSemanticDomain::EN_LIST_ELEMENT,0));
      bResult &= oPath.bGoDown(weatherfi_tclKnot(weatherfi_tclToken::EN_LIST,weatherfi_tclSemanticDomain::EN_MSG_VERSIONSFORFORECASTS));
   } break;
   case weatherfi_tclToken::EN_MSG_GETTABULARWEATHERSKICONDITIONDATAMETHODSTART:
   {
      bResult &= oPath.bGoDown(weatherfi_tclKnot(weatherfi_tclToken::EN_U8,weatherfi_tclSemanticDomain::EN_MSG_MAXNUMBER));
      bResult &= oPath.bGoDown(weatherfi_tclKnot(weatherfi_tclToken::EN_S32_METER,weatherfi_tclSemanticDomain::EN_MSG_MAXDISTANCE));
      bResult &= oPath.bGoDown(weatherfi_tclKnot(weatherfi_tclToken::EN_POSITIONWGS84,weatherfi_tclSemanticDomain::EN_LIST_ELEMENT,0));
      bResult &= oPath.bGoDown(weatherfi_tclKnot(weatherfi_tclToken::EN_LIST,weatherfi_tclSemanticDomain::EN_MSG_POSITIONLIST));
   } break;
   case weatherfi_tclToken::EN_MSG_GETTABULARWEATHERSKICONDITIONDATAMETHODRESULT:
   {
      bResult &= oPath.bGoDown(weatherfi_tclKnot(weatherfi_tclToken::EN_SKICONDITIONFORPOSITION,weatherfi_tclSemanticDomain::EN_LIST_ELEMENT,0));
      bResult &= oPath.bGoDown(weatherfi_tclKnot(weatherfi_tclToken::EN_LIST,weatherfi_tclSemanticDomain::EN_MSG_SKICONDITIONFORPOSITION));
      bResult &= oPath.bGoDown(weatherfi_tclKnot(weatherfi_tclToken::EN_U32,weatherfi_tclSemanticDomain::EN_MSG_TABULARWEATHERSKICONDITIONVERSIONID));
   } break;
   case weatherfi_tclToken::EN_MSG_GETWEATHERALERTDATAMETHODSTART:
   {
      bResult &= oPath.bGoDown(weatherfi_tclKnot(weatherfi_tclToken::EN_BOOL,weatherfi_tclSemanticDomain::EN_MSG_TWELVEHOURTIMEPRESENTATION));
      if (4 <= poOutContext->u16GetMajorVersion())
      {
         bResult &= oPath.bGoDown(weatherfi_tclKnot(weatherfi_tclToken::EN_STATEORZONE,weatherfi_tclSemanticDomain::EN_LIST_ELEMENT,0));
         bResult &= oPath.bGoDown(weatherfi_tclKnot(weatherfi_tclToken::EN_LIST,weatherfi_tclSemanticDomain::EN_MSG_STATEZONEFILTER));
      }
      if (poOutContext->u16GetMajorVersion() <= 3)
      {
         bResult &= oPath.bGoDown(weatherfi_tclKnot(weatherfi_tclToken::EN_U32,weatherfi_tclSemanticDomain::EN_LIST_ELEMENT,0));
         bResult &= oPath.bGoDown(weatherfi_tclKnot(weatherfi_tclToken::EN_LIST,weatherfi_tclSemanticDomain::EN_MSG_STATEFILTER));
      }
      bResult &= oPath.bGoDown(weatherfi_tclKnot(weatherfi_tclToken::EN_U8,weatherfi_tclSemanticDomain::EN_MSG_MAXNUMBER));
      bResult &= oPath.bGoDown(weatherfi_tclKnot(weatherfi_tclToken::EN_S32_METER,weatherfi_tclSemanticDomain::EN_MSG_MAXDISTANCE));
      bResult &= oPath.bGoDown(weatherfi_tclKnot(weatherfi_tclToken::EN_POSITIONWGS84,weatherfi_tclSemanticDomain::EN_LIST_ELEMENT,0));
      bResult &= oPath.bGoDown(weatherfi_tclKnot(weatherfi_tclToken::EN_LIST,weatherfi_tclSemanticDomain::EN_MSG_POSITIONLIST));
   } break;
   case weatherfi_tclToken::EN_MSG_GETWEATHERALERTDATAMETHODRESULT:
   {
      bResult &= oPath.bGoDown(weatherfi_tclKnot(weatherfi_tclToken::EN_WEATHERALERTSFORPOSITION,weatherfi_tclSemanticDomain::EN_LIST_ELEMENT,0));
      bResult &= oPath.bGoDown(weatherfi_tclKnot(weatherfi_tclToken::EN_LIST,weatherfi_tclSemanticDomain::EN_MSG_WEATHERALERTSFORPOSITION));
      bResult &= oPath.bGoDown(weatherfi_tclKnot(weatherfi_tclToken::EN_STATESPERLANGUAGE,weatherfi_tclSemanticDomain::EN_LIST_ELEMENT,0));
      bResult &= oPath.bGoDown(weatherfi_tclKnot(weatherfi_tclToken::EN_LIST,weatherfi_tclSemanticDomain::EN_MSG_STATESANDVERSIONPERLANGUAGE));
   } break;
   case weatherfi_tclToken::EN_MSG_CONFIRMGRAPHICALWEATHERRASTERTILESHAREDMEMORYMETHODSTART:
   {
      bResult &= oPath.bGoDown(weatherfi_tclKnot(weatherfi_tclToken::EN_TILEANDRASTERPICTURESHAREDMEMORY,weatherfi_tclSemanticDomain::EN_MSG_SHAREDMEMORYOVERVIEW));
      bResult &= oPath.bGoDown(weatherfi_tclKnot(weatherfi_tclToken::EN_BOOL,weatherfi_tclSemanticDomain::EN_MSG_OPEN));
      bResult &= oPath.bGoDown(weatherfi_tclKnot(weatherfi_tclToken::EN_E8_PICTURETYPE,weatherfi_tclSemanticDomain::EN_MSG_PICTURETYPE));
      bResult &= oPath.bGoDown(weatherfi_tclKnot(weatherfi_tclToken::EN_E8_PRODUCTTYPE,weatherfi_tclSemanticDomain::EN_MSG_PRODUCTTYPE));
   } break;
   case weatherfi_tclToken::EN_MSG_CONFIRMGRAPHICALWEATHERRASTERTILESHAREDMEMORYMETHODRESULT:
   {
      if (28 <= poOutContext->u16GetMajorVersion())
      {
         bResult &= oPath.bGoDown(weatherfi_tclKnot(weatherfi_tclToken::EN_E8_PICTURETYPE,weatherfi_tclSemanticDomain::EN_MSG_PICTURETYPE));
      }
      if (28 <= poOutContext->u16GetMajorVersion())
      {
         bResult &= oPath.bGoDown(weatherfi_tclKnot(weatherfi_tclToken::EN_E8_PRODUCTTYPE,weatherfi_tclSemanticDomain::EN_MSG_PRODUCTTYPE));
      }
   } break;
   case weatherfi_tclToken::EN_MSG_CONFIRMGRAPHICALWEATHERTILEPICTUREDATAMETHODSTART:
   {
      bResult &= oPath.bGoDown(weatherfi_tclKnot(weatherfi_tclToken::EN_VERSIONSOFTILE,weatherfi_tclSemanticDomain::EN_LIST_ELEMENT,0));
      bResult &= oPath.bGoDown(weatherfi_tclKnot(weatherfi_tclToken::EN_LIST,weatherfi_tclSemanticDomain::EN_MSG_BACKGROUNDTILES));
      bResult &= oPath.bGoDown(weatherfi_tclKnot(weatherfi_tclToken::EN_VERSIONSOFTILE,weatherfi_tclSemanticDomain::EN_LIST_ELEMENT,0));
      bResult &= oPath.bGoDown(weatherfi_tclKnot(weatherfi_tclToken::EN_LIST,weatherfi_tclSemanticDomain::EN_MSG_USEDTILES));
      bResult &= oPath.bGoDown(weatherfi_tclKnot(weatherfi_tclToken::EN_E8_PICTURETYPE,weatherfi_tclSemanticDomain::EN_MSG_PICTURETYPE));
      bResult &= oPath.bGoDown(weatherfi_tclKnot(weatherfi_tclToken::EN_E8_PRODUCTTYPE,weatherfi_tclSemanticDomain::EN_MSG_PRODUCTTYPE));
   } break;
   case weatherfi_tclToken::EN_MSG_CONFIRMGRAPHICALWEATHERTILEPICTUREDATAMETHODRESULT:
   {
      if (28 <= poOutContext->u16GetMajorVersion())
      {
         bResult &= oPath.bGoDown(weatherfi_tclKnot(weatherfi_tclToken::EN_E8_PICTURETYPE,weatherfi_tclSemanticDomain::EN_MSG_PICTURETYPE));
      }
      if (28 <= poOutContext->u16GetMajorVersion())
      {
         bResult &= oPath.bGoDown(weatherfi_tclKnot(weatherfi_tclToken::EN_E8_PRODUCTTYPE,weatherfi_tclSemanticDomain::EN_MSG_PRODUCTTYPE));
      }
   } break;
   case weatherfi_tclToken::EN_MSG_GETSURFACEDATAMETHODSTART:
   {
      bResult &= oPath.bGoDown(weatherfi_tclKnot(weatherfi_tclToken::EN_U8,weatherfi_tclSemanticDomain::EN_MSG_REQUESTEDBINCONTAINERVERSION));
      bResult &= oPath.bGoDown(weatherfi_tclKnot(weatherfi_tclToken::EN_B8_SHAPECONTENT,weatherfi_tclSemanticDomain::EN_MSG_PRESSURECENTERFILTER));
      bResult &= oPath.bGoDown(weatherfi_tclKnot(weatherfi_tclToken::EN_B8_SHAPECONTENT,weatherfi_tclSemanticDomain::EN_MSG_ISOBARFILTER));
      bResult &= oPath.bGoDown(weatherfi_tclKnot(weatherfi_tclToken::EN_B8_SHAPECONTENT,weatherfi_tclSemanticDomain::EN_MSG_FRONTFILTER));
   } break;
   case weatherfi_tclToken::EN_MSG_GETSURFACEDATAMETHODRESULT:
   {
      bResult &= oPath.bGoDown(weatherfi_tclKnot(weatherfi_tclToken::EN_BINCONTAINER,weatherfi_tclSemanticDomain::EN_MSG_SURFACESHAPES));
      bResult &= oPath.bGoDown(weatherfi_tclKnot(weatherfi_tclToken::EN_WEATHERSHAPETYPEPRESSURECENTER,weatherfi_tclSemanticDomain::EN_LIST_ELEMENT,0));
      bResult &= oPath.bGoDown(weatherfi_tclKnot(weatherfi_tclToken::EN_LIST,weatherfi_tclSemanticDomain::EN_MSG_PRESSURECENTERS));
      bResult &= oPath.bGoDown(weatherfi_tclKnot(weatherfi_tclToken::EN_WEATHERSHAPETYPEISOBAR,weatherfi_tclSemanticDomain::EN_LIST_ELEMENT,0));
      bResult &= oPath.bGoDown(weatherfi_tclKnot(weatherfi_tclToken::EN_LIST,weatherfi_tclSemanticDomain::EN_MSG_ISOBARS));
      bResult &= oPath.bGoDown(weatherfi_tclKnot(weatherfi_tclToken::EN_WEATHERSHAPETYPEFRONT,weatherfi_tclSemanticDomain::EN_LIST_ELEMENT,0));
      bResult &= oPath.bGoDown(weatherfi_tclKnot(weatherfi_tclToken::EN_LIST,weatherfi_tclSemanticDomain::EN_MSG_FRONTS));
      bResult &= oPath.bGoDown(weatherfi_tclKnot(weatherfi_tclToken::EN_U32,weatherfi_tclSemanticDomain::EN_MSG_UPDATECOUNTER));
   } break;
   case weatherfi_tclToken::EN_MSG_GETSTORMATTRIBUTESDATAMETHODSTART:
   {
      bResult &= oPath.bGoDown(weatherfi_tclKnot(weatherfi_tclToken::EN_U8,weatherfi_tclSemanticDomain::EN_MSG_REQUESTEDBINCONTAINERVERSION));
      bResult &= oPath.bGoDown(weatherfi_tclKnot(weatherfi_tclToken::EN_B8_SHAPECONTENT,weatherfi_tclSemanticDomain::EN_MSG_STORMATTRIBUTESFILTER));
   } break;
   case weatherfi_tclToken::EN_MSG_GETSTORMATTRIBUTESDATAMETHODRESULT:
   {
      bResult &= oPath.bGoDown(weatherfi_tclKnot(weatherfi_tclToken::EN_BINCONTAINER,weatherfi_tclSemanticDomain::EN_MSG_STORMATTRIBUTESHAPES));
      bResult &= oPath.bGoDown(weatherfi_tclKnot(weatherfi_tclToken::EN_WEATHERSHAPETYPESTORMATTRIBUTES,weatherfi_tclSemanticDomain::EN_LIST_ELEMENT,0));
      bResult &= oPath.bGoDown(weatherfi_tclKnot(weatherfi_tclToken::EN_LIST,weatherfi_tclSemanticDomain::EN_MSG_STORMATTRIBUTES));
      bResult &= oPath.bGoDown(weatherfi_tclKnot(weatherfi_tclToken::EN_U32,weatherfi_tclSemanticDomain::EN_MSG_UPDATECOUNTER));
   } break;
   case weatherfi_tclToken::EN_MSG_GETSTORMTRACKDATAMETHODSTART:
   {
      bResult &= oPath.bGoDown(weatherfi_tclKnot(weatherfi_tclToken::EN_U8,weatherfi_tclSemanticDomain::EN_MSG_REQUESTEDBINCONTAINERVERSION));
      bResult &= oPath.bGoDown(weatherfi_tclKnot(weatherfi_tclToken::EN_B8_SHAPECONTENT,weatherfi_tclSemanticDomain::EN_MSG_WINDRADIUSFILTER));
      bResult &= oPath.bGoDown(weatherfi_tclKnot(weatherfi_tclToken::EN_B8_SHAPECONTENT,weatherfi_tclSemanticDomain::EN_MSG_STORMPOSITIONFILTER));
   } break;
   case weatherfi_tclToken::EN_MSG_GETSTORMTRACKDATAMETHODRESULT:
   {
      bResult &= oPath.bGoDown(weatherfi_tclKnot(weatherfi_tclToken::EN_BINCONTAINER,weatherfi_tclSemanticDomain::EN_MSG_STORMTRACKSHAPES));
      bResult &= oPath.bGoDown(weatherfi_tclKnot(weatherfi_tclToken::EN_WEATHERSHAPETYPESTORMTRACK,weatherfi_tclSemanticDomain::EN_LIST_ELEMENT,0));
      bResult &= oPath.bGoDown(weatherfi_tclKnot(weatherfi_tclToken::EN_LIST,weatherfi_tclSemanticDomain::EN_MSG_STORMTRACKS));
      bResult &= oPath.bGoDown(weatherfi_tclKnot(weatherfi_tclToken::EN_U32,weatherfi_tclSemanticDomain::EN_MSG_UPDATECOUNTER));
   } break;
   case weatherfi_tclToken::EN_MSG_CONFIRMRASTERTILESHAREDMEMORYMETHODSTART:
   {
      bResult &= oPath.bGoDown(weatherfi_tclKnot(weatherfi_tclToken::EN_WEATHERSHAREDMEMORYDESCRIPTION,weatherfi_tclSemanticDomain::EN_LIST_ELEMENT,0));
      bResult &= oPath.bGoDown(weatherfi_tclKnot(weatherfi_tclToken::EN_LIST,weatherfi_tclSemanticDomain::EN_MSG_CONFIRMEDSHAREDMEMORIES));
   } break;
   case weatherfi_tclToken::EN_MSG_CONFIRMRASTERTILESHAREDMEMORYMETHODRESULT:
   {
      bResult &= oPath.bGoDown(weatherfi_tclKnot(weatherfi_tclToken::EN_TILEIDENTIFIER,weatherfi_tclSemanticDomain::EN_LIST_ELEMENT,0));
      bResult &= oPath.bGoDown(weatherfi_tclKnot(weatherfi_tclToken::EN_LIST,weatherfi_tclSemanticDomain::EN_MSG_CONFIRMEDSHAREDMEMORIES));
   } break;
   case weatherfi_tclToken::EN_MSG_CONFIRMRASTERTILEPICTURESMETHODSTART:
   {
      bResult &= oPath.bGoDown(weatherfi_tclKnot(weatherfi_tclToken::EN_TILEIDENTIFIER,weatherfi_tclSemanticDomain::EN_LIST_ELEMENT,0));
      bResult &= oPath.bGoDown(weatherfi_tclKnot(weatherfi_tclToken::EN_LIST,weatherfi_tclSemanticDomain::EN_MSG_CONFIRMEDTILETYPES));
   } break;
   case weatherfi_tclToken::EN_MSG_CONFIRMRASTERTILEPICTURESMETHODRESULT:
   {
      bResult &= oPath.bGoDown(weatherfi_tclKnot(weatherfi_tclToken::EN_TILEIDENTIFIER,weatherfi_tclSemanticDomain::EN_LIST_ELEMENT,0));
      bResult &= oPath.bGoDown(weatherfi_tclKnot(weatherfi_tclToken::EN_LIST,weatherfi_tclSemanticDomain::EN_MSG_CONFIRMEDTILETYPES));
   } break;
   case weatherfi_tclToken::EN_MSG_CURRENTWEATHERDATACHANGEDSTATUS:
   {
      bResult &= oPath.bGoDown(weatherfi_tclKnot(weatherfi_tclToken::EN_U32,weatherfi_tclSemanticDomain::EN_MSG_CURRENTWEATHERID));
   } break;
   case weatherfi_tclToken::EN_MSG_WEATHERFORECASTDATACHANGEDSTATUS:
   {
      bResult &= oPath.bGoDown(weatherfi_tclKnot(weatherfi_tclToken::EN_U32,weatherfi_tclSemanticDomain::EN_MSG_WEATHERFORECASTID));
   } break;
   case weatherfi_tclToken::EN_MSG_COUNTYWARNINGDATACHANGEDSTATUS:
   {
      bResult &= oPath.bGoDown(weatherfi_tclKnot(weatherfi_tclToken::EN_BOOL,weatherfi_tclSemanticDomain::EN_MSG_SUBSTANTIALCHANGE));
      if (2 <= poOutContext->u16GetMajorVersion())
      {
         bResult &= oPath.bGoDown(weatherfi_tclKnot(weatherfi_tclToken::EN_U32,weatherfi_tclSemanticDomain::EN_MSG_COUNTYWARNINGSUBID));
      }
      bResult &= oPath.bGoDown(weatherfi_tclKnot(weatherfi_tclToken::EN_U32,weatherfi_tclSemanticDomain::EN_MSG_COUNTYWARNINGID));
   } break;
   case weatherfi_tclToken::EN_MSG_TABULARWEATHERDATASTATUS:
   {
      bResult &= oPath.bGoDown(weatherfi_tclKnot(weatherfi_tclToken::EN_VERSIONPERFORECAST,weatherfi_tclSemanticDomain::EN_LIST_ELEMENT,0));
      bResult &= oPath.bGoDown(weatherfi_tclKnot(weatherfi_tclToken::EN_LIST,weatherfi_tclSemanticDomain::EN_MSG_VERSIONSFORFORECASTS));
   } break;
   case weatherfi_tclToken::EN_MSG_TABULARWEATHERSKICONDITIONDATASTATUS:
   {
      bResult &= oPath.bGoDown(weatherfi_tclKnot(weatherfi_tclToken::EN_U32,weatherfi_tclSemanticDomain::EN_MSG_TABULARWEATHERSKCONDITIONVERSIONID));
   } break;
   case weatherfi_tclToken::EN_MSG_WEATHERALERTDATASTATUS:
   {
      bResult &= oPath.bGoDown(weatherfi_tclKnot(weatherfi_tclToken::EN_STATESANDAREASPERLANGUAGE,weatherfi_tclSemanticDomain::EN_LIST_ELEMENT,0));
      bResult &= oPath.bGoDown(weatherfi_tclKnot(weatherfi_tclToken::EN_LIST,weatherfi_tclSemanticDomain::EN_MSG_STATESANDAREASPERLANGUAGE));
   } break;
   case weatherfi_tclToken::EN_MSG_GRAPHICALWEATHERRASTERTILESHAREDMEMORYSTATUS:
   {
      bResult &= oPath.bGoDown(weatherfi_tclKnot(weatherfi_tclToken::EN_TILEANDRASTERPICTURESHAREDMEMORY,weatherfi_tclSemanticDomain::EN_MSG_SHAREDMEMORYOVERVIEW));
      bResult &= oPath.bGoDown(weatherfi_tclKnot(weatherfi_tclToken::EN_BOOL,weatherfi_tclSemanticDomain::EN_MSG_OPEN));
      bResult &= oPath.bGoDown(weatherfi_tclKnot(weatherfi_tclToken::EN_E8_FORMATVERSION,weatherfi_tclSemanticDomain::EN_MSG_FORMATVERSION));
      bResult &= oPath.bGoDown(weatherfi_tclKnot(weatherfi_tclToken::EN_E8_PICTURETYPE,weatherfi_tclSemanticDomain::EN_MSG_PICTURETYPE));
      bResult &= oPath.bGoDown(weatherfi_tclKnot(weatherfi_tclToken::EN_E8_PRODUCTTYPE,weatherfi_tclSemanticDomain::EN_MSG_PRODUCTTYPE));
   } break;
   case weatherfi_tclToken::EN_MSG_GRAPHICALWEATHERRADARANIMATIONSHAREDMEMORYSTATUS:
   {
      bResult &= oPath.bGoDown(weatherfi_tclKnot(weatherfi_tclToken::EN_TILEANDRASTERPICTURESHAREDMEMORY,weatherfi_tclSemanticDomain::EN_MSG_SHAREDMEMORYOVERVIEW));
      bResult &= oPath.bGoDown(weatherfi_tclKnot(weatherfi_tclToken::EN_BOOL,weatherfi_tclSemanticDomain::EN_MSG_OPEN));
      bResult &= oPath.bGoDown(weatherfi_tclKnot(weatherfi_tclToken::EN_E8_FORMATVERSION,weatherfi_tclSemanticDomain::EN_MSG_FORMATVERSION));
      bResult &= oPath.bGoDown(weatherfi_tclKnot(weatherfi_tclToken::EN_E8_PICTURETYPE,weatherfi_tclSemanticDomain::EN_MSG_PICTURETYPE));
      bResult &= oPath.bGoDown(weatherfi_tclKnot(weatherfi_tclToken::EN_E8_PRODUCTTYPE,weatherfi_tclSemanticDomain::EN_MSG_PRODUCTTYPE));
   } break;
   case weatherfi_tclToken::EN_MSG_GRAPHICALWEATHERTILEPICTUREDATASTATUS:
   {
      bResult &= oPath.bGoDown(weatherfi_tclKnot(weatherfi_tclToken::EN_GRAPHICALWEATHERTILEPICTURE,weatherfi_tclSemanticDomain::EN_LIST_ELEMENT,0));
      bResult &= oPath.bGoDown(weatherfi_tclKnot(weatherfi_tclToken::EN_LIST,weatherfi_tclSemanticDomain::EN_MSG_PRESENTEDPICTURES));
      bResult &= oPath.bGoDown(weatherfi_tclKnot(weatherfi_tclToken::EN_VERSIONSOFTILE,weatherfi_tclSemanticDomain::EN_LIST_ELEMENT,0));
      bResult &= oPath.bGoDown(weatherfi_tclKnot(weatherfi_tclToken::EN_LIST,weatherfi_tclSemanticDomain::EN_MSG_BACKGROUNDTILES));
      bResult &= oPath.bGoDown(weatherfi_tclKnot(weatherfi_tclToken::EN_VERSIONSOFTILE,weatherfi_tclSemanticDomain::EN_LIST_ELEMENT,0));
      bResult &= oPath.bGoDown(weatherfi_tclKnot(weatherfi_tclToken::EN_LIST,weatherfi_tclSemanticDomain::EN_MSG_USEDTILES));
      bResult &= oPath.bGoDown(weatherfi_tclKnot(weatherfi_tclToken::EN_E8_PICTURETYPE,weatherfi_tclSemanticDomain::EN_MSG_PICTURETYPE));
      bResult &= oPath.bGoDown(weatherfi_tclKnot(weatherfi_tclToken::EN_E8_PRODUCTTYPE,weatherfi_tclSemanticDomain::EN_MSG_PRODUCTTYPE));
   } break;
   case weatherfi_tclToken::EN_MSG_GRAPHICALWEATHERRADARANIMATIONPICTUREDATASTATUS:
   {
      bResult &= oPath.bGoDown(weatherfi_tclKnot(weatherfi_tclToken::EN_GRAPHICALWEATHERTILEPICTURE,weatherfi_tclSemanticDomain::EN_LIST_ELEMENT,0));
      bResult &= oPath.bGoDown(weatherfi_tclKnot(weatherfi_tclToken::EN_LIST,weatherfi_tclSemanticDomain::EN_MSG_PRESENTEDPICTURES));
      bResult &= oPath.bGoDown(weatherfi_tclKnot(weatherfi_tclToken::EN_VERSIONSOFTILE,weatherfi_tclSemanticDomain::EN_LIST_ELEMENT,0));
      bResult &= oPath.bGoDown(weatherfi_tclKnot(weatherfi_tclToken::EN_LIST,weatherfi_tclSemanticDomain::EN_MSG_BACKGROUNDTILES));
      bResult &= oPath.bGoDown(weatherfi_tclKnot(weatherfi_tclToken::EN_VERSIONSOFTILE,weatherfi_tclSemanticDomain::EN_LIST_ELEMENT,0));
      bResult &= oPath.bGoDown(weatherfi_tclKnot(weatherfi_tclToken::EN_LIST,weatherfi_tclSemanticDomain::EN_MSG_USEDTILES));
      bResult &= oPath.bGoDown(weatherfi_tclKnot(weatherfi_tclToken::EN_E8_PICTURETYPE,weatherfi_tclSemanticDomain::EN_MSG_PICTURETYPE));
      bResult &= oPath.bGoDown(weatherfi_tclKnot(weatherfi_tclToken::EN_E8_PRODUCTTYPE,weatherfi_tclSemanticDomain::EN_MSG_PRODUCTTYPE));
   } break;
   case weatherfi_tclToken::EN_MSG_SURFACEDATASTATUS:
   {
      bResult &= oPath.bGoDown(weatherfi_tclKnot(weatherfi_tclToken::EN_U32,weatherfi_tclSemanticDomain::EN_MSG_UPDATECOUNTER));
   } break;
   case weatherfi_tclToken::EN_MSG_STORMATTRIBUTESDATASTATUS:
   {
      bResult &= oPath.bGoDown(weatherfi_tclKnot(weatherfi_tclToken::EN_U32,weatherfi_tclSemanticDomain::EN_MSG_UPDATECOUNTER));
   } break;
   case weatherfi_tclToken::EN_MSG_STORMTRACKDATASTATUS:
   {
      bResult &= oPath.bGoDown(weatherfi_tclKnot(weatherfi_tclToken::EN_U32,weatherfi_tclSemanticDomain::EN_MSG_UPDATECOUNTER));
   } break;
   case weatherfi_tclToken::EN_MSG_RASTERTILESHAREDMEMORIESSTATUS:
   {
      bResult &= oPath.bGoDown(weatherfi_tclKnot(weatherfi_tclToken::EN_WEATHERSHAREDMEMORYDESCRIPTION,weatherfi_tclSemanticDomain::EN_LIST_ELEMENT,0));
      bResult &= oPath.bGoDown(weatherfi_tclKnot(weatherfi_tclToken::EN_LIST,weatherfi_tclSemanticDomain::EN_MSG_SHAREDMEMORIES));
   } break;
   case weatherfi_tclToken::EN_MSG_RADARSTATICPICTUREDATASTATUS:
   {
      bResult &= oPath.bGoDown(weatherfi_tclKnot(weatherfi_tclToken::EN_RASTERTILEPICTURE,weatherfi_tclSemanticDomain::EN_MSG_PRESENTEDPICTURE));
   } break;
   case weatherfi_tclToken::EN_MSG_RADARANIMATIONDATASTATUS:
   {
      bResult &= oPath.bGoDown(weatherfi_tclKnot(weatherfi_tclToken::EN_RASTERTILEPICTURE,weatherfi_tclSemanticDomain::EN_LIST_ELEMENT,0));
      bResult &= oPath.bGoDown(weatherfi_tclKnot(weatherfi_tclToken::EN_LIST,weatherfi_tclSemanticDomain::EN_MSG_PRESENTEDPICTURES));
   } break;
   case weatherfi_tclToken::EN_MSG_WINDSTATICPICTUREDATASTATUS:
   {
      bResult &= oPath.bGoDown(weatherfi_tclKnot(weatherfi_tclToken::EN_RASTERTILEPICTURE,weatherfi_tclSemanticDomain::EN_MSG_PRESENTEDDIRECTIONPICTURE));
      bResult &= oPath.bGoDown(weatherfi_tclKnot(weatherfi_tclToken::EN_RASTERTILEPICTURE,weatherfi_tclSemanticDomain::EN_MSG_PRESENTEDMAGNITUDEPICTURE));
   } break;
   case weatherfi_tclToken::EN_MSG_ENGINEERINGTEXTSTATUS:
   {
      bResult &= oPath.bGoDown(weatherfi_tclKnot(weatherfi_tclToken::EN_STRING,weatherfi_tclSemanticDomain::EN_MSG_MESSAGE));
   } break;
   case weatherfi_tclToken::EN_BINCONTAINER:
   case weatherfi_tclToken::EN_RESERVED:
   case weatherfi_tclToken::EN_U8_PERCENT:
   case weatherfi_tclToken::EN_S32_METER:
   case weatherfi_tclToken::EN_S32_FOOT:
   case weatherfi_tclToken::EN_S32_MILLIMETER:
   case weatherfi_tclToken::EN_POSIXTIME:
   case weatherfi_tclToken::EN_S16_KMPERHOUR:
   case weatherfi_tclToken::EN_S16_KNOT:
   case weatherfi_tclToken::EN_S16_KELVIN:
   case weatherfi_tclToken::EN_S16_FAHRENHEIT:
   case weatherfi_tclToken::EN_S32_PASCAL:
   case weatherfi_tclToken::EN_FIVERSION:
   case weatherfi_tclToken::EN_S32_LONGITUDE:
   case weatherfi_tclToken::EN_S32_LATITUDE:
   case weatherfi_tclToken::EN_POSITIONWGS84:
   case weatherfi_tclToken::EN_E16_ISOLANGUAGECODE:
   case weatherfi_tclToken::EN_U8_DIRECTIONABSOLUTE:
   case weatherfi_tclToken::EN_S16_DEGREE:
   case weatherfi_tclToken::EN_E8_BINCONTAINERTYPES:
   case weatherfi_tclToken::EN_E8_WEATHERSHAPETYPE:
   case weatherfi_tclToken::EN_B8_SHAPECONTENT:
   case weatherfi_tclToken::EN_WEATHERSHAPE:
   case weatherfi_tclToken::EN_WEATHERSHAPEUNION0:
   case weatherfi_tclToken::EN_E8_WEATHERTILETYPE:
   case weatherfi_tclToken::EN_E8_WEATHERTILEDATATYPE:
   case weatherfi_tclToken::EN_E8_PICTURETYPE:
   case weatherfi_tclToken::EN_TILEIDENTIFIER:
   case weatherfi_tclToken::EN_AREABOUNDINGBOX:
   case weatherfi_tclToken::EN_SCALE:
   case weatherfi_tclToken::EN_WEATHERSHAPELIST:
   case weatherfi_tclToken::EN_GRAPHICALWEATHERSHAPEBINCONTAINER:
   case weatherfi_tclToken::EN_E8_WEATHERFRONTTYPE:
   case weatherfi_tclToken::EN_E8_WEATHERPRESSURETYPE:
   case weatherfi_tclToken::EN_WEATHERSHAPETYPEISOBAR:
   case weatherfi_tclToken::EN_WEATHERSHAPETYPEWINDRADIUS:
   case weatherfi_tclToken::EN_E8_WEATHERSTORMPOSITIONTYPE:
   case weatherfi_tclToken::EN_E8_WEATHERSTORMTYPE:
   case weatherfi_tclToken::EN_B8_WEATHERSTORMTYPE:
   case weatherfi_tclToken::EN_WEATHERSHAPETYPESTORMATTRIBUTES:
   case weatherfi_tclToken::EN_WEATHERSHAPETYPEFRONT:
   case weatherfi_tclToken::EN_WEATHERSHAPETYPEPRESSURECENTER:
   case weatherfi_tclToken::EN_WEATHERSHAPETYPESTORMPOSITION:
   case weatherfi_tclToken::EN_WEATHERSHAPETYPESTORMTRACK:
   case weatherfi_tclToken::EN_E8_WEATHERID:
   case weatherfi_tclToken::EN_E8_COUNTYWARNINGCODE:
   case weatherfi_tclToken::EN_E8_TABULARWEATHERID:
   case weatherfi_tclToken::EN_E8_TIMEZONE:
   case weatherfi_tclToken::EN_STATE:
   case weatherfi_tclToken::EN_WEATHERCONDITION:
   case weatherfi_tclToken::EN_VISIBILITY:
   case weatherfi_tclToken::EN_METARSTATION:
   case weatherfi_tclToken::EN_CURRENTWEATHER:
   case weatherfi_tclToken::EN_WEATHERFORPOSITION:
   case weatherfi_tclToken::EN_MARINEZONE:
   case weatherfi_tclToken::EN_CODEDCITY:
   case weatherfi_tclToken::EN_WEATHERFORECAST:
   case weatherfi_tclToken::EN_WEATHERFORECASTFORPOSITION:
   case weatherfi_tclToken::EN_WARNINGID:
   case weatherfi_tclToken::EN_COUNTY:
   case weatherfi_tclToken::EN_COUNTYWARNING:
   case weatherfi_tclToken::EN_B16_FORECASTTYPE:
   case weatherfi_tclToken::EN_E8_FORECASTTYPE:
   case weatherfi_tclToken::EN_VERSIONPERFORECAST:
   case weatherfi_tclToken::EN_E8_PRECIPITATIONTYPE:
   case weatherfi_tclToken::EN_E8_CLOUDCOVERAGETYPE:
   case weatherfi_tclToken::EN_TABULARWEATHERLOCATION:
   case weatherfi_tclToken::EN_TABULARWEATHERCONDITION:
   case weatherfi_tclToken::EN_PRECIPITATION:
   case weatherfi_tclToken::EN_HUMIDITY:
   case weatherfi_tclToken::EN_CLOUDCOVERAGE:
   case weatherfi_tclToken::EN_UVLEVEL:
   case weatherfi_tclToken::EN_POLLENLEVEL:
   case weatherfi_tclToken::EN_TABULARWEATHERPERFORECAST:
   case weatherfi_tclToken::EN_TABULARWEATHER:
   case weatherfi_tclToken::EN_TABULARWEATHERFORPOSITION:
   case weatherfi_tclToken::EN_B16_SKIAREAATTRIBUTES:
   case weatherfi_tclToken::EN_SKIAREAATTRIBUTES:
   case weatherfi_tclToken::EN_SKICONDITION:
   case weatherfi_tclToken::EN_SKICONDITIONFORPOSITION:
   case weatherfi_tclToken::EN_E8_ALERTTYPE:
   case weatherfi_tclToken::EN_ALERTTYPE:
   case weatherfi_tclToken::EN_WEATHERALERTAREA:
   case weatherfi_tclToken::EN_STATEORZONE:
   case weatherfi_tclToken::EN_WEATHERALERT:
   case weatherfi_tclToken::EN_VERSIONPERSTATE:
   case weatherfi_tclToken::EN_STATESPERLANGUAGE:
   case weatherfi_tclToken::EN_WEATHERALERTSFORPOSITION:
   case weatherfi_tclToken::EN_SCALEFORTILE:
   case weatherfi_tclToken::EN_AREAINSTATE:
   case weatherfi_tclToken::EN_STATESANDAREASPERLANGUAGE:
   case weatherfi_tclToken::EN_E8_PRODUCTTYPE:
   case weatherfi_tclToken::EN_WEATHERSHAREDMEMORYDESCRIPTION:
   case weatherfi_tclToken::EN_E8_FORMATVERSION:
   case weatherfi_tclToken::EN_TILEANDRASTERPICTURESHAREDMEMORY:
   case weatherfi_tclToken::EN_RASTERTILE:
   case weatherfi_tclToken::EN_RASTERTILEPICTURE:
   case weatherfi_tclToken::EN_GRAPHICALWEATHERTILE:
   case weatherfi_tclToken::EN_GRAPHICALWEATHERTILEPICTURE:
   case weatherfi_tclToken::EN_VERSIONSOFTILE:
   case weatherfi_tclToken::EN_U8:   
   case weatherfi_tclToken::EN_S8:   
   case weatherfi_tclToken::EN_U16:   
   case weatherfi_tclToken::EN_S16:   
   case weatherfi_tclToken::EN_U24:   
   case weatherfi_tclToken::EN_S24:   
   case weatherfi_tclToken::EN_U32:   
   case weatherfi_tclToken::EN_S32:   
   case weatherfi_tclToken::EN_U64:   
   case weatherfi_tclToken::EN_S64:   
   case weatherfi_tclToken::EN_F32:   
   case weatherfi_tclToken::EN_F64:   
   case weatherfi_tclToken::EN_BOOL:   
   case weatherfi_tclToken::EN_STRING:   
   case weatherfi_tclToken::EN_MULTILANGUAGESTRING:   
   default:
      oPath.bGoDown(weatherfi_tclKnot(enMsgToken,weatherfi_tclSemanticDomain::EN_UNKNOWN));
      bResult = TRUE;
   }	
   return bResult;
}

tBool weatherfi_tclDescription::bDoIt(fi_tclVisitableTypeBase& oTypeBase)
{
   // --read or write?
   if (enType==EN_PARSING)
   {
     // --read first, then pass visitor
     (*poInContext) >> oTypeBase;
     oTypeBase.vTakeVisitor(*poVisitor);
   }
   else
   {
     // --first pass visitor, then stream 
	 oTypeBase.vTakeVisitor(*poVisitor);
     (*poOutContext) << oTypeBase;
   }
   return poVisitor->bIsValid();
}

tBool weatherfi_tclDescription::bProcessMessage() {
   tBool bResult = TRUE;
   tBool bInsideBinContainerVersion = false;
   tU16 u16MajorVersion;
   if (enType == EN_GENERATING)
   {
      u16MajorVersion = poOutContext->u16GetMajorVersion();
   }
   else
   {
      u16MajorVersion = poInContext->u16GetMajorVersion();
   }
   if (u16MajorVersion > 0x8000)
   {
      return FALSE;
   }
   tU16 u16SavedMajorVersion = u16MajorVersion;
   poVisitor->vReleaseBreak();
   while ((oPath.u32Position>0) && 
      bResult &&
      !poVisitor->bBreak() )    {
      // get current context (name, type, list index of next element)
      weatherfi_tclKnot oKnot = oPath.oGetIterator().oKnot();
      weatherfi_tclSemanticDomain::tenType enSemanticDomain = oKnot.enSemanticDomain;
      weatherfi_tclToken::tenType enToken = oKnot.enToken;
      tU32 u32Index = oKnot.u32Index;
      
      // lists need special handling
      if (enSemanticDomain == weatherfi_tclSemanticDomain::EN_LIST_ELEMENT) {
         oPath.bGoUp();
         // has list remaining elements?
         if (u32Index < oPath.oGetIterator().oKnot().u32Index) {
            // create next list element
            oPath.bGoDown(weatherfi_tclKnot(enToken,enSemanticDomain,u32Index+1));
            oPath.bGoDown(weatherfi_tclKnot(enToken,enSemanticDomain,u32Index));
         } else {
            // remove list, clean up
            oPath.bGoUp();
            oCallStack.bGoUp();
            continue;	
         }
      }
      // push current context on stack for visitor
      oCallStack.bGoDown(weatherfi_tclKnot(enToken,enSemanticDomain,u32Index));
      poVisitor->oIterator=oCallStack.oGetIterator();
      
      // now, process element
      switch (enToken) {
      case weatherfi_tclToken::EN_END_OF_STRUCT: 
      {
         // clean up after structures
         if (enSemanticDomain == weatherfi_tclSemanticDomain::EN_BINCONTAINER)
         {
            u16MajorVersion = u16SavedMajorVersion;
            if (enType == EN_GENERATING)
            {
               poOutContext->u16SetMajorVersion(u16MajorVersion);
            }
            else
            {
               poInContext->u16SetMajorVersion(u16MajorVersion);
            }
         }
         oPath.bGoUp();
         oCallStack.bGoUp();
         oCallStack.bGoUp();
      } break;
      case weatherfi_tclToken::EN_LIST: 
      {
         fi_tclList oList;
         // get list size
         if (!bDoIt(oList)) {
            // rearrange LIST and LIST_ELEMENT knots
            // pop "old" LIST knot
            oPath.bGoUp();
            // pop and backup LIST_ELEMENT knot
            weatherfi_tclKnot saveKnot;
            oPath.bGoUp(saveKnot);
            // push LIST knot
            oPath.bGoDown(weatherfi_tclKnot(enToken,enSemanticDomain,oList.u32ListSize));
            // push LIST_ELEMENT knot
            oPath.bGoDown(saveKnot);
            return FALSE;
         } else {
            // rearrange LIST and LIST_ELEMENT knots
            // pop "old" LIST knot
            oPath.bGoUp();
            // pop and backup LIST_ELEMENT knot
            weatherfi_tclKnot saveKnot;
            oPath.bGoUp(saveKnot);
            // push LIST knot
            oPath.bGoDown(weatherfi_tclKnot(enToken,enSemanticDomain,oList.u32ListSize));
            // push LIST_ELEMENT knot
            oPath.bGoDown(saveKnot);
         }
      } break;
      case weatherfi_tclToken::EN_U8: 
      {
         fi_tclU8 oU8;
         if (!bDoIt(oU8))
            return FALSE;
         oCallStack.bGoUp();
         oPath.bGoUp();
         if (bInsideBinContainerVersion)
         {
            bInsideBinContainerVersion = false;
            u16SavedMajorVersion = u16MajorVersion;
            u16MajorVersion = oU8.u8Value;
            if (enType == EN_GENERATING)
            {
               poOutContext->u16SetMajorVersion(u16MajorVersion);
            }
            else
            {
               poInContext->u16SetMajorVersion(u16MajorVersion);
            }
         }
      } break;
      case weatherfi_tclToken::EN_U16: 
      {
         fi_tclU16 oU16;
         if (!bDoIt(oU16))
            return FALSE;
         oCallStack.bGoUp();
         oPath.bGoUp();
      } break;
      case weatherfi_tclToken::EN_U24: 
      {
         fi_tclU24 oU24;
         if (!bDoIt(oU24))
            return FALSE;
         oCallStack.bGoUp();
         oPath.bGoUp();
      } break;
      case weatherfi_tclToken::EN_U32: 
      {
         fi_tclU32 oU32;
         if (!bDoIt(oU32))
            return FALSE;
         oCallStack.bGoUp();
         oPath.bGoUp();
      } break;
      case weatherfi_tclToken::EN_U64: 
      {
         fi_tclU64 oU64;
         if (!bDoIt(oU64))
            return FALSE;
         oCallStack.bGoUp();
         oPath.bGoUp();
      } break;
      case weatherfi_tclToken::EN_S8: 
      {
         fi_tclS8 oS8;
         if (!bDoIt(oS8))
            return FALSE;
         oCallStack.bGoUp();
         oPath.bGoUp();
      } break;
      case weatherfi_tclToken::EN_S16: 
      {
         fi_tclS16 oS16;
         if (!bDoIt(oS16))
            return FALSE;
         oCallStack.bGoUp();
         oPath.bGoUp();
      } break;
      case weatherfi_tclToken::EN_S24: 
      {
         fi_tclS24 oS24;
         if (!bDoIt(oS24))
            return FALSE;
         oCallStack.bGoUp();
         oPath.bGoUp();
      } break;
      case weatherfi_tclToken::EN_S32: 
      {
         fi_tclS32 oS32;
         if (!bDoIt(oS32))
            return FALSE;
         oCallStack.bGoUp();
         oPath.bGoUp();
      } break;
      case weatherfi_tclToken::EN_S64: 
      {
         fi_tclS64 oS64;
         if (!bDoIt(oS64))
            return FALSE;
         oCallStack.bGoUp();
         oPath.bGoUp();
      } break;
      case weatherfi_tclToken::EN_F32: 
      {
         fi_tclF32 oF32;
         if (!bDoIt(oF32))
            return FALSE;
         oCallStack.bGoUp();
         oPath.bGoUp();
      } break;
      case weatherfi_tclToken::EN_F64: 
      {
         fi_tclF64 oF64;
         if (!bDoIt(oF64))
            return FALSE;
         oCallStack.bGoUp();
         oPath.bGoUp();
      } break;
      case weatherfi_tclToken::EN_BOOL: 
      {
         fi_tclBool oBool;
         if (!bDoIt(oBool))
            return FALSE;
         oCallStack.bGoUp();
         oPath.bGoUp();
      } break;
      case weatherfi_tclToken::EN_STRING: 
      {
         fi_tclString oString;
         if (!bDoIt(oString)) {
            oString.vDestroy();
            return FALSE;
         }
         oString.vDestroy();
         oCallStack.bGoUp();
         oPath.bGoUp();
      } break;
      case weatherfi_tclToken::EN_MULTILANGUAGESTRING: 
      {
         fi_tclMultiLanguageString oString;
         if (!bDoIt(oString)) {
            oString.vDestroy();
            return FALSE;
         }
         oString.vDestroy();
         oCallStack.bGoUp();
         oPath.bGoUp();
      } break;
      // include rest of type expansions/processing
   case weatherfi_tclToken::EN_MSG_GETCURRENTWEATHERDATAMETHODSTART:
   case weatherfi_tclToken::EN_MSG_GETCURRENTWEATHERDATAMETHODRESULT:
   case weatherfi_tclToken::EN_MSG_GETWEATHERFORECASTDATAMETHODSTART:
   case weatherfi_tclToken::EN_MSG_GETWEATHERFORECASTDATAMETHODRESULT:
   case weatherfi_tclToken::EN_MSG_GETCOUNTYWARNINGDATAMETHODSTART:
   case weatherfi_tclToken::EN_MSG_GETCOUNTYWARNINGDATAMETHODRESULT:
   case weatherfi_tclToken::EN_MSG_GETFORECASTCITYLISTMETHODSTART:
   case weatherfi_tclToken::EN_MSG_GETFORECASTCITYLISTMETHODRESULT:
   case weatherfi_tclToken::EN_MSG_GETFORECASTFORCITYMETHODSTART:
   case weatherfi_tclToken::EN_MSG_GETFORECASTFORCITYMETHODRESULT:
   case weatherfi_tclToken::EN_MSG_GETTABULARWEATHERDATAMETHODSTART:
   case weatherfi_tclToken::EN_MSG_GETTABULARWEATHERDATAMETHODRESULT:
   case weatherfi_tclToken::EN_MSG_GETTABULARWEATHERSKICONDITIONDATAMETHODSTART:
   case weatherfi_tclToken::EN_MSG_GETTABULARWEATHERSKICONDITIONDATAMETHODRESULT:
   case weatherfi_tclToken::EN_MSG_GETWEATHERALERTDATAMETHODSTART:
   case weatherfi_tclToken::EN_MSG_GETWEATHERALERTDATAMETHODRESULT:
   case weatherfi_tclToken::EN_MSG_CONFIRMGRAPHICALWEATHERRASTERTILESHAREDMEMORYMETHODSTART:
   case weatherfi_tclToken::EN_MSG_CONFIRMGRAPHICALWEATHERRASTERTILESHAREDMEMORYMETHODRESULT:
   case weatherfi_tclToken::EN_MSG_CONFIRMGRAPHICALWEATHERTILEPICTUREDATAMETHODSTART:
   case weatherfi_tclToken::EN_MSG_CONFIRMGRAPHICALWEATHERTILEPICTUREDATAMETHODRESULT:
   case weatherfi_tclToken::EN_MSG_GETSURFACEDATAMETHODSTART:
   case weatherfi_tclToken::EN_MSG_GETSURFACEDATAMETHODRESULT:
   case weatherfi_tclToken::EN_MSG_GETSTORMATTRIBUTESDATAMETHODSTART:
   case weatherfi_tclToken::EN_MSG_GETSTORMATTRIBUTESDATAMETHODRESULT:
   case weatherfi_tclToken::EN_MSG_GETSTORMTRACKDATAMETHODSTART:
   case weatherfi_tclToken::EN_MSG_GETSTORMTRACKDATAMETHODRESULT:
   case weatherfi_tclToken::EN_MSG_CONFIRMRASTERTILESHAREDMEMORYMETHODSTART:
   case weatherfi_tclToken::EN_MSG_CONFIRMRASTERTILESHAREDMEMORYMETHODRESULT:
   case weatherfi_tclToken::EN_MSG_CONFIRMRASTERTILEPICTURESMETHODSTART:
   case weatherfi_tclToken::EN_MSG_CONFIRMRASTERTILEPICTURESMETHODRESULT:
   case weatherfi_tclToken::EN_MSG_CURRENTWEATHERDATACHANGEDGET:
   case weatherfi_tclToken::EN_MSG_CURRENTWEATHERDATACHANGEDUPREG:
   case weatherfi_tclToken::EN_MSG_CURRENTWEATHERDATACHANGEDRELUPREG:
   case weatherfi_tclToken::EN_MSG_CURRENTWEATHERDATACHANGEDSTATUS:
   case weatherfi_tclToken::EN_MSG_WEATHERFORECASTDATACHANGEDGET:
   case weatherfi_tclToken::EN_MSG_WEATHERFORECASTDATACHANGEDUPREG:
   case weatherfi_tclToken::EN_MSG_WEATHERFORECASTDATACHANGEDRELUPREG:
   case weatherfi_tclToken::EN_MSG_WEATHERFORECASTDATACHANGEDSTATUS:
   case weatherfi_tclToken::EN_MSG_COUNTYWARNINGDATACHANGEDGET:
   case weatherfi_tclToken::EN_MSG_COUNTYWARNINGDATACHANGEDUPREG:
   case weatherfi_tclToken::EN_MSG_COUNTYWARNINGDATACHANGEDRELUPREG:
   case weatherfi_tclToken::EN_MSG_COUNTYWARNINGDATACHANGEDSTATUS:
   case weatherfi_tclToken::EN_MSG_TABULARWEATHERDATAGET:
   case weatherfi_tclToken::EN_MSG_TABULARWEATHERDATAUPREG:
   case weatherfi_tclToken::EN_MSG_TABULARWEATHERDATARELUPREG:
   case weatherfi_tclToken::EN_MSG_TABULARWEATHERDATASTATUS:
   case weatherfi_tclToken::EN_MSG_TABULARWEATHERSKICONDITIONDATAGET:
   case weatherfi_tclToken::EN_MSG_TABULARWEATHERSKICONDITIONDATAUPREG:
   case weatherfi_tclToken::EN_MSG_TABULARWEATHERSKICONDITIONDATARELUPREG:
   case weatherfi_tclToken::EN_MSG_TABULARWEATHERSKICONDITIONDATASTATUS:
   case weatherfi_tclToken::EN_MSG_WEATHERALERTDATAGET:
   case weatherfi_tclToken::EN_MSG_WEATHERALERTDATAUPREG:
   case weatherfi_tclToken::EN_MSG_WEATHERALERTDATARELUPREG:
   case weatherfi_tclToken::EN_MSG_WEATHERALERTDATASTATUS:
   case weatherfi_tclToken::EN_MSG_GRAPHICALWEATHERRASTERTILESHAREDMEMORYGET:
   case weatherfi_tclToken::EN_MSG_GRAPHICALWEATHERRASTERTILESHAREDMEMORYUPREG:
   case weatherfi_tclToken::EN_MSG_GRAPHICALWEATHERRASTERTILESHAREDMEMORYRELUPREG:
   case weatherfi_tclToken::EN_MSG_GRAPHICALWEATHERRASTERTILESHAREDMEMORYSTATUS:
   case weatherfi_tclToken::EN_MSG_GRAPHICALWEATHERRADARANIMATIONSHAREDMEMORYGET:
   case weatherfi_tclToken::EN_MSG_GRAPHICALWEATHERRADARANIMATIONSHAREDMEMORYUPREG:
   case weatherfi_tclToken::EN_MSG_GRAPHICALWEATHERRADARANIMATIONSHAREDMEMORYRELUPREG:
   case weatherfi_tclToken::EN_MSG_GRAPHICALWEATHERRADARANIMATIONSHAREDMEMORYSTATUS:
   case weatherfi_tclToken::EN_MSG_GRAPHICALWEATHERTILEPICTUREDATAGET:
   case weatherfi_tclToken::EN_MSG_GRAPHICALWEATHERTILEPICTUREDATAUPREG:
   case weatherfi_tclToken::EN_MSG_GRAPHICALWEATHERTILEPICTUREDATARELUPREG:
   case weatherfi_tclToken::EN_MSG_GRAPHICALWEATHERTILEPICTUREDATASTATUS:
   case weatherfi_tclToken::EN_MSG_GRAPHICALWEATHERRADARANIMATIONPICTUREDATAGET:
   case weatherfi_tclToken::EN_MSG_GRAPHICALWEATHERRADARANIMATIONPICTUREDATAUPREG:
   case weatherfi_tclToken::EN_MSG_GRAPHICALWEATHERRADARANIMATIONPICTUREDATARELUPREG:
   case weatherfi_tclToken::EN_MSG_GRAPHICALWEATHERRADARANIMATIONPICTUREDATASTATUS:
   case weatherfi_tclToken::EN_MSG_SURFACEDATAUPREG:
   case weatherfi_tclToken::EN_MSG_SURFACEDATARELUPREG:
   case weatherfi_tclToken::EN_MSG_SURFACEDATAGET:
   case weatherfi_tclToken::EN_MSG_SURFACEDATASTATUS:
   case weatherfi_tclToken::EN_MSG_STORMATTRIBUTESDATAUPREG:
   case weatherfi_tclToken::EN_MSG_STORMATTRIBUTESDATARELUPREG:
   case weatherfi_tclToken::EN_MSG_STORMATTRIBUTESDATAGET:
   case weatherfi_tclToken::EN_MSG_STORMATTRIBUTESDATASTATUS:
   case weatherfi_tclToken::EN_MSG_STORMTRACKDATAUPREG:
   case weatherfi_tclToken::EN_MSG_STORMTRACKDATARELUPREG:
   case weatherfi_tclToken::EN_MSG_STORMTRACKDATAGET:
   case weatherfi_tclToken::EN_MSG_STORMTRACKDATASTATUS:
   case weatherfi_tclToken::EN_MSG_RASTERTILESHAREDMEMORIESGET:
   case weatherfi_tclToken::EN_MSG_RASTERTILESHAREDMEMORIESUPREG:
   case weatherfi_tclToken::EN_MSG_RASTERTILESHAREDMEMORIESRELUPREG:
   case weatherfi_tclToken::EN_MSG_RASTERTILESHAREDMEMORIESSTATUS:
   case weatherfi_tclToken::EN_MSG_RADARSTATICPICTUREDATAGET:
   case weatherfi_tclToken::EN_MSG_RADARSTATICPICTUREDATAUPREG:
   case weatherfi_tclToken::EN_MSG_RADARSTATICPICTUREDATARELUPREG:
   case weatherfi_tclToken::EN_MSG_RADARSTATICPICTUREDATASTATUS:
   case weatherfi_tclToken::EN_MSG_RADARANIMATIONDATAGET:
   case weatherfi_tclToken::EN_MSG_RADARANIMATIONDATAUPREG:
   case weatherfi_tclToken::EN_MSG_RADARANIMATIONDATARELUPREG:
   case weatherfi_tclToken::EN_MSG_RADARANIMATIONDATASTATUS:
   case weatherfi_tclToken::EN_MSG_WINDSTATICPICTUREDATAGET:
   case weatherfi_tclToken::EN_MSG_WINDSTATICPICTUREDATAUPREG:
   case weatherfi_tclToken::EN_MSG_WINDSTATICPICTUREDATARELUPREG:
   case weatherfi_tclToken::EN_MSG_WINDSTATICPICTUREDATASTATUS:
   case weatherfi_tclToken::EN_MSG_ENGINEERINGTEXTGET:
   case weatherfi_tclToken::EN_MSG_ENGINEERINGTEXTUPREG:
   case weatherfi_tclToken::EN_MSG_ENGINEERINGTEXTRELUPREG:
   case weatherfi_tclToken::EN_MSG_ENGINEERINGTEXTSTATUS:
      bInitMessage(enToken);
      break;
   case weatherfi_tclToken::EN_BINCONTAINER:
   {
      if (poVisitor->bDoExpand_BinContainer(enSemanticDomain))
      {
         oPath.bGoUp();
         oPath.bGoDown(weatherfi_tclKnot(weatherfi_tclToken::EN_END_OF_STRUCT,weatherfi_tclSemanticDomain::EN_UNKNOWN));
         oPath.bGoDown(weatherfi_tclKnot(weatherfi_tclToken::EN_U8,weatherfi_tclSemanticDomain::EN_LIST_ELEMENT,0));
         oPath.bGoDown(weatherfi_tclKnot(weatherfi_tclToken::EN_LIST,weatherfi_tclSemanticDomain::EN_CONTAINERDATALIST));
      }
      else
      {
         fi_tcl_BinContainer o_BinContainer;
         if (!bDoIt(o_BinContainer))
         {
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
            o_BinContainer.vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
            return FALSE;
         }
         else
         {
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
            o_BinContainer.vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
            oCallStack.bGoUp();
            oPath.bGoUp();
         }
      }
   } break;
   case weatherfi_tclToken::EN_RESERVED:
   {
      oCallStack.bGoUp();
      oPath.bGoUp();
   } break;
   case weatherfi_tclToken::EN_U8_PERCENT:
   {
      fi_tcl_u8_Percent o_u8_Percent;
      if (!bDoIt(o_u8_Percent))
         return FALSE;
      oCallStack.bGoUp();
      oPath.bGoUp();
   } break;
   case weatherfi_tclToken::EN_S32_METER:
   {
      fi_tcl_s32_Meter o_s32_Meter;
      if (!bDoIt(o_s32_Meter))
         return FALSE;
      oCallStack.bGoUp();
      oPath.bGoUp();
   } break;
   case weatherfi_tclToken::EN_S32_FOOT:
   {
      fi_tcl_s32_Foot o_s32_Foot;
      if (!bDoIt(o_s32_Foot))
         return FALSE;
      oCallStack.bGoUp();
      oPath.bGoUp();
   } break;
   case weatherfi_tclToken::EN_S32_MILLIMETER:
   {
      fi_tcl_s32_Millimeter o_s32_Millimeter;
      if (!bDoIt(o_s32_Millimeter))
         return FALSE;
      oCallStack.bGoUp();
      oPath.bGoUp();
   } break;
   case weatherfi_tclToken::EN_POSIXTIME:
   {
      if (poVisitor->bDoExpand_POSIXTime(enSemanticDomain))
      {
         oPath.bGoUp();
         oPath.bGoDown(weatherfi_tclKnot(weatherfi_tclToken::EN_END_OF_STRUCT,weatherfi_tclSemanticDomain::EN_UNKNOWN));
         oPath.bGoDown(weatherfi_tclKnot(weatherfi_tclToken::EN_S32,weatherfi_tclSemanticDomain::EN_TIME));
      }
      else
      {
         fi_tcl_POSIXTime o_POSIXTime;
         if (!bDoIt(o_POSIXTime))
         {
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
            o_POSIXTime.vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
            return FALSE;
         }
         else
         {
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
            o_POSIXTime.vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
            oCallStack.bGoUp();
            oPath.bGoUp();
         }
      }
   } break;
   case weatherfi_tclToken::EN_S16_KMPERHOUR:
   {
      fi_tcl_s16_KmPerHour o_s16_KmPerHour;
      if (!bDoIt(o_s16_KmPerHour))
         return FALSE;
      oCallStack.bGoUp();
      oPath.bGoUp();
   } break;
   case weatherfi_tclToken::EN_S16_KNOT:
   {
      fi_tcl_s16_Knot o_s16_Knot;
      if (!bDoIt(o_s16_Knot))
         return FALSE;
      oCallStack.bGoUp();
      oPath.bGoUp();
   } break;
   case weatherfi_tclToken::EN_S16_KELVIN:
   {
      fi_tcl_s16_Kelvin o_s16_Kelvin;
      if (!bDoIt(o_s16_Kelvin))
         return FALSE;
      oCallStack.bGoUp();
      oPath.bGoUp();
   } break;
   case weatherfi_tclToken::EN_S16_FAHRENHEIT:
   {
      fi_tcl_s16_Fahrenheit o_s16_Fahrenheit;
      if (!bDoIt(o_s16_Fahrenheit))
         return FALSE;
      oCallStack.bGoUp();
      oPath.bGoUp();
   } break;
   case weatherfi_tclToken::EN_S32_PASCAL:
   {
      fi_tcl_s32_Pascal o_s32_Pascal;
      if (!bDoIt(o_s32_Pascal))
         return FALSE;
      oCallStack.bGoUp();
      oPath.bGoUp();
   } break;
   case weatherfi_tclToken::EN_FIVERSION:
   {
      if (poVisitor->bDoExpand_FIVersion(enSemanticDomain))
      {
         oPath.bGoUp();
         oPath.bGoDown(weatherfi_tclKnot(weatherfi_tclToken::EN_END_OF_STRUCT,weatherfi_tclSemanticDomain::EN_UNKNOWN));
         oPath.bGoDown(weatherfi_tclKnot(weatherfi_tclToken::EN_U8,weatherfi_tclSemanticDomain::EN_PATCHVERSION));
         oPath.bGoDown(weatherfi_tclKnot(weatherfi_tclToken::EN_U8,weatherfi_tclSemanticDomain::EN_MINORVERSION));
         oPath.bGoDown(weatherfi_tclKnot(weatherfi_tclToken::EN_U8,weatherfi_tclSemanticDomain::EN_MAJORVERSION));
      }
      else
      {
         fi_tcl_FIVersion o_FIVersion;
         if (!bDoIt(o_FIVersion))
         {
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
            o_FIVersion.vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
            return FALSE;
         }
         else
         {
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
            o_FIVersion.vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
            oCallStack.bGoUp();
            oPath.bGoUp();
         }
      }
   } break;
   case weatherfi_tclToken::EN_S32_LONGITUDE:
   {
      fi_tcl_s32_Longitude o_s32_Longitude;
      if (!bDoIt(o_s32_Longitude))
         return FALSE;
      oCallStack.bGoUp();
      oPath.bGoUp();
   } break;
   case weatherfi_tclToken::EN_S32_LATITUDE:
   {
      fi_tcl_s32_Latitude o_s32_Latitude;
      if (!bDoIt(o_s32_Latitude))
         return FALSE;
      oCallStack.bGoUp();
      oPath.bGoUp();
   } break;
   case weatherfi_tclToken::EN_POSITIONWGS84:
   {
      if (poVisitor->bDoExpand_PositionWGS84(enSemanticDomain))
      {
         oPath.bGoUp();
         oPath.bGoDown(weatherfi_tclKnot(weatherfi_tclToken::EN_END_OF_STRUCT,weatherfi_tclSemanticDomain::EN_UNKNOWN));
         oPath.bGoDown(weatherfi_tclKnot(weatherfi_tclToken::EN_S32_LATITUDE,weatherfi_tclSemanticDomain::EN_LATITUDE));
         oPath.bGoDown(weatherfi_tclKnot(weatherfi_tclToken::EN_S32_LONGITUDE,weatherfi_tclSemanticDomain::EN_LONGITUDE));
      }
      else
      {
         fi_tcl_PositionWGS84 o_PositionWGS84;
         if (!bDoIt(o_PositionWGS84))
         {
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
            o_PositionWGS84.vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
            return FALSE;
         }
         else
         {
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
            o_PositionWGS84.vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
            oCallStack.bGoUp();
            oPath.bGoUp();
         }
      }
   } break;
   case weatherfi_tclToken::EN_E16_ISOLANGUAGECODE:
   {
      fi_tcl_e16_ISOLanguageCode o_e16_ISOLanguageCode;
      if (!bDoIt(o_e16_ISOLanguageCode))
         return FALSE;
      oCallStack.bGoUp();
      oPath.bGoUp();
   } break;
   case weatherfi_tclToken::EN_U8_DIRECTIONABSOLUTE:
   {
      fi_tcl_u8_DirectionAbsolute o_u8_DirectionAbsolute;
      if (!bDoIt(o_u8_DirectionAbsolute))
         return FALSE;
      oCallStack.bGoUp();
      oPath.bGoUp();
   } break;
   case weatherfi_tclToken::EN_S16_DEGREE:
   {
      fi_tcl_s16_Degree o_s16_Degree;
      if (!bDoIt(o_s16_Degree))
         return FALSE;
      oCallStack.bGoUp();
      oPath.bGoUp();
   } break;
   case weatherfi_tclToken::EN_E8_BINCONTAINERTYPES:
   {
      fi_tcl_e8_BinContainerTypes o_e8_BinContainerTypes;
      if (!bDoIt(o_e8_BinContainerTypes))
         return FALSE;
      oCallStack.bGoUp();
      oPath.bGoUp();
   } break;
   case weatherfi_tclToken::EN_E8_WEATHERSHAPETYPE:
   {
      fi_tcl_e8_WeatherShapeType o_e8_WeatherShapeType;
      if (!bDoIt(o_e8_WeatherShapeType))
         return FALSE;
      oCallStack.bGoUp();
      oPath.bGoUp();
   } break;
   case weatherfi_tclToken::EN_B8_SHAPECONTENT:
   {
      fi_tcl_b8_ShapeContent o_b8_ShapeContent;
      if (!bDoIt(o_b8_ShapeContent))
         return FALSE;
      oCallStack.bGoUp();
      oPath.bGoUp();
   } break;
   case weatherfi_tclToken::EN_WEATHERSHAPEUNION0:
   {
      oPath.bGoUp();
      oCallStack.bGoUp();
      fi_tcl_e8_WeatherShapeType oDataType;
      oCallStack.bGoDown(weatherfi_tclKnot(weatherfi_tclToken::EN_E8_WEATHERSHAPETYPE,weatherfi_tclSemanticDomain::EN_DATA_TYPE));
      poVisitor->oIterator = oCallStack.oGetIterator();
      bDoIt(oDataType);
      oCallStack.bGoUp();
      switch (oDataType.enType)
      {
      case fi_tcl_e8_WeatherShapeType::FI_EN_T_RESERVED:
         oPath.bGoDown(weatherfi_tclKnot(weatherfi_tclToken::EN_RESERVED,weatherfi_tclSemanticDomain::EN_SHAPETYPE));
         break;
      case fi_tcl_e8_WeatherShapeType::FI_EN_T_WEATHERSHAPETYPEFRONT:
         oPath.bGoDown(weatherfi_tclKnot(weatherfi_tclToken::EN_WEATHERSHAPETYPEFRONT,weatherfi_tclSemanticDomain::EN_SHAPETYPE));
         break;
      case fi_tcl_e8_WeatherShapeType::FI_EN_T_WEATHERSHAPETYPEPRESSURECENTER:
         oPath.bGoDown(weatherfi_tclKnot(weatherfi_tclToken::EN_WEATHERSHAPETYPEPRESSURECENTER,weatherfi_tclSemanticDomain::EN_SHAPETYPE));
         break;
      case fi_tcl_e8_WeatherShapeType::FI_EN_T_WEATHERSHAPETYPEISOBAR:
         oPath.bGoDown(weatherfi_tclKnot(weatherfi_tclToken::EN_WEATHERSHAPETYPEISOBAR,weatherfi_tclSemanticDomain::EN_SHAPETYPE));
         break;
      case fi_tcl_e8_WeatherShapeType::FI_EN_T_WEATHERSHAPETYPESTORMPOSITION:
         oPath.bGoDown(weatherfi_tclKnot(weatherfi_tclToken::EN_WEATHERSHAPETYPESTORMPOSITION,weatherfi_tclSemanticDomain::EN_SHAPETYPE));
         break;
      case fi_tcl_e8_WeatherShapeType::FI_EN_T_WEATHERSHAPETYPEWINDRADIUS:
         oPath.bGoDown(weatherfi_tclKnot(weatherfi_tclToken::EN_WEATHERSHAPETYPEWINDRADIUS,weatherfi_tclSemanticDomain::EN_SHAPETYPE));
         break;
      case fi_tcl_e8_WeatherShapeType::FI_EN_T_WEATHERSHAPETYPESTORMATTRIBUTES:
         oPath.bGoDown(weatherfi_tclKnot(weatherfi_tclToken::EN_WEATHERSHAPETYPESTORMATTRIBUTES,weatherfi_tclSemanticDomain::EN_SHAPETYPE));
         break;
      case fi_tcl_e8_WeatherShapeType::FI_EN_T_WEATHERSHAPETYPESTORMTRACK:
         oPath.bGoDown(weatherfi_tclKnot(weatherfi_tclToken::EN_WEATHERSHAPETYPESTORMTRACK,weatherfi_tclSemanticDomain::EN_SHAPETYPE));
         break;
      }
   } break;
   case weatherfi_tclToken::EN_WEATHERSHAPE:
   {
      if (poVisitor->bDoExpand_WeatherShape(enSemanticDomain))
      {
         oPath.bGoUp();
         oPath.bGoDown(weatherfi_tclKnot(weatherfi_tclToken::EN_END_OF_STRUCT,weatherfi_tclSemanticDomain::EN_UNKNOWN));
         oPath.bGoDown(weatherfi_tclKnot(weatherfi_tclToken::EN_WEATHERSHAPEUNION0,weatherfi_tclSemanticDomain::EN_SHAPETYPE));
      }
      else
      {
         fi_tcl_WeatherShape o_WeatherShape;
         if (!bDoIt(o_WeatherShape))
         {
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
            o_WeatherShape.vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
            return FALSE;
         }
         else
         {
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
            o_WeatherShape.vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
            oCallStack.bGoUp();
            oPath.bGoUp();
         }
      }
   } break;
   case weatherfi_tclToken::EN_E8_WEATHERTILETYPE:
   {
      fi_tcl_e8_WeatherTileType o_e8_WeatherTileType;
      if (!bDoIt(o_e8_WeatherTileType))
         return FALSE;
      oCallStack.bGoUp();
      oPath.bGoUp();
   } break;
   case weatherfi_tclToken::EN_E8_WEATHERTILEDATATYPE:
   {
      fi_tcl_e8_WeatherTileDataType o_e8_WeatherTileDataType;
      if (!bDoIt(o_e8_WeatherTileDataType))
         return FALSE;
      oCallStack.bGoUp();
      oPath.bGoUp();
   } break;
   case weatherfi_tclToken::EN_E8_PICTURETYPE:
   {
      fi_tcl_e8_PictureType o_e8_PictureType;
      if (!bDoIt(o_e8_PictureType))
         return FALSE;
      oCallStack.bGoUp();
      oPath.bGoUp();
   } break;
   case weatherfi_tclToken::EN_TILEIDENTIFIER:
   {
      if (poVisitor->bDoExpand_TileIdentifier(enSemanticDomain))
      {
         oPath.bGoUp();
         oPath.bGoDown(weatherfi_tclKnot(weatherfi_tclToken::EN_END_OF_STRUCT,weatherfi_tclSemanticDomain::EN_UNKNOWN));
         oPath.bGoDown(weatherfi_tclKnot(weatherfi_tclToken::EN_E8_WEATHERTILEDATATYPE,weatherfi_tclSemanticDomain::EN_TILEDATATYPE));
         oPath.bGoDown(weatherfi_tclKnot(weatherfi_tclToken::EN_E8_PICTURETYPE,weatherfi_tclSemanticDomain::EN_PICTURETYPE));
         oPath.bGoDown(weatherfi_tclKnot(weatherfi_tclToken::EN_E8_WEATHERTILETYPE,weatherfi_tclSemanticDomain::EN_TILETYPE));
      }
      else
      {
         fi_tcl_TileIdentifier o_TileIdentifier;
         if (!bDoIt(o_TileIdentifier))
         {
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
            o_TileIdentifier.vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
            return FALSE;
         }
         else
         {
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
            o_TileIdentifier.vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
            oCallStack.bGoUp();
            oPath.bGoUp();
         }
      }
   } break;
   case weatherfi_tclToken::EN_AREABOUNDINGBOX:
   {
      if (poVisitor->bDoExpand_AreaBoundingBox(enSemanticDomain))
      {
         oPath.bGoUp();
         oPath.bGoDown(weatherfi_tclKnot(weatherfi_tclToken::EN_END_OF_STRUCT,weatherfi_tclSemanticDomain::EN_UNKNOWN));
         oPath.bGoDown(weatherfi_tclKnot(weatherfi_tclToken::EN_POSITIONWGS84,weatherfi_tclSemanticDomain::EN_UPPERRIGTHPOSITION));
         oPath.bGoDown(weatherfi_tclKnot(weatherfi_tclToken::EN_POSITIONWGS84,weatherfi_tclSemanticDomain::EN_LOWERLEFTPOSITION));
      }
      else
      {
         fi_tcl_AreaBoundingBox o_AreaBoundingBox;
         if (!bDoIt(o_AreaBoundingBox))
         {
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
            o_AreaBoundingBox.vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
            return FALSE;
         }
         else
         {
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
            o_AreaBoundingBox.vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
            oCallStack.bGoUp();
            oPath.bGoUp();
         }
      }
   } break;
   case weatherfi_tclToken::EN_SCALE:
   {
      if (poVisitor->bDoExpand_Scale(enSemanticDomain))
      {
         oPath.bGoUp();
         oPath.bGoDown(weatherfi_tclKnot(weatherfi_tclToken::EN_END_OF_STRUCT,weatherfi_tclSemanticDomain::EN_UNKNOWN));
         oPath.bGoDown(weatherfi_tclKnot(weatherfi_tclToken::EN_U32,weatherfi_tclSemanticDomain::EN_NUMBERROWS));
         oPath.bGoDown(weatherfi_tclKnot(weatherfi_tclToken::EN_U32,weatherfi_tclSemanticDomain::EN_NUMBERCOLUMNS));
      }
      else
      {
         fi_tcl_Scale o_Scale;
         if (!bDoIt(o_Scale))
         {
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
            o_Scale.vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
            return FALSE;
         }
         else
         {
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
            o_Scale.vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
            oCallStack.bGoUp();
            oPath.bGoUp();
         }
      }
   } break;
   case weatherfi_tclToken::EN_WEATHERSHAPELIST:
   {
      if (poVisitor->bDoExpand_WeatherShapeList(enSemanticDomain))
      {
         oPath.bGoUp();
         oPath.bGoDown(weatherfi_tclKnot(weatherfi_tclToken::EN_END_OF_STRUCT,weatherfi_tclSemanticDomain::EN_UNKNOWN));
         oPath.bGoDown(weatherfi_tclKnot(weatherfi_tclToken::EN_WEATHERSHAPE,weatherfi_tclSemanticDomain::EN_LIST_ELEMENT,0));
         oPath.bGoDown(weatherfi_tclKnot(weatherfi_tclToken::EN_LIST,weatherfi_tclSemanticDomain::EN_WEATHERSHAPES));
         oPath.bGoDown(weatherfi_tclKnot(weatherfi_tclToken::EN_E8_WEATHERSHAPETYPE,weatherfi_tclSemanticDomain::EN_SHAPETYPE));
      }
      else
      {
         fi_tcl_WeatherShapeList o_WeatherShapeList;
         if (!bDoIt(o_WeatherShapeList))
         {
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
            o_WeatherShapeList.vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
            return FALSE;
         }
         else
         {
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
            o_WeatherShapeList.vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
            oCallStack.bGoUp();
            oPath.bGoUp();
         }
      }
   } break;
#ifndef FI_S_EXTERNAL_FI
   case weatherfi_tclToken::EN_GRAPHICALWEATHERSHAPEBINCONTAINER:
   {
      if (poVisitor->bDoExpand_GraphicalWeatherShapeBinContainer(enSemanticDomain))
      {
         oPath.bGoUp();
         bInsideBinContainerVersion = true;
         oPath.bGoDown(weatherfi_tclKnot(weatherfi_tclToken::EN_END_OF_STRUCT,weatherfi_tclSemanticDomain::EN_BINCONTAINER));
         oPath.bGoDown(weatherfi_tclKnot(weatherfi_tclToken::EN_WEATHERSHAPELIST,weatherfi_tclSemanticDomain::EN_LIST_ELEMENT,0));
         oPath.bGoDown(weatherfi_tclKnot(weatherfi_tclToken::EN_LIST,weatherfi_tclSemanticDomain::EN_WEATHERSHAPELISTS));
         oPath.bGoDown(weatherfi_tclKnot(weatherfi_tclToken::EN_E8_BINCONTAINERTYPES,weatherfi_tclSemanticDomain::EN_CONTAINERTYPE));
         oPath.bGoDown(weatherfi_tclKnot(weatherfi_tclToken::EN_FIVERSION,weatherfi_tclSemanticDomain::EN_CONTAINERFIVERSION));
         oPath.bGoDown(weatherfi_tclKnot(weatherfi_tclToken::EN_U16,weatherfi_tclSemanticDomain::EN_SERVICEID));
         oPath.bGoDown(weatherfi_tclKnot(weatherfi_tclToken::EN_U32,weatherfi_tclSemanticDomain::EN_CONTAINERLENGTH));
      }
      else
      {
         fi_tcl_GraphicalWeatherShapeBinContainer o_GraphicalWeatherShapeBinContainer;
         if (!bDoIt(o_GraphicalWeatherShapeBinContainer))
         {
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
            o_GraphicalWeatherShapeBinContainer.vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
            return FALSE;
         }
         else
         {
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
            o_GraphicalWeatherShapeBinContainer.vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
            oCallStack.bGoUp();
            oPath.bGoUp();
         }
      }
   } break;
#endif // FI_S_EXTERNAL_FI
   case weatherfi_tclToken::EN_E8_WEATHERFRONTTYPE:
   {
      fi_tcl_e8_WeatherFrontType o_e8_WeatherFrontType;
      if (!bDoIt(o_e8_WeatherFrontType))
         return FALSE;
      oCallStack.bGoUp();
      oPath.bGoUp();
   } break;
   case weatherfi_tclToken::EN_E8_WEATHERPRESSURETYPE:
   {
      fi_tcl_e8_WeatherPressureType o_e8_WeatherPressureType;
      if (!bDoIt(o_e8_WeatherPressureType))
         return FALSE;
      oCallStack.bGoUp();
      oPath.bGoUp();
   } break;
   case weatherfi_tclToken::EN_WEATHERSHAPETYPEISOBAR:
   {
      if (poVisitor->bDoExpand_WeatherShapeTypeIsobar(enSemanticDomain))
      {
         oPath.bGoUp();
         oPath.bGoDown(weatherfi_tclKnot(weatherfi_tclToken::EN_END_OF_STRUCT,weatherfi_tclSemanticDomain::EN_UNKNOWN));
         oPath.bGoDown(weatherfi_tclKnot(weatherfi_tclToken::EN_POSITIONWGS84,weatherfi_tclSemanticDomain::EN_LIST_ELEMENT,0));
         oPath.bGoDown(weatherfi_tclKnot(weatherfi_tclToken::EN_LIST,weatherfi_tclSemanticDomain::EN_GEOPOINTS));
         oPath.bGoDown(weatherfi_tclKnot(weatherfi_tclToken::EN_S32_PASCAL,weatherfi_tclSemanticDomain::EN_PRESSURE));
         oPath.bGoDown(weatherfi_tclKnot(weatherfi_tclToken::EN_POSIXTIME,weatherfi_tclSemanticDomain::EN_ISSUETIME));
         oPath.bGoDown(weatherfi_tclKnot(weatherfi_tclToken::EN_U32,weatherfi_tclSemanticDomain::EN_SHAPEID));
      }
      else
      {
         fi_tcl_WeatherShapeTypeIsobar o_WeatherShapeTypeIsobar;
         if (!bDoIt(o_WeatherShapeTypeIsobar))
         {
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
            o_WeatherShapeTypeIsobar.vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
            return FALSE;
         }
         else
         {
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
            o_WeatherShapeTypeIsobar.vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
            oCallStack.bGoUp();
            oPath.bGoUp();
         }
      }
   } break;
   case weatherfi_tclToken::EN_WEATHERSHAPETYPEWINDRADIUS:
   {
      if (poVisitor->bDoExpand_WeatherShapeTypeWindRadius(enSemanticDomain))
      {
         oPath.bGoUp();
         oPath.bGoDown(weatherfi_tclKnot(weatherfi_tclToken::EN_END_OF_STRUCT,weatherfi_tclSemanticDomain::EN_UNKNOWN));
         oPath.bGoDown(weatherfi_tclKnot(weatherfi_tclToken::EN_POSITIONWGS84,weatherfi_tclSemanticDomain::EN_LIST_ELEMENT,0));
         oPath.bGoDown(weatherfi_tclKnot(weatherfi_tclToken::EN_LIST,weatherfi_tclSemanticDomain::EN_GEOPOINTS));
         oPath.bGoDown(weatherfi_tclKnot(weatherfi_tclToken::EN_S16_KNOT,weatherfi_tclSemanticDomain::EN_WINDSPEED));
         oPath.bGoDown(weatherfi_tclKnot(weatherfi_tclToken::EN_POSIXTIME,weatherfi_tclSemanticDomain::EN_ISSUETIME));
         oPath.bGoDown(weatherfi_tclKnot(weatherfi_tclToken::EN_U32,weatherfi_tclSemanticDomain::EN_SHAPEID));
      }
      else
      {
         fi_tcl_WeatherShapeTypeWindRadius o_WeatherShapeTypeWindRadius;
         if (!bDoIt(o_WeatherShapeTypeWindRadius))
         {
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
            o_WeatherShapeTypeWindRadius.vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
            return FALSE;
         }
         else
         {
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
            o_WeatherShapeTypeWindRadius.vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
            oCallStack.bGoUp();
            oPath.bGoUp();
         }
      }
   } break;
   case weatherfi_tclToken::EN_E8_WEATHERSTORMPOSITIONTYPE:
   {
      fi_tcl_e8_WeatherStormPositionType o_e8_WeatherStormPositionType;
      if (!bDoIt(o_e8_WeatherStormPositionType))
         return FALSE;
      oCallStack.bGoUp();
      oPath.bGoUp();
   } break;
   case weatherfi_tclToken::EN_E8_WEATHERSTORMTYPE:
   {
      fi_tcl_e8_WeatherStormType o_e8_WeatherStormType;
      if (!bDoIt(o_e8_WeatherStormType))
         return FALSE;
      oCallStack.bGoUp();
      oPath.bGoUp();
   } break;
   case weatherfi_tclToken::EN_B8_WEATHERSTORMTYPE:
   {
      fi_tcl_b8_WeatherStormType o_b8_WeatherStormType;
      if (!bDoIt(o_b8_WeatherStormType))
         return FALSE;
      oCallStack.bGoUp();
      oPath.bGoUp();
   } break;
   case weatherfi_tclToken::EN_WEATHERSHAPETYPESTORMATTRIBUTES:
   {
      if (poVisitor->bDoExpand_WeatherShapeTypeStormAttributes(enSemanticDomain))
      {
         oPath.bGoUp();
         oPath.bGoDown(weatherfi_tclKnot(weatherfi_tclToken::EN_END_OF_STRUCT,weatherfi_tclSemanticDomain::EN_UNKNOWN));
         oPath.bGoDown(weatherfi_tclKnot(weatherfi_tclToken::EN_POSITIONWGS84,weatherfi_tclSemanticDomain::EN_GEOPOINT));
         oPath.bGoDown(weatherfi_tclKnot(weatherfi_tclToken::EN_B8_WEATHERSTORMTYPE,weatherfi_tclSemanticDomain::EN_STORMTYPE));
         oPath.bGoDown(weatherfi_tclKnot(weatherfi_tclToken::EN_S16_KNOT,weatherfi_tclSemanticDomain::EN_MOVEMENTSPEED));
         oPath.bGoDown(weatherfi_tclKnot(weatherfi_tclToken::EN_S16_DEGREE,weatherfi_tclSemanticDomain::EN_MOVEMENTDIRECTION));
         oPath.bGoDown(weatherfi_tclKnot(weatherfi_tclToken::EN_S32_FOOT,weatherfi_tclSemanticDomain::EN_ECHOTOPHEIGHT));
         oPath.bGoDown(weatherfi_tclKnot(weatherfi_tclToken::EN_POSIXTIME,weatherfi_tclSemanticDomain::EN_OBSERVATIONTIME));
         oPath.bGoDown(weatherfi_tclKnot(weatherfi_tclToken::EN_STRING,weatherfi_tclSemanticDomain::EN_STORMUNIQUEID));
         oPath.bGoDown(weatherfi_tclKnot(weatherfi_tclToken::EN_POSIXTIME,weatherfi_tclSemanticDomain::EN_ISSUETIME));
         oPath.bGoDown(weatherfi_tclKnot(weatherfi_tclToken::EN_U32,weatherfi_tclSemanticDomain::EN_SHAPEID));
      }
      else
      {
         fi_tcl_WeatherShapeTypeStormAttributes o_WeatherShapeTypeStormAttributes;
         if (!bDoIt(o_WeatherShapeTypeStormAttributes))
         {
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
            o_WeatherShapeTypeStormAttributes.vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
            return FALSE;
         }
         else
         {
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
            o_WeatherShapeTypeStormAttributes.vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
            oCallStack.bGoUp();
            oPath.bGoUp();
         }
      }
   } break;
   case weatherfi_tclToken::EN_WEATHERSHAPETYPEFRONT:
   {
      if (poVisitor->bDoExpand_WeatherShapeTypeFront(enSemanticDomain))
      {
         oPath.bGoUp();
         oPath.bGoDown(weatherfi_tclKnot(weatherfi_tclToken::EN_END_OF_STRUCT,weatherfi_tclSemanticDomain::EN_UNKNOWN));
         oPath.bGoDown(weatherfi_tclKnot(weatherfi_tclToken::EN_POSITIONWGS84,weatherfi_tclSemanticDomain::EN_LIST_ELEMENT,0));
         oPath.bGoDown(weatherfi_tclKnot(weatherfi_tclToken::EN_LIST,weatherfi_tclSemanticDomain::EN_GEOPOINTS));
         oPath.bGoDown(weatherfi_tclKnot(weatherfi_tclToken::EN_E8_WEATHERFRONTTYPE,weatherfi_tclSemanticDomain::EN_FRONTTYPE));
         oPath.bGoDown(weatherfi_tclKnot(weatherfi_tclToken::EN_POSIXTIME,weatherfi_tclSemanticDomain::EN_ISSUETIME));
         oPath.bGoDown(weatherfi_tclKnot(weatherfi_tclToken::EN_U32,weatherfi_tclSemanticDomain::EN_SHAPEID));
      }
      else
      {
         fi_tcl_WeatherShapeTypeFront o_WeatherShapeTypeFront;
         if (!bDoIt(o_WeatherShapeTypeFront))
         {
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
            o_WeatherShapeTypeFront.vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
            return FALSE;
         }
         else
         {
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
            o_WeatherShapeTypeFront.vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
            oCallStack.bGoUp();
            oPath.bGoUp();
         }
      }
   } break;
   case weatherfi_tclToken::EN_WEATHERSHAPETYPEPRESSURECENTER:
   {
      if (poVisitor->bDoExpand_WeatherShapeTypePressureCenter(enSemanticDomain))
      {
         oPath.bGoUp();
         oPath.bGoDown(weatherfi_tclKnot(weatherfi_tclToken::EN_END_OF_STRUCT,weatherfi_tclSemanticDomain::EN_UNKNOWN));
         oPath.bGoDown(weatherfi_tclKnot(weatherfi_tclToken::EN_POSITIONWGS84,weatherfi_tclSemanticDomain::EN_GEOPOINT));
         oPath.bGoDown(weatherfi_tclKnot(weatherfi_tclToken::EN_S32_PASCAL,weatherfi_tclSemanticDomain::EN_PRESSURE));
         oPath.bGoDown(weatherfi_tclKnot(weatherfi_tclToken::EN_E8_WEATHERPRESSURETYPE,weatherfi_tclSemanticDomain::EN_PRESSURETYPE));
         oPath.bGoDown(weatherfi_tclKnot(weatherfi_tclToken::EN_POSIXTIME,weatherfi_tclSemanticDomain::EN_ISSUETIME));
         oPath.bGoDown(weatherfi_tclKnot(weatherfi_tclToken::EN_U32,weatherfi_tclSemanticDomain::EN_SHAPEID));
      }
      else
      {
         fi_tcl_WeatherShapeTypePressureCenter o_WeatherShapeTypePressureCenter;
         if (!bDoIt(o_WeatherShapeTypePressureCenter))
         {
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
            o_WeatherShapeTypePressureCenter.vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
            return FALSE;
         }
         else
         {
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
            o_WeatherShapeTypePressureCenter.vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
            oCallStack.bGoUp();
            oPath.bGoUp();
         }
      }
   } break;
   case weatherfi_tclToken::EN_WEATHERSHAPETYPESTORMPOSITION:
   {
      if (poVisitor->bDoExpand_WeatherShapeTypeStormPosition(enSemanticDomain))
      {
         oPath.bGoUp();
         oPath.bGoDown(weatherfi_tclKnot(weatherfi_tclToken::EN_END_OF_STRUCT,weatherfi_tclSemanticDomain::EN_UNKNOWN));
         oPath.bGoDown(weatherfi_tclKnot(weatherfi_tclToken::EN_WEATHERSHAPETYPEWINDRADIUS,weatherfi_tclSemanticDomain::EN_LIST_ELEMENT,0));
         oPath.bGoDown(weatherfi_tclKnot(weatherfi_tclToken::EN_LIST,weatherfi_tclSemanticDomain::EN_WINDRADIUSLIST));
         oPath.bGoDown(weatherfi_tclKnot(weatherfi_tclToken::EN_POSITIONWGS84,weatherfi_tclSemanticDomain::EN_GEOPOINT));
         oPath.bGoDown(weatherfi_tclKnot(weatherfi_tclToken::EN_E8_WEATHERSTORMTYPE,weatherfi_tclSemanticDomain::EN_STORMTYPE));
         oPath.bGoDown(weatherfi_tclKnot(weatherfi_tclToken::EN_POSIXTIME,weatherfi_tclSemanticDomain::EN_TIMESTAMP));
         oPath.bGoDown(weatherfi_tclKnot(weatherfi_tclToken::EN_S32_PASCAL,weatherfi_tclSemanticDomain::EN_PRESSURE));
         oPath.bGoDown(weatherfi_tclKnot(weatherfi_tclToken::EN_S16_KNOT,weatherfi_tclSemanticDomain::EN_GUSTS));
         oPath.bGoDown(weatherfi_tclKnot(weatherfi_tclToken::EN_S16_KNOT,weatherfi_tclSemanticDomain::EN_MAXSUSTAINEDWINDS));
         oPath.bGoDown(weatherfi_tclKnot(weatherfi_tclToken::EN_S16_KNOT,weatherfi_tclSemanticDomain::EN_SPEED));
         oPath.bGoDown(weatherfi_tclKnot(weatherfi_tclToken::EN_S16_DEGREE,weatherfi_tclSemanticDomain::EN_DIRECTION));
         oPath.bGoDown(weatherfi_tclKnot(weatherfi_tclToken::EN_E8_WEATHERSTORMPOSITIONTYPE,weatherfi_tclSemanticDomain::EN_POSITIONTYPE));
         oPath.bGoDown(weatherfi_tclKnot(weatherfi_tclToken::EN_POSIXTIME,weatherfi_tclSemanticDomain::EN_ISSUETIME));
         oPath.bGoDown(weatherfi_tclKnot(weatherfi_tclToken::EN_U32,weatherfi_tclSemanticDomain::EN_SHAPEID));
      }
      else
      {
         fi_tcl_WeatherShapeTypeStormPosition o_WeatherShapeTypeStormPosition;
         if (!bDoIt(o_WeatherShapeTypeStormPosition))
         {
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
            o_WeatherShapeTypeStormPosition.vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
            return FALSE;
         }
         else
         {
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
            o_WeatherShapeTypeStormPosition.vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
            oCallStack.bGoUp();
            oPath.bGoUp();
         }
      }
   } break;
   case weatherfi_tclToken::EN_WEATHERSHAPETYPESTORMTRACK:
   {
      if (poVisitor->bDoExpand_WeatherShapeTypeStormTrack(enSemanticDomain))
      {
         oPath.bGoUp();
         oPath.bGoDown(weatherfi_tclKnot(weatherfi_tclToken::EN_END_OF_STRUCT,weatherfi_tclSemanticDomain::EN_UNKNOWN));
         oPath.bGoDown(weatherfi_tclKnot(weatherfi_tclToken::EN_WEATHERSHAPETYPESTORMPOSITION,weatherfi_tclSemanticDomain::EN_LIST_ELEMENT,0));
         oPath.bGoDown(weatherfi_tclKnot(weatherfi_tclToken::EN_LIST,weatherfi_tclSemanticDomain::EN_STORMPOSITIONLIST));
         oPath.bGoDown(weatherfi_tclKnot(weatherfi_tclToken::EN_STRING,weatherfi_tclSemanticDomain::EN_STORMNAME));
         oPath.bGoDown(weatherfi_tclKnot(weatherfi_tclToken::EN_STRING,weatherfi_tclSemanticDomain::EN_STORMUNIQUEID));
         oPath.bGoDown(weatherfi_tclKnot(weatherfi_tclToken::EN_U32,weatherfi_tclSemanticDomain::EN_SHAPEID));
      }
      else
      {
         fi_tcl_WeatherShapeTypeStormTrack o_WeatherShapeTypeStormTrack;
         if (!bDoIt(o_WeatherShapeTypeStormTrack))
         {
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
            o_WeatherShapeTypeStormTrack.vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
            return FALSE;
         }
         else
         {
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
            o_WeatherShapeTypeStormTrack.vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
            oCallStack.bGoUp();
            oPath.bGoUp();
         }
      }
   } break;
   case weatherfi_tclToken::EN_E8_WEATHERID:
   {
      fi_tcl_e8_WeatherId o_e8_WeatherId;
      if (!bDoIt(o_e8_WeatherId))
         return FALSE;
      oCallStack.bGoUp();
      oPath.bGoUp();
   } break;
   case weatherfi_tclToken::EN_E8_COUNTYWARNINGCODE:
   {
      fi_tcl_e8_CountyWarningCode o_e8_CountyWarningCode;
      if (!bDoIt(o_e8_CountyWarningCode))
         return FALSE;
      oCallStack.bGoUp();
      oPath.bGoUp();
   } break;
   case weatherfi_tclToken::EN_E8_TABULARWEATHERID:
   {
      fi_tcl_e8_TabularWeatherId o_e8_TabularWeatherId;
      if (!bDoIt(o_e8_TabularWeatherId))
         return FALSE;
      oCallStack.bGoUp();
      oPath.bGoUp();
   } break;
   case weatherfi_tclToken::EN_E8_TIMEZONE:
   {
      fi_tcl_e8_Timezone o_e8_Timezone;
      if (!bDoIt(o_e8_Timezone))
         return FALSE;
      oCallStack.bGoUp();
      oPath.bGoUp();
   } break;
   case weatherfi_tclToken::EN_STATE:
   {
      if (poVisitor->bDoExpand_State(enSemanticDomain))
      {
         oPath.bGoUp();
         oPath.bGoDown(weatherfi_tclKnot(weatherfi_tclToken::EN_END_OF_STRUCT,weatherfi_tclSemanticDomain::EN_UNKNOWN));
         oPath.bGoDown(weatherfi_tclKnot(weatherfi_tclToken::EN_STRING,weatherfi_tclSemanticDomain::EN_STATENAME));
         oPath.bGoDown(weatherfi_tclKnot(weatherfi_tclToken::EN_STRING,weatherfi_tclSemanticDomain::EN_STATEID));
      }
      else
      {
         fi_tcl_State o_State;
         if (!bDoIt(o_State))
         {
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
            o_State.vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
            return FALSE;
         }
         else
         {
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
            o_State.vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
            oCallStack.bGoUp();
            oPath.bGoUp();
         }
      }
   } break;
   case weatherfi_tclToken::EN_WEATHERCONDITION:
   {
      if (poVisitor->bDoExpand_WeatherCondition(enSemanticDomain))
      {
         oPath.bGoUp();
         oPath.bGoDown(weatherfi_tclKnot(weatherfi_tclToken::EN_END_OF_STRUCT,weatherfi_tclSemanticDomain::EN_UNKNOWN));
         oPath.bGoDown(weatherfi_tclKnot(weatherfi_tclToken::EN_MULTILANGUAGESTRING,weatherfi_tclSemanticDomain::EN_WEATHERDESCRIPTION));
         oPath.bGoDown(weatherfi_tclKnot(weatherfi_tclToken::EN_E8_WEATHERID,weatherfi_tclSemanticDomain::EN_WEATHERID));
      }
      else
      {
         fi_tcl_WeatherCondition o_WeatherCondition;
         if (!bDoIt(o_WeatherCondition))
         {
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
            o_WeatherCondition.vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
            return FALSE;
         }
         else
         {
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
            o_WeatherCondition.vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
            oCallStack.bGoUp();
            oPath.bGoUp();
         }
      }
   } break;
   case weatherfi_tclToken::EN_VISIBILITY:
   {
      if (poVisitor->bDoExpand_Visibility(enSemanticDomain))
      {
         oPath.bGoUp();
         oPath.bGoDown(weatherfi_tclKnot(weatherfi_tclToken::EN_END_OF_STRUCT,weatherfi_tclSemanticDomain::EN_UNKNOWN));
         oPath.bGoDown(weatherfi_tclKnot(weatherfi_tclToken::EN_S32_METER,weatherfi_tclSemanticDomain::EN_VISIBILITY));
         oPath.bGoDown(weatherfi_tclKnot(weatherfi_tclToken::EN_BOOL,weatherfi_tclSemanticDomain::EN_LESSTHAN));
      }
      else
      {
         fi_tcl_Visibility o_Visibility;
         if (!bDoIt(o_Visibility))
         {
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
            o_Visibility.vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
            return FALSE;
         }
         else
         {
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
            o_Visibility.vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
            oCallStack.bGoUp();
            oPath.bGoUp();
         }
      }
   } break;
   case weatherfi_tclToken::EN_METARSTATION:
   {
      if (poVisitor->bDoExpand_MetarStation(enSemanticDomain))
      {
         oPath.bGoUp();
         oPath.bGoDown(weatherfi_tclKnot(weatherfi_tclToken::EN_END_OF_STRUCT,weatherfi_tclSemanticDomain::EN_UNKNOWN));
         oPath.bGoDown(weatherfi_tclKnot(weatherfi_tclToken::EN_E8_TIMEZONE,weatherfi_tclSemanticDomain::EN_TIMEZONE));
         oPath.bGoDown(weatherfi_tclKnot(weatherfi_tclToken::EN_POSITIONWGS84,weatherfi_tclSemanticDomain::EN_STATIONCOORDINATES));
         oPath.bGoDown(weatherfi_tclKnot(weatherfi_tclToken::EN_STATE,weatherfi_tclSemanticDomain::EN_STATE));
         oPath.bGoDown(weatherfi_tclKnot(weatherfi_tclToken::EN_STRING,weatherfi_tclSemanticDomain::EN_STATIONNAME));
         oPath.bGoDown(weatherfi_tclKnot(weatherfi_tclToken::EN_U32,weatherfi_tclSemanticDomain::EN_STATIONID));
      }
      else
      {
         fi_tcl_MetarStation o_MetarStation;
         if (!bDoIt(o_MetarStation))
         {
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
            o_MetarStation.vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
            return FALSE;
         }
         else
         {
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
            o_MetarStation.vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
            oCallStack.bGoUp();
            oPath.bGoUp();
         }
      }
   } break;
   case weatherfi_tclToken::EN_CURRENTWEATHER:
   {
      if (poVisitor->bDoExpand_CurrentWeather(enSemanticDomain))
      {
         oPath.bGoUp();
         oPath.bGoDown(weatherfi_tclKnot(weatherfi_tclToken::EN_END_OF_STRUCT,weatherfi_tclSemanticDomain::EN_UNKNOWN));
         oPath.bGoDown(weatherfi_tclKnot(weatherfi_tclToken::EN_S32_PASCAL,weatherfi_tclSemanticDomain::EN_PRESSURE));
         oPath.bGoDown(weatherfi_tclKnot(weatherfi_tclToken::EN_S16_KMPERHOUR,weatherfi_tclSemanticDomain::EN_WINDSPEED));
         oPath.bGoDown(weatherfi_tclKnot(weatherfi_tclToken::EN_U8_DIRECTIONABSOLUTE,weatherfi_tclSemanticDomain::EN_WINDDIRECTION));
         oPath.bGoDown(weatherfi_tclKnot(weatherfi_tclToken::EN_VISIBILITY,weatherfi_tclSemanticDomain::EN_VISIBILITY));
         oPath.bGoDown(weatherfi_tclKnot(weatherfi_tclToken::EN_S16_KELVIN,weatherfi_tclSemanticDomain::EN_DEWPOINT));
         oPath.bGoDown(weatherfi_tclKnot(weatherfi_tclToken::EN_S16_KELVIN,weatherfi_tclSemanticDomain::EN_TEMPERATURE));
         oPath.bGoDown(weatherfi_tclKnot(weatherfi_tclToken::EN_WEATHERCONDITION,weatherfi_tclSemanticDomain::EN_WEATHERCONDITION));
         oPath.bGoDown(weatherfi_tclKnot(weatherfi_tclToken::EN_POSIXTIME,weatherfi_tclSemanticDomain::EN_GENERATIONTIME));
         oPath.bGoDown(weatherfi_tclKnot(weatherfi_tclToken::EN_S32_METER,weatherfi_tclSemanticDomain::EN_DISTANCE));
         oPath.bGoDown(weatherfi_tclKnot(weatherfi_tclToken::EN_METARSTATION,weatherfi_tclSemanticDomain::EN_METARSTATION));
      }
      else
      {
         fi_tcl_CurrentWeather o_CurrentWeather;
         if (!bDoIt(o_CurrentWeather))
         {
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
            o_CurrentWeather.vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
            return FALSE;
         }
         else
         {
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
            o_CurrentWeather.vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
            oCallStack.bGoUp();
            oPath.bGoUp();
         }
      }
   } break;
   case weatherfi_tclToken::EN_WEATHERFORPOSITION:
   {
      if (poVisitor->bDoExpand_WeatherForPosition(enSemanticDomain))
      {
         oPath.bGoUp();
         oPath.bGoDown(weatherfi_tclKnot(weatherfi_tclToken::EN_END_OF_STRUCT,weatherfi_tclSemanticDomain::EN_UNKNOWN));
         oPath.bGoDown(weatherfi_tclKnot(weatherfi_tclToken::EN_CURRENTWEATHER,weatherfi_tclSemanticDomain::EN_LIST_ELEMENT,0));
         oPath.bGoDown(weatherfi_tclKnot(weatherfi_tclToken::EN_LIST,weatherfi_tclSemanticDomain::EN_CURRENTWEATHERSITUATION));
         oPath.bGoDown(weatherfi_tclKnot(weatherfi_tclToken::EN_POSITIONWGS84,weatherfi_tclSemanticDomain::EN_POSITION));
      }
      else
      {
         fi_tcl_WeatherForPosition o_WeatherForPosition;
         if (!bDoIt(o_WeatherForPosition))
         {
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
            o_WeatherForPosition.vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
            return FALSE;
         }
         else
         {
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
            o_WeatherForPosition.vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
            oCallStack.bGoUp();
            oPath.bGoUp();
         }
      }
   } break;
   case weatherfi_tclToken::EN_MARINEZONE:
   {
      if (poVisitor->bDoExpand_MarineZone(enSemanticDomain))
      {
         oPath.bGoUp();
         oPath.bGoDown(weatherfi_tclKnot(weatherfi_tclToken::EN_END_OF_STRUCT,weatherfi_tclSemanticDomain::EN_UNKNOWN));
         oPath.bGoDown(weatherfi_tclKnot(weatherfi_tclToken::EN_STRING,weatherfi_tclSemanticDomain::EN_MARINEZONENAME));
         oPath.bGoDown(weatherfi_tclKnot(weatherfi_tclToken::EN_STRING,weatherfi_tclSemanticDomain::EN_MARINEZONEID));
      }
      else
      {
         fi_tcl_MarineZone o_MarineZone;
         if (!bDoIt(o_MarineZone))
         {
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
            o_MarineZone.vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
            return FALSE;
         }
         else
         {
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
            o_MarineZone.vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
            oCallStack.bGoUp();
            oPath.bGoUp();
         }
      }
   } break;
   case weatherfi_tclToken::EN_CODEDCITY:
   {
      if (poVisitor->bDoExpand_CodedCity(enSemanticDomain))
      {
         oPath.bGoUp();
         oPath.bGoDown(weatherfi_tclKnot(weatherfi_tclToken::EN_END_OF_STRUCT,weatherfi_tclSemanticDomain::EN_UNKNOWN));
         oPath.bGoDown(weatherfi_tclKnot(weatherfi_tclToken::EN_E8_TIMEZONE,weatherfi_tclSemanticDomain::EN_TIMEZONE));
         oPath.bGoDown(weatherfi_tclKnot(weatherfi_tclToken::EN_POSITIONWGS84,weatherfi_tclSemanticDomain::EN_CITYCOORDINATES));
         oPath.bGoDown(weatherfi_tclKnot(weatherfi_tclToken::EN_STATE,weatherfi_tclSemanticDomain::EN_STATE));
         oPath.bGoDown(weatherfi_tclKnot(weatherfi_tclToken::EN_STRING,weatherfi_tclSemanticDomain::EN_CITYNAME));
         oPath.bGoDown(weatherfi_tclKnot(weatherfi_tclToken::EN_U32,weatherfi_tclSemanticDomain::EN_CITYID));
      }
      else
      {
         fi_tcl_CodedCity o_CodedCity;
         if (!bDoIt(o_CodedCity))
         {
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
            o_CodedCity.vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
            return FALSE;
         }
         else
         {
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
            o_CodedCity.vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
            oCallStack.bGoUp();
            oPath.bGoUp();
         }
      }
   } break;
   case weatherfi_tclToken::EN_WEATHERFORECAST:
   {
      if (poVisitor->bDoExpand_WeatherForecast(enSemanticDomain))
      {
         oPath.bGoUp();
         oPath.bGoDown(weatherfi_tclKnot(weatherfi_tclToken::EN_END_OF_STRUCT,weatherfi_tclSemanticDomain::EN_UNKNOWN));
         oPath.bGoDown(weatherfi_tclKnot(weatherfi_tclToken::EN_S16_KELVIN,weatherfi_tclSemanticDomain::EN_LIST_ELEMENT,0));
         oPath.bGoDown(weatherfi_tclKnot(weatherfi_tclToken::EN_LIST,weatherfi_tclSemanticDomain::EN_MINMAXTEMPERATURELIST));
         oPath.bGoDown(weatherfi_tclKnot(weatherfi_tclToken::EN_WEATHERCONDITION,weatherfi_tclSemanticDomain::EN_LIST_ELEMENT,0));
         oPath.bGoDown(weatherfi_tclKnot(weatherfi_tclToken::EN_LIST,weatherfi_tclSemanticDomain::EN_WEATHERCONDITIONLIST));
         oPath.bGoDown(weatherfi_tclKnot(weatherfi_tclToken::EN_POSIXTIME,weatherfi_tclSemanticDomain::EN_FORECASTSTARTTIME));
         oPath.bGoDown(weatherfi_tclKnot(weatherfi_tclToken::EN_POSIXTIME,weatherfi_tclSemanticDomain::EN_GENERATIONTIME));
         oPath.bGoDown(weatherfi_tclKnot(weatherfi_tclToken::EN_S32_METER,weatherfi_tclSemanticDomain::EN_DISTANCE));
         oPath.bGoDown(weatherfi_tclKnot(weatherfi_tclToken::EN_CODEDCITY,weatherfi_tclSemanticDomain::EN_CODEDCITY));
      }
      else
      {
         fi_tcl_WeatherForecast o_WeatherForecast;
         if (!bDoIt(o_WeatherForecast))
         {
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
            o_WeatherForecast.vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
            return FALSE;
         }
         else
         {
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
            o_WeatherForecast.vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
            oCallStack.bGoUp();
            oPath.bGoUp();
         }
      }
   } break;
   case weatherfi_tclToken::EN_WEATHERFORECASTFORPOSITION:
   {
      if (poVisitor->bDoExpand_WeatherForecastForPosition(enSemanticDomain))
      {
         oPath.bGoUp();
         oPath.bGoDown(weatherfi_tclKnot(weatherfi_tclToken::EN_END_OF_STRUCT,weatherfi_tclSemanticDomain::EN_UNKNOWN));
         oPath.bGoDown(weatherfi_tclKnot(weatherfi_tclToken::EN_WEATHERFORECAST,weatherfi_tclSemanticDomain::EN_LIST_ELEMENT,0));
         oPath.bGoDown(weatherfi_tclKnot(weatherfi_tclToken::EN_LIST,weatherfi_tclSemanticDomain::EN_WEATHERFORECASTS));
         oPath.bGoDown(weatherfi_tclKnot(weatherfi_tclToken::EN_POSITIONWGS84,weatherfi_tclSemanticDomain::EN_POSITION));
      }
      else
      {
         fi_tcl_WeatherForecastForPosition o_WeatherForecastForPosition;
         if (!bDoIt(o_WeatherForecastForPosition))
         {
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
            o_WeatherForecastForPosition.vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
            return FALSE;
         }
         else
         {
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
            o_WeatherForecastForPosition.vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
            oCallStack.bGoUp();
            oPath.bGoUp();
         }
      }
   } break;
   case weatherfi_tclToken::EN_WARNINGID:
   {
      if (poVisitor->bDoExpand_WarningId(enSemanticDomain))
      {
         oPath.bGoUp();
         oPath.bGoDown(weatherfi_tclKnot(weatherfi_tclToken::EN_END_OF_STRUCT,weatherfi_tclSemanticDomain::EN_UNKNOWN));
         oPath.bGoDown(weatherfi_tclKnot(weatherfi_tclToken::EN_U16,weatherfi_tclSemanticDomain::EN_MINOR));
         oPath.bGoDown(weatherfi_tclKnot(weatherfi_tclToken::EN_U16,weatherfi_tclSemanticDomain::EN_MAJOR));
      }
      else
      {
         fi_tcl_WarningId o_WarningId;
         if (!bDoIt(o_WarningId))
         {
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
            o_WarningId.vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
            return FALSE;
         }
         else
         {
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
            o_WarningId.vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
            oCallStack.bGoUp();
            oPath.bGoUp();
         }
      }
   } break;
   case weatherfi_tclToken::EN_COUNTY:
   {
      if (poVisitor->bDoExpand_County(enSemanticDomain))
      {
         oPath.bGoUp();
         oPath.bGoDown(weatherfi_tclKnot(weatherfi_tclToken::EN_END_OF_STRUCT,weatherfi_tclSemanticDomain::EN_UNKNOWN));
         oPath.bGoDown(weatherfi_tclKnot(weatherfi_tclToken::EN_E8_TIMEZONE,weatherfi_tclSemanticDomain::EN_TIMEZONE));
         oPath.bGoDown(weatherfi_tclKnot(weatherfi_tclToken::EN_POSITIONWGS84,weatherfi_tclSemanticDomain::EN_COUNTYCOORDINATES));
         oPath.bGoDown(weatherfi_tclKnot(weatherfi_tclToken::EN_STATE,weatherfi_tclSemanticDomain::EN_STATE));
         oPath.bGoDown(weatherfi_tclKnot(weatherfi_tclToken::EN_STRING,weatherfi_tclSemanticDomain::EN_COUNTYNAME));
         oPath.bGoDown(weatherfi_tclKnot(weatherfi_tclToken::EN_STRING,weatherfi_tclSemanticDomain::EN_UGCCODE));
      }
      else
      {
         fi_tcl_County o_County;
         if (!bDoIt(o_County))
         {
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
            o_County.vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
            return FALSE;
         }
         else
         {
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
            o_County.vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
            oCallStack.bGoUp();
            oPath.bGoUp();
         }
      }
   } break;
   case weatherfi_tclToken::EN_COUNTYWARNING:
   {
      if (poVisitor->bDoExpand_CountyWarning(enSemanticDomain))
      {
         oPath.bGoUp();
         oPath.bGoDown(weatherfi_tclKnot(weatherfi_tclToken::EN_END_OF_STRUCT,weatherfi_tclSemanticDomain::EN_UNKNOWN));
         oPath.bGoDown(weatherfi_tclKnot(weatherfi_tclToken::EN_S32_METER,weatherfi_tclSemanticDomain::EN_DISTANCE));
         oPath.bGoDown(weatherfi_tclKnot(weatherfi_tclToken::EN_POSIXTIME,weatherfi_tclSemanticDomain::EN_EXPIRATIONTIME));
         oPath.bGoDown(weatherfi_tclKnot(weatherfi_tclToken::EN_MULTILANGUAGESTRING,weatherfi_tclSemanticDomain::EN_WARNINGDESCRIPTION));
         oPath.bGoDown(weatherfi_tclKnot(weatherfi_tclToken::EN_E8_COUNTYWARNINGCODE,weatherfi_tclSemanticDomain::EN_WARNINGCODE));
         oPath.bGoDown(weatherfi_tclKnot(weatherfi_tclToken::EN_COUNTY,weatherfi_tclSemanticDomain::EN_AFFECTEDCOUNTY));
         oPath.bGoDown(weatherfi_tclKnot(weatherfi_tclToken::EN_WARNINGID,weatherfi_tclSemanticDomain::EN_WARNINGMESSAGEID));
      }
      else
      {
         fi_tcl_CountyWarning o_CountyWarning;
         if (!bDoIt(o_CountyWarning))
         {
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
            o_CountyWarning.vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
            return FALSE;
         }
         else
         {
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
            o_CountyWarning.vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
            oCallStack.bGoUp();
            oPath.bGoUp();
         }
      }
   } break;
   case weatherfi_tclToken::EN_B16_FORECASTTYPE:
   {
      fi_tcl_b16_ForecastType o_b16_ForecastType;
      if (!bDoIt(o_b16_ForecastType))
         return FALSE;
      oCallStack.bGoUp();
      oPath.bGoUp();
   } break;
   case weatherfi_tclToken::EN_E8_FORECASTTYPE:
   {
      fi_tcl_e8_ForecastType o_e8_ForecastType;
      if (!bDoIt(o_e8_ForecastType))
         return FALSE;
      oCallStack.bGoUp();
      oPath.bGoUp();
   } break;
   case weatherfi_tclToken::EN_VERSIONPERFORECAST:
   {
      if (poVisitor->bDoExpand_VersionPerForecast(enSemanticDomain))
      {
         oPath.bGoUp();
         oPath.bGoDown(weatherfi_tclKnot(weatherfi_tclToken::EN_END_OF_STRUCT,weatherfi_tclSemanticDomain::EN_UNKNOWN));
         oPath.bGoDown(weatherfi_tclKnot(weatherfi_tclToken::EN_U32,weatherfi_tclSemanticDomain::EN_VERSIONID));
         oPath.bGoDown(weatherfi_tclKnot(weatherfi_tclToken::EN_E8_FORECASTTYPE,weatherfi_tclSemanticDomain::EN_FORECASTTYPE));
      }
      else
      {
         fi_tcl_VersionPerForecast o_VersionPerForecast;
         if (!bDoIt(o_VersionPerForecast))
         {
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
            o_VersionPerForecast.vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
            return FALSE;
         }
         else
         {
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
            o_VersionPerForecast.vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
            oCallStack.bGoUp();
            oPath.bGoUp();
         }
      }
   } break;
   case weatherfi_tclToken::EN_E8_PRECIPITATIONTYPE:
   {
      fi_tcl_e8_PrecipitationType o_e8_PrecipitationType;
      if (!bDoIt(o_e8_PrecipitationType))
         return FALSE;
      oCallStack.bGoUp();
      oPath.bGoUp();
   } break;
   case weatherfi_tclToken::EN_E8_CLOUDCOVERAGETYPE:
   {
      fi_tcl_e8_CloudCoverageType o_e8_CloudCoverageType;
      if (!bDoIt(o_e8_CloudCoverageType))
         return FALSE;
      oCallStack.bGoUp();
      oPath.bGoUp();
   } break;
   case weatherfi_tclToken::EN_TABULARWEATHERLOCATION:
   {
      if (poVisitor->bDoExpand_TabularWeatherLocation(enSemanticDomain))
      {
         oPath.bGoUp();
         oPath.bGoDown(weatherfi_tclKnot(weatherfi_tclToken::EN_END_OF_STRUCT,weatherfi_tclSemanticDomain::EN_UNKNOWN));
         oPath.bGoDown(weatherfi_tclKnot(weatherfi_tclToken::EN_POSITIONWGS84,weatherfi_tclSemanticDomain::EN_LOCATIONCOORDINATES));
         oPath.bGoDown(weatherfi_tclKnot(weatherfi_tclToken::EN_STATE,weatherfi_tclSemanticDomain::EN_STATE));
         oPath.bGoDown(weatherfi_tclKnot(weatherfi_tclToken::EN_STRING,weatherfi_tclSemanticDomain::EN_LOCATIONNAME));
         oPath.bGoDown(weatherfi_tclKnot(weatherfi_tclToken::EN_U32,weatherfi_tclSemanticDomain::EN_LOCATIONID));
      }
      else
      {
         fi_tcl_TabularWeatherLocation o_TabularWeatherLocation;
         if (!bDoIt(o_TabularWeatherLocation))
         {
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
            o_TabularWeatherLocation.vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
            return FALSE;
         }
         else
         {
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
            o_TabularWeatherLocation.vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
            oCallStack.bGoUp();
            oPath.bGoUp();
         }
      }
   } break;
   case weatherfi_tclToken::EN_TABULARWEATHERCONDITION:
   {
      if (poVisitor->bDoExpand_TabularWeatherCondition(enSemanticDomain))
      {
         oPath.bGoUp();
         oPath.bGoDown(weatherfi_tclKnot(weatherfi_tclToken::EN_END_OF_STRUCT,weatherfi_tclSemanticDomain::EN_UNKNOWN));
         oPath.bGoDown(weatherfi_tclKnot(weatherfi_tclToken::EN_MULTILANGUAGESTRING,weatherfi_tclSemanticDomain::EN_WEATHERDESCRIPTION));
         oPath.bGoDown(weatherfi_tclKnot(weatherfi_tclToken::EN_E8_TABULARWEATHERID,weatherfi_tclSemanticDomain::EN_WEATHERID));
      }
      else
      {
         fi_tcl_TabularWeatherCondition o_TabularWeatherCondition;
         if (!bDoIt(o_TabularWeatherCondition))
         {
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
            o_TabularWeatherCondition.vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
            return FALSE;
         }
         else
         {
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
            o_TabularWeatherCondition.vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
            oCallStack.bGoUp();
            oPath.bGoUp();
         }
      }
   } break;
   case weatherfi_tclToken::EN_PRECIPITATION:
   {
      if (poVisitor->bDoExpand_Precipitation(enSemanticDomain))
      {
         oPath.bGoUp();
         oPath.bGoDown(weatherfi_tclKnot(weatherfi_tclToken::EN_END_OF_STRUCT,weatherfi_tclSemanticDomain::EN_UNKNOWN));
         oPath.bGoDown(weatherfi_tclKnot(weatherfi_tclToken::EN_S32_MILLIMETER,weatherfi_tclSemanticDomain::EN_PRECIPITATIONAMOUNTHIGH));
         oPath.bGoDown(weatherfi_tclKnot(weatherfi_tclToken::EN_S32_MILLIMETER,weatherfi_tclSemanticDomain::EN_PRECIPITATIONAMOUNTLOW));
         oPath.bGoDown(weatherfi_tclKnot(weatherfi_tclToken::EN_MULTILANGUAGESTRING,weatherfi_tclSemanticDomain::EN_PRECIPITATIONTYPETEXT));
         oPath.bGoDown(weatherfi_tclKnot(weatherfi_tclToken::EN_E8_PRECIPITATIONTYPE,weatherfi_tclSemanticDomain::EN_PRECIPITATIONTYPE));
         oPath.bGoDown(weatherfi_tclKnot(weatherfi_tclToken::EN_BOOL,weatherfi_tclSemanticDomain::EN_PRECIPITATIONVALID));
      }
      else
      {
         fi_tcl_Precipitation o_Precipitation;
         if (!bDoIt(o_Precipitation))
         {
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
            o_Precipitation.vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
            return FALSE;
         }
         else
         {
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
            o_Precipitation.vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
            oCallStack.bGoUp();
            oPath.bGoUp();
         }
      }
   } break;
   case weatherfi_tclToken::EN_HUMIDITY:
   {
      if (poVisitor->bDoExpand_Humidity(enSemanticDomain))
      {
         oPath.bGoUp();
         oPath.bGoDown(weatherfi_tclKnot(weatherfi_tclToken::EN_END_OF_STRUCT,weatherfi_tclSemanticDomain::EN_UNKNOWN));
         oPath.bGoDown(weatherfi_tclKnot(weatherfi_tclToken::EN_U8_PERCENT,weatherfi_tclSemanticDomain::EN_HUMIDITYHIGH));
         oPath.bGoDown(weatherfi_tclKnot(weatherfi_tclToken::EN_U8_PERCENT,weatherfi_tclSemanticDomain::EN_HUMIDITYLOW));
         oPath.bGoDown(weatherfi_tclKnot(weatherfi_tclToken::EN_BOOL,weatherfi_tclSemanticDomain::EN_VALID));
      }
      else
      {
         fi_tcl_Humidity o_Humidity;
         if (!bDoIt(o_Humidity))
         {
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
            o_Humidity.vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
            return FALSE;
         }
         else
         {
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
            o_Humidity.vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
            oCallStack.bGoUp();
            oPath.bGoUp();
         }
      }
   } break;
   case weatherfi_tclToken::EN_CLOUDCOVERAGE:
   {
      if (poVisitor->bDoExpand_CloudCoverage(enSemanticDomain))
      {
         oPath.bGoUp();
         oPath.bGoDown(weatherfi_tclKnot(weatherfi_tclToken::EN_END_OF_STRUCT,weatherfi_tclSemanticDomain::EN_UNKNOWN));
         oPath.bGoDown(weatherfi_tclKnot(weatherfi_tclToken::EN_MULTILANGUAGESTRING,weatherfi_tclSemanticDomain::EN_CLOUDCOVERAGETEXT));
         oPath.bGoDown(weatherfi_tclKnot(weatherfi_tclToken::EN_E8_CLOUDCOVERAGETYPE,weatherfi_tclSemanticDomain::EN_CLOUDCOVERAGETYPE));
         oPath.bGoDown(weatherfi_tclKnot(weatherfi_tclToken::EN_BOOL,weatherfi_tclSemanticDomain::EN_VALID));
      }
      else
      {
         fi_tcl_CloudCoverage o_CloudCoverage;
         if (!bDoIt(o_CloudCoverage))
         {
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
            o_CloudCoverage.vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
            return FALSE;
         }
         else
         {
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
            o_CloudCoverage.vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
            oCallStack.bGoUp();
            oPath.bGoUp();
         }
      }
   } break;
   case weatherfi_tclToken::EN_UVLEVEL:
   {
      if (poVisitor->bDoExpand_UVLevel(enSemanticDomain))
      {
         oPath.bGoUp();
         oPath.bGoDown(weatherfi_tclKnot(weatherfi_tclToken::EN_END_OF_STRUCT,weatherfi_tclSemanticDomain::EN_UNKNOWN));
         oPath.bGoDown(weatherfi_tclKnot(weatherfi_tclToken::EN_MULTILANGUAGESTRING,weatherfi_tclSemanticDomain::EN_UVRISK));
         oPath.bGoDown(weatherfi_tclKnot(weatherfi_tclToken::EN_U8,weatherfi_tclSemanticDomain::EN_UVINDEXHIGH));
         oPath.bGoDown(weatherfi_tclKnot(weatherfi_tclToken::EN_U8,weatherfi_tclSemanticDomain::EN_UVINDEXLOW));
         oPath.bGoDown(weatherfi_tclKnot(weatherfi_tclToken::EN_BOOL,weatherfi_tclSemanticDomain::EN_VALID));
      }
      else
      {
         fi_tcl_UVLevel o_UVLevel;
         if (!bDoIt(o_UVLevel))
         {
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
            o_UVLevel.vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
            return FALSE;
         }
         else
         {
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
            o_UVLevel.vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
            oCallStack.bGoUp();
            oPath.bGoUp();
         }
      }
   } break;
   case weatherfi_tclToken::EN_POLLENLEVEL:
   {
      if (poVisitor->bDoExpand_PollenLevel(enSemanticDomain))
      {
         oPath.bGoUp();
         oPath.bGoDown(weatherfi_tclKnot(weatherfi_tclToken::EN_END_OF_STRUCT,weatherfi_tclSemanticDomain::EN_UNKNOWN));
         oPath.bGoDown(weatherfi_tclKnot(weatherfi_tclToken::EN_MULTILANGUAGESTRING,weatherfi_tclSemanticDomain::EN_POLLENLEVEL));
         oPath.bGoDown(weatherfi_tclKnot(weatherfi_tclToken::EN_U8,weatherfi_tclSemanticDomain::EN_POLLENCOUNT));
         oPath.bGoDown(weatherfi_tclKnot(weatherfi_tclToken::EN_BOOL,weatherfi_tclSemanticDomain::EN_VALID));
      }
      else
      {
         fi_tcl_PollenLevel o_PollenLevel;
         if (!bDoIt(o_PollenLevel))
         {
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
            o_PollenLevel.vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
            return FALSE;
         }
         else
         {
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
            o_PollenLevel.vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
            oCallStack.bGoUp();
            oPath.bGoUp();
         }
      }
   } break;
   case weatherfi_tclToken::EN_TABULARWEATHERPERFORECAST:
   {
      if (poVisitor->bDoExpand_TabularWeatherPerForecast(enSemanticDomain))
      {
         oPath.bGoUp();
         oPath.bGoDown(weatherfi_tclKnot(weatherfi_tclToken::EN_END_OF_STRUCT,weatherfi_tclSemanticDomain::EN_UNKNOWN));
         oPath.bGoDown(weatherfi_tclKnot(weatherfi_tclToken::EN_POLLENLEVEL,weatherfi_tclSemanticDomain::EN_POLLENLEVEL));
         oPath.bGoDown(weatherfi_tclKnot(weatherfi_tclToken::EN_MULTILANGUAGESTRING,weatherfi_tclSemanticDomain::EN_AIRQUALITY));
         oPath.bGoDown(weatherfi_tclKnot(weatherfi_tclToken::EN_UVLEVEL,weatherfi_tclSemanticDomain::EN_UVLEVEL));
         oPath.bGoDown(weatherfi_tclKnot(weatherfi_tclToken::EN_CLOUDCOVERAGE,weatherfi_tclSemanticDomain::EN_CLOUDCOVERAGE));
         oPath.bGoDown(weatherfi_tclKnot(weatherfi_tclToken::EN_HUMIDITY,weatherfi_tclSemanticDomain::EN_HUMIDITY));
         oPath.bGoDown(weatherfi_tclKnot(weatherfi_tclToken::EN_S16_KMPERHOUR,weatherfi_tclSemanticDomain::EN_WINDSPEED));
         oPath.bGoDown(weatherfi_tclKnot(weatherfi_tclToken::EN_U8_DIRECTIONABSOLUTE,weatherfi_tclSemanticDomain::EN_WINDDIRECTION));
         oPath.bGoDown(weatherfi_tclKnot(weatherfi_tclToken::EN_PRECIPITATION,weatherfi_tclSemanticDomain::EN_PRECIPITATION));
         oPath.bGoDown(weatherfi_tclKnot(weatherfi_tclToken::EN_U8_PERCENT,weatherfi_tclSemanticDomain::EN_PROBABILITYOFPRECIPITATION));
         if (27 <= u16MajorVersion)
         {
            oPath.bGoDown(weatherfi_tclKnot(weatherfi_tclToken::EN_S16_FAHRENHEIT,weatherfi_tclSemanticDomain::EN_MINTEMPERATUREFAHRENHEIT));
         }
         oPath.bGoDown(weatherfi_tclKnot(weatherfi_tclToken::EN_S16_KELVIN,weatherfi_tclSemanticDomain::EN_MINTEMPERATURE));
         if (27 <= u16MajorVersion)
         {
            oPath.bGoDown(weatherfi_tclKnot(weatherfi_tclToken::EN_S16_FAHRENHEIT,weatherfi_tclSemanticDomain::EN_MAXTEMPERATUREFAHRENHEIT));
         }
         oPath.bGoDown(weatherfi_tclKnot(weatherfi_tclToken::EN_S16_KELVIN,weatherfi_tclSemanticDomain::EN_MAXTEMPERATURE));
         if (27 <= u16MajorVersion)
         {
            oPath.bGoDown(weatherfi_tclKnot(weatherfi_tclToken::EN_S16_FAHRENHEIT,weatherfi_tclSemanticDomain::EN_TEMPERATUREFAHRENHEIT));
         }
         oPath.bGoDown(weatherfi_tclKnot(weatherfi_tclToken::EN_S16_KELVIN,weatherfi_tclSemanticDomain::EN_TEMPERATURE));
         oPath.bGoDown(weatherfi_tclKnot(weatherfi_tclToken::EN_TABULARWEATHERCONDITION,weatherfi_tclSemanticDomain::EN_WEATHERCONDITION));
         oPath.bGoDown(weatherfi_tclKnot(weatherfi_tclToken::EN_POSIXTIME,weatherfi_tclSemanticDomain::EN_RECEPTIONTIME));
         oPath.bGoDown(weatherfi_tclKnot(weatherfi_tclToken::EN_E8_FORECASTTYPE,weatherfi_tclSemanticDomain::EN_FORECASTTYPE));
      }
      else
      {
         fi_tcl_TabularWeatherPerForecast o_TabularWeatherPerForecast;
         if (!bDoIt(o_TabularWeatherPerForecast))
         {
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
            o_TabularWeatherPerForecast.vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
            return FALSE;
         }
         else
         {
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
            o_TabularWeatherPerForecast.vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
            oCallStack.bGoUp();
            oPath.bGoUp();
         }
      }
   } break;
   case weatherfi_tclToken::EN_TABULARWEATHER:
   {
      if (poVisitor->bDoExpand_TabularWeather(enSemanticDomain))
      {
         oPath.bGoUp();
         oPath.bGoDown(weatherfi_tclKnot(weatherfi_tclToken::EN_END_OF_STRUCT,weatherfi_tclSemanticDomain::EN_UNKNOWN));
         oPath.bGoDown(weatherfi_tclKnot(weatherfi_tclToken::EN_TABULARWEATHERPERFORECAST,weatherfi_tclSemanticDomain::EN_LIST_ELEMENT,0));
         oPath.bGoDown(weatherfi_tclKnot(weatherfi_tclToken::EN_LIST,weatherfi_tclSemanticDomain::EN_TABULARWEATHERPERFORECAST));
         oPath.bGoDown(weatherfi_tclKnot(weatherfi_tclToken::EN_S32_METER,weatherfi_tclSemanticDomain::EN_DISTANCE));
         oPath.bGoDown(weatherfi_tclKnot(weatherfi_tclToken::EN_TABULARWEATHERLOCATION,weatherfi_tclSemanticDomain::EN_TABULARWEATHERLOCATION));
      }
      else
      {
         fi_tcl_TabularWeather o_TabularWeather;
         if (!bDoIt(o_TabularWeather))
         {
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
            o_TabularWeather.vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
            return FALSE;
         }
         else
         {
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
            o_TabularWeather.vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
            oCallStack.bGoUp();
            oPath.bGoUp();
         }
      }
   } break;
   case weatherfi_tclToken::EN_TABULARWEATHERFORPOSITION:
   {
      if (poVisitor->bDoExpand_TabularWeatherForPosition(enSemanticDomain))
      {
         oPath.bGoUp();
         oPath.bGoDown(weatherfi_tclKnot(weatherfi_tclToken::EN_END_OF_STRUCT,weatherfi_tclSemanticDomain::EN_UNKNOWN));
         oPath.bGoDown(weatherfi_tclKnot(weatherfi_tclToken::EN_TABULARWEATHER,weatherfi_tclSemanticDomain::EN_LIST_ELEMENT,0));
         oPath.bGoDown(weatherfi_tclKnot(weatherfi_tclToken::EN_LIST,weatherfi_tclSemanticDomain::EN_TABULARWEATHERSITUATION));
         oPath.bGoDown(weatherfi_tclKnot(weatherfi_tclToken::EN_POSITIONWGS84,weatherfi_tclSemanticDomain::EN_POSITION));
      }
      else
      {
         fi_tcl_TabularWeatherForPosition o_TabularWeatherForPosition;
         if (!bDoIt(o_TabularWeatherForPosition))
         {
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
            o_TabularWeatherForPosition.vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
            return FALSE;
         }
         else
         {
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
            o_TabularWeatherForPosition.vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
            oCallStack.bGoUp();
            oPath.bGoUp();
         }
      }
   } break;
   case weatherfi_tclToken::EN_B16_SKIAREAATTRIBUTES:
   {
      fi_tcl_b16_SkiAreaAttributes o_b16_SkiAreaAttributes;
      if (!bDoIt(o_b16_SkiAreaAttributes))
         return FALSE;
      oCallStack.bGoUp();
      oPath.bGoUp();
   } break;
   case weatherfi_tclToken::EN_SKIAREAATTRIBUTES:
   {
      if (poVisitor->bDoExpand_SkiAreaAttributes(enSemanticDomain))
      {
         oPath.bGoUp();
         oPath.bGoDown(weatherfi_tclKnot(weatherfi_tclToken::EN_END_OF_STRUCT,weatherfi_tclSemanticDomain::EN_UNKNOWN));
         oPath.bGoDown(weatherfi_tclKnot(weatherfi_tclToken::EN_B16_SKIAREAATTRIBUTES,weatherfi_tclSemanticDomain::EN_INFORMATION));
         oPath.bGoDown(weatherfi_tclKnot(weatherfi_tclToken::EN_B16_SKIAREAATTRIBUTES,weatherfi_tclSemanticDomain::EN_INFOAVAILABLE));
      }
      else
      {
         fi_tcl_SkiAreaAttributes o_SkiAreaAttributes;
         if (!bDoIt(o_SkiAreaAttributes))
         {
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
            o_SkiAreaAttributes.vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
            return FALSE;
         }
         else
         {
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
            o_SkiAreaAttributes.vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
            oCallStack.bGoUp();
            oPath.bGoUp();
         }
      }
   } break;
   case weatherfi_tclToken::EN_SKICONDITION:
   {
      if (poVisitor->bDoExpand_SkiCondition(enSemanticDomain))
      {
         oPath.bGoUp();
         oPath.bGoDown(weatherfi_tclKnot(weatherfi_tclToken::EN_END_OF_STRUCT,weatherfi_tclSemanticDomain::EN_UNKNOWN));
         oPath.bGoDown(weatherfi_tclKnot(weatherfi_tclToken::EN_SKIAREAATTRIBUTES,weatherfi_tclSemanticDomain::EN_SKIAREAATTRIBUTES));
         oPath.bGoDown(weatherfi_tclKnot(weatherfi_tclToken::EN_S16,weatherfi_tclSemanticDomain::EN_OPENTRAILSHIGH));
         oPath.bGoDown(weatherfi_tclKnot(weatherfi_tclToken::EN_S16,weatherfi_tclSemanticDomain::EN_OPENTRAILSLOW));
         oPath.bGoDown(weatherfi_tclKnot(weatherfi_tclToken::EN_S16,weatherfi_tclSemanticDomain::EN_OPERATINGLIFTS));
         oPath.bGoDown(weatherfi_tclKnot(weatherfi_tclToken::EN_S32_MILLIMETER,weatherfi_tclSemanticDomain::EN_NEWSNOWHIGH));
         oPath.bGoDown(weatherfi_tclKnot(weatherfi_tclToken::EN_S32_MILLIMETER,weatherfi_tclSemanticDomain::EN_NEWSNOWLOW));
         oPath.bGoDown(weatherfi_tclKnot(weatherfi_tclToken::EN_S32_MILLIMETER,weatherfi_tclSemanticDomain::EN_MAXIMUMBASESNOWDEPTH));
         oPath.bGoDown(weatherfi_tclKnot(weatherfi_tclToken::EN_S32_MILLIMETER,weatherfi_tclSemanticDomain::EN_MINIMUMBASESNOWDEPTH));
         oPath.bGoDown(weatherfi_tclKnot(weatherfi_tclToken::EN_MULTILANGUAGESTRING,weatherfi_tclSemanticDomain::EN_SNOWCONDITION));
         oPath.bGoDown(weatherfi_tclKnot(weatherfi_tclToken::EN_MULTILANGUAGESTRING,weatherfi_tclSemanticDomain::EN_WINDCONDITION));
         if (27 <= u16MajorVersion)
         {
            oPath.bGoDown(weatherfi_tclKnot(weatherfi_tclToken::EN_S16_FAHRENHEIT,weatherfi_tclSemanticDomain::EN_TEMPERATUREFAHRENHEIT));
         }
         oPath.bGoDown(weatherfi_tclKnot(weatherfi_tclToken::EN_S16_KELVIN,weatherfi_tclSemanticDomain::EN_TEMPERATURE));
         oPath.bGoDown(weatherfi_tclKnot(weatherfi_tclToken::EN_TABULARWEATHERCONDITION,weatherfi_tclSemanticDomain::EN_WEATHERCONDITION));
         oPath.bGoDown(weatherfi_tclKnot(weatherfi_tclToken::EN_POSIXTIME,weatherfi_tclSemanticDomain::EN_RECEPTIONTIME));
         oPath.bGoDown(weatherfi_tclKnot(weatherfi_tclToken::EN_S32_METER,weatherfi_tclSemanticDomain::EN_DISTANCE));
         oPath.bGoDown(weatherfi_tclKnot(weatherfi_tclToken::EN_TABULARWEATHERLOCATION,weatherfi_tclSemanticDomain::EN_SKIAREA));
      }
      else
      {
         fi_tcl_SkiCondition o_SkiCondition;
         if (!bDoIt(o_SkiCondition))
         {
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
            o_SkiCondition.vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
            return FALSE;
         }
         else
         {
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
            o_SkiCondition.vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
            oCallStack.bGoUp();
            oPath.bGoUp();
         }
      }
   } break;
   case weatherfi_tclToken::EN_SKICONDITIONFORPOSITION:
   {
      if (poVisitor->bDoExpand_SkiConditionForPosition(enSemanticDomain))
      {
         oPath.bGoUp();
         oPath.bGoDown(weatherfi_tclKnot(weatherfi_tclToken::EN_END_OF_STRUCT,weatherfi_tclSemanticDomain::EN_UNKNOWN));
         oPath.bGoDown(weatherfi_tclKnot(weatherfi_tclToken::EN_SKICONDITION,weatherfi_tclSemanticDomain::EN_LIST_ELEMENT,0));
         oPath.bGoDown(weatherfi_tclKnot(weatherfi_tclToken::EN_LIST,weatherfi_tclSemanticDomain::EN_SKICONDITION));
         oPath.bGoDown(weatherfi_tclKnot(weatherfi_tclToken::EN_POSITIONWGS84,weatherfi_tclSemanticDomain::EN_POSITION));
      }
      else
      {
         fi_tcl_SkiConditionForPosition o_SkiConditionForPosition;
         if (!bDoIt(o_SkiConditionForPosition))
         {
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
            o_SkiConditionForPosition.vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
            return FALSE;
         }
         else
         {
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
            o_SkiConditionForPosition.vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
            oCallStack.bGoUp();
            oPath.bGoUp();
         }
      }
   } break;
   case weatherfi_tclToken::EN_E8_ALERTTYPE:
   {
      fi_tcl_e8_AlertType o_e8_AlertType;
      if (!bDoIt(o_e8_AlertType))
         return FALSE;
      oCallStack.bGoUp();
      oPath.bGoUp();
   } break;
   case weatherfi_tclToken::EN_ALERTTYPE:
   {
      if (poVisitor->bDoExpand_AlertType(enSemanticDomain))
      {
         oPath.bGoUp();
         oPath.bGoDown(weatherfi_tclKnot(weatherfi_tclToken::EN_END_OF_STRUCT,weatherfi_tclSemanticDomain::EN_UNKNOWN));
         oPath.bGoDown(weatherfi_tclKnot(weatherfi_tclToken::EN_STRING,weatherfi_tclSemanticDomain::EN_ALERTTYPETEXT));
         oPath.bGoDown(weatherfi_tclKnot(weatherfi_tclToken::EN_U8,weatherfi_tclSemanticDomain::EN_ALERTTYPEPRIORITY));
         oPath.bGoDown(weatherfi_tclKnot(weatherfi_tclToken::EN_E8_ALERTTYPE,weatherfi_tclSemanticDomain::EN_ALERTTYPEID));
      }
      else
      {
         fi_tcl_AlertType o_AlertType;
         if (!bDoIt(o_AlertType))
         {
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
            o_AlertType.vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
            return FALSE;
         }
         else
         {
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
            o_AlertType.vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
            oCallStack.bGoUp();
            oPath.bGoUp();
         }
      }
   } break;
   case weatherfi_tclToken::EN_WEATHERALERTAREA:
   {
      if (poVisitor->bDoExpand_WeatherAlertArea(enSemanticDomain))
      {
         oPath.bGoUp();
         oPath.bGoDown(weatherfi_tclKnot(weatherfi_tclToken::EN_END_OF_STRUCT,weatherfi_tclSemanticDomain::EN_UNKNOWN));
         oPath.bGoDown(weatherfi_tclKnot(weatherfi_tclToken::EN_POSITIONWGS84,weatherfi_tclSemanticDomain::EN_LIST_ELEMENT,0));
         oPath.bGoDown(weatherfi_tclKnot(weatherfi_tclToken::EN_LIST,weatherfi_tclSemanticDomain::EN_SURROUNDINGPOLYGON));
         if (4 <= u16MajorVersion)
         {
            oPath.bGoDown(weatherfi_tclKnot(weatherfi_tclToken::EN_MARINEZONE,weatherfi_tclSemanticDomain::EN_MARINEZONE));
         }
         if (4 <= u16MajorVersion)
         {
            oPath.bGoDown(weatherfi_tclKnot(weatherfi_tclToken::EN_STATE,weatherfi_tclSemanticDomain::EN_STATE));
         }
         oPath.bGoDown(weatherfi_tclKnot(weatherfi_tclToken::EN_STRING,weatherfi_tclSemanticDomain::EN_LOCATIONNAME));
         oPath.bGoDown(weatherfi_tclKnot(weatherfi_tclToken::EN_U32,weatherfi_tclSemanticDomain::EN_LOCATIONCODE));
      }
      else
      {
         fi_tcl_WeatherAlertArea o_WeatherAlertArea;
         if (!bDoIt(o_WeatherAlertArea))
         {
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
            o_WeatherAlertArea.vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
            return FALSE;
         }
         else
         {
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
            o_WeatherAlertArea.vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
            oCallStack.bGoUp();
            oPath.bGoUp();
         }
      }
   } break;
   case weatherfi_tclToken::EN_STATEORZONE:
   {
      if (poVisitor->bDoExpand_StateOrZone(enSemanticDomain))
      {
         oPath.bGoUp();
         oPath.bGoDown(weatherfi_tclKnot(weatherfi_tclToken::EN_END_OF_STRUCT,weatherfi_tclSemanticDomain::EN_UNKNOWN));
         oPath.bGoDown(weatherfi_tclKnot(weatherfi_tclToken::EN_U16,weatherfi_tclSemanticDomain::EN_STATEORZONEIDNUMERIC));
         oPath.bGoDown(weatherfi_tclKnot(weatherfi_tclToken::EN_BOOL,weatherfi_tclSemanticDomain::EN_ISMARINEZONE));
      }
      else
      {
         fi_tcl_StateOrZone o_StateOrZone;
         if (!bDoIt(o_StateOrZone))
         {
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
            o_StateOrZone.vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
            return FALSE;
         }
         else
         {
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
            o_StateOrZone.vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
            oCallStack.bGoUp();
            oPath.bGoUp();
         }
      }
   } break;
   case weatherfi_tclToken::EN_WEATHERALERT:
   {
      if (poVisitor->bDoExpand_WeatherAlert(enSemanticDomain))
      {
         oPath.bGoUp();
         oPath.bGoDown(weatherfi_tclKnot(weatherfi_tclToken::EN_END_OF_STRUCT,weatherfi_tclSemanticDomain::EN_UNKNOWN));
         oPath.bGoDown(weatherfi_tclKnot(weatherfi_tclToken::EN_STRING,weatherfi_tclSemanticDomain::EN_WEATHERALERTTEXT));
         if (4 <= u16MajorVersion)
         {
            oPath.bGoDown(weatherfi_tclKnot(weatherfi_tclToken::EN_STRING,weatherfi_tclSemanticDomain::EN_LIST_ELEMENT,0));
            oPath.bGoDown(weatherfi_tclKnot(weatherfi_tclToken::EN_LIST,weatherfi_tclSemanticDomain::EN_PHONENUMBERS));
         }
         oPath.bGoDown(weatherfi_tclKnot(weatherfi_tclToken::EN_POSITIONWGS84,weatherfi_tclSemanticDomain::EN_LIST_ELEMENT,0));
         oPath.bGoDown(weatherfi_tclKnot(weatherfi_tclToken::EN_LIST,weatherfi_tclSemanticDomain::EN_SURROUNDINGPOLYGON));
         oPath.bGoDown(weatherfi_tclKnot(weatherfi_tclToken::EN_POSIXTIME,weatherfi_tclSemanticDomain::EN_STOPTIME));
         oPath.bGoDown(weatherfi_tclKnot(weatherfi_tclToken::EN_POSIXTIME,weatherfi_tclSemanticDomain::EN_STARTTIME));
         if (4 <= u16MajorVersion)
         {
            oPath.bGoDown(weatherfi_tclKnot(weatherfi_tclToken::EN_ALERTTYPE,weatherfi_tclSemanticDomain::EN_LIST_ELEMENT,0));
            oPath.bGoDown(weatherfi_tclKnot(weatherfi_tclToken::EN_LIST,weatherfi_tclSemanticDomain::EN_ALERTTYPES));
         }
         if (u16MajorVersion <= 3)
         {
            oPath.bGoDown(weatherfi_tclKnot(weatherfi_tclToken::EN_ALERTTYPE,weatherfi_tclSemanticDomain::EN_ALERTTYPE));
         }
         oPath.bGoDown(weatherfi_tclKnot(weatherfi_tclToken::EN_POSIXTIME,weatherfi_tclSemanticDomain::EN_RECEPTIONTIME));
         oPath.bGoDown(weatherfi_tclKnot(weatherfi_tclToken::EN_S32_METER,weatherfi_tclSemanticDomain::EN_DISTANCE));
         oPath.bGoDown(weatherfi_tclKnot(weatherfi_tclToken::EN_WEATHERALERTAREA,weatherfi_tclSemanticDomain::EN_LIST_ELEMENT,0));
         oPath.bGoDown(weatherfi_tclKnot(weatherfi_tclToken::EN_LIST,weatherfi_tclSemanticDomain::EN_WEATHERALERTAREAS));
         oPath.bGoDown(weatherfi_tclKnot(weatherfi_tclToken::EN_E16_ISOLANGUAGECODE,weatherfi_tclSemanticDomain::EN_LANGUAGE));
         if (4 <= u16MajorVersion)
         {
            oPath.bGoDown(weatherfi_tclKnot(weatherfi_tclToken::EN_STATEORZONE,weatherfi_tclSemanticDomain::EN_STATEORZONEIDENTIFIER));
         }
         if (u16MajorVersion <= 3)
         {
            oPath.bGoDown(weatherfi_tclKnot(weatherfi_tclToken::EN_U32,weatherfi_tclSemanticDomain::EN_STATEIDNUMERIC));
         }
         if (4 <= u16MajorVersion)
         {
            oPath.bGoDown(weatherfi_tclKnot(weatherfi_tclToken::EN_U8,weatherfi_tclSemanticDomain::EN_PRIORITY));
         }
         oPath.bGoDown(weatherfi_tclKnot(weatherfi_tclToken::EN_U32,weatherfi_tclSemanticDomain::EN_ALERTID));
      }
      else
      {
         fi_tcl_WeatherAlert o_WeatherAlert;
         if (!bDoIt(o_WeatherAlert))
         {
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
            o_WeatherAlert.vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
            return FALSE;
         }
         else
         {
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
            o_WeatherAlert.vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
            oCallStack.bGoUp();
            oPath.bGoUp();
         }
      }
   } break;
   case weatherfi_tclToken::EN_VERSIONPERSTATE:
   {
      if (poVisitor->bDoExpand_VersionPerState(enSemanticDomain))
      {
         oPath.bGoUp();
         oPath.bGoDown(weatherfi_tclKnot(weatherfi_tclToken::EN_END_OF_STRUCT,weatherfi_tclSemanticDomain::EN_UNKNOWN));
         oPath.bGoDown(weatherfi_tclKnot(weatherfi_tclToken::EN_U32,weatherfi_tclSemanticDomain::EN_VERSION));
         if (4 <= u16MajorVersion)
         {
            oPath.bGoDown(weatherfi_tclKnot(weatherfi_tclToken::EN_STATEORZONE,weatherfi_tclSemanticDomain::EN_STATEORZONEIDENTIFIER));
         }
         if (u16MajorVersion <= 3)
         {
            oPath.bGoDown(weatherfi_tclKnot(weatherfi_tclToken::EN_U32,weatherfi_tclSemanticDomain::EN_STATEIDNUMERIC));
         }
      }
      else
      {
         fi_tcl_VersionPerState o_VersionPerState;
         if (!bDoIt(o_VersionPerState))
         {
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
            o_VersionPerState.vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
            return FALSE;
         }
         else
         {
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
            o_VersionPerState.vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
            oCallStack.bGoUp();
            oPath.bGoUp();
         }
      }
   } break;
   case weatherfi_tclToken::EN_STATESPERLANGUAGE:
   {
      if (poVisitor->bDoExpand_StatesPerLanguage(enSemanticDomain))
      {
         oPath.bGoUp();
         oPath.bGoDown(weatherfi_tclKnot(weatherfi_tclToken::EN_END_OF_STRUCT,weatherfi_tclSemanticDomain::EN_UNKNOWN));
         oPath.bGoDown(weatherfi_tclKnot(weatherfi_tclToken::EN_E16_ISOLANGUAGECODE,weatherfi_tclSemanticDomain::EN_LANGUAGE));
         oPath.bGoDown(weatherfi_tclKnot(weatherfi_tclToken::EN_VERSIONPERSTATE,weatherfi_tclSemanticDomain::EN_LIST_ELEMENT,0));
         oPath.bGoDown(weatherfi_tclKnot(weatherfi_tclToken::EN_LIST,weatherfi_tclSemanticDomain::EN_VERSIONPERSTATE));
      }
      else
      {
         fi_tcl_StatesPerLanguage o_StatesPerLanguage;
         if (!bDoIt(o_StatesPerLanguage))
         {
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
            o_StatesPerLanguage.vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
            return FALSE;
         }
         else
         {
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
            o_StatesPerLanguage.vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
            oCallStack.bGoUp();
            oPath.bGoUp();
         }
      }
   } break;
   case weatherfi_tclToken::EN_WEATHERALERTSFORPOSITION:
   {
      if (poVisitor->bDoExpand_WeatherAlertsForPosition(enSemanticDomain))
      {
         oPath.bGoUp();
         oPath.bGoDown(weatherfi_tclKnot(weatherfi_tclToken::EN_END_OF_STRUCT,weatherfi_tclSemanticDomain::EN_UNKNOWN));
         oPath.bGoDown(weatherfi_tclKnot(weatherfi_tclToken::EN_WEATHERALERT,weatherfi_tclSemanticDomain::EN_LIST_ELEMENT,0));
         oPath.bGoDown(weatherfi_tclKnot(weatherfi_tclToken::EN_LIST,weatherfi_tclSemanticDomain::EN_WEATHERALERTS));
         oPath.bGoDown(weatherfi_tclKnot(weatherfi_tclToken::EN_POSITIONWGS84,weatherfi_tclSemanticDomain::EN_POSITION));
      }
      else
      {
         fi_tcl_WeatherAlertsForPosition o_WeatherAlertsForPosition;
         if (!bDoIt(o_WeatherAlertsForPosition))
         {
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
            o_WeatherAlertsForPosition.vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
            return FALSE;
         }
         else
         {
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
            o_WeatherAlertsForPosition.vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
            oCallStack.bGoUp();
            oPath.bGoUp();
         }
      }
   } break;
   case weatherfi_tclToken::EN_SCALEFORTILE:
   {
      if (poVisitor->bDoExpand_ScaleForTile(enSemanticDomain))
      {
         oPath.bGoUp();
         oPath.bGoDown(weatherfi_tclKnot(weatherfi_tclToken::EN_END_OF_STRUCT,weatherfi_tclSemanticDomain::EN_UNKNOWN));
         oPath.bGoDown(weatherfi_tclKnot(weatherfi_tclToken::EN_SCALE,weatherfi_tclSemanticDomain::EN_SCALE));
         oPath.bGoDown(weatherfi_tclKnot(weatherfi_tclToken::EN_U32,weatherfi_tclSemanticDomain::EN_SIZE));
         oPath.bGoDown(weatherfi_tclKnot(weatherfi_tclToken::EN_U32,weatherfi_tclSemanticDomain::EN_OFFSET));
      }
      else
      {
         fi_tcl_ScaleForTile o_ScaleForTile;
         if (!bDoIt(o_ScaleForTile))
         {
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
            o_ScaleForTile.vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
            return FALSE;
         }
         else
         {
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
            o_ScaleForTile.vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
            oCallStack.bGoUp();
            oPath.bGoUp();
         }
      }
   } break;
   case weatherfi_tclToken::EN_AREAINSTATE:
   {
      if (poVisitor->bDoExpand_AreaInState(enSemanticDomain))
      {
         oPath.bGoUp();
         oPath.bGoDown(weatherfi_tclKnot(weatherfi_tclToken::EN_END_OF_STRUCT,weatherfi_tclSemanticDomain::EN_UNKNOWN));
         oPath.bGoDown(weatherfi_tclKnot(weatherfi_tclToken::EN_VERSIONPERSTATE,weatherfi_tclSemanticDomain::EN_VERSIONPERSTATE));
         oPath.bGoDown(weatherfi_tclKnot(weatherfi_tclToken::EN_AREABOUNDINGBOX,weatherfi_tclSemanticDomain::EN_AREA));
      }
      else
      {
         fi_tcl_AreaInState o_AreaInState;
         if (!bDoIt(o_AreaInState))
         {
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
            o_AreaInState.vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
            return FALSE;
         }
         else
         {
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
            o_AreaInState.vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
            oCallStack.bGoUp();
            oPath.bGoUp();
         }
      }
   } break;
   case weatherfi_tclToken::EN_STATESANDAREASPERLANGUAGE:
   {
      if (poVisitor->bDoExpand_StatesAndAreasPerLanguage(enSemanticDomain))
      {
         oPath.bGoUp();
         oPath.bGoDown(weatherfi_tclKnot(weatherfi_tclToken::EN_END_OF_STRUCT,weatherfi_tclSemanticDomain::EN_UNKNOWN));
         oPath.bGoDown(weatherfi_tclKnot(weatherfi_tclToken::EN_E16_ISOLANGUAGECODE,weatherfi_tclSemanticDomain::EN_LANGUAGE));
         oPath.bGoDown(weatherfi_tclKnot(weatherfi_tclToken::EN_AREAINSTATE,weatherfi_tclSemanticDomain::EN_LIST_ELEMENT,0));
         oPath.bGoDown(weatherfi_tclKnot(weatherfi_tclToken::EN_LIST,weatherfi_tclSemanticDomain::EN_AFFECTEDAREASINSTATES));
      }
      else
      {
         fi_tcl_StatesAndAreasPerLanguage o_StatesAndAreasPerLanguage;
         if (!bDoIt(o_StatesAndAreasPerLanguage))
         {
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
            o_StatesAndAreasPerLanguage.vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
            return FALSE;
         }
         else
         {
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
            o_StatesAndAreasPerLanguage.vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
            oCallStack.bGoUp();
            oPath.bGoUp();
         }
      }
   } break;
   case weatherfi_tclToken::EN_E8_PRODUCTTYPE:
   {
      fi_tcl_e8_ProductType o_e8_ProductType;
      if (!bDoIt(o_e8_ProductType))
         return FALSE;
      oCallStack.bGoUp();
      oPath.bGoUp();
   } break;
   case weatherfi_tclToken::EN_WEATHERSHAREDMEMORYDESCRIPTION:
   {
      if (poVisitor->bDoExpand_WeatherSharedMemoryDescription(enSemanticDomain))
      {
         oPath.bGoUp();
         oPath.bGoDown(weatherfi_tclKnot(weatherfi_tclToken::EN_END_OF_STRUCT,weatherfi_tclSemanticDomain::EN_UNKNOWN));
         oPath.bGoDown(weatherfi_tclKnot(weatherfi_tclToken::EN_BOOL,weatherfi_tclSemanticDomain::EN_OPEN));
         oPath.bGoDown(weatherfi_tclKnot(weatherfi_tclToken::EN_U32,weatherfi_tclSemanticDomain::EN_SHAREDMEMORYSIZE));
         oPath.bGoDown(weatherfi_tclKnot(weatherfi_tclToken::EN_STRING,weatherfi_tclSemanticDomain::EN_SHAREDMEMORYNAME));
         oPath.bGoDown(weatherfi_tclKnot(weatherfi_tclToken::EN_TILEIDENTIFIER,weatherfi_tclSemanticDomain::EN_TILEIDENTIFIER));
      }
      else
      {
         fi_tcl_WeatherSharedMemoryDescription o_WeatherSharedMemoryDescription;
         if (!bDoIt(o_WeatherSharedMemoryDescription))
         {
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
            o_WeatherSharedMemoryDescription.vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
            return FALSE;
         }
         else
         {
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
            o_WeatherSharedMemoryDescription.vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
            oCallStack.bGoUp();
            oPath.bGoUp();
         }
      }
   } break;
   case weatherfi_tclToken::EN_E8_FORMATVERSION:
   {
      fi_tcl_e8_FormatVersion o_e8_FormatVersion;
      if (!bDoIt(o_e8_FormatVersion))
         return FALSE;
      oCallStack.bGoUp();
      oPath.bGoUp();
   } break;
   case weatherfi_tclToken::EN_TILEANDRASTERPICTURESHAREDMEMORY:
   {
      if (poVisitor->bDoExpand_TileAndRasterPictureSharedMemory(enSemanticDomain))
      {
         oPath.bGoUp();
         oPath.bGoDown(weatherfi_tclKnot(weatherfi_tclToken::EN_END_OF_STRUCT,weatherfi_tclSemanticDomain::EN_UNKNOWN));
         oPath.bGoDown(weatherfi_tclKnot(weatherfi_tclToken::EN_SCALEFORTILE,weatherfi_tclSemanticDomain::EN_LIST_ELEMENT,0));
         oPath.bGoDown(weatherfi_tclKnot(weatherfi_tclToken::EN_LIST,weatherfi_tclSemanticDomain::EN_SCALESFORTILE));
         oPath.bGoDown(weatherfi_tclKnot(weatherfi_tclToken::EN_U32,weatherfi_tclSemanticDomain::EN_VERSIONSIZE));
         oPath.bGoDown(weatherfi_tclKnot(weatherfi_tclToken::EN_U32,weatherfi_tclSemanticDomain::EN_NUMBEROFVERSIONS));
         oPath.bGoDown(weatherfi_tclKnot(weatherfi_tclToken::EN_U32,weatherfi_tclSemanticDomain::EN_TILESIZE));
         oPath.bGoDown(weatherfi_tclKnot(weatherfi_tclToken::EN_U32,weatherfi_tclSemanticDomain::EN_NUMBEROFTILES));
         oPath.bGoDown(weatherfi_tclKnot(weatherfi_tclToken::EN_U32,weatherfi_tclSemanticDomain::EN_SIZE));
         oPath.bGoDown(weatherfi_tclKnot(weatherfi_tclToken::EN_STRING,weatherfi_tclSemanticDomain::EN_NAME));
      }
      else
      {
         fi_tcl_TileAndRasterPictureSharedMemory o_TileAndRasterPictureSharedMemory;
         if (!bDoIt(o_TileAndRasterPictureSharedMemory))
         {
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
            o_TileAndRasterPictureSharedMemory.vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
            return FALSE;
         }
         else
         {
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
            o_TileAndRasterPictureSharedMemory.vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
            oCallStack.bGoUp();
            oPath.bGoUp();
         }
      }
   } break;
   case weatherfi_tclToken::EN_RASTERTILE:
   {
      if (poVisitor->bDoExpand_RasterTile(enSemanticDomain))
      {
         oPath.bGoUp();
         oPath.bGoDown(weatherfi_tclKnot(weatherfi_tclToken::EN_END_OF_STRUCT,weatherfi_tclSemanticDomain::EN_UNKNOWN));
         oPath.bGoDown(weatherfi_tclKnot(weatherfi_tclToken::EN_SCALEFORTILE,weatherfi_tclSemanticDomain::EN_LIST_ELEMENT,0));
         oPath.bGoDown(weatherfi_tclKnot(weatherfi_tclToken::EN_LIST,weatherfi_tclSemanticDomain::EN_SCALESFORTILE));
         oPath.bGoDown(weatherfi_tclKnot(weatherfi_tclToken::EN_U32,weatherfi_tclSemanticDomain::EN_VALUEPRECISION));
         oPath.bGoDown(weatherfi_tclKnot(weatherfi_tclToken::EN_U32,weatherfi_tclSemanticDomain::EN_VALUEOFFSET));
         oPath.bGoDown(weatherfi_tclKnot(weatherfi_tclToken::EN_SCALE,weatherfi_tclSemanticDomain::EN_GENERATEDMAXSCALE));
         oPath.bGoDown(weatherfi_tclKnot(weatherfi_tclToken::EN_SCALE,weatherfi_tclSemanticDomain::EN_ORIGINALSCALE));
         oPath.bGoDown(weatherfi_tclKnot(weatherfi_tclToken::EN_AREABOUNDINGBOX,weatherfi_tclSemanticDomain::EN_BOUNDINGBOX));
         oPath.bGoDown(weatherfi_tclKnot(weatherfi_tclToken::EN_POSIXTIME,weatherfi_tclSemanticDomain::EN_TIMESTAMP));
         oPath.bGoDown(weatherfi_tclKnot(weatherfi_tclToken::EN_BOOL,weatherfi_tclSemanticDomain::EN_BELONGSTOPICTURE));
         oPath.bGoDown(weatherfi_tclKnot(weatherfi_tclToken::EN_S32,weatherfi_tclSemanticDomain::EN_SHAREDMEMORYSIZE));
         oPath.bGoDown(weatherfi_tclKnot(weatherfi_tclToken::EN_S32,weatherfi_tclSemanticDomain::EN_SHAREDMEMORYOFFSET));
      }
      else
      {
         fi_tcl_RasterTile o_RasterTile;
         if (!bDoIt(o_RasterTile))
         {
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
            o_RasterTile.vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
            return FALSE;
         }
         else
         {
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
            o_RasterTile.vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
            oCallStack.bGoUp();
            oPath.bGoUp();
         }
      }
   } break;
   case weatherfi_tclToken::EN_RASTERTILEPICTURE:
   {
      if (poVisitor->bDoExpand_RasterTilePicture(enSemanticDomain))
      {
         oPath.bGoUp();
         oPath.bGoDown(weatherfi_tclKnot(weatherfi_tclToken::EN_END_OF_STRUCT,weatherfi_tclSemanticDomain::EN_UNKNOWN));
         oPath.bGoDown(weatherfi_tclKnot(weatherfi_tclToken::EN_RASTERTILE,weatherfi_tclSemanticDomain::EN_LIST_ELEMENT,0));
         oPath.bGoDown(weatherfi_tclKnot(weatherfi_tclToken::EN_LIST,weatherfi_tclSemanticDomain::EN_TILELIST));
         oPath.bGoDown(weatherfi_tclKnot(weatherfi_tclToken::EN_BOOL,weatherfi_tclSemanticDomain::EN_OLDTILESINPICTURE));
         oPath.bGoDown(weatherfi_tclKnot(weatherfi_tclToken::EN_BOOL,weatherfi_tclSemanticDomain::EN_PICTURECOMPLETE));
         oPath.bGoDown(weatherfi_tclKnot(weatherfi_tclToken::EN_S32,weatherfi_tclSemanticDomain::EN_NUMBEROFEXPECTEDTILES));
         oPath.bGoDown(weatherfi_tclKnot(weatherfi_tclToken::EN_POSIXTIME,weatherfi_tclSemanticDomain::EN_TIMESTAMP));
      }
      else
      {
         fi_tcl_RasterTilePicture o_RasterTilePicture;
         if (!bDoIt(o_RasterTilePicture))
         {
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
            o_RasterTilePicture.vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
            return FALSE;
         }
         else
         {
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
            o_RasterTilePicture.vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
            oCallStack.bGoUp();
            oPath.bGoUp();
         }
      }
   } break;
   case weatherfi_tclToken::EN_GRAPHICALWEATHERTILE:
   {
      if (poVisitor->bDoExpand_GraphicalWeatherTile(enSemanticDomain))
      {
         oPath.bGoUp();
         oPath.bGoDown(weatherfi_tclKnot(weatherfi_tclToken::EN_END_OF_STRUCT,weatherfi_tclSemanticDomain::EN_UNKNOWN));
         oPath.bGoDown(weatherfi_tclKnot(weatherfi_tclToken::EN_SCALE,weatherfi_tclSemanticDomain::EN_GENERATEDMAXSCALE));
         oPath.bGoDown(weatherfi_tclKnot(weatherfi_tclToken::EN_SCALE,weatherfi_tclSemanticDomain::EN_ORIGINALSCALE));
         oPath.bGoDown(weatherfi_tclKnot(weatherfi_tclToken::EN_AREABOUNDINGBOX,weatherfi_tclSemanticDomain::EN_BOUNDINGBOX));
         oPath.bGoDown(weatherfi_tclKnot(weatherfi_tclToken::EN_POSIXTIME,weatherfi_tclSemanticDomain::EN_TIMESTAMP));
         oPath.bGoDown(weatherfi_tclKnot(weatherfi_tclToken::EN_BOOL,weatherfi_tclSemanticDomain::EN_BELONGSTOPICTURE));
         oPath.bGoDown(weatherfi_tclKnot(weatherfi_tclToken::EN_U32,weatherfi_tclSemanticDomain::EN_TILEVERSION));
         oPath.bGoDown(weatherfi_tclKnot(weatherfi_tclToken::EN_U32,weatherfi_tclSemanticDomain::EN_INDEXINTILEARRAY));
      }
      else
      {
         fi_tcl_GraphicalWeatherTile o_GraphicalWeatherTile;
         if (!bDoIt(o_GraphicalWeatherTile))
         {
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
            o_GraphicalWeatherTile.vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
            return FALSE;
         }
         else
         {
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
            o_GraphicalWeatherTile.vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
            oCallStack.bGoUp();
            oPath.bGoUp();
         }
      }
   } break;
   case weatherfi_tclToken::EN_GRAPHICALWEATHERTILEPICTURE:
   {
      if (poVisitor->bDoExpand_GraphicalWeatherTilePicture(enSemanticDomain))
      {
         oPath.bGoUp();
         oPath.bGoDown(weatherfi_tclKnot(weatherfi_tclToken::EN_END_OF_STRUCT,weatherfi_tclSemanticDomain::EN_UNKNOWN));
         oPath.bGoDown(weatherfi_tclKnot(weatherfi_tclToken::EN_GRAPHICALWEATHERTILE,weatherfi_tclSemanticDomain::EN_LIST_ELEMENT,0));
         oPath.bGoDown(weatherfi_tclKnot(weatherfi_tclToken::EN_LIST,weatherfi_tclSemanticDomain::EN_TILELIST));
         oPath.bGoDown(weatherfi_tclKnot(weatherfi_tclToken::EN_BOOL,weatherfi_tclSemanticDomain::EN_OLDTILESINPICTURE));
         oPath.bGoDown(weatherfi_tclKnot(weatherfi_tclToken::EN_BOOL,weatherfi_tclSemanticDomain::EN_PICTURECOMPLETE));
         oPath.bGoDown(weatherfi_tclKnot(weatherfi_tclToken::EN_U32,weatherfi_tclSemanticDomain::EN_NUMBEROFEXPECTEDTILES));
         oPath.bGoDown(weatherfi_tclKnot(weatherfi_tclToken::EN_POSIXTIME,weatherfi_tclSemanticDomain::EN_TIMESTAMP));
      }
      else
      {
         fi_tcl_GraphicalWeatherTilePicture o_GraphicalWeatherTilePicture;
         if (!bDoIt(o_GraphicalWeatherTilePicture))
         {
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
            o_GraphicalWeatherTilePicture.vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
            return FALSE;
         }
         else
         {
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
            o_GraphicalWeatherTilePicture.vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
            oCallStack.bGoUp();
            oPath.bGoUp();
         }
      }
   } break;
   case weatherfi_tclToken::EN_VERSIONSOFTILE:
   {
      if (poVisitor->bDoExpand_VersionsOfTile(enSemanticDomain))
      {
         oPath.bGoUp();
         oPath.bGoDown(weatherfi_tclKnot(weatherfi_tclToken::EN_END_OF_STRUCT,weatherfi_tclSemanticDomain::EN_UNKNOWN));
         oPath.bGoDown(weatherfi_tclKnot(weatherfi_tclToken::EN_U32,weatherfi_tclSemanticDomain::EN_LIST_ELEMENT,0));
         oPath.bGoDown(weatherfi_tclKnot(weatherfi_tclToken::EN_LIST,weatherfi_tclSemanticDomain::EN_TILEVERSIONLIST));
         oPath.bGoDown(weatherfi_tclKnot(weatherfi_tclToken::EN_U32,weatherfi_tclSemanticDomain::EN_INDEXINTILEARRAY));
      }
      else
      {
         fi_tcl_VersionsOfTile o_VersionsOfTile;
         if (!bDoIt(o_VersionsOfTile))
         {
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
            o_VersionsOfTile.vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
            return FALSE;
         }
         else
         {
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
            o_VersionsOfTile.vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
            oCallStack.bGoUp();
            oPath.bGoUp();
         }
      }
   } break;
      case weatherfi_tclToken::EN_UNKNOWN:
      case weatherfi_tclToken::EN_LAST_TOKEN:         
      default:
         return FALSE;
      }
  }
  return bResult;
}

