#ifndef __WEATHERFIDEBUGVISITOR_H__
#define __WEATHERFIDEBUGVISITOR_H__

class MY_DECL weatherfi_tclPrintVisitor : public weatherfi_tclVisitorBase {

private:
   /* default constructor */ weatherfi_tclPrintVisitor();  //lint !e1704   // use constructor with parameter

public:
   weatherfi_tclPrintVisitor(fi_tclOutput* poOut):poOutput(poOut) { line[0] = '\0'; }

   // --Besuche allgemeine Objekte	
   virtual tVoid vVisitU8(fi_tclU8& oU8);
   virtual tVoid vVisitS8(fi_tclS8& oS8);
   virtual tVoid vVisitU16(fi_tclU16& oU16);
   virtual tVoid vVisitS16(fi_tclS16& oS16);
   virtual tVoid vVisitU24(fi_tclU24& oU24);
   virtual tVoid vVisitS24(fi_tclS24& oS24);
   virtual tVoid vVisitU32(fi_tclU32& oU32);
   virtual tVoid vVisitS32(fi_tclS32& oS32);
   virtual tVoid vVisitU64(fi_tclU64& oU64);
   virtual tVoid vVisitS64(fi_tclS64& oS64);
   virtual tVoid vVisitBool(fi_tclBool& oBool);
   virtual tVoid vVisitString(fi_tclString& oString);
   virtual tVoid vVisitMultiLanguageString(fi_tclMultiLanguageString& oString);
   virtual tVoid vVisitList(fi_tclList& oList);

   // Besuche die generierten Typen
   virtual tBool bDoExpand_BinContainer(weatherfi_tclSemanticDomain::tenType enSemantic);
   virtual tBool bDoExpand_Reserved(weatherfi_tclSemanticDomain::tenType enSemantic);
   virtual tVoid vVisit_u8_Percent(fi_tcl_u8_Percent& o_u8_Percent);
   virtual tVoid vVisit_s32_Meter(fi_tcl_s32_Meter& o_s32_Meter);
   virtual tVoid vVisit_s32_Foot(fi_tcl_s32_Foot& o_s32_Foot);
   virtual tVoid vVisit_s32_Millimeter(fi_tcl_s32_Millimeter& o_s32_Millimeter);
   virtual tBool bDoExpand_POSIXTime(weatherfi_tclSemanticDomain::tenType enSemantic);
   virtual tVoid vVisit_s16_KmPerHour(fi_tcl_s16_KmPerHour& o_s16_KmPerHour);
   virtual tVoid vVisit_s16_Knot(fi_tcl_s16_Knot& o_s16_Knot);
   virtual tVoid vVisit_s16_Kelvin(fi_tcl_s16_Kelvin& o_s16_Kelvin);
   virtual tVoid vVisit_s16_Fahrenheit(fi_tcl_s16_Fahrenheit& o_s16_Fahrenheit);
   virtual tVoid vVisit_s32_Pascal(fi_tcl_s32_Pascal& o_s32_Pascal);
   virtual tBool bDoExpand_FIVersion(weatherfi_tclSemanticDomain::tenType enSemantic);
   virtual tVoid vVisit_s32_Longitude(fi_tcl_s32_Longitude& o_s32_Longitude);
   virtual tVoid vVisit_s32_Latitude(fi_tcl_s32_Latitude& o_s32_Latitude);
   virtual tBool bDoExpand_PositionWGS84(weatherfi_tclSemanticDomain::tenType enSemantic);
   virtual tVoid vVisit_e16_ISOLanguageCode(fi_tcl_e16_ISOLanguageCode& o_e16_ISOLanguageCode);
   virtual tVoid vVisit_u8_DirectionAbsolute(fi_tcl_u8_DirectionAbsolute& o_u8_DirectionAbsolute);
   virtual tVoid vVisit_s16_Degree(fi_tcl_s16_Degree& o_s16_Degree);
   virtual tVoid vVisit_e8_BinContainerTypes(fi_tcl_e8_BinContainerTypes& o_e8_BinContainerTypes);
   virtual tVoid vVisit_e8_WeatherShapeType(fi_tcl_e8_WeatherShapeType& o_e8_WeatherShapeType);
   virtual tVoid vVisit_b8_ShapeContent(fi_tcl_b8_ShapeContent& o_b8_ShapeContent);
   virtual tBool bDoExpand_WeatherShape(weatherfi_tclSemanticDomain::tenType enSemantic);
   virtual tVoid vVisit_e8_WeatherTileType(fi_tcl_e8_WeatherTileType& o_e8_WeatherTileType);
   virtual tVoid vVisit_e8_WeatherTileDataType(fi_tcl_e8_WeatherTileDataType& o_e8_WeatherTileDataType);
   virtual tVoid vVisit_e8_PictureType(fi_tcl_e8_PictureType& o_e8_PictureType);
   virtual tBool bDoExpand_TileIdentifier(weatherfi_tclSemanticDomain::tenType enSemantic);
   virtual tBool bDoExpand_AreaBoundingBox(weatherfi_tclSemanticDomain::tenType enSemantic);
   virtual tBool bDoExpand_Scale(weatherfi_tclSemanticDomain::tenType enSemantic);
   virtual tBool bDoExpand_WeatherShapeList(weatherfi_tclSemanticDomain::tenType enSemantic);
#ifndef FI_S_EXTERNAL_FI
   virtual tBool bDoExpand_GraphicalWeatherShapeBinContainer(weatherfi_tclSemanticDomain::tenType enSemantic);
#endif // FI_S_EXTERNAL_FI
   virtual tVoid vVisit_e8_WeatherFrontType(fi_tcl_e8_WeatherFrontType& o_e8_WeatherFrontType);
   virtual tVoid vVisit_e8_WeatherPressureType(fi_tcl_e8_WeatherPressureType& o_e8_WeatherPressureType);
   virtual tBool bDoExpand_WeatherShapeTypeIsobar(weatherfi_tclSemanticDomain::tenType enSemantic);
   virtual tBool bDoExpand_WeatherShapeTypeWindRadius(weatherfi_tclSemanticDomain::tenType enSemantic);
   virtual tVoid vVisit_e8_WeatherStormPositionType(fi_tcl_e8_WeatherStormPositionType& o_e8_WeatherStormPositionType);
   virtual tVoid vVisit_e8_WeatherStormType(fi_tcl_e8_WeatherStormType& o_e8_WeatherStormType);
   virtual tVoid vVisit_b8_WeatherStormType(fi_tcl_b8_WeatherStormType& o_b8_WeatherStormType);
   virtual tBool bDoExpand_WeatherShapeTypeStormAttributes(weatherfi_tclSemanticDomain::tenType enSemantic);
   virtual tBool bDoExpand_WeatherShapeTypeFront(weatherfi_tclSemanticDomain::tenType enSemantic);
   virtual tBool bDoExpand_WeatherShapeTypePressureCenter(weatherfi_tclSemanticDomain::tenType enSemantic);
   virtual tBool bDoExpand_WeatherShapeTypeStormPosition(weatherfi_tclSemanticDomain::tenType enSemantic);
   virtual tBool bDoExpand_WeatherShapeTypeStormTrack(weatherfi_tclSemanticDomain::tenType enSemantic);
   virtual tVoid vVisit_e8_WeatherId(fi_tcl_e8_WeatherId& o_e8_WeatherId);
   virtual tVoid vVisit_e8_CountyWarningCode(fi_tcl_e8_CountyWarningCode& o_e8_CountyWarningCode);
   virtual tVoid vVisit_e8_TabularWeatherId(fi_tcl_e8_TabularWeatherId& o_e8_TabularWeatherId);
   virtual tVoid vVisit_e8_Timezone(fi_tcl_e8_Timezone& o_e8_Timezone);
   virtual tBool bDoExpand_State(weatherfi_tclSemanticDomain::tenType enSemantic);
   virtual tBool bDoExpand_WeatherCondition(weatherfi_tclSemanticDomain::tenType enSemantic);
   virtual tBool bDoExpand_Visibility(weatherfi_tclSemanticDomain::tenType enSemantic);
   virtual tBool bDoExpand_MetarStation(weatherfi_tclSemanticDomain::tenType enSemantic);
   virtual tBool bDoExpand_CurrentWeather(weatherfi_tclSemanticDomain::tenType enSemantic);
   virtual tBool bDoExpand_WeatherForPosition(weatherfi_tclSemanticDomain::tenType enSemantic);
   virtual tBool bDoExpand_MarineZone(weatherfi_tclSemanticDomain::tenType enSemantic);
   virtual tBool bDoExpand_CodedCity(weatherfi_tclSemanticDomain::tenType enSemantic);
   virtual tBool bDoExpand_WeatherForecast(weatherfi_tclSemanticDomain::tenType enSemantic);
   virtual tBool bDoExpand_WeatherForecastForPosition(weatherfi_tclSemanticDomain::tenType enSemantic);
   virtual tBool bDoExpand_WarningId(weatherfi_tclSemanticDomain::tenType enSemantic);
   virtual tBool bDoExpand_County(weatherfi_tclSemanticDomain::tenType enSemantic);
   virtual tBool bDoExpand_CountyWarning(weatherfi_tclSemanticDomain::tenType enSemantic);
   virtual tVoid vVisit_b16_ForecastType(fi_tcl_b16_ForecastType& o_b16_ForecastType);
   virtual tVoid vVisit_e8_ForecastType(fi_tcl_e8_ForecastType& o_e8_ForecastType);
   virtual tBool bDoExpand_VersionPerForecast(weatherfi_tclSemanticDomain::tenType enSemantic);
   virtual tVoid vVisit_e8_PrecipitationType(fi_tcl_e8_PrecipitationType& o_e8_PrecipitationType);
   virtual tVoid vVisit_e8_CloudCoverageType(fi_tcl_e8_CloudCoverageType& o_e8_CloudCoverageType);
   virtual tBool bDoExpand_TabularWeatherLocation(weatherfi_tclSemanticDomain::tenType enSemantic);
   virtual tBool bDoExpand_TabularWeatherCondition(weatherfi_tclSemanticDomain::tenType enSemantic);
   virtual tBool bDoExpand_Precipitation(weatherfi_tclSemanticDomain::tenType enSemantic);
   virtual tBool bDoExpand_Humidity(weatherfi_tclSemanticDomain::tenType enSemantic);
   virtual tBool bDoExpand_CloudCoverage(weatherfi_tclSemanticDomain::tenType enSemantic);
   virtual tBool bDoExpand_UVLevel(weatherfi_tclSemanticDomain::tenType enSemantic);
   virtual tBool bDoExpand_PollenLevel(weatherfi_tclSemanticDomain::tenType enSemantic);
   virtual tBool bDoExpand_TabularWeatherPerForecast(weatherfi_tclSemanticDomain::tenType enSemantic);
   virtual tBool bDoExpand_TabularWeather(weatherfi_tclSemanticDomain::tenType enSemantic);
   virtual tBool bDoExpand_TabularWeatherForPosition(weatherfi_tclSemanticDomain::tenType enSemantic);
   virtual tVoid vVisit_b16_SkiAreaAttributes(fi_tcl_b16_SkiAreaAttributes& o_b16_SkiAreaAttributes);
   virtual tBool bDoExpand_SkiAreaAttributes(weatherfi_tclSemanticDomain::tenType enSemantic);
   virtual tBool bDoExpand_SkiCondition(weatherfi_tclSemanticDomain::tenType enSemantic);
   virtual tBool bDoExpand_SkiConditionForPosition(weatherfi_tclSemanticDomain::tenType enSemantic);
   virtual tVoid vVisit_e8_AlertType(fi_tcl_e8_AlertType& o_e8_AlertType);
   virtual tBool bDoExpand_AlertType(weatherfi_tclSemanticDomain::tenType enSemantic);
   virtual tBool bDoExpand_WeatherAlertArea(weatherfi_tclSemanticDomain::tenType enSemantic);
   virtual tBool bDoExpand_StateOrZone(weatherfi_tclSemanticDomain::tenType enSemantic);
   virtual tBool bDoExpand_WeatherAlert(weatherfi_tclSemanticDomain::tenType enSemantic);
   virtual tBool bDoExpand_VersionPerState(weatherfi_tclSemanticDomain::tenType enSemantic);
   virtual tBool bDoExpand_StatesPerLanguage(weatherfi_tclSemanticDomain::tenType enSemantic);
   virtual tBool bDoExpand_WeatherAlertsForPosition(weatherfi_tclSemanticDomain::tenType enSemantic);
   virtual tBool bDoExpand_ScaleForTile(weatherfi_tclSemanticDomain::tenType enSemantic);
   virtual tBool bDoExpand_AreaInState(weatherfi_tclSemanticDomain::tenType enSemantic);
   virtual tBool bDoExpand_StatesAndAreasPerLanguage(weatherfi_tclSemanticDomain::tenType enSemantic);
   virtual tVoid vVisit_e8_ProductType(fi_tcl_e8_ProductType& o_e8_ProductType);
   virtual tBool bDoExpand_WeatherSharedMemoryDescription(weatherfi_tclSemanticDomain::tenType enSemantic);
   virtual tVoid vVisit_e8_FormatVersion(fi_tcl_e8_FormatVersion& o_e8_FormatVersion);
   virtual tBool bDoExpand_TileAndRasterPictureSharedMemory(weatherfi_tclSemanticDomain::tenType enSemantic);
   virtual tBool bDoExpand_RasterTile(weatherfi_tclSemanticDomain::tenType enSemantic);
   virtual tBool bDoExpand_RasterTilePicture(weatherfi_tclSemanticDomain::tenType enSemantic);
   virtual tBool bDoExpand_GraphicalWeatherTile(weatherfi_tclSemanticDomain::tenType enSemantic);
   virtual tBool bDoExpand_GraphicalWeatherTilePicture(weatherfi_tclSemanticDomain::tenType enSemantic);
   virtual tBool bDoExpand_VersionsOfTile(weatherfi_tclSemanticDomain::tenType enSemantic);
private:
	// ostream& oOut;
   tChar line[256];
   /*
	OSAL_tIODescriptor fd;
   char *ps8PrintBuf;
   tU32 u32BufSize;
   static const tU32 C_U32_MAXLINELENGTH;
   */
   fi_tclOutput* poOutput;
};


class MY_DECL weatherfi_tclRandomInitVisitor : public weatherfi_tclVisitorBase {
public:

   weatherfi_tclRandomInitVisitor(tU32 u32Seed=1):u32ListSize(3) { srand(u32Seed); }
   tVoid vSetSeed(tU32 u32Seed) const { srand(u32Seed); }
   // --Besuche allgemeine Objekte	
   virtual tVoid vVisitU8(fi_tclU8& oU8);
   virtual tVoid vVisitS8(fi_tclS8& oS8);
   virtual tVoid vVisitU16(fi_tclU16& oU16);
   virtual tVoid vVisitS16(fi_tclS16& oS16);
   virtual tVoid vVisitU24(fi_tclU24& oU24);
   virtual tVoid vVisitS24(fi_tclS24& oS24);
   virtual tVoid vVisitU32(fi_tclU32& oU32);
   virtual tVoid vVisitS32(fi_tclS32& oS32);
   virtual tVoid vVisitU64(fi_tclU64& oU64);
   virtual tVoid vVisitS64(fi_tclS64& oS64);
   virtual tVoid vVisitBool(fi_tclBool& oBool);
   virtual tVoid vVisitString(fi_tclString& oString);
   virtual tVoid vVisitMultiLanguageString(fi_tclMultiLanguageString& oString);
   virtual tVoid vVisitList(fi_tclList& oList);

	// Besuche die generierten Typen
   virtual tVoid vVisit_u8_Percent(fi_tcl_u8_Percent& o_u8_Percent);
   virtual tVoid vVisit_s32_Meter(fi_tcl_s32_Meter& o_s32_Meter);
   virtual tVoid vVisit_s32_Foot(fi_tcl_s32_Foot& o_s32_Foot);
   virtual tVoid vVisit_s32_Millimeter(fi_tcl_s32_Millimeter& o_s32_Millimeter);
   virtual tVoid vVisit_s16_KmPerHour(fi_tcl_s16_KmPerHour& o_s16_KmPerHour);
   virtual tVoid vVisit_s16_Knot(fi_tcl_s16_Knot& o_s16_Knot);
   virtual tVoid vVisit_s16_Kelvin(fi_tcl_s16_Kelvin& o_s16_Kelvin);
   virtual tVoid vVisit_s16_Fahrenheit(fi_tcl_s16_Fahrenheit& o_s16_Fahrenheit);
   virtual tVoid vVisit_s32_Pascal(fi_tcl_s32_Pascal& o_s32_Pascal);
   virtual tVoid vVisit_s32_Longitude(fi_tcl_s32_Longitude& o_s32_Longitude);
   virtual tVoid vVisit_s32_Latitude(fi_tcl_s32_Latitude& o_s32_Latitude);
   virtual tVoid vVisit_e16_ISOLanguageCode(fi_tcl_e16_ISOLanguageCode& o_e16_ISOLanguageCode);
   virtual tVoid vVisit_u8_DirectionAbsolute(fi_tcl_u8_DirectionAbsolute& o_u8_DirectionAbsolute);
   virtual tVoid vVisit_s16_Degree(fi_tcl_s16_Degree& o_s16_Degree);
   virtual tVoid vVisit_e8_BinContainerTypes(fi_tcl_e8_BinContainerTypes& o_e8_BinContainerTypes);
   virtual tVoid vVisit_e8_WeatherShapeType(fi_tcl_e8_WeatherShapeType& o_e8_WeatherShapeType);
   virtual tVoid vVisit_b8_ShapeContent(fi_tcl_b8_ShapeContent& o_b8_ShapeContent);
   virtual tVoid vVisit_e8_WeatherTileType(fi_tcl_e8_WeatherTileType& o_e8_WeatherTileType);
   virtual tVoid vVisit_e8_WeatherTileDataType(fi_tcl_e8_WeatherTileDataType& o_e8_WeatherTileDataType);
   virtual tVoid vVisit_e8_PictureType(fi_tcl_e8_PictureType& o_e8_PictureType);
#ifndef FI_S_EXTERNAL_FI
#endif // FI_S_EXTERNAL_FI
   virtual tVoid vVisit_e8_WeatherFrontType(fi_tcl_e8_WeatherFrontType& o_e8_WeatherFrontType);
   virtual tVoid vVisit_e8_WeatherPressureType(fi_tcl_e8_WeatherPressureType& o_e8_WeatherPressureType);
   virtual tVoid vVisit_e8_WeatherStormPositionType(fi_tcl_e8_WeatherStormPositionType& o_e8_WeatherStormPositionType);
   virtual tVoid vVisit_e8_WeatherStormType(fi_tcl_e8_WeatherStormType& o_e8_WeatherStormType);
   virtual tVoid vVisit_b8_WeatherStormType(fi_tcl_b8_WeatherStormType& o_b8_WeatherStormType);
   virtual tVoid vVisit_e8_WeatherId(fi_tcl_e8_WeatherId& o_e8_WeatherId);
   virtual tVoid vVisit_e8_CountyWarningCode(fi_tcl_e8_CountyWarningCode& o_e8_CountyWarningCode);
   virtual tVoid vVisit_e8_TabularWeatherId(fi_tcl_e8_TabularWeatherId& o_e8_TabularWeatherId);
   virtual tVoid vVisit_e8_Timezone(fi_tcl_e8_Timezone& o_e8_Timezone);
   virtual tVoid vVisit_b16_ForecastType(fi_tcl_b16_ForecastType& o_b16_ForecastType);
   virtual tVoid vVisit_e8_ForecastType(fi_tcl_e8_ForecastType& o_e8_ForecastType);
   virtual tVoid vVisit_e8_PrecipitationType(fi_tcl_e8_PrecipitationType& o_e8_PrecipitationType);
   virtual tVoid vVisit_e8_CloudCoverageType(fi_tcl_e8_CloudCoverageType& o_e8_CloudCoverageType);
   virtual tVoid vVisit_b16_SkiAreaAttributes(fi_tcl_b16_SkiAreaAttributes& o_b16_SkiAreaAttributes);
   virtual tVoid vVisit_e8_AlertType(fi_tcl_e8_AlertType& o_e8_AlertType);
   virtual tVoid vVisit_e8_ProductType(fi_tcl_e8_ProductType& o_e8_ProductType);
   virtual tVoid vVisit_e8_FormatVersion(fi_tcl_e8_FormatVersion& o_e8_FormatVersion);
	tU32 u32ListSize;
};

#endif
