/************************************************************************
 
 *FILE:           navifitypes.h
 
 *SW-COMPONENT:   NaviFI, Navigation Functional Interface
 
 *DESCRIPTION:    Interface fuer NachrichtenStrukturTypdefinitionen des navifi
                  
 *AUTHOR:         Jochen Bruns (CM-DI/ENS41)
 
 *COPYRIGHT:      (c) 2001 Blaupunkt GmbH
 
 *HISTORY:
           (t.b.a)
 * 
 *    Rev 1.0   Oct 7 2001 17:16:00   bnj2hi
 * Initial revision
 *  
 ************************************************************************/

#ifndef VEHICLECFGFITYPES_HEADER
#define VEHICLECFGFITYPES_HEADER

// #include <vector>
// 


class vehiclecfgfi_tclVisitorBase;

/* --NaviFI-MessageStrukturtypen --*/

class vehiclecfgfi_tclMsgVehicleConfigurationUpReg : public fi_tclVisitableTypeBase, public fi_tclMessageBase
{
public:
   virtual tU16 u16GetServiceID() const;
   virtual tU16 u16GetFunctionID() const;
   virtual tU8  u8GetOpCode() const;
   virtual const fi_tclTypeBase& corfoGetTypeBase() const {return *this;};
   virtual fi_tclTypeBase& rfoGetTypeBase() {return *this;};
   vehiclecfgfi_tclMsgVehicleConfigurationUpReg() {}
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   vehiclecfgfi_tclMsgVehicleConfigurationUpReg& operator=(const vehiclecfgfi_tclMsgVehicleConfigurationUpReg& coRef);
   vehiclecfgfi_tclMsgVehicleConfigurationUpReg(const vehiclecfgfi_tclMsgVehicleConfigurationUpReg& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual tBool operator==(const vehiclecfgfi_tclMsgVehicleConfigurationUpReg& rfoCmp) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   virtual tS32 s32GetTypeId() const { return vehiclecfgfi_tclToken::EN_MSG_VEHICLECONFIGURATIONUPREG;}
};

class vehiclecfgfi_tclMsgVehicleConfigurationRelUpReg : public fi_tclVisitableTypeBase, public fi_tclMessageBase
{
public:
   virtual tU16 u16GetServiceID() const;
   virtual tU16 u16GetFunctionID() const;
   virtual tU8  u8GetOpCode() const;
   virtual const fi_tclTypeBase& corfoGetTypeBase() const {return *this;};
   virtual fi_tclTypeBase& rfoGetTypeBase() {return *this;};
   vehiclecfgfi_tclMsgVehicleConfigurationRelUpReg() {}
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   vehiclecfgfi_tclMsgVehicleConfigurationRelUpReg& operator=(const vehiclecfgfi_tclMsgVehicleConfigurationRelUpReg& coRef);
   vehiclecfgfi_tclMsgVehicleConfigurationRelUpReg(const vehiclecfgfi_tclMsgVehicleConfigurationRelUpReg& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual tBool operator==(const vehiclecfgfi_tclMsgVehicleConfigurationRelUpReg& rfoCmp) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   virtual tS32 s32GetTypeId() const { return vehiclecfgfi_tclToken::EN_MSG_VEHICLECONFIGURATIONRELUPREG;}
};

class vehiclecfgfi_tclMsgVehicleConfigurationGet : public fi_tclVisitableTypeBase, public fi_tclMessageBase
{
public:
   virtual tU16 u16GetServiceID() const;
   virtual tU16 u16GetFunctionID() const;
   virtual tU8  u8GetOpCode() const;
   virtual const fi_tclTypeBase& corfoGetTypeBase() const {return *this;};
   virtual fi_tclTypeBase& rfoGetTypeBase() {return *this;};
   vehiclecfgfi_tclMsgVehicleConfigurationGet() {}
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   vehiclecfgfi_tclMsgVehicleConfigurationGet& operator=(const vehiclecfgfi_tclMsgVehicleConfigurationGet& coRef);
   vehiclecfgfi_tclMsgVehicleConfigurationGet(const vehiclecfgfi_tclMsgVehicleConfigurationGet& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual tBool operator==(const vehiclecfgfi_tclMsgVehicleConfigurationGet& rfoCmp) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   virtual tS32 s32GetTypeId() const { return vehiclecfgfi_tclToken::EN_MSG_VEHICLECONFIGURATIONGET;}
};

class vehiclecfgfi_tclMsgVehicleConfigurationStatus : public fi_tclVisitableTypeBase, public fi_tclMessageBase
{
public:
   virtual tU16 u16GetServiceID() const;
   virtual tU16 u16GetFunctionID() const;
   virtual tU8  u8GetOpCode() const;
   virtual const fi_tclTypeBase& corfoGetTypeBase() const {return *this;};
   virtual fi_tclTypeBase& rfoGetTypeBase() {return *this;};
   vehiclecfgfi_tclMsgVehicleConfigurationStatus():Brand(),VehicleType(0),EngineType(0),Gearbox(0),ConsumptionCurve(0),FuelType(),VehicleAttributes() {}
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   vehiclecfgfi_tclMsgVehicleConfigurationStatus& operator=(const vehiclecfgfi_tclMsgVehicleConfigurationStatus& coRef);
   vehiclecfgfi_tclMsgVehicleConfigurationStatus(const vehiclecfgfi_tclMsgVehicleConfigurationStatus& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
   fi_tcl_e16_CarManufacturerBrand Brand;
   tU32 VehicleType;
   tU32 EngineType;
   tU32 Gearbox;
   tU32 ConsumptionCurve;
   fi_tcl_e8_FuelType FuelType;
   fi_tcl_b8_VehicleAttributes VehicleAttributes;

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual tBool operator==(const vehiclecfgfi_tclMsgVehicleConfigurationStatus& rfoCmp) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   virtual tS32 s32GetTypeId() const { return vehiclecfgfi_tclToken::EN_MSG_VEHICLECONFIGURATIONSTATUS;}
};


#endif
