/************************************************************************
 
 *FILE:           navifitypes.cpp
 
 *SW-COMPONENT:   NaviFI, Navigation Functional Interface
 
 *DESCRIPTION:    Interface fuer allgemeine Typdefinitionen des Nafi
                  
 *AUTHOR:         Jochen Bruns (CM-DI/ENS41)
 
 *COPYRIGHT:      (c) 2001 Blaupunkt GmbH
 
 ************************************************************************/

#include "precompiled.hh"
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
vehiclecfgfi_tclMsgVehicleConfigurationUpReg::vehiclecfgfi_tclMsgVehicleConfigurationUpReg(const vehiclecfgfi_tclMsgVehicleConfigurationUpReg& coRef):fi_tclVisitableTypeBase(coRef)
{
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
vehiclecfgfi_tclMsgVehicleConfigurationUpReg& vehiclecfgfi_tclMsgVehicleConfigurationUpReg::operator=(const vehiclecfgfi_tclMsgVehicleConfigurationUpReg& coRef)
{
   if (this == &coRef) return *this;
   return *this;
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
tU16 vehiclecfgfi_tclMsgVehicleConfigurationUpReg::u16GetServiceID() const {return VEHICLECFGFI_C_U16_SERVICE_ID;}
tU16 vehiclecfgfi_tclMsgVehicleConfigurationUpReg::u16GetFunctionID() const {return VEHICLECFGFI_C_U16_VEHICLECONFIGURATION;}
tU8 vehiclecfgfi_tclMsgVehicleConfigurationUpReg::u8GetOpCode() const {return CCA_C_U8_OPCODE_UPREG;}

tU32 vehiclecfgfi_tclMsgVehicleConfigurationUpReg::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 0;
}

tBool vehiclecfgfi_tclMsgVehicleConfigurationUpReg::operator==(const vehiclecfgfi_tclMsgVehicleConfigurationUpReg& /* rfoCmp */) const
{
   tBool bResult = true;
   return bResult;
}

fi_tclInContext& vehiclecfgfi_tclMsgVehicleConfigurationUpReg::oRead(fi_tclInContext& oIn)
{
   return oIn;
}

fi_tclOutContext& vehiclecfgfi_tclMsgVehicleConfigurationUpReg::oWrite(fi_tclOutContext& oOut) const
{
   return oOut;
}

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
vehiclecfgfi_tclMsgVehicleConfigurationRelUpReg::vehiclecfgfi_tclMsgVehicleConfigurationRelUpReg(const vehiclecfgfi_tclMsgVehicleConfigurationRelUpReg& coRef):fi_tclVisitableTypeBase(coRef)
{
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
vehiclecfgfi_tclMsgVehicleConfigurationRelUpReg& vehiclecfgfi_tclMsgVehicleConfigurationRelUpReg::operator=(const vehiclecfgfi_tclMsgVehicleConfigurationRelUpReg& coRef)
{
   if (this == &coRef) return *this;
   return *this;
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
tU16 vehiclecfgfi_tclMsgVehicleConfigurationRelUpReg::u16GetServiceID() const {return VEHICLECFGFI_C_U16_SERVICE_ID;}
tU16 vehiclecfgfi_tclMsgVehicleConfigurationRelUpReg::u16GetFunctionID() const {return VEHICLECFGFI_C_U16_VEHICLECONFIGURATION;}
tU8 vehiclecfgfi_tclMsgVehicleConfigurationRelUpReg::u8GetOpCode() const {return CCA_C_U8_OPCODE_RELUPREG;}

tU32 vehiclecfgfi_tclMsgVehicleConfigurationRelUpReg::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 0;
}

tBool vehiclecfgfi_tclMsgVehicleConfigurationRelUpReg::operator==(const vehiclecfgfi_tclMsgVehicleConfigurationRelUpReg& /* rfoCmp */) const
{
   tBool bResult = true;
   return bResult;
}

fi_tclInContext& vehiclecfgfi_tclMsgVehicleConfigurationRelUpReg::oRead(fi_tclInContext& oIn)
{
   return oIn;
}

fi_tclOutContext& vehiclecfgfi_tclMsgVehicleConfigurationRelUpReg::oWrite(fi_tclOutContext& oOut) const
{
   return oOut;
}

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
vehiclecfgfi_tclMsgVehicleConfigurationGet::vehiclecfgfi_tclMsgVehicleConfigurationGet(const vehiclecfgfi_tclMsgVehicleConfigurationGet& coRef):fi_tclVisitableTypeBase(coRef)
{
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
vehiclecfgfi_tclMsgVehicleConfigurationGet& vehiclecfgfi_tclMsgVehicleConfigurationGet::operator=(const vehiclecfgfi_tclMsgVehicleConfigurationGet& coRef)
{
   if (this == &coRef) return *this;
   return *this;
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
tU16 vehiclecfgfi_tclMsgVehicleConfigurationGet::u16GetServiceID() const {return VEHICLECFGFI_C_U16_SERVICE_ID;}
tU16 vehiclecfgfi_tclMsgVehicleConfigurationGet::u16GetFunctionID() const {return VEHICLECFGFI_C_U16_VEHICLECONFIGURATION;}
tU8 vehiclecfgfi_tclMsgVehicleConfigurationGet::u8GetOpCode() const {return CCA_C_U8_OPCODE_GET;}

tU32 vehiclecfgfi_tclMsgVehicleConfigurationGet::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 0;
}

tBool vehiclecfgfi_tclMsgVehicleConfigurationGet::operator==(const vehiclecfgfi_tclMsgVehicleConfigurationGet& /* rfoCmp */) const
{
   tBool bResult = true;
   return bResult;
}

fi_tclInContext& vehiclecfgfi_tclMsgVehicleConfigurationGet::oRead(fi_tclInContext& oIn)
{
   return oIn;
}

fi_tclOutContext& vehiclecfgfi_tclMsgVehicleConfigurationGet::oWrite(fi_tclOutContext& oOut) const
{
   return oOut;
}

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
vehiclecfgfi_tclMsgVehicleConfigurationStatus::vehiclecfgfi_tclMsgVehicleConfigurationStatus(const vehiclecfgfi_tclMsgVehicleConfigurationStatus& coRef):fi_tclVisitableTypeBase(coRef)
{
   Brand = coRef.Brand;
   VehicleType = coRef.VehicleType;
   EngineType = coRef.EngineType;
   Gearbox = coRef.Gearbox;
   ConsumptionCurve = coRef.ConsumptionCurve;
   FuelType = coRef.FuelType;
   VehicleAttributes = coRef.VehicleAttributes;
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
vehiclecfgfi_tclMsgVehicleConfigurationStatus& vehiclecfgfi_tclMsgVehicleConfigurationStatus::operator=(const vehiclecfgfi_tclMsgVehicleConfigurationStatus& coRef)
{
   if (this == &coRef) return *this;
   Brand = coRef.Brand;
   VehicleType = coRef.VehicleType;
   EngineType = coRef.EngineType;
   Gearbox = coRef.Gearbox;
   ConsumptionCurve = coRef.ConsumptionCurve;
   FuelType = coRef.FuelType;
   VehicleAttributes = coRef.VehicleAttributes;
   return *this;
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
tU16 vehiclecfgfi_tclMsgVehicleConfigurationStatus::u16GetServiceID() const {return VEHICLECFGFI_C_U16_SERVICE_ID;}
tU16 vehiclecfgfi_tclMsgVehicleConfigurationStatus::u16GetFunctionID() const {return VEHICLECFGFI_C_U16_VEHICLECONFIGURATION;}
tU8 vehiclecfgfi_tclMsgVehicleConfigurationStatus::u8GetOpCode() const {return CCA_C_U8_OPCODE_STATUS;}

tU32 vehiclecfgfi_tclMsgVehicleConfigurationStatus::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 20;
}

tBool vehiclecfgfi_tclMsgVehicleConfigurationStatus::operator==(const vehiclecfgfi_tclMsgVehicleConfigurationStatus& rfoCmp) const
{
   tBool bResult = true;
      bResult = bResult && (Brand == rfoCmp.Brand);
      bResult = bResult && (VehicleType == rfoCmp.VehicleType);
      bResult = bResult && (EngineType == rfoCmp.EngineType);
      bResult = bResult && (Gearbox == rfoCmp.Gearbox);
      bResult = bResult && (ConsumptionCurve == rfoCmp.ConsumptionCurve);
      bResult = bResult && (FuelType == rfoCmp.FuelType);
      bResult = bResult && (VehicleAttributes == rfoCmp.VehicleAttributes);
   return bResult;
}

fi_tclInContext& vehiclecfgfi_tclMsgVehicleConfigurationStatus::oRead(fi_tclInContext& oIn)
{
   oIn >> Brand;
   oIn >> VehicleType;
   oIn >> EngineType;
   oIn >> Gearbox;
   oIn >> ConsumptionCurve;
   oIn >> FuelType;
   oIn >> VehicleAttributes;
   return oIn;
}

fi_tclOutContext& vehiclecfgfi_tclMsgVehicleConfigurationStatus::oWrite(fi_tclOutContext& oOut) const
{
   oOut << Brand;
   oOut << VehicleType;
   oOut << EngineType;
   oOut << Gearbox;
   oOut << ConsumptionCurve;
   oOut << FuelType;
   oOut << VehicleAttributes;
   return oOut;
}

