#ifndef VEHICLECFGFILANGUAGE_HEADER
#define VEHICLECFGFILANGUAGE_HEADER

class vehiclecfgfi_tclInContext;
class vehiclecfgfi_tclOutContext;
class vehiclecfgfi_tclVisitorBase;

class MY_DECL vehiclecfgfi_tclDescription {
 public:
  enum tenType { EN_PARSING, EN_GENERATING };	
  
  vehiclecfgfi_tclDescription(fi_tclInContext* poIn, vehiclecfgfi_tclVisitorBase* poVisit);
  vehiclecfgfi_tclDescription(fi_tclOutContext* poOut, vehiclecfgfi_tclVisitorBase* poVisit);
  
  /* --Hier kommen nun die Methoden, die einzelne Nachrichten entspr. NaFI 
		erzeugen (EN_GENERATING) bzw. einlesen (EN_PARSING). */

  tBool bInitMessage(vehiclecfgfi_tclToken::tenType enMsgToken);
  tBool bProcessMessage();

  // tBool bProcessElement(); 

  tBool bDoIt(fi_tclVisitableTypeBase& poBaseType);
#ifndef FI_S_EXTERNAL_FI
  void vEnableSpecialBinContainer() { bUseSpecialBinContainer = true; }
#endif

 private:
  /* default constructor */ vehiclecfgfi_tclDescription();  //lint !e1704 // always use parameters
  tenType enType; //--read or write?

  union {
    fi_tclInContext* poInContext;
    fi_tclOutContext* poOutContext;
  };

  vehiclecfgfi_tclVisitorBase* poVisitor;

  // typedef navifi_tclTraversePath::tclKnot tclKnot;

  tBool bUseSpecialBinContainer;  
  
 public:
  
  // --Traversierungspfad
  fi_tclTraversePath<vehiclecfgfi_tclKnot> oPath;
  //   navifi_tclTraversePath oPath;
  fi_tclTraversePath<vehiclecfgfi_tclKnot> oCallStack;
   //  navifi_tclTraversePath oCallStack;
  
};

// --Inline-Implementierungen
inline vehiclecfgfi_tclDescription::vehiclecfgfi_tclDescription(fi_tclInContext* poIn, vehiclecfgfi_tclVisitorBase* poVisit):
  enType(EN_PARSING),poInContext(poIn),poVisitor(poVisit),bUseSpecialBinContainer(false) {}

inline vehiclecfgfi_tclDescription::vehiclecfgfi_tclDescription(fi_tclOutContext* poOut, vehiclecfgfi_tclVisitorBase* poVisit):
  enType(EN_GENERATING),poOutContext(poOut),poVisitor(poVisit),bUseSpecialBinContainer(false) {}

#endif

