#include "precompiled.hh"

tBool vehiclecfgfi_tclDescription::bInitMessage(vehiclecfgfi_tclToken::tenType enMsgToken) {
   tBool bResult = TRUE;
   switch (enMsgToken) {
   case vehiclecfgfi_tclToken::EN_LAST_TOKEN:
   case vehiclecfgfi_tclToken::EN_LIST:
   case vehiclecfgfi_tclToken::EN_END_OF_STRUCT:
   case vehiclecfgfi_tclToken::EN_UNKNOWN:
      bResult=FALSE;   
   break;
      // include the expansions for the messages
   case vehiclecfgfi_tclToken::EN_MSG_VEHICLECONFIGURATIONSTATUS:
   {
      bResult &= oPath.bGoDown(vehiclecfgfi_tclKnot(vehiclecfgfi_tclToken::EN_B8_VEHICLEATTRIBUTES,vehiclecfgfi_tclSemanticDomain::EN_MSG_VEHICLEATTRIBUTES));
      bResult &= oPath.bGoDown(vehiclecfgfi_tclKnot(vehiclecfgfi_tclToken::EN_E8_FUELTYPE,vehiclecfgfi_tclSemanticDomain::EN_MSG_FUELTYPE));
      bResult &= oPath.bGoDown(vehiclecfgfi_tclKnot(vehiclecfgfi_tclToken::EN_U32,vehiclecfgfi_tclSemanticDomain::EN_MSG_CONSUMPTIONCURVE));
      bResult &= oPath.bGoDown(vehiclecfgfi_tclKnot(vehiclecfgfi_tclToken::EN_U32,vehiclecfgfi_tclSemanticDomain::EN_MSG_GEARBOX));
      bResult &= oPath.bGoDown(vehiclecfgfi_tclKnot(vehiclecfgfi_tclToken::EN_U32,vehiclecfgfi_tclSemanticDomain::EN_MSG_ENGINETYPE));
      bResult &= oPath.bGoDown(vehiclecfgfi_tclKnot(vehiclecfgfi_tclToken::EN_U32,vehiclecfgfi_tclSemanticDomain::EN_MSG_VEHICLETYPE));
      bResult &= oPath.bGoDown(vehiclecfgfi_tclKnot(vehiclecfgfi_tclToken::EN_E16_CARMANUFACTURERBRAND,vehiclecfgfi_tclSemanticDomain::EN_MSG_BRAND));
   } break;
   case vehiclecfgfi_tclToken::EN_BINCONTAINER:
   case vehiclecfgfi_tclToken::EN_E8_FUELTYPE:
   case vehiclecfgfi_tclToken::EN_E16_CARMANUFACTURERBRAND:
   case vehiclecfgfi_tclToken::EN_B8_VEHICLEATTRIBUTES:
   case vehiclecfgfi_tclToken::EN_U8:   
   case vehiclecfgfi_tclToken::EN_S8:   
   case vehiclecfgfi_tclToken::EN_U16:   
   case vehiclecfgfi_tclToken::EN_S16:   
   case vehiclecfgfi_tclToken::EN_U24:   
   case vehiclecfgfi_tclToken::EN_S24:   
   case vehiclecfgfi_tclToken::EN_U32:   
   case vehiclecfgfi_tclToken::EN_S32:   
   case vehiclecfgfi_tclToken::EN_U64:   
   case vehiclecfgfi_tclToken::EN_S64:   
   case vehiclecfgfi_tclToken::EN_F32:   
   case vehiclecfgfi_tclToken::EN_F64:   
   case vehiclecfgfi_tclToken::EN_BOOL:   
   case vehiclecfgfi_tclToken::EN_STRING:   
   case vehiclecfgfi_tclToken::EN_MULTILANGUAGESTRING:   
   default:
      oPath.bGoDown(vehiclecfgfi_tclKnot(enMsgToken,vehiclecfgfi_tclSemanticDomain::EN_UNKNOWN));
      bResult = TRUE;
   }	
   return bResult;
}

tBool vehiclecfgfi_tclDescription::bDoIt(fi_tclVisitableTypeBase& oTypeBase)
{
   // --read or write?
   if (enType==EN_PARSING)
   {
     // --read first, then pass visitor
     (*poInContext) >> oTypeBase;
     oTypeBase.vTakeVisitor(*poVisitor);
   }
   else
   {
     // --first pass visitor, then stream 
	 oTypeBase.vTakeVisitor(*poVisitor);
     (*poOutContext) << oTypeBase;
   }
   return poVisitor->bIsValid();
}

tBool vehiclecfgfi_tclDescription::bProcessMessage() {
   tBool bResult = TRUE;
   tBool bInsideBinContainerVersion = false;
   tU16 u16MajorVersion;
   if (enType == EN_GENERATING)
   {
      u16MajorVersion = poOutContext->u16GetMajorVersion();
   }
   else
   {
      u16MajorVersion = poInContext->u16GetMajorVersion();
   }
   if (u16MajorVersion > 0x8000)
   {
      return FALSE;
   }
   tU16 u16SavedMajorVersion = u16MajorVersion;
   poVisitor->vReleaseBreak();
   while ((oPath.u32Position>0) && 
      bResult &&
      !poVisitor->bBreak() )    {
      // get current context (name, type, list index of next element)
      vehiclecfgfi_tclKnot oKnot = oPath.oGetIterator().oKnot();
      vehiclecfgfi_tclSemanticDomain::tenType enSemanticDomain = oKnot.enSemanticDomain;
      vehiclecfgfi_tclToken::tenType enToken = oKnot.enToken;
      tU32 u32Index = oKnot.u32Index;
      
      // lists need special handling
      if (enSemanticDomain == vehiclecfgfi_tclSemanticDomain::EN_LIST_ELEMENT) {
         oPath.bGoUp();
         // has list remaining elements?
         if (u32Index < oPath.oGetIterator().oKnot().u32Index) {
            // create next list element
            oPath.bGoDown(vehiclecfgfi_tclKnot(enToken,enSemanticDomain,u32Index+1));
            oPath.bGoDown(vehiclecfgfi_tclKnot(enToken,enSemanticDomain,u32Index));
         } else {
            // remove list, clean up
            oPath.bGoUp();
            oCallStack.bGoUp();
            continue;	
         }
      }
      // push current context on stack for visitor
      oCallStack.bGoDown(vehiclecfgfi_tclKnot(enToken,enSemanticDomain,u32Index));
      poVisitor->oIterator=oCallStack.oGetIterator();
      
      // now, process element
      switch (enToken) {
      case vehiclecfgfi_tclToken::EN_END_OF_STRUCT: 
      {
         // clean up after structures
         if (enSemanticDomain == vehiclecfgfi_tclSemanticDomain::EN_BINCONTAINER)
         {
            u16MajorVersion = u16SavedMajorVersion;
            if (enType == EN_GENERATING)
            {
               poOutContext->u16SetMajorVersion(u16MajorVersion);
            }
            else
            {
               poInContext->u16SetMajorVersion(u16MajorVersion);
            }
         }
         oPath.bGoUp();
         oCallStack.bGoUp();
         oCallStack.bGoUp();
      } break;
      case vehiclecfgfi_tclToken::EN_LIST: 
      {
         fi_tclList oList;
         // get list size
         if (!bDoIt(oList)) {
            // rearrange LIST and LIST_ELEMENT knots
            // pop "old" LIST knot
            oPath.bGoUp();
            // pop and backup LIST_ELEMENT knot
            vehiclecfgfi_tclKnot saveKnot;
            oPath.bGoUp(saveKnot);
            // push LIST knot
            oPath.bGoDown(vehiclecfgfi_tclKnot(enToken,enSemanticDomain,oList.u32ListSize));
            // push LIST_ELEMENT knot
            oPath.bGoDown(saveKnot);
            return FALSE;
         } else {
            // rearrange LIST and LIST_ELEMENT knots
            // pop "old" LIST knot
            oPath.bGoUp();
            // pop and backup LIST_ELEMENT knot
            vehiclecfgfi_tclKnot saveKnot;
            oPath.bGoUp(saveKnot);
            // push LIST knot
            oPath.bGoDown(vehiclecfgfi_tclKnot(enToken,enSemanticDomain,oList.u32ListSize));
            // push LIST_ELEMENT knot
            oPath.bGoDown(saveKnot);
         }
      } break;
      case vehiclecfgfi_tclToken::EN_U8: 
      {
         fi_tclU8 oU8;
         if (!bDoIt(oU8))
            return FALSE;
         oCallStack.bGoUp();
         oPath.bGoUp();
         if (bInsideBinContainerVersion)
         {
            bInsideBinContainerVersion = false;
            u16SavedMajorVersion = u16MajorVersion;
            u16MajorVersion = oU8.u8Value;
            if (enType == EN_GENERATING)
            {
               poOutContext->u16SetMajorVersion(u16MajorVersion);
            }
            else
            {
               poInContext->u16SetMajorVersion(u16MajorVersion);
            }
         }
      } break;
      case vehiclecfgfi_tclToken::EN_U16: 
      {
         fi_tclU16 oU16;
         if (!bDoIt(oU16))
            return FALSE;
         oCallStack.bGoUp();
         oPath.bGoUp();
      } break;
      case vehiclecfgfi_tclToken::EN_U24: 
      {
         fi_tclU24 oU24;
         if (!bDoIt(oU24))
            return FALSE;
         oCallStack.bGoUp();
         oPath.bGoUp();
      } break;
      case vehiclecfgfi_tclToken::EN_U32: 
      {
         fi_tclU32 oU32;
         if (!bDoIt(oU32))
            return FALSE;
         oCallStack.bGoUp();
         oPath.bGoUp();
      } break;
      case vehiclecfgfi_tclToken::EN_U64: 
      {
         fi_tclU64 oU64;
         if (!bDoIt(oU64))
            return FALSE;
         oCallStack.bGoUp();
         oPath.bGoUp();
      } break;
      case vehiclecfgfi_tclToken::EN_S8: 
      {
         fi_tclS8 oS8;
         if (!bDoIt(oS8))
            return FALSE;
         oCallStack.bGoUp();
         oPath.bGoUp();
      } break;
      case vehiclecfgfi_tclToken::EN_S16: 
      {
         fi_tclS16 oS16;
         if (!bDoIt(oS16))
            return FALSE;
         oCallStack.bGoUp();
         oPath.bGoUp();
      } break;
      case vehiclecfgfi_tclToken::EN_S24: 
      {
         fi_tclS24 oS24;
         if (!bDoIt(oS24))
            return FALSE;
         oCallStack.bGoUp();
         oPath.bGoUp();
      } break;
      case vehiclecfgfi_tclToken::EN_S32: 
      {
         fi_tclS32 oS32;
         if (!bDoIt(oS32))
            return FALSE;
         oCallStack.bGoUp();
         oPath.bGoUp();
      } break;
      case vehiclecfgfi_tclToken::EN_S64: 
      {
         fi_tclS64 oS64;
         if (!bDoIt(oS64))
            return FALSE;
         oCallStack.bGoUp();
         oPath.bGoUp();
      } break;
      case vehiclecfgfi_tclToken::EN_F32: 
      {
         fi_tclF32 oF32;
         if (!bDoIt(oF32))
            return FALSE;
         oCallStack.bGoUp();
         oPath.bGoUp();
      } break;
      case vehiclecfgfi_tclToken::EN_F64: 
      {
         fi_tclF64 oF64;
         if (!bDoIt(oF64))
            return FALSE;
         oCallStack.bGoUp();
         oPath.bGoUp();
      } break;
      case vehiclecfgfi_tclToken::EN_BOOL: 
      {
         fi_tclBool oBool;
         if (!bDoIt(oBool))
            return FALSE;
         oCallStack.bGoUp();
         oPath.bGoUp();
      } break;
      case vehiclecfgfi_tclToken::EN_STRING: 
      {
         fi_tclString oString;
         if (!bDoIt(oString)) {
            oString.vDestroy();
            return FALSE;
         }
         oString.vDestroy();
         oCallStack.bGoUp();
         oPath.bGoUp();
      } break;
      case vehiclecfgfi_tclToken::EN_MULTILANGUAGESTRING: 
      {
         fi_tclMultiLanguageString oString;
         if (!bDoIt(oString)) {
            oString.vDestroy();
            return FALSE;
         }
         oString.vDestroy();
         oCallStack.bGoUp();
         oPath.bGoUp();
      } break;
      // include rest of type expansions/processing
   case vehiclecfgfi_tclToken::EN_MSG_VEHICLECONFIGURATIONUPREG:
   case vehiclecfgfi_tclToken::EN_MSG_VEHICLECONFIGURATIONRELUPREG:
   case vehiclecfgfi_tclToken::EN_MSG_VEHICLECONFIGURATIONGET:
   case vehiclecfgfi_tclToken::EN_MSG_VEHICLECONFIGURATIONSTATUS:
      bInitMessage(enToken);
      break;
   case vehiclecfgfi_tclToken::EN_BINCONTAINER:
   {
      if (poVisitor->bDoExpand_BinContainer(enSemanticDomain))
      {
         oPath.bGoUp();
         oPath.bGoDown(vehiclecfgfi_tclKnot(vehiclecfgfi_tclToken::EN_END_OF_STRUCT,vehiclecfgfi_tclSemanticDomain::EN_UNKNOWN));
         oPath.bGoDown(vehiclecfgfi_tclKnot(vehiclecfgfi_tclToken::EN_U8,vehiclecfgfi_tclSemanticDomain::EN_LIST_ELEMENT,0));
         oPath.bGoDown(vehiclecfgfi_tclKnot(vehiclecfgfi_tclToken::EN_LIST,vehiclecfgfi_tclSemanticDomain::EN_CONTAINERDATALIST));
      }
      else
      {
         fi_tcl_BinContainer o_BinContainer;
         if (!bDoIt(o_BinContainer))
         {
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
            o_BinContainer.vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
            return FALSE;
         }
         else
         {
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
            o_BinContainer.vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
            oCallStack.bGoUp();
            oPath.bGoUp();
         }
      }
   } break;
   case vehiclecfgfi_tclToken::EN_E8_FUELTYPE:
   {
      fi_tcl_e8_FuelType o_e8_FuelType;
      if (!bDoIt(o_e8_FuelType))
         return FALSE;
      oCallStack.bGoUp();
      oPath.bGoUp();
   } break;
   case vehiclecfgfi_tclToken::EN_E16_CARMANUFACTURERBRAND:
   {
      fi_tcl_e16_CarManufacturerBrand o_e16_CarManufacturerBrand;
      if (!bDoIt(o_e16_CarManufacturerBrand))
         return FALSE;
      oCallStack.bGoUp();
      oPath.bGoUp();
   } break;
   case vehiclecfgfi_tclToken::EN_B8_VEHICLEATTRIBUTES:
   {
      fi_tcl_b8_VehicleAttributes o_b8_VehicleAttributes;
      if (!bDoIt(o_b8_VehicleAttributes))
         return FALSE;
      oCallStack.bGoUp();
      oPath.bGoUp();
   } break;
      case vehiclecfgfi_tclToken::EN_UNKNOWN:
      case vehiclecfgfi_tclToken::EN_LAST_TOKEN:         
      default:
         return FALSE;
      }
  }
  return bResult;
}

