#ifndef FIVISITOR_HEADER
#define FIVISITOR_HEADER

// --Basisklasse fuer eine FI-Besucher-Klasse

class fi_tclOutput {
public:
   fi_tclOutput();
   virtual ~fi_tclOutput(){};

   virtual tVoid vPrintLine(tCString coszLine) = 0;
};

class fi_tclFileOutput : public fi_tclOutput 
{
public:
   fi_tclFileOutput(OSAL_tIODescriptor rIOD):fd(rIOD) {}
   virtual tVoid vPrintLine(tCString coszLine);
protected:
   OSAL_tIODescriptor fd;
private:
   fi_tclFileOutput(); //lint !e1704
   fi_tclFileOutput& operator=(const fi_tclFileOutput& coRef);
   fi_tclFileOutput(const fi_tclFileOutput& coRef); //lint !e1704
};

class fi_tclMemOutput : public fi_tclOutput
{
public:
   fi_tclMemOutput(tU32 u32MemSize);
   virtual ~fi_tclMemOutput();
   virtual tVoid vPrintLine(tCString coszLine);
   tString szGetBuffer();
protected:
   tChar* szBuf;
   tChar* szEndBuf;
   tChar* s8BufPos;
private:
   fi_tclMemOutput(); //lint !e1704
   fi_tclMemOutput(const fi_tclMemOutput& coRef); //lint !e1704
   fi_tclMemOutput& operator=(const fi_tclMemOutput& coRef); //lint !e1704
};

class MY_DECL fi_tclVisitorBase {
public:

   // --Konstruktor
   fi_tclVisitorBase():bBreakNow(FALSE),bIsVisitorValid(FALSE) {}
   virtual ~fi_tclVisitorBase() {}

   tBool bIsValid() const { return bIsVisitorValid; }
   tVoid vInvalidate() { bIsVisitorValid=FALSE; }
   tVoid vValidate() { bIsVisitorValid=TRUE; }
   tBool bBreak() const { return bBreakNow; }
   tVoid vReleaseBreak() { bBreakNow = FALSE; }
   // --Besuche allgemeine Objekte	
   virtual tVoid vVisitU8(fi_tclU8& oU8);
   virtual tVoid vVisitS8(fi_tclS8& oS8);
   virtual tVoid vVisitU16(fi_tclU16& oU16);
   virtual tVoid vVisitS16(fi_tclS16& oS16);
   virtual tVoid vVisitU24(fi_tclU24& oU24);
   virtual tVoid vVisitS24(fi_tclS24& oS24);
   virtual tVoid vVisitU32(fi_tclU32& oU32);
   virtual tVoid vVisitS32(fi_tclS32& oS32);
   virtual tVoid vVisitU64(fi_tclU64& oU64);
   virtual tVoid vVisitS64(fi_tclS64& oS64);
   virtual tVoid vVisitF32(fi_tclF32& oF32);
   virtual tVoid vVisitF64(fi_tclF64& oF64);
   virtual tVoid vVisitBool(fi_tclBool& oBool);
   virtual tVoid vVisitString(fi_tclString& oString);
   virtual tVoid vVisitMultiLanguageString(fi_tclMultiLanguageString& oString);

   virtual tVoid vVisitList(fi_tclList& oList);
   virtual tVoid vVisit_e8_Status(fi_tcl_e8_Status& oe8_Status);

   virtual tVoid vVisit_e8_TypeOfFile(fi_tcl_e8_TypeOfFile& oe8_TypeOfFile);

   virtual tVoid vVisit_FileContents(fi_tcl_FileContents& oFileContents);

   virtual tVoid vVisit_Directory(fi_tcl_Directory& oDirectory);

   virtual tVoid vVisit_UTUInt(fi_tcl_UTUInt& oUTUInt);

   virtual tVoid vVisit_UTListModel(fi_tcl_UTListModel& oUTListModel);

   virtual tVoid vVisit_UTListSelectionModel(fi_tcl_UTListSelectionModel& oUTListSelectionModel);

   virtual tVoid vVisit_UTMessage(fi_tcl_UTMessage& oUTMessage);

   virtual tVoid vVisit_UTCCAMessage(fi_tcl_UTCCAMessage& oUTCCAMessage);

   virtual tVoid vVisit_UTAction(fi_tcl_UTAction& oUTAction);

   virtual tVoid vVisit_e8_DevNotification(fi_tcl_e8_DevNotification& oe8_DevNotification);

   virtual tVoid vVisit_e8_DapMemType(fi_tcl_e8_DapMemType& oe8_DapMemType);

   virtual tVoid vVisit_MemBlockDesc(fi_tcl_MemBlockDesc& oMemBlockDesc);

   virtual tVoid vVisit_PathFilename(fi_tcl_PathFilename& oPathFilename);

   virtual tVoid vVisit_DapPhysicalAddress(fi_tcl_DapPhysicalAddress& oDapPhysicalAddress);

   virtual tVoid vVisit_DapPhysicalBlockAddress(fi_tcl_DapPhysicalBlockAddress& oDapPhysicalBlockAddress);

   virtual tVoid vVisit_DapPhysicalBlockListElem(fi_tcl_DapPhysicalBlockListElem& oDapPhysicalBlockListElem);

   virtual tVoid vVisit_DapComplexPhysicalBlockAddress(fi_tcl_DapComplexPhysicalBlockAddress& oDapComplexPhysicalBlockAddress);

   virtual tVoid vVisit_e8_DapDeviceError(fi_tcl_e8_DapDeviceError& oe8_DapDeviceError);

   virtual tVoid vVisit_e8_DapDataAvailable(fi_tcl_e8_DapDataAvailable& oe8_DapDataAvailable);

   virtual tVoid vVisit_e8_DapMediaType(fi_tcl_e8_DapMediaType& oe8_DapMediaType);

   virtual tVoid vVisit_FileCopy(fi_tcl_FileCopy& oFileCopy);

   virtual tVoid vVisit_DapRegionDescr(fi_tcl_DapRegionDescr& oDapRegionDescr);

   virtual tVoid vVisit_e8_UserID(fi_tcl_e8_UserID& oe8_UserID);

   virtual tVoid vVisit_b8_InputContinuation(fi_tcl_b8_InputContinuation& ob8_InputContinuation);

   virtual tVoid vVisit_e16_SelectionCriterionType(fi_tcl_e16_SelectionCriterionType& oe16_SelectionCriterionType);

   virtual tVoid vVisit_b8_SelectionCriteriaMask(fi_tcl_b8_SelectionCriteriaMask& ob8_SelectionCriteriaMask);

   virtual tVoid vVisit_b8_RefinementCriteriaMask(fi_tcl_b8_RefinementCriteriaMask& ob8_RefinementCriteriaMask);

   virtual tVoid vVisit_ObjectDescription(fi_tcl_ObjectDescription& oObjectDescription);

   virtual tVoid vVisit_s32_Longitude(fi_tcl_s32_Longitude& os32_Longitude);

   virtual tVoid vVisit_b8_NavBinProperties(fi_tcl_b8_NavBinProperties& ob8_NavBinProperties);

   virtual tVoid vVisit_ClusterId(fi_tcl_ClusterId& oClusterId);

   virtual tVoid vVisit_b8_CellProperties(fi_tcl_b8_CellProperties& ob8_CellProperties);

   virtual tVoid vVisit_Cell(fi_tcl_Cell& oCell);

   virtual tVoid vVisit_ClusterInfo(fi_tcl_ClusterInfo& oClusterInfo);

   virtual tVoid vVisit_e8_DetailType(fi_tcl_e8_DetailType& oe8_DetailType);

   virtual tVoid vVisit_ObjectDetail(fi_tcl_ObjectDetail& oObjectDetail);

   virtual tVoid vVisit_b8_ResolutionType(fi_tcl_b8_ResolutionType& ob8_ResolutionType);

   virtual tVoid vVisit_b8_DataSetProperties(fi_tcl_b8_DataSetProperties& ob8_DataSetProperties);

   virtual tVoid vVisit_DataSetElement(fi_tcl_DataSetElement& oDataSetElement);

   virtual tVoid vVisit_e16_POIType(fi_tcl_e16_POIType& oe16_POIType);

   virtual tVoid vVisit_b16_POIType(fi_tcl_b16_POIType& ob16_POIType);

   virtual tVoid vVisit_e8_POIDataset(fi_tcl_e8_POIDataset& oe8_POIDataset);

   virtual tVoid vVisit_s32_Latitude(fi_tcl_s32_Latitude& os32_Latitude);

   virtual tVoid vVisit_PositionWGS84(fi_tcl_PositionWGS84& oPositionWGS84);

   virtual tVoid vVisit_IndexCatBrand(fi_tcl_IndexCatBrand& oIndexCatBrand);

   virtual tVoid vVisit_MapIdPair(fi_tcl_MapIdPair& oMapIdPair);

   virtual tVoid vVisit_DataBlockStartInfo(fi_tcl_DataBlockStartInfo& oDataBlockStartInfo);

   virtual tVoid vVisit_DataBlockResultInfo(fi_tcl_DataBlockResultInfo& oDataBlockResultInfo);

   virtual tVoid vVisit_e8_StorageMode(fi_tcl_e8_StorageMode& oe8_StorageMode);

   virtual tVoid vVisit_e8_ResumeType(fi_tcl_e8_ResumeType& oe8_ResumeType);

   virtual tVoid vVisit_e8_StoreStatus(fi_tcl_e8_StoreStatus& oe8_StoreStatus);

   virtual tVoid vVisit_e8_ProgressStatus(fi_tcl_e8_ProgressStatus& oe8_ProgressStatus);

   virtual tVoid vVisit_RegionNumberOrder(fi_tcl_RegionNumberOrder& oRegionNumberOrder);

   virtual tVoid vVisit_RegionNumberResult(fi_tcl_RegionNumberResult& oRegionNumberResult);

   virtual tVoid vVisit_RegionInfo(fi_tcl_RegionInfo& oRegionInfo);

   virtual tVoid vVisit_RegionOutline(fi_tcl_RegionOutline& oRegionOutline);

   virtual tVoid vVisit_e8_DapAccessMode(fi_tcl_e8_DapAccessMode& oe8_DapAccessMode);

   virtual tVoid vVisit_DapDeviceStatusInfo(fi_tcl_DapDeviceStatusInfo& oDapDeviceStatusInfo);

   virtual tVoid vVisit_e8_DapWriteProt(fi_tcl_e8_DapWriteProt& oe8_DapWriteProt);

   virtual tVoid vVisit_DapVirtualMediaInfo(fi_tcl_DapVirtualMediaInfo& oDapVirtualMediaInfo);

   virtual tVoid vVisit_e16_DapFileType(fi_tcl_e16_DapFileType& oe16_DapFileType);

   virtual tVoid vVisit_e16_DapNumberRepr(fi_tcl_e16_DapNumberRepr& oe16_DapNumberRepr);

   virtual tVoid vVisit_DapDeviceInfo(fi_tcl_DapDeviceInfo& oDapDeviceInfo);

   virtual tVoid vVisit_DapFileType(fi_tcl_DapFileType& oDapFileType);

   virtual tVoid vVisit_DapCodePageDescr(fi_tcl_DapCodePageDescr& oDapCodePageDescr);

   virtual tVoid vVisit_DapLanguageDescr(fi_tcl_DapLanguageDescr& oDapLanguageDescr);

   virtual tVoid vVisit_DevMediaInfo(fi_tcl_DevMediaInfo& oDevMediaInfo);

   virtual tVoid vVisit_DapMediaInfo(fi_tcl_DapMediaInfo& oDapMediaInfo);

   virtual tVoid vVisit_e8_DapDataType(fi_tcl_e8_DapDataType& oe8_DapDataType);

   virtual tVoid vVisit_DapDataSetInfo(fi_tcl_DapDataSetInfo& oDapDataSetInfo);

   virtual tVoid vVisit_DapDefaultControl(fi_tcl_DapDefaultControl& oDapDefaultControl);

   virtual tVoid vVisit_DapRegionMetaInfo(fi_tcl_DapRegionMetaInfo& oDapRegionMetaInfo);

   virtual tVoid vVisit_DapProfileMetaInfo(fi_tcl_DapProfileMetaInfo& oDapProfileMetaInfo);

   virtual tVoid vVisit_DapRegionDescription(fi_tcl_DapRegionDescription& oDapRegionDescription);

   virtual tVoid vVisit_b8_StructureType(fi_tcl_b8_StructureType& ob8_StructureType);

   virtual tVoid vVisit_e32_RNWExtensionType(fi_tcl_e32_RNWExtensionType& oe32_RNWExtensionType);

   virtual tVoid vVisit_e8_RNWDataUsageState(fi_tcl_e8_RNWDataUsageState& oe8_RNWDataUsageState);

   virtual tVoid vVisit_MemPos(fi_tcl_MemPos& oMemPos);

   virtual tVoid vVisit_StructureReference(fi_tcl_StructureReference& oStructureReference);

   virtual tVoid vVisit_NavClusterId(fi_tcl_NavClusterId& oNavClusterId);

   virtual tVoid vVisit_ClusterResultInfo(fi_tcl_ClusterResultInfo& oClusterResultInfo);

   virtual tVoid vVisit_RNWDataStorageInfo(fi_tcl_RNWDataStorageInfo& oRNWDataStorageInfo);

   virtual tVoid vVisit_e8_LocClass(fi_tcl_e8_LocClass& oe8_LocClass);

   virtual tVoid vVisit_e8_CarriageWay(fi_tcl_e8_CarriageWay& oe8_CarriageWay);

   virtual tVoid vVisit_e8_TrafficFlow(fi_tcl_e8_TrafficFlow& oe8_TrafficFlow);

   virtual tVoid vVisit_e8_FollowDirection(fi_tcl_e8_FollowDirection& oe8_FollowDirection);

   virtual tVoid vVisit_LocTableIdent(fi_tcl_LocTableIdent& oLocTableIdent);

   virtual tVoid vVisit_Outline(fi_tcl_Outline& oOutline);

   virtual tVoid vVisit_e16_ISOCountryCode(fi_tcl_e16_ISOCountryCode& oe16_ISOCountryCode);

   virtual tVoid vVisit_e16_ISOLanguageCode(fi_tcl_e16_ISOLanguageCode& oe16_ISOLanguageCode);

   virtual tVoid vVisit_PrefixElem(fi_tcl_PrefixElem& oPrefixElem);

   virtual tVoid vVisit_PrefixTable(fi_tcl_PrefixTable& oPrefixTable);

   virtual tVoid vVisit_e8_DapPrioritaet(fi_tcl_e8_DapPrioritaet& oe8_DapPrioritaet);

   virtual tVoid vVisit_e8_DapOrderType(fi_tcl_e8_DapOrderType& oe8_DapOrderType);

   virtual tVoid vVisit_u32_DapContainerSize(fi_tcl_u32_DapContainerSize& ou32_DapContainerSize);

   virtual tVoid vVisit_DapDataTypeInfo(fi_tcl_DapDataTypeInfo& oDapDataTypeInfo);

   virtual tVoid vVisit_u32_DataSpace(fi_tcl_u32_DataSpace& ou32_DataSpace);

   virtual tVoid vVisit_DapDataInfo(fi_tcl_DapDataInfo& oDapDataInfo);

   virtual tVoid vVisit_ClusterStartInfo(fi_tcl_ClusterStartInfo& oClusterStartInfo);

   virtual tVoid vVisit_LocalOneCellID(fi_tcl_LocalOneCellID& oLocalOneCellID);

   virtual tVoid vVisit_BBox(fi_tcl_BBox& oBBox);

   virtual tVoid vVisit_RegProfOutline(fi_tcl_RegProfOutline& oRegProfOutline);

   virtual tVoid vVisit_DapPrefixDesc(fi_tcl_DapPrefixDesc& oDapPrefixDesc);

   virtual tVoid vVisit_DapPrefixState(fi_tcl_DapPrefixState& oDapPrefixState);

   virtual tVoid vVisit_e8_TransferType(fi_tcl_e8_TransferType& oe8_TransferType);

   virtual tVoid vVisit_e8_CoordinateCoding(fi_tcl_e8_CoordinateCoding& oe8_CoordinateCoding);

   virtual tVoid vVisit_e16_DataType(fi_tcl_e16_DataType& oe16_DataType);

   virtual tVoid vVisit_UniqueID(fi_tcl_UniqueID& oUniqueID);

   virtual tVoid vVisit_MapScale(fi_tcl_MapScale& oMapScale);

   virtual tVoid vVisit_BoundingBox(fi_tcl_BoundingBox& oBoundingBox);

   virtual tVoid vVisit_ResultBlocks(fi_tcl_ResultBlocks& oResultBlocks);

   virtual tVoid vVisit_e8_RequestType(fi_tcl_e8_RequestType& oe8_RequestType);

   virtual tVoid vVisit_e16_OneCellIndex(fi_tcl_e16_OneCellIndex& oe16_OneCellIndex);

   virtual tVoid vVisit_e8_NavOneCellDirection(fi_tcl_e8_NavOneCellDirection& oe8_NavOneCellDirection);

   virtual tVoid vVisit_OneCellRelation(fi_tcl_OneCellRelation& oOneCellRelation);

   virtual tVoid vVisit_e8_Amenity(fi_tcl_e8_Amenity& oe8_Amenity);

   virtual tVoid vVisit_Amenity(fi_tcl_Amenity& oAmenity);

   virtual tVoid vVisit_e8_FileType(fi_tcl_e8_FileType& oe8_FileType);

   virtual tVoid vVisit_DapRegionDescrList(fi_tcl_DapRegionDescrList& oDapRegionDescrList);

   virtual tVoid vVisit_CatalogueFiles(fi_tcl_CatalogueFiles& oCatalogueFiles);

   virtual tVoid vVisit_UTInt(fi_tcl_UTInt& oUTInt);

   virtual tVoid vVisit_UTBool(fi_tcl_UTBool& oUTBool);

   virtual tVoid vVisit_UTString(fi_tcl_UTString& oUTString);

   virtual tVoid vVisit_OrderInfo(fi_tcl_OrderInfo& oOrderInfo);

   virtual tVoid vVisit_BinContainer(fi_tcl_BinContainer& oBinContainer);

   virtual tVoid vVisit_Reserved(fi_tcl_Reserved& oReserved);

   virtual tVoid vVisit_u8_Percent(fi_tcl_u8_Percent& ou8_Percent);

   virtual tVoid vVisit_s16_PerThousand(fi_tcl_s16_PerThousand& os16_PerThousand);

   virtual tVoid vVisit_u16_IndexInReferenceList(fi_tcl_u16_IndexInReferenceList& ou16_IndexInReferenceList);

   virtual tVoid vVisit_u16_ErrorCode(fi_tcl_u16_ErrorCode& ou16_ErrorCode);

   virtual tVoid vVisit_u16_RPM(fi_tcl_u16_RPM& ou16_RPM);

   virtual tVoid vVisit_s32_Kilogram(fi_tcl_s32_Kilogram& os32_Kilogram);

   virtual tVoid vVisit_s32_Pound(fi_tcl_s32_Pound& os32_Pound);

   virtual tVoid vVisit_s16_Meter(fi_tcl_s16_Meter& os16_Meter);

   virtual tVoid vVisit_s32_Meter(fi_tcl_s32_Meter& os32_Meter);

   virtual tVoid vVisit_s32_Yards(fi_tcl_s32_Yards& os32_Yards);

   virtual tVoid vVisit_s32_Foot(fi_tcl_s32_Foot& os32_Foot);

   virtual tVoid vVisit_s32_Centimeter(fi_tcl_s32_Centimeter& os32_Centimeter);

   virtual tVoid vVisit_s32_Inch(fi_tcl_s32_Inch& os32_Inch);

   virtual tVoid vVisit_s32_Millimeter(fi_tcl_s32_Millimeter& os32_Millimeter);

   virtual tVoid vVisit_s32_Microliter(fi_tcl_s32_Microliter& os32_Microliter);

   virtual tVoid vVisit_s32_Second(fi_tcl_s32_Second& os32_Second);

   virtual tVoid vVisit_u16_MilliSecond(fi_tcl_u16_MilliSecond& ou16_MilliSecond);

   virtual tVoid vVisit_s32_MilliSecond(fi_tcl_s32_MilliSecond& os32_MilliSecond);

   virtual tVoid vVisit_POSIXTime(fi_tcl_POSIXTime& oPOSIXTime);

   virtual tVoid vVisit_e8_DST_State(fi_tcl_e8_DST_State& oe8_DST_State);

   virtual tVoid vVisit_TimeZoneElement(fi_tcl_TimeZoneElement& oTimeZoneElement);

   virtual tVoid vVisit_s16_KmPerHour(fi_tcl_s16_KmPerHour& os16_KmPerHour);

   virtual tVoid vVisit_s16_MilesPerHour(fi_tcl_s16_MilesPerHour& os16_MilesPerHour);

   virtual tVoid vVisit_s16_Knot(fi_tcl_s16_Knot& os16_Knot);

   virtual tVoid vVisit_s16_CentimeterSecond(fi_tcl_s16_CentimeterSecond& os16_CentimeterSecond);

   virtual tVoid vVisit_s16_Kelvin(fi_tcl_s16_Kelvin& os16_Kelvin);

   virtual tVoid vVisit_s16_Fahrenheit(fi_tcl_s16_Fahrenheit& os16_Fahrenheit);

   virtual tVoid vVisit_s32_Pascal(fi_tcl_s32_Pascal& os32_Pascal);

   virtual tVoid vVisit_s32_Watt(fi_tcl_s32_Watt& os32_Watt);

   virtual tVoid vVisit_FIVersion(fi_tcl_FIVersion& oFIVersion);

   virtual tVoid vVisit_UserPOIElement(fi_tcl_UserPOIElement& oUserPOIElement);

   virtual tVoid vVisit_LocTableDesc(fi_tcl_LocTableDesc& oLocTableDesc);

   virtual tVoid vVisit_b16_ElementProperties(fi_tcl_b16_ElementProperties& ob16_ElementProperties);

   virtual tVoid vVisit_RectangleWGS84(fi_tcl_RectangleWGS84& oRectangleWGS84);

   virtual tVoid vVisit_LanguageDependentType(fi_tcl_LanguageDependentType& oLanguageDependentType);

   virtual tVoid vVisit_LanguageIdElem(fi_tcl_LanguageIdElem& oLanguageIdElem);

   virtual tVoid vVisit_LanguageID(fi_tcl_LanguageID& oLanguageID);

   virtual tVoid vVisit_u8_DirectionAbsolute(fi_tcl_u8_DirectionAbsolute& ou8_DirectionAbsolute);

   virtual tVoid vVisit_u8_DirectionRelative(fi_tcl_u8_DirectionRelative& ou8_DirectionRelative);

   virtual tVoid vVisit_s16_CentiDegree(fi_tcl_s16_CentiDegree& os16_CentiDegree);

   virtual tVoid vVisit_s16_Degree(fi_tcl_s16_Degree& os16_Degree);

   virtual tVoid vVisit_u16_DirectionAbsolute_CentiDegree(fi_tcl_u16_DirectionAbsolute_CentiDegree& ou16_DirectionAbsolute_CentiDegree);

   virtual tVoid vVisit_s16_DirectionRelative_CentiDegree(fi_tcl_s16_DirectionRelative_CentiDegree& os16_DirectionRelative_CentiDegree);

   virtual tVoid vVisit_e8_FuelType(fi_tcl_e8_FuelType& oe8_FuelType);

   virtual tVoid vVisit_DistTimeFuel(fi_tcl_DistTimeFuel& oDistTimeFuel);

   virtual tVoid vVisit_e8_BinContainerTypes(fi_tcl_e8_BinContainerTypes& oe8_BinContainerTypes);

   virtual tVoid vVisit_State(fi_tcl_State& oState);

   virtual tVoid vVisit_e8_FuelAge(fi_tcl_e8_FuelAge& oe8_FuelAge);

   virtual tVoid vVisit_FuelTypeCode(fi_tcl_FuelTypeCode& oFuelTypeCode);

   virtual tVoid vVisit_RegionId(fi_tcl_RegionId& oRegionId);

   virtual tVoid vVisit_FuelAge(fi_tcl_FuelAge& oFuelAge);

   virtual tVoid vVisit_FuelPrice(fi_tcl_FuelPrice& oFuelPrice);

   virtual tVoid vVisit_FuelStationId(fi_tcl_FuelStationId& oFuelStationId);

   virtual tVoid vVisit_FuelType(fi_tcl_FuelType& oFuelType);

   virtual tVoid vVisit_FuelStation(fi_tcl_FuelStation& oFuelStation);

   virtual tVoid vVisit_FuelStationPrices(fi_tcl_FuelStationPrices& oFuelStationPrices);

   virtual tVoid vVisit_StationFuelTypes(fi_tcl_StationFuelTypes& oStationFuelTypes);

   virtual tVoid vVisit_b16_StationDescriptionRequest(fi_tcl_b16_StationDescriptionRequest& ob16_StationDescriptionRequest);

   virtual tVoid vVisit_FuelStationInfo(fi_tcl_FuelStationInfo& oFuelStationInfo);

   virtual tVoid vVisit_FuelStationPricesForPosition(fi_tcl_FuelStationPricesForPosition& oFuelStationPricesForPosition);

   virtual tVoid vVisit_UpdateId(fi_tcl_UpdateId& oUpdateId);

   virtual tVoid vVisit_e8_SXMFuelType(fi_tcl_e8_SXMFuelType& oe8_SXMFuelType);

   virtual tVoid vVisit_e8_RoadClassCode(fi_tcl_e8_RoadClassCode& oe8_RoadClassCode);

   virtual tVoid vVisit_TMOneCellPortion(fi_tcl_TMOneCellPortion& oTMOneCellPortion);

   virtual tVoid vVisit_NavClusterDesc(fi_tcl_NavClusterDesc& oNavClusterDesc);

   virtual tVoid vVisit_b8_TMCIntersectionPath(fi_tcl_b8_TMCIntersectionPath& ob8_TMCIntersectionPath);

   virtual tVoid vVisit_e8_TMCIntersectionPathType(fi_tcl_e8_TMCIntersectionPathType& oe8_TMCIntersectionPathType);

   virtual tVoid vVisit_NavOneCellDesc(fi_tcl_NavOneCellDesc& oNavOneCellDesc);

   virtual tVoid vVisit_TMIntersectionMatrix(fi_tcl_TMIntersectionMatrix& oTMIntersectionMatrix);

   virtual tVoid vVisit_s16_EMU(fi_tcl_s16_EMU& os16_EMU);

   virtual tVoid vVisit_s32_MEMU(fi_tcl_s32_MEMU& os32_MEMU);

   virtual tVoid vVisit_s16_MEMUSecond(fi_tcl_s16_MEMUSecond& os16_MEMUSecond);

   virtual tVoid vVisit_s16_EAU(fi_tcl_s16_EAU& os16_EAU);

   virtual tVoid vVisit_NavPlainPathListSet(fi_tcl_NavPlainPathListSet& oNavPlainPathListSet);

   virtual tVoid vVisit_s32_EMU(fi_tcl_s32_EMU& os32_EMU);

   virtual tVoid vVisit_b32_RoadProperty(fi_tcl_b32_RoadProperty& ob32_RoadProperty);

   virtual tVoid vVisit_e8_PathType(fi_tcl_e8_PathType& oe8_PathType);

   virtual tVoid vVisit_s16_CurvatureValue(fi_tcl_s16_CurvatureValue& os16_CurvatureValue);

   virtual tVoid vVisit_e8_EntryPointState(fi_tcl_e8_EntryPointState& oe8_EntryPointState);

   virtual tVoid vVisit_u32_Resistance(fi_tcl_u32_Resistance& ou32_Resistance);

   virtual tVoid vVisit_e8_NavStreetType(fi_tcl_e8_NavStreetType& oe8_NavStreetType);

   virtual tVoid vVisit_e8_RoadNetworkClass(fi_tcl_e8_RoadNetworkClass& oe8_RoadNetworkClass);

   virtual tVoid vVisit_e8_RoadInfoPriority(fi_tcl_e8_RoadInfoPriority& oe8_RoadInfoPriority);

   virtual tVoid vVisit_NavRoadInfoProperty(fi_tcl_NavRoadInfoProperty& oNavRoadInfoProperty);

   virtual tVoid vVisit_NavRoadInfoDesc(fi_tcl_NavRoadInfoDesc& oNavRoadInfoDesc);

   virtual tVoid vVisit_e8_RoadInfoRefListType(fi_tcl_e8_RoadInfoRefListType& oe8_RoadInfoRefListType);

   virtual tVoid vVisit_NavRoadInfoRefListUnionType(fi_tcl_NavRoadInfoRefListUnionType& oNavRoadInfoRefListUnionType);

   virtual tVoid vVisit_NavRoadInfoListSet(fi_tcl_NavRoadInfoListSet& oNavRoadInfoListSet);

   virtual tVoid vVisit_e8_RoadPathInfoCategory(fi_tcl_e8_RoadPathInfoCategory& oe8_RoadPathInfoCategory);

   virtual tVoid vVisit_e8_CrossroadInfoCategory(fi_tcl_e8_CrossroadInfoCategory& oe8_CrossroadInfoCategory);

   virtual tVoid vVisit_RoadPathInfoCategory(fi_tcl_RoadPathInfoCategory& oRoadPathInfoCategory);

   virtual tVoid vVisit_RoadPathInfoListSet(fi_tcl_RoadPathInfoListSet& oRoadPathInfoListSet);

   virtual tVoid vVisit_NavTMOneCell(fi_tcl_NavTMOneCell& oNavTMOneCell);

   virtual tVoid vVisit_NavTMOneCellListSet(fi_tcl_NavTMOneCellListSet& oNavTMOneCellListSet);

   virtual tVoid vVisit_e8_DataAvailable(fi_tcl_e8_DataAvailable& oe8_DataAvailable);

   virtual tVoid vVisit_e8_NavLocationDescType(fi_tcl_e8_NavLocationDescType& oe8_NavLocationDescType);

   virtual tVoid vVisit_NavLocationDesc(fi_tcl_NavLocationDesc& oNavLocationDesc);

#ifndef FI_S_EXTERNAL_FI
   virtual tVoid vVisit_NavLocationBinContainer(fi_tcl_NavLocationBinContainer& oNavLocationBinContainer);

#endif // FI_S_EXTERNAL_FI
   virtual tVoid vVisit_e8_NavIndexZFDestinationType(fi_tcl_e8_NavIndexZFDestinationType& oe8_NavIndexZFDestinationType);

   virtual tVoid vVisit_e8_NavLocationNavDataType(fi_tcl_e8_NavLocationNavDataType& oe8_NavLocationNavDataType);

   virtual tVoid vVisit_u32_DataSetId(fi_tcl_u32_DataSetId& ou32_DataSetId);

   virtual tVoid vVisit_e8_SideInfo(fi_tcl_e8_SideInfo& oe8_SideInfo);

   virtual tVoid vVisit_NavSpotDestinationOneCellProperty(fi_tcl_NavSpotDestinationOneCellProperty& oNavSpotDestinationOneCellProperty);

   virtual tVoid vVisit_NavSpotDestinationOneCellDesc(fi_tcl_NavSpotDestinationOneCellDesc& oNavSpotDestinationOneCellDesc);

   virtual tVoid vVisit_NavStreetDestinationOneCellProperty(fi_tcl_NavStreetDestinationOneCellProperty& oNavStreetDestinationOneCellProperty);

   virtual tVoid vVisit_NavStreetDestinationOneCellDesc(fi_tcl_NavStreetDestinationOneCellDesc& oNavStreetDestinationOneCellDesc);

   virtual tVoid vVisit_NavStreetDestinationOneCellListSet(fi_tcl_NavStreetDestinationOneCellListSet& oNavStreetDestinationOneCellListSet);

   virtual tVoid vVisit_e8_NavIntersectionType(fi_tcl_e8_NavIntersectionType& oe8_NavIntersectionType);

   virtual tVoid vVisit_NavZeroCellDesc(fi_tcl_NavZeroCellDesc& oNavZeroCellDesc);

   virtual tVoid vVisit_NavIntersectionDestinationZeroCellProperty(fi_tcl_NavIntersectionDestinationZeroCellProperty& oNavIntersectionDestinationZeroCellProperty);

   virtual tVoid vVisit_NavIntersectionDestinationZeroCellDesc(fi_tcl_NavIntersectionDestinationZeroCellDesc& oNavIntersectionDestinationZeroCellDesc);

   virtual tVoid vVisit_NavAreaDescriptionCircle(fi_tcl_NavAreaDescriptionCircle& oNavAreaDescriptionCircle);

   virtual tVoid vVisit_NavAreaDescriptionPolygon(fi_tcl_NavAreaDescriptionPolygon& oNavAreaDescriptionPolygon);

   virtual tVoid vVisit_CountryInfo(fi_tcl_CountryInfo& oCountryInfo);

   virtual tVoid vVisit_u16_TripHandle(fi_tcl_u16_TripHandle& ou16_TripHandle);

   virtual tVoid vVisit_b32_NavRouteStatus(fi_tcl_b32_NavRouteStatus& ob32_NavRouteStatus);

   virtual tVoid vVisit_b32_ExtNavRouteStatus(fi_tcl_b32_ExtNavRouteStatus& ob32_ExtNavRouteStatus);

   virtual tVoid vVisit_NavRouteInfo(fi_tcl_NavRouteInfo& oNavRouteInfo);

   virtual tVoid vVisit_u16_TripSegmentNumber(fi_tcl_u16_TripSegmentNumber& ou16_TripSegmentNumber);

   virtual tVoid vVisit_e8_ManoeuvreCriticality(fi_tcl_e8_ManoeuvreCriticality& oe8_ManoeuvreCriticality);

   virtual tVoid vVisit_NavRouteDestinationDesc(fi_tcl_NavRouteDestinationDesc& oNavRouteDestinationDesc);

   virtual tVoid vVisit_b32_NavRouteOneCellStatus(fi_tcl_b32_NavRouteOneCellStatus& ob32_NavRouteOneCellStatus);

   virtual tVoid vVisit_b32_ExtNavRouteOneCellStatus(fi_tcl_b32_ExtNavRouteOneCellStatus& ob32_ExtNavRouteOneCellStatus);

   virtual tVoid vVisit_NavRouteOneCellProperties(fi_tcl_NavRouteOneCellProperties& oNavRouteOneCellProperties);

   virtual tVoid vVisit_NavRouteOneCellDesc(fi_tcl_NavRouteOneCellDesc& oNavRouteOneCellDesc);

   virtual tVoid vVisit_NavRouteInstructionDesc(fi_tcl_NavRouteInstructionDesc& oNavRouteInstructionDesc);

   virtual tVoid vVisit_u16_RouteHandle(fi_tcl_u16_RouteHandle& ou16_RouteHandle);

   virtual tVoid vVisit_e8_SignPostDestType(fi_tcl_e8_SignPostDestType& oe8_SignPostDestType);

   virtual tVoid vVisit_e8_SignPostDestinationCategory(fi_tcl_e8_SignPostDestinationCategory& oe8_SignPostDestinationCategory);

   virtual tVoid vVisit_e8_SignPostDestStatus(fi_tcl_e8_SignPostDestStatus& oe8_SignPostDestStatus);

   virtual tVoid vVisit_e8_DirectionStatus(fi_tcl_e8_DirectionStatus& oe8_DirectionStatus);

   virtual tVoid vVisit_SignPostDestDirection(fi_tcl_SignPostDestDirection& oSignPostDestDirection);

   virtual tVoid vVisit_e8_DirectionCategory(fi_tcl_e8_DirectionCategory& oe8_DirectionCategory);

   virtual tVoid vVisit_e8_NavOneCellCategory(fi_tcl_e8_NavOneCellCategory& oe8_NavOneCellCategory);

   virtual tVoid vVisit_DirectionCategory(fi_tcl_DirectionCategory& oDirectionCategory);

   virtual tVoid vVisit_b8_DirectionInfoStatus(fi_tcl_b8_DirectionInfoStatus& ob8_DirectionInfoStatus);

   virtual tVoid vVisit_DirectionInfo(fi_tcl_DirectionInfo& oDirectionInfo);

   virtual tVoid vVisit_SignPostDestination(fi_tcl_SignPostDestination& oSignPostDestination);

   virtual tVoid vVisit_DirectionInfoList(fi_tcl_DirectionInfoList& oDirectionInfoList);

   virtual tVoid vVisit_ReferenceElement(fi_tcl_ReferenceElement& oReferenceElement);

   virtual tVoid vVisit_b8_SignPostInfoStatus(fi_tcl_b8_SignPostInfoStatus& ob8_SignPostInfoStatus);

   virtual tVoid vVisit_e8_TMAffectionType(fi_tcl_e8_TMAffectionType& oe8_TMAffectionType);

   virtual tVoid vVisit_b8_TMOneCellAttribute(fi_tcl_b8_TMOneCellAttribute& ob8_TMOneCellAttribute);

   virtual tVoid vVisit_TMOneCellDesc(fi_tcl_TMOneCellDesc& oTMOneCellDesc);

   virtual tVoid vVisit_NavLocationDataDesc(fi_tcl_NavLocationDataDesc& oNavLocationDataDesc);

   virtual tVoid vVisit_u32_MediaId(fi_tcl_u32_MediaId& ou32_MediaId);

   virtual tVoid vVisit_EDMOneCellProp(fi_tcl_EDMOneCellProp& oEDMOneCellProp);

   virtual tVoid vVisit_e8_NavDataLevel(fi_tcl_e8_NavDataLevel& oe8_NavDataLevel);

   virtual tVoid vVisit_TMIntersectionPath(fi_tcl_TMIntersectionPath& oTMIntersectionPath);

   virtual tVoid vVisit_SameLevelOneCellBlock(fi_tcl_SameLevelOneCellBlock& oSameLevelOneCellBlock);

   virtual tVoid vVisit_NavSpotDestinationOneCellListSet(fi_tcl_NavSpotDestinationOneCellListSet& oNavSpotDestinationOneCellListSet);

   virtual tVoid vVisit_NavPosOneCellProperty(fi_tcl_NavPosOneCellProperty& oNavPosOneCellProperty);

   virtual tVoid vVisit_NavIntersectionDestinationZeroCellListSet(fi_tcl_NavIntersectionDestinationZeroCellListSet& oNavIntersectionDestinationZeroCellListSet);

   virtual tVoid vVisit_NavOneCell(fi_tcl_NavOneCell& oNavOneCell);

   virtual tVoid vVisit_SignPostElement(fi_tcl_SignPostElement& oSignPostElement);

   virtual tVoid vVisit_NavDLDChainOneCellProperty(fi_tcl_NavDLDChainOneCellProperty& oNavDLDChainOneCellProperty);

   virtual tVoid vVisit_NavDLDChainOneCellDesc(fi_tcl_NavDLDChainOneCellDesc& oNavDLDChainOneCellDesc);

   virtual tVoid vVisit_NavDLDChainOneCellListSet(fi_tcl_NavDLDChainOneCellListSet& oNavDLDChainOneCellListSet);

#ifndef FI_S_EXTERNAL_FI
   virtual tVoid vVisit_NavUTMBinContainer(fi_tcl_NavUTMBinContainer& oNavUTMBinContainer);

#endif // FI_S_EXTERNAL_FI
   virtual tVoid vVisit_e8_WeatherProtocol(fi_tcl_e8_WeatherProtocol& oe8_WeatherProtocol);

   virtual tVoid vVisit_b8_CriterionStatus(fi_tcl_b8_CriterionStatus& ob8_CriterionStatus);

   virtual tVoid vVisit_AddressTemplate(fi_tcl_AddressTemplate& oAddressTemplate);

   virtual tVoid vVisit_e8_FilterAttributeType(fi_tcl_e8_FilterAttributeType& oe8_FilterAttributeType);

   virtual tVoid vVisit_FilterAttribute(fi_tcl_FilterAttribute& oFilterAttribute);

   virtual tVoid vVisit_e16_MenuItemType(fi_tcl_e16_MenuItemType& oe16_MenuItemType);

   virtual tVoid vVisit_e8_LocationValueListType(fi_tcl_e8_LocationValueListType& oe8_LocationValueListType);

   virtual tVoid vVisit_b8_ListResultOptions(fi_tcl_b8_ListResultOptions& ob8_ListResultOptions);

   virtual tVoid vVisit_b8_ListGetOptions(fi_tcl_b8_ListGetOptions& ob8_ListGetOptions);

   virtual tVoid vVisit_LocationValueListUnion(fi_tcl_LocationValueListUnion& oLocationValueListUnion);

   virtual tVoid vVisit_ListElement(fi_tcl_ListElement& oListElement);

   virtual tVoid vVisit_StringElement(fi_tcl_StringElement& oStringElement);

   virtual tVoid vVisit_StringList(fi_tcl_StringList& oStringList);

   virtual tVoid vVisit_StringDescriptionElement(fi_tcl_StringDescriptionElement& oStringDescriptionElement);

   virtual tVoid vVisit_StringDescriptionList(fi_tcl_StringDescriptionList& oStringDescriptionList);

   virtual tVoid vVisit_StringID(fi_tcl_StringID& oStringID);

   virtual tVoid vVisit_StringIDElement(fi_tcl_StringIDElement& oStringIDElement);

   virtual tVoid vVisit_PositionWGS84Element(fi_tcl_PositionWGS84Element& oPositionWGS84Element);

   virtual tVoid vVisit_PositionWGS84List(fi_tcl_PositionWGS84List& oPositionWGS84List);

   virtual tVoid vVisit_StringPosition(fi_tcl_StringPosition& oStringPosition);

   virtual tVoid vVisit_StringPositionElement(fi_tcl_StringPositionElement& oStringPositionElement);

   virtual tVoid vVisit_StringPositionDescriptionElement(fi_tcl_StringPositionDescriptionElement& oStringPositionDescriptionElement);

   virtual tVoid vVisit_StringPositionDescriptionList(fi_tcl_StringPositionDescriptionList& oStringPositionDescriptionList);

   virtual tVoid vVisit_b8_ListSortOptions(fi_tcl_b8_ListSortOptions& ob8_ListSortOptions);

   virtual tVoid vVisit_e8_LocationDescriptionDataType(fi_tcl_e8_LocationDescriptionDataType& oe8_LocationDescriptionDataType);

   virtual tVoid vVisit_SelectionCriterionDescription(fi_tcl_SelectionCriterionDescription& oSelectionCriterionDescription);

   virtual tVoid vVisit_b8_CriteriaGetOptions(fi_tcl_b8_CriteriaGetOptions& ob8_CriteriaGetOptions);

   virtual tVoid vVisit_DAPISelectableCriterion(fi_tcl_DAPISelectableCriterion& oDAPISelectableCriterion);

   virtual tVoid vVisit_e8_TransformMode(fi_tcl_e8_TransformMode& oe8_TransformMode);

   virtual tVoid vVisit_b8_LocationDescriptorStatus(fi_tcl_b8_LocationDescriptorStatus& ob8_LocationDescriptorStatus);

   virtual tVoid vVisit_LocationDescriptor(fi_tcl_LocationDescriptor& oLocationDescriptor);

   virtual tVoid vVisit_SelectableCriterion(fi_tcl_SelectableCriterion& oSelectableCriterion);

   virtual tVoid vVisit_LocationDescription(fi_tcl_LocationDescription& oLocationDescription);

   virtual tVoid vVisit_StringPositionList(fi_tcl_StringPositionList& oStringPositionList);

   virtual tVoid vVisit_StringIDList(fi_tcl_StringIDList& oStringIDList);

   virtual tVoid vVisit_FLIString(fi_tcl_FLIString& oFLIString);

   virtual tVoid vVisit_b8_PositionStatus(fi_tcl_b8_PositionStatus& ob8_PositionStatus);

   virtual tVoid vVisit_ListOfPositions(fi_tcl_ListOfPositions& oListOfPositions);

   virtual tVoid vVisit_e8_MapDataLevel(fi_tcl_e8_MapDataLevel& oe8_MapDataLevel);

   virtual tVoid vVisit_MapCoordinates(fi_tcl_MapCoordinates& oMapCoordinates);

   virtual tVoid vVisit_RelativeCoord_8Bit(fi_tcl_RelativeCoord_8Bit& oRelativeCoord_8Bit);

   virtual tVoid vVisit_RelativeCoord_16Bit(fi_tcl_RelativeCoord_16Bit& oRelativeCoord_16Bit);

   virtual tVoid vVisit_RelativeCoord_24Bit(fi_tcl_RelativeCoord_24Bit& oRelativeCoord_24Bit);

   virtual tVoid vVisit_s16_Longitude(fi_tcl_s16_Longitude& os16_Longitude);

   virtual tVoid vVisit_s16_Latitude(fi_tcl_s16_Latitude& os16_Latitude);

   virtual tVoid vVisit_s24_Longitude(fi_tcl_s24_Longitude& os24_Longitude);

   virtual tVoid vVisit_s24_Latitude(fi_tcl_s24_Latitude& os24_Latitude);

   virtual tVoid vVisit_PositionWGS84_16Bit(fi_tcl_PositionWGS84_16Bit& oPositionWGS84_16Bit);

   virtual tVoid vVisit_PositionWGS84_24Bit(fi_tcl_PositionWGS84_24Bit& oPositionWGS84_24Bit);

   virtual tVoid vVisit_e8_CoordCode(fi_tcl_e8_CoordCode& oe8_CoordCode);

   virtual tVoid vVisit_CodedCoord(fi_tcl_CodedCoord& oCodedCoord);

   virtual tVoid vVisit_CoordCodingScheme(fi_tcl_CoordCodingScheme& oCoordCodingScheme);

   virtual tVoid vVisit_b8_PresenceIndicator(fi_tcl_b8_PresenceIndicator& ob8_PresenceIndicator);

   virtual tVoid vVisit_s8_MapDisplayZLevel(fi_tcl_s8_MapDisplayZLevel& os8_MapDisplayZLevel);

   virtual tVoid vVisit_s8_MapDisplayPriority(fi_tcl_s8_MapDisplayPriority& os8_MapDisplayPriority);

   virtual tVoid vVisit_MapCodedElement(fi_tcl_MapCodedElement& oMapCodedElement);

   virtual tVoid vVisit_MapContainer(fi_tcl_MapContainer& oMapContainer);

   virtual tVoid vVisit_e8_MapElementDescrType(fi_tcl_e8_MapElementDescrType& oe8_MapElementDescrType);

   virtual tVoid vVisit_MapElementDescriptor(fi_tcl_MapElementDescriptor& oMapElementDescriptor);

   virtual tVoid vVisit_MapElementDescription(fi_tcl_MapElementDescription& oMapElementDescription);

   virtual tVoid vVisit_e8_MapGeometricType(fi_tcl_e8_MapGeometricType& oe8_MapGeometricType);

   virtual tVoid vVisit_MapGeographicType(fi_tcl_MapGeographicType& oMapGeographicType);

   virtual tVoid vVisit_e8_SurfaceCoverCode(fi_tcl_e8_SurfaceCoverCode& oe8_SurfaceCoverCode);

   virtual tVoid vVisit_MapRegion(fi_tcl_MapRegion& oMapRegion);

   virtual tVoid vVisit_MapDirectory(fi_tcl_MapDirectory& oMapDirectory);

   virtual tVoid vVisit_u16_MapScale(fi_tcl_u16_MapScale& ou16_MapScale);

   virtual tVoid vVisit_MapDataLevelDirectory(fi_tcl_MapDataLevelDirectory& oMapDataLevelDirectory);

   virtual tVoid vVisit_ScaleConfig(fi_tcl_ScaleConfig& oScaleConfig);

   virtual tVoid vVisit_s16_XPosScreen(fi_tcl_s16_XPosScreen& os16_XPosScreen);

   virtual tVoid vVisit_s16_YPosScreen(fi_tcl_s16_YPosScreen& os16_YPosScreen);

   virtual tVoid vVisit_u16_Direction(fi_tcl_u16_Direction& ou16_Direction);

   virtual tVoid vVisit_b16_HUCaps(fi_tcl_b16_HUCaps& ob16_HUCaps);

   virtual tVoid vVisit_b16_GlobalPreferences(fi_tcl_b16_GlobalPreferences& ob16_GlobalPreferences);

   virtual tVoid vVisit_b32_POI1(fi_tcl_b32_POI1& ob32_POI1);

   virtual tVoid vVisit_b32_POI2(fi_tcl_b32_POI2& ob32_POI2);

   virtual tVoid vVisit_b32_ServiceStations(fi_tcl_b32_ServiceStations& ob32_ServiceStations);

   virtual tVoid vVisit_b32_ServiceStations2(fi_tcl_b32_ServiceStations2& ob32_ServiceStations2);

   virtual tVoid vVisit_b32_ServiceStations3(fi_tcl_b32_ServiceStations3& ob32_ServiceStations3);

   virtual tVoid vVisit_b8_FreewayFacilities(fi_tcl_b8_FreewayFacilities& ob8_FreewayFacilities);

   virtual tVoid vVisit_b8_ParkingAreas(fi_tcl_b8_ParkingAreas& ob8_ParkingAreas);

   virtual tVoid vVisit_b8_BorderLines(fi_tcl_b8_BorderLines& ob8_BorderLines);

   virtual tVoid vVisit_b8_RiverClass(fi_tcl_b8_RiverClass& ob8_RiverClass);

   virtual tVoid vVisit_b8_Channels(fi_tcl_b8_Channels& ob8_Channels);

   virtual tVoid vVisit_b32_Streets(fi_tcl_b32_Streets& ob32_Streets);

   virtual tVoid vVisit_b8_Areas(fi_tcl_b8_Areas& ob8_Areas);

   virtual tVoid vVisit_b32_CityCenters(fi_tcl_b32_CityCenters& ob32_CityCenters);

   virtual tVoid vVisit_b8_DirInfoStatus(fi_tcl_b8_DirInfoStatus& ob8_DirInfoStatus);

   virtual tVoid vVisit_e8_FilterAcceptance(fi_tcl_e8_FilterAcceptance& oe8_FilterAcceptance);

   virtual tVoid vVisit_e8_DrawMode(fi_tcl_e8_DrawMode& oe8_DrawMode);

   virtual tVoid vVisit_e8_MapState(fi_tcl_e8_MapState& oe8_MapState);

   virtual tVoid vVisit_e8_MapMode(fi_tcl_e8_MapMode& oe8_MapMode);

   virtual tVoid vVisit_e8_MapScale(fi_tcl_e8_MapScale& oe8_MapScale);

   virtual tVoid vVisit_e8_MapAngle(fi_tcl_e8_MapAngle& oe8_MapAngle);

   virtual tVoid vVisit_MapTransMatrix(fi_tcl_MapTransMatrix& oMapTransMatrix);

   virtual tVoid vVisit_e8_BaudRate(fi_tcl_e8_BaudRate& oe8_BaudRate);

   virtual tVoid vVisit_e16_IdxType(fi_tcl_e16_IdxType& oe16_IdxType);

   virtual tVoid vVisit_PositionScreen(fi_tcl_PositionScreen& oPositionScreen);

   virtual tVoid vVisit_IndexInfo(fi_tcl_IndexInfo& oIndexInfo);

   virtual tVoid vVisit_b8_DrawOptions(fi_tcl_b8_DrawOptions& ob8_DrawOptions);

   virtual tVoid vVisit_RouteDescriptor(fi_tcl_RouteDescriptor& oRouteDescriptor);

   virtual tVoid vVisit_e8_RouteDisplayType(fi_tcl_e8_RouteDisplayType& oe8_RouteDisplayType);

   virtual tVoid vVisit_e16_USMarcLanguageCode(fi_tcl_e16_USMarcLanguageCode& oe16_USMarcLanguageCode);

   virtual tVoid vVisit_u32CodePage(fi_tcl_u32CodePage& ou32CodePage);

   virtual tVoid vVisit_e8_LanguageDefaultFlag(fi_tcl_e8_LanguageDefaultFlag& oe8_LanguageDefaultFlag);

   virtual tVoid vVisit_LanguageFilter(fi_tcl_LanguageFilter& oLanguageFilter);

   virtual tVoid vVisit_ZoomLevelConfig(fi_tcl_ZoomLevelConfig& oZoomLevelConfig);

   virtual tVoid vVisit_DestinationFlag(fi_tcl_DestinationFlag& oDestinationFlag);

   virtual tVoid vVisit_b16_TheaterDescriptionRequest(fi_tcl_b16_TheaterDescriptionRequest& ob16_TheaterDescriptionRequest);

   virtual tVoid vVisit_TheaterInfo(fi_tcl_TheaterInfo& oTheaterInfo);

   virtual tVoid vVisit_MovieId(fi_tcl_MovieId& oMovieId);

   virtual tVoid vVisit_Rating(fi_tcl_Rating& oRating);

   virtual tVoid vVisit_RunTime(fi_tcl_RunTime& oRunTime);

   virtual tVoid vVisit_MovieName(fi_tcl_MovieName& oMovieName);

   virtual tVoid vVisit_MovieDescription(fi_tcl_MovieDescription& oMovieDescription);

   virtual tVoid vVisit_TheaterId(fi_tcl_TheaterId& oTheaterId);

   virtual tVoid vVisit_Showing(fi_tcl_Showing& oShowing);

   virtual tVoid vVisit_MovieTimes(fi_tcl_MovieTimes& oMovieTimes);

   virtual tVoid vVisit_TheaterMovieTimes(fi_tcl_TheaterMovieTimes& oTheaterMovieTimes);

   virtual tVoid vVisit_TheaterMovieTimesForPosition(fi_tcl_TheaterMovieTimesForPosition& oTheaterMovieTimesForPosition);

   virtual tVoid vVisit_e8_DetailGrade(fi_tcl_e8_DetailGrade& oe8_DetailGrade);

   virtual tVoid vVisit_BriefMovieDescription(fi_tcl_BriefMovieDescription& oBriefMovieDescription);

   virtual tVoid vVisit_TheaterDescription(fi_tcl_TheaterDescription& oTheaterDescription);

   virtual tVoid vVisit_u16_UserTrafficMessageHandle(fi_tcl_u16_UserTrafficMessageHandle& ou16_UserTrafficMessageHandle);

   virtual tVoid vVisit_UTMHandleContainer(fi_tcl_UTMHandleContainer& oUTMHandleContainer);

   virtual tVoid vVisit_e8_PositionCalculationState(fi_tcl_e8_PositionCalculationState& oe8_PositionCalculationState);

   virtual tVoid vVisit_e8_SwitchPositionStatus(fi_tcl_e8_SwitchPositionStatus& oe8_SwitchPositionStatus);

   virtual tVoid vVisit_e8_LaneStatus(fi_tcl_e8_LaneStatus& oe8_LaneStatus);

   virtual tVoid vVisit_b8_LaneType(fi_tcl_b8_LaneType& ob8_LaneType);

   virtual tVoid vVisit_b8_LaneChangeRestriction(fi_tcl_b8_LaneChangeRestriction& ob8_LaneChangeRestriction);

   virtual tVoid vVisit_u8_IndexInLaneInfoSegmentList(fi_tcl_u8_IndexInLaneInfoSegmentList& ou8_IndexInLaneInfoSegmentList);

   virtual tVoid vVisit_u8_IndexInLaneInfoList(fi_tcl_u8_IndexInLaneInfoList& ou8_IndexInLaneInfoList);

   virtual tVoid vVisit_u8_DrivingDirection(fi_tcl_u8_DrivingDirection& ou8_DrivingDirection);

   virtual tVoid vVisit_LaneDirection(fi_tcl_LaneDirection& oLaneDirection);

   virtual tVoid vVisit_LaneInfoOneCellReference(fi_tcl_LaneInfoOneCellReference& oLaneInfoOneCellReference);

   virtual tVoid vVisit_LaneInfoOneCellIndexReference(fi_tcl_LaneInfoOneCellIndexReference& oLaneInfoOneCellIndexReference);

   virtual tVoid vVisit_LaneInfoPathSectionIndexReference(fi_tcl_LaneInfoPathSectionIndexReference& oLaneInfoPathSectionIndexReference);

   virtual tVoid vVisit_LaneInfoElementReference(fi_tcl_LaneInfoElementReference& oLaneInfoElementReference);

   virtual tVoid vVisit_e8_LaneReferenceCategory(fi_tcl_e8_LaneReferenceCategory& oe8_LaneReferenceCategory);

   virtual tVoid vVisit_LaneReference(fi_tcl_LaneReference& oLaneReference);

   virtual tVoid vVisit_LaneInfo(fi_tcl_LaneInfo& oLaneInfo);

   virtual tVoid vVisit_LaneInfoElement(fi_tcl_LaneInfoElement& oLaneInfoElement);

   virtual tVoid vVisit_LaneInfoSegment(fi_tcl_LaneInfoSegment& oLaneInfoSegment);

   virtual tVoid vVisit_LaneInfoSegmentList(fi_tcl_LaneInfoSegmentList& oLaneInfoSegmentList);

   virtual tVoid vVisit_LaneInfoListSet(fi_tcl_LaneInfoListSet& oLaneInfoListSet);

   virtual tVoid vVisit_e8_EntryExitType(fi_tcl_e8_EntryExitType& oe8_EntryExitType);

   virtual tVoid vVisit_EntryExitCoordinates(fi_tcl_EntryExitCoordinates& oEntryExitCoordinates);

   virtual tVoid vVisit_EntryExitPointListSet(fi_tcl_EntryExitPointListSet& oEntryExitPointListSet);

   virtual tVoid vVisit_WGS84CoordinateList(fi_tcl_WGS84CoordinateList& oWGS84CoordinateList);

   virtual tVoid vVisit_ShapePointListSet(fi_tcl_ShapePointListSet& oShapePointListSet);

   virtual tVoid vVisit_b8_TrafficMessageContent(fi_tcl_b8_TrafficMessageContent& ob8_TrafficMessageContent);

   virtual tVoid vVisit_e8_TMGeometricMessageType(fi_tcl_e8_TMGeometricMessageType& oe8_TMGeometricMessageType);

   virtual tVoid vVisit_e16_NaviEventValue(fi_tcl_e16_NaviEventValue& oe16_NaviEventValue);

   virtual tVoid vVisit_TMMapOneCellListSet(fi_tcl_TMMapOneCellListSet& oTMMapOneCellListSet);

   virtual tVoid vVisit_TrafficSense(fi_tcl_TrafficSense& oTrafficSense);

   virtual tVoid vVisit_TrafficSenseList(fi_tcl_TrafficSenseList& oTrafficSenseList);

   virtual tVoid vVisit_SpeedFactor(fi_tcl_SpeedFactor& oSpeedFactor);

   virtual tVoid vVisit_e8_RoadTypeDesc(fi_tcl_e8_RoadTypeDesc& oe8_RoadTypeDesc);

   virtual tVoid vVisit_SpeedFactorRoadAreaType(fi_tcl_SpeedFactorRoadAreaType& oSpeedFactorRoadAreaType);

   virtual tVoid vVisit_SpeedFactorsCountry(fi_tcl_SpeedFactorsCountry& oSpeedFactorsCountry);

   virtual tVoid vVisit_SpeedFactorsList(fi_tcl_SpeedFactorsList& oSpeedFactorsList);

   virtual tVoid vVisit_b8_SpeedLimitStatus(fi_tcl_b8_SpeedLimitStatus& ob8_SpeedLimitStatus);

   virtual tVoid vVisit_e8_SpeedUnit(fi_tcl_e8_SpeedUnit& oe8_SpeedUnit);

   virtual tVoid vVisit_e8_SpeedType(fi_tcl_e8_SpeedType& oe8_SpeedType);

   virtual tVoid vVisit_SpeedLimitStatus(fi_tcl_SpeedLimitStatus& oSpeedLimitStatus);

   virtual tVoid vVisit_SpeedLimit(fi_tcl_SpeedLimit& oSpeedLimit);

   virtual tVoid vVisit_SpeedLimitRoadAreaType(fi_tcl_SpeedLimitRoadAreaType& oSpeedLimitRoadAreaType);

   virtual tVoid vVisit_SpeedLimitsCountry(fi_tcl_SpeedLimitsCountry& oSpeedLimitsCountry);

   virtual tVoid vVisit_SpeedLimitsList(fi_tcl_SpeedLimitsList& oSpeedLimitsList);

   virtual tVoid vVisit_PrefixDesc(fi_tcl_PrefixDesc& oPrefixDesc);

   virtual tVoid vVisit_PrefixState(fi_tcl_PrefixState& oPrefixState);

   virtual tVoid vVisit_PrefixStateList(fi_tcl_PrefixStateList& oPrefixStateList);

   virtual tVoid vVisit_e8_LanguageCat(fi_tcl_e8_LanguageCat& oe8_LanguageCat);

   virtual tVoid vVisit_LanguageCategory(fi_tcl_LanguageCategory& oLanguageCategory);

   virtual tVoid vVisit_LanguageDesc(fi_tcl_LanguageDesc& oLanguageDesc);

   virtual tVoid vVisit_LanguageDescList(fi_tcl_LanguageDescList& oLanguageDescList);

   virtual tVoid vVisit_e8_GlobalAnnotationCategory(fi_tcl_e8_GlobalAnnotationCategory& oe8_GlobalAnnotationCategory);

   virtual tVoid vVisit_GlobalAnnotationTablesUnion(fi_tcl_GlobalAnnotationTablesUnion& oGlobalAnnotationTablesUnion);

   virtual tVoid vVisit_TimeZoneName(fi_tcl_TimeZoneName& oTimeZoneName);

   virtual tVoid vVisit_UPOI_Category(fi_tcl_UPOI_Category& oUPOI_Category);

   virtual tVoid vVisit_e8_UPOI_Source(fi_tcl_e8_UPOI_Source& oe8_UPOI_Source);

   virtual tVoid vVisit_b16_UPOI_Source(fi_tcl_b16_UPOI_Source& ob16_UPOI_Source);

   virtual tVoid vVisit_b8_UPOI_FilterSetStatus(fi_tcl_b8_UPOI_FilterSetStatus& ob8_UPOI_FilterSetStatus);

   virtual tVoid vVisit_e8_UPOI_AnnouncementDistance(fi_tcl_e8_UPOI_AnnouncementDistance& oe8_UPOI_AnnouncementDistance);

   virtual tVoid vVisit_b8_UPOI_AnnouncementStatus(fi_tcl_b8_UPOI_AnnouncementStatus& ob8_UPOI_AnnouncementStatus);

   virtual tVoid vVisit_b8_UPOI_Validity(fi_tcl_b8_UPOI_Validity& ob8_UPOI_Validity);

   virtual tVoid vVisit_UPOI_Element(fi_tcl_UPOI_Element& oUPOI_Element);

   virtual tVoid vVisit_b8_UPOI_FilterSet_FieldRelevance(fi_tcl_b8_UPOI_FilterSet_FieldRelevance& ob8_UPOI_FilterSet_FieldRelevance);

   virtual tVoid vVisit_UPOI_FilterSet(fi_tcl_UPOI_FilterSet& oUPOI_FilterSet);

   virtual tVoid vVisit_UPOI_FilterList(fi_tcl_UPOI_FilterList& oUPOI_FilterList);

   virtual tVoid vVisit_UPOI_CategoryConfiguration(fi_tcl_UPOI_CategoryConfiguration& oUPOI_CategoryConfiguration);

   virtual tVoid vVisit_UPOI_CategoryConfigurationList(fi_tcl_UPOI_CategoryConfigurationList& oUPOI_CategoryConfigurationList);

   virtual tVoid vVisit_b8_UPOI_Status(fi_tcl_b8_UPOI_Status& ob8_UPOI_Status);

   virtual tVoid vVisit_UPOI_Combination(fi_tcl_UPOI_Combination& oUPOI_Combination);

   virtual tVoid vVisit_UPOI_ListSet(fi_tcl_UPOI_ListSet& oUPOI_ListSet);

   virtual tVoid vVisit_ClockTime(fi_tcl_ClockTime& oClockTime);

   virtual tVoid vVisit_Date(fi_tcl_Date& oDate);

   virtual tVoid vVisit_VersionInfo(fi_tcl_VersionInfo& oVersionInfo);

   virtual tVoid vVisit_e8_GPSFix(fi_tcl_e8_GPSFix& oe8_GPSFix);

   virtual tVoid vVisit_GPSAdditionalInformation(fi_tcl_GPSAdditionalInformation& oGPSAdditionalInformation);

   virtual tVoid vVisit_e8_GPSChannelStatus(fi_tcl_e8_GPSChannelStatus& oe8_GPSChannelStatus);

   virtual tVoid vVisit_s8_ElevationRelative(fi_tcl_s8_ElevationRelative& os8_ElevationRelative);

   virtual tVoid vVisit_GPSChannelInformation(fi_tcl_GPSChannelInformation& oGPSChannelInformation);

   virtual tVoid vVisit_TMMapRef(fi_tcl_TMMapRef& oTMMapRef);

   virtual tVoid vVisit_UTMDesc(fi_tcl_UTMDesc& oUTMDesc);

   virtual tVoid vVisit_UTMDescByTM(fi_tcl_UTMDescByTM& oUTMDescByTM);

   virtual tVoid vVisit_b16_PositionReliability(fi_tcl_b16_PositionReliability& ob16_PositionReliability);

   virtual tVoid vVisit_PositionHeadingSpeed(fi_tcl_PositionHeadingSpeed& oPositionHeadingSpeed);

   virtual tVoid vVisit_e8_InfoStatus(fi_tcl_e8_InfoStatus& oe8_InfoStatus);

   virtual tVoid vVisit_InfoStatus(fi_tcl_InfoStatus& oInfoStatus);

   virtual tVoid vVisit_DirectionInfoListSet(fi_tcl_DirectionInfoListSet& oDirectionInfoListSet);

   virtual tVoid vVisit_ReferenceElementWithID(fi_tcl_ReferenceElementWithID& oReferenceElementWithID);

   virtual tVoid vVisit_e8_SingleRoadInfoCategory(fi_tcl_e8_SingleRoadInfoCategory& oe8_SingleRoadInfoCategory);

   virtual tVoid vVisit_SingleRoadInfo(fi_tcl_SingleRoadInfo& oSingleRoadInfo);

   virtual tVoid vVisit_StateNameElement(fi_tcl_StateNameElement& oStateNameElement);

   virtual tVoid vVisit_CountyNameElement(fi_tcl_CountyNameElement& oCountyNameElement);

   virtual tVoid vVisit_CityDistrictNameElement(fi_tcl_CityDistrictNameElement& oCityDistrictNameElement);

   virtual tVoid vVisit_BuildUpAreaNameElement(fi_tcl_BuildUpAreaNameElement& oBuildUpAreaNameElement);

   virtual tVoid vVisit_RoadNameElementList(fi_tcl_RoadNameElementList& oRoadNameElementList);

   virtual tVoid vVisit_b8_RoadNumberStatus(fi_tcl_b8_RoadNumberStatus& ob8_RoadNumberStatus);

   virtual tVoid vVisit_RequiredTaxDisc(fi_tcl_RequiredTaxDisc& oRequiredTaxDisc);

   virtual tVoid vVisit_e8_RequiredPermissionType(fi_tcl_e8_RequiredPermissionType& oe8_RequiredPermissionType);

   virtual tVoid vVisit_e8_RequiredPermission(fi_tcl_e8_RequiredPermission& oe8_RequiredPermission);

   virtual tVoid vVisit_GenericRequiredPermission(fi_tcl_GenericRequiredPermission& oGenericRequiredPermission);

   virtual tVoid vVisit_RequiredPermission(fi_tcl_RequiredPermission& oRequiredPermission);

   virtual tVoid vVisit_RequiredPermissionList(fi_tcl_RequiredPermissionList& oRequiredPermissionList);

   virtual tVoid vVisit_CountryNameElement(fi_tcl_CountryNameElement& oCountryNameElement);

   virtual tVoid vVisit_StateNameListSet(fi_tcl_StateNameListSet& oStateNameListSet);

   virtual tVoid vVisit_CountyNameListSet(fi_tcl_CountyNameListSet& oCountyNameListSet);

   virtual tVoid vVisit_CityNameElement(fi_tcl_CityNameElement& oCityNameElement);

   virtual tVoid vVisit_IndexInReferenceList(fi_tcl_IndexInReferenceList& oIndexInReferenceList);

   virtual tVoid vVisit_BuildUpAreaNameListSet(fi_tcl_BuildUpAreaNameListSet& oBuildUpAreaNameListSet);

   virtual tVoid vVisit_RoadNameListSet(fi_tcl_RoadNameListSet& oRoadNameListSet);

   virtual tVoid vVisit_CompassDirection(fi_tcl_CompassDirection& oCompassDirection);

   virtual tVoid vVisit_RequiredPermissionListSet(fi_tcl_RequiredPermissionListSet& oRequiredPermissionListSet);

   virtual tVoid vVisit_e8_IntersectionType(fi_tcl_e8_IntersectionType& oe8_IntersectionType);

   virtual tVoid vVisit_TimeZoneListSet(fi_tcl_TimeZoneListSet& oTimeZoneListSet);

   virtual tVoid vVisit_IntersectionNameElement(fi_tcl_IntersectionNameElement& oIntersectionNameElement);

   virtual tVoid vVisit_IntersectionNameListSet(fi_tcl_IntersectionNameListSet& oIntersectionNameListSet);

   virtual tVoid vVisit_RoadNameElement(fi_tcl_RoadNameElement& oRoadNameElement);

   virtual tVoid vVisit_RoadNumber(fi_tcl_RoadNumber& oRoadNumber);

   virtual tVoid vVisit_IntersectionNumberElement(fi_tcl_IntersectionNumberElement& oIntersectionNumberElement);

   virtual tVoid vVisit_MapDescriptionListSet(fi_tcl_MapDescriptionListSet& oMapDescriptionListSet);

   virtual tVoid vVisit_CountryNameListSet(fi_tcl_CountryNameListSet& oCountryNameListSet);

   virtual tVoid vVisit_CityNameListSet(fi_tcl_CityNameListSet& oCityNameListSet);

   virtual tVoid vVisit_SignPostListSet(fi_tcl_SignPostListSet& oSignPostListSet);

   virtual tVoid vVisit_IntersectionNumberListSet(fi_tcl_IntersectionNumberListSet& oIntersectionNumberListSet);

   virtual tVoid vVisit_RoadNumberElementList(fi_tcl_RoadNumberElementList& oRoadNumberElementList);

   virtual tVoid vVisit_RoadNumberListSet(fi_tcl_RoadNumberListSet& oRoadNumberListSet);

   virtual tVoid vVisit_b16_RoadAttribute(fi_tcl_b16_RoadAttribute& ob16_RoadAttribute);

   virtual tVoid vVisit_EDMOneCell(fi_tcl_EDMOneCell& oEDMOneCell);

   virtual tVoid vVisit_NavPosOnecellSectionDescription(fi_tcl_NavPosOnecellSectionDescription& oNavPosOnecellSectionDescription);

   virtual tVoid vVisit_EntryPoint(fi_tcl_EntryPoint& oEntryPoint);

   virtual tVoid vVisit_PositionDescription(fi_tcl_PositionDescription& oPositionDescription);

   virtual tVoid vVisit_RoadAttributes(fi_tcl_RoadAttributes& oRoadAttributes);

   virtual tVoid vVisit_RoadId(fi_tcl_RoadId& oRoadId);

   virtual tVoid vVisit_e8_ExtraDescElementType(fi_tcl_e8_ExtraDescElementType& oe8_ExtraDescElementType);

   virtual tVoid vVisit_ExtraDescElement(fi_tcl_ExtraDescElement& oExtraDescElement);

   virtual tVoid vVisit_ExtraDescListSet(fi_tcl_ExtraDescListSet& oExtraDescListSet);

   virtual tVoid vVisit_b32_DataProperties(fi_tcl_b32_DataProperties& ob32_DataProperties);

   virtual tVoid vVisit_DataDescElement(fi_tcl_DataDescElement& oDataDescElement);

   virtual tVoid vVisit_DataDescListSet(fi_tcl_DataDescListSet& oDataDescListSet);

   virtual tVoid vVisit_b8_CrossroadProperties(fi_tcl_b8_CrossroadProperties& ob8_CrossroadProperties);

   virtual tVoid vVisit_CrossroadDesc(fi_tcl_CrossroadDesc& oCrossroadDesc);

   virtual tVoid vVisit_CrossroadInfo(fi_tcl_CrossroadInfo& oCrossroadInfo);

   virtual tVoid vVisit_IntersectionDenotation(fi_tcl_IntersectionDenotation& oIntersectionDenotation);

   virtual tVoid vVisit_IntersectionPathDenotation(fi_tcl_IntersectionPathDenotation& oIntersectionPathDenotation);

   virtual tVoid vVisit_IntersectionPathDesc(fi_tcl_IntersectionPathDesc& oIntersectionPathDesc);

   virtual tVoid vVisit_IntersectionDescElement(fi_tcl_IntersectionDescElement& oIntersectionDescElement);

   virtual tVoid vVisit_NavIntersectionListSet(fi_tcl_NavIntersectionListSet& oNavIntersectionListSet);

   virtual tVoid vVisit_IntersectionListSet(fi_tcl_IntersectionListSet& oIntersectionListSet);

   virtual tVoid vVisit_e16_BaseTrafficSign(fi_tcl_e16_BaseTrafficSign& oe16_BaseTrafficSign);

   virtual tVoid vVisit_e8_BaseTrafficSignCategory(fi_tcl_e8_BaseTrafficSignCategory& oe8_BaseTrafficSignCategory);

   virtual tVoid vVisit_e8_SpeedSign(fi_tcl_e8_SpeedSign& oe8_SpeedSign);

   virtual tVoid vVisit_e16_WarningSign(fi_tcl_e16_WarningSign& oe16_WarningSign);

   virtual tVoid vVisit_e16_RegulatorySign(fi_tcl_e16_RegulatorySign& oe16_RegulatorySign);

   virtual tVoid vVisit_e16_AdditionalTrafficSign(fi_tcl_e16_AdditionalTrafficSign& oe16_AdditionalTrafficSign);

   virtual tVoid vVisit_TimeDependentString(fi_tcl_TimeDependentString& oTimeDependentString);

   virtual tVoid vVisit_b8_LaneDependentValidity(fi_tcl_b8_LaneDependentValidity& ob8_LaneDependentValidity);

   virtual tVoid vVisit_e8_TrafficSignQuantifier(fi_tcl_e8_TrafficSignQuantifier& oe8_TrafficSignQuantifier);

   virtual tVoid vVisit_AdditionalTrafficSign(fi_tcl_AdditionalTrafficSign& oAdditionalTrafficSign);

   virtual tVoid vVisit_TrafficSignElement(fi_tcl_TrafficSignElement& oTrafficSignElement);

   virtual tVoid vVisit_TrafficSignList(fi_tcl_TrafficSignList& oTrafficSignList);

   virtual tVoid vVisit_RoadInfoCombination(fi_tcl_RoadInfoCombination& oRoadInfoCombination);

   virtual tVoid vVisit_TrafficSignListSet(fi_tcl_TrafficSignListSet& oTrafficSignListSet);

   virtual tVoid vVisit_b32_POICategory(fi_tcl_b32_POICategory& ob32_POICategory);

   virtual tVoid vVisit_POIElement(fi_tcl_POIElement& oPOIElement);

   virtual tVoid vVisit_POIListSet(fi_tcl_POIListSet& oPOIListSet);

   virtual tVoid vVisit_b8_InstructionStatus(fi_tcl_b8_InstructionStatus& ob8_InstructionStatus);

   virtual tVoid vVisit_SimpleInstruction(fi_tcl_SimpleInstruction& oSimpleInstruction);

   virtual tVoid vVisit_SimpleInstructionListSet(fi_tcl_SimpleInstructionListSet& oSimpleInstructionListSet);

   virtual tVoid vVisit_SectionCharacteristics(fi_tcl_SectionCharacteristics& oSectionCharacteristics);

   virtual tVoid vVisit_NavRouteId(fi_tcl_NavRouteId& oNavRouteId);

   virtual tVoid vVisit_b8_RouteProperties(fi_tcl_b8_RouteProperties& ob8_RouteProperties);

   virtual tVoid vVisit_MostWorseManoeuvreInfo(fi_tcl_MostWorseManoeuvreInfo& oMostWorseManoeuvreInfo);

   virtual tVoid vVisit_CriticalDecisionPointListElement(fi_tcl_CriticalDecisionPointListElement& oCriticalDecisionPointListElement);

   virtual tVoid vVisit_CriticalDecisionPointListSet(fi_tcl_CriticalDecisionPointListSet& oCriticalDecisionPointListSet);

   virtual tVoid vVisit_TollBoothElement(fi_tcl_TollBoothElement& oTollBoothElement);

   virtual tVoid vVisit_TollBoothListSet(fi_tcl_TollBoothListSet& oTollBoothListSet);

   virtual tVoid vVisit_CityDistrictNameListSet(fi_tcl_CityDistrictNameListSet& oCityDistrictNameListSet);

   virtual tVoid vVisit_MapDescRefList(fi_tcl_MapDescRefList& oMapDescRefList);

   virtual tVoid vVisit_RoadNameRefList(fi_tcl_RoadNameRefList& oRoadNameRefList);

   virtual tVoid vVisit_RoadNumberRefList(fi_tcl_RoadNumberRefList& oRoadNumberRefList);

   virtual tVoid vVisit_PointOfInterestElement(fi_tcl_PointOfInterestElement& oPointOfInterestElement);

   virtual tVoid vVisit_UnspecifiedText(fi_tcl_UnspecifiedText& oUnspecifiedText);

   virtual tVoid vVisit_NavRouteCompare(fi_tcl_NavRouteCompare& oNavRouteCompare);

   virtual tVoid vVisit_NavRouteListSet(fi_tcl_NavRouteListSet& oNavRouteListSet);

#ifndef FI_S_EXTERNAL_FI
   virtual tVoid vVisit_NavRouteListBinContainer(fi_tcl_NavRouteListBinContainer& oNavRouteListBinContainer);

#endif // FI_S_EXTERNAL_FI
   virtual tVoid vVisit_e8_TMHandling(fi_tcl_e8_TMHandling& oe8_TMHandling);

   virtual tVoid vVisit_e8_TMDirectionInterpretation(fi_tcl_e8_TMDirectionInterpretation& oe8_TMDirectionInterpretation);

   virtual tVoid vVisit_b8_TMIntersectionPath(fi_tcl_b8_TMIntersectionPath& ob8_TMIntersectionPath);

   virtual tVoid vVisit_TMParamAmbiguousClosing(fi_tcl_TMParamAmbiguousClosing& oTMParamAmbiguousClosing);

   virtual tVoid vVisit_TMParamAmbiguousDynamicDisruption(fi_tcl_TMParamAmbiguousDynamicDisruption& oTMParamAmbiguousDynamicDisruption);

   virtual tVoid vVisit_TMParamAmbiguousArea(fi_tcl_TMParamAmbiguousArea& oTMParamAmbiguousArea);

   virtual tVoid vVisit_e8_ShapeType(fi_tcl_e8_ShapeType& oe8_ShapeType);

   virtual tVoid vVisit_Shape(fi_tcl_Shape& oShape);

   virtual tVoid vVisit_RDBId(fi_tcl_RDBId& oRDBId);

   virtual tVoid vVisit_ExtendedLocation(fi_tcl_ExtendedLocation& oExtendedLocation);

   virtual tVoid vVisit_CountryLocationList(fi_tcl_CountryLocationList& oCountryLocationList);

   virtual tVoid vVisit_TMProgramService(fi_tcl_TMProgramService& oTMProgramService);

   virtual tVoid vVisit_TMServiceProvider(fi_tcl_TMServiceProvider& oTMServiceProvider);

   virtual tVoid vVisit_e8_TMCategory(fi_tcl_e8_TMCategory& oe8_TMCategory);

   virtual tVoid vVisit_b8_TMMappingPossibility(fi_tcl_b8_TMMappingPossibility& ob8_TMMappingPossibility);

   virtual tVoid vVisit_b8_TMMappingStatus(fi_tcl_b8_TMMappingStatus& ob8_TMMappingStatus);

#ifndef FI_S_EXTERNAL_FI
   virtual tVoid vVisit_TMMapBinContainer(fi_tcl_TMMapBinContainer& oTMMapBinContainer);

#endif // FI_S_EXTERNAL_FI
   virtual tVoid vVisit_TMCodedMapReference(fi_tcl_TMCodedMapReference& oTMCodedMapReference);

   virtual tVoid vVisit_EDMLevelOCList(fi_tcl_EDMLevelOCList& oEDMLevelOCList);

   virtual tVoid vVisit_e8_TMValueStatus(fi_tcl_e8_TMValueStatus& oe8_TMValueStatus);

   virtual tVoid vVisit_TMCombination(fi_tcl_TMCombination& oTMCombination);

   virtual tVoid vVisit_TMCStructuredText(fi_tcl_TMCStructuredText& oTMCStructuredText);

   virtual tVoid vVisit_TMCategoryStatistics(fi_tcl_TMCategoryStatistics& oTMCategoryStatistics);

   virtual tVoid vVisit_e8_TMFlowImpact(fi_tcl_e8_TMFlowImpact& oe8_TMFlowImpact);

   virtual tVoid vVisit_e8_TMUrgency(fi_tcl_e8_TMUrgency& oe8_TMUrgency);

   virtual tVoid vVisit_UTMStatistics(fi_tcl_UTMStatistics& oUTMStatistics);

   virtual tVoid vVisit_TMFlowImpactStatistics(fi_tcl_TMFlowImpactStatistics& oTMFlowImpactStatistics);

   virtual tVoid vVisit_b8_TMAdditionalInformation(fi_tcl_b8_TMAdditionalInformation& ob8_TMAdditionalInformation);

   virtual tVoid vVisit_e8_TMGeographicalPathRelationType(fi_tcl_e8_TMGeographicalPathRelationType& oe8_TMGeographicalPathRelationType);

   virtual tVoid vVisit_b8_TMRelevance(fi_tcl_b8_TMRelevance& ob8_TMRelevance);

   virtual tVoid vVisit_e8_TrafficMsgType(fi_tcl_e8_TrafficMsgType& oe8_TrafficMsgType);

   virtual tVoid vVisit_e8_EventType(fi_tcl_e8_EventType& oe8_EventType);

   virtual tVoid vVisit_TMBaseInfo(fi_tcl_TMBaseInfo& oTMBaseInfo);

   virtual tVoid vVisit_b32_TrafficMessageSource(fi_tcl_b32_TrafficMessageSource& ob32_TrafficMessageSource);

   virtual tVoid vVisit_e8_PosHorizonState(fi_tcl_e8_PosHorizonState& oe8_PosHorizonState);

   virtual tVoid vVisit_PosixExactTime(fi_tcl_PosixExactTime& oPosixExactTime);

   virtual tVoid vVisit_OffsetSlopeValue(fi_tcl_OffsetSlopeValue& oOffsetSlopeValue);

   virtual tVoid vVisit_OffsetHeightValue(fi_tcl_OffsetHeightValue& oOffsetHeightValue);

   virtual tVoid vVisit_PosHorizonStartPath(fi_tcl_PosHorizonStartPath& oPosHorizonStartPath);

   virtual tVoid vVisit_e8_DigitalMapSpeedCategoryType(fi_tcl_e8_DigitalMapSpeedCategoryType& oe8_DigitalMapSpeedCategoryType);

   virtual tVoid vVisit_e8_PosHorizonSuccessorState(fi_tcl_e8_PosHorizonSuccessorState& oe8_PosHorizonSuccessorState);

   virtual tVoid vVisit_b32_PathSectionStatus(fi_tcl_b32_PathSectionStatus& ob32_PathSectionStatus);

   virtual tVoid vVisit_b8_PosHorizonSuccessorState(fi_tcl_b8_PosHorizonSuccessorState& ob8_PosHorizonSuccessorState);

   virtual tVoid vVisit_PosHorizonPathSuccessor(fi_tcl_PosHorizonPathSuccessor& oPosHorizonPathSuccessor);

   virtual tVoid vVisit_PosHorizonPathSection(fi_tcl_PosHorizonPathSection& oPosHorizonPathSection);

   virtual tVoid vVisit_PosHorizonOneCellDesc(fi_tcl_PosHorizonOneCellDesc& oPosHorizonOneCellDesc);

   virtual tVoid vVisit_b8_HorizonOneCellPropertyStatus(fi_tcl_b8_HorizonOneCellPropertyStatus& ob8_HorizonOneCellPropertyStatus);

   virtual tVoid vVisit_HorizonMostProbablePath(fi_tcl_HorizonMostProbablePath& oHorizonMostProbablePath);

   virtual tVoid vVisit_PosHorizonRootElement(fi_tcl_PosHorizonRootElement& oPosHorizonRootElement);

   virtual tVoid vVisit_PosHorizonOneCellSection(fi_tcl_PosHorizonOneCellSection& oPosHorizonOneCellSection);

   virtual tVoid vVisit_PositionPathDescription(fi_tcl_PositionPathDescription& oPositionPathDescription);

   virtual tVoid vVisit_PositionList(fi_tcl_PositionList& oPositionList);

   virtual tVoid vVisit_e8_ExtendedPositionCalculationState(fi_tcl_e8_ExtendedPositionCalculationState& oe8_ExtendedPositionCalculationState);

   virtual tVoid vVisit_ExtrapolatedPosition(fi_tcl_ExtrapolatedPosition& oExtrapolatedPosition);

   virtual tVoid vVisit_ExtrapolatedOCDesc(fi_tcl_ExtrapolatedOCDesc& oExtrapolatedOCDesc);

   virtual tVoid vVisit_b8_ExtrapolationReliability(fi_tcl_b8_ExtrapolationReliability& ob8_ExtrapolationReliability);

   virtual tVoid vVisit_VehicleSystemParameter(fi_tcl_VehicleSystemParameter& oVehicleSystemParameter);

   virtual tVoid vVisit_VehicleCovarianceMatrix(fi_tcl_VehicleCovarianceMatrix& oVehicleCovarianceMatrix);

   virtual tVoid vVisit_e8_PresentationStatus(fi_tcl_e8_PresentationStatus& oe8_PresentationStatus);

   virtual tVoid vVisit_e8_CalibrationOperationCode(fi_tcl_e8_CalibrationOperationCode& oe8_CalibrationOperationCode);

   virtual tVoid vVisit_e8_CalibrationState(fi_tcl_e8_CalibrationState& oe8_CalibrationState);

   virtual tVoid vVisit_e8_DeadReckoningPositionState(fi_tcl_e8_DeadReckoningPositionState& oe8_DeadReckoningPositionState);

   virtual tVoid vVisit_s16_CentiDegreePerSecond(fi_tcl_s16_CentiDegreePerSecond& os16_CentiDegreePerSecond);

   virtual tVoid vVisit_ContourEqualProbability(fi_tcl_ContourEqualProbability& oContourEqualProbability);

   virtual tVoid vVisit_b16_SensorDataPhalanx(fi_tcl_b16_SensorDataPhalanx& ob16_SensorDataPhalanx);

   virtual tVoid vVisit_e8_MapMatchingRule(fi_tcl_e8_MapMatchingRule& oe8_MapMatchingRule);

   virtual tVoid vVisit_u32_SquareDecimeter(fi_tcl_u32_SquareDecimeter& ou32_SquareDecimeter);

   virtual tVoid vVisit_u32_Milliliter(fi_tcl_u32_Milliliter& ou32_Milliliter);

   virtual tVoid vVisit_u32_Microliter(fi_tcl_u32_Microliter& ou32_Microliter);

   virtual tVoid vVisit_e8_RouteCapabilityID(fi_tcl_e8_RouteCapabilityID& oe8_RouteCapabilityID);

   virtual tVoid vVisit_RouteCapability(fi_tcl_RouteCapability& oRouteCapability);

   virtual tVoid vVisit_e8_RouteOption(fi_tcl_e8_RouteOption& oe8_RouteOption);

   virtual tVoid vVisit_e8_RouteDestinationType(fi_tcl_e8_RouteDestinationType& oe8_RouteDestinationType);

   virtual tVoid vVisit_TripSegment(fi_tcl_TripSegment& oTripSegment);

   virtual tVoid vVisit_b8_AddTripSegmentParameters(fi_tcl_b8_AddTripSegmentParameters& ob8_AddTripSegmentParameters);

   virtual tVoid vVisit_e8_DynamicRouteCalcMode(fi_tcl_e8_DynamicRouteCalcMode& oe8_DynamicRouteCalcMode);

   virtual tVoid vVisit_CurrentRouteOption(fi_tcl_CurrentRouteOption& oCurrentRouteOption);

   virtual tVoid vVisit_AvailablePermission(fi_tcl_AvailablePermission& oAvailablePermission);

   virtual tVoid vVisit_e8_CalculationOrder(fi_tcl_e8_CalculationOrder& oe8_CalculationOrder);

   virtual tVoid vVisit_e8_CalculationCause(fi_tcl_e8_CalculationCause& oe8_CalculationCause);

   virtual tVoid vVisit_e8_CalculationMode(fi_tcl_e8_CalculationMode& oe8_CalculationMode);

   virtual tVoid vVisit_CalculationMode(fi_tcl_CalculationMode& oCalculationMode);

   virtual tVoid vVisit_AvailableManipSourcesOfSegment(fi_tcl_AvailableManipSourcesOfSegment& oAvailableManipSourcesOfSegment);

   virtual tVoid vVisit_ActiveManipSourcesOfSegment(fi_tcl_ActiveManipSourcesOfSegment& oActiveManipSourcesOfSegment);

   virtual tVoid vVisit_ActiveManipSourcesOfRoute(fi_tcl_ActiveManipSourcesOfRoute& oActiveManipSourcesOfRoute);

   virtual tVoid vVisit_TrafficMessageStatus(fi_tcl_TrafficMessageStatus& oTrafficMessageStatus);

   virtual tVoid vVisit_e8_SegmentSkippingMode(fi_tcl_e8_SegmentSkippingMode& oe8_SegmentSkippingMode);

   virtual tVoid vVisit_UserPermissionProfile(fi_tcl_UserPermissionProfile& oUserPermissionProfile);

   virtual tVoid vVisit_b8_DynamisationCause(fi_tcl_b8_DynamisationCause& ob8_DynamisationCause);

   virtual tVoid vVisit_RouteInfoElementValues(fi_tcl_RouteInfoElementValues& oRouteInfoElementValues);

   virtual tVoid vVisit_b32_RoadInfoProperties(fi_tcl_b32_RoadInfoProperties& ob32_RoadInfoProperties);

   virtual tVoid vVisit_RouteInfoElementStatus(fi_tcl_RouteInfoElementStatus& oRouteInfoElementStatus);

   virtual tVoid vVisit_FirstElement(fi_tcl_FirstElement& oFirstElement);

   virtual tVoid vVisit_EntryPointInfo(fi_tcl_EntryPointInfo& oEntryPointInfo);

   virtual tVoid vVisit_e8_RouteInfoCategory(fi_tcl_e8_RouteInfoCategory& oe8_RouteInfoCategory);

   virtual tVoid vVisit_RouteInfoElement(fi_tcl_RouteInfoElement& oRouteInfoElement);

   virtual tVoid vVisit_RouteInfoCategory(fi_tcl_RouteInfoCategory& oRouteInfoCategory);

   virtual tVoid vVisit_RouteInfoCategoryStatus(fi_tcl_RouteInfoCategoryStatus& oRouteInfoCategoryStatus);

   virtual tVoid vVisit_SingleRouteInfoStatus(fi_tcl_SingleRouteInfoStatus& oSingleRouteInfoStatus);

   virtual tVoid vVisit_UTMGroupNumberOnLengthList(fi_tcl_UTMGroupNumberOnLengthList& oUTMGroupNumberOnLengthList);

   virtual tVoid vVisit_UTMGroupNumberOnNameList(fi_tcl_UTMGroupNumberOnNameList& oUTMGroupNumberOnNameList);

   virtual tVoid vVisit_Destination(fi_tcl_Destination& oDestination);

   virtual tVoid vVisit_DestinationListSet(fi_tcl_DestinationListSet& oDestinationListSet);

   virtual tVoid vVisit_e8_Timezone(fi_tcl_e8_Timezone& oe8_Timezone);

   virtual tVoid vVisit_CodedCity(fi_tcl_CodedCity& oCodedCity);

   virtual tVoid vVisit_TabularWeatherLocation(fi_tcl_TabularWeatherLocation& oTabularWeatherLocation);

   virtual tVoid vVisit_OffRoadElementInfo(fi_tcl_OffRoadElementInfo& oOffRoadElementInfo);

   virtual tVoid vVisit_DistanceTimeInfo(fi_tcl_DistanceTimeInfo& oDistanceTimeInfo);

   virtual tVoid vVisit_RouteDistanceTimeInfo(fi_tcl_RouteDistanceTimeInfo& oRouteDistanceTimeInfo);

   virtual tVoid vVisit_e32_RouteCalculationErrorInfo(fi_tcl_e32_RouteCalculationErrorInfo& oe32_RouteCalculationErrorInfo);

   virtual tVoid vVisit_AvailableRouteOption(fi_tcl_AvailableRouteOption& oAvailableRouteOption);

   virtual tVoid vVisit_RouteSegmentDefinition(fi_tcl_RouteSegmentDefinition& oRouteSegmentDefinition);

   virtual tVoid vVisit_e8_TripSegmentStatus(fi_tcl_e8_TripSegmentStatus& oe8_TripSegmentStatus);

   virtual tVoid vVisit_TripSegmentStatus(fi_tcl_TripSegmentStatus& oTripSegmentStatus);

   virtual tVoid vVisit_RouteStatus(fi_tcl_RouteStatus& oRouteStatus);

   virtual tVoid vVisit_b8_RouteDifferenceStatus(fi_tcl_b8_RouteDifferenceStatus& ob8_RouteDifferenceStatus);

   virtual tVoid vVisit_b8_TravelValueValidity(fi_tcl_b8_TravelValueValidity& ob8_TravelValueValidity);

   virtual tVoid vVisit_e8_RouteBranchingType(fi_tcl_e8_RouteBranchingType& oe8_RouteBranchingType);

   virtual tVoid vVisit_RouteBranchingCoordinate(fi_tcl_RouteBranchingCoordinate& oRouteBranchingCoordinate);

   virtual tVoid vVisit_RouteValuesChange(fi_tcl_RouteValuesChange& oRouteValuesChange);

   virtual tVoid vVisit_e8_ProfileType(fi_tcl_e8_ProfileType& oe8_ProfileType);

   virtual tVoid vVisit_e8_NavAreaType(fi_tcl_e8_NavAreaType& oe8_NavAreaType);

   virtual tVoid vVisit_e8_VehicleType(fi_tcl_e8_VehicleType& oe8_VehicleType);

   virtual tVoid vVisit_Speedvector(fi_tcl_Speedvector& oSpeedvector);

   virtual tVoid vVisit_VehicleSpeedProfile(fi_tcl_VehicleSpeedProfile& oVehicleSpeedProfile);

   virtual tVoid vVisit_b8_CargoInfo(fi_tcl_b8_CargoInfo& ob8_CargoInfo);

   virtual tVoid vVisit_VehicleProfile(fi_tcl_VehicleProfile& oVehicleProfile);

   virtual tVoid vVisit_UserSpeedProfile(fi_tcl_UserSpeedProfile& oUserSpeedProfile);

   virtual tVoid vVisit_FuelConsumptionProfile(fi_tcl_FuelConsumptionProfile& oFuelConsumptionProfile);

   virtual tVoid vVisit_b8_ThresholdDefinitionProfile(fi_tcl_b8_ThresholdDefinitionProfile& ob8_ThresholdDefinitionProfile);

   virtual tVoid vVisit_ThresholdDefinitionProfile(fi_tcl_ThresholdDefinitionProfile& oThresholdDefinitionProfile);

   virtual tVoid vVisit_RouteHandleDescription(fi_tcl_RouteHandleDescription& oRouteHandleDescription);

   virtual tVoid vVisit_RouteDefinition(fi_tcl_RouteDefinition& oRouteDefinition);

   virtual tVoid vVisit_b8_SpeedProfiles(fi_tcl_b8_SpeedProfiles& ob8_SpeedProfiles);

   virtual tVoid vVisit_b8_UserProfiles(fi_tcl_b8_UserProfiles& ob8_UserProfiles);

   virtual tVoid vVisit_SpeedProfiles(fi_tcl_SpeedProfiles& oSpeedProfiles);

   virtual tVoid vVisit_e8_VehicleClass(fi_tcl_e8_VehicleClass& oe8_VehicleClass);

   virtual tVoid vVisit_e8_Gearbox(fi_tcl_e8_Gearbox& oe8_Gearbox);

   virtual tVoid vVisit_e8_DriveMode(fi_tcl_e8_DriveMode& oe8_DriveMode);

   virtual tVoid vVisit_VehicleParameter(fi_tcl_VehicleParameter& oVehicleParameter);

   virtual tVoid vVisit_e8_DriverType(fi_tcl_e8_DriverType& oe8_DriverType);

   virtual tVoid vVisit_DriverParameter(fi_tcl_DriverParameter& oDriverParameter);

   virtual tVoid vVisit_GreenProfile(fi_tcl_GreenProfile& oGreenProfile);

   virtual tVoid vVisit_UserProfiles(fi_tcl_UserProfiles& oUserProfiles);

   virtual tVoid vVisit_e8_MapDestinationType(fi_tcl_e8_MapDestinationType& oe8_MapDestinationType);

   virtual tVoid vVisit_MapDestination(fi_tcl_MapDestination& oMapDestination);

   virtual tVoid vVisit_MapOneCellDesc(fi_tcl_MapOneCellDesc& oMapOneCellDesc);

#ifndef FI_S_EXTERNAL_FI
   virtual tVoid vVisit_MapRouteBinContainer(fi_tcl_MapRouteBinContainer& oMapRouteBinContainer);

#endif // FI_S_EXTERNAL_FI
   virtual tVoid vVisit_TimeDuration(fi_tcl_TimeDuration& oTimeDuration);

   virtual tVoid vVisit_e8_TimeDependentClosureType(fi_tcl_e8_TimeDependentClosureType& oe8_TimeDependentClosureType);

   virtual tVoid vVisit_TimeDependentClosure(fi_tcl_TimeDependentClosure& oTimeDependentClosure);

   virtual tVoid vVisit_TimeDependentClosureListSet(fi_tcl_TimeDependentClosureListSet& oTimeDependentClosureListSet);

   virtual tVoid vVisit_e8_RCalcProcessStatus(fi_tcl_e8_RCalcProcessStatus& oe8_RCalcProcessStatus);

   virtual tVoid vVisit_b32_CalculationProperties(fi_tcl_b32_CalculationProperties& ob32_CalculationProperties);

   virtual tVoid vVisit_NavRouteCalcProperty(fi_tcl_NavRouteCalcProperty& oNavRouteCalcProperty);

   virtual tVoid vVisit_GlueAreaDesc(fi_tcl_GlueAreaDesc& oGlueAreaDesc);

   virtual tVoid vVisit_e8_DataAccessibility(fi_tcl_e8_DataAccessibility& oe8_DataAccessibility);

   virtual tVoid vVisit_e8_NavRCalcRouteStartPoint(fi_tcl_e8_NavRCalcRouteStartPoint& oe8_NavRCalcRouteStartPoint);

   virtual tVoid vVisit_NavRCalcRouteStartPointUnionType(fi_tcl_NavRCalcRouteStartPointUnionType& oNavRCalcRouteStartPointUnionType);

   virtual tVoid vVisit_NavRCalcPositionDesc(fi_tcl_NavRCalcPositionDesc& oNavRCalcPositionDesc);

   virtual tVoid vVisit_NavRCalcCarPosition(fi_tcl_NavRCalcCarPosition& oNavRCalcCarPosition);

   virtual tVoid vVisit_NavSubDestinationList(fi_tcl_NavSubDestinationList& oNavSubDestinationList);

   virtual tVoid vVisit_e8_LoadStrategy(fi_tcl_e8_LoadStrategy& oe8_LoadStrategy);

   virtual tVoid vVisit_LoadStrategy(fi_tcl_LoadStrategy& oLoadStrategy);

   virtual tVoid vVisit_e8_StrategyStatus(fi_tcl_e8_StrategyStatus& oe8_StrategyStatus);

   virtual tVoid vVisit_StrategyStatus(fi_tcl_StrategyStatus& oStrategyStatus);

   virtual tVoid vVisit_EvaluatedPosition(fi_tcl_EvaluatedPosition& oEvaluatedPosition);

   virtual tVoid vVisit_e8_DepictionArea(fi_tcl_e8_DepictionArea& oe8_DepictionArea);

   virtual tVoid vVisit_DepictionArea(fi_tcl_DepictionArea& oDepictionArea);

   virtual tVoid vVisit_DepictComplete(fi_tcl_DepictComplete& oDepictComplete);

   virtual tVoid vVisit_DepictLength(fi_tcl_DepictLength& oDepictLength);

   virtual tVoid vVisit_DepictPolygon(fi_tcl_DepictPolygon& oDepictPolygon);

   virtual tVoid vVisit_e8_DepictionQuantityState(fi_tcl_e8_DepictionQuantityState& oe8_DepictionQuantityState);

   virtual tVoid vVisit_DepictionQuantityState(fi_tcl_DepictionQuantityState& oDepictionQuantityState);

   virtual tVoid vVisit_DepictedComplete(fi_tcl_DepictedComplete& oDepictedComplete);

   virtual tVoid vVisit_DepictedPartLength(fi_tcl_DepictedPartLength& oDepictedPartLength);

   virtual tVoid vVisit_DepictedPartPolygon(fi_tcl_DepictedPartPolygon& oDepictedPartPolygon);

   virtual tVoid vVisit_b8_DepictionModeSettings(fi_tcl_b8_DepictionModeSettings& ob8_DepictionModeSettings);

   virtual tVoid vVisit_DepictionModeSettings(fi_tcl_DepictionModeSettings& oDepictionModeSettings);

   virtual tVoid vVisit_e8_DepictionDirectionMode(fi_tcl_e8_DepictionDirectionMode& oe8_DepictionDirectionMode);

   virtual tVoid vVisit_b8_DepictionResult(fi_tcl_b8_DepictionResult& ob8_DepictionResult);

   virtual tVoid vVisit_CntDepictResultElem(fi_tcl_CntDepictResultElem& oCntDepictResultElem);

   virtual tVoid vVisit_PathListToDepict(fi_tcl_PathListToDepict& oPathListToDepict);

   virtual tVoid vVisit_PathDataListSetToDepict(fi_tcl_PathDataListSetToDepict& oPathDataListSetToDepict);

   virtual tVoid vVisit_NavDLDOneCellProperty(fi_tcl_NavDLDOneCellProperty& oNavDLDOneCellProperty);

   virtual tVoid vVisit_NavDLDOneCellDesc(fi_tcl_NavDLDOneCellDesc& oNavDLDOneCellDesc);

   virtual tVoid vVisit_NavDLDepictedPSOneCellList(fi_tcl_NavDLDepictedPSOneCellList& oNavDLDepictedPSOneCellList);

   virtual tVoid vVisit_DepictedNavDataLevelListSet(fi_tcl_DepictedNavDataLevelListSet& oDepictedNavDataLevelListSet);

   virtual tVoid vVisit_DepictedDataPathListSet(fi_tcl_DepictedDataPathListSet& oDepictedDataPathListSet);

   virtual tVoid vVisit_b8_RouteSegmentCLTypes(fi_tcl_b8_RouteSegmentCLTypes& ob8_RouteSegmentCLTypes);

   virtual tVoid vVisit_RouteSegmentCL(fi_tcl_RouteSegmentCL& oRouteSegmentCL);

   virtual tVoid vVisit_LocationBranchCL(fi_tcl_LocationBranchCL& oLocationBranchCL);

   virtual tVoid vVisit_DestinationBranchCL(fi_tcl_DestinationBranchCL& oDestinationBranchCL);

   virtual tVoid vVisit_DestinationCL(fi_tcl_DestinationCL& oDestinationCL);

   virtual tVoid vVisit_RegionStatus(fi_tcl_RegionStatus& oRegionStatus);

   virtual tVoid vVisit_e8_ResumeMode(fi_tcl_e8_ResumeMode& oe8_ResumeMode);

   virtual tVoid vVisit_e8_ResumedOperation(fi_tcl_e8_ResumedOperation& oe8_ResumedOperation);

   virtual tVoid vVisit_Rfd_BaselineFiles(fi_tcl_Rfd_BaselineFiles& oRfd_BaselineFiles);

   virtual tVoid vVisit_e8_Rfd_CCAError(fi_tcl_e8_Rfd_CCAError& oe8_Rfd_CCAError);

   virtual tVoid vVisit_e8_Rfd_ServiceStatus(fi_tcl_e8_Rfd_ServiceStatus& oe8_Rfd_ServiceStatus);

   virtual tVoid vVisit_e8_UpdateState(fi_tcl_e8_UpdateState& oe8_UpdateState);

   virtual tVoid vVisit_e8_SxmProtocol(fi_tcl_e8_SxmProtocol& oe8_SxmProtocol);

   virtual tVoid vVisit_DevicePathForProtocol(fi_tcl_DevicePathForProtocol& oDevicePathForProtocol);

   virtual tVoid vVisit_SxmFile(fi_tcl_SxmFile& oSxmFile);

   virtual tVoid vVisit_FilesForProtocol(fi_tcl_FilesForProtocol& oFilesForProtocol);

   virtual tVoid vVisit_e8_MetricSystem(fi_tcl_e8_MetricSystem& oe8_MetricSystem);

   virtual tVoid vVisit_b8_GuidanceMode(fi_tcl_b8_GuidanceMode& ob8_GuidanceMode);

   virtual tVoid vVisit_b8_GuidanceStatus(fi_tcl_b8_GuidanceStatus& ob8_GuidanceStatus);

   virtual tVoid vVisit_e8_DataCarrierRequestStatus(fi_tcl_e8_DataCarrierRequestStatus& oe8_DataCarrierRequestStatus);

   virtual tVoid vVisit_e8_GuidanceElement(fi_tcl_e8_GuidanceElement& oe8_GuidanceElement);

   virtual tVoid vVisit_b8_GuidanceElementAttribute(fi_tcl_b8_GuidanceElementAttribute& ob8_GuidanceElementAttribute);

   virtual tVoid vVisit_RoadNameList(fi_tcl_RoadNameList& oRoadNameList);

   virtual tVoid vVisit_RoadNumberList(fi_tcl_RoadNumberList& oRoadNumberList);

   virtual tVoid vVisit_SignPostElementList(fi_tcl_SignPostElementList& oSignPostElementList);

   virtual tVoid vVisit_TrafficSignElementList(fi_tcl_TrafficSignElementList& oTrafficSignElementList);

   virtual tVoid vVisit_IntersectionDescElementList(fi_tcl_IntersectionDescElementList& oIntersectionDescElementList);

   virtual tVoid vVisit_e8_GuidanceDescriptorInfoCategory(fi_tcl_e8_GuidanceDescriptorInfoCategory& oe8_GuidanceDescriptorInfoCategory);

   virtual tVoid vVisit_GuidanceDescriptorInfoCategory(fi_tcl_GuidanceDescriptorInfoCategory& oGuidanceDescriptorInfoCategory);

   virtual tVoid vVisit_GuidanceDescriptorInfoCategoryRefElement(fi_tcl_GuidanceDescriptorInfoCategoryRefElement& oGuidanceDescriptorInfoCategoryRefElement);

   virtual tVoid vVisit_e8_GuidanceSymbol(fi_tcl_e8_GuidanceSymbol& oe8_GuidanceSymbol);

   virtual tVoid vVisit_GuidanceElement(fi_tcl_GuidanceElement& oGuidanceElement);

   virtual tVoid vVisit_e8_GuidanceStatusSymbol(fi_tcl_e8_GuidanceStatusSymbol& oe8_GuidanceStatusSymbol);

   virtual tVoid vVisit_SideRoad(fi_tcl_SideRoad& oSideRoad);

   virtual tVoid vVisit_CombinedStatus(fi_tcl_CombinedStatus& oCombinedStatus);

   virtual tVoid vVisit_SingleRoadInfoElementList(fi_tcl_SingleRoadInfoElementList& oSingleRoadInfoElementList);

   virtual tVoid vVisit_b8_GuidanceSymbolAttributes(fi_tcl_b8_GuidanceSymbolAttributes& ob8_GuidanceSymbolAttributes);

   virtual tVoid vVisit_Crossing(fi_tcl_Crossing& oCrossing);

   virtual tVoid vVisit_e8_GuidanceManoeuvreSymbol(fi_tcl_e8_GuidanceManoeuvreSymbol& oe8_GuidanceManoeuvreSymbol);

   virtual tVoid vVisit_e8_GuidanceManoeuvreType(fi_tcl_e8_GuidanceManoeuvreType& oe8_GuidanceManoeuvreType);

   virtual tVoid vVisit_GuidanceManoeuvreBaseSymbol(fi_tcl_GuidanceManoeuvreBaseSymbol& oGuidanceManoeuvreBaseSymbol);

   virtual tVoid vVisit_GuidanceManoeuvreSymbol(fi_tcl_GuidanceManoeuvreSymbol& oGuidanceManoeuvreSymbol);

   virtual tVoid vVisit_b8_GuidanceSymbolStatus(fi_tcl_b8_GuidanceSymbolStatus& ob8_GuidanceSymbolStatus);

   virtual tVoid vVisit_GuidanceManoeuvreSymbolList(fi_tcl_GuidanceManoeuvreSymbolList& oGuidanceManoeuvreSymbolList);

   virtual tVoid vVisit_EntryPointSymbol(fi_tcl_EntryPointSymbol& oEntryPointSymbol);

   virtual tVoid vVisit_e8_GuidanceDestinationType(fi_tcl_e8_GuidanceDestinationType& oe8_GuidanceDestinationType);

   virtual tVoid vVisit_DestinationReachedSymbol(fi_tcl_DestinationReachedSymbol& oDestinationReachedSymbol);

   virtual tVoid vVisit_e8_RoundaboutSymbolType(fi_tcl_e8_RoundaboutSymbolType& oe8_RoundaboutSymbolType);

   virtual tVoid vVisit_RoundaboutSideRoad(fi_tcl_RoundaboutSideRoad& oRoundaboutSideRoad);

   virtual tVoid vVisit_RoundaboutSymbol(fi_tcl_RoundaboutSymbol& oRoundaboutSymbol);

   virtual tVoid vVisit_CriticalManoeuvreInfo(fi_tcl_CriticalManoeuvreInfo& oCriticalManoeuvreInfo);

   virtual tVoid vVisit_e8_TurnToSymbol(fi_tcl_e8_TurnToSymbol& oe8_TurnToSymbol);

   virtual tVoid vVisit_TurnToSymbol(fi_tcl_TurnToSymbol& oTurnToSymbol);

   virtual tVoid vVisit_LaneChangeSymbol(fi_tcl_LaneChangeSymbol& oLaneChangeSymbol);

   virtual tVoid vVisit_AbstractTurnSymbol(fi_tcl_AbstractTurnSymbol& oAbstractTurnSymbol);

   virtual tVoid vVisit_BargraphDistance(fi_tcl_BargraphDistance& oBargraphDistance);

   virtual tVoid vVisit_GuidanceManeuverElement(fi_tcl_GuidanceManeuverElement& oGuidanceManeuverElement);

   virtual tVoid vVisit_RoadDescription(fi_tcl_RoadDescription& oRoadDescription);

   virtual tVoid vVisit_GuidanceMapManeuverElement(fi_tcl_GuidanceMapManeuverElement& oGuidanceMapManeuverElement);

   virtual tVoid vVisit_b8_GuidanceMessageCategory(fi_tcl_b8_GuidanceMessageCategory& ob8_GuidanceMessageCategory);

   virtual tVoid vVisit_b8_WarningPointStatus(fi_tcl_b8_WarningPointStatus& ob8_WarningPointStatus);

   virtual tVoid vVisit_b8_HorizonEventStatus(fi_tcl_b8_HorizonEventStatus& ob8_HorizonEventStatus);

   virtual tVoid vVisit_e16_EffectCode(fi_tcl_e16_EffectCode& oe16_EffectCode);

   virtual tVoid vVisit_e16_CauseCode(fi_tcl_e16_CauseCode& oe16_CauseCode);

   virtual tVoid vVisit_e8_SpeedLimitExceedingStatus(fi_tcl_e8_SpeedLimitExceedingStatus& oe8_SpeedLimitExceedingStatus);

   virtual tVoid vVisit_SpeedLimitSign(fi_tcl_SpeedLimitSign& oSpeedLimitSign);

   virtual tVoid vVisit_e8_WarningSignCriticality(fi_tcl_e8_WarningSignCriticality& oe8_WarningSignCriticality);

   virtual tVoid vVisit_WarningSign(fi_tcl_WarningSign& oWarningSign);

   virtual tVoid vVisit_POI(fi_tcl_POI& oPOI);

   virtual tVoid vVisit_e8_RoadAttriuteInfo(fi_tcl_e8_RoadAttriuteInfo& oe8_RoadAttriuteInfo);

   virtual tVoid vVisit_RoadAttributeInfo(fi_tcl_RoadAttributeInfo& oRoadAttributeInfo);

   virtual tVoid vVisit_RequiredPermissionInfo(fi_tcl_RequiredPermissionInfo& oRequiredPermissionInfo);

   virtual tVoid vVisit_e8_WarningPointDataType(fi_tcl_e8_WarningPointDataType& oe8_WarningPointDataType);

   virtual tVoid vVisit_e8_HorizonEventDataType(fi_tcl_e8_HorizonEventDataType& oe8_HorizonEventDataType);

   virtual tVoid vVisit_UPOI(fi_tcl_UPOI& oUPOI);

   virtual tVoid vVisit_NextWarningPoint(fi_tcl_NextWarningPoint& oNextWarningPoint);

   virtual tVoid vVisit_e8_TEAEventType(fi_tcl_e8_TEAEventType& oe8_TEAEventType);

   virtual tVoid vVisit_b8_WarningsOnHorizonMode(fi_tcl_b8_WarningsOnHorizonMode& ob8_WarningsOnHorizonMode);

   virtual tVoid vVisit_e8_MultiMediaFunction(fi_tcl_e8_MultiMediaFunction& oe8_MultiMediaFunction);

   virtual tVoid vVisit_e8_MultiMediaType(fi_tcl_e8_MultiMediaType& oe8_MultiMediaType);

   virtual tVoid vVisit_e8_MultiMediaStatus(fi_tcl_e8_MultiMediaStatus& oe8_MultiMediaStatus);

   virtual tVoid vVisit_MultiMediaDescriptor(fi_tcl_MultiMediaDescriptor& oMultiMediaDescriptor);

   virtual tVoid vVisit_MultiMediaElement(fi_tcl_MultiMediaElement& oMultiMediaElement);

   virtual tVoid vVisit_NEVList(fi_tcl_NEVList& oNEVList);

   virtual tVoid vVisit_b16_FunctionalityGroupRouteInfo(fi_tcl_b16_FunctionalityGroupRouteInfo& ob16_FunctionalityGroupRouteInfo);

   virtual tVoid vVisit_b16_FunctionalityGroupDestinationInfo(fi_tcl_b16_FunctionalityGroupDestinationInfo& ob16_FunctionalityGroupDestinationInfo);

   virtual tVoid vVisit_b16_FunctionalityGroupDrivingRecommendation(fi_tcl_b16_FunctionalityGroupDrivingRecommendation& ob16_FunctionalityGroupDrivingRecommendation);

   virtual tVoid vVisit_b16_FunctionalityGroupCorridorInfo(fi_tcl_b16_FunctionalityGroupCorridorInfo& ob16_FunctionalityGroupCorridorInfo);

   virtual tVoid vVisit_b16_FunctionalityGroupHorizonInfoTrafficMessage(fi_tcl_b16_FunctionalityGroupHorizonInfoTrafficMessage& ob16_FunctionalityGroupHorizonInfoTrafficMessage);

   virtual tVoid vVisit_b16_FunctionalityGroupHorizonInfoSpeedLimit(fi_tcl_b16_FunctionalityGroupHorizonInfoSpeedLimit& ob16_FunctionalityGroupHorizonInfoSpeedLimit);

   virtual tVoid vVisit_b16_FunctionalityGroupHorizonInfoWarningSign(fi_tcl_b16_FunctionalityGroupHorizonInfoWarningSign& ob16_FunctionalityGroupHorizonInfoWarningSign);

   virtual tVoid vVisit_b16_FunctionalityGroupHorizonInfoPOI(fi_tcl_b16_FunctionalityGroupHorizonInfoPOI& ob16_FunctionalityGroupHorizonInfoPOI);

   virtual tVoid vVisit_b16_FunctionalityGroupHorizonInfoRoadAttribute(fi_tcl_b16_FunctionalityGroupHorizonInfoRoadAttribute& ob16_FunctionalityGroupHorizonInfoRoadAttribute);

   virtual tVoid vVisit_b16_FunctionalityGroupHorizonInfoCurve(fi_tcl_b16_FunctionalityGroupHorizonInfoCurve& ob16_FunctionalityGroupHorizonInfoCurve);

   virtual tVoid vVisit_b16_FunctionalityGroupDriverSpeedAdvice(fi_tcl_b16_FunctionalityGroupDriverSpeedAdvice& ob16_FunctionalityGroupDriverSpeedAdvice);

   virtual tVoid vVisit_e8_ThreeStateValue(fi_tcl_e8_ThreeStateValue& oe8_ThreeStateValue);

   virtual tVoid vVisit_b16_HorizonEventTrafficSignSettings(fi_tcl_b16_HorizonEventTrafficSignSettings& ob16_HorizonEventTrafficSignSettings);

   virtual tVoid vVisit_HorizonEventsFilter_TrafficSign(fi_tcl_HorizonEventsFilter_TrafficSign& oHorizonEventsFilter_TrafficSign);

   virtual tVoid vVisit_b16_FunctionalityGroupHorizonInfoTollBooth(fi_tcl_b16_FunctionalityGroupHorizonInfoTollBooth& ob16_FunctionalityGroupHorizonInfoTollBooth);

   virtual tVoid vVisit_b32_HorizonEventFilterPOI(fi_tcl_b32_HorizonEventFilterPOI& ob32_HorizonEventFilterPOI);

   virtual tVoid vVisit_b8_TrafficMessageSettings(fi_tcl_b8_TrafficMessageSettings& ob8_TrafficMessageSettings);

   virtual tVoid vVisit_HorizonEvent_TMConfiguration(fi_tcl_HorizonEvent_TMConfiguration& oHorizonEvent_TMConfiguration);

   virtual tVoid vVisit_HorizonEventsFilter_TrafficMessage(fi_tcl_HorizonEventsFilter_TrafficMessage& oHorizonEventsFilter_TrafficMessage);

   virtual tVoid vVisit_HorizonEventsFilter_POI(fi_tcl_HorizonEventsFilter_POI& oHorizonEventsFilter_POI);

   virtual tVoid vVisit_HorizonEventsFilter_TollBooth(fi_tcl_HorizonEventsFilter_TollBooth& oHorizonEventsFilter_TollBooth);

   virtual tVoid vVisit_HorizonEventsFilter_RoadAttribute(fi_tcl_HorizonEventsFilter_RoadAttribute& oHorizonEventsFilter_RoadAttribute);

   virtual tVoid vVisit_DriverSpeedAdviceConfiguration(fi_tcl_DriverSpeedAdviceConfiguration& oDriverSpeedAdviceConfiguration);

   virtual tVoid vVisit_HorizonEventsFilter(fi_tcl_HorizonEventsFilter& oHorizonEventsFilter);

   virtual tVoid vVisit_SpeedLimitParameter(fi_tcl_SpeedLimitParameter& oSpeedLimitParameter);

   virtual tVoid vVisit_e8_DriverAdviceType(fi_tcl_e8_DriverAdviceType& oe8_DriverAdviceType);

   virtual tVoid vVisit_e8_DriverActionFeedback(fi_tcl_e8_DriverActionFeedback& oe8_DriverActionFeedback);

   virtual tVoid vVisit_b32_PredictiveCCMode(fi_tcl_b32_PredictiveCCMode& ob32_PredictiveCCMode);

   virtual tVoid vVisit_b32_PredictiveCC_ControlBits(fi_tcl_b32_PredictiveCC_ControlBits& ob32_PredictiveCC_ControlBits);

   virtual tVoid vVisit_e8_SpeedLimitLocation(fi_tcl_e8_SpeedLimitLocation& oe8_SpeedLimitLocation);

   virtual tVoid vVisit_LocDepSpeedLimitExceeding(fi_tcl_LocDepSpeedLimitExceeding& oLocDepSpeedLimitExceeding);

   virtual tVoid vVisit_e8_VoiceGender(fi_tcl_e8_VoiceGender& oe8_VoiceGender);

   virtual tVoid vVisit_Language(fi_tcl_Language& oLanguage);

   virtual tVoid vVisit_e8_Sentence(fi_tcl_e8_Sentence& oe8_Sentence);

   virtual tVoid vVisit_e8_SpeechFeature(fi_tcl_e8_SpeechFeature& oe8_SpeechFeature);

   virtual tVoid vVisit_e8_SpeechStatus(fi_tcl_e8_SpeechStatus& oe8_SpeechStatus);

   virtual tVoid vVisit_e8_DebugSound(fi_tcl_e8_DebugSound& oe8_DebugSound);

   virtual tVoid vVisit_u32_StateManagerHandle(fi_tcl_u32_StateManagerHandle& ou32_StateManagerHandle);

   virtual tVoid vVisit_e32_SystemState(fi_tcl_e32_SystemState& oe32_SystemState);

   virtual tVoid vVisit_NavAppState(fi_tcl_NavAppState& oNavAppState);

   virtual tVoid vVisit_e32_ShutdownLevel(fi_tcl_e32_ShutdownLevel& oe32_ShutdownLevel);

   virtual tVoid vVisit_OnroadOffroadPositions(fi_tcl_OnroadOffroadPositions& oOnroadOffroadPositions);

   virtual tVoid vVisit_b8_BreadCrumbTypes(fi_tcl_b8_BreadCrumbTypes& ob8_BreadCrumbTypes);

   virtual tVoid vVisit_b8_ProfileDataType(fi_tcl_b8_ProfileDataType& ob8_ProfileDataType);

   virtual tVoid vVisit_b8_ProfileStatus(fi_tcl_b8_ProfileStatus& ob8_ProfileStatus);

   virtual tVoid vVisit_CountryTimes(fi_tcl_CountryTimes& oCountryTimes);

   virtual tVoid vVisit_b8_StatPosStatusInfo(fi_tcl_b8_StatPosStatusInfo& ob8_StatPosStatusInfo);

   virtual tVoid vVisit_ProfileData(fi_tcl_ProfileData& oProfileData);

   virtual tVoid vVisit_ProfileDataList(fi_tcl_ProfileDataList& oProfileDataList);

   virtual tVoid vVisit_e8_AuthorisationStatus(fi_tcl_e8_AuthorisationStatus& oe8_AuthorisationStatus);

   virtual tVoid vVisit_e8_SigStatus(fi_tcl_e8_SigStatus& oe8_SigStatus);

   virtual tVoid vVisit_e8_AuthStatus(fi_tcl_e8_AuthStatus& oe8_AuthStatus);

   virtual tVoid vVisit_e8_SXMSignalStatus(fi_tcl_e8_SXMSignalStatus& oe8_SXMSignalStatus);

   virtual tVoid vVisit_FuelPriceData(fi_tcl_FuelPriceData& oFuelPriceData);

   virtual tVoid vVisit_e8_AuthorizationStatus(fi_tcl_e8_AuthorizationStatus& oe8_AuthorizationStatus);

   virtual tVoid vVisit_e8_SignalStatus(fi_tcl_e8_SignalStatus& oe8_SignalStatus);

   virtual tVoid vVisit_e8_MethodResult(fi_tcl_e8_MethodResult& oe8_MethodResult);

   virtual tVoid vVisit_e8_UpdateType(fi_tcl_e8_UpdateType& oe8_UpdateType);

   virtual tVoid vVisit_e8_AlertPrio(fi_tcl_e8_AlertPrio& oe8_AlertPrio);

   virtual tVoid vVisit_Capabilities(fi_tcl_Capabilities& oCapabilities);

   virtual tVoid vVisit_AU_Index(fi_tcl_AU_Index& oAU_Index);

   virtual tVoid vVisit_GraphicalInfo(fi_tcl_GraphicalInfo& oGraphicalInfo);

   virtual tVoid vVisit_e8_SXMTileType(fi_tcl_e8_SXMTileType& oe8_SXMTileType);

   virtual tVoid vVisit_e8_SXMShapeType(fi_tcl_e8_SXMShapeType& oe8_SXMShapeType);

   virtual tVoid vVisit_e8_SXMTileDataType(fi_tcl_e8_SXMTileDataType& oe8_SXMTileDataType);

   virtual tVoid vVisit_SXMSharedMemoryDescription(fi_tcl_SXMSharedMemoryDescription& oSXMSharedMemoryDescription);

   virtual tVoid vVisit_SXMSharedMemoryTile(fi_tcl_SXMSharedMemoryTile& oSXMSharedMemoryTile);

   virtual tVoid vVisit_SXMShape(fi_tcl_SXMShape& oSXMShape);

   virtual tVoid vVisit_e8_FrontType(fi_tcl_e8_FrontType& oe8_FrontType);

   virtual tVoid vVisit_e8_PressureType(fi_tcl_e8_PressureType& oe8_PressureType);

   virtual tVoid vVisit_SXMShapeTypeIsobar(fi_tcl_SXMShapeTypeIsobar& oSXMShapeTypeIsobar);

   virtual tVoid vVisit_SXMShapeTypeWindRadius(fi_tcl_SXMShapeTypeWindRadius& oSXMShapeTypeWindRadius);

   virtual tVoid vVisit_e8_StormPositionType(fi_tcl_e8_StormPositionType& oe8_StormPositionType);

   virtual tVoid vVisit_e8_StormType(fi_tcl_e8_StormType& oe8_StormType);

   virtual tVoid vVisit_b8_StormType(fi_tcl_b8_StormType& ob8_StormType);

   virtual tVoid vVisit_SXMShapeTypeStormAttributes(fi_tcl_SXMShapeTypeStormAttributes& oSXMShapeTypeStormAttributes);

   virtual tVoid vVisit_SXMShapeTypeFront(fi_tcl_SXMShapeTypeFront& oSXMShapeTypeFront);

   virtual tVoid vVisit_SXMShapeTypePressureCenter(fi_tcl_SXMShapeTypePressureCenter& oSXMShapeTypePressureCenter);

   virtual tVoid vVisit_SXMShapeTypeStormPosition(fi_tcl_SXMShapeTypeStormPosition& oSXMShapeTypeStormPosition);

   virtual tVoid vVisit_SXMShapeTypeStormTrack(fi_tcl_SXMShapeTypeStormTrack& oSXMShapeTypeStormTrack);

   virtual tVoid vVisit_b8_TEAPresenceIndicator(fi_tcl_b8_TEAPresenceIndicator& ob8_TEAPresenceIndicator);

   virtual tVoid vVisit_b32_RoadInfoCategoryIndicator(fi_tcl_b32_RoadInfoCategoryIndicator& ob32_RoadInfoCategoryIndicator);

   virtual tVoid vVisit_e8_HorizonRoadInfoCategory(fi_tcl_e8_HorizonRoadInfoCategory& oe8_HorizonRoadInfoCategory);

   virtual tVoid vVisit_HorizonRoadInfoUnion(fi_tcl_HorizonRoadInfoUnion& oHorizonRoadInfoUnion);

   virtual tVoid vVisit_b8_CurvatureStatus(fi_tcl_b8_CurvatureStatus& ob8_CurvatureStatus);

   virtual tVoid vVisit_Curvature(fi_tcl_Curvature& oCurvature);

   virtual tVoid vVisit_CurvatureList(fi_tcl_CurvatureList& oCurvatureList);

   virtual tVoid vVisit_e8_MPPState(fi_tcl_e8_MPPState& oe8_MPPState);

   virtual tVoid vVisit_MPPData(fi_tcl_MPPData& oMPPData);

   virtual tVoid vVisit_b8_TEAOneCellSectionInfo(fi_tcl_b8_TEAOneCellSectionInfo& ob8_TEAOneCellSectionInfo);

   virtual tVoid vVisit_b8_FurtherInfoUnion(fi_tcl_b8_FurtherInfoUnion& ob8_FurtherInfoUnion);

   virtual tVoid vVisit_u8_SlopePercent(fi_tcl_u8_SlopePercent& ou8_SlopePercent);

   virtual tVoid vVisit_AlternativTEAEventIDList(fi_tcl_AlternativTEAEventIDList& oAlternativTEAEventIDList);

   virtual tVoid vVisit_TEAEventID(fi_tcl_TEAEventID& oTEAEventID);

   virtual tVoid vVisit_HorizonEvent(fi_tcl_HorizonEvent& oHorizonEvent);

   virtual tVoid vVisit_e8_TMLocationType(fi_tcl_e8_TMLocationType& oe8_TMLocationType);

   virtual tVoid vVisit_e8_Tendency(fi_tcl_e8_Tendency& oe8_Tendency);

   virtual tVoid vVisit_TMEvent(fi_tcl_TMEvent& oTMEvent);

   virtual tVoid vVisit_TMInfo(fi_tcl_TMInfo& oTMInfo);

   virtual tVoid vVisit_TMCodedMessage(fi_tcl_TMCodedMessage& oTMCodedMessage);

#ifndef FI_S_EXTERNAL_FI
   virtual tVoid vVisit_TMCodedMessageBinContainer(fi_tcl_TMCodedMessageBinContainer& oTMCodedMessageBinContainer);

#endif // FI_S_EXTERNAL_FI
   virtual tVoid vVisit_TrafficMessage(fi_tcl_TrafficMessage& oTrafficMessage);

   virtual tVoid vVisit_ISORDBId(fi_tcl_ISORDBId& oISORDBId);

   virtual tVoid vVisit_TMInfoReference(fi_tcl_TMInfoReference& oTMInfoReference);

   virtual tVoid vVisit_NextTrafficEvent(fi_tcl_NextTrafficEvent& oNextTrafficEvent);

   virtual tVoid vVisit_TMCodedTextReference(fi_tcl_TMCodedTextReference& oTMCodedTextReference);

   virtual tVoid vVisit_TMInfoListSet(fi_tcl_TMInfoListSet& oTMInfoListSet);

   virtual tVoid vVisit_b16_TMSubstantialInformation(fi_tcl_b16_TMSubstantialInformation& ob16_TMSubstantialInformation);

   virtual tVoid vVisit_TMUrgencyStatistics(fi_tcl_TMUrgencyStatistics& oTMUrgencyStatistics);

   virtual tVoid vVisit_b8_TrafficMessageSourceAvailability(fi_tcl_b8_TrafficMessageSourceAvailability& ob8_TrafficMessageSourceAvailability);

   virtual tVoid vVisit_e8_TMHazardLocationAccuracy(fi_tcl_e8_TMHazardLocationAccuracy& oe8_TMHazardLocationAccuracy);

   virtual tVoid vVisit_e8_TMReliability(fi_tcl_e8_TMReliability& oe8_TMReliability);

   virtual tVoid vVisit_e8_TMHazardLocationDynamics(fi_tcl_e8_TMHazardLocationDynamics& oe8_TMHazardLocationDynamics);

   virtual tVoid vVisit_e8_TMQuantifierType(fi_tcl_e8_TMQuantifierType& oe8_TMQuantifierType);

   virtual tVoid vVisit_e8_TMExtendedFlowImpact(fi_tcl_e8_TMExtendedFlowImpact& oe8_TMExtendedFlowImpact);

   virtual tVoid vVisit_TrafficMsgMemoryStatisticsPerType(fi_tcl_TrafficMsgMemoryStatisticsPerType& oTrafficMsgMemoryStatisticsPerType);

   virtual tVoid vVisit_TrafficMsgMemoryStatistics(fi_tcl_TrafficMsgMemoryStatistics& oTrafficMsgMemoryStatistics);

   virtual tVoid vVisit_ISORDBIdAvailability(fi_tcl_ISORDBIdAvailability& oISORDBIdAvailability);

   virtual tVoid vVisit_TMStatistics(fi_tcl_TMStatistics& oTMStatistics);

   virtual tVoid vVisit_e8_TMSegmentType(fi_tcl_e8_TMSegmentType& oe8_TMSegmentType);

   virtual tVoid vVisit_e8_TMSegmentSubType(fi_tcl_e8_TMSegmentSubType& oe8_TMSegmentSubType);

   virtual tVoid vVisit_TMDescription(fi_tcl_TMDescription& oTMDescription);

   virtual tVoid vVisit_TMRequirementFulfilment(fi_tcl_TMRequirementFulfilment& oTMRequirementFulfilment);

   virtual tVoid vVisit_TMPreciseLocationDescription(fi_tcl_TMPreciseLocationDescription& oTMPreciseLocationDescription);

   virtual tVoid vVisit_TMChangedMessage(fi_tcl_TMChangedMessage& oTMChangedMessage);

   virtual tVoid vVisit_e8_RequestFailureReason(fi_tcl_e8_RequestFailureReason& oe8_RequestFailureReason);

   virtual tVoid vVisit_b8_RequestStatus(fi_tcl_b8_RequestStatus& ob8_RequestStatus);

   virtual tVoid vVisit_RDBIDLocationListErrors(fi_tcl_RDBIDLocationListErrors& oRDBIDLocationListErrors);

   virtual tVoid vVisit_e8_TmcMediumType(fi_tcl_e8_TmcMediumType& oe8_TmcMediumType);

   virtual tVoid vVisit_e16_TmcApplicationId(fi_tcl_e16_TmcApplicationId& oe16_TmcApplicationId);

   virtual tVoid vVisit_e8_TmcMode(fi_tcl_e8_TmcMode& oe8_TmcMode);

   virtual tVoid vVisit_e8_TunerState(fi_tcl_e8_TunerState& oe8_TunerState);

   virtual tVoid vVisit_e8_TmcOperationMode(fi_tcl_e8_TmcOperationMode& oe8_TmcOperationMode);

   virtual tVoid vVisit_e8_OperationMode(fi_tcl_e8_OperationMode& oe8_OperationMode);

   virtual tVoid vVisit_e8_TmcCapability(fi_tcl_e8_TmcCapability& oe8_TmcCapability);

   virtual tVoid vVisit_e8_TpegCapability(fi_tcl_e8_TpegCapability& oe8_TpegCapability);

   virtual tVoid vVisit_e8_CommonCapability(fi_tcl_e8_CommonCapability& oe8_CommonCapability);

   virtual tVoid vVisit_e8_TpegApplication(fi_tcl_e8_TpegApplication& oe8_TpegApplication);

   virtual tVoid vVisit_e8_TpegLocReferencing(fi_tcl_e8_TpegLocReferencing& oe8_TpegLocReferencing);

   virtual tVoid vVisit_e8_TpegTfpMethod(fi_tcl_e8_TpegTfpMethod& oe8_TpegTfpMethod);

   virtual tVoid vVisit_e8_MessageType(fi_tcl_e8_MessageType& oe8_MessageType);

   virtual tVoid vVisit_e8_TunerReceptionState(fi_tcl_e8_TunerReceptionState& oe8_TunerReceptionState);

   virtual tVoid vVisit_VersionedTpegApplication(fi_tcl_VersionedTpegApplication& oVersionedTpegApplication);

   virtual tVoid vVisit_TpegSid(fi_tcl_TpegSid& oTpegSid);

   virtual tVoid vVisit_TpegAcid(fi_tcl_TpegAcid& oTpegAcid);

   virtual tVoid vVisit_TmcServiceIdentification(fi_tcl_TmcServiceIdentification& oTmcServiceIdentification);

   virtual tVoid vVisit_TunerRdbId(fi_tcl_TunerRdbId& oTunerRdbId);

   virtual tVoid vVisit_Encryption(fi_tcl_Encryption& oEncryption);

   virtual tVoid vVisit_MsgSource(fi_tcl_MsgSource& oMsgSource);

   virtual tVoid vVisit_TrafficInfo(fi_tcl_TrafficInfo& oTrafficInfo);

   virtual tVoid vVisit_TmcCapability(fi_tcl_TmcCapability& oTmcCapability);

   virtual tVoid vVisit_TpegCapability(fi_tcl_TpegCapability& oTpegCapability);

   virtual tVoid vVisit_CommonCapability(fi_tcl_CommonCapability& oCommonCapability);

   virtual tVoid vVisit_TpegApplicationVersion(fi_tcl_TpegApplicationVersion& oTpegApplicationVersion);

   virtual tVoid vVisit_TpegMessage(fi_tcl_TpegMessage& oTpegMessage);

   virtual tVoid vVisit_e16_CarManufacturerBrand(fi_tcl_e16_CarManufacturerBrand& oe16_CarManufacturerBrand);

   virtual tVoid vVisit_b8_VehicleAttributes(fi_tcl_b8_VehicleAttributes& ob8_VehicleAttributes);

   virtual tVoid vVisit_e8_WeatherId(fi_tcl_e8_WeatherId& oe8_WeatherId);

   virtual tVoid vVisit_e8_CountyWarningCode(fi_tcl_e8_CountyWarningCode& oe8_CountyWarningCode);

   virtual tVoid vVisit_e8_TabularWeatherId(fi_tcl_e8_TabularWeatherId& oe8_TabularWeatherId);

   virtual tVoid vVisit_MetarStation(fi_tcl_MetarStation& oMetarStation);

   virtual tVoid vVisit_WeatherCondition(fi_tcl_WeatherCondition& oWeatherCondition);

   virtual tVoid vVisit_Visibility(fi_tcl_Visibility& oVisibility);

   virtual tVoid vVisit_CurrentWeather(fi_tcl_CurrentWeather& oCurrentWeather);

   virtual tVoid vVisit_WeatherForPosition(fi_tcl_WeatherForPosition& oWeatherForPosition);

   virtual tVoid vVisit_CurrentWeatherListSet(fi_tcl_CurrentWeatherListSet& oCurrentWeatherListSet);

   virtual tVoid vVisit_FuelStationDescription(fi_tcl_FuelStationDescription& oFuelStationDescription);

   virtual tVoid vVisit_MarineZone(fi_tcl_MarineZone& oMarineZone);

   virtual tVoid vVisit_WeatherForecast(fi_tcl_WeatherForecast& oWeatherForecast);

   virtual tVoid vVisit_WeatherForecastForPosition(fi_tcl_WeatherForecastForPosition& oWeatherForecastForPosition);

   virtual tVoid vVisit_WeatherForecastListSet(fi_tcl_WeatherForecastListSet& oWeatherForecastListSet);

   virtual tVoid vVisit_WarningId(fi_tcl_WarningId& oWarningId);

   virtual tVoid vVisit_County(fi_tcl_County& oCounty);

   virtual tVoid vVisit_CountyWarning(fi_tcl_CountyWarning& oCountyWarning);

   virtual tVoid vVisit_b16_ForecastType(fi_tcl_b16_ForecastType& ob16_ForecastType);

   virtual tVoid vVisit_e8_ForecastType(fi_tcl_e8_ForecastType& oe8_ForecastType);

   virtual tVoid vVisit_VersionPerForecast(fi_tcl_VersionPerForecast& oVersionPerForecast);

   virtual tVoid vVisit_e8_PrecipitationType(fi_tcl_e8_PrecipitationType& oe8_PrecipitationType);

   virtual tVoid vVisit_e8_CloudCoverageType(fi_tcl_e8_CloudCoverageType& oe8_CloudCoverageType);

   virtual tVoid vVisit_TabularWeatherCondition(fi_tcl_TabularWeatherCondition& oTabularWeatherCondition);

   virtual tVoid vVisit_Precipitation(fi_tcl_Precipitation& oPrecipitation);

   virtual tVoid vVisit_Humidity(fi_tcl_Humidity& oHumidity);

   virtual tVoid vVisit_CloudCoverage(fi_tcl_CloudCoverage& oCloudCoverage);

   virtual tVoid vVisit_UVLevel(fi_tcl_UVLevel& oUVLevel);

   virtual tVoid vVisit_PollenLevel(fi_tcl_PollenLevel& oPollenLevel);

   virtual tVoid vVisit_TabularWeatherPerForecast(fi_tcl_TabularWeatherPerForecast& oTabularWeatherPerForecast);

   virtual tVoid vVisit_TabularWeather(fi_tcl_TabularWeather& oTabularWeather);

   virtual tVoid vVisit_TabularWeatherForPosition(fi_tcl_TabularWeatherForPosition& oTabularWeatherForPosition);

   virtual tVoid vVisit_TabularWeatherListSet(fi_tcl_TabularWeatherListSet& oTabularWeatherListSet);

   virtual tVoid vVisit_b16_SkiAreaAttributes(fi_tcl_b16_SkiAreaAttributes& ob16_SkiAreaAttributes);

   virtual tVoid vVisit_SkiAreaAttributes(fi_tcl_SkiAreaAttributes& oSkiAreaAttributes);

   virtual tVoid vVisit_SkiCondition(fi_tcl_SkiCondition& oSkiCondition);

   virtual tVoid vVisit_SkiConditionForPosition(fi_tcl_SkiConditionForPosition& oSkiConditionForPosition);

   virtual tVoid vVisit_e8_AlertType(fi_tcl_e8_AlertType& oe8_AlertType);

   virtual tVoid vVisit_AlertType(fi_tcl_AlertType& oAlertType);

   virtual tVoid vVisit_WeatherAlertArea(fi_tcl_WeatherAlertArea& oWeatherAlertArea);

   virtual tVoid vVisit_StateOrZone(fi_tcl_StateOrZone& oStateOrZone);

   virtual tVoid vVisit_WeatherAlert(fi_tcl_WeatherAlert& oWeatherAlert);

   virtual tVoid vVisit_VersionPerState(fi_tcl_VersionPerState& oVersionPerState);

   virtual tVoid vVisit_StatesPerLanguage(fi_tcl_StatesPerLanguage& oStatesPerLanguage);

   virtual tVoid vVisit_WeatherAlertsForPosition(fi_tcl_WeatherAlertsForPosition& oWeatherAlertsForPosition);

   virtual tVoid vVisit_AreaBoundingBox(fi_tcl_AreaBoundingBox& oAreaBoundingBox);

   virtual tVoid vVisit_AreaInState(fi_tcl_AreaInState& oAreaInState);

   virtual tVoid vVisit_StatesAndAreasPerLanguage(fi_tcl_StatesAndAreasPerLanguage& oStatesAndAreasPerLanguage);

   virtual tVoid vVisit_e8_ProductType(fi_tcl_e8_ProductType& oe8_ProductType);

   virtual tVoid vVisit_e8_PictureType(fi_tcl_e8_PictureType& oe8_PictureType);

   virtual tVoid vVisit_e8_FormatVersion(fi_tcl_e8_FormatVersion& oe8_FormatVersion);

   virtual tVoid vVisit_Scale(fi_tcl_Scale& oScale);

   virtual tVoid vVisit_ScaleForTile(fi_tcl_ScaleForTile& oScaleForTile);

   virtual tVoid vVisit_TileAndRasterPictureSharedMemory(fi_tcl_TileAndRasterPictureSharedMemory& oTileAndRasterPictureSharedMemory);

   virtual tVoid vVisit_GraphicalWeatherTile(fi_tcl_GraphicalWeatherTile& oGraphicalWeatherTile);

   virtual tVoid vVisit_GraphicalWeatherTilePicture(fi_tcl_GraphicalWeatherTilePicture& oGraphicalWeatherTilePicture);

   virtual tVoid vVisit_VersionsOfTile(fi_tcl_VersionsOfTile& oVersionsOfTile);

   virtual tVoid vVisit_e8_WeatherShapeType(fi_tcl_e8_WeatherShapeType& oe8_WeatherShapeType);

   virtual tVoid vVisit_b8_ShapeContent(fi_tcl_b8_ShapeContent& ob8_ShapeContent);

   virtual tVoid vVisit_WeatherShape(fi_tcl_WeatherShape& oWeatherShape);

   virtual tVoid vVisit_e8_WeatherTileType(fi_tcl_e8_WeatherTileType& oe8_WeatherTileType);

   virtual tVoid vVisit_e8_WeatherTileDataType(fi_tcl_e8_WeatherTileDataType& oe8_WeatherTileDataType);

   virtual tVoid vVisit_TileIdentifier(fi_tcl_TileIdentifier& oTileIdentifier);

   virtual tVoid vVisit_WeatherSharedMemoryDescription(fi_tcl_WeatherSharedMemoryDescription& oWeatherSharedMemoryDescription);

   virtual tVoid vVisit_RasterTile(fi_tcl_RasterTile& oRasterTile);

   virtual tVoid vVisit_RasterTilePicture(fi_tcl_RasterTilePicture& oRasterTilePicture);

   virtual tVoid vVisit_WeatherShapeList(fi_tcl_WeatherShapeList& oWeatherShapeList);

#ifndef FI_S_EXTERNAL_FI
   virtual tVoid vVisit_GraphicalWeatherShapeBinContainer(fi_tcl_GraphicalWeatherShapeBinContainer& oGraphicalWeatherShapeBinContainer);

#endif // FI_S_EXTERNAL_FI
   virtual tVoid vVisit_e8_WeatherFrontType(fi_tcl_e8_WeatherFrontType& oe8_WeatherFrontType);

   virtual tVoid vVisit_e8_WeatherPressureType(fi_tcl_e8_WeatherPressureType& oe8_WeatherPressureType);

   virtual tVoid vVisit_WeatherShapeTypeIsobar(fi_tcl_WeatherShapeTypeIsobar& oWeatherShapeTypeIsobar);

   virtual tVoid vVisit_WeatherShapeTypeWindRadius(fi_tcl_WeatherShapeTypeWindRadius& oWeatherShapeTypeWindRadius);

   virtual tVoid vVisit_e8_WeatherStormPositionType(fi_tcl_e8_WeatherStormPositionType& oe8_WeatherStormPositionType);

   virtual tVoid vVisit_e8_WeatherStormType(fi_tcl_e8_WeatherStormType& oe8_WeatherStormType);

   virtual tVoid vVisit_b8_WeatherStormType(fi_tcl_b8_WeatherStormType& ob8_WeatherStormType);

   virtual tVoid vVisit_WeatherShapeTypeStormAttributes(fi_tcl_WeatherShapeTypeStormAttributes& oWeatherShapeTypeStormAttributes);

   virtual tVoid vVisit_WeatherShapeTypeFront(fi_tcl_WeatherShapeTypeFront& oWeatherShapeTypeFront);

   virtual tVoid vVisit_WeatherShapeTypePressureCenter(fi_tcl_WeatherShapeTypePressureCenter& oWeatherShapeTypePressureCenter);

   virtual tVoid vVisit_WeatherShapeTypeStormPosition(fi_tcl_WeatherShapeTypeStormPosition& oWeatherShapeTypeStormPosition);

   virtual tVoid vVisit_WeatherShapeTypeStormTrack(fi_tcl_WeatherShapeTypeStormTrack& oWeatherShapeTypeStormTrack);


 	fi_tclTraversePath<fi_tclKnot>::tclIterator oIterator;		
	
protected:
	tBool bBreakNow;
	tBool bIsVisitorValid;
private:

};

#endif
