/************************************************************************
 
 *FILE:           alltypes.h
 
 *SW-COMPONENT:   FI, framework for Functional Interface
 
 *DESCRIPTION:    Interface for all types defined in the different FIs
                  
 *AUTHOR:         Jochen Bruns (CM-DI/ENS41)
 
 *COPYRIGHT:      (c) 2001 Blaupunkt GmbH
 
 *HISTORY:
           $ Log $
 * 
 *    Rev 1.0   Oct 7 2001 17:16:00   bnj2hi
 * Initial revision
 *  
 ************************************************************************/

#ifndef ALLFITYPES_HEADER
#define ALLFITYPES_HEADER

#include <vector>


class fi_tclVisitorBase;

const tU16 FI_C_U16_ERROR_INTERNALFAILURE = 1;
const tU16 FI_C_U16_ERROR_INVALIDBINCONTAINERWRONGVERSION = 2;
const tU16 FI_C_U16_ERROR_INVALIDBINCONTAINERUNEXPECTEDDATA = 3;

class fi_tclVisitableTypeBase :public fi_tclTypeBase
{
public:
   virtual void vTakeVisitor(fi_tclVisitorBase& /*oVisitor*/) {}
};

class fi_tclU8 : public fi_tclVisitableTypeBase
{
public:
   fi_tclU8():u8Value(0) {}
   tU8 u8Value;
   
   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual tBool operator==(const fi_tclU8& oCmp) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& oOutContext) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& oOutContext);
   virtual void vTakeVisitor(fi_tclVisitorBase& oVisitor);
   virtual tS32 s32GetTypeId() const { return typesfi_tclToken::EN_U8;}
};

class fi_tclS8 : public fi_tclVisitableTypeBase
{
public:
   fi_tclS8():s8Value(0) {}
   tS8 s8Value;
   
   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual tBool operator==(const fi_tclS8& oCmp) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& oOutContext) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& oOutContext);
   virtual void vTakeVisitor(fi_tclVisitorBase& oVisitor);
   virtual tS32 s32GetTypeId() const { return typesfi_tclToken::EN_S8;}
};

class fi_tclU16 : public fi_tclVisitableTypeBase
{
public:
   fi_tclU16():u16Value(0) {}
   tU16 u16Value;
   
   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual tBool operator==(const fi_tclU16& oCmp) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& oOutContext) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& oOutContext);
   virtual void vTakeVisitor(fi_tclVisitorBase& oVisitor);
   virtual tS32 s32GetTypeId() const { return typesfi_tclToken::EN_U16;}
};

class fi_tclS16 : public fi_tclVisitableTypeBase
{
public:
   fi_tclS16():s16Value(0) {}
   tS16 s16Value;
   
   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual tBool operator==(const fi_tclS16& oCmp) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& oOutContext) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& oOutContext);
   virtual void vTakeVisitor(fi_tclVisitorBase& oVisitor);
   virtual tS32 s32GetTypeId() const { return typesfi_tclToken::EN_S16;}
};

class fi_tclU24 : public fi_tclVisitableTypeBase
{
public:
   fi_tclU24():u24Value(0) {}
   tU24 u24Value;
   
   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual tBool operator==(const fi_tclU24& oCmp) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& oOutContext) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& oOutContext);
   virtual void vTakeVisitor(fi_tclVisitorBase& oVisitor);
   virtual tS32 s32GetTypeId() const { return typesfi_tclToken::EN_U24;}
};

class fi_tclS24 : public fi_tclVisitableTypeBase
{
public:
   fi_tclS24():s24Value(0) {}
   tS24 s24Value;

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual tBool operator==(const fi_tclS24& oCmp) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& oOutContext) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& oOutContext);
   virtual void vTakeVisitor(fi_tclVisitorBase& oVisitor);
   virtual tS32 s32GetTypeId() const { return typesfi_tclToken::EN_S24;}
};

class fi_tclU32 : public fi_tclVisitableTypeBase
{
public:
   fi_tclU32():u32Value(0) {}
   tU32 u32Value;

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual tBool operator==(const fi_tclU32& oCmp) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& oOutContext) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& oOutContext);
   virtual void vTakeVisitor(fi_tclVisitorBase& oVisitor);
   virtual tS32 s32GetTypeId() const { return typesfi_tclToken::EN_U32;}
};

class fi_tclS32 : public fi_tclVisitableTypeBase
{
public:
   fi_tclS32():s32Value(0) {}
   tS32 s32Value;

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual tBool operator==(const fi_tclS32& oCmp) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& oOutContext) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& oOutContext);
   virtual void vTakeVisitor(fi_tclVisitorBase& oVisitor);
   virtual tS32 s32GetTypeId() const { return typesfi_tclToken::EN_S32;}
};

class fi_tclU64 : public fi_tclVisitableTypeBase
{
public:
   fi_tclU64():u64Value(0) {}
   tU64 u64Value;

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual tBool operator==(const fi_tclU64& oCmp) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& oOutContext) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& oOutContext);
   virtual void vTakeVisitor(fi_tclVisitorBase& oVisitor);
   virtual tS32 s32GetTypeId() const { return typesfi_tclToken::EN_U64;}
};

class fi_tclS64 : public fi_tclVisitableTypeBase
{
public:
   fi_tclS64():s64Value(0) {}
   tS64 s64Value;

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual tBool operator==(const fi_tclS64& oCmp) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& oOutContext) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& oOutContext);
   virtual void vTakeVisitor(fi_tclVisitorBase& oVisitor);
   virtual tS32 s32GetTypeId() const { return typesfi_tclToken::EN_S64;}
};

class fi_tclF32 : public fi_tclVisitableTypeBase
{
public:
   fi_tclF32():f32Value(0) {}
   tFloat f32Value;

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual tBool operator==(const fi_tclF32& oCmp) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& oOutContext) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& oOutContext);
   virtual void vTakeVisitor(fi_tclVisitorBase& oVisitor);
   virtual tS32 s32GetTypeId() const { return typesfi_tclToken::EN_F32;}
};

class fi_tclF64 : public fi_tclVisitableTypeBase
{
public:
   fi_tclF64():f64Value(0) {}
   tDouble f64Value;

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual tBool operator==(const fi_tclF64& oCmp) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& oOutContext) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& oOutContext);
   virtual void vTakeVisitor(fi_tclVisitorBase& oVisitor);
   virtual tS32 s32GetTypeId() const { return typesfi_tclToken::EN_F64;}
};

class fi_tclBool : public fi_tclVisitableTypeBase
{
public:
   fi_tclBool():bValue(0) {}
   tBool bValue;

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual tBool operator==(const fi_tclBool& oCmp) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& oOutContext) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& oOutContext);
   virtual void vTakeVisitor(fi_tclVisitorBase& oVisitor);
   virtual tS32 s32GetTypeId() const { return typesfi_tclToken::EN_BOOL;}
};

class fi_tclString : public fi_tclVisitableTypeBase
{
public:
   fi_tclString():szValue(0) {}
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   fi_tclString(const fi_tclString& coRef);
   fi_tclString& operator=(const fi_tclString& coRef);
   virtual ~fi_tclString();
#endif

   tString szValue;

   virtual void vDestroy();
   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual tBool operator==(const fi_tclString& oCmp) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& oOutContext) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& oOutContext);
   virtual void vTakeVisitor(fi_tclVisitorBase& oVisitor);
#ifndef FI_DO_NOT_USE_TSTRING
   fi_tclString& operator=(tCString coszString); // ADDED
   fi_tclString(tCString coszInit); //ADDED
   tBool operator==(tCString coszString) const; // ADDED
   operator const tChar* () const; // ADDED
   operator tString&(); // ADDED
   tBool operator!=(int iNULL) const; // ADDED
   tChar* operator+(int iOffset); // ADDED
   tChar* operator+(tU8  u8Offset); // ADDED
   tChar* operator+(tU32 u32Offset); // ADDED
   tChar& operator[](tU16 u16Index); //ADDED
   tChar& operator[](tU32 u32Index); //ADDED
   tChar& operator[](tS32 s32Index); //ADDED
#endif
   enum tenCharSet {
      FI_EN_UNDEFINED = 0,
      FI_EN_ISO8859_15M,
      FI_EN_UTF8,
      FI_EN_ISO8859_1M
   };
   virtual tS32 s32GetTypeId() const { return typesfi_tclToken::EN_STRING;}
   /* The following functions are used to import string values into FI-objects
    * and to export strings from FI-Objects.
    * The character encoding (ISO-Modified or UTF8) is provided as parameter
    * Attention: string values are copied by these functions, thus incoming and/or
    * outgoing strings have to be deleted externally.
    */
   tBool bSet(const fi_tclString& corfoInit, tenCharSet enCharSet);
   tBool bSet(tCString coszInit, tenCharSet enCharSet);
   tString szGet(tenCharSet enCharSet) const;
};

class fi_tclList : public fi_tclVisitableTypeBase
{
public:
   fi_tclList():u32ListSize(0) {}
   tU32 u32ListSize;
   
   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual tBool operator==(const fi_tclList& oCmp) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& oOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& oIn);
   virtual void vTakeVisitor(fi_tclVisitorBase& oVisitor);
   virtual tS32 s32GetTypeId() const { return typesfi_tclToken::EN_LIST;}
};

class fi_tclMultiLanguageString : public fi_tclVisitableTypeBase
{
public:
   fi_tclMultiLanguageString():szValue(0) {}
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   fi_tclMultiLanguageString(const fi_tclMultiLanguageString& coRef);
   fi_tclMultiLanguageString& operator=(const fi_tclMultiLanguageString& coRef);
   virtual ~fi_tclMultiLanguageString();
#endif

   tString szValue;

   virtual void vDestroy();
   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual tBool operator==(const fi_tclMultiLanguageString& oCmp) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& oOutContext) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& oOutContext);
   virtual void vTakeVisitor(fi_tclVisitorBase& oVisitor);
#ifndef FI_DO_NOT_USE_TSTRING
   fi_tclMultiLanguageString& operator=(tCString coszString); // ADDED
   fi_tclMultiLanguageString(tCString coszInit); //ADDED
   tBool operator==(tCString coszString) const; // ADDED
   operator const tChar* () const; // ADDED
   operator tString&(); // ADDED
   tBool operator!=(int iNULL) const; // ADDED
   tChar* operator+(int iOffset); // ADDED
   tChar* operator+(tU8  u8Offset); // ADDED
   tChar* operator+(tU32 u32Offset); // ADDED
   tChar& operator[](tU16 u16Index); //ADDED
   tChar& operator[](tU32 u32Index); //ADDED
   tChar& operator[](tS32 s32Index); //ADDED
#endif
   enum tenCharSet {
      FI_EN_UNDEFINED = 0,
      FI_EN_ISO8859_15M,
      FI_EN_UTF8
   };
   virtual tS32 s32GetTypeId() const { return typesfi_tclToken::EN_STRING;}
   /* The following functions are used to import string values into FI-objects
    * and to export strings from FI-Objects.
    * The character encoding (ISO-Modified or UTF8) is provided as parameter
    * Attention: string values are copied by these functions, thus incoming and/or
    * outgoing strings have to be deleted externally.
    */
   tBool bSet(const fi_tclMultiLanguageString& corfoInit, tenCharSet enCharSet);
   tBool bSet(tCString coszInit, tenCharSet enCharSet);
   tString szGet(tenCharSet enCharSet) const;
};
class fi_tcl_e8_Status;
class fi_tcl_e8_TypeOfFile;
class fi_tcl_FileContents;
class fi_tcl_Directory;
class fi_tcl_UTUInt;
class fi_tcl_UTListModel;
class fi_tcl_UTListSelectionModel;
class fi_tcl_UTMessage;
class fi_tcl_UTCCAMessage;
class fi_tcl_UTAction;
class fi_tcl_e8_DevNotification;
class fi_tcl_e8_DapMemType;
class fi_tcl_MemBlockDesc;
class fi_tcl_PathFilename;
class fi_tcl_DapPhysicalAddress;
class fi_tcl_DapPhysicalBlockAddress;
class fi_tcl_DapPhysicalBlockListElem;
class fi_tcl_DapComplexPhysicalBlockAddress;
class fi_tcl_e8_DapDeviceError;
class fi_tcl_e8_DapDataAvailable;
class fi_tcl_e8_DapMediaType;
class fi_tcl_FileCopy;
class fi_tcl_DapRegionDescr;
class fi_tcl_e8_UserID;
class fi_tcl_b8_InputContinuation;
class fi_tcl_e16_SelectionCriterionType;
class fi_tcl_b8_SelectionCriteriaMask;
class fi_tcl_b8_RefinementCriteriaMask;
class fi_tcl_ObjectDescription;
class fi_tcl_s32_Longitude;
class fi_tcl_b8_NavBinProperties;
class fi_tcl_ClusterId;
class fi_tcl_b8_CellProperties;
class fi_tcl_Cell;
class fi_tcl_ClusterInfo;
class fi_tcl_e8_DetailType;
class fi_tcl_ObjectDetail;
class fi_tcl_b8_ResolutionType;
class fi_tcl_b8_DataSetProperties;
class fi_tcl_DataSetElement;
class fi_tcl_e16_POIType;
class fi_tcl_b16_POIType;
class fi_tcl_e8_POIDataset;
class fi_tcl_s32_Latitude;
class fi_tcl_PositionWGS84;
class fi_tcl_IndexCatBrand;
class fi_tcl_MapIdPair;
class fi_tcl_DataBlockStartInfo;
class fi_tcl_DataBlockResultInfo;
class fi_tcl_e8_StorageMode;
class fi_tcl_e8_ResumeType;
class fi_tcl_e8_StoreStatus;
class fi_tcl_e8_ProgressStatus;
class fi_tcl_RegionNumberOrder;
class fi_tcl_RegionNumberResult;
class fi_tcl_RegionInfo;
class fi_tcl_RegionOutline;
class fi_tcl_e8_DapAccessMode;
class fi_tcl_DapDeviceStatusInfo;
class fi_tcl_e8_DapWriteProt;
class fi_tcl_DapVirtualMediaInfo;
class fi_tcl_e16_DapFileType;
class fi_tcl_e16_DapNumberRepr;
class fi_tcl_DapDeviceInfo;
class fi_tcl_DapFileType;
class fi_tcl_DapCodePageDescr;
class fi_tcl_DapLanguageDescr;
class fi_tcl_DevMediaInfo;
class fi_tcl_DapMediaInfo;
class fi_tcl_e8_DapDataType;
class fi_tcl_DapDataSetInfo;
class fi_tcl_DapDefaultControl;
class fi_tcl_DapRegionMetaInfo;
class fi_tcl_DapProfileMetaInfo;
class fi_tcl_DapRegionDescription;
class fi_tcl_b8_StructureType;
class fi_tcl_e32_RNWExtensionType;
class fi_tcl_e8_RNWDataUsageState;
class fi_tcl_MemPos;
class fi_tcl_StructureReference;
class fi_tcl_NavClusterId;
class fi_tcl_ClusterResultInfo;
class fi_tcl_RNWDataStorageInfo;
class fi_tcl_e8_LocClass;
class fi_tcl_e8_CarriageWay;
class fi_tcl_e8_TrafficFlow;
class fi_tcl_e8_FollowDirection;
class fi_tcl_LocTableIdent;
class fi_tcl_Outline;
class fi_tcl_e16_ISOCountryCode;
class fi_tcl_e16_ISOLanguageCode;
class fi_tcl_PrefixElem;
class fi_tcl_PrefixTable;
class fi_tcl_e8_DapPrioritaet;
class fi_tcl_e8_DapOrderType;
class fi_tcl_u32_DapContainerSize;
class fi_tcl_DapDataTypeInfo;
class fi_tcl_u32_DataSpace;
class fi_tcl_DapDataInfo;
class fi_tcl_ClusterStartInfo;
class fi_tcl_LocalOneCellID;
class fi_tcl_BBox;
class fi_tcl_RegProfOutline;
class fi_tcl_DapPrefixDesc;
class fi_tcl_DapPrefixState;
class fi_tcl_e8_TransferType;
class fi_tcl_e8_CoordinateCoding;
class fi_tcl_e16_DataType;
class fi_tcl_UniqueID;
class fi_tcl_MapScale;
class fi_tcl_BoundingBox;
class fi_tcl_ResultBlocks;
class fi_tcl_e8_RequestType;
class fi_tcl_e16_OneCellIndex;
class fi_tcl_e8_NavOneCellDirection;
class fi_tcl_OneCellRelation;
class fi_tcl_e8_Amenity;
class fi_tcl_Amenity;
class fi_tcl_e8_FileType;
class fi_tcl_DapRegionDescrList;
class fi_tcl_CatalogueFiles;
class fi_tcl_UTInt;
class fi_tcl_UTBool;
class fi_tcl_UTString;
class fi_tcl_OrderInfo;
class fi_tcl_BinContainer;
class fi_tcl_Reserved;
class fi_tcl_u8_Percent;
class fi_tcl_s16_PerThousand;
class fi_tcl_u16_IndexInReferenceList;
class fi_tcl_u16_ErrorCode;
class fi_tcl_u16_RPM;
class fi_tcl_s32_Kilogram;
class fi_tcl_s32_Pound;
class fi_tcl_s16_Meter;
class fi_tcl_s32_Meter;
class fi_tcl_s32_Yards;
class fi_tcl_s32_Foot;
class fi_tcl_s32_Centimeter;
class fi_tcl_s32_Inch;
class fi_tcl_s32_Millimeter;
class fi_tcl_s32_Microliter;
class fi_tcl_s32_Second;
class fi_tcl_u16_MilliSecond;
class fi_tcl_s32_MilliSecond;
class fi_tcl_POSIXTime;
class fi_tcl_e8_DST_State;
class fi_tcl_TimeZoneElement;
class fi_tcl_s16_KmPerHour;
class fi_tcl_s16_MilesPerHour;
class fi_tcl_s16_Knot;
class fi_tcl_s16_CentimeterSecond;
class fi_tcl_s16_Kelvin;
class fi_tcl_s16_Fahrenheit;
class fi_tcl_s32_Pascal;
class fi_tcl_s32_Watt;
class fi_tcl_FIVersion;
class fi_tcl_UserPOIElement;
class fi_tcl_LocTableDesc;
class fi_tcl_b16_ElementProperties;
class fi_tcl_RectangleWGS84;
class fi_tcl_LanguageDependentType;
class fi_tcl_LanguageIdElem;
class fi_tcl_LanguageID;
class fi_tcl_u8_DirectionAbsolute;
class fi_tcl_u8_DirectionRelative;
class fi_tcl_s16_CentiDegree;
class fi_tcl_s16_Degree;
class fi_tcl_u16_DirectionAbsolute_CentiDegree;
class fi_tcl_s16_DirectionRelative_CentiDegree;
class fi_tcl_e8_FuelType;
class fi_tcl_DistTimeFuel;
class fi_tcl_e8_BinContainerTypes;
class fi_tcl_State;
class fi_tcl_e8_FuelAge;
class fi_tcl_FuelTypeCode;
class fi_tcl_RegionId;
class fi_tcl_FuelAge;
class fi_tcl_FuelPrice;
class fi_tcl_FuelStationId;
class fi_tcl_FuelType;
class fi_tcl_FuelStation;
class fi_tcl_FuelStationPrices;
class fi_tcl_StationFuelTypes;
class fi_tcl_b16_StationDescriptionRequest;
class fi_tcl_FuelStationInfo;
class fi_tcl_FuelStationPricesForPosition;
class fi_tcl_UpdateId;
class fi_tcl_e8_SXMFuelType;
class fi_tcl_e8_RoadClassCode;
class fi_tcl_TMOneCellPortion;
class fi_tcl_NavClusterDesc;
class fi_tcl_b8_TMCIntersectionPath;
class fi_tcl_e8_TMCIntersectionPathType;
class fi_tcl_NavOneCellDesc;
class fi_tcl_TMIntersectionMatrix;
class fi_tcl_s16_EMU;
class fi_tcl_s32_MEMU;
class fi_tcl_s16_MEMUSecond;
class fi_tcl_s16_EAU;
class fi_tcl_NavPlainPathListSet;
class fi_tcl_s32_EMU;
class fi_tcl_b32_RoadProperty;
class fi_tcl_e8_PathType;
class fi_tcl_s16_CurvatureValue;
class fi_tcl_e8_EntryPointState;
class fi_tcl_u32_Resistance;
class fi_tcl_e8_NavStreetType;
class fi_tcl_e8_RoadNetworkClass;
class fi_tcl_e8_RoadInfoPriority;
class fi_tcl_NavRoadInfoProperty;
class fi_tcl_NavRoadInfoDesc;
class fi_tcl_e8_RoadInfoRefListType;
class fi_tcl_NavRoadInfoRefListUnionType;
class fi_tcl_NavRoadInfoListSet;
class fi_tcl_e8_RoadPathInfoCategory;
class fi_tcl_e8_CrossroadInfoCategory;
class fi_tcl_RoadPathInfoCategory;
class fi_tcl_RoadPathInfoListSet;
class fi_tcl_NavTMOneCell;
class fi_tcl_NavTMOneCellListSet;
class fi_tcl_e8_DataAvailable;
class fi_tcl_e8_NavLocationDescType;
class fi_tcl_NavLocationDesc;
#ifndef FI_S_EXTERNAL_FI
class fi_tcl_NavLocationBinContainer;
#endif // FI_S_EXTERNAL_FI
class fi_tcl_e8_NavIndexZFDestinationType;
class fi_tcl_e8_NavLocationNavDataType;
class fi_tcl_u32_DataSetId;
class fi_tcl_e8_SideInfo;
class fi_tcl_NavSpotDestinationOneCellProperty;
class fi_tcl_NavSpotDestinationOneCellDesc;
class fi_tcl_NavStreetDestinationOneCellProperty;
class fi_tcl_NavStreetDestinationOneCellDesc;
class fi_tcl_NavStreetDestinationOneCellListSet;
class fi_tcl_e8_NavIntersectionType;
class fi_tcl_NavZeroCellDesc;
class fi_tcl_NavIntersectionDestinationZeroCellProperty;
class fi_tcl_NavIntersectionDestinationZeroCellDesc;
class fi_tcl_NavAreaDescriptionCircle;
class fi_tcl_NavAreaDescriptionPolygon;
class fi_tcl_CountryInfo;
class fi_tcl_u16_TripHandle;
class fi_tcl_b32_NavRouteStatus;
class fi_tcl_b32_ExtNavRouteStatus;
class fi_tcl_NavRouteInfo;
class fi_tcl_u16_TripSegmentNumber;
class fi_tcl_e8_ManoeuvreCriticality;
class fi_tcl_NavRouteDestinationDesc;
class fi_tcl_b32_NavRouteOneCellStatus;
class fi_tcl_b32_ExtNavRouteOneCellStatus;
class fi_tcl_NavRouteOneCellProperties;
class fi_tcl_NavRouteOneCellDesc;
class fi_tcl_NavRouteInstructionDesc;
class fi_tcl_u16_RouteHandle;
class fi_tcl_e8_SignPostDestType;
class fi_tcl_e8_SignPostDestinationCategory;
class fi_tcl_e8_SignPostDestStatus;
class fi_tcl_e8_DirectionStatus;
class fi_tcl_SignPostDestDirection;
class fi_tcl_e8_DirectionCategory;
class fi_tcl_e8_NavOneCellCategory;
class fi_tcl_DirectionCategory;
class fi_tcl_b8_DirectionInfoStatus;
class fi_tcl_DirectionInfo;
class fi_tcl_SignPostDestination;
class fi_tcl_DirectionInfoList;
class fi_tcl_ReferenceElement;
class fi_tcl_b8_SignPostInfoStatus;
class fi_tcl_e8_TMAffectionType;
class fi_tcl_b8_TMOneCellAttribute;
class fi_tcl_TMOneCellDesc;
class fi_tcl_NavLocationDataDesc;
class fi_tcl_u32_MediaId;
class fi_tcl_EDMOneCellProp;
class fi_tcl_e8_NavDataLevel;
class fi_tcl_TMIntersectionPath;
class fi_tcl_SameLevelOneCellBlock;
class fi_tcl_NavSpotDestinationOneCellListSet;
class fi_tcl_NavPosOneCellProperty;
class fi_tcl_NavIntersectionDestinationZeroCellListSet;
class fi_tcl_NavOneCell;
class fi_tcl_SignPostElement;
class fi_tcl_NavDLDChainOneCellProperty;
class fi_tcl_NavDLDChainOneCellDesc;
class fi_tcl_NavDLDChainOneCellListSet;
#ifndef FI_S_EXTERNAL_FI
class fi_tcl_NavUTMBinContainer;
#endif // FI_S_EXTERNAL_FI
class fi_tcl_e8_WeatherProtocol;
class fi_tcl_b8_CriterionStatus;
class fi_tcl_AddressTemplate;
class fi_tcl_e8_FilterAttributeType;
class fi_tcl_FilterAttribute;
class fi_tcl_e16_MenuItemType;
class fi_tcl_e8_LocationValueListType;
class fi_tcl_b8_ListResultOptions;
class fi_tcl_b8_ListGetOptions;
class fi_tcl_LocationValueListUnion;
class fi_tcl_ListElement;
class fi_tcl_StringElement;
class fi_tcl_StringList;
class fi_tcl_StringDescriptionElement;
class fi_tcl_StringDescriptionList;
class fi_tcl_StringID;
class fi_tcl_StringIDElement;
class fi_tcl_PositionWGS84Element;
class fi_tcl_PositionWGS84List;
class fi_tcl_StringPosition;
class fi_tcl_StringPositionElement;
class fi_tcl_StringPositionDescriptionElement;
class fi_tcl_StringPositionDescriptionList;
class fi_tcl_b8_ListSortOptions;
class fi_tcl_e8_LocationDescriptionDataType;
class fi_tcl_SelectionCriterionDescription;
class fi_tcl_b8_CriteriaGetOptions;
class fi_tcl_DAPISelectableCriterion;
class fi_tcl_e8_TransformMode;
class fi_tcl_b8_LocationDescriptorStatus;
class fi_tcl_LocationDescriptor;
class fi_tcl_SelectableCriterion;
class fi_tcl_LocationDescription;
class fi_tcl_StringPositionList;
class fi_tcl_StringIDList;
class fi_tcl_FLIString;
class fi_tcl_b8_PositionStatus;
class fi_tcl_ListOfPositions;
class fi_tcl_e8_MapDataLevel;
class fi_tcl_MapCoordinates;
class fi_tcl_RelativeCoord_8Bit;
class fi_tcl_RelativeCoord_16Bit;
class fi_tcl_RelativeCoord_24Bit;
class fi_tcl_s16_Longitude;
class fi_tcl_s16_Latitude;
class fi_tcl_s24_Longitude;
class fi_tcl_s24_Latitude;
class fi_tcl_PositionWGS84_16Bit;
class fi_tcl_PositionWGS84_24Bit;
class fi_tcl_e8_CoordCode;
class fi_tcl_CodedCoord;
class fi_tcl_CoordCodingScheme;
class fi_tcl_b8_PresenceIndicator;
class fi_tcl_s8_MapDisplayZLevel;
class fi_tcl_s8_MapDisplayPriority;
class fi_tcl_MapCodedElement;
class fi_tcl_MapContainer;
class fi_tcl_e8_MapElementDescrType;
class fi_tcl_MapElementDescriptor;
class fi_tcl_MapElementDescription;
class fi_tcl_e8_MapGeometricType;
class fi_tcl_MapGeographicType;
class fi_tcl_e8_SurfaceCoverCode;
class fi_tcl_MapRegion;
class fi_tcl_MapDirectory;
class fi_tcl_u16_MapScale;
class fi_tcl_MapDataLevelDirectory;
class fi_tcl_ScaleConfig;
class fi_tcl_s16_XPosScreen;
class fi_tcl_s16_YPosScreen;
class fi_tcl_u16_Direction;
class fi_tcl_b16_HUCaps;
class fi_tcl_b16_GlobalPreferences;
class fi_tcl_b32_POI1;
class fi_tcl_b32_POI2;
class fi_tcl_b32_ServiceStations;
class fi_tcl_b32_ServiceStations2;
class fi_tcl_b32_ServiceStations3;
class fi_tcl_b8_FreewayFacilities;
class fi_tcl_b8_ParkingAreas;
class fi_tcl_b8_BorderLines;
class fi_tcl_b8_RiverClass;
class fi_tcl_b8_Channels;
class fi_tcl_b32_Streets;
class fi_tcl_b8_Areas;
class fi_tcl_b32_CityCenters;
class fi_tcl_b8_DirInfoStatus;
class fi_tcl_e8_FilterAcceptance;
class fi_tcl_e8_DrawMode;
class fi_tcl_e8_MapState;
class fi_tcl_e8_MapMode;
class fi_tcl_e8_MapScale;
class fi_tcl_e8_MapAngle;
class fi_tcl_MapTransMatrix;
class fi_tcl_e8_BaudRate;
class fi_tcl_e16_IdxType;
class fi_tcl_PositionScreen;
class fi_tcl_IndexInfo;
class fi_tcl_b8_DrawOptions;
class fi_tcl_RouteDescriptor;
class fi_tcl_e8_RouteDisplayType;
class fi_tcl_e16_USMarcLanguageCode;
class fi_tcl_u32CodePage;
class fi_tcl_e8_LanguageDefaultFlag;
class fi_tcl_LanguageFilter;
class fi_tcl_ZoomLevelConfig;
class fi_tcl_DestinationFlag;
class fi_tcl_b16_TheaterDescriptionRequest;
class fi_tcl_TheaterInfo;
class fi_tcl_MovieId;
class fi_tcl_Rating;
class fi_tcl_RunTime;
class fi_tcl_MovieName;
class fi_tcl_MovieDescription;
class fi_tcl_TheaterId;
class fi_tcl_Showing;
class fi_tcl_MovieTimes;
class fi_tcl_TheaterMovieTimes;
class fi_tcl_TheaterMovieTimesForPosition;
class fi_tcl_e8_DetailGrade;
class fi_tcl_BriefMovieDescription;
class fi_tcl_TheaterDescription;
class fi_tcl_u16_UserTrafficMessageHandle;
class fi_tcl_UTMHandleContainer;
class fi_tcl_e8_PositionCalculationState;
class fi_tcl_e8_SwitchPositionStatus;
class fi_tcl_e8_LaneStatus;
class fi_tcl_b8_LaneType;
class fi_tcl_b8_LaneChangeRestriction;
class fi_tcl_u8_IndexInLaneInfoSegmentList;
class fi_tcl_u8_IndexInLaneInfoList;
class fi_tcl_u8_DrivingDirection;
class fi_tcl_LaneDirection;
class fi_tcl_LaneInfoOneCellReference;
class fi_tcl_LaneInfoOneCellIndexReference;
class fi_tcl_LaneInfoPathSectionIndexReference;
class fi_tcl_LaneInfoElementReference;
class fi_tcl_e8_LaneReferenceCategory;
class fi_tcl_LaneReference;
class fi_tcl_LaneInfo;
class fi_tcl_LaneInfoElement;
class fi_tcl_LaneInfoSegment;
class fi_tcl_LaneInfoSegmentList;
class fi_tcl_LaneInfoListSet;
class fi_tcl_e8_EntryExitType;
class fi_tcl_EntryExitCoordinates;
class fi_tcl_EntryExitPointListSet;
class fi_tcl_WGS84CoordinateList;
class fi_tcl_ShapePointListSet;
class fi_tcl_b8_TrafficMessageContent;
class fi_tcl_e8_TMGeometricMessageType;
class fi_tcl_e16_NaviEventValue;
class fi_tcl_TMMapOneCellListSet;
class fi_tcl_TrafficSense;
class fi_tcl_TrafficSenseList;
class fi_tcl_SpeedFactor;
class fi_tcl_e8_RoadTypeDesc;
class fi_tcl_SpeedFactorRoadAreaType;
class fi_tcl_SpeedFactorsCountry;
class fi_tcl_SpeedFactorsList;
class fi_tcl_b8_SpeedLimitStatus;
class fi_tcl_e8_SpeedUnit;
class fi_tcl_e8_SpeedType;
class fi_tcl_SpeedLimitStatus;
class fi_tcl_SpeedLimit;
class fi_tcl_SpeedLimitRoadAreaType;
class fi_tcl_SpeedLimitsCountry;
class fi_tcl_SpeedLimitsList;
class fi_tcl_PrefixDesc;
class fi_tcl_PrefixState;
class fi_tcl_PrefixStateList;
class fi_tcl_e8_LanguageCat;
class fi_tcl_LanguageCategory;
class fi_tcl_LanguageDesc;
class fi_tcl_LanguageDescList;
class fi_tcl_e8_GlobalAnnotationCategory;
class fi_tcl_GlobalAnnotationTablesUnion;
class fi_tcl_TimeZoneName;
class fi_tcl_UPOI_Category;
class fi_tcl_e8_UPOI_Source;
class fi_tcl_b16_UPOI_Source;
class fi_tcl_b8_UPOI_FilterSetStatus;
class fi_tcl_e8_UPOI_AnnouncementDistance;
class fi_tcl_b8_UPOI_AnnouncementStatus;
class fi_tcl_b8_UPOI_Validity;
class fi_tcl_UPOI_Element;
class fi_tcl_b8_UPOI_FilterSet_FieldRelevance;
class fi_tcl_UPOI_FilterSet;
class fi_tcl_UPOI_FilterList;
class fi_tcl_UPOI_CategoryConfiguration;
class fi_tcl_UPOI_CategoryConfigurationList;
class fi_tcl_b8_UPOI_Status;
class fi_tcl_UPOI_Combination;
class fi_tcl_UPOI_ListSet;
class fi_tcl_ClockTime;
class fi_tcl_Date;
class fi_tcl_VersionInfo;
class fi_tcl_e8_GPSFix;
class fi_tcl_GPSAdditionalInformation;
class fi_tcl_e8_GPSChannelStatus;
class fi_tcl_s8_ElevationRelative;
class fi_tcl_GPSChannelInformation;
class fi_tcl_TMMapRef;
class fi_tcl_UTMDesc;
class fi_tcl_UTMDescByTM;
class fi_tcl_b16_PositionReliability;
class fi_tcl_PositionHeadingSpeed;
class fi_tcl_e8_InfoStatus;
class fi_tcl_InfoStatus;
class fi_tcl_DirectionInfoListSet;
class fi_tcl_ReferenceElementWithID;
class fi_tcl_e8_SingleRoadInfoCategory;
class fi_tcl_SingleRoadInfo;
class fi_tcl_StateNameElement;
class fi_tcl_CountyNameElement;
class fi_tcl_CityDistrictNameElement;
class fi_tcl_BuildUpAreaNameElement;
class fi_tcl_RoadNameElementList;
class fi_tcl_b8_RoadNumberStatus;
class fi_tcl_RequiredTaxDisc;
class fi_tcl_e8_RequiredPermissionType;
class fi_tcl_e8_RequiredPermission;
class fi_tcl_GenericRequiredPermission;
class fi_tcl_RequiredPermission;
class fi_tcl_RequiredPermissionList;
class fi_tcl_CountryNameElement;
class fi_tcl_StateNameListSet;
class fi_tcl_CountyNameListSet;
class fi_tcl_CityNameElement;
class fi_tcl_IndexInReferenceList;
class fi_tcl_BuildUpAreaNameListSet;
class fi_tcl_RoadNameListSet;
class fi_tcl_CompassDirection;
class fi_tcl_RequiredPermissionListSet;
class fi_tcl_e8_IntersectionType;
class fi_tcl_TimeZoneListSet;
class fi_tcl_IntersectionNameElement;
class fi_tcl_IntersectionNameListSet;
class fi_tcl_RoadNameElement;
class fi_tcl_RoadNumber;
class fi_tcl_IntersectionNumberElement;
class fi_tcl_MapDescriptionListSet;
class fi_tcl_CountryNameListSet;
class fi_tcl_CityNameListSet;
class fi_tcl_SignPostListSet;
class fi_tcl_IntersectionNumberListSet;
class fi_tcl_RoadNumberElementList;
class fi_tcl_RoadNumberListSet;
class fi_tcl_b16_RoadAttribute;
class fi_tcl_EDMOneCell;
class fi_tcl_NavPosOnecellSectionDescription;
class fi_tcl_EntryPoint;
class fi_tcl_PositionDescription;
class fi_tcl_RoadAttributes;
class fi_tcl_RoadId;
class fi_tcl_e8_ExtraDescElementType;
class fi_tcl_ExtraDescElement;
class fi_tcl_ExtraDescListSet;
class fi_tcl_b32_DataProperties;
class fi_tcl_DataDescElement;
class fi_tcl_DataDescListSet;
class fi_tcl_b8_CrossroadProperties;
class fi_tcl_CrossroadDesc;
class fi_tcl_CrossroadInfo;
class fi_tcl_IntersectionDenotation;
class fi_tcl_IntersectionPathDenotation;
class fi_tcl_IntersectionPathDesc;
class fi_tcl_IntersectionDescElement;
class fi_tcl_NavIntersectionListSet;
class fi_tcl_IntersectionListSet;
class fi_tcl_e16_BaseTrafficSign;
class fi_tcl_e8_BaseTrafficSignCategory;
class fi_tcl_e8_SpeedSign;
class fi_tcl_e16_WarningSign;
class fi_tcl_e16_RegulatorySign;
class fi_tcl_e16_AdditionalTrafficSign;
class fi_tcl_TimeDependentString;
class fi_tcl_b8_LaneDependentValidity;
class fi_tcl_e8_TrafficSignQuantifier;
class fi_tcl_AdditionalTrafficSign;
class fi_tcl_TrafficSignElement;
class fi_tcl_TrafficSignList;
class fi_tcl_RoadInfoCombination;
class fi_tcl_TrafficSignListSet;
class fi_tcl_b32_POICategory;
class fi_tcl_POIElement;
class fi_tcl_POIListSet;
class fi_tcl_b8_InstructionStatus;
class fi_tcl_SimpleInstruction;
class fi_tcl_SimpleInstructionListSet;
class fi_tcl_SectionCharacteristics;
class fi_tcl_NavRouteId;
class fi_tcl_b8_RouteProperties;
class fi_tcl_MostWorseManoeuvreInfo;
class fi_tcl_CriticalDecisionPointListElement;
class fi_tcl_CriticalDecisionPointListSet;
class fi_tcl_TollBoothElement;
class fi_tcl_TollBoothListSet;
class fi_tcl_CityDistrictNameListSet;
class fi_tcl_MapDescRefList;
class fi_tcl_RoadNameRefList;
class fi_tcl_RoadNumberRefList;
class fi_tcl_PointOfInterestElement;
class fi_tcl_UnspecifiedText;
class fi_tcl_NavRouteCompare;
class fi_tcl_NavRouteListSet;
#ifndef FI_S_EXTERNAL_FI
class fi_tcl_NavRouteListBinContainer;
#endif // FI_S_EXTERNAL_FI
class fi_tcl_e8_TMHandling;
class fi_tcl_e8_TMDirectionInterpretation;
class fi_tcl_b8_TMIntersectionPath;
class fi_tcl_TMParamAmbiguousClosing;
class fi_tcl_TMParamAmbiguousDynamicDisruption;
class fi_tcl_TMParamAmbiguousArea;
class fi_tcl_e8_ShapeType;
class fi_tcl_Shape;
class fi_tcl_RDBId;
class fi_tcl_ExtendedLocation;
class fi_tcl_CountryLocationList;
class fi_tcl_TMProgramService;
class fi_tcl_TMServiceProvider;
class fi_tcl_e8_TMCategory;
class fi_tcl_b8_TMMappingPossibility;
class fi_tcl_b8_TMMappingStatus;
#ifndef FI_S_EXTERNAL_FI
class fi_tcl_TMMapBinContainer;
#endif // FI_S_EXTERNAL_FI
class fi_tcl_TMCodedMapReference;
class fi_tcl_EDMLevelOCList;
class fi_tcl_e8_TMValueStatus;
class fi_tcl_TMCombination;
class fi_tcl_TMCStructuredText;
class fi_tcl_TMCategoryStatistics;
class fi_tcl_e8_TMFlowImpact;
class fi_tcl_e8_TMUrgency;
class fi_tcl_UTMStatistics;
class fi_tcl_TMFlowImpactStatistics;
class fi_tcl_b8_TMAdditionalInformation;
class fi_tcl_e8_TMGeographicalPathRelationType;
class fi_tcl_b8_TMRelevance;
class fi_tcl_e8_TrafficMsgType;
class fi_tcl_e8_EventType;
class fi_tcl_TMBaseInfo;
class fi_tcl_b32_TrafficMessageSource;
class fi_tcl_e8_PosHorizonState;
class fi_tcl_PosixExactTime;
class fi_tcl_OffsetSlopeValue;
class fi_tcl_OffsetHeightValue;
class fi_tcl_PosHorizonStartPath;
class fi_tcl_e8_DigitalMapSpeedCategoryType;
class fi_tcl_e8_PosHorizonSuccessorState;
class fi_tcl_b32_PathSectionStatus;
class fi_tcl_b8_PosHorizonSuccessorState;
class fi_tcl_PosHorizonPathSuccessor;
class fi_tcl_PosHorizonPathSection;
class fi_tcl_PosHorizonOneCellDesc;
class fi_tcl_b8_HorizonOneCellPropertyStatus;
class fi_tcl_HorizonMostProbablePath;
class fi_tcl_PosHorizonRootElement;
class fi_tcl_PosHorizonOneCellSection;
class fi_tcl_PositionPathDescription;
class fi_tcl_PositionList;
class fi_tcl_e8_ExtendedPositionCalculationState;
class fi_tcl_ExtrapolatedPosition;
class fi_tcl_ExtrapolatedOCDesc;
class fi_tcl_b8_ExtrapolationReliability;
class fi_tcl_VehicleSystemParameter;
class fi_tcl_VehicleCovarianceMatrix;
class fi_tcl_e8_PresentationStatus;
class fi_tcl_e8_CalibrationOperationCode;
class fi_tcl_e8_CalibrationState;
class fi_tcl_e8_DeadReckoningPositionState;
class fi_tcl_s16_CentiDegreePerSecond;
class fi_tcl_ContourEqualProbability;
class fi_tcl_b16_SensorDataPhalanx;
class fi_tcl_e8_MapMatchingRule;
class fi_tcl_u32_SquareDecimeter;
class fi_tcl_u32_Milliliter;
class fi_tcl_u32_Microliter;
class fi_tcl_e8_RouteCapabilityID;
class fi_tcl_RouteCapability;
class fi_tcl_e8_RouteOption;
class fi_tcl_e8_RouteDestinationType;
class fi_tcl_TripSegment;
class fi_tcl_b8_AddTripSegmentParameters;
class fi_tcl_e8_DynamicRouteCalcMode;
class fi_tcl_CurrentRouteOption;
class fi_tcl_AvailablePermission;
class fi_tcl_e8_CalculationOrder;
class fi_tcl_e8_CalculationCause;
class fi_tcl_e8_CalculationMode;
class fi_tcl_CalculationMode;
class fi_tcl_AvailableManipSourcesOfSegment;
class fi_tcl_ActiveManipSourcesOfSegment;
class fi_tcl_ActiveManipSourcesOfRoute;
class fi_tcl_TrafficMessageStatus;
class fi_tcl_e8_SegmentSkippingMode;
class fi_tcl_UserPermissionProfile;
class fi_tcl_b8_DynamisationCause;
class fi_tcl_RouteInfoElementValues;
class fi_tcl_b32_RoadInfoProperties;
class fi_tcl_RouteInfoElementStatus;
class fi_tcl_FirstElement;
class fi_tcl_EntryPointInfo;
class fi_tcl_e8_RouteInfoCategory;
class fi_tcl_RouteInfoElement;
class fi_tcl_RouteInfoCategory;
class fi_tcl_RouteInfoCategoryStatus;
class fi_tcl_SingleRouteInfoStatus;
class fi_tcl_UTMGroupNumberOnLengthList;
class fi_tcl_UTMGroupNumberOnNameList;
class fi_tcl_Destination;
class fi_tcl_DestinationListSet;
class fi_tcl_e8_Timezone;
class fi_tcl_CodedCity;
class fi_tcl_TabularWeatherLocation;
class fi_tcl_OffRoadElementInfo;
class fi_tcl_DistanceTimeInfo;
class fi_tcl_RouteDistanceTimeInfo;
class fi_tcl_e32_RouteCalculationErrorInfo;
class fi_tcl_AvailableRouteOption;
class fi_tcl_RouteSegmentDefinition;
class fi_tcl_e8_TripSegmentStatus;
class fi_tcl_TripSegmentStatus;
class fi_tcl_RouteStatus;
class fi_tcl_b8_RouteDifferenceStatus;
class fi_tcl_b8_TravelValueValidity;
class fi_tcl_e8_RouteBranchingType;
class fi_tcl_RouteBranchingCoordinate;
class fi_tcl_RouteValuesChange;
class fi_tcl_e8_ProfileType;
class fi_tcl_e8_NavAreaType;
class fi_tcl_e8_VehicleType;
class fi_tcl_Speedvector;
class fi_tcl_VehicleSpeedProfile;
class fi_tcl_b8_CargoInfo;
class fi_tcl_VehicleProfile;
class fi_tcl_UserSpeedProfile;
class fi_tcl_FuelConsumptionProfile;
class fi_tcl_b8_ThresholdDefinitionProfile;
class fi_tcl_ThresholdDefinitionProfile;
class fi_tcl_RouteHandleDescription;
class fi_tcl_RouteDefinition;
class fi_tcl_b8_SpeedProfiles;
class fi_tcl_b8_UserProfiles;
class fi_tcl_SpeedProfiles;
class fi_tcl_e8_VehicleClass;
class fi_tcl_e8_Gearbox;
class fi_tcl_e8_DriveMode;
class fi_tcl_VehicleParameter;
class fi_tcl_e8_DriverType;
class fi_tcl_DriverParameter;
class fi_tcl_GreenProfile;
class fi_tcl_UserProfiles;
class fi_tcl_e8_MapDestinationType;
class fi_tcl_MapDestination;
class fi_tcl_MapOneCellDesc;
#ifndef FI_S_EXTERNAL_FI
class fi_tcl_MapRouteBinContainer;
#endif // FI_S_EXTERNAL_FI
class fi_tcl_TimeDuration;
class fi_tcl_e8_TimeDependentClosureType;
class fi_tcl_TimeDependentClosure;
class fi_tcl_TimeDependentClosureListSet;
class fi_tcl_e8_RCalcProcessStatus;
class fi_tcl_b32_CalculationProperties;
class fi_tcl_NavRouteCalcProperty;
class fi_tcl_GlueAreaDesc;
class fi_tcl_e8_DataAccessibility;
class fi_tcl_e8_NavRCalcRouteStartPoint;
class fi_tcl_NavRCalcRouteStartPointUnionType;
class fi_tcl_NavRCalcPositionDesc;
class fi_tcl_NavRCalcCarPosition;
class fi_tcl_NavSubDestinationList;
class fi_tcl_e8_LoadStrategy;
class fi_tcl_LoadStrategy;
class fi_tcl_e8_StrategyStatus;
class fi_tcl_StrategyStatus;
class fi_tcl_EvaluatedPosition;
class fi_tcl_e8_DepictionArea;
class fi_tcl_DepictionArea;
class fi_tcl_DepictComplete;
class fi_tcl_DepictLength;
class fi_tcl_DepictPolygon;
class fi_tcl_e8_DepictionQuantityState;
class fi_tcl_DepictionQuantityState;
class fi_tcl_DepictedComplete;
class fi_tcl_DepictedPartLength;
class fi_tcl_DepictedPartPolygon;
class fi_tcl_b8_DepictionModeSettings;
class fi_tcl_DepictionModeSettings;
class fi_tcl_e8_DepictionDirectionMode;
class fi_tcl_b8_DepictionResult;
class fi_tcl_CntDepictResultElem;
class fi_tcl_PathListToDepict;
class fi_tcl_PathDataListSetToDepict;
class fi_tcl_NavDLDOneCellProperty;
class fi_tcl_NavDLDOneCellDesc;
class fi_tcl_NavDLDepictedPSOneCellList;
class fi_tcl_DepictedNavDataLevelListSet;
class fi_tcl_DepictedDataPathListSet;
class fi_tcl_b8_RouteSegmentCLTypes;
class fi_tcl_RouteSegmentCL;
class fi_tcl_LocationBranchCL;
class fi_tcl_DestinationBranchCL;
class fi_tcl_DestinationCL;
class fi_tcl_RegionStatus;
class fi_tcl_e8_ResumeMode;
class fi_tcl_e8_ResumedOperation;
class fi_tcl_Rfd_BaselineFiles;
class fi_tcl_e8_Rfd_CCAError;
class fi_tcl_e8_Rfd_ServiceStatus;
class fi_tcl_e8_UpdateState;
class fi_tcl_e8_SxmProtocol;
class fi_tcl_DevicePathForProtocol;
class fi_tcl_SxmFile;
class fi_tcl_FilesForProtocol;
class fi_tcl_e8_MetricSystem;
class fi_tcl_b8_GuidanceMode;
class fi_tcl_b8_GuidanceStatus;
class fi_tcl_e8_DataCarrierRequestStatus;
class fi_tcl_e8_GuidanceElement;
class fi_tcl_b8_GuidanceElementAttribute;
class fi_tcl_RoadNameList;
class fi_tcl_RoadNumberList;
class fi_tcl_SignPostElementList;
class fi_tcl_TrafficSignElementList;
class fi_tcl_IntersectionDescElementList;
class fi_tcl_e8_GuidanceDescriptorInfoCategory;
class fi_tcl_GuidanceDescriptorInfoCategory;
class fi_tcl_GuidanceDescriptorInfoCategoryRefElement;
class fi_tcl_e8_GuidanceSymbol;
class fi_tcl_GuidanceElement;
class fi_tcl_e8_GuidanceStatusSymbol;
class fi_tcl_SideRoad;
class fi_tcl_CombinedStatus;
class fi_tcl_SingleRoadInfoElementList;
class fi_tcl_b8_GuidanceSymbolAttributes;
class fi_tcl_Crossing;
class fi_tcl_e8_GuidanceManoeuvreSymbol;
class fi_tcl_e8_GuidanceManoeuvreType;
class fi_tcl_GuidanceManoeuvreBaseSymbol;
class fi_tcl_GuidanceManoeuvreSymbol;
class fi_tcl_b8_GuidanceSymbolStatus;
class fi_tcl_GuidanceManoeuvreSymbolList;
class fi_tcl_EntryPointSymbol;
class fi_tcl_e8_GuidanceDestinationType;
class fi_tcl_DestinationReachedSymbol;
class fi_tcl_e8_RoundaboutSymbolType;
class fi_tcl_RoundaboutSideRoad;
class fi_tcl_RoundaboutSymbol;
class fi_tcl_CriticalManoeuvreInfo;
class fi_tcl_e8_TurnToSymbol;
class fi_tcl_TurnToSymbol;
class fi_tcl_LaneChangeSymbol;
class fi_tcl_AbstractTurnSymbol;
class fi_tcl_BargraphDistance;
class fi_tcl_GuidanceManeuverElement;
class fi_tcl_RoadDescription;
class fi_tcl_GuidanceMapManeuverElement;
class fi_tcl_b8_GuidanceMessageCategory;
class fi_tcl_b8_WarningPointStatus;
class fi_tcl_b8_HorizonEventStatus;
class fi_tcl_e16_EffectCode;
class fi_tcl_e16_CauseCode;
class fi_tcl_e8_SpeedLimitExceedingStatus;
class fi_tcl_SpeedLimitSign;
class fi_tcl_e8_WarningSignCriticality;
class fi_tcl_WarningSign;
class fi_tcl_POI;
class fi_tcl_e8_RoadAttriuteInfo;
class fi_tcl_RoadAttributeInfo;
class fi_tcl_RequiredPermissionInfo;
class fi_tcl_e8_WarningPointDataType;
class fi_tcl_e8_HorizonEventDataType;
class fi_tcl_UPOI;
class fi_tcl_NextWarningPoint;
class fi_tcl_e8_TEAEventType;
class fi_tcl_b8_WarningsOnHorizonMode;
class fi_tcl_e8_MultiMediaFunction;
class fi_tcl_e8_MultiMediaType;
class fi_tcl_e8_MultiMediaStatus;
class fi_tcl_MultiMediaDescriptor;
class fi_tcl_MultiMediaElement;
class fi_tcl_NEVList;
class fi_tcl_b16_FunctionalityGroupRouteInfo;
class fi_tcl_b16_FunctionalityGroupDestinationInfo;
class fi_tcl_b16_FunctionalityGroupDrivingRecommendation;
class fi_tcl_b16_FunctionalityGroupCorridorInfo;
class fi_tcl_b16_FunctionalityGroupHorizonInfoTrafficMessage;
class fi_tcl_b16_FunctionalityGroupHorizonInfoSpeedLimit;
class fi_tcl_b16_FunctionalityGroupHorizonInfoWarningSign;
class fi_tcl_b16_FunctionalityGroupHorizonInfoPOI;
class fi_tcl_b16_FunctionalityGroupHorizonInfoRoadAttribute;
class fi_tcl_b16_FunctionalityGroupHorizonInfoCurve;
class fi_tcl_b16_FunctionalityGroupDriverSpeedAdvice;
class fi_tcl_e8_ThreeStateValue;
class fi_tcl_b16_HorizonEventTrafficSignSettings;
class fi_tcl_HorizonEventsFilter_TrafficSign;
class fi_tcl_b16_FunctionalityGroupHorizonInfoTollBooth;
class fi_tcl_b32_HorizonEventFilterPOI;
class fi_tcl_b8_TrafficMessageSettings;
class fi_tcl_HorizonEvent_TMConfiguration;
class fi_tcl_HorizonEventsFilter_TrafficMessage;
class fi_tcl_HorizonEventsFilter_POI;
class fi_tcl_HorizonEventsFilter_TollBooth;
class fi_tcl_HorizonEventsFilter_RoadAttribute;
class fi_tcl_DriverSpeedAdviceConfiguration;
class fi_tcl_HorizonEventsFilter;
class fi_tcl_SpeedLimitParameter;
class fi_tcl_e8_DriverAdviceType;
class fi_tcl_e8_DriverActionFeedback;
class fi_tcl_b32_PredictiveCCMode;
class fi_tcl_b32_PredictiveCC_ControlBits;
class fi_tcl_e8_SpeedLimitLocation;
class fi_tcl_LocDepSpeedLimitExceeding;
class fi_tcl_e8_VoiceGender;
class fi_tcl_Language;
class fi_tcl_e8_Sentence;
class fi_tcl_e8_SpeechFeature;
class fi_tcl_e8_SpeechStatus;
class fi_tcl_e8_DebugSound;
class fi_tcl_u32_StateManagerHandle;
class fi_tcl_e32_SystemState;
class fi_tcl_NavAppState;
class fi_tcl_e32_ShutdownLevel;
class fi_tcl_OnroadOffroadPositions;
class fi_tcl_b8_BreadCrumbTypes;
class fi_tcl_b8_ProfileDataType;
class fi_tcl_b8_ProfileStatus;
class fi_tcl_CountryTimes;
class fi_tcl_b8_StatPosStatusInfo;
class fi_tcl_ProfileData;
class fi_tcl_ProfileDataList;
class fi_tcl_e8_AuthorisationStatus;
class fi_tcl_e8_SigStatus;
class fi_tcl_e8_AuthStatus;
class fi_tcl_e8_SXMSignalStatus;
class fi_tcl_FuelPriceData;
class fi_tcl_e8_AuthorizationStatus;
class fi_tcl_e8_SignalStatus;
class fi_tcl_e8_MethodResult;
class fi_tcl_e8_UpdateType;
class fi_tcl_e8_AlertPrio;
class fi_tcl_Capabilities;
class fi_tcl_AU_Index;
class fi_tcl_GraphicalInfo;
class fi_tcl_e8_SXMTileType;
class fi_tcl_e8_SXMShapeType;
class fi_tcl_e8_SXMTileDataType;
class fi_tcl_SXMSharedMemoryDescription;
class fi_tcl_SXMSharedMemoryTile;
class fi_tcl_SXMShape;
class fi_tcl_e8_FrontType;
class fi_tcl_e8_PressureType;
class fi_tcl_SXMShapeTypeIsobar;
class fi_tcl_SXMShapeTypeWindRadius;
class fi_tcl_e8_StormPositionType;
class fi_tcl_e8_StormType;
class fi_tcl_b8_StormType;
class fi_tcl_SXMShapeTypeStormAttributes;
class fi_tcl_SXMShapeTypeFront;
class fi_tcl_SXMShapeTypePressureCenter;
class fi_tcl_SXMShapeTypeStormPosition;
class fi_tcl_SXMShapeTypeStormTrack;
class fi_tcl_b8_TEAPresenceIndicator;
class fi_tcl_b32_RoadInfoCategoryIndicator;
class fi_tcl_e8_HorizonRoadInfoCategory;
class fi_tcl_HorizonRoadInfoUnion;
class fi_tcl_b8_CurvatureStatus;
class fi_tcl_Curvature;
class fi_tcl_CurvatureList;
class fi_tcl_e8_MPPState;
class fi_tcl_MPPData;
class fi_tcl_b8_TEAOneCellSectionInfo;
class fi_tcl_b8_FurtherInfoUnion;
class fi_tcl_u8_SlopePercent;
class fi_tcl_AlternativTEAEventIDList;
class fi_tcl_TEAEventID;
class fi_tcl_HorizonEvent;
class fi_tcl_e8_TMLocationType;
class fi_tcl_e8_Tendency;
class fi_tcl_TMEvent;
class fi_tcl_TMInfo;
class fi_tcl_TMCodedMessage;
#ifndef FI_S_EXTERNAL_FI
class fi_tcl_TMCodedMessageBinContainer;
#endif // FI_S_EXTERNAL_FI
class fi_tcl_TrafficMessage;
class fi_tcl_ISORDBId;
class fi_tcl_TMInfoReference;
class fi_tcl_NextTrafficEvent;
class fi_tcl_TMCodedTextReference;
class fi_tcl_TMInfoListSet;
class fi_tcl_b16_TMSubstantialInformation;
class fi_tcl_TMUrgencyStatistics;
class fi_tcl_b8_TrafficMessageSourceAvailability;
class fi_tcl_e8_TMHazardLocationAccuracy;
class fi_tcl_e8_TMReliability;
class fi_tcl_e8_TMHazardLocationDynamics;
class fi_tcl_e8_TMQuantifierType;
class fi_tcl_e8_TMExtendedFlowImpact;
class fi_tcl_TrafficMsgMemoryStatisticsPerType;
class fi_tcl_TrafficMsgMemoryStatistics;
class fi_tcl_ISORDBIdAvailability;
class fi_tcl_TMStatistics;
class fi_tcl_e8_TMSegmentType;
class fi_tcl_e8_TMSegmentSubType;
class fi_tcl_TMDescription;
class fi_tcl_TMRequirementFulfilment;
class fi_tcl_TMPreciseLocationDescription;
class fi_tcl_TMChangedMessage;
class fi_tcl_e8_RequestFailureReason;
class fi_tcl_b8_RequestStatus;
class fi_tcl_RDBIDLocationListErrors;
class fi_tcl_e8_TmcMediumType;
class fi_tcl_e16_TmcApplicationId;
class fi_tcl_e8_TmcMode;
class fi_tcl_e8_TunerState;
class fi_tcl_e8_TmcOperationMode;
class fi_tcl_e8_OperationMode;
class fi_tcl_e8_TmcCapability;
class fi_tcl_e8_TpegCapability;
class fi_tcl_e8_CommonCapability;
class fi_tcl_e8_TpegApplication;
class fi_tcl_e8_TpegLocReferencing;
class fi_tcl_e8_TpegTfpMethod;
class fi_tcl_e8_MessageType;
class fi_tcl_e8_TunerReceptionState;
class fi_tcl_VersionedTpegApplication;
class fi_tcl_TpegSid;
class fi_tcl_TpegAcid;
class fi_tcl_TmcServiceIdentification;
class fi_tcl_TunerRdbId;
class fi_tcl_Encryption;
class fi_tcl_MsgSource;
class fi_tcl_TrafficInfo;
class fi_tcl_TmcCapability;
class fi_tcl_TpegCapability;
class fi_tcl_CommonCapability;
class fi_tcl_TpegApplicationVersion;
class fi_tcl_TpegMessage;
class fi_tcl_e16_CarManufacturerBrand;
class fi_tcl_b8_VehicleAttributes;
class fi_tcl_e8_WeatherId;
class fi_tcl_e8_CountyWarningCode;
class fi_tcl_e8_TabularWeatherId;
class fi_tcl_MetarStation;
class fi_tcl_WeatherCondition;
class fi_tcl_Visibility;
class fi_tcl_CurrentWeather;
class fi_tcl_WeatherForPosition;
class fi_tcl_CurrentWeatherListSet;
class fi_tcl_FuelStationDescription;
class fi_tcl_MarineZone;
class fi_tcl_WeatherForecast;
class fi_tcl_WeatherForecastForPosition;
class fi_tcl_WeatherForecastListSet;
class fi_tcl_WarningId;
class fi_tcl_County;
class fi_tcl_CountyWarning;
class fi_tcl_b16_ForecastType;
class fi_tcl_e8_ForecastType;
class fi_tcl_VersionPerForecast;
class fi_tcl_e8_PrecipitationType;
class fi_tcl_e8_CloudCoverageType;
class fi_tcl_TabularWeatherCondition;
class fi_tcl_Precipitation;
class fi_tcl_Humidity;
class fi_tcl_CloudCoverage;
class fi_tcl_UVLevel;
class fi_tcl_PollenLevel;
class fi_tcl_TabularWeatherPerForecast;
class fi_tcl_TabularWeather;
class fi_tcl_TabularWeatherForPosition;
class fi_tcl_TabularWeatherListSet;
class fi_tcl_b16_SkiAreaAttributes;
class fi_tcl_SkiAreaAttributes;
class fi_tcl_SkiCondition;
class fi_tcl_SkiConditionForPosition;
class fi_tcl_e8_AlertType;
class fi_tcl_AlertType;
class fi_tcl_WeatherAlertArea;
class fi_tcl_StateOrZone;
class fi_tcl_WeatherAlert;
class fi_tcl_VersionPerState;
class fi_tcl_StatesPerLanguage;
class fi_tcl_WeatherAlertsForPosition;
class fi_tcl_AreaBoundingBox;
class fi_tcl_AreaInState;
class fi_tcl_StatesAndAreasPerLanguage;
class fi_tcl_e8_ProductType;
class fi_tcl_e8_PictureType;
class fi_tcl_e8_FormatVersion;
class fi_tcl_Scale;
class fi_tcl_ScaleForTile;
class fi_tcl_TileAndRasterPictureSharedMemory;
class fi_tcl_GraphicalWeatherTile;
class fi_tcl_GraphicalWeatherTilePicture;
class fi_tcl_VersionsOfTile;
class fi_tcl_e8_WeatherShapeType;
class fi_tcl_b8_ShapeContent;
class fi_tcl_WeatherShape;
class fi_tcl_e8_WeatherTileType;
class fi_tcl_e8_WeatherTileDataType;
class fi_tcl_TileIdentifier;
class fi_tcl_WeatherSharedMemoryDescription;
class fi_tcl_RasterTile;
class fi_tcl_RasterTilePicture;
class fi_tcl_WeatherShapeList;
#ifndef FI_S_EXTERNAL_FI
class fi_tcl_GraphicalWeatherShapeBinContainer;
#endif // FI_S_EXTERNAL_FI
class fi_tcl_e8_WeatherFrontType;
class fi_tcl_e8_WeatherPressureType;
class fi_tcl_WeatherShapeTypeIsobar;
class fi_tcl_WeatherShapeTypeWindRadius;
class fi_tcl_e8_WeatherStormPositionType;
class fi_tcl_e8_WeatherStormType;
class fi_tcl_b8_WeatherStormType;
class fi_tcl_WeatherShapeTypeStormAttributes;
class fi_tcl_WeatherShapeTypeFront;
class fi_tcl_WeatherShapeTypePressureCenter;
class fi_tcl_WeatherShapeTypeStormPosition;
class fi_tcl_WeatherShapeTypeStormTrack;
class fi_tcl_e8_Status : public fi_tclVisitableTypeBase
{
public:
   fi_tcl_e8_Status():enType(FI_EN_SUCCESS) {}

   enum tenType {
      FI_EN_SUCCESS = 0UL,
      FI_EN_ERROR = 1UL,
      FI_EN_NOTEXISTING = 2UL,
      FI_EN_ALREADYEXISTS = 3UL,
      FI_EN_OUTOFMEMORY = 4UL,
      FI_EN_WRONGPARAMETER = 5UL,
      FI_EN_NOSERVER = 6UL,
      FI_EN_NOTANACTION = 7UL,
      FI_EN_INVALIDHANDLE = 8UL,
      FI_EN_NOTALLOWED = 9UL,
      FI_EN_INVALIDVALUE = 10UL,
      FI_EN_UNKNOWN = 11UL
   };
   tenType enType;

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual tBool operator==(const fi_tcl_e8_Status& rfoCmp) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   virtual tS32 s32GetTypeId() const { return typesfi_tclToken::EN_E8_STATUS;}
   virtual tVoid vTakeVisitor(fi_tclVisitorBase& rfoVisitor);
};

class fi_tcl_e8_TypeOfFile : public fi_tclVisitableTypeBase
{
public:
   fi_tcl_e8_TypeOfFile():enType(FI_EN_T_RESERVED) {}

   enum tenType {
      FI_EN_T_RESERVED = 0UL,
      FI_EN_T_DIRECTORY = 1UL,
      FI_EN_T_UTSTRING = 2UL,
      FI_EN_T_UTINT = 3UL,
      FI_EN_T_UTUINT = 4UL,
      FI_EN_T_UTLISTMODEL = 5UL,
      FI_EN_T_UTLISTSELECTIONMODEL = 6UL,
      FI_EN_T_UTMESSAGE = 7UL,
      FI_EN_T_UTCCAMESSAGE = 8UL,
      FI_EN_T_UTACTION = 9UL,
      FI_EN_T_UTBOOL = 10UL
   };
   tenType enType;

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual tBool operator==(const fi_tcl_e8_TypeOfFile& rfoCmp) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   virtual tS32 s32GetTypeId() const { return typesfi_tclToken::EN_E8_TYPEOFFILE;}
   virtual tVoid vTakeVisitor(fi_tclVisitorBase& rfoVisitor);
};

class fi_tcl_FileContents : public fi_tclVisitableTypeBase
{
public:
   fi_tcl_FileContents():poFileTypeData(0) {}
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   fi_tcl_FileContents& operator=(const fi_tcl_FileContents& coRef);
   fi_tcl_FileContents(const fi_tcl_FileContents& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
   fi_tcl_e8_TypeOfFile FileTypeType;
   fi_tclTypeBase* poFileTypeData;
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   virtual ~fi_tcl_FileContents();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   virtual tVoid vDestroy();
   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual tBool operator==(const fi_tcl_FileContents& rfoCmp) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   virtual tS32 s32GetTypeId() const { return typesfi_tclToken::EN_FILECONTENTS;}
   virtual tVoid vTakeVisitor(fi_tclVisitorBase& rfoVisitor);
};

class fi_tcl_Directory : public fi_tclVisitableTypeBase
{
public:
   fi_tcl_Directory() {}
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   fi_tcl_Directory& operator=(const fi_tcl_Directory& coRef);
   fi_tcl_Directory(const fi_tcl_Directory& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual tBool operator==(const fi_tcl_Directory& rfoCmp) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   virtual tS32 s32GetTypeId() const { return typesfi_tclToken::EN_DIRECTORY;}
   virtual tVoid vTakeVisitor(fi_tclVisitorBase& rfoVisitor);
};

class fi_tcl_UTUInt : public fi_tclVisitableTypeBase
{
public:
   fi_tcl_UTUInt():UTUIntValue(0) {}
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   fi_tcl_UTUInt& operator=(const fi_tcl_UTUInt& coRef);
   fi_tcl_UTUInt(const fi_tcl_UTUInt& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
   tU32 UTUIntValue;

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual tBool operator==(const fi_tcl_UTUInt& rfoCmp) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   virtual tS32 s32GetTypeId() const { return typesfi_tclToken::EN_UTUINT;}
   virtual tVoid vTakeVisitor(fi_tclVisitorBase& rfoVisitor);
};

class fi_tcl_UTListModel : public fi_tclVisitableTypeBase
{
public:
   fi_tcl_UTListModel():ListRowCount(0) {}
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   fi_tcl_UTListModel& operator=(const fi_tcl_UTListModel& coRef);
   fi_tcl_UTListModel(const fi_tcl_UTListModel& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
   tU32 ListRowCount;
   std::vector<fi_tclString, std::allocator<fi_tclString> > UTListValue;

   virtual tVoid vDestroy();
   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual tBool operator==(const fi_tcl_UTListModel& rfoCmp) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   virtual tS32 s32GetTypeId() const { return typesfi_tclToken::EN_UTLISTMODEL;}
   virtual tVoid vTakeVisitor(fi_tclVisitorBase& rfoVisitor);
};

class fi_tcl_UTListSelectionModel : public fi_tclVisitableTypeBase
{
public:
   fi_tcl_UTListSelectionModel():ListSelRowCount(0) {}
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   fi_tcl_UTListSelectionModel& operator=(const fi_tcl_UTListSelectionModel& coRef);
   fi_tcl_UTListSelectionModel(const fi_tcl_UTListSelectionModel& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
   tU32 ListSelRowCount;
   std::vector<fi_tclString, std::allocator<fi_tclString> > UTListSelectionValue;

   virtual tVoid vDestroy();
   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual tBool operator==(const fi_tcl_UTListSelectionModel& rfoCmp) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   virtual tS32 s32GetTypeId() const { return typesfi_tclToken::EN_UTLISTSELECTIONMODEL;}
   virtual tVoid vTakeVisitor(fi_tclVisitorBase& rfoVisitor);
};

class fi_tcl_UTMessage : public fi_tclVisitableTypeBase
{
public:
   fi_tcl_UTMessage():NotDefined(0) {}
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   fi_tcl_UTMessage& operator=(const fi_tcl_UTMessage& coRef);
   fi_tcl_UTMessage(const fi_tcl_UTMessage& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
   tU32 NotDefined;

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual tBool operator==(const fi_tcl_UTMessage& rfoCmp) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   virtual tS32 s32GetTypeId() const { return typesfi_tclToken::EN_UTMESSAGE;}
   virtual tVoid vTakeVisitor(fi_tclVisitorBase& rfoVisitor);
};

class fi_tcl_UTCCAMessage : public fi_tclVisitableTypeBase
{
public:
   fi_tcl_UTCCAMessage():ToBeDefined(0) {}
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   fi_tcl_UTCCAMessage& operator=(const fi_tcl_UTCCAMessage& coRef);
   fi_tcl_UTCCAMessage(const fi_tcl_UTCCAMessage& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
   tU32 ToBeDefined;

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual tBool operator==(const fi_tcl_UTCCAMessage& rfoCmp) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   virtual tS32 s32GetTypeId() const { return typesfi_tclToken::EN_UTCCAMESSAGE;}
   virtual tVoid vTakeVisitor(fi_tclVisitorBase& rfoVisitor);
};

class fi_tcl_UTAction : public fi_tclVisitableTypeBase
{
public:
   fi_tcl_UTAction() {}
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   fi_tcl_UTAction& operator=(const fi_tcl_UTAction& coRef);
   fi_tcl_UTAction(const fi_tcl_UTAction& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
   std::vector<fi_tclString, std::allocator<fi_tclString> > UTActionParameters;

   virtual tVoid vDestroy();
   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual tBool operator==(const fi_tcl_UTAction& rfoCmp) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   virtual tS32 s32GetTypeId() const { return typesfi_tclToken::EN_UTACTION;}
   virtual tVoid vTakeVisitor(fi_tclVisitorBase& rfoVisitor);
};

class fi_tcl_e8_DevNotification : public fi_tclVisitableTypeBase
{
public:
   fi_tcl_e8_DevNotification():enType(FI_EN_DAP_ENNOTITOTALFAILURE) {}

   enum tenType {
      FI_EN_DAP_ENNOTITOTALFAILURE = 0UL,
      FI_EN_DAP_ENNOTIOVERTEMPERATURE = 1UL,
      FI_EN_DAP_ENNOTIMEDIACHANGE = 2UL,
      FI_EN_DAP_ENNOTIMEDIASTATE = 3UL,
      FI_EN_DAP_ENNOTIMODECHANGE = 4UL
   };
   tenType enType;

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual tBool operator==(const fi_tcl_e8_DevNotification& rfoCmp) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   virtual tS32 s32GetTypeId() const { return typesfi_tclToken::EN_E8_DEVNOTIFICATION;}
   virtual tVoid vTakeVisitor(fi_tclVisitorBase& rfoVisitor);
};

class fi_tcl_e8_DapMemType : public fi_tclVisitableTypeBase
{
public:
   fi_tcl_e8_DapMemType():enType(FI_EN_DAP_MT_SHARED) {}

   enum tenType {
      FI_EN_DAP_MT_SHARED = 0UL,
      FI_EN_DAP_MT_HEAP = 1UL,
      FI_EN_DAP_MT_UNKNOWN = 2UL
   };
   tenType enType;

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual tBool operator==(const fi_tcl_e8_DapMemType& rfoCmp) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   virtual tS32 s32GetTypeId() const { return typesfi_tclToken::EN_E8_DAPMEMTYPE;}
   virtual tVoid vTakeVisitor(fi_tclVisitorBase& rfoVisitor);
};

class fi_tcl_MemBlockDesc : public fi_tclVisitableTypeBase
{
public:
   fi_tcl_MemBlockDesc():u32Size(0),pvMemAccess(0),hSharedMemHandle(0),bIsCopy(0),enMemType(),szSharedMemName() {}
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   fi_tcl_MemBlockDesc& operator=(const fi_tcl_MemBlockDesc& coRef);
   fi_tcl_MemBlockDesc(const fi_tcl_MemBlockDesc& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
   tU32 u32Size;
   tU32 pvMemAccess;
   tS32 hSharedMemHandle;
   tBool bIsCopy;
   fi_tcl_e8_DapMemType enMemType;
   fi_tclString szSharedMemName;

   virtual tVoid vDestroy();
   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual tBool operator==(const fi_tcl_MemBlockDesc& rfoCmp) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   virtual tS32 s32GetTypeId() const { return typesfi_tclToken::EN_MEMBLOCKDESC;}
   virtual tVoid vTakeVisitor(fi_tclVisitorBase& rfoVisitor);
};

class fi_tcl_PathFilename : public fi_tclVisitableTypeBase
{
public:
   fi_tcl_PathFilename():szFile(),szPath() {}
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   fi_tcl_PathFilename& operator=(const fi_tcl_PathFilename& coRef);
   fi_tcl_PathFilename(const fi_tcl_PathFilename& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
   fi_tclString szFile;
   fi_tclString szPath;

   virtual tVoid vDestroy();
   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual tBool operator==(const fi_tcl_PathFilename& rfoCmp) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   virtual tS32 s32GetTypeId() const { return typesfi_tclToken::EN_PATHFILENAME;}
   virtual tVoid vTakeVisitor(fi_tclVisitorBase& rfoVisitor);
};

class fi_tcl_DapPhysicalAddress : public fi_tclVisitableTypeBase
{
public:
   fi_tcl_DapPhysicalAddress():u32MediaId(0),oPathFilename() {}
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   fi_tcl_DapPhysicalAddress& operator=(const fi_tcl_DapPhysicalAddress& coRef);
   fi_tcl_DapPhysicalAddress(const fi_tcl_DapPhysicalAddress& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
   tU32 u32MediaId;
   fi_tcl_PathFilename oPathFilename;

   virtual tVoid vDestroy();
   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual tBool operator==(const fi_tcl_DapPhysicalAddress& rfoCmp) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   virtual tS32 s32GetTypeId() const { return typesfi_tclToken::EN_DAPPHYSICALADDRESS;}
   virtual tVoid vTakeVisitor(fi_tclVisitorBase& rfoVisitor);
};

class fi_tcl_DapPhysicalBlockAddress : public fi_tclVisitableTypeBase
{
public:
   fi_tcl_DapPhysicalBlockAddress():oPhysAdr(),u32FileOffset(0),u32BlockSize(0) {}
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   fi_tcl_DapPhysicalBlockAddress& operator=(const fi_tcl_DapPhysicalBlockAddress& coRef);
   fi_tcl_DapPhysicalBlockAddress(const fi_tcl_DapPhysicalBlockAddress& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
   fi_tcl_DapPhysicalAddress oPhysAdr;
   tU32 u32FileOffset;
   tU32 u32BlockSize;

   virtual tVoid vDestroy();
   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual tBool operator==(const fi_tcl_DapPhysicalBlockAddress& rfoCmp) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   virtual tS32 s32GetTypeId() const { return typesfi_tclToken::EN_DAPPHYSICALBLOCKADDRESS;}
   virtual tVoid vTakeVisitor(fi_tclVisitorBase& rfoVisitor);
};

class fi_tcl_DapPhysicalBlockListElem : public fi_tclVisitableTypeBase
{
public:
   fi_tcl_DapPhysicalBlockListElem():oPhysBlockAdr(),u32OriginIndex(0) {}
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   fi_tcl_DapPhysicalBlockListElem& operator=(const fi_tcl_DapPhysicalBlockListElem& coRef);
   fi_tcl_DapPhysicalBlockListElem(const fi_tcl_DapPhysicalBlockListElem& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
   fi_tcl_DapPhysicalBlockAddress oPhysBlockAdr;
   tU32 u32OriginIndex;

   virtual tVoid vDestroy();
   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual tBool operator==(const fi_tcl_DapPhysicalBlockListElem& rfoCmp) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   virtual tS32 s32GetTypeId() const { return typesfi_tclToken::EN_DAPPHYSICALBLOCKLISTELEM;}
   virtual tVoid vTakeVisitor(fi_tclVisitorBase& rfoVisitor);
};

class fi_tcl_DapComplexPhysicalBlockAddress : public fi_tclVisitableTypeBase
{
public:
   fi_tcl_DapComplexPhysicalBlockAddress():oPhysBlockAdr(),oMemAdr() {}
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   fi_tcl_DapComplexPhysicalBlockAddress& operator=(const fi_tcl_DapComplexPhysicalBlockAddress& coRef);
   fi_tcl_DapComplexPhysicalBlockAddress(const fi_tcl_DapComplexPhysicalBlockAddress& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
   fi_tcl_DapPhysicalBlockAddress oPhysBlockAdr;
   fi_tcl_MemBlockDesc oMemAdr;

   virtual tVoid vDestroy();
   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual tBool operator==(const fi_tcl_DapComplexPhysicalBlockAddress& rfoCmp) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   virtual tS32 s32GetTypeId() const { return typesfi_tclToken::EN_DAPCOMPLEXPHYSICALBLOCKADDRESS;}
   virtual tVoid vTakeVisitor(fi_tclVisitorBase& rfoVisitor);
};

class fi_tcl_e8_DapDeviceError : public fi_tclVisitableTypeBase
{
public:
   fi_tcl_e8_DapDeviceError():enType(FI_EN_DAP_ENDEVICEERRNONE) {}

   enum tenType {
      FI_EN_DAP_ENDEVICEERRNONE = 0UL,
      FI_EN_DAP_ENDEVICEERRUNSPECIFIED = 1UL,
      FI_EN_DAP_ENDEVICEERRTOTALFAILURE = 2UL,
      FI_EN_DAP_ENDEVICEERROVERTEMPERATURE = 3UL
   };
   tenType enType;

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual tBool operator==(const fi_tcl_e8_DapDeviceError& rfoCmp) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   virtual tS32 s32GetTypeId() const { return typesfi_tclToken::EN_E8_DAPDEVICEERROR;}
   virtual tVoid vTakeVisitor(fi_tclVisitorBase& rfoVisitor);
};

class fi_tcl_e8_DapDataAvailable : public fi_tclVisitableTypeBase
{
public:
   fi_tcl_e8_DapDataAvailable():enType(FI_EN_DAP_ENDATANOTAVAILABLE) {}

   enum tenType {
      FI_EN_DAP_ENDATANOTAVAILABLE = 0UL,
      FI_EN_DAP_ENDATALIMITEDAVAILABLE = 1UL,
      FI_EN_DAP_ENDATAFULLAVAILABLE = 2UL
   };
   tenType enType;

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual tBool operator==(const fi_tcl_e8_DapDataAvailable& rfoCmp) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   virtual tS32 s32GetTypeId() const { return typesfi_tclToken::EN_E8_DAPDATAAVAILABLE;}
   virtual tVoid vTakeVisitor(fi_tclVisitorBase& rfoVisitor);
};

class fi_tcl_e8_DapMediaType : public fi_tclVisitableTypeBase
{
public:
   fi_tcl_e8_DapMediaType():enType(FI_EN_DAP_ENMEDIANONE) {}

   enum tenType {
      FI_EN_DAP_ENMEDIANONE = 0UL,
      FI_EN_DAP_ENMEDIAINCORRECT = 1UL,
      FI_EN_DAP_ENMEDIAUNKNOWN = 2UL,
      FI_EN_DAP_ENMEDIADATA = 3UL,
      FI_EN_DAP_ENMEDIAAUDIO = 4UL,
      FI_EN_DAP_ENMEDIAMIXED = 5UL,
      FI_EN_DAP_ENMEDIANAV = 6UL,
      FI_EN_DAP_ENMEDIAENCRYPTED = 7UL,
      FI_EN_DAP_ENMEDIACOPYPROTECT = 8UL
   };
   tenType enType;

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual tBool operator==(const fi_tcl_e8_DapMediaType& rfoCmp) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   virtual tS32 s32GetTypeId() const { return typesfi_tclToken::EN_E8_DAPMEDIATYPE;}
   virtual tVoid vTakeVisitor(fi_tclVisitorBase& rfoVisitor);
};

class fi_tcl_FileCopy : public fi_tclVisitableTypeBase
{
public:
   fi_tcl_FileCopy():oTarget(),oSource(),bCloseFileAfterProcessing(0) {}
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   fi_tcl_FileCopy& operator=(const fi_tcl_FileCopy& coRef);
   fi_tcl_FileCopy(const fi_tcl_FileCopy& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
   fi_tcl_PathFilename oTarget;
   fi_tcl_PathFilename oSource;
   tBool bCloseFileAfterProcessing;

   virtual tVoid vDestroy();
   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual tBool operator==(const fi_tcl_FileCopy& rfoCmp) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   virtual tS32 s32GetTypeId() const { return typesfi_tclToken::EN_FILECOPY;}
   virtual tVoid vTakeVisitor(fi_tclVisitorBase& rfoVisitor);
};

class fi_tcl_DapRegionDescr : public fi_tclVisitableTypeBase
{
public:
   fi_tcl_DapRegionDescr():u32MediumId(0),u32CreateDate(0),u16RegionId(0),u8ProfileID(0),szDevice() {}
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   fi_tcl_DapRegionDescr& operator=(const fi_tcl_DapRegionDescr& coRef);
   fi_tcl_DapRegionDescr(const fi_tcl_DapRegionDescr& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
   tU32 u32MediumId;
   tU32 u32CreateDate;
   tU16 u16RegionId;
   tU8 u8ProfileID;
   fi_tclString szDevice;

   virtual tVoid vDestroy();
   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual tBool operator==(const fi_tcl_DapRegionDescr& rfoCmp) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   virtual tS32 s32GetTypeId() const { return typesfi_tclToken::EN_DAPREGIONDESCR;}
   virtual tVoid vTakeVisitor(fi_tclVisitorBase& rfoVisitor);
};

class fi_tcl_e8_UserID : public fi_tclVisitableTypeBase
{
public:
   fi_tcl_e8_UserID():enType(FI_EN_INVALID) {}

   enum tenType {
      FI_EN_INVALID = 0UL,
      FI_EN_LIM = 1UL
   };
   tenType enType;

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual tBool operator==(const fi_tcl_e8_UserID& rfoCmp) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   virtual tS32 s32GetTypeId() const { return typesfi_tclToken::EN_E8_USERID;}
   virtual tVoid vTakeVisitor(fi_tclVisitorBase& rfoVisitor);
};

class fi_tcl_b8_InputContinuation : public fi_tclVisitableTypeBase
{
public:
   fi_tcl_b8_InputContinuation():u8Value(0) {}

   enum {
      FI_C_U8_BIT_CATEGORIES = 0x1UL,
      FI_C_U8_BIT_FILTERATTRIBUTES = 0x2UL,
      FI_C_U8_BIT_MENUITEM = 0x4UL,
      FI_C_U8_BIT_DESTINATIONREACHABLE = 0x8UL,
      FI_C_U8_BIT_INCOMPLETEDATABASE = 0x10UL
   };
   tBool bCategories() const {return (u8Value & FI_C_U8_BIT_CATEGORIES) != 0; }
   tVoid vSetCategories(tBool bSetBit) { u8Value = (bSetBit)?(u8Value | FI_C_U8_BIT_CATEGORIES):(u8Value & ~FI_C_U8_BIT_CATEGORIES); }
   tBool bFilterAttributes() const {return (u8Value & FI_C_U8_BIT_FILTERATTRIBUTES) != 0; }
   tVoid vSetFilterAttributes(tBool bSetBit) { u8Value = (bSetBit)?(u8Value | FI_C_U8_BIT_FILTERATTRIBUTES):(u8Value & ~FI_C_U8_BIT_FILTERATTRIBUTES); }
   tBool bMenuItem() const {return (u8Value & FI_C_U8_BIT_MENUITEM) != 0; }
   tVoid vSetMenuItem(tBool bSetBit) { u8Value = (bSetBit)?(u8Value | FI_C_U8_BIT_MENUITEM):(u8Value & ~FI_C_U8_BIT_MENUITEM); }
   tBool bDestinationReachable() const {return (u8Value & FI_C_U8_BIT_DESTINATIONREACHABLE) != 0; }
   tVoid vSetDestinationReachable(tBool bSetBit) { u8Value = (bSetBit)?(u8Value | FI_C_U8_BIT_DESTINATIONREACHABLE):(u8Value & ~FI_C_U8_BIT_DESTINATIONREACHABLE); }
   tBool bIncompleteDataBase() const {return (u8Value & FI_C_U8_BIT_INCOMPLETEDATABASE) != 0; }
   tVoid vSetIncompleteDataBase(tBool bSetBit) { u8Value = (bSetBit)?(u8Value | FI_C_U8_BIT_INCOMPLETEDATABASE):(u8Value & ~FI_C_U8_BIT_INCOMPLETEDATABASE); }
   struct rBitValues {
      unsigned int Categories:1;
      unsigned int FilterAttributes:1;
      unsigned int MenuItem:1;
      unsigned int DestinationReachable:1;
      unsigned int IncompleteDataBase:1;
      unsigned int dummy5:1;
      unsigned int dummy6:1;
      unsigned int dummy7:1;
   };
   union {
      tU8 u8Value;
      rBitValues bits;
   };

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual tBool operator==(const fi_tcl_b8_InputContinuation& rfoCmp) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   virtual tS32 s32GetTypeId() const { return typesfi_tclToken::EN_B8_INPUTCONTINUATION;}
   virtual tVoid vTakeVisitor(fi_tclVisitorBase& rfoVisitor);
};

class fi_tcl_e16_SelectionCriterionType : public fi_tclVisitableTypeBase
{
public:
   fi_tcl_e16_SelectionCriterionType():enType(FI_EN_RESERVED) {}

   enum tenType {
      FI_EN_RESERVED = 0UL,
      FI_EN_COUNTRY = 1UL,
      FI_EN_TOWN = 2UL,
      FI_EN_STREET = 3UL,
      FI_EN_JUNCTION = 4UL,
      FI_EN_HOUSENUMBER = 5UL,
      FI_EN_ZIPCODE = 6UL,
      FI_EN_BUILDING = 7UL,
      FI_EN_TELEPHONENUMBER = 8UL,
      FI_EN_PROVINCE = 9UL,
      FI_EN_DISTRICT = 10UL,
      FI_EN_POI = 11UL,
      FI_EN_ALLPOIS = 12UL,
      FI_EN_MAJORCITY = 13UL,
      FI_EN_NATIONALSUPRAREGIONALPOI = 14UL,
      FI_EN_INTERNATIONALSUPRAREGIONALPOI = 15UL,
      FI_EN_TOWNCENTER = 16UL,
      FI_EN_ATTORNEY = 17UL,
      FI_EN_BORDERCROSSING = 18UL,
      FI_EN_CITYHALL = 19UL,
      FI_EN_COURTHOUSE = 20UL,
      FI_EN_EMBASSY = 21UL,
      FI_EN_FERRYTERMINALORFERRYLINK = 22UL,
      FI_EN_GOVERMENTOFFICE = 23UL,
      FI_EN_HOSPITAL = 24UL,
      FI_EN_LANDMARK = 25UL,
      FI_EN_LIBRARY = 26UL,
      FI_EN_MOTORWAYBRANCH = 27UL,
      FI_EN_MOTORWAYEXIT = 28UL,
      FI_EN_MOTORWAYSERVICE = 29UL,
      FI_EN_PARKING = 30UL,
      FI_EN_POLICESTATION = 31UL,
      FI_EN_POSTOFFICE = 32UL,
      FI_EN_PUBLICBUILDING = 33UL,
      FI_EN_RAILWAYSTATIONORRAILWAY = 34UL,
      FI_EN_SCENICVIEW = 35UL,
      FI_EN_SCHOOL = 36UL,
      FI_EN_THEATER = 37UL,
      FI_EN_UNIVERSITYCOLLEGE = 38UL,
      FI_EN_TOLLBOOTH = 39UL,
      FI_EN_COMMUTERRAILSTATION = 40UL,
      FI_EN_MONORAILSTATION = 41UL,
      FI_EN_MAGLEVSTATION = 42UL,
      FI_EN_COACHSTATION = 43UL,
      FI_EN_OTHERTRAFFICFACILITIES = 44UL,
      FI_EN_RESIDENTIALAREA = 45UL,
      FI_EN_PRIMARYSCHOOL = 46UL,
      FI_EN_MIDDLESCHOOL = 47UL,
      FI_EN_HIGHSCHOOL = 48UL,
      FI_EN_TECHNICALSECONDARYSCHOOL = 49UL,
      FI_EN_SPECIALIZEDSCHOOL = 50UL,
      FI_EN_EDUCATIONOTHERS = 51UL,
      FI_EN_PROVINCIALREPRESENTATION = 52UL,
      FI_EN_MUNICIPALREPRESENTATION = 53UL,
      FI_EN_INTERIORREPRESENTATIONOTHER = 54UL,
      FI_EN_CONSULATE = 55UL,
      FI_EN_FOREIGNREPRESENTATIONOTHER = 56UL,
      FI_EN_FIREPOLICE = 57UL,
      FI_EN_LOGISTICS = 58UL,
      FI_EN_URBANNAME = 59UL,
      FI_EN_CITYDISTRICT = 60UL,
      FI_EN_POSTALDISTRICT = 61UL,
      FI_EN_MOTORWAYENTRANCE = 62UL,
      FI_EN_POBOXES = 63UL,
      FI_EN_PLAZA = 64UL,
      FI_EN_OTHERSCHOOL = 65UL,
      FI_EN_ELEMENTARYSCHOOL = 66UL,
      FI_EN_USER_POIS = 117UL,
      FI_EN_OSDE_ADDRESSES = 118UL,
      FI_EN_OSDE_POI = 119UL,
      FI_EN_CWS_ALLPOIS = 120UL,
      FI_EN_NAVIGATIONINTERNALDATA = 121UL,
      FI_EN_ROADDISTANCE = 122UL,
      FI_EN_AIRDISTANCE = 123UL,
      FI_EN_GEOGRAPHICALPOSITION = 124UL,
      FI_EN_COMMENT = 125UL,
      FI_EN_REFINEBYINCLUSION = 126UL,
      FI_EN_REFINEBYASSOCIATION = 127UL,
      FI_EN_DATASET = 128UL,
      FI_EN_ADDRESS = 129UL,
      FI_EN_HOUSENUMBERPATTERN = 130UL,
      FI_EN_INTERMEDIATEDESTINATION = 192UL,
      FI_EN_FINALDESTINATION = 193UL,
      FI_EN_LANDCOVER = 194UL,
      FI_EN_SURFACECOVER = 195UL,
      FI_EN_WATER = 197UL,
      FI_EN_ROUTE = 198UL,
      FI_EN_SPECIALCONTENT = 199UL,
      FI_EN_AIRLINEACCESS = 200UL,
      FI_EN_AIRPORT = 201UL,
      FI_EN_AMUSEMENTPARK = 202UL,
      FI_EN_AUTOMATICTELLERMACHINE = 203UL,
      FI_EN_BANK = 204UL,
      FI_EN_BEACH = 205UL,
      FI_EN_BOWLINGCENTRE = 206UL,
      FI_EN_BUSINESSFACILITY = 207UL,
      FI_EN_BUSSTATION = 208UL,
      FI_EN_CAFE = 209UL,
      FI_EN_CAKEANDPASTRYSHOP = 210UL,
      FI_EN_CASINO = 211UL,
      FI_EN_CHURCH = 212UL,
      FI_EN_CINEMA = 213UL,
      FI_EN_DENTIST = 214UL,
      FI_EN_DRIVETHROUGHBOTTLESHOP = 215UL,
      FI_EN_DRYCLEANERS = 216UL,
      FI_EN_ENTERTAINMENT = 217UL,
      FI_EN_EXHIBITION = 218UL,
      FI_EN_FACTORY = 219UL,
      FI_EN_GARAGE = 220UL,
      FI_EN_GASSTATION = 221UL,
      FI_EN_GOLFCOURSE = 222UL,
      FI_EN_GROCERYSTORE = 223UL,
      FI_EN_HISTORICALMONUMENT = 224UL,
      FI_EN_HOTEL_MOTEL = 225UL,
      FI_EN_ICESKATINGPARK = 226UL,
      FI_EN_MARINA = 227UL,
      FI_EN_MOSQUE = 228UL,
      FI_EN_MOTORCYCLEDEALER = 229UL,
      FI_EN_MOTORINGORGANISATION = 230UL,
      FI_EN_MOUNTAINPASS = 231UL,
      FI_EN_MOUNTAINPEAK = 232UL,
      FI_EN_MUSEUM = 233UL,
      FI_EN_NATURERESERVE = 234UL,
      FI_EN_NIGHTLIFE = 235UL,
      FI_EN_PHYSICIAN = 236UL,
      FI_EN_PLACEOFWORSHIP = 237UL,
      FI_EN_PRACTITIONER = 238UL,
      FI_EN_REALTOR = 239UL,
      FI_EN_RECREATIONAREA = 240UL,
      FI_EN_RECREATIONFACILITY = 241UL,
      FI_EN_RENTALCARSTATION = 242UL,
      FI_EN_RESTAURANT = 243UL,
      FI_EN_RECREATIONVEHICLEPARKING = 244UL,
      FI_EN_SHOPPINGCENTER = 245UL,
      FI_EN_SKIRESORT = 246UL,
      FI_EN_SPORTAIRPORT = 247UL,
      FI_EN_SPORTAREA = 248UL,
      FI_EN_SYNAGOGE = 249UL,
      FI_EN_TRUCKSTOP = 250UL,
      FI_EN_VANTAGEPOINT = 251UL,
      FI_EN_VETERINAERIANSERVICE = 252UL,
      FI_EN_WINEBAR = 253UL,
      FI_EN_WINERY = 254UL,
      FI_EN_ZOO = 255UL,
      FI_EN_COMMUNITYCENTER = 256UL,
      FI_EN_TOURISTOFFICE = 257UL,
      FI_EN_TOURISTATTRACTION = 258UL,
      FI_EN_DRIVINGEXERCISEAREA = 259UL,
      FI_EN_STADIUM = 260UL,
      FI_EN_COMPANY = 261UL,
      FI_EN_DOCTOR = 262UL,
      FI_EN_YACHTBASIN = 263UL,
      FI_EN_WATERSPORTS = 264UL,
      FI_EN_CONVENTIONCENTER = 265UL,
      FI_EN_PHARMACY = 266UL,
      FI_EN_SWIMMING = 267UL,
      FI_EN_CULTURALCENTER = 268UL,
      FI_EN_CONCERTHALL = 269UL,
      FI_EN_SHOP = 270UL,
      FI_EN_TRAVELAGENCY = 272UL,
      FI_EN_RENTACARPARKING = 273UL,
      FI_EN_MONASTERY = 274UL,
      FI_EN_LAUNDRY = 275UL,
      FI_EN_KINDERGARTEN = 276UL,
      FI_EN_HOLIDAYAREA = 278UL,
      FI_EN_FREEPORT = 279UL,
      FI_EN_FIREBRIGADE = 280UL,
      FI_EN_EMERGENCYMEDICALSERVICE = 281UL,
      FI_EN_DEPARTMENTSTORE = 282UL,
      FI_EN_CAMPGROUND = 283UL,
      FI_EN_ARTSCENTER = 284UL,
      FI_EN_RESTAURANTAREA = 285UL,
      FI_EN_OPENPARKINGAREA = 286UL,
      FI_EN_BARORPUB = 287UL,
      FI_EN_BOOKSTORE = 288UL,
      FI_EN_MEDICALSERVICE = 289UL,
      FI_EN_GUESTHOUSE = 290UL,
      FI_EN_SERVICEPARKINGAREA = 291UL,
      FI_EN_CARSPARES = 292UL,
      FI_EN_OTHERCARFACILITIES = 293UL,
      FI_EN_ARBORETUM = 294UL,
      FI_EN_MEMORIAL = 295UL,
      FI_EN_MUSICHALL = 296UL,
      FI_EN_OTHERARTSANDRELIGION = 297UL,
      FI_EN_NEWSPAPEROFFICE = 298UL,
      FI_EN_BROADCASTINGSTATION = 299UL,
      FI_EN_SONGANDDANCETROUPE = 300UL,
      FI_EN_SCIENCEEXHIBITIONCENTER = 301UL,
      FI_EN_OBSERVATORY = 302UL,
      FI_EN_SCIENTIFICRESEARCHINSTITUTION = 303UL,
      FI_EN_PUBLISHINGCOMPANY = 304UL,
      FI_EN_JOURNALEDITORIALOFFICE = 305UL,
      FI_EN_FILMANDTVPRODUCTION = 306UL,
      FI_EN_ARTSTROUPE = 307UL,
      FI_EN_ACROBATICS = 308UL,
      FI_EN_CULTURALTROUPE = 309UL,
      FI_EN_OTHERCULTUREANDSCIENCE = 310UL,
      FI_EN_GOLFTRAININGCENTER = 311UL,
      FI_EN_TENNISCOURT = 312UL,
      FI_EN_GYMNASIUM = 313UL,
      FI_EN_OTHERSPORTS = 314UL,
      FI_EN_EXCHANGES = 315UL,
      FI_EN_INSURANCEAGANCY = 316UL,
      FI_EN_OTHERBANKINGANDBUSINESS = 317UL,
      FI_EN_PUBLICTOILET = 318UL,
      FI_EN_TELECOMOFFICE = 319UL,
      FI_EN_CONFERENCECENTER = 320UL,
      FI_EN_WAREHOUSE = 321UL,
      FI_EN_ARCHIVE = 322UL,
      FI_EN_OTHERPUBLICPLACE = 323UL,
      FI_EN_PEDESTRIANPRECINCT = 324UL,
      FI_EN_INTERNETCAFE = 325UL,
      FI_EN_KARAOKECLUB = 326UL,
      FI_EN_SANATORIUM = 327UL,
      FI_EN_SAUNABATH = 328UL,
      FI_EN_CLUB = 329UL,
      FI_EN_OTHERLEISURE = 330UL,
      FI_EN_EMPORIUM = 331UL,
      FI_EN_SUPERMARKET = 332UL,
      FI_EN_ELECTRICALAPPLIANCESTORE = 333UL,
      FI_EN_PHOTOSTUDIO = 334UL,
      FI_EN_EXPRESSPHOTO = 335UL,
      FI_EN_AUDIOVIDEOSHOP = 336UL,
      FI_EN_HAIRDRESSER = 337UL,
      FI_EN_CLOTHINGSTORE = 338UL,
      FI_EN_SPORTINGGOODSSTORE = 339UL,
      FI_EN_STATIONERYSTORE = 340UL,
      FI_EN_DRUGSTORE = 341UL,
      FI_EN_GLASSESSTORE = 342UL,
      FI_EN_JUWELLERYSTORE = 343UL,
      FI_EN_PAINTINGANDCALLIGRAPHY = 344UL,
      FI_EN_TOYSTORE = 345UL,
      FI_EN_MUSICALINSTRUMENTSTORE = 346UL,
      FI_EN_PETSTORE = 347UL,
      FI_EN_OTHERSHOPPING = 348UL,
      FI_EN_REALTYEXCHANGECENTER = 349UL,
      FI_EN_UPHOLSTERYDESIGNSTUDIO = 350UL,
      FI_EN_REMOVER = 351UL,
      FI_EN_FAIRTRADEMARKET = 352UL,
      FI_EN_FOODOTHERS = 353UL,
      FI_EN_STATEGOVERNMENTDEPARTMENT = 354UL,
      FI_EN_PROVINVIALGOVERNMENTORGAN = 355UL,
      FI_EN_MUNICIPALGOVERNMENTORGAN = 356UL,
      FI_EN_TRAFFICPOLICESTATION = 357UL,
      FI_EN_GOVERNMENTOTHERS = 358UL,
      FI_EN_NURSERY = 359UL,
      FI_EN_TRAININGINSTITUTION = 360UL,
      FI_EN_FIRSTAID = 361UL,
      FI_EN_MOTHERANDCHILDCARE = 362UL,
      FI_EN_MOXIBUSTIONPARLOR = 363UL,
      FI_EN_MEDICALOTHERS = 364UL,
      FI_EN_CEMETERY = 365UL,
      FI_EN_MILITARYCEMETERY = 366UL,
      FI_EN_FUNERALHOME = 367UL,
      FI_EN_MORTUARYOTHERS = 368UL,
      FI_EN_FARM = 369UL,
      FI_EN_MINE = 370UL,
      FI_EN_COFFEESHOP = 371UL,
      FI_EN_CNGSTATION = 372UL,
      FI_EN_LPGSTATION = 373UL,
      FI_EN_INN = 374UL,
      FI_EN_OTHERACCOMMODATION = 375UL,
      FI_EN_FASTFOODRESTAURANT = 376UL,
      FI_EN_CHINESERESTAURANT = 377UL,
      FI_EN_FOREIGNRESTAURANT = 378UL,
      FI_EN_OPERA = 379UL,
      FI_EN_FURNITURESTORE = 380UL,
      FI_EN_TOURISMOTHERS = 381UL,
      FI_EN_ANTIQUEANDARTEXHIBITION = 382UL,
      FI_EN_COMMUNICATIONEQUIPMENT = 383UL,
      FI_EN_COMPUTERSTORE = 384UL,
      FI_EN_CONVENIENCESTORE = 385UL,
      FI_EN_FLOWERSHOP = 386UL,
      FI_EN_PERFORMINGARTS = 387UL,
      FI_EN_SPECIALITYFOODSTORE = 388UL,
      FI_EN_WATCHANDCAMERASTORE = 389UL,
      FI_EN_OPTICIAN = 390UL,
      FI_EN_TEMPLE = 391UL,
      FI_EN_AQUARIUM = 392UL,
      FI_EN_SUBWAYSTATION = 393UL,
      FI_EN_OTHERSTATIONS = 394UL,
      FI_EN_HIGHRISEBUILDING = 395UL,
      FI_EN_SCIENCEANDTECHNOLOGYCENTER = 396UL,
      FI_EN_TELECOMCOMPANY = 397UL,
      FI_EN_OTHERPLACEOFWORSHIP = 398UL,
      FI_EN_CARRACE = 399UL,
      FI_EN_COMMUNITYGROUP = 400UL,
      FI_EN_COSMETICS = 401UL,
      FI_EN_CRAFTWORKGIFT = 402UL,
      FI_EN_ECONOMICCHAINHOTEL = 403UL,
      FI_EN_OPENMARKET = 404UL,
      FI_EN_PARK = 405UL,
      FI_EN_PLANTANDPET = 406UL,
      FI_EN_SECURITIES = 407UL,
      FI_EN_STARHOTEL = 408UL,
      FI_EN_TEASHOP = 409UL,
      FI_EN_MOVIETHEATHER = 410UL,
      FI_EN_VOCATIONALSCHOOL = 411UL,
      FI_EN_DISEASEPREVENTIONORGANIZATION = 412UL,
      FI_EN_COMMUNITYMEDICALTREATMENT = 413UL,
      FI_EN_CULTUREART = 414UL,
      FI_EN_PARKANDRIDE = 415UL,
      FI_EN_CIGARETTEWINE = 416UL,
      FI_EN_VETERINARY = 417UL,
      FI_EN_BATH = 418UL,
      FI_EN_OTHERTRAVEL = 419UL,
      FI_EN_BAKERYANDCAKE = 420UL,
      FI_EN_PLANT = 421UL,
      FI_EN_OFFICEBUILDING = 422UL,
      FI_EN_HORSERACETRACK = 423UL,
      FI_EN_POINTADDRESS = 424UL,
      FI_EN_CONSUMERELECTRONICS = 425UL,
      FI_EN_HOMEIMPROVEMENT = 426UL,
      FI_EN_HOMESPECIALTY = 427UL,
      FI_EN_OFFICESUPPLY = 428UL,
      FI_EN_SPECIALTYSTORE = 429UL,
      FI_EN_MILITARYBASE = 430UL,
      FI_EN_TRANSPORTATIONSSERVICE = 431UL,
      FI_EN_ANIMALPARK = 432UL,
      FI_EN_CARGOCENTER = 433UL,
      FI_EN_COUNTYCOUNCIL = 434UL,
      FI_EN_INDUSTRIALZONE = 435UL,
      FI_EN_PUBLICRESTROOM = 436UL,
      FI_EN_WEIGHTSTATION = 437UL,
      FI_EN_ELECTRICCHARGESTATION = 438UL,
      FI_EN_PUBLICTRANSPORT = 439UL,
      FI_EN_HAMLET = 440UL,
      FI_EN_GOLFPRACTISE = 441UL,
      FI_EN_FUNERALDIRECTOR = 442UL,
      FI_EN_OTHERLIFESERVICE = 443UL,
      FI_EN_CHARGINGSTATION = 444UL,
      FI_EN_MARUTIPLANTOFFICE = 445UL,
      FI_EN_ACURADEALER = 450UL,
      FI_EN_ALFAROMEODEALER = 451UL,
      FI_EN_ASTONDEALER = 452UL,
      FI_EN_AUDIDEALER = 453UL,
      FI_EN_BENTLEYDEALER = 454UL,
      FI_EN_BMWDEALER = 455UL,
      FI_EN_BUICKDEALER = 457UL,
      FI_EN_CADILLACDEALER = 458UL,
      FI_EN_CHEVROLETDEALER = 459UL,
      FI_EN_CHRYSLERDEALER = 460UL,
      FI_EN_CITROENDEALER = 461UL,
      FI_EN_DAEWOODEALER = 462UL,
      FI_EN_DAIHATSUDEALER = 463UL,
      FI_EN_DODGEDEALER = 464UL,
      FI_EN_FERRARIDEALER = 465UL,
      FI_EN_FIATDEALER = 466UL,
      FI_EN_FORDDEALER = 467UL,
      FI_EN_GMCDEALER = 468UL,
      FI_EN_GMHDEALER = 469UL,
      FI_EN_HONDADEALER = 470UL,
      FI_EN_HYUNDAIDEALER = 471UL,
      FI_EN_INDEPENDENTGARAGEDEALER = 472UL,
      FI_EN_ISUZUDEALER = 473UL,
      FI_EN_JAGUARDEALER = 474UL,
      FI_EN_JEEPDEALER = 475UL,
      FI_EN_KIADEALER = 476UL,
      FI_EN_LADADEALER = 477UL,
      FI_EN_LAMBORGHINIDEALER = 478UL,
      FI_EN_LANCIADEALER = 479UL,
      FI_EN_LANDDEALER = 480UL,
      FI_EN_LANDROVERDEALER = 481UL,
      FI_EN_LEXUSDEALER = 482UL,
      FI_EN_LINCOLNDEALER = 483UL,
      FI_EN_MASERATIDEALER = 484UL,
      FI_EN_MAZDADEALER = 485UL,
      FI_EN_MCCDEALER = 486UL,
      FI_EN_MERCEDESBENZDEALER = 487UL,
      FI_EN_MGDEALER = 488UL,
      FI_EN_MINIDEALER = 489UL,
      FI_EN_MITSUBISHIDEALER = 490UL,
      FI_EN_NISSANDEALER = 491UL,
      FI_EN_OLDSMOBILEDEALER = 492UL,
      FI_EN_OPELDEALER = 493UL,
      FI_EN_PEUGEOTDEALER = 494UL,
      FI_EN_PONTIACDEALER = 495UL,
      FI_EN_PORSCHEDEALER = 496UL,
      FI_EN_RENAULTDEALER = 497UL,
      FI_EN_ROLLSROYCEDEALER = 498UL,
      FI_EN_ROVERDEALER = 499UL,
      FI_EN_SAABDEALER = 500UL,
      FI_EN_SATURNDEALER = 501UL,
      FI_EN_SEATDEALER = 502UL,
      FI_EN_SKODADEALER = 503UL,
      FI_EN_SUBARUDEALER = 504UL,
      FI_EN_SUZUKIDEALER = 505UL,
      FI_EN_TOYOTADEALER = 506UL,
      FI_EN_VOLKSWAGENDEALER = 507UL,
      FI_EN_VOLVODEALER = 508UL,
      FI_EN_GMDEALER = 510UL,
      FI_EN_VAUXHALLDEALER = 511UL,
      FI_EN_INFINITIDEALER = 512UL,
      FI_EN_PROTONDEALER = 513UL,
      FI_EN_MARUTIDEALER = 514UL,
      FI_EN_ACURA = 600UL,
      FI_EN_ALFAROMEO = 601UL,
      FI_EN_ASTON = 602UL,
      FI_EN_AUDI = 603UL,
      FI_EN_BENTLEY = 604UL,
      FI_EN_BMW = 605UL,
      FI_EN_BOSCH = 606UL,
      FI_EN_BUICK = 607UL,
      FI_EN_CADILLAC = 608UL,
      FI_EN_CHEVROLET = 609UL,
      FI_EN_CHRYSLER = 610UL,
      FI_EN_CITROEN = 611UL,
      FI_EN_DAEWOO = 612UL,
      FI_EN_DAIHATSU = 613UL,
      FI_EN_DODGE = 614UL,
      FI_EN_FERRARI = 615UL,
      FI_EN_FIAT = 616UL,
      FI_EN_FORD = 617UL,
      FI_EN_GMC = 618UL,
      FI_EN_GMH = 619UL,
      FI_EN_HONDA = 620UL,
      FI_EN_HYUNDAI = 621UL,
      FI_EN_INDEPENDENTGARAGE = 622UL,
      FI_EN_ISUZU = 623UL,
      FI_EN_JAGUAR = 624UL,
      FI_EN_JEEP = 625UL,
      FI_EN_KIA = 626UL,
      FI_EN_LADA = 627UL,
      FI_EN_LAMBORGHINI = 628UL,
      FI_EN_LANCIA = 629UL,
      FI_EN_LAND = 630UL,
      FI_EN_LANDROVER = 631UL,
      FI_EN_LEXUS = 632UL,
      FI_EN_LINCOLN = 633UL,
      FI_EN_MASERATI = 634UL,
      FI_EN_MAZDA = 635UL,
      FI_EN_MCC = 636UL,
      FI_EN_MERCEDESBENZ = 637UL,
      FI_EN_MG = 638UL,
      FI_EN_MINI = 639UL,
      FI_EN_MITSUBISHI = 640UL,
      FI_EN_NISSAN = 641UL,
      FI_EN_OLDSMOBILE = 642UL,
      FI_EN_OPEL = 643UL,
      FI_EN_PEUGEOT = 644UL,
      FI_EN_PONTIAC = 645UL,
      FI_EN_PORSCHE = 646UL,
      FI_EN_RENAULT = 647UL,
      FI_EN_ROLLSROYCE = 648UL,
      FI_EN_ROVER = 649UL,
      FI_EN_SAAB = 650UL,
      FI_EN_SATURN = 651UL,
      FI_EN_SEAT = 652UL,
      FI_EN_SKODA = 653UL,
      FI_EN_SUBARU = 654UL,
      FI_EN_SUZUKI = 655UL,
      FI_EN_TOYOTA = 656UL,
      FI_EN_VOLKSWAGEN = 657UL,
      FI_EN_VOLVO = 658UL,
      FI_EN_GM = 660UL,
      FI_EN_BLAUPUNKT = 661UL,
      FI_EN_EVOBUS = 662UL,
      FI_EN_IRISBUS = 663UL,
      FI_EN_NEOPLAN = 664UL,
      FI_EN_OMNIBUS = 665UL,
      FI_EN_SCANIA = 666UL,
      FI_EN_VOLVOTRUCKS = 667UL,
      FI_EN_BUSSERVICE = 668UL,
      FI_EN_DAF = 669UL,
      FI_EN_MANTRUCK = 670UL,
      FI_EN_MERCEDESBENZTRUCK = 671UL,
      FI_EN_VAUXHALL = 672UL,
      FI_EN_MERCEDESBENZOMNIPLUS = 673UL,
      FI_EN_SETRAOMNIPLUS = 674UL,
      FI_EN_INFINITI = 675UL,
      FI_EN_RENAULTTRUCK = 676UL,
      FI_EN_PROTON = 677UL,
      FI_EN_VOLVOBUS = 678UL,
      FI_EN_BOSCHSERVICEPARTNER = 679UL,
      FI_EN_DAFTRUCKS = 680UL,
      FI_EN_MERCEDESBENZBUS = 681UL,
      FI_EN_SETRA = 682UL,
      FI_EN_JAC = 683UL,
      FI_EN_MARUTI = 684UL,
      FI_EN_SHOPPING = 751UL,
      FI_EN_BANKINGANDBUSINESS = 752UL,
      FI_EN_TRAVEL = 753UL,
      FI_EN_PUBLICPLACES = 754UL,
      FI_EN_AUTOMOTIVE = 755UL,
      FI_EN_PERSONALSERVICES = 756UL,
      FI_EN_LEISURE = 757UL,
      FI_EN_EMERGENCY = 758UL,
      FI_EN_CARDEALER = 759UL,
      FI_EN_MENUITEMRESTAURANT = 760UL,
      FI_EN_MENUITEMHOTEL = 761UL,
      FI_EN_TOURISMANDSIGHTSEEING = 762UL,
      FI_EN_ARTANDRELIGION = 763UL,
      FI_EN_CULTURALANDSCIENTIFICINSTITUTES = 764UL,
      FI_EN_SPORTS = 765UL,
      FI_EN_REALESTATE = 766UL,
      FI_EN_FOOD = 767UL,
      FI_EN_GOVERNMENTOFFICE = 768UL,
      FI_EN_EDUCATION = 769UL,
      FI_EN_MEDICAL = 770UL,
      FI_EN_MORTUARY = 771UL,
      FI_EN_INTERIORREPRESENTATION = 772UL,
      FI_EN_FOREIGNREPRESENTATION = 773UL,
      FI_EN_MENUITEMOTHERS = 774UL,
      FI_EN_GROUPPLACEOFWORSHIP = 775UL,
      FI_EN_GROUPNIGHTLIFE = 776UL,
      FI_EN_GROUPTOURISTATTRACTION = 777UL,
      FI_EN_GROUPSTATION = 778UL,
      FI_EN_GROUPBUSINESS = 779UL,
      FI_EN_GROUPHIGHEREDUCATION = 780UL,
      FI_EN_GROUPEATANDDRINK = 781UL,
      FI_EN_GROUPELECTRICALAPPLIANCECHAINSTORE = 782UL,
      FI_EN_GROUPHEALTHCARE = 783UL,
      FI_EN_GROUPSPECIALGROUND = 784UL,
      FI_EN_GROUPSPECIALMARKET = 785UL,
      FI_EN_GROUPLIBRARY = 786UL,
      FI_EN_GROUPBANKPUBLICSERVICE = 787UL,
      FI_EN_GROUPLOGISTICSANDPOSTOFFICE = 788UL,
      FI_EN_GROUPENTERPRISEANDFACTORY = 789UL,
      FI_EN_GROUPSPORTSENTERTAINMENT = 790UL,
      FI_EN_GROUPBUSINESSCENTER = 791UL,
      FI_EN_GROUPMEDICALSERVICE = 792UL,
      FI_EN_GROUPMARINA = 793UL,
      FI_EN_GROUPFRANCHISESTORE = 794UL,
      FI_EN_GROUPVEHICLE = 795UL,
      FI_EN_GROUPGOVERNOFFICECOMMUNITY = 796UL,
      FI_EN_GROUPLIFESERVICE = 798UL,
      FI_EN_GROUPCOMMERCIALRESIDENTIALBUILDING = 799UL,
      FI_EN_GROUPSPORTSTATIONER = 800UL,
      FI_EN_GROUPSPORTSGROUND = 801UL,
      FI_EN_GROUPPARKPLAZA = 802UL,
      FI_EN_GROUPFINANCEINSURANCE = 803UL,
      FI_EN_GROUPFURNITUREHOMEDECORATION = 804UL,
      FI_EN_GROUPPLANTOFFICES = 805UL,
      FI_EN_GROUPMARUTI = 806UL,
      FI_EN_CARWASHES = 901UL,
      FI_EN_PARKINGGARAGE = 902UL,
      FI_EN_ROADASSISTANCE = 903UL,
      FI_EN_AUTOPARTS = 904UL,
      FI_EN_PARKANDRIDEFACILITY = 905UL,
      FI_EN_AMERICANFOOD = 906UL,
      FI_EN_BREAKFAST = 907UL,
      FI_EN_BBQ = 908UL,
      FI_EN_BREWPUP = 909UL,
      FI_EN_DELI = 910UL,
      FI_EN_ITALIAN = 911UL,
      FI_EN_EUROPEAN = 912UL,
      FI_EN_FRENCH = 913UL,
      FI_EN_GREEK = 914UL,
      FI_EN_GRILL = 915UL,
      FI_EN_INDIAN = 916UL,
      FI_EN_INTERNATIONAL = 917UL,
      FI_EN_JAPANESE = 918UL,
      FI_EN_KOSHER = 919UL,
      FI_EN_LATIN = 920UL,
      FI_EN_MEXICAN = 921UL,
      FI_EN_MIDDLEEASTERN = 922UL,
      FI_EN_SEAFOOD = 923UL,
      FI_EN_STEAKHOUSE = 924UL,
      FI_EN_THAI = 925UL,
      FI_EN_VEGETARIAN = 926UL,
      FI_EN_OTHERRESTAURANT = 927UL,
      FI_EN_COCKTAILLOUNGE = 928UL,
      FI_EN_LOCALTRANSIT = 929UL,
      FI_EN_RVPARKS = 930UL,
      FI_EN_MALLS = 931UL,
      FI_EN_MENSAPPAREL = 932UL,
      FI_EN_WOMENSAPPAREL = 933UL,
      FI_EN_CHILDRENSAPPAREL = 934UL,
      FI_EN_SHOEFOOTWEAR = 935UL,
      FI_EN_HOMEANDGARDEN = 936UL,
      FI_EN_CDRECORDVIDEO = 937UL,
      FI_EN_MAJORAPPLIANCE = 938UL,
      FI_EN_ENTERTAINMENTELECTRONICS = 939UL,
      FI_EN_FLOWERSANDJEWELRY = 940UL,
      FI_EN_VIDEOANDGAME = 941UL,
      FI_EN_WINEANDLIQUOR = 942UL,
      FI_EN_DISCOUNTSTORE = 943UL,
      FI_EN_BOATING = 944UL,
      FI_EN_GIFTANTIQUEART = 945UL,
      FI_EN_VARIETYSTORE = 946UL,
      FI_EN_FOODBEVERAGE = 947UL,
      FI_EN_GENERALMERCHANDISE = 948UL,
      FI_EN_TAILORANDALTERATION = 949UL,
      FI_EN_HEALTHCLUB = 950UL,
      FI_EN_SPORTSCOMPLEX = 951UL,
      FI_EN_WASTEANDSANITARY = 952UL,
      FI_EN_CHECKCASHINGSERVICES = 953UL,
      FI_EN_FIREDEPARTMENT = 954UL,
      FI_EN_SOCIALSERVICE = 955UL,
      FI_EN_RETIREMENTNURSINGHOME = 956UL,
      FI_EN_TAXSERVICE = 957UL,
      FI_EN_BANKETHALL = 958UL,
      FI_EN_REPAIRSERVICE = 959UL,
      FI_EN_STORAGE = 960UL,
      FI_EN_MOVER = 961UL,
      FI_EN_MONEYTRANSFERRINGSERVICES = 962UL,
      FI_EN_TELEPHONESERVICE = 963UL,
      FI_EN_UTILITIES = 964UL,
      FI_EN_OTHERCOMMUNICATION = 965UL,
      FI_EN_OTHERWORSHIP = 968UL,
      FI_EN_NONGMCARDEALERS = 969UL,
      FI_EN_BUSINESSSERVICE = 970UL,
      FI_EN_ONEORTWOSTAR = 971UL,
      FI_EN_THREESTAR = 972UL,
      FI_EN_FOURSTAR = 973UL,
      FI_EN_FIVESTAR = 974UL,
      FI_EN_NONSTAR = 975UL,
      FI_EN_VACATIONVILLAGE = 976UL,
      FI_EN_CALIFORNIANRESTAURANT = 977UL,
      FI_EN_SOUTHWESTERNRESTAURANT = 978UL,
      FI_EN_BURGER = 979UL,
      FI_EN_CHICKEN = 980UL,
      FI_EN_ICECREAM = 981UL,
      FI_EN_PIZZA = 982UL,
      FI_EN_SANDWICH = 983UL,
      FI_EN_SNACK = 984UL,
      FI_EN_SUSHI = 985UL,
      FI_EN_VEGAN = 986UL,
      FI_EN_SPORTINSTRUCTIONCAMP = 987UL,
      FI_EN_NORTHWESTERNRESTAURANT = 988UL,
      FI_EN_JIANGXIRESTAURANT = 989UL,
      FI_EN_GUANGXIRESTAURANT = 990UL,
      FI_EN_TAIWANESERESTAURANT = 991UL,
      FI_EN_YUNNANRESTAURANT = 992UL,
      FI_EN_MONGOLIANRESTAURANT = 993UL,
      FI_EN_JIANGSURESTAURANT = 994UL,
      FI_EN_SHANDONGRESTAURANT = 995UL,
      FI_EN_HUNANRESTAURANT = 996UL,
      FI_EN_CANTONESERESTAURANT = 997UL,
      FI_EN_SZECHUANRESTAURANT = 998UL,
      FI_EN_NORTHEASTERNRESTAURANT = 999UL,
      FI_EN_BEIJINGRESTAURANT = 1000UL,
      FI_EN_SHANGHAIRESTAURANT = 1001UL,
      FI_EN_PORRIDGE = 1002UL,
      FI_EN_ISLAMICRESTAURANT = 1003UL,
      FI_EN_DUTCHRESTAURANT = 1004UL,
      FI_EN_BELGIANRESTAURANT = 1005UL,
      FI_EN_PORTUGUESERESTAURANT = 1006UL,
      FI_EN_SWISSRESTAURANT = 1007UL,
      FI_EN_SPANISHRESTAURANT = 1008UL,
      FI_EN_MALTESERESTAURANT = 1009UL,
      FI_EN_BOHEMIANRESTAURANT = 1010UL,
      FI_EN_BALKANRESTAURANT = 1011UL,
      FI_EN_BALTICRESTAURANT = 1012UL,
      FI_EN_HUNGARIANRESTAURANT = 1013UL,
      FI_EN_IRISHRESTAURANT = 1014UL,
      FI_EN_SCANDINAVIANRESTAURANT = 1015UL,
      FI_EN_FINNISHRESTAURANT = 1016UL,
      FI_EN_RUSSIANRESTAURANT = 1017UL,
      FI_EN_BRITISHRESTAURANT = 1018UL,
      FI_EN_POLISHRESTAURANT = 1019UL,
      FI_EN_AUSTRIANRESTAURANT = 1020UL,
      FI_EN_GERMANRESTAURANT = 1021UL,
      FI_EN_EASTEUROPEANRESTAURANT = 1022UL,
      FI_EN_TAPASRESTAURANT = 1023UL,
      FI_EN_HAWAIIANRESTAURANT = 1024UL,
      FI_EN_ASIANRESTAURANT = 1025UL,
      FI_EN_TURKISHRESTAURANT = 1026UL,
      FI_EN_INDONESIANRESTAURANT = 1027UL,
      FI_EN_VIETNAMESIANRESTAURANT = 1028UL,
      FI_EN_AUSTRALIANRESTAURANT = 1029UL,
      FI_EN_AFRICANRESTAURANT = 1030UL,
      FI_EN_KOREANRESTAURANT = 1031UL,
      FI_EN_AZERBAIJANRESTAURANT = 1032UL,
      FI_EN_SURINAMESERESTAURANT = 1033UL,
      FI_EN_BELORUSSIANRESTAURANT = 1034UL,
      FI_EN_FILIPINORESTAURANT = 1035UL,
      FI_EN_CAUCASIANRESTAURANT = 1036UL,
      FI_EN_SOUTHAMERICANRESTAURANT = 1037UL,
      FI_EN_ARGENTINEANRESTAURANT = 1038UL,
      FI_EN_BRAZILIANRESTAURANT = 1039UL,
      FI_EN_CHILEANRESTAURANT = 1040UL,
      FI_EN_CRIOLLARESTAURANT = 1041UL,
      FI_EN_FONDUERESTAURANT = 1042UL,
      FI_EN_FUSIONRESTAURANT = 1043UL,
      FI_EN_PASTRIERESTAURANT = 1044UL,
      FI_EN_OTHERCLOTHING = 1045UL,
      FI_EN_SPECIALTYCLOTHING = 1046UL,
      FI_EN_HOMECENTERS = 1047UL,
      FI_EN_AGRICULTURALMARKET = 1048UL,
      FI_EN_LOTTERYBOOTH = 1049UL,
      FI_EN_POLICESERVICES = 1050UL,
      FI_EN_SPORTSCENTERS = 1051UL,
      FI_EN_CATHOLIC = 1052UL,
      FI_EN_OTHERINTERNALITIONALRESTAURANT = 1053UL,
      FI_EN_USERPOI_MINCAT = 1792UL,
      FI_EN_USERPOI_MAXCAT = 2047UL,
      FI_EN_SXMPOI_MINCAT = 2048UL,
      FI_EN_SXMPOI_MAXCAT = 2303UL,
      FI_EN_GROUPFUELAUTO = 3001UL,
      FI_EN_GROUPPARKING = 3002UL,
      FI_EN_GROUPSERVICEMAINTENANCE = 3003UL,
      FI_EN_GROUPFOODANDNIGHTLIFE = 3004UL,
      FI_EN_GROUPTRAVELLODGING = 3005UL,
      FI_EN_GROUPSPORTSFACILITIESVENUES = 3006UL,
      FI_EN_GROUPTRANSPORTATION = 3007UL,
      FI_EN_GROUPCAMPINGANDRVPARKS = 3008UL,
      FI_EN_GROUPSHOPPINGSERVICES = 3009UL,
      FI_EN_GROUPMALLSANDCLOTHING = 3010UL,
      FI_EN_GROUPSHOPPINGCENTERMALLS = 3011UL,
      FI_EN_GROUPCLOTHINGSTORE = 3012UL,
      FI_EN_GROUPHOMEIMPROVEMENT = 3013UL,
      FI_EN_GROUPSPECIALTYRETAIL = 3014UL,
      FI_EN_GROUPELECTRONICS = 3015UL,
      FI_EN_GROUPFOODBEVERAGES = 3016UL,
      FI_EN_GROUPOTHERRETAIL = 3017UL,
      FI_EN_GROUPPROFESSIONALSERVICES = 3018UL,
      FI_EN_GROUPCOMMUNITYANDEMERGENCY = 3019UL,
      FI_EN_GROUPTELEPHONEANDUTILITIES = 3020UL,
      FI_EN_GROUPRECREATIONCOMMUNITYCENTER = 3021UL,
      FI_EN_GROUPCOMMUNITYSERVICES = 3022UL,
      FI_EN_GROUPENTERTAINMENT = 3023UL,
      FI_EN_GROUPRECREATION = 3024UL,
      FI_EN_GROUPTOURISTANDCULTURAL = 3025UL,
      FI_EN_GROUPCULTURALVENUES = 3026UL,
      FI_EN_GROUPRESTSTOPS = 3027UL,
      FI_EN_GROUPBANKINGFINANCIAL = 3028UL,
      FI_EN_GROUPDEALERSHIPS = 3029UL,
      FI_EN_GROUPEMERGENCYSERVICES = 3030UL,
      FI_EN_GROUPAMERICANFOOD = 3031UL,
      FI_EN_GROUPJAPANESEFOOD = 3032UL,
      FI_EN_GROUPVEGETARIANFOOD = 3033UL,
      FI_EN_GROUPOTHERRESTAURANT = 3034UL,
      FI_EN_GROUPCHINESERESTAURANT = 3035UL,
      FI_EN_GROUPLATINRESTAURANT = 3036UL,
      FI_EN_SKIRESORT2 = 3100UL,
      FI_EN_DP_MERIANSCOUT = 4000UL,
      FI_EN_DP_VIAMICHELIN = 4001UL,
      FI_EN_DP_FALK = 4002UL,
      FI_EN_F_SMALLPARK = 4096UL,
      FI_EN_F_LARGEPARK = 4097UL,
      FI_EN_F_SMALLSTADIUM = 4098UL,
      FI_EN_F_LARGESTADIUM = 4099UL,
      FI_EN_F_FASTFOOD = 4100UL,
      FI_EN_F_CHINESEFOOD = 4101UL,
      FI_EN_F_CHINESESICHUANFOOD = 4102UL,
      FI_EN_F_CHINESEHUNANFOOD = 4103UL,
      FI_EN_F_CHINESESHANDONGFOOD = 4104UL,
      FI_EN_F_CHINESEGUANGDONGFOOD = 4105UL,
      FI_EN_F_CHINESESHANGHAIFOOD = 4106UL,
      FI_EN_F_FRENCHFOOD = 4107UL,
      FI_EN_F_ITALIANFOOD = 4108UL,
      FI_EN_F_BRAZILIANFOOD = 4109UL,
      FI_EN_F_GERMANFOOD = 4110UL,
      FI_EN_F_USFOOD = 4111UL,
      FI_EN_F_JAPANESEFOOD = 4112UL,
      FI_EN_F_KOREANFOOD = 4113UL,
      FI_EN_F_MALAYSIANFOOD = 4114UL,
      FI_EN_F_INDIANFOOD = 4115UL,
      FI_EN_F_SPANISHFOOD = 4116UL,
      FI_EN_F_MEXICANFOOD = 4117UL,
      FI_EN_F_TURKISHFOOD = 4118UL,
      FI_EN_F_GREEKFOOD = 4119UL,
      FI_EN_F_DUTCHFOOD = 4120UL,
      FI_EN_F_BELGIANFOOD = 4121UL,
      FI_EN_F_DANISHFOOD = 4122UL,
      FI_EN_F_SWEDISHFOOD = 4123UL,
      FI_EN_F_SOUMIFOOD = 4124UL,
      FI_EN_F_NORWEGIANFOOD = 4125UL,
      FI_EN_F_CZECHFOOD = 4126UL,
      FI_EN_F_ARGENTINEFOOD = 4127UL,
      FI_EN_F_PORTUGESEFOOD = 4128UL,
      FI_EN_F_CANADIANFOOD = 4129UL,
      FI_EN_F_BRITISHFOOD = 4130UL,
      FI_EN_F_PUBFOOD = 4131UL,
      FI_EN_F_EGYTIANFOOD = 4132UL,
      FI_EN_F_PERSIANFOOD = 4133UL,
      FI_EN_F_ARABFOOD = 4134UL,
      FI_EN_F_RUSSIANFOOD = 4135UL,
      FI_EN_F_CHAFINGDISHFOOD = 4136UL,
      FI_EN_F_KOSHERFOOD = 4137UL,
      FI_EN_F_MUSLIMFOOD = 4138UL,
      FI_EN_F_BAR = 4140UL,
      FI_EN_F_CAFE = 4141UL,
      FI_EN_F_TEASHOP = 4142UL,
      FI_EN_F_ACCOMMODATIONHOTEL = 4143UL,
      FI_EN_F_ACCOMMODATIONINN = 4144UL,
      FI_EN_F_ACCOMMODATIONBEDANDBREAKFAST = 4145UL,
      FI_EN_F_ACCOMMODATIONGUESTHOUSE = 4146UL,
      FI_EN_F_ACCOMMODATIONMOTEL = 4147UL,
      FI_EN_F_ACCOMMODATIONAPARTMENTHOTEL = 4148UL,
      FI_EN_F_THREESTARACCOMMODATION = 4149UL,
      FI_EN_F_FOURSTARACCOMMODATION = 4150UL,
      FI_EN_F_FIVESTARACCOMMODATION = 4151UL,
      FI_EN_F_STOCKEXCHANGE = 4152UL,
      FI_EN_F_FUTURESEXCHANGE = 4153UL,
      FI_EN_F_GOLDEXCHANGE = 4154UL,
      FI_EN_F_DOMESTICAPPLIANCES = 4155UL,
      FI_EN_F_COMPUTERS = 4156UL,
      FI_EN_F_MOBILEPHONES = 4157UL,
      FI_EN_F_PHOTOEQUIPMENT = 4158UL,
      FI_EN_F_ACOUSTICEQUIPMENT = 4159UL,
      FI_EN_F_ELECTRICAPPLICATIONS = 4160UL,
      FI_EN_F_MENSCLOTHES = 4161UL,
      FI_EN_F_WOMENSCLOTHES = 4162UL,
      FI_EN_F_CHILDRENWEAR = 4163UL,
      FI_EN_F_COSTUMERENTAL = 4164UL,
      FI_EN_F_FOREIGNFOOD = 4165UL,
      FI_EN_F_OTHERCOFFEE = 4166UL,
      FI_EN_F_ONESTARACCOMMODATION = 4167UL,
      FI_EN_F_TWOSTARACCOMMODATION = 4168UL,
      FI_EN_F_PARKANDRIDEPARKING = 4169UL,
      FI_EN_F_OPENAREAPARKING = 4170UL,
      FI_EN_F_GARAGEPARKING = 4171UL,
      FI_EN_F_RENTACARPARKING = 4172UL,
      FI_EN_F_MULTISTOREYPARKING = 4173UL,
      FI_EN_F_AMERICANFOOD = 4174UL,
      FI_EN_F_CALIFORNIANFOOD = 4175UL,
      FI_EN_F_CONTINENTALFOOD = 4176UL,
      FI_EN_F_OTHERFOOD = 4177UL,
      FI_EN_F_SEAFOOD = 4178UL,
      FI_EN_F_THAIFOOD = 4179UL,
      FI_EN_F_VEGETARIANFOOD = 4180UL,
      FI_EN_F_VIETNAMESEFOOD = 4181UL,
      FI_EN_F_UNKNOWNFOOD = 4182UL,
      FI_EN_F_AUSTRIANFOOD = 4183UL,
      FI_EN_F_BARBEQUE_SOUTHERN = 4184UL,
      FI_EN_F_BISTRO = 4185UL,
      FI_EN_F_BREWPUB = 4186UL,
      FI_EN_F_BRITHISHISLESFOOD = 4187UL,
      FI_EN_F_CAJUN_CARRIBEANFOOD = 4188UL,
      FI_EN_F_EASTEUROPEANFOOD = 4189UL,
      FI_EN_F_GRILL = 4190UL,
      FI_EN_F_HAWAIIAN_POLYNESIANFOOD = 4191UL,
      FI_EN_F_HUNGARIANFOOD = 4192UL,
      FI_EN_F_INDONESIAN_MALAYSIANFOOD = 4193UL,
      FI_EN_F_LATINAMERICANFOOD = 4194UL,
      FI_EN_F_MALTESEFOOD = 4195UL,
      FI_EN_F_MIDDLEEASTERNFOOD = 4196UL,
      FI_EN_F_FILIPINOFOOD = 4197UL,
      FI_EN_F_POLISHFOOD = 4198UL,
      FI_EN_F_PORTUGUESEFOOD = 4199UL,
      FI_EN_F_SANDWICH = 4200UL,
      FI_EN_F_SCANDINAVIANFOOD = 4201UL,
      FI_EN_F_SOUTHAMERICANFOOD = 4202UL,
      FI_EN_F_SOUTHEASTASIANFOOD = 4203UL,
      FI_EN_F_SOUTHWESTERNFOOD = 4204UL,
      FI_EN_F_SURINAMESEFOOD = 4205UL,
      FI_EN_F_STEAKHOUSE = 4206UL,
      FI_EN_F_SWISSFOOD = 4207UL,
      FI_EN_F_AFRICANFOOD = 4208UL,
      FI_EN_F_INTERNATIONALFOOD = 4209UL,
      FI_EN_F_BOHEMIANFOOD = 4210UL,
      FI_EN_F_BALKANFOOD = 4211UL,
      FI_EN_F_FINNISHFOOD = 4212UL,
      FI_EN_F_AUSTRALIANFOOD = 4213UL,
      FI_EN_F_LPG_AVAILABLE = 4214UL,
      FI_EN_F_PETROL_AVAILABLE = 4215UL,
      FI_EN_F_DIESEL_AVAILABLE = 4216UL,
      FI_EN_F_CNG_AVAILABLE = 4217UL,
      FI_EN_F_E85_AVAILABLE = 4218UL,
      FI_EN_F_24H_OPEN = 4219UL,
      FI_EN_F_ONETWOSTARS = 4220UL,
      FI_EN_F_THREESTARS = 4221UL,
      FI_EN_F_FOURSTARS = 4222UL,
      FI_EN_F_FIVESTARS = 4223UL,
      FI_EN_F_ELECTRICCHARGINGSTATION = 4225UL,
      FI_EN_F_BIODIESEL = 4269UL,
      FI_EN_F_HYDROGEN = 4270UL,
      FI_EN_F_ADBLUE = 4273UL,
      FI_EN_MCDONALDS = 32768UL,
      FI_EN_BURGERKING = 32769UL,
      FI_EN_KFC = 32770UL,
      FI_EN_PIZZAHUT = 32771UL,
      FI_EN_HAAGENDASZ = 32772UL,
      FI_EN_STARBUCKS = 32773UL,
      FI_EN_UBCCOFFEE = 32774UL,
      FI_EN_PEOPLESBANKOFCHINA = 32775UL,
      FI_EN_INDANDCOMBANKOFCHINA = 32776UL,
      FI_EN_CHINACONSTRUCTIONBANK = 32777UL,
      FI_EN_AGICULTURALBANKOFCHINA = 32778UL,
      FI_EN_BANKOFCHINA = 32779UL,
      FI_EN_CHINAMERCHANTSBANK = 32780UL,
      FI_EN_COMMUNICATIONBANKOFCHINA = 32781UL,
      FI_EN_HUAXIABANK = 32782UL,
      FI_EN_MINGSHENGBANKINGCORP = 32783UL,
      FI_EN_CHINAEVERBRIGHTBANK = 32784UL,
      FI_EN_CITICINDUSTRIALBANK = 32785UL,
      FI_EN_FAMOUSFOREIGNBANK = 32786UL,
      FI_EN_ARAL = 32787UL,
      FI_EN_BP = 32788UL,
      FI_EN_SHELL = 32789UL,
      FI_EN_PETROCHINA = 32790UL,
      FI_EN_EXXONMOBIL = 32791UL,
      FI_EN_TOTAL = 32792UL,
      FI_EN_AVIA = 32793UL,
      FI_EN_AGIP = 32794UL,
      FI_EN_ORLEN = 32795UL,
      FI_EN_SINOPEC = 32796UL,
      FI_EN_REALBREWEDTEA = 32797UL,
      FI_EN_ORIGUS = 32798UL,
      FI_EN_CHINARESOURCES = 32799UL,
      FI_EN_ATMPEOPLESBANKOFCHINA = 32875UL,
      FI_EN_ATMINDANDCOMBANKOFCHINA = 32876UL,
      FI_EN_ATMCHINACONSTRUCTIONBANK = 32877UL,
      FI_EN_ATMAGICULTURALBANKOFCHINA = 32878UL,
      FI_EN_ATMBANKOFCHINA = 32879UL,
      FI_EN_ATMCHINAMERCHANTSBANK = 32880UL,
      FI_EN_ATMCOMMUNICATIONBANKOFCHINA = 32881UL,
      FI_EN_ATMHUAXIABANK = 32882UL,
      FI_EN_ATMMINGSHENGBANKINGCORP = 32883UL,
      FI_EN_ATMCHINAEVERBRIGHTBANK = 32884UL,
      FI_EN_ATMCITICINDUSTRIALBANK = 32885UL,
      FI_EN_ATMFAMOUSFOREIGNBANK = 32886UL,
      FI_EN_ATMGUANGDONGDEVELOPMENTBANK = 32887UL,
      FI_EN_ATMSHENZENDEVELOPMENTBANK = 32888UL,
      FI_EN_ATMPUDONGDEVELOPMENTBANK = 32889UL,
      FI_EN_ATMRURALCREDITCOOPCHINA = 32890UL,
      FI_EN_ATMCITIBANK = 32891UL,
      FI_EN_ATMHBSC = 32892UL,
      FI_EN_ATMSTDCHARTEREDBANK = 32893UL,
      FI_EN_ATMDAIICHIKANGYOBANK = 32894UL,
      FI_EN_GUANGDONGDEVELOPMENTBANK = 32895UL,
      FI_EN_SHENZENDEVELOPMENTBANK = 32896UL,
      FI_EN_PUDONGDEVELOPMENTBANK = 32897UL,
      FI_EN_RURALCREDITCOOPCHINA = 32898UL,
      FI_EN_CITIBANK = 32899UL,
      FI_EN_HBSC = 32900UL,
      FI_EN_STDCHARTEREDBANK = 32901UL,
      FI_EN_DAIICHIKANGYOBANK = 32902UL,
      FI_EN_SGMCOMPANY = 32903UL,
      FI_EN_YOUNGHO = 32904UL,
      FI_EN_B_HOLIDAYINN = 32905UL,
      FI_EN_B_BESTWESTERN = 32906UL,
      FI_EN_B_RAMADA = 32907UL,
      FI_EN_B_ALLGUTH = 32908UL,
      FI_EN_B_ESSO = 32909UL,
      FI_EN_B_JET = 32910UL,
      FI_EN_B_TEXACO = 32911UL,
      FI_EN_B_FINA = 32912UL,
      FI_EN_B_DEA = 32913UL,
      FI_EN_B_ELF = 32914UL,
      FI_EN_B_BFT = 32915UL,
      FI_EN_B_NOVOTEL = 32916UL,
      FI_EN_B_BAVARIA = 32917UL,
      FI_EN_B_IBIS = 32918UL,
      FI_EN_B_SOFITEL = 32919UL,
      FI_EN_B_PULLMAN = 32920UL,
      FI_EN_B_ATHENA = 32921UL,
      FI_EN_B_ASTORIA = 32922UL,
      FI_EN_B_CONCORDE = 32923UL,
      FI_EN_B_DORINT = 32924UL,
      FI_EN_B_RINGHOTEL = 32925UL,
      FI_EN_B_MOBIL = 32926UL,
      FI_EN_B_MERIDIEN = 32927UL,
      FI_EN_B_ELFANTAR = 32928UL,
      FI_EN_B_ANTAR = 32929UL,
      FI_EN_B_MOUNTCHARLOTTETHISTLE = 32930UL,
      FI_EN_B_MOEVENPICK = 32931UL,
      FI_EN_B_MORRISONS = 32932UL,
      FI_EN_B_CARREFOUR = 32933UL,
      FI_EN_B_RITZCARLTON = 32934UL,
      FI_EN_B_TESCO = 32935UL,
      FI_EN_B_GRANGE = 32936UL,
      FI_EN_B_MINOL = 32937UL,
      FI_EN_B_CARLTON = 32938UL,
      FI_EN_B_INTERHOTEL = 32939UL,
      FI_EN_B_AXOTEL = 32940UL,
      FI_EN_B_CAMPANILE = 32941UL,
      FI_EN_B_MERCURE = 32942UL,
      FI_EN_B_CONFORTEL = 32943UL,
      FI_EN_B_COMFORTINN = 32944UL,
      FI_EN_B_FIMOTEL = 32945UL,
      FI_EN_B_URBIS = 32946UL,
      FI_EN_B_CLIMATDEFRANCE = 32947UL,
      FI_EN_B_RELAISBLEUS = 32948UL,
      FI_EN_B_RESTHOTEL = 32949UL,
      FI_EN_B_GOLDENTULIP = 32950UL,
      FI_EN_B_SHERATON = 32951UL,
      FI_EN_B_HILTON = 32952UL,
      FI_EN_B_APEGIA = 32953UL,
      FI_EN_B_CLUBMEDITERRANEE = 32954UL,
      FI_EN_B_CASINO = 32955UL,
      FI_EN_B_MARRIOT = 32956UL,
      FI_EN_B_WESTFALEN = 32957UL,
      FI_EN_B_SVG = 32958UL,
      FI_EN_B_SCANDIC = 32959UL,
      FI_EN_B_STEIGENBERGER = 32960UL,
      FI_EN_B_PANNONIA = 32961UL,
      FI_EN_B_SAVOY = 32962UL,
      FI_EN_B_HYATTREGENCY = 32963UL,
      FI_EN_B_QUEENS = 32964UL,
      FI_EN_B_ERG = 32965UL,
      FI_EN_B_IP = 32966UL,
      FI_EN_B_TAMOIL = 32967UL,
      FI_EN_B_Q8 = 32968UL,
      FI_EN_B_GULF = 32969UL,
      FI_EN_B_MURCO = 32970UL,
      FI_EN_B_STAR = 32971UL,
      FI_EN_B_MARITIM = 32972UL,
      FI_EN_B_AKZENTHOTEL = 32973UL,
      FI_EN_B_FORMULE1 = 32974UL,
      FI_EN_B_FORTE = 32975UL,
      FI_EN_B_UK = 32976UL,
      FI_EN_B_SAFEWAY = 32977UL,
      FI_EN_B_BURMAH = 32978UL,
      FI_EN_B_JSAINSBURY = 32979UL,
      FI_EN_B_REPSOL = 32980UL,
      FI_EN_B_NIKKO = 32981UL,
      FI_EN_B_RISTORAGIP = 32982UL,
      FI_EN_B_MOTTA = 32983UL,
      FI_EN_B_API = 32984UL,
      FI_EN_B_FRANKLIN = 32985UL,
      FI_EN_B_ADMIRALBENBOWINN = 32986UL,
      FI_EN_B_FAMILYINN = 32987UL,
      FI_EN_B_SMOLLENSKI = 32988UL,
      FI_EN_B_CHEZGERARD = 32989UL,
      FI_EN_B_TAG = 32990UL,
      FI_EN_B_EDWARDIAN = 32991UL,
      FI_EN_B_WELCOME = 32992UL,
      FI_EN_B_SECA = 32993UL,
      FI_EN_B_ASDA = 32994UL,
      FI_EN_B_CHEVRON = 32995UL,
      FI_EN_B_OLDSMOBILE = 32996UL,
      FI_EN_B_HONDA = 32997UL,
      FI_EN_B_A_1 = 32998UL,
      FI_EN_B_AMERADAHESS = 32999UL,
      FI_EN_B_AMOCO = 33000UL,
      FI_EN_B_ARCO = 33001UL,
      FI_EN_B_ATLANTIC = 33002UL,
      FI_EN_B_BEACON = 33003UL,
      FI_EN_B_CENEX = 33004UL,
      FI_EN_B_CIRCLEX = 33005UL,
      FI_EN_B_CITGO = 33006UL,
      FI_EN_B_COASTAL = 33007UL,
      FI_EN_B_CONOCO = 33008UL,
      FI_EN_B_CROWNCENTRAL = 33009UL,
      FI_EN_B_DIAMONDSHAMROCK = 33010UL,
      FI_EN_B_EMRO = 33011UL,
      FI_EN_B_ERNIESFUELSTOP = 33012UL,
      FI_EN_B_EXXON = 33013UL,
      FI_EN_B_FARMERSUNION = 33014UL,
      FI_EN_B_FLYINGJ = 33015UL,
      FI_EN_B_GASAMATOIL = 33016UL,
      FI_EN_B_GETTY = 33017UL,
      FI_EN_B_HUNTOIL = 33018UL,
      FI_EN_B_MAPCO = 33019UL,
      FI_EN_B_MARATHON = 33020UL,
      FI_EN_B_MERIDIANOIL = 33021UL,
      FI_EN_B_MERINT = 33022UL,
      FI_EN_B_MULLINSANDPRICHARD = 33023UL,
      FI_EN_B_MURPHYOIL = 33024UL,
      FI_EN_B_PDQ = 33025UL,
      FI_EN_B_RACETRAC = 33026UL,
      FI_EN_B_REBEL = 33027UL,
      FI_EN_B_SINCLAIR = 33028UL,
      FI_EN_B_SUN = 33029UL,
      FI_EN_B_SUNOCO = 33030UL,
      FI_EN_B_TENNECO = 33031UL,
      FI_EN_B_TERRIBLEHERBST = 33032UL,
      FI_EN_B_UNIOIL = 33033UL,
      FI_EN_B_USAPETROLIUM = 33034UL,
      FI_EN_B_WESCO = 33035UL,
      FI_EN_B_ACCOR = 33036UL,
      FI_EN_B_ADAMSMARKHOTEL = 33037UL,
      FI_EN_B_BALLYSCASINOHOTEL = 33038UL,
      FI_EN_B_BESTINN = 33039UL,
      FI_EN_B_BUDGETHOSTINN = 33040UL,
      FI_EN_B_BUDGETELINN = 33041UL,
      FI_EN_B_CEARSARSWOLD = 33042UL,
      FI_EN_B_CHALETSUSSEINTERNATIONAL = 33043UL,
      FI_EN_B_CHOICEHOTELSINTERNATIONAL = 33044UL,
      FI_EN_B_CIRCUSCIRCUS = 33045UL,
      FI_EN_B_CLARION = 33046UL,
      FI_EN_B_CLUBHOUSEINN = 33047UL,
      FI_EN_B_CONSORTHOTEL = 33048UL,
      FI_EN_B_COUNTRYINN = 33049UL,
      FI_EN_B_COUNTYARDBYMARRIOTT = 33050UL,
      FI_EN_B_CROWNSTELINGSUITES = 33051UL,
      FI_EN_B_DAYSINN = 33052UL,
      FI_EN_B_DOUBLETREE = 33053UL,
      FI_EN_B_DOWNTOWNERMOTORINN = 33054UL,
      FI_EN_B_DRURYINN = 33055UL,
      FI_EN_B_EZ8MOTEL = 33056UL,
      FI_EN_B_ECONOLODGE = 33057UL,
      FI_EN_B_ECONOMYINN = 33058UL,
      FI_EN_B_ECONOMYLODGINGSYSTEMS = 33059UL,
      FI_EN_B_EMBASSYSUITES = 33060UL,
      FI_EN_B_EXELINN = 33061UL,
      FI_EN_B_FAIRFIELDINNBYMARRIOTT = 33062UL,
      FI_EN_B_FAIRMONTHOTEL = 33063UL,
      FI_EN_B_FOURSEASONS = 33064UL,
      FI_EN_B_FRIENDSHIPINN = 33065UL,
      FI_EN_B_GUESTQUATERS = 33066UL,
      FI_EN_B_HAMPTONINN = 33067UL,
      FI_EN_B_HARLEYHOTEL = 33068UL,
      FI_EN_B_HARRAHS = 33069UL,
      FI_EN_B_HARVEYHOTEL = 33070UL,
      FI_EN_B_HAWTHORN = 33071UL,
      FI_EN_B_HOMEWOODSUITES = 33072UL,
      FI_EN_B_ALLSEASONS = 33073UL,
      FI_EN_B_HOSPITALITYINTERNATIONAL = 33074UL,
      FI_EN_B_AMERIHOST = 33075UL,
      FI_EN_B_DOLLARINN = 33076UL,
      FI_EN_B_HOWARDJOHNSON = 33077UL,
      FI_EN_B_KIGHTSINN = 33078UL,
      FI_EN_B_LAQUINTAMOTORINN = 33079UL,
      FI_EN_B_LEXINGTON = 33080UL,
      FI_EN_B_LOEWSHOTEL = 33081UL,
      FI_EN_B_MASTERHOSTS = 33082UL,
      FI_EN_B_MASTERECONOMYINN = 33083UL,
      FI_EN_B_MGMGRAND = 33084UL,
      FI_EN_B_MIDWAYHOSPITALITY = 33085UL,
      FI_EN_B_MOTEL6 = 33086UL,
      FI_EN_B_OMNIHOTEL = 33087UL,
      FI_EN_B_PARKINNSINTERNATIONAL = 33088UL,
      FI_EN_B_PASSPORTINN = 33089UL,
      FI_EN_B_QUALITY = 33090UL,
      FI_EN_B_RADDISON = 33091UL,
      FI_EN_B_REDCARPETINN = 33092UL,
      FI_EN_B_REDLION = 33093UL,
      FI_EN_B_REDROOFINN = 33094UL,
      FI_EN_B_REGENTINTLHOTEL = 33095UL,
      FI_EN_B_RODEWAYINN = 33096UL,
      FI_EN_B_SCOTTISHINN = 33097UL,
      FI_EN_B_SHILOINN = 33098UL,
      FI_EN_B_SHOLODGE = 33099UL,
      FI_EN_B_SIGNATUREINN = 33100UL,
      FI_EN_B_SLEEPINN = 33101UL,
      FI_EN_B_STOUFFER = 33102UL,
      FI_EN_B_SUITEMARK = 33103UL,
      FI_EN_B_SUMMERFIELD = 33104UL,
      FI_EN_B_SUNDOWNERINTERNATIONAL = 33105UL,
      FI_EN_B_SUPER8MOTEL = 33106UL,
      FI_EN_B_HEARTLANDINN = 33107UL,
      FI_EN_B_SWISSOTELINN = 33108UL,
      FI_EN_B_THRIFTYLTD = 33109UL,
      FI_EN_B_TRAVELERSINN = 33110UL,
      FI_EN_B_TRAVELODGE = 33111UL,
      FI_EN_B_VAGABONDINN = 33112UL,
      FI_EN_B_VALUINN = 33113UL,
      FI_EN_B_VENTUREINN = 33114UL,
      FI_EN_B_WALTDISNEYWORLDRESORT = 33115UL,
      FI_EN_B_WARWICKINTLHOTEL = 33116UL,
      FI_EN_B_WESTIN = 33117UL,
      FI_EN_B_WOODFIN = 33118UL,
      FI_EN_B_WYNDHAM = 33119UL,
      FI_EN_B_LEXUS = 33120UL,
      FI_EN_B_TOYOTA = 33121UL,
      FI_EN_B_MERCEDESBENZ = 33122UL,
      FI_EN_B_ELECLERK = 33123UL,
      FI_EN_B_INTERCONTINENTAL = 33124UL,
      FI_EN_B_JARVIS = 33125UL,
      FI_EN_B_COPTHORNE = 33126UL,
      FI_EN_B_BMW = 33127UL,
      FI_EN_B_RENAULT = 33128UL,
      FI_EN_B_OPEL = 33129UL,
      FI_EN_B_VOLKSWAGEN = 33130UL,
      FI_EN_B_PEUGEOT = 33131UL,
      FI_EN_B_BALLADINS = 33132UL,
      FI_EN_B_NUITHOTEL = 33133UL,
      FI_EN_B_MIGROL = 33134UL,
      FI_EN_B_LINCOLNMERCURY = 33135UL,
      FI_EN_B_ELAN = 33136UL,
      FI_EN_B_GO = 33137UL,
      FI_EN_B_HEM = 33138UL,
      FI_EN_B_OMV = 33139UL,
      FI_EN_B_SPRINT = 33140UL,
      FI_EN_B_STATOIL = 33141UL,
      FI_EN_B_LINDNER = 33142UL,
      FI_EN_B_ROMANTIK = 33143UL,
      FI_EN_B_ROSENBERGER = 33144UL,
      FI_EN_B_WIENERWALDTOURAST = 33145UL,
      FI_EN_B_FORD = 33146UL,
      FI_EN_B_ACURA = 33147UL,
      FI_EN_B_ALFAROMEO = 33148UL,
      FI_EN_B_ASIAMOTORS = 33149UL,
      FI_EN_B_ASTONMARTIN = 33150UL,
      FI_EN_B_AUDI = 33151UL,
      FI_EN_B_BENTLEY = 33152UL,
      FI_EN_B_BUGATI = 33153UL,
      FI_EN_B_BUICK = 33154UL,
      FI_EN_B_CADILLAC = 33155UL,
      FI_EN_B_CHEVROLET = 33156UL,
      FI_EN_B_CHRYSLER = 33157UL,
      FI_EN_B_CITROEN = 33158UL,
      FI_EN_B_DAEWOO = 33159UL,
      FI_EN_B_DAIHATSU = 33160UL,
      FI_EN_B_DODGE = 33161UL,
      FI_EN_B_EAGLE = 33162UL,
      FI_EN_B_FERRARI = 33163UL,
      FI_EN_B_FIAT = 33164UL,
      FI_EN_B_FSO = 33165UL,
      FI_EN_B_GM = 33166UL,
      FI_EN_B_GMC = 33167UL,
      FI_EN_B_HYUNDAI = 33168UL,
      FI_EN_B_INFINITI = 33169UL,
      FI_EN_B_ISUZU = 33170UL,
      FI_EN_B_JAGUAR = 33171UL,
      FI_EN_B_JEEP = 33172UL,
      FI_EN_B_JENSEN = 33173UL,
      FI_EN_B_KIA = 33174UL,
      FI_EN_B_LADA = 33175UL,
      FI_EN_B_LAMBORGHINI = 33176UL,
      FI_EN_B_LANCIA = 33177UL,
      FI_EN_B_LANDROVER = 33178UL,
      FI_EN_B_LOTUS = 33179UL,
      FI_EN_B_MARCOS = 33180UL,
      FI_EN_B_MASERATI = 33181UL,
      FI_EN_B_MAZDA = 33182UL,
      FI_EN_B_MCLAREN = 33183UL,
      FI_EN_B_MEGA = 33184UL,
      FI_EN_B_MG = 33185UL,
      FI_EN_B_MITSUBISHI = 33186UL,
      FI_EN_B_MORGAN = 33187UL,
      FI_EN_B_MORRIS = 33188UL,
      FI_EN_B_NISSAN = 33189UL,
      FI_EN_B_PONTIAC = 33190UL,
      FI_EN_B_PORSCHE = 33191UL,
      FI_EN_B_ROLLSROYCE = 33192UL,
      FI_EN_B_ROVER = 33193UL,
      FI_EN_B_SAAB = 33194UL,
      FI_EN_B_SATURN = 33195UL,
      FI_EN_B_SEAT = 33196UL,
      FI_EN_B_SKODA = 33197UL,
      FI_EN_B_SSANGYONG = 33198UL,
      FI_EN_B_SUBARU = 33199UL,
      FI_EN_B_SUZUKI = 33200UL,
      FI_EN_B_TRIUMPH = 33201UL,
      FI_EN_B_TVR = 33202UL,
      FI_EN_B_VAUXHALL = 33203UL,
      FI_EN_B_VOLVO = 33204UL,
      FI_EN_B_LEESINN = 33205UL,
      FI_EN_B_SORAT = 33206UL,
      FI_EN_B_MINOTEL = 33207UL,
      FI_EN_B_KEMPINSKI = 33208UL,
      FI_EN_B_LIBERTEL = 33209UL,
      FI_EN_B_AIRPORTINN = 33210UL,
      FI_EN_B_AMBASSADOR = 33211UL,
      FI_EN_B_AMERICINNMOTEL = 33212UL,
      FI_EN_B_ATLANTICBUDGETINN = 33213UL,
      FI_EN_B_BILTMOREHOTEL = 33214UL,
      FI_EN_B_COZ8HOTEL = 33215UL,
      FI_EN_B_CORPORATELODGING = 33216UL,
      FI_EN_B_COUNTRYHEARTHINN = 33217UL,
      FI_EN_B_CRICKETINN = 33218UL,
      FI_EN_B_CROWNEPLAZA = 33219UL,
      FI_EN_B_IMA = 33220UL,
      FI_EN_B_INNSUITESHOTEL = 33221UL,
      FI_EN_B_INNKEEPER = 33222UL,
      FI_EN_B_INNSOFAMERICA = 33223UL,
      FI_EN_B_LK = 33224UL,
      FI_EN_B_MASTERSINN = 33225UL,
      FI_EN_B_MCINTOSHINN = 33226UL,
      FI_EN_B_MICROTEL = 33227UL,
      FI_EN_B_NATIONAL9MOTEL = 33228UL,
      FI_EN_B_NENDELSINN = 33229UL,
      FI_EN_B_OASISMOTEL = 33230UL,
      FI_EN_B_PARAMOUNTHOTEL = 33231UL,
      FI_EN_B_PLAZAHOTEL = 33232UL,
      FI_EN_B_RENAISSANCE = 33233UL,
      FI_EN_B_SELECTINN = 33234UL,
      FI_EN_B_SHONEYSINN = 33235UL,
      FI_EN_B_STUDIOPLUS = 33236UL,
      FI_EN_B_TRAVELINN = 33237UL,
      FI_EN_B_VILLAGEINN = 33238UL,
      FI_EN_B_WELLESLEYINN = 33239UL,
      FI_EN_B_1STOP = 33240UL,
      FI_EN_B_7ELEVEN = 33241UL,
      FI_EN_B_ALLSUPS = 33242UL,
      FI_EN_B_AMERISTOP = 33243UL,
      FI_EN_B_AMPMMINIMART = 33244UL,
      FI_EN_B_ANCHOR = 33245UL,
      FI_EN_B_ASHLAND = 33246UL,
      FI_EN_B_AUTOSTOP = 33247UL,
      FI_EN_B_BESTMART = 33248UL,
      FI_EN_B_BIG10MART = 33249UL,
      FI_EN_B_BIGD = 33250UL,
      FI_EN_B_BIGFOOT = 33251UL,
      FI_EN_B_BIGH = 33252UL,
      FI_EN_B_BLUEANDWHITESERVICE = 33253UL,
      FI_EN_B_BONDEDOIL = 33254UL,
      FI_EN_B_BRADLEY = 33255UL,
      FI_EN_B_BREAKTIME = 33256UL,
      FI_EN_B_BRYANTS = 33257UL,
      FI_EN_B_BUDGET = 33258UL,
      FI_EN_B_CANNON = 33259UL,
      FI_EN_B_CASHNDASH = 33260UL,
      FI_EN_B_CERTIFIED = 33261UL,
      FI_EN_B_CHECKER = 33262UL,
      FI_EN_B_CHRISTYSMARKET = 33263UL,
      FI_EN_B_CLARKOIL = 33264UL,
      FI_EN_B_COASTALMART = 33265UL,
      FI_EN_B_COGOS = 33266UL,
      FI_EN_B_COMPAC = 33267UL,
      FI_EN_B_CONVENIENTFOODMART = 33268UL,
      FI_EN_B_CORNERSTOP = 33269UL,
      FI_EN_B_CRYSTALFLASH = 33270UL,
      FI_EN_B_CUMBERLANDFARMS = 33271UL,
      FI_EN_B_CURTS = 33272UL,
      FI_EN_B_DAIRYMART = 33273UL,
      FI_EN_B_DAVIS = 33274UL,
      FI_EN_B_DAVISONOILANDGAS = 33275UL,
      FI_EN_B_DAYANDNIGHT = 33276UL,
      FI_EN_B_DBMART = 33277UL,
      FI_EN_B_DELIMART = 33278UL,
      FI_EN_B_DEPOT = 33279UL,
      FI_EN_B_DSIX = 33280UL,
      FI_EN_B_DUKE = 33281UL,
      FI_EN_B_DYNO = 33282UL,
      FI_EN_B_EEASTCOAST = 33283UL,
      FI_EN_B_DAYSTOP = 33284UL,
      FI_EN_B_ETNASNACKMART = 33285UL,
      FI_EN_B_EXPRESS = 33286UL,
      FI_EN_B_EXPRESSLANE = 33287UL,
      FI_EN_B_EXPRESSMART = 33288UL,
      FI_EN_B_EZGO = 33289UL,
      FI_EN_B_EZMART = 33290UL,
      FI_EN_B_EZSHOP = 33291UL,
      FI_EN_B_EZSTOP = 33292UL,
      FI_EN_B_FAMILYEXPRESS = 33293UL,
      FI_EN_B_FARMCO = 33294UL,
      FI_EN_B_FARMSTORE = 33295UL,
      FI_EN_B_FASTRIP = 33296UL,
      FI_EN_B_FASTOP = 33297UL,
      FI_EN_B_FASTSTOP = 33298UL,
      FI_EN_B_FAVORITEMARKET = 33299UL,
      FI_EN_B_FLASHFOODS = 33300UL,
      FI_EN_B_FOODMART = 33301UL,
      FI_EN_B_FOODNFUEL = 33302UL,
      FI_EN_B_FOURSTART = 33303UL,
      FI_EN_B_FRIENDLYMART = 33304UL,
      FI_EN_B_FRIENDS = 33305UL,
      FI_EN_B_GANT = 33306UL,
      FI_EN_B_GASAMERICA = 33307UL,
      FI_EN_B_GASANDGO = 33308UL,
      FI_EN_B_GASANDMINIMART = 33309UL,
      FI_EN_B_GASCENTER = 33310UL,
      FI_EN_B_GASCITY = 33311UL,
      FI_EN_B_GASLAND = 33312UL,
      FI_EN_B_GASMAN = 33313UL,
      FI_EN_B_GASMART = 33314UL,
      FI_EN_B_GASNSHOP = 33315UL,
      FI_EN_B_GATE = 33316UL,
      FI_EN_B_GIANT = 33317UL,
      FI_EN_B_GITNGO = 33318UL,
      FI_EN_B_GOLDENGALLON = 33319UL,
      FI_EN_B_HANDEEHUGOS = 33320UL,
      FI_EN_B_HANDIPLUS = 33321UL,
      FI_EN_B_HANDYANDY = 33322UL,
      FI_EN_B_HANDYMART = 33323UL,
      FI_EN_B_HANDYWAY = 33324UL,
      FI_EN_B_HESS = 33325UL,
      FI_EN_B_HOBOPANTRY = 33326UL,
      FI_EN_B_HOLIDAYMARKET = 33327UL,
      FI_EN_B_HOPIN = 33328UL,
      FI_EN_B_HUCKSFOODSTORE = 33329UL,
      FI_EN_B_ICO = 33330UL,
      FI_EN_B_INLANDFOODSTORE = 33331UL,
      FI_EN_B_JACKPOT = 33332UL,
      FI_EN_B_JETFOODSHOP = 33333UL,
      FI_EN_B_JIFFYSTOP = 33334UL,
      FI_EN_B_JRFOODMART = 33335UL,
      FI_EN_B_JRFOODSTORE = 33336UL,
      FI_EN_B_KANGAROO = 33337UL,
      FI_EN_B_KELLEYWILLIAMSON = 33338UL,
      FI_EN_B_KENTKWIK = 33339UL,
      FI_EN_B_KERRMCGEE = 33340UL,
      FI_EN_B_KOCOLENE = 33341UL,
      FI_EN_B_KUMANDGO = 33342UL,
      FI_EN_B_KWIKFILL = 33343UL,
      FI_EN_B_KWIKKING = 33344UL,
      FI_EN_B_KWIKMART = 33345UL,
      FI_EN_B_KWIKSTORE = 33346UL,
      FI_EN_B_KWIKTRIP = 33347UL,
      FI_EN_B_KWIKWAY = 33348UL,
      FI_EN_B_LAKESIDE = 33349UL,
      FI_EN_B_LILCHAMP = 33350UL,
      FI_EN_B_LITTLEGENERAL = 33351UL,
      FI_EN_B_LOVESCOUNTRYSTORE = 33352UL,
      FI_EN_B_MAJIKMARKET = 33353UL,
      FI_EN_B_MALCO = 33354UL,
      FI_EN_B_MARTINOIL = 33355UL,
      FI_EN_B_MAVERICKMARKET = 33356UL,
      FI_EN_B_MEIJER = 33357UL,
      FI_EN_B_MIDSTATESPETROLEUM = 33358UL,
      FI_EN_B_MILLER = 33359UL,
      FI_EN_B_MINIMART = 33360UL,
      FI_EN_B_MINITMART = 33361UL,
      FI_EN_B_MONARCHOIL = 33362UL,
      FI_EN_B_MRM = 33363UL,
      FI_EN_B_MRMIKES = 33364UL,
      FI_EN_B_NEIGHBORS = 33365UL,
      FI_EN_B_NICENEASY = 33366UL,
      FI_EN_B_NOCO = 33367UL,
      FI_EN_B_OCEAN = 33368UL,
      FI_EN_B_ONESTOP = 33369UL,
      FI_EN_B_OPENPANTRY = 33370UL,
      FI_EN_B_ORLOSKI = 33371UL,
      FI_EN_B_OTTOS = 33372UL,
      FI_EN_B_PACKANDSACK = 33373UL,
      FI_EN_B_PALMSPRINGSOIL = 33374UL,
      FI_EN_B_PANDM = 33375UL,
      FI_EN_B_PARMART = 33376UL,
      FI_EN_B_PATCOHANDYSHOP = 33377UL,
      FI_EN_B_PENNZMART = 33378UL,
      FI_EN_B_PEOPLES = 33379UL,
      FI_EN_B_PETROLEUM = 33380UL,
      FI_EN_B_PETROMART = 33381UL,
      FI_EN_B_PETROPANTRY = 33382UL,
      FI_EN_B_PHILLIPS66 = 33383UL,
      FI_EN_B_PILOT = 33384UL,
      FI_EN_B_PLAIDPANTRY = 33385UL,
      FI_EN_B_PRESTIGE = 33386UL,
      FI_EN_B_PRESTO = 33387UL,
      FI_EN_B_PRIDE = 33388UL,
      FI_EN_B_PRIMETIME = 33389UL,
      FI_EN_B_PRONTO = 33390UL,
      FI_EN_B_PUMPNPANTRY = 33391UL,
      FI_EN_B_QUALITYQMART = 33392UL,
      FI_EN_B_QUARLES = 33393UL,
      FI_EN_B_QUICKFUEL = 33394UL,
      FI_EN_B_QUICKSTOP = 33395UL,
      FI_EN_B_QUIKTRIP = 33396UL,
      FI_EN_B_QUICKWAY = 33397UL,
      FI_EN_B_RACEWAY = 33398UL,
      FI_EN_B_RADIANT = 33399UL,
      FI_EN_B_RAPIDROBERTS = 33400UL,
      FI_EN_B_REDAPPLE = 33401UL,
      FI_EN_B_REDDMART = 33402UL,
      FI_EN_B_REDWOOD = 33403UL,
      FI_EN_B_RENNIES = 33404UL,
      FI_EN_B_RHODES101STOP = 33405UL,
      FI_EN_B_RICKER = 33406UL,
      FI_EN_B_RIDGEWAY = 33407UL,
      FI_EN_B_RIPGRIFFIN = 33408UL,
      FI_EN_B_ROADAMERICA = 33409UL,
      FI_EN_B_ROBERTSOIL = 33410UL,
      FI_EN_B_ROTTENROBBIE = 33411UL,
      FI_EN_B_RPM = 33412UL,
      FI_EN_B_SANESCO = 33413UL,
      FI_EN_B_SANTEFEMARKET = 33414UL,
      FI_EN_B_SAVASTOP = 33415UL,
      FI_EN_B_SAVOMAT = 33416UL,
      FI_EN_B_SCHRADER = 33417UL,
      FI_EN_B_SCOT = 33418UL,
      FI_EN_B_SCOTCHMAN = 33419UL,
      FI_EN_B_SENTRYFOODMART = 33420UL,
      FI_EN_B_SHEETZ = 33421UL,
      FI_EN_B_SHOPNGO = 33422UL,
      FI_EN_B_SICO = 33423UL,
      FI_EN_B_SMILEGAS = 33424UL,
      FI_EN_B_SPARKYS = 33425UL,
      FI_EN_B_SPECTRUM = 33426UL,
      FI_EN_B_SPEEDWAY = 33427UL,
      FI_EN_B_SPUR = 33428UL,
      FI_EN_B_SANDSFOODSTORE = 33429UL,
      FI_EN_B_STANDARD = 33430UL,
      FI_EN_B_STEWARTS = 33431UL,
      FI_EN_B_STINKERSTATION = 33432UL,
      FI_EN_B_STOPIN = 33433UL,
      FI_EN_B_STOPNGO = 33434UL,
      FI_EN_B_STOPNSAVE = 33435UL,
      FI_EN_B_STUCKEYS = 33436UL,
      FI_EN_B_SUGARCREEKSTORE = 33437UL,
      FI_EN_B_SUNGLO = 33438UL,
      FI_EN_B_SUNNY = 33439UL,
      FI_EN_B_SUNRISE = 33440UL,
      FI_EN_B_SUPERAMERICA = 33441UL,
      FI_EN_B_SUPERMART = 33442UL,
      FI_EN_B_SUPERPUMPER = 33443UL,
      FI_EN_B_SUPERSTOP = 33444UL,
      FI_EN_B_SUPERSHOP = 33445UL,
      FI_EN_B_SUWANNEESWIFTYSTORE = 33446UL,
      FI_EN_B_SWIFTY = 33447UL,
      FI_EN_B_THECOUNTRYSTORE = 33448UL,
      FI_EN_B_THEPANTRY = 33449UL,
      FI_EN_B_THESTORE = 33450UL,
      FI_EN_B_THORNTONOIL = 33451UL,
      FI_EN_B_THRIFTWAY = 33452UL,
      FI_EN_B_TIGERMART = 33453UL,
      FI_EN_B_TOMTHUMB = 33454UL,
      FI_EN_B_TOWNANDCOUNTRY = 33455UL,
      FI_EN_B_TOWNSTARSTORE = 33456UL,
      FI_EN_B_TREX = 33457UL,
      FI_EN_B_UGASUM = 33458UL,
      FI_EN_B_ULTRAMAR = 33459UL,
      FI_EN_B_UNIMART = 33460UL,
      FI_EN_B_UNITEDDAIRYFARMERS = 33461UL,
      FI_EN_B_UNITEDOIL = 33462UL,
      FI_EN_B_UNIONUNOCAL76 = 33463UL,
      FI_EN_B_UPUMPIT = 33464UL,
      FI_EN_B_VILLAGEPANTRY = 33465UL,
      FI_EN_B_WACO = 33466UL,
      FI_EN_B_WARECO = 33467UL,
      FI_EN_B_WAWA = 33468UL,
      FI_EN_B_WEBBERENERGYFUELS = 33469UL,
      FI_EN_B_WHITING = 33470UL,
      FI_EN_B_WILCO = 33471UL,
      FI_EN_B_WILLIAMS = 33472UL,
      FI_EN_B_XPRESSFUELS = 33473UL,
      FI_EN_B_XTRAMART = 33474UL,
      FI_EN_B_YOUNGS = 33475UL,
      FI_EN_B_HERITAGEINN = 33476UL,
      FI_EN_B_HOMEPLACEINN = 33477UL,
      FI_EN_B_THRIFTLODGE = 33478UL,
      FI_EN_B_THRIFTY = 33479UL,
      FI_EN_B_AVANTI = 33480UL,
      FI_EN_B_COOPOK = 33481UL,
      FI_EN_B_BANDB = 33482UL,
      FI_EN_B_BONSAUHOTEL = 33483UL,
      FI_EN_B_ETAPHOTEL = 33484UL,
      FI_EN_B_FRANTOUR = 33485UL,
      FI_EN_B_MARMOTTE = 33486UL,
      FI_EN_B_PREMIERECLASSE = 33487UL,
      FI_EN_B_VILLAGESHOTEL = 33488UL,
      FI_EN_B_ARCANTIS = 33489UL,
      FI_EN_B_CHATEAUXANDHOTELSDEFRANCE = 33490UL,
      FI_EN_B_ETAPESHOTELIERSCORSES = 33491UL,
      FI_EN_B_EUROSTARTHOTUSA = 33492UL,
      FI_EN_B_ELYSEEWESTHOTEL = 33493UL,
      FI_EN_B_HERALDUS = 33494UL,
      FI_EN_B_HOTELSDUGRANDSUD = 33495UL,
      FI_EN_B_LOGISDEFRANCE = 33496UL,
      FI_EN_B_MOULINETAPE = 33497UL,
      FI_EN_B_NEOTEL = 33498UL,
      FI_EN_B_NIDSDEFRANCE = 33499UL,
      FI_EN_B_RELAISDESILENCE = 33500UL,
      FI_EN_B_RELAISANDCHATEAUX = 33501UL,
      FI_EN_B_WELCOMESWISSHOTELS = 33502UL,
      FI_EN_B_ALPINE = 33503UL,
      FI_EN_B_EANDGHOTELSSCHWEIZ = 33504UL,
      FI_EN_B_INTEREUROPEHOTEL = 33505UL,
      FI_EN_B_SWISSLEADINGHOTEL = 33506UL,
      FI_EN_B_TOPINTERNATIONALHOTEL = 33507UL,
      FI_EN_B_GENOL = 33508UL,
      FI_EN_B_STROH = 33509UL,
      FI_EN_B_TURMOEL = 33510UL,
      FI_EN_B_RUEHL = 33511UL,
      FI_EN_B_ASTRON = 33512UL,
      FI_EN_B_REMAHOTELS = 33513UL,
      FI_EN_B_SENATOR = 33514UL,
      FI_EN_B_STARHOTEL = 33515UL,
      FI_EN_B_TREFFHOTELS = 33516UL,
      FI_EN_B_AGROLA = 33517UL,
      FI_EN_B_DYNEFF = 33518UL,
      FI_EN_B_SAVE = 33519UL,
      FI_EN_B_AC = 33520UL,
      FI_EN_B_VANDERVALK = 33521UL,
      FI_EN_B_POSTILJON = 33522UL,
      FI_EN_B_SCORE = 33523UL,
      FI_EN_B_STAKIS = 33524UL,
      FI_EN_B_CANADIANPACIFIC = 33525UL,
      FI_EN_B_COAST = 33526UL,
      FI_EN_B_DELTA = 33527UL,
      FI_EN_B_HOTELDESGOUVERNEURS = 33528UL,
      FI_EN_B_JOURNEYSEND = 33529UL,
      FI_EN_B_SANDMAN = 33530UL,
      FI_EN_B_WANDLYN = 33531UL,
      FI_EN_B_BEAVER = 33532UL,
      FI_EN_B_CANADIANTIRE = 33533UL,
      FI_EN_B_CANGO = 33534UL,
      FI_EN_B_GASRITE = 33535UL,
      FI_EN_B_HUSKY = 33536UL,
      FI_EN_B_IRVING = 33537UL,
      FI_EN_B_MRGAS = 33538UL,
      FI_EN_B_OLCO = 33539UL,
      FI_EN_B_PAYLESS = 33540UL,
      FI_EN_B_PENNY = 33541UL,
      FI_EN_B_PETROCANADA = 33542UL,
      FI_EN_B_PIONEER = 33543UL,
      FI_EN_B_SUNNYS = 33544UL,
      FI_EN_B_SUPERSAVE = 33545UL,
      FI_EN_B_TURBO = 33546UL,
      FI_EN_B_COUNTRYSIDEINNS = 33547UL,
      FI_EN_B_COUNTRY = 33548UL,
      FI_EN_B_FORTEHERITAGE = 33549UL,
      FI_EN_B_FORTEPOSTHOUSE = 33550UL,
      FI_EN_B_FOWNES = 33551UL,
      FI_EN_B_FRIENDLYHOTELSCOMFORTINNS = 33552UL,
      FI_EN_B_FRIENDLYHOTELSQUALITYINNS = 33553UL,
      FI_EN_B_INDEPENDENTS = 33554UL,
      FI_EN_B_LGIS = 33555UL,
      FI_EN_B_LYRIC = 33556UL,
      FI_EN_B_MACDONALD = 33557UL,
      FI_EN_B_MARSTON = 33558UL,
      FI_EN_B_MENZIES = 33559UL,
      FI_EN_B_MILLENIUMANDCOPTHORNE = 33560UL,
      FI_EN_B_MOATHOUSEHOTELS = 33561UL,
      FI_EN_B_PRIDEOFBRITAIN = 33562UL,
      FI_EN_B_PRINCIPAL = 33563UL,
      FI_EN_B_QUEENSMOATHOUSE = 33564UL,
      FI_EN_B_REGAL = 33565UL,
      FI_EN_B_ROADCHEF = 33566UL,
      FI_EN_B_SCOTLANDSCOMMENDED = 33567UL,
      FI_EN_B_SCOTTISHHIGHLAND = 33568UL,
      FI_EN_B_SCOTTISHANDNEWCASTLE = 33569UL,
      FI_EN_B_SHIRE = 33570UL,
      FI_EN_B_SMALLLUXURYHOTELS = 33571UL,
      FI_EN_B_SWALLOW = 33572UL,
      FI_EN_B_THISTLE = 33573UL,
      FI_EN_B_TOBY = 33574UL,
      FI_EN_B_VIRGINCOLLECTION = 33575UL,
      FI_EN_B_ANGLO = 33576UL,
      FI_EN_B_BUTLER = 33577UL,
      FI_EN_B_PROTEUS = 33578UL,
      FI_EN_B_BRITISHFUELSLIMITED = 33579UL,
      FI_EN_B_RIX = 33580UL,
      FI_EN_B_POWER = 33581UL,
      FI_EN_B_OK = 33582UL,
      FI_EN_B_PREEM = 33583UL,
      FI_EN_B_NORSKHYDRO = 33584UL,
      FI_EN_B_DINX = 33585UL,
      FI_EN_B_UNOX = 33586UL,
      FI_EN_B_NESTE = 33587UL,
      FI_EN_B_TEBOIL = 33588UL,
      FI_EN_B_ATAC = 33589UL,
      FI_EN_B_INTERMARCHE = 33590UL,
      FI_EN_B_MAMMOUTH = 33591UL,
      FI_EN_B_MONTEDISON = 33592UL,
      FI_EN_B_KESOIL = 33593UL,
      FI_EN_B_MPSA = 33594UL,
      FI_EN_B_GALP = 33595UL,
      FI_EN_B_PETROCAT = 33596UL,
      FI_EN_B_PETRONOR = 33597UL,
      FI_EN_B_IDS = 33598UL,
      FI_EN_B_MEROIL = 33599UL,
      FI_EN_B_NH = 33600UL,
      FI_EN_B_STARVINMARVIN = 33601UL,
      FI_EN_B_CROWN = 33602UL,
      FI_EN_B_EZSERVE = 33603UL,
      FI_EN_B_PANTRY = 33604UL,
      FI_EN_B_HANDYPANTRY = 33605UL,
      FI_EN_B_BASTION = 33606UL,
      FI_EN_B_CAMPSA = 33607UL,
      FI_EN_B_HYDROTEXACO = 33608UL,
      FI_EN_B_KAI = 33609UL,
      FI_EN_B_AMERISUITES = 33610UL,
      FI_EN_B_DELUXINN = 33611UL,
      FI_EN_B_EXECUTIVEINN = 33612UL,
      FI_EN_B_GREATWESTERNINN = 33613UL,
      FI_EN_B_HOMESTEADVILLAGE = 33614UL,
      FI_EN_B_STRATFORDHOUSEINN = 33615UL,
      FI_EN_B_WILSONWORLDHOTEL = 33616UL,
      FI_EN_B_BLEUMARINE = 33617UL,
      FI_EN_B_CLARINE = 33618UL,
      FI_EN_B_FASTHOTEL = 33619UL,
      FI_EN_B_SOLMELIA = 33620UL,
      FI_EN_B_AUCHAN = 33621UL,
      FI_EN_B_CEDICO = 33622UL,
      FI_EN_B_CHAMPION = 33623UL,
      FI_EN_B_CLUB = 33624UL,
      FI_EN_B_DCA = 33625UL,
      FI_EN_B_DESMETANDVANDIEST = 33626UL,
      FI_EN_B_LESMOUSQUETAIRES = 33627UL,
      FI_EN_B_NORDPICARDIECARBURANT = 33628UL,
      FI_EN_B_SHOPI = 33629UL,
      FI_EN_B_CABINN = 33630UL,
      FI_EN_B_DANSKKROFERIE = 33631UL,
      FI_EN_B_FIRSTHOTELS = 33632UL,
      FI_EN_B_GOODMORNINGHOTELS = 33633UL,
      FI_EN_B_INTERDAN = 33634UL,
      FI_EN_B_LARSENHOTELOGKROFERIE = 33635UL,
      FI_EN_B_PROVOBISHOTELS = 33636UL,
      FI_EN_B_SWEDENHOTELS = 33637UL,
      FI_EN_B_DKBENZIN = 33638UL,
      FI_EN_B_HAAHR = 33639UL,
      FI_EN_B_METEX = 33640UL,
      FI_EN_B_ASTOTEL = 33641UL,
      FI_EN_B_PREMIERLODGE = 33642UL,
      FI_EN_B_NATIONAL = 33643UL,
      FI_EN_B_OAK = 33644UL,
      FI_EN_B_ED = 33645UL,
      FI_EN_B_ELLERMONTAN = 33646UL,
      FI_EN_B_METROPOLITAN = 33647UL,
      FI_EN_B_STAYNSAVE = 33648UL,
      FI_EN_B_SUTTONPLACE = 33649UL,
      FI_EN_B_CREVIER = 33650UL,
      FI_EN_B_DOMO = 33651UL,
      FI_EN_B_MOHAWK = 33652UL,
      FI_EN_B_PAYRITE = 33653UL,
      FI_EN_B_REALCANADIANSUPERSTORE = 33654UL,
      FI_EN_B_SERGAZ = 33655UL,
      FI_EN_B_STINSON = 33656UL,
      FI_EN_B_TEMPO = 33657UL,
      FI_EN_B_TRUVALUE = 33658UL,
      FI_EN_B_XL = 33659UL,
      FI_EN_B_CITADINESAPPARTHOTELS = 33660UL,
      FI_EN_B_CORA = 33661UL,
      FI_EN_B_GEANT = 33662UL,
      FI_EN_B_GLEANER = 33663UL,
      FI_EN_B_GLOBE = 33664UL,
      FI_EN_B_IMPERIAL = 33665UL,
      FI_EN_B_MARTENS = 33666UL,
      FI_EN_B_MATCH = 33667UL,
      FI_EN_B_PS = 33668UL,
      FI_EN_B_SPARTAN = 33669UL,
      FI_EN_B_SPOT = 33670UL,
      FI_EN_B_THAMES = 33671UL,
      FI_EN_B_THRUST = 33672UL,
      FI_EN_B_WCF = 33673UL,
      FI_EN_B_CEPSAELF = 33674UL,
      FI_EN_B_EXEL = 33675UL,
      FI_EN_B_ENGEN = 33676UL,
      FI_EN_B_CALTEX = 33677UL,
      FI_EN_B_ZENEX = 33678UL,
      FI_EN_B_AFRICOIL = 33679UL,
      FI_EN_B_OKQ8 = 33680UL,
      FI_EN_B_FLAIRHOTEL = 33681UL,
      FI_EN_B_BILISTEN = 33682UL,
      FI_EN_B_ICABENSIN = 33683UL,
      FI_EN_B_SUPERU = 33684UL,
      FI_EN_B_SAROIL = 33685UL,
      FI_EN_B_TRYP = 33686UL,
      FI_EN_B_ECOMARCHE = 33687UL,
      FI_EN_B_SP = 33688UL,
      FI_EN_B_ABACOLI = 33689UL,
      FI_EN_B_EROSKI = 33690UL,
      FI_EN_B_PARADORNACIONAL = 33691UL,
      FI_EN_B_POUSADA = 33692UL,
      FI_EN_B_PETROGAL = 33693UL,
      FI_EN_B_CONTACTHOTEL = 33694UL,
      FI_EN_B_CITOTEL = 33695UL,
      FI_EN_B_AUSTRIATREND = 33696UL,
      FI_EN_B_ARMORINE = 33697UL,
      FI_EN_B_NERVOL = 33698UL,
      FI_EN_B_LIBRECO = 33699UL,
      FI_EN_B_QUICKPALACE = 33700UL,
      FI_EN_B_CALPAM = 33701UL,
      FI_EN_B_MAXOL = 33702UL,
      FI_EN_B_FLARE = 33703UL,
      FI_EN_B_IDEMITSU = 33704UL,
      FI_EN_B_TOPOIL = 33705UL,
      FI_EN_B_HESPERIA = 33706UL,
      FI_EN_B_TULIPINN = 33707UL,
      FI_EN_B_COMOD = 33708UL,
      FI_EN_B_KYRIADHOTEL = 33709UL,
      FI_EN_B_CHARVET = 33710UL,
      FI_EN_B_SEO = 33711UL,
      FI_EN_B_MUNDORF = 33712UL,
      FI_EN_B_EEURO = 33713UL,
      FI_EN_B_NORLANDIA = 33714UL,
      FI_EN_B_RAINBOW = 33715UL,
      FI_EN_B_RICA = 33716UL,
      FI_EN_B_CUMULUS = 33717UL,
      FI_EN_B_LAPPIAHOTELS = 33718UL,
      FI_EN_B_SOKOSHOTELS = 33719UL,
      FI_EN_B_RIVOLIHOTELS = 33720UL,
      FI_EN_B_HUSA = 33721UL,
      FI_EN_B_VALERO = 33722UL,
      FI_EN_B_SERCOTEL = 33723UL,
      FI_EN_B_SILKEN = 33724UL,
      FI_EN_B_GOLDENARCH = 33725UL,
      FI_EN_B_BLUEBANDHOTELS = 33726UL,
      FI_EN_B_VIKTORS = 33727UL,
      FI_EN_B_FINLANDIAHOTELS = 33728UL,
      FI_EN_B_OIL = 33729UL,
      FI_EN_B_EM = 33730UL,
      FI_EN_B_JURYS = 33731UL,
      FI_EN_B_PROTEAHOTEL = 33732UL,
      FI_EN_B_PARKPLAZA = 33733UL,
      FI_EN_B_BENZINA = 33734UL,
      FI_EN_B_MINI = 33735UL,
      FI_EN_B_TOTALFINA = 33736UL,
      FI_EN_B_CHARMETTES = 33737UL,
      FI_EN_B_BARCELOHOTELS = 33738UL,
      FI_EN_B_RIUHOTELS = 33739UL,
      FI_EN_B_IBEROSTAR = 33740UL,
      FI_EN_B_FASSBINDHOTELS = 33741UL,
      FI_EN_B_IDYLLHOTELSSCHWEIZ = 33742UL,
      FI_EN_B_KIDSHOTELS = 33743UL,
      FI_EN_B_MANOTEL = 33744UL,
      FI_EN_B_SELECTIONSUISSE = 33745UL,
      FI_EN_B_SUNSTARHOTELS = 33746UL,
      FI_EN_B_SWISSDELUXEHOTELS = 33747UL,
      FI_EN_B_SWISSINTERNATIONALHOTELS = 33748UL,
      FI_EN_B_TURICUM = 33749UL,
      FI_EN_B_LIANA = 33750UL,
      FI_EN_B_PAPOIL = 33751UL,
      FI_EN_B_PARAMO = 33752UL,
      FI_EN_B_PETRA = 33753UL,
      FI_EN_B_ROBINOIL = 33754UL,
      FI_EN_B_SLOVNAFT = 33755UL,
      FI_EN_B_LAGERHAUS = 33756UL,
      FI_EN_B_IQ = 33757UL,
      FI_EN_B_BIM = 33758UL,
      FI_EN_B_TANGO = 33759UL,
      FI_EN_B_PHOENIX = 33760UL,
      FI_EN_B_TOP = 33761UL,
      FI_EN_B_AWI = 33762UL,
      FI_EN_B_AVIOLAMP = 33763UL,
      FI_EN_B_JOLLYHOTEL = 33764UL,
      FI_EN_B_RAIFFEISEN = 33765UL,
      FI_EN_B_HAI = 33766UL,
      FI_EN_B_TESORO = 33767UL,
      FI_EN_B_AUSTRIACLASSIC = 33768UL,
      FI_EN_B_LANDIDYLL = 33769UL,
      FI_EN_B_ARABELLESHERATON = 33770UL,
      FI_EN_B_RAMADATREFF = 33771UL,
      FI_EN_B_FOURPOINTS = 33772UL,
      FI_EN_B_RAMADAJARVIS = 33773UL,
      FI_EN_B_ADNOC_FOD = 33774UL,
      FI_EN_B_EMARAT = 33775UL,
      FI_EN_B_EMIRATES = 33776UL,
      FI_EN_B_ENOC = 33777UL,
      FI_EN_B_EPPCO = 33778UL,
      FI_EN_B_KNPC = 33779UL,
      FI_EN_B_NAFT = 33780UL,
      FI_EN_B_ALDREES = 33781UL,
      FI_EN_B_BANOCO = 33782UL,
      FI_EN_B_SARAS = 33783UL,
      FI_EN_B_CHRYSLERFIVESTAR = 33784UL,
      FI_EN_B_DODGEFIVESTAR = 33785UL,
      FI_EN_B_JEEPFIVESTAR = 33786UL,
      FI_EN_B_OCTAPLUS = 33787UL,
      FI_EN_B_NORDOEL = 33788UL,
      FI_EN_B_CLASSIC = 33789UL,
      FI_EN_B_ENEOS = 33790UL,
      FI_EN_B_IDEMITSUKOSAN = 33791UL,
      FI_EN_B_COSMO = 33792UL,
      FI_EN_B_SHOWASHELL = 33793UL,
      FI_EN_B_JOMO = 33794UL,
      FI_EN_B_GENERAL = 33795UL,
      FI_EN_B_KIGNAS = 33796UL,
      FI_EN_B_KYUSYUSEKIYU = 33797UL,
      FI_EN_B_MITSUISEKIYU = 33798UL,
      FI_EN_B_TAIYOSEKIYU = 33799UL,
      FI_EN_B_AEGEAN = 33800UL,
      FI_EN_B_AVIN = 33801UL,
      FI_EN_B_CYCLON = 33802UL,
      FI_EN_B_DRACOIL = 33803UL,
      FI_EN_B_EKO = 33804UL,
      FI_EN_B_EL = 33805UL,
      FI_EN_B_ETEKA = 33806UL,
      FI_EN_B_SWISSBUDGETHOTELS = 33807UL,
      FI_EN_B_TINQ = 33808UL,
      FI_EN_B_MAYBACH = 33809UL,
      FI_EN_B_HUMMER = 33810UL,
      FI_EN_B_MALANNOODLES = 33811UL,
      FI_EN_B_YONGHESOYBEANMILKKING = 33812UL,
      FI_EN_B_AANDW = 33813UL,
      FI_EN_B_ROASTERS = 33814UL,
      FI_EN_B_DOMINOS = 33815UL,
      FI_EN_B_SUBWAY = 33816UL,
      FI_EN_B_FUJANINDUSTRIALBANK = 33817UL,
      FI_EN_B_HUANRUN = 33818UL,
      FI_EN_B_WALMART = 33819UL,
      FI_EN_B_PRICESMART = 33820UL,
      FI_EN_B_SHANGHAIPUDONGDEVELOPMENTBANK = 33821UL,
      FI_EN_B_HUALIAN = 33822UL,
      FI_EN_B_GLORIA = 33823UL,
      FI_EN_B_GRANDHYATT = 33824UL,
      FI_EN_B_GREENTREEINN = 33825UL,
      FI_EN_B_GUANGDONG = 33826UL,
      FI_EN_B_HANTINGHOTEL = 33827UL,
      FI_EN_B_HARBOURPLAZA = 33828UL,
      FI_EN_B_HNAHOTEL = 33829UL,
      FI_EN_B_HOLIDAYINNEXPRESS = 33830UL,
      FI_EN_B_JINJIANG = 33831UL,
      FI_EN_B_JINJIANGINN = 33832UL,
      FI_EN_B_JINLING = 33833UL,
      FI_EN_B_MOTEL168 = 33834UL,
      FI_EN_B_NEWCENTURY = 33835UL,
      FI_EN_B_SHANGRILA = 33836UL,
      FI_EN_B_TOPSTARHOTEL = 33837UL,
      FI_EN_B_TREASUREHOTEL = 33838UL,
      FI_EN_B_XICUIZL = 33839UL,
      FI_EN_B_XINYUZHIXINGHOTEL = 33840UL,
      FI_EN_B_AJISENRAMEN = 33841UL,
      FI_EN_B_DICOS = 33842UL,
      FI_EN_B_LAOJIABAKEMEAT = 33843UL,
      FI_EN_B_CHINARESOURCES = 33844UL,
      FI_EN_B_INDUSTRIALBANK = 33845UL,
      FI_EN_B_HANGSEN = 33846UL,
      FI_EN_B_WINGHANG = 33847UL,
      FI_EN_B_DBS = 33848UL,
      FI_EN_B_BANKOFEASTASIA = 33849UL,
      FI_EN_B_HONGQI = 33850UL,
      FI_EN_B_HOYODO = 33851UL,
      FI_EN_B_EASEINN = 33852UL,
      FI_EN_B_HUALIANSHANGHAIHUALIAN = 33853UL,
      FI_EN_B_HUHUI = 33854UL,
      FI_EN_B_JIADELI = 33855UL,
      FI_EN_B_JINGGONG = 33856UL,
      FI_EN_B_LIANHUA = 33857UL,
      FI_EN_B_MINRUN = 33858UL,
      FI_EN_B_NONGGONGSHANG = 33859UL,
      FI_EN_B_SUGUO = 33860UL,
      FI_EN_B_CELEBRITYCITY = 33861UL,
      FI_EN_B_WUMART = 33862UL,
      FI_EN_B_ZHONGBAI = 33863UL,
      FI_EN_B_MANNINGS = 33864UL,
      FI_EN_B_ASWASTONGROUP = 33865UL,
      FI_EN_B_WELLCOME = 33866UL,
      FI_EN_B_BARONY = 33867UL,
      FI_EN_B_HOMEINN = 33868UL,
      FI_EN_B_EASYINN = 33869UL,
      FI_EN_B_CONIFER = 33871UL,
      FI_EN_B_EASEHOTEL = 33872UL,
      FI_EN_B_TRUSTMART = 33873UL,
      FI_EN_BN_087_JALTA = 33880UL,
      FI_EN_BN_1_POTATO_2 = 33881UL,
      FI_EN_BN_101_DROGERIE = 33882UL,
      FI_EN_BN_01022003 = 33883UL,
      FI_EN_BN_241_PIZZA = 33884UL,
      FI_EN_BN_345_STORE = 33885UL,
      FI_EN_BN_36_6 = 33886UL,
      FI_EN_BN_5_MARINOPOULOS = 33887UL,
      FI_EN_BN_76 = 33888UL,
      FI_EN_BN_8_A_HUIT = 33889UL,
      FI_EN_BN_99_RESTAURANT = 33890UL,
      FI_EN_BN_A_BANK = 33891UL,
      FI_EN_BN_A_CASCATA = 33892UL,
      FI_EN_BN_A_O = 33893UL,
      FI_EN_BN_A_P = 33894UL,
      FI_EN_BN_A_W = 33895UL,
      FI_EN_BN_A_C_SANTOS = 33896UL,
      FI_EN_BN_A24 = 33897UL,
      FI_EN_BN_AAA_RENT_A_CAR = 33898UL,
      FI_EN_BN_AACHENER_BANK_EG = 33899UL,
      FI_EN_BN_AALT_AUTO_LOCATION_ROMANDIE_SA = 33900UL,
      FI_EN_BN_AAMCO_TRANSMISSIONS = 33901UL,
      FI_EN_BN_AARGAUISCHE_KANTONALBANK = 33902UL,
      FI_EN_BN_AB_HOTELS = 33903UL,
      FI_EN_BN_AB_VASSILOPOULOS = 33904UL,
      FI_EN_BN_ABA_PIKNIK = 33905UL,
      FI_EN_BN_ABACO = 33906UL,
      FI_EN_BN_ABANKA_VIPA = 33907UL,
      FI_EN_BN_ABBA_HOTELS = 33908UL,
      FI_EN_BN_ABBEY = 33909UL,
      FI_EN_BN_ABC_FINE_WINE_SPIRITS = 33910UL,
      FI_EN_BN_ABC = 33911UL,
      FI_EN_BN_ABERCROMBIE_FITCH = 33912UL,
      FI_EN_BN_ABK = 33913UL,
      FI_EN_BN_ABN_AMRO = 33914UL,
      FI_EN_BN_ABRA_AUTOBODY_GLASS = 33915UL,
      FI_EN_BN_ABSA = 33916UL,
      FI_EN_BN_ABSOLYUT_BANK = 33917UL,
      FI_EN_BN_ABU_DHABI_COMMERCIAL_BANK = 33918UL,
      FI_EN_BN_ABU_DIYAB = 33919UL,
      FI_EN_BN_AC_RESTAURANTS = 33920UL,
      FI_EN_BN_ACAPULCO_MEXICAN_RESTAURANT = 33921UL,
      FI_EN_BN_ACCBANK = 33922UL,
      FI_EN_BN_ACCENT_INN = 33923UL,
      FI_EN_BN_ACCESS_BANK = 33924UL,
      FI_EN_BN_ACCESSORIZE = 33925UL,
      FI_EN_BN_ACCIDENT_REPAIR_CENTRE = 33926UL,
      FI_EN_BN_ACE_CO_OP_BANK = 33927UL,
      FI_EN_BN_ACE_PARKING = 33928UL,
      FI_EN_BN_ACE_RENT_A_CAR = 33929UL,
      FI_EN_BN_ACHILLEAS_ACCESSORIES = 33930UL,
      FI_EN_BN_ACME_MARKETS = 33931UL,
      FI_EN_BN_ACTION = 33932UL,
      FI_EN_BN_ACTIVE_GREEN_ROSS = 33933UL,
      FI_EN_BN_ACTIVOBANK = 33934UL,
      FI_EN_BN_AD_DELHAIZE = 33935UL,
      FI_EN_BN_ADA = 33936UL,
      FI_EN_BN_ADABANK = 33937UL,
      FI_EN_BN_ADAC_AUTOVERMIETUNG = 33938UL,
      FI_EN_BN_ADAGIO_CITY_APARTHOTEL = 33939UL,
      FI_EN_BN_ADANA_SOFRASI = 33940UL,
      FI_EN_BN_ADEG = 33941UL,
      FI_EN_BN_ADESE = 33942UL,
      FI_EN_BN_ADESSA = 33943UL,
      FI_EN_BN_ADLER = 33944UL,
      FI_EN_BN_ADNOC = 33945UL,
      FI_EN_BN_ADRIA_BANK = 33946UL,
      FI_EN_BN_ADVANCE_AUTO_PARTS = 33947UL,
      FI_EN_BN_ADVANCED_AUTOMOTIVE = 33948UL,
      FI_EN_BN_AEROPOSTALE = 33949UL,
      FI_EN_BN_AEROSOLES = 33950UL,
      FI_EN_BN_AFIRME = 33951UL,
      FI_EN_BN_AFRA = 33952UL,
      FI_EN_BN_AFRIBANK_NIGERIA = 33953UL,
      FI_EN_BN_AFRICAN_BANK = 33954UL,
      FI_EN_BN_AFRIQUIA = 33955UL,
      FI_EN_BN_AG_S = 33956UL,
      FI_EN_BN_AGON = 33957UL,
      FI_EN_BN_AGUNG_RENT_A_CAR = 33958UL,
      FI_EN_BN_AHOLD = 33959UL,
      FI_EN_BN_AHORRAMAS = 33960UL,
      FI_EN_BN_AHUMADA = 33961UL,
      FI_EN_BN_AIG_BANK_POLSKA_SA = 33962UL,
      FI_EN_BN_AIROTEL = 33963UL,
      FI_EN_BN_AIZKRAUKLES_BANKA_LATVIJA = 33964UL,
      FI_EN_BN_AK_BARS = 33965UL,
      FI_EN_BN_AKBANK = 33966UL,
      FI_EN_BN_AKENA_HOTEL = 33967UL,
      FI_EN_BN_AKI = 33968UL,
      FI_EN_BN_AKO = 33969UL,
      FI_EN_BN_AKPET = 33970UL,
      FI_EN_BN_AKS = 33971UL,
      FI_EN_BN_AKYURT = 33972UL,
      FI_EN_BN_AL_ABRAAJ = 33973UL,
      FI_EN_BN_AL_AHALI = 33974UL,
      FI_EN_BN_AL_BAIK = 33975UL,
      FI_EN_BN_AL_MAHA = 33976UL,
      FI_EN_BN_AL_REHILY = 33977UL,
      FI_EN_BN_AL_SAFI = 33978UL,
      FI_EN_BN_AL_TAZAJ = 33979UL,
      FI_EN_BN_ALABAMA_NBC = 33980UL,
      FI_EN_BN_ALADDINS_EATERY = 33981UL,
      FI_EN_BN_ALADO = 33982UL,
      FI_EN_BN_ALAMO = 33983UL,
      FI_EN_BN_ALBARAKA_TURK = 33984UL,
      FI_EN_BN_ALBERT_HEIJN = 33985UL,
      FI_EN_BN_ALBERT = 33986UL,
      FI_EN_BN_ALBERTSONS_PHARMACY = 33987UL,
      FI_EN_BN_ALBERTSONS = 33988UL,
      FI_EN_BN_ALCAMPO = 33989UL,
      FI_EN_BN_ALDI = 33990UL,
      FI_EN_BN_ALDO = 33991UL,
      FI_EN_BN_ALE = 33992UL,
      FI_EN_BN_ALEMAGNA = 33993UL,
      FI_EN_BN_ALEPA = 33994UL,
      FI_EN_BN_ALEXI_ANDRIOTTI = 33995UL,
      FI_EN_BN_ALFA_MART = 33996UL,
      FI_EN_BN_ALFA_BANK = 33997UL,
      FI_EN_BN_ALIMENTA = 33998UL,
      FI_EN_BN_ALIMERKA = 33999UL,
      FI_EN_BN_ALIMEX = 34000UL,
      FI_EN_BN_ALINEA = 34001UL,
      FI_EN_BN_ALIOR_BANK = 34002UL,
      FI_EN_BN_ALIPROX = 34003UL,
      FI_EN_BN_ALISUPER = 34004UL,
      FI_EN_BN_ALL_SEASONS_EUROPE = 34005UL,
      FI_EN_BN_ALL_TUNE_LUBE = 34006UL,
      FI_EN_BN_ALLAHABAD_BANK = 34007UL,
      FI_EN_BN_ALLIANCE_LEICESTER = 34008UL,
      FI_EN_BN_ALLIED_IRISH_BANK = 34009UL,
      FI_EN_BN_ALLIED_TIRES_SERVICE = 34010UL,
      FI_EN_BN_ALLO_TELECOM = 34011UL,
      FI_EN_BN_ALM_BRAND = 34012UL,
      FI_EN_BN_ALMA_MARKET = 34013UL,
      FI_EN_BN_ALNATURA = 34014UL,
      FI_EN_BN_ALOC_CARS = 34015UL,
      FI_EN_BN_ALOFT = 34016UL,
      FI_EN_BN_ALOHA = 34017UL,
      FI_EN_BN_ALOUETTE = 34018UL,
      FI_EN_BN_ALPARK = 34019UL,
      FI_EN_BN_ALPET = 34020UL,
      FI_EN_BN_ALPHA_BANK = 34021UL,
      FI_EN_BN_ALPHA_COPY_NOKIA_STORES = 34022UL,
      FI_EN_BN_ALTAE = 34023UL,
      FI_EN_BN_ALTUNBILEKLER = 34024UL,
      FI_EN_BN_ALVI = 34025UL,
      FI_EN_BN_AMAGERBANKEN = 34026UL,
      FI_EN_BN_AMARANTE_HOTELS = 34027UL,
      FI_EN_BN_AMARILLO = 34028UL,
      FI_EN_BN_AMARINE = 34029UL,
      FI_EN_BN_AMATOS = 34030UL,
      FI_EN_BN_AMBIT_RSM_BANK = 34031UL,
      FI_EN_BN_AMC_THEATRES = 34032UL,
      FI_EN_BN_AMCORE_BANK = 34033UL,
      FI_EN_BN_AMERICAN_CAFE = 34034UL,
      FI_EN_BN_AMERICAN_EAGLE_OUTFITTERS = 34035UL,
      FI_EN_BN_AMERICAN_NATIONAL_BANK = 34036UL,
      FI_EN_BN_AMERICAN_SAVINGS_BANK = 34037UL,
      FI_EN_BN_AMERICAS_BEST_VALUE_INN = 34038UL,
      FI_EN_BN_AMERICAS_TIRE = 34039UL,
      FI_EN_BN_AMERICINN_HOTEL_SUITES = 34040UL,
      FI_EN_BN_AMERICINN_LODGE_SUITES = 34041UL,
      FI_EN_BN_AMERICINN_MOTEL_SUITES = 34042UL,
      FI_EN_BN_AMERICINN = 34043UL,
      FI_EN_BN_AMICO = 34044UL,
      FI_EN_BN_AMIGO = 34045UL,
      FI_EN_BN_AMPM = 34046UL,
      FI_EN_BN_AMRAT_HOTELS = 34047UL,
      FI_EN_BN_AMRATH_HOTELS = 34048UL,
      FI_EN_BN_AMREY_HOTELS = 34049UL,
      FI_EN_BN_AMSOUTH_BANK = 34050UL,
      FI_EN_BN_ANADOLUBANK = 34051UL,
      FI_EN_BN_ANCANARA = 34052UL,
      FI_EN_BN_ANCHOR_BC = 34053UL,
      FI_EN_BN_ANCHORBANK = 34054UL,
      FI_EN_BN_ANDAZ = 34055UL,
      FI_EN_BN_ANDELSKASSEN = 34056UL,
      FI_EN_BN_ANDHRA_BANK = 34057UL,
      FI_EN_BN_ANDYS_BURGERS_SHAKES_FRIES = 34058UL,
      FI_EN_BN_ANGLO_IRISH_BANK = 34059UL,
      FI_EN_BN_ANGLO_ROMANIAN_BANK = 34060UL,
      FI_EN_BN_ANKER = 34061UL,
      FI_EN_BN_ANN_TAYLOR_FACTORY = 34062UL,
      FI_EN_BN_ANN_TAYLOR_LOFT = 34063UL,
      FI_EN_BN_ANN_TAYLOR = 34064UL,
      FI_EN_BN_ANNA_RISKA = 34065UL,
      FI_EN_BN_ANNA = 34066UL,
      FI_EN_BN_ANTIBES_PARKING = 34067UL,
      FI_EN_BN_ANTOL = 34068UL,
      FI_EN_BN_ANWB = 34069UL,
      FI_EN_BN_ANZ = 34070UL,
      FI_EN_BN_AP = 34071UL,
      FI_EN_BN_APCOA = 34072UL,
      FI_EN_BN_APNA_BAZAAR = 34073UL,
      FI_EN_BN_APNA_SAHAKARI_BANK = 34074UL,
      FI_EN_BN_APO_BANK = 34075UL,
      FI_EN_BN_APOLLO = 34076UL,
      FI_EN_BN_APPENZELLER_KANTONALBANK = 34077UL,
      FI_EN_BN_APPLE_AUTO_GLASS = 34078UL,
      FI_EN_BN_APPLEBEES = 34079UL,
      FI_EN_BN_APSIS_HOTELS = 34080UL,
      FI_EN_BN_ARAB_BANK = 34081UL,
      FI_EN_BN_ARAB_WORLD_RESTAURANT = 34082UL,
      FI_EN_BN_ARAP_TURK_BANKASI = 34083UL,
      FI_EN_BN_ARBEJDERNES_LANDSBANK = 34084UL,
      FI_EN_BN_ARBYS = 34085UL,
      FI_EN_BN_ARC = 34086UL,
      FI_EN_BN_ARD_DISCOUNT = 34087UL,
      FI_EN_BN_ARDENE = 34088UL,
      FI_EN_BN_ARENA_MLADOST = 34089UL,
      FI_EN_BN_ARENA_WEST = 34090UL,
      FI_EN_BN_ARGENTA = 34091UL,
      FI_EN_BN_ARGO = 34092UL,
      FI_EN_BN_ARGOS_OIL = 34093UL,
      FI_EN_BN_ARIADNI = 34094UL,
      FI_EN_BN_ARIS = 34095UL,
      FI_EN_BN_ARS = 34096UL,
      FI_EN_BN_ART_MOZI = 34097UL,
      FI_EN_BN_ARTHUR_TREACHERS = 34098UL,
      FI_EN_BN_ARTOTEL = 34099UL,
      FI_EN_BN_AS_ADVENTURE = 34100UL,
      FI_EN_BN_ASCEND_COLLECTION = 34101UL,
      FI_EN_BN_ASCOTT_THE_RESIDENCE = 34102UL,
      FI_EN_BN_ASHLEY_STEWART = 34103UL,
      FI_EN_BN_ASOIL = 34104UL,
      FI_EN_BN_ASPIS_BANK = 34105UL,
      FI_EN_BN_ASPRO = 34106UL,
      FI_EN_BN_ASSOCIATED_BANK = 34107UL,
      FI_EN_BN_ASTRAKHANGAZPROM = 34108UL,
      FI_EN_BN_ASTURIENNE = 34109UL,
      FI_EN_BN_AT_T = 34110UL,
      FI_EN_BN_ATAHOTEL = 34111UL,
      FI_EN_BN_ATB_FINANCIAL = 34112UL,
      FI_EN_BN_ATEBANK = 34113UL,
      FI_EN_BN_ATHENS_OIL = 34114UL,
      FI_EN_BN_ATHLETES_WORLD = 34115UL,
      FI_EN_BN_ATL_MIETWAGEN_GESMBH = 34116UL,
      FI_EN_BN_ATLANTSOLIA = 34117UL,
      FI_EN_BN_ATRIUM_HOTELS = 34118UL,
      FI_EN_BN_ATS_EUROMASTER = 34119UL,
      FI_EN_BN_ATTICA_BANK = 34120UL,
      FI_EN_BN_ATTIJARIWAFA_BANK = 34121UL,
      FI_EN_BN_ATU = 34122UL,
      FI_EN_BN_AU_BON_PAIN = 34123UL,
      FI_EN_BN_AU_BUREAU = 34124UL,
      FI_EN_BN_AUNTIE_ANNES = 34125UL,
      FI_EN_BN_AURELIOS_PIZZA = 34126UL,
      FI_EN_BN_AURGI = 34127UL,
      FI_EN_BN_AURIGA = 34128UL,
      FI_EN_BN_AURORA_PHARMACY = 34129UL,
      FI_EN_BN_AUTO_ATLANTIS = 34130UL,
      FI_EN_BN_AUTO_DOCTOR = 34131UL,
      FI_EN_BN_AUTO_EUROPA = 34132UL,
      FI_EN_BN_AUTO_GLASS_CENTER = 34133UL,
      FI_EN_BN_AUTO_GLASS_SPECIALISTS = 34134UL,
      FI_EN_BN_AUTO_RENT = 34135UL,
      FI_EN_BN_AUTOBAHN = 34136UL,
      FI_EN_BN_AUTODRIVER = 34137UL,
      FI_EN_BN_AUTOFERBAR = 34138UL,
      FI_EN_BN_AUTOFOOD = 34139UL,
      FI_EN_BN_AUTOGOLDEN = 34140UL,
      FI_EN_BN_AUTOGRILL = 34141UL,
      FI_EN_BN_AUTO_JARDIM = 34142UL,
      FI_EN_BN_AUTOLUX = 34143UL,
      FI_EN_BN_AUTOMATIC_RESTAURANT = 34144UL,
      FI_EN_BN_AUTONOM_RENT_A_CAR = 34145UL,
      FI_EN_BN_AUTOP = 34146UL,
      FI_EN_BN_AUTORENT = 34147UL,
      FI_EN_BN_AUTOTAALGLAS = 34148UL,
      FI_EN_BN_AUTOZONE = 34149UL,
      FI_EN_BN_AVA = 34150UL,
      FI_EN_BN_AVENTA = 34151UL,
      FI_EN_BN_AVENUE = 34152UL,
      FI_EN_BN_AVEVE = 34153UL,
      FI_EN_BN_AVIS = 34154UL,
      FI_EN_BN_AVOSKA = 34155UL,
      FI_EN_BN_AVR_RENT_A_CAR = 34156UL,
      FI_EN_BN_AXA = 34157UL,
      FI_EN_BN_AXIS_BANK = 34158UL,
      FI_EN_BN_AXON = 34159UL,
      FI_EN_BN_AZBUKA_VKUSA = 34160UL,
      FI_EN_BN_AZORIA = 34161UL,
      FI_EN_BN_AZTECA = 34162UL,
      FI_EN_BN_B_DALTON = 34163UL,
      FI_EN_BN_BABIESRUS = 34164UL,
      FI_EN_BN_BACK_YARD_BURGERS = 34165UL,
      FI_EN_BN_BADENIA = 34166UL,
      FI_EN_BN_BADGET = 34167UL,
      FI_EN_BN_BAHAMA_BREEZE = 34168UL,
      FI_EN_BN_BAJA_FRESH = 34169UL,
      FI_EN_BN_BAJAJ_AUTO = 34170UL,
      FI_EN_BN_BAKERS_SQUARE = 34171UL,
      FI_EN_BN_BAKERS = 34172UL,
      FI_EN_BN_BALA = 34173UL,
      FI_EN_BN_BALOISE_BANK_SOBA = 34174UL,
      FI_EN_BN_BALTIC_INTERNATIONAL_BANK = 34175UL,
      FI_EN_BN_BALTIC_PETROLEUM = 34176UL,
      FI_EN_BN_BALTIC_TRUST_BANK = 34177UL,
      FI_EN_BN_BALTINVESTBANK = 34178UL,
      FI_EN_BN_BALTIYSKIY_BANK = 34179UL,
      FI_EN_BN_BALT_TREYD = 34180UL,
      FI_EN_BN_BANAMEX = 34181UL,
      FI_EN_BN_BANANA_REPUBLIC = 34182UL,
      FI_EN_BN_BANC_POST = 34183UL,
      FI_EN_BN_BANCA_AGRICOLA_DI_CEREA = 34184UL,
      FI_EN_BN_BANCA_AGRICOLA_MANTOVANA = 34185UL,
      FI_EN_BN_BANCA_ANTONIANA_POPOLARE_VENETA = 34186UL,
      FI_EN_BN_BANCA_ANTONVENETA = 34187UL,
      FI_EN_BN_BANCA_BRIGNONE = 34188UL,
      FI_EN_BN_BANCA_CARIGE = 34189UL,
      FI_EN_BN_BANCA_CARIME = 34190UL,
      FI_EN_BN_BANCA_CHANTUNALA_GRISCHUNA = 34191UL,
      FI_EN_BN_BANCA_COMERCIALA_CARPATICA = 34192UL,
      FI_EN_BN_BANCA_COMERCIALA_ROMANA = 34193UL,
      FI_EN_BN_BANCA_COMMERCIALE_ITALIANA = 34194UL,
      FI_EN_BN_BANCA_COOP = 34195UL,
      FI_EN_BN_BANCA_CR_FIRENZE = 34196UL,
      FI_EN_BN_BANCA_CRT = 34197UL,
      FI_EN_BN_BANCA_DEL_FUCINO = 34198UL,
      FI_EN_BN_BANCA_DEL_GARDA = 34199UL,
      FI_EN_BN_BANCA_DEL_PIEMONTE = 34200UL,
      FI_EN_BN_BANCA_DELLA_CAMPANIA = 34201UL,
      FI_EN_BN_BANCA_DELLA_CIOCIARIA = 34202UL,
      FI_EN_BN_BANCA_DELLA_PROVINCIA_DI_MACERATA = 34203UL,
      FI_EN_BN_BANCA_DELLAGRICOLTURA = 34204UL,
      FI_EN_BN_BANCA_DELLO_STATO_DEL_CANTON_TICINO = 34205UL,
      FI_EN_BN_BANCA_DI_BERGAMO = 34206UL,
      FI_EN_BN_BANCA_DI_BOLOGNA = 34207UL,
      FI_EN_BN_BANCA_DI_CAGLIARI = 34208UL,
      FI_EN_BN_BANCA_DI_CREDITO_COOPERAT_DI_ROMA = 34209UL,
      FI_EN_BN_BANCA_DI_CREDITO_COOPERAT_GENOVESE = 34210UL,
      FI_EN_BN_BANCA_DI_CREDITO_COOPERATIVO = 34211UL,
      FI_EN_BN_BANCA_DI_PALERMO = 34212UL,
      FI_EN_BN_BANCA_DI_PIACENZA = 34213UL,
      FI_EN_BN_BANCA_DI_RIMINI = 34214UL,
      FI_EN_BN_BANCA_DI_ROMA = 34215UL,
      FI_EN_BN_BANCA_DI_SASSARI = 34216UL,
      FI_EN_BN_BANCA_DI_TRENTO_E_BOLZANO = 34217UL,
      FI_EN_BN_BANCA_DI_VERONA = 34218UL,
      FI_EN_BN_BANCA_ETRURIA = 34219UL,
      FI_EN_BN_BANCA_FIDEURAM = 34220UL,
      FI_EN_BN_BANCA_GENERALI = 34221UL,
      FI_EN_BN_BANCA_INTESA = 34222UL,
      FI_EN_BN_BANCA_LEONARDO = 34223UL,
      FI_EN_BN_BANCA_LOMBARDA = 34224UL,
      FI_EN_BN_BANCA_MALATESTIANA = 34225UL,
      FI_EN_BN_BANCA_MARCH = 34226UL,
      FI_EN_BN_BANCA_MARCHE = 34227UL,
      FI_EN_BN_BANCA_MEDIOLANUM = 34228UL,
      FI_EN_BN_BANCA_NAZIONALE_DEL_LAVORO = 34229UL,
      FI_EN_BN_BANCA_PASSADORE_C = 34230UL,
      FI_EN_BN_BANCA_POLARE_PUGLIA_E_BASILICATA = 34231UL,
      FI_EN_BN_BANCA_PONTI = 34232UL,
      FI_EN_BN_BANCA_POP_COMMERCIO_E_INDUSTRIA = 34233UL,
      FI_EN_BN_BANCA_POP_DELLETRURIA_E_DEL_LAZIO = 34234UL,
      FI_EN_BN_BANCA_POPOL_COMMERCIO_E_INDUSTRIA = 34235UL,
      FI_EN_BN_BANCA_POPOLARE_DEL_LAZIO = 34236UL,
      FI_EN_BN_BANCA_POPOLARE_DELLADRIATICO = 34237UL,
      FI_EN_BN_BANCA_POPOLARE_DELLEMILIA_ROMAGNA = 34238UL,
      FI_EN_BN_BANCA_POPOLARE_DI_ANCONA = 34239UL,
      FI_EN_BN_BANCA_POPOLARE_DI_APRILIA = 34240UL,
      FI_EN_BN_BANCA_POPOLARE_DI_BARI = 34241UL,
      FI_EN_BN_BANCA_POPOLARE_DI_BERGAMO = 34242UL,
      FI_EN_BN_BANCA_POPOLARE_DI_LODI = 34243UL,
      FI_EN_BN_BANCA_POPOLARE_DI_MILANO = 34244UL,
      FI_EN_BN_BANCA_POPOLARE_DI_NOVARA = 34245UL,
      FI_EN_BN_BANCA_POPOLARE_DI_RAVENNA = 34246UL,
      FI_EN_BN_BANCA_POPOLARE_DI_SONDRIO = 34247UL,
      FI_EN_BN_BANCA_POPOLARE_DI_SPOLETO = 34248UL,
      FI_EN_BN_BANCA_POPOLARE_DI_VICENZA = 34249UL,
      FI_EN_BN_BANCA_POPOLARE_ITALIANA = 34250UL,
      FI_EN_BN_BANCA_POPOLARE_PUGLIA_E_BASILICATA = 34251UL,
      FI_EN_BN_BANCA_POPOLARE_VALCONCA = 34252UL,
      FI_EN_BN_BANCA_PUEYO = 34253UL,
      FI_EN_BN_BANCA_REGIONALE_EUROPEA = 34254UL,
      FI_EN_BN_BANCA_ROMANEASCA = 34255UL,
      FI_EN_BN_BANCA_SELLA = 34256UL,
      FI_EN_BN_BANCA_TOSCANA = 34257UL,
      FI_EN_BN_BANCA_TRANSILVANIA = 34258UL,
      FI_EN_BN_BANCA_VESUVIANA = 34259UL,
      FI_EN_BN_BANCAJA = 34260UL,
      FI_EN_BN_BANCAMIGROS = 34261UL,
      FI_EN_BN_BANCAPULIA = 34262UL,
      FI_EN_BN_BANCARIBE = 34263UL,
      FI_EN_BN_BANCFIRST = 34264UL,
      FI_EN_BN_BANCO_24HORAS = 34265UL,
      FI_EN_BN_BANCO_ALCALA = 34266UL,
      FI_EN_BN_BANCO_AMBROSIANO_VENETO = 34267UL,
      FI_EN_BN_BANCO_AZTECA = 34268UL,
      FI_EN_BN_BANCO_CAIXA_GERAL = 34269UL,
      FI_EN_BN_BANCO_CANARIAS = 34270UL,
      FI_EN_BN_BANCO_CARONI = 34271UL,
      FI_EN_BN_BANCO_CIUDAD = 34272UL,
      FI_EN_BN_BANCO_COMAFI = 34273UL,
      FI_EN_BN_BANCO_CONDELL = 34274UL,
      FI_EN_BN_BANCO_COOPERATIVO_ESPANOL = 34275UL,
      FI_EN_BN_BANCO_CREDICHILE = 34276UL,
      FI_EN_BN_BANCO_CREDICOOP = 34277UL,
      FI_EN_BN_BANCO_DE_ANDALUCIA = 34278UL,
      FI_EN_BN_BANCO_DE_CASTILLA = 34279UL,
      FI_EN_BN_BANCO_DE_CHILE = 34280UL,
      FI_EN_BN_BANCO_DE_CREDITO_BALEAR = 34281UL,
      FI_EN_BN_BANCO_DE_ESPANA = 34282UL,
      FI_EN_BN_BANCO_DE_GALICIA = 34283UL,
      FI_EN_BN_BANCO_DE_INVESTIMENTO_GLOBAL = 34284UL,
      FI_EN_BN_BANCO_DE_LA_NACION_ARGENTINA = 34285UL,
      FI_EN_BN_BANCO_DE_VALENCIA = 34286UL,
      FI_EN_BN_BANCO_DE_VASCONIA = 34287UL,
      FI_EN_BN_BANCO_DE_VENEZUELA = 34288UL,
      FI_EN_BN_BANCO_DEL_BAJIO = 34289UL,
      FI_EN_BN_BANCO_DEL_COMERCIO = 34290UL,
      FI_EN_BN_BANCO_DEL_DESARROLLO = 34291UL,
      FI_EN_BN_BANCO_DESIO_LAZIO = 34292UL,
      FI_EN_BN_BANCO_DESIO = 34293UL,
      FI_EN_BN_BANCO_DI_BRESCIA = 34294UL,
      FI_EN_BN_BANCO_DI_CHIAVARI_E_RIVIERA_LIGURE = 34295UL,
      FI_EN_BN_BANCO_DI_NAPOLI = 34296UL,
      FI_EN_BN_BANCO_DI_SAN_GIORGIO = 34297UL,
      FI_EN_BN_BANCO_DI_SARDEGNA = 34298UL,
      FI_EN_BN_BANCO_DI_SICILIA = 34299UL,
      FI_EN_BN_BANCO_DO_BRASIL = 34300UL,
      FI_EN_BN_BANCO_ECHEVERRIA = 34301UL,
      FI_EN_BN_BANCO_ESPIRITO_SANTO = 34302UL,
      FI_EN_BN_BANCO_ESPIRITO_SANTO_2 = 34303UL,
      FI_EN_BN_BANCO_EUROPEO_DE_FINANZAS = 34304UL,
      FI_EN_BN_BANCO_EXTERIOR = 34305UL,
      FI_EN_BN_BANCO_FALABELLA = 34306UL,
      FI_EN_BN_BANCO_FEDERAL = 34307UL,
      FI_EN_BN_BANCO_FINANTIA_SOFINLOC = 34308UL,
      FI_EN_BN_BANCO_FRANCES = 34309UL,
      FI_EN_BN_BANCO_GALLEGO = 34310UL,
      FI_EN_BN_BANCO_GUAYANA = 34311UL,
      FI_EN_BN_BANCO_GUIPUZCOANO = 34312UL,
      FI_EN_BN_BANCO_HERRERO = 34313UL,
      FI_EN_BN_BANCO_INDUSTRIAL_DE_VENEZUELA = 34314UL,
      FI_EN_BN_BANCO_INTERNACIONAL_DO_FUNCHAL = 34315UL,
      FI_EN_BN_BANCO_MADRID = 34316UL,
      FI_EN_BN_BANCO_MAIS = 34317UL,
      FI_EN_BN_BANCO_MERCANTIL = 34318UL,
      FI_EN_BN_BANCO_NACIONAL_DE_CREDITO = 34319UL,
      FI_EN_BN_BANCO_PARIS = 34320UL,
      FI_EN_BN_BANCO_PASTOR = 34321UL,
      FI_EN_BN_BANCO_PLAZA = 34322UL,
      FI_EN_BN_BANCO_POPOLARE_DI_VERONA_E_NOVARA = 34323UL,
      FI_EN_BN_BANCO_POPOLARE = 34324UL,
      FI_EN_BN_BANCO_POPULAR = 34325UL,
      FI_EN_BN_BANCO_PORTUGUES_DE_INVESTIMENTO = 34326UL,
      FI_EN_BN_BANCO_PORTUGUES_DE_NEGOCIOS = 34327UL,
      FI_EN_BN_BANCO_RIPLEY = 34328UL,
      FI_EN_BN_BANCO_SAN_GEMINIANO_E_SAN_PROSPERO = 34329UL,
      FI_EN_BN_BANCO_SECURITY = 34330UL,
      FI_EN_BN_BANCO_SIMEON = 34331UL,
      FI_EN_BN_BANCO_SOFITASA = 34332UL,
      FI_EN_BN_BANCO_URQUIJO = 34333UL,
      FI_EN_BN_BANCOA_CREDIT_AGRICOLE = 34334UL,
      FI_EN_BN_BANCOBICE = 34335UL,
      FI_EN_BN_BANCOESTADO = 34336UL,
      FI_EN_BN_BANCOEX = 34337UL,
      FI_EN_BN_BANCOFAR = 34338UL,
      FI_EN_BN_BANCOMER = 34339UL,
      FI_EN_BN_BANCOPOPULAR_ECOM = 34340UL,
      FI_EN_BN_BANCORPSOUTH = 34341UL,
      FI_EN_BN_BANCORREOS = 34342UL,
      FI_EN_BN_BANCOSABADELL = 34343UL,
      FI_EN_BN_BANCSABADELL = 34344UL,
      FI_EN_BN_BANCWEST = 34345UL,
      FI_EN_BN_BANDANAS_BAR_B_QUE_AND_GRILL = 34346UL,
      FI_EN_BN_BANESCO = 34347UL,
      FI_EN_BN_BANESTO = 34348UL,
      FI_EN_BN_BANGALORE_DISTRICT_CO_OP_BANK = 34349UL,
      FI_EN_BN_BANGALORE_SOUHARDA_CO_OP_BANK = 34350UL,
      FI_EN_BN_BANGKOK_BANK = 34351UL,
      FI_EN_BN_BANIF = 34352UL,
      FI_EN_BN_BANK_1_SAAR = 34353UL,
      FI_EN_BN_BANK_ASYA = 34354UL,
      FI_EN_BN_BANK_AUSTRIA = 34355UL,
      FI_EN_BN_BANK_BPH = 34356UL,
      FI_EN_BN_BANK_BUKOPIN = 34357UL,
      FI_EN_BN_BANK_BUMIPUTERA = 34358UL,
      FI_EN_BN_BANK_CENTRAL_ASIA = 34359UL,
      FI_EN_BN_BANK_COOP = 34360UL,
      FI_EN_BN_BANK_DANAMON = 34361UL,
      FI_EN_BN_BANK_DIPO = 34362UL,
      FI_EN_BN_BANK_EKONOMI = 34363UL,
      FI_EN_BN_BANK_EKSEKUTIF_INTERNASIONAL = 34364UL,
      FI_EN_BN_BANK_GANESHA = 34365UL,
      FI_EN_BN_BANK_GOSPODARKI_ZYWNOSCIOWEJ = 34366UL,
      FI_EN_BN_BANK_HALIM_INDONESIA = 34367UL,
      FI_EN_BN_BANK_IFI = 34368UL,
      FI_EN_BN_BANK_INDONESIA = 34369UL,
      FI_EN_BN_BANK_INTERNASIONAL_INDONESIA = 34370UL,
      FI_EN_BN_BANK_INTERNATIONAL_ASIA = 34371UL,
      FI_EN_BN_BANK_JABAR = 34372UL,
      FI_EN_BN_BANK_JASA_JAKARTA = 34373UL,
      FI_EN_BN_BANK_LINTH = 34374UL,
      FI_EN_BN_BANK_MANDIRI = 34375UL,
      FI_EN_BN_BANK_MASPION = 34376UL,
      FI_EN_BN_BANK_MAYAPADA_INTERNASIONAL = 34377UL,
      FI_EN_BN_BANK_MAYORA = 34378UL,
      FI_EN_BN_BANK_MEGA = 34379UL,
      FI_EN_BN_BANK_MELLAT = 34380UL,
      FI_EN_BN_BANK_MIDWEST = 34381UL,
      FI_EN_BN_BANK_MOSKVY = 34382UL,
      FI_EN_BN_BANK_NEGARA_INDONESIA = 34383UL,
      FI_EN_BN_BANK_NIAGA = 34384UL,
      FI_EN_BN_BANK_NISP = 34385UL,
      FI_EN_BN_BANK_OCHRONY_SRODOWISKA = 34386UL,
      FI_EN_BN_BANK_OF_AMERICA = 34387UL,
      FI_EN_BN_BANK_OF_BARODA = 34388UL,
      FI_EN_BN_BANK_OF_CYPRUS = 34389UL,
      FI_EN_BN_BANK_OF_GREECE = 34390UL,
      FI_EN_BN_BANK_OF_HAWAII = 34391UL,
      FI_EN_BN_BANK_OF_INDIA = 34392UL,
      FI_EN_BN_BANK_OF_IRELAND = 34393UL,
      FI_EN_BN_BANK_OF_MADURA = 34394UL,
      FI_EN_BN_BANK_OF_MAHARASHTRA = 34395UL,
      FI_EN_BN_BANK_OF_MONTREAL = 34396UL,
      FI_EN_BN_BANK_OF_NEW_YORK = 34397UL,
      FI_EN_BN_BANK_OF_PUNJAB = 34398UL,
      FI_EN_BN_BANK_OF_QUEENSLAND = 34399UL,
      FI_EN_BN_BANK_OF_RAJASTHAN = 34400UL,
      FI_EN_BN_BANK_OF_SCOTLAND = 34401UL,
      FI_EN_BN_BANK_OF_THE_WEST = 34402UL,
      FI_EN_BN_BANK_OF_TOKYO = 34403UL,
      FI_EN_BN_BANK_PEKAO_SA = 34404UL,
      FI_EN_BN_BANK_PHB = 34405UL,
      FI_EN_BN_BANK_POCZTOWY = 34406UL,
      FI_EN_BN_BANK_POLSKIEJ_SPOLDZIELCZOSCI = 34407UL,
      FI_EN_BN_BANK_RAKYAT_INDONESIA = 34408UL,
      FI_EN_BN_BANK_UIB = 34409UL,
      FI_EN_BN_BANK_VAN_DE_POST = 34410UL,
      FI_EN_BN_BANK_VICTORIA = 34411UL,
      FI_EN_BN_BANK_VOZROZHDENIE = 34412UL,
      FI_EN_BN_BANK_ZACHODNI_WBK = 34413UL,
      FI_EN_BN_BANKA_CELJE = 34414UL,
      FI_EN_BN_BANKA_KOPER = 34415UL,
      FI_EN_BN_BANKINTER = 34416UL,
      FI_EN_BN_BANKOA = 34417UL,
      FI_EN_BN_BANKPYME = 34418UL,
      FI_EN_BN_BANORTE = 34419UL,
      FI_EN_BN_BANQUE_CANTONALE_BERNOISE = 34420UL,
      FI_EN_BN_BANQUE_CANTONALE_DE_BALE = 34421UL,
      FI_EN_BN_BANQUE_CANTONALE_DE_FRIBOURG = 34422UL,
      FI_EN_BN_BANQUE_CANTONALE_DE_GENEVE = 34423UL,
      FI_EN_BN_BANQUE_CANTONALE_DU_JURA = 34424UL,
      FI_EN_BN_BANQUE_CANTONALE_DU_VALAIS = 34425UL,
      FI_EN_BN_BANQUE_CANTONALE_NEUCHATELOISE = 34426UL,
      FI_EN_BN_BANQUE_CANTONALE_VAUDOISE = 34427UL,
      FI_EN_BN_BANQUE_COOP = 34428UL,
      FI_EN_BN_BANQUE_DE_BRETAGNE = 34429UL,
      FI_EN_BN_BANQUE_DE_FRANCE = 34430UL,
      FI_EN_BN_BANQUE_DE_LA_POSTE = 34431UL,
      FI_EN_BN_BANQUE_DE_MONTREAL = 34432UL,
      FI_EN_BN_BANQUE_DE_SAVOIE = 34433UL,
      FI_EN_BN_BANQUE_J_VAN_BREDA_CO = 34434UL,
      FI_EN_BN_BANQUE_LAURENTIENNE = 34435UL,
      FI_EN_BN_BANQUE_MARTIN_MAUREL = 34436UL,
      FI_EN_BN_BANQUE_MIGROS = 34437UL,
      FI_EN_BN_BANQUE_NATIONALE = 34438UL,
      FI_EN_BN_BANQUE_PALATINE = 34439UL,
      FI_EN_BN_BANQUE_POPULAIRE = 34440UL,
      FI_EN_BN_BANQUE_SCOTIA = 34441UL,
      FI_EN_BN_BANQUE_TARNEAUD = 34442UL,
      FI_EN_BN_BANREGIO = 34443UL,
      FI_EN_BN_BANRISUL = 34444UL,
      FI_EN_BN_BAPCO = 34445UL,
      FI_EN_BN_BARCLAYS = 34446UL,
      FI_EN_BN_BARISTA = 34447UL,
      FI_EN_BN_BARNES_NOBLE_BOOKSELLERS = 34448UL,
      FI_EN_BN_BARNEYS_NEW_YORK = 34449UL,
      FI_EN_BN_BARNHILLS = 34450UL,
      FI_EN_BN_BAS_VAN_DER_HEIJDEN = 34451UL,
      FI_EN_BN_BASE_SHOP = 34452UL,
      FI_EN_BN_BASELLANDSCHAFTLICHE_KANTONALBANK = 34453UL,
      FI_EN_BN_BASGIMPA = 34454UL,
      FI_EN_BN_BASHKIRNEFT = 34455UL,
      FI_EN_BN_BASHKIRNEFTEPRODUKT = 34456UL,
      FI_EN_BN_BASHNEFT = 34457UL,
      FI_EN_BN_BASIC = 34458UL,
      FI_EN_BN_BASILE_PETROLI = 34459UL,
      FI_EN_BN_BASKIN_ROBBINS = 34460UL,
      FI_EN_BN_BASKO = 34461UL,
      FI_EN_BN_BASLER_KANTONALBANK = 34462UL,
      FI_EN_BN_BASS = 34463UL,
      FI_EN_BN_BATA = 34464UL,
      FI_EN_BN_BATH_BODY_WORKS = 34465UL,
      FI_EN_BN_BATRIQ = 34466UL,
      FI_EN_BN_BATTARD = 34467UL,
      FI_EN_BN_BATTERIES_PLUS = 34468UL,
      FI_EN_BN_BAUHAUS = 34469UL,
      FI_EN_BN_BAUKING = 34470UL,
      FI_EN_BN_BAUMAX = 34471UL,
      FI_EN_BN_BAWAG_PSK = 34472UL,
      FI_EN_BN_BAYFIN = 34473UL,
      FI_EN_BN_BAYMONT_INN_SUITES = 34474UL,
      FI_EN_BN_BAYWA = 34475UL,
      FI_EN_BN_BAZAAR = 34476UL,
      FI_EN_BN_BB_BANK = 34477UL,
      FI_EN_BN_BB_T = 34478UL,
      FI_EN_BN_BBK = 34479UL,
      FI_EN_BN_BBVA_BANCO_PROVINCIAL = 34480UL,
      FI_EN_BN_BBVA_BANCOMER = 34481UL,
      FI_EN_BN_BBVA = 34482UL,
      FI_EN_BN_BCA = 34483UL,
      FI_EN_BN_BCBGMAXAZRIA = 34484UL,
      FI_EN_BN_BCEE = 34485UL,
      FI_EN_BN_BCI = 34486UL,
      FI_EN_BN_BCL = 34487UL,
      FI_EN_BN_BCP = 34488UL,
      FI_EN_BN_BDC = 34489UL,
      FI_EN_BN_BDS_MONGOLIAN_BARBEQUE = 34490UL,
      FI_EN_BN_BECKS_PRIME = 34491UL,
      FI_EN_BN_BEEF_OBRADYS = 34492UL,
      FI_EN_BN_BEEFEATER = 34493UL,
      FI_EN_BN_BELAMBRA_VVF = 34494UL,
      FI_EN_BN_BELCOMPANY = 34495UL,
      FI_EN_BN_BELGACOM = 34496UL,
      FI_EN_BN_BELL = 34497UL,
      FI_EN_BN_BELLAFLORA = 34498UL,
      FI_EN_BN_BEMOL = 34499UL,
      FI_EN_BN_BEN_JERRYS = 34500UL,
      FI_EN_BN_BENDIGO_BANK = 34501UL,
      FI_EN_BN_BENEDETTIS = 34502UL,
      FI_EN_BN_BENEFICIAL_FINANCE = 34503UL,
      FI_EN_BN_BENIHANA = 34504UL,
      FI_EN_BN_UNITED_COLORS_OF_BENETTON = 34505UL,
      FI_EN_BN_BENNIGANS = 34506UL,
      FI_EN_BN_BENSAUDE_TURISMO = 34507UL,
      FI_EN_BN_BENT = 34508UL,
      FI_EN_BN_BENTLEY_LEATHERS = 34509UL,
      FI_EN_BN_BENZINOL = 34510UL,
      FI_EN_BN_BEPON = 34511UL,
      FI_EN_BN_BERCA = 34512UL,
      FI_EN_BN_BERES_MULTICARS = 34513UL,
      FI_EN_BN_BERLINER_BANK = 34514UL,
      FI_EN_BN_BERLINER_SPARKASSE = 34515UL,
      FI_EN_BN_BERLINER_VOLKSBANK = 34516UL,
      FI_EN_BN_BERNARD_PHILIBERT = 34517UL,
      FI_EN_BN_BERNER_KANTONALBANK = 34518UL,
      FI_EN_BN_BERSHKA = 34519UL,
      FI_EN_BN_BERTUCCIS = 34520UL,
      FI_EN_BN_BES = 34521UL,
      FI_EN_BN_BEST_BUY = 34522UL,
      FI_EN_BN_BEST_LOVED = 34523UL,
      FI_EN_BN_BEST_OIL = 34524UL,
      FI_EN_BN_BEST_WESTERN_PREMIER = 34525UL,
      FI_EN_BN_BEST = 34526UL,
      FI_EN_BN_BETACAR = 34527UL,
      FI_EN_BN_BFC = 34528UL,
      FI_EN_BN_BG_BANK = 34529UL,
      FI_EN_BN_BGL = 34530UL,
      FI_EN_BN_BHARAT_CO_OP_BANK = 34531UL,
      FI_EN_BN_BHARAT_OVERSEAS_BANK = 34532UL,
      FI_EN_BN_BHARAT_PETROLEUM = 34533UL,
      FI_EN_BN_BHPETROL = 34534UL,
      FI_EN_BN_BHW = 34535UL,
      FI_EN_BN_BI_LO = 34536UL,
      FI_EN_BN_BIEDRONKA = 34537UL,
      FI_EN_BN_BIELEFELDER_VOLKSBANK = 34538UL,
      FI_EN_BN_BIG_10_TIRES = 34539UL,
      FI_EN_BN_BIG_BAZAAR = 34540UL,
      FI_EN_BN_BIG_BOY = 34541UL,
      FI_EN_BN_BIG_DOGS = 34542UL,
      FI_EN_BN_BIG_HORN_STEAK_HOUSE = 34543UL,
      FI_EN_BN_BIG_TOWN_HERO = 34544UL,
      FI_EN_BN_BIGMAT = 34545UL,
      FI_EN_BN_BILDERBERG = 34546UL,
      FI_EN_BN_BILDIRICI = 34547UL,
      FI_EN_BN_BILKA = 34548UL,
      FI_EN_BN_BILL_MILLER_BAR_B_Q = 34549UL,
      FI_EN_BN_BILLA = 34550UL,
      FI_EN_BN_BINBANK = 34551UL,
      FI_EN_BN_BIO_COMPANY = 34552UL,
      FI_EN_BN_BIPA = 34553UL,
      FI_EN_BN_BIPOP_CARIRE = 34554UL,
      FI_EN_BN_BIRMINGHAM_MIDSHIRES = 34555UL,
      FI_EN_BN_BISE = 34556UL,
      FI_EN_BN_BISTRO_ROMAIN = 34557UL,
      FI_EN_BN_BIVERBANCA = 34558UL,
      FI_EN_BN_BKCP = 34559UL,
      FI_EN_BN_BKS_BANK = 34560UL,
      FI_EN_BN_BLACK_ANGUS_STEAKHOUSE = 34561UL,
      FI_EN_BN_BLAKES_LOTABURGER = 34562UL,
      FI_EN_BN_BLENDERS_IN_THE_GRASS = 34563UL,
      FI_EN_BN_BLIMPIE = 34564UL,
      FI_EN_BN_BLISKA = 34565UL,
      FI_EN_BN_BLOKKER = 34566UL,
      FI_EN_BN_BLOMMERS_ICE_CREAM = 34567UL,
      FI_EN_BN_BLUE_BURRITO_GRILLE = 34568UL,
      FI_EN_BN_BLUE_CORAL_SEAFOOD_SPIRITS = 34569UL,
      FI_EN_BN_BLUE_MESA_GRILL = 34570UL,
      FI_EN_BN_BLUE_TREE = 34571UL,
      FI_EN_BN_BMCE = 34572UL,
      FI_EN_BN_BNL = 34573UL,
      FI_EN_BN_BNP_PARIBAS_FORTIS = 34574UL,
      FI_EN_BN_BNP_PARIBAS = 34575UL,
      FI_EN_BN_BOB_EVANS = 34576UL,
      FI_EN_BN_BOBS_STORES = 34577UL,
      FI_EN_BN_BOBS = 34578UL,
      FI_EN_BN_BOCATTA = 34579UL,
      FI_EN_BN_BOD = 34580UL,
      FI_EN_BN_BODEGA_AURRERA = 34581UL,
      FI_EN_BN_BODYTALK = 34582UL,
      FI_EN_BN_BOJANGLES = 34583UL,
      FI_EN_BN_BOLLE = 34584UL,
      FI_EN_BN_BOLOCO = 34585UL,
      FI_EN_BN_BOLWELL = 34586UL,
      FI_EN_BN_BOM_PRECO = 34587UL,
      FI_EN_BN_BOMBAY_MERCANTILE_CO_OP_BANK = 34588UL,
      FI_EN_BN_BOMI = 34589UL,
      FI_EN_BN_BONA_COMPRA = 34590UL,
      FI_EN_BN_BONANZA = 34591UL,
      FI_EN_BN_BONAREA = 34592UL,
      FI_EN_BN_BONEFISH_GRILL = 34593UL,
      FI_EN_BN_BONES = 34594UL,
      FI_EN_BN_BONITA = 34595UL,
      FI_EN_BN_BONPREU = 34596UL,
      FI_EN_BN_BON_TON = 34597UL,
      FI_EN_BN_BOOK_RACK = 34598UL,
      FI_EN_BN_BOOK_WORLD = 34599UL,
      FI_EN_BN_BOOKS_A_MILLION = 34600UL,
      FI_EN_BN_BOOSTER_JUICE = 34601UL,
      FI_EN_BN_BORDERS = 34602UL,
      FI_EN_BN_BOSCH_CAR_SERVICE = 34603UL,
      FI_EN_BN_BOSCOLO = 34604UL,
      FI_EN_BN_BOSTON_BEANERY = 34605UL,
      FI_EN_BN_BOSTON_MARKET = 34606UL,
      FI_EN_BN_BOSTON_PIZZA = 34607UL,
      FI_EN_BN_BOSTONS_RESTAURANT_SPORTS_BAR = 34608UL,
      FI_EN_BN_BOULANGER = 34609UL,
      FI_EN_BN_BOX = 34610UL,
      FI_EN_BN_BPET = 34611UL,
      FI_EN_BN_BPU_BANCA = 34612UL,
      FI_EN_BN_BR = 34613UL,
      FI_EN_BN_BRADESCO = 34614UL,
      FI_EN_BN_BRADFORD_BINGLEY = 34615UL,
      FI_EN_BN_BRAKES_PLUS = 34616UL,
      FI_EN_BN_BRAND_OIL = 34617UL,
      FI_EN_BN_BRANTANO = 34618UL,
      FI_EN_BN_BRASSERIES_FLO = 34619UL,
      FI_EN_BN_BRAUMS = 34620UL,
      FI_EN_BN_BRAUNEGGER = 34621UL,
      FI_EN_BN_BRD = 34622UL,
      FI_EN_BN_BRE_BANK_SA = 34623UL,
      FI_EN_BN_BRED = 34624UL,
      FI_EN_BN_BRETAGNE_MATERIAUX = 34625UL,
      FI_EN_BN_BRETECHE = 34626UL,
      FI_EN_BN_BRICK = 34627UL,
      FI_EN_BN_BRICO_DEPOT = 34628UL,
      FI_EN_BN_BRICO_PLAN_IT = 34629UL,
      FI_EN_BN_BRICO = 34630UL,
      FI_EN_BN_BRICOMARCHE = 34631UL,
      FI_EN_BN_BRISTOL_WEST = 34632UL,
      FI_EN_BN_BRIT_HOTEL = 34633UL,
      FI_EN_BN_BRIT = 34634UL,
      FI_EN_BN_BRITANNIA_BUILDING_SOCIETY = 34635UL,
      FI_EN_BN_BRITANNIA = 34636UL,
      FI_EN_BN_BROOKS_BROTHERS = 34637UL,
      FI_EN_BN_BROOKS_PHARMACY = 34638UL,
      FI_EN_BN_BROWNS = 34639UL,
      FI_EN_BN_BRUEGGERS = 34640UL,
      FI_EN_BN_BRUNA = 34641UL,
      FI_EN_BN_BRUNET = 34642UL,
      FI_EN_BN_BRUSTERS_REAL_ICE_CREAM = 34643UL,
      FI_EN_BN_BRYC = 34644UL,
      FI_EN_BN_BSB = 34645UL,
      FI_EN_BN_BSTDB = 34646UL,
      FI_EN_BN_BTV = 34647UL,
      FI_EN_BN_BUCA_DI_BEPPO = 34648UL,
      FI_EN_BN_BUCHBINDER = 34649UL,
      FI_EN_BN_BUDAPEST_BANK = 34650UL,
      FI_EN_BN_BUDGENS = 34651UL,
      FI_EN_BN_BUDGET_EXHAUST_TYRES = 34652UL,
      FI_EN_BN_BUDNIKOWSKI = 34653UL,
      FI_EN_BN_BUENO_PITTA = 34654UL,
      FI_EN_BN_BUFFALO_GRILL = 34655UL,
      FI_EN_BN_BUFFALO_WILD_WINGS = 34656UL,
      FI_EN_BN_BUFORI = 34657UL,
      FI_EN_BN_BUKVOED = 34658UL,
      FI_EN_BN_BUNNPRIS = 34659UL,
      FI_EN_BN_BUONA = 34660UL,
      FI_EN_BN_BUREAU_EN_GROS = 34661UL,
      FI_EN_BN_BURGER_KING = 34662UL,
      FI_EN_BN_BURGERLAND = 34663UL,
      FI_EN_BN_BURLEX = 34664UL,
      FI_EN_BN_BURLINGTON_SHOES = 34665UL,
      FI_EN_BN_BURN_OIL = 34666UL,
      FI_EN_BN_BURSA_ISKENDER = 34667UL,
      FI_EN_BN_BUSINESS_CAR_RENTAL = 34668UL,
      FI_EN_BN_BUT = 34669UL,
      FI_EN_BN_BW_BANK = 34670UL,
      FI_EN_BN_BWOC = 34671UL,
      FI_EN_BN_C_A = 34672UL,
      FI_EN_BN_C_C_SCHAPER = 34673UL,
      FI_EN_BN_C1000 = 34674UL,
      FI_EN_BN_CACTUS = 34675UL,
      FI_EN_BN_CAESARS = 34676UL,
      FI_EN_BN_CAFE_COFFEE_DAY = 34677UL,
      FI_EN_BN_CAFE_DU_BOUCHER = 34678UL,
      FI_EN_BN_CAFE_LEFFE = 34679UL,
      FI_EN_BN_CAFFE_NERO = 34680UL,
      FI_EN_BN_CAFFE_RITAZZA = 34681UL,
      FI_EN_BN_CAGDAS = 34682UL,
      FI_EN_BN_CAI = 34683UL,
      FI_EN_BN_CAISSE_DEPARGNE = 34684UL,
      FI_EN_BN_CAISSE_POPULAIRE_DESJARDINS = 34685UL,
      FI_EN_BN_CAIXA_ADVOCATS = 34686UL,
      FI_EN_BN_CAIXA_ALBALAT = 34687UL,
      FI_EN_BN_CAIXA_BENICARLO = 34688UL,
      FI_EN_BN_CAIXA_CALLOSA = 34689UL,
      FI_EN_BN_CAIXA_CATALUNYA = 34690UL,
      FI_EN_BN_CAIXA_DE_CREDITO_AGRICOLA = 34691UL,
      FI_EN_BN_CAIXA_DENGINYERS = 34692UL,
      FI_EN_BN_CAIXA_ECONOMICA_DA_MISERICORDIA = 34693UL,
      FI_EN_BN_CAIXA_GALICIA = 34694UL,
      FI_EN_BN_CAIXA_GERAL_DE_DEPOSITOS = 34695UL,
      FI_EN_BN_CAIXA_GERAL = 34696UL,
      FI_EN_BN_CAIXA_GIRONA = 34697UL,
      FI_EN_BN_CAIXA_LAIETANA = 34698UL,
      FI_EN_BN_CAIXA_MANLLEU = 34699UL,
      FI_EN_BN_CAIXA_MANRESA = 34700UL,
      FI_EN_BN_CAIXA_ONTINYENT = 34701UL,
      FI_EN_BN_CAIXA_PENEDES = 34702UL,
      FI_EN_BN_CAIXA_POPULAR = 34703UL,
      FI_EN_BN_CAIXA_RURAL_ALCORA = 34704UL,
      FI_EN_BN_CAIXA_RURAL_BALEARS = 34705UL,
      FI_EN_BN_CAIXA_RURAL_BURRIANA = 34706UL,
      FI_EN_BN_CAIXA_RURAL_DALGEMESI = 34707UL,
      FI_EN_BN_CAIXA_RURAL_GALEGA = 34708UL,
      FI_EN_BN_CAIXA_RURAL_LA_VALL = 34709UL,
      FI_EN_BN_CAIXA_RURAL_LES_COVES = 34710UL,
      FI_EN_BN_CAIXA_RURAL_NULES = 34711UL,
      FI_EN_BN_CAIXA_RURAL_SANT_VICENT = 34712UL,
      FI_EN_BN_CAIXA_RURAL_TORRENT = 34713UL,
      FI_EN_BN_CAIXA_RURAL_VILA_REAL = 34714UL,
      FI_EN_BN_CAIXA_RURAL_VILAVELLA = 34715UL,
      FI_EN_BN_CAIXA_RURAL = 34716UL,
      FI_EN_BN_CAIXA_SABADELL = 34717UL,
      FI_EN_BN_CAIXA_TARRAGONA = 34718UL,
      FI_EN_BN_CAIXA_TERRASSA = 34719UL,
      FI_EN_BN_CAIXA_VINAROS = 34720UL,
      FI_EN_BN_CAIXA = 34721UL,
      FI_EN_BN_CAIXACALLOSA = 34722UL,
      FI_EN_BN_CAIXALMASSORA = 34723UL,
      FI_EN_BN_CAIXALQUERIES = 34724UL,
      FI_EN_BN_CAIXALTEA = 34725UL,
      FI_EN_BN_CAIXANOVA = 34726UL,
      FI_EN_BN_CAIXAPETRER = 34727UL,
      FI_EN_BN_CAIXATERRASA = 34728UL,
      FI_EN_BN_CAJA_ABOGADOS = 34729UL,
      FI_EN_BN_CAJA_BADAJOZ = 34730UL,
      FI_EN_BN_CAJA_BURGOS = 34731UL,
      FI_EN_BN_CAJA_CAMINOS = 34732UL,
      FI_EN_BN_CAJA_CAMPO = 34733UL,
      FI_EN_BN_CAJA_CANARIAS = 34734UL,
      FI_EN_BN_CAJA_CANTABRIA = 34735UL,
      FI_EN_BN_CAJA_CIRCULO = 34736UL,
      FI_EN_BN_CAJA_DE_ARQUITECTOS = 34737UL,
      FI_EN_BN_CAJA_DE_AVILA = 34738UL,
      FI_EN_BN_CAJA_DE_BADAJOZ = 34739UL,
      FI_EN_BN_CAJA_DE_BURGOS = 34740UL,
      FI_EN_BN_CAJA_DE_EXTREMADURA = 34741UL,
      FI_EN_BN_CAJA_DE_GUADALAJARA = 34742UL,
      FI_EN_BN_CAJA_DE_INGENIEROS = 34743UL,
      FI_EN_BN_CAJA_DE_JAEN = 34744UL,
      FI_EN_BN_CAJA_DE_JAEN_2 = 34745UL,
      FI_EN_BN_CAJA_DUERO = 34746UL,
      FI_EN_BN_CAJA_ESPANA = 34747UL,
      FI_EN_BN_CAJA_GRANADA = 34748UL,
      FI_EN_BN_CAJA_IMMACULADA = 34749UL,
      FI_EN_BN_CAJA_LABORAL = 34750UL,
      FI_EN_BN_CAJA_MADRID = 34751UL,
      FI_EN_BN_CAJA_NAVARRA = 34752UL,
      FI_EN_BN_CAJA_RIOJA = 34753UL,
      FI_EN_BN_CAJA_RURAL_ALBAL = 34754UL,
      FI_EN_BN_CAJA_RURAL_ALMENARA = 34755UL,
      FI_EN_BN_CAJA_RURAL_BETXI = 34756UL,
      FI_EN_BN_CAJA_RURAL_BURGOS = 34757UL,
      FI_EN_BN_CAJA_RURAL_CASINOS = 34758UL,
      FI_EN_BN_CAJA_RURAL_CASTELLON = 34759UL,
      FI_EN_BN_CAJA_RURAL_CENTRAL = 34760UL,
      FI_EN_BN_CAJA_RURAL_CHILCHES = 34761UL,
      FI_EN_BN_CAJA_RURAL_CORDOBA = 34762UL,
      FI_EN_BN_CAJA_RURAL_DE_ALBACETE = 34763UL,
      FI_EN_BN_CAJA_RURAL_DE_ALGINET = 34764UL,
      FI_EN_BN_CAJA_RURAL_DE_ASTURIAS = 34765UL,
      FI_EN_BN_CAJA_RURAL_DE_BAENA = 34766UL,
      FI_EN_BN_CAJA_RURAL_DE_CANARIAS = 34767UL,
      FI_EN_BN_CAJA_RURAL_DE_CANETE = 34768UL,
      FI_EN_BN_CAJA_RURAL_DE_CASAS_IBANEZ = 34769UL,
      FI_EN_BN_CAJA_RURAL_DE_CHESTE = 34770UL,
      FI_EN_BN_CAJA_RURAL_DE_CIUDAD_REAL = 34771UL,
      FI_EN_BN_CAJA_RURAL_DE_CUENCA = 34772UL,
      FI_EN_BN_CAJA_RURAL_DE_FUENTEPELAYO = 34773UL,
      FI_EN_BN_CAJA_RURAL_DE_GIJON = 34774UL,
      FI_EN_BN_CAJA_RURAL_DE_GRANADA = 34775UL,
      FI_EN_BN_CAJA_RURAL_DE_LA_RODA = 34776UL,
      FI_EN_BN_CAJA_RURAL_DE_MOTA_DEL_CUERVO = 34777UL,
      FI_EN_BN_CAJA_RURAL_DE_NAVARRA = 34778UL,
      FI_EN_BN_CAJA_RURAL_DE_ONDA = 34779UL,
      FI_EN_BN_CAJA_RURAL_DE_SALAMANCA = 34780UL,
      FI_EN_BN_CAJA_RURAL_DE_SEGOVIA = 34781UL,
      FI_EN_BN_CAJA_RURAL_DE_SORIA = 34782UL,
      FI_EN_BN_CAJA_RURAL_DE_TERUEL = 34783UL,
      FI_EN_BN_CAJA_RURAL_DE_TOLEDO = 34784UL,
      FI_EN_BN_CAJA_RURAL_DE_UTRERA = 34785UL,
      FI_EN_BN_CAJA_RURAL_DE_VILLAMALEA = 34786UL,
      FI_EN_BN_CAJA_RURAL_DEL_DUERO = 34787UL,
      FI_EN_BN_CAJA_RURAL_JAEN = 34788UL,
      FI_EN_BN_CAJA_RURAL_NUEVA_CARTEYA = 34789UL,
      FI_EN_BN_CAJA_RURAL_REGIONAL = 34790UL,
      FI_EN_BN_CAJA_RURAL_VILAFAMES = 34791UL,
      FI_EN_BN_CAJA_RURAL = 34792UL,
      FI_EN_BN_CAJA_SAN_FERNANDO = 34793UL,
      FI_EN_BN_CAJA_SEGOVIA = 34794UL,
      FI_EN_BN_CAJA_VITAL_KUTXA = 34795UL,
      FI_EN_BN_CAJALMENDRALEJO = 34796UL,
      FI_EN_BN_CAJALON = 34797UL,
      FI_EN_BN_CAJAMAR = 34798UL,
      FI_EN_BN_CAJAMURCIA = 34799UL,
      FI_EN_BN_CAJASIETE = 34800UL,
      FI_EN_BN_CAJASOL = 34801UL,
      FI_EN_BN_CAJASTUR = 34802UL,
      FI_EN_BN_CAJASUR = 34803UL,
      FI_EN_BN_CALIFORNIA_BANK_TRUST = 34804UL,
      FI_EN_BN_CALIFORNIA_CHICKEN_CAFE = 34805UL,
      FI_EN_BN_CALIFORNIA_NATIONAL_BANK = 34806UL,
      FI_EN_BN_CALIFORNIA_PIZZA_KITCHEN = 34807UL,
      FI_EN_BN_CALIFORNIA_TORTILLA = 34808UL,
      FI_EN_BN_CALIFORNIA = 34809UL,
      FI_EN_BN_CALISER = 34810UL,
      FI_EN_BN_CAM = 34811UL,
      FI_EN_BN_CAMBRIA_SUITES = 34812UL,
      FI_EN_BN_CAMBRIDGE_BUILDING_SOCIETY = 34813UL,
      FI_EN_BN_CAMPUS = 34814UL,
      FI_EN_BN_CAN = 34815UL,
      FI_EN_BN_CANADAS_BEST_VALUE_INN = 34816UL,
      FI_EN_BN_CANADIAN_WESTERN_BANK = 34817UL,
      FI_EN_BN_CANARA_BANK = 34818UL,
      FI_EN_BN_CANARIAS = 34819UL,
      FI_EN_BN_CANDLEWOOD_SUITES = 34820UL,
      FI_EN_BN_CANTINA_LAREDO = 34821UL,
      FI_EN_BN_CAPITAL_BANK = 34822UL,
      FI_EN_BN_CAPITAL_CITY_BANK = 34823UL,
      FI_EN_BN_CAPITALIA = 34824UL,
      FI_EN_BN_CAPITEC_BANK = 34825UL,
      FI_EN_BN_CAPITOL = 34826UL,
      FI_EN_BN_CAPRABO = 34827UL,
      FI_EN_BN_CAPSIS_HOTELS = 34828UL,
      FI_EN_BN_CAPTAIN_DS = 34829UL,
      FI_EN_BN_CAR_MEDIC = 34830UL,
      FI_EN_BN_CAR_RENTAL_BULGARIA = 34831UL,
      FI_EN_BN_CAR_CONDAL = 34832UL,
      FI_EN_BN_CARESTEL = 34833UL,
      FI_EN_BN_CARGLASS = 34834UL,
      FI_EN_BN_CARGO = 34835UL,
      FI_EN_BN_CARIBOU_COFFEE = 34836UL,
      FI_EN_BN_CARICHIETI = 34837UL,
      FI_EN_BN_CARIFAC = 34838UL,
      FI_EN_BN_CARIFANO = 34839UL,
      FI_EN_BN_CARIFERMO = 34840UL,
      FI_EN_BN_CARINOS_ITALIAN_GRILL = 34841UL,
      FI_EN_BN_CARIPARMA_PIACENZA = 34842UL,
      FI_EN_BN_CARIPE = 34843UL,
      FI_EN_BN_CARIPLO = 34844UL,
      FI_EN_BN_CARIPRATO = 34845UL,
      FI_EN_BN_CARISBO = 34846UL,
      FI_EN_BN_CARLOS_OKELLYS_MEXICAN_CAFE = 34847UL,
      FI_EN_BN_CARLS_JR = 34848UL,
      FI_EN_BN_CAROIL = 34849UL,
      FI_EN_BN_CARPARK = 34850UL,
      FI_EN_BN_CARPET_RIGHT = 34851UL,
      FI_EN_BN_CARQUEST = 34852UL,
      FI_EN_BN_CARRABBAS_ITALIAN_GRILL = 34853UL,
      FI_EN_BN_CARREFOUR_CITY = 34854UL,
      FI_EN_BN_CARREFOUR_EXPRESS = 34855UL,
      FI_EN_BN_CARREFOUR_MARKET = 34856UL,
      FI_EN_BN_CARROWS = 34857UL,
      FI_EN_BN_CARVEL = 34858UL,
      FI_EN_BN_CASA = 34859UL,
      FI_EN_BN_CASEYS_GENERAL_STORE = 34860UL,
      FI_EN_BN_CASH_RECORD = 34861UL,
      FI_EN_BN_CASH4YOU = 34862UL,
      FI_EN_BN_CASINO_CAFETERIA = 34863UL,
      FI_EN_BN_CASSA_DI_RISP_DI_VR_VI_BL_AN = 34864UL,
      FI_EN_BN_CASSA_DI_RISPARMIO_DELLA_SPEZIA = 34865UL,
      FI_EN_BN_CASSA_DI_RISPARMIO_DI_ASTI = 34866UL,
      FI_EN_BN_CASSA_DI_RISPARMIO_DI_BOLOGNA = 34867UL,
      FI_EN_BN_CASSA_DI_RISPARMIO_DI_CESENA = 34868UL,
      FI_EN_BN_CASSA_DI_RISPARMIO_DI_FERRARA = 34869UL,
      FI_EN_BN_CASSA_DI_RISPARMIO_DI_FIRENZE = 34870UL,
      FI_EN_BN_CASSA_DI_RISPARMIO_DI_FORLI = 34871UL,
      FI_EN_BN_CASSA_DI_RISPARMIO_DI_IMOLA = 34872UL,
      FI_EN_BN_CASSA_DI_RISPARMIO_DI_LORETO = 34873UL,
      FI_EN_BN_CASSA_DI_RISPARMIO_DI_LUCCA = 34874UL,
      FI_EN_BN_CASSA_DI_RISPARMIO_DI_RAVENNA = 34875UL,
      FI_EN_BN_CASSA_DI_RISPARMIO_DI_RIETI = 34876UL,
      FI_EN_BN_CASSA_DI_RISPARMIO_DI_RIMINI = 34877UL,
      FI_EN_BN_CASSA_DI_RISPARMIO_DI_SAN_MINIATO = 34878UL,
      FI_EN_BN_CASSA_DI_RISPARMIO_PADOVA_E_ROVIGO = 34879UL,
      FI_EN_BN_CASSA_DI_RISPARMIO_PARMA_E_PIACENZA = 34880UL,
      FI_EN_BN_CASSA_RISP_DELLA_PROV_DELLAQUILA = 34881UL,
      FI_EN_BN_CASTELLO_LOPES = 34882UL,
      FI_EN_BN_CASTORAMA = 34883UL,
      FI_EN_BN_CASTROL = 34884UL,
      FI_EN_BN_CASUAL_MALE = 34885UL,
      FI_EN_BN_CATALONIA = 34886UL,
      FI_EN_BN_CATHAY_BANK = 34887UL,
      FI_EN_BN_CATHERINES = 34888UL,
      FI_EN_BN_CATHOLIC_SYRIAN_BANK = 34889UL,
      FI_EN_BN_CATO = 34890UL,
      FI_EN_BN_CBA = 34891UL,
      FI_EN_BN_CBC = 34892UL,
      FI_EN_BN_CC_BANK = 34893UL,
      FI_EN_BN_CCF = 34894UL,
      FI_EN_BN_CCM = 34895UL,
      FI_EN_BN_CCMONAGAS = 34896UL,
      FI_EN_BN_CCS_COFFEE_HOUSE = 34897UL,
      FI_EN_BN_CEC_BANK = 34898UL,
      FI_EN_BN_CECA = 34899UL,
      FI_EN_BN_CEDEO = 34900UL,
      FI_EN_BN_CELIKLER = 34901UL,
      FI_EN_BN_CENTAURO = 34902UL,
      FI_EN_BN_CENTEA = 34903UL,
      FI_EN_BN_CENTIMETER = 34904UL,
      FI_EN_BN_CENTRA = 34905UL,
      FI_EN_BN_CENTRAL_BANCO_UNIVERSAL = 34906UL,
      FI_EN_BN_CENTRAL_BANK_OF_INDIA = 34907UL,
      FI_EN_BN_CENTRAL_CHENNAI_CO_OP_BANK = 34908UL,
      FI_EN_BN_CENTRAL_COOPERATIVE_BANK = 34909UL,
      FI_EN_BN_CENTRAL_MADEIRENSE = 34910UL,
      FI_EN_BN_CENTRAL_TYRE = 34911UL,
      FI_EN_BN_CENTRAL = 34912UL,
      FI_EN_BN_CENTURION_BANK = 34913UL,
      FI_EN_BN_CENTURY_BANK = 34914UL,
      FI_EN_BN_CEPSA = 34915UL,
      FI_EN_BN_CERTIGARD = 34916UL,
      FI_EN_BN_CESKA_NARODNI_BANKA = 34917UL,
      FI_EN_BN_CESKA_SPORITELNA = 34918UL,
      FI_EN_BN_CESKOMORAVSKA_STAVEBNI_SPORITELNA = 34919UL,
      FI_EN_BN_CETELEM = 34920UL,
      FI_EN_BN_CHALKIADAKIS = 34921UL,
      FI_EN_BN_CHAMPION_MARINOPOULOS = 34922UL,
      FI_EN_BN_CHAMPPS = 34923UL,
      FI_EN_BN_CHAMPS_SPORTS = 34924UL,
      FI_EN_BN_CHANDRIS_HOTELS_RESORTS = 34925UL,
      FI_EN_BN_CHANELLOS_PIZZA = 34926UL,
      FI_EN_BN_CHAPTERS = 34927UL,
      FI_EN_BN_CHARLES_SCHWAB_CORP = 34928UL,
      FI_EN_BN_CHARLEYS = 34929UL,
      FI_EN_BN_CHARLOTTE_RUSSE = 34930UL,
      FI_EN_BN_CHART_HOUSE = 34931UL,
      FI_EN_BN_CHARTER_ONE_BANK = 34932UL,
      FI_EN_BN_CHARTER = 34933UL,
      FI_EN_BN_CHASE = 34934UL,
      FI_EN_BN_CHATEAU_DAX = 34935UL,
      FI_EN_BN_CHATEAUX_ET_HOTELS_COLLECTION = 34936UL,
      FI_EN_BN_CHAYNAYA_LOZHKA = 34937UL,
      FI_EN_BN_CHECKER_AUTO_PARTS = 34938UL,
      FI_EN_BN_CHECKERS = 34939UL,
      FI_EN_BN_CHEDDARS = 34940UL,
      FI_EN_BN_CHEDRAUI = 34941UL,
      FI_EN_BN_CHEEBURGER_CHEEBURGER = 34942UL,
      FI_EN_BN_CHEESEBURGER_IN_PARADISE = 34943UL,
      FI_EN_BN_CHEESECAKE_FACTORY = 34944UL,
      FI_EN_BN_CHELSEA_BUILDING_SOCIETY = 34945UL,
      FI_EN_BN_CHELTENHAM_GLOUCESTER = 34946UL,
      FI_EN_BN_CHEMICAL_BANK = 34947UL,
      FI_EN_BN_CHENNAI_CENTRAL_CO_OP_BANK = 34948UL,
      FI_EN_BN_CHENNAI_CORPORATION_CO_OP_BANK = 34949UL,
      FI_EN_BN_CHERY = 34950UL,
      FI_EN_BN_CHESHIRE_BUILDING_SOCIETY = 34951UL,
      FI_EN_BN_CHESTERS = 34952UL,
      FI_EN_BN_CHEVYS = 34953UL,
      FI_EN_BN_CHI_CHIS = 34954UL,
      FI_EN_BN_CHICKEN_DELIGHT = 34955UL,
      FI_EN_BN_CHICKEN_EXPRESS = 34956UL,
      FI_EN_BN_CHICKEN_KITCHEN = 34957UL,
      FI_EN_BN_CHICKEN_LICKEN = 34958UL,
      FI_EN_BN_CHICKEN_TIKKA = 34959UL,
      FI_EN_BN_CHICK_FIL_A = 34960UL,
      FI_EN_BN_CHICOS_ALL_AMERICAN_BISTRO = 34961UL,
      FI_EN_BN_CHICOS_RESTAURANT = 34962UL,
      FI_EN_BN_CHILDRENS_PLACE = 34963UL,
      FI_EN_BN_CHILIS_GRILL_BAR = 34964UL,
      FI_EN_BN_CHILO = 34965UL,
      FI_EN_BN_CHIMARRAO = 34966UL,
      FI_EN_BN_CHIMARRAO_2 = 34967UL,
      FI_EN_BN_CHINA_BUFFET = 34968UL,
      FI_EN_BN_CHINA_COAST = 34969UL,
      FI_EN_BN_CHINA_EAST = 34970UL,
      FI_EN_BN_CHINA_EXPRESS = 34971UL,
      FI_EN_BN_CHINA_GARDEN = 34972UL,
      FI_EN_BN_CHINA_HOUSE = 34973UL,
      FI_EN_BN_CHINA_TRUST_COMMERCIAL_BANK = 34974UL,
      FI_EN_BN_CHINS = 34975UL,
      FI_EN_BN_CHIP_7 = 34976UL,
      FI_EN_BN_CHIPOTLE = 34977UL,
      FI_EN_BN_CHIPS_AWAY = 34978UL,
      FI_EN_BN_CHLOPSKIE_JADLO = 34979UL,
      FI_EN_BN_CHRISTIAN_BROTHERS_AUTOMOTIVE = 34980UL,
      FI_EN_BN_CHRISTOPHER_BANKS = 34981UL,
      FI_EN_BN_CHUCK_E_CHEESES = 34982UL,
      FI_EN_BN_CHURCHS_CHICKEN = 34983UL,
      FI_EN_BN_CIAO = 34984UL,
      FI_EN_BN_CIB_BANK = 34985UL,
      FI_EN_BN_CIBC = 34986UL,
      FI_EN_BN_CIC = 34987UL,
      FI_EN_BN_CICAR = 34988UL,
      FI_EN_BN_CICIS_PIZZA = 34989UL,
      FI_EN_BN_CINELANDIA = 34990UL,
      FI_EN_BN_CINEMA_CITY = 34991UL,
      FI_EN_BN_CINEMAPLEXX = 34992UL,
      FI_EN_BN_CINEMARK = 34993UL,
      FI_EN_BN_CINEMAX = 34994UL,
      FI_EN_BN_CINEPLEX = 34995UL,
      FI_EN_BN_CINEPOLIS = 34996UL,
      FI_EN_BN_CINESA = 34997UL,
      FI_EN_BN_CINEWORLD = 34998UL,
      FI_EN_BN_CINNABON = 34999UL,
      FI_EN_BN_CIRCUIT_CITY = 35000UL,
      FI_EN_BN_CIRCUS = 35001UL,
      FI_EN_BN_CITADINES_APART_HOTEL = 35002UL,
      FI_EN_BN_CITI_FINANCIAL = 35003UL,
      FI_EN_BN_CITIZEN_CREDIT_CO_OP_BANK = 35004UL,
      FI_EN_BN_CITIZENS_BANK_TRUST = 35005UL,
      FI_EN_BN_CITIZENS_BANK = 35006UL,
      FI_EN_BN_CITY_BITES = 35007UL,
      FI_EN_BN_CITY_BLENDS = 35008UL,
      FI_EN_BN_CITY_DELHAIZE = 35009UL,
      FI_EN_BN_CITY_FINANCIAL = 35010UL,
      FI_EN_BN_CITY_GROSS = 35011UL,
      FI_EN_BN_CITY_HANDLOWY = 35012UL,
      FI_EN_BN_CITY_LODGE = 35013UL,
      FI_EN_BN_CITY_MARKT = 35014UL,
      FI_EN_BN_CITY_PARK_HOTELS = 35015UL,
      FI_EN_BN_CITY_PARKING = 35016UL,
      FI_EN_BN_CITY_UNION_BANK = 35017UL,
      FI_EN_BN_CJ_BANKS = 35018UL,
      FI_EN_BN_CKP_CO_OPERATIVE_BANK = 35019UL,
      FI_EN_BN_CLAIM_JUMPER = 35020UL,
      FI_EN_BN_CLAIRES = 35021UL,
      FI_EN_BN_CLARION_HOTEL = 35022UL,
      FI_EN_BN_CLARK = 35023UL,
      FI_EN_BN_CLARKS = 35024UL,
      FI_EN_BN_CLASSICAL_HOTELS = 35025UL,
      FI_EN_BN_CLEAN_CAR = 35026UL,
      FI_EN_BN_CLIENTIS = 35027UL,
      FI_EN_BN_CLUB_MED = 35028UL,
      FI_EN_BN_CLYDESDALE_BANK = 35029UL,
      FI_EN_BN_CMH = 35030UL,
      FI_EN_BN_CNG = 35031UL,
      FI_EN_BN_CO_BIGELOW = 35032UL,
      FI_EN_BN_COACH = 35033UL,
      FI_EN_BN_COALIMENT = 35034UL,
      FI_EN_BN_COALVE = 35035UL,
      FI_EN_BN_COCCIMARKET = 35036UL,
      FI_EN_BN_COCOS = 35037UL,
      FI_EN_BN_CODI = 35038UL,
      FI_EN_BN_COFFE_CO = 35039UL,
      FI_EN_BN_THE_COFFEE_BEAN_TEA_LEAF = 35040UL,
      FI_EN_BN_COFFEE_BEANERY = 35041UL,
      FI_EN_BN_COFFEE_HOUSE = 35042UL,
      FI_EN_BN_COFFEE_REPUBLIC = 35043UL,
      FI_EN_BN_COFFEE_TIME = 35044UL,
      FI_EN_BN_COFFEE_WORLD = 35045UL,
      FI_EN_BN_COLD_STONE_CREAMERY = 35046UL,
      FI_EN_BN_COLDWATER_CREEK = 35047UL,
      FI_EN_BN_COLE_HAAN = 35048UL,
      FI_EN_BN_COLE_MUFFLER = 35049UL,
      FI_EN_BN_COLES = 35050UL,
      FI_EN_BN_COLMAR = 35051UL,
      FI_EN_BN_COLONYA_CAIXA_POLLENCA = 35052UL,
      FI_EN_BN_COLRUYT = 35053UL,
      FI_EN_BN_COLTERS_TEXAS_BAR_B_Q = 35054UL,
      FI_EN_BN_COMERCIAL_MEXICANA = 35055UL,
      FI_EN_BN_COMERICA = 35056UL,
      FI_EN_BN_COMET = 35057UL,
      FI_EN_BN_COMFORT_SUITES = 35058UL,
      FI_EN_BN_COMMERZBANK = 35059UL,
      FI_EN_BN_COMMERZIALBANK = 35060UL,
      FI_EN_BN_COMMONWEALTH_BANK = 35061UL,
      FI_EN_BN_COMPRABENE = 35062UL,
      FI_EN_BN_COMPRE_BEM = 35063UL,
      FI_EN_BN_COMPREBEM = 35064UL,
      FI_EN_BN_COMPRO_QUI = 35065UL,
      FI_EN_BN_COMPUTER_CITY = 35066UL,
      FI_EN_BN_CONAD = 35067UL,
      FI_EN_BN_CONDIS = 35068UL,
      FI_EN_BN_CONFORAMA = 35069UL,
      FI_EN_BN_CONOIL = 35070UL,
      FI_EN_BN_CONRAD = 35071UL,
      FI_EN_BN_CONSAD_CITY = 35072UL,
      FI_EN_BN_CONSUM = 35073UL,
      FI_EN_BN_CONTACT_GB = 35074UL,
      FI_EN_BN_CONTINENTAL_FORUM_HOTELS = 35075UL,
      FI_EN_BN_CONTINENTAL_HOTELS = 35076UL,
      FI_EN_BN_CONTINENTE = 35077UL,
      FI_EN_BN_COOL_RIVER = 35078UL,
      FI_EN_BN_COOP_BAU_HOBBY = 35079UL,
      FI_EN_BN_COOP_CITY = 35080UL,
      FI_EN_BN_COOP_EXTRA = 35081UL,
      FI_EN_BN_COOP_FORUM = 35082UL,
      FI_EN_BN_COOP_KONSUM = 35083UL,
      FI_EN_BN_COOP_NAERA = 35084UL,
      FI_EN_BN_COOP_PRONTO = 35085UL,
      FI_EN_BN_COOP_RESTAURANT = 35086UL,
      FI_EN_BN_COOP_VITALITY_APOTHEKE = 35087UL,
      FI_EN_BN_COOP = 35088UL,
      FI_EN_BN_CO_OP = 35089UL,
      FI_EN_BN_CO_OPERATIVE_BANK = 35090UL,
      FI_EN_BN_COPEC = 35091UL,
      FI_EN_BN_CORAL_HOTELS_AND_RESORTS = 35092UL,
      FI_EN_BN_CORALIA_CLUB = 35093UL,
      FI_EN_BN_CORNER_BAKERY_CAFE = 35094UL,
      FI_EN_BN_CORP_BANCA = 35095UL,
      FI_EN_BN_CORPBANCA = 35096UL,
      FI_EN_BN_CORPORATE_COMMERCIAL_BANK = 35097UL,
      FI_EN_BN_CORPORATION_BANK = 35098UL,
      FI_EN_BN_CORSALYS = 35099UL,
      FI_EN_BN_CORUS = 35100UL,
      FI_EN_BN_CORVETTE = 35101UL,
      FI_EN_BN_COSI = 35102UL,
      FI_EN_BN_COSMOS = 35103UL,
      FI_EN_BN_COSTA_COFFEE = 35104UL,
      FI_EN_BN_COSTCO = 35105UL,
      FI_EN_BN_COSTCUTTER = 35106UL,
      FI_EN_BN_COTO = 35107UL,
      FI_EN_BN_COTTAGE_INN_PIZZA = 35108UL,
      FI_EN_BN_COTTON_GINNY = 35109UL,
      FI_EN_BN_COUCHE_TARD = 35110UL,
      FI_EN_BN_COUNTRY_INN_SUITES_BY_CARLSON = 35111UL,
      FI_EN_BN_COUNTRY_INN = 35112UL,
      FI_EN_BN_COUNTRY_KITCHEN = 35113UL,
      FI_EN_BN_COUNTRY_STYLE = 35114UL,
      FI_EN_BN_COUNTRYSIDE_HOTELS = 35115UL,
      FI_EN_BN_COURTEPAILLE = 35116UL,
      FI_EN_BN_COURTHEOUX = 35117UL,
      FI_EN_BN_COUSINS = 35118UL,
      FI_EN_BN_COVENTRY_BUILDING_SOCIETY = 35119UL,
      FI_EN_BN_COVIRAN = 35120UL,
      FI_EN_BN_COZYMELS_MEXICAN_GRILL = 35121UL,
      FI_EN_BN_CPH = 35122UL,
      FI_EN_BN_CPHM = 35123UL,
      FI_EN_BN_CR_CHICKS = 35124UL,
      FI_EN_BN_CRACKER_BARREL_OLD_COUNTRY_STORE = 35125UL,
      FI_EN_BN_CRAI = 35126UL,
      FI_EN_BN_CRATE_BARREL = 35127UL,
      FI_EN_BN_CRAZY_BOWLS_WRAPS = 35128UL,
      FI_EN_BN_CREDEM = 35129UL,
      FI_EN_BN_CREDI_VENETO = 35130UL,
      FI_EN_BN_CREDIT_AGRICOLE = 35131UL,
      FI_EN_BN_CREDIT_COOPERATIF = 35132UL,
      FI_EN_BN_CREDIT_DU_NORD = 35133UL,
      FI_EN_BN_CREDIT_FONCIER = 35134UL,
      FI_EN_BN_CREDIT_MARITIME = 35135UL,
      FI_EN_BN_CREDIT_MUTUEL = 35136UL,
      FI_EN_BN_CREDIT_POSITIVE_BANK = 35137UL,
      FI_EN_BN_CREDIT_SUISSE = 35138UL,
      FI_EN_BN_CREDIT = 35139UL,
      FI_EN_BN_CREDITO_AGRICOLA = 35140UL,
      FI_EN_BN_CREDITO_ARTIGIANO = 35141UL,
      FI_EN_BN_CREDITO_BERGAMASCO = 35142UL,
      FI_EN_BN_CREDITO_COOPERATIVO = 35143UL,
      FI_EN_BN_CREDITO_EMILIANO = 35144UL,
      FI_EN_BN_CREDITO_SICILIANO = 35145UL,
      FI_EN_BN_CREDITO_VALTELLINESE = 35146UL,
      FI_EN_BN_CREDITO_VERONESE = 35147UL,
      FI_EN_BN_CREDITPLUS_BANK = 35148UL,
      FI_EN_BN_CRISPERS = 35149UL,
      FI_EN_BN_CROWN_FRIED_CHICKEN = 35150UL,
      FI_EN_BN_CROWNE_PLAZA_HOTEL = 35151UL,
      FI_EN_BN_CROWNE_PLAZA_RESORT = 35152UL,
      FI_EN_BN_CROWNE_PLAZA_SUITES = 35153UL,
      FI_EN_BN_CRUZ_VERDE = 35154UL,
      FI_EN_BN_CSOB = 35155UL,
      FI_EN_BN_CUB_FOODS = 35156UL,
      FI_EN_BN_CULVERS = 35157UL,
      FI_EN_BN_CUMBERLAND_BUILDING_SOCIETY = 35158UL,
      FI_EN_BN_CURRYS = 35159UL,
      FI_EN_BN_CURRYSDIGITAL = 35160UL,
      FI_EN_BN_CVS_PHARMACY = 35161UL,
      FI_EN_BN_CZECHOCAR_CS = 35162UL,
      FI_EN_BN_D_MART = 35163UL,
      FI_EN_BN_D_W_FOOD_CENTERS = 35164UL,
      FI_EN_BN_D_X = 35165UL,
      FI_EN_BN_DACIA = 35166UL,
      FI_EN_BN_DAECKIA = 35167UL,
      FI_EN_BN_DADDIOS_TAKE_BAKE = 35168UL,
      FI_EN_BN_DADI = 35169UL,
      FI_EN_BN_DAGLIBRUGSEN = 35170UL,
      FI_EN_BN_DAGOSTINO_SUPERMARKET = 35171UL,
      FI_EN_BN_DAIRY_BELLE = 35172UL,
      FI_EN_BN_DAIRY_QUEEN = 35173UL,
      FI_EN_BN_DAISY_MART = 35174UL,
      FI_EN_BN_DAMLA_PETROL = 35175UL,
      FI_EN_BN_DAMONS_GRILL = 35176UL,
      FI_EN_BN_DAN_DOOLEY = 35177UL,
      FI_EN_BN_DANGELO = 35178UL,
      FI_EN_BN_DANIER_LEATHER = 35179UL,
      FI_EN_BN_DAENISCHES_BETTENLAGER = 35180UL,
      FI_EN_BN_DANSKE_BANK = 35181UL,
      FI_EN_BN_DAPHNES_GREEK_CAFE = 35182UL,
      FI_EN_BN_DARTY = 35183UL,
      FI_EN_BN_DAS_BIERHAUS = 35184UL,
      FI_EN_BN_DATS_24 = 35185UL,
      FI_EN_BN_DATS = 35186UL,
      FI_EN_BN_DAVE_BUSTERS = 35187UL,
      FI_EN_BN_DAYJET = 35188UL,
      FI_EN_BN_DAYLIGHT_DONUTS = 35189UL,
      FI_EN_BN_DB_CARSHARING = 35190UL,
      FI_EN_BN_DBANK = 35191UL,
      FI_EN_BN_DCB_BANK = 35192UL,
      FI_EN_BN_DDS_DISCOUNTS = 35193UL,
      FI_EN_BN_DE_HISTORISKE = 35194UL,
      FI_EN_BN_DE_MADRID = 35195UL,
      FI_EN_BN_DEBONAIRS_PIZZA = 35196UL,
      FI_EN_BN_DECA = 35197UL,
      FI_EN_BN_DECATHLON = 35198UL,
      FI_EN_BN_DEDEMAN_HOTELS_RESORTS = 35199UL,
      FI_EN_BN_DEEN_SUPERMARKTEN = 35200UL,
      FI_EN_BN_DEFOIL = 35201UL,
      FI_EN_BN_DEGUSSA_BANK = 35202UL,
      FI_EN_BN_DEICHMANN = 35203UL,
      FI_EN_BN_DEKAMARKT = 35204UL,
      FI_EN_BN_DEL_RIO = 35205UL,
      FI_EN_BN_DEL_SUR = 35206UL,
      FI_EN_BN_DEL_TACO = 35207UL,
      FI_EN_BN_DELHAIZE = 35208UL,
      FI_EN_BN_DELHI_STATE_CO_OP_BANK = 35209UL,
      FI_EN_BN_DELIAS = 35210UL,
      FI_EN_BN_DELKA = 35211UL,
      FI_EN_BN_DELTA_LLOYD = 35212UL,
      FI_EN_BN_DEMA = 35213UL,
      FI_EN_BN_DENA_BANK = 35214UL,
      FI_EN_BN_DENIZBANK = 35215UL,
      FI_EN_BN_DENNER = 35216UL,
      FI_EN_BN_DENNYS = 35217UL,
      FI_EN_BN_DENZELDRIVE = 35218UL,
      FI_EN_BN_DER_MANN = 35219UL,
      FI_EN_BN_DERAG = 35220UL,
      FI_EN_BN_DERANG_PLUS = 35221UL,
      FI_EN_BN_DERBY_HOTELS = 35222UL,
      FI_EN_BN_DERBYSHIRE_BUILDING_SOCIETY = 35223UL,
      FI_EN_BN_DESERT_MOON = 35224UL,
      FI_EN_BN_DESIGN_HOTELS = 35225UL,
      FI_EN_BN_DESPAR = 35226UL,
      FI_EN_BN_DEUTSCHE_APOTHEKER_UND_AERZTEBANK = 35227UL,
      FI_EN_BN_DEUTSCHE_BANK = 35228UL,
      FI_EN_BN_DEUTSCHE_KREDITBANK_AG = 35229UL,
      FI_EN_BN_DEVELOPMENT_CREDIT_BANK = 35230UL,
      FI_EN_BN_DEVERE = 35231UL,
      FI_EN_BN_DEXIA = 35232UL,
      FI_EN_BN_DEZELNA_BANKA_SLOVENIJE = 35233UL,
      FI_EN_BN_DHANALAKSHMI_BANK = 35234UL,
      FI_EN_BN_DHB = 35235UL,
      FI_EN_BN_DI_PER_DI = 35236UL,
      FI_EN_BN_DI = 35237UL,
      FI_EN_BN_DIA = 35238UL,
      FI_EN_BN_DIAGONAL_HOTELS = 35239UL,
      FI_EN_BN_DIALPRIX = 35240UL,
      FI_EN_BN_DIAMOND_AUTO_GLASS = 35241UL,
      FI_EN_BN_DIAMOND_BANK = 35242UL,
      FI_EN_BN_DICK_SMITH = 35243UL,
      FI_EN_BN_DICKEYS_BARBECUE_PIT = 35244UL,
      FI_EN_BN_DICKS_SPORTING_GOODS = 35245UL,
      FI_EN_BN_DICO = 35246UL,
      FI_EN_BN_DIFFERENT_TWIST_PRETZEL_CO = 35247UL,
      FI_EN_BN_DIGROS = 35248UL,
      FI_EN_BN_DIKSI = 35249UL,
      FI_EN_BN_DILLARDS = 35250UL,
      FI_EN_BN_DIME_SAVINGS_BANK = 35251UL,
      FI_EN_BN_DIMEGLIO = 35252UL,
      FI_EN_BN_DINAZ = 35253UL,
      FI_EN_BN_DINEROEXPRESS = 35254UL,
      FI_EN_BN_DINNERS = 35255UL,
      FI_EN_BN_DIONISOS = 35256UL,
      FI_EN_BN_DIRK_VAN_DEN_BROEK = 35257UL,
      FI_EN_BN_DISCO = 35258UL,
      FI_EN_BN_DISCOUNT_TIRE = 35259UL,
      FI_EN_BN_DISCOUNT = 35260UL,
      FI_EN_BN_DISGOR = 35261UL,
      FI_EN_BN_DISNEYLAND_RESORT_PARIS = 35262UL,
      FI_EN_BN_DISPORT = 35263UL,
      FI_EN_BN_DISPREU = 35264UL,
      FI_EN_BN_DIVANIS_CHAIN_HOTELS = 35265UL,
      FI_EN_BN_DIXIE_CHILI_DELI = 35266UL,
      FI_EN_BN_DIXONS = 35267UL,
      FI_EN_BN_DM = 35268UL,
      FI_EN_BN_DNB_NORD = 35269UL,
      FI_EN_BN_DOCK_GAMES = 35270UL,
      FI_EN_BN_DOCKX = 35271UL,
      FI_EN_BN_DOK = 35272UL,
      FI_EN_BN_DOKTOR_STOLETOV = 35273UL,
      FI_EN_BN_DOLCE_VITA = 35274UL,
      FI_EN_BN_DOLLAR_RENT_A_CAR = 35275UL,
      FI_EN_BN_DOLLAR_THRIFTY = 35276UL,
      FI_EN_BN_DOLLY_DIMPLES = 35277UL,
      FI_EN_BN_DOM_NA_KINOTO = 35278UL,
      FI_EN_BN_DOMINET_BANK = 35279UL,
      FI_EN_BN_DOMINICKS = 35280UL,
      FI_EN_BN_DOMINION = 35281UL,
      FI_EN_BN_DOMINOS_PIZZA = 35282UL,
      FI_EN_BN_DOMOTEL = 35283UL,
      FI_EN_BN_DON_DOMAT = 35284UL,
      FI_EN_BN_DON_PABLOS_MEXICAN_KITCHEN = 35285UL,
      FI_EN_BN_DONATOS = 35286UL,
      FI_EN_BN_DOOLITTLES = 35287UL,
      FI_EN_BN_DOSTEEN_RESTAURANT = 35288UL,
      FI_EN_BN_DOTS = 35289UL,
      FI_EN_BN_DPIU = 35290UL,
      FI_EN_BN_DR_AHORRO = 35291UL,
      FI_EN_BN_DRENIKOV_RENT_A_CAR = 35292UL,
      FI_EN_BN_DRESDNER_BANK = 35293UL,
      FI_EN_BN_DRESSBARN = 35294UL,
      FI_EN_BN_DROGASIL = 35295UL,
      FI_EN_BN_DROVA = 35296UL,
      FI_EN_BN_DRUG_EMPORIUM = 35297UL,
      FI_EN_BN_DRUGSTORE_PHARMACY = 35298UL,
      FI_EN_BN_DRUMMONDS = 35299UL,
      FI_EN_BN_DRUXYS = 35300UL,
      FI_EN_BN_DSK_BANK = 35301UL,
      FI_EN_BN_DU = 35302UL,
      FI_EN_BN_DUANE_READE = 35303UL,
      FI_EN_BN_DUNFERMLINE_BUILDING_SOCIETY = 35304UL,
      FI_EN_BN_DUNKIN_DONUTS = 35305UL,
      FI_EN_BN_DUNNES_STORES = 35306UL,
      FI_EN_BN_DUPONT = 35307UL,
      FI_EN_BN_DZ_BANK = 35308UL,
      FI_EN_BN_DZI_BANK = 35309UL,
      FI_EN_BN_E5_MODE = 35310UL,
      FI_EN_BN_EARL_SCHEIB_PAINT_BODY = 35311UL,
      FI_EN_BN_EARLS = 35312UL,
      FI_EN_BN_EAST_OF_CHICAGO = 35313UL,
      FI_EN_BN_EAST_SIDE_MARIOS = 35314UL,
      FI_EN_BN_E_BANKA = 35315UL,
      FI_EN_BN_EBN = 35316UL,
      FI_EN_BN_EBS_BUILDING_SOCIETY = 35317UL,
      FI_EN_BN_ECARD = 35318UL,
      FI_EN_BN_ECKERD = 35319UL,
      FI_EN_BN_ECOBANK = 35320UL,
      FI_EN_BN_ECONOMY_CAR_RENTAL = 35321UL,
      FI_EN_BN_EDAH = 35322UL,
      FI_EN_BN_EDDIE_BAUER = 35323UL,
      FI_EN_BN_EDDINGTONS = 35324UL,
      FI_EN_BN_EDEKA = 35325UL,
      FI_EN_BN_EDO_OF_JAPAN = 35326UL,
      FI_EN_BN_EEGEES = 35327UL,
      FI_EN_BN_EFFIA = 35328UL,
      FI_EN_BN_EG3 = 35329UL,
      FI_EN_BN_EGGO = 35330UL,
      FI_EN_BN_EH_HOTELES = 35331UL,
      FI_EN_BN_EIBANK = 35332UL,
      FI_EN_BN_EINSTEIN_BROS = 35333UL,
      FI_EN_BN_EKI = 35334UL,
      FI_EN_BN_EKOMAR = 35335UL,
      FI_EN_BN_EKONO = 35336UL,
      FI_EN_BN_EL_ARBOL = 35337UL,
      FI_EN_BN_EL_CHICO = 35338UL,
      FI_EN_BN_EL_CORTE_INGLES = 35339UL,
      FI_EN_BN_EL_FAROLITO = 35340UL,
      FI_EN_BN_EL_MONTE = 35341UL,
      FI_EN_BN_EL_PATIO = 35342UL,
      FI_EN_BN_EL_PETROL = 35343UL,
      FI_EN_BN_EL_POLLO_LOCO = 35344UL,
      FI_EN_BN_EL_POLLO_PEPE = 35345UL,
      FI_EN_BN_EL_PORTON = 35346UL,
      FI_EN_BN_EL_TORITO = 35347UL,
      FI_EN_BN_EL_TORO_MEXICAN_RESTAURANT_CANTINA = 35348UL,
      FI_EN_BN_EL_VAQUERO = 35349UL,
      FI_EN_BN_ELAN = 35350UL,
      FI_EN_BN_ELDA = 35351UL,
      FI_EN_BN_ELDI = 35352UL,
      FI_EN_BN_ELDORADO = 35353UL,
      FI_EN_BN_ELEA = 35354UL,
      FI_EN_BN_ELECTRA_HOTELS_RESORTS = 35355UL,
      FI_EN_BN_ELECTRIC = 35356UL,
      FI_EN_BN_ELECTROTHERM_INDIA_LIMITED = 35357UL,
      FI_EN_BN_ELEMAG = 35358UL,
      FI_EN_BN_ELEPHANT_BLEU = 35359UL,
      FI_EN_BN_ELEXIA_FITNESS = 35360UL,
      FI_EN_BN_ELGIGANTEN = 35361UL,
      FI_EN_BN_ELIN = 35362UL,
      FI_EN_BN_ELITE_CAR_RENTAL = 35363UL,
      FI_EN_BN_ELITE_HOTELS_OF_SWEDEN = 35364UL,
      FI_EN_BN_ELITE = 35365UL,
      FI_EN_BN_ELKI_PALKI = 35366UL,
      FI_EN_BN_ELKJOP = 35367UL,
      FI_EN_BN_ELLEDI = 35368UL,
      FI_EN_BN_ELLIANOS_COFFEE_COMPANY = 35369UL,
      FI_EN_BN_ELLIOTTS_OFF_BROADWAY_DELI = 35370UL,
      FI_EN_BN_ELMA = 35371UL,
      FI_EN_BN_ELPRICE = 35372UL,
      FI_EN_BN_EMERALD_CITY_SMOOTHIE = 35373UL,
      FI_EN_BN_EMIGRANT_SAVINGS_BANK = 35374UL,
      FI_EN_BN_EMIL_BANCA = 35375UL,
      FI_EN_BN_EMME_PIU = 35376UL,
      FI_EN_BN_EMO = 35377UL,
      FI_EN_BN_EMPIRE = 35378UL,
      FI_EN_BN_EMPORIKI_BANK = 35379UL,
      FI_EN_BN_EM_TE = 35380UL,
      FI_EN_BN_ENERGY_KITCHEN = 35381UL,
      FI_EN_BN_ENERGY = 35382UL,
      FI_EN_BN_ENERPETROLI = 35383UL,
      FI_EN_BN_ENTERPRISE = 35384UL,
      FI_EN_BN_EO_DER_BIOSUPERMARKT = 35385UL,
      FI_EN_BN_EP = 35386UL,
      FI_EN_BN_EP_ELECTRONIC_PARTNER = 35387UL,
      FI_EN_BN_EQUITORIAL_TRUST_BANK = 35388UL,
      FI_EN_BN_ERBERT_GERBERTS = 35389UL,
      FI_EN_BN_ERIKS_DELICAFE = 35390UL,
      FI_EN_BN_ERK = 35391UL,
      FI_EN_BN_ERO_CAR_BULGARIA_LTD = 35392UL,
      FI_EN_BN_EROSKI_CENTER = 35393UL,
      FI_EN_BN_EROSKI_CITY = 35394UL,
      FI_EN_BN_ERSTE_BANK = 35395UL,
      FI_EN_BN_ESKA = 35396UL,
      FI_EN_BN_ESPRIT = 35397UL,
      FI_EN_BN_ESSAR = 35398UL,
      FI_EN_BN_ESSEC = 35399UL,
      FI_EN_BN_ESSELUNGA = 35400UL,
      FI_EN_BN_ESSO_EXPRESS = 35401UL,
      FI_EN_BN_ESTUARY = 35402UL,
      FI_EN_BN_ETAM = 35403UL,
      FI_EN_BN_ETAP_HOTEL = 35404UL,
      FI_EN_BN_EUREST = 35405UL,
      FI_EN_BN_EURO_6000 = 35406UL,
      FI_EN_BN_EURO_CAR_PARKS = 35407UL,
      FI_EN_BN_EURO_CENTER = 35408UL,
      FI_EN_BN_EUROBANK_TEKFEN = 35409UL,
      FI_EN_BN_EUROBANK = 35410UL,
      FI_EN_BN_EURO_BULGARIAN_CULTURAL_CENTRE = 35411UL,
      FI_EN_BN_EUROCOVER = 35412UL,
      FI_EN_BN_EURODOLLAR = 35413UL,
      FI_EN_BN_EUROIL = 35414UL,
      FI_EN_BN_EUROMAR_HOTELS = 35415UL,
      FI_EN_BN_EUROMARKET = 35416UL,
      FI_EN_BN_EUROMASTER = 35417UL,
      FI_EN_BN_EUROMOBIL = 35418UL,
      FI_EN_BN_EURONET = 35419UL,
      FI_EN_BN_EURONICS = 35420UL,
      FI_EN_BN_EUROOIL = 35421UL,
      FI_EN_BN_EUROPABANK = 35422UL,
      FI_EN_BN_EUROPARK = 35423UL,
      FI_EN_BN_EUROPCAR_INTERRENT = 35424UL,
      FI_EN_BN_EUROPCAR = 35425UL,
      FI_EN_BN_EUROPEAN_CENTRAL_BANK = 35426UL,
      FI_EN_BN_EUROPETROL = 35427UL,
      FI_EN_BN_EUROPIU = 35428UL,
      FI_EN_BN_EUROPLEX = 35429UL,
      FI_EN_BN_EURORENT = 35430UL,
      FI_EN_BN_EUROSCOOP = 35431UL,
      FI_EN_BN_EUROSPAR = 35432UL,
      FI_EN_BN_EUROSPIN = 35433UL,
      FI_EN_BN_EUROSTARS_HOTELS = 35434UL,
      FI_EN_BN_EUROTYRE = 35435UL,
      FI_EN_BN_EUZKADI = 35436UL,
      FI_EN_BN_EVEREST_BANK = 35437UL,
      FI_EN_BN_EVEREST = 35438UL,
      FI_EN_BN_EVOS = 35439UL,
      FI_EN_BN_EVRAZIYA = 35440UL,
      FI_EN_BN_EVROIL = 35441UL,
      FI_EN_BN_EWA = 35442UL,
      FI_EN_BN_EXCELSIOR_GAMA_SUPERMERCADOS = 35443UL,
      FI_EN_BN_EXCELSIOR = 35444UL,
      FI_EN_BN_EXCLUSIVE_HOTELS = 35445UL,
      FI_EN_BN_EXELLENT_ELECTRO = 35446UL,
      FI_EN_BN_EXHAUST_PROS = 35447UL,
      FI_EN_BN_EXPERT = 35448UL,
      FI_EN_BN_EXPO_DESIGN_CENTER = 35449UL,
      FI_EN_BN_EXPO_HOTELES_RESORT = 35450UL,
      FI_EN_BN_EXPRESS_BY_HOLIDAY_INN = 35451UL,
      FI_EN_BN_EXPRESS_FASHION = 35452UL,
      FI_EN_BN_EXPRESS_LUBE = 35453UL,
      FI_EN_BN_EXPRESS_OIL_CHANGE = 35454UL,
      FI_EN_BN_EXTENDED_STAYAMERICA = 35455UL,
      FI_EN_BN_EXTRA = 35456UL,
      FI_EN_BN_EXTRAZONE = 35457UL,
      FI_EN_BN_EXTREME_PITA = 35458UL,
      FI_EN_BN_EZ_LUBE = 35459UL,
      FI_EN_BN_F24 = 35460UL,
      FI_EN_BN_FABRICLAND = 35461UL,
      FI_EN_BN_FACES_CINEMA = 35462UL,
      FI_EN_BN_FAETON = 35463UL,
      FI_EN_BN_FAIRFIELD_RESORTS = 35464UL,
      FI_EN_BN_FAIRWEATHER = 35465UL,
      FI_EN_BN_FAKTA = 35466UL,
      FI_EN_BN_FALKENSTEINER = 35467UL,
      FI_EN_BN_FAMILA = 35468UL,
      FI_EN_BN_FAMILIA_HOTELS = 35469UL,
      FI_EN_BN_FAMILIA = 35470UL,
      FI_EN_BN_FAMILIPRIX = 35471UL,
      FI_EN_BN_FAMILOTEL = 35472UL,
      FI_EN_BN_FAMILY_COMPANY = 35473UL,
      FI_EN_BN_FAMILY_FARE = 35474UL,
      FI_EN_BN_FAMILY_GAME_CENTER = 35475UL,
      FI_EN_BN_FAMOUS_DAVES = 35476UL,
      FI_EN_BN_FAMOUS_FOOTWEAR = 35477UL,
      FI_EN_BN_FANTASTICO = 35478UL,
      FI_EN_BN_FARMA_RED = 35479UL,
      FI_EN_BN_FARMACIAS_BENAVIDES = 35480UL,
      FI_EN_BN_FARMACIAS_DEL_AHORRO = 35481UL,
      FI_EN_BN_FARMACIAS_GUADALAJARA = 35482UL,
      FI_EN_BN_FARMACIAS_SIMILARES = 35483UL,
      FI_EN_BN_FARMACITY = 35484UL,
      FI_EN_BN_FARMAKOR = 35485UL,
      FI_EN_BN_FARMAOFERTAS = 35486UL,
      FI_EN_BN_FARMATODO = 35487UL,
      FI_EN_BN_FARMER_BOYS = 35488UL,
      FI_EN_BN_FARMER_JACK = 35489UL,
      FI_EN_BN_FARNAS = 35490UL,
      FI_EN_BN_FARRUCO = 35491UL,
      FI_EN_BN_FAS_GAS = 35492UL,
      FI_EN_BN_FASHION_BUG = 35493UL,
      FI_EN_BN_FAST = 35494UL,
      FI_EN_BN_FAT_TUESDAY = 35495UL,
      FI_EN_BN_FATBURGER = 35496UL,
      FI_EN_BN_FAZOLIS = 35497UL,
      FI_EN_BN_FEDERAL_BANK = 35498UL,
      FI_EN_BN_FEDEX_OFFICE = 35499UL,
      FI_EN_BN_FEDEX = 35500UL,
      FI_EN_BN_FEIRA_NOVA = 35501UL,
      FI_EN_BN_FESTIBAL_CENTRE = 35502UL,
      FI_EN_BN_FEU_VERT = 35503UL,
      FI_EN_BN_FIBANKC = 35504UL,
      FI_EN_BN_FIDELITY_BANK = 35505UL,
      FI_EN_BN_FIDEURAM = 35506UL,
      FI_EN_BN_FIELDS = 35507UL,
      FI_EN_BN_FIESTA_INN = 35508UL,
      FI_EN_BN_FIFTH_THIRD_BANK = 35509UL,
      FI_EN_BN_FINANSBANK = 35510UL,
      FI_EN_BN_FINBANK = 35511UL,
      FI_EN_BN_FINECO = 35512UL,
      FI_EN_BN_FINIBANCO = 35513UL,
      FI_EN_BN_FINISH_LINE = 35514UL,
      FI_EN_BN_FINNKINO = 35515UL,
      FI_EN_BN_FINTRO = 35516UL,
      FI_EN_BN_FIONIA_BANK = 35517UL,
      FI_EN_BN_FIREHOUSE_SUBS = 35518UL,
      FI_EN_BN_FIRESTONE = 35519UL,
      FI_EN_BN_FIREZONE = 35520UL,
      FI_EN_BN_FIRST_ACTIVE = 35521UL,
      FI_EN_BN_FIRST_AMERICAN_BANK = 35522UL,
      FI_EN_BN_FIRST_BANK = 35523UL,
      FI_EN_BN_FIRST_CITY_MONUMENT_BANK = 35524UL,
      FI_EN_BN_FIRST_COMMERCIAL_BANK = 35525UL,
      FI_EN_BN_FIRST_COMMONWEALTH_BANK = 35526UL,
      FI_EN_BN_FIRST_FEDERAL = 35527UL,
      FI_EN_BN_FIRST_FINANCIAL_BANK = 35528UL,
      FI_EN_BN_FIRST_INDEPENDENT_BANK = 35529UL,
      FI_EN_BN_FIRST_INTERSTATE_BANK = 35530UL,
      FI_EN_BN_FIRST_INVESTMENT_BANK = 35531UL,
      FI_EN_BN_FIRST_MIDWEST_BANK = 35532UL,
      FI_EN_BN_FIRST_NATIONAL_BANK = 35533UL,
      FI_EN_BN_FIRST_NIAGARA = 35534UL,
      FI_EN_BN_FIRST_SOUTH_BANK = 35535UL,
      FI_EN_BN_FIRST_STOP = 35536UL,
      FI_EN_BN_FIRST_TENNESSEE_BANK = 35537UL,
      FI_EN_BN_FIRST_TRUST_BANK = 35538UL,
      FI_EN_BN_FIRST_WATCH = 35539UL,
      FI_EN_BN_FIRSTBANK = 35540UL,
      FI_EN_BN_FISH_MARKET = 35541UL,
      FI_EN_BN_FIVE_GUYS_BURGERS_AND_FRIES = 35542UL,
      FI_EN_BN_FLAG_HOTEL = 35543UL,
      FI_EN_BN_FLAMINGO_CINEMA = 35544UL,
      FI_EN_BN_FLAT_TOP_GRILL = 35545UL,
      FI_EN_BN_FLEETFUELS = 35546UL,
      FI_EN_BN_FLEMINGS_PRIME_STEAKHOUSE_WINE_BAR = 35547UL,
      FI_EN_BN_FLESSABANK = 35548UL,
      FI_EN_BN_FLOR_DO_CAFE = 35549UL,
      FI_EN_BN_FLUNCH = 35550UL,
      FI_EN_BN_FLYCAR = 35551UL,
      FI_EN_BN_FLYPARK = 35552UL,
      FI_EN_BN_FNAC = 35553UL,
      FI_EN_BN_FOKUS_BANK = 35554UL,
      FI_EN_BN_FOLKETS_BIO = 35555UL,
      FI_EN_BN_FOOD_BASICS = 35556UL,
      FI_EN_BN_FOOD_CITY = 35557UL,
      FI_EN_BN_FOOD_LION = 35558UL,
      FI_EN_BN_FOODLAND = 35559UL,
      FI_EN_BN_FOODWORLD = 35560UL,
      FI_EN_BN_FOOT_LOCKER = 35561UL,
      FI_EN_BN_FOOTACTION_USA = 35562UL,
      FI_EN_BN_FORD_RENT_A_CAR = 35563UL,
      FI_EN_BN_FOERDE_SPARKASSE = 35564UL,
      FI_EN_BN_FOREVER_21 = 35565UL,
      FI_EN_BN_FORMOSA = 35566UL,
      FI_EN_BN_FORMULA_ONE_AUTOCENTRES = 35567UL,
      FI_EN_BN_FORSTAEDERNES_BANK = 35568UL,
      FI_EN_BN_FORSTINGER = 35569UL,
      FI_EN_BN_FORTINOS = 35570UL,
      FI_EN_BN_FORTIS_BANK = 35571UL,
      FI_EN_BN_FORTIS_BANQUE = 35572UL,
      FI_EN_BN_FORTUNE = 35573UL,
      FI_EN_BN_FORUM_CINEMAS = 35574UL,
      FI_EN_BN_FOSTERS_FREEZE = 35575UL,
      FI_EN_BN_FOSTERS_HOLLYWOOD = 35576UL,
      FI_EN_BN_FOTEX = 35577UL,
      FI_EN_BN_FOUNTAIN_TIRE = 35578UL,
      FI_EN_BN_FOUR_POINTS_BY_SHERATON = 35579UL,
      FI_EN_BN_FOUR_STAR_PIZZA = 35580UL,
      FI_EN_BN_FOX_RENT_A_CAR = 35581UL,
      FI_EN_BN_FOXS_PIZZA_DEN = 35582UL,
      FI_EN_BN_FRANCOCAR = 35583UL,
      FI_EN_BN_FRANKFURTER_SPARKASSE = 35584UL,
      FI_EN_BN_FRANKFURTER_VOLKSBANK = 35585UL,
      FI_EN_BN_FRANPRIX = 35586UL,
      FI_EN_BN_FRANSMANNI = 35587UL,
      FI_EN_BN_FRED_MEYER_PHARMACY = 35588UL,
      FI_EN_BN_FREE_RECORD_SHOP = 35589UL,
      FI_EN_BN_FREEBIRDS_WORLD_BURRITO = 35590UL,
      FI_EN_BN_FREIBURGER_KANTONALBANK = 35591UL,
      FI_EN_BN_FRESC_CO = 35592UL,
      FI_EN_BN_FRESH_READY = 35593UL,
      FI_EN_BN_FRESH_CHOICE = 35594UL,
      FI_EN_BN_FRESH_CITY = 35595UL,
      FI_EN_BN_FRESH_MARKET = 35596UL,
      FI_EN_BN_FRESHENS_SMOOTHIE_COMPANY = 35597UL,
      FI_EN_BN_FRESSNAPF = 35598UL,
      FI_EN_BN_FRIDAYS = 35599UL,
      FI_EN_BN_FRIENDLY_SUPERMARKET = 35600UL,
      FI_EN_BN_FRIENDLYS = 35601UL,
      FI_EN_BN_FRIESLAND_BANK = 35602UL,
      FI_EN_BN_FRISCHS_BIG_BOY = 35603UL,
      FI_EN_BN_FROIZ = 35604UL,
      FI_EN_BN_FROST_BANK = 35605UL,
      FI_EN_BN_FRULLATI_CAFE = 35606UL,
      FI_EN_BN_FUDDRUCKERS = 35607UL,
      FI_EN_BN_FURGOCAR = 35608UL,
      FI_EN_BN_FURRS = 35609UL,
      FI_EN_BN_FUST = 35610UL,
      FI_EN_BN_FUTURA = 35611UL,
      FI_EN_BN_FUTURE_SHOP = 35612UL,
      FI_EN_BN_G_V = 35613UL,
      FI_EN_BN_G20 = 35614UL,
      FI_EN_BN_GABRIELS = 35615UL,
      FI_EN_BN_GADIS = 35616UL,
      FI_EN_BN_GAILLI_MARKEY = 35617UL,
      FI_EN_BN_GALAXIAS = 35618UL,
      FI_EN_BN_GALES = 35619UL,
      FI_EN_BN_GALICIA = 35620UL,
      FI_EN_BN_GALLERY_HOTELES = 35621UL,
      FI_EN_BN_GAMA = 35622UL,
      FI_EN_BN_GAMMA = 35623UL,
      FI_EN_BN_GAP = 35624UL,
      FI_EN_BN_GARANTI_BANKASI = 35625UL,
      FI_EN_BN_GARDEN_RIDGE = 35626UL,
      FI_EN_BN_GARFIELDS = 35627UL,
      FI_EN_BN_GARLAM = 35628UL,
      FI_EN_BN_GAERTNERBANK = 35629UL,
      FI_EN_BN_GAS_KING = 35630UL,
      FI_EN_BN_GAS_PLUS = 35631UL,
      FI_EN_BN_GAST_IM_SCHLOSS = 35632UL,
      FI_EN_BN_GAUMONT = 35633UL,
      FI_EN_BN_GAZ = 35634UL,
      FI_EN_BN_GAZPROM = 35635UL,
      FI_EN_BN_GAZPROMBANK = 35636UL,
      FI_EN_BN_GB_EXPRESS = 35637UL,
      FI_EN_BN_GB = 35638UL,
      FI_EN_BN_GE_MONEY_BANK = 35639UL,
      FI_EN_BN_GEANT_CASINO = 35640UL,
      FI_EN_BN_GEELY = 35641UL,
      FI_EN_BN_GENERAL_COOPERATIVE_BANK = 35642UL,
      FI_EN_BN_GENERALI_BANK = 35643UL,
      FI_EN_BN_GENIKI_BANK = 35644UL,
      FI_EN_BN_GEOX = 35645UL,
      FI_EN_BN_GETGO = 35646UL,
      FI_EN_BN_GETIN_BANK = 35647UL,
      FI_EN_BN_GIANT_DRUGSTORE = 35648UL,
      FI_EN_BN_GIANT_EAGLE = 35649UL,
      FI_EN_BN_GIANT_FOOD_STORES = 35650UL,
      FI_EN_BN_GIANT_GASOLINE = 35651UL,
      FI_EN_BN_GIANT_TIGER = 35652UL,
      FI_EN_BN_GIBBS = 35653UL,
      FI_EN_BN_GIEFFE = 35654UL,
      FI_EN_BN_GIFI = 35655UL,
      FI_EN_BN_GIGANTTI = 35656UL,
      FI_EN_BN_GIMENES = 35657UL,
      FI_EN_BN_GIMSA = 35658UL,
      FI_EN_BN_GINOS_EAST = 35659UL,
      FI_EN_BN_GINOS_PIZZA = 35660UL,
      FI_EN_BN_GINOSS_VIPS = 35661UL,
      FI_EN_BN_GLARNER_KANTONALBANK = 35662UL,
      FI_EN_BN_GLENS_MARKET = 35663UL,
      FI_EN_BN_GLOBAL_CASH = 35664UL,
      FI_EN_BN_GLOBAL_TRUST_BANK = 35665UL,
      FI_EN_BN_GLOBEKS = 35666UL,
      FI_EN_BN_GLOBI = 35667UL,
      FI_EN_BN_GLOBUS = 35668UL,
      FI_EN_BN_GLORIA_JEANS = 35669UL,
      FI_EN_BN_GLOU = 35670UL,
      FI_EN_BN_GNC = 35671UL,
      FI_EN_BN_GO_SPORT = 35672UL,
      FI_EN_BN_GOCO = 35673UL,
      FI_EN_BN_GODFATHERS = 35674UL,
      FI_EN_BN_GOLD_STAR_CHILI = 35675UL,
      FI_EN_BN_GOLDEN_CHICK = 35676UL,
      FI_EN_BN_GOLDEN_CORRAL = 35677UL,
      FI_EN_BN_GOLDEN_FORK = 35678UL,
      FI_EN_BN_GOLDEN_PALACE = 35679UL,
      FI_EN_BN_GOLDEN_TULIP_HOTELS_INNS_RESORTS = 35680UL,
      FI_EN_BN_GOLFF = 35681UL,
      FI_EN_BN_GOOD_EATS = 35682UL,
      FI_EN_BN_GOOD_TIME_BURGERS_FROZEN_CUSTARD = 35683UL,
      FI_EN_BN_GOODYEAR = 35684UL,
      FI_EN_BN_GOODYS = 35685UL,
      FI_EN_BN_GORENJSKA_BANKA = 35686UL,
      FI_EN_BN_G_PARK = 35687UL,
      FI_EN_BN_GRAN_MELIA_HOTELS_RESORTS = 35688UL,
      FI_EN_BN_GRAND_HOTEL_CONTINENTAL = 35689UL,
      FI_EN_BN_GRAND_HYATT = 35690UL,
      FI_EN_BN_GRAND_RESIDENCES_BY_MARRIOTT = 35691UL,
      FI_EN_BN_GRAND_UNION = 35692UL,
      FI_EN_BN_GRAND = 35693UL,
      FI_EN_BN_GRANDES_ETAPES_FRANCAISES = 35694UL,
      FI_EN_BN_GRAUBUENDNER_KANTONALBANK = 35695UL,
      FI_EN_BN_GREAT_AMERICAN_COOKIE = 35696UL,
      FI_EN_BN_GREAT_OUTDOORS = 35697UL,
      FI_EN_BN_GREAT_STEAK_FRY = 35698UL,
      FI_EN_BN_GREAT_STEAK_POTATO_COMPANY = 35699UL,
      FI_EN_BN_GREAT_WALL = 35700UL,
      FI_EN_BN_GREAT_WRAPS = 35701UL,
      FI_EN_BN_GRECOTEL = 35702UL,
      FI_EN_BN_GREENE_KING_INNS = 35703UL,
      FI_EN_BN_GREENS = 35704UL,
      FI_EN_BN_GREGORYS = 35705UL,
      FI_EN_BN_GRETELS_PRETZELS = 35706UL,
      FI_EN_BN_GRIGORIS = 35707UL,
      FI_EN_BN_GROS = 35708UL,
      FI_EN_BN_GROSSMART = 35709UL,
      FI_EN_BN_GROUND_ROUND = 35710UL,
      FI_EN_BN_GROUP_H_21 = 35711UL,
      FI_EN_BN_GRUP_DUSA = 35712UL,
      FI_EN_BN_GRUP_HATIPOGLU = 35713UL,
      FI_EN_BN_GS = 35714UL,
      FI_EN_BN_GTO = 35715UL,
      FI_EN_BN_GUARANTY_TRUST_BANK = 35716UL,
      FI_EN_BN_GUARDIAN = 35717UL,
      FI_EN_BN_GUITART_HOTELS = 35718UL,
      FI_EN_BN_GULLIVER = 35719UL,
      FI_EN_BN_GURGOAN_GRAMIN = 35720UL,
      FI_EN_BN_GYMBOREE = 35721UL,
      FI_EN_BN_H_M = 35722UL,
      FI_EN_BN_H10 = 35723UL,
      FI_EN_BN_HAAN = 35725UL,
      FI_EN_BN_HACIENDA_MEXICANA = 35726UL,
      FI_EN_BN_HACIOGLU = 35727UL,
      FI_EN_BN_HAGA_BANK = 35728UL,
      FI_EN_BN_HAGEBAU = 35729UL,
      FI_EN_BN_HAKMAR_EKSPRES = 35730UL,
      FI_EN_BN_HAKMAR = 35731UL,
      FI_EN_BN_HALFORDS = 35732UL,
      FI_EN_BN_HALIFAX_HISPANIA = 35733UL,
      FI_EN_BN_HALIFAX = 35734UL,
      FI_EN_BN_HALKBANK = 35735UL,
      FI_EN_BN_HALLHUBER = 35736UL,
      FI_EN_BN_HAMBURGER_SPARKASSE = 35737UL,
      FI_EN_BN_HAMBURGER_VOLKSBANK = 35738UL,
      FI_EN_BN_HAMPSHIRE = 35739UL,
      FI_EN_BN_HAMPTON_INN_SUITES = 35740UL,
      FI_EN_BN_HANCO = 35741UL,
      FI_EN_BN_HANCOCK_BANK = 35742UL,
      FI_EN_BN_HANDELSBANKEN = 35743UL,
      FI_EN_BN_HANNOVERSCHE_VOLKSBANK = 35744UL,
      FI_EN_BN_HANSABANKA = 35745UL,
      FI_EN_BN_HANSAPANK = 35746UL,
      FI_EN_BN_HANSEATIC_BANK = 35747UL,
      FI_EN_BN_HANWHA_BANK = 35748UL,
      FI_EN_BN_HAPPI_HOUSE = 35749UL,
      FI_EN_BN_HAPPY_BAR_GRILL = 35750UL,
      FI_EN_BN_HAPPY_CENTER = 35751UL,
      FI_EN_BN_HAPPY_FOOD = 35752UL,
      FI_EN_BN_HAPPY_RENT = 35753UL,
      FI_EN_BN_HARD_ROCK_CAFE = 35754UL,
      FI_EN_BN_HARD_ROCK_HOTEL = 35755UL,
      FI_EN_BN_HARDEES = 35756UL,
      FI_EN_BN_HARLEY_DAVIDSON = 35757UL,
      FI_EN_BN_HARRIS_BANK = 35758UL,
      FI_EN_BN_HARRY_AND_MAX = 35759UL,
      FI_EN_BN_HARTLAUER = 35760UL,
      FI_EN_BN_HARVEST_FOODS = 35761UL,
      FI_EN_BN_HARVEY_NORMAN = 35762UL,
      FI_EN_BN_HARVEYS = 35763UL,
      FI_EN_BN_HAWTHORN_SUITES_BY_WYNDHAM = 35764UL,
      FI_EN_BN_HBW_EXPRESS_TAKAREKSZOEVETKEZET = 35765UL,
      FI_EN_BN_HD_SUPPLY = 35766UL,
      FI_EN_BN_HDFC_BANK = 35767UL,
      FI_EN_BN_HEAVENLY_HAM = 35768UL,
      FI_EN_BN_H_E_B_PHARMACY = 35769UL,
      FI_EN_BN_H_E_B = 35770UL,
      FI_EN_BN_HEBROS_BANK = 35771UL,
      FI_EN_BN_HELLENIC_BANK = 35772UL,
      FI_EN_BN_HELLENIC_POSTBANK = 35773UL,
      FI_EN_BN_HELLO_HOTELS = 35774UL,
      FI_EN_BN_HELLWEG = 35775UL,
      FI_EN_BN_HEMA = 35776UL,
      FI_EN_BN_HEMKOEP = 35777UL,
      FI_EN_BN_HENRI_BENDEL = 35778UL,
      FI_EN_BN_HERFY = 35779UL,
      FI_EN_BN_HERTZ = 35780UL,
      FI_EN_BN_HERVIS = 35781UL,
      FI_EN_BN_HESBURGER = 35782UL,
      FI_EN_BN_HEYTENS = 35783UL,
      FI_EN_BN_HFC_BANK = 35784UL,
      FI_EN_BN_HHGREGG = 35785UL,
      FI_EN_BN_HIBERNIA = 35786UL,
      FI_EN_BN_HIGH_TECH_BURRITO = 35787UL,
      FI_EN_BN_HILTON_GARDEN_INN = 35788UL,
      FI_EN_BN_HILTON_GRAND_VACATIONS = 35789UL,
      FI_EN_BN_HIPER_USERA = 35790UL,
      FI_EN_BN_HIPERCOMPRA = 35791UL,
      FI_EN_BN_HIPERCOR = 35792UL,
      FI_EN_BN_HIPERSOL = 35793UL,
      FI_EN_BN_HIPPOPOTAMUS = 35794UL,
      FI_EN_BN_HI_Q = 35795UL,
      FI_EN_BN_HISTORIC_HOTELS_OF_SWEDEN = 35796UL,
      FI_EN_BN_HIT = 35797UL,
      FI_EN_BN_HL_MARKT = 35798UL,
      FI_EN_BN_HOBEES = 35799UL,
      FI_EN_BN_HOFER = 35800UL,
      FI_EN_BN_HOGI_YOGI = 35801UL,
      FI_EN_BN_HOLDEN_HDT = 35802UL,
      FI_EN_BN_HOLDEN_SPECIAL_VEHICLE = 35803UL,
      FI_EN_BN_HOLDEN = 35804UL,
      FI_EN_BN_HOLIDAY_INN_EXPRESS_HOTEL_SUITES = 35805UL,
      FI_EN_BN_HOLIDAY_INN_EXPRESS = 35806UL,
      FI_EN_BN_HOLIDAY_INN_GARDEN_COURT = 35807UL,
      FI_EN_BN_HOLIDAY_INN_HOTEL_SUITES = 35808UL,
      FI_EN_BN_HOLIDAY_INN_RESORT = 35809UL,
      FI_EN_BN_HOLIDAY_INN_SELECT_SUITES = 35810UL,
      FI_EN_BN_HOLIDAY_INN_SELECT = 35811UL,
      FI_EN_BN_HOLIDAY_INN_SUNSPREE_RESORT = 35812UL,
      FI_EN_BN_HOLIDAY_STATIONSTORES = 35813UL,
      FI_EN_BN_HOLLAND_BLUMEN_MARK = 35814UL,
      FI_EN_BN_HOLLAND_HOTELS = 35815UL,
      FI_EN_BN_HOLLYWOOD_MEGAPLEX = 35816UL,
      FI_EN_BN_HOLMES_PLACE = 35817UL,
      FI_EN_BN_HOME_FEDERAL_BANK = 35818UL,
      FI_EN_BN_HOME_HARDWARE = 35819UL,
      FI_EN_BN_HOME_MARKET = 35820UL,
      FI_EN_BN_HOME_SAVINGS_LOAN = 35821UL,
      FI_EN_BN_HOMEGOODS = 35822UL,
      FI_EN_BN_HOMESTEAD_STUDIO_SUITES = 35823UL,
      FI_EN_BN_HOMETOWN_BUFFET = 35824UL,
      FI_EN_BN_HONEYBAKED_HAM_COMPANY = 35825UL,
      FI_EN_BN_HONEYCOMBE_LEISURE = 35826UL,
      FI_EN_BN_HONG_KONG_EXPRESS = 35827UL,
      FI_EN_BN_HONSEL = 35828UL,
      FI_EN_BN_HOOTERS = 35829UL,
      FI_EN_BN_HORNBACH = 35830UL,
      FI_EN_BN_HOSPES = 35831UL,
      FI_EN_BN_HOSTA_PIKNIK = 35832UL,
      FI_EN_BN_HOT_N_NOW = 35833UL,
      FI_EN_BN_HOT_TOPIC = 35834UL,
      FI_EN_BN_HOTEL_INDIGO = 35835UL,
      FI_EN_BN_HOTELES_COTURSA = 35836UL,
      FI_EN_BN_HOTELS_BARRIERE = 35837UL,
      FI_EN_BN_HOTELS_ONIX = 35838UL,
      FI_EN_BN_HOTENCO_HOTELES = 35839UL,
      FI_EN_BN_HOTUSA = 35840UL,
      FI_EN_BN_HOULIHANS = 35841UL,
      FI_EN_BN_HOUSEHOLD_BANK = 35842UL,
      FI_EN_BN_HOYER = 35843UL,
      FI_EN_BN_HP = 35844UL,
      FI_EN_BN_HRVATSKA_POSTANSKA_BANKA = 35845UL,
      FI_EN_BN_HSBC = 35846UL,
      FI_EN_BN_HSV = 35847UL,
      FI_EN_BN_HUBO = 35848UL,
      FI_EN_BN_HUDDLE_HOUSE = 35849UL,
      FI_EN_BN_HUMANIC = 35850UL,
      FI_EN_BN_HUMPTYS = 35851UL,
      FI_EN_BN_HUNAN_CHINESE_RESTAURANT = 35852UL,
      FI_EN_BN_HUNGRY_HOWIES_PIZZA = 35853UL,
      FI_EN_BN_HUNGRY_HUNTER = 35854UL,
      FI_EN_BN_HUNTINGTON_NATIONAL_BANK = 35855UL,
      FI_EN_BN_HUNTINGTON = 35856UL,
      FI_EN_BN_HVB_BANK = 35857UL,
      FI_EN_BN_HYATT_HOTELS_RESORTS = 35858UL,
      FI_EN_BN_HYATT_PLACE = 35859UL,
      FI_EN_BN_HYATT_RESORTS = 35860UL,
      FI_EN_BN_HYATT_SUMMERFIELD_SUITES = 35861UL,
      FI_EN_BN_HYATT_VACATION_CLUB = 35862UL,
      FI_EN_BN_HYDRO = 35863UL,
      FI_EN_BN_HYPER_U = 35864UL,
      FI_EN_BN_HYPERNOVA = 35865UL,
      FI_EN_BN_HYPO = 35866UL,
      FI_EN_BN_HYPO_ALPE_ADRIA_BANK = 35867UL,
      FI_EN_BN_HYPOVEREINSBANK = 35868UL,
      FI_EN_BN_HY_VEE = 35869UL,
      FI_EN_BN_I_CANT_BELIEVE_ITS_YOGURT = 35870UL,
      FI_EN_BN_IBC_BANK = 35871UL,
      FI_EN_BN_IBERCAJA = 35872UL,
      FI_EN_BN_IBERDOEX = 35873UL,
      FI_EN_BN_IBERENT = 35874UL,
      FI_EN_BN_IBP = 35875UL,
      FI_EN_BN_IC_BANK = 35876UL,
      FI_EN_BN_ICA_BANK = 35877UL,
      FI_EN_BN_ICA_KVANTUM = 35878UL,
      FI_EN_BN_ICA_MAXI = 35879UL,
      FI_EN_BN_ICA_NAERA = 35880UL,
      FI_EN_BN_ICA_SUPERMARKET = 35881UL,
      FI_EN_BN_ICELAND = 35882UL,
      FI_EN_BN_ICICI_BANK = 35883UL,
      FI_EN_BN_ICING = 35884UL,
      FI_EN_BN_IDA = 35885UL,
      FI_EN_BN_IDBI_BANK = 35886UL,
      FI_EN_BN_IES = 35887UL,
      FI_EN_BN_IFA = 35888UL,
      FI_EN_BN_IGA = 35889UL,
      FI_EN_BN_IHOP = 35890UL,
      FI_EN_BN_IHR_PLATZ = 35891UL,
      FI_EN_BN_IIB_BANK = 35892UL,
      FI_EN_BN_III_FORKS = 35893UL,
      FI_EN_BN_IKBAL = 35894UL,
      FI_EN_BN_IKEA = 35895UL,
      FI_EN_BN_IKI = 35896UL,
      FI_EN_BN_IL_PATIO = 35897UL,
      FI_EN_BN_ILEKTRONIKI = 35898UL,
      FI_EN_BN_ILHA_VERDE = 35899UL,
      FI_EN_BN_IMAGIX = 35900UL,
      FI_EN_BN_IMAX = 35901UL,
      FI_EN_BN_IMC = 35902UL,
      FI_EN_BN_IMO_CARWASH = 35903UL,
      FI_EN_BN_INA = 35904UL,
      FI_EN_BN_INBURSA = 35905UL,
      FI_EN_BN_INDIAN_BANK = 35906UL,
      FI_EN_BN_INDIAN_OIL = 35907UL,
      FI_EN_BN_INDIAN_OVERSEAS_BANK = 35908UL,
      FI_EN_BN_INDO_MART = 35909UL,
      FI_EN_BN_INDRAPRASTHA = 35910UL,
      FI_EN_BN_INDUS = 35911UL,
      FI_EN_BN_INDUSIND_BANK = 35912UL,
      FI_EN_BN_ING_BANK_SLASKI = 35913UL,
      FI_EN_BN_ING_BANK = 35914UL,
      FI_EN_BN_ING_DIRECT = 35915UL,
      FI_EN_BN_ING_NATIONALE_NEDERLANDEN = 35916UL,
      FI_EN_BN_ING_VYSYA = 35917UL,
      FI_EN_BN_ING_DIBA = 35918UL,
      FI_EN_BN_INGLES_GAS_EXPRESS = 35919UL,
      FI_EN_BN_INGLES_MARKETS = 35920UL,
      FI_EN_BN_INGLES_PHARMACY = 35921UL,
      FI_EN_BN_INKASBANK = 35922UL,
      FI_EN_BN_INNO_GALERIA = 35923UL,
      FI_EN_BN_INNO = 35924UL,
      FI_EN_BN_IN_N_OUT_BURGER = 35925UL,
      FI_EN_BN_INNSIDE_PREMIUM_HOTELS = 35926UL,
      FI_EN_BN_INOKOM = 35927UL,
      FI_EN_BN_INOV = 35928UL,
      FI_EN_BN_INS = 35929UL,
      FI_EN_BN_INTERCONTINENTAL_BANK = 35930UL,
      FI_EN_BN_INTERCONTINENTAL = 35931UL,
      FI_EN_BN_INTERDISCOUNT = 35932UL,
      FI_EN_BN_INTER_EUROPA_BANK = 35933UL,
      FI_EN_BN_INTER_HOTEL = 35934UL,
      FI_EN_BN_INTERPARKING = 35935UL,
      FI_EN_BN_INTERSPAR = 35936UL,
      FI_EN_BN_INTERSPORT = 35937UL,
      FI_EN_BN_INVERSIS = 35938UL,
      FI_EN_BN_INVEST = 35939UL,
      FI_EN_BN_INVESTACOR = 35940UL,
      FI_EN_BN_INVESTBANK = 35941UL,
      FI_EN_BN_IPAR_KUTXA = 35942UL,
      FI_EN_BN_IPIRANGA = 35943UL,
      FI_EN_BN_IRISH_LIFE_AND_PERMANENT = 35944UL,
      FI_EN_BN_IRISH_NATIONWIDE_BUILDING_SOCIETY = 35945UL,
      FI_EN_BN_IRMA = 35946UL,
      FI_EN_BN_IS_BANK = 35947UL,
      FI_EN_BN_ISA = 35948UL,
      FI_EN_BN_ISAACS_RESTAURANT_DELI = 35949UL,
      FI_EN_BN_ISLANDS = 35950UL,
      FI_EN_BN_ISMAR = 35951UL,
      FI_EN_BN_ISO = 35952UL,
      FI_EN_BN_ISSIMO = 35953UL,
      FI_EN_BN_ISTROBANKA = 35954UL,
      FI_EN_BN_ITALIANNIS = 35955UL,
      FI_EN_BN_ITAU = 35956UL,
      FI_EN_BN_ITC = 35957UL,
      FI_EN_BN_IVARS = 35958UL,
      FI_EN_BN_IVECO = 35959UL,
      FI_EN_BN_IXE = 35960UL,
      FI_EN_BN_IXINA = 35961UL,
      FI_EN_BN_IZZI = 35962UL,
      FI_EN_BN_J_ALEXANDERS = 35963UL,
      FI_EN_BN_J_CREW = 35964UL,
      FI_EN_BN_J_JILL = 35965UL,
      FI_EN_BN_JACK_ASTORS = 35966UL,
      FI_EN_BN_JACK_IN_THE_BOX = 35967UL,
      FI_EN_BN_JAI_LAXMI_BANK = 35968UL,
      FI_EN_BN_JAMBA_JUICE = 35969UL,
      FI_EN_BN_JAMMU_KASHMIR_BANK = 35970UL,
      FI_EN_BN_JAN_LINDERS = 35971UL,
      FI_EN_BN_JANATA_SAHAKARI_BANK = 35972UL,
      FI_EN_BN_JANKALYAN_SAHAKARI_BANK = 35973UL,
      FI_EN_BN_JANSAHAKARI_BANK = 35974UL,
      FI_EN_BN_JANSEVA_SAHAKARI_BANK = 35975UL,
      FI_EN_BN_JASMIS = 35976UL,
      FI_EN_BN_JASONS_DELI = 35977UL,
      FI_EN_BN_JB_BOURNAZOS = 35978UL,
      FI_EN_BN_JBC = 35979UL,
      FI_EN_BN_JCPENNEY = 35980UL,
      FI_EN_BN_JEAN_COUTU = 35981UL,
      FI_EN_BN_JEDNOTA = 35982UL,
      FI_EN_BN_JENSENS_BOFHUS = 35983UL,
      FI_EN_BN_JERAS_JUICE = 35984UL,
      FI_EN_BN_JERRYS_SUBS_PIZZA = 35985UL,
      FI_EN_BN_JERSEY_MIKES_SUBS = 35986UL,
      FI_EN_BN_JESPAC = 35987UL,
      FI_EN_BN_JETOIL = 35988UL,
      FI_EN_BN_JEWEL_OSCO = 35989UL,
      FI_EN_BN_JIFFY_LUBE = 35990UL,
      FI_EN_BN_JIMMY_JOHNS = 35991UL,
      FI_EN_BN_JOCKEY = 35992UL,
      FI_EN_BN_JOES_CRAB_SHACK = 35993UL,
      FI_EN_BN_JOEYS_ONLY = 35994UL,
      FI_EN_BN_JOHNNY_ROCKETS = 35995UL,
      FI_EN_BN_JOHNSTON_MURPHY = 35996UL,
      FI_EN_BN_JOKER = 35997UL,
      FI_EN_BN_JONES_NEW_YORK = 35998UL,
      FI_EN_BN_JONES = 35999UL,
      FI_EN_BN_JOSEPHINOS = 36000UL,
      FI_EN_BN_JOUETLAND_B_COMME_BEBE = 36001UL,
      FI_EN_BN_JOUETLAND_BEBELAND = 36002UL,
      FI_EN_BN_JOUETLAND = 36003UL,
      FI_EN_BN_JOURNEYS = 36004UL,
      FI_EN_BN_JOY_HOTELS = 36005UL,
      FI_EN_BN_JPMORGAN_CHASE = 36006UL,
      FI_EN_BN_JRECK_SUBS = 36007UL,
      FI_EN_BN_JUAN_POLLO = 36008UL,
      FI_EN_BN_JUICE_IT_UP = 36009UL,
      FI_EN_BN_JUICE_STOP = 36010UL,
      FI_EN_BN_JUMBO = 36011UL,
      FI_EN_BN_JUMPIN_JUICE_JAVA = 36012UL,
      FI_EN_BN_JURKI = 36013UL,
      FI_EN_BN_JUST_BURGERS = 36014UL,
      FI_EN_BN_JUST_TIRES = 36015UL,
      FI_EN_BN_JUSTICE = 36016UL,
      FI_EN_BN_JW_MARRIOTT = 36017UL,
      FI_EN_BN_JYSKE_BANK = 36018UL,
      FI_EN_BN_K_H_BANK = 36019UL,
      FI_EN_BN_K_K = 36020UL,
      FI_EN_BN_KADOIL = 36021UL,
      FI_EN_BN_KAISERS = 36022UL,
      FI_EN_BN_KAL_TIRE = 36023UL,
      FI_EN_BN_KAOIL = 36024UL,
      FI_EN_BN_KARADAG = 36025UL,
      FI_EN_BN_KARMELKORN = 36026UL,
      FI_EN_BN_KARNATAKA_BANK = 36027UL,
      FI_EN_BN_KARO_FILM = 36028UL,
      FI_EN_BN_KARSTADT = 36029UL,
      FI_EN_BN_KARUR_VYSYA_BANK = 36030UL,
      FI_EN_BN_KARUSEL = 36031UL,
      FI_EN_BN_KASH_N_KARRY = 36032UL,
      FI_EN_BN_KASSELER_SPARKASSE = 36033UL,
      FI_EN_BN_KAUFHOF = 36034UL,
      FI_EN_BN_KAUFLAND = 36035UL,
      FI_EN_BN_KAUFMANN = 36036UL,
      FI_EN_BN_KAUFPARK = 36037UL,
      FI_EN_BN_KAV_AUTOVERHUUR = 36038UL,
      FI_EN_BN_KBC = 36039UL,
      FI_EN_BN_K_CITYMARKET = 36040UL,
      FI_EN_BN_KDB_BANK = 36041UL,
      FI_EN_BN_KEDDY = 36042UL,
      FI_EN_BN_KEISY = 36043UL,
      FI_EN_BN_KELSEYS = 36044UL,
      FI_EN_BN_KEM = 36045UL,
      FI_EN_BN_KENOL = 36046UL,
      FI_EN_BN_KEVA_JUICE = 36047UL,
      FI_EN_BN_K_EXTRA = 36048UL,
      FI_EN_BN_KEY = 36049UL,
      FI_EN_BN_KEYBANK = 36050UL,
      FI_EN_BN_KHOUM_KREDIT = 36051UL,
      FI_EN_BN_KIDS_CLASS = 36052UL,
      FI_EN_BN_KIDS_FOOT_LOCKER = 36053UL,
      FI_EN_BN_KIK = 36054UL,
      FI_EN_BN_KIKA = 36055UL,
      FI_EN_BN_KILER = 36056UL,
      FI_EN_BN_KILOUTOU = 36057UL,
      FI_EN_BN_KIM = 36058UL,
      FI_EN_BN_KIND_HOERGERAETE = 36059UL,
      FI_EN_BN_KINEPOLIS = 36060UL,
      FI_EN_BN_KINETIC_ENGINEERING = 36061UL,
      FI_EN_BN_KING_SOOPERS_PHARMACY = 36062UL,
      FI_EN_BN_KINGS_FAMILY_RESTAURANTS = 36063UL,
      FI_EN_BN_KINGS_SUPER_MARKETS = 36064UL,
      FI_EN_BN_KINOPLEX = 36065UL,
      FI_EN_BN_KIPA = 36066UL,
      FI_EN_BN_KIWI = 36067UL,
      FI_EN_BN_KLEIDERBAUER = 36068UL,
      FI_EN_BN_KLUBPETROL = 36069UL,
      FI_EN_BN_K_MARKET = 36070UL,
      FI_EN_BN_KMART_PHARMACY = 36071UL,
      FI_EN_BN_KMART = 36072UL,
      FI_EN_BN_KMOIL = 36073UL,
      FI_EN_BN_KM_PRONA = 36074UL,
      FI_EN_BN_KNAUBER = 36075UL,
      FI_EN_BN_KNOWFAT_LIFESTYLE_GRILLE = 36076UL,
      FI_EN_BN_KOA = 36077UL,
      FI_EN_BN_KOBIL = 36078UL,
      FI_EN_BN_KODI = 36079UL,
      FI_EN_BN_KOHLS = 36080UL,
      FI_EN_BN_KOELNER_BANK = 36081UL,
      FI_EN_BN_KOMART = 36082UL,
      FI_EN_BN_KOMERCNI_BANKA = 36083UL,
      FI_EN_BN_KOMMUNALKREDIT = 36084UL,
      FI_EN_BN_KONMAR = 36085UL,
      FI_EN_BN_KONSUM = 36086UL,
      FI_EN_BN_KONTAKT = 36087UL,
      FI_EN_BN_KONTANTEN = 36088UL,
      FI_EN_BN_KONYALI_HACI_USTA = 36089UL,
      FI_EN_BN_KONZUM = 36090UL,
      FI_EN_BN_KOO_KOO_ROO = 36091UL,
      FI_EN_BN_KOPEYKA = 36092UL,
      FI_EN_BN_KORUS = 36093UL,
      FI_EN_BN_KOSEBASI = 36094UL,
      FI_EN_BN_KOTAK_MAHINDRA_BANK = 36095UL,
      FI_EN_BN_KOTIPIZZA = 36096UL,
      FI_EN_BN_KOTSOVOLOS = 36097UL,
      FI_EN_BN_KOZMO = 36098UL,
      FI_EN_BN_KRAGEN_AUTO_PARTS = 36099UL,
      FI_EN_BN_KRAKOWSKI_BANK_SPOLDZIELCZY = 36100UL,
      FI_EN_BN_KREDIIDIPANK = 36101UL,
      FI_EN_BN_KREDIT_EVROPA_BANK = 36102UL,
      FI_EN_BN_KREDYT_BANK = 36103UL,
      FI_EN_BN_KREFEL = 36104UL,
      FI_EN_BN_KREISSPARKASSE_AHRWEILER = 36105UL,
      FI_EN_BN_KREISSPARKASSE_AUGSBURG = 36106UL,
      FI_EN_BN_KREISSPARKASSE_BITBURG_PRUEM = 36107UL,
      FI_EN_BN_KREISSPARKASSE_BOEBLINGEN = 36108UL,
      FI_EN_BN_KREISSPARKASSE_COCHEM_ZELL = 36109UL,
      FI_EN_BN_KREISSPARKASSE_ESSLINGEN_NUERTINGEN = 36110UL,
      FI_EN_BN_KREISSPARKASSE_FREUDENSTADT = 36111UL,
      FI_EN_BN_KREISSPARKASSE_GOEPPINGEN = 36112UL,
      FI_EN_BN_KREISSPARKASSE_GROSS_GERAU = 36113UL,
      FI_EN_BN_KREISSPARKASSE_HEILBRONN = 36114UL,
      FI_EN_BN_KREISSPARKASSE_HEINSBERG_ERKELENZ = 36115UL,
      FI_EN_BN_KREISSPARKASSE_KOELN = 36116UL,
      FI_EN_BN_KREISSPARKASSE_LUDWIGSBURG = 36117UL,
      FI_EN_BN_KREISSPARKASSE_MAYEN = 36118UL,
      FI_EN_BN_KREISSPARKASSE_MUENCHEN_STARNBERG = 36119UL,
      FI_EN_BN_KREISSPARKASSE_REUTLINGEN = 36120UL,
      FI_EN_BN_KREISSPARKASSE_SYKE = 36121UL,
      FI_EN_BN_KREISSPARKASSE_TUEBINGEN = 36122UL,
      FI_EN_BN_KREISSPARKASSE_TUTTLINGEN = 36123UL,
      FI_EN_BN_KREISSPARKASSE_WAIBLINGEN = 36124UL,
      FI_EN_BN_KREISSPARKASSE_WESERMUENDE_HADELN = 36125UL,
      FI_EN_BN_KRISPY_KREME = 36126UL,
      FI_EN_BN_KROGER_PHARMACY = 36127UL,
      FI_EN_BN_KROGER = 36128UL,
      FI_EN_BN_KRONOS = 36129UL,
      FI_EN_BN_KROSHKA_KARTOSHKA = 36130UL,
      FI_EN_BN_KRUIDVAT = 36131UL,
      FI_EN_BN_KRUZHKA = 36132UL,
      FI_EN_BN_KRYSTAL = 36133UL,
      FI_EN_BN_K_SUPERMARKET = 36134UL,
      FI_EN_BN_KUECHENTREFF = 36135UL,
      FI_EN_BN_KUDU = 36136UL,
      FI_EN_BN_KUTXA = 36137UL,
      FI_EN_BN_KUVEYTTURK = 36138UL,
      FI_EN_BN_KVARTAL = 36139UL,
      FI_EN_BN_KVICKLY = 36140UL,
      FI_EN_BN_KWIK_SAVE = 36141UL,
      FI_EN_BN_KWIK_FIT = 36142UL,
      FI_EN_BN_KYOTO_BOWL = 36143UL,
      FI_EN_BN_KYRIAD_PRESTIGE = 36144UL,
      FI_EN_BN_KYRIAD = 36145UL,
      FI_EN_BN_L_L_HAWAIIAN_BARBECUE = 36146UL,
      FI_EN_BN_LA_BAMBA = 36147UL,
      FI_EN_BN_LA_BANQUE_POSTALE = 36148UL,
      FI_EN_BN_LA_BELLE_PROVINCE = 36149UL,
      FI_EN_BN_LA_BOUCHERIE = 36150UL,
      FI_EN_BN_LA_CAGE_AUX_SPORTS = 36151UL,
      FI_EN_BN_LA_CAIXA = 36152UL,
      FI_EN_BN_LA_CAJA_DE_CANARIAS = 36153UL,
      FI_EN_BN_LA_CRIEE = 36154UL,
      FI_EN_BN_LA_FOIRFOUILLE = 36155UL,
      FI_EN_BN_LA_FOURMI = 36156UL,
      FI_EN_BN_LA_GRANDE_RECRE = 36157UL,
      FI_EN_BN_LA_MANSION = 36158UL,
      FI_EN_BN_LA_PASTERIA = 36159UL,
      FI_EN_BN_LA_PLATEFORME_DU_BATIMENT = 36160UL,
      FI_EN_BN_LA_QUINTA_INN_SUITES = 36161UL,
      FI_EN_BN_LA_QUINTA_INN = 36162UL,
      FI_EN_BN_LA_SALSA_FRESH_MEXICAN_GRILL = 36163UL,
      FI_EN_BN_LA_SALSA = 36164UL,
      FI_EN_BN_LA_SENZA = 36165UL,
      FI_EN_BN_LA_SIRENA = 36166UL,
      FI_EN_BN_LACOSTE = 36167UL,
      FI_EN_BN_LACTUCA = 36168UL,
      FI_EN_BN_LADY_FOOT_LOCKER = 36169UL,
      FI_EN_BN_LAIKI_BANK = 36170UL,
      FI_EN_BN_LAKSHMI_VILAS_BANK = 36171UL,
      FI_EN_BN_LALA_ARBON_CO_OP_BANK = 36172UL,
      FI_EN_BN_LANDBOUWKREDIET = 36173UL,
      FI_EN_BN_LANDESBANK_BADEN_WUERTTEMBERG = 36174UL,
      FI_EN_BN_LANDESBANK_BERLIN = 36175UL,
      FI_EN_BN_LANDESBAUSPARKASSE = 36176UL,
      FI_EN_BN_LANDESSPARKASSE_ZU_OLDENBURG = 36177UL,
      FI_EN_BN_LANDHOTELS = 36178UL,
      FI_EN_BN_LANDI = 36179UL,
      FI_EN_BN_LANDRYS_SEAFOOD_HOUSE = 36180UL,
      FI_EN_BN_LANDS_END = 36181UL,
      FI_EN_BN_LANDZEIT = 36182UL,
      FI_EN_BN_LANE_BRYANT = 36183UL,
      FI_EN_BN_LANIDOR = 36184UL,
      FI_EN_BN_LAENSFOERSAEKRINGAR = 36185UL,
      FI_EN_BN_LAPEYRE = 36186UL,
      FI_EN_BN_LAPIN_HOUSE = 36187UL,
      FI_EN_BN_LARCHE = 36188UL,
      FI_EN_BN_LARRYS_GIANT_SUBS = 36189UL,
      FI_EN_BN_LAS_ALITAS = 36190UL,
      FI_EN_BN_LAS_GAONERAS = 36191UL,
      FI_EN_BN_LASALLE_BANK = 36192UL,
      FI_EN_BN_LATEKO = 36193UL,
      FI_EN_BN_LATVIJAS_KRAJBANKA = 36194UL,
      FI_EN_BN_LATVIJAS_NAFTA = 36195UL,
      FI_EN_BN_LAUDAMOTION = 36196UL,
      FI_EN_BN_LAUREN = 36197UL,
      FI_EN_BN_LAURENTIAN_BANK = 36198UL,
      FI_EN_BN_LAUTO_E_LECLERC = 36199UL,
      FI_EN_BN_LAWTONS = 36200UL,
      FI_EN_BN_LCL = 36201UL,
      FI_EN_BN_LD_MARKET = 36202UL,
      FI_EN_BN_LE_BOEUF_JARDINIER = 36203UL,
      FI_EN_BN_LE_CHATEAU = 36204UL,
      FI_EN_BN_LE_MERIDIEN = 36205UL,
      FI_EN_BN_LE_PETIT_BOFINGER = 36206UL,
      FI_EN_BN_LEADER_PRICE = 36207UL,
      FI_EN_BN_LEADING_SMALL_HOTELS_OF_THE_WORLD = 36208UL,
      FI_EN_BN_LEASEPLAN = 36209UL,
      FI_EN_BN_LEE_ROY_SELMONS = 36210UL,
      FI_EN_BN_LEEANN_CHIN = 36211UL,
      FI_EN_BN_LEEDS_HOLBECK_BUILDING_SOCIETY = 36212UL,
      FI_EN_BN_LEEDS_BUILDING_SOCIETY = 36213UL,
      FI_EN_BN_LEEN_BAKKER = 36214UL,
      FI_EN_BN_LEGACY_HOTELS_RESORTS = 36215UL,
      FI_EN_BN_LEGAL_SEA_FOODS = 36216UL,
      FI_EN_BN_LENNYS_SUB_SHOP = 36217UL,
      FI_EN_BN_LENTA = 36218UL,
      FI_EN_BN_LENTZ_USA_MUFFLERS_BRAKES_SHOCKS = 36219UL,
      FI_EN_BN_LEON_DE_BRUXELLES = 36220UL,
      FI_EN_BN_LEONS = 36221UL,
      FI_EN_BN_LEPEEP_RESTAURANT = 36222UL,
      FI_EN_BN_LEROY_MERLIN = 36223UL,
      FI_EN_BN_LES_3_BRASSEURS = 36224UL,
      FI_EN_BN_LES_ROUTIERS = 36225UL,
      FI_EN_BN_LEVIS = 36226UL,
      FI_EN_BN_LEY = 36227UL,
      FI_EN_BN_LEYSIEFFER = 36228UL,
      FI_EN_BN_LIBERTY_BANK = 36229UL,
      FI_EN_BN_LIBERTY = 36230UL,
      FI_EN_BN_LIBRA_BANK = 36231UL,
      FI_EN_BN_LIDER = 36232UL,
      FI_EN_BN_LIDL = 36233UL,
      FI_EN_BN_LIDS = 36234UL,
      FI_EN_BN_LIECHTENSTEINISCHE_LANDESBANK_AG = 36235UL,
      FI_EN_BN_LIMITED_TOO = 36236UL,
      FI_EN_BN_LION_OF_PORCHES = 36237UL,
      FI_EN_BN_LIONS_CHOICE = 36238UL,
      FI_EN_BN_LIPPO_BANK = 36239UL,
      FI_EN_BN_LITTLE_CAESARS = 36240UL,
      FI_EN_BN_LIZ_CLAIBORNE = 36241UL,
      FI_EN_BN_LIZARRAN = 36242UL,
      FI_EN_BN_LLANO_PETROL = 36243UL,
      FI_EN_BN_LLOYDS_TSB = 36244UL,
      FI_EN_BN_LMG = 36245UL,
      FI_EN_BN_LML_INDIA = 36246UL,
      FI_EN_BN_LOBLAWS = 36247UL,
      FI_EN_BN_LOCALIZA = 36248UL,
      FI_EN_BN_LOCATEL = 36249UL,
      FI_EN_BN_LOGANS_ROADHOUSE = 36250UL,
      FI_EN_BN_LOKALBRUGSEN = 36251UL,
      FI_EN_BN_LOLLICUP_COFFEE_TEA = 36252UL,
      FI_EN_BN_LOMO = 36253UL,
      FI_EN_BN_LONDIS = 36254UL,
      FI_EN_BN_LONDON_DRUGS = 36255UL,
      FI_EN_BN_LONE_STAR_STEAKHOUSE_SALOON = 36256UL,
      FI_EN_BN_LONG_JOHN_SILVERS = 36257UL,
      FI_EN_BN_LONGHORN_STEAKHOUSE = 36258UL,
      FI_EN_BN_LONGOS = 36259UL,
      FI_EN_BN_LONGS_DRUGS = 36260UL,
      FI_EN_BN_LORAN_CAR_RENTAL = 36261UL,
      FI_EN_BN_LORD_KRISHNA_BANK = 36262UL,
      FI_EN_BN_LOS_ARCOS = 36263UL,
      FI_EN_BN_LOS_BISQUETS_BISQUETS_OBREGON = 36264UL,
      FI_EN_BN_LOTOS = 36265UL,
      FI_EN_BN_LOUIS_DELHAIZE = 36266UL,
      FI_EN_BN_LOWES = 36267UL,
      FI_EN_BN_LS_UK_ = 36268UL,
      FI_EN_BN_LUBYS = 36269UL,
      FI_EN_BN_LUCAS_SERVICE = 36270UL,
      FI_EN_BN_LUCKY_CINEMA = 36271UL,
      FI_EN_BN_LUCKYS_CAFE = 36272UL,
      FI_EN_BN_LUDENDO_VILLAGE = 36273UL,
      FI_EN_BN_LUDOVA_BANKA = 36274UL,
      FI_EN_BN_LUHMANN_TANKSTELLEN = 36275UL,
      FI_EN_BN_LUKAS_BANK = 36276UL,
      FI_EN_BN_LUKOIL = 36277UL,
      FI_EN_BN_LUMIERE = 36278UL,
      FI_EN_BN_LUNCH_GARDEN = 36279UL,
      FI_EN_BN_LUPA = 36280UL,
      FI_EN_BN_LUPILLOS = 36281UL,
      FI_EN_BN_LUSITANA = 36282UL,
      FI_EN_BN_LUSITANIA = 36283UL,
      FI_EN_BN_LUSSILE = 36284UL,
      FI_EN_BN_LUTHERS = 36285UL,
      FI_EN_BN_LUXAUTO = 36286UL,
      FI_EN_BN_LUXURY_COLLECTION_ARABELLA_ = 36287UL,
      FI_EN_BN_LUXURY_COLLECTION = 36288UL,
      FI_EN_BN_LUZERNER_KANTONALBANK = 36289UL,
      FI_EN_BN_LYON_PARC_AUTO = 36290UL,
      FI_EN_BN_M_I_BANK = 36291UL,
      FI_EN_BN_M_M_MEAT_SHOP = 36292UL,
      FI_EN_BN_M_S = 36293UL,
      FI_EN_BN_M_T_BANK = 36294UL,
      FI_EN_BN_MAACO = 36295UL,
      FI_EN_BN_MACE = 36296UL,
      FI_EN_BN_MACEWEN = 36297UL,
      FI_EN_BN_MACHEEZMO_MOUSE = 36298UL,
      FI_EN_BN_MACRO = 36299UL,
      FI_EN_BN_MACROCENTER = 36300UL,
      FI_EN_BN_MACS = 36301UL,
      FI_EN_BN_MACYS = 36302UL,
      FI_EN_BN_MADE_IN_JAPAN = 36303UL,
      FI_EN_BN_MAGGIANOS = 36304UL,
      FI_EN_BN_MAGGIORE = 36305UL,
      FI_EN_BN_MAGIC_LIFE = 36306UL,
      FI_EN_BN_MAGNET = 36307UL,
      FI_EN_BN_MAGNIT = 36308UL,
      FI_EN_BN_MAGNOLIYA = 36309UL,
      FI_EN_BN_MAHALAXMI_BANK = 36310UL,
      FI_EN_BN_MAHANAGAR_CO_OP_BANK = 36311UL,
      FI_EN_BN_MAHANAGAR = 36312UL,
      FI_EN_BN_MAHINDRA = 36313UL,
      FI_EN_BN_MAIDENFORM = 36314UL,
      FI_EN_BN_MAINSTAY_SUITES = 36315UL,
      FI_EN_BN_MAINZER_VOLKSBANK = 36316UL,
      FI_EN_BN_MAKPETROL = 36317UL,
      FI_EN_BN_MAKRO = 36318UL,
      FI_EN_BN_MAKROMARKET = 36319UL,
      FI_EN_BN_MAM_LIMITED = 36320UL,
      FI_EN_BN_MAN = 36321UL,
      FI_EN_BN_MANASEER = 36322UL,
      FI_EN_BN_MANCHU_WOK = 36323UL,
      FI_EN_BN_MANCINOS_PIZZA_GRINDERS = 36324UL,
      FI_EN_BN_MANDARIN_ORIENTAL = 36325UL,
      FI_EN_BN_MANGO = 36326UL,
      FI_EN_BN_MANIA = 36327UL,
      FI_EN_BN_MANOR = 36328UL,
      FI_EN_BN_MANSINGH_GROUP = 36329UL,
      FI_EN_BN_MARBLE_SLAB_CREAMERY = 36330UL,
      FI_EN_BN_MARCHE_PLUS = 36331UL,
      FI_EN_BN_MARCHE_U = 36332UL,
      FI_EN_BN_MARCONFORT = 36333UL,
      FI_EN_BN_MARCOS_PIZZA = 36334UL,
      FI_EN_BN_MAREDO = 36335UL,
      FI_EN_BN_MAREES = 36336UL,
      FI_EN_BN_MARFIN_BANK = 36337UL,
      FI_EN_BN_MARFIN_EGNATIA_BANK = 36338UL,
      FI_EN_BN_MARGHERITA = 36339UL,
      FI_EN_BN_MARIE_CALLENDERS = 36340UL,
      FI_EN_BN_MARINOPOULOS = 36341UL,
      FI_EN_BN_MARK_PIS = 36342UL,
      FI_EN_BN_MARK = 36343UL,
      FI_EN_BN_MARKA = 36344UL,
      FI_EN_BN_MARKANTALO = 36345UL,
      FI_EN_BN_MARKS_SPENCER = 36346UL,
      FI_EN_BN_MARKS_WORK_WEARHOUSE = 36347UL,
      FI_EN_BN_MARKTKAUF = 36348UL,
      FI_EN_BN_MARRACHINHO = 36349UL,
      FI_EN_BN_MARRIOTT_VACATION_CLUB = 36350UL,
      FI_EN_BN_MARSHALL_ILSLEY_CORP = 36351UL,
      FI_EN_BN_MARSHALLS = 36352UL,
      FI_EN_BN_MARTINS_DRUGSTORE = 36353UL,
      FI_EN_BN_MARTINS_FOOD_MARKETS = 36354UL,
      FI_EN_BN_MARTINS_GASOLINE = 36355UL,
      FI_EN_BN_MARUTI = 36356UL,
      FI_EN_BN_MARY_BROWNS_FRIED_CHICKEN = 36357UL,
      FI_EN_BN_MAS_Y_MAS = 36358UL,
      FI_EN_BN_MAS = 36359UL,
      FI_EN_BN_MASKOMO = 36360UL,
      FI_EN_BN_MASOUTIS = 36361UL,
      FI_EN_BN_MASSIMO_DUTTI = 36362UL,
      FI_EN_BN_MASTER_BANK = 36363UL,
      FI_EN_BN_MASTERFIT = 36364UL,
      FI_EN_BN_MASYMAS = 36365UL,
      FI_EN_BN_MATOEPPET = 36366UL,
      FI_EN_BN_MATOU_FRANCE = 36367UL,
      FI_EN_BN_MAURICES_BBQ = 36368UL,
      FI_EN_BN_MAX_ERMAS = 36369UL,
      FI_EN_BN_MAX_BAHR = 36370UL,
      FI_EN_BN_MAX = 36371UL,
      FI_EN_BN_MAXCOOP = 36372UL,
      FI_EN_BN_MAXI = 36373UL,
      FI_EN_BN_MAXIMA = 36374UL,
      FI_EN_BN_MAXMAT = 36375UL,
      FI_EN_BN_MAXRAVE = 36376UL,
      FI_EN_BN_MAYBANK = 36377UL,
      FI_EN_BN_MAZATLAN_MEXICAN_RESTAURANT = 36378UL,
      FI_EN_BN_MAZZIOS = 36379UL,
      FI_EN_BN_MB_FINANCIAL = 36380UL,
      FI_EN_BN_MBANK = 36381UL,
      FI_EN_BN_MBNA_CORP = 36382UL,
      FI_EN_BN_MBRR = 36383UL,
      FI_EN_BN_MCALISTERS_DELI = 36384UL,
      FI_EN_BN_MCCORMICK_SCHMICKS = 36385UL,
      FI_EN_BN_MCD = 36386UL,
      FI_EN_BN_MCDONALDS = 36387UL,
      FI_EN_BN_MCL_CAFETERIA = 36388UL,
      FI_EN_BN_MDM_BANK = 36389UL,
      FI_EN_BN_ME_BY_MELIA = 36390UL,
      FI_EN_BN_MEDAS = 36391UL,
      FI_EN_BN_MEDEIA = 36392UL,
      FI_EN_BN_MEDIA_MARKT = 36393UL,
      FI_EN_BN_MEDIA_WORLD = 36394UL,
      FI_EN_BN_MEDIAN_HOTELS = 36395UL,
      FI_EN_BN_MEDICINE_SHOPPE = 36396UL,
      FI_EN_BN_MEDICINOS_BANKAS = 36397UL,
      FI_EN_BN_MEDIMAX = 36398UL,
      FI_EN_BN_MEDIUM_HOTELES = 36399UL,
      FI_EN_BN_MEDOIL = 36400UL,
      FI_EN_BN_MEDUSA_CINEMA = 36401UL,
      FI_EN_BN_MEGA_CGR = 36402UL,
      FI_EN_BN_MEGA_MARINA = 36403UL,
      FI_EN_BN_MEGA_WRAPS = 36404UL,
      FI_EN_BN_MEGA_OYL = 36405UL,
      FI_EN_BN_MEGO = 36406UL,
      FI_EN_BN_MEIJER_GAS_STATION = 36407UL,
      FI_EN_BN_MEIJER_PHARMACY = 36408UL,
      FI_EN_BN_MEINEKE_CAR_CARE_CENTER = 36409UL,
      FI_EN_BN_MEKONOMEN = 36410UL,
      FI_EN_BN_MELIA_HOTELS_RESORTS = 36411UL,
      FI_EN_BN_MELLON = 36412UL,
      FI_EN_BN_MEMA = 36413UL,
      FI_EN_BN_MENARDS = 36414UL,
      FI_EN_BN_MENS_WEARHOUSE = 36415UL,
      FI_EN_BN_MENY = 36416UL,
      FI_EN_BN_MERCADONA = 36417UL,
      FI_EN_BN_MERCANTILE_BSHRS_CORP = 36418UL,
      FI_EN_BN_MERCATOR = 36419UL,
      FI_EN_BN_MERCHANTS_BANK = 36420UL,
      FI_EN_BN_MERIDIAN_CREDIT_UNION = 36421UL,
      FI_EN_BN_MERKUR = 36422UL,
      FI_EN_BN_MERLE_NORMAN = 36423UL,
      FI_EN_BN_MERRAL = 36424UL,
      FI_EN_BN_MERVYNS = 36425UL,
      FI_EN_BN_MESHUR_PEYNIRCI = 36426UL,
      FI_EN_BN_META = 36427UL,
      FI_EN_BN_METAX = 36428UL,
      FI_EN_BN_METEOR_PARKING = 36429UL,
      FI_EN_BN_METRO = 36430UL,
      FI_EN_BN_MEXX = 36431UL,
      FI_EN_BN_MGALLERY = 36432UL,
      FI_EN_BN_MI_VIEJO_PUEBLITO = 36433UL,
      FI_EN_BN_MIAMI_SUBS_GRILL = 36434UL,
      FI_EN_BN_MICROMANIA = 36435UL,
      FI_EN_BN_MICROTEL_INNS_SUITES = 36436UL,
      FI_EN_BN_MIDAS = 36437UL,
      FI_EN_BN_MIDFIRST_BANK = 36438UL,
      FI_EN_BN_MID_STATE_BANK_TRUST = 36439UL,
      FI_EN_BN_MIGATO = 36440UL,
      FI_EN_BN_MIGROS = 36441UL,
      FI_EN_BN_MIGROSBANK = 36442UL,
      FI_EN_BN_MILESTONES = 36443UL,
      FI_EN_BN_MILIOS_SANDWICHES = 36444UL,
      FI_EN_BN_MILLENIUM_BANK = 36445UL,
      FI_EN_BN_MILLENIUM = 36446UL,
      FI_EN_BN_MILLENNIUM_BANK = 36447UL,
      FI_EN_BN_MILLENNIUM_BCP = 36448UL,
      FI_EN_BN_MIMIS_CAFE = 36449UL,
      FI_EN_BN_MINI_PRECO = 36450UL,
      FI_EN_BN_MINIMAL = 36451UL,
      FI_EN_BN_MINIPRECO_DIA = 36452UL,
      FI_EN_BN_MINIPRECO = 36453UL,
      FI_EN_BN_MIRACLE_EAR = 36454UL,
      FI_EN_BN_MISAS = 36455UL,
      FI_EN_BN_MISR = 36456UL,
      FI_EN_BN_MISS_KAPRIZ = 36457UL,
      FI_EN_BN_MISSONI = 36458UL,
      FI_EN_BN_MISTER_LADY = 36459UL,
      FI_EN_BN_MISTER_PIZZA = 36460UL,
      FI_EN_BN_MISTER_TRANSMISSION = 36461UL,
      FI_EN_BN_MITCHELLS_FISH_MARKET = 36462UL,
      FI_EN_BN_MITSUOKA = 36463UL,
      FI_EN_BN_MITTELBRANDENBURGISCHE_SPARKASSE = 36464UL,
      FI_EN_BN_MK2 = 36465UL,
      FI_EN_BN_MKB_BANK = 36466UL,
      FI_EN_BN_MKB_ROMEXTERRA_BANK = 36467UL,
      FI_EN_BN_MKB_UNIONBANK = 36468UL,
      FI_EN_BN_MOEBELIX = 36469UL,
      FI_EN_BN_MOBISTAR_CENTER = 36470UL,
      FI_EN_BN_MOCA_LOCA = 36471UL,
      FI_EN_BN_MOCHA = 36472UL,
      FI_EN_BN_MODALFA = 36473UL,
      FI_EN_BN_MODELO = 36474UL,
      FI_EN_BN_MODERN = 36475UL,
      FI_EN_BN_MOES_SOUTHWEST_GRILL = 36476UL,
      FI_EN_BN_MOIL = 36477UL,
      FI_EN_BN_MOL = 36478UL,
      FI_EN_BN_MONICAL_PIZZA = 36479UL,
      FI_EN_BN_MONOP = 36480UL,
      FI_EN_BN_MONOPRIX = 36481UL,
      FI_EN_BN_MONRIF = 36482UL,
      FI_EN_BN_MONRO_MUFFLER_BRAKE_SERVICE = 36483UL,
      FI_EN_BN_MONTANA_MIKES = 36484UL,
      FI_EN_BN_MONTANAS = 36485UL,
      FI_EN_BN_MONTE_DEI_PASCHI_DI_SIENA = 36486UL,
      FI_EN_BN_MONTEPIO_GERAL = 36487UL,
      FI_EN_BN_MONTEPIO = 36488UL,
      FI_EN_BN_MONTO_MOTORS = 36489UL,
      FI_EN_BN_MONTSERRAT = 36490UL,
      FI_EN_BN_MOORES = 36491UL,
      FI_EN_BN_MOPAS = 36492UL,
      FI_EN_BN_MORRIS_OIL = 36493UL,
      FI_EN_BN_MORTONS = 36494UL,
      FI_EN_BN_MOSKOVSKIY_INDUSTRIALNIY_BANK = 36495UL,
      FI_EN_BN_MOSKVICH = 36496UL,
      FI_EN_BN_MOTEL_ONE = 36497UL,
      FI_EN_BN_MOTHERCARE = 36498UL,
      FI_EN_BN_MOTHERHOOD_MATERNITY = 36499UL,
      FI_EN_BN_MOVIE_STAR = 36500UL,
      FI_EN_BN_MOXIES = 36501UL,
      FI_EN_BN_MPREIS = 36502UL,
      FI_EN_BN_MR_BIGGS = 36503UL,
      FI_EN_BN_MR_CLUTCH = 36504UL,
      FI_EN_BN_MR_GOODCENTS_SUBS_PASTAS = 36505UL,
      FI_EN_BN_MR_HERO = 36506UL,
      FI_EN_BN_MR_JIMS_PIZZA = 36507UL,
      FI_EN_BN_MR_LUBE = 36508UL,
      FI_EN_BN_MR_MUFFLER = 36509UL,
      FI_EN_BN_MR_PITA = 36510UL,
      FI_EN_BN_MR_SMOOTHIE = 36511UL,
      FI_EN_BN_MR_SUB = 36512UL,
      FI_EN_BN_MR_BRICOLAGE = 36513UL,
      FI_EN_BN_MRS_FIELDS = 36514UL,
      FI_EN_BN_MRS_VANELLIS = 36515UL,
      FI_EN_BN_MTEL_IMAX_3D = 36516UL,
      FI_EN_BN_MTK = 36517UL,
      FI_EN_BN_MUELLER = 36518UL,
      FI_EN_BN_MULTIBANK = 36519UL,
      FI_EN_BN_MULTIBANKA = 36520UL,
      FI_EN_BN_MULTICAJA = 36521UL,
      FI_EN_BN_MULTIKINO = 36522UL,
      FI_EN_BN_MULTIMARKET = 36523UL,
      FI_EN_BN_MULTIPLEX_UNITED_NEW_CINEMA = 36524UL,
      FI_EN_BN_MUMBAI_DISTRICT_CENTRAL_CO_OP_BANK = 36525UL,
      FI_EN_BN_MU_MU = 36526UL,
      FI_EN_BN_MUNDICENTER = 36527UL,
      FI_EN_BN_MURPHY_EXPRESS = 36528UL,
      FI_EN_BN_MURPHY_USA = 36529UL,
      FI_EN_BN_MURPHYS_DELI = 36530UL,
      FI_EN_BN_MUSTANG_CINEMA = 36531UL,
      FI_EN_BN_MY_MARKET_METRO = 36532UL,
      FI_EN_BN_MY_SUITE_APPART_HOTELS = 36533UL,
      FI_EN_BN_N1 = 36534UL,
      FI_EN_BN_NACIONAL = 36535UL,
      FI_EN_BN_NAH_FRISCH = 36536UL,
      FI_EN_BN_NAIF_CHICKEN = 36537UL,
      FI_EN_BN_NAKHODKA = 36538UL,
      FI_EN_BN_NANDOS = 36539UL,
      FI_EN_BN_NANZ = 36540UL,
      FI_EN_BN_NAPA_AUTO_PARTS = 36541UL,
      FI_EN_BN_NAPA_AUTOCARE_CENTER = 36542UL,
      FI_EN_BN_NASSAUISCHE_SPARKASSE = 36543UL,
      FI_EN_BN_NATHANS_FAMOUS = 36544UL,
      FI_EN_BN_NATIONAL_ATESA = 36545UL,
      FI_EN_BN_NATIONAL_AUSTRALIA_BANK = 36546UL,
      FI_EN_BN_NATIONAL_BANK_OF_AGR_AND_DVLPT = 36547UL,
      FI_EN_BN_NATIONAL_BANK_OF_ARIZONA = 36548UL,
      FI_EN_BN_NATIONAL_BANK_OF_GREECE = 36549UL,
      FI_EN_BN_NATIONAL_BANK = 36550UL,
      FI_EN_BN_NATIONAL_CAR_PARKS = 36551UL,
      FI_EN_BN_NATIONAL_CAR_RENTAL = 36552UL,
      FI_EN_BN_NATIONAL_CITY_BANK = 36553UL,
      FI_EN_BN_NATIONAL_CO_OP_BANK = 36554UL,
      FI_EN_BN_NATIONAL_IRISH_BANK = 36555UL,
      FI_EN_BN_NATIONAL_OIL = 36556UL,
      FI_EN_BN_NATIONAL_TYRES_AUTOCARE = 36557UL,
      FI_EN_BN_NATIONAL_CITER = 36558UL,
      FI_EN_BN_NATIONWIDE_AUTOCENTRE = 36559UL,
      FI_EN_BN_NATIONWIDE_BUILDING_SOCIETY = 36560UL,
      FI_EN_BN_NATIONWIDE_CRASH_REPAIR_CENTRE = 36561UL,
      FI_EN_BN_NATUR_PRODUKT = 36562UL,
      FI_EN_BN_NATURASI = 36563UL,
      FI_EN_BN_NATURES_BASKET = 36564UL,
      FI_EN_BN_NATURES_TABLE_CAFE = 36565UL,
      FI_EN_BN_NATWEST = 36566UL,
      FI_EN_BN_NAZA = 36567UL,
      FI_EN_BN_NAZAR = 36568UL,
      FI_EN_BN_NBC_CAPITAL_CORP = 36569UL,
      FI_EN_BN_NCP = 36570UL,
      FI_EN_BN_NEDBANK = 36571UL,
      FI_EN_BN_NEEDS = 36572UL,
      FI_EN_BN_NEHODA_CZ = 36573UL,
      FI_EN_BN_NELDA = 36574UL,
      FI_EN_BN_NEOBANK = 36575UL,
      FI_EN_BN_NEOS_BANCA = 36576UL,
      FI_EN_BN_NESPRESSO = 36577UL,
      FI_EN_BN_NETTO = 36578UL,
      FI_EN_BN_NETTORAMA = 36579UL,
      FI_EN_BN_NEUE_AARGAUER_BANK = 36580UL,
      FI_EN_BN_NEVIS = 36581UL,
      FI_EN_BN_NEW_CHINA_BUFFET = 36582UL,
      FI_EN_BN_NEW_YORK_COMPANY = 36583UL,
      FI_EN_BN_NEW_YORK_COMMUNITY_BANK = 36584UL,
      FI_EN_BN_NEW_YORK_FRIES = 36585UL,
      FI_EN_BN_NEW_YORK_PIZZERIA = 36586UL,
      FI_EN_BN_NEW_YORKER = 36587UL,
      FI_EN_BN_NEWCASTLE_BUILDING_SOCIETY = 36588UL,
      FI_EN_BN_NEX = 36589UL,
      FI_EN_BN_NGVC = 36590UL,
      FI_EN_BN_NICKELODEON_FAMILY_SUITES = 36591UL,
      FI_EN_BN_NIDWALDNER_KANTONALBANK = 36592UL,
      FI_EN_BN_NIEDERMEYER = 36593UL,
      FI_EN_BN_NIEDEROESTERREICHISCHE_LANDESBANK = 36594UL,
      FI_EN_BN_NIKE = 36595UL,
      FI_EN_BN_NILGIRIS = 36596UL,
      FI_EN_BN_NINE_WEST = 36597UL,
      FI_EN_BN_NIS = 36598UL,
      FI_EN_BN_NISA = 36599UL,
      FI_EN_BN_NKD = 36600UL,
      FI_EN_BN_NO_FRILLS = 36601UL,
      FI_EN_BN_NOAL_OIL = 36602UL,
      FI_EN_BN_NOB_HILL_FOODS = 36603UL,
      FI_EN_BN_NOKIA = 36604UL,
      FI_EN_BN_NOMOS_BANK = 36605UL,
      FI_EN_BN_NOODLES_COMPANY = 36606UL,
      FI_EN_BN_NOR_HOTELS = 36607UL,
      FI_EN_BN_NORAUTO = 36608UL,
      FI_EN_BN_NORD_LB = 36609UL,
      FI_EN_BN_NORDDEUTSCHE_LANDESBANK = 36610UL,
      FI_EN_BN_NORDEA = 36611UL,
      FI_EN_BN_NORDISK_FILM = 36612UL,
      FI_EN_BN_NORDJYSKE_BANK = 36613UL,
      FI_EN_BN_NORDSEE = 36614UL,
      FI_EN_BN_NORDSTROM = 36615UL,
      FI_EN_BN_NORFA = 36616UL,
      FI_EN_BN_NORISBANK = 36617UL,
      FI_EN_BN_NORMA = 36618UL,
      FI_EN_BN_NORSK_KINO = 36619UL,
      FI_EN_BN_NORTH_KANARA_GSB_CO_OP_BANK = 36620UL,
      FI_EN_BN_NORTHEAST_BANK = 36621UL,
      FI_EN_BN_NORTHERN_BANK = 36622UL,
      FI_EN_BN_NORTHERN_REFLECTIONS = 36623UL,
      FI_EN_BN_NORTHERN_ROCK = 36624UL,
      FI_EN_BN_NORTHERN_TRUST = 36625UL,
      FI_EN_BN_NORTHWEST_TIRE_SERVICE = 36626UL,
      FI_EN_BN_NORWICH_PETERBOROUGH_BS = 36627UL,
      FI_EN_BN_NOTHING_BUT_NOODLES = 36628UL,
      FI_EN_BN_NOTTINGHAM_BUILDING_SOCIETY = 36629UL,
      FI_EN_BN_NOVA_INVEST = 36630UL,
      FI_EN_BN_NOVA_KREDITNA_BANKA_MARIBOR = 36631UL,
      FI_EN_BN_NOVA_LJUBLJANSKA_BANKA = 36632UL,
      FI_EN_BN_NOVABANK = 36633UL,
      FI_EN_BN_NOVGORODNEFTEPRODUKT = 36634UL,
      FI_EN_BN_NOVO = 36635UL,
      FI_EN_BN_NOVOSIBIRSKNEFTEPRODUKT = 36636UL,
      FI_EN_BN_NP_MARKT = 36637UL,
      FI_EN_BN_NU_METRO = 36638UL,
      FI_EN_BN_NUNEZ_I_NAVARRO_HOTELS = 36639UL,
      FI_EN_BN_O_MAMMA_MIA = 36640UL,
      FI_EN_BN_O_SHIPKA = 36641UL,
      FI_EN_BN_OANDO = 36642UL,
      FI_EN_BN_OB = 36643UL,
      FI_EN_BN_OBERBANK = 36644UL,
      FI_EN_BN_OBEROI = 36645UL,
      FI_EN_BN_OBI = 36646UL,
      FI_EN_BN_OBK = 36647UL,
      FI_EN_BN_OBSHTINSKA_BANKA = 36648UL,
      FI_EN_BN_OBWALDNER_KANTONALBANK = 36649UL,
      FI_EN_BN_OCCIDENTAL_HOTELES = 36650UL,
      FI_EN_BN_OCEAN_BASKET = 36651UL,
      FI_EN_BN_OCEANIA_HOTELS = 36652UL,
      FI_EN_BN_OCEANIC_BANK = 36653UL,
      FI_EN_BN_OCHARLEYS = 36654UL,
      FI_EN_BN_ODALYS = 36655UL,
      FI_EN_BN_ODEON = 36656UL,
      FI_EN_BN_OEKOTEL = 36657UL,
      FI_EN_BN_OERAL = 36658UL,
      FI_EN_BN_OFFICE_DEPOT = 36659UL,
      FI_EN_BN_OFFICEMAX = 36660UL,
      FI_EN_BN_OIL_ = 36661UL,
      FI_EN_BN_OILIBYA = 36662UL,
      FI_EN_BN_OK_GROCER = 36663UL,
      FI_EN_BN_OK_TIRE = 36664UL,
      FI_EN_BN_OKEY = 36665UL,
      FI_EN_BN_OKTAN = 36666UL,
      FI_EN_BN_OLD_COUNTRY_BUFFET = 36667UL,
      FI_EN_BN_OLD_ENGLISH_INNS = 36668UL,
      FI_EN_BN_OLD_MUTUAL_BANK = 36669UL,
      FI_EN_BN_OLD_NAVY = 36670UL,
      FI_EN_BN_OLDENBURGISCHE_LANDESBANK = 36671UL,
      FI_EN_BN_OLEARYS = 36672UL,
      FI_EN_BN_OLEREX = 36673UL,
      FI_EN_BN_OLGA = 36674UL,
      FI_EN_BN_OLGAS_KITCHEN = 36675UL,
      FI_EN_BN_OLIS = 36676UL,
      FI_EN_BN_OLIVE_GARDEN = 36677UL,
      FI_EN_BN_OLIVIER_STRELLI = 36678UL,
      FI_EN_BN_OLYMPIA_SPORTS = 36679UL,
      FI_EN_BN_OMAN_OIL = 36680UL,
      FI_EN_BN_OMNI_HOTELS = 36681UL,
      FI_EN_BN_OMNIPLEX = 36682UL,
      FI_EN_BN_OMV_ISTRABENZ = 36683UL,
      FI_EN_BN_ON_THE_BORDER = 36684UL,
      FI_EN_BN_ONCE_UPON_A_CHILD = 36685UL,
      FI_EN_BN_ONCU = 36686UL,
      FI_EN_BN_ONOFF = 36687UL,
      FI_EN_BN_OPENBANK = 36688UL,
      FI_EN_BN_OPENCOR = 36689UL,
      FI_EN_BN_OPET = 36690UL,
      FI_EN_BN_ORANGE_JULIUS = 36691UL,
      FI_EN_BN_ORBIS = 36692UL,
      FI_EN_BN_ORCHARD_SUPPLY_HARDWARE = 36693UL,
      FI_EN_BN_OREA = 36694UL,
      FI_EN_BN_OREILLY_AUTO_PARTS = 36695UL,
      FI_EN_BN_ORGA = 36696UL,
      FI_EN_BN_ORIENTAL_BANK_OF_COMMERCE = 36697UL,
      FI_EN_BN_ORIGINAL_PANCAKE_HOUSE = 36698UL,
      FI_EN_BN_ORKAN = 36699UL,
      FI_EN_BN_ORLEANS_GESTION = 36700UL,
      FI_EN_BN_ORSAY = 36701UL,
      FI_EN_BN_OSCO_DRUG = 36702UL,
      FI_EN_BN_OSHKOSH_BGOSH = 36703UL,
      FI_EN_BN_OSLO_KINEMATOGRAFER = 36704UL,
      FI_EN_BN_OESTERREICHISCHE_VERKEHRSKREDITBANK = 36705UL,
      FI_EN_BN_OESTGOETA_ENSKILDA_BANK = 36706UL,
      FI_EN_BN_OSTSEE_SPARKASSE_ROSTOCK = 36707UL,
      FI_EN_BN_OSUUSPANKKI = 36708UL,
      FI_EN_BN_OTESHOP = 36709UL,
      FI_EN_BN_OTP_BANK = 36710UL,
      FI_EN_BN_OTP_BANKA = 36711UL,
      FI_EN_BN_OTTO = 36712UL,
      FI_EN_BN_OTTOS_AG = 36713UL,
      FI_EN_BN_OUTBACK_STEAKHOUSE = 36714UL,
      FI_EN_BN_OVER_RENT = 36715UL,
      FI_EN_BN_OVERSTOCK = 36716UL,
      FI_EN_BN_OYSHO = 36717UL,
      FI_EN_BN_OZTURK = 36718UL,
      FI_EN_BN_P1 = 36719UL,
      FI_EN_BN_PACSUN = 36720UL,
      FI_EN_BN_PACIFIC_WESTERN_NATIONAL_BANK = 36721UL,
      FI_EN_BN_PALACE_CINEMAS = 36722UL,
      FI_EN_BN_PAM = 36723UL,
      FI_EN_BN_PAMIDA = 36724UL,
      FI_EN_BN_PAN_PACIFIC = 36725UL,
      FI_EN_BN_PANAGO_PIZZA = 36726UL,
      FI_EN_BN_PANATSEYA = 36727UL,
      FI_EN_BN_PANCHEROS_MEXICAN_GRILL = 36728UL,
      FI_EN_BN_PANCHOS_MEXICAN_BUFFET = 36729UL,
      FI_EN_BN_PANDA_EXPRESS = 36730UL,
      FI_EN_BN_PANERA_BREAD = 36731UL,
      FI_EN_BN_PANIN_BANK = 36732UL,
      FI_EN_BN_PANORAMA = 36733UL,
      FI_EN_BN_PANS_CO = 36734UL,
      FI_EN_BN_PAO_DE_ACUCAR = 36735UL,
      FI_EN_BN_PAPA_GINOS = 36736UL,
      FI_EN_BN_PAPA_JOHNS = 36737UL,
      FI_EN_BN_PAPA_MURPHYS = 36738UL,
      FI_EN_BN_PAPA_ROMANOS = 36739UL,
      FI_EN_BN_PARADISUS_RESORTS = 36740UL,
      FI_EN_BN_PARCUS = 36741UL,
      FI_EN_BN_PAREX_BANKA = 36742UL,
      FI_EN_BN_PARITATE = 36743UL,
      FI_EN_BN_PARK_HYATT = 36744UL,
      FI_EN_BN_PARK_INN = 36745UL,
      FI_EN_BN_PARK_PLAZA_HOTELS_RESORTS = 36746UL,
      FI_EN_BN_PARK_RITE = 36747UL,
      FI_EN_BN_PARKCITY = 36748UL,
      FI_EN_BN_PARKING_EXPRESS = 36749UL,
      FI_EN_BN_PARROT_ICE = 36750UL,
      FI_EN_BN_PARTENER_ROMPETROL = 36751UL,
      FI_EN_BN_PARTSOURCE = 36752UL,
      FI_EN_BN_PASOIL = 36753UL,
      FI_EN_BN_PASTA_BRAVO = 36754UL,
      FI_EN_BN_PASTA_HOUSE_CO = 36755UL,
      FI_EN_BN_PASTA_POMODORO = 36756UL,
      FI_EN_BN_PASTA_YA_GOTCHA_ = 36757UL,
      FI_EN_BN_PASTAFIORE = 36758UL,
      FI_EN_BN_PASTARITO_PIZZARITO = 36759UL,
      FI_EN_BN_PAT_OSCARS = 36760UL,
      FI_EN_BN_PATERSON = 36761UL,
      FI_EN_BN_PATHE = 36762UL,
      FI_EN_BN_PATHMARK = 36763UL,
      FI_EN_BN_PATRIA = 36764UL,
      FI_EN_BN_PAX_BANK = 36765UL,
      FI_EN_BN_PAYLESS_CAR_RENTAL = 36766UL,
      FI_EN_BN_PAYLESS_SHOESOURCE = 36767UL,
      FI_EN_BN_PBZ = 36768UL,
      FI_EN_BN_PC_WORLD = 36769UL,
      FI_EN_BN_PDV = 36770UL,
      FI_EN_BN_PEEK_CLOPPENBURG = 36771UL,
      FI_EN_BN_PEETS_COFFEE_TEA = 36772UL,
      FI_EN_BN_PEHLIVANOGLU = 36773UL,
      FI_EN_BN_PEI_WEI_ASIAN_DINER = 36774UL,
      FI_EN_BN_PEMEX = 36775UL,
      FI_EN_BN_PENN_FEDERAL_SAVINGS_BANK = 36776UL,
      FI_EN_BN_PENN_STATION_EAST_COAST_SUBS = 36777UL,
      FI_EN_BN_PENNINGTONS = 36778UL,
      FI_EN_BN_PENNSTAR_BANK = 36779UL,
      FI_EN_BN_PENNZOIL_10_MINUTE_OIL_CHANGE = 36780UL,
      FI_EN_BN_PENSKE_AUTO_CENTER = 36781UL,
      FI_EN_BN_PENTO = 36782UL,
      FI_EN_BN_PEOPLES_BANK = 36783UL,
      FI_EN_BN_PEP_BOYS = 36784UL,
      FI_EN_BN_PEPECAR = 36785UL,
      FI_EN_BN_PEPES_MEXICAN_RESTAURANT = 36786UL,
      FI_EN_BN_PEPPERONI_GRILL = 36787UL,
      FI_EN_BN_PEPPES_PIZZA = 36788UL,
      FI_EN_BN_PEREKRYOSTOK = 36789UL,
      FI_EN_BN_PERFECT_PITA = 36790UL,
      FI_EN_BN_PERKINS = 36791UL,
      FI_EN_BN_PERMATA_BANK = 36792UL,
      FI_EN_BN_PERODUA = 36793UL,
      FI_EN_BN_PERTAMINA = 36794UL,
      FI_EN_BN_PERVAYA_POMOSHCH = 36795UL,
      FI_EN_BN_PESTANA = 36796UL,
      FI_EN_BN_PET_VALU = 36797UL,
      FI_EN_BN_PETIT_CASINO = 36798UL,
      FI_EN_BN_PETITE_SOPHISTICATE = 36799UL,
      FI_EN_BN_PETLINE = 36800UL,
      FI_EN_BN_PETRO_STOPPING_CENTERS = 36801UL,
      FI_EN_BN_PETRO_AERO_BANK = 36802UL,
      FI_EN_BN_PETROBRAS = 36803UL,
      FI_EN_BN_PETROCHEMIA_PLOCK = 36804UL,
      FI_EN_BN_PETROKOMMERTS = 36805UL,
      FI_EN_BN_PETROL_OFISI = 36806UL,
      FI_EN_BN_PETROL = 36807UL,
      FI_EN_BN_PETROM_V = 36808UL,
      FI_EN_BN_PETROM = 36809UL,
      FI_EN_BN_PETROMAR = 36810UL,
      FI_EN_BN_PETROMIN = 36811UL,
      FI_EN_BN_PETRONAS = 36812UL,
      FI_EN_BN_PETROTURK = 36813UL,
      FI_EN_BN_PEUGEOT_RENT = 36814UL,
      FI_EN_BN_PF_CHANGS_CHINA_BISTRO = 36815UL,
      FI_EN_BN_PHARMA_PLUS = 36816UL,
      FI_EN_BN_PHARMAPRIX = 36817UL,
      FI_EN_BN_PHARMASAVE = 36818UL,
      FI_EN_BN_PHARRO = 36819UL,
      FI_EN_BN_PHILLY_CONNECTION = 36820UL,
      FI_EN_BN_PHOTO_HALL = 36821UL,
      FI_EN_BN_PICCADILLY = 36822UL,
      FI_EN_BN_PICCADILY = 36823UL,
      FI_EN_BN_PICK_UP_STIX = 36824UL,
      FI_EN_BN_PICKN_PAY = 36825UL,
      FI_EN_BN_PICTUREHOUSE = 36826UL,
      FI_EN_BN_PIER_1_IMPORTS = 36827UL,
      FI_EN_BN_PIGGLY_WIGGLY = 36828UL,
      FI_EN_BN_PIM = 36829UL,
      FI_EN_BN_PINGO_DOCE = 36830UL,
      FI_EN_BN_PIOTR_I_PAWEL = 36831UL,
      FI_EN_BN_PIRAEUS_BANK = 36832UL,
      FI_EN_BN_PIT_STOP = 36833UL,
      FI_EN_BN_PITA_PIT = 36834UL,
      FI_EN_BN_PIZZA_73 = 36835UL,
      FI_EN_BN_PIZZA_DEL_ARTE = 36836UL,
      FI_EN_BN_PIZZA_DELIGHT = 36837UL,
      FI_EN_BN_PIZZA_FABRIKA = 36838UL,
      FI_EN_BN_PIZZA_FACTORY = 36839UL,
      FI_EN_BN_PIZZA_HUT = 36840UL,
      FI_EN_BN_PIZZA_INN = 36841UL,
      FI_EN_BN_PIZZA_ITALIA = 36842UL,
      FI_EN_BN_PIZZA_JAZZ = 36843UL,
      FI_EN_BN_PIZZA_MOVIL = 36844UL,
      FI_EN_BN_PIZZA_NOVA = 36845UL,
      FI_EN_BN_PIZZA_PAI = 36846UL,
      FI_EN_BN_PIZZA_PIZZA = 36847UL,
      FI_EN_BN_PIZZA_RANCH = 36848UL,
      FI_EN_BN_PIZZAVILLE = 36849UL,
      FI_EN_BN_PKO_BANK_POLSKI = 36850UL,
      FI_EN_BN_PLANET_SMOOTHIE = 36851UL,
      FI_EN_BN_PLANET_SUB = 36852UL,
      FI_EN_BN_PLANETA_SUSHI = 36853UL,
      FI_EN_BN_PLANTAGE_BOOKS_MORE = 36854UL,
      FI_EN_BN_PLAYLIFE = 36855UL,
      FI_EN_BN_PLAZA = 36856UL,
      FI_EN_BN_PLUS_SUPERDESCOMPTE = 36857UL,
      FI_EN_BN_PLUS_MARKT = 36858UL,
      FI_EN_BN_PLUS = 36859UL,
      FI_EN_BN_PM = 36860UL,
      FI_EN_BN_PMO = 36861UL,
      FI_EN_BN_PNC_BANK = 36862UL,
      FI_EN_BN_PNEUHAGE = 36863UL,
      FI_EN_BN_PODKARPACKI_BANK_SPOLDZIELCZY = 36864UL,
      FI_EN_BN_PODRAVSKA_BANKA = 36865UL,
      FI_EN_BN_POHONA_PH = 36866UL,
      FI_EN_BN_POIESZ = 36867UL,
      FI_EN_BN_POINT_S = 36868UL,
      FI_EN_BN_POINTP_TP = 36869UL,
      FI_EN_BN_POINTP = 36870UL,
      FI_EN_BN_POLBANK_EFG = 36871UL,
      FI_EN_BN_POLIS_PARK = 36872UL,
      FI_EN_BN_POLLO_FELIZ = 36873UL,
      FI_EN_BN_POLLO_TROPICAL = 36874UL,
      FI_EN_BN_POLLOS_RIO = 36875UL,
      FI_EN_BN_POLOMARKET = 36876UL,
      FI_EN_BN_POLUSHKA = 36877UL,
      FI_EN_BN_PONDEROSA = 36878UL,
      FI_EN_BN_PONT = 36879UL,
      FI_EN_BN_POPEYES = 36880UL,
      FI_EN_BN_POPULAR_ECOM = 36881UL,
      FI_EN_BN_PORT_OF_SUBS = 36882UL,
      FI_EN_BN_PORTMAN_BUILDING_SOCIETY = 36883UL,
      FI_EN_BN_PORTUGALIA = 36884UL,
      FI_EN_BN_POSTBANK = 36885UL,
      FI_EN_BN_POSTBANKEN = 36886UL,
      FI_EN_BN_POSTE_ITALIANE = 36887UL,
      FI_EN_BN_POSTEN = 36888UL,
      FI_EN_BN_POSTFINANCE = 36889UL,
      FI_EN_BN_POSTNA_BANKA_SLOVENIJE = 36890UL,
      FI_EN_BN_POSTOVA_BANKA = 36891UL,
      FI_EN_BN_POSTOVNI_SPORITELNA = 36892UL,
      FI_EN_BN_POTBELLY_SANDWICH_WORKS = 36893UL,
      FI_EN_BN_POTREFENA_HUSA = 36894UL,
      FI_EN_BN_POTUGALIA = 36895UL,
      FI_EN_BN_POTZOLLCALLI = 36896UL,
      FI_EN_BN_POUSADAS_DE_PORTUGAL = 36897UL,
      FI_EN_BN_PRAKTIKER = 36898UL,
      FI_EN_BN_PRAVEK = 36899UL,
      FI_EN_BN_PRECISION_AUTOMOTIVE = 36900UL,
      FI_EN_BN_PREMAMAN = 36901UL,
      FI_EN_BN_PREMIER_INN = 36902UL,
      FI_EN_BN_PREMIO = 36903UL,
      FI_EN_BN_PRENATAL = 36904UL,
      FI_EN_BN_PRESSBYRAN = 36905UL,
      FI_EN_BN_PRET_A_MANGER = 36906UL,
      FI_EN_BN_PRETZEL_TIME = 36907UL,
      FI_EN_BN_PRETZELMAKER = 36908UL,
      FI_EN_BN_PRICE_CHOPPER = 36909UL,
      FI_EN_BN_PRIDE_OF_BRITAIN = 36910UL,
      FI_EN_BN_PRIMA = 36911UL,
      FI_EN_BN_PRIME = 36912UL,
      FI_EN_BN_PRIMO = 36913UL,
      FI_EN_BN_PRINCES_RESORT_HOTELS = 36914UL,
      FI_EN_BN_PRINCIPALITY_BUILDING_SOCIETY = 36915UL,
      FI_EN_BN_PRISMA = 36916UL,
      FI_EN_BN_PRIVATBANK = 36917UL,
      FI_EN_BN_PRIVATBANKA = 36918UL,
      FI_EN_BN_PROBANK = 36919UL,
      FI_EN_BN_PROBANKA = 36920UL,
      FI_EN_BN_PROCREDIT_BANK = 36921UL,
      FI_EN_BN_PROFI = 36922UL,
      FI_EN_BN_PROFILE_TYRECENTER = 36923UL,
      FI_EN_BN_PROMO_FASHION = 36924UL,
      FI_EN_BN_PROMSVYAZBANK = 36925UL,
      FI_EN_BN_PRONTI = 36926UL,
      FI_EN_BN_PROTON = 36927UL,
      FI_EN_BN_PROVIGO = 36928UL,
      FI_EN_BN_PROXI = 36929UL,
      FI_EN_BN_PROXIM = 36930UL,
      FI_EN_BN_PROXY_DELHAIZE = 36931UL,
      FI_EN_BN_PSD_BANK = 36932UL,
      FI_EN_BN_PSK_BANK = 36933UL,
      FI_EN_BN_PSS_SPOLEM = 36934UL,
      FI_EN_BN_PTK = 36935UL,
      FI_EN_BN_PUBLIX_PIX = 36936UL,
      FI_EN_BN_PUBLIX = 36937UL,
      FI_EN_BN_PUERTO_CRISTO = 36938UL,
      FI_EN_BN_PULL_BEAR = 36939UL,
      FI_EN_BN_PUM_PLASTIQUES = 36940UL,
      FI_EN_BN_PUMP = 36941UL,
      FI_EN_BN_PUNE_PEOPLE_CO_OP_BANK = 36942UL,
      FI_EN_BN_PUNE_URBAN_CO_OP_BANK = 36943UL,
      FI_EN_BN_PUNE_ZILLA_MADHYAVARTI_SAHAKARI = 36944UL,
      FI_EN_BN_PUNJAB_MAHARASHTRA_CO_OP_BANK = 36945UL,
      FI_EN_BN_PUNJAB_SIND_BANK = 36946UL,
      FI_EN_BN_PUNJAB_NATIONAL_BANK = 36947UL,
      FI_EN_BN_PUNTO_DI = 36948UL,
      FI_EN_BN_PUNTO_SMA = 36949UL,
      FI_EN_BN_PYATYOROCHKA = 36950UL,
      FI_EN_BN_Q1 = 36951UL,
      FI_EN_BN_Q8_EASY = 36952UL,
      FI_EN_BN_QDOBA = 36953UL,
      FI_EN_BN_Q_PARK = 36954UL,
      FI_EN_BN_QSTAR = 36955UL,
      FI_EN_BN_QUAKER_STEAK_LUBE = 36956UL,
      FI_EN_BN_QUALITY_INN = 36957UL,
      FI_EN_BN_QUEBRAMAR = 36958UL,
      FI_EN_BN_QUENTIN = 36959UL,
      FI_EN_BN_QUESTER = 36960UL,
      FI_EN_BN_QUICK_RENT = 36961UL,
      FI_EN_BN_QUICK = 36962UL,
      FI_EN_BN_QUIKSILVER = 36963UL,
      FI_EN_BN_QUINCYS = 36964UL,
      FI_EN_BN_QUIZNOS_SUB = 36965UL,
      FI_EN_BN_RADEF = 36966UL,
      FI_EN_BN_RABOBANK = 36967UL,
      FI_EN_BN_RADIO_KORASIDI = 36968UL,
      FI_EN_BN_RADIO_POPULAR = 36969UL,
      FI_EN_BN_RADIOSHACK = 36970UL,
      FI_EN_BN_RADISSON_EDWARDIAN_HOTELS = 36971UL,
      FI_EN_BN_RADISSON_HOTELS_RESORTS = 36972UL,
      FI_EN_BN_RADISSON_SAS_HOTELS_RESORTS = 36973UL,
      FI_EN_BN_RADUGA = 36974UL,
      FI_EN_BN_RAFAEL_HOTELES = 36975UL,
      FI_EN_BN_RAFFERTYS = 36976UL,
      FI_EN_BN_RAIFFEISEN_BANK = 36977UL,
      FI_EN_BN_RAI_INTERNACIONAL = 36978UL,
      FI_EN_BN_RAINFOREST_CAFE = 36979UL,
      FI_EN_BN_RAKHAT_LUKUM = 36980UL,
      FI_EN_BN_RALLYS = 36981UL,
      FI_EN_BN_RALPH_LAUREN = 36982UL,
      FI_EN_BN_RALPHS = 36983UL,
      FI_EN_BN_RAMSTORN = 36984UL,
      FI_EN_BN_RAN = 36985UL,
      FI_EN_BN_RAPID_FIT = 36986UL,
      FI_EN_BN_RAS_BANK = 36987UL,
      FI_EN_BN_RASTA = 36988UL,
      FI_EN_BN_RATIO = 36989UL,
      FI_EN_BN_RATNAKAR_BANK = 36990UL,
      FI_EN_BN_RAUTAKIRJA = 36991UL,
      FI_EN_BN_RBC_CENTURA_BANK = 36992UL,
      FI_EN_BN_RBC_ROYAL_BANK = 36993UL,
      FI_EN_BN_READY = 36994UL,
      FI_EN_BN_READYBANK_AG = 36995UL,
      FI_EN_BN_REAL = 36996UL,
      FI_EN_BN_RECORD = 36997UL,
      FI_EN_BN_RED_HOT_BLUE = 36998UL,
      FI_EN_BN_RED_LOBSTER = 36999UL,
      FI_EN_BN_RED_POINT_RENT = 37000UL,
      FI_EN_BN_RED_ROBIN = 37001UL,
      FI_EN_BN_REDFARMA = 37002UL,
      FI_EN_BN_REGAL_CINEMAS = 37003UL,
      FI_EN_BN_REGENT_HOTELS_RESORTS = 37004UL,
      FI_EN_BN_REGENT = 37005UL,
      FI_EN_BN_REGIONS = 37006UL,
      FI_EN_BN_REIFENCOM = 37007UL,
      FI_EN_BN_REIFF = 37008UL,
      FI_EN_BN_REISEBANK = 37009UL,
      FI_EN_BN_REITMANS = 37010UL,
      FI_EN_BN_RELAIS_CHATEAUX = 37011UL,
      FI_EN_BN_RELIANCE_FRESH = 37012UL,
      FI_EN_BN_RELIANCE = 37013UL,
      FI_EN_BN_REMA_1000 = 37014UL,
      FI_EN_BN_RENAULT_RENT = 37015UL,
      FI_EN_BN_RENO = 37016UL,
      FI_EN_BN_RENT_A_CAR_KOSMOS = 37017UL,
      FI_EN_BN_RENT_A_CAR = 37018UL,
      FI_EN_BN_RENTA_AVTO = 37019UL,
      FI_EN_BN_RENTAMOBILE = 37020UL,
      FI_EN_BN_REPOSTAR = 37021UL,
      FI_EN_BN_REPUBLIC_BANK_TRUST = 37022UL,
      FI_EN_BN_RESERVE_BANK_OF_INDIA = 37023UL,
      FI_EN_BN_RESIDENCE_INN = 37024UL,
      FI_EN_BN_RESTAUMARCHE = 37025UL,
      FI_EN_BN_RESTAURANT_CACTUS = 37026UL,
      FI_EN_BN_RESTAURANT_LE_CHESNOY_SA = 37027UL,
      FI_EN_BN_RESTAURANTE_SANBORNS = 37028UL,
      FI_EN_BN_REVALIS_EVER = 37029UL,
      FI_EN_BN_REVOIL = 37030UL,
      FI_EN_BN_REWE = 37031UL,
      FI_EN_BN_REXALL = 37032UL,
      FI_EN_BN_RHASA = 37033UL,
      FI_EN_BN_RHEINGOLD = 37034UL,
      FI_EN_BN_RIETUMU_BANKA = 37035UL,
      FI_EN_BN_RIGLA = 37036UL,
      FI_EN_BN_RIMI_HYPERMARKET = 37037UL,
      FI_EN_BN_RIMI_SUPERMARKET = 37038UL,
      FI_EN_BN_RIMI = 37039UL,
      FI_EN_BN_RINGHOTELS = 37040UL,
      FI_EN_BN_RIRA_OIL = 37041UL,
      FI_EN_BN_RITE_AID = 37042UL,
      FI_EN_BN_RITZ_CARLTON_CLUB = 37043UL,
      FI_EN_BN_ROADHOUSE_GRILL = 37044UL,
      FI_EN_BN_ROADY = 37045UL,
      FI_EN_BN_ROBEKS = 37046UL,
      FI_EN_BN_ROBYS = 37047UL,
      FI_EN_BN_ROCK_BOTTOM = 37048UL,
      FI_EN_BN_RODILLA = 37049UL,
      FI_EN_BN_ROGERS = 37050UL,
      FI_EN_BN_ROLO_BANCA_1473 = 37051UL,
      FI_EN_BN_ROLY_POLY = 37052UL,
      FI_EN_BN_ROMA_PIZZA = 37053UL,
      FI_EN_BN_ROMANA_MARKET = 37054UL,
      FI_EN_BN_ROMANIA_RENTACAR = 37055UL,
      FI_EN_BN_ROMANOS_MACARONI_GRILL = 37056UL,
      FI_EN_BN_ROMPETROL = 37057UL,
      FI_EN_BN_RONA = 37058UL,
      FI_EN_BN_ROOTS = 37059UL,
      FI_EN_BN_ROSAS_CAFE = 37060UL,
      FI_EN_BN_ROSATIS_PIZZA = 37061UL,
      FI_EN_BN_ROSBANK = 37062UL,
      FI_EN_BN_ROSNEFT = 37063UL,
      FI_EN_BN_ROSS_DRESS_FOR_LESS = 37064UL,
      FI_EN_BN_ROSSELKHOZBANK = 37065UL,
      FI_EN_BN_ROSSMANN = 37066UL,
      FI_EN_BN_ROSSO = 37067UL,
      FI_EN_BN_ROSTIKS = 37068UL,
      FI_EN_BN_ROTH = 37069UL,
      FI_EN_BN_ROUND_TABLE_PIZZA = 37070UL,
      FI_EN_BN_ROY_ROGERS = 37071UL,
      FI_EN_BN_ROYAL_BANK_OF_SCOTLAND = 37072UL,
      FI_EN_BN_ROYAL_ENFIELD = 37073UL,
      FI_EN_BN_ROYS = 37074UL,
      FI_EN_BN_RUBIOS_FRESH_MEXICAN_GRILL = 37075UL,
      FI_EN_BN_RUBY_TUESDAY = 37076UL,
      FI_EN_BN_RUBYS_DINER = 37077UL,
      FI_EN_BN_RUE21 = 37078UL,
      FI_EN_BN_RUGGED_BEAR = 37079UL,
      FI_EN_BN_RUMBI_ISLAND_GRILL = 37080UL,
      FI_EN_BN_RUPEE_CO_OP_BANK = 37081UL,
      FI_EN_BN_RURAL_KUTXA = 37082UL,
      FI_EN_BN_RURALCAJA = 37083UL,
      FI_EN_BN_RUSBANK = 37084UL,
      FI_EN_BN_RUSSKIY_STANDART = 37085UL,
      FI_EN_BN_RUSSNEFT = 37086UL,
      FI_EN_BN_RUSTICAE_METROPOLI = 37087UL,
      FI_EN_BN_RUTHS_CHRIS_STEAK_HOUSE = 37088UL,
      FI_EN_BN_RUTTERS = 37089UL,
      FI_EN_BN_RYANS = 37090UL,
      FI_EN_BN_SA_NOSTRA = 37091UL,
      FI_EN_BN_SAEAESTOEPANKKI = 37092UL,
      FI_EN_BN_SAEAESTUMARKET = 37093UL,
      FI_EN_BN_SABA = 37094UL,
      FI_EN_BN_SABADELLATLANTICO = 37095UL,
      FI_EN_BN_SABECO = 37096UL,
      FI_EN_BN_SACOOR = 37097UL,
      FI_EN_BN_SAFEWAY_PHARMACY = 37098UL,
      FI_EN_BN_SAGARDI = 37099UL,
      FI_EN_BN_SAHAKARI_BHANDAR = 37100UL,
      FI_EN_BN_SAHAN = 37101UL,
      FI_EN_BN_SAHARA = 37102UL,
      FI_EN_BN_SAINSBURYS = 37103UL,
      FI_EN_BN_SALAD_SPINNERS = 37104UL,
      FI_EN_BN_SALADWORKS = 37105UL,
      FI_EN_BN_SALAMA = 37106UL,
      FI_EN_BN_SALAMANDER = 37107UL,
      FI_EN_BN_SALCOBRAND = 37108UL,
      FI_EN_BN_SALE = 37109UL,
      FI_EN_BN_SALSA = 37110UL,
      FI_EN_BN_SAM_0_13 = 37111UL,
      FI_EN_BN_SAMOKHVAL = 37112UL,
      FI_EN_BN_SAMPI = 37113UL,
      FI_EN_BN_SAMPO = 37114UL,
      FI_EN_BN_SAMS_CLUB = 37115UL,
      FI_EN_BN_SAMSONITE = 37116UL,
      FI_EN_BN_SAN_CARLO = 37117UL,
      FI_EN_BN_SAN_FRANCISCO_OVEN = 37118UL,
      FI_EN_BN_SAN_FRANCISCO_SOUP_COMPANY = 37119UL,
      FI_EN_BN_SANDELLAS = 37120UL,
      FI_EN_BN_SANDERS = 37121UL,
      FI_EN_BN_SANDWICH_FACTORY = 37122UL,
      FI_EN_BN_SANGALI_CO_OP_BANK = 37123UL,
      FI_EN_BN_SANKT_GALLER_KANTONALBANK = 37124UL,
      FI_EN_BN_SANPAOLO_BANK = 37125UL,
      FI_EN_BN_SANTA_BARBARA_BANK_TRUST = 37126UL,
      FI_EN_BN_SANTA_ISABEL = 37127UL,
      FI_EN_BN_SANTANA = 37128UL,
      FI_EN_BN_SANTANDER_CENTRAL_HISPANO = 37129UL,
      FI_EN_BN_SANTANDER_CONSUMER_BANK = 37130UL,
      FI_EN_BN_SANTANDER_RIO = 37131UL,
      FI_EN_BN_SANTANDER_TOTTA = 37132UL,
      FI_EN_BN_SANTANDER = 37133UL,
      FI_EN_BN_SANTELENA = 37134UL,
      FI_EN_BN_SARAS_ENERGIA = 37135UL,
      FI_EN_BN_SARASWAT_BANK = 37136UL,
      FI_EN_BN_SARKU_JAPAN = 37137UL,
      FI_EN_BN_SARNI = 37138UL,
      FI_EN_BN_SASCO = 37139UL,
      FI_EN_BN_SASOL = 37140UL,
      FI_EN_BN_SAUDI_FUEL = 37141UL,
      FI_EN_BN_SAVE_ON_FOODS = 37142UL,
      FI_EN_BN_SAVE_A_LOT = 37143UL,
      FI_EN_BN_SAV_MOR_FOODS = 37144UL,
      FI_EN_BN_SAV_ON_DRUGS = 37145UL,
      FI_EN_BN_SAYPA = 37146UL,
      FI_EN_BN_SBARRO = 37147UL,
      FI_EN_BN_SBERBANK_ROSSII = 37148UL,
      FI_EN_BN_SCANIA = 37149UL,
      FI_EN_BN_SCAPA = 37150UL,
      FI_EN_BN_SCAPINO = 37151UL,
      FI_EN_BN_SCHAFFHAUSER_KANTONALBANK = 37152UL,
      FI_EN_BN_SCHLECKER = 37153UL,
      FI_EN_BN_SCHLEIPER = 37154UL,
      FI_EN_BN_SCHLOTZSKYS = 37155UL,
      FI_EN_BN_SCHNITZELHAUS = 37156UL,
      FI_EN_BN_SCHNITZLPLATZL = 37157UL,
      FI_EN_BN_SCHNUCKS = 37158UL,
      FI_EN_BN_SCHOELLERBANK = 37159UL,
      FI_EN_BN_SCHOENEN_REUS = 37160UL,
      FI_EN_BN_SCHOEPS = 37161UL,
      FI_EN_BN_SCHUHHOF = 37162UL,
      FI_EN_BN_SCHWAEBISCH_HALL = 37163UL,
      FI_EN_BN_SCHWYZER_KANTONALBANK = 37164UL,
      FI_EN_BN_SCORE_SUPERMARKET = 37165UL,
      FI_EN_BN_SCOTIABANK = 37166UL,
      FI_EN_BN_SCOTTISH_FUELS = 37167UL,
      FI_EN_BN_SEARS_AUTO_CENTER = 37168UL,
      FI_EN_BN_SEARS_HARDWARE = 37169UL,
      FI_EN_BN_SEARS_HOMETOWN_STORE = 37170UL,
      FI_EN_BN_SEARS_OUTLET = 37171UL,
      FI_EN_BN_SEARS_RENT_A_CAR = 37172UL,
      FI_EN_BN_SEARS = 37173UL,
      FI_EN_BN_SEASONS_52 = 37174UL,
      FI_EN_BN_SEASSIDE_HOTELS = 37175UL,
      FI_EN_BN_SEATTLES_BEST = 37176UL,
      FI_EN_BN_SEB = 37177UL,
      FI_EN_BN_SECOND_CUP = 37178UL,
      FI_EN_BN_SEDMOY_KONTINENT = 37179UL,
      FI_EN_BN_SEKERBANK = 37180UL,
      FI_EN_BN_SELEXION = 37181UL,
      FI_EN_BN_SELEXYZ = 37182UL,
      FI_EN_BN_SELGROS = 37183UL,
      FI_EN_BN_SELVER = 37184UL,
      FI_EN_BN_SEM_ANGLES = 37185UL,
      FI_EN_BN_SEMIACS = 37186UL,
      FI_EN_BN_SENDAS = 37187UL,
      FI_EN_BN_SERRA_DA_ESTRELA = 37188UL,
      FI_EN_BN_SEYHANLAR_MARKET = 37189UL,
      FI_EN_BN_SF = 37190UL,
      FI_EN_BN_SFIC = 37191UL,
      FI_EN_BN_SHAKEYS = 37192UL,
      FI_EN_BN_SHAMRAO_VITHAL_CO_OP_BANK = 37193UL,
      FI_EN_BN_SHANGRI_LA = 37194UL,
      FI_EN_BN_SHARIS = 37195UL,
      FI_EN_BN_SHARKYS_WOODFIRED_MEXICAN_GRILL = 37196UL,
      FI_EN_BN_SHAWS = 37197UL,
      FI_EN_BN_SHEARINGS = 37198UL,
      FI_EN_BN_SHELL_EXPRESS = 37199UL,
      FI_EN_BN_SHERRIFS = 37200UL,
      FI_EN_BN_SHIVAJINAGAR_SAHAKARI_BANK = 37201UL,
      FI_EN_BN_SHIVAJIRAO_BHOSALE_SAHAKARI_BANK = 37202UL,
      FI_EN_BN_SHIVAJIRAO_BHOSLE_BANK = 37203UL,
      FI_EN_BN_SHOE_DEPT = 37204UL,
      FI_EN_BN_SHOE_DISCOUNT = 37205UL,
      FI_EN_BN_SHOE_SHOW = 37206UL,
      FI_EN_BN_SHOKOLADNITSA = 37207UL,
      FI_EN_BN_SHONEYS = 37208UL,
      FI_EN_BN_SHOPKO = 37209UL,
      FI_EN_BN_SHOPPERS_DRUG_MART = 37210UL,
      FI_EN_BN_SHOPRITE = 37211UL,
      FI_EN_BN_SHORTYS_MEXICAN_ROADHOUSE = 37212UL,
      FI_EN_BN_SHOWCASE = 37213UL,
      FI_EN_BN_SIAULIU_BANKAS = 37214UL,
      FI_EN_BN_SIBA = 37215UL,
      FI_EN_BN_SIBNEFT = 37216UL,
      FI_EN_BN_SIDIS = 37217UL,
      FI_EN_BN_SIGMA = 37218UL,
      FI_EN_BN_SIKON_GROUP_LTD = 37219UL,
      FI_EN_BN_SILK_OIL = 37220UL,
      FI_EN_BN_SILMET = 37221UL,
      FI_EN_BN_SILVER_DINER = 37222UL,
      FI_EN_BN_SILVER_FOX = 37223UL,
      FI_EN_BN_SILVER_MINE_SUBS = 37224UL,
      FI_EN_BN_SILVER_SCREEN = 37225UL,
      FI_EN_BN_SIMPATIA_CRAI = 37226UL,
      FI_EN_BN_SIMPLY_MARKET = 37227UL,
      FI_EN_BN_SIR_PIZZA = 37228UL,
      FI_EN_BN_SIR = 37229UL,
      FI_EN_BN_SIRLOIN_STOCKADE = 37230UL,
      FI_EN_BN_SISA = 37231UL,
      FI_EN_BN_SIWA = 37232UL,
      FI_EN_BN_SIXT = 37233UL,
      FI_EN_BN_SIZZLER = 37234UL,
      FI_EN_BN_SKARLET = 37235UL,
      FI_EN_BN_SKB_BANKA = 37236UL,
      FI_EN_BN_SKECHERS = 37237UL,
      FI_EN_BN_SKIPPERS = 37238UL,
      FI_EN_BN_SKIPTON_BUILDING_SOCIETY = 37239UL,
      FI_EN_BN_SKLAVENITIS = 37240UL,
      FI_EN_BN_SKY_PARK_SECURE = 37241UL,
      FI_EN_BN_SKYE_BANK = 37242UL,
      FI_EN_BN_SKYLINE_CHILI = 37243UL,
      FI_EN_BN_SLAVNEFT = 37244UL,
      FI_EN_BN_SLEEP_COUNTRY = 37245UL,
      FI_EN_BN_SLOVENSKA_SPORITELNA = 37246UL,
      FI_EN_BN_SMA = 37247UL,
      FI_EN_BN_SMALL_ELEGANT_HOTELS = 37248UL,
      FI_EN_BN_S_MARKET = 37249UL,
      FI_EN_BN_SMART_SET = 37250UL,
      FI_EN_BN_SMART = 37251UL,
      FI_EN_BN_S_MART = 37252UL,
      FI_EN_BN_SMATCH = 37253UL,
      FI_EN_BN_SMC = 37254UL,
      FI_EN_BN_SMOKEY_BONES = 37255UL,
      FI_EN_BN_SMOOTHIE_FACTORY = 37256UL,
      FI_EN_BN_SMOOTHIE_KING = 37257UL,
      FI_EN_BN_SNACK_ATTACK = 37258UL,
      FI_EN_BN_SNG = 37259UL,
      FI_EN_BN_SNORAS = 37260UL,
      FI_EN_BN_SNS_BANK = 37261UL,
      FI_EN_BN_SOBEYS = 37262UL,
      FI_EN_BN_SOCIETE_GENERALE_EXPRESSBANK = 37263UL,
      FI_EN_BN_SOCIETE_GENERALE = 37264UL,
      FI_EN_BN_SOFIA_CITY_CENTRE_CINEMA = 37265UL,
      FI_EN_BN_SOGLIA = 37266UL,
      FI_EN_BN_SOK = 37267UL,
      FI_EN_BN_SOL_HOTELS = 37268UL,
      FI_EN_BN_SOLAPUR_JANTA_SAHAKARI_BANK = 37269UL,
      FI_EN_BN_SOLBANK = 37270UL,
      FI_EN_BN_SOLINCA = 37271UL,
      FI_EN_BN_SOLMAR = 37272UL,
      FI_EN_BN_SOLO_SQUEEZE = 37273UL,
      FI_EN_BN_SOLSTICE = 37274UL,
      FI_EN_BN_SOMAP = 37275UL,
      FI_EN_BN_SOMEPI = 37276UL,
      FI_EN_BN_SOMERFIELD = 37277UL,
      FI_EN_BN_SOMETHINGS_FISHY = 37278UL,
      FI_EN_BN_SONAE_SIERRA = 37279UL,
      FI_EN_BN_SONIC = 37280UL,
      FI_EN_BN_SONNYS_REAL_PIT_BBQ = 37281UL,
      FI_EN_BN_SONY = 37282UL,
      FI_EN_BN_SORELI_ISLA = 37283UL,
      FI_EN_BN_SORIANA = 37284UL,
      FI_EN_BN_SORLI_DISCAU = 37285UL,
      FI_EN_BN_SOUPBOX = 37286UL,
      FI_EN_BN_SOUPER_SALAD = 37287UL,
      FI_EN_BN_SOUPLANTATION = 37288UL,
      FI_EN_BN_SOUTH_INDIAN_BANK = 37289UL,
      FI_EN_BN_SOUTHERN_FRIED_CHICKEN = 37290UL,
      FI_EN_BN_SOUTHERN_SUN = 37291UL,
      FI_EN_BN_SOUTHERN_TSUNAMI = 37292UL,
      FI_EN_BN_SOVEREIGN_BANK = 37293UL,
      FI_EN_BN_SOYKAN = 37294UL,
      FI_EN_BN_SPAGHETTI_WAREHOUSE = 37295UL,
      FI_EN_BN_SPAR_GOURMET = 37296UL,
      FI_EN_BN_SPAR_NORD_BANK = 37297UL,
      FI_EN_BN_SPAR = 37298UL,
      FI_EN_BN_SPARBANK_VEST = 37299UL,
      FI_EN_BN_SPARDA_BANK = 37300UL,
      FI_EN_BN_SPAREBANK_1 = 37301UL,
      FI_EN_BN_SPAREBANKEN_VEST = 37302UL,
      FI_EN_BN_SPARKASSE_AACHEN = 37303UL,
      FI_EN_BN_SPARKASSE_ALLGAEU = 37304UL,
      FI_EN_BN_SPARKASSE_BAMBERG = 37305UL,
      FI_EN_BN_SPARKASSE_BIELEFELD = 37306UL,
      FI_EN_BN_SPARKASSE_BOCHUM = 37307UL,
      FI_EN_BN_SPARKASSE_BREMEN = 37308UL,
      FI_EN_BN_SPARKASSE_CHEMNITZ = 37309UL,
      FI_EN_BN_SPARKASSE_DACHAU = 37310UL,
      FI_EN_BN_SPARKASSE_DORTMUND = 37311UL,
      FI_EN_BN_SPARKASSE_DUISBURG = 37312UL,
      FI_EN_BN_SPARKASSE_DUEREN = 37313UL,
      FI_EN_BN_SPARKASSE_ERDING_DORFEN = 37314UL,
      FI_EN_BN_SPARKASSE_ESSEN = 37315UL,
      FI_EN_BN_SPARKASSE_FICHTELGEBIRGE = 37316UL,
      FI_EN_BN_SPARKASSE_FUERSTENFELDBRUCK = 37317UL,
      FI_EN_BN_SPARKASSE_GIESSEN = 37318UL,
      FI_EN_BN_SPARKASSE_GOEPPINGEN = 37319UL,
      FI_EN_BN_SPARKASSE_HANNOVER = 37320UL,
      FI_EN_BN_SPARKASSE_HARBURG_BUXTEHUDE = 37321UL,
      FI_EN_BN_SPARKASSE_HEIDELBERG = 37322UL,
      FI_EN_BN_SPARKASSE_HERFORD = 37323UL,
      FI_EN_BN_SPARKASSE_HILDESHEIM = 37324UL,
      FI_EN_BN_SPARKASSE_HOHENLOHEKREIS = 37325UL,
      FI_EN_BN_SPARKASSE_HOLSTEIN_EUTIN = 37326UL,
      FI_EN_BN_SPARKASSE_KARLSRUHE = 37327UL,
      FI_EN_BN_SPARKASSE_KOBLENZ = 37328UL,
      FI_EN_BN_SPARKASSE_KOELNBONN = 37329UL,
      FI_EN_BN_SPARKASSE_KREFELD = 37330UL,
      FI_EN_BN_SPARKASSE_KULMBACH_KRONACH = 37331UL,
      FI_EN_BN_SPARKASSE_LANDSBERG_DIESSEN = 37332UL,
      FI_EN_BN_SPARKASSE_LANGEN_SELIGENSTADT = 37333UL,
      FI_EN_BN_SPARKASSE_LEIPZIG = 37334UL,
      FI_EN_BN_SPARKASSE_LEMGO = 37335UL,
      FI_EN_BN_SPARKASSE_MITTELMOSEL_EIFEL = 37336UL,
      FI_EN_BN_SPARKASSE_NEUSS = 37337UL,
      FI_EN_BN_SPARKASSE_NEUSTADT_AD_AISCH = 37338UL,
      FI_EN_BN_SPARKASSE_NUERNBERG = 37339UL,
      FI_EN_BN_SPARKASSE_OBERHESSEN = 37340UL,
      FI_EN_BN_SPARKASSE_OSTERODE_AM_HARZ = 37341UL,
      FI_EN_BN_SPARKASSE_PFORZHEIM_CALW = 37342UL,
      FI_EN_BN_SPARKASSE_RHEIN_NECKAR_NORD = 37343UL,
      FI_EN_BN_SPARKASSE_RHEIN_NAHE = 37344UL,
      FI_EN_BN_SPARKASSE_SCHAUMBURG = 37345UL,
      FI_EN_BN_SPARKASSE_SUEDHOLSTEIN = 37346UL,
      FI_EN_BN_SPARKASSE_TRIER = 37347UL,
      FI_EN_BN_SPARKASSE_ULM = 37348UL,
      FI_EN_BN_SPARKASSE_VOGTLAND = 37349UL,
      FI_EN_BN_SPARKASSE_VORDERPFALZ = 37350UL,
      FI_EN_BN_SPARKASSE = 37351UL,
      FI_EN_BN_SPEEDY_AUTO_SERVICE = 37352UL,
      FI_EN_BN_SPEEDY_GLASS = 37353UL,
      FI_EN_BN_SPEEDY = 37354UL,
      FI_EN_BN_SPENCERS = 37355UL,
      FI_EN_BN_SPENDIMEGLIO = 37356UL,
      FI_EN_BN_SPF = 37357UL,
      FI_EN_BN_SPHINX = 37358UL,
      FI_EN_BN_SPINACH = 37359UL,
      FI_EN_BN_SPIZZICO = 37360UL,
      FI_EN_BN_SPLITSKA_BANKA = 37361UL,
      FI_EN_BN_SPOLDZIELCZA_GRUPA_BANKOWA_GBW = 37362UL,
      FI_EN_BN_SPORTCHEK = 37363UL,
      FI_EN_BN_SPORTMART = 37364UL,
      FI_EN_BN_SPORTS_AUTHORITY = 37365UL,
      FI_EN_BN_SPORTS_EXPERTS = 37366UL,
      FI_EN_BN_SPORTS_WORLD = 37367UL,
      FI_EN_BN_SPORTZONE = 37368UL,
      FI_EN_BN_SPRIDER_STORES = 37369UL,
      FI_EN_BN_SPRING_BANK = 37370UL,
      FI_EN_BN_SPRING_TIME = 37371UL,
      FI_EN_BN_SPRINGFIELD = 37372UL,
      FI_EN_BN_MARRIOTT_SPRINGHILL_SUITES = 37373UL,
      FI_EN_BN_SR_FRANGO_DA_GUIA = 37374UL,
      FI_EN_BN_ST_GEORGE = 37375UL,
      FI_EN_BN_ST_REGIS = 37376UL,
      FI_EN_BN_ST_GALLER_KANTONALBANK = 37377UL,
      FI_EN_BN_ST1 = 37378UL,
      FI_EN_BN_STADTSPARKASSE_MUENCHEN = 37379UL,
      FI_EN_BN_STADTSPARKASSE_WUPPERTAL = 37380UL,
      FI_EN_BN_STAFFORDSHIRE = 37381UL,
      FI_EN_BN_STANDA = 37382UL,
      FI_EN_BN_STANDAARD_BOEKHANDEL = 37383UL,
      FI_EN_BN_STANDARD_BANK_TRUST = 37384UL,
      FI_EN_BN_STANDARD_BANK = 37385UL,
      FI_EN_BN_STANDARD_CHARTERED = 37386UL,
      FI_EN_BN_STANDARD_PARKING = 37387UL,
      FI_EN_BN_STAPLES_BUSINESS_DEPOT = 37388UL,
      FI_EN_BN_STAPLES = 37389UL,
      FI_EN_BN_STAR_MARKET = 37390UL,
      FI_EN_BN_STAR_MART = 37391UL,
      FI_EN_BN_STARCAR = 37392UL,
      FI_EN_BN_STARIY_LEKAR = 37393UL,
      FI_EN_BN_STARPET = 37394UL,
      FI_EN_BN_STARS_HOTELS = 37395UL,
      FI_EN_BN_STATE_BANK_OF_HYDERABAD = 37396UL,
      FI_EN_BN_STATE_BANK_OF_INDIA = 37397UL,
      FI_EN_BN_STATE_BANK_OF_INDORE = 37398UL,
      FI_EN_BN_STATE_BANK_OF_MYSORE = 37399UL,
      FI_EN_BN_STATE_BANK_OF_PATIALA = 37400UL,
      FI_EN_BN_STATE_BANK_OF_SAURASHTRA = 37401UL,
      FI_EN_BN_STATE_BANK = 37402UL,
      FI_EN_BN_STAYBRIDGE_SUITES = 37403UL,
      FI_EN_BN_STEAK_ESCAPE = 37404UL,
      FI_EN_BN_STEAK_N_SHAKE = 37405UL,
      FI_EN_BN_STEAK_OUT = 37406UL,
      FI_EN_BN_STEERS = 37407UL,
      FI_EN_BN_STER_CENTURY = 37408UL,
      FI_EN_BN_STER_CINEMAS = 37409UL,
      FI_EN_BN_STER_KINEKOR = 37410UL,
      FI_EN_BN_STERLING_BANK = 37411UL,
      FI_EN_BN_STEVE_BARRYS = 37412UL,
      FI_EN_BN_STEVE_MADDEN = 37413UL,
      FI_EN_BN_STITCHES = 37414UL,
      FI_EN_BN_STOKROTKA = 37415UL,
      FI_EN_BN_STOP_SHOP = 37416UL,
      FI_EN_BN_STRADIVARIUS = 37417UL,
      FI_EN_BN_STRASBURG_CHILDREN = 37418UL,
      FI_EN_BN_STRIDE_RITE = 37419UL,
      FI_EN_BN_STROUD_SWINDON_BUILDING_SOCIETY = 37420UL,
      FI_EN_BN_STUDIO_6 = 37421UL,
      FI_EN_BN_STUDIO = 37422UL,
      FI_EN_BN_STUTTGARTER_VOLKSBANK = 37423UL,
      FI_EN_BN_SUB_STATION_II = 37424UL,
      FI_EN_BN_SUBMARINA_CALIFORNIA_SUBS = 37425UL,
      FI_EN_BN_SUBURBAN_EXTENDED_STAY = 37426UL,
      FI_EN_BN_SUEDWESTBANK = 37427UL,
      FI_EN_BN_SUITEHOTEL = 37428UL,
      FI_EN_BN_SULTANAHMET_KOFTECISI = 37429UL,
      FI_EN_BN_SUMA = 37430UL,
      FI_EN_BN_SUN_SAND = 37431UL,
      FI_EN_BN_SUN_NATIONAL_BANK = 37432UL,
      FI_EN_BN_SUN_OIL = 37433UL,
      FI_EN_BN_SUNCORP = 37434UL,
      FI_EN_BN_SUNHOTEL = 37435UL,
      FI_EN_BN_SUNOCO_CANADA = 37436UL,
      FI_EN_BN_SUPA_QUICK = 37437UL,
      FI_EN_BN_SUPER_8 = 37438UL,
      FI_EN_BN_SUPER_BM = 37439UL,
      FI_EN_BN_SUPER_CENTRO = 37440UL,
      FI_EN_BN_SUPER_DE_BOER = 37441UL,
      FI_EN_BN_SUPER_ELITE = 37442UL,
      FI_EN_BN_SUPER_GAZ = 37443UL,
      FI_EN_BN_SUPER_GB = 37444UL,
      FI_EN_BN_SUPER_INDO = 37445UL,
      FI_EN_BN_SUPER_PARTNER_GB = 37446UL,
      FI_EN_BN_SUPER_SALADS = 37447UL,
      FI_EN_BN_SUPERAMA = 37448UL,
      FI_EN_BN_SUPERAVUI = 37449UL,
      FI_EN_BN_SUPERBEST = 37450UL,
      FI_EN_BN_SUPERBRUGSEN = 37451UL,
      FI_EN_BN_SUPERCOR = 37452UL,
      FI_EN_BN_SUPERESTALVI = 37453UL,
      FI_EN_BN_SUPERM = 37454UL,
      FI_EN_BN_SUPERMA = 37455UL,
      FI_EN_BN_SUPERMACS_FAMILY_RESTAURANT = 37456UL,
      FI_EN_BN_SUPERMACS_FRESH_EXPRESS = 37457UL,
      FI_EN_BN_SUPERMEC = 37458UL,
      FI_EN_BN_SUPERMERCADOS_BH = 37459UL,
      FI_EN_BN_SUPERNETTO = 37460UL,
      FI_EN_BN_SUPERQUINN = 37461UL,
      FI_EN_BN_SUPERSOL = 37462UL,
      FI_EN_BN_SUPERVALU = 37463UL,
      FI_EN_BN_SUPERVIELLE_BANCO = 37464UL,
      FI_EN_BN_SURCOUF = 37465UL,
      FI_EN_BN_SURGUTNEFTEGAZ = 37466UL,
      FI_EN_BN_SUSHI_ITTO = 37467UL,
      FI_EN_BN_SUTTERLUETY = 37468UL,
      FI_EN_BN_SUVARNA_SAHAKARI_BANK = 37469UL,
      FI_EN_BN_SUWARN_SAHAKARI_BANK = 37470UL,
      FI_EN_BN_SUZY_SHIER = 37471UL,
      FI_EN_BN_SVEJK_RESTAURANT = 37472UL,
      FI_EN_BN_SVENSK_KASSASERVICE = 37473UL,
      FI_EN_BN_SWEDBANK = 37474UL,
      FI_EN_BN_SWENSENS = 37475UL,
      FI_EN_BN_SWISS_CHALET = 37476UL,
      FI_EN_BN_SWISS_QUALITY_HOTELS = 37477UL,
      FI_EN_BN_SYNDICATE_BANK = 37478UL,
      FI_EN_BN_SYNOVUS = 37479UL,
      FI_EN_BN_SYSTEM_PARKING = 37480UL,
      FI_EN_BN_TABI = 37481UL,
      FI_EN_BN_TABLAPIZZA = 37482UL,
      FI_EN_BN_TABLES_AUBERGES_DE_FRANCE = 37483UL,
      FI_EN_BN_TACI_OIL = 37484UL,
      FI_EN_BN_TACO_BELL = 37485UL,
      FI_EN_BN_TACO_BUENO = 37486UL,
      FI_EN_BN_TACO_CABANA = 37487UL,
      FI_EN_BN_TACO_DEL_MAR = 37488UL,
      FI_EN_BN_TACO_H = 37489UL,
      FI_EN_BN_TACO_INN = 37490UL,
      FI_EN_BN_TACO_JOHNS = 37491UL,
      FI_EN_BN_TACO_MAC = 37492UL,
      FI_EN_BN_TACOTIME = 37493UL,
      FI_EN_BN_TADIM_PIZZA = 37494UL,
      FI_EN_BN_TAJ = 37495UL,
      FI_EN_BN_TAKKO_FASHION = 37496UL,
      FI_EN_BN_TALBOTS = 37497UL,
      FI_EN_BN_TALLY_WEIJL = 37498UL,
      FI_EN_BN_TAMILNADU_MERCANTILE_BANK = 37499UL,
      FI_EN_BN_TANDY_ELECTRONICS = 37500UL,
      FI_EN_BN_TANDY = 37501UL,
      FI_EN_BN_TANKA = 37502UL,
      FI_EN_BN_TANSAS = 37503UL,
      FI_EN_BN_TANTALIZER = 37504UL,
      FI_EN_BN_TANUKI = 37505UL,
      FI_EN_BN_TAPELIA = 37506UL,
      FI_EN_BN_TAQUERIA_ARANDAS = 37507UL,
      FI_EN_BN_TAQUERIA_GUADALAJARA = 37508UL,
      FI_EN_BN_TARAS_BULBA = 37509UL,
      FI_EN_BN_TARGET_PHARMACY = 37510UL,
      FI_EN_BN_TARGET = 37511UL,
      FI_EN_BN_TASET = 37512UL,
      FI_EN_BN_TASHELAT = 37513UL,
      FI_EN_BN_TASTEE_FREEZ = 37514UL,
      FI_EN_BN_TATA = 37515UL,
      FI_EN_BN_TATNEFT = 37516UL,
      FI_EN_BN_TATNEFTEPRODUKT = 37517UL,
      FI_EN_BN_TATRA_BANKA = 37518UL,
      FI_EN_BN_TAVERNE_DE_MAITRE_KANTER = 37519UL,
      FI_EN_BN_T_BONES_GREAT_AMERICAN_EATERY = 37520UL,
      FI_EN_BN_TC_ZIRAAT_BANKASI = 37521UL,
      FI_EN_BN_TCBY = 37522UL,
      FI_EN_BN_TCF = 37523UL,
      FI_EN_BN_TD_BANK = 37524UL,
      FI_EN_BN_TD_CANADA_TRUST = 37525UL,
      FI_EN_BN_TD_CARS = 37526UL,
      FI_EN_BN_TDC = 37527UL,
      FI_EN_BN_TEB = 37528UL,
      FI_EN_BN_TEBOIL_EXPRESS = 37529UL,
      FI_EN_BN_TECH_NET = 37530UL,
      FI_EN_BN_TEDCASTLES = 37531UL,
      FI_EN_BN_TEDS_MONTANA_GRILL = 37532UL,
      FI_EN_BN_TEGUT = 37533UL,
      FI_EN_BN_TEKNISET = 37534UL,
      FI_EN_BN_TEKPA = 37535UL,
      FI_EN_BN_TEKSTILBANK = 37536UL,
      FI_EN_BN_TELEPIZZA = 37537UL,
      FI_EN_BN_TELUS = 37538UL,
      FI_EN_BN_TEMPEST = 37539UL,
      FI_EN_BN_TENGELMANN = 37540UL,
      FI_EN_BN_TERCAS = 37541UL,
      FI_EN_BN_TEREMOK = 37542UL,
      FI_EN_BN_TERIYAKI_STIX = 37543UL,
      FI_EN_BN_TERMO = 37544UL,
      FI_EN_BN_TERNO = 37545UL,
      FI_EN_BN_TERPEL = 37546UL,
      FI_EN_BN_TESCO_IRELAND = 37547UL,
      FI_EN_BN_TETCO = 37548UL,
      FI_EN_BN_TEXAS_ROADHOUSE = 37549UL,
      FI_EN_BN_TEXAS_STEAKHOUSE_SALOON = 37550UL,
      FI_EN_BN_TGI_FRIDAYS = 37551UL,
      FI_EN_BN_THANE_JANATA_SAHAKARI_BANK = 37552UL,
      FI_EN_BN_THANSEN = 37553UL,
      FI_EN_BN_THE_AJARA_URBAN_BANK = 37554UL,
      FI_EN_BN_THE_BAY = 37555UL,
      FI_EN_BN_THE_BISHOPS_ARMS = 37556UL,
      FI_EN_BN_THE_CAPITAL_GRILLE = 37557UL,
      FI_EN_BN_THE_COSMOS_CO_OP_BANK = 37558UL,
      FI_EN_BN_THE_DECCAN_MERCHANTS_CO_OP_BANK = 37559UL,
      FI_EN_BN_THE_DISCOVERY_STORE = 37560UL,
      FI_EN_BN_THE_HOME_DEPOT_FLOOR_STORE = 37561UL,
      FI_EN_BN_THE_HOME_DEPOT_LANDSCAPE_SUPPLY = 37562UL,
      FI_EN_BN_THE_HOME_DEPOT = 37563UL,
      FI_EN_BN_THE_KEG_STEAKHOUSE_BAR = 37564UL,
      FI_EN_BN_THE_LIMITED = 37565UL,
      FI_EN_BN_THE_MELTING_POT = 37566UL,
      FI_EN_BN_THE_MILLS = 37567UL,
      FI_EN_BN_THE_PHONE_HOUSE = 37568UL,
      FI_EN_BN_THE_READ_SHOP = 37569UL,
      FI_EN_BN_THE_SOURCE = 37570UL,
      FI_EN_BN_THEEB = 37571UL,
      FI_EN_BN_THIRD_FEDERAL_SAVINGS_LOAN = 37572UL,
      FI_EN_BN_THIROS = 37573UL,
      FI_EN_BN_THON = 37574UL,
      FI_EN_BN_THRIFTLODGE_CANADA = 37575UL,
      FI_EN_BN_THRIFTY_RENTAL_CAR = 37576UL,
      FI_EN_BN_THUNDERCLOUD_SUBS = 37577UL,
      FI_EN_BN_THURGAUER_KANTONALBANK = 37578UL,
      FI_EN_BN_TIA_CAR_RENT = 37579UL,
      FI_EN_BN_TIAS_TEX_MEX = 37580UL,
      FI_EN_BN_TIFFOSI = 37581UL,
      FI_EN_BN_TIFON = 37582UL,
      FI_EN_BN_TIGER_WHEEL_TYRE = 37583UL,
      FI_EN_BN_TIGRE = 37584UL,
      FI_EN_BN_TIGROS = 37585UL,
      FI_EN_BN_TIKE = 37586UL,
      FI_EN_BN_TIM_HORTONS = 37587UL,
      FI_EN_BN_TIMBER_LODGE_STEAKHOUSE = 37588UL,
      FI_EN_BN_TIMBERLAND = 37589UL,
      FI_EN_BN_TIMOTHYS = 37590UL,
      FI_EN_BN_TIP_TOP_TAILORS = 37591UL,
      FI_EN_BN_TIRECRAFT = 37592UL,
      FI_EN_BN_TIRES_PLUS = 37593UL,
      FI_EN_BN_TIREX = 37594UL,
      FI_EN_BN_TIVOLI = 37595UL,
      FI_EN_BN_T_MARKET = 37596UL,
      FI_EN_BN_T_MOBILE = 37597UL,
      FI_EN_BN_TNK = 37598UL,
      FI_EN_BN_TNSC_BANK = 37599UL,
      FI_EN_BN_TODIS = 37600UL,
      FI_EN_BN_TOGOS = 37601UL,
      FI_EN_BN_TOI_MOI = 37602UL,
      FI_EN_BN_TOKS = 37603UL,
      FI_EN_BN_TOKYO_EXPRESS = 37604UL,
      FI_EN_BN_TOM_CO = 37605UL,
      FI_EN_BN_TOMPKINS_TRUST_COMPANY = 37606UL,
      FI_EN_BN_TONY_ROMAS = 37607UL,
      FI_EN_BN_TOOM_BAUMARKT = 37608UL,
      FI_EN_BN_TOOM = 37609UL,
      FI_EN_BN_TOP_SERVICE_TEAM = 37610UL,
      FI_EN_BN_TOPAZ = 37611UL,
      FI_EN_BN_TOPPERS_PIZZA = 37612UL,
      FI_EN_BN_TORFS = 37613UL,
      FI_EN_BN_TORONTO_DOMINION_BANK_CANADA = 37614UL,
      FI_EN_BN_TORRID = 37615UL,
      FI_EN_BN_TOTTA = 37616UL,
      FI_EN_BN_TOWN_PUMP = 37617UL,
      FI_EN_BN_TOWNEPLACE_SUITES = 37618UL,
      FI_EN_BN_TOWNHOME_INN = 37619UL,
      FI_EN_BN_TOYSRUS = 37620UL,
      FI_EN_BN_TRADER_JOES = 37621UL,
      FI_EN_BN_TRADER_VICS_RESTAURANT = 37622UL,
      FI_EN_BN_TRAFIC = 37623UL,
      FI_EN_BN_TRAGUS = 37624UL,
      FI_EN_BN_TRASTA_KOMERCBANKA = 37625UL,
      FI_EN_BN_TRAVELCENTERS_OF_AMERICA = 37626UL,
      FI_EN_BN_TRAVELODGE_CANADA = 37627UL,
      FI_EN_BN_TREBOL = 37628UL,
      FI_EN_BN_TREFF = 37629UL,
      FI_EN_BN_TRENDWEST_RESORTS = 37630UL,
      FI_EN_BN_TRIAL = 37631UL,
      FI_EN_BN_TRIODOS_BANK = 37632UL,
      FI_EN_BN_TROEFMARKT = 37633UL,
      FI_EN_BN_TROMBA_RIJA = 37634UL,
      FI_EN_BN_TRONY = 37635UL,
      FI_EN_BN_TROPICAL_SMOOTHIE_CAFE = 37636UL,
      FI_EN_BN_TRYP_HOTELS = 37637UL,
      FI_EN_BN_TSAKIRIS_MALLAS = 37638UL,
      FI_EN_BN_TSENTR_INVEST = 37639UL,
      FI_EN_BN_TUBBYS = 37640UL,
      FI_EN_BN_TUFFY = 37641UL,
      FI_EN_BN_TUI_CARS = 37642UL,
      FI_EN_BN_TULLYS = 37643UL,
      FI_EN_BN_TUNE_UP = 37644UL,
      FI_EN_BN_TUO = 37645UL,
      FI_EN_BN_TUODI = 37646UL,
      FI_EN_BN_TURIN = 37647UL,
      FI_EN_BN_TURK_EXIMBANK = 37648UL,
      FI_EN_BN_TUERK_PETROL = 37649UL,
      FI_EN_BN_TURKISH_BANK = 37650UL,
      FI_EN_BN_TURKIYE_FINANS_KATILIM_BANKASI = 37651UL,
      FI_EN_BN_TURKIYE_IS_BANKASI = 37652UL,
      FI_EN_BN_TURKLAND_BANK = 37653UL,
      FI_EN_BN_TURKUAZ = 37654UL,
      FI_EN_BN_TUS_OIL = 37655UL,
      FI_EN_BN_TUS = 37656UL,
      FI_EN_BN_TUTA = 37657UL,
      FI_EN_BN_TVS_MOTORS = 37658UL,
      FI_EN_BN_U_SAVE_AUTO_RENTAL = 37659UL,
      FI_EN_BN_UBA = 37660UL,
      FI_EN_BN_UBS_AG = 37661UL,
      FI_EN_BN_UCAR = 37662UL,
      FI_EN_BN_UCI_KINOWELT = 37663UL,
      FI_EN_BN_UCI = 37664UL,
      FI_EN_BN_UCO_BANK = 37665UL,
      FI_EN_BN_UDACO = 37666UL,
      FI_EN_BN_UDGAM_VIKAS_SAHAKARI_BANK = 37667UL,
      FI_EN_BN_UGC = 37668UL,
      FI_EN_BN_UGUR_CENTER = 37669UL,
      FI_EN_BN_ULLRICH = 37670UL,
      FI_EN_BN_ULSTER_BANK = 37671UL,
      FI_EN_BN_ULTRA = 37672UL,
      FI_EN_BN_UMB_BANK = 37673UL,
      FI_EN_BN_UNA_MAS = 37674UL,
      FI_EN_BN_UNAWAY = 37675UL,
      FI_EN_BN_UNDERGROUND_STATION = 37676UL,
      FI_EN_BN_UNES = 37677UL,
      FI_EN_BN_UNI_CREDITO = 37678UL,
      FI_EN_BN_UNIBANCO = 37679UL,
      FI_EN_BN_UNIBANKA = 37680UL,
      FI_EN_BN_UNICAJA = 37681UL,
      FI_EN_BN_UNICASA_SUPERMERCADOS = 37682UL,
      FI_EN_BN_UNICO = 37683UL,
      FI_EN_BN_UNICREDIT_BANCA = 37684UL,
      FI_EN_BN_UNICREDIT_BANK = 37685UL,
      FI_EN_BN_UNICREDIT_BULBANK = 37686UL,
      FI_EN_BN_UNICREDIT_ROMANIA = 37687UL,
      FI_EN_BN_UNICREDIT_TIRIAC_BANK = 37688UL,
      FI_EN_BN_UNIDAS = 37689UL,
      FI_EN_BN_UNIEURO = 37690UL,
      FI_EN_BN_UNIMARC = 37691UL,
      FI_EN_BN_UNIMARKT = 37692UL,
      FI_EN_BN_UNION_BANK_TRUST = 37693UL,
      FI_EN_BN_UNION_BANK_OF_CALIFORNIA = 37694UL,
      FI_EN_BN_UNION_BANK_OF_INDIA = 37695UL,
      FI_EN_BN_UNION_PLANTERS_BANK = 37696UL,
      FI_EN_BN_UNIPOL_BANCA = 37697UL,
      FI_EN_BN_UNIPRIX = 37698UL,
      FI_EN_BN_UNITED_BANK_OF_INDIA = 37699UL,
      FI_EN_BN_UNITED_BRANDS = 37700UL,
      FI_EN_BN_UNITED_BULGARIAN_BANK = 37701UL,
      FI_EN_BN_UNITY_BANK = 37702UL,
      FI_EN_BN_UNO_CHICAGO_GRILL = 37703UL,
      FI_EN_BN_UNO_E = 37704UL,
      FI_EN_BN_UOB_BUANA = 37705UL,
      FI_EN_BN_UPI = 37706UL,
      FI_EN_BN_UPS_STORE = 37707UL,
      FI_EN_BN_UPS = 37708UL,
      FI_EN_BN_UPSTALSBOOM = 37709UL,
      FI_EN_BN_URALSIB = 37710UL,
      FI_EN_BN_URBAN_BEHAVIOR = 37711UL,
      FI_EN_BN_URNER_KANTONALBANK = 37712UL,
      FI_EN_BN_US_BANK = 37713UL,
      FI_EN_BN_US_CELLULAR = 37714UL,
      FI_EN_BN_USPET = 37715UL,
      FI_EN_BN_UTKONOS = 37716UL,
      FI_EN_BN_UTOPIA = 37717UL,
      FI_EN_BN_UTOPOLIS = 37718UL,
      FI_EN_BN_UYUM = 37719UL,
      FI_EN_BN_VACANCES_BLEUES = 37720UL,
      FI_EN_BN_VAKIFBANK = 37721UL,
      FI_EN_BN_VALENTINE = 37722UL,
      FI_EN_BN_VALIANT_BANK = 37723UL,
      FI_EN_BN_VALIEXCHIMP = 37724UL,
      FI_EN_BN_VALINTATALO = 37725UL,
      FI_EN_BN_VALLEY_NATIONAL_BANK = 37726UL,
      FI_EN_BN_VALVOLINE_INSTANT_OIL_CHANGE = 37727UL,
      FI_EN_BN_VAN_HOUTTE = 37728UL,
      FI_EN_BN_VAN_REETH = 37729UL,
      FI_EN_BN_VANCITY_CREDIT_UNION = 37730UL,
      FI_EN_BN_VANDEN_BORRE = 37731UL,
      FI_EN_BN_VANITY = 37732UL,
      FI_EN_BN_VAZ = 37733UL,
      FI_EN_BN_VECINO = 37734UL,
      FI_EN_BN_VEF_BANKA = 37735UL,
      FI_EN_BN_VEFK = 37736UL,
      FI_EN_BN_VENETO_BANCA = 37737UL,
      FI_EN_BN_VENEZOLANO_DE_CREDITO = 37738UL,
      FI_EN_BN_VENTUS = 37739UL,
      FI_EN_BN_VERBANDS_SPARKASSE_WESEL = 37740UL,
      FI_EN_BN_VERGOELST = 37741UL,
      FI_EN_BN_VERIZON = 37742UL,
      FI_EN_BN_VERO_MODA = 37743UL,
      FI_EN_BN_VEROPOULOS_SPAR = 37744UL,
      FI_EN_BN_VETI = 37745UL,
      FI_EN_BN_VIADA = 37746UL,
      FI_EN_BN_VI_BUTIKERNA = 37747UL,
      FI_EN_BN_VICTORIAS_SECRET = 37748UL,
      FI_EN_BN_VICTORY = 37749UL,
      FI_EN_BN_VIDAL = 37750UL,
      FI_EN_BN_VIDYA_SAHAKARI_BANK = 37751UL,
      FI_EN_BN_VIE_DE_FRANCE = 37752UL,
      FI_EN_BN_VIENA = 37753UL,
      FI_EN_BN_VIJAYA_BANK = 37754UL,
      FI_EN_BN_VILLA_DEL_MAR = 37755UL,
      FI_EN_BN_VILLA_PIZZA = 37756UL,
      FI_EN_BN_VILLAGE_CINEMAS = 37757UL,
      FI_EN_BN_VINCCI = 37758UL,
      FI_EN_BN_VINCI_PARK = 37759UL,
      FI_EN_BN_VIPS = 37760UL,
      FI_EN_BN_VIS_A_VIS = 37761UL,
      FI_EN_BN_VITA = 37762UL,
      FI_EN_BN_VITALYS = 37763UL,
      FI_EN_BN_VIVAHOTEL = 37764UL,
      FI_EN_BN_VIVAL = 37765UL,
      FI_EN_BN_VIVO = 37766UL,
      FI_EN_BN_VLAIKOVA = 37767UL,
      FI_EN_BN_VOBIS = 37768UL,
      FI_EN_BN_VODAFONE = 37769UL,
      FI_EN_BN_VOEGELE = 37770UL,
      FI_EN_BN_VOLG = 37771UL,
      FI_EN_BN_VOLGANEFTEPRODUKT = 37772UL,
      FI_EN_BN_VOLGA_PETROLEUM = 37773UL,
      FI_EN_BN_VOLKSBANK_GOEPPINGEN = 37774UL,
      FI_EN_BN_VOLKSBANK_HEILBRONN = 37775UL,
      FI_EN_BN_VOLKSBANK_HOHENZOLLERN = 37776UL,
      FI_EN_BN_VOLKSBANK_KARLSRUHE = 37777UL,
      FI_EN_BN_VOLKSBANK_LUDWIGSBURG = 37778UL,
      FI_EN_BN_VOLKSBANK_NAHETAL = 37779UL,
      FI_EN_BN_VOLKSBANK_PADERBORN_HOEXTER_DETMOLD = 37780UL,
      FI_EN_BN_VOLKSBANK_PFORZHEIM = 37781UL,
      FI_EN_BN_VOLKSBANK_REMS = 37782UL,
      FI_EN_BN_VOLKSBANK_ROTTWEIL = 37783UL,
      FI_EN_BN_VOLKSBANK = 37784UL,
      FI_EN_BN_VOLKSBANKEN_RAIFFEISENBANKEN = 37785UL,
      FI_EN_BN_VOLKSKREDITBANK = 37786UL,
      FI_EN_BN_VOMAR = 37787UL,
      FI_EN_BN_VONS = 37788UL,
      FI_EN_BN_VOZROZHDENIE = 37789UL,
      FI_EN_BN_VP_MEDIA = 37790UL,
      FI_EN_BN_VP_MARKET = 37791UL,
      FI_EN_BN_VR_BANK_HOF = 37792UL,
      FI_EN_BN_VR_BANK_RHEIN_NECKAR = 37793UL,
      FI_EN_BN_VR_GENOSSENSCHAFTSBANK_FULDA = 37794UL,
      FI_EN_BN_VSEOBECNA_UVEROVA_BANKA = 37795UL,
      FI_EN_BN_VTB_24 = 37796UL,
      FI_EN_BN_VTB = 37797UL,
      FI_EN_BN_VUE = 37798UL,
      FI_EN_BN_W = 37799UL,
      FI_EN_BN_WACHOVIA = 37800UL,
      FI_EN_BN_WAFFLE_HOUSE = 37801UL,
      FI_EN_BN_WAHOOS_FISH_TACO = 37802UL,
      FI_EN_BN_WAITROSE = 37803UL,
      FI_EN_BN_WALDENBOOKS = 37804UL,
      FI_EN_BN_WALDORF_ASTORIA_COLLECTION = 37805UL,
      FI_EN_BN_WALGREENS = 37806UL,
      FI_EN_BN_WALL_STREET_DELI = 37807UL,
      FI_EN_BN_WALLISER_KANTONALBANK = 37808UL,
      FI_EN_BN_WAL_MART_PHARMACY = 37809UL,
      FI_EN_BN_WAL_MART_SUPERCENTER = 37810UL,
      FI_EN_BN_WAL_MART_TIRE_AND_LUBE = 37811UL,
      FI_EN_BN_WARNER_VILLAGE = 37812UL,
      FI_EN_BN_WASH_BOX = 37813UL,
      FI_EN_BN_WASHINGTON_MUTUAL = 37814UL,
      FI_EN_BN_WATANIA = 37815UL,
      FI_EN_BN_WATANYA = 37816UL,
      FI_EN_BN_WE = 37817UL,
      FI_EN_BN_WEGMANS_PHARMACY = 37818UL,
      FI_EN_BN_WEGMANS = 37819UL,
      FI_EN_BN_WEIS_MARKETS = 37820UL,
      FI_EN_BN_WELL = 37821UL,
      FI_EN_BN_WELLS_FARGO = 37822UL,
      FI_EN_BN_WEMA_BANK = 37823UL,
      FI_EN_BN_WENDYS = 37824UL,
      FI_EN_BN_WERE_ROLLING_PRETZEL_COMPANY = 37825UL,
      FI_EN_BN_WESBANK = 37826UL,
      FI_EN_BN_WESSELS_MUELLER = 37827UL,
      FI_EN_BN_WEST_BROMWICH_BUILDING_SOCIETY = 37828UL,
      FI_EN_BN_WESTERN_SIZZLIN_STEAK_MORE = 37829UL,
      FI_EN_BN_WESTERN_UNION = 37830UL,
      FI_EN_BN_WESTLB = 37831UL,
      FI_EN_BN_WESTPAC = 37832UL,
      FI_EN_BN_WESTSIDE_DELI = 37833UL,
      FI_EN_BN_WET_SEAL = 37834UL,
      FI_EN_BN_WETZELS_PRETZELS = 37835UL,
      FI_EN_BN_WG_GRINDERS = 37836UL,
      FI_EN_BN_WHATABURGER = 37837UL,
      FI_EN_BN_WHITE_BARN_CANDLE_CO = 37838UL,
      FI_EN_BN_WHITE_CASTLE = 37839UL,
      FI_EN_BN_WHITE_HEN_PANTRY = 37840UL,
      FI_EN_BN_WHITE_HOUSE_BLACK_MARKET = 37841UL,
      FI_EN_BN_WHITE_SPOT = 37842UL,
      FI_EN_BN_WHITTS_BARBECUE = 37843UL,
      FI_EN_BN_WHOLE_FOODS = 37844UL,
      FI_EN_BN_WHSMITH = 37845UL,
      FI_EN_BN_WIBRA = 37846UL,
      FI_EN_BN_WIENER_SPAR_UND_KREDITINSTITUT = 37847UL,
      FI_EN_BN_WIENERSCHNITZEL = 37848UL,
      FI_EN_BN_WIENERWALD = 37849UL,
      FI_EN_BN_WIESBADENER_VOLKSBANK = 37850UL,
      FI_EN_BN_WILD_BEAN_CAFE = 37851UL,
      FI_EN_BN_WILLIAMS_COFFEE_PUB = 37852UL,
      FI_EN_BN_WILLYS_HEMMA = 37853UL,
      FI_EN_BN_WILLYS = 37854UL,
      FI_EN_BN_WIMPY = 37855UL,
      FI_EN_BN_WINCHELLS = 37856UL,
      FI_EN_BN_WIND = 37857UL,
      FI_EN_BN_WINGATE_BY_WYNDHAM = 37858UL,
      FI_EN_BN_WINGS = 37859UL,
      FI_EN_BN_WINGSTOP = 37860UL,
      FI_EN_BN_WINN_DIXIE = 37861UL,
      FI_EN_BN_WINNERS = 37862UL,
      FI_EN_BN_WINTERS = 37863UL,
      FI_EN_BN_WOLFF_CINEMA = 37864UL,
      FI_EN_BN_WOMENS_SECRET = 37865UL,
      FI_EN_BN_WONGS_WOK = 37866UL,
      FI_EN_BN_WOODYS_BARBQ = 37867UL,
      FI_EN_BN_WOOLWICH = 37868UL,
      FI_EN_BN_WORLD_WRAPPS = 37869UL,
      FI_EN_BN_WORLDHOTELS = 37870UL,
      FI_EN_BN_WORTEN = 37871UL,
      FI_EN_BN_WUESTENROT = 37872UL,
      FI_EN_BN_WYNDAM_HOTELS = 37873UL,
      FI_EN_BN_XXXLUTZ = 37874UL,
      FI_EN_BN_XYNOS = 37875UL,
      FI_EN_BN_YAKITORIYA = 37876UL,
      FI_EN_BN_YAPI_KREDI_BANKASI = 37877UL,
      FI_EN_BN_YAPOSHA = 37878UL,
      FI_EN_BN_YARD_HOUSE = 37879UL,
      FI_EN_BN_YELMO = 37880UL,
      FI_EN_BN_YOKOHAMA_RICE_BOWL = 37881UL,
      FI_EN_BN_YORKSHIRE_BANK = 37882UL,
      FI_EN_BN_YORKSHIRE_BUILDING_SOCIETY = 37883UL,
      FI_EN_BN_YOSHINOYA = 37884UL,
      FI_EN_BN_YOUNGS_BREWERY = 37885UL,
      FI_EN_BN_YOUR_HOTEL = 37886UL,
      FI_EN_BN_YOURS_TRULY = 37887UL,
      FI_EN_BN_YPF = 37888UL,
      FI_EN_BN_YUKOS = 37889UL,
      FI_EN_BN_YUNIASTRUM_BANK = 37890UL,
      FI_EN_BN_YUNIKREDIT_BANK = 37891UL,
      FI_EN_BN_YUNUS_MARKET = 37892UL,
      FI_EN_BN_YUROPET = 37893UL,
      FI_EN_BN_YX = 37894UL,
      FI_EN_BN_ZAFFARI = 37895UL,
      FI_EN_BN_ZAGREBACKA_BANKA = 37896UL,
      FI_EN_BN_ZARA = 37897UL,
      FI_EN_BN_ZAXBYS = 37898UL,
      FI_EN_BN_ZDOROVYE_LYUDI = 37899UL,
      FI_EN_BN_ZEEMAN = 37900UL,
      FI_EN_BN_ZEHRS = 37901UL,
      FI_EN_BN_ZELLERS_PHARMACY = 37902UL,
      FI_EN_BN_ZELLERS = 37903UL,
      FI_EN_BN_ZENIT = 37904UL,
      FI_EN_BN_ZENITH_BANK = 37905UL,
      FI_EN_BN_ZEYNEL_CILLI = 37906UL,
      FI_EN_BN_ZIELPUNKT = 37907UL,
      FI_EN_BN_ZIONS_BANK = 37908UL,
      FI_EN_BN_ZIONS_FIRST_NATIONAL_BANK = 37909UL,
      FI_EN_BN_ZIPPO = 37910UL,
      FI_EN_BN_ZIPPY_KIDSTORE = 37911UL,
      FI_EN_BN_ZIZ = 37912UL,
      FI_EN_BN_ZOES_KITCHEN = 37913UL,
      FI_EN_BN_ZON_LUSOMUNDO = 37914UL,
      FI_EN_BN_ZOUP_ = 37915UL,
      FI_EN_BN_ZUGER_KANTONALBANK = 37916UL,
      FI_EN_BN_ZUERCHER_KANTONALBANK = 37917UL,
      FI_EN_BN_PETIT_BISTRO = 37944UL,
      FI_EN_BN_ACCOMMODATION_GETAWAYS_VIC = 37945UL,
      FI_EN_BN_AUSTRALIS = 37946UL,
      FI_EN_BN_BED_BREAKFAST_NSW = 37947UL,
      FI_EN_BN_BED_BREAKFAST_NT = 37948UL,
      FI_EN_BN_BED_BREAKFAST_QLD = 37949UL,
      FI_EN_BN_BED_BREAKFAST_SA = 37950UL,
      FI_EN_BN_BED_BREAKFAST_TAS = 37951UL,
      FI_EN_BN_BREAKFREE = 37952UL,
      FI_EN_BN_BREAKFREE_RESORTS = 37953UL,
      FI_EN_BN_BROADWATER_RESORTS = 37954UL,
      FI_EN_BN_CHANCELLOR = 37955UL,
      FI_EN_BN_CHIFLEY = 37956UL,
      FI_EN_BN_CITIGATE = 37957UL,
      FI_EN_BN_COMFORT = 37958UL,
      FI_EN_BN_COUNTRY_COMFORT = 37959UL,
      FI_EN_BN_GOLDEN_CHAIN = 37960UL,
      FI_EN_BN_GRAND_CHANCELLOR = 37961UL,
      FI_EN_BN_GRAND_MERCURE = 37962UL,
      FI_EN_BN_HYATT = 37963UL,
      FI_EN_BN_LANDMARK_RESORTS = 37964UL,
      FI_EN_BN_LEISURE_INN = 37965UL,
      FI_EN_BN_MANNING_APARTMENT_HOTELS = 37966UL,
      FI_EN_BN_MANTRA = 37967UL,
      FI_EN_BN_MEDINA = 37968UL,
      FI_EN_BN_MEDINA_APARTMENT_HOTELS = 37969UL,
      FI_EN_BN_MERITON_APARTMENTS = 37970UL,
      FI_EN_BN_OAKFORD = 37971UL,
      FI_EN_BN_OAKS = 37972UL,
      FI_EN_BN_OAKS_HOTELS = 37973UL,
      FI_EN_BN_PACIFIC_INTERNATIONAL = 37974UL,
      FI_EN_BN_PALAZZO_RESORTS = 37975UL,
      FI_EN_BN_PARK_REGIS = 37976UL,
      FI_EN_BN_PUNTHILL_APARTMENT_HOTELS = 37977UL,
      FI_EN_BN_QUAY_GRAND_QUAY_WEST_SUITES = 37978UL,
      FI_EN_BN_CALVIN_KLEIN = 37979UL,
      FI_EN_BN_RENDEZVOUS = 37980UL,
      FI_EN_BN_RYDGES = 37981UL,
      FI_EN_BN_SAVILLE_SUITES = 37982UL,
      FI_EN_BN_SEBEL = 37983UL,
      FI_EN_BN_SHERATON_PERTH_HOTEL = 37984UL,
      FI_EN_BN_SOMERSET = 37985UL,
      FI_EN_BN_STAMFORD = 37986UL,
      FI_EN_BN_STAR_CITY_5_STAR_LUXURY = 37987UL,
      FI_EN_BN_COTTON_CLUB = 37988UL,
      FI_EN_BN_TOWN_COUNTRY_ACCOMMODATION_WA = 37989UL,
      FI_EN_BN_TRAVELODGE_HOTELS = 37990UL,
      FI_EN_BN_YHA = 37991UL,
      FI_EN_BN_AMPOL = 37992UL,
      FI_EN_BN_APCO = 37993UL,
      FI_EN_BN_BETTER_CHOICE = 37994UL,
      FI_EN_BN_BLUE_STAR = 37995UL,
      FI_EN_BN_BOGAS = 37996UL,
      FI_EN_BN_BRANBAC = 37997UL,
      FI_EN_BN_CALTEX_SAFEWAY = 37998UL,
      FI_EN_BN_CALTEX_WOOLWORTHS = 37999UL,
      FI_EN_BN_COLES_EXPRESS = 38000UL,
      FI_EN_BN_CROSS_COUNTRY = 38001UL,
      FI_EN_BN_ENFFUE = 38002UL,
      FI_EN_BN_EXCEL = 38003UL,
      FI_EN_BN_FREEDOM_FUELS = 38004UL,
      FI_EN_BN_FUEL_ZONE = 38005UL,
      FI_EN_BN_GUCCI = 38006UL,
      FI_EN_BN_MAJOR = 38007UL,
      FI_EN_BN_MATILDA_FUELS = 38008UL,
      FI_EN_BN_NEUMANN_PETROLEUM = 38009UL,
      FI_EN_BN_HUGO_BOSS = 38010UL,
      FI_EN_BN_PENTACO = 38011UL,
      FI_EN_BN_SAFF = 38012UL,
      FI_EN_BN_SOLO = 38013UL,
      FI_EN_BN_UNITED_PETROLEUM = 38014UL,
      FI_EN_BN_VOLUME_PLUS = 38015UL,
      FI_EN_BN_WESTERN_FUEL = 38016UL,
      FI_EN_BN_WOOLWORTHS = 38017UL,
      FI_EN_BN_CHALLENGE = 38018UL,
      FI_EN_BN_ATU_AUTOSERVIS_PRO_KAZDEHO = 38019UL,
      FI_EN_BN_ATU_AUTOSUPERMARKET_E_OFFICINA = 38020UL,
      FI_EN_BN_ATU_DE_COMPLETE_GARAGE = 38021UL,
      FI_EN_BN_ATU_DIE_NR1_MEISTERWERKSTATT = 38022UL,
      FI_EN_BN_AGNES_B = 38023UL,
      FI_EN_BN_AGORA = 38024UL,
      FI_EN_BN_AUGUSTA_BANK = 38025UL,
      FI_EN_BN_BAKERS_2 = 38026UL,
      FI_EN_BN_BAKERS_PHARMACY = 38027UL,
      FI_EN_BN_BASS_PRO_SHOPS = 38028UL,
      FI_EN_BN_BLAU_VERD_HOTELS = 38029UL,
      FI_EN_BN_BRANDENBURGER_BANK = 38030UL,
      FI_EN_BN_BREMISCHE_VOLKSBANK = 38031UL,
      FI_EN_BN_CEREALITY = 38032UL,
      FI_EN_BN_CHICOS = 38033UL,
      FI_EN_BN_CITY_MARKET = 38034UL,
      FI_EN_BN_CITY_MARKET_FUEL_CENTER = 38035UL,
      FI_EN_BN_CITY_MARKET_PHARMACY = 38036UL,
      FI_EN_BN_CLICKS = 38037UL,
      FI_EN_BN_COAST_GAS = 38038UL,
      FI_EN_BN_COSMOTE = 38039UL,
      FI_EN_BN_COSTA_BRAVA_HOTELS = 38040UL,
      FI_EN_BN_COULEURS_DE_TOLLENS = 38041UL,
      FI_EN_BN_CREDIT_UND_VOLKSBANK = 38042UL,
      FI_EN_BN_NEIMAN_MARCUS = 38043UL,
      FI_EN_BN_DILLONS_FUEL_CENTER = 38044UL,
      FI_EN_BN_DILLONS_MARKETPLACE = 38045UL,
      FI_EN_BN_DILLONS_MARKETPLACE_FUEL_CENTER = 38046UL,
      FI_EN_BN_DILLONS_MARKETPLACE_PHARMACY = 38047UL,
      FI_EN_BN_DILLONS_PHARMACY = 38048UL,
      FI_EN_BN_DITHMARSCHER_VR_BANK = 38049UL,
      FI_EN_BN_DORTMUNDER_VOLKSBANK = 38050UL,
      FI_EN_BN_DRESDNER_VOLKSBANK_RAIFFEISENBANK = 38051UL,
      FI_EN_BN_ECKERNFOERDER_BANK = 38052UL,
      FI_EN_BN_EDEKABANK = 38053UL,
      FI_EN_BN_EHINGER_VOLKSBANK = 38054UL,
      FI_EN_BN_EMSLAENDISCHE_VOLKSBANK = 38055UL,
      FI_EN_BN_ENZTALBANK = 38056UL,
      FI_EN_BN_ERFURTER_BANK = 38057UL,
      FI_EN_BN_EVANGELISCHE_KREDITGENOSSENSCHAFT = 38058UL,
      FI_EN_BN_FAMILYPRIX = 38059UL,
      FI_EN_BN_FARMACIILE_DONA = 38060UL,
      FI_EN_BN_FOOD_4_LESS = 38061UL,
      FI_EN_BN_FOOD_4_LESS_FUEL_CENTER = 38062UL,
      FI_EN_BN_FOOD_4_LESS_PHARMACY = 38063UL,
      FI_EN_BN_FOODS_CO = 38064UL,
      FI_EN_BN_FOODS_CO_FUEL_CENTER = 38065UL,
      FI_EN_BN_FOODS_CO_PHARMACY = 38066UL,
      FI_EN_BN_FRANKENBERGER_BANK = 38067UL,
      FI_EN_BN_FRASSES = 38068UL,
      FI_EN_BN_FRED_MEYER = 38069UL,
      FI_EN_BN_FRED_MEYER_FUEL_CENTER = 38070UL,
      FI_EN_BN_FREIBERGER_BANK = 38071UL,
      FI_EN_BN_FREISINGER_BANK = 38072UL,
      FI_EN_BN_FRYS = 38073UL,
      FI_EN_BN_FRYS_FUEL_CENTER = 38074UL,
      FI_EN_BN_FRYS_MARKETPLACE = 38075UL,
      FI_EN_BN_FRYS_MARKETPLACE_FUEL_CENTER = 38076UL,
      FI_EN_BN_FRYS_MARKETPLACE_PHARMACY = 38077UL,
      FI_EN_BN_FRYS_PHARMACY = 38078UL,
      FI_EN_BN_GENO_BANK_ESSEN = 38079UL,
      FI_EN_BN_GENOBANK_DONAUWALD = 38080UL,
      FI_EN_BN_GENOBANK_RHOEN_GRABFELD = 38081UL,
      FI_EN_BN_GENOSSENSCHAFTSBANK_UNTERALLG = 38082UL,
      FI_EN_BN_GERAER_BANK = 38083UL,
      FI_EN_BN_GERBES = 38084UL,
      FI_EN_BN_GERBES_PHARMACY = 38085UL,
      FI_EN_BN_GERMANOS = 38086UL,
      FI_EN_BN_GOLDEN_KRUST_BAKERY = 38087UL,
      FI_EN_BN_GRAFSCHAFTER_VOLKSBANK = 38088UL,
      FI_EN_BN_GROSS_GERAUER_VOLKSBANK = 38089UL,
      FI_EN_BN_H_G_BANK_HEIDELBERG_KURPFALZ = 38090UL,
      FI_EN_BN_HALLERTAUER_VOLKSBANK = 38091UL,
      FI_EN_BN_HEIDELBERGER_VOLKSBANK = 38092UL,
      FI_EN_BN_HEIDENHEIMER_VOLKSBANK = 38093UL,
      FI_EN_BN_HILANDER = 38094UL,
      FI_EN_BN_HILANDER_FUEL_CENTER = 38095UL,
      FI_EN_BN_HILANDER_PHARMACY = 38096UL,
      FI_EN_BN_HONEY_DEW_DONUTS = 38097UL,
      FI_EN_BN_JAY_C = 38098UL,
      FI_EN_BN_JAY_C_FUEL_CENTER = 38099UL,
      FI_EN_BN_JAY_C_PHARMACY = 38100UL,
      FI_EN_BN_JOHN_DORYS = 38101UL,
      FI_EN_BN_JOHNNIES = 38102UL,
      FI_EN_BN_KASSELER_BANK = 38103UL,
      FI_EN_BN_KIELER_VOLKSBANK = 38104UL,
      FI_EN_BN_KING_SOOPERS = 38105UL,
      FI_EN_BN_KING_SOOPERS_FUEL_CENTER = 38106UL,
      FI_EN_BN_KROGER_FUEL_CENTER = 38107UL,
      FI_EN_BN_KROGER_MARKETPLACE = 38108UL,
      FI_EN_BN_KROGER_MARKETPLACE_FUEL_CENTER = 38109UL,
      FI_EN_BN_KROGER_MARKETPLACE_PHARMACY = 38110UL,
      FI_EN_BN_KULMBACHER_BANK = 38111UL,
      FI_EN_BN_LANDSBERG_AMMERSEE_BANK = 38112UL,
      FI_EN_BN_LARKSPUR_HOTELS = 38113UL,
      FI_EN_BN_LEDO_PIZZA_AND_PASTA = 38114UL,
      FI_EN_BN_LEUTKIRCHER_BANK = 38115UL,
      FI_EN_BN_LEVOBANK = 38116UL,
      FI_EN_BN_LIGA_BANK = 38117UL,
      FI_EN_BN_LOAF_N_JUG = 38118UL,
      FI_EN_BN_LOXAM = 38119UL,
      FI_EN_BN_MAERKISCHE_BANK = 38120UL,
      FI_EN_BN_MCCAFE = 38121UL,
      FI_EN_BN_MERCHANTS_TIRE_AUTO = 38122UL,
      FI_EN_BN_MUENCHNER_BANK = 38123UL,
      FI_EN_BN_NORDTHUERINGER_VOLKSBANK = 38124UL,
      FI_EN_BN_OIL_CAN_HENRYS = 38125UL,
      FI_EN_BN_OSTFRIESISCHE_VOLKSBANK = 38126UL,
      FI_EN_BN_OSTHARZER_VOLKSBANK = 38127UL,
      FI_EN_BN_OWENS = 38128UL,
      FI_EN_BN_OWENS_FUEL_CENTER = 38129UL,
      FI_EN_BN_OWENS_PHARMACY = 38130UL,
      FI_EN_BN_PAY_LESS_FUEL_CENTER = 38131UL,
      FI_EN_BN_PAY_LESS_PHARMACY = 38132UL,
      FI_EN_BN_PENNYPINCHERS = 38133UL,
      FI_EN_BN_PETITS_GRANS_HOTELS_DE_CATALUNYA = 38134UL,
      FI_EN_BN_PETRO_T = 38135UL,
      FI_EN_BN_PHARMAVIE = 38136UL,
      FI_EN_BN_POMMERSCHE_VOLKSBANK = 38137UL,
      FI_EN_BN_PRICE_RITE = 38138UL,
      FI_EN_BN_PRICE_RITE_PHARMACY = 38139UL,
      FI_EN_BN_QFC = 38140UL,
      FI_EN_BN_QFC_FUEL_CENTER = 38141UL,
      FI_EN_BN_QFC_PHARMACY = 38142UL,
      FI_EN_BN_RAIFFEISEN_SPAR_KREDITBANK = 38143UL,
      FI_EN_BN_RAIFFEISENBANK_AUGSBURGER_LAND_WEST = 38144UL,
      FI_EN_BN_RAIFFEISENBANK_BAD_ABBACH_SAAL = 38145UL,
      FI_EN_BN_RAIFFEISENBANK_BURGAU = 38146UL,
      FI_EN_BN_RAIFFEISENBANK_DONAU_HEUBERG = 38147UL,
      FI_EN_BN_RAIFFEISENBANK_EHINGEN_HOCHSTRAESS = 38148UL,
      FI_EN_BN_RAIFFEISENBANK_ERKELENZ = 38149UL,
      FI_EN_BN_RAIFFEISENBANK_GREVENBROICH = 38150UL,
      FI_EN_BN_RAIFFEISENBANK_GROSSENLUEDER = 38151UL,
      FI_EN_BN_RAIFFEISENBANK_HAMMELBURG = 38152UL,
      FI_EN_BN_RAIFFEISENBANK_HEINSBERG = 38153UL,
      FI_EN_BN_RAIFFEISENBANK_IM_ALLGAEUER_LAND = 38154UL,
      FI_EN_BN_RAIFFEISENBANK_IM_KREIS_CALW = 38155UL,
      FI_EN_BN_RAIFFEISENBANK_IM_NAABTAL = 38156UL,
      FI_EN_BN_RAIFFEISENBANK_IM_OBERLAND = 38157UL,
      FI_EN_BN_RAIFFEISENBANK_IM_STIFTLAND = 38158UL,
      FI_EN_BN_RAIFFEISENBANK_ISAR_LOISACHTAL = 38159UL,
      FI_EN_BN_RAIFFEISENBANK_KARLSTADT_GEMUENDEN = 38160UL,
      FI_EN_BN_RAIFFEISENBANK_KEMPTEN = 38161UL,
      FI_EN_BN_RAIFFEISENBANK_KIRCHWEIHTAL = 38162UL,
      FI_EN_BN_RAIFFEISENBANK_KRUMBACH = 38163UL,
      FI_EN_BN_RAIFFEISENBANK_LOHR_AM_MAIN = 38164UL,
      FI_EN_BN_RAIFFEISENBANK_MARKTHEIDENFELD = 38165UL,
      FI_EN_BN_RAIFFEISENBANK_OBERALLGAEU_SUED = 38166UL,
      FI_EN_BN_RAIFFEISENBANK_OBERMAIN_NORD = 38167UL,
      FI_EN_BN_RAIFFEISENBANK_OBERPFALZ_SUED = 38168UL,
      FI_EN_BN_RAIFFEISENBANK_RHEINBACH_VOREIFEL = 38169UL,
      FI_EN_BN_RAIFFEISENBANK_RHEIN_BERG = 38170UL,
      FI_EN_BN_RAIFFEISENBANK_RISSTAL = 38171UL,
      FI_EN_BN_RAIFFEISENBANK_RONSHAUSEN_MARKSUHL = 38172UL,
      FI_EN_BN_RAIFFEISENBANK_ROSDORF = 38173UL,
      FI_EN_BN_RAIFFEISENBANK_ROTTUMTAL = 38174UL,
      FI_EN_BN_RAIFFEISENBANK_SCHWANDORF_NITTENAU = 38175UL,
      FI_EN_BN_RAIFFEISENBANK_STRAUBING = 38176UL,
      FI_EN_BN_RAIFFEISENBANK_TOELZER_LAND = 38177UL,
      FI_EN_BN_RAIFFEISENBANK_TROSTBERG_TRAUNREUT = 38178UL,
      FI_EN_BN_RAIFFEISENBANK_VOLKACH_WIESENTHEID = 38179UL,
      FI_EN_BN_RAIFFEISENBANK_WESERMARSCH_SUED = 38180UL,
      FI_EN_BN_RAIFFEISENBANK_WESTEIFEL = 38181UL,
      FI_EN_BN_RAIFFEISENBANK_VOLKSBANK_MILTENBERG = 38182UL,
      FI_EN_BN_RAIFFEISEN_VB_BAD_STAFFELSTEIN = 38183UL,
      FI_EN_BN_RAIFFEISEN_VB_DONAUWOERTH = 38184UL,
      FI_EN_BN_RAIFFEISEN_VB_FUERTH = 38185UL,
      FI_EN_BN_RAIFFEISEN_VB_LICHTENFELS_ITZGRUND = 38186UL,
      FI_EN_BN_RAIFFEISEN_VOLKSBANK_EBERSBERG = 38187UL,
      FI_EN_BN_RAIFFEISEN_VOLKSBANK_FRESENA = 38188UL,
      FI_EN_BN_RAIFFEISENVOLKSBANK_GEWERBEBANK = 38189UL,
      FI_EN_BN_RAIFFEISEN_VOLKSBANK_HASSBERGE = 38190UL,
      FI_EN_BN_RAIFFEISEN_VOLKSBANK_ISEN_SEMPT = 38191UL,
      FI_EN_BN_RAIFFEISEN_VOLKSBANK_RIES = 38192UL,
      FI_EN_BN_RAIFFEISEN_VOLKSBANK_SAALE_ORLA = 38193UL,
      FI_EN_BN_RALPHS_FUEL_CENTER = 38194UL,
      FI_EN_BN_RALPHS_PHARMACY = 38195UL,
      FI_EN_BN_RANCH_1 = 38196UL,
      FI_EN_BN_RB_ALTDORF_ERGOLDING = 38197UL,
      FI_EN_BN_RB_ASCHAFFENBURG = 38198UL,
      FI_EN_BN_RB_BAD_GOEGGING = 38199UL,
      FI_EN_BN_RB_BAD_WINDSHEIM = 38200UL,
      FI_EN_BN_RB_CHAM_RODING_FURTH_IM_WALD = 38201UL,
      FI_EN_BN_RB_DEGGENDORF_PLATTLING = 38202UL,
      FI_EN_BN_RB_DONAU_ILLER = 38203UL,
      FI_EN_BN_RB_ESTENFELD_BERGTHEIM = 38204UL,
      FI_EN_BN_RB_FUESSEN_PFRONTEN_NESSELWANG = 38205UL,
      FI_EN_BN_RB_GRAEFENB_FORCHH_ESCH_HEROLDSB = 38206UL,
      FI_EN_BN_RB_GROSSOSTHEIM_OBERNBURG = 38207UL,
      FI_EN_BN_RB_HALLERTAU = 38208UL,
      FI_EN_BN_RB_HERSBRUCK = 38209UL,
      FI_EN_BN_RB_HOECHBERG = 38210UL,
      FI_EN_BN_RB_I_LKRS_PASSAU_NORD = 38211UL,
      FI_EN_BN_RB_KEMNATHER_LAND_STEINWALD = 38212UL,
      FI_EN_BN_RB_KITZINGER_LAND = 38213UL,
      FI_EN_BN_RB_KOCHER_JAGST = 38214UL,
      FI_EN_BN_RB_MECKLENBURGER_SEENPLATTE = 38215UL,
      FI_EN_BN_RB_MITTELRHEIN = 38216UL,
      FI_EN_BN_RB_MUENCHEN_NORD = 38217UL,
      FI_EN_BN_RB_NEUMARKT_I_D_OPF = 38218UL,
      FI_EN_BN_RB_NEUSTADT_VOHENSTRAUSS = 38219UL,
      FI_EN_BN_RB_OCHSENFURT = 38220UL,
      FI_EN_BN_RB_OESTLICHE_SUEDEIFEL = 38221UL,
      FI_EN_BN_RB_PFAFFENWINKEL = 38222UL,
      FI_EN_BN_RB_RAIN_AM_LECH = 38223UL,
      FI_EN_BN_RB_ROTH_SCHWABACH = 38224UL,
      FI_EN_BN_RB_STAUDEN = 38225UL,
      FI_EN_BN_RB_SULZBACH_ROSENBERG = 38226UL,
      FI_EN_BN_RB_VILSHOFENER_LAND = 38227UL,
      FI_EN_BN_RB_WEIDEN = 38228UL,
      FI_EN_BN_RB_WEILHEIM = 38229UL,
      FI_EN_BN_RB_WEISSENBURG_GUNZENHAUSEN = 38230UL,
      FI_EN_BN_RB_WERRATAL_LANDECK = 38231UL,
      FI_EN_BN_RHEINGAUER_VB = 38232UL,
      FI_EN_BN_ROLLERZ = 38233UL,
      FI_EN_BN_ROTTALER_RB = 38234UL,
      FI_EN_BN_ROTTALER_VOLKSBANK_RAIFFEISENBANK = 38235UL,
      FI_EN_BN_RULER = 38236UL,
      FI_EN_BN_RUESSELSHEIMER_VB = 38237UL,
      FI_EN_BN_RV_BANK_RHEIN_HAARDT = 38238UL,
      FI_EN_BN_RVB_EBERN = 38239UL,
      FI_EN_BN_RVB_ERLANGEN_HOECHSTADT = 38240UL,
      FI_EN_BN_RVB_KRONACH_LUDWIGSSTADT = 38241UL,
      FI_EN_BN_RVB_NEUBURG_DONAU = 38242UL,
      FI_EN_BN_SAMURAI_SAMS = 38243UL,
      FI_EN_BN_SCOTTS = 38244UL,
      FI_EN_BN_SCOTTS_FUEL_CENTER = 38245UL,
      FI_EN_BN_SCOTTS_PHARMACY = 38246UL,
      FI_EN_BN_SELECT_REGISTRY = 38247UL,
      FI_EN_BN_SMITHS = 38248UL,
      FI_EN_BN_SMITHS_FUEL_CENTER = 38249UL,
      FI_EN_BN_SMITHS_MARKETPLACE = 38250UL,
      FI_EN_BN_SMITHS_MARKETPLACE_FUEL_CENTER = 38251UL,
      FI_EN_BN_SMITHS_MARKETPLACE_PHARMACY = 38252UL,
      FI_EN_BN_SMITHS_PHARMACY = 38253UL,
      FI_EN_BN_SPAR_UND_KREDITBANK = 38254UL,
      FI_EN_BN_SPREEWALDBANK = 38255UL,
      FI_EN_BN_ST_LOUIS_BREAD_CO = 38256UL,
      FI_EN_BN_ST_WENDELER_VB = 38257UL,
      FI_EN_BN_STAYEASY = 38258UL,
      FI_EN_BN_SURF_CITY_SQUEEZE = 38259UL,
      FI_EN_BN_TIMBERCITY = 38260UL,
      FI_EN_BN_TOMMY_BAHAMA = 38261UL,
      FI_EN_BN_TURKEY_HILL = 38262UL,
      FI_EN_BN_ULMER_VOLKSBANK = 38263UL,
      FI_EN_BN_URENDE = 38264UL,
      FI_EN_BN_VB_BACKNANG = 38265UL,
      FI_EN_BN_VB_BAD_DRIBURG_BRAKEL_STEINHEIM = 38266UL,
      FI_EN_BN_VB_BAD_SAULGAU = 38267UL,
      FI_EN_BN_VB_BADEN_BADEN_RASTATT = 38268UL,
      FI_EN_BN_VB_BAUTZEN = 38269UL,
      FI_EN_BN_VB_BITBURG = 38270UL,
      FI_EN_BN_VB_BRAMGAU_IM_OSNABRUECKER_LAND = 38271UL,
      FI_EN_BN_VB_BREISGAU_SUED = 38272UL,
      FI_EN_BN_VB_BUEREN_UND_SALZKOTTEN = 38273UL,
      FI_EN_BN_VB_CHEMNITZ = 38274UL,
      FI_EN_BN_VB_DARMSTADT_KREIS_BERGSTRASSE = 38275UL,
      FI_EN_BN_VB_DILL_VB_UND_RB = 38276UL,
      FI_EN_BN_VB_ERKELENZ_HUECKELHOVEN_WEGBERG = 38277UL,
      FI_EN_BN_VB_ETTLINGEN = 38278UL,
      FI_EN_BN_VB_FREIBURG = 38279UL,
      FI_EN_BN_VB_GLAN_MUENCHWEILER = 38280UL,
      FI_EN_BN_VB_GRONAU_AHAUS = 38281UL,
      FI_EN_BN_VB_HERRENBERG_ROTTENBURG = 38282UL,
      FI_EN_BN_VB_HEUCHELHEIM = 38283UL,
      FI_EN_BN_VB_HOHENLOHE = 38284UL,
      FI_EN_BN_VB_KAISERSLAUTERN_NORDWESTPFALZ = 38285UL,
      FI_EN_BN_VB_KIRNAU = 38286UL,
      FI_EN_BN_VB_KRAICHGAU = 38287UL,
      FI_EN_BN_VB_LAUTERBACH_SCHLITZ = 38288UL,
      FI_EN_BN_VB_LAUTERECKEN = 38289UL,
      FI_EN_BN_VB_LUDWIGSBURG = 38290UL,
      FI_EN_BN_VB_MAGDEBURG = 38291UL,
      FI_EN_BN_VB_MAIN_TAUNUS = 38292UL,
      FI_EN_BN_VB_MESSKIRCH_RB = 38293UL,
      FI_EN_BN_VB_MITTLERES_ERZGEBIRGE = 38294UL,
      FI_EN_BN_VB_MOECKMUEHL_NEUENSTADT = 38295UL,
      FI_EN_BN_VB_NAGOLDTAL = 38296UL,
      FI_EN_BN_VB_NORDOBERPFALZ = 38297UL,
      FI_EN_BN_VB_NORDSCHWARZWALD = 38298UL,
      FI_EN_BN_VB_OSTERBURG_LUECHOW_DANNENBERG = 38299UL,
      FI_EN_BN_VB_OSTLIPPE = 38300UL,
      FI_EN_BN_VB_PFORZHEIM = 38301UL,
      FI_EN_BN_VB_RB_EICHSTAETT = 38302UL,
      FI_EN_BN_VB_REISTE_ESLOHE = 38303UL,
      FI_EN_BN_VB_RHEIN_LAHN = 38304UL,
      FI_EN_BN_VB_RIESA = 38305UL,
      FI_EN_BN_VB_RION_LEONBERG = 38306UL,
      FI_EN_BN_VB_ROTTWEIL = 38307UL,
      FI_EN_BN_VB_SAALETAL = 38308UL,
      FI_EN_BN_VB_SAARLOUIS = 38309UL,
      FI_EN_BN_VB_SAAR_WEST = 38310UL,
      FI_EN_BN_VB_SCHMALLENBERG = 38311UL,
      FI_EN_BN_VB_SCHWAEBISCH_GMUEND = 38312UL,
      FI_EN_BN_VB_SULMTAL = 38313UL,
      FI_EN_BN_VB_TUEBINGEN = 38314UL,
      FI_EN_BN_VB_UND_RB_EISENACH = 38315UL,
      FI_EN_BN_VB_UNTERE_SAAR = 38316UL,
      FI_EN_BN_VB_WILFERDINGEN_KELTERN = 38317UL,
      FI_EN_BN_VB_WORMS_WONNEGAU = 38318UL,
      FI_EN_BN_VB_RB_DEGGINGEN = 38319UL,
      FI_EN_BN_VB_RB_DINGOLFING = 38320UL,
      FI_EN_BN_VB_RB_MEISSEN_GROSSENHAIN = 38321UL,
      FI_EN_BN_VB_RB_RIEDLINGEN = 38322UL,
      FI_EN_BN_VER_VB_REGIONALVERBAND_SAARBRUECKEN = 38323UL,
      FI_EN_BN_VEREINIGTE_RB_BURGSTAEDT = 38324UL,
      FI_EN_BN_VEREINIGTE_VOLKSBANK = 38325UL,
      FI_EN_BN_VEREINIGTE_VOLKSBANK_LIMBURG = 38326UL,
      FI_EN_BN_VEREINIGTE_VOLKSBANK_MAINGAU = 38327UL,
      FI_EN_BN_VEREINIGTE_VOLKSBANK_RAIFFEISENBANK = 38328UL,
      FI_EN_BN_VOLKSBANK_ACHERN = 38329UL,
      FI_EN_BN_VOLKSBANK_ALLGAEU_WEST = 38330UL,
      FI_EN_BN_VOLKSBANK_ALZEY = 38331UL,
      FI_EN_BN_VOLKSBANK_AN_DER_NIERS = 38332UL,
      FI_EN_BN_VOLKSBANK_BAD_OEYNHAUSEN_HERFORD = 38333UL,
      FI_EN_BN_VOLKSBANK_BAD_SALZUFLEN = 38334UL,
      FI_EN_BN_VOLKSBANK_BALINGEN = 38335UL,
      FI_EN_BN_VOLKSBANK_BECKUM = 38336UL,
      FI_EN_BN_VOLKSBANK_BIGGE_LENNE = 38337UL,
      FI_EN_BN_VOLKSBANK_BOCHUM_WITTEN = 38338UL,
      FI_EN_BN_VOLKSBANK_BONN_RHEIN_SIEG = 38339UL,
      FI_EN_BN_VOLKSBANK_BOERDE_BERNBURG = 38340UL,
      FI_EN_BN_VOLKSBANK_BRACKENHEIM_GUEGLINGEN = 38341UL,
      FI_EN_BN_VOLKSBANK_BRAUNSCHWEIG_WOLFSBURG = 38342UL,
      FI_EN_BN_VOLKSBANK_BREISGAU_NORD = 38343UL,
      FI_EN_BN_VOLKSBANK_BREMEN_NORD = 38344UL,
      FI_EN_BN_VOLKSBANK_BREMERHAVEN_CUXLAND = 38345UL,
      FI_EN_BN_VOLKSBANK_BRENZTAL = 38346UL,
      FI_EN_BN_VOLKSBANK_BRILON = 38347UL,
      FI_EN_BN_VOLKSBANK_BRUCHSAL_BRETTEN = 38348UL,
      FI_EN_BN_VOLKSBANK_BRUHRAIN_KRAICH_HARDT = 38349UL,
      FI_EN_BN_VOLKSBANK_BUEHL = 38350UL,
      FI_EN_BN_VOLKSBANK_DESSAU_ANHALT = 38351UL,
      FI_EN_BN_VOLKSBANK_DILLINGEN = 38352UL,
      FI_EN_BN_VOLKSBANK_DONAU_NECKAR = 38353UL,
      FI_EN_BN_VOLKSBANK_DORNSTETTEN = 38354UL,
      FI_EN_BN_VOLKSBANK_DREIEICH = 38355UL,
      FI_EN_BN_VOLKSBANK_DREILAENDERECK = 38356UL,
      FI_EN_BN_VOLKSBANK_DUEREN = 38357UL,
      FI_EN_BN_VOLKSBANK_DUESSELDORF_NEUSS = 38358UL,
      FI_EN_BN_VOLKSBANK_EBINGEN = 38359UL,
      FI_EN_BN_VOLKSBANK_EICHSFELD_NORTHEIM = 38360UL,
      FI_EN_BN_VOLKSBANK_EIFEL_MITTE = 38361UL,
      FI_EN_BN_VOLKSBANK_EINBECK = 38362UL,
      FI_EN_BN_VOLKSBANK_ELMSHORN = 38363UL,
      FI_EN_BN_VOLKSBANK_ELSTERLAND = 38364UL,
      FI_EN_BN_VOLKSBANK_EMMERICH_REES = 38365UL,
      FI_EN_BN_VOLKSBANK_ERFT = 38366UL,
      FI_EN_BN_VOLKSBANK_ESSLINGEN = 38367UL,
      FI_EN_BN_VOLKSBANK_EUSKIRCHEN = 38368UL,
      FI_EN_BN_VOLKSBANK_EUTIN_RAIFFEISENBANK = 38369UL,
      FI_EN_BN_VOLKSBANK_FORCHHEIM = 38370UL,
      FI_EN_BN_VOLKSBANK_FRANKEN = 38371UL,
      FI_EN_BN_VOLKSBANK_GEEST = 38372UL,
      FI_EN_BN_VOLKSBANK_GMHUETTE_HAGEN_BISSENDORF = 38373UL,
      FI_EN_BN_VOLKSBANK_GOETTINGEN = 38374UL,
      FI_EN_BN_VOLKSBANK_GRAFSCHAFT_HOYA = 38375UL,
      FI_EN_BN_VOLKSBANK_GUETERSLOH = 38376UL,
      FI_EN_BN_VOLKSBANK_HALLE_SAALE_ = 38377UL,
      FI_EN_BN_VOLKSBANK_HAMELN_STADTHAGEN = 38378UL,
      FI_EN_BN_VOLKSBANK_HAMM = 38379UL,
      FI_EN_BN_VOLKSBANK_HEGAU = 38380UL,
      FI_EN_BN_VOLKSBANK_HELLWEG = 38381UL,
      FI_EN_BN_VOLKSBANK_HELMSTEDT = 38382UL,
      FI_EN_BN_VOLKSBANK_HILDESHEIM = 38383UL,
      FI_EN_BN_VOLKSBANK_HILDESHEIMER_BOERDE = 38384UL,
      FI_EN_BN_VOLKSBANK_HOCHRHEIN = 38385UL,
      FI_EN_BN_VOLKSBANK_HORB_FREUDENSTADT = 38386UL,
      FI_EN_BN_VOLKSBANK_HUNSRUECK_NAHE = 38387UL,
      FI_EN_BN_VOLKSBANK_IM_HARZ = 38388UL,
      FI_EN_BN_VOLKSBANK_IM_MAERKISCHEN_KREIS = 38389UL,
      FI_EN_BN_VOLKSBANK_IN_SCHAUMBURG = 38390UL,
      FI_EN_BN_VOLKSBANK_JEVER = 38391UL,
      FI_EN_BN_VOLKSBANK_KINZIGTAL = 38392UL,
      FI_EN_BN_VOLKSBANK_KIRCHHEIM_NUERTINGEN = 38393UL,
      FI_EN_BN_VOLKSBANK_KLEVERLAND = 38394UL,
      FI_EN_BN_VOLKSBANK_KOBLENZ_MITTELRHEIN = 38395UL,
      FI_EN_BN_VOLKSBANK_KONSTANZ = 38396UL,
      FI_EN_BN_VOLKSBANK_KREFELD = 38397UL,
      FI_EN_BN_VOLKSBANK_KUR_UND_RHEINPFALZ = 38398UL,
      FI_EN_BN_VOLKSBANK_LAHR = 38399UL,
      FI_EN_BN_VOLKSBANK_LAUPHEIM = 38400UL,
      FI_EN_BN_VOLKSBANK_LEIPZIG = 38401UL,
      FI_EN_BN_VOLKSBANK_LINGEN = 38402UL,
      FI_EN_BN_VOLKSBANK_LOEBAU_ZITTAU = 38403UL,
      FI_EN_BN_VOLKSBANK_LUEBBECKER_LAND = 38404UL,
      FI_EN_BN_VOLKSBANK_LUENEBURGER_HEIDE = 38405UL,
      FI_EN_BN_VOLKSBANK_MAIN_TAUBER = 38406UL,
      FI_EN_BN_VOLKSBANK_MARL_RECKLINGHAUSEN = 38407UL,
      FI_EN_BN_VOLKSBANK_METZINGEN_BAD_URACH = 38408UL,
      FI_EN_BN_VOLKSBANK_MINDEN_HILLE_PORTA = 38409UL,
      FI_EN_BN_VOLKSBANK_MITTELHESSEN = 38410UL,
      FI_EN_BN_VOLKSBANK_MOENCHENGLADBACH = 38411UL,
      FI_EN_BN_VOLKSBANK_MOSBACH = 38412UL,
      FI_EN_BN_VOLKSBANK_MUENSINGEN = 38413UL,
      FI_EN_BN_VOLKSBANK_MUENSTER = 38414UL,
      FI_EN_BN_VOLKSBANK_NECKARTAL = 38415UL,
      FI_EN_BN_VOLKSBANK_NEUNKIRCHEN = 38416UL,
      FI_EN_BN_VOLKSBANK_NIEDERRHEIN = 38417UL,
      FI_EN_BN_VOLKSBANK_NORDHARZ = 38418UL,
      FI_EN_BN_VOLKSBANK_NORDHEIDE = 38419UL,
      FI_EN_BN_VOLKSBANK_OBERBERG = 38420UL,
      FI_EN_BN_VOLKSBANK_ODENWALD = 38421UL,
      FI_EN_BN_VOLKSBANK_OFFENBURG = 38422UL,
      FI_EN_BN_VOLKSBANK_OSNABRUECK = 38423UL,
      FI_EN_BN_VOLKSBANK_PEINE = 38424UL,
      FI_EN_BN_VOLKSBANK_RAIFFEISENBANK_DACHAU = 38425UL,
      FI_EN_BN_VOLKSBANK_RAIFFEISENBANK_ITZEHOE = 38426UL,
      FI_EN_BN_VOLKSBANK_RAIFFEISENBANK_WUERZBURG = 38427UL,
      FI_EN_BN_VOLKSBANK_REMSCHEID_SOLINGEN = 38428UL,
      FI_EN_BN_VOLKSBANK_REUTLINGEN = 38429UL,
      FI_EN_BN_VOLKSBANK_RHEINAHREIFEL = 38430UL,
      FI_EN_BN_VOLKSBANK_RHEIN_LIPPE = 38431UL,
      FI_EN_BN_VOLKSBANK_RHEIN_NAHE_HUNSRUECK = 38432UL,
      FI_EN_BN_VOLKSBANK_RHEIN_RUHR = 38433UL,
      FI_EN_BN_VOLKSBANK_RHEIN_WEHRA = 38434UL,
      FI_EN_BN_VOLKSBANK_RHEIN_WUPPER = 38435UL,
      FI_EN_BN_VOLKSBANK_RUHR_MITTE = 38436UL,
      FI_EN_BN_VOLKSBANK_SAARPFALZ = 38437UL,
      FI_EN_BN_VOLKSBANK_SAUERLAND = 38438UL,
      FI_EN_BN_VOLKSBANK_SCHWARZWALD_NECKAR = 38439UL,
      FI_EN_BN_VOLKSBANK_SOLLING = 38440UL,
      FI_EN_BN_VOLKSBANK_STORMARN = 38441UL,
      FI_EN_BN_VOLKSBANK_SUED_EMSLAND = 38442UL,
      FI_EN_BN_VOLKSBANK_SUEDHEIDE = 38443UL,
      FI_EN_BN_VOLKSBANK_SULINGEN = 38444UL,
      FI_EN_BN_VOLKSBANK_TECKLENBURGER_LAND = 38445UL,
      FI_EN_BN_VOLKSBANK_TRIER = 38446UL,
      FI_EN_BN_VOLKSBANK_UELZEN_SALZWEDEL = 38447UL,
      FI_EN_BN_VOLKSBANK_UNNA = 38448UL,
      FI_EN_BN_VOLKSBANK_VERDEN = 38449UL,
      FI_EN_BN_VOLKSBANK_VOGTLAND = 38450UL,
      FI_EN_BN_VOLKSBANK_WARBURGER_LAND = 38451UL,
      FI_EN_BN_VOLKSBANK_WENDEN_DROLSHAGEN = 38452UL,
      FI_EN_BN_VOLKSBANK_WESERBERGLAND = 38453UL,
      FI_EN_BN_VOLKSBANK_WIESLOCH = 38454UL,
      FI_EN_BN_VOLKSBANK_WITTINGEN_KLOETZE = 38455UL,
      FI_EN_BN_VOLKSBANK_WOLFENBUETTEL_SALZGITTER = 38456UL,
      FI_EN_BN_VOLKSBANK_RAIFFEISENBANK_AMBERG = 38457UL,
      FI_EN_BN_VOLKSBANK_RAIFFEISENBANK_DOEBELN = 38458UL,
      FI_EN_BN_VOLKS_UND_RAIFFEISENBANK_PRIGNITZ = 38459UL,
      FI_EN_BN_VOLKS_UND_RAIFFEISENBANK_WISMAR = 38460UL,
      FI_EN_BN_VR_BANK_BAMBERG = 38461UL,
      FI_EN_BN_VR_BANK_BIEDENKOPF_GLADENBACH = 38462UL,
      FI_EN_BN_VR_BANK_DINKELSBUEHL = 38463UL,
      FI_EN_BN_VR_BANK_FLENSBURG_SCHLESWIG = 38464UL,
      FI_EN_BN_VR_BANK_HESSENLAND = 38465UL,
      FI_EN_BN_VR_BANK_IM_ENZKREIS = 38466UL,
      FI_EN_BN_VR_BANK_KAUFBEUREN_OSTALLGAEU = 38467UL,
      FI_EN_BN_VR_BANK_KITZINGEN = 38468UL,
      FI_EN_BN_VR_BANK_LAUSITZ = 38469UL,
      FI_EN_BN_VR_BANK_MAIN_KINZIG_BUEDINGEN = 38470UL,
      FI_EN_BN_VR_BANK_MITTELHAARDT = 38471UL,
      FI_EN_BN_VR_BANK_MUENCHEN_LAND = 38472UL,
      FI_EN_BN_VR_BANK_NIEBUELL = 38473UL,
      FI_EN_BN_VR_BANK_NUERNBERG = 38474UL,
      FI_EN_BN_VR_BANK_OSTHOLSTEIN_NORD_PLOEN = 38475UL,
      FI_EN_BN_VR_BANK_PINNEBERG = 38476UL,
      FI_EN_BN_VR_BANK_RHEIN_MOSEL = 38477UL,
      FI_EN_BN_VR_BANK_ROSENHEIM_CHIEMSEE = 38478UL,
      FI_EN_BN_VR_BANK_SAARPFALZ = 38479UL,
      FI_EN_BN_VR_BANK_SCHWAEBISCH_HALL_CRAILSHEIM = 38480UL,
      FI_EN_BN_VR_BANK_SUEDLICHE_WEINSTRASSE = 38481UL,
      FI_EN_BN_VR_BANK_SUEDPFALZ = 38482UL,
      FI_EN_BN_VR_BANK_SUEDTHUERINGEN = 38483UL,
      FI_EN_BN_VR_BANK_SUEDWESTPFALZ = 38484UL,
      FI_EN_BN_VR_BANK_UNTERTAUNUS = 38485UL,
      FI_EN_BN_VR_BANK_WESTTHUERINGEN = 38486UL,
      FI_EN_BN_VR_MEINE_RAIFFEISENBANK = 38487UL,
      FI_EN_BN_VR_BANK_AALEN = 38488UL,
      FI_EN_BN_VR_BANK_ALB = 38489UL,
      FI_EN_BN_VR_BANK_ALTENBURGER_LAND = 38490UL,
      FI_EN_BN_VR_BANK_ASPERG_MARKGROENINGEN = 38491UL,
      FI_EN_BN_VR_BANK_BGLADBACH_OVERATH_ROESRATH = 38492UL,
      FI_EN_BN_VR_BANK_BAD_HERSFELD_ROTENBURG = 38493UL,
      FI_EN_BN_VR_BANK_BAD_KISSINGEN_BAD_BRUECKENAU = 38494UL,
      FI_EN_BN_VR_BANK_BAD_SALZUNGEN_SCHMALKALDEN = 38495UL,
      FI_EN_BN_VR_BANK_BAYREUTH = 38496UL,
      FI_EN_BN_VR_BANK_BONN = 38497UL,
      FI_EN_BN_VR_BANK_COBURG = 38498UL,
      FI_EN_BN_VR_BANK_ELLWANGEN = 38499UL,
      FI_EN_BN_VR_BANK_FICHTELGEBIRGE = 38500UL,
      FI_EN_BN_VR_BANK_FUERSTENFELDBRUCK = 38501UL,
      FI_EN_BN_VR_BANK_FUERSTENWALDE_SEELOW_WRIEZEN = 38502UL,
      FI_EN_BN_VR_BANK_GEROLZHOFEN = 38503UL,
      FI_EN_BN_VR_BANK_HUNSRUECK_MOSEL = 38504UL,
      FI_EN_BN_VR_BANK_IM_KREIS_RENDSBURG = 38505UL,
      FI_EN_BN_VR_BANK_IN_MITTELBADEN = 38506UL,
      FI_EN_BN_VR_BANK_LANDAU = 38507UL,
      FI_EN_BN_VR_BANK_LECH_ZUSAM = 38508UL,
      FI_EN_BN_VR_BANK_LKR_GARMISCH_PARTENKIRCHEN = 38509UL,
      FI_EN_BN_VR_BANK_MANGFALLTAL_ROSENHEIM = 38510UL,
      FI_EN_BN_VR_BANK_MEMMINGEN = 38511UL,
      FI_EN_BN_VR_BANK_NEU_ULM_WEISSENHORN = 38512UL,
      FI_EN_BN_VR_BANK_NEUWIED_LINZ = 38513UL,
      FI_EN_BN_VR_BANK_NIEDERSCHLESIEN = 38514UL,
      FI_EN_BN_VR_BANK_NORDEIFEL = 38515UL,
      FI_EN_BN_VR_BANK_NORDRHOEN = 38516UL,
      FI_EN_BN_VR_BANK_OBERBAYERN_SUEDOST = 38517UL,
      FI_EN_BN_VR_BANK_PASSAU = 38518UL,
      FI_EN_BN_VR_BANK_RAIFFEISENBANK_BAYERN_MITTE = 38519UL,
      FI_EN_BN_VR_BANK_RHEIN_ERFT = 38520UL,
      FI_EN_BN_VR_BANK_RHEIN_SIEG = 38521UL,
      FI_EN_BN_VR_BANK_RHOEN_GRABFELD = 38522UL,
      FI_EN_BN_VR_BANK_ROTHENBURG_O_D_TBR = 38523UL,
      FI_EN_BN_VR_BANK_ROTTAL_INN = 38524UL,
      FI_EN_BN_VR_BANK_STROMBERG_NECKAR = 38525UL,
      FI_EN_BN_VR_BANK_TAUFKIRCHEN_DORFEN = 38526UL,
      FI_EN_BN_VR_BANK_UCKERMARK_RANDOW = 38527UL,
      FI_EN_BN_VR_BANK_UFFENHEIM_NEUSTADT = 38528UL,
      FI_EN_BN_VR_BANK_VILSBIBURG = 38529UL,
      FI_EN_BN_VR_BANK_WERRA_MEISSNER = 38530UL,
      FI_EN_BN_VR_BANK_WESTMUENSTERLAND = 38531UL,
      FI_EN_BN_VR_BANK_WESTPFALZ = 38532UL,
      FI_EN_BN_V_UND_RB_SAALE_UNSTRUT = 38533UL,
      FI_EN_BN_WALDECKER_BANK = 38534UL,
      FI_EN_BN_WESTERWALD_BANK = 38535UL,
      FI_EN_BN_WILSONS = 38536UL,
      FI_EN_BN_YOGEN_FRUZ = 38537UL,
      FI_EN_CC_AMERICANEXPRESS = 60000UL,
      FI_EN_CC_BARCLAYCARD = 60001UL,
      FI_EN_CC_CARTEBLEU = 60002UL,
      FI_EN_CC_ACCESS = 60003UL,
      FI_EN_CC_CONNECTCARD = 60004UL,
      FI_EN_CC_DELTACARD = 60005UL,
      FI_EN_CC_SWITCHCARD = 60006UL,
      FI_EN_CC_TARJETA6000 = 60007UL,
      FI_EN_CC_CARTEBLANCHE = 60008UL,
      FI_EN_CC_DINERSCLUBCARD = 60009UL,
      FI_EN_CC_MASTERCARD = 60010UL,
      FI_EN_CC_VISACARD = 60011UL,
      FI_EN_CC_JAPANESECREDITBANK = 60012UL,
      FI_EN_CC_ELECTRONICCASH = 60013UL,
      FI_EN_CC_CARTASI = 60014UL
   };
   tenType enType;

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual tBool operator==(const fi_tcl_e16_SelectionCriterionType& rfoCmp) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   virtual tS32 s32GetTypeId() const { return typesfi_tclToken::EN_E16_SELECTIONCRITERIONTYPE;}
   virtual tVoid vTakeVisitor(fi_tclVisitorBase& rfoVisitor);
};

class fi_tcl_b8_SelectionCriteriaMask : public fi_tclVisitableTypeBase
{
public:
   fi_tcl_b8_SelectionCriteriaMask():u8Value(0) {}

   enum {
      FI_C_U8_BIT_MENURELEVANTCATEGORIES = 0x1UL,
      FI_C_U8_BIT_ALLCATEGORIES = 0x2UL,
      FI_C_U8_BIT_FILTERATTRIBUTES = 0x4UL,
      FI_C_U8_BIT_MENUITEM = 0x8UL
   };
   tBool bMenurelevantCategories() const {return (u8Value & FI_C_U8_BIT_MENURELEVANTCATEGORIES) != 0; }
   tVoid vSetMenurelevantCategories(tBool bSetBit) { u8Value = (bSetBit)?(u8Value | FI_C_U8_BIT_MENURELEVANTCATEGORIES):(u8Value & ~FI_C_U8_BIT_MENURELEVANTCATEGORIES); }
   tBool bAllCategories() const {return (u8Value & FI_C_U8_BIT_ALLCATEGORIES) != 0; }
   tVoid vSetAllCategories(tBool bSetBit) { u8Value = (bSetBit)?(u8Value | FI_C_U8_BIT_ALLCATEGORIES):(u8Value & ~FI_C_U8_BIT_ALLCATEGORIES); }
   tBool bFilterAttributes() const {return (u8Value & FI_C_U8_BIT_FILTERATTRIBUTES) != 0; }
   tVoid vSetFilterAttributes(tBool bSetBit) { u8Value = (bSetBit)?(u8Value | FI_C_U8_BIT_FILTERATTRIBUTES):(u8Value & ~FI_C_U8_BIT_FILTERATTRIBUTES); }
   tBool bMenuItem() const {return (u8Value & FI_C_U8_BIT_MENUITEM) != 0; }
   tVoid vSetMenuItem(tBool bSetBit) { u8Value = (bSetBit)?(u8Value | FI_C_U8_BIT_MENUITEM):(u8Value & ~FI_C_U8_BIT_MENUITEM); }
   struct rBitValues {
      unsigned int MenurelevantCategories:1;
      unsigned int AllCategories:1;
      unsigned int FilterAttributes:1;
      unsigned int MenuItem:1;
      unsigned int dummy4:1;
      unsigned int dummy5:1;
      unsigned int dummy6:1;
      unsigned int dummy7:1;
   };
   union {
      tU8 u8Value;
      rBitValues bits;
   };

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual tBool operator==(const fi_tcl_b8_SelectionCriteriaMask& rfoCmp) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   virtual tS32 s32GetTypeId() const { return typesfi_tclToken::EN_B8_SELECTIONCRITERIAMASK;}
   virtual tVoid vTakeVisitor(fi_tclVisitorBase& rfoVisitor);
};

class fi_tcl_b8_RefinementCriteriaMask : public fi_tclVisitableTypeBase
{
public:
   fi_tcl_b8_RefinementCriteriaMask():u8Value(0) {}

   enum {
      FI_C_U8_BIT_CATEGORIES = 0x1UL,
      FI_C_U8_BIT_FILTERATTRIBUTES = 0x2UL,
      FI_C_U8_BIT_ATTRIBUTES = 0x4UL
   };
   tBool bCategories() const {return (u8Value & FI_C_U8_BIT_CATEGORIES) != 0; }
   tVoid vSetCategories(tBool bSetBit) { u8Value = (bSetBit)?(u8Value | FI_C_U8_BIT_CATEGORIES):(u8Value & ~FI_C_U8_BIT_CATEGORIES); }
   tBool bFilterAttributes() const {return (u8Value & FI_C_U8_BIT_FILTERATTRIBUTES) != 0; }
   tVoid vSetFilterAttributes(tBool bSetBit) { u8Value = (bSetBit)?(u8Value | FI_C_U8_BIT_FILTERATTRIBUTES):(u8Value & ~FI_C_U8_BIT_FILTERATTRIBUTES); }
   tBool bAttributes() const {return (u8Value & FI_C_U8_BIT_ATTRIBUTES) != 0; }
   tVoid vSetAttributes(tBool bSetBit) { u8Value = (bSetBit)?(u8Value | FI_C_U8_BIT_ATTRIBUTES):(u8Value & ~FI_C_U8_BIT_ATTRIBUTES); }
   struct rBitValues {
      unsigned int Categories:1;
      unsigned int FilterAttributes:1;
      unsigned int Attributes:1;
      unsigned int dummy3:1;
      unsigned int dummy4:1;
      unsigned int dummy5:1;
      unsigned int dummy6:1;
      unsigned int dummy7:1;
   };
   union {
      tU8 u8Value;
      rBitValues bits;
   };

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual tBool operator==(const fi_tcl_b8_RefinementCriteriaMask& rfoCmp) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   virtual tS32 s32GetTypeId() const { return typesfi_tclToken::EN_B8_REFINEMENTCRITERIAMASK;}
   virtual tVoid vTakeVisitor(fi_tclVisitorBase& rfoVisitor);
};

class fi_tcl_ObjectDescription : public fi_tclVisitableTypeBase
{
public:
   fi_tcl_ObjectDescription():Code(0),Description() {}
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   fi_tcl_ObjectDescription& operator=(const fi_tcl_ObjectDescription& coRef);
   fi_tcl_ObjectDescription(const fi_tcl_ObjectDescription& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
   tU16 Code;
   fi_tclString Description;

   virtual tVoid vDestroy();
   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual tBool operator==(const fi_tcl_ObjectDescription& rfoCmp) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   virtual tS32 s32GetTypeId() const { return typesfi_tclToken::EN_OBJECTDESCRIPTION;}
   virtual tVoid vTakeVisitor(fi_tclVisitorBase& rfoVisitor);
};

class fi_tcl_s32_Longitude : public fi_tclVisitableTypeBase
{
public:
   fi_tcl_s32_Longitude(tS32 _s32Value = 0):s32Value(_s32Value) {} 

   tS32 s32Value;

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual tBool operator==(const fi_tcl_s32_Longitude& rfoCmp) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   virtual tS32 s32GetTypeId() const { return typesfi_tclToken::EN_S32_LONGITUDE;}
   virtual tVoid vTakeVisitor(fi_tclVisitorBase& rfoVisitor);
};

class fi_tcl_b8_NavBinProperties : public fi_tclVisitableTypeBase
{
public:
   fi_tcl_b8_NavBinProperties():u8Value(0) {}

   enum {
      FI_C_U8_BIT_CONTAINSONECELLS = 0x1UL
   };
   tBool bContainsOneCells() const {return (u8Value & FI_C_U8_BIT_CONTAINSONECELLS) != 0; }
   tVoid vSetContainsOneCells(tBool bSetBit) { u8Value = (bSetBit)?(u8Value | FI_C_U8_BIT_CONTAINSONECELLS):(u8Value & ~FI_C_U8_BIT_CONTAINSONECELLS); }
   struct rBitValues {
      unsigned int ContainsOneCells:1;
      unsigned int dummy1:1;
      unsigned int dummy2:1;
      unsigned int dummy3:1;
      unsigned int dummy4:1;
      unsigned int dummy5:1;
      unsigned int dummy6:1;
      unsigned int dummy7:1;
   };
   union {
      tU8 u8Value;
      rBitValues bits;
   };

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual tBool operator==(const fi_tcl_b8_NavBinProperties& rfoCmp) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   virtual tS32 s32GetTypeId() const { return typesfi_tclToken::EN_B8_NAVBINPROPERTIES;}
   virtual tVoid vTakeVisitor(fi_tclVisitorBase& rfoVisitor);
};

class fi_tcl_ClusterId : public fi_tclVisitableTypeBase
{
public:
   fi_tcl_ClusterId():Offset(0),Length(0),FileId(0) {}
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   fi_tcl_ClusterId& operator=(const fi_tcl_ClusterId& coRef);
   fi_tcl_ClusterId(const fi_tcl_ClusterId& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
   tU32 Offset;
   tU16 Length;
   tU16 FileId;

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual tBool operator==(const fi_tcl_ClusterId& rfoCmp) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   virtual tS32 s32GetTypeId() const { return typesfi_tclToken::EN_CLUSTERID;}
   virtual tVoid vTakeVisitor(fi_tclVisitorBase& rfoVisitor);
};

class fi_tcl_b8_CellProperties : public fi_tclVisitableTypeBase
{
public:
   fi_tcl_b8_CellProperties():u16Value(0) {}

   enum {
      FI_C_U16_BIT_INDIGITISATIONDIRECTIONRHS = 0x1UL,
      FI_C_U16_BIT_AGAINSTDIGITISATIONDIRECTIONRHS = 0x2UL,
      FI_C_U16_BIT_ISCOMPLEX = 0x4UL,
      FI_C_U16_BIT_ISOBJECT = 0x8UL,
      FI_C_U16_BIT_ISLENGTHRATIOVALID = 0x10UL,
      FI_C_U16_BIT_RATIOINDIGDIRECTION = 0x20UL
   };
   tBool bInDigitisationDirectionRHS() const {return (u16Value & FI_C_U16_BIT_INDIGITISATIONDIRECTIONRHS) != 0; }
   tVoid vSetInDigitisationDirectionRHS(tBool bSetBit) { u16Value = (bSetBit)?(u16Value | FI_C_U16_BIT_INDIGITISATIONDIRECTIONRHS):(u16Value & ~FI_C_U16_BIT_INDIGITISATIONDIRECTIONRHS); }
   tBool bAgainstDigitisationDirectionRHS() const {return (u16Value & FI_C_U16_BIT_AGAINSTDIGITISATIONDIRECTIONRHS) != 0; }
   tVoid vSetAgainstDigitisationDirectionRHS(tBool bSetBit) { u16Value = (bSetBit)?(u16Value | FI_C_U16_BIT_AGAINSTDIGITISATIONDIRECTIONRHS):(u16Value & ~FI_C_U16_BIT_AGAINSTDIGITISATIONDIRECTIONRHS); }
   tBool bIsComplex() const {return (u16Value & FI_C_U16_BIT_ISCOMPLEX) != 0; }
   tVoid vSetIsComplex(tBool bSetBit) { u16Value = (bSetBit)?(u16Value | FI_C_U16_BIT_ISCOMPLEX):(u16Value & ~FI_C_U16_BIT_ISCOMPLEX); }
   tBool bIsObject() const {return (u16Value & FI_C_U16_BIT_ISOBJECT) != 0; }
   tVoid vSetIsObject(tBool bSetBit) { u16Value = (bSetBit)?(u16Value | FI_C_U16_BIT_ISOBJECT):(u16Value & ~FI_C_U16_BIT_ISOBJECT); }
   tBool bIsLengthRatioValid() const {return (u16Value & FI_C_U16_BIT_ISLENGTHRATIOVALID) != 0; }
   tVoid vSetIsLengthRatioValid(tBool bSetBit) { u16Value = (bSetBit)?(u16Value | FI_C_U16_BIT_ISLENGTHRATIOVALID):(u16Value & ~FI_C_U16_BIT_ISLENGTHRATIOVALID); }
   tBool bRatioInDigDirection() const {return (u16Value & FI_C_U16_BIT_RATIOINDIGDIRECTION) != 0; }
   tVoid vSetRatioInDigDirection(tBool bSetBit) { u16Value = (bSetBit)?(u16Value | FI_C_U16_BIT_RATIOINDIGDIRECTION):(u16Value & ~FI_C_U16_BIT_RATIOINDIGDIRECTION); }
   struct rBitValues {
      unsigned int InDigitisationDirectionRHS:1;
      unsigned int AgainstDigitisationDirectionRHS:1;
      unsigned int IsComplex:1;
      unsigned int IsObject:1;
      unsigned int IsLengthRatioValid:1;
      unsigned int RatioInDigDirection:1;
      unsigned int dummy6:1;
      unsigned int dummy7:1;
      unsigned int dummy8:1;
      unsigned int dummy9:1;
      unsigned int dummy10:1;
      unsigned int dummy11:1;
      unsigned int dummy12:1;
      unsigned int dummy13:1;
      unsigned int dummy14:1;
      unsigned int dummy15:1;
   };
   union {
      tU16 u16Value;
      rBitValues bits;
   };

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual tBool operator==(const fi_tcl_b8_CellProperties& rfoCmp) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   virtual tS32 s32GetTypeId() const { return typesfi_tclToken::EN_B8_CELLPROPERTIES;}
   virtual tVoid vTakeVisitor(fi_tclVisitorBase& rfoVisitor);
};

class fi_tcl_Cell : public fi_tclVisitableTypeBase
{
public:
   fi_tcl_Cell():ID(0),Properties(),InterpolationRatio(0) {}
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   fi_tcl_Cell& operator=(const fi_tcl_Cell& coRef);
   fi_tcl_Cell(const fi_tcl_Cell& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
   tU16 ID;
   fi_tcl_b8_CellProperties Properties;
   tU8 InterpolationRatio;

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual tBool operator==(const fi_tcl_Cell& rfoCmp) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   virtual tS32 s32GetTypeId() const { return typesfi_tclToken::EN_CELL;}
   virtual tVoid vTakeVisitor(fi_tclVisitorBase& rfoVisitor);
};

class fi_tcl_ClusterInfo : public fi_tclVisitableTypeBase
{
public:
   fi_tcl_ClusterInfo():ID() {}
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   fi_tcl_ClusterInfo& operator=(const fi_tcl_ClusterInfo& coRef);
   fi_tcl_ClusterInfo(const fi_tcl_ClusterInfo& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
   fi_tcl_ClusterId ID;
   std::vector<fi_tcl_Cell, std::allocator<fi_tcl_Cell> > Cells;

   virtual tVoid vDestroy();
   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual tBool operator==(const fi_tcl_ClusterInfo& rfoCmp) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   virtual tS32 s32GetTypeId() const { return typesfi_tclToken::EN_CLUSTERINFO;}
   virtual tVoid vTakeVisitor(fi_tclVisitorBase& rfoVisitor);
};

class fi_tcl_e8_DetailType : public fi_tclVisitableTypeBase
{
public:
   fi_tcl_e8_DetailType():enType(FI_EN_NONE) {}

   enum tenType {
      FI_EN_NONE = 0UL,
      FI_EN_DESCRIPTION = 1UL,
      FI_EN_ADDRESS = 2UL,
      FI_EN_PHONENO = 3UL,
      FI_EN_FAXNO = 4UL,
      FI_EN_EMAIL = 5UL,
      FI_EN_WWW = 6UL,
      FI_EN_FILE = 7UL,
      FI_EN_POSTCODEAREAUPPERLEFTX = 8UL,
      FI_EN_POSTCODEAREAUPPERLEFTY = 9UL,
      FI_EN_POSTCODEAREALOWERRIGHTX = 10UL,
      FI_EN_POSTCODEAREALOWERRIGHTY = 11UL,
      FI_EN_CURRENCY = 33UL,
      FI_EN_HOUSENUMBER = 34UL,
      FI_EN_SEMANTIC = 35UL,
      FI_EN_STREETNAME = 36UL,
      FI_EN_TOWNNAME = 37UL,
      FI_EN_TOWNADDON = 38UL,
      FI_EN_ZIPCODE = 39UL,
      FI_EN_STATEORPROVINCE = 40UL,
      FI_EN_COUNTRY = 41UL,
      FI_EN_RATING = 42UL,
      FI_EN_REVIEW = 43UL
   };
   tenType enType;

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual tBool operator==(const fi_tcl_e8_DetailType& rfoCmp) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   virtual tS32 s32GetTypeId() const { return typesfi_tclToken::EN_E8_DETAILTYPE;}
   virtual tVoid vTakeVisitor(fi_tclVisitorBase& rfoVisitor);
};

class fi_tcl_ObjectDetail : public fi_tclVisitableTypeBase
{
public:
   fi_tcl_ObjectDetail():String(),Type() {}
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   fi_tcl_ObjectDetail& operator=(const fi_tcl_ObjectDetail& coRef);
   fi_tcl_ObjectDetail(const fi_tcl_ObjectDetail& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
   fi_tclString String;
   fi_tcl_e8_DetailType Type;

   virtual tVoid vDestroy();
   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual tBool operator==(const fi_tcl_ObjectDetail& rfoCmp) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   virtual tS32 s32GetTypeId() const { return typesfi_tclToken::EN_OBJECTDETAIL;}
   virtual tVoid vTakeVisitor(fi_tclVisitorBase& rfoVisitor);
};

class fi_tcl_b8_ResolutionType : public fi_tclVisitableTypeBase
{
public:
   fi_tcl_b8_ResolutionType():u8Value(0) {}

   enum {
      FI_C_U8_BIT_RESOLVEPERMUTATION = 0x1UL,
      FI_C_U8_BIT_RESOLVEAFFILIATION = 0x2UL,
      FI_C_U8_BIT_RESOLVEALTERNATIVENAME = 0x4UL,
      FI_C_U8_BIT_RESOLVEPOSITIONBASEDINPUT = 0x8UL,
      FI_C_U8_BIT_RESOLVEEXONYM = 0x10UL,
      FI_C_U8_BIT_MATCHASFARASPOSSIBLE = 0x20UL,
      FI_C_U8_BIT_RESOLVELATEAMBIGUITY = 0x40UL
   };
   tBool bResolvePermutation() const {return (u8Value & FI_C_U8_BIT_RESOLVEPERMUTATION) != 0; }
   tVoid vSetResolvePermutation(tBool bSetBit) { u8Value = (bSetBit)?(u8Value | FI_C_U8_BIT_RESOLVEPERMUTATION):(u8Value & ~FI_C_U8_BIT_RESOLVEPERMUTATION); }
   tBool bResolveAffiliation() const {return (u8Value & FI_C_U8_BIT_RESOLVEAFFILIATION) != 0; }
   tVoid vSetResolveAffiliation(tBool bSetBit) { u8Value = (bSetBit)?(u8Value | FI_C_U8_BIT_RESOLVEAFFILIATION):(u8Value & ~FI_C_U8_BIT_RESOLVEAFFILIATION); }
   tBool bResolveAlternativeName() const {return (u8Value & FI_C_U8_BIT_RESOLVEALTERNATIVENAME) != 0; }
   tVoid vSetResolveAlternativeName(tBool bSetBit) { u8Value = (bSetBit)?(u8Value | FI_C_U8_BIT_RESOLVEALTERNATIVENAME):(u8Value & ~FI_C_U8_BIT_RESOLVEALTERNATIVENAME); }
   tBool bResolvePositionBasedInput() const {return (u8Value & FI_C_U8_BIT_RESOLVEPOSITIONBASEDINPUT) != 0; }
   tVoid vSetResolvePositionBasedInput(tBool bSetBit) { u8Value = (bSetBit)?(u8Value | FI_C_U8_BIT_RESOLVEPOSITIONBASEDINPUT):(u8Value & ~FI_C_U8_BIT_RESOLVEPOSITIONBASEDINPUT); }
   tBool bResolveExonym() const {return (u8Value & FI_C_U8_BIT_RESOLVEEXONYM) != 0; }
   tVoid vSetResolveExonym(tBool bSetBit) { u8Value = (bSetBit)?(u8Value | FI_C_U8_BIT_RESOLVEEXONYM):(u8Value & ~FI_C_U8_BIT_RESOLVEEXONYM); }
   tBool bMatchAsFarAsPossible() const {return (u8Value & FI_C_U8_BIT_MATCHASFARASPOSSIBLE) != 0; }
   tVoid vSetMatchAsFarAsPossible(tBool bSetBit) { u8Value = (bSetBit)?(u8Value | FI_C_U8_BIT_MATCHASFARASPOSSIBLE):(u8Value & ~FI_C_U8_BIT_MATCHASFARASPOSSIBLE); }
   tBool bResolveLateAmbiguity() const {return (u8Value & FI_C_U8_BIT_RESOLVELATEAMBIGUITY) != 0; }
   tVoid vSetResolveLateAmbiguity(tBool bSetBit) { u8Value = (bSetBit)?(u8Value | FI_C_U8_BIT_RESOLVELATEAMBIGUITY):(u8Value & ~FI_C_U8_BIT_RESOLVELATEAMBIGUITY); }
   struct rBitValues {
      unsigned int ResolvePermutation:1;
      unsigned int ResolveAffiliation:1;
      unsigned int ResolveAlternativeName:1;
      unsigned int ResolvePositionBasedInput:1;
      unsigned int ResolveExonym:1;
      unsigned int MatchAsFarAsPossible:1;
      unsigned int ResolveLateAmbiguity:1;
      unsigned int dummy7:1;
   };
   union {
      tU8 u8Value;
      rBitValues bits;
   };

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual tBool operator==(const fi_tcl_b8_ResolutionType& rfoCmp) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   virtual tS32 s32GetTypeId() const { return typesfi_tclToken::EN_B8_RESOLUTIONTYPE;}
   virtual tVoid vTakeVisitor(fi_tclVisitorBase& rfoVisitor);
};

class fi_tcl_b8_DataSetProperties : public fi_tclVisitableTypeBase
{
public:
   fi_tcl_b8_DataSetProperties():u8Value(0) {}

   enum {
      FI_C_U8_BIT_ISTRAVELGUIDEDATASET = 0x1UL,
      FI_C_U8_BIT_ISUSERPOIDATASET = 0x2UL
   };
   tBool bIsTravelGuideDataSet() const {return (u8Value & FI_C_U8_BIT_ISTRAVELGUIDEDATASET) != 0; }
   tVoid vSetIsTravelGuideDataSet(tBool bSetBit) { u8Value = (bSetBit)?(u8Value | FI_C_U8_BIT_ISTRAVELGUIDEDATASET):(u8Value & ~FI_C_U8_BIT_ISTRAVELGUIDEDATASET); }
   tBool bIsUserPOIDataSet() const {return (u8Value & FI_C_U8_BIT_ISUSERPOIDATASET) != 0; }
   tVoid vSetIsUserPOIDataSet(tBool bSetBit) { u8Value = (bSetBit)?(u8Value | FI_C_U8_BIT_ISUSERPOIDATASET):(u8Value & ~FI_C_U8_BIT_ISUSERPOIDATASET); }
   struct rBitValues {
      unsigned int IsTravelGuideDataSet:1;
      unsigned int IsUserPOIDataSet:1;
      unsigned int dummy2:1;
      unsigned int dummy3:1;
      unsigned int dummy4:1;
      unsigned int dummy5:1;
      unsigned int dummy6:1;
      unsigned int dummy7:1;
   };
   union {
      tU8 u8Value;
      rBitValues bits;
   };

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual tBool operator==(const fi_tcl_b8_DataSetProperties& rfoCmp) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   virtual tS32 s32GetTypeId() const { return typesfi_tclToken::EN_B8_DATASETPROPERTIES;}
   virtual tVoid vTakeVisitor(fi_tclVisitorBase& rfoVisitor);
};

class fi_tcl_DataSetElement : public fi_tclVisitableTypeBase
{
public:
   fi_tcl_DataSetElement():ID(0),Properties(),Name() {}
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   fi_tcl_DataSetElement& operator=(const fi_tcl_DataSetElement& coRef);
   fi_tcl_DataSetElement(const fi_tcl_DataSetElement& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
   tU32 ID;
   fi_tcl_b8_DataSetProperties Properties;
   fi_tclString Name;

   virtual tVoid vDestroy();
   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual tBool operator==(const fi_tcl_DataSetElement& rfoCmp) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   virtual tS32 s32GetTypeId() const { return typesfi_tclToken::EN_DATASETELEMENT;}
   virtual tVoid vTakeVisitor(fi_tclVisitorBase& rfoVisitor);
};

class fi_tcl_e16_POIType : public fi_tclVisitableTypeBase
{
public:
   fi_tcl_e16_POIType():enType(FI_EN_UNDEFINED) {}

   enum tenType {
      FI_EN_UNDEFINED = 0UL,
      FI_EN_ADDRESSBOOK_POI = 1UL,
      FI_EN_IMPORTED_POI = 2UL
   };
   tenType enType;

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual tBool operator==(const fi_tcl_e16_POIType& rfoCmp) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   virtual tS32 s32GetTypeId() const { return typesfi_tclToken::EN_E16_POITYPE;}
   virtual tVoid vTakeVisitor(fi_tclVisitorBase& rfoVisitor);
};

class fi_tcl_b16_POIType : public fi_tclVisitableTypeBase
{
public:
   fi_tcl_b16_POIType():u16Value(0) {}

   enum {
      FI_C_U16_BIT_ADDRESSBOOK_POI = 0x1UL,
      FI_C_U16_BIT_IMPORTED_POI = 0x2UL
   };
   tBool bADDRESSBOOK_POI() const {return (u16Value & FI_C_U16_BIT_ADDRESSBOOK_POI) != 0; }
   tVoid vSetADDRESSBOOK_POI(tBool bSetBit) { u16Value = (bSetBit)?(u16Value | FI_C_U16_BIT_ADDRESSBOOK_POI):(u16Value & ~FI_C_U16_BIT_ADDRESSBOOK_POI); }
   tBool bIMPORTED_POI() const {return (u16Value & FI_C_U16_BIT_IMPORTED_POI) != 0; }
   tVoid vSetIMPORTED_POI(tBool bSetBit) { u16Value = (bSetBit)?(u16Value | FI_C_U16_BIT_IMPORTED_POI):(u16Value & ~FI_C_U16_BIT_IMPORTED_POI); }
   struct rBitValues {
      unsigned int ADDRESSBOOK_POI:1;
      unsigned int IMPORTED_POI:1;
      unsigned int dummy2:1;
      unsigned int dummy3:1;
      unsigned int dummy4:1;
      unsigned int dummy5:1;
      unsigned int dummy6:1;
      unsigned int dummy7:1;
      unsigned int dummy8:1;
      unsigned int dummy9:1;
      unsigned int dummy10:1;
      unsigned int dummy11:1;
      unsigned int dummy12:1;
      unsigned int dummy13:1;
      unsigned int dummy14:1;
      unsigned int dummy15:1;
   };
   union {
      tU16 u16Value;
      rBitValues bits;
   };

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual tBool operator==(const fi_tcl_b16_POIType& rfoCmp) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   virtual tS32 s32GetTypeId() const { return typesfi_tclToken::EN_B16_POITYPE;}
   virtual tVoid vTakeVisitor(fi_tclVisitorBase& rfoVisitor);
};

class fi_tcl_e8_POIDataset : public fi_tclVisitableTypeBase
{
public:
   fi_tcl_e8_POIDataset():enType(FI_EN_UPOIS) {}

   enum tenType {
      FI_EN_UPOIS = 0UL,
      FI_EN_SXM_POI = 1UL
   };
   tenType enType;

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual tBool operator==(const fi_tcl_e8_POIDataset& rfoCmp) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   virtual tS32 s32GetTypeId() const { return typesfi_tclToken::EN_E8_POIDATASET;}
   virtual tVoid vTakeVisitor(fi_tclVisitorBase& rfoVisitor);
};

class fi_tcl_s32_Latitude : public fi_tclVisitableTypeBase
{
public:
   fi_tcl_s32_Latitude(tS32 _s32Value = 0):s32Value(_s32Value) {} 

   tS32 s32Value;

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual tBool operator==(const fi_tcl_s32_Latitude& rfoCmp) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   virtual tS32 s32GetTypeId() const { return typesfi_tclToken::EN_S32_LATITUDE;}
   virtual tVoid vTakeVisitor(fi_tclVisitorBase& rfoVisitor);
};

class fi_tcl_PositionWGS84 : public fi_tclVisitableTypeBase
{
public:
   fi_tcl_PositionWGS84():Longitude(),Latitude() {}
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   fi_tcl_PositionWGS84& operator=(const fi_tcl_PositionWGS84& coRef);
   fi_tcl_PositionWGS84(const fi_tcl_PositionWGS84& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
   fi_tcl_s32_Longitude Longitude;
   fi_tcl_s32_Latitude Latitude;

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual tBool operator==(const fi_tcl_PositionWGS84& rfoCmp) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   virtual tS32 s32GetTypeId() const { return typesfi_tclToken::EN_POSITIONWGS84;}
   virtual tVoid vTakeVisitor(fi_tclVisitorBase& rfoVisitor);
};

class fi_tcl_IndexCatBrand : public fi_tclVisitableTypeBase
{
public:
   fi_tcl_IndexCatBrand():Category(0),Brand(0) {}
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   fi_tcl_IndexCatBrand& operator=(const fi_tcl_IndexCatBrand& coRef);
   fi_tcl_IndexCatBrand(const fi_tcl_IndexCatBrand& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
   tU16 Category;
   tU16 Brand;

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual tBool operator==(const fi_tcl_IndexCatBrand& rfoCmp) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   virtual tS32 s32GetTypeId() const { return typesfi_tclToken::EN_INDEXCATBRAND;}
   virtual tVoid vTakeVisitor(fi_tclVisitorBase& rfoVisitor);
};

class fi_tcl_MapIdPair : public fi_tclVisitableTypeBase
{
public:
   fi_tcl_MapIdPair():FeatureGroup(0),SubGroup(0) {}
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   fi_tcl_MapIdPair& operator=(const fi_tcl_MapIdPair& coRef);
   fi_tcl_MapIdPair(const fi_tcl_MapIdPair& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
   tU16 FeatureGroup;
   tU16 SubGroup;

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual tBool operator==(const fi_tcl_MapIdPair& rfoCmp) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   virtual tS32 s32GetTypeId() const { return typesfi_tclToken::EN_MAPIDPAIR;}
   virtual tVoid vTakeVisitor(fi_tclVisitorBase& rfoVisitor);
};

class fi_tcl_DataBlockStartInfo : public fi_tclVisitableTypeBase
{
public:
   fi_tcl_DataBlockStartInfo():u32Offset(0),u32Size(0),szSharedMemory(),szPath(),szFilename() {}
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   fi_tcl_DataBlockStartInfo& operator=(const fi_tcl_DataBlockStartInfo& coRef);
   fi_tcl_DataBlockStartInfo(const fi_tcl_DataBlockStartInfo& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
   tU32 u32Offset;
   tU32 u32Size;
   fi_tclString szSharedMemory;
   fi_tclString szPath;
   fi_tclString szFilename;

   virtual tVoid vDestroy();
   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual tBool operator==(const fi_tcl_DataBlockStartInfo& rfoCmp) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   virtual tS32 s32GetTypeId() const { return typesfi_tclToken::EN_DATABLOCKSTARTINFO;}
   virtual tVoid vTakeVisitor(fi_tclVisitorBase& rfoVisitor);
};

class fi_tcl_DataBlockResultInfo : public fi_tclVisitableTypeBase
{
public:
   fi_tcl_DataBlockResultInfo():u32Offset(0),u32Size(0),u16ErrorCode(0),szSharedMemory(),szPath(),szFilename() {}
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   fi_tcl_DataBlockResultInfo& operator=(const fi_tcl_DataBlockResultInfo& coRef);
   fi_tcl_DataBlockResultInfo(const fi_tcl_DataBlockResultInfo& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
   tU32 u32Offset;
   tU32 u32Size;
   tU16 u16ErrorCode;
   fi_tclString szSharedMemory;
   fi_tclString szPath;
   fi_tclString szFilename;

   virtual tVoid vDestroy();
   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual tBool operator==(const fi_tcl_DataBlockResultInfo& rfoCmp) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   virtual tS32 s32GetTypeId() const { return typesfi_tclToken::EN_DATABLOCKRESULTINFO;}
   virtual tVoid vTakeVisitor(fi_tclVisitorBase& rfoVisitor);
};

class fi_tcl_e8_StorageMode : public fi_tclVisitableTypeBase
{
public:
   fi_tcl_e8_StorageMode():enType(FI_EN_INVALID) {}

   enum tenType {
      FI_EN_INVALID = 0UL,
      FI_EN_STOREANDKNIT = 1UL,
      FI_EN_KNITONLY = 2UL,
      FI_EN_STOREONLY = 3UL
   };
   tenType enType;

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual tBool operator==(const fi_tcl_e8_StorageMode& rfoCmp) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   virtual tS32 s32GetTypeId() const { return typesfi_tclToken::EN_E8_STORAGEMODE;}
   virtual tVoid vTakeVisitor(fi_tclVisitorBase& rfoVisitor);
};

class fi_tcl_e8_ResumeType : public fi_tclVisitableTypeBase
{
public:
   fi_tcl_e8_ResumeType():enType(FI_EN_INVALID) {}

   enum tenType {
      FI_EN_INVALID = 0UL,
      FI_EN_RESUMESTORAGE = 1UL,
      FI_EN_ABORTSTORAGEKEEP = 2UL,
      FI_EN_ABORTSTORAGE = 3UL
   };
   tenType enType;

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual tBool operator==(const fi_tcl_e8_ResumeType& rfoCmp) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   virtual tS32 s32GetTypeId() const { return typesfi_tclToken::EN_E8_RESUMETYPE;}
   virtual tVoid vTakeVisitor(fi_tclVisitorBase& rfoVisitor);
};

class fi_tcl_e8_StoreStatus : public fi_tclVisitableTypeBase
{
public:
   fi_tcl_e8_StoreStatus():enType(FI_EN_INVALID) {}

   enum tenType {
      FI_EN_INVALID = 0UL,
      FI_EN_DELETED = 1UL,
      FI_EN_STORED = 2UL,
      FI_EN_NOTPROCESSED = 3UL
   };
   tenType enType;

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual tBool operator==(const fi_tcl_e8_StoreStatus& rfoCmp) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   virtual tS32 s32GetTypeId() const { return typesfi_tclToken::EN_E8_STORESTATUS;}
   virtual tVoid vTakeVisitor(fi_tclVisitorBase& rfoVisitor);
};

class fi_tcl_e8_ProgressStatus : public fi_tclVisitableTypeBase
{
public:
   fi_tcl_e8_ProgressStatus():enType(FI_EN_INVALID) {}

   enum tenType {
      FI_EN_INVALID = 0UL,
      FI_EN_INPROGRESS = 1UL,
      FI_EN_TERMINATEDSUCCESSFULLY = 2UL,
      FI_EN_TERMINATEDWITHERROR = 3UL,
      FI_EN_ABORTEDBYSYSTEM = 4UL,
      FI_EN_ABORTEDBYUSER = 5UL
   };
   tenType enType;

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual tBool operator==(const fi_tcl_e8_ProgressStatus& rfoCmp) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   virtual tS32 s32GetTypeId() const { return typesfi_tclToken::EN_E8_PROGRESSSTATUS;}
   virtual tVoid vTakeVisitor(fi_tclVisitorBase& rfoVisitor);
};

class fi_tcl_RegionNumberOrder : public fi_tclVisitableTypeBase
{
public:
   fi_tcl_RegionNumberOrder():RegionNumber(0),enStorageMode() {}
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   fi_tcl_RegionNumberOrder& operator=(const fi_tcl_RegionNumberOrder& coRef);
   fi_tcl_RegionNumberOrder(const fi_tcl_RegionNumberOrder& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
   tU16 RegionNumber;
   fi_tcl_e8_StorageMode enStorageMode;

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual tBool operator==(const fi_tcl_RegionNumberOrder& rfoCmp) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   virtual tS32 s32GetTypeId() const { return typesfi_tclToken::EN_REGIONNUMBERORDER;}
   virtual tVoid vTakeVisitor(fi_tclVisitorBase& rfoVisitor);
};

class fi_tcl_RegionNumberResult : public fi_tclVisitableTypeBase
{
public:
   fi_tcl_RegionNumberResult():RegionNumber(0),Error(0) {}
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   fi_tcl_RegionNumberResult& operator=(const fi_tcl_RegionNumberResult& coRef);
   fi_tcl_RegionNumberResult(const fi_tcl_RegionNumberResult& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
   tU16 RegionNumber;
   tU16 Error;

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual tBool operator==(const fi_tcl_RegionNumberResult& rfoCmp) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   virtual tS32 s32GetTypeId() const { return typesfi_tclToken::EN_REGIONNUMBERRESULT;}
   virtual tVoid vTakeVisitor(fi_tclVisitorBase& rfoVisitor);
};

class fi_tcl_RegionInfo : public fi_tclVisitableTypeBase
{
public:
   fi_tcl_RegionInfo():RegionNumber(0),RegionCodeId(0),RegionProfileId(0),Size(0),NeededSlots(0),RegionName(0),CreationDate(0),StoreStatus() {}
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   fi_tcl_RegionInfo& operator=(const fi_tcl_RegionInfo& coRef);
   fi_tcl_RegionInfo(const fi_tcl_RegionInfo& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
   tU16 RegionNumber;
   tU16 RegionCodeId;
   tU16 RegionProfileId;
   tU32 Size;
   tU16 NeededSlots;
   fi_tclMultiLanguageString RegionName;
   tU32 CreationDate;
   fi_tcl_e8_StorageMode StoreStatus;

   virtual tVoid vDestroy();
   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual tBool operator==(const fi_tcl_RegionInfo& rfoCmp) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   virtual tS32 s32GetTypeId() const { return typesfi_tclToken::EN_REGIONINFO;}
   virtual tVoid vTakeVisitor(fi_tclVisitorBase& rfoVisitor);
};

class fi_tcl_RegionOutline : public fi_tclVisitableTypeBase
{
public:
   fi_tcl_RegionOutline():RegionCodeId(0),RegionProfileId(0),CreationDate(0),StoreStatus() {}
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   fi_tcl_RegionOutline& operator=(const fi_tcl_RegionOutline& coRef);
   fi_tcl_RegionOutline(const fi_tcl_RegionOutline& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
   tU16 RegionCodeId;
   tU16 RegionProfileId;
   tU32 CreationDate;
   fi_tcl_e8_StorageMode StoreStatus;
   std::vector<fi_tcl_PositionWGS84, std::allocator<fi_tcl_PositionWGS84> > Outline;

   virtual tVoid vDestroy();
   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual tBool operator==(const fi_tcl_RegionOutline& rfoCmp) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   virtual tS32 s32GetTypeId() const { return typesfi_tclToken::EN_REGIONOUTLINE;}
   virtual tVoid vTakeVisitor(fi_tclVisitorBase& rfoVisitor);
};

class fi_tcl_e8_DapAccessMode : public fi_tclVisitableTypeBase
{
public:
   fi_tcl_e8_DapAccessMode():enType(FI_EN_DAP_ENACCESSSHARED) {}

   enum tenType {
      FI_EN_DAP_ENACCESSSHARED = 0UL,
      FI_EN_DAP_ENACCESSEXCLUSIVEOTHER = 1UL,
      FI_EN_DAP_ENACCESSEXCLUSIVEDAPI = 2UL,
      FI_EN_DAP_ENACCESSNONE = 3UL
   };
   tenType enType;

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual tBool operator==(const fi_tcl_e8_DapAccessMode& rfoCmp) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   virtual tS32 s32GetTypeId() const { return typesfi_tclToken::EN_E8_DAPACCESSMODE;}
   virtual tVoid vTakeVisitor(fi_tclVisitorBase& rfoVisitor);
};

class fi_tcl_DapDeviceStatusInfo : public fi_tclVisitableTypeBase
{
public:
   fi_tcl_DapDeviceStatusInfo():szDevicePath(),enDeviceError() {}
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   fi_tcl_DapDeviceStatusInfo& operator=(const fi_tcl_DapDeviceStatusInfo& coRef);
   fi_tcl_DapDeviceStatusInfo(const fi_tcl_DapDeviceStatusInfo& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
   fi_tclString szDevicePath;
   fi_tcl_e8_DapDeviceError enDeviceError;

   virtual tVoid vDestroy();
   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual tBool operator==(const fi_tcl_DapDeviceStatusInfo& rfoCmp) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   virtual tS32 s32GetTypeId() const { return typesfi_tclToken::EN_DAPDEVICESTATUSINFO;}
   virtual tVoid vTakeVisitor(fi_tclVisitorBase& rfoVisitor);
};

class fi_tcl_e8_DapWriteProt : public fi_tclVisitableTypeBase
{
public:
   fi_tcl_e8_DapWriteProt():enType(FI_EN_DAP_ENUNKNOWN) {}

   enum tenType {
      FI_EN_DAP_ENUNKNOWN = 0UL,
      FI_EN_DAP_ENLOCK = 1UL,
      FI_EN_DAP_ENUNLOCK = 2UL
   };
   tenType enType;

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual tBool operator==(const fi_tcl_e8_DapWriteProt& rfoCmp) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   virtual tS32 s32GetTypeId() const { return typesfi_tclToken::EN_E8_DAPWRITEPROT;}
   virtual tVoid vTakeVisitor(fi_tclVisitorBase& rfoVisitor);
};

class fi_tcl_DapVirtualMediaInfo : public fi_tclVisitableTypeBase
{
public:
   fi_tcl_DapVirtualMediaInfo():u32MediaId(0),enDataAvailable(),szMediaDescription() {}
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   fi_tcl_DapVirtualMediaInfo& operator=(const fi_tcl_DapVirtualMediaInfo& coRef);
   fi_tcl_DapVirtualMediaInfo(const fi_tcl_DapVirtualMediaInfo& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
   tU32 u32MediaId;
   fi_tcl_e8_DapDataAvailable enDataAvailable;
   fi_tclString szMediaDescription;

   virtual tVoid vDestroy();
   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual tBool operator==(const fi_tcl_DapVirtualMediaInfo& rfoCmp) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   virtual tS32 s32GetTypeId() const { return typesfi_tclToken::EN_DAPVIRTUALMEDIAINFO;}
   virtual tVoid vTakeVisitor(fi_tclVisitorBase& rfoVisitor);
};

class fi_tcl_e16_DapFileType : public fi_tclVisitableTypeBase
{
public:
   fi_tcl_e16_DapFileType():enType(FI_EN_DAP_ENMAP) {}

   enum tenType {
      FI_EN_DAP_ENMAP = 1UL,
      FI_EN_DAP_ENNAVI = 2UL,
      FI_EN_DAP_ENINDEX = 3UL,
      FI_EN_DAP_ENEXTERN = 4UL,
      FI_EN_DAP_ENASSMBL = 5UL,
      FI_EN_DAP_ENHIGHENTR = 6UL,
      FI_EN_DAP_ENANN_EXP = 7UL,
      FI_EN_DAP_ENP3D_PICT = 8UL,
      FI_EN_DAP_EN3D_PICT = 9UL,
      FI_EN_DAP_ENPHOTOR_P = 10UL
   };
   tenType enType;

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual tBool operator==(const fi_tcl_e16_DapFileType& rfoCmp) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   virtual tS32 s32GetTypeId() const { return typesfi_tclToken::EN_E16_DAPFILETYPE;}
   virtual tVoid vTakeVisitor(fi_tclVisitorBase& rfoVisitor);
};

class fi_tcl_e16_DapNumberRepr : public fi_tclVisitableTypeBase
{
public:
   fi_tcl_e16_DapNumberRepr():enType(FI_EN_DAP_ENNUMREPRDEC) {}

   enum tenType {
      FI_EN_DAP_ENNUMREPRDEC = 1UL,
      FI_EN_DAP_ENNUMREPRHEX = 2UL,
      FI_EN_DAP_ENNUMREPRTILE = 3UL
   };
   tenType enType;

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual tBool operator==(const fi_tcl_e16_DapNumberRepr& rfoCmp) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   virtual tS32 s32GetTypeId() const { return typesfi_tclToken::EN_E16_DAPNUMBERREPR;}
   virtual tVoid vTakeVisitor(fi_tclVisitorBase& rfoVisitor);
};

class fi_tcl_DapDeviceInfo : public fi_tclVisitableTypeBase
{
public:
   fi_tcl_DapDeviceInfo():enDeviceError(),szDeviceName() {}
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   fi_tcl_DapDeviceInfo& operator=(const fi_tcl_DapDeviceInfo& coRef);
   fi_tcl_DapDeviceInfo(const fi_tcl_DapDeviceInfo& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
   fi_tcl_e8_DapDeviceError enDeviceError;
   fi_tclString szDeviceName;

   virtual tVoid vDestroy();
   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual tBool operator==(const fi_tcl_DapDeviceInfo& rfoCmp) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   virtual tS32 s32GetTypeId() const { return typesfi_tclToken::EN_DAPDEVICEINFO;}
   virtual tVoid vTakeVisitor(fi_tclVisitorBase& rfoVisitor);
};

class fi_tcl_DapFileType : public fi_tclVisitableTypeBase
{
public:
   fi_tcl_DapFileType():u16FileType(),u16NumRep(),szPrefix(),szSuffix() {}
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   fi_tcl_DapFileType& operator=(const fi_tcl_DapFileType& coRef);
   fi_tcl_DapFileType(const fi_tcl_DapFileType& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
   fi_tcl_e16_DapFileType u16FileType;
   fi_tcl_e16_DapNumberRepr u16NumRep;
   fi_tclString szPrefix;
   fi_tclString szSuffix;

   virtual tVoid vDestroy();
   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual tBool operator==(const fi_tcl_DapFileType& rfoCmp) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   virtual tS32 s32GetTypeId() const { return typesfi_tclToken::EN_DAPFILETYPE;}
   virtual tVoid vTakeVisitor(fi_tclVisitorBase& rfoVisitor);
};

class fi_tcl_DapCodePageDescr : public fi_tclVisitableTypeBase
{
public:
   fi_tcl_DapCodePageDescr():u16ListPosition(0),u32FirstLetter(0),u32LastLetter(0),szCodePage() {}
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   fi_tcl_DapCodePageDescr& operator=(const fi_tcl_DapCodePageDescr& coRef);
   fi_tcl_DapCodePageDescr(const fi_tcl_DapCodePageDescr& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
   tU16 u16ListPosition;
   tU32 u32FirstLetter;
   tU32 u32LastLetter;
   fi_tclString szCodePage;

   virtual tVoid vDestroy();
   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual tBool operator==(const fi_tcl_DapCodePageDescr& rfoCmp) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   virtual tS32 s32GetTypeId() const { return typesfi_tclToken::EN_DAPCODEPAGEDESCR;}
   virtual tVoid vTakeVisitor(fi_tclVisitorBase& rfoVisitor);
};

class fi_tcl_DapLanguageDescr : public fi_tclVisitableTypeBase
{
public:
   fi_tcl_DapLanguageDescr():u16LanguageId(0),u16LanguageCode(0) {}
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   fi_tcl_DapLanguageDescr& operator=(const fi_tcl_DapLanguageDescr& coRef);
   fi_tcl_DapLanguageDescr(const fi_tcl_DapLanguageDescr& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
   tU16 u16LanguageId;
   tU16 u16LanguageCode;
   std::vector<tU16, std::allocator<tU16> > au16CodePagePos;

   virtual tVoid vDestroy();
   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual tBool operator==(const fi_tcl_DapLanguageDescr& rfoCmp) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   virtual tS32 s32GetTypeId() const { return typesfi_tclToken::EN_DAPLANGUAGEDESCR;}
   virtual tVoid vTakeVisitor(fi_tclVisitorBase& rfoVisitor);
};

class fi_tcl_DevMediaInfo : public fi_tclVisitableTypeBase
{
public:
   fi_tcl_DevMediaInfo():szDevicePath(),bMediaAvailable(0),bMediaAccessable(0),enAccessMode(),enMediaType(),bDefaultDevice(0),enWriteProtState() {}
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   fi_tcl_DevMediaInfo& operator=(const fi_tcl_DevMediaInfo& coRef);
   fi_tcl_DevMediaInfo(const fi_tcl_DevMediaInfo& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
   fi_tclString szDevicePath;
   tBool bMediaAvailable;
   tBool bMediaAccessable;
   fi_tcl_e8_DapAccessMode enAccessMode;
   fi_tcl_e8_DapMediaType enMediaType;
   tBool bDefaultDevice;
   fi_tcl_e8_DapWriteProt enWriteProtState;
   std::vector<fi_tcl_DapVirtualMediaInfo, std::allocator<fi_tcl_DapVirtualMediaInfo> > oVirtualMediaInfoList;

   virtual tVoid vDestroy();
   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual tBool operator==(const fi_tcl_DevMediaInfo& rfoCmp) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   virtual tS32 s32GetTypeId() const { return typesfi_tclToken::EN_DEVMEDIAINFO;}
   virtual tVoid vTakeVisitor(fi_tclVisitorBase& rfoVisitor);
};

class fi_tcl_DapMediaInfo : public fi_tclVisitableTypeBase
{
public:
   fi_tcl_DapMediaInfo():enAccessMode(),enMediaType(),szDeviceName() {}
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   fi_tcl_DapMediaInfo& operator=(const fi_tcl_DapMediaInfo& coRef);
   fi_tcl_DapMediaInfo(const fi_tcl_DapMediaInfo& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
   fi_tcl_e8_DapAccessMode enAccessMode;
   fi_tcl_e8_DapMediaType enMediaType;
   fi_tclString szDeviceName;
   std::vector<fi_tcl_DapVirtualMediaInfo, std::allocator<fi_tcl_DapVirtualMediaInfo> > aoVirtualMediaInfo;

   virtual tVoid vDestroy();
   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual tBool operator==(const fi_tcl_DapMediaInfo& rfoCmp) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   virtual tS32 s32GetTypeId() const { return typesfi_tclToken::EN_DAPMEDIAINFO;}
   virtual tVoid vTakeVisitor(fi_tclVisitorBase& rfoVisitor);
};

class fi_tcl_e8_DapDataType : public fi_tclVisitableTypeBase
{
public:
   fi_tcl_e8_DapDataType():enType(FI_EN_DAP_ENDATATYPE_UNKNOWN) {}

   enum tenType {
      FI_EN_DAP_ENDATATYPE_UNKNOWN = 0UL,
      FI_EN_DAP_ENDATATYPE_RNW = 1UL,
      FI_EN_DAP_ENDATATYPE_LID = 2UL,
      FI_EN_DAP_ENDATATYPE_MAP = 3UL,
      FI_EN_DAP_ENDATATYPE_TTC = 6UL,
      FI_EN_DAP_ENDATATYPE_CTS = 7UL,
      FI_EN_DAP_ENDATATYPE_TLG = 8UL,
      FI_EN_DAP_ENDATATYPE_EXT = 10UL,
      FI_EN_DAP_ENDATATYPE_TMC = 12UL,
      FI_EN_DAP_ENDATATYPE_TCF = 13UL,
      FI_EN_DAP_ENDATATYPE_MID = 14UL,
      FI_EN_DAP_ENDATATYPE_GID = 15UL,
      FI_EN_DAP_ENDATATYPE_SDB = 16UL,
      FI_EN_DAP_ENDATATYPE_SDN = 17UL,
      FI_EN_DAP_ENDATATYPE_PTH = 18UL
   };
   tenType enType;

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual tBool operator==(const fi_tcl_e8_DapDataType& rfoCmp) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   virtual tS32 s32GetTypeId() const { return typesfi_tclToken::EN_E8_DAPDATATYPE;}
   virtual tVoid vTakeVisitor(fi_tclVisitorBase& rfoVisitor);
};

class fi_tcl_DapDataSetInfo : public fi_tclVisitableTypeBase
{
public:
   fi_tcl_DapDataSetInfo():u32MediaId(0),u32DatasetId(0),enDataAvailable(),szAccessPath() {}
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   fi_tcl_DapDataSetInfo& operator=(const fi_tcl_DapDataSetInfo& coRef);
   fi_tcl_DapDataSetInfo(const fi_tcl_DapDataSetInfo& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
   tU32 u32MediaId;
   tU32 u32DatasetId;
   fi_tcl_e8_DapDataAvailable enDataAvailable;
   fi_tclString szAccessPath;

   virtual tVoid vDestroy();
   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual tBool operator==(const fi_tcl_DapDataSetInfo& rfoCmp) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   virtual tS32 s32GetTypeId() const { return typesfi_tclToken::EN_DAPDATASETINFO;}
   virtual tVoid vTakeVisitor(fi_tclVisitorBase& rfoVisitor);
};

class fi_tcl_DapDefaultControl : public fi_tclVisitableTypeBase
{
public:
   fi_tcl_DapDefaultControl():u32CtrlHandle(0),bGetControl(0) {}
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   fi_tcl_DapDefaultControl& operator=(const fi_tcl_DapDefaultControl& coRef);
   fi_tcl_DapDefaultControl(const fi_tcl_DapDefaultControl& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
   tU32 u32CtrlHandle;
   tBool bGetControl;

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual tBool operator==(const fi_tcl_DapDefaultControl& rfoCmp) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   virtual tS32 s32GetTypeId() const { return typesfi_tclToken::EN_DAPDEFAULTCONTROL;}
   virtual tVoid vTakeVisitor(fi_tclVisitorBase& rfoVisitor);
};

class fi_tcl_DapRegionMetaInfo : public fi_tclVisitableTypeBase
{
public:
   fi_tcl_DapRegionMetaInfo():u16RegionId(0),szRegionCode() {}
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   fi_tcl_DapRegionMetaInfo& operator=(const fi_tcl_DapRegionMetaInfo& coRef);
   fi_tcl_DapRegionMetaInfo(const fi_tcl_DapRegionMetaInfo& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
   tU16 u16RegionId;
   fi_tclString szRegionCode;

   virtual tVoid vDestroy();
   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual tBool operator==(const fi_tcl_DapRegionMetaInfo& rfoCmp) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   virtual tS32 s32GetTypeId() const { return typesfi_tclToken::EN_DAPREGIONMETAINFO;}
   virtual tVoid vTakeVisitor(fi_tclVisitorBase& rfoVisitor);
};

class fi_tcl_DapProfileMetaInfo : public fi_tclVisitableTypeBase
{
public:
   fi_tcl_DapProfileMetaInfo():u8ProfileID(0),szProfile() {}
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   fi_tcl_DapProfileMetaInfo& operator=(const fi_tcl_DapProfileMetaInfo& coRef);
   fi_tcl_DapProfileMetaInfo(const fi_tcl_DapProfileMetaInfo& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
   tU8 u8ProfileID;
   fi_tclString szProfile;

   virtual tVoid vDestroy();
   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual tBool operator==(const fi_tcl_DapProfileMetaInfo& rfoCmp) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   virtual tS32 s32GetTypeId() const { return typesfi_tclToken::EN_DAPPROFILEMETAINFO;}
   virtual tVoid vTakeVisitor(fi_tclVisitorBase& rfoVisitor);
};

class fi_tcl_DapRegionDescription : public fi_tclVisitableTypeBase
{
public:
   fi_tcl_DapRegionDescription():u16RegionId(0),szDevice(),u32MediumId(0) {}
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   fi_tcl_DapRegionDescription& operator=(const fi_tcl_DapRegionDescription& coRef);
   fi_tcl_DapRegionDescription(const fi_tcl_DapRegionDescription& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
   tU16 u16RegionId;
   fi_tclString szDevice;
   tU32 u32MediumId;

   virtual tVoid vDestroy();
   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual tBool operator==(const fi_tcl_DapRegionDescription& rfoCmp) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   virtual tS32 s32GetTypeId() const { return typesfi_tclToken::EN_DAPREGIONDESCRIPTION;}
   virtual tVoid vTakeVisitor(fi_tclVisitorBase& rfoVisitor);
};

class fi_tcl_b8_StructureType : public fi_tclVisitableTypeBase
{
public:
   fi_tcl_b8_StructureType():u8Value(0) {}

   enum {
      FI_C_U8_BIT_CLUSTER = 0x1UL,
      FI_C_U8_BIT_ANNOTATION = 0x2UL,
      FI_C_U8_BIT_EXT = 0x4UL,
      FI_C_U8_BIT_AREA = 0x8UL
   };
   tBool bCLUSTER() const {return (u8Value & FI_C_U8_BIT_CLUSTER) != 0; }
   tVoid vSetCLUSTER(tBool bSetBit) { u8Value = (bSetBit)?(u8Value | FI_C_U8_BIT_CLUSTER):(u8Value & ~FI_C_U8_BIT_CLUSTER); }
   tBool bANNOTATION() const {return (u8Value & FI_C_U8_BIT_ANNOTATION) != 0; }
   tVoid vSetANNOTATION(tBool bSetBit) { u8Value = (bSetBit)?(u8Value | FI_C_U8_BIT_ANNOTATION):(u8Value & ~FI_C_U8_BIT_ANNOTATION); }
   tBool bEXT() const {return (u8Value & FI_C_U8_BIT_EXT) != 0; }
   tVoid vSetEXT(tBool bSetBit) { u8Value = (bSetBit)?(u8Value | FI_C_U8_BIT_EXT):(u8Value & ~FI_C_U8_BIT_EXT); }
   tBool bArea() const {return (u8Value & FI_C_U8_BIT_AREA) != 0; }
   tVoid vSetArea(tBool bSetBit) { u8Value = (bSetBit)?(u8Value | FI_C_U8_BIT_AREA):(u8Value & ~FI_C_U8_BIT_AREA); }
   struct rBitValues {
      unsigned int CLUSTER:1;
      unsigned int ANNOTATION:1;
      unsigned int EXT:1;
      unsigned int Area:1;
      unsigned int dummy4:1;
      unsigned int dummy5:1;
      unsigned int dummy6:1;
      unsigned int dummy7:1;
   };
   union {
      tU8 u8Value;
      rBitValues bits;
   };

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual tBool operator==(const fi_tcl_b8_StructureType& rfoCmp) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   virtual tS32 s32GetTypeId() const { return typesfi_tclToken::EN_B8_STRUCTURETYPE;}
   virtual tVoid vTakeVisitor(fi_tclVisitorBase& rfoVisitor);
};

class fi_tcl_e32_RNWExtensionType : public fi_tclVisitableTypeBase
{
public:
   fi_tcl_e32_RNWExtensionType():enType(FI_EN_RNW_ENNOEXTENSION) {}

   enum tenType {
      FI_EN_RNW_ENNOEXTENSION = 0UL,
      FI_EN_RNW_ENBASEEXTENSION = 1UL
   };
   tenType enType;

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual tBool operator==(const fi_tcl_e32_RNWExtensionType& rfoCmp) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   virtual tS32 s32GetTypeId() const { return typesfi_tclToken::EN_E32_RNWEXTENSIONTYPE;}
   virtual tVoid vTakeVisitor(fi_tclVisitorBase& rfoVisitor);
};

class fi_tcl_e8_RNWDataUsageState : public fi_tclVisitableTypeBase
{
public:
   fi_tcl_e8_RNWDataUsageState():enType(FI_EN_RNW_ENDATANOTAVAILABLE) {}

   enum tenType {
      FI_EN_RNW_ENDATANOTAVAILABLE = 0UL,
      FI_EN_RNW_ENDATAUNUSED = 1UL,
      FI_EN_RNW_ENDATAUSEDBYONESELFONLY = 2UL,
      FI_EN_RNW_ENDATAUSEDBYOTHERSONLY = 3UL,
      FI_EN_RNW_ENDATAUSEDBYSELFANDOTHER = 4UL
   };
   tenType enType;

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual tBool operator==(const fi_tcl_e8_RNWDataUsageState& rfoCmp) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   virtual tS32 s32GetTypeId() const { return typesfi_tclToken::EN_E8_RNWDATAUSAGESTATE;}
   virtual tVoid vTakeVisitor(fi_tclVisitorBase& rfoVisitor);
};

class fi_tcl_MemPos : public fi_tclVisitableTypeBase
{
public:
   fi_tcl_MemPos():u32Offset(0),u32Length(0) {}
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   fi_tcl_MemPos& operator=(const fi_tcl_MemPos& coRef);
   fi_tcl_MemPos(const fi_tcl_MemPos& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
   tU32 u32Offset;
   tU32 u32Length;

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual tBool operator==(const fi_tcl_MemPos& rfoCmp) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   virtual tS32 s32GetTypeId() const { return typesfi_tclToken::EN_MEMPOS;}
   virtual tVoid vTakeVisitor(fi_tclVisitorBase& rfoVisitor);
};

class fi_tcl_StructureReference : public fi_tclVisitableTypeBase
{
public:
   fi_tcl_StructureReference():oClusterPos(),oExpAnnPos(),oExtClPos(),oAreaPos() {}
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   fi_tcl_StructureReference& operator=(const fi_tcl_StructureReference& coRef);
   fi_tcl_StructureReference(const fi_tcl_StructureReference& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
   fi_tcl_MemPos oClusterPos;
   fi_tcl_MemPos oExpAnnPos;
   fi_tcl_MemPos oExtClPos;
   fi_tcl_MemPos oAreaPos;

   virtual tVoid vDestroy();
   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual tBool operator==(const fi_tcl_StructureReference& rfoCmp) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   virtual tS32 s32GetTypeId() const { return typesfi_tclToken::EN_STRUCTUREREFERENCE;}
   virtual tVoid vTakeVisitor(fi_tclVisitorBase& rfoVisitor);
};

class fi_tcl_NavClusterId : public fi_tclVisitableTypeBase
{
public:
   fi_tcl_NavClusterId():FileOffset(0),ClusterLength(0),FileId(0) {}
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   fi_tcl_NavClusterId& operator=(const fi_tcl_NavClusterId& coRef);
   fi_tcl_NavClusterId(const fi_tcl_NavClusterId& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
   tU32 FileOffset;
   tU16 ClusterLength;
   tU16 FileId;

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual tBool operator==(const fi_tcl_NavClusterId& rfoCmp) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   virtual tS32 s32GetTypeId() const { return typesfi_tclToken::EN_NAVCLUSTERID;}
   virtual tVoid vTakeVisitor(fi_tclVisitorBase& rfoVisitor);
};

class fi_tcl_ClusterResultInfo : public fi_tclVisitableTypeBase
{
public:
   fi_tcl_ClusterResultInfo():oClusterId(),oDataRef(),u16ErrorCode(0) {}
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   fi_tcl_ClusterResultInfo& operator=(const fi_tcl_ClusterResultInfo& coRef);
   fi_tcl_ClusterResultInfo(const fi_tcl_ClusterResultInfo& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
   fi_tcl_NavClusterId oClusterId;
   fi_tcl_StructureReference oDataRef;
   tU16 u16ErrorCode;

   virtual tVoid vDestroy();
   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual tBool operator==(const fi_tcl_ClusterResultInfo& rfoCmp) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   virtual tS32 s32GetTypeId() const { return typesfi_tclToken::EN_CLUSTERRESULTINFO;}
   virtual tVoid vTakeVisitor(fi_tclVisitorBase& rfoVisitor);
};

class fi_tcl_RNWDataStorageInfo : public fi_tclVisitableTypeBase
{
public:
   fi_tcl_RNWDataStorageInfo():oClusterId(),UsageState() {}
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   fi_tcl_RNWDataStorageInfo& operator=(const fi_tcl_RNWDataStorageInfo& coRef);
   fi_tcl_RNWDataStorageInfo(const fi_tcl_RNWDataStorageInfo& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
   fi_tcl_NavClusterId oClusterId;
   fi_tcl_e8_RNWDataUsageState UsageState;

   virtual tVoid vDestroy();
   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual tBool operator==(const fi_tcl_RNWDataStorageInfo& rfoCmp) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   virtual tS32 s32GetTypeId() const { return typesfi_tclToken::EN_RNWDATASTORAGEINFO;}
   virtual tVoid vTakeVisitor(fi_tclVisitorBase& rfoVisitor);
};

class fi_tcl_e8_LocClass : public fi_tclVisitableTypeBase
{
public:
   fi_tcl_e8_LocClass():enType(FI_EN_TMC_LOCCLASS_NONE) {}

   enum tenType {
      FI_EN_TMC_LOCCLASS_NONE = 0UL,
      FI_EN_TMC_LOCCLASS_AREA = 1UL,
      FI_EN_TMC_LOCCLASS_SEGMENT = 2UL,
      FI_EN_TMC_LOCCLASS_POINT = 3UL
   };
   tenType enType;

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual tBool operator==(const fi_tcl_e8_LocClass& rfoCmp) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   virtual tS32 s32GetTypeId() const { return typesfi_tclToken::EN_E8_LOCCLASS;}
   virtual tVoid vTakeVisitor(fi_tclVisitorBase& rfoVisitor);
};

class fi_tcl_e8_CarriageWay : public fi_tclVisitableTypeBase
{
public:
   fi_tcl_e8_CarriageWay():enType(FI_EN_TMC_CARRIAGEWAY_UNKNOWN) {}

   enum tenType {
      FI_EN_TMC_CARRIAGEWAY_UNKNOWN = 0UL,
      FI_EN_TMC_CARRIAGEWAY_MAIN = 1UL,
      FI_EN_TMC_CARRIAGEWAY_SUB = 2UL
   };
   tenType enType;

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual tBool operator==(const fi_tcl_e8_CarriageWay& rfoCmp) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   virtual tS32 s32GetTypeId() const { return typesfi_tclToken::EN_E8_CARRIAGEWAY;}
   virtual tVoid vTakeVisitor(fi_tclVisitorBase& rfoVisitor);
};

class fi_tcl_e8_TrafficFlow : public fi_tclVisitableTypeBase
{
public:
   fi_tcl_e8_TrafficFlow():enType(FI_EN_TMC_TRAFFICFLOW_UNKNOWN) {}

   enum tenType {
      FI_EN_TMC_TRAFFICFLOW_UNKNOWN = 0UL,
      FI_EN_TMC_TRAFFICFLOW_INDIR = 2UL,
      FI_EN_TMC_TRAFFICFLOW_AGAINSTDIR = 4UL,
      FI_EN_TMC_TRAFFICFLOW_BOTHDIR = 6UL
   };
   tenType enType;

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual tBool operator==(const fi_tcl_e8_TrafficFlow& rfoCmp) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   virtual tS32 s32GetTypeId() const { return typesfi_tclToken::EN_E8_TRAFFICFLOW;}
   virtual tVoid vTakeVisitor(fi_tclVisitorBase& rfoVisitor);
};

class fi_tcl_e8_FollowDirection : public fi_tclVisitableTypeBase
{
public:
   fi_tcl_e8_FollowDirection():enType(FI_EN_TMC_FOLLOWDIRECTION_UNKNOWN) {}

   enum tenType {
      FI_EN_TMC_FOLLOWDIRECTION_UNKNOWN = 0UL,
      FI_EN_TMC_FOLLOWDIRECTION_PREVIOUS = 1UL,
      FI_EN_TMC_FOLLOWDIRECTION_NEXT = 2UL
   };
   tenType enType;

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual tBool operator==(const fi_tcl_e8_FollowDirection& rfoCmp) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   virtual tS32 s32GetTypeId() const { return typesfi_tclToken::EN_E8_FOLLOWDIRECTION;}
   virtual tVoid vTakeVisitor(fi_tclVisitorBase& rfoVisitor);
};

class fi_tcl_LocTableIdent : public fi_tclVisitableTypeBase
{
public:
   fi_tcl_LocTableIdent():u8CountryCode(0),u8TableNumber(0) {}
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   fi_tcl_LocTableIdent& operator=(const fi_tcl_LocTableIdent& coRef);
   fi_tcl_LocTableIdent(const fi_tcl_LocTableIdent& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
   tU8 u8CountryCode;
   tU8 u8TableNumber;

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual tBool operator==(const fi_tcl_LocTableIdent& rfoCmp) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   virtual tS32 s32GetTypeId() const { return typesfi_tclToken::EN_LOCTABLEIDENT;}
   virtual tVoid vTakeVisitor(fi_tclVisitorBase& rfoVisitor);
};

class fi_tcl_Outline : public fi_tclVisitableTypeBase
{
public:
   fi_tcl_Outline() {}
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   fi_tcl_Outline& operator=(const fi_tcl_Outline& coRef);
   fi_tcl_Outline(const fi_tcl_Outline& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
   std::vector<fi_tcl_PositionWGS84, std::allocator<fi_tcl_PositionWGS84> > Points;

   virtual tVoid vDestroy();
   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual tBool operator==(const fi_tcl_Outline& rfoCmp) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   virtual tS32 s32GetTypeId() const { return typesfi_tclToken::EN_OUTLINE;}
   virtual tVoid vTakeVisitor(fi_tclVisitorBase& rfoVisitor);
};

class fi_tcl_e16_ISOCountryCode : public fi_tclVisitableTypeBase
{
public:
   fi_tcl_e16_ISOCountryCode():enType(FI_EN_ISO_ALPHA_3_UNDEFINED) {}

   enum tenType {
      FI_EN_ISO_ALPHA_3_UNDEFINED = 0UL,
      FI_EN_ISO_ALPHA_3_AFG = 1223UL,
      FI_EN_ISO_ALPHA_3_ALB = 1410UL,
      FI_EN_ISO_ALPHA_3_DZA = 4929UL,
      FI_EN_ISO_ALPHA_3_ASM = 1645UL,
      FI_EN_ISO_ALPHA_3_AND = 1476UL,
      FI_EN_ISO_ALPHA_3_AGO = 1263UL,
      FI_EN_ISO_ALPHA_3_AIA = 1313UL,
      FI_EN_ISO_ALPHA_3_ATG = 1671UL,
      FI_EN_ISO_ALPHA_3_ARG = 1607UL,
      FI_EN_ISO_ALPHA_3_ARM = 1613UL,
      FI_EN_ISO_ALPHA_3_ABW = 1111UL,
      FI_EN_ISO_ALPHA_3_AUS = 1715UL,
      FI_EN_ISO_ALPHA_3_AUT = 1716UL,
      FI_EN_ISO_ALPHA_3_AZE = 1861UL,
      FI_EN_ISO_ALPHA_3_BHS = 2323UL,
      FI_EN_ISO_ALPHA_3_BHR = 2322UL,
      FI_EN_ISO_ALPHA_3_BGD = 2276UL,
      FI_EN_ISO_ALPHA_3_BRB = 2626UL,
      FI_EN_ISO_ALPHA_3_BLR = 2450UL,
      FI_EN_ISO_ALPHA_3_BEL = 2220UL,
      FI_EN_ISO_ALPHA_3_BLZ = 2458UL,
      FI_EN_ISO_ALPHA_3_BEN = 2222UL,
      FI_EN_ISO_ALPHA_3_BMU = 2485UL,
      FI_EN_ISO_ALPHA_3_BTN = 2702UL,
      FI_EN_ISO_ALPHA_3_BOL = 2540UL,
      FI_EN_ISO_ALPHA_3_BIH = 2344UL,
      FI_EN_ISO_ALPHA_3_BWA = 2785UL,
      FI_EN_ISO_ALPHA_3_BRA = 2625UL,
      FI_EN_ISO_ALPHA_3_BRN = 2638UL,
      FI_EN_ISO_ALPHA_3_BGR = 2290UL,
      FI_EN_ISO_ALPHA_3_BFA = 2241UL,
      FI_EN_ISO_ALPHA_3_BDI = 2185UL,
      FI_EN_ISO_ALPHA_3_KHM = 11533UL,
      FI_EN_ISO_ALPHA_3_CMR = 3506UL,
      FI_EN_ISO_ALPHA_3_CAN = 3118UL,
      FI_EN_ISO_ALPHA_3_CPV = 3606UL,
      FI_EN_ISO_ALPHA_3_CYM = 3885UL,
      FI_EN_ISO_ALPHA_3_CAF = 3110UL,
      FI_EN_ISO_ALPHA_3_TCD = 20580UL,
      FI_EN_ISO_ALPHA_3_CHL = 3340UL,
      FI_EN_ISO_ALPHA_3_CHN = 3342UL,
      FI_EN_ISO_ALPHA_3_COL = 3564UL,
      FI_EN_ISO_ALPHA_3_COM = 3565UL,
      FI_EN_ISO_ALPHA_3_COG = 3559UL,
      FI_EN_ISO_ALPHA_3_COD = 3556UL,
      FI_EN_ISO_ALPHA_3_COK = 3563UL,
      FI_EN_ISO_ALPHA_3_CRI = 3657UL,
      FI_EN_ISO_ALPHA_3_CIV = 3382UL,
      FI_EN_ISO_ALPHA_3_HRV = 8790UL,
      FI_EN_ISO_ALPHA_3_CUB = 3746UL,
      FI_EN_ISO_ALPHA_3_CYP = 3888UL,
      FI_EN_ISO_ALPHA_3_CZE = 3909UL,
      FI_EN_ISO_ALPHA_3_DNK = 4555UL,
      FI_EN_ISO_ALPHA_3_DJI = 4425UL,
      FI_EN_ISO_ALPHA_3_DMA = 4513UL,
      FI_EN_ISO_ALPHA_3_DOM = 4589UL,
      FI_EN_ISO_ALPHA_3_ECU = 5237UL,
      FI_EN_ISO_ALPHA_3_EGY = 5369UL,
      FI_EN_ISO_ALPHA_3_SLV = 19862UL,
      FI_EN_ISO_ALPHA_3_GNQ = 7633UL,
      FI_EN_ISO_ALPHA_3_ERI = 5705UL,
      FI_EN_ISO_ALPHA_3_EST = 5748UL,
      FI_EN_ISO_ALPHA_3_ETH = 5768UL,
      FI_EN_ISO_ALPHA_3_FLK = 6539UL,
      FI_EN_ISO_ALPHA_3_FRO = 6735UL,
      FI_EN_ISO_ALPHA_3_FJI = 6473UL,
      FI_EN_ISO_ALPHA_3_FIN = 6446UL,
      FI_EN_ISO_ALPHA_3_FRA = 6721UL,
      FI_EN_ISO_ALPHA_3_GUF = 7846UL,
      FI_EN_ISO_ALPHA_3_PYF = 17190UL,
      FI_EN_ISO_ALPHA_3_GAB = 7202UL,
      FI_EN_ISO_ALPHA_3_GMB = 7586UL,
      FI_EN_ISO_ALPHA_3_GEO = 7343UL,
      FI_EN_ISO_ALPHA_3_DEU = 4277UL,
      FI_EN_ISO_ALPHA_3_GHA = 7425UL,
      FI_EN_ISO_ALPHA_3_GIB = 7458UL,
      FI_EN_ISO_ALPHA_3_GRC = 7747UL,
      FI_EN_ISO_ALPHA_3_GRL = 7756UL,
      FI_EN_ISO_ALPHA_3_GRD = 7748UL,
      FI_EN_ISO_ALPHA_3_GLP = 7568UL,
      FI_EN_ISO_ALPHA_3_GUM = 7853UL,
      FI_EN_ISO_ALPHA_3_GTM = 7821UL,
      FI_EN_ISO_ALPHA_3_GIN = 7470UL,
      FI_EN_ISO_ALPHA_3_GNB = 7618UL,
      FI_EN_ISO_ALPHA_3_GUY = 7865UL,
      FI_EN_ISO_ALPHA_3_HTI = 8841UL,
      FI_EN_ISO_ALPHA_3_VAT = 22580UL,
      FI_EN_ISO_ALPHA_3_HND = 8644UL,
      FI_EN_ISO_ALPHA_3_HKG = 8551UL,
      FI_EN_ISO_ALPHA_3_HUN = 8878UL,
      FI_EN_ISO_ALPHA_3_ISL = 9836UL,
      FI_EN_ISO_ALPHA_3_IND = 9668UL,
      FI_EN_ISO_ALPHA_3_IDN = 9358UL,
      FI_EN_ISO_ALPHA_3_INT = 9684UL,
      FI_EN_ISO_ALPHA_3_IRN = 9806UL,
      FI_EN_ISO_ALPHA_3_IRQ = 9809UL,
      FI_EN_ISO_ALPHA_3_IRL = 9804UL,
      FI_EN_ISO_ALPHA_3_ISR = 9842UL,
      FI_EN_ISO_ALPHA_3_ITA = 9857UL,
      FI_EN_ISO_ALPHA_3_JAM = 10285UL,
      FI_EN_ISO_ALPHA_3_JPN = 10766UL,
      FI_EN_ISO_ALPHA_3_JOR = 10738UL,
      FI_EN_ISO_ALPHA_3_KAZ = 11322UL,
      FI_EN_ISO_ALPHA_3_KEN = 11438UL,
      FI_EN_ISO_ALPHA_3_KIR = 11570UL,
      FI_EN_ISO_ALPHA_3_PRK = 16971UL,
      FI_EN_ISO_ALPHA_3_KOR = 11762UL,
      FI_EN_ISO_ALPHA_3_KWT = 12020UL,
      FI_EN_ISO_ALPHA_3_KGZ = 11514UL,
      FI_EN_ISO_ALPHA_3_LAO = 12335UL,
      FI_EN_ISO_ALPHA_3_LVA = 12993UL,
      FI_EN_ISO_ALPHA_3_LBN = 12366UL,
      FI_EN_ISO_ALPHA_3_LSO = 12911UL,
      FI_EN_ISO_ALPHA_3_LBR = 12370UL,
      FI_EN_ISO_ALPHA_3_LBY = 12377UL,
      FI_EN_ISO_ALPHA_3_LIE = 12581UL,
      FI_EN_ISO_ALPHA_3_LTU = 12949UL,
      FI_EN_ISO_ALPHA_3_LUX = 12984UL,
      FI_EN_ISO_ALPHA_3_MAC = 13347UL,
      FI_EN_ISO_ALPHA_3_MKD = 13668UL,
      FI_EN_ISO_ALPHA_3_MDG = 13447UL,
      FI_EN_ISO_ALPHA_3_MWI = 14057UL,
      FI_EN_ISO_ALPHA_3_MYS = 14131UL,
      FI_EN_ISO_ALPHA_3_MDV = 13462UL,
      FI_EN_ISO_ALPHA_3_MLI = 13705UL,
      FI_EN_ISO_ALPHA_3_MLT = 13716UL,
      FI_EN_ISO_ALPHA_3_MHL = 13580UL,
      FI_EN_ISO_ALPHA_3_MTQ = 13969UL,
      FI_EN_ISO_ALPHA_3_MRT = 13908UL,
      FI_EN_ISO_ALPHA_3_MUS = 14003UL,
      FI_EN_ISO_ALPHA_3_MYT = 14132UL,
      FI_EN_ISO_ALPHA_3_MEX = 13496UL,
      FI_EN_ISO_ALPHA_3_FSM = 6765UL,
      FI_EN_ISO_ALPHA_3_MDA = 13441UL,
      FI_EN_ISO_ALPHA_3_MCO = 13423UL,
      FI_EN_ISO_ALPHA_3_MNG = 13767UL,
      FI_EN_ISO_ALPHA_3_MNE = 13765UL,
      FI_EN_ISO_ALPHA_3_MSR = 13938UL,
      FI_EN_ISO_ALPHA_3_MAR = 13362UL,
      FI_EN_ISO_ALPHA_3_MOZ = 13818UL,
      FI_EN_ISO_ALPHA_3_MMR = 13746UL,
      FI_EN_ISO_ALPHA_3_NAM = 14381UL,
      FI_EN_ISO_ALPHA_3_NRU = 14933UL,
      FI_EN_ISO_ALPHA_3_NPL = 14860UL,
      FI_EN_ISO_ALPHA_3_NLD = 14724UL,
      FI_EN_ISO_ALPHA_3_ANT = 1492UL,
      FI_EN_ISO_ALPHA_3_NCL = 14444UL,
      FI_EN_ISO_ALPHA_3_NZL = 15180UL,
      FI_EN_ISO_ALPHA_3_NIC = 14627UL,
      FI_EN_ISO_ALPHA_3_NER = 14514UL,
      FI_EN_ISO_ALPHA_3_NGA = 14561UL,
      FI_EN_ISO_ALPHA_3_NIU = 14645UL,
      FI_EN_ISO_ALPHA_3_NFK = 14539UL,
      FI_EN_ISO_ALPHA_3_MNP = 13776UL,
      FI_EN_ISO_ALPHA_3_NOR = 14834UL,
      FI_EN_ISO_ALPHA_3_PSE = 16997UL,
      FI_EN_ISO_ALPHA_3_OMN = 15790UL,
      FI_EN_ISO_ALPHA_3_PAK = 16427UL,
      FI_EN_ISO_ALPHA_3_PLW = 16791UL,
      FI_EN_ISO_ALPHA_3_PAN = 16430UL,
      FI_EN_ISO_ALPHA_3_PNG = 16839UL,
      FI_EN_ISO_ALPHA_3_PRY = 16985UL,
      FI_EN_ISO_ALPHA_3_PER = 16562UL,
      FI_EN_ISO_ALPHA_3_PHL = 16652UL,
      FI_EN_ISO_ALPHA_3_PCN = 16494UL,
      FI_EN_ISO_ALPHA_3_POL = 16876UL,
      FI_EN_ISO_ALPHA_3_PRT = 16980UL,
      FI_EN_ISO_ALPHA_3_PRI = 16969UL,
      FI_EN_ISO_ALPHA_3_QAT = 17460UL,
      FI_EN_ISO_ALPHA_3_REU = 18613UL,
      FI_EN_ISO_ALPHA_3_ROU = 18933UL,
      FI_EN_ISO_ALPHA_3_RUS = 19123UL,
      FI_EN_ISO_ALPHA_3_RWA = 19169UL,
      FI_EN_ISO_ALPHA_3_KNA = 11713UL,
      FI_EN_ISO_ALPHA_3_LCA = 12385UL,
      FI_EN_ISO_ALPHA_3_VCT = 22644UL,
      FI_EN_ISO_ALPHA_3_WSM = 24173UL,
      FI_EN_ISO_ALPHA_3_SMR = 19890UL,
      FI_EN_ISO_ALPHA_3_STP = 20112UL,
      FI_EN_ISO_ALPHA_3_SAU = 19509UL,
      FI_EN_ISO_ALPHA_3_SEN = 19630UL,
      FI_EN_ISO_ALPHA_3_SRB = 20034UL,
      FI_EN_ISO_ALPHA_3_SYC = 20259UL,
      FI_EN_ISO_ALPHA_3_SLE = 19845UL,
      FI_EN_ISO_ALPHA_3_SGP = 19696UL,
      FI_EN_ISO_ALPHA_3_SVK = 20171UL,
      FI_EN_ISO_ALPHA_3_SVN = 20174UL,
      FI_EN_ISO_ALPHA_3_SLB = 19842UL,
      FI_EN_ISO_ALPHA_3_SOM = 19949UL,
      FI_EN_ISO_ALPHA_3_ZAF = 26662UL,
      FI_EN_ISO_ALPHA_3_ESP = 5744UL,
      FI_EN_ISO_ALPHA_3_LKA = 12641UL,
      FI_EN_ISO_ALPHA_3_SHN = 19726UL,
      FI_EN_ISO_ALPHA_3_SPM = 19981UL,
      FI_EN_ISO_ALPHA_3_SDN = 19598UL,
      FI_EN_ISO_ALPHA_3_SUR = 20146UL,
      FI_EN_ISO_ALPHA_3_SJM = 19789UL,
      FI_EN_ISO_ALPHA_3_SWZ = 20218UL,
      FI_EN_ISO_ALPHA_3_SWE = 20197UL,
      FI_EN_ISO_ALPHA_3_CHE = 3333UL,
      FI_EN_ISO_ALPHA_3_SYR = 20274UL,
      FI_EN_ISO_ALPHA_3_TWN = 21230UL,
      FI_EN_ISO_ALPHA_3_TJK = 20811UL,
      FI_EN_ISO_ALPHA_3_TZA = 21313UL,
      FI_EN_ISO_ALPHA_3_THA = 20737UL,
      FI_EN_ISO_ALPHA_3_TLS = 20883UL,
      FI_EN_ISO_ALPHA_3_TGO = 20719UL,
      FI_EN_ISO_ALPHA_3_TKL = 20844UL,
      FI_EN_ISO_ALPHA_3_TON = 20974UL,
      FI_EN_ISO_ALPHA_3_TTO = 21135UL,
      FI_EN_ISO_ALPHA_3_TUN = 21166UL,
      FI_EN_ISO_ALPHA_3_TUR = 21170UL,
      FI_EN_ISO_ALPHA_3_TKM = 20845UL,
      FI_EN_ISO_ALPHA_3_TCA = 20577UL,
      FI_EN_ISO_ALPHA_3_TUV = 21174UL,
      FI_EN_ISO_ALPHA_3_UGA = 21729UL,
      FI_EN_ISO_ALPHA_3_UKR = 21874UL,
      FI_EN_ISO_ALPHA_3_ARE = 1605UL,
      FI_EN_ISO_ALPHA_3_GBR = 7250UL,
      FI_EN_ISO_ALPHA_3_USA = 22113UL,
      FI_EN_ISO_ALPHA_3_URY = 22105UL,
      FI_EN_ISO_ALPHA_3_UZB = 22338UL,
      FI_EN_ISO_ALPHA_3_VUT = 23220UL,
      FI_EN_ISO_ALPHA_3_VEN = 22702UL,
      FI_EN_ISO_ALPHA_3_VNM = 22989UL,
      FI_EN_ISO_ALPHA_3_VGB = 22754UL,
      FI_EN_ISO_ALPHA_3_VIR = 22834UL,
      FI_EN_ISO_ALPHA_3_WLF = 23942UL,
      FI_EN_ISO_ALPHA_3_ESH = 5736UL,
      FI_EN_ISO_ALPHA_3_YEM = 25773UL,
      FI_EN_ISO_ALPHA_3_YUG = 26279UL,
      FI_EN_ISO_ALPHA_3_ZMB = 27042UL,
      FI_EN_ISO_ALPHA_3_ZWE = 27365UL
   };
   tenType enType;

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual tBool operator==(const fi_tcl_e16_ISOCountryCode& rfoCmp) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   virtual tS32 s32GetTypeId() const { return typesfi_tclToken::EN_E16_ISOCOUNTRYCODE;}
   virtual tVoid vTakeVisitor(fi_tclVisitorBase& rfoVisitor);
};

class fi_tcl_e16_ISOLanguageCode : public fi_tclVisitableTypeBase
{
public:
   fi_tcl_e16_ISOLanguageCode():enType(FI_EN_ISO_639_1_UNDEFINED) {}

   enum tenType {
      FI_EN_ISO_639_1_UNDEFINED = 0UL,
      FI_EN_ISO_639_1_AA = 24929UL,
      FI_EN_ISO_639_1_AB = 24930UL,
      FI_EN_ISO_639_1_AE = 24933UL,
      FI_EN_ISO_639_1_AF = 24934UL,
      FI_EN_ISO_639_1_AK = 24939UL,
      FI_EN_ISO_639_1_AM = 24941UL,
      FI_EN_ISO_639_1_AN = 24942UL,
      FI_EN_ISO_639_1_AR = 24946UL,
      FI_EN_ISO_639_1_AS = 24947UL,
      FI_EN_ISO_639_1_AV = 24950UL,
      FI_EN_ISO_639_1_AY = 24953UL,
      FI_EN_ISO_639_1_AZ = 24954UL,
      FI_EN_ISO_639_1_BA = 25185UL,
      FI_EN_ISO_639_1_BE = 25189UL,
      FI_EN_ISO_639_1_BG = 25191UL,
      FI_EN_ISO_639_1_BH = 25192UL,
      FI_EN_ISO_639_1_BI = 25193UL,
      FI_EN_ISO_639_1_BL = 25196UL,
      FI_EN_ISO_639_1_BM = 25197UL,
      FI_EN_ISO_639_1_BN = 25198UL,
      FI_EN_ISO_639_1_BO = 25199UL,
      FI_EN_ISO_639_1_BR = 25202UL,
      FI_EN_ISO_639_1_BS = 25203UL,
      FI_EN_ISO_639_1_BT = 25204UL,
      FI_EN_ISO_639_1_CA = 25441UL,
      FI_EN_ISO_639_1_CE = 25445UL,
      FI_EN_ISO_639_1_CF = 25446UL,
      FI_EN_ISO_639_1_CH = 25448UL,
      FI_EN_ISO_639_1_CL = 25452UL,
      FI_EN_ISO_639_1_CN = 25454UL,
      FI_EN_ISO_639_1_CO = 25455UL,
      FI_EN_ISO_639_1_CR = 25458UL,
      FI_EN_ISO_639_1_CS = 25459UL,
      FI_EN_ISO_639_1_CT = 25460UL,
      FI_EN_ISO_639_1_CU = 25461UL,
      FI_EN_ISO_639_1_CV = 25462UL,
      FI_EN_ISO_639_1_CY = 25465UL,
      FI_EN_ISO_639_1_DA = 25697UL,
      FI_EN_ISO_639_1_DE = 25701UL,
      FI_EN_ISO_639_1_DV = 25718UL,
      FI_EN_ISO_639_1_DZ = 25722UL,
      FI_EN_ISO_639_1_EE = 25957UL,
      FI_EN_ISO_639_1_EG = 25959UL,
      FI_EN_ISO_639_1_EL = 25964UL,
      FI_EN_ISO_639_1_EN = 25966UL,
      FI_EN_ISO_639_1_EO = 25967UL,
      FI_EN_ISO_639_1_ES = 25971UL,
      FI_EN_ISO_639_1_ET = 25972UL,
      FI_EN_ISO_639_1_EU = 25973UL,
      FI_EN_ISO_639_1_FA = 26209UL,
      FI_EN_ISO_639_1_FF = 26214UL,
      FI_EN_ISO_639_1_FI = 26217UL,
      FI_EN_ISO_639_1_FJ = 26218UL,
      FI_EN_ISO_639_1_FO = 26223UL,
      FI_EN_ISO_639_1_FR = 26226UL,
      FI_EN_ISO_639_1_FY = 26233UL,
      FI_EN_ISO_639_1_GA = 26465UL,
      FI_EN_ISO_639_1_GD = 26468UL,
      FI_EN_ISO_639_1_GL = 26476UL,
      FI_EN_ISO_639_1_GN = 26478UL,
      FI_EN_ISO_639_1_GU = 26485UL,
      FI_EN_ISO_639_1_GV = 26486UL,
      FI_EN_ISO_639_1_HA = 26721UL,
      FI_EN_ISO_639_1_HE = 26725UL,
      FI_EN_ISO_639_1_HI = 26729UL,
      FI_EN_ISO_639_1_HO = 26735UL,
      FI_EN_ISO_639_1_HR = 26738UL,
      FI_EN_ISO_639_1_HU = 26741UL,
      FI_EN_ISO_639_1_HY = 26745UL,
      FI_EN_ISO_639_1_HZ = 26746UL,
      FI_EN_ISO_639_1_IA = 26977UL,
      FI_EN_ISO_639_1_ID = 26980UL,
      FI_EN_ISO_639_1_IE = 26981UL,
      FI_EN_ISO_639_1_IG = 26983UL,
      FI_EN_ISO_639_1_II = 26985UL,
      FI_EN_ISO_639_1_IK = 26987UL,
      FI_EN_ISO_639_1_IO = 26991UL,
      FI_EN_ISO_639_1_IS = 26995UL,
      FI_EN_ISO_639_1_IT = 26996UL,
      FI_EN_ISO_639_1_IU = 26997UL,
      FI_EN_ISO_639_1_JA = 27233UL,
      FI_EN_ISO_639_1_JV = 27254UL,
      FI_EN_ISO_639_1_KA = 27489UL,
      FI_EN_ISO_639_1_KG = 27495UL,
      FI_EN_ISO_639_1_KI = 27497UL,
      FI_EN_ISO_639_1_KJ = 27498UL,
      FI_EN_ISO_639_1_KK = 27499UL,
      FI_EN_ISO_639_1_KL = 27500UL,
      FI_EN_ISO_639_1_KM = 27501UL,
      FI_EN_ISO_639_1_KN = 27502UL,
      FI_EN_ISO_639_1_KO = 27503UL,
      FI_EN_ISO_639_1_KR = 27506UL,
      FI_EN_ISO_639_1_KS = 27507UL,
      FI_EN_ISO_639_1_KU = 27509UL,
      FI_EN_ISO_639_1_KV = 27510UL,
      FI_EN_ISO_639_1_KW = 27511UL,
      FI_EN_ISO_639_1_KY = 27513UL,
      FI_EN_ISO_639_1_LA = 27745UL,
      FI_EN_ISO_639_1_LB = 27746UL,
      FI_EN_ISO_639_1_LG = 27751UL,
      FI_EN_ISO_639_1_LI = 27753UL,
      FI_EN_ISO_639_1_LN = 27758UL,
      FI_EN_ISO_639_1_LO = 27759UL,
      FI_EN_ISO_639_1_LT = 27764UL,
      FI_EN_ISO_639_1_LU = 27765UL,
      FI_EN_ISO_639_1_LV = 27766UL,
      FI_EN_ISO_639_1_MC = 28003UL,
      FI_EN_ISO_639_1_MG = 28007UL,
      FI_EN_ISO_639_1_MH = 28008UL,
      FI_EN_ISO_639_1_MI = 28009UL,
      FI_EN_ISO_639_1_MK = 28011UL,
      FI_EN_ISO_639_1_ML = 28012UL,
      FI_EN_ISO_639_1_MN = 28014UL,
      FI_EN_ISO_639_1_MO = 28015UL,
      FI_EN_ISO_639_1_MR = 28018UL,
      FI_EN_ISO_639_1_MS = 28019UL,
      FI_EN_ISO_639_1_MT = 28020UL,
      FI_EN_ISO_639_1_MY = 28025UL,
      FI_EN_ISO_639_1_NA = 28257UL,
      FI_EN_ISO_639_1_NB = 28258UL,
      FI_EN_ISO_639_1_ND = 28260UL,
      FI_EN_ISO_639_1_NE = 28261UL,
      FI_EN_ISO_639_1_NG = 28263UL,
      FI_EN_ISO_639_1_NL = 28268UL,
      FI_EN_ISO_639_1_NN = 28270UL,
      FI_EN_ISO_639_1_NO = 28271UL,
      FI_EN_ISO_639_1_NR = 28274UL,
      FI_EN_ISO_639_1_NV = 28278UL,
      FI_EN_ISO_639_1_NY = 28281UL,
      FI_EN_ISO_639_1_OC = 28515UL,
      FI_EN_ISO_639_1_OJ = 28522UL,
      FI_EN_ISO_639_1_OM = 28525UL,
      FI_EN_ISO_639_1_OR = 28530UL,
      FI_EN_ISO_639_1_OS = 28531UL,
      FI_EN_ISO_639_1_PA = 28769UL,
      FI_EN_ISO_639_1_PI = 28777UL,
      FI_EN_ISO_639_1_PL = 28780UL,
      FI_EN_ISO_639_1_PS = 28787UL,
      FI_EN_ISO_639_1_PT = 28788UL,
      FI_EN_ISO_639_1_QU = 29045UL,
      FI_EN_ISO_639_1_RM = 29293UL,
      FI_EN_ISO_639_1_RN = 29294UL,
      FI_EN_ISO_639_1_RO = 29295UL,
      FI_EN_ISO_639_1_RT = 29300UL,
      FI_EN_ISO_639_1_RU = 29301UL,
      FI_EN_ISO_639_1_RW = 29303UL,
      FI_EN_ISO_639_1_SA = 29537UL,
      FI_EN_ISO_639_1_SB = 29538UL,
      FI_EN_ISO_639_1_SC = 29539UL,
      FI_EN_ISO_639_1_SD = 29540UL,
      FI_EN_ISO_639_1_SE = 29541UL,
      FI_EN_ISO_639_1_SG = 29543UL,
      FI_EN_ISO_639_1_SH = 29544UL,
      FI_EN_ISO_639_1_SI = 29545UL,
      FI_EN_ISO_639_1_SK = 29547UL,
      FI_EN_ISO_639_1_SL = 29548UL,
      FI_EN_ISO_639_1_SM = 29549UL,
      FI_EN_ISO_639_1_SN = 29550UL,
      FI_EN_ISO_639_1_SO = 29551UL,
      FI_EN_ISO_639_1_SQ = 29553UL,
      FI_EN_ISO_639_1_SR = 29554UL,
      FI_EN_ISO_639_1_SS = 29555UL,
      FI_EN_ISO_639_1_ST = 29556UL,
      FI_EN_ISO_639_1_SU = 29557UL,
      FI_EN_ISO_639_1_SV = 29558UL,
      FI_EN_ISO_639_1_SW = 29559UL,
      FI_EN_ISO_639_1_SX = 29560UL,
      FI_EN_ISO_639_1_TA = 29793UL,
      FI_EN_ISO_639_1_TE = 29797UL,
      FI_EN_ISO_639_1_TG = 29799UL,
      FI_EN_ISO_639_1_TH = 29800UL,
      FI_EN_ISO_639_1_TI = 29801UL,
      FI_EN_ISO_639_1_TK = 29803UL,
      FI_EN_ISO_639_1_TL = 29804UL,
      FI_EN_ISO_639_1_TN = 29806UL,
      FI_EN_ISO_639_1_TO = 29807UL,
      FI_EN_ISO_639_1_TR = 29810UL,
      FI_EN_ISO_639_1_TS = 29811UL,
      FI_EN_ISO_639_1_TT = 29812UL,
      FI_EN_ISO_639_1_TW = 29815UL,
      FI_EN_ISO_639_1_TY = 29817UL,
      FI_EN_ISO_639_1_UE = 30053UL,
      FI_EN_ISO_639_1_UG = 30055UL,
      FI_EN_ISO_639_1_UK = 30059UL,
      FI_EN_ISO_639_1_UL = 30060UL,
      FI_EN_ISO_639_1_UR = 30066UL,
      FI_EN_ISO_639_1_UZ = 30074UL,
      FI_EN_ISO_639_1_VA = 30305UL,
      FI_EN_ISO_639_1_VE = 30309UL,
      FI_EN_ISO_639_1_VI = 30313UL,
      FI_EN_ISO_639_1_VO = 30319UL,
      FI_EN_ISO_639_1_WA = 30561UL,
      FI_EN_ISO_639_1_WO = 30575UL,
      FI_EN_ISO_639_1_XH = 30824UL,
      FI_EN_ISO_639_1_YI = 31081UL,
      FI_EN_ISO_639_1_YO = 31087UL,
      FI_EN_ISO_639_1_ZA = 31329UL,
      FI_EN_ISO_639_1_ZH = 31336UL,
      FI_EN_ISO_639_1_ZL = 31340UL,
      FI_EN_ISO_639_1_ZU = 31349UL
   };
   tenType enType;

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual tBool operator==(const fi_tcl_e16_ISOLanguageCode& rfoCmp) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   virtual tS32 s32GetTypeId() const { return typesfi_tclToken::EN_E16_ISOLANGUAGECODE;}
   virtual tVoid vTakeVisitor(fi_tclVisitorBase& rfoVisitor);
};

class fi_tcl_PrefixElem : public fi_tclVisitableTypeBase
{
public:
   fi_tcl_PrefixElem():u8Priority(0),u16Status(0),u8NumberHierarchy(0),u32StateCode(0),bVoice(0),pcRoadPrefix() {}
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   fi_tcl_PrefixElem& operator=(const fi_tcl_PrefixElem& coRef);
   fi_tcl_PrefixElem(const fi_tcl_PrefixElem& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
   tU8 u8Priority;
   tU16 u16Status;
   tU8 u8NumberHierarchy;
   tU32 u32StateCode;
   tBool bVoice;
   fi_tclString pcRoadPrefix;

   virtual tVoid vDestroy();
   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual tBool operator==(const fi_tcl_PrefixElem& rfoCmp) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   virtual tS32 s32GetTypeId() const { return typesfi_tclToken::EN_PREFIXELEM;}
   virtual tVoid vTakeVisitor(fi_tclVisitorBase& rfoVisitor);
};

class fi_tcl_PrefixTable : public fi_tclVisitableTypeBase
{
public:
   fi_tcl_PrefixTable():oTableIdent(),u32StartIndex(0),u32NumberOfPrefixes(0) {}
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   fi_tcl_PrefixTable& operator=(const fi_tcl_PrefixTable& coRef);
   fi_tcl_PrefixTable(const fi_tcl_PrefixTable& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
   fi_tcl_LocTableIdent oTableIdent;
   tU32 u32StartIndex;
   tU32 u32NumberOfPrefixes;

   virtual tVoid vDestroy();
   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual tBool operator==(const fi_tcl_PrefixTable& rfoCmp) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   virtual tS32 s32GetTypeId() const { return typesfi_tclToken::EN_PREFIXTABLE;}
   virtual tVoid vTakeVisitor(fi_tclVisitorBase& rfoVisitor);
};

class fi_tcl_e8_DapPrioritaet : public fi_tclVisitableTypeBase
{
public:
   fi_tcl_e8_DapPrioritaet():enType(FI_EN_DAP_JOB_C_U8_PRIO_HIGHEST) {}

   enum tenType {
      FI_EN_DAP_JOB_C_U8_PRIO_HIGHEST = 0UL,
      FI_EN_DAP_JOB_C_U8_PRIO_HIGHER = 1UL,
      FI_EN_DAP_JOB_C_U8_PRIO_HIGH = 2UL,
      FI_EN_DAP_JOB_C_U8_PRIO_NORMAL = 3UL,
      FI_EN_DAP_JOB_C_U8_PRIO_LOW = 4UL,
      FI_EN_DAP_JOB_C_U8_PRIO_LOWER = 5UL,
      FI_EN_DAP_JOB_C_U8_PRIO_LOWEST = 6UL
   };
   tenType enType;

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual tBool operator==(const fi_tcl_e8_DapPrioritaet& rfoCmp) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   virtual tS32 s32GetTypeId() const { return typesfi_tclToken::EN_E8_DAPPRIORITAET;}
   virtual tVoid vTakeVisitor(fi_tclVisitorBase& rfoVisitor);
};

class fi_tcl_e8_DapOrderType : public fi_tclVisitableTypeBase
{
public:
   fi_tcl_e8_DapOrderType():enType(FI_EN_DEFAULT) {}

   enum tenType {
      FI_EN_DEFAULT = 0UL,
      FI_EN_MAP_FOREGROUND_MAP = 1UL,
      FI_EN_RNW_FOREGROUND_MAP = 2UL,
      FI_EN_MAP_PRELOAD_POS_CHANGE = 3UL,
      FI_EN_RNW_PRELOAD_POS_CHANGE = 4UL,
      FI_EN_RNW_FIRST_ROUTE = 5UL,
      FI_EN_TMC_LOC_TEXT_TRANSLATION = 6UL,
      FI_EN_TMC_LOC_INFO = 7UL,
      FI_EN_RAW_TIMA_CONFIG_EXCEPT_ETX = 8UL,
      FI_EN_RAW_TIMA_CONFIG_ETX = 9UL,
      FI_EN_RAW_FCWDB = 10UL,
      FI_EN_RNW_RDB_LOADER = 11UL,
      FI_EN_RNW_GLOBAL_INFO = 12UL,
      FI_EN_RNW_RCALC_ENRICH_ROUTEDATA = 13UL,
      FI_EN_RNW_PCCOMP_DEMO = 14UL,
      FI_EN_RNW_PCCOMP_HORIZON = 15UL,
      FI_EN_RNW_PCCOMP_LOAD_POS = 16UL,
      FI_EN_RNW_PCCOMP_LOAD_NEIGHBORHOOD = 17UL,
      FI_EN_RAW_PCCOMP_TRIPFILE = 18UL,
      FI_EN_RAW_FOREGROUND_MAP = 19UL,
      FI_EN_RAW_PRELOAD_SCALE_CHANGE = 20UL,
      FI_EN_RNW_MDB_LOAD_AREA_DATA = 21UL,
      FI_EN_RNW_LOAD_GLOBAL_ANNOT = 22UL,
      FI_EN_RNW_MDB_LOAD_CLUSTER = 23UL,
      FI_EN_TMC_EDM_LOC_INFO = 24UL,
      FI_EN_RNW_CID_SEARCH = 25UL,
      FI_EN_LID_LOCATION_INPUT = 26UL,
      FI_EN_LID_CATCHWORDSEARCH = 27UL,
      FI_EN_UAM_ADDRESSBOOK_POI = 28UL,
      FI_EN_POI_USER_POI_IMPORT = 29UL,
      FI_EN_HNS_LOAD_DATA_FOREGROUND = 30UL,
      FI_EN_HNS_LOAD_DATA_BACKGROUND = 31UL,
      FI_EN_META_LOAD_LANG_DESCR = 32UL,
      FI_EN_META_LOAD_FILE_DESCR = 33UL,
      FI_EN_DAP_RNW_LOAD_INIT = 34UL,
      FI_EN_DAP_TMC_LOAD_INIT = 35UL,
      FI_EN_DAP_MAP_LOAD_INIT = 36UL,
      FI_EN_DAP_ARCHIVE_STORAGE = 37UL
   };
   tenType enType;

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual tBool operator==(const fi_tcl_e8_DapOrderType& rfoCmp) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   virtual tS32 s32GetTypeId() const { return typesfi_tclToken::EN_E8_DAPORDERTYPE;}
   virtual tVoid vTakeVisitor(fi_tclVisitorBase& rfoVisitor);
};

class fi_tcl_u32_DapContainerSize : public fi_tclVisitableTypeBase
{
public:
   fi_tcl_u32_DapContainerSize(tU32 _u32Value = 0):u32Value(_u32Value) {} 

   tU32 u32Value;

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual tBool operator==(const fi_tcl_u32_DapContainerSize& rfoCmp) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   virtual tS32 s32GetTypeId() const { return typesfi_tclToken::EN_U32_DAPCONTAINERSIZE;}
   virtual tVoid vTakeVisitor(fi_tclVisitorBase& rfoVisitor);
};

class fi_tcl_DapDataTypeInfo : public fi_tclVisitableTypeBase
{
public:
   fi_tcl_DapDataTypeInfo():szDevice(),szAccessPath(),enDataType(),enDataAvailablility(),u32MediumId(0),u32DatasetId(0),u32DataBaseId(0) {}
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   fi_tcl_DapDataTypeInfo& operator=(const fi_tcl_DapDataTypeInfo& coRef);
   fi_tcl_DapDataTypeInfo(const fi_tcl_DapDataTypeInfo& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
   fi_tclString szDevice;
   fi_tclString szAccessPath;
   fi_tcl_e8_DapDataType enDataType;
   fi_tcl_e8_DapDataAvailable enDataAvailablility;
   tU32 u32MediumId;
   tU32 u32DatasetId;
   tU32 u32DataBaseId;

   virtual tVoid vDestroy();
   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual tBool operator==(const fi_tcl_DapDataTypeInfo& rfoCmp) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   virtual tS32 s32GetTypeId() const { return typesfi_tclToken::EN_DAPDATATYPEINFO;}
   virtual tVoid vTakeVisitor(fi_tclVisitorBase& rfoVisitor);
};

class fi_tcl_u32_DataSpace : public fi_tclVisitableTypeBase
{
public:
   fi_tcl_u32_DataSpace(tU32 _u32Value = 0):u32Value(_u32Value) {} 

   tU32 u32Value;

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual tBool operator==(const fi_tcl_u32_DataSpace& rfoCmp) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   virtual tS32 s32GetTypeId() const { return typesfi_tclToken::EN_U32_DATASPACE;}
   virtual tVoid vTakeVisitor(fi_tclVisitorBase& rfoVisitor);
};

class fi_tcl_DapDataInfo : public fi_tclVisitableTypeBase
{
public:
   fi_tcl_DapDataInfo():enDataType(),enDataAvailable(),u32MediaId(0),u32DatasetId(0),u32DataBaseId(0),szAccessPath() {}
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   fi_tcl_DapDataInfo& operator=(const fi_tcl_DapDataInfo& coRef);
   fi_tcl_DapDataInfo(const fi_tcl_DapDataInfo& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
   fi_tcl_e8_DapDataType enDataType;
   fi_tcl_e8_DapDataAvailable enDataAvailable;
   tU32 u32MediaId;
   tU32 u32DatasetId;
   tU32 u32DataBaseId;
   fi_tclString szAccessPath;

   virtual tVoid vDestroy();
   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual tBool operator==(const fi_tcl_DapDataInfo& rfoCmp) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   virtual tS32 s32GetTypeId() const { return typesfi_tclToken::EN_DAPDATAINFO;}
   virtual tVoid vTakeVisitor(fi_tclVisitorBase& rfoVisitor);
};

class fi_tcl_ClusterStartInfo : public fi_tclVisitableTypeBase
{
public:
   fi_tcl_ClusterStartInfo():oClusterId(),eType() {}
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   fi_tcl_ClusterStartInfo& operator=(const fi_tcl_ClusterStartInfo& coRef);
   fi_tcl_ClusterStartInfo(const fi_tcl_ClusterStartInfo& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
   fi_tcl_NavClusterId oClusterId;
   fi_tcl_b8_StructureType eType;

   virtual tVoid vDestroy();
   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual tBool operator==(const fi_tcl_ClusterStartInfo& rfoCmp) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   virtual tS32 s32GetTypeId() const { return typesfi_tclToken::EN_CLUSTERSTARTINFO;}
   virtual tVoid vTakeVisitor(fi_tclVisitorBase& rfoVisitor);
};

class fi_tcl_LocalOneCellID : public fi_tclVisitableTypeBase
{
public:
   fi_tcl_LocalOneCellID():ClusterIndex(0),OneCellIndex(0) {}
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   fi_tcl_LocalOneCellID& operator=(const fi_tcl_LocalOneCellID& coRef);
   fi_tcl_LocalOneCellID(const fi_tcl_LocalOneCellID& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
   tU16 ClusterIndex;
   tU16 OneCellIndex;

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual tBool operator==(const fi_tcl_LocalOneCellID& rfoCmp) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   virtual tS32 s32GetTypeId() const { return typesfi_tclToken::EN_LOCALONECELLID;}
   virtual tVoid vTakeVisitor(fi_tclVisitorBase& rfoVisitor);
};

class fi_tcl_BBox : public fi_tclVisitableTypeBase
{
public:
   fi_tcl_BBox():LowerLeftPosition(),UpperRigthPosition() {}
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   fi_tcl_BBox& operator=(const fi_tcl_BBox& coRef);
   fi_tcl_BBox(const fi_tcl_BBox& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
   fi_tcl_PositionWGS84 LowerLeftPosition;
   fi_tcl_PositionWGS84 UpperRigthPosition;

   virtual tVoid vDestroy();
   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual tBool operator==(const fi_tcl_BBox& rfoCmp) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   virtual tS32 s32GetTypeId() const { return typesfi_tclToken::EN_BBOX;}
   virtual tVoid vTakeVisitor(fi_tclVisitorBase& rfoVisitor);
};

class fi_tcl_RegProfOutline : public fi_tclVisitableTypeBase
{
public:
   fi_tcl_RegProfOutline():RegionProfileId(0) {}
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   fi_tcl_RegProfOutline& operator=(const fi_tcl_RegProfOutline& coRef);
   fi_tcl_RegProfOutline(const fi_tcl_RegProfOutline& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
   tU16 RegionProfileId;
   std::vector<fi_tcl_PositionWGS84, std::allocator<fi_tcl_PositionWGS84> > Outline;

   virtual tVoid vDestroy();
   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual tBool operator==(const fi_tcl_RegProfOutline& rfoCmp) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   virtual tS32 s32GetTypeId() const { return typesfi_tclToken::EN_REGPROFOUTLINE;}
   virtual tVoid vTakeVisitor(fi_tclVisitorBase& rfoVisitor);
};

class fi_tcl_DapPrefixDesc : public fi_tclVisitableTypeBase
{
public:
   fi_tcl_DapPrefixDesc():Mode(0),Prefix() {}
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   fi_tcl_DapPrefixDesc& operator=(const fi_tcl_DapPrefixDesc& coRef);
   fi_tcl_DapPrefixDesc(const fi_tcl_DapPrefixDesc& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
   tU16 Mode;
   fi_tclString Prefix;

   virtual tVoid vDestroy();
   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual tBool operator==(const fi_tcl_DapPrefixDesc& rfoCmp) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   virtual tS32 s32GetTypeId() const { return typesfi_tclToken::EN_DAPPREFIXDESC;}
   virtual tVoid vTakeVisitor(fi_tclVisitorBase& rfoVisitor);
};

class fi_tcl_DapPrefixState : public fi_tclVisitableTypeBase
{
public:
   fi_tcl_DapPrefixState():CountryCode() {}
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   fi_tcl_DapPrefixState& operator=(const fi_tcl_DapPrefixState& coRef);
   fi_tcl_DapPrefixState(const fi_tcl_DapPrefixState& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
   fi_tcl_e16_ISOCountryCode CountryCode;
   std::vector<fi_tcl_DapPrefixDesc, std::allocator<fi_tcl_DapPrefixDesc> > PrefixDescList;

   virtual tVoid vDestroy();
   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual tBool operator==(const fi_tcl_DapPrefixState& rfoCmp) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   virtual tS32 s32GetTypeId() const { return typesfi_tclToken::EN_DAPPREFIXSTATE;}
   virtual tVoid vTakeVisitor(fi_tclVisitorBase& rfoVisitor);
};

class fi_tcl_e8_TransferType : public fi_tclVisitableTypeBase
{
public:
   fi_tcl_e8_TransferType():enType(FI_EN_INVALID) {}

   enum tenType {
      FI_EN_INVALID = 0UL,
      FI_EN_SM = 1UL,
      FI_EN_FILE = 2UL,
      FI_EN_DEVICE = 3UL
   };
   tenType enType;

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual tBool operator==(const fi_tcl_e8_TransferType& rfoCmp) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   virtual tS32 s32GetTypeId() const { return typesfi_tclToken::EN_E8_TRANSFERTYPE;}
   virtual tVoid vTakeVisitor(fi_tclVisitorBase& rfoVisitor);
};

class fi_tcl_e8_CoordinateCoding : public fi_tclVisitableTypeBase
{
public:
   fi_tcl_e8_CoordinateCoding():enType(FI_EN_ABSOLUTE) {}

   enum tenType {
      FI_EN_ABSOLUTE = 0UL,
      FI_EN_RELBBOXCENTER = 1UL
   };
   tenType enType;

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual tBool operator==(const fi_tcl_e8_CoordinateCoding& rfoCmp) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   virtual tS32 s32GetTypeId() const { return typesfi_tclToken::EN_E8_COORDINATECODING;}
   virtual tVoid vTakeVisitor(fi_tclVisitorBase& rfoVisitor);
};

class fi_tcl_e16_DataType : public fi_tclVisitableTypeBase
{
public:
   fi_tcl_e16_DataType():enType(FI_EN_INVALID) {}

   enum tenType {
      FI_EN_INVALID = 0UL,
      FI_EN_MAP_2D = 1UL,
      FI_EN_DEM = 2UL,
      FI_EN_CITY_MODELS = 3UL,
      FI_EN_LANDMARKS_3D = 4UL,
      FI_EN_DIGITAL_IMAGES = 5UL,
      FI_EN_LANDMARKS = 6UL
   };
   tenType enType;

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual tBool operator==(const fi_tcl_e16_DataType& rfoCmp) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   virtual tS32 s32GetTypeId() const { return typesfi_tclToken::EN_E16_DATATYPE;}
   virtual tVoid vTakeVisitor(fi_tclVisitorBase& rfoVisitor);
};

class fi_tcl_UniqueID : public fi_tclVisitableTypeBase
{
public:
   fi_tcl_UniqueID():FirstElement(0),SecondElement(0) {}
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   fi_tcl_UniqueID& operator=(const fi_tcl_UniqueID& coRef);
   fi_tcl_UniqueID(const fi_tcl_UniqueID& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
   tU32 FirstElement;
   tU32 SecondElement;

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual tBool operator==(const fi_tcl_UniqueID& rfoCmp) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   virtual tS32 s32GetTypeId() const { return typesfi_tclToken::EN_UNIQUEID;}
   virtual tVoid vTakeVisitor(fi_tclVisitorBase& rfoVisitor);
};

class fi_tcl_MapScale : public fi_tclVisitableTypeBase
{
public:
   fi_tcl_MapScale(tU16 _u16Value = 0):u16Value(_u16Value) {} 

   tU16 u16Value;

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual tBool operator==(const fi_tcl_MapScale& rfoCmp) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   virtual tS32 s32GetTypeId() const { return typesfi_tclToken::EN_MAPSCALE;}
   virtual tVoid vTakeVisitor(fi_tclVisitorBase& rfoVisitor);
};

class fi_tcl_BoundingBox : public fi_tclVisitableTypeBase
{
public:
   fi_tcl_BoundingBox():BoundingBoxLowerLeft(),BoundingBoxUpperRight() {}
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   fi_tcl_BoundingBox& operator=(const fi_tcl_BoundingBox& coRef);
   fi_tcl_BoundingBox(const fi_tcl_BoundingBox& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
   fi_tcl_PositionWGS84 BoundingBoxLowerLeft;
   fi_tcl_PositionWGS84 BoundingBoxUpperRight;

   virtual tVoid vDestroy();
   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual tBool operator==(const fi_tcl_BoundingBox& rfoCmp) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   virtual tS32 s32GetTypeId() const { return typesfi_tclToken::EN_BOUNDINGBOX;}
   virtual tVoid vTakeVisitor(fi_tclVisitorBase& rfoVisitor);
};

class fi_tcl_ResultBlocks : public fi_tclVisitableTypeBase
{
public:
   fi_tcl_ResultBlocks():UniqueID(),Offset(0),ErrorCode(0) {}
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   fi_tcl_ResultBlocks& operator=(const fi_tcl_ResultBlocks& coRef);
   fi_tcl_ResultBlocks(const fi_tcl_ResultBlocks& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
   fi_tcl_UniqueID UniqueID;
   tU32 Offset;
   tU32 ErrorCode;

   virtual tVoid vDestroy();
   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual tBool operator==(const fi_tcl_ResultBlocks& rfoCmp) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   virtual tS32 s32GetTypeId() const { return typesfi_tclToken::EN_RESULTBLOCKS;}
   virtual tVoid vTakeVisitor(fi_tclVisitorBase& rfoVisitor);
};

class fi_tcl_e8_RequestType : public fi_tclVisitableTypeBase
{
public:
   fi_tcl_e8_RequestType():enType(FI_EN_INVALID) {}

   enum tenType {
      FI_EN_INVALID = 0UL,
      FI_EN_BREAKDOWN_TO_LEVEL = 1UL,
      FI_EN_BREAKDOWN_USE_BBOX = 2UL
   };
   tenType enType;

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual tBool operator==(const fi_tcl_e8_RequestType& rfoCmp) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   virtual tS32 s32GetTypeId() const { return typesfi_tclToken::EN_E8_REQUESTTYPE;}
   virtual tVoid vTakeVisitor(fi_tclVisitorBase& rfoVisitor);
};

class fi_tcl_e16_OneCellIndex : public fi_tclVisitableTypeBase
{
public:
   fi_tcl_e16_OneCellIndex():enType(FI_EN_ORIGINAL_ROUTE) {}

   enum tenType {
      FI_EN_ORIGINAL_ROUTE = 0UL,
      FI_EN_CONNECTION_ONECELL = 65535UL
   };
   tenType enType;

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual tBool operator==(const fi_tcl_e16_OneCellIndex& rfoCmp) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   virtual tS32 s32GetTypeId() const { return typesfi_tclToken::EN_E16_ONECELLINDEX;}
   virtual tVoid vTakeVisitor(fi_tclVisitorBase& rfoVisitor);
};

class fi_tcl_e8_NavOneCellDirection : public fi_tclVisitableTypeBase
{
public:
   fi_tcl_e8_NavOneCellDirection():enType(FI_EN_NO) {}

   enum tenType {
      FI_EN_NO = 0UL,
      FI_EN_INDIGITIZED = 1UL,
      FI_EN_REVDIGITIZED = 2UL,
      FI_EN_OMNIDIGITIZED = 3UL
   };
   tenType enType;

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual tBool operator==(const fi_tcl_e8_NavOneCellDirection& rfoCmp) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   virtual tS32 s32GetTypeId() const { return typesfi_tclToken::EN_E8_NAVONECELLDIRECTION;}
   virtual tVoid vTakeVisitor(fi_tclVisitorBase& rfoVisitor);
};

class fi_tcl_OneCellRelation : public fi_tclVisitableTypeBase
{
public:
   fi_tcl_OneCellRelation():ParentOneCellIndex(),UseDirection() {}
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   fi_tcl_OneCellRelation& operator=(const fi_tcl_OneCellRelation& coRef);
   fi_tcl_OneCellRelation(const fi_tcl_OneCellRelation& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
   fi_tcl_e16_OneCellIndex ParentOneCellIndex;
   fi_tcl_e8_NavOneCellDirection UseDirection;

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual tBool operator==(const fi_tcl_OneCellRelation& rfoCmp) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   virtual tS32 s32GetTypeId() const { return typesfi_tclToken::EN_ONECELLRELATION;}
   virtual tVoid vTakeVisitor(fi_tclVisitorBase& rfoVisitor);
};

class fi_tcl_e8_Amenity : public fi_tclVisitableTypeBase
{
public:
   fi_tcl_e8_Amenity():enType(FI_EN_RESERVED) {}

   enum tenType {
      FI_EN_RESERVED = 0UL,
      FI_EN_OPEN_24_HOURS = 1UL,
      FI_EN_EMERGENCY_ROAD_SERVICE = 2UL,
      FI_EN_SERVICE_REPAIR = 3UL,
      FI_EN_INTERSTATE_ACCESS = 4UL,
      FI_EN_DISCOUNT = 5UL,
      FI_EN_STORE = 6UL,
      FI_EN_FOOD = 7UL,
      FI_EN_TRUCK_STOP = 8UL,
      FI_EN_STADIUM_SEATING = 9UL
   };
   tenType enType;

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual tBool operator==(const fi_tcl_e8_Amenity& rfoCmp) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   virtual tS32 s32GetTypeId() const { return typesfi_tclToken::EN_E8_AMENITY;}
   virtual tVoid vTakeVisitor(fi_tclVisitorBase& rfoVisitor);
};

class fi_tcl_Amenity : public fi_tclVisitableTypeBase
{
public:
   fi_tcl_Amenity():Amenity() {}
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   fi_tcl_Amenity& operator=(const fi_tcl_Amenity& coRef);
   fi_tcl_Amenity(const fi_tcl_Amenity& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
   fi_tcl_e8_Amenity Amenity;

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual tBool operator==(const fi_tcl_Amenity& rfoCmp) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   virtual tS32 s32GetTypeId() const { return typesfi_tclToken::EN_AMENITY;}
   virtual tVoid vTakeVisitor(fi_tclVisitorBase& rfoVisitor);
};

class fi_tcl_e8_FileType : public fi_tclVisitableTypeBase
{
public:
   fi_tcl_e8_FileType():enType(FI_EN_UNDEFINED) {}

   enum tenType {
      FI_EN_UNDEFINED = 0UL,
      FI_EN_FILE = 1UL,
      FI_EN_DIRECTORY = 2UL
   };
   tenType enType;

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual tBool operator==(const fi_tcl_e8_FileType& rfoCmp) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   virtual tS32 s32GetTypeId() const { return typesfi_tclToken::EN_E8_FILETYPE;}
   virtual tVoid vTakeVisitor(fi_tclVisitorBase& rfoVisitor);
};

class fi_tcl_DapRegionDescrList : public fi_tclVisitableTypeBase
{
public:
   fi_tcl_DapRegionDescrList():u32DatasetId(0) {}
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   fi_tcl_DapRegionDescrList& operator=(const fi_tcl_DapRegionDescrList& coRef);
   fi_tcl_DapRegionDescrList(const fi_tcl_DapRegionDescrList& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
   tU32 u32DatasetId;
   std::vector<fi_tcl_DapRegionDescr, std::allocator<fi_tcl_DapRegionDescr> > oRegionDescList;

   virtual tVoid vDestroy();
   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual tBool operator==(const fi_tcl_DapRegionDescrList& rfoCmp) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   virtual tS32 s32GetTypeId() const { return typesfi_tclToken::EN_DAPREGIONDESCRLIST;}
   virtual tVoid vTakeVisitor(fi_tclVisitorBase& rfoVisitor);
};

class fi_tcl_CatalogueFiles : public fi_tclVisitableTypeBase
{
public:
   fi_tcl_CatalogueFiles():CatalogueFileName(),EventSignature(0),CatalogueFileHandle(0),Contents() {}
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   fi_tcl_CatalogueFiles& operator=(const fi_tcl_CatalogueFiles& coRef);
   fi_tcl_CatalogueFiles(const fi_tcl_CatalogueFiles& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
   fi_tclString CatalogueFileName;
   tU32 EventSignature;
   tU32 CatalogueFileHandle;
   fi_tcl_FileContents Contents;

   virtual tVoid vDestroy();
   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual tBool operator==(const fi_tcl_CatalogueFiles& rfoCmp) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   virtual tS32 s32GetTypeId() const { return typesfi_tclToken::EN_CATALOGUEFILES;}
   virtual tVoid vTakeVisitor(fi_tclVisitorBase& rfoVisitor);
};

class fi_tcl_UTInt : public fi_tclVisitableTypeBase
{
public:
   fi_tcl_UTInt():UTIntValue(0) {}
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   fi_tcl_UTInt& operator=(const fi_tcl_UTInt& coRef);
   fi_tcl_UTInt(const fi_tcl_UTInt& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
   tS32 UTIntValue;

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual tBool operator==(const fi_tcl_UTInt& rfoCmp) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   virtual tS32 s32GetTypeId() const { return typesfi_tclToken::EN_UTINT;}
   virtual tVoid vTakeVisitor(fi_tclVisitorBase& rfoVisitor);
};

class fi_tcl_UTBool : public fi_tclVisitableTypeBase
{
public:
   fi_tcl_UTBool():UTBoolValue(0) {}
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   fi_tcl_UTBool& operator=(const fi_tcl_UTBool& coRef);
   fi_tcl_UTBool(const fi_tcl_UTBool& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
   tBool UTBoolValue;

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual tBool operator==(const fi_tcl_UTBool& rfoCmp) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   virtual tS32 s32GetTypeId() const { return typesfi_tclToken::EN_UTBOOL;}
   virtual tVoid vTakeVisitor(fi_tclVisitorBase& rfoVisitor);
};

class fi_tcl_UTString : public fi_tclVisitableTypeBase
{
public:
   fi_tcl_UTString():StringValue() {}
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   fi_tcl_UTString& operator=(const fi_tcl_UTString& coRef);
   fi_tcl_UTString(const fi_tcl_UTString& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
   fi_tclString StringValue;

   virtual tVoid vDestroy();
   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual tBool operator==(const fi_tcl_UTString& rfoCmp) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   virtual tS32 s32GetTypeId() const { return typesfi_tclToken::EN_UTSTRING;}
   virtual tVoid vTakeVisitor(fi_tclVisitorBase& rfoVisitor);
};

class fi_tcl_OrderInfo : public fi_tclVisitableTypeBase
{
public:
   fi_tcl_OrderInfo():RegionInfo(),StoreStatus() {}
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   fi_tcl_OrderInfo& operator=(const fi_tcl_OrderInfo& coRef);
   fi_tcl_OrderInfo(const fi_tcl_OrderInfo& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
   fi_tcl_RegionInfo RegionInfo;
   fi_tcl_e8_StoreStatus StoreStatus;

   virtual tVoid vDestroy();
   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual tBool operator==(const fi_tcl_OrderInfo& rfoCmp) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   virtual tS32 s32GetTypeId() const { return typesfi_tclToken::EN_ORDERINFO;}
   virtual tVoid vTakeVisitor(fi_tclVisitorBase& rfoVisitor);
};

class fi_tcl_BinContainer : public fi_tclVisitableTypeBase
{
public:
   fi_tcl_BinContainer() {}
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   fi_tcl_BinContainer& operator=(const fi_tcl_BinContainer& coRef);
   fi_tcl_BinContainer(const fi_tcl_BinContainer& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
   std::vector<tU8, std::allocator<tU8> > ContainerDataList;

   virtual tVoid vDestroy();
   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual tBool operator==(const fi_tcl_BinContainer& rfoCmp) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   virtual tS32 s32GetTypeId() const { return typesfi_tclToken::EN_BINCONTAINER;}
   virtual tVoid vTakeVisitor(fi_tclVisitorBase& rfoVisitor);
};

class fi_tcl_Reserved : public fi_tclVisitableTypeBase
{
public:
   fi_tcl_Reserved() {}
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   fi_tcl_Reserved& operator=(const fi_tcl_Reserved& coRef);
   fi_tcl_Reserved(const fi_tcl_Reserved& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual tBool operator==(const fi_tcl_Reserved& rfoCmp) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   virtual tS32 s32GetTypeId() const { return typesfi_tclToken::EN_RESERVED;}
   virtual tVoid vTakeVisitor(fi_tclVisitorBase& rfoVisitor);
};

class fi_tcl_u8_Percent : public fi_tclVisitableTypeBase
{
public:
   fi_tcl_u8_Percent(tU8 _u8Value = 0):u8Value(_u8Value) {} 

   tU8 u8Value;

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual tBool operator==(const fi_tcl_u8_Percent& rfoCmp) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   virtual tS32 s32GetTypeId() const { return typesfi_tclToken::EN_U8_PERCENT;}
   virtual tVoid vTakeVisitor(fi_tclVisitorBase& rfoVisitor);
};

class fi_tcl_s16_PerThousand : public fi_tclVisitableTypeBase
{
public:
   fi_tcl_s16_PerThousand(tS16 _s16Value = 0):s16Value(_s16Value) {} 

   tS16 s16Value;

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual tBool operator==(const fi_tcl_s16_PerThousand& rfoCmp) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   virtual tS32 s32GetTypeId() const { return typesfi_tclToken::EN_S16_PERTHOUSAND;}
   virtual tVoid vTakeVisitor(fi_tclVisitorBase& rfoVisitor);
};

class fi_tcl_u16_IndexInReferenceList : public fi_tclVisitableTypeBase
{
public:
   fi_tcl_u16_IndexInReferenceList(tU16 _u16Value = 0):u16Value(_u16Value) {} 

   tU16 u16Value;

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual tBool operator==(const fi_tcl_u16_IndexInReferenceList& rfoCmp) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   virtual tS32 s32GetTypeId() const { return typesfi_tclToken::EN_U16_INDEXINREFERENCELIST;}
   virtual tVoid vTakeVisitor(fi_tclVisitorBase& rfoVisitor);
};

class fi_tcl_u16_ErrorCode : public fi_tclVisitableTypeBase
{
public:
   fi_tcl_u16_ErrorCode(tU16 _u16Value = 0):u16Value(_u16Value) {} 

   tU16 u16Value;

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual tBool operator==(const fi_tcl_u16_ErrorCode& rfoCmp) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   virtual tS32 s32GetTypeId() const { return typesfi_tclToken::EN_U16_ERRORCODE;}
   virtual tVoid vTakeVisitor(fi_tclVisitorBase& rfoVisitor);
};

class fi_tcl_u16_RPM : public fi_tclVisitableTypeBase
{
public:
   fi_tcl_u16_RPM(tU16 _u16Value = 0):u16Value(_u16Value) {} 

   tU16 u16Value;

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual tBool operator==(const fi_tcl_u16_RPM& rfoCmp) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   virtual tS32 s32GetTypeId() const { return typesfi_tclToken::EN_U16_RPM;}
   virtual tVoid vTakeVisitor(fi_tclVisitorBase& rfoVisitor);
};

class fi_tcl_s32_Kilogram : public fi_tclVisitableTypeBase
{
public:
   fi_tcl_s32_Kilogram(tS32 _s32Value = 0):s32Value(_s32Value) {} 

   tS32 s32Value;

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual tBool operator==(const fi_tcl_s32_Kilogram& rfoCmp) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   virtual tS32 s32GetTypeId() const { return typesfi_tclToken::EN_S32_KILOGRAM;}
   virtual tVoid vTakeVisitor(fi_tclVisitorBase& rfoVisitor);
};

class fi_tcl_s32_Pound : public fi_tclVisitableTypeBase
{
public:
   fi_tcl_s32_Pound(tS32 _s32Value = 0):s32Value(_s32Value) {} 

   tS32 s32Value;

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual tBool operator==(const fi_tcl_s32_Pound& rfoCmp) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   virtual tS32 s32GetTypeId() const { return typesfi_tclToken::EN_S32_POUND;}
   virtual tVoid vTakeVisitor(fi_tclVisitorBase& rfoVisitor);
};

class fi_tcl_s16_Meter : public fi_tclVisitableTypeBase
{
public:
   fi_tcl_s16_Meter(tS16 _s16Value = 0):s16Value(_s16Value) {} 

   tS16 s16Value;

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual tBool operator==(const fi_tcl_s16_Meter& rfoCmp) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   virtual tS32 s32GetTypeId() const { return typesfi_tclToken::EN_S16_METER;}
   virtual tVoid vTakeVisitor(fi_tclVisitorBase& rfoVisitor);
};

class fi_tcl_s32_Meter : public fi_tclVisitableTypeBase
{
public:
   fi_tcl_s32_Meter(tS32 _s32Value = 0):s32Value(_s32Value) {} 

   tS32 s32Value;

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual tBool operator==(const fi_tcl_s32_Meter& rfoCmp) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   virtual tS32 s32GetTypeId() const { return typesfi_tclToken::EN_S32_METER;}
   virtual tVoid vTakeVisitor(fi_tclVisitorBase& rfoVisitor);
};

class fi_tcl_s32_Yards : public fi_tclVisitableTypeBase
{
public:
   fi_tcl_s32_Yards(tS32 _s32Value = 0):s32Value(_s32Value) {} 

   tS32 s32Value;

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual tBool operator==(const fi_tcl_s32_Yards& rfoCmp) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   virtual tS32 s32GetTypeId() const { return typesfi_tclToken::EN_S32_YARDS;}
   virtual tVoid vTakeVisitor(fi_tclVisitorBase& rfoVisitor);
};

class fi_tcl_s32_Foot : public fi_tclVisitableTypeBase
{
public:
   fi_tcl_s32_Foot(tS32 _s32Value = 0):s32Value(_s32Value) {} 

   tS32 s32Value;

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual tBool operator==(const fi_tcl_s32_Foot& rfoCmp) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   virtual tS32 s32GetTypeId() const { return typesfi_tclToken::EN_S32_FOOT;}
   virtual tVoid vTakeVisitor(fi_tclVisitorBase& rfoVisitor);
};

class fi_tcl_s32_Centimeter : public fi_tclVisitableTypeBase
{
public:
   fi_tcl_s32_Centimeter(tS32 _s32Value = 0):s32Value(_s32Value) {} 

   tS32 s32Value;

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual tBool operator==(const fi_tcl_s32_Centimeter& rfoCmp) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   virtual tS32 s32GetTypeId() const { return typesfi_tclToken::EN_S32_CENTIMETER;}
   virtual tVoid vTakeVisitor(fi_tclVisitorBase& rfoVisitor);
};

class fi_tcl_s32_Inch : public fi_tclVisitableTypeBase
{
public:
   fi_tcl_s32_Inch(tS32 _s32Value = 0):s32Value(_s32Value) {} 

   tS32 s32Value;

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual tBool operator==(const fi_tcl_s32_Inch& rfoCmp) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   virtual tS32 s32GetTypeId() const { return typesfi_tclToken::EN_S32_INCH;}
   virtual tVoid vTakeVisitor(fi_tclVisitorBase& rfoVisitor);
};

class fi_tcl_s32_Millimeter : public fi_tclVisitableTypeBase
{
public:
   fi_tcl_s32_Millimeter(tS32 _s32Value = 0):s32Value(_s32Value) {} 

   tS32 s32Value;

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual tBool operator==(const fi_tcl_s32_Millimeter& rfoCmp) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   virtual tS32 s32GetTypeId() const { return typesfi_tclToken::EN_S32_MILLIMETER;}
   virtual tVoid vTakeVisitor(fi_tclVisitorBase& rfoVisitor);
};

class fi_tcl_s32_Microliter : public fi_tclVisitableTypeBase
{
public:
   fi_tcl_s32_Microliter(tS32 _s32Value = 0):s32Value(_s32Value) {} 

   tS32 s32Value;

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual tBool operator==(const fi_tcl_s32_Microliter& rfoCmp) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   virtual tS32 s32GetTypeId() const { return typesfi_tclToken::EN_S32_MICROLITER;}
   virtual tVoid vTakeVisitor(fi_tclVisitorBase& rfoVisitor);
};

class fi_tcl_s32_Second : public fi_tclVisitableTypeBase
{
public:
   fi_tcl_s32_Second(tS32 _s32Value = 0):s32Value(_s32Value) {} 

   tS32 s32Value;

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual tBool operator==(const fi_tcl_s32_Second& rfoCmp) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   virtual tS32 s32GetTypeId() const { return typesfi_tclToken::EN_S32_SECOND;}
   virtual tVoid vTakeVisitor(fi_tclVisitorBase& rfoVisitor);
};

class fi_tcl_u16_MilliSecond : public fi_tclVisitableTypeBase
{
public:
   fi_tcl_u16_MilliSecond(tU16 _u16Value = 0):u16Value(_u16Value) {} 

   tU16 u16Value;

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual tBool operator==(const fi_tcl_u16_MilliSecond& rfoCmp) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   virtual tS32 s32GetTypeId() const { return typesfi_tclToken::EN_U16_MILLISECOND;}
   virtual tVoid vTakeVisitor(fi_tclVisitorBase& rfoVisitor);
};

class fi_tcl_s32_MilliSecond : public fi_tclVisitableTypeBase
{
public:
   fi_tcl_s32_MilliSecond(tS32 _s32Value = 0):s32Value(_s32Value) {} 

   tS32 s32Value;

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual tBool operator==(const fi_tcl_s32_MilliSecond& rfoCmp) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   virtual tS32 s32GetTypeId() const { return typesfi_tclToken::EN_S32_MILLISECOND;}
   virtual tVoid vTakeVisitor(fi_tclVisitorBase& rfoVisitor);
};

class fi_tcl_POSIXTime : public fi_tclVisitableTypeBase
{
public:
   fi_tcl_POSIXTime():Time(0) {}
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   fi_tcl_POSIXTime& operator=(const fi_tcl_POSIXTime& coRef);
   fi_tcl_POSIXTime(const fi_tcl_POSIXTime& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
   tS32 Time;

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual tBool operator==(const fi_tcl_POSIXTime& rfoCmp) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   virtual tS32 s32GetTypeId() const { return typesfi_tclToken::EN_POSIXTIME;}
   virtual tVoid vTakeVisitor(fi_tclVisitorBase& rfoVisitor);
};

class fi_tcl_e8_DST_State : public fi_tclVisitableTypeBase
{
public:
   fi_tcl_e8_DST_State():enType(FI_EN_T_STANDARDTIME) {}

   enum tenType {
      FI_EN_T_STANDARDTIME = 0UL,
      FI_EN_T_DAYLIGHTSAVINGTIME = 1UL,
      FI_EN_T_EVALUATIONNECESSARY = 2UL
   };
   tenType enType;

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual tBool operator==(const fi_tcl_e8_DST_State& rfoCmp) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   virtual tS32 s32GetTypeId() const { return typesfi_tclToken::EN_E8_DST_STATE;}
   virtual tVoid vTakeVisitor(fi_tclVisitorBase& rfoVisitor);
};

class fi_tcl_TimeZoneElement : public fi_tclVisitableTypeBase
{
public:
   fi_tcl_TimeZoneElement():Abbreviation_StandardTime(0),Abbreviation_DST_in_effect(0),TimeZoneDifference(),DST_State(),DSTDifference() {}
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   fi_tcl_TimeZoneElement& operator=(const fi_tcl_TimeZoneElement& coRef);
   fi_tcl_TimeZoneElement(const fi_tcl_TimeZoneElement& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
   fi_tclMultiLanguageString Abbreviation_StandardTime;
   fi_tclMultiLanguageString Abbreviation_DST_in_effect;
   fi_tcl_s32_Second TimeZoneDifference;
   fi_tcl_e8_DST_State DST_State;
   fi_tcl_s32_Second DSTDifference;
   std::vector<tU8, std::allocator<tU8> > DST_TimeDomain;

   virtual tVoid vDestroy();
   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual tBool operator==(const fi_tcl_TimeZoneElement& rfoCmp) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   virtual tS32 s32GetTypeId() const { return typesfi_tclToken::EN_TIMEZONEELEMENT;}
   virtual tVoid vTakeVisitor(fi_tclVisitorBase& rfoVisitor);
};

class fi_tcl_s16_KmPerHour : public fi_tclVisitableTypeBase
{
public:
   fi_tcl_s16_KmPerHour(tS16 _s16Value = 0):s16Value(_s16Value) {} 

   tS16 s16Value;

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual tBool operator==(const fi_tcl_s16_KmPerHour& rfoCmp) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   virtual tS32 s32GetTypeId() const { return typesfi_tclToken::EN_S16_KMPERHOUR;}
   virtual tVoid vTakeVisitor(fi_tclVisitorBase& rfoVisitor);
};

class fi_tcl_s16_MilesPerHour : public fi_tclVisitableTypeBase
{
public:
   fi_tcl_s16_MilesPerHour(tS16 _s16Value = 0):s16Value(_s16Value) {} 

   tS16 s16Value;

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual tBool operator==(const fi_tcl_s16_MilesPerHour& rfoCmp) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   virtual tS32 s32GetTypeId() const { return typesfi_tclToken::EN_S16_MILESPERHOUR;}
   virtual tVoid vTakeVisitor(fi_tclVisitorBase& rfoVisitor);
};

class fi_tcl_s16_Knot : public fi_tclVisitableTypeBase
{
public:
   fi_tcl_s16_Knot(tS16 _s16Value = 0):s16Value(_s16Value) {} 

   tS16 s16Value;

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual tBool operator==(const fi_tcl_s16_Knot& rfoCmp) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   virtual tS32 s32GetTypeId() const { return typesfi_tclToken::EN_S16_KNOT;}
   virtual tVoid vTakeVisitor(fi_tclVisitorBase& rfoVisitor);
};

class fi_tcl_s16_CentimeterSecond : public fi_tclVisitableTypeBase
{
public:
   fi_tcl_s16_CentimeterSecond(tS16 _s16Value = 0):s16Value(_s16Value) {} 

   tS16 s16Value;

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual tBool operator==(const fi_tcl_s16_CentimeterSecond& rfoCmp) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   virtual tS32 s32GetTypeId() const { return typesfi_tclToken::EN_S16_CENTIMETERSECOND;}
   virtual tVoid vTakeVisitor(fi_tclVisitorBase& rfoVisitor);
};

class fi_tcl_s16_Kelvin : public fi_tclVisitableTypeBase
{
public:
   fi_tcl_s16_Kelvin(tS16 _s16Value = 0):s16Value(_s16Value) {} 

   tS16 s16Value;

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual tBool operator==(const fi_tcl_s16_Kelvin& rfoCmp) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   virtual tS32 s32GetTypeId() const { return typesfi_tclToken::EN_S16_KELVIN;}
   virtual tVoid vTakeVisitor(fi_tclVisitorBase& rfoVisitor);
};

class fi_tcl_s16_Fahrenheit : public fi_tclVisitableTypeBase
{
public:
   fi_tcl_s16_Fahrenheit(tS16 _s16Value = 0):s16Value(_s16Value) {} 

   tS16 s16Value;

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual tBool operator==(const fi_tcl_s16_Fahrenheit& rfoCmp) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   virtual tS32 s32GetTypeId() const { return typesfi_tclToken::EN_S16_FAHRENHEIT;}
   virtual tVoid vTakeVisitor(fi_tclVisitorBase& rfoVisitor);
};

class fi_tcl_s32_Pascal : public fi_tclVisitableTypeBase
{
public:
   fi_tcl_s32_Pascal(tS32 _s32Value = 0):s32Value(_s32Value) {} 

   tS32 s32Value;

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual tBool operator==(const fi_tcl_s32_Pascal& rfoCmp) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   virtual tS32 s32GetTypeId() const { return typesfi_tclToken::EN_S32_PASCAL;}
   virtual tVoid vTakeVisitor(fi_tclVisitorBase& rfoVisitor);
};

class fi_tcl_s32_Watt : public fi_tclVisitableTypeBase
{
public:
   fi_tcl_s32_Watt(tS32 _s32Value = 0):s32Value(_s32Value) {} 

   tS32 s32Value;

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual tBool operator==(const fi_tcl_s32_Watt& rfoCmp) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   virtual tS32 s32GetTypeId() const { return typesfi_tclToken::EN_S32_WATT;}
   virtual tVoid vTakeVisitor(fi_tclVisitorBase& rfoVisitor);
};

class fi_tcl_FIVersion : public fi_tclVisitableTypeBase
{
public:
   fi_tcl_FIVersion():MajorVersion(0),MinorVersion(0),PatchVersion(0) {}
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   fi_tcl_FIVersion& operator=(const fi_tcl_FIVersion& coRef);
   fi_tcl_FIVersion(const fi_tcl_FIVersion& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
   tU8 MajorVersion;
   tU8 MinorVersion;
   tU8 PatchVersion;

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual tBool operator==(const fi_tcl_FIVersion& rfoCmp) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   virtual tS32 s32GetTypeId() const { return typesfi_tclToken::EN_FIVERSION;}
   virtual tVoid vTakeVisitor(fi_tclVisitorBase& rfoVisitor);
};

class fi_tcl_UserPOIElement : public fi_tclVisitableTypeBase
{
public:
   fi_tcl_UserPOIElement():UniqueID(0),Category(0),Position(),Name(),Description() {}
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   fi_tcl_UserPOIElement& operator=(const fi_tcl_UserPOIElement& coRef);
   fi_tcl_UserPOIElement(const fi_tcl_UserPOIElement& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
   tU32 UniqueID;
   tU32 Category;
   fi_tcl_PositionWGS84 Position;
   fi_tclString Name;
   fi_tclString Description;

   virtual tVoid vDestroy();
   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual tBool operator==(const fi_tcl_UserPOIElement& rfoCmp) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   virtual tS32 s32GetTypeId() const { return typesfi_tclToken::EN_USERPOIELEMENT;}
   virtual tVoid vTakeVisitor(fi_tclVisitorBase& rfoVisitor);
};

class fi_tcl_LocTableDesc : public fi_tclVisitableTypeBase
{
public:
   fi_tcl_LocTableDesc():oLocTableIdent(),u16TableVersion(0),u16IsoCountryCode(0),u8DefaultLanguageId(0),oOutline() {}
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   fi_tcl_LocTableDesc& operator=(const fi_tcl_LocTableDesc& coRef);
   fi_tcl_LocTableDesc(const fi_tcl_LocTableDesc& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
   fi_tcl_LocTableIdent oLocTableIdent;
   tU16 u16TableVersion;
   tU16 u16IsoCountryCode;
   tU8 u8DefaultLanguageId;
   std::vector<tU16, std::allocator<tU16> > FeatureAvailList;
   fi_tcl_Outline oOutline;

   virtual tVoid vDestroy();
   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual tBool operator==(const fi_tcl_LocTableDesc& rfoCmp) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   virtual tS32 s32GetTypeId() const { return typesfi_tclToken::EN_LOCTABLEDESC;}
   virtual tVoid vTakeVisitor(fi_tclVisitorBase& rfoVisitor);
};

class fi_tcl_b16_ElementProperties : public fi_tclVisitableTypeBase
{
public:
   fi_tcl_b16_ElementProperties():u16Value(0) {}

   enum {
      FI_C_U16_BIT_VALIDDESTINATION = 0x1UL,
      FI_C_U16_BIT_VALIDPOSITION = 0x2UL,
      FI_C_U16_BIT_VALIDFORMAPDISPLAY = 0x4UL,
      FI_C_U16_BIT_DETAILAVAILABLE = 0x8UL,
      FI_C_U16_BIT_ALTERNATIVENAME = 0x10UL,
      FI_C_U16_BIT_AMBIGUOUS = 0x20UL,
      FI_C_U16_BIT_CONTAINESXMLDESCRIPTION = 0x40UL,
      FI_C_U16_BIT_ISTRAVELGUIDEDATASET = 0x80UL,
      FI_C_U16_BIT_ISBASENAME = 0x100UL,
      FI_C_U16_BIT_ISUSERPOIDATASET = 0x200UL
   };
   tBool bValidDestination() const {return (u16Value & FI_C_U16_BIT_VALIDDESTINATION) != 0; }
   tVoid vSetValidDestination(tBool bSetBit) { u16Value = (bSetBit)?(u16Value | FI_C_U16_BIT_VALIDDESTINATION):(u16Value & ~FI_C_U16_BIT_VALIDDESTINATION); }
   tBool bValidPosition() const {return (u16Value & FI_C_U16_BIT_VALIDPOSITION) != 0; }
   tVoid vSetValidPosition(tBool bSetBit) { u16Value = (bSetBit)?(u16Value | FI_C_U16_BIT_VALIDPOSITION):(u16Value & ~FI_C_U16_BIT_VALIDPOSITION); }
   tBool bValidForMapDisplay() const {return (u16Value & FI_C_U16_BIT_VALIDFORMAPDISPLAY) != 0; }
   tVoid vSetValidForMapDisplay(tBool bSetBit) { u16Value = (bSetBit)?(u16Value | FI_C_U16_BIT_VALIDFORMAPDISPLAY):(u16Value & ~FI_C_U16_BIT_VALIDFORMAPDISPLAY); }
   tBool bDetailAvailable() const {return (u16Value & FI_C_U16_BIT_DETAILAVAILABLE) != 0; }
   tVoid vSetDetailAvailable(tBool bSetBit) { u16Value = (bSetBit)?(u16Value | FI_C_U16_BIT_DETAILAVAILABLE):(u16Value & ~FI_C_U16_BIT_DETAILAVAILABLE); }
   tBool bAlternativeName() const {return (u16Value & FI_C_U16_BIT_ALTERNATIVENAME) != 0; }
   tVoid vSetAlternativeName(tBool bSetBit) { u16Value = (bSetBit)?(u16Value | FI_C_U16_BIT_ALTERNATIVENAME):(u16Value & ~FI_C_U16_BIT_ALTERNATIVENAME); }
   tBool bAmbiguous() const {return (u16Value & FI_C_U16_BIT_AMBIGUOUS) != 0; }
   tVoid vSetAmbiguous(tBool bSetBit) { u16Value = (bSetBit)?(u16Value | FI_C_U16_BIT_AMBIGUOUS):(u16Value & ~FI_C_U16_BIT_AMBIGUOUS); }
   tBool bContainesXMLDescription() const {return (u16Value & FI_C_U16_BIT_CONTAINESXMLDESCRIPTION) != 0; }
   tVoid vSetContainesXMLDescription(tBool bSetBit) { u16Value = (bSetBit)?(u16Value | FI_C_U16_BIT_CONTAINESXMLDESCRIPTION):(u16Value & ~FI_C_U16_BIT_CONTAINESXMLDESCRIPTION); }
   tBool bIsTravelGuideDataSet() const {return (u16Value & FI_C_U16_BIT_ISTRAVELGUIDEDATASET) != 0; }
   tVoid vSetIsTravelGuideDataSet(tBool bSetBit) { u16Value = (bSetBit)?(u16Value | FI_C_U16_BIT_ISTRAVELGUIDEDATASET):(u16Value & ~FI_C_U16_BIT_ISTRAVELGUIDEDATASET); }
   tBool bIsBaseName() const {return (u16Value & FI_C_U16_BIT_ISBASENAME) != 0; }
   tVoid vSetIsBaseName(tBool bSetBit) { u16Value = (bSetBit)?(u16Value | FI_C_U16_BIT_ISBASENAME):(u16Value & ~FI_C_U16_BIT_ISBASENAME); }
   tBool bIsUserPOIDataSet() const {return (u16Value & FI_C_U16_BIT_ISUSERPOIDATASET) != 0; }
   tVoid vSetIsUserPOIDataSet(tBool bSetBit) { u16Value = (bSetBit)?(u16Value | FI_C_U16_BIT_ISUSERPOIDATASET):(u16Value & ~FI_C_U16_BIT_ISUSERPOIDATASET); }
   struct rBitValues {
      unsigned int ValidDestination:1;
      unsigned int ValidPosition:1;
      unsigned int ValidForMapDisplay:1;
      unsigned int DetailAvailable:1;
      unsigned int AlternativeName:1;
      unsigned int Ambiguous:1;
      unsigned int ContainesXMLDescription:1;
      unsigned int IsTravelGuideDataSet:1;
      unsigned int IsBaseName:1;
      unsigned int IsUserPOIDataSet:1;
      unsigned int dummy10:1;
      unsigned int dummy11:1;
      unsigned int dummy12:1;
      unsigned int dummy13:1;
      unsigned int dummy14:1;
      unsigned int dummy15:1;
   };
   union {
      tU16 u16Value;
      rBitValues bits;
   };

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual tBool operator==(const fi_tcl_b16_ElementProperties& rfoCmp) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   virtual tS32 s32GetTypeId() const { return typesfi_tclToken::EN_B16_ELEMENTPROPERTIES;}
   virtual tVoid vTakeVisitor(fi_tclVisitorBase& rfoVisitor);
};

class fi_tcl_RectangleWGS84 : public fi_tclVisitableTypeBase
{
public:
   fi_tcl_RectangleWGS84():LongitudeMin(),LatitudeMin(),LongitudeMax(),LatitudeMax() {}
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   fi_tcl_RectangleWGS84& operator=(const fi_tcl_RectangleWGS84& coRef);
   fi_tcl_RectangleWGS84(const fi_tcl_RectangleWGS84& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
   fi_tcl_s32_Longitude LongitudeMin;
   fi_tcl_s32_Latitude LatitudeMin;
   fi_tcl_s32_Longitude LongitudeMax;
   fi_tcl_s32_Latitude LatitudeMax;

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual tBool operator==(const fi_tcl_RectangleWGS84& rfoCmp) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   virtual tS32 s32GetTypeId() const { return typesfi_tclToken::EN_RECTANGLEWGS84;}
   virtual tVoid vTakeVisitor(fi_tclVisitorBase& rfoVisitor);
};

class fi_tcl_LanguageDependentType : public fi_tclVisitableTypeBase
{
public:
   fi_tcl_LanguageDependentType():oLanguageCode(),oCountryCode(),pcType() {}
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   fi_tcl_LanguageDependentType& operator=(const fi_tcl_LanguageDependentType& coRef);
   fi_tcl_LanguageDependentType(const fi_tcl_LanguageDependentType& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
   fi_tcl_e16_ISOLanguageCode oLanguageCode;
   fi_tcl_e16_ISOCountryCode oCountryCode;
   fi_tclString pcType;

   virtual tVoid vDestroy();
   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual tBool operator==(const fi_tcl_LanguageDependentType& rfoCmp) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   virtual tS32 s32GetTypeId() const { return typesfi_tclToken::EN_LANGUAGEDEPENDENTTYPE;}
   virtual tVoid vTakeVisitor(fi_tclVisitorBase& rfoVisitor);
};

class fi_tcl_LanguageIdElem : public fi_tclVisitableTypeBase
{
public:
   fi_tcl_LanguageIdElem():oLocTableIdent(),oCountry(),oLanguage(),u8LanguageId(0),bDefaultLanguage(0) {}
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   fi_tcl_LanguageIdElem& operator=(const fi_tcl_LanguageIdElem& coRef);
   fi_tcl_LanguageIdElem(const fi_tcl_LanguageIdElem& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
   fi_tcl_LocTableIdent oLocTableIdent;
   fi_tcl_e16_ISOCountryCode oCountry;
   fi_tcl_e16_ISOLanguageCode oLanguage;
   tU8 u8LanguageId;
   tBool bDefaultLanguage;

   virtual tVoid vDestroy();
   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual tBool operator==(const fi_tcl_LanguageIdElem& rfoCmp) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   virtual tS32 s32GetTypeId() const { return typesfi_tclToken::EN_LANGUAGEIDELEM;}
   virtual tVoid vTakeVisitor(fi_tclVisitorBase& rfoVisitor);
};

class fi_tcl_LanguageID : public fi_tclVisitableTypeBase
{
public:
   fi_tcl_LanguageID():ISO639_LanguageCode(),ISO3166_CountryCode() {}
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   fi_tcl_LanguageID& operator=(const fi_tcl_LanguageID& coRef);
   fi_tcl_LanguageID(const fi_tcl_LanguageID& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
   fi_tcl_e16_ISOLanguageCode ISO639_LanguageCode;
   fi_tcl_e16_ISOCountryCode ISO3166_CountryCode;

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual tBool operator==(const fi_tcl_LanguageID& rfoCmp) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   virtual tS32 s32GetTypeId() const { return typesfi_tclToken::EN_LANGUAGEID;}
   virtual tVoid vTakeVisitor(fi_tclVisitorBase& rfoVisitor);
};

class fi_tcl_u8_DirectionAbsolute : public fi_tclVisitableTypeBase
{
public:
   fi_tcl_u8_DirectionAbsolute(tU8 _u8Value = 0):u8Value(_u8Value) {} 

   tU8 u8Value;

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual tBool operator==(const fi_tcl_u8_DirectionAbsolute& rfoCmp) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   virtual tS32 s32GetTypeId() const { return typesfi_tclToken::EN_U8_DIRECTIONABSOLUTE;}
   virtual tVoid vTakeVisitor(fi_tclVisitorBase& rfoVisitor);
};

class fi_tcl_u8_DirectionRelative : public fi_tclVisitableTypeBase
{
public:
   fi_tcl_u8_DirectionRelative(tU8 _u8Value = 0):u8Value(_u8Value) {} 

   tU8 u8Value;

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual tBool operator==(const fi_tcl_u8_DirectionRelative& rfoCmp) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   virtual tS32 s32GetTypeId() const { return typesfi_tclToken::EN_U8_DIRECTIONRELATIVE;}
   virtual tVoid vTakeVisitor(fi_tclVisitorBase& rfoVisitor);
};

class fi_tcl_s16_CentiDegree : public fi_tclVisitableTypeBase
{
public:
   fi_tcl_s16_CentiDegree(tS16 _s16Value = 0):s16Value(_s16Value) {} 

   tS16 s16Value;

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual tBool operator==(const fi_tcl_s16_CentiDegree& rfoCmp) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   virtual tS32 s32GetTypeId() const { return typesfi_tclToken::EN_S16_CENTIDEGREE;}
   virtual tVoid vTakeVisitor(fi_tclVisitorBase& rfoVisitor);
};

class fi_tcl_s16_Degree : public fi_tclVisitableTypeBase
{
public:
   fi_tcl_s16_Degree(tS16 _s16Value = 0):s16Value(_s16Value) {} 

   tS16 s16Value;

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual tBool operator==(const fi_tcl_s16_Degree& rfoCmp) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   virtual tS32 s32GetTypeId() const { return typesfi_tclToken::EN_S16_DEGREE;}
   virtual tVoid vTakeVisitor(fi_tclVisitorBase& rfoVisitor);
};

class fi_tcl_u16_DirectionAbsolute_CentiDegree : public fi_tclVisitableTypeBase
{
public:
   fi_tcl_u16_DirectionAbsolute_CentiDegree(tU16 _u16Value = 0):u16Value(_u16Value) {} 

   tU16 u16Value;

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual tBool operator==(const fi_tcl_u16_DirectionAbsolute_CentiDegree& rfoCmp) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   virtual tS32 s32GetTypeId() const { return typesfi_tclToken::EN_U16_DIRECTIONABSOLUTE_CENTIDEGREE;}
   virtual tVoid vTakeVisitor(fi_tclVisitorBase& rfoVisitor);
};

class fi_tcl_s16_DirectionRelative_CentiDegree : public fi_tclVisitableTypeBase
{
public:
   fi_tcl_s16_DirectionRelative_CentiDegree(tS16 _s16Value = 0):s16Value(_s16Value) {} 

   tS16 s16Value;

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual tBool operator==(const fi_tcl_s16_DirectionRelative_CentiDegree& rfoCmp) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   virtual tS32 s32GetTypeId() const { return typesfi_tclToken::EN_S16_DIRECTIONRELATIVE_CENTIDEGREE;}
   virtual tVoid vTakeVisitor(fi_tclVisitorBase& rfoVisitor);
};

class fi_tcl_e8_FuelType : public fi_tclVisitableTypeBase
{
public:
   fi_tcl_e8_FuelType():enType(FI_EN_RESERVED) {}

   enum tenType {
      FI_EN_RESERVED = 0UL,
      FI_EN_PETROL = 1UL,
      FI_EN_DIESEL = 2UL,
      FI_EN_HYDROGEN = 3UL,
      FI_EN_COMPRESSEDNATURALGAS = 4UL,
      FI_EN_LIQUIFIEDPETROLEUMGAS = 5UL
   };
   tenType enType;

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual tBool operator==(const fi_tcl_e8_FuelType& rfoCmp) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   virtual tS32 s32GetTypeId() const { return typesfi_tclToken::EN_E8_FUELTYPE;}
   virtual tVoid vTakeVisitor(fi_tclVisitorBase& rfoVisitor);
};

class fi_tcl_DistTimeFuel : public fi_tclVisitableTypeBase
{
public:
   fi_tcl_DistTimeFuel():Distance(),Time(),Fuel() {}
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   fi_tcl_DistTimeFuel& operator=(const fi_tcl_DistTimeFuel& coRef);
   fi_tcl_DistTimeFuel(const fi_tcl_DistTimeFuel& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
   fi_tcl_s32_Meter Distance;
   fi_tcl_s32_Second Time;
   fi_tcl_s32_Microliter Fuel;

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual tBool operator==(const fi_tcl_DistTimeFuel& rfoCmp) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   virtual tS32 s32GetTypeId() const { return typesfi_tclToken::EN_DISTTIMEFUEL;}
   virtual tVoid vTakeVisitor(fi_tclVisitorBase& rfoVisitor);
};

class fi_tcl_e8_BinContainerTypes : public fi_tclVisitableTypeBase
{
public:
   fi_tcl_e8_BinContainerTypes():enType(FI_EN_T_RESERVED) {}

   enum tenType {
      FI_EN_T_RESERVED = 0UL,
      FI_EN_T_NAVUTMBINCONTAINER = 1UL,
      FI_EN_T_NAVLOCATIONBINCONTAINER = 2UL,
      FI_EN_T_TMCODEDMESSAGEBINCONTAINER = 3UL,
      FI_EN_T_NAVROUTELISTBINCONTAINER = 4UL,
      FI_EN_T_TMMAPBINCONTAINER = 5UL,
      FI_EN_T_MAPROUTEBINCONTAINER = 6UL,
      FI_EN_T_GRAPHICALWEATHERSHAPEBINCONTAINER = 7UL
   };
   tenType enType;

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual tBool operator==(const fi_tcl_e8_BinContainerTypes& rfoCmp) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   virtual tS32 s32GetTypeId() const { return typesfi_tclToken::EN_E8_BINCONTAINERTYPES;}
   virtual tVoid vTakeVisitor(fi_tclVisitorBase& rfoVisitor);
};

class fi_tcl_State : public fi_tclVisitableTypeBase
{
public:
   fi_tcl_State():StateId(),StateName() {}
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   fi_tcl_State& operator=(const fi_tcl_State& coRef);
   fi_tcl_State(const fi_tcl_State& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
   fi_tclString StateId;
   fi_tclString StateName;

   virtual tVoid vDestroy();
   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual tBool operator==(const fi_tcl_State& rfoCmp) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   virtual tS32 s32GetTypeId() const { return typesfi_tclToken::EN_STATE;}
   virtual tVoid vTakeVisitor(fi_tclVisitorBase& rfoVisitor);
};

class fi_tcl_e8_FuelAge : public fi_tclVisitableTypeBase
{
public:
   fi_tcl_e8_FuelAge():enType(FI_EN_WITHIN_1_DAY) {}

   enum tenType {
      FI_EN_WITHIN_1_DAY = 0UL,
      FI_EN_WITHIN_2_DAYS = 1UL,
      FI_EN_WITHIN_3_DAYS = 2UL,
      FI_EN_MORE_THAN_3_DAYS = 3UL,
      FI_EN_INVALID = 255UL
   };
   tenType enType;

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual tBool operator==(const fi_tcl_e8_FuelAge& rfoCmp) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   virtual tS32 s32GetTypeId() const { return typesfi_tclToken::EN_E8_FUELAGE;}
   virtual tVoid vTakeVisitor(fi_tclVisitorBase& rfoVisitor);
};

class fi_tcl_FuelTypeCode : public fi_tclVisitableTypeBase
{
public:
   fi_tcl_FuelTypeCode():FuelTypeCode(0) {}
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   fi_tcl_FuelTypeCode& operator=(const fi_tcl_FuelTypeCode& coRef);
   fi_tcl_FuelTypeCode(const fi_tcl_FuelTypeCode& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
   tU8 FuelTypeCode;

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual tBool operator==(const fi_tcl_FuelTypeCode& rfoCmp) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   virtual tS32 s32GetTypeId() const { return typesfi_tclToken::EN_FUELTYPECODE;}
   virtual tVoid vTakeVisitor(fi_tclVisitorBase& rfoVisitor);
};

class fi_tcl_RegionId : public fi_tclVisitableTypeBase
{
public:
   fi_tcl_RegionId():RegionId(0) {}
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   fi_tcl_RegionId& operator=(const fi_tcl_RegionId& coRef);
   fi_tcl_RegionId(const fi_tcl_RegionId& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
   tU16 RegionId;

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual tBool operator==(const fi_tcl_RegionId& rfoCmp) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   virtual tS32 s32GetTypeId() const { return typesfi_tclToken::EN_REGIONID;}
   virtual tVoid vTakeVisitor(fi_tclVisitorBase& rfoVisitor);
};

class fi_tcl_FuelAge : public fi_tclVisitableTypeBase
{
public:
   fi_tcl_FuelAge():AgeType() {}
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   fi_tcl_FuelAge& operator=(const fi_tcl_FuelAge& coRef);
   fi_tcl_FuelAge(const fi_tcl_FuelAge& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
   fi_tcl_e8_FuelAge AgeType;

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual tBool operator==(const fi_tcl_FuelAge& rfoCmp) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   virtual tS32 s32GetTypeId() const { return typesfi_tclToken::EN_FUELAGE;}
   virtual tVoid vTakeVisitor(fi_tclVisitorBase& rfoVisitor);
};

class fi_tcl_FuelPrice : public fi_tclVisitableTypeBase
{
public:
   fi_tcl_FuelPrice():FuelType(),Price(0),Currency(),Age() {}
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   fi_tcl_FuelPrice& operator=(const fi_tcl_FuelPrice& coRef);
   fi_tcl_FuelPrice(const fi_tcl_FuelPrice& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
   fi_tcl_FuelTypeCode FuelType;
   tU16 Price;
   fi_tclString Currency;
   fi_tcl_FuelAge Age;

   virtual tVoid vDestroy();
   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual tBool operator==(const fi_tcl_FuelPrice& rfoCmp) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   virtual tS32 s32GetTypeId() const { return typesfi_tclToken::EN_FUELPRICE;}
   virtual tVoid vTakeVisitor(fi_tclVisitorBase& rfoVisitor);
};

class fi_tcl_FuelStationId : public fi_tclVisitableTypeBase
{
public:
   fi_tcl_FuelStationId():StationId(0) {}
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   fi_tcl_FuelStationId& operator=(const fi_tcl_FuelStationId& coRef);
   fi_tcl_FuelStationId(const fi_tcl_FuelStationId& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
   tU16 StationId;

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual tBool operator==(const fi_tcl_FuelStationId& rfoCmp) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   virtual tS32 s32GetTypeId() const { return typesfi_tclToken::EN_FUELSTATIONID;}
   virtual tVoid vTakeVisitor(fi_tclVisitorBase& rfoVisitor);
};

class fi_tcl_FuelType : public fi_tclVisitableTypeBase
{
public:
   fi_tcl_FuelType():Code(),Name(0),WellKnownType(0) {}
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   fi_tcl_FuelType& operator=(const fi_tcl_FuelType& coRef);
   fi_tcl_FuelType(const fi_tcl_FuelType& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
   fi_tcl_FuelTypeCode Code;
   fi_tclMultiLanguageString Name;
   tBool WellKnownType;

   virtual tVoid vDestroy();
   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual tBool operator==(const fi_tcl_FuelType& rfoCmp) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   virtual tS32 s32GetTypeId() const { return typesfi_tclToken::EN_FUELTYPE;}
   virtual tVoid vTakeVisitor(fi_tclVisitorBase& rfoVisitor);
};

class fi_tcl_FuelStation : public fi_tclVisitableTypeBase
{
public:
   fi_tcl_FuelStation():RegionId(),StationId() {}
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   fi_tcl_FuelStation& operator=(const fi_tcl_FuelStation& coRef);
   fi_tcl_FuelStation(const fi_tcl_FuelStation& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
   fi_tcl_RegionId RegionId;
   fi_tcl_FuelStationId StationId;

   virtual tVoid vDestroy();
   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual tBool operator==(const fi_tcl_FuelStation& rfoCmp) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   virtual tS32 s32GetTypeId() const { return typesfi_tclToken::EN_FUELSTATION;}
   virtual tVoid vTakeVisitor(fi_tclVisitorBase& rfoVisitor);
};

class fi_tcl_FuelStationPrices : public fi_tclVisitableTypeBase
{
public:
   fi_tcl_FuelStationPrices():FuelStation() {}
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   fi_tcl_FuelStationPrices& operator=(const fi_tcl_FuelStationPrices& coRef);
   fi_tcl_FuelStationPrices(const fi_tcl_FuelStationPrices& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
   fi_tcl_FuelStation FuelStation;
   std::vector<fi_tcl_FuelPrice, std::allocator<fi_tcl_FuelPrice> > FuelPrices;

   virtual tVoid vDestroy();
   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual tBool operator==(const fi_tcl_FuelStationPrices& rfoCmp) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   virtual tS32 s32GetTypeId() const { return typesfi_tclToken::EN_FUELSTATIONPRICES;}
   virtual tVoid vTakeVisitor(fi_tclVisitorBase& rfoVisitor);
};

class fi_tcl_StationFuelTypes : public fi_tclVisitableTypeBase
{
public:
   fi_tcl_StationFuelTypes():FuelStation() {}
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   fi_tcl_StationFuelTypes& operator=(const fi_tcl_StationFuelTypes& coRef);
   fi_tcl_StationFuelTypes(const fi_tcl_StationFuelTypes& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
   fi_tcl_FuelStation FuelStation;
   std::vector<fi_tcl_FuelType, std::allocator<fi_tcl_FuelType> > FuelTypeList;

   virtual tVoid vDestroy();
   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual tBool operator==(const fi_tcl_StationFuelTypes& rfoCmp) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   virtual tS32 s32GetTypeId() const { return typesfi_tclToken::EN_STATIONFUELTYPES;}
   virtual tVoid vTakeVisitor(fi_tclVisitorBase& rfoVisitor);
};

class fi_tcl_b16_StationDescriptionRequest : public fi_tclVisitableTypeBase
{
public:
   fi_tcl_b16_StationDescriptionRequest():u16Value(0) {}

   enum {
      FI_C_U16_BIT_NAME = 0x1UL,
      FI_C_U16_BIT_BRAND = 0x2UL,
      FI_C_U16_BIT_ADDRESS = 0x4UL,
      FI_C_U16_BIT_CITY = 0x8UL,
      FI_C_U16_BIT_ZIP = 0x10UL,
      FI_C_U16_BIT_STATE = 0x20UL,
      FI_C_U16_BIT_PHONE = 0x40UL,
      FI_C_U16_BIT_POSITION = 0x80UL,
      FI_C_U16_BIT_LISTOFAMENITIES = 0x100UL
   };
   tBool bName() const {return (u16Value & FI_C_U16_BIT_NAME) != 0; }
   tVoid vSetName(tBool bSetBit) { u16Value = (bSetBit)?(u16Value | FI_C_U16_BIT_NAME):(u16Value & ~FI_C_U16_BIT_NAME); }
   tBool bBrand() const {return (u16Value & FI_C_U16_BIT_BRAND) != 0; }
   tVoid vSetBrand(tBool bSetBit) { u16Value = (bSetBit)?(u16Value | FI_C_U16_BIT_BRAND):(u16Value & ~FI_C_U16_BIT_BRAND); }
   tBool bAddress() const {return (u16Value & FI_C_U16_BIT_ADDRESS) != 0; }
   tVoid vSetAddress(tBool bSetBit) { u16Value = (bSetBit)?(u16Value | FI_C_U16_BIT_ADDRESS):(u16Value & ~FI_C_U16_BIT_ADDRESS); }
   tBool bCity() const {return (u16Value & FI_C_U16_BIT_CITY) != 0; }
   tVoid vSetCity(tBool bSetBit) { u16Value = (bSetBit)?(u16Value | FI_C_U16_BIT_CITY):(u16Value & ~FI_C_U16_BIT_CITY); }
   tBool bZip() const {return (u16Value & FI_C_U16_BIT_ZIP) != 0; }
   tVoid vSetZip(tBool bSetBit) { u16Value = (bSetBit)?(u16Value | FI_C_U16_BIT_ZIP):(u16Value & ~FI_C_U16_BIT_ZIP); }
   tBool bState() const {return (u16Value & FI_C_U16_BIT_STATE) != 0; }
   tVoid vSetState(tBool bSetBit) { u16Value = (bSetBit)?(u16Value | FI_C_U16_BIT_STATE):(u16Value & ~FI_C_U16_BIT_STATE); }
   tBool bPhone() const {return (u16Value & FI_C_U16_BIT_PHONE) != 0; }
   tVoid vSetPhone(tBool bSetBit) { u16Value = (bSetBit)?(u16Value | FI_C_U16_BIT_PHONE):(u16Value & ~FI_C_U16_BIT_PHONE); }
   tBool bPosition() const {return (u16Value & FI_C_U16_BIT_POSITION) != 0; }
   tVoid vSetPosition(tBool bSetBit) { u16Value = (bSetBit)?(u16Value | FI_C_U16_BIT_POSITION):(u16Value & ~FI_C_U16_BIT_POSITION); }
   tBool bListOfAmenities() const {return (u16Value & FI_C_U16_BIT_LISTOFAMENITIES) != 0; }
   tVoid vSetListOfAmenities(tBool bSetBit) { u16Value = (bSetBit)?(u16Value | FI_C_U16_BIT_LISTOFAMENITIES):(u16Value & ~FI_C_U16_BIT_LISTOFAMENITIES); }
   struct rBitValues {
      unsigned int Name:1;
      unsigned int Brand:1;
      unsigned int Address:1;
      unsigned int City:1;
      unsigned int Zip:1;
      unsigned int State:1;
      unsigned int Phone:1;
      unsigned int Position:1;
      unsigned int ListOfAmenities:1;
      unsigned int dummy9:1;
      unsigned int dummy10:1;
      unsigned int dummy11:1;
      unsigned int dummy12:1;
      unsigned int dummy13:1;
      unsigned int dummy14:1;
      unsigned int dummy15:1;
   };
   union {
      tU16 u16Value;
      rBitValues bits;
   };

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual tBool operator==(const fi_tcl_b16_StationDescriptionRequest& rfoCmp) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   virtual tS32 s32GetTypeId() const { return typesfi_tclToken::EN_B16_STATIONDESCRIPTIONREQUEST;}
   virtual tVoid vTakeVisitor(fi_tclVisitorBase& rfoVisitor);
};

class fi_tcl_FuelStationInfo : public fi_tclVisitableTypeBase
{
public:
   fi_tcl_FuelStationInfo():Address(),Brand(),City(),Name(),Phone(),Position(),State(),Zip() {}
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   fi_tcl_FuelStationInfo& operator=(const fi_tcl_FuelStationInfo& coRef);
   fi_tcl_FuelStationInfo(const fi_tcl_FuelStationInfo& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
   fi_tclString Address;
   fi_tclString Brand;
   fi_tclString City;
   std::vector<fi_tcl_Amenity, std::allocator<fi_tcl_Amenity> > ListOfAmenities;
   fi_tclString Name;
   fi_tclString Phone;
   fi_tcl_PositionWGS84 Position;
   fi_tcl_State State;
   fi_tclString Zip;

   virtual tVoid vDestroy();
   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual tBool operator==(const fi_tcl_FuelStationInfo& rfoCmp) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   virtual tS32 s32GetTypeId() const { return typesfi_tclToken::EN_FUELSTATIONINFO;}
   virtual tVoid vTakeVisitor(fi_tclVisitorBase& rfoVisitor);
};

class fi_tcl_FuelStationPricesForPosition : public fi_tclVisitableTypeBase
{
public:
   fi_tcl_FuelStationPricesForPosition():Position() {}
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   fi_tcl_FuelStationPricesForPosition& operator=(const fi_tcl_FuelStationPricesForPosition& coRef);
   fi_tcl_FuelStationPricesForPosition(const fi_tcl_FuelStationPricesForPosition& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
   fi_tcl_PositionWGS84 Position;
   std::vector<fi_tcl_FuelStationPrices, std::allocator<fi_tcl_FuelStationPrices> > FuelStationPrices;

   virtual tVoid vDestroy();
   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual tBool operator==(const fi_tcl_FuelStationPricesForPosition& rfoCmp) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   virtual tS32 s32GetTypeId() const { return typesfi_tclToken::EN_FUELSTATIONPRICESFORPOSITION;}
   virtual tVoid vTakeVisitor(fi_tclVisitorBase& rfoVisitor);
};

class fi_tcl_UpdateId : public fi_tclVisitableTypeBase
{
public:
   fi_tcl_UpdateId():UpdateId(0) {}
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   fi_tcl_UpdateId& operator=(const fi_tcl_UpdateId& coRef);
   fi_tcl_UpdateId(const fi_tcl_UpdateId& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
   tU16 UpdateId;

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual tBool operator==(const fi_tcl_UpdateId& rfoCmp) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   virtual tS32 s32GetTypeId() const { return typesfi_tclToken::EN_UPDATEID;}
   virtual tVoid vTakeVisitor(fi_tclVisitorBase& rfoVisitor);
};

class fi_tcl_e8_SXMFuelType : public fi_tclVisitableTypeBase
{
public:
   fi_tcl_e8_SXMFuelType():enType(FI_EN_REGULAR) {}

   enum tenType {
      FI_EN_REGULAR = 0UL,
      FI_EN_MIDRANGE = 1UL,
      FI_EN_PREMIUM = 2UL,
      FI_EN_DIESEL = 3UL,
      FI_EN_UNKNOWN = 255UL
   };
   tenType enType;

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual tBool operator==(const fi_tcl_e8_SXMFuelType& rfoCmp) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   virtual tS32 s32GetTypeId() const { return typesfi_tclToken::EN_E8_SXMFUELTYPE;}
   virtual tVoid vTakeVisitor(fi_tclVisitorBase& rfoVisitor);
};

class fi_tcl_e8_RoadClassCode : public fi_tclVisitableTypeBase
{
public:
   fi_tcl_e8_RoadClassCode():enType(FI_EN_RESERVED) {}

   enum tenType {
      FI_EN_RESERVED = 0UL,
      FI_EN_MOTORWAY = 1UL,
      FI_EN_FREEWAY = 2UL,
      FI_EN_HIGHWAY = 3UL,
      FI_EN_ARTERIAL = 4UL,
      FI_EN_COLLECTOR = 5UL,
      FI_EN_LOCAL = 6UL,
      FI_EN_ADRESSABLESTREET = 7UL,
      FI_EN_TRAIL = 8UL
   };
   tenType enType;

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual tBool operator==(const fi_tcl_e8_RoadClassCode& rfoCmp) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   virtual tS32 s32GetTypeId() const { return typesfi_tclToken::EN_E8_ROADCLASSCODE;}
   virtual tVoid vTakeVisitor(fi_tclVisitorBase& rfoVisitor);
};

class fi_tcl_TMOneCellPortion : public fi_tclVisitableTypeBase
{
public:
   fi_tcl_TMOneCellPortion():Offset(),Length() {}
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   fi_tcl_TMOneCellPortion& operator=(const fi_tcl_TMOneCellPortion& coRef);
   fi_tcl_TMOneCellPortion(const fi_tcl_TMOneCellPortion& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
   fi_tcl_u8_Percent Offset;
   fi_tcl_u8_Percent Length;

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual tBool operator==(const fi_tcl_TMOneCellPortion& rfoCmp) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   virtual tS32 s32GetTypeId() const { return typesfi_tclToken::EN_TMONECELLPORTION;}
   virtual tVoid vTakeVisitor(fi_tclVisitorBase& rfoVisitor);
};

class fi_tcl_NavClusterDesc : public fi_tclVisitableTypeBase
{
public:
   fi_tcl_NavClusterDesc():Level(0),FileId(0),FileOffset(0),Length(0) {}
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   fi_tcl_NavClusterDesc& operator=(const fi_tcl_NavClusterDesc& coRef);
   fi_tcl_NavClusterDesc(const fi_tcl_NavClusterDesc& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
   tU8 Level;
   tU16 FileId;
   tU32 FileOffset;
   tU16 Length;

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual tBool operator==(const fi_tcl_NavClusterDesc& rfoCmp) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   virtual tS32 s32GetTypeId() const { return typesfi_tclToken::EN_NAVCLUSTERDESC;}
   virtual tVoid vTakeVisitor(fi_tclVisitorBase& rfoVisitor);
};

class fi_tcl_b8_TMCIntersectionPath : public fi_tclVisitableTypeBase
{
public:
   fi_tcl_b8_TMCIntersectionPath():u8Value(0) {}

   enum {
      FI_C_U8_BIT_EXITINTMCDIR = 0x2UL,
      FI_C_U8_BIT_ENTRYINTMCDIR = 0x4UL,
      FI_C_U8_BIT_MAINCARRIAGEWAYINTMCDIR = 0x8UL,
      FI_C_U8_BIT_EXITAGTMCDIR = 0x10UL,
      FI_C_U8_BIT_ENTRYAGTMCDIR = 0x20UL,
      FI_C_U8_BIT_MAINCARRIAGEWAYAGTMCDIR = 0x40UL
   };
   tBool bExitInTMCDir() const {return (u8Value & FI_C_U8_BIT_EXITINTMCDIR) != 0; }
   tVoid vSetExitInTMCDir(tBool bSetBit) { u8Value = (bSetBit)?(u8Value | FI_C_U8_BIT_EXITINTMCDIR):(u8Value & ~FI_C_U8_BIT_EXITINTMCDIR); }
   tBool bEntryInTMCDir() const {return (u8Value & FI_C_U8_BIT_ENTRYINTMCDIR) != 0; }
   tVoid vSetEntryInTMCDir(tBool bSetBit) { u8Value = (bSetBit)?(u8Value | FI_C_U8_BIT_ENTRYINTMCDIR):(u8Value & ~FI_C_U8_BIT_ENTRYINTMCDIR); }
   tBool bMainCarriageWayInTMCDir() const {return (u8Value & FI_C_U8_BIT_MAINCARRIAGEWAYINTMCDIR) != 0; }
   tVoid vSetMainCarriageWayInTMCDir(tBool bSetBit) { u8Value = (bSetBit)?(u8Value | FI_C_U8_BIT_MAINCARRIAGEWAYINTMCDIR):(u8Value & ~FI_C_U8_BIT_MAINCARRIAGEWAYINTMCDIR); }
   tBool bExitAgTMCDir() const {return (u8Value & FI_C_U8_BIT_EXITAGTMCDIR) != 0; }
   tVoid vSetExitAgTMCDir(tBool bSetBit) { u8Value = (bSetBit)?(u8Value | FI_C_U8_BIT_EXITAGTMCDIR):(u8Value & ~FI_C_U8_BIT_EXITAGTMCDIR); }
   tBool bEntryAgTMCDir() const {return (u8Value & FI_C_U8_BIT_ENTRYAGTMCDIR) != 0; }
   tVoid vSetEntryAgTMCDir(tBool bSetBit) { u8Value = (bSetBit)?(u8Value | FI_C_U8_BIT_ENTRYAGTMCDIR):(u8Value & ~FI_C_U8_BIT_ENTRYAGTMCDIR); }
   tBool bMainCarriageWayAgTMCDir() const {return (u8Value & FI_C_U8_BIT_MAINCARRIAGEWAYAGTMCDIR) != 0; }
   tVoid vSetMainCarriageWayAgTMCDir(tBool bSetBit) { u8Value = (bSetBit)?(u8Value | FI_C_U8_BIT_MAINCARRIAGEWAYAGTMCDIR):(u8Value & ~FI_C_U8_BIT_MAINCARRIAGEWAYAGTMCDIR); }
   struct rBitValues {
      unsigned int dummy0:1;
      unsigned int ExitInTMCDir:1;
      unsigned int EntryInTMCDir:1;
      unsigned int MainCarriageWayInTMCDir:1;
      unsigned int ExitAgTMCDir:1;
      unsigned int EntryAgTMCDir:1;
      unsigned int MainCarriageWayAgTMCDir:1;
      unsigned int dummy7:1;
   };
   union {
      tU8 u8Value;
      rBitValues bits;
   };

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual tBool operator==(const fi_tcl_b8_TMCIntersectionPath& rfoCmp) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   virtual tS32 s32GetTypeId() const { return typesfi_tclToken::EN_B8_TMCINTERSECTIONPATH;}
   virtual tVoid vTakeVisitor(fi_tclVisitorBase& rfoVisitor);
};

class fi_tcl_e8_TMCIntersectionPathType : public fi_tclVisitableTypeBase
{
public:
   fi_tcl_e8_TMCIntersectionPathType():enType(FI_EN_EXITINTMCDIR) {}

   enum tenType {
      FI_EN_EXITINTMCDIR = 1UL,
      FI_EN_ENTRYINTMCDIR = 2UL,
      FI_EN_MAINCARRIAGEWAYINTMCDIR = 3UL,
      FI_EN_EXITAGTMCDIR = 4UL,
      FI_EN_ENTRYAGTMCDIR = 5UL,
      FI_EN_MAINCARRIAGEWAYAGTMCDIR = 6UL
   };
   tenType enType;

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual tBool operator==(const fi_tcl_e8_TMCIntersectionPathType& rfoCmp) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   virtual tS32 s32GetTypeId() const { return typesfi_tclToken::EN_E8_TMCINTERSECTIONPATHTYPE;}
   virtual tVoid vTakeVisitor(fi_tclVisitorBase& rfoVisitor);
};

class fi_tcl_NavOneCellDesc : public fi_tclVisitableTypeBase
{
public:
   fi_tcl_NavOneCellDesc():OneCellId(0),UseDirection(),IndexInClusterRefList() {}
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   fi_tcl_NavOneCellDesc& operator=(const fi_tcl_NavOneCellDesc& coRef);
   fi_tcl_NavOneCellDesc(const fi_tcl_NavOneCellDesc& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
   tU16 OneCellId;
   fi_tcl_e8_NavOneCellDirection UseDirection;
   fi_tcl_u16_IndexInReferenceList IndexInClusterRefList;

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual tBool operator==(const fi_tcl_NavOneCellDesc& rfoCmp) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   virtual tS32 s32GetTypeId() const { return typesfi_tclToken::EN_NAVONECELLDESC;}
   virtual tVoid vTakeVisitor(fi_tclVisitorBase& rfoVisitor);
};

class fi_tcl_TMIntersectionMatrix : public fi_tclVisitableTypeBase
{
public:
   fi_tcl_TMIntersectionMatrix():DataLevel(0) {}
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   fi_tcl_TMIntersectionMatrix& operator=(const fi_tcl_TMIntersectionMatrix& coRef);
   fi_tcl_TMIntersectionMatrix(const fi_tcl_TMIntersectionMatrix& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
   tU8 DataLevel;
   std::vector<fi_tcl_NavOneCellDesc, std::allocator<fi_tcl_NavOneCellDesc> > IntoIntersectionOneCells;
   std::vector<fi_tcl_NavOneCellDesc, std::allocator<fi_tcl_NavOneCellDesc> > OutOfIntersectionOneCells;

   virtual tVoid vDestroy();
   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual tBool operator==(const fi_tcl_TMIntersectionMatrix& rfoCmp) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   virtual tS32 s32GetTypeId() const { return typesfi_tclToken::EN_TMINTERSECTIONMATRIX;}
   virtual tVoid vTakeVisitor(fi_tclVisitorBase& rfoVisitor);
};

class fi_tcl_s16_EMU : public fi_tclVisitableTypeBase
{
public:
   fi_tcl_s16_EMU(tS16 _s16Value = 0):s16Value(_s16Value) {} 

   tS16 s16Value;

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual tBool operator==(const fi_tcl_s16_EMU& rfoCmp) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   virtual tS32 s32GetTypeId() const { return typesfi_tclToken::EN_S16_EMU;}
   virtual tVoid vTakeVisitor(fi_tclVisitorBase& rfoVisitor);
};

class fi_tcl_s32_MEMU : public fi_tclVisitableTypeBase
{
public:
   fi_tcl_s32_MEMU(tS32 _s32Value = 0):s32Value(_s32Value) {} 

   tS32 s32Value;

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual tBool operator==(const fi_tcl_s32_MEMU& rfoCmp) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   virtual tS32 s32GetTypeId() const { return typesfi_tclToken::EN_S32_MEMU;}
   virtual tVoid vTakeVisitor(fi_tclVisitorBase& rfoVisitor);
};

class fi_tcl_s16_MEMUSecond : public fi_tclVisitableTypeBase
{
public:
   fi_tcl_s16_MEMUSecond(tS16 _s16Value = 0):s16Value(_s16Value) {} 

   tS16 s16Value;

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual tBool operator==(const fi_tcl_s16_MEMUSecond& rfoCmp) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   virtual tS32 s32GetTypeId() const { return typesfi_tclToken::EN_S16_MEMUSECOND;}
   virtual tVoid vTakeVisitor(fi_tclVisitorBase& rfoVisitor);
};

class fi_tcl_s16_EAU : public fi_tclVisitableTypeBase
{
public:
   fi_tcl_s16_EAU(tS16 _s16Value = 0):s16Value(_s16Value) {} 

   tS16 s16Value;

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual tBool operator==(const fi_tcl_s16_EAU& rfoCmp) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   virtual tS32 s32GetTypeId() const { return typesfi_tclToken::EN_S16_EAU;}
   virtual tVoid vTakeVisitor(fi_tclVisitorBase& rfoVisitor);
};

class fi_tcl_NavPlainPathListSet : public fi_tclVisitableTypeBase
{
public:
   fi_tcl_NavPlainPathListSet() {}
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   fi_tcl_NavPlainPathListSet& operator=(const fi_tcl_NavPlainPathListSet& coRef);
   fi_tcl_NavPlainPathListSet(const fi_tcl_NavPlainPathListSet& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
   std::vector<fi_tcl_NavClusterDesc, std::allocator<fi_tcl_NavClusterDesc> > Cluster;
   std::vector<fi_tcl_NavOneCellDesc, std::allocator<fi_tcl_NavOneCellDesc> > OneCell;

   virtual tVoid vDestroy();
   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual tBool operator==(const fi_tcl_NavPlainPathListSet& rfoCmp) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   virtual tS32 s32GetTypeId() const { return typesfi_tclToken::EN_NAVPLAINPATHLISTSET;}
   virtual tVoid vTakeVisitor(fi_tclVisitorBase& rfoVisitor);
};

class fi_tcl_s32_EMU : public fi_tclVisitableTypeBase
{
public:
   fi_tcl_s32_EMU(tS32 _s32Value = 0):s32Value(_s32Value) {} 

   tS32 s32Value;

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual tBool operator==(const fi_tcl_s32_EMU& rfoCmp) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   virtual tS32 s32GetTypeId() const { return typesfi_tclToken::EN_S32_EMU;}
   virtual tVoid vTakeVisitor(fi_tclVisitorBase& rfoVisitor);
};

class fi_tcl_b32_RoadProperty : public fi_tclVisitableTypeBase
{
public:
   fi_tcl_b32_RoadProperty():u32Value(0) {}

   enum {
      FI_C_U32_BIT_ISRESTRICTED = 0x1UL,
      FI_C_U32_BIT_ISBUILDUP = 0x2UL,
      FI_C_U32_BIT_ISSPEEDLIM = 0x4UL,
      FI_C_U32_BIT_ISJUNCTIONFREE = 0x8UL,
      FI_C_U32_BIT_ISCOLLAPSED = 0x10UL,
      FI_C_U32_BIT_ISBASICATTRIBUTED = 0x20UL,
      FI_C_U32_BIT_ISOBJECT = 0x40UL,
      FI_C_U32_BIT_ISCOMPLEXINTERSECTION = 0x80UL,
      FI_C_U32_BIT_ISFERRY = 0x100UL,
      FI_C_U32_BIT_ISTOLLROAD = 0x200UL,
      FI_C_U32_BIT_ISSEASONALCLOSED = 0x400UL,
      FI_C_U32_BIT_ISTUNNEL = 0x800UL,
      FI_C_U32_BIT_ISNOPASS = 0x1000UL,
      FI_C_U32_BIT_ISHARDONEWAYINDIGITIZED = 0x2000UL,
      FI_C_U32_BIT_ISHARDONEWAYREVDIGITIZED = 0x4000UL,
      FI_C_U32_BIT_ISBRIDGE = 0x8000UL,
      FI_C_U32_BIT_ISSTUBBLE = 0x10000UL,
      FI_C_U32_BIT_ISGATEWAY = 0x20000UL,
      FI_C_U32_BIT_ISNOTCOVEREDWITHTRUCKATTRIBUTES = 0x40000UL,
      FI_C_U32_BIT_ISAUTOTRAIN = 0x80000UL,
      FI_C_U32_BIT_ISUNPAVEDROAD = 0x100000UL
   };
   tBool bIsRestricted() const {return (u32Value & FI_C_U32_BIT_ISRESTRICTED) != 0; }
   tVoid vSetIsRestricted(tBool bSetBit) { u32Value = (bSetBit)?(u32Value | FI_C_U32_BIT_ISRESTRICTED):(u32Value & ~FI_C_U32_BIT_ISRESTRICTED); }
   tBool bIsBuildUp() const {return (u32Value & FI_C_U32_BIT_ISBUILDUP) != 0; }
   tVoid vSetIsBuildUp(tBool bSetBit) { u32Value = (bSetBit)?(u32Value | FI_C_U32_BIT_ISBUILDUP):(u32Value & ~FI_C_U32_BIT_ISBUILDUP); }
   tBool bIsSpeedLim() const {return (u32Value & FI_C_U32_BIT_ISSPEEDLIM) != 0; }
   tVoid vSetIsSpeedLim(tBool bSetBit) { u32Value = (bSetBit)?(u32Value | FI_C_U32_BIT_ISSPEEDLIM):(u32Value & ~FI_C_U32_BIT_ISSPEEDLIM); }
   tBool bIsJunctionFree() const {return (u32Value & FI_C_U32_BIT_ISJUNCTIONFREE) != 0; }
   tVoid vSetIsJunctionFree(tBool bSetBit) { u32Value = (bSetBit)?(u32Value | FI_C_U32_BIT_ISJUNCTIONFREE):(u32Value & ~FI_C_U32_BIT_ISJUNCTIONFREE); }
   tBool bIsCollapsed() const {return (u32Value & FI_C_U32_BIT_ISCOLLAPSED) != 0; }
   tVoid vSetIsCollapsed(tBool bSetBit) { u32Value = (bSetBit)?(u32Value | FI_C_U32_BIT_ISCOLLAPSED):(u32Value & ~FI_C_U32_BIT_ISCOLLAPSED); }
   tBool bIsBasicAttributed() const {return (u32Value & FI_C_U32_BIT_ISBASICATTRIBUTED) != 0; }
   tVoid vSetIsBasicAttributed(tBool bSetBit) { u32Value = (bSetBit)?(u32Value | FI_C_U32_BIT_ISBASICATTRIBUTED):(u32Value & ~FI_C_U32_BIT_ISBASICATTRIBUTED); }
   tBool bIsObject() const {return (u32Value & FI_C_U32_BIT_ISOBJECT) != 0; }
   tVoid vSetIsObject(tBool bSetBit) { u32Value = (bSetBit)?(u32Value | FI_C_U32_BIT_ISOBJECT):(u32Value & ~FI_C_U32_BIT_ISOBJECT); }
   tBool bIsComplexIntersection() const {return (u32Value & FI_C_U32_BIT_ISCOMPLEXINTERSECTION) != 0; }
   tVoid vSetIsComplexIntersection(tBool bSetBit) { u32Value = (bSetBit)?(u32Value | FI_C_U32_BIT_ISCOMPLEXINTERSECTION):(u32Value & ~FI_C_U32_BIT_ISCOMPLEXINTERSECTION); }
   tBool bIsFerry() const {return (u32Value & FI_C_U32_BIT_ISFERRY) != 0; }
   tVoid vSetIsFerry(tBool bSetBit) { u32Value = (bSetBit)?(u32Value | FI_C_U32_BIT_ISFERRY):(u32Value & ~FI_C_U32_BIT_ISFERRY); }
   tBool bIsTollRoad() const {return (u32Value & FI_C_U32_BIT_ISTOLLROAD) != 0; }
   tVoid vSetIsTollRoad(tBool bSetBit) { u32Value = (bSetBit)?(u32Value | FI_C_U32_BIT_ISTOLLROAD):(u32Value & ~FI_C_U32_BIT_ISTOLLROAD); }
   tBool bIsSeasonalClosed() const {return (u32Value & FI_C_U32_BIT_ISSEASONALCLOSED) != 0; }
   tVoid vSetIsSeasonalClosed(tBool bSetBit) { u32Value = (bSetBit)?(u32Value | FI_C_U32_BIT_ISSEASONALCLOSED):(u32Value & ~FI_C_U32_BIT_ISSEASONALCLOSED); }
   tBool bIsTunnel() const {return (u32Value & FI_C_U32_BIT_ISTUNNEL) != 0; }
   tVoid vSetIsTunnel(tBool bSetBit) { u32Value = (bSetBit)?(u32Value | FI_C_U32_BIT_ISTUNNEL):(u32Value & ~FI_C_U32_BIT_ISTUNNEL); }
   tBool bIsNoPass() const {return (u32Value & FI_C_U32_BIT_ISNOPASS) != 0; }
   tVoid vSetIsNoPass(tBool bSetBit) { u32Value = (bSetBit)?(u32Value | FI_C_U32_BIT_ISNOPASS):(u32Value & ~FI_C_U32_BIT_ISNOPASS); }
   tBool bIsHardOnewayInDigitized() const {return (u32Value & FI_C_U32_BIT_ISHARDONEWAYINDIGITIZED) != 0; }
   tVoid vSetIsHardOnewayInDigitized(tBool bSetBit) { u32Value = (bSetBit)?(u32Value | FI_C_U32_BIT_ISHARDONEWAYINDIGITIZED):(u32Value & ~FI_C_U32_BIT_ISHARDONEWAYINDIGITIZED); }
   tBool bIsHardOnewayRevDigitized() const {return (u32Value & FI_C_U32_BIT_ISHARDONEWAYREVDIGITIZED) != 0; }
   tVoid vSetIsHardOnewayRevDigitized(tBool bSetBit) { u32Value = (bSetBit)?(u32Value | FI_C_U32_BIT_ISHARDONEWAYREVDIGITIZED):(u32Value & ~FI_C_U32_BIT_ISHARDONEWAYREVDIGITIZED); }
   tBool bIsBridge() const {return (u32Value & FI_C_U32_BIT_ISBRIDGE) != 0; }
   tVoid vSetIsBridge(tBool bSetBit) { u32Value = (bSetBit)?(u32Value | FI_C_U32_BIT_ISBRIDGE):(u32Value & ~FI_C_U32_BIT_ISBRIDGE); }
   tBool bIsStubble() const {return (u32Value & FI_C_U32_BIT_ISSTUBBLE) != 0; }
   tVoid vSetIsStubble(tBool bSetBit) { u32Value = (bSetBit)?(u32Value | FI_C_U32_BIT_ISSTUBBLE):(u32Value & ~FI_C_U32_BIT_ISSTUBBLE); }
   tBool bIsGateway() const {return (u32Value & FI_C_U32_BIT_ISGATEWAY) != 0; }
   tVoid vSetIsGateway(tBool bSetBit) { u32Value = (bSetBit)?(u32Value | FI_C_U32_BIT_ISGATEWAY):(u32Value & ~FI_C_U32_BIT_ISGATEWAY); }
   tBool bIsNotCoveredWithTruckAttributes() const {return (u32Value & FI_C_U32_BIT_ISNOTCOVEREDWITHTRUCKATTRIBUTES) != 0; }
   tVoid vSetIsNotCoveredWithTruckAttributes(tBool bSetBit) { u32Value = (bSetBit)?(u32Value | FI_C_U32_BIT_ISNOTCOVEREDWITHTRUCKATTRIBUTES):(u32Value & ~FI_C_U32_BIT_ISNOTCOVEREDWITHTRUCKATTRIBUTES); }
   tBool bIsAutoTrain() const {return (u32Value & FI_C_U32_BIT_ISAUTOTRAIN) != 0; }
   tVoid vSetIsAutoTrain(tBool bSetBit) { u32Value = (bSetBit)?(u32Value | FI_C_U32_BIT_ISAUTOTRAIN):(u32Value & ~FI_C_U32_BIT_ISAUTOTRAIN); }
   tBool bIsUnpavedRoad() const {return (u32Value & FI_C_U32_BIT_ISUNPAVEDROAD) != 0; }
   tVoid vSetIsUnpavedRoad(tBool bSetBit) { u32Value = (bSetBit)?(u32Value | FI_C_U32_BIT_ISUNPAVEDROAD):(u32Value & ~FI_C_U32_BIT_ISUNPAVEDROAD); }
   struct rBitValues {
      unsigned int IsRestricted:1;
      unsigned int IsBuildUp:1;
      unsigned int IsSpeedLim:1;
      unsigned int IsJunctionFree:1;
      unsigned int IsCollapsed:1;
      unsigned int IsBasicAttributed:1;
      unsigned int IsObject:1;
      unsigned int IsComplexIntersection:1;
      unsigned int IsFerry:1;
      unsigned int IsTollRoad:1;
      unsigned int IsSeasonalClosed:1;
      unsigned int IsTunnel:1;
      unsigned int IsNoPass:1;
      unsigned int IsHardOnewayInDigitized:1;
      unsigned int IsHardOnewayRevDigitized:1;
      unsigned int IsBridge:1;
      unsigned int IsStubble:1;
      unsigned int IsGateway:1;
      unsigned int IsNotCoveredWithTruckAttributes:1;
      unsigned int IsAutoTrain:1;
      unsigned int IsUnpavedRoad:1;
      unsigned int dummy21:1;
      unsigned int dummy22:1;
      unsigned int dummy23:1;
      unsigned int dummy24:1;
      unsigned int dummy25:1;
      unsigned int dummy26:1;
      unsigned int dummy27:1;
      unsigned int dummy28:1;
      unsigned int dummy29:1;
      unsigned int dummy30:1;
      unsigned int dummy31:1;
   };
   union {
      tU32 u32Value;
      rBitValues bits;
   };

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual tBool operator==(const fi_tcl_b32_RoadProperty& rfoCmp) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   virtual tS32 s32GetTypeId() const { return typesfi_tclToken::EN_B32_ROADPROPERTY;}
   virtual tVoid vTakeVisitor(fi_tclVisitorBase& rfoVisitor);
};

class fi_tcl_e8_PathType : public fi_tclVisitableTypeBase
{
public:
   fi_tcl_e8_PathType():enType(FI_EN_UNKNOWN) {}

   enum tenType {
      FI_EN_UNKNOWN = 0UL,
      FI_EN_DYP = 1UL,
      FI_EN_POP = 2UL,
      FI_EN_HP = 3UL,
      FI_EN_EP = 4UL
   };
   tenType enType;

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual tBool operator==(const fi_tcl_e8_PathType& rfoCmp) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   virtual tS32 s32GetTypeId() const { return typesfi_tclToken::EN_E8_PATHTYPE;}
   virtual tVoid vTakeVisitor(fi_tclVisitorBase& rfoVisitor);
};

class fi_tcl_s16_CurvatureValue : public fi_tclVisitableTypeBase
{
public:
   fi_tcl_s16_CurvatureValue(tS16 _s16Value = 0):s16Value(_s16Value) {} 

   tS16 s16Value;

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual tBool operator==(const fi_tcl_s16_CurvatureValue& rfoCmp) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   virtual tS32 s32GetTypeId() const { return typesfi_tclToken::EN_S16_CURVATUREVALUE;}
   virtual tVoid vTakeVisitor(fi_tclVisitorBase& rfoVisitor);
};

class fi_tcl_e8_EntryPointState : public fi_tclVisitableTypeBase
{
public:
   fi_tcl_e8_EntryPointState():enType(FI_EN_UNKNOWN) {}

   enum tenType {
      FI_EN_UNKNOWN = 0UL,
      FI_EN_NOENTRYPOINTGUIDANCE = 1UL,
      FI_EN_DRIVINGTOENTRYPOINT = 2UL,
      FI_EN_NEARTHEROAD = 3UL,
      FI_EN_ONROADWITHCAUTION = 4UL,
      FI_EN_WAITINGFORDATA = 5UL
   };
   tenType enType;

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual tBool operator==(const fi_tcl_e8_EntryPointState& rfoCmp) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   virtual tS32 s32GetTypeId() const { return typesfi_tclToken::EN_E8_ENTRYPOINTSTATE;}
   virtual tVoid vTakeVisitor(fi_tclVisitorBase& rfoVisitor);
};

class fi_tcl_u32_Resistance : public fi_tclVisitableTypeBase
{
public:
   fi_tcl_u32_Resistance(tU32 _u32Value = 0):u32Value(_u32Value) {} 

   tU32 u32Value;

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual tBool operator==(const fi_tcl_u32_Resistance& rfoCmp) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   virtual tS32 s32GetTypeId() const { return typesfi_tclToken::EN_U32_RESISTANCE;}
   virtual tVoid vTakeVisitor(fi_tclVisitorBase& rfoVisitor);
};

class fi_tcl_e8_NavStreetType : public fi_tclVisitableTypeBase
{
public:
   fi_tcl_e8_NavStreetType():enType(FI_EN_NOTYPE) {}

   enum tenType {
      FI_EN_NOTYPE = 0UL,
      FI_EN_LONGRAMP = 1UL,
      FI_EN_ROUNDABOUT = 2UL,
      FI_EN_PARALLEL = 3UL,
      FI_EN_SERVICEROAD = 4UL,
      FI_EN_MAINROAD = 5UL,
      FI_EN_SQUARE = 6UL,
      FI_EN_PARKINGAREA = 7UL,
      FI_EN_PEDESTRIAN = 8UL,
      FI_EN_INTERCONNECT = 9UL,
      FI_EN_PARKINGINTERN = 10UL
   };
   tenType enType;

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual tBool operator==(const fi_tcl_e8_NavStreetType& rfoCmp) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   virtual tS32 s32GetTypeId() const { return typesfi_tclToken::EN_E8_NAVSTREETTYPE;}
   virtual tVoid vTakeVisitor(fi_tclVisitorBase& rfoVisitor);
};

class fi_tcl_e8_RoadNetworkClass : public fi_tclVisitableTypeBase
{
public:
   fi_tcl_e8_RoadNetworkClass():enType(FI_EN_) {}

   enum tenType {
      FI_EN_ = 0UL,
      FI_EN_SUPERSCALE_0 = 1UL,
      FI_EN_SUPERSCALE_1000 = 2UL,
      FI_EN_SUPERSCALE_500 = 3UL,
      FI_EN_SUPERSCALE_250 = 4UL,
      FI_EN_SUPERSCALE_100 = 5UL,
      FI_EN_SUPERSCALE_50 = 6UL
   };
   tenType enType;

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual tBool operator==(const fi_tcl_e8_RoadNetworkClass& rfoCmp) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   virtual tS32 s32GetTypeId() const { return typesfi_tclToken::EN_E8_ROADNETWORKCLASS;}
   virtual tVoid vTakeVisitor(fi_tclVisitorBase& rfoVisitor);
};

class fi_tcl_e8_RoadInfoPriority : public fi_tclVisitableTypeBase
{
public:
   fi_tcl_e8_RoadInfoPriority():enType(FI_EN_RESERVED) {}

   enum tenType {
      FI_EN_RESERVED = 0UL,
      FI_EN_POSITION = 1UL,
      FI_EN_GUIDEDROUTE = 2UL,
      FI_EN_TRACKEDROUTE = 3UL,
      FI_EN_TRAFFICINFO = 4UL,
      FI_EN_PLANNEDROUTE = 5UL,
      FI_EN_MAP = 6UL,
      FI_EN_MAPEXT = 7UL,
      FI_EN_MAPINTZOOM = 8UL,
      FI_EN_HORIZON = 9UL,
      FI_EN_HORIZONEXT = 10UL,
      FI_EN_LOCATIONINPUT = 11UL
   };
   tenType enType;

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual tBool operator==(const fi_tcl_e8_RoadInfoPriority& rfoCmp) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   virtual tS32 s32GetTypeId() const { return typesfi_tclToken::EN_E8_ROADINFOPRIORITY;}
   virtual tVoid vTakeVisitor(fi_tclVisitorBase& rfoVisitor);
};

class fi_tcl_NavRoadInfoProperty : public fi_tclVisitableTypeBase
{
public:
   fi_tcl_NavRoadInfoProperty():IndexInRoadNameList(),IndexInRoadNumberList(),IndexInMapDescList() {}
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   fi_tcl_NavRoadInfoProperty& operator=(const fi_tcl_NavRoadInfoProperty& coRef);
   fi_tcl_NavRoadInfoProperty(const fi_tcl_NavRoadInfoProperty& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
   fi_tcl_u16_IndexInReferenceList IndexInRoadNameList;
   fi_tcl_u16_IndexInReferenceList IndexInRoadNumberList;
   fi_tcl_u16_IndexInReferenceList IndexInMapDescList;

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual tBool operator==(const fi_tcl_NavRoadInfoProperty& rfoCmp) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   virtual tS32 s32GetTypeId() const { return typesfi_tclToken::EN_NAVROADINFOPROPERTY;}
   virtual tVoid vTakeVisitor(fi_tclVisitorBase& rfoVisitor);
};

class fi_tcl_NavRoadInfoDesc : public fi_tclVisitableTypeBase
{
public:
   fi_tcl_NavRoadInfoDesc():OneCellDesc(),OneCellProperty() {}
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   fi_tcl_NavRoadInfoDesc& operator=(const fi_tcl_NavRoadInfoDesc& coRef);
   fi_tcl_NavRoadInfoDesc(const fi_tcl_NavRoadInfoDesc& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
   fi_tcl_NavOneCellDesc OneCellDesc;
   fi_tcl_NavRoadInfoProperty OneCellProperty;

   virtual tVoid vDestroy();
   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual tBool operator==(const fi_tcl_NavRoadInfoDesc& rfoCmp) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   virtual tS32 s32GetTypeId() const { return typesfi_tclToken::EN_NAVROADINFODESC;}
   virtual tVoid vTakeVisitor(fi_tclVisitorBase& rfoVisitor);
};

class fi_tcl_e8_RoadInfoRefListType : public fi_tclVisitableTypeBase
{
public:
   fi_tcl_e8_RoadInfoRefListType():enType(FI_EN_T_RESERVED) {}

   enum tenType {
      FI_EN_T_RESERVED = 0UL,
      FI_EN_T_ROADNAMEREFLIST = 7UL,
      FI_EN_T_ROADNUMBERREFLIST = 8UL
   };
   tenType enType;

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual tBool operator==(const fi_tcl_e8_RoadInfoRefListType& rfoCmp) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   virtual tS32 s32GetTypeId() const { return typesfi_tclToken::EN_E8_ROADINFOREFLISTTYPE;}
   virtual tVoid vTakeVisitor(fi_tclVisitorBase& rfoVisitor);
};

class fi_tcl_NavRoadInfoRefListUnionType : public fi_tclVisitableTypeBase
{
public:
   fi_tcl_NavRoadInfoRefListUnionType():poInfoListsData(0) {}
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   fi_tcl_NavRoadInfoRefListUnionType& operator=(const fi_tcl_NavRoadInfoRefListUnionType& coRef);
   fi_tcl_NavRoadInfoRefListUnionType(const fi_tcl_NavRoadInfoRefListUnionType& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
   fi_tcl_e8_RoadInfoRefListType InfoListsType;
   fi_tclTypeBase* poInfoListsData;
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   virtual ~fi_tcl_NavRoadInfoRefListUnionType();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   virtual tVoid vDestroy();
   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual tBool operator==(const fi_tcl_NavRoadInfoRefListUnionType& rfoCmp) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   virtual tS32 s32GetTypeId() const { return typesfi_tclToken::EN_NAVROADINFOREFLISTUNIONTYPE;}
   virtual tVoid vTakeVisitor(fi_tclVisitorBase& rfoVisitor);
};

class fi_tcl_NavRoadInfoListSet : public fi_tclVisitableTypeBase
{
public:
   fi_tcl_NavRoadInfoListSet() {}
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   fi_tcl_NavRoadInfoListSet& operator=(const fi_tcl_NavRoadInfoListSet& coRef);
   fi_tcl_NavRoadInfoListSet(const fi_tcl_NavRoadInfoListSet& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
   std::vector<fi_tcl_NavClusterDesc, std::allocator<fi_tcl_NavClusterDesc> > Cluster;
   std::vector<fi_tcl_NavRoadInfoDesc, std::allocator<fi_tcl_NavRoadInfoDesc> > RoadInfo;
   std::vector<fi_tcl_NavRoadInfoRefListUnionType, std::allocator<fi_tcl_NavRoadInfoRefListUnionType> > NavRoadInfoUnionLists;

   virtual tVoid vDestroy();
   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual tBool operator==(const fi_tcl_NavRoadInfoListSet& rfoCmp) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   virtual tS32 s32GetTypeId() const { return typesfi_tclToken::EN_NAVROADINFOLISTSET;}
   virtual tVoid vTakeVisitor(fi_tclVisitorBase& rfoVisitor);
};

class fi_tcl_e8_RoadPathInfoCategory : public fi_tclVisitableTypeBase
{
public:
   fi_tcl_e8_RoadPathInfoCategory():enType(FI_EN_T_RESERVED) {}

   enum tenType {
      FI_EN_T_RESERVED = 0UL,
      FI_EN_T_COUNTRYNAMELISTSET = 1UL,
      FI_EN_T_STATENAMELISTSET = 2UL,
      FI_EN_T_COUNTYNAMELISTSET = 3UL,
      FI_EN_T_CITYNAMELISTSET = 4UL,
      FI_EN_T_CITYDISTRICTNAMELISTSET = 5UL,
      FI_EN_T_BUILDUPAREANAMELISTSET = 6UL,
      FI_EN_T_ROADNAMELISTSET = 7UL,
      FI_EN_T_ROADNUMBERLISTSET = 8UL,
      FI_EN_T_MAPDESCRIPTIONLISTSET = 11UL,
      FI_EN_T_SIGNPOSTLISTSET = 18UL,
      FI_EN_T_EXTRADESCLISTSET = 19UL,
      FI_EN_T_DATADESCLISTSET = 20UL,
      FI_EN_T_NAVINTERSECTIONLISTSET = 21UL,
      FI_EN_T_TRAFFICSIGNLISTSET = 22UL,
      FI_EN_T_POILISTSET = 23UL,
      FI_EN_T_LANEINFOLISTSET = 24UL,
      FI_EN_T_DIRECTIONINFOLISTSET = 25UL,
      FI_EN_T_SHAPEPOINTLISTSET = 28UL,
      FI_EN_T_REQUIREDPERMISSIONLISTSET = 29UL,
      FI_EN_T_TOLLBOOTHLISTSET = 34UL,
      FI_EN_T_TIMEZONELISTSET = 35UL
   };
   tenType enType;

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual tBool operator==(const fi_tcl_e8_RoadPathInfoCategory& rfoCmp) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   virtual tS32 s32GetTypeId() const { return typesfi_tclToken::EN_E8_ROADPATHINFOCATEGORY;}
   virtual tVoid vTakeVisitor(fi_tclVisitorBase& rfoVisitor);
};

class fi_tcl_e8_CrossroadInfoCategory : public fi_tclVisitableTypeBase
{
public:
   fi_tcl_e8_CrossroadInfoCategory():enType(FI_EN_T_RESERVED) {}

   enum tenType {
      FI_EN_T_RESERVED = 0UL,
      FI_EN_T_ROADNAMELISTSET = 7UL,
      FI_EN_T_ROADNUMBERLISTSET = 8UL
   };
   tenType enType;

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual tBool operator==(const fi_tcl_e8_CrossroadInfoCategory& rfoCmp) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   virtual tS32 s32GetTypeId() const { return typesfi_tclToken::EN_E8_CROSSROADINFOCATEGORY;}
   virtual tVoid vTakeVisitor(fi_tclVisitorBase& rfoVisitor);
};

class fi_tcl_RoadPathInfoCategory : public fi_tclVisitableTypeBase
{
public:
   fi_tcl_RoadPathInfoCategory():poCategoryData(0) {}
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   fi_tcl_RoadPathInfoCategory& operator=(const fi_tcl_RoadPathInfoCategory& coRef);
   fi_tcl_RoadPathInfoCategory(const fi_tcl_RoadPathInfoCategory& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
   fi_tcl_e8_RoadPathInfoCategory CategoryType;
   fi_tclTypeBase* poCategoryData;
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   virtual ~fi_tcl_RoadPathInfoCategory();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   virtual tVoid vDestroy();
   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual tBool operator==(const fi_tcl_RoadPathInfoCategory& rfoCmp) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   virtual tS32 s32GetTypeId() const { return typesfi_tclToken::EN_ROADPATHINFOCATEGORY;}
   virtual tVoid vTakeVisitor(fi_tclVisitorBase& rfoVisitor);
};

class fi_tcl_RoadPathInfoListSet : public fi_tclVisitableTypeBase
{
public:
   fi_tcl_RoadPathInfoListSet():RoadPathListSet() {}
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   fi_tcl_RoadPathInfoListSet& operator=(const fi_tcl_RoadPathInfoListSet& coRef);
   fi_tcl_RoadPathInfoListSet(const fi_tcl_RoadPathInfoListSet& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
   fi_tcl_NavPlainPathListSet RoadPathListSet;
   std::vector<fi_tcl_RoadPathInfoCategory, std::allocator<fi_tcl_RoadPathInfoCategory> > RoadPathInfoCategoryList;

   virtual tVoid vDestroy();
   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual tBool operator==(const fi_tcl_RoadPathInfoListSet& rfoCmp) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   virtual tS32 s32GetTypeId() const { return typesfi_tclToken::EN_ROADPATHINFOLISTSET;}
   virtual tVoid vTakeVisitor(fi_tclVisitorBase& rfoVisitor);
};

class fi_tcl_NavTMOneCell : public fi_tclVisitableTypeBase
{
public:
   fi_tcl_NavTMOneCell():OCDesc() {}
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   fi_tcl_NavTMOneCell& operator=(const fi_tcl_NavTMOneCell& coRef);
   fi_tcl_NavTMOneCell(const fi_tcl_NavTMOneCell& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
   fi_tcl_NavOneCellDesc OCDesc;

   virtual tVoid vDestroy();
   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual tBool operator==(const fi_tcl_NavTMOneCell& rfoCmp) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   virtual tS32 s32GetTypeId() const { return typesfi_tclToken::EN_NAVTMONECELL;}
   virtual tVoid vTakeVisitor(fi_tclVisitorBase& rfoVisitor);
};

class fi_tcl_NavTMOneCellListSet : public fi_tclVisitableTypeBase
{
public:
   fi_tcl_NavTMOneCellListSet() {}
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   fi_tcl_NavTMOneCellListSet& operator=(const fi_tcl_NavTMOneCellListSet& coRef);
   fi_tcl_NavTMOneCellListSet(const fi_tcl_NavTMOneCellListSet& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
   std::vector<fi_tcl_NavClusterDesc, std::allocator<fi_tcl_NavClusterDesc> > Cluster;
   std::vector<fi_tcl_NavTMOneCell, std::allocator<fi_tcl_NavTMOneCell> > TMOneCell;

   virtual tVoid vDestroy();
   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual tBool operator==(const fi_tcl_NavTMOneCellListSet& rfoCmp) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   virtual tS32 s32GetTypeId() const { return typesfi_tclToken::EN_NAVTMONECELLLISTSET;}
   virtual tVoid vTakeVisitor(fi_tclVisitorBase& rfoVisitor);
};

class fi_tcl_e8_DataAvailable : public fi_tclVisitableTypeBase
{
public:
   fi_tcl_e8_DataAvailable():enType(FI_EN_NOTAVAILABLE) {}

   enum tenType {
      FI_EN_NOTAVAILABLE = 0UL,
      FI_EN_LIMITEDAVAILABLE = 1UL,
      FI_EN_FULLAVAILABLE = 2UL
   };
   tenType enType;

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual tBool operator==(const fi_tcl_e8_DataAvailable& rfoCmp) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   virtual tS32 s32GetTypeId() const { return typesfi_tclToken::EN_E8_DATAAVAILABLE;}
   virtual tVoid vTakeVisitor(fi_tclVisitorBase& rfoVisitor);
};

class fi_tcl_e8_NavLocationDescType : public fi_tclVisitableTypeBase
{
public:
   fi_tcl_e8_NavLocationDescType():enType(FI_EN_T_RESERVED) {}

   enum tenType {
      FI_EN_T_RESERVED = 0UL,
      FI_EN_T_NAVLOCATIONDATADESC = 1UL,
      FI_EN_T_NAVAREADESCRIPTIONCIRCLE = 2UL,
      FI_EN_T_NAVAREADESCRIPTIONPOLYGON = 3UL
   };
   tenType enType;

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual tBool operator==(const fi_tcl_e8_NavLocationDescType& rfoCmp) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   virtual tS32 s32GetTypeId() const { return typesfi_tclToken::EN_E8_NAVLOCATIONDESCTYPE;}
   virtual tVoid vTakeVisitor(fi_tclVisitorBase& rfoVisitor);
};

class fi_tcl_NavLocationDesc : public fi_tclVisitableTypeBase
{
public:
   fi_tcl_NavLocationDesc():poNavLocationDescTypeData(0) {}
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   fi_tcl_NavLocationDesc& operator=(const fi_tcl_NavLocationDesc& coRef);
   fi_tcl_NavLocationDesc(const fi_tcl_NavLocationDesc& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
   fi_tcl_e8_NavLocationDescType NavLocationDescTypeType;
   fi_tclTypeBase* poNavLocationDescTypeData;
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   virtual ~fi_tcl_NavLocationDesc();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   virtual tVoid vDestroy();
   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual tBool operator==(const fi_tcl_NavLocationDesc& rfoCmp) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   virtual tS32 s32GetTypeId() const { return typesfi_tclToken::EN_NAVLOCATIONDESC;}
   virtual tVoid vTakeVisitor(fi_tclVisitorBase& rfoVisitor);
};

#ifndef FI_S_EXTERNAL_FI
class fi_tcl_NavLocationBinContainer : public fi_tclVisitableTypeBase
{
public:
   fi_tcl_NavLocationBinContainer():ContainerLength(0),ServiceID(0),ContainerFIVersion(),ContainerType(),ContainerData() {}
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   fi_tcl_NavLocationBinContainer& operator=(const fi_tcl_NavLocationBinContainer& coRef);
   fi_tcl_NavLocationBinContainer(const fi_tcl_NavLocationBinContainer& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
   tU32 ContainerLength;
   tU16 ServiceID;
   fi_tcl_FIVersion ContainerFIVersion;
   fi_tcl_e8_BinContainerTypes ContainerType;
   fi_tcl_NavLocationDesc ContainerData;

   virtual tVoid vDestroy();
   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual tBool operator==(const fi_tcl_NavLocationBinContainer& rfoCmp) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   virtual tS32 s32GetTypeId() const { return typesfi_tclToken::EN_NAVLOCATIONBINCONTAINER;}
   virtual tVoid vTakeVisitor(fi_tclVisitorBase& rfoVisitor);
   tU16 u16Transform(const fi_tcl_BinContainer& oContainer);
   static const tU16 C_U16_MAJORVERSION_MAX;
   static const tU16 C_U16_MAJORVERSION_MIN;
};

#endif // FI_S_EXTERNAL_FI
class fi_tcl_e8_NavIndexZFDestinationType : public fi_tclVisitableTypeBase
{
public:
   fi_tcl_e8_NavIndexZFDestinationType():enType(FI_EN_CENTRE) {}

   enum tenType {
      FI_EN_CENTRE = 1UL,
      FI_EN_SPOT = 2UL,
      FI_EN_STREET = 3UL,
      FI_EN_HOUSENUMBER = 4UL
   };
   tenType enType;

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual tBool operator==(const fi_tcl_e8_NavIndexZFDestinationType& rfoCmp) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   virtual tS32 s32GetTypeId() const { return typesfi_tclToken::EN_E8_NAVINDEXZFDESTINATIONTYPE;}
   virtual tVoid vTakeVisitor(fi_tclVisitorBase& rfoVisitor);
};

class fi_tcl_e8_NavLocationNavDataType : public fi_tclVisitableTypeBase
{
public:
   fi_tcl_e8_NavLocationNavDataType():enType(FI_EN_T_RESERVED) {}

   enum tenType {
      FI_EN_T_RESERVED = 0UL,
      FI_EN_T_NAVINTERSECTIONDESTINATIONZEROCELLLISTSET = 1UL,
      FI_EN_T_NAVSTREETDESTINATIONONECELLLISTSET = 2UL,
      FI_EN_T_NAVSPOTDESTINATIONONECELLLISTSET = 3UL
   };
   tenType enType;

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual tBool operator==(const fi_tcl_e8_NavLocationNavDataType& rfoCmp) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   virtual tS32 s32GetTypeId() const { return typesfi_tclToken::EN_E8_NAVLOCATIONNAVDATATYPE;}
   virtual tVoid vTakeVisitor(fi_tclVisitorBase& rfoVisitor);
};

class fi_tcl_u32_DataSetId : public fi_tclVisitableTypeBase
{
public:
   fi_tcl_u32_DataSetId(tU32 _u32Value = 0):u32Value(_u32Value) {} 

   tU32 u32Value;

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual tBool operator==(const fi_tcl_u32_DataSetId& rfoCmp) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   virtual tS32 s32GetTypeId() const { return typesfi_tclToken::EN_U32_DATASETID;}
   virtual tVoid vTakeVisitor(fi_tclVisitorBase& rfoVisitor);
};

class fi_tcl_e8_SideInfo : public fi_tclVisitableTypeBase
{
public:
   fi_tcl_e8_SideInfo():enType(FI_EN_RESERVED) {}

   enum tenType {
      FI_EN_RESERVED = 0UL,
      FI_EN_LEFT = 1UL,
      FI_EN_RIGHT = 2UL,
      FI_EN_UNKNOWN = 3UL
   };
   tenType enType;

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual tBool operator==(const fi_tcl_e8_SideInfo& rfoCmp) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   virtual tS32 s32GetTypeId() const { return typesfi_tclToken::EN_E8_SIDEINFO;}
   virtual tVoid vTakeVisitor(fi_tclVisitorBase& rfoVisitor);
};

class fi_tcl_NavSpotDestinationOneCellProperty : public fi_tclVisitableTypeBase
{
public:
   fi_tcl_NavSpotDestinationOneCellProperty():SideInfo(),FromZeroCellToSpotLength(),OneCellLength(),DestDistance(),DecisionPoint(),IndexInObjectPointRefList(),IndexInAccessPointRefList() {}
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   fi_tcl_NavSpotDestinationOneCellProperty& operator=(const fi_tcl_NavSpotDestinationOneCellProperty& coRef);
   fi_tcl_NavSpotDestinationOneCellProperty(const fi_tcl_NavSpotDestinationOneCellProperty& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
   fi_tcl_e8_SideInfo SideInfo;
   fi_tcl_s32_EMU FromZeroCellToSpotLength;
   fi_tcl_s32_EMU OneCellLength;
   fi_tcl_s32_EMU DestDistance;
   fi_tcl_PositionWGS84 DecisionPoint;
   fi_tcl_u16_IndexInReferenceList IndexInObjectPointRefList;
   fi_tcl_u16_IndexInReferenceList IndexInAccessPointRefList;

   virtual tVoid vDestroy();
   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual tBool operator==(const fi_tcl_NavSpotDestinationOneCellProperty& rfoCmp) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   virtual tS32 s32GetTypeId() const { return typesfi_tclToken::EN_NAVSPOTDESTINATIONONECELLPROPERTY;}
   virtual tVoid vTakeVisitor(fi_tclVisitorBase& rfoVisitor);
};

class fi_tcl_NavSpotDestinationOneCellDesc : public fi_tclVisitableTypeBase
{
public:
   fi_tcl_NavSpotDestinationOneCellDesc():OneCellDesc(),OneCellProperty() {}
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   fi_tcl_NavSpotDestinationOneCellDesc& operator=(const fi_tcl_NavSpotDestinationOneCellDesc& coRef);
   fi_tcl_NavSpotDestinationOneCellDesc(const fi_tcl_NavSpotDestinationOneCellDesc& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
   fi_tcl_NavOneCellDesc OneCellDesc;
   fi_tcl_NavSpotDestinationOneCellProperty OneCellProperty;

   virtual tVoid vDestroy();
   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual tBool operator==(const fi_tcl_NavSpotDestinationOneCellDesc& rfoCmp) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   virtual tS32 s32GetTypeId() const { return typesfi_tclToken::EN_NAVSPOTDESTINATIONONECELLDESC;}
   virtual tVoid vTakeVisitor(fi_tclVisitorBase& rfoVisitor);
};

class fi_tcl_NavStreetDestinationOneCellProperty : public fi_tclVisitableTypeBase
{
public:
   fi_tcl_NavStreetDestinationOneCellProperty():SideInfo(),IndexInObjectPointRefList(),IndexInAccessPointRefList() {}
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   fi_tcl_NavStreetDestinationOneCellProperty& operator=(const fi_tcl_NavStreetDestinationOneCellProperty& coRef);
   fi_tcl_NavStreetDestinationOneCellProperty(const fi_tcl_NavStreetDestinationOneCellProperty& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
   fi_tcl_e8_SideInfo SideInfo;
   fi_tcl_u16_IndexInReferenceList IndexInObjectPointRefList;
   fi_tcl_u16_IndexInReferenceList IndexInAccessPointRefList;

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual tBool operator==(const fi_tcl_NavStreetDestinationOneCellProperty& rfoCmp) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   virtual tS32 s32GetTypeId() const { return typesfi_tclToken::EN_NAVSTREETDESTINATIONONECELLPROPERTY;}
   virtual tVoid vTakeVisitor(fi_tclVisitorBase& rfoVisitor);
};

class fi_tcl_NavStreetDestinationOneCellDesc : public fi_tclVisitableTypeBase
{
public:
   fi_tcl_NavStreetDestinationOneCellDesc():OneCellDesc(),OneCellProperty() {}
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   fi_tcl_NavStreetDestinationOneCellDesc& operator=(const fi_tcl_NavStreetDestinationOneCellDesc& coRef);
   fi_tcl_NavStreetDestinationOneCellDesc(const fi_tcl_NavStreetDestinationOneCellDesc& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
   fi_tcl_NavOneCellDesc OneCellDesc;
   fi_tcl_NavStreetDestinationOneCellProperty OneCellProperty;

   virtual tVoid vDestroy();
   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual tBool operator==(const fi_tcl_NavStreetDestinationOneCellDesc& rfoCmp) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   virtual tS32 s32GetTypeId() const { return typesfi_tclToken::EN_NAVSTREETDESTINATIONONECELLDESC;}
   virtual tVoid vTakeVisitor(fi_tclVisitorBase& rfoVisitor);
};

class fi_tcl_NavStreetDestinationOneCellListSet : public fi_tclVisitableTypeBase
{
public:
   fi_tcl_NavStreetDestinationOneCellListSet() {}
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   fi_tcl_NavStreetDestinationOneCellListSet& operator=(const fi_tcl_NavStreetDestinationOneCellListSet& coRef);
   fi_tcl_NavStreetDestinationOneCellListSet(const fi_tcl_NavStreetDestinationOneCellListSet& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
   std::vector<fi_tcl_NavClusterDesc, std::allocator<fi_tcl_NavClusterDesc> > ClusterRefList;
   std::vector<fi_tcl_NavStreetDestinationOneCellDesc, std::allocator<fi_tcl_NavStreetDestinationOneCellDesc> > StreetDestinationOneCellRefList;

   virtual tVoid vDestroy();
   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual tBool operator==(const fi_tcl_NavStreetDestinationOneCellListSet& rfoCmp) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   virtual tS32 s32GetTypeId() const { return typesfi_tclToken::EN_NAVSTREETDESTINATIONONECELLLISTSET;}
   virtual tVoid vTakeVisitor(fi_tclVisitorBase& rfoVisitor);
};

class fi_tcl_e8_NavIntersectionType : public fi_tclVisitableTypeBase
{
public:
   fi_tcl_e8_NavIntersectionType():enType(FI_EN_OBJECTINTERSECTION) {}

   enum tenType {
      FI_EN_OBJECTINTERSECTION = 1UL,
      FI_EN_COMPLEXINTERSECTION = 2UL,
      FI_EN_SIMPLEINTERSECTION = 3UL
   };
   tenType enType;

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual tBool operator==(const fi_tcl_e8_NavIntersectionType& rfoCmp) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   virtual tS32 s32GetTypeId() const { return typesfi_tclToken::EN_E8_NAVINTERSECTIONTYPE;}
   virtual tVoid vTakeVisitor(fi_tclVisitorBase& rfoVisitor);
};

class fi_tcl_NavZeroCellDesc : public fi_tclVisitableTypeBase
{
public:
   fi_tcl_NavZeroCellDesc():ZeroCellId(0),IndexInClusterRefList() {}
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   fi_tcl_NavZeroCellDesc& operator=(const fi_tcl_NavZeroCellDesc& coRef);
   fi_tcl_NavZeroCellDesc(const fi_tcl_NavZeroCellDesc& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
   tU16 ZeroCellId;
   fi_tcl_u16_IndexInReferenceList IndexInClusterRefList;

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual tBool operator==(const fi_tcl_NavZeroCellDesc& rfoCmp) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   virtual tS32 s32GetTypeId() const { return typesfi_tclToken::EN_NAVZEROCELLDESC;}
   virtual tVoid vTakeVisitor(fi_tclVisitorBase& rfoVisitor);
};

class fi_tcl_NavIntersectionDestinationZeroCellProperty : public fi_tclVisitableTypeBase
{
public:
   fi_tcl_NavIntersectionDestinationZeroCellProperty():IntersectionType(),IndexInObjectPointRefList(),IndexInAccessPointRefList() {}
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   fi_tcl_NavIntersectionDestinationZeroCellProperty& operator=(const fi_tcl_NavIntersectionDestinationZeroCellProperty& coRef);
   fi_tcl_NavIntersectionDestinationZeroCellProperty(const fi_tcl_NavIntersectionDestinationZeroCellProperty& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
   fi_tcl_e8_NavIntersectionType IntersectionType;
   fi_tcl_u16_IndexInReferenceList IndexInObjectPointRefList;
   fi_tcl_u16_IndexInReferenceList IndexInAccessPointRefList;

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual tBool operator==(const fi_tcl_NavIntersectionDestinationZeroCellProperty& rfoCmp) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   virtual tS32 s32GetTypeId() const { return typesfi_tclToken::EN_NAVINTERSECTIONDESTINATIONZEROCELLPROPERTY;}
   virtual tVoid vTakeVisitor(fi_tclVisitorBase& rfoVisitor);
};

class fi_tcl_NavIntersectionDestinationZeroCellDesc : public fi_tclVisitableTypeBase
{
public:
   fi_tcl_NavIntersectionDestinationZeroCellDesc():ZeroCellDesc(),ZeroCellProperty() {}
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   fi_tcl_NavIntersectionDestinationZeroCellDesc& operator=(const fi_tcl_NavIntersectionDestinationZeroCellDesc& coRef);
   fi_tcl_NavIntersectionDestinationZeroCellDesc(const fi_tcl_NavIntersectionDestinationZeroCellDesc& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
   fi_tcl_NavZeroCellDesc ZeroCellDesc;
   fi_tcl_NavIntersectionDestinationZeroCellProperty ZeroCellProperty;

   virtual tVoid vDestroy();
   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual tBool operator==(const fi_tcl_NavIntersectionDestinationZeroCellDesc& rfoCmp) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   virtual tS32 s32GetTypeId() const { return typesfi_tclToken::EN_NAVINTERSECTIONDESTINATIONZEROCELLDESC;}
   virtual tVoid vTakeVisitor(fi_tclVisitorBase& rfoVisitor);
};

class fi_tcl_NavAreaDescriptionCircle : public fi_tclVisitableTypeBase
{
public:
   fi_tcl_NavAreaDescriptionCircle():Radius(),Coordinate() {}
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   fi_tcl_NavAreaDescriptionCircle& operator=(const fi_tcl_NavAreaDescriptionCircle& coRef);
   fi_tcl_NavAreaDescriptionCircle(const fi_tcl_NavAreaDescriptionCircle& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
   fi_tcl_s32_Meter Radius;
   fi_tcl_PositionWGS84 Coordinate;

   virtual tVoid vDestroy();
   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual tBool operator==(const fi_tcl_NavAreaDescriptionCircle& rfoCmp) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   virtual tS32 s32GetTypeId() const { return typesfi_tclToken::EN_NAVAREADESCRIPTIONCIRCLE;}
   virtual tVoid vTakeVisitor(fi_tclVisitorBase& rfoVisitor);
};

class fi_tcl_NavAreaDescriptionPolygon : public fi_tclVisitableTypeBase
{
public:
   fi_tcl_NavAreaDescriptionPolygon() {}
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   fi_tcl_NavAreaDescriptionPolygon& operator=(const fi_tcl_NavAreaDescriptionPolygon& coRef);
   fi_tcl_NavAreaDescriptionPolygon(const fi_tcl_NavAreaDescriptionPolygon& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
   std::vector<fi_tcl_PositionWGS84, std::allocator<fi_tcl_PositionWGS84> > CoordinateList;

   virtual tVoid vDestroy();
   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual tBool operator==(const fi_tcl_NavAreaDescriptionPolygon& rfoCmp) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   virtual tS32 s32GetTypeId() const { return typesfi_tclToken::EN_NAVAREADESCRIPTIONPOLYGON;}
   virtual tVoid vTakeVisitor(fi_tclVisitorBase& rfoVisitor);
};

class fi_tcl_CountryInfo : public fi_tclVisitableTypeBase
{
public:
   fi_tcl_CountryInfo():CountryCode(),TrafficSense() {}
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   fi_tcl_CountryInfo& operator=(const fi_tcl_CountryInfo& coRef);
   fi_tcl_CountryInfo(const fi_tcl_CountryInfo& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
   fi_tcl_e16_ISOCountryCode CountryCode;
   fi_tcl_e8_SideInfo TrafficSense;

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual tBool operator==(const fi_tcl_CountryInfo& rfoCmp) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   virtual tS32 s32GetTypeId() const { return typesfi_tclToken::EN_COUNTRYINFO;}
   virtual tVoid vTakeVisitor(fi_tclVisitorBase& rfoVisitor);
};

class fi_tcl_u16_TripHandle : public fi_tclVisitableTypeBase
{
public:
   fi_tcl_u16_TripHandle(tU16 _u16Value = 0):u16Value(_u16Value) {} 

   tU16 u16Value;

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual tBool operator==(const fi_tcl_u16_TripHandle& rfoCmp) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   virtual tS32 s32GetTypeId() const { return typesfi_tclToken::EN_U16_TRIPHANDLE;}
   virtual tVoid vTakeVisitor(fi_tclVisitorBase& rfoVisitor);
};

class fi_tcl_b32_NavRouteStatus : public fi_tclVisitableTypeBase
{
public:
   fi_tcl_b32_NavRouteStatus():u32Value(0) {}

   enum {
      FI_C_U32_BIT_BTOLLROADSINRL = 0x1UL,
      FI_C_U32_BIT_BMOTORWAYSINRL = 0x2UL,
      FI_C_U32_BIT_BFERRIESINRL = 0x4UL,
      FI_C_U32_BIT_BTUNNELSINRL = 0x8UL,
      FI_C_U32_BIT_BBLOCKEDOCINRL = 0x10UL,
      FI_C_U32_BIT_BMANIPULATEDOCINRL = 0x20UL,
      FI_C_U32_BIT_BNOPASSOCINRL = 0x40UL,
      FI_C_U32_BIT_BRESTRICTEDOCINRL = 0x80UL,
      FI_C_U32_BIT_BNOPASSDESTAREAOC = 0x100UL,
      FI_C_U32_BIT_BRESTRICTEDDESTAREAOC = 0x200UL,
      FI_C_U32_BIT_BGUIDANCEROUTERESISEXTENDED = 0x800UL,
      FI_C_U32_BIT_BRELEASED = 0x1000UL,
      FI_C_U32_BIT_BPACKED = 0x2000UL,
      FI_C_U32_BIT_BMERGED = 0x4000UL,
      FI_C_U32_BIT_BISPRIMARYOUTOFCORRIDOR = 0x8000UL,
      FI_C_U32_BIT_BISSECUNDARYOUTOFCORRIDOR = 0x10000UL,
      FI_C_U32_BIT_BFREEWAYINRL = 0x20000UL,
      FI_C_U32_BIT_BSEASONALCLOSEDINRL = 0x40000UL,
      FI_C_U32_BIT_BMOTORWAYSINRLONLYATLEAFFILES = 0x80000UL,
      FI_C_U32_BIT_BFREEWAYSINRLONLYATLEAFFILES = 0x100000UL,
      FI_C_U32_BIT_BUNPAVEDROADSINRL = 0x200000UL,
      FI_C_U32_BIT_BTOLLBOOTHINRL = 0x400000UL
   };
   tBool bbTollRoadsInRL() const {return (u32Value & FI_C_U32_BIT_BTOLLROADSINRL) != 0; }
   tVoid vSetbTollRoadsInRL(tBool bSetBit) { u32Value = (bSetBit)?(u32Value | FI_C_U32_BIT_BTOLLROADSINRL):(u32Value & ~FI_C_U32_BIT_BTOLLROADSINRL); }
   tBool bbMotorwaysInRL() const {return (u32Value & FI_C_U32_BIT_BMOTORWAYSINRL) != 0; }
   tVoid vSetbMotorwaysInRL(tBool bSetBit) { u32Value = (bSetBit)?(u32Value | FI_C_U32_BIT_BMOTORWAYSINRL):(u32Value & ~FI_C_U32_BIT_BMOTORWAYSINRL); }
   tBool bbFerriesInRL() const {return (u32Value & FI_C_U32_BIT_BFERRIESINRL) != 0; }
   tVoid vSetbFerriesInRL(tBool bSetBit) { u32Value = (bSetBit)?(u32Value | FI_C_U32_BIT_BFERRIESINRL):(u32Value & ~FI_C_U32_BIT_BFERRIESINRL); }
   tBool bbTunnelsInRL() const {return (u32Value & FI_C_U32_BIT_BTUNNELSINRL) != 0; }
   tVoid vSetbTunnelsInRL(tBool bSetBit) { u32Value = (bSetBit)?(u32Value | FI_C_U32_BIT_BTUNNELSINRL):(u32Value & ~FI_C_U32_BIT_BTUNNELSINRL); }
   tBool bbBlockedOCInRL() const {return (u32Value & FI_C_U32_BIT_BBLOCKEDOCINRL) != 0; }
   tVoid vSetbBlockedOCInRL(tBool bSetBit) { u32Value = (bSetBit)?(u32Value | FI_C_U32_BIT_BBLOCKEDOCINRL):(u32Value & ~FI_C_U32_BIT_BBLOCKEDOCINRL); }
   tBool bbManipulatedOCInRL() const {return (u32Value & FI_C_U32_BIT_BMANIPULATEDOCINRL) != 0; }
   tVoid vSetbManipulatedOCInRL(tBool bSetBit) { u32Value = (bSetBit)?(u32Value | FI_C_U32_BIT_BMANIPULATEDOCINRL):(u32Value & ~FI_C_U32_BIT_BMANIPULATEDOCINRL); }
   tBool bbNoPassOCInRL() const {return (u32Value & FI_C_U32_BIT_BNOPASSOCINRL) != 0; }
   tVoid vSetbNoPassOCInRL(tBool bSetBit) { u32Value = (bSetBit)?(u32Value | FI_C_U32_BIT_BNOPASSOCINRL):(u32Value & ~FI_C_U32_BIT_BNOPASSOCINRL); }
   tBool bbRestrictedOCInRL() const {return (u32Value & FI_C_U32_BIT_BRESTRICTEDOCINRL) != 0; }
   tVoid vSetbRestrictedOCInRL(tBool bSetBit) { u32Value = (bSetBit)?(u32Value | FI_C_U32_BIT_BRESTRICTEDOCINRL):(u32Value & ~FI_C_U32_BIT_BRESTRICTEDOCINRL); }
   tBool bbNoPassDestAreaOC() const {return (u32Value & FI_C_U32_BIT_BNOPASSDESTAREAOC) != 0; }
   tVoid vSetbNoPassDestAreaOC(tBool bSetBit) { u32Value = (bSetBit)?(u32Value | FI_C_U32_BIT_BNOPASSDESTAREAOC):(u32Value & ~FI_C_U32_BIT_BNOPASSDESTAREAOC); }
   tBool bbRestrictedDestAreaOC() const {return (u32Value & FI_C_U32_BIT_BRESTRICTEDDESTAREAOC) != 0; }
   tVoid vSetbRestrictedDestAreaOC(tBool bSetBit) { u32Value = (bSetBit)?(u32Value | FI_C_U32_BIT_BRESTRICTEDDESTAREAOC):(u32Value & ~FI_C_U32_BIT_BRESTRICTEDDESTAREAOC); }
   tBool bbGuidanceRouteResIsExtended() const {return (u32Value & FI_C_U32_BIT_BGUIDANCEROUTERESISEXTENDED) != 0; }
   tVoid vSetbGuidanceRouteResIsExtended(tBool bSetBit) { u32Value = (bSetBit)?(u32Value | FI_C_U32_BIT_BGUIDANCEROUTERESISEXTENDED):(u32Value & ~FI_C_U32_BIT_BGUIDANCEROUTERESISEXTENDED); }
   tBool bbReleased() const {return (u32Value & FI_C_U32_BIT_BRELEASED) != 0; }
   tVoid vSetbReleased(tBool bSetBit) { u32Value = (bSetBit)?(u32Value | FI_C_U32_BIT_BRELEASED):(u32Value & ~FI_C_U32_BIT_BRELEASED); }
   tBool bbPacked() const {return (u32Value & FI_C_U32_BIT_BPACKED) != 0; }
   tVoid vSetbPacked(tBool bSetBit) { u32Value = (bSetBit)?(u32Value | FI_C_U32_BIT_BPACKED):(u32Value & ~FI_C_U32_BIT_BPACKED); }
   tBool bbMerged() const {return (u32Value & FI_C_U32_BIT_BMERGED) != 0; }
   tVoid vSetbMerged(tBool bSetBit) { u32Value = (bSetBit)?(u32Value | FI_C_U32_BIT_BMERGED):(u32Value & ~FI_C_U32_BIT_BMERGED); }
   tBool bbIsPrimaryOutOfCorridor() const {return (u32Value & FI_C_U32_BIT_BISPRIMARYOUTOFCORRIDOR) != 0; }
   tVoid vSetbIsPrimaryOutOfCorridor(tBool bSetBit) { u32Value = (bSetBit)?(u32Value | FI_C_U32_BIT_BISPRIMARYOUTOFCORRIDOR):(u32Value & ~FI_C_U32_BIT_BISPRIMARYOUTOFCORRIDOR); }
   tBool bbIsSecundaryOutOfCorridor() const {return (u32Value & FI_C_U32_BIT_BISSECUNDARYOUTOFCORRIDOR) != 0; }
   tVoid vSetbIsSecundaryOutOfCorridor(tBool bSetBit) { u32Value = (bSetBit)?(u32Value | FI_C_U32_BIT_BISSECUNDARYOUTOFCORRIDOR):(u32Value & ~FI_C_U32_BIT_BISSECUNDARYOUTOFCORRIDOR); }
   tBool bbFreewayInRL() const {return (u32Value & FI_C_U32_BIT_BFREEWAYINRL) != 0; }
   tVoid vSetbFreewayInRL(tBool bSetBit) { u32Value = (bSetBit)?(u32Value | FI_C_U32_BIT_BFREEWAYINRL):(u32Value & ~FI_C_U32_BIT_BFREEWAYINRL); }
   tBool bbSeasonalClosedInRL() const {return (u32Value & FI_C_U32_BIT_BSEASONALCLOSEDINRL) != 0; }
   tVoid vSetbSeasonalClosedInRL(tBool bSetBit) { u32Value = (bSetBit)?(u32Value | FI_C_U32_BIT_BSEASONALCLOSEDINRL):(u32Value & ~FI_C_U32_BIT_BSEASONALCLOSEDINRL); }
   tBool bbMotorwaysInRLOnlyAtLeafFiles() const {return (u32Value & FI_C_U32_BIT_BMOTORWAYSINRLONLYATLEAFFILES) != 0; }
   tVoid vSetbMotorwaysInRLOnlyAtLeafFiles(tBool bSetBit) { u32Value = (bSetBit)?(u32Value | FI_C_U32_BIT_BMOTORWAYSINRLONLYATLEAFFILES):(u32Value & ~FI_C_U32_BIT_BMOTORWAYSINRLONLYATLEAFFILES); }
   tBool bbFreewaysInRLOnlyAtLeafFiles() const {return (u32Value & FI_C_U32_BIT_BFREEWAYSINRLONLYATLEAFFILES) != 0; }
   tVoid vSetbFreewaysInRLOnlyAtLeafFiles(tBool bSetBit) { u32Value = (bSetBit)?(u32Value | FI_C_U32_BIT_BFREEWAYSINRLONLYATLEAFFILES):(u32Value & ~FI_C_U32_BIT_BFREEWAYSINRLONLYATLEAFFILES); }
   tBool bbUnpavedRoadsInRL() const {return (u32Value & FI_C_U32_BIT_BUNPAVEDROADSINRL) != 0; }
   tVoid vSetbUnpavedRoadsInRL(tBool bSetBit) { u32Value = (bSetBit)?(u32Value | FI_C_U32_BIT_BUNPAVEDROADSINRL):(u32Value & ~FI_C_U32_BIT_BUNPAVEDROADSINRL); }
   tBool bbTollBoothInRL() const {return (u32Value & FI_C_U32_BIT_BTOLLBOOTHINRL) != 0; }
   tVoid vSetbTollBoothInRL(tBool bSetBit) { u32Value = (bSetBit)?(u32Value | FI_C_U32_BIT_BTOLLBOOTHINRL):(u32Value & ~FI_C_U32_BIT_BTOLLBOOTHINRL); }
   struct rBitValues {
      unsigned int bTollRoadsInRL:1;
      unsigned int bMotorwaysInRL:1;
      unsigned int bFerriesInRL:1;
      unsigned int bTunnelsInRL:1;
      unsigned int bBlockedOCInRL:1;
      unsigned int bManipulatedOCInRL:1;
      unsigned int bNoPassOCInRL:1;
      unsigned int bRestrictedOCInRL:1;
      unsigned int bNoPassDestAreaOC:1;
      unsigned int bRestrictedDestAreaOC:1;
      unsigned int dummy10:1;
      unsigned int bGuidanceRouteResIsExtended:1;
      unsigned int bReleased:1;
      unsigned int bPacked:1;
      unsigned int bMerged:1;
      unsigned int bIsPrimaryOutOfCorridor:1;
      unsigned int bIsSecundaryOutOfCorridor:1;
      unsigned int bFreewayInRL:1;
      unsigned int bSeasonalClosedInRL:1;
      unsigned int bMotorwaysInRLOnlyAtLeafFiles:1;
      unsigned int bFreewaysInRLOnlyAtLeafFiles:1;
      unsigned int bUnpavedRoadsInRL:1;
      unsigned int bTollBoothInRL:1;
      unsigned int dummy23:1;
      unsigned int dummy24:1;
      unsigned int dummy25:1;
      unsigned int dummy26:1;
      unsigned int dummy27:1;
      unsigned int dummy28:1;
      unsigned int dummy29:1;
      unsigned int dummy30:1;
      unsigned int dummy31:1;
   };
   union {
      tU32 u32Value;
      rBitValues bits;
   };

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual tBool operator==(const fi_tcl_b32_NavRouteStatus& rfoCmp) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   virtual tS32 s32GetTypeId() const { return typesfi_tclToken::EN_B32_NAVROUTESTATUS;}
   virtual tVoid vTakeVisitor(fi_tclVisitorBase& rfoVisitor);
};

class fi_tcl_b32_ExtNavRouteStatus : public fi_tclVisitableTypeBase
{
public:
   fi_tcl_b32_ExtNavRouteStatus():u32Value(0) {}

   enum {
      FI_C_U32_BIT_BRLHASSECTIONSWITHOUTTRUCKATTRIBUTATION = 0x1UL,
      FI_C_U32_BIT_BVEHICLEDIMENSIONEXCEEDEDINRL = 0x2UL,
      FI_C_U32_BIT_BPROHIBITIONFORDANGEROUSGOODSINRL = 0x4UL,
      FI_C_U32_BIT_BPROHIBITIONFORWATERPOLLUTINGGOODSINRL = 0x8UL,
      FI_C_U32_BIT_BPROHIBITIONFOREXPLOSIVEGOODSINRL = 0x10UL,
      FI_C_U32_BIT_BSTRONGGRADIENTINRL = 0x20UL,
      FI_C_U32_BIT_BSHARPCURVEINRL = 0x40UL,
      FI_C_U32_BIT_BMULTIPLESHARPCURVESINRL = 0x80UL,
      FI_C_U32_BIT_BMANDATORYSNOWCHAININRL = 0x100UL,
      FI_C_U32_BIT_BRISKOFSKIDDINGINRL = 0x200UL,
      FI_C_U32_BIT_BRISKOFSIDEWINDINRL = 0x400UL,
      FI_C_U32_BIT_BRISKOFSNOWSLIPPERINESSINRL = 0x800UL,
      FI_C_U32_BIT_BTRUCKPROHIBITIONINRL = 0x1000UL,
      FI_C_U32_BIT_BTRAILERPROHIBITIONINRL = 0x2000UL,
      FI_C_U32_BIT_BREQUIREDPERMISSIONINRL = 0x4000UL,
      FI_C_U32_BIT_BPROHIBITEDTURNSINROUTELIST = 0x8000UL,
      FI_C_U32_BIT_BREGULARADMINCLOSEDINRL = 0x10000UL,
      FI_C_U32_BIT_BINCONSTRUCTIONINRL = 0x20000UL,
      FI_C_U32_BIT_BHOVROADSINRL = 0x40000UL,
      FI_C_U32_BIT_BAUTOTRAININRL = 0x80000UL
   };
   tBool bbRLHasSectionsWithoutTruckAttributation() const {return (u32Value & FI_C_U32_BIT_BRLHASSECTIONSWITHOUTTRUCKATTRIBUTATION) != 0; }
   tVoid vSetbRLHasSectionsWithoutTruckAttributation(tBool bSetBit) { u32Value = (bSetBit)?(u32Value | FI_C_U32_BIT_BRLHASSECTIONSWITHOUTTRUCKATTRIBUTATION):(u32Value & ~FI_C_U32_BIT_BRLHASSECTIONSWITHOUTTRUCKATTRIBUTATION); }
   tBool bbVehicleDimensionExceededInRL() const {return (u32Value & FI_C_U32_BIT_BVEHICLEDIMENSIONEXCEEDEDINRL) != 0; }
   tVoid vSetbVehicleDimensionExceededInRL(tBool bSetBit) { u32Value = (bSetBit)?(u32Value | FI_C_U32_BIT_BVEHICLEDIMENSIONEXCEEDEDINRL):(u32Value & ~FI_C_U32_BIT_BVEHICLEDIMENSIONEXCEEDEDINRL); }
   tBool bbProhibitionForDangerousGoodsInRL() const {return (u32Value & FI_C_U32_BIT_BPROHIBITIONFORDANGEROUSGOODSINRL) != 0; }
   tVoid vSetbProhibitionForDangerousGoodsInRL(tBool bSetBit) { u32Value = (bSetBit)?(u32Value | FI_C_U32_BIT_BPROHIBITIONFORDANGEROUSGOODSINRL):(u32Value & ~FI_C_U32_BIT_BPROHIBITIONFORDANGEROUSGOODSINRL); }
   tBool bbProhibitionForWaterPollutingGoodsInRL() const {return (u32Value & FI_C_U32_BIT_BPROHIBITIONFORWATERPOLLUTINGGOODSINRL) != 0; }
   tVoid vSetbProhibitionForWaterPollutingGoodsInRL(tBool bSetBit) { u32Value = (bSetBit)?(u32Value | FI_C_U32_BIT_BPROHIBITIONFORWATERPOLLUTINGGOODSINRL):(u32Value & ~FI_C_U32_BIT_BPROHIBITIONFORWATERPOLLUTINGGOODSINRL); }
   tBool bbProhibitionForExplosiveGoodsInRL() const {return (u32Value & FI_C_U32_BIT_BPROHIBITIONFOREXPLOSIVEGOODSINRL) != 0; }
   tVoid vSetbProhibitionForExplosiveGoodsInRL(tBool bSetBit) { u32Value = (bSetBit)?(u32Value | FI_C_U32_BIT_BPROHIBITIONFOREXPLOSIVEGOODSINRL):(u32Value & ~FI_C_U32_BIT_BPROHIBITIONFOREXPLOSIVEGOODSINRL); }
   tBool bbStrongGradientInRL() const {return (u32Value & FI_C_U32_BIT_BSTRONGGRADIENTINRL) != 0; }
   tVoid vSetbStrongGradientInRL(tBool bSetBit) { u32Value = (bSetBit)?(u32Value | FI_C_U32_BIT_BSTRONGGRADIENTINRL):(u32Value & ~FI_C_U32_BIT_BSTRONGGRADIENTINRL); }
   tBool bbSharpCurveInRL() const {return (u32Value & FI_C_U32_BIT_BSHARPCURVEINRL) != 0; }
   tVoid vSetbSharpCurveInRL(tBool bSetBit) { u32Value = (bSetBit)?(u32Value | FI_C_U32_BIT_BSHARPCURVEINRL):(u32Value & ~FI_C_U32_BIT_BSHARPCURVEINRL); }
   tBool bbMultipleSharpCurvesInRL() const {return (u32Value & FI_C_U32_BIT_BMULTIPLESHARPCURVESINRL) != 0; }
   tVoid vSetbMultipleSharpCurvesInRL(tBool bSetBit) { u32Value = (bSetBit)?(u32Value | FI_C_U32_BIT_BMULTIPLESHARPCURVESINRL):(u32Value & ~FI_C_U32_BIT_BMULTIPLESHARPCURVESINRL); }
   tBool bbMandatorySnowChainInRL() const {return (u32Value & FI_C_U32_BIT_BMANDATORYSNOWCHAININRL) != 0; }
   tVoid vSetbMandatorySnowChainInRL(tBool bSetBit) { u32Value = (bSetBit)?(u32Value | FI_C_U32_BIT_BMANDATORYSNOWCHAININRL):(u32Value & ~FI_C_U32_BIT_BMANDATORYSNOWCHAININRL); }
   tBool bbRiskOfSkiddingInRL() const {return (u32Value & FI_C_U32_BIT_BRISKOFSKIDDINGINRL) != 0; }
   tVoid vSetbRiskOfSkiddingInRL(tBool bSetBit) { u32Value = (bSetBit)?(u32Value | FI_C_U32_BIT_BRISKOFSKIDDINGINRL):(u32Value & ~FI_C_U32_BIT_BRISKOFSKIDDINGINRL); }
   tBool bbRiskOfSidewindInRL() const {return (u32Value & FI_C_U32_BIT_BRISKOFSIDEWINDINRL) != 0; }
   tVoid vSetbRiskOfSidewindInRL(tBool bSetBit) { u32Value = (bSetBit)?(u32Value | FI_C_U32_BIT_BRISKOFSIDEWINDINRL):(u32Value & ~FI_C_U32_BIT_BRISKOFSIDEWINDINRL); }
   tBool bbRiskOfSnowSlipperinessInRL() const {return (u32Value & FI_C_U32_BIT_BRISKOFSNOWSLIPPERINESSINRL) != 0; }
   tVoid vSetbRiskOfSnowSlipperinessInRL(tBool bSetBit) { u32Value = (bSetBit)?(u32Value | FI_C_U32_BIT_BRISKOFSNOWSLIPPERINESSINRL):(u32Value & ~FI_C_U32_BIT_BRISKOFSNOWSLIPPERINESSINRL); }
   tBool bbTruckProhibitionInRL() const {return (u32Value & FI_C_U32_BIT_BTRUCKPROHIBITIONINRL) != 0; }
   tVoid vSetbTruckProhibitionInRL(tBool bSetBit) { u32Value = (bSetBit)?(u32Value | FI_C_U32_BIT_BTRUCKPROHIBITIONINRL):(u32Value & ~FI_C_U32_BIT_BTRUCKPROHIBITIONINRL); }
   tBool bbTrailerProhibitionInRL() const {return (u32Value & FI_C_U32_BIT_BTRAILERPROHIBITIONINRL) != 0; }
   tVoid vSetbTrailerProhibitionInRL(tBool bSetBit) { u32Value = (bSetBit)?(u32Value | FI_C_U32_BIT_BTRAILERPROHIBITIONINRL):(u32Value & ~FI_C_U32_BIT_BTRAILERPROHIBITIONINRL); }
   tBool bbRequiredPermissionInRL() const {return (u32Value & FI_C_U32_BIT_BREQUIREDPERMISSIONINRL) != 0; }
   tVoid vSetbRequiredPermissionInRL(tBool bSetBit) { u32Value = (bSetBit)?(u32Value | FI_C_U32_BIT_BREQUIREDPERMISSIONINRL):(u32Value & ~FI_C_U32_BIT_BREQUIREDPERMISSIONINRL); }
   tBool bbProhibitedTurnsInRouteList() const {return (u32Value & FI_C_U32_BIT_BPROHIBITEDTURNSINROUTELIST) != 0; }
   tVoid vSetbProhibitedTurnsInRouteList(tBool bSetBit) { u32Value = (bSetBit)?(u32Value | FI_C_U32_BIT_BPROHIBITEDTURNSINROUTELIST):(u32Value & ~FI_C_U32_BIT_BPROHIBITEDTURNSINROUTELIST); }
   tBool bbRegularAdminClosedInRL() const {return (u32Value & FI_C_U32_BIT_BREGULARADMINCLOSEDINRL) != 0; }
   tVoid vSetbRegularAdminClosedInRL(tBool bSetBit) { u32Value = (bSetBit)?(u32Value | FI_C_U32_BIT_BREGULARADMINCLOSEDINRL):(u32Value & ~FI_C_U32_BIT_BREGULARADMINCLOSEDINRL); }
   tBool bbInConstructionInRL() const {return (u32Value & FI_C_U32_BIT_BINCONSTRUCTIONINRL) != 0; }
   tVoid vSetbInConstructionInRL(tBool bSetBit) { u32Value = (bSetBit)?(u32Value | FI_C_U32_BIT_BINCONSTRUCTIONINRL):(u32Value & ~FI_C_U32_BIT_BINCONSTRUCTIONINRL); }
   tBool bbHOVRoadsInRL() const {return (u32Value & FI_C_U32_BIT_BHOVROADSINRL) != 0; }
   tVoid vSetbHOVRoadsInRL(tBool bSetBit) { u32Value = (bSetBit)?(u32Value | FI_C_U32_BIT_BHOVROADSINRL):(u32Value & ~FI_C_U32_BIT_BHOVROADSINRL); }
   tBool bbAutoTrainInRL() const {return (u32Value & FI_C_U32_BIT_BAUTOTRAININRL) != 0; }
   tVoid vSetbAutoTrainInRL(tBool bSetBit) { u32Value = (bSetBit)?(u32Value | FI_C_U32_BIT_BAUTOTRAININRL):(u32Value & ~FI_C_U32_BIT_BAUTOTRAININRL); }
   struct rBitValues {
      unsigned int bRLHasSectionsWithoutTruckAttributation:1;
      unsigned int bVehicleDimensionExceededInRL:1;
      unsigned int bProhibitionForDangerousGoodsInRL:1;
      unsigned int bProhibitionForWaterPollutingGoodsInRL:1;
      unsigned int bProhibitionForExplosiveGoodsInRL:1;
      unsigned int bStrongGradientInRL:1;
      unsigned int bSharpCurveInRL:1;
      unsigned int bMultipleSharpCurvesInRL:1;
      unsigned int bMandatorySnowChainInRL:1;
      unsigned int bRiskOfSkiddingInRL:1;
      unsigned int bRiskOfSidewindInRL:1;
      unsigned int bRiskOfSnowSlipperinessInRL:1;
      unsigned int bTruckProhibitionInRL:1;
      unsigned int bTrailerProhibitionInRL:1;
      unsigned int bRequiredPermissionInRL:1;
      unsigned int bProhibitedTurnsInRouteList:1;
      unsigned int bRegularAdminClosedInRL:1;
      unsigned int bInConstructionInRL:1;
      unsigned int bHOVRoadsInRL:1;
      unsigned int bAutoTrainInRL:1;
      unsigned int dummy20:1;
      unsigned int dummy21:1;
      unsigned int dummy22:1;
      unsigned int dummy23:1;
      unsigned int dummy24:1;
      unsigned int dummy25:1;
      unsigned int dummy26:1;
      unsigned int dummy27:1;
      unsigned int dummy28:1;
      unsigned int dummy29:1;
      unsigned int dummy30:1;
      unsigned int dummy31:1;
   };
   union {
      tU32 u32Value;
      rBitValues bits;
   };

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual tBool operator==(const fi_tcl_b32_ExtNavRouteStatus& rfoCmp) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   virtual tS32 s32GetTypeId() const { return typesfi_tclToken::EN_B32_EXTNAVROUTESTATUS;}
   virtual tVoid vTakeVisitor(fi_tclVisitorBase& rfoVisitor);
};

class fi_tcl_NavRouteInfo : public fi_tclVisitableTypeBase
{
public:
   fi_tcl_NavRouteInfo():MaxClusterLevel(0),InfoStatus(),ExtInfoStatus() {}
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   fi_tcl_NavRouteInfo& operator=(const fi_tcl_NavRouteInfo& coRef);
   fi_tcl_NavRouteInfo(const fi_tcl_NavRouteInfo& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
   tU8 MaxClusterLevel;
   fi_tcl_b32_NavRouteStatus InfoStatus;
   fi_tcl_b32_ExtNavRouteStatus ExtInfoStatus;

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual tBool operator==(const fi_tcl_NavRouteInfo& rfoCmp) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   virtual tS32 s32GetTypeId() const { return typesfi_tclToken::EN_NAVROUTEINFO;}
   virtual tVoid vTakeVisitor(fi_tclVisitorBase& rfoVisitor);
};

class fi_tcl_u16_TripSegmentNumber : public fi_tclVisitableTypeBase
{
public:
   fi_tcl_u16_TripSegmentNumber(tU16 _u16Value = 0):u16Value(_u16Value) {} 

   tU16 u16Value;

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual tBool operator==(const fi_tcl_u16_TripSegmentNumber& rfoCmp) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   virtual tS32 s32GetTypeId() const { return typesfi_tclToken::EN_U16_TRIPSEGMENTNUMBER;}
   virtual tVoid vTakeVisitor(fi_tclVisitorBase& rfoVisitor);
};

class fi_tcl_e8_ManoeuvreCriticality : public fi_tclVisitableTypeBase
{
public:
   fi_tcl_e8_ManoeuvreCriticality():enType(FI_EN_UNDEFINED) {}

   enum tenType {
      FI_EN_UNDEFINED = 0UL,
      FI_EN_NORMAL = 1UL,
      FI_EN_MIDDLE = 2UL,
      FI_EN_HIGH = 3UL
   };
   tenType enType;

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual tBool operator==(const fi_tcl_e8_ManoeuvreCriticality& rfoCmp) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   virtual tS32 s32GetTypeId() const { return typesfi_tclToken::EN_E8_MANOEUVRECRITICALITY;}
   virtual tVoid vTakeVisitor(fi_tclVisitorBase& rfoVisitor);
};

class fi_tcl_NavRouteDestinationDesc : public fi_tclVisitableTypeBase
{
public:
   fi_tcl_NavRouteDestinationDesc():IsSpotDestination(0),SubDestinationNumber(0),ObjectPoint(),DecisionPoint() {}
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   fi_tcl_NavRouteDestinationDesc& operator=(const fi_tcl_NavRouteDestinationDesc& coRef);
   fi_tcl_NavRouteDestinationDesc(const fi_tcl_NavRouteDestinationDesc& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
   tBool IsSpotDestination;
   tU16 SubDestinationNumber;
   fi_tcl_PositionWGS84 ObjectPoint;
   fi_tcl_PositionWGS84 DecisionPoint;

   virtual tVoid vDestroy();
   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual tBool operator==(const fi_tcl_NavRouteDestinationDesc& rfoCmp) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   virtual tS32 s32GetTypeId() const { return typesfi_tclToken::EN_NAVROUTEDESTINATIONDESC;}
   virtual tVoid vTakeVisitor(fi_tclVisitorBase& rfoVisitor);
};

class fi_tcl_b32_NavRouteOneCellStatus : public fi_tclVisitableTypeBase
{
public:
   fi_tcl_b32_NavRouteOneCellStatus():u32Value(0) {}

   enum {
      FI_C_U32_BIT_BISPARTIALMOTORWAY = 0x1UL,
      FI_C_U32_BIT_BISCOMPLETEMOTORWAY = 0x2UL,
      FI_C_U32_BIT_BISPARTIALFERRY = 0x4UL,
      FI_C_U32_BIT_BISCOMPLETEFERRY = 0x8UL,
      FI_C_U32_BIT_BISPARTIALTOLLROAD = 0x10UL,
      FI_C_U32_BIT_BISCOMPLETETOLLROAD = 0x20UL,
      FI_C_U32_BIT_BISPARTIALTUNNEL = 0x40UL,
      FI_C_U32_BIT_BISCOMPLETETUNNEL = 0x80UL,
      FI_C_U32_BIT_BISNOPASS = 0x100UL,
      FI_C_U32_BIT_BISRESTRICTED = 0x200UL,
      FI_C_U32_BIT_BISBLOCKADE = 0x400UL,
      FI_C_U32_BIT_BISOCWIDMANIPULATED = 0x800UL,
      FI_C_U32_BIT_BISNOPASSDESTAREAOC = 0x1000UL,
      FI_C_U32_BIT_BISRESTRICTEDDESTAREAOC = 0x2000UL,
      FI_C_U32_BIT_BISDESTINATION = 0x4000UL,
      FI_C_U32_BIT_BISBUILTUPAREA = 0x8000UL,
      FI_C_U32_BIT_BISCOLLAPSEDONECELL = 0x10000UL,
      FI_C_U32_BIT_BISTURNPOSSIBLEATNEXTZC = 0x20000UL,
      FI_C_U32_BIT_BISCOMPLEXINTERSECTION = 0x40000UL,
      FI_C_U32_BIT_BISOBJECT = 0x80000UL,
      FI_C_U32_BIT_BISMORETHANTWOC1CATNEXTZC = 0x100000UL,
      FI_C_U32_BIT_BISONLYNONOBJPARKINGATNEXTZC = 0x200000UL,
      FI_C_U32_BIT_BISONBORDEROFGCL = 0x400000UL,
      FI_C_U32_BIT_BISUPLINK = 0x800000UL,
      FI_C_U32_BIT_BISPRIMARYOUTOFCORRIDOR = 0x1000000UL,
      FI_C_U32_BIT_BISSECUNDARYOUTOFCORRIDOR = 0x2000000UL,
      FI_C_U32_BIT_BISFIRSTINCOMPLEXINTERSECTION = 0x4000000UL,
      FI_C_U32_BIT_BISPREPATHOFCOMPLEXINTERSECTION = 0x8000000UL,
      FI_C_U32_BIT_BISPARTIALFREEWAY = 0x10000000UL,
      FI_C_U32_BIT_BISCOMPLETEFREEWAY = 0x20000000UL,
      FI_C_U32_BIT_BISPARTIALSEASONALCLOSED = 0x40000000UL,
      FI_C_U32_BIT_BISCOMPLETESEASONALCLOSED = 0x80000000UL
   };
   tBool bbIsPartialMotorway() const {return (u32Value & FI_C_U32_BIT_BISPARTIALMOTORWAY) != 0; }
   tVoid vSetbIsPartialMotorway(tBool bSetBit) { u32Value = (bSetBit)?(u32Value | FI_C_U32_BIT_BISPARTIALMOTORWAY):(u32Value & ~FI_C_U32_BIT_BISPARTIALMOTORWAY); }
   tBool bbIsCompleteMotorway() const {return (u32Value & FI_C_U32_BIT_BISCOMPLETEMOTORWAY) != 0; }
   tVoid vSetbIsCompleteMotorway(tBool bSetBit) { u32Value = (bSetBit)?(u32Value | FI_C_U32_BIT_BISCOMPLETEMOTORWAY):(u32Value & ~FI_C_U32_BIT_BISCOMPLETEMOTORWAY); }
   tBool bbIsPartialFerry() const {return (u32Value & FI_C_U32_BIT_BISPARTIALFERRY) != 0; }
   tVoid vSetbIsPartialFerry(tBool bSetBit) { u32Value = (bSetBit)?(u32Value | FI_C_U32_BIT_BISPARTIALFERRY):(u32Value & ~FI_C_U32_BIT_BISPARTIALFERRY); }
   tBool bbIsCompleteFerry() const {return (u32Value & FI_C_U32_BIT_BISCOMPLETEFERRY) != 0; }
   tVoid vSetbIsCompleteFerry(tBool bSetBit) { u32Value = (bSetBit)?(u32Value | FI_C_U32_BIT_BISCOMPLETEFERRY):(u32Value & ~FI_C_U32_BIT_BISCOMPLETEFERRY); }
   tBool bbIsPartialTollRoad() const {return (u32Value & FI_C_U32_BIT_BISPARTIALTOLLROAD) != 0; }
   tVoid vSetbIsPartialTollRoad(tBool bSetBit) { u32Value = (bSetBit)?(u32Value | FI_C_U32_BIT_BISPARTIALTOLLROAD):(u32Value & ~FI_C_U32_BIT_BISPARTIALTOLLROAD); }
   tBool bbIsCompleteTollRoad() const {return (u32Value & FI_C_U32_BIT_BISCOMPLETETOLLROAD) != 0; }
   tVoid vSetbIsCompleteTollRoad(tBool bSetBit) { u32Value = (bSetBit)?(u32Value | FI_C_U32_BIT_BISCOMPLETETOLLROAD):(u32Value & ~FI_C_U32_BIT_BISCOMPLETETOLLROAD); }
   tBool bbIsPartialTunnel() const {return (u32Value & FI_C_U32_BIT_BISPARTIALTUNNEL) != 0; }
   tVoid vSetbIsPartialTunnel(tBool bSetBit) { u32Value = (bSetBit)?(u32Value | FI_C_U32_BIT_BISPARTIALTUNNEL):(u32Value & ~FI_C_U32_BIT_BISPARTIALTUNNEL); }
   tBool bbIsCompleteTunnel() const {return (u32Value & FI_C_U32_BIT_BISCOMPLETETUNNEL) != 0; }
   tVoid vSetbIsCompleteTunnel(tBool bSetBit) { u32Value = (bSetBit)?(u32Value | FI_C_U32_BIT_BISCOMPLETETUNNEL):(u32Value & ~FI_C_U32_BIT_BISCOMPLETETUNNEL); }
   tBool bbIsNoPass() const {return (u32Value & FI_C_U32_BIT_BISNOPASS) != 0; }
   tVoid vSetbIsNoPass(tBool bSetBit) { u32Value = (bSetBit)?(u32Value | FI_C_U32_BIT_BISNOPASS):(u32Value & ~FI_C_U32_BIT_BISNOPASS); }
   tBool bbIsRestricted() const {return (u32Value & FI_C_U32_BIT_BISRESTRICTED) != 0; }
   tVoid vSetbIsRestricted(tBool bSetBit) { u32Value = (bSetBit)?(u32Value | FI_C_U32_BIT_BISRESTRICTED):(u32Value & ~FI_C_U32_BIT_BISRESTRICTED); }
   tBool bbIsBlockade() const {return (u32Value & FI_C_U32_BIT_BISBLOCKADE) != 0; }
   tVoid vSetbIsBlockade(tBool bSetBit) { u32Value = (bSetBit)?(u32Value | FI_C_U32_BIT_BISBLOCKADE):(u32Value & ~FI_C_U32_BIT_BISBLOCKADE); }
   tBool bbIsOCWidManipulated() const {return (u32Value & FI_C_U32_BIT_BISOCWIDMANIPULATED) != 0; }
   tVoid vSetbIsOCWidManipulated(tBool bSetBit) { u32Value = (bSetBit)?(u32Value | FI_C_U32_BIT_BISOCWIDMANIPULATED):(u32Value & ~FI_C_U32_BIT_BISOCWIDMANIPULATED); }
   tBool bbIsNoPassDestAreaOC() const {return (u32Value & FI_C_U32_BIT_BISNOPASSDESTAREAOC) != 0; }
   tVoid vSetbIsNoPassDestAreaOC(tBool bSetBit) { u32Value = (bSetBit)?(u32Value | FI_C_U32_BIT_BISNOPASSDESTAREAOC):(u32Value & ~FI_C_U32_BIT_BISNOPASSDESTAREAOC); }
   tBool bbIsRestrictedDestAreaOC() const {return (u32Value & FI_C_U32_BIT_BISRESTRICTEDDESTAREAOC) != 0; }
   tVoid vSetbIsRestrictedDestAreaOC(tBool bSetBit) { u32Value = (bSetBit)?(u32Value | FI_C_U32_BIT_BISRESTRICTEDDESTAREAOC):(u32Value & ~FI_C_U32_BIT_BISRESTRICTEDDESTAREAOC); }
   tBool bbIsDestination() const {return (u32Value & FI_C_U32_BIT_BISDESTINATION) != 0; }
   tVoid vSetbIsDestination(tBool bSetBit) { u32Value = (bSetBit)?(u32Value | FI_C_U32_BIT_BISDESTINATION):(u32Value & ~FI_C_U32_BIT_BISDESTINATION); }
   tBool bbIsBuiltUpArea() const {return (u32Value & FI_C_U32_BIT_BISBUILTUPAREA) != 0; }
   tVoid vSetbIsBuiltUpArea(tBool bSetBit) { u32Value = (bSetBit)?(u32Value | FI_C_U32_BIT_BISBUILTUPAREA):(u32Value & ~FI_C_U32_BIT_BISBUILTUPAREA); }
   tBool bbIsCollapsedOneCell() const {return (u32Value & FI_C_U32_BIT_BISCOLLAPSEDONECELL) != 0; }
   tVoid vSetbIsCollapsedOneCell(tBool bSetBit) { u32Value = (bSetBit)?(u32Value | FI_C_U32_BIT_BISCOLLAPSEDONECELL):(u32Value & ~FI_C_U32_BIT_BISCOLLAPSEDONECELL); }
   tBool bbIsTurnPossibleAtNextZC() const {return (u32Value & FI_C_U32_BIT_BISTURNPOSSIBLEATNEXTZC) != 0; }
   tVoid vSetbIsTurnPossibleAtNextZC(tBool bSetBit) { u32Value = (bSetBit)?(u32Value | FI_C_U32_BIT_BISTURNPOSSIBLEATNEXTZC):(u32Value & ~FI_C_U32_BIT_BISTURNPOSSIBLEATNEXTZC); }
   tBool bbIsComplexIntersection() const {return (u32Value & FI_C_U32_BIT_BISCOMPLEXINTERSECTION) != 0; }
   tVoid vSetbIsComplexIntersection(tBool bSetBit) { u32Value = (bSetBit)?(u32Value | FI_C_U32_BIT_BISCOMPLEXINTERSECTION):(u32Value & ~FI_C_U32_BIT_BISCOMPLEXINTERSECTION); }
   tBool bbIsObject() const {return (u32Value & FI_C_U32_BIT_BISOBJECT) != 0; }
   tVoid vSetbIsObject(tBool bSetBit) { u32Value = (bSetBit)?(u32Value | FI_C_U32_BIT_BISOBJECT):(u32Value & ~FI_C_U32_BIT_BISOBJECT); }
   tBool bbIsMoreThanTwoC1CAtNextZC() const {return (u32Value & FI_C_U32_BIT_BISMORETHANTWOC1CATNEXTZC) != 0; }
   tVoid vSetbIsMoreThanTwoC1CAtNextZC(tBool bSetBit) { u32Value = (bSetBit)?(u32Value | FI_C_U32_BIT_BISMORETHANTWOC1CATNEXTZC):(u32Value & ~FI_C_U32_BIT_BISMORETHANTWOC1CATNEXTZC); }
   tBool bbIsOnlyNonObjParkingAtNextZC() const {return (u32Value & FI_C_U32_BIT_BISONLYNONOBJPARKINGATNEXTZC) != 0; }
   tVoid vSetbIsOnlyNonObjParkingAtNextZC(tBool bSetBit) { u32Value = (bSetBit)?(u32Value | FI_C_U32_BIT_BISONLYNONOBJPARKINGATNEXTZC):(u32Value & ~FI_C_U32_BIT_BISONLYNONOBJPARKINGATNEXTZC); }
   tBool bbIsOnBorderOfGCl() const {return (u32Value & FI_C_U32_BIT_BISONBORDEROFGCL) != 0; }
   tVoid vSetbIsOnBorderOfGCl(tBool bSetBit) { u32Value = (bSetBit)?(u32Value | FI_C_U32_BIT_BISONBORDEROFGCL):(u32Value & ~FI_C_U32_BIT_BISONBORDEROFGCL); }
   tBool bbIsUpLink() const {return (u32Value & FI_C_U32_BIT_BISUPLINK) != 0; }
   tVoid vSetbIsUpLink(tBool bSetBit) { u32Value = (bSetBit)?(u32Value | FI_C_U32_BIT_BISUPLINK):(u32Value & ~FI_C_U32_BIT_BISUPLINK); }
   tBool bbIsPrimaryOutOfCorridor() const {return (u32Value & FI_C_U32_BIT_BISPRIMARYOUTOFCORRIDOR) != 0; }
   tVoid vSetbIsPrimaryOutOfCorridor(tBool bSetBit) { u32Value = (bSetBit)?(u32Value | FI_C_U32_BIT_BISPRIMARYOUTOFCORRIDOR):(u32Value & ~FI_C_U32_BIT_BISPRIMARYOUTOFCORRIDOR); }
   tBool bbIsSecundaryOutOfCorridor() const {return (u32Value & FI_C_U32_BIT_BISSECUNDARYOUTOFCORRIDOR) != 0; }
   tVoid vSetbIsSecundaryOutOfCorridor(tBool bSetBit) { u32Value = (bSetBit)?(u32Value | FI_C_U32_BIT_BISSECUNDARYOUTOFCORRIDOR):(u32Value & ~FI_C_U32_BIT_BISSECUNDARYOUTOFCORRIDOR); }
   tBool bbIsFirstInComplexIntersection() const {return (u32Value & FI_C_U32_BIT_BISFIRSTINCOMPLEXINTERSECTION) != 0; }
   tVoid vSetbIsFirstInComplexIntersection(tBool bSetBit) { u32Value = (bSetBit)?(u32Value | FI_C_U32_BIT_BISFIRSTINCOMPLEXINTERSECTION):(u32Value & ~FI_C_U32_BIT_BISFIRSTINCOMPLEXINTERSECTION); }
   tBool bbIsPrePathOfComplexIntersection() const {return (u32Value & FI_C_U32_BIT_BISPREPATHOFCOMPLEXINTERSECTION) != 0; }
   tVoid vSetbIsPrePathOfComplexIntersection(tBool bSetBit) { u32Value = (bSetBit)?(u32Value | FI_C_U32_BIT_BISPREPATHOFCOMPLEXINTERSECTION):(u32Value & ~FI_C_U32_BIT_BISPREPATHOFCOMPLEXINTERSECTION); }
   tBool bbIsPartialFreeway() const {return (u32Value & FI_C_U32_BIT_BISPARTIALFREEWAY) != 0; }
   tVoid vSetbIsPartialFreeway(tBool bSetBit) { u32Value = (bSetBit)?(u32Value | FI_C_U32_BIT_BISPARTIALFREEWAY):(u32Value & ~FI_C_U32_BIT_BISPARTIALFREEWAY); }
   tBool bbIsCompleteFreeway() const {return (u32Value & FI_C_U32_BIT_BISCOMPLETEFREEWAY) != 0; }
   tVoid vSetbIsCompleteFreeway(tBool bSetBit) { u32Value = (bSetBit)?(u32Value | FI_C_U32_BIT_BISCOMPLETEFREEWAY):(u32Value & ~FI_C_U32_BIT_BISCOMPLETEFREEWAY); }
   tBool bbIsPartialSeasonalClosed() const {return (u32Value & FI_C_U32_BIT_BISPARTIALSEASONALCLOSED) != 0; }
   tVoid vSetbIsPartialSeasonalClosed(tBool bSetBit) { u32Value = (bSetBit)?(u32Value | FI_C_U32_BIT_BISPARTIALSEASONALCLOSED):(u32Value & ~FI_C_U32_BIT_BISPARTIALSEASONALCLOSED); }
   tBool bbIsCompleteSeasonalClosed() const {return (u32Value & FI_C_U32_BIT_BISCOMPLETESEASONALCLOSED) != 0; }
   tVoid vSetbIsCompleteSeasonalClosed(tBool bSetBit) { u32Value = (bSetBit)?(u32Value | FI_C_U32_BIT_BISCOMPLETESEASONALCLOSED):(u32Value & ~FI_C_U32_BIT_BISCOMPLETESEASONALCLOSED); }
   struct rBitValues {
      unsigned int bIsPartialMotorway:1;
      unsigned int bIsCompleteMotorway:1;
      unsigned int bIsPartialFerry:1;
      unsigned int bIsCompleteFerry:1;
      unsigned int bIsPartialTollRoad:1;
      unsigned int bIsCompleteTollRoad:1;
      unsigned int bIsPartialTunnel:1;
      unsigned int bIsCompleteTunnel:1;
      unsigned int bIsNoPass:1;
      unsigned int bIsRestricted:1;
      unsigned int bIsBlockade:1;
      unsigned int bIsOCWidManipulated:1;
      unsigned int bIsNoPassDestAreaOC:1;
      unsigned int bIsRestrictedDestAreaOC:1;
      unsigned int bIsDestination:1;
      unsigned int bIsBuiltUpArea:1;
      unsigned int bIsCollapsedOneCell:1;
      unsigned int bIsTurnPossibleAtNextZC:1;
      unsigned int bIsComplexIntersection:1;
      unsigned int bIsObject:1;
      unsigned int bIsMoreThanTwoC1CAtNextZC:1;
      unsigned int bIsOnlyNonObjParkingAtNextZC:1;
      unsigned int bIsOnBorderOfGCl:1;
      unsigned int bIsUpLink:1;
      unsigned int bIsPrimaryOutOfCorridor:1;
      unsigned int bIsSecundaryOutOfCorridor:1;
      unsigned int bIsFirstInComplexIntersection:1;
      unsigned int bIsPrePathOfComplexIntersection:1;
      unsigned int bIsPartialFreeway:1;
      unsigned int bIsCompleteFreeway:1;
      unsigned int bIsPartialSeasonalClosed:1;
      unsigned int bIsCompleteSeasonalClosed:1;
   };
   union {
      tU32 u32Value;
      rBitValues bits;
   };

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual tBool operator==(const fi_tcl_b32_NavRouteOneCellStatus& rfoCmp) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   virtual tS32 s32GetTypeId() const { return typesfi_tclToken::EN_B32_NAVROUTEONECELLSTATUS;}
   virtual tVoid vTakeVisitor(fi_tclVisitorBase& rfoVisitor);
};

class fi_tcl_b32_ExtNavRouteOneCellStatus : public fi_tclVisitableTypeBase
{
public:
   fi_tcl_b32_ExtNavRouteOneCellStatus():u32Value(0) {}

   enum {
      FI_C_U32_BIT_BNOTCOVEREDWITHTRUCKATTRIBUTES = 0x1UL,
      FI_C_U32_BIT_BVEHICLEDIMENSIONEXCEEDED = 0x2UL,
      FI_C_U32_BIT_BHASPROHIBITIONFORDANGEROUSGOODS = 0x4UL,
      FI_C_U32_BIT_BHASPROHIBITIONFORWATERPOLLUTINGGOODS = 0x8UL,
      FI_C_U32_BIT_BHASPROHIBITIONFOREXPLOSIVEGOODS = 0x10UL,
      FI_C_U32_BIT_BHASSTRONGGRADIENT = 0x20UL,
      FI_C_U32_BIT_BHASSHARPCURVE = 0x40UL,
      FI_C_U32_BIT_BHASMULTIPLESHARPCURVES = 0x80UL,
      FI_C_U32_BIT_BHASMANDATORYSNOWCHAIN = 0x100UL,
      FI_C_U32_BIT_BHASRISKOFSKIDDING = 0x200UL,
      FI_C_U32_BIT_BHASRISKOFSIDEWIND = 0x400UL,
      FI_C_U32_BIT_BHASRISKOFSNOWSLIPPERINESS = 0x800UL,
      FI_C_U32_BIT_BHASTRUCKPROHIBITION = 0x1000UL,
      FI_C_U32_BIT_BHASTRAILERPROHIBITION = 0x2000UL,
      FI_C_U32_BIT_BHASMANDATORYTAXDISC = 0x4000UL,
      FI_C_U32_BIT_BPROHIBITIONONFOLLOWINGTURN = 0x8000UL,
      FI_C_U32_BIT_BREGULARADMINCLOSED = 0x10000UL,
      FI_C_U32_BIT_BREGULARADMINCLOSEDPARTLY = 0x20000UL,
      FI_C_U32_BIT_BINCONSTRUCTION = 0x40000UL,
      FI_C_U32_BIT_BINCONSTRUCTIONPARTLY = 0x80000UL,
      FI_C_U32_BIT_BISHOV = 0x100000UL,
      FI_C_U32_BIT_BISPARTIALAUTOTRAIN = 0x200000UL,
      FI_C_U32_BIT_BISCOMPLETEAUTOTRAIN = 0x400000UL,
      FI_C_U32_BIT_BISPARTIALUNPAVEDROAD = 0x800000UL,
      FI_C_U32_BIT_BISCOMPLETEUNPAVEDROAD = 0x1000000UL
   };
   tBool bbNotCoveredWithTruckAttributes() const {return (u32Value & FI_C_U32_BIT_BNOTCOVEREDWITHTRUCKATTRIBUTES) != 0; }
   tVoid vSetbNotCoveredWithTruckAttributes(tBool bSetBit) { u32Value = (bSetBit)?(u32Value | FI_C_U32_BIT_BNOTCOVEREDWITHTRUCKATTRIBUTES):(u32Value & ~FI_C_U32_BIT_BNOTCOVEREDWITHTRUCKATTRIBUTES); }
   tBool bbVehicleDimensionExceeded() const {return (u32Value & FI_C_U32_BIT_BVEHICLEDIMENSIONEXCEEDED) != 0; }
   tVoid vSetbVehicleDimensionExceeded(tBool bSetBit) { u32Value = (bSetBit)?(u32Value | FI_C_U32_BIT_BVEHICLEDIMENSIONEXCEEDED):(u32Value & ~FI_C_U32_BIT_BVEHICLEDIMENSIONEXCEEDED); }
   tBool bbHasProhibitionForDangerousGoods() const {return (u32Value & FI_C_U32_BIT_BHASPROHIBITIONFORDANGEROUSGOODS) != 0; }
   tVoid vSetbHasProhibitionForDangerousGoods(tBool bSetBit) { u32Value = (bSetBit)?(u32Value | FI_C_U32_BIT_BHASPROHIBITIONFORDANGEROUSGOODS):(u32Value & ~FI_C_U32_BIT_BHASPROHIBITIONFORDANGEROUSGOODS); }
   tBool bbHasProhibitionForWaterPollutingGoods() const {return (u32Value & FI_C_U32_BIT_BHASPROHIBITIONFORWATERPOLLUTINGGOODS) != 0; }
   tVoid vSetbHasProhibitionForWaterPollutingGoods(tBool bSetBit) { u32Value = (bSetBit)?(u32Value | FI_C_U32_BIT_BHASPROHIBITIONFORWATERPOLLUTINGGOODS):(u32Value & ~FI_C_U32_BIT_BHASPROHIBITIONFORWATERPOLLUTINGGOODS); }
   tBool bbHasProhibitionForExplosiveGoods() const {return (u32Value & FI_C_U32_BIT_BHASPROHIBITIONFOREXPLOSIVEGOODS) != 0; }
   tVoid vSetbHasProhibitionForExplosiveGoods(tBool bSetBit) { u32Value = (bSetBit)?(u32Value | FI_C_U32_BIT_BHASPROHIBITIONFOREXPLOSIVEGOODS):(u32Value & ~FI_C_U32_BIT_BHASPROHIBITIONFOREXPLOSIVEGOODS); }
   tBool bbHasStrongGradient() const {return (u32Value & FI_C_U32_BIT_BHASSTRONGGRADIENT) != 0; }
   tVoid vSetbHasStrongGradient(tBool bSetBit) { u32Value = (bSetBit)?(u32Value | FI_C_U32_BIT_BHASSTRONGGRADIENT):(u32Value & ~FI_C_U32_BIT_BHASSTRONGGRADIENT); }
   tBool bbHasSharpCurve() const {return (u32Value & FI_C_U32_BIT_BHASSHARPCURVE) != 0; }
   tVoid vSetbHasSharpCurve(tBool bSetBit) { u32Value = (bSetBit)?(u32Value | FI_C_U32_BIT_BHASSHARPCURVE):(u32Value & ~FI_C_U32_BIT_BHASSHARPCURVE); }
   tBool bbHasMultipleSharpCurves() const {return (u32Value & FI_C_U32_BIT_BHASMULTIPLESHARPCURVES) != 0; }
   tVoid vSetbHasMultipleSharpCurves(tBool bSetBit) { u32Value = (bSetBit)?(u32Value | FI_C_U32_BIT_BHASMULTIPLESHARPCURVES):(u32Value & ~FI_C_U32_BIT_BHASMULTIPLESHARPCURVES); }
   tBool bbHasMandatorySnowChain() const {return (u32Value & FI_C_U32_BIT_BHASMANDATORYSNOWCHAIN) != 0; }
   tVoid vSetbHasMandatorySnowChain(tBool bSetBit) { u32Value = (bSetBit)?(u32Value | FI_C_U32_BIT_BHASMANDATORYSNOWCHAIN):(u32Value & ~FI_C_U32_BIT_BHASMANDATORYSNOWCHAIN); }
   tBool bbHasRiskOfSkidding() const {return (u32Value & FI_C_U32_BIT_BHASRISKOFSKIDDING) != 0; }
   tVoid vSetbHasRiskOfSkidding(tBool bSetBit) { u32Value = (bSetBit)?(u32Value | FI_C_U32_BIT_BHASRISKOFSKIDDING):(u32Value & ~FI_C_U32_BIT_BHASRISKOFSKIDDING); }
   tBool bbHasRiskOfSidewind() const {return (u32Value & FI_C_U32_BIT_BHASRISKOFSIDEWIND) != 0; }
   tVoid vSetbHasRiskOfSidewind(tBool bSetBit) { u32Value = (bSetBit)?(u32Value | FI_C_U32_BIT_BHASRISKOFSIDEWIND):(u32Value & ~FI_C_U32_BIT_BHASRISKOFSIDEWIND); }
   tBool bbHasRiskOfSnowSlipperiness() const {return (u32Value & FI_C_U32_BIT_BHASRISKOFSNOWSLIPPERINESS) != 0; }
   tVoid vSetbHasRiskOfSnowSlipperiness(tBool bSetBit) { u32Value = (bSetBit)?(u32Value | FI_C_U32_BIT_BHASRISKOFSNOWSLIPPERINESS):(u32Value & ~FI_C_U32_BIT_BHASRISKOFSNOWSLIPPERINESS); }
   tBool bbHasTruckProhibition() const {return (u32Value & FI_C_U32_BIT_BHASTRUCKPROHIBITION) != 0; }
   tVoid vSetbHasTruckProhibition(tBool bSetBit) { u32Value = (bSetBit)?(u32Value | FI_C_U32_BIT_BHASTRUCKPROHIBITION):(u32Value & ~FI_C_U32_BIT_BHASTRUCKPROHIBITION); }
   tBool bbHasTrailerProhibition() const {return (u32Value & FI_C_U32_BIT_BHASTRAILERPROHIBITION) != 0; }
   tVoid vSetbHasTrailerProhibition(tBool bSetBit) { u32Value = (bSetBit)?(u32Value | FI_C_U32_BIT_BHASTRAILERPROHIBITION):(u32Value & ~FI_C_U32_BIT_BHASTRAILERPROHIBITION); }
   tBool bbHasMandatoryTaxDisc() const {return (u32Value & FI_C_U32_BIT_BHASMANDATORYTAXDISC) != 0; }
   tVoid vSetbHasMandatoryTaxDisc(tBool bSetBit) { u32Value = (bSetBit)?(u32Value | FI_C_U32_BIT_BHASMANDATORYTAXDISC):(u32Value & ~FI_C_U32_BIT_BHASMANDATORYTAXDISC); }
   tBool bbProhibitionOnFollowingTurn() const {return (u32Value & FI_C_U32_BIT_BPROHIBITIONONFOLLOWINGTURN) != 0; }
   tVoid vSetbProhibitionOnFollowingTurn(tBool bSetBit) { u32Value = (bSetBit)?(u32Value | FI_C_U32_BIT_BPROHIBITIONONFOLLOWINGTURN):(u32Value & ~FI_C_U32_BIT_BPROHIBITIONONFOLLOWINGTURN); }
   tBool bbRegularAdminClosed() const {return (u32Value & FI_C_U32_BIT_BREGULARADMINCLOSED) != 0; }
   tVoid vSetbRegularAdminClosed(tBool bSetBit) { u32Value = (bSetBit)?(u32Value | FI_C_U32_BIT_BREGULARADMINCLOSED):(u32Value & ~FI_C_U32_BIT_BREGULARADMINCLOSED); }
   tBool bbRegularAdminClosedPartly() const {return (u32Value & FI_C_U32_BIT_BREGULARADMINCLOSEDPARTLY) != 0; }
   tVoid vSetbRegularAdminClosedPartly(tBool bSetBit) { u32Value = (bSetBit)?(u32Value | FI_C_U32_BIT_BREGULARADMINCLOSEDPARTLY):(u32Value & ~FI_C_U32_BIT_BREGULARADMINCLOSEDPARTLY); }
   tBool bbInConstruction() const {return (u32Value & FI_C_U32_BIT_BINCONSTRUCTION) != 0; }
   tVoid vSetbInConstruction(tBool bSetBit) { u32Value = (bSetBit)?(u32Value | FI_C_U32_BIT_BINCONSTRUCTION):(u32Value & ~FI_C_U32_BIT_BINCONSTRUCTION); }
   tBool bbInConstructionPartly() const {return (u32Value & FI_C_U32_BIT_BINCONSTRUCTIONPARTLY) != 0; }
   tVoid vSetbInConstructionPartly(tBool bSetBit) { u32Value = (bSetBit)?(u32Value | FI_C_U32_BIT_BINCONSTRUCTIONPARTLY):(u32Value & ~FI_C_U32_BIT_BINCONSTRUCTIONPARTLY); }
   tBool bbIsHOV() const {return (u32Value & FI_C_U32_BIT_BISHOV) != 0; }
   tVoid vSetbIsHOV(tBool bSetBit) { u32Value = (bSetBit)?(u32Value | FI_C_U32_BIT_BISHOV):(u32Value & ~FI_C_U32_BIT_BISHOV); }
   tBool bbIsPartialAutoTrain() const {return (u32Value & FI_C_U32_BIT_BISPARTIALAUTOTRAIN) != 0; }
   tVoid vSetbIsPartialAutoTrain(tBool bSetBit) { u32Value = (bSetBit)?(u32Value | FI_C_U32_BIT_BISPARTIALAUTOTRAIN):(u32Value & ~FI_C_U32_BIT_BISPARTIALAUTOTRAIN); }
   tBool bbIsCompleteAutoTrain() const {return (u32Value & FI_C_U32_BIT_BISCOMPLETEAUTOTRAIN) != 0; }
   tVoid vSetbIsCompleteAutoTrain(tBool bSetBit) { u32Value = (bSetBit)?(u32Value | FI_C_U32_BIT_BISCOMPLETEAUTOTRAIN):(u32Value & ~FI_C_U32_BIT_BISCOMPLETEAUTOTRAIN); }
   tBool bbIsPartialUnpavedRoad() const {return (u32Value & FI_C_U32_BIT_BISPARTIALUNPAVEDROAD) != 0; }
   tVoid vSetbIsPartialUnpavedRoad(tBool bSetBit) { u32Value = (bSetBit)?(u32Value | FI_C_U32_BIT_BISPARTIALUNPAVEDROAD):(u32Value & ~FI_C_U32_BIT_BISPARTIALUNPAVEDROAD); }
   tBool bbIsCompleteUnpavedRoad() const {return (u32Value & FI_C_U32_BIT_BISCOMPLETEUNPAVEDROAD) != 0; }
   tVoid vSetbIsCompleteUnpavedRoad(tBool bSetBit) { u32Value = (bSetBit)?(u32Value | FI_C_U32_BIT_BISCOMPLETEUNPAVEDROAD):(u32Value & ~FI_C_U32_BIT_BISCOMPLETEUNPAVEDROAD); }
   struct rBitValues {
      unsigned int bNotCoveredWithTruckAttributes:1;
      unsigned int bVehicleDimensionExceeded:1;
      unsigned int bHasProhibitionForDangerousGoods:1;
      unsigned int bHasProhibitionForWaterPollutingGoods:1;
      unsigned int bHasProhibitionForExplosiveGoods:1;
      unsigned int bHasStrongGradient:1;
      unsigned int bHasSharpCurve:1;
      unsigned int bHasMultipleSharpCurves:1;
      unsigned int bHasMandatorySnowChain:1;
      unsigned int bHasRiskOfSkidding:1;
      unsigned int bHasRiskOfSidewind:1;
      unsigned int bHasRiskOfSnowSlipperiness:1;
      unsigned int bHasTruckProhibition:1;
      unsigned int bHasTrailerProhibition:1;
      unsigned int bHasMandatoryTaxDisc:1;
      unsigned int bProhibitionOnFollowingTurn:1;
      unsigned int bRegularAdminClosed:1;
      unsigned int bRegularAdminClosedPartly:1;
      unsigned int bInConstruction:1;
      unsigned int bInConstructionPartly:1;
      unsigned int bIsHOV:1;
      unsigned int bIsPartialAutoTrain:1;
      unsigned int bIsCompleteAutoTrain:1;
      unsigned int bIsPartialUnpavedRoad:1;
      unsigned int bIsCompleteUnpavedRoad:1;
      unsigned int dummy25:1;
      unsigned int dummy26:1;
      unsigned int dummy27:1;
      unsigned int dummy28:1;
      unsigned int dummy29:1;
      unsigned int dummy30:1;
      unsigned int dummy31:1;
   };
   union {
      tU32 u32Value;
      rBitValues bits;
   };

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual tBool operator==(const fi_tcl_b32_ExtNavRouteOneCellStatus& rfoCmp) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   virtual tS32 s32GetTypeId() const { return typesfi_tclToken::EN_B32_EXTNAVROUTEONECELLSTATUS;}
   virtual tVoid vTakeVisitor(fi_tclVisitorBase& rfoVisitor);
};

class fi_tcl_NavRouteOneCellProperties : public fi_tclVisitableTypeBase
{
public:
   fi_tcl_NavRouteOneCellProperties():TripSegmentNumber(),CoordOfToZeroCell(),Status(),ExtStatus(),RoadProperty(),RoadClass(0),StreetType(0),TimeManipulator(0),RouteLength(),RouteTime(),RouteTimeFullTraffic(),RouteTimeNoTraffic(),OneCellLength(),OneCellTime(),Resistance(0),ROSA(0),GBWZ(0) {}
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   fi_tcl_NavRouteOneCellProperties& operator=(const fi_tcl_NavRouteOneCellProperties& coRef);
   fi_tcl_NavRouteOneCellProperties(const fi_tcl_NavRouteOneCellProperties& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
   fi_tcl_u16_TripSegmentNumber TripSegmentNumber;
   fi_tcl_PositionWGS84 CoordOfToZeroCell;
   fi_tcl_b32_NavRouteOneCellStatus Status;
   fi_tcl_b32_ExtNavRouteOneCellStatus ExtStatus;
   fi_tcl_b32_RoadProperty RoadProperty;
   tU8 RoadClass;
   tU8 StreetType;
   tU8 TimeManipulator;
   fi_tcl_s32_EMU RouteLength;
   fi_tcl_s32_Second RouteTime;
   fi_tcl_s32_Second RouteTimeFullTraffic;
   fi_tcl_s32_Second RouteTimeNoTraffic;
   fi_tcl_s32_EMU OneCellLength;
   fi_tcl_s32_Second OneCellTime;
   tU32 Resistance;
   tU32 ROSA;
   tU8 GBWZ;

   virtual tVoid vDestroy();
   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual tBool operator==(const fi_tcl_NavRouteOneCellProperties& rfoCmp) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   virtual tS32 s32GetTypeId() const { return typesfi_tclToken::EN_NAVROUTEONECELLPROPERTIES;}
   virtual tVoid vTakeVisitor(fi_tclVisitorBase& rfoVisitor);
};

class fi_tcl_NavRouteOneCellDesc : public fi_tclVisitableTypeBase
{
public:
   fi_tcl_NavRouteOneCellDesc():OCDesc(),Instruction(),Destination(),CountryCode(),NextOneCellOnPath(),OCProperties(),StateCode() {}
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   fi_tcl_NavRouteOneCellDesc& operator=(const fi_tcl_NavRouteOneCellDesc& coRef);
   fi_tcl_NavRouteOneCellDesc(const fi_tcl_NavRouteOneCellDesc& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
   fi_tcl_NavOneCellDesc OCDesc;
   fi_tcl_u16_IndexInReferenceList Instruction;
   fi_tcl_u16_IndexInReferenceList Destination;
   fi_tcl_u16_IndexInReferenceList CountryCode;
   fi_tcl_u16_IndexInReferenceList NextOneCellOnPath;
   fi_tcl_NavRouteOneCellProperties OCProperties;
   fi_tcl_u16_IndexInReferenceList StateCode;

   virtual tVoid vDestroy();
   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual tBool operator==(const fi_tcl_NavRouteOneCellDesc& rfoCmp) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   virtual tS32 s32GetTypeId() const { return typesfi_tclToken::EN_NAVROUTEONECELLDESC;}
   virtual tVoid vTakeVisitor(fi_tclVisitorBase& rfoVisitor);
};

class fi_tcl_NavRouteInstructionDesc : public fi_tclVisitableTypeBase
{
public:
   fi_tcl_NavRouteInstructionDesc():NavInstruction(0),NextInstruction(),IndexInFileNameList(),ManoeuvreCriticality() {}
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   fi_tcl_NavRouteInstructionDesc& operator=(const fi_tcl_NavRouteInstructionDesc& coRef);
   fi_tcl_NavRouteInstructionDesc(const fi_tcl_NavRouteInstructionDesc& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
   tU32 NavInstruction;
   fi_tcl_u16_IndexInReferenceList NextInstruction;
   fi_tcl_u16_IndexInReferenceList IndexInFileNameList;
   fi_tcl_e8_ManoeuvreCriticality ManoeuvreCriticality;

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual tBool operator==(const fi_tcl_NavRouteInstructionDesc& rfoCmp) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   virtual tS32 s32GetTypeId() const { return typesfi_tclToken::EN_NAVROUTEINSTRUCTIONDESC;}
   virtual tVoid vTakeVisitor(fi_tclVisitorBase& rfoVisitor);
};

class fi_tcl_u16_RouteHandle : public fi_tclVisitableTypeBase
{
public:
   fi_tcl_u16_RouteHandle(tU16 _u16Value = 0):u16Value(_u16Value) {} 

   tU16 u16Value;

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual tBool operator==(const fi_tcl_u16_RouteHandle& rfoCmp) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   virtual tS32 s32GetTypeId() const { return typesfi_tclToken::EN_U16_ROUTEHANDLE;}
   virtual tVoid vTakeVisitor(fi_tclVisitorBase& rfoVisitor);
};

class fi_tcl_e8_SignPostDestType : public fi_tclVisitableTypeBase
{
public:
   fi_tcl_e8_SignPostDestType():enType(FI_EN_RESERVED) {}

   enum tenType {
      FI_EN_RESERVED = 0UL,
      FI_EN_TOWARD = 1UL,
      FI_EN_BRANCH = 2UL,
      FI_EN_EXIT = 3UL
   };
   tenType enType;

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual tBool operator==(const fi_tcl_e8_SignPostDestType& rfoCmp) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   virtual tS32 s32GetTypeId() const { return typesfi_tclToken::EN_E8_SIGNPOSTDESTTYPE;}
   virtual tVoid vTakeVisitor(fi_tclVisitorBase& rfoVisitor);
};

class fi_tcl_e8_SignPostDestinationCategory : public fi_tclVisitableTypeBase
{
public:
   fi_tcl_e8_SignPostDestinationCategory():enType(FI_EN_T_RESERVED) {}

   enum tenType {
      FI_EN_T_RESERVED = 0UL,
      FI_EN_T_COUNTRYNAMEELEMENT = 1UL,
      FI_EN_T_STATENAMEELEMENT = 2UL,
      FI_EN_T_COUNTYNAMEELEMENT = 3UL,
      FI_EN_T_CITYNAMEELEMENT = 4UL,
      FI_EN_T_CITYDISTRICTNAMEELEMENT = 5UL,
      FI_EN_T_BUILDUPAREANAMEELEMENT = 6UL,
      FI_EN_T_ROADNAMEELEMENT = 7UL,
      FI_EN_T_ROADNUMBER = 8UL,
      FI_EN_T_INTERSECTIONNAMEELEMENT = 9UL,
      FI_EN_T_INTERSECTIONNUMBERELEMENT = 10UL,
      FI_EN_T_POINTOFINTERESTELEMENT = 19UL,
      FI_EN_T_UNSPECIFIEDTEXT = 20UL,
      FI_EN_T_COMPASSDIRECTION = 26UL
   };
   tenType enType;

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual tBool operator==(const fi_tcl_e8_SignPostDestinationCategory& rfoCmp) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   virtual tS32 s32GetTypeId() const { return typesfi_tclToken::EN_E8_SIGNPOSTDESTINATIONCATEGORY;}
   virtual tVoid vTakeVisitor(fi_tclVisitorBase& rfoVisitor);
};

class fi_tcl_e8_SignPostDestStatus : public fi_tclVisitableTypeBase
{
public:
   fi_tcl_e8_SignPostDestStatus():enType(FI_EN_UNKNOWN) {}

   enum tenType {
      FI_EN_UNKNOWN = 0UL,
      FI_EN_OFFROUTE = 1UL,
      FI_EN_ONROUTE = 2UL
   };
   tenType enType;

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual tBool operator==(const fi_tcl_e8_SignPostDestStatus& rfoCmp) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   virtual tS32 s32GetTypeId() const { return typesfi_tclToken::EN_E8_SIGNPOSTDESTSTATUS;}
   virtual tVoid vTakeVisitor(fi_tclVisitorBase& rfoVisitor);
};

class fi_tcl_e8_DirectionStatus : public fi_tclVisitableTypeBase
{
public:
   fi_tcl_e8_DirectionStatus():enType(FI_EN_UNKNOWN) {}

   enum tenType {
      FI_EN_UNKNOWN = 0UL,
      FI_EN_OFFROUTE = 1UL,
      FI_EN_ONROUTE = 2UL,
      FI_EN_PREFERRED = 3UL
   };
   tenType enType;

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual tBool operator==(const fi_tcl_e8_DirectionStatus& rfoCmp) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   virtual tS32 s32GetTypeId() const { return typesfi_tclToken::EN_E8_DIRECTIONSTATUS;}
   virtual tVoid vTakeVisitor(fi_tclVisitorBase& rfoVisitor);
};

class fi_tcl_SignPostDestDirection : public fi_tclVisitableTypeBase
{
public:
   fi_tcl_SignPostDestDirection():DirectionIsValid(0),Direction(),DirectionDesc(0) {}
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   fi_tcl_SignPostDestDirection& operator=(const fi_tcl_SignPostDestDirection& coRef);
   fi_tcl_SignPostDestDirection(const fi_tcl_SignPostDestDirection& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
   tBool DirectionIsValid;
   fi_tcl_u8_DirectionAbsolute Direction;
   fi_tclMultiLanguageString DirectionDesc;

   virtual tVoid vDestroy();
   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual tBool operator==(const fi_tcl_SignPostDestDirection& rfoCmp) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   virtual tS32 s32GetTypeId() const { return typesfi_tclToken::EN_SIGNPOSTDESTDIRECTION;}
   virtual tVoid vTakeVisitor(fi_tclVisitorBase& rfoVisitor);
};

class fi_tcl_e8_DirectionCategory : public fi_tclVisitableTypeBase
{
public:
   fi_tcl_e8_DirectionCategory():enType(FI_EN_T_RESERVED) {}

   enum tenType {
      FI_EN_T_RESERVED = 0UL,
      FI_EN_T_COUNTRYNAMEELEMENT = 1UL,
      FI_EN_T_STATENAMEELEMENT = 2UL,
      FI_EN_T_COUNTYNAMEELEMENT = 3UL,
      FI_EN_T_CITYNAMEELEMENT = 4UL,
      FI_EN_T_CITYDISTRICTNAMEELEMENT = 5UL,
      FI_EN_T_BUILDUPAREANAMEELEMENT = 6UL,
      FI_EN_T_ROADNAMEELEMENT = 7UL,
      FI_EN_T_ROADNUMBER = 8UL,
      FI_EN_T_INTERSECTIONNAMEELEMENT = 9UL,
      FI_EN_T_INTERSECTIONNUMBERELEMENT = 10UL,
      FI_EN_T_POINTOFINTERESTELEMENT = 19UL,
      FI_EN_T_UNSPECIFIEDTEXT = 20UL,
      FI_EN_T_COMPASSDIRECTION = 26UL
   };
   tenType enType;

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual tBool operator==(const fi_tcl_e8_DirectionCategory& rfoCmp) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   virtual tS32 s32GetTypeId() const { return typesfi_tclToken::EN_E8_DIRECTIONCATEGORY;}
   virtual tVoid vTakeVisitor(fi_tclVisitorBase& rfoVisitor);
};

class fi_tcl_e8_NavOneCellCategory : public fi_tclVisitableTypeBase
{
public:
   fi_tcl_e8_NavOneCellCategory():enType(FI_EN_T_RESERVED) {}

   enum tenType {
      FI_EN_T_RESERVED = 0UL,
      FI_EN_T_NAVONECELL = 1UL,
      FI_EN_T_U16_INDEXINREFERENCELIST = 2UL
   };
   tenType enType;

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual tBool operator==(const fi_tcl_e8_NavOneCellCategory& rfoCmp) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   virtual tS32 s32GetTypeId() const { return typesfi_tclToken::EN_E8_NAVONECELLCATEGORY;}
   virtual tVoid vTakeVisitor(fi_tclVisitorBase& rfoVisitor);
};

class fi_tcl_DirectionCategory : public fi_tclVisitableTypeBase
{
public:
   fi_tcl_DirectionCategory():poDirectionCategoryData(0) {}
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   fi_tcl_DirectionCategory& operator=(const fi_tcl_DirectionCategory& coRef);
   fi_tcl_DirectionCategory(const fi_tcl_DirectionCategory& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
   fi_tcl_e8_DirectionCategory DirectionCategoryType;
   fi_tclTypeBase* poDirectionCategoryData;
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   virtual ~fi_tcl_DirectionCategory();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   virtual tVoid vDestroy();
   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual tBool operator==(const fi_tcl_DirectionCategory& rfoCmp) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   virtual tS32 s32GetTypeId() const { return typesfi_tclToken::EN_DIRECTIONCATEGORY;}
   virtual tVoid vTakeVisitor(fi_tclVisitorBase& rfoVisitor);
};

class fi_tcl_b8_DirectionInfoStatus : public fi_tclVisitableTypeBase
{
public:
   fi_tcl_b8_DirectionInfoStatus():u8Value(0) {}

   enum {
      FI_C_U8_BIT_AMBIGUOUS = 0x1UL
   };
   tBool bAmbiguous() const {return (u8Value & FI_C_U8_BIT_AMBIGUOUS) != 0; }
   tVoid vSetAmbiguous(tBool bSetBit) { u8Value = (bSetBit)?(u8Value | FI_C_U8_BIT_AMBIGUOUS):(u8Value & ~FI_C_U8_BIT_AMBIGUOUS); }
   struct rBitValues {
      unsigned int Ambiguous:1;
      unsigned int dummy1:1;
      unsigned int dummy2:1;
      unsigned int dummy3:1;
      unsigned int dummy4:1;
      unsigned int dummy5:1;
      unsigned int dummy6:1;
      unsigned int dummy7:1;
   };
   union {
      tU8 u8Value;
      rBitValues bits;
   };

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual tBool operator==(const fi_tcl_b8_DirectionInfoStatus& rfoCmp) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   virtual tS32 s32GetTypeId() const { return typesfi_tclToken::EN_B8_DIRECTIONINFOSTATUS;}
   virtual tVoid vTakeVisitor(fi_tclVisitorBase& rfoVisitor);
};

class fi_tcl_DirectionInfo : public fi_tclVisitableTypeBase
{
public:
   fi_tcl_DirectionInfo():DirectionID(0),DirectionCategory(),DirectionStatus(),Status() {}
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   fi_tcl_DirectionInfo& operator=(const fi_tcl_DirectionInfo& coRef);
   fi_tcl_DirectionInfo(const fi_tcl_DirectionInfo& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
   tU32 DirectionID;
   fi_tcl_DirectionCategory DirectionCategory;
   fi_tcl_e8_DirectionStatus DirectionStatus;
   fi_tcl_b8_DirectionInfoStatus Status;

   virtual tVoid vDestroy();
   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual tBool operator==(const fi_tcl_DirectionInfo& rfoCmp) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   virtual tS32 s32GetTypeId() const { return typesfi_tclToken::EN_DIRECTIONINFO;}
   virtual tVoid vTakeVisitor(fi_tclVisitorBase& rfoVisitor);
};

class fi_tcl_SignPostDestination : public fi_tclVisitableTypeBase
{
public:
   fi_tcl_SignPostDestination():Type(),poSignPostDestinationCategoryData(0),SignPostDestinationDirection() {}
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   fi_tcl_SignPostDestination& operator=(const fi_tcl_SignPostDestination& coRef);
   fi_tcl_SignPostDestination(const fi_tcl_SignPostDestination& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
   fi_tcl_e8_SignPostDestType Type;
   fi_tcl_e8_SignPostDestinationCategory SignPostDestinationCategoryType;
   fi_tclTypeBase* poSignPostDestinationCategoryData;
   fi_tcl_SignPostDestDirection SignPostDestinationDirection;
   std::vector<fi_tcl_DirectionInfo, std::allocator<fi_tcl_DirectionInfo> > DirectionInfoList;
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   virtual ~fi_tcl_SignPostDestination();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   virtual tVoid vDestroy();
   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual tBool operator==(const fi_tcl_SignPostDestination& rfoCmp) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   virtual tS32 s32GetTypeId() const { return typesfi_tclToken::EN_SIGNPOSTDESTINATION;}
   virtual tVoid vTakeVisitor(fi_tclVisitorBase& rfoVisitor);
};

class fi_tcl_DirectionInfoList : public fi_tclVisitableTypeBase
{
public:
   fi_tcl_DirectionInfoList() {}
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   fi_tcl_DirectionInfoList& operator=(const fi_tcl_DirectionInfoList& coRef);
   fi_tcl_DirectionInfoList(const fi_tcl_DirectionInfoList& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
   std::vector<fi_tcl_DirectionInfo, std::allocator<fi_tcl_DirectionInfo> > DirectionInfoList;

   virtual tVoid vDestroy();
   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual tBool operator==(const fi_tcl_DirectionInfoList& rfoCmp) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   virtual tS32 s32GetTypeId() const { return typesfi_tclToken::EN_DIRECTIONINFOLIST;}
   virtual tVoid vTakeVisitor(fi_tclVisitorBase& rfoVisitor);
};

class fi_tcl_ReferenceElement : public fi_tclVisitableTypeBase
{
public:
   fi_tcl_ReferenceElement():BaseList(),RefList() {}
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   fi_tcl_ReferenceElement& operator=(const fi_tcl_ReferenceElement& coRef);
   fi_tcl_ReferenceElement(const fi_tcl_ReferenceElement& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
   fi_tcl_u16_IndexInReferenceList BaseList;
   fi_tcl_u16_IndexInReferenceList RefList;

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual tBool operator==(const fi_tcl_ReferenceElement& rfoCmp) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   virtual tS32 s32GetTypeId() const { return typesfi_tclToken::EN_REFERENCEELEMENT;}
   virtual tVoid vTakeVisitor(fi_tclVisitorBase& rfoVisitor);
};

class fi_tcl_b8_SignPostInfoStatus : public fi_tclVisitableTypeBase
{
public:
   fi_tcl_b8_SignPostInfoStatus():u8Value(0) {}

   enum {
      FI_C_U8_BIT_DPTPASSED = 0x1UL
   };
   tBool bDptPassed() const {return (u8Value & FI_C_U8_BIT_DPTPASSED) != 0; }
   tVoid vSetDptPassed(tBool bSetBit) { u8Value = (bSetBit)?(u8Value | FI_C_U8_BIT_DPTPASSED):(u8Value & ~FI_C_U8_BIT_DPTPASSED); }
   struct rBitValues {
      unsigned int DptPassed:1;
      unsigned int dummy1:1;
      unsigned int dummy2:1;
      unsigned int dummy3:1;
      unsigned int dummy4:1;
      unsigned int dummy5:1;
      unsigned int dummy6:1;
      unsigned int dummy7:1;
   };
   union {
      tU8 u8Value;
      rBitValues bits;
   };

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual tBool operator==(const fi_tcl_b8_SignPostInfoStatus& rfoCmp) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   virtual tS32 s32GetTypeId() const { return typesfi_tclToken::EN_B8_SIGNPOSTINFOSTATUS;}
   virtual tVoid vTakeVisitor(fi_tclVisitorBase& rfoVisitor);
};

class fi_tcl_e8_TMAffectionType : public fi_tclVisitableTypeBase
{
public:
   fi_tcl_e8_TMAffectionType():enType(FI_EN_BEGINNING) {}

   enum tenType {
      FI_EN_BEGINNING = 1UL,
      FI_EN_END = 2UL,
      FI_EN_COMPLETE = 3UL
   };
   tenType enType;

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual tBool operator==(const fi_tcl_e8_TMAffectionType& rfoCmp) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   virtual tS32 s32GetTypeId() const { return typesfi_tclToken::EN_E8_TMAFFECTIONTYPE;}
   virtual tVoid vTakeVisitor(fi_tclVisitorBase& rfoVisitor);
};

class fi_tcl_b8_TMOneCellAttribute : public fi_tclVisitableTypeBase
{
public:
   fi_tcl_b8_TMOneCellAttribute():u8Value(0) {}

   enum {
      FI_C_U8_BIT_ISFIRST = 0x1UL,
      FI_C_U8_BIT_ISLAST = 0x2UL,
      FI_C_U8_BIT_ISPARTOFREVERSETMPATH = 0x4UL
   };
   tBool bIsFirst() const {return (u8Value & FI_C_U8_BIT_ISFIRST) != 0; }
   tVoid vSetIsFirst(tBool bSetBit) { u8Value = (bSetBit)?(u8Value | FI_C_U8_BIT_ISFIRST):(u8Value & ~FI_C_U8_BIT_ISFIRST); }
   tBool bIsLast() const {return (u8Value & FI_C_U8_BIT_ISLAST) != 0; }
   tVoid vSetIsLast(tBool bSetBit) { u8Value = (bSetBit)?(u8Value | FI_C_U8_BIT_ISLAST):(u8Value & ~FI_C_U8_BIT_ISLAST); }
   tBool bIsPartOfReverseTMPath() const {return (u8Value & FI_C_U8_BIT_ISPARTOFREVERSETMPATH) != 0; }
   tVoid vSetIsPartOfReverseTMPath(tBool bSetBit) { u8Value = (bSetBit)?(u8Value | FI_C_U8_BIT_ISPARTOFREVERSETMPATH):(u8Value & ~FI_C_U8_BIT_ISPARTOFREVERSETMPATH); }
   struct rBitValues {
      unsigned int IsFirst:1;
      unsigned int IsLast:1;
      unsigned int IsPartOfReverseTMPath:1;
      unsigned int dummy3:1;
      unsigned int dummy4:1;
      unsigned int dummy5:1;
      unsigned int dummy6:1;
      unsigned int dummy7:1;
   };
   union {
      tU8 u8Value;
      rBitValues bits;
   };

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual tBool operator==(const fi_tcl_b8_TMOneCellAttribute& rfoCmp) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   virtual tS32 s32GetTypeId() const { return typesfi_tclToken::EN_B8_TMONECELLATTRIBUTE;}
   virtual tVoid vTakeVisitor(fi_tclVisitorBase& rfoVisitor);
};

class fi_tcl_TMOneCellDesc : public fi_tclVisitableTypeBase
{
public:
   fi_tcl_TMOneCellDesc():NavOneCell(),TMAttributes(),Portion(),AffectionType() {}
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   fi_tcl_TMOneCellDesc& operator=(const fi_tcl_TMOneCellDesc& coRef);
   fi_tcl_TMOneCellDesc(const fi_tcl_TMOneCellDesc& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
   fi_tcl_NavOneCellDesc NavOneCell;
   fi_tcl_b8_TMOneCellAttribute TMAttributes;
   fi_tcl_TMOneCellPortion Portion;
   fi_tcl_e8_TMAffectionType AffectionType;

   virtual tVoid vDestroy();
   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual tBool operator==(const fi_tcl_TMOneCellDesc& rfoCmp) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   virtual tS32 s32GetTypeId() const { return typesfi_tclToken::EN_TMONECELLDESC;}
   virtual tVoid vTakeVisitor(fi_tclVisitorBase& rfoVisitor);
};

class fi_tcl_NavLocationDataDesc : public fi_tclVisitableTypeBase
{
public:
   fi_tcl_NavLocationDataDesc():NavDataSetID(),IndexZFDestType(),poNavDataTypeData(0) {}
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   fi_tcl_NavLocationDataDesc& operator=(const fi_tcl_NavLocationDataDesc& coRef);
   fi_tcl_NavLocationDataDesc(const fi_tcl_NavLocationDataDesc& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
   fi_tcl_u32_DataSetId NavDataSetID;
   fi_tcl_e8_NavIndexZFDestinationType IndexZFDestType;
   std::vector<fi_tcl_PositionWGS84, std::allocator<fi_tcl_PositionWGS84> > ObjectPointRefList;
   std::vector<fi_tcl_PositionWGS84, std::allocator<fi_tcl_PositionWGS84> > AccessPointRefList;
   fi_tcl_e8_NavLocationNavDataType NavDataTypeType;
   fi_tclTypeBase* poNavDataTypeData;
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   virtual ~fi_tcl_NavLocationDataDesc();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   virtual tVoid vDestroy();
   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual tBool operator==(const fi_tcl_NavLocationDataDesc& rfoCmp) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   virtual tS32 s32GetTypeId() const { return typesfi_tclToken::EN_NAVLOCATIONDATADESC;}
   virtual tVoid vTakeVisitor(fi_tclVisitorBase& rfoVisitor);
};

class fi_tcl_u32_MediaId : public fi_tclVisitableTypeBase
{
public:
   fi_tcl_u32_MediaId(tU32 _u32Value = 0):u32Value(_u32Value) {} 

   tU32 u32Value;

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual tBool operator==(const fi_tcl_u32_MediaId& rfoCmp) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   virtual tS32 s32GetTypeId() const { return typesfi_tclToken::EN_U32_MEDIAID;}
   virtual tVoid vTakeVisitor(fi_tclVisitorBase& rfoVisitor);
};

class fi_tcl_EDMOneCellProp : public fi_tclVisitableTypeBase
{
public:
   fi_tcl_EDMOneCellProp():IsPrimary(0),IsInObject(0),IsInComplexIntersection(0),IsBuiltupArea(0),IsFreeway(0),IsFirst(0),IsLast(0),LaneNr(0),RoadClass(),Speed(0),VLI(0),AbsLength(),RelLength(),Portion() {}
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   fi_tcl_EDMOneCellProp& operator=(const fi_tcl_EDMOneCellProp& coRef);
   fi_tcl_EDMOneCellProp(const fi_tcl_EDMOneCellProp& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
   tBool IsPrimary;
   tBool IsInObject;
   tBool IsInComplexIntersection;
   tBool IsBuiltupArea;
   tBool IsFreeway;
   tBool IsFirst;
   tBool IsLast;
   tU8 LaneNr;
   fi_tcl_e8_RoadClassCode RoadClass;
   tF32 Speed;
   tF32 VLI;
   fi_tcl_s32_Meter AbsLength;
   fi_tcl_u8_Percent RelLength;
   fi_tcl_TMOneCellPortion Portion;

   virtual tVoid vDestroy();
   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual tBool operator==(const fi_tcl_EDMOneCellProp& rfoCmp) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   virtual tS32 s32GetTypeId() const { return typesfi_tclToken::EN_EDMONECELLPROP;}
   virtual tVoid vTakeVisitor(fi_tclVisitorBase& rfoVisitor);
};

class fi_tcl_e8_NavDataLevel : public fi_tclVisitableTypeBase
{
public:
   fi_tcl_e8_NavDataLevel():enType(FI_EN_DATA_LEVEL_0) {}

   enum tenType {
      FI_EN_DATA_LEVEL_0 = 0UL,
      FI_EN_DATA_LEVEL_1 = 1UL,
      FI_EN_DATA_LEVEL_2 = 2UL,
      FI_EN_DATA_LEVEL_3 = 3UL
   };
   tenType enType;

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual tBool operator==(const fi_tcl_e8_NavDataLevel& rfoCmp) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   virtual tS32 s32GetTypeId() const { return typesfi_tclToken::EN_E8_NAVDATALEVEL;}
   virtual tVoid vTakeVisitor(fi_tclVisitorBase& rfoVisitor);
};

class fi_tcl_TMIntersectionPath : public fi_tclVisitableTypeBase
{
public:
   fi_tcl_TMIntersectionPath():PathType() {}
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   fi_tcl_TMIntersectionPath& operator=(const fi_tcl_TMIntersectionPath& coRef);
   fi_tcl_TMIntersectionPath(const fi_tcl_TMIntersectionPath& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
   fi_tcl_e8_TMCIntersectionPathType PathType;
   std::vector<fi_tcl_TMIntersectionMatrix, std::allocator<fi_tcl_TMIntersectionMatrix> > LevelMatrix;

   virtual tVoid vDestroy();
   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual tBool operator==(const fi_tcl_TMIntersectionPath& rfoCmp) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   virtual tS32 s32GetTypeId() const { return typesfi_tclToken::EN_TMINTERSECTIONPATH;}
   virtual tVoid vTakeVisitor(fi_tclVisitorBase& rfoVisitor);
};

class fi_tcl_SameLevelOneCellBlock : public fi_tclVisitableTypeBase
{
public:
   fi_tcl_SameLevelOneCellBlock():Level(0) {}
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   fi_tcl_SameLevelOneCellBlock& operator=(const fi_tcl_SameLevelOneCellBlock& coRef);
   fi_tcl_SameLevelOneCellBlock(const fi_tcl_SameLevelOneCellBlock& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
   tU8 Level;
   std::vector<fi_tcl_NavClusterId, std::allocator<fi_tcl_NavClusterId> > ClusterIdList;
   std::vector<fi_tcl_LocalOneCellID, std::allocator<fi_tcl_LocalOneCellID> > OneCellIdList;
   std::vector<fi_tcl_OneCellRelation, std::allocator<fi_tcl_OneCellRelation> > OneCellRelationList;

   virtual tVoid vDestroy();
   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual tBool operator==(const fi_tcl_SameLevelOneCellBlock& rfoCmp) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   virtual tS32 s32GetTypeId() const { return typesfi_tclToken::EN_SAMELEVELONECELLBLOCK;}
   virtual tVoid vTakeVisitor(fi_tclVisitorBase& rfoVisitor);
};

class fi_tcl_NavSpotDestinationOneCellListSet : public fi_tclVisitableTypeBase
{
public:
   fi_tcl_NavSpotDestinationOneCellListSet() {}
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   fi_tcl_NavSpotDestinationOneCellListSet& operator=(const fi_tcl_NavSpotDestinationOneCellListSet& coRef);
   fi_tcl_NavSpotDestinationOneCellListSet(const fi_tcl_NavSpotDestinationOneCellListSet& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
   std::vector<fi_tcl_NavClusterDesc, std::allocator<fi_tcl_NavClusterDesc> > ClusterRefList;
   std::vector<fi_tcl_NavSpotDestinationOneCellDesc, std::allocator<fi_tcl_NavSpotDestinationOneCellDesc> > SpotDestinationOneCellRefList;

   virtual tVoid vDestroy();
   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual tBool operator==(const fi_tcl_NavSpotDestinationOneCellListSet& rfoCmp) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   virtual tS32 s32GetTypeId() const { return typesfi_tclToken::EN_NAVSPOTDESTINATIONONECELLLISTSET;}
   virtual tVoid vTakeVisitor(fi_tclVisitorBase& rfoVisitor);
};

class fi_tcl_NavPosOneCellProperty : public fi_tclVisitableTypeBase
{
public:
   fi_tcl_NavPosOneCellProperty():CountryCode(),OneCellLength(),RoadClass(),RoadType(),RoadNetworkClass(),OneCellStatus(),StateCode(0) {}
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   fi_tcl_NavPosOneCellProperty& operator=(const fi_tcl_NavPosOneCellProperty& coRef);
   fi_tcl_NavPosOneCellProperty(const fi_tcl_NavPosOneCellProperty& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
   fi_tcl_e16_ISOCountryCode CountryCode;
   fi_tcl_s32_EMU OneCellLength;
   fi_tcl_e8_RoadClassCode RoadClass;
   fi_tcl_e8_NavStreetType RoadType;
   fi_tcl_e8_RoadNetworkClass RoadNetworkClass;
   fi_tcl_b32_RoadProperty OneCellStatus;
   tU32 StateCode;

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual tBool operator==(const fi_tcl_NavPosOneCellProperty& rfoCmp) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   virtual tS32 s32GetTypeId() const { return typesfi_tclToken::EN_NAVPOSONECELLPROPERTY;}
   virtual tVoid vTakeVisitor(fi_tclVisitorBase& rfoVisitor);
};

class fi_tcl_NavIntersectionDestinationZeroCellListSet : public fi_tclVisitableTypeBase
{
public:
   fi_tcl_NavIntersectionDestinationZeroCellListSet() {}
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   fi_tcl_NavIntersectionDestinationZeroCellListSet& operator=(const fi_tcl_NavIntersectionDestinationZeroCellListSet& coRef);
   fi_tcl_NavIntersectionDestinationZeroCellListSet(const fi_tcl_NavIntersectionDestinationZeroCellListSet& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
   std::vector<fi_tcl_NavClusterDesc, std::allocator<fi_tcl_NavClusterDesc> > ClusterRefList;
   std::vector<fi_tcl_NavIntersectionDestinationZeroCellDesc, std::allocator<fi_tcl_NavIntersectionDestinationZeroCellDesc> > IntersectionDestinationZeroCellRefList;

   virtual tVoid vDestroy();
   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual tBool operator==(const fi_tcl_NavIntersectionDestinationZeroCellListSet& rfoCmp) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   virtual tS32 s32GetTypeId() const { return typesfi_tclToken::EN_NAVINTERSECTIONDESTINATIONZEROCELLLISTSET;}
   virtual tVoid vTakeVisitor(fi_tclVisitorBase& rfoVisitor);
};

class fi_tcl_NavOneCell : public fi_tclVisitableTypeBase
{
public:
   fi_tcl_NavOneCell():OneCellId(0),UseDirection(),ClusterFileId(0),ClusterFileOffset(0),ClusterLength(0) {}
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   fi_tcl_NavOneCell& operator=(const fi_tcl_NavOneCell& coRef);
   fi_tcl_NavOneCell(const fi_tcl_NavOneCell& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
   tU16 OneCellId;
   fi_tcl_e8_NavOneCellDirection UseDirection;
   tU16 ClusterFileId;
   tU32 ClusterFileOffset;
   tU16 ClusterLength;

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual tBool operator==(const fi_tcl_NavOneCell& rfoCmp) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   virtual tS32 s32GetTypeId() const { return typesfi_tclToken::EN_NAVONECELL;}
   virtual tVoid vTakeVisitor(fi_tclVisitorBase& rfoVisitor);
};

class fi_tcl_SignPostElement : public fi_tclVisitableTypeBase
{
public:
   fi_tcl_SignPostElement():poNavOneCellCategoryData(0),Status() {}
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   fi_tcl_SignPostElement& operator=(const fi_tcl_SignPostElement& coRef);
   fi_tcl_SignPostElement(const fi_tcl_SignPostElement& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
   fi_tcl_e8_NavOneCellCategory NavOneCellCategoryType;
   fi_tclTypeBase* poNavOneCellCategoryData;
   fi_tcl_e8_SignPostDestStatus Status;
   std::vector<fi_tcl_SignPostDestination, std::allocator<fi_tcl_SignPostDestination> > SignPostDestination;
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   virtual ~fi_tcl_SignPostElement();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   virtual tVoid vDestroy();
   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual tBool operator==(const fi_tcl_SignPostElement& rfoCmp) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   virtual tS32 s32GetTypeId() const { return typesfi_tclToken::EN_SIGNPOSTELEMENT;}
   virtual tVoid vTakeVisitor(fi_tclVisitorBase& rfoVisitor);
};

class fi_tcl_NavDLDChainOneCellProperty : public fi_tclVisitableTypeBase
{
public:
   fi_tcl_NavDLDChainOneCellProperty():LengthFromFirstOC(),TurnLengthOnFollowingIntersection() {}
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   fi_tcl_NavDLDChainOneCellProperty& operator=(const fi_tcl_NavDLDChainOneCellProperty& coRef);
   fi_tcl_NavDLDChainOneCellProperty(const fi_tcl_NavDLDChainOneCellProperty& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
   fi_tcl_s32_Meter LengthFromFirstOC;
   fi_tcl_s32_Meter TurnLengthOnFollowingIntersection;

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual tBool operator==(const fi_tcl_NavDLDChainOneCellProperty& rfoCmp) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   virtual tS32 s32GetTypeId() const { return typesfi_tclToken::EN_NAVDLDCHAINONECELLPROPERTY;}
   virtual tVoid vTakeVisitor(fi_tclVisitorBase& rfoVisitor);
};

class fi_tcl_NavDLDChainOneCellDesc : public fi_tclVisitableTypeBase
{
public:
   fi_tcl_NavDLDChainOneCellDesc():OneCellDesc(),OneCellProperty() {}
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   fi_tcl_NavDLDChainOneCellDesc& operator=(const fi_tcl_NavDLDChainOneCellDesc& coRef);
   fi_tcl_NavDLDChainOneCellDesc(const fi_tcl_NavDLDChainOneCellDesc& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
   fi_tcl_NavOneCellDesc OneCellDesc;
   fi_tcl_NavDLDChainOneCellProperty OneCellProperty;

   virtual tVoid vDestroy();
   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual tBool operator==(const fi_tcl_NavDLDChainOneCellDesc& rfoCmp) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   virtual tS32 s32GetTypeId() const { return typesfi_tclToken::EN_NAVDLDCHAINONECELLDESC;}
   virtual tVoid vTakeVisitor(fi_tclVisitorBase& rfoVisitor);
};

class fi_tcl_NavDLDChainOneCellListSet : public fi_tclVisitableTypeBase
{
public:
   fi_tcl_NavDLDChainOneCellListSet() {}
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   fi_tcl_NavDLDChainOneCellListSet& operator=(const fi_tcl_NavDLDChainOneCellListSet& coRef);
   fi_tcl_NavDLDChainOneCellListSet(const fi_tcl_NavDLDChainOneCellListSet& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
   std::vector<fi_tcl_NavClusterDesc, std::allocator<fi_tcl_NavClusterDesc> > ClusterRefList;
   std::vector<fi_tcl_NavDLDChainOneCellDesc, std::allocator<fi_tcl_NavDLDChainOneCellDesc> > OneCellRefList;

   virtual tVoid vDestroy();
   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual tBool operator==(const fi_tcl_NavDLDChainOneCellListSet& rfoCmp) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   virtual tS32 s32GetTypeId() const { return typesfi_tclToken::EN_NAVDLDCHAINONECELLLISTSET;}
   virtual tVoid vTakeVisitor(fi_tclVisitorBase& rfoVisitor);
};

#ifndef FI_S_EXTERNAL_FI
class fi_tcl_NavUTMBinContainer : public fi_tclVisitableTypeBase
{
public:
   fi_tcl_NavUTMBinContainer():ContainerLength(0),ServiceID(0),ContainerFIVersion(),ContainerType(),NavDataSetID(),UTMOneCellListSet() {}
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   fi_tcl_NavUTMBinContainer& operator=(const fi_tcl_NavUTMBinContainer& coRef);
   fi_tcl_NavUTMBinContainer(const fi_tcl_NavUTMBinContainer& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
   tU32 ContainerLength;
   tU16 ServiceID;
   fi_tcl_FIVersion ContainerFIVersion;
   fi_tcl_e8_BinContainerTypes ContainerType;
   fi_tcl_u32_DataSetId NavDataSetID;
   fi_tcl_NavDLDChainOneCellListSet UTMOneCellListSet;

   virtual tVoid vDestroy();
   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual tBool operator==(const fi_tcl_NavUTMBinContainer& rfoCmp) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   virtual tS32 s32GetTypeId() const { return typesfi_tclToken::EN_NAVUTMBINCONTAINER;}
   virtual tVoid vTakeVisitor(fi_tclVisitorBase& rfoVisitor);
   tU16 u16Transform(const fi_tcl_BinContainer& oContainer);
   static const tU16 C_U16_MAJORVERSION_MAX;
   static const tU16 C_U16_MAJORVERSION_MIN;
};

#endif // FI_S_EXTERNAL_FI
class fi_tcl_e8_WeatherProtocol : public fi_tclVisitableTypeBase
{
public:
   fi_tcl_e8_WeatherProtocol():enType(FI_EN_UNKNOWN) {}

   enum tenType {
      FI_EN_UNKNOWN = 0UL,
      FI_EN_METAR = 1UL,
      FI_EN_CCF = 2UL,
      FI_EN_COUNTYWARNING = 3UL,
      FI_EN_TABULARWEATHER = 4UL,
      FI_EN_TABULARSKI = 5UL,
      FI_EN_GRAPHICALRADAR = 6UL,
      FI_EN_ALERTS = 7UL,
      FI_EN_GRAPHICALRADARANIMATION = 8UL,
      FI_EN_GRAPHICALSURFACE = 9UL,
      FI_EN_GRAPHICALSTORMATTRIBUTES = 10UL,
      FI_EN_GRAPHICALSTORMTRACK = 11UL,
      FI_EN_GRAPHICALWINDDIRECTION = 12UL,
      FI_EN_GRAPHICALWINDMAGNITUDE = 13UL
   };
   tenType enType;

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual tBool operator==(const fi_tcl_e8_WeatherProtocol& rfoCmp) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   virtual tS32 s32GetTypeId() const { return typesfi_tclToken::EN_E8_WEATHERPROTOCOL;}
   virtual tVoid vTakeVisitor(fi_tclVisitorBase& rfoVisitor);
};

class fi_tcl_b8_CriterionStatus : public fi_tclVisitableTypeBase
{
public:
   fi_tcl_b8_CriterionStatus():u8Value(0) {}

   enum {
      FI_C_U8_BIT_AMBIGUITYRESOLVING = 0x1UL
   };
   tBool bAmbiguityResolving() const {return (u8Value & FI_C_U8_BIT_AMBIGUITYRESOLVING) != 0; }
   tVoid vSetAmbiguityResolving(tBool bSetBit) { u8Value = (bSetBit)?(u8Value | FI_C_U8_BIT_AMBIGUITYRESOLVING):(u8Value & ~FI_C_U8_BIT_AMBIGUITYRESOLVING); }
   struct rBitValues {
      unsigned int AmbiguityResolving:1;
      unsigned int dummy1:1;
      unsigned int dummy2:1;
      unsigned int dummy3:1;
      unsigned int dummy4:1;
      unsigned int dummy5:1;
      unsigned int dummy6:1;
      unsigned int dummy7:1;
   };
   union {
      tU8 u8Value;
      rBitValues bits;
   };

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual tBool operator==(const fi_tcl_b8_CriterionStatus& rfoCmp) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   virtual tS32 s32GetTypeId() const { return typesfi_tclToken::EN_B8_CRITERIONSTATUS;}
   virtual tVoid vTakeVisitor(fi_tclVisitorBase& rfoVisitor);
};

class fi_tcl_AddressTemplate : public fi_tclVisitableTypeBase
{
public:
   fi_tcl_AddressTemplate():CountryCode() {}
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   fi_tcl_AddressTemplate& operator=(const fi_tcl_AddressTemplate& coRef);
   fi_tcl_AddressTemplate(const fi_tcl_AddressTemplate& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
   fi_tcl_e16_ISOCountryCode CountryCode;
   std::vector<fi_tcl_e16_SelectionCriterionType, std::allocator<fi_tcl_e16_SelectionCriterionType> > SelectionCriteria;

   virtual tVoid vDestroy();
   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual tBool operator==(const fi_tcl_AddressTemplate& rfoCmp) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   virtual tS32 s32GetTypeId() const { return typesfi_tclToken::EN_ADDRESSTEMPLATE;}
   virtual tVoid vTakeVisitor(fi_tclVisitorBase& rfoVisitor);
};

class fi_tcl_e8_FilterAttributeType : public fi_tclVisitableTypeBase
{
public:
   fi_tcl_e8_FilterAttributeType():enType(FI_EN_RESERVED) {}

   enum tenType {
      FI_EN_RESERVED = 0UL,
      FI_EN_ATTRIBUTEGROUP = 1UL,
      FI_EN_SELECTABLEGROUPATTRIBUTE = 2UL,
      FI_EN_SELECTABLESINGLEATTRIBUTE = 3UL,
      FI_EN_SUBCATEGORYGROUP = 4UL,
      FI_EN_MENUITEM = 5UL
   };
   tenType enType;

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual tBool operator==(const fi_tcl_e8_FilterAttributeType& rfoCmp) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   virtual tS32 s32GetTypeId() const { return typesfi_tclToken::EN_E8_FILTERATTRIBUTETYPE;}
   virtual tVoid vTakeVisitor(fi_tclVisitorBase& rfoVisitor);
};

class fi_tcl_FilterAttribute : public fi_tclVisitableTypeBase
{
public:
   fi_tcl_FilterAttribute():Type(),Code(0),Name() {}
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   fi_tcl_FilterAttribute& operator=(const fi_tcl_FilterAttribute& coRef);
   fi_tcl_FilterAttribute(const fi_tcl_FilterAttribute& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
   fi_tcl_e8_FilterAttributeType Type;
   tU16 Code;
   fi_tclString Name;

   virtual tVoid vDestroy();
   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual tBool operator==(const fi_tcl_FilterAttribute& rfoCmp) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   virtual tS32 s32GetTypeId() const { return typesfi_tclToken::EN_FILTERATTRIBUTE;}
   virtual tVoid vTakeVisitor(fi_tclVisitorBase& rfoVisitor);
};

class fi_tcl_e16_MenuItemType : public fi_tclVisitableTypeBase
{
public:
   fi_tcl_e16_MenuItemType():enType(FI_EN_RESERVED) {}

   enum tenType {
      FI_EN_RESERVED = 0UL,
      FI_EN_ALL = 1UL,
      FI_EN_FILTERSETTINGS = 2UL
   };
   tenType enType;

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual tBool operator==(const fi_tcl_e16_MenuItemType& rfoCmp) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   virtual tS32 s32GetTypeId() const { return typesfi_tclToken::EN_E16_MENUITEMTYPE;}
   virtual tVoid vTakeVisitor(fi_tclVisitorBase& rfoVisitor);
};

class fi_tcl_e8_LocationValueListType : public fi_tclVisitableTypeBase
{
public:
   fi_tcl_e8_LocationValueListType():enType(FI_EN_T_RESERVED) {}

   enum tenType {
      FI_EN_T_RESERVED = 0UL,
      FI_EN_T_STRINGLIST = 1UL,
      FI_EN_T_STRINGDESCRIPTIONLIST = 2UL,
      FI_EN_T_STRINGIDLIST = 3UL,
      FI_EN_T_POSITIONWGS84LIST = 18UL,
      FI_EN_T_STRINGPOSITIONLIST = 23UL,
      FI_EN_T_STRINGPOSITIONDESCRIPTIONLIST = 24UL
   };
   tenType enType;

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual tBool operator==(const fi_tcl_e8_LocationValueListType& rfoCmp) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   virtual tS32 s32GetTypeId() const { return typesfi_tclToken::EN_E8_LOCATIONVALUELISTTYPE;}
   virtual tVoid vTakeVisitor(fi_tclVisitorBase& rfoVisitor);
};

class fi_tcl_b8_ListResultOptions : public fi_tclVisitableTypeBase
{
public:
   fi_tcl_b8_ListResultOptions():u8Value(0) {}

   enum {
      FI_C_U8_BIT_PREVPAGE = 0x1UL,
      FI_C_U8_BIT_NEXTPAGE = 0x2UL,
      FI_C_U8_BIT_DATABASEINCOMPLETE = 0x4UL
   };
   tBool bPrevPage() const {return (u8Value & FI_C_U8_BIT_PREVPAGE) != 0; }
   tVoid vSetPrevPage(tBool bSetBit) { u8Value = (bSetBit)?(u8Value | FI_C_U8_BIT_PREVPAGE):(u8Value & ~FI_C_U8_BIT_PREVPAGE); }
   tBool bNextPage() const {return (u8Value & FI_C_U8_BIT_NEXTPAGE) != 0; }
   tVoid vSetNextPage(tBool bSetBit) { u8Value = (bSetBit)?(u8Value | FI_C_U8_BIT_NEXTPAGE):(u8Value & ~FI_C_U8_BIT_NEXTPAGE); }
   tBool bDatabaseIncomplete() const {return (u8Value & FI_C_U8_BIT_DATABASEINCOMPLETE) != 0; }
   tVoid vSetDatabaseIncomplete(tBool bSetBit) { u8Value = (bSetBit)?(u8Value | FI_C_U8_BIT_DATABASEINCOMPLETE):(u8Value & ~FI_C_U8_BIT_DATABASEINCOMPLETE); }
   struct rBitValues {
      unsigned int PrevPage:1;
      unsigned int NextPage:1;
      unsigned int DatabaseIncomplete:1;
      unsigned int dummy3:1;
      unsigned int dummy4:1;
      unsigned int dummy5:1;
      unsigned int dummy6:1;
      unsigned int dummy7:1;
   };
   union {
      tU8 u8Value;
      rBitValues bits;
   };

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual tBool operator==(const fi_tcl_b8_ListResultOptions& rfoCmp) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   virtual tS32 s32GetTypeId() const { return typesfi_tclToken::EN_B8_LISTRESULTOPTIONS;}
   virtual tVoid vTakeVisitor(fi_tclVisitorBase& rfoVisitor);
};

class fi_tcl_b8_ListGetOptions : public fi_tclVisitableTypeBase
{
public:
   fi_tcl_b8_ListGetOptions():u8Value(0) {}

   enum {
      FI_C_U8_BIT_MATCHFORREDUCTION = 0x1UL,
      FI_C_U8_BIT_INCLUDEAMBIGUOUSELEMENTS = 0x2UL,
      FI_C_U8_BIT_EXCLUDEALTERNATIVENAMES = 0x4UL,
      FI_C_U8_BIT_CASECORRECTSPELLING = 0x8UL,
      FI_C_U8_BIT_LOWERCASE = 0x10UL,
      FI_C_U8_BIT_ASINDATA = 0x20UL,
      FI_C_U8_BIT_INCLUDEALLEXONYMS = 0x40UL,
      FI_C_U8_BIT_MAPGROUPINATTRIBUTES = 0x80UL
   };
   tBool bMatchForReduction() const {return (u8Value & FI_C_U8_BIT_MATCHFORREDUCTION) != 0; }
   tVoid vSetMatchForReduction(tBool bSetBit) { u8Value = (bSetBit)?(u8Value | FI_C_U8_BIT_MATCHFORREDUCTION):(u8Value & ~FI_C_U8_BIT_MATCHFORREDUCTION); }
   tBool bIncludeAmbiguousElements() const {return (u8Value & FI_C_U8_BIT_INCLUDEAMBIGUOUSELEMENTS) != 0; }
   tVoid vSetIncludeAmbiguousElements(tBool bSetBit) { u8Value = (bSetBit)?(u8Value | FI_C_U8_BIT_INCLUDEAMBIGUOUSELEMENTS):(u8Value & ~FI_C_U8_BIT_INCLUDEAMBIGUOUSELEMENTS); }
   tBool bExcludeAlternativeNames() const {return (u8Value & FI_C_U8_BIT_EXCLUDEALTERNATIVENAMES) != 0; }
   tVoid vSetExcludeAlternativeNames(tBool bSetBit) { u8Value = (bSetBit)?(u8Value | FI_C_U8_BIT_EXCLUDEALTERNATIVENAMES):(u8Value & ~FI_C_U8_BIT_EXCLUDEALTERNATIVENAMES); }
   tBool bCaseCorrectSpelling() const {return (u8Value & FI_C_U8_BIT_CASECORRECTSPELLING) != 0; }
   tVoid vSetCaseCorrectSpelling(tBool bSetBit) { u8Value = (bSetBit)?(u8Value | FI_C_U8_BIT_CASECORRECTSPELLING):(u8Value & ~FI_C_U8_BIT_CASECORRECTSPELLING); }
   tBool bLowerCase() const {return (u8Value & FI_C_U8_BIT_LOWERCASE) != 0; }
   tVoid vSetLowerCase(tBool bSetBit) { u8Value = (bSetBit)?(u8Value | FI_C_U8_BIT_LOWERCASE):(u8Value & ~FI_C_U8_BIT_LOWERCASE); }
   tBool bAsInData() const {return (u8Value & FI_C_U8_BIT_ASINDATA) != 0; }
   tVoid vSetAsInData(tBool bSetBit) { u8Value = (bSetBit)?(u8Value | FI_C_U8_BIT_ASINDATA):(u8Value & ~FI_C_U8_BIT_ASINDATA); }
   tBool bIncludeAllExonyms() const {return (u8Value & FI_C_U8_BIT_INCLUDEALLEXONYMS) != 0; }
   tVoid vSetIncludeAllExonyms(tBool bSetBit) { u8Value = (bSetBit)?(u8Value | FI_C_U8_BIT_INCLUDEALLEXONYMS):(u8Value & ~FI_C_U8_BIT_INCLUDEALLEXONYMS); }
   tBool bMapGroupInAttributes() const {return (u8Value & FI_C_U8_BIT_MAPGROUPINATTRIBUTES) != 0; }
   tVoid vSetMapGroupInAttributes(tBool bSetBit) { u8Value = (bSetBit)?(u8Value | FI_C_U8_BIT_MAPGROUPINATTRIBUTES):(u8Value & ~FI_C_U8_BIT_MAPGROUPINATTRIBUTES); }
   struct rBitValues {
      unsigned int MatchForReduction:1;
      unsigned int IncludeAmbiguousElements:1;
      unsigned int ExcludeAlternativeNames:1;
      unsigned int CaseCorrectSpelling:1;
      unsigned int LowerCase:1;
      unsigned int AsInData:1;
      unsigned int IncludeAllExonyms:1;
      unsigned int MapGroupInAttributes:1;
   };
   union {
      tU8 u8Value;
      rBitValues bits;
   };

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual tBool operator==(const fi_tcl_b8_ListGetOptions& rfoCmp) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   virtual tS32 s32GetTypeId() const { return typesfi_tclToken::EN_B8_LISTGETOPTIONS;}
   virtual tVoid vTakeVisitor(fi_tclVisitorBase& rfoVisitor);
};

class fi_tcl_LocationValueListUnion : public fi_tclVisitableTypeBase
{
public:
   fi_tcl_LocationValueListUnion():poValueListData(0) {}
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   fi_tcl_LocationValueListUnion& operator=(const fi_tcl_LocationValueListUnion& coRef);
   fi_tcl_LocationValueListUnion(const fi_tcl_LocationValueListUnion& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
   fi_tcl_e8_LocationValueListType ValueListType;
   fi_tclTypeBase* poValueListData;
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   virtual ~fi_tcl_LocationValueListUnion();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   virtual tVoid vDestroy();
   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual tBool operator==(const fi_tcl_LocationValueListUnion& rfoCmp) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   virtual tS32 s32GetTypeId() const { return typesfi_tclToken::EN_LOCATIONVALUELISTUNION;}
   virtual tVoid vTakeVisitor(fi_tclVisitorBase& rfoVisitor);
};

class fi_tcl_ListElement : public fi_tclVisitableTypeBase
{
public:
   fi_tcl_ListElement():Position(),Properties(),Name(),Description() {}
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   fi_tcl_ListElement& operator=(const fi_tcl_ListElement& coRef);
   fi_tcl_ListElement(const fi_tcl_ListElement& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
   fi_tcl_PositionWGS84 Position;
   fi_tcl_b16_ElementProperties Properties;
   fi_tclString Name;
   fi_tclString Description;

   virtual tVoid vDestroy();
   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual tBool operator==(const fi_tcl_ListElement& rfoCmp) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   virtual tS32 s32GetTypeId() const { return typesfi_tclToken::EN_LISTELEMENT;}
   virtual tVoid vTakeVisitor(fi_tclVisitorBase& rfoVisitor);
};

class fi_tcl_StringElement : public fi_tclVisitableTypeBase
{
public:
   fi_tcl_StringElement():Properties(),String() {}
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   fi_tcl_StringElement& operator=(const fi_tcl_StringElement& coRef);
   fi_tcl_StringElement(const fi_tcl_StringElement& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
   fi_tcl_b16_ElementProperties Properties;
   fi_tclString String;

   virtual tVoid vDestroy();
   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual tBool operator==(const fi_tcl_StringElement& rfoCmp) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   virtual tS32 s32GetTypeId() const { return typesfi_tclToken::EN_STRINGELEMENT;}
   virtual tVoid vTakeVisitor(fi_tclVisitorBase& rfoVisitor);
};

class fi_tcl_StringList : public fi_tclVisitableTypeBase
{
public:
   fi_tcl_StringList() {}
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   fi_tcl_StringList& operator=(const fi_tcl_StringList& coRef);
   fi_tcl_StringList(const fi_tcl_StringList& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
   std::vector<fi_tcl_StringElement, std::allocator<fi_tcl_StringElement> > StringList;

   virtual tVoid vDestroy();
   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual tBool operator==(const fi_tcl_StringList& rfoCmp) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   virtual tS32 s32GetTypeId() const { return typesfi_tclToken::EN_STRINGLIST;}
   virtual tVoid vTakeVisitor(fi_tclVisitorBase& rfoVisitor);
};

class fi_tcl_StringDescriptionElement : public fi_tclVisitableTypeBase
{
public:
   fi_tcl_StringDescriptionElement():Properties(),ElementString(),DescriptionString() {}
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   fi_tcl_StringDescriptionElement& operator=(const fi_tcl_StringDescriptionElement& coRef);
   fi_tcl_StringDescriptionElement(const fi_tcl_StringDescriptionElement& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
   fi_tcl_b16_ElementProperties Properties;
   fi_tclString ElementString;
   fi_tclString DescriptionString;

   virtual tVoid vDestroy();
   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual tBool operator==(const fi_tcl_StringDescriptionElement& rfoCmp) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   virtual tS32 s32GetTypeId() const { return typesfi_tclToken::EN_STRINGDESCRIPTIONELEMENT;}
   virtual tVoid vTakeVisitor(fi_tclVisitorBase& rfoVisitor);
};

class fi_tcl_StringDescriptionList : public fi_tclVisitableTypeBase
{
public:
   fi_tcl_StringDescriptionList() {}
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   fi_tcl_StringDescriptionList& operator=(const fi_tcl_StringDescriptionList& coRef);
   fi_tcl_StringDescriptionList(const fi_tcl_StringDescriptionList& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
   std::vector<fi_tcl_StringDescriptionElement, std::allocator<fi_tcl_StringDescriptionElement> > StringDescriptionList;

   virtual tVoid vDestroy();
   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual tBool operator==(const fi_tcl_StringDescriptionList& rfoCmp) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   virtual tS32 s32GetTypeId() const { return typesfi_tclToken::EN_STRINGDESCRIPTIONLIST;}
   virtual tVoid vTakeVisitor(fi_tclVisitorBase& rfoVisitor);
};

class fi_tcl_StringID : public fi_tclVisitableTypeBase
{
public:
   fi_tcl_StringID():String(),ID(0) {}
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   fi_tcl_StringID& operator=(const fi_tcl_StringID& coRef);
   fi_tcl_StringID(const fi_tcl_StringID& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
   fi_tclString String;
   tU32 ID;

   virtual tVoid vDestroy();
   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual tBool operator==(const fi_tcl_StringID& rfoCmp) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   virtual tS32 s32GetTypeId() const { return typesfi_tclToken::EN_STRINGID;}
   virtual tVoid vTakeVisitor(fi_tclVisitorBase& rfoVisitor);
};

class fi_tcl_StringIDElement : public fi_tclVisitableTypeBase
{
public:
   fi_tcl_StringIDElement():Properties(),StringID() {}
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   fi_tcl_StringIDElement& operator=(const fi_tcl_StringIDElement& coRef);
   fi_tcl_StringIDElement(const fi_tcl_StringIDElement& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
   fi_tcl_b16_ElementProperties Properties;
   fi_tcl_StringID StringID;

   virtual tVoid vDestroy();
   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual tBool operator==(const fi_tcl_StringIDElement& rfoCmp) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   virtual tS32 s32GetTypeId() const { return typesfi_tclToken::EN_STRINGIDELEMENT;}
   virtual tVoid vTakeVisitor(fi_tclVisitorBase& rfoVisitor);
};

class fi_tcl_PositionWGS84Element : public fi_tclVisitableTypeBase
{
public:
   fi_tcl_PositionWGS84Element():Properties(),PositionWGS84() {}
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   fi_tcl_PositionWGS84Element& operator=(const fi_tcl_PositionWGS84Element& coRef);
   fi_tcl_PositionWGS84Element(const fi_tcl_PositionWGS84Element& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
   fi_tcl_b16_ElementProperties Properties;
   fi_tcl_PositionWGS84 PositionWGS84;

   virtual tVoid vDestroy();
   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual tBool operator==(const fi_tcl_PositionWGS84Element& rfoCmp) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   virtual tS32 s32GetTypeId() const { return typesfi_tclToken::EN_POSITIONWGS84ELEMENT;}
   virtual tVoid vTakeVisitor(fi_tclVisitorBase& rfoVisitor);
};

class fi_tcl_PositionWGS84List : public fi_tclVisitableTypeBase
{
public:
   fi_tcl_PositionWGS84List() {}
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   fi_tcl_PositionWGS84List& operator=(const fi_tcl_PositionWGS84List& coRef);
   fi_tcl_PositionWGS84List(const fi_tcl_PositionWGS84List& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
   std::vector<fi_tcl_PositionWGS84Element, std::allocator<fi_tcl_PositionWGS84Element> > PositionWGS84List;

   virtual tVoid vDestroy();
   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual tBool operator==(const fi_tcl_PositionWGS84List& rfoCmp) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   virtual tS32 s32GetTypeId() const { return typesfi_tclToken::EN_POSITIONWGS84LIST;}
   virtual tVoid vTakeVisitor(fi_tclVisitorBase& rfoVisitor);
};

class fi_tcl_StringPosition : public fi_tclVisitableTypeBase
{
public:
   fi_tcl_StringPosition():String(),Position() {}
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   fi_tcl_StringPosition& operator=(const fi_tcl_StringPosition& coRef);
   fi_tcl_StringPosition(const fi_tcl_StringPosition& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
   fi_tclString String;
   fi_tcl_PositionWGS84 Position;

   virtual tVoid vDestroy();
   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual tBool operator==(const fi_tcl_StringPosition& rfoCmp) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   virtual tS32 s32GetTypeId() const { return typesfi_tclToken::EN_STRINGPOSITION;}
   virtual tVoid vTakeVisitor(fi_tclVisitorBase& rfoVisitor);
};

class fi_tcl_StringPositionElement : public fi_tclVisitableTypeBase
{
public:
   fi_tcl_StringPositionElement():Properties(),StringPosition() {}
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   fi_tcl_StringPositionElement& operator=(const fi_tcl_StringPositionElement& coRef);
   fi_tcl_StringPositionElement(const fi_tcl_StringPositionElement& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
   fi_tcl_b16_ElementProperties Properties;
   fi_tcl_StringPosition StringPosition;

   virtual tVoid vDestroy();
   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual tBool operator==(const fi_tcl_StringPositionElement& rfoCmp) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   virtual tS32 s32GetTypeId() const { return typesfi_tclToken::EN_STRINGPOSITIONELEMENT;}
   virtual tVoid vTakeVisitor(fi_tclVisitorBase& rfoVisitor);
};

class fi_tcl_StringPositionDescriptionElement : public fi_tclVisitableTypeBase
{
public:
   fi_tcl_StringPositionDescriptionElement():Properties(),ElementStringPosition(),DescriptionString() {}
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   fi_tcl_StringPositionDescriptionElement& operator=(const fi_tcl_StringPositionDescriptionElement& coRef);
   fi_tcl_StringPositionDescriptionElement(const fi_tcl_StringPositionDescriptionElement& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
   fi_tcl_b16_ElementProperties Properties;
   fi_tcl_StringPosition ElementStringPosition;
   fi_tclString DescriptionString;

   virtual tVoid vDestroy();
   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual tBool operator==(const fi_tcl_StringPositionDescriptionElement& rfoCmp) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   virtual tS32 s32GetTypeId() const { return typesfi_tclToken::EN_STRINGPOSITIONDESCRIPTIONELEMENT;}
   virtual tVoid vTakeVisitor(fi_tclVisitorBase& rfoVisitor);
};

class fi_tcl_StringPositionDescriptionList : public fi_tclVisitableTypeBase
{
public:
   fi_tcl_StringPositionDescriptionList() {}
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   fi_tcl_StringPositionDescriptionList& operator=(const fi_tcl_StringPositionDescriptionList& coRef);
   fi_tcl_StringPositionDescriptionList(const fi_tcl_StringPositionDescriptionList& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
   std::vector<fi_tcl_StringPositionDescriptionElement, std::allocator<fi_tcl_StringPositionDescriptionElement> > StringPositionDescriptionList;

   virtual tVoid vDestroy();
   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual tBool operator==(const fi_tcl_StringPositionDescriptionList& rfoCmp) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   virtual tS32 s32GetTypeId() const { return typesfi_tclToken::EN_STRINGPOSITIONDESCRIPTIONLIST;}
   virtual tVoid vTakeVisitor(fi_tclVisitorBase& rfoVisitor);
};

class fi_tcl_b8_ListSortOptions : public fi_tclVisitableTypeBase
{
public:
   fi_tcl_b8_ListSortOptions():u8Value(0) {}

   enum {
      FI_C_U8_BIT_NONSORTED = 0x1UL,
      FI_C_U8_BIT_SORTBYALPHABETICALORDER = 0x2UL,
      FI_C_U8_BIT_SORTBYAIRDISTANCE = 0x4UL,
      FI_C_U8_BIT_SORTBYROUTEDISTANCE = 0x8UL,
      FI_C_U8_BIT_SORTBYSIMILARITY = 0x10UL
   };
   tBool bNonSorted() const {return (u8Value & FI_C_U8_BIT_NONSORTED) != 0; }
   tVoid vSetNonSorted(tBool bSetBit) { u8Value = (bSetBit)?(u8Value | FI_C_U8_BIT_NONSORTED):(u8Value & ~FI_C_U8_BIT_NONSORTED); }
   tBool bSortByAlphabeticalOrder() const {return (u8Value & FI_C_U8_BIT_SORTBYALPHABETICALORDER) != 0; }
   tVoid vSetSortByAlphabeticalOrder(tBool bSetBit) { u8Value = (bSetBit)?(u8Value | FI_C_U8_BIT_SORTBYALPHABETICALORDER):(u8Value & ~FI_C_U8_BIT_SORTBYALPHABETICALORDER); }
   tBool bSortByAirDistance() const {return (u8Value & FI_C_U8_BIT_SORTBYAIRDISTANCE) != 0; }
   tVoid vSetSortByAirDistance(tBool bSetBit) { u8Value = (bSetBit)?(u8Value | FI_C_U8_BIT_SORTBYAIRDISTANCE):(u8Value & ~FI_C_U8_BIT_SORTBYAIRDISTANCE); }
   tBool bSortByRouteDistance() const {return (u8Value & FI_C_U8_BIT_SORTBYROUTEDISTANCE) != 0; }
   tVoid vSetSortByRouteDistance(tBool bSetBit) { u8Value = (bSetBit)?(u8Value | FI_C_U8_BIT_SORTBYROUTEDISTANCE):(u8Value & ~FI_C_U8_BIT_SORTBYROUTEDISTANCE); }
   tBool bSortBySimilarity() const {return (u8Value & FI_C_U8_BIT_SORTBYSIMILARITY) != 0; }
   tVoid vSetSortBySimilarity(tBool bSetBit) { u8Value = (bSetBit)?(u8Value | FI_C_U8_BIT_SORTBYSIMILARITY):(u8Value & ~FI_C_U8_BIT_SORTBYSIMILARITY); }
   struct rBitValues {
      unsigned int NonSorted:1;
      unsigned int SortByAlphabeticalOrder:1;
      unsigned int SortByAirDistance:1;
      unsigned int SortByRouteDistance:1;
      unsigned int SortBySimilarity:1;
      unsigned int dummy5:1;
      unsigned int dummy6:1;
      unsigned int dummy7:1;
   };
   union {
      tU8 u8Value;
      rBitValues bits;
   };

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual tBool operator==(const fi_tcl_b8_ListSortOptions& rfoCmp) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   virtual tS32 s32GetTypeId() const { return typesfi_tclToken::EN_B8_LISTSORTOPTIONS;}
   virtual tVoid vTakeVisitor(fi_tclVisitorBase& rfoVisitor);
};

class fi_tcl_e8_LocationDescriptionDataType : public fi_tclVisitableTypeBase
{
public:
   fi_tcl_e8_LocationDescriptionDataType():enType(FI_EN_T_RESERVED) {}

   enum tenType {
      FI_EN_T_RESERVED = 0UL,
      FI_EN_TSTRING = 1UL,
      FI_EN_T_STRINGID = 3UL,
      FI_EN_T_POSITIONHEADINGSPEED = 16UL,
      FI_EN_T_POSITIONWGS84 = 18UL,
      FI_EN_T_NAVLOCATIONBINCONTAINER = 21UL,
      FI_EN_T_STRINGPOSITION = 23UL,
      FI_EN_T_FLISTRING = 25UL,
      FI_EN_T_LISTOFPOSITIONS = 26UL
   };
   tenType enType;

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual tBool operator==(const fi_tcl_e8_LocationDescriptionDataType& rfoCmp) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   virtual tS32 s32GetTypeId() const { return typesfi_tclToken::EN_E8_LOCATIONDESCRIPTIONDATATYPE;}
   virtual tVoid vTakeVisitor(fi_tclVisitorBase& rfoVisitor);
};

class fi_tcl_SelectionCriterionDescription : public fi_tclVisitableTypeBase
{
public:
   fi_tcl_SelectionCriterionDescription():SelectionCriterion(),Description() {}
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   fi_tcl_SelectionCriterionDescription& operator=(const fi_tcl_SelectionCriterionDescription& coRef);
   fi_tcl_SelectionCriterionDescription(const fi_tcl_SelectionCriterionDescription& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
   fi_tcl_e16_SelectionCriterionType SelectionCriterion;
   fi_tclString Description;

   virtual tVoid vDestroy();
   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual tBool operator==(const fi_tcl_SelectionCriterionDescription& rfoCmp) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   virtual tS32 s32GetTypeId() const { return typesfi_tclToken::EN_SELECTIONCRITERIONDESCRIPTION;}
   virtual tVoid vTakeVisitor(fi_tclVisitorBase& rfoVisitor);
};

class fi_tcl_b8_CriteriaGetOptions : public fi_tclVisitableTypeBase
{
public:
   fi_tcl_b8_CriteriaGetOptions():u8Value(0) {}

   enum {
      FI_C_U8_BIT_NONSORTED = 0x1UL,
      FI_C_U8_BIT_INCLUDEEMPTY = 0x2UL,
      FI_C_U8_BIT_HIDEVIRTUALCATS = 0x4UL
   };
   tBool bNonSorted() const {return (u8Value & FI_C_U8_BIT_NONSORTED) != 0; }
   tVoid vSetNonSorted(tBool bSetBit) { u8Value = (bSetBit)?(u8Value | FI_C_U8_BIT_NONSORTED):(u8Value & ~FI_C_U8_BIT_NONSORTED); }
   tBool bIncludeEmpty() const {return (u8Value & FI_C_U8_BIT_INCLUDEEMPTY) != 0; }
   tVoid vSetIncludeEmpty(tBool bSetBit) { u8Value = (bSetBit)?(u8Value | FI_C_U8_BIT_INCLUDEEMPTY):(u8Value & ~FI_C_U8_BIT_INCLUDEEMPTY); }
   tBool bHideVirtualCats() const {return (u8Value & FI_C_U8_BIT_HIDEVIRTUALCATS) != 0; }
   tVoid vSetHideVirtualCats(tBool bSetBit) { u8Value = (bSetBit)?(u8Value | FI_C_U8_BIT_HIDEVIRTUALCATS):(u8Value & ~FI_C_U8_BIT_HIDEVIRTUALCATS); }
   struct rBitValues {
      unsigned int NonSorted:1;
      unsigned int IncludeEmpty:1;
      unsigned int HideVirtualCats:1;
      unsigned int dummy3:1;
      unsigned int dummy4:1;
      unsigned int dummy5:1;
      unsigned int dummy6:1;
      unsigned int dummy7:1;
   };
   union {
      tU8 u8Value;
      rBitValues bits;
   };

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual tBool operator==(const fi_tcl_b8_CriteriaGetOptions& rfoCmp) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   virtual tS32 s32GetTypeId() const { return typesfi_tclToken::EN_B8_CRITERIAGETOPTIONS;}
   virtual tVoid vTakeVisitor(fi_tclVisitorBase& rfoVisitor);
};

class fi_tcl_DAPISelectableCriterion : public fi_tclVisitableTypeBase
{
public:
   fi_tcl_DAPISelectableCriterion():SelectionCriterion(),DataType(),SortOption(),AttributesAvailable(0),Description(),Status(),NumOfPOI(0) {}
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   fi_tcl_DAPISelectableCriterion& operator=(const fi_tcl_DAPISelectableCriterion& coRef);
   fi_tcl_DAPISelectableCriterion(const fi_tcl_DAPISelectableCriterion& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
   fi_tcl_e16_SelectionCriterionType SelectionCriterion;
   fi_tcl_e8_LocationDescriptionDataType DataType;
   fi_tcl_b8_ListSortOptions SortOption;
   tBool AttributesAvailable;
   fi_tclString Description;
   fi_tcl_b8_CriterionStatus Status;
   tU16 NumOfPOI;

   virtual tVoid vDestroy();
   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual tBool operator==(const fi_tcl_DAPISelectableCriterion& rfoCmp) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   virtual tS32 s32GetTypeId() const { return typesfi_tclToken::EN_DAPISELECTABLECRITERION;}
   virtual tVoid vTakeVisitor(fi_tclVisitorBase& rfoVisitor);
};

class fi_tcl_e8_TransformMode : public fi_tclVisitableTypeBase
{
public:
   fi_tcl_e8_TransformMode():enType(FI_EN_RESOLVENAME) {}

   enum tenType {
      FI_EN_RESOLVENAME = 1UL,
      FI_EN_GETNAVINFO = 2UL,
      FI_EN_RESOLVENAMEANDGETNAVINFO = 3UL,
      FI_EN_TRANSFORMPATH = 4UL,
      FI_EN_MATCHASFARASPOSSIBLE = 5UL,
      FI_EN_GETEDITABLEADDRESSFORPOSITION = 6UL,
      FI_EN_GETADDRESSINFOFORPOSITION = 7UL,
      FI_EN_ASSIGNADDRESSPARTS = 8UL
   };
   tenType enType;

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual tBool operator==(const fi_tcl_e8_TransformMode& rfoCmp) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   virtual tS32 s32GetTypeId() const { return typesfi_tclToken::EN_E8_TRANSFORMMODE;}
   virtual tVoid vTakeVisitor(fi_tclVisitorBase& rfoVisitor);
};

class fi_tcl_b8_LocationDescriptorStatus : public fi_tclVisitableTypeBase
{
public:
   fi_tcl_b8_LocationDescriptorStatus():u8Value(0) {}

   enum {
      FI_C_U8_BIT_ISPREFIX = 0x1UL,
      FI_C_U8_BIT_ISINEXACT = 0x2UL
   };
   tBool bIsPrefix() const {return (u8Value & FI_C_U8_BIT_ISPREFIX) != 0; }
   tVoid vSetIsPrefix(tBool bSetBit) { u8Value = (bSetBit)?(u8Value | FI_C_U8_BIT_ISPREFIX):(u8Value & ~FI_C_U8_BIT_ISPREFIX); }
   tBool bIsInexact() const {return (u8Value & FI_C_U8_BIT_ISINEXACT) != 0; }
   tVoid vSetIsInexact(tBool bSetBit) { u8Value = (bSetBit)?(u8Value | FI_C_U8_BIT_ISINEXACT):(u8Value & ~FI_C_U8_BIT_ISINEXACT); }
   struct rBitValues {
      unsigned int IsPrefix:1;
      unsigned int IsInexact:1;
      unsigned int dummy2:1;
      unsigned int dummy3:1;
      unsigned int dummy4:1;
      unsigned int dummy5:1;
      unsigned int dummy6:1;
      unsigned int dummy7:1;
   };
   union {
      tU8 u8Value;
      rBitValues bits;
   };

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual tBool operator==(const fi_tcl_b8_LocationDescriptorStatus& rfoCmp) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   virtual tS32 s32GetTypeId() const { return typesfi_tclToken::EN_B8_LOCATIONDESCRIPTORSTATUS;}
   virtual tVoid vTakeVisitor(fi_tclVisitorBase& rfoVisitor);
};

class fi_tcl_LocationDescriptor : public fi_tclVisitableTypeBase
{
public:
   fi_tcl_LocationDescriptor():SelectionCriterion(),poDataData(0),Status() {}
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   fi_tcl_LocationDescriptor& operator=(const fi_tcl_LocationDescriptor& coRef);
   fi_tcl_LocationDescriptor(const fi_tcl_LocationDescriptor& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
   fi_tcl_e16_SelectionCriterionType SelectionCriterion;
   fi_tcl_e8_LocationDescriptionDataType DataType;
   fi_tclTypeBase* poDataData;
   fi_tcl_b8_LocationDescriptorStatus Status;
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   virtual ~fi_tcl_LocationDescriptor();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   virtual tVoid vDestroy();
   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual tBool operator==(const fi_tcl_LocationDescriptor& rfoCmp) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   virtual tS32 s32GetTypeId() const { return typesfi_tclToken::EN_LOCATIONDESCRIPTOR;}
   virtual tVoid vTakeVisitor(fi_tclVisitorBase& rfoVisitor);
};

class fi_tcl_SelectableCriterion : public fi_tclVisitableTypeBase
{
public:
   fi_tcl_SelectableCriterion():SelectionCriterion(),DataType(),SortOption(),AttributesAvailable(0),Status(),NumOfPOI(0) {}
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   fi_tcl_SelectableCriterion& operator=(const fi_tcl_SelectableCriterion& coRef);
   fi_tcl_SelectableCriterion(const fi_tcl_SelectableCriterion& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
   fi_tcl_e16_SelectionCriterionType SelectionCriterion;
   fi_tcl_e8_LocationDescriptionDataType DataType;
   fi_tcl_b8_ListSortOptions SortOption;
   tBool AttributesAvailable;
   fi_tcl_b8_CriterionStatus Status;
   tU16 NumOfPOI;

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual tBool operator==(const fi_tcl_SelectableCriterion& rfoCmp) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   virtual tS32 s32GetTypeId() const { return typesfi_tclToken::EN_SELECTABLECRITERION;}
   virtual tVoid vTakeVisitor(fi_tclVisitorBase& rfoVisitor);
};

class fi_tcl_LocationDescription : public fi_tclVisitableTypeBase
{
public:
   fi_tcl_LocationDescription() {}
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   fi_tcl_LocationDescription& operator=(const fi_tcl_LocationDescription& coRef);
   fi_tcl_LocationDescription(const fi_tcl_LocationDescription& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
   std::vector<fi_tcl_LocationDescriptor, std::allocator<fi_tcl_LocationDescriptor> > Descriptors;

   virtual tVoid vDestroy();
   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual tBool operator==(const fi_tcl_LocationDescription& rfoCmp) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   virtual tS32 s32GetTypeId() const { return typesfi_tclToken::EN_LOCATIONDESCRIPTION;}
   virtual tVoid vTakeVisitor(fi_tclVisitorBase& rfoVisitor);
};

class fi_tcl_StringPositionList : public fi_tclVisitableTypeBase
{
public:
   fi_tcl_StringPositionList() {}
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   fi_tcl_StringPositionList& operator=(const fi_tcl_StringPositionList& coRef);
   fi_tcl_StringPositionList(const fi_tcl_StringPositionList& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
   std::vector<fi_tcl_StringPositionElement, std::allocator<fi_tcl_StringPositionElement> > StringPositionList;

   virtual tVoid vDestroy();
   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual tBool operator==(const fi_tcl_StringPositionList& rfoCmp) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   virtual tS32 s32GetTypeId() const { return typesfi_tclToken::EN_STRINGPOSITIONLIST;}
   virtual tVoid vTakeVisitor(fi_tclVisitorBase& rfoVisitor);
};

class fi_tcl_StringIDList : public fi_tclVisitableTypeBase
{
public:
   fi_tcl_StringIDList() {}
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   fi_tcl_StringIDList& operator=(const fi_tcl_StringIDList& coRef);
   fi_tcl_StringIDList(const fi_tcl_StringIDList& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
   std::vector<fi_tcl_StringIDElement, std::allocator<fi_tcl_StringIDElement> > StringIDList;

   virtual tVoid vDestroy();
   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual tBool operator==(const fi_tcl_StringIDList& rfoCmp) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   virtual tS32 s32GetTypeId() const { return typesfi_tclToken::EN_STRINGIDLIST;}
   virtual tVoid vTakeVisitor(fi_tclVisitorBase& rfoVisitor);
};

class fi_tcl_FLIString : public fi_tclVisitableTypeBase
{
public:
   fi_tcl_FLIString():String() {}
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   fi_tcl_FLIString& operator=(const fi_tcl_FLIString& coRef);
   fi_tcl_FLIString(const fi_tcl_FLIString& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
   fi_tclString String;

   virtual tVoid vDestroy();
   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual tBool operator==(const fi_tcl_FLIString& rfoCmp) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   virtual tS32 s32GetTypeId() const { return typesfi_tclToken::EN_FLISTRING;}
   virtual tVoid vTakeVisitor(fi_tclVisitorBase& rfoVisitor);
};

class fi_tcl_b8_PositionStatus : public fi_tclVisitableTypeBase
{
public:
   fi_tcl_b8_PositionStatus():u8Value(0) {}

   enum {
      FI_C_U8_BIT_EXIT = 0x1UL
   };
   tBool bExit() const {return (u8Value & FI_C_U8_BIT_EXIT) != 0; }
   tVoid vSetExit(tBool bSetBit) { u8Value = (bSetBit)?(u8Value | FI_C_U8_BIT_EXIT):(u8Value & ~FI_C_U8_BIT_EXIT); }
   struct rBitValues {
      unsigned int Exit:1;
      unsigned int dummy1:1;
      unsigned int dummy2:1;
      unsigned int dummy3:1;
      unsigned int dummy4:1;
      unsigned int dummy5:1;
      unsigned int dummy6:1;
      unsigned int dummy7:1;
   };
   union {
      tU8 u8Value;
      rBitValues bits;
   };

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual tBool operator==(const fi_tcl_b8_PositionStatus& rfoCmp) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   virtual tS32 s32GetTypeId() const { return typesfi_tclToken::EN_B8_POSITIONSTATUS;}
   virtual tVoid vTakeVisitor(fi_tclVisitorBase& rfoVisitor);
};

class fi_tcl_ListOfPositions : public fi_tclVisitableTypeBase
{
public:
   fi_tcl_ListOfPositions():ID(0),CurrentPosition() {}
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   fi_tcl_ListOfPositions& operator=(const fi_tcl_ListOfPositions& coRef);
   fi_tcl_ListOfPositions(const fi_tcl_ListOfPositions& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
   std::vector<fi_tcl_PositionWGS84, std::allocator<fi_tcl_PositionWGS84> > Positions;
   std::vector<fi_tcl_b8_PositionStatus, std::allocator<fi_tcl_b8_PositionStatus> > PositionStati;
   tU32 ID;
   fi_tcl_PositionWGS84 CurrentPosition;

   virtual tVoid vDestroy();
   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual tBool operator==(const fi_tcl_ListOfPositions& rfoCmp) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   virtual tS32 s32GetTypeId() const { return typesfi_tclToken::EN_LISTOFPOSITIONS;}
   virtual tVoid vTakeVisitor(fi_tclVisitorBase& rfoVisitor);
};

class fi_tcl_e8_MapDataLevel : public fi_tclVisitableTypeBase
{
public:
   fi_tcl_e8_MapDataLevel():enType(FI_EN_DATA_LEVEL_1) {}

   enum tenType {
      FI_EN_DATA_LEVEL_1 = 1UL,
      FI_EN_DATA_LEVEL_2 = 2UL,
      FI_EN_DATA_LEVEL_3 = 3UL,
      FI_EN_DATA_LEVEL_4 = 4UL
   };
   tenType enType;

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual tBool operator==(const fi_tcl_e8_MapDataLevel& rfoCmp) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   virtual tS32 s32GetTypeId() const { return typesfi_tclToken::EN_E8_MAPDATALEVEL;}
   virtual tVoid vTakeVisitor(fi_tclVisitorBase& rfoVisitor);
};

class fi_tcl_MapCoordinates : public fi_tclVisitableTypeBase
{
public:
   fi_tcl_MapCoordinates() {}
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   fi_tcl_MapCoordinates& operator=(const fi_tcl_MapCoordinates& coRef);
   fi_tcl_MapCoordinates(const fi_tcl_MapCoordinates& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
   std::vector<fi_tcl_PositionWGS84, std::allocator<fi_tcl_PositionWGS84> > Coordinates;

   virtual tVoid vDestroy();
   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual tBool operator==(const fi_tcl_MapCoordinates& rfoCmp) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   virtual tS32 s32GetTypeId() const { return typesfi_tclToken::EN_MAPCOORDINATES;}
   virtual tVoid vTakeVisitor(fi_tclVisitorBase& rfoVisitor);
};

class fi_tcl_RelativeCoord_8Bit : public fi_tclVisitableTypeBase
{
public:
   fi_tcl_RelativeCoord_8Bit():s8_RelativeLongitude(0),s8_RelativeLatitude(0) {}
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   fi_tcl_RelativeCoord_8Bit& operator=(const fi_tcl_RelativeCoord_8Bit& coRef);
   fi_tcl_RelativeCoord_8Bit(const fi_tcl_RelativeCoord_8Bit& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
   tS8 s8_RelativeLongitude;
   tS8 s8_RelativeLatitude;

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual tBool operator==(const fi_tcl_RelativeCoord_8Bit& rfoCmp) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   virtual tS32 s32GetTypeId() const { return typesfi_tclToken::EN_RELATIVECOORD_8BIT;}
   virtual tVoid vTakeVisitor(fi_tclVisitorBase& rfoVisitor);
};

class fi_tcl_RelativeCoord_16Bit : public fi_tclVisitableTypeBase
{
public:
   fi_tcl_RelativeCoord_16Bit():s16_RelativeLongitude(0),s16_RelativeLatitude(0) {}
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   fi_tcl_RelativeCoord_16Bit& operator=(const fi_tcl_RelativeCoord_16Bit& coRef);
   fi_tcl_RelativeCoord_16Bit(const fi_tcl_RelativeCoord_16Bit& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
   tS16 s16_RelativeLongitude;
   tS16 s16_RelativeLatitude;

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual tBool operator==(const fi_tcl_RelativeCoord_16Bit& rfoCmp) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   virtual tS32 s32GetTypeId() const { return typesfi_tclToken::EN_RELATIVECOORD_16BIT;}
   virtual tVoid vTakeVisitor(fi_tclVisitorBase& rfoVisitor);
};

class fi_tcl_RelativeCoord_24Bit : public fi_tclVisitableTypeBase
{
public:
   fi_tcl_RelativeCoord_24Bit():s24_RelativeLongitude(0),s24_RelativeLatitude(0) {}
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   fi_tcl_RelativeCoord_24Bit& operator=(const fi_tcl_RelativeCoord_24Bit& coRef);
   fi_tcl_RelativeCoord_24Bit(const fi_tcl_RelativeCoord_24Bit& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
   tS24 s24_RelativeLongitude;
   tS24 s24_RelativeLatitude;

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual tBool operator==(const fi_tcl_RelativeCoord_24Bit& rfoCmp) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   virtual tS32 s32GetTypeId() const { return typesfi_tclToken::EN_RELATIVECOORD_24BIT;}
   virtual tVoid vTakeVisitor(fi_tclVisitorBase& rfoVisitor);
};

class fi_tcl_s16_Longitude : public fi_tclVisitableTypeBase
{
public:
   fi_tcl_s16_Longitude(tS16 _s16Value = 0):s16Value(_s16Value) {} 

   tS16 s16Value;

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual tBool operator==(const fi_tcl_s16_Longitude& rfoCmp) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   virtual tS32 s32GetTypeId() const { return typesfi_tclToken::EN_S16_LONGITUDE;}
   virtual tVoid vTakeVisitor(fi_tclVisitorBase& rfoVisitor);
};

class fi_tcl_s16_Latitude : public fi_tclVisitableTypeBase
{
public:
   fi_tcl_s16_Latitude(tS16 _s16Value = 0):s16Value(_s16Value) {} 

   tS16 s16Value;

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual tBool operator==(const fi_tcl_s16_Latitude& rfoCmp) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   virtual tS32 s32GetTypeId() const { return typesfi_tclToken::EN_S16_LATITUDE;}
   virtual tVoid vTakeVisitor(fi_tclVisitorBase& rfoVisitor);
};

class fi_tcl_s24_Longitude : public fi_tclVisitableTypeBase
{
public:
   fi_tcl_s24_Longitude(tS24 _s24Value = 0):s24Value(_s24Value) {} 

   tS24 s24Value;

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual tBool operator==(const fi_tcl_s24_Longitude& rfoCmp) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   virtual tS32 s32GetTypeId() const { return typesfi_tclToken::EN_S24_LONGITUDE;}
   virtual tVoid vTakeVisitor(fi_tclVisitorBase& rfoVisitor);
};

class fi_tcl_s24_Latitude : public fi_tclVisitableTypeBase
{
public:
   fi_tcl_s24_Latitude(tS24 _s24Value = 0):s24Value(_s24Value) {} 

   tS24 s24Value;

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual tBool operator==(const fi_tcl_s24_Latitude& rfoCmp) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   virtual tS32 s32GetTypeId() const { return typesfi_tclToken::EN_S24_LATITUDE;}
   virtual tVoid vTakeVisitor(fi_tclVisitorBase& rfoVisitor);
};

class fi_tcl_PositionWGS84_16Bit : public fi_tclVisitableTypeBase
{
public:
   fi_tcl_PositionWGS84_16Bit():Longitude(),Latitude() {}
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   fi_tcl_PositionWGS84_16Bit& operator=(const fi_tcl_PositionWGS84_16Bit& coRef);
   fi_tcl_PositionWGS84_16Bit(const fi_tcl_PositionWGS84_16Bit& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
   fi_tcl_s16_Longitude Longitude;
   fi_tcl_s16_Latitude Latitude;

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual tBool operator==(const fi_tcl_PositionWGS84_16Bit& rfoCmp) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   virtual tS32 s32GetTypeId() const { return typesfi_tclToken::EN_POSITIONWGS84_16BIT;}
   virtual tVoid vTakeVisitor(fi_tclVisitorBase& rfoVisitor);
};

class fi_tcl_PositionWGS84_24Bit : public fi_tclVisitableTypeBase
{
public:
   fi_tcl_PositionWGS84_24Bit():Longitude(),Latitude() {}
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   fi_tcl_PositionWGS84_24Bit& operator=(const fi_tcl_PositionWGS84_24Bit& coRef);
   fi_tcl_PositionWGS84_24Bit(const fi_tcl_PositionWGS84_24Bit& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
   fi_tcl_s24_Longitude Longitude;
   fi_tcl_s24_Latitude Latitude;

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual tBool operator==(const fi_tcl_PositionWGS84_24Bit& rfoCmp) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   virtual tS32 s32GetTypeId() const { return typesfi_tclToken::EN_POSITIONWGS84_24BIT;}
   virtual tVoid vTakeVisitor(fi_tclVisitorBase& rfoVisitor);
};

class fi_tcl_e8_CoordCode : public fi_tclVisitableTypeBase
{
public:
   fi_tcl_e8_CoordCode():enType(FI_EN_T_RESERVED) {}

   enum tenType {
      FI_EN_T_RESERVED = 0UL,
      FI_EN_T_POSITIONWGS84 = 1UL,
      FI_EN_T_POSITIONWGS84_24BIT = 2UL,
      FI_EN_T_POSITIONWGS84_16BIT = 3UL,
      FI_EN_T_RELATIVECOORD_24BIT = 130UL,
      FI_EN_T_RELATIVECOORD_16BIT = 131UL,
      FI_EN_T_RELATIVECOORD_8BIT = 132UL
   };
   tenType enType;

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual tBool operator==(const fi_tcl_e8_CoordCode& rfoCmp) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   virtual tS32 s32GetTypeId() const { return typesfi_tclToken::EN_E8_COORDCODE;}
   virtual tVoid vTakeVisitor(fi_tclVisitorBase& rfoVisitor);
};

class fi_tcl_CodedCoord : public fi_tclVisitableTypeBase
{
public:
   fi_tcl_CodedCoord():poCodedCoordinateData(0) {}
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   fi_tcl_CodedCoord& operator=(const fi_tcl_CodedCoord& coRef);
   fi_tcl_CodedCoord(const fi_tcl_CodedCoord& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
   fi_tcl_e8_CoordCode CodedCoordinateType;
   fi_tclTypeBase* poCodedCoordinateData;
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   virtual ~fi_tcl_CodedCoord();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   virtual tVoid vDestroy();
   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual tBool operator==(const fi_tcl_CodedCoord& rfoCmp) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   virtual tS32 s32GetTypeId() const { return typesfi_tclToken::EN_CODEDCOORD;}
   virtual tVoid vTakeVisitor(fi_tclVisitorBase& rfoVisitor);
};

class fi_tcl_CoordCodingScheme : public fi_tclVisitableTypeBase
{
public:
   fi_tcl_CoordCodingScheme():DataCoordCode(),BaseCoordinate() {}
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   fi_tcl_CoordCodingScheme& operator=(const fi_tcl_CoordCodingScheme& coRef);
   fi_tcl_CoordCodingScheme(const fi_tcl_CoordCodingScheme& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
   fi_tcl_e8_CoordCode DataCoordCode;
   fi_tcl_CodedCoord BaseCoordinate;

   virtual tVoid vDestroy();
   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual tBool operator==(const fi_tcl_CoordCodingScheme& rfoCmp) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   virtual tS32 s32GetTypeId() const { return typesfi_tclToken::EN_COORDCODINGSCHEME;}
   virtual tVoid vTakeVisitor(fi_tclVisitorBase& rfoVisitor);
};

class fi_tcl_b8_PresenceIndicator : public fi_tclVisitableTypeBase
{
public:
   fi_tcl_b8_PresenceIndicator():u8Value(0) {}

   enum {
      FI_C_U8_BIT_T_E16_ISOCOUNTRYCODE = 0x40UL,
      FI_C_U8_BIT_T_E8_MAPGEOMETRICTYPE = 0x20UL,
      FI_C_U8_BIT_T_MAPGEOGRAPHICTYPE = 0x10UL,
      FI_C_U8_BIT_T_MAPELEMENTDESCRIPTION = 0x8UL,
      FI_C_U8_BIT_T_S8_MAPDISPLAYPRIORITY = 0x4UL,
      FI_C_U8_BIT_T_S8_MAPDISPLAYZLEVEL = 0x2UL,
      FI_C_U8_BIT_T_MAPCOORDINATES = 0x1UL
   };
   tBool bT_e16_ISOCountryCode() const {return (u8Value & FI_C_U8_BIT_T_E16_ISOCOUNTRYCODE) != 0; }
   tVoid vSetT_e16_ISOCountryCode(tBool bSetBit) { u8Value = (bSetBit)?(u8Value | FI_C_U8_BIT_T_E16_ISOCOUNTRYCODE):(u8Value & ~FI_C_U8_BIT_T_E16_ISOCOUNTRYCODE); }
   tBool bT_e8_MapGeometricType() const {return (u8Value & FI_C_U8_BIT_T_E8_MAPGEOMETRICTYPE) != 0; }
   tVoid vSetT_e8_MapGeometricType(tBool bSetBit) { u8Value = (bSetBit)?(u8Value | FI_C_U8_BIT_T_E8_MAPGEOMETRICTYPE):(u8Value & ~FI_C_U8_BIT_T_E8_MAPGEOMETRICTYPE); }
   tBool bT_MapGeographicType() const {return (u8Value & FI_C_U8_BIT_T_MAPGEOGRAPHICTYPE) != 0; }
   tVoid vSetT_MapGeographicType(tBool bSetBit) { u8Value = (bSetBit)?(u8Value | FI_C_U8_BIT_T_MAPGEOGRAPHICTYPE):(u8Value & ~FI_C_U8_BIT_T_MAPGEOGRAPHICTYPE); }
   tBool bT_MapElementDescription() const {return (u8Value & FI_C_U8_BIT_T_MAPELEMENTDESCRIPTION) != 0; }
   tVoid vSetT_MapElementDescription(tBool bSetBit) { u8Value = (bSetBit)?(u8Value | FI_C_U8_BIT_T_MAPELEMENTDESCRIPTION):(u8Value & ~FI_C_U8_BIT_T_MAPELEMENTDESCRIPTION); }
   tBool bT_s8_MapDisplayPriority() const {return (u8Value & FI_C_U8_BIT_T_S8_MAPDISPLAYPRIORITY) != 0; }
   tVoid vSetT_s8_MapDisplayPriority(tBool bSetBit) { u8Value = (bSetBit)?(u8Value | FI_C_U8_BIT_T_S8_MAPDISPLAYPRIORITY):(u8Value & ~FI_C_U8_BIT_T_S8_MAPDISPLAYPRIORITY); }
   tBool bT_s8_MapDisplayZLevel() const {return (u8Value & FI_C_U8_BIT_T_S8_MAPDISPLAYZLEVEL) != 0; }
   tVoid vSetT_s8_MapDisplayZLevel(tBool bSetBit) { u8Value = (bSetBit)?(u8Value | FI_C_U8_BIT_T_S8_MAPDISPLAYZLEVEL):(u8Value & ~FI_C_U8_BIT_T_S8_MAPDISPLAYZLEVEL); }
   tBool bT_MapCoordinates() const {return (u8Value & FI_C_U8_BIT_T_MAPCOORDINATES) != 0; }
   tVoid vSetT_MapCoordinates(tBool bSetBit) { u8Value = (bSetBit)?(u8Value | FI_C_U8_BIT_T_MAPCOORDINATES):(u8Value & ~FI_C_U8_BIT_T_MAPCOORDINATES); }
   struct rBitValues {
      unsigned int T_MapCoordinates:1;
      unsigned int T_s8_MapDisplayZLevel:1;
      unsigned int T_s8_MapDisplayPriority:1;
      unsigned int T_MapElementDescription:1;
      unsigned int T_MapGeographicType:1;
      unsigned int T_e8_MapGeometricType:1;
      unsigned int T_e16_ISOCountryCode:1;
      unsigned int dummy7:1;
   };
   union {
      tU8 u8Value;
      rBitValues bits;
   };

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual tBool operator==(const fi_tcl_b8_PresenceIndicator& rfoCmp) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   virtual tS32 s32GetTypeId() const { return typesfi_tclToken::EN_B8_PRESENCEINDICATOR;}
   virtual tVoid vTakeVisitor(fi_tclVisitorBase& rfoVisitor);
};

class fi_tcl_s8_MapDisplayZLevel : public fi_tclVisitableTypeBase
{
public:
   fi_tcl_s8_MapDisplayZLevel(tS8 _s8Value = 0):s8Value(_s8Value) {} 

   tS8 s8Value;

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual tBool operator==(const fi_tcl_s8_MapDisplayZLevel& rfoCmp) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   virtual tS32 s32GetTypeId() const { return typesfi_tclToken::EN_S8_MAPDISPLAYZLEVEL;}
   virtual tVoid vTakeVisitor(fi_tclVisitorBase& rfoVisitor);
};

class fi_tcl_s8_MapDisplayPriority : public fi_tclVisitableTypeBase
{
public:
   fi_tcl_s8_MapDisplayPriority(tS8 _s8Value = 0):s8Value(_s8Value) {} 

   tS8 s8Value;

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual tBool operator==(const fi_tcl_s8_MapDisplayPriority& rfoCmp) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   virtual tS32 s32GetTypeId() const { return typesfi_tclToken::EN_S8_MAPDISPLAYPRIORITY;}
   virtual tVoid vTakeVisitor(fi_tclVisitorBase& rfoVisitor);
};

class fi_tcl_MapCodedElement : public fi_tclVisitableTypeBase
{
public:
   fi_tcl_MapCodedElement():poOption0(0),poOption1(0),poOption2(0),poOption3(0),poOption4(0),poOption5(0),poOption6(0) {}
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   fi_tcl_MapCodedElement& operator=(const fi_tcl_MapCodedElement& coRef);
   fi_tcl_MapCodedElement(const fi_tcl_MapCodedElement& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
   fi_tcl_b8_PresenceIndicator MapCodedElementMask;
   fi_tcl_e16_ISOCountryCode* poOption0;
   fi_tcl_e16_ISOCountryCode* poGet_e16_ISOCountryCode() { return poOption0;}
   fi_tcl_e8_MapGeometricType* poOption1;
   fi_tcl_e8_MapGeometricType* poGet_e8_MapGeometricType() { return poOption1;}
   fi_tcl_MapGeographicType* poOption2;
   fi_tcl_MapGeographicType* poGet_MapGeographicType() { return poOption2;}
   fi_tcl_MapElementDescription* poOption3;
   fi_tcl_MapElementDescription* poGet_MapElementDescription() { return poOption3;}
   fi_tcl_s8_MapDisplayPriority* poOption4;
   fi_tcl_s8_MapDisplayPriority* poGet_s8_MapDisplayPriority() { return poOption4;}
   fi_tcl_s8_MapDisplayZLevel* poOption5;
   fi_tcl_s8_MapDisplayZLevel* poGet_s8_MapDisplayZLevel() { return poOption5;}
   fi_tcl_MapCoordinates* poOption6;
   fi_tcl_MapCoordinates* poGet_MapCoordinates() { return poOption6;}
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   virtual ~fi_tcl_MapCodedElement();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   virtual tVoid vDestroy();
   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual tBool operator==(const fi_tcl_MapCodedElement& rfoCmp) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   virtual tS32 s32GetTypeId() const { return typesfi_tclToken::EN_MAPCODEDELEMENT;}
   virtual tVoid vTakeVisitor(fi_tclVisitorBase& rfoVisitor);
};

class fi_tcl_MapContainer : public fi_tclVisitableTypeBase
{
public:
   fi_tcl_MapContainer():FullCoverNorthWest(),FullCoverSouthEast(),DataLevel(),CoordCodingScheme() {}
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   fi_tcl_MapContainer& operator=(const fi_tcl_MapContainer& coRef);
   fi_tcl_MapContainer(const fi_tcl_MapContainer& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
   fi_tcl_PositionWGS84 FullCoverNorthWest;
   fi_tcl_PositionWGS84 FullCoverSouthEast;
   fi_tcl_e8_MapDataLevel DataLevel;
   fi_tcl_CoordCodingScheme CoordCodingScheme;
   std::vector<fi_tcl_MapCodedElement, std::allocator<fi_tcl_MapCodedElement> > MapCodedElements;

   virtual tVoid vDestroy();
   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual tBool operator==(const fi_tcl_MapContainer& rfoCmp) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   virtual tS32 s32GetTypeId() const { return typesfi_tclToken::EN_MAPCONTAINER;}
   virtual tVoid vTakeVisitor(fi_tclVisitorBase& rfoVisitor);
};

class fi_tcl_e8_MapElementDescrType : public fi_tclVisitableTypeBase
{
public:
   fi_tcl_e8_MapElementDescrType():enType(FI_EN_T_RESERVED) {}

   enum tenType {
      FI_EN_T_RESERVED = 0UL,
      FI_EN_TSTRING = 1UL,
      FI_EN_T_MAPGEOGRAPHICTYPE = 2UL,
      FI_EN_T_E8_ROADCLASSCODE = 3UL,
      FI_EN_T_B16_ROADATTRIBUTE = 4UL,
      FI_EN_T_ROADNUMBER = 5UL,
      FI_EN_T_E8_SURFACECOVERCODE = 6UL,
      FI_EN_T_E16_NAVIEVENTVALUE = 7UL,
      FI_EN_TMULTILANGUAGESTRING = 8UL
   };
   tenType enType;

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual tBool operator==(const fi_tcl_e8_MapElementDescrType& rfoCmp) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   virtual tS32 s32GetTypeId() const { return typesfi_tclToken::EN_E8_MAPELEMENTDESCRTYPE;}
   virtual tVoid vTakeVisitor(fi_tclVisitorBase& rfoVisitor);
};

class fi_tcl_MapElementDescriptor : public fi_tclVisitableTypeBase
{
public:
   fi_tcl_MapElementDescriptor():poMapElementDescrDataData(0) {}
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   fi_tcl_MapElementDescriptor& operator=(const fi_tcl_MapElementDescriptor& coRef);
   fi_tcl_MapElementDescriptor(const fi_tcl_MapElementDescriptor& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
   fi_tcl_e8_MapElementDescrType MapElementDescrDataType;
   fi_tclTypeBase* poMapElementDescrDataData;
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   virtual ~fi_tcl_MapElementDescriptor();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   virtual tVoid vDestroy();
   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual tBool operator==(const fi_tcl_MapElementDescriptor& rfoCmp) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   virtual tS32 s32GetTypeId() const { return typesfi_tclToken::EN_MAPELEMENTDESCRIPTOR;}
   virtual tVoid vTakeVisitor(fi_tclVisitorBase& rfoVisitor);
};

class fi_tcl_MapElementDescription : public fi_tclVisitableTypeBase
{
public:
   fi_tcl_MapElementDescription() {}
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   fi_tcl_MapElementDescription& operator=(const fi_tcl_MapElementDescription& coRef);
   fi_tcl_MapElementDescription(const fi_tcl_MapElementDescription& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
   std::vector<fi_tcl_MapElementDescriptor, std::allocator<fi_tcl_MapElementDescriptor> > Description;

   virtual tVoid vDestroy();
   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual tBool operator==(const fi_tcl_MapElementDescription& rfoCmp) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   virtual tS32 s32GetTypeId() const { return typesfi_tclToken::EN_MAPELEMENTDESCRIPTION;}
   virtual tVoid vTakeVisitor(fi_tclVisitorBase& rfoVisitor);
};

class fi_tcl_e8_MapGeometricType : public fi_tclVisitableTypeBase
{
public:
   fi_tcl_e8_MapGeometricType():enType(FI_EN_RESERVED) {}

   enum tenType {
      FI_EN_RESERVED = 0UL,
      FI_EN_POINT = 1UL,
      FI_EN_LINE = 2UL,
      FI_EN_AREA = 3UL,
      FI_EN_RESERVEDFORCOMPLEXAREA = 4UL,
      FI_EN_RESERVEDFORVOLUMEMAPELEMENTS = 5UL
   };
   tenType enType;

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual tBool operator==(const fi_tcl_e8_MapGeometricType& rfoCmp) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   virtual tS32 s32GetTypeId() const { return typesfi_tclToken::EN_E8_MAPGEOMETRICTYPE;}
   virtual tVoid vTakeVisitor(fi_tclVisitorBase& rfoVisitor);
};

class fi_tcl_MapGeographicType : public fi_tclVisitableTypeBase
{
public:
   fi_tcl_MapGeographicType():MapGeographicType() {}
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   fi_tcl_MapGeographicType& operator=(const fi_tcl_MapGeographicType& coRef);
   fi_tcl_MapGeographicType(const fi_tcl_MapGeographicType& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
   fi_tcl_e16_SelectionCriterionType MapGeographicType;

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual tBool operator==(const fi_tcl_MapGeographicType& rfoCmp) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   virtual tS32 s32GetTypeId() const { return typesfi_tclToken::EN_MAPGEOGRAPHICTYPE;}
   virtual tVoid vTakeVisitor(fi_tclVisitorBase& rfoVisitor);
};

class fi_tcl_e8_SurfaceCoverCode : public fi_tclVisitableTypeBase
{
public:
   fi_tcl_e8_SurfaceCoverCode():enType(FI_EN_RESERVED) {}

   enum tenType {
      FI_EN_RESERVED = 0UL,
      FI_EN_BUILDUPAREA = 1UL,
      FI_EN_INDUSTRIALAREA = 2UL,
      FI_EN_PARK = 3UL,
      FI_EN_FOREST = 4UL,
      FI_EN_DESERT = 5UL,
      FI_EN_ISLAND = 6UL,
      FI_EN_CHANNEL = 7UL,
      FI_EN_HARBOUR = 8UL,
      FI_EN_RIVER = 9UL,
      FI_EN_OPENWATER = 10UL,
      FI_EN_SWAMP = 11UL,
      FI_EN_HEATHER = 12UL,
      FI_EN_SAND = 13UL
   };
   tenType enType;

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual tBool operator==(const fi_tcl_e8_SurfaceCoverCode& rfoCmp) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   virtual tS32 s32GetTypeId() const { return typesfi_tclToken::EN_E8_SURFACECOVERCODE;}
   virtual tVoid vTakeVisitor(fi_tclVisitorBase& rfoVisitor);
};

class fi_tcl_MapRegion : public fi_tclVisitableTypeBase
{
public:
   fi_tcl_MapRegion():DataLevel(),ExtPosNorthWest(),ExtPosSouthEast(),Identifier(0) {}
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   fi_tcl_MapRegion& operator=(const fi_tcl_MapRegion& coRef);
   fi_tcl_MapRegion(const fi_tcl_MapRegion& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
   fi_tcl_e8_MapDataLevel DataLevel;
   fi_tcl_PositionWGS84 ExtPosNorthWest;
   fi_tcl_PositionWGS84 ExtPosSouthEast;
   tU32 Identifier;

   virtual tVoid vDestroy();
   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual tBool operator==(const fi_tcl_MapRegion& rfoCmp) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   virtual tS32 s32GetTypeId() const { return typesfi_tclToken::EN_MAPREGION;}
   virtual tVoid vTakeVisitor(fi_tclVisitorBase& rfoVisitor);
};

class fi_tcl_MapDirectory : public fi_tclVisitableTypeBase
{
public:
   fi_tcl_MapDirectory():ExtPosNorthWest(),ExtPosSouthEast() {}
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   fi_tcl_MapDirectory& operator=(const fi_tcl_MapDirectory& coRef);
   fi_tcl_MapDirectory(const fi_tcl_MapDirectory& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
   fi_tcl_PositionWGS84 ExtPosNorthWest;
   fi_tcl_PositionWGS84 ExtPosSouthEast;

   virtual tVoid vDestroy();
   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual tBool operator==(const fi_tcl_MapDirectory& rfoCmp) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   virtual tS32 s32GetTypeId() const { return typesfi_tclToken::EN_MAPDIRECTORY;}
   virtual tVoid vTakeVisitor(fi_tclVisitorBase& rfoVisitor);
};

class fi_tcl_u16_MapScale : public fi_tclVisitableTypeBase
{
public:
   fi_tcl_u16_MapScale(tU16 _u16Value = 0):u16Value(_u16Value) {} 

   tU16 u16Value;

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual tBool operator==(const fi_tcl_u16_MapScale& rfoCmp) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   virtual tS32 s32GetTypeId() const { return typesfi_tclToken::EN_U16_MAPSCALE;}
   virtual tVoid vTakeVisitor(fi_tclVisitorBase& rfoVisitor);
};

class fi_tcl_MapDataLevelDirectory : public fi_tclVisitableTypeBase
{
public:
   fi_tcl_MapDataLevelDirectory():DataLevel(),MinScale(),MaxScale() {}
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   fi_tcl_MapDataLevelDirectory& operator=(const fi_tcl_MapDataLevelDirectory& coRef);
   fi_tcl_MapDataLevelDirectory(const fi_tcl_MapDataLevelDirectory& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
   fi_tcl_e8_MapDataLevel DataLevel;
   fi_tcl_u16_MapScale MinScale;
   fi_tcl_u16_MapScale MaxScale;

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual tBool operator==(const fi_tcl_MapDataLevelDirectory& rfoCmp) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   virtual tS32 s32GetTypeId() const { return typesfi_tclToken::EN_MAPDATALEVELDIRECTORY;}
   virtual tVoid vTakeVisitor(fi_tclVisitorBase& rfoVisitor);
};

class fi_tcl_ScaleConfig : public fi_tclVisitableTypeBase
{
public:
   fi_tcl_ScaleConfig():ScaleBarSize(0),CacheRadius(0) {}
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   fi_tcl_ScaleConfig& operator=(const fi_tcl_ScaleConfig& coRef);
   fi_tcl_ScaleConfig(const fi_tcl_ScaleConfig& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
   tU16 ScaleBarSize;
   tU32 CacheRadius;

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual tBool operator==(const fi_tcl_ScaleConfig& rfoCmp) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   virtual tS32 s32GetTypeId() const { return typesfi_tclToken::EN_SCALECONFIG;}
   virtual tVoid vTakeVisitor(fi_tclVisitorBase& rfoVisitor);
};

class fi_tcl_s16_XPosScreen : public fi_tclVisitableTypeBase
{
public:
   fi_tcl_s16_XPosScreen(tS16 _s16Value = 0):s16Value(_s16Value) {} 

   tS16 s16Value;

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual tBool operator==(const fi_tcl_s16_XPosScreen& rfoCmp) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   virtual tS32 s32GetTypeId() const { return typesfi_tclToken::EN_S16_XPOSSCREEN;}
   virtual tVoid vTakeVisitor(fi_tclVisitorBase& rfoVisitor);
};

class fi_tcl_s16_YPosScreen : public fi_tclVisitableTypeBase
{
public:
   fi_tcl_s16_YPosScreen(tS16 _s16Value = 0):s16Value(_s16Value) {} 

   tS16 s16Value;

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual tBool operator==(const fi_tcl_s16_YPosScreen& rfoCmp) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   virtual tS32 s32GetTypeId() const { return typesfi_tclToken::EN_S16_YPOSSCREEN;}
   virtual tVoid vTakeVisitor(fi_tclVisitorBase& rfoVisitor);
};

class fi_tcl_u16_Direction : public fi_tclVisitableTypeBase
{
public:
   fi_tcl_u16_Direction(tU16 _u16Value = 0):u16Value(_u16Value) {} 

   tU16 u16Value;

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual tBool operator==(const fi_tcl_u16_Direction& rfoCmp) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   virtual tS32 s32GetTypeId() const { return typesfi_tclToken::EN_U16_DIRECTION;}
   virtual tVoid vTakeVisitor(fi_tclVisitorBase& rfoVisitor);
};

class fi_tcl_b16_HUCaps : public fi_tclVisitableTypeBase
{
public:
   fi_tcl_b16_HUCaps():u16Value(0) {}

   enum {
      FI_C_U16_BIT_DUMMY = 0x8000UL
   };
   tBool bDummy() const {return (u16Value & FI_C_U16_BIT_DUMMY) != 0; }
   tVoid vSetDummy(tBool bSetBit) { u16Value = (bSetBit)?(u16Value | FI_C_U16_BIT_DUMMY):(u16Value & ~FI_C_U16_BIT_DUMMY); }
   struct rBitValues {
      unsigned int dummy0:1;
      unsigned int dummy1:1;
      unsigned int dummy2:1;
      unsigned int dummy3:1;
      unsigned int dummy4:1;
      unsigned int dummy5:1;
      unsigned int dummy6:1;
      unsigned int dummy7:1;
      unsigned int dummy8:1;
      unsigned int dummy9:1;
      unsigned int dummy10:1;
      unsigned int dummy11:1;
      unsigned int dummy12:1;
      unsigned int dummy13:1;
      unsigned int dummy14:1;
      unsigned int Dummy:1;
   };
   union {
      tU16 u16Value;
      rBitValues bits;
   };

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual tBool operator==(const fi_tcl_b16_HUCaps& rfoCmp) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   virtual tS32 s32GetTypeId() const { return typesfi_tclToken::EN_B16_HUCAPS;}
   virtual tVoid vTakeVisitor(fi_tclVisitorBase& rfoVisitor);
};

class fi_tcl_b16_GlobalPreferences : public fi_tclVisitableTypeBase
{
public:
   fi_tcl_b16_GlobalPreferences():u16Value(0) {}

   enum {
      FI_C_U16_BIT_MP_LABEL_CITYCENTERPOINTS = 0x2UL,
      FI_C_U16_BIT_MP_LABEL_FWFACILITES = 0x4UL,
      FI_C_U16_BIT_MP_LABEL_POI = 0x8UL,
      FI_C_U16_BIT_MP_LABEL_REPAIR = 0x10UL,
      FI_C_U16_BIT_MP_LABEL_BORDER_NAME = 0x20UL,
      FI_C_U16_BIT_MP_LABEL_RIVER_NAME = 0x40UL,
      FI_C_U16_BIT_MP_LABEL_RAILWAY = 0x80UL,
      FI_C_U16_BIT_MP_LABEL_CHANNEL_NAME = 0x100UL,
      FI_C_U16_BIT_MP_LABEL_STREET_NAME = 0x200UL,
      FI_C_U16_BIT_MP_LABEL_AREA_NAME = 0x400UL,
      FI_C_U16_BIT_MP_LABEL_TMCINFO = 0x800UL,
      FI_C_U16_BIT_MP_LABEL_HOME_DESTINATIONS = 0x1000UL,
      FI_C_U16_BIT_MP_LABEL_LAST_DESTINATIONS = 0x2000UL,
      FI_C_U16_BIT_MP_LABEL_XMTRAFFICFLOW = 0x4000UL,
      FI_C_U16_BIT_MP_LABEL_SLIPROADCLOSING = 0x8000UL
   };
   tBool bMP_Label_CityCenterPoints() const {return (u16Value & FI_C_U16_BIT_MP_LABEL_CITYCENTERPOINTS) != 0; }
   tVoid vSetMP_Label_CityCenterPoints(tBool bSetBit) { u16Value = (bSetBit)?(u16Value | FI_C_U16_BIT_MP_LABEL_CITYCENTERPOINTS):(u16Value & ~FI_C_U16_BIT_MP_LABEL_CITYCENTERPOINTS); }
   tBool bMP_Label_FWFacilites() const {return (u16Value & FI_C_U16_BIT_MP_LABEL_FWFACILITES) != 0; }
   tVoid vSetMP_Label_FWFacilites(tBool bSetBit) { u16Value = (bSetBit)?(u16Value | FI_C_U16_BIT_MP_LABEL_FWFACILITES):(u16Value & ~FI_C_U16_BIT_MP_LABEL_FWFACILITES); }
   tBool bMP_Label_POI() const {return (u16Value & FI_C_U16_BIT_MP_LABEL_POI) != 0; }
   tVoid vSetMP_Label_POI(tBool bSetBit) { u16Value = (bSetBit)?(u16Value | FI_C_U16_BIT_MP_LABEL_POI):(u16Value & ~FI_C_U16_BIT_MP_LABEL_POI); }
   tBool bMP_Label_Repair() const {return (u16Value & FI_C_U16_BIT_MP_LABEL_REPAIR) != 0; }
   tVoid vSetMP_Label_Repair(tBool bSetBit) { u16Value = (bSetBit)?(u16Value | FI_C_U16_BIT_MP_LABEL_REPAIR):(u16Value & ~FI_C_U16_BIT_MP_LABEL_REPAIR); }
   tBool bMP_Label_Border_Name() const {return (u16Value & FI_C_U16_BIT_MP_LABEL_BORDER_NAME) != 0; }
   tVoid vSetMP_Label_Border_Name(tBool bSetBit) { u16Value = (bSetBit)?(u16Value | FI_C_U16_BIT_MP_LABEL_BORDER_NAME):(u16Value & ~FI_C_U16_BIT_MP_LABEL_BORDER_NAME); }
   tBool bMP_Label_River_Name() const {return (u16Value & FI_C_U16_BIT_MP_LABEL_RIVER_NAME) != 0; }
   tVoid vSetMP_Label_River_Name(tBool bSetBit) { u16Value = (bSetBit)?(u16Value | FI_C_U16_BIT_MP_LABEL_RIVER_NAME):(u16Value & ~FI_C_U16_BIT_MP_LABEL_RIVER_NAME); }
   tBool bMP_Label_Railway() const {return (u16Value & FI_C_U16_BIT_MP_LABEL_RAILWAY) != 0; }
   tVoid vSetMP_Label_Railway(tBool bSetBit) { u16Value = (bSetBit)?(u16Value | FI_C_U16_BIT_MP_LABEL_RAILWAY):(u16Value & ~FI_C_U16_BIT_MP_LABEL_RAILWAY); }
   tBool bMP_Label_Channel_Name() const {return (u16Value & FI_C_U16_BIT_MP_LABEL_CHANNEL_NAME) != 0; }
   tVoid vSetMP_Label_Channel_Name(tBool bSetBit) { u16Value = (bSetBit)?(u16Value | FI_C_U16_BIT_MP_LABEL_CHANNEL_NAME):(u16Value & ~FI_C_U16_BIT_MP_LABEL_CHANNEL_NAME); }
   tBool bMP_Label_Street_Name() const {return (u16Value & FI_C_U16_BIT_MP_LABEL_STREET_NAME) != 0; }
   tVoid vSetMP_Label_Street_Name(tBool bSetBit) { u16Value = (bSetBit)?(u16Value | FI_C_U16_BIT_MP_LABEL_STREET_NAME):(u16Value & ~FI_C_U16_BIT_MP_LABEL_STREET_NAME); }
   tBool bMP_Label_Area_Name() const {return (u16Value & FI_C_U16_BIT_MP_LABEL_AREA_NAME) != 0; }
   tVoid vSetMP_Label_Area_Name(tBool bSetBit) { u16Value = (bSetBit)?(u16Value | FI_C_U16_BIT_MP_LABEL_AREA_NAME):(u16Value & ~FI_C_U16_BIT_MP_LABEL_AREA_NAME); }
   tBool bMP_Label_TMCInfo() const {return (u16Value & FI_C_U16_BIT_MP_LABEL_TMCINFO) != 0; }
   tVoid vSetMP_Label_TMCInfo(tBool bSetBit) { u16Value = (bSetBit)?(u16Value | FI_C_U16_BIT_MP_LABEL_TMCINFO):(u16Value & ~FI_C_U16_BIT_MP_LABEL_TMCINFO); }
   tBool bMP_Label_Home_Destinations() const {return (u16Value & FI_C_U16_BIT_MP_LABEL_HOME_DESTINATIONS) != 0; }
   tVoid vSetMP_Label_Home_Destinations(tBool bSetBit) { u16Value = (bSetBit)?(u16Value | FI_C_U16_BIT_MP_LABEL_HOME_DESTINATIONS):(u16Value & ~FI_C_U16_BIT_MP_LABEL_HOME_DESTINATIONS); }
   tBool bMP_Label_Last_Destinations() const {return (u16Value & FI_C_U16_BIT_MP_LABEL_LAST_DESTINATIONS) != 0; }
   tVoid vSetMP_Label_Last_Destinations(tBool bSetBit) { u16Value = (bSetBit)?(u16Value | FI_C_U16_BIT_MP_LABEL_LAST_DESTINATIONS):(u16Value & ~FI_C_U16_BIT_MP_LABEL_LAST_DESTINATIONS); }
   tBool bMP_Label_XMTrafficFlow() const {return (u16Value & FI_C_U16_BIT_MP_LABEL_XMTRAFFICFLOW) != 0; }
   tVoid vSetMP_Label_XMTrafficFlow(tBool bSetBit) { u16Value = (bSetBit)?(u16Value | FI_C_U16_BIT_MP_LABEL_XMTRAFFICFLOW):(u16Value & ~FI_C_U16_BIT_MP_LABEL_XMTRAFFICFLOW); }
   tBool bMP_Label_SlipRoadClosing() const {return (u16Value & FI_C_U16_BIT_MP_LABEL_SLIPROADCLOSING) != 0; }
   tVoid vSetMP_Label_SlipRoadClosing(tBool bSetBit) { u16Value = (bSetBit)?(u16Value | FI_C_U16_BIT_MP_LABEL_SLIPROADCLOSING):(u16Value & ~FI_C_U16_BIT_MP_LABEL_SLIPROADCLOSING); }
   struct rBitValues {
      unsigned int dummy0:1;
      unsigned int MP_Label_CityCenterPoints:1;
      unsigned int MP_Label_FWFacilites:1;
      unsigned int MP_Label_POI:1;
      unsigned int MP_Label_Repair:1;
      unsigned int MP_Label_Border_Name:1;
      unsigned int MP_Label_River_Name:1;
      unsigned int MP_Label_Railway:1;
      unsigned int MP_Label_Channel_Name:1;
      unsigned int MP_Label_Street_Name:1;
      unsigned int MP_Label_Area_Name:1;
      unsigned int MP_Label_TMCInfo:1;
      unsigned int MP_Label_Home_Destinations:1;
      unsigned int MP_Label_Last_Destinations:1;
      unsigned int MP_Label_XMTrafficFlow:1;
      unsigned int MP_Label_SlipRoadClosing:1;
   };
   union {
      tU16 u16Value;
      rBitValues bits;
   };

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual tBool operator==(const fi_tcl_b16_GlobalPreferences& rfoCmp) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   virtual tS32 s32GetTypeId() const { return typesfi_tclToken::EN_B16_GLOBALPREFERENCES;}
   virtual tVoid vTakeVisitor(fi_tclVisitorBase& rfoVisitor);
};

class fi_tcl_b32_POI1 : public fi_tclVisitableTypeBase
{
public:
   fi_tcl_b32_POI1():u32Value(0) {}

   enum {
      FI_C_U32_BIT_MP_POI_AIRP = 0x1UL,
      FI_C_U32_BIT_MP_POI_BRDX = 0x2UL,
      FI_C_U32_BIT_MP_POI_EXIT = 0x4UL,
      FI_C_U32_BIT_MP_RESERVED = 0x8UL,
      FI_C_U32_BIT_MP_POI_FACL = 0x10UL,
      FI_C_U32_BIT_MP_POI_OFFI = 0x20UL,
      FI_C_U32_BIT_MP_POI_LSIG = 0x40UL,
      FI_C_U32_BIT_MP_POI_LLMK = 0x80UL,
      FI_C_U32_BIT_MP_POI_GLMK = 0x100UL,
      FI_C_U32_BIT_MP_POI_GSIG = 0x200UL,
      FI_C_U32_BIT_MP_POI_PARK = 0x400UL,
      FI_C_U32_BIT_MP_POI_RAIL = 0x800UL,
      FI_C_U32_BIT_MP_POI_HOTM = 0x1000UL,
      FI_C_U32_BIT_MP_POI_REST = 0x2000UL,
      FI_C_U32_BIT_MP_POI_FUEL = 0x4000UL,
      FI_C_U32_BIT_MP_POI_HOSP = 0x8000UL,
      FI_C_U32_BIT_MP_POI_ENTM = 0x10000UL,
      FI_C_U32_BIT_MP_POI_CRNT = 0x20000UL,
      FI_C_U32_BIT_MP_POI_SPOR = 0x40000UL,
      FI_C_U32_BIT_MP_POI_BUSI = 0x80000UL,
      FI_C_U32_BIT_MP_POI_POST = 0x100000UL,
      FI_C_U32_BIT_MP_POI_POLI = 0x200000UL,
      FI_C_U32_BIT_MP_POI_FTRM = 0x400000UL,
      FI_C_U32_BIT_MP_POI_SHOP = 0x800000UL,
      FI_C_U32_BIT_MP_POI_TOLL = 0x1000000UL,
      FI_C_U32_BIT_MP_POI_WORS = 0x2000000UL,
      FI_C_U32_BIT_MP_POI_FLSH = 0x4000000UL,
      FI_C_U32_BIT_MP_POI_BUS = 0x8000000UL,
      FI_C_U32_BIT_MP_POI_BANK = 0x10000000UL,
      FI_C_U32_BIT_MP_POI_CAMPING = 0x20000000UL,
      FI_C_U32_BIT_MP_POI_SPEC = 0x80000000UL
   };
   tBool bMP_POI_Airp() const {return (u32Value & FI_C_U32_BIT_MP_POI_AIRP) != 0; }
   tVoid vSetMP_POI_Airp(tBool bSetBit) { u32Value = (bSetBit)?(u32Value | FI_C_U32_BIT_MP_POI_AIRP):(u32Value & ~FI_C_U32_BIT_MP_POI_AIRP); }
   tBool bMP_POI_BrdX() const {return (u32Value & FI_C_U32_BIT_MP_POI_BRDX) != 0; }
   tVoid vSetMP_POI_BrdX(tBool bSetBit) { u32Value = (bSetBit)?(u32Value | FI_C_U32_BIT_MP_POI_BRDX):(u32Value & ~FI_C_U32_BIT_MP_POI_BRDX); }
   tBool bMP_POI_Exit() const {return (u32Value & FI_C_U32_BIT_MP_POI_EXIT) != 0; }
   tVoid vSetMP_POI_Exit(tBool bSetBit) { u32Value = (bSetBit)?(u32Value | FI_C_U32_BIT_MP_POI_EXIT):(u32Value & ~FI_C_U32_BIT_MP_POI_EXIT); }
   tBool bMP_reserved() const {return (u32Value & FI_C_U32_BIT_MP_RESERVED) != 0; }
   tVoid vSetMP_reserved(tBool bSetBit) { u32Value = (bSetBit)?(u32Value | FI_C_U32_BIT_MP_RESERVED):(u32Value & ~FI_C_U32_BIT_MP_RESERVED); }
   tBool bMP_POI_Facl() const {return (u32Value & FI_C_U32_BIT_MP_POI_FACL) != 0; }
   tVoid vSetMP_POI_Facl(tBool bSetBit) { u32Value = (bSetBit)?(u32Value | FI_C_U32_BIT_MP_POI_FACL):(u32Value & ~FI_C_U32_BIT_MP_POI_FACL); }
   tBool bMP_POI_Offi() const {return (u32Value & FI_C_U32_BIT_MP_POI_OFFI) != 0; }
   tVoid vSetMP_POI_Offi(tBool bSetBit) { u32Value = (bSetBit)?(u32Value | FI_C_U32_BIT_MP_POI_OFFI):(u32Value & ~FI_C_U32_BIT_MP_POI_OFFI); }
   tBool bMP_POI_Lsig() const {return (u32Value & FI_C_U32_BIT_MP_POI_LSIG) != 0; }
   tVoid vSetMP_POI_Lsig(tBool bSetBit) { u32Value = (bSetBit)?(u32Value | FI_C_U32_BIT_MP_POI_LSIG):(u32Value & ~FI_C_U32_BIT_MP_POI_LSIG); }
   tBool bMP_POI_Llmk() const {return (u32Value & FI_C_U32_BIT_MP_POI_LLMK) != 0; }
   tVoid vSetMP_POI_Llmk(tBool bSetBit) { u32Value = (bSetBit)?(u32Value | FI_C_U32_BIT_MP_POI_LLMK):(u32Value & ~FI_C_U32_BIT_MP_POI_LLMK); }
   tBool bMP_POI_Glmk() const {return (u32Value & FI_C_U32_BIT_MP_POI_GLMK) != 0; }
   tVoid vSetMP_POI_Glmk(tBool bSetBit) { u32Value = (bSetBit)?(u32Value | FI_C_U32_BIT_MP_POI_GLMK):(u32Value & ~FI_C_U32_BIT_MP_POI_GLMK); }
   tBool bMP_POI_Gsig() const {return (u32Value & FI_C_U32_BIT_MP_POI_GSIG) != 0; }
   tVoid vSetMP_POI_Gsig(tBool bSetBit) { u32Value = (bSetBit)?(u32Value | FI_C_U32_BIT_MP_POI_GSIG):(u32Value & ~FI_C_U32_BIT_MP_POI_GSIG); }
   tBool bMP_POI_Park() const {return (u32Value & FI_C_U32_BIT_MP_POI_PARK) != 0; }
   tVoid vSetMP_POI_Park(tBool bSetBit) { u32Value = (bSetBit)?(u32Value | FI_C_U32_BIT_MP_POI_PARK):(u32Value & ~FI_C_U32_BIT_MP_POI_PARK); }
   tBool bMP_POI_Rail() const {return (u32Value & FI_C_U32_BIT_MP_POI_RAIL) != 0; }
   tVoid vSetMP_POI_Rail(tBool bSetBit) { u32Value = (bSetBit)?(u32Value | FI_C_U32_BIT_MP_POI_RAIL):(u32Value & ~FI_C_U32_BIT_MP_POI_RAIL); }
   tBool bMP_POI_HotM() const {return (u32Value & FI_C_U32_BIT_MP_POI_HOTM) != 0; }
   tVoid vSetMP_POI_HotM(tBool bSetBit) { u32Value = (bSetBit)?(u32Value | FI_C_U32_BIT_MP_POI_HOTM):(u32Value & ~FI_C_U32_BIT_MP_POI_HOTM); }
   tBool bMP_POI_Rest() const {return (u32Value & FI_C_U32_BIT_MP_POI_REST) != 0; }
   tVoid vSetMP_POI_Rest(tBool bSetBit) { u32Value = (bSetBit)?(u32Value | FI_C_U32_BIT_MP_POI_REST):(u32Value & ~FI_C_U32_BIT_MP_POI_REST); }
   tBool bMP_POI_Fuel() const {return (u32Value & FI_C_U32_BIT_MP_POI_FUEL) != 0; }
   tVoid vSetMP_POI_Fuel(tBool bSetBit) { u32Value = (bSetBit)?(u32Value | FI_C_U32_BIT_MP_POI_FUEL):(u32Value & ~FI_C_U32_BIT_MP_POI_FUEL); }
   tBool bMP_POI_Hosp() const {return (u32Value & FI_C_U32_BIT_MP_POI_HOSP) != 0; }
   tVoid vSetMP_POI_Hosp(tBool bSetBit) { u32Value = (bSetBit)?(u32Value | FI_C_U32_BIT_MP_POI_HOSP):(u32Value & ~FI_C_U32_BIT_MP_POI_HOSP); }
   tBool bMP_POI_Entm() const {return (u32Value & FI_C_U32_BIT_MP_POI_ENTM) != 0; }
   tVoid vSetMP_POI_Entm(tBool bSetBit) { u32Value = (bSetBit)?(u32Value | FI_C_U32_BIT_MP_POI_ENTM):(u32Value & ~FI_C_U32_BIT_MP_POI_ENTM); }
   tBool bMP_POI_Crnt() const {return (u32Value & FI_C_U32_BIT_MP_POI_CRNT) != 0; }
   tVoid vSetMP_POI_Crnt(tBool bSetBit) { u32Value = (bSetBit)?(u32Value | FI_C_U32_BIT_MP_POI_CRNT):(u32Value & ~FI_C_U32_BIT_MP_POI_CRNT); }
   tBool bMP_POI_Spor() const {return (u32Value & FI_C_U32_BIT_MP_POI_SPOR) != 0; }
   tVoid vSetMP_POI_Spor(tBool bSetBit) { u32Value = (bSetBit)?(u32Value | FI_C_U32_BIT_MP_POI_SPOR):(u32Value & ~FI_C_U32_BIT_MP_POI_SPOR); }
   tBool bMP_POI_Busi() const {return (u32Value & FI_C_U32_BIT_MP_POI_BUSI) != 0; }
   tVoid vSetMP_POI_Busi(tBool bSetBit) { u32Value = (bSetBit)?(u32Value | FI_C_U32_BIT_MP_POI_BUSI):(u32Value & ~FI_C_U32_BIT_MP_POI_BUSI); }
   tBool bMP_POI_Post() const {return (u32Value & FI_C_U32_BIT_MP_POI_POST) != 0; }
   tVoid vSetMP_POI_Post(tBool bSetBit) { u32Value = (bSetBit)?(u32Value | FI_C_U32_BIT_MP_POI_POST):(u32Value & ~FI_C_U32_BIT_MP_POI_POST); }
   tBool bMP_POI_Poli() const {return (u32Value & FI_C_U32_BIT_MP_POI_POLI) != 0; }
   tVoid vSetMP_POI_Poli(tBool bSetBit) { u32Value = (bSetBit)?(u32Value | FI_C_U32_BIT_MP_POI_POLI):(u32Value & ~FI_C_U32_BIT_MP_POI_POLI); }
   tBool bMP_POI_Ftrm() const {return (u32Value & FI_C_U32_BIT_MP_POI_FTRM) != 0; }
   tVoid vSetMP_POI_Ftrm(tBool bSetBit) { u32Value = (bSetBit)?(u32Value | FI_C_U32_BIT_MP_POI_FTRM):(u32Value & ~FI_C_U32_BIT_MP_POI_FTRM); }
   tBool bMP_POI_Shop() const {return (u32Value & FI_C_U32_BIT_MP_POI_SHOP) != 0; }
   tVoid vSetMP_POI_Shop(tBool bSetBit) { u32Value = (bSetBit)?(u32Value | FI_C_U32_BIT_MP_POI_SHOP):(u32Value & ~FI_C_U32_BIT_MP_POI_SHOP); }
   tBool bMP_POI_Toll() const {return (u32Value & FI_C_U32_BIT_MP_POI_TOLL) != 0; }
   tVoid vSetMP_POI_Toll(tBool bSetBit) { u32Value = (bSetBit)?(u32Value | FI_C_U32_BIT_MP_POI_TOLL):(u32Value & ~FI_C_U32_BIT_MP_POI_TOLL); }
   tBool bMP_POI_Wors() const {return (u32Value & FI_C_U32_BIT_MP_POI_WORS) != 0; }
   tVoid vSetMP_POI_Wors(tBool bSetBit) { u32Value = (bSetBit)?(u32Value | FI_C_U32_BIT_MP_POI_WORS):(u32Value & ~FI_C_U32_BIT_MP_POI_WORS); }
   tBool bMP_POI_Flsh() const {return (u32Value & FI_C_U32_BIT_MP_POI_FLSH) != 0; }
   tVoid vSetMP_POI_Flsh(tBool bSetBit) { u32Value = (bSetBit)?(u32Value | FI_C_U32_BIT_MP_POI_FLSH):(u32Value & ~FI_C_U32_BIT_MP_POI_FLSH); }
   tBool bMP_POI_Bus() const {return (u32Value & FI_C_U32_BIT_MP_POI_BUS) != 0; }
   tVoid vSetMP_POI_Bus(tBool bSetBit) { u32Value = (bSetBit)?(u32Value | FI_C_U32_BIT_MP_POI_BUS):(u32Value & ~FI_C_U32_BIT_MP_POI_BUS); }
   tBool bMP_POI_Bank() const {return (u32Value & FI_C_U32_BIT_MP_POI_BANK) != 0; }
   tVoid vSetMP_POI_Bank(tBool bSetBit) { u32Value = (bSetBit)?(u32Value | FI_C_U32_BIT_MP_POI_BANK):(u32Value & ~FI_C_U32_BIT_MP_POI_BANK); }
   tBool bMP_POI_Camping() const {return (u32Value & FI_C_U32_BIT_MP_POI_CAMPING) != 0; }
   tVoid vSetMP_POI_Camping(tBool bSetBit) { u32Value = (bSetBit)?(u32Value | FI_C_U32_BIT_MP_POI_CAMPING):(u32Value & ~FI_C_U32_BIT_MP_POI_CAMPING); }
   tBool bMP_POI_Spec() const {return (u32Value & FI_C_U32_BIT_MP_POI_SPEC) != 0; }
   tVoid vSetMP_POI_Spec(tBool bSetBit) { u32Value = (bSetBit)?(u32Value | FI_C_U32_BIT_MP_POI_SPEC):(u32Value & ~FI_C_U32_BIT_MP_POI_SPEC); }
   struct rBitValues {
      unsigned int MP_POI_Airp:1;
      unsigned int MP_POI_BrdX:1;
      unsigned int MP_POI_Exit:1;
      unsigned int MP_reserved:1;
      unsigned int MP_POI_Facl:1;
      unsigned int MP_POI_Offi:1;
      unsigned int MP_POI_Lsig:1;
      unsigned int MP_POI_Llmk:1;
      unsigned int MP_POI_Glmk:1;
      unsigned int MP_POI_Gsig:1;
      unsigned int MP_POI_Park:1;
      unsigned int MP_POI_Rail:1;
      unsigned int MP_POI_HotM:1;
      unsigned int MP_POI_Rest:1;
      unsigned int MP_POI_Fuel:1;
      unsigned int MP_POI_Hosp:1;
      unsigned int MP_POI_Entm:1;
      unsigned int MP_POI_Crnt:1;
      unsigned int MP_POI_Spor:1;
      unsigned int MP_POI_Busi:1;
      unsigned int MP_POI_Post:1;
      unsigned int MP_POI_Poli:1;
      unsigned int MP_POI_Ftrm:1;
      unsigned int MP_POI_Shop:1;
      unsigned int MP_POI_Toll:1;
      unsigned int MP_POI_Wors:1;
      unsigned int MP_POI_Flsh:1;
      unsigned int MP_POI_Bus:1;
      unsigned int MP_POI_Bank:1;
      unsigned int MP_POI_Camping:1;
      unsigned int dummy30:1;
      unsigned int MP_POI_Spec:1;
   };
   union {
      tU32 u32Value;
      rBitValues bits;
   };

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual tBool operator==(const fi_tcl_b32_POI1& rfoCmp) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   virtual tS32 s32GetTypeId() const { return typesfi_tclToken::EN_B32_POI1;}
   virtual tVoid vTakeVisitor(fi_tclVisitorBase& rfoVisitor);
};

class fi_tcl_b32_POI2 : public fi_tclVisitableTypeBase
{
public:
   fi_tcl_b32_POI2():u32Value(0) {}

   enum {
      FI_C_U32_BIT_MP_REP_BENTLEY = 0x1UL,
      FI_C_U32_BIT_MP_REP_BUICK = 0x2UL,
      FI_C_U32_BIT_MP_REP_CADILLAC = 0x4UL,
      FI_C_U32_BIT_MP_REP_CHEVROLET = 0x8UL,
      FI_C_U32_BIT_MP_REP_DAEWOO = 0x10UL,
      FI_C_U32_BIT_MP_REP_DAIHATSU = 0x20UL,
      FI_C_U32_BIT_MP_REP_DODGE = 0x40UL,
      FI_C_U32_BIT_MP_REP_GMC = 0x80UL,
      FI_C_U32_BIT_MP_REP_GMH = 0x100UL,
      FI_C_U32_BIT_MP_REP_HYUNDAI = 0x200UL,
      FI_C_U32_BIT_MP_REP_ISUZU = 0x400UL,
      FI_C_U32_BIT_MP_REP_JAGUAR = 0x800UL,
      FI_C_U32_BIT_MP_REP_JEEP = 0x1000UL,
      FI_C_U32_BIT_MP_REP_KIA = 0x2000UL,
      FI_C_U32_BIT_MP_REP_LADA = 0x4000UL,
      FI_C_U32_BIT_MP_REP_LEXUS = 0x8000UL,
      FI_C_U32_BIT_MP_REP_LINCOLN = 0x10000UL,
      FI_C_U32_BIT_MP_REP_MG = 0x20000UL,
      FI_C_U32_BIT_MP_REP_MINI = 0x40000UL,
      FI_C_U32_BIT_MP_REP_OLDSMOBILE = 0x80000UL,
      FI_C_U32_BIT_MP_REP_PONTIAC = 0x100000UL,
      FI_C_U32_BIT_MP_REP_ROLLSROYCE = 0x200000UL,
      FI_C_U32_BIT_MP_REP_SATURN = 0x400000UL,
      FI_C_U32_BIT_MP_REP_SUBARU = 0x800000UL,
      FI_C_U32_BIT_MP_REP_SUZUKI = 0x1000000UL,
      FI_C_U32_BIT_MP_REP_GM = 0x2000000UL,
      FI_C_U32_BIT_MP_REP_SGM = 0x4000000UL
   };
   tBool bMP_REP_Bentley() const {return (u32Value & FI_C_U32_BIT_MP_REP_BENTLEY) != 0; }
   tVoid vSetMP_REP_Bentley(tBool bSetBit) { u32Value = (bSetBit)?(u32Value | FI_C_U32_BIT_MP_REP_BENTLEY):(u32Value & ~FI_C_U32_BIT_MP_REP_BENTLEY); }
   tBool bMP_REP_Buick() const {return (u32Value & FI_C_U32_BIT_MP_REP_BUICK) != 0; }
   tVoid vSetMP_REP_Buick(tBool bSetBit) { u32Value = (bSetBit)?(u32Value | FI_C_U32_BIT_MP_REP_BUICK):(u32Value & ~FI_C_U32_BIT_MP_REP_BUICK); }
   tBool bMP_REP_Cadillac() const {return (u32Value & FI_C_U32_BIT_MP_REP_CADILLAC) != 0; }
   tVoid vSetMP_REP_Cadillac(tBool bSetBit) { u32Value = (bSetBit)?(u32Value | FI_C_U32_BIT_MP_REP_CADILLAC):(u32Value & ~FI_C_U32_BIT_MP_REP_CADILLAC); }
   tBool bMP_REP_Chevrolet() const {return (u32Value & FI_C_U32_BIT_MP_REP_CHEVROLET) != 0; }
   tVoid vSetMP_REP_Chevrolet(tBool bSetBit) { u32Value = (bSetBit)?(u32Value | FI_C_U32_BIT_MP_REP_CHEVROLET):(u32Value & ~FI_C_U32_BIT_MP_REP_CHEVROLET); }
   tBool bMP_REP_Daewoo() const {return (u32Value & FI_C_U32_BIT_MP_REP_DAEWOO) != 0; }
   tVoid vSetMP_REP_Daewoo(tBool bSetBit) { u32Value = (bSetBit)?(u32Value | FI_C_U32_BIT_MP_REP_DAEWOO):(u32Value & ~FI_C_U32_BIT_MP_REP_DAEWOO); }
   tBool bMP_REP_Daihatsu() const {return (u32Value & FI_C_U32_BIT_MP_REP_DAIHATSU) != 0; }
   tVoid vSetMP_REP_Daihatsu(tBool bSetBit) { u32Value = (bSetBit)?(u32Value | FI_C_U32_BIT_MP_REP_DAIHATSU):(u32Value & ~FI_C_U32_BIT_MP_REP_DAIHATSU); }
   tBool bMP_REP_Dodge() const {return (u32Value & FI_C_U32_BIT_MP_REP_DODGE) != 0; }
   tVoid vSetMP_REP_Dodge(tBool bSetBit) { u32Value = (bSetBit)?(u32Value | FI_C_U32_BIT_MP_REP_DODGE):(u32Value & ~FI_C_U32_BIT_MP_REP_DODGE); }
   tBool bMP_REP_Gmc() const {return (u32Value & FI_C_U32_BIT_MP_REP_GMC) != 0; }
   tVoid vSetMP_REP_Gmc(tBool bSetBit) { u32Value = (bSetBit)?(u32Value | FI_C_U32_BIT_MP_REP_GMC):(u32Value & ~FI_C_U32_BIT_MP_REP_GMC); }
   tBool bMP_REP_Gmh() const {return (u32Value & FI_C_U32_BIT_MP_REP_GMH) != 0; }
   tVoid vSetMP_REP_Gmh(tBool bSetBit) { u32Value = (bSetBit)?(u32Value | FI_C_U32_BIT_MP_REP_GMH):(u32Value & ~FI_C_U32_BIT_MP_REP_GMH); }
   tBool bMP_REP_Hyundai() const {return (u32Value & FI_C_U32_BIT_MP_REP_HYUNDAI) != 0; }
   tVoid vSetMP_REP_Hyundai(tBool bSetBit) { u32Value = (bSetBit)?(u32Value | FI_C_U32_BIT_MP_REP_HYUNDAI):(u32Value & ~FI_C_U32_BIT_MP_REP_HYUNDAI); }
   tBool bMP_REP_Isuzu() const {return (u32Value & FI_C_U32_BIT_MP_REP_ISUZU) != 0; }
   tVoid vSetMP_REP_Isuzu(tBool bSetBit) { u32Value = (bSetBit)?(u32Value | FI_C_U32_BIT_MP_REP_ISUZU):(u32Value & ~FI_C_U32_BIT_MP_REP_ISUZU); }
   tBool bMP_REP_Jaguar() const {return (u32Value & FI_C_U32_BIT_MP_REP_JAGUAR) != 0; }
   tVoid vSetMP_REP_Jaguar(tBool bSetBit) { u32Value = (bSetBit)?(u32Value | FI_C_U32_BIT_MP_REP_JAGUAR):(u32Value & ~FI_C_U32_BIT_MP_REP_JAGUAR); }
   tBool bMP_REP_Jeep() const {return (u32Value & FI_C_U32_BIT_MP_REP_JEEP) != 0; }
   tVoid vSetMP_REP_Jeep(tBool bSetBit) { u32Value = (bSetBit)?(u32Value | FI_C_U32_BIT_MP_REP_JEEP):(u32Value & ~FI_C_U32_BIT_MP_REP_JEEP); }
   tBool bMP_REP_Kia() const {return (u32Value & FI_C_U32_BIT_MP_REP_KIA) != 0; }
   tVoid vSetMP_REP_Kia(tBool bSetBit) { u32Value = (bSetBit)?(u32Value | FI_C_U32_BIT_MP_REP_KIA):(u32Value & ~FI_C_U32_BIT_MP_REP_KIA); }
   tBool bMP_REP_Lada() const {return (u32Value & FI_C_U32_BIT_MP_REP_LADA) != 0; }
   tVoid vSetMP_REP_Lada(tBool bSetBit) { u32Value = (bSetBit)?(u32Value | FI_C_U32_BIT_MP_REP_LADA):(u32Value & ~FI_C_U32_BIT_MP_REP_LADA); }
   tBool bMP_REP_Lexus() const {return (u32Value & FI_C_U32_BIT_MP_REP_LEXUS) != 0; }
   tVoid vSetMP_REP_Lexus(tBool bSetBit) { u32Value = (bSetBit)?(u32Value | FI_C_U32_BIT_MP_REP_LEXUS):(u32Value & ~FI_C_U32_BIT_MP_REP_LEXUS); }
   tBool bMP_REP_Lincoln() const {return (u32Value & FI_C_U32_BIT_MP_REP_LINCOLN) != 0; }
   tVoid vSetMP_REP_Lincoln(tBool bSetBit) { u32Value = (bSetBit)?(u32Value | FI_C_U32_BIT_MP_REP_LINCOLN):(u32Value & ~FI_C_U32_BIT_MP_REP_LINCOLN); }
   tBool bMP_REP_Mg() const {return (u32Value & FI_C_U32_BIT_MP_REP_MG) != 0; }
   tVoid vSetMP_REP_Mg(tBool bSetBit) { u32Value = (bSetBit)?(u32Value | FI_C_U32_BIT_MP_REP_MG):(u32Value & ~FI_C_U32_BIT_MP_REP_MG); }
   tBool bMP_REP_Mini() const {return (u32Value & FI_C_U32_BIT_MP_REP_MINI) != 0; }
   tVoid vSetMP_REP_Mini(tBool bSetBit) { u32Value = (bSetBit)?(u32Value | FI_C_U32_BIT_MP_REP_MINI):(u32Value & ~FI_C_U32_BIT_MP_REP_MINI); }
   tBool bMP_REP_OldsMobile() const {return (u32Value & FI_C_U32_BIT_MP_REP_OLDSMOBILE) != 0; }
   tVoid vSetMP_REP_OldsMobile(tBool bSetBit) { u32Value = (bSetBit)?(u32Value | FI_C_U32_BIT_MP_REP_OLDSMOBILE):(u32Value & ~FI_C_U32_BIT_MP_REP_OLDSMOBILE); }
   tBool bMP_REP_Pontiac() const {return (u32Value & FI_C_U32_BIT_MP_REP_PONTIAC) != 0; }
   tVoid vSetMP_REP_Pontiac(tBool bSetBit) { u32Value = (bSetBit)?(u32Value | FI_C_U32_BIT_MP_REP_PONTIAC):(u32Value & ~FI_C_U32_BIT_MP_REP_PONTIAC); }
   tBool bMP_REP_RollsRoyce() const {return (u32Value & FI_C_U32_BIT_MP_REP_ROLLSROYCE) != 0; }
   tVoid vSetMP_REP_RollsRoyce(tBool bSetBit) { u32Value = (bSetBit)?(u32Value | FI_C_U32_BIT_MP_REP_ROLLSROYCE):(u32Value & ~FI_C_U32_BIT_MP_REP_ROLLSROYCE); }
   tBool bMP_REP_Saturn() const {return (u32Value & FI_C_U32_BIT_MP_REP_SATURN) != 0; }
   tVoid vSetMP_REP_Saturn(tBool bSetBit) { u32Value = (bSetBit)?(u32Value | FI_C_U32_BIT_MP_REP_SATURN):(u32Value & ~FI_C_U32_BIT_MP_REP_SATURN); }
   tBool bMP_REP_Subaru() const {return (u32Value & FI_C_U32_BIT_MP_REP_SUBARU) != 0; }
   tVoid vSetMP_REP_Subaru(tBool bSetBit) { u32Value = (bSetBit)?(u32Value | FI_C_U32_BIT_MP_REP_SUBARU):(u32Value & ~FI_C_U32_BIT_MP_REP_SUBARU); }
   tBool bMP_REP_Suzuki() const {return (u32Value & FI_C_U32_BIT_MP_REP_SUZUKI) != 0; }
   tVoid vSetMP_REP_Suzuki(tBool bSetBit) { u32Value = (bSetBit)?(u32Value | FI_C_U32_BIT_MP_REP_SUZUKI):(u32Value & ~FI_C_U32_BIT_MP_REP_SUZUKI); }
   tBool bMP_REP_GM() const {return (u32Value & FI_C_U32_BIT_MP_REP_GM) != 0; }
   tVoid vSetMP_REP_GM(tBool bSetBit) { u32Value = (bSetBit)?(u32Value | FI_C_U32_BIT_MP_REP_GM):(u32Value & ~FI_C_U32_BIT_MP_REP_GM); }
   tBool bMP_REP_SGM() const {return (u32Value & FI_C_U32_BIT_MP_REP_SGM) != 0; }
   tVoid vSetMP_REP_SGM(tBool bSetBit) { u32Value = (bSetBit)?(u32Value | FI_C_U32_BIT_MP_REP_SGM):(u32Value & ~FI_C_U32_BIT_MP_REP_SGM); }
   struct rBitValues {
      unsigned int MP_REP_Bentley:1;
      unsigned int MP_REP_Buick:1;
      unsigned int MP_REP_Cadillac:1;
      unsigned int MP_REP_Chevrolet:1;
      unsigned int MP_REP_Daewoo:1;
      unsigned int MP_REP_Daihatsu:1;
      unsigned int MP_REP_Dodge:1;
      unsigned int MP_REP_Gmc:1;
      unsigned int MP_REP_Gmh:1;
      unsigned int MP_REP_Hyundai:1;
      unsigned int MP_REP_Isuzu:1;
      unsigned int MP_REP_Jaguar:1;
      unsigned int MP_REP_Jeep:1;
      unsigned int MP_REP_Kia:1;
      unsigned int MP_REP_Lada:1;
      unsigned int MP_REP_Lexus:1;
      unsigned int MP_REP_Lincoln:1;
      unsigned int MP_REP_Mg:1;
      unsigned int MP_REP_Mini:1;
      unsigned int MP_REP_OldsMobile:1;
      unsigned int MP_REP_Pontiac:1;
      unsigned int MP_REP_RollsRoyce:1;
      unsigned int MP_REP_Saturn:1;
      unsigned int MP_REP_Subaru:1;
      unsigned int MP_REP_Suzuki:1;
      unsigned int MP_REP_GM:1;
      unsigned int MP_REP_SGM:1;
      unsigned int dummy27:1;
      unsigned int dummy28:1;
      unsigned int dummy29:1;
      unsigned int dummy30:1;
      unsigned int dummy31:1;
   };
   union {
      tU32 u32Value;
      rBitValues bits;
   };

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual tBool operator==(const fi_tcl_b32_POI2& rfoCmp) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   virtual tS32 s32GetTypeId() const { return typesfi_tclToken::EN_B32_POI2;}
   virtual tVoid vTakeVisitor(fi_tclVisitorBase& rfoVisitor);
};

class fi_tcl_b32_ServiceStations : public fi_tclVisitableTypeBase
{
public:
   fi_tcl_b32_ServiceStations():u32Value(0) {}

   enum {
      FI_C_U32_BIT_MP_REP_ALLG = 0x1UL,
      FI_C_U32_BIT_MP_REP_BOSCH = 0x2UL,
      FI_C_U32_BIT_MP_REP_FORD = 0x4UL,
      FI_C_U32_BIT_MP_REP_AUDI = 0x8UL,
      FI_C_U32_BIT_MP_REP_VW = 0x10UL,
      FI_C_U32_BIT_MP_REP_PORSCHE = 0x20UL,
      FI_C_U32_BIT_MP_REP_HONDA = 0x40UL,
      FI_C_U32_BIT_MP_REP_NISSAN = 0x80UL,
      FI_C_U32_BIT_MP_REP_MBENZ = 0x100UL,
      FI_C_U32_BIT_MP_REP_BMW = 0x200UL,
      FI_C_U32_BIT_MP_REP_OPEL = 0x400UL,
      FI_C_U32_BIT_MP_REP_CHRYSLER = 0x800UL,
      FI_C_U32_BIT_MP_REP_FIAT = 0x1000UL,
      FI_C_U32_BIT_MP_REP_SEAT = 0x2000UL,
      FI_C_U32_BIT_MP_REP_LANCIA = 0x4000UL,
      FI_C_U32_BIT_MP_REP_ALFA = 0x8000UL,
      FI_C_U32_BIT_MP_REP_SKODA = 0x10000UL,
      FI_C_U32_BIT_MP_REP_PEUGEOT = 0x20000UL,
      FI_C_U32_BIT_MP_REP_RENAULT = 0x40000UL,
      FI_C_U32_BIT_MP_REP_CITROEN = 0x80000UL,
      FI_C_U32_BIT_MP_REP_VOLVO = 0x100000UL,
      FI_C_U32_BIT_MP_REP_SAAB = 0x200000UL,
      FI_C_U32_BIT_MP_REP_TOYOTA = 0x400000UL,
      FI_C_U32_BIT_MP_REP_MITSUBISHI = 0x800000UL,
      FI_C_U32_BIT_MP_REP_MAZDA = 0x1000000UL,
      FI_C_U32_BIT_MP_REP_MASERATI = 0x2000000UL,
      FI_C_U32_BIT_MP_REP_FERRARI = 0x4000000UL,
      FI_C_U32_BIT_MP_REP_SMART = 0x8000000UL,
      FI_C_U32_BIT_MP_REP_ROVER = 0x10000000UL,
      FI_C_U32_BIT_MP_REP_LANDROVER = 0x20000000UL,
      FI_C_U32_BIT_MP_REP_ACURA = 0x40000000UL,
      FI_C_U32_BIT_MP_REP_ASTON = 0x80000000UL
   };
   tBool bMP_REP_Allg() const {return (u32Value & FI_C_U32_BIT_MP_REP_ALLG) != 0; }
   tVoid vSetMP_REP_Allg(tBool bSetBit) { u32Value = (bSetBit)?(u32Value | FI_C_U32_BIT_MP_REP_ALLG):(u32Value & ~FI_C_U32_BIT_MP_REP_ALLG); }
   tBool bMP_REP_Bosch() const {return (u32Value & FI_C_U32_BIT_MP_REP_BOSCH) != 0; }
   tVoid vSetMP_REP_Bosch(tBool bSetBit) { u32Value = (bSetBit)?(u32Value | FI_C_U32_BIT_MP_REP_BOSCH):(u32Value & ~FI_C_U32_BIT_MP_REP_BOSCH); }
   tBool bMP_REP_Ford() const {return (u32Value & FI_C_U32_BIT_MP_REP_FORD) != 0; }
   tVoid vSetMP_REP_Ford(tBool bSetBit) { u32Value = (bSetBit)?(u32Value | FI_C_U32_BIT_MP_REP_FORD):(u32Value & ~FI_C_U32_BIT_MP_REP_FORD); }
   tBool bMP_REP_Audi() const {return (u32Value & FI_C_U32_BIT_MP_REP_AUDI) != 0; }
   tVoid vSetMP_REP_Audi(tBool bSetBit) { u32Value = (bSetBit)?(u32Value | FI_C_U32_BIT_MP_REP_AUDI):(u32Value & ~FI_C_U32_BIT_MP_REP_AUDI); }
   tBool bMP_REP_Vw() const {return (u32Value & FI_C_U32_BIT_MP_REP_VW) != 0; }
   tVoid vSetMP_REP_Vw(tBool bSetBit) { u32Value = (bSetBit)?(u32Value | FI_C_U32_BIT_MP_REP_VW):(u32Value & ~FI_C_U32_BIT_MP_REP_VW); }
   tBool bMP_REP_Porsche() const {return (u32Value & FI_C_U32_BIT_MP_REP_PORSCHE) != 0; }
   tVoid vSetMP_REP_Porsche(tBool bSetBit) { u32Value = (bSetBit)?(u32Value | FI_C_U32_BIT_MP_REP_PORSCHE):(u32Value & ~FI_C_U32_BIT_MP_REP_PORSCHE); }
   tBool bMP_REP_Honda() const {return (u32Value & FI_C_U32_BIT_MP_REP_HONDA) != 0; }
   tVoid vSetMP_REP_Honda(tBool bSetBit) { u32Value = (bSetBit)?(u32Value | FI_C_U32_BIT_MP_REP_HONDA):(u32Value & ~FI_C_U32_BIT_MP_REP_HONDA); }
   tBool bMP_REP_Nissan() const {return (u32Value & FI_C_U32_BIT_MP_REP_NISSAN) != 0; }
   tVoid vSetMP_REP_Nissan(tBool bSetBit) { u32Value = (bSetBit)?(u32Value | FI_C_U32_BIT_MP_REP_NISSAN):(u32Value & ~FI_C_U32_BIT_MP_REP_NISSAN); }
   tBool bMP_REP_MBenz() const {return (u32Value & FI_C_U32_BIT_MP_REP_MBENZ) != 0; }
   tVoid vSetMP_REP_MBenz(tBool bSetBit) { u32Value = (bSetBit)?(u32Value | FI_C_U32_BIT_MP_REP_MBENZ):(u32Value & ~FI_C_U32_BIT_MP_REP_MBENZ); }
   tBool bMP_REP_BMW() const {return (u32Value & FI_C_U32_BIT_MP_REP_BMW) != 0; }
   tVoid vSetMP_REP_BMW(tBool bSetBit) { u32Value = (bSetBit)?(u32Value | FI_C_U32_BIT_MP_REP_BMW):(u32Value & ~FI_C_U32_BIT_MP_REP_BMW); }
   tBool bMP_REP_Opel() const {return (u32Value & FI_C_U32_BIT_MP_REP_OPEL) != 0; }
   tVoid vSetMP_REP_Opel(tBool bSetBit) { u32Value = (bSetBit)?(u32Value | FI_C_U32_BIT_MP_REP_OPEL):(u32Value & ~FI_C_U32_BIT_MP_REP_OPEL); }
   tBool bMP_REP_Chrysler() const {return (u32Value & FI_C_U32_BIT_MP_REP_CHRYSLER) != 0; }
   tVoid vSetMP_REP_Chrysler(tBool bSetBit) { u32Value = (bSetBit)?(u32Value | FI_C_U32_BIT_MP_REP_CHRYSLER):(u32Value & ~FI_C_U32_BIT_MP_REP_CHRYSLER); }
   tBool bMP_REP_Fiat() const {return (u32Value & FI_C_U32_BIT_MP_REP_FIAT) != 0; }
   tVoid vSetMP_REP_Fiat(tBool bSetBit) { u32Value = (bSetBit)?(u32Value | FI_C_U32_BIT_MP_REP_FIAT):(u32Value & ~FI_C_U32_BIT_MP_REP_FIAT); }
   tBool bMP_REP_Seat() const {return (u32Value & FI_C_U32_BIT_MP_REP_SEAT) != 0; }
   tVoid vSetMP_REP_Seat(tBool bSetBit) { u32Value = (bSetBit)?(u32Value | FI_C_U32_BIT_MP_REP_SEAT):(u32Value & ~FI_C_U32_BIT_MP_REP_SEAT); }
   tBool bMP_REP_Lancia() const {return (u32Value & FI_C_U32_BIT_MP_REP_LANCIA) != 0; }
   tVoid vSetMP_REP_Lancia(tBool bSetBit) { u32Value = (bSetBit)?(u32Value | FI_C_U32_BIT_MP_REP_LANCIA):(u32Value & ~FI_C_U32_BIT_MP_REP_LANCIA); }
   tBool bMP_REP_Alfa() const {return (u32Value & FI_C_U32_BIT_MP_REP_ALFA) != 0; }
   tVoid vSetMP_REP_Alfa(tBool bSetBit) { u32Value = (bSetBit)?(u32Value | FI_C_U32_BIT_MP_REP_ALFA):(u32Value & ~FI_C_U32_BIT_MP_REP_ALFA); }
   tBool bMP_REP_Skoda() const {return (u32Value & FI_C_U32_BIT_MP_REP_SKODA) != 0; }
   tVoid vSetMP_REP_Skoda(tBool bSetBit) { u32Value = (bSetBit)?(u32Value | FI_C_U32_BIT_MP_REP_SKODA):(u32Value & ~FI_C_U32_BIT_MP_REP_SKODA); }
   tBool bMP_REP_Peugeot() const {return (u32Value & FI_C_U32_BIT_MP_REP_PEUGEOT) != 0; }
   tVoid vSetMP_REP_Peugeot(tBool bSetBit) { u32Value = (bSetBit)?(u32Value | FI_C_U32_BIT_MP_REP_PEUGEOT):(u32Value & ~FI_C_U32_BIT_MP_REP_PEUGEOT); }
   tBool bMP_REP_Renault() const {return (u32Value & FI_C_U32_BIT_MP_REP_RENAULT) != 0; }
   tVoid vSetMP_REP_Renault(tBool bSetBit) { u32Value = (bSetBit)?(u32Value | FI_C_U32_BIT_MP_REP_RENAULT):(u32Value & ~FI_C_U32_BIT_MP_REP_RENAULT); }
   tBool bMP_REP_Citroen() const {return (u32Value & FI_C_U32_BIT_MP_REP_CITROEN) != 0; }
   tVoid vSetMP_REP_Citroen(tBool bSetBit) { u32Value = (bSetBit)?(u32Value | FI_C_U32_BIT_MP_REP_CITROEN):(u32Value & ~FI_C_U32_BIT_MP_REP_CITROEN); }
   tBool bMP_REP_Volvo() const {return (u32Value & FI_C_U32_BIT_MP_REP_VOLVO) != 0; }
   tVoid vSetMP_REP_Volvo(tBool bSetBit) { u32Value = (bSetBit)?(u32Value | FI_C_U32_BIT_MP_REP_VOLVO):(u32Value & ~FI_C_U32_BIT_MP_REP_VOLVO); }
   tBool bMP_REP_Saab() const {return (u32Value & FI_C_U32_BIT_MP_REP_SAAB) != 0; }
   tVoid vSetMP_REP_Saab(tBool bSetBit) { u32Value = (bSetBit)?(u32Value | FI_C_U32_BIT_MP_REP_SAAB):(u32Value & ~FI_C_U32_BIT_MP_REP_SAAB); }
   tBool bMP_REP_Toyota() const {return (u32Value & FI_C_U32_BIT_MP_REP_TOYOTA) != 0; }
   tVoid vSetMP_REP_Toyota(tBool bSetBit) { u32Value = (bSetBit)?(u32Value | FI_C_U32_BIT_MP_REP_TOYOTA):(u32Value & ~FI_C_U32_BIT_MP_REP_TOYOTA); }
   tBool bMP_REP_Mitsubishi() const {return (u32Value & FI_C_U32_BIT_MP_REP_MITSUBISHI) != 0; }
   tVoid vSetMP_REP_Mitsubishi(tBool bSetBit) { u32Value = (bSetBit)?(u32Value | FI_C_U32_BIT_MP_REP_MITSUBISHI):(u32Value & ~FI_C_U32_BIT_MP_REP_MITSUBISHI); }
   tBool bMP_REP_Mazda() const {return (u32Value & FI_C_U32_BIT_MP_REP_MAZDA) != 0; }
   tVoid vSetMP_REP_Mazda(tBool bSetBit) { u32Value = (bSetBit)?(u32Value | FI_C_U32_BIT_MP_REP_MAZDA):(u32Value & ~FI_C_U32_BIT_MP_REP_MAZDA); }
   tBool bMP_REP_Maserati() const {return (u32Value & FI_C_U32_BIT_MP_REP_MASERATI) != 0; }
   tVoid vSetMP_REP_Maserati(tBool bSetBit) { u32Value = (bSetBit)?(u32Value | FI_C_U32_BIT_MP_REP_MASERATI):(u32Value & ~FI_C_U32_BIT_MP_REP_MASERATI); }
   tBool bMP_REP_Ferrari() const {return (u32Value & FI_C_U32_BIT_MP_REP_FERRARI) != 0; }
   tVoid vSetMP_REP_Ferrari(tBool bSetBit) { u32Value = (bSetBit)?(u32Value | FI_C_U32_BIT_MP_REP_FERRARI):(u32Value & ~FI_C_U32_BIT_MP_REP_FERRARI); }
   tBool bMP_REP_Smart() const {return (u32Value & FI_C_U32_BIT_MP_REP_SMART) != 0; }
   tVoid vSetMP_REP_Smart(tBool bSetBit) { u32Value = (bSetBit)?(u32Value | FI_C_U32_BIT_MP_REP_SMART):(u32Value & ~FI_C_U32_BIT_MP_REP_SMART); }
   tBool bMP_REP_Rover() const {return (u32Value & FI_C_U32_BIT_MP_REP_ROVER) != 0; }
   tVoid vSetMP_REP_Rover(tBool bSetBit) { u32Value = (bSetBit)?(u32Value | FI_C_U32_BIT_MP_REP_ROVER):(u32Value & ~FI_C_U32_BIT_MP_REP_ROVER); }
   tBool bMP_REP_Landrover() const {return (u32Value & FI_C_U32_BIT_MP_REP_LANDROVER) != 0; }
   tVoid vSetMP_REP_Landrover(tBool bSetBit) { u32Value = (bSetBit)?(u32Value | FI_C_U32_BIT_MP_REP_LANDROVER):(u32Value & ~FI_C_U32_BIT_MP_REP_LANDROVER); }
   tBool bMP_REP_Acura() const {return (u32Value & FI_C_U32_BIT_MP_REP_ACURA) != 0; }
   tVoid vSetMP_REP_Acura(tBool bSetBit) { u32Value = (bSetBit)?(u32Value | FI_C_U32_BIT_MP_REP_ACURA):(u32Value & ~FI_C_U32_BIT_MP_REP_ACURA); }
   tBool bMP_REP_Aston() const {return (u32Value & FI_C_U32_BIT_MP_REP_ASTON) != 0; }
   tVoid vSetMP_REP_Aston(tBool bSetBit) { u32Value = (bSetBit)?(u32Value | FI_C_U32_BIT_MP_REP_ASTON):(u32Value & ~FI_C_U32_BIT_MP_REP_ASTON); }
   struct rBitValues {
      unsigned int MP_REP_Allg:1;
      unsigned int MP_REP_Bosch:1;
      unsigned int MP_REP_Ford:1;
      unsigned int MP_REP_Audi:1;
      unsigned int MP_REP_Vw:1;
      unsigned int MP_REP_Porsche:1;
      unsigned int MP_REP_Honda:1;
      unsigned int MP_REP_Nissan:1;
      unsigned int MP_REP_MBenz:1;
      unsigned int MP_REP_BMW:1;
      unsigned int MP_REP_Opel:1;
      unsigned int MP_REP_Chrysler:1;
      unsigned int MP_REP_Fiat:1;
      unsigned int MP_REP_Seat:1;
      unsigned int MP_REP_Lancia:1;
      unsigned int MP_REP_Alfa:1;
      unsigned int MP_REP_Skoda:1;
      unsigned int MP_REP_Peugeot:1;
      unsigned int MP_REP_Renault:1;
      unsigned int MP_REP_Citroen:1;
      unsigned int MP_REP_Volvo:1;
      unsigned int MP_REP_Saab:1;
      unsigned int MP_REP_Toyota:1;
      unsigned int MP_REP_Mitsubishi:1;
      unsigned int MP_REP_Mazda:1;
      unsigned int MP_REP_Maserati:1;
      unsigned int MP_REP_Ferrari:1;
      unsigned int MP_REP_Smart:1;
      unsigned int MP_REP_Rover:1;
      unsigned int MP_REP_Landrover:1;
      unsigned int MP_REP_Acura:1;
      unsigned int MP_REP_Aston:1;
   };
   union {
      tU32 u32Value;
      rBitValues bits;
   };

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual tBool operator==(const fi_tcl_b32_ServiceStations& rfoCmp) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   virtual tS32 s32GetTypeId() const { return typesfi_tclToken::EN_B32_SERVICESTATIONS;}
   virtual tVoid vTakeVisitor(fi_tclVisitorBase& rfoVisitor);
};

class fi_tcl_b32_ServiceStations2 : public fi_tclVisitableTypeBase
{
public:
   fi_tcl_b32_ServiceStations2():u32Value(0) {}

   enum {
      FI_C_U32_BIT_MP_REP_PROTON = 0x1UL,
      FI_C_U32_BIT_MP_REP_EVOBUS = 0x2UL,
      FI_C_U32_BIT_MP_REP_IRISBUS = 0x4UL,
      FI_C_U32_BIT_MP_REP_NEOMAN = 0x8UL,
      FI_C_U32_BIT_MP_REP_OMNIPLUS = 0x10UL,
      FI_C_U32_BIT_MP_REP_SCANIA = 0x20UL,
      FI_C_U32_BIT_MP_REP_VOLVO_TRUCK = 0x40UL,
      FI_C_U32_BIT_MP_REP_VOLKSWAGEN_TRUCK = 0x80UL,
      FI_C_U32_BIT_MP_REP_BLAUPUNKT = 0x100UL,
      FI_C_U32_BIT_MP_REP_DAF = 0x200UL,
      FI_C_U32_BIT_MP_REP_MANTRUCK = 0x400UL,
      FI_C_U32_BIT_MP_REP_NEOPLAN = 0x800UL
   };
   tBool bMP_REP_Proton() const {return (u32Value & FI_C_U32_BIT_MP_REP_PROTON) != 0; }
   tVoid vSetMP_REP_Proton(tBool bSetBit) { u32Value = (bSetBit)?(u32Value | FI_C_U32_BIT_MP_REP_PROTON):(u32Value & ~FI_C_U32_BIT_MP_REP_PROTON); }
   tBool bMP_REP_Evobus() const {return (u32Value & FI_C_U32_BIT_MP_REP_EVOBUS) != 0; }
   tVoid vSetMP_REP_Evobus(tBool bSetBit) { u32Value = (bSetBit)?(u32Value | FI_C_U32_BIT_MP_REP_EVOBUS):(u32Value & ~FI_C_U32_BIT_MP_REP_EVOBUS); }
   tBool bMP_REP_Irisbus() const {return (u32Value & FI_C_U32_BIT_MP_REP_IRISBUS) != 0; }
   tVoid vSetMP_REP_Irisbus(tBool bSetBit) { u32Value = (bSetBit)?(u32Value | FI_C_U32_BIT_MP_REP_IRISBUS):(u32Value & ~FI_C_U32_BIT_MP_REP_IRISBUS); }
   tBool bMP_REP_Neoman() const {return (u32Value & FI_C_U32_BIT_MP_REP_NEOMAN) != 0; }
   tVoid vSetMP_REP_Neoman(tBool bSetBit) { u32Value = (bSetBit)?(u32Value | FI_C_U32_BIT_MP_REP_NEOMAN):(u32Value & ~FI_C_U32_BIT_MP_REP_NEOMAN); }
   tBool bMP_REP_Omniplus() const {return (u32Value & FI_C_U32_BIT_MP_REP_OMNIPLUS) != 0; }
   tVoid vSetMP_REP_Omniplus(tBool bSetBit) { u32Value = (bSetBit)?(u32Value | FI_C_U32_BIT_MP_REP_OMNIPLUS):(u32Value & ~FI_C_U32_BIT_MP_REP_OMNIPLUS); }
   tBool bMP_REP_Scania() const {return (u32Value & FI_C_U32_BIT_MP_REP_SCANIA) != 0; }
   tVoid vSetMP_REP_Scania(tBool bSetBit) { u32Value = (bSetBit)?(u32Value | FI_C_U32_BIT_MP_REP_SCANIA):(u32Value & ~FI_C_U32_BIT_MP_REP_SCANIA); }
   tBool bMP_REP_Volvo_Truck() const {return (u32Value & FI_C_U32_BIT_MP_REP_VOLVO_TRUCK) != 0; }
   tVoid vSetMP_REP_Volvo_Truck(tBool bSetBit) { u32Value = (bSetBit)?(u32Value | FI_C_U32_BIT_MP_REP_VOLVO_TRUCK):(u32Value & ~FI_C_U32_BIT_MP_REP_VOLVO_TRUCK); }
   tBool bMP_REP_Volkswagen_Truck() const {return (u32Value & FI_C_U32_BIT_MP_REP_VOLKSWAGEN_TRUCK) != 0; }
   tVoid vSetMP_REP_Volkswagen_Truck(tBool bSetBit) { u32Value = (bSetBit)?(u32Value | FI_C_U32_BIT_MP_REP_VOLKSWAGEN_TRUCK):(u32Value & ~FI_C_U32_BIT_MP_REP_VOLKSWAGEN_TRUCK); }
   tBool bMP_REP_Blaupunkt() const {return (u32Value & FI_C_U32_BIT_MP_REP_BLAUPUNKT) != 0; }
   tVoid vSetMP_REP_Blaupunkt(tBool bSetBit) { u32Value = (bSetBit)?(u32Value | FI_C_U32_BIT_MP_REP_BLAUPUNKT):(u32Value & ~FI_C_U32_BIT_MP_REP_BLAUPUNKT); }
   tBool bMP_REP_DAF() const {return (u32Value & FI_C_U32_BIT_MP_REP_DAF) != 0; }
   tVoid vSetMP_REP_DAF(tBool bSetBit) { u32Value = (bSetBit)?(u32Value | FI_C_U32_BIT_MP_REP_DAF):(u32Value & ~FI_C_U32_BIT_MP_REP_DAF); }
   tBool bMP_REP_Mantruck() const {return (u32Value & FI_C_U32_BIT_MP_REP_MANTRUCK) != 0; }
   tVoid vSetMP_REP_Mantruck(tBool bSetBit) { u32Value = (bSetBit)?(u32Value | FI_C_U32_BIT_MP_REP_MANTRUCK):(u32Value & ~FI_C_U32_BIT_MP_REP_MANTRUCK); }
   tBool bMP_REP_Neoplan() const {return (u32Value & FI_C_U32_BIT_MP_REP_NEOPLAN) != 0; }
   tVoid vSetMP_REP_Neoplan(tBool bSetBit) { u32Value = (bSetBit)?(u32Value | FI_C_U32_BIT_MP_REP_NEOPLAN):(u32Value & ~FI_C_U32_BIT_MP_REP_NEOPLAN); }
   struct rBitValues {
      unsigned int MP_REP_Proton:1;
      unsigned int MP_REP_Evobus:1;
      unsigned int MP_REP_Irisbus:1;
      unsigned int MP_REP_Neoman:1;
      unsigned int MP_REP_Omniplus:1;
      unsigned int MP_REP_Scania:1;
      unsigned int MP_REP_Volvo_Truck:1;
      unsigned int MP_REP_Volkswagen_Truck:1;
      unsigned int MP_REP_Blaupunkt:1;
      unsigned int MP_REP_DAF:1;
      unsigned int MP_REP_Mantruck:1;
      unsigned int MP_REP_Neoplan:1;
      unsigned int dummy12:1;
      unsigned int dummy13:1;
      unsigned int dummy14:1;
      unsigned int dummy15:1;
      unsigned int dummy16:1;
      unsigned int dummy17:1;
      unsigned int dummy18:1;
      unsigned int dummy19:1;
      unsigned int dummy20:1;
      unsigned int dummy21:1;
      unsigned int dummy22:1;
      unsigned int dummy23:1;
      unsigned int dummy24:1;
      unsigned int dummy25:1;
      unsigned int dummy26:1;
      unsigned int dummy27:1;
      unsigned int dummy28:1;
      unsigned int dummy29:1;
      unsigned int dummy30:1;
      unsigned int dummy31:1;
   };
   union {
      tU32 u32Value;
      rBitValues bits;
   };

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual tBool operator==(const fi_tcl_b32_ServiceStations2& rfoCmp) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   virtual tS32 s32GetTypeId() const { return typesfi_tclToken::EN_B32_SERVICESTATIONS2;}
   virtual tVoid vTakeVisitor(fi_tclVisitorBase& rfoVisitor);
};

class fi_tcl_b32_ServiceStations3 : public fi_tclVisitableTypeBase
{
public:
   fi_tcl_b32_ServiceStations3():u32Value(0) {}

   enum {
      FI_C_U32_BIT_DUMMY0 = 0x1UL
   };
   tBool bdummy0() const {return (u32Value & FI_C_U32_BIT_DUMMY0) != 0; }
   tVoid vSetdummy0(tBool bSetBit) { u32Value = (bSetBit)?(u32Value | FI_C_U32_BIT_DUMMY0):(u32Value & ~FI_C_U32_BIT_DUMMY0); }
   struct rBitValues {
      unsigned int dummy0:1;
      unsigned int dummy1:1;
      unsigned int dummy2:1;
      unsigned int dummy3:1;
      unsigned int dummy4:1;
      unsigned int dummy5:1;
      unsigned int dummy6:1;
      unsigned int dummy7:1;
      unsigned int dummy8:1;
      unsigned int dummy9:1;
      unsigned int dummy10:1;
      unsigned int dummy11:1;
      unsigned int dummy12:1;
      unsigned int dummy13:1;
      unsigned int dummy14:1;
      unsigned int dummy15:1;
      unsigned int dummy16:1;
      unsigned int dummy17:1;
      unsigned int dummy18:1;
      unsigned int dummy19:1;
      unsigned int dummy20:1;
      unsigned int dummy21:1;
      unsigned int dummy22:1;
      unsigned int dummy23:1;
      unsigned int dummy24:1;
      unsigned int dummy25:1;
      unsigned int dummy26:1;
      unsigned int dummy27:1;
      unsigned int dummy28:1;
      unsigned int dummy29:1;
      unsigned int dummy30:1;
      unsigned int dummy31:1;
   };
   union {
      tU32 u32Value;
      rBitValues bits;
   };

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual tBool operator==(const fi_tcl_b32_ServiceStations3& rfoCmp) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   virtual tS32 s32GetTypeId() const { return typesfi_tclToken::EN_B32_SERVICESTATIONS3;}
   virtual tVoid vTakeVisitor(fi_tclVisitorBase& rfoVisitor);
};

class fi_tcl_b8_FreewayFacilities : public fi_tclVisitableTypeBase
{
public:
   fi_tcl_b8_FreewayFacilities():u8Value(0) {}

   enum {
      FI_C_U8_BIT_MP_FRF_T = 0x1UL,
      FI_C_U8_BIT_MP_FRF_R = 0x2UL,
      FI_C_U8_BIT_MP_FRF_K = 0x4UL,
      FI_C_U8_BIT_MP_FRF_M = 0x8UL,
      FI_C_U8_BIT_MP_FRF_W = 0x10UL,
      FI_C_U8_BIT_MP_FRF_P = 0x20UL
   };
   tBool bMP_FRF_T() const {return (u8Value & FI_C_U8_BIT_MP_FRF_T) != 0; }
   tVoid vSetMP_FRF_T(tBool bSetBit) { u8Value = (bSetBit)?(u8Value | FI_C_U8_BIT_MP_FRF_T):(u8Value & ~FI_C_U8_BIT_MP_FRF_T); }
   tBool bMP_FRF_R() const {return (u8Value & FI_C_U8_BIT_MP_FRF_R) != 0; }
   tVoid vSetMP_FRF_R(tBool bSetBit) { u8Value = (bSetBit)?(u8Value | FI_C_U8_BIT_MP_FRF_R):(u8Value & ~FI_C_U8_BIT_MP_FRF_R); }
   tBool bMP_FRF_K() const {return (u8Value & FI_C_U8_BIT_MP_FRF_K) != 0; }
   tVoid vSetMP_FRF_K(tBool bSetBit) { u8Value = (bSetBit)?(u8Value | FI_C_U8_BIT_MP_FRF_K):(u8Value & ~FI_C_U8_BIT_MP_FRF_K); }
   tBool bMP_FRF_M() const {return (u8Value & FI_C_U8_BIT_MP_FRF_M) != 0; }
   tVoid vSetMP_FRF_M(tBool bSetBit) { u8Value = (bSetBit)?(u8Value | FI_C_U8_BIT_MP_FRF_M):(u8Value & ~FI_C_U8_BIT_MP_FRF_M); }
   tBool bMP_FRF_W() const {return (u8Value & FI_C_U8_BIT_MP_FRF_W) != 0; }
   tVoid vSetMP_FRF_W(tBool bSetBit) { u8Value = (bSetBit)?(u8Value | FI_C_U8_BIT_MP_FRF_W):(u8Value & ~FI_C_U8_BIT_MP_FRF_W); }
   tBool bMP_FRF_P() const {return (u8Value & FI_C_U8_BIT_MP_FRF_P) != 0; }
   tVoid vSetMP_FRF_P(tBool bSetBit) { u8Value = (bSetBit)?(u8Value | FI_C_U8_BIT_MP_FRF_P):(u8Value & ~FI_C_U8_BIT_MP_FRF_P); }
   struct rBitValues {
      unsigned int MP_FRF_T:1;
      unsigned int MP_FRF_R:1;
      unsigned int MP_FRF_K:1;
      unsigned int MP_FRF_M:1;
      unsigned int MP_FRF_W:1;
      unsigned int MP_FRF_P:1;
      unsigned int dummy6:1;
      unsigned int dummy7:1;
   };
   union {
      tU8 u8Value;
      rBitValues bits;
   };

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual tBool operator==(const fi_tcl_b8_FreewayFacilities& rfoCmp) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   virtual tS32 s32GetTypeId() const { return typesfi_tclToken::EN_B8_FREEWAYFACILITIES;}
   virtual tVoid vTakeVisitor(fi_tclVisitorBase& rfoVisitor);
};

class fi_tcl_b8_ParkingAreas : public fi_tclVisitableTypeBase
{
public:
   fi_tcl_b8_ParkingAreas():u8Value(0) {}

   enum {
      FI_C_U8_BIT_MP_PRK_0 = 0x1UL,
      FI_C_U8_BIT_MP_PRK_1 = 0x2UL,
      FI_C_U8_BIT_MP_PRK_2 = 0x4UL,
      FI_C_U8_BIT_MP_PRK_3 = 0x8UL
   };
   tBool bMP_PRK_0() const {return (u8Value & FI_C_U8_BIT_MP_PRK_0) != 0; }
   tVoid vSetMP_PRK_0(tBool bSetBit) { u8Value = (bSetBit)?(u8Value | FI_C_U8_BIT_MP_PRK_0):(u8Value & ~FI_C_U8_BIT_MP_PRK_0); }
   tBool bMP_PRK_1() const {return (u8Value & FI_C_U8_BIT_MP_PRK_1) != 0; }
   tVoid vSetMP_PRK_1(tBool bSetBit) { u8Value = (bSetBit)?(u8Value | FI_C_U8_BIT_MP_PRK_1):(u8Value & ~FI_C_U8_BIT_MP_PRK_1); }
   tBool bMP_PRK_2() const {return (u8Value & FI_C_U8_BIT_MP_PRK_2) != 0; }
   tVoid vSetMP_PRK_2(tBool bSetBit) { u8Value = (bSetBit)?(u8Value | FI_C_U8_BIT_MP_PRK_2):(u8Value & ~FI_C_U8_BIT_MP_PRK_2); }
   tBool bMP_PRK_3() const {return (u8Value & FI_C_U8_BIT_MP_PRK_3) != 0; }
   tVoid vSetMP_PRK_3(tBool bSetBit) { u8Value = (bSetBit)?(u8Value | FI_C_U8_BIT_MP_PRK_3):(u8Value & ~FI_C_U8_BIT_MP_PRK_3); }
   struct rBitValues {
      unsigned int MP_PRK_0:1;
      unsigned int MP_PRK_1:1;
      unsigned int MP_PRK_2:1;
      unsigned int MP_PRK_3:1;
      unsigned int dummy4:1;
      unsigned int dummy5:1;
      unsigned int dummy6:1;
      unsigned int dummy7:1;
   };
   union {
      tU8 u8Value;
      rBitValues bits;
   };

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual tBool operator==(const fi_tcl_b8_ParkingAreas& rfoCmp) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   virtual tS32 s32GetTypeId() const { return typesfi_tclToken::EN_B8_PARKINGAREAS;}
   virtual tVoid vTakeVisitor(fi_tclVisitorBase& rfoVisitor);
};

class fi_tcl_b8_BorderLines : public fi_tclVisitableTypeBase
{
public:
   fi_tcl_b8_BorderLines():u8Value(0) {}

   enum {
      FI_C_U8_BIT_MP_BRD_0 = 0x1UL,
      FI_C_U8_BIT_MP_BRD_1 = 0x2UL,
      FI_C_U8_BIT_MP_BRD_2 = 0x4UL,
      FI_C_U8_BIT_MP_BRD_3 = 0x8UL
   };
   tBool bMP_BRD_0() const {return (u8Value & FI_C_U8_BIT_MP_BRD_0) != 0; }
   tVoid vSetMP_BRD_0(tBool bSetBit) { u8Value = (bSetBit)?(u8Value | FI_C_U8_BIT_MP_BRD_0):(u8Value & ~FI_C_U8_BIT_MP_BRD_0); }
   tBool bMP_BRD_1() const {return (u8Value & FI_C_U8_BIT_MP_BRD_1) != 0; }
   tVoid vSetMP_BRD_1(tBool bSetBit) { u8Value = (bSetBit)?(u8Value | FI_C_U8_BIT_MP_BRD_1):(u8Value & ~FI_C_U8_BIT_MP_BRD_1); }
   tBool bMP_BRD_2() const {return (u8Value & FI_C_U8_BIT_MP_BRD_2) != 0; }
   tVoid vSetMP_BRD_2(tBool bSetBit) { u8Value = (bSetBit)?(u8Value | FI_C_U8_BIT_MP_BRD_2):(u8Value & ~FI_C_U8_BIT_MP_BRD_2); }
   tBool bMP_BRD_3() const {return (u8Value & FI_C_U8_BIT_MP_BRD_3) != 0; }
   tVoid vSetMP_BRD_3(tBool bSetBit) { u8Value = (bSetBit)?(u8Value | FI_C_U8_BIT_MP_BRD_3):(u8Value & ~FI_C_U8_BIT_MP_BRD_3); }
   struct rBitValues {
      unsigned int MP_BRD_0:1;
      unsigned int MP_BRD_1:1;
      unsigned int MP_BRD_2:1;
      unsigned int MP_BRD_3:1;
      unsigned int dummy4:1;
      unsigned int dummy5:1;
      unsigned int dummy6:1;
      unsigned int dummy7:1;
   };
   union {
      tU8 u8Value;
      rBitValues bits;
   };

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual tBool operator==(const fi_tcl_b8_BorderLines& rfoCmp) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   virtual tS32 s32GetTypeId() const { return typesfi_tclToken::EN_B8_BORDERLINES;}
   virtual tVoid vTakeVisitor(fi_tclVisitorBase& rfoVisitor);
};

class fi_tcl_b8_RiverClass : public fi_tclVisitableTypeBase
{
public:
   fi_tcl_b8_RiverClass():u8Value(0) {}

   enum {
      FI_C_U8_BIT_MP_RIV_0 = 0x1UL,
      FI_C_U8_BIT_MP_RIV_1 = 0x2UL,
      FI_C_U8_BIT_MP_RIV_2 = 0x4UL,
      FI_C_U8_BIT_MP_RIV_3 = 0x8UL
   };
   tBool bMP_RIV_0() const {return (u8Value & FI_C_U8_BIT_MP_RIV_0) != 0; }
   tVoid vSetMP_RIV_0(tBool bSetBit) { u8Value = (bSetBit)?(u8Value | FI_C_U8_BIT_MP_RIV_0):(u8Value & ~FI_C_U8_BIT_MP_RIV_0); }
   tBool bMP_RIV_1() const {return (u8Value & FI_C_U8_BIT_MP_RIV_1) != 0; }
   tVoid vSetMP_RIV_1(tBool bSetBit) { u8Value = (bSetBit)?(u8Value | FI_C_U8_BIT_MP_RIV_1):(u8Value & ~FI_C_U8_BIT_MP_RIV_1); }
   tBool bMP_RIV_2() const {return (u8Value & FI_C_U8_BIT_MP_RIV_2) != 0; }
   tVoid vSetMP_RIV_2(tBool bSetBit) { u8Value = (bSetBit)?(u8Value | FI_C_U8_BIT_MP_RIV_2):(u8Value & ~FI_C_U8_BIT_MP_RIV_2); }
   tBool bMP_RIV_3() const {return (u8Value & FI_C_U8_BIT_MP_RIV_3) != 0; }
   tVoid vSetMP_RIV_3(tBool bSetBit) { u8Value = (bSetBit)?(u8Value | FI_C_U8_BIT_MP_RIV_3):(u8Value & ~FI_C_U8_BIT_MP_RIV_3); }
   struct rBitValues {
      unsigned int MP_RIV_0:1;
      unsigned int MP_RIV_1:1;
      unsigned int MP_RIV_2:1;
      unsigned int MP_RIV_3:1;
      unsigned int dummy4:1;
      unsigned int dummy5:1;
      unsigned int dummy6:1;
      unsigned int dummy7:1;
   };
   union {
      tU8 u8Value;
      rBitValues bits;
   };

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual tBool operator==(const fi_tcl_b8_RiverClass& rfoCmp) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   virtual tS32 s32GetTypeId() const { return typesfi_tclToken::EN_B8_RIVERCLASS;}
   virtual tVoid vTakeVisitor(fi_tclVisitorBase& rfoVisitor);
};

class fi_tcl_b8_Channels : public fi_tclVisitableTypeBase
{
public:
   fi_tcl_b8_Channels():u8Value(0) {}

   enum {
      FI_C_U8_BIT_MP_CHA_0 = 0x1UL,
      FI_C_U8_BIT_MP_CHA_1 = 0x2UL,
      FI_C_U8_BIT_MP_CHA_2 = 0x4UL,
      FI_C_U8_BIT_MP_CHA_3 = 0x8UL
   };
   tBool bMP_CHA_0() const {return (u8Value & FI_C_U8_BIT_MP_CHA_0) != 0; }
   tVoid vSetMP_CHA_0(tBool bSetBit) { u8Value = (bSetBit)?(u8Value | FI_C_U8_BIT_MP_CHA_0):(u8Value & ~FI_C_U8_BIT_MP_CHA_0); }
   tBool bMP_CHA_1() const {return (u8Value & FI_C_U8_BIT_MP_CHA_1) != 0; }
   tVoid vSetMP_CHA_1(tBool bSetBit) { u8Value = (bSetBit)?(u8Value | FI_C_U8_BIT_MP_CHA_1):(u8Value & ~FI_C_U8_BIT_MP_CHA_1); }
   tBool bMP_CHA_2() const {return (u8Value & FI_C_U8_BIT_MP_CHA_2) != 0; }
   tVoid vSetMP_CHA_2(tBool bSetBit) { u8Value = (bSetBit)?(u8Value | FI_C_U8_BIT_MP_CHA_2):(u8Value & ~FI_C_U8_BIT_MP_CHA_2); }
   tBool bMP_CHA_3() const {return (u8Value & FI_C_U8_BIT_MP_CHA_3) != 0; }
   tVoid vSetMP_CHA_3(tBool bSetBit) { u8Value = (bSetBit)?(u8Value | FI_C_U8_BIT_MP_CHA_3):(u8Value & ~FI_C_U8_BIT_MP_CHA_3); }
   struct rBitValues {
      unsigned int MP_CHA_0:1;
      unsigned int MP_CHA_1:1;
      unsigned int MP_CHA_2:1;
      unsigned int MP_CHA_3:1;
      unsigned int dummy4:1;
      unsigned int dummy5:1;
      unsigned int dummy6:1;
      unsigned int dummy7:1;
   };
   union {
      tU8 u8Value;
      rBitValues bits;
   };

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual tBool operator==(const fi_tcl_b8_Channels& rfoCmp) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   virtual tS32 s32GetTypeId() const { return typesfi_tclToken::EN_B8_CHANNELS;}
   virtual tVoid vTakeVisitor(fi_tclVisitorBase& rfoVisitor);
};

class fi_tcl_b32_Streets : public fi_tclVisitableTypeBase
{
public:
   fi_tcl_b32_Streets():u32Value(0) {}

   enum {
      FI_C_U32_BIT_MP_STR_0 = 0x1UL,
      FI_C_U32_BIT_MP_STR_1 = 0x2UL,
      FI_C_U32_BIT_MP_STR_2 = 0x4UL,
      FI_C_U32_BIT_MP_STR_3 = 0x8UL,
      FI_C_U32_BIT_MP_STR_4 = 0x10UL,
      FI_C_U32_BIT_MP_STR_5 = 0x20UL,
      FI_C_U32_BIT_MP_STR_6 = 0x40UL,
      FI_C_U32_BIT_MP_STR_7 = 0x80UL,
      FI_C_U32_BIT_MP_STR_8 = 0x100UL,
      FI_C_U32_BIT_MP_STR_9 = 0x200UL
   };
   tBool bMP_STR_0() const {return (u32Value & FI_C_U32_BIT_MP_STR_0) != 0; }
   tVoid vSetMP_STR_0(tBool bSetBit) { u32Value = (bSetBit)?(u32Value | FI_C_U32_BIT_MP_STR_0):(u32Value & ~FI_C_U32_BIT_MP_STR_0); }
   tBool bMP_STR_1() const {return (u32Value & FI_C_U32_BIT_MP_STR_1) != 0; }
   tVoid vSetMP_STR_1(tBool bSetBit) { u32Value = (bSetBit)?(u32Value | FI_C_U32_BIT_MP_STR_1):(u32Value & ~FI_C_U32_BIT_MP_STR_1); }
   tBool bMP_STR_2() const {return (u32Value & FI_C_U32_BIT_MP_STR_2) != 0; }
   tVoid vSetMP_STR_2(tBool bSetBit) { u32Value = (bSetBit)?(u32Value | FI_C_U32_BIT_MP_STR_2):(u32Value & ~FI_C_U32_BIT_MP_STR_2); }
   tBool bMP_STR_3() const {return (u32Value & FI_C_U32_BIT_MP_STR_3) != 0; }
   tVoid vSetMP_STR_3(tBool bSetBit) { u32Value = (bSetBit)?(u32Value | FI_C_U32_BIT_MP_STR_3):(u32Value & ~FI_C_U32_BIT_MP_STR_3); }
   tBool bMP_STR_4() const {return (u32Value & FI_C_U32_BIT_MP_STR_4) != 0; }
   tVoid vSetMP_STR_4(tBool bSetBit) { u32Value = (bSetBit)?(u32Value | FI_C_U32_BIT_MP_STR_4):(u32Value & ~FI_C_U32_BIT_MP_STR_4); }
   tBool bMP_STR_5() const {return (u32Value & FI_C_U32_BIT_MP_STR_5) != 0; }
   tVoid vSetMP_STR_5(tBool bSetBit) { u32Value = (bSetBit)?(u32Value | FI_C_U32_BIT_MP_STR_5):(u32Value & ~FI_C_U32_BIT_MP_STR_5); }
   tBool bMP_STR_6() const {return (u32Value & FI_C_U32_BIT_MP_STR_6) != 0; }
   tVoid vSetMP_STR_6(tBool bSetBit) { u32Value = (bSetBit)?(u32Value | FI_C_U32_BIT_MP_STR_6):(u32Value & ~FI_C_U32_BIT_MP_STR_6); }
   tBool bMP_STR_7() const {return (u32Value & FI_C_U32_BIT_MP_STR_7) != 0; }
   tVoid vSetMP_STR_7(tBool bSetBit) { u32Value = (bSetBit)?(u32Value | FI_C_U32_BIT_MP_STR_7):(u32Value & ~FI_C_U32_BIT_MP_STR_7); }
   tBool bMP_STR_8() const {return (u32Value & FI_C_U32_BIT_MP_STR_8) != 0; }
   tVoid vSetMP_STR_8(tBool bSetBit) { u32Value = (bSetBit)?(u32Value | FI_C_U32_BIT_MP_STR_8):(u32Value & ~FI_C_U32_BIT_MP_STR_8); }
   tBool bMP_STR_9() const {return (u32Value & FI_C_U32_BIT_MP_STR_9) != 0; }
   tVoid vSetMP_STR_9(tBool bSetBit) { u32Value = (bSetBit)?(u32Value | FI_C_U32_BIT_MP_STR_9):(u32Value & ~FI_C_U32_BIT_MP_STR_9); }
   struct rBitValues {
      unsigned int MP_STR_0:1;
      unsigned int MP_STR_1:1;
      unsigned int MP_STR_2:1;
      unsigned int MP_STR_3:1;
      unsigned int MP_STR_4:1;
      unsigned int MP_STR_5:1;
      unsigned int MP_STR_6:1;
      unsigned int MP_STR_7:1;
      unsigned int MP_STR_8:1;
      unsigned int MP_STR_9:1;
      unsigned int dummy10:1;
      unsigned int dummy11:1;
      unsigned int dummy12:1;
      unsigned int dummy13:1;
      unsigned int dummy14:1;
      unsigned int dummy15:1;
      unsigned int dummy16:1;
      unsigned int dummy17:1;
      unsigned int dummy18:1;
      unsigned int dummy19:1;
      unsigned int dummy20:1;
      unsigned int dummy21:1;
      unsigned int dummy22:1;
      unsigned int dummy23:1;
      unsigned int dummy24:1;
      unsigned int dummy25:1;
      unsigned int dummy26:1;
      unsigned int dummy27:1;
      unsigned int dummy28:1;
      unsigned int dummy29:1;
      unsigned int dummy30:1;
      unsigned int dummy31:1;
   };
   union {
      tU32 u32Value;
      rBitValues bits;
   };

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual tBool operator==(const fi_tcl_b32_Streets& rfoCmp) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   virtual tS32 s32GetTypeId() const { return typesfi_tclToken::EN_B32_STREETS;}
   virtual tVoid vTakeVisitor(fi_tclVisitorBase& rfoVisitor);
};

class fi_tcl_b8_Areas : public fi_tclVisitableTypeBase
{
public:
   fi_tcl_b8_Areas():u8Value(0) {}

   enum {
      FI_C_U8_BIT_MP_AREA_URBAN = 0x1UL,
      FI_C_U8_BIT_MP_AREA_NPARKS = 0x2UL,
      FI_C_U8_BIT_MP_AREA_CPARK = 0x4UL,
      FI_C_U8_BIT_MP_AREA_WATER = 0x8UL,
      FI_C_U8_BIT_MP_AREA_ISLAND = 0x10UL,
      FI_C_U8_BIT_MP_AREA_WOOD = 0x20UL,
      FI_C_U8_BIT_MP_AREA_INDS = 0x40UL,
      FI_C_U8_BIT_MP_AREA_DESERT = 0x80UL
   };
   tBool bMP_AREA_URBAN() const {return (u8Value & FI_C_U8_BIT_MP_AREA_URBAN) != 0; }
   tVoid vSetMP_AREA_URBAN(tBool bSetBit) { u8Value = (bSetBit)?(u8Value | FI_C_U8_BIT_MP_AREA_URBAN):(u8Value & ~FI_C_U8_BIT_MP_AREA_URBAN); }
   tBool bMP_AREA_NPARKS() const {return (u8Value & FI_C_U8_BIT_MP_AREA_NPARKS) != 0; }
   tVoid vSetMP_AREA_NPARKS(tBool bSetBit) { u8Value = (bSetBit)?(u8Value | FI_C_U8_BIT_MP_AREA_NPARKS):(u8Value & ~FI_C_U8_BIT_MP_AREA_NPARKS); }
   tBool bMP_AREA_CPARK() const {return (u8Value & FI_C_U8_BIT_MP_AREA_CPARK) != 0; }
   tVoid vSetMP_AREA_CPARK(tBool bSetBit) { u8Value = (bSetBit)?(u8Value | FI_C_U8_BIT_MP_AREA_CPARK):(u8Value & ~FI_C_U8_BIT_MP_AREA_CPARK); }
   tBool bMP_AREA_WATER() const {return (u8Value & FI_C_U8_BIT_MP_AREA_WATER) != 0; }
   tVoid vSetMP_AREA_WATER(tBool bSetBit) { u8Value = (bSetBit)?(u8Value | FI_C_U8_BIT_MP_AREA_WATER):(u8Value & ~FI_C_U8_BIT_MP_AREA_WATER); }
   tBool bMP_AREA_ISLAND() const {return (u8Value & FI_C_U8_BIT_MP_AREA_ISLAND) != 0; }
   tVoid vSetMP_AREA_ISLAND(tBool bSetBit) { u8Value = (bSetBit)?(u8Value | FI_C_U8_BIT_MP_AREA_ISLAND):(u8Value & ~FI_C_U8_BIT_MP_AREA_ISLAND); }
   tBool bMP_AREA_WOOD() const {return (u8Value & FI_C_U8_BIT_MP_AREA_WOOD) != 0; }
   tVoid vSetMP_AREA_WOOD(tBool bSetBit) { u8Value = (bSetBit)?(u8Value | FI_C_U8_BIT_MP_AREA_WOOD):(u8Value & ~FI_C_U8_BIT_MP_AREA_WOOD); }
   tBool bMP_AREA_INDS() const {return (u8Value & FI_C_U8_BIT_MP_AREA_INDS) != 0; }
   tVoid vSetMP_AREA_INDS(tBool bSetBit) { u8Value = (bSetBit)?(u8Value | FI_C_U8_BIT_MP_AREA_INDS):(u8Value & ~FI_C_U8_BIT_MP_AREA_INDS); }
   tBool bMP_AREA_DESERT() const {return (u8Value & FI_C_U8_BIT_MP_AREA_DESERT) != 0; }
   tVoid vSetMP_AREA_DESERT(tBool bSetBit) { u8Value = (bSetBit)?(u8Value | FI_C_U8_BIT_MP_AREA_DESERT):(u8Value & ~FI_C_U8_BIT_MP_AREA_DESERT); }
   struct rBitValues {
      unsigned int MP_AREA_URBAN:1;
      unsigned int MP_AREA_NPARKS:1;
      unsigned int MP_AREA_CPARK:1;
      unsigned int MP_AREA_WATER:1;
      unsigned int MP_AREA_ISLAND:1;
      unsigned int MP_AREA_WOOD:1;
      unsigned int MP_AREA_INDS:1;
      unsigned int MP_AREA_DESERT:1;
   };
   union {
      tU8 u8Value;
      rBitValues bits;
   };

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual tBool operator==(const fi_tcl_b8_Areas& rfoCmp) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   virtual tS32 s32GetTypeId() const { return typesfi_tclToken::EN_B8_AREAS;}
   virtual tVoid vTakeVisitor(fi_tclVisitorBase& rfoVisitor);
};

class fi_tcl_b32_CityCenters : public fi_tclVisitableTypeBase
{
public:
   fi_tcl_b32_CityCenters():u32Value(0) {}

   enum {
      FI_C_U32_BIT_MP_CCP_G_10_MIO = 0x1UL,
      FI_C_U32_BIT_MP_CCP_G_5_MIO = 0x2UL,
      FI_C_U32_BIT_MP_CCP_G_2_MIO = 0x4UL,
      FI_C_U32_BIT_MP_CCP_G_1_MIO = 0x8UL,
      FI_C_U32_BIT_MP_CCP_G_500000 = 0x10UL,
      FI_C_U32_BIT_MP_CCP_G_200000 = 0x20UL,
      FI_C_U32_BIT_MP_CCP_G_100000 = 0x40UL,
      FI_C_U32_BIT_MP_CCP_G_50000 = 0x80UL,
      FI_C_U32_BIT_MP_CCP_G_20000 = 0x100UL,
      FI_C_U32_BIT_MP_CCP_G_10000 = 0x200UL,
      FI_C_U32_BIT_MP_CCP_G_5000 = 0x400UL,
      FI_C_U32_BIT_MP_CCP_L_5000 = 0x800UL,
      FI_C_U32_BIT_MP_CCP_CROWD = 0x1000UL
   };
   tBool bMP_CCP_G_10_MIO() const {return (u32Value & FI_C_U32_BIT_MP_CCP_G_10_MIO) != 0; }
   tVoid vSetMP_CCP_G_10_MIO(tBool bSetBit) { u32Value = (bSetBit)?(u32Value | FI_C_U32_BIT_MP_CCP_G_10_MIO):(u32Value & ~FI_C_U32_BIT_MP_CCP_G_10_MIO); }
   tBool bMP_CCP_G_5_MIO() const {return (u32Value & FI_C_U32_BIT_MP_CCP_G_5_MIO) != 0; }
   tVoid vSetMP_CCP_G_5_MIO(tBool bSetBit) { u32Value = (bSetBit)?(u32Value | FI_C_U32_BIT_MP_CCP_G_5_MIO):(u32Value & ~FI_C_U32_BIT_MP_CCP_G_5_MIO); }
   tBool bMP_CCP_G_2_MIO() const {return (u32Value & FI_C_U32_BIT_MP_CCP_G_2_MIO) != 0; }
   tVoid vSetMP_CCP_G_2_MIO(tBool bSetBit) { u32Value = (bSetBit)?(u32Value | FI_C_U32_BIT_MP_CCP_G_2_MIO):(u32Value & ~FI_C_U32_BIT_MP_CCP_G_2_MIO); }
   tBool bMP_CCP_G_1_MIO() const {return (u32Value & FI_C_U32_BIT_MP_CCP_G_1_MIO) != 0; }
   tVoid vSetMP_CCP_G_1_MIO(tBool bSetBit) { u32Value = (bSetBit)?(u32Value | FI_C_U32_BIT_MP_CCP_G_1_MIO):(u32Value & ~FI_C_U32_BIT_MP_CCP_G_1_MIO); }
   tBool bMP_CCP_G_500000() const {return (u32Value & FI_C_U32_BIT_MP_CCP_G_500000) != 0; }
   tVoid vSetMP_CCP_G_500000(tBool bSetBit) { u32Value = (bSetBit)?(u32Value | FI_C_U32_BIT_MP_CCP_G_500000):(u32Value & ~FI_C_U32_BIT_MP_CCP_G_500000); }
   tBool bMP_CCP_G_200000() const {return (u32Value & FI_C_U32_BIT_MP_CCP_G_200000) != 0; }
   tVoid vSetMP_CCP_G_200000(tBool bSetBit) { u32Value = (bSetBit)?(u32Value | FI_C_U32_BIT_MP_CCP_G_200000):(u32Value & ~FI_C_U32_BIT_MP_CCP_G_200000); }
   tBool bMP_CCP_G_100000() const {return (u32Value & FI_C_U32_BIT_MP_CCP_G_100000) != 0; }
   tVoid vSetMP_CCP_G_100000(tBool bSetBit) { u32Value = (bSetBit)?(u32Value | FI_C_U32_BIT_MP_CCP_G_100000):(u32Value & ~FI_C_U32_BIT_MP_CCP_G_100000); }
   tBool bMP_CCP_G_50000() const {return (u32Value & FI_C_U32_BIT_MP_CCP_G_50000) != 0; }
   tVoid vSetMP_CCP_G_50000(tBool bSetBit) { u32Value = (bSetBit)?(u32Value | FI_C_U32_BIT_MP_CCP_G_50000):(u32Value & ~FI_C_U32_BIT_MP_CCP_G_50000); }
   tBool bMP_CCP_G_20000() const {return (u32Value & FI_C_U32_BIT_MP_CCP_G_20000) != 0; }
   tVoid vSetMP_CCP_G_20000(tBool bSetBit) { u32Value = (bSetBit)?(u32Value | FI_C_U32_BIT_MP_CCP_G_20000):(u32Value & ~FI_C_U32_BIT_MP_CCP_G_20000); }
   tBool bMP_CCP_G_10000() const {return (u32Value & FI_C_U32_BIT_MP_CCP_G_10000) != 0; }
   tVoid vSetMP_CCP_G_10000(tBool bSetBit) { u32Value = (bSetBit)?(u32Value | FI_C_U32_BIT_MP_CCP_G_10000):(u32Value & ~FI_C_U32_BIT_MP_CCP_G_10000); }
   tBool bMP_CCP_G_5000() const {return (u32Value & FI_C_U32_BIT_MP_CCP_G_5000) != 0; }
   tVoid vSetMP_CCP_G_5000(tBool bSetBit) { u32Value = (bSetBit)?(u32Value | FI_C_U32_BIT_MP_CCP_G_5000):(u32Value & ~FI_C_U32_BIT_MP_CCP_G_5000); }
   tBool bMP_CCP_L_5000() const {return (u32Value & FI_C_U32_BIT_MP_CCP_L_5000) != 0; }
   tVoid vSetMP_CCP_L_5000(tBool bSetBit) { u32Value = (bSetBit)?(u32Value | FI_C_U32_BIT_MP_CCP_L_5000):(u32Value & ~FI_C_U32_BIT_MP_CCP_L_5000); }
   tBool bMP_CCP_CROWD() const {return (u32Value & FI_C_U32_BIT_MP_CCP_CROWD) != 0; }
   tVoid vSetMP_CCP_CROWD(tBool bSetBit) { u32Value = (bSetBit)?(u32Value | FI_C_U32_BIT_MP_CCP_CROWD):(u32Value & ~FI_C_U32_BIT_MP_CCP_CROWD); }
   struct rBitValues {
      unsigned int MP_CCP_G_10_MIO:1;
      unsigned int MP_CCP_G_5_MIO:1;
      unsigned int MP_CCP_G_2_MIO:1;
      unsigned int MP_CCP_G_1_MIO:1;
      unsigned int MP_CCP_G_500000:1;
      unsigned int MP_CCP_G_200000:1;
      unsigned int MP_CCP_G_100000:1;
      unsigned int MP_CCP_G_50000:1;
      unsigned int MP_CCP_G_20000:1;
      unsigned int MP_CCP_G_10000:1;
      unsigned int MP_CCP_G_5000:1;
      unsigned int MP_CCP_L_5000:1;
      unsigned int MP_CCP_CROWD:1;
      unsigned int dummy13:1;
      unsigned int dummy14:1;
      unsigned int dummy15:1;
      unsigned int dummy16:1;
      unsigned int dummy17:1;
      unsigned int dummy18:1;
      unsigned int dummy19:1;
      unsigned int dummy20:1;
      unsigned int dummy21:1;
      unsigned int dummy22:1;
      unsigned int dummy23:1;
      unsigned int dummy24:1;
      unsigned int dummy25:1;
      unsigned int dummy26:1;
      unsigned int dummy27:1;
      unsigned int dummy28:1;
      unsigned int dummy29:1;
      unsigned int dummy30:1;
      unsigned int dummy31:1;
   };
   union {
      tU32 u32Value;
      rBitValues bits;
   };

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual tBool operator==(const fi_tcl_b32_CityCenters& rfoCmp) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   virtual tS32 s32GetTypeId() const { return typesfi_tclToken::EN_B32_CITYCENTERS;}
   virtual tVoid vTakeVisitor(fi_tclVisitorBase& rfoVisitor);
};

class fi_tcl_b8_DirInfoStatus : public fi_tclVisitableTypeBase
{
public:
   fi_tcl_b8_DirInfoStatus():u8Value(0) {}

   enum {
      FI_C_U8_BIT_MP_NORTH_DIR = 0x1UL,
      FI_C_U8_BIT_MP_DEST_DIR = 0x2UL
   };
   tBool bMP_NORTH_DIR() const {return (u8Value & FI_C_U8_BIT_MP_NORTH_DIR) != 0; }
   tVoid vSetMP_NORTH_DIR(tBool bSetBit) { u8Value = (bSetBit)?(u8Value | FI_C_U8_BIT_MP_NORTH_DIR):(u8Value & ~FI_C_U8_BIT_MP_NORTH_DIR); }
   tBool bMP_DEST_DIR() const {return (u8Value & FI_C_U8_BIT_MP_DEST_DIR) != 0; }
   tVoid vSetMP_DEST_DIR(tBool bSetBit) { u8Value = (bSetBit)?(u8Value | FI_C_U8_BIT_MP_DEST_DIR):(u8Value & ~FI_C_U8_BIT_MP_DEST_DIR); }
   struct rBitValues {
      unsigned int MP_NORTH_DIR:1;
      unsigned int MP_DEST_DIR:1;
      unsigned int dummy2:1;
      unsigned int dummy3:1;
      unsigned int dummy4:1;
      unsigned int dummy5:1;
      unsigned int dummy6:1;
      unsigned int dummy7:1;
   };
   union {
      tU8 u8Value;
      rBitValues bits;
   };

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual tBool operator==(const fi_tcl_b8_DirInfoStatus& rfoCmp) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   virtual tS32 s32GetTypeId() const { return typesfi_tclToken::EN_B8_DIRINFOSTATUS;}
   virtual tVoid vTakeVisitor(fi_tclVisitorBase& rfoVisitor);
};

class fi_tcl_e8_FilterAcceptance : public fi_tclVisitableTypeBase
{
public:
   fi_tcl_e8_FilterAcceptance():enType(FI_EN_MP_LABEL_ACCEPTED) {}

   enum tenType {
      FI_EN_MP_LABEL_ACCEPTED = 0UL,
      FI_EN_MP_LABEL_NOTALL_ACCEPTED = 1UL
   };
   tenType enType;

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual tBool operator==(const fi_tcl_e8_FilterAcceptance& rfoCmp) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   virtual tS32 s32GetTypeId() const { return typesfi_tclToken::EN_E8_FILTERACCEPTANCE;}
   virtual tVoid vTakeVisitor(fi_tclVisitorBase& rfoVisitor);
};

class fi_tcl_e8_DrawMode : public fi_tclVisitableTypeBase
{
public:
   fi_tcl_e8_DrawMode():enType(FI_EN_MP_DM_SINGLE) {}

   enum tenType {
      FI_EN_MP_DM_SINGLE = 1UL,
      FI_EN_MP_DM_SINGLE_UPDATE = 2UL,
      FI_EN_MP_DM_CONTINUOUS = 3UL,
      FI_EN_MP_DM_TILE = 4UL,
      FI_EN_MP_DM_FAST_SCROLL = 5UL
   };
   tenType enType;

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual tBool operator==(const fi_tcl_e8_DrawMode& rfoCmp) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   virtual tS32 s32GetTypeId() const { return typesfi_tclToken::EN_E8_DRAWMODE;}
   virtual tVoid vTakeVisitor(fi_tclVisitorBase& rfoVisitor);
};

class fi_tcl_e8_MapState : public fi_tclVisitableTypeBase
{
public:
   fi_tcl_e8_MapState():enType(FI_EN_MP_STATE_OFF) {}

   enum tenType {
      FI_EN_MP_STATE_OFF = 1UL,
      FI_EN_MP_STATE_ON = 2UL,
      FI_EN_MP_STATE_CONTINUE = 3UL
   };
   tenType enType;

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual tBool operator==(const fi_tcl_e8_MapState& rfoCmp) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   virtual tS32 s32GetTypeId() const { return typesfi_tclToken::EN_E8_MAPSTATE;}
   virtual tVoid vTakeVisitor(fi_tclVisitorBase& rfoVisitor);
};

class fi_tcl_e8_MapMode : public fi_tclVisitableTypeBase
{
public:
   fi_tcl_e8_MapMode():enType(FI_EN_MP_MM_POS) {}

   enum tenType {
      FI_EN_MP_MM_POS = 1UL,
      FI_EN_MP_MM_DEST = 2UL,
      FI_EN_MP_MM_OVERVIEW = 3UL,
      FI_EN_MP_MM_CURSOR = 4UL,
      FI_EN_MP_MM_INDEX = 5UL,
      FI_EN_MP_MM_DECISIONPNT = 6UL,
      FI_EN_MP_MM_INTERSECTION = 7UL
   };
   tenType enType;

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual tBool operator==(const fi_tcl_e8_MapMode& rfoCmp) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   virtual tS32 s32GetTypeId() const { return typesfi_tclToken::EN_E8_MAPMODE;}
   virtual tVoid vTakeVisitor(fi_tclVisitorBase& rfoVisitor);
};

class fi_tcl_e8_MapScale : public fi_tclVisitableTypeBase
{
public:
   fi_tcl_e8_MapScale():enType(FI_EN_MP_SCALE_005) {}

   enum tenType {
      FI_EN_MP_SCALE_005 = 0UL,
      FI_EN_MP_SCALE_01 = 1UL,
      FI_EN_MP_SCALE_02 = 2UL,
      FI_EN_MP_SCALE_05 = 3UL,
      FI_EN_MP_SCALE_1 = 4UL,
      FI_EN_MP_SCALE_2 = 5UL,
      FI_EN_MP_SCALE_5 = 6UL,
      FI_EN_MP_SCALE_10 = 7UL,
      FI_EN_MP_SCALE_20 = 8UL,
      FI_EN_MP_SCALE_50 = 9UL,
      FI_EN_MP_SCALE_100 = 10UL,
      FI_EN_MP_SCALE_200 = 11UL,
      FI_EN_MP_SCALE_500 = 12UL,
      FI_EN_MP_AUTOSCALE = 13UL,
      FI_EN_MP_ZOOMLEVEL_1 = 16UL,
      FI_EN_MP_ZOOMLEVEL_2 = 17UL,
      FI_EN_MP_ZOOMLEVEL_3 = 18UL,
      FI_EN_MP_ZOOMLEVEL_4 = 19UL,
      FI_EN_MP_ZOOMLEVEL_5 = 20UL,
      FI_EN_MP_ZOOMLEVEL_6 = 21UL,
      FI_EN_MP_ZOOMLEVEL_7 = 22UL,
      FI_EN_MP_ZOOMLEVEL_8 = 23UL,
      FI_EN_MP_ZOOMLEVEL_9 = 24UL,
      FI_EN_MP_ZOOMLEVEL_10 = 25UL,
      FI_EN_MP_ZOOMLEVEL_11 = 26UL,
      FI_EN_MP_ZOOMLEVEL_12 = 27UL,
      FI_EN_MP_ZOOMLEVEL_13 = 28UL
   };
   tenType enType;

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual tBool operator==(const fi_tcl_e8_MapScale& rfoCmp) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   virtual tS32 s32GetTypeId() const { return typesfi_tclToken::EN_E8_MAPSCALE;}
   virtual tVoid vTakeVisitor(fi_tclVisitorBase& rfoVisitor);
};

class fi_tcl_e8_MapAngle : public fi_tclVisitableTypeBase
{
public:
   fi_tcl_e8_MapAngle():enType(FI_EN_MP_DIR_NUP) {}

   enum tenType {
      FI_EN_MP_DIR_NUP = 1UL,
      FI_EN_MP_DIR_HEADUP = 2UL,
      FI_EN_MP_DIR_DESTUP = 3UL,
      FI_EN_MP_DIR_DECISIONPNTUP = 4UL,
      FI_EN_MP_DIR_INTERSECTIONUP = 5UL
   };
   tenType enType;

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual tBool operator==(const fi_tcl_e8_MapAngle& rfoCmp) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   virtual tS32 s32GetTypeId() const { return typesfi_tclToken::EN_E8_MAPANGLE;}
   virtual tVoid vTakeVisitor(fi_tclVisitorBase& rfoVisitor);
};

class fi_tcl_MapTransMatrix : public fi_tclVisitableTypeBase
{
public:
   fi_tcl_MapTransMatrix():m11(0),m12(0),m21(0),m22(0) {}
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   fi_tcl_MapTransMatrix& operator=(const fi_tcl_MapTransMatrix& coRef);
   fi_tcl_MapTransMatrix(const fi_tcl_MapTransMatrix& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
   tS32 m11;
   tS32 m12;
   tS32 m21;
   tS32 m22;

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual tBool operator==(const fi_tcl_MapTransMatrix& rfoCmp) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   virtual tS32 s32GetTypeId() const { return typesfi_tclToken::EN_MAPTRANSMATRIX;}
   virtual tVoid vTakeVisitor(fi_tclVisitorBase& rfoVisitor);
};

class fi_tcl_e8_BaudRate : public fi_tclVisitableTypeBase
{
public:
   fi_tcl_e8_BaudRate():enType(FI_EN_MP_115_2KBAUD) {}

   enum tenType {
      FI_EN_MP_115_2KBAUD = 1UL
   };
   tenType enType;

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual tBool operator==(const fi_tcl_e8_BaudRate& rfoCmp) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   virtual tS32 s32GetTypeId() const { return typesfi_tclToken::EN_E8_BAUDRATE;}
   virtual tVoid vTakeVisitor(fi_tclVisitorBase& rfoVisitor);
};

class fi_tcl_e16_IdxType : public fi_tclVisitableTypeBase
{
public:
   fi_tcl_e16_IdxType():enType(FI_EN_MP_IDX_INIT) {}

   enum tenType {
      FI_EN_MP_IDX_INIT = 0UL,
      FI_EN_MP_IDX_PARENT = 254UL,
      FI_EN_MP_IDX_LIST = 252UL,
      FI_EN_MP_IDX_BRANCH = 251UL,
      FI_EN_MP_IDX_NOT_USED = 249UL,
      FI_EN_MP_IDX_MAIN_TOWN = 240UL,
      FI_EN_MP_IDX_DISTRICT = 241UL,
      FI_EN_MP_IDX_ADMN_DISTRICT = 242UL,
      FI_EN_MP_IDX_CITY_AREA = 245UL,
      FI_EN_MP_IDX_DEST_AREA = 246UL,
      FI_EN_MP_IDX_POS_AREA = 247UL,
      FI_EN_MP_IDX_NAME_SIGNPOST = 224UL,
      FI_EN_MP_IDX_NAME_EXIT_NR = 225UL,
      FI_EN_MP_IDX_ALL_POI = 226UL,
      FI_EN_MP_IDX_XSTR = 1UL,
      FI_EN_MP_IDX_ADR = 2UL,
      FI_EN_MP_IDX_STREET = 3UL,
      FI_EN_MP_IDX_OFFICIAL = 4UL,
      FI_EN_MP_IDX_CITY = 5UL,
      FI_EN_MP_IDX_LSIG = 6UL,
      FI_EN_MP_IDX_AIRPORT = 7UL,
      FI_EN_MP_IDX_LLMK = 8UL,
      FI_EN_MP_IDX_GLMK = 9UL,
      FI_EN_MP_IDX_GSIG = 10UL,
      FI_EN_MP_IDX_PARK = 11UL,
      FI_EN_MP_IDX_STATE = 12UL,
      FI_EN_MP_IDX_BRDX = 13UL,
      FI_EN_MP_IDX_RAIL = 14UL,
      FI_EN_MP_IDX_CENTER = 15UL,
      FI_EN_MP_IDX_EXIT = 16UL,
      FI_EN_MP_IDX_BRCH = 17UL,
      FI_EN_MP_IDX_FACILITY = 18UL,
      FI_EN_MP_IDX_HOTELMOTEL = 19UL,
      FI_EN_MP_IDX_REST = 20UL,
      FI_EN_MP_IDX_FUEL = 22UL,
      FI_EN_MP_IDX_HOSPITAL = 23UL,
      FI_EN_MP_IDX_THEATER = 24UL,
      FI_EN_MP_IDX_CRNT = 25UL,
      FI_EN_MP_IDX_SPORT = 26UL,
      FI_EN_MP_IDX_EXHIBITION = 27UL,
      FI_EN_MP_IDX_POST = 28UL,
      FI_EN_MP_IDX_POLICE = 29UL,
      FI_EN_MP_IDX_FERRY = 30UL,
      FI_EN_MP_IDX_SHOP_CNTR = 31UL,
      FI_EN_MP_IDX_ABCO = 76UL,
      FI_EN_MP_IDX_MBENZ = 21UL,
      FI_EN_MP_IDX_BOSCH = 100UL,
      FI_EN_MP_IDX_FORD = 101UL,
      FI_EN_MP_IDX_AUDI = 102UL,
      FI_EN_MP_IDX_VW = 103UL,
      FI_EN_MP_IDX_PORSCHE = 104UL,
      FI_EN_MP_IDX_HONDA = 105UL,
      FI_EN_MP_IDX_NISSAN = 106UL,
      FI_EN_MP_IDX_INDEPENDENT = 107UL,
      FI_EN_MP_IDX_BMW = 108UL,
      FI_EN_MP_IDX_OPEL = 109UL,
      FI_EN_MP_IDX_CHRYSLER = 110UL,
      FI_EN_MP_IDX_PEUGEOT = 111UL,
      FI_EN_MP_IDX_RENAULT = 112UL,
      FI_EN_MP_IDX_CITROEN = 113UL,
      FI_EN_MP_IDX_VOLVO = 114UL,
      FI_EN_MP_IDX_SAAB = 115UL,
      FI_EN_MP_IDX_FIAT = 116UL,
      FI_EN_MP_IDX_TOYOTA = 117UL,
      FI_EN_MP_IDX_MITSUBISHI = 118UL,
      FI_EN_MP_IDX_MAZDA = 119UL,
      FI_EN_MP_IDX_SEAT = 120UL,
      FI_EN_MP_IDX_LANCIA = 121UL,
      FI_EN_MP_IDX_ALFA = 122UL,
      FI_EN_MP_IDX_SKODA = 123UL,
      FI_EN_MP_IDX_MASERATI = 124UL,
      FI_EN_MP_IDX_FERRARI = 125UL,
      FI_EN_MP_IDX_SMART = 126UL,
      FI_EN_MP_IDX_ROVER = 127UL,
      FI_EN_MP_IDX_LANDROVER = 128UL,
      FI_EN_MP_IDX_ACURA = 129UL,
      FI_EN_MP_IDX_ASTON = 130UL,
      FI_EN_MP_IDX_BENTLEY = 131UL,
      FI_EN_MP_IDX_BUICK = 132UL,
      FI_EN_MP_IDX_CADILLAC = 133UL,
      FI_EN_MP_IDX_CHEVROLET = 134UL,
      FI_EN_MP_IDX_DAEWOO = 135UL,
      FI_EN_MP_IDX_DAIHATSU = 136UL,
      FI_EN_MP_IDX_DODGE = 137UL,
      FI_EN_MP_IDX_GMC = 138UL,
      FI_EN_MP_IDX_GMH = 139UL,
      FI_EN_MP_IDX_HYUNDAI = 140UL,
      FI_EN_MP_IDX_ISUZU = 141UL,
      FI_EN_MP_IDX_JAGUAR = 142UL,
      FI_EN_MP_IDX_JEEP = 143UL,
      FI_EN_MP_IDX_KIA = 144UL,
      FI_EN_MP_IDX_LADA = 145UL,
      FI_EN_MP_IDX_LEXUS = 146UL,
      FI_EN_MP_IDX_LINCOLN = 147UL,
      FI_EN_MP_IDX_MG = 148UL,
      FI_EN_MP_IDX_MINI = 149UL,
      FI_EN_MP_IDX_OLDSMOBILE = 150UL,
      FI_EN_MP_IDX_PONTIAC = 151UL,
      FI_EN_MP_IDX_ROLLSROYCE = 152UL,
      FI_EN_MP_IDX_SATURN = 153UL,
      FI_EN_MP_IDX_SUBARU = 154UL,
      FI_EN_MP_IDX_SUZUKI = 155UL
   };
   tenType enType;

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual tBool operator==(const fi_tcl_e16_IdxType& rfoCmp) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   virtual tS32 s32GetTypeId() const { return typesfi_tclToken::EN_E16_IDXTYPE;}
   virtual tVoid vTakeVisitor(fi_tclVisitorBase& rfoVisitor);
};

class fi_tcl_PositionScreen : public fi_tclVisitableTypeBase
{
public:
   fi_tcl_PositionScreen():XPos(),YPos() {}
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   fi_tcl_PositionScreen& operator=(const fi_tcl_PositionScreen& coRef);
   fi_tcl_PositionScreen(const fi_tcl_PositionScreen& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
   fi_tcl_s16_XPosScreen XPos;
   fi_tcl_s16_YPosScreen YPos;

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual tBool operator==(const fi_tcl_PositionScreen& rfoCmp) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   virtual tS32 s32GetTypeId() const { return typesfi_tclToken::EN_POSITIONSCREEN;}
   virtual tVoid vTakeVisitor(fi_tclVisitorBase& rfoVisitor);
};

class fi_tcl_IndexInfo : public fi_tclVisitableTypeBase
{
public:
   fi_tcl_IndexInfo():IdxType(),IdxString() {}
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   fi_tcl_IndexInfo& operator=(const fi_tcl_IndexInfo& coRef);
   fi_tcl_IndexInfo(const fi_tcl_IndexInfo& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
   fi_tcl_e16_IdxType IdxType;
   fi_tclString IdxString;

   virtual tVoid vDestroy();
   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual tBool operator==(const fi_tcl_IndexInfo& rfoCmp) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   virtual tS32 s32GetTypeId() const { return typesfi_tclToken::EN_INDEXINFO;}
   virtual tVoid vTakeVisitor(fi_tclVisitorBase& rfoVisitor);
};

class fi_tcl_b8_DrawOptions : public fi_tclVisitableTypeBase
{
public:
   fi_tcl_b8_DrawOptions():u8Value(0) {}

   enum {
      FI_C_U8_BIT_MP_ENABLE_DCM = 0x1UL,
      FI_C_U8_BIT_MP_ENABLE_3D_LANDMARKS = 0x2UL,
      FI_C_U8_BIT_MP_ENABLE_USED_TRACK = 0x4UL,
      FI_C_U8_BIT_MP_ENABLE_DRIVING_PATH = 0x8UL,
      FI_C_U8_BIT_MP_ENABLE_3D_VIEW = 0x10UL,
      FI_C_U8_BIT_MP_ENABLE_SMOOTH_ZOOM = 0x20UL,
      FI_C_U8_BIT_MP_ENABLE_ONEWAY_MARKS = 0x40UL
   };
   tBool bMP_ENABLE_DCM() const {return (u8Value & FI_C_U8_BIT_MP_ENABLE_DCM) != 0; }
   tVoid vSetMP_ENABLE_DCM(tBool bSetBit) { u8Value = (bSetBit)?(u8Value | FI_C_U8_BIT_MP_ENABLE_DCM):(u8Value & ~FI_C_U8_BIT_MP_ENABLE_DCM); }
   tBool bMP_ENABLE_3D_LANDMARKS() const {return (u8Value & FI_C_U8_BIT_MP_ENABLE_3D_LANDMARKS) != 0; }
   tVoid vSetMP_ENABLE_3D_LANDMARKS(tBool bSetBit) { u8Value = (bSetBit)?(u8Value | FI_C_U8_BIT_MP_ENABLE_3D_LANDMARKS):(u8Value & ~FI_C_U8_BIT_MP_ENABLE_3D_LANDMARKS); }
   tBool bMP_ENABLE_USED_TRACK() const {return (u8Value & FI_C_U8_BIT_MP_ENABLE_USED_TRACK) != 0; }
   tVoid vSetMP_ENABLE_USED_TRACK(tBool bSetBit) { u8Value = (bSetBit)?(u8Value | FI_C_U8_BIT_MP_ENABLE_USED_TRACK):(u8Value & ~FI_C_U8_BIT_MP_ENABLE_USED_TRACK); }
   tBool bMP_ENABLE_DRIVING_PATH() const {return (u8Value & FI_C_U8_BIT_MP_ENABLE_DRIVING_PATH) != 0; }
   tVoid vSetMP_ENABLE_DRIVING_PATH(tBool bSetBit) { u8Value = (bSetBit)?(u8Value | FI_C_U8_BIT_MP_ENABLE_DRIVING_PATH):(u8Value & ~FI_C_U8_BIT_MP_ENABLE_DRIVING_PATH); }
   tBool bMP_ENABLE_3D_VIEW() const {return (u8Value & FI_C_U8_BIT_MP_ENABLE_3D_VIEW) != 0; }
   tVoid vSetMP_ENABLE_3D_VIEW(tBool bSetBit) { u8Value = (bSetBit)?(u8Value | FI_C_U8_BIT_MP_ENABLE_3D_VIEW):(u8Value & ~FI_C_U8_BIT_MP_ENABLE_3D_VIEW); }
   tBool bMP_ENABLE_SMOOTH_ZOOM() const {return (u8Value & FI_C_U8_BIT_MP_ENABLE_SMOOTH_ZOOM) != 0; }
   tVoid vSetMP_ENABLE_SMOOTH_ZOOM(tBool bSetBit) { u8Value = (bSetBit)?(u8Value | FI_C_U8_BIT_MP_ENABLE_SMOOTH_ZOOM):(u8Value & ~FI_C_U8_BIT_MP_ENABLE_SMOOTH_ZOOM); }
   tBool bMP_ENABLE_ONEWAY_MARKS() const {return (u8Value & FI_C_U8_BIT_MP_ENABLE_ONEWAY_MARKS) != 0; }
   tVoid vSetMP_ENABLE_ONEWAY_MARKS(tBool bSetBit) { u8Value = (bSetBit)?(u8Value | FI_C_U8_BIT_MP_ENABLE_ONEWAY_MARKS):(u8Value & ~FI_C_U8_BIT_MP_ENABLE_ONEWAY_MARKS); }
   struct rBitValues {
      unsigned int MP_ENABLE_DCM:1;
      unsigned int MP_ENABLE_3D_LANDMARKS:1;
      unsigned int MP_ENABLE_USED_TRACK:1;
      unsigned int MP_ENABLE_DRIVING_PATH:1;
      unsigned int MP_ENABLE_3D_VIEW:1;
      unsigned int MP_ENABLE_SMOOTH_ZOOM:1;
      unsigned int MP_ENABLE_ONEWAY_MARKS:1;
      unsigned int dummy7:1;
   };
   union {
      tU8 u8Value;
      rBitValues bits;
   };

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual tBool operator==(const fi_tcl_b8_DrawOptions& rfoCmp) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   virtual tS32 s32GetTypeId() const { return typesfi_tclToken::EN_B8_DRAWOPTIONS;}
   virtual tVoid vTakeVisitor(fi_tclVisitorBase& rfoVisitor);
};

class fi_tcl_RouteDescriptor : public fi_tclVisitableTypeBase
{
public:
   fi_tcl_RouteDescriptor():TripHandle(),RouteHandle() {}
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   fi_tcl_RouteDescriptor& operator=(const fi_tcl_RouteDescriptor& coRef);
   fi_tcl_RouteDescriptor(const fi_tcl_RouteDescriptor& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
   fi_tcl_u16_TripHandle TripHandle;
   fi_tcl_u16_RouteHandle RouteHandle;

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual tBool operator==(const fi_tcl_RouteDescriptor& rfoCmp) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   virtual tS32 s32GetTypeId() const { return typesfi_tclToken::EN_ROUTEDESCRIPTOR;}
   virtual tVoid vTakeVisitor(fi_tclVisitorBase& rfoVisitor);
};

class fi_tcl_e8_RouteDisplayType : public fi_tclVisitableTypeBase
{
public:
   fi_tcl_e8_RouteDisplayType():enType(FI_EN_RDT_CURRENT_SEGMENT) {}

   enum tenType {
      FI_EN_RDT_CURRENT_SEGMENT = 0UL,
      FI_EN_RDT_COMPLETE = 1UL
   };
   tenType enType;

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual tBool operator==(const fi_tcl_e8_RouteDisplayType& rfoCmp) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   virtual tS32 s32GetTypeId() const { return typesfi_tclToken::EN_E8_ROUTEDISPLAYTYPE;}
   virtual tVoid vTakeVisitor(fi_tclVisitorBase& rfoVisitor);
};

class fi_tcl_e16_USMarcLanguageCode : public fi_tclVisitableTypeBase
{
public:
   fi_tcl_e16_USMarcLanguageCode():enType(FI_EN_UND) {}

   enum tenType {
      FI_EN_UND = 0UL,
      FI_EN_ALB = 1410UL,
      FI_EN_ARA = 1601UL,
      FI_EN_BAQ = 2097UL,
      FI_EN_BAT = 2100UL,
      FI_EN_BEL = 2220UL,
      FI_EN_BRE = 2629UL,
      FI_EN_BUL = 2732UL,
      FI_EN_CAT = 3124UL,
      FI_EN_CEL = 3244UL,
      FI_EN_CHI = 3337UL,
      FI_EN_CHL = 3340UL,
      FI_EN_CNE = 3525UL,
      FI_EN_CYT = 3892UL,
      FI_EN_CZE = 3909UL,
      FI_EN_DAN = 4142UL,
      FI_EN_DUT = 4788UL,
      FI_EN_ENG = 5575UL,
      FI_EN_EST = 5748UL,
      FI_EN_FAR = 6194UL,
      FI_EN_FIN = 6446UL,
      FI_EN_FRE = 6725UL,
      FI_EN_FRY = 6745UL,
      FI_EN_GAE = 7205UL,
      FI_EN_GEM = 7341UL,
      FI_EN_GER = 7346UL,
      FI_EN_GLE = 7557UL,
      FI_EN_GLG = 7559UL,
      FI_EN_GRE = 7749UL,
      FI_EN_GRL = 7756UL,
      FI_EN_HIN = 8494UL,
      FI_EN_HUN = 8878UL,
      FI_EN_ICE = 9317UL,
      FI_EN_IND = 9668UL,
      FI_EN_ITA = 9857UL,
      FI_EN_KOR = 11762UL,
      FI_EN_LAN = 12334UL,
      FI_EN_LAP = 12336UL,
      FI_EN_LAT = 12340UL,
      FI_EN_LAV = 12342UL,
      FI_EN_LIT = 12596UL,
      FI_EN_LTZ = 12954UL,
      FI_EN_MAC = 13347UL,
      FI_EN_MAP = 13360UL,
      FI_EN_MAY = 13369UL,
      FI_EN_MLT = 13716UL,
      FI_EN_MOL = 13804UL,
      FI_EN_NOR = 14834UL,
      FI_EN_PAA = 16417UL,
      FI_EN_POL = 16876UL,
      FI_EN_POR = 16882UL,
      FI_EN_ROA = 18913UL,
      FI_EN_ROH = 18920UL,
      FI_EN_RUM = 19117UL,
      FI_EN_RUS = 19123UL,
      FI_EN_SCC = 19555UL,
      FI_EN_SCO = 19567UL,
      FI_EN_SCR = 19570UL,
      FI_EN_SLA = 19841UL,
      FI_EN_SLO = 19855UL,
      FI_EN_SLV = 19862UL,
      FI_EN_SPA = 19969UL,
      FI_EN_SWE = 20197UL,
      FI_EN_THA = 20737UL,
      FI_EN_TLE = 20869UL,
      FI_EN_TUR = 21170UL,
      FI_EN_UKR = 21874UL,
      FI_EN_VAL = 22572UL,
      FI_EN_WEL = 23724UL,
      FI_EN_WEN = 23726UL
   };
   tenType enType;

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual tBool operator==(const fi_tcl_e16_USMarcLanguageCode& rfoCmp) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   virtual tS32 s32GetTypeId() const { return typesfi_tclToken::EN_E16_USMARCLANGUAGECODE;}
   virtual tVoid vTakeVisitor(fi_tclVisitorBase& rfoVisitor);
};

class fi_tcl_u32CodePage : public fi_tclVisitableTypeBase
{
public:
   fi_tcl_u32CodePage(tU32 _u32Value = 0):u32Value(_u32Value) {} 

   tU32 u32Value;

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual tBool operator==(const fi_tcl_u32CodePage& rfoCmp) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   virtual tS32 s32GetTypeId() const { return typesfi_tclToken::EN_U32CODEPAGE;}
   virtual tVoid vTakeVisitor(fi_tclVisitorBase& rfoVisitor);
};

class fi_tcl_e8_LanguageDefaultFlag : public fi_tclVisitableTypeBase
{
public:
   fi_tcl_e8_LanguageDefaultFlag():enType(FI_EN_ML_DEF_DONT_CARE) {}

   enum tenType {
      FI_EN_ML_DEF_DONT_CARE = 0UL,
      FI_EN_ML_DEF_INCLUDE = 1UL,
      FI_EN_ML_DEF_EXCLUDE = 2UL
   };
   tenType enType;

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual tBool operator==(const fi_tcl_e8_LanguageDefaultFlag& rfoCmp) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   virtual tS32 s32GetTypeId() const { return typesfi_tclToken::EN_E8_LANGUAGEDEFAULTFLAG;}
   virtual tVoid vTakeVisitor(fi_tclVisitorBase& rfoVisitor);
};

class fi_tcl_LanguageFilter : public fi_tclVisitableTypeBase
{
public:
   fi_tcl_LanguageFilter():DefaultFlag(),Language() {}
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   fi_tcl_LanguageFilter& operator=(const fi_tcl_LanguageFilter& coRef);
   fi_tcl_LanguageFilter(const fi_tcl_LanguageFilter& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
   fi_tcl_e8_LanguageDefaultFlag DefaultFlag;
   fi_tcl_e16_USMarcLanguageCode Language;
   std::vector<fi_tcl_u32CodePage, std::allocator<fi_tcl_u32CodePage> > CodePageList;

   virtual tVoid vDestroy();
   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual tBool operator==(const fi_tcl_LanguageFilter& rfoCmp) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   virtual tS32 s32GetTypeId() const { return typesfi_tclToken::EN_LANGUAGEFILTER;}
   virtual tVoid vTakeVisitor(fi_tclVisitorBase& rfoVisitor);
};

class fi_tcl_ZoomLevelConfig : public fi_tclVisitableTypeBase
{
public:
   fi_tcl_ZoomLevelConfig():SourceScale(),ScaleBarSize(0) {}
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   fi_tcl_ZoomLevelConfig& operator=(const fi_tcl_ZoomLevelConfig& coRef);
   fi_tcl_ZoomLevelConfig(const fi_tcl_ZoomLevelConfig& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
   fi_tcl_e8_MapScale SourceScale;
   tU8 ScaleBarSize;

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual tBool operator==(const fi_tcl_ZoomLevelConfig& rfoCmp) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   virtual tS32 s32GetTypeId() const { return typesfi_tclToken::EN_ZOOMLEVELCONFIG;}
   virtual tVoid vTakeVisitor(fi_tclVisitorBase& rfoVisitor);
};

class fi_tcl_DestinationFlag : public fi_tclVisitableTypeBase
{
public:
   fi_tcl_DestinationFlag():DestPosition(),DestinationType(0) {}
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   fi_tcl_DestinationFlag& operator=(const fi_tcl_DestinationFlag& coRef);
   fi_tcl_DestinationFlag(const fi_tcl_DestinationFlag& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
   fi_tcl_PositionWGS84 DestPosition;
   tU8 DestinationType;

   virtual tVoid vDestroy();
   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual tBool operator==(const fi_tcl_DestinationFlag& rfoCmp) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   virtual tS32 s32GetTypeId() const { return typesfi_tclToken::EN_DESTINATIONFLAG;}
   virtual tVoid vTakeVisitor(fi_tclVisitorBase& rfoVisitor);
};

class fi_tcl_b16_TheaterDescriptionRequest : public fi_tclVisitableTypeBase
{
public:
   fi_tcl_b16_TheaterDescriptionRequest():u16Value(0) {}

   enum {
      FI_C_U16_BIT_STATE = 0x1UL,
      FI_C_U16_BIT_NAME = 0x2UL,
      FI_C_U16_BIT_ADDRESS = 0x4UL,
      FI_C_U16_BIT_CITY = 0x8UL,
      FI_C_U16_BIT_ZIP = 0x10UL,
      FI_C_U16_BIT_PHONE = 0x20UL,
      FI_C_U16_BIT_POSITION = 0x40UL,
      FI_C_U16_BIT_LISTOFAMENITIES = 0x80UL
   };
   tBool bState() const {return (u16Value & FI_C_U16_BIT_STATE) != 0; }
   tVoid vSetState(tBool bSetBit) { u16Value = (bSetBit)?(u16Value | FI_C_U16_BIT_STATE):(u16Value & ~FI_C_U16_BIT_STATE); }
   tBool bName() const {return (u16Value & FI_C_U16_BIT_NAME) != 0; }
   tVoid vSetName(tBool bSetBit) { u16Value = (bSetBit)?(u16Value | FI_C_U16_BIT_NAME):(u16Value & ~FI_C_U16_BIT_NAME); }
   tBool bAddress() const {return (u16Value & FI_C_U16_BIT_ADDRESS) != 0; }
   tVoid vSetAddress(tBool bSetBit) { u16Value = (bSetBit)?(u16Value | FI_C_U16_BIT_ADDRESS):(u16Value & ~FI_C_U16_BIT_ADDRESS); }
   tBool bCity() const {return (u16Value & FI_C_U16_BIT_CITY) != 0; }
   tVoid vSetCity(tBool bSetBit) { u16Value = (bSetBit)?(u16Value | FI_C_U16_BIT_CITY):(u16Value & ~FI_C_U16_BIT_CITY); }
   tBool bZip() const {return (u16Value & FI_C_U16_BIT_ZIP) != 0; }
   tVoid vSetZip(tBool bSetBit) { u16Value = (bSetBit)?(u16Value | FI_C_U16_BIT_ZIP):(u16Value & ~FI_C_U16_BIT_ZIP); }
   tBool bPhone() const {return (u16Value & FI_C_U16_BIT_PHONE) != 0; }
   tVoid vSetPhone(tBool bSetBit) { u16Value = (bSetBit)?(u16Value | FI_C_U16_BIT_PHONE):(u16Value & ~FI_C_U16_BIT_PHONE); }
   tBool bPosition() const {return (u16Value & FI_C_U16_BIT_POSITION) != 0; }
   tVoid vSetPosition(tBool bSetBit) { u16Value = (bSetBit)?(u16Value | FI_C_U16_BIT_POSITION):(u16Value & ~FI_C_U16_BIT_POSITION); }
   tBool bListOfAmenities() const {return (u16Value & FI_C_U16_BIT_LISTOFAMENITIES) != 0; }
   tVoid vSetListOfAmenities(tBool bSetBit) { u16Value = (bSetBit)?(u16Value | FI_C_U16_BIT_LISTOFAMENITIES):(u16Value & ~FI_C_U16_BIT_LISTOFAMENITIES); }
   struct rBitValues {
      unsigned int State:1;
      unsigned int Name:1;
      unsigned int Address:1;
      unsigned int City:1;
      unsigned int Zip:1;
      unsigned int Phone:1;
      unsigned int Position:1;
      unsigned int ListOfAmenities:1;
      unsigned int dummy8:1;
      unsigned int dummy9:1;
      unsigned int dummy10:1;
      unsigned int dummy11:1;
      unsigned int dummy12:1;
      unsigned int dummy13:1;
      unsigned int dummy14:1;
      unsigned int dummy15:1;
   };
   union {
      tU16 u16Value;
      rBitValues bits;
   };

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual tBool operator==(const fi_tcl_b16_TheaterDescriptionRequest& rfoCmp) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   virtual tS32 s32GetTypeId() const { return typesfi_tclToken::EN_B16_THEATERDESCRIPTIONREQUEST;}
   virtual tVoid vTakeVisitor(fi_tclVisitorBase& rfoVisitor);
};

class fi_tcl_TheaterInfo : public fi_tclVisitableTypeBase
{
public:
   fi_tcl_TheaterInfo():State(),Name(),Address(),City(),Zip(),Phone(),Position() {}
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   fi_tcl_TheaterInfo& operator=(const fi_tcl_TheaterInfo& coRef);
   fi_tcl_TheaterInfo(const fi_tcl_TheaterInfo& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
   fi_tcl_State State;
   fi_tclString Name;
   fi_tclString Address;
   fi_tclString City;
   fi_tclString Zip;
   fi_tclString Phone;
   fi_tcl_PositionWGS84 Position;
   std::vector<fi_tcl_Amenity, std::allocator<fi_tcl_Amenity> > ListOfAmenities;

   virtual tVoid vDestroy();
   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual tBool operator==(const fi_tcl_TheaterInfo& rfoCmp) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   virtual tS32 s32GetTypeId() const { return typesfi_tclToken::EN_THEATERINFO;}
   virtual tVoid vTakeVisitor(fi_tclVisitorBase& rfoVisitor);
};

class fi_tcl_MovieId : public fi_tclVisitableTypeBase
{
public:
   fi_tcl_MovieId():MovieId(0) {}
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   fi_tcl_MovieId& operator=(const fi_tcl_MovieId& coRef);
   fi_tcl_MovieId(const fi_tcl_MovieId& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
   tU8 MovieId;

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual tBool operator==(const fi_tcl_MovieId& rfoCmp) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   virtual tS32 s32GetTypeId() const { return typesfi_tclToken::EN_MOVIEID;}
   virtual tVoid vTakeVisitor(fi_tclVisitorBase& rfoVisitor);
};

class fi_tcl_Rating : public fi_tclVisitableTypeBase
{
public:
   fi_tcl_Rating():System(),Rating() {}
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   fi_tcl_Rating& operator=(const fi_tcl_Rating& coRef);
   fi_tcl_Rating(const fi_tcl_Rating& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
   fi_tclString System;
   fi_tclString Rating;

   virtual tVoid vDestroy();
   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual tBool operator==(const fi_tcl_Rating& rfoCmp) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   virtual tS32 s32GetTypeId() const { return typesfi_tclToken::EN_RATING;}
   virtual tVoid vTakeVisitor(fi_tclVisitorBase& rfoVisitor);
};

class fi_tcl_RunTime : public fi_tclVisitableTypeBase
{
public:
   fi_tcl_RunTime():RunTime(0) {}
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   fi_tcl_RunTime& operator=(const fi_tcl_RunTime& coRef);
   fi_tcl_RunTime(const fi_tcl_RunTime& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
   tU8 RunTime;

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual tBool operator==(const fi_tcl_RunTime& rfoCmp) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   virtual tS32 s32GetTypeId() const { return typesfi_tclToken::EN_RUNTIME;}
   virtual tVoid vTakeVisitor(fi_tclVisitorBase& rfoVisitor);
};

class fi_tcl_MovieName : public fi_tclVisitableTypeBase
{
public:
   fi_tcl_MovieName():Name() {}
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   fi_tcl_MovieName& operator=(const fi_tcl_MovieName& coRef);
   fi_tcl_MovieName(const fi_tcl_MovieName& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
   fi_tclString Name;

   virtual tVoid vDestroy();
   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual tBool operator==(const fi_tcl_MovieName& rfoCmp) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   virtual tS32 s32GetTypeId() const { return typesfi_tclToken::EN_MOVIENAME;}
   virtual tVoid vTakeVisitor(fi_tclVisitorBase& rfoVisitor);
};

class fi_tcl_MovieDescription : public fi_tclVisitableTypeBase
{
public:
   fi_tcl_MovieDescription():ID(),Name(),RunTime(),SizeOfCompleteActorList(0),Actors(),SizeOfCompleteSynopsis(0),Synopsis() {}
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   fi_tcl_MovieDescription& operator=(const fi_tcl_MovieDescription& coRef);
   fi_tcl_MovieDescription(const fi_tcl_MovieDescription& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
   fi_tcl_MovieId ID;
   fi_tcl_MovieName Name;
   std::vector<fi_tcl_Rating, std::allocator<fi_tcl_Rating> > Rating;
   fi_tcl_RunTime RunTime;
   tU32 SizeOfCompleteActorList;
   fi_tclString Actors;
   tU32 SizeOfCompleteSynopsis;
   fi_tclString Synopsis;

   virtual tVoid vDestroy();
   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual tBool operator==(const fi_tcl_MovieDescription& rfoCmp) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   virtual tS32 s32GetTypeId() const { return typesfi_tclToken::EN_MOVIEDESCRIPTION;}
   virtual tVoid vTakeVisitor(fi_tclVisitorBase& rfoVisitor);
};

class fi_tcl_TheaterId : public fi_tclVisitableTypeBase
{
public:
   fi_tcl_TheaterId():TheaterId(0),State() {}
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   fi_tcl_TheaterId& operator=(const fi_tcl_TheaterId& coRef);
   fi_tcl_TheaterId(const fi_tcl_TheaterId& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
   tU32 TheaterId;
   fi_tcl_State State;

   virtual tVoid vDestroy();
   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual tBool operator==(const fi_tcl_TheaterId& rfoCmp) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   virtual tS32 s32GetTypeId() const { return typesfi_tclToken::EN_THEATERID;}
   virtual tVoid vTakeVisitor(fi_tclVisitorBase& rfoVisitor);
};

class fi_tcl_Showing : public fi_tclVisitableTypeBase
{
public:
   fi_tcl_Showing():Time() {}
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   fi_tcl_Showing& operator=(const fi_tcl_Showing& coRef);
   fi_tcl_Showing(const fi_tcl_Showing& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
   fi_tcl_POSIXTime Time;

   virtual tVoid vDestroy();
   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual tBool operator==(const fi_tcl_Showing& rfoCmp) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   virtual tS32 s32GetTypeId() const { return typesfi_tclToken::EN_SHOWING;}
   virtual tVoid vTakeVisitor(fi_tclVisitorBase& rfoVisitor);
};

class fi_tcl_MovieTimes : public fi_tclVisitableTypeBase
{
public:
   fi_tcl_MovieTimes():MovieId(),Rating() {}
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   fi_tcl_MovieTimes& operator=(const fi_tcl_MovieTimes& coRef);
   fi_tcl_MovieTimes(const fi_tcl_MovieTimes& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
   fi_tcl_MovieId MovieId;
   fi_tclString Rating;
   std::vector<fi_tcl_Showing, std::allocator<fi_tcl_Showing> > Showings;

   virtual tVoid vDestroy();
   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual tBool operator==(const fi_tcl_MovieTimes& rfoCmp) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   virtual tS32 s32GetTypeId() const { return typesfi_tclToken::EN_MOVIETIMES;}
   virtual tVoid vTakeVisitor(fi_tclVisitorBase& rfoVisitor);
};

class fi_tcl_TheaterMovieTimes : public fi_tclVisitableTypeBase
{
public:
   fi_tcl_TheaterMovieTimes():Theater() {}
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   fi_tcl_TheaterMovieTimes& operator=(const fi_tcl_TheaterMovieTimes& coRef);
   fi_tcl_TheaterMovieTimes(const fi_tcl_TheaterMovieTimes& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
   fi_tcl_TheaterId Theater;
   std::vector<fi_tcl_MovieTimes, std::allocator<fi_tcl_MovieTimes> > MovieTimes;

   virtual tVoid vDestroy();
   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual tBool operator==(const fi_tcl_TheaterMovieTimes& rfoCmp) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   virtual tS32 s32GetTypeId() const { return typesfi_tclToken::EN_THEATERMOVIETIMES;}
   virtual tVoid vTakeVisitor(fi_tclVisitorBase& rfoVisitor);
};

class fi_tcl_TheaterMovieTimesForPosition : public fi_tclVisitableTypeBase
{
public:
   fi_tcl_TheaterMovieTimesForPosition():Position() {}
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   fi_tcl_TheaterMovieTimesForPosition& operator=(const fi_tcl_TheaterMovieTimesForPosition& coRef);
   fi_tcl_TheaterMovieTimesForPosition(const fi_tcl_TheaterMovieTimesForPosition& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
   fi_tcl_PositionWGS84 Position;
   std::vector<fi_tcl_TheaterMovieTimes, std::allocator<fi_tcl_TheaterMovieTimes> > TheaterMovieTimes;

   virtual tVoid vDestroy();
   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual tBool operator==(const fi_tcl_TheaterMovieTimesForPosition& rfoCmp) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   virtual tS32 s32GetTypeId() const { return typesfi_tclToken::EN_THEATERMOVIETIMESFORPOSITION;}
   virtual tVoid vTakeVisitor(fi_tclVisitorBase& rfoVisitor);
};

class fi_tcl_e8_DetailGrade : public fi_tclVisitableTypeBase
{
public:
   fi_tcl_e8_DetailGrade():enType(FI_EN_T_NODETAIL) {}

   enum tenType {
      FI_EN_T_NODETAIL = 0UL,
      FI_EN_T_SHORTDETAIL = 1UL,
      FI_EN_T_COMPLETEDETAIL = 2UL
   };
   tenType enType;

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual tBool operator==(const fi_tcl_e8_DetailGrade& rfoCmp) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   virtual tS32 s32GetTypeId() const { return typesfi_tclToken::EN_E8_DETAILGRADE;}
   virtual tVoid vTakeVisitor(fi_tclVisitorBase& rfoVisitor);
};

class fi_tcl_BriefMovieDescription : public fi_tclVisitableTypeBase
{
public:
   fi_tcl_BriefMovieDescription():ID(),Name(),RunTime() {}
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   fi_tcl_BriefMovieDescription& operator=(const fi_tcl_BriefMovieDescription& coRef);
   fi_tcl_BriefMovieDescription(const fi_tcl_BriefMovieDescription& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
   fi_tcl_MovieId ID;
   fi_tcl_MovieName Name;
   fi_tcl_RunTime RunTime;

   virtual tVoid vDestroy();
   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual tBool operator==(const fi_tcl_BriefMovieDescription& rfoCmp) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   virtual tS32 s32GetTypeId() const { return typesfi_tclToken::EN_BRIEFMOVIEDESCRIPTION;}
   virtual tVoid vTakeVisitor(fi_tclVisitorBase& rfoVisitor);
};

class fi_tcl_TheaterDescription : public fi_tclVisitableTypeBase
{
public:
   fi_tcl_TheaterDescription():Theater(),TheaterDescription() {}
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   fi_tcl_TheaterDescription& operator=(const fi_tcl_TheaterDescription& coRef);
   fi_tcl_TheaterDescription(const fi_tcl_TheaterDescription& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
   fi_tcl_TheaterId Theater;
   fi_tcl_TheaterInfo TheaterDescription;

   virtual tVoid vDestroy();
   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual tBool operator==(const fi_tcl_TheaterDescription& rfoCmp) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   virtual tS32 s32GetTypeId() const { return typesfi_tclToken::EN_THEATERDESCRIPTION;}
   virtual tVoid vTakeVisitor(fi_tclVisitorBase& rfoVisitor);
};

class fi_tcl_u16_UserTrafficMessageHandle : public fi_tclVisitableTypeBase
{
public:
   fi_tcl_u16_UserTrafficMessageHandle(tU16 _u16Value = 0):u16Value(_u16Value) {} 

   tU16 u16Value;

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual tBool operator==(const fi_tcl_u16_UserTrafficMessageHandle& rfoCmp) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   virtual tS32 s32GetTypeId() const { return typesfi_tclToken::EN_U16_USERTRAFFICMESSAGEHANDLE;}
   virtual tVoid vTakeVisitor(fi_tclVisitorBase& rfoVisitor);
};

class fi_tcl_UTMHandleContainer : public fi_tclVisitableTypeBase
{
public:
   fi_tcl_UTMHandleContainer():UTMHandle(),OutComingClosingLength(),ErrorCode() {}
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   fi_tcl_UTMHandleContainer& operator=(const fi_tcl_UTMHandleContainer& coRef);
   fi_tcl_UTMHandleContainer(const fi_tcl_UTMHandleContainer& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
   fi_tcl_u16_UserTrafficMessageHandle UTMHandle;
   fi_tcl_s32_Meter OutComingClosingLength;
   fi_tcl_u16_ErrorCode ErrorCode;

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual tBool operator==(const fi_tcl_UTMHandleContainer& rfoCmp) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   virtual tS32 s32GetTypeId() const { return typesfi_tclToken::EN_UTMHANDLECONTAINER;}
   virtual tVoid vTakeVisitor(fi_tclVisitorBase& rfoVisitor);
};

class fi_tcl_e8_PositionCalculationState : public fi_tclVisitableTypeBase
{
public:
   fi_tcl_e8_PositionCalculationState():enType(FI_EN_UNKNOWN) {}

   enum tenType {
      FI_EN_UNKNOWN = 0UL,
      FI_EN_OFFMAP = 1UL,
      FI_EN_OFFROAD = 2UL,
      FI_EN_FREEZE = 3UL,
      FI_EN_ONROAD = 4UL,
      FI_EN_OFFCORRIDOR = 5UL,
      FI_EN_LASTPOSITION = 6UL
   };
   tenType enType;

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual tBool operator==(const fi_tcl_e8_PositionCalculationState& rfoCmp) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   virtual tS32 s32GetTypeId() const { return typesfi_tclToken::EN_E8_POSITIONCALCULATIONSTATE;}
   virtual tVoid vTakeVisitor(fi_tclVisitorBase& rfoVisitor);
};

class fi_tcl_e8_SwitchPositionStatus : public fi_tclVisitableTypeBase
{
public:
   fi_tcl_e8_SwitchPositionStatus():enType(FI_EN_UNKNOWN) {}

   enum tenType {
      FI_EN_UNKNOWN = 0UL,
      FI_EN_NOTACTIVATED = 1UL,
      FI_EN_ACTIVATED = 2UL
   };
   tenType enType;

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual tBool operator==(const fi_tcl_e8_SwitchPositionStatus& rfoCmp) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   virtual tS32 s32GetTypeId() const { return typesfi_tclToken::EN_E8_SWITCHPOSITIONSTATUS;}
   virtual tVoid vTakeVisitor(fi_tclVisitorBase& rfoVisitor);
};

class fi_tcl_e8_LaneStatus : public fi_tclVisitableTypeBase
{
public:
   fi_tcl_e8_LaneStatus():enType(FI_EN_UNKNOWN) {}

   enum tenType {
      FI_EN_UNKNOWN = 0UL,
      FI_EN_FORBIDDEN = 1UL,
      FI_EN_ALLOWED = 2UL,
      FI_EN_RECOMMENDED = 3UL
   };
   tenType enType;

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual tBool operator==(const fi_tcl_e8_LaneStatus& rfoCmp) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   virtual tS32 s32GetTypeId() const { return typesfi_tclToken::EN_E8_LANESTATUS;}
   virtual tVoid vTakeVisitor(fi_tclVisitorBase& rfoVisitor);
};

class fi_tcl_b8_LaneType : public fi_tclVisitableTypeBase
{
public:
   fi_tcl_b8_LaneType():u8Value(0) {}

   enum {
      FI_C_U8_BIT_SPECIAL = 0x1UL,
      FI_C_U8_BIT_EXIT = 0x2UL,
      FI_C_U8_BIT_HOV = 0x4UL
   };
   tBool bSpecial() const {return (u8Value & FI_C_U8_BIT_SPECIAL) != 0; }
   tVoid vSetSpecial(tBool bSetBit) { u8Value = (bSetBit)?(u8Value | FI_C_U8_BIT_SPECIAL):(u8Value & ~FI_C_U8_BIT_SPECIAL); }
   tBool bExit() const {return (u8Value & FI_C_U8_BIT_EXIT) != 0; }
   tVoid vSetExit(tBool bSetBit) { u8Value = (bSetBit)?(u8Value | FI_C_U8_BIT_EXIT):(u8Value & ~FI_C_U8_BIT_EXIT); }
   tBool bHOV() const {return (u8Value & FI_C_U8_BIT_HOV) != 0; }
   tVoid vSetHOV(tBool bSetBit) { u8Value = (bSetBit)?(u8Value | FI_C_U8_BIT_HOV):(u8Value & ~FI_C_U8_BIT_HOV); }
   struct rBitValues {
      unsigned int Special:1;
      unsigned int Exit:1;
      unsigned int HOV:1;
      unsigned int dummy3:1;
      unsigned int dummy4:1;
      unsigned int dummy5:1;
      unsigned int dummy6:1;
      unsigned int dummy7:1;
   };
   union {
      tU8 u8Value;
      rBitValues bits;
   };

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual tBool operator==(const fi_tcl_b8_LaneType& rfoCmp) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   virtual tS32 s32GetTypeId() const { return typesfi_tclToken::EN_B8_LANETYPE;}
   virtual tVoid vTakeVisitor(fi_tclVisitorBase& rfoVisitor);
};

class fi_tcl_b8_LaneChangeRestriction : public fi_tclVisitableTypeBase
{
public:
   fi_tcl_b8_LaneChangeRestriction():u8Value(0) {}

   enum {
      FI_C_U8_BIT_PREVIOUSLANE = 0x1UL,
      FI_C_U8_BIT_NEXTLANE = 0x2UL
   };
   tBool bPreviousLane() const {return (u8Value & FI_C_U8_BIT_PREVIOUSLANE) != 0; }
   tVoid vSetPreviousLane(tBool bSetBit) { u8Value = (bSetBit)?(u8Value | FI_C_U8_BIT_PREVIOUSLANE):(u8Value & ~FI_C_U8_BIT_PREVIOUSLANE); }
   tBool bNextLane() const {return (u8Value & FI_C_U8_BIT_NEXTLANE) != 0; }
   tVoid vSetNextLane(tBool bSetBit) { u8Value = (bSetBit)?(u8Value | FI_C_U8_BIT_NEXTLANE):(u8Value & ~FI_C_U8_BIT_NEXTLANE); }
   struct rBitValues {
      unsigned int PreviousLane:1;
      unsigned int NextLane:1;
      unsigned int dummy2:1;
      unsigned int dummy3:1;
      unsigned int dummy4:1;
      unsigned int dummy5:1;
      unsigned int dummy6:1;
      unsigned int dummy7:1;
   };
   union {
      tU8 u8Value;
      rBitValues bits;
   };

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual tBool operator==(const fi_tcl_b8_LaneChangeRestriction& rfoCmp) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   virtual tS32 s32GetTypeId() const { return typesfi_tclToken::EN_B8_LANECHANGERESTRICTION;}
   virtual tVoid vTakeVisitor(fi_tclVisitorBase& rfoVisitor);
};

class fi_tcl_u8_IndexInLaneInfoSegmentList : public fi_tclVisitableTypeBase
{
public:
   fi_tcl_u8_IndexInLaneInfoSegmentList(tU8 _u8Value = 0):u8Value(_u8Value) {} 

   tU8 u8Value;

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual tBool operator==(const fi_tcl_u8_IndexInLaneInfoSegmentList& rfoCmp) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   virtual tS32 s32GetTypeId() const { return typesfi_tclToken::EN_U8_INDEXINLANEINFOSEGMENTLIST;}
   virtual tVoid vTakeVisitor(fi_tclVisitorBase& rfoVisitor);
};

class fi_tcl_u8_IndexInLaneInfoList : public fi_tclVisitableTypeBase
{
public:
   fi_tcl_u8_IndexInLaneInfoList(tU8 _u8Value = 0):u8Value(_u8Value) {} 

   tU8 u8Value;

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual tBool operator==(const fi_tcl_u8_IndexInLaneInfoList& rfoCmp) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   virtual tS32 s32GetTypeId() const { return typesfi_tclToken::EN_U8_INDEXINLANEINFOLIST;}
   virtual tVoid vTakeVisitor(fi_tclVisitorBase& rfoVisitor);
};

class fi_tcl_u8_DrivingDirection : public fi_tclVisitableTypeBase
{
public:
   fi_tcl_u8_DrivingDirection(tU8 _u8Value = 0):u8Value(_u8Value) {} 

   tU8 u8Value;

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual tBool operator==(const fi_tcl_u8_DrivingDirection& rfoCmp) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   virtual tS32 s32GetTypeId() const { return typesfi_tclToken::EN_U8_DRIVINGDIRECTION;}
   virtual tVoid vTakeVisitor(fi_tclVisitorBase& rfoVisitor);
};

class fi_tcl_LaneDirection : public fi_tclVisitableTypeBase
{
public:
   fi_tcl_LaneDirection():DirectionToFollowingLane(),FollowingLaneStatus(),FollowingLaneType() {}
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   fi_tcl_LaneDirection& operator=(const fi_tcl_LaneDirection& coRef);
   fi_tcl_LaneDirection(const fi_tcl_LaneDirection& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
   fi_tcl_u8_DrivingDirection DirectionToFollowingLane;
   fi_tcl_e8_LaneStatus FollowingLaneStatus;
   fi_tcl_b8_LaneType FollowingLaneType;

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual tBool operator==(const fi_tcl_LaneDirection& rfoCmp) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   virtual tS32 s32GetTypeId() const { return typesfi_tclToken::EN_LANEDIRECTION;}
   virtual tVoid vTakeVisitor(fi_tclVisitorBase& rfoVisitor);
};

class fi_tcl_LaneInfoOneCellReference : public fi_tclVisitableTypeBase
{
public:
   fi_tcl_LaneInfoOneCellReference():OneCell(),SegmentIndex(),LaneIndex() {}
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   fi_tcl_LaneInfoOneCellReference& operator=(const fi_tcl_LaneInfoOneCellReference& coRef);
   fi_tcl_LaneInfoOneCellReference(const fi_tcl_LaneInfoOneCellReference& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
   fi_tcl_NavOneCell OneCell;
   fi_tcl_u8_IndexInLaneInfoSegmentList SegmentIndex;
   fi_tcl_u8_IndexInLaneInfoList LaneIndex;

   virtual tVoid vDestroy();
   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual tBool operator==(const fi_tcl_LaneInfoOneCellReference& rfoCmp) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   virtual tS32 s32GetTypeId() const { return typesfi_tclToken::EN_LANEINFOONECELLREFERENCE;}
   virtual tVoid vTakeVisitor(fi_tclVisitorBase& rfoVisitor);
};

class fi_tcl_LaneInfoOneCellIndexReference : public fi_tclVisitableTypeBase
{
public:
   fi_tcl_LaneInfoOneCellIndexReference():OneCellIndex(),SegmentIndex(),LaneIndex() {}
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   fi_tcl_LaneInfoOneCellIndexReference& operator=(const fi_tcl_LaneInfoOneCellIndexReference& coRef);
   fi_tcl_LaneInfoOneCellIndexReference(const fi_tcl_LaneInfoOneCellIndexReference& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
   fi_tcl_u16_IndexInReferenceList OneCellIndex;
   fi_tcl_u8_IndexInLaneInfoSegmentList SegmentIndex;
   fi_tcl_u8_IndexInLaneInfoList LaneIndex;

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual tBool operator==(const fi_tcl_LaneInfoOneCellIndexReference& rfoCmp) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   virtual tS32 s32GetTypeId() const { return typesfi_tclToken::EN_LANEINFOONECELLINDEXREFERENCE;}
   virtual tVoid vTakeVisitor(fi_tclVisitorBase& rfoVisitor);
};

class fi_tcl_LaneInfoPathSectionIndexReference : public fi_tclVisitableTypeBase
{
public:
   fi_tcl_LaneInfoPathSectionIndexReference():PathSectionIndex(),SegmentIndex(),LaneIndex() {}
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   fi_tcl_LaneInfoPathSectionIndexReference& operator=(const fi_tcl_LaneInfoPathSectionIndexReference& coRef);
   fi_tcl_LaneInfoPathSectionIndexReference(const fi_tcl_LaneInfoPathSectionIndexReference& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
   fi_tcl_u16_IndexInReferenceList PathSectionIndex;
   fi_tcl_u8_IndexInLaneInfoSegmentList SegmentIndex;
   fi_tcl_u8_IndexInLaneInfoList LaneIndex;

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual tBool operator==(const fi_tcl_LaneInfoPathSectionIndexReference& rfoCmp) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   virtual tS32 s32GetTypeId() const { return typesfi_tclToken::EN_LANEINFOPATHSECTIONINDEXREFERENCE;}
   virtual tVoid vTakeVisitor(fi_tclVisitorBase& rfoVisitor);
};

class fi_tcl_LaneInfoElementReference : public fi_tclVisitableTypeBase
{
public:
   fi_tcl_LaneInfoElementReference():ElementId(0),LaneIndex() {}
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   fi_tcl_LaneInfoElementReference& operator=(const fi_tcl_LaneInfoElementReference& coRef);
   fi_tcl_LaneInfoElementReference(const fi_tcl_LaneInfoElementReference& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
   tU16 ElementId;
   fi_tcl_u8_IndexInLaneInfoList LaneIndex;

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual tBool operator==(const fi_tcl_LaneInfoElementReference& rfoCmp) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   virtual tS32 s32GetTypeId() const { return typesfi_tclToken::EN_LANEINFOELEMENTREFERENCE;}
   virtual tVoid vTakeVisitor(fi_tclVisitorBase& rfoVisitor);
};

class fi_tcl_e8_LaneReferenceCategory : public fi_tclVisitableTypeBase
{
public:
   fi_tcl_e8_LaneReferenceCategory():enType(FI_EN_T_RESERVED) {}

   enum tenType {
      FI_EN_T_RESERVED = 0UL,
      FI_EN_T_LANEINFOONECELLREFERENCE = 1UL,
      FI_EN_T_LANEINFOONECELLINDEXREFERENCE = 2UL,
      FI_EN_T_LANEINFOELEMENTREFERENCE = 3UL,
      FI_EN_T_LANEINFOPATHSECTIONINDEXREFERENCE = 4UL
   };
   tenType enType;

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual tBool operator==(const fi_tcl_e8_LaneReferenceCategory& rfoCmp) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   virtual tS32 s32GetTypeId() const { return typesfi_tclToken::EN_E8_LANEREFERENCECATEGORY;}
   virtual tVoid vTakeVisitor(fi_tclVisitorBase& rfoVisitor);
};

class fi_tcl_LaneReference : public fi_tclVisitableTypeBase
{
public:
   fi_tcl_LaneReference():poLaneReferenceCategoryData(0),LaneDirection() {}
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   fi_tcl_LaneReference& operator=(const fi_tcl_LaneReference& coRef);
   fi_tcl_LaneReference(const fi_tcl_LaneReference& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
   fi_tcl_e8_LaneReferenceCategory LaneReferenceCategoryType;
   fi_tclTypeBase* poLaneReferenceCategoryData;
   fi_tcl_LaneDirection LaneDirection;
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   virtual ~fi_tcl_LaneReference();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   virtual tVoid vDestroy();
   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual tBool operator==(const fi_tcl_LaneReference& rfoCmp) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   virtual tS32 s32GetTypeId() const { return typesfi_tclToken::EN_LANEREFERENCE;}
   virtual tVoid vTakeVisitor(fi_tclVisitorBase& rfoVisitor);
};

class fi_tcl_LaneInfo : public fi_tclVisitableTypeBase
{
public:
   fi_tcl_LaneInfo():Status(),Type(),ChangeRestriction() {}
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   fi_tcl_LaneInfo& operator=(const fi_tcl_LaneInfo& coRef);
   fi_tcl_LaneInfo(const fi_tcl_LaneInfo& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
   fi_tcl_e8_LaneStatus Status;
   fi_tcl_b8_LaneType Type;
   fi_tcl_b8_LaneChangeRestriction ChangeRestriction;
   std::vector<fi_tcl_LaneReference, std::allocator<fi_tcl_LaneReference> > FollowingLaneList;

   virtual tVoid vDestroy();
   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual tBool operator==(const fi_tcl_LaneInfo& rfoCmp) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   virtual tS32 s32GetTypeId() const { return typesfi_tclToken::EN_LANEINFO;}
   virtual tVoid vTakeVisitor(fi_tclVisitorBase& rfoVisitor);
};

class fi_tcl_LaneInfoElement : public fi_tclVisitableTypeBase
{
public:
   fi_tcl_LaneInfoElement():ElementId(0),PositionWGS84() {}
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   fi_tcl_LaneInfoElement& operator=(const fi_tcl_LaneInfoElement& coRef);
   fi_tcl_LaneInfoElement(const fi_tcl_LaneInfoElement& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
   tU16 ElementId;
   std::vector<fi_tcl_LaneInfo, std::allocator<fi_tcl_LaneInfo> > LaneInfoList;
   fi_tcl_PositionWGS84 PositionWGS84;

   virtual tVoid vDestroy();
   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual tBool operator==(const fi_tcl_LaneInfoElement& rfoCmp) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   virtual tS32 s32GetTypeId() const { return typesfi_tclToken::EN_LANEINFOELEMENT;}
   virtual tVoid vTakeVisitor(fi_tclVisitorBase& rfoVisitor);
};

class fi_tcl_LaneInfoSegment : public fi_tclVisitableTypeBase
{
public:
   fi_tcl_LaneInfoSegment():Offset() {}
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   fi_tcl_LaneInfoSegment& operator=(const fi_tcl_LaneInfoSegment& coRef);
   fi_tcl_LaneInfoSegment(const fi_tcl_LaneInfoSegment& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
   fi_tcl_s32_EMU Offset;
   std::vector<fi_tcl_LaneInfo, std::allocator<fi_tcl_LaneInfo> > LaneInfoList;

   virtual tVoid vDestroy();
   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual tBool operator==(const fi_tcl_LaneInfoSegment& rfoCmp) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   virtual tS32 s32GetTypeId() const { return typesfi_tclToken::EN_LANEINFOSEGMENT;}
   virtual tVoid vTakeVisitor(fi_tclVisitorBase& rfoVisitor);
};

class fi_tcl_LaneInfoSegmentList : public fi_tclVisitableTypeBase
{
public:
   fi_tcl_LaneInfoSegmentList() {}
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   fi_tcl_LaneInfoSegmentList& operator=(const fi_tcl_LaneInfoSegmentList& coRef);
   fi_tcl_LaneInfoSegmentList(const fi_tcl_LaneInfoSegmentList& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
   std::vector<fi_tcl_LaneInfoSegment, std::allocator<fi_tcl_LaneInfoSegment> > LaneInfoSegmentList;

   virtual tVoid vDestroy();
   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual tBool operator==(const fi_tcl_LaneInfoSegmentList& rfoCmp) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   virtual tS32 s32GetTypeId() const { return typesfi_tclToken::EN_LANEINFOSEGMENTLIST;}
   virtual tVoid vTakeVisitor(fi_tclVisitorBase& rfoVisitor);
};

class fi_tcl_LaneInfoListSet : public fi_tclVisitableTypeBase
{
public:
   fi_tcl_LaneInfoListSet() {}
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   fi_tcl_LaneInfoListSet& operator=(const fi_tcl_LaneInfoListSet& coRef);
   fi_tcl_LaneInfoListSet(const fi_tcl_LaneInfoListSet& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
   std::vector<fi_tcl_ReferenceElement, std::allocator<fi_tcl_ReferenceElement> > AlternativRefList;
   std::vector<fi_tcl_LaneInfoSegmentList, std::allocator<fi_tcl_LaneInfoSegmentList> > LaneInfoSegmentListList;

   virtual tVoid vDestroy();
   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual tBool operator==(const fi_tcl_LaneInfoListSet& rfoCmp) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   virtual tS32 s32GetTypeId() const { return typesfi_tclToken::EN_LANEINFOLISTSET;}
   virtual tVoid vTakeVisitor(fi_tclVisitorBase& rfoVisitor);
};

class fi_tcl_e8_EntryExitType : public fi_tclVisitableTypeBase
{
public:
   fi_tcl_e8_EntryExitType():enType(FI_EN_ENTRYPOINTCOORDINATE) {}

   enum tenType {
      FI_EN_ENTRYPOINTCOORDINATE = 0UL,
      FI_EN_EXITPOINTCOORDINATE = 1UL
   };
   tenType enType;

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual tBool operator==(const fi_tcl_e8_EntryExitType& rfoCmp) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   virtual tS32 s32GetTypeId() const { return typesfi_tclToken::EN_E8_ENTRYEXITTYPE;}
   virtual tVoid vTakeVisitor(fi_tclVisitorBase& rfoVisitor);
};

class fi_tcl_EntryExitCoordinates : public fi_tclVisitableTypeBase
{
public:
   fi_tcl_EntryExitCoordinates():Type(),Coordinate() {}
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   fi_tcl_EntryExitCoordinates& operator=(const fi_tcl_EntryExitCoordinates& coRef);
   fi_tcl_EntryExitCoordinates(const fi_tcl_EntryExitCoordinates& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
   fi_tcl_e8_EntryExitType Type;
   fi_tcl_PositionWGS84 Coordinate;

   virtual tVoid vDestroy();
   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual tBool operator==(const fi_tcl_EntryExitCoordinates& rfoCmp) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   virtual tS32 s32GetTypeId() const { return typesfi_tclToken::EN_ENTRYEXITCOORDINATES;}
   virtual tVoid vTakeVisitor(fi_tclVisitorBase& rfoVisitor);
};

class fi_tcl_EntryExitPointListSet : public fi_tclVisitableTypeBase
{
public:
   fi_tcl_EntryExitPointListSet() {}
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   fi_tcl_EntryExitPointListSet& operator=(const fi_tcl_EntryExitPointListSet& coRef);
   fi_tcl_EntryExitPointListSet(const fi_tcl_EntryExitPointListSet& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
   std::vector<fi_tcl_ReferenceElement, std::allocator<fi_tcl_ReferenceElement> > AlternativRefList;
   std::vector<fi_tcl_EntryExitCoordinates, std::allocator<fi_tcl_EntryExitCoordinates> > EntryExitPointList;

   virtual tVoid vDestroy();
   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual tBool operator==(const fi_tcl_EntryExitPointListSet& rfoCmp) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   virtual tS32 s32GetTypeId() const { return typesfi_tclToken::EN_ENTRYEXITPOINTLISTSET;}
   virtual tVoid vTakeVisitor(fi_tclVisitorBase& rfoVisitor);
};

class fi_tcl_WGS84CoordinateList : public fi_tclVisitableTypeBase
{
public:
   fi_tcl_WGS84CoordinateList() {}
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   fi_tcl_WGS84CoordinateList& operator=(const fi_tcl_WGS84CoordinateList& coRef);
   fi_tcl_WGS84CoordinateList(const fi_tcl_WGS84CoordinateList& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
   std::vector<fi_tcl_PositionWGS84, std::allocator<fi_tcl_PositionWGS84> > WGS84CoordinateList;

   virtual tVoid vDestroy();
   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual tBool operator==(const fi_tcl_WGS84CoordinateList& rfoCmp) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   virtual tS32 s32GetTypeId() const { return typesfi_tclToken::EN_WGS84COORDINATELIST;}
   virtual tVoid vTakeVisitor(fi_tclVisitorBase& rfoVisitor);
};

class fi_tcl_ShapePointListSet : public fi_tclVisitableTypeBase
{
public:
   fi_tcl_ShapePointListSet() {}
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   fi_tcl_ShapePointListSet& operator=(const fi_tcl_ShapePointListSet& coRef);
   fi_tcl_ShapePointListSet(const fi_tcl_ShapePointListSet& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
   std::vector<fi_tcl_WGS84CoordinateList, std::allocator<fi_tcl_WGS84CoordinateList> > ShapePointListList;

   virtual tVoid vDestroy();
   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual tBool operator==(const fi_tcl_ShapePointListSet& rfoCmp) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   virtual tS32 s32GetTypeId() const { return typesfi_tclToken::EN_SHAPEPOINTLISTSET;}
   virtual tVoid vTakeVisitor(fi_tclVisitorBase& rfoVisitor);
};

class fi_tcl_b8_TrafficMessageContent : public fi_tclVisitableTypeBase
{
public:
   fi_tcl_b8_TrafficMessageContent():u8Value(0) {}

   enum {
      FI_C_U8_BIT_TEXTBINCONTAINER = 0x1UL,
      FI_C_U8_BIT_MAPBINCONTAINER = 0x2UL,
      FI_C_U8_BIT_TMINFO = 0x4UL
   };
   tBool bTextBinContainer() const {return (u8Value & FI_C_U8_BIT_TEXTBINCONTAINER) != 0; }
   tVoid vSetTextBinContainer(tBool bSetBit) { u8Value = (bSetBit)?(u8Value | FI_C_U8_BIT_TEXTBINCONTAINER):(u8Value & ~FI_C_U8_BIT_TEXTBINCONTAINER); }
   tBool bMapBinContainer() const {return (u8Value & FI_C_U8_BIT_MAPBINCONTAINER) != 0; }
   tVoid vSetMapBinContainer(tBool bSetBit) { u8Value = (bSetBit)?(u8Value | FI_C_U8_BIT_MAPBINCONTAINER):(u8Value & ~FI_C_U8_BIT_MAPBINCONTAINER); }
   tBool bTMInfo() const {return (u8Value & FI_C_U8_BIT_TMINFO) != 0; }
   tVoid vSetTMInfo(tBool bSetBit) { u8Value = (bSetBit)?(u8Value | FI_C_U8_BIT_TMINFO):(u8Value & ~FI_C_U8_BIT_TMINFO); }
   struct rBitValues {
      unsigned int TextBinContainer:1;
      unsigned int MapBinContainer:1;
      unsigned int TMInfo:1;
      unsigned int dummy3:1;
      unsigned int dummy4:1;
      unsigned int dummy5:1;
      unsigned int dummy6:1;
      unsigned int dummy7:1;
   };
   union {
      tU8 u8Value;
      rBitValues bits;
   };

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual tBool operator==(const fi_tcl_b8_TrafficMessageContent& rfoCmp) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   virtual tS32 s32GetTypeId() const { return typesfi_tclToken::EN_B8_TRAFFICMESSAGECONTENT;}
   virtual tVoid vTakeVisitor(fi_tclVisitorBase& rfoVisitor);
};

class fi_tcl_e8_TMGeometricMessageType : public fi_tclVisitableTypeBase
{
public:
   fi_tcl_e8_TMGeometricMessageType():enType(FI_EN_AREA) {}

   enum tenType {
      FI_EN_AREA = 0UL,
      FI_EN_ROAD = 1UL,
      FI_EN_POINT = 2UL
   };
   tenType enType;

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual tBool operator==(const fi_tcl_e8_TMGeometricMessageType& rfoCmp) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   virtual tS32 s32GetTypeId() const { return typesfi_tclToken::EN_E8_TMGEOMETRICMESSAGETYPE;}
   virtual tVoid vTakeVisitor(fi_tclVisitorBase& rfoVisitor);
};

class fi_tcl_e16_NaviEventValue : public fi_tclVisitableTypeBase
{
public:
   fi_tcl_e16_NaviEventValue():enType(FI_EN_NEV_UNDEFINED) {}

   enum tenType {
      FI_EN_NEV_UNDEFINED = 0UL,
      FI_EN_NEV_SLIPROADSCLOSED = 1UL,
      FI_EN_NEV_EXITSLIPROADCLOSED = 2UL,
      FI_EN_NEV_SLOWTRAFFIC = 3UL,
      FI_EN_NEV_ENTRYSLIPROADCLOSED = 4UL,
      FI_EN_NEV_FERRYSERVICENOTOPERATING = 5UL,
      FI_EN_NEV_HEAVYTRAFFIC = 6UL,
      FI_EN_NEV_STATIONARYTRAFFIC = 7UL,
      FI_EN_NEV_QUEUINGTRAFFICOVERTHECRESTOFAHILL = 8UL,
      FI_EN_NEV_QUEUINGTRAFFICAROUNDABENDINTHEROAD = 9UL,
      FI_EN_NEV_QUEUINGTRAFFIC = 10UL,
      FI_EN_NEV_CLOSEDAHEAD = 11UL,
      FI_EN_NEV_DELAY = 12UL,
      FI_EN_NEV_VEHICLEONWRONGCARRIAGEWAY = 13UL,
      FI_EN_NEV_DANGEROFAQUAPLANING = 14UL,
      FI_EN_NEV_ROADWORKS = 15UL,
      FI_EN_NEV_ROADWORKSSLOWTRAFFIC = 16UL,
      FI_EN_NEV_ROADWORKSHEAVYTRAFFIC = 17UL,
      FI_EN_NEV_ROADWORKSSTATIONARYTRAFFIC = 18UL,
      FI_EN_NEV_ROADWORKSQUEUINGTRAFFIC = 19UL,
      FI_EN_NEV_ROADWORKSCLOSEDAHEAD = 20UL,
      FI_EN_NEV_ROADWORKSDELAY = 21UL,
      FI_EN_NEV_ROADWORKSNARROWLANES = 22UL,
      FI_EN_NEV_SECURITYALERT = 23UL,
      FI_EN_NEV_SECURITYALERTSLOWTRAFFIC = 24UL,
      FI_EN_NEV_SECURITYALERTHEAVYTRAFFIC = 25UL,
      FI_EN_NEV_SECURITYALERTSTATIONARYTRAFFIC = 26UL,
      FI_EN_NEV_SECURITYALERTQUEUINGTRAFFIC = 27UL,
      FI_EN_NEV_SECURITYALERTCLOSEDAHEAD = 28UL,
      FI_EN_NEV_SECURITYALERTDELAY = 29UL,
      FI_EN_NEV_VEHICLESSLOWINGTOLOOKATACCIDENT = 30UL,
      FI_EN_NEV_VEHICLESSLOWINGTOLOOKATACCIDENTSLOWTRAFFIC = 31UL,
      FI_EN_NEV_VEHICLESSLOWINGTOLOOKATACCIDENTHEAVYTRAFFIC = 32UL,
      FI_EN_NEV_VEHICLESSLOWINGTOLOOKATACCIDENTSTATIONARYTRAFFIC = 33UL,
      FI_EN_NEV_VEHICLESSLOWINGTOLOOKATACCIDENTQUEUINGTRAFFIC = 34UL,
      FI_EN_NEV_VEHICLESSLOWINGTOLOOKATACCIDENTDELAY = 35UL,
      FI_EN_NEV_RESTRICTIONS = 36UL,
      FI_EN_NEV_SWITCHYOURCARRADIO = 37UL,
      FI_EN_NEV_NARROWLANES = 38UL,
      FI_EN_NEV_NARROWLANESSLOWTRAFFIC = 39UL,
      FI_EN_NEV_NARROWLANESHEAVYTRAFFIC = 40UL,
      FI_EN_NEV_NARROWLANESSTATIONARYTRAFFIC = 41UL,
      FI_EN_NEV_NARROWLANESQUEUINGTRAFFIC = 42UL,
      FI_EN_NEV_SUBSIDENCEDANGER = 43UL,
      FI_EN_NEV_SUBSIDENCEDANGERROADPASSABLEWITHCARE = 44UL,
      FI_EN_NEV_SUBSIDENCEDANGERCLOSEDAHEAD = 45UL,
      FI_EN_NEV_SUBSIDENCEDANGERNARROWLANES = 46UL,
      FI_EN_NEV_GASLEAKDANGER = 47UL,
      FI_EN_NEV_GASLEAKDANGERCLOSEDAHEAD = 48UL,
      FI_EN_NEV_GASLEAKDANGERDELAY = 49UL,
      FI_EN_NEV_RESCUEANDRECOVERYWORKINPROGRESSDANGER = 50UL,
      FI_EN_NEV_RESCUEANDRECOVERYWORKINPROGRESSDANGERCLOSEDAHEAD = 51UL,
      FI_EN_NEV_BROKENDOWNVEHICLEDANGER = 52UL,
      FI_EN_NEV_BROKENDOWNVEHICLEDANGERSLOWTRAFFIC = 53UL,
      FI_EN_NEV_BROKENDOWNVEHICLEDANGERHEAVYTRAFFIC = 54UL,
      FI_EN_NEV_BROKENDOWNVEHICLEDANGERSTATIONARYTRAFFIC = 55UL,
      FI_EN_NEV_BROKENDOWNVEHICLEDANGERQUEUINGTRAFFIC = 56UL,
      FI_EN_NEV_BROKENDOWNVEHICLEDANGERCLOSEDAHEAD = 57UL,
      FI_EN_NEV_BROKENDOWNVEHICLEDANGERDELAY = 58UL,
      FI_EN_NEV_BROKENDOWNVEHICLENARROWLANES = 59UL,
      FI_EN_NEV_SLOWMOVINGMAINTENANCEVEHICLE = 60UL,
      FI_EN_NEV_SLOWMOVINGMAINTENANCEVEHICLEDELAY = 61UL,
      FI_EN_NEV_EARTHQUAKEDAMAGEDANGER = 62UL,
      FI_EN_NEV_LANDSLIPSDANGER = 63UL,
      FI_EN_NEV_LANDSLIPSDANGERROADPASSABLEWITHCARE = 64UL,
      FI_EN_NEV_LANDSLIPSDANGERCLOSEDAHEAD = 65UL,
      FI_EN_NEV_FIREDANGER = 66UL,
      FI_EN_NEV_FIREDANGERCLOSEDAHEAD = 67UL,
      FI_EN_NEV_FIREDANGERDELAY = 68UL,
      FI_EN_NEV_OBSTRUCTIONSONTHEROADDANGER = 69UL,
      FI_EN_NEV_OBSTRUCTIONSONTHEROADDANGERROADPASSABLEWITHCARE = 70UL,
      FI_EN_NEV_OBSTRUCTIONSONTHEROADDANGERCLOSEDAHEAD = 71UL,
      FI_EN_NEV_FLOODINGDANGER = 72UL,
      FI_EN_NEV_FLOODINGDANGERSLOWTRAFFIC = 73UL,
      FI_EN_NEV_FLOODINGDANGERHEAVYTRAFFIC = 74UL,
      FI_EN_NEV_FLOODINGDANGERSTATIONARYTRAFFIC = 75UL,
      FI_EN_NEV_FLOODINGDANGERQUEUINGTRAFFIC = 76UL,
      FI_EN_NEV_FLOODINGDANGERROADPASSABLEWITHCARE = 77UL,
      FI_EN_NEV_FLOODINGDANGERCLOSEDAHEAD = 78UL,
      FI_EN_NEV_FLOODINGDANGERDELAY = 79UL,
      FI_EN_NEV_AVALANCHESDANGER = 80UL,
      FI_EN_NEV_AVALANCHESDANGERROADPASSABLEWITHCARE = 81UL,
      FI_EN_NEV_AVALANCHESDANGERCLOSEDAHEAD = 82UL,
      FI_EN_NEV_PEOPLEONROADWAYDANGER = 83UL,
      FI_EN_NEV_BURSTPIPEDANGER = 84UL,
      FI_EN_NEV_BURSTPIPEDANGERCLOSEDAHEAD = 85UL,
      FI_EN_NEV_BURSTPIPEDANGERDELAY = 86UL,
      FI_EN_NEV_RECKLESSDRIVER = 87UL,
      FI_EN_NEV_ABNORMALLOADDANGER = 88UL,
      FI_EN_NEV_ABNORMALLOADDANGERDELAY = 89UL,
      FI_EN_NEV_ROCKFALLSDANGER = 90UL,
      FI_EN_NEV_ROCKFALLSDANGERROADPASSABLEWITHCARE = 91UL,
      FI_EN_NEV_ROCKFALLSDANGERCLOSEDAHEAD = 92UL,
      FI_EN_NEV_STORMDAMAGEDANGER = 93UL,
      FI_EN_NEV_STORMDAMAGEDANGERROADPASSABLEWITHCARE = 94UL,
      FI_EN_NEV_STORMDAMAGEDANGERCLOSEDAHEAD = 95UL,
      FI_EN_NEV_ANIMALSONROADWAYDANGER = 96UL,
      FI_EN_NEV_SEWERCOLLAPSEDANGER = 97UL,
      FI_EN_NEV_SEWERCOLLAPSEDANGERCLOSEDAHEAD = 98UL,
      FI_EN_NEV_SEWERCOLLAPSEDANGERDELAY = 99UL,
      FI_EN_NEV_SHEDLOADDANGER = 100UL,
      FI_EN_NEV_SHEDLOADDANGERSLOWTRAFFIC = 101UL,
      FI_EN_NEV_SHEDLOADDANGERHEAVYTRAFFIC = 102UL,
      FI_EN_NEV_SHEDLOADDANGERSTATIONARYTRAFFIC = 103UL,
      FI_EN_NEV_SHEDLOADDANGERQUEUINGTRAFFIC = 104UL,
      FI_EN_NEV_SHEDLOADDANGERROADPASSABLEWITHCARE = 105UL,
      FI_EN_NEV_SHEDLOADDANGERCLOSEDAHEAD = 106UL,
      FI_EN_NEV_SHEDLOADDANGERDELAY = 107UL,
      FI_EN_NEV_SHEDLOADDANGERNARROWLANES = 108UL,
      FI_EN_NEV_MUDONROAD = 109UL,
      FI_EN_NEV_HAZARDOUSDRIVINGCONDITIONS = 110UL,
      FI_EN_NEV_OVERHEIGHTWARNINGSYSTEMTRIGGERED = 111UL,
      FI_EN_NEV_TRAFFICLIGHTSWORKINGINCORRECTLY = 112UL,
      FI_EN_NEV_TRAFFICLIGHTSWORKINGINCORRECTLYSLOWTRAFFIC = 113UL,
      FI_EN_NEV_TRAFFICLIGHTSWORKINGINCORRECTLYHEAVYTRAFFIC = 114UL,
      FI_EN_NEV_TRAFFICLIGHTSWORKINGINCORRECTLYSTATIONARYTRAFFIC = 115UL,
      FI_EN_NEV_TRAFFICLIGHTSWORKINGINCORRECTLYQUEUINGTRAFFIC = 116UL,
      FI_EN_NEV_TRAFFICLIGHTSWORKINGINCORRECTLYDELAY = 117UL,
      FI_EN_NEV_EMERGENCYTELEPHONESNOTWORKING = 118UL,
      FI_EN_NEV_EMERGENCYVEHICLES = 119UL,
      FI_EN_NEV_VISIBILITYREDUCED = 120UL,
      FI_EN_NEV_VISIBILITYREDUCEDTOLESSTHAN50M = 121UL,
      FI_EN_NEV_SMOGALERT = 122UL,
      FI_EN_NEV_SMOGALERTCLOSEDAHEAD = 123UL,
      FI_EN_NEV_HEAVYFROST = 124UL,
      FI_EN_NEV_STRONGWINDS = 125UL,
      FI_EN_NEV_LEVELCROSSINGFAILURE = 126UL,
      FI_EN_NEV_LEVELCROSSINGFAILURESLOWTRAFFIC = 127UL,
      FI_EN_NEV_LEVELCROSSINGFAILUREHEAVYTRAFFIC = 128UL,
      FI_EN_NEV_LEVELCROSSINGFAILURESTATIONARYTRAFFIC = 129UL,
      FI_EN_NEV_LEVELCROSSINGFAILUREQUEUINGTRAFFIC = 130UL,
      FI_EN_NEV_LEVELCROSSINGFAILUREDELAY = 131UL,
      FI_EN_NEV_SLIPPYROAD = 132UL,
      FI_EN_NEV_SLIPPYROADROADPASSABLEWITHCARE = 133UL,
      FI_EN_NEV_SLIPPYROADCLOSEDAHEAD = 134UL,
      FI_EN_NEV_SLIPPYROADNARROWLANES = 135UL,
      FI_EN_NEV_ACCIDENT = 136UL,
      FI_EN_NEV_ACCIDENTSLOWTRAFFIC = 137UL,
      FI_EN_NEV_ACCIDENTHEAVYTRAFFIC = 138UL,
      FI_EN_NEV_ACCIDENTSTATIONARYTRAFFIC = 139UL,
      FI_EN_NEV_ACCIDENTQUEUINGTRAFFIC = 140UL,
      FI_EN_NEV_ACCIDENTCLOSEDAHEAD = 141UL,
      FI_EN_NEV_ACCIDENTDELAY = 142UL,
      FI_EN_NEV_ACCIDENTNARROWLANES = 143UL,
      FI_EN_NEV_THUNDERSTORM = 144UL,
      FI_EN_NEV_MAJOREVENT = 145UL,
      FI_EN_NEV_MAJOREVENTSLOWTRAFFIC = 146UL,
      FI_EN_NEV_MAJOREVENTHEAVYTRAFFIC = 147UL,
      FI_EN_NEV_MAJOREVENTSTATIONARYTRAFFIC = 148UL,
      FI_EN_NEV_MAJOREVENTQUEUINGTRAFFIC = 149UL,
      FI_EN_NEV_MAJOREVENTCLOSEDAHEAD = 150UL,
      FI_EN_NEV_MAJOREVENTDELAY = 151UL,
      FI_EN_NEV_TRAFFICCONGESTION = 152UL,
      FI_EN_NEV_TRAFFICCONGESTIONAVERAGESPEED = 153UL,
      FI_EN_NEV_TRAFFICCONGESTIONEXPECTED = 154UL,
      FI_EN_NEV_TRAFFICCONGESTIONDELAY = 155UL,
      FI_EN_NEV_CLOSEDAHEADSTATIONARYTRAFFIC = 156UL,
      FI_EN_NEV_CLOSEDAHEADQUEUINGTRAFFIC = 157UL,
      FI_EN_NEV_CLOSEDAHEADSLOWTRAFFIC = 158UL,
      FI_EN_NEV_SNOWONTHEROAD = 159UL,
      FI_EN_NEV_SNOWONTHEROADCLOSEDAHEAD = 160UL,
      FI_EN_NEV_SNOWONTHEROADNARROWLANES = 161UL,
      FI_EN_NEV_ICE = 162UL,
      FI_EN_NEV_ICEROADPASSABLEWITHCARE = 163UL,
      FI_EN_NEV_ICECLOSEDAHEAD = 164UL,
      FI_EN_NEV_SLIPPYROADSHEDLOAD = 165UL,
      FI_EN_NEV_TRAFFICSIGNALLIGHTSWORKINGINCORRECTLY = 166UL,
      FI_EN_NEV_OILONROAD = 167UL,
      FI_EN_NEV_ACCIDENTOILONROAD = 168UL,
      FI_EN_NEV_PETROLONROAD = 169UL,
      FI_EN_NEV_ACCIDENTPETROLONROAD = 170UL,
      FI_EN_NEV_ACCIDENTCHEMICALSPILLAGE = 171UL,
      FI_EN_NEV_TRAFFICREGULATIONSCHANGED = 172UL,
      FI_EN_NEV_TUNNELVENTILATIONNOTWORKING = 173UL,
      FI_EN_NEV_CLOSEDAHEADDELAY = 174UL,
      FI_EN_NEV_DELAYGREATERONEHOUR = 175UL,
      FI_EN_NEV_DELAYGREATERTHREEHOURS = 176UL,
      FI_EN_NEV_DELAYFORBUSES = 177UL,
      FI_EN_NEV_DELAYFORHEAVYLORRIES = 178UL,
      FI_EN_NEV_DELAYFORHEAVYLORRIESGREATERONEHOUR = 179UL,
      FI_EN_NEV_DELAYFORHEAVYLORRIESGREATERTHREEHOURS = 180UL,
      FI_EN_NEV_CHILDRENONROADWAYDANGER = 181UL,
      FI_EN_NEV_SERVICEAREABUSY = 182UL,
      FI_EN_NEV_FUELSTATIONCLOSED = 183UL,
      FI_EN_NEV_RESTAURANTCLOSED = 184UL,
      FI_EN_NEV_VISIBILITYREDUCEDSLIPPERYROAD = 185UL,
      FI_EN_NEV_TRAFFICCONGESTIONAVERAGESPEEDOF10KMH = 186UL,
      FI_EN_NEV_TRAFFICCONGESTIONAVERAGESPEEDOF20KMH = 187UL,
      FI_EN_NEV_TRAFFICCONGESTIONAVERAGESPEEDOF30KMH = 188UL,
      FI_EN_NEV_TRAFFICCONGESTIONAVERAGESPEEDOF40KMH = 189UL,
      FI_EN_NEV_TRAFFICCONGESTIONAVERAGESPEEDOF50KMH = 190UL,
      FI_EN_NEV_TRAFFICCONGESTIONAVERAGESPEEDOF60KMH = 191UL,
      FI_EN_NEV_TRAFFICCONGESTIONAVERAGESPEEDOF70KMH = 192UL,
      FI_EN_NEV_FREEFLOW = 193UL
   };
   tenType enType;

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual tBool operator==(const fi_tcl_e16_NaviEventValue& rfoCmp) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   virtual tS32 s32GetTypeId() const { return typesfi_tclToken::EN_E16_NAVIEVENTVALUE;}
   virtual tVoid vTakeVisitor(fi_tclVisitorBase& rfoVisitor);
};

class fi_tcl_TMMapOneCellListSet : public fi_tclVisitableTypeBase
{
public:
   fi_tcl_TMMapOneCellListSet() {}
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   fi_tcl_TMMapOneCellListSet& operator=(const fi_tcl_TMMapOneCellListSet& coRef);
   fi_tcl_TMMapOneCellListSet(const fi_tcl_TMMapOneCellListSet& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
   std::vector<fi_tcl_TMOneCellDesc, std::allocator<fi_tcl_TMOneCellDesc> > TMOneCellList;
   std::vector<fi_tcl_NavClusterDesc, std::allocator<fi_tcl_NavClusterDesc> > ClusterList;

   virtual tVoid vDestroy();
   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual tBool operator==(const fi_tcl_TMMapOneCellListSet& rfoCmp) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   virtual tS32 s32GetTypeId() const { return typesfi_tclToken::EN_TMMAPONECELLLISTSET;}
   virtual tVoid vTakeVisitor(fi_tclVisitorBase& rfoVisitor);
};

class fi_tcl_TrafficSense : public fi_tclVisitableTypeBase
{
public:
   fi_tcl_TrafficSense():CountryCode(),TrafficSense() {}
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   fi_tcl_TrafficSense& operator=(const fi_tcl_TrafficSense& coRef);
   fi_tcl_TrafficSense(const fi_tcl_TrafficSense& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
   fi_tcl_e16_ISOCountryCode CountryCode;
   fi_tcl_e8_SideInfo TrafficSense;

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual tBool operator==(const fi_tcl_TrafficSense& rfoCmp) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   virtual tS32 s32GetTypeId() const { return typesfi_tclToken::EN_TRAFFICSENSE;}
   virtual tVoid vTakeVisitor(fi_tclVisitorBase& rfoVisitor);
};

class fi_tcl_TrafficSenseList : public fi_tclVisitableTypeBase
{
public:
   fi_tcl_TrafficSenseList() {}
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   fi_tcl_TrafficSenseList& operator=(const fi_tcl_TrafficSenseList& coRef);
   fi_tcl_TrafficSenseList(const fi_tcl_TrafficSenseList& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
   std::vector<fi_tcl_TrafficSense, std::allocator<fi_tcl_TrafficSense> > TrafficSenseList;

   virtual tVoid vDestroy();
   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual tBool operator==(const fi_tcl_TrafficSenseList& rfoCmp) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   virtual tS32 s32GetTypeId() const { return typesfi_tclToken::EN_TRAFFICSENSELIST;}
   virtual tVoid vTakeVisitor(fi_tclVisitorBase& rfoVisitor);
};

class fi_tcl_SpeedFactor : public fi_tclVisitableTypeBase
{
public:
   fi_tcl_SpeedFactor():RoadClass(),SpeedValue() {}
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   fi_tcl_SpeedFactor& operator=(const fi_tcl_SpeedFactor& coRef);
   fi_tcl_SpeedFactor(const fi_tcl_SpeedFactor& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
   fi_tcl_e8_RoadClassCode RoadClass;
   fi_tcl_s16_CentimeterSecond SpeedValue;

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual tBool operator==(const fi_tcl_SpeedFactor& rfoCmp) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   virtual tS32 s32GetTypeId() const { return typesfi_tclToken::EN_SPEEDFACTOR;}
   virtual tVoid vTakeVisitor(fi_tclVisitorBase& rfoVisitor);
};

class fi_tcl_e8_RoadTypeDesc : public fi_tclVisitableTypeBase
{
public:
   fi_tcl_e8_RoadTypeDesc():enType(FI_EN_URBAN) {}

   enum tenType {
      FI_EN_URBAN = 0UL,
      FI_EN_RURAL = 1UL,
      FI_EN_FREEWAY = 2UL
   };
   tenType enType;

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual tBool operator==(const fi_tcl_e8_RoadTypeDesc& rfoCmp) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   virtual tS32 s32GetTypeId() const { return typesfi_tclToken::EN_E8_ROADTYPEDESC;}
   virtual tVoid vTakeVisitor(fi_tclVisitorBase& rfoVisitor);
};

class fi_tcl_SpeedFactorRoadAreaType : public fi_tclVisitableTypeBase
{
public:
   fi_tcl_SpeedFactorRoadAreaType():RoadTypeDescription() {}
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   fi_tcl_SpeedFactorRoadAreaType& operator=(const fi_tcl_SpeedFactorRoadAreaType& coRef);
   fi_tcl_SpeedFactorRoadAreaType(const fi_tcl_SpeedFactorRoadAreaType& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
   fi_tcl_e8_RoadTypeDesc RoadTypeDescription;
   std::vector<fi_tcl_SpeedFactor, std::allocator<fi_tcl_SpeedFactor> > SpeedFactor;

   virtual tVoid vDestroy();
   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual tBool operator==(const fi_tcl_SpeedFactorRoadAreaType& rfoCmp) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   virtual tS32 s32GetTypeId() const { return typesfi_tclToken::EN_SPEEDFACTORROADAREATYPE;}
   virtual tVoid vTakeVisitor(fi_tclVisitorBase& rfoVisitor);
};

class fi_tcl_SpeedFactorsCountry : public fi_tclVisitableTypeBase
{
public:
   fi_tcl_SpeedFactorsCountry():CountryCode(),TimeOffsetToHighway(),TimeOffsetOnLongRamp() {}
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   fi_tcl_SpeedFactorsCountry& operator=(const fi_tcl_SpeedFactorsCountry& coRef);
   fi_tcl_SpeedFactorsCountry(const fi_tcl_SpeedFactorsCountry& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
   fi_tcl_e16_ISOCountryCode CountryCode;
   std::vector<fi_tcl_SpeedFactorRoadAreaType, std::allocator<fi_tcl_SpeedFactorRoadAreaType> > SpeedFactorsRoadAreaTypeList;
   fi_tcl_s32_Second TimeOffsetToHighway;
   fi_tcl_s32_MilliSecond TimeOffsetOnLongRamp;

   virtual tVoid vDestroy();
   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual tBool operator==(const fi_tcl_SpeedFactorsCountry& rfoCmp) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   virtual tS32 s32GetTypeId() const { return typesfi_tclToken::EN_SPEEDFACTORSCOUNTRY;}
   virtual tVoid vTakeVisitor(fi_tclVisitorBase& rfoVisitor);
};

class fi_tcl_SpeedFactorsList : public fi_tclVisitableTypeBase
{
public:
   fi_tcl_SpeedFactorsList() {}
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   fi_tcl_SpeedFactorsList& operator=(const fi_tcl_SpeedFactorsList& coRef);
   fi_tcl_SpeedFactorsList(const fi_tcl_SpeedFactorsList& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
   std::vector<fi_tcl_SpeedFactorsCountry, std::allocator<fi_tcl_SpeedFactorsCountry> > SpeedFactorsCountryList;

   virtual tVoid vDestroy();
   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual tBool operator==(const fi_tcl_SpeedFactorsList& rfoCmp) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   virtual tS32 s32GetTypeId() const { return typesfi_tclToken::EN_SPEEDFACTORSLIST;}
   virtual tVoid vTakeVisitor(fi_tclVisitorBase& rfoVisitor);
};

class fi_tcl_b8_SpeedLimitStatus : public fi_tclVisitableTypeBase
{
public:
   fi_tcl_b8_SpeedLimitStatus():u8Value(0) {}

   enum {
      FI_C_U8_BIT_STATUSENTERED = 0x1UL
   };
   tBool bStatusEntered() const {return (u8Value & FI_C_U8_BIT_STATUSENTERED) != 0; }
   tVoid vSetStatusEntered(tBool bSetBit) { u8Value = (bSetBit)?(u8Value | FI_C_U8_BIT_STATUSENTERED):(u8Value & ~FI_C_U8_BIT_STATUSENTERED); }
   struct rBitValues {
      unsigned int StatusEntered:1;
      unsigned int dummy1:1;
      unsigned int dummy2:1;
      unsigned int dummy3:1;
      unsigned int dummy4:1;
      unsigned int dummy5:1;
      unsigned int dummy6:1;
      unsigned int dummy7:1;
   };
   union {
      tU8 u8Value;
      rBitValues bits;
   };

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual tBool operator==(const fi_tcl_b8_SpeedLimitStatus& rfoCmp) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   virtual tS32 s32GetTypeId() const { return typesfi_tclToken::EN_B8_SPEEDLIMITSTATUS;}
   virtual tVoid vTakeVisitor(fi_tclVisitorBase& rfoVisitor);
};

class fi_tcl_e8_SpeedUnit : public fi_tclVisitableTypeBase
{
public:
   fi_tcl_e8_SpeedUnit():enType(FI_EN_KILOMETERSPERHOUR) {}

   enum tenType {
      FI_EN_KILOMETERSPERHOUR = 0UL,
      FI_EN_MILESPERHOUR = 1UL
   };
   tenType enType;

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual tBool operator==(const fi_tcl_e8_SpeedUnit& rfoCmp) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   virtual tS32 s32GetTypeId() const { return typesfi_tclToken::EN_E8_SPEEDUNIT;}
   virtual tVoid vTakeVisitor(fi_tclVisitorBase& rfoVisitor);
};

class fi_tcl_e8_SpeedType : public fi_tclVisitableTypeBase
{
public:
   fi_tcl_e8_SpeedType():enType(FI_EN_MAXIMUM) {}

   enum tenType {
      FI_EN_MAXIMUM = 0UL,
      FI_EN_RECOMMENDED = 1UL
   };
   tenType enType;

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual tBool operator==(const fi_tcl_e8_SpeedType& rfoCmp) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   virtual tS32 s32GetTypeId() const { return typesfi_tclToken::EN_E8_SPEEDTYPE;}
   virtual tVoid vTakeVisitor(fi_tclVisitorBase& rfoVisitor);
};

class fi_tcl_SpeedLimitStatus : public fi_tclVisitableTypeBase
{
public:
   fi_tcl_SpeedLimitStatus():SpeedUnit(),SpeedType(),Status() {}
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   fi_tcl_SpeedLimitStatus& operator=(const fi_tcl_SpeedLimitStatus& coRef);
   fi_tcl_SpeedLimitStatus(const fi_tcl_SpeedLimitStatus& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
   fi_tcl_e8_SpeedUnit SpeedUnit;
   fi_tcl_e8_SpeedType SpeedType;
   fi_tcl_b8_SpeedLimitStatus Status;

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual tBool operator==(const fi_tcl_SpeedLimitStatus& rfoCmp) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   virtual tS32 s32GetTypeId() const { return typesfi_tclToken::EN_SPEEDLIMITSTATUS;}
   virtual tVoid vTakeVisitor(fi_tclVisitorBase& rfoVisitor);
};

class fi_tcl_SpeedLimit : public fi_tclVisitableTypeBase
{
public:
   fi_tcl_SpeedLimit():RoadClass(),SpeedValue(0),Status() {}
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   fi_tcl_SpeedLimit& operator=(const fi_tcl_SpeedLimit& coRef);
   fi_tcl_SpeedLimit(const fi_tcl_SpeedLimit& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
   fi_tcl_e8_RoadClassCode RoadClass;
   tU8 SpeedValue;
   fi_tcl_SpeedLimitStatus Status;

   virtual tVoid vDestroy();
   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual tBool operator==(const fi_tcl_SpeedLimit& rfoCmp) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   virtual tS32 s32GetTypeId() const { return typesfi_tclToken::EN_SPEEDLIMIT;}
   virtual tVoid vTakeVisitor(fi_tclVisitorBase& rfoVisitor);
};

class fi_tcl_SpeedLimitRoadAreaType : public fi_tclVisitableTypeBase
{
public:
   fi_tcl_SpeedLimitRoadAreaType():RoadTypeDescription() {}
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   fi_tcl_SpeedLimitRoadAreaType& operator=(const fi_tcl_SpeedLimitRoadAreaType& coRef);
   fi_tcl_SpeedLimitRoadAreaType(const fi_tcl_SpeedLimitRoadAreaType& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
   fi_tcl_e8_RoadTypeDesc RoadTypeDescription;
   std::vector<fi_tcl_SpeedLimit, std::allocator<fi_tcl_SpeedLimit> > SpeedLimitRoadClassList;

   virtual tVoid vDestroy();
   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual tBool operator==(const fi_tcl_SpeedLimitRoadAreaType& rfoCmp) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   virtual tS32 s32GetTypeId() const { return typesfi_tclToken::EN_SPEEDLIMITROADAREATYPE;}
   virtual tVoid vTakeVisitor(fi_tclVisitorBase& rfoVisitor);
};

class fi_tcl_SpeedLimitsCountry : public fi_tclVisitableTypeBase
{
public:
   fi_tcl_SpeedLimitsCountry():CountryCode() {}
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   fi_tcl_SpeedLimitsCountry& operator=(const fi_tcl_SpeedLimitsCountry& coRef);
   fi_tcl_SpeedLimitsCountry(const fi_tcl_SpeedLimitsCountry& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
   fi_tcl_e16_ISOCountryCode CountryCode;
   std::vector<fi_tcl_SpeedLimitRoadAreaType, std::allocator<fi_tcl_SpeedLimitRoadAreaType> > SpeedLimitsRoadAreaTypeList;

   virtual tVoid vDestroy();
   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual tBool operator==(const fi_tcl_SpeedLimitsCountry& rfoCmp) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   virtual tS32 s32GetTypeId() const { return typesfi_tclToken::EN_SPEEDLIMITSCOUNTRY;}
   virtual tVoid vTakeVisitor(fi_tclVisitorBase& rfoVisitor);
};

class fi_tcl_SpeedLimitsList : public fi_tclVisitableTypeBase
{
public:
   fi_tcl_SpeedLimitsList() {}
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   fi_tcl_SpeedLimitsList& operator=(const fi_tcl_SpeedLimitsList& coRef);
   fi_tcl_SpeedLimitsList(const fi_tcl_SpeedLimitsList& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
   std::vector<fi_tcl_SpeedLimitsCountry, std::allocator<fi_tcl_SpeedLimitsCountry> > SpeedLimitsCountryList;

   virtual tVoid vDestroy();
   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual tBool operator==(const fi_tcl_SpeedLimitsList& rfoCmp) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   virtual tS32 s32GetTypeId() const { return typesfi_tclToken::EN_SPEEDLIMITSLIST;}
   virtual tVoid vTakeVisitor(fi_tclVisitorBase& rfoVisitor);
};

class fi_tcl_PrefixDesc : public fi_tclVisitableTypeBase
{
public:
   fi_tcl_PrefixDesc():Mode(0),Prefix() {}
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   fi_tcl_PrefixDesc& operator=(const fi_tcl_PrefixDesc& coRef);
   fi_tcl_PrefixDesc(const fi_tcl_PrefixDesc& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
   tU16 Mode;
   fi_tclString Prefix;

   virtual tVoid vDestroy();
   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual tBool operator==(const fi_tcl_PrefixDesc& rfoCmp) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   virtual tS32 s32GetTypeId() const { return typesfi_tclToken::EN_PREFIXDESC;}
   virtual tVoid vTakeVisitor(fi_tclVisitorBase& rfoVisitor);
};

class fi_tcl_PrefixState : public fi_tclVisitableTypeBase
{
public:
   fi_tcl_PrefixState():CountryCode() {}
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   fi_tcl_PrefixState& operator=(const fi_tcl_PrefixState& coRef);
   fi_tcl_PrefixState(const fi_tcl_PrefixState& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
   fi_tcl_e16_ISOCountryCode CountryCode;
   std::vector<fi_tcl_PrefixDesc, std::allocator<fi_tcl_PrefixDesc> > PrefixDescList;

   virtual tVoid vDestroy();
   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual tBool operator==(const fi_tcl_PrefixState& rfoCmp) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   virtual tS32 s32GetTypeId() const { return typesfi_tclToken::EN_PREFIXSTATE;}
   virtual tVoid vTakeVisitor(fi_tclVisitorBase& rfoVisitor);
};

class fi_tcl_PrefixStateList : public fi_tclVisitableTypeBase
{
public:
   fi_tcl_PrefixStateList() {}
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   fi_tcl_PrefixStateList& operator=(const fi_tcl_PrefixStateList& coRef);
   fi_tcl_PrefixStateList(const fi_tcl_PrefixStateList& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
   std::vector<fi_tcl_PrefixState, std::allocator<fi_tcl_PrefixState> > PrefixStateList;

   virtual tVoid vDestroy();
   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual tBool operator==(const fi_tcl_PrefixStateList& rfoCmp) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   virtual tS32 s32GetTypeId() const { return typesfi_tclToken::EN_PREFIXSTATELIST;}
   virtual tVoid vTakeVisitor(fi_tclVisitorBase& rfoVisitor);
};

class fi_tcl_e8_LanguageCat : public fi_tclVisitableTypeBase
{
public:
   fi_tcl_e8_LanguageCat():enType(FI_EN_RESERVED) {}

   enum tenType {
      FI_EN_RESERVED = 0UL,
      FI_EN_LANGUAGEDIRECTION = 1UL
   };
   tenType enType;

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual tBool operator==(const fi_tcl_e8_LanguageCat& rfoCmp) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   virtual tS32 s32GetTypeId() const { return typesfi_tclToken::EN_E8_LANGUAGECAT;}
   virtual tVoid vTakeVisitor(fi_tclVisitorBase& rfoVisitor);
};

class fi_tcl_LanguageCategory : public fi_tclVisitableTypeBase
{
public:
   fi_tcl_LanguageCategory():LanguageCat() {}
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   fi_tcl_LanguageCategory& operator=(const fi_tcl_LanguageCategory& coRef);
   fi_tcl_LanguageCategory(const fi_tcl_LanguageCategory& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
   fi_tcl_e8_LanguageCat LanguageCat;
   std::vector<fi_tclString, std::allocator<fi_tclString> > Word;

   virtual tVoid vDestroy();
   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual tBool operator==(const fi_tcl_LanguageCategory& rfoCmp) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   virtual tS32 s32GetTypeId() const { return typesfi_tclToken::EN_LANGUAGECATEGORY;}
   virtual tVoid vTakeVisitor(fi_tclVisitorBase& rfoVisitor);
};

class fi_tcl_LanguageDesc : public fi_tclVisitableTypeBase
{
public:
   fi_tcl_LanguageDesc():LanguageId() {}
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   fi_tcl_LanguageDesc& operator=(const fi_tcl_LanguageDesc& coRef);
   fi_tcl_LanguageDesc(const fi_tcl_LanguageDesc& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
   fi_tcl_e16_ISOLanguageCode LanguageId;
   std::vector<fi_tcl_LanguageCategory, std::allocator<fi_tcl_LanguageCategory> > LanguageCategoryList;

   virtual tVoid vDestroy();
   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual tBool operator==(const fi_tcl_LanguageDesc& rfoCmp) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   virtual tS32 s32GetTypeId() const { return typesfi_tclToken::EN_LANGUAGEDESC;}
   virtual tVoid vTakeVisitor(fi_tclVisitorBase& rfoVisitor);
};

class fi_tcl_LanguageDescList : public fi_tclVisitableTypeBase
{
public:
   fi_tcl_LanguageDescList() {}
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   fi_tcl_LanguageDescList& operator=(const fi_tcl_LanguageDescList& coRef);
   fi_tcl_LanguageDescList(const fi_tcl_LanguageDescList& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
   std::vector<fi_tcl_LanguageDesc, std::allocator<fi_tcl_LanguageDesc> > LanguageDescList;

   virtual tVoid vDestroy();
   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual tBool operator==(const fi_tcl_LanguageDescList& rfoCmp) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   virtual tS32 s32GetTypeId() const { return typesfi_tclToken::EN_LANGUAGEDESCLIST;}
   virtual tVoid vTakeVisitor(fi_tclVisitorBase& rfoVisitor);
};

class fi_tcl_e8_GlobalAnnotationCategory : public fi_tclVisitableTypeBase
{
public:
   fi_tcl_e8_GlobalAnnotationCategory():enType(FI_EN_T_RESERVED) {}

   enum tenType {
      FI_EN_T_RESERVED = 0UL,
      FI_EN_T_TRAFFICSENSELIST = 1UL,
      FI_EN_T_SPEEDFACTORSLIST = 2UL,
      FI_EN_T_SPEEDLIMITSLIST = 3UL,
      FI_EN_T_REQUIREDPERMISSIONLIST = 4UL,
      FI_EN_T_PREFIXSTATELIST = 5UL,
      FI_EN_T_LANGUAGEDESCLIST = 6UL
   };
   tenType enType;

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual tBool operator==(const fi_tcl_e8_GlobalAnnotationCategory& rfoCmp) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   virtual tS32 s32GetTypeId() const { return typesfi_tclToken::EN_E8_GLOBALANNOTATIONCATEGORY;}
   virtual tVoid vTakeVisitor(fi_tclVisitorBase& rfoVisitor);
};

class fi_tcl_GlobalAnnotationTablesUnion : public fi_tclVisitableTypeBase
{
public:
   fi_tcl_GlobalAnnotationTablesUnion():poGlobalAnnotationUnionData(0) {}
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   fi_tcl_GlobalAnnotationTablesUnion& operator=(const fi_tcl_GlobalAnnotationTablesUnion& coRef);
   fi_tcl_GlobalAnnotationTablesUnion(const fi_tcl_GlobalAnnotationTablesUnion& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
   fi_tcl_e8_GlobalAnnotationCategory GlobalAnnotationUnionType;
   fi_tclTypeBase* poGlobalAnnotationUnionData;
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   virtual ~fi_tcl_GlobalAnnotationTablesUnion();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   virtual tVoid vDestroy();
   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual tBool operator==(const fi_tcl_GlobalAnnotationTablesUnion& rfoCmp) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   virtual tS32 s32GetTypeId() const { return typesfi_tclToken::EN_GLOBALANNOTATIONTABLESUNION;}
   virtual tVoid vTakeVisitor(fi_tclVisitorBase& rfoVisitor);
};

class fi_tcl_TimeZoneName : public fi_tclVisitableTypeBase
{
public:
   fi_tcl_TimeZoneName():NormalName(0),DSTName(0) {}
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   fi_tcl_TimeZoneName& operator=(const fi_tcl_TimeZoneName& coRef);
   fi_tcl_TimeZoneName(const fi_tcl_TimeZoneName& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
   fi_tclMultiLanguageString NormalName;
   fi_tclMultiLanguageString DSTName;

   virtual tVoid vDestroy();
   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual tBool operator==(const fi_tcl_TimeZoneName& rfoCmp) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   virtual tS32 s32GetTypeId() const { return typesfi_tclToken::EN_TIMEZONENAME;}
   virtual tVoid vTakeVisitor(fi_tclVisitorBase& rfoVisitor);
};

class fi_tcl_UPOI_Category : public fi_tclVisitableTypeBase
{
public:
   fi_tcl_UPOI_Category():Value(0) {}
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   fi_tcl_UPOI_Category& operator=(const fi_tcl_UPOI_Category& coRef);
   fi_tcl_UPOI_Category(const fi_tcl_UPOI_Category& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
   tU32 Value;

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual tBool operator==(const fi_tcl_UPOI_Category& rfoCmp) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   virtual tS32 s32GetTypeId() const { return typesfi_tclToken::EN_UPOI_CATEGORY;}
   virtual tVoid vTakeVisitor(fi_tclVisitorBase& rfoVisitor);
};

class fi_tcl_e8_UPOI_Source : public fi_tclVisitableTypeBase
{
public:
   fi_tcl_e8_UPOI_Source():enType(FI_EN_UNKNOWN) {}

   enum tenType {
      FI_EN_UNKNOWN = 0UL,
      FI_EN_STANDARD = 1UL,
      FI_EN_DOWNLOADED = 2UL,
      FI_EN_TRAVELGUIDE = 3UL,
      FI_EN_ADDRESSBOOK = 4UL
   };
   tenType enType;

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual tBool operator==(const fi_tcl_e8_UPOI_Source& rfoCmp) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   virtual tS32 s32GetTypeId() const { return typesfi_tclToken::EN_E8_UPOI_SOURCE;}
   virtual tVoid vTakeVisitor(fi_tclVisitorBase& rfoVisitor);
};

class fi_tcl_b16_UPOI_Source : public fi_tclVisitableTypeBase
{
public:
   fi_tcl_b16_UPOI_Source():u16Value(0) {}

   enum {
      FI_C_U16_BIT_STANDARD = 0x1UL,
      FI_C_U16_BIT_DOWNLOADED = 0x2UL,
      FI_C_U16_BIT_TRAVELGUIDE = 0x4UL,
      FI_C_U16_BIT_ADDRESSBOOK = 0x8UL
   };
   tBool bStandard() const {return (u16Value & FI_C_U16_BIT_STANDARD) != 0; }
   tVoid vSetStandard(tBool bSetBit) { u16Value = (bSetBit)?(u16Value | FI_C_U16_BIT_STANDARD):(u16Value & ~FI_C_U16_BIT_STANDARD); }
   tBool bDownloaded() const {return (u16Value & FI_C_U16_BIT_DOWNLOADED) != 0; }
   tVoid vSetDownloaded(tBool bSetBit) { u16Value = (bSetBit)?(u16Value | FI_C_U16_BIT_DOWNLOADED):(u16Value & ~FI_C_U16_BIT_DOWNLOADED); }
   tBool bTravelGuide() const {return (u16Value & FI_C_U16_BIT_TRAVELGUIDE) != 0; }
   tVoid vSetTravelGuide(tBool bSetBit) { u16Value = (bSetBit)?(u16Value | FI_C_U16_BIT_TRAVELGUIDE):(u16Value & ~FI_C_U16_BIT_TRAVELGUIDE); }
   tBool bAddressbook() const {return (u16Value & FI_C_U16_BIT_ADDRESSBOOK) != 0; }
   tVoid vSetAddressbook(tBool bSetBit) { u16Value = (bSetBit)?(u16Value | FI_C_U16_BIT_ADDRESSBOOK):(u16Value & ~FI_C_U16_BIT_ADDRESSBOOK); }
   struct rBitValues {
      unsigned int Standard:1;
      unsigned int Downloaded:1;
      unsigned int TravelGuide:1;
      unsigned int Addressbook:1;
      unsigned int dummy4:1;
      unsigned int dummy5:1;
      unsigned int dummy6:1;
      unsigned int dummy7:1;
      unsigned int dummy8:1;
      unsigned int dummy9:1;
      unsigned int dummy10:1;
      unsigned int dummy11:1;
      unsigned int dummy12:1;
      unsigned int dummy13:1;
      unsigned int dummy14:1;
      unsigned int dummy15:1;
   };
   union {
      tU16 u16Value;
      rBitValues bits;
   };

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual tBool operator==(const fi_tcl_b16_UPOI_Source& rfoCmp) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   virtual tS32 s32GetTypeId() const { return typesfi_tclToken::EN_B16_UPOI_SOURCE;}
   virtual tVoid vTakeVisitor(fi_tclVisitorBase& rfoVisitor);
};

class fi_tcl_b8_UPOI_FilterSetStatus : public fi_tclVisitableTypeBase
{
public:
   fi_tcl_b8_UPOI_FilterSetStatus():u8Value(0) {}

   enum {
      FI_C_U8_BIT_FAVOURITE = 0x1UL
   };
   tBool bfavourite() const {return (u8Value & FI_C_U8_BIT_FAVOURITE) != 0; }
   tVoid vSetfavourite(tBool bSetBit) { u8Value = (bSetBit)?(u8Value | FI_C_U8_BIT_FAVOURITE):(u8Value & ~FI_C_U8_BIT_FAVOURITE); }
   struct rBitValues {
      unsigned int favourite:1;
      unsigned int dummy1:1;
      unsigned int dummy2:1;
      unsigned int dummy3:1;
      unsigned int dummy4:1;
      unsigned int dummy5:1;
      unsigned int dummy6:1;
      unsigned int dummy7:1;
   };
   union {
      tU8 u8Value;
      rBitValues bits;
   };

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual tBool operator==(const fi_tcl_b8_UPOI_FilterSetStatus& rfoCmp) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   virtual tS32 s32GetTypeId() const { return typesfi_tclToken::EN_B8_UPOI_FILTERSETSTATUS;}
   virtual tVoid vTakeVisitor(fi_tclVisitorBase& rfoVisitor);
};

class fi_tcl_e8_UPOI_AnnouncementDistance : public fi_tclVisitableTypeBase
{
public:
   fi_tcl_e8_UPOI_AnnouncementDistance():enType(FI_EN_OFF) {}

   enum tenType {
      FI_EN_OFF = 0UL,
      FI_EN_SHORT = 1UL,
      FI_EN_LONG = 2UL
   };
   tenType enType;

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual tBool operator==(const fi_tcl_e8_UPOI_AnnouncementDistance& rfoCmp) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   virtual tS32 s32GetTypeId() const { return typesfi_tclToken::EN_E8_UPOI_ANNOUNCEMENTDISTANCE;}
   virtual tVoid vTakeVisitor(fi_tclVisitorBase& rfoVisitor);
};

class fi_tcl_b8_UPOI_AnnouncementStatus : public fi_tclVisitableTypeBase
{
public:
   fi_tcl_b8_UPOI_AnnouncementStatus():u8Value(0) {}

   enum {
      FI_C_U8_BIT_SYMBOLICENABLED = 0x1UL,
      FI_C_U8_BIT_ACOUSTICENABLED = 0x2UL,
      FI_C_U8_BIT_MULTIPOIACOUSTICENABLED = 0x4UL,
      FI_C_U8_BIT_USENEARPATHES = 0x8UL
   };
   tBool bSymbolicEnabled() const {return (u8Value & FI_C_U8_BIT_SYMBOLICENABLED) != 0; }
   tVoid vSetSymbolicEnabled(tBool bSetBit) { u8Value = (bSetBit)?(u8Value | FI_C_U8_BIT_SYMBOLICENABLED):(u8Value & ~FI_C_U8_BIT_SYMBOLICENABLED); }
   tBool bAcousticEnabled() const {return (u8Value & FI_C_U8_BIT_ACOUSTICENABLED) != 0; }
   tVoid vSetAcousticEnabled(tBool bSetBit) { u8Value = (bSetBit)?(u8Value | FI_C_U8_BIT_ACOUSTICENABLED):(u8Value & ~FI_C_U8_BIT_ACOUSTICENABLED); }
   tBool bMultiPOIAcousticEnabled() const {return (u8Value & FI_C_U8_BIT_MULTIPOIACOUSTICENABLED) != 0; }
   tVoid vSetMultiPOIAcousticEnabled(tBool bSetBit) { u8Value = (bSetBit)?(u8Value | FI_C_U8_BIT_MULTIPOIACOUSTICENABLED):(u8Value & ~FI_C_U8_BIT_MULTIPOIACOUSTICENABLED); }
   tBool bUseNearPathes() const {return (u8Value & FI_C_U8_BIT_USENEARPATHES) != 0; }
   tVoid vSetUseNearPathes(tBool bSetBit) { u8Value = (bSetBit)?(u8Value | FI_C_U8_BIT_USENEARPATHES):(u8Value & ~FI_C_U8_BIT_USENEARPATHES); }
   struct rBitValues {
      unsigned int SymbolicEnabled:1;
      unsigned int AcousticEnabled:1;
      unsigned int MultiPOIAcousticEnabled:1;
      unsigned int UseNearPathes:1;
      unsigned int dummy4:1;
      unsigned int dummy5:1;
      unsigned int dummy6:1;
      unsigned int dummy7:1;
   };
   union {
      tU8 u8Value;
      rBitValues bits;
   };

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual tBool operator==(const fi_tcl_b8_UPOI_AnnouncementStatus& rfoCmp) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   virtual tS32 s32GetTypeId() const { return typesfi_tclToken::EN_B8_UPOI_ANNOUNCEMENTSTATUS;}
   virtual tVoid vTakeVisitor(fi_tclVisitorBase& rfoVisitor);
};

class fi_tcl_b8_UPOI_Validity : public fi_tclVisitableTypeBase
{
public:
   fi_tcl_b8_UPOI_Validity():u8Value(0) {}

   enum {
      FI_C_U8_BIT_ONROADOFFSETVALID = 0x1UL,
      FI_C_U8_BIT_PERPENDICULARPOINTPOSITIONVALID = 0x2UL
   };
   tBool bOnRoadOffsetValid() const {return (u8Value & FI_C_U8_BIT_ONROADOFFSETVALID) != 0; }
   tVoid vSetOnRoadOffsetValid(tBool bSetBit) { u8Value = (bSetBit)?(u8Value | FI_C_U8_BIT_ONROADOFFSETVALID):(u8Value & ~FI_C_U8_BIT_ONROADOFFSETVALID); }
   tBool bPerpendicularPointPositionValid() const {return (u8Value & FI_C_U8_BIT_PERPENDICULARPOINTPOSITIONVALID) != 0; }
   tVoid vSetPerpendicularPointPositionValid(tBool bSetBit) { u8Value = (bSetBit)?(u8Value | FI_C_U8_BIT_PERPENDICULARPOINTPOSITIONVALID):(u8Value & ~FI_C_U8_BIT_PERPENDICULARPOINTPOSITIONVALID); }
   struct rBitValues {
      unsigned int OnRoadOffsetValid:1;
      unsigned int PerpendicularPointPositionValid:1;
      unsigned int dummy2:1;
      unsigned int dummy3:1;
      unsigned int dummy4:1;
      unsigned int dummy5:1;
      unsigned int dummy6:1;
      unsigned int dummy7:1;
   };
   union {
      tU8 u8Value;
      rBitValues bits;
   };

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual tBool operator==(const fi_tcl_b8_UPOI_Validity& rfoCmp) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   virtual tS32 s32GetTypeId() const { return typesfi_tclToken::EN_B8_UPOI_VALIDITY;}
   virtual tVoid vTakeVisitor(fi_tclVisitorBase& rfoVisitor);
};

class fi_tcl_UPOI_Element : public fi_tclVisitableTypeBase
{
public:
   fi_tcl_UPOI_Element():UniqueID(0),Category(),Source(),Name(),ShortDescription(),Position(),PerpendicularPointPosition() {}
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   fi_tcl_UPOI_Element& operator=(const fi_tcl_UPOI_Element& coRef);
   fi_tcl_UPOI_Element(const fi_tcl_UPOI_Element& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
   tU32 UniqueID;
   fi_tcl_UPOI_Category Category;
   fi_tcl_e8_UPOI_Source Source;
   fi_tclString Name;
   fi_tclString ShortDescription;
   fi_tcl_PositionWGS84 Position;
   fi_tcl_PositionWGS84 PerpendicularPointPosition;

   virtual tVoid vDestroy();
   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual tBool operator==(const fi_tcl_UPOI_Element& rfoCmp) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   virtual tS32 s32GetTypeId() const { return typesfi_tclToken::EN_UPOI_ELEMENT;}
   virtual tVoid vTakeVisitor(fi_tclVisitorBase& rfoVisitor);
};

class fi_tcl_b8_UPOI_FilterSet_FieldRelevance : public fi_tclVisitableTypeBase
{
public:
   fi_tcl_b8_UPOI_FilterSet_FieldRelevance():u8Value(0) {}

   enum {
      FI_C_U8_BIT_SOURCE = 0x1UL,
      FI_C_U8_BIT_CATEGORY = 0x2UL,
      FI_C_U8_BIT_STATUS = 0x4UL
   };
   tBool bSource() const {return (u8Value & FI_C_U8_BIT_SOURCE) != 0; }
   tVoid vSetSource(tBool bSetBit) { u8Value = (bSetBit)?(u8Value | FI_C_U8_BIT_SOURCE):(u8Value & ~FI_C_U8_BIT_SOURCE); }
   tBool bCategory() const {return (u8Value & FI_C_U8_BIT_CATEGORY) != 0; }
   tVoid vSetCategory(tBool bSetBit) { u8Value = (bSetBit)?(u8Value | FI_C_U8_BIT_CATEGORY):(u8Value & ~FI_C_U8_BIT_CATEGORY); }
   tBool bStatus() const {return (u8Value & FI_C_U8_BIT_STATUS) != 0; }
   tVoid vSetStatus(tBool bSetBit) { u8Value = (bSetBit)?(u8Value | FI_C_U8_BIT_STATUS):(u8Value & ~FI_C_U8_BIT_STATUS); }
   struct rBitValues {
      unsigned int Source:1;
      unsigned int Category:1;
      unsigned int Status:1;
      unsigned int dummy3:1;
      unsigned int dummy4:1;
      unsigned int dummy5:1;
      unsigned int dummy6:1;
      unsigned int dummy7:1;
   };
   union {
      tU8 u8Value;
      rBitValues bits;
   };

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual tBool operator==(const fi_tcl_b8_UPOI_FilterSet_FieldRelevance& rfoCmp) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   virtual tS32 s32GetTypeId() const { return typesfi_tclToken::EN_B8_UPOI_FILTERSET_FIELDRELEVANCE;}
   virtual tVoid vTakeVisitor(fi_tclVisitorBase& rfoVisitor);
};

class fi_tcl_UPOI_FilterSet : public fi_tclVisitableTypeBase
{
public:
   fi_tcl_UPOI_FilterSet():Relevance(),Source(),Category(),Status() {}
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   fi_tcl_UPOI_FilterSet& operator=(const fi_tcl_UPOI_FilterSet& coRef);
   fi_tcl_UPOI_FilterSet(const fi_tcl_UPOI_FilterSet& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
   fi_tcl_b8_UPOI_FilterSet_FieldRelevance Relevance;
   fi_tcl_e8_UPOI_Source Source;
   fi_tcl_UPOI_Category Category;
   fi_tcl_b8_UPOI_FilterSetStatus Status;

   virtual tVoid vDestroy();
   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual tBool operator==(const fi_tcl_UPOI_FilterSet& rfoCmp) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   virtual tS32 s32GetTypeId() const { return typesfi_tclToken::EN_UPOI_FILTERSET;}
   virtual tVoid vTakeVisitor(fi_tclVisitorBase& rfoVisitor);
};

class fi_tcl_UPOI_FilterList : public fi_tclVisitableTypeBase
{
public:
   fi_tcl_UPOI_FilterList() {}
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   fi_tcl_UPOI_FilterList& operator=(const fi_tcl_UPOI_FilterList& coRef);
   fi_tcl_UPOI_FilterList(const fi_tcl_UPOI_FilterList& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
   std::vector<fi_tcl_UPOI_FilterSet, std::allocator<fi_tcl_UPOI_FilterSet> > List;

   virtual tVoid vDestroy();
   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual tBool operator==(const fi_tcl_UPOI_FilterList& rfoCmp) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   virtual tS32 s32GetTypeId() const { return typesfi_tclToken::EN_UPOI_FILTERLIST;}
   virtual tVoid vTakeVisitor(fi_tclVisitorBase& rfoVisitor);
};

class fi_tcl_UPOI_CategoryConfiguration : public fi_tclVisitableTypeBase
{
public:
   fi_tcl_UPOI_CategoryConfiguration():FilterSet(),AnnouncementDistance(),AnnouncementStatus() {}
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   fi_tcl_UPOI_CategoryConfiguration& operator=(const fi_tcl_UPOI_CategoryConfiguration& coRef);
   fi_tcl_UPOI_CategoryConfiguration(const fi_tcl_UPOI_CategoryConfiguration& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
   fi_tcl_UPOI_FilterSet FilterSet;
   fi_tcl_e8_UPOI_AnnouncementDistance AnnouncementDistance;
   fi_tcl_b8_UPOI_AnnouncementStatus AnnouncementStatus;

   virtual tVoid vDestroy();
   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual tBool operator==(const fi_tcl_UPOI_CategoryConfiguration& rfoCmp) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   virtual tS32 s32GetTypeId() const { return typesfi_tclToken::EN_UPOI_CATEGORYCONFIGURATION;}
   virtual tVoid vTakeVisitor(fi_tclVisitorBase& rfoVisitor);
};

class fi_tcl_UPOI_CategoryConfigurationList : public fi_tclVisitableTypeBase
{
public:
   fi_tcl_UPOI_CategoryConfigurationList() {}
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   fi_tcl_UPOI_CategoryConfigurationList& operator=(const fi_tcl_UPOI_CategoryConfigurationList& coRef);
   fi_tcl_UPOI_CategoryConfigurationList(const fi_tcl_UPOI_CategoryConfigurationList& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
   std::vector<fi_tcl_UPOI_CategoryConfiguration, std::allocator<fi_tcl_UPOI_CategoryConfiguration> > List;

   virtual tVoid vDestroy();
   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual tBool operator==(const fi_tcl_UPOI_CategoryConfigurationList& rfoCmp) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   virtual tS32 s32GetTypeId() const { return typesfi_tclToken::EN_UPOI_CATEGORYCONFIGURATIONLIST;}
   virtual tVoid vTakeVisitor(fi_tclVisitorBase& rfoVisitor);
};

class fi_tcl_b8_UPOI_Status : public fi_tclVisitableTypeBase
{
public:
   fi_tcl_b8_UPOI_Status():u8Value(0) {}

   enum {
      FI_C_U8_BIT_ONROAD = 0x1UL
   };
   tBool bOnRoad() const {return (u8Value & FI_C_U8_BIT_ONROAD) != 0; }
   tVoid vSetOnRoad(tBool bSetBit) { u8Value = (bSetBit)?(u8Value | FI_C_U8_BIT_ONROAD):(u8Value & ~FI_C_U8_BIT_ONROAD); }
   struct rBitValues {
      unsigned int OnRoad:1;
      unsigned int dummy1:1;
      unsigned int dummy2:1;
      unsigned int dummy3:1;
      unsigned int dummy4:1;
      unsigned int dummy5:1;
      unsigned int dummy6:1;
      unsigned int dummy7:1;
   };
   union {
      tU8 u8Value;
      rBitValues bits;
   };

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual tBool operator==(const fi_tcl_b8_UPOI_Status& rfoCmp) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   virtual tS32 s32GetTypeId() const { return typesfi_tclToken::EN_B8_UPOI_STATUS;}
   virtual tVoid vTakeVisitor(fi_tclVisitorBase& rfoVisitor);
};

class fi_tcl_UPOI_Combination : public fi_tclVisitableTypeBase
{
public:
   fi_tcl_UPOI_Combination():BaseList(),RefList(),ID(0),DataValidity(),OnRoadOffset(),PerpendicularPointPosition(),UPOIStatus() {}
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   fi_tcl_UPOI_Combination& operator=(const fi_tcl_UPOI_Combination& coRef);
   fi_tcl_UPOI_Combination(const fi_tcl_UPOI_Combination& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
   fi_tcl_u16_IndexInReferenceList BaseList;
   fi_tcl_u16_IndexInReferenceList RefList;
   tU32 ID;
   fi_tcl_b8_UPOI_Validity DataValidity;
   fi_tcl_s16_PerThousand OnRoadOffset;
   fi_tcl_PositionWGS84 PerpendicularPointPosition;
   fi_tcl_b8_UPOI_Status UPOIStatus;

   virtual tVoid vDestroy();
   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual tBool operator==(const fi_tcl_UPOI_Combination& rfoCmp) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   virtual tS32 s32GetTypeId() const { return typesfi_tclToken::EN_UPOI_COMBINATION;}
   virtual tVoid vTakeVisitor(fi_tclVisitorBase& rfoVisitor);
};

class fi_tcl_UPOI_ListSet : public fi_tclVisitableTypeBase
{
public:
   fi_tcl_UPOI_ListSet() {}
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   fi_tcl_UPOI_ListSet& operator=(const fi_tcl_UPOI_ListSet& coRef);
   fi_tcl_UPOI_ListSet(const fi_tcl_UPOI_ListSet& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
   std::vector<fi_tcl_UPOI_Combination, std::allocator<fi_tcl_UPOI_Combination> > CombinationList;
   std::vector<fi_tcl_UPOI_Element, std::allocator<fi_tcl_UPOI_Element> > UPOI_RefList;

   virtual tVoid vDestroy();
   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual tBool operator==(const fi_tcl_UPOI_ListSet& rfoCmp) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   virtual tS32 s32GetTypeId() const { return typesfi_tclToken::EN_UPOI_LISTSET;}
   virtual tVoid vTakeVisitor(fi_tclVisitorBase& rfoVisitor);
};

class fi_tcl_ClockTime : public fi_tclVisitableTypeBase
{
public:
   fi_tcl_ClockTime():Hour(0),Minute(0),Second(0) {}
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   fi_tcl_ClockTime& operator=(const fi_tcl_ClockTime& coRef);
   fi_tcl_ClockTime(const fi_tcl_ClockTime& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
   tU8 Hour;
   tU8 Minute;
   tU8 Second;

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual tBool operator==(const fi_tcl_ClockTime& rfoCmp) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   virtual tS32 s32GetTypeId() const { return typesfi_tclToken::EN_CLOCKTIME;}
   virtual tVoid vTakeVisitor(fi_tclVisitorBase& rfoVisitor);
};

class fi_tcl_Date : public fi_tclVisitableTypeBase
{
public:
   fi_tcl_Date():Year(0),Month(0),Day(0) {}
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   fi_tcl_Date& operator=(const fi_tcl_Date& coRef);
   fi_tcl_Date(const fi_tcl_Date& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
   tU16 Year;
   tU8 Month;
   tU8 Day;

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual tBool operator==(const fi_tcl_Date& rfoCmp) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   virtual tS32 s32GetTypeId() const { return typesfi_tclToken::EN_DATE;}
   virtual tVoid vTakeVisitor(fi_tclVisitorBase& rfoVisitor);
};

class fi_tcl_VersionInfo : public fi_tclVisitableTypeBase
{
public:
   fi_tcl_VersionInfo():Manufacturer(),ProductionDate(),ProductVersion() {}
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   fi_tcl_VersionInfo& operator=(const fi_tcl_VersionInfo& coRef);
   fi_tcl_VersionInfo(const fi_tcl_VersionInfo& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
   fi_tclString Manufacturer;
   fi_tclString ProductionDate;
   fi_tclString ProductVersion;

   virtual tVoid vDestroy();
   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual tBool operator==(const fi_tcl_VersionInfo& rfoCmp) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   virtual tS32 s32GetTypeId() const { return typesfi_tclToken::EN_VERSIONINFO;}
   virtual tVoid vTakeVisitor(fi_tclVisitorBase& rfoVisitor);
};

class fi_tcl_e8_GPSFix : public fi_tclVisitableTypeBase
{
public:
   fi_tcl_e8_GPSFix():enType(FI_EN_RESERVED) {}

   enum tenType {
      FI_EN_RESERVED = 0UL,
      FI_EN_NOTAVAILABLE = 1UL,
      FI_EN_NOFIX = 2UL,
      FI_EN_2DFIX = 3UL,
      FI_EN_3DFIX = 4UL,
      FI_EN_TIMEFIX = 5UL,
      FI_EN_ANTENNANOTPROPERLYCONNECTED_OPEN = 6UL,
      FI_EN_ANTENNANOTPROPERLYCONNECTED_SHORTCIRCUIT = 7UL
   };
   tenType enType;

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual tBool operator==(const fi_tcl_e8_GPSFix& rfoCmp) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   virtual tS32 s32GetTypeId() const { return typesfi_tclToken::EN_E8_GPSFIX;}
   virtual tVoid vTakeVisitor(fi_tclVisitorBase& rfoVisitor);
};

class fi_tcl_GPSAdditionalInformation : public fi_tclVisitableTypeBase
{
public:
   fi_tcl_GPSAdditionalInformation():Fix(),HDOP(0),VDOP(0),Heading(),Speed(),Height() {}
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   fi_tcl_GPSAdditionalInformation& operator=(const fi_tcl_GPSAdditionalInformation& coRef);
   fi_tcl_GPSAdditionalInformation(const fi_tcl_GPSAdditionalInformation& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
   fi_tcl_e8_GPSFix Fix;
   tU8 HDOP;
   tU8 VDOP;
   fi_tcl_u8_DirectionAbsolute Heading;
   fi_tcl_s16_CentimeterSecond Speed;
   fi_tcl_s32_Meter Height;

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual tBool operator==(const fi_tcl_GPSAdditionalInformation& rfoCmp) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   virtual tS32 s32GetTypeId() const { return typesfi_tclToken::EN_GPSADDITIONALINFORMATION;}
   virtual tVoid vTakeVisitor(fi_tclVisitorBase& rfoVisitor);
};

class fi_tcl_e8_GPSChannelStatus : public fi_tclVisitableTypeBase
{
public:
   fi_tcl_e8_GPSChannelStatus():enType(FI_EN_NOTUSED) {}

   enum tenType {
      FI_EN_NOTUSED = 0UL,
      FI_EN_SEARCHING = 1UL,
      FI_EN_TRACKING = 2UL,
      FI_EN_EPHEMERISOK = 3UL,
      FI_EN_USEDFORFIX = 4UL
   };
   tenType enType;

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual tBool operator==(const fi_tcl_e8_GPSChannelStatus& rfoCmp) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   virtual tS32 s32GetTypeId() const { return typesfi_tclToken::EN_E8_GPSCHANNELSTATUS;}
   virtual tVoid vTakeVisitor(fi_tclVisitorBase& rfoVisitor);
};

class fi_tcl_s8_ElevationRelative : public fi_tclVisitableTypeBase
{
public:
   fi_tcl_s8_ElevationRelative(tS8 _s8Value = 0):s8Value(_s8Value) {} 

   tS8 s8Value;

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual tBool operator==(const fi_tcl_s8_ElevationRelative& rfoCmp) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   virtual tS32 s32GetTypeId() const { return typesfi_tclToken::EN_S8_ELEVATIONRELATIVE;}
   virtual tVoid vTakeVisitor(fi_tclVisitorBase& rfoVisitor);
};

class fi_tcl_GPSChannelInformation : public fi_tclVisitableTypeBase
{
public:
   fi_tcl_GPSChannelInformation():SatelliteId(0),ChannelStatus(),Azimuth(),Elevation(),CarrierToNoiseRatio(0) {}
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   fi_tcl_GPSChannelInformation& operator=(const fi_tcl_GPSChannelInformation& coRef);
   fi_tcl_GPSChannelInformation(const fi_tcl_GPSChannelInformation& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
   tU8 SatelliteId;
   fi_tcl_e8_GPSChannelStatus ChannelStatus;
   fi_tcl_u8_DirectionRelative Azimuth;
   fi_tcl_s8_ElevationRelative Elevation;
   tS8 CarrierToNoiseRatio;

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual tBool operator==(const fi_tcl_GPSChannelInformation& rfoCmp) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   virtual tS32 s32GetTypeId() const { return typesfi_tclToken::EN_GPSCHANNELINFORMATION;}
   virtual tVoid vTakeVisitor(fi_tclVisitorBase& rfoVisitor);
};

class fi_tcl_TMMapRef : public fi_tclVisitableTypeBase
{
public:
   fi_tcl_TMMapRef() {}
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   fi_tcl_TMMapRef& operator=(const fi_tcl_TMMapRef& coRef);
   fi_tcl_TMMapRef(const fi_tcl_TMMapRef& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
   std::vector<tU8, std::allocator<tU8> > ElementCount;

   virtual tVoid vDestroy();
   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual tBool operator==(const fi_tcl_TMMapRef& rfoCmp) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   virtual tS32 s32GetTypeId() const { return typesfi_tclToken::EN_TMMAPREF;}
   virtual tVoid vTakeVisitor(fi_tclVisitorBase& rfoVisitor);
};

class fi_tcl_UTMDesc : public fi_tclVisitableTypeBase
{
public:
   fi_tcl_UTMDesc():NaviEventValue(),StartElement(),StartOffset(),UTMLength(),NavUTMContainer() {}
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   fi_tcl_UTMDesc& operator=(const fi_tcl_UTMDesc& coRef);
   fi_tcl_UTMDesc(const fi_tcl_UTMDesc& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
   fi_tcl_e16_NaviEventValue NaviEventValue;
   fi_tcl_u16_IndexInReferenceList StartElement;
   fi_tcl_s32_Meter StartOffset;
   fi_tcl_s32_Meter UTMLength;
   fi_tcl_BinContainer NavUTMContainer;

   virtual tVoid vDestroy();
   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual tBool operator==(const fi_tcl_UTMDesc& rfoCmp) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   virtual tS32 s32GetTypeId() const { return typesfi_tclToken::EN_UTMDESC;}
   virtual tVoid vTakeVisitor(fi_tclVisitorBase& rfoVisitor);
};

class fi_tcl_UTMDescByTM : public fi_tclVisitableTypeBase
{
public:
   fi_tcl_UTMDescByTM():TrafficMessageRevision(0),TrafficMessageID(0),NaviEventValue() {}
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   fi_tcl_UTMDescByTM& operator=(const fi_tcl_UTMDescByTM& coRef);
   fi_tcl_UTMDescByTM(const fi_tcl_UTMDescByTM& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
   tU32 TrafficMessageRevision;
   tU32 TrafficMessageID;
   fi_tcl_e16_NaviEventValue NaviEventValue;

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual tBool operator==(const fi_tcl_UTMDescByTM& rfoCmp) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   virtual tS32 s32GetTypeId() const { return typesfi_tclToken::EN_UTMDESCBYTM;}
   virtual tVoid vTakeVisitor(fi_tclVisitorBase& rfoVisitor);
};

class fi_tcl_b16_PositionReliability : public fi_tclVisitableTypeBase
{
public:
   fi_tcl_b16_PositionReliability():u16Value(0) {}

   enum {
      FI_C_U16_BIT_CALIBRATED = 0x1UL,
      FI_C_U16_BIT_MATCHEDTODIGITALMAP = 0x2UL,
      FI_C_U16_BIT_FULLYDIGITIZEDAREA = 0x4UL,
      FI_C_U16_BIT_INSIDEDIGITIZEDAREA = 0x8UL,
      FI_C_U16_BIT_DEADRECKONINGAVAILABLE = 0x10UL,
      FI_C_U16_BIT_DIFFERENTIALGPSPOSITIONDATAAVAILABLE = 0x20UL,
      FI_C_U16_BIT_GPSPOSITIONDATAAVAILABLE = 0x40UL,
      FI_C_U16_BIT_GPSCOMPLETEBLOCKAGE = 0x80UL,
      FI_C_U16_BIT_MATCHINGALLOWEDREVERSETOHARDONEWAY = 0x100UL
   };
   tBool bCalibrated() const {return (u16Value & FI_C_U16_BIT_CALIBRATED) != 0; }
   tVoid vSetCalibrated(tBool bSetBit) { u16Value = (bSetBit)?(u16Value | FI_C_U16_BIT_CALIBRATED):(u16Value & ~FI_C_U16_BIT_CALIBRATED); }
   tBool bMatchedToDigitalMap() const {return (u16Value & FI_C_U16_BIT_MATCHEDTODIGITALMAP) != 0; }
   tVoid vSetMatchedToDigitalMap(tBool bSetBit) { u16Value = (bSetBit)?(u16Value | FI_C_U16_BIT_MATCHEDTODIGITALMAP):(u16Value & ~FI_C_U16_BIT_MATCHEDTODIGITALMAP); }
   tBool bFullyDigitizedArea() const {return (u16Value & FI_C_U16_BIT_FULLYDIGITIZEDAREA) != 0; }
   tVoid vSetFullyDigitizedArea(tBool bSetBit) { u16Value = (bSetBit)?(u16Value | FI_C_U16_BIT_FULLYDIGITIZEDAREA):(u16Value & ~FI_C_U16_BIT_FULLYDIGITIZEDAREA); }
   tBool bInsideDigitizedArea() const {return (u16Value & FI_C_U16_BIT_INSIDEDIGITIZEDAREA) != 0; }
   tVoid vSetInsideDigitizedArea(tBool bSetBit) { u16Value = (bSetBit)?(u16Value | FI_C_U16_BIT_INSIDEDIGITIZEDAREA):(u16Value & ~FI_C_U16_BIT_INSIDEDIGITIZEDAREA); }
   tBool bDeadReckoningAvailable() const {return (u16Value & FI_C_U16_BIT_DEADRECKONINGAVAILABLE) != 0; }
   tVoid vSetDeadReckoningAvailable(tBool bSetBit) { u16Value = (bSetBit)?(u16Value | FI_C_U16_BIT_DEADRECKONINGAVAILABLE):(u16Value & ~FI_C_U16_BIT_DEADRECKONINGAVAILABLE); }
   tBool bDifferentialGPSPositionDataAvailable() const {return (u16Value & FI_C_U16_BIT_DIFFERENTIALGPSPOSITIONDATAAVAILABLE) != 0; }
   tVoid vSetDifferentialGPSPositionDataAvailable(tBool bSetBit) { u16Value = (bSetBit)?(u16Value | FI_C_U16_BIT_DIFFERENTIALGPSPOSITIONDATAAVAILABLE):(u16Value & ~FI_C_U16_BIT_DIFFERENTIALGPSPOSITIONDATAAVAILABLE); }
   tBool bGPSPositionDataAvailable() const {return (u16Value & FI_C_U16_BIT_GPSPOSITIONDATAAVAILABLE) != 0; }
   tVoid vSetGPSPositionDataAvailable(tBool bSetBit) { u16Value = (bSetBit)?(u16Value | FI_C_U16_BIT_GPSPOSITIONDATAAVAILABLE):(u16Value & ~FI_C_U16_BIT_GPSPOSITIONDATAAVAILABLE); }
   tBool bGPSCompleteBlockage() const {return (u16Value & FI_C_U16_BIT_GPSCOMPLETEBLOCKAGE) != 0; }
   tVoid vSetGPSCompleteBlockage(tBool bSetBit) { u16Value = (bSetBit)?(u16Value | FI_C_U16_BIT_GPSCOMPLETEBLOCKAGE):(u16Value & ~FI_C_U16_BIT_GPSCOMPLETEBLOCKAGE); }
   tBool bMatchingAllowedReverseToHardOneway() const {return (u16Value & FI_C_U16_BIT_MATCHINGALLOWEDREVERSETOHARDONEWAY) != 0; }
   tVoid vSetMatchingAllowedReverseToHardOneway(tBool bSetBit) { u16Value = (bSetBit)?(u16Value | FI_C_U16_BIT_MATCHINGALLOWEDREVERSETOHARDONEWAY):(u16Value & ~FI_C_U16_BIT_MATCHINGALLOWEDREVERSETOHARDONEWAY); }
   struct rBitValues {
      unsigned int Calibrated:1;
      unsigned int MatchedToDigitalMap:1;
      unsigned int FullyDigitizedArea:1;
      unsigned int InsideDigitizedArea:1;
      unsigned int DeadReckoningAvailable:1;
      unsigned int DifferentialGPSPositionDataAvailable:1;
      unsigned int GPSPositionDataAvailable:1;
      unsigned int GPSCompleteBlockage:1;
      unsigned int MatchingAllowedReverseToHardOneway:1;
      unsigned int dummy9:1;
      unsigned int dummy10:1;
      unsigned int dummy11:1;
      unsigned int dummy12:1;
      unsigned int dummy13:1;
      unsigned int dummy14:1;
      unsigned int dummy15:1;
   };
   union {
      tU16 u16Value;
      rBitValues bits;
   };

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual tBool operator==(const fi_tcl_b16_PositionReliability& rfoCmp) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   virtual tS32 s32GetTypeId() const { return typesfi_tclToken::EN_B16_POSITIONRELIABILITY;}
   virtual tVoid vTakeVisitor(fi_tclVisitorBase& rfoVisitor);
};

class fi_tcl_PositionHeadingSpeed : public fi_tclVisitableTypeBase
{
public:
   fi_tcl_PositionHeadingSpeed():PositionWGS84(),PositionReliability(),Speed(),Heading() {}
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   fi_tcl_PositionHeadingSpeed& operator=(const fi_tcl_PositionHeadingSpeed& coRef);
   fi_tcl_PositionHeadingSpeed(const fi_tcl_PositionHeadingSpeed& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
   fi_tcl_PositionWGS84 PositionWGS84;
   fi_tcl_b16_PositionReliability PositionReliability;
   fi_tcl_s16_CentimeterSecond Speed;
   fi_tcl_u8_DirectionAbsolute Heading;

   virtual tVoid vDestroy();
   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual tBool operator==(const fi_tcl_PositionHeadingSpeed& rfoCmp) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   virtual tS32 s32GetTypeId() const { return typesfi_tclToken::EN_POSITIONHEADINGSPEED;}
   virtual tVoid vTakeVisitor(fi_tclVisitorBase& rfoVisitor);
};

class fi_tcl_e8_InfoStatus : public fi_tclVisitableTypeBase
{
public:
   fi_tcl_e8_InfoStatus():enType(FI_EN_INVALID) {}

   enum tenType {
      FI_EN_INVALID = 0UL,
      FI_EN_PARTIAL = 1UL,
      FI_EN_CHANGE = 2UL,
      FI_EN_COMPLETE = 3UL,
      FI_EN_NOMOREDATA = 4UL
   };
   tenType enType;

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual tBool operator==(const fi_tcl_e8_InfoStatus& rfoCmp) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   virtual tS32 s32GetTypeId() const { return typesfi_tclToken::EN_E8_INFOSTATUS;}
   virtual tVoid vTakeVisitor(fi_tclVisitorBase& rfoVisitor);
};

class fi_tcl_InfoStatus : public fi_tclVisitableTypeBase
{
public:
   fi_tcl_InfoStatus():InfoCounter(0),Status() {}
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   fi_tcl_InfoStatus& operator=(const fi_tcl_InfoStatus& coRef);
   fi_tcl_InfoStatus(const fi_tcl_InfoStatus& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
   tU16 InfoCounter;
   fi_tcl_e8_InfoStatus Status;

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual tBool operator==(const fi_tcl_InfoStatus& rfoCmp) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   virtual tS32 s32GetTypeId() const { return typesfi_tclToken::EN_INFOSTATUS;}
   virtual tVoid vTakeVisitor(fi_tclVisitorBase& rfoVisitor);
};

class fi_tcl_DirectionInfoListSet : public fi_tclVisitableTypeBase
{
public:
   fi_tcl_DirectionInfoListSet() {}
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   fi_tcl_DirectionInfoListSet& operator=(const fi_tcl_DirectionInfoListSet& coRef);
   fi_tcl_DirectionInfoListSet(const fi_tcl_DirectionInfoListSet& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
   std::vector<fi_tcl_ReferenceElement, std::allocator<fi_tcl_ReferenceElement> > AlternativRefList;
   std::vector<fi_tcl_DirectionInfo, std::allocator<fi_tcl_DirectionInfo> > DirectionInfoList;

   virtual tVoid vDestroy();
   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual tBool operator==(const fi_tcl_DirectionInfoListSet& rfoCmp) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   virtual tS32 s32GetTypeId() const { return typesfi_tclToken::EN_DIRECTIONINFOLISTSET;}
   virtual tVoid vTakeVisitor(fi_tclVisitorBase& rfoVisitor);
};

class fi_tcl_ReferenceElementWithID : public fi_tclVisitableTypeBase
{
public:
   fi_tcl_ReferenceElementWithID():BaseList(),RefList(),ID(0) {}
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   fi_tcl_ReferenceElementWithID& operator=(const fi_tcl_ReferenceElementWithID& coRef);
   fi_tcl_ReferenceElementWithID(const fi_tcl_ReferenceElementWithID& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
   fi_tcl_u16_IndexInReferenceList BaseList;
   fi_tcl_u16_IndexInReferenceList RefList;
   tU32 ID;

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual tBool operator==(const fi_tcl_ReferenceElementWithID& rfoCmp) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   virtual tS32 s32GetTypeId() const { return typesfi_tclToken::EN_REFERENCEELEMENTWITHID;}
   virtual tVoid vTakeVisitor(fi_tclVisitorBase& rfoVisitor);
};

class fi_tcl_e8_SingleRoadInfoCategory : public fi_tclVisitableTypeBase
{
public:
   fi_tcl_e8_SingleRoadInfoCategory():enType(FI_EN_T_RESERVED) {}

   enum tenType {
      FI_EN_T_RESERVED = 0UL,
      FI_EN_T_COUNTRYNAMEELEMENT = 1UL,
      FI_EN_T_STATENAMEELEMENT = 2UL,
      FI_EN_T_COUNTYNAMEELEMENT = 3UL,
      FI_EN_T_CITYNAMEELEMENT = 4UL,
      FI_EN_T_CITYDISTRICTNAMEELEMENT = 5UL,
      FI_EN_T_BUILDUPAREANAMEELEMENT = 6UL,
      FI_EN_T_ROADNAMEELEMENTLIST = 7UL,
      FI_EN_T_ROADNUMBERELEMENTLIST = 8UL,
      FI_EN_T_EXTRADESCELEMENT = 19UL,
      FI_EN_T_DATADESCELEMENT = 20UL,
      FI_EN_T_INTERSECTIONDESCELEMENT = 21UL,
      FI_EN_T_TRAFFICSIGNLIST = 22UL,
      FI_EN_T_DIRECTIONINFOLIST = 25UL,
      FI_EN_T_REQUIREDPERMISSIONLIST = 29UL,
      FI_EN_T_TIMEZONEELEMENT = 35UL
   };
   tenType enType;

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual tBool operator==(const fi_tcl_e8_SingleRoadInfoCategory& rfoCmp) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   virtual tS32 s32GetTypeId() const { return typesfi_tclToken::EN_E8_SINGLEROADINFOCATEGORY;}
   virtual tVoid vTakeVisitor(fi_tclVisitorBase& rfoVisitor);
};

class fi_tcl_SingleRoadInfo : public fi_tclVisitableTypeBase
{
public:
   fi_tcl_SingleRoadInfo():poCategoryData(0) {}
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   fi_tcl_SingleRoadInfo& operator=(const fi_tcl_SingleRoadInfo& coRef);
   fi_tcl_SingleRoadInfo(const fi_tcl_SingleRoadInfo& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
   fi_tcl_e8_SingleRoadInfoCategory CategoryType;
   fi_tclTypeBase* poCategoryData;
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   virtual ~fi_tcl_SingleRoadInfo();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   virtual tVoid vDestroy();
   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual tBool operator==(const fi_tcl_SingleRoadInfo& rfoCmp) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   virtual tS32 s32GetTypeId() const { return typesfi_tclToken::EN_SINGLEROADINFO;}
   virtual tVoid vTakeVisitor(fi_tclVisitorBase& rfoVisitor);
};

class fi_tcl_StateNameElement : public fi_tclVisitableTypeBase
{
public:
   fi_tcl_StateNameElement():StateName(0),StateCode_old(0),StateCode(0) {}
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   fi_tcl_StateNameElement& operator=(const fi_tcl_StateNameElement& coRef);
   fi_tcl_StateNameElement(const fi_tcl_StateNameElement& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
   fi_tclMultiLanguageString StateName;
   tU16 StateCode_old;
   tU32 StateCode;

   virtual tVoid vDestroy();
   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual tBool operator==(const fi_tcl_StateNameElement& rfoCmp) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   virtual tS32 s32GetTypeId() const { return typesfi_tclToken::EN_STATENAMEELEMENT;}
   virtual tVoid vTakeVisitor(fi_tclVisitorBase& rfoVisitor);
};

class fi_tcl_CountyNameElement : public fi_tclVisitableTypeBase
{
public:
   fi_tcl_CountyNameElement():CountyName(0) {}
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   fi_tcl_CountyNameElement& operator=(const fi_tcl_CountyNameElement& coRef);
   fi_tcl_CountyNameElement(const fi_tcl_CountyNameElement& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
   fi_tclMultiLanguageString CountyName;

   virtual tVoid vDestroy();
   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual tBool operator==(const fi_tcl_CountyNameElement& rfoCmp) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   virtual tS32 s32GetTypeId() const { return typesfi_tclToken::EN_COUNTYNAMEELEMENT;}
   virtual tVoid vTakeVisitor(fi_tclVisitorBase& rfoVisitor);
};

class fi_tcl_CityDistrictNameElement : public fi_tclVisitableTypeBase
{
public:
   fi_tcl_CityDistrictNameElement():Name(0),Priority(0),Population(0) {}
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   fi_tcl_CityDistrictNameElement& operator=(const fi_tcl_CityDistrictNameElement& coRef);
   fi_tcl_CityDistrictNameElement(const fi_tcl_CityDistrictNameElement& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
   fi_tclMultiLanguageString Name;
   tS8 Priority;
   tU32 Population;

   virtual tVoid vDestroy();
   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual tBool operator==(const fi_tcl_CityDistrictNameElement& rfoCmp) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   virtual tS32 s32GetTypeId() const { return typesfi_tclToken::EN_CITYDISTRICTNAMEELEMENT;}
   virtual tVoid vTakeVisitor(fi_tclVisitorBase& rfoVisitor);
};

class fi_tcl_BuildUpAreaNameElement : public fi_tclVisitableTypeBase
{
public:
   fi_tcl_BuildUpAreaNameElement():Name(0),Priority(0),Population(0) {}
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   fi_tcl_BuildUpAreaNameElement& operator=(const fi_tcl_BuildUpAreaNameElement& coRef);
   fi_tcl_BuildUpAreaNameElement(const fi_tcl_BuildUpAreaNameElement& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
   fi_tclMultiLanguageString Name;
   tS8 Priority;
   tU32 Population;

   virtual tVoid vDestroy();
   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual tBool operator==(const fi_tcl_BuildUpAreaNameElement& rfoCmp) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   virtual tS32 s32GetTypeId() const { return typesfi_tclToken::EN_BUILDUPAREANAMEELEMENT;}
   virtual tVoid vTakeVisitor(fi_tclVisitorBase& rfoVisitor);
};

class fi_tcl_RoadNameElementList : public fi_tclVisitableTypeBase
{
public:
   fi_tcl_RoadNameElementList() {}
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   fi_tcl_RoadNameElementList& operator=(const fi_tcl_RoadNameElementList& coRef);
   fi_tcl_RoadNameElementList(const fi_tcl_RoadNameElementList& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
   std::vector<fi_tclMultiLanguageString, std::allocator<fi_tclMultiLanguageString> > RoadNameList;

   virtual tVoid vDestroy();
   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual tBool operator==(const fi_tcl_RoadNameElementList& rfoCmp) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   virtual tS32 s32GetTypeId() const { return typesfi_tclToken::EN_ROADNAMEELEMENTLIST;}
   virtual tVoid vTakeVisitor(fi_tclVisitorBase& rfoVisitor);
};

class fi_tcl_b8_RoadNumberStatus : public fi_tclVisitableTypeBase
{
public:
   fi_tcl_b8_RoadNumberStatus():u8Value(0) {}

   enum {
      FI_C_U8_BIT_ACOUSTIC = 0x1UL,
      FI_C_U8_BIT_PREICON = 0x2UL,
      FI_C_U8_BIT_MAPICON = 0x4UL,
      FI_C_U8_BIT_PRECEDENCEOVERTEXT = 0x8UL
   };
   tBool bAcoustic() const {return (u8Value & FI_C_U8_BIT_ACOUSTIC) != 0; }
   tVoid vSetAcoustic(tBool bSetBit) { u8Value = (bSetBit)?(u8Value | FI_C_U8_BIT_ACOUSTIC):(u8Value & ~FI_C_U8_BIT_ACOUSTIC); }
   tBool bPreIcon() const {return (u8Value & FI_C_U8_BIT_PREICON) != 0; }
   tVoid vSetPreIcon(tBool bSetBit) { u8Value = (bSetBit)?(u8Value | FI_C_U8_BIT_PREICON):(u8Value & ~FI_C_U8_BIT_PREICON); }
   tBool bMapIcon() const {return (u8Value & FI_C_U8_BIT_MAPICON) != 0; }
   tVoid vSetMapIcon(tBool bSetBit) { u8Value = (bSetBit)?(u8Value | FI_C_U8_BIT_MAPICON):(u8Value & ~FI_C_U8_BIT_MAPICON); }
   tBool bPrecedenceOverText() const {return (u8Value & FI_C_U8_BIT_PRECEDENCEOVERTEXT) != 0; }
   tVoid vSetPrecedenceOverText(tBool bSetBit) { u8Value = (bSetBit)?(u8Value | FI_C_U8_BIT_PRECEDENCEOVERTEXT):(u8Value & ~FI_C_U8_BIT_PRECEDENCEOVERTEXT); }
   struct rBitValues {
      unsigned int Acoustic:1;
      unsigned int PreIcon:1;
      unsigned int MapIcon:1;
      unsigned int PrecedenceOverText:1;
      unsigned int dummy4:1;
      unsigned int dummy5:1;
      unsigned int dummy6:1;
      unsigned int dummy7:1;
   };
   union {
      tU8 u8Value;
      rBitValues bits;
   };

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual tBool operator==(const fi_tcl_b8_RoadNumberStatus& rfoCmp) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   virtual tS32 s32GetTypeId() const { return typesfi_tclToken::EN_B8_ROADNUMBERSTATUS;}
   virtual tVoid vTakeVisitor(fi_tclVisitorBase& rfoVisitor);
};

class fi_tcl_RequiredTaxDisc : public fi_tclVisitableTypeBase
{
public:
   fi_tcl_RequiredTaxDisc():RequiredPermissionID(0),CountryCode(),Region(0),RequiredPermissionName(0),Description(0) {}
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   fi_tcl_RequiredTaxDisc& operator=(const fi_tcl_RequiredTaxDisc& coRef);
   fi_tcl_RequiredTaxDisc(const fi_tcl_RequiredTaxDisc& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
   tS32 RequiredPermissionID;
   fi_tcl_e16_ISOCountryCode CountryCode;
   tU16 Region;
   fi_tclMultiLanguageString RequiredPermissionName;
   fi_tclMultiLanguageString Description;

   virtual tVoid vDestroy();
   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual tBool operator==(const fi_tcl_RequiredTaxDisc& rfoCmp) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   virtual tS32 s32GetTypeId() const { return typesfi_tclToken::EN_REQUIREDTAXDISC;}
   virtual tVoid vTakeVisitor(fi_tclVisitorBase& rfoVisitor);
};

class fi_tcl_e8_RequiredPermissionType : public fi_tclVisitableTypeBase
{
public:
   fi_tcl_e8_RequiredPermissionType():enType(FI_EN_RESERVED) {}

   enum tenType {
      FI_EN_RESERVED = 0UL,
      FI_EN_REQUIREDTAXDISC = 1UL,
      FI_EN_REQUIREDURBANTAX = 2UL
   };
   tenType enType;

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual tBool operator==(const fi_tcl_e8_RequiredPermissionType& rfoCmp) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   virtual tS32 s32GetTypeId() const { return typesfi_tclToken::EN_E8_REQUIREDPERMISSIONTYPE;}
   virtual tVoid vTakeVisitor(fi_tclVisitorBase& rfoVisitor);
};

class fi_tcl_e8_RequiredPermission : public fi_tclVisitableTypeBase
{
public:
   fi_tcl_e8_RequiredPermission():enType(FI_EN_T_RESERVED) {}

   enum tenType {
      FI_EN_T_RESERVED = 0UL,
      FI_EN_T_REQUIREDTAXDISC = 1UL,
      FI_EN_T_GENERICREQUIREDPERMISSION = 2UL
   };
   tenType enType;

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual tBool operator==(const fi_tcl_e8_RequiredPermission& rfoCmp) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   virtual tS32 s32GetTypeId() const { return typesfi_tclToken::EN_E8_REQUIREDPERMISSION;}
   virtual tVoid vTakeVisitor(fi_tclVisitorBase& rfoVisitor);
};

class fi_tcl_GenericRequiredPermission : public fi_tclVisitableTypeBase
{
public:
   fi_tcl_GenericRequiredPermission():RequiredPermissionID(0),CountryCode(),RegionId(0),RequiredPermissionName(0),Description(0),RequiredPermissionType() {}
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   fi_tcl_GenericRequiredPermission& operator=(const fi_tcl_GenericRequiredPermission& coRef);
   fi_tcl_GenericRequiredPermission(const fi_tcl_GenericRequiredPermission& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
   tS32 RequiredPermissionID;
   fi_tcl_e16_ISOCountryCode CountryCode;
   tU16 RegionId;
   fi_tclMultiLanguageString RequiredPermissionName;
   fi_tclMultiLanguageString Description;
   fi_tcl_e8_RequiredPermissionType RequiredPermissionType;

   virtual tVoid vDestroy();
   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual tBool operator==(const fi_tcl_GenericRequiredPermission& rfoCmp) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   virtual tS32 s32GetTypeId() const { return typesfi_tclToken::EN_GENERICREQUIREDPERMISSION;}
   virtual tVoid vTakeVisitor(fi_tclVisitorBase& rfoVisitor);
};

class fi_tcl_RequiredPermission : public fi_tclVisitableTypeBase
{
public:
   fi_tcl_RequiredPermission():poCategoryData(0) {}
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   fi_tcl_RequiredPermission& operator=(const fi_tcl_RequiredPermission& coRef);
   fi_tcl_RequiredPermission(const fi_tcl_RequiredPermission& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
   fi_tcl_e8_RequiredPermission CategoryType;
   fi_tclTypeBase* poCategoryData;
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   virtual ~fi_tcl_RequiredPermission();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   virtual tVoid vDestroy();
   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual tBool operator==(const fi_tcl_RequiredPermission& rfoCmp) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   virtual tS32 s32GetTypeId() const { return typesfi_tclToken::EN_REQUIREDPERMISSION;}
   virtual tVoid vTakeVisitor(fi_tclVisitorBase& rfoVisitor);
};

class fi_tcl_RequiredPermissionList : public fi_tclVisitableTypeBase
{
public:
   fi_tcl_RequiredPermissionList() {}
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   fi_tcl_RequiredPermissionList& operator=(const fi_tcl_RequiredPermissionList& coRef);
   fi_tcl_RequiredPermissionList(const fi_tcl_RequiredPermissionList& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
   std::vector<fi_tcl_RequiredPermission, std::allocator<fi_tcl_RequiredPermission> > RequiredPermissionList;

   virtual tVoid vDestroy();
   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual tBool operator==(const fi_tcl_RequiredPermissionList& rfoCmp) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   virtual tS32 s32GetTypeId() const { return typesfi_tclToken::EN_REQUIREDPERMISSIONLIST;}
   virtual tVoid vTakeVisitor(fi_tclVisitorBase& rfoVisitor);
};

class fi_tcl_CountryNameElement : public fi_tclVisitableTypeBase
{
public:
   fi_tcl_CountryNameElement():Code(),Name(0) {}
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   fi_tcl_CountryNameElement& operator=(const fi_tcl_CountryNameElement& coRef);
   fi_tcl_CountryNameElement(const fi_tcl_CountryNameElement& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
   fi_tcl_e16_ISOCountryCode Code;
   fi_tclMultiLanguageString Name;

   virtual tVoid vDestroy();
   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual tBool operator==(const fi_tcl_CountryNameElement& rfoCmp) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   virtual tS32 s32GetTypeId() const { return typesfi_tclToken::EN_COUNTRYNAMEELEMENT;}
   virtual tVoid vTakeVisitor(fi_tclVisitorBase& rfoVisitor);
};

class fi_tcl_StateNameListSet : public fi_tclVisitableTypeBase
{
public:
   fi_tcl_StateNameListSet() {}
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   fi_tcl_StateNameListSet& operator=(const fi_tcl_StateNameListSet& coRef);
   fi_tcl_StateNameListSet(const fi_tcl_StateNameListSet& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
   std::vector<fi_tcl_u16_IndexInReferenceList, std::allocator<fi_tcl_u16_IndexInReferenceList> > ElementRefList;
   std::vector<fi_tcl_StateNameElement, std::allocator<fi_tcl_StateNameElement> > StateNameRefList;

   virtual tVoid vDestroy();
   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual tBool operator==(const fi_tcl_StateNameListSet& rfoCmp) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   virtual tS32 s32GetTypeId() const { return typesfi_tclToken::EN_STATENAMELISTSET;}
   virtual tVoid vTakeVisitor(fi_tclVisitorBase& rfoVisitor);
};

class fi_tcl_CountyNameListSet : public fi_tclVisitableTypeBase
{
public:
   fi_tcl_CountyNameListSet() {}
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   fi_tcl_CountyNameListSet& operator=(const fi_tcl_CountyNameListSet& coRef);
   fi_tcl_CountyNameListSet(const fi_tcl_CountyNameListSet& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
   std::vector<fi_tcl_u16_IndexInReferenceList, std::allocator<fi_tcl_u16_IndexInReferenceList> > ElementRefList;
   std::vector<fi_tclMultiLanguageString, std::allocator<fi_tclMultiLanguageString> > CountyNameRefList;

   virtual tVoid vDestroy();
   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual tBool operator==(const fi_tcl_CountyNameListSet& rfoCmp) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   virtual tS32 s32GetTypeId() const { return typesfi_tclToken::EN_COUNTYNAMELISTSET;}
   virtual tVoid vTakeVisitor(fi_tclVisitorBase& rfoVisitor);
};

class fi_tcl_CityNameElement : public fi_tclVisitableTypeBase
{
public:
   fi_tcl_CityNameElement():Name(0),Priority(0),Population(0) {}
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   fi_tcl_CityNameElement& operator=(const fi_tcl_CityNameElement& coRef);
   fi_tcl_CityNameElement(const fi_tcl_CityNameElement& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
   fi_tclMultiLanguageString Name;
   tS8 Priority;
   tU32 Population;

   virtual tVoid vDestroy();
   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual tBool operator==(const fi_tcl_CityNameElement& rfoCmp) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   virtual tS32 s32GetTypeId() const { return typesfi_tclToken::EN_CITYNAMEELEMENT;}
   virtual tVoid vTakeVisitor(fi_tclVisitorBase& rfoVisitor);
};

class fi_tcl_IndexInReferenceList : public fi_tclVisitableTypeBase
{
public:
   fi_tcl_IndexInReferenceList():RefElement(),DescriptionOnNextNode(0) {}
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   fi_tcl_IndexInReferenceList& operator=(const fi_tcl_IndexInReferenceList& coRef);
   fi_tcl_IndexInReferenceList(const fi_tcl_IndexInReferenceList& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
   fi_tcl_u16_IndexInReferenceList RefElement;
   tBool DescriptionOnNextNode;

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual tBool operator==(const fi_tcl_IndexInReferenceList& rfoCmp) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   virtual tS32 s32GetTypeId() const { return typesfi_tclToken::EN_INDEXINREFERENCELIST;}
   virtual tVoid vTakeVisitor(fi_tclVisitorBase& rfoVisitor);
};

class fi_tcl_BuildUpAreaNameListSet : public fi_tclVisitableTypeBase
{
public:
   fi_tcl_BuildUpAreaNameListSet() {}
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   fi_tcl_BuildUpAreaNameListSet& operator=(const fi_tcl_BuildUpAreaNameListSet& coRef);
   fi_tcl_BuildUpAreaNameListSet(const fi_tcl_BuildUpAreaNameListSet& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
   std::vector<fi_tcl_IndexInReferenceList, std::allocator<fi_tcl_IndexInReferenceList> > ElementInRefList;
   std::vector<fi_tcl_BuildUpAreaNameElement, std::allocator<fi_tcl_BuildUpAreaNameElement> > BuildUpAreaNameRefList;

   virtual tVoid vDestroy();
   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual tBool operator==(const fi_tcl_BuildUpAreaNameListSet& rfoCmp) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   virtual tS32 s32GetTypeId() const { return typesfi_tclToken::EN_BUILDUPAREANAMELISTSET;}
   virtual tVoid vTakeVisitor(fi_tclVisitorBase& rfoVisitor);
};

class fi_tcl_RoadNameListSet : public fi_tclVisitableTypeBase
{
public:
   fi_tcl_RoadNameListSet() {}
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   fi_tcl_RoadNameListSet& operator=(const fi_tcl_RoadNameListSet& coRef);
   fi_tcl_RoadNameListSet(const fi_tcl_RoadNameListSet& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
   std::vector<fi_tcl_u16_IndexInReferenceList, std::allocator<fi_tcl_u16_IndexInReferenceList> > ElementRefList;
   std::vector<fi_tcl_ReferenceElement, std::allocator<fi_tcl_ReferenceElement> > AlternativRefList;
   std::vector<fi_tclMultiLanguageString, std::allocator<fi_tclMultiLanguageString> > RoadNameRefList;

   virtual tVoid vDestroy();
   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual tBool operator==(const fi_tcl_RoadNameListSet& rfoCmp) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   virtual tS32 s32GetTypeId() const { return typesfi_tclToken::EN_ROADNAMELISTSET;}
   virtual tVoid vTakeVisitor(fi_tclVisitorBase& rfoVisitor);
};

class fi_tcl_CompassDirection : public fi_tclVisitableTypeBase
{
public:
   fi_tcl_CompassDirection():DirectionIsValid(0),Direction(),DirectionDesc(0) {}
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   fi_tcl_CompassDirection& operator=(const fi_tcl_CompassDirection& coRef);
   fi_tcl_CompassDirection(const fi_tcl_CompassDirection& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
   tBool DirectionIsValid;
   fi_tcl_u8_DirectionAbsolute Direction;
   fi_tclMultiLanguageString DirectionDesc;

   virtual tVoid vDestroy();
   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual tBool operator==(const fi_tcl_CompassDirection& rfoCmp) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   virtual tS32 s32GetTypeId() const { return typesfi_tclToken::EN_COMPASSDIRECTION;}
   virtual tVoid vTakeVisitor(fi_tclVisitorBase& rfoVisitor);
};

class fi_tcl_RequiredPermissionListSet : public fi_tclVisitableTypeBase
{
public:
   fi_tcl_RequiredPermissionListSet() {}
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   fi_tcl_RequiredPermissionListSet& operator=(const fi_tcl_RequiredPermissionListSet& coRef);
   fi_tcl_RequiredPermissionListSet(const fi_tcl_RequiredPermissionListSet& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
   std::vector<fi_tcl_ReferenceElement, std::allocator<fi_tcl_ReferenceElement> > AlternativRefList;
   std::vector<fi_tcl_ReferenceElementWithID, std::allocator<fi_tcl_ReferenceElementWithID> > AlternativRefIDList;
   std::vector<fi_tcl_RequiredPermission, std::allocator<fi_tcl_RequiredPermission> > RequiredPermissionRefList;

   virtual tVoid vDestroy();
   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual tBool operator==(const fi_tcl_RequiredPermissionListSet& rfoCmp) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   virtual tS32 s32GetTypeId() const { return typesfi_tclToken::EN_REQUIREDPERMISSIONLISTSET;}
   virtual tVoid vTakeVisitor(fi_tclVisitorBase& rfoVisitor);
};

class fi_tcl_e8_IntersectionType : public fi_tclVisitableTypeBase
{
public:
   fi_tcl_e8_IntersectionType():enType(FI_EN_UNSPECIFIED) {}

   enum tenType {
      FI_EN_T_RESERVED = 0UL,
      FI_EN_MOTORWAYEXIT = 1UL,
      FI_EN_MOTORWAYINTERCHANGE = 2UL,
      FI_EN_MOTORWAYJUNCTION = 3UL,
      FI_EN_EXIT = 4UL,
      FI_EN_CROSSING = 5UL,
      FI_EN_FERRYTERMINAL = 6UL,
      FI_EN_BORDERCROSSING = 7UL,
      FI_EN_ROUNDABOUT = 8UL,
      FI_EN_UNSPECIFIED = 9UL,
      FI_EN_ENTRANCE = 10UL,
      FI_EN_MOTORWAYENTRANCE = 11UL
   };
   tenType enType;

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual tBool operator==(const fi_tcl_e8_IntersectionType& rfoCmp) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   virtual tS32 s32GetTypeId() const { return typesfi_tclToken::EN_E8_INTERSECTIONTYPE;}
   virtual tVoid vTakeVisitor(fi_tclVisitorBase& rfoVisitor);
};

class fi_tcl_TimeZoneListSet : public fi_tclVisitableTypeBase
{
public:
   fi_tcl_TimeZoneListSet() {}
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   fi_tcl_TimeZoneListSet& operator=(const fi_tcl_TimeZoneListSet& coRef);
   fi_tcl_TimeZoneListSet(const fi_tcl_TimeZoneListSet& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
   std::vector<fi_tcl_u16_IndexInReferenceList, std::allocator<fi_tcl_u16_IndexInReferenceList> > ElementRefList;
   std::vector<fi_tcl_TimeZoneElement, std::allocator<fi_tcl_TimeZoneElement> > TimeZoneList;

   virtual tVoid vDestroy();
   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual tBool operator==(const fi_tcl_TimeZoneListSet& rfoCmp) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   virtual tS32 s32GetTypeId() const { return typesfi_tclToken::EN_TIMEZONELISTSET;}
   virtual tVoid vTakeVisitor(fi_tclVisitorBase& rfoVisitor);
};

class fi_tcl_IntersectionNameElement : public fi_tclVisitableTypeBase
{
public:
   fi_tcl_IntersectionNameElement():IntersectionType(),IntersectionPrefix(),IntersectionName(0),IntersectionSuffix() {}
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   fi_tcl_IntersectionNameElement& operator=(const fi_tcl_IntersectionNameElement& coRef);
   fi_tcl_IntersectionNameElement(const fi_tcl_IntersectionNameElement& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
   fi_tcl_e8_IntersectionType IntersectionType;
   fi_tclString IntersectionPrefix;
   fi_tclMultiLanguageString IntersectionName;
   fi_tclString IntersectionSuffix;

   virtual tVoid vDestroy();
   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual tBool operator==(const fi_tcl_IntersectionNameElement& rfoCmp) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   virtual tS32 s32GetTypeId() const { return typesfi_tclToken::EN_INTERSECTIONNAMEELEMENT;}
   virtual tVoid vTakeVisitor(fi_tclVisitorBase& rfoVisitor);
};

class fi_tcl_IntersectionNameListSet : public fi_tclVisitableTypeBase
{
public:
   fi_tcl_IntersectionNameListSet() {}
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   fi_tcl_IntersectionNameListSet& operator=(const fi_tcl_IntersectionNameListSet& coRef);
   fi_tcl_IntersectionNameListSet(const fi_tcl_IntersectionNameListSet& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
   std::vector<fi_tcl_ReferenceElement, std::allocator<fi_tcl_ReferenceElement> > AlternativRefList;
   std::vector<fi_tcl_IntersectionNameElement, std::allocator<fi_tcl_IntersectionNameElement> > IntersectionNameRefList;

   virtual tVoid vDestroy();
   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual tBool operator==(const fi_tcl_IntersectionNameListSet& rfoCmp) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   virtual tS32 s32GetTypeId() const { return typesfi_tclToken::EN_INTERSECTIONNAMELISTSET;}
   virtual tVoid vTakeVisitor(fi_tclVisitorBase& rfoVisitor);
};

class fi_tcl_RoadNameElement : public fi_tclVisitableTypeBase
{
public:
   fi_tcl_RoadNameElement():RoadName(0) {}
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   fi_tcl_RoadNameElement& operator=(const fi_tcl_RoadNameElement& coRef);
   fi_tcl_RoadNameElement(const fi_tcl_RoadNameElement& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
   fi_tclMultiLanguageString RoadName;

   virtual tVoid vDestroy();
   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual tBool operator==(const fi_tcl_RoadNameElement& rfoCmp) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   virtual tS32 s32GetTypeId() const { return typesfi_tclToken::EN_ROADNAMEELEMENT;}
   virtual tVoid vTakeVisitor(fi_tclVisitorBase& rfoVisitor);
};

class fi_tcl_RoadNumber : public fi_tclVisitableTypeBase
{
public:
   fi_tcl_RoadNumber():Status(),CountryCode(),State(0),StateCode(0),NumberHierarchy(0),NumberPrefix(),RoadNumber(),NumberSuffix(),CompassDirection() {}
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   fi_tcl_RoadNumber& operator=(const fi_tcl_RoadNumber& coRef);
   fi_tcl_RoadNumber(const fi_tcl_RoadNumber& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
   fi_tcl_b8_RoadNumberStatus Status;
   fi_tcl_e16_ISOCountryCode CountryCode;
   tU16 State;
   tU32 StateCode;
   tU8 NumberHierarchy;
   fi_tclString NumberPrefix;
   fi_tclString RoadNumber;
   fi_tclString NumberSuffix;
   fi_tcl_CompassDirection CompassDirection;

   virtual tVoid vDestroy();
   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual tBool operator==(const fi_tcl_RoadNumber& rfoCmp) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   virtual tS32 s32GetTypeId() const { return typesfi_tclToken::EN_ROADNUMBER;}
   virtual tVoid vTakeVisitor(fi_tclVisitorBase& rfoVisitor);
};

class fi_tcl_IntersectionNumberElement : public fi_tclVisitableTypeBase
{
public:
   fi_tcl_IntersectionNumberElement():IntersectionType(),IntersectionNumber() {}
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   fi_tcl_IntersectionNumberElement& operator=(const fi_tcl_IntersectionNumberElement& coRef);
   fi_tcl_IntersectionNumberElement(const fi_tcl_IntersectionNumberElement& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
   fi_tcl_e8_IntersectionType IntersectionType;
   fi_tcl_RoadNumber IntersectionNumber;

   virtual tVoid vDestroy();
   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual tBool operator==(const fi_tcl_IntersectionNumberElement& rfoCmp) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   virtual tS32 s32GetTypeId() const { return typesfi_tclToken::EN_INTERSECTIONNUMBERELEMENT;}
   virtual tVoid vTakeVisitor(fi_tclVisitorBase& rfoVisitor);
};

class fi_tcl_MapDescriptionListSet : public fi_tclVisitableTypeBase
{
public:
   fi_tcl_MapDescriptionListSet() {}
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   fi_tcl_MapDescriptionListSet& operator=(const fi_tcl_MapDescriptionListSet& coRef);
   fi_tcl_MapDescriptionListSet(const fi_tcl_MapDescriptionListSet& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
   std::vector<fi_tcl_u16_IndexInReferenceList, std::allocator<fi_tcl_u16_IndexInReferenceList> > ElementRefList;
   std::vector<fi_tcl_MapCodedElement, std::allocator<fi_tcl_MapCodedElement> > MapElementRefList;

   virtual tVoid vDestroy();
   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual tBool operator==(const fi_tcl_MapDescriptionListSet& rfoCmp) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   virtual tS32 s32GetTypeId() const { return typesfi_tclToken::EN_MAPDESCRIPTIONLISTSET;}
   virtual tVoid vTakeVisitor(fi_tclVisitorBase& rfoVisitor);
};

class fi_tcl_CountryNameListSet : public fi_tclVisitableTypeBase
{
public:
   fi_tcl_CountryNameListSet() {}
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   fi_tcl_CountryNameListSet& operator=(const fi_tcl_CountryNameListSet& coRef);
   fi_tcl_CountryNameListSet(const fi_tcl_CountryNameListSet& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
   std::vector<fi_tcl_u16_IndexInReferenceList, std::allocator<fi_tcl_u16_IndexInReferenceList> > ElementRefList;
   std::vector<fi_tcl_CountryNameElement, std::allocator<fi_tcl_CountryNameElement> > CountryNameRefList;

   virtual tVoid vDestroy();
   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual tBool operator==(const fi_tcl_CountryNameListSet& rfoCmp) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   virtual tS32 s32GetTypeId() const { return typesfi_tclToken::EN_COUNTRYNAMELISTSET;}
   virtual tVoid vTakeVisitor(fi_tclVisitorBase& rfoVisitor);
};

class fi_tcl_CityNameListSet : public fi_tclVisitableTypeBase
{
public:
   fi_tcl_CityNameListSet() {}
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   fi_tcl_CityNameListSet& operator=(const fi_tcl_CityNameListSet& coRef);
   fi_tcl_CityNameListSet(const fi_tcl_CityNameListSet& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
   std::vector<fi_tcl_IndexInReferenceList, std::allocator<fi_tcl_IndexInReferenceList> > ElementInRefList;
   std::vector<fi_tcl_CityNameElement, std::allocator<fi_tcl_CityNameElement> > CityNameRefList;

   virtual tVoid vDestroy();
   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual tBool operator==(const fi_tcl_CityNameListSet& rfoCmp) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   virtual tS32 s32GetTypeId() const { return typesfi_tclToken::EN_CITYNAMELISTSET;}
   virtual tVoid vTakeVisitor(fi_tclVisitorBase& rfoVisitor);
};

class fi_tcl_SignPostListSet : public fi_tclVisitableTypeBase
{
public:
   fi_tcl_SignPostListSet() {}
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   fi_tcl_SignPostListSet& operator=(const fi_tcl_SignPostListSet& coRef);
   fi_tcl_SignPostListSet(const fi_tcl_SignPostListSet& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
   std::vector<fi_tcl_ReferenceElement, std::allocator<fi_tcl_ReferenceElement> > AlternativRefList;
   std::vector<fi_tcl_SignPostElement, std::allocator<fi_tcl_SignPostElement> > SignPostElement;

   virtual tVoid vDestroy();
   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual tBool operator==(const fi_tcl_SignPostListSet& rfoCmp) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   virtual tS32 s32GetTypeId() const { return typesfi_tclToken::EN_SIGNPOSTLISTSET;}
   virtual tVoid vTakeVisitor(fi_tclVisitorBase& rfoVisitor);
};

class fi_tcl_IntersectionNumberListSet : public fi_tclVisitableTypeBase
{
public:
   fi_tcl_IntersectionNumberListSet() {}
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   fi_tcl_IntersectionNumberListSet& operator=(const fi_tcl_IntersectionNumberListSet& coRef);
   fi_tcl_IntersectionNumberListSet(const fi_tcl_IntersectionNumberListSet& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
   std::vector<fi_tcl_ReferenceElement, std::allocator<fi_tcl_ReferenceElement> > AlternativRefList;
   std::vector<fi_tcl_RoadNumber, std::allocator<fi_tcl_RoadNumber> > IntersectionNumberRefList;

   virtual tVoid vDestroy();
   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual tBool operator==(const fi_tcl_IntersectionNumberListSet& rfoCmp) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   virtual tS32 s32GetTypeId() const { return typesfi_tclToken::EN_INTERSECTIONNUMBERLISTSET;}
   virtual tVoid vTakeVisitor(fi_tclVisitorBase& rfoVisitor);
};

class fi_tcl_RoadNumberElementList : public fi_tclVisitableTypeBase
{
public:
   fi_tcl_RoadNumberElementList() {}
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   fi_tcl_RoadNumberElementList& operator=(const fi_tcl_RoadNumberElementList& coRef);
   fi_tcl_RoadNumberElementList(const fi_tcl_RoadNumberElementList& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
   std::vector<fi_tcl_RoadNumber, std::allocator<fi_tcl_RoadNumber> > RoadNumberList;

   virtual tVoid vDestroy();
   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual tBool operator==(const fi_tcl_RoadNumberElementList& rfoCmp) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   virtual tS32 s32GetTypeId() const { return typesfi_tclToken::EN_ROADNUMBERELEMENTLIST;}
   virtual tVoid vTakeVisitor(fi_tclVisitorBase& rfoVisitor);
};

class fi_tcl_RoadNumberListSet : public fi_tclVisitableTypeBase
{
public:
   fi_tcl_RoadNumberListSet() {}
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   fi_tcl_RoadNumberListSet& operator=(const fi_tcl_RoadNumberListSet& coRef);
   fi_tcl_RoadNumberListSet(const fi_tcl_RoadNumberListSet& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
   std::vector<fi_tcl_u16_IndexInReferenceList, std::allocator<fi_tcl_u16_IndexInReferenceList> > ElementRefList;
   std::vector<fi_tcl_ReferenceElement, std::allocator<fi_tcl_ReferenceElement> > AlternativRefList;
   std::vector<fi_tcl_RoadNumber, std::allocator<fi_tcl_RoadNumber> > RoadNumberRefList;

   virtual tVoid vDestroy();
   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual tBool operator==(const fi_tcl_RoadNumberListSet& rfoCmp) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   virtual tS32 s32GetTypeId() const { return typesfi_tclToken::EN_ROADNUMBERLISTSET;}
   virtual tVoid vTakeVisitor(fi_tclVisitorBase& rfoVisitor);
};

class fi_tcl_b16_RoadAttribute : public fi_tclVisitableTypeBase
{
public:
   fi_tcl_b16_RoadAttribute():u16Value(0) {}

   enum {
      FI_C_U16_BIT_SEPARATELANES = 0x20UL,
      FI_C_U16_BIT_TOLLROAD = 0x10UL,
      FI_C_U16_BIT_TOLLROADRESTRICTEDACCESS = 0x8UL,
      FI_C_U16_BIT_RAILWAYORFERRYLINKS = 0x4UL,
      FI_C_U16_BIT_SCENICROAD = 0x2UL,
      FI_C_U16_BIT_RESERVED = 0x1UL
   };
   tBool bSeparateLanes() const {return (u16Value & FI_C_U16_BIT_SEPARATELANES) != 0; }
   tVoid vSetSeparateLanes(tBool bSetBit) { u16Value = (bSetBit)?(u16Value | FI_C_U16_BIT_SEPARATELANES):(u16Value & ~FI_C_U16_BIT_SEPARATELANES); }
   tBool bTollRoad() const {return (u16Value & FI_C_U16_BIT_TOLLROAD) != 0; }
   tVoid vSetTollRoad(tBool bSetBit) { u16Value = (bSetBit)?(u16Value | FI_C_U16_BIT_TOLLROAD):(u16Value & ~FI_C_U16_BIT_TOLLROAD); }
   tBool bTollRoadRestrictedAccess() const {return (u16Value & FI_C_U16_BIT_TOLLROADRESTRICTEDACCESS) != 0; }
   tVoid vSetTollRoadRestrictedAccess(tBool bSetBit) { u16Value = (bSetBit)?(u16Value | FI_C_U16_BIT_TOLLROADRESTRICTEDACCESS):(u16Value & ~FI_C_U16_BIT_TOLLROADRESTRICTEDACCESS); }
   tBool bRailwayOrFerryLinks() const {return (u16Value & FI_C_U16_BIT_RAILWAYORFERRYLINKS) != 0; }
   tVoid vSetRailwayOrFerryLinks(tBool bSetBit) { u16Value = (bSetBit)?(u16Value | FI_C_U16_BIT_RAILWAYORFERRYLINKS):(u16Value & ~FI_C_U16_BIT_RAILWAYORFERRYLINKS); }
   tBool bScenicRoad() const {return (u16Value & FI_C_U16_BIT_SCENICROAD) != 0; }
   tVoid vSetScenicRoad(tBool bSetBit) { u16Value = (bSetBit)?(u16Value | FI_C_U16_BIT_SCENICROAD):(u16Value & ~FI_C_U16_BIT_SCENICROAD); }
   tBool bReserved() const {return (u16Value & FI_C_U16_BIT_RESERVED) != 0; }
   tVoid vSetReserved(tBool bSetBit) { u16Value = (bSetBit)?(u16Value | FI_C_U16_BIT_RESERVED):(u16Value & ~FI_C_U16_BIT_RESERVED); }
   struct rBitValues {
      unsigned int Reserved:1;
      unsigned int ScenicRoad:1;
      unsigned int RailwayOrFerryLinks:1;
      unsigned int TollRoadRestrictedAccess:1;
      unsigned int TollRoad:1;
      unsigned int SeparateLanes:1;
      unsigned int dummy6:1;
      unsigned int dummy7:1;
      unsigned int dummy8:1;
      unsigned int dummy9:1;
      unsigned int dummy10:1;
      unsigned int dummy11:1;
      unsigned int dummy12:1;
      unsigned int dummy13:1;
      unsigned int dummy14:1;
      unsigned int dummy15:1;
   };
   union {
      tU16 u16Value;
      rBitValues bits;
   };

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual tBool operator==(const fi_tcl_b16_RoadAttribute& rfoCmp) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   virtual tS32 s32GetTypeId() const { return typesfi_tclToken::EN_B16_ROADATTRIBUTE;}
   virtual tVoid vTakeVisitor(fi_tclVisitorBase& rfoVisitor);
};

class fi_tcl_EDMOneCell : public fi_tclVisitableTypeBase
{
public:
   fi_tcl_EDMOneCell():OneCellId(0),IndexInClusterList(),OCProperties() {}
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   fi_tcl_EDMOneCell& operator=(const fi_tcl_EDMOneCell& coRef);
   fi_tcl_EDMOneCell(const fi_tcl_EDMOneCell& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
   tU16 OneCellId;
   fi_tcl_u16_IndexInReferenceList IndexInClusterList;
   fi_tcl_EDMOneCellProp OCProperties;

   virtual tVoid vDestroy();
   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual tBool operator==(const fi_tcl_EDMOneCell& rfoCmp) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   virtual tS32 s32GetTypeId() const { return typesfi_tclToken::EN_EDMONECELL;}
   virtual tVoid vTakeVisitor(fi_tclVisitorBase& rfoVisitor);
};

class fi_tcl_NavPosOnecellSectionDescription : public fi_tclVisitableTypeBase
{
public:
   fi_tcl_NavPosOnecellSectionDescription():Cluster(),OneCell(),OneCellProperty(),SectionIndex(0) {}
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   fi_tcl_NavPosOnecellSectionDescription& operator=(const fi_tcl_NavPosOnecellSectionDescription& coRef);
   fi_tcl_NavPosOnecellSectionDescription(const fi_tcl_NavPosOnecellSectionDescription& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
   fi_tcl_NavClusterDesc Cluster;
   fi_tcl_NavOneCellDesc OneCell;
   fi_tcl_NavPosOneCellProperty OneCellProperty;
   tU16 SectionIndex;

   virtual tVoid vDestroy();
   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual tBool operator==(const fi_tcl_NavPosOnecellSectionDescription& rfoCmp) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   virtual tS32 s32GetTypeId() const { return typesfi_tclToken::EN_NAVPOSONECELLSECTIONDESCRIPTION;}
   virtual tVoid vTakeVisitor(fi_tclVisitorBase& rfoVisitor);
};

class fi_tcl_EntryPoint : public fi_tclVisitableTypeBase
{
public:
   fi_tcl_EntryPoint():EntryPointStatus(),PositionCoord(),MapAngle(),OnecellSection(),LengthToOnecellEnd(),ResistanceManipulator() {}
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   fi_tcl_EntryPoint& operator=(const fi_tcl_EntryPoint& coRef);
   fi_tcl_EntryPoint(const fi_tcl_EntryPoint& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
   fi_tcl_e8_EntryPointState EntryPointStatus;
   fi_tcl_PositionWGS84 PositionCoord;
   fi_tcl_s16_EAU MapAngle;
   fi_tcl_NavPosOnecellSectionDescription OnecellSection;
   fi_tcl_s32_MEMU LengthToOnecellEnd;
   fi_tcl_u32_Resistance ResistanceManipulator;

   virtual tVoid vDestroy();
   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual tBool operator==(const fi_tcl_EntryPoint& rfoCmp) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   virtual tS32 s32GetTypeId() const { return typesfi_tclToken::EN_ENTRYPOINT;}
   virtual tVoid vTakeVisitor(fi_tclVisitorBase& rfoVisitor);
};

class fi_tcl_PositionDescription : public fi_tclVisitableTypeBase
{
public:
   fi_tcl_PositionDescription():PositionCoord(),OnecellSection(),LengthToIntersection(),Icourse(),MapAngle(),IndexInHorizon(0xFFFF) {}
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   fi_tcl_PositionDescription& operator=(const fi_tcl_PositionDescription& coRef);
   fi_tcl_PositionDescription(const fi_tcl_PositionDescription& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
   fi_tcl_PositionWGS84 PositionCoord;
   fi_tcl_NavPosOnecellSectionDescription OnecellSection;
   fi_tcl_s32_MEMU LengthToIntersection;
   fi_tcl_s16_EAU Icourse;
   fi_tcl_s16_EAU MapAngle;
   fi_tcl_u16_IndexInReferenceList IndexInHorizon;

   virtual tVoid vDestroy();
   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual tBool operator==(const fi_tcl_PositionDescription& rfoCmp) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   virtual tS32 s32GetTypeId() const { return typesfi_tclToken::EN_POSITIONDESCRIPTION;}
   virtual tVoid vTakeVisitor(fi_tclVisitorBase& rfoVisitor);
};

class fi_tcl_RoadAttributes : public fi_tclVisitableTypeBase
{
public:
   fi_tcl_RoadAttributes():RoadClass(),RoadProperty(),RoadType(),RoadNetworkClass() {}
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   fi_tcl_RoadAttributes& operator=(const fi_tcl_RoadAttributes& coRef);
   fi_tcl_RoadAttributes(const fi_tcl_RoadAttributes& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
   fi_tcl_e8_RoadClassCode RoadClass;
   fi_tcl_b32_RoadProperty RoadProperty;
   fi_tcl_e8_NavStreetType RoadType;
   fi_tcl_e8_RoadNetworkClass RoadNetworkClass;

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual tBool operator==(const fi_tcl_RoadAttributes& rfoCmp) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   virtual tS32 s32GetTypeId() const { return typesfi_tclToken::EN_ROADATTRIBUTES;}
   virtual tVoid vTakeVisitor(fi_tclVisitorBase& rfoVisitor);
};

class fi_tcl_RoadId : public fi_tclVisitableTypeBase
{
public:
   fi_tcl_RoadId():OneCellId(0),ClusterFileId(0),ClusterLength(0),ClusterFileOffset(0),NavDataSetID() {}
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   fi_tcl_RoadId& operator=(const fi_tcl_RoadId& coRef);
   fi_tcl_RoadId(const fi_tcl_RoadId& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
   tU16 OneCellId;
   tU16 ClusterFileId;
   tU16 ClusterLength;
   tU32 ClusterFileOffset;
   fi_tcl_u32_DataSetId NavDataSetID;

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual tBool operator==(const fi_tcl_RoadId& rfoCmp) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   virtual tS32 s32GetTypeId() const { return typesfi_tclToken::EN_ROADID;}
   virtual tVoid vTakeVisitor(fi_tclVisitorBase& rfoVisitor);
};

class fi_tcl_e8_ExtraDescElementType : public fi_tclVisitableTypeBase
{
public:
   fi_tcl_e8_ExtraDescElementType():enType(FI_EN_UNSPECIFIED) {}

   enum tenType {
      FI_EN_UNSPECIFIED = 0UL,
      FI_EN_MOUNTAINS = 1UL,
      FI_EN_NATIONALPARK = 2UL
   };
   tenType enType;

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual tBool operator==(const fi_tcl_e8_ExtraDescElementType& rfoCmp) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   virtual tS32 s32GetTypeId() const { return typesfi_tclToken::EN_E8_EXTRADESCELEMENTTYPE;}
   virtual tVoid vTakeVisitor(fi_tclVisitorBase& rfoVisitor);
};

class fi_tcl_ExtraDescElement : public fi_tclVisitableTypeBase
{
public:
   fi_tcl_ExtraDescElement():Type(),ShortDescription(0),LongDescription(0) {}
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   fi_tcl_ExtraDescElement& operator=(const fi_tcl_ExtraDescElement& coRef);
   fi_tcl_ExtraDescElement(const fi_tcl_ExtraDescElement& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
   fi_tcl_e8_ExtraDescElementType Type;
   fi_tclMultiLanguageString ShortDescription;
   fi_tclMultiLanguageString LongDescription;

   virtual tVoid vDestroy();
   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual tBool operator==(const fi_tcl_ExtraDescElement& rfoCmp) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   virtual tS32 s32GetTypeId() const { return typesfi_tclToken::EN_EXTRADESCELEMENT;}
   virtual tVoid vTakeVisitor(fi_tclVisitorBase& rfoVisitor);
};

class fi_tcl_ExtraDescListSet : public fi_tclVisitableTypeBase
{
public:
   fi_tcl_ExtraDescListSet() {}
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   fi_tcl_ExtraDescListSet& operator=(const fi_tcl_ExtraDescListSet& coRef);
   fi_tcl_ExtraDescListSet(const fi_tcl_ExtraDescListSet& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
   std::vector<fi_tcl_ReferenceElement, std::allocator<fi_tcl_ReferenceElement> > AlternativRefList;
   std::vector<fi_tcl_ExtraDescElement, std::allocator<fi_tcl_ExtraDescElement> > ExtraDescRefList;

   virtual tVoid vDestroy();
   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual tBool operator==(const fi_tcl_ExtraDescListSet& rfoCmp) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   virtual tS32 s32GetTypeId() const { return typesfi_tclToken::EN_EXTRADESCLISTSET;}
   virtual tVoid vTakeVisitor(fi_tclVisitorBase& rfoVisitor);
};

class fi_tcl_b32_DataProperties : public fi_tclVisitableTypeBase
{
public:
   fi_tcl_b32_DataProperties():u32Value(0) {}

   enum {
      FI_C_U32_BIT_BASICATTRIBUTED = 0x1UL,
      FI_C_U32_BIT_INTERCONNECTING = 0x2UL,
      FI_C_U32_BIT_MAJORROAD = 0x4UL
   };
   tBool bBasicAttributed() const {return (u32Value & FI_C_U32_BIT_BASICATTRIBUTED) != 0; }
   tVoid vSetBasicAttributed(tBool bSetBit) { u32Value = (bSetBit)?(u32Value | FI_C_U32_BIT_BASICATTRIBUTED):(u32Value & ~FI_C_U32_BIT_BASICATTRIBUTED); }
   tBool bInterconnecting() const {return (u32Value & FI_C_U32_BIT_INTERCONNECTING) != 0; }
   tVoid vSetInterconnecting(tBool bSetBit) { u32Value = (bSetBit)?(u32Value | FI_C_U32_BIT_INTERCONNECTING):(u32Value & ~FI_C_U32_BIT_INTERCONNECTING); }
   tBool bMajorRoad() const {return (u32Value & FI_C_U32_BIT_MAJORROAD) != 0; }
   tVoid vSetMajorRoad(tBool bSetBit) { u32Value = (bSetBit)?(u32Value | FI_C_U32_BIT_MAJORROAD):(u32Value & ~FI_C_U32_BIT_MAJORROAD); }
   struct rBitValues {
      unsigned int BasicAttributed:1;
      unsigned int Interconnecting:1;
      unsigned int MajorRoad:1;
      unsigned int dummy3:1;
      unsigned int dummy4:1;
      unsigned int dummy5:1;
      unsigned int dummy6:1;
      unsigned int dummy7:1;
      unsigned int dummy8:1;
      unsigned int dummy9:1;
      unsigned int dummy10:1;
      unsigned int dummy11:1;
      unsigned int dummy12:1;
      unsigned int dummy13:1;
      unsigned int dummy14:1;
      unsigned int dummy15:1;
      unsigned int dummy16:1;
      unsigned int dummy17:1;
      unsigned int dummy18:1;
      unsigned int dummy19:1;
      unsigned int dummy20:1;
      unsigned int dummy21:1;
      unsigned int dummy22:1;
      unsigned int dummy23:1;
      unsigned int dummy24:1;
      unsigned int dummy25:1;
      unsigned int dummy26:1;
      unsigned int dummy27:1;
      unsigned int dummy28:1;
      unsigned int dummy29:1;
      unsigned int dummy30:1;
      unsigned int dummy31:1;
   };
   union {
      tU32 u32Value;
      rBitValues bits;
   };

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual tBool operator==(const fi_tcl_b32_DataProperties& rfoCmp) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   virtual tS32 s32GetTypeId() const { return typesfi_tclToken::EN_B32_DATAPROPERTIES;}
   virtual tVoid vTakeVisitor(fi_tclVisitorBase& rfoVisitor);
};

class fi_tcl_DataDescElement : public fi_tclVisitableTypeBase
{
public:
   fi_tcl_DataDescElement():RNWDataProperties(),CandyProductCode(0) {}
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   fi_tcl_DataDescElement& operator=(const fi_tcl_DataDescElement& coRef);
   fi_tcl_DataDescElement(const fi_tcl_DataDescElement& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
   fi_tcl_b32_DataProperties RNWDataProperties;
   tU32 CandyProductCode;

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual tBool operator==(const fi_tcl_DataDescElement& rfoCmp) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   virtual tS32 s32GetTypeId() const { return typesfi_tclToken::EN_DATADESCELEMENT;}
   virtual tVoid vTakeVisitor(fi_tclVisitorBase& rfoVisitor);
};

class fi_tcl_DataDescListSet : public fi_tclVisitableTypeBase
{
public:
   fi_tcl_DataDescListSet() {}
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   fi_tcl_DataDescListSet& operator=(const fi_tcl_DataDescListSet& coRef);
   fi_tcl_DataDescListSet(const fi_tcl_DataDescListSet& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
   std::vector<fi_tcl_u16_IndexInReferenceList, std::allocator<fi_tcl_u16_IndexInReferenceList> > ElementRefList;
   std::vector<fi_tcl_ReferenceElement, std::allocator<fi_tcl_ReferenceElement> > AlternativRefList;
   std::vector<fi_tcl_DataDescElement, std::allocator<fi_tcl_DataDescElement> > DataDescRefList;

   virtual tVoid vDestroy();
   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual tBool operator==(const fi_tcl_DataDescListSet& rfoCmp) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   virtual tS32 s32GetTypeId() const { return typesfi_tclToken::EN_DATADESCLISTSET;}
   virtual tVoid vTakeVisitor(fi_tclVisitorBase& rfoVisitor);
};

class fi_tcl_b8_CrossroadProperties : public fi_tclVisitableTypeBase
{
public:
   fi_tcl_b8_CrossroadProperties():u8Value(0) {}

   enum {
      FI_C_U8_BIT_ENTRANCE = 0x2UL,
      FI_C_U8_BIT_EXIT = 0x4UL,
      FI_C_U8_BIT_INVALIDEXIT = 0x8UL,
      FI_C_U8_BIT_ENTRANCEISMEMBEROFPATH = 0x10UL,
      FI_C_U8_BIT_EXITISMEMBEROFPATH = 0x20UL
   };
   tBool bEntrance() const {return (u8Value & FI_C_U8_BIT_ENTRANCE) != 0; }
   tVoid vSetEntrance(tBool bSetBit) { u8Value = (bSetBit)?(u8Value | FI_C_U8_BIT_ENTRANCE):(u8Value & ~FI_C_U8_BIT_ENTRANCE); }
   tBool bExit() const {return (u8Value & FI_C_U8_BIT_EXIT) != 0; }
   tVoid vSetExit(tBool bSetBit) { u8Value = (bSetBit)?(u8Value | FI_C_U8_BIT_EXIT):(u8Value & ~FI_C_U8_BIT_EXIT); }
   tBool bInvalidExit() const {return (u8Value & FI_C_U8_BIT_INVALIDEXIT) != 0; }
   tVoid vSetInvalidExit(tBool bSetBit) { u8Value = (bSetBit)?(u8Value | FI_C_U8_BIT_INVALIDEXIT):(u8Value & ~FI_C_U8_BIT_INVALIDEXIT); }
   tBool bEntranceIsMemberOfPath() const {return (u8Value & FI_C_U8_BIT_ENTRANCEISMEMBEROFPATH) != 0; }
   tVoid vSetEntranceIsMemberOfPath(tBool bSetBit) { u8Value = (bSetBit)?(u8Value | FI_C_U8_BIT_ENTRANCEISMEMBEROFPATH):(u8Value & ~FI_C_U8_BIT_ENTRANCEISMEMBEROFPATH); }
   tBool bExitIsMemberOfPath() const {return (u8Value & FI_C_U8_BIT_EXITISMEMBEROFPATH) != 0; }
   tVoid vSetExitIsMemberOfPath(tBool bSetBit) { u8Value = (bSetBit)?(u8Value | FI_C_U8_BIT_EXITISMEMBEROFPATH):(u8Value & ~FI_C_U8_BIT_EXITISMEMBEROFPATH); }
   struct rBitValues {
      unsigned int dummy0:1;
      unsigned int Entrance:1;
      unsigned int Exit:1;
      unsigned int InvalidExit:1;
      unsigned int EntranceIsMemberOfPath:1;
      unsigned int ExitIsMemberOfPath:1;
      unsigned int dummy6:1;
      unsigned int dummy7:1;
   };
   union {
      tU8 u8Value;
      rBitValues bits;
   };

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual tBool operator==(const fi_tcl_b8_CrossroadProperties& rfoCmp) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   virtual tS32 s32GetTypeId() const { return typesfi_tclToken::EN_B8_CROSSROADPROPERTIES;}
   virtual tVoid vTakeVisitor(fi_tclVisitorBase& rfoVisitor);
};

class fi_tcl_CrossroadDesc : public fi_tclVisitableTypeBase
{
public:
   fi_tcl_CrossroadDesc():IsDirectionValid(0),Direction(),DirectionOfConnectedElement(),CrossroadProperty(),CrossroadInfoRefElement(),CrossroadAttributes(),IndexOfTwinElement() {}
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   fi_tcl_CrossroadDesc& operator=(const fi_tcl_CrossroadDesc& coRef);
   fi_tcl_CrossroadDesc(const fi_tcl_CrossroadDesc& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
   tBool IsDirectionValid;
   fi_tcl_u8_DirectionAbsolute Direction;
   fi_tcl_u8_DirectionAbsolute DirectionOfConnectedElement;
   fi_tcl_b8_CrossroadProperties CrossroadProperty;
   fi_tcl_u16_IndexInReferenceList CrossroadInfoRefElement;
   fi_tcl_RoadAttributes CrossroadAttributes;
   fi_tcl_u16_IndexInReferenceList IndexOfTwinElement;

   virtual tVoid vDestroy();
   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual tBool operator==(const fi_tcl_CrossroadDesc& rfoCmp) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   virtual tS32 s32GetTypeId() const { return typesfi_tclToken::EN_CROSSROADDESC;}
   virtual tVoid vTakeVisitor(fi_tclVisitorBase& rfoVisitor);
};

class fi_tcl_CrossroadInfo : public fi_tclVisitableTypeBase
{
public:
   fi_tcl_CrossroadInfo():poCrossroadInfoData(0) {}
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   fi_tcl_CrossroadInfo& operator=(const fi_tcl_CrossroadInfo& coRef);
   fi_tcl_CrossroadInfo(const fi_tcl_CrossroadInfo& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
   fi_tcl_e8_CrossroadInfoCategory CrossroadInfoType;
   fi_tclTypeBase* poCrossroadInfoData;
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   virtual ~fi_tcl_CrossroadInfo();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   virtual tVoid vDestroy();
   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual tBool operator==(const fi_tcl_CrossroadInfo& rfoCmp) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   virtual tS32 s32GetTypeId() const { return typesfi_tclToken::EN_CROSSROADINFO;}
   virtual tVoid vTakeVisitor(fi_tclVisitorBase& rfoVisitor);
};

class fi_tcl_IntersectionDenotation : public fi_tclVisitableTypeBase
{
public:
   fi_tcl_IntersectionDenotation():IntersectionNumber(),IntersectionNamePrefix(),IntersectionNameBody(0),IntersectionNameSuffix() {}
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   fi_tcl_IntersectionDenotation& operator=(const fi_tcl_IntersectionDenotation& coRef);
   fi_tcl_IntersectionDenotation(const fi_tcl_IntersectionDenotation& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
   fi_tcl_RoadNumber IntersectionNumber;
   fi_tclString IntersectionNamePrefix;
   fi_tclMultiLanguageString IntersectionNameBody;
   fi_tclString IntersectionNameSuffix;

   virtual tVoid vDestroy();
   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual tBool operator==(const fi_tcl_IntersectionDenotation& rfoCmp) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   virtual tS32 s32GetTypeId() const { return typesfi_tclToken::EN_INTERSECTIONDENOTATION;}
   virtual tVoid vTakeVisitor(fi_tclVisitorBase& rfoVisitor);
};

class fi_tcl_IntersectionPathDenotation : public fi_tclVisitableTypeBase
{
public:
   fi_tcl_IntersectionPathDenotation():EntranceMask(0),ExitMask(0),IntersectionDenotation() {}
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   fi_tcl_IntersectionPathDenotation& operator=(const fi_tcl_IntersectionPathDenotation& coRef);
   fi_tcl_IntersectionPathDenotation(const fi_tcl_IntersectionPathDenotation& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
   tU32 EntranceMask;
   tU32 ExitMask;
   fi_tcl_IntersectionDenotation IntersectionDenotation;

   virtual tVoid vDestroy();
   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual tBool operator==(const fi_tcl_IntersectionPathDenotation& rfoCmp) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   virtual tS32 s32GetTypeId() const { return typesfi_tclToken::EN_INTERSECTIONPATHDENOTATION;}
   virtual tVoid vTakeVisitor(fi_tclVisitorBase& rfoVisitor);
};

class fi_tcl_IntersectionPathDesc : public fi_tclVisitableTypeBase
{
public:
   fi_tcl_IntersectionPathDesc():IntersectionType(),IntersectionDiameter(),IntersectionCenterCoordinates() {}
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   fi_tcl_IntersectionPathDesc& operator=(const fi_tcl_IntersectionPathDesc& coRef);
   fi_tcl_IntersectionPathDesc(const fi_tcl_IntersectionPathDesc& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
   fi_tcl_e8_IntersectionType IntersectionType;
   std::vector<fi_tcl_IntersectionPathDenotation, std::allocator<fi_tcl_IntersectionPathDenotation> > IntersectionDenotationList;
   fi_tcl_s32_EMU IntersectionDiameter;
   fi_tcl_PositionWGS84 IntersectionCenterCoordinates;
   std::vector<fi_tcl_CrossroadDesc, std::allocator<fi_tcl_CrossroadDesc> > CrossroadList;

   virtual tVoid vDestroy();
   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual tBool operator==(const fi_tcl_IntersectionPathDesc& rfoCmp) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   virtual tS32 s32GetTypeId() const { return typesfi_tclToken::EN_INTERSECTIONPATHDESC;}
   virtual tVoid vTakeVisitor(fi_tclVisitorBase& rfoVisitor);
};

class fi_tcl_IntersectionDescElement : public fi_tclVisitableTypeBase
{
public:
   fi_tcl_IntersectionDescElement():IntersectionType(),IntersectionDenotation(),IntersectionDiameter(),IntersectionCenterCoordinates() {}
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   fi_tcl_IntersectionDescElement& operator=(const fi_tcl_IntersectionDescElement& coRef);
   fi_tcl_IntersectionDescElement(const fi_tcl_IntersectionDescElement& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
   fi_tcl_e8_IntersectionType IntersectionType;
   fi_tcl_IntersectionDenotation IntersectionDenotation;
   fi_tcl_s32_EMU IntersectionDiameter;
   fi_tcl_PositionWGS84 IntersectionCenterCoordinates;
   std::vector<fi_tcl_CrossroadDesc, std::allocator<fi_tcl_CrossroadDesc> > CrossroadList;
   std::vector<fi_tcl_CrossroadInfo, std::allocator<fi_tcl_CrossroadInfo> > CrossroadInfoList;

   virtual tVoid vDestroy();
   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual tBool operator==(const fi_tcl_IntersectionDescElement& rfoCmp) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   virtual tS32 s32GetTypeId() const { return typesfi_tclToken::EN_INTERSECTIONDESCELEMENT;}
   virtual tVoid vTakeVisitor(fi_tclVisitorBase& rfoVisitor);
};

class fi_tcl_NavIntersectionListSet : public fi_tclVisitableTypeBase
{
public:
   fi_tcl_NavIntersectionListSet():CrossroadInfoElementRefList() {}
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   fi_tcl_NavIntersectionListSet& operator=(const fi_tcl_NavIntersectionListSet& coRef);
   fi_tcl_NavIntersectionListSet(const fi_tcl_NavIntersectionListSet& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
   std::vector<fi_tcl_IndexInReferenceList, std::allocator<fi_tcl_IndexInReferenceList> > ElementInRefList;
   std::vector<fi_tcl_IntersectionPathDesc, std::allocator<fi_tcl_IntersectionPathDesc> > IntersectionPathRefList;
   fi_tcl_NavPlainPathListSet CrossroadInfoElementRefList;
   std::vector<fi_tcl_CrossroadInfo, std::allocator<fi_tcl_CrossroadInfo> > CrossroadInfoList;

   virtual tVoid vDestroy();
   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual tBool operator==(const fi_tcl_NavIntersectionListSet& rfoCmp) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   virtual tS32 s32GetTypeId() const { return typesfi_tclToken::EN_NAVINTERSECTIONLISTSET;}
   virtual tVoid vTakeVisitor(fi_tclVisitorBase& rfoVisitor);
};

class fi_tcl_IntersectionListSet : public fi_tclVisitableTypeBase
{
public:
   fi_tcl_IntersectionListSet() {}
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   fi_tcl_IntersectionListSet& operator=(const fi_tcl_IntersectionListSet& coRef);
   fi_tcl_IntersectionListSet(const fi_tcl_IntersectionListSet& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
   std::vector<fi_tcl_IndexInReferenceList, std::allocator<fi_tcl_IndexInReferenceList> > ElementInRefList;
   std::vector<fi_tcl_IntersectionDescElement, std::allocator<fi_tcl_IntersectionDescElement> > IntersectionRefList;
   std::vector<fi_tcl_CrossroadInfo, std::allocator<fi_tcl_CrossroadInfo> > CrossroadInfoList;

   virtual tVoid vDestroy();
   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual tBool operator==(const fi_tcl_IntersectionListSet& rfoCmp) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   virtual tS32 s32GetTypeId() const { return typesfi_tclToken::EN_INTERSECTIONLISTSET;}
   virtual tVoid vTakeVisitor(fi_tclVisitorBase& rfoVisitor);
};

class fi_tcl_e16_BaseTrafficSign : public fi_tclVisitableTypeBase
{
public:
   fi_tcl_e16_BaseTrafficSign():enType(FI_EN_UNSPECIFIED) {}

   enum tenType {
      FI_EN_UNSPECIFIED = 0UL,
      FI_EN_SPEEDLIMIT = 1UL,
      FI_EN_SPEEDRECOMMEND = 2UL
   };
   tenType enType;

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual tBool operator==(const fi_tcl_e16_BaseTrafficSign& rfoCmp) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   virtual tS32 s32GetTypeId() const { return typesfi_tclToken::EN_E16_BASETRAFFICSIGN;}
   virtual tVoid vTakeVisitor(fi_tclVisitorBase& rfoVisitor);
};

class fi_tcl_e8_BaseTrafficSignCategory : public fi_tclVisitableTypeBase
{
public:
   fi_tcl_e8_BaseTrafficSignCategory():enType(FI_EN_T_RESERVED) {}

   enum tenType {
      FI_EN_T_RESERVED = 0UL,
      FI_EN_T_E8_SPEEDSIGN = 1UL,
      FI_EN_T_E16_WARNINGSIGN = 2UL,
      FI_EN_T_E16_REGULATORYSIGN = 3UL
   };
   tenType enType;

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual tBool operator==(const fi_tcl_e8_BaseTrafficSignCategory& rfoCmp) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   virtual tS32 s32GetTypeId() const { return typesfi_tclToken::EN_E8_BASETRAFFICSIGNCATEGORY;}
   virtual tVoid vTakeVisitor(fi_tclVisitorBase& rfoVisitor);
};

class fi_tcl_e8_SpeedSign : public fi_tclVisitableTypeBase
{
public:
   fi_tcl_e8_SpeedSign():enType(FI_EN_UNSPECIFIED) {}

   enum tenType {
      FI_EN_UNSPECIFIED = 0UL,
      FI_EN_SPEEDLIMIT = 1UL,
      FI_EN_SPEEDRECOMMEND = 2UL
   };
   tenType enType;

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual tBool operator==(const fi_tcl_e8_SpeedSign& rfoCmp) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   virtual tS32 s32GetTypeId() const { return typesfi_tclToken::EN_E8_SPEEDSIGN;}
   virtual tVoid vTakeVisitor(fi_tclVisitorBase& rfoVisitor);
};

class fi_tcl_e16_WarningSign : public fi_tclVisitableTypeBase
{
public:
   fi_tcl_e16_WarningSign():enType(FI_EN_UNSPECIFIED) {}

   enum tenType {
      FI_EN_UNSPECIFIED = 0UL,
      FI_EN_GENERALWARNING = 1010UL,
      FI_EN_DANGEROUSCROSSING = 1020UL,
      FI_EN_LEFTSINGLECURVE = 1031UL,
      FI_EN_RIGHTSINGLECURVE = 1032UL,
      FI_EN_SCURVEFIRSTLEFT = 1051UL,
      FI_EN_SCURVEFIRSTRIGHT = 1052UL,
      FI_EN_SLOPEDOWNGRADE = 1080UL,
      FI_EN_SLOPEUPGRADE = 1100UL,
      FI_EN_SPEEDRAMPS = 1120UL,
      FI_EN_SNOWORBLACKICE = 1130UL,
      FI_EN_SLIPPERYROAD = 1140UL,
      FI_EN_FALLINGROCKSFROMRIGHT = 1151UL,
      FI_EN_FALLINGROCKSFROMLEFT = 1152UL,
      FI_EN_BANK = 1160UL,
      FI_EN_CROSSWINDFROMRIGHT = 1171UL,
      FI_EN_CROSSWINDFROMLEFT = 1172UL,
      FI_EN_CONSTRICTIONBOTHSIDES = 1200UL,
      FI_EN_CONSTRICTIONRIGHTSIDE = 1211UL,
      FI_EN_CONSTRICTIONLEFTSIDE = 1212UL,
      FI_EN_CONSTRUCTIONAHEAD = 1230UL,
      FI_EN_TRAFFICCONGESTIONLIKELY = 1240UL,
      FI_EN_TWOWAYTRAFFIC = 1250UL,
      FI_EN_MOVEABLEBRIDGE = 1280UL,
      FI_EN_COASTFERRYBASSIN = 1290UL,
      FI_EN_TRAFFICLIGHT = 1310UL,
      FI_EN_PEDESTRIANCROSSINGRIGHT = 1331UL,
      FI_EN_PEDESTRIANCROSSINGLEFT = 1332UL,
      FI_EN_ZEBRACROSSINGRIGHT = 1341UL,
      FI_EN_ZEBRACROSSINGLEFT = 1342UL,
      FI_EN_CHILDRENCROSSINGRIGHT = 1361UL,
      FI_EN_CHILDRENCROSSINGLEFT = 1362UL,
      FI_EN_BICYCLESCROSSINGRIGHT = 1381UL,
      FI_EN_BICYCLESCROSSINGLEFT = 1382UL,
      FI_EN_DOMESTICANIMALSCROSSINGRIGHT = 1401UL,
      FI_EN_DOMESTICANIMALSCROSSINGLEFT = 1402UL,
      FI_EN_WILDANIMALSCROSSINGRIGHT = 1421UL,
      FI_EN_WILDANIMALSCROSSINGLEFT = 1422UL,
      FI_EN_AIRTRAFFICRIGHT = 1441UL,
      FI_EN_AIRTRAFFICLEFT = 1442UL,
      FI_EN_BUSESENTERINGORLEAVINGROADWAY = 1450UL,
      FI_EN_RAILROADCROSSINGWITHBARRIER = 1500UL,
      FI_EN_UNPROTECTEDRAILROADCROSSING = 1510UL,
      FI_EN_THREESTRIPEDBAKEBEFOREUNPROTECTEDRAILROADCROSSING = 1530UL,
      FI_EN_THREESTRIPEDBAKEBEFORERAILROADCROSSINGWITHBARRIER = 1560UL,
      FI_EN_THREESTRIPEDBAKERIGHT = 1571UL,
      FI_EN_THREESTRIPEDBAKELEFT = 1572UL,
      FI_EN_TWOSTRIPEDBAKERIGHT = 1591UL,
      FI_EN_TWOSTRIPEDBAKELEFT = 1592UL,
      FI_EN_ONESTRIPEDBAKERIGHT = 1621UL,
      FI_EN_ONESTRIPEDBAKELEFT = 1622UL,
      FI_EN_NOUTURNFORTRUCKS = 6011UL,
      FI_EN_CURVEDIRECTIONPLATELEFT = 6251UL,
      FI_EN_CURVEDIRECTIONPLATERIGHT = 6252UL
   };
   tenType enType;

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual tBool operator==(const fi_tcl_e16_WarningSign& rfoCmp) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   virtual tS32 s32GetTypeId() const { return typesfi_tclToken::EN_E16_WARNINGSIGN;}
   virtual tVoid vTakeVisitor(fi_tclVisitorBase& rfoVisitor);
};

class fi_tcl_e16_RegulatorySign : public fi_tclVisitableTypeBase
{
public:
   fi_tcl_e16_RegulatorySign():enType(FI_EN_UNSPECIFIED) {}

   enum tenType {
      FI_EN_UNSPECIFIED = 0UL,
      FI_EN_GENERALPROHIBITION = 2500UL,
      FI_EN_PROHIBITIONFORCARS = 2510UL,
      FI_EN_PROHIBITIONFORTRUCKS = 2530UL,
      FI_EN_PROHIBITIONFORDANGEROUSGOODS = 2610UL,
      FI_EN_MAXIMUMTOTALWEIGHT = 2620UL,
      FI_EN_MAXIMUMLOADPERAXLE = 2630UL,
      FI_EN_MAXIMUMVEHICLEWIDTH = 2640UL,
      FI_EN_MAXIMUMVEHICLEHEIGHT = 2650UL,
      FI_EN_MAXIMUMVEHICLELENGTH = 2660UL,
      FI_EN_MANDATORYSNOWCHAINS = 2680UL,
      FI_EN_PROHIBITIONFORWATERPOLLUTINGGOODS = 2690UL,
      FI_EN_PROHIBITIONFOREXPLOSIVEGOODS = 2691UL
   };
   tenType enType;

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual tBool operator==(const fi_tcl_e16_RegulatorySign& rfoCmp) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   virtual tS32 s32GetTypeId() const { return typesfi_tclToken::EN_E16_REGULATORYSIGN;}
   virtual tVoid vTakeVisitor(fi_tclVisitorBase& rfoVisitor);
};

class fi_tcl_e16_AdditionalTrafficSign : public fi_tclVisitableTypeBase
{
public:
   fi_tcl_e16_AdditionalTrafficSign():enType(FI_EN_UNSPECIFIED) {}

   enum tenType {
      FI_EN_UNSPECIFIED = 0UL,
      FI_EN_TIMEDEPENDENT = 1UL,
      FI_EN_VEHICLETYPE = 2UL,
      FI_EN_WEATHER = 3UL,
      FI_EN_WETNESS = 4UL,
      FI_EN_WIND = 5UL,
      FI_EN_INDISTANCEMETER = 6UL,
      FI_EN_INDISTANCEKILOMETER = 7UL,
      FI_EN_DIRECTIONLEFTDIRECTARROW = 10UL,
      FI_EN_DIRECTIONLEFTCIRCLEARROW = 11UL,
      FI_EN_DIRECTIONRIGHTDIRECTARROW = 20UL,
      FI_EN_DIRECTIONRIGHTCIRCLEARROW = 21UL,
      FI_EN_OPPOSITETRAFFIC = 31UL,
      FI_EN_BICYCLESCROSSING = 32UL,
      FI_EN_VALIDITYLENGTHMETER = 130UL,
      FI_EN_VALIDITYLENGTHKILOMETER = 131UL,
      FI_EN_STOPINDISTANCEMETER = 431UL,
      FI_EN_OIL = 630UL,
      FI_EN_SMOKE = 631UL,
      FI_EN_BADROADCONDITION = 632UL,
      FI_EN_BUILDINGVEHICLESCOMINGOUT = 633UL,
      FI_EN_STREETDAMAGED = 634UL,
      FI_EN_STREETDIRTY = 635UL,
      FI_EN_DANGEROFCOLLISION = 636UL,
      FI_EN_TOAD = 637UL,
      FI_EN_DANGEROFCONGESTION = 638UL,
      FI_EN_TREECLOSETOSTREETBOUNDARY = 639UL,
      FI_EN_SNOWORBLACKICE = 730UL,
      FI_EN_RIGHTOFWAYCHANGED = 830UL,
      FI_EN_ROADGEOMETRYCHANGED = 831UL,
      FI_EN_INDUSTRIALAREATRAINSHAVERIGHTOFWAY = 832UL,
      FI_EN_PORTAREATRAINSHAVERIGHTOFWAY = 833UL,
      FI_EN_PLAYINGCHILDREN = 1010UL,
      FI_EN_SKIDRIVERSCROSSING = 1011UL,
      FI_EN_START = 1230UL,
      FI_EN_END = 1231UL,
      FI_EN_SCHOOL = 3012UL,
      FI_EN_KINDERGARDEN = 3013UL,
      FI_EN_SKIDRIVERSCROSSINGATCERTAINTIME = 4010UL,
      FI_EN_RADARCONTROL = 4002UL,
      FI_EN_SCHOOLBUSWITHTIME = 4236UL,
      FI_EN_VALIDFORCARS = 4810UL,
      FI_EN_VALIDFORCARSWITHTRAILER = 4811UL,
      FI_EN_VALIDFORVEHICLESWITHPERMITTEDGROSSWEIGHTOVER3DOT5TONS = 4812UL,
      FI_EN_VALIDFORTRUCKSWITHTRAILER = 4813UL,
      FI_EN_VALIDFORARTICULATEDLORRY = 4814UL,
      FI_EN_VALIDFORTRUCKSWITHTRAILERANDARTICULATEDLORRY = 4815UL,
      FI_EN_VALIDFORBUSSES = 4816UL,
      FI_EN_VALIDFORVEHILCESWITHPERMITTEDGROSSWEIGHTOVER3DOT5TONSANDBUSSESANDCARSWITHTRAILERS = 4913UL,
      FI_EN_VEHICLEWITHEXPLOSIVELOAD = 5230UL,
      FI_EN_VEHICLEWITHWATERPOLLUTINGLOAD = 5231UL,
      FI_EN_BYWETNESS = 5236UL,
      FI_EN_UNSECUREDSTREETBORDER = 5238UL,
      FI_EN_RISKOFSKIDDINGFORCARWITHTRAILER = 6010UL
   };
   tenType enType;

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual tBool operator==(const fi_tcl_e16_AdditionalTrafficSign& rfoCmp) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   virtual tS32 s32GetTypeId() const { return typesfi_tclToken::EN_E16_ADDITIONALTRAFFICSIGN;}
   virtual tVoid vTakeVisitor(fi_tclVisitorBase& rfoVisitor);
};

class fi_tcl_TimeDependentString : public fi_tclVisitableTypeBase
{
public:
   fi_tcl_TimeDependentString(tString _szValue = 0):szValue(_szValue) {} 

   fi_tclString szValue;

   virtual tVoid vDestroy();
   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual tBool operator==(const fi_tcl_TimeDependentString& rfoCmp) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   virtual tS32 s32GetTypeId() const { return typesfi_tclToken::EN_TIMEDEPENDENTSTRING;}
   virtual tVoid vTakeVisitor(fi_tclVisitorBase& rfoVisitor);
};

class fi_tcl_b8_LaneDependentValidity : public fi_tclVisitableTypeBase
{
public:
   fi_tcl_b8_LaneDependentValidity():u8Value(0) {}

   enum {
      FI_C_U8_BIT_LANE0 = 0x1UL,
      FI_C_U8_BIT_LANE1 = 0x2UL,
      FI_C_U8_BIT_LANE2 = 0x4UL,
      FI_C_U8_BIT_LANE3 = 0x8UL,
      FI_C_U8_BIT_LANE4 = 0x10UL,
      FI_C_U8_BIT_LANE5 = 0x20UL,
      FI_C_U8_BIT_LANE6 = 0x40UL,
      FI_C_U8_BIT_LANE7 = 0x80UL
   };
   tBool bLane0() const {return (u8Value & FI_C_U8_BIT_LANE0) != 0; }
   tVoid vSetLane0(tBool bSetBit) { u8Value = (bSetBit)?(u8Value | FI_C_U8_BIT_LANE0):(u8Value & ~FI_C_U8_BIT_LANE0); }
   tBool bLane1() const {return (u8Value & FI_C_U8_BIT_LANE1) != 0; }
   tVoid vSetLane1(tBool bSetBit) { u8Value = (bSetBit)?(u8Value | FI_C_U8_BIT_LANE1):(u8Value & ~FI_C_U8_BIT_LANE1); }
   tBool bLane2() const {return (u8Value & FI_C_U8_BIT_LANE2) != 0; }
   tVoid vSetLane2(tBool bSetBit) { u8Value = (bSetBit)?(u8Value | FI_C_U8_BIT_LANE2):(u8Value & ~FI_C_U8_BIT_LANE2); }
   tBool bLane3() const {return (u8Value & FI_C_U8_BIT_LANE3) != 0; }
   tVoid vSetLane3(tBool bSetBit) { u8Value = (bSetBit)?(u8Value | FI_C_U8_BIT_LANE3):(u8Value & ~FI_C_U8_BIT_LANE3); }
   tBool bLane4() const {return (u8Value & FI_C_U8_BIT_LANE4) != 0; }
   tVoid vSetLane4(tBool bSetBit) { u8Value = (bSetBit)?(u8Value | FI_C_U8_BIT_LANE4):(u8Value & ~FI_C_U8_BIT_LANE4); }
   tBool bLane5() const {return (u8Value & FI_C_U8_BIT_LANE5) != 0; }
   tVoid vSetLane5(tBool bSetBit) { u8Value = (bSetBit)?(u8Value | FI_C_U8_BIT_LANE5):(u8Value & ~FI_C_U8_BIT_LANE5); }
   tBool bLane6() const {return (u8Value & FI_C_U8_BIT_LANE6) != 0; }
   tVoid vSetLane6(tBool bSetBit) { u8Value = (bSetBit)?(u8Value | FI_C_U8_BIT_LANE6):(u8Value & ~FI_C_U8_BIT_LANE6); }
   tBool bLane7() const {return (u8Value & FI_C_U8_BIT_LANE7) != 0; }
   tVoid vSetLane7(tBool bSetBit) { u8Value = (bSetBit)?(u8Value | FI_C_U8_BIT_LANE7):(u8Value & ~FI_C_U8_BIT_LANE7); }
   struct rBitValues {
      unsigned int Lane0:1;
      unsigned int Lane1:1;
      unsigned int Lane2:1;
      unsigned int Lane3:1;
      unsigned int Lane4:1;
      unsigned int Lane5:1;
      unsigned int Lane6:1;
      unsigned int Lane7:1;
   };
   union {
      tU8 u8Value;
      rBitValues bits;
   };

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual tBool operator==(const fi_tcl_b8_LaneDependentValidity& rfoCmp) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   virtual tS32 s32GetTypeId() const { return typesfi_tclToken::EN_B8_LANEDEPENDENTVALIDITY;}
   virtual tVoid vTakeVisitor(fi_tclVisitorBase& rfoVisitor);
};

class fi_tcl_e8_TrafficSignQuantifier : public fi_tclVisitableTypeBase
{
public:
   fi_tcl_e8_TrafficSignQuantifier():enType(FI_EN_T_RESERVED) {}

   enum tenType {
      FI_EN_T_RESERVED = 0UL,
      FI_EN_T_S16_KMPERHOUR = 1UL,
      FI_EN_T_S16_MILESPERHOUR = 2UL,
      FI_EN_TSTRING = 3UL,
      FI_EN_T_U8_PERCENT = 4UL,
      FI_EN_T_B8_LANEDEPENDENTVALIDITY = 5UL,
      FI_EN_T_TIMEDEPENDENTSTRING = 6UL,
      FI_EN_T_S32_METER = 7UL,
      FI_EN_T_S32_YARDS = 8UL,
      FI_EN_TMULTILANGUAGESTRING = 9UL,
      FI_EN_T_S32_CENTIMETER = 10UL,
      FI_EN_T_S32_INCH = 11UL,
      FI_EN_T_S32_KILOGRAM = 12UL,
      FI_EN_T_S32_POUND = 13UL
   };
   tenType enType;

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual tBool operator==(const fi_tcl_e8_TrafficSignQuantifier& rfoCmp) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   virtual tS32 s32GetTypeId() const { return typesfi_tclToken::EN_E8_TRAFFICSIGNQUANTIFIER;}
   virtual tVoid vTakeVisitor(fi_tclVisitorBase& rfoVisitor);
};

class fi_tcl_AdditionalTrafficSign : public fi_tclVisitableTypeBase
{
public:
   fi_tcl_AdditionalTrafficSign():AdditionalSign(),poQuantifierOfAddSignData(0) {}
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   fi_tcl_AdditionalTrafficSign& operator=(const fi_tcl_AdditionalTrafficSign& coRef);
   fi_tcl_AdditionalTrafficSign(const fi_tcl_AdditionalTrafficSign& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
   fi_tcl_e16_AdditionalTrafficSign AdditionalSign;
   fi_tcl_e8_TrafficSignQuantifier QuantifierOfAddSignType;
   fi_tclTypeBase* poQuantifierOfAddSignData;
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   virtual ~fi_tcl_AdditionalTrafficSign();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   virtual tVoid vDestroy();
   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual tBool operator==(const fi_tcl_AdditionalTrafficSign& rfoCmp) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   virtual tS32 s32GetTypeId() const { return typesfi_tclToken::EN_ADDITIONALTRAFFICSIGN;}
   virtual tVoid vTakeVisitor(fi_tclVisitorBase& rfoVisitor);
};

class fi_tcl_TrafficSignElement : public fi_tclVisitableTypeBase
{
public:
   fi_tcl_TrafficSignElement():DynamicTrafficSign(0),VirtualTrafficSign(0),poBaseSignUnionData(0),poQuantifierOfBaseSignData(0) {}
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   fi_tcl_TrafficSignElement& operator=(const fi_tcl_TrafficSignElement& coRef);
   fi_tcl_TrafficSignElement(const fi_tcl_TrafficSignElement& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
   tBool DynamicTrafficSign;
   tBool VirtualTrafficSign;
   fi_tcl_e8_BaseTrafficSignCategory BaseSignUnionType;
   fi_tclTypeBase* poBaseSignUnionData;
   fi_tcl_e8_TrafficSignQuantifier QuantifierOfBaseSignType;
   fi_tclTypeBase* poQuantifierOfBaseSignData;
   std::vector<fi_tcl_AdditionalTrafficSign, std::allocator<fi_tcl_AdditionalTrafficSign> > AdditionalSignList;
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   virtual ~fi_tcl_TrafficSignElement();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   virtual tVoid vDestroy();
   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual tBool operator==(const fi_tcl_TrafficSignElement& rfoCmp) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   virtual tS32 s32GetTypeId() const { return typesfi_tclToken::EN_TRAFFICSIGNELEMENT;}
   virtual tVoid vTakeVisitor(fi_tclVisitorBase& rfoVisitor);
};

class fi_tcl_TrafficSignList : public fi_tclVisitableTypeBase
{
public:
   fi_tcl_TrafficSignList() {}
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   fi_tcl_TrafficSignList& operator=(const fi_tcl_TrafficSignList& coRef);
   fi_tcl_TrafficSignList(const fi_tcl_TrafficSignList& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
   std::vector<fi_tcl_TrafficSignElement, std::allocator<fi_tcl_TrafficSignElement> > TrafficSignRoadList;

   virtual tVoid vDestroy();
   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual tBool operator==(const fi_tcl_TrafficSignList& rfoCmp) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   virtual tS32 s32GetTypeId() const { return typesfi_tclToken::EN_TRAFFICSIGNLIST;}
   virtual tVoid vTakeVisitor(fi_tclVisitorBase& rfoVisitor);
};

class fi_tcl_RoadInfoCombination : public fi_tclVisitableTypeBase
{
public:
   fi_tcl_RoadInfoCombination():RoadElement(),InfoElement(),StartOffset(),Length(),ID(0) {}
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   fi_tcl_RoadInfoCombination& operator=(const fi_tcl_RoadInfoCombination& coRef);
   fi_tcl_RoadInfoCombination(const fi_tcl_RoadInfoCombination& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
   fi_tcl_u16_IndexInReferenceList RoadElement;
   fi_tcl_u16_IndexInReferenceList InfoElement;
   fi_tcl_s32_Meter StartOffset;
   fi_tcl_s32_Meter Length;
   tU32 ID;

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual tBool operator==(const fi_tcl_RoadInfoCombination& rfoCmp) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   virtual tS32 s32GetTypeId() const { return typesfi_tclToken::EN_ROADINFOCOMBINATION;}
   virtual tVoid vTakeVisitor(fi_tclVisitorBase& rfoVisitor);
};

class fi_tcl_TrafficSignListSet : public fi_tclVisitableTypeBase
{
public:
   fi_tcl_TrafficSignListSet() {}
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   fi_tcl_TrafficSignListSet& operator=(const fi_tcl_TrafficSignListSet& coRef);
   fi_tcl_TrafficSignListSet(const fi_tcl_TrafficSignListSet& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
   std::vector<fi_tcl_RoadInfoCombination, std::allocator<fi_tcl_RoadInfoCombination> > CombinationList;
   std::vector<fi_tcl_TrafficSignElement, std::allocator<fi_tcl_TrafficSignElement> > TrafficSignList;

   virtual tVoid vDestroy();
   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual tBool operator==(const fi_tcl_TrafficSignListSet& rfoCmp) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   virtual tS32 s32GetTypeId() const { return typesfi_tclToken::EN_TRAFFICSIGNLISTSET;}
   virtual tVoid vTakeVisitor(fi_tclVisitorBase& rfoVisitor);
};

class fi_tcl_b32_POICategory : public fi_tclVisitableTypeBase
{
public:
   fi_tcl_b32_POICategory():u32Value(0) {}

   enum {
      FI_C_U32_BIT_PARKINGAREA = 0x1UL,
      FI_C_U32_BIT_PETROLSTATION = 0x2UL,
      FI_C_U32_BIT_RESTAURANT = 0x4UL,
      FI_C_U32_BIT_AUTOHOF = 0x8UL,
      FI_C_U32_BIT_MOTEL = 0x10UL,
      FI_C_U32_BIT_WC = 0x20UL,
      FI_C_U32_BIT_KIOSK = 0x40UL,
      FI_C_U32_BIT_AIRPORT = 0x80UL,
      FI_C_U32_BIT_FIRSTAIDPOINT = 0x100UL,
      FI_C_U32_BIT_INDUSTIALAREA = 0x200UL,
      FI_C_U32_BIT_RAILWAYSTATION = 0x400UL,
      FI_C_U32_BIT_BUSSTATION = 0x800UL,
      FI_C_U32_BIT_HARBOUR = 0x1000UL,
      FI_C_U32_BIT_INFORMATIONCENTRE = 0x2000UL,
      FI_C_U32_BIT_RESTAREA = 0x4000UL,
      FI_C_U32_BIT_FAIR = 0x8000UL,
      FI_C_U32_BIT_HOSPITAL = 0x10000UL,
      FI_C_U32_BIT_FERRYCONNECTION = 0x20000UL
   };
   tBool bParkingArea() const {return (u32Value & FI_C_U32_BIT_PARKINGAREA) != 0; }
   tVoid vSetParkingArea(tBool bSetBit) { u32Value = (bSetBit)?(u32Value | FI_C_U32_BIT_PARKINGAREA):(u32Value & ~FI_C_U32_BIT_PARKINGAREA); }
   tBool bPetrolStation() const {return (u32Value & FI_C_U32_BIT_PETROLSTATION) != 0; }
   tVoid vSetPetrolStation(tBool bSetBit) { u32Value = (bSetBit)?(u32Value | FI_C_U32_BIT_PETROLSTATION):(u32Value & ~FI_C_U32_BIT_PETROLSTATION); }
   tBool bRestaurant() const {return (u32Value & FI_C_U32_BIT_RESTAURANT) != 0; }
   tVoid vSetRestaurant(tBool bSetBit) { u32Value = (bSetBit)?(u32Value | FI_C_U32_BIT_RESTAURANT):(u32Value & ~FI_C_U32_BIT_RESTAURANT); }
   tBool bAutohof() const {return (u32Value & FI_C_U32_BIT_AUTOHOF) != 0; }
   tVoid vSetAutohof(tBool bSetBit) { u32Value = (bSetBit)?(u32Value | FI_C_U32_BIT_AUTOHOF):(u32Value & ~FI_C_U32_BIT_AUTOHOF); }
   tBool bMotel() const {return (u32Value & FI_C_U32_BIT_MOTEL) != 0; }
   tVoid vSetMotel(tBool bSetBit) { u32Value = (bSetBit)?(u32Value | FI_C_U32_BIT_MOTEL):(u32Value & ~FI_C_U32_BIT_MOTEL); }
   tBool bWC() const {return (u32Value & FI_C_U32_BIT_WC) != 0; }
   tVoid vSetWC(tBool bSetBit) { u32Value = (bSetBit)?(u32Value | FI_C_U32_BIT_WC):(u32Value & ~FI_C_U32_BIT_WC); }
   tBool bKiosk() const {return (u32Value & FI_C_U32_BIT_KIOSK) != 0; }
   tVoid vSetKiosk(tBool bSetBit) { u32Value = (bSetBit)?(u32Value | FI_C_U32_BIT_KIOSK):(u32Value & ~FI_C_U32_BIT_KIOSK); }
   tBool bAirport() const {return (u32Value & FI_C_U32_BIT_AIRPORT) != 0; }
   tVoid vSetAirport(tBool bSetBit) { u32Value = (bSetBit)?(u32Value | FI_C_U32_BIT_AIRPORT):(u32Value & ~FI_C_U32_BIT_AIRPORT); }
   tBool bFirstAidPoint() const {return (u32Value & FI_C_U32_BIT_FIRSTAIDPOINT) != 0; }
   tVoid vSetFirstAidPoint(tBool bSetBit) { u32Value = (bSetBit)?(u32Value | FI_C_U32_BIT_FIRSTAIDPOINT):(u32Value & ~FI_C_U32_BIT_FIRSTAIDPOINT); }
   tBool bIndustialArea() const {return (u32Value & FI_C_U32_BIT_INDUSTIALAREA) != 0; }
   tVoid vSetIndustialArea(tBool bSetBit) { u32Value = (bSetBit)?(u32Value | FI_C_U32_BIT_INDUSTIALAREA):(u32Value & ~FI_C_U32_BIT_INDUSTIALAREA); }
   tBool bRailwayStation() const {return (u32Value & FI_C_U32_BIT_RAILWAYSTATION) != 0; }
   tVoid vSetRailwayStation(tBool bSetBit) { u32Value = (bSetBit)?(u32Value | FI_C_U32_BIT_RAILWAYSTATION):(u32Value & ~FI_C_U32_BIT_RAILWAYSTATION); }
   tBool bBusStation() const {return (u32Value & FI_C_U32_BIT_BUSSTATION) != 0; }
   tVoid vSetBusStation(tBool bSetBit) { u32Value = (bSetBit)?(u32Value | FI_C_U32_BIT_BUSSTATION):(u32Value & ~FI_C_U32_BIT_BUSSTATION); }
   tBool bHarbour() const {return (u32Value & FI_C_U32_BIT_HARBOUR) != 0; }
   tVoid vSetHarbour(tBool bSetBit) { u32Value = (bSetBit)?(u32Value | FI_C_U32_BIT_HARBOUR):(u32Value & ~FI_C_U32_BIT_HARBOUR); }
   tBool bInformationCentre() const {return (u32Value & FI_C_U32_BIT_INFORMATIONCENTRE) != 0; }
   tVoid vSetInformationCentre(tBool bSetBit) { u32Value = (bSetBit)?(u32Value | FI_C_U32_BIT_INFORMATIONCENTRE):(u32Value & ~FI_C_U32_BIT_INFORMATIONCENTRE); }
   tBool bRestArea() const {return (u32Value & FI_C_U32_BIT_RESTAREA) != 0; }
   tVoid vSetRestArea(tBool bSetBit) { u32Value = (bSetBit)?(u32Value | FI_C_U32_BIT_RESTAREA):(u32Value & ~FI_C_U32_BIT_RESTAREA); }
   tBool bFair() const {return (u32Value & FI_C_U32_BIT_FAIR) != 0; }
   tVoid vSetFair(tBool bSetBit) { u32Value = (bSetBit)?(u32Value | FI_C_U32_BIT_FAIR):(u32Value & ~FI_C_U32_BIT_FAIR); }
   tBool bHospital() const {return (u32Value & FI_C_U32_BIT_HOSPITAL) != 0; }
   tVoid vSetHospital(tBool bSetBit) { u32Value = (bSetBit)?(u32Value | FI_C_U32_BIT_HOSPITAL):(u32Value & ~FI_C_U32_BIT_HOSPITAL); }
   tBool bFerryConnection() const {return (u32Value & FI_C_U32_BIT_FERRYCONNECTION) != 0; }
   tVoid vSetFerryConnection(tBool bSetBit) { u32Value = (bSetBit)?(u32Value | FI_C_U32_BIT_FERRYCONNECTION):(u32Value & ~FI_C_U32_BIT_FERRYCONNECTION); }
   struct rBitValues {
      unsigned int ParkingArea:1;
      unsigned int PetrolStation:1;
      unsigned int Restaurant:1;
      unsigned int Autohof:1;
      unsigned int Motel:1;
      unsigned int WC:1;
      unsigned int Kiosk:1;
      unsigned int Airport:1;
      unsigned int FirstAidPoint:1;
      unsigned int IndustialArea:1;
      unsigned int RailwayStation:1;
      unsigned int BusStation:1;
      unsigned int Harbour:1;
      unsigned int InformationCentre:1;
      unsigned int RestArea:1;
      unsigned int Fair:1;
      unsigned int Hospital:1;
      unsigned int FerryConnection:1;
      unsigned int dummy18:1;
      unsigned int dummy19:1;
      unsigned int dummy20:1;
      unsigned int dummy21:1;
      unsigned int dummy22:1;
      unsigned int dummy23:1;
      unsigned int dummy24:1;
      unsigned int dummy25:1;
      unsigned int dummy26:1;
      unsigned int dummy27:1;
      unsigned int dummy28:1;
      unsigned int dummy29:1;
      unsigned int dummy30:1;
      unsigned int dummy31:1;
   };
   union {
      tU32 u32Value;
      rBitValues bits;
   };

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual tBool operator==(const fi_tcl_b32_POICategory& rfoCmp) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   virtual tS32 s32GetTypeId() const { return typesfi_tclToken::EN_B32_POICATEGORY;}
   virtual tVoid vTakeVisitor(fi_tclVisitorBase& rfoVisitor);
};

class fi_tcl_POIElement : public fi_tclVisitableTypeBase
{
public:
   fi_tcl_POIElement():Category(),Name(0),IsLocationValid(0),Location(),Position() {}
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   fi_tcl_POIElement& operator=(const fi_tcl_POIElement& coRef);
   fi_tcl_POIElement(const fi_tcl_POIElement& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
   fi_tcl_b32_POICategory Category;
   fi_tclMultiLanguageString Name;
   tBool IsLocationValid;
   fi_tcl_s32_Meter Location;
   fi_tcl_PositionWGS84 Position;

   virtual tVoid vDestroy();
   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual tBool operator==(const fi_tcl_POIElement& rfoCmp) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   virtual tS32 s32GetTypeId() const { return typesfi_tclToken::EN_POIELEMENT;}
   virtual tVoid vTakeVisitor(fi_tclVisitorBase& rfoVisitor);
};

class fi_tcl_POIListSet : public fi_tclVisitableTypeBase
{
public:
   fi_tcl_POIListSet() {}
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   fi_tcl_POIListSet& operator=(const fi_tcl_POIListSet& coRef);
   fi_tcl_POIListSet(const fi_tcl_POIListSet& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
   std::vector<fi_tcl_ReferenceElement, std::allocator<fi_tcl_ReferenceElement> > AlternativRefList;
   std::vector<fi_tcl_ReferenceElementWithID, std::allocator<fi_tcl_ReferenceElementWithID> > AlternativRefIDList;
   std::vector<fi_tcl_POIElement, std::allocator<fi_tcl_POIElement> > POIList;

   virtual tVoid vDestroy();
   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual tBool operator==(const fi_tcl_POIListSet& rfoCmp) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   virtual tS32 s32GetTypeId() const { return typesfi_tclToken::EN_POILISTSET;}
   virtual tVoid vTakeVisitor(fi_tclVisitorBase& rfoVisitor);
};

class fi_tcl_b8_InstructionStatus : public fi_tclVisitableTypeBase
{
public:
   fi_tcl_b8_InstructionStatus():u8Value(0) {}

   enum {
      FI_C_U8_BIT_STACKED = 0x1UL
   };
   tBool bStacked() const {return (u8Value & FI_C_U8_BIT_STACKED) != 0; }
   tVoid vSetStacked(tBool bSetBit) { u8Value = (bSetBit)?(u8Value | FI_C_U8_BIT_STACKED):(u8Value & ~FI_C_U8_BIT_STACKED); }
   struct rBitValues {
      unsigned int Stacked:1;
      unsigned int dummy1:1;
      unsigned int dummy2:1;
      unsigned int dummy3:1;
      unsigned int dummy4:1;
      unsigned int dummy5:1;
      unsigned int dummy6:1;
      unsigned int dummy7:1;
   };
   union {
      tU8 u8Value;
      rBitValues bits;
   };

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual tBool operator==(const fi_tcl_b8_InstructionStatus& rfoCmp) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   virtual tS32 s32GetTypeId() const { return typesfi_tclToken::EN_B8_INSTRUCTIONSTATUS;}
   virtual tVoid vTakeVisitor(fi_tclVisitorBase& rfoVisitor);
};

class fi_tcl_SimpleInstruction : public fi_tclVisitableTypeBase
{
public:
   fi_tcl_SimpleInstruction():IntersectionType(),TurnDirection(),TrafficSense(),Status() {}
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   fi_tcl_SimpleInstruction& operator=(const fi_tcl_SimpleInstruction& coRef);
   fi_tcl_SimpleInstruction(const fi_tcl_SimpleInstruction& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
   fi_tcl_e8_IntersectionType IntersectionType;
   fi_tcl_u8_DirectionRelative TurnDirection;
   fi_tcl_e8_SideInfo TrafficSense;
   fi_tcl_b8_InstructionStatus Status;

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual tBool operator==(const fi_tcl_SimpleInstruction& rfoCmp) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   virtual tS32 s32GetTypeId() const { return typesfi_tclToken::EN_SIMPLEINSTRUCTION;}
   virtual tVoid vTakeVisitor(fi_tclVisitorBase& rfoVisitor);
};

class fi_tcl_SimpleInstructionListSet : public fi_tclVisitableTypeBase
{
public:
   fi_tcl_SimpleInstructionListSet() {}
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   fi_tcl_SimpleInstructionListSet& operator=(const fi_tcl_SimpleInstructionListSet& coRef);
   fi_tcl_SimpleInstructionListSet(const fi_tcl_SimpleInstructionListSet& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
   std::vector<fi_tcl_ReferenceElement, std::allocator<fi_tcl_ReferenceElement> > AlternativRefList;
   std::vector<fi_tcl_SimpleInstruction, std::allocator<fi_tcl_SimpleInstruction> > SimpleInstructionList;

   virtual tVoid vDestroy();
   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual tBool operator==(const fi_tcl_SimpleInstructionListSet& rfoCmp) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   virtual tS32 s32GetTypeId() const { return typesfi_tclToken::EN_SIMPLEINSTRUCTIONLISTSET;}
   virtual tVoid vTakeVisitor(fi_tclVisitorBase& rfoVisitor);
};

class fi_tcl_SectionCharacteristics : public fi_tclVisitableTypeBase
{
public:
   fi_tcl_SectionCharacteristics():Length(),Time(),TimeFullTraffic(),TimeNoTraffic(),Fuel(),FuelFullTraffic(),FuelNoTraffic() {}
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   fi_tcl_SectionCharacteristics& operator=(const fi_tcl_SectionCharacteristics& coRef);
   fi_tcl_SectionCharacteristics(const fi_tcl_SectionCharacteristics& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
   fi_tcl_s32_Meter Length;
   fi_tcl_s32_Second Time;
   fi_tcl_s32_Second TimeFullTraffic;
   fi_tcl_s32_Second TimeNoTraffic;
   fi_tcl_s32_Microliter Fuel;
   fi_tcl_s32_Microliter FuelFullTraffic;
   fi_tcl_s32_Microliter FuelNoTraffic;

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual tBool operator==(const fi_tcl_SectionCharacteristics& rfoCmp) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   virtual tS32 s32GetTypeId() const { return typesfi_tclToken::EN_SECTIONCHARACTERISTICS;}
   virtual tVoid vTakeVisitor(fi_tclVisitorBase& rfoVisitor);
};

class fi_tcl_NavRouteId : public fi_tclVisitableTypeBase
{
public:
   fi_tcl_NavRouteId():TripHandle(),RouteHandle(),TripSegmentNumber(),ReleaseNumber(0) {}
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   fi_tcl_NavRouteId& operator=(const fi_tcl_NavRouteId& coRef);
   fi_tcl_NavRouteId(const fi_tcl_NavRouteId& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
   fi_tcl_u16_TripHandle TripHandle;
   fi_tcl_u16_RouteHandle RouteHandle;
   fi_tcl_u16_TripSegmentNumber TripSegmentNumber;
   tU32 ReleaseNumber;

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual tBool operator==(const fi_tcl_NavRouteId& rfoCmp) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   virtual tS32 s32GetTypeId() const { return typesfi_tclToken::EN_NAVROUTEID;}
   virtual tVoid vTakeVisitor(fi_tclVisitorBase& rfoVisitor);
};

class fi_tcl_b8_RouteProperties : public fi_tclVisitableTypeBase
{
public:
   fi_tcl_b8_RouteProperties():u8Value(0) {}

   enum {
      FI_C_U8_BIT_BLOCKAGES = 0x1UL
   };
   tBool bBlockages() const {return (u8Value & FI_C_U8_BIT_BLOCKAGES) != 0; }
   tVoid vSetBlockages(tBool bSetBit) { u8Value = (bSetBit)?(u8Value | FI_C_U8_BIT_BLOCKAGES):(u8Value & ~FI_C_U8_BIT_BLOCKAGES); }
   struct rBitValues {
      unsigned int Blockages:1;
      unsigned int dummy1:1;
      unsigned int dummy2:1;
      unsigned int dummy3:1;
      unsigned int dummy4:1;
      unsigned int dummy5:1;
      unsigned int dummy6:1;
      unsigned int dummy7:1;
   };
   union {
      tU8 u8Value;
      rBitValues bits;
   };

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual tBool operator==(const fi_tcl_b8_RouteProperties& rfoCmp) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   virtual tS32 s32GetTypeId() const { return typesfi_tclToken::EN_B8_ROUTEPROPERTIES;}
   virtual tVoid vTakeVisitor(fi_tclVisitorBase& rfoVisitor);
};

class fi_tcl_MostWorseManoeuvreInfo : public fi_tclVisitableTypeBase
{
public:
   fi_tcl_MostWorseManoeuvreInfo():Criticality(),RouteDeltaValues(),RouteProperties() {}
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   fi_tcl_MostWorseManoeuvreInfo& operator=(const fi_tcl_MostWorseManoeuvreInfo& coRef);
   fi_tcl_MostWorseManoeuvreInfo(const fi_tcl_MostWorseManoeuvreInfo& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
   fi_tcl_e8_ManoeuvreCriticality Criticality;
   fi_tcl_SectionCharacteristics RouteDeltaValues;
   fi_tcl_b8_RouteProperties RouteProperties;

   virtual tVoid vDestroy();
   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual tBool operator==(const fi_tcl_MostWorseManoeuvreInfo& rfoCmp) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   virtual tS32 s32GetTypeId() const { return typesfi_tclToken::EN_MOSTWORSEMANOEUVREINFO;}
   virtual tVoid vTakeVisitor(fi_tclVisitorBase& rfoVisitor);
};

class fi_tcl_CriticalDecisionPointListElement : public fi_tclVisitableTypeBase
{
public:
   fi_tcl_CriticalDecisionPointListElement():MostWorseNavInstruction(0),MostWorseManoeuvreInfo() {}
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   fi_tcl_CriticalDecisionPointListElement& operator=(const fi_tcl_CriticalDecisionPointListElement& coRef);
   fi_tcl_CriticalDecisionPointListElement(const fi_tcl_CriticalDecisionPointListElement& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
   tU32 MostWorseNavInstruction;
   fi_tcl_MostWorseManoeuvreInfo MostWorseManoeuvreInfo;

   virtual tVoid vDestroy();
   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual tBool operator==(const fi_tcl_CriticalDecisionPointListElement& rfoCmp) 