/************************************************************************
 
 *FILE:           alltypes.cpp
 
 *SW-COMPONENT:   FI Functional Interface
 
 *DESCRIPTION:    Interface fuer alle Typdefinitionen
                  
 *AUTHOR:         Jochen Bruns (CM-DI/ENS41)
 
 *COPYRIGHT:      (c) 2001 Blaupunkt GmbH
 
 ************************************************************************/

#include "precompiled.hh"
fi_tclOutContext& fi_tclU8::oWrite(fi_tclOutContext& oOut) const 
{
  oOut.oWrite(u8Value);
  return oOut;
}

fi_tclInContext& fi_tclU8::oRead(fi_tclInContext& oIn) 
{
  oIn.oRead(u8Value);
  return oIn;
}

tBool fi_tclU8::operator==(const fi_tclU8& rfoCmp) const
{
   return rfoCmp.u8Value == u8Value;
}

tU32 fi_tclU8::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 1;
}

fi_tclOutContext& fi_tclS8::oWrite(fi_tclOutContext& oOut) const 
{
  oOut.oWrite(s8Value);
  return oOut;
}

fi_tclInContext& fi_tclS8::oRead(fi_tclInContext& oIn) 
{
  oIn.oRead(s8Value);
  return oIn;
}

tBool fi_tclS8::operator==(const fi_tclS8& rfoCmp) const
{
   return rfoCmp.s8Value == s8Value;
}

tU32 fi_tclS8::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 1;
}

fi_tclOutContext& fi_tclU16::oWrite(fi_tclOutContext& oOut) const 
{
  oOut.oWrite(u16Value);
  return oOut;
}

fi_tclInContext& fi_tclU16::oRead(fi_tclInContext& oIn) 
{
  oIn.oRead(u16Value);
  return oIn;
}

tBool fi_tclU16::operator==(const fi_tclU16& rfoCmp) const
{
   return rfoCmp.u16Value == u16Value;
}

tU32 fi_tclU16::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 2;
}

fi_tclOutContext& fi_tclS16::oWrite(fi_tclOutContext& oOut) const 
{
  oOut.oWrite(s16Value);
  return oOut;
}

fi_tclInContext& fi_tclS16::oRead(fi_tclInContext& oIn) 
{
  oIn.oRead(s16Value);
  return oIn;
}

tBool fi_tclS16::operator==(const fi_tclS16& rfoCmp) const
{
   return rfoCmp.s16Value == s16Value;
}

tU32 fi_tclS16::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 2;
}

fi_tclOutContext& fi_tclU24::oWrite(fi_tclOutContext& oOut) const 
{
  oOut.oWrite(u24Value);
  return oOut;
}

fi_tclInContext& fi_tclU24::oRead(fi_tclInContext& oIn) 
{
  oIn.oRead(u24Value);
  return oIn;
}

tBool fi_tclU24::operator==(const fi_tclU24& rfoCmp) const
{
   return rfoCmp.u24Value == u24Value; //lint !e1702
}

tU32 fi_tclU24::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 3;
}

fi_tclOutContext& fi_tclS24::oWrite(fi_tclOutContext& oOut) const 
{
  oOut.oWrite(s24Value);
  return oOut;
}

fi_tclInContext& fi_tclS24::oRead(fi_tclInContext& oIn) 
{
  oIn.oRead(s24Value);
  return oIn;
}

tBool fi_tclS24::operator==(const fi_tclS24& rfoCmp) const
{
   return rfoCmp.s24Value == s24Value; //lint !e1702
}

tU32 fi_tclS24::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 3;
}

fi_tclOutContext& fi_tclU32::oWrite(fi_tclOutContext& oOut) const 
{
  oOut.oWrite(u32Value);
  return oOut;
}

fi_tclInContext& fi_tclU32::oRead(fi_tclInContext& oIn) 
{
  oIn.oRead(u32Value);
  return oIn;
}

tBool fi_tclU32::operator==(const fi_tclU32& rfoCmp) const
{
   return rfoCmp.u32Value == u32Value;
}

tU32 fi_tclU32::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 4;
}

fi_tclOutContext& fi_tclU64::oWrite(fi_tclOutContext& oOut) const 
{
  oOut.oWrite(u64Value);
  return oOut;
}

fi_tclInContext& fi_tclU64::oRead(fi_tclInContext& oIn) 
{
  oIn.oRead(u64Value);
  return oIn;
}

tBool fi_tclU64::operator==(const fi_tclU64& rfoCmp) const
{
   return rfoCmp.u64Value == u64Value;
}

tU32 fi_tclU64::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 8;
}

fi_tclOutContext& fi_tclS32::oWrite(fi_tclOutContext& oOut) const 
{
  oOut.oWrite(s32Value);
  return oOut;
}

fi_tclInContext& fi_tclS32::oRead(fi_tclInContext& oIn) 
{
  oIn.oRead(s32Value);
  return oIn;
}

tBool fi_tclS32::operator==(const fi_tclS32& rfoCmp) const
{
   return rfoCmp.s32Value == s32Value;
}

tU32 fi_tclS32::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 4;
}

fi_tclOutContext& fi_tclS64::oWrite(fi_tclOutContext& oOut) const 
{
  oOut.oWrite(s64Value);
  return oOut;
}

fi_tclInContext& fi_tclS64::oRead(fi_tclInContext& oIn) 
{
  oIn.oRead(s64Value);
  return oIn;
}

tBool fi_tclS64::operator==(const fi_tclS64& rfoCmp) const
{
   return rfoCmp.s64Value == s64Value;
}

tU32 fi_tclS64::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 8;
}

fi_tclOutContext& fi_tclF32::oWrite(fi_tclOutContext& oOut) const 
{
  oOut.oWrite(f32Value);
  return oOut;
}

fi_tclInContext& fi_tclF32::oRead(fi_tclInContext& oIn) 
{
  oIn.oRead(f32Value);
  return oIn;
}

tBool fi_tclF32::operator==(const fi_tclF32& rfoCmp) const
{
   return rfoCmp.f32Value == f32Value; //lint !e777
}

tU32 fi_tclF32::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 4;
}

fi_tclOutContext& fi_tclF64::oWrite(fi_tclOutContext& oOut) const 
{
  oOut.oWrite(f64Value);
  return oOut;
}

fi_tclInContext& fi_tclF64::oRead(fi_tclInContext& oIn) 
{
  oIn.oRead(f64Value);
  return oIn;
}

tBool fi_tclF64::operator==(const fi_tclF64& rfoCmp) const
{
   return rfoCmp.f64Value == f64Value; //lint !e777
}

tU32 fi_tclF64::u32GetSize(tU16 /*u16MajorVersion*/) const
{
  return 8;
}

fi_tclOutContext& fi_tclBool::oWrite(fi_tclOutContext& oOut) const 
{
  oOut.oWrite(bValue);
  return oOut;
}

fi_tclInContext& fi_tclBool::oRead(fi_tclInContext& oIn) 
{
  oIn.oRead(bValue);
  return oIn;
}

tBool fi_tclBool::operator==(const fi_tclBool& rfoCmp) const
{
   return rfoCmp.bValue == bValue;
}

tU32 fi_tclBool::u32GetSize(tU16 /*u16MajorVersion*/) const
{
  return 1;
}

fi_tclOutContext& fi_tclString::oWrite(fi_tclOutContext& oOut) const 
{
  oOut.oWrite(szValue);
  return oOut;
}

tVoid fi_tclString::vDestroy() 
{
  OSAL_DELETE[] szValue;
  szValue = OSAL_NULL;
}

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
fi_tclString::~fi_tclString() 
{
  OSAL_DELETE[] szValue;
  szValue = OSAL_NULL;
}

fi_tclString& fi_tclString::operator=(const fi_tclString& coRef)
{
   if (this == &coRef) return *this;

   OSAL_DELETE[] szValue;
   if (coRef.szValue != OSAL_NULL)
   {
      tU32 u32UTFStringLength = OSAL_u32StringLength(coRef.szValue) + 1;
      szValue = OSAL_NEW tChar[u32UTFStringLength];
	  if (szValue != OSAL_NULL)
      {
         (void)OSAL_szStringCopy(szValue,coRef.szValue);
      }
   }
   else
   {
      szValue = OSAL_NULL;
   }
   return *this;
}

fi_tclString::fi_tclString(const fi_tclString& coRef):fi_tclVisitableTypeBase(coRef)
{
   if (coRef.szValue != OSAL_NULL)
   {
      tU32 u32UTFStringLength = OSAL_u32StringLength(coRef.szValue) + 1;
      szValue = OSAL_NEW tChar[u32UTFStringLength];
      if (szValue != OSAL_NULL)
      {
         (void)OSAL_szStringCopy(szValue,coRef.szValue);
      }
   }
   else
   {
      szValue = OSAL_NULL;
   }
}
#endif

fi_tclInContext& fi_tclString::oRead(fi_tclInContext& oIn) 
{
  oIn.oRead(szValue);
  return oIn;
}

tBool fi_tclString::operator==(const fi_tclString& rfoCmp) const
{
   if ((szValue == OSAL_NULL) || (rfoCmp.szValue == OSAL_NULL))
   {
      if (szValue == rfoCmp.szValue)
      {
         return TRUE;
      }
      else
      {
         if (szValue == OSAL_NULL)
         {
            return (OSAL_u32StringLength(rfoCmp.szValue) == 0);
         }
         else
         {
            return (OSAL_u32StringLength(szValue) == 0);
         }
      }
   }
   else
   {
      return (0 == strcmp(szValue,rfoCmp.szValue));
   }
}

tU32 fi_tclString::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return FI_u32StringLength(szValue) + 1;
}

#ifndef FI_DO_NOT_USE_TSTRING
fi_tclString& fi_tclString::operator=(tCString coszString) // ADDED
{
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   if (coszString != OSAL_NULL)
   {
      // nothing to convert, just copy (UTF-8) string into member field
      tU32 u32UTFStringLength = OSAL_u32StringLength(coszString) + 1;
      OSAL_DELETE[] szValue;
      szValue = OSAL_NEW tChar[u32UTFStringLength];
      if (szValue)
      {
         (void)OSAL_szStringCopy(szValue,coszString);
      }
   }
   else
   {
      OSAL_DELETE[] szValue;
      szValue = OSAL_NULL;
   }
#else
   szValue = const_cast<tString>(coszString);
#endif
   return *this;
}

//fi_tclString::fi_tclString(const tString& coszString) // ADDED (changed from const tString to const tString&)
fi_tclString::fi_tclString(tCString coszString) // ADDED (changed from const tString& to tCString)
{
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   if (coszString != OSAL_NULL)
   {
      tU32 u32UTFStringLength = OSAL_u32StringLength(coszString) + 1;
      szValue = OSAL_NEW tChar[u32UTFStringLength];
      if (szValue)
      {
         (void)OSAL_szStringCopy(szValue,coszString);
      }
   }
   else
   {
      szValue = OSAL_NULL;
   }
#else
   szValue = const_cast<tString>(coszString);
#endif
}

tBool fi_tclString::operator==(tCString coszString) const // ADDED
{
   if ((szValue == OSAL_NULL) || (coszString == OSAL_NULL))
   {
      if (szValue == coszString)
      {
         return TRUE;
      }
      else
      {
         if (szValue == OSAL_NULL)
         {
            return (OSAL_u32StringLength(coszString) == 0); //lint !e668 : same constellation as in other compare operator, which is ok for LINT
         }
         else
         {
            return (OSAL_u32StringLength(szValue) == 0);
         }
      }
   }
   else
   {
      return (0 == strcmp(szValue,coszString));
   }
}

fi_tclString::operator tString&() // ADDED
{
   return szValue;
}

fi_tclString::operator const tChar* () const // ADDED
{
   return szValue;
}

tBool fi_tclString::operator!=(int iNULL) const // ADDED
{
   return szValue != (char*)iNULL;
}

static tChar FI_C_U8_NULLCHAR = '\0';

tChar* fi_tclString::operator+(int iOffset) // ADDED
{
   if (szValue)
      return szValue + iOffset;
   else
      return OSAL_NULL;
}

tChar* fi_tclString::operator+(tU8  u8Offset) // ADDED
{
   if (szValue)
      return szValue + u8Offset;
   else
      return OSAL_NULL;
}

tChar* fi_tclString::operator+(tU32 u32Offset) // ADDED
{
   if (szValue)
      return szValue + u32Offset;
   else
      return OSAL_NULL;
}

tChar& fi_tclString::operator[](tU16 u16Index) //ADDED
{
   if (szValue)
      return szValue[u16Index];
   else
      return FI_C_U8_NULLCHAR;
}

tChar& fi_tclString::operator[](tU32 u32Index) //ADDED
{
   if (szValue)
      return szValue[u32Index];
   else
      return FI_C_U8_NULLCHAR;
}

tChar& fi_tclString::operator[](tS32 s32Index) //ADDED
{
   if (szValue)
      return szValue[s32Index];
   else
      return FI_C_U8_NULLCHAR;
}
#endif

#ifndef FI_S_NO_STRING_ACCESS_METHODS

tBool fi_tclString::bSet(const fi_tclString& corfoInit, tenCharSet enCharSet)
{
   return bSet(corfoInit.szValue, enCharSet);
}

//tBool figroup_fi_tclString::bSet(const tString& coszInit, tenCharSet enCharSet)
tBool fi_tclString::bSet(tCString coszInit, tenCharSet enCharSet)
{
   tBool bSuccess = true;
   if (coszInit != OSAL_NULL)
   {
   switch (enCharSet)
   {
   case FI_EN_UTF8:
      {
#ifdef FI_S_UTFMODE_TRANSPARENT
         // nothing to convert, just copy UTF-8 string into member field
         tU32 u32UTFStringLength = OSAL_u32StringLength(coszInit) + 1;
         OSAL_DELETE[] szValue;
         szValue = OSAL_NEW tChar[u32UTFStringLength];
         if (szValue)
         {
            (void)OSAL_szStringCopy(szValue,coszInit);
         }
         else
         {
            bSuccess = false;
         }
#else
         // input is UTF8, FI assumes ISO-Mod internally, thus convert input
         tU32 u32UTFStringLength = OSAL_u32StringLength(coszInit) + 1;
         tU32 u32ISOStringLength = utfutil_u32ConvertUTF82ISOMod(
            0,
            0,
            coszInit,
            u32UTFStringLength
         );
         OSAL_DELETE[] szValue;
         szValue = OSAL_NEW tChar[u32ISOStringLength];
         if (szValue)
         {
            utfutil_u32ConvertUTF82ISOMod(
               szValue,
               u32ISOStringLength,
               coszInit,
               u32UTFStringLength
               );
         }
         else
         {
            bSuccess = false;
         }
#endif
      } break;
   case FI_EN_ISO8859_15M:
      {
#ifdef FI_S_UTFMODE_TRANSPARENT
         // input is ISO-Mod, FI assumes UTF8 internally, thus convert input
         tU32 u32ISOStringLength = OSAL_u32StringLength(coszInit) + 1;
         tU32 u32UTFStringLength = utfutil_u32ConvertISOMod2UTF8(
            0,
            0,
            coszInit,
            u32ISOStringLength
         );
         OSAL_DELETE[] szValue;
         szValue = OSAL_NEW tChar[u32UTFStringLength];
         if (szValue)
         {
            utfutil_u32ConvertISOMod2UTF8(
               szValue,
               u32UTFStringLength,
               coszInit,
               u32ISOStringLength
               );
         }
         else
         {
            bSuccess = false;
         }
#else
         // nothing to convert, just copy ISO-Mod string into member field
         tU32 u32ISOStringLength = OSAL_u32StringLength(coszInit) + 1;
         OSAL_DELETE[] szValue;
         szValue = OSAL_NEW tChar[u32ISOStringLength];
         if (szValue)
         {
            (void)OSAL_szStringCopy(szValue,coszInit);
         }
         else
         {
            bSuccess = false;
         }
#endif
      } break;
case FI_EN_ISO8859_1M :
      {
#ifdef FI_S_UTFMODE_TRANSPARENT
         // input is ISO-Mod, FI assumes UTF8 internally, thus convert input
         tU32 u32ISOStringLength = OSAL_u32StringLength(coszInit) + 1;
         tU32 u32UTFStringLength = util_u32ConvertISO8859_1Mod2UTF8(
            0,
            0,
            coszInit,
            u32ISOStringLength
         );
         OSAL_DELETE[] szValue;
         szValue = OSAL_NEW tChar[u32UTFStringLength];
         if (szValue)
         {
            util_u32ConvertISO8859_1Mod2UTF8(
               szValue,
               u32UTFStringLength,
               coszInit,
               u32ISOStringLength
               );
         }
         else
         {
            bSuccess = false;
         }
#else
         // nothing to convert, just copy ISO-Mod string into member field
         tU32 u32ISOStringLength = OSAL_u32StringLength(coszInit) + 1;
         OSAL_DELETE[] szValue;
         szValue = OSAL_NEW tChar[u32ISOStringLength];
         if (szValue)
         {
            (void)OSAL_szStringCopy(szValue,coszInit);
         }
         else
         {
            bSuccess = false;
         }
#endif
      } break;
   case FI_EN_UNDEFINED:
   default:
      bSuccess = false;
   }
   }
   else
   {
      OSAL_DELETE[] szValue;
      szValue = OSAL_NULL;
   }
   return bSuccess;
}

tString fi_tclString::szGet(tenCharSet enCharSet) const
{
   tString szRetVal = 0;
   if (OSAL_NULL != szValue)
   {
      switch (enCharSet)
      {
      case FI_EN_UTF8:
         {
#ifdef FI_S_UTFMODE_TRANSPARENT
            // nothing to convert, just copy internal member value
            tU32 u32UTFStringLength = OSAL_u32StringLength(szValue) + 1;
            szRetVal = OSAL_NEW tChar[u32UTFStringLength];
            if (szRetVal)
            {
               (void)OSAL_szStringCopy(szRetVal,szValue);
            }
#else
            // internal member is ISO-Mod, export as UTF8
            tU32 u32ISOStringLength = OSAL_u32StringLength(szValue) + 1;
            tU32 u32UTFStringLength = utfutil_u32ConvertISOMod2UTF8(
               0,
               0,
               szValue,
               u32ISOStringLength
               );
            szRetVal = OSAL_NEW tChar[u32UTFStringLength];
            if (szRetVal)
            {
               utfutil_u32ConvertISOMod2UTF8(
                  szRetVal,
                  u32UTFStringLength,
                  szValue,
                  u32ISOStringLength
                  );
            }
#endif
         } break;
      case FI_EN_ISO8859_15M:
         {
#ifdef FI_S_UTFMODE_TRANSPARENT
            // internal member is UTF8, export as ISO-Mod
            tU32 u32UTFStringLength = OSAL_u32StringLength(szValue) + 1;
            tU32 u32ISOStringLength = utfutil_u32ConvertUTF82ISOMod(
               0,
               0,
               szValue,
               u32UTFStringLength
               );
            szRetVal = OSAL_NEW tChar[u32ISOStringLength];
            if (szRetVal)
            {
               utfutil_u32ConvertUTF82ISOMod(
                  szRetVal,
                  u32ISOStringLength,
                  szValue,
                  u32UTFStringLength
                  );
            }
#else
            // nothing to convert, just copy internal member value
            tU32 u32ISOStringLength = OSAL_u32StringLength(szValue) + 1;
            szRetVal = OSAL_NEW tChar[u32ISOStringLength];
            if (szRetVal)
            {
               (void)OSAL_szStringCopy(szRetVal,szValue);
            }
#endif
         } break;
      case FI_EN_UNDEFINED:
      default:
         szRetVal = OSAL_NULL;
      }
   }
   return szRetVal;
}
#endif

fi_tclOutContext& fi_tclList::oWrite(fi_tclOutContext& oOut) const 
{
   // --Schreibe die Listenlaenge in den Kontext
   oOut.oWrite(u32ListSize);
   return oOut;
}

fi_tclInContext& fi_tclList::oRead(fi_tclInContext& oIn) 
{
  // --Lese die Listenlaenge aus dem Kontext
  oIn.oRead(u32ListSize);
  return oIn;
}

tBool fi_tclList::operator==(const fi_tclList& rfoCmp) const
{
   return rfoCmp.u32ListSize == u32ListSize;
}

tU32 fi_tclList::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 4;
}

fi_tclOutContext& fi_tclMultiLanguageString::oWrite(fi_tclOutContext& oOut) const 
{
  oOut.oWrite(szValue);
  return oOut;
}

tVoid fi_tclMultiLanguageString::vDestroy() 
{
  OSAL_DELETE[] szValue;
  szValue = OSAL_NULL;
}

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
fi_tclMultiLanguageString::~fi_tclMultiLanguageString() 
{
  OSAL_DELETE[] szValue;
  szValue = OSAL_NULL;
}

fi_tclMultiLanguageString& fi_tclMultiLanguageString::operator=(const fi_tclMultiLanguageString& coRef)
{
   if (this == &coRef) return *this;

   OSAL_DELETE[] szValue;
   if (coRef.szValue != OSAL_NULL)
   {
      tU32 u32UTFStringLength = OSAL_u32StringLength(coRef.szValue) + 1;
      szValue = OSAL_NEW tChar[u32UTFStringLength];
	  if (szValue != OSAL_NULL)
      {
         (void)OSAL_szStringCopy(szValue,coRef.szValue);
      }
   }
   else
   {
      szValue = OSAL_NULL;
   }
   return *this;
}

fi_tclMultiLanguageString::fi_tclMultiLanguageString(const fi_tclMultiLanguageString& coRef):fi_tclVisitableTypeBase(coRef)
{
   if (coRef.szValue != OSAL_NULL)
   {
      tU32 u32UTFStringLength = OSAL_u32StringLength(coRef.szValue) + 1;
      szValue = OSAL_NEW tChar[u32UTFStringLength];
      if (szValue != OSAL_NULL)
      {
         (void)OSAL_szStringCopy(szValue,coRef.szValue);
      }
   }
   else
   {
      szValue = OSAL_NULL;
   }
}
#endif

fi_tclInContext& fi_tclMultiLanguageString::oRead(fi_tclInContext& oIn) 
{
  oIn.oRead(szValue);
  return oIn;
}

tBool fi_tclMultiLanguageString::operator==(const fi_tclMultiLanguageString& rfoCmp) const
{
   if ((szValue == OSAL_NULL) || (rfoCmp.szValue == OSAL_NULL))
   {
      if (szValue == rfoCmp.szValue)
      {
         return TRUE;
      }
      else
      {
         if (szValue == OSAL_NULL)
         {
            return (OSAL_u32StringLength(rfoCmp.szValue) == 0);
         }
         else
         {
            return (OSAL_u32StringLength(szValue) == 0);
         }
      }
   }
   else
   {
      return (0 == strcmp(szValue,rfoCmp.szValue));
   }
}

tU32 fi_tclMultiLanguageString::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return FI_u32StringLength(szValue) + 1;
}

#ifndef FI_DO_NOT_USE_TSTRING
fi_tclMultiLanguageString& fi_tclMultiLanguageString::operator=(tCString coszString) // ADDED
{
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   if (coszString != OSAL_NULL)
   {
      // nothing to convert, just copy (UTF-8) string into member field
      tU32 u32UTFStringLength = OSAL_u32StringLength(coszString) + 1;
      OSAL_DELETE[] szValue;
      szValue = OSAL_NEW tChar[u32UTFStringLength];
      if (szValue)
      {
         (void)OSAL_szStringCopy(szValue,coszString);
      }
   }
   else
   {
      OSAL_DELETE[] szValue;
      szValue = OSAL_NULL;
   }
#else
   szValue = const_cast<tString>(coszString);
#endif
   return *this;
}

//fi_tclMultiLanguageString::fi_tclMultiLanguageString(const tString& coszString) // ADDED (changed from const tString to const tString&)
fi_tclMultiLanguageString::fi_tclMultiLanguageString(tCString coszString) // ADDED (changed from const tString& to tCString)
{
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   if (coszString != OSAL_NULL)
   {
      tU32 u32UTFStringLength = OSAL_u32StringLength(coszString) + 1;
      szValue = OSAL_NEW tChar[u32UTFStringLength];
      if (szValue)
      {
         (void)OSAL_szStringCopy(szValue,coszString);
      }
   }
   else
   {
      szValue = OSAL_NULL;
   }
#else
   szValue = const_cast<tString>(coszString);
#endif
}

tBool fi_tclMultiLanguageString::operator==(tCString coszString) const // ADDED
{
   if ((szValue == OSAL_NULL) || (coszString == OSAL_NULL))
   {
      if (szValue == coszString)
      {
         return TRUE;
      }
      else
      {
         if (szValue == OSAL_NULL)
         {
            return (OSAL_u32StringLength(coszString) == 0); //lint !e668 : same constellation as in other compare operator, which is ok for LINT
         }
         else
         {
            return (OSAL_u32StringLength(szValue) == 0);
         }
      }
   }
   else
   {
      return (0 == strcmp(szValue,coszString));
   }
}

fi_tclMultiLanguageString::operator tString&() // ADDED
{
   return szValue;
}

fi_tclMultiLanguageString::operator const tChar* () const // ADDED
{
   return szValue;
}

tBool fi_tclMultiLanguageString::operator!=(int iNULL) const// ADDED
{
   return szValue != (char*)iNULL;
}

tChar* fi_tclMultiLanguageString::operator+(int iOffset) // ADDED
{
   if (szValue)
      return szValue + iOffset;
   else
      return OSAL_NULL;
}

tChar* fi_tclMultiLanguageString::operator+(tU8  u8Offset) // ADDED
{
   if (szValue)
      return szValue + u8Offset;
   else
      return OSAL_NULL;
}

tChar* fi_tclMultiLanguageString::operator+(tU32 u32Offset) // ADDED
{
   if (szValue)
      return szValue + u32Offset;
   else
      return OSAL_NULL;
}

tChar& fi_tclMultiLanguageString::operator[](tU16 u16Index) //ADDED
{
   if (szValue)
      return szValue[u16Index];
   else
      return FI_C_U8_NULLCHAR;
}

tChar& fi_tclMultiLanguageString::operator[](tU32 u32Index) //ADDED
{
   if (szValue)
      return szValue[u32Index];
   else
      return FI_C_U8_NULLCHAR;
}

tChar& fi_tclMultiLanguageString::operator[](tS32 s32Index) //ADDED
{
   if (szValue)
      return szValue[s32Index];
   else
      return FI_C_U8_NULLCHAR;
}
#endif

#ifndef FI_S_NO_STRING_ACCESS_METHODS

tBool fi_tclMultiLanguageString::bSet(const fi_tclMultiLanguageString& corfoInit, tenCharSet enCharSet)
{
   return bSet(corfoInit.szValue, enCharSet);
}

//tBool figroup_fi_tclMultiLanguageString::bSet(const tString& coszInit, tenCharSet enCharSet)
tBool fi_tclMultiLanguageString::bSet(tCString coszInit, tenCharSet enCharSet)
{
   tBool bSuccess = true;
   if (coszInit != OSAL_NULL)
   {
   switch (enCharSet)
   {
   case FI_EN_UTF8:
      {
#ifdef FI_S_UTFMODE_TRANSPARENT
         // nothing to convert, just copy UTF-8 string into member field
         tU32 u32UTFStringLength = OSAL_u32StringLength(coszInit) + 1;
         OSAL_DELETE[] szValue;
         szValue = OSAL_NEW tChar[u32UTFStringLength];
         if (szValue)
         {
            (void)OSAL_szStringCopy(szValue,coszInit);
         }
         else
         {
            bSuccess = false;
         }
#else
         // input is UTF8, FI assumes ISO-Mod internally, thus convert input
         tU32 u32UTFStringLength = OSAL_u32StringLength(coszInit) + 1;
         tU32 u32ISOStringLength = utfutil_u32ConvertUTF82ISOMod(
            0,
            0,
            coszInit,
            u32UTFStringLength
         );
         OSAL_DELETE[] szValue;
         szValue = OSAL_NEW tChar[u32ISOStringLength];
         if (szValue)
         {
            utfutil_u32ConvertUTF82ISOMod(
               szValue,
               u32ISOStringLength,
               coszInit,
               u32UTFStringLength
               );
         }
         else
         {
            bSuccess = false;
         }
#endif
      } break;
   case FI_EN_ISO8859_15M:
      {
#ifdef FI_S_UTFMODE_TRANSPARENT
         // input is ISO-Mod, FI assumes UTF8 internally, thus convert input
         tU32 u32ISOStringLength = OSAL_u32StringLength(coszInit) + 1;
         tU32 u32UTFStringLength = utfutil_u32ConvertISOMod2UTF8(
            0,
            0,
            coszInit,
            u32ISOStringLength
         );
         OSAL_DELETE[] szValue;
         szValue = OSAL_NEW tChar[u32UTFStringLength];
         if (szValue)
         {
            utfutil_u32ConvertISOMod2UTF8(
               szValue,
               u32UTFStringLength,
               coszInit,
               u32ISOStringLength
               );
         }
         else
         {
            bSuccess = false;
         }
#else
         // nothing to convert, just copy ISO-Mod string into member field
         tU32 u32ISOStringLength = OSAL_u32StringLength(coszInit) + 1;
         OSAL_DELETE[] szValue;
         szValue = OSAL_NEW tChar[u32ISOStringLength];
         if (szValue)
         {
            (void)OSAL_szStringCopy(szValue,coszInit);
         }
         else
         {
            bSuccess = false;
         }
#endif
      } break;
   case FI_EN_UNDEFINED:
   default:
      bSuccess = false;
   }
   }
   else
   {
      OSAL_DELETE[] szValue;
      szValue = OSAL_NULL;
   }

   return bSuccess;
}

tString fi_tclMultiLanguageString::szGet(tenCharSet enCharSet) const
{
   tString szRetVal = 0;
   if (OSAL_NULL != szValue)
   {
      switch (enCharSet)
      {
      case FI_EN_UTF8:
         {
#ifdef FI_S_UTFMODE_TRANSPARENT
            // nothing to convert, just copy internal member value
            tU32 u32UTFStringLength = OSAL_u32StringLength(szValue) + 1;
            szRetVal = OSAL_NEW tChar[u32UTFStringLength];
            if (szRetVal)
            {
               (void)OSAL_szStringCopy(szRetVal,szValue);
            }
#else
            // internal member is ISO-Mod, export as UTF8
            tU32 u32ISOStringLength = OSAL_u32StringLength(szValue) + 1;
            tU32 u32UTFStringLength = utfutil_u32ConvertISOMod2UTF8(
               0,
               0,
               szValue,
               u32ISOStringLength
               );
            szRetVal = OSAL_NEW tChar[u32UTFStringLength];
            if (szRetVal)
            {
               utfutil_u32ConvertISOMod2UTF8(
                  szRetVal,
                  u32UTFStringLength,
                  szValue,
                  u32ISOStringLength
                  );
            }
#endif
         } break;
      case FI_EN_ISO8859_15M:
         {
#ifdef FI_S_UTFMODE_TRANSPARENT
            // internal member is UTF8, export as ISO-Mod
            tU32 u32UTFStringLength = OSAL_u32StringLength(szValue) + 1;
            tU32 u32ISOStringLength = utfutil_u32ConvertUTF82ISOMod(
               0,
               0,
               szValue,
               u32UTFStringLength
               );
            szRetVal = OSAL_NEW tChar[u32ISOStringLength];
            if (szRetVal)
            {
               utfutil_u32ConvertUTF82ISOMod(
                  szRetVal,
                  u32ISOStringLength,
                  szValue,
                  u32UTFStringLength
                  );
            }
#else
            // nothing to convert, just copy internal member value
            tU32 u32ISOStringLength = OSAL_u32StringLength(szValue) + 1;
            szRetVal = OSAL_NEW tChar[u32ISOStringLength];
            if (szRetVal)
            {
               (void)OSAL_szStringCopy(szRetVal,szValue);
            }
#endif
         } break;
      case FI_EN_UNDEFINED:
      default:
         szRetVal = OSAL_NULL;
      }
   }
   return szRetVal;
}
#endif

tU32 fi_tcl_e8_Status::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 1;
}

tBool fi_tcl_e8_Status::operator==(const fi_tcl_e8_Status& rfoCmp) const
{
   return enType == rfoCmp.enType;
}

fi_tclInContext& fi_tcl_e8_Status::oRead(fi_tclInContext& oIn)
{
   tU8 u8Value;
   oIn >> u8Value;
   enType = (tenType)u8Value;
   return oIn;
}

fi_tclOutContext& fi_tcl_e8_Status::oWrite(fi_tclOutContext& oOut) const
{
   return oOut.oWrite((tU8)enType);
}

tU32 fi_tcl_e8_TypeOfFile::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 1;
}

tBool fi_tcl_e8_TypeOfFile::operator==(const fi_tcl_e8_TypeOfFile& rfoCmp) const
{
   return enType == rfoCmp.enType;
}

fi_tclInContext& fi_tcl_e8_TypeOfFile::oRead(fi_tclInContext& oIn)
{
   tU8 u8Value;
   oIn >> u8Value;
   enType = (tenType)u8Value;
   return oIn;
}

fi_tclOutContext& fi_tcl_e8_TypeOfFile::oWrite(fi_tclOutContext& oOut) const
{
   return oOut.oWrite((tU8)enType);
}

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
fi_tcl_FileContents::fi_tcl_FileContents(const fi_tcl_FileContents& coRef):fi_tclVisitableTypeBase(coRef)
{
   FileTypeType = coRef.FileTypeType;
   if  (coRef.poFileTypeData)
   {
      switch(FileTypeType.enType)
      {
      case fi_tcl_e8_TypeOfFile::FI_EN_T_RESERVED:
         poFileTypeData = OSAL_NEW fi_tcl_Reserved((const fi_tcl_Reserved&)*coRef.poFileTypeData);
         break;
      case fi_tcl_e8_TypeOfFile::FI_EN_T_DIRECTORY:
         poFileTypeData = OSAL_NEW fi_tcl_Directory((const fi_tcl_Directory&)*coRef.poFileTypeData);
         break;
      case fi_tcl_e8_TypeOfFile::FI_EN_T_UTSTRING:
         poFileTypeData = OSAL_NEW fi_tcl_UTString((const fi_tcl_UTString&)*coRef.poFileTypeData);
         break;
      case fi_tcl_e8_TypeOfFile::FI_EN_T_UTINT:
         poFileTypeData = OSAL_NEW fi_tcl_UTInt((const fi_tcl_UTInt&)*coRef.poFileTypeData);
         break;
      case fi_tcl_e8_TypeOfFile::FI_EN_T_UTUINT:
         poFileTypeData = OSAL_NEW fi_tcl_UTUInt((const fi_tcl_UTUInt&)*coRef.poFileTypeData);
         break;
      case fi_tcl_e8_TypeOfFile::FI_EN_T_UTLISTMODEL:
         poFileTypeData = OSAL_NEW fi_tcl_UTListModel((const fi_tcl_UTListModel&)*coRef.poFileTypeData);
         break;
      case fi_tcl_e8_TypeOfFile::FI_EN_T_UTLISTSELECTIONMODEL:
         poFileTypeData = OSAL_NEW fi_tcl_UTListSelectionModel((const fi_tcl_UTListSelectionModel&)*coRef.poFileTypeData);
         break;
      case fi_tcl_e8_TypeOfFile::FI_EN_T_UTMESSAGE:
         poFileTypeData = OSAL_NEW fi_tcl_UTMessage((const fi_tcl_UTMessage&)*coRef.poFileTypeData);
         break;
      case fi_tcl_e8_TypeOfFile::FI_EN_T_UTCCAMESSAGE:
         poFileTypeData = OSAL_NEW fi_tcl_UTCCAMessage((const fi_tcl_UTCCAMessage&)*coRef.poFileTypeData);
         break;
      case fi_tcl_e8_TypeOfFile::FI_EN_T_UTACTION:
         poFileTypeData = OSAL_NEW fi_tcl_UTAction((const fi_tcl_UTAction&)*coRef.poFileTypeData);
         break;
      case fi_tcl_e8_TypeOfFile::FI_EN_T_UTBOOL:
         poFileTypeData = OSAL_NEW fi_tcl_UTBool((const fi_tcl_UTBool&)*coRef.poFileTypeData);
         break;
      default:
         poFileTypeData = OSAL_NULL;
      }
   }
   else
   {
      poFileTypeData = OSAL_NULL;
   }
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
fi_tcl_FileContents& fi_tcl_FileContents::operator=(const fi_tcl_FileContents& coRef)
{
   if (this == &coRef) return *this;
   OSAL_DELETE poFileTypeData;
   FileTypeType = coRef.FileTypeType;
   if  (coRef.poFileTypeData)
   {
      switch(FileTypeType.enType)
      {
      case fi_tcl_e8_TypeOfFile::FI_EN_T_RESERVED:
         poFileTypeData = OSAL_NEW fi_tcl_Reserved((const fi_tcl_Reserved&)*coRef.poFileTypeData);
         break;
      case fi_tcl_e8_TypeOfFile::FI_EN_T_DIRECTORY:
         poFileTypeData = OSAL_NEW fi_tcl_Directory((const fi_tcl_Directory&)*coRef.poFileTypeData);
         break;
      case fi_tcl_e8_TypeOfFile::FI_EN_T_UTSTRING:
         poFileTypeData = OSAL_NEW fi_tcl_UTString((const fi_tcl_UTString&)*coRef.poFileTypeData);
         break;
      case fi_tcl_e8_TypeOfFile::FI_EN_T_UTINT:
         poFileTypeData = OSAL_NEW fi_tcl_UTInt((const fi_tcl_UTInt&)*coRef.poFileTypeData);
         break;
      case fi_tcl_e8_TypeOfFile::FI_EN_T_UTUINT:
         poFileTypeData = OSAL_NEW fi_tcl_UTUInt((const fi_tcl_UTUInt&)*coRef.poFileTypeData);
         break;
      case fi_tcl_e8_TypeOfFile::FI_EN_T_UTLISTMODEL:
         poFileTypeData = OSAL_NEW fi_tcl_UTListModel((const fi_tcl_UTListModel&)*coRef.poFileTypeData);
         break;
      case fi_tcl_e8_TypeOfFile::FI_EN_T_UTLISTSELECTIONMODEL:
         poFileTypeData = OSAL_NEW fi_tcl_UTListSelectionModel((const fi_tcl_UTListSelectionModel&)*coRef.poFileTypeData);
         break;
      case fi_tcl_e8_TypeOfFile::FI_EN_T_UTMESSAGE:
         poFileTypeData = OSAL_NEW fi_tcl_UTMessage((const fi_tcl_UTMessage&)*coRef.poFileTypeData);
         break;
      case fi_tcl_e8_TypeOfFile::FI_EN_T_UTCCAMESSAGE:
         poFileTypeData = OSAL_NEW fi_tcl_UTCCAMessage((const fi_tcl_UTCCAMessage&)*coRef.poFileTypeData);
         break;
      case fi_tcl_e8_TypeOfFile::FI_EN_T_UTACTION:
         poFileTypeData = OSAL_NEW fi_tcl_UTAction((const fi_tcl_UTAction&)*coRef.poFileTypeData);
         break;
      case fi_tcl_e8_TypeOfFile::FI_EN_T_UTBOOL:
         poFileTypeData = OSAL_NEW fi_tcl_UTBool((const fi_tcl_UTBool&)*coRef.poFileTypeData);
         break;
      default:
         poFileTypeData = OSAL_NULL;
      }
   }
   else
   {
      poFileTypeData = OSAL_NULL;
   }
   return *this;
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
fi_tcl_FileContents::~fi_tcl_FileContents()
{
   OSAL_DELETE poFileTypeData;
   poFileTypeData = OSAL_NULL;
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
tVoid fi_tcl_FileContents::vDestroy()
{
   if (poFileTypeData)
   {
      poFileTypeData->vDestroy();
      OSAL_DELETE poFileTypeData;
      poFileTypeData = OSAL_NULL;
   }
}

tU32 fi_tcl_FileContents::u32GetSize(tU16 u16MajorVersion) const
{
   return 1+(poFileTypeData?poFileTypeData->u32GetSize(u16MajorVersion):0);
}

tBool fi_tcl_FileContents::operator==(const fi_tcl_FileContents& rfoCmp) const
{
   tBool bResult = true;
   bResult = bResult && (FileTypeType == rfoCmp.FileTypeType);
   if (bResult && poFileTypeData && rfoCmp.poFileTypeData) 
   {
      switch (FileTypeType.enType)
      {
      case fi_tcl_e8_TypeOfFile::FI_EN_T_RESERVED:
         bResult = bResult && (*(const fi_tcl_Reserved*)poFileTypeData == *(const fi_tcl_Reserved*)rfoCmp.poFileTypeData); //lint !e826
      break;
      case fi_tcl_e8_TypeOfFile::FI_EN_T_DIRECTORY:
         bResult = bResult && (*(const fi_tcl_Directory*)poFileTypeData == *(const fi_tcl_Directory*)rfoCmp.poFileTypeData); //lint !e826
      break;
      case fi_tcl_e8_TypeOfFile::FI_EN_T_UTSTRING:
         bResult = bResult && (*(const fi_tcl_UTString*)poFileTypeData == *(const fi_tcl_UTString*)rfoCmp.poFileTypeData); //lint !e826
      break;
      case fi_tcl_e8_TypeOfFile::FI_EN_T_UTINT:
         bResult = bResult && (*(const fi_tcl_UTInt*)poFileTypeData == *(const fi_tcl_UTInt*)rfoCmp.poFileTypeData); //lint !e826
      break;
      case fi_tcl_e8_TypeOfFile::FI_EN_T_UTUINT:
         bResult = bResult && (*(const fi_tcl_UTUInt*)poFileTypeData == *(const fi_tcl_UTUInt*)rfoCmp.poFileTypeData); //lint !e826
      break;
      case fi_tcl_e8_TypeOfFile::FI_EN_T_UTLISTMODEL:
         bResult = bResult && (*(const fi_tcl_UTListModel*)poFileTypeData == *(const fi_tcl_UTListModel*)rfoCmp.poFileTypeData); //lint !e826
      break;
      case fi_tcl_e8_TypeOfFile::FI_EN_T_UTLISTSELECTIONMODEL:
         bResult = bResult && (*(const fi_tcl_UTListSelectionModel*)poFileTypeData == *(const fi_tcl_UTListSelectionModel*)rfoCmp.poFileTypeData); //lint !e826
      break;
      case fi_tcl_e8_TypeOfFile::FI_EN_T_UTMESSAGE:
         bResult = bResult && (*(const fi_tcl_UTMessage*)poFileTypeData == *(const fi_tcl_UTMessage*)rfoCmp.poFileTypeData); //lint !e826
      break;
      case fi_tcl_e8_TypeOfFile::FI_EN_T_UTCCAMESSAGE:
         bResult = bResult && (*(const fi_tcl_UTCCAMessage*)poFileTypeData == *(const fi_tcl_UTCCAMessage*)rfoCmp.poFileTypeData); //lint !e826
      break;
      case fi_tcl_e8_TypeOfFile::FI_EN_T_UTACTION:
         bResult = bResult && (*(const fi_tcl_UTAction*)poFileTypeData == *(const fi_tcl_UTAction*)rfoCmp.poFileTypeData); //lint !e826
      break;
      case fi_tcl_e8_TypeOfFile::FI_EN_T_UTBOOL:
         bResult = bResult && (*(const fi_tcl_UTBool*)poFileTypeData == *(const fi_tcl_UTBool*)rfoCmp.poFileTypeData); //lint !e826
      break;
      }
   }
   else
   {
      bResult = bResult && (poFileTypeData == rfoCmp.poFileTypeData);
   }
   return bResult;
}

fi_tclInContext& fi_tcl_FileContents::oRead(fi_tclInContext& oIn)
{
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   OSAL_DELETE poFileTypeData;
#else
   if (poFileTypeData)
   {
      poFileTypeData->vDestroy();
      OSAL_DELETE poFileTypeData;
   }
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
   oIn >> FileTypeType;
   switch(FileTypeType.enType)
   {
   case fi_tcl_e8_TypeOfFile::FI_EN_T_RESERVED:
      poFileTypeData = OSAL_NEW fi_tcl_Reserved;
      break;
   case fi_tcl_e8_TypeOfFile::FI_EN_T_DIRECTORY:
      poFileTypeData = OSAL_NEW fi_tcl_Directory;
      break;
   case fi_tcl_e8_TypeOfFile::FI_EN_T_UTSTRING:
      poFileTypeData = OSAL_NEW fi_tcl_UTString;
      break;
   case fi_tcl_e8_TypeOfFile::FI_EN_T_UTINT:
      poFileTypeData = OSAL_NEW fi_tcl_UTInt;
      break;
   case fi_tcl_e8_TypeOfFile::FI_EN_T_UTUINT:
      poFileTypeData = OSAL_NEW fi_tcl_UTUInt;
      break;
   case fi_tcl_e8_TypeOfFile::FI_EN_T_UTLISTMODEL:
      poFileTypeData = OSAL_NEW fi_tcl_UTListModel;
      break;
   case fi_tcl_e8_TypeOfFile::FI_EN_T_UTLISTSELECTIONMODEL:
      poFileTypeData = OSAL_NEW fi_tcl_UTListSelectionModel;
      break;
   case fi_tcl_e8_TypeOfFile::FI_EN_T_UTMESSAGE:
      poFileTypeData = OSAL_NEW fi_tcl_UTMessage;
      break;
   case fi_tcl_e8_TypeOfFile::FI_EN_T_UTCCAMESSAGE:
      poFileTypeData = OSAL_NEW fi_tcl_UTCCAMessage;
      break;
   case fi_tcl_e8_TypeOfFile::FI_EN_T_UTACTION:
      poFileTypeData = OSAL_NEW fi_tcl_UTAction;
      break;
   case fi_tcl_e8_TypeOfFile::FI_EN_T_UTBOOL:
      poFileTypeData = OSAL_NEW fi_tcl_UTBool;
      break;
   default:
      oIn.Invalidate();
      poFileTypeData = OSAL_NULL;
   }
   if (poFileTypeData && oIn.bIsValid())
      poFileTypeData->oRead(oIn);
   else
      oIn.Invalidate();
   return oIn;
}

fi_tclOutContext& fi_tcl_FileContents::oWrite(fi_tclOutContext& oOut) const
{
   oOut << FileTypeType;
   if (poFileTypeData)
   {
      poFileTypeData->oWrite(oOut);
   }
   else
   {
      oOut.Invalidate();
   }
   return oOut;
}

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
fi_tcl_Directory::fi_tcl_Directory(const fi_tcl_Directory& coRef):fi_tclVisitableTypeBase(coRef)
{
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
fi_tcl_Directory& fi_tcl_Directory::operator=(const fi_tcl_Directory& coRef)
{
   if (this == &coRef) return *this;
   return *this;
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
tU32 fi_tcl_Directory::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 0;
}

tBool fi_tcl_Directory::operator==(const fi_tcl_Directory& /* rfoCmp */) const
{
   tBool bResult = true;
   return bResult;
}

fi_tclInContext& fi_tcl_Directory::oRead(fi_tclInContext& oIn)
{
   return oIn;
}

fi_tclOutContext& fi_tcl_Directory::oWrite(fi_tclOutContext& oOut) const
{
   return oOut;
}

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
fi_tcl_UTUInt::fi_tcl_UTUInt(const fi_tcl_UTUInt& coRef):fi_tclVisitableTypeBase(coRef)
{
   UTUIntValue = coRef.UTUIntValue;
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
fi_tcl_UTUInt& fi_tcl_UTUInt::operator=(const fi_tcl_UTUInt& coRef)
{
   if (this == &coRef) return *this;
   UTUIntValue = coRef.UTUIntValue;
   return *this;
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
tU32 fi_tcl_UTUInt::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 4;
}

tBool fi_tcl_UTUInt::operator==(const fi_tcl_UTUInt& rfoCmp) const
{
   tBool bResult = true;
      bResult = bResult && (UTUIntValue == rfoCmp.UTUIntValue);
   return bResult;
}

fi_tclInContext& fi_tcl_UTUInt::oRead(fi_tclInContext& oIn)
{
   oIn >> UTUIntValue;
   return oIn;
}

fi_tclOutContext& fi_tcl_UTUInt::oWrite(fi_tclOutContext& oOut) const
{
   oOut << UTUIntValue;
   return oOut;
}

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
fi_tcl_UTListModel::fi_tcl_UTListModel(const fi_tcl_UTListModel& coRef):fi_tclVisitableTypeBase(coRef)
{
   ListRowCount = coRef.ListRowCount;
   UTListValue = coRef.UTListValue;
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
fi_tcl_UTListModel& fi_tcl_UTListModel::operator=(const fi_tcl_UTListModel& coRef)
{
   if (this == &coRef) return *this;
   ListRowCount = coRef.ListRowCount;
   UTListValue = coRef.UTListValue;
   return *this;
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
tVoid fi_tcl_UTListModel::vDestroy()
{
   {
      for (tU32 u32Idx = 0; u32Idx < UTListValue.size(); ++u32Idx)
         UTListValue[u32Idx].vDestroy();
   }
   UTListValue.clear();
}

tU32 fi_tcl_UTListModel::u32GetSize(tU16 u16MajorVersion) const
{
   tU32 u32DynamicSize = 0;
   if (3 <= u16MajorVersion)
   {
      u32DynamicSize += 4;
   }
   tU32 u32ListIdx;
   for (u32ListIdx = 0; u32ListIdx < UTListValue.size(); ++u32ListIdx)
      u32DynamicSize += UTListValue[u32ListIdx].u32GetSize(u16MajorVersion);
   return u32DynamicSize+4;
}

tBool fi_tcl_UTListModel::operator==(const fi_tcl_UTListModel& rfoCmp) const
{
   tBool bResult = true;
      bResult = bResult && (ListRowCount == rfoCmp.ListRowCount);
      bResult = bResult && (UTListValue.size() == rfoCmp.UTListValue.size());
      if (bResult)
      {
         for (tU32 u32Idx = 0; bResult && (u32Idx < UTListValue.size()); ++u32Idx)
            bResult = bResult && (UTListValue[u32Idx] == rfoCmp.UTListValue[u32Idx]);
      }
   return bResult;
}

fi_tclInContext& fi_tcl_UTListModel::oRead(fi_tclInContext& oIn)
{
   if (3 <= oIn.u16GetMajorVersion())
   {
      oIn >> ListRowCount;
   }
   {
      tU32 u32Length;
      tU32 u32Idx;
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
      for (u32Idx = 0; u32Idx < UTListValue.size(); ++u32Idx)
      {
         UTListValue[u32Idx].vDestroy();
      }
#endif // !VARIANT_S_FTR_ENABLE_DEEP_COPY
      oIn >> u32Length;
      UTListValue.resize(u32Length);
      for (u32Idx = 0; u32Idx < u32Length; ++u32Idx)
      {
         oIn >> UTListValue[u32Idx];
      }
   }
   return oIn;
}

fi_tclOutContext& fi_tcl_UTListModel::oWrite(fi_tclOutContext& oOut) const
{
   if (3 <= oOut.u16GetMajorVersion())
   {
      oOut << ListRowCount;
   }
   oOut << (tU32)UTListValue.size();
   {
      for (tU32 u32Idx = 0; u32Idx < UTListValue.size(); ++u32Idx)
         oOut << UTListValue[u32Idx];
   }
   return oOut;
}

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
fi_tcl_UTListSelectionModel::fi_tcl_UTListSelectionModel(const fi_tcl_UTListSelectionModel& coRef):fi_tclVisitableTypeBase(coRef)
{
   ListSelRowCount = coRef.ListSelRowCount;
   UTListSelectionValue = coRef.UTListSelectionValue;
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
fi_tcl_UTListSelectionModel& fi_tcl_UTListSelectionModel::operator=(const fi_tcl_UTListSelectionModel& coRef)
{
   if (this == &coRef) return *this;
   ListSelRowCount = coRef.ListSelRowCount;
   UTListSelectionValue = coRef.UTListSelectionValue;
   return *this;
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
tVoid fi_tcl_UTListSelectionModel::vDestroy()
{
   {
      for (tU32 u32Idx = 0; u32Idx < UTListSelectionValue.size(); ++u32Idx)
         UTListSelectionValue[u32Idx].vDestroy();
   }
   UTListSelectionValue.clear();
}

tU32 fi_tcl_UTListSelectionModel::u32GetSize(tU16 u16MajorVersion) const
{
   tU32 u32DynamicSize = 0;
   if (3 <= u16MajorVersion)
   {
      u32DynamicSize += 4;
   }
   tU32 u32ListIdx;
   for (u32ListIdx = 0; u32ListIdx < UTListSelectionValue.size(); ++u32ListIdx)
      u32DynamicSize += UTListSelectionValue[u32ListIdx].u32GetSize(u16MajorVersion);
   return u32DynamicSize+4;
}

tBool fi_tcl_UTListSelectionModel::operator==(const fi_tcl_UTListSelectionModel& rfoCmp) const
{
   tBool bResult = true;
      bResult = bResult && (ListSelRowCount == rfoCmp.ListSelRowCount);
      bResult = bResult && (UTListSelectionValue.size() == rfoCmp.UTListSelectionValue.size());
      if (bResult)
      {
         for (tU32 u32Idx = 0; bResult && (u32Idx < UTListSelectionValue.size()); ++u32Idx)
            bResult = bResult && (UTListSelectionValue[u32Idx] == rfoCmp.UTListSelectionValue[u32Idx]);
      }
   return bResult;
}

fi_tclInContext& fi_tcl_UTListSelectionModel::oRead(fi_tclInContext& oIn)
{
   if (3 <= oIn.u16GetMajorVersion())
   {
      oIn >> ListSelRowCount;
   }
   {
      tU32 u32Length;
      tU32 u32Idx;
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
      for (u32Idx = 0; u32Idx < UTListSelectionValue.size(); ++u32Idx)
      {
         UTListSelectionValue[u32Idx].vDestroy();
      }
#endif // !VARIANT_S_FTR_ENABLE_DEEP_COPY
      oIn >> u32Length;
      UTListSelectionValue.resize(u32Length);
      for (u32Idx = 0; u32Idx < u32Length; ++u32Idx)
      {
         oIn >> UTListSelectionValue[u32Idx];
      }
   }
   return oIn;
}

fi_tclOutContext& fi_tcl_UTListSelectionModel::oWrite(fi_tclOutContext& oOut) const
{
   if (3 <= oOut.u16GetMajorVersion())
   {
      oOut << ListSelRowCount;
   }
   oOut << (tU32)UTListSelectionValue.size();
   {
      for (tU32 u32Idx = 0; u32Idx < UTListSelectionValue.size(); ++u32Idx)
         oOut << UTListSelectionValue[u32Idx];
   }
   return oOut;
}

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
fi_tcl_UTMessage::fi_tcl_UTMessage(const fi_tcl_UTMessage& coRef):fi_tclVisitableTypeBase(coRef)
{
   NotDefined = coRef.NotDefined;
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
fi_tcl_UTMessage& fi_tcl_UTMessage::operator=(const fi_tcl_UTMessage& coRef)
{
   if (this == &coRef) return *this;
   NotDefined = coRef.NotDefined;
   return *this;
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
tU32 fi_tcl_UTMessage::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 4;
}

tBool fi_tcl_UTMessage::operator==(const fi_tcl_UTMessage& rfoCmp) const
{
   tBool bResult = true;
      bResult = bResult && (NotDefined == rfoCmp.NotDefined);
   return bResult;
}

fi_tclInContext& fi_tcl_UTMessage::oRead(fi_tclInContext& oIn)
{
   oIn >> NotDefined;
   return oIn;
}

fi_tclOutContext& fi_tcl_UTMessage::oWrite(fi_tclOutContext& oOut) const
{
   oOut << NotDefined;
   return oOut;
}

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
fi_tcl_UTCCAMessage::fi_tcl_UTCCAMessage(const fi_tcl_UTCCAMessage& coRef):fi_tclVisitableTypeBase(coRef)
{
   ToBeDefined = coRef.ToBeDefined;
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
fi_tcl_UTCCAMessage& fi_tcl_UTCCAMessage::operator=(const fi_tcl_UTCCAMessage& coRef)
{
   if (this == &coRef) return *this;
   ToBeDefined = coRef.ToBeDefined;
   return *this;
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
tU32 fi_tcl_UTCCAMessage::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 4;
}

tBool fi_tcl_UTCCAMessage::operator==(const fi_tcl_UTCCAMessage& rfoCmp) const
{
   tBool bResult = true;
      bResult = bResult && (ToBeDefined == rfoCmp.ToBeDefined);
   return bResult;
}

fi_tclInContext& fi_tcl_UTCCAMessage::oRead(fi_tclInContext& oIn)
{
   oIn >> ToBeDefined;
   return oIn;
}

fi_tclOutContext& fi_tcl_UTCCAMessage::oWrite(fi_tclOutContext& oOut) const
{
   oOut << ToBeDefined;
   return oOut;
}

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
fi_tcl_UTAction::fi_tcl_UTAction(const fi_tcl_UTAction& coRef):fi_tclVisitableTypeBase(coRef)
{
   UTActionParameters = coRef.UTActionParameters;
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
fi_tcl_UTAction& fi_tcl_UTAction::operator=(const fi_tcl_UTAction& coRef)
{
   if (this == &coRef) return *this;
   UTActionParameters = coRef.UTActionParameters;
   return *this;
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
tVoid fi_tcl_UTAction::vDestroy()
{
   {
      for (tU32 u32Idx = 0; u32Idx < UTActionParameters.size(); ++u32Idx)
         UTActionParameters[u32Idx].vDestroy();
   }
   UTActionParameters.clear();
}

tU32 fi_tcl_UTAction::u32GetSize(tU16 u16MajorVersion) const
{
   tU32 u32DynamicSize = 0;
   tU32 u32ListIdx;
   for (u32ListIdx = 0; u32ListIdx < UTActionParameters.size(); ++u32ListIdx)
      u32DynamicSize += UTActionParameters[u32ListIdx].u32GetSize(u16MajorVersion);
   return u32DynamicSize+4;
}

tBool fi_tcl_UTAction::operator==(const fi_tcl_UTAction& rfoCmp) const
{
   tBool bResult = true;
      bResult = bResult && (UTActionParameters.size() == rfoCmp.UTActionParameters.size());
      if (bResult)
      {
         for (tU32 u32Idx = 0; bResult && (u32Idx < UTActionParameters.size()); ++u32Idx)
            bResult = bResult && (UTActionParameters[u32Idx] == rfoCmp.UTActionParameters[u32Idx]);
      }
   return bResult;
}

fi_tclInContext& fi_tcl_UTAction::oRead(fi_tclInContext& oIn)
{
   {
      tU32 u32Length;
      tU32 u32Idx;
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
      for (u32Idx = 0; u32Idx < UTActionParameters.size(); ++u32Idx)
      {
         UTActionParameters[u32Idx].vDestroy();
      }
#endif // !VARIANT_S_FTR_ENABLE_DEEP_COPY
      oIn >> u32Length;
      UTActionParameters.resize(u32Length);
      for (u32Idx = 0; u32Idx < u32Length; ++u32Idx)
      {
         oIn >> UTActionParameters[u32Idx];
      }
   }
   return oIn;
}

fi_tclOutContext& fi_tcl_UTAction::oWrite(fi_tclOutContext& oOut) const
{
   oOut << (tU32)UTActionParameters.size();
   {
      for (tU32 u32Idx = 0; u32Idx < UTActionParameters.size(); ++u32Idx)
         oOut << UTActionParameters[u32Idx];
   }
   return oOut;
}

tU32 fi_tcl_e8_DevNotification::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 1;
}

tBool fi_tcl_e8_DevNotification::operator==(const fi_tcl_e8_DevNotification& rfoCmp) const
{
   return enType == rfoCmp.enType;
}

fi_tclInContext& fi_tcl_e8_DevNotification::oRead(fi_tclInContext& oIn)
{
   tU8 u8Value;
   oIn >> u8Value;
   enType = (tenType)u8Value;
   return oIn;
}

fi_tclOutContext& fi_tcl_e8_DevNotification::oWrite(fi_tclOutContext& oOut) const
{
   return oOut.oWrite((tU8)enType);
}

tU32 fi_tcl_e8_DapMemType::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 1;
}

tBool fi_tcl_e8_DapMemType::operator==(const fi_tcl_e8_DapMemType& rfoCmp) const
{
   return enType == rfoCmp.enType;
}

fi_tclInContext& fi_tcl_e8_DapMemType::oRead(fi_tclInContext& oIn)
{
   tU8 u8Value;
   oIn >> u8Value;
   enType = (tenType)u8Value;
   return oIn;
}

fi_tclOutContext& fi_tcl_e8_DapMemType::oWrite(fi_tclOutContext& oOut) const
{
   return oOut.oWrite((tU8)enType);
}

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
fi_tcl_MemBlockDesc::fi_tcl_MemBlockDesc(const fi_tcl_MemBlockDesc& coRef):fi_tclVisitableTypeBase(coRef)
{
   u32Size = coRef.u32Size;
   pvMemAccess = coRef.pvMemAccess;
   hSharedMemHandle = coRef.hSharedMemHandle;
   bIsCopy = coRef.bIsCopy;
   enMemType = coRef.enMemType;
   szSharedMemName = coRef.szSharedMemName;
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
fi_tcl_MemBlockDesc& fi_tcl_MemBlockDesc::operator=(const fi_tcl_MemBlockDesc& coRef)
{
   if (this == &coRef) return *this;
   u32Size = coRef.u32Size;
   pvMemAccess = coRef.pvMemAccess;
   hSharedMemHandle = coRef.hSharedMemHandle;
   bIsCopy = coRef.bIsCopy;
   enMemType = coRef.enMemType;
   szSharedMemName = coRef.szSharedMemName;
   return *this;
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
tVoid fi_tcl_MemBlockDesc::vDestroy()
{
   szSharedMemName.vDestroy();
}

tU32 fi_tcl_MemBlockDesc::u32GetSize(tU16 u16MajorVersion) const
{
   return 14+szSharedMemName.u32GetSize(u16MajorVersion);
}

tBool fi_tcl_MemBlockDesc::operator==(const fi_tcl_MemBlockDesc& rfoCmp) const
{
   tBool bResult = true;
      bResult = bResult && (u32Size == rfoCmp.u32Size);
      bResult = bResult && (pvMemAccess == rfoCmp.pvMemAccess);
      bResult = bResult && (hSharedMemHandle == rfoCmp.hSharedMemHandle);
      bResult = bResult && (bIsCopy == rfoCmp.bIsCopy);
      bResult = bResult && (enMemType == rfoCmp.enMemType);
      bResult = bResult && (szSharedMemName == rfoCmp.szSharedMemName);
   return bResult;
}

fi_tclInContext& fi_tcl_MemBlockDesc::oRead(fi_tclInContext& oIn)
{
   oIn >> u32Size;
   oIn >> pvMemAccess;
   oIn >> hSharedMemHandle;
   oIn >> bIsCopy;
   oIn >> enMemType;
   oIn >> szSharedMemName;
   return oIn;
}

fi_tclOutContext& fi_tcl_MemBlockDesc::oWrite(fi_tclOutContext& oOut) const
{
   oOut << u32Size;
   oOut << pvMemAccess;
   oOut << hSharedMemHandle;
   oOut << bIsCopy;
   oOut << enMemType;
   oOut << szSharedMemName;
   return oOut;
}

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
fi_tcl_PathFilename::fi_tcl_PathFilename(const fi_tcl_PathFilename& coRef):fi_tclVisitableTypeBase(coRef)
{
   szFile = coRef.szFile;
   szPath = coRef.szPath;
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
fi_tcl_PathFilename& fi_tcl_PathFilename::operator=(const fi_tcl_PathFilename& coRef)
{
   if (this == &coRef) return *this;
   szFile = coRef.szFile;
   szPath = coRef.szPath;
   return *this;
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
tVoid fi_tcl_PathFilename::vDestroy()
{
   szFile.vDestroy();
   szPath.vDestroy();
}

tU32 fi_tcl_PathFilename::u32GetSize(tU16 u16MajorVersion) const
{
   return 0+szFile.u32GetSize(u16MajorVersion)+szPath.u32GetSize(u16MajorVersion);
}

tBool fi_tcl_PathFilename::operator==(const fi_tcl_PathFilename& rfoCmp) const
{
   tBool bResult = true;
      bResult = bResult && (szFile == rfoCmp.szFile);
      bResult = bResult && (szPath == rfoCmp.szPath);
   return bResult;
}

fi_tclInContext& fi_tcl_PathFilename::oRead(fi_tclInContext& oIn)
{
   oIn >> szFile;
   oIn >> szPath;
   return oIn;
}

fi_tclOutContext& fi_tcl_PathFilename::oWrite(fi_tclOutContext& oOut) const
{
   oOut << szFile;
   oOut << szPath;
   return oOut;
}

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
fi_tcl_DapPhysicalAddress::fi_tcl_DapPhysicalAddress(const fi_tcl_DapPhysicalAddress& coRef):fi_tclVisitableTypeBase(coRef)
{
   u32MediaId = coRef.u32MediaId;
   oPathFilename = coRef.oPathFilename;
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
fi_tcl_DapPhysicalAddress& fi_tcl_DapPhysicalAddress::operator=(const fi_tcl_DapPhysicalAddress& coRef)
{
   if (this == &coRef) return *this;
   u32MediaId = coRef.u32MediaId;
   oPathFilename = coRef.oPathFilename;
   return *this;
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
tVoid fi_tcl_DapPhysicalAddress::vDestroy()
{
   oPathFilename.vDestroy(); 
}

tU32 fi_tcl_DapPhysicalAddress::u32GetSize(tU16 u16MajorVersion) const
{
   return 4+oPathFilename.u32GetSize(u16MajorVersion);
}

tBool fi_tcl_DapPhysicalAddress::operator==(const fi_tcl_DapPhysicalAddress& rfoCmp) const
{
   tBool bResult = true;
      bResult = bResult && (u32MediaId == rfoCmp.u32MediaId);
      bResult = bResult && (oPathFilename == rfoCmp.oPathFilename);
   return bResult;
}

fi_tclInContext& fi_tcl_DapPhysicalAddress::oRead(fi_tclInContext& oIn)
{
   oIn >> u32MediaId;
   oIn >> oPathFilename;
   return oIn;
}

fi_tclOutContext& fi_tcl_DapPhysicalAddress::oWrite(fi_tclOutContext& oOut) const
{
   oOut << u32MediaId;
   oOut << oPathFilename;
   return oOut;
}

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
fi_tcl_DapPhysicalBlockAddress::fi_tcl_DapPhysicalBlockAddress(const fi_tcl_DapPhysicalBlockAddress& coRef):fi_tclVisitableTypeBase(coRef)
{
   oPhysAdr = coRef.oPhysAdr;
   u32FileOffset = coRef.u32FileOffset;
   u32BlockSize = coRef.u32BlockSize;
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
fi_tcl_DapPhysicalBlockAddress& fi_tcl_DapPhysicalBlockAddress::operator=(const fi_tcl_DapPhysicalBlockAddress& coRef)
{
   if (this == &coRef) return *this;
   oPhysAdr = coRef.oPhysAdr;
   u32FileOffset = coRef.u32FileOffset;
   u32BlockSize = coRef.u32BlockSize;
   return *this;
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
tVoid fi_tcl_DapPhysicalBlockAddress::vDestroy()
{
   oPhysAdr.vDestroy(); 
}

tU32 fi_tcl_DapPhysicalBlockAddress::u32GetSize(tU16 u16MajorVersion) const
{
   return 8+oPhysAdr.u32GetSize(u16MajorVersion);
}

tBool fi_tcl_DapPhysicalBlockAddress::operator==(const fi_tcl_DapPhysicalBlockAddress& rfoCmp) const
{
   tBool bResult = true;
      bResult = bResult && (oPhysAdr == rfoCmp.oPhysAdr);
      bResult = bResult && (u32FileOffset == rfoCmp.u32FileOffset);
      bResult = bResult && (u32BlockSize == rfoCmp.u32BlockSize);
   return bResult;
}

fi_tclInContext& fi_tcl_DapPhysicalBlockAddress::oRead(fi_tclInContext& oIn)
{
   oIn >> oPhysAdr;
   oIn >> u32FileOffset;
   oIn >> u32BlockSize;
   return oIn;
}

fi_tclOutContext& fi_tcl_DapPhysicalBlockAddress::oWrite(fi_tclOutContext& oOut) const
{
   oOut << oPhysAdr;
   oOut << u32FileOffset;
   oOut << u32BlockSize;
   return oOut;
}

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
fi_tcl_DapPhysicalBlockListElem::fi_tcl_DapPhysicalBlockListElem(const fi_tcl_DapPhysicalBlockListElem& coRef):fi_tclVisitableTypeBase(coRef)
{
   oPhysBlockAdr = coRef.oPhysBlockAdr;
   u32OriginIndex = coRef.u32OriginIndex;
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
fi_tcl_DapPhysicalBlockListElem& fi_tcl_DapPhysicalBlockListElem::operator=(const fi_tcl_DapPhysicalBlockListElem& coRef)
{
   if (this == &coRef) return *this;
   oPhysBlockAdr = coRef.oPhysBlockAdr;
   u32OriginIndex = coRef.u32OriginIndex;
   return *this;
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
tVoid fi_tcl_DapPhysicalBlockListElem::vDestroy()
{
   oPhysBlockAdr.vDestroy(); 
}

tU32 fi_tcl_DapPhysicalBlockListElem::u32GetSize(tU16 u16MajorVersion) const
{
   return 4+oPhysBlockAdr.u32GetSize(u16MajorVersion);
}

tBool fi_tcl_DapPhysicalBlockListElem::operator==(const fi_tcl_DapPhysicalBlockListElem& rfoCmp) const
{
   tBool bResult = true;
      bResult = bResult && (oPhysBlockAdr == rfoCmp.oPhysBlockAdr);
      bResult = bResult && (u32OriginIndex == rfoCmp.u32OriginIndex);
   return bResult;
}

fi_tclInContext& fi_tcl_DapPhysicalBlockListElem::oRead(fi_tclInContext& oIn)
{
   oIn >> oPhysBlockAdr;
   oIn >> u32OriginIndex;
   return oIn;
}

fi_tclOutContext& fi_tcl_DapPhysicalBlockListElem::oWrite(fi_tclOutContext& oOut) const
{
   oOut << oPhysBlockAdr;
   oOut << u32OriginIndex;
   return oOut;
}

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
fi_tcl_DapComplexPhysicalBlockAddress::fi_tcl_DapComplexPhysicalBlockAddress(const fi_tcl_DapComplexPhysicalBlockAddress& coRef):fi_tclVisitableTypeBase(coRef)
{
   oPhysBlockAdr = coRef.oPhysBlockAdr;
   oMemAdr = coRef.oMemAdr;
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
fi_tcl_DapComplexPhysicalBlockAddress& fi_tcl_DapComplexPhysicalBlockAddress::operator=(const fi_tcl_DapComplexPhysicalBlockAddress& coRef)
{
   if (this == &coRef) return *this;
   oPhysBlockAdr = coRef.oPhysBlockAdr;
   oMemAdr = coRef.oMemAdr;
   return *this;
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
tVoid fi_tcl_DapComplexPhysicalBlockAddress::vDestroy()
{
   oPhysBlockAdr.vDestroy(); 
   oMemAdr.vDestroy(); 
}

tU32 fi_tcl_DapComplexPhysicalBlockAddress::u32GetSize(tU16 u16MajorVersion) const
{
   return 0+oPhysBlockAdr.u32GetSize(u16MajorVersion)+oMemAdr.u32GetSize(u16MajorVersion);
}

tBool fi_tcl_DapComplexPhysicalBlockAddress::operator==(const fi_tcl_DapComplexPhysicalBlockAddress& rfoCmp) const
{
   tBool bResult = true;
      bResult = bResult && (oPhysBlockAdr == rfoCmp.oPhysBlockAdr);
      bResult = bResult && (oMemAdr == rfoCmp.oMemAdr);
   return bResult;
}

fi_tclInContext& fi_tcl_DapComplexPhysicalBlockAddress::oRead(fi_tclInContext& oIn)
{
   oIn >> oPhysBlockAdr;
   oIn >> oMemAdr;
   return oIn;
}

fi_tclOutContext& fi_tcl_DapComplexPhysicalBlockAddress::oWrite(fi_tclOutContext& oOut) const
{
   oOut << oPhysBlockAdr;
   oOut << oMemAdr;
   return oOut;
}

tU32 fi_tcl_e8_DapDeviceError::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 1;
}

tBool fi_tcl_e8_DapDeviceError::operator==(const fi_tcl_e8_DapDeviceError& rfoCmp) const
{
   return enType == rfoCmp.enType;
}

fi_tclInContext& fi_tcl_e8_DapDeviceError::oRead(fi_tclInContext& oIn)
{
   tU8 u8Value;
   oIn >> u8Value;
   enType = (tenType)u8Value;
   return oIn;
}

fi_tclOutContext& fi_tcl_e8_DapDeviceError::oWrite(fi_tclOutContext& oOut) const
{
   return oOut.oWrite((tU8)enType);
}

tU32 fi_tcl_e8_DapDataAvailable::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 1;
}

tBool fi_tcl_e8_DapDataAvailable::operator==(const fi_tcl_e8_DapDataAvailable& rfoCmp) const
{
   return enType == rfoCmp.enType;
}

fi_tclInContext& fi_tcl_e8_DapDataAvailable::oRead(fi_tclInContext& oIn)
{
   tU8 u8Value;
   oIn >> u8Value;
   enType = (tenType)u8Value;
   return oIn;
}

fi_tclOutContext& fi_tcl_e8_DapDataAvailable::oWrite(fi_tclOutContext& oOut) const
{
   return oOut.oWrite((tU8)enType);
}

tU32 fi_tcl_e8_DapMediaType::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 1;
}

tBool fi_tcl_e8_DapMediaType::operator==(const fi_tcl_e8_DapMediaType& rfoCmp) const
{
   return enType == rfoCmp.enType;
}

fi_tclInContext& fi_tcl_e8_DapMediaType::oRead(fi_tclInContext& oIn)
{
   tU8 u8Value;
   oIn >> u8Value;
   enType = (tenType)u8Value;
   return oIn;
}

fi_tclOutContext& fi_tcl_e8_DapMediaType::oWrite(fi_tclOutContext& oOut) const
{
   fi_tcl_e8_DapMediaType::tenType enData = enType;
   if ((enData == FI_EN_DAP_ENMEDIACOPYPROTECT) && !(3 <= oOut.u16GetMajorVersion()))
   {
      enData = FI_EN_DAP_ENMEDIAINCORRECT;
   }
   if ((enData == FI_EN_DAP_ENMEDIAENCRYPTED) && !(3 <= oOut.u16GetMajorVersion()))
   {
      enData = FI_EN_DAP_ENMEDIAINCORRECT;
   }
   return oOut.oWrite((tU8)enData);
}

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
fi_tcl_FileCopy::fi_tcl_FileCopy(const fi_tcl_FileCopy& coRef):fi_tclVisitableTypeBase(coRef)
{
   oTarget = coRef.oTarget;
   oSource = coRef.oSource;
   bCloseFileAfterProcessing = coRef.bCloseFileAfterProcessing;
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
fi_tcl_FileCopy& fi_tcl_FileCopy::operator=(const fi_tcl_FileCopy& coRef)
{
   if (this == &coRef) return *this;
   oTarget = coRef.oTarget;
   oSource = coRef.oSource;
   bCloseFileAfterProcessing = coRef.bCloseFileAfterProcessing;
   return *this;
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
tVoid fi_tcl_FileCopy::vDestroy()
{
   oTarget.vDestroy(); 
   oSource.vDestroy(); 
}

tU32 fi_tcl_FileCopy::u32GetSize(tU16 u16MajorVersion) const
{
   return 1+oTarget.u32GetSize(u16MajorVersion)+oSource.u32GetSize(u16MajorVersion);
}

tBool fi_tcl_FileCopy::operator==(const fi_tcl_FileCopy& rfoCmp) const
{
   tBool bResult = true;
      bResult = bResult && (oTarget == rfoCmp.oTarget);
      bResult = bResult && (oSource == rfoCmp.oSource);
      bResult = bResult && (bCloseFileAfterProcessing == rfoCmp.bCloseFileAfterProcessing);
   return bResult;
}

fi_tclInContext& fi_tcl_FileCopy::oRead(fi_tclInContext& oIn)
{
   oIn >> oTarget;
   oIn >> oSource;
   oIn >> bCloseFileAfterProcessing;
   return oIn;
}

fi_tclOutContext& fi_tcl_FileCopy::oWrite(fi_tclOutContext& oOut) const
{
   oOut << oTarget;
   oOut << oSource;
   oOut << bCloseFileAfterProcessing;
   return oOut;
}

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
fi_tcl_DapRegionDescr::fi_tcl_DapRegionDescr(const fi_tcl_DapRegionDescr& coRef):fi_tclVisitableTypeBase(coRef)
{
   u32MediumId = coRef.u32MediumId;
   u32CreateDate = coRef.u32CreateDate;
   u16RegionId = coRef.u16RegionId;
   u8ProfileID = coRef.u8ProfileID;
   szDevice = coRef.szDevice;
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
fi_tcl_DapRegionDescr& fi_tcl_DapRegionDescr::operator=(const fi_tcl_DapRegionDescr& coRef)
{
   if (this == &coRef) return *this;
   u32MediumId = coRef.u32MediumId;
   u32CreateDate = coRef.u32CreateDate;
   u16RegionId = coRef.u16RegionId;
   u8ProfileID = coRef.u8ProfileID;
   szDevice = coRef.szDevice;
   return *this;
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
tVoid fi_tcl_DapRegionDescr::vDestroy()
{
   szDevice.vDestroy();
}

tU32 fi_tcl_DapRegionDescr::u32GetSize(tU16 u16MajorVersion) const
{
   return 11+szDevice.u32GetSize(u16MajorVersion);
}

tBool fi_tcl_DapRegionDescr::operator==(const fi_tcl_DapRegionDescr& rfoCmp) const
{
   tBool bResult = true;
      bResult = bResult && (u32MediumId == rfoCmp.u32MediumId);
      bResult = bResult && (u32CreateDate == rfoCmp.u32CreateDate);
      bResult = bResult && (u16RegionId == rfoCmp.u16RegionId);
      bResult = bResult && (u8ProfileID == rfoCmp.u8ProfileID);
      bResult = bResult && (szDevice == rfoCmp.szDevice);
   return bResult;
}

fi_tclInContext& fi_tcl_DapRegionDescr::oRead(fi_tclInContext& oIn)
{
   oIn >> u32MediumId;
   oIn >> u32CreateDate;
   oIn >> u16RegionId;
   oIn >> u8ProfileID;
   oIn >> szDevice;
   return oIn;
}

fi_tclOutContext& fi_tcl_DapRegionDescr::oWrite(fi_tclOutContext& oOut) const
{
   oOut << u32MediumId;
   oOut << u32CreateDate;
   oOut << u16RegionId;
   oOut << u8ProfileID;
   oOut << szDevice;
   return oOut;
}

tU32 fi_tcl_e8_UserID::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 1;
}

tBool fi_tcl_e8_UserID::operator==(const fi_tcl_e8_UserID& rfoCmp) const
{
   return enType == rfoCmp.enType;
}

fi_tclInContext& fi_tcl_e8_UserID::oRead(fi_tclInContext& oIn)
{
   tU8 u8Value;
   oIn >> u8Value;
   enType = (tenType)u8Value;
   return oIn;
}

fi_tclOutContext& fi_tcl_e8_UserID::oWrite(fi_tclOutContext& oOut) const
{
   return oOut.oWrite((tU8)enType);
}

tU32 fi_tcl_b8_InputContinuation::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 1;
}

tBool fi_tcl_b8_InputContinuation::operator==(const fi_tcl_b8_InputContinuation& rfoCmp) const
{
   return u8Value == rfoCmp.u8Value;
}

fi_tclInContext& fi_tcl_b8_InputContinuation::oRead(fi_tclInContext& oIn)
{
   return oIn >> u8Value;
}

fi_tclOutContext& fi_tcl_b8_InputContinuation::oWrite(fi_tclOutContext& oOut) const
{
   return oOut << u8Value;
}

tU32 fi_tcl_e16_SelectionCriterionType::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 2;
}

tBool fi_tcl_e16_SelectionCriterionType::operator==(const fi_tcl_e16_SelectionCriterionType& rfoCmp) const
{
   return enType == rfoCmp.enType;
}

fi_tclInContext& fi_tcl_e16_SelectionCriterionType::oRead(fi_tclInContext& oIn)
{
   tU16 u16Value;
   oIn >> u16Value;
   enType = (tenType)u16Value;
   return oIn;
}

fi_tclOutContext& fi_tcl_e16_SelectionCriterionType::oWrite(fi_tclOutContext& oOut) const
{
   return oOut.oWrite((tU16)enType);
}

tU32 fi_tcl_b8_SelectionCriteriaMask::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 1;
}

tBool fi_tcl_b8_SelectionCriteriaMask::operator==(const fi_tcl_b8_SelectionCriteriaMask& rfoCmp) const
{
   return u8Value == rfoCmp.u8Value;
}

fi_tclInContext& fi_tcl_b8_SelectionCriteriaMask::oRead(fi_tclInContext& oIn)
{
   return oIn >> u8Value;
}

fi_tclOutContext& fi_tcl_b8_SelectionCriteriaMask::oWrite(fi_tclOutContext& oOut) const
{
   return oOut << u8Value;
}

tU32 fi_tcl_b8_RefinementCriteriaMask::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 1;
}

tBool fi_tcl_b8_RefinementCriteriaMask::operator==(const fi_tcl_b8_RefinementCriteriaMask& rfoCmp) const
{
   return u8Value == rfoCmp.u8Value;
}

fi_tclInContext& fi_tcl_b8_RefinementCriteriaMask::oRead(fi_tclInContext& oIn)
{
   return oIn >> u8Value;
}

fi_tclOutContext& fi_tcl_b8_RefinementCriteriaMask::oWrite(fi_tclOutContext& oOut) const
{
   return oOut << u8Value;
}

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
fi_tcl_ObjectDescription::fi_tcl_ObjectDescription(const fi_tcl_ObjectDescription& coRef):fi_tclVisitableTypeBase(coRef)
{
   Code = coRef.Code;
   Description = coRef.Description;
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
fi_tcl_ObjectDescription& fi_tcl_ObjectDescription::operator=(const fi_tcl_ObjectDescription& coRef)
{
   if (this == &coRef) return *this;
   Code = coRef.Code;
   Description = coRef.Description;
   return *this;
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
tVoid fi_tcl_ObjectDescription::vDestroy()
{
   Description.vDestroy();
}

tU32 fi_tcl_ObjectDescription::u32GetSize(tU16 u16MajorVersion) const
{
   return 2+Description.u32GetSize(u16MajorVersion);
}

tBool fi_tcl_ObjectDescription::operator==(const fi_tcl_ObjectDescription& rfoCmp) const
{
   tBool bResult = true;
      bResult = bResult && (Code == rfoCmp.Code);
      bResult = bResult && (Description == rfoCmp.Description);
   return bResult;
}

fi_tclInContext& fi_tcl_ObjectDescription::oRead(fi_tclInContext& oIn)
{
   oIn >> Code;
   oIn >> Description;
   return oIn;
}

fi_tclOutContext& fi_tcl_ObjectDescription::oWrite(fi_tclOutContext& oOut) const
{
   oOut << Code;
   oOut << Description;
   return oOut;
}

tU32 fi_tcl_s32_Longitude::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 4;
}

tBool fi_tcl_s32_Longitude::operator==(const fi_tcl_s32_Longitude& rfoCmp) const
{
   return s32Value == rfoCmp.s32Value;
}

fi_tclInContext& fi_tcl_s32_Longitude::oRead(fi_tclInContext& oIn)
{
   return oIn >> s32Value;
}

fi_tclOutContext& fi_tcl_s32_Longitude::oWrite(fi_tclOutContext& oOut) const
{
   return oOut << s32Value;
}

tU32 fi_tcl_b8_NavBinProperties::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 1;
}

tBool fi_tcl_b8_NavBinProperties::operator==(const fi_tcl_b8_NavBinProperties& rfoCmp) const
{
   return u8Value == rfoCmp.u8Value;
}

fi_tclInContext& fi_tcl_b8_NavBinProperties::oRead(fi_tclInContext& oIn)
{
   return oIn >> u8Value;
}

fi_tclOutContext& fi_tcl_b8_NavBinProperties::oWrite(fi_tclOutContext& oOut) const
{
   return oOut << u8Value;
}

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
fi_tcl_ClusterId::fi_tcl_ClusterId(const fi_tcl_ClusterId& coRef):fi_tclVisitableTypeBase(coRef)
{
   Offset = coRef.Offset;
   Length = coRef.Length;
   FileId = coRef.FileId;
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
fi_tcl_ClusterId& fi_tcl_ClusterId::operator=(const fi_tcl_ClusterId& coRef)
{
   if (this == &coRef) return *this;
   Offset = coRef.Offset;
   Length = coRef.Length;
   FileId = coRef.FileId;
   return *this;
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
tU32 fi_tcl_ClusterId::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 8;
}

tBool fi_tcl_ClusterId::operator==(const fi_tcl_ClusterId& rfoCmp) const
{
   tBool bResult = true;
      bResult = bResult && (Offset == rfoCmp.Offset);
      bResult = bResult && (Length == rfoCmp.Length);
      bResult = bResult && (FileId == rfoCmp.FileId);
   return bResult;
}

fi_tclInContext& fi_tcl_ClusterId::oRead(fi_tclInContext& oIn)
{
   oIn >> Offset;
   oIn >> Length;
   oIn >> FileId;
   return oIn;
}

fi_tclOutContext& fi_tcl_ClusterId::oWrite(fi_tclOutContext& oOut) const
{
   oOut << Offset;
   oOut << Length;
   oOut << FileId;
   return oOut;
}

tU32 fi_tcl_b8_CellProperties::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 2;
}

tBool fi_tcl_b8_CellProperties::operator==(const fi_tcl_b8_CellProperties& rfoCmp) const
{
   return u16Value == rfoCmp.u16Value;
}

fi_tclInContext& fi_tcl_b8_CellProperties::oRead(fi_tclInContext& oIn)
{
   return oIn >> u16Value;
}

fi_tclOutContext& fi_tcl_b8_CellProperties::oWrite(fi_tclOutContext& oOut) const
{
   return oOut << u16Value;
}

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
fi_tcl_Cell::fi_tcl_Cell(const fi_tcl_Cell& coRef):fi_tclVisitableTypeBase(coRef)
{
   ID = coRef.ID;
   Properties = coRef.Properties;
   InterpolationRatio = coRef.InterpolationRatio;
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
fi_tcl_Cell& fi_tcl_Cell::operator=(const fi_tcl_Cell& coRef)
{
   if (this == &coRef) return *this;
   ID = coRef.ID;
   Properties = coRef.Properties;
   InterpolationRatio = coRef.InterpolationRatio;
   return *this;
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
tU32 fi_tcl_Cell::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 5;
}

tBool fi_tcl_Cell::operator==(const fi_tcl_Cell& rfoCmp) const
{
   tBool bResult = true;
      bResult = bResult && (ID == rfoCmp.ID);
      bResult = bResult && (Properties == rfoCmp.Properties);
      bResult = bResult && (InterpolationRatio == rfoCmp.InterpolationRatio);
   return bResult;
}

fi_tclInContext& fi_tcl_Cell::oRead(fi_tclInContext& oIn)
{
   oIn >> ID;
   oIn >> Properties;
   oIn >> InterpolationRatio;
   return oIn;
}

fi_tclOutContext& fi_tcl_Cell::oWrite(fi_tclOutContext& oOut) const
{
   oOut << ID;
   oOut << Properties;
   oOut << InterpolationRatio;
   return oOut;
}

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
fi_tcl_ClusterInfo::fi_tcl_ClusterInfo(const fi_tcl_ClusterInfo& coRef):fi_tclVisitableTypeBase(coRef)
{
   ID = coRef.ID;
   Cells = coRef.Cells;
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
fi_tcl_ClusterInfo& fi_tcl_ClusterInfo::operator=(const fi_tcl_ClusterInfo& coRef)
{
   if (this == &coRef) return *this;
   ID = coRef.ID;
   Cells = coRef.Cells;
   return *this;
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
tVoid fi_tcl_ClusterInfo::vDestroy()
{
   ID.vDestroy(); 
   {
      for (tU32 u32Idx = 0; u32Idx < Cells.size(); ++u32Idx)
         Cells[u32Idx].vDestroy();
   }
   Cells.clear();
}

tU32 fi_tcl_ClusterInfo::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 12+Cells.size()*5;
}

tBool fi_tcl_ClusterInfo::operator==(const fi_tcl_ClusterInfo& rfoCmp) const
{
   tBool bResult = true;
      bResult = bResult && (ID == rfoCmp.ID);
      bResult = bResult && (Cells.size() == rfoCmp.Cells.size());
      if (bResult)
      {
         for (tU32 u32Idx = 0; bResult && (u32Idx < Cells.size()); ++u32Idx)
            bResult = bResult && (Cells[u32Idx] == rfoCmp.Cells[u32Idx]);
      }
   return bResult;
}

fi_tclInContext& fi_tcl_ClusterInfo::oRead(fi_tclInContext& oIn)
{
   oIn >> ID;
   {
      tU32 u32Length;
      tU32 u32Idx;
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
      for (u32Idx = 0; u32Idx < Cells.size(); ++u32Idx)
      {
         Cells[u32Idx].vDestroy();
      }
#endif // !VARIANT_S_FTR_ENABLE_DEEP_COPY
      oIn >> u32Length;
      Cells.resize(u32Length);
      for (u32Idx = 0; u32Idx < u32Length; ++u32Idx)
      {
         oIn >> Cells[u32Idx];
      }
   }
   return oIn;
}

fi_tclOutContext& fi_tcl_ClusterInfo::oWrite(fi_tclOutContext& oOut) const
{
   oOut << ID;
   oOut << (tU32)Cells.size();
   {
      for (tU32 u32Idx = 0; u32Idx < Cells.size(); ++u32Idx)
         oOut << Cells[u32Idx];
   }
   return oOut;
}

tU32 fi_tcl_e8_DetailType::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 1;
}

tBool fi_tcl_e8_DetailType::operator==(const fi_tcl_e8_DetailType& rfoCmp) const
{
   return enType == rfoCmp.enType;
}

fi_tclInContext& fi_tcl_e8_DetailType::oRead(fi_tclInContext& oIn)
{
   tU8 u8Value;
   oIn >> u8Value;
   enType = (tenType)u8Value;
   return oIn;
}

fi_tclOutContext& fi_tcl_e8_DetailType::oWrite(fi_tclOutContext& oOut) const
{
   return oOut.oWrite((tU8)enType);
}

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
fi_tcl_ObjectDetail::fi_tcl_ObjectDetail(const fi_tcl_ObjectDetail& coRef):fi_tclVisitableTypeBase(coRef)
{
   String = coRef.String;
   Type = coRef.Type;
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
fi_tcl_ObjectDetail& fi_tcl_ObjectDetail::operator=(const fi_tcl_ObjectDetail& coRef)
{
   if (this == &coRef) return *this;
   String = coRef.String;
   Type = coRef.Type;
   return *this;
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
tVoid fi_tcl_ObjectDetail::vDestroy()
{
   String.vDestroy();
}

tU32 fi_tcl_ObjectDetail::u32GetSize(tU16 u16MajorVersion) const
{
   return 1+String.u32GetSize(u16MajorVersion);
}

tBool fi_tcl_ObjectDetail::operator==(const fi_tcl_ObjectDetail& rfoCmp) const
{
   tBool bResult = true;
      bResult = bResult && (String == rfoCmp.String);
      bResult = bResult && (Type == rfoCmp.Type);
   return bResult;
}

fi_tclInContext& fi_tcl_ObjectDetail::oRead(fi_tclInContext& oIn)
{
   oIn >> String;
   oIn >> Type;
   return oIn;
}

fi_tclOutContext& fi_tcl_ObjectDetail::oWrite(fi_tclOutContext& oOut) const
{
   oOut << String;
   oOut << Type;
   return oOut;
}

tU32 fi_tcl_b8_ResolutionType::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 1;
}

tBool fi_tcl_b8_ResolutionType::operator==(const fi_tcl_b8_ResolutionType& rfoCmp) const
{
   return u8Value == rfoCmp.u8Value;
}

fi_tclInContext& fi_tcl_b8_ResolutionType::oRead(fi_tclInContext& oIn)
{
   return oIn >> u8Value;
}

fi_tclOutContext& fi_tcl_b8_ResolutionType::oWrite(fi_tclOutContext& oOut) const
{
   return oOut << u8Value;
}

tU32 fi_tcl_b8_DataSetProperties::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 1;
}

tBool fi_tcl_b8_DataSetProperties::operator==(const fi_tcl_b8_DataSetProperties& rfoCmp) const
{
   return u8Value == rfoCmp.u8Value;
}

fi_tclInContext& fi_tcl_b8_DataSetProperties::oRead(fi_tclInContext& oIn)
{
   return oIn >> u8Value;
}

fi_tclOutContext& fi_tcl_b8_DataSetProperties::oWrite(fi_tclOutContext& oOut) const
{
   return oOut << u8Value;
}

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
fi_tcl_DataSetElement::fi_tcl_DataSetElement(const fi_tcl_DataSetElement& coRef):fi_tclVisitableTypeBase(coRef)
{
   ID = coRef.ID;
   Properties = coRef.Properties;
   Name = coRef.Name;
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
fi_tcl_DataSetElement& fi_tcl_DataSetElement::operator=(const fi_tcl_DataSetElement& coRef)
{
   if (this == &coRef) return *this;
   ID = coRef.ID;
   Properties = coRef.Properties;
   Name = coRef.Name;
   return *this;
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
tVoid fi_tcl_DataSetElement::vDestroy()
{
   Name.vDestroy();
}

tU32 fi_tcl_DataSetElement::u32GetSize(tU16 u16MajorVersion) const
{
   return 5+Name.u32GetSize(u16MajorVersion);
}

tBool fi_tcl_DataSetElement::operator==(const fi_tcl_DataSetElement& rfoCmp) const
{
   tBool bResult = true;
      bResult = bResult && (ID == rfoCmp.ID);
      bResult = bResult && (Properties == rfoCmp.Properties);
      bResult = bResult && (Name == rfoCmp.Name);
   return bResult;
}

fi_tclInContext& fi_tcl_DataSetElement::oRead(fi_tclInContext& oIn)
{
   oIn >> ID;
   oIn >> Properties;
   oIn >> Name;
   return oIn;
}

fi_tclOutContext& fi_tcl_DataSetElement::oWrite(fi_tclOutContext& oOut) const
{
   oOut << ID;
   oOut << Properties;
   oOut << Name;
   return oOut;
}

tU32 fi_tcl_e16_POIType::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 2;
}

tBool fi_tcl_e16_POIType::operator==(const fi_tcl_e16_POIType& rfoCmp) const
{
   return enType == rfoCmp.enType;
}

fi_tclInContext& fi_tcl_e16_POIType::oRead(fi_tclInContext& oIn)
{
   tU16 u16Value;
   oIn >> u16Value;
   enType = (tenType)u16Value;
   return oIn;
}

fi_tclOutContext& fi_tcl_e16_POIType::oWrite(fi_tclOutContext& oOut) const
{
   return oOut.oWrite((tU16)enType);
}

tU32 fi_tcl_b16_POIType::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 2;
}

tBool fi_tcl_b16_POIType::operator==(const fi_tcl_b16_POIType& rfoCmp) const
{
   return u16Value == rfoCmp.u16Value;
}

fi_tclInContext& fi_tcl_b16_POIType::oRead(fi_tclInContext& oIn)
{
   return oIn >> u16Value;
}

fi_tclOutContext& fi_tcl_b16_POIType::oWrite(fi_tclOutContext& oOut) const
{
   return oOut << u16Value;
}

tU32 fi_tcl_e8_POIDataset::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 1;
}

tBool fi_tcl_e8_POIDataset::operator==(const fi_tcl_e8_POIDataset& rfoCmp) const
{
   return enType == rfoCmp.enType;
}

fi_tclInContext& fi_tcl_e8_POIDataset::oRead(fi_tclInContext& oIn)
{
   tU8 u8Value;
   oIn >> u8Value;
   enType = (tenType)u8Value;
   return oIn;
}

fi_tclOutContext& fi_tcl_e8_POIDataset::oWrite(fi_tclOutContext& oOut) const
{
   return oOut.oWrite((tU8)enType);
}

tU32 fi_tcl_s32_Latitude::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 4;
}

tBool fi_tcl_s32_Latitude::operator==(const fi_tcl_s32_Latitude& rfoCmp) const
{
   return s32Value == rfoCmp.s32Value;
}

fi_tclInContext& fi_tcl_s32_Latitude::oRead(fi_tclInContext& oIn)
{
   return oIn >> s32Value;
}

fi_tclOutContext& fi_tcl_s32_Latitude::oWrite(fi_tclOutContext& oOut) const
{
   return oOut << s32Value;
}

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
fi_tcl_PositionWGS84::fi_tcl_PositionWGS84(const fi_tcl_PositionWGS84& coRef):fi_tclVisitableTypeBase(coRef)
{
   Longitude = coRef.Longitude;
   Latitude = coRef.Latitude;
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
fi_tcl_PositionWGS84& fi_tcl_PositionWGS84::operator=(const fi_tcl_PositionWGS84& coRef)
{
   if (this == &coRef) return *this;
   Longitude = coRef.Longitude;
   Latitude = coRef.Latitude;
   return *this;
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
tU32 fi_tcl_PositionWGS84::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 8;
}

tBool fi_tcl_PositionWGS84::operator==(const fi_tcl_PositionWGS84& rfoCmp) const
{
   tBool bResult = true;
      bResult = bResult && (Longitude == rfoCmp.Longitude);
      bResult = bResult && (Latitude == rfoCmp.Latitude);
   return bResult;
}

fi_tclInContext& fi_tcl_PositionWGS84::oRead(fi_tclInContext& oIn)
{
   oIn >> Longitude;
   oIn >> Latitude;
   return oIn;
}

fi_tclOutContext& fi_tcl_PositionWGS84::oWrite(fi_tclOutContext& oOut) const
{
   oOut << Longitude;
   oOut << Latitude;
   return oOut;
}

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
fi_tcl_IndexCatBrand::fi_tcl_IndexCatBrand(const fi_tcl_IndexCatBrand& coRef):fi_tclVisitableTypeBase(coRef)
{
   Category = coRef.Category;
   Brand = coRef.Brand;
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
fi_tcl_IndexCatBrand& fi_tcl_IndexCatBrand::operator=(const fi_tcl_IndexCatBrand& coRef)
{
   if (this == &coRef) return *this;
   Category = coRef.Category;
   Brand = coRef.Brand;
   return *this;
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
tU32 fi_tcl_IndexCatBrand::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 4;
}

tBool fi_tcl_IndexCatBrand::operator==(const fi_tcl_IndexCatBrand& rfoCmp) const
{
   tBool bResult = true;
      bResult = bResult && (Category == rfoCmp.Category);
      bResult = bResult && (Brand == rfoCmp.Brand);
   return bResult;
}

fi_tclInContext& fi_tcl_IndexCatBrand::oRead(fi_tclInContext& oIn)
{
   oIn >> Category;
   oIn >> Brand;
   return oIn;
}

fi_tclOutContext& fi_tcl_IndexCatBrand::oWrite(fi_tclOutContext& oOut) const
{
   oOut << Category;
   oOut << Brand;
   return oOut;
}

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
fi_tcl_MapIdPair::fi_tcl_MapIdPair(const fi_tcl_MapIdPair& coRef):fi_tclVisitableTypeBase(coRef)
{
   FeatureGroup = coRef.FeatureGroup;
   SubGroup = coRef.SubGroup;
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
fi_tcl_MapIdPair& fi_tcl_MapIdPair::operator=(const fi_tcl_MapIdPair& coRef)
{
   if (this == &coRef) return *this;
   FeatureGroup = coRef.FeatureGroup;
   SubGroup = coRef.SubGroup;
   return *this;
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
tU32 fi_tcl_MapIdPair::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 4;
}

tBool fi_tcl_MapIdPair::operator==(const fi_tcl_MapIdPair& rfoCmp) const
{
   tBool bResult = true;
      bResult = bResult && (FeatureGroup == rfoCmp.FeatureGroup);
      bResult = bResult && (SubGroup == rfoCmp.SubGroup);
   return bResult;
}

fi_tclInContext& fi_tcl_MapIdPair::oRead(fi_tclInContext& oIn)
{
   oIn >> FeatureGroup;
   oIn >> SubGroup;
   return oIn;
}

fi_tclOutContext& fi_tcl_MapIdPair::oWrite(fi_tclOutContext& oOut) const
{
   oOut << FeatureGroup;
   oOut << SubGroup;
   return oOut;
}

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
fi_tcl_DataBlockStartInfo::fi_tcl_DataBlockStartInfo(const fi_tcl_DataBlockStartInfo& coRef):fi_tclVisitableTypeBase(coRef)
{
   u32Offset = coRef.u32Offset;
   u32Size = coRef.u32Size;
   szSharedMemory = coRef.szSharedMemory;
   szPath = coRef.szPath;
   szFilename = coRef.szFilename;
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
fi_tcl_DataBlockStartInfo& fi_tcl_DataBlockStartInfo::operator=(const fi_tcl_DataBlockStartInfo& coRef)
{
   if (this == &coRef) return *this;
   u32Offset = coRef.u32Offset;
   u32Size = coRef.u32Size;
   szSharedMemory = coRef.szSharedMemory;
   szPath = coRef.szPath;
   szFilename = coRef.szFilename;
   return *this;
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
tVoid fi_tcl_DataBlockStartInfo::vDestroy()
{
   szSharedMemory.vDestroy();
   szPath.vDestroy();
   szFilename.vDestroy();
}

tU32 fi_tcl_DataBlockStartInfo::u32GetSize(tU16 u16MajorVersion) const
{
   return 8+szSharedMemory.u32GetSize(u16MajorVersion)+szPath.u32GetSize(u16MajorVersion)+szFilename.u32GetSize(u16MajorVersion);
}

tBool fi_tcl_DataBlockStartInfo::operator==(const fi_tcl_DataBlockStartInfo& rfoCmp) const
{
   tBool bResult = true;
      bResult = bResult && (u32Offset == rfoCmp.u32Offset);
      bResult = bResult && (u32Size == rfoCmp.u32Size);
      bResult = bResult && (szSharedMemory == rfoCmp.szSharedMemory);
      bResult = bResult && (szPath == rfoCmp.szPath);
      bResult = bResult && (szFilename == rfoCmp.szFilename);
   return bResult;
}

fi_tclInContext& fi_tcl_DataBlockStartInfo::oRead(fi_tclInContext& oIn)
{
   oIn >> u32Offset;
   oIn >> u32Size;
   oIn >> szSharedMemory;
   oIn >> szPath;
   oIn >> szFilename;
   return oIn;
}

fi_tclOutContext& fi_tcl_DataBlockStartInfo::oWrite(fi_tclOutContext& oOut) const
{
   oOut << u32Offset;
   oOut << u32Size;
   oOut << szSharedMemory;
   oOut << szPath;
   oOut << szFilename;
   return oOut;
}

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
fi_tcl_DataBlockResultInfo::fi_tcl_DataBlockResultInfo(const fi_tcl_DataBlockResultInfo& coRef):fi_tclVisitableTypeBase(coRef)
{
   u32Offset = coRef.u32Offset;
   u32Size = coRef.u32Size;
   u16ErrorCode = coRef.u16ErrorCode;
   szSharedMemory = coRef.szSharedMemory;
   szPath = coRef.szPath;
   szFilename = coRef.szFilename;
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
fi_tcl_DataBlockResultInfo& fi_tcl_DataBlockResultInfo::operator=(const fi_tcl_DataBlockResultInfo& coRef)
{
   if (this == &coRef) return *this;
   u32Offset = coRef.u32Offset;
   u32Size = coRef.u32Size;
   u16ErrorCode = coRef.u16ErrorCode;
   szSharedMemory = coRef.szSharedMemory;
   szPath = coRef.szPath;
   szFilename = coRef.szFilename;
   return *this;
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
tVoid fi_tcl_DataBlockResultInfo::vDestroy()
{
   szSharedMemory.vDestroy();
   szPath.vDestroy();
   szFilename.vDestroy();
}

tU32 fi_tcl_DataBlockResultInfo::u32GetSize(tU16 u16MajorVersion) const
{
   return 10+szSharedMemory.u32GetSize(u16MajorVersion)+szPath.u32GetSize(u16MajorVersion)+szFilename.u32GetSize(u16MajorVersion);
}

tBool fi_tcl_DataBlockResultInfo::operator==(const fi_tcl_DataBlockResultInfo& rfoCmp) const
{
   tBool bResult = true;
      bResult = bResult && (u32Offset == rfoCmp.u32Offset);
      bResult = bResult && (u32Size == rfoCmp.u32Size);
      bResult = bResult && (u16ErrorCode == rfoCmp.u16ErrorCode);
      bResult = bResult && (szSharedMemory == rfoCmp.szSharedMemory);
      bResult = bResult && (szPath == rfoCmp.szPath);
      bResult = bResult && (szFilename == rfoCmp.szFilename);
   return bResult;
}

fi_tclInContext& fi_tcl_DataBlockResultInfo::oRead(fi_tclInContext& oIn)
{
   oIn >> u32Offset;
   oIn >> u32Size;
   oIn >> u16ErrorCode;
   oIn >> szSharedMemory;
   oIn >> szPath;
   oIn >> szFilename;
   return oIn;
}

fi_tclOutContext& fi_tcl_DataBlockResultInfo::oWrite(fi_tclOutContext& oOut) const
{
   oOut << u32Offset;
   oOut << u32Size;
   oOut << u16ErrorCode;
   oOut << szSharedMemory;
   oOut << szPath;
   oOut << szFilename;
   return oOut;
}

tU32 fi_tcl_e8_StorageMode::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 1;
}

tBool fi_tcl_e8_StorageMode::operator==(const fi_tcl_e8_StorageMode& rfoCmp) const
{
   return enType == rfoCmp.enType;
}

fi_tclInContext& fi_tcl_e8_StorageMode::oRead(fi_tclInContext& oIn)
{
   tU8 u8Value;
   oIn >> u8Value;
   enType = (tenType)u8Value;
   return oIn;
}

fi_tclOutContext& fi_tcl_e8_StorageMode::oWrite(fi_tclOutContext& oOut) const
{
   return oOut.oWrite((tU8)enType);
}

tU32 fi_tcl_e8_ResumeType::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 1;
}

tBool fi_tcl_e8_ResumeType::operator==(const fi_tcl_e8_ResumeType& rfoCmp) const
{
   return enType == rfoCmp.enType;
}

fi_tclInContext& fi_tcl_e8_ResumeType::oRead(fi_tclInContext& oIn)
{
   tU8 u8Value;
   oIn >> u8Value;
   enType = (tenType)u8Value;
   return oIn;
}

fi_tclOutContext& fi_tcl_e8_ResumeType::oWrite(fi_tclOutContext& oOut) const
{
   return oOut.oWrite((tU8)enType);
}

tU32 fi_tcl_e8_StoreStatus::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 1;
}

tBool fi_tcl_e8_StoreStatus::operator==(const fi_tcl_e8_StoreStatus& rfoCmp) const
{
   return enType == rfoCmp.enType;
}

fi_tclInContext& fi_tcl_e8_StoreStatus::oRead(fi_tclInContext& oIn)
{
   tU8 u8Value;
   oIn >> u8Value;
   enType = (tenType)u8Value;
   return oIn;
}

fi_tclOutContext& fi_tcl_e8_StoreStatus::oWrite(fi_tclOutContext& oOut) const
{
   return oOut.oWrite((tU8)enType);
}

tU32 fi_tcl_e8_ProgressStatus::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 1;
}

tBool fi_tcl_e8_ProgressStatus::operator==(const fi_tcl_e8_ProgressStatus& rfoCmp) const
{
   return enType == rfoCmp.enType;
}

fi_tclInContext& fi_tcl_e8_ProgressStatus::oRead(fi_tclInContext& oIn)
{
   tU8 u8Value;
   oIn >> u8Value;
   enType = (tenType)u8Value;
   return oIn;
}

fi_tclOutContext& fi_tcl_e8_ProgressStatus::oWrite(fi_tclOutContext& oOut) const
{
   return oOut.oWrite((tU8)enType);
}

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
fi_tcl_RegionNumberOrder::fi_tcl_RegionNumberOrder(const fi_tcl_RegionNumberOrder& coRef):fi_tclVisitableTypeBase(coRef)
{
   RegionNumber = coRef.RegionNumber;
   enStorageMode = coRef.enStorageMode;
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
fi_tcl_RegionNumberOrder& fi_tcl_RegionNumberOrder::operator=(const fi_tcl_RegionNumberOrder& coRef)
{
   if (this == &coRef) return *this;
   RegionNumber = coRef.RegionNumber;
   enStorageMode = coRef.enStorageMode;
   return *this;
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
tU32 fi_tcl_RegionNumberOrder::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 3;
}

tBool fi_tcl_RegionNumberOrder::operator==(const fi_tcl_RegionNumberOrder& rfoCmp) const
{
   tBool bResult = true;
      bResult = bResult && (RegionNumber == rfoCmp.RegionNumber);
      bResult = bResult && (enStorageMode == rfoCmp.enStorageMode);
   return bResult;
}

fi_tclInContext& fi_tcl_RegionNumberOrder::oRead(fi_tclInContext& oIn)
{
   oIn >> RegionNumber;
   oIn >> enStorageMode;
   return oIn;
}

fi_tclOutContext& fi_tcl_RegionNumberOrder::oWrite(fi_tclOutContext& oOut) const
{
   oOut << RegionNumber;
   oOut << enStorageMode;
   return oOut;
}

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
fi_tcl_RegionNumberResult::fi_tcl_RegionNumberResult(const fi_tcl_RegionNumberResult& coRef):fi_tclVisitableTypeBase(coRef)
{
   RegionNumber = coRef.RegionNumber;
   Error = coRef.Error;
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
fi_tcl_RegionNumberResult& fi_tcl_RegionNumberResult::operator=(const fi_tcl_RegionNumberResult& coRef)
{
   if (this == &coRef) return *this;
   RegionNumber = coRef.RegionNumber;
   Error = coRef.Error;
   return *this;
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
tU32 fi_tcl_RegionNumberResult::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 4;
}

tBool fi_tcl_RegionNumberResult::operator==(const fi_tcl_RegionNumberResult& rfoCmp) const
{
   tBool bResult = true;
      bResult = bResult && (RegionNumber == rfoCmp.RegionNumber);
      bResult = bResult && (Error == rfoCmp.Error);
   return bResult;
}

fi_tclInContext& fi_tcl_RegionNumberResult::oRead(fi_tclInContext& oIn)
{
   oIn >> RegionNumber;
   oIn >> Error;
   return oIn;
}

fi_tclOutContext& fi_tcl_RegionNumberResult::oWrite(fi_tclOutContext& oOut) const
{
   oOut << RegionNumber;
   oOut << Error;
   return oOut;
}

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
fi_tcl_RegionInfo::fi_tcl_RegionInfo(const fi_tcl_RegionInfo& coRef):fi_tclVisitableTypeBase(coRef)
{
   RegionNumber = coRef.RegionNumber;
   RegionCodeId = coRef.RegionCodeId;
   RegionProfileId = coRef.RegionProfileId;
   Size = coRef.Size;
   NeededSlots = coRef.NeededSlots;
   RegionName = coRef.RegionName;
   CreationDate = coRef.CreationDate;
   StoreStatus = coRef.StoreStatus;
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
fi_tcl_RegionInfo& fi_tcl_RegionInfo::operator=(const fi_tcl_RegionInfo& coRef)
{
   if (this == &coRef) return *this;
   RegionNumber = coRef.RegionNumber;
   RegionCodeId = coRef.RegionCodeId;
   RegionProfileId = coRef.RegionProfileId;
   Size = coRef.Size;
   NeededSlots = coRef.NeededSlots;
   RegionName = coRef.RegionName;
   CreationDate = coRef.CreationDate;
   StoreStatus = coRef.StoreStatus;
   return *this;
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
tVoid fi_tcl_RegionInfo::vDestroy()
{
   RegionName.vDestroy();
}

tU32 fi_tcl_RegionInfo::u32GetSize(tU16 u16MajorVersion) const
{
   tU32 u32DynamicSize = 0;
   if (1 <= u16MajorVersion)
   {
      u32DynamicSize += 1;
   }
   return u32DynamicSize+16+RegionName.u32GetSize(u16MajorVersion);
}

tBool fi_tcl_RegionInfo::operator==(const fi_tcl_RegionInfo& rfoCmp) const
{
   tBool bResult = true;
      bResult = bResult && (RegionNumber == rfoCmp.RegionNumber);
      bResult = bResult && (RegionCodeId == rfoCmp.RegionCodeId);
      bResult = bResult && (RegionProfileId == rfoCmp.RegionProfileId);
      bResult = bResult && (Size == rfoCmp.Size);
      bResult = bResult && (NeededSlots == rfoCmp.NeededSlots);
      bResult = bResult && (RegionName == rfoCmp.RegionName);
      bResult = bResult && (CreationDate == rfoCmp.CreationDate);
      bResult = bResult && (StoreStatus == rfoCmp.StoreStatus);
   return bResult;
}

fi_tclInContext& fi_tcl_RegionInfo::oRead(fi_tclInContext& oIn)
{
   oIn >> RegionNumber;
   oIn >> RegionCodeId;
   oIn >> RegionProfileId;
   oIn >> Size;
   oIn >> NeededSlots;
   oIn >> RegionName;
   oIn >> CreationDate;
   if (1 <= oIn.u16GetMajorVersion())
   {
      oIn >> StoreStatus;
   }
   return oIn;
}

fi_tclOutContext& fi_tcl_RegionInfo::oWrite(fi_tclOutContext& oOut) const
{
   oOut << RegionNumber;
   oOut << RegionCodeId;
   oOut << RegionProfileId;
   oOut << Size;
   oOut << NeededSlots;
   oOut << RegionName;
   oOut << CreationDate;
   if (1 <= oOut.u16GetMajorVersion())
   {
      oOut << StoreStatus;
   }
   return oOut;
}

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
fi_tcl_RegionOutline::fi_tcl_RegionOutline(const fi_tcl_RegionOutline& coRef):fi_tclVisitableTypeBase(coRef)
{
   RegionCodeId = coRef.RegionCodeId;
   RegionProfileId = coRef.RegionProfileId;
   CreationDate = coRef.CreationDate;
   StoreStatus = coRef.StoreStatus;
   Outline = coRef.Outline;
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
fi_tcl_RegionOutline& fi_tcl_RegionOutline::operator=(const fi_tcl_RegionOutline& coRef)
{
   if (this == &coRef) return *this;
   RegionCodeId = coRef.RegionCodeId;
   RegionProfileId = coRef.RegionProfileId;
   CreationDate = coRef.CreationDate;
   StoreStatus = coRef.StoreStatus;
   Outline = coRef.Outline;
   return *this;
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
tVoid fi_tcl_RegionOutline::vDestroy()
{
   {
      for (tU32 u32Idx = 0; u32Idx < Outline.size(); ++u32Idx)
         Outline[u32Idx].vDestroy();
   }
   Outline.clear();
}

tU32 fi_tcl_RegionOutline::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 13+Outline.size()*8;
}

tBool fi_tcl_RegionOutline::operator==(const fi_tcl_RegionOutline& rfoCmp) const
{
   tBool bResult = true;
      bResult = bResult && (RegionCodeId == rfoCmp.RegionCodeId);
      bResult = bResult && (RegionProfileId == rfoCmp.RegionProfileId);
      bResult = bResult && (CreationDate == rfoCmp.CreationDate);
      bResult = bResult && (StoreStatus == rfoCmp.StoreStatus);
      bResult = bResult && (Outline.size() == rfoCmp.Outline.size());
      if (bResult)
      {
         for (tU32 u32Idx = 0; bResult && (u32Idx < Outline.size()); ++u32Idx)
            bResult = bResult && (Outline[u32Idx] == rfoCmp.Outline[u32Idx]);
      }
   return bResult;
}

fi_tclInContext& fi_tcl_RegionOutline::oRead(fi_tclInContext& oIn)
{
   oIn >> RegionCodeId;
   oIn >> RegionProfileId;
   oIn >> CreationDate;
   oIn >> StoreStatus;
   {
      tU32 u32Length;
      tU32 u32Idx;
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
      for (u32Idx = 0; u32Idx < Outline.size(); ++u32Idx)
      {
         Outline[u32Idx].vDestroy();
      }
#endif // !VARIANT_S_FTR_ENABLE_DEEP_COPY
      oIn >> u32Length;
      Outline.resize(u32Length);
      for (u32Idx = 0; u32Idx < u32Length; ++u32Idx)
      {
         oIn >> Outline[u32Idx];
      }
   }
   return oIn;
}

fi_tclOutContext& fi_tcl_RegionOutline::oWrite(fi_tclOutContext& oOut) const
{
   oOut << RegionCodeId;
   oOut << RegionProfileId;
   oOut << CreationDate;
   oOut << StoreStatus;
   oOut << (tU32)Outline.size();
   {
      for (tU32 u32Idx = 0; u32Idx < Outline.size(); ++u32Idx)
         oOut << Outline[u32Idx];
   }
   return oOut;
}

tU32 fi_tcl_e8_DapAccessMode::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 1;
}

tBool fi_tcl_e8_DapAccessMode::operator==(const fi_tcl_e8_DapAccessMode& rfoCmp) const
{
   return enType == rfoCmp.enType;
}

fi_tclInContext& fi_tcl_e8_DapAccessMode::oRead(fi_tclInContext& oIn)
{
   tU8 u8Value;
   oIn >> u8Value;
   enType = (tenType)u8Value;
   return oIn;
}

fi_tclOutContext& fi_tcl_e8_DapAccessMode::oWrite(fi_tclOutContext& oOut) const
{
   return oOut.oWrite((tU8)enType);
}

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
fi_tcl_DapDeviceStatusInfo::fi_tcl_DapDeviceStatusInfo(const fi_tcl_DapDeviceStatusInfo& coRef):fi_tclVisitableTypeBase(coRef)
{
   szDevicePath = coRef.szDevicePath;
   enDeviceError = coRef.enDeviceError;
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
fi_tcl_DapDeviceStatusInfo& fi_tcl_DapDeviceStatusInfo::operator=(const fi_tcl_DapDeviceStatusInfo& coRef)
{
   if (this == &coRef) return *this;
   szDevicePath = coRef.szDevicePath;
   enDeviceError = coRef.enDeviceError;
   return *this;
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
tVoid fi_tcl_DapDeviceStatusInfo::vDestroy()
{
   szDevicePath.vDestroy();
}

tU32 fi_tcl_DapDeviceStatusInfo::u32GetSize(tU16 u16MajorVersion) const
{
   return 1+szDevicePath.u32GetSize(u16MajorVersion);
}

tBool fi_tcl_DapDeviceStatusInfo::operator==(const fi_tcl_DapDeviceStatusInfo& rfoCmp) const
{
   tBool bResult = true;
      bResult = bResult && (szDevicePath == rfoCmp.szDevicePath);
      bResult = bResult && (enDeviceError == rfoCmp.enDeviceError);
   return bResult;
}

fi_tclInContext& fi_tcl_DapDeviceStatusInfo::oRead(fi_tclInContext& oIn)
{
   oIn >> szDevicePath;
   oIn >> enDeviceError;
   return oIn;
}

fi_tclOutContext& fi_tcl_DapDeviceStatusInfo::oWrite(fi_tclOutContext& oOut) const
{
   oOut << szDevicePath;
   oOut << enDeviceError;
   return oOut;
}

tU32 fi_tcl_e8_DapWriteProt::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 1;
}

tBool fi_tcl_e8_DapWriteProt::operator==(const fi_tcl_e8_DapWriteProt& rfoCmp) const
{
   return enType == rfoCmp.enType;
}

fi_tclInContext& fi_tcl_e8_DapWriteProt::oRead(fi_tclInContext& oIn)
{
   tU8 u8Value;
   oIn >> u8Value;
   enType = (tenType)u8Value;
   return oIn;
}

fi_tclOutContext& fi_tcl_e8_DapWriteProt::oWrite(fi_tclOutContext& oOut) const
{
   return oOut.oWrite((tU8)enType);
}

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
fi_tcl_DapVirtualMediaInfo::fi_tcl_DapVirtualMediaInfo(const fi_tcl_DapVirtualMediaInfo& coRef):fi_tclVisitableTypeBase(coRef)
{
   u32MediaId = coRef.u32MediaId;
   enDataAvailable = coRef.enDataAvailable;
   szMediaDescription = coRef.szMediaDescription;
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
fi_tcl_DapVirtualMediaInfo& fi_tcl_DapVirtualMediaInfo::operator=(const fi_tcl_DapVirtualMediaInfo& coRef)
{
   if (this == &coRef) return *this;
   u32MediaId = coRef.u32MediaId;
   enDataAvailable = coRef.enDataAvailable;
   szMediaDescription = coRef.szMediaDescription;
   return *this;
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
tVoid fi_tcl_DapVirtualMediaInfo::vDestroy()
{
   szMediaDescription.vDestroy();
}

tU32 fi_tcl_DapVirtualMediaInfo::u32GetSize(tU16 u16MajorVersion) const
{
   return 5+szMediaDescription.u32GetSize(u16MajorVersion);
}

tBool fi_tcl_DapVirtualMediaInfo::operator==(const fi_tcl_DapVirtualMediaInfo& rfoCmp) const
{
   tBool bResult = true;
      bResult = bResult && (u32MediaId == rfoCmp.u32MediaId);
      bResult = bResult && (enDataAvailable == rfoCmp.enDataAvailable);
      bResult = bResult && (szMediaDescription == rfoCmp.szMediaDescription);
   return bResult;
}

fi_tclInContext& fi_tcl_DapVirtualMediaInfo::oRead(fi_tclInContext& oIn)
{
   oIn >> u32MediaId;
   oIn >> enDataAvailable;
   oIn >> szMediaDescription;
   return oIn;
}

fi_tclOutContext& fi_tcl_DapVirtualMediaInfo::oWrite(fi_tclOutContext& oOut) const
{
   oOut << u32MediaId;
   oOut << enDataAvailable;
   oOut << szMediaDescription;
   return oOut;
}

tU32 fi_tcl_e16_DapFileType::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 2;
}

tBool fi_tcl_e16_DapFileType::operator==(const fi_tcl_e16_DapFileType& rfoCmp) const
{
   return enType == rfoCmp.enType;
}

fi_tclInContext& fi_tcl_e16_DapFileType::oRead(fi_tclInContext& oIn)
{
   tU16 u16Value;
   oIn >> u16Value;
   enType = (tenType)u16Value;
   return oIn;
}

fi_tclOutContext& fi_tcl_e16_DapFileType::oWrite(fi_tclOutContext& oOut) const
{
   return oOut.oWrite((tU16)enType);
}

tU32 fi_tcl_e16_DapNumberRepr::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 2;
}

tBool fi_tcl_e16_DapNumberRepr::operator==(const fi_tcl_e16_DapNumberRepr& rfoCmp) const
{
   return enType == rfoCmp.enType;
}

fi_tclInContext& fi_tcl_e16_DapNumberRepr::oRead(fi_tclInContext& oIn)
{
   tU16 u16Value;
   oIn >> u16Value;
   enType = (tenType)u16Value;
   return oIn;
}

fi_tclOutContext& fi_tcl_e16_DapNumberRepr::oWrite(fi_tclOutContext& oOut) const
{
   return oOut.oWrite((tU16)enType);
}

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
fi_tcl_DapDeviceInfo::fi_tcl_DapDeviceInfo(const fi_tcl_DapDeviceInfo& coRef):fi_tclVisitableTypeBase(coRef)
{
   enDeviceError = coRef.enDeviceError;
   szDeviceName = coRef.szDeviceName;
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
fi_tcl_DapDeviceInfo& fi_tcl_DapDeviceInfo::operator=(const fi_tcl_DapDeviceInfo& coRef)
{
   if (this == &coRef) return *this;
   enDeviceError = coRef.enDeviceError;
   szDeviceName = coRef.szDeviceName;
   return *this;
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
tVoid fi_tcl_DapDeviceInfo::vDestroy()
{
   szDeviceName.vDestroy();
}

tU32 fi_tcl_DapDeviceInfo::u32GetSize(tU16 u16MajorVersion) const
{
   return 1+szDeviceName.u32GetSize(u16MajorVersion);
}

tBool fi_tcl_DapDeviceInfo::operator==(const fi_tcl_DapDeviceInfo& rfoCmp) const
{
   tBool bResult = true;
      bResult = bResult && (enDeviceError == rfoCmp.enDeviceError);
      bResult = bResult && (szDeviceName == rfoCmp.szDeviceName);
   return bResult;
}

fi_tclInContext& fi_tcl_DapDeviceInfo::oRead(fi_tclInContext& oIn)
{
   oIn >> enDeviceError;
   oIn >> szDeviceName;
   return oIn;
}

fi_tclOutContext& fi_tcl_DapDeviceInfo::oWrite(fi_tclOutContext& oOut) const
{
   oOut << enDeviceError;
   oOut << szDeviceName;
   return oOut;
}

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
fi_tcl_DapFileType::fi_tcl_DapFileType(const fi_tcl_DapFileType& coRef):fi_tclVisitableTypeBase(coRef)
{
   u16FileType = coRef.u16FileType;
   u16NumRep = coRef.u16NumRep;
   szPrefix = coRef.szPrefix;
   szSuffix = coRef.szSuffix;
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
fi_tcl_DapFileType& fi_tcl_DapFileType::operator=(const fi_tcl_DapFileType& coRef)
{
   if (this == &coRef) return *this;
   u16FileType = coRef.u16FileType;
   u16NumRep = coRef.u16NumRep;
   szPrefix = coRef.szPrefix;
   szSuffix = coRef.szSuffix;
   return *this;
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
tVoid fi_tcl_DapFileType::vDestroy()
{
   szPrefix.vDestroy();
   szSuffix.vDestroy();
}

tU32 fi_tcl_DapFileType::u32GetSize(tU16 u16MajorVersion) const
{
   return 4+szPrefix.u32GetSize(u16MajorVersion)+szSuffix.u32GetSize(u16MajorVersion);
}

tBool fi_tcl_DapFileType::operator==(const fi_tcl_DapFileType& rfoCmp) const
{
   tBool bResult = true;
      bResult = bResult && (u16FileType == rfoCmp.u16FileType);
      bResult = bResult && (u16NumRep == rfoCmp.u16NumRep);
      bResult = bResult && (szPrefix == rfoCmp.szPrefix);
      bResult = bResult && (szSuffix == rfoCmp.szSuffix);
   return bResult;
}

fi_tclInContext& fi_tcl_DapFileType::oRead(fi_tclInContext& oIn)
{
   oIn >> u16FileType;
   oIn >> u16NumRep;
   oIn >> szPrefix;
   oIn >> szSuffix;
   return oIn;
}

fi_tclOutContext& fi_tcl_DapFileType::oWrite(fi_tclOutContext& oOut) const
{
   oOut << u16FileType;
   oOut << u16NumRep;
   oOut << szPrefix;
   oOut << szSuffix;
   return oOut;
}

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
fi_tcl_DapCodePageDescr::fi_tcl_DapCodePageDescr(const fi_tcl_DapCodePageDescr& coRef):fi_tclVisitableTypeBase(coRef)
{
   u16ListPosition = coRef.u16ListPosition;
   u32FirstLetter = coRef.u32FirstLetter;
   u32LastLetter = coRef.u32LastLetter;
   szCodePage = coRef.szCodePage;
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
fi_tcl_DapCodePageDescr& fi_tcl_DapCodePageDescr::operator=(const fi_tcl_DapCodePageDescr& coRef)
{
   if (this == &coRef) return *this;
   u16ListPosition = coRef.u16ListPosition;
   u32FirstLetter = coRef.u32FirstLetter;
   u32LastLetter = coRef.u32LastLetter;
   szCodePage = coRef.szCodePage;
   return *this;
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
tVoid fi_tcl_DapCodePageDescr::vDestroy()
{
   szCodePage.vDestroy();
}

tU32 fi_tcl_DapCodePageDescr::u32GetSize(tU16 u16MajorVersion) const
{
   return 10+szCodePage.u32GetSize(u16MajorVersion);
}

tBool fi_tcl_DapCodePageDescr::operator==(const fi_tcl_DapCodePageDescr& rfoCmp) const
{
   tBool bResult = true;
      bResult = bResult && (u16ListPosition == rfoCmp.u16ListPosition);
      bResult = bResult && (u32FirstLetter == rfoCmp.u32FirstLetter);
      bResult = bResult && (u32LastLetter == rfoCmp.u32LastLetter);
      bResult = bResult && (szCodePage == rfoCmp.szCodePage);
   return bResult;
}

fi_tclInContext& fi_tcl_DapCodePageDescr::oRead(fi_tclInContext& oIn)
{
   oIn >> u16ListPosition;
   oIn >> u32FirstLetter;
   oIn >> u32LastLetter;
   oIn >> szCodePage;
   return oIn;
}

fi_tclOutContext& fi_tcl_DapCodePageDescr::oWrite(fi_tclOutContext& oOut) const
{
   oOut << u16ListPosition;
   oOut << u32FirstLetter;
   oOut << u32LastLetter;
   oOut << szCodePage;
   return oOut;
}

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
fi_tcl_DapLanguageDescr::fi_tcl_DapLanguageDescr(const fi_tcl_DapLanguageDescr& coRef):fi_tclVisitableTypeBase(coRef)
{
   u16LanguageId = coRef.u16LanguageId;
   u16LanguageCode = coRef.u16LanguageCode;
   au16CodePagePos = coRef.au16CodePagePos;
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
fi_tcl_DapLanguageDescr& fi_tcl_DapLanguageDescr::operator=(const fi_tcl_DapLanguageDescr& coRef)
{
   if (this == &coRef) return *this;
   u16LanguageId = coRef.u16LanguageId;
   u16LanguageCode = coRef.u16LanguageCode;
   au16CodePagePos = coRef.au16CodePagePos;
   return *this;
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
tVoid fi_tcl_DapLanguageDescr::vDestroy()
{
   au16CodePagePos.clear();
}

tU32 fi_tcl_DapLanguageDescr::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 8+au16CodePagePos.size()*2;
}

tBool fi_tcl_DapLanguageDescr::operator==(const fi_tcl_DapLanguageDescr& rfoCmp) const
{
   tBool bResult = true;
      bResult = bResult && (u16LanguageId == rfoCmp.u16LanguageId);
      bResult = bResult && (u16LanguageCode == rfoCmp.u16LanguageCode);
      bResult = bResult && (au16CodePagePos.size() == rfoCmp.au16CodePagePos.size());
      if (bResult)
      {
         for (tU32 u32Idx = 0; bResult && (u32Idx < au16CodePagePos.size()); ++u32Idx)
            bResult = bResult && (au16CodePagePos[u32Idx] == rfoCmp.au16CodePagePos[u32Idx]);
      }
   return bResult;
}

fi_tclInContext& fi_tcl_DapLanguageDescr::oRead(fi_tclInContext& oIn)
{
   oIn >> u16LanguageId;
   oIn >> u16LanguageCode;
   {
      tU32 u32Length;
      tU32 u32Idx;
      oIn >> u32Length;
      au16CodePagePos.resize(u32Length);
      for (u32Idx = 0; u32Idx < u32Length; ++u32Idx)
      {
         oIn >> au16CodePagePos[u32Idx];
      }
   }
   return oIn;
}

fi_tclOutContext& fi_tcl_DapLanguageDescr::oWrite(fi_tclOutContext& oOut) const
{
   oOut << u16LanguageId;
   oOut << u16LanguageCode;
   oOut << (tU32)au16CodePagePos.size();
   {
      for (tU32 u32Idx = 0; u32Idx < au16CodePagePos.size(); ++u32Idx)
         oOut << au16CodePagePos[u32Idx];
   }
   return oOut;
}

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
fi_tcl_DevMediaInfo::fi_tcl_DevMediaInfo(const fi_tcl_DevMediaInfo& coRef):fi_tclVisitableTypeBase(coRef)
{
   szDevicePath = coRef.szDevicePath;
   bMediaAvailable = coRef.bMediaAvailable;
   bMediaAccessable = coRef.bMediaAccessable;
   enAccessMode = coRef.enAccessMode;
   enMediaType = coRef.enMediaType;
   bDefaultDevice = coRef.bDefaultDevice;
   enWriteProtState = coRef.enWriteProtState;
   oVirtualMediaInfoList = coRef.oVirtualMediaInfoList;
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
fi_tcl_DevMediaInfo& fi_tcl_DevMediaInfo::operator=(const fi_tcl_DevMediaInfo& coRef)
{
   if (this == &coRef) return *this;
   szDevicePath = coRef.szDevicePath;
   bMediaAvailable = coRef.bMediaAvailable;
   bMediaAccessable = coRef.bMediaAccessable;
   enAccessMode = coRef.enAccessMode;
   enMediaType = coRef.enMediaType;
   bDefaultDevice = coRef.bDefaultDevice;
   enWriteProtState = coRef.enWriteProtState;
   oVirtualMediaInfoList = coRef.oVirtualMediaInfoList;
   return *this;
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
tVoid fi_tcl_DevMediaInfo::vDestroy()
{
   szDevicePath.vDestroy();
   {
      for (tU32 u32Idx = 0; u32Idx < oVirtualMediaInfoList.size(); ++u32Idx)
         oVirtualMediaInfoList[u32Idx].vDestroy();
   }
   oVirtualMediaInfoList.clear();
}

tU32 fi_tcl_DevMediaInfo::u32GetSize(tU16 u16MajorVersion) const
{
   tU32 u32DynamicSize = 0;
   tU32 u32ListIdx;
   for (u32ListIdx = 0; u32ListIdx < oVirtualMediaInfoList.size(); ++u32ListIdx)
      u32DynamicSize += oVirtualMediaInfoList[u32ListIdx].u32GetSize(u16MajorVersion);
   return u32DynamicSize+10+szDevicePath.u32GetSize(u16MajorVersion);
}

tBool fi_tcl_DevMediaInfo::operator==(const fi_tcl_DevMediaInfo& rfoCmp) const
{
   tBool bResult = true;
      bResult = bResult && (szDevicePath == rfoCmp.szDevicePath);
      bResult = bResult && (bMediaAvailable == rfoCmp.bMediaAvailable);
      bResult = bResult && (bMediaAccessable == rfoCmp.bMediaAccessable);
      bResult = bResult && (enAccessMode == rfoCmp.enAccessMode);
      bResult = bResult && (enMediaType == rfoCmp.enMediaType);
      bResult = bResult && (bDefaultDevice == rfoCmp.bDefaultDevice);
      bResult = bResult && (enWriteProtState == rfoCmp.enWriteProtState);
      bResult = bResult && (oVirtualMediaInfoList.size() == rfoCmp.oVirtualMediaInfoList.size());
      if (bResult)
      {
         for (tU32 u32Idx = 0; bResult && (u32Idx < oVirtualMediaInfoList.size()); ++u32Idx)
            bResult = bResult && (oVirtualMediaInfoList[u32Idx] == rfoCmp.oVirtualMediaInfoList[u32Idx]);
      }
   return bResult;
}

fi_tclInContext& fi_tcl_DevMediaInfo::oRead(fi_tclInContext& oIn)
{
   oIn >> szDevicePath;
   oIn >> bMediaAvailable;
   oIn >> bMediaAccessable;
   oIn >> enAccessMode;
   oIn >> enMediaType;
   oIn >> bDefaultDevice;
   oIn >> enWriteProtState;
   {
      tU32 u32Length;
      tU32 u32Idx;
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
      for (u32Idx = 0; u32Idx < oVirtualMediaInfoList.size(); ++u32Idx)
      {
         oVirtualMediaInfoList[u32Idx].vDestroy();
      }
#endif // !VARIANT_S_FTR_ENABLE_DEEP_COPY
      oIn >> u32Length;
      oVirtualMediaInfoList.resize(u32Length);
      for (u32Idx = 0; u32Idx < u32Length; ++u32Idx)
      {
         oIn >> oVirtualMediaInfoList[u32Idx];
      }
   }
   return oIn;
}

fi_tclOutContext& fi_tcl_DevMediaInfo::oWrite(fi_tclOutContext& oOut) const
{
   oOut << szDevicePath;
   oOut << bMediaAvailable;
   oOut << bMediaAccessable;
   oOut << enAccessMode;
   oOut << enMediaType;
   oOut << bDefaultDevice;
   oOut << enWriteProtState;
   oOut << (tU32)oVirtualMediaInfoList.size();
   {
      for (tU32 u32Idx = 0; u32Idx < oVirtualMediaInfoList.size(); ++u32Idx)
         oOut << oVirtualMediaInfoList[u32Idx];
   }
   return oOut;
}

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
fi_tcl_DapMediaInfo::fi_tcl_DapMediaInfo(const fi_tcl_DapMediaInfo& coRef):fi_tclVisitableTypeBase(coRef)
{
   enAccessMode = coRef.enAccessMode;
   enMediaType = coRef.enMediaType;
   szDeviceName = coRef.szDeviceName;
   aoVirtualMediaInfo = coRef.aoVirtualMediaInfo;
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
fi_tcl_DapMediaInfo& fi_tcl_DapMediaInfo::operator=(const fi_tcl_DapMediaInfo& coRef)
{
   if (this == &coRef) return *this;
   enAccessMode = coRef.enAccessMode;
   enMediaType = coRef.enMediaType;
   szDeviceName = coRef.szDeviceName;
   aoVirtualMediaInfo = coRef.aoVirtualMediaInfo;
   return *this;
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
tVoid fi_tcl_DapMediaInfo::vDestroy()
{
   szDeviceName.vDestroy();
   {
      for (tU32 u32Idx = 0; u32Idx < aoVirtualMediaInfo.size(); ++u32Idx)
         aoVirtualMediaInfo[u32Idx].vDestroy();
   }
   aoVirtualMediaInfo.clear();
}

tU32 fi_tcl_DapMediaInfo::u32GetSize(tU16 u16MajorVersion) const
{
   tU32 u32DynamicSize = 0;
   tU32 u32ListIdx;
   for (u32ListIdx = 0; u32ListIdx < aoVirtualMediaInfo.size(); ++u32ListIdx)
      u32DynamicSize += aoVirtualMediaInfo[u32ListIdx].u32GetSize(u16MajorVersion);
   return u32DynamicSize+6+szDeviceName.u32GetSize(u16MajorVersion);
}

tBool fi_tcl_DapMediaInfo::operator==(const fi_tcl_DapMediaInfo& rfoCmp) const
{
   tBool bResult = true;
      bResult = bResult && (enAccessMode == rfoCmp.enAccessMode);
      bResult = bResult && (enMediaType == rfoCmp.enMediaType);
      bResult = bResult && (szDeviceName == rfoCmp.szDeviceName);
      bResult = bResult && (aoVirtualMediaInfo.size() == rfoCmp.aoVirtualMediaInfo.size());
      if (bResult)
      {
         for (tU32 u32Idx = 0; bResult && (u32Idx < aoVirtualMediaInfo.size()); ++u32Idx)
            bResult = bResult && (aoVirtualMediaInfo[u32Idx] == rfoCmp.aoVirtualMediaInfo[u32Idx]);
      }
   return bResult;
}

fi_tclInContext& fi_tcl_DapMediaInfo::oRead(fi_tclInContext& oIn)
{
   oIn >> enAccessMode;
   oIn >> enMediaType;
   oIn >> szDeviceName;
   {
      tU32 u32Length;
      tU32 u32Idx;
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
      for (u32Idx = 0; u32Idx < aoVirtualMediaInfo.size(); ++u32Idx)
      {
         aoVirtualMediaInfo[u32Idx].vDestroy();
      }
#endif // !VARIANT_S_FTR_ENABLE_DEEP_COPY
      oIn >> u32Length;
      aoVirtualMediaInfo.resize(u32Length);
      for (u32Idx = 0; u32Idx < u32Length; ++u32Idx)
      {
         oIn >> aoVirtualMediaInfo[u32Idx];
      }
   }
   return oIn;
}

fi_tclOutContext& fi_tcl_DapMediaInfo::oWrite(fi_tclOutContext& oOut) const
{
   oOut << enAccessMode;
   oOut << enMediaType;
   oOut << szDeviceName;
   oOut << (tU32)aoVirtualMediaInfo.size();
   {
      for (tU32 u32Idx = 0; u32Idx < aoVirtualMediaInfo.size(); ++u32Idx)
         oOut << aoVirtualMediaInfo[u32Idx];
   }
   return oOut;
}

tU32 fi_tcl_e8_DapDataType::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 1;
}

tBool fi_tcl_e8_DapDataType::operator==(const fi_tcl_e8_DapDataType& rfoCmp) const
{
   return enType == rfoCmp.enType;
}

fi_tclInContext& fi_tcl_e8_DapDataType::oRead(fi_tclInContext& oIn)
{
   tU8 u8Value;
   oIn >> u8Value;
   enType = (tenType)u8Value;
   return oIn;
}

fi_tclOutContext& fi_tcl_e8_DapDataType::oWrite(fi_tclOutContext& oOut) const
{
   return oOut.oWrite((tU8)enType);
}

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
fi_tcl_DapDataSetInfo::fi_tcl_DapDataSetInfo(const fi_tcl_DapDataSetInfo& coRef):fi_tclVisitableTypeBase(coRef)
{
   u32MediaId = coRef.u32MediaId;
   u32DatasetId = coRef.u32DatasetId;
   enDataAvailable = coRef.enDataAvailable;
   szAccessPath = coRef.szAccessPath;
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
fi_tcl_DapDataSetInfo& fi_tcl_DapDataSetInfo::operator=(const fi_tcl_DapDataSetInfo& coRef)
{
   if (this == &coRef) return *this;
   u32MediaId = coRef.u32MediaId;
   u32DatasetId = coRef.u32DatasetId;
   enDataAvailable = coRef.enDataAvailable;
   szAccessPath = coRef.szAccessPath;
   return *this;
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
tVoid fi_tcl_DapDataSetInfo::vDestroy()
{
   szAccessPath.vDestroy();
}

tU32 fi_tcl_DapDataSetInfo::u32GetSize(tU16 u16MajorVersion) const
{
   return 9+szAccessPath.u32GetSize(u16MajorVersion);
}

tBool fi_tcl_DapDataSetInfo::operator==(const fi_tcl_DapDataSetInfo& rfoCmp) const
{
   tBool bResult = true;
      bResult = bResult && (u32MediaId == rfoCmp.u32MediaId);
      bResult = bResult && (u32DatasetId == rfoCmp.u32DatasetId);
      bResult = bResult && (enDataAvailable == rfoCmp.enDataAvailable);
      bResult = bResult && (szAccessPath == rfoCmp.szAccessPath);
   return bResult;
}

fi_tclInContext& fi_tcl_DapDataSetInfo::oRead(fi_tclInContext& oIn)
{
   oIn >> u32MediaId;
   oIn >> u32DatasetId;
   oIn >> enDataAvailable;
   oIn >> szAccessPath;
   return oIn;
}

fi_tclOutContext& fi_tcl_DapDataSetInfo::oWrite(fi_tclOutContext& oOut) const
{
   oOut << u32MediaId;
   oOut << u32DatasetId;
   oOut << enDataAvailable;
   oOut << szAccessPath;
   return oOut;
}

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
fi_tcl_DapDefaultControl::fi_tcl_DapDefaultControl(const fi_tcl_DapDefaultControl& coRef):fi_tclVisitableTypeBase(coRef)
{
   u32CtrlHandle = coRef.u32CtrlHandle;
   bGetControl = coRef.bGetControl;
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
fi_tcl_DapDefaultControl& fi_tcl_DapDefaultControl::operator=(const fi_tcl_DapDefaultControl& coRef)
{
   if (this == &coRef) return *this;
   u32CtrlHandle = coRef.u32CtrlHandle;
   bGetControl = coRef.bGetControl;
   return *this;
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
tU32 fi_tcl_DapDefaultControl::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 5;
}

tBool fi_tcl_DapDefaultControl::operator==(const fi_tcl_DapDefaultControl& rfoCmp) const
{
   tBool bResult = true;
      bResult = bResult && (u32CtrlHandle == rfoCmp.u32CtrlHandle);
      bResult = bResult && (bGetControl == rfoCmp.bGetControl);
   return bResult;
}

fi_tclInContext& fi_tcl_DapDefaultControl::oRead(fi_tclInContext& oIn)
{
   oIn >> u32CtrlHandle;
   oIn >> bGetControl;
   return oIn;
}

fi_tclOutContext& fi_tcl_DapDefaultControl::oWrite(fi_tclOutContext& oOut) const
{
   oOut << u32CtrlHandle;
   oOut << bGetControl;
   return oOut;
}

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
fi_tcl_DapRegionMetaInfo::fi_tcl_DapRegionMetaInfo(const fi_tcl_DapRegionMetaInfo& coRef):fi_tclVisitableTypeBase(coRef)
{
   u16RegionId = coRef.u16RegionId;
   szRegionCode = coRef.szRegionCode;
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
fi_tcl_DapRegionMetaInfo& fi_tcl_DapRegionMetaInfo::operator=(const fi_tcl_DapRegionMetaInfo& coRef)
{
   if (this == &coRef) return *this;
   u16RegionId = coRef.u16RegionId;
   szRegionCode = coRef.szRegionCode;
   return *this;
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
tVoid fi_tcl_DapRegionMetaInfo::vDestroy()
{
   szRegionCode.vDestroy();
}

tU32 fi_tcl_DapRegionMetaInfo::u32GetSize(tU16 u16MajorVersion) const
{
   return 2+szRegionCode.u32GetSize(u16MajorVersion);
}

tBool fi_tcl_DapRegionMetaInfo::operator==(const fi_tcl_DapRegionMetaInfo& rfoCmp) const
{
   tBool bResult = true;
      bResult = bResult && (u16RegionId == rfoCmp.u16RegionId);
      bResult = bResult && (szRegionCode == rfoCmp.szRegionCode);
   return bResult;
}

fi_tclInContext& fi_tcl_DapRegionMetaInfo::oRead(fi_tclInContext& oIn)
{
   oIn >> u16RegionId;
   oIn >> szRegionCode;
   return oIn;
}

fi_tclOutContext& fi_tcl_DapRegionMetaInfo::oWrite(fi_tclOutContext& oOut) const
{
   oOut << u16RegionId;
   oOut << szRegionCode;
   return oOut;
}

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
fi_tcl_DapProfileMetaInfo::fi_tcl_DapProfileMetaInfo(const fi_tcl_DapProfileMetaInfo& coRef):fi_tclVisitableTypeBase(coRef)
{
   u8ProfileID = coRef.u8ProfileID;
   szProfile = coRef.szProfile;
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
fi_tcl_DapProfileMetaInfo& fi_tcl_DapProfileMetaInfo::operator=(const fi_tcl_DapProfileMetaInfo& coRef)
{
   if (this == &coRef) return *this;
   u8ProfileID = coRef.u8ProfileID;
   szProfile = coRef.szProfile;
   return *this;
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
tVoid fi_tcl_DapProfileMetaInfo::vDestroy()
{
   szProfile.vDestroy();
}

tU32 fi_tcl_DapProfileMetaInfo::u32GetSize(tU16 u16MajorVersion) const
{
   return 1+szProfile.u32GetSize(u16MajorVersion);
}

tBool fi_tcl_DapProfileMetaInfo::operator==(const fi_tcl_DapProfileMetaInfo& rfoCmp) const
{
   tBool bResult = true;
      bResult = bResult && (u8ProfileID == rfoCmp.u8ProfileID);
      bResult = bResult && (szProfile == rfoCmp.szProfile);
   return bResult;
}

fi_tclInContext& fi_tcl_DapProfileMetaInfo::oRead(fi_tclInContext& oIn)
{
   oIn >> u8ProfileID;
   oIn >> szProfile;
   return oIn;
}

fi_tclOutContext& fi_tcl_DapProfileMetaInfo::oWrite(fi_tclOutContext& oOut) const
{
   oOut << u8ProfileID;
   oOut << szProfile;
   return oOut;
}

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
fi_tcl_DapRegionDescription::fi_tcl_DapRegionDescription(const fi_tcl_DapRegionDescription& coRef):fi_tclVisitableTypeBase(coRef)
{
   u16RegionId = coRef.u16RegionId;
   szDevice = coRef.szDevice;
   u32MediumId = coRef.u32MediumId;
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
fi_tcl_DapRegionDescription& fi_tcl_DapRegionDescription::operator=(const fi_tcl_DapRegionDescription& coRef)
{
   if (this == &coRef) return *this;
   u16RegionId = coRef.u16RegionId;
   szDevice = coRef.szDevice;
   u32MediumId = coRef.u32MediumId;
   return *this;
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
tVoid fi_tcl_DapRegionDescription::vDestroy()
{
   szDevice.vDestroy();
}

tU32 fi_tcl_DapRegionDescription::u32GetSize(tU16 u16MajorVersion) const
{
   return 6+szDevice.u32GetSize(u16MajorVersion);
}

tBool fi_tcl_DapRegionDescription::operator==(const fi_tcl_DapRegionDescription& rfoCmp) const
{
   tBool bResult = true;
      bResult = bResult && (u16RegionId == rfoCmp.u16RegionId);
      bResult = bResult && (szDevice == rfoCmp.szDevice);
      bResult = bResult && (u32MediumId == rfoCmp.u32MediumId);
   return bResult;
}

fi_tclInContext& fi_tcl_DapRegionDescription::oRead(fi_tclInContext& oIn)
{
   oIn >> u16RegionId;
   oIn >> szDevice;
   oIn >> u32MediumId;
   return oIn;
}

fi_tclOutContext& fi_tcl_DapRegionDescription::oWrite(fi_tclOutContext& oOut) const
{
   oOut << u16RegionId;
   oOut << szDevice;
   oOut << u32MediumId;
   return oOut;
}

tU32 fi_tcl_b8_StructureType::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 1;
}

tBool fi_tcl_b8_StructureType::operator==(const fi_tcl_b8_StructureType& rfoCmp) const
{
   return u8Value == rfoCmp.u8Value;
}

fi_tclInContext& fi_tcl_b8_StructureType::oRead(fi_tclInContext& oIn)
{
   return oIn >> u8Value;
}

fi_tclOutContext& fi_tcl_b8_StructureType::oWrite(fi_tclOutContext& oOut) const
{
   return oOut << u8Value;
}

tU32 fi_tcl_e32_RNWExtensionType::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 1;
}

tBool fi_tcl_e32_RNWExtensionType::operator==(const fi_tcl_e32_RNWExtensionType& rfoCmp) const
{
   return enType == rfoCmp.enType;
}

fi_tclInContext& fi_tcl_e32_RNWExtensionType::oRead(fi_tclInContext& oIn)
{
   tU8 u8Value;
   oIn >> u8Value;
   enType = (tenType)u8Value;
   return oIn;
}

fi_tclOutContext& fi_tcl_e32_RNWExtensionType::oWrite(fi_tclOutContext& oOut) const
{
   return oOut.oWrite((tU8)enType);
}

tU32 fi_tcl_e8_RNWDataUsageState::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 1;
}

tBool fi_tcl_e8_RNWDataUsageState::operator==(const fi_tcl_e8_RNWDataUsageState& rfoCmp) const
{
   return enType == rfoCmp.enType;
}

fi_tclInContext& fi_tcl_e8_RNWDataUsageState::oRead(fi_tclInContext& oIn)
{
   tU8 u8Value;
   oIn >> u8Value;
   enType = (tenType)u8Value;
   return oIn;
}

fi_tclOutContext& fi_tcl_e8_RNWDataUsageState::oWrite(fi_tclOutContext& oOut) const
{
   return oOut.oWrite((tU8)enType);
}

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
fi_tcl_MemPos::fi_tcl_MemPos(const fi_tcl_MemPos& coRef):fi_tclVisitableTypeBase(coRef)
{
   u32Offset = coRef.u32Offset;
   u32Length = coRef.u32Length;
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
fi_tcl_MemPos& fi_tcl_MemPos::operator=(const fi_tcl_MemPos& coRef)
{
   if (this == &coRef) return *this;
   u32Offset = coRef.u32Offset;
   u32Length = coRef.u32Length;
   return *this;
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
tU32 fi_tcl_MemPos::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 8;
}

tBool fi_tcl_MemPos::operator==(const fi_tcl_MemPos& rfoCmp) const
{
   tBool bResult = true;
      bResult = bResult && (u32Offset == rfoCmp.u32Offset);
      bResult = bResult && (u32Length == rfoCmp.u32Length);
   return bResult;
}

fi_tclInContext& fi_tcl_MemPos::oRead(fi_tclInContext& oIn)
{
   oIn >> u32Offset;
   oIn >> u32Length;
   return oIn;
}

fi_tclOutContext& fi_tcl_MemPos::oWrite(fi_tclOutContext& oOut) const
{
   oOut << u32Offset;
   oOut << u32Length;
   return oOut;
}

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
fi_tcl_StructureReference::fi_tcl_StructureReference(const fi_tcl_StructureReference& coRef):fi_tclVisitableTypeBase(coRef)
{
   oClusterPos = coRef.oClusterPos;
   oExpAnnPos = coRef.oExpAnnPos;
   oExtClPos = coRef.oExtClPos;
   oAreaPos = coRef.oAreaPos;
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
fi_tcl_StructureReference& fi_tcl_StructureReference::operator=(const fi_tcl_StructureReference& coRef)
{
   if (this == &coRef) return *this;
   oClusterPos = coRef.oClusterPos;
   oExpAnnPos = coRef.oExpAnnPos;
   oExtClPos = coRef.oExtClPos;
   oAreaPos = coRef.oAreaPos;
   return *this;
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
tVoid fi_tcl_StructureReference::vDestroy()
{
   oClusterPos.vDestroy(); 
   oExpAnnPos.vDestroy(); 
   oExtClPos.vDestroy(); 
   oAreaPos.vDestroy(); 
}

tU32 fi_tcl_StructureReference::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 32;
}

tBool fi_tcl_StructureReference::operator==(const fi_tcl_StructureReference& rfoCmp) const
{
   tBool bResult = true;
      bResult = bResult && (oClusterPos == rfoCmp.oClusterPos);
      bResult = bResult && (oExpAnnPos == rfoCmp.oExpAnnPos);
      bResult = bResult && (oExtClPos == rfoCmp.oExtClPos);
      bResult = bResult && (oAreaPos == rfoCmp.oAreaPos);
   return bResult;
}

fi_tclInContext& fi_tcl_StructureReference::oRead(fi_tclInContext& oIn)
{
   oIn >> oClusterPos;
   oIn >> oExpAnnPos;
   oIn >> oExtClPos;
   oIn >> oAreaPos;
   return oIn;
}

fi_tclOutContext& fi_tcl_StructureReference::oWrite(fi_tclOutContext& oOut) const
{
   oOut << oClusterPos;
   oOut << oExpAnnPos;
   oOut << oExtClPos;
   oOut << oAreaPos;
   return oOut;
}

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
fi_tcl_NavClusterId::fi_tcl_NavClusterId(const fi_tcl_NavClusterId& coRef):fi_tclVisitableTypeBase(coRef)
{
   FileOffset = coRef.FileOffset;
   ClusterLength = coRef.ClusterLength;
   FileId = coRef.FileId;
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
fi_tcl_NavClusterId& fi_tcl_NavClusterId::operator=(const fi_tcl_NavClusterId& coRef)
{
   if (this == &coRef) return *this;
   FileOffset = coRef.FileOffset;
   ClusterLength = coRef.ClusterLength;
   FileId = coRef.FileId;
   return *this;
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
tU32 fi_tcl_NavClusterId::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 8;
}

tBool fi_tcl_NavClusterId::operator==(const fi_tcl_NavClusterId& rfoCmp) const
{
   tBool bResult = true;
      bResult = bResult && (FileOffset == rfoCmp.FileOffset);
      bResult = bResult && (ClusterLength == rfoCmp.ClusterLength);
      bResult = bResult && (FileId == rfoCmp.FileId);
   return bResult;
}

fi_tclInContext& fi_tcl_NavClusterId::oRead(fi_tclInContext& oIn)
{
   oIn >> FileOffset;
   oIn >> ClusterLength;
   oIn >> FileId;
   return oIn;
}

fi_tclOutContext& fi_tcl_NavClusterId::oWrite(fi_tclOutContext& oOut) const
{
   oOut << FileOffset;
   oOut << ClusterLength;
   oOut << FileId;
   return oOut;
}

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
fi_tcl_ClusterResultInfo::fi_tcl_ClusterResultInfo(const fi_tcl_ClusterResultInfo& coRef):fi_tclVisitableTypeBase(coRef)
{
   oClusterId = coRef.oClusterId;
   oDataRef = coRef.oDataRef;
   u16ErrorCode = coRef.u16ErrorCode;
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
fi_tcl_ClusterResultInfo& fi_tcl_ClusterResultInfo::operator=(const fi_tcl_ClusterResultInfo& coRef)
{
   if (this == &coRef) return *this;
   oClusterId = coRef.oClusterId;
   oDataRef = coRef.oDataRef;
   u16ErrorCode = coRef.u16ErrorCode;
   return *this;
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
tVoid fi_tcl_ClusterResultInfo::vDestroy()
{
   oClusterId.vDestroy(); 
   oDataRef.vDestroy(); 
}

tU32 fi_tcl_ClusterResultInfo::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 42;
}

tBool fi_tcl_ClusterResultInfo::operator==(const fi_tcl_ClusterResultInfo& rfoCmp) const
{
   tBool bResult = true;
      bResult = bResult && (oClusterId == rfoCmp.oClusterId);
      bResult = bResult && (oDataRef == rfoCmp.oDataRef);
      bResult = bResult && (u16ErrorCode == rfoCmp.u16ErrorCode);
   return bResult;
}

fi_tclInContext& fi_tcl_ClusterResultInfo::oRead(fi_tclInContext& oIn)
{
   oIn >> oClusterId;
   oIn >> oDataRef;
   oIn >> u16ErrorCode;
   return oIn;
}

fi_tclOutContext& fi_tcl_ClusterResultInfo::oWrite(fi_tclOutContext& oOut) const
{
   oOut << oClusterId;
   oOut << oDataRef;
   oOut << u16ErrorCode;
   return oOut;
}

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
fi_tcl_RNWDataStorageInfo::fi_tcl_RNWDataStorageInfo(const fi_tcl_RNWDataStorageInfo& coRef):fi_tclVisitableTypeBase(coRef)
{
   oClusterId = coRef.oClusterId;
   UsageState = coRef.UsageState;
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
fi_tcl_RNWDataStorageInfo& fi_tcl_RNWDataStorageInfo::operator=(const fi_tcl_RNWDataStorageInfo& coRef)
{
   if (this == &coRef) return *this;
   oClusterId = coRef.oClusterId;
   UsageState = coRef.UsageState;
   return *this;
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
tVoid fi_tcl_RNWDataStorageInfo::vDestroy()
{
   oClusterId.vDestroy(); 
}

tU32 fi_tcl_RNWDataStorageInfo::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 9;
}

tBool fi_tcl_RNWDataStorageInfo::operator==(const fi_tcl_RNWDataStorageInfo& rfoCmp) const
{
   tBool bResult = true;
      bResult = bResult && (oClusterId == rfoCmp.oClusterId);
      bResult = bResult && (UsageState == rfoCmp.UsageState);
   return bResult;
}

fi_tclInContext& fi_tcl_RNWDataStorageInfo::oRead(fi_tclInContext& oIn)
{
   oIn >> oClusterId;
   oIn >> UsageState;
   return oIn;
}

fi_tclOutContext& fi_tcl_RNWDataStorageInfo::oWrite(fi_tclOutContext& oOut) const
{
   oOut << oClusterId;
   oOut << UsageState;
   return oOut;
}

tU32 fi_tcl_e8_LocClass::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 1;
}

tBool fi_tcl_e8_LocClass::operator==(const fi_tcl_e8_LocClass& rfoCmp) const
{
   return enType == rfoCmp.enType;
}

fi_tclInContext& fi_tcl_e8_LocClass::oRead(fi_tclInContext& oIn)
{
   tU8 u8Value;
   oIn >> u8Value;
   enType = (tenType)u8Value;
   return oIn;
}

fi_tclOutContext& fi_tcl_e8_LocClass::oWrite(fi_tclOutContext& oOut) const
{
   return oOut.oWrite((tU8)enType);
}

tU32 fi_tcl_e8_CarriageWay::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 1;
}

tBool fi_tcl_e8_CarriageWay::operator==(const fi_tcl_e8_CarriageWay& rfoCmp) const
{
   return enType == rfoCmp.enType;
}

fi_tclInContext& fi_tcl_e8_CarriageWay::oRead(fi_tclInContext& oIn)
{
   tU8 u8Value;
   oIn >> u8Value;
   enType = (tenType)u8Value;
   return oIn;
}

fi_tclOutContext& fi_tcl_e8_CarriageWay::oWrite(fi_tclOutContext& oOut) const
{
   return oOut.oWrite((tU8)enType);
}

tU32 fi_tcl_e8_TrafficFlow::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 1;
}

tBool fi_tcl_e8_TrafficFlow::operator==(const fi_tcl_e8_TrafficFlow& rfoCmp) const
{
   return enType == rfoCmp.enType;
}

fi_tclInContext& fi_tcl_e8_TrafficFlow::oRead(fi_tclInContext& oIn)
{
   tU8 u8Value;
   oIn >> u8Value;
   enType = (tenType)u8Value;
   return oIn;
}

fi_tclOutContext& fi_tcl_e8_TrafficFlow::oWrite(fi_tclOutContext& oOut) const
{
   return oOut.oWrite((tU8)enType);
}

tU32 fi_tcl_e8_FollowDirection::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 1;
}

tBool fi_tcl_e8_FollowDirection::operator==(const fi_tcl_e8_FollowDirection& rfoCmp) const
{
   return enType == rfoCmp.enType;
}

fi_tclInContext& fi_tcl_e8_FollowDirection::oRead(fi_tclInContext& oIn)
{
   tU8 u8Value;
   oIn >> u8Value;
   enType = (tenType)u8Value;
   return oIn;
}

fi_tclOutContext& fi_tcl_e8_FollowDirection::oWrite(fi_tclOutContext& oOut) const
{
   return oOut.oWrite((tU8)enType);
}

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
fi_tcl_LocTableIdent::fi_tcl_LocTableIdent(const fi_tcl_LocTableIdent& coRef):fi_tclVisitableTypeBase(coRef)
{
   u8CountryCode = coRef.u8CountryCode;
   u8TableNumber = coRef.u8TableNumber;
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
fi_tcl_LocTableIdent& fi_tcl_LocTableIdent::operator=(const fi_tcl_LocTableIdent& coRef)
{
   if (this == &coRef) return *this;
   u8CountryCode = coRef.u8CountryCode;
   u8TableNumber = coRef.u8TableNumber;
   return *this;
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
tU32 fi_tcl_LocTableIdent::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 2;
}

tBool fi_tcl_LocTableIdent::operator==(const fi_tcl_LocTableIdent& rfoCmp) const
{
   tBool bResult = true;
      bResult = bResult && (u8CountryCode == rfoCmp.u8CountryCode);
      bResult = bResult && (u8TableNumber == rfoCmp.u8TableNumber);
   return bResult;
}

fi_tclInContext& fi_tcl_LocTableIdent::oRead(fi_tclInContext& oIn)
{
   oIn >> u8CountryCode;
   oIn >> u8TableNumber;
   return oIn;
}

fi_tclOutContext& fi_tcl_LocTableIdent::oWrite(fi_tclOutContext& oOut) const
{
   oOut << u8CountryCode;
   oOut << u8TableNumber;
   return oOut;
}

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
fi_tcl_Outline::fi_tcl_Outline(const fi_tcl_Outline& coRef):fi_tclVisitableTypeBase(coRef)
{
   Points = coRef.Points;
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
fi_tcl_Outline& fi_tcl_Outline::operator=(const fi_tcl_Outline& coRef)
{
   if (this == &coRef) return *this;
   Points = coRef.Points;
   return *this;
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
tVoid fi_tcl_Outline::vDestroy()
{
   {
      for (tU32 u32Idx = 0; u32Idx < Points.size(); ++u32Idx)
         Points[u32Idx].vDestroy();
   }
   Points.clear();
}

tU32 fi_tcl_Outline::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 4+Points.size()*8;
}

tBool fi_tcl_Outline::operator==(const fi_tcl_Outline& rfoCmp) const
{
   tBool bResult = true;
      bResult = bResult && (Points.size() == rfoCmp.Points.size());
      if (bResult)
      {
         for (tU32 u32Idx = 0; bResult && (u32Idx < Points.size()); ++u32Idx)
            bResult = bResult && (Points[u32Idx] == rfoCmp.Points[u32Idx]);
      }
   return bResult;
}

fi_tclInContext& fi_tcl_Outline::oRead(fi_tclInContext& oIn)
{
   {
      tU32 u32Length;
      tU32 u32Idx;
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
      for (u32Idx = 0; u32Idx < Points.size(); ++u32Idx)
      {
         Points[u32Idx].vDestroy();
      }
#endif // !VARIANT_S_FTR_ENABLE_DEEP_COPY
      oIn >> u32Length;
      Points.resize(u32Length);
      for (u32Idx = 0; u32Idx < u32Length; ++u32Idx)
      {
         oIn >> Points[u32Idx];
      }
   }
   return oIn;
}

fi_tclOutContext& fi_tcl_Outline::oWrite(fi_tclOutContext& oOut) const
{
   oOut << (tU32)Points.size();
   {
      for (tU32 u32Idx = 0; u32Idx < Points.size(); ++u32Idx)
         oOut << Points[u32Idx];
   }
   return oOut;
}

tU32 fi_tcl_e16_ISOCountryCode::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 2;
}

tBool fi_tcl_e16_ISOCountryCode::operator==(const fi_tcl_e16_ISOCountryCode& rfoCmp) const
{
   return enType == rfoCmp.enType;
}

fi_tclInContext& fi_tcl_e16_ISOCountryCode::oRead(fi_tclInContext& oIn)
{
   tU16 u16Value;
   oIn >> u16Value;
   enType = (tenType)u16Value;
   return oIn;
}

fi_tclOutContext& fi_tcl_e16_ISOCountryCode::oWrite(fi_tclOutContext& oOut) const
{
   return oOut.oWrite((tU16)enType);
}

tU32 fi_tcl_e16_ISOLanguageCode::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 2;
}

tBool fi_tcl_e16_ISOLanguageCode::operator==(const fi_tcl_e16_ISOLanguageCode& rfoCmp) const
{
   return enType == rfoCmp.enType;
}

fi_tclInContext& fi_tcl_e16_ISOLanguageCode::oRead(fi_tclInContext& oIn)
{
   tU16 u16Value;
   oIn >> u16Value;
   enType = (tenType)u16Value;
   return oIn;
}

fi_tclOutContext& fi_tcl_e16_ISOLanguageCode::oWrite(fi_tclOutContext& oOut) const
{
   return oOut.oWrite((tU16)enType);
}

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
fi_tcl_PrefixElem::fi_tcl_PrefixElem(const fi_tcl_PrefixElem& coRef):fi_tclVisitableTypeBase(coRef)
{
   u8Priority = coRef.u8Priority;
   u16Status = coRef.u16Status;
   u8NumberHierarchy = coRef.u8NumberHierarchy;
   u32StateCode = coRef.u32StateCode;
   bVoice = coRef.bVoice;
   pcRoadPrefix = coRef.pcRoadPrefix;
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
fi_tcl_PrefixElem& fi_tcl_PrefixElem::operator=(const fi_tcl_PrefixElem& coRef)
{
   if (this == &coRef) return *this;
   u8Priority = coRef.u8Priority;
   u16Status = coRef.u16Status;
   u8NumberHierarchy = coRef.u8NumberHierarchy;
   u32StateCode = coRef.u32StateCode;
   bVoice = coRef.bVoice;
   pcRoadPrefix = coRef.pcRoadPrefix;
   return *this;
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
tVoid fi_tcl_PrefixElem::vDestroy()
{
   pcRoadPrefix.vDestroy();
}

tU32 fi_tcl_PrefixElem::u32GetSize(tU16 u16MajorVersion) const
{
   tU32 u32DynamicSize = 0;
   if (4 <= u16MajorVersion)
   {
      u32DynamicSize += 2;
   }
   if (4 <= u16MajorVersion)
   {
      u32DynamicSize += 1;
   }
   if (4 <= u16MajorVersion)
   {
      u32DynamicSize += 4;
   }
   if (u16MajorVersion <= 3)
   {
      u32DynamicSize += 1;
   }
   return u32DynamicSize+1+pcRoadPrefix.u32GetSize(u16MajorVersion);
}

tBool fi_tcl_PrefixElem::operator==(const fi_tcl_PrefixElem& rfoCmp) const
{
   tBool bResult = true;
      bResult = bResult && (u8Priority == rfoCmp.u8Priority);
      bResult = bResult && (u16Status == rfoCmp.u16Status);
      bResult = bResult && (u8NumberHierarchy == rfoCmp.u8NumberHierarchy);
      bResult = bResult && (u32StateCode == rfoCmp.u32StateCode);
      bResult = bResult && (bVoice == rfoCmp.bVoice);
      bResult = bResult && (pcRoadPrefix == rfoCmp.pcRoadPrefix);
   return bResult;
}

fi_tclInContext& fi_tcl_PrefixElem::oRead(fi_tclInContext& oIn)
{
   oIn >> u8Priority;
   if (4 <= oIn.u16GetMajorVersion())
   {
      oIn >> u16Status;
   }
   if (4 <= oIn.u16GetMajorVersion())
   {
      oIn >> u8NumberHierarchy;
   }
   if (4 <= oIn.u16GetMajorVersion())
   {
      oIn >> u32StateCode;
   }
   if (oIn.u16GetMajorVersion() <= 3)
   {
      oIn >> bVoice;
   }
   oIn >> pcRoadPrefix;
   return oIn;
}

fi_tclOutContext& fi_tcl_PrefixElem::oWrite(fi_tclOutContext& oOut) const
{
   oOut << u8Priority;
   if (4 <= oOut.u16GetMajorVersion())
   {
      oOut << u16Status;
   }
   if (4 <= oOut.u16GetMajorVersion())
   {
      oOut << u8NumberHierarchy;
   }
   if (4 <= oOut.u16GetMajorVersion())
   {
      oOut << u32StateCode;
   }
   if (oOut.u16GetMajorVersion() <= 3)
   {
      oOut << bVoice;
   }
   oOut << pcRoadPrefix;
   return oOut;
}

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
fi_tcl_PrefixTable::fi_tcl_PrefixTable(const fi_tcl_PrefixTable& coRef):fi_tclVisitableTypeBase(coRef)
{
   oTableIdent = coRef.oTableIdent;
   u32StartIndex = coRef.u32StartIndex;
   u32NumberOfPrefixes = coRef.u32NumberOfPrefixes;
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
fi_tcl_PrefixTable& fi_tcl_PrefixTable::operator=(const fi_tcl_PrefixTable& coRef)
{
   if (this == &coRef) return *this;
   oTableIdent = coRef.oTableIdent;
   u32StartIndex = coRef.u32StartIndex;
   u32NumberOfPrefixes = coRef.u32NumberOfPrefixes;
   return *this;
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
tVoid fi_tcl_PrefixTable::vDestroy()
{
   oTableIdent.vDestroy(); 
}

tU32 fi_tcl_PrefixTable::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 10;
}

tBool fi_tcl_PrefixTable::operator==(const fi_tcl_PrefixTable& rfoCmp) const
{
   tBool bResult = true;
      bResult = bResult && (oTableIdent == rfoCmp.oTableIdent);
      bResult = bResult && (u32StartIndex == rfoCmp.u32StartIndex);
      bResult = bResult && (u32NumberOfPrefixes == rfoCmp.u32NumberOfPrefixes);
   return bResult;
}

fi_tclInContext& fi_tcl_PrefixTable::oRead(fi_tclInContext& oIn)
{
   oIn >> oTableIdent;
   oIn >> u32StartIndex;
   oIn >> u32NumberOfPrefixes;
   return oIn;
}

fi_tclOutContext& fi_tcl_PrefixTable::oWrite(fi_tclOutContext& oOut) const
{
   oOut << oTableIdent;
   oOut << u32StartIndex;
   oOut << u32NumberOfPrefixes;
   return oOut;
}

tU32 fi_tcl_e8_DapPrioritaet::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 1;
}

tBool fi_tcl_e8_DapPrioritaet::operator==(const fi_tcl_e8_DapPrioritaet& rfoCmp) const
{
   return enType == rfoCmp.enType;
}

fi_tclInContext& fi_tcl_e8_DapPrioritaet::oRead(fi_tclInContext& oIn)
{
   tU8 u8Value;
   oIn >> u8Value;
   enType = (tenType)u8Value;
   return oIn;
}

fi_tclOutContext& fi_tcl_e8_DapPrioritaet::oWrite(fi_tclOutContext& oOut) const
{
   return oOut.oWrite((tU8)enType);
}

tU32 fi_tcl_e8_DapOrderType::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 1;
}

tBool fi_tcl_e8_DapOrderType::operator==(const fi_tcl_e8_DapOrderType& rfoCmp) const
{
   return enType == rfoCmp.enType;
}

fi_tclInContext& fi_tcl_e8_DapOrderType::oRead(fi_tclInContext& oIn)
{
   tU8 u8Value;
   oIn >> u8Value;
   enType = (tenType)u8Value;
   return oIn;
}

fi_tclOutContext& fi_tcl_e8_DapOrderType::oWrite(fi_tclOutContext& oOut) const
{
   return oOut.oWrite((tU8)enType);
}

tU32 fi_tcl_u32_DapContainerSize::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 4;
}

tBool fi_tcl_u32_DapContainerSize::operator==(const fi_tcl_u32_DapContainerSize& rfoCmp) const
{
   return u32Value == rfoCmp.u32Value;
}

fi_tclInContext& fi_tcl_u32_DapContainerSize::oRead(fi_tclInContext& oIn)
{
   return oIn >> u32Value;
}

fi_tclOutContext& fi_tcl_u32_DapContainerSize::oWrite(fi_tclOutContext& oOut) const
{
   return oOut << u32Value;
}

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
fi_tcl_DapDataTypeInfo::fi_tcl_DapDataTypeInfo(const fi_tcl_DapDataTypeInfo& coRef):fi_tclVisitableTypeBase(coRef)
{
   szDevice = coRef.szDevice;
   szAccessPath = coRef.szAccessPath;
   enDataType = coRef.enDataType;
   enDataAvailablility = coRef.enDataAvailablility;
   u32MediumId = coRef.u32MediumId;
   u32DatasetId = coRef.u32DatasetId;
   u32DataBaseId = coRef.u32DataBaseId;
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
fi_tcl_DapDataTypeInfo& fi_tcl_DapDataTypeInfo::operator=(const fi_tcl_DapDataTypeInfo& coRef)
{
   if (this == &coRef) return *this;
   szDevice = coRef.szDevice;
   szAccessPath = coRef.szAccessPath;
   enDataType = coRef.enDataType;
   enDataAvailablility = coRef.enDataAvailablility;
   u32MediumId = coRef.u32MediumId;
   u32DatasetId = coRef.u32DatasetId;
   u32DataBaseId = coRef.u32DataBaseId;
   return *this;
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
tVoid fi_tcl_DapDataTypeInfo::vDestroy()
{
   szDevice.vDestroy();
   szAccessPath.vDestroy();
}

tU32 fi_tcl_DapDataTypeInfo::u32GetSize(tU16 u16MajorVersion) const
{
   return 14+szDevice.u32GetSize(u16MajorVersion)+szAccessPath.u32GetSize(u16MajorVersion);
}

tBool fi_tcl_DapDataTypeInfo::operator==(const fi_tcl_DapDataTypeInfo& rfoCmp) const
{
   tBool bResult = true;
      bResult = bResult && (szDevice == rfoCmp.szDevice);
      bResult = bResult && (szAccessPath == rfoCmp.szAccessPath);
      bResult = bResult && (enDataType == rfoCmp.enDataType);
      bResult = bResult && (enDataAvailablility == rfoCmp.enDataAvailablility);
      bResult = bResult && (u32MediumId == rfoCmp.u32MediumId);
      bResult = bResult && (u32DatasetId == rfoCmp.u32DatasetId);
      bResult = bResult && (u32DataBaseId == rfoCmp.u32DataBaseId);
   return bResult;
}

fi_tclInContext& fi_tcl_DapDataTypeInfo::oRead(fi_tclInContext& oIn)
{
   oIn >> szDevice;
   oIn >> szAccessPath;
   oIn >> enDataType;
   oIn >> enDataAvailablility;
   oIn >> u32MediumId;
   oIn >> u32DatasetId;
   oIn >> u32DataBaseId;
   return oIn;
}

fi_tclOutContext& fi_tcl_DapDataTypeInfo::oWrite(fi_tclOutContext& oOut) const
{
   oOut << szDevice;
   oOut << szAccessPath;
   oOut << enDataType;
   oOut << enDataAvailablility;
   oOut << u32MediumId;
   oOut << u32DatasetId;
   oOut << u32DataBaseId;
   return oOut;
}

tU32 fi_tcl_u32_DataSpace::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 4;
}

tBool fi_tcl_u32_DataSpace::operator==(const fi_tcl_u32_DataSpace& rfoCmp) const
{
   return u32Value == rfoCmp.u32Value;
}

fi_tclInContext& fi_tcl_u32_DataSpace::oRead(fi_tclInContext& oIn)
{
   return oIn >> u32Value;
}

fi_tclOutContext& fi_tcl_u32_DataSpace::oWrite(fi_tclOutContext& oOut) const
{
   return oOut << u32Value;
}

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
fi_tcl_DapDataInfo::fi_tcl_DapDataInfo(const fi_tcl_DapDataInfo& coRef):fi_tclVisitableTypeBase(coRef)
{
   enDataType = coRef.enDataType;
   enDataAvailable = coRef.enDataAvailable;
   u32MediaId = coRef.u32MediaId;
   u32DatasetId = coRef.u32DatasetId;
   u32DataBaseId = coRef.u32DataBaseId;
   szAccessPath = coRef.szAccessPath;
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
fi_tcl_DapDataInfo& fi_tcl_DapDataInfo::operator=(const fi_tcl_DapDataInfo& coRef)
{
   if (this == &coRef) return *this;
   enDataType = coRef.enDataType;
   enDataAvailable = coRef.enDataAvailable;
   u32MediaId = coRef.u32MediaId;
   u32DatasetId = coRef.u32DatasetId;
   u32DataBaseId = coRef.u32DataBaseId;
   szAccessPath = coRef.szAccessPath;
   return *this;
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
tVoid fi_tcl_DapDataInfo::vDestroy()
{
   szAccessPath.vDestroy();
}

tU32 fi_tcl_DapDataInfo::u32GetSize(tU16 u16MajorVersion) const
{
   return 14+szAccessPath.u32GetSize(u16MajorVersion);
}

tBool fi_tcl_DapDataInfo::operator==(const fi_tcl_DapDataInfo& rfoCmp) const
{
   tBool bResult = true;
      bResult = bResult && (enDataType == rfoCmp.enDataType);
      bResult = bResult && (enDataAvailable == rfoCmp.enDataAvailable);
      bResult = bResult && (u32MediaId == rfoCmp.u32MediaId);
      bResult = bResult && (u32DatasetId == rfoCmp.u32DatasetId);
      bResult = bResult && (u32DataBaseId == rfoCmp.u32DataBaseId);
      bResult = bResult && (szAccessPath == rfoCmp.szAccessPath);
   return bResult;
}

fi_tclInContext& fi_tcl_DapDataInfo::oRead(fi_tclInContext& oIn)
{
   oIn >> enDataType;
   oIn >> enDataAvailable;
   oIn >> u32MediaId;
   oIn >> u32DatasetId;
   oIn >> u32DataBaseId;
   oIn >> szAccessPath;
   return oIn;
}

fi_tclOutContext& fi_tcl_DapDataInfo::oWrite(fi_tclOutContext& oOut) const
{
   oOut << enDataType;
   oOut << enDataAvailable;
   oOut << u32MediaId;
   oOut << u32DatasetId;
   oOut << u32DataBaseId;
   oOut << szAccessPath;
   return oOut;
}

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
fi_tcl_ClusterStartInfo::fi_tcl_ClusterStartInfo(const fi_tcl_ClusterStartInfo& coRef):fi_tclVisitableTypeBase(coRef)
{
   oClusterId = coRef.oClusterId;
   eType = coRef.eType;
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
fi_tcl_ClusterStartInfo& fi_tcl_ClusterStartInfo::operator=(const fi_tcl_ClusterStartInfo& coRef)
{
   if (this == &coRef) return *this;
   oClusterId = coRef.oClusterId;
   eType = coRef.eType;
   return *this;
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
tVoid fi_tcl_ClusterStartInfo::vDestroy()
{
   oClusterId.vDestroy(); 
}

tU32 fi_tcl_ClusterStartInfo::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 9;
}

tBool fi_tcl_ClusterStartInfo::operator==(const fi_tcl_ClusterStartInfo& rfoCmp) const
{
   tBool bResult = true;
      bResult = bResult && (oClusterId == rfoCmp.oClusterId);
      bResult = bResult && (eType == rfoCmp.eType);
   return bResult;
}

fi_tclInContext& fi_tcl_ClusterStartInfo::oRead(fi_tclInContext& oIn)
{
   oIn >> oClusterId;
   oIn >> eType;
   return oIn;
}

fi_tclOutContext& fi_tcl_ClusterStartInfo::oWrite(fi_tclOutContext& oOut) const
{
   oOut << oClusterId;
   oOut << eType;
   return oOut;
}

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
fi_tcl_LocalOneCellID::fi_tcl_LocalOneCellID(const fi_tcl_LocalOneCellID& coRef):fi_tclVisitableTypeBase(coRef)
{
   ClusterIndex = coRef.ClusterIndex;
   OneCellIndex = coRef.OneCellIndex;
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
fi_tcl_LocalOneCellID& fi_tcl_LocalOneCellID::operator=(const fi_tcl_LocalOneCellID& coRef)
{
   if (this == &coRef) return *this;
   ClusterIndex = coRef.ClusterIndex;
   OneCellIndex = coRef.OneCellIndex;
   return *this;
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
tU32 fi_tcl_LocalOneCellID::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 4;
}

tBool fi_tcl_LocalOneCellID::operator==(const fi_tcl_LocalOneCellID& rfoCmp) const
{
   tBool bResult = true;
      bResult = bResult && (ClusterIndex == rfoCmp.ClusterIndex);
      bResult = bResult && (OneCellIndex == rfoCmp.OneCellIndex);
   return bResult;
}

fi_tclInContext& fi_tcl_LocalOneCellID::oRead(fi_tclInContext& oIn)
{
   oIn >> ClusterIndex;
   oIn >> OneCellIndex;
   return oIn;
}

fi_tclOutContext& fi_tcl_LocalOneCellID::oWrite(fi_tclOutContext& oOut) const
{
   oOut << ClusterIndex;
   oOut << OneCellIndex;
   return oOut;
}

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
fi_tcl_BBox::fi_tcl_BBox(const fi_tcl_BBox& coRef):fi_tclVisitableTypeBase(coRef)
{
   LowerLeftPosition = coRef.LowerLeftPosition;
   UpperRigthPosition = coRef.UpperRigthPosition;
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
fi_tcl_BBox& fi_tcl_BBox::operator=(const fi_tcl_BBox& coRef)
{
   if (this == &coRef) return *this;
   LowerLeftPosition = coRef.LowerLeftPosition;
   UpperRigthPosition = coRef.UpperRigthPosition;
   return *this;
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
tVoid fi_tcl_BBox::vDestroy()
{
   LowerLeftPosition.vDestroy(); 
   UpperRigthPosition.vDestroy(); 
}

tU32 fi_tcl_BBox::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 16;
}

tBool fi_tcl_BBox::operator==(const fi_tcl_BBox& rfoCmp) const
{
   tBool bResult = true;
      bResult = bResult && (LowerLeftPosition == rfoCmp.LowerLeftPosition);
      bResult = bResult && (UpperRigthPosition == rfoCmp.UpperRigthPosition);
   return bResult;
}

fi_tclInContext& fi_tcl_BBox::oRead(fi_tclInContext& oIn)
{
   oIn >> LowerLeftPosition;
   oIn >> UpperRigthPosition;
   return oIn;
}

fi_tclOutContext& fi_tcl_BBox::oWrite(fi_tclOutContext& oOut) const
{
   oOut << LowerLeftPosition;
   oOut << UpperRigthPosition;
   return oOut;
}

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
fi_tcl_RegProfOutline::fi_tcl_RegProfOutline(const fi_tcl_RegProfOutline& coRef):fi_tclVisitableTypeBase(coRef)
{
   RegionProfileId = coRef.RegionProfileId;
   Outline = coRef.Outline;
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
fi_tcl_RegProfOutline& fi_tcl_RegProfOutline::operator=(const fi_tcl_RegProfOutline& coRef)
{
   if (this == &coRef) return *this;
   RegionProfileId = coRef.RegionProfileId;
   Outline = coRef.Outline;
   return *this;
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
tVoid fi_tcl_RegProfOutline::vDestroy()
{
   {
      for (tU32 u32Idx = 0; u32Idx < Outline.size(); ++u32Idx)
         Outline[u32Idx].vDestroy();
   }
   Outline.clear();
}

tU32 fi_tcl_RegProfOutline::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 6+Outline.size()*8;
}

tBool fi_tcl_RegProfOutline::operator==(const fi_tcl_RegProfOutline& rfoCmp) const
{
   tBool bResult = true;
      bResult = bResult && (RegionProfileId == rfoCmp.RegionProfileId);
      bResult = bResult && (Outline.size() == rfoCmp.Outline.size());
      if (bResult)
      {
         for (tU32 u32Idx = 0; bResult && (u32Idx < Outline.size()); ++u32Idx)
            bResult = bResult && (Outline[u32Idx] == rfoCmp.Outline[u32Idx]);
      }
   return bResult;
}

fi_tclInContext& fi_tcl_RegProfOutline::oRead(fi_tclInContext& oIn)
{
   oIn >> RegionProfileId;
   {
      tU32 u32Length;
      tU32 u32Idx;
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
      for (u32Idx = 0; u32Idx < Outline.size(); ++u32Idx)
      {
         Outline[u32Idx].vDestroy();
      }
#endif // !VARIANT_S_FTR_ENABLE_DEEP_COPY
      oIn >> u32Length;
      Outline.resize(u32Length);
      for (u32Idx = 0; u32Idx < u32Length; ++u32Idx)
      {
         oIn >> Outline[u32Idx];
      }
   }
   return oIn;
}

fi_tclOutContext& fi_tcl_RegProfOutline::oWrite(fi_tclOutContext& oOut) const
{
   oOut << RegionProfileId;
   oOut << (tU32)Outline.size();
   {
      for (tU32 u32Idx = 0; u32Idx < Outline.size(); ++u32Idx)
         oOut << Outline[u32Idx];
   }
   return oOut;
}

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
fi_tcl_DapPrefixDesc::fi_tcl_DapPrefixDesc(const fi_tcl_DapPrefixDesc& coRef):fi_tclVisitableTypeBase(coRef)
{
   Mode = coRef.Mode;
   Prefix = coRef.Prefix;
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
fi_tcl_DapPrefixDesc& fi_tcl_DapPrefixDesc::operator=(const fi_tcl_DapPrefixDesc& coRef)
{
   if (this == &coRef) return *this;
   Mode = coRef.Mode;
   Prefix = coRef.Prefix;
   return *this;
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
tVoid fi_tcl_DapPrefixDesc::vDestroy()
{
   Prefix.vDestroy();
}

tU32 fi_tcl_DapPrefixDesc::u32GetSize(tU16 u16MajorVersion) const
{
   return 2+Prefix.u32GetSize(u16MajorVersion);
}

tBool fi_tcl_DapPrefixDesc::operator==(const fi_tcl_DapPrefixDesc& rfoCmp) const
{
   tBool bResult = true;
      bResult = bResult && (Mode == rfoCmp.Mode);
      bResult = bResult && (Prefix == rfoCmp.Prefix);
   return bResult;
}

fi_tclInContext& fi_tcl_DapPrefixDesc::oRead(fi_tclInContext& oIn)
{
   oIn >> Mode;
   oIn >> Prefix;
   return oIn;
}

fi_tclOutContext& fi_tcl_DapPrefixDesc::oWrite(fi_tclOutContext& oOut) const
{
   oOut << Mode;
   oOut << Prefix;
   return oOut;
}

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
fi_tcl_DapPrefixState::fi_tcl_DapPrefixState(const fi_tcl_DapPrefixState& coRef):fi_tclVisitableTypeBase(coRef)
{
   CountryCode = coRef.CountryCode;
   PrefixDescList = coRef.PrefixDescList;
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
fi_tcl_DapPrefixState& fi_tcl_DapPrefixState::operator=(const fi_tcl_DapPrefixState& coRef)
{
   if (this == &coRef) return *this;
   CountryCode = coRef.CountryCode;
   PrefixDescList = coRef.PrefixDescList;
   return *this;
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
tVoid fi_tcl_DapPrefixState::vDestroy()
{
   {
      for (tU32 u32Idx = 0; u32Idx < PrefixDescList.size(); ++u32Idx)
         PrefixDescList[u32Idx].vDestroy();
   }
   PrefixDescList.clear();
}

tU32 fi_tcl_DapPrefixState::u32GetSize(tU16 u16MajorVersion) const
{
   tU32 u32DynamicSize = 0;
   tU32 u32ListIdx;
   for (u32ListIdx = 0; u32ListIdx < PrefixDescList.size(); ++u32ListIdx)
      u32DynamicSize += PrefixDescList[u32ListIdx].u32GetSize(u16MajorVersion);
   return u32DynamicSize+6;
}

tBool fi_tcl_DapPrefixState::operator==(const fi_tcl_DapPrefixState& rfoCmp) const
{
   tBool bResult = true;
      bResult = bResult && (CountryCode == rfoCmp.CountryCode);
      bResult = bResult && (PrefixDescList.size() == rfoCmp.PrefixDescList.size());
      if (bResult)
      {
         for (tU32 u32Idx = 0; bResult && (u32Idx < PrefixDescList.size()); ++u32Idx)
            bResult = bResult && (PrefixDescList[u32Idx] == rfoCmp.PrefixDescList[u32Idx]);
      }
   return bResult;
}

fi_tclInContext& fi_tcl_DapPrefixState::oRead(fi_tclInContext& oIn)
{
   oIn >> CountryCode;
   {
      tU32 u32Length;
      tU32 u32Idx;
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
      for (u32Idx = 0; u32Idx < PrefixDescList.size(); ++u32Idx)
      {
         PrefixDescList[u32Idx].vDestroy();
      }
#endif // !VARIANT_S_FTR_ENABLE_DEEP_COPY
      oIn >> u32Length;
      PrefixDescList.resize(u32Length);
      for (u32Idx = 0; u32Idx < u32Length; ++u32Idx)
      {
         oIn >> PrefixDescList[u32Idx];
      }
   }
   return oIn;
}

fi_tclOutContext& fi_tcl_DapPrefixState::oWrite(fi_tclOutContext& oOut) const
{
   oOut << CountryCode;
   oOut << (tU32)PrefixDescList.size();
   {
      for (tU32 u32Idx = 0; u32Idx < PrefixDescList.size(); ++u32Idx)
         oOut << PrefixDescList[u32Idx];
   }
   return oOut;
}

tU32 fi_tcl_e8_TransferType::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 1;
}

tBool fi_tcl_e8_TransferType::operator==(const fi_tcl_e8_TransferType& rfoCmp) const
{
   return enType == rfoCmp.enType;
}

fi_tclInContext& fi_tcl_e8_TransferType::oRead(fi_tclInContext& oIn)
{
   tU8 u8Value;
   oIn >> u8Value;
   enType = (tenType)u8Value;
   return oIn;
}

fi_tclOutContext& fi_tcl_e8_TransferType::oWrite(fi_tclOutContext& oOut) const
{
   return oOut.oWrite((tU8)enType);
}

tU32 fi_tcl_e8_CoordinateCoding::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 1;
}

tBool fi_tcl_e8_CoordinateCoding::operator==(const fi_tcl_e8_CoordinateCoding& rfoCmp) const
{
   return enType == rfoCmp.enType;
}

fi_tclInContext& fi_tcl_e8_CoordinateCoding::oRead(fi_tclInContext& oIn)
{
   tU8 u8Value;
   oIn >> u8Value;
   enType = (tenType)u8Value;
   return oIn;
}

fi_tclOutContext& fi_tcl_e8_CoordinateCoding::oWrite(fi_tclOutContext& oOut) const
{
   return oOut.oWrite((tU8)enType);
}

tU32 fi_tcl_e16_DataType::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 2;
}

tBool fi_tcl_e16_DataType::operator==(const fi_tcl_e16_DataType& rfoCmp) const
{
   return enType == rfoCmp.enType;
}

fi_tclInContext& fi_tcl_e16_DataType::oRead(fi_tclInContext& oIn)
{
   tU16 u16Value;
   oIn >> u16Value;
   enType = (tenType)u16Value;
   return oIn;
}

fi_tclOutContext& fi_tcl_e16_DataType::oWrite(fi_tclOutContext& oOut) const
{
   return oOut.oWrite((tU16)enType);
}

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
fi_tcl_UniqueID::fi_tcl_UniqueID(const fi_tcl_UniqueID& coRef):fi_tclVisitableTypeBase(coRef)
{
   FirstElement = coRef.FirstElement;
   SecondElement = coRef.SecondElement;
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
fi_tcl_UniqueID& fi_tcl_UniqueID::operator=(const fi_tcl_UniqueID& coRef)
{
   if (this == &coRef) return *this;
   FirstElement = coRef.FirstElement;
   SecondElement = coRef.SecondElement;
   return *this;
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
tU32 fi_tcl_UniqueID::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 8;
}

tBool fi_tcl_UniqueID::operator==(const fi_tcl_UniqueID& rfoCmp) const
{
   tBool bResult = true;
      bResult = bResult && (FirstElement == rfoCmp.FirstElement);
      bResult = bResult && (SecondElement == rfoCmp.SecondElement);
   return bResult;
}

fi_tclInContext& fi_tcl_UniqueID::oRead(fi_tclInContext& oIn)
{
   oIn >> FirstElement;
   oIn >> SecondElement;
   return oIn;
}

fi_tclOutContext& fi_tcl_UniqueID::oWrite(fi_tclOutContext& oOut) const
{
   oOut << FirstElement;
   oOut << SecondElement;
   return oOut;
}

tU32 fi_tcl_MapScale::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 2;
}

tBool fi_tcl_MapScale::operator==(const fi_tcl_MapScale& rfoCmp) const
{
   return u16Value == rfoCmp.u16Value;
}

fi_tclInContext& fi_tcl_MapScale::oRead(fi_tclInContext& oIn)
{
   return oIn >> u16Value;
}

fi_tclOutContext& fi_tcl_MapScale::oWrite(fi_tclOutContext& oOut) const
{
   return oOut << u16Value;
}

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
fi_tcl_BoundingBox::fi_tcl_BoundingBox(const fi_tcl_BoundingBox& coRef):fi_tclVisitableTypeBase(coRef)
{
   BoundingBoxLowerLeft = coRef.BoundingBoxLowerLeft;
   BoundingBoxUpperRight = coRef.BoundingBoxUpperRight;
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
fi_tcl_BoundingBox& fi_tcl_BoundingBox::operator=(const fi_tcl_BoundingBox& coRef)
{
   if (this == &coRef) return *this;
   BoundingBoxLowerLeft = coRef.BoundingBoxLowerLeft;
   BoundingBoxUpperRight = coRef.BoundingBoxUpperRight;
   return *this;
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
tVoid fi_tcl_BoundingBox::vDestroy()
{
   BoundingBoxLowerLeft.vDestroy(); 
   BoundingBoxUpperRight.vDestroy(); 
}

tU32 fi_tcl_BoundingBox::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 16;
}

tBool fi_tcl_BoundingBox::operator==(const fi_tcl_BoundingBox& rfoCmp) const
{
   tBool bResult = true;
      bResult = bResult && (BoundingBoxLowerLeft == rfoCmp.BoundingBoxLowerLeft);
      bResult = bResult && (BoundingBoxUpperRight == rfoCmp.BoundingBoxUpperRight);
   return bResult;
}

fi_tclInContext& fi_tcl_BoundingBox::oRead(fi_tclInContext& oIn)
{
   oIn >> BoundingBoxLowerLeft;
   oIn >> BoundingBoxUpperRight;
   return oIn;
}

fi_tclOutContext& fi_tcl_BoundingBox::oWrite(fi_tclOutContext& oOut) const
{
   oOut << BoundingBoxLowerLeft;
   oOut << BoundingBoxUpperRight;
   return oOut;
}

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
fi_tcl_ResultBlocks::fi_tcl_ResultBlocks(const fi_tcl_ResultBlocks& coRef):fi_tclVisitableTypeBase(coRef)
{
   UniqueID = coRef.UniqueID;
   Offset = coRef.Offset;
   ErrorCode = coRef.ErrorCode;
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
fi_tcl_ResultBlocks& fi_tcl_ResultBlocks::operator=(const fi_tcl_ResultBlocks& coRef)
{
   if (this == &coRef) return *this;
   UniqueID = coRef.UniqueID;
   Offset = coRef.Offset;
   ErrorCode = coRef.ErrorCode;
   return *this;
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
tVoid fi_tcl_ResultBlocks::vDestroy()
{
   UniqueID.vDestroy(); 
}

tU32 fi_tcl_ResultBlocks::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 16;
}

tBool fi_tcl_ResultBlocks::operator==(const fi_tcl_ResultBlocks& rfoCmp) const
{
   tBool bResult = true;
      bResult = bResult && (UniqueID == rfoCmp.UniqueID);
      bResult = bResult && (Offset == rfoCmp.Offset);
      bResult = bResult && (ErrorCode == rfoCmp.ErrorCode);
   return bResult;
}

fi_tclInContext& fi_tcl_ResultBlocks::oRead(fi_tclInContext& oIn)
{
   oIn >> UniqueID;
   oIn >> Offset;
   oIn >> ErrorCode;
   return oIn;
}

fi_tclOutContext& fi_tcl_ResultBlocks::oWrite(fi_tclOutContext& oOut) const
{
   oOut << UniqueID;
   oOut << Offset;
   oOut << ErrorCode;
   return oOut;
}

tU32 fi_tcl_e8_RequestType::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 1;
}

tBool fi_tcl_e8_RequestType::operator==(const fi_tcl_e8_RequestType& rfoCmp) const
{
   return enType == rfoCmp.enType;
}

fi_tclInContext& fi_tcl_e8_RequestType::oRead(fi_tclInContext& oIn)
{
   tU8 u8Value;
   oIn >> u8Value;
   enType = (tenType)u8Value;
   return oIn;
}

fi_tclOutContext& fi_tcl_e8_RequestType::oWrite(fi_tclOutContext& oOut) const
{
   return oOut.oWrite((tU8)enType);
}

tU32 fi_tcl_e16_OneCellIndex::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 2;
}

tBool fi_tcl_e16_OneCellIndex::operator==(const fi_tcl_e16_OneCellIndex& rfoCmp) const
{
   return enType == rfoCmp.enType;
}

fi_tclInContext& fi_tcl_e16_OneCellIndex::oRead(fi_tclInContext& oIn)
{
   tU16 u16Value;
   oIn >> u16Value;
   enType = (tenType)u16Value;
   return oIn;
}

fi_tclOutContext& fi_tcl_e16_OneCellIndex::oWrite(fi_tclOutContext& oOut) const
{
   return oOut.oWrite((tU16)enType);
}

tU32 fi_tcl_e8_NavOneCellDirection::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 1;
}

tBool fi_tcl_e8_NavOneCellDirection::operator==(const fi_tcl_e8_NavOneCellDirection& rfoCmp) const
{
   return enType == rfoCmp.enType;
}

fi_tclInContext& fi_tcl_e8_NavOneCellDirection::oRead(fi_tclInContext& oIn)
{
   tU8 u8Value;
   oIn >> u8Value;
   enType = (tenType)u8Value;
   return oIn;
}

fi_tclOutContext& fi_tcl_e8_NavOneCellDirection::oWrite(fi_tclOutContext& oOut) const
{
   return oOut.oWrite((tU8)enType);
}

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
fi_tcl_OneCellRelation::fi_tcl_OneCellRelation(const fi_tcl_OneCellRelation& coRef):fi_tclVisitableTypeBase(coRef)
{
   ParentOneCellIndex = coRef.ParentOneCellIndex;
   UseDirection = coRef.UseDirection;
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
fi_tcl_OneCellRelation& fi_tcl_OneCellRelation::operator=(const fi_tcl_OneCellRelation& coRef)
{
   if (this == &coRef) return *this;
   ParentOneCellIndex = coRef.ParentOneCellIndex;
   UseDirection = coRef.UseDirection;
   return *this;
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
tU32 fi_tcl_OneCellRelation::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 3;
}

tBool fi_tcl_OneCellRelation::operator==(const fi_tcl_OneCellRelation& rfoCmp) const
{
   tBool bResult = true;
      bResult = bResult && (ParentOneCellIndex == rfoCmp.ParentOneCellIndex);
      bResult = bResult && (UseDirection == rfoCmp.UseDirection);
   return bResult;
}

fi_tclInContext& fi_tcl_OneCellRelation::oRead(fi_tclInContext& oIn)
{
   oIn >> ParentOneCellIndex;
   oIn >> UseDirection;
   return oIn;
}

fi_tclOutContext& fi_tcl_OneCellRelation::oWrite(fi_tclOutContext& oOut) const
{
   oOut << ParentOneCellIndex;
   oOut << UseDirection;
   return oOut;
}

tU32 fi_tcl_e8_Amenity::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 1;
}

tBool fi_tcl_e8_Amenity::operator==(const fi_tcl_e8_Amenity& rfoCmp) const
{
   return enType == rfoCmp.enType;
}

fi_tclInContext& fi_tcl_e8_Amenity::oRead(fi_tclInContext& oIn)
{
   tU8 u8Value;
   oIn >> u8Value;
   enType = (tenType)u8Value;
   return oIn;
}

fi_tclOutContext& fi_tcl_e8_Amenity::oWrite(fi_tclOutContext& oOut) const
{
   return oOut.oWrite((tU8)enType);
}

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
fi_tcl_Amenity::fi_tcl_Amenity(const fi_tcl_Amenity& coRef):fi_tclVisitableTypeBase(coRef)
{
   Amenity = coRef.Amenity;
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
fi_tcl_Amenity& fi_tcl_Amenity::operator=(const fi_tcl_Amenity& coRef)
{
   if (this == &coRef) return *this;
   Amenity = coRef.Amenity;
   return *this;
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
tU32 fi_tcl_Amenity::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 1;
}

tBool fi_tcl_Amenity::operator==(const fi_tcl_Amenity& rfoCmp) const
{
   tBool bResult = true;
      bResult = bResult && (Amenity == rfoCmp.Amenity);
   return bResult;
}

fi_tclInContext& fi_tcl_Amenity::oRead(fi_tclInContext& oIn)
{
   oIn >> Amenity;
   return oIn;
}

fi_tclOutContext& fi_tcl_Amenity::oWrite(fi_tclOutContext& oOut) const
{
   oOut << Amenity;
   return oOut;
}

tU32 fi_tcl_e8_FileType::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 1;
}

tBool fi_tcl_e8_FileType::operator==(const fi_tcl_e8_FileType& rfoCmp) const
{
   return enType == rfoCmp.enType;
}

fi_tclInContext& fi_tcl_e8_FileType::oRead(fi_tclInContext& oIn)
{
   tU8 u8Value;
   oIn >> u8Value;
   enType = (tenType)u8Value;
   return oIn;
}

fi_tclOutContext& fi_tcl_e8_FileType::oWrite(fi_tclOutContext& oOut) const
{
   return oOut.oWrite((tU8)enType);
}

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
fi_tcl_DapRegionDescrList::fi_tcl_DapRegionDescrList(const fi_tcl_DapRegionDescrList& coRef):fi_tclVisitableTypeBase(coRef)
{
   u32DatasetId = coRef.u32DatasetId;
   oRegionDescList = coRef.oRegionDescList;
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
fi_tcl_DapRegionDescrList& fi_tcl_DapRegionDescrList::operator=(const fi_tcl_DapRegionDescrList& coRef)
{
   if (this == &coRef) return *this;
   u32DatasetId = coRef.u32DatasetId;
   oRegionDescList = coRef.oRegionDescList;
   return *this;
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
tVoid fi_tcl_DapRegionDescrList::vDestroy()
{
   {
      for (tU32 u32Idx = 0; u32Idx < oRegionDescList.size(); ++u32Idx)
         oRegionDescList[u32Idx].vDestroy();
   }
   oRegionDescList.clear();
}

tU32 fi_tcl_DapRegionDescrList::u32GetSize(tU16 u16MajorVersion) const
{
   tU32 u32DynamicSize = 0;
   tU32 u32ListIdx;
   for (u32ListIdx = 0; u32ListIdx < oRegionDescList.size(); ++u32ListIdx)
      u32DynamicSize += oRegionDescList[u32ListIdx].u32GetSize(u16MajorVersion);
   return u32DynamicSize+8;
}

tBool fi_tcl_DapRegionDescrList::operator==(const fi_tcl_DapRegionDescrList& rfoCmp) const
{
   tBool bResult = true;
      bResult = bResult && (u32DatasetId == rfoCmp.u32DatasetId);
      bResult = bResult && (oRegionDescList.size() == rfoCmp.oRegionDescList.size());
      if (bResult)
      {
         for (tU32 u32Idx = 0; bResult && (u32Idx < oRegionDescList.size()); ++u32Idx)
            bResult = bResult && (oRegionDescList[u32Idx] == rfoCmp.oRegionDescList[u32Idx]);
      }
   return bResult;
}

fi_tclInContext& fi_tcl_DapRegionDescrList::oRead(fi_tclInContext& oIn)
{
   oIn >> u32DatasetId;
   {
      tU32 u32Length;
      tU32 u32Idx;
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
      for (u32Idx = 0; u32Idx < oRegionDescList.size(); ++u32Idx)
      {
         oRegionDescList[u32Idx].vDestroy();
      }
#endif // !VARIANT_S_FTR_ENABLE_DEEP_COPY
      oIn >> u32Length;
      oRegionDescList.resize(u32Length);
      for (u32Idx = 0; u32Idx < u32Length; ++u32Idx)
      {
         oIn >> oRegionDescList[u32Idx];
      }
   }
   return oIn;
}

fi_tclOutContext& fi_tcl_DapRegionDescrList::oWrite(fi_tclOutContext& oOut) const
{
   oOut << u32DatasetId;
   oOut << (tU32)oRegionDescList.size();
   {
      for (tU32 u32Idx = 0; u32Idx < oRegionDescList.size(); ++u32Idx)
         oOut << oRegionDescList[u32Idx];
   }
   return oOut;
}

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
fi_tcl_CatalogueFiles::fi_tcl_CatalogueFiles(const fi_tcl_CatalogueFiles& coRef):fi_tclVisitableTypeBase(coRef)
{
   CatalogueFileName = coRef.CatalogueFileName;
   EventSignature = coRef.EventSignature;
   CatalogueFileHandle = coRef.CatalogueFileHandle;
   Contents = coRef.Contents;
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
fi_tcl_CatalogueFiles& fi_tcl_CatalogueFiles::operator=(const fi_tcl_CatalogueFiles& coRef)
{
   if (this == &coRef) return *this;
   CatalogueFileName = coRef.CatalogueFileName;
   EventSignature = coRef.EventSignature;
   CatalogueFileHandle = coRef.CatalogueFileHandle;
   Contents = coRef.Contents;
   return *this;
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
tVoid fi_tcl_CatalogueFiles::vDestroy()
{
   CatalogueFileName.vDestroy();
   Contents.vDestroy(); 
}

tU32 fi_tcl_CatalogueFiles::u32GetSize(tU16 u16MajorVersion) const
{
   return 8+CatalogueFileName.u32GetSize(u16MajorVersion)+Contents.u32GetSize(u16MajorVersion);
}

tBool fi_tcl_CatalogueFiles::operator==(const fi_tcl_CatalogueFiles& rfoCmp) const
{
   tBool bResult = true;
      bResult = bResult && (CatalogueFileName == rfoCmp.CatalogueFileName);
      bResult = bResult && (EventSignature == rfoCmp.EventSignature);
      bResult = bResult && (CatalogueFileHandle == rfoCmp.CatalogueFileHandle);
      bResult = bResult && (Contents == rfoCmp.Contents);
   return bResult;
}

fi_tclInContext& fi_tcl_CatalogueFiles::oRead(fi_tclInContext& oIn)
{
   oIn >> CatalogueFileName;
   oIn >> EventSignature;
   oIn >> CatalogueFileHandle;
   oIn >> Contents;
   return oIn;
}

fi_tclOutContext& fi_tcl_CatalogueFiles::oWrite(fi_tclOutContext& oOut) const
{
   oOut << CatalogueFileName;
   oOut << EventSignature;
   oOut << CatalogueFileHandle;
   oOut << Contents;
   return oOut;
}

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
fi_tcl_UTInt::fi_tcl_UTInt(const fi_tcl_UTInt& coRef):fi_tclVisitableTypeBase(coRef)
{
   UTIntValue = coRef.UTIntValue;
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
fi_tcl_UTInt& fi_tcl_UTInt::operator=(const fi_tcl_UTInt& coRef)
{
   if (this == &coRef) return *this;
   UTIntValue = coRef.UTIntValue;
   return *this;
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
tU32 fi_tcl_UTInt::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 4;
}

tBool fi_tcl_UTInt::operator==(const fi_tcl_UTInt& rfoCmp) const
{
   tBool bResult = true;
      bResult = bResult && (UTIntValue == rfoCmp.UTIntValue);
   return bResult;
}

fi_tclInContext& fi_tcl_UTInt::oRead(fi_tclInContext& oIn)
{
   oIn >> UTIntValue;
   return oIn;
}

fi_tclOutContext& fi_tcl_UTInt::oWrite(fi_tclOutContext& oOut) const
{
   oOut << UTIntValue;
   return oOut;
}

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
fi_tcl_UTBool::fi_tcl_UTBool(const fi_tcl_UTBool& coRef):fi_tclVisitableTypeBase(coRef)
{
   UTBoolValue = coRef.UTBoolValue;
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
fi_tcl_UTBool& fi_tcl_UTBool::operator=(const fi_tcl_UTBool& coRef)
{
   if (this == &coRef) return *this;
   UTBoolValue = coRef.UTBoolValue;
   return *this;
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
tU32 fi_tcl_UTBool::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 1;
}

tBool fi_tcl_UTBool::operator==(const fi_tcl_UTBool& rfoCmp) const
{
   tBool bResult = true;
      bResult = bResult && (UTBoolValue == rfoCmp.UTBoolValue);
   return bResult;
}

fi_tclInContext& fi_tcl_UTBool::oRead(fi_tclInContext& oIn)
{
   oIn >> UTBoolValue;
   return oIn;
}

fi_tclOutContext& fi_tcl_UTBool::oWrite(fi_tclOutContext& oOut) const
{
   oOut << UTBoolValue;
   return oOut;
}

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
fi_tcl_UTString::fi_tcl_UTString(const fi_tcl_UTString& coRef):fi_tclVisitableTypeBase(coRef)
{
   StringValue = coRef.StringValue;
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
fi_tcl_UTString& fi_tcl_UTString::operator=(const fi_tcl_UTString& coRef)
{
   if (this == &coRef) return *this;
   StringValue = coRef.StringValue;
   return *this;
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
tVoid fi_tcl_UTString::vDestroy()
{
   StringValue.vDestroy();
}

tU32 fi_tcl_UTString::u32GetSize(tU16 u16MajorVersion) const
{
   return 0+StringValue.u32GetSize(u16MajorVersion);
}

tBool fi_tcl_UTString::operator==(const fi_tcl_UTString& rfoCmp) const
{
   tBool bResult = true;
      bResult = bResult && (StringValue == rfoCmp.StringValue);
   return bResult;
}

fi_tclInContext& fi_tcl_UTString::oRead(fi_tclInContext& oIn)
{
   oIn >> StringValue;
   return oIn;
}

fi_tclOutContext& fi_tcl_UTString::oWrite(fi_tclOutContext& oOut) const
{
   oOut << StringValue;
   return oOut;
}

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
fi_tcl_OrderInfo::fi_tcl_OrderInfo(const fi_tcl_OrderInfo& coRef):fi_tclVisitableTypeBase(coRef)
{
   RegionInfo = coRef.RegionInfo;
   StoreStatus = coRef.StoreStatus;
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
fi_tcl_OrderInfo& fi_tcl_OrderInfo::operator=(const fi_tcl_OrderInfo& coRef)
{
   if (this == &coRef) return *this;
   RegionInfo = coRef.RegionInfo;
   StoreStatus = coRef.StoreStatus;
   return *this;
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
tVoid fi_tcl_OrderInfo::vDestroy()
{
   RegionInfo.vDestroy(); 
}

tU32 fi_tcl_OrderInfo::u32GetSize(tU16 u16MajorVersion) const
{
   return 1+RegionInfo.u32GetSize(u16MajorVersion);
}

tBool fi_tcl_OrderInfo::operator==(const fi_tcl_OrderInfo& rfoCmp) const
{
   tBool bResult = true;
      bResult = bResult && (RegionInfo == rfoCmp.RegionInfo);
      bResult = bResult && (StoreStatus == rfoCmp.StoreStatus);
   return bResult;
}

fi_tclInContext& fi_tcl_OrderInfo::oRead(fi_tclInContext& oIn)
{
   oIn >> RegionInfo;
   oIn >> StoreStatus;
   return oIn;
}

fi_tclOutContext& fi_tcl_OrderInfo::oWrite(fi_tclOutContext& oOut) const
{
   oOut << RegionInfo;
   oOut << StoreStatus;
   return oOut;
}

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
fi_tcl_BinContainer::fi_tcl_BinContainer(const fi_tcl_BinContainer& coRef):fi_tclVisitableTypeBase(coRef)
{
   ContainerDataList = coRef.ContainerDataList;
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
fi_tcl_BinContainer& fi_tcl_BinContainer::operator=(const fi_tcl_BinContainer& coRef)
{
   if (this == &coRef) return *this;
   ContainerDataList = coRef.ContainerDataList;
   return *this;
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
tVoid fi_tcl_BinContainer::vDestroy()
{
   ContainerDataList.clear();
}

tU32 fi_tcl_BinContainer::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 4+ContainerDataList.size()*1;
}

tBool fi_tcl_BinContainer::operator==(const fi_tcl_BinContainer& rfoCmp) const
{
   tBool bResult = true;
      bResult = bResult && (ContainerDataList.size() == rfoCmp.ContainerDataList.size());
      if (bResult)
      {
         for (tU32 u32Idx = 0; bResult && (u32Idx < ContainerDataList.size()); ++u32Idx)
            bResult = bResult && (ContainerDataList[u32Idx] == rfoCmp.ContainerDataList[u32Idx]);
      }
   return bResult;
}

fi_tclInContext& fi_tcl_BinContainer::oRead(fi_tclInContext& oIn)
{
   {
      tU32 u32Length;
      tU32 u32Idx;
      oIn >> u32Length;
      ContainerDataList.resize(u32Length);
      for (u32Idx = 0; u32Idx < u32Length; ++u32Idx)
      {
         oIn >> ContainerDataList[u32Idx];
      }
   }
   return oIn;
}

fi_tclOutContext& fi_tcl_BinContainer::oWrite(fi_tclOutContext& oOut) const
{
   oOut << (tU32)ContainerDataList.size();
   {
      for (tU32 u32Idx = 0; u32Idx < ContainerDataList.size(); ++u32Idx)
         oOut << ContainerDataList[u32Idx];
   }
   return oOut;
}

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
fi_tcl_Reserved::fi_tcl_Reserved(const fi_tcl_Reserved& coRef):fi_tclVisitableTypeBase(coRef)
{
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
fi_tcl_Reserved& fi_tcl_Reserved::operator=(const fi_tcl_Reserved& coRef)
{
   if (this == &coRef) return *this;
   return *this;
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
tU32 fi_tcl_Reserved::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 0;
}

tBool fi_tcl_Reserved::operator==(const fi_tcl_Reserved& /* rfoCmp */) const
{
   tBool bResult = true;
   return bResult;
}

fi_tclInContext& fi_tcl_Reserved::oRead(fi_tclInContext& oIn)
{
   return oIn;
}

fi_tclOutContext& fi_tcl_Reserved::oWrite(fi_tclOutContext& oOut) const
{
   return oOut;
}

tU32 fi_tcl_u8_Percent::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 1;
}

tBool fi_tcl_u8_Percent::operator==(const fi_tcl_u8_Percent& rfoCmp) const
{
   return u8Value == rfoCmp.u8Value;
}

fi_tclInContext& fi_tcl_u8_Percent::oRead(fi_tclInContext& oIn)
{
   return oIn >> u8Value;
}

fi_tclOutContext& fi_tcl_u8_Percent::oWrite(fi_tclOutContext& oOut) const
{
   return oOut << u8Value;
}

tU32 fi_tcl_s16_PerThousand::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 2;
}

tBool fi_tcl_s16_PerThousand::operator==(const fi_tcl_s16_PerThousand& rfoCmp) const
{
   return s16Value == rfoCmp.s16Value;
}

fi_tclInContext& fi_tcl_s16_PerThousand::oRead(fi_tclInContext& oIn)
{
   return oIn >> s16Value;
}

fi_tclOutContext& fi_tcl_s16_PerThousand::oWrite(fi_tclOutContext& oOut) const
{
   return oOut << s16Value;
}

tU32 fi_tcl_u16_IndexInReferenceList::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 2;
}

tBool fi_tcl_u16_IndexInReferenceList::operator==(const fi_tcl_u16_IndexInReferenceList& rfoCmp) const
{
   return u16Value == rfoCmp.u16Value;
}

fi_tclInContext& fi_tcl_u16_IndexInReferenceList::oRead(fi_tclInContext& oIn)
{
   return oIn >> u16Value;
}

fi_tclOutContext& fi_tcl_u16_IndexInReferenceList::oWrite(fi_tclOutContext& oOut) const
{
   return oOut << u16Value;
}

tU32 fi_tcl_u16_ErrorCode::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 2;
}

tBool fi_tcl_u16_ErrorCode::operator==(const fi_tcl_u16_ErrorCode& rfoCmp) const
{
   return u16Value == rfoCmp.u16Value;
}

fi_tclInContext& fi_tcl_u16_ErrorCode::oRead(fi_tclInContext& oIn)
{
   return oIn >> u16Value;
}

fi_tclOutContext& fi_tcl_u16_ErrorCode::oWrite(fi_tclOutContext& oOut) const
{
   return oOut << u16Value;
}

tU32 fi_tcl_u16_RPM::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 2;
}

tBool fi_tcl_u16_RPM::operator==(const fi_tcl_u16_RPM& rfoCmp) const
{
   return u16Value == rfoCmp.u16Value;
}

fi_tclInContext& fi_tcl_u16_RPM::oRead(fi_tclInContext& oIn)
{
   return oIn >> u16Value;
}

fi_tclOutContext& fi_tcl_u16_RPM::oWrite(fi_tclOutContext& oOut) const
{
   return oOut << u16Value;
}

tU32 fi_tcl_s32_Kilogram::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 4;
}

tBool fi_tcl_s32_Kilogram::operator==(const fi_tcl_s32_Kilogram& rfoCmp) const
{
   return s32Value == rfoCmp.s32Value;
}

fi_tclInContext& fi_tcl_s32_Kilogram::oRead(fi_tclInContext& oIn)
{
   return oIn >> s32Value;
}

fi_tclOutContext& fi_tcl_s32_Kilogram::oWrite(fi_tclOutContext& oOut) const
{
   return oOut << s32Value;
}

tU32 fi_tcl_s32_Pound::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 4;
}

tBool fi_tcl_s32_Pound::operator==(const fi_tcl_s32_Pound& rfoCmp) const
{
   return s32Value == rfoCmp.s32Value;
}

fi_tclInContext& fi_tcl_s32_Pound::oRead(fi_tclInContext& oIn)
{
   return oIn >> s32Value;
}

fi_tclOutContext& fi_tcl_s32_Pound::oWrite(fi_tclOutContext& oOut) const
{
   return oOut << s32Value;
}

tU32 fi_tcl_s16_Meter::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 2;
}

tBool fi_tcl_s16_Meter::operator==(const fi_tcl_s16_Meter& rfoCmp) const
{
   return s16Value == rfoCmp.s16Value;
}

fi_tclInContext& fi_tcl_s16_Meter::oRead(fi_tclInContext& oIn)
{
   return oIn >> s16Value;
}

fi_tclOutContext& fi_tcl_s16_Meter::oWrite(fi_tclOutContext& oOut) const
{
   return oOut << s16Value;
}

tU32 fi_tcl_s32_Meter::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 4;
}

tBool fi_tcl_s32_Meter::operator==(const fi_tcl_s32_Meter& rfoCmp) const
{
   return s32Value == rfoCmp.s32Value;
}

fi_tclInContext& fi_tcl_s32_Meter::oRead(fi_tclInContext& oIn)
{
   return oIn >> s32Value;
}

fi_tclOutContext& fi_tcl_s32_Meter::oWrite(fi_tclOutContext& oOut) const
{
   return oOut << s32Value;
}

tU32 fi_tcl_s32_Yards::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 4;
}

tBool fi_tcl_s32_Yards::operator==(const fi_tcl_s32_Yards& rfoCmp) const
{
   return s32Value == rfoCmp.s32Value;
}

fi_tclInContext& fi_tcl_s32_Yards::oRead(fi_tclInContext& oIn)
{
   return oIn >> s32Value;
}

fi_tclOutContext& fi_tcl_s32_Yards::oWrite(fi_tclOutContext& oOut) const
{
   return oOut << s32Value;
}

tU32 fi_tcl_s32_Foot::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 4;
}

tBool fi_tcl_s32_Foot::operator==(const fi_tcl_s32_Foot& rfoCmp) const
{
   return s32Value == rfoCmp.s32Value;
}

fi_tclInContext& fi_tcl_s32_Foot::oRead(fi_tclInContext& oIn)
{
   return oIn >> s32Value;
}

fi_tclOutContext& fi_tcl_s32_Foot::oWrite(fi_tclOutContext& oOut) const
{
   return oOut << s32Value;
}

tU32 fi_tcl_s32_Centimeter::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 4;
}

tBool fi_tcl_s32_Centimeter::operator==(const fi_tcl_s32_Centimeter& rfoCmp) const
{
   return s32Value == rfoCmp.s32Value;
}

fi_tclInContext& fi_tcl_s32_Centimeter::oRead(fi_tclInContext& oIn)
{
   return oIn >> s32Value;
}

fi_tclOutContext& fi_tcl_s32_Centimeter::oWrite(fi_tclOutContext& oOut) const
{
   return oOut << s32Value;
}

tU32 fi_tcl_s32_Inch::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 4;
}

tBool fi_tcl_s32_Inch::operator==(const fi_tcl_s32_Inch& rfoCmp) const
{
   return s32Value == rfoCmp.s32Value;
}

fi_tclInContext& fi_tcl_s32_Inch::oRead(fi_tclInContext& oIn)
{
   return oIn >> s32Value;
}

fi_tclOutContext& fi_tcl_s32_Inch::oWrite(fi_tclOutContext& oOut) const
{
   return oOut << s32Value;
}

tU32 fi_tcl_s32_Millimeter::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 4;
}

tBool fi_tcl_s32_Millimeter::operator==(const fi_tcl_s32_Millimeter& rfoCmp) const
{
   return s32Value == rfoCmp.s32Value;
}

fi_tclInContext& fi_tcl_s32_Millimeter::oRead(fi_tclInContext& oIn)
{
   return oIn >> s32Value;
}

fi_tclOutContext& fi_tcl_s32_Millimeter::oWrite(fi_tclOutContext& oOut) const
{
   return oOut << s32Value;
}

tU32 fi_tcl_s32_Microliter::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 4;
}

tBool fi_tcl_s32_Microliter::operator==(const fi_tcl_s32_Microliter& rfoCmp) const
{
   return s32Value == rfoCmp.s32Value;
}

fi_tclInContext& fi_tcl_s32_Microliter::oRead(fi_tclInContext& oIn)
{
   return oIn >> s32Value;
}

fi_tclOutContext& fi_tcl_s32_Microliter::oWrite(fi_tclOutContext& oOut) const
{
   return oOut << s32Value;
}

tU32 fi_tcl_s32_Second::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 4;
}

tBool fi_tcl_s32_Second::operator==(const fi_tcl_s32_Second& rfoCmp) const
{
   return s32Value == rfoCmp.s32Value;
}

fi_tclInContext& fi_tcl_s32_Second::oRead(fi_tclInContext& oIn)
{
   return oIn >> s32Value;
}

fi_tclOutContext& fi_tcl_s32_Second::oWrite(fi_tclOutContext& oOut) const
{
   return oOut << s32Value;
}

tU32 fi_tcl_u16_MilliSecond::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 2;
}

tBool fi_tcl_u16_MilliSecond::operator==(const fi_tcl_u16_MilliSecond& rfoCmp) const
{
   return u16Value == rfoCmp.u16Value;
}

fi_tclInContext& fi_tcl_u16_MilliSecond::oRead(fi_tclInContext& oIn)
{
   return oIn >> u16Value;
}

fi_tclOutContext& fi_tcl_u16_MilliSecond::oWrite(fi_tclOutContext& oOut) const
{
   return oOut << u16Value;
}

tU32 fi_tcl_s32_MilliSecond::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 4;
}

tBool fi_tcl_s32_MilliSecond::operator==(const fi_tcl_s32_MilliSecond& rfoCmp) const
{
   return s32Value == rfoCmp.s32Value;
}

fi_tclInContext& fi_tcl_s32_MilliSecond::oRead(fi_tclInContext& oIn)
{
   return oIn >> s32Value;
}

fi_tclOutContext& fi_tcl_s32_MilliSecond::oWrite(fi_tclOutContext& oOut) const
{
   return oOut << s32Value;
}

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
fi_tcl_POSIXTime::fi_tcl_POSIXTime(const fi_tcl_POSIXTime& coRef):fi_tclVisitableTypeBase(coRef)
{
   Time = coRef.Time;
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
fi_tcl_POSIXTime& fi_tcl_POSIXTime::operator=(const fi_tcl_POSIXTime& coRef)
{
   if (this == &coRef) return *this;
   Time = coRef.Time;
   return *this;
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
tU32 fi_tcl_POSIXTime::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 4;
}

tBool fi_tcl_POSIXTime::operator==(const fi_tcl_POSIXTime& rfoCmp) const
{
   tBool bResult = true;
      bResult = bResult && (Time == rfoCmp.Time);
   return bResult;
}

fi_tclInContext& fi_tcl_POSIXTime::oRead(fi_tclInContext& oIn)
{
   oIn >> Time;
   return oIn;
}

fi_tclOutContext& fi_tcl_POSIXTime::oWrite(fi_tclOutContext& oOut) const
{
   oOut << Time;
   return oOut;
}

tU32 fi_tcl_e8_DST_State::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 1;
}

tBool fi_tcl_e8_DST_State::operator==(const fi_tcl_e8_DST_State& rfoCmp) const
{
   return enType == rfoCmp.enType;
}

fi_tclInContext& fi_tcl_e8_DST_State::oRead(fi_tclInContext& oIn)
{
   tU8 u8Value;
   oIn >> u8Value;
   enType = (tenType)u8Value;
   return oIn;
}

fi_tclOutContext& fi_tcl_e8_DST_State::oWrite(fi_tclOutContext& oOut) const
{
   return oOut.oWrite((tU8)enType);
}

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
fi_tcl_TimeZoneElement::fi_tcl_TimeZoneElement(const fi_tcl_TimeZoneElement& coRef):fi_tclVisitableTypeBase(coRef)
{
   Abbreviation_StandardTime = coRef.Abbreviation_StandardTime;
   Abbreviation_DST_in_effect = coRef.Abbreviation_DST_in_effect;
   TimeZoneDifference = coRef.TimeZoneDifference;
   DST_State = coRef.DST_State;
   DSTDifference = coRef.DSTDifference;
   DST_TimeDomain = coRef.DST_TimeDomain;
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
fi_tcl_TimeZoneElement& fi_tcl_TimeZoneElement::operator=(const fi_tcl_TimeZoneElement& coRef)
{
   if (this == &coRef) return *this;
   Abbreviation_StandardTime = coRef.Abbreviation_StandardTime;
   Abbreviation_DST_in_effect = coRef.Abbreviation_DST_in_effect;
   TimeZoneDifference = coRef.TimeZoneDifference;
   DST_State = coRef.DST_State;
   DSTDifference = coRef.DSTDifference;
   DST_TimeDomain = coRef.DST_TimeDomain;
   return *this;
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
tVoid fi_tcl_TimeZoneElement::vDestroy()
{
   Abbreviation_StandardTime.vDestroy();
   Abbreviation_DST_in_effect.vDestroy();
   DST_TimeDomain.clear();
}

tU32 fi_tcl_TimeZoneElement::u32GetSize(tU16 u16MajorVersion) const
{
   return 13+Abbreviation_StandardTime.u32GetSize(u16MajorVersion)+Abbreviation_DST_in_effect.u32GetSize(u16MajorVersion)+DST_TimeDomain.size()*1;
}

tBool fi_tcl_TimeZoneElement::operator==(const fi_tcl_TimeZoneElement& rfoCmp) const
{
   tBool bResult = true;
      bResult = bResult && (Abbreviation_StandardTime == rfoCmp.Abbreviation_StandardTime);
      bResult = bResult && (Abbreviation_DST_in_effect == rfoCmp.Abbreviation_DST_in_effect);
      bResult = bResult && (TimeZoneDifference == rfoCmp.TimeZoneDifference);
      bResult = bResult && (DST_State == rfoCmp.DST_State);
      bResult = bResult && (DSTDifference == rfoCmp.DSTDifference);
      bResult = bResult && (DST_TimeDomain.size() == rfoCmp.DST_TimeDomain.size());
      if (bResult)
      {
         for (tU32 u32Idx = 0; bResult && (u32Idx < DST_TimeDomain.size()); ++u32Idx)
            bResult = bResult && (DST_TimeDomain[u32Idx] == rfoCmp.DST_TimeDomain[u32Idx]);
      }
   return bResult;
}

fi_tclInContext& fi_tcl_TimeZoneElement::oRead(fi_tclInContext& oIn)
{
   oIn >> Abbreviation_StandardTime;
   oIn >> Abbreviation_DST_in_effect;
   oIn >> TimeZoneDifference;
   oIn >> DST_State;
   oIn >> DSTDifference;
   {
      tU32 u32Length;
      tU32 u32Idx;
      oIn >> u32Length;
      DST_TimeDomain.resize(u32Length);
      for (u32Idx = 0; u32Idx < u32Length; ++u32Idx)
      {
         oIn >> DST_TimeDomain[u32Idx];
      }
   }
   return oIn;
}

fi_tclOutContext& fi_tcl_TimeZoneElement::oWrite(fi_tclOutContext& oOut) const
{
   oOut << Abbreviation_StandardTime;
   oOut << Abbreviation_DST_in_effect;
   oOut << TimeZoneDifference;
   oOut << DST_State;
   oOut << DSTDifference;
   oOut << (tU32)DST_TimeDomain.size();
   {
      for (tU32 u32Idx = 0; u32Idx < DST_TimeDomain.size(); ++u32Idx)
         oOut << DST_TimeDomain[u32Idx];
   }
   return oOut;
}

tU32 fi_tcl_s16_KmPerHour::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 2;
}

tBool fi_tcl_s16_KmPerHour::operator==(const fi_tcl_s16_KmPerHour& rfoCmp) const
{
   return s16Value == rfoCmp.s16Value;
}

fi_tclInContext& fi_tcl_s16_KmPerHour::oRead(fi_tclInContext& oIn)
{
   return oIn >> s16Value;
}

fi_tclOutContext& fi_tcl_s16_KmPerHour::oWrite(fi_tclOutContext& oOut) const
{
   return oOut << s16Value;
}

tU32 fi_tcl_s16_MilesPerHour::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 2;
}

tBool fi_tcl_s16_MilesPerHour::operator==(const fi_tcl_s16_MilesPerHour& rfoCmp) const
{
   return s16Value == rfoCmp.s16Value;
}

fi_tclInContext& fi_tcl_s16_MilesPerHour::oRead(fi_tclInContext& oIn)
{
   return oIn >> s16Value;
}

fi_tclOutContext& fi_tcl_s16_MilesPerHour::oWrite(fi_tclOutContext& oOut) const
{
   return oOut << s16Value;
}

tU32 fi_tcl_s16_Knot::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 2;
}

tBool fi_tcl_s16_Knot::operator==(const fi_tcl_s16_Knot& rfoCmp) const
{
   return s16Value == rfoCmp.s16Value;
}

fi_tclInContext& fi_tcl_s16_Knot::oRead(fi_tclInContext& oIn)
{
   return oIn >> s16Value;
}

fi_tclOutContext& fi_tcl_s16_Knot::oWrite(fi_tclOutContext& oOut) const
{
   return oOut << s16Value;
}

tU32 fi_tcl_s16_CentimeterSecond::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 2;
}

tBool fi_tcl_s16_CentimeterSecond::operator==(const fi_tcl_s16_CentimeterSecond& rfoCmp) const
{
   return s16Value == rfoCmp.s16Value;
}

fi_tclInContext& fi_tcl_s16_CentimeterSecond::oRead(fi_tclInContext& oIn)
{
   return oIn >> s16Value;
}

fi_tclOutContext& fi_tcl_s16_CentimeterSecond::oWrite(fi_tclOutContext& oOut) const
{
   return oOut << s16Value;
}

tU32 fi_tcl_s16_Kelvin::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 2;
}

tBool fi_tcl_s16_Kelvin::operator==(const fi_tcl_s16_Kelvin& rfoCmp) const
{
   return s16Value == rfoCmp.s16Value;
}

fi_tclInContext& fi_tcl_s16_Kelvin::oRead(fi_tclInContext& oIn)
{
   return oIn >> s16Value;
}

fi_tclOutContext& fi_tcl_s16_Kelvin::oWrite(fi_tclOutContext& oOut) const
{
   return oOut << s16Value;
}

tU32 fi_tcl_s16_Fahrenheit::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 2;
}

tBool fi_tcl_s16_Fahrenheit::operator==(const fi_tcl_s16_Fahrenheit& rfoCmp) const
{
   return s16Value == rfoCmp.s16Value;
}

fi_tclInContext& fi_tcl_s16_Fahrenheit::oRead(fi_tclInContext& oIn)
{
   return oIn >> s16Value;
}

fi_tclOutContext& fi_tcl_s16_Fahrenheit::oWrite(fi_tclOutContext& oOut) const
{
   return oOut << s16Value;
}

tU32 fi_tcl_s32_Pascal::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 4;
}

tBool fi_tcl_s32_Pascal::operator==(const fi_tcl_s32_Pascal& rfoCmp) const
{
   return s32Value == rfoCmp.s32Value;
}

fi_tclInContext& fi_tcl_s32_Pascal::oRead(fi_tclInContext& oIn)
{
   return oIn >> s32Value;
}

fi_tclOutContext& fi_tcl_s32_Pascal::oWrite(fi_tclOutContext& oOut) const
{
   return oOut << s32Value;
}

tU32 fi_tcl_s32_Watt::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 4;
}

tBool fi_tcl_s32_Watt::operator==(const fi_tcl_s32_Watt& rfoCmp) const
{
   return s32Value == rfoCmp.s32Value;
}

fi_tclInContext& fi_tcl_s32_Watt::oRead(fi_tclInContext& oIn)
{
   return oIn >> s32Value;
}

fi_tclOutContext& fi_tcl_s32_Watt::oWrite(fi_tclOutContext& oOut) const
{
   return oOut << s32Value;
}

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
fi_tcl_FIVersion::fi_tcl_FIVersion(const fi_tcl_FIVersion& coRef):fi_tclVisitableTypeBase(coRef)
{
   MajorVersion = coRef.MajorVersion;
   MinorVersion = coRef.MinorVersion;
   PatchVersion = coRef.PatchVersion;
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
fi_tcl_FIVersion& fi_tcl_FIVersion::operator=(const fi_tcl_FIVersion& coRef)
{
   if (this == &coRef) return *this;
   MajorVersion = coRef.MajorVersion;
   MinorVersion = coRef.MinorVersion;
   PatchVersion = coRef.PatchVersion;
   return *this;
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
tU32 fi_tcl_FIVersion::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 3;
}

tBool fi_tcl_FIVersion::operator==(const fi_tcl_FIVersion& rfoCmp) const
{
   tBool bResult = true;
      bResult = bResult && (MajorVersion == rfoCmp.MajorVersion);
      bResult = bResult && (MinorVersion == rfoCmp.MinorVersion);
      bResult = bResult && (PatchVersion == rfoCmp.PatchVersion);
   return bResult;
}

fi_tclInContext& fi_tcl_FIVersion::oRead(fi_tclInContext& oIn)
{
   oIn >> MajorVersion;
   oIn >> MinorVersion;
   oIn >> PatchVersion;
   return oIn;
}

fi_tclOutContext& fi_tcl_FIVersion::oWrite(fi_tclOutContext& oOut) const
{
   oOut << MajorVersion;
   oOut << MinorVersion;
   oOut << PatchVersion;
   return oOut;
}

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
fi_tcl_UserPOIElement::fi_tcl_UserPOIElement(const fi_tcl_UserPOIElement& coRef):fi_tclVisitableTypeBase(coRef)
{
   UniqueID = coRef.UniqueID;
   Category = coRef.Category;
   Position = coRef.Position;
   Name = coRef.Name;
   Description = coRef.Description;
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
fi_tcl_UserPOIElement& fi_tcl_UserPOIElement::operator=(const fi_tcl_UserPOIElement& coRef)
{
   if (this == &coRef) return *this;
   UniqueID = coRef.UniqueID;
   Category = coRef.Category;
   Position = coRef.Position;
   Name = coRef.Name;
   Description = coRef.Description;
   return *this;
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
tVoid fi_tcl_UserPOIElement::vDestroy()
{
   Position.vDestroy(); 
   Name.vDestroy();
   Description.vDestroy();
}

tU32 fi_tcl_UserPOIElement::u32GetSize(tU16 u16MajorVersion) const
{
   return 16+Name.u32GetSize(u16MajorVersion)+Description.u32GetSize(u16MajorVersion);
}

tBool fi_tcl_UserPOIElement::operator==(const fi_tcl_UserPOIElement& rfoCmp) const
{
   tBool bResult = true;
      bResult = bResult && (UniqueID == rfoCmp.UniqueID);
      bResult = bResult && (Category == rfoCmp.Category);
      bResult = bResult && (Position == rfoCmp.Position);
      bResult = bResult && (Name == rfoCmp.Name);
      bResult = bResult && (Description == rfoCmp.Description);
   return bResult;
}

fi_tclInContext& fi_tcl_UserPOIElement::oRead(fi_tclInContext& oIn)
{
   oIn >> UniqueID;
   oIn >> Category;
   oIn >> Position;
   oIn >> Name;
   oIn >> Description;
   return oIn;
}

fi_tclOutContext& fi_tcl_UserPOIElement::oWrite(fi_tclOutContext& oOut) const
{
   oOut << UniqueID;
   oOut << Category;
   oOut << Position;
   oOut << Name;
   oOut << Description;
   return oOut;
}

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
fi_tcl_LocTableDesc::fi_tcl_LocTableDesc(const fi_tcl_LocTableDesc& coRef):fi_tclVisitableTypeBase(coRef)
{
   oLocTableIdent = coRef.oLocTableIdent;
   u16TableVersion = coRef.u16TableVersion;
   u16IsoCountryCode = coRef.u16IsoCountryCode;
   u8DefaultLanguageId = coRef.u8DefaultLanguageId;
   FeatureAvailList = coRef.FeatureAvailList;
   oOutline = coRef.oOutline;
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
fi_tcl_LocTableDesc& fi_tcl_LocTableDesc::operator=(const fi_tcl_LocTableDesc& coRef)
{
   if (this == &coRef) return *this;
   oLocTableIdent = coRef.oLocTableIdent;
   u16TableVersion = coRef.u16TableVersion;
   u16IsoCountryCode = coRef.u16IsoCountryCode;
   u8DefaultLanguageId = coRef.u8DefaultLanguageId;
   FeatureAvailList = coRef.FeatureAvailList;
   oOutline = coRef.oOutline;
   return *this;
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
tVoid fi_tcl_LocTableDesc::vDestroy()
{
   oLocTableIdent.vDestroy(); 
   FeatureAvailList.clear();
   oOutline.vDestroy(); 
}

tU32 fi_tcl_LocTableDesc::u32GetSize(tU16 u16MajorVersion) const
{
   return 11+FeatureAvailList.size()*2+oOutline.u32GetSize(u16MajorVersion);
}

tBool fi_tcl_LocTableDesc::operator==(const fi_tcl_LocTableDesc& rfoCmp) const
{
   tBool bResult = true;
      bResult = bResult && (oLocTableIdent == rfoCmp.oLocTableIdent);
      bResult = bResult && (u16TableVersion == rfoCmp.u16TableVersion);
      bResult = bResult && (u16IsoCountryCode == rfoCmp.u16IsoCountryCode);
      bResult = bResult && (u8DefaultLanguageId == rfoCmp.u8DefaultLanguageId);
      bResult = bResult && (FeatureAvailList.size() == rfoCmp.FeatureAvailList.size());
      if (bResult)
      {
         for (tU32 u32Idx = 0; bResult && (u32Idx < FeatureAvailList.size()); ++u32Idx)
            bResult = bResult && (FeatureAvailList[u32Idx] == rfoCmp.FeatureAvailList[u32Idx]);
      }
      bResult = bResult && (oOutline == rfoCmp.oOutline);
   return bResult;
}

fi_tclInContext& fi_tcl_LocTableDesc::oRead(fi_tclInContext& oIn)
{
   oIn >> oLocTableIdent;
   oIn >> u16TableVersion;
   oIn >> u16IsoCountryCode;
   oIn >> u8DefaultLanguageId;
   {
      tU32 u32Length;
      tU32 u32Idx;
      oIn >> u32Length;
      FeatureAvailList.resize(u32Length);
      for (u32Idx = 0; u32Idx < u32Length; ++u32Idx)
      {
         oIn >> FeatureAvailList[u32Idx];
      }
   }
   oIn >> oOutline;
   return oIn;
}

fi_tclOutContext& fi_tcl_LocTableDesc::oWrite(fi_tclOutContext& oOut) const
{
   oOut << oLocTableIdent;
   oOut << u16TableVersion;
   oOut << u16IsoCountryCode;
   oOut << u8DefaultLanguageId;
   oOut << (tU32)FeatureAvailList.size();
   {
      for (tU32 u32Idx = 0; u32Idx < FeatureAvailList.size(); ++u32Idx)
         oOut << FeatureAvailList[u32Idx];
   }
   oOut << oOutline;
   return oOut;
}

tU32 fi_tcl_b16_ElementProperties::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 2;
}

tBool fi_tcl_b16_ElementProperties::operator==(const fi_tcl_b16_ElementProperties& rfoCmp) const
{
   return u16Value == rfoCmp.u16Value;
}

fi_tclInContext& fi_tcl_b16_ElementProperties::oRead(fi_tclInContext& oIn)
{
   return oIn >> u16Value;
}

fi_tclOutContext& fi_tcl_b16_ElementProperties::oWrite(fi_tclOutContext& oOut) const
{
   tU16 temp = u16Value;
   if (!(6 <= oOut.u16GetMajorVersion()))
      temp &= ~FI_C_U16_BIT_ISBASENAME;
   if (!(15 <= oOut.u16GetMajorVersion()))
      temp &= ~FI_C_U16_BIT_ISUSERPOIDATASET;
   return oOut << temp;
}

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
fi_tcl_RectangleWGS84::fi_tcl_RectangleWGS84(const fi_tcl_RectangleWGS84& coRef):fi_tclVisitableTypeBase(coRef)
{
   LongitudeMin = coRef.LongitudeMin;
   LatitudeMin = coRef.LatitudeMin;
   LongitudeMax = coRef.LongitudeMax;
   LatitudeMax = coRef.LatitudeMax;
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
fi_tcl_RectangleWGS84& fi_tcl_RectangleWGS84::operator=(const fi_tcl_RectangleWGS84& coRef)
{
   if (this == &coRef) return *this;
   LongitudeMin = coRef.LongitudeMin;
   LatitudeMin = coRef.LatitudeMin;
   LongitudeMax = coRef.LongitudeMax;
   LatitudeMax = coRef.LatitudeMax;
   return *this;
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
tU32 fi_tcl_RectangleWGS84::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 16;
}

tBool fi_tcl_RectangleWGS84::operator==(const fi_tcl_RectangleWGS84& rfoCmp) const
{
   tBool bResult = true;
      bResult = bResult && (LongitudeMin == rfoCmp.LongitudeMin);
      bResult = bResult && (LatitudeMin == rfoCmp.LatitudeMin);
      bResult = bResult && (LongitudeMax == rfoCmp.LongitudeMax);
      bResult = bResult && (LatitudeMax == rfoCmp.LatitudeMax);
   return bResult;
}

fi_tclInContext& fi_tcl_RectangleWGS84::oRead(fi_tclInContext& oIn)
{
   oIn >> LongitudeMin;
   oIn >> LatitudeMin;
   oIn >> LongitudeMax;
   oIn >> LatitudeMax;
   return oIn;
}

fi_tclOutContext& fi_tcl_RectangleWGS84::oWrite(fi_tclOutContext& oOut) const
{
   oOut << LongitudeMin;
   oOut << LatitudeMin;
   oOut << LongitudeMax;
   oOut << LatitudeMax;
   return oOut;
}

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
fi_tcl_LanguageDependentType::fi_tcl_LanguageDependentType(const fi_tcl_LanguageDependentType& coRef):fi_tclVisitableTypeBase(coRef)
{
   oLanguageCode = coRef.oLanguageCode;
   oCountryCode = coRef.oCountryCode;
   pcType = coRef.pcType;
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
fi_tcl_LanguageDependentType& fi_tcl_LanguageDependentType::operator=(const fi_tcl_LanguageDependentType& coRef)
{
   if (this == &coRef) return *this;
   oLanguageCode = coRef.oLanguageCode;
   oCountryCode = coRef.oCountryCode;
   pcType = coRef.pcType;
   return *this;
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
tVoid fi_tcl_LanguageDependentType::vDestroy()
{
   pcType.vDestroy();
}

tU32 fi_tcl_LanguageDependentType::u32GetSize(tU16 u16MajorVersion) const
{
   return 4+pcType.u32GetSize(u16MajorVersion);
}

tBool fi_tcl_LanguageDependentType::operator==(const fi_tcl_LanguageDependentType& rfoCmp) const
{
   tBool bResult = true;
      bResult = bResult && (oLanguageCode == rfoCmp.oLanguageCode);
      bResult = bResult && (oCountryCode == rfoCmp.oCountryCode);
      bResult = bResult && (pcType == rfoCmp.pcType);
   return bResult;
}

fi_tclInContext& fi_tcl_LanguageDependentType::oRead(fi_tclInContext& oIn)
{
   oIn >> oLanguageCode;
   oIn >> oCountryCode;
   oIn >> pcType;
   return oIn;
}

fi_tclOutContext& fi_tcl_LanguageDependentType::oWrite(fi_tclOutContext& oOut) const
{
   oOut << oLanguageCode;
   oOut << oCountryCode;
   oOut << pcType;
   return oOut;
}

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
fi_tcl_LanguageIdElem::fi_tcl_LanguageIdElem(const fi_tcl_LanguageIdElem& coRef):fi_tclVisitableTypeBase(coRef)
{
   oLocTableIdent = coRef.oLocTableIdent;
   oCountry = coRef.oCountry;
   oLanguage = coRef.oLanguage;
   u8LanguageId = coRef.u8LanguageId;
   bDefaultLanguage = coRef.bDefaultLanguage;
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
fi_tcl_LanguageIdElem& fi_tcl_LanguageIdElem::operator=(const fi_tcl_LanguageIdElem& coRef)
{
   if (this == &coRef) return *this;
   oLocTableIdent = coRef.oLocTableIdent;
   oCountry = coRef.oCountry;
   oLanguage = coRef.oLanguage;
   u8LanguageId = coRef.u8LanguageId;
   bDefaultLanguage = coRef.bDefaultLanguage;
   return *this;
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
tVoid fi_tcl_LanguageIdElem::vDestroy()
{
   oLocTableIdent.vDestroy(); 
}

tU32 fi_tcl_LanguageIdElem::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 8;
}

tBool fi_tcl_LanguageIdElem::operator==(const fi_tcl_LanguageIdElem& rfoCmp) const
{
   tBool bResult = true;
      bResult = bResult && (oLocTableIdent == rfoCmp.oLocTableIdent);
      bResult = bResult && (oCountry == rfoCmp.oCountry);
      bResult = bResult && (oLanguage == rfoCmp.oLanguage);
      bResult = bResult && (u8LanguageId == rfoCmp.u8LanguageId);
      bResult = bResult && (bDefaultLanguage == rfoCmp.bDefaultLanguage);
   return bResult;
}

fi_tclInContext& fi_tcl_LanguageIdElem::oRead(fi_tclInContext& oIn)
{
   oIn >> oLocTableIdent;
   oIn >> oCountry;
   oIn >> oLanguage;
   oIn >> u8LanguageId;
   oIn >> bDefaultLanguage;
   return oIn;
}

fi_tclOutContext& fi_tcl_LanguageIdElem::oWrite(fi_tclOutContext& oOut) const
{
   oOut << oLocTableIdent;
   oOut << oCountry;
   oOut << oLanguage;
   oOut << u8LanguageId;
   oOut << bDefaultLanguage;
   return oOut;
}

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
fi_tcl_LanguageID::fi_tcl_LanguageID(const fi_tcl_LanguageID& coRef):fi_tclVisitableTypeBase(coRef)
{
   ISO639_LanguageCode = coRef.ISO639_LanguageCode;
   ISO3166_CountryCode = coRef.ISO3166_CountryCode;
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
fi_tcl_LanguageID& fi_tcl_LanguageID::operator=(const fi_tcl_LanguageID& coRef)
{
   if (this == &coRef) return *this;
   ISO639_LanguageCode = coRef.ISO639_LanguageCode;
   ISO3166_CountryCode = coRef.ISO3166_CountryCode;
   return *this;
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
tU32 fi_tcl_LanguageID::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 4;
}

tBool fi_tcl_LanguageID::operator==(const fi_tcl_LanguageID& rfoCmp) const
{
   tBool bResult = true;
      bResult = bResult && (ISO639_LanguageCode == rfoCmp.ISO639_LanguageCode);
      bResult = bResult && (ISO3166_CountryCode == rfoCmp.ISO3166_CountryCode);
   return bResult;
}

fi_tclInContext& fi_tcl_LanguageID::oRead(fi_tclInContext& oIn)
{
   oIn >> ISO639_LanguageCode;
   oIn >> ISO3166_CountryCode;
   return oIn;
}

fi_tclOutContext& fi_tcl_LanguageID::oWrite(fi_tclOutContext& oOut) const
{
   oOut << ISO639_LanguageCode;
   oOut << ISO3166_CountryCode;
   return oOut;
}

tU32 fi_tcl_u8_DirectionAbsolute::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 1;
}

tBool fi_tcl_u8_DirectionAbsolute::operator==(const fi_tcl_u8_DirectionAbsolute& rfoCmp) const
{
   return u8Value == rfoCmp.u8Value;
}

fi_tclInContext& fi_tcl_u8_DirectionAbsolute::oRead(fi_tclInContext& oIn)
{
   return oIn >> u8Value;
}

fi_tclOutContext& fi_tcl_u8_DirectionAbsolute::oWrite(fi_tclOutContext& oOut) const
{
   return oOut << u8Value;
}

tU32 fi_tcl_u8_DirectionRelative::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 1;
}

tBool fi_tcl_u8_DirectionRelative::operator==(const fi_tcl_u8_DirectionRelative& rfoCmp) const
{
   return u8Value == rfoCmp.u8Value;
}

fi_tclInContext& fi_tcl_u8_DirectionRelative::oRead(fi_tclInContext& oIn)
{
   return oIn >> u8Value;
}

fi_tclOutContext& fi_tcl_u8_DirectionRelative::oWrite(fi_tclOutContext& oOut) const
{
   return oOut << u8Value;
}

tU32 fi_tcl_s16_CentiDegree::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 2;
}

tBool fi_tcl_s16_CentiDegree::operator==(const fi_tcl_s16_CentiDegree& rfoCmp) const
{
   return s16Value == rfoCmp.s16Value;
}

fi_tclInContext& fi_tcl_s16_CentiDegree::oRead(fi_tclInContext& oIn)
{
   return oIn >> s16Value;
}

fi_tclOutContext& fi_tcl_s16_CentiDegree::oWrite(fi_tclOutContext& oOut) const
{
   return oOut << s16Value;
}

tU32 fi_tcl_s16_Degree::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 2;
}

tBool fi_tcl_s16_Degree::operator==(const fi_tcl_s16_Degree& rfoCmp) const
{
   return s16Value == rfoCmp.s16Value;
}

fi_tclInContext& fi_tcl_s16_Degree::oRead(fi_tclInContext& oIn)
{
   return oIn >> s16Value;
}

fi_tclOutContext& fi_tcl_s16_Degree::oWrite(fi_tclOutContext& oOut) const
{
   return oOut << s16Value;
}

tU32 fi_tcl_u16_DirectionAbsolute_CentiDegree::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 2;
}

tBool fi_tcl_u16_DirectionAbsolute_CentiDegree::operator==(const fi_tcl_u16_DirectionAbsolute_CentiDegree& rfoCmp) const
{
   return u16Value == rfoCmp.u16Value;
}

fi_tclInContext& fi_tcl_u16_DirectionAbsolute_CentiDegree::oRead(fi_tclInContext& oIn)
{
   return oIn >> u16Value;
}

fi_tclOutContext& fi_tcl_u16_DirectionAbsolute_CentiDegree::oWrite(fi_tclOutContext& oOut) const
{
   return oOut << u16Value;
}

tU32 fi_tcl_s16_DirectionRelative_CentiDegree::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 2;
}

tBool fi_tcl_s16_DirectionRelative_CentiDegree::operator==(const fi_tcl_s16_DirectionRelative_CentiDegree& rfoCmp) const
{
   return s16Value == rfoCmp.s16Value;
}

fi_tclInContext& fi_tcl_s16_DirectionRelative_CentiDegree::oRead(fi_tclInContext& oIn)
{
   return oIn >> s16Value;
}

fi_tclOutContext& fi_tcl_s16_DirectionRelative_CentiDegree::oWrite(fi_tclOutContext& oOut) const
{
   return oOut << s16Value;
}

tU32 fi_tcl_e8_FuelType::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 1;
}

tBool fi_tcl_e8_FuelType::operator==(const fi_tcl_e8_FuelType& rfoCmp) const
{
   return enType == rfoCmp.enType;
}

fi_tclInContext& fi_tcl_e8_FuelType::oRead(fi_tclInContext& oIn)
{
   tU8 u8Value;
   oIn >> u8Value;
   enType = (tenType)u8Value;
   return oIn;
}

fi_tclOutContext& fi_tcl_e8_FuelType::oWrite(fi_tclOutContext& oOut) const
{
   return oOut.oWrite((tU8)enType);
}

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
fi_tcl_DistTimeFuel::fi_tcl_DistTimeFuel(const fi_tcl_DistTimeFuel& coRef):fi_tclVisitableTypeBase(coRef)
{
   Distance = coRef.Distance;
   Time = coRef.Time;
   Fuel = coRef.Fuel;
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
fi_tcl_DistTimeFuel& fi_tcl_DistTimeFuel::operator=(const fi_tcl_DistTimeFuel& coRef)
{
   if (this == &coRef) return *this;
   Distance = coRef.Distance;
   Time = coRef.Time;
   Fuel = coRef.Fuel;
   return *this;
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
tU32 fi_tcl_DistTimeFuel::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 12;
}

tBool fi_tcl_DistTimeFuel::operator==(const fi_tcl_DistTimeFuel& rfoCmp) const
{
   tBool bResult = true;
      bResult = bResult && (Distance == rfoCmp.Distance);
      bResult = bResult && (Time == rfoCmp.Time);
      bResult = bResult && (Fuel == rfoCmp.Fuel);
   return bResult;
}

fi_tclInContext& fi_tcl_DistTimeFuel::oRead(fi_tclInContext& oIn)
{
   oIn >> Distance;
   oIn >> Time;
   oIn >> Fuel;
   return oIn;
}

fi_tclOutContext& fi_tcl_DistTimeFuel::oWrite(fi_tclOutContext& oOut) const
{
   oOut << Distance;
   oOut << Time;
   oOut << Fuel;
   return oOut;
}

tU32 fi_tcl_e8_BinContainerTypes::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 1;
}

tBool fi_tcl_e8_BinContainerTypes::operator==(const fi_tcl_e8_BinContainerTypes& rfoCmp) const
{
   return enType == rfoCmp.enType;
}

fi_tclInContext& fi_tcl_e8_BinContainerTypes::oRead(fi_tclInContext& oIn)
{
   tU8 u8Value;
   oIn >> u8Value;
   enType = (tenType)u8Value;
   return oIn;
}

fi_tclOutContext& fi_tcl_e8_BinContainerTypes::oWrite(fi_tclOutContext& oOut) const
{
   fi_tcl_e8_BinContainerTypes::tenType enData = enType;
   if ((enData == FI_EN_T_GRAPHICALWEATHERSHAPEBINCONTAINER) && !(29 <= oOut.u16GetMajorVersion()))
   {
      enData = FI_EN_T_RESERVED;
   }
   if ((enData == FI_EN_T_MAPROUTEBINCONTAINER) && !(15 <= oOut.u16GetMajorVersion()))
   {
      enData = FI_EN_T_RESERVED;
   }
   return oOut.oWrite((tU8)enData);
}

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
fi_tcl_State::fi_tcl_State(const fi_tcl_State& coRef):fi_tclVisitableTypeBase(coRef)
{
   StateId = coRef.StateId;
   StateName = coRef.StateName;
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
fi_tcl_State& fi_tcl_State::operator=(const fi_tcl_State& coRef)
{
   if (this == &coRef) return *this;
   StateId = coRef.StateId;
   StateName = coRef.StateName;
   return *this;
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
tVoid fi_tcl_State::vDestroy()
{
   StateId.vDestroy();
   StateName.vDestroy();
}

tU32 fi_tcl_State::u32GetSize(tU16 u16MajorVersion) const
{
   return 0+StateId.u32GetSize(u16MajorVersion)+StateName.u32GetSize(u16MajorVersion);
}

tBool fi_tcl_State::operator==(const fi_tcl_State& rfoCmp) const
{
   tBool bResult = true;
      bResult = bResult && (StateId == rfoCmp.StateId);
      bResult = bResult && (StateName == rfoCmp.StateName);
   return bResult;
}

fi_tclInContext& fi_tcl_State::oRead(fi_tclInContext& oIn)
{
   oIn >> StateId;
   oIn >> StateName;
   return oIn;
}

fi_tclOutContext& fi_tcl_State::oWrite(fi_tclOutContext& oOut) const
{
   oOut << StateId;
   oOut << StateName;
   return oOut;
}

tU32 fi_tcl_e8_FuelAge::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 1;
}

tBool fi_tcl_e8_FuelAge::operator==(const fi_tcl_e8_FuelAge& rfoCmp) const
{
   return enType == rfoCmp.enType;
}

fi_tclInContext& fi_tcl_e8_FuelAge::oRead(fi_tclInContext& oIn)
{
   tU8 u8Value;
   oIn >> u8Value;
   enType = (tenType)u8Value;
   return oIn;
}

fi_tclOutContext& fi_tcl_e8_FuelAge::oWrite(fi_tclOutContext& oOut) const
{
   return oOut.oWrite((tU8)enType);
}

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
fi_tcl_FuelTypeCode::fi_tcl_FuelTypeCode(const fi_tcl_FuelTypeCode& coRef):fi_tclVisitableTypeBase(coRef)
{
   FuelTypeCode = coRef.FuelTypeCode;
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
fi_tcl_FuelTypeCode& fi_tcl_FuelTypeCode::operator=(const fi_tcl_FuelTypeCode& coRef)
{
   if (this == &coRef) return *this;
   FuelTypeCode = coRef.FuelTypeCode;
   return *this;
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
tU32 fi_tcl_FuelTypeCode::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 1;
}

tBool fi_tcl_FuelTypeCode::operator==(const fi_tcl_FuelTypeCode& rfoCmp) const
{
   tBool bResult = true;
      bResult = bResult && (FuelTypeCode == rfoCmp.FuelTypeCode);
   return bResult;
}

fi_tclInContext& fi_tcl_FuelTypeCode::oRead(fi_tclInContext& oIn)
{
   oIn >> FuelTypeCode;
   return oIn;
}

fi_tclOutContext& fi_tcl_FuelTypeCode::oWrite(fi_tclOutContext& oOut) const
{
   oOut << FuelTypeCode;
   return oOut;
}

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
fi_tcl_RegionId::fi_tcl_RegionId(const fi_tcl_RegionId& coRef):fi_tclVisitableTypeBase(coRef)
{
   RegionId = coRef.RegionId;
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
fi_tcl_RegionId& fi_tcl_RegionId::operator=(const fi_tcl_RegionId& coRef)
{
   if (this == &coRef) return *this;
   RegionId = coRef.RegionId;
   return *this;
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
tU32 fi_tcl_RegionId::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 2;
}

tBool fi_tcl_RegionId::operator==(const fi_tcl_RegionId& rfoCmp) const
{
   tBool bResult = true;
      bResult = bResult && (RegionId == rfoCmp.RegionId);
   return bResult;
}

fi_tclInContext& fi_tcl_RegionId::oRead(fi_tclInContext& oIn)
{
   oIn >> RegionId;
   return oIn;
}

fi_tclOutContext& fi_tcl_RegionId::oWrite(fi_tclOutContext& oOut) const
{
   oOut << RegionId;
   return oOut;
}

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
fi_tcl_FuelAge::fi_tcl_FuelAge(const fi_tcl_FuelAge& coRef):fi_tclVisitableTypeBase(coRef)
{
   AgeType = coRef.AgeType;
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
fi_tcl_FuelAge& fi_tcl_FuelAge::operator=(const fi_tcl_FuelAge& coRef)
{
   if (this == &coRef) return *this;
   AgeType = coRef.AgeType;
   return *this;
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
tU32 fi_tcl_FuelAge::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 1;
}

tBool fi_tcl_FuelAge::operator==(const fi_tcl_FuelAge& rfoCmp) const
{
   tBool bResult = true;
      bResult = bResult && (AgeType == rfoCmp.AgeType);
   return bResult;
}

fi_tclInContext& fi_tcl_FuelAge::oRead(fi_tclInContext& oIn)
{
   oIn >> AgeType;
   return oIn;
}

fi_tclOutContext& fi_tcl_FuelAge::oWrite(fi_tclOutContext& oOut) const
{
   oOut << AgeType;
   return oOut;
}

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
fi_tcl_FuelPrice::fi_tcl_FuelPrice(const fi_tcl_FuelPrice& coRef):fi_tclVisitableTypeBase(coRef)
{
   FuelType = coRef.FuelType;
   Price = coRef.Price;
   Currency = coRef.Currency;
   Age = coRef.Age;
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
fi_tcl_FuelPrice& fi_tcl_FuelPrice::operator=(const fi_tcl_FuelPrice& coRef)
{
   if (this == &coRef) return *this;
   FuelType = coRef.FuelType;
   Price = coRef.Price;
   Currency = coRef.Currency;
   Age = coRef.Age;
   return *this;
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
tVoid fi_tcl_FuelPrice::vDestroy()
{
   FuelType.vDestroy(); 
   Currency.vDestroy();
   Age.vDestroy(); 
}

tU32 fi_tcl_FuelPrice::u32GetSize(tU16 u16MajorVersion) const
{
   tU32 u32DynamicSize = 0;
   if (2 <= u16MajorVersion)
   {
      u32DynamicSize += 1;
   }
   return u32DynamicSize+3+Currency.u32GetSize(u16MajorVersion);
}

tBool fi_tcl_FuelPrice::operator==(const fi_tcl_FuelPrice& rfoCmp) const
{
   tBool bResult = true;
      bResult = bResult && (FuelType == rfoCmp.FuelType);
      bResult = bResult && (Price == rfoCmp.Price);
      bResult = bResult && (Currency == rfoCmp.Currency);
      bResult = bResult && (Age == rfoCmp.Age);
   return bResult;
}

fi_tclInContext& fi_tcl_FuelPrice::oRead(fi_tclInContext& oIn)
{
   oIn >> FuelType;
   oIn >> Price;
   oIn >> Currency;
   if (2 <= oIn.u16GetMajorVersion())
   {
      oIn >> Age;
   }
   return oIn;
}

fi_tclOutContext& fi_tcl_FuelPrice::oWrite(fi_tclOutContext& oOut) const
{
   oOut << FuelType;
   oOut << Price;
   oOut << Currency;
   if (2 <= oOut.u16GetMajorVersion())
   {
      oOut << Age;
   }
   return oOut;
}

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
fi_tcl_FuelStationId::fi_tcl_FuelStationId(const fi_tcl_FuelStationId& coRef):fi_tclVisitableTypeBase(coRef)
{
   StationId = coRef.StationId;
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
fi_tcl_FuelStationId& fi_tcl_FuelStationId::operator=(const fi_tcl_FuelStationId& coRef)
{
   if (this == &coRef) return *this;
   StationId = coRef.StationId;
   return *this;
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
tU32 fi_tcl_FuelStationId::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 2;
}

tBool fi_tcl_FuelStationId::operator==(const fi_tcl_FuelStationId& rfoCmp) const
{
   tBool bResult = true;
      bResult = bResult && (StationId == rfoCmp.StationId);
   return bResult;
}

fi_tclInContext& fi_tcl_FuelStationId::oRead(fi_tclInContext& oIn)
{
   oIn >> StationId;
   return oIn;
}

fi_tclOutContext& fi_tcl_FuelStationId::oWrite(fi_tclOutContext& oOut) const
{
   oOut << StationId;
   return oOut;
}

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
fi_tcl_FuelType::fi_tcl_FuelType(const fi_tcl_FuelType& coRef):fi_tclVisitableTypeBase(coRef)
{
   Code = coRef.Code;
   Name = coRef.Name;
   WellKnownType = coRef.WellKnownType;
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
fi_tcl_FuelType& fi_tcl_FuelType::operator=(const fi_tcl_FuelType& coRef)
{
   if (this == &coRef) return *this;
   Code = coRef.Code;
   Name = coRef.Name;
   WellKnownType = coRef.WellKnownType;
   return *this;
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
tVoid fi_tcl_FuelType::vDestroy()
{
   Code.vDestroy(); 
   Name.vDestroy();
}

tU32 fi_tcl_FuelType::u32GetSize(tU16 u16MajorVersion) const
{
   return 2+Name.u32GetSize(u16MajorVersion);
}

tBool fi_tcl_FuelType::operator==(const fi_tcl_FuelType& rfoCmp) const
{
   tBool bResult = true;
      bResult = bResult && (Code == rfoCmp.Code);
      bResult = bResult && (Name == rfoCmp.Name);
      bResult = bResult && (WellKnownType == rfoCmp.WellKnownType);
   return bResult;
}

fi_tclInContext& fi_tcl_FuelType::oRead(fi_tclInContext& oIn)
{
   oIn >> Code;
   oIn >> Name;
   oIn >> WellKnownType;
   return oIn;
}

fi_tclOutContext& fi_tcl_FuelType::oWrite(fi_tclOutContext& oOut) const
{
   oOut << Code;
   oOut << Name;
   oOut << WellKnownType;
   return oOut;
}

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
fi_tcl_FuelStation::fi_tcl_FuelStation(const fi_tcl_FuelStation& coRef):fi_tclVisitableTypeBase(coRef)
{
   RegionId = coRef.RegionId;
   StationId = coRef.StationId;
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
fi_tcl_FuelStation& fi_tcl_FuelStation::operator=(const fi_tcl_FuelStation& coRef)
{
   if (this == &coRef) return *this;
   RegionId = coRef.RegionId;
   StationId = coRef.StationId;
   return *this;
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
tVoid fi_tcl_FuelStation::vDestroy()
{
   RegionId.vDestroy(); 
   StationId.vDestroy(); 
}

tU32 fi_tcl_FuelStation::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 4;
}

tBool fi_tcl_FuelStation::operator==(const fi_tcl_FuelStation& rfoCmp) const
{
   tBool bResult = true;
      bResult = bResult && (RegionId == rfoCmp.RegionId);
      bResult = bResult && (StationId == rfoCmp.StationId);
   return bResult;
}

fi_tclInContext& fi_tcl_FuelStation::oRead(fi_tclInContext& oIn)
{
   oIn >> RegionId;
   oIn >> StationId;
   return oIn;
}

fi_tclOutContext& fi_tcl_FuelStation::oWrite(fi_tclOutContext& oOut) const
{
   oOut << RegionId;
   oOut << StationId;
   return oOut;
}

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
fi_tcl_FuelStationPrices::fi_tcl_FuelStationPrices(const fi_tcl_FuelStationPrices& coRef):fi_tclVisitableTypeBase(coRef)
{
   FuelStation = coRef.FuelStation;
   FuelPrices = coRef.FuelPrices;
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
fi_tcl_FuelStationPrices& fi_tcl_FuelStationPrices::operator=(const fi_tcl_FuelStationPrices& coRef)
{
   if (this == &coRef) return *this;
   FuelStation = coRef.FuelStation;
   FuelPrices = coRef.FuelPrices;
   return *this;
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
tVoid fi_tcl_FuelStationPrices::vDestroy()
{
   FuelStation.vDestroy(); 
   {
      for (tU32 u32Idx = 0; u32Idx < FuelPrices.size(); ++u32Idx)
         FuelPrices[u32Idx].vDestroy();
   }
   FuelPrices.clear();
}

tU32 fi_tcl_FuelStationPrices::u32GetSize(tU16 u16MajorVersion) const
{
   tU32 u32DynamicSize = 0;
   tU32 u32ListIdx;
   for (u32ListIdx = 0; u32ListIdx < FuelPrices.size(); ++u32ListIdx)
      u32DynamicSize += FuelPrices[u32ListIdx].u32GetSize(u16MajorVersion);
   return u32DynamicSize+8;
}

tBool fi_tcl_FuelStationPrices::operator==(const fi_tcl_FuelStationPrices& rfoCmp) const
{
   tBool bResult = true;
      bResult = bResult && (FuelStation == rfoCmp.FuelStation);
      bResult = bResult && (FuelPrices.size() == rfoCmp.FuelPrices.size());
      if (bResult)
      {
         for (tU32 u32Idx = 0; bResult && (u32Idx < FuelPrices.size()); ++u32Idx)
            bResult = bResult && (FuelPrices[u32Idx] == rfoCmp.FuelPrices[u32Idx]);
      }
   return bResult;
}

fi_tclInContext& fi_tcl_FuelStationPrices::oRead(fi_tclInContext& oIn)
{
   oIn >> FuelStation;
   {
      tU32 u32Length;
      tU32 u32Idx;
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
      for (u32Idx = 0; u32Idx < FuelPrices.size(); ++u32Idx)
      {
         FuelPrices[u32Idx].vDestroy();
      }
#endif // !VARIANT_S_FTR_ENABLE_DEEP_COPY
      oIn >> u32Length;
      FuelPrices.resize(u32Length);
      for (u32Idx = 0; u32Idx < u32Length; ++u32Idx)
      {
         oIn >> FuelPrices[u32Idx];
      }
   }
   return oIn;
}

fi_tclOutContext& fi_tcl_FuelStationPrices::oWrite(fi_tclOutContext& oOut) const
{
   oOut << FuelStation;
   oOut << (tU32)FuelPrices.size();
   {
      for (tU32 u32Idx = 0; u32Idx < FuelPrices.size(); ++u32Idx)
         oOut << FuelPrices[u32Idx];
   }
   return oOut;
}

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
fi_tcl_StationFuelTypes::fi_tcl_StationFuelTypes(const fi_tcl_StationFuelTypes& coRef):fi_tclVisitableTypeBase(coRef)
{
   FuelStation = coRef.FuelStation;
   FuelTypeList = coRef.FuelTypeList;
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
fi_tcl_StationFuelTypes& fi_tcl_StationFuelTypes::operator=(const fi_tcl_StationFuelTypes& coRef)
{
   if (this == &coRef) return *this;
   FuelStation = coRef.FuelStation;
   FuelTypeList = coRef.FuelTypeList;
   return *this;
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
tVoid fi_tcl_StationFuelTypes::vDestroy()
{
   FuelStation.vDestroy(); 
   {
      for (tU32 u32Idx = 0; u32Idx < FuelTypeList.size(); ++u32Idx)
         FuelTypeList[u32Idx].vDestroy();
   }
   FuelTypeList.clear();
}

tU32 fi_tcl_StationFuelTypes::u32GetSize(tU16 u16MajorVersion) const
{
   tU32 u32DynamicSize = 0;
   tU32 u32ListIdx;
   for (u32ListIdx = 0; u32ListIdx < FuelTypeList.size(); ++u32ListIdx)
      u32DynamicSize += FuelTypeList[u32ListIdx].u32GetSize(u16MajorVersion);
   return u32DynamicSize+8;
}

tBool fi_tcl_StationFuelTypes::operator==(const fi_tcl_StationFuelTypes& rfoCmp) const
{
   tBool bResult = true;
      bResult = bResult && (FuelStation == rfoCmp.FuelStation);
      bResult = bResult && (FuelTypeList.size() == rfoCmp.FuelTypeList.size());
      if (bResult)
      {
         for (tU32 u32Idx = 0; bResult && (u32Idx < FuelTypeList.size()); ++u32Idx)
            bResult = bResult && (FuelTypeList[u32Idx] == rfoCmp.FuelTypeList[u32Idx]);
      }
   return bResult;
}

fi_tclInContext& fi_tcl_StationFuelTypes::oRead(fi_tclInContext& oIn)
{
   oIn >> FuelStation;
   {
      tU32 u32Length;
      tU32 u32Idx;
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
      for (u32Idx = 0; u32Idx < FuelTypeList.size(); ++u32Idx)
      {
         FuelTypeList[u32Idx].vDestroy();
      }
#endif // !VARIANT_S_FTR_ENABLE_DEEP_COPY
      oIn >> u32Length;
      FuelTypeList.resize(u32Length);
      for (u32Idx = 0; u32Idx < u32Length; ++u32Idx)
      {
         oIn >> FuelTypeList[u32Idx];
      }
   }
   return oIn;
}

fi_tclOutContext& fi_tcl_StationFuelTypes::oWrite(fi_tclOutContext& oOut) const
{
   oOut << FuelStation;
   oOut << (tU32)FuelTypeList.size();
   {
      for (tU32 u32Idx = 0; u32Idx < FuelTypeList.size(); ++u32Idx)
         oOut << FuelTypeList[u32Idx];
   }
   return oOut;
}

tU32 fi_tcl_b16_StationDescriptionRequest::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 2;
}

tBool fi_tcl_b16_StationDescriptionRequest::operator==(const fi_tcl_b16_StationDescriptionRequest& rfoCmp) const
{
   return u16Value == rfoCmp.u16Value;
}

fi_tclInContext& fi_tcl_b16_StationDescriptionRequest::oRead(fi_tclInContext& oIn)
{
   return oIn >> u16Value;
}

fi_tclOutContext& fi_tcl_b16_StationDescriptionRequest::oWrite(fi_tclOutContext& oOut) const
{
   return oOut << u16Value;
}

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
fi_tcl_FuelStationInfo::fi_tcl_FuelStationInfo(const fi_tcl_FuelStationInfo& coRef):fi_tclVisitableTypeBase(coRef)
{
   Address = coRef.Address;
   Brand = coRef.Brand;
   City = coRef.City;
   ListOfAmenities = coRef.ListOfAmenities;
   Name = coRef.Name;
   Phone = coRef.Phone;
   Position = coRef.Position;
   State = coRef.State;
   Zip = coRef.Zip;
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
fi_tcl_FuelStationInfo& fi_tcl_FuelStationInfo::operator=(const fi_tcl_FuelStationInfo& coRef)
{
   if (this == &coRef) return *this;
   Address = coRef.Address;
   Brand = coRef.Brand;
   City = coRef.City;
   ListOfAmenities = coRef.ListOfAmenities;
   Name = coRef.Name;
   Phone = coRef.Phone;
   Position = coRef.Position;
   State = coRef.State;
   Zip = coRef.Zip;
   return *this;
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
tVoid fi_tcl_FuelStationInfo::vDestroy()
{
   Address.vDestroy();
   Brand.vDestroy();
   City.vDestroy();
   {
      for (tU32 u32Idx = 0; u32Idx < ListOfAmenities.size(); ++u32Idx)
         ListOfAmenities[u32Idx].vDestroy();
   }
   ListOfAmenities.clear();
   Name.vDestroy();
   Phone.vDestroy();
   Position.vDestroy(); 
   State.vDestroy(); 
   Zip.vDestroy();
}

tU32 fi_tcl_FuelStationInfo::u32GetSize(tU16 u16MajorVersion) const
{
   return 12+Address.u32GetSize(u16MajorVersion)+Brand.u32GetSize(u16MajorVersion)+City.u32GetSize(u16MajorVersion)+ListOfAmenities.size()*1+Name.u32GetSize(u16MajorVersion)+Phone.u32GetSize(u16MajorVersion)+State.u32GetSize(u16MajorVersion)+Zip.u32GetSize(u16MajorVersion);
}

tBool fi_tcl_FuelStationInfo::operator==(const fi_tcl_FuelStationInfo& rfoCmp) const
{
   tBool bResult = true;
      bResult = bResult && (Address == rfoCmp.Address);
      bResult = bResult && (Brand == rfoCmp.Brand);
      bResult = bResult && (City == rfoCmp.City);
      bResult = bResult && (ListOfAmenities.size() == rfoCmp.ListOfAmenities.size());
      if (bResult)
      {
         for (tU32 u32Idx = 0; bResult && (u32Idx < ListOfAmenities.size()); ++u32Idx)
            bResult = bResult && (ListOfAmenities[u32Idx] == rfoCmp.ListOfAmenities[u32Idx]);
      }
      bResult = bResult && (Name == rfoCmp.Name);
      bResult = bResult && (Phone == rfoCmp.Phone);
      bResult = bResult && (Position == rfoCmp.Position);
      bResult = bResult && (State == rfoCmp.State);
      bResult = bResult && (Zip == rfoCmp.Zip);
   return bResult;
}

fi_tclInContext& fi_tcl_FuelStationInfo::oRead(fi_tclInContext& oIn)
{
   oIn >> Address;
   oIn >> Brand;
   oIn >> City;
   {
      tU32 u32Length;
      tU32 u32Idx;
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
      for (u32Idx = 0; u32Idx < ListOfAmenities.size(); ++u32Idx)
      {
         ListOfAmenities[u32Idx].vDestroy();
      }
#endif // !VARIANT_S_FTR_ENABLE_DEEP_COPY
      oIn >> u32Length;
      ListOfAmenities.resize(u32Length);
      for (u32Idx = 0; u32Idx < u32Length; ++u32Idx)
      {
         oIn >> ListOfAmenities[u32Idx];
      }
   }
   oIn >> Name;
   oIn >> Phone;
   oIn >> Position;
   oIn >> State;
   oIn >> Zip;
   return oIn;
}

fi_tclOutContext& fi_tcl_FuelStationInfo::oWrite(fi_tclOutContext& oOut) const
{
   oOut << Address;
   oOut << Brand;
   oOut << City;
   oOut << (tU32)ListOfAmenities.size();
   {
      for (tU32 u32Idx = 0; u32Idx < ListOfAmenities.size(); ++u32Idx)
         oOut << ListOfAmenities[u32Idx];
   }
   oOut << Name;
   oOut << Phone;
   oOut << Position;
   oOut << State;
   oOut << Zip;
   return oOut;
}

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
fi_tcl_FuelStationPricesForPosition::fi_tcl_FuelStationPricesForPosition(const fi_tcl_FuelStationPricesForPosition& coRef):fi_tclVisitableTypeBase(coRef)
{
   Position = coRef.Position;
   FuelStationPrices = coRef.FuelStationPrices;
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
fi_tcl_FuelStationPricesForPosition& fi_tcl_FuelStationPricesForPosition::operator=(const fi_tcl_FuelStationPricesForPosition& coRef)
{
   if (this == &coRef) return *this;
   Position = coRef.Position;
   FuelStationPrices = coRef.FuelStationPrices;
   return *this;
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
tVoid fi_tcl_FuelStationPricesForPosition::vDestroy()
{
   Position.vDestroy(); 
   {
      for (tU32 u32Idx = 0; u32Idx < FuelStationPrices.size(); ++u32Idx)
         FuelStationPrices[u32Idx].vDestroy();
   }
   FuelStationPrices.clear();
}

tU32 fi_tcl_FuelStationPricesForPosition::u32GetSize(tU16 u16MajorVersion) const
{
   tU32 u32DynamicSize = 0;
   tU32 u32ListIdx;
   for (u32ListIdx = 0; u32ListIdx < FuelStationPrices.size(); ++u32ListIdx)
      u32DynamicSize += FuelStationPrices[u32ListIdx].u32GetSize(u16MajorVersion);
   return u32DynamicSize+12;
}

tBool fi_tcl_FuelStationPricesForPosition::operator==(const fi_tcl_FuelStationPricesForPosition& rfoCmp) const
{
   tBool bResult = true;
      bResult = bResult && (Position == rfoCmp.Position);
      bResult = bResult && (FuelStationPrices.size() == rfoCmp.FuelStationPrices.size());
      if (bResult)
      {
         for (tU32 u32Idx = 0; bResult && (u32Idx < FuelStationPrices.size()); ++u32Idx)
            bResult = bResult && (FuelStationPrices[u32Idx] == rfoCmp.FuelStationPrices[u32Idx]);
      }
   return bResult;
}

fi_tclInContext& fi_tcl_FuelStationPricesForPosition::oRead(fi_tclInContext& oIn)
{
   oIn >> Position;
   {
      tU32 u32Length;
      tU32 u32Idx;
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
      for (u32Idx = 0; u32Idx < FuelStationPrices.size(); ++u32Idx)
      {
         FuelStationPrices[u32Idx].vDestroy();
      }
#endif // !VARIANT_S_FTR_ENABLE_DEEP_COPY
      oIn >> u32Length;
      FuelStationPrices.resize(u32Length);
      for (u32Idx = 0; u32Idx < u32Length; ++u32Idx)
      {
         oIn >> FuelStationPrices[u32Idx];
      }
   }
   return oIn;
}

fi_tclOutContext& fi_tcl_FuelStationPricesForPosition::oWrite(fi_tclOutContext& oOut) const
{
   oOut << Position;
   oOut << (tU32)FuelStationPrices.size();
   {
      for (tU32 u32Idx = 0; u32Idx < FuelStationPrices.size(); ++u32Idx)
         oOut << FuelStationPrices[u32Idx];
   }
   return oOut;
}

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
fi_tcl_UpdateId::fi_tcl_UpdateId(const fi_tcl_UpdateId& coRef):fi_tclVisitableTypeBase(coRef)
{
   UpdateId = coRef.UpdateId;
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
fi_tcl_UpdateId& fi_tcl_UpdateId::operator=(const fi_tcl_UpdateId& coRef)
{
   if (this == &coRef) return *this;
   UpdateId = coRef.UpdateId;
   return *this;
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
tU32 fi_tcl_UpdateId::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 2;
}

tBool fi_tcl_UpdateId::operator==(const fi_tcl_UpdateId& rfoCmp) const
{
   tBool bResult = true;
      bResult = bResult && (UpdateId == rfoCmp.UpdateId);
   return bResult;
}

fi_tclInContext& fi_tcl_UpdateId::oRead(fi_tclInContext& oIn)
{
   oIn >> UpdateId;
   return oIn;
}

fi_tclOutContext& fi_tcl_UpdateId::oWrite(fi_tclOutContext& oOut) const
{
   oOut << UpdateId;
   return oOut;
}

tU32 fi_tcl_e8_SXMFuelType::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 1;
}

tBool fi_tcl_e8_SXMFuelType::operator==(const fi_tcl_e8_SXMFuelType& rfoCmp) const
{
   return enType == rfoCmp.enType;
}

fi_tclInContext& fi_tcl_e8_SXMFuelType::oRead(fi_tclInContext& oIn)
{
   tU8 u8Value;
   oIn >> u8Value;
   enType = (tenType)u8Value;
   return oIn;
}

fi_tclOutContext& fi_tcl_e8_SXMFuelType::oWrite(fi_tclOutContext& oOut) const
{
   return oOut.oWrite((tU8)enType);
}

tU32 fi_tcl_e8_RoadClassCode::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 1;
}

tBool fi_tcl_e8_RoadClassCode::operator==(const fi_tcl_e8_RoadClassCode& rfoCmp) const
{
   return enType == rfoCmp.enType;
}

fi_tclInContext& fi_tcl_e8_RoadClassCode::oRead(fi_tclInContext& oIn)
{
   tU8 u8Value;
   oIn >> u8Value;
   enType = (tenType)u8Value;
   return oIn;
}

fi_tclOutContext& fi_tcl_e8_RoadClassCode::oWrite(fi_tclOutContext& oOut) const
{
   return oOut.oWrite((tU8)enType);
}

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
fi_tcl_TMOneCellPortion::fi_tcl_TMOneCellPortion(const fi_tcl_TMOneCellPortion& coRef):fi_tclVisitableTypeBase(coRef)
{
   Offset = coRef.Offset;
   Length = coRef.Length;
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
fi_tcl_TMOneCellPortion& fi_tcl_TMOneCellPortion::operator=(const fi_tcl_TMOneCellPortion& coRef)
{
   if (this == &coRef) return *this;
   Offset = coRef.Offset;
   Length = coRef.Length;
   return *this;
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
tU32 fi_tcl_TMOneCellPortion::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 2;
}

tBool fi_tcl_TMOneCellPortion::operator==(const fi_tcl_TMOneCellPortion& rfoCmp) const
{
   tBool bResult = true;
      bResult = bResult && (Offset == rfoCmp.Offset);
      bResult = bResult && (Length == rfoCmp.Length);
   return bResult;
}

fi_tclInContext& fi_tcl_TMOneCellPortion::oRead(fi_tclInContext& oIn)
{
   oIn >> Offset;
   oIn >> Length;
   return oIn;
}

fi_tclOutContext& fi_tcl_TMOneCellPortion::oWrite(fi_tclOutContext& oOut) const
{
   oOut << Offset;
   oOut << Length;
   return oOut;
}

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
fi_tcl_NavClusterDesc::fi_tcl_NavClusterDesc(const fi_tcl_NavClusterDesc& coRef):fi_tclVisitableTypeBase(coRef)
{
   Level = coRef.Level;
   FileId = coRef.FileId;
   FileOffset = coRef.FileOffset;
   Length = coRef.Length;
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
fi_tcl_NavClusterDesc& fi_tcl_NavClusterDesc::operator=(const fi_tcl_NavClusterDesc& coRef)
{
   if (this == &coRef) return *this;
   Level = coRef.Level;
   FileId = coRef.FileId;
   FileOffset = coRef.FileOffset;
   Length = coRef.Length;
   return *this;
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
tU32 fi_tcl_NavClusterDesc::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 9;
}

tBool fi_tcl_NavClusterDesc::operator==(const fi_tcl_NavClusterDesc& rfoCmp) const
{
   tBool bResult = true;
      bResult = bResult && (Level == rfoCmp.Level);
      bResult = bResult && (FileId == rfoCmp.FileId);
      bResult = bResult && (FileOffset == rfoCmp.FileOffset);
      bResult = bResult && (Length == rfoCmp.Length);
   return bResult;
}

fi_tclInContext& fi_tcl_NavClusterDesc::oRead(fi_tclInContext& oIn)
{
   oIn >> Level;
   oIn >> FileId;
   oIn >> FileOffset;
   oIn >> Length;
   return oIn;
}

fi_tclOutContext& fi_tcl_NavClusterDesc::oWrite(fi_tclOutContext& oOut) const
{
   oOut << Level;
   oOut << FileId;
   oOut << FileOffset;
   oOut << Length;
   return oOut;
}

tU32 fi_tcl_b8_TMCIntersectionPath::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 1;
}

tBool fi_tcl_b8_TMCIntersectionPath::operator==(const fi_tcl_b8_TMCIntersectionPath& rfoCmp) const
{
   return u8Value == rfoCmp.u8Value;
}

fi_tclInContext& fi_tcl_b8_TMCIntersectionPath::oRead(fi_tclInContext& oIn)
{
   return oIn >> u8Value;
}

fi_tclOutContext& fi_tcl_b8_TMCIntersectionPath::oWrite(fi_tclOutContext& oOut) const
{
   return oOut << u8Value;
}

tU32 fi_tcl_e8_TMCIntersectionPathType::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 1;
}

tBool fi_tcl_e8_TMCIntersectionPathType::operator==(const fi_tcl_e8_TMCIntersectionPathType& rfoCmp) const
{
   return enType == rfoCmp.enType;
}

fi_tclInContext& fi_tcl_e8_TMCIntersectionPathType::oRead(fi_tclInContext& oIn)
{
   tU8 u8Value;
   oIn >> u8Value;
   enType = (tenType)u8Value;
   return oIn;
}

fi_tclOutContext& fi_tcl_e8_TMCIntersectionPathType::oWrite(fi_tclOutContext& oOut) const
{
   return oOut.oWrite((tU8)enType);
}

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
fi_tcl_NavOneCellDesc::fi_tcl_NavOneCellDesc(const fi_tcl_NavOneCellDesc& coRef):fi_tclVisitableTypeBase(coRef)
{
   OneCellId = coRef.OneCellId;
   UseDirection = coRef.UseDirection;
   IndexInClusterRefList = coRef.IndexInClusterRefList;
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
fi_tcl_NavOneCellDesc& fi_tcl_NavOneCellDesc::operator=(const fi_tcl_NavOneCellDesc& coRef)
{
   if (this == &coRef) return *this;
   OneCellId = coRef.OneCellId;
   UseDirection = coRef.UseDirection;
   IndexInClusterRefList = coRef.IndexInClusterRefList;
   return *this;
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
tU32 fi_tcl_NavOneCellDesc::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 5;
}

tBool fi_tcl_NavOneCellDesc::operator==(const fi_tcl_NavOneCellDesc& rfoCmp) const
{
   tBool bResult = true;
      bResult = bResult && (OneCellId == rfoCmp.OneCellId);
      bResult = bResult && (UseDirection == rfoCmp.UseDirection);
      bResult = bResult && (IndexInClusterRefList == rfoCmp.IndexInClusterRefList);
   return bResult;
}

fi_tclInContext& fi_tcl_NavOneCellDesc::oRead(fi_tclInContext& oIn)
{
   oIn >> OneCellId;
   oIn >> UseDirection;
   oIn >> IndexInClusterRefList;
   return oIn;
}

fi_tclOutContext& fi_tcl_NavOneCellDesc::oWrite(fi_tclOutContext& oOut) const
{
   oOut << OneCellId;
   oOut << UseDirection;
   oOut << IndexInClusterRefList;
   return oOut;
}

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
fi_tcl_TMIntersectionMatrix::fi_tcl_TMIntersectionMatrix(const fi_tcl_TMIntersectionMatrix& coRef):fi_tclVisitableTypeBase(coRef)
{
   DataLevel = coRef.DataLevel;
   IntoIntersectionOneCells = coRef.IntoIntersectionOneCells;
   OutOfIntersectionOneCells = coRef.OutOfIntersectionOneCells;
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
fi_tcl_TMIntersectionMatrix& fi_tcl_TMIntersectionMatrix::operator=(const fi_tcl_TMIntersectionMatrix& coRef)
{
   if (this == &coRef) return *this;
   DataLevel = coRef.DataLevel;
   IntoIntersectionOneCells = coRef.IntoIntersectionOneCells;
   OutOfIntersectionOneCells = coRef.OutOfIntersectionOneCells;
   return *this;
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
tVoid fi_tcl_TMIntersectionMatrix::vDestroy()
{
   {
      for (tU32 u32Idx = 0; u32Idx < IntoIntersectionOneCells.size(); ++u32Idx)
         IntoIntersectionOneCells[u32Idx].vDestroy();
   }
   IntoIntersectionOneCells.clear();
   {
      for (tU32 u32Idx = 0; u32Idx < OutOfIntersectionOneCells.size(); ++u32Idx)
         OutOfIntersectionOneCells[u32Idx].vDestroy();
   }
   OutOfIntersectionOneCells.clear();
}

tU32 fi_tcl_TMIntersectionMatrix::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 9+IntoIntersectionOneCells.size()*5+OutOfIntersectionOneCells.size()*5;
}

tBool fi_tcl_TMIntersectionMatrix::operator==(const fi_tcl_TMIntersectionMatrix& rfoCmp) const
{
   tBool bResult = true;
      bResult = bResult && (DataLevel == rfoCmp.DataLevel);
      bResult = bResult && (IntoIntersectionOneCells.size() == rfoCmp.IntoIntersectionOneCells.size());
      if (bResult)
      {
         for (tU32 u32Idx = 0; bResult && (u32Idx < IntoIntersectionOneCells.size()); ++u32Idx)
            bResult = bResult && (IntoIntersectionOneCells[u32Idx] == rfoCmp.IntoIntersectionOneCells[u32Idx]);
      }
      bResult = bResult && (OutOfIntersectionOneCells.size() == rfoCmp.OutOfIntersectionOneCells.size());
      if (bResult)
      {
         for (tU32 u32Idx = 0; bResult && (u32Idx < OutOfIntersectionOneCells.size()); ++u32Idx)
            bResult = bResult && (OutOfIntersectionOneCells[u32Idx] == rfoCmp.OutOfIntersectionOneCells[u32Idx]);
      }
   return bResult;
}

fi_tclInContext& fi_tcl_TMIntersectionMatrix::oRead(fi_tclInContext& oIn)
{
   oIn >> DataLevel;
   {
      tU32 u32Length;
      tU32 u32Idx;
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
      for (u32Idx = 0; u32Idx < IntoIntersectionOneCells.size(); ++u32Idx)
      {
         IntoIntersectionOneCells[u32Idx].vDestroy();
      }
#endif // !VARIANT_S_FTR_ENABLE_DEEP_COPY
      oIn >> u32Length;
      IntoIntersectionOneCells.resize(u32Length);
      for (u32Idx = 0; u32Idx < u32Length; ++u32Idx)
      {
         oIn >> IntoIntersectionOneCells[u32Idx];
      }
   }
   {
      tU32 u32Length;
      tU32 u32Idx;
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
      for (u32Idx = 0; u32Idx < OutOfIntersectionOneCells.size(); ++u32Idx)
      {
         OutOfIntersectionOneCells[u32Idx].vDestroy();
      }
#endif // !VARIANT_S_FTR_ENABLE_DEEP_COPY
      oIn >> u32Length;
      OutOfIntersectionOneCells.resize(u32Length);
      for (u32Idx = 0; u32Idx < u32Length; ++u32Idx)
      {
         oIn >> OutOfIntersectionOneCells[u32Idx];
      }
   }
   return oIn;
}

fi_tclOutContext& fi_tcl_TMIntersectionMatrix::oWrite(fi_tclOutContext& oOut) const
{
   oOut << DataLevel;
   oOut << (tU32)IntoIntersectionOneCells.size();
   {
      for (tU32 u32Idx = 0; u32Idx < IntoIntersectionOneCells.size(); ++u32Idx)
         oOut << IntoIntersectionOneCells[u32Idx];
   }
   oOut << (tU32)OutOfIntersectionOneCells.size();
   {
      for (tU32 u32Idx = 0; u32Idx < OutOfIntersectionOneCells.size(); ++u32Idx)
         oOut << OutOfIntersectionOneCells[u32Idx];
   }
   return oOut;
}

tU32 fi_tcl_s16_EMU::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 2;
}

tBool fi_tcl_s16_EMU::operator==(const fi_tcl_s16_EMU& rfoCmp) const
{
   return s16Value == rfoCmp.s16Value;
}

fi_tclInContext& fi_tcl_s16_EMU::oRead(fi_tclInContext& oIn)
{
   return oIn >> s16Value;
}

fi_tclOutContext& fi_tcl_s16_EMU::oWrite(fi_tclOutContext& oOut) const
{
   return oOut << s16Value;
}

tU32 fi_tcl_s32_MEMU::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 4;
}

tBool fi_tcl_s32_MEMU::operator==(const fi_tcl_s32_MEMU& rfoCmp) const
{
   return s32Value == rfoCmp.s32Value;
}

fi_tclInContext& fi_tcl_s32_MEMU::oRead(fi_tclInContext& oIn)
{
   return oIn >> s32Value;
}

fi_tclOutContext& fi_tcl_s32_MEMU::oWrite(fi_tclOutContext& oOut) const
{
   return oOut << s32Value;
}

tU32 fi_tcl_s16_MEMUSecond::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 2;
}

tBool fi_tcl_s16_MEMUSecond::operator==(const fi_tcl_s16_MEMUSecond& rfoCmp) const
{
   return s16Value == rfoCmp.s16Value;
}

fi_tclInContext& fi_tcl_s16_MEMUSecond::oRead(fi_tclInContext& oIn)
{
   return oIn >> s16Value;
}

fi_tclOutContext& fi_tcl_s16_MEMUSecond::oWrite(fi_tclOutContext& oOut) const
{
   return oOut << s16Value;
}

tU32 fi_tcl_s16_EAU::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 2;
}

tBool fi_tcl_s16_EAU::operator==(const fi_tcl_s16_EAU& rfoCmp) const
{
   return s16Value == rfoCmp.s16Value;
}

fi_tclInContext& fi_tcl_s16_EAU::oRead(fi_tclInContext& oIn)
{
   return oIn >> s16Value;
}

fi_tclOutContext& fi_tcl_s16_EAU::oWrite(fi_tclOutContext& oOut) const
{
   return oOut << s16Value;
}

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
fi_tcl_NavPlainPathListSet::fi_tcl_NavPlainPathListSet(const fi_tcl_NavPlainPathListSet& coRef):fi_tclVisitableTypeBase(coRef)
{
   Cluster = coRef.Cluster;
   OneCell = coRef.OneCell;
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
fi_tcl_NavPlainPathListSet& fi_tcl_NavPlainPathListSet::operator=(const fi_tcl_NavPlainPathListSet& coRef)
{
   if (this == &coRef) return *this;
   Cluster = coRef.Cluster;
   OneCell = coRef.OneCell;
   return *this;
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
tVoid fi_tcl_NavPlainPathListSet::vDestroy()
{
   {
      for (tU32 u32Idx = 0; u32Idx < Cluster.size(); ++u32Idx)
         Cluster[u32Idx].vDestroy();
   }
   Cluster.clear();
   {
      for (tU32 u32Idx = 0; u32Idx < OneCell.size(); ++u32Idx)
         OneCell[u32Idx].vDestroy();
   }
   OneCell.clear();
}

tU32 fi_tcl_NavPlainPathListSet::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 8+Cluster.size()*9+OneCell.size()*5;
}

tBool fi_tcl_NavPlainPathListSet::operator==(const fi_tcl_NavPlainPathListSet& rfoCmp) const
{
   tBool bResult = true;
      bResult = bResult && (Cluster.size() == rfoCmp.Cluster.size());
      if (bResult)
      {
         for (tU32 u32Idx = 0; bResult && (u32Idx < Cluster.size()); ++u32Idx)
            bResult = bResult && (Cluster[u32Idx] == rfoCmp.Cluster[u32Idx]);
      }
      bResult = bResult && (OneCell.size() == rfoCmp.OneCell.size());
      if (bResult)
      {
         for (tU32 u32Idx = 0; bResult && (u32Idx < OneCell.size()); ++u32Idx)
            bResult = bResult && (OneCell[u32Idx] == rfoCmp.OneCell[u32Idx]);
      }
   return bResult;
}

fi_tclInContext& fi_tcl_NavPlainPathListSet::oRead(fi_tclInContext& oIn)
{
   {
      tU32 u32Length;
      tU32 u32Idx;
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
      for (u32Idx = 0; u32Idx < Cluster.size(); ++u32Idx)
      {
         Cluster[u32Idx].vDestroy();
      }
#endif // !VARIANT_S_FTR_ENABLE_DEEP_COPY
      oIn >> u32Length;
      Cluster.resize(u32Length);
      for (u32Idx = 0; u32Idx < u32Length; ++u32Idx)
      {
         oIn >> Cluster[u32Idx];
      }
   }
   {
      tU32 u32Length;
      tU32 u32Idx;
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
      for (u32Idx = 0; u32Idx < OneCell.size(); ++u32Idx)
      {
         OneCell[u32Idx].vDestroy();
      }
#endif // !VARIANT_S_FTR_ENABLE_DEEP_COPY
      oIn >> u32Length;
      OneCell.resize(u32Length);
      for (u32Idx = 0; u32Idx < u32Length; ++u32Idx)
      {
         oIn >> OneCell[u32Idx];
      }
   }
   return oIn;
}

fi_tclOutContext& fi_tcl_NavPlainPathListSet::oWrite(fi_tclOutContext& oOut) const
{
   oOut << (tU32)Cluster.size();
   {
      for (tU32 u32Idx = 0; u32Idx < Cluster.size(); ++u32Idx)
         oOut << Cluster[u32Idx];
   }
   oOut << (tU32)OneCell.size();
   {
      for (tU32 u32Idx = 0; u32Idx < OneCell.size(); ++u32Idx)
         oOut << OneCell[u32Idx];
   }
   return oOut;
}

tU32 fi_tcl_s32_EMU::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 4;
}

tBool fi_tcl_s32_EMU::operator==(const fi_tcl_s32_EMU& rfoCmp) const
{
   return s32Value == rfoCmp.s32Value;
}

fi_tclInContext& fi_tcl_s32_EMU::oRead(fi_tclInContext& oIn)
{
   return oIn >> s32Value;
}

fi_tclOutContext& fi_tcl_s32_EMU::oWrite(fi_tclOutContext& oOut) const
{
   return oOut << s32Value;
}

tU32 fi_tcl_b32_RoadProperty::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 4;
}

tBool fi_tcl_b32_RoadProperty::operator==(const fi_tcl_b32_RoadProperty& rfoCmp) const
{
   return u32Value == rfoCmp.u32Value;
}

fi_tclInContext& fi_tcl_b32_RoadProperty::oRead(fi_tclInContext& oIn)
{
   return oIn >> u32Value;
}

fi_tclOutContext& fi_tcl_b32_RoadProperty::oWrite(fi_tclOutContext& oOut) const
{
   tU32 temp = u32Value;
   if (!(9 <= oOut.u16GetMajorVersion()))
      temp &= ~FI_C_U32_BIT_ISGATEWAY;
   if (!(7 <= oOut.u16GetMajorVersion()))
      temp &= ~FI_C_U32_BIT_ISNOTCOVEREDWITHTRUCKATTRIBUTES;
   if (!(25 <= oOut.u16GetMajorVersion()))
      temp &= ~FI_C_U32_BIT_ISAUTOTRAIN;
   if (!(32 <= oOut.u16GetMajorVersion()))
      temp &= ~FI_C_U32_BIT_ISUNPAVEDROAD;
   return oOut << temp;
}

tU32 fi_tcl_e8_PathType::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 1;
}

tBool fi_tcl_e8_PathType::operator==(const fi_tcl_e8_PathType& rfoCmp) const
{
   return enType == rfoCmp.enType;
}

fi_tclInContext& fi_tcl_e8_PathType::oRead(fi_tclInContext& oIn)
{
   tU8 u8Value;
   oIn >> u8Value;
   enType = (tenType)u8Value;
   return oIn;
}

fi_tclOutContext& fi_tcl_e8_PathType::oWrite(fi_tclOutContext& oOut) const
{
   return oOut.oWrite((tU8)enType);
}

tU32 fi_tcl_s16_CurvatureValue::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 2;
}

tBool fi_tcl_s16_CurvatureValue::operator==(const fi_tcl_s16_CurvatureValue& rfoCmp) const
{
   return s16Value == rfoCmp.s16Value;
}

fi_tclInContext& fi_tcl_s16_CurvatureValue::oRead(fi_tclInContext& oIn)
{
   return oIn >> s16Value;
}

fi_tclOutContext& fi_tcl_s16_CurvatureValue::oWrite(fi_tclOutContext& oOut) const
{
   return oOut << s16Value;
}

tU32 fi_tcl_e8_EntryPointState::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 1;
}

tBool fi_tcl_e8_EntryPointState::operator==(const fi_tcl_e8_EntryPointState& rfoCmp) const
{
   return enType == rfoCmp.enType;
}

fi_tclInContext& fi_tcl_e8_EntryPointState::oRead(fi_tclInContext& oIn)
{
   tU8 u8Value;
   oIn >> u8Value;
   enType = (tenType)u8Value;
   return oIn;
}

fi_tclOutContext& fi_tcl_e8_EntryPointState::oWrite(fi_tclOutContext& oOut) const
{
   return oOut.oWrite((tU8)enType);
}

tU32 fi_tcl_u32_Resistance::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 4;
}

tBool fi_tcl_u32_Resistance::operator==(const fi_tcl_u32_Resistance& rfoCmp) const
{
   return u32Value == rfoCmp.u32Value;
}

fi_tclInContext& fi_tcl_u32_Resistance::oRead(fi_tclInContext& oIn)
{
   return oIn >> u32Value;
}

fi_tclOutContext& fi_tcl_u32_Resistance::oWrite(fi_tclOutContext& oOut) const
{
   return oOut << u32Value;
}

tU32 fi_tcl_e8_NavStreetType::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 1;
}

tBool fi_tcl_e8_NavStreetType::operator==(const fi_tcl_e8_NavStreetType& rfoCmp) const
{
   return enType == rfoCmp.enType;
}

fi_tclInContext& fi_tcl_e8_NavStreetType::oRead(fi_tclInContext& oIn)
{
   tU8 u8Value;
   oIn >> u8Value;
   enType = (tenType)u8Value;
   return oIn;
}

fi_tclOutContext& fi_tcl_e8_NavStreetType::oWrite(fi_tclOutContext& oOut) const
{
   return oOut.oWrite((tU8)enType);
}

tU32 fi_tcl_e8_RoadNetworkClass::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 1;
}

tBool fi_tcl_e8_RoadNetworkClass::operator==(const fi_tcl_e8_RoadNetworkClass& rfoCmp) const
{
   return enType == rfoCmp.enType;
}

fi_tclInContext& fi_tcl_e8_RoadNetworkClass::oRead(fi_tclInContext& oIn)
{
   tU8 u8Value;
   oIn >> u8Value;
   enType = (tenType)u8Value;
   return oIn;
}

fi_tclOutContext& fi_tcl_e8_RoadNetworkClass::oWrite(fi_tclOutContext& oOut) const
{
   return oOut.oWrite((tU8)enType);
}

tU32 fi_tcl_e8_RoadInfoPriority::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 1;
}

tBool fi_tcl_e8_RoadInfoPriority::operator==(const fi_tcl_e8_RoadInfoPriority& rfoCmp) const
{
   return enType == rfoCmp.enType;
}

fi_tclInContext& fi_tcl_e8_RoadInfoPriority::oRead(fi_tclInContext& oIn)
{
   tU8 u8Value;
   oIn >> u8Value;
   enType = (tenType)u8Value;
   return oIn;
}

fi_tclOutContext& fi_tcl_e8_RoadInfoPriority::oWrite(fi_tclOutContext& oOut) const
{
   return oOut.oWrite((tU8)enType);
}

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
fi_tcl_NavRoadInfoProperty::fi_tcl_NavRoadInfoProperty(const fi_tcl_NavRoadInfoProperty& coRef):fi_tclVisitableTypeBase(coRef)
{
   IndexInRoadNameList = coRef.IndexInRoadNameList;
   IndexInRoadNumberList = coRef.IndexInRoadNumberList;
   IndexInMapDescList = coRef.IndexInMapDescList;
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
fi_tcl_NavRoadInfoProperty& fi_tcl_NavRoadInfoProperty::operator=(const fi_tcl_NavRoadInfoProperty& coRef)
{
   if (this == &coRef) return *this;
   IndexInRoadNameList = coRef.IndexInRoadNameList;
   IndexInRoadNumberList = coRef.IndexInRoadNumberList;
   IndexInMapDescList = coRef.IndexInMapDescList;
   return *this;
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
tU32 fi_tcl_NavRoadInfoProperty::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 6;
}

tBool fi_tcl_NavRoadInfoProperty::operator==(const fi_tcl_NavRoadInfoProperty& rfoCmp) const
{
   tBool bResult = true;
      bResult = bResult && (IndexInRoadNameList == rfoCmp.IndexInRoadNameList);
      bResult = bResult && (IndexInRoadNumberList == rfoCmp.IndexInRoadNumberList);
      bResult = bResult && (IndexInMapDescList == rfoCmp.IndexInMapDescList);
   return bResult;
}

fi_tclInContext& fi_tcl_NavRoadInfoProperty::oRead(fi_tclInContext& oIn)
{
   oIn >> IndexInRoadNameList;
   oIn >> IndexInRoadNumberList;
   oIn >> IndexInMapDescList;
   return oIn;
}

fi_tclOutContext& fi_tcl_NavRoadInfoProperty::oWrite(fi_tclOutContext& oOut) const
{
   oOut << IndexInRoadNameList;
   oOut << IndexInRoadNumberList;
   oOut << IndexInMapDescList;
   return oOut;
}

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
fi_tcl_NavRoadInfoDesc::fi_tcl_NavRoadInfoDesc(const fi_tcl_NavRoadInfoDesc& coRef):fi_tclVisitableTypeBase(coRef)
{
   OneCellDesc = coRef.OneCellDesc;
   OneCellProperty = coRef.OneCellProperty;
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
fi_tcl_NavRoadInfoDesc& fi_tcl_NavRoadInfoDesc::operator=(const fi_tcl_NavRoadInfoDesc& coRef)
{
   if (this == &coRef) return *this;
   OneCellDesc = coRef.OneCellDesc;
   OneCellProperty = coRef.OneCellProperty;
   return *this;
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
tVoid fi_tcl_NavRoadInfoDesc::vDestroy()
{
   OneCellDesc.vDestroy(); 
   OneCellProperty.vDestroy(); 
}

tU32 fi_tcl_NavRoadInfoDesc::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 11;
}

tBool fi_tcl_NavRoadInfoDesc::operator==(const fi_tcl_NavRoadInfoDesc& rfoCmp) const
{
   tBool bResult = true;
      bResult = bResult && (OneCellDesc == rfoCmp.OneCellDesc);
      bResult = bResult && (OneCellProperty == rfoCmp.OneCellProperty);
   return bResult;
}

fi_tclInContext& fi_tcl_NavRoadInfoDesc::oRead(fi_tclInContext& oIn)
{
   oIn >> OneCellDesc;
   oIn >> OneCellProperty;
   return oIn;
}

fi_tclOutContext& fi_tcl_NavRoadInfoDesc::oWrite(fi_tclOutContext& oOut) const
{
   oOut << OneCellDesc;
   oOut << OneCellProperty;
   return oOut;
}

tU32 fi_tcl_e8_RoadInfoRefListType::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 1;
}

tBool fi_tcl_e8_RoadInfoRefListType::operator==(const fi_tcl_e8_RoadInfoRefListType& rfoCmp) const
{
   return enType == rfoCmp.enType;
}

fi_tclInContext& fi_tcl_e8_RoadInfoRefListType::oRead(fi_tclInContext& oIn)
{
   tU8 u8Value;
   oIn >> u8Value;
   enType = (tenType)u8Value;
   return oIn;
}

fi_tclOutContext& fi_tcl_e8_RoadInfoRefListType::oWrite(fi_tclOutContext& oOut) const
{
   return oOut.oWrite((tU8)enType);
}

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
fi_tcl_NavRoadInfoRefListUnionType::fi_tcl_NavRoadInfoRefListUnionType(const fi_tcl_NavRoadInfoRefListUnionType& coRef):fi_tclVisitableTypeBase(coRef)
{
   InfoListsType = coRef.InfoListsType;
   if  (coRef.poInfoListsData)
   {
      switch(InfoListsType.enType)
      {
      case fi_tcl_e8_RoadInfoRefListType::FI_EN_T_RESERVED:
         poInfoListsData = OSAL_NEW fi_tcl_Reserved((const fi_tcl_Reserved&)*coRef.poInfoListsData);
         break;
      case fi_tcl_e8_RoadInfoRefListType::FI_EN_T_ROADNAMEREFLIST:
         poInfoListsData = OSAL_NEW fi_tcl_RoadNameRefList((const fi_tcl_RoadNameRefList&)*coRef.poInfoListsData);
         break;
      case fi_tcl_e8_RoadInfoRefListType::FI_EN_T_ROADNUMBERREFLIST:
         poInfoListsData = OSAL_NEW fi_tcl_RoadNumberRefList((const fi_tcl_RoadNumberRefList&)*coRef.poInfoListsData);
         break;
      default:
         poInfoListsData = OSAL_NULL;
      }
   }
   else
   {
      poInfoListsData = OSAL_NULL;
   }
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
fi_tcl_NavRoadInfoRefListUnionType& fi_tcl_NavRoadInfoRefListUnionType::operator=(const fi_tcl_NavRoadInfoRefListUnionType& coRef)
{
   if (this == &coRef) return *this;
   OSAL_DELETE poInfoListsData;
   InfoListsType = coRef.InfoListsType;
   if  (coRef.poInfoListsData)
   {
      switch(InfoListsType.enType)
      {
      case fi_tcl_e8_RoadInfoRefListType::FI_EN_T_RESERVED:
         poInfoListsData = OSAL_NEW fi_tcl_Reserved((const fi_tcl_Reserved&)*coRef.poInfoListsData);
         break;
      case fi_tcl_e8_RoadInfoRefListType::FI_EN_T_ROADNAMEREFLIST:
         poInfoListsData = OSAL_NEW fi_tcl_RoadNameRefList((const fi_tcl_RoadNameRefList&)*coRef.poInfoListsData);
         break;
      case fi_tcl_e8_RoadInfoRefListType::FI_EN_T_ROADNUMBERREFLIST:
         poInfoListsData = OSAL_NEW fi_tcl_RoadNumberRefList((const fi_tcl_RoadNumberRefList&)*coRef.poInfoListsData);
         break;
      default:
         poInfoListsData = OSAL_NULL;
      }
   }
   else
   {
      poInfoListsData = OSAL_NULL;
   }
   return *this;
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
fi_tcl_NavRoadInfoRefListUnionType::~fi_tcl_NavRoadInfoRefListUnionType()
{
   OSAL_DELETE poInfoListsData;
   poInfoListsData = OSAL_NULL;
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
tVoid fi_tcl_NavRoadInfoRefListUnionType::vDestroy()
{
   if (poInfoListsData)
   {
      poInfoListsData->vDestroy();
      OSAL_DELETE poInfoListsData;
      poInfoListsData = OSAL_NULL;
   }
}

tU32 fi_tcl_NavRoadInfoRefListUnionType::u32GetSize(tU16 u16MajorVersion) const
{
   return 1+(poInfoListsData?poInfoListsData->u32GetSize(u16MajorVersion):0);
}

tBool fi_tcl_NavRoadInfoRefListUnionType::operator==(const fi_tcl_NavRoadInfoRefListUnionType& rfoCmp) const
{
   tBool bResult = true;
   bResult = bResult && (InfoListsType == rfoCmp.InfoListsType);
   if (bResult && poInfoListsData && rfoCmp.poInfoListsData) 
   {
      switch (InfoListsType.enType)
      {
      case fi_tcl_e8_RoadInfoRefListType::FI_EN_T_RESERVED:
         bResult = bResult && (*(const fi_tcl_Reserved*)poInfoListsData == *(const fi_tcl_Reserved*)rfoCmp.poInfoListsData); //lint !e826
      break;
      case fi_tcl_e8_RoadInfoRefListType::FI_EN_T_ROADNAMEREFLIST:
         bResult = bResult && (*(const fi_tcl_RoadNameRefList*)poInfoListsData == *(const fi_tcl_RoadNameRefList*)rfoCmp.poInfoListsData); //lint !e826
      break;
      case fi_tcl_e8_RoadInfoRefListType::FI_EN_T_ROADNUMBERREFLIST:
         bResult = bResult && (*(const fi_tcl_RoadNumberRefList*)poInfoListsData == *(const fi_tcl_RoadNumberRefList*)rfoCmp.poInfoListsData); //lint !e826
      break;
      }
   }
   else
   {
      bResult = bResult && (poInfoListsData == rfoCmp.poInfoListsData);
   }
   return bResult;
}

fi_tclInContext& fi_tcl_NavRoadInfoRefListUnionType::oRead(fi_tclInContext& oIn)
{
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   OSAL_DELETE poInfoListsData;
#else
   if (poInfoListsData)
   {
      poInfoListsData->vDestroy();
      OSAL_DELETE poInfoListsData;
   }
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
   oIn >> InfoListsType;
   switch(InfoListsType.enType)
   {
   case fi_tcl_e8_RoadInfoRefListType::FI_EN_T_RESERVED:
      poInfoListsData = OSAL_NEW fi_tcl_Reserved;
      break;
   case fi_tcl_e8_RoadInfoRefListType::FI_EN_T_ROADNAMEREFLIST:
      poInfoListsData = OSAL_NEW fi_tcl_RoadNameRefList;
      break;
   case fi_tcl_e8_RoadInfoRefListType::FI_EN_T_ROADNUMBERREFLIST:
      poInfoListsData = OSAL_NEW fi_tcl_RoadNumberRefList;
      break;
   default:
      oIn.Invalidate();
      poInfoListsData = OSAL_NULL;
   }
   if (poInfoListsData && oIn.bIsValid())
      poInfoListsData->oRead(oIn);
   else
      oIn.Invalidate();
   return oIn;
}

fi_tclOutContext& fi_tcl_NavRoadInfoRefListUnionType::oWrite(fi_tclOutContext& oOut) const
{
   oOut << InfoListsType;
   if (poInfoListsData)
   {
      poInfoListsData->oWrite(oOut);
   }
   else
   {
      oOut.Invalidate();
   }
   return oOut;
}

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
fi_tcl_NavRoadInfoListSet::fi_tcl_NavRoadInfoListSet(const fi_tcl_NavRoadInfoListSet& coRef):fi_tclVisitableTypeBase(coRef)
{
   Cluster = coRef.Cluster;
   RoadInfo = coRef.RoadInfo;
   NavRoadInfoUnionLists = coRef.NavRoadInfoUnionLists;
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
fi_tcl_NavRoadInfoListSet& fi_tcl_NavRoadInfoListSet::operator=(const fi_tcl_NavRoadInfoListSet& coRef)
{
   if (this == &coRef) return *this;
   Cluster = coRef.Cluster;
   RoadInfo = coRef.RoadInfo;
   NavRoadInfoUnionLists = coRef.NavRoadInfoUnionLists;
   return *this;
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
tVoid fi_tcl_NavRoadInfoListSet::vDestroy()
{
   {
      for (tU32 u32Idx = 0; u32Idx < Cluster.size(); ++u32Idx)
         Cluster[u32Idx].vDestroy();
   }
   Cluster.clear();
   {
      for (tU32 u32Idx = 0; u32Idx < RoadInfo.size(); ++u32Idx)
         RoadInfo[u32Idx].vDestroy();
   }
   RoadInfo.clear();
   {
      for (tU32 u32Idx = 0; u32Idx < NavRoadInfoUnionLists.size(); ++u32Idx)
         NavRoadInfoUnionLists[u32Idx].vDestroy();
   }
   NavRoadInfoUnionLists.clear();
}

tU32 fi_tcl_NavRoadInfoListSet::u32GetSize(tU16 u16MajorVersion) const
{
   tU32 u32DynamicSize = 0;
   tU32 u32ListIdx;
   for (u32ListIdx = 0; u32ListIdx < NavRoadInfoUnionLists.size(); ++u32ListIdx)
      u32DynamicSize += NavRoadInfoUnionLists[u32ListIdx].u32GetSize(u16MajorVersion);
   return u32DynamicSize+12+Cluster.size()*9+RoadInfo.size()*11;
}

tBool fi_tcl_NavRoadInfoListSet::operator==(const fi_tcl_NavRoadInfoListSet& rfoCmp) const
{
   tBool bResult = true;
      bResult = bResult && (Cluster.size() == rfoCmp.Cluster.size());
      if (bResult)
      {
         for (tU32 u32Idx = 0; bResult && (u32Idx < Cluster.size()); ++u32Idx)
            bResult = bResult && (Cluster[u32Idx] == rfoCmp.Cluster[u32Idx]);
      }
      bResult = bResult && (RoadInfo.size() == rfoCmp.RoadInfo.size());
      if (bResult)
      {
         for (tU32 u32Idx = 0; bResult && (u32Idx < RoadInfo.size()); ++u32Idx)
            bResult = bResult && (RoadInfo[u32Idx] == rfoCmp.RoadInfo[u32Idx]);
      }
      bResult = bResult && (NavRoadInfoUnionLists.size() == rfoCmp.NavRoadInfoUnionLists.size());
      if (bResult)
      {
         for (tU32 u32Idx = 0; bResult && (u32Idx < NavRoadInfoUnionLists.size()); ++u32Idx)
            bResult = bResult && (NavRoadInfoUnionLists[u32Idx] == rfoCmp.NavRoadInfoUnionLists[u32Idx]);
      }
   return bResult;
}

fi_tclInContext& fi_tcl_NavRoadInfoListSet::oRead(fi_tclInContext& oIn)
{
   {
      tU32 u32Length;
      tU32 u32Idx;
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
      for (u32Idx = 0; u32Idx < Cluster.size(); ++u32Idx)
      {
         Cluster[u32Idx].vDestroy();
      }
#endif // !VARIANT_S_FTR_ENABLE_DEEP_COPY
      oIn >> u32Length;
      Cluster.resize(u32Length);
      for (u32Idx = 0; u32Idx < u32Length; ++u32Idx)
      {
         oIn >> Cluster[u32Idx];
      }
   }
   {
      tU32 u32Length;
      tU32 u32Idx;
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
      for (u32Idx = 0; u32Idx < RoadInfo.size(); ++u32Idx)
      {
         RoadInfo[u32Idx].vDestroy();
      }
#endif // !VARIANT_S_FTR_ENABLE_DEEP_COPY
      oIn >> u32Length;
      RoadInfo.resize(u32Length);
      for (u32Idx = 0; u32Idx < u32Length; ++u32Idx)
      {
         oIn >> RoadInfo[u32Idx];
      }
   }
   {
      tU32 u32Length;
      tU32 u32Idx;
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
      for (u32Idx = 0; u32Idx < NavRoadInfoUnionLists.size(); ++u32Idx)
      {
         NavRoadInfoUnionLists[u32Idx].vDestroy();
      }
#endif // !VARIANT_S_FTR_ENABLE_DEEP_COPY
      oIn >> u32Length;
      NavRoadInfoUnionLists.resize(u32Length);
      for (u32Idx = 0; u32Idx < u32Length; ++u32Idx)
      {
         oIn >> NavRoadInfoUnionLists[u32Idx];
      }
   }
   return oIn;
}

fi_tclOutContext& fi_tcl_NavRoadInfoListSet::oWrite(fi_tclOutContext& oOut) const
{
   oOut << (tU32)Cluster.size();
   {
      for (tU32 u32Idx = 0; u32Idx < Cluster.size(); ++u32Idx)
         oOut << Cluster[u32Idx];
   }
   oOut << (tU32)RoadInfo.size();
   {
      for (tU32 u32Idx = 0; u32Idx < RoadInfo.size(); ++u32Idx)
         oOut << RoadInfo[u32Idx];
   }
   oOut << (tU32)NavRoadInfoUnionLists.size();
   {
      for (tU32 u32Idx = 0; u32Idx < NavRoadInfoUnionLists.size(); ++u32Idx)
         oOut << NavRoadInfoUnionLists[u32Idx];
   }
   return oOut;
}

tU32 fi_tcl_e8_RoadPathInfoCategory::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 1;
}

tBool fi_tcl_e8_RoadPathInfoCategory::operator==(const fi_tcl_e8_RoadPathInfoCategory& rfoCmp) const
{
   return enType == rfoCmp.enType;
}

fi_tclInContext& fi_tcl_e8_RoadPathInfoCategory::oRead(fi_tclInContext& oIn)
{
   tU8 u8Value;
   oIn >> u8Value;
   enType = (tenType)u8Value;
   return oIn;
}

fi_tclOutContext& fi_tcl_e8_RoadPathInfoCategory::oWrite(fi_tclOutContext& oOut) const
{
   fi_tcl_e8_RoadPathInfoCategory::tenType enData = enType;
   if ((enData == FI_EN_T_TIMEZONELISTSET) && !(21 <= oOut.u16GetMajorVersion()))
   {
      enData = FI_EN_T_RESERVED;
   }
   if ((enData == FI_EN_T_TOLLBOOTHLISTSET) && !(34 <= oOut.u16GetMajorVersion()))
   {
      enData = FI_EN_T_RESERVED;
   }
   if ((enData == FI_EN_T_REQUIREDPERMISSIONLISTSET) && !(9 <= oOut.u16GetMajorVersion()))
   {
      enData = FI_EN_T_RESERVED;
   }
   if ((enData == FI_EN_T_SHAPEPOINTLISTSET) && !(9 <= oOut.u16GetMajorVersion()))
   {
      enData = FI_EN_T_RESERVED;
   }
   if ((enData == FI_EN_T_DIRECTIONINFOLISTSET) && !(9 <= oOut.u16GetMajorVersion()))
   {
      enData = FI_EN_T_RESERVED;
   }
   return oOut.oWrite((tU8)enData);
}

tU32 fi_tcl_e8_CrossroadInfoCategory::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 1;
}

tBool fi_tcl_e8_CrossroadInfoCategory::operator==(const fi_tcl_e8_CrossroadInfoCategory& rfoCmp) const
{
   return enType == rfoCmp.enType;
}

fi_tclInContext& fi_tcl_e8_CrossroadInfoCategory::oRead(fi_tclInContext& oIn)
{
   tU8 u8Value;
   oIn >> u8Value;
   enType = (tenType)u8Value;
   return oIn;
}

fi_tclOutContext& fi_tcl_e8_CrossroadInfoCategory::oWrite(fi_tclOutContext& oOut) const
{
   return oOut.oWrite((tU8)enType);
}

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
fi_tcl_RoadPathInfoCategory::fi_tcl_RoadPathInfoCategory(const fi_tcl_RoadPathInfoCategory& coRef):fi_tclVisitableTypeBase(coRef)
{
   CategoryType = coRef.CategoryType;
   if  (coRef.poCategoryData)
   {
      switch(CategoryType.enType)
      {
      case fi_tcl_e8_RoadPathInfoCategory::FI_EN_T_RESERVED:
         poCategoryData = OSAL_NEW fi_tcl_Reserved((const fi_tcl_Reserved&)*coRef.poCategoryData);
         break;
      case fi_tcl_e8_RoadPathInfoCategory::FI_EN_T_COUNTRYNAMELISTSET:
         poCategoryData = OSAL_NEW fi_tcl_CountryNameListSet((const fi_tcl_CountryNameListSet&)*coRef.poCategoryData);
         break;
      case fi_tcl_e8_RoadPathInfoCategory::FI_EN_T_STATENAMELISTSET:
         poCategoryData = OSAL_NEW fi_tcl_StateNameListSet((const fi_tcl_StateNameListSet&)*coRef.poCategoryData);
         break;
      case fi_tcl_e8_RoadPathInfoCategory::FI_EN_T_COUNTYNAMELISTSET:
         poCategoryData = OSAL_NEW fi_tcl_CountyNameListSet((const fi_tcl_CountyNameListSet&)*coRef.poCategoryData);
         break;
      case fi_tcl_e8_RoadPathInfoCategory::FI_EN_T_CITYNAMELISTSET:
         poCategoryData = OSAL_NEW fi_tcl_CityNameListSet((const fi_tcl_CityNameListSet&)*coRef.poCategoryData);
         break;
      case fi_tcl_e8_RoadPathInfoCategory::FI_EN_T_CITYDISTRICTNAMELISTSET:
         poCategoryData = OSAL_NEW fi_tcl_CityDistrictNameListSet((const fi_tcl_CityDistrictNameListSet&)*coRef.poCategoryData);
         break;
      case fi_tcl_e8_RoadPathInfoCategory::FI_EN_T_BUILDUPAREANAMELISTSET:
         poCategoryData = OSAL_NEW fi_tcl_BuildUpAreaNameListSet((const fi_tcl_BuildUpAreaNameListSet&)*coRef.poCategoryData);
         break;
      case fi_tcl_e8_RoadPathInfoCategory::FI_EN_T_ROADNAMELISTSET:
         poCategoryData = OSAL_NEW fi_tcl_RoadNameListSet((const fi_tcl_RoadNameListSet&)*coRef.poCategoryData);
         break;
      case fi_tcl_e8_RoadPathInfoCategory::FI_EN_T_ROADNUMBERLISTSET:
         poCategoryData = OSAL_NEW fi_tcl_RoadNumberListSet((const fi_tcl_RoadNumberListSet&)*coRef.poCategoryData);
         break;
      case fi_tcl_e8_RoadPathInfoCategory::FI_EN_T_MAPDESCRIPTIONLISTSET:
         poCategoryData = OSAL_NEW fi_tcl_MapDescriptionListSet((const fi_tcl_MapDescriptionListSet&)*coRef.poCategoryData);
         break;
      case fi_tcl_e8_RoadPathInfoCategory::FI_EN_T_SIGNPOSTLISTSET:
         poCategoryData = OSAL_NEW fi_tcl_SignPostListSet((const fi_tcl_SignPostListSet&)*coRef.poCategoryData);
         break;
      case fi_tcl_e8_RoadPathInfoCategory::FI_EN_T_EXTRADESCLISTSET:
         poCategoryData = OSAL_NEW fi_tcl_ExtraDescListSet((const fi_tcl_ExtraDescListSet&)*coRef.poCategoryData);
         break;
      case fi_tcl_e8_RoadPathInfoCategory::FI_EN_T_DATADESCLISTSET:
         poCategoryData = OSAL_NEW fi_tcl_DataDescListSet((const fi_tcl_DataDescListSet&)*coRef.poCategoryData);
         break;
      case fi_tcl_e8_RoadPathInfoCategory::FI_EN_T_NAVINTERSECTIONLISTSET:
         poCategoryData = OSAL_NEW fi_tcl_NavIntersectionListSet((const fi_tcl_NavIntersectionListSet&)*coRef.poCategoryData);
         break;
      case fi_tcl_e8_RoadPathInfoCategory::FI_EN_T_TRAFFICSIGNLISTSET:
         poCategoryData = OSAL_NEW fi_tcl_TrafficSignListSet((const fi_tcl_TrafficSignListSet&)*coRef.poCategoryData);
         break;
      case fi_tcl_e8_RoadPathInfoCategory::FI_EN_T_POILISTSET:
         poCategoryData = OSAL_NEW fi_tcl_POIListSet((const fi_tcl_POIListSet&)*coRef.poCategoryData);
         break;
      case fi_tcl_e8_RoadPathInfoCategory::FI_EN_T_LANEINFOLISTSET:
         poCategoryData = OSAL_NEW fi_tcl_LaneInfoListSet((const fi_tcl_LaneInfoListSet&)*coRef.poCategoryData);
         break;
      case fi_tcl_e8_RoadPathInfoCategory::FI_EN_T_DIRECTIONINFOLISTSET:
         poCategoryData = OSAL_NEW fi_tcl_DirectionInfoListSet((const fi_tcl_DirectionInfoListSet&)*coRef.poCategoryData);
         break;
      case fi_tcl_e8_RoadPathInfoCategory::FI_EN_T_SHAPEPOINTLISTSET:
         poCategoryData = OSAL_NEW fi_tcl_ShapePointListSet((const fi_tcl_ShapePointListSet&)*coRef.poCategoryData);
         break;
      case fi_tcl_e8_RoadPathInfoCategory::FI_EN_T_REQUIREDPERMISSIONLISTSET:
         poCategoryData = OSAL_NEW fi_tcl_RequiredPermissionListSet((const fi_tcl_RequiredPermissionListSet&)*coRef.poCategoryData);
         break;
      case fi_tcl_e8_RoadPathInfoCategory::FI_EN_T_TOLLBOOTHLISTSET:
         poCategoryData = OSAL_NEW fi_tcl_TollBoothListSet((const fi_tcl_TollBoothListSet&)*coRef.poCategoryData);
         break;
      case fi_tcl_e8_RoadPathInfoCategory::FI_EN_T_TIMEZONELISTSET:
         poCategoryData = OSAL_NEW fi_tcl_TimeZoneListSet((const fi_tcl_TimeZoneListSet&)*coRef.poCategoryData);
         break;
      default:
         poCategoryData = OSAL_NULL;
      }
   }
   else
   {
      poCategoryData = OSAL_NULL;
   }
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
fi_tcl_RoadPathInfoCategory& fi_tcl_RoadPathInfoCategory::operator=(const fi_tcl_RoadPathInfoCategory& coRef)
{
   if (this == &coRef) return *this;
   OSAL_DELETE poCategoryData;
   CategoryType = coRef.CategoryType;
   if  (coRef.poCategoryData)
   {
      switch(CategoryType.enType)
      {
      case fi_tcl_e8_RoadPathInfoCategory::FI_EN_T_RESERVED:
         poCategoryData = OSAL_NEW fi_tcl_Reserved((const fi_tcl_Reserved&)*coRef.poCategoryData);
         break;
      case fi_tcl_e8_RoadPathInfoCategory::FI_EN_T_COUNTRYNAMELISTSET:
         poCategoryData = OSAL_NEW fi_tcl_CountryNameListSet((const fi_tcl_CountryNameListSet&)*coRef.poCategoryData);
         break;
      case fi_tcl_e8_RoadPathInfoCategory::FI_EN_T_STATENAMELISTSET:
         poCategoryData = OSAL_NEW fi_tcl_StateNameListSet((const fi_tcl_StateNameListSet&)*coRef.poCategoryData);
         break;
      case fi_tcl_e8_RoadPathInfoCategory::FI_EN_T_COUNTYNAMELISTSET:
         poCategoryData = OSAL_NEW fi_tcl_CountyNameListSet((const fi_tcl_CountyNameListSet&)*coRef.poCategoryData);
         break;
      case fi_tcl_e8_RoadPathInfoCategory::FI_EN_T_CITYNAMELISTSET:
         poCategoryData = OSAL_NEW fi_tcl_CityNameListSet((const fi_tcl_CityNameListSet&)*coRef.poCategoryData);
         break;
      case fi_tcl_e8_RoadPathInfoCategory::FI_EN_T_CITYDISTRICTNAMELISTSET:
         poCategoryData = OSAL_NEW fi_tcl_CityDistrictNameListSet((const fi_tcl_CityDistrictNameListSet&)*coRef.poCategoryData);
         break;
      case fi_tcl_e8_RoadPathInfoCategory::FI_EN_T_BUILDUPAREANAMELISTSET:
         poCategoryData = OSAL_NEW fi_tcl_BuildUpAreaNameListSet((const fi_tcl_BuildUpAreaNameListSet&)*coRef.poCategoryData);
         break;
      case fi_tcl_e8_RoadPathInfoCategory::FI_EN_T_ROADNAMELISTSET:
         poCategoryData = OSAL_NEW fi_tcl_RoadNameListSet((const fi_tcl_RoadNameListSet&)*coRef.poCategoryData);
         break;
      case fi_tcl_e8_RoadPathInfoCategory::FI_EN_T_ROADNUMBERLISTSET:
         poCategoryData = OSAL_NEW fi_tcl_RoadNumberListSet((const fi_tcl_RoadNumberListSet&)*coRef.poCategoryData);
         break;
      case fi_tcl_e8_RoadPathInfoCategory::FI_EN_T_MAPDESCRIPTIONLISTSET:
         poCategoryData = OSAL_NEW fi_tcl_MapDescriptionListSet((const fi_tcl_MapDescriptionListSet&)*coRef.poCategoryData);
         break;
      case fi_tcl_e8_RoadPathInfoCategory::FI_EN_T_SIGNPOSTLISTSET:
         poCategoryData = OSAL_NEW fi_tcl_SignPostListSet((const fi_tcl_SignPostListSet&)*coRef.poCategoryData);
         break;
      case fi_tcl_e8_RoadPathInfoCategory::FI_EN_T_EXTRADESCLISTSET:
         poCategoryData = OSAL_NEW fi_tcl_ExtraDescListSet((const fi_tcl_ExtraDescListSet&)*coRef.poCategoryData);
         break;
      case fi_tcl_e8_RoadPathInfoCategory::FI_EN_T_DATADESCLISTSET:
         poCategoryData = OSAL_NEW fi_tcl_DataDescListSet((const fi_tcl_DataDescListSet&)*coRef.poCategoryData);
         break;
      case fi_tcl_e8_RoadPathInfoCategory::FI_EN_T_NAVINTERSECTIONLISTSET:
         poCategoryData = OSAL_NEW fi_tcl_NavIntersectionListSet((const fi_tcl_NavIntersectionListSet&)*coRef.poCategoryData);
         break;
      case fi_tcl_e8_RoadPathInfoCategory::FI_EN_T_TRAFFICSIGNLISTSET:
         poCategoryData = OSAL_NEW fi_tcl_TrafficSignListSet((const fi_tcl_TrafficSignListSet&)*coRef.poCategoryData);
         break;
      case fi_tcl_e8_RoadPathInfoCategory::FI_EN_T_POILISTSET:
         poCategoryData = OSAL_NEW fi_tcl_POIListSet((const fi_tcl_POIListSet&)*coRef.poCategoryData);
         break;
      case fi_tcl_e8_RoadPathInfoCategory::FI_EN_T_LANEINFOLISTSET:
         poCategoryData = OSAL_NEW fi_tcl_LaneInfoListSet((const fi_tcl_LaneInfoListSet&)*coRef.poCategoryData);
         break;
      case fi_tcl_e8_RoadPathInfoCategory::FI_EN_T_DIRECTIONINFOLISTSET:
         poCategoryData = OSAL_NEW fi_tcl_DirectionInfoListSet((const fi_tcl_DirectionInfoListSet&)*coRef.poCategoryData);
         break;
      case fi_tcl_e8_RoadPathInfoCategory::FI_EN_T_SHAPEPOINTLISTSET:
         poCategoryData = OSAL_NEW fi_tcl_ShapePointListSet((const fi_tcl_ShapePointListSet&)*coRef.poCategoryData);
         break;
      case fi_tcl_e8_RoadPathInfoCategory::FI_EN_T_REQUIREDPERMISSIONLISTSET:
         poCategoryData = OSAL_NEW fi_tcl_RequiredPermissionListSet((const fi_tcl_RequiredPermissionListSet&)*coRef.poCategoryData);
         break;
      case fi_tcl_e8_RoadPathInfoCategory::FI_EN_T_TOLLBOOTHLISTSET:
         poCategoryData = OSAL_NEW fi_tcl_TollBoothListSet((const fi_tcl_TollBoothListSet&)*coRef.poCategoryData);
         break;
      case fi_tcl_e8_RoadPathInfoCategory::FI_EN_T_TIMEZONELISTSET:
         poCategoryData = OSAL_NEW fi_tcl_TimeZoneListSet((const fi_tcl_TimeZoneListSet&)*coRef.poCategoryData);
         break;
      default:
         poCategoryData = OSAL_NULL;
      }
   }
   else
   {
      poCategoryData = OSAL_NULL;
   }
   return *this;
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
fi_tcl_RoadPathInfoCategory::~fi_tcl_RoadPathInfoCategory()
{
   OSAL_DELETE poCategoryData;
   poCategoryData = OSAL_NULL;
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
tVoid fi_tcl_RoadPathInfoCategory::vDestroy()
{
   if (poCategoryData)
   {
      poCategoryData->vDestroy();
      OSAL_DELETE poCategoryData;
      poCategoryData = OSAL_NULL;
   }
}

tU32 fi_tcl_RoadPathInfoCategory::u32GetSize(tU16 u16MajorVersion) const
{
   tU32 u32DynamicSize = 0;
   if (CategoryType.enType == fi_tcl_e8_RoadPathInfoCategory::FI_EN_T_RESERVED)
      u32DynamicSize += (poCategoryData?poCategoryData->u32GetSize(u16MajorVersion):0);
   if (CategoryType.enType == fi_tcl_e8_RoadPathInfoCategory::FI_EN_T_COUNTRYNAMELISTSET)
      u32DynamicSize += (poCategoryData?poCategoryData->u32GetSize(u16MajorVersion):0);
   if (CategoryType.enType == fi_tcl_e8_RoadPathInfoCategory::FI_EN_T_STATENAMELISTSET)
      u32DynamicSize += (poCategoryData?poCategoryData->u32GetSize(u16MajorVersion):0);
   if (CategoryType.enType == fi_tcl_e8_RoadPathInfoCategory::FI_EN_T_COUNTYNAMELISTSET)
      u32DynamicSize += (poCategoryData?poCategoryData->u32GetSize(u16MajorVersion):0);
   if (CategoryType.enType == fi_tcl_e8_RoadPathInfoCategory::FI_EN_T_CITYNAMELISTSET)
      u32DynamicSize += (poCategoryData?poCategoryData->u32GetSize(u16MajorVersion):0);
   if (CategoryType.enType == fi_tcl_e8_RoadPathInfoCategory::FI_EN_T_CITYDISTRICTNAMELISTSET)
      u32DynamicSize += (poCategoryData?poCategoryData->u32GetSize(u16MajorVersion):0);
   if (CategoryType.enType == fi_tcl_e8_RoadPathInfoCategory::FI_EN_T_BUILDUPAREANAMELISTSET)
      u32DynamicSize += (poCategoryData?poCategoryData->u32GetSize(u16MajorVersion):0);
   if (CategoryType.enType == fi_tcl_e8_RoadPathInfoCategory::FI_EN_T_ROADNAMELISTSET)
      u32DynamicSize += (poCategoryData?poCategoryData->u32GetSize(u16MajorVersion):0);
   if (CategoryType.enType == fi_tcl_e8_RoadPathInfoCategory::FI_EN_T_ROADNUMBERLISTSET)
      u32DynamicSize += (poCategoryData?poCategoryData->u32GetSize(u16MajorVersion):0);
   if (CategoryType.enType == fi_tcl_e8_RoadPathInfoCategory::FI_EN_T_MAPDESCRIPTIONLISTSET)
      u32DynamicSize += (poCategoryData?poCategoryData->u32GetSize(u16MajorVersion):0);
   if (CategoryType.enType == fi_tcl_e8_RoadPathInfoCategory::FI_EN_T_SIGNPOSTLISTSET)
      u32DynamicSize += (poCategoryData?poCategoryData->u32GetSize(u16MajorVersion):0);
   if (CategoryType.enType == fi_tcl_e8_RoadPathInfoCategory::FI_EN_T_EXTRADESCLISTSET)
      u32DynamicSize += (poCategoryData?poCategoryData->u32GetSize(u16MajorVersion):0);
   if (CategoryType.enType == fi_tcl_e8_RoadPathInfoCategory::FI_EN_T_DATADESCLISTSET)
      u32DynamicSize += (poCategoryData?poCategoryData->u32GetSize(u16MajorVersion):0);
   if (CategoryType.enType == fi_tcl_e8_RoadPathInfoCategory::FI_EN_T_NAVINTERSECTIONLISTSET)
      u32DynamicSize += (poCategoryData?poCategoryData->u32GetSize(u16MajorVersion):0);
   if (CategoryType.enType == fi_tcl_e8_RoadPathInfoCategory::FI_EN_T_TRAFFICSIGNLISTSET)
      u32DynamicSize += (poCategoryData?poCategoryData->u32GetSize(u16MajorVersion):0);
   if (CategoryType.enType == fi_tcl_e8_RoadPathInfoCategory::FI_EN_T_POILISTSET)
      u32DynamicSize += (poCategoryData?poCategoryData->u32GetSize(u16MajorVersion):0);
   if (CategoryType.enType == fi_tcl_e8_RoadPathInfoCategory::FI_EN_T_LANEINFOLISTSET)
      u32DynamicSize += (poCategoryData?poCategoryData->u32GetSize(u16MajorVersion):0);
   if ((CategoryType.enType == fi_tcl_e8_RoadPathInfoCategory::FI_EN_T_DIRECTIONINFOLISTSET) &&
       (9 <= u16MajorVersion))
      u32DynamicSize += (poCategoryData?poCategoryData->u32GetSize(u16MajorVersion):0);
   if ((CategoryType.enType == fi_tcl_e8_RoadPathInfoCategory::FI_EN_T_SHAPEPOINTLISTSET) &&
       (9 <= u16MajorVersion))
      u32DynamicSize += (poCategoryData?poCategoryData->u32GetSize(u16MajorVersion):0);
   if ((CategoryType.enType == fi_tcl_e8_RoadPathInfoCategory::FI_EN_T_REQUIREDPERMISSIONLISTSET) &&
       (9 <= u16MajorVersion))
      u32DynamicSize += (poCategoryData?poCategoryData->u32GetSize(u16MajorVersion):0);
   if ((CategoryType.enType == fi_tcl_e8_RoadPathInfoCategory::FI_EN_T_TOLLBOOTHLISTSET) &&
       (34 <= u16MajorVersion))
      u32DynamicSize += (poCategoryData?poCategoryData->u32GetSize(u16MajorVersion):0);
   if ((CategoryType.enType == fi_tcl_e8_RoadPathInfoCategory::FI_EN_T_TIMEZONELISTSET) &&
       (21 <= u16MajorVersion))
      u32DynamicSize += (poCategoryData?poCategoryData->u32GetSize(u16MajorVersion):0);
   return u32DynamicSize+1;
}

tBool fi_tcl_RoadPathInfoCategory::operator==(const fi_tcl_RoadPathInfoCategory& rfoCmp) const
{
   tBool bResult = true;
   bResult = bResult && (CategoryType == rfoCmp.CategoryType);
   if (bResult && poCategoryData && rfoCmp.poCategoryData) 
   {
      switch (CategoryType.enType)
      {
      case fi_tcl_e8_RoadPathInfoCategory::FI_EN_T_RESERVED:
         bResult = bResult && (*(const fi_tcl_Reserved*)poCategoryData == *(const fi_tcl_Reserved*)rfoCmp.poCategoryData); //lint !e826
      break;
      case fi_tcl_e8_RoadPathInfoCategory::FI_EN_T_COUNTRYNAMELISTSET:
         bResult = bResult && (*(const fi_tcl_CountryNameListSet*)poCategoryData == *(const fi_tcl_CountryNameListSet*)rfoCmp.poCategoryData); //lint !e826
      break;
      case fi_tcl_e8_RoadPathInfoCategory::FI_EN_T_STATENAMELISTSET:
         bResult = bResult && (*(const fi_tcl_StateNameListSet*)poCategoryData == *(const fi_tcl_StateNameListSet*)rfoCmp.poCategoryData); //lint !e826
      break;
      case fi_tcl_e8_RoadPathInfoCategory::FI_EN_T_COUNTYNAMELISTSET:
         bResult = bResult && (*(const fi_tcl_CountyNameListSet*)poCategoryData == *(const fi_tcl_CountyNameListSet*)rfoCmp.poCategoryData); //lint !e826
      break;
      case fi_tcl_e8_RoadPathInfoCategory::FI_EN_T_CITYNAMELISTSET:
         bResult = bResult && (*(const fi_tcl_CityNameListSet*)poCategoryData == *(const fi_tcl_CityNameListSet*)rfoCmp.poCategoryData); //lint !e826
      break;
      case fi_tcl_e8_RoadPathInfoCategory::FI_EN_T_CITYDISTRICTNAMELISTSET:
         bResult = bResult && (*(const fi_tcl_CityDistrictNameListSet*)poCategoryData == *(const fi_tcl_CityDistrictNameListSet*)rfoCmp.poCategoryData); //lint !e826
      break;
      case fi_tcl_e8_RoadPathInfoCategory::FI_EN_T_BUILDUPAREANAMELISTSET:
         bResult = bResult && (*(const fi_tcl_BuildUpAreaNameListSet*)poCategoryData == *(const fi_tcl_BuildUpAreaNameListSet*)rfoCmp.poCategoryData); //lint !e826
      break;
      case fi_tcl_e8_RoadPathInfoCategory::FI_EN_T_ROADNAMELISTSET:
         bResult = bResult && (*(const fi_tcl_RoadNameListSet*)poCategoryData == *(const fi_tcl_RoadNameListSet*)rfoCmp.poCategoryData); //lint !e826
      break;
      case fi_tcl_e8_RoadPathInfoCategory::FI_EN_T_ROADNUMBERLISTSET:
         bResult = bResult && (*(const fi_tcl_RoadNumberListSet*)poCategoryData == *(const fi_tcl_RoadNumberListSet*)rfoCmp.poCategoryData); //lint !e826
      break;
      case fi_tcl_e8_RoadPathInfoCategory::FI_EN_T_MAPDESCRIPTIONLISTSET:
         bResult = bResult && (*(const fi_tcl_MapDescriptionListSet*)poCategoryData == *(const fi_tcl_MapDescriptionListSet*)rfoCmp.poCategoryData); //lint !e826
      break;
      case fi_tcl_e8_RoadPathInfoCategory::FI_EN_T_SIGNPOSTLISTSET:
         bResult = bResult && (*(const fi_tcl_SignPostListSet*)poCategoryData == *(const fi_tcl_SignPostListSet*)rfoCmp.poCategoryData); //lint !e826
      break;
      case fi_tcl_e8_RoadPathInfoCategory::FI_EN_T_EXTRADESCLISTSET:
         bResult = bResult && (*(const fi_tcl_ExtraDescListSet*)poCategoryData == *(const fi_tcl_ExtraDescListSet*)rfoCmp.poCategoryData); //lint !e826
      break;
      case fi_tcl_e8_RoadPathInfoCategory::FI_EN_T_DATADESCLISTSET:
         bResult = bResult && (*(const fi_tcl_DataDescListSet*)poCategoryData == *(const fi_tcl_DataDescListSet*)rfoCmp.poCategoryData); //lint !e826
      break;
      case fi_tcl_e8_RoadPathInfoCategory::FI_EN_T_NAVINTERSECTIONLISTSET:
         bResult = bResult && (*(const fi_tcl_NavIntersectionListSet*)poCategoryData == *(const fi_tcl_NavIntersectionListSet*)rfoCmp.poCategoryData); //lint !e826
      break;
      case fi_tcl_e8_RoadPathInfoCategory::FI_EN_T_TRAFFICSIGNLISTSET:
         bResult = bResult && (*(const fi_tcl_TrafficSignListSet*)poCategoryData == *(const fi_tcl_TrafficSignListSet*)rfoCmp.poCategoryData); //lint !e826
      break;
      case fi_tcl_e8_RoadPathInfoCategory::FI_EN_T_POILISTSET:
         bResult = bResult && (*(const fi_tcl_POIListSet*)poCategoryData == *(const fi_tcl_POIListSet*)rfoCmp.poCategoryData); //lint !e826
      break;
      case fi_tcl_e8_RoadPathInfoCategory::FI_EN_T_LANEINFOLISTSET:
         bResult = bResult && (*(const fi_tcl_LaneInfoListSet*)poCategoryData == *(const fi_tcl_LaneInfoListSet*)rfoCmp.poCategoryData); //lint !e826
      break;
      case fi_tcl_e8_RoadPathInfoCategory::FI_EN_T_DIRECTIONINFOLISTSET:
         bResult = bResult && (*(const fi_tcl_DirectionInfoListSet*)poCategoryData == *(const fi_tcl_DirectionInfoListSet*)rfoCmp.poCategoryData); //lint !e826
      break;
      case fi_tcl_e8_RoadPathInfoCategory::FI_EN_T_SHAPEPOINTLISTSET:
         bResult = bResult && (*(const fi_tcl_ShapePointListSet*)poCategoryData == *(const fi_tcl_ShapePointListSet*)rfoCmp.poCategoryData); //lint !e826
      break;
      case fi_tcl_e8_RoadPathInfoCategory::FI_EN_T_REQUIREDPERMISSIONLISTSET:
         bResult = bResult && (*(const fi_tcl_RequiredPermissionListSet*)poCategoryData == *(const fi_tcl_RequiredPermissionListSet*)rfoCmp.poCategoryData); //lint !e826
      break;
      case fi_tcl_e8_RoadPathInfoCategory::FI_EN_T_TOLLBOOTHLISTSET:
         bResult = bResult && (*(const fi_tcl_TollBoothListSet*)poCategoryData == *(const fi_tcl_TollBoothListSet*)rfoCmp.poCategoryData); //lint !e826
      break;
      case fi_tcl_e8_RoadPathInfoCategory::FI_EN_T_TIMEZONELISTSET:
         bResult = bResult && (*(const fi_tcl_TimeZoneListSet*)poCategoryData == *(const fi_tcl_TimeZoneListSet*)rfoCmp.poCategoryData); //lint !e826
      break;
      }
   }
   else
   {
      bResult = bResult && (poCategoryData == rfoCmp.poCategoryData);
   }
   return bResult;
}

fi_tclInContext& fi_tcl_RoadPathInfoCategory::oRead(fi_tclInContext& oIn)
{
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   OSAL_DELETE poCategoryData;
#else
   if (poCategoryData)
   {
      poCategoryData->vDestroy();
      OSAL_DELETE poCategoryData;
   }
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
   oIn >> CategoryType;
   switch(CategoryType.enType)
   {
   case fi_tcl_e8_RoadPathInfoCategory::FI_EN_T_RESERVED:
      poCategoryData = OSAL_NEW fi_tcl_Reserved;
      break;
   case fi_tcl_e8_RoadPathInfoCategory::FI_EN_T_COUNTRYNAMELISTSET:
      poCategoryData = OSAL_NEW fi_tcl_CountryNameListSet;
      break;
   case fi_tcl_e8_RoadPathInfoCategory::FI_EN_T_STATENAMELISTSET:
      poCategoryData = OSAL_NEW fi_tcl_StateNameListSet;
      break;
   case fi_tcl_e8_RoadPathInfoCategory::FI_EN_T_COUNTYNAMELISTSET:
      poCategoryData = OSAL_NEW fi_tcl_CountyNameListSet;
      break;
   case fi_tcl_e8_RoadPathInfoCategory::FI_EN_T_CITYNAMELISTSET:
      poCategoryData = OSAL_NEW fi_tcl_CityNameListSet;
      break;
   case fi_tcl_e8_RoadPathInfoCategory::FI_EN_T_CITYDISTRICTNAMELISTSET:
      poCategoryData = OSAL_NEW fi_tcl_CityDistrictNameListSet;
      break;
   case fi_tcl_e8_RoadPathInfoCategory::FI_EN_T_BUILDUPAREANAMELISTSET:
      poCategoryData = OSAL_NEW fi_tcl_BuildUpAreaNameListSet;
      break;
   case fi_tcl_e8_RoadPathInfoCategory::FI_EN_T_ROADNAMELISTSET:
      poCategoryData = OSAL_NEW fi_tcl_RoadNameListSet;
      break;
   case fi_tcl_e8_RoadPathInfoCategory::FI_EN_T_ROADNUMBERLISTSET:
      poCategoryData = OSAL_NEW fi_tcl_RoadNumberListSet;
      break;
   case fi_tcl_e8_RoadPathInfoCategory::FI_EN_T_MAPDESCRIPTIONLISTSET:
      poCategoryData = OSAL_NEW fi_tcl_MapDescriptionListSet;
      break;
   case fi_tcl_e8_RoadPathInfoCategory::FI_EN_T_SIGNPOSTLISTSET:
      poCategoryData = OSAL_NEW fi_tcl_SignPostListSet;
      break;
   case fi_tcl_e8_RoadPathInfoCategory::FI_EN_T_EXTRADESCLISTSET:
      poCategoryData = OSAL_NEW fi_tcl_ExtraDescListSet;
      break;
   case fi_tcl_e8_RoadPathInfoCategory::FI_EN_T_DATADESCLISTSET:
      poCategoryData = OSAL_NEW fi_tcl_DataDescListSet;
      break;
   case fi_tcl_e8_RoadPathInfoCategory::FI_EN_T_NAVINTERSECTIONLISTSET:
      poCategoryData = OSAL_NEW fi_tcl_NavIntersectionListSet;
      break;
   case fi_tcl_e8_RoadPathInfoCategory::FI_EN_T_TRAFFICSIGNLISTSET:
      poCategoryData = OSAL_NEW fi_tcl_TrafficSignListSet;
      break;
   case fi_tcl_e8_RoadPathInfoCategory::FI_EN_T_POILISTSET:
      poCategoryData = OSAL_NEW fi_tcl_POIListSet;
      break;
   case fi_tcl_e8_RoadPathInfoCategory::FI_EN_T_LANEINFOLISTSET:
      poCategoryData = OSAL_NEW fi_tcl_LaneInfoListSet;
      break;
   case fi_tcl_e8_RoadPathInfoCategory::FI_EN_T_DIRECTIONINFOLISTSET:
      poCategoryData = OSAL_NEW fi_tcl_DirectionInfoListSet;
      break;
   case fi_tcl_e8_RoadPathInfoCategory::FI_EN_T_SHAPEPOINTLISTSET:
      poCategoryData = OSAL_NEW fi_tcl_ShapePointListSet;
      break;
   case fi_tcl_e8_RoadPathInfoCategory::FI_EN_T_REQUIREDPERMISSIONLISTSET:
      poCategoryData = OSAL_NEW fi_tcl_RequiredPermissionListSet;
      break;
   case fi_tcl_e8_RoadPathInfoCategory::FI_EN_T_TOLLBOOTHLISTSET:
      poCategoryData = OSAL_NEW fi_tcl_TollBoothListSet;
      break;
   case fi_tcl_e8_RoadPathInfoCategory::FI_EN_T_TIMEZONELISTSET:
      poCategoryData = OSAL_NEW fi_tcl_TimeZoneListSet;
      break;
   default:
      oIn.Invalidate();
      poCategoryData = OSAL_NULL;
   }
   if (poCategoryData && oIn.bIsValid())
      poCategoryData->oRead(oIn);
   else
      oIn.Invalidate();
   return oIn;
}

fi_tclOutContext& fi_tcl_RoadPathInfoCategory::oWrite(fi_tclOutContext& oOut) const
{
   oOut << CategoryType;
   if (poCategoryData)
   {
      if (CategoryType.enType == fi_tcl_e8_RoadPathInfoCategory::FI_EN_T_RESERVED)
      {
         poCategoryData->oWrite(oOut);
      }
      if (CategoryType.enType == fi_tcl_e8_RoadPathInfoCategory::FI_EN_T_COUNTRYNAMELISTSET)
      {
         poCategoryData->oWrite(oOut);
      }
      if (CategoryType.enType == fi_tcl_e8_RoadPathInfoCategory::FI_EN_T_STATENAMELISTSET)
      {
         poCategoryData->oWrite(oOut);
      }
      if (CategoryType.enType == fi_tcl_e8_RoadPathInfoCategory::FI_EN_T_COUNTYNAMELISTSET)
      {
         poCategoryData->oWrite(oOut);
      }
      if (CategoryType.enType == fi_tcl_e8_RoadPathInfoCategory::FI_EN_T_CITYNAMELISTSET)
      {
         poCategoryData->oWrite(oOut);
      }
      if (CategoryType.enType == fi_tcl_e8_RoadPathInfoCategory::FI_EN_T_CITYDISTRICTNAMELISTSET)
      {
         poCategoryData->oWrite(oOut);
      }
      if (CategoryType.enType == fi_tcl_e8_RoadPathInfoCategory::FI_EN_T_BUILDUPAREANAMELISTSET)
      {
         poCategoryData->oWrite(oOut);
      }
      if (CategoryType.enType == fi_tcl_e8_RoadPathInfoCategory::FI_EN_T_ROADNAMELISTSET)
      {
         poCategoryData->oWrite(oOut);
      }
      if (CategoryType.enType == fi_tcl_e8_RoadPathInfoCategory::FI_EN_T_ROADNUMBERLISTSET)
      {
         poCategoryData->oWrite(oOut);
      }
      if (CategoryType.enType == fi_tcl_e8_RoadPathInfoCategory::FI_EN_T_MAPDESCRIPTIONLISTSET)
      {
         poCategoryData->oWrite(oOut);
      }
      if (CategoryType.enType == fi_tcl_e8_RoadPathInfoCategory::FI_EN_T_SIGNPOSTLISTSET)
      {
         poCategoryData->oWrite(oOut);
      }
      if (CategoryType.enType == fi_tcl_e8_RoadPathInfoCategory::FI_EN_T_EXTRADESCLISTSET)
      {
         poCategoryData->oWrite(oOut);
      }
      if (CategoryType.enType == fi_tcl_e8_RoadPathInfoCategory::FI_EN_T_DATADESCLISTSET)
      {
         poCategoryData->oWrite(oOut);
      }
      if (CategoryType.enType == fi_tcl_e8_RoadPathInfoCategory::FI_EN_T_NAVINTERSECTIONLISTSET)
      {
         poCategoryData->oWrite(oOut);
      }
      if (CategoryType.enType == fi_tcl_e8_RoadPathInfoCategory::FI_EN_T_TRAFFICSIGNLISTSET)
      {
         poCategoryData->oWrite(oOut);
      }
      if (CategoryType.enType == fi_tcl_e8_RoadPathInfoCategory::FI_EN_T_POILISTSET)
      {
         poCategoryData->oWrite(oOut);
      }
      if (CategoryType.enType == fi_tcl_e8_RoadPathInfoCategory::FI_EN_T_LANEINFOLISTSET)
      {
         poCategoryData->oWrite(oOut);
      }
      if (CategoryType.enType == fi_tcl_e8_RoadPathInfoCategory::FI_EN_T_DIRECTIONINFOLISTSET)
      {
         if (!(9 <= oOut.u16GetMajorVersion()))
         {
            fi_tcl_Reserved oDefault;
            oOut << oDefault;
         }
         else
         {
            poCategoryData->oWrite(oOut);
         }
      }
      if (CategoryType.enType == fi_tcl_e8_RoadPathInfoCategory::FI_EN_T_SHAPEPOINTLISTSET)
      {
         if (!(9 <= oOut.u16GetMajorVersion()))
         {
            fi_tcl_Reserved oDefault;
            oOut << oDefault;
         }
         else
         {
            poCategoryData->oWrite(oOut);
         }
      }
      if (CategoryType.enType == fi_tcl_e8_RoadPathInfoCategory::FI_EN_T_REQUIREDPERMISSIONLISTSET)
      {
         if (!(9 <= oOut.u16GetMajorVersion()))
         {
            fi_tcl_Reserved oDefault;
            oOut << oDefault;
         }
         else
         {
            poCategoryData->oWrite(oOut);
         }
      }
      if (CategoryType.enType == fi_tcl_e8_RoadPathInfoCategory::FI_EN_T_TOLLBOOTHLISTSET)
      {
         if (!(34 <= oOut.u16GetMajorVersion()))
         {
            fi_tcl_Reserved oDefault;
            oOut << oDefault;
         }
         else
         {
            poCategoryData->oWrite(oOut);
         }
      }
      if (CategoryType.enType == fi_tcl_e8_RoadPathInfoCategory::FI_EN_T_TIMEZONELISTSET)
      {
         if (!(21 <= oOut.u16GetMajorVersion()))
         {
            fi_tcl_Reserved oDefault;
            oOut << oDefault;
         }
         else
         {
            poCategoryData->oWrite(oOut);
         }
      }
   }
   else
   {
      oOut.Invalidate();
   }
   return oOut;
}

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
fi_tcl_RoadPathInfoListSet::fi_tcl_RoadPathInfoListSet(const fi_tcl_RoadPathInfoListSet& coRef):fi_tclVisitableTypeBase(coRef)
{
   RoadPathListSet = coRef.RoadPathListSet;
   RoadPathInfoCategoryList = coRef.RoadPathInfoCategoryList;
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
fi_tcl_RoadPathInfoListSet& fi_tcl_RoadPathInfoListSet::operator=(const fi_tcl_RoadPathInfoListSet& coRef)
{
   if (this == &coRef) return *this;
   RoadPathListSet = coRef.RoadPathListSet;
   RoadPathInfoCategoryList = coRef.RoadPathInfoCategoryList;
   return *this;
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
tVoid fi_tcl_RoadPathInfoListSet::vDestroy()
{
   RoadPathListSet.vDestroy(); 
   {
      for (tU32 u32Idx = 0; u32Idx < RoadPathInfoCategoryList.size(); ++u32Idx)
         RoadPathInfoCategoryList[u32Idx].vDestroy();
   }
   RoadPathInfoCategoryList.clear();
}

tU32 fi_tcl_RoadPathInfoListSet::u32GetSize(tU16 u16MajorVersion) const
{
   tU32 u32DynamicSize = 0;
   tU32 u32ListIdx;
   for (u32ListIdx = 0; u32ListIdx < RoadPathInfoCategoryList.size(); ++u32ListIdx)
      u32DynamicSize += RoadPathInfoCategoryList[u32ListIdx].u32GetSize(u16MajorVersion);
   return u32DynamicSize+4+RoadPathListSet.u32GetSize(u16MajorVersion);
}

tBool fi_tcl_RoadPathInfoListSet::operator==(const fi_tcl_RoadPathInfoListSet& rfoCmp) const
{
   tBool bResult = true;
      bResult = bResult && (RoadPathListSet == rfoCmp.RoadPathListSet);
      bResult = bResult && (RoadPathInfoCategoryList.size() == rfoCmp.RoadPathInfoCategoryList.size());
      if (bResult)
      {
         for (tU32 u32Idx = 0; bResult && (u32Idx < RoadPathInfoCategoryList.size()); ++u32Idx)
            bResult = bResult && (RoadPathInfoCategoryList[u32Idx] == rfoCmp.RoadPathInfoCategoryList[u32Idx]);
      }
   return bResult;
}

fi_tclInContext& fi_tcl_RoadPathInfoListSet::oRead(fi_tclInContext& oIn)
{
   oIn >> RoadPathListSet;
   {
      tU32 u32Length;
      tU32 u32Idx;
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
      for (u32Idx = 0; u32Idx < RoadPathInfoCategoryList.size(); ++u32Idx)
      {
         RoadPathInfoCategoryList[u32Idx].vDestroy();
      }
#endif // !VARIANT_S_FTR_ENABLE_DEEP_COPY
      oIn >> u32Length;
      RoadPathInfoCategoryList.resize(u32Length);
      for (u32Idx = 0; u32Idx < u32Length; ++u32Idx)
      {
         oIn >> RoadPathInfoCategoryList[u32Idx];
      }
   }
   return oIn;
}

fi_tclOutContext& fi_tcl_RoadPathInfoListSet::oWrite(fi_tclOutContext& oOut) const
{
   oOut << RoadPathListSet;
   oOut << (tU32)RoadPathInfoCategoryList.size();
   {
      for (tU32 u32Idx = 0; u32Idx < RoadPathInfoCategoryList.size(); ++u32Idx)
         oOut << RoadPathInfoCategoryList[u32Idx];
   }
   return oOut;
}

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
fi_tcl_NavTMOneCell::fi_tcl_NavTMOneCell(const fi_tcl_NavTMOneCell& coRef):fi_tclVisitableTypeBase(coRef)
{
   OCDesc = coRef.OCDesc;
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
fi_tcl_NavTMOneCell& fi_tcl_NavTMOneCell::operator=(const fi_tcl_NavTMOneCell& coRef)
{
   if (this == &coRef) return *this;
   OCDesc = coRef.OCDesc;
   return *this;
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
tVoid fi_tcl_NavTMOneCell::vDestroy()
{
   OCDesc.vDestroy(); 
}

tU32 fi_tcl_NavTMOneCell::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 5;
}

tBool fi_tcl_NavTMOneCell::operator==(const fi_tcl_NavTMOneCell& rfoCmp) const
{
   tBool bResult = true;
      bResult = bResult && (OCDesc == rfoCmp.OCDesc);
   return bResult;
}

fi_tclInContext& fi_tcl_NavTMOneCell::oRead(fi_tclInContext& oIn)
{
   oIn >> OCDesc;
   return oIn;
}

fi_tclOutContext& fi_tcl_NavTMOneCell::oWrite(fi_tclOutContext& oOut) const
{
   oOut << OCDesc;
   return oOut;
}

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
fi_tcl_NavTMOneCellListSet::fi_tcl_NavTMOneCellListSet(const fi_tcl_NavTMOneCellListSet& coRef):fi_tclVisitableTypeBase(coRef)
{
   Cluster = coRef.Cluster;
   TMOneCell = coRef.TMOneCell;
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
fi_tcl_NavTMOneCellListSet& fi_tcl_NavTMOneCellListSet::operator=(const fi_tcl_NavTMOneCellListSet& coRef)
{
   if (this == &coRef) return *this;
   Cluster = coRef.Cluster;
   TMOneCell = coRef.TMOneCell;
   return *this;
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
tVoid fi_tcl_NavTMOneCellListSet::vDestroy()
{
   {
      for (tU32 u32Idx = 0; u32Idx < Cluster.size(); ++u32Idx)
         Cluster[u32Idx].vDestroy();
   }
   Cluster.clear();
   {
      for (tU32 u32Idx = 0; u32Idx < TMOneCell.size(); ++u32Idx)
         TMOneCell[u32Idx].vDestroy();
   }
   TMOneCell.clear();
}

tU32 fi_tcl_NavTMOneCellListSet::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 8+Cluster.size()*9+TMOneCell.size()*5;
}

tBool fi_tcl_NavTMOneCellListSet::operator==(const fi_tcl_NavTMOneCellListSet& rfoCmp) const
{
   tBool bResult = true;
      bResult = bResult && (Cluster.size() == rfoCmp.Cluster.size());
      if (bResult)
      {
         for (tU32 u32Idx = 0; bResult && (u32Idx < Cluster.size()); ++u32Idx)
            bResult = bResult && (Cluster[u32Idx] == rfoCmp.Cluster[u32Idx]);
      }
      bResult = bResult && (TMOneCell.size() == rfoCmp.TMOneCell.size());
      if (bResult)
      {
         for (tU32 u32Idx = 0; bResult && (u32Idx < TMOneCell.size()); ++u32Idx)
            bResult = bResult && (TMOneCell[u32Idx] == rfoCmp.TMOneCell[u32Idx]);
      }
   return bResult;
}

fi_tclInContext& fi_tcl_NavTMOneCellListSet::oRead(fi_tclInContext& oIn)
{
   {
      tU32 u32Length;
      tU32 u32Idx;
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
      for (u32Idx = 0; u32Idx < Cluster.size(); ++u32Idx)
      {
         Cluster[u32Idx].vDestroy();
      }
#endif // !VARIANT_S_FTR_ENABLE_DEEP_COPY
      oIn >> u32Length;
      Cluster.resize(u32Length);
      for (u32Idx = 0; u32Idx < u32Length; ++u32Idx)
      {
         oIn >> Cluster[u32Idx];
      }
   }
   {
      tU32 u32Length;
      tU32 u32Idx;
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
      for (u32Idx = 0; u32Idx < TMOneCell.size(); ++u32Idx)
      {
         TMOneCell[u32Idx].vDestroy();
      }
#endif // !VARIANT_S_FTR_ENABLE_DEEP_COPY
      oIn >> u32Length;
      TMOneCell.resize(u32Length);
      for (u32Idx = 0; u32Idx < u32Length; ++u32Idx)
      {
         oIn >> TMOneCell[u32Idx];
      }
   }
   return oIn;
}

fi_tclOutContext& fi_tcl_NavTMOneCellListSet::oWrite(fi_tclOutContext& oOut) const
{
   oOut << (tU32)Cluster.size();
   {
      for (tU32 u32Idx = 0; u32Idx < Cluster.size(); ++u32Idx)
         oOut << Cluster[u32Idx];
   }
   oOut << (tU32)TMOneCell.size();
   {
      for (tU32 u32Idx = 0; u32Idx < TMOneCell.size(); ++u32Idx)
         oOut << TMOneCell[u32Idx];
   }
   return oOut;
}

tU32 fi_tcl_e8_DataAvailable::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 1;
}

tBool fi_tcl_e8_DataAvailable::operator==(const fi_tcl_e8_DataAvailable& rfoCmp) const
{
   return enType == rfoCmp.enType;
}

fi_tclInContext& fi_tcl_e8_DataAvailable::oRead(fi_tclInContext& oIn)
{
   tU8 u8Value;
   oIn >> u8Value;
   enType = (tenType)u8Value;
   return oIn;
}

fi_tclOutContext& fi_tcl_e8_DataAvailable::oWrite(fi_tclOutContext& oOut) const
{
   return oOut.oWrite((tU8)enType);
}

tU32 fi_tcl_e8_NavLocationDescType::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 1;
}

tBool fi_tcl_e8_NavLocationDescType::operator==(const fi_tcl_e8_NavLocationDescType& rfoCmp) const
{
   return enType == rfoCmp.enType;
}

fi_tclInContext& fi_tcl_e8_NavLocationDescType::oRead(fi_tclInContext& oIn)
{
   tU8 u8Value;
   oIn >> u8Value;
   enType = (tenType)u8Value;
   return oIn;
}

fi_tclOutContext& fi_tcl_e8_NavLocationDescType::oWrite(fi_tclOutContext& oOut) const
{
   return oOut.oWrite((tU8)enType);
}

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
fi_tcl_NavLocationDesc::fi_tcl_NavLocationDesc(const fi_tcl_NavLocationDesc& coRef):fi_tclVisitableTypeBase(coRef)
{
   NavLocationDescTypeType = coRef.NavLocationDescTypeType;
   if  (coRef.poNavLocationDescTypeData)
   {
      switch(NavLocationDescTypeType.enType)
      {
      case fi_tcl_e8_NavLocationDescType::FI_EN_T_RESERVED:
         poNavLocationDescTypeData = OSAL_NEW fi_tcl_Reserved((const fi_tcl_Reserved&)*coRef.poNavLocationDescTypeData);
         break;
      case fi_tcl_e8_NavLocationDescType::FI_EN_T_NAVLOCATIONDATADESC:
         poNavLocationDescTypeData = OSAL_NEW fi_tcl_NavLocationDataDesc((const fi_tcl_NavLocationDataDesc&)*coRef.poNavLocationDescTypeData);
         break;
      case fi_tcl_e8_NavLocationDescType::FI_EN_T_NAVAREADESCRIPTIONCIRCLE:
         poNavLocationDescTypeData = OSAL_NEW fi_tcl_NavAreaDescriptionCircle((const fi_tcl_NavAreaDescriptionCircle&)*coRef.poNavLocationDescTypeData);
         break;
      case fi_tcl_e8_NavLocationDescType::FI_EN_T_NAVAREADESCRIPTIONPOLYGON:
         poNavLocationDescTypeData = OSAL_NEW fi_tcl_NavAreaDescriptionPolygon((const fi_tcl_NavAreaDescriptionPolygon&)*coRef.poNavLocationDescTypeData);
         break;
      default:
         poNavLocationDescTypeData = OSAL_NULL;
      }
   }
   else
   {
      poNavLocationDescTypeData = OSAL_NULL;
   }
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
fi_tcl_NavLocationDesc& fi_tcl_NavLocationDesc::operator=(const fi_tcl_NavLocationDesc& coRef)
{
   if (this == &coRef) return *this;
   OSAL_DELETE poNavLocationDescTypeData;
   NavLocationDescTypeType = coRef.NavLocationDescTypeType;
   if  (coRef.poNavLocationDescTypeData)
   {
      switch(NavLocationDescTypeType.enType)
      {
      case fi_tcl_e8_NavLocationDescType::FI_EN_T_RESERVED:
         poNavLocationDescTypeData = OSAL_NEW fi_tcl_Reserved((const fi_tcl_Reserved&)*coRef.poNavLocationDescTypeData);
         break;
      case fi_tcl_e8_NavLocationDescType::FI_EN_T_NAVLOCATIONDATADESC:
         poNavLocationDescTypeData = OSAL_NEW fi_tcl_NavLocationDataDesc((const fi_tcl_NavLocationDataDesc&)*coRef.poNavLocationDescTypeData);
         break;
      case fi_tcl_e8_NavLocationDescType::FI_EN_T_NAVAREADESCRIPTIONCIRCLE:
         poNavLocationDescTypeData = OSAL_NEW fi_tcl_NavAreaDescriptionCircle((const fi_tcl_NavAreaDescriptionCircle&)*coRef.poNavLocationDescTypeData);
         break;
      case fi_tcl_e8_NavLocationDescType::FI_EN_T_NAVAREADESCRIPTIONPOLYGON:
         poNavLocationDescTypeData = OSAL_NEW fi_tcl_NavAreaDescriptionPolygon((const fi_tcl_NavAreaDescriptionPolygon&)*coRef.poNavLocationDescTypeData);
         break;
      default:
         poNavLocationDescTypeData = OSAL_NULL;
      }
   }
   else
   {
      poNavLocationDescTypeData = OSAL_NULL;
   }
   return *this;
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
fi_tcl_NavLocationDesc::~fi_tcl_NavLocationDesc()
{
   OSAL_DELETE poNavLocationDescTypeData;
   poNavLocationDescTypeData = OSAL_NULL;
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
tVoid fi_tcl_NavLocationDesc::vDestroy()
{
   if (poNavLocationDescTypeData)
   {
      poNavLocationDescTypeData->vDestroy();
      OSAL_DELETE poNavLocationDescTypeData;
      poNavLocationDescTypeData = OSAL_NULL;
   }
}

tU32 fi_tcl_NavLocationDesc::u32GetSize(tU16 u16MajorVersion) const
{
   return 1+(poNavLocationDescTypeData?poNavLocationDescTypeData->u32GetSize(u16MajorVersion):0);
}

tBool fi_tcl_NavLocationDesc::operator==(const fi_tcl_NavLocationDesc& rfoCmp) const
{
   tBool bResult = true;
   bResult = bResult && (NavLocationDescTypeType == rfoCmp.NavLocationDescTypeType);
   if (bResult && poNavLocationDescTypeData && rfoCmp.poNavLocationDescTypeData) 
   {
      switch (NavLocationDescTypeType.enType)
      {
      case fi_tcl_e8_NavLocationDescType::FI_EN_T_RESERVED:
         bResult = bResult && (*(const fi_tcl_Reserved*)poNavLocationDescTypeData == *(const fi_tcl_Reserved*)rfoCmp.poNavLocationDescTypeData); //lint !e826
      break;
      case fi_tcl_e8_NavLocationDescType::FI_EN_T_NAVLOCATIONDATADESC:
         bResult = bResult && (*(const fi_tcl_NavLocationDataDesc*)poNavLocationDescTypeData == *(const fi_tcl_NavLocationDataDesc*)rfoCmp.poNavLocationDescTypeData); //lint !e826
      break;
      case fi_tcl_e8_NavLocationDescType::FI_EN_T_NAVAREADESCRIPTIONCIRCLE:
         bResult = bResult && (*(const fi_tcl_NavAreaDescriptionCircle*)poNavLocationDescTypeData == *(const fi_tcl_NavAreaDescriptionCircle*)rfoCmp.poNavLocationDescTypeData); //lint !e826
      break;
      case fi_tcl_e8_NavLocationDescType::FI_EN_T_NAVAREADESCRIPTIONPOLYGON:
         bResult = bResult && (*(const fi_tcl_NavAreaDescriptionPolygon*)poNavLocationDescTypeData == *(const fi_tcl_NavAreaDescriptionPolygon*)rfoCmp.poNavLocationDescTypeData); //lint !e826
      break;
      }
   }
   else
   {
      bResult = bResult && (poNavLocationDescTypeData == rfoCmp.poNavLocationDescTypeData);
   }
   return bResult;
}

fi_tclInContext& fi_tcl_NavLocationDesc::oRead(fi_tclInContext& oIn)
{
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   OSAL_DELETE poNavLocationDescTypeData;
#else
   if (poNavLocationDescTypeData)
   {
      poNavLocationDescTypeData->vDestroy();
      OSAL_DELETE poNavLocationDescTypeData;
   }
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
   oIn >> NavLocationDescTypeType;
   switch(NavLocationDescTypeType.enType)
   {
   case fi_tcl_e8_NavLocationDescType::FI_EN_T_RESERVED:
      poNavLocationDescTypeData = OSAL_NEW fi_tcl_Reserved;
      break;
   case fi_tcl_e8_NavLocationDescType::FI_EN_T_NAVLOCATIONDATADESC:
      poNavLocationDescTypeData = OSAL_NEW fi_tcl_NavLocationDataDesc;
      break;
   case fi_tcl_e8_NavLocationDescType::FI_EN_T_NAVAREADESCRIPTIONCIRCLE:
      poNavLocationDescTypeData = OSAL_NEW fi_tcl_NavAreaDescriptionCircle;
      break;
   case fi_tcl_e8_NavLocationDescType::FI_EN_T_NAVAREADESCRIPTIONPOLYGON:
      poNavLocationDescTypeData = OSAL_NEW fi_tcl_NavAreaDescriptionPolygon;
      break;
   default:
      oIn.Invalidate();
      poNavLocationDescTypeData = OSAL_NULL;
   }
   if (poNavLocationDescTypeData && oIn.bIsValid())
      poNavLocationDescTypeData->oRead(oIn);
   else
      oIn.Invalidate();
   return oIn;
}

fi_tclOutContext& fi_tcl_NavLocationDesc::oWrite(fi_tclOutContext& oOut) const
{
   oOut << NavLocationDescTypeType;
   if (poNavLocationDescTypeData)
   {
      poNavLocationDescTypeData->oWrite(oOut);
   }
   else
   {
      oOut.Invalidate();
   }
   return oOut;
}

#ifndef FI_S_EXTERNAL_FI
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
fi_tcl_NavLocationBinContainer::fi_tcl_NavLocationBinContainer(const fi_tcl_NavLocationBinContainer& coRef):fi_tclVisitableTypeBase(coRef)
{
   ContainerLength = coRef.ContainerLength;
   ServiceID = coRef.ServiceID;
   ContainerFIVersion = coRef.ContainerFIVersion;
   ContainerType = coRef.ContainerType;
   ContainerData = coRef.ContainerData;
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
fi_tcl_NavLocationBinContainer& fi_tcl_NavLocationBinContainer::operator=(const fi_tcl_NavLocationBinContainer& coRef)
{
   if (this == &coRef) return *this;
   ContainerLength = coRef.ContainerLength;
   ServiceID = coRef.ServiceID;
   ContainerFIVersion = coRef.ContainerFIVersion;
   ContainerType = coRef.ContainerType;
   ContainerData = coRef.ContainerData;
   return *this;
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
tVoid fi_tcl_NavLocationBinContainer::vDestroy()
{
   ContainerFIVersion.vDestroy(); 
   ContainerData.vDestroy(); 
}

tU32 fi_tcl_NavLocationBinContainer::u32GetSize(tU16 u16MajorVersion) const
{
   u16MajorVersion = ContainerFIVersion.MajorVersion;
   return 10+ContainerData.u32GetSize(u16MajorVersion);
}

tBool fi_tcl_NavLocationBinContainer::operator==(const fi_tcl_NavLocationBinContainer& rfoCmp) const
{
   tBool bResult = true;
      bResult = bResult && (ContainerLength == rfoCmp.ContainerLength);
      bResult = bResult && (ServiceID == rfoCmp.ServiceID);
      bResult = bResult && (ContainerFIVersion == rfoCmp.ContainerFIVersion);
      bResult = bResult && (ContainerType == rfoCmp.ContainerType);
      bResult = bResult && (ContainerData == rfoCmp.ContainerData);
   return bResult;
}

fi_tclInContext& fi_tcl_NavLocationBinContainer::oRead(fi_tclInContext& oIn)
{
   oIn >> ContainerLength;
   oIn >> ServiceID;
   oIn >> ContainerFIVersion;
   oIn >> ContainerType;
   if (!oIn.bIsValid() ||
       (ContainerLength <= 6) ||
       (ContainerType.enType != fi_tcl_e8_BinContainerTypes::FI_EN_T_NAVLOCATIONBINCONTAINER) ||
       (ContainerFIVersion.MajorVersion < fi_tcl_NavLocationBinContainer::C_U16_MAJORVERSION_MIN) ||
       (ContainerFIVersion.MajorVersion > fi_tcl_NavLocationBinContainer::C_U16_MAJORVERSION_MAX))
   {
      if (oIn.bIsValid() && (ContainerLength >= 6))
      {
         // read rest of container but discard it
         for (tU32 u32Dummy = 0; u32Dummy < (ContainerLength - 6); ++u32Dummy)
         {
            tU8 u8Dummy;
            oIn.oRead(u8Dummy);
         }
      }
      else
      {
         oIn.Invalidate();
      }
      return oIn;
   }
   tU16 u16MajorVersion = oIn.u16SetMajorVersion(ContainerFIVersion.MajorVersion);
   oIn >> ContainerData;
   oIn.u16SetMajorVersion(u16MajorVersion);
   return oIn;
}

fi_tclOutContext& fi_tcl_NavLocationBinContainer::oWrite(fi_tclOutContext& oOut) const
{
   tU16 u16MajorVersion = oOut.u16SetMajorVersion(ContainerFIVersion.MajorVersion);
   oOut << ContainerLength;
   oOut << ServiceID;
   oOut << ContainerFIVersion;
   oOut << ContainerType;
   oOut << ContainerData;
   oOut.u16SetMajorVersion(u16MajorVersion);
   return oOut;
}

tU16 fi_tcl_NavLocationBinContainer::u16Transform(const fi_tcl_BinContainer& oContainer)
{
   tU16 u16RetVal = 0;
   if (&oContainer != OSAL_NULL) //lint !e774 (&oContainer CAN be NULL!!)
   {
      this->vDestroy();
      tU32 u32MinSize = this->u32GetSize(fi_tcl_NavLocationBinContainer::C_U16_MAJORVERSION_MAX);
      tU32 u32Size = oContainer.u32GetSize(0);
      if (u32Size >= u32MinSize)
      {
         tU8* pu8Buf = OSAL_NEW tU8[u32Size];
         if (pu8Buf != OSAL_NULL)
         {
            if (oContainer.ContainerDataList[5] == (tU8)fi_tcl_e8_BinContainerTypes::FI_EN_T_NAVLOCATIONBINCONTAINER)
            {
               tU16 u16MajorVersion = oContainer.ContainerDataList[2];
               if ((u16MajorVersion >= fi_tcl_NavLocationBinContainer::C_U16_MAJORVERSION_MIN) &&
                   (u16MajorVersion <= fi_tcl_NavLocationBinContainer::C_U16_MAJORVERSION_MAX))
               {
                  fi_tclOutContext oOut(pu8Buf,pu8Buf+u32Size,u16MajorVersion);
                  fi_tclInContext  oIn (pu8Buf,pu8Buf+u32Size,u16MajorVersion);
                  oOut << oContainer;
                  oIn >> *this;
                  if (!oIn.bIsValid())
                  {
                     u16RetVal = FI_C_U16_ERROR_INTERNALFAILURE;
                  }
               }
               else
               {
                  u16RetVal = FI_C_U16_ERROR_INVALIDBINCONTAINERWRONGVERSION;
               }
            }
            else
            {
               u16RetVal = FI_C_U16_ERROR_INVALIDBINCONTAINERUNEXPECTEDDATA;
            }
         }
         else
         {
            this->ContainerType.enType = fi_tcl_e8_BinContainerTypes::FI_EN_T_RESERVED;
            u16RetVal = FI_C_U16_ERROR_INTERNALFAILURE;
         }
         OSAL_DELETE[] pu8Buf;
      }
      else
      {
         u16RetVal = FI_C_U16_ERROR_INVALIDBINCONTAINERUNEXPECTEDDATA;
      }
   }
   else
   {
      u16RetVal = FI_C_U16_ERROR_INVALIDBINCONTAINERUNEXPECTEDDATA;
   }
   return u16RetVal;
}

const tU16 fi_tcl_NavLocationBinContainer::C_U16_MAJORVERSION_MAX = 33;
const tU16 fi_tcl_NavLocationBinContainer::C_U16_MAJORVERSION_MIN = 6;

#endif // FI_S_EXTERNAL_FI
tU32 fi_tcl_e8_NavIndexZFDestinationType::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 1;
}

tBool fi_tcl_e8_NavIndexZFDestinationType::operator==(const fi_tcl_e8_NavIndexZFDestinationType& rfoCmp) const
{
   return enType == rfoCmp.enType;
}

fi_tclInContext& fi_tcl_e8_NavIndexZFDestinationType::oRead(fi_tclInContext& oIn)
{
   tU8 u8Value;
   oIn >> u8Value;
   enType = (tenType)u8Value;
   return oIn;
}

fi_tclOutContext& fi_tcl_e8_NavIndexZFDestinationType::oWrite(fi_tclOutContext& oOut) const
{
   return oOut.oWrite((tU8)enType);
}

tU32 fi_tcl_e8_NavLocationNavDataType::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 1;
}

tBool fi_tcl_e8_NavLocationNavDataType::operator==(const fi_tcl_e8_NavLocationNavDataType& rfoCmp) const
{
   return enType == rfoCmp.enType;
}

fi_tclInContext& fi_tcl_e8_NavLocationNavDataType::oRead(fi_tclInContext& oIn)
{
   tU8 u8Value;
   oIn >> u8Value;
   enType = (tenType)u8Value;
   return oIn;
}

fi_tclOutContext& fi_tcl_e8_NavLocationNavDataType::oWrite(fi_tclOutContext& oOut) const
{
   return oOut.oWrite((tU8)enType);
}

tU32 fi_tcl_u32_DataSetId::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 4;
}

tBool fi_tcl_u32_DataSetId::operator==(const fi_tcl_u32_DataSetId& rfoCmp) const
{
   return u32Value == rfoCmp.u32Value;
}

fi_tclInContext& fi_tcl_u32_DataSetId::oRead(fi_tclInContext& oIn)
{
   return oIn >> u32Value;
}

fi_tclOutContext& fi_tcl_u32_DataSetId::oWrite(fi_tclOutContext& oOut) const
{
   return oOut << u32Value;
}

tU32 fi_tcl_e8_SideInfo::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 1;
}

tBool fi_tcl_e8_SideInfo::operator==(const fi_tcl_e8_SideInfo& rfoCmp) const
{
   return enType == rfoCmp.enType;
}

fi_tclInContext& fi_tcl_e8_SideInfo::oRead(fi_tclInContext& oIn)
{
   tU8 u8Value;
   oIn >> u8Value;
   enType = (tenType)u8Value;
   return oIn;
}

fi_tclOutContext& fi_tcl_e8_SideInfo::oWrite(fi_tclOutContext& oOut) const
{
   return oOut.oWrite((tU8)enType);
}

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
fi_tcl_NavSpotDestinationOneCellProperty::fi_tcl_NavSpotDestinationOneCellProperty(const fi_tcl_NavSpotDestinationOneCellProperty& coRef):fi_tclVisitableTypeBase(coRef)
{
   SideInfo = coRef.SideInfo;
   FromZeroCellToSpotLength = coRef.FromZeroCellToSpotLength;
   OneCellLength = coRef.OneCellLength;
   DestDistance = coRef.DestDistance;
   DecisionPoint = coRef.DecisionPoint;
   IndexInObjectPointRefList = coRef.IndexInObjectPointRefList;
   IndexInAccessPointRefList = coRef.IndexInAccessPointRefList;
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
fi_tcl_NavSpotDestinationOneCellProperty& fi_tcl_NavSpotDestinationOneCellProperty::operator=(const fi_tcl_NavSpotDestinationOneCellProperty& coRef)
{
   if (this == &coRef) return *this;
   SideInfo = coRef.SideInfo;
   FromZeroCellToSpotLength = coRef.FromZeroCellToSpotLength;
   OneCellLength = coRef.OneCellLength;
   DestDistance = coRef.DestDistance;
   DecisionPoint = coRef.DecisionPoint;
   IndexInObjectPointRefList = coRef.IndexInObjectPointRefList;
   IndexInAccessPointRefList = coRef.IndexInAccessPointRefList;
   return *this;
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
tVoid fi_tcl_NavSpotDestinationOneCellProperty::vDestroy()
{
   DecisionPoint.vDestroy(); 
}

tU32 fi_tcl_NavSpotDestinationOneCellProperty::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 25;
}

tBool fi_tcl_NavSpotDestinationOneCellProperty::operator==(const fi_tcl_NavSpotDestinationOneCellProperty& rfoCmp) const
{
   tBool bResult = true;
      bResult = bResult && (SideInfo == rfoCmp.SideInfo);
      bResult = bResult && (FromZeroCellToSpotLength == rfoCmp.FromZeroCellToSpotLength);
      bResult = bResult && (OneCellLength == rfoCmp.OneCellLength);
      bResult = bResult && (DestDistance == rfoCmp.DestDistance);
      bResult = bResult && (DecisionPoint == rfoCmp.DecisionPoint);
      bResult = bResult && (IndexInObjectPointRefList == rfoCmp.IndexInObjectPointRefList);
      bResult = bResult && (IndexInAccessPointRefList == rfoCmp.IndexInAccessPointRefList);
   return bResult;
}

fi_tclInContext& fi_tcl_NavSpotDestinationOneCellProperty::oRead(fi_tclInContext& oIn)
{
   oIn >> SideInfo;
   oIn >> FromZeroCellToSpotLength;
   oIn >> OneCellLength;
   oIn >> DestDistance;
   oIn >> DecisionPoint;
   oIn >> IndexInObjectPointRefList;
   oIn >> IndexInAccessPointRefList;
   return oIn;
}

fi_tclOutContext& fi_tcl_NavSpotDestinationOneCellProperty::oWrite(fi_tclOutContext& oOut) const
{
   oOut << SideInfo;
   oOut << FromZeroCellToSpotLength;
   oOut << OneCellLength;
   oOut << DestDistance;
   oOut << DecisionPoint;
   oOut << IndexInObjectPointRefList;
   oOut << IndexInAccessPointRefList;
   return oOut;
}

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
fi_tcl_NavSpotDestinationOneCellDesc::fi_tcl_NavSpotDestinationOneCellDesc(const fi_tcl_NavSpotDestinationOneCellDesc& coRef):fi_tclVisitableTypeBase(coRef)
{
   OneCellDesc = coRef.OneCellDesc;
   OneCellProperty = coRef.OneCellProperty;
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
fi_tcl_NavSpotDestinationOneCellDesc& fi_tcl_NavSpotDestinationOneCellDesc::operator=(const fi_tcl_NavSpotDestinationOneCellDesc& coRef)
{
   if (this == &coRef) return *this;
   OneCellDesc = coRef.OneCellDesc;
   OneCellProperty = coRef.OneCellProperty;
   return *this;
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
tVoid fi_tcl_NavSpotDestinationOneCellDesc::vDestroy()
{
   OneCellDesc.vDestroy(); 
   OneCellProperty.vDestroy(); 
}

tU32 fi_tcl_NavSpotDestinationOneCellDesc::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 30;
}

tBool fi_tcl_NavSpotDestinationOneCellDesc::operator==(const fi_tcl_NavSpotDestinationOneCellDesc& rfoCmp) const
{
   tBool bResult = true;
      bResult = bResult && (OneCellDesc == rfoCmp.OneCellDesc);
      bResult = bResult && (OneCellProperty == rfoCmp.OneCellProperty);
   return bResult;
}

fi_tclInContext& fi_tcl_NavSpotDestinationOneCellDesc::oRead(fi_tclInContext& oIn)
{
   oIn >> OneCellDesc;
   oIn >> OneCellProperty;
   return oIn;
}

fi_tclOutContext& fi_tcl_NavSpotDestinationOneCellDesc::oWrite(fi_tclOutContext& oOut) const
{
   oOut << OneCellDesc;
   oOut << OneCellProperty;
   return oOut;
}

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
fi_tcl_NavStreetDestinationOneCellProperty::fi_tcl_NavStreetDestinationOneCellProperty(const fi_tcl_NavStreetDestinationOneCellProperty& coRef):fi_tclVisitableTypeBase(coRef)
{
   SideInfo = coRef.SideInfo;
   IndexInObjectPointRefList = coRef.IndexInObjectPointRefList;
   IndexInAccessPointRefList = coRef.IndexInAccessPointRefList;
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
fi_tcl_NavStreetDestinationOneCellProperty& fi_tcl_NavStreetDestinationOneCellProperty::operator=(const fi_tcl_NavStreetDestinationOneCellProperty& coRef)
{
   if (this == &coRef) return *this;
   SideInfo = coRef.SideInfo;
   IndexInObjectPointRefList = coRef.IndexInObjectPointRefList;
   IndexInAccessPointRefList = coRef.IndexInAccessPointRefList;
   return *this;
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
tU32 fi_tcl_NavStreetDestinationOneCellProperty::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 5;
}

tBool fi_tcl_NavStreetDestinationOneCellProperty::operator==(const fi_tcl_NavStreetDestinationOneCellProperty& rfoCmp) const
{
   tBool bResult = true;
      bResult = bResult && (SideInfo == rfoCmp.SideInfo);
      bResult = bResult && (IndexInObjectPointRefList == rfoCmp.IndexInObjectPointRefList);
      bResult = bResult && (IndexInAccessPointRefList == rfoCmp.IndexInAccessPointRefList);
   return bResult;
}

fi_tclInContext& fi_tcl_NavStreetDestinationOneCellProperty::oRead(fi_tclInContext& oIn)
{
   oIn >> SideInfo;
   oIn >> IndexInObjectPointRefList;
   oIn >> IndexInAccessPointRefList;
   return oIn;
}

fi_tclOutContext& fi_tcl_NavStreetDestinationOneCellProperty::oWrite(fi_tclOutContext& oOut) const
{
   oOut << SideInfo;
   oOut << IndexInObjectPointRefList;
   oOut << IndexInAccessPointRefList;
   return oOut;
}

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
fi_tcl_NavStreetDestinationOneCellDesc::fi_tcl_NavStreetDestinationOneCellDesc(const fi_tcl_NavStreetDestinationOneCellDesc& coRef):fi_tclVisitableTypeBase(coRef)
{
   OneCellDesc = coRef.OneCellDesc;
   OneCellProperty = coRef.OneCellProperty;
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
fi_tcl_NavStreetDestinationOneCellDesc& fi_tcl_NavStreetDestinationOneCellDesc::operator=(const fi_tcl_NavStreetDestinationOneCellDesc& coRef)
{
   if (this == &coRef) return *this;
   OneCellDesc = coRef.OneCellDesc;
   OneCellProperty = coRef.OneCellProperty;
   return *this;
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
tVoid fi_tcl_NavStreetDestinationOneCellDesc::vDestroy()
{
   OneCellDesc.vDestroy(); 
   OneCellProperty.vDestroy(); 
}

tU32 fi_tcl_NavStreetDestinationOneCellDesc::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 10;
}

tBool fi_tcl_NavStreetDestinationOneCellDesc::operator==(const fi_tcl_NavStreetDestinationOneCellDesc& rfoCmp) const
{
   tBool bResult = true;
      bResult = bResult && (OneCellDesc == rfoCmp.OneCellDesc);
      bResult = bResult && (OneCellProperty == rfoCmp.OneCellProperty);
   return bResult;
}

fi_tclInContext& fi_tcl_NavStreetDestinationOneCellDesc::oRead(fi_tclInContext& oIn)
{
   oIn >> OneCellDesc;
   oIn >> OneCellProperty;
   return oIn;
}

fi_tclOutContext& fi_tcl_NavStreetDestinationOneCellDesc::oWrite(fi_tclOutContext& oOut) const
{
   oOut << OneCellDesc;
   oOut << OneCellProperty;
   return oOut;
}

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
fi_tcl_NavStreetDestinationOneCellListSet::fi_tcl_NavStreetDestinationOneCellListSet(const fi_tcl_NavStreetDestinationOneCellListSet& coRef):fi_tclVisitableTypeBase(coRef)
{
   ClusterRefList = coRef.ClusterRefList;
   StreetDestinationOneCellRefList = coRef.StreetDestinationOneCellRefList;
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
fi_tcl_NavStreetDestinationOneCellListSet& fi_tcl_NavStreetDestinationOneCellListSet::operator=(const fi_tcl_NavStreetDestinationOneCellListSet& coRef)
{
   if (this == &coRef) return *this;
   ClusterRefList = coRef.ClusterRefList;
   StreetDestinationOneCellRefList = coRef.StreetDestinationOneCellRefList;
   return *this;
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
tVoid fi_tcl_NavStreetDestinationOneCellListSet::vDestroy()
{
   {
      for (tU32 u32Idx = 0; u32Idx < ClusterRefList.size(); ++u32Idx)
         ClusterRefList[u32Idx].vDestroy();
   }
   ClusterRefList.clear();
   {
      for (tU32 u32Idx = 0; u32Idx < StreetDestinationOneCellRefList.size(); ++u32Idx)
         StreetDestinationOneCellRefList[u32Idx].vDestroy();
   }
   StreetDestinationOneCellRefList.clear();
}

tU32 fi_tcl_NavStreetDestinationOneCellListSet::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 8+ClusterRefList.size()*9+StreetDestinationOneCellRefList.size()*10;
}

tBool fi_tcl_NavStreetDestinationOneCellListSet::operator==(const fi_tcl_NavStreetDestinationOneCellListSet& rfoCmp) const
{
   tBool bResult = true;
      bResult = bResult && (ClusterRefList.size() == rfoCmp.ClusterRefList.size());
      if (bResult)
      {
         for (tU32 u32Idx = 0; bResult && (u32Idx < ClusterRefList.size()); ++u32Idx)
            bResult = bResult && (ClusterRefList[u32Idx] == rfoCmp.ClusterRefList[u32Idx]);
      }
      bResult = bResult && (StreetDestinationOneCellRefList.size() == rfoCmp.StreetDestinationOneCellRefList.size());
      if (bResult)
      {
         for (tU32 u32Idx = 0; bResult && (u32Idx < StreetDestinationOneCellRefList.size()); ++u32Idx)
            bResult = bResult && (StreetDestinationOneCellRefList[u32Idx] == rfoCmp.StreetDestinationOneCellRefList[u32Idx]);
      }
   return bResult;
}

fi_tclInContext& fi_tcl_NavStreetDestinationOneCellListSet::oRead(fi_tclInContext& oIn)
{
   {
      tU32 u32Length;
      tU32 u32Idx;
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
      for (u32Idx = 0; u32Idx < ClusterRefList.size(); ++u32Idx)
      {
         ClusterRefList[u32Idx].vDestroy();
      }
#endif // !VARIANT_S_FTR_ENABLE_DEEP_COPY
      oIn >> u32Length;
      ClusterRefList.resize(u32Length);
      for (u32Idx = 0; u32Idx < u32Length; ++u32Idx)
      {
         oIn >> ClusterRefList[u32Idx];
      }
   }
   {
      tU32 u32Length;
      tU32 u32Idx;
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
      for (u32Idx = 0; u32Idx < StreetDestinationOneCellRefList.size(); ++u32Idx)
      {
         StreetDestinationOneCellRefList[u32Idx].vDestroy();
      }
#endif // !VARIANT_S_FTR_ENABLE_DEEP_COPY
      oIn >> u32Length;
      StreetDestinationOneCellRefList.resize(u32Length);
      for (u32Idx = 0; u32Idx < u32Length; ++u32Idx)
      {
         oIn >> StreetDestinationOneCellRefList[u32Idx];
      }
   }
   return oIn;
}

fi_tclOutContext& fi_tcl_NavStreetDestinationOneCellListSet::oWrite(fi_tclOutContext& oOut) const
{
   oOut << (tU32)ClusterRefList.size();
   {
      for (tU32 u32Idx = 0; u32Idx < ClusterRefList.size(); ++u32Idx)
         oOut << ClusterRefList[u32Idx];
   }
   oOut << (tU32)StreetDestinationOneCellRefList.size();
   {
      for (tU32 u32Idx = 0; u32Idx < StreetDestinationOneCellRefList.size(); ++u32Idx)
         oOut << StreetDestinationOneCellRefList[u32Idx];
   }
   return oOut;
}

tU32 fi_tcl_e8_NavIntersectionType::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 1;
}

tBool fi_tcl_e8_NavIntersectionType::operator==(const fi_tcl_e8_NavIntersectionType& rfoCmp) const
{
   return enType == rfoCmp.enType;
}

fi_tclInContext& fi_tcl_e8_NavIntersectionType::oRead(fi_tclInContext& oIn)
{
   tU8 u8Value;
   oIn >> u8Value;
   enType = (tenType)u8Value;
   return oIn;
}

fi_tclOutContext& fi_tcl_e8_NavIntersectionType::oWrite(fi_tclOutContext& oOut) const
{
   return oOut.oWrite((tU8)enType);
}

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
fi_tcl_NavZeroCellDesc::fi_tcl_NavZeroCellDesc(const fi_tcl_NavZeroCellDesc& coRef):fi_tclVisitableTypeBase(coRef)
{
   ZeroCellId = coRef.ZeroCellId;
   IndexInClusterRefList = coRef.IndexInClusterRefList;
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
fi_tcl_NavZeroCellDesc& fi_tcl_NavZeroCellDesc::operator=(const fi_tcl_NavZeroCellDesc& coRef)
{
   if (this == &coRef) return *this;
   ZeroCellId = coRef.ZeroCellId;
   IndexInClusterRefList = coRef.IndexInClusterRefList;
   return *this;
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
tU32 fi_tcl_NavZeroCellDesc::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 4;
}

tBool fi_tcl_NavZeroCellDesc::operator==(const fi_tcl_NavZeroCellDesc& rfoCmp) const
{
   tBool bResult = true;
      bResult = bResult && (ZeroCellId == rfoCmp.ZeroCellId);
      bResult = bResult && (IndexInClusterRefList == rfoCmp.IndexInClusterRefList);
   return bResult;
}

fi_tclInContext& fi_tcl_NavZeroCellDesc::oRead(fi_tclInContext& oIn)
{
   oIn >> ZeroCellId;
   oIn >> IndexInClusterRefList;
   return oIn;
}

fi_tclOutContext& fi_tcl_NavZeroCellDesc::oWrite(fi_tclOutContext& oOut) const
{
   oOut << ZeroCellId;
   oOut << IndexInClusterRefList;
   return oOut;
}

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
fi_tcl_NavIntersectionDestinationZeroCellProperty::fi_tcl_NavIntersectionDestinationZeroCellProperty(const fi_tcl_NavIntersectionDestinationZeroCellProperty& coRef):fi_tclVisitableTypeBase(coRef)
{
   IntersectionType = coRef.IntersectionType;
   IndexInObjectPointRefList = coRef.IndexInObjectPointRefList;
   IndexInAccessPointRefList = coRef.IndexInAccessPointRefList;
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
fi_tcl_NavIntersectionDestinationZeroCellProperty& fi_tcl_NavIntersectionDestinationZeroCellProperty::operator=(const fi_tcl_NavIntersectionDestinationZeroCellProperty& coRef)
{
   if (this == &coRef) return *this;
   IntersectionType = coRef.IntersectionType;
   IndexInObjectPointRefList = coRef.IndexInObjectPointRefList;
   IndexInAccessPointRefList = coRef.IndexInAccessPointRefList;
   return *this;
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
tU32 fi_tcl_NavIntersectionDestinationZeroCellProperty::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 5;
}

tBool fi_tcl_NavIntersectionDestinationZeroCellProperty::operator==(const fi_tcl_NavIntersectionDestinationZeroCellProperty& rfoCmp) const
{
   tBool bResult = true;
      bResult = bResult && (IntersectionType == rfoCmp.IntersectionType);
      bResult = bResult && (IndexInObjectPointRefList == rfoCmp.IndexInObjectPointRefList);
      bResult = bResult && (IndexInAccessPointRefList == rfoCmp.IndexInAccessPointRefList);
   return bResult;
}

fi_tclInContext& fi_tcl_NavIntersectionDestinationZeroCellProperty::oRead(fi_tclInContext& oIn)
{
   oIn >> IntersectionType;
   oIn >> IndexInObjectPointRefList;
   oIn >> IndexInAccessPointRefList;
   return oIn;
}

fi_tclOutContext& fi_tcl_NavIntersectionDestinationZeroCellProperty::oWrite(fi_tclOutContext& oOut) const
{
   oOut << IntersectionType;
   oOut << IndexInObjectPointRefList;
   oOut << IndexInAccessPointRefList;
   return oOut;
}

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
fi_tcl_NavIntersectionDestinationZeroCellDesc::fi_tcl_NavIntersectionDestinationZeroCellDesc(const fi_tcl_NavIntersectionDestinationZeroCellDesc& coRef):fi_tclVisitableTypeBase(coRef)
{
   ZeroCellDesc = coRef.ZeroCellDesc;
   ZeroCellProperty = coRef.ZeroCellProperty;
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
fi_tcl_NavIntersectionDestinationZeroCellDesc& fi_tcl_NavIntersectionDestinationZeroCellDesc::operator=(const fi_tcl_NavIntersectionDestinationZeroCellDesc& coRef)
{
   if (this == &coRef) return *this;
   ZeroCellDesc = coRef.ZeroCellDesc;
   ZeroCellProperty = coRef.ZeroCellProperty;
   return *this;
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
tVoid fi_tcl_NavIntersectionDestinationZeroCellDesc::vDestroy()
{
   ZeroCellDesc.vDestroy(); 
   ZeroCellProperty.vDestroy(); 
}

tU32 fi_tcl_NavIntersectionDestinationZeroCellDesc::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 9;
}

tBool fi_tcl_NavIntersectionDestinationZeroCellDesc::operator==(const fi_tcl_NavIntersectionDestinationZeroCellDesc& rfoCmp) const
{
   tBool bResult = true;
      bResult = bResult && (ZeroCellDesc == rfoCmp.ZeroCellDesc);
      bResult = bResult && (ZeroCellProperty == rfoCmp.ZeroCellProperty);
   return bResult;
}

fi_tclInContext& fi_tcl_NavIntersectionDestinationZeroCellDesc::oRead(fi_tclInContext& oIn)
{
   oIn >> ZeroCellDesc;
   oIn >> ZeroCellProperty;
   return oIn;
}

fi_tclOutContext& fi_tcl_NavIntersectionDestinationZeroCellDesc::oWrite(fi_tclOutContext& oOut) const
{
   oOut << ZeroCellDesc;
   oOut << ZeroCellProperty;
   return oOut;
}

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
fi_tcl_NavAreaDescriptionCircle::fi_tcl_NavAreaDescriptionCircle(const fi_tcl_NavAreaDescriptionCircle& coRef):fi_tclVisitableTypeBase(coRef)
{
   Radius = coRef.Radius;
   Coordinate = coRef.Coordinate;
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
fi_tcl_NavAreaDescriptionCircle& fi_tcl_NavAreaDescriptionCircle::operator=(const fi_tcl_NavAreaDescriptionCircle& coRef)
{
   if (this == &coRef) return *this;
   Radius = coRef.Radius;
   Coordinate = coRef.Coordinate;
   return *this;
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
tVoid fi_tcl_NavAreaDescriptionCircle::vDestroy()
{
   Coordinate.vDestroy(); 
}

tU32 fi_tcl_NavAreaDescriptionCircle::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 12;
}

tBool fi_tcl_NavAreaDescriptionCircle::operator==(const fi_tcl_NavAreaDescriptionCircle& rfoCmp) const
{
   tBool bResult = true;
      bResult = bResult && (Radius == rfoCmp.Radius);
      bResult = bResult && (Coordinate == rfoCmp.Coordinate);
   return bResult;
}

fi_tclInContext& fi_tcl_NavAreaDescriptionCircle::oRead(fi_tclInContext& oIn)
{
   oIn >> Radius;
   oIn >> Coordinate;
   return oIn;
}

fi_tclOutContext& fi_tcl_NavAreaDescriptionCircle::oWrite(fi_tclOutContext& oOut) const
{
   oOut << Radius;
   oOut << Coordinate;
   return oOut;
}

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
fi_tcl_NavAreaDescriptionPolygon::fi_tcl_NavAreaDescriptionPolygon(const fi_tcl_NavAreaDescriptionPolygon& coRef):fi_tclVisitableTypeBase(coRef)
{
   CoordinateList = coRef.CoordinateList;
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
fi_tcl_NavAreaDescriptionPolygon& fi_tcl_NavAreaDescriptionPolygon::operator=(const fi_tcl_NavAreaDescriptionPolygon& coRef)
{
   if (this == &coRef) return *this;
   CoordinateList = coRef.CoordinateList;
   return *this;
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
tVoid fi_tcl_NavAreaDescriptionPolygon::vDestroy()
{
   {
      for (tU32 u32Idx = 0; u32Idx < CoordinateList.size(); ++u32Idx)
         CoordinateList[u32Idx].vDestroy();
   }
   CoordinateList.clear();
}

tU32 fi_tcl_NavAreaDescriptionPolygon::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 4+CoordinateList.size()*8;
}

tBool fi_tcl_NavAreaDescriptionPolygon::operator==(const fi_tcl_NavAreaDescriptionPolygon& rfoCmp) const
{
   tBool bResult = true;
      bResult = bResult && (CoordinateList.size() == rfoCmp.CoordinateList.size());
      if (bResult)
      {
         for (tU32 u32Idx = 0; bResult && (u32Idx < CoordinateList.size()); ++u32Idx)
            bResult = bResult && (CoordinateList[u32Idx] == rfoCmp.CoordinateList[u32Idx]);
      }
   return bResult;
}

fi_tclInContext& fi_tcl_NavAreaDescriptionPolygon::oRead(fi_tclInContext& oIn)
{
   {
      tU32 u32Length;
      tU32 u32Idx;
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
      for (u32Idx = 0; u32Idx < CoordinateList.size(); ++u32Idx)
      {
         CoordinateList[u32Idx].vDestroy();
      }
#endif // !VARIANT_S_FTR_ENABLE_DEEP_COPY
      oIn >> u32Length;
      CoordinateList.resize(u32Length);
      for (u32Idx = 0; u32Idx < u32Length; ++u32Idx)
      {
         oIn >> CoordinateList[u32Idx];
      }
   }
   return oIn;
}

fi_tclOutContext& fi_tcl_NavAreaDescriptionPolygon::oWrite(fi_tclOutContext& oOut) const
{
   oOut << (tU32)CoordinateList.size();
   {
      for (tU32 u32Idx = 0; u32Idx < CoordinateList.size(); ++u32Idx)
         oOut << CoordinateList[u32Idx];
   }
   return oOut;
}

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
fi_tcl_CountryInfo::fi_tcl_CountryInfo(const fi_tcl_CountryInfo& coRef):fi_tclVisitableTypeBase(coRef)
{
   CountryCode = coRef.CountryCode;
   TrafficSense = coRef.TrafficSense;
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
fi_tcl_CountryInfo& fi_tcl_CountryInfo::operator=(const fi_tcl_CountryInfo& coRef)
{
   if (this == &coRef) return *this;
   CountryCode = coRef.CountryCode;
   TrafficSense = coRef.TrafficSense;
   return *this;
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
tU32 fi_tcl_CountryInfo::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 3;
}

tBool fi_tcl_CountryInfo::operator==(const fi_tcl_CountryInfo& rfoCmp) const
{
   tBool bResult = true;
      bResult = bResult && (CountryCode == rfoCmp.CountryCode);
      bResult = bResult && (TrafficSense == rfoCmp.TrafficSense);
   return bResult;
}

fi_tclInContext& fi_tcl_CountryInfo::oRead(fi_tclInContext& oIn)
{
   oIn >> CountryCode;
   oIn >> TrafficSense;
   return oIn;
}

fi_tclOutContext& fi_tcl_CountryInfo::oWrite(fi_tclOutContext& oOut) const
{
   oOut << CountryCode;
   oOut << TrafficSense;
   return oOut;
}

tU32 fi_tcl_u16_TripHandle::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 2;
}

tBool fi_tcl_u16_TripHandle::operator==(const fi_tcl_u16_TripHandle& rfoCmp) const
{
   return u16Value == rfoCmp.u16Value;
}

fi_tclInContext& fi_tcl_u16_TripHandle::oRead(fi_tclInContext& oIn)
{
   return oIn >> u16Value;
}

fi_tclOutContext& fi_tcl_u16_TripHandle::oWrite(fi_tclOutContext& oOut) const
{
   return oOut << u16Value;
}

tU32 fi_tcl_b32_NavRouteStatus::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 4;
}

tBool fi_tcl_b32_NavRouteStatus::operator==(const fi_tcl_b32_NavRouteStatus& rfoCmp) const
{
   return u32Value == rfoCmp.u32Value;
}

fi_tclInContext& fi_tcl_b32_NavRouteStatus::oRead(fi_tclInContext& oIn)
{
   return oIn >> u32Value;
}

fi_tclOutContext& fi_tcl_b32_NavRouteStatus::oWrite(fi_tclOutContext& oOut) const
{
   tU32 temp = u32Value;
   if (!(32 <= oOut.u16GetMajorVersion()))
      temp &= ~FI_C_U32_BIT_BUNPAVEDROADSINRL;
   if (!(36 <= oOut.u16GetMajorVersion()))
      temp &= ~FI_C_U32_BIT_BTOLLBOOTHINRL;
   return oOut << temp;
}

tU32 fi_tcl_b32_ExtNavRouteStatus::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 4;
}

tBool fi_tcl_b32_ExtNavRouteStatus::operator==(const fi_tcl_b32_ExtNavRouteStatus& rfoCmp) const
{
   return u32Value == rfoCmp.u32Value;
}

fi_tclInContext& fi_tcl_b32_ExtNavRouteStatus::oRead(fi_tclInContext& oIn)
{
   return oIn >> u32Value;
}

fi_tclOutContext& fi_tcl_b32_ExtNavRouteStatus::oWrite(fi_tclOutContext& oOut) const
{
   tU32 temp = u32Value;
   if (!(9 <= oOut.u16GetMajorVersion()))
      temp &= ~FI_C_U32_BIT_BREQUIREDPERMISSIONINRL;
   if (!(11 <= oOut.u16GetMajorVersion()))
      temp &= ~FI_C_U32_BIT_BPROHIBITEDTURNSINROUTELIST;
   if (!(15 <= oOut.u16GetMajorVersion()))
      temp &= ~FI_C_U32_BIT_BREGULARADMINCLOSEDINRL;
   if (!(15 <= oOut.u16GetMajorVersion()))
      temp &= ~FI_C_U32_BIT_BINCONSTRUCTIONINRL;
   if (!(25 <= oOut.u16GetMajorVersion()))
      temp &= ~FI_C_U32_BIT_BHOVROADSINRL;
   if (!(25 <= oOut.u16GetMajorVersion()))
      temp &= ~FI_C_U32_BIT_BAUTOTRAININRL;
   return oOut << temp;
}

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
fi_tcl_NavRouteInfo::fi_tcl_NavRouteInfo(const fi_tcl_NavRouteInfo& coRef):fi_tclVisitableTypeBase(coRef)
{
   MaxClusterLevel = coRef.MaxClusterLevel;
   InfoStatus = coRef.InfoStatus;
   ExtInfoStatus = coRef.ExtInfoStatus;
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
fi_tcl_NavRouteInfo& fi_tcl_NavRouteInfo::operator=(const fi_tcl_NavRouteInfo& coRef)
{
   if (this == &coRef) return *this;
   MaxClusterLevel = coRef.MaxClusterLevel;
   InfoStatus = coRef.InfoStatus;
   ExtInfoStatus = coRef.ExtInfoStatus;
   return *this;
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
tU32 fi_tcl_NavRouteInfo::u32GetSize(tU16 u16MajorVersion) const
{
   tU32 u32DynamicSize = 0;
   if (7 <= u16MajorVersion)
   {
      u32DynamicSize += 4;
   }
   return u32DynamicSize+5;
}

tBool fi_tcl_NavRouteInfo::operator==(const fi_tcl_NavRouteInfo& rfoCmp) const
{
   tBool bResult = true;
      bResult = bResult && (MaxClusterLevel == rfoCmp.MaxClusterLevel);
      bResult = bResult && (InfoStatus == rfoCmp.InfoStatus);
      bResult = bResult && (ExtInfoStatus == rfoCmp.ExtInfoStatus);
   return bResult;
}

fi_tclInContext& fi_tcl_NavRouteInfo::oRead(fi_tclInContext& oIn)
{
   oIn >> MaxClusterLevel;
   oIn >> InfoStatus;
   if (7 <= oIn.u16GetMajorVersion())
   {
      oIn >> ExtInfoStatus;
   }
   return oIn;
}

fi_tclOutContext& fi_tcl_NavRouteInfo::oWrite(fi_tclOutContext& oOut) const
{
   oOut << MaxClusterLevel;
   oOut << InfoStatus;
   if (7 <= oOut.u16GetMajorVersion())
   {
      oOut << ExtInfoStatus;
   }
   return oOut;
}

tU32 fi_tcl_u16_TripSegmentNumber::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 2;
}

tBool fi_tcl_u16_TripSegmentNumber::operator==(const fi_tcl_u16_TripSegmentNumber& rfoCmp) const
{
   return u16Value == rfoCmp.u16Value;
}

fi_tclInContext& fi_tcl_u16_TripSegmentNumber::oRead(fi_tclInContext& oIn)
{
   return oIn >> u16Value;
}

fi_tclOutContext& fi_tcl_u16_TripSegmentNumber::oWrite(fi_tclOutContext& oOut) const
{
   return oOut << u16Value;
}

tU32 fi_tcl_e8_ManoeuvreCriticality::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 1;
}

tBool fi_tcl_e8_ManoeuvreCriticality::operator==(const fi_tcl_e8_ManoeuvreCriticality& rfoCmp) const
{
   return enType == rfoCmp.enType;
}

fi_tclInContext& fi_tcl_e8_ManoeuvreCriticality::oRead(fi_tclInContext& oIn)
{
   tU8 u8Value;
   oIn >> u8Value;
   enType = (tenType)u8Value;
   return oIn;
}

fi_tclOutContext& fi_tcl_e8_ManoeuvreCriticality::oWrite(fi_tclOutContext& oOut) const
{
   return oOut.oWrite((tU8)enType);
}

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
fi_tcl_NavRouteDestinationDesc::fi_tcl_NavRouteDestinationDesc(const fi_tcl_NavRouteDestinationDesc& coRef):fi_tclVisitableTypeBase(coRef)
{
   IsSpotDestination = coRef.IsSpotDestination;
   SubDestinationNumber = coRef.SubDestinationNumber;
   ObjectPoint = coRef.ObjectPoint;
   DecisionPoint = coRef.DecisionPoint;
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
fi_tcl_NavRouteDestinationDesc& fi_tcl_NavRouteDestinationDesc::operator=(const fi_tcl_NavRouteDestinationDesc& coRef)
{
   if (this == &coRef) return *this;
   IsSpotDestination = coRef.IsSpotDestination;
   SubDestinationNumber = coRef.SubDestinationNumber;
   ObjectPoint = coRef.ObjectPoint;
   DecisionPoint = coRef.DecisionPoint;
   return *this;
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
tVoid fi_tcl_NavRouteDestinationDesc::vDestroy()
{
   ObjectPoint.vDestroy(); 
   DecisionPoint.vDestroy(); 
}

tU32 fi_tcl_NavRouteDestinationDesc::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 19;
}

tBool fi_tcl_NavRouteDestinationDesc::operator==(const fi_tcl_NavRouteDestinationDesc& rfoCmp) const
{
   tBool bResult = true;
      bResult = bResult && (IsSpotDestination == rfoCmp.IsSpotDestination);
      bResult = bResult && (SubDestinationNumber == rfoCmp.SubDestinationNumber);
      bResult = bResult && (ObjectPoint == rfoCmp.ObjectPoint);
      bResult = bResult && (DecisionPoint == rfoCmp.DecisionPoint);
   return bResult;
}

fi_tclInContext& fi_tcl_NavRouteDestinationDesc::oRead(fi_tclInContext& oIn)
{
   oIn >> IsSpotDestination;
   oIn >> SubDestinationNumber;
   oIn >> ObjectPoint;
   oIn >> DecisionPoint;
   return oIn;
}

fi_tclOutContext& fi_tcl_NavRouteDestinationDesc::oWrite(fi_tclOutContext& oOut) const
{
   oOut << IsSpotDestination;
   oOut << SubDestinationNumber;
   oOut << ObjectPoint;
   oOut << DecisionPoint;
   return oOut;
}

tU32 fi_tcl_b32_NavRouteOneCellStatus::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 4;
}

tBool fi_tcl_b32_NavRouteOneCellStatus::operator==(const fi_tcl_b32_NavRouteOneCellStatus& rfoCmp) const
{
   return u32Value == rfoCmp.u32Value;
}

fi_tclInContext& fi_tcl_b32_NavRouteOneCellStatus::oRead(fi_tclInContext& oIn)
{
   return oIn >> u32Value;
}

fi_tclOutContext& fi_tcl_b32_NavRouteOneCellStatus::oWrite(fi_tclOutContext& oOut) const
{
   return oOut << u32Value;
}

tU32 fi_tcl_b32_ExtNavRouteOneCellStatus::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 4;
}

tBool fi_tcl_b32_ExtNavRouteOneCellStatus::operator==(const fi_tcl_b32_ExtNavRouteOneCellStatus& rfoCmp) const
{
   return u32Value == rfoCmp.u32Value;
}

fi_tclInContext& fi_tcl_b32_ExtNavRouteOneCellStatus::oRead(fi_tclInContext& oIn)
{
   return oIn >> u32Value;
}

fi_tclOutContext& fi_tcl_b32_ExtNavRouteOneCellStatus::oWrite(fi_tclOutContext& oOut) const
{
   tU32 temp = u32Value;
   if (!(9 <= oOut.u16GetMajorVersion()))
      temp &= ~FI_C_U32_BIT_BHASMANDATORYTAXDISC;
   if (!(11 <= oOut.u16GetMajorVersion()))
      temp &= ~FI_C_U32_BIT_BPROHIBITIONONFOLLOWINGTURN;
   if (!(15 <= oOut.u16GetMajorVersion()))
      temp &= ~FI_C_U32_BIT_BREGULARADMINCLOSED;
   if (!(15 <= oOut.u16GetMajorVersion()))
      temp &= ~FI_C_U32_BIT_BREGULARADMINCLOSEDPARTLY;
   if (!(15 <= oOut.u16GetMajorVersion()))
      temp &= ~FI_C_U32_BIT_BINCONSTRUCTION;
   if (!(15 <= oOut.u16GetMajorVersion()))
      temp &= ~FI_C_U32_BIT_BINCONSTRUCTIONPARTLY;
   if (!(25 <= oOut.u16GetMajorVersion()))
      temp &= ~FI_C_U32_BIT_BISHOV;
   if (!(25 <= oOut.u16GetMajorVersion()))
      temp &= ~FI_C_U32_BIT_BISPARTIALAUTOTRAIN;
   if (!(25 <= oOut.u16GetMajorVersion()))
      temp &= ~FI_C_U32_BIT_BISCOMPLETEAUTOTRAIN;
   if (!(32 <= oOut.u16GetMajorVersion()))
      temp &= ~FI_C_U32_BIT_BISPARTIALUNPAVEDROAD;
   if (!(32 <= oOut.u16GetMajorVersion()))
      temp &= ~FI_C_U32_BIT_BISCOMPLETEUNPAVEDROAD;
   return oOut << temp;
}

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
fi_tcl_NavRouteOneCellProperties::fi_tcl_NavRouteOneCellProperties(const fi_tcl_NavRouteOneCellProperties& coRef):fi_tclVisitableTypeBase(coRef)
{
   TripSegmentNumber = coRef.TripSegmentNumber;
   CoordOfToZeroCell = coRef.CoordOfToZeroCell;
   Status = coRef.Status;
   ExtStatus = coRef.ExtStatus;
   RoadProperty = coRef.RoadProperty;
   RoadClass = coRef.RoadClass;
   StreetType = coRef.StreetType;
   TimeManipulator = coRef.TimeManipulator;
   RouteLength = coRef.RouteLength;
   RouteTime = coRef.RouteTime;
   RouteTimeFullTraffic = coRef.RouteTimeFullTraffic;
   RouteTimeNoTraffic = coRef.RouteTimeNoTraffic;
   OneCellLength = coRef.OneCellLength;
   OneCellTime = coRef.OneCellTime;
   Resistance = coRef.Resistance;
   ROSA = coRef.ROSA;
   GBWZ = coRef.GBWZ;
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
fi_tcl_NavRouteOneCellProperties& fi_tcl_NavRouteOneCellProperties::operator=(const fi_tcl_NavRouteOneCellProperties& coRef)
{
   if (this == &coRef) return *this;
   TripSegmentNumber = coRef.TripSegmentNumber;
   CoordOfToZeroCell = coRef.CoordOfToZeroCell;
   Status = coRef.Status;
   ExtStatus = coRef.ExtStatus;
   RoadProperty = coRef.RoadProperty;
   RoadClass = coRef.RoadClass;
   StreetType = coRef.StreetType;
   TimeManipulator = coRef.TimeManipulator;
   RouteLength = coRef.RouteLength;
   RouteTime = coRef.RouteTime;
   RouteTimeFullTraffic = coRef.RouteTimeFullTraffic;
   RouteTimeNoTraffic = coRef.RouteTimeNoTraffic;
   OneCellLength = coRef.OneCellLength;
   OneCellTime = coRef.OneCellTime;
   Resistance = coRef.Resistance;
   ROSA = coRef.ROSA;
   GBWZ = coRef.GBWZ;
   return *this;
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
tVoid fi_tcl_NavRouteOneCellProperties::vDestroy()
{
   CoordOfToZeroCell.vDestroy(); 
}

tU32 fi_tcl_NavRouteOneCellProperties::u32GetSize(tU16 u16MajorVersion) const
{
   tU32 u32DynamicSize = 0;
   if (7 <= u16MajorVersion)
   {
      u32DynamicSize += 4;
   }
   if (7 <= u16MajorVersion)
   {
      u32DynamicSize += 4;
   }
   if (25 <= u16MajorVersion)
   {
      u32DynamicSize += 4;
   }
   if (25 <= u16MajorVersion)
   {
      u32DynamicSize += 4;
   }
   return u32DynamicSize+42;
}

tBool fi_tcl_NavRouteOneCellProperties::operator==(const fi_tcl_NavRouteOneCellProperties& rfoCmp) const
{
   tBool bResult = true;
      bResult = bResult && (TripSegmentNumber == rfoCmp.TripSegmentNumber);
      bResult = bResult && (CoordOfToZeroCell == rfoCmp.CoordOfToZeroCell);
      bResult = bResult && (Status == rfoCmp.Status);
      bResult = bResult && (ExtStatus == rfoCmp.ExtStatus);
      bResult = bResult && (RoadProperty == rfoCmp.RoadProperty);
      bResult = bResult && (RoadClass == rfoCmp.RoadClass);
      bResult = bResult && (StreetType == rfoCmp.StreetType);
      bResult = bResult && (TimeManipulator == rfoCmp.TimeManipulator);
      bResult = bResult && (RouteLength == rfoCmp.RouteLength);
      bResult = bResult && (RouteTime == rfoCmp.RouteTime);
      bResult = bResult && (RouteTimeFullTraffic == rfoCmp.RouteTimeFullTraffic);
      bResult = bResult && (RouteTimeNoTraffic == rfoCmp.RouteTimeNoTraffic);
      bResult = bResult && (OneCellLength == rfoCmp.OneCellLength);
      bResult = bResult && (OneCellTime == rfoCmp.OneCellTime);
      bResult = bResult && (Resistance == rfoCmp.Resistance);
      bResult = bResult && (ROSA == rfoCmp.ROSA);
      bResult = bResult && (GBWZ == rfoCmp.GBWZ);
   return bResult;
}

fi_tclInContext& fi_tcl_NavRouteOneCellProperties::oRead(fi_tclInContext& oIn)
{
   oIn >> TripSegmentNumber;
   oIn >> CoordOfToZeroCell;
   oIn >> Status;
   if (7 <= oIn.u16GetMajorVersion())
   {
      oIn >> ExtStatus;
   }
   if (7 <= oIn.u16GetMajorVersion())
   {
      oIn >> RoadProperty;
   }
   oIn >> RoadClass;
   oIn >> StreetType;
   oIn >> TimeManipulator;
   oIn >> RouteLength;
   oIn >> RouteTime;
   if (25 <= oIn.u16GetMajorVersion())
   {
      oIn >> RouteTimeFullTraffic;
   }
   if (25 <= oIn.u16GetMajorVersion())
   {
      oIn >> RouteTimeNoTraffic;
   }
   oIn >> OneCellLength;
   oIn >> OneCellTime;
   oIn >> Resistance;
   oIn >> ROSA;
   oIn >> GBWZ;
   return oIn;
}

fi_tclOutContext& fi_tcl_NavRouteOneCellProperties::oWrite(fi_tclOutContext& oOut) const
{
   oOut << TripSegmentNumber;
   oOut << CoordOfToZeroCell;
   oOut << Status;
   if (7 <= oOut.u16GetMajorVersion())
   {
      oOut << ExtStatus;
   }
   if (7 <= oOut.u16GetMajorVersion())
   {
      oOut << RoadProperty;
   }
   oOut << RoadClass;
   oOut << StreetType;
   oOut << TimeManipulator;
   oOut << RouteLength;
   oOut << RouteTime;
   if (25 <= oOut.u16GetMajorVersion())
   {
      oOut << RouteTimeFullTraffic;
   }
   if (25 <= oOut.u16GetMajorVersion())
   {
      oOut << RouteTimeNoTraffic;
   }
   oOut << OneCellLength;
   oOut << OneCellTime;
   oOut << Resistance;
   oOut << ROSA;
   oOut << GBWZ;
   return oOut;
}

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
fi_tcl_NavRouteOneCellDesc::fi_tcl_NavRouteOneCellDesc(const fi_tcl_NavRouteOneCellDesc& coRef):fi_tclVisitableTypeBase(coRef)
{
   OCDesc = coRef.OCDesc;
   Instruction = coRef.Instruction;
   Destination = coRef.Destination;
   CountryCode = coRef.CountryCode;
   NextOneCellOnPath = coRef.NextOneCellOnPath;
   OCProperties = coRef.OCProperties;
   StateCode = coRef.StateCode;
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
fi_tcl_NavRouteOneCellDesc& fi_tcl_NavRouteOneCellDesc::operator=(const fi_tcl_NavRouteOneCellDesc& coRef)
{
   if (this == &coRef) return *this;
   OCDesc = coRef.OCDesc;
   Instruction = coRef.Instruction;
   Destination = coRef.Destination;
   CountryCode = coRef.CountryCode;
   NextOneCellOnPath = coRef.NextOneCellOnPath;
   OCProperties = coRef.OCProperties;
   StateCode = coRef.StateCode;
   return *this;
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
tVoid fi_tcl_NavRouteOneCellDesc::vDestroy()
{
   OCDesc.vDestroy(); 
   OCProperties.vDestroy(); 
}

tU32 fi_tcl_NavRouteOneCellDesc::u32GetSize(tU16 u16MajorVersion) const
{
   tU32 u32DynamicSize = 0;
   if (9 <= u16MajorVersion)
   {
      u32DynamicSize += 2;
   }
   if (11 <= u16MajorVersion)
   {
      u32DynamicSize += 2;
   }
   return u32DynamicSize+11+OCProperties.u32GetSize(u16MajorVersion);
}

tBool fi_tcl_NavRouteOneCellDesc::operator==(const fi_tcl_NavRouteOneCellDesc& rfoCmp) const
{
   tBool bResult = true;
      bResult = bResult && (OCDesc == rfoCmp.OCDesc);
      bResult = bResult && (Instruction == rfoCmp.Instruction);
      bResult = bResult && (Destination == rfoCmp.Destination);
      bResult = bResult && (CountryCode == rfoCmp.CountryCode);
      bResult = bResult && (NextOneCellOnPath == rfoCmp.NextOneCellOnPath);
      bResult = bResult && (OCProperties == rfoCmp.OCProperties);
      bResult = bResult && (StateCode == rfoCmp.StateCode);
   return bResult;
}

fi_tclInContext& fi_tcl_NavRouteOneCellDesc::oRead(fi_tclInContext& oIn)
{
   oIn >> OCDesc;
   oIn >> Instruction;
   oIn >> Destination;
   if (9 <= oIn.u16GetMajorVersion())
   {
      oIn >> CountryCode;
   }
   oIn >> NextOneCellOnPath;
   oIn >> OCProperties;
   if (11 <= oIn.u16GetMajorVersion())
   {
      oIn >> StateCode;
   }
   return oIn;
}

fi_tclOutContext& fi_tcl_NavRouteOneCellDesc::oWrite(fi_tclOutContext& oOut) const
{
   oOut << OCDesc;
   oOut << Instruction;
   oOut << Destination;
   if (9 <= oOut.u16GetMajorVersion())
   {
      oOut << CountryCode;
   }
   oOut << NextOneCellOnPath;
   oOut << OCProperties;
   if (11 <= oOut.u16GetMajorVersion())
   {
      oOut << StateCode;
   }
   return oOut;
}

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
fi_tcl_NavRouteInstructionDesc::fi_tcl_NavRouteInstructionDesc(const fi_tcl_NavRouteInstructionDesc& coRef):fi_tclVisitableTypeBase(coRef)
{
   NavInstruction = coRef.NavInstruction;
   NextInstruction = coRef.NextInstruction;
   IndexInFileNameList = coRef.IndexInFileNameList;
   ManoeuvreCriticality = coRef.ManoeuvreCriticality;
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
fi_tcl_NavRouteInstructionDesc& fi_tcl_NavRouteInstructionDesc::operator=(const fi_tcl_NavRouteInstructionDesc& coRef)
{
   if (this == &coRef) return *this;
   NavInstruction = coRef.NavInstruction;
   NextInstruction = coRef.NextInstruction;
   IndexInFileNameList = coRef.IndexInFileNameList;
   ManoeuvreCriticality = coRef.ManoeuvreCriticality;
   return *this;
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
tU32 fi_tcl_NavRouteInstructionDesc::u32GetSize(tU16 u16MajorVersion) const
{
   tU32 u32DynamicSize = 0;
   if (9 <= u16MajorVersion)
   {
      u32DynamicSize += 2;
   }
   if (25 <= u16MajorVersion)
   {
      u32DynamicSize += 1;
   }
   return u32DynamicSize+6;
}

tBool fi_tcl_NavRouteInstructionDesc::operator==(const fi_tcl_NavRouteInstructionDesc& rfoCmp) const
{
   tBool bResult = true;
      bResult = bResult && (NavInstruction == rfoCmp.NavInstruction);
      bResult = bResult && (NextInstruction == rfoCmp.NextInstruction);
      bResult = bResult && (IndexInFileNameList == rfoCmp.IndexInFileNameList);
      bResult = bResult && (ManoeuvreCriticality == rfoCmp.ManoeuvreCriticality);
   return bResult;
}

fi_tclInContext& fi_tcl_NavRouteInstructionDesc::oRead(fi_tclInContext& oIn)
{
   oIn >> NavInstruction;
   oIn >> NextInstruction;
   if (9 <= oIn.u16GetMajorVersion())
   {
      oIn >> IndexInFileNameList;
   }
   if (25 <= oIn.u16GetMajorVersion())
   {
      oIn >> ManoeuvreCriticality;
   }
   return oIn;
}

fi_tclOutContext& fi_tcl_NavRouteInstructionDesc::oWrite(fi_tclOutContext& oOut) const
{
   oOut << NavInstruction;
   oOut << NextInstruction;
   if (9 <= oOut.u16GetMajorVersion())
   {
      oOut << IndexInFileNameList;
   }
   if (25 <= oOut.u16GetMajorVersion())
   {
      oOut << ManoeuvreCriticality;
   }
   return oOut;
}

tU32 fi_tcl_u16_RouteHandle::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 2;
}

tBool fi_tcl_u16_RouteHandle::operator==(const fi_tcl_u16_RouteHandle& rfoCmp) const
{
   return u16Value == rfoCmp.u16Value;
}

fi_tclInContext& fi_tcl_u16_RouteHandle::oRead(fi_tclInContext& oIn)
{
   return oIn >> u16Value;
}

fi_tclOutContext& fi_tcl_u16_RouteHandle::oWrite(fi_tclOutContext& oOut) const
{
   return oOut << u16Value;
}

tU32 fi_tcl_e8_SignPostDestType::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 1;
}

tBool fi_tcl_e8_SignPostDestType::operator==(const fi_tcl_e8_SignPostDestType& rfoCmp) const
{
   return enType == rfoCmp.enType;
}

fi_tclInContext& fi_tcl_e8_SignPostDestType::oRead(fi_tclInContext& oIn)
{
   tU8 u8Value;
   oIn >> u8Value;
   enType = (tenType)u8Value;
   return oIn;
}

fi_tclOutContext& fi_tcl_e8_SignPostDestType::oWrite(fi_tclOutContext& oOut) const
{
   fi_tcl_e8_SignPostDestType::tenType enData = enType;
   if ((enData == FI_EN_EXIT) && !(21 <= oOut.u16GetMajorVersion()))
   {
      enData = FI_EN_RESERVED;
   }
   return oOut.oWrite((tU8)enData);
}

tU32 fi_tcl_e8_SignPostDestinationCategory::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 1;
}

tBool fi_tcl_e8_SignPostDestinationCategory::operator==(const fi_tcl_e8_SignPostDestinationCategory& rfoCmp) const
{
   return enType == rfoCmp.enType;
}

fi_tclInContext& fi_tcl_e8_SignPostDestinationCategory::oRead(fi_tclInContext& oIn)
{
   tU8 u8Value;
   oIn >> u8Value;
   enType = (tenType)u8Value;
   return oIn;
}

fi_tclOutContext& fi_tcl_e8_SignPostDestinationCategory::oWrite(fi_tclOutContext& oOut) const
{
   fi_tcl_e8_SignPostDestinationCategory::tenType enData = enType;
   if ((enData == FI_EN_T_COMPASSDIRECTION) && !(9 <= oOut.u16GetMajorVersion()))
   {
      enData = FI_EN_T_RESERVED;
   }
   return oOut.oWrite((tU8)enData);
}

tU32 fi_tcl_e8_SignPostDestStatus::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 1;
}

tBool fi_tcl_e8_SignPostDestStatus::operator==(const fi_tcl_e8_SignPostDestStatus& rfoCmp) const
{
   return enType == rfoCmp.enType;
}

fi_tclInContext& fi_tcl_e8_SignPostDestStatus::oRead(fi_tclInContext& oIn)
{
   tU8 u8Value;
   oIn >> u8Value;
   enType = (tenType)u8Value;
   return oIn;
}

fi_tclOutContext& fi_tcl_e8_SignPostDestStatus::oWrite(fi_tclOutContext& oOut) const
{
   return oOut.oWrite((tU8)enType);
}

tU32 fi_tcl_e8_DirectionStatus::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 1;
}

tBool fi_tcl_e8_DirectionStatus::operator==(const fi_tcl_e8_DirectionStatus& rfoCmp) const
{
   return enType == rfoCmp.enType;
}

fi_tclInContext& fi_tcl_e8_DirectionStatus::oRead(fi_tclInContext& oIn)
{
   tU8 u8Value;
   oIn >> u8Value;
   enType = (tenType)u8Value;
   return oIn;
}

fi_tclOutContext& fi_tcl_e8_DirectionStatus::oWrite(fi_tclOutContext& oOut) const
{
   fi_tcl_e8_DirectionStatus::tenType enData = enType;
   if ((enData == FI_EN_PREFERRED) && !(9 <= oOut.u16GetMajorVersion()))
   {
      enData = FI_EN_UNKNOWN;
   }
   return oOut.oWrite((tU8)enData);
}

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
fi_tcl_SignPostDestDirection::fi_tcl_SignPostDestDirection(const fi_tcl_SignPostDestDirection& coRef):fi_tclVisitableTypeBase(coRef)
{
   DirectionIsValid = coRef.DirectionIsValid;
   Direction = coRef.Direction;
   DirectionDesc = coRef.DirectionDesc;
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
fi_tcl_SignPostDestDirection& fi_tcl_SignPostDestDirection::operator=(const fi_tcl_SignPostDestDirection& coRef)
{
   if (this == &coRef) return *this;
   DirectionIsValid = coRef.DirectionIsValid;
   Direction = coRef.Direction;
   DirectionDesc = coRef.DirectionDesc;
   return *this;
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
tVoid fi_tcl_SignPostDestDirection::vDestroy()
{
   DirectionDesc.vDestroy();
}

tU32 fi_tcl_SignPostDestDirection::u32GetSize(tU16 u16MajorVersion) const
{
   tU32 u32DynamicSize = 0;
   if (u16MajorVersion <= 8)
   {
      u32DynamicSize += 1;
   }
   return u32DynamicSize+1+DirectionDesc.u32GetSize(u16MajorVersion);
}

tBool fi_tcl_SignPostDestDirection::operator==(const fi_tcl_SignPostDestDirection& rfoCmp) const
{
   tBool bResult = true;
      bResult = bResult && (DirectionIsValid == rfoCmp.DirectionIsValid);
      bResult = bResult && (Direction == rfoCmp.Direction);
      bResult = bResult && (DirectionDesc == rfoCmp.DirectionDesc);
   return bResult;
}

fi_tclInContext& fi_tcl_SignPostDestDirection::oRead(fi_tclInContext& oIn)
{
   if (oIn.u16GetMajorVersion() <= 8)
   {
      oIn >> DirectionIsValid;
   }
   oIn >> Direction;
   oIn >> DirectionDesc;
   return oIn;
}

fi_tclOutContext& fi_tcl_SignPostDestDirection::oWrite(fi_tclOutContext& oOut) const
{
   if (oOut.u16GetMajorVersion() <= 8)
   {
      oOut << DirectionIsValid;
   }
   oOut << Direction;
   oOut << DirectionDesc;
   return oOut;
}

tU32 fi_tcl_e8_DirectionCategory::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 1;
}

tBool fi_tcl_e8_DirectionCategory::operator==(const fi_tcl_e8_DirectionCategory& rfoCmp) const
{
   return enType == rfoCmp.enType;
}

fi_tclInContext& fi_tcl_e8_DirectionCategory::oRead(fi_tclInContext& oIn)
{
   tU8 u8Value;
   oIn >> u8Value;
   enType = (tenType)u8Value;
   return oIn;
}

fi_tclOutContext& fi_tcl_e8_DirectionCategory::oWrite(fi_tclOutContext& oOut) const
{
   fi_tcl_e8_DirectionCategory::tenType enData = enType;
   if ((enData == FI_EN_T_COMPASSDIRECTION) && !(9 <= oOut.u16GetMajorVersion()))
   {
      enData = FI_EN_T_RESERVED;
   }
   return oOut.oWrite((tU8)enData);
}

tU32 fi_tcl_e8_NavOneCellCategory::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 1;
}

tBool fi_tcl_e8_NavOneCellCategory::operator==(const fi_tcl_e8_NavOneCellCategory& rfoCmp) const
{
   return enType == rfoCmp.enType;
}

fi_tclInContext& fi_tcl_e8_NavOneCellCategory::oRead(fi_tclInContext& oIn)
{
   tU8 u8Value;
   oIn >> u8Value;
   enType = (tenType)u8Value;
   return oIn;
}

fi_tclOutContext& fi_tcl_e8_NavOneCellCategory::oWrite(fi_tclOutContext& oOut) const
{
   return oOut.oWrite((tU8)enType);
}

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
fi_tcl_DirectionCategory::fi_tcl_DirectionCategory(const fi_tcl_DirectionCategory& coRef):fi_tclVisitableTypeBase(coRef)
{
   DirectionCategoryType = coRef.DirectionCategoryType;
   if  (coRef.poDirectionCategoryData)
   {
      switch(DirectionCategoryType.enType)
      {
      case fi_tcl_e8_DirectionCategory::FI_EN_T_RESERVED:
         poDirectionCategoryData = OSAL_NEW fi_tcl_Reserved((const fi_tcl_Reserved&)*coRef.poDirectionCategoryData);
         break;
      case fi_tcl_e8_DirectionCategory::FI_EN_T_COUNTRYNAMEELEMENT:
         poDirectionCategoryData = OSAL_NEW fi_tcl_CountryNameElement((const fi_tcl_CountryNameElement&)*coRef.poDirectionCategoryData);
         break;
      case fi_tcl_e8_DirectionCategory::FI_EN_T_STATENAMEELEMENT:
         poDirectionCategoryData = OSAL_NEW fi_tcl_StateNameElement((const fi_tcl_StateNameElement&)*coRef.poDirectionCategoryData);
         break;
      case fi_tcl_e8_DirectionCategory::FI_EN_T_COUNTYNAMEELEMENT:
         poDirectionCategoryData = OSAL_NEW fi_tcl_CountyNameElement((const fi_tcl_CountyNameElement&)*coRef.poDirectionCategoryData);
         break;
      case fi_tcl_e8_DirectionCategory::FI_EN_T_CITYNAMEELEMENT:
         poDirectionCategoryData = OSAL_NEW fi_tcl_CityNameElement((const fi_tcl_CityNameElement&)*coRef.poDirectionCategoryData);
         break;
      case fi_tcl_e8_DirectionCategory::FI_EN_T_CITYDISTRICTNAMEELEMENT:
         poDirectionCategoryData = OSAL_NEW fi_tcl_CityDistrictNameElement((const fi_tcl_CityDistrictNameElement&)*coRef.poDirectionCategoryData);
         break;
      case fi_tcl_e8_DirectionCategory::FI_EN_T_BUILDUPAREANAMEELEMENT:
         poDirectionCategoryData = OSAL_NEW fi_tcl_BuildUpAreaNameElement((const fi_tcl_BuildUpAreaNameElement&)*coRef.poDirectionCategoryData);
         break;
      case fi_tcl_e8_DirectionCategory::FI_EN_T_ROADNAMEELEMENT:
         poDirectionCategoryData = OSAL_NEW fi_tcl_RoadNameElement((const fi_tcl_RoadNameElement&)*coRef.poDirectionCategoryData);
         break;
      case fi_tcl_e8_DirectionCategory::FI_EN_T_ROADNUMBER:
         poDirectionCategoryData = OSAL_NEW fi_tcl_RoadNumber((const fi_tcl_RoadNumber&)*coRef.poDirectionCategoryData);
         break;
      case fi_tcl_e8_DirectionCategory::FI_EN_T_INTERSECTIONNAMEELEMENT:
         poDirectionCategoryData = OSAL_NEW fi_tcl_IntersectionNameElement((const fi_tcl_IntersectionNameElement&)*coRef.poDirectionCategoryData);
         break;
      case fi_tcl_e8_DirectionCategory::FI_EN_T_INTERSECTIONNUMBERELEMENT:
         poDirectionCategoryData = OSAL_NEW fi_tcl_IntersectionNumberElement((const fi_tcl_IntersectionNumberElement&)*coRef.poDirectionCategoryData);
         break;
      case fi_tcl_e8_DirectionCategory::FI_EN_T_POINTOFINTERESTELEMENT:
         poDirectionCategoryData = OSAL_NEW fi_tcl_PointOfInterestElement((const fi_tcl_PointOfInterestElement&)*coRef.poDirectionCategoryData);
         break;
      case fi_tcl_e8_DirectionCategory::FI_EN_T_UNSPECIFIEDTEXT:
         poDirectionCategoryData = OSAL_NEW fi_tcl_UnspecifiedText((const fi_tcl_UnspecifiedText&)*coRef.poDirectionCategoryData);
         break;
      case fi_tcl_e8_DirectionCategory::FI_EN_T_COMPASSDIRECTION:
         poDirectionCategoryData = OSAL_NEW fi_tcl_CompassDirection((const fi_tcl_CompassDirection&)*coRef.poDirectionCategoryData);
         break;
      default:
         poDirectionCategoryData = OSAL_NULL;
      }
   }
   else
   {
      poDirectionCategoryData = OSAL_NULL;
   }
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
fi_tcl_DirectionCategory& fi_tcl_DirectionCategory::operator=(const fi_tcl_DirectionCategory& coRef)
{
   if (this == &coRef) return *this;
   OSAL_DELETE poDirectionCategoryData;
   DirectionCategoryType = coRef.DirectionCategoryType;
   if  (coRef.poDirectionCategoryData)
   {
      switch(DirectionCategoryType.enType)
      {
      case fi_tcl_e8_DirectionCategory::FI_EN_T_RESERVED:
         poDirectionCategoryData = OSAL_NEW fi_tcl_Reserved((const fi_tcl_Reserved&)*coRef.poDirectionCategoryData);
         break;
      case fi_tcl_e8_DirectionCategory::FI_EN_T_COUNTRYNAMEELEMENT:
         poDirectionCategoryData = OSAL_NEW fi_tcl_CountryNameElement((const fi_tcl_CountryNameElement&)*coRef.poDirectionCategoryData);
         break;
      case fi_tcl_e8_DirectionCategory::FI_EN_T_STATENAMEELEMENT:
         poDirectionCategoryData = OSAL_NEW fi_tcl_StateNameElement((const fi_tcl_StateNameElement&)*coRef.poDirectionCategoryData);
         break;
      case fi_tcl_e8_DirectionCategory::FI_EN_T_COUNTYNAMEELEMENT:
         poDirectionCategoryData = OSAL_NEW fi_tcl_CountyNameElement((const fi_tcl_CountyNameElement&)*coRef.poDirectionCategoryData);
         break;
      case fi_tcl_e8_DirectionCategory::FI_EN_T_CITYNAMEELEMENT:
         poDirectionCategoryData = OSAL_NEW fi_tcl_CityNameElement((const fi_tcl_CityNameElement&)*coRef.poDirectionCategoryData);
         break;
      case fi_tcl_e8_DirectionCategory::FI_EN_T_CITYDISTRICTNAMEELEMENT:
         poDirectionCategoryData = OSAL_NEW fi_tcl_CityDistrictNameElement((const fi_tcl_CityDistrictNameElement&)*coRef.poDirectionCategoryData);
         break;
      case fi_tcl_e8_DirectionCategory::FI_EN_T_BUILDUPAREANAMEELEMENT:
         poDirectionCategoryData = OSAL_NEW fi_tcl_BuildUpAreaNameElement((const fi_tcl_BuildUpAreaNameElement&)*coRef.poDirectionCategoryData);
         break;
      case fi_tcl_e8_DirectionCategory::FI_EN_T_ROADNAMEELEMENT:
         poDirectionCategoryData = OSAL_NEW fi_tcl_RoadNameElement((const fi_tcl_RoadNameElement&)*coRef.poDirectionCategoryData);
         break;
      case fi_tcl_e8_DirectionCategory::FI_EN_T_ROADNUMBER:
         poDirectionCategoryData = OSAL_NEW fi_tcl_RoadNumber((const fi_tcl_RoadNumber&)*coRef.poDirectionCategoryData);
         break;
      case fi_tcl_e8_DirectionCategory::FI_EN_T_INTERSECTIONNAMEELEMENT:
         poDirectionCategoryData = OSAL_NEW fi_tcl_IntersectionNameElement((const fi_tcl_IntersectionNameElement&)*coRef.poDirectionCategoryData);
         break;
      case fi_tcl_e8_DirectionCategory::FI_EN_T_INTERSECTIONNUMBERELEMENT:
         poDirectionCategoryData = OSAL_NEW fi_tcl_IntersectionNumberElement((const fi_tcl_IntersectionNumberElement&)*coRef.poDirectionCategoryData);
         break;
      case fi_tcl_e8_DirectionCategory::FI_EN_T_POINTOFINTERESTELEMENT:
         poDirectionCategoryData = OSAL_NEW fi_tcl_PointOfInterestElement((const fi_tcl_PointOfInterestElement&)*coRef.poDirectionCategoryData);
         break;
      case fi_tcl_e8_DirectionCategory::FI_EN_T_UNSPECIFIEDTEXT:
         poDirectionCategoryData = OSAL_NEW fi_tcl_UnspecifiedText((const fi_tcl_UnspecifiedText&)*coRef.poDirectionCategoryData);
         break;
      case fi_tcl_e8_DirectionCategory::FI_EN_T_COMPASSDIRECTION:
         poDirectionCategoryData = OSAL_NEW fi_tcl_CompassDirection((const fi_tcl_CompassDirection&)*coRef.poDirectionCategoryData);
         break;
      default:
         poDirectionCategoryData = OSAL_NULL;
      }
   }
   else
   {
      poDirectionCategoryData = OSAL_NULL;
   }
   return *this;
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
fi_tcl_DirectionCategory::~fi_tcl_DirectionCategory()
{
   OSAL_DELETE poDirectionCategoryData;
   poDirectionCategoryData = OSAL_NULL;
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
tVoid fi_tcl_DirectionCategory::vDestroy()
{
   if (poDirectionCategoryData)
   {
      poDirectionCategoryData->vDestroy();
      OSAL_DELETE poDirectionCategoryData;
      poDirectionCategoryData = OSAL_NULL;
   }
}

tU32 fi_tcl_DirectionCategory::u32GetSize(tU16 u16MajorVersion) const
{
   tU32 u32DynamicSize = 0;
   if (DirectionCategoryType.enType == fi_tcl_e8_DirectionCategory::FI_EN_T_RESERVED)
      u32DynamicSize += (poDirectionCategoryData?poDirectionCategoryData->u32GetSize(u16MajorVersion):0);
   if (DirectionCategoryType.enType == fi_tcl_e8_DirectionCategory::FI_EN_T_COUNTRYNAMEELEMENT)
      u32DynamicSize += (poDirectionCategoryData?poDirectionCategoryData->u32GetSize(u16MajorVersion):0);
   if (DirectionCategoryType.enType == fi_tcl_e8_DirectionCategory::FI_EN_T_STATENAMEELEMENT)
      u32DynamicSize += (poDirectionCategoryData?poDirectionCategoryData->u32GetSize(u16MajorVersion):0);
   if (DirectionCategoryType.enType == fi_tcl_e8_DirectionCategory::FI_EN_T_COUNTYNAMEELEMENT)
      u32DynamicSize += (poDirectionCategoryData?poDirectionCategoryData->u32GetSize(u16MajorVersion):0);
   if (DirectionCategoryType.enType == fi_tcl_e8_DirectionCategory::FI_EN_T_CITYNAMEELEMENT)
      u32DynamicSize += (poDirectionCategoryData?poDirectionCategoryData->u32GetSize(u16MajorVersion):0);
   if (DirectionCategoryType.enType == fi_tcl_e8_DirectionCategory::FI_EN_T_CITYDISTRICTNAMEELEMENT)
      u32DynamicSize += (poDirectionCategoryData?poDirectionCategoryData->u32GetSize(u16MajorVersion):0);
   if (DirectionCategoryType.enType == fi_tcl_e8_DirectionCategory::FI_EN_T_BUILDUPAREANAMEELEMENT)
      u32DynamicSize += (poDirectionCategoryData?poDirectionCategoryData->u32GetSize(u16MajorVersion):0);
   if (DirectionCategoryType.enType == fi_tcl_e8_DirectionCategory::FI_EN_T_ROADNAMEELEMENT)
      u32DynamicSize += (poDirectionCategoryData?poDirectionCategoryData->u32GetSize(u16MajorVersion):0);
   if (DirectionCategoryType.enType == fi_tcl_e8_DirectionCategory::FI_EN_T_ROADNUMBER)
      u32DynamicSize += (poDirectionCategoryData?poDirectionCategoryData->u32GetSize(u16MajorVersion):0);
   if (DirectionCategoryType.enType == fi_tcl_e8_DirectionCategory::FI_EN_T_INTERSECTIONNAMEELEMENT)
      u32DynamicSize += (poDirectionCategoryData?poDirectionCategoryData->u32GetSize(u16MajorVersion):0);
   if (DirectionCategoryType.enType == fi_tcl_e8_DirectionCategory::FI_EN_T_INTERSECTIONNUMBERELEMENT)
      u32DynamicSize += (poDirectionCategoryData?poDirectionCategoryData->u32GetSize(u16MajorVersion):0);
   if (DirectionCategoryType.enType == fi_tcl_e8_DirectionCategory::FI_EN_T_POINTOFINTERESTELEMENT)
      u32DynamicSize += (poDirectionCategoryData?poDirectionCategoryData->u32GetSize(u16MajorVersion):0);
   if (DirectionCategoryType.enType == fi_tcl_e8_DirectionCategory::FI_EN_T_UNSPECIFIEDTEXT)
      u32DynamicSize += (poDirectionCategoryData?poDirectionCategoryData->u32GetSize(u16MajorVersion):0);
   if ((DirectionCategoryType.enType == fi_tcl_e8_DirectionCategory::FI_EN_T_COMPASSDIRECTION) &&
       (9 <= u16MajorVersion))
      u32DynamicSize += (poDirectionCategoryData?poDirectionCategoryData->u32GetSize(u16MajorVersion):0);
   return u32DynamicSize+1;
}

tBool fi_tcl_DirectionCategory::operator==(const fi_tcl_DirectionCategory& rfoCmp) const
{
   tBool bResult = true;
   bResult = bResult && (DirectionCategoryType == rfoCmp.DirectionCategoryType);
   if (bResult && poDirectionCategoryData && rfoCmp.poDirectionCategoryData) 
   {
      switch (DirectionCategoryType.enType)
      {
      case fi_tcl_e8_DirectionCategory::FI_EN_T_RESERVED:
         bResult = bResult && (*(const fi_tcl_Reserved*)poDirectionCategoryData == *(const fi_tcl_Reserved*)rfoCmp.poDirectionCategoryData); //lint !e826
      break;
      case fi_tcl_e8_DirectionCategory::FI_EN_T_COUNTRYNAMEELEMENT:
         bResult = bResult && (*(const fi_tcl_CountryNameElement*)poDirectionCategoryData == *(const fi_tcl_CountryNameElement*)rfoCmp.poDirectionCategoryData); //lint !e826
      break;
      case fi_tcl_e8_DirectionCategory::FI_EN_T_STATENAMEELEMENT:
         bResult = bResult && (*(const fi_tcl_StateNameElement*)poDirectionCategoryData == *(const fi_tcl_StateNameElement*)rfoCmp.poDirectionCategoryData); //lint !e826
      break;
      case fi_tcl_e8_DirectionCategory::FI_EN_T_COUNTYNAMEELEMENT:
         bResult = bResult && (*(const fi_tcl_CountyNameElement*)poDirectionCategoryData == *(const fi_tcl_CountyNameElement*)rfoCmp.poDirectionCategoryData); //lint !e826
      break;
      case fi_tcl_e8_DirectionCategory::FI_EN_T_CITYNAMEELEMENT:
         bResult = bResult && (*(const fi_tcl_CityNameElement*)poDirectionCategoryData == *(const fi_tcl_CityNameElement*)rfoCmp.poDirectionCategoryData); //lint !e826
      break;
      case fi_tcl_e8_DirectionCategory::FI_EN_T_CITYDISTRICTNAMEELEMENT:
         bResult = bResult && (*(const fi_tcl_CityDistrictNameElement*)poDirectionCategoryData == *(const fi_tcl_CityDistrictNameElement*)rfoCmp.poDirectionCategoryData); //lint !e826
      break;
      case fi_tcl_e8_DirectionCategory::FI_EN_T_BUILDUPAREANAMEELEMENT:
         bResult = bResult && (*(const fi_tcl_BuildUpAreaNameElement*)poDirectionCategoryData == *(const fi_tcl_BuildUpAreaNameElement*)rfoCmp.poDirectionCategoryData); //lint !e826
      break;
      case fi_tcl_e8_DirectionCategory::FI_EN_T_ROADNAMEELEMENT:
         bResult = bResult && (*(const fi_tcl_RoadNameElement*)poDirectionCategoryData == *(const fi_tcl_RoadNameElement*)rfoCmp.poDirectionCategoryData); //lint !e826
      break;
      case fi_tcl_e8_DirectionCategory::FI_EN_T_ROADNUMBER:
         bResult = bResult && (*(const fi_tcl_RoadNumber*)poDirectionCategoryData == *(const fi_tcl_RoadNumber*)rfoCmp.poDirectionCategoryData); //lint !e826
      break;
      case fi_tcl_e8_DirectionCategory::FI_EN_T_INTERSECTIONNAMEELEMENT:
         bResult = bResult && (*(const fi_tcl_IntersectionNameElement*)poDirectionCategoryData == *(const fi_tcl_IntersectionNameElement*)rfoCmp.poDirectionCategoryData); //lint !e826
      break;
      case fi_tcl_e8_DirectionCategory::FI_EN_T_INTERSECTIONNUMBERELEMENT:
         bResult = bResult && (*(const fi_tcl_IntersectionNumberElement*)poDirectionCategoryData == *(const fi_tcl_IntersectionNumberElement*)rfoCmp.poDirectionCategoryData); //lint !e826
      break;
      case fi_tcl_e8_DirectionCategory::FI_EN_T_POINTOFINTERESTELEMENT:
         bResult = bResult && (*(const fi_tcl_PointOfInterestElement*)poDirectionCategoryData == *(const fi_tcl_PointOfInterestElement*)rfoCmp.poDirectionCategoryData); //lint !e826
      break;
      case fi_tcl_e8_DirectionCategory::FI_EN_T_UNSPECIFIEDTEXT:
         bResult = bResult && (*(const fi_tcl_UnspecifiedText*)poDirectionCategoryData == *(const fi_tcl_UnspecifiedText*)rfoCmp.poDirectionCategoryData); //lint !e826
      break;
      case fi_tcl_e8_DirectionCategory::FI_EN_T_COMPASSDIRECTION:
         bResult = bResult && (*(const fi_tcl_CompassDirection*)poDirectionCategoryData == *(const fi_tcl_CompassDirection*)rfoCmp.poDirectionCategoryData); //lint !e826
      break;
      }
   }
   else
   {
      bResult = bResult && (poDirectionCategoryData == rfoCmp.poDirectionCategoryData);
   }
   return bResult;
}

fi_tclInContext& fi_tcl_DirectionCategory::oRead(fi_tclInContext& oIn)
{
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   OSAL_DELETE poDirectionCategoryData;
#else
   if (poDirectionCategoryData)
   {
      poDirectionCategoryData->vDestroy();
      OSAL_DELETE poDirectionCategoryData;
   }
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
   oIn >> DirectionCategoryType;
   switch(DirectionCategoryType.enType)
   {
   case fi_tcl_e8_DirectionCategory::FI_EN_T_RESERVED:
      poDirectionCategoryData = OSAL_NEW fi_tcl_Reserved;
      break;
   case fi_tcl_e8_DirectionCategory::FI_EN_T_COUNTRYNAMEELEMENT:
      poDirectionCategoryData = OSAL_NEW fi_tcl_CountryNameElement;
      break;
   case fi_tcl_e8_DirectionCategory::FI_EN_T_STATENAMEELEMENT:
      poDirectionCategoryData = OSAL_NEW fi_tcl_StateNameElement;
      break;
   case fi_tcl_e8_DirectionCategory::FI_EN_T_COUNTYNAMEELEMENT:
      poDirectionCategoryData = OSAL_NEW fi_tcl_CountyNameElement;
      break;
   case fi_tcl_e8_DirectionCategory::FI_EN_T_CITYNAMEELEMENT:
      poDirectionCategoryData = OSAL_NEW fi_tcl_CityNameElement;
      break;
   case fi_tcl_e8_DirectionCategory::FI_EN_T_CITYDISTRICTNAMEELEMENT:
      poDirectionCategoryData = OSAL_NEW fi_tcl_CityDistrictNameElement;
      break;
   case fi_tcl_e8_DirectionCategory::FI_EN_T_BUILDUPAREANAMEELEMENT:
      poDirectionCategoryData = OSAL_NEW fi_tcl_BuildUpAreaNameElement;
      break;
   case fi_tcl_e8_DirectionCategory::FI_EN_T_ROADNAMEELEMENT:
      poDirectionCategoryData = OSAL_NEW fi_tcl_RoadNameElement;
      break;
   case fi_tcl_e8_DirectionCategory::FI_EN_T_ROADNUMBER:
      poDirectionCategoryData = OSAL_NEW fi_tcl_RoadNumber;
      break;
   case fi_tcl_e8_DirectionCategory::FI_EN_T_INTERSECTIONNAMEELEMENT:
      poDirectionCategoryData = OSAL_NEW fi_tcl_IntersectionNameElement;
      break;
   case fi_tcl_e8_DirectionCategory::FI_EN_T_INTERSECTIONNUMBERELEMENT:
      poDirectionCategoryData = OSAL_NEW fi_tcl_IntersectionNumberElement;
      break;
   case fi_tcl_e8_DirectionCategory::FI_EN_T_POINTOFINTERESTELEMENT:
      poDirectionCategoryData = OSAL_NEW fi_tcl_PointOfInterestElement;
      break;
   case fi_tcl_e8_DirectionCategory::FI_EN_T_UNSPECIFIEDTEXT:
      poDirectionCategoryData = OSAL_NEW fi_tcl_UnspecifiedText;
      break;
   case fi_tcl_e8_DirectionCategory::FI_EN_T_COMPASSDIRECTION:
      poDirectionCategoryData = OSAL_NEW fi_tcl_CompassDirection;
      break;
   default:
      oIn.Invalidate();
      poDirectionCategoryData = OSAL_NULL;
   }
   if (poDirectionCategoryData && oIn.bIsValid())
      poDirectionCategoryData->oRead(oIn);
   else
      oIn.Invalidate();
   return oIn;
}

fi_tclOutContext& fi_tcl_DirectionCategory::oWrite(fi_tclOutContext& oOut) const
{
   oOut << DirectionCategoryType;
   if (poDirectionCategoryData)
   {
      if (DirectionCategoryType.enType == fi_tcl_e8_DirectionCategory::FI_EN_T_RESERVED)
      {
         poDirectionCategoryData->oWrite(oOut);
      }
      if (DirectionCategoryType.enType == fi_tcl_e8_DirectionCategory::FI_EN_T_COUNTRYNAMEELEMENT)
      {
         poDirectionCategoryData->oWrite(oOut);
      }
      if (DirectionCategoryType.enType == fi_tcl_e8_DirectionCategory::FI_EN_T_STATENAMEELEMENT)
      {
         poDirectionCategoryData->oWrite(oOut);
      }
      if (DirectionCategoryType.enType == fi_tcl_e8_DirectionCategory::FI_EN_T_COUNTYNAMEELEMENT)
      {
         poDirectionCategoryData->oWrite(oOut);
      }
      if (DirectionCategoryType.enType == fi_tcl_e8_DirectionCategory::FI_EN_T_CITYNAMEELEMENT)
      {
         poDirectionCategoryData->oWrite(oOut);
      }
      if (DirectionCategoryType.enType == fi_tcl_e8_DirectionCategory::FI_EN_T_CITYDISTRICTNAMEELEMENT)
      {
         poDirectionCategoryData->oWrite(oOut);
      }
      if (DirectionCategoryType.enType == fi_tcl_e8_DirectionCategory::FI_EN_T_BUILDUPAREANAMEELEMENT)
      {
         poDirectionCategoryData->oWrite(oOut);
      }
      if (DirectionCategoryType.enType == fi_tcl_e8_DirectionCategory::FI_EN_T_ROADNAMEELEMENT)
      {
         poDirectionCategoryData->oWrite(oOut);
      }
      if (DirectionCategoryType.enType == fi_tcl_e8_DirectionCategory::FI_EN_T_ROADNUMBER)
      {
         poDirectionCategoryData->oWrite(oOut);
      }
      if (DirectionCategoryType.enType == fi_tcl_e8_DirectionCategory::FI_EN_T_INTERSECTIONNAMEELEMENT)
      {
         poDirectionCategoryData->oWrite(oOut);
      }
      if (DirectionCategoryType.enType == fi_tcl_e8_DirectionCategory::FI_EN_T_INTERSECTIONNUMBERELEMENT)
      {
         poDirectionCategoryData->oWrite(oOut);
      }
      if (DirectionCategoryType.enType == fi_tcl_e8_DirectionCategory::FI_EN_T_POINTOFINTERESTELEMENT)
      {
         poDirectionCategoryData->oWrite(oOut);
      }
      if (DirectionCategoryType.enType == fi_tcl_e8_DirectionCategory::FI_EN_T_UNSPECIFIEDTEXT)
      {
         poDirectionCategoryData->oWrite(oOut);
      }
      if (DirectionCategoryType.enType == fi_tcl_e8_DirectionCategory::FI_EN_T_COMPASSDIRECTION)
      {
         if (!(9 <= oOut.u16GetMajorVersion()))
         {
            fi_tcl_Reserved oDefault;
            oOut << oDefault;
         }
         else
         {
            poDirectionCategoryData->oWrite(oOut);
         }
      }
   }
   else
   {
      oOut.Invalidate();
   }
   return oOut;
}

tU32 fi_tcl_b8_DirectionInfoStatus::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 1;
}

tBool fi_tcl_b8_DirectionInfoStatus::operator==(const fi_tcl_b8_DirectionInfoStatus& rfoCmp) const
{
   return u8Value == rfoCmp.u8Value;
}

fi_tclInContext& fi_tcl_b8_DirectionInfoStatus::oRead(fi_tclInContext& oIn)
{
   return oIn >> u8Value;
}

fi_tclOutContext& fi_tcl_b8_DirectionInfoStatus::oWrite(fi_tclOutContext& oOut) const
{
   return oOut << u8Value;
}

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
fi_tcl_DirectionInfo::fi_tcl_DirectionInfo(const fi_tcl_DirectionInfo& coRef):fi_tclVisitableTypeBase(coRef)
{
   DirectionID = coRef.DirectionID;
   DirectionCategory = coRef.DirectionCategory;
   DirectionStatus = coRef.DirectionStatus;
   Status = coRef.Status;
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
fi_tcl_DirectionInfo& fi_tcl_DirectionInfo::operator=(const fi_tcl_DirectionInfo& coRef)
{
   if (this == &coRef) return *this;
   DirectionID = coRef.DirectionID;
   DirectionCategory = coRef.DirectionCategory;
   DirectionStatus = coRef.DirectionStatus;
   Status = coRef.Status;
   return *this;
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
tVoid fi_tcl_DirectionInfo::vDestroy()
{
   DirectionCategory.vDestroy(); 
}

tU32 fi_tcl_DirectionInfo::u32GetSize(tU16 u16MajorVersion) const
{
   tU32 u32DynamicSize = 0;
   if (21 <= u16MajorVersion)
   {
      u32DynamicSize += 1;
   }
   return u32DynamicSize+5+DirectionCategory.u32GetSize(u16MajorVersion);
}

tBool fi_tcl_DirectionInfo::operator==(const fi_tcl_DirectionInfo& rfoCmp) const
{
   tBool bResult = true;
      bResult = bResult && (DirectionID == rfoCmp.DirectionID);
      bResult = bResult && (DirectionCategory == rfoCmp.DirectionCategory);
      bResult = bResult && (DirectionStatus == rfoCmp.DirectionStatus);
      bResult = bResult && (Status == rfoCmp.Status);
   return bResult;
}

fi_tclInContext& fi_tcl_DirectionInfo::oRead(fi_tclInContext& oIn)
{
   oIn >> DirectionID;
   oIn >> DirectionCategory;
   oIn >> DirectionStatus;
   if (21 <= oIn.u16GetMajorVersion())
   {
      oIn >> Status;
   }
   return oIn;
}

fi_tclOutContext& fi_tcl_DirectionInfo::oWrite(fi_tclOutContext& oOut) const
{
   oOut << DirectionID;
   oOut << DirectionCategory;
   oOut << DirectionStatus;
   if (21 <= oOut.u16GetMajorVersion())
   {
      oOut << Status;
   }
   return oOut;
}

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
fi_tcl_SignPostDestination::fi_tcl_SignPostDestination(const fi_tcl_SignPostDestination& coRef):fi_tclVisitableTypeBase(coRef)
{
   Type = coRef.Type;
   SignPostDestinationCategoryType = coRef.SignPostDestinationCategoryType;
   if  (coRef.poSignPostDestinationCategoryData)
   {
      switch(SignPostDestinationCategoryType.enType)
      {
      case fi_tcl_e8_SignPostDestinationCategory::FI_EN_T_RESERVED:
         poSignPostDestinationCategoryData = OSAL_NEW fi_tcl_Reserved((const fi_tcl_Reserved&)*coRef.poSignPostDestinationCategoryData);
         break;
      case fi_tcl_e8_SignPostDestinationCategory::FI_EN_T_COUNTRYNAMEELEMENT:
         poSignPostDestinationCategoryData = OSAL_NEW fi_tcl_CountryNameElement((const fi_tcl_CountryNameElement&)*coRef.poSignPostDestinationCategoryData);
         break;
      case fi_tcl_e8_SignPostDestinationCategory::FI_EN_T_STATENAMEELEMENT:
         poSignPostDestinationCategoryData = OSAL_NEW fi_tcl_StateNameElement((const fi_tcl_StateNameElement&)*coRef.poSignPostDestinationCategoryData);
         break;
      case fi_tcl_e8_SignPostDestinationCategory::FI_EN_T_COUNTYNAMEELEMENT:
         poSignPostDestinationCategoryData = OSAL_NEW fi_tcl_CountyNameElement((const fi_tcl_CountyNameElement&)*coRef.poSignPostDestinationCategoryData);
         break;
      case fi_tcl_e8_SignPostDestinationCategory::FI_EN_T_CITYNAMEELEMENT:
         poSignPostDestinationCategoryData = OSAL_NEW fi_tcl_CityNameElement((const fi_tcl_CityNameElement&)*coRef.poSignPostDestinationCategoryData);
         break;
      case fi_tcl_e8_SignPostDestinationCategory::FI_EN_T_CITYDISTRICTNAMEELEMENT:
         poSignPostDestinationCategoryData = OSAL_NEW fi_tcl_CityDistrictNameElement((const fi_tcl_CityDistrictNameElement&)*coRef.poSignPostDestinationCategoryData);
         break;
      case fi_tcl_e8_SignPostDestinationCategory::FI_EN_T_BUILDUPAREANAMEELEMENT:
         poSignPostDestinationCategoryData = OSAL_NEW fi_tcl_BuildUpAreaNameElement((const fi_tcl_BuildUpAreaNameElement&)*coRef.poSignPostDestinationCategoryData);
         break;
      case fi_tcl_e8_SignPostDestinationCategory::FI_EN_T_ROADNAMEELEMENT:
         poSignPostDestinationCategoryData = OSAL_NEW fi_tcl_RoadNameElement((const fi_tcl_RoadNameElement&)*coRef.poSignPostDestinationCategoryData);
         break;
      case fi_tcl_e8_SignPostDestinationCategory::FI_EN_T_ROADNUMBER:
         poSignPostDestinationCategoryData = OSAL_NEW fi_tcl_RoadNumber((const fi_tcl_RoadNumber&)*coRef.poSignPostDestinationCategoryData);
         break;
      case fi_tcl_e8_SignPostDestinationCategory::FI_EN_T_INTERSECTIONNAMEELEMENT:
         poSignPostDestinationCategoryData = OSAL_NEW fi_tcl_IntersectionNameElement((const fi_tcl_IntersectionNameElement&)*coRef.poSignPostDestinationCategoryData);
         break;
      case fi_tcl_e8_SignPostDestinationCategory::FI_EN_T_INTERSECTIONNUMBERELEMENT:
         poSignPostDestinationCategoryData = OSAL_NEW fi_tcl_IntersectionNumberElement((const fi_tcl_IntersectionNumberElement&)*coRef.poSignPostDestinationCategoryData);
         break;
      case fi_tcl_e8_SignPostDestinationCategory::FI_EN_T_POINTOFINTERESTELEMENT:
         poSignPostDestinationCategoryData = OSAL_NEW fi_tcl_PointOfInterestElement((const fi_tcl_PointOfInterestElement&)*coRef.poSignPostDestinationCategoryData);
         break;
      case fi_tcl_e8_SignPostDestinationCategory::FI_EN_T_UNSPECIFIEDTEXT:
         poSignPostDestinationCategoryData = OSAL_NEW fi_tcl_UnspecifiedText((const fi_tcl_UnspecifiedText&)*coRef.poSignPostDestinationCategoryData);
         break;
      case fi_tcl_e8_SignPostDestinationCategory::FI_EN_T_COMPASSDIRECTION:
         poSignPostDestinationCategoryData = OSAL_NEW fi_tcl_CompassDirection((const fi_tcl_CompassDirection&)*coRef.poSignPostDestinationCategoryData);
         break;
      default:
         poSignPostDestinationCategoryData = OSAL_NULL;
      }
   }
   else
   {
      poSignPostDestinationCategoryData = OSAL_NULL;
   }
   SignPostDestinationDirection = coRef.SignPostDestinationDirection;
   DirectionInfoList = coRef.DirectionInfoList;
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
fi_tcl_SignPostDestination& fi_tcl_SignPostDestination::operator=(const fi_tcl_SignPostDestination& coRef)
{
   if (this == &coRef) return *this;
   Type = coRef.Type;
   OSAL_DELETE poSignPostDestinationCategoryData;
   SignPostDestinationCategoryType = coRef.SignPostDestinationCategoryType;
   if  (coRef.poSignPostDestinationCategoryData)
   {
      switch(SignPostDestinationCategoryType.enType)
      {
      case fi_tcl_e8_SignPostDestinationCategory::FI_EN_T_RESERVED:
         poSignPostDestinationCategoryData = OSAL_NEW fi_tcl_Reserved((const fi_tcl_Reserved&)*coRef.poSignPostDestinationCategoryData);
         break;
      case fi_tcl_e8_SignPostDestinationCategory::FI_EN_T_COUNTRYNAMEELEMENT:
         poSignPostDestinationCategoryData = OSAL_NEW fi_tcl_CountryNameElement((const fi_tcl_CountryNameElement&)*coRef.poSignPostDestinationCategoryData);
         break;
      case fi_tcl_e8_SignPostDestinationCategory::FI_EN_T_STATENAMEELEMENT:
         poSignPostDestinationCategoryData = OSAL_NEW fi_tcl_StateNameElement((const fi_tcl_StateNameElement&)*coRef.poSignPostDestinationCategoryData);
         break;
      case fi_tcl_e8_SignPostDestinationCategory::FI_EN_T_COUNTYNAMEELEMENT:
         poSignPostDestinationCategoryData = OSAL_NEW fi_tcl_CountyNameElement((const fi_tcl_CountyNameElement&)*coRef.poSignPostDestinationCategoryData);
         break;
      case fi_tcl_e8_SignPostDestinationCategory::FI_EN_T_CITYNAMEELEMENT:
         poSignPostDestinationCategoryData = OSAL_NEW fi_tcl_CityNameElement((const fi_tcl_CityNameElement&)*coRef.poSignPostDestinationCategoryData);
         break;
      case fi_tcl_e8_SignPostDestinationCategory::FI_EN_T_CITYDISTRICTNAMEELEMENT:
         poSignPostDestinationCategoryData = OSAL_NEW fi_tcl_CityDistrictNameElement((const fi_tcl_CityDistrictNameElement&)*coRef.poSignPostDestinationCategoryData);
         break;
      case fi_tcl_e8_SignPostDestinationCategory::FI_EN_T_BUILDUPAREANAMEELEMENT:
         poSignPostDestinationCategoryData = OSAL_NEW fi_tcl_BuildUpAreaNameElement((const fi_tcl_BuildUpAreaNameElement&)*coRef.poSignPostDestinationCategoryData);
         break;
      case fi_tcl_e8_SignPostDestinationCategory::FI_EN_T_ROADNAMEELEMENT:
         poSignPostDestinationCategoryData = OSAL_NEW fi_tcl_RoadNameElement((const fi_tcl_RoadNameElement&)*coRef.poSignPostDestinationCategoryData);
         break;
      case fi_tcl_e8_SignPostDestinationCategory::FI_EN_T_ROADNUMBER:
         poSignPostDestinationCategoryData = OSAL_NEW fi_tcl_RoadNumber((const fi_tcl_RoadNumber&)*coRef.poSignPostDestinationCategoryData);
         break;
      case fi_tcl_e8_SignPostDestinationCategory::FI_EN_T_INTERSECTIONNAMEELEMENT:
         poSignPostDestinationCategoryData = OSAL_NEW fi_tcl_IntersectionNameElement((const fi_tcl_IntersectionNameElement&)*coRef.poSignPostDestinationCategoryData);
         break;
      case fi_tcl_e8_SignPostDestinationCategory::FI_EN_T_INTERSECTIONNUMBERELEMENT:
         poSignPostDestinationCategoryData = OSAL_NEW fi_tcl_IntersectionNumberElement((const fi_tcl_IntersectionNumberElement&)*coRef.poSignPostDestinationCategoryData);
         break;
      case fi_tcl_e8_SignPostDestinationCategory::FI_EN_T_POINTOFINTERESTELEMENT:
         poSignPostDestinationCategoryData = OSAL_NEW fi_tcl_PointOfInterestElement((const fi_tcl_PointOfInterestElement&)*coRef.poSignPostDestinationCategoryData);
         break;
      case fi_tcl_e8_SignPostDestinationCategory::FI_EN_T_UNSPECIFIEDTEXT:
         poSignPostDestinationCategoryData = OSAL_NEW fi_tcl_UnspecifiedText((const fi_tcl_UnspecifiedText&)*coRef.poSignPostDestinationCategoryData);
         break;
      case fi_tcl_e8_SignPostDestinationCategory::FI_EN_T_COMPASSDIRECTION:
         poSignPostDestinationCategoryData = OSAL_NEW fi_tcl_CompassDirection((const fi_tcl_CompassDirection&)*coRef.poSignPostDestinationCategoryData);
         break;
      default:
         poSignPostDestinationCategoryData = OSAL_NULL;
      }
   }
   else
   {
      poSignPostDestinationCategoryData = OSAL_NULL;
   }
   SignPostDestinationDirection = coRef.SignPostDestinationDirection;
   DirectionInfoList = coRef.DirectionInfoList;
   return *this;
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
fi_tcl_SignPostDestination::~fi_tcl_SignPostDestination()
{
   OSAL_DELETE poSignPostDestinationCategoryData;
   poSignPostDestinationCategoryData = OSAL_NULL;
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
tVoid fi_tcl_SignPostDestination::vDestroy()
{
   if (poSignPostDestinationCategoryData)
   {
      poSignPostDestinationCategoryData->vDestroy();
      OSAL_DELETE poSignPostDestinationCategoryData;
      poSignPostDestinationCategoryData = OSAL_NULL;
   }
   SignPostDestinationDirection.vDestroy(); 
   {
      for (tU32 u32Idx = 0; u32Idx < DirectionInfoList.size(); ++u32Idx)
         DirectionInfoList[u32Idx].vDestroy();
   }
   DirectionInfoList.clear();
}

tU32 fi_tcl_SignPostDestination::u32GetSize(tU16 u16MajorVersion) const
{
   tU32 u32DynamicSize = 0;
   if (u16MajorVersion <= 8)
   {
      u32DynamicSize += 1;
      if (SignPostDestinationCategoryType.enType == fi_tcl_e8_SignPostDestinationCategory::FI_EN_T_RESERVED)
         u32DynamicSize += (poSignPostDestinationCategoryData?poSignPostDestinationCategoryData->u32GetSize(u16MajorVersion):0);
      if (SignPostDestinationCategoryType.enType == fi_tcl_e8_SignPostDestinationCategory::FI_EN_T_COUNTRYNAMEELEMENT)
         u32DynamicSize += (poSignPostDestinationCategoryData?poSignPostDestinationCategoryData->u32GetSize(u16MajorVersion):0);
      if (SignPostDestinationCategoryType.enType == fi_tcl_e8_SignPostDestinationCategory::FI_EN_T_STATENAMEELEMENT)
         u32DynamicSize += (poSignPostDestinationCategoryData?poSignPostDestinationCategoryData->u32GetSize(u16MajorVersion):0);
      if (SignPostDestinationCategoryType.enType == fi_tcl_e8_SignPostDestinationCategory::FI_EN_T_COUNTYNAMEELEMENT)
         u32DynamicSize += (poSignPostDestinationCategoryData?poSignPostDestinationCategoryData->u32GetSize(u16MajorVersion):0);
      if (SignPostDestinationCategoryType.enType == fi_tcl_e8_SignPostDestinationCategory::FI_EN_T_CITYNAMEELEMENT)
         u32DynamicSize += (poSignPostDestinationCategoryData?poSignPostDestinationCategoryData->u32GetSize(u16MajorVersion):0);
      if (SignPostDestinationCategoryType.enType == fi_tcl_e8_SignPostDestinationCategory::FI_EN_T_CITYDISTRICTNAMEELEMENT)
         u32DynamicSize += (poSignPostDestinationCategoryData?poSignPostDestinationCategoryData->u32GetSize(u16MajorVersion):0);
      if (SignPostDestinationCategoryType.enType == fi_tcl_e8_SignPostDestinationCategory::FI_EN_T_BUILDUPAREANAMEELEMENT)
         u32DynamicSize += (poSignPostDestinationCategoryData?poSignPostDestinationCategoryData->u32GetSize(u16MajorVersion):0);
      if (SignPostDestinationCategoryType.enType == fi_tcl_e8_SignPostDestinationCategory::FI_EN_T_ROADNAMEELEMENT)
         u32DynamicSize += (poSignPostDestinationCategoryData?poSignPostDestinationCategoryData->u32GetSize(u16MajorVersion):0);
      if (SignPostDestinationCategoryType.enType == fi_tcl_e8_SignPostDestinationCategory::FI_EN_T_ROADNUMBER)
         u32DynamicSize += (poSignPostDestinationCategoryData?poSignPostDestinationCategoryData->u32GetSize(u16MajorVersion):0);
      if (SignPostDestinationCategoryType.enType == fi_tcl_e8_SignPostDestinationCategory::FI_EN_T_INTERSECTIONNAMEELEMENT)
         u32DynamicSize += (poSignPostDestinationCategoryData?poSignPostDestinationCategoryData->u32GetSize(u16MajorVersion):0);
      if (SignPostDestinationCategoryType.enType == fi_tcl_e8_SignPostDestinationCategory::FI_EN_T_INTERSECTIONNUMBERELEMENT)
         u32DynamicSize += (poSignPostDestinationCategoryData?poSignPostDestinationCategoryData->u32GetSize(u16MajorVersion):0);
      if (SignPostDestinationCategoryType.enType == fi_tcl_e8_SignPostDestinationCategory::FI_EN_T_POINTOFINTERESTELEMENT)
         u32DynamicSize += (poSignPostDestinationCategoryData?poSignPostDestinationCategoryData->u32GetSize(u16MajorVersion):0);
      if (SignPostDestinationCategoryType.enType == fi_tcl_e8_SignPostDestinationCategory::FI_EN_T_UNSPECIFIEDTEXT)
         u32DynamicSize += (poSignPostDestinationCategoryData?poSignPostDestinationCategoryData->u32GetSize(u16MajorVersion):0);
      if ((SignPostDestinationCategoryType.enType == fi_tcl_e8_SignPostDestinationCategory::FI_EN_T_COMPASSDIRECTION) &&
          (9 <= u16MajorVersion))
         u32DynamicSize += (poSignPostDestinationCategoryData?poSignPostDestinationCategoryData->u32GetSize(u16MajorVersion):0);
   }
   if (u16MajorVersion <= 8)
   {
      u32DynamicSize += SignPostDestinationDirection.u32GetSize(u16MajorVersion);
   }
   tU32 u32ListIdx;
   if (9 <= u16MajorVersion)
   {
      u32DynamicSize += 4;
      for (u32ListIdx = 0; u32ListIdx < DirectionInfoList.size(); ++u32ListIdx)
         u32DynamicSize += DirectionInfoList[u32ListIdx].u32GetSize(u16MajorVersion);
   }
   return u32DynamicSize+1;
}

tBool fi_tcl_SignPostDestination::operator==(const fi_tcl_SignPostDestination& rfoCmp) const
{
   tBool bResult = true;
      bResult = bResult && (Type == rfoCmp.Type);
   bResult = bResult && (SignPostDestinationCategoryType == rfoCmp.SignPostDestinationCategoryType);
   if (bResult && poSignPostDestinationCategoryData && rfoCmp.poSignPostDestinationCategoryData) 
   {
      switch (SignPostDestinationCategoryType.enType)
      {
      case fi_tcl_e8_SignPostDestinationCategory::FI_EN_T_RESERVED:
         bResult = bResult && (*(const fi_tcl_Reserved*)poSignPostDestinationCategoryData == *(const fi_tcl_Reserved*)rfoCmp.poSignPostDestinationCategoryData); //lint !e826
      break;
      case fi_tcl_e8_SignPostDestinationCategory::FI_EN_T_COUNTRYNAMEELEMENT:
         bResult = bResult && (*(const fi_tcl_CountryNameElement*)poSignPostDestinationCategoryData == *(const fi_tcl_CountryNameElement*)rfoCmp.poSignPostDestinationCategoryData); //lint !e826
      break;
      case fi_tcl_e8_SignPostDestinationCategory::FI_EN_T_STATENAMEELEMENT:
         bResult = bResult && (*(const fi_tcl_StateNameElement*)poSignPostDestinationCategoryData == *(const fi_tcl_StateNameElement*)rfoCmp.poSignPostDestinationCategoryData); //lint !e826
      break;
      case fi_tcl_e8_SignPostDestinationCategory::FI_EN_T_COUNTYNAMEELEMENT:
         bResult = bResult && (*(const fi_tcl_CountyNameElement*)poSignPostDestinationCategoryData == *(const fi_tcl_CountyNameElement*)rfoCmp.poSignPostDestinationCategoryData); //lint !e826
      break;
      case fi_tcl_e8_SignPostDestinationCategory::FI_EN_T_CITYNAMEELEMENT:
         bResult = bResult && (*(const fi_tcl_CityNameElement*)poSignPostDestinationCategoryData == *(const fi_tcl_CityNameElement*)rfoCmp.poSignPostDestinationCategoryData); //lint !e826
      break;
      case fi_tcl_e8_SignPostDestinationCategory::FI_EN_T_CITYDISTRICTNAMEELEMENT:
         bResult = bResult && (*(const fi_tcl_CityDistrictNameElement*)poSignPostDestinationCategoryData == *(const fi_tcl_CityDistrictNameElement*)rfoCmp.poSignPostDestinationCategoryData); //lint !e826
      break;
      case fi_tcl_e8_SignPostDestinationCategory::FI_EN_T_BUILDUPAREANAMEELEMENT:
         bResult = bResult && (*(const fi_tcl_BuildUpAreaNameElement*)poSignPostDestinationCategoryData == *(const fi_tcl_BuildUpAreaNameElement*)rfoCmp.poSignPostDestinationCategoryData); //lint !e826
      break;
      case fi_tcl_e8_SignPostDestinationCategory::FI_EN_T_ROADNAMEELEMENT:
         bResult = bResult && (*(const fi_tcl_RoadNameElement*)poSignPostDestinationCategoryData == *(const fi_tcl_RoadNameElement*)rfoCmp.poSignPostDestinationCategoryData); //lint !e826
      break;
      case fi_tcl_e8_SignPostDestinationCategory::FI_EN_T_ROADNUMBER:
         bResult = bResult && (*(const fi_tcl_RoadNumber*)poSignPostDestinationCategoryData == *(const fi_tcl_RoadNumber*)rfoCmp.poSignPostDestinationCategoryData); //lint !e826
      break;
      case fi_tcl_e8_SignPostDestinationCategory::FI_EN_T_INTERSECTIONNAMEELEMENT:
         bResult = bResult && (*(const fi_tcl_IntersectionNameElement*)poSignPostDestinationCategoryData == *(const fi_tcl_IntersectionNameElement*)rfoCmp.poSignPostDestinationCategoryData); //lint !e826
      break;
      case fi_tcl_e8_SignPostDestinationCategory::FI_EN_T_INTERSECTIONNUMBERELEMENT:
         bResult = bResult && (*(const fi_tcl_IntersectionNumberElement*)poSignPostDestinationCategoryData == *(const fi_tcl_IntersectionNumberElement*)rfoCmp.poSignPostDestinationCategoryData); //lint !e826
      break;
      case fi_tcl_e8_SignPostDestinationCategory::FI_EN_T_POINTOFINTERESTELEMENT:
         bResult = bResult && (*(const fi_tcl_PointOfInterestElement*)poSignPostDestinationCategoryData == *(const fi_tcl_PointOfInterestElement*)rfoCmp.poSignPostDestinationCategoryData); //lint !e826
      break;
      case fi_tcl_e8_SignPostDestinationCategory::FI_EN_T_UNSPECIFIEDTEXT:
         bResult = bResult && (*(const fi_tcl_UnspecifiedText*)poSignPostDestinationCategoryData == *(const fi_tcl_UnspecifiedText*)rfoCmp.poSignPostDestinationCategoryData); //lint !e826
      break;
      case fi_tcl_e8_SignPostDestinationCategory::FI_EN_T_COMPASSDIRECTION:
         bResult = bResult && (*(const fi_tcl_CompassDirection*)poSignPostDestinationCategoryData == *(const fi_tcl_CompassDirection*)rfoCmp.poSignPostDestinationCategoryData); //lint !e826
      break;
      }
   }
   else
   {
      bResult = bResult && (poSignPostDestinationCategoryData == rfoCmp.poSignPostDestinationCategoryData);
   }
      bResult = bResult && (SignPostDestinationDirection == rfoCmp.SignPostDestinationDirection);
      bResult = bResult && (DirectionInfoList.size() == rfoCmp.DirectionInfoList.size());
      if (bResult)
      {
         for (tU32 u32Idx = 0; bResult && (u32Idx < DirectionInfoList.size()); ++u32Idx)
            bResult = bResult && (DirectionInfoList[u32Idx] == rfoCmp.DirectionInfoList[u32Idx]);
      }
   return bResult;
}

fi_tclInContext& fi_tcl_SignPostDestination::oRead(fi_tclInContext& oIn)
{
   oIn >> Type;
   if (oIn.u16GetMajorVersion() <= 8)
   {
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
      OSAL_DELETE poSignPostDestinationCategoryData;
#else
      if (poSignPostDestinationCategoryData)
      {
         poSignPostDestinationCategoryData->vDestroy();
         OSAL_DELETE poSignPostDestinationCategoryData;
      }
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
      oIn >> SignPostDestinationCategoryType;
      switch(SignPostDestinationCategoryType.enType)
      {
      case fi_tcl_e8_SignPostDestinationCategory::FI_EN_T_RESERVED:
         poSignPostDestinationCategoryData = OSAL_NEW fi_tcl_Reserved;
         break;
      case fi_tcl_e8_SignPostDestinationCategory::FI_EN_T_COUNTRYNAMEELEMENT:
         poSignPostDestinationCategoryData = OSAL_NEW fi_tcl_CountryNameElement;
         break;
      case fi_tcl_e8_SignPostDestinationCategory::FI_EN_T_STATENAMEELEMENT:
         poSignPostDestinationCategoryData = OSAL_NEW fi_tcl_StateNameElement;
         break;
      case fi_tcl_e8_SignPostDestinationCategory::FI_EN_T_COUNTYNAMEELEMENT:
         poSignPostDestinationCategoryData = OSAL_NEW fi_tcl_CountyNameElement;
         break;
      case fi_tcl_e8_SignPostDestinationCategory::FI_EN_T_CITYNAMEELEMENT:
         poSignPostDestinationCategoryData = OSAL_NEW fi_tcl_CityNameElement;
         break;
      case fi_tcl_e8_SignPostDestinationCategory::FI_EN_T_CITYDISTRICTNAMEELEMENT:
         poSignPostDestinationCategoryData = OSAL_NEW fi_tcl_CityDistrictNameElement;
         break;
      case fi_tcl_e8_SignPostDestinationCategory::FI_EN_T_BUILDUPAREANAMEELEMENT:
         poSignPostDestinationCategoryData = OSAL_NEW fi_tcl_BuildUpAreaNameElement;
         break;
      case fi_tcl_e8_SignPostDestinationCategory::FI_EN_T_ROADNAMEELEMENT:
         poSignPostDestinationCategoryData = OSAL_NEW fi_tcl_RoadNameElement;
         break;
      case fi_tcl_e8_SignPostDestinationCategory::FI_EN_T_ROADNUMBER:
         poSignPostDestinationCategoryData = OSAL_NEW fi_tcl_RoadNumber;
         break;
      case fi_tcl_e8_SignPostDestinationCategory::FI_EN_T_INTERSECTIONNAMEELEMENT:
         poSignPostDestinationCategoryData = OSAL_NEW fi_tcl_IntersectionNameElement;
         break;
      case fi_tcl_e8_SignPostDestinationCategory::FI_EN_T_INTERSECTIONNUMBERELEMENT:
         poSignPostDestinationCategoryData = OSAL_NEW fi_tcl_IntersectionNumberElement;
         break;
      case fi_tcl_e8_SignPostDestinationCategory::FI_EN_T_POINTOFINTERESTELEMENT:
         poSignPostDestinationCategoryData = OSAL_NEW fi_tcl_PointOfInterestElement;
         break;
      case fi_tcl_e8_SignPostDestinationCategory::FI_EN_T_UNSPECIFIEDTEXT:
         poSignPostDestinationCategoryData = OSAL_NEW fi_tcl_UnspecifiedText;
         break;
      case fi_tcl_e8_SignPostDestinationCategory::FI_EN_T_COMPASSDIRECTION:
         poSignPostDestinationCategoryData = OSAL_NEW fi_tcl_CompassDirection;
         break;
      default:
         oIn.Invalidate();
         poSignPostDestinationCategoryData = OSAL_NULL;
      }
      if (poSignPostDestinationCategoryData && oIn.bIsValid())
         poSignPostDestinationCategoryData->oRead(oIn);
      else
         oIn.Invalidate();
   }
   if (oIn.u16GetMajorVersion() <= 8)
   {
      oIn >> SignPostDestinationDirection;
   }
   if (9 <= oIn.u16GetMajorVersion())
   {
      {
         tU32 u32Length;
         tU32 u32Idx;
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
         for (u32Idx = 0; u32Idx < DirectionInfoList.size(); ++u32Idx)
         {
            DirectionInfoList[u32Idx].vDestroy();
         }
#endif // !VARIANT_S_FTR_ENABLE_DEEP_COPY
         oIn >> u32Length;
         DirectionInfoList.resize(u32Length);
         for (u32Idx = 0; u32Idx < u32Length; ++u32Idx)
         {
            oIn >> DirectionInfoList[u32Idx];
         }
      }
   }
   return oIn;
}

fi_tclOutContext& fi_tcl_SignPostDestination::oWrite(fi_tclOutContext& oOut) const
{
   oOut << Type;
   if (oOut.u16GetMajorVersion() <= 8)
   {
      oOut << SignPostDestinationCategoryType;
      if (poSignPostDestinationCategoryData)
      {
         if (SignPostDestinationCategoryType.enType == fi_tcl_e8_SignPostDestinationCategory::FI_EN_T_RESERVED)
         {
            poSignPostDestinationCategoryData->oWrite(oOut);
         }
         if (SignPostDestinationCategoryType.enType == fi_tcl_e8_SignPostDestinationCategory::FI_EN_T_COUNTRYNAMEELEMENT)
         {
            poSignPostDestinationCategoryData->oWrite(oOut);
         }
         if (SignPostDestinationCategoryType.enType == fi_tcl_e8_SignPostDestinationCategory::FI_EN_T_STATENAMEELEMENT)
         {
            poSignPostDestinationCategoryData->oWrite(oOut);
         }
         if (SignPostDestinationCategoryType.enType == fi_tcl_e8_SignPostDestinationCategory::FI_EN_T_COUNTYNAMEELEMENT)
         {
            poSignPostDestinationCategoryData->oWrite(oOut);
         }
         if (SignPostDestinationCategoryType.enType == fi_tcl_e8_SignPostDestinationCategory::FI_EN_T_CITYNAMEELEMENT)
         {
            poSignPostDestinationCategoryData->oWrite(oOut);
         }
         if (SignPostDestinationCategoryType.enType == fi_tcl_e8_SignPostDestinationCategory::FI_EN_T_CITYDISTRICTNAMEELEMENT)
         {
            poSignPostDestinationCategoryData->oWrite(oOut);
         }
         if (SignPostDestinationCategoryType.enType == fi_tcl_e8_SignPostDestinationCategory::FI_EN_T_BUILDUPAREANAMEELEMENT)
         {
            poSignPostDestinationCategoryData->oWrite(oOut);
         }
         if (SignPostDestinationCategoryType.enType == fi_tcl_e8_SignPostDestinationCategory::FI_EN_T_ROADNAMEELEMENT)
         {
            poSignPostDestinationCategoryData->oWrite(oOut);
         }
         if (SignPostDestinationCategoryType.enType == fi_tcl_e8_SignPostDestinationCategory::FI_EN_T_ROADNUMBER)
         {
            poSignPostDestinationCategoryData->oWrite(oOut);
         }
         if (SignPostDestinationCategoryType.enType == fi_tcl_e8_SignPostDestinationCategory::FI_EN_T_INTERSECTIONNAMEELEMENT)
         {
            poSignPostDestinationCategoryData->oWrite(oOut);
         }
         if (SignPostDestinationCategoryType.enType == fi_tcl_e8_SignPostDestinationCategory::FI_EN_T_INTERSECTIONNUMBERELEMENT)
         {
            poSignPostDestinationCategoryData->oWrite(oOut);
         }
         if (SignPostDestinationCategoryType.enType == fi_tcl_e8_SignPostDestinationCategory::FI_EN_T_POINTOFINTERESTELEMENT)
         {
            poSignPostDestinationCategoryData->oWrite(oOut);
         }
         if (SignPostDestinationCategoryType.enType == fi_tcl_e8_SignPostDestinationCategory::FI_EN_T_UNSPECIFIEDTEXT)
         {
            poSignPostDestinationCategoryData->oWrite(oOut);
         }
         if (SignPostDestinationCategoryType.enType == fi_tcl_e8_SignPostDestinationCategory::FI_EN_T_COMPASSDIRECTION)
         {
            if (!(9 <= oOut.u16GetMajorVersion()))
            {
               fi_tcl_Reserved oDefault;
               oOut << oDefault;
            }
            else
            {
               poSignPostDestinationCategoryData->oWrite(oOut);
            }
         }
      }
      else
      {
         oOut.Invalidate();
      }
   }
   if (oOut.u16GetMajorVersion() <= 8)
   {
      oOut << SignPostDestinationDirection;
   }
   if (9 <= oOut.u16GetMajorVersion())
   {
      oOut << (tU32)DirectionInfoList.size();
      {
         for (tU32 u32Idx = 0; u32Idx < DirectionInfoList.size(); ++u32Idx)
            oOut << DirectionInfoList[u32Idx];
      }
   }
   return oOut;
}

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
fi_tcl_DirectionInfoList::fi_tcl_DirectionInfoList(const fi_tcl_DirectionInfoList& coRef):fi_tclVisitableTypeBase(coRef)
{
   DirectionInfoList = coRef.DirectionInfoList;
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
fi_tcl_DirectionInfoList& fi_tcl_DirectionInfoList::operator=(const fi_tcl_DirectionInfoList& coRef)
{
   if (this == &coRef) return *this;
   DirectionInfoList = coRef.DirectionInfoList;
   return *this;
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
tVoid fi_tcl_DirectionInfoList::vDestroy()
{
   {
      for (tU32 u32Idx = 0; u32Idx < DirectionInfoList.size(); ++u32Idx)
         DirectionInfoList[u32Idx].vDestroy();
   }
   DirectionInfoList.clear();
}

tU32 fi_tcl_DirectionInfoList::u32GetSize(tU16 u16MajorVersion) const
{
   tU32 u32DynamicSize = 0;
   tU32 u32ListIdx;
   for (u32ListIdx = 0; u32ListIdx < DirectionInfoList.size(); ++u32ListIdx)
      u32DynamicSize += DirectionInfoList[u32ListIdx].u32GetSize(u16MajorVersion);
   return u32DynamicSize+4;
}

tBool fi_tcl_DirectionInfoList::operator==(const fi_tcl_DirectionInfoList& rfoCmp) const
{
   tBool bResult = true;
      bResult = bResult && (DirectionInfoList.size() == rfoCmp.DirectionInfoList.size());
      if (bResult)
      {
         for (tU32 u32Idx = 0; bResult && (u32Idx < DirectionInfoList.size()); ++u32Idx)
            bResult = bResult && (DirectionInfoList[u32Idx] == rfoCmp.DirectionInfoList[u32Idx]);
      }
   return bResult;
}

fi_tclInContext& fi_tcl_DirectionInfoList::oRead(fi_tclInContext& oIn)
{
   {
      tU32 u32Length;
      tU32 u32Idx;
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
      for (u32Idx = 0; u32Idx < DirectionInfoList.size(); ++u32Idx)
      {
         DirectionInfoList[u32Idx].vDestroy();
      }
#endif // !VARIANT_S_FTR_ENABLE_DEEP_COPY
      oIn >> u32Length;
      DirectionInfoList.resize(u32Length);
      for (u32Idx = 0; u32Idx < u32Length; ++u32Idx)
      {
         oIn >> DirectionInfoList[u32Idx];
      }
   }
   return oIn;
}

fi_tclOutContext& fi_tcl_DirectionInfoList::oWrite(fi_tclOutContext& oOut) const
{
   oOut << (tU32)DirectionInfoList.size();
   {
      for (tU32 u32Idx = 0; u32Idx < DirectionInfoList.size(); ++u32Idx)
         oOut << DirectionInfoList[u32Idx];
   }
   return oOut;
}

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
fi_tcl_ReferenceElement::fi_tcl_ReferenceElement(const fi_tcl_ReferenceElement& coRef):fi_tclVisitableTypeBase(coRef)
{
   BaseList = coRef.BaseList;
   RefList = coRef.RefList;
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
fi_tcl_ReferenceElement& fi_tcl_ReferenceElement::operator=(const fi_tcl_ReferenceElement& coRef)
{
   if (this == &coRef) return *this;
   BaseList = coRef.BaseList;
   RefList = coRef.RefList;
   return *this;
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
tU32 fi_tcl_ReferenceElement::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 4;
}

tBool fi_tcl_ReferenceElement::operator==(const fi_tcl_ReferenceElement& rfoCmp) const
{
   tBool bResult = true;
      bResult = bResult && (BaseList == rfoCmp.BaseList);
      bResult = bResult && (RefList == rfoCmp.RefList);
   return bResult;
}

fi_tclInContext& fi_tcl_ReferenceElement::oRead(fi_tclInContext& oIn)
{
   oIn >> BaseList;
   oIn >> RefList;
   return oIn;
}

fi_tclOutContext& fi_tcl_ReferenceElement::oWrite(fi_tclOutContext& oOut) const
{
   oOut << BaseList;
   oOut << RefList;
   return oOut;
}

tU32 fi_tcl_b8_SignPostInfoStatus::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 1;
}

tBool fi_tcl_b8_SignPostInfoStatus::operator==(const fi_tcl_b8_SignPostInfoStatus& rfoCmp) const
{
   return u8Value == rfoCmp.u8Value;
}

fi_tclInContext& fi_tcl_b8_SignPostInfoStatus::oRead(fi_tclInContext& oIn)
{
   return oIn >> u8Value;
}

fi_tclOutContext& fi_tcl_b8_SignPostInfoStatus::oWrite(fi_tclOutContext& oOut) const
{
   return oOut << u8Value;
}

tU32 fi_tcl_e8_TMAffectionType::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 1;
}

tBool fi_tcl_e8_TMAffectionType::operator==(const fi_tcl_e8_TMAffectionType& rfoCmp) const
{
   return enType == rfoCmp.enType;
}

fi_tclInContext& fi_tcl_e8_TMAffectionType::oRead(fi_tclInContext& oIn)
{
   tU8 u8Value;
   oIn >> u8Value;
   enType = (tenType)u8Value;
   return oIn;
}

fi_tclOutContext& fi_tcl_e8_TMAffectionType::oWrite(fi_tclOutContext& oOut) const
{
   return oOut.oWrite((tU8)enType);
}

tU32 fi_tcl_b8_TMOneCellAttribute::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 1;
}

tBool fi_tcl_b8_TMOneCellAttribute::operator==(const fi_tcl_b8_TMOneCellAttribute& rfoCmp) const
{
   return u8Value == rfoCmp.u8Value;
}

fi_tclInContext& fi_tcl_b8_TMOneCellAttribute::oRead(fi_tclInContext& oIn)
{
   return oIn >> u8Value;
}

fi_tclOutContext& fi_tcl_b8_TMOneCellAttribute::oWrite(fi_tclOutContext& oOut) const
{
   return oOut << u8Value;
}

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
fi_tcl_TMOneCellDesc::fi_tcl_TMOneCellDesc(const fi_tcl_TMOneCellDesc& coRef):fi_tclVisitableTypeBase(coRef)
{
   NavOneCell = coRef.NavOneCell;
   TMAttributes = coRef.TMAttributes;
   Portion = coRef.Portion;
   AffectionType = coRef.AffectionType;
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
fi_tcl_TMOneCellDesc& fi_tcl_TMOneCellDesc::operator=(const fi_tcl_TMOneCellDesc& coRef)
{
   if (this == &coRef) return *this;
   NavOneCell = coRef.NavOneCell;
   TMAttributes = coRef.TMAttributes;
   Portion = coRef.Portion;
   AffectionType = coRef.AffectionType;
   return *this;
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
tVoid fi_tcl_TMOneCellDesc::vDestroy()
{
   NavOneCell.vDestroy(); 
   Portion.vDestroy(); 
}

tU32 fi_tcl_TMOneCellDesc::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 9;
}

tBool fi_tcl_TMOneCellDesc::operator==(const fi_tcl_TMOneCellDesc& rfoCmp) const
{
   tBool bResult = true;
      bResult = bResult && (NavOneCell == rfoCmp.NavOneCell);
      bResult = bResult && (TMAttributes == rfoCmp.TMAttributes);
      bResult = bResult && (Portion == rfoCmp.Portion);
      bResult = bResult && (AffectionType == rfoCmp.AffectionType);
   return bResult;
}

fi_tclInContext& fi_tcl_TMOneCellDesc::oRead(fi_tclInContext& oIn)
{
   oIn >> NavOneCell;
   oIn >> TMAttributes;
   oIn >> Portion;
   oIn >> AffectionType;
   return oIn;
}

fi_tclOutContext& fi_tcl_TMOneCellDesc::oWrite(fi_tclOutContext& oOut) const
{
   oOut << NavOneCell;
   oOut << TMAttributes;
   oOut << Portion;
   oOut << AffectionType;
   return oOut;
}

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
fi_tcl_NavLocationDataDesc::fi_tcl_NavLocationDataDesc(const fi_tcl_NavLocationDataDesc& coRef):fi_tclVisitableTypeBase(coRef)
{
   NavDataSetID = coRef.NavDataSetID;
   IndexZFDestType = coRef.IndexZFDestType;
   ObjectPointRefList = coRef.ObjectPointRefList;
   AccessPointRefList = coRef.AccessPointRefList;
   NavDataTypeType = coRef.NavDataTypeType;
   if  (coRef.poNavDataTypeData)
   {
      switch(NavDataTypeType.enType)
      {
      case fi_tcl_e8_NavLocationNavDataType::FI_EN_T_RESERVED:
         poNavDataTypeData = OSAL_NEW fi_tcl_Reserved((const fi_tcl_Reserved&)*coRef.poNavDataTypeData);
         break;
      case fi_tcl_e8_NavLocationNavDataType::FI_EN_T_NAVINTERSECTIONDESTINATIONZEROCELLLISTSET:
         poNavDataTypeData = OSAL_NEW fi_tcl_NavIntersectionDestinationZeroCellListSet((const fi_tcl_NavIntersectionDestinationZeroCellListSet&)*coRef.poNavDataTypeData);
         break;
      case fi_tcl_e8_NavLocationNavDataType::FI_EN_T_NAVSTREETDESTINATIONONECELLLISTSET:
         poNavDataTypeData = OSAL_NEW fi_tcl_NavStreetDestinationOneCellListSet((const fi_tcl_NavStreetDestinationOneCellListSet&)*coRef.poNavDataTypeData);
         break;
      case fi_tcl_e8_NavLocationNavDataType::FI_EN_T_NAVSPOTDESTINATIONONECELLLISTSET:
         poNavDataTypeData = OSAL_NEW fi_tcl_NavSpotDestinationOneCellListSet((const fi_tcl_NavSpotDestinationOneCellListSet&)*coRef.poNavDataTypeData);
         break;
      default:
         poNavDataTypeData = OSAL_NULL;
      }
   }
   else
   {
      poNavDataTypeData = OSAL_NULL;
   }
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
fi_tcl_NavLocationDataDesc& fi_tcl_NavLocationDataDesc::operator=(const fi_tcl_NavLocationDataDesc& coRef)
{
   if (this == &coRef) return *this;
   NavDataSetID = coRef.NavDataSetID;
   IndexZFDestType = coRef.IndexZFDestType;
   ObjectPointRefList = coRef.ObjectPointRefList;
   AccessPointRefList = coRef.AccessPointRefList;
   OSAL_DELETE poNavDataTypeData;
   NavDataTypeType = coRef.NavDataTypeType;
   if  (coRef.poNavDataTypeData)
   {
      switch(NavDataTypeType.enType)
      {
      case fi_tcl_e8_NavLocationNavDataType::FI_EN_T_RESERVED:
         poNavDataTypeData = OSAL_NEW fi_tcl_Reserved((const fi_tcl_Reserved&)*coRef.poNavDataTypeData);
         break;
      case fi_tcl_e8_NavLocationNavDataType::FI_EN_T_NAVINTERSECTIONDESTINATIONZEROCELLLISTSET:
         poNavDataTypeData = OSAL_NEW fi_tcl_NavIntersectionDestinationZeroCellListSet((const fi_tcl_NavIntersectionDestinationZeroCellListSet&)*coRef.poNavDataTypeData);
         break;
      case fi_tcl_e8_NavLocationNavDataType::FI_EN_T_NAVSTREETDESTINATIONONECELLLISTSET:
         poNavDataTypeData = OSAL_NEW fi_tcl_NavStreetDestinationOneCellListSet((const fi_tcl_NavStreetDestinationOneCellListSet&)*coRef.poNavDataTypeData);
         break;
      case fi_tcl_e8_NavLocationNavDataType::FI_EN_T_NAVSPOTDESTINATIONONECELLLISTSET:
         poNavDataTypeData = OSAL_NEW fi_tcl_NavSpotDestinationOneCellListSet((const fi_tcl_NavSpotDestinationOneCellListSet&)*coRef.poNavDataTypeData);
         break;
      default:
         poNavDataTypeData = OSAL_NULL;
      }
   }
   else
   {
      poNavDataTypeData = OSAL_NULL;
   }
   return *this;
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
fi_tcl_NavLocationDataDesc::~fi_tcl_NavLocationDataDesc()
{
   OSAL_DELETE poNavDataTypeData;
   poNavDataTypeData = OSAL_NULL;
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
tVoid fi_tcl_NavLocationDataDesc::vDestroy()
{
   {
      for (tU32 u32Idx = 0; u32Idx < ObjectPointRefList.size(); ++u32Idx)
         ObjectPointRefList[u32Idx].vDestroy();
   }
   ObjectPointRefList.clear();
   {
      for (tU32 u32Idx = 0; u32Idx < AccessPointRefList.size(); ++u32Idx)
         AccessPointRefList[u32Idx].vDestroy();
   }
   AccessPointRefList.clear();
   if (poNavDataTypeData)
   {
      poNavDataTypeData->vDestroy();
      OSAL_DELETE poNavDataTypeData;
      poNavDataTypeData = OSAL_NULL;
   }
}

tU32 fi_tcl_NavLocationDataDesc::u32GetSize(tU16 u16MajorVersion) const
{
   return 14+ObjectPointRefList.size()*8+AccessPointRefList.size()*8+(poNavDataTypeData?poNavDataTypeData->u32GetSize(u16MajorVersion):0);
}

tBool fi_tcl_NavLocationDataDesc::operator==(const fi_tcl_NavLocationDataDesc& rfoCmp) const
{
   tBool bResult = true;
      bResult = bResult && (NavDataSetID == rfoCmp.NavDataSetID);
      bResult = bResult && (IndexZFDestType == rfoCmp.IndexZFDestType);
      bResult = bResult && (ObjectPointRefList.size() == rfoCmp.ObjectPointRefList.size());
      if (bResult)
      {
         for (tU32 u32Idx = 0; bResult && (u32Idx < ObjectPointRefList.size()); ++u32Idx)
            bResult = bResult && (ObjectPointRefList[u32Idx] == rfoCmp.ObjectPointRefList[u32Idx]);
      }
      bResult = bResult && (AccessPointRefList.size() == rfoCmp.AccessPointRefList.size());
      if (bResult)
      {
         for (tU32 u32Idx = 0; bResult && (u32Idx < AccessPointRefList.size()); ++u32Idx)
            bResult = bResult && (AccessPointRefList[u32Idx] == rfoCmp.AccessPointRefList[u32Idx]);
      }
   bResult = bResult && (NavDataTypeType == rfoCmp.NavDataTypeType);
   if (bResult && poNavDataTypeData && rfoCmp.poNavDataTypeData) 
   {
      switch (NavDataTypeType.enType)
      {
      case fi_tcl_e8_NavLocationNavDataType::FI_EN_T_RESERVED:
         bResult = bResult && (*(const fi_tcl_Reserved*)poNavDataTypeData == *(const fi_tcl_Reserved*)rfoCmp.poNavDataTypeData); //lint !e826
      break;
      case fi_tcl_e8_NavLocationNavDataType::FI_EN_T_NAVINTERSECTIONDESTINATIONZEROCELLLISTSET:
         bResult = bResult && (*(const fi_tcl_NavIntersectionDestinationZeroCellListSet*)poNavDataTypeData == *(const fi_tcl_NavIntersectionDestinationZeroCellListSet*)rfoCmp.poNavDataTypeData); //lint !e826
      break;
      case fi_tcl_e8_NavLocationNavDataType::FI_EN_T_NAVSTREETDESTINATIONONECELLLISTSET:
         bResult = bResult && (*(const fi_tcl_NavStreetDestinationOneCellListSet*)poNavDataTypeData == *(const fi_tcl_NavStreetDestinationOneCellListSet*)rfoCmp.poNavDataTypeData); //lint !e826
      break;
      case fi_tcl_e8_NavLocationNavDataType::FI_EN_T_NAVSPOTDESTINATIONONECELLLISTSET:
         bResult = bResult && (*(const fi_tcl_NavSpotDestinationOneCellListSet*)poNavDataTypeData == *(const fi_tcl_NavSpotDestinationOneCellListSet*)rfoCmp.poNavDataTypeData); //lint !e826
      break;
      }
   }
   else
   {
      bResult = bResult && (poNavDataTypeData == rfoCmp.poNavDataTypeData);
   }
   return bResult;
}

fi_tclInContext& fi_tcl_NavLocationDataDesc::oRead(fi_tclInContext& oIn)
{
   oIn >> NavDataSetID;
   oIn >> IndexZFDestType;
   {
      tU32 u32Length;
      tU32 u32Idx;
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
      for (u32Idx = 0; u32Idx < ObjectPointRefList.size(); ++u32Idx)
      {
         ObjectPointRefList[u32Idx].vDestroy();
      }
#endif // !VARIANT_S_FTR_ENABLE_DEEP_COPY
      oIn >> u32Length;
      ObjectPointRefList.resize(u32Length);
      for (u32Idx = 0; u32Idx < u32Length; ++u32Idx)
      {
         oIn >> ObjectPointRefList[u32Idx];
      }
   }
   {
      tU32 u32Length;
      tU32 u32Idx;
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
      for (u32Idx = 0; u32Idx < AccessPointRefList.size(); ++u32Idx)
      {
         AccessPointRefList[u32Idx].vDestroy();
      }
#endif // !VARIANT_S_FTR_ENABLE_DEEP_COPY
      oIn >> u32Length;
      AccessPointRefList.resize(u32Length);
      for (u32Idx = 0; u32Idx < u32Length; ++u32Idx)
      {
         oIn >> AccessPointRefList[u32Idx];
      }
   }
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   OSAL_DELETE poNavDataTypeData;
#else
   if (poNavDataTypeData)
   {
      poNavDataTypeData->vDestroy();
      OSAL_DELETE poNavDataTypeData;
   }
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
   oIn >> NavDataTypeType;
   switch(NavDataTypeType.enType)
   {
   case fi_tcl_e8_NavLocationNavDataType::FI_EN_T_RESERVED:
      poNavDataTypeData = OSAL_NEW fi_tcl_Reserved;
      break;
   case fi_tcl_e8_NavLocationNavDataType::FI_EN_T_NAVINTERSECTIONDESTINATIONZEROCELLLISTSET:
      poNavDataTypeData = OSAL_NEW fi_tcl_NavIntersectionDestinationZeroCellListSet;
      break;
   case fi_tcl_e8_NavLocationNavDataType::FI_EN_T_NAVSTREETDESTINATIONONECELLLISTSET:
      poNavDataTypeData = OSAL_NEW fi_tcl_NavStreetDestinationOneCellListSet;
      break;
   case fi_tcl_e8_NavLocationNavDataType::FI_EN_T_NAVSPOTDESTINATIONONECELLLISTSET:
      poNavDataTypeData = OSAL_NEW fi_tcl_NavSpotDestinationOneCellListSet;
      break;
   default:
      oIn.Invalidate();
      poNavDataTypeData = OSAL_NULL;
   }
   if (poNavDataTypeData && oIn.bIsValid())
      poNavDataTypeData->oRead(oIn);
   else
      oIn.Invalidate();
   return oIn;
}

fi_tclOutContext& fi_tcl_NavLocationDataDesc::oWrite(fi_tclOutContext& oOut) const
{
   oOut << NavDataSetID;
   oOut << IndexZFDestType;
   oOut << (tU32)ObjectPointRefList.size();
   {
      for (tU32 u32Idx = 0; u32Idx < ObjectPointRefList.size(); ++u32Idx)
         oOut << ObjectPointRefList[u32Idx];
   }
   oOut << (tU32)AccessPointRefList.size();
   {
      for (tU32 u32Idx = 0; u32Idx < AccessPointRefList.size(); ++u32Idx)
         oOut << AccessPointRefList[u32Idx];
   }
   oOut << NavDataTypeType;
   if (poNavDataTypeData)
   {
      poNavDataTypeData->oWrite(oOut);
   }
   else
   {
      oOut.Invalidate();
   }
   return oOut;
}

tU32 fi_tcl_u32_MediaId::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 4;
}

tBool fi_tcl_u32_MediaId::operator==(const fi_tcl_u32_MediaId& rfoCmp) const
{
   return u32Value == rfoCmp.u32Value;
}

fi_tclInContext& fi_tcl_u32_MediaId::oRead(fi_tclInContext& oIn)
{
   return oIn >> u32Value;
}

fi_tclOutContext& fi_tcl_u32_MediaId::oWrite(fi_tclOutContext& oOut) const
{
   return oOut << u32Value;
}

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
fi_tcl_EDMOneCellProp::fi_tcl_EDMOneCellProp(const fi_tcl_EDMOneCellProp& coRef):fi_tclVisitableTypeBase(coRef)
{
   IsPrimary = coRef.IsPrimary;
   IsInObject = coRef.IsInObject;
   IsInComplexIntersection = coRef.IsInComplexIntersection;
   IsBuiltupArea = coRef.IsBuiltupArea;
   IsFreeway = coRef.IsFreeway;
   IsFirst = coRef.IsFirst;
   IsLast = coRef.IsLast;
   LaneNr = coRef.LaneNr;
   RoadClass = coRef.RoadClass;
   Speed = coRef.Speed;
   VLI = coRef.VLI;
   AbsLength = coRef.AbsLength;
   RelLength = coRef.RelLength;
   Portion = coRef.Portion;
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
fi_tcl_EDMOneCellProp& fi_tcl_EDMOneCellProp::operator=(const fi_tcl_EDMOneCellProp& coRef)
{
   if (this == &coRef) return *this;
   IsPrimary = coRef.IsPrimary;
   IsInObject = coRef.IsInObject;
   IsInComplexIntersection = coRef.IsInComplexIntersection;
   IsBuiltupArea = coRef.IsBuiltupArea;
   IsFreeway = coRef.IsFreeway;
   IsFirst = coRef.IsFirst;
   IsLast = coRef.IsLast;
   LaneNr = coRef.LaneNr;
   RoadClass = coRef.RoadClass;
   Speed = coRef.Speed;
   VLI = coRef.VLI;
   AbsLength = coRef.AbsLength;
   RelLength = coRef.RelLength;
   Portion = coRef.Portion;
   return *this;
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
tVoid fi_tcl_EDMOneCellProp::vDestroy()
{
   Portion.vDestroy(); 
}

tU32 fi_tcl_EDMOneCellProp::u32GetSize(tU16 u16MajorVersion) const
{
   tU32 u32DynamicSize = 0;
   if (13 <= u16MajorVersion)
   {
      u32DynamicSize += 1;
   }
   if (13 <= u16MajorVersion)
   {
      u32DynamicSize += 1;
   }
   return u32DynamicSize+22;
}

tBool fi_tcl_EDMOneCellProp::operator==(const fi_tcl_EDMOneCellProp& rfoCmp) const
{
   tBool bResult = true;
      bResult = bResult && (IsPrimary == rfoCmp.IsPrimary);
      bResult = bResult && (IsInObject == rfoCmp.IsInObject);
      bResult = bResult && (IsInComplexIntersection == rfoCmp.IsInComplexIntersection);
      bResult = bResult && (IsBuiltupArea == rfoCmp.IsBuiltupArea);
      bResult = bResult && (IsFreeway == rfoCmp.IsFreeway);
      bResult = bResult && (IsFirst == rfoCmp.IsFirst);
      bResult = bResult && (IsLast == rfoCmp.IsLast);
      bResult = bResult && (LaneNr == rfoCmp.LaneNr);
      bResult = bResult && (RoadClass == rfoCmp.RoadClass);
      bResult = bResult && (Speed == rfoCmp.Speed);
      bResult = bResult && (VLI == rfoCmp.VLI);
      bResult = bResult && (AbsLength == rfoCmp.AbsLength);
      bResult = bResult && (RelLength == rfoCmp.RelLength);
      bResult = bResult && (Portion == rfoCmp.Portion);
   return bResult;
}

fi_tclInContext& fi_tcl_EDMOneCellProp::oRead(fi_tclInContext& oIn)
{
   oIn >> IsPrimary;
   oIn >> IsInObject;
   oIn >> IsInComplexIntersection;
   if (13 <= oIn.u16GetMajorVersion())
   {
      oIn >> IsBuiltupArea;
   }
   if (13 <= oIn.u16GetMajorVersion())
   {
      oIn >> IsFreeway;
   }
   oIn >> IsFirst;
   oIn >> IsLast;
   oIn >> LaneNr;
   oIn >> RoadClass;
   oIn >> Speed;
   oIn >> VLI;
   oIn >> AbsLength;
   oIn >> RelLength;
   oIn >> Portion;
   return oIn;
}

fi_tclOutContext& fi_tcl_EDMOneCellProp::oWrite(fi_tclOutContext& oOut) const
{
   oOut << IsPrimary;
   oOut << IsInObject;
   oOut << IsInComplexIntersection;
   if (13 <= oOut.u16GetMajorVersion())
   {
      oOut << IsBuiltupArea;
   }
   if (13 <= oOut.u16GetMajorVersion())
   {
      oOut << IsFreeway;
   }
   oOut << IsFirst;
   oOut << IsLast;
   oOut << LaneNr;
   oOut << RoadClass;
   oOut << Speed;
   oOut << VLI;
   oOut << AbsLength;
   oOut << RelLength;
   oOut << Portion;
   return oOut;
}

tU32 fi_tcl_e8_NavDataLevel::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 1;
}

tBool fi_tcl_e8_NavDataLevel::operator==(const fi_tcl_e8_NavDataLevel& rfoCmp) const
{
   return enType == rfoCmp.enType;
}

fi_tclInContext& fi_tcl_e8_NavDataLevel::oRead(fi_tclInContext& oIn)
{
   tU8 u8Value;
   oIn >> u8Value;
   enType = (tenType)u8Value;
   return oIn;
}

fi_tclOutContext& fi_tcl_e8_NavDataLevel::oWrite(fi_tclOutContext& oOut) const
{
   return oOut.oWrite((tU8)enType);
}

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
fi_tcl_TMIntersectionPath::fi_tcl_TMIntersectionPath(const fi_tcl_TMIntersectionPath& coRef):fi_tclVisitableTypeBase(coRef)
{
   PathType = coRef.PathType;
   LevelMatrix = coRef.LevelMatrix;
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
fi_tcl_TMIntersectionPath& fi_tcl_TMIntersectionPath::operator=(const fi_tcl_TMIntersectionPath& coRef)
{
   if (this == &coRef) return *this;
   PathType = coRef.PathType;
   LevelMatrix = coRef.LevelMatrix;
   return *this;
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
tVoid fi_tcl_TMIntersectionPath::vDestroy()
{
   {
      for (tU32 u32Idx = 0; u32Idx < LevelMatrix.size(); ++u32Idx)
         LevelMatrix[u32Idx].vDestroy();
   }
   LevelMatrix.clear();
}

tU32 fi_tcl_TMIntersectionPath::u32GetSize(tU16 u16MajorVersion) const
{
   tU32 u32DynamicSize = 0;
   tU32 u32ListIdx;
   for (u32ListIdx = 0; u32ListIdx < LevelMatrix.size(); ++u32ListIdx)
      u32DynamicSize += LevelMatrix[u32ListIdx].u32GetSize(u16MajorVersion);
   return u32DynamicSize+5;
}

tBool fi_tcl_TMIntersectionPath::operator==(const fi_tcl_TMIntersectionPath& rfoCmp) const
{
   tBool bResult = true;
      bResult = bResult && (PathType == rfoCmp.PathType);
      bResult = bResult && (LevelMatrix.size() == rfoCmp.LevelMatrix.size());
      if (bResult)
      {
         for (tU32 u32Idx = 0; bResult && (u32Idx < LevelMatrix.size()); ++u32Idx)
            bResult = bResult && (LevelMatrix[u32Idx] == rfoCmp.LevelMatrix[u32Idx]);
      }
   return bResult;
}

fi_tclInContext& fi_tcl_TMIntersectionPath::oRead(fi_tclInContext& oIn)
{
   oIn >> PathType;
   {
      tU32 u32Length;
      tU32 u32Idx;
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
      for (u32Idx = 0; u32Idx < LevelMatrix.size(); ++u32Idx)
      {
         LevelMatrix[u32Idx].vDestroy();
      }
#endif // !VARIANT_S_FTR_ENABLE_DEEP_COPY
      oIn >> u32Length;
      LevelMatrix.resize(u32Length);
      for (u32Idx = 0; u32Idx < u32Length; ++u32Idx)
      {
         oIn >> LevelMatrix[u32Idx];
      }
   }
   return oIn;
}

fi_tclOutContext& fi_tcl_TMIntersectionPath::oWrite(fi_tclOutContext& oOut) const
{
   oOut << PathType;
   oOut << (tU32)LevelMatrix.size();
   {
      for (tU32 u32Idx = 0; u32Idx < LevelMatrix.size(); ++u32Idx)
         oOut << LevelMatrix[u32Idx];
   }
   return oOut;
}

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
fi_tcl_SameLevelOneCellBlock::fi_tcl_SameLevelOneCellBlock(const fi_tcl_SameLevelOneCellBlock& coRef):fi_tclVisitableTypeBase(coRef)
{
   Level = coRef.Level;
   ClusterIdList = coRef.ClusterIdList;
   OneCellIdList = coRef.OneCellIdList;
   OneCellRelationList = coRef.OneCellRelationList;
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
fi_tcl_SameLevelOneCellBlock& fi_tcl_SameLevelOneCellBlock::operator=(const fi_tcl_SameLevelOneCellBlock& coRef)
{
   if (this == &coRef) return *this;
   Level = coRef.Level;
   ClusterIdList = coRef.ClusterIdList;
   OneCellIdList = coRef.OneCellIdList;
   OneCellRelationList = coRef.OneCellRelationList;
   return *this;
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
tVoid fi_tcl_SameLevelOneCellBlock::vDestroy()
{
   {
      for (tU32 u32Idx = 0; u32Idx < ClusterIdList.size(); ++u32Idx)
         ClusterIdList[u32Idx].vDestroy();
   }
   ClusterIdList.clear();
   {
      for (tU32 u32Idx = 0; u32Idx < OneCellIdList.size(); ++u32Idx)
         OneCellIdList[u32Idx].vDestroy();
   }
   OneCellIdList.clear();
   {
      for (tU32 u32Idx = 0; u32Idx < OneCellRelationList.size(); ++u32Idx)
         OneCellRelationList[u32Idx].vDestroy();
   }
   OneCellRelationList.clear();
}

tU32 fi_tcl_SameLevelOneCellBlock::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 13+ClusterIdList.size()*8+OneCellIdList.size()*4+OneCellRelationList.size()*3;
}

tBool fi_tcl_SameLevelOneCellBlock::operator==(const fi_tcl_SameLevelOneCellBlock& rfoCmp) const
{
   tBool bResult = true;
      bResult = bResult && (Level == rfoCmp.Level);
      bResult = bResult && (ClusterIdList.size() == rfoCmp.ClusterIdList.size());
      if (bResult)
      {
         for (tU32 u32Idx = 0; bResult && (u32Idx < ClusterIdList.size()); ++u32Idx)
            bResult = bResult && (ClusterIdList[u32Idx] == rfoCmp.ClusterIdList[u32Idx]);
      }
      bResult = bResult && (OneCellIdList.size() == rfoCmp.OneCellIdList.size());
      if (bResult)
      {
         for (tU32 u32Idx = 0; bResult && (u32Idx < OneCellIdList.size()); ++u32Idx)
            bResult = bResult && (OneCellIdList[u32Idx] == rfoCmp.OneCellIdList[u32Idx]);
      }
      bResult = bResult && (OneCellRelationList.size() == rfoCmp.OneCellRelationList.size());
      if (bResult)
      {
         for (tU32 u32Idx = 0; bResult && (u32Idx < OneCellRelationList.size()); ++u32Idx)
            bResult = bResult && (OneCellRelationList[u32Idx] == rfoCmp.OneCellRelationList[u32Idx]);
      }
   return bResult;
}

fi_tclInContext& fi_tcl_SameLevelOneCellBlock::oRead(fi_tclInContext& oIn)
{
   oIn >> Level;
   {
      tU32 u32Length;
      tU32 u32Idx;
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
      for (u32Idx = 0; u32Idx < ClusterIdList.size(); ++u32Idx)
      {
         ClusterIdList[u32Idx].vDestroy();
      }
#endif // !VARIANT_S_FTR_ENABLE_DEEP_COPY
      oIn >> u32Length;
      ClusterIdList.resize(u32Length);
      for (u32Idx = 0; u32Idx < u32Length; ++u32Idx)
      {
         oIn >> ClusterIdList[u32Idx];
      }
   }
   {
      tU32 u32Length;
      tU32 u32Idx;
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
      for (u32Idx = 0; u32Idx < OneCellIdList.size(); ++u32Idx)
      {
         OneCellIdList[u32Idx].vDestroy();
      }
#endif // !VARIANT_S_FTR_ENABLE_DEEP_COPY
      oIn >> u32Length;
      OneCellIdList.resize(u32Length);
      for (u32Idx = 0; u32Idx < u32Length; ++u32Idx)
      {
         oIn >> OneCellIdList[u32Idx];
      }
   }
   {
      tU32 u32Length;
      tU32 u32Idx;
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
      for (u32Idx = 0; u32Idx < OneCellRelationList.size(); ++u32Idx)
      {
         OneCellRelationList[u32Idx].vDestroy();
      }
#endif // !VARIANT_S_FTR_ENABLE_DEEP_COPY
      oIn >> u32Length;
      OneCellRelationList.resize(u32Length);
      for (u32Idx = 0; u32Idx < u32Length; ++u32Idx)
      {
         oIn >> OneCellRelationList[u32Idx];
      }
   }
   return oIn;
}

fi_tclOutContext& fi_tcl_SameLevelOneCellBlock::oWrite(fi_tclOutContext& oOut) const
{
   oOut << Level;
   oOut << (tU32)ClusterIdList.size();
   {
      for (tU32 u32Idx = 0; u32Idx < ClusterIdList.size(); ++u32Idx)
         oOut << ClusterIdList[u32Idx];
   }
   oOut << (tU32)OneCellIdList.size();
   {
      for (tU32 u32Idx = 0; u32Idx < OneCellIdList.size(); ++u32Idx)
         oOut << OneCellIdList[u32Idx];
   }
   oOut << (tU32)OneCellRelationList.size();
   {
      for (tU32 u32Idx = 0; u32Idx < OneCellRelationList.size(); ++u32Idx)
         oOut << OneCellRelationList[u32Idx];
   }
   return oOut;
}

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
fi_tcl_NavSpotDestinationOneCellListSet::fi_tcl_NavSpotDestinationOneCellListSet(const fi_tcl_NavSpotDestinationOneCellListSet& coRef):fi_tclVisitableTypeBase(coRef)
{
   ClusterRefList = coRef.ClusterRefList;
   SpotDestinationOneCellRefList = coRef.SpotDestinationOneCellRefList;
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
fi_tcl_NavSpotDestinationOneCellListSet& fi_tcl_NavSpotDestinationOneCellListSet::operator=(const fi_tcl_NavSpotDestinationOneCellListSet& coRef)
{
   if (this == &coRef) return *this;
   ClusterRefList = coRef.ClusterRefList;
   SpotDestinationOneCellRefList = coRef.SpotDestinationOneCellRefList;
   return *this;
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
tVoid fi_tcl_NavSpotDestinationOneCellListSet::vDestroy()
{
   {
      for (tU32 u32Idx = 0; u32Idx < ClusterRefList.size(); ++u32Idx)
         ClusterRefList[u32Idx].vDestroy();
   }
   ClusterRefList.clear();
   {
      for (tU32 u32Idx = 0; u32Idx < SpotDestinationOneCellRefList.size(); ++u32Idx)
         SpotDestinationOneCellRefList[u32Idx].vDestroy();
   }
   SpotDestinationOneCellRefList.clear();
}

tU32 fi_tcl_NavSpotDestinationOneCellListSet::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 8+ClusterRefList.size()*9+SpotDestinationOneCellRefList.size()*30;
}

tBool fi_tcl_NavSpotDestinationOneCellListSet::operator==(const fi_tcl_NavSpotDestinationOneCellListSet& rfoCmp) const
{
   tBool bResult = true;
      bResult = bResult && (ClusterRefList.size() == rfoCmp.ClusterRefList.size());
      if (bResult)
      {
         for (tU32 u32Idx = 0; bResult && (u32Idx < ClusterRefList.size()); ++u32Idx)
            bResult = bResult && (ClusterRefList[u32Idx] == rfoCmp.ClusterRefList[u32Idx]);
      }
      bResult = bResult && (SpotDestinationOneCellRefList.size() == rfoCmp.SpotDestinationOneCellRefList.size());
      if (bResult)
      {
         for (tU32 u32Idx = 0; bResult && (u32Idx < SpotDestinationOneCellRefList.size()); ++u32Idx)
            bResult = bResult && (SpotDestinationOneCellRefList[u32Idx] == rfoCmp.SpotDestinationOneCellRefList[u32Idx]);
      }
   return bResult;
}

fi_tclInContext& fi_tcl_NavSpotDestinationOneCellListSet::oRead(fi_tclInContext& oIn)
{
   {
      tU32 u32Length;
      tU32 u32Idx;
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
      for (u32Idx = 0; u32Idx < ClusterRefList.size(); ++u32Idx)
      {
         ClusterRefList[u32Idx].vDestroy();
      }
#endif // !VARIANT_S_FTR_ENABLE_DEEP_COPY
      oIn >> u32Length;
      ClusterRefList.resize(u32Length);
      for (u32Idx = 0; u32Idx < u32Length; ++u32Idx)
      {
         oIn >> ClusterRefList[u32Idx];
      }
   }
   {
      tU32 u32Length;
      tU32 u32Idx;
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
      for (u32Idx = 0; u32Idx < SpotDestinationOneCellRefList.size(); ++u32Idx)
      {
         SpotDestinationOneCellRefList[u32Idx].vDestroy();
      }
#endif // !VARIANT_S_FTR_ENABLE_DEEP_COPY
      oIn >> u32Length;
      SpotDestinationOneCellRefList.resize(u32Length);
      for (u32Idx = 0; u32Idx < u32Length; ++u32Idx)
      {
         oIn >> SpotDestinationOneCellRefList[u32Idx];
      }
   }
   return oIn;
}

fi_tclOutContext& fi_tcl_NavSpotDestinationOneCellListSet::oWrite(fi_tclOutContext& oOut) const
{
   oOut << (tU32)ClusterRefList.size();
   {
      for (tU32 u32Idx = 0; u32Idx < ClusterRefList.size(); ++u32Idx)
         oOut << ClusterRefList[u32Idx];
   }
   oOut << (tU32)SpotDestinationOneCellRefList.size();
   {
      for (tU32 u32Idx = 0; u32Idx < SpotDestinationOneCellRefList.size(); ++u32Idx)
         oOut << SpotDestinationOneCellRefList[u32Idx];
   }
   return oOut;
}

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
fi_tcl_NavPosOneCellProperty::fi_tcl_NavPosOneCellProperty(const fi_tcl_NavPosOneCellProperty& coRef):fi_tclVisitableTypeBase(coRef)
{
   CountryCode = coRef.CountryCode;
   OneCellLength = coRef.OneCellLength;
   RoadClass = coRef.RoadClass;
   RoadType = coRef.RoadType;
   RoadNetworkClass = coRef.RoadNetworkClass;
   OneCellStatus = coRef.OneCellStatus;
   StateCode = coRef.StateCode;
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
fi_tcl_NavPosOneCellProperty& fi_tcl_NavPosOneCellProperty::operator=(const fi_tcl_NavPosOneCellProperty& coRef)
{
   if (this == &coRef) return *this;
   CountryCode = coRef.CountryCode;
   OneCellLength = coRef.OneCellLength;
   RoadClass = coRef.RoadClass;
   RoadType = coRef.RoadType;
   RoadNetworkClass = coRef.RoadNetworkClass;
   OneCellStatus = coRef.OneCellStatus;
   StateCode = coRef.StateCode;
   return *this;
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
tU32 fi_tcl_NavPosOneCellProperty::u32GetSize(tU16 u16MajorVersion) const
{
   tU32 u32DynamicSize = 0;
   if (11 <= u16MajorVersion)
   {
      u32DynamicSize += 1;
   }
   if (11 <= u16MajorVersion)
   {
      u32DynamicSize += 4;
   }
   return u32DynamicSize+12;
}

tBool fi_tcl_NavPosOneCellProperty::operator==(const fi_tcl_NavPosOneCellProperty& rfoCmp) const
{
   tBool bResult = true;
      bResult = bResult && (CountryCode == rfoCmp.CountryCode);
      bResult = bResult && (OneCellLength == rfoCmp.OneCellLength);
      bResult = bResult && (RoadClass == rfoCmp.RoadClass);
      bResult = bResult && (RoadType == rfoCmp.RoadType);
      bResult = bResult && (RoadNetworkClass == rfoCmp.RoadNetworkClass);
      bResult = bResult && (OneCellStatus == rfoCmp.OneCellStatus);
      bResult = bResult && (StateCode == rfoCmp.StateCode);
   return bResult;
}

fi_tclInContext& fi_tcl_NavPosOneCellProperty::oRead(fi_tclInContext& oIn)
{
   oIn >> CountryCode;
   oIn >> OneCellLength;
   oIn >> RoadClass;
   oIn >> RoadType;
   if (11 <= oIn.u16GetMajorVersion())
   {
      oIn >> RoadNetworkClass;
   }
   oIn >> OneCellStatus;
   if (11 <= oIn.u16GetMajorVersion())
   {
      oIn >> StateCode;
   }
   return oIn;
}

fi_tclOutContext& fi_tcl_NavPosOneCellProperty::oWrite(fi_tclOutContext& oOut) const
{
   oOut << CountryCode;
   oOut << OneCellLength;
   oOut << RoadClass;
   oOut << RoadType;
   if (11 <= oOut.u16GetMajorVersion())
   {
      oOut << RoadNetworkClass;
   }
   oOut << OneCellStatus;
   if (11 <= oOut.u16GetMajorVersion())
   {
      oOut << StateCode;
   }
   return oOut;
}

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
fi_tcl_NavIntersectionDestinationZeroCellListSet::fi_tcl_NavIntersectionDestinationZeroCellListSet(const fi_tcl_NavIntersectionDestinationZeroCellListSet& coRef):fi_tclVisitableTypeBase(coRef)
{
   ClusterRefList = coRef.ClusterRefList;
   IntersectionDestinationZeroCellRefList = coRef.IntersectionDestinationZeroCellRefList;
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
fi_tcl_NavIntersectionDestinationZeroCellListSet& fi_tcl_NavIntersectionDestinationZeroCellListSet::operator=(const fi_tcl_NavIntersectionDestinationZeroCellListSet& coRef)
{
   if (this == &coRef) return *this;
   ClusterRefList = coRef.ClusterRefList;
   IntersectionDestinationZeroCellRefList = coRef.IntersectionDestinationZeroCellRefList;
   return *this;
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
tVoid fi_tcl_NavIntersectionDestinationZeroCellListSet::vDestroy()
{
   {
      for (tU32 u32Idx = 0; u32Idx < ClusterRefList.size(); ++u32Idx)
         ClusterRefList[u32Idx].vDestroy();
   }
   ClusterRefList.clear();
   {
      for (tU32 u32Idx = 0; u32Idx < IntersectionDestinationZeroCellRefList.size(); ++u32Idx)
         IntersectionDestinationZeroCellRefList[u32Idx].vDestroy();
   }
   IntersectionDestinationZeroCellRefList.clear();
}

tU32 fi_tcl_NavIntersectionDestinationZeroCellListSet::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 8+ClusterRefList.size()*9+IntersectionDestinationZeroCellRefList.size()*9;
}

tBool fi_tcl_NavIntersectionDestinationZeroCellListSet::operator==(const fi_tcl_NavIntersectionDestinationZeroCellListSet& rfoCmp) const
{
   tBool bResult = true;
      bResult = bResult && (ClusterRefList.size() == rfoCmp.ClusterRefList.size());
      if (bResult)
      {
         for (tU32 u32Idx = 0; bResult && (u32Idx < ClusterRefList.size()); ++u32Idx)
            bResult = bResult && (ClusterRefList[u32Idx] == rfoCmp.ClusterRefList[u32Idx]);
      }
      bResult = bResult && (IntersectionDestinationZeroCellRefList.size() == rfoCmp.IntersectionDestinationZeroCellRefList.size());
      if (bResult)
      {
         for (tU32 u32Idx = 0; bResult && (u32Idx < IntersectionDestinationZeroCellRefList.size()); ++u32Idx)
            bResult = bResult && (IntersectionDestinationZeroCellRefList[u32Idx] == rfoCmp.IntersectionDestinationZeroCellRefList[u32Idx]);
      }
   return bResult;
}

fi_tclInContext& fi_tcl_NavIntersectionDestinationZeroCellListSet::oRead(fi_tclInContext& oIn)
{
   {
      tU32 u32Length;
      tU32 u32Idx;
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
      for (u32Idx = 0; u32Idx < ClusterRefList.size(); ++u32Idx)
      {
         ClusterRefList[u32Idx].vDestroy();
      }
#endif // !VARIANT_S_FTR_ENABLE_DEEP_COPY
      oIn >> u32Length;
      ClusterRefList.resize(u32Length);
      for (u32Idx = 0; u32Idx < u32Length; ++u32Idx)
      {
         oIn >> ClusterRefList[u32Idx];
      }
   }
   {
      tU32 u32Length;
      tU32 u32Idx;
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
      for (u32Idx = 0; u32Idx < IntersectionDestinationZeroCellRefList.size(); ++u32Idx)
      {
         IntersectionDestinationZeroCellRefList[u32Idx].vDestroy();
      }
#endif // !VARIANT_S_FTR_ENABLE_DEEP_COPY
      oIn >> u32Length;
      IntersectionDestinationZeroCellRefList.resize(u32Length);
      for (u32Idx = 0; u32Idx < u32Length; ++u32Idx)
      {
         oIn >> IntersectionDestinationZeroCellRefList[u32Idx];
      }
   }
   return oIn;
}

fi_tclOutContext& fi_tcl_NavIntersectionDestinationZeroCellListSet::oWrite(fi_tclOutContext& oOut) const
{
   oOut << (tU32)ClusterRefList.size();
   {
      for (tU32 u32Idx = 0; u32Idx < ClusterRefList.size(); ++u32Idx)
         oOut << ClusterRefList[u32Idx];
   }
   oOut << (tU32)IntersectionDestinationZeroCellRefList.size();
   {
      for (tU32 u32Idx = 0; u32Idx < IntersectionDestinationZeroCellRefList.size(); ++u32Idx)
         oOut << IntersectionDestinationZeroCellRefList[u32Idx];
   }
   return oOut;
}

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
fi_tcl_NavOneCell::fi_tcl_NavOneCell(const fi_tcl_NavOneCell& coRef):fi_tclVisitableTypeBase(coRef)
{
   OneCellId = coRef.OneCellId;
   UseDirection = coRef.UseDirection;
   ClusterFileId = coRef.ClusterFileId;
   ClusterFileOffset = coRef.ClusterFileOffset;
   ClusterLength = coRef.ClusterLength;
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
fi_tcl_NavOneCell& fi_tcl_NavOneCell::operator=(const fi_tcl_NavOneCell& coRef)
{
   if (this == &coRef) return *this;
   OneCellId = coRef.OneCellId;
   UseDirection = coRef.UseDirection;
   ClusterFileId = coRef.ClusterFileId;
   ClusterFileOffset = coRef.ClusterFileOffset;
   ClusterLength = coRef.ClusterLength;
   return *this;
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
tU32 fi_tcl_NavOneCell::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 11;
}

tBool fi_tcl_NavOneCell::operator==(const fi_tcl_NavOneCell& rfoCmp) const
{
   tBool bResult = true;
      bResult = bResult && (OneCellId == rfoCmp.OneCellId);
      bResult = bResult && (UseDirection == rfoCmp.UseDirection);
      bResult = bResult && (ClusterFileId == rfoCmp.ClusterFileId);
      bResult = bResult && (ClusterFileOffset == rfoCmp.ClusterFileOffset);
      bResult = bResult && (ClusterLength == rfoCmp.ClusterLength);
   return bResult;
}

fi_tclInContext& fi_tcl_NavOneCell::oRead(fi_tclInContext& oIn)
{
   oIn >> OneCellId;
   oIn >> UseDirection;
   oIn >> ClusterFileId;
   oIn >> ClusterFileOffset;
   oIn >> ClusterLength;
   return oIn;
}

fi_tclOutContext& fi_tcl_NavOneCell::oWrite(fi_tclOutContext& oOut) const
{
   oOut << OneCellId;
   oOut << UseDirection;
   oOut << ClusterFileId;
   oOut << ClusterFileOffset;
   oOut << ClusterLength;
   return oOut;
}

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
fi_tcl_SignPostElement::fi_tcl_SignPostElement(const fi_tcl_SignPostElement& coRef):fi_tclVisitableTypeBase(coRef)
{
   NavOneCellCategoryType = coRef.NavOneCellCategoryType;
   if  (coRef.poNavOneCellCategoryData)
   {
      switch(NavOneCellCategoryType.enType)
      {
      case fi_tcl_e8_NavOneCellCategory::FI_EN_T_RESERVED:
         poNavOneCellCategoryData = OSAL_NEW fi_tcl_Reserved((const fi_tcl_Reserved&)*coRef.poNavOneCellCategoryData);
         break;
      case fi_tcl_e8_NavOneCellCategory::FI_EN_T_NAVONECELL:
         poNavOneCellCategoryData = OSAL_NEW fi_tcl_NavOneCell((const fi_tcl_NavOneCell&)*coRef.poNavOneCellCategoryData);
         break;
      case fi_tcl_e8_NavOneCellCategory::FI_EN_T_U16_INDEXINREFERENCELIST:
         poNavOneCellCategoryData = OSAL_NEW fi_tcl_u16_IndexInReferenceList((const fi_tcl_u16_IndexInReferenceList&)*coRef.poNavOneCellCategoryData);
         break;
      default:
         poNavOneCellCategoryData = OSAL_NULL;
      }
   }
   else
   {
      poNavOneCellCategoryData = OSAL_NULL;
   }
   Status = coRef.Status;
   SignPostDestination = coRef.SignPostDestination;
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
fi_tcl_SignPostElement& fi_tcl_SignPostElement::operator=(const fi_tcl_SignPostElement& coRef)
{
   if (this == &coRef) return *this;
   OSAL_DELETE poNavOneCellCategoryData;
   NavOneCellCategoryType = coRef.NavOneCellCategoryType;
   if  (coRef.poNavOneCellCategoryData)
   {
      switch(NavOneCellCategoryType.enType)
      {
      case fi_tcl_e8_NavOneCellCategory::FI_EN_T_RESERVED:
         poNavOneCellCategoryData = OSAL_NEW fi_tcl_Reserved((const fi_tcl_Reserved&)*coRef.poNavOneCellCategoryData);
         break;
      case fi_tcl_e8_NavOneCellCategory::FI_EN_T_NAVONECELL:
         poNavOneCellCategoryData = OSAL_NEW fi_tcl_NavOneCell((const fi_tcl_NavOneCell&)*coRef.poNavOneCellCategoryData);
         break;
      case fi_tcl_e8_NavOneCellCategory::FI_EN_T_U16_INDEXINREFERENCELIST:
         poNavOneCellCategoryData = OSAL_NEW fi_tcl_u16_IndexInReferenceList((const fi_tcl_u16_IndexInReferenceList&)*coRef.poNavOneCellCategoryData);
         break;
      default:
         poNavOneCellCategoryData = OSAL_NULL;
      }
   }
   else
   {
      poNavOneCellCategoryData = OSAL_NULL;
   }
   Status = coRef.Status;
   SignPostDestination = coRef.SignPostDestination;
   return *this;
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
fi_tcl_SignPostElement::~fi_tcl_SignPostElement()
{
   OSAL_DELETE poNavOneCellCategoryData;
   poNavOneCellCategoryData = OSAL_NULL;
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
tVoid fi_tcl_SignPostElement::vDestroy()
{
   if (poNavOneCellCategoryData)
   {
      poNavOneCellCategoryData->vDestroy();
      OSAL_DELETE poNavOneCellCategoryData;
      poNavOneCellCategoryData = OSAL_NULL;
   }
   {
      for (tU32 u32Idx = 0; u32Idx < SignPostDestination.size(); ++u32Idx)
         SignPostDestination[u32Idx].vDestroy();
   }
   SignPostDestination.clear();
}

tU32 fi_tcl_SignPostElement::u32GetSize(tU16 u16MajorVersion) const
{
   tU32 u32DynamicSize = 0;
   if (u16MajorVersion <= 8)
   {
      u32DynamicSize += 1;
   }
   tU32 u32ListIdx;
   for (u32ListIdx = 0; u32ListIdx < SignPostDestination.size(); ++u32ListIdx)
      u32DynamicSize += SignPostDestination[u32ListIdx].u32GetSize(u16MajorVersion);
   return u32DynamicSize+5+(poNavOneCellCategoryData?poNavOneCellCategoryData->u32GetSize(u16MajorVersion):0);
}

tBool fi_tcl_SignPostElement::operator==(const fi_tcl_SignPostElement& rfoCmp) const
{
   tBool bResult = true;
   bResult = bResult && (NavOneCellCategoryType == rfoCmp.NavOneCellCategoryType);
   if (bResult && poNavOneCellCategoryData && rfoCmp.poNavOneCellCategoryData) 
   {
      switch (NavOneCellCategoryType.enType)
      {
      case fi_tcl_e8_NavOneCellCategory::FI_EN_T_RESERVED:
         bResult = bResult && (*(const fi_tcl_Reserved*)poNavOneCellCategoryData == *(const fi_tcl_Reserved*)rfoCmp.poNavOneCellCategoryData); //lint !e826
      break;
      case fi_tcl_e8_NavOneCellCategory::FI_EN_T_NAVONECELL:
         bResult = bResult && (*(const fi_tcl_NavOneCell*)poNavOneCellCategoryData == *(const fi_tcl_NavOneCell*)rfoCmp.poNavOneCellCategoryData); //lint !e826
      break;
      case fi_tcl_e8_NavOneCellCategory::FI_EN_T_U16_INDEXINREFERENCELIST:
         bResult = bResult && (*(const fi_tcl_u16_IndexInReferenceList*)poNavOneCellCategoryData == *(const fi_tcl_u16_IndexInReferenceList*)rfoCmp.poNavOneCellCategoryData); //lint !e826
      break;
      }
   }
   else
   {
      bResult = bResult && (poNavOneCellCategoryData == rfoCmp.poNavOneCellCategoryData);
   }
      bResult = bResult && (Status == rfoCmp.Status);
      bResult = bResult && (SignPostDestination.size() == rfoCmp.SignPostDestination.size());
      if (bResult)
      {
         for (tU32 u32Idx = 0; bResult && (u32Idx < SignPostDestination.size()); ++u32Idx)
            bResult = bResult && (SignPostDestination[u32Idx] == rfoCmp.SignPostDestination[u32Idx]);
      }
   return bResult;
}

fi_tclInContext& fi_tcl_SignPostElement::oRead(fi_tclInContext& oIn)
{
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   OSAL_DELETE poNavOneCellCategoryData;
#else
   if (poNavOneCellCategoryData)
   {
      poNavOneCellCategoryData->vDestroy();
      OSAL_DELETE poNavOneCellCategoryData;
   }
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
   oIn >> NavOneCellCategoryType;
   switch(NavOneCellCategoryType.enType)
   {
   case fi_tcl_e8_NavOneCellCategory::FI_EN_T_RESERVED:
      poNavOneCellCategoryData = OSAL_NEW fi_tcl_Reserved;
      break;
   case fi_tcl_e8_NavOneCellCategory::FI_EN_T_NAVONECELL:
      poNavOneCellCategoryData = OSAL_NEW fi_tcl_NavOneCell;
      break;
   case fi_tcl_e8_NavOneCellCategory::FI_EN_T_U16_INDEXINREFERENCELIST:
      poNavOneCellCategoryData = OSAL_NEW fi_tcl_u16_IndexInReferenceList;
      break;
   default:
      oIn.Invalidate();
      poNavOneCellCategoryData = OSAL_NULL;
   }
   if (poNavOneCellCategoryData && oIn.bIsValid())
      poNavOneCellCategoryData->oRead(oIn);
   else
      oIn.Invalidate();
   if (oIn.u16GetMajorVersion() <= 8)
   {
      oIn >> Status;
   }
   {
      tU32 u32Length;
      tU32 u32Idx;
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
      for (u32Idx = 0; u32Idx < SignPostDestination.size(); ++u32Idx)
      {
         SignPostDestination[u32Idx].vDestroy();
      }
#endif // !VARIANT_S_FTR_ENABLE_DEEP_COPY
      oIn >> u32Length;
      SignPostDestination.resize(u32Length);
      for (u32Idx = 0; u32Idx < u32Length; ++u32Idx)
      {
         oIn >> SignPostDestination[u32Idx];
      }
   }
   return oIn;
}

fi_tclOutContext& fi_tcl_SignPostElement::oWrite(fi_tclOutContext& oOut) const
{
   oOut << NavOneCellCategoryType;
   if (poNavOneCellCategoryData)
   {
      poNavOneCellCategoryData->oWrite(oOut);
   }
   else
   {
      oOut.Invalidate();
   }
   if (oOut.u16GetMajorVersion() <= 8)
   {
      oOut << Status;
   }
   oOut << (tU32)SignPostDestination.size();
   {
      for (tU32 u32Idx = 0; u32Idx < SignPostDestination.size(); ++u32Idx)
         oOut << SignPostDestination[u32Idx];
   }
   return oOut;
}

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
fi_tcl_NavDLDChainOneCellProperty::fi_tcl_NavDLDChainOneCellProperty(const fi_tcl_NavDLDChainOneCellProperty& coRef):fi_tclVisitableTypeBase(coRef)
{
   LengthFromFirstOC = coRef.LengthFromFirstOC;
   TurnLengthOnFollowingIntersection = coRef.TurnLengthOnFollowingIntersection;
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
fi_tcl_NavDLDChainOneCellProperty& fi_tcl_NavDLDChainOneCellProperty::operator=(const fi_tcl_NavDLDChainOneCellProperty& coRef)
{
   if (this == &coRef) return *this;
   LengthFromFirstOC = coRef.LengthFromFirstOC;
   TurnLengthOnFollowingIntersection = coRef.TurnLengthOnFollowingIntersection;
   return *this;
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
tU32 fi_tcl_NavDLDChainOneCellProperty::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 8;
}

tBool fi_tcl_NavDLDChainOneCellProperty::operator==(const fi_tcl_NavDLDChainOneCellProperty& rfoCmp) const
{
   tBool bResult = true;
      bResult = bResult && (LengthFromFirstOC == rfoCmp.LengthFromFirstOC);
      bResult = bResult && (TurnLengthOnFollowingIntersection == rfoCmp.TurnLengthOnFollowingIntersection);
   return bResult;
}

fi_tclInContext& fi_tcl_NavDLDChainOneCellProperty::oRead(fi_tclInContext& oIn)
{
   oIn >> LengthFromFirstOC;
   oIn >> TurnLengthOnFollowingIntersection;
   return oIn;
}

fi_tclOutContext& fi_tcl_NavDLDChainOneCellProperty::oWrite(fi_tclOutContext& oOut) const
{
   oOut << LengthFromFirstOC;
   oOut << TurnLengthOnFollowingIntersection;
   return oOut;
}

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
fi_tcl_NavDLDChainOneCellDesc::fi_tcl_NavDLDChainOneCellDesc(const fi_tcl_NavDLDChainOneCellDesc& coRef):fi_tclVisitableTypeBase(coRef)
{
   OneCellDesc = coRef.OneCellDesc;
   OneCellProperty = coRef.OneCellProperty;
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
fi_tcl_NavDLDChainOneCellDesc& fi_tcl_NavDLDChainOneCellDesc::operator=(const fi_tcl_NavDLDChainOneCellDesc& coRef)
{
   if (this == &coRef) return *this;
   OneCellDesc = coRef.OneCellDesc;
   OneCellProperty = coRef.OneCellProperty;
   return *this;
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
tVoid fi_tcl_NavDLDChainOneCellDesc::vDestroy()
{
   OneCellDesc.vDestroy(); 
   OneCellProperty.vDestroy(); 
}

tU32 fi_tcl_NavDLDChainOneCellDesc::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 13;
}

tBool fi_tcl_NavDLDChainOneCellDesc::operator==(const fi_tcl_NavDLDChainOneCellDesc& rfoCmp) const
{
   tBool bResult = true;
      bResult = bResult && (OneCellDesc == rfoCmp.OneCellDesc);
      bResult = bResult && (OneCellProperty == rfoCmp.OneCellProperty);
   return bResult;
}

fi_tclInContext& fi_tcl_NavDLDChainOneCellDesc::oRead(fi_tclInContext& oIn)
{
   oIn >> OneCellDesc;
   oIn >> OneCellProperty;
   return oIn;
}

fi_tclOutContext& fi_tcl_NavDLDChainOneCellDesc::oWrite(fi_tclOutContext& oOut) const
{
   oOut << OneCellDesc;
   oOut << OneCellProperty;
   return oOut;
}

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
fi_tcl_NavDLDChainOneCellListSet::fi_tcl_NavDLDChainOneCellListSet(const fi_tcl_NavDLDChainOneCellListSet& coRef):fi_tclVisitableTypeBase(coRef)
{
   ClusterRefList = coRef.ClusterRefList;
   OneCellRefList = coRef.OneCellRefList;
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
fi_tcl_NavDLDChainOneCellListSet& fi_tcl_NavDLDChainOneCellListSet::operator=(const fi_tcl_NavDLDChainOneCellListSet& coRef)
{
   if (this == &coRef) return *this;
   ClusterRefList = coRef.ClusterRefList;
   OneCellRefList = coRef.OneCellRefList;
   return *this;
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
tVoid fi_tcl_NavDLDChainOneCellListSet::vDestroy()
{
   {
      for (tU32 u32Idx = 0; u32Idx < ClusterRefList.size(); ++u32Idx)
         ClusterRefList[u32Idx].vDestroy();
   }
   ClusterRefList.clear();
   {
      for (tU32 u32Idx = 0; u32Idx < OneCellRefList.size(); ++u32Idx)
         OneCellRefList[u32Idx].vDestroy();
   }
   OneCellRefList.clear();
}

tU32 fi_tcl_NavDLDChainOneCellListSet::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 8+ClusterRefList.size()*9+OneCellRefList.size()*13;
}

tBool fi_tcl_NavDLDChainOneCellListSet::operator==(const fi_tcl_NavDLDChainOneCellListSet& rfoCmp) const
{
   tBool bResult = true;
      bResult = bResult && (ClusterRefList.size() == rfoCmp.ClusterRefList.size());
      if (bResult)
      {
         for (tU32 u32Idx = 0; bResult && (u32Idx < ClusterRefList.size()); ++u32Idx)
            bResult = bResult && (ClusterRefList[u32Idx] == rfoCmp.ClusterRefList[u32Idx]);
      }
      bResult = bResult && (OneCellRefList.size() == rfoCmp.OneCellRefList.size());
      if (bResult)
      {
         for (tU32 u32Idx = 0; bResult && (u32Idx < OneCellRefList.size()); ++u32Idx)
            bResult = bResult && (OneCellRefList[u32Idx] == rfoCmp.OneCellRefList[u32Idx]);
      }
   return bResult;
}

fi_tclInContext& fi_tcl_NavDLDChainOneCellListSet::oRead(fi_tclInContext& oIn)
{
   {
      tU32 u32Length;
      tU32 u32Idx;
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
      for (u32Idx = 0; u32Idx < ClusterRefList.size(); ++u32Idx)
      {
         ClusterRefList[u32Idx].vDestroy();
      }
#endif // !VARIANT_S_FTR_ENABLE_DEEP_COPY
      oIn >> u32Length;
      ClusterRefList.resize(u32Length);
      for (u32Idx = 0; u32Idx < u32Length; ++u32Idx)
      {
         oIn >> ClusterRefList[u32Idx];
      }
   }
   {
      tU32 u32Length;
      tU32 u32Idx;
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
      for (u32Idx = 0; u32Idx < OneCellRefList.size(); ++u32Idx)
      {
         OneCellRefList[u32Idx].vDestroy();
      }
#endif // !VARIANT_S_FTR_ENABLE_DEEP_COPY
      oIn >> u32Length;
      OneCellRefList.resize(u32Length);
      for (u32Idx = 0; u32Idx < u32Length; ++u32Idx)
      {
         oIn >> OneCellRefList[u32Idx];
      }
   }
   return oIn;
}

fi_tclOutContext& fi_tcl_NavDLDChainOneCellListSet::oWrite(fi_tclOutContext& oOut) const
{
   oOut << (tU32)ClusterRefList.size();
   {
      for (tU32 u32Idx = 0; u32Idx < ClusterRefList.size(); ++u32Idx)
         oOut << ClusterRefList[u32Idx];
   }
   oOut << (tU32)OneCellRefList.size();
   {
      for (tU32 u32Idx = 0; u32Idx < OneCellRefList.size(); ++u32Idx)
         oOut << OneCellRefList[u32Idx];
   }
   return oOut;
}

#ifndef FI_S_EXTERNAL_FI
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
fi_tcl_NavUTMBinContainer::fi_tcl_NavUTMBinContainer(const fi_tcl_NavUTMBinContainer& coRef):fi_tclVisitableTypeBase(coRef)
{
   ContainerLength = coRef.ContainerLength;
   ServiceID = coRef.ServiceID;
   ContainerFIVersion = coRef.ContainerFIVersion;
   ContainerType = coRef.ContainerType;
   NavDataSetID = coRef.NavDataSetID;
   UTMOneCellListSet = coRef.UTMOneCellListSet;
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
fi_tcl_NavUTMBinContainer& fi_tcl_NavUTMBinContainer::operator=(const fi_tcl_NavUTMBinContainer& coRef)
{
   if (this == &coRef) return *this;
   ContainerLength = coRef.ContainerLength;
   ServiceID = coRef.ServiceID;
   ContainerFIVersion = coRef.ContainerFIVersion;
   ContainerType = coRef.ContainerType;
   NavDataSetID = coRef.NavDataSetID;
   UTMOneCellListSet = coRef.UTMOneCellListSet;
   return *this;
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
tVoid fi_tcl_NavUTMBinContainer::vDestroy()
{
   ContainerFIVersion.vDestroy(); 
   UTMOneCellListSet.vDestroy(); 
}

tU32 fi_tcl_NavUTMBinContainer::u32GetSize(tU16 u16MajorVersion) const
{
   u16MajorVersion = ContainerFIVersion.MajorVersion;
   return 14+UTMOneCellListSet.u32GetSize(u16MajorVersion);
}

tBool fi_tcl_NavUTMBinContainer::operator==(const fi_tcl_NavUTMBinContainer& rfoCmp) const
{
   tBool bResult = true;
      bResult = bResult && (ContainerLength == rfoCmp.ContainerLength);
      bResult = bResult && (ServiceID == rfoCmp.ServiceID);
      bResult = bResult && (ContainerFIVersion == rfoCmp.ContainerFIVersion);
      bResult = bResult && (ContainerType == rfoCmp.ContainerType);
      bResult = bResult && (NavDataSetID == rfoCmp.NavDataSetID);
      bResult = bResult && (UTMOneCellListSet == rfoCmp.UTMOneCellListSet);
   return bResult;
}

fi_tclInContext& fi_tcl_NavUTMBinContainer::oRead(fi_tclInContext& oIn)
{
   oIn >> ContainerLength;
   oIn >> ServiceID;
   oIn >> ContainerFIVersion;
   oIn >> ContainerType;
   if (!oIn.bIsValid() ||
       (ContainerLength <= 6) ||
       (ContainerType.enType != fi_tcl_e8_BinContainerTypes::FI_EN_T_NAVUTMBINCONTAINER) ||
       (ContainerFIVersion.MajorVersion < fi_tcl_NavUTMBinContainer::C_U16_MAJORVERSION_MIN) ||
       (ContainerFIVersion.MajorVersion > fi_tcl_NavUTMBinContainer::C_U16_MAJORVERSION_MAX))
   {
      if (oIn.bIsValid() && (ContainerLength >= 6))
      {
         // read rest of container but discard it
         for (tU32 u32Dummy = 0; u32Dummy < (ContainerLength - 6); ++u32Dummy)
         {
            tU8 u8Dummy;
            oIn.oRead(u8Dummy);
         }
      }
      else
      {
         oIn.Invalidate();
      }
      return oIn;
   }
   tU16 u16MajorVersion = oIn.u16SetMajorVersion(ContainerFIVersion.MajorVersion);
   oIn >> NavDataSetID;
   oIn >> UTMOneCellListSet;
   oIn.u16SetMajorVersion(u16MajorVersion);
   return oIn;
}

fi_tclOutContext& fi_tcl_NavUTMBinContainer::oWrite(fi_tclOutContext& oOut) const
{
   tU16 u16MajorVersion = oOut.u16SetMajorVersion(ContainerFIVersion.MajorVersion);
   oOut << ContainerLength;
   oOut << ServiceID;
   oOut << ContainerFIVersion;
   oOut << ContainerType;
   oOut << NavDataSetID;
   oOut << UTMOneCellListSet;
   oOut.u16SetMajorVersion(u16MajorVersion);
   return oOut;
}

tU16 fi_tcl_NavUTMBinContainer::u16Transform(const fi_tcl_BinContainer& oContainer)
{
   tU16 u16RetVal = 0;
   if (&oContainer != OSAL_NULL) //lint !e774 (&oContainer CAN be NULL!!)
   {
      this->vDestroy();
      tU32 u32MinSize = this->u32GetSize(fi_tcl_NavUTMBinContainer::C_U16_MAJORVERSION_MAX);
      tU32 u32Size = oContainer.u32GetSize(0);
      if (u32Size >= u32MinSize)
      {
         tU8* pu8Buf = OSAL_NEW tU8[u32Size];
         if (pu8Buf != OSAL_NULL)
         {
            if (oContainer.ContainerDataList[5] == (tU8)fi_tcl_e8_BinContainerTypes::FI_EN_T_NAVUTMBINCONTAINER)
            {
               tU16 u16MajorVersion = oContainer.ContainerDataList[2];
               if ((u16MajorVersion >= fi_tcl_NavUTMBinContainer::C_U16_MAJORVERSION_MIN) &&
                   (u16MajorVersion <= fi_tcl_NavUTMBinContainer::C_U16_MAJORVERSION_MAX))
               {
                  fi_tclOutContext oOut(pu8Buf,pu8Buf+u32Size,u16MajorVersion);
                  fi_tclInContext  oIn (pu8Buf,pu8Buf+u32Size,u16MajorVersion);
                  oOut << oContainer;
                  oIn >> *this;
                  if (!oIn.bIsValid())
                  {
                     u16RetVal = FI_C_U16_ERROR_INTERNALFAILURE;
                  }
               }
               else
               {
                  u16RetVal = FI_C_U16_ERROR_INVALIDBINCONTAINERWRONGVERSION;
               }
            }
            else
            {
               u16RetVal = FI_C_U16_ERROR_INVALIDBINCONTAINERUNEXPECTEDDATA;
            }
         }
         else
         {
            this->ContainerType.enType = fi_tcl_e8_BinContainerTypes::FI_EN_T_RESERVED;
            u16RetVal = FI_C_U16_ERROR_INTERNALFAILURE;
         }
         OSAL_DELETE[] pu8Buf;
      }
      else
      {
         u16RetVal = FI_C_U16_ERROR_INVALIDBINCONTAINERUNEXPECTEDDATA;
      }
   }
   else
   {
      u16RetVal = FI_C_U16_ERROR_INVALIDBINCONTAINERUNEXPECTEDDATA;
   }
   return u16RetVal;
}

const tU16 fi_tcl_NavUTMBinContainer::C_U16_MAJORVERSION_MAX = 33;
const tU16 fi_tcl_NavUTMBinContainer::C_U16_MAJORVERSION_MIN = 6;

#endif // FI_S_EXTERNAL_FI
tU32 fi_tcl_e8_WeatherProtocol::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 1;
}

tBool fi_tcl_e8_WeatherProtocol::operator==(const fi_tcl_e8_WeatherProtocol& rfoCmp) const
{
   return enType == rfoCmp.enType;
}

fi_tclInContext& fi_tcl_e8_WeatherProtocol::oRead(fi_tclInContext& oIn)
{
   tU8 u8Value;
   oIn >> u8Value;
   enType = (tenType)u8Value;
   return oIn;
}

fi_tclOutContext& fi_tcl_e8_WeatherProtocol::oWrite(fi_tclOutContext& oOut) const
{
   return oOut.oWrite((tU8)enType);
}

tU32 fi_tcl_b8_CriterionStatus::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 1;
}

tBool fi_tcl_b8_CriterionStatus::operator==(const fi_tcl_b8_CriterionStatus& rfoCmp) const
{
   return u8Value == rfoCmp.u8Value;
}

fi_tclInContext& fi_tcl_b8_CriterionStatus::oRead(fi_tclInContext& oIn)
{
   return oIn >> u8Value;
}

fi_tclOutContext& fi_tcl_b8_CriterionStatus::oWrite(fi_tclOutContext& oOut) const
{
   return oOut << u8Value;
}

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
fi_tcl_AddressTemplate::fi_tcl_AddressTemplate(const fi_tcl_AddressTemplate& coRef):fi_tclVisitableTypeBase(coRef)
{
   CountryCode = coRef.CountryCode;
   SelectionCriteria = coRef.SelectionCriteria;
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
fi_tcl_AddressTemplate& fi_tcl_AddressTemplate::operator=(const fi_tcl_AddressTemplate& coRef)
{
   if (this == &coRef) return *this;
   CountryCode = coRef.CountryCode;
   SelectionCriteria = coRef.SelectionCriteria;
   return *this;
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
tVoid fi_tcl_AddressTemplate::vDestroy()
{
   SelectionCriteria.clear();
}

tU32 fi_tcl_AddressTemplate::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 6+SelectionCriteria.size()*2;
}

tBool fi_tcl_AddressTemplate::operator==(const fi_tcl_AddressTemplate& rfoCmp) const
{
   tBool bResult = true;
      bResult = bResult && (CountryCode == rfoCmp.CountryCode);
      bResult = bResult && (SelectionCriteria.size() == rfoCmp.SelectionCriteria.size());
      if (bResult)
      {
         for (tU32 u32Idx = 0; bResult && (u32Idx < SelectionCriteria.size()); ++u32Idx)
            bResult = bResult && (SelectionCriteria[u32Idx] == rfoCmp.SelectionCriteria[u32Idx]);
      }
   return bResult;
}

fi_tclInContext& fi_tcl_AddressTemplate::oRead(fi_tclInContext& oIn)
{
   oIn >> CountryCode;
   {
      tU32 u32Length;
      tU32 u32Idx;
      oIn >> u32Length;
      SelectionCriteria.resize(u32Length);
      for (u32Idx = 0; u32Idx < u32Length; ++u32Idx)
      {
         oIn >> SelectionCriteria[u32Idx];
      }
   }
   return oIn;
}

fi_tclOutContext& fi_tcl_AddressTemplate::oWrite(fi_tclOutContext& oOut) const
{
   oOut << CountryCode;
   oOut << (tU32)SelectionCriteria.size();
   {
      for (tU32 u32Idx = 0; u32Idx < SelectionCriteria.size(); ++u32Idx)
         oOut << SelectionCriteria[u32Idx];
   }
   return oOut;
}

tU32 fi_tcl_e8_FilterAttributeType::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 1;
}

tBool fi_tcl_e8_FilterAttributeType::operator==(const fi_tcl_e8_FilterAttributeType& rfoCmp) const
{
   return enType == rfoCmp.enType;
}

fi_tclInContext& fi_tcl_e8_FilterAttributeType::oRead(fi_tclInContext& oIn)
{
   tU8 u8Value;
   oIn >> u8Value;
   enType = (tenType)u8Value;
   return oIn;
}

fi_tclOutContext& fi_tcl_e8_FilterAttributeType::oWrite(fi_tclOutContext& oOut) const
{
   return oOut.oWrite((tU8)enType);
}

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
fi_tcl_FilterAttribute::fi_tcl_FilterAttribute(const fi_tcl_FilterAttribute& coRef):fi_tclVisitableTypeBase(coRef)
{
   Type = coRef.Type;
   Code = coRef.Code;
   Name = coRef.Name;
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
fi_tcl_FilterAttribute& fi_tcl_FilterAttribute::operator=(const fi_tcl_FilterAttribute& coRef)
{
   if (this == &coRef) return *this;
   Type = coRef.Type;
   Code = coRef.Code;
   Name = coRef.Name;
   return *this;
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
tVoid fi_tcl_FilterAttribute::vDestroy()
{
   Name.vDestroy();
}

tU32 fi_tcl_FilterAttribute::u32GetSize(tU16 u16MajorVersion) const
{
   return 3+Name.u32GetSize(u16MajorVersion);
}

tBool fi_tcl_FilterAttribute::operator==(const fi_tcl_FilterAttribute& rfoCmp) const
{
   tBool bResult = true;
      bResult = bResult && (Type == rfoCmp.Type);
      bResult = bResult && (Code == rfoCmp.Code);
      bResult = bResult && (Name == rfoCmp.Name);
   return bResult;
}

fi_tclInContext& fi_tcl_FilterAttribute::oRead(fi_tclInContext& oIn)
{
   oIn >> Type;
   oIn >> Code;
   oIn >> Name;
   return oIn;
}

fi_tclOutContext& fi_tcl_FilterAttribute::oWrite(fi_tclOutContext& oOut) const
{
   oOut << Type;
   oOut << Code;
   oOut << Name;
   return oOut;
}

tU32 fi_tcl_e16_MenuItemType::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 2;
}

tBool fi_tcl_e16_MenuItemType::operator==(const fi_tcl_e16_MenuItemType& rfoCmp) const
{
   return enType == rfoCmp.enType;
}

fi_tclInContext& fi_tcl_e16_MenuItemType::oRead(fi_tclInContext& oIn)
{
   tU16 u16Value;
   oIn >> u16Value;
   enType = (tenType)u16Value;
   return oIn;
}

fi_tclOutContext& fi_tcl_e16_MenuItemType::oWrite(fi_tclOutContext& oOut) const
{
   return oOut.oWrite((tU16)enType);
}

tU32 fi_tcl_e8_LocationValueListType::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 1;
}

tBool fi_tcl_e8_LocationValueListType::operator==(const fi_tcl_e8_LocationValueListType& rfoCmp) const
{
   return enType == rfoCmp.enType;
}

fi_tclInContext& fi_tcl_e8_LocationValueListType::oRead(fi_tclInContext& oIn)
{
   tU8 u8Value;
   oIn >> u8Value;
   enType = (tenType)u8Value;
   return oIn;
}

fi_tclOutContext& fi_tcl_e8_LocationValueListType::oWrite(fi_tclOutContext& oOut) const
{
   return oOut.oWrite((tU8)enType);
}

tU32 fi_tcl_b8_ListResultOptions::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 1;
}

tBool fi_tcl_b8_ListResultOptions::operator==(const fi_tcl_b8_ListResultOptions& rfoCmp) const
{
   return u8Value == rfoCmp.u8Value;
}

fi_tclInContext& fi_tcl_b8_ListResultOptions::oRead(fi_tclInContext& oIn)
{
   return oIn >> u8Value;
}

fi_tclOutContext& fi_tcl_b8_ListResultOptions::oWrite(fi_tclOutContext& oOut) const
{
   return oOut << u8Value;
}

tU32 fi_tcl_b8_ListGetOptions::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 1;
}

tBool fi_tcl_b8_ListGetOptions::operator==(const fi_tcl_b8_ListGetOptions& rfoCmp) const
{
   return u8Value == rfoCmp.u8Value;
}

fi_tclInContext& fi_tcl_b8_ListGetOptions::oRead(fi_tclInContext& oIn)
{
   return oIn >> u8Value;
}

fi_tclOutContext& fi_tcl_b8_ListGetOptions::oWrite(fi_tclOutContext& oOut) const
{
   tU8 temp = u8Value;
   if (!(17 <= oOut.u16GetMajorVersion()))
      temp &= ~FI_C_U8_BIT_INCLUDEALLEXONYMS;
   if (!(26 <= oOut.u16GetMajorVersion()))
      temp &= ~FI_C_U8_BIT_MAPGROUPINATTRIBUTES;
   return oOut << temp;
}

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
fi_tcl_LocationValueListUnion::fi_tcl_LocationValueListUnion(const fi_tcl_LocationValueListUnion& coRef):fi_tclVisitableTypeBase(coRef)
{
   ValueListType = coRef.ValueListType;
   if  (coRef.poValueListData)
   {
      switch(ValueListType.enType)
      {
      case fi_tcl_e8_LocationValueListType::FI_EN_T_RESERVED:
         poValueListData = OSAL_NEW fi_tcl_Reserved((const fi_tcl_Reserved&)*coRef.poValueListData);
         break;
      case fi_tcl_e8_LocationValueListType::FI_EN_T_STRINGLIST:
         poValueListData = OSAL_NEW fi_tcl_StringList((const fi_tcl_StringList&)*coRef.poValueListData);
         break;
      case fi_tcl_e8_LocationValueListType::FI_EN_T_STRINGDESCRIPTIONLIST:
         poValueListData = OSAL_NEW fi_tcl_StringDescriptionList((const fi_tcl_StringDescriptionList&)*coRef.poValueListData);
         break;
      case fi_tcl_e8_LocationValueListType::FI_EN_T_STRINGIDLIST:
         poValueListData = OSAL_NEW fi_tcl_StringIDList((const fi_tcl_StringIDList&)*coRef.poValueListData);
         break;
      case fi_tcl_e8_LocationValueListType::FI_EN_T_POSITIONWGS84LIST:
         poValueListData = OSAL_NEW fi_tcl_PositionWGS84List((const fi_tcl_PositionWGS84List&)*coRef.poValueListData);
         break;
      case fi_tcl_e8_LocationValueListType::FI_EN_T_STRINGPOSITIONLIST:
         poValueListData = OSAL_NEW fi_tcl_StringPositionList((const fi_tcl_StringPositionList&)*coRef.poValueListData);
         break;
      case fi_tcl_e8_LocationValueListType::FI_EN_T_STRINGPOSITIONDESCRIPTIONLIST:
         poValueListData = OSAL_NEW fi_tcl_StringPositionDescriptionList((const fi_tcl_StringPositionDescriptionList&)*coRef.poValueListData);
         break;
      default:
         poValueListData = OSAL_NULL;
      }
   }
   else
   {
      poValueListData = OSAL_NULL;
   }
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
fi_tcl_LocationValueListUnion& fi_tcl_LocationValueListUnion::operator=(const fi_tcl_LocationValueListUnion& coRef)
{
   if (this == &coRef) return *this;
   OSAL_DELETE poValueListData;
   ValueListType = coRef.ValueListType;
   if  (coRef.poValueListData)
   {
      switch(ValueListType.enType)
      {
      case fi_tcl_e8_LocationValueListType::FI_EN_T_RESERVED:
         poValueListData = OSAL_NEW fi_tcl_Reserved((const fi_tcl_Reserved&)*coRef.poValueListData);
         break;
      case fi_tcl_e8_LocationValueListType::FI_EN_T_STRINGLIST:
         poValueListData = OSAL_NEW fi_tcl_StringList((const fi_tcl_StringList&)*coRef.poValueListData);
         break;
      case fi_tcl_e8_LocationValueListType::FI_EN_T_STRINGDESCRIPTIONLIST:
         poValueListData = OSAL_NEW fi_tcl_StringDescriptionList((const fi_tcl_StringDescriptionList&)*coRef.poValueListData);
         break;
      case fi_tcl_e8_LocationValueListType::FI_EN_T_STRINGIDLIST:
         poValueListData = OSAL_NEW fi_tcl_StringIDList((const fi_tcl_StringIDList&)*coRef.poValueListData);
         break;
      case fi_tcl_e8_LocationValueListType::FI_EN_T_POSITIONWGS84LIST:
         poValueListData = OSAL_NEW fi_tcl_PositionWGS84List((const fi_tcl_PositionWGS84List&)*coRef.poValueListData);
         break;
      case fi_tcl_e8_LocationValueListType::FI_EN_T_STRINGPOSITIONLIST:
         poValueListData = OSAL_NEW fi_tcl_StringPositionList((const fi_tcl_StringPositionList&)*coRef.poValueListData);
         break;
      case fi_tcl_e8_LocationValueListType::FI_EN_T_STRINGPOSITIONDESCRIPTIONLIST:
         poValueListData = OSAL_NEW fi_tcl_StringPositionDescriptionList((const fi_tcl_StringPositionDescriptionList&)*coRef.poValueListData);
         break;
      default:
         poValueListData = OSAL_NULL;
      }
   }
   else
   {
      poValueListData = OSAL_NULL;
   }
   return *this;
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
fi_tcl_LocationValueListUnion::~fi_tcl_LocationValueListUnion()
{
   OSAL_DELETE poValueListData;
   poValueListData = OSAL_NULL;
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
tVoid fi_tcl_LocationValueListUnion::vDestroy()
{
   if (poValueListData)
   {
      poValueListData->vDestroy();
      OSAL_DELETE poValueListData;
      poValueListData = OSAL_NULL;
   }
}

tU32 fi_tcl_LocationValueListUnion::u32GetSize(tU16 u16MajorVersion) const
{
   return 1+(poValueListData?poValueListData->u32GetSize(u16MajorVersion):0);
}

tBool fi_tcl_LocationValueListUnion::operator==(const fi_tcl_LocationValueListUnion& rfoCmp) const
{
   tBool bResult = true;
   bResult = bResult && (ValueListType == rfoCmp.ValueListType);
   if (bResult && poValueListData && rfoCmp.poValueListData) 
   {
      switch (ValueListType.enType)
      {
      case fi_tcl_e8_LocationValueListType::FI_EN_T_RESERVED:
         bResult = bResult && (*(const fi_tcl_Reserved*)poValueListData == *(const fi_tcl_Reserved*)rfoCmp.poValueListData); //lint !e826
      break;
      case fi_tcl_e8_LocationValueListType::FI_EN_T_STRINGLIST:
         bResult = bResult && (*(const fi_tcl_StringList*)poValueListData == *(const fi_tcl_StringList*)rfoCmp.poValueListData); //lint !e826
      break;
      case fi_tcl_e8_LocationValueListType::FI_EN_T_STRINGDESCRIPTIONLIST:
         bResult = bResult && (*(const fi_tcl_StringDescriptionList*)poValueListData == *(const fi_tcl_StringDescriptionList*)rfoCmp.poValueListData); //lint !e826
      break;
      case fi_tcl_e8_LocationValueListType::FI_EN_T_STRINGIDLIST:
         bResult = bResult && (*(const fi_tcl_StringIDList*)poValueListData == *(const fi_tcl_StringIDList*)rfoCmp.poValueListData); //lint !e826
      break;
      case fi_tcl_e8_LocationValueListType::FI_EN_T_POSITIONWGS84LIST:
         bResult = bResult && (*(const fi_tcl_PositionWGS84List*)poValueListData == *(const fi_tcl_PositionWGS84List*)rfoCmp.poValueListData); //lint !e826
      break;
      case fi_tcl_e8_LocationValueListType::FI_EN_T_STRINGPOSITIONLIST:
         bResult = bResult && (*(const fi_tcl_StringPositionList*)poValueListData == *(const fi_tcl_StringPositionList*)rfoCmp.poValueListData); //lint !e826
      break;
      case fi_tcl_e8_LocationValueListType::FI_EN_T_STRINGPOSITIONDESCRIPTIONLIST:
         bResult = bResult && (*(const fi_tcl_StringPositionDescriptionList*)poValueListData == *(const fi_tcl_StringPositionDescriptionList*)rfoCmp.poValueListData); //lint !e826
      break;
      }
   }
   else
   {
      bResult = bResult && (poValueListData == rfoCmp.poValueListData);
   }
   return bResult;
}

fi_tclInContext& fi_tcl_LocationValueListUnion::oRead(fi_tclInContext& oIn)
{
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   OSAL_DELETE poValueListData;
#else
   if (poValueListData)
   {
      poValueListData->vDestroy();
      OSAL_DELETE poValueListData;
   }
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
   oIn >> ValueListType;
   switch(ValueListType.enType)
   {
   case fi_tcl_e8_LocationValueListType::FI_EN_T_RESERVED:
      poValueListData = OSAL_NEW fi_tcl_Reserved;
      break;
   case fi_tcl_e8_LocationValueListType::FI_EN_T_STRINGLIST:
      poValueListData = OSAL_NEW fi_tcl_StringList;
      break;
   case fi_tcl_e8_LocationValueListType::FI_EN_T_STRINGDESCRIPTIONLIST:
      poValueListData = OSAL_NEW fi_tcl_StringDescriptionList;
      break;
   case fi_tcl_e8_LocationValueListType::FI_EN_T_STRINGIDLIST:
      poValueListData = OSAL_NEW fi_tcl_StringIDList;
      break;
   case fi_tcl_e8_LocationValueListType::FI_EN_T_POSITIONWGS84LIST:
      poValueListData = OSAL_NEW fi_tcl_PositionWGS84List;
      break;
   case fi_tcl_e8_LocationValueListType::FI_EN_T_STRINGPOSITIONLIST:
      poValueListData = OSAL_NEW fi_tcl_StringPositionList;
      break;
   case fi_tcl_e8_LocationValueListType::FI_EN_T_STRINGPOSITIONDESCRIPTIONLIST:
      poValueListData = OSAL_NEW fi_tcl_StringPositionDescriptionList;
      break;
   default:
      oIn.Invalidate();
      poValueListData = OSAL_NULL;
   }
   if (poValueListData && oIn.bIsValid())
      poValueListData->oRead(oIn);
   else
      oIn.Invalidate();
   return oIn;
}

fi_tclOutContext& fi_tcl_LocationValueListUnion::oWrite(fi_tclOutContext& oOut) const
{
   oOut << ValueListType;
   if (poValueListData)
   {
      poValueListData->oWrite(oOut);
   }
   else
   {
      oOut.Invalidate();
   }
   return oOut;
}

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
fi_tcl_ListElement::fi_tcl_ListElement(const fi_tcl_ListElement& coRef):fi_tclVisitableTypeBase(coRef)
{
   Position = coRef.Position;
   Properties = coRef.Properties;
   Name = coRef.Name;
   Description = coRef.Description;
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
fi_tcl_ListElement& fi_tcl_ListElement::operator=(const fi_tcl_ListElement& coRef)
{
   if (this == &coRef) return *this;
   Position = coRef.Position;
   Properties = coRef.Properties;
   Name = coRef.Name;
   Description = coRef.Description;
   return *this;
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
tVoid fi_tcl_ListElement::vDestroy()
{
   Position.vDestroy(); 
   Name.vDestroy();
   Description.vDestroy();
}

tU32 fi_tcl_ListElement::u32GetSize(tU16 u16MajorVersion) const
{
   return 10+Name.u32GetSize(u16MajorVersion)+Description.u32GetSize(u16MajorVersion);
}

tBool fi_tcl_ListElement::operator==(const fi_tcl_ListElement& rfoCmp) const
{
   tBool bResult = true;
      bResult = bResult && (Position == rfoCmp.Position);
      bResult = bResult && (Properties == rfoCmp.Properties);
      bResult = bResult && (Name == rfoCmp.Name);
      bResult = bResult && (Description == rfoCmp.Description);
   return bResult;
}

fi_tclInContext& fi_tcl_ListElement::oRead(fi_tclInContext& oIn)
{
   oIn >> Position;
   oIn >> Properties;
   oIn >> Name;
   oIn >> Description;
   return oIn;
}

fi_tclOutContext& fi_tcl_ListElement::oWrite(fi_tclOutContext& oOut) const
{
   oOut << Position;
   oOut << Properties;
   oOut << Name;
   oOut << Description;
   return oOut;
}

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
fi_tcl_StringElement::fi_tcl_StringElement(const fi_tcl_StringElement& coRef):fi_tclVisitableTypeBase(coRef)
{
   Properties = coRef.Properties;
   String = coRef.String;
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
fi_tcl_StringElement& fi_tcl_StringElement::operator=(const fi_tcl_StringElement& coRef)
{
   if (this == &coRef) return *this;
   Properties = coRef.Properties;
   String = coRef.String;
   return *this;
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
tVoid fi_tcl_StringElement::vDestroy()
{
   String.vDestroy();
}

tU32 fi_tcl_StringElement::u32GetSize(tU16 u16MajorVersion) const
{
   return 2+String.u32GetSize(u16MajorVersion);
}

tBool fi_tcl_StringElement::operator==(const fi_tcl_StringElement& rfoCmp) const
{
   tBool bResult = true;
      bResult = bResult && (Properties == rfoCmp.Properties);
      bResult = bResult && (String == rfoCmp.String);
   return bResult;
}

fi_tclInContext& fi_tcl_StringElement::oRead(fi_tclInContext& oIn)
{
   oIn >> Properties;
   oIn >> String;
   return oIn;
}

fi_tclOutContext& fi_tcl_StringElement::oWrite(fi_tclOutContext& oOut) const
{
   oOut << Properties;
   oOut << String;
   return oOut;
}

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
fi_tcl_StringList::fi_tcl_StringList(const fi_tcl_StringList& coRef):fi_tclVisitableTypeBase(coRef)
{
   StringList = coRef.StringList;
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
fi_tcl_StringList& fi_tcl_StringList::operator=(const fi_tcl_StringList& coRef)
{
   if (this == &coRef) return *this;
   StringList = coRef.StringList;
   return *this;
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
tVoid fi_tcl_StringList::vDestroy()
{
   {
      for (tU32 u32Idx = 0; u32Idx < StringList.size(); ++u32Idx)
         StringList[u32Idx].vDestroy();
   }
   StringList.clear();
}

tU32 fi_tcl_StringList::u32GetSize(tU16 u16MajorVersion) const
{
   tU32 u32DynamicSize = 0;
   tU32 u32ListIdx;
   for (u32ListIdx = 0; u32ListIdx < StringList.size(); ++u32ListIdx)
      u32DynamicSize += StringList[u32ListIdx].u32GetSize(u16MajorVersion);
   return u32DynamicSize+4;
}

tBool fi_tcl_StringList::operator==(const fi_tcl_StringList& rfoCmp) const
{
   tBool bResult = true;
      bResult = bResult && (StringList.size() == rfoCmp.StringList.size());
      if (bResult)
      {
         for (tU32 u32Idx = 0; bResult && (u32Idx < StringList.size()); ++u32Idx)
            bResult = bResult && (StringList[u32Idx] == rfoCmp.StringList[u32Idx]);
      }
   return bResult;
}

fi_tclInContext& fi_tcl_StringList::oRead(fi_tclInContext& oIn)
{
   {
      tU32 u32Length;
      tU32 u32Idx;
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
      for (u32Idx = 0; u32Idx < StringList.size(); ++u32Idx)
      {
         StringList[u32Idx].vDestroy();
      }
#endif // !VARIANT_S_FTR_ENABLE_DEEP_COPY
      oIn >> u32Length;
      StringList.resize(u32Length);
      for (u32Idx = 0; u32Idx < u32Length; ++u32Idx)
      {
         oIn >> StringList[u32Idx];
      }
   }
   return oIn;
}

fi_tclOutContext& fi_tcl_StringList::oWrite(fi_tclOutContext& oOut) const
{
   oOut << (tU32)StringList.size();
   {
      for (tU32 u32Idx = 0; u32Idx < StringList.size(); ++u32Idx)
         oOut << StringList[u32Idx];
   }
   return oOut;
}

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
fi_tcl_StringDescriptionElement::fi_tcl_StringDescriptionElement(const fi_tcl_StringDescriptionElement& coRef):fi_tclVisitableTypeBase(coRef)
{
   Properties = coRef.Properties;
   ElementString = coRef.ElementString;
   DescriptionString = coRef.DescriptionString;
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
fi_tcl_StringDescriptionElement& fi_tcl_StringDescriptionElement::operator=(const fi_tcl_StringDescriptionElement& coRef)
{
   if (this == &coRef) return *this;
   Properties = coRef.Properties;
   ElementString = coRef.ElementString;
   DescriptionString = coRef.DescriptionString;
   return *this;
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
tVoid fi_tcl_StringDescriptionElement::vDestroy()
{
   ElementString.vDestroy();
   DescriptionString.vDestroy();
}

tU32 fi_tcl_StringDescriptionElement::u32GetSize(tU16 u16MajorVersion) const
{
   return 2+ElementString.u32GetSize(u16MajorVersion)+DescriptionString.u32GetSize(u16MajorVersion);
}

tBool fi_tcl_StringDescriptionElement::operator==(const fi_tcl_StringDescriptionElement& rfoCmp) const
{
   tBool bResult = true;
      bResult = bResult && (Properties == rfoCmp.Properties);
      bResult = bResult && (ElementString == rfoCmp.ElementString);
      bResult = bResult && (DescriptionString == rfoCmp.DescriptionString);
   return bResult;
}

fi_tclInContext& fi_tcl_StringDescriptionElement::oRead(fi_tclInContext& oIn)
{
   oIn >> Properties;
   oIn >> ElementString;
   oIn >> DescriptionString;
   return oIn;
}

fi_tclOutContext& fi_tcl_StringDescriptionElement::oWrite(fi_tclOutContext& oOut) const
{
   oOut << Properties;
   oOut << ElementString;
   oOut << DescriptionString;
   return oOut;
}

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
fi_tcl_StringDescriptionList::fi_tcl_StringDescriptionList(const fi_tcl_StringDescriptionList& coRef):fi_tclVisitableTypeBase(coRef)
{
   StringDescriptionList = coRef.StringDescriptionList;
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
fi_tcl_StringDescriptionList& fi_tcl_StringDescriptionList::operator=(const fi_tcl_StringDescriptionList& coRef)
{
   if (this == &coRef) return *this;
   StringDescriptionList = coRef.StringDescriptionList;
   return *this;
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
tVoid fi_tcl_StringDescriptionList::vDestroy()
{
   {
      for (tU32 u32Idx = 0; u32Idx < StringDescriptionList.size(); ++u32Idx)
         StringDescriptionList[u32Idx].vDestroy();
   }
   StringDescriptionList.clear();
}

tU32 fi_tcl_StringDescriptionList::u32GetSize(tU16 u16MajorVersion) const
{
   tU32 u32DynamicSize = 0;
   tU32 u32ListIdx;
   for (u32ListIdx = 0; u32ListIdx < StringDescriptionList.size(); ++u32ListIdx)
      u32DynamicSize += StringDescriptionList[u32ListIdx].u32GetSize(u16MajorVersion);
   return u32DynamicSize+4;
}

tBool fi_tcl_StringDescriptionList::operator==(const fi_tcl_StringDescriptionList& rfoCmp) const
{
   tBool bResult = true;
      bResult = bResult && (StringDescriptionList.size() == rfoCmp.StringDescriptionList.size());
      if (bResult)
      {
         for (tU32 u32Idx = 0; bResult && (u32Idx < StringDescriptionList.size()); ++u32Idx)
            bResult = bResult && (StringDescriptionList[u32Idx] == rfoCmp.StringDescriptionList[u32Idx]);
      }
   return bResult;
}

fi_tclInContext& fi_tcl_StringDescriptionList::oRead(fi_tclInContext& oIn)
{
   {
      tU32 u32Length;
      tU32 u32Idx;
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
      for (u32Idx = 0; u32Idx < StringDescriptionList.size(); ++u32Idx)
      {
         StringDescriptionList[u32Idx].vDestroy();
      }
#endif // !VARIANT_S_FTR_ENABLE_DEEP_COPY
      oIn >> u32Length;
      StringDescriptionList.resize(u32Length);
      for (u32Idx = 0; u32Idx < u32Length; ++u32Idx)
      {
         oIn >> StringDescriptionList[u32Idx];
      }
   }
   return oIn;
}

fi_tclOutContext& fi_tcl_StringDescriptionList::oWrite(fi_tclOutContext& oOut) const
{
   oOut << (tU32)StringDescriptionList.size();
   {
      for (tU32 u32Idx = 0; u32Idx < StringDescriptionList.size(); ++u32Idx)
         oOut << StringDescriptionList[u32Idx];
   }
   return oOut;
}

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
fi_tcl_StringID::fi_tcl_StringID(const fi_tcl_StringID& coRef):fi_tclVisitableTypeBase(coRef)
{
   String = coRef.String;
   ID = coRef.ID;
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
fi_tcl_StringID& fi_tcl_StringID::operator=(const fi_tcl_StringID& coRef)
{
   if (this == &coRef) return *this;
   String = coRef.String;
   ID = coRef.ID;
   return *this;
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
tVoid fi_tcl_StringID::vDestroy()
{
   String.vDestroy();
}

tU32 fi_tcl_StringID::u32GetSize(tU16 u16MajorVersion) const
{
   return 4+String.u32GetSize(u16MajorVersion);
}

tBool fi_tcl_StringID::operator==(const fi_tcl_StringID& rfoCmp) const
{
   tBool bResult = true;
      bResult = bResult && (String == rfoCmp.String);
      bResult = bResult && (ID == rfoCmp.ID);
   return bResult;
}

fi_tclInContext& fi_tcl_StringID::oRead(fi_tclInContext& oIn)
{
   oIn >> String;
   oIn >> ID;
   return oIn;
}

fi_tclOutContext& fi_tcl_StringID::oWrite(fi_tclOutContext& oOut) const
{
   oOut << String;
   oOut << ID;
   return oOut;
}

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
fi_tcl_StringIDElement::fi_tcl_StringIDElement(const fi_tcl_StringIDElement& coRef):fi_tclVisitableTypeBase(coRef)
{
   Properties = coRef.Properties;
   StringID = coRef.StringID;
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
fi_tcl_StringIDElement& fi_tcl_StringIDElement::operator=(const fi_tcl_StringIDElement& coRef)
{
   if (this == &coRef) return *this;
   Properties = coRef.Properties;
   StringID = coRef.StringID;
   return *this;
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
tVoid fi_tcl_StringIDElement::vDestroy()
{
   StringID.vDestroy(); 
}

tU32 fi_tcl_StringIDElement::u32GetSize(tU16 u16MajorVersion) const
{
   return 2+StringID.u32GetSize(u16MajorVersion);
}

tBool fi_tcl_StringIDElement::operator==(const fi_tcl_StringIDElement& rfoCmp) const
{
   tBool bResult = true;
      bResult = bResult && (Properties == rfoCmp.Properties);
      bResult = bResult && (StringID == rfoCmp.StringID);
   return bResult;
}

fi_tclInContext& fi_tcl_StringIDElement::oRead(fi_tclInContext& oIn)
{
   oIn >> Properties;
   oIn >> StringID;
   return oIn;
}

fi_tclOutContext& fi_tcl_StringIDElement::oWrite(fi_tclOutContext& oOut) const
{
   oOut << Properties;
   oOut << StringID;
   return oOut;
}

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
fi_tcl_PositionWGS84Element::fi_tcl_PositionWGS84Element(const fi_tcl_PositionWGS84Element& coRef):fi_tclVisitableTypeBase(coRef)
{
   Properties = coRef.Properties;
   PositionWGS84 = coRef.PositionWGS84;
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
fi_tcl_PositionWGS84Element& fi_tcl_PositionWGS84Element::operator=(const fi_tcl_PositionWGS84Element& coRef)
{
   if (this == &coRef) return *this;
   Properties = coRef.Properties;
   PositionWGS84 = coRef.PositionWGS84;
   return *this;
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
tVoid fi_tcl_PositionWGS84Element::vDestroy()
{
   PositionWGS84.vDestroy(); 
}

tU32 fi_tcl_PositionWGS84Element::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 10;
}

tBool fi_tcl_PositionWGS84Element::operator==(const fi_tcl_PositionWGS84Element& rfoCmp) const
{
   tBool bResult = true;
      bResult = bResult && (Properties == rfoCmp.Properties);
      bResult = bResult && (PositionWGS84 == rfoCmp.PositionWGS84);
   return bResult;
}

fi_tclInContext& fi_tcl_PositionWGS84Element::oRead(fi_tclInContext& oIn)
{
   oIn >> Properties;
   oIn >> PositionWGS84;
   return oIn;
}

fi_tclOutContext& fi_tcl_PositionWGS84Element::oWrite(fi_tclOutContext& oOut) const
{
   oOut << Properties;
   oOut << PositionWGS84;
   return oOut;
}

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
fi_tcl_PositionWGS84List::fi_tcl_PositionWGS84List(const fi_tcl_PositionWGS84List& coRef):fi_tclVisitableTypeBase(coRef)
{
   PositionWGS84List = coRef.PositionWGS84List;
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
fi_tcl_PositionWGS84List& fi_tcl_PositionWGS84List::operator=(const fi_tcl_PositionWGS84List& coRef)
{
   if (this == &coRef) return *this;
   PositionWGS84List = coRef.PositionWGS84List;
   return *this;
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
tVoid fi_tcl_PositionWGS84List::vDestroy()
{
   {
      for (tU32 u32Idx = 0; u32Idx < PositionWGS84List.size(); ++u32Idx)
         PositionWGS84List[u32Idx].vDestroy();
   }
   PositionWGS84List.clear();
}

tU32 fi_tcl_PositionWGS84List::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 4+PositionWGS84List.size()*10;
}

tBool fi_tcl_PositionWGS84List::operator==(const fi_tcl_PositionWGS84List& rfoCmp) const
{
   tBool bResult = true;
      bResult = bResult && (PositionWGS84List.size() == rfoCmp.PositionWGS84List.size());
      if (bResult)
      {
         for (tU32 u32Idx = 0; bResult && (u32Idx < PositionWGS84List.size()); ++u32Idx)
            bResult = bResult && (PositionWGS84List[u32Idx] == rfoCmp.PositionWGS84List[u32Idx]);
      }
   return bResult;
}

fi_tclInContext& fi_tcl_PositionWGS84List::oRead(fi_tclInContext& oIn)
{
   {
      tU32 u32Length;
      tU32 u32Idx;
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
      for (u32Idx = 0; u32Idx < PositionWGS84List.size(); ++u32Idx)
      {
         PositionWGS84List[u32Idx].vDestroy();
      }
#endif // !VARIANT_S_FTR_ENABLE_DEEP_COPY
      oIn >> u32Length;
      PositionWGS84List.resize(u32Length);
      for (u32Idx = 0; u32Idx < u32Length; ++u32Idx)
      {
         oIn >> PositionWGS84List[u32Idx];
      }
   }
   return oIn;
}

fi_tclOutContext& fi_tcl_PositionWGS84List::oWrite(fi_tclOutContext& oOut) const
{
   oOut << (tU32)PositionWGS84List.size();
   {
      for (tU32 u32Idx = 0; u32Idx < PositionWGS84List.size(); ++u32Idx)
         oOut << PositionWGS84List[u32Idx];
   }
   return oOut;
}

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
fi_tcl_StringPosition::fi_tcl_StringPosition(const fi_tcl_StringPosition& coRef):fi_tclVisitableTypeBase(coRef)
{
   String = coRef.String;
   Position = coRef.Position;
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
fi_tcl_StringPosition& fi_tcl_StringPosition::operator=(const fi_tcl_StringPosition& coRef)
{
   if (this == &coRef) return *this;
   String = coRef.String;
   Position = coRef.Position;
   return *this;
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
tVoid fi_tcl_StringPosition::vDestroy()
{
   String.vDestroy();
   Position.vDestroy(); 
}

tU32 fi_tcl_StringPosition::u32GetSize(tU16 u16MajorVersion) const
{
   return 8+String.u32GetSize(u16MajorVersion);
}

tBool fi_tcl_StringPosition::operator==(const fi_tcl_StringPosition& rfoCmp) const
{
   tBool bResult = true;
      bResult = bResult && (String == rfoCmp.String);
      bResult = bResult && (Position == rfoCmp.Position);
   return bResult;
}

fi_tclInContext& fi_tcl_StringPosition::oRead(fi_tclInContext& oIn)
{
   oIn >> String;
   oIn >> Position;
   return oIn;
}

fi_tclOutContext& fi_tcl_StringPosition::oWrite(fi_tclOutContext& oOut) const
{
   oOut << String;
   oOut << Position;
   return oOut;
}

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
fi_tcl_StringPositionElement::fi_tcl_StringPositionElement(const fi_tcl_StringPositionElement& coRef):fi_tclVisitableTypeBase(coRef)
{
   Properties = coRef.Properties;
   StringPosition = coRef.StringPosition;
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
fi_tcl_StringPositionElement& fi_tcl_StringPositionElement::operator=(const fi_tcl_StringPositionElement& coRef)
{
   if (this == &coRef) return *this;
   Properties = coRef.Properties;
   StringPosition = coRef.StringPosition;
   return *this;
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
tVoid fi_tcl_StringPositionElement::vDestroy()
{
   StringPosition.vDestroy(); 
}

tU32 fi_tcl_StringPositionElement::u32GetSize(tU16 u16MajorVersion) const
{
   return 2+StringPosition.u32GetSize(u16MajorVersion);
}

tBool fi_tcl_StringPositionElement::operator==(const fi_tcl_StringPositionElement& rfoCmp) const
{
   tBool bResult = true;
      bResult = bResult && (Properties == rfoCmp.Properties);
      bResult = bResult && (StringPosition == rfoCmp.StringPosition);
   return bResult;
}

fi_tclInContext& fi_tcl_StringPositionElement::oRead(fi_tclInContext& oIn)
{
   oIn >> Properties;
   oIn >> StringPosition;
   return oIn;
}

fi_tclOutContext& fi_tcl_StringPositionElement::oWrite(fi_tclOutContext& oOut) const
{
   oOut << Properties;
   oOut << StringPosition;
   return oOut;
}

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
fi_tcl_StringPositionDescriptionElement::fi_tcl_StringPositionDescriptionElement(const fi_tcl_StringPositionDescriptionElement& coRef):fi_tclVisitableTypeBase(coRef)
{
   Properties = coRef.Properties;
   ElementStringPosition = coRef.ElementStringPosition;
   DescriptionString = coRef.DescriptionString;
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
fi_tcl_StringPositionDescriptionElement& fi_tcl_StringPositionDescriptionElement::operator=(const fi_tcl_StringPositionDescriptionElement& coRef)
{
   if (this == &coRef) return *this;
   Properties = coRef.Properties;
   ElementStringPosition = coRef.ElementStringPosition;
   DescriptionString = coRef.DescriptionString;
   return *this;
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
tVoid fi_tcl_StringPositionDescriptionElement::vDestroy()
{
   ElementStringPosition.vDestroy(); 
   DescriptionString.vDestroy();
}

tU32 fi_tcl_StringPositionDescriptionElement::u32GetSize(tU16 u16MajorVersion) const
{
   return 2+ElementStringPosition.u32GetSize(u16MajorVersion)+DescriptionString.u32GetSize(u16MajorVersion);
}

tBool fi_tcl_StringPositionDescriptionElement::operator==(const fi_tcl_StringPositionDescriptionElement& rfoCmp) const
{
   tBool bResult = true;
      bResult = bResult && (Properties == rfoCmp.Properties);
      bResult = bResult && (ElementStringPosition == rfoCmp.ElementStringPosition);
      bResult = bResult && (DescriptionString == rfoCmp.DescriptionString);
   return bResult;
}

fi_tclInContext& fi_tcl_StringPositionDescriptionElement::oRead(fi_tclInContext& oIn)
{
   oIn >> Properties;
   oIn >> ElementStringPosition;
   oIn >> DescriptionString;
   return oIn;
}

fi_tclOutContext& fi_tcl_StringPositionDescriptionElement::oWrite(fi_tclOutContext& oOut) const
{
   oOut << Properties;
   oOut << ElementStringPosition;
   oOut << DescriptionString;
   return oOut;
}

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
fi_tcl_StringPositionDescriptionList::fi_tcl_StringPositionDescriptionList(const fi_tcl_StringPositionDescriptionList& coRef):fi_tclVisitableTypeBase(coRef)
{
   StringPositionDescriptionList = coRef.StringPositionDescriptionList;
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
fi_tcl_StringPositionDescriptionList& fi_tcl_StringPositionDescriptionList::operator=(const fi_tcl_StringPositionDescriptionList& coRef)
{
   if (this == &coRef) return *this;
   StringPositionDescriptionList = coRef.StringPositionDescriptionList;
   return *this;
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
tVoid fi_tcl_StringPositionDescriptionList::vDestroy()
{
   {
      for (tU32 u32Idx = 0; u32Idx < StringPositionDescriptionList.size(); ++u32Idx)
         StringPositionDescriptionList[u32Idx].vDestroy();
   }
   StringPositionDescriptionList.clear();
}

tU32 fi_tcl_StringPositionDescriptionList::u32GetSize(tU16 u16MajorVersion) const
{
   tU32 u32DynamicSize = 0;
   tU32 u32ListIdx;
   for (u32ListIdx = 0; u32ListIdx < StringPositionDescriptionList.size(); ++u32ListIdx)
      u32DynamicSize += StringPositionDescriptionList[u32ListIdx].u32GetSize(u16MajorVersion);
   return u32DynamicSize+4;
}

tBool fi_tcl_StringPositionDescriptionList::operator==(const fi_tcl_StringPositionDescriptionList& rfoCmp) const
{
   tBool bResult = true;
      bResult = bResult && (StringPositionDescriptionList.size() == rfoCmp.StringPositionDescriptionList.size());
      if (bResult)
      {
         for (tU32 u32Idx = 0; bResult && (u32Idx < StringPositionDescriptionList.size()); ++u32Idx)
            bResult = bResult && (StringPositionDescriptionList[u32Idx] == rfoCmp.StringPositionDescriptionList[u32Idx]);
      }
   return bResult;
}

fi_tclInContext& fi_tcl_StringPositionDescriptionList::oRead(fi_tclInContext& oIn)
{
   {
      tU32 u32Length;
      tU32 u32Idx;
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
      for (u32Idx = 0; u32Idx < StringPositionDescriptionList.size(); ++u32Idx)
      {
         StringPositionDescriptionList[u32Idx].vDestroy();
      }
#endif // !VARIANT_S_FTR_ENABLE_DEEP_COPY
      oIn >> u32Length;
      StringPositionDescriptionList.resize(u32Length);
      for (u32Idx = 0; u32Idx < u32Length; ++u32Idx)
      {
         oIn >> StringPositionDescriptionList[u32Idx];
      }
   }
   return oIn;
}

fi_tclOutContext& fi_tcl_StringPositionDescriptionList::oWrite(fi_tclOutContext& oOut) const
{
   oOut << (tU32)StringPositionDescriptionList.size();
   {
      for (tU32 u32Idx = 0; u32Idx < StringPositionDescriptionList.size(); ++u32Idx)
         oOut << StringPositionDescriptionList[u32Idx];
   }
   return oOut;
}

tU32 fi_tcl_b8_ListSortOptions::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 1;
}

tBool fi_tcl_b8_ListSortOptions::operator==(const fi_tcl_b8_ListSortOptions& rfoCmp) const
{
   return u8Value == rfoCmp.u8Value;
}

fi_tclInContext& fi_tcl_b8_ListSortOptions::oRead(fi_tclInContext& oIn)
{
   return oIn >> u8Value;
}

fi_tclOutContext& fi_tcl_b8_ListSortOptions::oWrite(fi_tclOutContext& oOut) const
{
   return oOut << u8Value;
}

tU32 fi_tcl_e8_LocationDescriptionDataType::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 1;
}

tBool fi_tcl_e8_LocationDescriptionDataType::operator==(const fi_tcl_e8_LocationDescriptionDataType& rfoCmp) const
{
   return enType == rfoCmp.enType;
}

fi_tclInContext& fi_tcl_e8_LocationDescriptionDataType::oRead(fi_tclInContext& oIn)
{
   tU8 u8Value;
   oIn >> u8Value;
   enType = (tenType)u8Value;
   return oIn;
}

fi_tclOutContext& fi_tcl_e8_LocationDescriptionDataType::oWrite(fi_tclOutContext& oOut) const
{
   fi_tcl_e8_LocationDescriptionDataType::tenType enData = enType;
   if ((enData == FI_EN_T_LISTOFPOSITIONS) && !(17 <= oOut.u16GetMajorVersion()))
   {
      enData = FI_EN_T_RESERVED;
   }
   if ((enData == FI_EN_T_FLISTRING) && !(11 <= oOut.u16GetMajorVersion()))
   {
      enData = FI_EN_T_RESERVED;
   }
   return oOut.oWrite((tU8)enData);
}

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
fi_tcl_SelectionCriterionDescription::fi_tcl_SelectionCriterionDescription(const fi_tcl_SelectionCriterionDescription& coRef):fi_tclVisitableTypeBase(coRef)
{
   SelectionCriterion = coRef.SelectionCriterion;
   Description = coRef.Description;
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
fi_tcl_SelectionCriterionDescription& fi_tcl_SelectionCriterionDescription::operator=(const fi_tcl_SelectionCriterionDescription& coRef)
{
   if (this == &coRef) return *this;
   SelectionCriterion = coRef.SelectionCriterion;
   Description = coRef.Description;
   return *this;
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
tVoid fi_tcl_SelectionCriterionDescription::vDestroy()
{
   Description.vDestroy();
}

tU32 fi_tcl_SelectionCriterionDescription::u32GetSize(tU16 u16MajorVersion) const
{
   return 2+Description.u32GetSize(u16MajorVersion);
}

tBool fi_tcl_SelectionCriterionDescription::operator==(const fi_tcl_SelectionCriterionDescription& rfoCmp) const
{
   tBool bResult = true;
      bResult = bResult && (SelectionCriterion == rfoCmp.SelectionCriterion);
      bResult = bResult && (Description == rfoCmp.Description);
   return bResult;
}

fi_tclInContext& fi_tcl_SelectionCriterionDescription::oRead(fi_tclInContext& oIn)
{
   oIn >> SelectionCriterion;
   oIn >> Description;
   return oIn;
}

fi_tclOutContext& fi_tcl_SelectionCriterionDescription::oWrite(fi_tclOutContext& oOut) const
{
   oOut << SelectionCriterion;
   oOut << Description;
   return oOut;
}

tU32 fi_tcl_b8_CriteriaGetOptions::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 1;
}

tBool fi_tcl_b8_CriteriaGetOptions::operator==(const fi_tcl_b8_CriteriaGetOptions& rfoCmp) const
{
   return u8Value == rfoCmp.u8Value;
}

fi_tclInContext& fi_tcl_b8_CriteriaGetOptions::oRead(fi_tclInContext& oIn)
{
   return oIn >> u8Value;
}

fi_tclOutContext& fi_tcl_b8_CriteriaGetOptions::oWrite(fi_tclOutContext& oOut) const
{
   return oOut << u8Value;
}

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
fi_tcl_DAPISelectableCriterion::fi_tcl_DAPISelectableCriterion(const fi_tcl_DAPISelectableCriterion& coRef):fi_tclVisitableTypeBase(coRef)
{
   SelectionCriterion = coRef.SelectionCriterion;
   DataType = coRef.DataType;
   SortOption = coRef.SortOption;
   AttributesAvailable = coRef.AttributesAvailable;
   Description = coRef.Description;
   Status = coRef.Status;
   NumOfPOI = coRef.NumOfPOI;
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
fi_tcl_DAPISelectableCriterion& fi_tcl_DAPISelectableCriterion::operator=(const fi_tcl_DAPISelectableCriterion& coRef)
{
   if (this == &coRef) return *this;
   SelectionCriterion = coRef.SelectionCriterion;
   DataType = coRef.DataType;
   SortOption = coRef.SortOption;
   AttributesAvailable = coRef.AttributesAvailable;
   Description = coRef.Description;
   Status = coRef.Status;
   NumOfPOI = coRef.NumOfPOI;
   return *this;
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
tVoid fi_tcl_DAPISelectableCriterion::vDestroy()
{
   Description.vDestroy();
}

tU32 fi_tcl_DAPISelectableCriterion::u32GetSize(tU16 u16MajorVersion) const
{
   tU32 u32DynamicSize = 0;
   if (13 <= u16MajorVersion)
   {
      u32DynamicSize += 1;
   }
   if (19 <= u16MajorVersion)
   {
      u32DynamicSize += 2;
   }
   return u32DynamicSize+5+Description.u32GetSize(u16MajorVersion);
}

tBool fi_tcl_DAPISelectableCriterion::operator==(const fi_tcl_DAPISelectableCriterion& rfoCmp) const
{
   tBool bResult = true;
      bResult = bResult && (SelectionCriterion == rfoCmp.SelectionCriterion);
      bResult = bResult && (DataType == rfoCmp.DataType);
      bResult = bResult && (SortOption == rfoCmp.SortOption);
      bResult = bResult && (AttributesAvailable == rfoCmp.AttributesAvailable);
      bResult = bResult && (Description == rfoCmp.Description);
      bResult = bResult && (Status == rfoCmp.Status);
      bResult = bResult && (NumOfPOI == rfoCmp.NumOfPOI);
   return bResult;
}

fi_tclInContext& fi_tcl_DAPISelectableCriterion::oRead(fi_tclInContext& oIn)
{
   oIn >> SelectionCriterion;
   oIn >> DataType;
   oIn >> SortOption;
   oIn >> AttributesAvailable;
   oIn >> Description;
   if (13 <= oIn.u16GetMajorVersion())
   {
      oIn >> Status;
   }
   if (19 <= oIn.u16GetMajorVersion())
   {
      oIn >> NumOfPOI;
   }
   return oIn;
}

fi_tclOutContext& fi_tcl_DAPISelectableCriterion::oWrite(fi_tclOutContext& oOut) const
{
   oOut << SelectionCriterion;
   oOut << DataType;
   oOut << SortOption;
   oOut << AttributesAvailable;
   oOut << Description;
   if (13 <= oOut.u16GetMajorVersion())
   {
      oOut << Status;
   }
   if (19 <= oOut.u16GetMajorVersion())
   {
      oOut << NumOfPOI;
   }
   return oOut;
}

tU32 fi_tcl_e8_TransformMode::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 1;
}

tBool fi_tcl_e8_TransformMode::operator==(const fi_tcl_e8_TransformMode& rfoCmp) const
{
   return enType == rfoCmp.enType;
}

fi_tclInContext& fi_tcl_e8_TransformMode::oRead(fi_tclInContext& oIn)
{
   tU8 u8Value;
   oIn >> u8Value;
   enType = (tenType)u8Value;
   return oIn;
}

fi_tclOutContext& fi_tcl_e8_TransformMode::oWrite(fi_tclOutContext& oOut) const
{
   fi_tcl_e8_TransformMode::tenType enData = enType;
   if ((enData == FI_EN_ASSIGNADDRESSPARTS) && !(19 <= oOut.u16GetMajorVersion()))
   {
      enData = FI_EN_GETNAVINFO;
   }
   if ((enData == FI_EN_GETADDRESSINFOFORPOSITION) && !(15 <= oOut.u16GetMajorVersion()))
   {
      enData = FI_EN_RESOLVENAMEANDGETNAVINFO;
   }
   if ((enData == FI_EN_GETEDITABLEADDRESSFORPOSITION) && !(15 <= oOut.u16GetMajorVersion()))
   {
      enData = FI_EN_RESOLVENAMEANDGETNAVINFO;
   }
   return oOut.oWrite((tU8)enData);
}

tU32 fi_tcl_b8_LocationDescriptorStatus::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 1;
}

tBool fi_tcl_b8_LocationDescriptorStatus::operator==(const fi_tcl_b8_LocationDescriptorStatus& rfoCmp) const
{
   return u8Value == rfoCmp.u8Value;
}

fi_tclInContext& fi_tcl_b8_LocationDescriptorStatus::oRead(fi_tclInContext& oIn)
{
   return oIn >> u8Value;
}

fi_tclOutContext& fi_tcl_b8_LocationDescriptorStatus::oWrite(fi_tclOutContext& oOut) const
{
   return oOut << u8Value;
}

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
fi_tcl_LocationDescriptor::fi_tcl_LocationDescriptor(const fi_tcl_LocationDescriptor& coRef):fi_tclVisitableTypeBase(coRef)
{
   SelectionCriterion = coRef.SelectionCriterion;
   DataType = coRef.DataType;
   if  (coRef.poDataData)
   {
      switch(DataType.enType)
      {
      case fi_tcl_e8_LocationDescriptionDataType::FI_EN_T_RESERVED:
         poDataData = OSAL_NEW fi_tcl_Reserved((const fi_tcl_Reserved&)*coRef.poDataData);
         break;
      case fi_tcl_e8_LocationDescriptionDataType::FI_EN_TSTRING:
         poDataData = OSAL_NEW fi_tclString((const fi_tclString&)*coRef.poDataData);
         break;
      case fi_tcl_e8_LocationDescriptionDataType::FI_EN_T_STRINGID:
         poDataData = OSAL_NEW fi_tcl_StringID((const fi_tcl_StringID&)*coRef.poDataData);
         break;
      case fi_tcl_e8_LocationDescriptionDataType::FI_EN_T_POSITIONHEADINGSPEED:
         poDataData = OSAL_NEW fi_tcl_PositionHeadingSpeed((const fi_tcl_PositionHeadingSpeed&)*coRef.poDataData);
         break;
      case fi_tcl_e8_LocationDescriptionDataType::FI_EN_T_POSITIONWGS84:
         poDataData = OSAL_NEW fi_tcl_PositionWGS84((const fi_tcl_PositionWGS84&)*coRef.poDataData);
         break;
      case fi_tcl_e8_LocationDescriptionDataType::FI_EN_T_NAVLOCATIONBINCONTAINER:
         if (coRef.poDataData->s32GetTypeId() == (tS32)typesfi_tclToken::EN_NAVLOCATIONBINCONTAINER)
         {
            poDataData = OSAL_NEW fi_tcl_NavLocationBinContainer((const fi_tcl_NavLocationBinContainer&)*coRef.poDataData);
         }
         else
         {
            poDataData = OSAL_NEW fi_tcl_BinContainer((const fi_tcl_BinContainer&)*coRef.poDataData);
         }
         break;
      case fi_tcl_e8_LocationDescriptionDataType::FI_EN_T_STRINGPOSITION:
         poDataData = OSAL_NEW fi_tcl_StringPosition((const fi_tcl_StringPosition&)*coRef.poDataData);
         break;
      case fi_tcl_e8_LocationDescriptionDataType::FI_EN_T_FLISTRING:
         poDataData = OSAL_NEW fi_tcl_FLIString((const fi_tcl_FLIString&)*coRef.poDataData);
         break;
      case fi_tcl_e8_LocationDescriptionDataType::FI_EN_T_LISTOFPOSITIONS:
         poDataData = OSAL_NEW fi_tcl_ListOfPositions((const fi_tcl_ListOfPositions&)*coRef.poDataData);
         break;
      default:
         poDataData = OSAL_NULL;
      }
   }
   else
   {
      poDataData = OSAL_NULL;
   }
   Status = coRef.Status;
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
fi_tcl_LocationDescriptor& fi_tcl_LocationDescriptor::operator=(const fi_tcl_LocationDescriptor& coRef)
{
   if (this == &coRef) return *this;
   SelectionCriterion = coRef.SelectionCriterion;
   OSAL_DELETE poDataData;
   DataType = coRef.DataType;
   if  (coRef.poDataData)
   {
      switch(DataType.enType)
      {
      case fi_tcl_e8_LocationDescriptionDataType::FI_EN_T_RESERVED:
         poDataData = OSAL_NEW fi_tcl_Reserved((const fi_tcl_Reserved&)*coRef.poDataData);
         break;
      case fi_tcl_e8_LocationDescriptionDataType::FI_EN_TSTRING:
         poDataData = OSAL_NEW fi_tclString((const fi_tclString&)*coRef.poDataData);
         break;
      case fi_tcl_e8_LocationDescriptionDataType::FI_EN_T_STRINGID:
         poDataData = OSAL_NEW fi_tcl_StringID((const fi_tcl_StringID&)*coRef.poDataData);
         break;
      case fi_tcl_e8_LocationDescriptionDataType::FI_EN_T_POSITIONHEADINGSPEED:
         poDataData = OSAL_NEW fi_tcl_PositionHeadingSpeed((const fi_tcl_PositionHeadingSpeed&)*coRef.poDataData);
         break;
      case fi_tcl_e8_LocationDescriptionDataType::FI_EN_T_POSITIONWGS84:
         poDataData = OSAL_NEW fi_tcl_PositionWGS84((const fi_tcl_PositionWGS84&)*coRef.poDataData);
         break;
      case fi_tcl_e8_LocationDescriptionDataType::FI_EN_T_NAVLOCATIONBINCONTAINER:
         if (coRef.poDataData->s32GetTypeId() == (tS32)typesfi_tclToken::EN_NAVLOCATIONBINCONTAINER)
         {
            poDataData = OSAL_NEW fi_tcl_NavLocationBinContainer((const fi_tcl_NavLocationBinContainer&)*coRef.poDataData);
         }
         else
         {
            poDataData = OSAL_NEW fi_tcl_BinContainer((const fi_tcl_BinContainer&)*coRef.poDataData);
         }
         break;
      case fi_tcl_e8_LocationDescriptionDataType::FI_EN_T_STRINGPOSITION:
         poDataData = OSAL_NEW fi_tcl_StringPosition((const fi_tcl_StringPosition&)*coRef.poDataData);
         break;
      case fi_tcl_e8_LocationDescriptionDataType::FI_EN_T_FLISTRING:
         poDataData = OSAL_NEW fi_tcl_FLIString((const fi_tcl_FLIString&)*coRef.poDataData);
         break;
      case fi_tcl_e8_LocationDescriptionDataType::FI_EN_T_LISTOFPOSITIONS:
         poDataData = OSAL_NEW fi_tcl_ListOfPositions((const fi_tcl_ListOfPositions&)*coRef.poDataData);
         break;
      default:
         poDataData = OSAL_NULL;
      }
   }
   else
   {
      poDataData = OSAL_NULL;
   }
   Status = coRef.Status;
   return *this;
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
fi_tcl_LocationDescriptor::~fi_tcl_LocationDescriptor()
{
   OSAL_DELETE poDataData;
   poDataData = OSAL_NULL;
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
tVoid fi_tcl_LocationDescriptor::vDestroy()
{
   if (poDataData)
   {
      poDataData->vDestroy();
      OSAL_DELETE poDataData;
      poDataData = OSAL_NULL;
   }
}

tU32 fi_tcl_LocationDescriptor::u32GetSize(tU16 u16MajorVersion) const
{
   tU32 u32DynamicSize = 0;
   if (DataType.enType == fi_tcl_e8_LocationDescriptionDataType::FI_EN_T_RESERVED)
      u32DynamicSize += (poDataData?poDataData->u32GetSize(u16MajorVersion):0);
   if (DataType.enType == fi_tcl_e8_LocationDescriptionDataType::FI_EN_TSTRING)
      u32DynamicSize += (poDataData?poDataData->u32GetSize(u16MajorVersion):0);
   if (DataType.enType == fi_tcl_e8_LocationDescriptionDataType::FI_EN_T_STRINGID)
      u32DynamicSize += (poDataData?poDataData->u32GetSize(u16MajorVersion):0);
   if (DataType.enType == fi_tcl_e8_LocationDescriptionDataType::FI_EN_T_POSITIONHEADINGSPEED)
      u32DynamicSize += (poDataData?poDataData->u32GetSize(u16MajorVersion):0);
   if (DataType.enType == fi_tcl_e8_LocationDescriptionDataType::FI_EN_T_POSITIONWGS84)
      u32DynamicSize += (poDataData?poDataData->u32GetSize(u16MajorVersion):0);
   if (DataType.enType == fi_tcl_e8_LocationDescriptionDataType::FI_EN_T_NAVLOCATIONBINCONTAINER)
      u32DynamicSize += (poDataData?poDataData->u32GetSize(u16MajorVersion):0);
   if (DataType.enType == fi_tcl_e8_LocationDescriptionDataType::FI_EN_T_STRINGPOSITION)
      u32DynamicSize += (poDataData?poDataData->u32GetSize(u16MajorVersion):0);
   if ((DataType.enType == fi_tcl_e8_LocationDescriptionDataType::FI_EN_T_FLISTRING) &&
       (11 <= u16MajorVersion))
      u32DynamicSize += (poDataData?poDataData->u32GetSize(u16MajorVersion):0);
   if ((DataType.enType == fi_tcl_e8_LocationDescriptionDataType::FI_EN_T_LISTOFPOSITIONS) &&
       (17 <= u16MajorVersion))
      u32DynamicSize += (poDataData?poDataData->u32GetSize(u16MajorVersion):0);
   if (25 <= u16MajorVersion)
   {
      u32DynamicSize += 1;
   }
   return u32DynamicSize+3;
}

tBool fi_tcl_LocationDescriptor::operator==(const fi_tcl_LocationDescriptor& rfoCmp) const
{
   tBool bResult = true;
      bResult = bResult && (SelectionCriterion == rfoCmp.SelectionCriterion);
   bResult = bResult && (DataType == rfoCmp.DataType);
   if (bResult && poDataData && rfoCmp.poDataData) 
   {
      switch (DataType.enType)
      {
      case fi_tcl_e8_LocationDescriptionDataType::FI_EN_T_RESERVED:
         bResult = bResult && (*(const fi_tcl_Reserved*)poDataData == *(const fi_tcl_Reserved*)rfoCmp.poDataData); //lint !e826
      break;
      case fi_tcl_e8_LocationDescriptionDataType::FI_EN_TSTRING:
         bResult = bResult && (*(const fi_tclString*)poDataData == *(const fi_tclString*)rfoCmp.poDataData); //lint !e826
      break;
      case fi_tcl_e8_LocationDescriptionDataType::FI_EN_T_STRINGID:
         bResult = bResult && (*(const fi_tcl_StringID*)poDataData == *(const fi_tcl_StringID*)rfoCmp.poDataData); //lint !e826
      break;
      case fi_tcl_e8_LocationDescriptionDataType::FI_EN_T_POSITIONHEADINGSPEED:
         bResult = bResult && (*(const fi_tcl_PositionHeadingSpeed*)poDataData == *(const fi_tcl_PositionHeadingSpeed*)rfoCmp.poDataData); //lint !e826
      break;
      case fi_tcl_e8_LocationDescriptionDataType::FI_EN_T_POSITIONWGS84:
         bResult = bResult && (*(const fi_tcl_PositionWGS84*)poDataData == *(const fi_tcl_PositionWGS84*)rfoCmp.poDataData); //lint !e826
      break;
      case fi_tcl_e8_LocationDescriptionDataType::FI_EN_T_NAVLOCATIONBINCONTAINER:
         bResult = bResult && (*(const fi_tcl_BinContainer*)poDataData == *(const fi_tcl_BinContainer*)rfoCmp.poDataData); //lint !e826
      break;
      case fi_tcl_e8_LocationDescriptionDataType::FI_EN_T_STRINGPOSITION:
         bResult = bResult && (*(const fi_tcl_StringPosition*)poDataData == *(const fi_tcl_StringPosition*)rfoCmp.poDataData); //lint !e826
      break;
      case fi_tcl_e8_LocationDescriptionDataType::FI_EN_T_FLISTRING:
         bResult = bResult && (*(const fi_tcl_FLIString*)poDataData == *(const fi_tcl_FLIString*)rfoCmp.poDataData); //lint !e826
      break;
      case fi_tcl_e8_LocationDescriptionDataType::FI_EN_T_LISTOFPOSITIONS:
         bResult = bResult && (*(const fi_tcl_ListOfPositions*)poDataData == *(const fi_tcl_ListOfPositions*)rfoCmp.poDataData); //lint !e826
      break;
      }
   }
   else
   {
      bResult = bResult && (poDataData == rfoCmp.poDataData);
   }
      bResult = bResult && (Status == rfoCmp.Status);
   return bResult;
}

fi_tclInContext& fi_tcl_LocationDescriptor::oRead(fi_tclInContext& oIn)
{
   oIn >> SelectionCriterion;
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   OSAL_DELETE poDataData;
#else
   if (poDataData)
   {
      poDataData->vDestroy();
      OSAL_DELETE poDataData;
   }
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
   oIn >> DataType;
   switch(DataType.enType)
   {
   case fi_tcl_e8_LocationDescriptionDataType::FI_EN_T_RESERVED:
      poDataData = OSAL_NEW fi_tcl_Reserved;
      break;
   case fi_tcl_e8_LocationDescriptionDataType::FI_EN_TSTRING:
      poDataData = OSAL_NEW fi_tclString;
      break;
   case fi_tcl_e8_LocationDescriptionDataType::FI_EN_T_STRINGID:
      poDataData = OSAL_NEW fi_tcl_StringID;
      break;
   case fi_tcl_e8_LocationDescriptionDataType::FI_EN_T_POSITIONHEADINGSPEED:
      poDataData = OSAL_NEW fi_tcl_PositionHeadingSpeed;
      break;
   case fi_tcl_e8_LocationDescriptionDataType::FI_EN_T_POSITIONWGS84:
      poDataData = OSAL_NEW fi_tcl_PositionWGS84;
      break;
   case fi_tcl_e8_LocationDescriptionDataType::FI_EN_T_NAVLOCATIONBINCONTAINER:
      poDataData = OSAL_NEW fi_tcl_BinContainer;
      break;
   case fi_tcl_e8_LocationDescriptionDataType::FI_EN_T_STRINGPOSITION:
      poDataData = OSAL_NEW fi_tcl_StringPosition;
      break;
   case fi_tcl_e8_LocationDescriptionDataType::FI_EN_T_FLISTRING:
      poDataData = OSAL_NEW fi_tcl_FLIString;
      break;
   case fi_tcl_e8_LocationDescriptionDataType::FI_EN_T_LISTOFPOSITIONS:
      poDataData = OSAL_NEW fi_tcl_ListOfPositions;
      break;
   default:
      oIn.Invalidate();
      poDataData = OSAL_NULL;
   }
   if (poDataData && oIn.bIsValid())
      poDataData->oRead(oIn);
   else
      oIn.Invalidate();
   if (25 <= oIn.u16GetMajorVersion())
   {
      oIn >> Status;
   }
   return oIn;
}

fi_tclOutContext& fi_tcl_LocationDescriptor::oWrite(fi_tclOutContext& oOut) const
{
   oOut << SelectionCriterion;
   oOut << DataType;
   if (poDataData)
   {
      if (DataType.enType == fi_tcl_e8_LocationDescriptionDataType::FI_EN_T_RESERVED)
      {
         poDataData->oWrite(oOut);
      }
      if (DataType.enType == fi_tcl_e8_LocationDescriptionDataType::FI_EN_TSTRING)
      {
         poDataData->oWrite(oOut);
      }
      if (DataType.enType == fi_tcl_e8_LocationDescriptionDataType::FI_EN_T_STRINGID)
      {
         poDataData->oWrite(oOut);
      }
      if (DataType.enType == fi_tcl_e8_LocationDescriptionDataType::FI_EN_T_POSITIONHEADINGSPEED)
      {
         poDataData->oWrite(oOut);
      }
      if (DataType.enType == fi_tcl_e8_LocationDescriptionDataType::FI_EN_T_POSITIONWGS84)
      {
         poDataData->oWrite(oOut);
      }
      if (DataType.enType == fi_tcl_e8_LocationDescriptionDataType::FI_EN_T_NAVLOCATIONBINCONTAINER)
      {
         poDataData->oWrite(oOut);
      }
      if (DataType.enType == fi_tcl_e8_LocationDescriptionDataType::FI_EN_T_STRINGPOSITION)
      {
         poDataData->oWrite(oOut);
      }
      if (DataType.enType == fi_tcl_e8_LocationDescriptionDataType::FI_EN_T_FLISTRING)
      {
         if (!(11 <= oOut.u16GetMajorVersion()))
         {
            fi_tcl_Reserved oDefault;
            oOut << oDefault;
         }
         else
         {
            poDataData->oWrite(oOut);
         }
      }
      if (DataType.enType == fi_tcl_e8_LocationDescriptionDataType::FI_EN_T_LISTOFPOSITIONS)
      {
         if (!(17 <= oOut.u16GetMajorVersion()))
         {
            fi_tcl_Reserved oDefault;
            oOut << oDefault;
         }
         else
         {
            poDataData->oWrite(oOut);
         }
      }
   }
   else
   {
      oOut.Invalidate();
   }
   if (25 <= oOut.u16GetMajorVersion())
   {
      oOut << Status;
   }
   return oOut;
}

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
fi_tcl_SelectableCriterion::fi_tcl_SelectableCriterion(const fi_tcl_SelectableCriterion& coRef):fi_tclVisitableTypeBase(coRef)
{
   SelectionCriterion = coRef.SelectionCriterion;
   DataType = coRef.DataType;
   SortOption = coRef.SortOption;
   AttributesAvailable = coRef.AttributesAvailable;
   Status = coRef.Status;
   NumOfPOI = coRef.NumOfPOI;
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
fi_tcl_SelectableCriterion& fi_tcl_SelectableCriterion::operator=(const fi_tcl_SelectableCriterion& coRef)
{
   if (this == &coRef) return *this;
   SelectionCriterion = coRef.SelectionCriterion;
   DataType = coRef.DataType;
   SortOption = coRef.SortOption;
   AttributesAvailable = coRef.AttributesAvailable;
   Status = coRef.Status;
   NumOfPOI = coRef.NumOfPOI;
   return *this;
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
tU32 fi_tcl_SelectableCriterion::u32GetSize(tU16 u16MajorVersion) const
{
   tU32 u32DynamicSize = 0;
   if (13 <= u16MajorVersion)
   {
      u32DynamicSize += 1;
   }
   if (19 <= u16MajorVersion)
   {
      u32DynamicSize += 2;
   }
   return u32DynamicSize+5;
}

tBool fi_tcl_SelectableCriterion::operator==(const fi_tcl_SelectableCriterion& rfoCmp) const
{
   tBool bResult = true;
      bResult = bResult && (SelectionCriterion == rfoCmp.SelectionCriterion);
      bResult = bResult && (DataType == rfoCmp.DataType);
      bResult = bResult && (SortOption == rfoCmp.SortOption);
      bResult = bResult && (AttributesAvailable == rfoCmp.AttributesAvailable);
      bResult = bResult && (Status == rfoCmp.Status);
      bResult = bResult && (NumOfPOI == rfoCmp.NumOfPOI);
   return bResult;
}

fi_tclInContext& fi_tcl_SelectableCriterion::oRead(fi_tclInContext& oIn)
{
   oIn >> SelectionCriterion;
   oIn >> DataType;
   oIn >> SortOption;
   oIn >> AttributesAvailable;
   if (13 <= oIn.u16GetMajorVersion())
   {
      oIn >> Status;
   }
   if (19 <= oIn.u16GetMajorVersion())
   {
      oIn >> NumOfPOI;
   }
   return oIn;
}

fi_tclOutContext& fi_tcl_SelectableCriterion::oWrite(fi_tclOutContext& oOut) const
{
   oOut << SelectionCriterion;
   oOut << DataType;
   oOut << SortOption;
   oOut << AttributesAvailable;
   if (13 <= oOut.u16GetMajorVersion())
   {
      oOut << Status;
   }
   if (19 <= oOut.u16GetMajorVersion())
   {
      oOut << NumOfPOI;
   }
   return oOut;
}

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
fi_tcl_LocationDescription::fi_tcl_LocationDescription(const fi_tcl_LocationDescription& coRef):fi_tclVisitableTypeBase(coRef)
{
   Descriptors = coRef.Descriptors;
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
fi_tcl_LocationDescription& fi_tcl_LocationDescription::operator=(const fi_tcl_LocationDescription& coRef)
{
   if (this == &coRef) return *this;
   Descriptors = coRef.Descriptors;
   return *this;
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
tVoid fi_tcl_LocationDescription::vDestroy()
{
   {
      for (tU32 u32Idx = 0; u32Idx < Descriptors.size(); ++u32Idx)
         Descriptors[u32Idx].vDestroy();
   }
   Descriptors.clear();
}

tU32 fi_tcl_LocationDescription::u32GetSize(tU16 u16MajorVersion) const
{
   tU32 u32DynamicSize = 0;
   tU32 u32ListIdx;
   for (u32ListIdx = 0; u32ListIdx < Descriptors.size(); ++u32ListIdx)
      u32DynamicSize += Descriptors[u32ListIdx].u32GetSize(u16MajorVersion);
   return u32DynamicSize+4;
}

tBool fi_tcl_LocationDescription::operator==(const fi_tcl_LocationDescription& rfoCmp) const
{
   tBool bResult = true;
      bResult = bResult && (Descriptors.size() == rfoCmp.Descriptors.size());
      if (bResult)
      {
         for (tU32 u32Idx = 0; bResult && (u32Idx < Descriptors.size()); ++u32Idx)
            bResult = bResult && (Descriptors[u32Idx] == rfoCmp.Descriptors[u32Idx]);
      }
   return bResult;
}

fi_tclInContext& fi_tcl_LocationDescription::oRead(fi_tclInContext& oIn)
{
   {
      tU32 u32Length;
      tU32 u32Idx;
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
      for (u32Idx = 0; u32Idx < Descriptors.size(); ++u32Idx)
      {
         Descriptors[u32Idx].vDestroy();
      }
#endif // !VARIANT_S_FTR_ENABLE_DEEP_COPY
      oIn >> u32Length;
      Descriptors.resize(u32Length);
      for (u32Idx = 0; u32Idx < u32Length; ++u32Idx)
      {
         oIn >> Descriptors[u32Idx];
      }
   }
   return oIn;
}

fi_tclOutContext& fi_tcl_LocationDescription::oWrite(fi_tclOutContext& oOut) const
{
   oOut << (tU32)Descriptors.size();
   {
      for (tU32 u32Idx = 0; u32Idx < Descriptors.size(); ++u32Idx)
         oOut << Descriptors[u32Idx];
   }
   return oOut;
}

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
fi_tcl_StringPositionList::fi_tcl_StringPositionList(const fi_tcl_StringPositionList& coRef):fi_tclVisitableTypeBase(coRef)
{
   StringPositionList = coRef.StringPositionList;
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
fi_tcl_StringPositionList& fi_tcl_StringPositionList::operator=(const fi_tcl_StringPositionList& coRef)
{
   if (this == &coRef) return *this;
   StringPositionList = coRef.StringPositionList;
   return *this;
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
tVoid fi_tcl_StringPositionList::vDestroy()
{
   {
      for (tU32 u32Idx = 0; u32Idx < StringPositionList.size(); ++u32Idx)
         StringPositionList[u32Idx].vDestroy();
   }
   StringPositionList.clear();
}

tU32 fi_tcl_StringPositionList::u32GetSize(tU16 u16MajorVersion) const
{
   tU32 u32DynamicSize = 0;
   tU32 u32ListIdx;
   for (u32ListIdx = 0; u32ListIdx < StringPositionList.size(); ++u32ListIdx)
      u32DynamicSize += StringPositionList[u32ListIdx].u32GetSize(u16MajorVersion);
   return u32DynamicSize+4;
}

tBool fi_tcl_StringPositionList::operator==(const fi_tcl_StringPositionList& rfoCmp) const
{
   tBool bResult = true;
      bResult = bResult && (StringPositionList.size() == rfoCmp.StringPositionList.size());
      if (bResult)
      {
         for (tU32 u32Idx = 0; bResult && (u32Idx < StringPositionList.size()); ++u32Idx)
            bResult = bResult && (StringPositionList[u32Idx] == rfoCmp.StringPositionList[u32Idx]);
      }
   return bResult;
}

fi_tclInContext& fi_tcl_StringPositionList::oRead(fi_tclInContext& oIn)
{
   {
      tU32 u32Length;
      tU32 u32Idx;
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
      for (u32Idx = 0; u32Idx < StringPositionList.size(); ++u32Idx)
      {
         StringPositionList[u32Idx].vDestroy();
      }
#endif // !VARIANT_S_FTR_ENABLE_DEEP_COPY
      oIn >> u32Length;
      StringPositionList.resize(u32Length);
      for (u32Idx = 0; u32Idx < u32Length; ++u32Idx)
      {
         oIn >> StringPositionList[u32Idx];
      }
   }
   return oIn;
}

fi_tclOutContext& fi_tcl_StringPositionList::oWrite(fi_tclOutContext& oOut) const
{
   oOut << (tU32)StringPositionList.size();
   {
      for (tU32 u32Idx = 0; u32Idx < StringPositionList.size(); ++u32Idx)
         oOut << StringPositionList[u32Idx];
   }
   return oOut;
}

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
fi_tcl_StringIDList::fi_tcl_StringIDList(const fi_tcl_StringIDList& coRef):fi_tclVisitableTypeBase(coRef)
{
   StringIDList = coRef.StringIDList;
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
fi_tcl_StringIDList& fi_tcl_StringIDList::operator=(const fi_tcl_StringIDList& coRef)
{
   if (this == &coRef) return *this;
   StringIDList = coRef.StringIDList;
   return *this;
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
tVoid fi_tcl_StringIDList::vDestroy()
{
   {
      for (tU32 u32Idx = 0; u32Idx < StringIDList.size(); ++u32Idx)
         StringIDList[u32Idx].vDestroy();
   }
   StringIDList.clear();
}

tU32 fi_tcl_StringIDList::u32GetSize(tU16 u16MajorVersion) const
{
   tU32 u32DynamicSize = 0;
   tU32 u32ListIdx;
   for (u32ListIdx = 0; u32ListIdx < StringIDList.size(); ++u32ListIdx)
      u32DynamicSize += StringIDList[u32ListIdx].u32GetSize(u16MajorVersion);
   return u32DynamicSize+4;
}

tBool fi_tcl_StringIDList::operator==(const fi_tcl_StringIDList& rfoCmp) const
{
   tBool bResult = true;
      bResult = bResult && (StringIDList.size() == rfoCmp.StringIDList.size());
      if (bResult)
      {
         for (tU32 u32Idx = 0; bResult && (u32Idx < StringIDList.size()); ++u32Idx)
            bResult = bResult && (StringIDList[u32Idx] == rfoCmp.StringIDList[u32Idx]);
      }
   return bResult;
}

fi_tclInContext& fi_tcl_StringIDList::oRead(fi_tclInContext& oIn)
{
   {
      tU32 u32Length;
      tU32 u32Idx;
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
      for (u32Idx = 0; u32Idx < StringIDList.size(); ++u32Idx)
      {
         StringIDList[u32Idx].vDestroy();
      }
#endif // !VARIANT_S_FTR_ENABLE_DEEP_COPY
      oIn >> u32Length;
      StringIDList.resize(u32Length);
      for (u32Idx = 0; u32Idx < u32Length; ++u32Idx)
      {
         oIn >> StringIDList[u32Idx];
      }
   }
   return oIn;
}

fi_tclOutContext& fi_tcl_StringIDList::oWrite(fi_tclOutContext& oOut) const
{
   oOut << (tU32)StringIDList.size();
   {
      for (tU32 u32Idx = 0; u32Idx < StringIDList.size(); ++u32Idx)
         oOut << StringIDList[u32Idx];
   }
   return oOut;
}

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
fi_tcl_FLIString::fi_tcl_FLIString(const fi_tcl_FLIString& coRef):fi_tclVisitableTypeBase(coRef)
{
   String = coRef.String;
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
fi_tcl_FLIString& fi_tcl_FLIString::operator=(const fi_tcl_FLIString& coRef)
{
   if (this == &coRef) return *this;
   String = coRef.String;
   return *this;
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
tVoid fi_tcl_FLIString::vDestroy()
{
   String.vDestroy();
}

tU32 fi_tcl_FLIString::u32GetSize(tU16 u16MajorVersion) const
{
   return 0+String.u32GetSize(u16MajorVersion);
}

tBool fi_tcl_FLIString::operator==(const fi_tcl_FLIString& rfoCmp) const
{
   tBool bResult = true;
      bResult = bResult && (String == rfoCmp.String);
   return bResult;
}

fi_tclInContext& fi_tcl_FLIString::oRead(fi_tclInContext& oIn)
{
   oIn >> String;
   return oIn;
}

fi_tclOutContext& fi_tcl_FLIString::oWrite(fi_tclOutContext& oOut) const
{
   oOut << String;
   return oOut;
}

tU32 fi_tcl_b8_PositionStatus::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 1;
}

tBool fi_tcl_b8_PositionStatus::operator==(const fi_tcl_b8_PositionStatus& rfoCmp) const
{
   return u8Value == rfoCmp.u8Value;
}

fi_tclInContext& fi_tcl_b8_PositionStatus::oRead(fi_tclInContext& oIn)
{
   return oIn >> u8Value;
}

fi_tclOutContext& fi_tcl_b8_PositionStatus::oWrite(fi_tclOutContext& oOut) const
{
   return oOut << u8Value;
}

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
fi_tcl_ListOfPositions::fi_tcl_ListOfPositions(const fi_tcl_ListOfPositions& coRef):fi_tclVisitableTypeBase(coRef)
{
   Positions = coRef.Positions;
   PositionStati = coRef.PositionStati;
   ID = coRef.ID;
   CurrentPosition = coRef.CurrentPosition;
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
fi_tcl_ListOfPositions& fi_tcl_ListOfPositions::operator=(const fi_tcl_ListOfPositions& coRef)
{
   if (this == &coRef) return *this;
   Positions = coRef.Positions;
   PositionStati = coRef.PositionStati;
   ID = coRef.ID;
   CurrentPosition = coRef.CurrentPosition;
   return *this;
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
tVoid fi_tcl_ListOfPositions::vDestroy()
{
   {
      for (tU32 u32Idx = 0; u32Idx < Positions.size(); ++u32Idx)
         Positions[u32Idx].vDestroy();
   }
   Positions.clear();
   PositionStati.clear();
   CurrentPosition.vDestroy(); 
}

tU32 fi_tcl_ListOfPositions::u32GetSize(tU16 u16MajorVersion) const
{
   tU32 u32DynamicSize = 0;
   if (26 <= u16MajorVersion)
   {
      u32DynamicSize += 4;
      u32DynamicSize += PositionStati.size()*1;
   }
   return u32DynamicSize+16+Positions.size()*8;
}

tBool fi_tcl_ListOfPositions::operator==(const fi_tcl_ListOfPositions& rfoCmp) const
{
   tBool bResult = true;
      bResult = bResult && (Positions.size() == rfoCmp.Positions.size());
      if (bResult)
      {
         for (tU32 u32Idx = 0; bResult && (u32Idx < Positions.size()); ++u32Idx)
            bResult = bResult && (Positions[u32Idx] == rfoCmp.Positions[u32Idx]);
      }
      bResult = bResult && (PositionStati.size() == rfoCmp.PositionStati.size());
      if (bResult)
      {
         for (tU32 u32Idx = 0; bResult && (u32Idx < PositionStati.size()); ++u32Idx)
            bResult = bResult && (PositionStati[u32Idx] == rfoCmp.PositionStati[u32Idx]);
      }
      bResult = bResult && (ID == rfoCmp.ID);
      bResult = bResult && (CurrentPosition == rfoCmp.CurrentPosition);
   return bResult;
}

fi_tclInContext& fi_tcl_ListOfPositions::oRead(fi_tclInContext& oIn)
{
   {
      tU32 u32Length;
      tU32 u32Idx;
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
      for (u32Idx = 0; u32Idx < Positions.size(); ++u32Idx)
      {
         Positions[u32Idx].vDestroy();
      }
#endif // !VARIANT_S_FTR_ENABLE_DEEP_COPY
      oIn >> u32Length;
      Positions.resize(u32Length);
      for (u32Idx = 0; u32Idx < u32Length; ++u32Idx)
      {
         oIn >> Positions[u32Idx];
      }
   }
   if (26 <= oIn.u16GetMajorVersion())
   {
      {
         tU32 u32Length;
         tU32 u32Idx;
         oIn >> u32Length;
         PositionStati.resize(u32Length);
         for (u32Idx = 0; u32Idx < u32Length; ++u32Idx)
         {
            oIn >> PositionStati[u32Idx];
         }
      }
   }
   oIn >> ID;
   oIn >> CurrentPosition;
   return oIn;
}

fi_tclOutContext& fi_tcl_ListOfPositions::oWrite(fi_tclOutContext& oOut) const
{
   oOut << (tU32)Positions.size();
   {
      for (tU32 u32Idx = 0; u32Idx < Positions.size(); ++u32Idx)
         oOut << Positions[u32Idx];
   }
   if (26 <= oOut.u16GetMajorVersion())
   {
      oOut << (tU32)PositionStati.size();
      {
         for (tU32 u32Idx = 0; u32Idx < PositionStati.size(); ++u32Idx)
            oOut << PositionStati[u32Idx];
      }
   }
   oOut << ID;
   oOut << CurrentPosition;
   return oOut;
}

tU32 fi_tcl_e8_MapDataLevel::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 1;
}

tBool fi_tcl_e8_MapDataLevel::operator==(const fi_tcl_e8_MapDataLevel& rfoCmp) const
{
   return enType == rfoCmp.enType;
}

fi_tclInContext& fi_tcl_e8_MapDataLevel::oRead(fi_tclInContext& oIn)
{
   tU8 u8Value;
   oIn >> u8Value;
   enType = (tenType)u8Value;
   return oIn;
}

fi_tclOutContext& fi_tcl_e8_MapDataLevel::oWrite(fi_tclOutContext& oOut) const
{
   return oOut.oWrite((tU8)enType);
}

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
fi_tcl_MapCoordinates::fi_tcl_MapCoordinates(const fi_tcl_MapCoordinates& coRef):fi_tclVisitableTypeBase(coRef)
{
   Coordinates = coRef.Coordinates;
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
fi_tcl_MapCoordinates& fi_tcl_MapCoordinates::operator=(const fi_tcl_MapCoordinates& coRef)
{
   if (this == &coRef) return *this;
   Coordinates = coRef.Coordinates;
   return *this;
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
tVoid fi_tcl_MapCoordinates::vDestroy()
{
   {
      for (tU32 u32Idx = 0; u32Idx < Coordinates.size(); ++u32Idx)
         Coordinates[u32Idx].vDestroy();
   }
   Coordinates.clear();
}

tU32 fi_tcl_MapCoordinates::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 4+Coordinates.size()*8;
}

tBool fi_tcl_MapCoordinates::operator==(const fi_tcl_MapCoordinates& rfoCmp) const
{
   tBool bResult = true;
      bResult = bResult && (Coordinates.size() == rfoCmp.Coordinates.size());
      if (bResult)
      {
         for (tU32 u32Idx = 0; bResult && (u32Idx < Coordinates.size()); ++u32Idx)
            bResult = bResult && (Coordinates[u32Idx] == rfoCmp.Coordinates[u32Idx]);
      }
   return bResult;
}

fi_tclInContext& fi_tcl_MapCoordinates::oRead(fi_tclInContext& oIn)
{
   {
      tU32 u32Length;
      tU32 u32Idx;
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
      for (u32Idx = 0; u32Idx < Coordinates.size(); ++u32Idx)
      {
         Coordinates[u32Idx].vDestroy();
      }
#endif // !VARIANT_S_FTR_ENABLE_DEEP_COPY
      oIn >> u32Length;
      Coordinates.resize(u32Length);
      for (u32Idx = 0; u32Idx < u32Length; ++u32Idx)
      {
         oIn >> Coordinates[u32Idx];
      }
   }
   return oIn;
}

fi_tclOutContext& fi_tcl_MapCoordinates::oWrite(fi_tclOutContext& oOut) const
{
   oOut << (tU32)Coordinates.size();
   {
      for (tU32 u32Idx = 0; u32Idx < Coordinates.size(); ++u32Idx)
         oOut << Coordinates[u32Idx];
   }
   return oOut;
}

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
fi_tcl_RelativeCoord_8Bit::fi_tcl_RelativeCoord_8Bit(const fi_tcl_RelativeCoord_8Bit& coRef):fi_tclVisitableTypeBase(coRef)
{
   s8_RelativeLongitude = coRef.s8_RelativeLongitude;
   s8_RelativeLatitude = coRef.s8_RelativeLatitude;
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
fi_tcl_RelativeCoord_8Bit& fi_tcl_RelativeCoord_8Bit::operator=(const fi_tcl_RelativeCoord_8Bit& coRef)
{
   if (this == &coRef) return *this;
   s8_RelativeLongitude = coRef.s8_RelativeLongitude;
   s8_RelativeLatitude = coRef.s8_RelativeLatitude;
   return *this;
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
tU32 fi_tcl_RelativeCoord_8Bit::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 2;
}

tBool fi_tcl_RelativeCoord_8Bit::operator==(const fi_tcl_RelativeCoord_8Bit& rfoCmp) const
{
   tBool bResult = true;
      bResult = bResult && (s8_RelativeLongitude == rfoCmp.s8_RelativeLongitude);
      bResult = bResult && (s8_RelativeLatitude == rfoCmp.s8_RelativeLatitude);
   return bResult;
}

fi_tclInContext& fi_tcl_RelativeCoord_8Bit::oRead(fi_tclInContext& oIn)
{
   oIn >> s8_RelativeLongitude;
   oIn >> s8_RelativeLatitude;
   return oIn;
}

fi_tclOutContext& fi_tcl_RelativeCoord_8Bit::oWrite(fi_tclOutContext& oOut) const
{
   oOut << s8_RelativeLongitude;
   oOut << s8_RelativeLatitude;
   return oOut;
}

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
fi_tcl_RelativeCoord_16Bit::fi_tcl_RelativeCoord_16Bit(const fi_tcl_RelativeCoord_16Bit& coRef):fi_tclVisitableTypeBase(coRef)
{
   s16_RelativeLongitude = coRef.s16_RelativeLongitude;
   s16_RelativeLatitude = coRef.s16_RelativeLatitude;
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
fi_tcl_RelativeCoord_16Bit& fi_tcl_RelativeCoord_16Bit::operator=(const fi_tcl_RelativeCoord_16Bit& coRef)
{
   if (this == &coRef) return *this;
   s16_RelativeLongitude = coRef.s16_RelativeLongitude;
   s16_RelativeLatitude = coRef.s16_RelativeLatitude;
   return *this;
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
tU32 fi_tcl_RelativeCoord_16Bit::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 4;
}

tBool fi_tcl_RelativeCoord_16Bit::operator==(const fi_tcl_RelativeCoord_16Bit& rfoCmp) const
{
   tBool bResult = true;
      bResult = bResult && (s16_RelativeLongitude == rfoCmp.s16_RelativeLongitude);
      bResult = bResult && (s16_RelativeLatitude == rfoCmp.s16_RelativeLatitude);
   return bResult;
}

fi_tclInContext& fi_tcl_RelativeCoord_16Bit::oRead(fi_tclInContext& oIn)
{
   oIn >> s16_RelativeLongitude;
   oIn >> s16_RelativeLatitude;
   return oIn;
}

fi_tclOutContext& fi_tcl_RelativeCoord_16Bit::oWrite(fi_tclOutContext& oOut) const
{
   oOut << s16_RelativeLongitude;
   oOut << s16_RelativeLatitude;
   return oOut;
}

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
fi_tcl_RelativeCoord_24Bit::fi_tcl_RelativeCoord_24Bit(const fi_tcl_RelativeCoord_24Bit& coRef):fi_tclVisitableTypeBase(coRef)
{
   s24_RelativeLongitude = coRef.s24_RelativeLongitude;
   s24_RelativeLatitude = coRef.s24_RelativeLatitude;
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
fi_tcl_RelativeCoord_24Bit& fi_tcl_RelativeCoord_24Bit::operator=(const fi_tcl_RelativeCoord_24Bit& coRef)
{
   if (this == &coRef) return *this;
   s24_RelativeLongitude = coRef.s24_RelativeLongitude;
   s24_RelativeLatitude = coRef.s24_RelativeLatitude;
   return *this;
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
tU32 fi_tcl_RelativeCoord_24Bit::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 6;
}

tBool fi_tcl_RelativeCoord_24Bit::operator==(const fi_tcl_RelativeCoord_24Bit& rfoCmp) const
{
   tBool bResult = true;
      bResult = bResult && (s24_RelativeLongitude == rfoCmp.s24_RelativeLongitude);
      bResult = bResult && (s24_RelativeLatitude == rfoCmp.s24_RelativeLatitude);
   return bResult;
}

fi_tclInContext& fi_tcl_RelativeCoord_24Bit::oRead(fi_tclInContext& oIn)
{
   oIn >> s24_RelativeLongitude;
   oIn >> s24_RelativeLatitude;
   return oIn;
}

fi_tclOutContext& fi_tcl_RelativeCoord_24Bit::oWrite(fi_tclOutContext& oOut) const
{
   oOut << s24_RelativeLongitude;
   oOut << s24_RelativeLatitude;
   return oOut;
}

tU32 fi_tcl_s16_Longitude::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 2;
}

tBool fi_tcl_s16_Longitude::operator==(const fi_tcl_s16_Longitude& rfoCmp) const
{
   return s16Value == rfoCmp.s16Value;
}

fi_tclInContext& fi_tcl_s16_Longitude::oRead(fi_tclInContext& oIn)
{
   return oIn >> s16Value;
}

fi_tclOutContext& fi_tcl_s16_Longitude::oWrite(fi_tclOutContext& oOut) const
{
   return oOut << s16Value;
}

tU32 fi_tcl_s16_Latitude::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 2;
}

tBool fi_tcl_s16_Latitude::operator==(const fi_tcl_s16_Latitude& rfoCmp) const
{
   return s16Value == rfoCmp.s16Value;
}

fi_tclInContext& fi_tcl_s16_Latitude::oRead(fi_tclInContext& oIn)
{
   return oIn >> s16Value;
}

fi_tclOutContext& fi_tcl_s16_Latitude::oWrite(fi_tclOutContext& oOut) const
{
   return oOut << s16Value;
}

tU32 fi_tcl_s24_Longitude::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 3;
}

tBool fi_tcl_s24_Longitude::operator==(const fi_tcl_s24_Longitude& rfoCmp) const
{
   return s24Value == rfoCmp.s24Value;
}

fi_tclInContext& fi_tcl_s24_Longitude::oRead(fi_tclInContext& oIn)
{
   return oIn >> s24Value;
}

fi_tclOutContext& fi_tcl_s24_Longitude::oWrite(fi_tclOutContext& oOut) const
{
   return oOut << s24Value;
}

tU32 fi_tcl_s24_Latitude::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 3;
}

tBool fi_tcl_s24_Latitude::operator==(const fi_tcl_s24_Latitude& rfoCmp) const
{
   return s24Value == rfoCmp.s24Value;
}

fi_tclInContext& fi_tcl_s24_Latitude::oRead(fi_tclInContext& oIn)
{
   return oIn >> s24Value;
}

fi_tclOutContext& fi_tcl_s24_Latitude::oWrite(fi_tclOutContext& oOut) const
{
   return oOut << s24Value;
}

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
fi_tcl_PositionWGS84_16Bit::fi_tcl_PositionWGS84_16Bit(const fi_tcl_PositionWGS84_16Bit& coRef):fi_tclVisitableTypeBase(coRef)
{
   Longitude = coRef.Longitude;
   Latitude = coRef.Latitude;
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
fi_tcl_PositionWGS84_16Bit& fi_tcl_PositionWGS84_16Bit::operator=(const fi_tcl_PositionWGS84_16Bit& coRef)
{
   if (this == &coRef) return *this;
   Longitude = coRef.Longitude;
   Latitude = coRef.Latitude;
   return *this;
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
tU32 fi_tcl_PositionWGS84_16Bit::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 4;
}

tBool fi_tcl_PositionWGS84_16Bit::operator==(const fi_tcl_PositionWGS84_16Bit& rfoCmp) const
{
   tBool bResult = true;
      bResult = bResult && (Longitude == rfoCmp.Longitude);
      bResult = bResult && (Latitude == rfoCmp.Latitude);
   return bResult;
}

fi_tclInContext& fi_tcl_PositionWGS84_16Bit::oRead(fi_tclInContext& oIn)
{
   oIn >> Longitude;
   oIn >> Latitude;
   return oIn;
}

fi_tclOutContext& fi_tcl_PositionWGS84_16Bit::oWrite(fi_tclOutContext& oOut) const
{
   oOut << Longitude;
   oOut << Latitude;
   return oOut;
}

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
fi_tcl_PositionWGS84_24Bit::fi_tcl_PositionWGS84_24Bit(const fi_tcl_PositionWGS84_24Bit& coRef):fi_tclVisitableTypeBase(coRef)
{
   Longitude = coRef.Longitude;
   Latitude = coRef.Latitude;
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
fi_tcl_PositionWGS84_24Bit& fi_tcl_PositionWGS84_24Bit::operator=(const fi_tcl_PositionWGS84_24Bit& coRef)
{
   if (this == &coRef) return *this;
   Longitude = coRef.Longitude;
   Latitude = coRef.Latitude;
   return *this;
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
tU32 fi_tcl_PositionWGS84_24Bit::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 6;
}

tBool fi_tcl_PositionWGS84_24Bit::operator==(const fi_tcl_PositionWGS84_24Bit& rfoCmp) const
{
   tBool bResult = true;
      bResult = bResult && (Longitude == rfoCmp.Longitude);
      bResult = bResult && (Latitude == rfoCmp.Latitude);
   return bResult;
}

fi_tclInContext& fi_tcl_PositionWGS84_24Bit::oRead(fi_tclInContext& oIn)
{
   oIn >> Longitude;
   oIn >> Latitude;
   return oIn;
}

fi_tclOutContext& fi_tcl_PositionWGS84_24Bit::oWrite(fi_tclOutContext& oOut) const
{
   oOut << Longitude;
   oOut << Latitude;
   return oOut;
}

tU32 fi_tcl_e8_CoordCode::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 1;
}

tBool fi_tcl_e8_CoordCode::operator==(const fi_tcl_e8_CoordCode& rfoCmp) const
{
   return enType == rfoCmp.enType;
}

fi_tclInContext& fi_tcl_e8_CoordCode::oRead(fi_tclInContext& oIn)
{
   tU8 u8Value;
   oIn >> u8Value;
   enType = (tenType)u8Value;
   return oIn;
}

fi_tclOutContext& fi_tcl_e8_CoordCode::oWrite(fi_tclOutContext& oOut) const
{
   return oOut.oWrite((tU8)enType);
}

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
fi_tcl_CodedCoord::fi_tcl_CodedCoord(const fi_tcl_CodedCoord& coRef):fi_tclVisitableTypeBase(coRef)
{
   CodedCoordinateType = coRef.CodedCoordinateType;
   if  (coRef.poCodedCoordinateData)
   {
      switch(CodedCoordinateType.enType)
      {
      case fi_tcl_e8_CoordCode::FI_EN_T_RESERVED:
         poCodedCoordinateData = OSAL_NEW fi_tcl_Reserved((const fi_tcl_Reserved&)*coRef.poCodedCoordinateData);
         break;
      case fi_tcl_e8_CoordCode::FI_EN_T_POSITIONWGS84:
         poCodedCoordinateData = OSAL_NEW fi_tcl_PositionWGS84((const fi_tcl_PositionWGS84&)*coRef.poCodedCoordinateData);
         break;
      case fi_tcl_e8_CoordCode::FI_EN_T_POSITIONWGS84_24BIT:
         poCodedCoordinateData = OSAL_NEW fi_tcl_PositionWGS84_24Bit((const fi_tcl_PositionWGS84_24Bit&)*coRef.poCodedCoordinateData);
         break;
      case fi_tcl_e8_CoordCode::FI_EN_T_POSITIONWGS84_16BIT:
         poCodedCoordinateData = OSAL_NEW fi_tcl_PositionWGS84_16Bit((const fi_tcl_PositionWGS84_16Bit&)*coRef.poCodedCoordinateData);
         break;
      case fi_tcl_e8_CoordCode::FI_EN_T_RELATIVECOORD_24BIT:
         poCodedCoordinateData = OSAL_NEW fi_tcl_RelativeCoord_24Bit((const fi_tcl_RelativeCoord_24Bit&)*coRef.poCodedCoordinateData);
         break;
      case fi_tcl_e8_CoordCode::FI_EN_T_RELATIVECOORD_16BIT:
         poCodedCoordinateData = OSAL_NEW fi_tcl_RelativeCoord_16Bit((const fi_tcl_RelativeCoord_16Bit&)*coRef.poCodedCoordinateData);
         break;
      case fi_tcl_e8_CoordCode::FI_EN_T_RELATIVECOORD_8BIT:
         poCodedCoordinateData = OSAL_NEW fi_tcl_RelativeCoord_8Bit((const fi_tcl_RelativeCoord_8Bit&)*coRef.poCodedCoordinateData);
         break;
      default:
         poCodedCoordinateData = OSAL_NULL;
      }
   }
   else
   {
      poCodedCoordinateData = OSAL_NULL;
   }
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
fi_tcl_CodedCoord& fi_tcl_CodedCoord::operator=(const fi_tcl_CodedCoord& coRef)
{
   if (this == &coRef) return *this;
   OSAL_DELETE poCodedCoordinateData;
   CodedCoordinateType = coRef.CodedCoordinateType;
   if  (coRef.poCodedCoordinateData)
   {
      switch(CodedCoordinateType.enType)
      {
      case fi_tcl_e8_CoordCode::FI_EN_T_RESERVED:
         poCodedCoordinateData = OSAL_NEW fi_tcl_Reserved((const fi_tcl_Reserved&)*coRef.poCodedCoordinateData);
         break;
      case fi_tcl_e8_CoordCode::FI_EN_T_POSITIONWGS84:
         poCodedCoordinateData = OSAL_NEW fi_tcl_PositionWGS84((const fi_tcl_PositionWGS84&)*coRef.poCodedCoordinateData);
         break;
      case fi_tcl_e8_CoordCode::FI_EN_T_POSITIONWGS84_24BIT:
         poCodedCoordinateData = OSAL_NEW fi_tcl_PositionWGS84_24Bit((const fi_tcl_PositionWGS84_24Bit&)*coRef.poCodedCoordinateData);
         break;
      case fi_tcl_e8_CoordCode::FI_EN_T_POSITIONWGS84_16BIT:
         poCodedCoordinateData = OSAL_NEW fi_tcl_PositionWGS84_16Bit((const fi_tcl_PositionWGS84_16Bit&)*coRef.poCodedCoordinateData);
         break;
      case fi_tcl_e8_CoordCode::FI_EN_T_RELATIVECOORD_24BIT:
         poCodedCoordinateData = OSAL_NEW fi_tcl_RelativeCoord_24Bit((const fi_tcl_RelativeCoord_24Bit&)*coRef.poCodedCoordinateData);
         break;
      case fi_tcl_e8_CoordCode::FI_EN_T_RELATIVECOORD_16BIT:
         poCodedCoordinateData = OSAL_NEW fi_tcl_RelativeCoord_16Bit((const fi_tcl_RelativeCoord_16Bit&)*coRef.poCodedCoordinateData);
         break;
      case fi_tcl_e8_CoordCode::FI_EN_T_RELATIVECOORD_8BIT:
         poCodedCoordinateData = OSAL_NEW fi_tcl_RelativeCoord_8Bit((const fi_tcl_RelativeCoord_8Bit&)*coRef.poCodedCoordinateData);
         break;
      default:
         poCodedCoordinateData = OSAL_NULL;
      }
   }
   else
   {
      poCodedCoordinateData = OSAL_NULL;
   }
   return *this;
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
fi_tcl_CodedCoord::~fi_tcl_CodedCoord()
{
   OSAL_DELETE poCodedCoordinateData;
   poCodedCoordinateData = OSAL_NULL;
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
tVoid fi_tcl_CodedCoord::vDestroy()
{
   if (poCodedCoordinateData)
   {
      poCodedCoordinateData->vDestroy();
      OSAL_DELETE poCodedCoordinateData;
      poCodedCoordinateData = OSAL_NULL;
   }
}

tU32 fi_tcl_CodedCoord::u32GetSize(tU16 u16MajorVersion) const
{
   return 1+(poCodedCoordinateData?poCodedCoordinateData->u32GetSize(u16MajorVersion):0);
}

tBool fi_tcl_CodedCoord::operator==(const fi_tcl_CodedCoord& rfoCmp) const
{
   tBool bResult = true;
   bResult = bResult && (CodedCoordinateType == rfoCmp.CodedCoordinateType);
   if (bResult && poCodedCoordinateData && rfoCmp.poCodedCoordinateData) 
   {
      switch (CodedCoordinateType.enType)
      {
      case fi_tcl_e8_CoordCode::FI_EN_T_RESERVED:
         bResult = bResult && (*(const fi_tcl_Reserved*)poCodedCoordinateData == *(const fi_tcl_Reserved*)rfoCmp.poCodedCoordinateData); //lint !e826
      break;
      case fi_tcl_e8_CoordCode::FI_EN_T_POSITIONWGS84:
         bResult = bResult && (*(const fi_tcl_PositionWGS84*)poCodedCoordinateData == *(const fi_tcl_PositionWGS84*)rfoCmp.poCodedCoordinateData); //lint !e826
      break;
      case fi_tcl_e8_CoordCode::FI_EN_T_POSITIONWGS84_24BIT:
         bResult = bResult && (*(const fi_tcl_PositionWGS84_24Bit*)poCodedCoordinateData == *(const fi_tcl_PositionWGS84_24Bit*)rfoCmp.poCodedCoordinateData); //lint !e826
      break;
      case fi_tcl_e8_CoordCode::FI_EN_T_POSITIONWGS84_16BIT:
         bResult = bResult && (*(const fi_tcl_PositionWGS84_16Bit*)poCodedCoordinateData == *(const fi_tcl_PositionWGS84_16Bit*)rfoCmp.poCodedCoordinateData); //lint !e826
      break;
      case fi_tcl_e8_CoordCode::FI_EN_T_RELATIVECOORD_24BIT:
         bResult = bResult && (*(const fi_tcl_RelativeCoord_24Bit*)poCodedCoordinateData == *(const fi_tcl_RelativeCoord_24Bit*)rfoCmp.poCodedCoordinateData); //lint !e826
      break;
      case fi_tcl_e8_CoordCode::FI_EN_T_RELATIVECOORD_16BIT:
         bResult = bResult && (*(const fi_tcl_RelativeCoord_16Bit*)poCodedCoordinateData == *(const fi_tcl_RelativeCoord_16Bit*)rfoCmp.poCodedCoordinateData); //lint !e826
      break;
      case fi_tcl_e8_CoordCode::FI_EN_T_RELATIVECOORD_8BIT:
         bResult = bResult && (*(const fi_tcl_RelativeCoord_8Bit*)poCodedCoordinateData == *(const fi_tcl_RelativeCoord_8Bit*)rfoCmp.poCodedCoordinateData); //lint !e826
      break;
      }
   }
   else
   {
      bResult = bResult && (poCodedCoordinateData == rfoCmp.poCodedCoordinateData);
   }
   return bResult;
}

fi_tclInContext& fi_tcl_CodedCoord::oRead(fi_tclInContext& oIn)
{
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   OSAL_DELETE poCodedCoordinateData;
#else
   if (poCodedCoordinateData)
   {
      poCodedCoordinateData->vDestroy();
      OSAL_DELETE poCodedCoordinateData;
   }
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
   oIn >> CodedCoordinateType;
   switch(CodedCoordinateType.enType)
   {
   case fi_tcl_e8_CoordCode::FI_EN_T_RESERVED:
      poCodedCoordinateData = OSAL_NEW fi_tcl_Reserved;
      break;
   case fi_tcl_e8_CoordCode::FI_EN_T_POSITIONWGS84:
      poCodedCoordinateData = OSAL_NEW fi_tcl_PositionWGS84;
      break;
   case fi_tcl_e8_CoordCode::FI_EN_T_POSITIONWGS84_24BIT:
      poCodedCoordinateData = OSAL_NEW fi_tcl_PositionWGS84_24Bit;
      break;
   case fi_tcl_e8_CoordCode::FI_EN_T_POSITIONWGS84_16BIT:
      poCodedCoordinateData = OSAL_NEW fi_tcl_PositionWGS84_16Bit;
      break;
   case fi_tcl_e8_CoordCode::FI_EN_T_RELATIVECOORD_24BIT:
      poCodedCoordinateData = OSAL_NEW fi_tcl_RelativeCoord_24Bit;
      break;
   case fi_tcl_e8_CoordCode::FI_EN_T_RELATIVECOORD_16BIT:
      poCodedCoordinateData = OSAL_NEW fi_tcl_RelativeCoord_16Bit;
      break;
   case fi_tcl_e8_CoordCode::FI_EN_T_RELATIVECOORD_8BIT:
      poCodedCoordinateData = OSAL_NEW fi_tcl_RelativeCoord_8Bit;
      break;
   default:
      oIn.Invalidate();
      poCodedCoordinateData = OSAL_NULL;
   }
   if (poCodedCoordinateData && oIn.bIsValid())
      poCodedCoordinateData->oRead(oIn);
   else
      oIn.Invalidate();
   return oIn;
}

fi_tclOutContext& fi_tcl_CodedCoord::oWrite(fi_tclOutContext& oOut) const
{
   oOut << CodedCoordinateType;
   if (poCodedCoordinateData)
   {
      poCodedCoordinateData->oWrite(oOut);
   }
   else
   {
      oOut.Invalidate();
   }
   return oOut;
}

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
fi_tcl_CoordCodingScheme::fi_tcl_CoordCodingScheme(const fi_tcl_CoordCodingScheme& coRef):fi_tclVisitableTypeBase(coRef)
{
   DataCoordCode = coRef.DataCoordCode;
   BaseCoordinate = coRef.BaseCoordinate;
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
fi_tcl_CoordCodingScheme& fi_tcl_CoordCodingScheme::operator=(const fi_tcl_CoordCodingScheme& coRef)
{
   if (this == &coRef) return *this;
   DataCoordCode = coRef.DataCoordCode;
   BaseCoordinate = coRef.BaseCoordinate;
   return *this;
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
tVoid fi_tcl_CoordCodingScheme::vDestroy()
{
   BaseCoordinate.vDestroy(); 
}

tU32 fi_tcl_CoordCodingScheme::u32GetSize(tU16 u16MajorVersion) const
{
   return 1+BaseCoordinate.u32GetSize(u16MajorVersion);
}

tBool fi_tcl_CoordCodingScheme::operator==(const fi_tcl_CoordCodingScheme& rfoCmp) const
{
   tBool bResult = true;
      bResult = bResult && (DataCoordCode == rfoCmp.DataCoordCode);
      bResult = bResult && (BaseCoordinate == rfoCmp.BaseCoordinate);
   return bResult;
}

fi_tclInContext& fi_tcl_CoordCodingScheme::oRead(fi_tclInContext& oIn)
{
   oIn >> DataCoordCode;
   oIn >> BaseCoordinate;
   return oIn;
}

fi_tclOutContext& fi_tcl_CoordCodingScheme::oWrite(fi_tclOutContext& oOut) const
{
   oOut << DataCoordCode;
   oOut << BaseCoordinate;
   return oOut;
}

tU32 fi_tcl_b8_PresenceIndicator::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 1;
}

tBool fi_tcl_b8_PresenceIndicator::operator==(const fi_tcl_b8_PresenceIndicator& rfoCmp) const
{
   return u8Value == rfoCmp.u8Value;
}

fi_tclInContext& fi_tcl_b8_PresenceIndicator::oRead(fi_tclInContext& oIn)
{
   return oIn >> u8Value;
}

fi_tclOutContext& fi_tcl_b8_PresenceIndicator::oWrite(fi_tclOutContext& oOut) const
{
   return oOut << u8Value;
}

tU32 fi_tcl_s8_MapDisplayZLevel::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 1;
}

tBool fi_tcl_s8_MapDisplayZLevel::operator==(const fi_tcl_s8_MapDisplayZLevel& rfoCmp) const
{
   return s8Value == rfoCmp.s8Value;
}

fi_tclInContext& fi_tcl_s8_MapDisplayZLevel::oRead(fi_tclInContext& oIn)
{
   return oIn >> s8Value;
}

fi_tclOutContext& fi_tcl_s8_MapDisplayZLevel::oWrite(fi_tclOutContext& oOut) const
{
   return oOut << s8Value;
}

tU32 fi_tcl_s8_MapDisplayPriority::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 1;
}

tBool fi_tcl_s8_MapDisplayPriority::operator==(const fi_tcl_s8_MapDisplayPriority& rfoCmp) const
{
   return s8Value == rfoCmp.s8Value;
}

fi_tclInContext& fi_tcl_s8_MapDisplayPriority::oRead(fi_tclInContext& oIn)
{
   return oIn >> s8Value;
}

fi_tclOutContext& fi_tcl_s8_MapDisplayPriority::oWrite(fi_tclOutContext& oOut) const
{
   return oOut << s8Value;
}

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
fi_tcl_MapCodedElement::fi_tcl_MapCodedElement(const fi_tcl_MapCodedElement& coRef):fi_tclVisitableTypeBase(coRef)
{
   MapCodedElementMask = coRef.MapCodedElementMask;
   if (MapCodedElementMask.u8Value & fi_tcl_b8_PresenceIndicator::FI_C_U8_BIT_T_E16_ISOCOUNTRYCODE && coRef.poOption0)
   {
      poOption0 = OSAL_NEW fi_tcl_e16_ISOCountryCode((const fi_tcl_e16_ISOCountryCode&)*coRef.poOption0);
      if (!poOption0)
      {
         MapCodedElementMask.vSetT_e16_ISOCountryCode(FALSE);
      }
   }
   else
   {
      poOption0 = OSAL_NULL;
      MapCodedElementMask.vSetT_e16_ISOCountryCode(FALSE);
   }
   if (MapCodedElementMask.u8Value & fi_tcl_b8_PresenceIndicator::FI_C_U8_BIT_T_E8_MAPGEOMETRICTYPE && coRef.poOption1)
   {
      poOption1 = OSAL_NEW fi_tcl_e8_MapGeometricType((const fi_tcl_e8_MapGeometricType&)*coRef.poOption1);
      if (!poOption1)
      {
         MapCodedElementMask.vSetT_e8_MapGeometricType(FALSE);
      }
   }
   else
   {
      poOption1 = OSAL_NULL;
      MapCodedElementMask.vSetT_e8_MapGeometricType(FALSE);
   }
   if (MapCodedElementMask.u8Value & fi_tcl_b8_PresenceIndicator::FI_C_U8_BIT_T_MAPGEOGRAPHICTYPE && coRef.poOption2)
   {
      poOption2 = OSAL_NEW fi_tcl_MapGeographicType((const fi_tcl_MapGeographicType&)*coRef.poOption2);
      if (!poOption2)
      {
         MapCodedElementMask.vSetT_MapGeographicType(FALSE);
      }
   }
   else
   {
      poOption2 = OSAL_NULL;
      MapCodedElementMask.vSetT_MapGeographicType(FALSE);
   }
   if (MapCodedElementMask.u8Value & fi_tcl_b8_PresenceIndicator::FI_C_U8_BIT_T_MAPELEMENTDESCRIPTION && coRef.poOption3)
   {
      poOption3 = OSAL_NEW fi_tcl_MapElementDescription((const fi_tcl_MapElementDescription&)*coRef.poOption3);
      if (!poOption3)
      {
         MapCodedElementMask.vSetT_MapElementDescription(FALSE);
      }
   }
   else
   {
      poOption3 = OSAL_NULL;
      MapCodedElementMask.vSetT_MapElementDescription(FALSE);
   }
   if (MapCodedElementMask.u8Value & fi_tcl_b8_PresenceIndicator::FI_C_U8_BIT_T_S8_MAPDISPLAYPRIORITY && coRef.poOption4)
   {
      poOption4 = OSAL_NEW fi_tcl_s8_MapDisplayPriority((const fi_tcl_s8_MapDisplayPriority&)*coRef.poOption4);
      if (!poOption4)
      {
         MapCodedElementMask.vSetT_s8_MapDisplayPriority(FALSE);
      }
   }
   else
   {
      poOption4 = OSAL_NULL;
      MapCodedElementMask.vSetT_s8_MapDisplayPriority(FALSE);
   }
   if (MapCodedElementMask.u8Value & fi_tcl_b8_PresenceIndicator::FI_C_U8_BIT_T_S8_MAPDISPLAYZLEVEL && coRef.poOption5)
   {
      poOption5 = OSAL_NEW fi_tcl_s8_MapDisplayZLevel((const fi_tcl_s8_MapDisplayZLevel&)*coRef.poOption5);
      if (!poOption5)
      {
         MapCodedElementMask.vSetT_s8_MapDisplayZLevel(FALSE);
      }
   }
   else
   {
      poOption5 = OSAL_NULL;
      MapCodedElementMask.vSetT_s8_MapDisplayZLevel(FALSE);
   }
   if (MapCodedElementMask.u8Value & fi_tcl_b8_PresenceIndicator::FI_C_U8_BIT_T_MAPCOORDINATES && coRef.poOption6)
   {
      poOption6 = OSAL_NEW fi_tcl_MapCoordinates((const fi_tcl_MapCoordinates&)*coRef.poOption6);
      if (!poOption6)
      {
         MapCodedElementMask.vSetT_MapCoordinates(FALSE);
      }
   }
   else
   {
      poOption6 = OSAL_NULL;
      MapCodedElementMask.vSetT_MapCoordinates(FALSE);
   }
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
fi_tcl_MapCodedElement& fi_tcl_MapCodedElement::operator=(const fi_tcl_MapCodedElement& coRef)
{
   if (this == &coRef) return *this;
   OSAL_DELETE poOption0;
   OSAL_DELETE poOption1;
   OSAL_DELETE poOption2;
   OSAL_DELETE poOption3;
   OSAL_DELETE poOption4;
   OSAL_DELETE poOption5;
   OSAL_DELETE poOption6;
   MapCodedElementMask = coRef.MapCodedElementMask;
   if (MapCodedElementMask.u8Value & fi_tcl_b8_PresenceIndicator::FI_C_U8_BIT_T_E16_ISOCOUNTRYCODE && coRef.poOption0)
   {
      poOption0 = OSAL_NEW fi_tcl_e16_ISOCountryCode((const fi_tcl_e16_ISOCountryCode&)*coRef.poOption0);
      if (!poOption0)
      {
         MapCodedElementMask.vSetT_e16_ISOCountryCode(FALSE);
      }
   }
   else
   {
      poOption0 = OSAL_NULL;
      MapCodedElementMask.vSetT_e16_ISOCountryCode(FALSE);
   }
   if (MapCodedElementMask.u8Value & fi_tcl_b8_PresenceIndicator::FI_C_U8_BIT_T_E8_MAPGEOMETRICTYPE && coRef.poOption1)
   {
      poOption1 = OSAL_NEW fi_tcl_e8_MapGeometricType((const fi_tcl_e8_MapGeometricType&)*coRef.poOption1);
      if (!poOption1)
      {
         MapCodedElementMask.vSetT_e8_MapGeometricType(FALSE);
      }
   }
   else
   {
      poOption1 = OSAL_NULL;
      MapCodedElementMask.vSetT_e8_MapGeometricType(FALSE);
   }
   if (MapCodedElementMask.u8Value & fi_tcl_b8_PresenceIndicator::FI_C_U8_BIT_T_MAPGEOGRAPHICTYPE && coRef.poOption2)
   {
      poOption2 = OSAL_NEW fi_tcl_MapGeographicType((const fi_tcl_MapGeographicType&)*coRef.poOption2);
      if (!poOption2)
      {
         MapCodedElementMask.vSetT_MapGeographicType(FALSE);
      }
   }
   else
   {
      poOption2 = OSAL_NULL;
      MapCodedElementMask.vSetT_MapGeographicType(FALSE);
   }
   if (MapCodedElementMask.u8Value & fi_tcl_b8_PresenceIndicator::FI_C_U8_BIT_T_MAPELEMENTDESCRIPTION && coRef.poOption3)
   {
      poOption3 = OSAL_NEW fi_tcl_MapElementDescription((const fi_tcl_MapElementDescription&)*coRef.poOption3);
      if (!poOption3)
      {
         MapCodedElementMask.vSetT_MapElementDescription(FALSE);
      }
   }
   else
   {
      poOption3 = OSAL_NULL;
      MapCodedElementMask.vSetT_MapElementDescription(FALSE);
   }
   if (MapCodedElementMask.u8Value & fi_tcl_b8_PresenceIndicator::FI_C_U8_BIT_T_S8_MAPDISPLAYPRIORITY && coRef.poOption4)
   {
      poOption4 = OSAL_NEW fi_tcl_s8_MapDisplayPriority((const fi_tcl_s8_MapDisplayPriority&)*coRef.poOption4);
      if (!poOption4)
      {
         MapCodedElementMask.vSetT_s8_MapDisplayPriority(FALSE);
      }
   }
   else
   {
      poOption4 = OSAL_NULL;
      MapCodedElementMask.vSetT_s8_MapDisplayPriority(FALSE);
   }
   if (MapCodedElementMask.u8Value & fi_tcl_b8_PresenceIndicator::FI_C_U8_BIT_T_S8_MAPDISPLAYZLEVEL && coRef.poOption5)
   {
      poOption5 = OSAL_NEW fi_tcl_s8_MapDisplayZLevel((const fi_tcl_s8_MapDisplayZLevel&)*coRef.poOption5);
      if (!poOption5)
      {
         MapCodedElementMask.vSetT_s8_MapDisplayZLevel(FALSE);
      }
   }
   else
   {
      poOption5 = OSAL_NULL;
      MapCodedElementMask.vSetT_s8_MapDisplayZLevel(FALSE);
   }
   if (MapCodedElementMask.u8Value & fi_tcl_b8_PresenceIndicator::FI_C_U8_BIT_T_MAPCOORDINATES && coRef.poOption6)
   {
      poOption6 = OSAL_NEW fi_tcl_MapCoordinates((const fi_tcl_MapCoordinates&)*coRef.poOption6);
      if (!poOption6)
      {
         MapCodedElementMask.vSetT_MapCoordinates(FALSE);
      }
   }
   else
   {
      poOption6 = OSAL_NULL;
      MapCodedElementMask.vSetT_MapCoordinates(FALSE);
   }
   return *this;
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
fi_tcl_MapCodedElement::~fi_tcl_MapCodedElement()
{
   OSAL_DELETE poOption0;
   poOption0 = OSAL_NULL;
   OSAL_DELETE poOption1;
   poOption1 = OSAL_NULL;
   OSAL_DELETE poOption2;
   poOption2 = OSAL_NULL;
   OSAL_DELETE poOption3;
   poOption3 = OSAL_NULL;
   OSAL_DELETE poOption4;
   poOption4 = OSAL_NULL;
   OSAL_DELETE poOption5;
   poOption5 = OSAL_NULL;
   OSAL_DELETE poOption6;
   poOption6 = OSAL_NULL;
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
tVoid fi_tcl_MapCodedElement::vDestroy()
{
   if (MapCodedElementMask.u8Value & fi_tcl_b8_PresenceIndicator::FI_C_U8_BIT_T_E16_ISOCOUNTRYCODE && poOption0)
   {
      poOption0->vDestroy();
      OSAL_DELETE poOption0;
      poOption0 = OSAL_NULL;
   }
   if (MapCodedElementMask.u8Value & fi_tcl_b8_PresenceIndicator::FI_C_U8_BIT_T_E8_MAPGEOMETRICTYPE && poOption1)
   {
      poOption1->vDestroy();
      OSAL_DELETE poOption1;
      poOption1 = OSAL_NULL;
   }
   if (MapCodedElementMask.u8Value & fi_tcl_b8_PresenceIndicator::FI_C_U8_BIT_T_MAPGEOGRAPHICTYPE && poOption2)
   {
      poOption2->vDestroy();
      OSAL_DELETE poOption2;
      poOption2 = OSAL_NULL;
   }
   if (MapCodedElementMask.u8Value & fi_tcl_b8_PresenceIndicator::FI_C_U8_BIT_T_MAPELEMENTDESCRIPTION && poOption3)
   {
      poOption3->vDestroy();
      OSAL_DELETE poOption3;
      poOption3 = OSAL_NULL;
   }
   if (MapCodedElementMask.u8Value & fi_tcl_b8_PresenceIndicator::FI_C_U8_BIT_T_S8_MAPDISPLAYPRIORITY && poOption4)
   {
      poOption4->vDestroy();
      OSAL_DELETE poOption4;
      poOption4 = OSAL_NULL;
   }
   if (MapCodedElementMask.u8Value & fi_tcl_b8_PresenceIndicator::FI_C_U8_BIT_T_S8_MAPDISPLAYZLEVEL && poOption5)
   {
      poOption5->vDestroy();
      OSAL_DELETE poOption5;
      poOption5 = OSAL_NULL;
   }
   if (MapCodedElementMask.u8Value & fi_tcl_b8_PresenceIndicator::FI_C_U8_BIT_T_MAPCOORDINATES && poOption6)
   {
      poOption6->vDestroy();
      OSAL_DELETE poOption6;
      poOption6 = OSAL_NULL;
   }
}

tU32 fi_tcl_MapCodedElement::u32GetSize(tU16 u16MajorVersion) const
{
   tU32 u32DynamicSize = 0;
   if (poOption0 && (MapCodedElementMask.u8Value & fi_tcl_b8_PresenceIndicator::FI_C_U8_BIT_T_E16_ISOCOUNTRYCODE))
   {
      u32DynamicSize += poOption0->u32GetSize(u16MajorVersion);
   }
   if (poOption1 && (MapCodedElementMask.u8Value & fi_tcl_b8_PresenceIndicator::FI_C_U8_BIT_T_E8_MAPGEOMETRICTYPE))
   {
      u32DynamicSize += poOption1->u32GetSize(u16MajorVersion);
   }
   if (poOption2 && (MapCodedElementMask.u8Value & fi_tcl_b8_PresenceIndicator::FI_C_U8_BIT_T_MAPGEOGRAPHICTYPE))
   {
      u32DynamicSize += poOption2->u32GetSize(u16MajorVersion);
   }
   if (poOption3 && (MapCodedElementMask.u8Value & fi_tcl_b8_PresenceIndicator::FI_C_U8_BIT_T_MAPELEMENTDESCRIPTION))
   {
      u32DynamicSize += poOption3->u32GetSize(u16MajorVersion);
   }
   if (poOption4 && (MapCodedElementMask.u8Value & fi_tcl_b8_PresenceIndicator::FI_C_U8_BIT_T_S8_MAPDISPLAYPRIORITY))
   {
      u32DynamicSize += poOption4->u32GetSize(u16MajorVersion);
   }
   if (poOption5 && (MapCodedElementMask.u8Value & fi_tcl_b8_PresenceIndicator::FI_C_U8_BIT_T_S8_MAPDISPLAYZLEVEL))
   {
      u32DynamicSize += poOption5->u32GetSize(u16MajorVersion);
   }
   if (poOption6 && (MapCodedElementMask.u8Value & fi_tcl_b8_PresenceIndicator::FI_C_U8_BIT_T_MAPCOORDINATES))
   {
      u32DynamicSize += poOption6->u32GetSize(u16MajorVersion);
   }
   return u32DynamicSize+1;
}

tBool fi_tcl_MapCodedElement::operator==(const fi_tcl_MapCodedElement& rfoCmp) const
{
   tBool bResult = true;
      bResult = bResult && (MapCodedElementMask == rfoCmp.MapCodedElementMask);
      if (bResult && (MapCodedElementMask.u8Value & fi_tcl_b8_PresenceIndicator::FI_C_U8_BIT_T_E16_ISOCOUNTRYCODE) && poOption0 && rfoCmp.poOption0)
         bResult = bResult && (*poOption0 == *(rfoCmp.poOption0));//lint !e826
      else
         bResult = FALSE;
      if (bResult && (MapCodedElementMask.u8Value & fi_tcl_b8_PresenceIndicator::FI_C_U8_BIT_T_E8_MAPGEOMETRICTYPE) && poOption1 && rfoCmp.poOption1)
         bResult = bResult && (*poOption1 == *(rfoCmp.poOption1));//lint !e826
      else
         bResult = FALSE;
      if (bResult && (MapCodedElementMask.u8Value & fi_tcl_b8_PresenceIndicator::FI_C_U8_BIT_T_MAPGEOGRAPHICTYPE) && poOption2 && rfoCmp.poOption2)
         bResult = bResult && (*poOption2 == *(rfoCmp.poOption2));//lint !e826
      else
         bResult = FALSE;
      if (bResult && (MapCodedElementMask.u8Value & fi_tcl_b8_PresenceIndicator::FI_C_U8_BIT_T_MAPELEMENTDESCRIPTION) && poOption3 && rfoCmp.poOption3)
         bResult = bResult && (*poOption3 == *(rfoCmp.poOption3));//lint !e826
      else
         bResult = FALSE;
      if (bResult && (MapCodedElementMask.u8Value & fi_tcl_b8_PresenceIndicator::FI_C_U8_BIT_T_S8_MAPDISPLAYPRIORITY) && poOption4 && rfoCmp.poOption4)
         bResult = bResult && (*poOption4 == *(rfoCmp.poOption4));//lint !e826
      else
         bResult = FALSE;
      if (bResult && (MapCodedElementMask.u8Value & fi_tcl_b8_PresenceIndicator::FI_C_U8_BIT_T_S8_MAPDISPLAYZLEVEL) && poOption5 && rfoCmp.poOption5)
         bResult = bResult && (*poOption5 == *(rfoCmp.poOption5));//lint !e826
      else
         bResult = FALSE;
      if (bResult && (MapCodedElementMask.u8Value & fi_tcl_b8_PresenceIndicator::FI_C_U8_BIT_T_MAPCOORDINATES) && poOption6 && rfoCmp.poOption6)
         bResult = bResult && (*poOption6 == *(rfoCmp.poOption6));//lint !e826
      else
         bResult = FALSE;
   return bResult;
}

fi_tclInContext& fi_tcl_MapCodedElement::oRead(fi_tclInContext& oIn)
{
   if (poOption0 != 0)
   {
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
      poOption0->vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
      OSAL_DELETE poOption0;
      poOption0 = OSAL_NULL;
   }
   if (poOption1 != 0)
   {
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
      poOption1->vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
      OSAL_DELETE poOption1;
      poOption1 = OSAL_NULL;
   }
   if (poOption2 != 0)
   {
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
      poOption2->vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
      OSAL_DELETE poOption2;
      poOption2 = OSAL_NULL;
   }
   if (poOption3 != 0)
   {
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
      poOption3->vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
      OSAL_DELETE poOption3;
      poOption3 = OSAL_NULL;
   }
   if (poOption4 != 0)
   {
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
      poOption4->vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
      OSAL_DELETE poOption4;
      poOption4 = OSAL_NULL;
   }
   if (poOption5 != 0)
   {
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
      poOption5->vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
      OSAL_DELETE poOption5;
      poOption5 = OSAL_NULL;
   }
   if (poOption6 != 0)
   {
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
      poOption6->vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
      OSAL_DELETE poOption6;
      poOption6 = OSAL_NULL;
   }
   oIn >> MapCodedElementMask;
   if (MapCodedElementMask.u8Value & fi_tcl_b8_PresenceIndicator::FI_C_U8_BIT_T_E16_ISOCOUNTRYCODE)
   {
      poOption0 = OSAL_NEW fi_tcl_e16_ISOCountryCode;
      if (poOption0)
         poOption0->oRead(oIn);
      else
         oIn.Invalidate();
   }
   if (MapCodedElementMask.u8Value & fi_tcl_b8_PresenceIndicator::FI_C_U8_BIT_T_E8_MAPGEOMETRICTYPE)
   {
      poOption1 = OSAL_NEW fi_tcl_e8_MapGeometricType;
      if (poOption1)
         poOption1->oRead(oIn);
      else
         oIn.Invalidate();
   }
   if (MapCodedElementMask.u8Value & fi_tcl_b8_PresenceIndicator::FI_C_U8_BIT_T_MAPGEOGRAPHICTYPE)
   {
      poOption2 = OSAL_NEW fi_tcl_MapGeographicType;
      if (poOption2)
         poOption2->oRead(oIn);
      else
         oIn.Invalidate();
   }
   if (MapCodedElementMask.u8Value & fi_tcl_b8_PresenceIndicator::FI_C_U8_BIT_T_MAPELEMENTDESCRIPTION)
   {
      poOption3 = OSAL_NEW fi_tcl_MapElementDescription;
      if (poOption3)
         poOption3->oRead(oIn);
      else
         oIn.Invalidate();
   }
   if (MapCodedElementMask.u8Value & fi_tcl_b8_PresenceIndicator::FI_C_U8_BIT_T_S8_MAPDISPLAYPRIORITY)
   {
      poOption4 = OSAL_NEW fi_tcl_s8_MapDisplayPriority;
      if (poOption4)
         poOption4->oRead(oIn);
      else
         oIn.Invalidate();
   }
   if (MapCodedElementMask.u8Value & fi_tcl_b8_PresenceIndicator::FI_C_U8_BIT_T_S8_MAPDISPLAYZLEVEL)
   {
      poOption5 = OSAL_NEW fi_tcl_s8_MapDisplayZLevel;
      if (poOption5)
         poOption5->oRead(oIn);
      else
         oIn.Invalidate();
   }
   if (MapCodedElementMask.u8Value & fi_tcl_b8_PresenceIndicator::FI_C_U8_BIT_T_MAPCOORDINATES)
   {
      poOption6 = OSAL_NEW fi_tcl_MapCoordinates;
      if (poOption6)
         poOption6->oRead(oIn);
      else
         oIn.Invalidate();
   }
   return oIn;
}

fi_tclOutContext& fi_tcl_MapCodedElement::oWrite(fi_tclOutContext& oOut) const
{
   oOut << MapCodedElementMask;
   if (MapCodedElementMask.u8Value & fi_tcl_b8_PresenceIndicator::FI_C_U8_BIT_T_E16_ISOCOUNTRYCODE)
   {
      if (poOption0)
      {
         poOption0->oWrite(oOut);
      }
      else
      {
         oOut.Invalidate();
      }
   }
   if (MapCodedElementMask.u8Value & fi_tcl_b8_PresenceIndicator::FI_C_U8_BIT_T_E8_MAPGEOMETRICTYPE)
   {
      if (poOption1)
      {
         poOption1->oWrite(oOut);
      }
      else
      {
         oOut.Invalidate();
      }
   }
   if (MapCodedElementMask.u8Value & fi_tcl_b8_PresenceIndicator::FI_C_U8_BIT_T_MAPGEOGRAPHICTYPE)
   {
      if (poOption2)
      {
         poOption2->oWrite(oOut);
      }
      else
      {
         oOut.Invalidate();
      }
   }
   if (MapCodedElementMask.u8Value & fi_tcl_b8_PresenceIndicator::FI_C_U8_BIT_T_MAPELEMENTDESCRIPTION)
   {
      if (poOption3)
      {
         poOption3->oWrite(oOut);
      }
      else
      {
         oOut.Invalidate();
      }
   }
   if (MapCodedElementMask.u8Value & fi_tcl_b8_PresenceIndicator::FI_C_U8_BIT_T_S8_MAPDISPLAYPRIORITY)
   {
      if (poOption4)
      {
         poOption4->oWrite(oOut);
      }
      else
      {
         oOut.Invalidate();
      }
   }
   if (MapCodedElementMask.u8Value & fi_tcl_b8_PresenceIndicator::FI_C_U8_BIT_T_S8_MAPDISPLAYZLEVEL)
   {
      if (poOption5)
      {
         poOption5->oWrite(oOut);
      }
      else
      {
         oOut.Invalidate();
      }
   }
   if (MapCodedElementMask.u8Value & fi_tcl_b8_PresenceIndicator::FI_C_U8_BIT_T_MAPCOORDINATES)
   {
      if (poOption6)
      {
         poOption6->oWrite(oOut);
      }
      else
      {
         oOut.Invalidate();
      }
   }
   return oOut;
}

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
fi_tcl_MapContainer::fi_tcl_MapContainer(const fi_tcl_MapContainer& coRef):fi_tclVisitableTypeBase(coRef)
{
   FullCoverNorthWest = coRef.FullCoverNorthWest;
   FullCoverSouthEast = coRef.FullCoverSouthEast;
   DataLevel = coRef.DataLevel;
   CoordCodingScheme = coRef.CoordCodingScheme;
   MapCodedElements = coRef.MapCodedElements;
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
fi_tcl_MapContainer& fi_tcl_MapContainer::operator=(const fi_tcl_MapContainer& coRef)
{
   if (this == &coRef) return *this;
   FullCoverNorthWest = coRef.FullCoverNorthWest;
   FullCoverSouthEast = coRef.FullCoverSouthEast;
   DataLevel = coRef.DataLevel;
   CoordCodingScheme = coRef.CoordCodingScheme;
   MapCodedElements = coRef.MapCodedElements;
   return *this;
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
tVoid fi_tcl_MapContainer::vDestroy()
{
   FullCoverNorthWest.vDestroy(); 
   FullCoverSouthEast.vDestroy(); 
   CoordCodingScheme.vDestroy(); 
   {
      for (tU32 u32Idx = 0; u32Idx < MapCodedElements.size(); ++u32Idx)
         MapCodedElements[u32Idx].vDestroy();
   }
   MapCodedElements.clear();
}

tU32 fi_tcl_MapContainer::u32GetSize(tU16 u16MajorVersion) const
{
   tU32 u32DynamicSize = 0;
   tU32 u32ListIdx;
   for (u32ListIdx = 0; u32ListIdx < MapCodedElements.size(); ++u32ListIdx)
      u32DynamicSize += MapCodedElements[u32ListIdx].u32GetSize(u16MajorVersion);
   return u32DynamicSize+21+CoordCodingScheme.u32GetSize(u16MajorVersion);
}

tBool fi_tcl_MapContainer::operator==(const fi_tcl_MapContainer& rfoCmp) const
{
   tBool bResult = true;
      bResult = bResult && (FullCoverNorthWest == rfoCmp.FullCoverNorthWest);
      bResult = bResult && (FullCoverSouthEast == rfoCmp.FullCoverSouthEast);
      bResult = bResult && (DataLevel == rfoCmp.DataLevel);
      bResult = bResult && (CoordCodingScheme == rfoCmp.CoordCodingScheme);
      bResult = bResult && (MapCodedElements.size() == rfoCmp.MapCodedElements.size());
      if (bResult)
      {
         for (tU32 u32Idx = 0; bResult && (u32Idx < MapCodedElements.size()); ++u32Idx)
            bResult = bResult && (MapCodedElements[u32Idx] == rfoCmp.MapCodedElements[u32Idx]);
      }
   return bResult;
}

fi_tclInContext& fi_tcl_MapContainer::oRead(fi_tclInContext& oIn)
{
   oIn >> FullCoverNorthWest;
   oIn >> FullCoverSouthEast;
   oIn >> DataLevel;
   oIn >> CoordCodingScheme;
   {
      tU32 u32Length;
      tU32 u32Idx;
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
      for (u32Idx = 0; u32Idx < MapCodedElements.size(); ++u32Idx)
      {
         MapCodedElements[u32Idx].vDestroy();
      }
#endif // !VARIANT_S_FTR_ENABLE_DEEP_COPY
      oIn >> u32Length;
      MapCodedElements.resize(u32Length);
      for (u32Idx = 0; u32Idx < u32Length; ++u32Idx)
      {
         oIn >> MapCodedElements[u32Idx];
      }
   }
   return oIn;
}

fi_tclOutContext& fi_tcl_MapContainer::oWrite(fi_tclOutContext& oOut) const
{
   oOut << FullCoverNorthWest;
   oOut << FullCoverSouthEast;
   oOut << DataLevel;
   oOut << CoordCodingScheme;
   oOut << (tU32)MapCodedElements.size();
   {
      for (tU32 u32Idx = 0; u32Idx < MapCodedElements.size(); ++u32Idx)
         oOut << MapCodedElements[u32Idx];
   }
   return oOut;
}

tU32 fi_tcl_e8_MapElementDescrType::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 1;
}

tBool fi_tcl_e8_MapElementDescrType::operator==(const fi_tcl_e8_MapElementDescrType& rfoCmp) const
{
   return enType == rfoCmp.enType;
}

fi_tclInContext& fi_tcl_e8_MapElementDescrType::oRead(fi_tclInContext& oIn)
{
   tU8 u8Value;
   oIn >> u8Value;
   enType = (tenType)u8Value;
   return oIn;
}

fi_tclOutContext& fi_tcl_e8_MapElementDescrType::oWrite(fi_tclOutContext& oOut) const
{
   return oOut.oWrite((tU8)enType);
}

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
fi_tcl_MapElementDescriptor::fi_tcl_MapElementDescriptor(const fi_tcl_MapElementDescriptor& coRef):fi_tclVisitableTypeBase(coRef)
{
   MapElementDescrDataType = coRef.MapElementDescrDataType;
   if  (coRef.poMapElementDescrDataData)
   {
      switch(MapElementDescrDataType.enType)
      {
      case fi_tcl_e8_MapElementDescrType::FI_EN_T_RESERVED:
         poMapElementDescrDataData = OSAL_NEW fi_tcl_Reserved((const fi_tcl_Reserved&)*coRef.poMapElementDescrDataData);
         break;
      case fi_tcl_e8_MapElementDescrType::FI_EN_TSTRING:
         poMapElementDescrDataData = OSAL_NEW fi_tclString((const fi_tclString&)*coRef.poMapElementDescrDataData);
         break;
      case fi_tcl_e8_MapElementDescrType::FI_EN_T_MAPGEOGRAPHICTYPE:
         poMapElementDescrDataData = OSAL_NEW fi_tcl_MapGeographicType((const fi_tcl_MapGeographicType&)*coRef.poMapElementDescrDataData);
         break;
      case fi_tcl_e8_MapElementDescrType::FI_EN_T_E8_ROADCLASSCODE:
         poMapElementDescrDataData = OSAL_NEW fi_tcl_e8_RoadClassCode((const fi_tcl_e8_RoadClassCode&)*coRef.poMapElementDescrDataData);
         break;
      case fi_tcl_e8_MapElementDescrType::FI_EN_T_B16_ROADATTRIBUTE:
         poMapElementDescrDataData = OSAL_NEW fi_tcl_b16_RoadAttribute((const fi_tcl_b16_RoadAttribute&)*coRef.poMapElementDescrDataData);
         break;
      case fi_tcl_e8_MapElementDescrType::FI_EN_T_ROADNUMBER:
         poMapElementDescrDataData = OSAL_NEW fi_tcl_RoadNumber((const fi_tcl_RoadNumber&)*coRef.poMapElementDescrDataData);
         break;
      case fi_tcl_e8_MapElementDescrType::FI_EN_T_E8_SURFACECOVERCODE:
         poMapElementDescrDataData = OSAL_NEW fi_tcl_e8_SurfaceCoverCode((const fi_tcl_e8_SurfaceCoverCode&)*coRef.poMapElementDescrDataData);
         break;
      case fi_tcl_e8_MapElementDescrType::FI_EN_T_E16_NAVIEVENTVALUE:
         poMapElementDescrDataData = OSAL_NEW fi_tcl_e16_NaviEventValue((const fi_tcl_e16_NaviEventValue&)*coRef.poMapElementDescrDataData);
         break;
      case fi_tcl_e8_MapElementDescrType::FI_EN_TMULTILANGUAGESTRING:
         poMapElementDescrDataData = OSAL_NEW fi_tclMultiLanguageString((const fi_tclMultiLanguageString&)*coRef.poMapElementDescrDataData);
         break;
      default:
         poMapElementDescrDataData = OSAL_NULL;
      }
   }
   else
   {
      poMapElementDescrDataData = OSAL_NULL;
   }
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
fi_tcl_MapElementDescriptor& fi_tcl_MapElementDescriptor::operator=(const fi_tcl_MapElementDescriptor& coRef)
{
   if (this == &coRef) return *this;
   OSAL_DELETE poMapElementDescrDataData;
   MapElementDescrDataType = coRef.MapElementDescrDataType;
   if  (coRef.poMapElementDescrDataData)
   {
      switch(MapElementDescrDataType.enType)
      {
      case fi_tcl_e8_MapElementDescrType::FI_EN_T_RESERVED:
         poMapElementDescrDataData = OSAL_NEW fi_tcl_Reserved((const fi_tcl_Reserved&)*coRef.poMapElementDescrDataData);
         break;
      case fi_tcl_e8_MapElementDescrType::FI_EN_TSTRING:
         poMapElementDescrDataData = OSAL_NEW fi_tclString((const fi_tclString&)*coRef.poMapElementDescrDataData);
         break;
      case fi_tcl_e8_MapElementDescrType::FI_EN_T_MAPGEOGRAPHICTYPE:
         poMapElementDescrDataData = OSAL_NEW fi_tcl_MapGeographicType((const fi_tcl_MapGeographicType&)*coRef.poMapElementDescrDataData);
         break;
      case fi_tcl_e8_MapElementDescrType::FI_EN_T_E8_ROADCLASSCODE:
         poMapElementDescrDataData = OSAL_NEW fi_tcl_e8_RoadClassCode((const fi_tcl_e8_RoadClassCode&)*coRef.poMapElementDescrDataData);
         break;
      case fi_tcl_e8_MapElementDescrType::FI_EN_T_B16_ROADATTRIBUTE:
         poMapElementDescrDataData = OSAL_NEW fi_tcl_b16_RoadAttribute((const fi_tcl_b16_RoadAttribute&)*coRef.poMapElementDescrDataData);
         break;
      case fi_tcl_e8_MapElementDescrType::FI_EN_T_ROADNUMBER:
         poMapElementDescrDataData = OSAL_NEW fi_tcl_RoadNumber((const fi_tcl_RoadNumber&)*coRef.poMapElementDescrDataData);
         break;
      case fi_tcl_e8_MapElementDescrType::FI_EN_T_E8_SURFACECOVERCODE:
         poMapElementDescrDataData = OSAL_NEW fi_tcl_e8_SurfaceCoverCode((const fi_tcl_e8_SurfaceCoverCode&)*coRef.poMapElementDescrDataData);
         break;
      case fi_tcl_e8_MapElementDescrType::FI_EN_T_E16_NAVIEVENTVALUE:
         poMapElementDescrDataData = OSAL_NEW fi_tcl_e16_NaviEventValue((const fi_tcl_e16_NaviEventValue&)*coRef.poMapElementDescrDataData);
         break;
      case fi_tcl_e8_MapElementDescrType::FI_EN_TMULTILANGUAGESTRING:
         poMapElementDescrDataData = OSAL_NEW fi_tclMultiLanguageString((const fi_tclMultiLanguageString&)*coRef.poMapElementDescrDataData);
         break;
      default:
         poMapElementDescrDataData = OSAL_NULL;
      }
   }
   else
   {
      poMapElementDescrDataData = OSAL_NULL;
   }
   return *this;
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
fi_tcl_MapElementDescriptor::~fi_tcl_MapElementDescriptor()
{
   OSAL_DELETE poMapElementDescrDataData;
   poMapElementDescrDataData = OSAL_NULL;
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
tVoid fi_tcl_MapElementDescriptor::vDestroy()
{
   if (poMapElementDescrDataData)
   {
      poMapElementDescrDataData->vDestroy();
      OSAL_DELETE poMapElementDescrDataData;
      poMapElementDescrDataData = OSAL_NULL;
   }
}

tU32 fi_tcl_MapElementDescriptor::u32GetSize(tU16 u16MajorVersion) const
{
   return 1+(poMapElementDescrDataData?poMapElementDescrDataData->u32GetSize(u16MajorVersion):0);
}

tBool fi_tcl_MapElementDescriptor::operator==(const fi_tcl_MapElementDescriptor& rfoCmp) const
{
   tBool bResult = true;
   bResult = bResult && (MapElementDescrDataType == rfoCmp.MapElementDescrDataType);
   if (bResult && poMapElementDescrDataData && rfoCmp.poMapElementDescrDataData) 
   {
      switch (MapElementDescrDataType.enType)
      {
      case fi_tcl_e8_MapElementDescrType::FI_EN_T_RESERVED:
         bResult = bResult && (*(const fi_tcl_Reserved*)poMapElementDescrDataData == *(const fi_tcl_Reserved*)rfoCmp.poMapElementDescrDataData); //lint !e826
      break;
      case fi_tcl_e8_MapElementDescrType::FI_EN_TSTRING:
         bResult = bResult && (*(const fi_tclString*)poMapElementDescrDataData == *(const fi_tclString*)rfoCmp.poMapElementDescrDataData); //lint !e826
      break;
      case fi_tcl_e8_MapElementDescrType::FI_EN_T_MAPGEOGRAPHICTYPE:
         bResult = bResult && (*(const fi_tcl_MapGeographicType*)poMapElementDescrDataData == *(const fi_tcl_MapGeographicType*)rfoCmp.poMapElementDescrDataData); //lint !e826
      break;
      case fi_tcl_e8_MapElementDescrType::FI_EN_T_E8_ROADCLASSCODE:
         bResult = bResult && (*(const fi_tcl_e8_RoadClassCode*)poMapElementDescrDataData == *(const fi_tcl_e8_RoadClassCode*)rfoCmp.poMapElementDescrDataData); //lint !e826
      break;
      case fi_tcl_e8_MapElementDescrType::FI_EN_T_B16_ROADATTRIBUTE:
         bResult = bResult && (*(const fi_tcl_b16_RoadAttribute*)poMapElementDescrDataData == *(const fi_tcl_b16_RoadAttribute*)rfoCmp.poMapElementDescrDataData); //lint !e826
      break;
      case fi_tcl_e8_MapElementDescrType::FI_EN_T_ROADNUMBER:
         bResult = bResult && (*(const fi_tcl_RoadNumber*)poMapElementDescrDataData == *(const fi_tcl_RoadNumber*)rfoCmp.poMapElementDescrDataData); //lint !e826
      break;
      case fi_tcl_e8_MapElementDescrType::FI_EN_T_E8_SURFACECOVERCODE:
         bResult = bResult && (*(const fi_tcl_e8_SurfaceCoverCode*)poMapElementDescrDataData == *(const fi_tcl_e8_SurfaceCoverCode*)rfoCmp.poMapElementDescrDataData); //lint !e826
      break;
      case fi_tcl_e8_MapElementDescrType::FI_EN_T_E16_NAVIEVENTVALUE:
         bResult = bResult && (*(const fi_tcl_e16_NaviEventValue*)poMapElementDescrDataData == *(const fi_tcl_e16_NaviEventValue*)rfoCmp.poMapElementDescrDataData); //lint !e826
      break;
      case fi_tcl_e8_MapElementDescrType::FI_EN_TMULTILANGUAGESTRING:
         bResult = bResult && (*(const fi_tclMultiLanguageString*)poMapElementDescrDataData == *(const fi_tclMultiLanguageString*)rfoCmp.poMapElementDescrDataData); //lint !e826
      break;
      }
   }
   else
   {
      bResult = bResult && (poMapElementDescrDataData == rfoCmp.poMapElementDescrDataData);
   }
   return bResult;
}

fi_tclInContext& fi_tcl_MapElementDescriptor::oRead(fi_tclInContext& oIn)
{
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   OSAL_DELETE poMapElementDescrDataData;
#else
   if (poMapElementDescrDataData)
   {
      poMapElementDescrDataData->vDestroy();
      OSAL_DELETE poMapElementDescrDataData;
   }
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
   oIn >> MapElementDescrDataType;
   switch(MapElementDescrDataType.enType)
   {
   case fi_tcl_e8_MapElementDescrType::FI_EN_T_RESERVED:
      poMapElementDescrDataData = OSAL_NEW fi_tcl_Reserved;
      break;
   case fi_tcl_e8_MapElementDescrType::FI_EN_TSTRING:
      poMapElementDescrDataData = OSAL_NEW fi_tclString;
      break;
   case fi_tcl_e8_MapElementDescrType::FI_EN_T_MAPGEOGRAPHICTYPE:
      poMapElementDescrDataData = OSAL_NEW fi_tcl_MapGeographicType;
      break;
   case fi_tcl_e8_MapElementDescrType::FI_EN_T_E8_ROADCLASSCODE:
      poMapElementDescrDataData = OSAL_NEW fi_tcl_e8_RoadClassCode;
      break;
   case fi_tcl_e8_MapElementDescrType::FI_EN_T_B16_ROADATTRIBUTE:
      poMapElementDescrDataData = OSAL_NEW fi_tcl_b16_RoadAttribute;
      break;
   case fi_tcl_e8_MapElementDescrType::FI_EN_T_ROADNUMBER:
      poMapElementDescrDataData = OSAL_NEW fi_tcl_RoadNumber;
      break;
   case fi_tcl_e8_MapElementDescrType::FI_EN_T_E8_SURFACECOVERCODE:
      poMapElementDescrDataData = OSAL_NEW fi_tcl_e8_SurfaceCoverCode;
      break;
   case fi_tcl_e8_MapElementDescrType::FI_EN_T_E16_NAVIEVENTVALUE:
      poMapElementDescrDataData = OSAL_NEW fi_tcl_e16_NaviEventValue;
      break;
   case fi_tcl_e8_MapElementDescrType::FI_EN_TMULTILANGUAGESTRING:
      poMapElementDescrDataData = OSAL_NEW fi_tclMultiLanguageString;
      break;
   default:
      oIn.Invalidate();
      poMapElementDescrDataData = OSAL_NULL;
   }
   if (poMapElementDescrDataData && oIn.bIsValid())
      poMapElementDescrDataData->oRead(oIn);
   else
      oIn.Invalidate();
   return oIn;
}

fi_tclOutContext& fi_tcl_MapElementDescriptor::oWrite(fi_tclOutContext& oOut) const
{
   oOut << MapElementDescrDataType;
   if (poMapElementDescrDataData)
   {
      poMapElementDescrDataData->oWrite(oOut);
   }
   else
   {
      oOut.Invalidate();
   }
   return oOut;
}

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
fi_tcl_MapElementDescription::fi_tcl_MapElementDescription(const fi_tcl_MapElementDescription& coRef):fi_tclVisitableTypeBase(coRef)
{
   Description = coRef.Description;
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
fi_tcl_MapElementDescription& fi_tcl_MapElementDescription::operator=(const fi_tcl_MapElementDescription& coRef)
{
   if (this == &coRef) return *this;
   Description = coRef.Description;
   return *this;
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
tVoid fi_tcl_MapElementDescription::vDestroy()
{
   {
      for (tU32 u32Idx = 0; u32Idx < Description.size(); ++u32Idx)
         Description[u32Idx].vDestroy();
   }
   Description.clear();
}

tU32 fi_tcl_MapElementDescription::u32GetSize(tU16 u16MajorVersion) const
{
   tU32 u32DynamicSize = 0;
   tU32 u32ListIdx;
   for (u32ListIdx = 0; u32ListIdx < Description.size(); ++u32ListIdx)
      u32DynamicSize += Description[u32ListIdx].u32GetSize(u16MajorVersion);
   return u32DynamicSize+4;
}

tBool fi_tcl_MapElementDescription::operator==(const fi_tcl_MapElementDescription& rfoCmp) const
{
   tBool bResult = true;
      bResult = bResult && (Description.size() == rfoCmp.Description.size());
      if (bResult)
      {
         for (tU32 u32Idx = 0; bResult && (u32Idx < Description.size()); ++u32Idx)
            bResult = bResult && (Description[u32Idx] == rfoCmp.Description[u32Idx]);
      }
   return bResult;
}

fi_tclInContext& fi_tcl_MapElementDescription::oRead(fi_tclInContext& oIn)
{
   {
      tU32 u32Length;
      tU32 u32Idx;
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
      for (u32Idx = 0; u32Idx < Description.size(); ++u32Idx)
      {
         Description[u32Idx].vDestroy();
      }
#endif // !VARIANT_S_FTR_ENABLE_DEEP_COPY
      oIn >> u32Length;
      Description.resize(u32Length);
      for (u32Idx = 0; u32Idx < u32Length; ++u32Idx)
      {
         oIn >> Description[u32Idx];
      }
   }
   return oIn;
}

fi_tclOutContext& fi_tcl_MapElementDescription::oWrite(fi_tclOutContext& oOut) const
{
   oOut << (tU32)Description.size();
   {
      for (tU32 u32Idx = 0; u32Idx < Description.size(); ++u32Idx)
         oOut << Description[u32Idx];
   }
   return oOut;
}

tU32 fi_tcl_e8_MapGeometricType::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 1;
}

tBool fi_tcl_e8_MapGeometricType::operator==(const fi_tcl_e8_MapGeometricType& rfoCmp) const
{
   return enType == rfoCmp.enType;
}

fi_tclInContext& fi_tcl_e8_MapGeometricType::oRead(fi_tclInContext& oIn)
{
   tU8 u8Value;
   oIn >> u8Value;
   enType = (tenType)u8Value;
   return oIn;
}

fi_tclOutContext& fi_tcl_e8_MapGeometricType::oWrite(fi_tclOutContext& oOut) const
{
   return oOut.oWrite((tU8)enType);
}

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
fi_tcl_MapGeographicType::fi_tcl_MapGeographicType(const fi_tcl_MapGeographicType& coRef):fi_tclVisitableTypeBase(coRef)
{
   MapGeographicType = coRef.MapGeographicType;
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
fi_tcl_MapGeographicType& fi_tcl_MapGeographicType::operator=(const fi_tcl_MapGeographicType& coRef)
{
   if (this == &coRef) return *this;
   MapGeographicType = coRef.MapGeographicType;
   return *this;
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
tU32 fi_tcl_MapGeographicType::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 2;
}

tBool fi_tcl_MapGeographicType::operator==(const fi_tcl_MapGeographicType& rfoCmp) const
{
   tBool bResult = true;
      bResult = bResult && (MapGeographicType == rfoCmp.MapGeographicType);
   return bResult;
}

fi_tclInContext& fi_tcl_MapGeographicType::oRead(fi_tclInContext& oIn)
{
   oIn >> MapGeographicType;
   return oIn;
}

fi_tclOutContext& fi_tcl_MapGeographicType::oWrite(fi_tclOutContext& oOut) const
{
   oOut << MapGeographicType;
   return oOut;
}

tU32 fi_tcl_e8_SurfaceCoverCode::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 1;
}

tBool fi_tcl_e8_SurfaceCoverCode::operator==(const fi_tcl_e8_SurfaceCoverCode& rfoCmp) const
{
   return enType == rfoCmp.enType;
}

fi_tclInContext& fi_tcl_e8_SurfaceCoverCode::oRead(fi_tclInContext& oIn)
{
   tU8 u8Value;
   oIn >> u8Value;
   enType = (tenType)u8Value;
   return oIn;
}

fi_tclOutContext& fi_tcl_e8_SurfaceCoverCode::oWrite(fi_tclOutContext& oOut) const
{
   return oOut.oWrite((tU8)enType);
}

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
fi_tcl_MapRegion::fi_tcl_MapRegion(const fi_tcl_MapRegion& coRef):fi_tclVisitableTypeBase(coRef)
{
   DataLevel = coRef.DataLevel;
   ExtPosNorthWest = coRef.ExtPosNorthWest;
   ExtPosSouthEast = coRef.ExtPosSouthEast;
   Identifier = coRef.Identifier;
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
fi_tcl_MapRegion& fi_tcl_MapRegion::operator=(const fi_tcl_MapRegion& coRef)
{
   if (this == &coRef) return *this;
   DataLevel = coRef.DataLevel;
   ExtPosNorthWest = coRef.ExtPosNorthWest;
   ExtPosSouthEast = coRef.ExtPosSouthEast;
   Identifier = coRef.Identifier;
   return *this;
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
tVoid fi_tcl_MapRegion::vDestroy()
{
   ExtPosNorthWest.vDestroy(); 
   ExtPosSouthEast.vDestroy(); 
}

tU32 fi_tcl_MapRegion::u32GetSize(tU16 u16MajorVersion) const
{
   tU32 u32DynamicSize = 0;
   if (7 <= u16MajorVersion)
   {
      u32DynamicSize += 4;
   }
   return u32DynamicSize+17;
}

tBool fi_tcl_MapRegion::operator==(const fi_tcl_MapRegion& rfoCmp) const
{
   tBool bResult = true;
      bResult = bResult && (DataLevel == rfoCmp.DataLevel);
      bResult = bResult && (ExtPosNorthWest == rfoCmp.ExtPosNorthWest);
      bResult = bResult && (ExtPosSouthEast == rfoCmp.ExtPosSouthEast);
      bResult = bResult && (Identifier == rfoCmp.Identifier);
   return bResult;
}

fi_tclInContext& fi_tcl_MapRegion::oRead(fi_tclInContext& oIn)
{
   oIn >> DataLevel;
   oIn >> ExtPosNorthWest;
   oIn >> ExtPosSouthEast;
   if (7 <= oIn.u16GetMajorVersion())
   {
      oIn >> Identifier;
   }
   return oIn;
}

fi_tclOutContext& fi_tcl_MapRegion::oWrite(fi_tclOutContext& oOut) const
{
   oOut << DataLevel;
   oOut << ExtPosNorthWest;
   oOut << ExtPosSouthEast;
   if (7 <= oOut.u16GetMajorVersion())
   {
      oOut << Identifier;
   }
   return oOut;
}

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
fi_tcl_MapDirectory::fi_tcl_MapDirectory(const fi_tcl_MapDirectory& coRef):fi_tclVisitableTypeBase(coRef)
{
   ExtPosNorthWest = coRef.ExtPosNorthWest;
   ExtPosSouthEast = coRef.ExtPosSouthEast;
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
fi_tcl_MapDirectory& fi_tcl_MapDirectory::operator=(const fi_tcl_MapDirectory& coRef)
{
   if (this == &coRef) return *this;
   ExtPosNorthWest = coRef.ExtPosNorthWest;
   ExtPosSouthEast = coRef.ExtPosSouthEast;
   return *this;
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
tVoid fi_tcl_MapDirectory::vDestroy()
{
   ExtPosNorthWest.vDestroy(); 
   ExtPosSouthEast.vDestroy(); 
}

tU32 fi_tcl_MapDirectory::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 16;
}

tBool fi_tcl_MapDirectory::operator==(const fi_tcl_MapDirectory& rfoCmp) const
{
   tBool bResult = true;
      bResult = bResult && (ExtPosNorthWest == rfoCmp.ExtPosNorthWest);
      bResult = bResult && (ExtPosSouthEast == rfoCmp.ExtPosSouthEast);
   return bResult;
}

fi_tclInContext& fi_tcl_MapDirectory::oRead(fi_tclInContext& oIn)
{
   oIn >> ExtPosNorthWest;
   oIn >> ExtPosSouthEast;
   return oIn;
}

fi_tclOutContext& fi_tcl_MapDirectory::oWrite(fi_tclOutContext& oOut) const
{
   oOut << ExtPosNorthWest;
   oOut << ExtPosSouthEast;
   return oOut;
}

tU32 fi_tcl_u16_MapScale::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 2;
}

tBool fi_tcl_u16_MapScale::operator==(const fi_tcl_u16_MapScale& rfoCmp) const
{
   return u16Value == rfoCmp.u16Value;
}

fi_tclInContext& fi_tcl_u16_MapScale::oRead(fi_tclInContext& oIn)
{
   return oIn >> u16Value;
}

fi_tclOutContext& fi_tcl_u16_MapScale::oWrite(fi_tclOutContext& oOut) const
{
   return oOut << u16Value;
}

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
fi_tcl_MapDataLevelDirectory::fi_tcl_MapDataLevelDirectory(const fi_tcl_MapDataLevelDirectory& coRef):fi_tclVisitableTypeBase(coRef)
{
   DataLevel = coRef.DataLevel;
   MinScale = coRef.MinScale;
   MaxScale = coRef.MaxScale;
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
fi_tcl_MapDataLevelDirectory& fi_tcl_MapDataLevelDirectory::operator=(const fi_tcl_MapDataLevelDirectory& coRef)
{
   if (this == &coRef) return *this;
   DataLevel = coRef.DataLevel;
   MinScale = coRef.MinScale;
   MaxScale = coRef.MaxScale;
   return *this;
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
tU32 fi_tcl_MapDataLevelDirectory::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 5;
}

tBool fi_tcl_MapDataLevelDirectory::operator==(const fi_tcl_MapDataLevelDirectory& rfoCmp) const
{
   tBool bResult = true;
      bResult = bResult && (DataLevel == rfoCmp.DataLevel);
      bResult = bResult && (MinScale == rfoCmp.MinScale);
      bResult = bResult && (MaxScale == rfoCmp.MaxScale);
   return bResult;
}

fi_tclInContext& fi_tcl_MapDataLevelDirectory::oRead(fi_tclInContext& oIn)
{
   oIn >> DataLevel;
   oIn >> MinScale;
   oIn >> MaxScale;
   return oIn;
}

fi_tclOutContext& fi_tcl_MapDataLevelDirectory::oWrite(fi_tclOutContext& oOut) const
{
   oOut << DataLevel;
   oOut << MinScale;
   oOut << MaxScale;
   return oOut;
}

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
fi_tcl_ScaleConfig::fi_tcl_ScaleConfig(const fi_tcl_ScaleConfig& coRef):fi_tclVisitableTypeBase(coRef)
{
   ScaleBarSize = coRef.ScaleBarSize;
   CacheRadius = coRef.CacheRadius;
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
fi_tcl_ScaleConfig& fi_tcl_ScaleConfig::operator=(const fi_tcl_ScaleConfig& coRef)
{
   if (this == &coRef) return *this;
   ScaleBarSize = coRef.ScaleBarSize;
   CacheRadius = coRef.CacheRadius;
   return *this;
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
tU32 fi_tcl_ScaleConfig::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 6;
}

tBool fi_tcl_ScaleConfig::operator==(const fi_tcl_ScaleConfig& rfoCmp) const
{
   tBool bResult = true;
      bResult = bResult && (ScaleBarSize == rfoCmp.ScaleBarSize);
      bResult = bResult && (CacheRadius == rfoCmp.CacheRadius);
   return bResult;
}

fi_tclInContext& fi_tcl_ScaleConfig::oRead(fi_tclInContext& oIn)
{
   oIn >> ScaleBarSize;
   oIn >> CacheRadius;
   return oIn;
}

fi_tclOutContext& fi_tcl_ScaleConfig::oWrite(fi_tclOutContext& oOut) const
{
   oOut << ScaleBarSize;
   oOut << CacheRadius;
   return oOut;
}

tU32 fi_tcl_s16_XPosScreen::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 2;
}

tBool fi_tcl_s16_XPosScreen::operator==(const fi_tcl_s16_XPosScreen& rfoCmp) const
{
   return s16Value == rfoCmp.s16Value;
}

fi_tclInContext& fi_tcl_s16_XPosScreen::oRead(fi_tclInContext& oIn)
{
   return oIn >> s16Value;
}

fi_tclOutContext& fi_tcl_s16_XPosScreen::oWrite(fi_tclOutContext& oOut) const
{
   return oOut << s16Value;
}

tU32 fi_tcl_s16_YPosScreen::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 2;
}

tBool fi_tcl_s16_YPosScreen::operator==(const fi_tcl_s16_YPosScreen& rfoCmp) const
{
   return s16Value == rfoCmp.s16Value;
}

fi_tclInContext& fi_tcl_s16_YPosScreen::oRead(fi_tclInContext& oIn)
{
   return oIn >> s16Value;
}

fi_tclOutContext& fi_tcl_s16_YPosScreen::oWrite(fi_tclOutContext& oOut) const
{
   return oOut << s16Value;
}

tU32 fi_tcl_u16_Direction::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 2;
}

tBool fi_tcl_u16_Direction::operator==(const fi_tcl_u16_Direction& rfoCmp) const
{
   return u16Value == rfoCmp.u16Value;
}

fi_tclInContext& fi_tcl_u16_Direction::oRead(fi_tclInContext& oIn)
{
   return oIn >> u16Value;
}

fi_tclOutContext& fi_tcl_u16_Direction::oWrite(fi_tclOutContext& oOut) const
{
   return oOut << u16Value;
}

tU32 fi_tcl_b16_HUCaps::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 2;
}

tBool fi_tcl_b16_HUCaps::operator==(const fi_tcl_b16_HUCaps& rfoCmp) const
{
   return u16Value == rfoCmp.u16Value;
}

fi_tclInContext& fi_tcl_b16_HUCaps::oRead(fi_tclInContext& oIn)
{
   return oIn >> u16Value;
}

fi_tclOutContext& fi_tcl_b16_HUCaps::oWrite(fi_tclOutContext& oOut) const
{
   return oOut << u16Value;
}

tU32 fi_tcl_b16_GlobalPreferences::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 2;
}

tBool fi_tcl_b16_GlobalPreferences::operator==(const fi_tcl_b16_GlobalPreferences& rfoCmp) const
{
   return u16Value == rfoCmp.u16Value;
}

fi_tclInContext& fi_tcl_b16_GlobalPreferences::oRead(fi_tclInContext& oIn)
{
   return oIn >> u16Value;
}

fi_tclOutContext& fi_tcl_b16_GlobalPreferences::oWrite(fi_tclOutContext& oOut) const
{
   return oOut << u16Value;
}

tU32 fi_tcl_b32_POI1::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 4;
}

tBool fi_tcl_b32_POI1::operator==(const fi_tcl_b32_POI1& rfoCmp) const
{
   return u32Value == rfoCmp.u32Value;
}

fi_tclInContext& fi_tcl_b32_POI1::oRead(fi_tclInContext& oIn)
{
   return oIn >> u32Value;
}

fi_tclOutContext& fi_tcl_b32_POI1::oWrite(fi_tclOutContext& oOut) const
{
   tU32 temp = u32Value;
   if (!(4 <= oOut.u16GetMajorVersion()))
      temp &= ~FI_C_U32_BIT_MP_POI_BUS;
   if (!(4 <= oOut.u16GetMajorVersion()))
      temp &= ~FI_C_U32_BIT_MP_POI_BANK;
   if (!(5 <= oOut.u16GetMajorVersion()))
      temp &= ~FI_C_U32_BIT_MP_POI_CAMPING;
   return oOut << temp;
}

tU32 fi_tcl_b32_POI2::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 4;
}

tBool fi_tcl_b32_POI2::operator==(const fi_tcl_b32_POI2& rfoCmp) const
{
   return u32Value == rfoCmp.u32Value;
}

fi_tclInContext& fi_tcl_b32_POI2::oRead(fi_tclInContext& oIn)
{
   return oIn >> u32Value;
}

fi_tclOutContext& fi_tcl_b32_POI2::oWrite(fi_tclOutContext& oOut) const
{
   tU32 temp = u32Value;
   if (!(4 <= oOut.u16GetMajorVersion()))
      temp &= ~FI_C_U32_BIT_MP_REP_GM;
   if (!(4 <= oOut.u16GetMajorVersion()))
      temp &= ~FI_C_U32_BIT_MP_REP_SGM;
   return oOut << temp;
}

tU32 fi_tcl_b32_ServiceStations::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 4;
}

tBool fi_tcl_b32_ServiceStations::operator==(const fi_tcl_b32_ServiceStations& rfoCmp) const
{
   return u32Value == rfoCmp.u32Value;
}

fi_tclInContext& fi_tcl_b32_ServiceStations::oRead(fi_tclInContext& oIn)
{
   return oIn >> u32Value;
}

fi_tclOutContext& fi_tcl_b32_ServiceStations::oWrite(fi_tclOutContext& oOut) const
{
   return oOut << u32Value;
}

tU32 fi_tcl_b32_ServiceStations2::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 4;
}

tBool fi_tcl_b32_ServiceStations2::operator==(const fi_tcl_b32_ServiceStations2& rfoCmp) const
{
   return u32Value == rfoCmp.u32Value;
}

fi_tclInContext& fi_tcl_b32_ServiceStations2::oRead(fi_tclInContext& oIn)
{
   return oIn >> u32Value;
}

fi_tclOutContext& fi_tcl_b32_ServiceStations2::oWrite(fi_tclOutContext& oOut) const
{
   tU32 temp = u32Value;
   if (!(6 <= oOut.u16GetMajorVersion()))
      temp &= ~FI_C_U32_BIT_MP_REP_DAF;
   if (!(6 <= oOut.u16GetMajorVersion()))
      temp &= ~FI_C_U32_BIT_MP_REP_MANTRUCK;
   if (!(6 <= oOut.u16GetMajorVersion()))
      temp &= ~FI_C_U32_BIT_MP_REP_NEOPLAN;
   return oOut << temp;
}

tU32 fi_tcl_b32_ServiceStations3::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 4;
}

tBool fi_tcl_b32_ServiceStations3::operator==(const fi_tcl_b32_ServiceStations3& rfoCmp) const
{
   return u32Value == rfoCmp.u32Value;
}

fi_tclInContext& fi_tcl_b32_ServiceStations3::oRead(fi_tclInContext& oIn)
{
   return oIn >> u32Value;
}

fi_tclOutContext& fi_tcl_b32_ServiceStations3::oWrite(fi_tclOutContext& oOut) const
{
   return oOut << u32Value;
}

tU32 fi_tcl_b8_FreewayFacilities::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 1;
}

tBool fi_tcl_b8_FreewayFacilities::operator==(const fi_tcl_b8_FreewayFacilities& rfoCmp) const
{
   return u8Value == rfoCmp.u8Value;
}

fi_tclInContext& fi_tcl_b8_FreewayFacilities::oRead(fi_tclInContext& oIn)
{
   return oIn >> u8Value;
}

fi_tclOutContext& fi_tcl_b8_FreewayFacilities::oWrite(fi_tclOutContext& oOut) const
{
   return oOut << u8Value;
}

tU32 fi_tcl_b8_ParkingAreas::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 1;
}

tBool fi_tcl_b8_ParkingAreas::operator==(const fi_tcl_b8_ParkingAreas& rfoCmp) const
{
   return u8Value == rfoCmp.u8Value;
}

fi_tclInContext& fi_tcl_b8_ParkingAreas::oRead(fi_tclInContext& oIn)
{
   return oIn >> u8Value;
}

fi_tclOutContext& fi_tcl_b8_ParkingAreas::oWrite(fi_tclOutContext& oOut) const
{
   return oOut << u8Value;
}

tU32 fi_tcl_b8_BorderLines::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 1;
}

tBool fi_tcl_b8_BorderLines::operator==(const fi_tcl_b8_BorderLines& rfoCmp) const
{
   return u8Value == rfoCmp.u8Value;
}

fi_tclInContext& fi_tcl_b8_BorderLines::oRead(fi_tclInContext& oIn)
{
   return oIn >> u8Value;
}

fi_tclOutContext& fi_tcl_b8_BorderLines::oWrite(fi_tclOutContext& oOut) const
{
   return oOut << u8Value;
}

tU32 fi_tcl_b8_RiverClass::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 1;
}

tBool fi_tcl_b8_RiverClass::operator==(const fi_tcl_b8_RiverClass& rfoCmp) const
{
   return u8Value == rfoCmp.u8Value;
}

fi_tclInContext& fi_tcl_b8_RiverClass::oRead(fi_tclInContext& oIn)
{
   return oIn >> u8Value;
}

fi_tclOutContext& fi_tcl_b8_RiverClass::oWrite(fi_tclOutContext& oOut) const
{
   return oOut << u8Value;
}

tU32 fi_tcl_b8_Channels::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 1;
}

tBool fi_tcl_b8_Channels::operator==(const fi_tcl_b8_Channels& rfoCmp) const
{
   return u8Value == rfoCmp.u8Value;
}

fi_tclInContext& fi_tcl_b8_Channels::oRead(fi_tclInContext& oIn)
{
   return oIn >> u8Value;
}

fi_tclOutContext& fi_tcl_b8_Channels::oWrite(fi_tclOutContext& oOut) const
{
   return oOut << u8Value;
}

tU32 fi_tcl_b32_Streets::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 4;
}

tBool fi_tcl_b32_Streets::operator==(const fi_tcl_b32_Streets& rfoCmp) const
{
   return u32Value == rfoCmp.u32Value;
}

fi_tclInContext& fi_tcl_b32_Streets::oRead(fi_tclInContext& oIn)
{
   return oIn >> u32Value;
}

fi_tclOutContext& fi_tcl_b32_Streets::oWrite(fi_tclOutContext& oOut) const
{
   return oOut << u32Value;
}

tU32 fi_tcl_b8_Areas::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 1;
}

tBool fi_tcl_b8_Areas::operator==(const fi_tcl_b8_Areas& rfoCmp) const
{
   return u8Value == rfoCmp.u8Value;
}

fi_tclInContext& fi_tcl_b8_Areas::oRead(fi_tclInContext& oIn)
{
   return oIn >> u8Value;
}

fi_tclOutContext& fi_tcl_b8_Areas::oWrite(fi_tclOutContext& oOut) const
{
   return oOut << u8Value;
}

tU32 fi_tcl_b32_CityCenters::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 4;
}

tBool fi_tcl_b32_CityCenters::operator==(const fi_tcl_b32_CityCenters& rfoCmp) const
{
   return u32Value == rfoCmp.u32Value;
}

fi_tclInContext& fi_tcl_b32_CityCenters::oRead(fi_tclInContext& oIn)
{
   return oIn >> u32Value;
}

fi_tclOutContext& fi_tcl_b32_CityCenters::oWrite(fi_tclOutContext& oOut) const
{
   return oOut << u32Value;
}

tU32 fi_tcl_b8_DirInfoStatus::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 1;
}

tBool fi_tcl_b8_DirInfoStatus::operator==(const fi_tcl_b8_DirInfoStatus& rfoCmp) const
{
   return u8Value == rfoCmp.u8Value;
}

fi_tclInContext& fi_tcl_b8_DirInfoStatus::oRead(fi_tclInContext& oIn)
{
   return oIn >> u8Value;
}

fi_tclOutContext& fi_tcl_b8_DirInfoStatus::oWrite(fi_tclOutContext& oOut) const
{
   return oOut << u8Value;
}

tU32 fi_tcl_e8_FilterAcceptance::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 1;
}

tBool fi_tcl_e8_FilterAcceptance::operator==(const fi_tcl_e8_FilterAcceptance& rfoCmp) const
{
   return enType == rfoCmp.enType;
}

fi_tclInContext& fi_tcl_e8_FilterAcceptance::oRead(fi_tclInContext& oIn)
{
   tU8 u8Value;
   oIn >> u8Value;
   enType = (tenType)u8Value;
   return oIn;
}

fi_tclOutContext& fi_tcl_e8_FilterAcceptance::oWrite(fi_tclOutContext& oOut) const
{
   return oOut.oWrite((tU8)enType);
}

tU32 fi_tcl_e8_DrawMode::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 1;
}

tBool fi_tcl_e8_DrawMode::operator==(const fi_tcl_e8_DrawMode& rfoCmp) const
{
   return enType == rfoCmp.enType;
}

fi_tclInContext& fi_tcl_e8_DrawMode::oRead(fi_tclInContext& oIn)
{
   tU8 u8Value;
   oIn >> u8Value;
   enType = (tenType)u8Value;
   return oIn;
}

fi_tclOutContext& fi_tcl_e8_DrawMode::oWrite(fi_tclOutContext& oOut) const
{
   return oOut.oWrite((tU8)enType);
}

tU32 fi_tcl_e8_MapState::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 1;
}

tBool fi_tcl_e8_MapState::operator==(const fi_tcl_e8_MapState& rfoCmp) const
{
   return enType == rfoCmp.enType;
}

fi_tclInContext& fi_tcl_e8_MapState::oRead(fi_tclInContext& oIn)
{
   tU8 u8Value;
   oIn >> u8Value;
   enType = (tenType)u8Value;
   return oIn;
}

fi_tclOutContext& fi_tcl_e8_MapState::oWrite(fi_tclOutContext& oOut) const
{
   return oOut.oWrite((tU8)enType);
}

tU32 fi_tcl_e8_MapMode::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 1;
}

tBool fi_tcl_e8_MapMode::operator==(const fi_tcl_e8_MapMode& rfoCmp) const
{
   return enType == rfoCmp.enType;
}

fi_tclInContext& fi_tcl_e8_MapMode::oRead(fi_tclInContext& oIn)
{
   tU8 u8Value;
   oIn >> u8Value;
   enType = (tenType)u8Value;
   return oIn;
}

fi_tclOutContext& fi_tcl_e8_MapMode::oWrite(fi_tclOutContext& oOut) const
{
   return oOut.oWrite((tU8)enType);
}

tU32 fi_tcl_e8_MapScale::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 1;
}

tBool fi_tcl_e8_MapScale::operator==(const fi_tcl_e8_MapScale& rfoCmp) const
{
   return enType == rfoCmp.enType;
}

fi_tclInContext& fi_tcl_e8_MapScale::oRead(fi_tclInContext& oIn)
{
   tU8 u8Value;
   oIn >> u8Value;
   enType = (tenType)u8Value;
   return oIn;
}

fi_tclOutContext& fi_tcl_e8_MapScale::oWrite(fi_tclOutContext& oOut) const
{
   return oOut.oWrite((tU8)enType);
}

tU32 fi_tcl_e8_MapAngle::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 1;
}

tBool fi_tcl_e8_MapAngle::operator==(const fi_tcl_e8_MapAngle& rfoCmp) const
{
   return enType == rfoCmp.enType;
}

fi_tclInContext& fi_tcl_e8_MapAngle::oRead(fi_tclInContext& oIn)
{
   tU8 u8Value;
   oIn >> u8Value;
   enType = (tenType)u8Value;
   return oIn;
}

fi_tclOutContext& fi_tcl_e8_MapAngle::oWrite(fi_tclOutContext& oOut) const
{
   return oOut.oWrite((tU8)enType);
}

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
fi_tcl_MapTransMatrix::fi_tcl_MapTransMatrix(const fi_tcl_MapTransMatrix& coRef):fi_tclVisitableTypeBase(coRef)
{
   m11 = coRef.m11;
   m12 = coRef.m12;
   m21 = coRef.m21;
   m22 = coRef.m22;
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
fi_tcl_MapTransMatrix& fi_tcl_MapTransMatrix::operator=(const fi_tcl_MapTransMatrix& coRef)
{
   if (this == &coRef) return *this;
   m11 = coRef.m11;
   m12 = coRef.m12;
   m21 = coRef.m21;
   m22 = coRef.m22;
   return *this;
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
tU32 fi_tcl_MapTransMatrix::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 16;
}

tBool fi_tcl_MapTransMatrix::operator==(const fi_tcl_MapTransMatrix& rfoCmp) const
{
   tBool bResult = true;
      bResult = bResult && (m11 == rfoCmp.m11);
      bResult = bResult && (m12 == rfoCmp.m12);
      bResult = bResult && (m21 == rfoCmp.m21);
      bResult = bResult && (m22 == rfoCmp.m22);
   return bResult;
}

fi_tclInContext& fi_tcl_MapTransMatrix::oRead(fi_tclInContext& oIn)
{
   oIn >> m11;
   oIn >> m12;
   oIn >> m21;
   oIn >> m22;
   return oIn;
}

fi_tclOutContext& fi_tcl_MapTransMatrix::oWrite(fi_tclOutContext& oOut) const
{
   oOut << m11;
   oOut << m12;
   oOut << m21;
   oOut << m22;
   return oOut;
}

tU32 fi_tcl_e8_BaudRate::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 1;
}

tBool fi_tcl_e8_BaudRate::operator==(const fi_tcl_e8_BaudRate& rfoCmp) const
{
   return enType == rfoCmp.enType;
}

fi_tclInContext& fi_tcl_e8_BaudRate::oRead(fi_tclInContext& oIn)
{
   tU8 u8Value;
   oIn >> u8Value;
   enType = (tenType)u8Value;
   return oIn;
}

fi_tclOutContext& fi_tcl_e8_BaudRate::oWrite(fi_tclOutContext& oOut) const
{
   return oOut.oWrite((tU8)enType);
}

tU32 fi_tcl_e16_IdxType::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 2;
}

tBool fi_tcl_e16_IdxType::operator==(const fi_tcl_e16_IdxType& rfoCmp) const
{
   return enType == rfoCmp.enType;
}

fi_tclInContext& fi_tcl_e16_IdxType::oRead(fi_tclInContext& oIn)
{
   tU16 u16Value;
   oIn >> u16Value;
   enType = (tenType)u16Value;
   return oIn;
}

fi_tclOutContext& fi_tcl_e16_IdxType::oWrite(fi_tclOutContext& oOut) const
{
   return oOut.oWrite((tU16)enType);
}

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
fi_tcl_PositionScreen::fi_tcl_PositionScreen(const fi_tcl_PositionScreen& coRef):fi_tclVisitableTypeBase(coRef)
{
   XPos = coRef.XPos;
   YPos = coRef.YPos;
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
fi_tcl_PositionScreen& fi_tcl_PositionScreen::operator=(const fi_tcl_PositionScreen& coRef)
{
   if (this == &coRef) return *this;
   XPos = coRef.XPos;
   YPos = coRef.YPos;
   return *this;
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
tU32 fi_tcl_PositionScreen::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 4;
}

tBool fi_tcl_PositionScreen::operator==(const fi_tcl_PositionScreen& rfoCmp) const
{
   tBool bResult = true;
      bResult = bResult && (XPos == rfoCmp.XPos);
      bResult = bResult && (YPos == rfoCmp.YPos);
   return bResult;
}

fi_tclInContext& fi_tcl_PositionScreen::oRead(fi_tclInContext& oIn)
{
   oIn >> XPos;
   oIn >> YPos;
   return oIn;
}

fi_tclOutContext& fi_tcl_PositionScreen::oWrite(fi_tclOutContext& oOut) const
{
   oOut << XPos;
   oOut << YPos;
   return oOut;
}

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
fi_tcl_IndexInfo::fi_tcl_IndexInfo(const fi_tcl_IndexInfo& coRef):fi_tclVisitableTypeBase(coRef)
{
   IdxType = coRef.IdxType;
   IdxString = coRef.IdxString;
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
fi_tcl_IndexInfo& fi_tcl_IndexInfo::operator=(const fi_tcl_IndexInfo& coRef)
{
   if (this == &coRef) return *this;
   IdxType = coRef.IdxType;
   IdxString = coRef.IdxString;
   return *this;
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
tVoid fi_tcl_IndexInfo::vDestroy()
{
   IdxString.vDestroy();
}

tU32 fi_tcl_IndexInfo::u32GetSize(tU16 u16MajorVersion) const
{
   return 2+IdxString.u32GetSize(u16MajorVersion);
}

tBool fi_tcl_IndexInfo::operator==(const fi_tcl_IndexInfo& rfoCmp) const
{
   tBool bResult = true;
      bResult = bResult && (IdxType == rfoCmp.IdxType);
      bResult = bResult && (IdxString == rfoCmp.IdxString);
   return bResult;
}

fi_tclInContext& fi_tcl_IndexInfo::oRead(fi_tclInContext& oIn)
{
   oIn >> IdxType;
   oIn >> IdxString;
   return oIn;
}

fi_tclOutContext& fi_tcl_IndexInfo::oWrite(fi_tclOutContext& oOut) const
{
   oOut << IdxType;
   oOut << IdxString;
   return oOut;
}

tU32 fi_tcl_b8_DrawOptions::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 1;
}

tBool fi_tcl_b8_DrawOptions::operator==(const fi_tcl_b8_DrawOptions& rfoCmp) const
{
   return u8Value == rfoCmp.u8Value;
}

fi_tclInContext& fi_tcl_b8_DrawOptions::oRead(fi_tclInContext& oIn)
{
   return oIn >> u8Value;
}

fi_tclOutContext& fi_tcl_b8_DrawOptions::oWrite(fi_tclOutContext& oOut) const
{
   tU8 temp = u8Value;
   if (!(5 <= oOut.u16GetMajorVersion()))
      temp &= ~FI_C_U8_BIT_MP_ENABLE_3D_VIEW;
   if (!(5 <= oOut.u16GetMajorVersion()))
      temp &= ~FI_C_U8_BIT_MP_ENABLE_SMOOTH_ZOOM;
   if (!(5 <= oOut.u16GetMajorVersion()))
      temp &= ~FI_C_U8_BIT_MP_ENABLE_ONEWAY_MARKS;
   return oOut << temp;
}

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
fi_tcl_RouteDescriptor::fi_tcl_RouteDescriptor(const fi_tcl_RouteDescriptor& coRef):fi_tclVisitableTypeBase(coRef)
{
   TripHandle = coRef.TripHandle;
   RouteHandle = coRef.RouteHandle;
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
fi_tcl_RouteDescriptor& fi_tcl_RouteDescriptor::operator=(const fi_tcl_RouteDescriptor& coRef)
{
   if (this == &coRef) return *this;
   TripHandle = coRef.TripHandle;
   RouteHandle = coRef.RouteHandle;
   return *this;
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
tU32 fi_tcl_RouteDescriptor::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 4;
}

tBool fi_tcl_RouteDescriptor::operator==(const fi_tcl_RouteDescriptor& rfoCmp) const
{
   tBool bResult = true;
      bResult = bResult && (TripHandle == rfoCmp.TripHandle);
      bResult = bResult && (RouteHandle == rfoCmp.RouteHandle);
   return bResult;
}

fi_tclInContext& fi_tcl_RouteDescriptor::oRead(fi_tclInContext& oIn)
{
   oIn >> TripHandle;
   oIn >> RouteHandle;
   return oIn;
}

fi_tclOutContext& fi_tcl_RouteDescriptor::oWrite(fi_tclOutContext& oOut) const
{
   oOut << TripHandle;
   oOut << RouteHandle;
   return oOut;
}

tU32 fi_tcl_e8_RouteDisplayType::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 1;
}

tBool fi_tcl_e8_RouteDisplayType::operator==(const fi_tcl_e8_RouteDisplayType& rfoCmp) const
{
   return enType == rfoCmp.enType;
}

fi_tclInContext& fi_tcl_e8_RouteDisplayType::oRead(fi_tclInContext& oIn)
{
   tU8 u8Value;
   oIn >> u8Value;
   enType = (tenType)u8Value;
   return oIn;
}

fi_tclOutContext& fi_tcl_e8_RouteDisplayType::oWrite(fi_tclOutContext& oOut) const
{
   return oOut.oWrite((tU8)enType);
}

tU32 fi_tcl_e16_USMarcLanguageCode::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 2;
}

tBool fi_tcl_e16_USMarcLanguageCode::operator==(const fi_tcl_e16_USMarcLanguageCode& rfoCmp) const
{
   return enType == rfoCmp.enType;
}

fi_tclInContext& fi_tcl_e16_USMarcLanguageCode::oRead(fi_tclInContext& oIn)
{
   tU16 u16Value;
   oIn >> u16Value;
   enType = (tenType)u16Value;
   return oIn;
}

fi_tclOutContext& fi_tcl_e16_USMarcLanguageCode::oWrite(fi_tclOutContext& oOut) const
{
   fi_tcl_e16_USMarcLanguageCode::tenType enData = enType;
   if ((enData == FI_EN_TLE) && !(5 <= oOut.u16GetMajorVersion()))
   {
      enData = FI_EN_UND;
   }
   if ((enData == FI_EN_THA) && !(5 <= oOut.u16GetMajorVersion()))
   {
      enData = FI_EN_UND;
   }
   if ((enData == FI_EN_MAY) && !(5 <= oOut.u16GetMajorVersion()))
   {
      enData = FI_EN_UND;
   }
   if ((enData == FI_EN_KOR) && !(6 <= oOut.u16GetMajorVersion()))
   {
      enData = FI_EN_UND;
   }
   if ((enData == FI_EN_IND) && !(6 <= oOut.u16GetMajorVersion()))
   {
      enData = FI_EN_UND;
   }
   if ((enData == FI_EN_ARA) && !(5 <= oOut.u16GetMajorVersion()))
   {
      enData = FI_EN_UND;
   }
   return oOut.oWrite((tU16)enData);
}

tU32 fi_tcl_u32CodePage::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 4;
}

tBool fi_tcl_u32CodePage::operator==(const fi_tcl_u32CodePage& rfoCmp) const
{
   return u32Value == rfoCmp.u32Value;
}

fi_tclInContext& fi_tcl_u32CodePage::oRead(fi_tclInContext& oIn)
{
   return oIn >> u32Value;
}

fi_tclOutContext& fi_tcl_u32CodePage::oWrite(fi_tclOutContext& oOut) const
{
   return oOut << u32Value;
}

tU32 fi_tcl_e8_LanguageDefaultFlag::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 1;
}

tBool fi_tcl_e8_LanguageDefaultFlag::operator==(const fi_tcl_e8_LanguageDefaultFlag& rfoCmp) const
{
   return enType == rfoCmp.enType;
}

fi_tclInContext& fi_tcl_e8_LanguageDefaultFlag::oRead(fi_tclInContext& oIn)
{
   tU8 u8Value;
   oIn >> u8Value;
   enType = (tenType)u8Value;
   return oIn;
}

fi_tclOutContext& fi_tcl_e8_LanguageDefaultFlag::oWrite(fi_tclOutContext& oOut) const
{
   return oOut.oWrite((tU8)enType);
}

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
fi_tcl_LanguageFilter::fi_tcl_LanguageFilter(const fi_tcl_LanguageFilter& coRef):fi_tclVisitableTypeBase(coRef)
{
   DefaultFlag = coRef.DefaultFlag;
   Language = coRef.Language;
   CodePageList = coRef.CodePageList;
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
fi_tcl_LanguageFilter& fi_tcl_LanguageFilter::operator=(const fi_tcl_LanguageFilter& coRef)
{
   if (this == &coRef) return *this;
   DefaultFlag = coRef.DefaultFlag;
   Language = coRef.Language;
   CodePageList = coRef.CodePageList;
   return *this;
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
tVoid fi_tcl_LanguageFilter::vDestroy()
{
   CodePageList.clear();
}

tU32 fi_tcl_LanguageFilter::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 7+CodePageList.size()*4;
}

tBool fi_tcl_LanguageFilter::operator==(const fi_tcl_LanguageFilter& rfoCmp) const
{
   tBool bResult = true;
      bResult = bResult && (DefaultFlag == rfoCmp.DefaultFlag);
      bResult = bResult && (Language == rfoCmp.Language);
      bResult = bResult && (CodePageList.size() == rfoCmp.CodePageList.size());
      if (bResult)
      {
         for (tU32 u32Idx = 0; bResult && (u32Idx < CodePageList.size()); ++u32Idx)
            bResult = bResult && (CodePageList[u32Idx] == rfoCmp.CodePageList[u32Idx]);
      }
   return bResult;
}

fi_tclInContext& fi_tcl_LanguageFilter::oRead(fi_tclInContext& oIn)
{
   oIn >> DefaultFlag;
   oIn >> Language;
   {
      tU32 u32Length;
      tU32 u32Idx;
      oIn >> u32Length;
      CodePageList.resize(u32Length);
      for (u32Idx = 0; u32Idx < u32Length; ++u32Idx)
      {
         oIn >> CodePageList[u32Idx];
      }
   }
   return oIn;
}

fi_tclOutContext& fi_tcl_LanguageFilter::oWrite(fi_tclOutContext& oOut) const
{
   oOut << DefaultFlag;
   oOut << Language;
   oOut << (tU32)CodePageList.size();
   {
      for (tU32 u32Idx = 0; u32Idx < CodePageList.size(); ++u32Idx)
         oOut << CodePageList[u32Idx];
   }
   return oOut;
}

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
fi_tcl_ZoomLevelConfig::fi_tcl_ZoomLevelConfig(const fi_tcl_ZoomLevelConfig& coRef):fi_tclVisitableTypeBase(coRef)
{
   SourceScale = coRef.SourceScale;
   ScaleBarSize = coRef.ScaleBarSize;
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
fi_tcl_ZoomLevelConfig& fi_tcl_ZoomLevelConfig::operator=(const fi_tcl_ZoomLevelConfig& coRef)
{
   if (this == &coRef) return *this;
   SourceScale = coRef.SourceScale;
   ScaleBarSize = coRef.ScaleBarSize;
   return *this;
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
tU32 fi_tcl_ZoomLevelConfig::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 2;
}

tBool fi_tcl_ZoomLevelConfig::operator==(const fi_tcl_ZoomLevelConfig& rfoCmp) const
{
   tBool bResult = true;
      bResult = bResult && (SourceScale == rfoCmp.SourceScale);
      bResult = bResult && (ScaleBarSize == rfoCmp.ScaleBarSize);
   return bResult;
}

fi_tclInContext& fi_tcl_ZoomLevelConfig::oRead(fi_tclInContext& oIn)
{
   oIn >> SourceScale;
   oIn >> ScaleBarSize;
   return oIn;
}

fi_tclOutContext& fi_tcl_ZoomLevelConfig::oWrite(fi_tclOutContext& oOut) const
{
   oOut << SourceScale;
   oOut << ScaleBarSize;
   return oOut;
}

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
fi_tcl_DestinationFlag::fi_tcl_DestinationFlag(const fi_tcl_DestinationFlag& coRef):fi_tclVisitableTypeBase(coRef)
{
   DestPosition = coRef.DestPosition;
   DestinationType = coRef.DestinationType;
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
fi_tcl_DestinationFlag& fi_tcl_DestinationFlag::operator=(const fi_tcl_DestinationFlag& coRef)
{
   if (this == &coRef) return *this;
   DestPosition = coRef.DestPosition;
   DestinationType = coRef.DestinationType;
   return *this;
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
tVoid fi_tcl_DestinationFlag::vDestroy()
{
   DestPosition.vDestroy(); 
}

tU32 fi_tcl_DestinationFlag::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 9;
}

tBool fi_tcl_DestinationFlag::operator==(const fi_tcl_DestinationFlag& rfoCmp) const
{
   tBool bResult = true;
      bResult = bResult && (DestPosition == rfoCmp.DestPosition);
      bResult = bResult && (DestinationType == rfoCmp.DestinationType);
   return bResult;
}

fi_tclInContext& fi_tcl_DestinationFlag::oRead(fi_tclInContext& oIn)
{
   oIn >> DestPosition;
   oIn >> DestinationType;
   return oIn;
}

fi_tclOutContext& fi_tcl_DestinationFlag::oWrite(fi_tclOutContext& oOut) const
{
   oOut << DestPosition;
   oOut << DestinationType;
   return oOut;
}

tU32 fi_tcl_b16_TheaterDescriptionRequest::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 2;
}

tBool fi_tcl_b16_TheaterDescriptionRequest::operator==(const fi_tcl_b16_TheaterDescriptionRequest& rfoCmp) const
{
   return u16Value == rfoCmp.u16Value;
}

fi_tclInContext& fi_tcl_b16_TheaterDescriptionRequest::oRead(fi_tclInContext& oIn)
{
   return oIn >> u16Value;
}

fi_tclOutContext& fi_tcl_b16_TheaterDescriptionRequest::oWrite(fi_tclOutContext& oOut) const
{
   return oOut << u16Value;
}

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
fi_tcl_TheaterInfo::fi_tcl_TheaterInfo(const fi_tcl_TheaterInfo& coRef):fi_tclVisitableTypeBase(coRef)
{
   State = coRef.State;
   Name = coRef.Name;
   Address = coRef.Address;
   City = coRef.City;
   Zip = coRef.Zip;
   Phone = coRef.Phone;
   Position = coRef.Position;
   ListOfAmenities = coRef.ListOfAmenities;
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
fi_tcl_TheaterInfo& fi_tcl_TheaterInfo::operator=(const fi_tcl_TheaterInfo& coRef)
{
   if (this == &coRef) return *this;
   State = coRef.State;
   Name = coRef.Name;
   Address = coRef.Address;
   City = coRef.City;
   Zip = coRef.Zip;
   Phone = coRef.Phone;
   Position = coRef.Position;
   ListOfAmenities = coRef.ListOfAmenities;
   return *this;
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
tVoid fi_tcl_TheaterInfo::vDestroy()
{
   State.vDestroy(); 
   Name.vDestroy();
   Address.vDestroy();
   City.vDestroy();
   Zip.vDestroy();
   Phone.vDestroy();
   Position.vDestroy(); 
   {
      for (tU32 u32Idx = 0; u32Idx < ListOfAmenities.size(); ++u32Idx)
         ListOfAmenities[u32Idx].vDestroy();
   }
   ListOfAmenities.clear();
}

tU32 fi_tcl_TheaterInfo::u32GetSize(tU16 u16MajorVersion) const
{
   return 12+State.u32GetSize(u16MajorVersion)+Name.u32GetSize(u16MajorVersion)+Address.u32GetSize(u16MajorVersion)+City.u32GetSize(u16MajorVersion)+Zip.u32GetSize(u16MajorVersion)+Phone.u32GetSize(u16MajorVersion)+ListOfAmenities.size()*1;
}

tBool fi_tcl_TheaterInfo::operator==(const fi_tcl_TheaterInfo& rfoCmp) const
{
   tBool bResult = true;
      bResult = bResult && (State == rfoCmp.State);
      bResult = bResult && (Name == rfoCmp.Name);
      bResult = bResult && (Address == rfoCmp.Address);
      bResult = bResult && (City == rfoCmp.City);
      bResult = bResult && (Zip == rfoCmp.Zip);
      bResult = bResult && (Phone == rfoCmp.Phone);
      bResult = bResult && (Position == rfoCmp.Position);
      bResult = bResult && (ListOfAmenities.size() == rfoCmp.ListOfAmenities.size());
      if (bResult)
      {
         for (tU32 u32Idx = 0; bResult && (u32Idx < ListOfAmenities.size()); ++u32Idx)
            bResult = bResult && (ListOfAmenities[u32Idx] == rfoCmp.ListOfAmenities[u32Idx]);
      }
   return bResult;
}

fi_tclInContext& fi_tcl_TheaterInfo::oRead(fi_tclInContext& oIn)
{
   oIn >> State;
   oIn >> Name;
   oIn >> Address;
   oIn >> City;
   oIn >> Zip;
   oIn >> Phone;
   oIn >> Position;
   {
      tU32 u32Length;
      tU32 u32Idx;
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
      for (u32Idx = 0; u32Idx < ListOfAmenities.size(); ++u32Idx)
      {
         ListOfAmenities[u32Idx].vDestroy();
      }
#endif // !VARIANT_S_FTR_ENABLE_DEEP_COPY
      oIn >> u32Length;
      ListOfAmenities.resize(u32Length);
      for (u32Idx = 0; u32Idx < u32Length; ++u32Idx)
      {
         oIn >> ListOfAmenities[u32Idx];
      }
   }
   return oIn;
}

fi_tclOutContext& fi_tcl_TheaterInfo::oWrite(fi_tclOutContext& oOut) const
{
   oOut << State;
   oOut << Name;
   oOut << Address;
   oOut << City;
   oOut << Zip;
   oOut << Phone;
   oOut << Position;
   oOut << (tU32)ListOfAmenities.size();
   {
      for (tU32 u32Idx = 0; u32Idx < ListOfAmenities.size(); ++u32Idx)
         oOut << ListOfAmenities[u32Idx];
   }
   return oOut;
}

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
fi_tcl_MovieId::fi_tcl_MovieId(const fi_tcl_MovieId& coRef):fi_tclVisitableTypeBase(coRef)
{
   MovieId = coRef.MovieId;
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
fi_tcl_MovieId& fi_tcl_MovieId::operator=(const fi_tcl_MovieId& coRef)
{
   if (this == &coRef) return *this;
   MovieId = coRef.MovieId;
   return *this;
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
tU32 fi_tcl_MovieId::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 1;
}

tBool fi_tcl_MovieId::operator==(const fi_tcl_MovieId& rfoCmp) const
{
   tBool bResult = true;
      bResult = bResult && (MovieId == rfoCmp.MovieId);
   return bResult;
}

fi_tclInContext& fi_tcl_MovieId::oRead(fi_tclInContext& oIn)
{
   oIn >> MovieId;
   return oIn;
}

fi_tclOutContext& fi_tcl_MovieId::oWrite(fi_tclOutContext& oOut) const
{
   oOut << MovieId;
   return oOut;
}

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
fi_tcl_Rating::fi_tcl_Rating(const fi_tcl_Rating& coRef):fi_tclVisitableTypeBase(coRef)
{
   System = coRef.System;
   Rating = coRef.Rating;
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
fi_tcl_Rating& fi_tcl_Rating::operator=(const fi_tcl_Rating& coRef)
{
   if (this == &coRef) return *this;
   System = coRef.System;
   Rating = coRef.Rating;
   return *this;
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
tVoid fi_tcl_Rating::vDestroy()
{
   System.vDestroy();
   Rating.vDestroy();
}

tU32 fi_tcl_Rating::u32GetSize(tU16 u16MajorVersion) const
{
   return 0+System.u32GetSize(u16MajorVersion)+Rating.u32GetSize(u16MajorVersion);
}

tBool fi_tcl_Rating::operator==(const fi_tcl_Rating& rfoCmp) const
{
   tBool bResult = true;
      bResult = bResult && (System == rfoCmp.System);
      bResult = bResult && (Rating == rfoCmp.Rating);
   return bResult;
}

fi_tclInContext& fi_tcl_Rating::oRead(fi_tclInContext& oIn)
{
   oIn >> System;
   oIn >> Rating;
   return oIn;
}

fi_tclOutContext& fi_tcl_Rating::oWrite(fi_tclOutContext& oOut) const
{
   oOut << System;
   oOut << Rating;
   return oOut;
}

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
fi_tcl_RunTime::fi_tcl_RunTime(const fi_tcl_RunTime& coRef):fi_tclVisitableTypeBase(coRef)
{
   RunTime = coRef.RunTime;
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
fi_tcl_RunTime& fi_tcl_RunTime::operator=(const fi_tcl_RunTime& coRef)
{
   if (this == &coRef) return *this;
   RunTime = coRef.RunTime;
   return *this;
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
tU32 fi_tcl_RunTime::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 1;
}

tBool fi_tcl_RunTime::operator==(const fi_tcl_RunTime& rfoCmp) const
{
   tBool bResult = true;
      bResult = bResult && (RunTime == rfoCmp.RunTime);
   return bResult;
}

fi_tclInContext& fi_tcl_RunTime::oRead(fi_tclInContext& oIn)
{
   oIn >> RunTime;
   return oIn;
}

fi_tclOutContext& fi_tcl_RunTime::oWrite(fi_tclOutContext& oOut) const
{
   oOut << RunTime;
   return oOut;
}

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
fi_tcl_MovieName::fi_tcl_MovieName(const fi_tcl_MovieName& coRef):fi_tclVisitableTypeBase(coRef)
{
   Name = coRef.Name;
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
fi_tcl_MovieName& fi_tcl_MovieName::operator=(const fi_tcl_MovieName& coRef)
{
   if (this == &coRef) return *this;
   Name = coRef.Name;
   return *this;
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
tVoid fi_tcl_MovieName::vDestroy()
{
   Name.vDestroy();
}

tU32 fi_tcl_MovieName::u32GetSize(tU16 u16MajorVersion) const
{
   return 0+Name.u32GetSize(u16MajorVersion);
}

tBool fi_tcl_MovieName::operator==(const fi_tcl_MovieName& rfoCmp) const
{
   tBool bResult = true;
      bResult = bResult && (Name == rfoCmp.Name);
   return bResult;
}

fi_tclInContext& fi_tcl_MovieName::oRead(fi_tclInContext& oIn)
{
   oIn >> Name;
   return oIn;
}

fi_tclOutContext& fi_tcl_MovieName::oWrite(fi_tclOutContext& oOut) const
{
   oOut << Name;
   return oOut;
}

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
fi_tcl_MovieDescription::fi_tcl_MovieDescription(const fi_tcl_MovieDescription& coRef):fi_tclVisitableTypeBase(coRef)
{
   ID = coRef.ID;
   Name = coRef.Name;
   Rating = coRef.Rating;
   RunTime = coRef.RunTime;
   SizeOfCompleteActorList = coRef.SizeOfCompleteActorList;
   Actors = coRef.Actors;
   SizeOfCompleteSynopsis = coRef.SizeOfCompleteSynopsis;
   Synopsis = coRef.Synopsis;
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
fi_tcl_MovieDescription& fi_tcl_MovieDescription::operator=(const fi_tcl_MovieDescription& coRef)
{
   if (this == &coRef) return *this;
   ID = coRef.ID;
   Name = coRef.Name;
   Rating = coRef.Rating;
   RunTime = coRef.RunTime;
   SizeOfCompleteActorList = coRef.SizeOfCompleteActorList;
   Actors = coRef.Actors;
   SizeOfCompleteSynopsis = coRef.SizeOfCompleteSynopsis;
   Synopsis = coRef.Synopsis;
   return *this;
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
tVoid fi_tcl_MovieDescription::vDestroy()
{
   ID.vDestroy(); 
   Name.vDestroy(); 
   {
      for (tU32 u32Idx = 0; u32Idx < Rating.size(); ++u32Idx)
         Rating[u32Idx].vDestroy();
   }
   Rating.clear();
   RunTime.vDestroy(); 
   Actors.vDestroy();
   Synopsis.vDestroy();
}

tU32 fi_tcl_MovieDescription::u32GetSize(tU16 u16MajorVersion) const
{
   tU32 u32DynamicSize = 0;
   tU32 u32ListIdx;
   for (u32ListIdx = 0; u32ListIdx < Rating.size(); ++u32ListIdx)
      u32DynamicSize += Rating[u32ListIdx].u32GetSize(u16MajorVersion);
   return u32DynamicSize+14+Name.u32GetSize(u16MajorVersion)+Actors.u32GetSize(u16MajorVersion)+Synopsis.u32GetSize(u16MajorVersion);
}

tBool fi_tcl_MovieDescription::operator==(const fi_tcl_MovieDescription& rfoCmp) const
{
   tBool bResult = true;
      bResult = bResult && (ID == rfoCmp.ID);
      bResult = bResult && (Name == rfoCmp.Name);
      bResult = bResult && (Rating.size() == rfoCmp.Rating.size());
      if (bResult)
      {
         for (tU32 u32Idx = 0; bResult && (u32Idx < Rating.size()); ++u32Idx)
            bResult = bResult && (Rating[u32Idx] == rfoCmp.Rating[u32Idx]);
      }
      bResult = bResult && (RunTime == rfoCmp.RunTime);
      bResult = bResult && (SizeOfCompleteActorList == rfoCmp.SizeOfCompleteActorList);
      bResult = bResult && (Actors == rfoCmp.Actors);
      bResult = bResult && (SizeOfCompleteSynopsis == rfoCmp.SizeOfCompleteSynopsis);
      bResult = bResult && (Synopsis == rfoCmp.Synopsis);
   return bResult;
}

fi_tclInContext& fi_tcl_MovieDescription::oRead(fi_tclInContext& oIn)
{
   oIn >> ID;
   oIn >> Name;
   {
      tU32 u32Length;
      tU32 u32Idx;
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
      for (u32Idx = 0; u32Idx < Rating.size(); ++u32Idx)
      {
         Rating[u32Idx].vDestroy();
      }
#endif // !VARIANT_S_FTR_ENABLE_DEEP_COPY
      oIn >> u32Length;
      Rating.resize(u32Length);
      for (u32Idx = 0; u32Idx < u32Length; ++u32Idx)
      {
         oIn >> Rating[u32Idx];
      }
   }
   oIn >> RunTime;
   oIn >> SizeOfCompleteActorList;
   oIn >> Actors;
   oIn >> SizeOfCompleteSynopsis;
   oIn >> Synopsis;
   return oIn;
}

fi_tclOutContext& fi_tcl_MovieDescription::oWrite(fi_tclOutContext& oOut) const
{
   oOut << ID;
   oOut << Name;
   oOut << (tU32)Rating.size();
   {
      for (tU32 u32Idx = 0; u32Idx < Rating.size(); ++u32Idx)
         oOut << Rating[u32Idx];
   }
   oOut << RunTime;
   oOut << SizeOfCompleteActorList;
   oOut << Actors;
   oOut << SizeOfCompleteSynopsis;
   oOut << Synopsis;
   return oOut;
}

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
fi_tcl_TheaterId::fi_tcl_TheaterId(const fi_tcl_TheaterId& coRef):fi_tclVisitableTypeBase(coRef)
{
   TheaterId = coRef.TheaterId;
   State = coRef.State;
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
fi_tcl_TheaterId& fi_tcl_TheaterId::operator=(const fi_tcl_TheaterId& coRef)
{
   if (this == &coRef) return *this;
   TheaterId = coRef.TheaterId;
   State = coRef.State;
   return *this;
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
tVoid fi_tcl_TheaterId::vDestroy()
{
   State.vDestroy(); 
}

tU32 fi_tcl_TheaterId::u32GetSize(tU16 u16MajorVersion) const
{
   return 4+State.u32GetSize(u16MajorVersion);
}

tBool fi_tcl_TheaterId::operator==(const fi_tcl_TheaterId& rfoCmp) const
{
   tBool bResult = true;
      bResult = bResult && (TheaterId == rfoCmp.TheaterId);
      bResult = bResult && (State == rfoCmp.State);
   return bResult;
}

fi_tclInContext& fi_tcl_TheaterId::oRead(fi_tclInContext& oIn)
{
   oIn >> TheaterId;
   oIn >> State;
   return oIn;
}

fi_tclOutContext& fi_tcl_TheaterId::oWrite(fi_tclOutContext& oOut) const
{
   oOut << TheaterId;
   oOut << State;
   return oOut;
}

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
fi_tcl_Showing::fi_tcl_Showing(const fi_tcl_Showing& coRef):fi_tclVisitableTypeBase(coRef)
{
   Time = coRef.Time;
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
fi_tcl_Showing& fi_tcl_Showing::operator=(const fi_tcl_Showing& coRef)
{
   if (this == &coRef) return *this;
   Time = coRef.Time;
   return *this;
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
tVoid fi_tcl_Showing::vDestroy()
{
   Time.vDestroy(); 
}

tU32 fi_tcl_Showing::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 4;
}

tBool fi_tcl_Showing::operator==(const fi_tcl_Showing& rfoCmp) const
{
   tBool bResult = true;
      bResult = bResult && (Time == rfoCmp.Time);
   return bResult;
}

fi_tclInContext& fi_tcl_Showing::oRead(fi_tclInContext& oIn)
{
   oIn >> Time;
   return oIn;
}

fi_tclOutContext& fi_tcl_Showing::oWrite(fi_tclOutContext& oOut) const
{
   oOut << Time;
   return oOut;
}

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
fi_tcl_MovieTimes::fi_tcl_MovieTimes(const fi_tcl_MovieTimes& coRef):fi_tclVisitableTypeBase(coRef)
{
   MovieId = coRef.MovieId;
   Rating = coRef.Rating;
   Showings = coRef.Showings;
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
fi_tcl_MovieTimes& fi_tcl_MovieTimes::operator=(const fi_tcl_MovieTimes& coRef)
{
   if (this == &coRef) return *this;
   MovieId = coRef.MovieId;
   Rating = coRef.Rating;
   Showings = coRef.Showings;
   return *this;
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
tVoid fi_tcl_MovieTimes::vDestroy()
{
   MovieId.vDestroy(); 
   Rating.vDestroy();
   {
      for (tU32 u32Idx = 0; u32Idx < Showings.size(); ++u32Idx)
         Showings[u32Idx].vDestroy();
   }
   Showings.clear();
}

tU32 fi_tcl_MovieTimes::u32GetSize(tU16 u16MajorVersion) const
{
   return 5+Rating.u32GetSize(u16MajorVersion)+Showings.size()*4;
}

tBool fi_tcl_MovieTimes::operator==(const fi_tcl_MovieTimes& rfoCmp) const
{
   tBool bResult = true;
      bResult = bResult && (MovieId == rfoCmp.MovieId);
      bResult = bResult && (Rating == rfoCmp.Rating);
      bResult = bResult && (Showings.size() == rfoCmp.Showings.size());
      if (bResult)
      {
         for (tU32 u32Idx = 0; bResult && (u32Idx < Showings.size()); ++u32Idx)
            bResult = bResult && (Showings[u32Idx] == rfoCmp.Showings[u32Idx]);
      }
   return bResult;
}

fi_tclInContext& fi_tcl_MovieTimes::oRead(fi_tclInContext& oIn)
{
   oIn >> MovieId;
   oIn >> Rating;
   {
      tU32 u32Length;
      tU32 u32Idx;
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
      for (u32Idx = 0; u32Idx < Showings.size(); ++u32Idx)
      {
         Showings[u32Idx].vDestroy();
      }
#endif // !VARIANT_S_FTR_ENABLE_DEEP_COPY
      oIn >> u32Length;
      Showings.resize(u32Length);
      for (u32Idx = 0; u32Idx < u32Length; ++u32Idx)
      {
         oIn >> Showings[u32Idx];
      }
   }
   return oIn;
}

fi_tclOutContext& fi_tcl_MovieTimes::oWrite(fi_tclOutContext& oOut) const
{
   oOut << MovieId;
   oOut << Rating;
   oOut << (tU32)Showings.size();
   {
      for (tU32 u32Idx = 0; u32Idx < Showings.size(); ++u32Idx)
         oOut << Showings[u32Idx];
   }
   return oOut;
}

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
fi_tcl_TheaterMovieTimes::fi_tcl_TheaterMovieTimes(const fi_tcl_TheaterMovieTimes& coRef):fi_tclVisitableTypeBase(coRef)
{
   Theater = coRef.Theater;
   MovieTimes = coRef.MovieTimes;
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
fi_tcl_TheaterMovieTimes& fi_tcl_TheaterMovieTimes::operator=(const fi_tcl_TheaterMovieTimes& coRef)
{
   if (this == &coRef) return *this;
   Theater = coRef.Theater;
   MovieTimes = coRef.MovieTimes;
   return *this;
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
tVoid fi_tcl_TheaterMovieTimes::vDestroy()
{
   Theater.vDestroy(); 
   {
      for (tU32 u32Idx = 0; u32Idx < MovieTimes.size(); ++u32Idx)
         MovieTimes[u32Idx].vDestroy();
   }
   MovieTimes.clear();
}

tU32 fi_tcl_TheaterMovieTimes::u32GetSize(tU16 u16MajorVersion) const
{
   tU32 u32DynamicSize = 0;
   tU32 u32ListIdx;
   for (u32ListIdx = 0; u32ListIdx < MovieTimes.size(); ++u32ListIdx)
      u32DynamicSize += MovieTimes[u32ListIdx].u32GetSize(u16MajorVersion);
   return u32DynamicSize+4+Theater.u32GetSize(u16MajorVersion);
}

tBool fi_tcl_TheaterMovieTimes::operator==(const fi_tcl_TheaterMovieTimes& rfoCmp) const
{
   tBool bResult = true;
      bResult = bResult && (Theater == rfoCmp.Theater);
      bResult = bResult && (MovieTimes.size() == rfoCmp.MovieTimes.size());
      if (bResult)
      {
         for (tU32 u32Idx = 0; bResult && (u32Idx < MovieTimes.size()); ++u32Idx)
            bResult = bResult && (MovieTimes[u32Idx] == rfoCmp.MovieTimes[u32Idx]);
      }
   return bResult;
}

fi_tclInContext& fi_tcl_TheaterMovieTimes::oRead(fi_tclInContext& oIn)
{
   oIn >> Theater;
   {
      tU32 u32Length;
      tU32 u32Idx;
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
      for (u32Idx = 0; u32Idx < MovieTimes.size(); ++u32Idx)
      {
         MovieTimes[u32Idx].vDestroy();
      }
#endif // !VARIANT_S_FTR_ENABLE_DEEP_COPY
      oIn >> u32Length;
      MovieTimes.resize(u32Length);
      for (u32Idx = 0; u32Idx < u32Length; ++u32Idx)
      {
         oIn >> MovieTimes[u32Idx];
      }
   }
   return oIn;
}

fi_tclOutContext& fi_tcl_TheaterMovieTimes::oWrite(fi_tclOutContext& oOut) const
{
   oOut << Theater;
   oOut << (tU32)MovieTimes.size();
   {
      for (tU32 u32Idx = 0; u32Idx < MovieTimes.size(); ++u32Idx)
         oOut << MovieTimes[u32Idx];
   }
   return oOut;
}

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
fi_tcl_TheaterMovieTimesForPosition::fi_tcl_TheaterMovieTimesForPosition(const fi_tcl_TheaterMovieTimesForPosition& coRef):fi_tclVisitableTypeBase(coRef)
{
   Position = coRef.Position;
   TheaterMovieTimes = coRef.TheaterMovieTimes;
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
fi_tcl_TheaterMovieTimesForPosition& fi_tcl_TheaterMovieTimesForPosition::operator=(const fi_tcl_TheaterMovieTimesForPosition& coRef)
{
   if (this == &coRef) return *this;
   Position = coRef.Position;
   TheaterMovieTimes = coRef.TheaterMovieTimes;
   return *this;
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
tVoid fi_tcl_TheaterMovieTimesForPosition::vDestroy()
{
   Position.vDestroy(); 
   {
      for (tU32 u32Idx = 0; u32Idx < TheaterMovieTimes.size(); ++u32Idx)
         TheaterMovieTimes[u32Idx].vDestroy();
   }
   TheaterMovieTimes.clear();
}

tU32 fi_tcl_TheaterMovieTimesForPosition::u32GetSize(tU16 u16MajorVersion) const
{
   tU32 u32DynamicSize = 0;
   tU32 u32ListIdx;
   for (u32ListIdx = 0; u32ListIdx < TheaterMovieTimes.size(); ++u32ListIdx)
      u32DynamicSize += TheaterMovieTimes[u32ListIdx].u32GetSize(u16MajorVersion);
   return u32DynamicSize+12;
}

tBool fi_tcl_TheaterMovieTimesForPosition::operator==(const fi_tcl_TheaterMovieTimesForPosition& rfoCmp) const
{
   tBool bResult = true;
      bResult = bResult && (Position == rfoCmp.Position);
      bResult = bResult && (TheaterMovieTimes.size() == rfoCmp.TheaterMovieTimes.size());
      if (bResult)
      {
         for (tU32 u32Idx = 0; bResult && (u32Idx < TheaterMovieTimes.size()); ++u32Idx)
            bResult = bResult && (TheaterMovieTimes[u32Idx] == rfoCmp.TheaterMovieTimes[u32Idx]);
      }
   return bResult;
}

fi_tclInContext& fi_tcl_TheaterMovieTimesForPosition::oRead(fi_tclInContext& oIn)
{
   oIn >> Position;
   {
      tU32 u32Length;
      tU32 u32Idx;
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
      for (u32Idx = 0; u32Idx < TheaterMovieTimes.size(); ++u32Idx)
      {
         TheaterMovieTimes[u32Idx].vDestroy();
      }
#endif // !VARIANT_S_FTR_ENABLE_DEEP_COPY
      oIn >> u32Length;
      TheaterMovieTimes.resize(u32Length);
      for (u32Idx = 0; u32Idx < u32Length; ++u32Idx)
      {
         oIn >> TheaterMovieTimes[u32Idx];
      }
   }
   return oIn;
}

fi_tclOutContext& fi_tcl_TheaterMovieTimesForPosition::oWrite(fi_tclOutContext& oOut) const
{
   oOut << Position;
   oOut << (tU32)TheaterMovieTimes.size();
   {
      for (tU32 u32Idx = 0; u32Idx < TheaterMovieTimes.size(); ++u32Idx)
         oOut << TheaterMovieTimes[u32Idx];
   }
   return oOut;
}

tU32 fi_tcl_e8_DetailGrade::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 1;
}

tBool fi_tcl_e8_DetailGrade::operator==(const fi_tcl_e8_DetailGrade& rfoCmp) const
{
   return enType == rfoCmp.enType;
}

fi_tclInContext& fi_tcl_e8_DetailGrade::oRead(fi_tclInContext& oIn)
{
   tU8 u8Value;
   oIn >> u8Value;
   enType = (tenType)u8Value;
   return oIn;
}

fi_tclOutContext& fi_tcl_e8_DetailGrade::oWrite(fi_tclOutContext& oOut) const
{
   return oOut.oWrite((tU8)enType);
}

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
fi_tcl_BriefMovieDescription::fi_tcl_BriefMovieDescription(const fi_tcl_BriefMovieDescription& coRef):fi_tclVisitableTypeBase(coRef)
{
   ID = coRef.ID;
   Name = coRef.Name;
   RunTime = coRef.RunTime;
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
fi_tcl_BriefMovieDescription& fi_tcl_BriefMovieDescription::operator=(const fi_tcl_BriefMovieDescription& coRef)
{
   if (this == &coRef) return *this;
   ID = coRef.ID;
   Name = coRef.Name;
   RunTime = coRef.RunTime;
   return *this;
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
tVoid fi_tcl_BriefMovieDescription::vDestroy()
{
   ID.vDestroy(); 
   Name.vDestroy(); 
   RunTime.vDestroy(); 
}

tU32 fi_tcl_BriefMovieDescription::u32GetSize(tU16 u16MajorVersion) const
{
   return 2+Name.u32GetSize(u16MajorVersion);
}

tBool fi_tcl_BriefMovieDescription::operator==(const fi_tcl_BriefMovieDescription& rfoCmp) const
{
   tBool bResult = true;
      bResult = bResult && (ID == rfoCmp.ID);
      bResult = bResult && (Name == rfoCmp.Name);
      bResult = bResult && (RunTime == rfoCmp.RunTime);
   return bResult;
}

fi_tclInContext& fi_tcl_BriefMovieDescription::oRead(fi_tclInContext& oIn)
{
   oIn >> ID;
   oIn >> Name;
   oIn >> RunTime;
   return oIn;
}

fi_tclOutContext& fi_tcl_BriefMovieDescription::oWrite(fi_tclOutContext& oOut) const
{
   oOut << ID;
   oOut << Name;
   oOut << RunTime;
   return oOut;
}

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
fi_tcl_TheaterDescription::fi_tcl_TheaterDescription(const fi_tcl_TheaterDescription& coRef):fi_tclVisitableTypeBase(coRef)
{
   Theater = coRef.Theater;
   TheaterDescription = coRef.TheaterDescription;
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
fi_tcl_TheaterDescription& fi_tcl_TheaterDescription::operator=(const fi_tcl_TheaterDescription& coRef)
{
   if (this == &coRef) return *this;
   Theater = coRef.Theater;
   TheaterDescription = coRef.TheaterDescription;
   return *this;
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
tVoid fi_tcl_TheaterDescription::vDestroy()
{
   Theater.vDestroy(); 
   TheaterDescription.vDestroy(); 
}

tU32 fi_tcl_TheaterDescription::u32GetSize(tU16 u16MajorVersion) const
{
   return 0+Theater.u32GetSize(u16MajorVersion)+TheaterDescription.u32GetSize(u16MajorVersion);
}

tBool fi_tcl_TheaterDescription::operator==(const fi_tcl_TheaterDescription& rfoCmp) const
{
   tBool bResult = true;
      bResult = bResult && (Theater == rfoCmp.Theater);
      bResult = bResult && (TheaterDescription == rfoCmp.TheaterDescription);
   return bResult;
}

fi_tclInContext& fi_tcl_TheaterDescription::oRead(fi_tclInContext& oIn)
{
   oIn >> Theater;
   oIn >> TheaterDescription;
   return oIn;
}

fi_tclOutContext& fi_tcl_TheaterDescription::oWrite(fi_tclOutContext& oOut) const
{
   oOut << Theater;
   oOut << TheaterDescription;
   return oOut;
}

tU32 fi_tcl_u16_UserTrafficMessageHandle::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 2;
}

tBool fi_tcl_u16_UserTrafficMessageHandle::operator==(const fi_tcl_u16_UserTrafficMessageHandle& rfoCmp) const
{
   return u16Value == rfoCmp.u16Value;
}

fi_tclInContext& fi_tcl_u16_UserTrafficMessageHandle::oRead(fi_tclInContext& oIn)
{
   return oIn >> u16Value;
}

fi_tclOutContext& fi_tcl_u16_UserTrafficMessageHandle::oWrite(fi_tclOutContext& oOut) const
{
   return oOut << u16Value;
}

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
fi_tcl_UTMHandleContainer::fi_tcl_UTMHandleContainer(const fi_tcl_UTMHandleContainer& coRef):fi_tclVisitableTypeBase(coRef)
{
   UTMHandle = coRef.UTMHandle;
   OutComingClosingLength = coRef.OutComingClosingLength;
   ErrorCode = coRef.ErrorCode;
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
fi_tcl_UTMHandleContainer& fi_tcl_UTMHandleContainer::operator=(const fi_tcl_UTMHandleContainer& coRef)
{
   if (this == &coRef) return *this;
   UTMHandle = coRef.UTMHandle;
   OutComingClosingLength = coRef.OutComingClosingLength;
   ErrorCode = coRef.ErrorCode;
   return *this;
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
tU32 fi_tcl_UTMHandleContainer::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 8;
}

tBool fi_tcl_UTMHandleContainer::operator==(const fi_tcl_UTMHandleContainer& rfoCmp) const
{
   tBool bResult = true;
      bResult = bResult && (UTMHandle == rfoCmp.UTMHandle);
      bResult = bResult && (OutComingClosingLength == rfoCmp.OutComingClosingLength);
      bResult = bResult && (ErrorCode == rfoCmp.ErrorCode);
   return bResult;
}

fi_tclInContext& fi_tcl_UTMHandleContainer::oRead(fi_tclInContext& oIn)
{
   oIn >> UTMHandle;
   oIn >> OutComingClosingLength;
   oIn >> ErrorCode;
   return oIn;
}

fi_tclOutContext& fi_tcl_UTMHandleContainer::oWrite(fi_tclOutContext& oOut) const
{
   oOut << UTMHandle;
   oOut << OutComingClosingLength;
   oOut << ErrorCode;
   return oOut;
}

tU32 fi_tcl_e8_PositionCalculationState::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 1;
}

tBool fi_tcl_e8_PositionCalculationState::operator==(const fi_tcl_e8_PositionCalculationState& rfoCmp) const
{
   return enType == rfoCmp.enType;
}

fi_tclInContext& fi_tcl_e8_PositionCalculationState::oRead(fi_tclInContext& oIn)
{
   tU8 u8Value;
   oIn >> u8Value;
   enType = (tenType)u8Value;
   return oIn;
}

fi_tclOutContext& fi_tcl_e8_PositionCalculationState::oWrite(fi_tclOutContext& oOut) const
{
   fi_tcl_e8_PositionCalculationState::tenType enData = enType;
   if ((enData == FI_EN_LASTPOSITION) && !(6 <= oOut.u16GetMajorVersion()))
   {
      enData = FI_EN_UNKNOWN;
   }
   return oOut.oWrite((tU8)enData);
}

tU32 fi_tcl_e8_SwitchPositionStatus::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 1;
}

tBool fi_tcl_e8_SwitchPositionStatus::operator==(const fi_tcl_e8_SwitchPositionStatus& rfoCmp) const
{
   return enType == rfoCmp.enType;
}

fi_tclInContext& fi_tcl_e8_SwitchPositionStatus::oRead(fi_tclInContext& oIn)
{
   tU8 u8Value;
   oIn >> u8Value;
   enType = (tenType)u8Value;
   return oIn;
}

fi_tclOutContext& fi_tcl_e8_SwitchPositionStatus::oWrite(fi_tclOutContext& oOut) const
{
   return oOut.oWrite((tU8)enType);
}

tU32 fi_tcl_e8_LaneStatus::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 1;
}

tBool fi_tcl_e8_LaneStatus::operator==(const fi_tcl_e8_LaneStatus& rfoCmp) const
{
   return enType == rfoCmp.enType;
}

fi_tclInContext& fi_tcl_e8_LaneStatus::oRead(fi_tclInContext& oIn)
{
   tU8 u8Value;
   oIn >> u8Value;
   enType = (tenType)u8Value;
   return oIn;
}

fi_tclOutContext& fi_tcl_e8_LaneStatus::oWrite(fi_tclOutContext& oOut) const
{
   return oOut.oWrite((tU8)enType);
}

tU32 fi_tcl_b8_LaneType::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 1;
}

tBool fi_tcl_b8_LaneType::operator==(const fi_tcl_b8_LaneType& rfoCmp) const
{
   return u8Value == rfoCmp.u8Value;
}

fi_tclInContext& fi_tcl_b8_LaneType::oRead(fi_tclInContext& oIn)
{
   return oIn >> u8Value;
}

fi_tclOutContext& fi_tcl_b8_LaneType::oWrite(fi_tclOutContext& oOut) const
{
   tU8 temp = u8Value;
   if (!(25 <= oOut.u16GetMajorVersion()))
      temp &= ~FI_C_U8_BIT_HOV;
   return oOut << temp;
}

tU32 fi_tcl_b8_LaneChangeRestriction::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 1;
}

tBool fi_tcl_b8_LaneChangeRestriction::operator==(const fi_tcl_b8_LaneChangeRestriction& rfoCmp) const
{
   return u8Value == rfoCmp.u8Value;
}

fi_tclInContext& fi_tcl_b8_LaneChangeRestriction::oRead(fi_tclInContext& oIn)
{
   return oIn >> u8Value;
}

fi_tclOutContext& fi_tcl_b8_LaneChangeRestriction::oWrite(fi_tclOutContext& oOut) const
{
   return oOut << u8Value;
}

tU32 fi_tcl_u8_IndexInLaneInfoSegmentList::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 1;
}

tBool fi_tcl_u8_IndexInLaneInfoSegmentList::operator==(const fi_tcl_u8_IndexInLaneInfoSegmentList& rfoCmp) const
{
   return u8Value == rfoCmp.u8Value;
}

fi_tclInContext& fi_tcl_u8_IndexInLaneInfoSegmentList::oRead(fi_tclInContext& oIn)
{
   return oIn >> u8Value;
}

fi_tclOutContext& fi_tcl_u8_IndexInLaneInfoSegmentList::oWrite(fi_tclOutContext& oOut) const
{
   return oOut << u8Value;
}

tU32 fi_tcl_u8_IndexInLaneInfoList::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 1;
}

tBool fi_tcl_u8_IndexInLaneInfoList::operator==(const fi_tcl_u8_IndexInLaneInfoList& rfoCmp) const
{
   return u8Value == rfoCmp.u8Value;
}

fi_tclInContext& fi_tcl_u8_IndexInLaneInfoList::oRead(fi_tclInContext& oIn)
{
   return oIn >> u8Value;
}

fi_tclOutContext& fi_tcl_u8_IndexInLaneInfoList::oWrite(fi_tclOutContext& oOut) const
{
   return oOut << u8Value;
}

tU32 fi_tcl_u8_DrivingDirection::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 1;
}

tBool fi_tcl_u8_DrivingDirection::operator==(const fi_tcl_u8_DrivingDirection& rfoCmp) const
{
   return u8Value == rfoCmp.u8Value;
}

fi_tclInContext& fi_tcl_u8_DrivingDirection::oRead(fi_tclInContext& oIn)
{
   return oIn >> u8Value;
}

fi_tclOutContext& fi_tcl_u8_DrivingDirection::oWrite(fi_tclOutContext& oOut) const
{
   return oOut << u8Value;
}

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
fi_tcl_LaneDirection::fi_tcl_LaneDirection(const fi_tcl_LaneDirection& coRef):fi_tclVisitableTypeBase(coRef)
{
   DirectionToFollowingLane = coRef.DirectionToFollowingLane;
   FollowingLaneStatus = coRef.FollowingLaneStatus;
   FollowingLaneType = coRef.FollowingLaneType;
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
fi_tcl_LaneDirection& fi_tcl_LaneDirection::operator=(const fi_tcl_LaneDirection& coRef)
{
   if (this == &coRef) return *this;
   DirectionToFollowingLane = coRef.DirectionToFollowingLane;
   FollowingLaneStatus = coRef.FollowingLaneStatus;
   FollowingLaneType = coRef.FollowingLaneType;
   return *this;
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
tU32 fi_tcl_LaneDirection::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 3;
}

tBool fi_tcl_LaneDirection::operator==(const fi_tcl_LaneDirection& rfoCmp) const
{
   tBool bResult = true;
      bResult = bResult && (DirectionToFollowingLane == rfoCmp.DirectionToFollowingLane);
      bResult = bResult && (FollowingLaneStatus == rfoCmp.FollowingLaneStatus);
      bResult = bResult && (FollowingLaneType == rfoCmp.FollowingLaneType);
   return bResult;
}

fi_tclInContext& fi_tcl_LaneDirection::oRead(fi_tclInContext& oIn)
{
   oIn >> DirectionToFollowingLane;
   oIn >> FollowingLaneStatus;
   oIn >> FollowingLaneType;
   return oIn;
}

fi_tclOutContext& fi_tcl_LaneDirection::oWrite(fi_tclOutContext& oOut) const
{
   oOut << DirectionToFollowingLane;
   oOut << FollowingLaneStatus;
   oOut << FollowingLaneType;
   return oOut;
}

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
fi_tcl_LaneInfoOneCellReference::fi_tcl_LaneInfoOneCellReference(const fi_tcl_LaneInfoOneCellReference& coRef):fi_tclVisitableTypeBase(coRef)
{
   OneCell = coRef.OneCell;
   SegmentIndex = coRef.SegmentIndex;
   LaneIndex = coRef.LaneIndex;
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
fi_tcl_LaneInfoOneCellReference& fi_tcl_LaneInfoOneCellReference::operator=(const fi_tcl_LaneInfoOneCellReference& coRef)
{
   if (this == &coRef) return *this;
   OneCell = coRef.OneCell;
   SegmentIndex = coRef.SegmentIndex;
   LaneIndex = coRef.LaneIndex;
   return *this;
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
tVoid fi_tcl_LaneInfoOneCellReference::vDestroy()
{
   OneCell.vDestroy(); 
}

tU32 fi_tcl_LaneInfoOneCellReference::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 13;
}

tBool fi_tcl_LaneInfoOneCellReference::operator==(const fi_tcl_LaneInfoOneCellReference& rfoCmp) const
{
   tBool bResult = true;
      bResult = bResult && (OneCell == rfoCmp.OneCell);
      bResult = bResult && (SegmentIndex == rfoCmp.SegmentIndex);
      bResult = bResult && (LaneIndex == rfoCmp.LaneIndex);
   return bResult;
}

fi_tclInContext& fi_tcl_LaneInfoOneCellReference::oRead(fi_tclInContext& oIn)
{
   oIn >> OneCell;
   oIn >> SegmentIndex;
   oIn >> LaneIndex;
   return oIn;
}

fi_tclOutContext& fi_tcl_LaneInfoOneCellReference::oWrite(fi_tclOutContext& oOut) const
{
   oOut << OneCell;
   oOut << SegmentIndex;
   oOut << LaneIndex;
   return oOut;
}

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
fi_tcl_LaneInfoOneCellIndexReference::fi_tcl_LaneInfoOneCellIndexReference(const fi_tcl_LaneInfoOneCellIndexReference& coRef):fi_tclVisitableTypeBase(coRef)
{
   OneCellIndex = coRef.OneCellIndex;
   SegmentIndex = coRef.SegmentIndex;
   LaneIndex = coRef.LaneIndex;
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
fi_tcl_LaneInfoOneCellIndexReference& fi_tcl_LaneInfoOneCellIndexReference::operator=(const fi_tcl_LaneInfoOneCellIndexReference& coRef)
{
   if (this == &coRef) return *this;
   OneCellIndex = coRef.OneCellIndex;
   SegmentIndex = coRef.SegmentIndex;
   LaneIndex = coRef.LaneIndex;
   return *this;
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
tU32 fi_tcl_LaneInfoOneCellIndexReference::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 4;
}

tBool fi_tcl_LaneInfoOneCellIndexReference::operator==(const fi_tcl_LaneInfoOneCellIndexReference& rfoCmp) const
{
   tBool bResult = true;
      bResult = bResult && (OneCellIndex == rfoCmp.OneCellIndex);
      bResult = bResult && (SegmentIndex == rfoCmp.SegmentIndex);
      bResult = bResult && (LaneIndex == rfoCmp.LaneIndex);
   return bResult;
}

fi_tclInContext& fi_tcl_LaneInfoOneCellIndexReference::oRead(fi_tclInContext& oIn)
{
   oIn >> OneCellIndex;
   oIn >> SegmentIndex;
   oIn >> LaneIndex;
   return oIn;
}

fi_tclOutContext& fi_tcl_LaneInfoOneCellIndexReference::oWrite(fi_tclOutContext& oOut) const
{
   oOut << OneCellIndex;
   oOut << SegmentIndex;
   oOut << LaneIndex;
   return oOut;
}

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
fi_tcl_LaneInfoPathSectionIndexReference::fi_tcl_LaneInfoPathSectionIndexReference(const fi_tcl_LaneInfoPathSectionIndexReference& coRef):fi_tclVisitableTypeBase(coRef)
{
   PathSectionIndex = coRef.PathSectionIndex;
   SegmentIndex = coRef.SegmentIndex;
   LaneIndex = coRef.LaneIndex;
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
fi_tcl_LaneInfoPathSectionIndexReference& fi_tcl_LaneInfoPathSectionIndexReference::operator=(const fi_tcl_LaneInfoPathSectionIndexReference& coRef)
{
   if (this == &coRef) return *this;
   PathSectionIndex = coRef.PathSectionIndex;
   SegmentIndex = coRef.SegmentIndex;
   LaneIndex = coRef.LaneIndex;
   return *this;
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
tU32 fi_tcl_LaneInfoPathSectionIndexReference::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 4;
}

tBool fi_tcl_LaneInfoPathSectionIndexReference::operator==(const fi_tcl_LaneInfoPathSectionIndexReference& rfoCmp) const
{
   tBool bResult = true;
      bResult = bResult && (PathSectionIndex == rfoCmp.PathSectionIndex);
      bResult = bResult && (SegmentIndex == rfoCmp.SegmentIndex);
      bResult = bResult && (LaneIndex == rfoCmp.LaneIndex);
   return bResult;
}

fi_tclInContext& fi_tcl_LaneInfoPathSectionIndexReference::oRead(fi_tclInContext& oIn)
{
   oIn >> PathSectionIndex;
   oIn >> SegmentIndex;
   oIn >> LaneIndex;
   return oIn;
}

fi_tclOutContext& fi_tcl_LaneInfoPathSectionIndexReference::oWrite(fi_tclOutContext& oOut) const
{
   oOut << PathSectionIndex;
   oOut << SegmentIndex;
   oOut << LaneIndex;
   return oOut;
}

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
fi_tcl_LaneInfoElementReference::fi_tcl_LaneInfoElementReference(const fi_tcl_LaneInfoElementReference& coRef):fi_tclVisitableTypeBase(coRef)
{
   ElementId = coRef.ElementId;
   LaneIndex = coRef.LaneIndex;
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
fi_tcl_LaneInfoElementReference& fi_tcl_LaneInfoElementReference::operator=(const fi_tcl_LaneInfoElementReference& coRef)
{
   if (this == &coRef) return *this;
   ElementId = coRef.ElementId;
   LaneIndex = coRef.LaneIndex;
   return *this;
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
tU32 fi_tcl_LaneInfoElementReference::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 3;
}

tBool fi_tcl_LaneInfoElementReference::operator==(const fi_tcl_LaneInfoElementReference& rfoCmp) const
{
   tBool bResult = true;
      bResult = bResult && (ElementId == rfoCmp.ElementId);
      bResult = bResult && (LaneIndex == rfoCmp.LaneIndex);
   return bResult;
}

fi_tclInContext& fi_tcl_LaneInfoElementReference::oRead(fi_tclInContext& oIn)
{
   oIn >> ElementId;
   oIn >> LaneIndex;
   return oIn;
}

fi_tclOutContext& fi_tcl_LaneInfoElementReference::oWrite(fi_tclOutContext& oOut) const
{
   oOut << ElementId;
   oOut << LaneIndex;
   return oOut;
}

tU32 fi_tcl_e8_LaneReferenceCategory::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 1;
}

tBool fi_tcl_e8_LaneReferenceCategory::operator==(const fi_tcl_e8_LaneReferenceCategory& rfoCmp) const
{
   return enType == rfoCmp.enType;
}

fi_tclInContext& fi_tcl_e8_LaneReferenceCategory::oRead(fi_tclInContext& oIn)
{
   tU8 u8Value;
   oIn >> u8Value;
   enType = (tenType)u8Value;
   return oIn;
}

fi_tclOutContext& fi_tcl_e8_LaneReferenceCategory::oWrite(fi_tclOutContext& oOut) const
{
   fi_tcl_e8_LaneReferenceCategory::tenType enData = enType;
   if ((enData == FI_EN_T_LANEINFOPATHSECTIONINDEXREFERENCE) && !(11 <= oOut.u16GetMajorVersion()))
   {
      enData = FI_EN_T_LANEINFOONECELLINDEXREFERENCE;
   }
   return oOut.oWrite((tU8)enData);
}

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
fi_tcl_LaneReference::fi_tcl_LaneReference(const fi_tcl_LaneReference& coRef):fi_tclVisitableTypeBase(coRef)
{
   LaneReferenceCategoryType = coRef.LaneReferenceCategoryType;
   if  (coRef.poLaneReferenceCategoryData)
   {
      switch(LaneReferenceCategoryType.enType)
      {
      case fi_tcl_e8_LaneReferenceCategory::FI_EN_T_RESERVED:
         poLaneReferenceCategoryData = OSAL_NEW fi_tcl_Reserved((const fi_tcl_Reserved&)*coRef.poLaneReferenceCategoryData);
         break;
      case fi_tcl_e8_LaneReferenceCategory::FI_EN_T_LANEINFOONECELLREFERENCE:
         poLaneReferenceCategoryData = OSAL_NEW fi_tcl_LaneInfoOneCellReference((const fi_tcl_LaneInfoOneCellReference&)*coRef.poLaneReferenceCategoryData);
         break;
      case fi_tcl_e8_LaneReferenceCategory::FI_EN_T_LANEINFOONECELLINDEXREFERENCE:
         poLaneReferenceCategoryData = OSAL_NEW fi_tcl_LaneInfoOneCellIndexReference((const fi_tcl_LaneInfoOneCellIndexReference&)*coRef.poLaneReferenceCategoryData);
         break;
      case fi_tcl_e8_LaneReferenceCategory::FI_EN_T_LANEINFOELEMENTREFERENCE:
         poLaneReferenceCategoryData = OSAL_NEW fi_tcl_LaneInfoElementReference((const fi_tcl_LaneInfoElementReference&)*coRef.poLaneReferenceCategoryData);
         break;
      case fi_tcl_e8_LaneReferenceCategory::FI_EN_T_LANEINFOPATHSECTIONINDEXREFERENCE:
         poLaneReferenceCategoryData = OSAL_NEW fi_tcl_LaneInfoPathSectionIndexReference((const fi_tcl_LaneInfoPathSectionIndexReference&)*coRef.poLaneReferenceCategoryData);
         break;
      default:
         poLaneReferenceCategoryData = OSAL_NULL;
      }
   }
   else
   {
      poLaneReferenceCategoryData = OSAL_NULL;
   }
   LaneDirection = coRef.LaneDirection;
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
fi_tcl_LaneReference& fi_tcl_LaneReference::operator=(const fi_tcl_LaneReference& coRef)
{
   if (this == &coRef) return *this;
   OSAL_DELETE poLaneReferenceCategoryData;
   LaneReferenceCategoryType = coRef.LaneReferenceCategoryType;
   if  (coRef.poLaneReferenceCategoryData)
   {
      switch(LaneReferenceCategoryType.enType)
      {
      case fi_tcl_e8_LaneReferenceCategory::FI_EN_T_RESERVED:
         poLaneReferenceCategoryData = OSAL_NEW fi_tcl_Reserved((const fi_tcl_Reserved&)*coRef.poLaneReferenceCategoryData);
         break;
      case fi_tcl_e8_LaneReferenceCategory::FI_EN_T_LANEINFOONECELLREFERENCE:
         poLaneReferenceCategoryData = OSAL_NEW fi_tcl_LaneInfoOneCellReference((const fi_tcl_LaneInfoOneCellReference&)*coRef.poLaneReferenceCategoryData);
         break;
      case fi_tcl_e8_LaneReferenceCategory::FI_EN_T_LANEINFOONECELLINDEXREFERENCE:
         poLaneReferenceCategoryData = OSAL_NEW fi_tcl_LaneInfoOneCellIndexReference((const fi_tcl_LaneInfoOneCellIndexReference&)*coRef.poLaneReferenceCategoryData);
         break;
      case fi_tcl_e8_LaneReferenceCategory::FI_EN_T_LANEINFOELEMENTREFERENCE:
         poLaneReferenceCategoryData = OSAL_NEW fi_tcl_LaneInfoElementReference((const fi_tcl_LaneInfoElementReference&)*coRef.poLaneReferenceCategoryData);
         break;
      case fi_tcl_e8_LaneReferenceCategory::FI_EN_T_LANEINFOPATHSECTIONINDEXREFERENCE:
         poLaneReferenceCategoryData = OSAL_NEW fi_tcl_LaneInfoPathSectionIndexReference((const fi_tcl_LaneInfoPathSectionIndexReference&)*coRef.poLaneReferenceCategoryData);
         break;
      default:
         poLaneReferenceCategoryData = OSAL_NULL;
      }
   }
   else
   {
      poLaneReferenceCategoryData = OSAL_NULL;
   }
   LaneDirection = coRef.LaneDirection;
   return *this;
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
fi_tcl_LaneReference::~fi_tcl_LaneReference()
{
   OSAL_DELETE poLaneReferenceCategoryData;
   poLaneReferenceCategoryData = OSAL_NULL;
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
tVoid fi_tcl_LaneReference::vDestroy()
{
   if (poLaneReferenceCategoryData)
   {
      poLaneReferenceCategoryData->vDestroy();
      OSAL_DELETE poLaneReferenceCategoryData;
      poLaneReferenceCategoryData = OSAL_NULL;
   }
   LaneDirection.vDestroy(); 
}

tU32 fi_tcl_LaneReference::u32GetSize(tU16 u16MajorVersion) const
{
   tU32 u32DynamicSize = 0;
   if (LaneReferenceCategoryType.enType == fi_tcl_e8_LaneReferenceCategory::FI_EN_T_RESERVED)
      u32DynamicSize += (poLaneReferenceCategoryData?poLaneReferenceCategoryData->u32GetSize(u16MajorVersion):0);
   if (LaneReferenceCategoryType.enType == fi_tcl_e8_LaneReferenceCategory::FI_EN_T_LANEINFOONECELLREFERENCE)
      u32DynamicSize += (poLaneReferenceCategoryData?poLaneReferenceCategoryData->u32GetSize(u16MajorVersion):0);
   if (LaneReferenceCategoryType.enType == fi_tcl_e8_LaneReferenceCategory::FI_EN_T_LANEINFOONECELLINDEXREFERENCE)
      u32DynamicSize += (poLaneReferenceCategoryData?poLaneReferenceCategoryData->u32GetSize(u16MajorVersion):0);
   if (LaneReferenceCategoryType.enType == fi_tcl_e8_LaneReferenceCategory::FI_EN_T_LANEINFOELEMENTREFERENCE)
      u32DynamicSize += (poLaneReferenceCategoryData?poLaneReferenceCategoryData->u32GetSize(u16MajorVersion):0);
   if ((LaneReferenceCategoryType.enType == fi_tcl_e8_LaneReferenceCategory::FI_EN_T_LANEINFOPATHSECTIONINDEXREFERENCE) &&
       (11 <= u16MajorVersion))
      u32DynamicSize += (poLaneReferenceCategoryData?poLaneReferenceCategoryData->u32GetSize(u16MajorVersion):0);
   return u32DynamicSize+4;
}

tBool fi_tcl_LaneReference::operator==(const fi_tcl_LaneReference& rfoCmp) const
{
   tBool bResult = true;
   bResult = bResult && (LaneReferenceCategoryType == rfoCmp.LaneReferenceCategoryType);
   if (bResult && poLaneReferenceCategoryData && rfoCmp.poLaneReferenceCategoryData) 
   {
      switch (LaneReferenceCategoryType.enType)
      {
      case fi_tcl_e8_LaneReferenceCategory::FI_EN_T_RESERVED:
         bResult = bResult && (*(const fi_tcl_Reserved*)poLaneReferenceCategoryData == *(const fi_tcl_Reserved*)rfoCmp.poLaneReferenceCategoryData); //lint !e826
      break;
      case fi_tcl_e8_LaneReferenceCategory::FI_EN_T_LANEINFOONECELLREFERENCE:
         bResult = bResult && (*(const fi_tcl_LaneInfoOneCellReference*)poLaneReferenceCategoryData == *(const fi_tcl_LaneInfoOneCellReference*)rfoCmp.poLaneReferenceCategoryData); //lint !e826
      break;
      case fi_tcl_e8_LaneReferenceCategory::FI_EN_T_LANEINFOONECELLINDEXREFERENCE:
         bResult = bResult && (*(const fi_tcl_LaneInfoOneCellIndexReference*)poLaneReferenceCategoryData == *(const fi_tcl_LaneInfoOneCellIndexReference*)rfoCmp.poLaneReferenceCategoryData); //lint !e826
      break;
      case fi_tcl_e8_LaneReferenceCategory::FI_EN_T_LANEINFOELEMENTREFERENCE:
         bResult = bResult && (*(const fi_tcl_LaneInfoElementReference*)poLaneReferenceCategoryData == *(const fi_tcl_LaneInfoElementReference*)rfoCmp.poLaneReferenceCategoryData); //lint !e826
      break;
      case fi_tcl_e8_LaneReferenceCategory::FI_EN_T_LANEINFOPATHSECTIONINDEXREFERENCE:
         bResult = bResult && (*(const fi_tcl_LaneInfoPathSectionIndexReference*)poLaneReferenceCategoryData == *(const fi_tcl_LaneInfoPathSectionIndexReference*)rfoCmp.poLaneReferenceCategoryData); //lint !e826
      break;
      }
   }
   else
   {
      bResult = bResult && (poLaneReferenceCategoryData == rfoCmp.poLaneReferenceCategoryData);
   }
      bResult = bResult && (LaneDirection == rfoCmp.LaneDirection);
   return bResult;
}

fi_tclInContext& fi_tcl_LaneReference::oRead(fi_tclInContext& oIn)
{
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   OSAL_DELETE poLaneReferenceCategoryData;
#else
   if (poLaneReferenceCategoryData)
   {
      poLaneReferenceCategoryData->vDestroy();
      OSAL_DELETE poLaneReferenceCategoryData;
   }
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
   oIn >> LaneReferenceCategoryType;
   switch(LaneReferenceCategoryType.enType)
   {
   case fi_tcl_e8_LaneReferenceCategory::FI_EN_T_RESERVED:
      poLaneReferenceCategoryData = OSAL_NEW fi_tcl_Reserved;
      break;
   case fi_tcl_e8_LaneReferenceCategory::FI_EN_T_LANEINFOONECELLREFERENCE:
      poLaneReferenceCategoryData = OSAL_NEW fi_tcl_LaneInfoOneCellReference;
      break;
   case fi_tcl_e8_LaneReferenceCategory::FI_EN_T_LANEINFOONECELLINDEXREFERENCE:
      poLaneReferenceCategoryData = OSAL_NEW fi_tcl_LaneInfoOneCellIndexReference;
      break;
   case fi_tcl_e8_LaneReferenceCategory::FI_EN_T_LANEINFOELEMENTREFERENCE:
      poLaneReferenceCategoryData = OSAL_NEW fi_tcl_LaneInfoElementReference;
      break;
   case fi_tcl_e8_LaneReferenceCategory::FI_EN_T_LANEINFOPATHSECTIONINDEXREFERENCE:
      poLaneReferenceCategoryData = OSAL_NEW fi_tcl_LaneInfoPathSectionIndexReference;
      break;
   default:
      oIn.Invalidate();
      poLaneReferenceCategoryData = OSAL_NULL;
   }
   if (poLaneReferenceCategoryData && oIn.bIsValid())
      poLaneReferenceCategoryData->oRead(oIn);
   else
      oIn.Invalidate();
   oIn >> LaneDirection;
   return oIn;
}

fi_tclOutContext& fi_tcl_LaneReference::oWrite(fi_tclOutContext& oOut) const
{
   oOut << LaneReferenceCategoryType;
   if (poLaneReferenceCategoryData)
   {
      if (LaneReferenceCategoryType.enType == fi_tcl_e8_LaneReferenceCategory::FI_EN_T_RESERVED)
      {
         poLaneReferenceCategoryData->oWrite(oOut);
      }
      if (LaneReferenceCategoryType.enType == fi_tcl_e8_LaneReferenceCategory::FI_EN_T_LANEINFOONECELLREFERENCE)
      {
         poLaneReferenceCategoryData->oWrite(oOut);
      }
      if (LaneReferenceCategoryType.enType == fi_tcl_e8_LaneReferenceCategory::FI_EN_T_LANEINFOONECELLINDEXREFERENCE)
      {
         poLaneReferenceCategoryData->oWrite(oOut);
      }
      if (LaneReferenceCategoryType.enType == fi_tcl_e8_LaneReferenceCategory::FI_EN_T_LANEINFOELEMENTREFERENCE)
      {
         poLaneReferenceCategoryData->oWrite(oOut);
      }
      if (LaneReferenceCategoryType.enType == fi_tcl_e8_LaneReferenceCategory::FI_EN_T_LANEINFOPATHSECTIONINDEXREFERENCE)
      {
         if (!(11 <= oOut.u16GetMajorVersion()))
         {
            fi_tcl_LaneInfoOneCellIndexReference oDefault;
            oOut << oDefault;
         }
         else
         {
            poLaneReferenceCategoryData->oWrite(oOut);
         }
      }
   }
   else
   {
      oOut.Invalidate();
   }
   oOut << LaneDirection;
   return oOut;
}

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
fi_tcl_LaneInfo::fi_tcl_LaneInfo(const fi_tcl_LaneInfo& coRef):fi_tclVisitableTypeBase(coRef)
{
   Status = coRef.Status;
   Type = coRef.Type;
   ChangeRestriction = coRef.ChangeRestriction;
   FollowingLaneList = coRef.FollowingLaneList;
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
fi_tcl_LaneInfo& fi_tcl_LaneInfo::operator=(const fi_tcl_LaneInfo& coRef)
{
   if (this == &coRef) return *this;
   Status = coRef.Status;
   Type = coRef.Type;
   ChangeRestriction = coRef.ChangeRestriction;
   FollowingLaneList = coRef.FollowingLaneList;
   return *this;
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
tVoid fi_tcl_LaneInfo::vDestroy()
{
   {
      for (tU32 u32Idx = 0; u32Idx < FollowingLaneList.size(); ++u32Idx)
         FollowingLaneList[u32Idx].vDestroy();
   }
   FollowingLaneList.clear();
}

tU32 fi_tcl_LaneInfo::u32GetSize(tU16 u16MajorVersion) const
{
   tU32 u32DynamicSize = 0;
   tU32 u32ListIdx;
   for (u32ListIdx = 0; u32ListIdx < FollowingLaneList.size(); ++u32ListIdx)
      u32DynamicSize += FollowingLaneList[u32ListIdx].u32GetSize(u16MajorVersion);
   return u32DynamicSize+7;
}

tBool fi_tcl_LaneInfo::operator==(const fi_tcl_LaneInfo& rfoCmp) const
{
   tBool bResult = true;
      bResult = bResult && (Status == rfoCmp.Status);
      bResult = bResult && (Type == rfoCmp.Type);
      bResult = bResult && (ChangeRestriction == rfoCmp.ChangeRestriction);
      bResult = bResult && (FollowingLaneList.size() == rfoCmp.FollowingLaneList.size());
      if (bResult)
      {
         for (tU32 u32Idx = 0; bResult && (u32Idx < FollowingLaneList.size()); ++u32Idx)
            bResult = bResult && (FollowingLaneList[u32Idx] == rfoCmp.FollowingLaneList[u32Idx]);
      }
   return bResult;
}

fi_tclInContext& fi_tcl_LaneInfo::oRead(fi_tclInContext& oIn)
{
   oIn >> Status;
   oIn >> Type;
   oIn >> ChangeRestriction;
   {
      tU32 u32Length;
      tU32 u32Idx;
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
      for (u32Idx = 0; u32Idx < FollowingLaneList.size(); ++u32Idx)
      {
         FollowingLaneList[u32Idx].vDestroy();
      }
#endif // !VARIANT_S_FTR_ENABLE_DEEP_COPY
      oIn >> u32Length;
      FollowingLaneList.resize(u32Length);
      for (u32Idx = 0; u32Idx < u32Length; ++u32Idx)
      {
         oIn >> FollowingLaneList[u32Idx];
      }
   }
   return oIn;
}

fi_tclOutContext& fi_tcl_LaneInfo::oWrite(fi_tclOutContext& oOut) const
{
   oOut << Status;
   oOut << Type;
   oOut << ChangeRestriction;
   oOut << (tU32)FollowingLaneList.size();
   {
      for (tU32 u32Idx = 0; u32Idx < FollowingLaneList.size(); ++u32Idx)
         oOut << FollowingLaneList[u32Idx];
   }
   return oOut;
}

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
fi_tcl_LaneInfoElement::fi_tcl_LaneInfoElement(const fi_tcl_LaneInfoElement& coRef):fi_tclVisitableTypeBase(coRef)
{
   ElementId = coRef.ElementId;
   LaneInfoList = coRef.LaneInfoList;
   PositionWGS84 = coRef.PositionWGS84;
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
fi_tcl_LaneInfoElement& fi_tcl_LaneInfoElement::operator=(const fi_tcl_LaneInfoElement& coRef)
{
   if (this == &coRef) return *this;
   ElementId = coRef.ElementId;
   LaneInfoList = coRef.LaneInfoList;
   PositionWGS84 = coRef.PositionWGS84;
   return *this;
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
tVoid fi_tcl_LaneInfoElement::vDestroy()
{
   {
      for (tU32 u32Idx = 0; u32Idx < LaneInfoList.size(); ++u32Idx)
         LaneInfoList[u32Idx].vDestroy();
   }
   LaneInfoList.clear();
   PositionWGS84.vDestroy(); 
}

tU32 fi_tcl_LaneInfoElement::u32GetSize(tU16 u16MajorVersion) const
{
   tU32 u32DynamicSize = 0;
   tU32 u32ListIdx;
   for (u32ListIdx = 0; u32ListIdx < LaneInfoList.size(); ++u32ListIdx)
      u32DynamicSize += LaneInfoList[u32ListIdx].u32GetSize(u16MajorVersion);
   return u32DynamicSize+14;
}

tBool fi_tcl_LaneInfoElement::operator==(const fi_tcl_LaneInfoElement& rfoCmp) const
{
   tBool bResult = true;
      bResult = bResult && (ElementId == rfoCmp.ElementId);
      bResult = bResult && (LaneInfoList.size() == rfoCmp.LaneInfoList.size());
      if (bResult)
      {
         for (tU32 u32Idx = 0; bResult && (u32Idx < LaneInfoList.size()); ++u32Idx)
            bResult = bResult && (LaneInfoList[u32Idx] == rfoCmp.LaneInfoList[u32Idx]);
      }
      bResult = bResult && (PositionWGS84 == rfoCmp.PositionWGS84);
   return bResult;
}

fi_tclInContext& fi_tcl_LaneInfoElement::oRead(fi_tclInContext& oIn)
{
   oIn >> ElementId;
   {
      tU32 u32Length;
      tU32 u32Idx;
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
      for (u32Idx = 0; u32Idx < LaneInfoList.size(); ++u32Idx)
      {
         LaneInfoList[u32Idx].vDestroy();
      }
#endif // !VARIANT_S_FTR_ENABLE_DEEP_COPY
      oIn >> u32Length;
      LaneInfoList.resize(u32Length);
      for (u32Idx = 0; u32Idx < u32Length; ++u32Idx)
      {
         oIn >> LaneInfoList[u32Idx];
      }
   }
   oIn >> PositionWGS84;
   return oIn;
}

fi_tclOutContext& fi_tcl_LaneInfoElement::oWrite(fi_tclOutContext& oOut) const
{
   oOut << ElementId;
   oOut << (tU32)LaneInfoList.size();
   {
      for (tU32 u32Idx = 0; u32Idx < LaneInfoList.size(); ++u32Idx)
         oOut << LaneInfoList[u32Idx];
   }
   oOut << PositionWGS84;
   return oOut;
}

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
fi_tcl_LaneInfoSegment::fi_tcl_LaneInfoSegment(const fi_tcl_LaneInfoSegment& coRef):fi_tclVisitableTypeBase(coRef)
{
   Offset = coRef.Offset;
   LaneInfoList = coRef.LaneInfoList;
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
fi_tcl_LaneInfoSegment& fi_tcl_LaneInfoSegment::operator=(const fi_tcl_LaneInfoSegment& coRef)
{
   if (this == &coRef) return *this;
   Offset = coRef.Offset;
   LaneInfoList = coRef.LaneInfoList;
   return *this;
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
tVoid fi_tcl_LaneInfoSegment::vDestroy()
{
   {
      for (tU32 u32Idx = 0; u32Idx < LaneInfoList.size(); ++u32Idx)
         LaneInfoList[u32Idx].vDestroy();
   }
   LaneInfoList.clear();
}

tU32 fi_tcl_LaneInfoSegment::u32GetSize(tU16 u16MajorVersion) const
{
   tU32 u32DynamicSize = 0;
   tU32 u32ListIdx;
   for (u32ListIdx = 0; u32ListIdx < LaneInfoList.size(); ++u32ListIdx)
      u32DynamicSize += LaneInfoList[u32ListIdx].u32GetSize(u16MajorVersion);
   return u32DynamicSize+8;
}

tBool fi_tcl_LaneInfoSegment::operator==(const fi_tcl_LaneInfoSegment& rfoCmp) const
{
   tBool bResult = true;
      bResult = bResult && (Offset == rfoCmp.Offset);
      bResult = bResult && (LaneInfoList.size() == rfoCmp.LaneInfoList.size());
      if (bResult)
      {
         for (tU32 u32Idx = 0; bResult && (u32Idx < LaneInfoList.size()); ++u32Idx)
            bResult = bResult && (LaneInfoList[u32Idx] == rfoCmp.LaneInfoList[u32Idx]);
      }
   return bResult;
}

fi_tclInContext& fi_tcl_LaneInfoSegment::oRead(fi_tclInContext& oIn)
{
   oIn >> Offset;
   {
      tU32 u32Length;
      tU32 u32Idx;
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
      for (u32Idx = 0; u32Idx < LaneInfoList.size(); ++u32Idx)
      {
         LaneInfoList[u32Idx].vDestroy();
      }
#endif // !VARIANT_S_FTR_ENABLE_DEEP_COPY
      oIn >> u32Length;
      LaneInfoList.resize(u32Length);
      for (u32Idx = 0; u32Idx < u32Length; ++u32Idx)
      {
         oIn >> LaneInfoList[u32Idx];
      }
   }
   return oIn;
}

fi_tclOutContext& fi_tcl_LaneInfoSegment::oWrite(fi_tclOutContext& oOut) const
{
   oOut << Offset;
   oOut << (tU32)LaneInfoList.size();
   {
      for (tU32 u32Idx = 0; u32Idx < LaneInfoList.size(); ++u32Idx)
         oOut << LaneInfoList[u32Idx];
   }
   return oOut;
}

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
fi_tcl_LaneInfoSegmentList::fi_tcl_LaneInfoSegmentList(const fi_tcl_LaneInfoSegmentList& coRef):fi_tclVisitableTypeBase(coRef)
{
   LaneInfoSegmentList = coRef.LaneInfoSegmentList;
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
fi_tcl_LaneInfoSegmentList& fi_tcl_LaneInfoSegmentList::operator=(const fi_tcl_LaneInfoSegmentList& coRef)
{
   if (this == &coRef) return *this;
   LaneInfoSegmentList = coRef.LaneInfoSegmentList;
   return *this;
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
tVoid fi_tcl_LaneInfoSegmentList::vDestroy()
{
   {
      for (tU32 u32Idx = 0; u32Idx < LaneInfoSegmentList.size(); ++u32Idx)
         LaneInfoSegmentList[u32Idx].vDestroy();
   }
   LaneInfoSegmentList.clear();
}

tU32 fi_tcl_LaneInfoSegmentList::u32GetSize(tU16 u16MajorVersion) const
{
   tU32 u32DynamicSize = 0;
   tU32 u32ListIdx;
   for (u32ListIdx = 0; u32ListIdx < LaneInfoSegmentList.size(); ++u32ListIdx)
      u32DynamicSize += LaneInfoSegmentList[u32ListIdx].u32GetSize(u16MajorVersion);
   return u32DynamicSize+4;
}

tBool fi_tcl_LaneInfoSegmentList::operator==(const fi_tcl_LaneInfoSegmentList& rfoCmp) const
{
   tBool bResult = true;
      bResult = bResult && (LaneInfoSegmentList.size() == rfoCmp.LaneInfoSegmentList.size());
      if (bResult)
      {
         for (tU32 u32Idx = 0; bResult && (u32Idx < LaneInfoSegmentList.size()); ++u32Idx)
            bResult = bResult && (LaneInfoSegmentList[u32Idx] == rfoCmp.LaneInfoSegmentList[u32Idx]);
      }
   return bResult;
}

fi_tclInContext& fi_tcl_LaneInfoSegmentList::oRead(fi_tclInContext& oIn)
{
   {
      tU32 u32Length;
      tU32 u32Idx;
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
      for (u32Idx = 0; u32Idx < LaneInfoSegmentList.size(); ++u32Idx)
      {
         LaneInfoSegmentList[u32Idx].vDestroy();
      }
#endif // !VARIANT_S_FTR_ENABLE_DEEP_COPY
      oIn >> u32Length;
      LaneInfoSegmentList.resize(u32Length);
      for (u32Idx = 0; u32Idx < u32Length; ++u32Idx)
      {
         oIn >> LaneInfoSegmentList[u32Idx];
      }
   }
   return oIn;
}

fi_tclOutContext& fi_tcl_LaneInfoSegmentList::oWrite(fi_tclOutContext& oOut) const
{
   oOut << (tU32)LaneInfoSegmentList.size();
   {
      for (tU32 u32Idx = 0; u32Idx < LaneInfoSegmentList.size(); ++u32Idx)
         oOut << LaneInfoSegmentList[u32Idx];
   }
   return oOut;
}

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
fi_tcl_LaneInfoListSet::fi_tcl_LaneInfoListSet(const fi_tcl_LaneInfoListSet& coRef):fi_tclVisitableTypeBase(coRef)
{
   AlternativRefList = coRef.AlternativRefList;
   LaneInfoSegmentListList = coRef.LaneInfoSegmentListList;
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
fi_tcl_LaneInfoListSet& fi_tcl_LaneInfoListSet::operator=(const fi_tcl_LaneInfoListSet& coRef)
{
   if (this == &coRef) return *this;
   AlternativRefList = coRef.AlternativRefList;
   LaneInfoSegmentListList = coRef.LaneInfoSegmentListList;
   return *this;
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
tVoid fi_tcl_LaneInfoListSet::vDestroy()
{
   {
      for (tU32 u32Idx = 0; u32Idx < AlternativRefList.size(); ++u32Idx)
         AlternativRefList[u32Idx].vDestroy();
   }
   AlternativRefList.clear();
   {
      for (tU32 u32Idx = 0; u32Idx < LaneInfoSegmentListList.size(); ++u32Idx)
         LaneInfoSegmentListList[u32Idx].vDestroy();
   }
   LaneInfoSegmentListList.clear();
}

tU32 fi_tcl_LaneInfoListSet::u32GetSize(tU16 u16MajorVersion) const
{
   tU32 u32DynamicSize = 0;
   tU32 u32ListIdx;
   for (u32ListIdx = 0; u32ListIdx < LaneInfoSegmentListList.size(); ++u32ListIdx)
      u32DynamicSize += LaneInfoSegmentListList[u32ListIdx].u32GetSize(u16MajorVersion);
   return u32DynamicSize+8+AlternativRefList.size()*4;
}

tBool fi_tcl_LaneInfoListSet::operator==(const fi_tcl_LaneInfoListSet& rfoCmp) const
{
   tBool bResult = true;
      bResult = bResult && (AlternativRefList.size() == rfoCmp.AlternativRefList.size());
      if (bResult)
      {
         for (tU32 u32Idx = 0; bResult && (u32Idx < AlternativRefList.size()); ++u32Idx)
            bResult = bResult && (AlternativRefList[u32Idx] == rfoCmp.AlternativRefList[u32Idx]);
      }
      bResult = bResult && (LaneInfoSegmentListList.size() == rfoCmp.LaneInfoSegmentListList.size());
      if (bResult)
      {
         for (tU32 u32Idx = 0; bResult && (u32Idx < LaneInfoSegmentListList.size()); ++u32Idx)
            bResult = bResult && (LaneInfoSegmentListList[u32Idx] == rfoCmp.LaneInfoSegmentListList[u32Idx]);
      }
   return bResult;
}

fi_tclInContext& fi_tcl_LaneInfoListSet::oRead(fi_tclInContext& oIn)
{
   {
      tU32 u32Length;
      tU32 u32Idx;
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
      for (u32Idx = 0; u32Idx < AlternativRefList.size(); ++u32Idx)
      {
         AlternativRefList[u32Idx].vDestroy();
      }
#endif // !VARIANT_S_FTR_ENABLE_DEEP_COPY
      oIn >> u32Length;
      AlternativRefList.resize(u32Length);
      for (u32Idx = 0; u32Idx < u32Length; ++u32Idx)
      {
         oIn >> AlternativRefList[u32Idx];
      }
   }
   {
      tU32 u32Length;
      tU32 u32Idx;
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
      for (u32Idx = 0; u32Idx < LaneInfoSegmentListList.size(); ++u32Idx)
      {
         LaneInfoSegmentListList[u32Idx].vDestroy();
      }
#endif // !VARIANT_S_FTR_ENABLE_DEEP_COPY
      oIn >> u32Length;
      LaneInfoSegmentListList.resize(u32Length);
      for (u32Idx = 0; u32Idx < u32Length; ++u32Idx)
      {
         oIn >> LaneInfoSegmentListList[u32Idx];
      }
   }
   return oIn;
}

fi_tclOutContext& fi_tcl_LaneInfoListSet::oWrite(fi_tclOutContext& oOut) const
{
   oOut << (tU32)AlternativRefList.size();
   {
      for (tU32 u32Idx = 0; u32Idx < AlternativRefList.size(); ++u32Idx)
         oOut << AlternativRefList[u32Idx];
   }
   oOut << (tU32)LaneInfoSegmentListList.size();
   {
      for (tU32 u32Idx = 0; u32Idx < LaneInfoSegmentListList.size(); ++u32Idx)
         oOut << LaneInfoSegmentListList[u32Idx];
   }
   return oOut;
}

tU32 fi_tcl_e8_EntryExitType::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 1;
}

tBool fi_tcl_e8_EntryExitType::operator==(const fi_tcl_e8_EntryExitType& rfoCmp) const
{
   return enType == rfoCmp.enType;
}

fi_tclInContext& fi_tcl_e8_EntryExitType::oRead(fi_tclInContext& oIn)
{
   tU8 u8Value;
   oIn >> u8Value;
   enType = (tenType)u8Value;
   return oIn;
}

fi_tclOutContext& fi_tcl_e8_EntryExitType::oWrite(fi_tclOutContext& oOut) const
{
   return oOut.oWrite((tU8)enType);
}

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
fi_tcl_EntryExitCoordinates::fi_tcl_EntryExitCoordinates(const fi_tcl_EntryExitCoordinates& coRef):fi_tclVisitableTypeBase(coRef)
{
   Type = coRef.Type;
   Coordinate = coRef.Coordinate;
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
fi_tcl_EntryExitCoordinates& fi_tcl_EntryExitCoordinates::operator=(const fi_tcl_EntryExitCoordinates& coRef)
{
   if (this == &coRef) return *this;
   Type = coRef.Type;
   Coordinate = coRef.Coordinate;
   return *this;
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
tVoid fi_tcl_EntryExitCoordinates::vDestroy()
{
   Coordinate.vDestroy(); 
}

tU32 fi_tcl_EntryExitCoordinates::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 9;
}

tBool fi_tcl_EntryExitCoordinates::operator==(const fi_tcl_EntryExitCoordinates& rfoCmp) const
{
   tBool bResult = true;
      bResult = bResult && (Type == rfoCmp.Type);
      bResult = bResult && (Coordinate == rfoCmp.Coordinate);
   return bResult;
}

fi_tclInContext& fi_tcl_EntryExitCoordinates::oRead(fi_tclInContext& oIn)
{
   oIn >> Type;
   oIn >> Coordinate;
   return oIn;
}

fi_tclOutContext& fi_tcl_EntryExitCoordinates::oWrite(fi_tclOutContext& oOut) const
{
   oOut << Type;
   oOut << Coordinate;
   return oOut;
}

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
fi_tcl_EntryExitPointListSet::fi_tcl_EntryExitPointListSet(const fi_tcl_EntryExitPointListSet& coRef):fi_tclVisitableTypeBase(coRef)
{
   AlternativRefList = coRef.AlternativRefList;
   EntryExitPointList = coRef.EntryExitPointList;
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
fi_tcl_EntryExitPointListSet& fi_tcl_EntryExitPointListSet::operator=(const fi_tcl_EntryExitPointListSet& coRef)
{
   if (this == &coRef) return *this;
   AlternativRefList = coRef.AlternativRefList;
   EntryExitPointList = coRef.EntryExitPointList;
   return *this;
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
tVoid fi_tcl_EntryExitPointListSet::vDestroy()
{
   {
      for (tU32 u32Idx = 0; u32Idx < AlternativRefList.size(); ++u32Idx)
         AlternativRefList[u32Idx].vDestroy();
   }
   AlternativRefList.clear();
   {
      for (tU32 u32Idx = 0; u32Idx < EntryExitPointList.size(); ++u32Idx)
         EntryExitPointList[u32Idx].vDestroy();
   }
   EntryExitPointList.clear();
}

tU32 fi_tcl_EntryExitPointListSet::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 8+AlternativRefList.size()*4+EntryExitPointList.size()*9;
}

tBool fi_tcl_EntryExitPointListSet::operator==(const fi_tcl_EntryExitPointListSet& rfoCmp) const
{
   tBool bResult = true;
      bResult = bResult && (AlternativRefList.size() == rfoCmp.AlternativRefList.size());
      if (bResult)
      {
         for (tU32 u32Idx = 0; bResult && (u32Idx < AlternativRefList.size()); ++u32Idx)
            bResult = bResult && (AlternativRefList[u32Idx] == rfoCmp.AlternativRefList[u32Idx]);
      }
      bResult = bResult && (EntryExitPointList.size() == rfoCmp.EntryExitPointList.size());
      if (bResult)
      {
         for (tU32 u32Idx = 0; bResult && (u32Idx < EntryExitPointList.size()); ++u32Idx)
            bResult = bResult && (EntryExitPointList[u32Idx] == rfoCmp.EntryExitPointList[u32Idx]);
      }
   return bResult;
}

fi_tclInContext& fi_tcl_EntryExitPointListSet::oRead(fi_tclInContext& oIn)
{
   {
      tU32 u32Length;
      tU32 u32Idx;
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
      for (u32Idx = 0; u32Idx < AlternativRefList.size(); ++u32Idx)
      {
         AlternativRefList[u32Idx].vDestroy();
      }
#endif // !VARIANT_S_FTR_ENABLE_DEEP_COPY
      oIn >> u32Length;
      AlternativRefList.resize(u32Length);
      for (u32Idx = 0; u32Idx < u32Length; ++u32Idx)
      {
         oIn >> AlternativRefList[u32Idx];
      }
   }
   {
      tU32 u32Length;
      tU32 u32Idx;
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
      for (u32Idx = 0; u32Idx < EntryExitPointList.size(); ++u32Idx)
      {
         EntryExitPointList[u32Idx].vDestroy();
      }
#endif // !VARIANT_S_FTR_ENABLE_DEEP_COPY
      oIn >> u32Length;
      EntryExitPointList.resize(u32Length);
      for (u32Idx = 0; u32Idx < u32Length; ++u32Idx)
      {
         oIn >> EntryExitPointList[u32Idx];
      }
   }
   return oIn;
}

fi_tclOutContext& fi_tcl_EntryExitPointListSet::oWrite(fi_tclOutContext& oOut) const
{
   oOut << (tU32)AlternativRefList.size();
   {
      for (tU32 u32Idx = 0; u32Idx < AlternativRefList.size(); ++u32Idx)
         oOut << AlternativRefList[u32Idx];
   }
   oOut << (tU32)EntryExitPointList.size();
   {
      for (tU32 u32Idx = 0; u32Idx < EntryExitPointList.size(); ++u32Idx)
         oOut << EntryExitPointList[u32Idx];
   }
   return oOut;
}

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
fi_tcl_WGS84CoordinateList::fi_tcl_WGS84CoordinateList(const fi_tcl_WGS84CoordinateList& coRef):fi_tclVisitableTypeBase(coRef)
{
   WGS84CoordinateList = coRef.WGS84CoordinateList;
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
fi_tcl_WGS84CoordinateList& fi_tcl_WGS84CoordinateList::operator=(const fi_tcl_WGS84CoordinateList& coRef)
{
   if (this == &coRef) return *this;
   WGS84CoordinateList = coRef.WGS84CoordinateList;
   return *this;
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
tVoid fi_tcl_WGS84CoordinateList::vDestroy()
{
   {
      for (tU32 u32Idx = 0; u32Idx < WGS84CoordinateList.size(); ++u32Idx)
         WGS84CoordinateList[u32Idx].vDestroy();
   }
   WGS84CoordinateList.clear();
}

tU32 fi_tcl_WGS84CoordinateList::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 4+WGS84CoordinateList.size()*8;
}

tBool fi_tcl_WGS84CoordinateList::operator==(const fi_tcl_WGS84CoordinateList& rfoCmp) const
{
   tBool bResult = true;
      bResult = bResult && (WGS84CoordinateList.size() == rfoCmp.WGS84CoordinateList.size());
      if (bResult)
      {
         for (tU32 u32Idx = 0; bResult && (u32Idx < WGS84CoordinateList.size()); ++u32Idx)
            bResult = bResult && (WGS84CoordinateList[u32Idx] == rfoCmp.WGS84CoordinateList[u32Idx]);
      }
   return bResult;
}

fi_tclInContext& fi_tcl_WGS84CoordinateList::oRead(fi_tclInContext& oIn)
{
   {
      tU32 u32Length;
      tU32 u32Idx;
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
      for (u32Idx = 0; u32Idx < WGS84CoordinateList.size(); ++u32Idx)
      {
         WGS84CoordinateList[u32Idx].vDestroy();
      }
#endif // !VARIANT_S_FTR_ENABLE_DEEP_COPY
      oIn >> u32Length;
      WGS84CoordinateList.resize(u32Length);
      for (u32Idx = 0; u32Idx < u32Length; ++u32Idx)
      {
         oIn >> WGS84CoordinateList[u32Idx];
      }
   }
   return oIn;
}

fi_tclOutContext& fi_tcl_WGS84CoordinateList::oWrite(fi_tclOutContext& oOut) const
{
   oOut << (tU32)WGS84CoordinateList.size();
   {
      for (tU32 u32Idx = 0; u32Idx < WGS84CoordinateList.size(); ++u32Idx)
         oOut << WGS84CoordinateList[u32Idx];
   }
   return oOut;
}

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
fi_tcl_ShapePointListSet::fi_tcl_ShapePointListSet(const fi_tcl_ShapePointListSet& coRef):fi_tclVisitableTypeBase(coRef)
{
   ShapePointListList = coRef.ShapePointListList;
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
fi_tcl_ShapePointListSet& fi_tcl_ShapePointListSet::operator=(const fi_tcl_ShapePointListSet& coRef)
{
   if (this == &coRef) return *this;
   ShapePointListList = coRef.ShapePointListList;
   return *this;
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
tVoid fi_tcl_ShapePointListSet::vDestroy()
{
   {
      for (tU32 u32Idx = 0; u32Idx < ShapePointListList.size(); ++u32Idx)
         ShapePointListList[u32Idx].vDestroy();
   }
   ShapePointListList.clear();
}

tU32 fi_tcl_ShapePointListSet::u32GetSize(tU16 u16MajorVersion) const
{
   tU32 u32DynamicSize = 0;
   tU32 u32ListIdx;
   for (u32ListIdx = 0; u32ListIdx < ShapePointListList.size(); ++u32ListIdx)
      u32DynamicSize += ShapePointListList[u32ListIdx].u32GetSize(u16MajorVersion);
   return u32DynamicSize+4;
}

tBool fi_tcl_ShapePointListSet::operator==(const fi_tcl_ShapePointListSet& rfoCmp) const
{
   tBool bResult = true;
      bResult = bResult && (ShapePointListList.size() == rfoCmp.ShapePointListList.size());
      if (bResult)
      {
         for (tU32 u32Idx = 0; bResult && (u32Idx < ShapePointListList.size()); ++u32Idx)
            bResult = bResult && (ShapePointListList[u32Idx] == rfoCmp.ShapePointListList[u32Idx]);
      }
   return bResult;
}

fi_tclInContext& fi_tcl_ShapePointListSet::oRead(fi_tclInContext& oIn)
{
   {
      tU32 u32Length;
      tU32 u32Idx;
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
      for (u32Idx = 0; u32Idx < ShapePointListList.size(); ++u32Idx)
      {
         ShapePointListList[u32Idx].vDestroy();
      }
#endif // !VARIANT_S_FTR_ENABLE_DEEP_COPY
      oIn >> u32Length;
      ShapePointListList.resize(u32Length);
      for (u32Idx = 0; u32Idx < u32Length; ++u32Idx)
      {
         oIn >> ShapePointListList[u32Idx];
      }
   }
   return oIn;
}

fi_tclOutContext& fi_tcl_ShapePointListSet::oWrite(fi_tclOutContext& oOut) const
{
   oOut << (tU32)ShapePointListList.size();
   {
      for (tU32 u32Idx = 0; u32Idx < ShapePointListList.size(); ++u32Idx)
         oOut << ShapePointListList[u32Idx];
   }
   return oOut;
}

tU32 fi_tcl_b8_TrafficMessageContent::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 1;
}

tBool fi_tcl_b8_TrafficMessageContent::operator==(const fi_tcl_b8_TrafficMessageContent& rfoCmp) const
{
   return u8Value == rfoCmp.u8Value;
}

fi_tclInContext& fi_tcl_b8_TrafficMessageContent::oRead(fi_tclInContext& oIn)
{
   return oIn >> u8Value;
}

fi_tclOutContext& fi_tcl_b8_TrafficMessageContent::oWrite(fi_tclOutContext& oOut) const
{
   tU8 temp = u8Value;
   if (!(9 <= oOut.u16GetMajorVersion()))
      temp &= ~FI_C_U8_BIT_TMINFO;
   return oOut << temp;
}

tU32 fi_tcl_e8_TMGeometricMessageType::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 1;
}

tBool fi_tcl_e8_TMGeometricMessageType::operator==(const fi_tcl_e8_TMGeometricMessageType& rfoCmp) const
{
   return enType == rfoCmp.enType;
}

fi_tclInContext& fi_tcl_e8_TMGeometricMessageType::oRead(fi_tclInContext& oIn)
{
   tU8 u8Value;
   oIn >> u8Value;
   enType = (tenType)u8Value;
   return oIn;
}

fi_tclOutContext& fi_tcl_e8_TMGeometricMessageType::oWrite(fi_tclOutContext& oOut) const
{
   return oOut.oWrite((tU8)enType);
}

tU32 fi_tcl_e16_NaviEventValue::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 2;
}

tBool fi_tcl_e16_NaviEventValue::operator==(const fi_tcl_e16_NaviEventValue& rfoCmp) const
{
   return enType == rfoCmp.enType;
}

fi_tclInContext& fi_tcl_e16_NaviEventValue::oRead(fi_tclInContext& oIn)
{
   tU16 u16Value;
   oIn >> u16Value;
   enType = (tenType)u16Value;
   return oIn;
}

fi_tclOutContext& fi_tcl_e16_NaviEventValue::oWrite(fi_tclOutContext& oOut) const
{
   fi_tcl_e16_NaviEventValue::tenType enData = enType;
   if ((enData == FI_EN_NEV_FREEFLOW) && !(11 <= oOut.u16GetMajorVersion()))
   {
      enData = FI_EN_NEV_UNDEFINED;
   }
   return oOut.oWrite((tU16)enData);
}

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
fi_tcl_TMMapOneCellListSet::fi_tcl_TMMapOneCellListSet(const fi_tcl_TMMapOneCellListSet& coRef):fi_tclVisitableTypeBase(coRef)
{
   TMOneCellList = coRef.TMOneCellList;
   ClusterList = coRef.ClusterList;
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
fi_tcl_TMMapOneCellListSet& fi_tcl_TMMapOneCellListSet::operator=(const fi_tcl_TMMapOneCellListSet& coRef)
{
   if (this == &coRef) return *this;
   TMOneCellList = coRef.TMOneCellList;
   ClusterList = coRef.ClusterList;
   return *this;
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
tVoid fi_tcl_TMMapOneCellListSet::vDestroy()
{
   {
      for (tU32 u32Idx = 0; u32Idx < TMOneCellList.size(); ++u32Idx)
         TMOneCellList[u32Idx].vDestroy();
   }
   TMOneCellList.clear();
   {
      for (tU32 u32Idx = 0; u32Idx < ClusterList.size(); ++u32Idx)
         ClusterList[u32Idx].vDestroy();
   }
   ClusterList.clear();
}

tU32 fi_tcl_TMMapOneCellListSet::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 8+TMOneCellList.size()*9+ClusterList.size()*9;
}

tBool fi_tcl_TMMapOneCellListSet::operator==(const fi_tcl_TMMapOneCellListSet& rfoCmp) const
{
   tBool bResult = true;
      bResult = bResult && (TMOneCellList.size() == rfoCmp.TMOneCellList.size());
      if (bResult)
      {
         for (tU32 u32Idx = 0; bResult && (u32Idx < TMOneCellList.size()); ++u32Idx)
            bResult = bResult && (TMOneCellList[u32Idx] == rfoCmp.TMOneCellList[u32Idx]);
      }
      bResult = bResult && (ClusterList.size() == rfoCmp.ClusterList.size());
      if (bResult)
      {
         for (tU32 u32Idx = 0; bResult && (u32Idx < ClusterList.size()); ++u32Idx)
            bResult = bResult && (ClusterList[u32Idx] == rfoCmp.ClusterList[u32Idx]);
      }
   return bResult;
}

fi_tclInContext& fi_tcl_TMMapOneCellListSet::oRead(fi_tclInContext& oIn)
{
   {
      tU32 u32Length;
      tU32 u32Idx;
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
      for (u32Idx = 0; u32Idx < TMOneCellList.size(); ++u32Idx)
      {
         TMOneCellList[u32Idx].vDestroy();
      }
#endif // !VARIANT_S_FTR_ENABLE_DEEP_COPY
      oIn >> u32Length;
      TMOneCellList.resize(u32Length);
      for (u32Idx = 0; u32Idx < u32Length; ++u32Idx)
      {
         oIn >> TMOneCellList[u32Idx];
      }
   }
   {
      tU32 u32Length;
      tU32 u32Idx;
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
      for (u32Idx = 0; u32Idx < ClusterList.size(); ++u32Idx)
      {
         ClusterList[u32Idx].vDestroy();
      }
#endif // !VARIANT_S_FTR_ENABLE_DEEP_COPY
      oIn >> u32Length;
      ClusterList.resize(u32Length);
      for (u32Idx = 0; u32Idx < u32Length; ++u32Idx)
      {
         oIn >> ClusterList[u32Idx];
      }
   }
   return oIn;
}

fi_tclOutContext& fi_tcl_TMMapOneCellListSet::oWrite(fi_tclOutContext& oOut) const
{
   oOut << (tU32)TMOneCellList.size();
   {
      for (tU32 u32Idx = 0; u32Idx < TMOneCellList.size(); ++u32Idx)
         oOut << TMOneCellList[u32Idx];
   }
   oOut << (tU32)ClusterList.size();
   {
      for (tU32 u32Idx = 0; u32Idx < ClusterList.size(); ++u32Idx)
         oOut << ClusterList[u32Idx];
   }
   return oOut;
}

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
fi_tcl_TrafficSense::fi_tcl_TrafficSense(const fi_tcl_TrafficSense& coRef):fi_tclVisitableTypeBase(coRef)
{
   CountryCode = coRef.CountryCode;
   TrafficSense = coRef.TrafficSense;
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
fi_tcl_TrafficSense& fi_tcl_TrafficSense::operator=(const fi_tcl_TrafficSense& coRef)
{
   if (this == &coRef) return *this;
   CountryCode = coRef.CountryCode;
   TrafficSense = coRef.TrafficSense;
   return *this;
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
tU32 fi_tcl_TrafficSense::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 3;
}

tBool fi_tcl_TrafficSense::operator==(const fi_tcl_TrafficSense& rfoCmp) const
{
   tBool bResult = true;
      bResult = bResult && (CountryCode == rfoCmp.CountryCode);
      bResult = bResult && (TrafficSense == rfoCmp.TrafficSense);
   return bResult;
}

fi_tclInContext& fi_tcl_TrafficSense::oRead(fi_tclInContext& oIn)
{
   oIn >> CountryCode;
   oIn >> TrafficSense;
   return oIn;
}

fi_tclOutContext& fi_tcl_TrafficSense::oWrite(fi_tclOutContext& oOut) const
{
   oOut << CountryCode;
   oOut << TrafficSense;
   return oOut;
}

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
fi_tcl_TrafficSenseList::fi_tcl_TrafficSenseList(const fi_tcl_TrafficSenseList& coRef):fi_tclVisitableTypeBase(coRef)
{
   TrafficSenseList = coRef.TrafficSenseList;
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
fi_tcl_TrafficSenseList& fi_tcl_TrafficSenseList::operator=(const fi_tcl_TrafficSenseList& coRef)
{
   if (this == &coRef) return *this;
   TrafficSenseList = coRef.TrafficSenseList;
   return *this;
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
tVoid fi_tcl_TrafficSenseList::vDestroy()
{
   {
      for (tU32 u32Idx = 0; u32Idx < TrafficSenseList.size(); ++u32Idx)
         TrafficSenseList[u32Idx].vDestroy();
   }
   TrafficSenseList.clear();
}

tU32 fi_tcl_TrafficSenseList::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 4+TrafficSenseList.size()*3;
}

tBool fi_tcl_TrafficSenseList::operator==(const fi_tcl_TrafficSenseList& rfoCmp) const
{
   tBool bResult = true;
      bResult = bResult && (TrafficSenseList.size() == rfoCmp.TrafficSenseList.size());
      if (bResult)
      {
         for (tU32 u32Idx = 0; bResult && (u32Idx < TrafficSenseList.size()); ++u32Idx)
            bResult = bResult && (TrafficSenseList[u32Idx] == rfoCmp.TrafficSenseList[u32Idx]);
      }
   return bResult;
}

fi_tclInContext& fi_tcl_TrafficSenseList::oRead(fi_tclInContext& oIn)
{
   {
      tU32 u32Length;
      tU32 u32Idx;
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
      for (u32Idx = 0; u32Idx < TrafficSenseList.size(); ++u32Idx)
      {
         TrafficSenseList[u32Idx].vDestroy();
      }
#endif // !VARIANT_S_FTR_ENABLE_DEEP_COPY
      oIn >> u32Length;
      TrafficSenseList.resize(u32Length);
      for (u32Idx = 0; u32Idx < u32Length; ++u32Idx)
      {
         oIn >> TrafficSenseList[u32Idx];
      }
   }
   return oIn;
}

fi_tclOutContext& fi_tcl_TrafficSenseList::oWrite(fi_tclOutContext& oOut) const
{
   oOut << (tU32)TrafficSenseList.size();
   {
      for (tU32 u32Idx = 0; u32Idx < TrafficSenseList.size(); ++u32Idx)
         oOut << TrafficSenseList[u32Idx];
   }
   return oOut;
}

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
fi_tcl_SpeedFactor::fi_tcl_SpeedFactor(const fi_tcl_SpeedFactor& coRef):fi_tclVisitableTypeBase(coRef)
{
   RoadClass = coRef.RoadClass;
   SpeedValue = coRef.SpeedValue;
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
fi_tcl_SpeedFactor& fi_tcl_SpeedFactor::operator=(const fi_tcl_SpeedFactor& coRef)
{
   if (this == &coRef) return *this;
   RoadClass = coRef.RoadClass;
   SpeedValue = coRef.SpeedValue;
   return *this;
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
tU32 fi_tcl_SpeedFactor::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 3;
}

tBool fi_tcl_SpeedFactor::operator==(const fi_tcl_SpeedFactor& rfoCmp) const
{
   tBool bResult = true;
      bResult = bResult && (RoadClass == rfoCmp.RoadClass);
      bResult = bResult && (SpeedValue == rfoCmp.SpeedValue);
   return bResult;
}

fi_tclInContext& fi_tcl_SpeedFactor::oRead(fi_tclInContext& oIn)
{
   oIn >> RoadClass;
   oIn >> SpeedValue;
   return oIn;
}

fi_tclOutContext& fi_tcl_SpeedFactor::oWrite(fi_tclOutContext& oOut) const
{
   oOut << RoadClass;
   oOut << SpeedValue;
   return oOut;
}

tU32 fi_tcl_e8_RoadTypeDesc::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 1;
}

tBool fi_tcl_e8_RoadTypeDesc::operator==(const fi_tcl_e8_RoadTypeDesc& rfoCmp) const
{
   return enType == rfoCmp.enType;
}

fi_tclInContext& fi_tcl_e8_RoadTypeDesc::oRead(fi_tclInContext& oIn)
{
   tU8 u8Value;
   oIn >> u8Value;
   enType = (tenType)u8Value;
   return oIn;
}

fi_tclOutContext& fi_tcl_e8_RoadTypeDesc::oWrite(fi_tclOutContext& oOut) const
{
   return oOut.oWrite((tU8)enType);
}

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
fi_tcl_SpeedFactorRoadAreaType::fi_tcl_SpeedFactorRoadAreaType(const fi_tcl_SpeedFactorRoadAreaType& coRef):fi_tclVisitableTypeBase(coRef)
{
   RoadTypeDescription = coRef.RoadTypeDescription;
   SpeedFactor = coRef.SpeedFactor;
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
fi_tcl_SpeedFactorRoadAreaType& fi_tcl_SpeedFactorRoadAreaType::operator=(const fi_tcl_SpeedFactorRoadAreaType& coRef)
{
   if (this == &coRef) return *this;
   RoadTypeDescription = coRef.RoadTypeDescription;
   SpeedFactor = coRef.SpeedFactor;
   return *this;
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
tVoid fi_tcl_SpeedFactorRoadAreaType::vDestroy()
{
   {
      for (tU32 u32Idx = 0; u32Idx < SpeedFactor.size(); ++u32Idx)
         SpeedFactor[u32Idx].vDestroy();
   }
   SpeedFactor.clear();
}

tU32 fi_tcl_SpeedFactorRoadAreaType::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 5+SpeedFactor.size()*3;
}

tBool fi_tcl_SpeedFactorRoadAreaType::operator==(const fi_tcl_SpeedFactorRoadAreaType& rfoCmp) const
{
   tBool bResult = true;
      bResult = bResult && (RoadTypeDescription == rfoCmp.RoadTypeDescription);
      bResult = bResult && (SpeedFactor.size() == rfoCmp.SpeedFactor.size());
      if (bResult)
      {
         for (tU32 u32Idx = 0; bResult && (u32Idx < SpeedFactor.size()); ++u32Idx)
            bResult = bResult && (SpeedFactor[u32Idx] == rfoCmp.SpeedFactor[u32Idx]);
      }
   return bResult;
}

fi_tclInContext& fi_tcl_SpeedFactorRoadAreaType::oRead(fi_tclInContext& oIn)
{
   oIn >> RoadTypeDescription;
   {
      tU32 u32Length;
      tU32 u32Idx;
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
      for (u32Idx = 0; u32Idx < SpeedFactor.size(); ++u32Idx)
      {
         SpeedFactor[u32Idx].vDestroy();
      }
#endif // !VARIANT_S_FTR_ENABLE_DEEP_COPY
      oIn >> u32Length;
      SpeedFactor.resize(u32Length);
      for (u32Idx = 0; u32Idx < u32Length; ++u32Idx)
      {
         oIn >> SpeedFactor[u32Idx];
      }
   }
   return oIn;
}

fi_tclOutContext& fi_tcl_SpeedFactorRoadAreaType::oWrite(fi_tclOutContext& oOut) const
{
   oOut << RoadTypeDescription;
   oOut << (tU32)SpeedFactor.size();
   {
      for (tU32 u32Idx = 0; u32Idx < SpeedFactor.size(); ++u32Idx)
         oOut << SpeedFactor[u32Idx];
   }
   return oOut;
}

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
fi_tcl_SpeedFactorsCountry::fi_tcl_SpeedFactorsCountry(const fi_tcl_SpeedFactorsCountry& coRef):fi_tclVisitableTypeBase(coRef)
{
   CountryCode = coRef.CountryCode;
   SpeedFactorsRoadAreaTypeList = coRef.SpeedFactorsRoadAreaTypeList;
   TimeOffsetToHighway = coRef.TimeOffsetToHighway;
   TimeOffsetOnLongRamp = coRef.TimeOffsetOnLongRamp;
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
fi_tcl_SpeedFactorsCountry& fi_tcl_SpeedFactorsCountry::operator=(const fi_tcl_SpeedFactorsCountry& coRef)
{
   if (this == &coRef) return *this;
   CountryCode = coRef.CountryCode;
   SpeedFactorsRoadAreaTypeList = coRef.SpeedFactorsRoadAreaTypeList;
   TimeOffsetToHighway = coRef.TimeOffsetToHighway;
   TimeOffsetOnLongRamp = coRef.TimeOffsetOnLongRamp;
   return *this;
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
tVoid fi_tcl_SpeedFactorsCountry::vDestroy()
{
   {
      for (tU32 u32Idx = 0; u32Idx < SpeedFactorsRoadAreaTypeList.size(); ++u32Idx)
         SpeedFactorsRoadAreaTypeList[u32Idx].vDestroy();
   }
   SpeedFactorsRoadAreaTypeList.clear();
}

tU32 fi_tcl_SpeedFactorsCountry::u32GetSize(tU16 u16MajorVersion) const
{
   tU32 u32DynamicSize = 0;
   tU32 u32ListIdx;
   for (u32ListIdx = 0; u32ListIdx < SpeedFactorsRoadAreaTypeList.size(); ++u32ListIdx)
      u32DynamicSize += SpeedFactorsRoadAreaTypeList[u32ListIdx].u32GetSize(u16MajorVersion);
   return u32DynamicSize+14;
}

tBool fi_tcl_SpeedFactorsCountry::operator==(const fi_tcl_SpeedFactorsCountry& rfoCmp) const
{
   tBool bResult = true;
      bResult = bResult && (CountryCode == rfoCmp.CountryCode);
      bResult = bResult && (SpeedFactorsRoadAreaTypeList.size() == rfoCmp.SpeedFactorsRoadAreaTypeList.size());
      if (bResult)
      {
         for (tU32 u32Idx = 0; bResult && (u32Idx < SpeedFactorsRoadAreaTypeList.size()); ++u32Idx)
            bResult = bResult && (SpeedFactorsRoadAreaTypeList[u32Idx] == rfoCmp.SpeedFactorsRoadAreaTypeList[u32Idx]);
      }
      bResult = bResult && (TimeOffsetToHighway == rfoCmp.TimeOffsetToHighway);
      bResult = bResult && (TimeOffsetOnLongRamp == rfoCmp.TimeOffsetOnLongRamp);
   return bResult;
}

fi_tclInContext& fi_tcl_SpeedFactorsCountry::oRead(fi_tclInContext& oIn)
{
   oIn >> CountryCode;
   {
      tU32 u32Length;
      tU32 u32Idx;
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
      for (u32Idx = 0; u32Idx < SpeedFactorsRoadAreaTypeList.size(); ++u32Idx)
      {
         SpeedFactorsRoadAreaTypeList[u32Idx].vDestroy();
      }
#endif // !VARIANT_S_FTR_ENABLE_DEEP_COPY
      oIn >> u32Length;
      SpeedFactorsRoadAreaTypeList.resize(u32Length);
      for (u32Idx = 0; u32Idx < u32Length; ++u32Idx)
      {
         oIn >> SpeedFactorsRoadAreaTypeList[u32Idx];
      }
   }
   oIn >> TimeOffsetToHighway;
   oIn >> TimeOffsetOnLongRamp;
   return oIn;
}

fi_tclOutContext& fi_tcl_SpeedFactorsCountry::oWrite(fi_tclOutContext& oOut) const
{
   oOut << CountryCode;
   oOut << (tU32)SpeedFactorsRoadAreaTypeList.size();
   {
      for (tU32 u32Idx = 0; u32Idx < SpeedFactorsRoadAreaTypeList.size(); ++u32Idx)
         oOut << SpeedFactorsRoadAreaTypeList[u32Idx];
   }
   oOut << TimeOffsetToHighway;
   oOut << TimeOffsetOnLongRamp;
   return oOut;
}

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
fi_tcl_SpeedFactorsList::fi_tcl_SpeedFactorsList(const fi_tcl_SpeedFactorsList& coRef):fi_tclVisitableTypeBase(coRef)
{
   SpeedFactorsCountryList = coRef.SpeedFactorsCountryList;
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
fi_tcl_SpeedFactorsList& fi_tcl_SpeedFactorsList::operator=(const fi_tcl_SpeedFactorsList& coRef)
{
   if (this == &coRef) return *this;
   SpeedFactorsCountryList = coRef.SpeedFactorsCountryList;
   return *this;
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
tVoid fi_tcl_SpeedFactorsList::vDestroy()
{
   {
      for (tU32 u32Idx = 0; u32Idx < SpeedFactorsCountryList.size(); ++u32Idx)
         SpeedFactorsCountryList[u32Idx].vDestroy();
   }
   SpeedFactorsCountryList.clear();
}

tU32 fi_tcl_SpeedFactorsList::u32GetSize(tU16 u16MajorVersion) const
{
   tU32 u32DynamicSize = 0;
   tU32 u32ListIdx;
   for (u32ListIdx = 0; u32ListIdx < SpeedFactorsCountryList.size(); ++u32ListIdx)
      u32DynamicSize += SpeedFactorsCountryList[u32ListIdx].u32GetSize(u16MajorVersion);
   return u32DynamicSize+4;
}

tBool fi_tcl_SpeedFactorsList::operator==(const fi_tcl_SpeedFactorsList& rfoCmp) const
{
   tBool bResult = true;
      bResult = bResult && (SpeedFactorsCountryList.size() == rfoCmp.SpeedFactorsCountryList.size());
      if (bResult)
      {
         for (tU32 u32Idx = 0; bResult && (u32Idx < SpeedFactorsCountryList.size()); ++u32Idx)
            bResult = bResult && (SpeedFactorsCountryList[u32Idx] == rfoCmp.SpeedFactorsCountryList[u32Idx]);
      }
   return bResult;
}

fi_tclInContext& fi_tcl_SpeedFactorsList::oRead(fi_tclInContext& oIn)
{
   {
      tU32 u32Length;
      tU32 u32Idx;
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
      for (u32Idx = 0; u32Idx < SpeedFactorsCountryList.size(); ++u32Idx)
      {
         SpeedFactorsCountryList[u32Idx].vDestroy();
      }
#endif // !VARIANT_S_FTR_ENABLE_DEEP_COPY
      oIn >> u32Length;
      SpeedFactorsCountryList.resize(u32Length);
      for (u32Idx = 0; u32Idx < u32Length; ++u32Idx)
      {
         oIn >> SpeedFactorsCountryList[u32Idx];
      }
   }
   return oIn;
}

fi_tclOutContext& fi_tcl_SpeedFactorsList::oWrite(fi_tclOutContext& oOut) const
{
   oOut << (tU32)SpeedFactorsCountryList.size();
   {
      for (tU32 u32Idx = 0; u32Idx < SpeedFactorsCountryList.size(); ++u32Idx)
         oOut << SpeedFactorsCountryList[u32Idx];
   }
   return oOut;
}

tU32 fi_tcl_b8_SpeedLimitStatus::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 1;
}

tBool fi_tcl_b8_SpeedLimitStatus::operator==(const fi_tcl_b8_SpeedLimitStatus& rfoCmp) const
{
   return u8Value == rfoCmp.u8Value;
}

fi_tclInContext& fi_tcl_b8_SpeedLimitStatus::oRead(fi_tclInContext& oIn)
{
   return oIn >> u8Value;
}

fi_tclOutContext& fi_tcl_b8_SpeedLimitStatus::oWrite(fi_tclOutContext& oOut) const
{
   return oOut << u8Value;
}

tU32 fi_tcl_e8_SpeedUnit::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 1;
}

tBool fi_tcl_e8_SpeedUnit::operator==(const fi_tcl_e8_SpeedUnit& rfoCmp) const
{
   return enType == rfoCmp.enType;
}

fi_tclInContext& fi_tcl_e8_SpeedUnit::oRead(fi_tclInContext& oIn)
{
   tU8 u8Value;
   oIn >> u8Value;
   enType = (tenType)u8Value;
   return oIn;
}

fi_tclOutContext& fi_tcl_e8_SpeedUnit::oWrite(fi_tclOutContext& oOut) const
{
   return oOut.oWrite((tU8)enType);
}

tU32 fi_tcl_e8_SpeedType::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 1;
}

tBool fi_tcl_e8_SpeedType::operator==(const fi_tcl_e8_SpeedType& rfoCmp) const
{
   return enType == rfoCmp.enType;
}

fi_tclInContext& fi_tcl_e8_SpeedType::oRead(fi_tclInContext& oIn)
{
   tU8 u8Value;
   oIn >> u8Value;
   enType = (tenType)u8Value;
   return oIn;
}

fi_tclOutContext& fi_tcl_e8_SpeedType::oWrite(fi_tclOutContext& oOut) const
{
   return oOut.oWrite((tU8)enType);
}

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
fi_tcl_SpeedLimitStatus::fi_tcl_SpeedLimitStatus(const fi_tcl_SpeedLimitStatus& coRef):fi_tclVisitableTypeBase(coRef)
{
   SpeedUnit = coRef.SpeedUnit;
   SpeedType = coRef.SpeedType;
   Status = coRef.Status;
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
fi_tcl_SpeedLimitStatus& fi_tcl_SpeedLimitStatus::operator=(const fi_tcl_SpeedLimitStatus& coRef)
{
   if (this == &coRef) return *this;
   SpeedUnit = coRef.SpeedUnit;
   SpeedType = coRef.SpeedType;
   Status = coRef.Status;
   return *this;
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
tU32 fi_tcl_SpeedLimitStatus::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 3;
}

tBool fi_tcl_SpeedLimitStatus::operator==(const fi_tcl_SpeedLimitStatus& rfoCmp) const
{
   tBool bResult = true;
      bResult = bResult && (SpeedUnit == rfoCmp.SpeedUnit);
      bResult = bResult && (SpeedType == rfoCmp.SpeedType);
      bResult = bResult && (Status == rfoCmp.Status);
   return bResult;
}

fi_tclInContext& fi_tcl_SpeedLimitStatus::oRead(fi_tclInContext& oIn)
{
   oIn >> SpeedUnit;
   oIn >> SpeedType;
   oIn >> Status;
   return oIn;
}

fi_tclOutContext& fi_tcl_SpeedLimitStatus::oWrite(fi_tclOutContext& oOut) const
{
   oOut << SpeedUnit;
   oOut << SpeedType;
   oOut << Status;
   return oOut;
}

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
fi_tcl_SpeedLimit::fi_tcl_SpeedLimit(const fi_tcl_SpeedLimit& coRef):fi_tclVisitableTypeBase(coRef)
{
   RoadClass = coRef.RoadClass;
   SpeedValue = coRef.SpeedValue;
   Status = coRef.Status;
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
fi_tcl_SpeedLimit& fi_tcl_SpeedLimit::operator=(const fi_tcl_SpeedLimit& coRef)
{
   if (this == &coRef) return *this;
   RoadClass = coRef.RoadClass;
   SpeedValue = coRef.SpeedValue;
   Status = coRef.Status;
   return *this;
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
tVoid fi_tcl_SpeedLimit::vDestroy()
{
   Status.vDestroy(); 
}

tU32 fi_tcl_SpeedLimit::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 5;
}

tBool fi_tcl_SpeedLimit::operator==(const fi_tcl_SpeedLimit& rfoCmp) const
{
   tBool bResult = true;
      bResult = bResult && (RoadClass == rfoCmp.RoadClass);
      bResult = bResult && (SpeedValue == rfoCmp.SpeedValue);
      bResult = bResult && (Status == rfoCmp.Status);
   return bResult;
}

fi_tclInContext& fi_tcl_SpeedLimit::oRead(fi_tclInContext& oIn)
{
   oIn >> RoadClass;
   oIn >> SpeedValue;
   oIn >> Status;
   return oIn;
}

fi_tclOutContext& fi_tcl_SpeedLimit::oWrite(fi_tclOutContext& oOut) const
{
   oOut << RoadClass;
   oOut << SpeedValue;
   oOut << Status;
   return oOut;
}

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
fi_tcl_SpeedLimitRoadAreaType::fi_tcl_SpeedLimitRoadAreaType(const fi_tcl_SpeedLimitRoadAreaType& coRef):fi_tclVisitableTypeBase(coRef)
{
   RoadTypeDescription = coRef.RoadTypeDescription;
   SpeedLimitRoadClassList = coRef.SpeedLimitRoadClassList;
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
fi_tcl_SpeedLimitRoadAreaType& fi_tcl_SpeedLimitRoadAreaType::operator=(const fi_tcl_SpeedLimitRoadAreaType& coRef)
{
   if (this == &coRef) return *this;
   RoadTypeDescription = coRef.RoadTypeDescription;
   SpeedLimitRoadClassList = coRef.SpeedLimitRoadClassList;
   return *this;
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
tVoid fi_tcl_SpeedLimitRoadAreaType::vDestroy()
{
   {
      for (tU32 u32Idx = 0; u32Idx < SpeedLimitRoadClassList.size(); ++u32Idx)
         SpeedLimitRoadClassList[u32Idx].vDestroy();
   }
   SpeedLimitRoadClassList.clear();
}

tU32 fi_tcl_SpeedLimitRoadAreaType::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 5+SpeedLimitRoadClassList.size()*5;
}

tBool fi_tcl_SpeedLimitRoadAreaType::operator==(const fi_tcl_SpeedLimitRoadAreaType& rfoCmp) const
{
   tBool bResult = true;
      bResult = bResult && (RoadTypeDescription == rfoCmp.RoadTypeDescription);
      bResult = bResult && (SpeedLimitRoadClassList.size() == rfoCmp.SpeedLimitRoadClassList.size());
      if (bResult)
      {
         for (tU32 u32Idx = 0; bResult && (u32Idx < SpeedLimitRoadClassList.size()); ++u32Idx)
            bResult = bResult && (SpeedLimitRoadClassList[u32Idx] == rfoCmp.SpeedLimitRoadClassList[u32Idx]);
      }
   return bResult;
}

fi_tclInContext& fi_tcl_SpeedLimitRoadAreaType::oRead(fi_tclInContext& oIn)
{
   oIn >> RoadTypeDescription;
   {
      tU32 u32Length;
      tU32 u32Idx;
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
      for (u32Idx = 0; u32Idx < SpeedLimitRoadClassList.size(); ++u32Idx)
      {
         SpeedLimitRoadClassList[u32Idx].vDestroy();
      }
#endif // !VARIANT_S_FTR_ENABLE_DEEP_COPY
      oIn >> u32Length;
      SpeedLimitRoadClassList.resize(u32Length);
      for (u32Idx = 0; u32Idx < u32Length; ++u32Idx)
      {
         oIn >> SpeedLimitRoadClassList[u32Idx];
      }
   }
   return oIn;
}

fi_tclOutContext& fi_tcl_SpeedLimitRoadAreaType::oWrite(fi_tclOutContext& oOut) const
{
   oOut << RoadTypeDescription;
   oOut << (tU32)SpeedLimitRoadClassList.size();
   {
      for (tU32 u32Idx = 0; u32Idx < SpeedLimitRoadClassList.size(); ++u32Idx)
         oOut << SpeedLimitRoadClassList[u32Idx];
   }
   return oOut;
}

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
fi_tcl_SpeedLimitsCountry::fi_tcl_SpeedLimitsCountry(const fi_tcl_SpeedLimitsCountry& coRef):fi_tclVisitableTypeBase(coRef)
{
   CountryCode = coRef.CountryCode;
   SpeedLimitsRoadAreaTypeList = coRef.SpeedLimitsRoadAreaTypeList;
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
fi_tcl_SpeedLimitsCountry& fi_tcl_SpeedLimitsCountry::operator=(const fi_tcl_SpeedLimitsCountry& coRef)
{
   if (this == &coRef) return *this;
   CountryCode = coRef.CountryCode;
   SpeedLimitsRoadAreaTypeList = coRef.SpeedLimitsRoadAreaTypeList;
   return *this;
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
tVoid fi_tcl_SpeedLimitsCountry::vDestroy()
{
   {
      for (tU32 u32Idx = 0; u32Idx < SpeedLimitsRoadAreaTypeList.size(); ++u32Idx)
         SpeedLimitsRoadAreaTypeList[u32Idx].vDestroy();
   }
   SpeedLimitsRoadAreaTypeList.clear();
}

tU32 fi_tcl_SpeedLimitsCountry::u32GetSize(tU16 u16MajorVersion) const
{
   tU32 u32DynamicSize = 0;
   tU32 u32ListIdx;
   for (u32ListIdx = 0; u32ListIdx < SpeedLimitsRoadAreaTypeList.size(); ++u32ListIdx)
      u32DynamicSize += SpeedLimitsRoadAreaTypeList[u32ListIdx].u32GetSize(u16MajorVersion);
   return u32DynamicSize+6;
}

tBool fi_tcl_SpeedLimitsCountry::operator==(const fi_tcl_SpeedLimitsCountry& rfoCmp) const
{
   tBool bResult = true;
      bResult = bResult && (CountryCode == rfoCmp.CountryCode);
      bResult = bResult && (SpeedLimitsRoadAreaTypeList.size() == rfoCmp.SpeedLimitsRoadAreaTypeList.size());
      if (bResult)
      {
         for (tU32 u32Idx = 0; bResult && (u32Idx < SpeedLimitsRoadAreaTypeList.size()); ++u32Idx)
            bResult = bResult && (SpeedLimitsRoadAreaTypeList[u32Idx] == rfoCmp.SpeedLimitsRoadAreaTypeList[u32Idx]);
      }
   return bResult;
}

fi_tclInContext& fi_tcl_SpeedLimitsCountry::oRead(fi_tclInContext& oIn)
{
   oIn >> CountryCode;
   {
      tU32 u32Length;
      tU32 u32Idx;
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
      for (u32Idx = 0; u32Idx < SpeedLimitsRoadAreaTypeList.size(); ++u32Idx)
      {
         SpeedLimitsRoadAreaTypeList[u32Idx].vDestroy();
      }
#endif // !VARIANT_S_FTR_ENABLE_DEEP_COPY
      oIn >> u32Length;
      SpeedLimitsRoadAreaTypeList.resize(u32Length);
      for (u32Idx = 0; u32Idx < u32Length; ++u32Idx)
      {
         oIn >> SpeedLimitsRoadAreaTypeList[u32Idx];
      }
   }
   return oIn;
}

fi_tclOutContext& fi_tcl_SpeedLimitsCountry::oWrite(fi_tclOutContext& oOut) const
{
   oOut << CountryCode;
   oOut << (tU32)SpeedLimitsRoadAreaTypeList.size();
   {
      for (tU32 u32Idx = 0; u32Idx < SpeedLimitsRoadAreaTypeList.size(); ++u32Idx)
         oOut << SpeedLimitsRoadAreaTypeList[u32Idx];
   }
   return oOut;
}

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
fi_tcl_SpeedLimitsList::fi_tcl_SpeedLimitsList(const fi_tcl_SpeedLimitsList& coRef):fi_tclVisitableTypeBase(coRef)
{
   SpeedLimitsCountryList = coRef.SpeedLimitsCountryList;
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
fi_tcl_SpeedLimitsList& fi_tcl_SpeedLimitsList::operator=(const fi_tcl_SpeedLimitsList& coRef)
{
   if (this == &coRef) return *this;
   SpeedLimitsCountryList = coRef.SpeedLimitsCountryList;
   return *this;
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
tVoid fi_tcl_SpeedLimitsList::vDestroy()
{
   {
      for (tU32 u32Idx = 0; u32Idx < SpeedLimitsCountryList.size(); ++u32Idx)
         SpeedLimitsCountryList[u32Idx].vDestroy();
   }
   SpeedLimitsCountryList.clear();
}

tU32 fi_tcl_SpeedLimitsList::u32GetSize(tU16 u16MajorVersion) const
{
   tU32 u32DynamicSize = 0;
   tU32 u32ListIdx;
   for (u32ListIdx = 0; u32ListIdx < SpeedLimitsCountryList.size(); ++u32ListIdx)
      u32DynamicSize += SpeedLimitsCountryList[u32ListIdx].u32GetSize(u16MajorVersion);
   return u32DynamicSize+4;
}

tBool fi_tcl_SpeedLimitsList::operator==(const fi_tcl_SpeedLimitsList& rfoCmp) const
{
   tBool bResult = true;
      bResult = bResult && (SpeedLimitsCountryList.size() == rfoCmp.SpeedLimitsCountryList.size());
      if (bResult)
      {
         for (tU32 u32Idx = 0; bResult && (u32Idx < SpeedLimitsCountryList.size()); ++u32Idx)
            bResult = bResult && (SpeedLimitsCountryList[u32Idx] == rfoCmp.SpeedLimitsCountryList[u32Idx]);
      }
   return bResult;
}

fi_tclInContext& fi_tcl_SpeedLimitsList::oRead(fi_tclInContext& oIn)
{
   {
      tU32 u32Length;
      tU32 u32Idx;
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
      for (u32Idx = 0; u32Idx < SpeedLimitsCountryList.size(); ++u32Idx)
      {
         SpeedLimitsCountryList[u32Idx].vDestroy();
      }
#endif // !VARIANT_S_FTR_ENABLE_DEEP_COPY
      oIn >> u32Length;
      SpeedLimitsCountryList.resize(u32Length);
      for (u32Idx = 0; u32Idx < u32Length; ++u32Idx)
      {
         oIn >> SpeedLimitsCountryList[u32Idx];
      }
   }
   return oIn;
}

fi_tclOutContext& fi_tcl_SpeedLimitsList::oWrite(fi_tclOutContext& oOut) const
{
   oOut << (tU32)SpeedLimitsCountryList.size();
   {
      for (tU32 u32Idx = 0; u32Idx < SpeedLimitsCountryList.size(); ++u32Idx)
         oOut << SpeedLimitsCountryList[u32Idx];
   }
   return oOut;
}

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
fi_tcl_PrefixDesc::fi_tcl_PrefixDesc(const fi_tcl_PrefixDesc& coRef):fi_tclVisitableTypeBase(coRef)
{
   Mode = coRef.Mode;
   Prefix = coRef.Prefix;
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
fi_tcl_PrefixDesc& fi_tcl_PrefixDesc::operator=(const fi_tcl_PrefixDesc& coRef)
{
   if (this == &coRef) return *this;
   Mode = coRef.Mode;
   Prefix = coRef.Prefix;
   return *this;
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
tVoid fi_tcl_PrefixDesc::vDestroy()
{
   Prefix.vDestroy();
}

tU32 fi_tcl_PrefixDesc::u32GetSize(tU16 u16MajorVersion) const
{
   return 2+Prefix.u32GetSize(u16MajorVersion);
}

tBool fi_tcl_PrefixDesc::operator==(const fi_tcl_PrefixDesc& rfoCmp) const
{
   tBool bResult = true;
      bResult = bResult && (Mode == rfoCmp.Mode);
      bResult = bResult && (Prefix == rfoCmp.Prefix);
   return bResult;
}

fi_tclInContext& fi_tcl_PrefixDesc::oRead(fi_tclInContext& oIn)
{
   oIn >> Mode;
   oIn >> Prefix;
   return oIn;
}

fi_tclOutContext& fi_tcl_PrefixDesc::oWrite(fi_tclOutContext& oOut) const
{
   oOut << Mode;
   oOut << Prefix;
   return oOut;
}

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
fi_tcl_PrefixState::fi_tcl_PrefixState(const fi_tcl_PrefixState& coRef):fi_tclVisitableTypeBase(coRef)
{
   CountryCode = coRef.CountryCode;
   PrefixDescList = coRef.PrefixDescList;
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
fi_tcl_PrefixState& fi_tcl_PrefixState::operator=(const fi_tcl_PrefixState& coRef)
{
   if (this == &coRef) return *this;
   CountryCode = coRef.CountryCode;
   PrefixDescList = coRef.PrefixDescList;
   return *this;
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
tVoid fi_tcl_PrefixState::vDestroy()
{
   {
      for (tU32 u32Idx = 0; u32Idx < PrefixDescList.size(); ++u32Idx)
         PrefixDescList[u32Idx].vDestroy();
   }
   PrefixDescList.clear();
}

tU32 fi_tcl_PrefixState::u32GetSize(tU16 u16MajorVersion) const
{
   tU32 u32DynamicSize = 0;
   tU32 u32ListIdx;
   for (u32ListIdx = 0; u32ListIdx < PrefixDescList.size(); ++u32ListIdx)
      u32DynamicSize += PrefixDescList[u32ListIdx].u32GetSize(u16MajorVersion);
   return u32DynamicSize+6;
}

tBool fi_tcl_PrefixState::operator==(const fi_tcl_PrefixState& rfoCmp) const
{
   tBool bResult = true;
      bResult = bResult && (CountryCode == rfoCmp.CountryCode);
      bResult = bResult && (PrefixDescList.size() == rfoCmp.PrefixDescList.size());
      if (bResult)
      {
         for (tU32 u32Idx = 0; bResult && (u32Idx < PrefixDescList.size()); ++u32Idx)
            bResult = bResult && (PrefixDescList[u32Idx] == rfoCmp.PrefixDescList[u32Idx]);
      }
   return bResult;
}

fi_tclInContext& fi_tcl_PrefixState::oRead(fi_tclInContext& oIn)
{
   oIn >> CountryCode;
   {
      tU32 u32Length;
      tU32 u32Idx;
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
      for (u32Idx = 0; u32Idx < PrefixDescList.size(); ++u32Idx)
      {
         PrefixDescList[u32Idx].vDestroy();
      }
#endif // !VARIANT_S_FTR_ENABLE_DEEP_COPY
      oIn >> u32Length;
      PrefixDescList.resize(u32Length);
      for (u32Idx = 0; u32Idx < u32Length; ++u32Idx)
      {
         oIn >> PrefixDescList[u32Idx];
      }
   }
   return oIn;
}

fi_tclOutContext& fi_tcl_PrefixState::oWrite(fi_tclOutContext& oOut) const
{
   oOut << CountryCode;
   oOut << (tU32)PrefixDescList.size();
   {
      for (tU32 u32Idx = 0; u32Idx < PrefixDescList.size(); ++u32Idx)
         oOut << PrefixDescList[u32Idx];
   }
   return oOut;
}

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
fi_tcl_PrefixStateList::fi_tcl_PrefixStateList(const fi_tcl_PrefixStateList& coRef):fi_tclVisitableTypeBase(coRef)
{
   PrefixStateList = coRef.PrefixStateList;
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
fi_tcl_PrefixStateList& fi_tcl_PrefixStateList::operator=(const fi_tcl_PrefixStateList& coRef)
{
   if (this == &coRef) return *this;
   PrefixStateList = coRef.PrefixStateList;
   return *this;
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
tVoid fi_tcl_PrefixStateList::vDestroy()
{
   {
      for (tU32 u32Idx = 0; u32Idx < PrefixStateList.size(); ++u32Idx)
         PrefixStateList[u32Idx].vDestroy();
   }
   PrefixStateList.clear();
}

tU32 fi_tcl_PrefixStateList::u32GetSize(tU16 u16MajorVersion) const
{
   tU32 u32DynamicSize = 0;
   tU32 u32ListIdx;
   for (u32ListIdx = 0; u32ListIdx < PrefixStateList.size(); ++u32ListIdx)
      u32DynamicSize += PrefixStateList[u32ListIdx].u32GetSize(u16MajorVersion);
   return u32DynamicSize+4;
}

tBool fi_tcl_PrefixStateList::operator==(const fi_tcl_PrefixStateList& rfoCmp) const
{
   tBool bResult = true;
      bResult = bResult && (PrefixStateList.size() == rfoCmp.PrefixStateList.size());
      if (bResult)
      {
         for (tU32 u32Idx = 0; bResult && (u32Idx < PrefixStateList.size()); ++u32Idx)
            bResult = bResult && (PrefixStateList[u32Idx] == rfoCmp.PrefixStateList[u32Idx]);
      }
   return bResult;
}

fi_tclInContext& fi_tcl_PrefixStateList::oRead(fi_tclInContext& oIn)
{
   {
      tU32 u32Length;
      tU32 u32Idx;
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
      for (u32Idx = 0; u32Idx < PrefixStateList.size(); ++u32Idx)
      {
         PrefixStateList[u32Idx].vDestroy();
      }
#endif // !VARIANT_S_FTR_ENABLE_DEEP_COPY
      oIn >> u32Length;
      PrefixStateList.resize(u32Length);
      for (u32Idx = 0; u32Idx < u32Length; ++u32Idx)
      {
         oIn >> PrefixStateList[u32Idx];
      }
   }
   return oIn;
}

fi_tclOutContext& fi_tcl_PrefixStateList::oWrite(fi_tclOutContext& oOut) const
{
   oOut << (tU32)PrefixStateList.size();
   {
      for (tU32 u32Idx = 0; u32Idx < PrefixStateList.size(); ++u32Idx)
         oOut << PrefixStateList[u32Idx];
   }
   return oOut;
}

tU32 fi_tcl_e8_LanguageCat::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 1;
}

tBool fi_tcl_e8_LanguageCat::operator==(const fi_tcl_e8_LanguageCat& rfoCmp) const
{
   return enType == rfoCmp.enType;
}

fi_tclInContext& fi_tcl_e8_LanguageCat::oRead(fi_tclInContext& oIn)
{
   tU8 u8Value;
   oIn >> u8Value;
   enType = (tenType)u8Value;
   return oIn;
}

fi_tclOutContext& fi_tcl_e8_LanguageCat::oWrite(fi_tclOutContext& oOut) const
{
   return oOut.oWrite((tU8)enType);
}

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
fi_tcl_LanguageCategory::fi_tcl_LanguageCategory(const fi_tcl_LanguageCategory& coRef):fi_tclVisitableTypeBase(coRef)
{
   LanguageCat = coRef.LanguageCat;
   Word = coRef.Word;
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
fi_tcl_LanguageCategory& fi_tcl_LanguageCategory::operator=(const fi_tcl_LanguageCategory& coRef)
{
   if (this == &coRef) return *this;
   LanguageCat = coRef.LanguageCat;
   Word = coRef.Word;
   return *this;
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
tVoid fi_tcl_LanguageCategory::vDestroy()
{
   {
      for (tU32 u32Idx = 0; u32Idx < Word.size(); ++u32Idx)
         Word[u32Idx].vDestroy();
   }
   Word.clear();
}

tU32 fi_tcl_LanguageCategory::u32GetSize(tU16 u16MajorVersion) const
{
   tU32 u32DynamicSize = 0;
   tU32 u32ListIdx;
   for (u32ListIdx = 0; u32ListIdx < Word.size(); ++u32ListIdx)
      u32DynamicSize += Word[u32ListIdx].u32GetSize(u16MajorVersion);
   return u32DynamicSize+5;
}

tBool fi_tcl_LanguageCategory::operator==(const fi_tcl_LanguageCategory& rfoCmp) const
{
   tBool bResult = true;
      bResult = bResult && (LanguageCat == rfoCmp.LanguageCat);
      bResult = bResult && (Word.size() == rfoCmp.Word.size());
      if (bResult)
      {
         for (tU32 u32Idx = 0; bResult && (u32Idx < Word.size()); ++u32Idx)
            bResult = bResult && (Word[u32Idx] == rfoCmp.Word[u32Idx]);
      }
   return bResult;
}

fi_tclInContext& fi_tcl_LanguageCategory::oRead(fi_tclInContext& oIn)
{
   oIn >> LanguageCat;
   {
      tU32 u32Length;
      tU32 u32Idx;
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
      for (u32Idx = 0; u32Idx < Word.size(); ++u32Idx)
      {
         Word[u32Idx].vDestroy();
      }
#endif // !VARIANT_S_FTR_ENABLE_DEEP_COPY
      oIn >> u32Length;
      Word.resize(u32Length);
      for (u32Idx = 0; u32Idx < u32Length; ++u32Idx)
      {
         oIn >> Word[u32Idx];
      }
   }
   return oIn;
}

fi_tclOutContext& fi_tcl_LanguageCategory::oWrite(fi_tclOutContext& oOut) const
{
   oOut << LanguageCat;
   oOut << (tU32)Word.size();
   {
      for (tU32 u32Idx = 0; u32Idx < Word.size(); ++u32Idx)
         oOut << Word[u32Idx];
   }
   return oOut;
}

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
fi_tcl_LanguageDesc::fi_tcl_LanguageDesc(const fi_tcl_LanguageDesc& coRef):fi_tclVisitableTypeBase(coRef)
{
   LanguageId = coRef.LanguageId;
   LanguageCategoryList = coRef.LanguageCategoryList;
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
fi_tcl_LanguageDesc& fi_tcl_LanguageDesc::operator=(const fi_tcl_LanguageDesc& coRef)
{
   if (this == &coRef) return *this;
   LanguageId = coRef.LanguageId;
   LanguageCategoryList = coRef.LanguageCategoryList;
   return *this;
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
tVoid fi_tcl_LanguageDesc::vDestroy()
{
   {
      for (tU32 u32Idx = 0; u32Idx < LanguageCategoryList.size(); ++u32Idx)
         LanguageCategoryList[u32Idx].vDestroy();
   }
   LanguageCategoryList.clear();
}

tU32 fi_tcl_LanguageDesc::u32GetSize(tU16 u16MajorVersion) const
{
   tU32 u32DynamicSize = 0;
   tU32 u32ListIdx;
   for (u32ListIdx = 0; u32ListIdx < LanguageCategoryList.size(); ++u32ListIdx)
      u32DynamicSize += LanguageCategoryList[u32ListIdx].u32GetSize(u16MajorVersion);
   return u32DynamicSize+6;
}

tBool fi_tcl_LanguageDesc::operator==(const fi_tcl_LanguageDesc& rfoCmp) const
{
   tBool bResult = true;
      bResult = bResult && (LanguageId == rfoCmp.LanguageId);
      bResult = bResult && (LanguageCategoryList.size() == rfoCmp.LanguageCategoryList.size());
      if (bResult)
      {
         for (tU32 u32Idx = 0; bResult && (u32Idx < LanguageCategoryList.size()); ++u32Idx)
            bResult = bResult && (LanguageCategoryList[u32Idx] == rfoCmp.LanguageCategoryList[u32Idx]);
      }
   return bResult;
}

fi_tclInContext& fi_tcl_LanguageDesc::oRead(fi_tclInContext& oIn)
{
   oIn >> LanguageId;
   {
      tU32 u32Length;
      tU32 u32Idx;
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
      for (u32Idx = 0; u32Idx < LanguageCategoryList.size(); ++u32Idx)
      {
         LanguageCategoryList[u32Idx].vDestroy();
      }
#endif // !VARIANT_S_FTR_ENABLE_DEEP_COPY
      oIn >> u32Length;
      LanguageCategoryList.resize(u32Length);
      for (u32Idx = 0; u32Idx < u32Length; ++u32Idx)
      {
         oIn >> LanguageCategoryList[u32Idx];
      }
   }
   return oIn;
}

fi_tclOutContext& fi_tcl_LanguageDesc::oWrite(fi_tclOutContext& oOut) const
{
   oOut << LanguageId;
   oOut << (tU32)LanguageCategoryList.size();
   {
      for (tU32 u32Idx = 0; u32Idx < LanguageCategoryList.size(); ++u32Idx)
         oOut << LanguageCategoryList[u32Idx];
   }
   return oOut;
}

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
fi_tcl_LanguageDescList::fi_tcl_LanguageDescList(const fi_tcl_LanguageDescList& coRef):fi_tclVisitableTypeBase(coRef)
{
   LanguageDescList = coRef.LanguageDescList;
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
fi_tcl_LanguageDescList& fi_tcl_LanguageDescList::operator=(const fi_tcl_LanguageDescList& coRef)
{
   if (this == &coRef) return *this;
   LanguageDescList = coRef.LanguageDescList;
   return *this;
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
tVoid fi_tcl_LanguageDescList::vDestroy()
{
   {
      for (tU32 u32Idx = 0; u32Idx < LanguageDescList.size(); ++u32Idx)
         LanguageDescList[u32Idx].vDestroy();
   }
   LanguageDescList.clear();
}

tU32 fi_tcl_LanguageDescList::u32GetSize(tU16 u16MajorVersion) const
{
   tU32 u32DynamicSize = 0;
   tU32 u32ListIdx;
   for (u32ListIdx = 0; u32ListIdx < LanguageDescList.size(); ++u32ListIdx)
      u32DynamicSize += LanguageDescList[u32ListIdx].u32GetSize(u16MajorVersion);
   return u32DynamicSize+4;
}

tBool fi_tcl_LanguageDescList::operator==(const fi_tcl_LanguageDescList& rfoCmp) const
{
   tBool bResult = true;
      bResult = bResult && (LanguageDescList.size() == rfoCmp.LanguageDescList.size());
      if (bResult)
      {
         for (tU32 u32Idx = 0; bResult && (u32Idx < LanguageDescList.size()); ++u32Idx)
            bResult = bResult && (LanguageDescList[u32Idx] == rfoCmp.LanguageDescList[u32Idx]);
      }
   return bResult;
}

fi_tclInContext& fi_tcl_LanguageDescList::oRead(fi_tclInContext& oIn)
{
   {
      tU32 u32Length;
      tU32 u32Idx;
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
      for (u32Idx = 0; u32Idx < LanguageDescList.size(); ++u32Idx)
      {
         LanguageDescList[u32Idx].vDestroy();
      }
#endif // !VARIANT_S_FTR_ENABLE_DEEP_COPY
      oIn >> u32Length;
      LanguageDescList.resize(u32Length);
      for (u32Idx = 0; u32Idx < u32Length; ++u32Idx)
      {
         oIn >> LanguageDescList[u32Idx];
      }
   }
   return oIn;
}

fi_tclOutContext& fi_tcl_LanguageDescList::oWrite(fi_tclOutContext& oOut) const
{
   oOut << (tU32)LanguageDescList.size();
   {
      for (tU32 u32Idx = 0; u32Idx < LanguageDescList.size(); ++u32Idx)
         oOut << LanguageDescList[u32Idx];
   }
   return oOut;
}

tU32 fi_tcl_e8_GlobalAnnotationCategory::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 1;
}

tBool fi_tcl_e8_GlobalAnnotationCategory::operator==(const fi_tcl_e8_GlobalAnnotationCategory& rfoCmp) const
{
   return enType == rfoCmp.enType;
}

fi_tclInContext& fi_tcl_e8_GlobalAnnotationCategory::oRead(fi_tclInContext& oIn)
{
   tU8 u8Value;
   oIn >> u8Value;
   enType = (tenType)u8Value;
   return oIn;
}

fi_tclOutContext& fi_tcl_e8_GlobalAnnotationCategory::oWrite(fi_tclOutContext& oOut) const
{
   return oOut.oWrite((tU8)enType);
}

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
fi_tcl_GlobalAnnotationTablesUnion::fi_tcl_GlobalAnnotationTablesUnion(const fi_tcl_GlobalAnnotationTablesUnion& coRef):fi_tclVisitableTypeBase(coRef)
{
   GlobalAnnotationUnionType = coRef.GlobalAnnotationUnionType;
   if  (coRef.poGlobalAnnotationUnionData)
   {
      switch(GlobalAnnotationUnionType.enType)
      {
      case fi_tcl_e8_GlobalAnnotationCategory::FI_EN_T_RESERVED:
         poGlobalAnnotationUnionData = OSAL_NEW fi_tcl_Reserved((const fi_tcl_Reserved&)*coRef.poGlobalAnnotationUnionData);
         break;
      case fi_tcl_e8_GlobalAnnotationCategory::FI_EN_T_TRAFFICSENSELIST:
         poGlobalAnnotationUnionData = OSAL_NEW fi_tcl_TrafficSenseList((const fi_tcl_TrafficSenseList&)*coRef.poGlobalAnnotationUnionData);
         break;
      case fi_tcl_e8_GlobalAnnotationCategory::FI_EN_T_SPEEDFACTORSLIST:
         poGlobalAnnotationUnionData = OSAL_NEW fi_tcl_SpeedFactorsList((const fi_tcl_SpeedFactorsList&)*coRef.poGlobalAnnotationUnionData);
         break;
      case fi_tcl_e8_GlobalAnnotationCategory::FI_EN_T_SPEEDLIMITSLIST:
         poGlobalAnnotationUnionData = OSAL_NEW fi_tcl_SpeedLimitsList((const fi_tcl_SpeedLimitsList&)*coRef.poGlobalAnnotationUnionData);
         break;
      case fi_tcl_e8_GlobalAnnotationCategory::FI_EN_T_REQUIREDPERMISSIONLIST:
         poGlobalAnnotationUnionData = OSAL_NEW fi_tcl_RequiredPermissionList((const fi_tcl_RequiredPermissionList&)*coRef.poGlobalAnnotationUnionData);
         break;
      case fi_tcl_e8_GlobalAnnotationCategory::FI_EN_T_PREFIXSTATELIST:
         poGlobalAnnotationUnionData = OSAL_NEW fi_tcl_PrefixStateList((const fi_tcl_PrefixStateList&)*coRef.poGlobalAnnotationUnionData);
         break;
      case fi_tcl_e8_GlobalAnnotationCategory::FI_EN_T_LANGUAGEDESCLIST:
         poGlobalAnnotationUnionData = OSAL_NEW fi_tcl_LanguageDescList((const fi_tcl_LanguageDescList&)*coRef.poGlobalAnnotationUnionData);
         break;
      default:
         poGlobalAnnotationUnionData = OSAL_NULL;
      }
   }
   else
   {
      poGlobalAnnotationUnionData = OSAL_NULL;
   }
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
fi_tcl_GlobalAnnotationTablesUnion& fi_tcl_GlobalAnnotationTablesUnion::operator=(const fi_tcl_GlobalAnnotationTablesUnion& coRef)
{
   if (this == &coRef) return *this;
   OSAL_DELETE poGlobalAnnotationUnionData;
   GlobalAnnotationUnionType = coRef.GlobalAnnotationUnionType;
   if  (coRef.poGlobalAnnotationUnionData)
   {
      switch(GlobalAnnotationUnionType.enType)
      {
      case fi_tcl_e8_GlobalAnnotationCategory::FI_EN_T_RESERVED:
         poGlobalAnnotationUnionData = OSAL_NEW fi_tcl_Reserved((const fi_tcl_Reserved&)*coRef.poGlobalAnnotationUnionData);
         break;
      case fi_tcl_e8_GlobalAnnotationCategory::FI_EN_T_TRAFFICSENSELIST:
         poGlobalAnnotationUnionData = OSAL_NEW fi_tcl_TrafficSenseList((const fi_tcl_TrafficSenseList&)*coRef.poGlobalAnnotationUnionData);
         break;
      case fi_tcl_e8_GlobalAnnotationCategory::FI_EN_T_SPEEDFACTORSLIST:
         poGlobalAnnotationUnionData = OSAL_NEW fi_tcl_SpeedFactorsList((const fi_tcl_SpeedFactorsList&)*coRef.poGlobalAnnotationUnionData);
         break;
      case fi_tcl_e8_GlobalAnnotationCategory::FI_EN_T_SPEEDLIMITSLIST:
         poGlobalAnnotationUnionData = OSAL_NEW fi_tcl_SpeedLimitsList((const fi_tcl_SpeedLimitsList&)*coRef.poGlobalAnnotationUnionData);
         break;
      case fi_tcl_e8_GlobalAnnotationCategory::FI_EN_T_REQUIREDPERMISSIONLIST:
         poGlobalAnnotationUnionData = OSAL_NEW fi_tcl_RequiredPermissionList((const fi_tcl_RequiredPermissionList&)*coRef.poGlobalAnnotationUnionData);
         break;
      case fi_tcl_e8_GlobalAnnotationCategory::FI_EN_T_PREFIXSTATELIST:
         poGlobalAnnotationUnionData = OSAL_NEW fi_tcl_PrefixStateList((const fi_tcl_PrefixStateList&)*coRef.poGlobalAnnotationUnionData);
         break;
      case fi_tcl_e8_GlobalAnnotationCategory::FI_EN_T_LANGUAGEDESCLIST:
         poGlobalAnnotationUnionData = OSAL_NEW fi_tcl_LanguageDescList((const fi_tcl_LanguageDescList&)*coRef.poGlobalAnnotationUnionData);
         break;
      default:
         poGlobalAnnotationUnionData = OSAL_NULL;
      }
   }
   else
   {
      poGlobalAnnotationUnionData = OSAL_NULL;
   }
   return *this;
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
fi_tcl_GlobalAnnotationTablesUnion::~fi_tcl_GlobalAnnotationTablesUnion()
{
   OSAL_DELETE poGlobalAnnotationUnionData;
   poGlobalAnnotationUnionData = OSAL_NULL;
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
tVoid fi_tcl_GlobalAnnotationTablesUnion::vDestroy()
{
   if (poGlobalAnnotationUnionData)
   {
      poGlobalAnnotationUnionData->vDestroy();
      OSAL_DELETE poGlobalAnnotationUnionData;
      poGlobalAnnotationUnionData = OSAL_NULL;
   }
}

tU32 fi_tcl_GlobalAnnotationTablesUnion::u32GetSize(tU16 u16MajorVersion) const
{
   return 1+(poGlobalAnnotationUnionData?poGlobalAnnotationUnionData->u32GetSize(u16MajorVersion):0);
}

tBool fi_tcl_GlobalAnnotationTablesUnion::operator==(const fi_tcl_GlobalAnnotationTablesUnion& rfoCmp) const
{
   tBool bResult = true;
   bResult = bResult && (GlobalAnnotationUnionType == rfoCmp.GlobalAnnotationUnionType);
   if (bResult && poGlobalAnnotationUnionData && rfoCmp.poGlobalAnnotationUnionData) 
   {
      switch (GlobalAnnotationUnionType.enType)
      {
      case fi_tcl_e8_GlobalAnnotationCategory::FI_EN_T_RESERVED:
         bResult = bResult && (*(const fi_tcl_Reserved*)poGlobalAnnotationUnionData == *(const fi_tcl_Reserved*)rfoCmp.poGlobalAnnotationUnionData); //lint !e826
      break;
      case fi_tcl_e8_GlobalAnnotationCategory::FI_EN_T_TRAFFICSENSELIST:
         bResult = bResult && (*(const fi_tcl_TrafficSenseList*)poGlobalAnnotationUnionData == *(const fi_tcl_TrafficSenseList*)rfoCmp.poGlobalAnnotationUnionData); //lint !e826
      break;
      case fi_tcl_e8_GlobalAnnotationCategory::FI_EN_T_SPEEDFACTORSLIST:
         bResult = bResult && (*(const fi_tcl_SpeedFactorsList*)poGlobalAnnotationUnionData == *(const fi_tcl_SpeedFactorsList*)rfoCmp.poGlobalAnnotationUnionData); //lint !e826
      break;
      case fi_tcl_e8_GlobalAnnotationCategory::FI_EN_T_SPEEDLIMITSLIST:
         bResult = bResult && (*(const fi_tcl_SpeedLimitsList*)poGlobalAnnotationUnionData == *(const fi_tcl_SpeedLimitsList*)rfoCmp.poGlobalAnnotationUnionData); //lint !e826
      break;
      case fi_tcl_e8_GlobalAnnotationCategory::FI_EN_T_REQUIREDPERMISSIONLIST:
         bResult = bResult && (*(const fi_tcl_RequiredPermissionList*)poGlobalAnnotationUnionData == *(const fi_tcl_RequiredPermissionList*)rfoCmp.poGlobalAnnotationUnionData); //lint !e826
      break;
      case fi_tcl_e8_GlobalAnnotationCategory::FI_EN_T_PREFIXSTATELIST:
         bResult = bResult && (*(const fi_tcl_PrefixStateList*)poGlobalAnnotationUnionData == *(const fi_tcl_PrefixStateList*)rfoCmp.poGlobalAnnotationUnionData); //lint !e826
      break;
      case fi_tcl_e8_GlobalAnnotationCategory::FI_EN_T_LANGUAGEDESCLIST:
         bResult = bResult && (*(const fi_tcl_LanguageDescList*)poGlobalAnnotationUnionData == *(const fi_tcl_LanguageDescList*)rfoCmp.poGlobalAnnotationUnionData); //lint !e826
      break;
      }
   }
   else
   {
      bResult = bResult && (poGlobalAnnotationUnionData == rfoCmp.poGlobalAnnotationUnionData);
   }
   return bResult;
}

fi_tclInContext& fi_tcl_GlobalAnnotationTablesUnion::oRead(fi_tclInContext& oIn)
{
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   OSAL_DELETE poGlobalAnnotationUnionData;
#else
   if (poGlobalAnnotationUnionData)
   {
      poGlobalAnnotationUnionData->vDestroy();
      OSAL_DELETE poGlobalAnnotationUnionData;
   }
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
   oIn >> GlobalAnnotationUnionType;
   switch(GlobalAnnotationUnionType.enType)
   {
   case fi_tcl_e8_GlobalAnnotationCategory::FI_EN_T_RESERVED:
      poGlobalAnnotationUnionData = OSAL_NEW fi_tcl_Reserved;
      break;
   case fi_tcl_e8_GlobalAnnotationCategory::FI_EN_T_TRAFFICSENSELIST:
      poGlobalAnnotationUnionData = OSAL_NEW fi_tcl_TrafficSenseList;
      break;
   case fi_tcl_e8_GlobalAnnotationCategory::FI_EN_T_SPEEDFACTORSLIST:
      poGlobalAnnotationUnionData = OSAL_NEW fi_tcl_SpeedFactorsList;
      break;
   case fi_tcl_e8_GlobalAnnotationCategory::FI_EN_T_SPEEDLIMITSLIST:
      poGlobalAnnotationUnionData = OSAL_NEW fi_tcl_SpeedLimitsList;
      break;
   case fi_tcl_e8_GlobalAnnotationCategory::FI_EN_T_REQUIREDPERMISSIONLIST:
      poGlobalAnnotationUnionData = OSAL_NEW fi_tcl_RequiredPermissionList;
      break;
   case fi_tcl_e8_GlobalAnnotationCategory::FI_EN_T_PREFIXSTATELIST:
      poGlobalAnnotationUnionData = OSAL_NEW fi_tcl_PrefixStateList;
      break;
   case fi_tcl_e8_GlobalAnnotationCategory::FI_EN_T_LANGUAGEDESCLIST:
      poGlobalAnnotationUnionData = OSAL_NEW fi_tcl_LanguageDescList;
      break;
   default:
      oIn.Invalidate();
      poGlobalAnnotationUnionData = OSAL_NULL;
   }
   if (poGlobalAnnotationUnionData && oIn.bIsValid())
      poGlobalAnnotationUnionData->oRead(oIn);
   else
      oIn.Invalidate();
   return oIn;
}

fi_tclOutContext& fi_tcl_GlobalAnnotationTablesUnion::oWrite(fi_tclOutContext& oOut) const
{
   oOut << GlobalAnnotationUnionType;
   if (poGlobalAnnotationUnionData)
   {
      poGlobalAnnotationUnionData->oWrite(oOut);
   }
   else
   {
      oOut.Invalidate();
   }
   return oOut;
}

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
fi_tcl_TimeZoneName::fi_tcl_TimeZoneName(const fi_tcl_TimeZoneName& coRef):fi_tclVisitableTypeBase(coRef)
{
   NormalName = coRef.NormalName;
   DSTName = coRef.DSTName;
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
fi_tcl_TimeZoneName& fi_tcl_TimeZoneName::operator=(const fi_tcl_TimeZoneName& coRef)
{
   if (this == &coRef) return *this;
   NormalName = coRef.NormalName;
   DSTName = coRef.DSTName;
   return *this;
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
tVoid fi_tcl_TimeZoneName::vDestroy()
{
   NormalName.vDestroy();
   DSTName.vDestroy();
}

tU32 fi_tcl_TimeZoneName::u32GetSize(tU16 u16MajorVersion) const
{
   return 0+NormalName.u32GetSize(u16MajorVersion)+DSTName.u32GetSize(u16MajorVersion);
}

tBool fi_tcl_TimeZoneName::operator==(const fi_tcl_TimeZoneName& rfoCmp) const
{
   tBool bResult = true;
      bResult = bResult && (NormalName == rfoCmp.NormalName);
      bResult = bResult && (DSTName == rfoCmp.DSTName);
   return bResult;
}

fi_tclInContext& fi_tcl_TimeZoneName::oRead(fi_tclInContext& oIn)
{
   oIn >> NormalName;
   oIn >> DSTName;
   return oIn;
}

fi_tclOutContext& fi_tcl_TimeZoneName::oWrite(fi_tclOutContext& oOut) const
{
   oOut << NormalName;
   oOut << DSTName;
   return oOut;
}

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
fi_tcl_UPOI_Category::fi_tcl_UPOI_Category(const fi_tcl_UPOI_Category& coRef):fi_tclVisitableTypeBase(coRef)
{
   Value = coRef.Value;
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
fi_tcl_UPOI_Category& fi_tcl_UPOI_Category::operator=(const fi_tcl_UPOI_Category& coRef)
{
   if (this == &coRef) return *this;
   Value = coRef.Value;
   return *this;
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
tU32 fi_tcl_UPOI_Category::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 4;
}

tBool fi_tcl_UPOI_Category::operator==(const fi_tcl_UPOI_Category& rfoCmp) const
{
   tBool bResult = true;
      bResult = bResult && (Value == rfoCmp.Value);
   return bResult;
}

fi_tclInContext& fi_tcl_UPOI_Category::oRead(fi_tclInContext& oIn)
{
   oIn >> Value;
   return oIn;
}

fi_tclOutContext& fi_tcl_UPOI_Category::oWrite(fi_tclOutContext& oOut) const
{
   oOut << Value;
   return oOut;
}

tU32 fi_tcl_e8_UPOI_Source::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 1;
}

tBool fi_tcl_e8_UPOI_Source::operator==(const fi_tcl_e8_UPOI_Source& rfoCmp) const
{
   return enType == rfoCmp.enType;
}

fi_tclInContext& fi_tcl_e8_UPOI_Source::oRead(fi_tclInContext& oIn)
{
   tU8 u8Value;
   oIn >> u8Value;
   enType = (tenType)u8Value;
   return oIn;
}

fi_tclOutContext& fi_tcl_e8_UPOI_Source::oWrite(fi_tclOutContext& oOut) const
{
   return oOut.oWrite((tU8)enType);
}

tU32 fi_tcl_b16_UPOI_Source::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 2;
}

tBool fi_tcl_b16_UPOI_Source::operator==(const fi_tcl_b16_UPOI_Source& rfoCmp) const
{
   return u16Value == rfoCmp.u16Value;
}

fi_tclInContext& fi_tcl_b16_UPOI_Source::oRead(fi_tclInContext& oIn)
{
   return oIn >> u16Value;
}

fi_tclOutContext& fi_tcl_b16_UPOI_Source::oWrite(fi_tclOutContext& oOut) const
{
   return oOut << u16Value;
}

tU32 fi_tcl_b8_UPOI_FilterSetStatus::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 1;
}

tBool fi_tcl_b8_UPOI_FilterSetStatus::operator==(const fi_tcl_b8_UPOI_FilterSetStatus& rfoCmp) const
{
   return u8Value == rfoCmp.u8Value;
}

fi_tclInContext& fi_tcl_b8_UPOI_FilterSetStatus::oRead(fi_tclInContext& oIn)
{
   return oIn >> u8Value;
}

fi_tclOutContext& fi_tcl_b8_UPOI_FilterSetStatus::oWrite(fi_tclOutContext& oOut) const
{
   return oOut << u8Value;
}

tU32 fi_tcl_e8_UPOI_AnnouncementDistance::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 1;
}

tBool fi_tcl_e8_UPOI_AnnouncementDistance::operator==(const fi_tcl_e8_UPOI_AnnouncementDistance& rfoCmp) const
{
   return enType == rfoCmp.enType;
}

fi_tclInContext& fi_tcl_e8_UPOI_AnnouncementDistance::oRead(fi_tclInContext& oIn)
{
   tU8 u8Value;
   oIn >> u8Value;
   enType = (tenType)u8Value;
   return oIn;
}

fi_tclOutContext& fi_tcl_e8_UPOI_AnnouncementDistance::oWrite(fi_tclOutContext& oOut) const
{
   return oOut.oWrite((tU8)enType);
}

tU32 fi_tcl_b8_UPOI_AnnouncementStatus::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 1;
}

tBool fi_tcl_b8_UPOI_AnnouncementStatus::operator==(const fi_tcl_b8_UPOI_AnnouncementStatus& rfoCmp) const
{
   return u8Value == rfoCmp.u8Value;
}

fi_tclInContext& fi_tcl_b8_UPOI_AnnouncementStatus::oRead(fi_tclInContext& oIn)
{
   return oIn >> u8Value;
}

fi_tclOutContext& fi_tcl_b8_UPOI_AnnouncementStatus::oWrite(fi_tclOutContext& oOut) const
{
   return oOut << u8Value;
}

tU32 fi_tcl_b8_UPOI_Validity::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 1;
}

tBool fi_tcl_b8_UPOI_Validity::operator==(const fi_tcl_b8_UPOI_Validity& rfoCmp) const
{
   return u8Value == rfoCmp.u8Value;
}

fi_tclInContext& fi_tcl_b8_UPOI_Validity::oRead(fi_tclInContext& oIn)
{
   return oIn >> u8Value;
}

fi_tclOutContext& fi_tcl_b8_UPOI_Validity::oWrite(fi_tclOutContext& oOut) const
{
   return oOut << u8Value;
}

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
fi_tcl_UPOI_Element::fi_tcl_UPOI_Element(const fi_tcl_UPOI_Element& coRef):fi_tclVisitableTypeBase(coRef)
{
   UniqueID = coRef.UniqueID;
   Category = coRef.Category;
   Source = coRef.Source;
   Name = coRef.Name;
   ShortDescription = coRef.ShortDescription;
   Position = coRef.Position;
   PerpendicularPointPosition = coRef.PerpendicularPointPosition;
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
fi_tcl_UPOI_Element& fi_tcl_UPOI_Element::operator=(const fi_tcl_UPOI_Element& coRef)
{
   if (this == &coRef) return *this;
   UniqueID = coRef.UniqueID;
   Category = coRef.Category;
   Source = coRef.Source;
   Name = coRef.Name;
   ShortDescription = coRef.ShortDescription;
   Position = coRef.Position;
   PerpendicularPointPosition = coRef.PerpendicularPointPosition;
   return *this;
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
tVoid fi_tcl_UPOI_Element::vDestroy()
{
   Category.vDestroy(); 
   Name.vDestroy();
   ShortDescription.vDestroy();
   Position.vDestroy(); 
   PerpendicularPointPosition.vDestroy(); 
}

tU32 fi_tcl_UPOI_Element::u32GetSize(tU16 u16MajorVersion) const
{
   tU32 u32DynamicSize = 0;
   if (17 <= u16MajorVersion)
   {
      u32DynamicSize += 8;
   }
   return u32DynamicSize+17+Name.u32GetSize(u16MajorVersion)+ShortDescription.u32GetSize(u16MajorVersion);
}

tBool fi_tcl_UPOI_Element::operator==(const fi_tcl_UPOI_Element& rfoCmp) const
{
   tBool bResult = true;
      bResult = bResult && (UniqueID == rfoCmp.UniqueID);
      bResult = bResult && (Category == rfoCmp.Category);
      bResult = bResult && (Source == rfoCmp.Source);
      bResult = bResult && (Name == rfoCmp.Name);
      bResult = bResult && (ShortDescription == rfoCmp.ShortDescription);
      bResult = bResult && (Position == rfoCmp.Position);
      bResult = bResult && (PerpendicularPointPosition == rfoCmp.PerpendicularPointPosition);
   return bResult;
}

fi_tclInContext& fi_tcl_UPOI_Element::oRead(fi_tclInContext& oIn)
{
   oIn >> UniqueID;
   oIn >> Category;
   oIn >> Source;
   oIn >> Name;
   oIn >> ShortDescription;
   oIn >> Position;
   if (17 <= oIn.u16GetMajorVersion())
   {
      oIn >> PerpendicularPointPosition;
   }
   return oIn;
}

fi_tclOutContext& fi_tcl_UPOI_Element::oWrite(fi_tclOutContext& oOut) const
{
   oOut << UniqueID;
   oOut << Category;
   oOut << Source;
   oOut << Name;
   oOut << ShortDescription;
   oOut << Position;
   if (17 <= oOut.u16GetMajorVersion())
   {
      oOut << PerpendicularPointPosition;
   }
   return oOut;
}

tU32 fi_tcl_b8_UPOI_FilterSet_FieldRelevance::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 1;
}

tBool fi_tcl_b8_UPOI_FilterSet_FieldRelevance::operator==(const fi_tcl_b8_UPOI_FilterSet_FieldRelevance& rfoCmp) const
{
   return u8Value == rfoCmp.u8Value;
}

fi_tclInContext& fi_tcl_b8_UPOI_FilterSet_FieldRelevance::oRead(fi_tclInContext& oIn)
{
   return oIn >> u8Value;
}

fi_tclOutContext& fi_tcl_b8_UPOI_FilterSet_FieldRelevance::oWrite(fi_tclOutContext& oOut) const
{
   return oOut << u8Value;
}

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
fi_tcl_UPOI_FilterSet::fi_tcl_UPOI_FilterSet(const fi_tcl_UPOI_FilterSet& coRef):fi_tclVisitableTypeBase(coRef)
{
   Relevance = coRef.Relevance;
   Source = coRef.Source;
   Category = coRef.Category;
   Status = coRef.Status;
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
fi_tcl_UPOI_FilterSet& fi_tcl_UPOI_FilterSet::operator=(const fi_tcl_UPOI_FilterSet& coRef)
{
   if (this == &coRef) return *this;
   Relevance = coRef.Relevance;
   Source = coRef.Source;
   Category = coRef.Category;
   Status = coRef.Status;
   return *this;
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
tVoid fi_tcl_UPOI_FilterSet::vDestroy()
{
   Category.vDestroy(); 
}

tU32 fi_tcl_UPOI_FilterSet::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 7;
}

tBool fi_tcl_UPOI_FilterSet::operator==(const fi_tcl_UPOI_FilterSet& rfoCmp) const
{
   tBool bResult = true;
      bResult = bResult && (Relevance == rfoCmp.Relevance);
      bResult = bResult && (Source == rfoCmp.Source);
      bResult = bResult && (Category == rfoCmp.Category);
      bResult = bResult && (Status == rfoCmp.Status);
   return bResult;
}

fi_tclInContext& fi_tcl_UPOI_FilterSet::oRead(fi_tclInContext& oIn)
{
   oIn >> Relevance;
   oIn >> Source;
   oIn >> Category;
   oIn >> Status;
   return oIn;
}

fi_tclOutContext& fi_tcl_UPOI_FilterSet::oWrite(fi_tclOutContext& oOut) const
{
   oOut << Relevance;
   oOut << Source;
   oOut << Category;
   oOut << Status;
   return oOut;
}

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
fi_tcl_UPOI_FilterList::fi_tcl_UPOI_FilterList(const fi_tcl_UPOI_FilterList& coRef):fi_tclVisitableTypeBase(coRef)
{
   List = coRef.List;
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
fi_tcl_UPOI_FilterList& fi_tcl_UPOI_FilterList::operator=(const fi_tcl_UPOI_FilterList& coRef)
{
   if (this == &coRef) return *this;
   List = coRef.List;
   return *this;
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
tVoid fi_tcl_UPOI_FilterList::vDestroy()
{
   {
      for (tU32 u32Idx = 0; u32Idx < List.size(); ++u32Idx)
         List[u32Idx].vDestroy();
   }
   List.clear();
}

tU32 fi_tcl_UPOI_FilterList::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 4+List.size()*7;
}

tBool fi_tcl_UPOI_FilterList::operator==(const fi_tcl_UPOI_FilterList& rfoCmp) const
{
   tBool bResult = true;
      bResult = bResult && (List.size() == rfoCmp.List.size());
      if (bResult)
      {
         for (tU32 u32Idx = 0; bResult && (u32Idx < List.size()); ++u32Idx)
            bResult = bResult && (List[u32Idx] == rfoCmp.List[u32Idx]);
      }
   return bResult;
}

fi_tclInContext& fi_tcl_UPOI_FilterList::oRead(fi_tclInContext& oIn)
{
   {
      tU32 u32Length;
      tU32 u32Idx;
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
      for (u32Idx = 0; u32Idx < List.size(); ++u32Idx)
      {
         List[u32Idx].vDestroy();
      }
#endif // !VARIANT_S_FTR_ENABLE_DEEP_COPY
      oIn >> u32Length;
      List.resize(u32Length);
      for (u32Idx = 0; u32Idx < u32Length; ++u32Idx)
      {
         oIn >> List[u32Idx];
      }
   }
   return oIn;
}

fi_tclOutContext& fi_tcl_UPOI_FilterList::oWrite(fi_tclOutContext& oOut) const
{
   oOut << (tU32)List.size();
   {
      for (tU32 u32Idx = 0; u32Idx < List.size(); ++u32Idx)
         oOut << List[u32Idx];
   }
   return oOut;
}

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
fi_tcl_UPOI_CategoryConfiguration::fi_tcl_UPOI_CategoryConfiguration(const fi_tcl_UPOI_CategoryConfiguration& coRef):fi_tclVisitableTypeBase(coRef)
{
   FilterSet = coRef.FilterSet;
   AnnouncementDistance = coRef.AnnouncementDistance;
   AnnouncementStatus = coRef.AnnouncementStatus;
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
fi_tcl_UPOI_CategoryConfiguration& fi_tcl_UPOI_CategoryConfiguration::operator=(const fi_tcl_UPOI_CategoryConfiguration& coRef)
{
   if (this == &coRef) return *this;
   FilterSet = coRef.FilterSet;
   AnnouncementDistance = coRef.AnnouncementDistance;
   AnnouncementStatus = coRef.AnnouncementStatus;
   return *this;
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
tVoid fi_tcl_UPOI_CategoryConfiguration::vDestroy()
{
   FilterSet.vDestroy(); 
}

tU32 fi_tcl_UPOI_CategoryConfiguration::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 9;
}

tBool fi_tcl_UPOI_CategoryConfiguration::operator==(const fi_tcl_UPOI_CategoryConfiguration& rfoCmp) const
{
   tBool bResult = true;
      bResult = bResult && (FilterSet == rfoCmp.FilterSet);
      bResult = bResult && (AnnouncementDistance == rfoCmp.AnnouncementDistance);
      bResult = bResult && (AnnouncementStatus == rfoCmp.AnnouncementStatus);
   return bResult;
}

fi_tclInContext& fi_tcl_UPOI_CategoryConfiguration::oRead(fi_tclInContext& oIn)
{
   oIn >> FilterSet;
   oIn >> AnnouncementDistance;
   oIn >> AnnouncementStatus;
   return oIn;
}

fi_tclOutContext& fi_tcl_UPOI_CategoryConfiguration::oWrite(fi_tclOutContext& oOut) const
{
   oOut << FilterSet;
   oOut << AnnouncementDistance;
   oOut << AnnouncementStatus;
   return oOut;
}

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
fi_tcl_UPOI_CategoryConfigurationList::fi_tcl_UPOI_CategoryConfigurationList(const fi_tcl_UPOI_CategoryConfigurationList& coRef):fi_tclVisitableTypeBase(coRef)
{
   List = coRef.List;
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
fi_tcl_UPOI_CategoryConfigurationList& fi_tcl_UPOI_CategoryConfigurationList::operator=(const fi_tcl_UPOI_CategoryConfigurationList& coRef)
{
   if (this == &coRef) return *this;
   List = coRef.List;
   return *this;
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
tVoid fi_tcl_UPOI_CategoryConfigurationList::vDestroy()
{
   {
      for (tU32 u32Idx = 0; u32Idx < List.size(); ++u32Idx)
         List[u32Idx].vDestroy();
   }
   List.clear();
}

tU32 fi_tcl_UPOI_CategoryConfigurationList::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 4+List.size()*9;
}

tBool fi_tcl_UPOI_CategoryConfigurationList::operator==(const fi_tcl_UPOI_CategoryConfigurationList& rfoCmp) const
{
   tBool bResult = true;
      bResult = bResult && (List.size() == rfoCmp.List.size());
      if (bResult)
      {
         for (tU32 u32Idx = 0; bResult && (u32Idx < List.size()); ++u32Idx)
            bResult = bResult && (List[u32Idx] == rfoCmp.List[u32Idx]);
      }
   return bResult;
}

fi_tclInContext& fi_tcl_UPOI_CategoryConfigurationList::oRead(fi_tclInContext& oIn)
{
   {
      tU32 u32Length;
      tU32 u32Idx;
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
      for (u32Idx = 0; u32Idx < List.size(); ++u32Idx)
      {
         List[u32Idx].vDestroy();
      }
#endif // !VARIANT_S_FTR_ENABLE_DEEP_COPY
      oIn >> u32Length;
      List.resize(u32Length);
      for (u32Idx = 0; u32Idx < u32Length; ++u32Idx)
      {
         oIn >> List[u32Idx];
      }
   }
   return oIn;
}

fi_tclOutContext& fi_tcl_UPOI_CategoryConfigurationList::oWrite(fi_tclOutContext& oOut) const
{
   oOut << (tU32)List.size();
   {
      for (tU32 u32Idx = 0; u32Idx < List.size(); ++u32Idx)
         oOut << List[u32Idx];
   }
   return oOut;
}

tU32 fi_tcl_b8_UPOI_Status::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 1;
}

tBool fi_tcl_b8_UPOI_Status::operator==(const fi_tcl_b8_UPOI_Status& rfoCmp) const
{
   return u8Value == rfoCmp.u8Value;
}

fi_tclInContext& fi_tcl_b8_UPOI_Status::oRead(fi_tclInContext& oIn)
{
   return oIn >> u8Value;
}

fi_tclOutContext& fi_tcl_b8_UPOI_Status::oWrite(fi_tclOutContext& oOut) const
{
   return oOut << u8Value;
}

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
fi_tcl_UPOI_Combination::fi_tcl_UPOI_Combination(const fi_tcl_UPOI_Combination& coRef):fi_tclVisitableTypeBase(coRef)
{
   BaseList = coRef.BaseList;
   RefList = coRef.RefList;
   ID = coRef.ID;
   DataValidity = coRef.DataValidity;
   OnRoadOffset = coRef.OnRoadOffset;
   PerpendicularPointPosition = coRef.PerpendicularPointPosition;
   UPOIStatus = coRef.UPOIStatus;
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
fi_tcl_UPOI_Combination& fi_tcl_UPOI_Combination::operator=(const fi_tcl_UPOI_Combination& coRef)
{
   if (this == &coRef) return *this;
   BaseList = coRef.BaseList;
   RefList = coRef.RefList;
   ID = coRef.ID;
   DataValidity = coRef.DataValidity;
   OnRoadOffset = coRef.OnRoadOffset;
   PerpendicularPointPosition = coRef.PerpendicularPointPosition;
   UPOIStatus = coRef.UPOIStatus;
   return *this;
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
tVoid fi_tcl_UPOI_Combination::vDestroy()
{
   PerpendicularPointPosition.vDestroy(); 
}

tU32 fi_tcl_UPOI_Combination::u32GetSize(tU16 u16MajorVersion) const
{
   tU32 u32DynamicSize = 0;
   if (17 <= u16MajorVersion)
   {
      u32DynamicSize += 1;
   }
   return u32DynamicSize+19;
}

tBool fi_tcl_UPOI_Combination::operator==(const fi_tcl_UPOI_Combination& rfoCmp) const
{
   tBool bResult = true;
      bResult = bResult && (BaseList == rfoCmp.BaseList);
      bResult = bResult && (RefList == rfoCmp.RefList);
      bResult = bResult && (ID == rfoCmp.ID);
      bResult = bResult && (DataValidity == rfoCmp.DataValidity);
      bResult = bResult && (OnRoadOffset == rfoCmp.OnRoadOffset);
      bResult = bResult && (PerpendicularPointPosition == rfoCmp.PerpendicularPointPosition);
      bResult = bResult && (UPOIStatus == rfoCmp.UPOIStatus);
   return bResult;
}

fi_tclInContext& fi_tcl_UPOI_Combination::oRead(fi_tclInContext& oIn)
{
   oIn >> BaseList;
   oIn >> RefList;
   oIn >> ID;
   oIn >> DataValidity;
   oIn >> OnRoadOffset;
   oIn >> PerpendicularPointPosition;
   if (17 <= oIn.u16GetMajorVersion())
   {
      oIn >> UPOIStatus;
   }
   return oIn;
}

fi_tclOutContext& fi_tcl_UPOI_Combination::oWrite(fi_tclOutContext& oOut) const
{
   oOut << BaseList;
   oOut << RefList;
   oOut << ID;
   oOut << DataValidity;
   oOut << OnRoadOffset;
   oOut << PerpendicularPointPosition;
   if (17 <= oOut.u16GetMajorVersion())
   {
      oOut << UPOIStatus;
   }
   return oOut;
}

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
fi_tcl_UPOI_ListSet::fi_tcl_UPOI_ListSet(const fi_tcl_UPOI_ListSet& coRef):fi_tclVisitableTypeBase(coRef)
{
   CombinationList = coRef.CombinationList;
   UPOI_RefList = coRef.UPOI_RefList;
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
fi_tcl_UPOI_ListSet& fi_tcl_UPOI_ListSet::operator=(const fi_tcl_UPOI_ListSet& coRef)
{
   if (this == &coRef) return *this;
   CombinationList = coRef.CombinationList;
   UPOI_RefList = coRef.UPOI_RefList;
   return *this;
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
tVoid fi_tcl_UPOI_ListSet::vDestroy()
{
   {
      for (tU32 u32Idx = 0; u32Idx < CombinationList.size(); ++u32Idx)
         CombinationList[u32Idx].vDestroy();
   }
   CombinationList.clear();
   {
      for (tU32 u32Idx = 0; u32Idx < UPOI_RefList.size(); ++u32Idx)
         UPOI_RefList[u32Idx].vDestroy();
   }
   UPOI_RefList.clear();
}

tU32 fi_tcl_UPOI_ListSet::u32GetSize(tU16 u16MajorVersion) const
{
   tU32 u32DynamicSize = 0;
   tU32 u32ListIdx;
   for (u32ListIdx = 0; u32ListIdx < CombinationList.size(); ++u32ListIdx)
      u32DynamicSize += CombinationList[u32ListIdx].u32GetSize(u16MajorVersion);
   for (u32ListIdx = 0; u32ListIdx < UPOI_RefList.size(); ++u32ListIdx)
      u32DynamicSize += UPOI_RefList[u32ListIdx].u32GetSize(u16MajorVersion);
   return u32DynamicSize+8;
}

tBool fi_tcl_UPOI_ListSet::operator==(const fi_tcl_UPOI_ListSet& rfoCmp) const
{
   tBool bResult = true;
      bResult = bResult && (CombinationList.size() == rfoCmp.CombinationList.size());
      if (bResult)
      {
         for (tU32 u32Idx = 0; bResult && (u32Idx < CombinationList.size()); ++u32Idx)
            bResult = bResult && (CombinationList[u32Idx] == rfoCmp.CombinationList[u32Idx]);
      }
      bResult = bResult && (UPOI_RefList.size() == rfoCmp.UPOI_RefList.size());
      if (bResult)
      {
         for (tU32 u32Idx = 0; bResult && (u32Idx < UPOI_RefList.size()); ++u32Idx)
            bResult = bResult && (UPOI_RefList[u32Idx] == rfoCmp.UPOI_RefList[u32Idx]);
      }
   return bResult;
}

fi_tclInContext& fi_tcl_UPOI_ListSet::oRead(fi_tclInContext& oIn)
{
   {
      tU32 u32Length;
      tU32 u32Idx;
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
      for (u32Idx = 0; u32Idx < CombinationList.size(); ++u32Idx)
      {
         CombinationList[u32Idx].vDestroy();
      }
#endif // !VARIANT_S_FTR_ENABLE_DEEP_COPY
      oIn >> u32Length;
      CombinationList.resize(u32Length);
      for (u32Idx = 0; u32Idx < u32Length; ++u32Idx)
      {
         oIn >> CombinationList[u32Idx];
      }
   }
   {
      tU32 u32Length;
      tU32 u32Idx;
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
      for (u32Idx = 0; u32Idx < UPOI_RefList.size(); ++u32Idx)
      {
         UPOI_RefList[u32Idx].vDestroy();
      }
#endif // !VARIANT_S_FTR_ENABLE_DEEP_COPY
      oIn >> u32Length;
      UPOI_RefList.resize(u32Length);
      for (u32Idx = 0; u32Idx < u32Length; ++u32Idx)
      {
         oIn >> UPOI_RefList[u32Idx];
      }
   }
   return oIn;
}

fi_tclOutContext& fi_tcl_UPOI_ListSet::oWrite(fi_tclOutContext& oOut) const
{
   oOut << (tU32)CombinationList.size();
   {
      for (tU32 u32Idx = 0; u32Idx < CombinationList.size(); ++u32Idx)
         oOut << CombinationList[u32Idx];
   }
   oOut << (tU32)UPOI_RefList.size();
   {
      for (tU32 u32Idx = 0; u32Idx < UPOI_RefList.size(); ++u32Idx)
         oOut << UPOI_RefList[u32Idx];
   }
   return oOut;
}

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
fi_tcl_ClockTime::fi_tcl_ClockTime(const fi_tcl_ClockTime& coRef):fi_tclVisitableTypeBase(coRef)
{
   Hour = coRef.Hour;
   Minute = coRef.Minute;
   Second = coRef.Second;
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
fi_tcl_ClockTime& fi_tcl_ClockTime::operator=(const fi_tcl_ClockTime& coRef)
{
   if (this == &coRef) return *this;
   Hour = coRef.Hour;
   Minute = coRef.Minute;
   Second = coRef.Second;
   return *this;
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
tU32 fi_tcl_ClockTime::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 3;
}

tBool fi_tcl_ClockTime::operator==(const fi_tcl_ClockTime& rfoCmp) const
{
   tBool bResult = true;
      bResult = bResult && (Hour == rfoCmp.Hour);
      bResult = bResult && (Minute == rfoCmp.Minute);
      bResult = bResult && (Second == rfoCmp.Second);
   return bResult;
}

fi_tclInContext& fi_tcl_ClockTime::oRead(fi_tclInContext& oIn)
{
   oIn >> Hour;
   oIn >> Minute;
   oIn >> Second;
   return oIn;
}

fi_tclOutContext& fi_tcl_ClockTime::oWrite(fi_tclOutContext& oOut) const
{
   oOut << Hour;
   oOut << Minute;
   oOut << Second;
   return oOut;
}

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
fi_tcl_Date::fi_tcl_Date(const fi_tcl_Date& coRef):fi_tclVisitableTypeBase(coRef)
{
   Year = coRef.Year;
   Month = coRef.Month;
   Day = coRef.Day;
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
fi_tcl_Date& fi_tcl_Date::operator=(const fi_tcl_Date& coRef)
{
   if (this == &coRef) return *this;
   Year = coRef.Year;
   Month = coRef.Month;
   Day = coRef.Day;
   return *this;
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
tU32 fi_tcl_Date::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 4;
}

tBool fi_tcl_Date::operator==(const fi_tcl_Date& rfoCmp) const
{
   tBool bResult = true;
      bResult = bResult && (Year == rfoCmp.Year);
      bResult = bResult && (Month == rfoCmp.Month);
      bResult = bResult && (Day == rfoCmp.Day);
   return bResult;
}

fi_tclInContext& fi_tcl_Date::oRead(fi_tclInContext& oIn)
{
   oIn >> Year;
   oIn >> Month;
   oIn >> Day;
   return oIn;
}

fi_tclOutContext& fi_tcl_Date::oWrite(fi_tclOutContext& oOut) const
{
   oOut << Year;
   oOut << Month;
   oOut << Day;
   return oOut;
}

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
fi_tcl_VersionInfo::fi_tcl_VersionInfo(const fi_tcl_VersionInfo& coRef):fi_tclVisitableTypeBase(coRef)
{
   Manufacturer = coRef.Manufacturer;
   ProductionDate = coRef.ProductionDate;
   ProductVersion = coRef.ProductVersion;
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
fi_tcl_VersionInfo& fi_tcl_VersionInfo::operator=(const fi_tcl_VersionInfo& coRef)
{
   if (this == &coRef) return *this;
   Manufacturer = coRef.Manufacturer;
   ProductionDate = coRef.ProductionDate;
   ProductVersion = coRef.ProductVersion;
   return *this;
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
tVoid fi_tcl_VersionInfo::vDestroy()
{
   Manufacturer.vDestroy();
   ProductionDate.vDestroy();
   ProductVersion.vDestroy();
}

tU32 fi_tcl_VersionInfo::u32GetSize(tU16 u16MajorVersion) const
{
   return 0+Manufacturer.u32GetSize(u16MajorVersion)+ProductionDate.u32GetSize(u16MajorVersion)+ProductVersion.u32GetSize(u16MajorVersion);
}

tBool fi_tcl_VersionInfo::operator==(const fi_tcl_VersionInfo& rfoCmp) const
{
   tBool bResult = true;
      bResult = bResult && (Manufacturer == rfoCmp.Manufacturer);
      bResult = bResult && (ProductionDate == rfoCmp.ProductionDate);
      bResult = bResult && (ProductVersion == rfoCmp.ProductVersion);
   return bResult;
}

fi_tclInContext& fi_tcl_VersionInfo::oRead(fi_tclInContext& oIn)
{
   oIn >> Manufacturer;
   oIn >> ProductionDate;
   oIn >> ProductVersion;
   return oIn;
}

fi_tclOutContext& fi_tcl_VersionInfo::oWrite(fi_tclOutContext& oOut) const
{
   oOut << Manufacturer;
   oOut << ProductionDate;
   oOut << ProductVersion;
   return oOut;
}

tU32 fi_tcl_e8_GPSFix::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 1;
}

tBool fi_tcl_e8_GPSFix::operator==(const fi_tcl_e8_GPSFix& rfoCmp) const
{
   return enType == rfoCmp.enType;
}

fi_tclInContext& fi_tcl_e8_GPSFix::oRead(fi_tclInContext& oIn)
{
   tU8 u8Value;
   oIn >> u8Value;
   enType = (tenType)u8Value;
   return oIn;
}

fi_tclOutContext& fi_tcl_e8_GPSFix::oWrite(fi_tclOutContext& oOut) const
{
   return oOut.oWrite((tU8)enType);
}

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
fi_tcl_GPSAdditionalInformation::fi_tcl_GPSAdditionalInformation(const fi_tcl_GPSAdditionalInformation& coRef):fi_tclVisitableTypeBase(coRef)
{
   Fix = coRef.Fix;
   HDOP = coRef.HDOP;
   VDOP = coRef.VDOP;
   Heading = coRef.Heading;
   Speed = coRef.Speed;
   Height = coRef.Height;
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
fi_tcl_GPSAdditionalInformation& fi_tcl_GPSAdditionalInformation::operator=(const fi_tcl_GPSAdditionalInformation& coRef)
{
   if (this == &coRef) return *this;
   Fix = coRef.Fix;
   HDOP = coRef.HDOP;
   VDOP = coRef.VDOP;
   Heading = coRef.Heading;
   Speed = coRef.Speed;
   Height = coRef.Height;
   return *this;
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
tU32 fi_tcl_GPSAdditionalInformation::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 10;
}

tBool fi_tcl_GPSAdditionalInformation::operator==(const fi_tcl_GPSAdditionalInformation& rfoCmp) const
{
   tBool bResult = true;
      bResult = bResult && (Fix == rfoCmp.Fix);
      bResult = bResult && (HDOP == rfoCmp.HDOP);
      bResult = bResult && (VDOP == rfoCmp.VDOP);
      bResult = bResult && (Heading == rfoCmp.Heading);
      bResult = bResult && (Speed == rfoCmp.Speed);
      bResult = bResult && (Height == rfoCmp.Height);
   return bResult;
}

fi_tclInContext& fi_tcl_GPSAdditionalInformation::oRead(fi_tclInContext& oIn)
{
   oIn >> Fix;
   oIn >> HDOP;
   oIn >> VDOP;
   oIn >> Heading;
   oIn >> Speed;
   oIn >> Height;
   return oIn;
}

fi_tclOutContext& fi_tcl_GPSAdditionalInformation::oWrite(fi_tclOutContext& oOut) const
{
   oOut << Fix;
   oOut << HDOP;
   oOut << VDOP;
   oOut << Heading;
   oOut << Speed;
   oOut << Height;
   return oOut;
}

tU32 fi_tcl_e8_GPSChannelStatus::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 1;
}

tBool fi_tcl_e8_GPSChannelStatus::operator==(const fi_tcl_e8_GPSChannelStatus& rfoCmp) const
{
   return enType == rfoCmp.enType;
}

fi_tclInContext& fi_tcl_e8_GPSChannelStatus::oRead(fi_tclInContext& oIn)
{
   tU8 u8Value;
   oIn >> u8Value;
   enType = (tenType)u8Value;
   return oIn;
}

fi_tclOutContext& fi_tcl_e8_GPSChannelStatus::oWrite(fi_tclOutContext& oOut) const
{
   return oOut.oWrite((tU8)enType);
}

tU32 fi_tcl_s8_ElevationRelative::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 1;
}

tBool fi_tcl_s8_ElevationRelative::operator==(const fi_tcl_s8_ElevationRelative& rfoCmp) const
{
   return s8Value == rfoCmp.s8Value;
}

fi_tclInContext& fi_tcl_s8_ElevationRelative::oRead(fi_tclInContext& oIn)
{
   return oIn >> s8Value;
}

fi_tclOutContext& fi_tcl_s8_ElevationRelative::oWrite(fi_tclOutContext& oOut) const
{
   return oOut << s8Value;
}

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
fi_tcl_GPSChannelInformation::fi_tcl_GPSChannelInformation(const fi_tcl_GPSChannelInformation& coRef):fi_tclVisitableTypeBase(coRef)
{
   SatelliteId = coRef.SatelliteId;
   ChannelStatus = coRef.ChannelStatus;
   Azimuth = coRef.Azimuth;
   Elevation = coRef.Elevation;
   CarrierToNoiseRatio = coRef.CarrierToNoiseRatio;
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
fi_tcl_GPSChannelInformation& fi_tcl_GPSChannelInformation::operator=(const fi_tcl_GPSChannelInformation& coRef)
{
   if (this == &coRef) return *this;
   SatelliteId = coRef.SatelliteId;
   ChannelStatus = coRef.ChannelStatus;
   Azimuth = coRef.Azimuth;
   Elevation = coRef.Elevation;
   CarrierToNoiseRatio = coRef.CarrierToNoiseRatio;
   return *this;
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
tU32 fi_tcl_GPSChannelInformation::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 5;
}

tBool fi_tcl_GPSChannelInformation::operator==(const fi_tcl_GPSChannelInformation& rfoCmp) const
{
   tBool bResult = true;
      bResult = bResult && (SatelliteId == rfoCmp.SatelliteId);
      bResult = bResult && (ChannelStatus == rfoCmp.ChannelStatus);
      bResult = bResult && (Azimuth == rfoCmp.Azimuth);
      bResult = bResult && (Elevation == rfoCmp.Elevation);
      bResult = bResult && (CarrierToNoiseRatio == rfoCmp.CarrierToNoiseRatio);
   return bResult;
}

fi_tclInContext& fi_tcl_GPSChannelInformation::oRead(fi_tclInContext& oIn)
{
   oIn >> SatelliteId;
   oIn >> ChannelStatus;
   oIn >> Azimuth;
   oIn >> Elevation;
   oIn >> CarrierToNoiseRatio;
   return oIn;
}

fi_tclOutContext& fi_tcl_GPSChannelInformation::oWrite(fi_tclOutContext& oOut) const
{
   oOut << SatelliteId;
   oOut << ChannelStatus;
   oOut << Azimuth;
   oOut << Elevation;
   oOut << CarrierToNoiseRatio;
   return oOut;
}

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
fi_tcl_TMMapRef::fi_tcl_TMMapRef(const fi_tcl_TMMapRef& coRef):fi_tclVisitableTypeBase(coRef)
{
   ElementCount = coRef.ElementCount;
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
fi_tcl_TMMapRef& fi_tcl_TMMapRef::operator=(const fi_tcl_TMMapRef& coRef)
{
   if (this == &coRef) return *this;
   ElementCount = coRef.ElementCount;
   return *this;
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
tVoid fi_tcl_TMMapRef::vDestroy()
{
   ElementCount.clear();
}

tU32 fi_tcl_TMMapRef::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 4+ElementCount.size()*1;
}

tBool fi_tcl_TMMapRef::operator==(const fi_tcl_TMMapRef& rfoCmp) const
{
   tBool bResult = true;
      bResult = bResult && (ElementCount.size() == rfoCmp.ElementCount.size());
      if (bResult)
      {
         for (tU32 u32Idx = 0; bResult && (u32Idx < ElementCount.size()); ++u32Idx)
            bResult = bResult && (ElementCount[u32Idx] == rfoCmp.ElementCount[u32Idx]);
      }
   return bResult;
}

fi_tclInContext& fi_tcl_TMMapRef::oRead(fi_tclInContext& oIn)
{
   {
      tU32 u32Length;
      tU32 u32Idx;
      oIn >> u32Length;
      ElementCount.resize(u32Length);
      for (u32Idx = 0; u32Idx < u32Length; ++u32Idx)
      {
         oIn >> ElementCount[u32Idx];
      }
   }
   return oIn;
}

fi_tclOutContext& fi_tcl_TMMapRef::oWrite(fi_tclOutContext& oOut) const
{
   oOut << (tU32)ElementCount.size();
   {
      for (tU32 u32Idx = 0; u32Idx < ElementCount.size(); ++u32Idx)
         oOut << ElementCount[u32Idx];
   }
   return oOut;
}

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
fi_tcl_UTMDesc::fi_tcl_UTMDesc(const fi_tcl_UTMDesc& coRef):fi_tclVisitableTypeBase(coRef)
{
   NaviEventValue = coRef.NaviEventValue;
   StartElement = coRef.StartElement;
   StartOffset = coRef.StartOffset;
   UTMLength = coRef.UTMLength;
   NavUTMContainer = coRef.NavUTMContainer;
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
fi_tcl_UTMDesc& fi_tcl_UTMDesc::operator=(const fi_tcl_UTMDesc& coRef)
{
   if (this == &coRef) return *this;
   NaviEventValue = coRef.NaviEventValue;
   StartElement = coRef.StartElement;
   StartOffset = coRef.StartOffset;
   UTMLength = coRef.UTMLength;
   NavUTMContainer = coRef.NavUTMContainer;
   return *this;
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
tVoid fi_tcl_UTMDesc::vDestroy()
{
   NavUTMContainer.vDestroy(); 
}

tU32 fi_tcl_UTMDesc::u32GetSize(tU16 u16MajorVersion) const
{
   return 12+NavUTMContainer.u32GetSize(u16MajorVersion);
}

tBool fi_tcl_UTMDesc::operator==(const fi_tcl_UTMDesc& rfoCmp) const
{
   tBool bResult = true;
      bResult = bResult && (NaviEventValue == rfoCmp.NaviEventValue);
      bResult = bResult && (StartElement == rfoCmp.StartElement);
      bResult = bResult && (StartOffset == rfoCmp.StartOffset);
      bResult = bResult && (UTMLength == rfoCmp.UTMLength);
      bResult = bResult && (NavUTMContainer == rfoCmp.NavUTMContainer);
   return bResult;
}

fi_tclInContext& fi_tcl_UTMDesc::oRead(fi_tclInContext& oIn)
{
   oIn >> NaviEventValue;
   oIn >> StartElement;
   oIn >> StartOffset;
   oIn >> UTMLength;
   oIn >> NavUTMContainer;
   return oIn;
}

fi_tclOutContext& fi_tcl_UTMDesc::oWrite(fi_tclOutContext& oOut) const
{
   oOut << NaviEventValue;
   oOut << StartElement;
   oOut << StartOffset;
   oOut << UTMLength;
   oOut << NavUTMContainer;
   return oOut;
}

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
fi_tcl_UTMDescByTM::fi_tcl_UTMDescByTM(const fi_tcl_UTMDescByTM& coRef):fi_tclVisitableTypeBase(coRef)
{
   TrafficMessageRevision = coRef.TrafficMessageRevision;
   TrafficMessageID = coRef.TrafficMessageID;
   NaviEventValue = coRef.NaviEventValue;
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
fi_tcl_UTMDescByTM& fi_tcl_UTMDescByTM::operator=(const fi_tcl_UTMDescByTM& coRef)
{
   if (this == &coRef) return *this;
   TrafficMessageRevision = coRef.TrafficMessageRevision;
   TrafficMessageID = coRef.TrafficMessageID;
   NaviEventValue = coRef.NaviEventValue;
   return *this;
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
tU32 fi_tcl_UTMDescByTM::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 10;
}

tBool fi_tcl_UTMDescByTM::operator==(const fi_tcl_UTMDescByTM& rfoCmp) const
{
   tBool bResult = true;
      bResult = bResult && (TrafficMessageRevision == rfoCmp.TrafficMessageRevision);
      bResult = bResult && (TrafficMessageID == rfoCmp.TrafficMessageID);
      bResult = bResult && (NaviEventValue == rfoCmp.NaviEventValue);
   return bResult;
}

fi_tclInContext& fi_tcl_UTMDescByTM::oRead(fi_tclInContext& oIn)
{
   oIn >> TrafficMessageRevision;
   oIn >> TrafficMessageID;
   oIn >> NaviEventValue;
   return oIn;
}

fi_tclOutContext& fi_tcl_UTMDescByTM::oWrite(fi_tclOutContext& oOut) const
{
   oOut << TrafficMessageRevision;
   oOut << TrafficMessageID;
   oOut << NaviEventValue;
   return oOut;
}

tU32 fi_tcl_b16_PositionReliability::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 2;
}

tBool fi_tcl_b16_PositionReliability::operator==(const fi_tcl_b16_PositionReliability& rfoCmp) const
{
   return u16Value == rfoCmp.u16Value;
}

fi_tclInContext& fi_tcl_b16_PositionReliability::oRead(fi_tclInContext& oIn)
{
   return oIn >> u16Value;
}

fi_tclOutContext& fi_tcl_b16_PositionReliability::oWrite(fi_tclOutContext& oOut) const
{
   return oOut << u16Value;
}

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
fi_tcl_PositionHeadingSpeed::fi_tcl_PositionHeadingSpeed(const fi_tcl_PositionHeadingSpeed& coRef):fi_tclVisitableTypeBase(coRef)
{
   PositionWGS84 = coRef.PositionWGS84;
   PositionReliability = coRef.PositionReliability;
   Speed = coRef.Speed;
   Heading = coRef.Heading;
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
fi_tcl_PositionHeadingSpeed& fi_tcl_PositionHeadingSpeed::operator=(const fi_tcl_PositionHeadingSpeed& coRef)
{
   if (this == &coRef) return *this;
   PositionWGS84 = coRef.PositionWGS84;
   PositionReliability = coRef.PositionReliability;
   Speed = coRef.Speed;
   Heading = coRef.Heading;
   return *this;
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
tVoid fi_tcl_PositionHeadingSpeed::vDestroy()
{
   PositionWGS84.vDestroy(); 
}

tU32 fi_tcl_PositionHeadingSpeed::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 13;
}

tBool fi_tcl_PositionHeadingSpeed::operator==(const fi_tcl_PositionHeadingSpeed& rfoCmp) const
{
   tBool bResult = true;
      bResult = bResult && (PositionWGS84 == rfoCmp.PositionWGS84);
      bResult = bResult && (PositionReliability == rfoCmp.PositionReliability);
      bResult = bResult && (Speed == rfoCmp.Speed);
      bResult = bResult && (Heading == rfoCmp.Heading);
   return bResult;
}

fi_tclInContext& fi_tcl_PositionHeadingSpeed::oRead(fi_tclInContext& oIn)
{
   oIn >> PositionWGS84;
   oIn >> PositionReliability;
   oIn >> Speed;
   oIn >> Heading;
   return oIn;
}

fi_tclOutContext& fi_tcl_PositionHeadingSpeed::oWrite(fi_tclOutContext& oOut) const
{
   oOut << PositionWGS84;
   oOut << PositionReliability;
   oOut << Speed;
   oOut << Heading;
   return oOut;
}

tU32 fi_tcl_e8_InfoStatus::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 1;
}

tBool fi_tcl_e8_InfoStatus::operator==(const fi_tcl_e8_InfoStatus& rfoCmp) const
{
   return enType == rfoCmp.enType;
}

fi_tclInContext& fi_tcl_e8_InfoStatus::oRead(fi_tclInContext& oIn)
{
   tU8 u8Value;
   oIn >> u8Value;
   enType = (tenType)u8Value;
   return oIn;
}

fi_tclOutContext& fi_tcl_e8_InfoStatus::oWrite(fi_tclOutContext& oOut) const
{
   return oOut.oWrite((tU8)enType);
}

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
fi_tcl_InfoStatus::fi_tcl_InfoStatus(const fi_tcl_InfoStatus& coRef):fi_tclVisitableTypeBase(coRef)
{
   InfoCounter = coRef.InfoCounter;
   Status = coRef.Status;
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
fi_tcl_InfoStatus& fi_tcl_InfoStatus::operator=(const fi_tcl_InfoStatus& coRef)
{
   if (this == &coRef) return *this;
   InfoCounter = coRef.InfoCounter;
   Status = coRef.Status;
   return *this;
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
tU32 fi_tcl_InfoStatus::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 3;
}

tBool fi_tcl_InfoStatus::operator==(const fi_tcl_InfoStatus& rfoCmp) const
{
   tBool bResult = true;
      bResult = bResult && (InfoCounter == rfoCmp.InfoCounter);
      bResult = bResult && (Status == rfoCmp.Status);
   return bResult;
}

fi_tclInContext& fi_tcl_InfoStatus::oRead(fi_tclInContext& oIn)
{
   oIn >> InfoCounter;
   oIn >> Status;
   return oIn;
}

fi_tclOutContext& fi_tcl_InfoStatus::oWrite(fi_tclOutContext& oOut) const
{
   oOut << InfoCounter;
   oOut << Status;
   return oOut;
}

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
fi_tcl_DirectionInfoListSet::fi_tcl_DirectionInfoListSet(const fi_tcl_DirectionInfoListSet& coRef):fi_tclVisitableTypeBase(coRef)
{
   AlternativRefList = coRef.AlternativRefList;
   DirectionInfoList = coRef.DirectionInfoList;
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
fi_tcl_DirectionInfoListSet& fi_tcl_DirectionInfoListSet::operator=(const fi_tcl_DirectionInfoListSet& coRef)
{
   if (this == &coRef) return *this;
   AlternativRefList = coRef.AlternativRefList;
   DirectionInfoList = coRef.DirectionInfoList;
   return *this;
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
tVoid fi_tcl_DirectionInfoListSet::vDestroy()
{
   {
      for (tU32 u32Idx = 0; u32Idx < AlternativRefList.size(); ++u32Idx)
         AlternativRefList[u32Idx].vDestroy();
   }
   AlternativRefList.clear();
   {
      for (tU32 u32Idx = 0; u32Idx < DirectionInfoList.size(); ++u32Idx)
         DirectionInfoList[u32Idx].vDestroy();
   }
   DirectionInfoList.clear();
}

tU32 fi_tcl_DirectionInfoListSet::u32GetSize(tU16 u16MajorVersion) const
{
   tU32 u32DynamicSize = 0;
   tU32 u32ListIdx;
   for (u32ListIdx = 0; u32ListIdx < DirectionInfoList.size(); ++u32ListIdx)
      u32DynamicSize += DirectionInfoList[u32ListIdx].u32GetSize(u16MajorVersion);
   return u32DynamicSize+8+AlternativRefList.size()*4;
}

tBool fi_tcl_DirectionInfoListSet::operator==(const fi_tcl_DirectionInfoListSet& rfoCmp) const
{
   tBool bResult = true;
      bResult = bResult && (AlternativRefList.size() == rfoCmp.AlternativRefList.size());
      if (bResult)
      {
         for (tU32 u32Idx = 0; bResult && (u32Idx < AlternativRefList.size()); ++u32Idx)
            bResult = bResult && (AlternativRefList[u32Idx] == rfoCmp.AlternativRefList[u32Idx]);
      }
      bResult = bResult && (DirectionInfoList.size() == rfoCmp.DirectionInfoList.size());
      if (bResult)
      {
         for (tU32 u32Idx = 0; bResult && (u32Idx < DirectionInfoList.size()); ++u32Idx)
            bResult = bResult && (DirectionInfoList[u32Idx] == rfoCmp.DirectionInfoList[u32Idx]);
      }
   return bResult;
}

fi_tclInContext& fi_tcl_DirectionInfoListSet::oRead(fi_tclInContext& oIn)
{
   {
      tU32 u32Length;
      tU32 u32Idx;
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
      for (u32Idx = 0; u32Idx < AlternativRefList.size(); ++u32Idx)
      {
         AlternativRefList[u32Idx].vDestroy();
      }
#endif // !VARIANT_S_FTR_ENABLE_DEEP_COPY
      oIn >> u32Length;
      AlternativRefList.resize(u32Length);
      for (u32Idx = 0; u32Idx < u32Length; ++u32Idx)
      {
         oIn >> AlternativRefList[u32Idx];
      }
   }
   {
      tU32 u32Length;
      tU32 u32Idx;
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
      for (u32Idx = 0; u32Idx < DirectionInfoList.size(); ++u32Idx)
      {
         DirectionInfoList[u32Idx].vDestroy();
      }
#endif // !VARIANT_S_FTR_ENABLE_DEEP_COPY
      oIn >> u32Length;
      DirectionInfoList.resize(u32Length);
      for (u32Idx = 0; u32Idx < u32Length; ++u32Idx)
      {
         oIn >> DirectionInfoList[u32Idx];
      }
   }
   return oIn;
}

fi_tclOutContext& fi_tcl_DirectionInfoListSet::oWrite(fi_tclOutContext& oOut) const
{
   oOut << (tU32)AlternativRefList.size();
   {
      for (tU32 u32Idx = 0; u32Idx < AlternativRefList.size(); ++u32Idx)
         oOut << AlternativRefList[u32Idx];
   }
   oOut << (tU32)DirectionInfoList.size();
   {
      for (tU32 u32Idx = 0; u32Idx < DirectionInfoList.size(); ++u32Idx)
         oOut << DirectionInfoList[u32Idx];
   }
   return oOut;
}

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
fi_tcl_ReferenceElementWithID::fi_tcl_ReferenceElementWithID(const fi_tcl_ReferenceElementWithID& coRef):fi_tclVisitableTypeBase(coRef)
{
   BaseList = coRef.BaseList;
   RefList = coRef.RefList;
   ID = coRef.ID;
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
fi_tcl_ReferenceElementWithID& fi_tcl_ReferenceElementWithID::operator=(const fi_tcl_ReferenceElementWithID& coRef)
{
   if (this == &coRef) return *this;
   BaseList = coRef.BaseList;
   RefList = coRef.RefList;
   ID = coRef.ID;
   return *this;
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
tU32 fi_tcl_ReferenceElementWithID::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 8;
}

tBool fi_tcl_ReferenceElementWithID::operator==(const fi_tcl_ReferenceElementWithID& rfoCmp) const
{
   tBool bResult = true;
      bResult = bResult && (BaseList == rfoCmp.BaseList);
      bResult = bResult && (RefList == rfoCmp.RefList);
      bResult = bResult && (ID == rfoCmp.ID);
   return bResult;
}

fi_tclInContext& fi_tcl_ReferenceElementWithID::oRead(fi_tclInContext& oIn)
{
   oIn >> BaseList;
   oIn >> RefList;
   oIn >> ID;
   return oIn;
}

fi_tclOutContext& fi_tcl_ReferenceElementWithID::oWrite(fi_tclOutContext& oOut) const
{
   oOut << BaseList;
   oOut << RefList;
   oOut << ID;
   return oOut;
}

tU32 fi_tcl_e8_SingleRoadInfoCategory::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 1;
}

tBool fi_tcl_e8_SingleRoadInfoCategory::operator==(const fi_tcl_e8_SingleRoadInfoCategory& rfoCmp) const
{
   return enType == rfoCmp.enType;
}

fi_tclInContext& fi_tcl_e8_SingleRoadInfoCategory::oRead(fi_tclInContext& oIn)
{
   tU8 u8Value;
   oIn >> u8Value;
   enType = (tenType)u8Value;
   return oIn;
}

fi_tclOutContext& fi_tcl_e8_SingleRoadInfoCategory::oWrite(fi_tclOutContext& oOut) const
{
   fi_tcl_e8_SingleRoadInfoCategory::tenType enData = enType;
   if ((enData == FI_EN_T_TIMEZONEELEMENT) && !(21 <= oOut.u16GetMajorVersion()))
   {
      enData = FI_EN_T_RESERVED;
   }
   if ((enData == FI_EN_T_REQUIREDPERMISSIONLIST) && !(9 <= oOut.u16GetMajorVersion()))
   {
      enData = FI_EN_T_RESERVED;
   }
   if ((enData == FI_EN_T_DIRECTIONINFOLIST) && !(9 <= oOut.u16GetMajorVersion()))
   {
      enData = FI_EN_T_RESERVED;
   }
   return oOut.oWrite((tU8)enData);
}

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
fi_tcl_SingleRoadInfo::fi_tcl_SingleRoadInfo(const fi_tcl_SingleRoadInfo& coRef):fi_tclVisitableTypeBase(coRef)
{
   CategoryType = coRef.CategoryType;
   if  (coRef.poCategoryData)
   {
      switch(CategoryType.enType)
      {
      case fi_tcl_e8_SingleRoadInfoCategory::FI_EN_T_RESERVED:
         poCategoryData = OSAL_NEW fi_tcl_Reserved((const fi_tcl_Reserved&)*coRef.poCategoryData);
         break;
      case fi_tcl_e8_SingleRoadInfoCategory::FI_EN_T_COUNTRYNAMEELEMENT:
         poCategoryData = OSAL_NEW fi_tcl_CountryNameElement((const fi_tcl_CountryNameElement&)*coRef.poCategoryData);
         break;
      case fi_tcl_e8_SingleRoadInfoCategory::FI_EN_T_STATENAMEELEMENT:
         poCategoryData = OSAL_NEW fi_tcl_StateNameElement((const fi_tcl_StateNameElement&)*coRef.poCategoryData);
         break;
      case fi_tcl_e8_SingleRoadInfoCategory::FI_EN_T_COUNTYNAMEELEMENT:
         poCategoryData = OSAL_NEW fi_tcl_CountyNameElement((const fi_tcl_CountyNameElement&)*coRef.poCategoryData);
         break;
      case fi_tcl_e8_SingleRoadInfoCategory::FI_EN_T_CITYNAMEELEMENT:
         poCategoryData = OSAL_NEW fi_tcl_CityNameElement((const fi_tcl_CityNameElement&)*coRef.poCategoryData);
         break;
      case fi_tcl_e8_SingleRoadInfoCategory::FI_EN_T_CITYDISTRICTNAMEELEMENT:
         poCategoryData = OSAL_NEW fi_tcl_CityDistrictNameElement((const fi_tcl_CityDistrictNameElement&)*coRef.poCategoryData);
         break;
      case fi_tcl_e8_SingleRoadInfoCategory::FI_EN_T_BUILDUPAREANAMEELEMENT:
         poCategoryData = OSAL_NEW fi_tcl_BuildUpAreaNameElement((const fi_tcl_BuildUpAreaNameElement&)*coRef.poCategoryData);
         break;
      case fi_tcl_e8_SingleRoadInfoCategory::FI_EN_T_ROADNAMEELEMENTLIST:
         poCategoryData = OSAL_NEW fi_tcl_RoadNameElementList((const fi_tcl_RoadNameElementList&)*coRef.poCategoryData);
         break;
      case fi_tcl_e8_SingleRoadInfoCategory::FI_EN_T_ROADNUMBERELEMENTLIST:
         poCategoryData = OSAL_NEW fi_tcl_RoadNumberElementList((const fi_tcl_RoadNumberElementList&)*coRef.poCategoryData);
         break;
      case fi_tcl_e8_SingleRoadInfoCategory::FI_EN_T_EXTRADESCELEMENT:
         poCategoryData = OSAL_NEW fi_tcl_ExtraDescElement((const fi_tcl_ExtraDescElement&)*coRef.poCategoryData);
         break;
      case fi_tcl_e8_SingleRoadInfoCategory::FI_EN_T_DATADESCELEMENT:
         poCategoryData = OSAL_NEW fi_tcl_DataDescElement((const fi_tcl_DataDescElement&)*coRef.poCategoryData);
         break;
      case fi_tcl_e8_SingleRoadInfoCategory::FI_EN_T_INTERSECTIONDESCELEMENT:
         poCategoryData = OSAL_NEW fi_tcl_IntersectionDescElement((const fi_tcl_IntersectionDescElement&)*coRef.poCategoryData);
         break;
      case fi_tcl_e8_SingleRoadInfoCategory::FI_EN_T_TRAFFICSIGNLIST:
         poCategoryData = OSAL_NEW fi_tcl_TrafficSignList((const fi_tcl_TrafficSignList&)*coRef.poCategoryData);
         break;
      case fi_tcl_e8_SingleRoadInfoCategory::FI_EN_T_DIRECTIONINFOLIST:
         poCategoryData = OSAL_NEW fi_tcl_DirectionInfoList((const fi_tcl_DirectionInfoList&)*coRef.poCategoryData);
         break;
      case fi_tcl_e8_SingleRoadInfoCategory::FI_EN_T_REQUIREDPERMISSIONLIST:
         poCategoryData = OSAL_NEW fi_tcl_RequiredPermissionList((const fi_tcl_RequiredPermissionList&)*coRef.poCategoryData);
         break;
      case fi_tcl_e8_SingleRoadInfoCategory::FI_EN_T_TIMEZONEELEMENT:
         poCategoryData = OSAL_NEW fi_tcl_TimeZoneElement((const fi_tcl_TimeZoneElement&)*coRef.poCategoryData);
         break;
      default:
         poCategoryData = OSAL_NULL;
      }
   }
   else
   {
      poCategoryData = OSAL_NULL;
   }
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
fi_tcl_SingleRoadInfo& fi_tcl_SingleRoadInfo::operator=(const fi_tcl_SingleRoadInfo& coRef)
{
   if (this == &coRef) return *this;
   OSAL_DELETE poCategoryData;
   CategoryType = coRef.CategoryType;
   if  (coRef.poCategoryData)
   {
      switch(CategoryType.enType)
      {
      case fi_tcl_e8_SingleRoadInfoCategory::FI_EN_T_RESERVED:
         poCategoryData = OSAL_NEW fi_tcl_Reserved((const fi_tcl_Reserved&)*coRef.poCategoryData);
         break;
      case fi_tcl_e8_SingleRoadInfoCategory::FI_EN_T_COUNTRYNAMEELEMENT:
         poCategoryData = OSAL_NEW fi_tcl_CountryNameElement((const fi_tcl_CountryNameElement&)*coRef.poCategoryData);
         break;
      case fi_tcl_e8_SingleRoadInfoCategory::FI_EN_T_STATENAMEELEMENT:
         poCategoryData = OSAL_NEW fi_tcl_StateNameElement((const fi_tcl_StateNameElement&)*coRef.poCategoryData);
         break;
      case fi_tcl_e8_SingleRoadInfoCategory::FI_EN_T_COUNTYNAMEELEMENT:
         poCategoryData = OSAL_NEW fi_tcl_CountyNameElement((const fi_tcl_CountyNameElement&)*coRef.poCategoryData);
         break;
      case fi_tcl_e8_SingleRoadInfoCategory::FI_EN_T_CITYNAMEELEMENT:
         poCategoryData = OSAL_NEW fi_tcl_CityNameElement((const fi_tcl_CityNameElement&)*coRef.poCategoryData);
         break;
      case fi_tcl_e8_SingleRoadInfoCategory::FI_EN_T_CITYDISTRICTNAMEELEMENT:
         poCategoryData = OSAL_NEW fi_tcl_CityDistrictNameElement((const fi_tcl_CityDistrictNameElement&)*coRef.poCategoryData);
         break;
      case fi_tcl_e8_SingleRoadInfoCategory::FI_EN_T_BUILDUPAREANAMEELEMENT:
         poCategoryData = OSAL_NEW fi_tcl_BuildUpAreaNameElement((const fi_tcl_BuildUpAreaNameElement&)*coRef.poCategoryData);
         break;
      case fi_tcl_e8_SingleRoadInfoCategory::FI_EN_T_ROADNAMEELEMENTLIST:
         poCategoryData = OSAL_NEW fi_tcl_RoadNameElementList((const fi_tcl_RoadNameElementList&)*coRef.poCategoryData);
         break;
      case fi_tcl_e8_SingleRoadInfoCategory::FI_EN_T_ROADNUMBERELEMENTLIST:
         poCategoryData = OSAL_NEW fi_tcl_RoadNumberElementList((const fi_tcl_RoadNumberElementList&)*coRef.poCategoryData);
         break;
      case fi_tcl_e8_SingleRoadInfoCategory::FI_EN_T_EXTRADESCELEMENT:
         poCategoryData = OSAL_NEW fi_tcl_ExtraDescElement((const fi_tcl_ExtraDescElement&)*coRef.poCategoryData);
         break;
      case fi_tcl_e8_SingleRoadInfoCategory::FI_EN_T_DATADESCELEMENT:
         poCategoryData = OSAL_NEW fi_tcl_DataDescElement((const fi_tcl_DataDescElement&)*coRef.poCategoryData);
         break;
      case fi_tcl_e8_SingleRoadInfoCategory::FI_EN_T_INTERSECTIONDESCELEMENT:
         poCategoryData = OSAL_NEW fi_tcl_IntersectionDescElement((const fi_tcl_IntersectionDescElement&)*coRef.poCategoryData);
         break;
      case fi_tcl_e8_SingleRoadInfoCategory::FI_EN_T_TRAFFICSIGNLIST:
         poCategoryData = OSAL_NEW fi_tcl_TrafficSignList((const fi_tcl_TrafficSignList&)*coRef.poCategoryData);
         break;
      case fi_tcl_e8_SingleRoadInfoCategory::FI_EN_T_DIRECTIONINFOLIST:
         poCategoryData = OSAL_NEW fi_tcl_DirectionInfoList((const fi_tcl_DirectionInfoList&)*coRef.poCategoryData);
         break;
      case fi_tcl_e8_SingleRoadInfoCategory::FI_EN_T_REQUIREDPERMISSIONLIST:
         poCategoryData = OSAL_NEW fi_tcl_RequiredPermissionList((const fi_tcl_RequiredPermissionList&)*coRef.poCategoryData);
         break;
      case fi_tcl_e8_SingleRoadInfoCategory::FI_EN_T_TIMEZONEELEMENT:
         poCategoryData = OSAL_NEW fi_tcl_TimeZoneElement((const fi_tcl_TimeZoneElement&)*coRef.poCategoryData);
         break;
      default:
         poCategoryData = OSAL_NULL;
      }
   }
   else
   {
      poCategoryData = OSAL_NULL;
   }
   return *this;
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
fi_tcl_SingleRoadInfo::~fi_tcl_SingleRoadInfo()
{
   OSAL_DELETE poCategoryData;
   poCategoryData = OSAL_NULL;
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
tVoid fi_tcl_SingleRoadInfo::vDestroy()
{
   if (poCategoryData)
   {
      poCategoryData->vDestroy();
      OSAL_DELETE poCategoryData;
      poCategoryData = OSAL_NULL;
   }
}

tU32 fi_tcl_SingleRoadInfo::u32GetSize(tU16 u16MajorVersion) const
{
   tU32 u32DynamicSize = 0;
   if (CategoryType.enType == fi_tcl_e8_SingleRoadInfoCategory::FI_EN_T_RESERVED)
      u32DynamicSize += (poCategoryData?poCategoryData->u32GetSize(u16MajorVersion):0);
   if (CategoryType.enType == fi_tcl_e8_SingleRoadInfoCategory::FI_EN_T_COUNTRYNAMEELEMENT)
      u32DynamicSize += (poCategoryData?poCategoryData->u32GetSize(u16MajorVersion):0);
   if (CategoryType.enType == fi_tcl_e8_SingleRoadInfoCategory::FI_EN_T_STATENAMEELEMENT)
      u32DynamicSize += (poCategoryData?poCategoryData->u32GetSize(u16MajorVersion):0);
   if (CategoryType.enType == fi_tcl_e8_SingleRoadInfoCategory::FI_EN_T_COUNTYNAMEELEMENT)
      u32DynamicSize += (poCategoryData?poCategoryData->u32GetSize(u16MajorVersion):0);
   if (CategoryType.enType == fi_tcl_e8_SingleRoadInfoCategory::FI_EN_T_CITYNAMEELEMENT)
      u32DynamicSize += (poCategoryData?poCategoryData->u32GetSize(u16MajorVersion):0);
   if (CategoryType.enType == fi_tcl_e8_SingleRoadInfoCategory::FI_EN_T_CITYDISTRICTNAMEELEMENT)
      u32DynamicSize += (poCategoryData?poCategoryData->u32GetSize(u16MajorVersion):0);
   if (CategoryType.enType == fi_tcl_e8_SingleRoadInfoCategory::FI_EN_T_BUILDUPAREANAMEELEMENT)
      u32DynamicSize += (poCategoryData?poCategoryData->u32GetSize(u16MajorVersion):0);
   if (CategoryType.enType == fi_tcl_e8_SingleRoadInfoCategory::FI_EN_T_ROADNAMEELEMENTLIST)
      u32DynamicSize += (poCategoryData?poCategoryData->u32GetSize(u16MajorVersion):0);
   if (CategoryType.enType == fi_tcl_e8_SingleRoadInfoCategory::FI_EN_T_ROADNUMBERELEMENTLIST)
      u32DynamicSize += (poCategoryData?poCategoryData->u32GetSize(u16MajorVersion):0);
   if (CategoryType.enType == fi_tcl_e8_SingleRoadInfoCategory::FI_EN_T_EXTRADESCELEMENT)
      u32DynamicSize += (poCategoryData?poCategoryData->u32GetSize(u16MajorVersion):0);
   if (CategoryType.enType == fi_tcl_e8_SingleRoadInfoCategory::FI_EN_T_DATADESCELEMENT)
      u32DynamicSize += (poCategoryData?poCategoryData->u32GetSize(u16MajorVersion):0);
   if (CategoryType.enType == fi_tcl_e8_SingleRoadInfoCategory::FI_EN_T_INTERSECTIONDESCELEMENT)
      u32DynamicSize += (poCategoryData?poCategoryData->u32GetSize(u16MajorVersion):0);
   if (CategoryType.enType == fi_tcl_e8_SingleRoadInfoCategory::FI_EN_T_TRAFFICSIGNLIST)
      u32DynamicSize += (poCategoryData?poCategoryData->u32GetSize(u16MajorVersion):0);
   if ((CategoryType.enType == fi_tcl_e8_SingleRoadInfoCategory::FI_EN_T_DIRECTIONINFOLIST) &&
       (9 <= u16MajorVersion))
      u32DynamicSize += (poCategoryData?poCategoryData->u32GetSize(u16MajorVersion):0);
   if ((CategoryType.enType == fi_tcl_e8_SingleRoadInfoCategory::FI_EN_T_REQUIREDPERMISSIONLIST) &&
       (9 <= u16MajorVersion))
      u32DynamicSize += (poCategoryData?poCategoryData->u32GetSize(u16MajorVersion):0);
   if ((CategoryType.enType == fi_tcl_e8_SingleRoadInfoCategory::FI_EN_T_TIMEZONEELEMENT) &&
       (21 <= u16MajorVersion))
      u32DynamicSize += (poCategoryData?poCategoryData->u32GetSize(u16MajorVersion):0);
   return u32DynamicSize+1;
}

tBool fi_tcl_SingleRoadInfo::operator==(const fi_tcl_SingleRoadInfo& rfoCmp) const
{
   tBool bResult = true;
   bResult = bResult && (CategoryType == rfoCmp.CategoryType);
   if (bResult && poCategoryData && rfoCmp.poCategoryData) 
   {
      switch (CategoryType.enType)
      {
      case fi_tcl_e8_SingleRoadInfoCategory::FI_EN_T_RESERVED:
         bResult = bResult && (*(const fi_tcl_Reserved*)poCategoryData == *(const fi_tcl_Reserved*)rfoCmp.poCategoryData); //lint !e826
      break;
      case fi_tcl_e8_SingleRoadInfoCategory::FI_EN_T_COUNTRYNAMEELEMENT:
         bResult = bResult && (*(const fi_tcl_CountryNameElement*)poCategoryData == *(const fi_tcl_CountryNameElement*)rfoCmp.poCategoryData); //lint !e826
      break;
      case fi_tcl_e8_SingleRoadInfoCategory::FI_EN_T_STATENAMEELEMENT:
         bResult = bResult && (*(const fi_tcl_StateNameElement*)poCategoryData == *(const fi_tcl_StateNameElement*)rfoCmp.poCategoryData); //lint !e826
      break;
      case fi_tcl_e8_SingleRoadInfoCategory::FI_EN_T_COUNTYNAMEELEMENT:
         bResult = bResult && (*(const fi_tcl_CountyNameElement*)poCategoryData == *(const fi_tcl_CountyNameElement*)rfoCmp.poCategoryData); //lint !e826
      break;
      case fi_tcl_e8_SingleRoadInfoCategory::FI_EN_T_CITYNAMEELEMENT:
         bResult = bResult && (*(const fi_tcl_CityNameElement*)poCategoryData == *(const fi_tcl_CityNameElement*)rfoCmp.poCategoryData); //lint !e826
      break;
      case fi_tcl_e8_SingleRoadInfoCategory::FI_EN_T_CITYDISTRICTNAMEELEMENT:
         bResult = bResult && (*(const fi_tcl_CityDistrictNameElement*)poCategoryData == *(const fi_tcl_CityDistrictNameElement*)rfoCmp.poCategoryData); //lint !e826
      break;
      case fi_tcl_e8_SingleRoadInfoCategory::FI_EN_T_BUILDUPAREANAMEELEMENT:
         bResult = bResult && (*(const fi_tcl_BuildUpAreaNameElement*)poCategoryData == *(const fi_tcl_BuildUpAreaNameElement*)rfoCmp.poCategoryData); //lint !e826
      break;
      case fi_tcl_e8_SingleRoadInfoCategory::FI_EN_T_ROADNAMEELEMENTLIST:
         bResult = bResult && (*(const fi_tcl_RoadNameElementList*)poCategoryData == *(const fi_tcl_RoadNameElementList*)rfoCmp.poCategoryData); //lint !e826
      break;
      case fi_tcl_e8_SingleRoadInfoCategory::FI_EN_T_ROADNUMBERELEMENTLIST:
         bResult = bResult && (*(const fi_tcl_RoadNumberElementList*)poCategoryData == *(const fi_tcl_RoadNumberElementList*)rfoCmp.poCategoryData); //lint !e826
      break;
      case fi_tcl_e8_SingleRoadInfoCategory::FI_EN_T_EXTRADESCELEMENT:
         bResult = bResult && (*(const fi_tcl_ExtraDescElement*)poCategoryData == *(const fi_tcl_ExtraDescElement*)rfoCmp.poCategoryData); //lint !e826
      break;
      case fi_tcl_e8_SingleRoadInfoCategory::FI_EN_T_DATADESCELEMENT:
         bResult = bResult && (*(const fi_tcl_DataDescElement*)poCategoryData == *(const fi_tcl_DataDescElement*)rfoCmp.poCategoryData); //lint !e826
      break;
      case fi_tcl_e8_SingleRoadInfoCategory::FI_EN_T_INTERSECTIONDESCELEMENT:
         bResult = bResult && (*(const fi_tcl_IntersectionDescElement*)poCategoryData == *(const fi_tcl_IntersectionDescElement*)rfoCmp.poCategoryData); //lint !e826
      break;
      case fi_tcl_e8_SingleRoadInfoCategory::FI_EN_T_TRAFFICSIGNLIST:
         bResult = bResult && (*(const fi_tcl_TrafficSignList*)poCategoryData == *(const fi_tcl_TrafficSignList*)rfoCmp.poCategoryData); //lint !e826
      break;
      case fi_tcl_e8_SingleRoadInfoCategory::FI_EN_T_DIRECTIONINFOLIST:
         bResult = bResult && (*(const fi_tcl_DirectionInfoList*)poCategoryData == *(const fi_tcl_DirectionInfoList*)rfoCmp.poCategoryData); //lint !e826
      break;
      case fi_tcl_e8_SingleRoadInfoCategory::FI_EN_T_REQUIREDPERMISSIONLIST:
         bResult = bResult && (*(const fi_tcl_RequiredPermissionList*)poCategoryData == *(const fi_tcl_RequiredPermissionList*)rfoCmp.poCategoryData); //lint !e826
      break;
      case fi_tcl_e8_SingleRoadInfoCategory::FI_EN_T_TIMEZONEELEMENT:
         bResult = bResult && (*(const fi_tcl_TimeZoneElement*)poCategoryData == *(const fi_tcl_TimeZoneElement*)rfoCmp.poCategoryData); //lint !e826
      break;
      }
   }
   else
   {
      bResult = bResult && (poCategoryData == rfoCmp.poCategoryData);
   }
   return bResult;
}

fi_tclInContext& fi_tcl_SingleRoadInfo::oRead(fi_tclInContext& oIn)
{
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   OSAL_DELETE poCategoryData;
#else
   if (poCategoryData)
   {
      poCategoryData->vDestroy();
      OSAL_DELETE poCategoryData;
   }
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
   oIn >> CategoryType;
   switch(CategoryType.enType)
   {
   case fi_tcl_e8_SingleRoadInfoCategory::FI_EN_T_RESERVED:
      poCategoryData = OSAL_NEW fi_tcl_Reserved;
      break;
   case fi_tcl_e8_SingleRoadInfoCategory::FI_EN_T_COUNTRYNAMEELEMENT:
      poCategoryData = OSAL_NEW fi_tcl_CountryNameElement;
      break;
   case fi_tcl_e8_SingleRoadInfoCategory::FI_EN_T_STATENAMEELEMENT:
      poCategoryData = OSAL_NEW fi_tcl_StateNameElement;
      break;
   case fi_tcl_e8_SingleRoadInfoCategory::FI_EN_T_COUNTYNAMEELEMENT:
      poCategoryData = OSAL_NEW fi_tcl_CountyNameElement;
      break;
   case fi_tcl_e8_SingleRoadInfoCategory::FI_EN_T_CITYNAMEELEMENT:
      poCategoryData = OSAL_NEW fi_tcl_CityNameElement;
      break;
   case fi_tcl_e8_SingleRoadInfoCategory::FI_EN_T_CITYDISTRICTNAMEELEMENT:
      poCategoryData = OSAL_NEW fi_tcl_CityDistrictNameElement;
      break;
   case fi_tcl_e8_SingleRoadInfoCategory::FI_EN_T_BUILDUPAREANAMEELEMENT:
      poCategoryData = OSAL_NEW fi_tcl_BuildUpAreaNameElement;
      break;
   case fi_tcl_e8_SingleRoadInfoCategory::FI_EN_T_ROADNAMEELEMENTLIST:
      poCategoryData = OSAL_NEW fi_tcl_RoadNameElementList;
      break;
   case fi_tcl_e8_SingleRoadInfoCategory::FI_EN_T_ROADNUMBERELEMENTLIST:
      poCategoryData = OSAL_NEW fi_tcl_RoadNumberElementList;
      break;
   case fi_tcl_e8_SingleRoadInfoCategory::FI_EN_T_EXTRADESCELEMENT:
      poCategoryData = OSAL_NEW fi_tcl_ExtraDescElement;
      break;
   case fi_tcl_e8_SingleRoadInfoCategory::FI_EN_T_DATADESCELEMENT:
      poCategoryData = OSAL_NEW fi_tcl_DataDescElement;
      break;
   case fi_tcl_e8_SingleRoadInfoCategory::FI_EN_T_INTERSECTIONDESCELEMENT:
      poCategoryData = OSAL_NEW fi_tcl_IntersectionDescElement;
      break;
   case fi_tcl_e8_SingleRoadInfoCategory::FI_EN_T_TRAFFICSIGNLIST:
      poCategoryData = OSAL_NEW fi_tcl_TrafficSignList;
      break;
   case fi_tcl_e8_SingleRoadInfoCategory::FI_EN_T_DIRECTIONINFOLIST:
      poCategoryData = OSAL_NEW fi_tcl_DirectionInfoList;
      break;
   case fi_tcl_e8_SingleRoadInfoCategory::FI_EN_T_REQUIREDPERMISSIONLIST:
      poCategoryData = OSAL_NEW fi_tcl_RequiredPermissionList;
      break;
   case fi_tcl_e8_SingleRoadInfoCategory::FI_EN_T_TIMEZONEELEMENT:
      poCategoryData = OSAL_NEW fi_tcl_TimeZoneElement;
      break;
   default:
      oIn.Invalidate();
      poCategoryData = OSAL_NULL;
   }
   if (poCategoryData && oIn.bIsValid())
      poCategoryData->oRead(oIn);
   else
      oIn.Invalidate();
   return oIn;
}

fi_tclOutContext& fi_tcl_SingleRoadInfo::oWrite(fi_tclOutContext& oOut) const
{
   oOut << CategoryType;
   if (poCategoryData)
   {
      if (CategoryType.enType == fi_tcl_e8_SingleRoadInfoCategory::FI_EN_T_RESERVED)
      {
         poCategoryData->oWrite(oOut);
      }
      if (CategoryType.enType == fi_tcl_e8_SingleRoadInfoCategory::FI_EN_T_COUNTRYNAMEELEMENT)
      {
         poCategoryData->oWrite(oOut);
      }
      if (CategoryType.enType == fi_tcl_e8_SingleRoadInfoCategory::FI_EN_T_STATENAMEELEMENT)
      {
         poCategoryData->oWrite(oOut);
      }
      if (CategoryType.enType == fi_tcl_e8_SingleRoadInfoCategory::FI_EN_T_COUNTYNAMEELEMENT)
      {
         poCategoryData->oWrite(oOut);
      }
      if (CategoryType.enType == fi_tcl_e8_SingleRoadInfoCategory::FI_EN_T_CITYNAMEELEMENT)
      {
         poCategoryData->oWrite(oOut);
      }
      if (CategoryType.enType == fi_tcl_e8_SingleRoadInfoCategory::FI_EN_T_CITYDISTRICTNAMEELEMENT)
      {
         poCategoryData->oWrite(oOut);
      }
      if (CategoryType.enType == fi_tcl_e8_SingleRoadInfoCategory::FI_EN_T_BUILDUPAREANAMEELEMENT)
      {
         poCategoryData->oWrite(oOut);
      }
      if (CategoryType.enType == fi_tcl_e8_SingleRoadInfoCategory::FI_EN_T_ROADNAMEELEMENTLIST)
      {
         poCategoryData->oWrite(oOut);
      }
      if (CategoryType.enType == fi_tcl_e8_SingleRoadInfoCategory::FI_EN_T_ROADNUMBERELEMENTLIST)
      {
         poCategoryData->oWrite(oOut);
      }
      if (CategoryType.enType == fi_tcl_e8_SingleRoadInfoCategory::FI_EN_T_EXTRADESCELEMENT)
      {
         poCategoryData->oWrite(oOut);
      }
      if (CategoryType.enType == fi_tcl_e8_SingleRoadInfoCategory::FI_EN_T_DATADESCELEMENT)
      {
         poCategoryData->oWrite(oOut);
      }
      if (CategoryType.enType == fi_tcl_e8_SingleRoadInfoCategory::FI_EN_T_INTERSECTIONDESCELEMENT)
      {
         poCategoryData->oWrite(oOut);
      }
      if (CategoryType.enType == fi_tcl_e8_SingleRoadInfoCategory::FI_EN_T_TRAFFICSIGNLIST)
      {
         poCategoryData->oWrite(oOut);
      }
      if (CategoryType.enType == fi_tcl_e8_SingleRoadInfoCategory::FI_EN_T_DIRECTIONINFOLIST)
      {
         if (!(9 <= oOut.u16GetMajorVersion()))
         {
            fi_tcl_Reserved oDefault;
            oOut << oDefault;
         }
         else
         {
            poCategoryData->oWrite(oOut);
         }
      }
      if (CategoryType.enType == fi_tcl_e8_SingleRoadInfoCategory::FI_EN_T_REQUIREDPERMISSIONLIST)
      {
         if (!(9 <= oOut.u16GetMajorVersion()))
         {
            fi_tcl_Reserved oDefault;
            oOut << oDefault;
         }
         else
         {
            poCategoryData->oWrite(oOut);
         }
      }
      if (CategoryType.enType == fi_tcl_e8_SingleRoadInfoCategory::FI_EN_T_TIMEZONEELEMENT)
      {
         if (!(21 <= oOut.u16GetMajorVersion()))
         {
            fi_tcl_Reserved oDefault;
            oOut << oDefault;
         }
         else
         {
            poCategoryData->oWrite(oOut);
         }
      }
   }
   else
   {
      oOut.Invalidate();
   }
   return oOut;
}

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
fi_tcl_StateNameElement::fi_tcl_StateNameElement(const fi_tcl_StateNameElement& coRef):fi_tclVisitableTypeBase(coRef)
{
   StateName = coRef.StateName;
   StateCode_old = coRef.StateCode_old;
   StateCode = coRef.StateCode;
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
fi_tcl_StateNameElement& fi_tcl_StateNameElement::operator=(const fi_tcl_StateNameElement& coRef)
{
   if (this == &coRef) return *this;
   StateName = coRef.StateName;
   StateCode_old = coRef.StateCode_old;
   StateCode = coRef.StateCode;
   return *this;
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
tVoid fi_tcl_StateNameElement::vDestroy()
{
   StateName.vDestroy();
}

tU32 fi_tcl_StateNameElement::u32GetSize(tU16 u16MajorVersion) const
{
   tU32 u32DynamicSize = 0;
   if (u16MajorVersion <= 10)
   {
      u32DynamicSize += 2;
   }
   if (11 <= u16MajorVersion)
   {
      u32DynamicSize += 4;
   }
   return u32DynamicSize+0+StateName.u32GetSize(u16MajorVersion);
}

tBool fi_tcl_StateNameElement::operator==(const fi_tcl_StateNameElement& rfoCmp) const
{
   tBool bResult = true;
      bResult = bResult && (StateName == rfoCmp.StateName);
      bResult = bResult && (StateCode_old == rfoCmp.StateCode_old);
      bResult = bResult && (StateCode == rfoCmp.StateCode);
   return bResult;
}

fi_tclInContext& fi_tcl_StateNameElement::oRead(fi_tclInContext& oIn)
{
   oIn >> StateName;
   if (oIn.u16GetMajorVersion() <= 10)
   {
      oIn >> StateCode_old;
   }
   if (11 <= oIn.u16GetMajorVersion())
   {
      oIn >> StateCode;
   }
   return oIn;
}

fi_tclOutContext& fi_tcl_StateNameElement::oWrite(fi_tclOutContext& oOut) const
{
   oOut << StateName;
   if (oOut.u16GetMajorVersion() <= 10)
   {
      oOut << StateCode_old;
   }
   if (11 <= oOut.u16GetMajorVersion())
   {
      oOut << StateCode;
   }
   return oOut;
}

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
fi_tcl_CountyNameElement::fi_tcl_CountyNameElement(const fi_tcl_CountyNameElement& coRef):fi_tclVisitableTypeBase(coRef)
{
   CountyName = coRef.CountyName;
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
fi_tcl_CountyNameElement& fi_tcl_CountyNameElement::operator=(const fi_tcl_CountyNameElement& coRef)
{
   if (this == &coRef) return *this;
   CountyName = coRef.CountyName;
   return *this;
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
tVoid fi_tcl_CountyNameElement::vDestroy()
{
   CountyName.vDestroy();
}

tU32 fi_tcl_CountyNameElement::u32GetSize(tU16 u16MajorVersion) const
{
   return 0+CountyName.u32GetSize(u16MajorVersion);
}

tBool fi_tcl_CountyNameElement::operator==(const fi_tcl_CountyNameElement& rfoCmp) const
{
   tBool bResult = true;
      bResult = bResult && (CountyName == rfoCmp.CountyName);
   return bResult;
}

fi_tclInContext& fi_tcl_CountyNameElement::oRead(fi_tclInContext& oIn)
{
   oIn >> CountyName;
   return oIn;
}

fi_tclOutContext& fi_tcl_CountyNameElement::oWrite(fi_tclOutContext& oOut) const
{
   oOut << CountyName;
   return oOut;
}

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
fi_tcl_CityDistrictNameElement::fi_tcl_CityDistrictNameElement(const fi_tcl_CityDistrictNameElement& coRef):fi_tclVisitableTypeBase(coRef)
{
   Name = coRef.Name;
   Priority = coRef.Priority;
   Population = coRef.Population;
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
fi_tcl_CityDistrictNameElement& fi_tcl_CityDistrictNameElement::operator=(const fi_tcl_CityDistrictNameElement& coRef)
{
   if (this == &coRef) return *this;
   Name = coRef.Name;
   Priority = coRef.Priority;
   Population = coRef.Population;
   return *this;
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
tVoid fi_tcl_CityDistrictNameElement::vDestroy()
{
   Name.vDestroy();
}

tU32 fi_tcl_CityDistrictNameElement::u32GetSize(tU16 u16MajorVersion) const
{
   return 5+Name.u32GetSize(u16MajorVersion);
}

tBool fi_tcl_CityDistrictNameElement::operator==(const fi_tcl_CityDistrictNameElement& rfoCmp) const
{
   tBool bResult = true;
      bResult = bResult && (Name == rfoCmp.Name);
      bResult = bResult && (Priority == rfoCmp.Priority);
      bResult = bResult && (Population == rfoCmp.Population);
   return bResult;
}

fi_tclInContext& fi_tcl_CityDistrictNameElement::oRead(fi_tclInContext& oIn)
{
   oIn >> Name;
   oIn >> Priority;
   oIn >> Population;
   return oIn;
}

fi_tclOutContext& fi_tcl_CityDistrictNameElement::oWrite(fi_tclOutContext& oOut) const
{
   oOut << Name;
   oOut << Priority;
   oOut << Population;
   return oOut;
}

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
fi_tcl_BuildUpAreaNameElement::fi_tcl_BuildUpAreaNameElement(const fi_tcl_BuildUpAreaNameElement& coRef):fi_tclVisitableTypeBase(coRef)
{
   Name = coRef.Name;
   Priority = coRef.Priority;
   Population = coRef.Population;
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
fi_tcl_BuildUpAreaNameElement& fi_tcl_BuildUpAreaNameElement::operator=(const fi_tcl_BuildUpAreaNameElement& coRef)
{
   if (this == &coRef) return *this;
   Name = coRef.Name;
   Priority = coRef.Priority;
   Population = coRef.Population;
   return *this;
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
tVoid fi_tcl_BuildUpAreaNameElement::vDestroy()
{
   Name.vDestroy();
}

tU32 fi_tcl_BuildUpAreaNameElement::u32GetSize(tU16 u16MajorVersion) const
{
   return 5+Name.u32GetSize(u16MajorVersion);
}

tBool fi_tcl_BuildUpAreaNameElement::operator==(const fi_tcl_BuildUpAreaNameElement& rfoCmp) const
{
   tBool bResult = true;
      bResult = bResult && (Name == rfoCmp.Name);
      bResult = bResult && (Priority == rfoCmp.Priority);
      bResult = bResult && (Population == rfoCmp.Population);
   return bResult;
}

fi_tclInContext& fi_tcl_BuildUpAreaNameElement::oRead(fi_tclInContext& oIn)
{
   oIn >> Name;
   oIn >> Priority;
   oIn >> Population;
   return oIn;
}

fi_tclOutContext& fi_tcl_BuildUpAreaNameElement::oWrite(fi_tclOutContext& oOut) const
{
   oOut << Name;
   oOut << Priority;
   oOut << Population;
   return oOut;
}

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
fi_tcl_RoadNameElementList::fi_tcl_RoadNameElementList(const fi_tcl_RoadNameElementList& coRef):fi_tclVisitableTypeBase(coRef)
{
   RoadNameList = coRef.RoadNameList;
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
fi_tcl_RoadNameElementList& fi_tcl_RoadNameElementList::operator=(const fi_tcl_RoadNameElementList& coRef)
{
   if (this == &coRef) return *this;
   RoadNameList = coRef.RoadNameList;
   return *this;
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
tVoid fi_tcl_RoadNameElementList::vDestroy()
{
   {
      for (tU32 u32Idx = 0; u32Idx < RoadNameList.size(); ++u32Idx)
         RoadNameList[u32Idx].vDestroy();
   }
   RoadNameList.clear();
}

tU32 fi_tcl_RoadNameElementList::u32GetSize(tU16 u16MajorVersion) const
{
   tU32 u32DynamicSize = 0;
   tU32 u32ListIdx;
   for (u32ListIdx = 0; u32ListIdx < RoadNameList.size(); ++u32ListIdx)
      u32DynamicSize += RoadNameList[u32ListIdx].u32GetSize(u16MajorVersion);
   return u32DynamicSize+4;
}

tBool fi_tcl_RoadNameElementList::operator==(const fi_tcl_RoadNameElementList& rfoCmp) const
{
   tBool bResult = true;
      bResult = bResult && (RoadNameList.size() == rfoCmp.RoadNameList.size());
      if (bResult)
      {
         for (tU32 u32Idx = 0; bResult && (u32Idx < RoadNameList.size()); ++u32Idx)
            bResult = bResult && (RoadNameList[u32Idx] == rfoCmp.RoadNameList[u32Idx]);
      }
   return bResult;
}

fi_tclInContext& fi_tcl_RoadNameElementList::oRead(fi_tclInContext& oIn)
{
   {
      tU32 u32Length;
      tU32 u32Idx;
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
      for (u32Idx = 0; u32Idx < RoadNameList.size(); ++u32Idx)
      {
         RoadNameList[u32Idx].vDestroy();
      }
#endif // !VARIANT_S_FTR_ENABLE_DEEP_COPY
      oIn >> u32Length;
      RoadNameList.resize(u32Length);
      for (u32Idx = 0; u32Idx < u32Length; ++u32Idx)
      {
         oIn >> RoadNameList[u32Idx];
      }
   }
   return oIn;
}

fi_tclOutContext& fi_tcl_RoadNameElementList::oWrite(fi_tclOutContext& oOut) const
{
   oOut << (tU32)RoadNameList.size();
   {
      for (tU32 u32Idx = 0; u32Idx < RoadNameList.size(); ++u32Idx)
         oOut << RoadNameList[u32Idx];
   }
   return oOut;
}

tU32 fi_tcl_b8_RoadNumberStatus::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 1;
}

tBool fi_tcl_b8_RoadNumberStatus::operator==(const fi_tcl_b8_RoadNumberStatus& rfoCmp) const
{
   return u8Value == rfoCmp.u8Value;
}

fi_tclInContext& fi_tcl_b8_RoadNumberStatus::oRead(fi_tclInContext& oIn)
{
   return oIn >> u8Value;
}

fi_tclOutContext& fi_tcl_b8_RoadNumberStatus::oWrite(fi_tclOutContext& oOut) const
{
   return oOut << u8Value;
}

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
fi_tcl_RequiredTaxDisc::fi_tcl_RequiredTaxDisc(const fi_tcl_RequiredTaxDisc& coRef):fi_tclVisitableTypeBase(coRef)
{
   RequiredPermissionID = coRef.RequiredPermissionID;
   CountryCode = coRef.CountryCode;
   Region = coRef.Region;
   RequiredPermissionName = coRef.RequiredPermissionName;
   Description = coRef.Description;
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
fi_tcl_RequiredTaxDisc& fi_tcl_RequiredTaxDisc::operator=(const fi_tcl_RequiredTaxDisc& coRef)
{
   if (this == &coRef) return *this;
   RequiredPermissionID = coRef.RequiredPermissionID;
   CountryCode = coRef.CountryCode;
   Region = coRef.Region;
   RequiredPermissionName = coRef.RequiredPermissionName;
   Description = coRef.Description;
   return *this;
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
tVoid fi_tcl_RequiredTaxDisc::vDestroy()
{
   RequiredPermissionName.vDestroy();
   Description.vDestroy();
}

tU32 fi_tcl_RequiredTaxDisc::u32GetSize(tU16 u16MajorVersion) const
{
   tU32 u32DynamicSize = 0;
   if (9 <= u16MajorVersion)
   {
      u32DynamicSize += 2;
   }
   return u32DynamicSize+6+RequiredPermissionName.u32GetSize(u16MajorVersion)+Description.u32GetSize(u16MajorVersion);
}

tBool fi_tcl_RequiredTaxDisc::operator==(const fi_tcl_RequiredTaxDisc& rfoCmp) const
{
   tBool bResult = true;
      bResult = bResult && (RequiredPermissionID == rfoCmp.RequiredPermissionID);
      bResult = bResult && (CountryCode == rfoCmp.CountryCode);
      bResult = bResult && (Region == rfoCmp.Region);
      bResult = bResult && (RequiredPermissionName == rfoCmp.RequiredPermissionName);
      bResult = bResult && (Description == rfoCmp.Description);
   return bResult;
}

fi_tclInContext& fi_tcl_RequiredTaxDisc::oRead(fi_tclInContext& oIn)
{
   oIn >> RequiredPermissionID;
   oIn >> CountryCode;
   if (9 <= oIn.u16GetMajorVersion())
   {
      oIn >> Region;
   }
   oIn >> RequiredPermissionName;
   oIn >> Description;
   return oIn;
}

fi_tclOutContext& fi_tcl_RequiredTaxDisc::oWrite(fi_tclOutContext& oOut) const
{
   oOut << RequiredPermissionID;
   oOut << CountryCode;
   if (9 <= oOut.u16GetMajorVersion())
   {
      oOut << Region;
   }
   oOut << RequiredPermissionName;
   oOut << Description;
   return oOut;
}

tU32 fi_tcl_e8_RequiredPermissionType::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 1;
}

tBool fi_tcl_e8_RequiredPermissionType::operator==(const fi_tcl_e8_RequiredPermissionType& rfoCmp) const
{
   return enType == rfoCmp.enType;
}

fi_tclInContext& fi_tcl_e8_RequiredPermissionType::oRead(fi_tclInContext& oIn)
{
   tU8 u8Value;
   oIn >> u8Value;
   enType = (tenType)u8Value;
   return oIn;
}

fi_tclOutContext& fi_tcl_e8_RequiredPermissionType::oWrite(fi_tclOutContext& oOut) const
{
   return oOut.oWrite((tU8)enType);
}

tU32 fi_tcl_e8_RequiredPermission::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 1;
}

tBool fi_tcl_e8_RequiredPermission::operator==(const fi_tcl_e8_RequiredPermission& rfoCmp) const
{
   return enType == rfoCmp.enType;
}

fi_tclInContext& fi_tcl_e8_RequiredPermission::oRead(fi_tclInContext& oIn)
{
   tU8 u8Value;
   oIn >> u8Value;
   enType = (tenType)u8Value;
   return oIn;
}

fi_tclOutContext& fi_tcl_e8_RequiredPermission::oWrite(fi_tclOutContext& oOut) const
{
   fi_tcl_e8_RequiredPermission::tenType enData = enType;
   if ((enData == FI_EN_T_GENERICREQUIREDPERMISSION) && !(13 <= oOut.u16GetMajorVersion()))
   {
      enData = FI_EN_T_RESERVED;
   }
   if ((enData == FI_EN_T_REQUIREDTAXDISC) && !(oOut.u16GetMajorVersion() <= 12))
   {
      enData = FI_EN_T_RESERVED;
   }
   return oOut.oWrite((tU8)enData);
}

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
fi_tcl_GenericRequiredPermission::fi_tcl_GenericRequiredPermission(const fi_tcl_GenericRequiredPermission& coRef):fi_tclVisitableTypeBase(coRef)
{
   RequiredPermissionID = coRef.RequiredPermissionID;
   CountryCode = coRef.CountryCode;
   RegionId = coRef.RegionId;
   RequiredPermissionName = coRef.RequiredPermissionName;
   Description = coRef.Description;
   RequiredPermissionType = coRef.RequiredPermissionType;
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
fi_tcl_GenericRequiredPermission& fi_tcl_GenericRequiredPermission::operator=(const fi_tcl_GenericRequiredPermission& coRef)
{
   if (this == &coRef) return *this;
   RequiredPermissionID = coRef.RequiredPermissionID;
   CountryCode = coRef.CountryCode;
   RegionId = coRef.RegionId;
   RequiredPermissionName = coRef.RequiredPermissionName;
   Description = coRef.Description;
   RequiredPermissionType = coRef.RequiredPermissionType;
   return *this;
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
tVoid fi_tcl_GenericRequiredPermission::vDestroy()
{
   RequiredPermissionName.vDestroy();
   Description.vDestroy();
}

tU32 fi_tcl_GenericRequiredPermission::u32GetSize(tU16 u16MajorVersion) const
{
   return 9+RequiredPermissionName.u32GetSize(u16MajorVersion)+Description.u32GetSize(u16MajorVersion);
}

tBool fi_tcl_GenericRequiredPermission::operator==(const fi_tcl_GenericRequiredPermission& rfoCmp) const
{
   tBool bResult = true;
      bResult = bResult && (RequiredPermissionID == rfoCmp.RequiredPermissionID);
      bResult = bResult && (CountryCode == rfoCmp.CountryCode);
      bResult = bResult && (RegionId == rfoCmp.RegionId);
      bResult = bResult && (RequiredPermissionName == rfoCmp.RequiredPermissionName);
      bResult = bResult && (Description == rfoCmp.Description);
      bResult = bResult && (RequiredPermissionType == rfoCmp.RequiredPermissionType);
   return bResult;
}

fi_tclInContext& fi_tcl_GenericRequiredPermission::oRead(fi_tclInContext& oIn)
{
   oIn >> RequiredPermissionID;
   oIn >> CountryCode;
   oIn >> RegionId;
   oIn >> RequiredPermissionName;
   oIn >> Description;
   oIn >> RequiredPermissionType;
   return oIn;
}

fi_tclOutContext& fi_tcl_GenericRequiredPermission::oWrite(fi_tclOutContext& oOut) const
{
   oOut << RequiredPermissionID;
   oOut << CountryCode;
   oOut << RegionId;
   oOut << RequiredPermissionName;
   oOut << Description;
   oOut << RequiredPermissionType;
   return oOut;
}

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
fi_tcl_RequiredPermission::fi_tcl_RequiredPermission(const fi_tcl_RequiredPermission& coRef):fi_tclVisitableTypeBase(coRef)
{
   CategoryType = coRef.CategoryType;
   if  (coRef.poCategoryData)
   {
      switch(CategoryType.enType)
      {
      case fi_tcl_e8_RequiredPermission::FI_EN_T_RESERVED:
         poCategoryData = OSAL_NEW fi_tcl_Reserved((const fi_tcl_Reserved&)*coRef.poCategoryData);
         break;
      case fi_tcl_e8_RequiredPermission::FI_EN_T_REQUIREDTAXDISC:
         poCategoryData = OSAL_NEW fi_tcl_RequiredTaxDisc((const fi_tcl_RequiredTaxDisc&)*coRef.poCategoryData);
         break;
      case fi_tcl_e8_RequiredPermission::FI_EN_T_GENERICREQUIREDPERMISSION:
         poCategoryData = OSAL_NEW fi_tcl_GenericRequiredPermission((const fi_tcl_GenericRequiredPermission&)*coRef.poCategoryData);
         break;
      default:
         poCategoryData = OSAL_NULL;
      }
   }
   else
   {
      poCategoryData = OSAL_NULL;
   }
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
fi_tcl_RequiredPermission& fi_tcl_RequiredPermission::operator=(const fi_tcl_RequiredPermission& coRef)
{
   if (this == &coRef) return *this;
   OSAL_DELETE poCategoryData;
   CategoryType = coRef.CategoryType;
   if  (coRef.poCategoryData)
   {
      switch(CategoryType.enType)
      {
      case fi_tcl_e8_RequiredPermission::FI_EN_T_RESERVED:
         poCategoryData = OSAL_NEW fi_tcl_Reserved((const fi_tcl_Reserved&)*coRef.poCategoryData);
         break;
      case fi_tcl_e8_RequiredPermission::FI_EN_T_REQUIREDTAXDISC:
         poCategoryData = OSAL_NEW fi_tcl_RequiredTaxDisc((const fi_tcl_RequiredTaxDisc&)*coRef.poCategoryData);
         break;
      case fi_tcl_e8_RequiredPermission::FI_EN_T_GENERICREQUIREDPERMISSION:
         poCategoryData = OSAL_NEW fi_tcl_GenericRequiredPermission((const fi_tcl_GenericRequiredPermission&)*coRef.poCategoryData);
         break;
      default:
         poCategoryData = OSAL_NULL;
      }
   }
   else
   {
      poCategoryData = OSAL_NULL;
   }
   return *this;
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
fi_tcl_RequiredPermission::~fi_tcl_RequiredPermission()
{
   OSAL_DELETE poCategoryData;
   poCategoryData = OSAL_NULL;
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
tVoid fi_tcl_RequiredPermission::vDestroy()
{
   if (poCategoryData)
   {
      poCategoryData->vDestroy();
      OSAL_DELETE poCategoryData;
      poCategoryData = OSAL_NULL;
   }
}

tU32 fi_tcl_RequiredPermission::u32GetSize(tU16 u16MajorVersion) const
{
   tU32 u32DynamicSize = 0;
   if (CategoryType.enType == fi_tcl_e8_RequiredPermission::FI_EN_T_RESERVED)
      u32DynamicSize += (poCategoryData?poCategoryData->u32GetSize(u16MajorVersion):0);
   if ((CategoryType.enType == fi_tcl_e8_RequiredPermission::FI_EN_T_REQUIREDTAXDISC) &&
       (u16MajorVersion <= 12))
      u32DynamicSize += (poCategoryData?poCategoryData->u32GetSize(u16MajorVersion):0);
   if ((CategoryType.enType == fi_tcl_e8_RequiredPermission::FI_EN_T_GENERICREQUIREDPERMISSION) &&
       (13 <= u16MajorVersion))
      u32DynamicSize += (poCategoryData?poCategoryData->u32GetSize(u16MajorVersion):0);
   return u32DynamicSize+1;
}

tBool fi_tcl_RequiredPermission::operator==(const fi_tcl_RequiredPermission& rfoCmp) const
{
   tBool bResult = true;
   bResult = bResult && (CategoryType == rfoCmp.CategoryType);
   if (bResult && poCategoryData && rfoCmp.poCategoryData) 
   {
      switch (CategoryType.enType)
      {
      case fi_tcl_e8_RequiredPermission::FI_EN_T_RESERVED:
         bResult = bResult && (*(const fi_tcl_Reserved*)poCategoryData == *(const fi_tcl_Reserved*)rfoCmp.poCategoryData); //lint !e826
      break;
      case fi_tcl_e8_RequiredPermission::FI_EN_T_REQUIREDTAXDISC:
         bResult = bResult && (*(const fi_tcl_RequiredTaxDisc*)poCategoryData == *(const fi_tcl_RequiredTaxDisc*)rfoCmp.poCategoryData); //lint !e826
      break;
      case fi_tcl_e8_RequiredPermission::FI_EN_T_GENERICREQUIREDPERMISSION:
         bResult = bResult && (*(const fi_tcl_GenericRequiredPermission*)poCategoryData == *(const fi_tcl_GenericRequiredPermission*)rfoCmp.poCategoryData); //lint !e826
      break;
      }
   }
   else
   {
      bResult = bResult && (poCategoryData == rfoCmp.poCategoryData);
   }
   return bResult;
}

fi_tclInContext& fi_tcl_RequiredPermission::oRead(fi_tclInContext& oIn)
{
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   OSAL_DELETE poCategoryData;
#else
   if (poCategoryData)
   {
      poCategoryData->vDestroy();
      OSAL_DELETE poCategoryData;
   }
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
   oIn >> CategoryType;
   switch(CategoryType.enType)
   {
   case fi_tcl_e8_RequiredPermission::FI_EN_T_RESERVED:
      poCategoryData = OSAL_NEW fi_tcl_Reserved;
      break;
   case fi_tcl_e8_RequiredPermission::FI_EN_T_REQUIREDTAXDISC:
      poCategoryData = OSAL_NEW fi_tcl_RequiredTaxDisc;
      break;
   case fi_tcl_e8_RequiredPermission::FI_EN_T_GENERICREQUIREDPERMISSION:
      poCategoryData = OSAL_NEW fi_tcl_GenericRequiredPermission;
      break;
   default:
      oIn.Invalidate();
      poCategoryData = OSAL_NULL;
   }
   if (poCategoryData && oIn.bIsValid())
      poCategoryData->oRead(oIn);
   else
      oIn.Invalidate();
   return oIn;
}

fi_tclOutContext& fi_tcl_RequiredPermission::oWrite(fi_tclOutContext& oOut) const
{
   oOut << CategoryType;
   if (poCategoryData)
   {
      if (CategoryType.enType == fi_tcl_e8_RequiredPermission::FI_EN_T_RESERVED)
      {
         poCategoryData->oWrite(oOut);
      }
      if (CategoryType.enType == fi_tcl_e8_RequiredPermission::FI_EN_T_REQUIREDTAXDISC)
      {
         if (!(oOut.u16GetMajorVersion() <= 12))
         {
            fi_tcl_Reserved oDefault;
            oOut << oDefault;
         }
         else
         {
            poCategoryData->oWrite(oOut);
         }
      }
      if (CategoryType.enType == fi_tcl_e8_RequiredPermission::FI_EN_T_GENERICREQUIREDPERMISSION)
      {
         if (!(13 <= oOut.u16GetMajorVersion()))
         {
            fi_tcl_Reserved oDefault;
            oOut << oDefault;
         }
         else
         {
            poCategoryData->oWrite(oOut);
         }
      }
   }
   else
   {
      oOut.Invalidate();
   }
   return oOut;
}

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
fi_tcl_RequiredPermissionList::fi_tcl_RequiredPermissionList(const fi_tcl_RequiredPermissionList& coRef):fi_tclVisitableTypeBase(coRef)
{
   RequiredPermissionList = coRef.RequiredPermissionList;
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
fi_tcl_RequiredPermissionList& fi_tcl_RequiredPermissionList::operator=(const fi_tcl_RequiredPermissionList& coRef)
{
   if (this == &coRef) return *this;
   RequiredPermissionList = coRef.RequiredPermissionList;
   return *this;
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
tVoid fi_tcl_RequiredPermissionList::vDestroy()
{
   {
      for (tU32 u32Idx = 0; u32Idx < RequiredPermissionList.size(); ++u32Idx)
         RequiredPermissionList[u32Idx].vDestroy();
   }
   RequiredPermissionList.clear();
}

tU32 fi_tcl_RequiredPermissionList::u32GetSize(tU16 u16MajorVersion) const
{
   tU32 u32DynamicSize = 0;
   tU32 u32ListIdx;
   for (u32ListIdx = 0; u32ListIdx < RequiredPermissionList.size(); ++u32ListIdx)
      u32DynamicSize += RequiredPermissionList[u32ListIdx].u32GetSize(u16MajorVersion);
   return u32DynamicSize+4;
}

tBool fi_tcl_RequiredPermissionList::operator==(const fi_tcl_RequiredPermissionList& rfoCmp) const
{
   tBool bResult = true;
      bResult = bResult && (RequiredPermissionList.size() == rfoCmp.RequiredPermissionList.size());
      if (bResult)
      {
         for (tU32 u32Idx = 0; bResult && (u32Idx < RequiredPermissionList.size()); ++u32Idx)
            bResult = bResult && (RequiredPermissionList[u32Idx] == rfoCmp.RequiredPermissionList[u32Idx]);
      }
   return bResult;
}

fi_tclInContext& fi_tcl_RequiredPermissionList::oRead(fi_tclInContext& oIn)
{
   {
      tU32 u32Length;
      tU32 u32Idx;
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
      for (u32Idx = 0; u32Idx < RequiredPermissionList.size(); ++u32Idx)
      {
         RequiredPermissionList[u32Idx].vDestroy();
      }
#endif // !VARIANT_S_FTR_ENABLE_DEEP_COPY
      oIn >> u32Length;
      RequiredPermissionList.resize(u32Length);
      for (u32Idx = 0; u32Idx < u32Length; ++u32Idx)
      {
         oIn >> RequiredPermissionList[u32Idx];
      }
   }
   return oIn;
}

fi_tclOutContext& fi_tcl_RequiredPermissionList::oWrite(fi_tclOutContext& oOut) const
{
   oOut << (tU32)RequiredPermissionList.size();
   {
      for (tU32 u32Idx = 0; u32Idx < RequiredPermissionList.size(); ++u32Idx)
         oOut << RequiredPermissionList[u32Idx];
   }
   return oOut;
}

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
fi_tcl_CountryNameElement::fi_tcl_CountryNameElement(const fi_tcl_CountryNameElement& coRef):fi_tclVisitableTypeBase(coRef)
{
   Code = coRef.Code;
   Name = coRef.Name;
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
fi_tcl_CountryNameElement& fi_tcl_CountryNameElement::operator=(const fi_tcl_CountryNameElement& coRef)
{
   if (this == &coRef) return *this;
   Code = coRef.Code;
   Name = coRef.Name;
   return *this;
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
tVoid fi_tcl_CountryNameElement::vDestroy()
{
   Name.vDestroy();
}

tU32 fi_tcl_CountryNameElement::u32GetSize(tU16 u16MajorVersion) const
{
   return 2+Name.u32GetSize(u16MajorVersion);
}

tBool fi_tcl_CountryNameElement::operator==(const fi_tcl_CountryNameElement& rfoCmp) const
{
   tBool bResult = true;
      bResult = bResult && (Code == rfoCmp.Code);
      bResult = bResult && (Name == rfoCmp.Name);
   return bResult;
}

fi_tclInContext& fi_tcl_CountryNameElement::oRead(fi_tclInContext& oIn)
{
   oIn >> Code;
   oIn >> Name;
   return oIn;
}

fi_tclOutContext& fi_tcl_CountryNameElement::oWrite(fi_tclOutContext& oOut) const
{
   oOut << Code;
   oOut << Name;
   return oOut;
}

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
fi_tcl_StateNameListSet::fi_tcl_StateNameListSet(const fi_tcl_StateNameListSet& coRef):fi_tclVisitableTypeBase(coRef)
{
   ElementRefList = coRef.ElementRefList;
   StateNameRefList = coRef.StateNameRefList;
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
fi_tcl_StateNameListSet& fi_tcl_StateNameListSet::operator=(const fi_tcl_StateNameListSet& coRef)
{
   if (this == &coRef) return *this;
   ElementRefList = coRef.ElementRefList;
   StateNameRefList = coRef.StateNameRefList;
   return *this;
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
tVoid fi_tcl_StateNameListSet::vDestroy()
{
   ElementRefList.clear();
   {
      for (tU32 u32Idx = 0; u32Idx < StateNameRefList.size(); ++u32Idx)
         StateNameRefList[u32Idx].vDestroy();
   }
   StateNameRefList.clear();
}

tU32 fi_tcl_StateNameListSet::u32GetSize(tU16 u16MajorVersion) const
{
   tU32 u32DynamicSize = 0;
   tU32 u32ListIdx;
   for (u32ListIdx = 0; u32ListIdx < StateNameRefList.size(); ++u32ListIdx)
      u32DynamicSize += StateNameRefList[u32ListIdx].u32GetSize(u16MajorVersion);
   return u32DynamicSize+8+ElementRefList.size()*2;
}

tBool fi_tcl_StateNameListSet::operator==(const fi_tcl_StateNameListSet& rfoCmp) const
{
   tBool bResult = true;
      bResult = bResult && (ElementRefList.size() == rfoCmp.ElementRefList.size());
      if (bResult)
      {
         for (tU32 u32Idx = 0; bResult && (u32Idx < ElementRefList.size()); ++u32Idx)
            bResult = bResult && (ElementRefList[u32Idx] == rfoCmp.ElementRefList[u32Idx]);
      }
      bResult = bResult && (StateNameRefList.size() == rfoCmp.StateNameRefList.size());
      if (bResult)
      {
         for (tU32 u32Idx = 0; bResult && (u32Idx < StateNameRefList.size()); ++u32Idx)
            bResult = bResult && (StateNameRefList[u32Idx] == rfoCmp.StateNameRefList[u32Idx]);
      }
   return bResult;
}

fi_tclInContext& fi_tcl_StateNameListSet::oRead(fi_tclInContext& oIn)
{
   {
      tU32 u32Length;
      tU32 u32Idx;
      oIn >> u32Length;
      ElementRefList.resize(u32Length);
      for (u32Idx = 0; u32Idx < u32Length; ++u32Idx)
      {
         oIn >> ElementRefList[u32Idx];
      }
   }
   {
      tU32 u32Length;
      tU32 u32Idx;
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
      for (u32Idx = 0; u32Idx < StateNameRefList.size(); ++u32Idx)
      {
         StateNameRefList[u32Idx].vDestroy();
      }
#endif // !VARIANT_S_FTR_ENABLE_DEEP_COPY
      oIn >> u32Length;
      StateNameRefList.resize(u32Length);
      for (u32Idx = 0; u32Idx < u32Length; ++u32Idx)
      {
         oIn >> StateNameRefList[u32Idx];
      }
   }
   return oIn;
}

fi_tclOutContext& fi_tcl_StateNameListSet::oWrite(fi_tclOutContext& oOut) const
{
   oOut << (tU32)ElementRefList.size();
   {
      for (tU32 u32Idx = 0; u32Idx < ElementRefList.size(); ++u32Idx)
         oOut << ElementRefList[u32Idx];
   }
   oOut << (tU32)StateNameRefList.size();
   {
      for (tU32 u32Idx = 0; u32Idx < StateNameRefList.size(); ++u32Idx)
         oOut << StateNameRefList[u32Idx];
   }
   return oOut;
}

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
fi_tcl_CountyNameListSet::fi_tcl_CountyNameListSet(const fi_tcl_CountyNameListSet& coRef):fi_tclVisitableTypeBase(coRef)
{
   ElementRefList = coRef.ElementRefList;
   CountyNameRefList = coRef.CountyNameRefList;
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
fi_tcl_CountyNameListSet& fi_tcl_CountyNameListSet::operator=(const fi_tcl_CountyNameListSet& coRef)
{
   if (this == &coRef) return *this;
   ElementRefList = coRef.ElementRefList;
   CountyNameRefList = coRef.CountyNameRefList;
   return *this;
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
tVoid fi_tcl_CountyNameListSet::vDestroy()
{
   ElementRefList.clear();
   {
      for (tU32 u32Idx = 0; u32Idx < CountyNameRefList.size(); ++u32Idx)
         CountyNameRefList[u32Idx].vDestroy();
   }
   CountyNameRefList.clear();
}

tU32 fi_tcl_CountyNameListSet::u32GetSize(tU16 u16MajorVersion) const
{
   tU32 u32DynamicSize = 0;
   tU32 u32ListIdx;
   for (u32ListIdx = 0; u32ListIdx < CountyNameRefList.size(); ++u32ListIdx)
      u32DynamicSize += CountyNameRefList[u32ListIdx].u32GetSize(u16MajorVersion);
   return u32DynamicSize+8+ElementRefList.size()*2;
}

tBool fi_tcl_CountyNameListSet::operator==(const fi_tcl_CountyNameListSet& rfoCmp) const
{
   tBool bResult = true;
      bResult = bResult && (ElementRefList.size() == rfoCmp.ElementRefList.size());
      if (bResult)
      {
         for (tU32 u32Idx = 0; bResult && (u32Idx < ElementRefList.size()); ++u32Idx)
            bResult = bResult && (ElementRefList[u32Idx] == rfoCmp.ElementRefList[u32Idx]);
      }
      bResult = bResult && (CountyNameRefList.size() == rfoCmp.CountyNameRefList.size());
      if (bResult)
      {
         for (tU32 u32Idx = 0; bResult && (u32Idx < CountyNameRefList.size()); ++u32Idx)
            bResult = bResult && (CountyNameRefList[u32Idx] == rfoCmp.CountyNameRefList[u32Idx]);
      }
   return bResult;
}

fi_tclInContext& fi_tcl_CountyNameListSet::oRead(fi_tclInContext& oIn)
{
   {
      tU32 u32Length;
      tU32 u32Idx;
      oIn >> u32Length;
      ElementRefList.resize(u32Length);
      for (u32Idx = 0; u32Idx < u32Length; ++u32Idx)
      {
         oIn >> ElementRefList[u32Idx];
      }
   }
   {
      tU32 u32Length;
      tU32 u32Idx;
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
      for (u32Idx = 0; u32Idx < CountyNameRefList.size(); ++u32Idx)
      {
         CountyNameRefList[u32Idx].vDestroy();
      }
#endif // !VARIANT_S_FTR_ENABLE_DEEP_COPY
      oIn >> u32Length;
      CountyNameRefList.resize(u32Length);
      for (u32Idx = 0; u32Idx < u32Length; ++u32Idx)
      {
         oIn >> CountyNameRefList[u32Idx];
      }
   }
   return oIn;
}

fi_tclOutContext& fi_tcl_CountyNameListSet::oWrite(fi_tclOutContext& oOut) const
{
   oOut << (tU32)ElementRefList.size();
   {
      for (tU32 u32Idx = 0; u32Idx < ElementRefList.size(); ++u32Idx)
         oOut << ElementRefList[u32Idx];
   }
   oOut << (tU32)CountyNameRefList.size();
   {
      for (tU32 u32Idx = 0; u32Idx < CountyNameRefList.size(); ++u32Idx)
         oOut << CountyNameRefList[u32Idx];
   }
   return oOut;
}

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
fi_tcl_CityNameElement::fi_tcl_CityNameElement(const fi_tcl_CityNameElement& coRef):fi_tclVisitableTypeBase(coRef)
{
   Name = coRef.Name;
   Priority = coRef.Priority;
   Population = coRef.Population;
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
fi_tcl_CityNameElement& fi_tcl_CityNameElement::operator=(const fi_tcl_CityNameElement& coRef)
{
   if (this == &coRef) return *this;
   Name = coRef.Name;
   Priority = coRef.Priority;
   Population = coRef.Population;
   return *this;
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
tVoid fi_tcl_CityNameElement::vDestroy()
{
   Name.vDestroy();
}

tU32 fi_tcl_CityNameElement::u32GetSize(tU16 u16MajorVersion) const
{
   return 5+Name.u32GetSize(u16MajorVersion);
}

tBool fi_tcl_CityNameElement::operator==(const fi_tcl_CityNameElement& rfoCmp) const
{
   tBool bResult = true;
      bResult = bResult && (Name == rfoCmp.Name);
      bResult = bResult && (Priority == rfoCmp.Priority);
      bResult = bResult && (Population == rfoCmp.Population);
   return bResult;
}

fi_tclInContext& fi_tcl_CityNameElement::oRead(fi_tclInContext& oIn)
{
   oIn >> Name;
   oIn >> Priority;
   oIn >> Population;
   return oIn;
}

fi_tclOutContext& fi_tcl_CityNameElement::oWrite(fi_tclOutContext& oOut) const
{
   oOut << Name;
   oOut << Priority;
   oOut << Population;
   return oOut;
}

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
fi_tcl_IndexInReferenceList::fi_tcl_IndexInReferenceList(const fi_tcl_IndexInReferenceList& coRef):fi_tclVisitableTypeBase(coRef)
{
   RefElement = coRef.RefElement;
   DescriptionOnNextNode = coRef.DescriptionOnNextNode;
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
fi_tcl_IndexInReferenceList& fi_tcl_IndexInReferenceList::operator=(const fi_tcl_IndexInReferenceList& coRef)
{
   if (this == &coRef) return *this;
   RefElement = coRef.RefElement;
   DescriptionOnNextNode = coRef.DescriptionOnNextNode;
   return *this;
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
tU32 fi_tcl_IndexInReferenceList::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 3;
}

tBool fi_tcl_IndexInReferenceList::operator==(const fi_tcl_IndexInReferenceList& rfoCmp) const
{
   tBool bResult = true;
      bResult = bResult && (RefElement == rfoCmp.RefElement);
      bResult = bResult && (DescriptionOnNextNode == rfoCmp.DescriptionOnNextNode);
   return bResult;
}

fi_tclInContext& fi_tcl_IndexInReferenceList::oRead(fi_tclInContext& oIn)
{
   oIn >> RefElement;
   oIn >> DescriptionOnNextNode;
   return oIn;
}

fi_tclOutContext& fi_tcl_IndexInReferenceList::oWrite(fi_tclOutContext& oOut) const
{
   oOut << RefElement;
   oOut << DescriptionOnNextNode;
   return oOut;
}

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
fi_tcl_BuildUpAreaNameListSet::fi_tcl_BuildUpAreaNameListSet(const fi_tcl_BuildUpAreaNameListSet& coRef):fi_tclVisitableTypeBase(coRef)
{
   ElementInRefList = coRef.ElementInRefList;
   BuildUpAreaNameRefList = coRef.BuildUpAreaNameRefList;
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
fi_tcl_BuildUpAreaNameListSet& fi_tcl_BuildUpAreaNameListSet::operator=(const fi_tcl_BuildUpAreaNameListSet& coRef)
{
   if (this == &coRef) return *this;
   ElementInRefList = coRef.ElementInRefList;
   BuildUpAreaNameRefList = coRef.BuildUpAreaNameRefList;
   return *this;
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
tVoid fi_tcl_BuildUpAreaNameListSet::vDestroy()
{
   {
      for (tU32 u32Idx = 0; u32Idx < ElementInRefList.size(); ++u32Idx)
         ElementInRefList[u32Idx].vDestroy();
   }
   ElementInRefList.clear();
   {
      for (tU32 u32Idx = 0; u32Idx < BuildUpAreaNameRefList.size(); ++u32Idx)
         BuildUpAreaNameRefList[u32Idx].vDestroy();
   }
   BuildUpAreaNameRefList.clear();
}

tU32 fi_tcl_BuildUpAreaNameListSet::u32GetSize(tU16 u16MajorVersion) const
{
   tU32 u32DynamicSize = 0;
   tU32 u32ListIdx;
   for (u32ListIdx = 0; u32ListIdx < BuildUpAreaNameRefList.size(); ++u32ListIdx)
      u32DynamicSize += BuildUpAreaNameRefList[u32ListIdx].u32GetSize(u16MajorVersion);
   return u32DynamicSize+8+ElementInRefList.size()*3;
}

tBool fi_tcl_BuildUpAreaNameListSet::operator==(const fi_tcl_BuildUpAreaNameListSet& rfoCmp) const
{
   tBool bResult = true;
      bResult = bResult && (ElementInRefList.size() == rfoCmp.ElementInRefList.size());
      if (bResult)
      {
         for (tU32 u32Idx = 0; bResult && (u32Idx < ElementInRefList.size()); ++u32Idx)
            bResult = bResult && (ElementInRefList[u32Idx] == rfoCmp.ElementInRefList[u32Idx]);
      }
      bResult = bResult && (BuildUpAreaNameRefList.size() == rfoCmp.BuildUpAreaNameRefList.size());
      if (bResult)
      {
         for (tU32 u32Idx = 0; bResult && (u32Idx < BuildUpAreaNameRefList.size()); ++u32Idx)
            bResult = bResult && (BuildUpAreaNameRefList[u32Idx] == rfoCmp.BuildUpAreaNameRefList[u32Idx]);
      }
   return bResult;
}

fi_tclInContext& fi_tcl_BuildUpAreaNameListSet::oRead(fi_tclInContext& oIn)
{
   {
      tU32 u32Length;
      tU32 u32Idx;
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
      for (u32Idx = 0; u32Idx < ElementInRefList.size(); ++u32Idx)
      {
         ElementInRefList[u32Idx].vDestroy();
      }
#endif // !VARIANT_S_FTR_ENABLE_DEEP_COPY
      oIn >> u32Length;
      ElementInRefList.resize(u32Length);
      for (u32Idx = 0; u32Idx < u32Length; ++u32Idx)
      {
         oIn >> ElementInRefList[u32Idx];
      }
   }
   {
      tU32 u32Length;
      tU32 u32Idx;
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
      for (u32Idx = 0; u32Idx < BuildUpAreaNameRefList.size(); ++u32Idx)
      {
         BuildUpAreaNameRefList[u32Idx].vDestroy();
      }
#endif // !VARIANT_S_FTR_ENABLE_DEEP_COPY
      oIn >> u32Length;
      BuildUpAreaNameRefList.resize(u32Length);
      for (u32Idx = 0; u32Idx < u32Length; ++u32Idx)
      {
         oIn >> BuildUpAreaNameRefList[u32Idx];
      }
   }
   return oIn;
}

fi_tclOutContext& fi_tcl_BuildUpAreaNameListSet::oWrite(fi_tclOutContext& oOut) const
{
   oOut << (tU32)ElementInRefList.size();
   {
      for (tU32 u32Idx = 0; u32Idx < ElementInRefList.size(); ++u32Idx)
         oOut << ElementInRefList[u32Idx];
   }
   oOut << (tU32)BuildUpAreaNameRefList.size();
   {
      for (tU32 u32Idx = 0; u32Idx < BuildUpAreaNameRefList.size(); ++u32Idx)
         oOut << BuildUpAreaNameRefList[u32Idx];
   }
   return oOut;
}

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
fi_tcl_RoadNameListSet::fi_tcl_RoadNameListSet(const fi_tcl_RoadNameListSet& coRef):fi_tclVisitableTypeBase(coRef)
{
   ElementRefList = coRef.ElementRefList;
   AlternativRefList = coRef.AlternativRefList;
   RoadNameRefList = coRef.RoadNameRefList;
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
fi_tcl_RoadNameListSet& fi_tcl_RoadNameListSet::operator=(const fi_tcl_RoadNameListSet& coRef)
{
   if (this == &coRef) return *this;
   ElementRefList = coRef.ElementRefList;
   AlternativRefList = coRef.AlternativRefList;
   RoadNameRefList = coRef.RoadNameRefList;
   return *this;
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
tVoid fi_tcl_RoadNameListSet::vDestroy()
{
   ElementRefList.clear();
   {
      for (tU32 u32Idx = 0; u32Idx < AlternativRefList.size(); ++u32Idx)
         AlternativRefList[u32Idx].vDestroy();
   }
   AlternativRefList.clear();
   {
      for (tU32 u32Idx = 0; u32Idx < RoadNameRefList.size(); ++u32Idx)
         RoadNameRefList[u32Idx].vDestroy();
   }
   RoadNameRefList.clear();
}

tU32 fi_tcl_RoadNameListSet::u32GetSize(tU16 u16MajorVersion) const
{
   tU32 u32DynamicSize = 0;
   tU32 u32ListIdx;
   for (u32ListIdx = 0; u32ListIdx < RoadNameRefList.size(); ++u32ListIdx)
      u32DynamicSize += RoadNameRefList[u32ListIdx].u32GetSize(u16MajorVersion);
   return u32DynamicSize+12+ElementRefList.size()*2+AlternativRefList.size()*4;
}

tBool fi_tcl_RoadNameListSet::operator==(const fi_tcl_RoadNameListSet& rfoCmp) const
{
   tBool bResult = true;
      bResult = bResult && (ElementRefList.size() == rfoCmp.ElementRefList.size());
      if (bResult)
      {
         for (tU32 u32Idx = 0; bResult && (u32Idx < ElementRefList.size()); ++u32Idx)
            bResult = bResult && (ElementRefList[u32Idx] == rfoCmp.ElementRefList[u32Idx]);
      }
      bResult = bResult && (AlternativRefList.size() == rfoCmp.AlternativRefList.size());
      if (bResult)
      {
         for (tU32 u32Idx = 0; bResult && (u32Idx < AlternativRefList.size()); ++u32Idx)
            bResult = bResult && (AlternativRefList[u32Idx] == rfoCmp.AlternativRefList[u32Idx]);
      }
      bResult = bResult && (RoadNameRefList.size() == rfoCmp.RoadNameRefList.size());
      if (bResult)
      {
         for (tU32 u32Idx = 0; bResult && (u32Idx < RoadNameRefList.size()); ++u32Idx)
            bResult = bResult && (RoadNameRefList[u32Idx] == rfoCmp.RoadNameRefList[u32Idx]);
      }
   return bResult;
}

fi_tclInContext& fi_tcl_RoadNameListSet::oRead(fi_tclInContext& oIn)
{
   {
      tU32 u32Length;
      tU32 u32Idx;
      oIn >> u32Length;
      ElementRefList.resize(u32Length);
      for (u32Idx = 0; u32Idx < u32Length; ++u32Idx)
      {
         oIn >> ElementRefList[u32Idx];
      }
   }
   {
      tU32 u32Length;
      tU32 u32Idx;
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
      for (u32Idx = 0; u32Idx < AlternativRefList.size(); ++u32Idx)
      {
         AlternativRefList[u32Idx].vDestroy();
      }
#endif // !VARIANT_S_FTR_ENABLE_DEEP_COPY
      oIn >> u32Length;
      AlternativRefList.resize(u32Length);
      for (u32Idx = 0; u32Idx < u32Length; ++u32Idx)
      {
         oIn >> AlternativRefList[u32Idx];
      }
   }
   {
      tU32 u32Length;
      tU32 u32Idx;
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
      for (u32Idx = 0; u32Idx < RoadNameRefList.size(); ++u32Idx)
      {
         RoadNameRefList[u32Idx].vDestroy();
      }
#endif // !VARIANT_S_FTR_ENABLE_DEEP_COPY
      oIn >> u32Length;
      RoadNameRefList.resize(u32Length);
      for (u32Idx = 0; u32Idx < u32Length; ++u32Idx)
      {
         oIn >> RoadNameRefList[u32Idx];
      }
   }
   return oIn;
}

fi_tclOutContext& fi_tcl_RoadNameListSet::oWrite(fi_tclOutContext& oOut) const
{
   oOut << (tU32)ElementRefList.size();
   {
      for (tU32 u32Idx = 0; u32Idx < ElementRefList.size(); ++u32Idx)
         oOut << ElementRefList[u32Idx];
   }
   oOut << (tU32)AlternativRefList.size();
   {
      for (tU32 u32Idx = 0; u32Idx < AlternativRefList.size(); ++u32Idx)
         oOut << AlternativRefList[u32Idx];
   }
   oOut << (tU32)RoadNameRefList.size();
   {
      for (tU32 u32Idx = 0; u32Idx < RoadNameRefList.size(); ++u32Idx)
         oOut << RoadNameRefList[u32Idx];
   }
   return oOut;
}

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
fi_tcl_CompassDirection::fi_tcl_CompassDirection(const fi_tcl_CompassDirection& coRef):fi_tclVisitableTypeBase(coRef)
{
   DirectionIsValid = coRef.DirectionIsValid;
   Direction = coRef.Direction;
   DirectionDesc = coRef.DirectionDesc;
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
fi_tcl_CompassDirection& fi_tcl_CompassDirection::operator=(const fi_tcl_CompassDirection& coRef)
{
   if (this == &coRef) return *this;
   DirectionIsValid = coRef.DirectionIsValid;
   Direction = coRef.Direction;
   DirectionDesc = coRef.DirectionDesc;
   return *this;
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
tVoid fi_tcl_CompassDirection::vDestroy()
{
   DirectionDesc.vDestroy();
}

tU32 fi_tcl_CompassDirection::u32GetSize(tU16 u16MajorVersion) const
{
   tU32 u32DynamicSize = 0;
   if (u16MajorVersion <= 8)
   {
      u32DynamicSize += 1;
   }
   return u32DynamicSize+1+DirectionDesc.u32GetSize(u16MajorVersion);
}

tBool fi_tcl_CompassDirection::operator==(const fi_tcl_CompassDirection& rfoCmp) const
{
   tBool bResult = true;
      bResult = bResult && (DirectionIsValid == rfoCmp.DirectionIsValid);
      bResult = bResult && (Direction == rfoCmp.Direction);
      bResult = bResult && (DirectionDesc == rfoCmp.DirectionDesc);
   return bResult;
}

fi_tclInContext& fi_tcl_CompassDirection::oRead(fi_tclInContext& oIn)
{
   if (oIn.u16GetMajorVersion() <= 8)
   {
      oIn >> DirectionIsValid;
   }
   oIn >> Direction;
   oIn >> DirectionDesc;
   return oIn;
}

fi_tclOutContext& fi_tcl_CompassDirection::oWrite(fi_tclOutContext& oOut) const
{
   if (oOut.u16GetMajorVersion() <= 8)
   {
      oOut << DirectionIsValid;
   }
   oOut << Direction;
   oOut << DirectionDesc;
   return oOut;
}

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
fi_tcl_RequiredPermissionListSet::fi_tcl_RequiredPermissionListSet(const fi_tcl_RequiredPermissionListSet& coRef):fi_tclVisitableTypeBase(coRef)
{
   AlternativRefList = coRef.AlternativRefList;
   AlternativRefIDList = coRef.AlternativRefIDList;
   RequiredPermissionRefList = coRef.RequiredPermissionRefList;
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
fi_tcl_RequiredPermissionListSet& fi_tcl_RequiredPermissionListSet::operator=(const fi_tcl_RequiredPermissionListSet& coRef)
{
   if (this == &coRef) return *this;
   AlternativRefList = coRef.AlternativRefList;
   AlternativRefIDList = coRef.AlternativRefIDList;
   RequiredPermissionRefList = coRef.RequiredPermissionRefList;
   return *this;
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
tVoid fi_tcl_RequiredPermissionListSet::vDestroy()
{
   {
      for (tU32 u32Idx = 0; u32Idx < AlternativRefList.size(); ++u32Idx)
         AlternativRefList[u32Idx].vDestroy();
   }
   AlternativRefList.clear();
   {
      for (tU32 u32Idx = 0; u32Idx < AlternativRefIDList.size(); ++u32Idx)
         AlternativRefIDList[u32Idx].vDestroy();
   }
   AlternativRefIDList.clear();
   {
      for (tU32 u32Idx = 0; u32Idx < RequiredPermissionRefList.size(); ++u32Idx)
         RequiredPermissionRefList[u32Idx].vDestroy();
   }
   RequiredPermissionRefList.clear();
}

tU32 fi_tcl_RequiredPermissionListSet::u32GetSize(tU16 u16MajorVersion) const
{
   tU32 u32DynamicSize = 0;
   if (u16MajorVersion <= 10)
   {
      u32DynamicSize += 4;
      u32DynamicSize += AlternativRefList.size()*4;
   }
   if (11 <= u16MajorVersion)
   {
      u32DynamicSize += 4;
      u32DynamicSize += AlternativRefIDList.size()*8;
   }
   tU32 u32ListIdx;
   for (u32ListIdx = 0; u32ListIdx < RequiredPermissionRefList.size(); ++u32ListIdx)
      u32DynamicSize += RequiredPermissionRefList[u32ListIdx].u32GetSize(u16MajorVersion);
   return u32DynamicSize+4;
}

tBool fi_tcl_RequiredPermissionListSet::operator==(const fi_tcl_RequiredPermissionListSet& rfoCmp) const
{
   tBool bResult = true;
      bResult = bResult && (AlternativRefList.size() == rfoCmp.AlternativRefList.size());
      if (bResult)
      {
         for (tU32 u32Idx = 0; bResult && (u32Idx < AlternativRefList.size()); ++u32Idx)
            bResult = bResult && (AlternativRefList[u32Idx] == rfoCmp.AlternativRefList[u32Idx]);
      }
      bResult = bResult && (AlternativRefIDList.size() == rfoCmp.AlternativRefIDList.size());
      if (bResult)
      {
         for (tU32 u32Idx = 0; bResult && (u32Idx < AlternativRefIDList.size()); ++u32Idx)
            bResult = bResult && (AlternativRefIDList[u32Idx] == rfoCmp.AlternativRefIDList[u32Idx]);
      }
      bResult = bResult && (RequiredPermissionRefList.size() == rfoCmp.RequiredPermissionRefList.size());
      if (bResult)
      {
         for (tU32 u32Idx = 0; bResult && (u32Idx < RequiredPermissionRefList.size()); ++u32Idx)
            bResult = bResult && (RequiredPermissionRefList[u32Idx] == rfoCmp.RequiredPermissionRefList[u32Idx]);
      }
   return bResult;
}

fi_tclInContext& fi_tcl_RequiredPermissionListSet::oRead(fi_tclInContext& oIn)
{
   if (oIn.u16GetMajorVersion() <= 10)
   {
      {
         tU32 u32Length;
         tU32 u32Idx;
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
         for (u32Idx = 0; u32Idx < AlternativRefList.size(); ++u32Idx)
         {
            AlternativRefList[u32Idx].vDestroy();
         }
#endif // !VARIANT_S_FTR_ENABLE_DEEP_COPY
         oIn >> u32Length;
         AlternativRefList.resize(u32Length);
         for (u32Idx = 0; u32Idx < u32Length; ++u32Idx)
         {
            oIn >> AlternativRefList[u32Idx];
         }
      }
   }
   if (11 <= oIn.u16GetMajorVersion())
   {
      {
         tU32 u32Length;
         tU32 u32Idx;
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
         for (u32Idx = 0; u32Idx < AlternativRefIDList.size(); ++u32Idx)
         {
            AlternativRefIDList[u32Idx].vDestroy();
         }
#endif // !VARIANT_S_FTR_ENABLE_DEEP_COPY
         oIn >> u32Length;
         AlternativRefIDList.resize(u32Length);
         for (u32Idx = 0; u32Idx < u32Length; ++u32Idx)
         {
            oIn >> AlternativRefIDList[u32Idx];
         }
      }
   }
   {
      tU32 u32Length;
      tU32 u32Idx;
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
      for (u32Idx = 0; u32Idx < RequiredPermissionRefList.size(); ++u32Idx)
      {
         RequiredPermissionRefList[u32Idx].vDestroy();
      }
#endif // !VARIANT_S_FTR_ENABLE_DEEP_COPY
      oIn >> u32Length;
      RequiredPermissionRefList.resize(u32Length);
      for (u32Idx = 0; u32Idx < u32Length; ++u32Idx)
      {
         oIn >> RequiredPermissionRefList[u32Idx];
      }
   }
   return oIn;
}

fi_tclOutContext& fi_tcl_RequiredPermissionListSet::oWrite(fi_tclOutContext& oOut) const
{
   if (oOut.u16GetMajorVersion() <= 10)
   {
      oOut << (tU32)AlternativRefList.size();
      {
         for (tU32 u32Idx = 0; u32Idx < AlternativRefList.size(); ++u32Idx)
            oOut << AlternativRefList[u32Idx];
      }
   }
   if (11 <= oOut.u16GetMajorVersion())
   {
      oOut << (tU32)AlternativRefIDList.size();
      {
         for (tU32 u32Idx = 0; u32Idx < AlternativRefIDList.size(); ++u32Idx)
            oOut << AlternativRefIDList[u32Idx];
      }
   }
   oOut << (tU32)RequiredPermissionRefList.size();
   {
      for (tU32 u32Idx = 0; u32Idx < RequiredPermissionRefList.size(); ++u32Idx)
         oOut << RequiredPermissionRefList[u32Idx];
   }
   return oOut;
}

tU32 fi_tcl_e8_IntersectionType::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 1;
}

tBool fi_tcl_e8_IntersectionType::operator==(const fi_tcl_e8_IntersectionType& rfoCmp) const
{
   return enType == rfoCmp.enType;
}

fi_tclInContext& fi_tcl_e8_IntersectionType::oRead(fi_tclInContext& oIn)
{
   tU8 u8Value;
   oIn >> u8Value;
   enType = (tenType)u8Value;
   return oIn;
}

fi_tclOutContext& fi_tcl_e8_IntersectionType::oWrite(fi_tclOutContext& oOut) const
{
   fi_tcl_e8_IntersectionType::tenType enData = enType;
   if ((enData == FI_EN_MOTORWAYENTRANCE) && !((31 <= oOut.u16GetMajorVersion()) && (oOut.u16GetMajorVersion() <= 32)))
   {
      enData = FI_EN_ENTRANCE;
   }
   if ((enData == FI_EN_ENTRANCE) && !(31 <= oOut.u16GetMajorVersion()))
   {
      enData = FI_EN_T_RESERVED;
   }
   if ((enData == FI_EN_MOTORWAYEXIT) && !(oOut.u16GetMajorVersion() <= 32))
   {
      enData = FI_EN_EXIT;
   }
   return oOut.oWrite((tU8)enData);
}

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
fi_tcl_TimeZoneListSet::fi_tcl_TimeZoneListSet(const fi_tcl_TimeZoneListSet& coRef):fi_tclVisitableTypeBase(coRef)
{
   ElementRefList = coRef.ElementRefList;
   TimeZoneList = coRef.TimeZoneList;
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
fi_tcl_TimeZoneListSet& fi_tcl_TimeZoneListSet::operator=(const fi_tcl_TimeZoneListSet& coRef)
{
   if (this == &coRef) return *this;
   ElementRefList = coRef.ElementRefList;
   TimeZoneList = coRef.TimeZoneList;
   return *this;
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
tVoid fi_tcl_TimeZoneListSet::vDestroy()
{
   ElementRefList.clear();
   {
      for (tU32 u32Idx = 0; u32Idx < TimeZoneList.size(); ++u32Idx)
         TimeZoneList[u32Idx].vDestroy();
   }
   TimeZoneList.clear();
}

tU32 fi_tcl_TimeZoneListSet::u32GetSize(tU16 u16MajorVersion) const
{
   tU32 u32DynamicSize = 0;
   tU32 u32ListIdx;
   for (u32ListIdx = 0; u32ListIdx < TimeZoneList.size(); ++u32ListIdx)
      u32DynamicSize += TimeZoneList[u32ListIdx].u32GetSize(u16MajorVersion);
   return u32DynamicSize+8+ElementRefList.size()*2;
}

tBool fi_tcl_TimeZoneListSet::operator==(const fi_tcl_TimeZoneListSet& rfoCmp) const
{
   tBool bResult = true;
      bResult = bResult && (ElementRefList.size() == rfoCmp.ElementRefList.size());
      if (bResult)
      {
         for (tU32 u32Idx = 0; bResult && (u32Idx < ElementRefList.size()); ++u32Idx)
            bResult = bResult && (ElementRefList[u32Idx] == rfoCmp.ElementRefList[u32Idx]);
      }
      bResult = bResult && (TimeZoneList.size() == rfoCmp.TimeZoneList.size());
      if (bResult)
      {
         for (tU32 u32Idx = 0; bResult && (u32Idx < TimeZoneList.size()); ++u32Idx)
            bResult = bResult && (TimeZoneList[u32Idx] == rfoCmp.TimeZoneList[u32Idx]);
      }
   return bResult;
}

fi_tclInContext& fi_tcl_TimeZoneListSet::oRead(fi_tclInContext& oIn)
{
   {
      tU32 u32Length;
      tU32 u32Idx;
      oIn >> u32Length;
      ElementRefList.resize(u32Length);
      for (u32Idx = 0; u32Idx < u32Length; ++u32Idx)
      {
         oIn >> ElementRefList[u32Idx];
      }
   }
   {
      tU32 u32Length;
      tU32 u32Idx;
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
      for (u32Idx = 0; u32Idx < TimeZoneList.size(); ++u32Idx)
      {
         TimeZoneList[u32Idx].vDestroy();
      }
#endif // !VARIANT_S_FTR_ENABLE_DEEP_COPY
      oIn >> u32Length;
      TimeZoneList.resize(u32Length);
      for (u32Idx = 0; u32Idx < u32Length; ++u32Idx)
      {
         oIn >> TimeZoneList[u32Idx];
      }
   }
   return oIn;
}

fi_tclOutContext& fi_tcl_TimeZoneListSet::oWrite(fi_tclOutContext& oOut) const
{
   oOut << (tU32)ElementRefList.size();
   {
      for (tU32 u32Idx = 0; u32Idx < ElementRefList.size(); ++u32Idx)
         oOut << ElementRefList[u32Idx];
   }
   oOut << (tU32)TimeZoneList.size();
   {
      for (tU32 u32Idx = 0; u32Idx < TimeZoneList.size(); ++u32Idx)
         oOut << TimeZoneList[u32Idx];
   }
   return oOut;
}

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
fi_tcl_IntersectionNameElement::fi_tcl_IntersectionNameElement(const fi_tcl_IntersectionNameElement& coRef):fi_tclVisitableTypeBase(coRef)
{
   IntersectionType = coRef.IntersectionType;
   IntersectionPrefix = coRef.IntersectionPrefix;
   IntersectionName = coRef.IntersectionName;
   IntersectionSuffix = coRef.IntersectionSuffix;
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
fi_tcl_IntersectionNameElement& fi_tcl_IntersectionNameElement::operator=(const fi_tcl_IntersectionNameElement& coRef)
{
   if (this == &coRef) return *this;
   IntersectionType = coRef.IntersectionType;
   IntersectionPrefix = coRef.IntersectionPrefix;
   IntersectionName = coRef.IntersectionName;
   IntersectionSuffix = coRef.IntersectionSuffix;
   return *this;
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
tVoid fi_tcl_IntersectionNameElement::vDestroy()
{
   IntersectionPrefix.vDestroy();
   IntersectionName.vDestroy();
   IntersectionSuffix.vDestroy();
}

tU32 fi_tcl_IntersectionNameElement::u32GetSize(tU16 u16MajorVersion) const
{
   return 1+IntersectionPrefix.u32GetSize(u16MajorVersion)+IntersectionName.u32GetSize(u16MajorVersion)+IntersectionSuffix.u32GetSize(u16MajorVersion);
}

tBool fi_tcl_IntersectionNameElement::operator==(const fi_tcl_IntersectionNameElement& rfoCmp) const
{
   tBool bResult = true;
      bResult = bResult && (IntersectionType == rfoCmp.IntersectionType);
      bResult = bResult && (IntersectionPrefix == rfoCmp.IntersectionPrefix);
      bResult = bResult && (IntersectionName == rfoCmp.IntersectionName);
      bResult = bResult && (IntersectionSuffix == rfoCmp.IntersectionSuffix);
   return bResult;
}

fi_tclInContext& fi_tcl_IntersectionNameElement::oRead(fi_tclInContext& oIn)
{
   oIn >> IntersectionType;
   oIn >> IntersectionPrefix;
   oIn >> IntersectionName;
   oIn >> IntersectionSuffix;
   return oIn;
}

fi_tclOutContext& fi_tcl_IntersectionNameElement::oWrite(fi_tclOutContext& oOut) const
{
   oOut << IntersectionType;
   oOut << IntersectionPrefix;
   oOut << IntersectionName;
   oOut << IntersectionSuffix;
   return oOut;
}

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
fi_tcl_IntersectionNameListSet::fi_tcl_IntersectionNameListSet(const fi_tcl_IntersectionNameListSet& coRef):fi_tclVisitableTypeBase(coRef)
{
   AlternativRefList = coRef.AlternativRefList;
   IntersectionNameRefList = coRef.IntersectionNameRefList;
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
fi_tcl_IntersectionNameListSet& fi_tcl_IntersectionNameListSet::operator=(const fi_tcl_IntersectionNameListSet& coRef)
{
   if (this == &coRef) return *this;
   AlternativRefList = coRef.AlternativRefList;
   IntersectionNameRefList = coRef.IntersectionNameRefList;
   return *this;
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
tVoid fi_tcl_IntersectionNameListSet::vDestroy()
{
   {
      for (tU32 u32Idx = 0; u32Idx < AlternativRefList.size(); ++u32Idx)
         AlternativRefList[u32Idx].vDestroy();
   }
   AlternativRefList.clear();
   {
      for (tU32 u32Idx = 0; u32Idx < IntersectionNameRefList.size(); ++u32Idx)
         IntersectionNameRefList[u32Idx].vDestroy();
   }
   IntersectionNameRefList.clear();
}

tU32 fi_tcl_IntersectionNameListSet::u32GetSize(tU16 u16MajorVersion) const
{
   tU32 u32DynamicSize = 0;
   tU32 u32ListIdx;
   for (u32ListIdx = 0; u32ListIdx < IntersectionNameRefList.size(); ++u32ListIdx)
      u32DynamicSize += IntersectionNameRefList[u32ListIdx].u32GetSize(u16MajorVersion);
   return u32DynamicSize+8+AlternativRefList.size()*4;
}

tBool fi_tcl_IntersectionNameListSet::operator==(const fi_tcl_IntersectionNameListSet& rfoCmp) const
{
   tBool bResult = true;
      bResult = bResult && (AlternativRefList.size() == rfoCmp.AlternativRefList.size());
      if (bResult)
      {
         for (tU32 u32Idx = 0; bResult && (u32Idx < AlternativRefList.size()); ++u32Idx)
            bResult = bResult && (AlternativRefList[u32Idx] == rfoCmp.AlternativRefList[u32Idx]);
      }
      bResult = bResult && (IntersectionNameRefList.size() == rfoCmp.IntersectionNameRefList.size());
      if (bResult)
      {
         for (tU32 u32Idx = 0; bResult && (u32Idx < IntersectionNameRefList.size()); ++u32Idx)
            bResult = bResult && (IntersectionNameRefList[u32Idx] == rfoCmp.IntersectionNameRefList[u32Idx]);
      }
   return bResult;
}

fi_tclInContext& fi_tcl_IntersectionNameListSet::oRead(fi_tclInContext& oIn)
{
   {
      tU32 u32Length;
      tU32 u32Idx;
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
      for (u32Idx = 0; u32Idx < AlternativRefList.size(); ++u32Idx)
      {
         AlternativRefList[u32Idx].vDestroy();
      }
#endif // !VARIANT_S_FTR_ENABLE_DEEP_COPY
      oIn >> u32Length;
      AlternativRefList.resize(u32Length);
      for (u32Idx = 0; u32Idx < u32Length; ++u32Idx)
      {
         oIn >> AlternativRefList[u32Idx];
      }
   }
   {
      tU32 u32Length;
      tU32 u32Idx;
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
      for (u32Idx = 0; u32Idx < IntersectionNameRefList.size(); ++u32Idx)
      {
         IntersectionNameRefList[u32Idx].vDestroy();
      }
#endif // !VARIANT_S_FTR_ENABLE_DEEP_COPY
      oIn >> u32Length;
      IntersectionNameRefList.resize(u32Length);
      for (u32Idx = 0; u32Idx < u32Length; ++u32Idx)
      {
         oIn >> IntersectionNameRefList[u32Idx];
      }
   }
   return oIn;
}

fi_tclOutContext& fi_tcl_IntersectionNameListSet::oWrite(fi_tclOutContext& oOut) const
{
   oOut << (tU32)AlternativRefList.size();
   {
      for (tU32 u32Idx = 0; u32Idx < AlternativRefList.size(); ++u32Idx)
         oOut << AlternativRefList[u32Idx];
   }
   oOut << (tU32)IntersectionNameRefList.size();
   {
      for (tU32 u32Idx = 0; u32Idx < IntersectionNameRefList.size(); ++u32Idx)
         oOut << IntersectionNameRefList[u32Idx];
   }
   return oOut;
}

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
fi_tcl_RoadNameElement::fi_tcl_RoadNameElement(const fi_tcl_RoadNameElement& coRef):fi_tclVisitableTypeBase(coRef)
{
   RoadName = coRef.RoadName;
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
fi_tcl_RoadNameElement& fi_tcl_RoadNameElement::operator=(const fi_tcl_RoadNameElement& coRef)
{
   if (this == &coRef) return *this;
   RoadName = coRef.RoadName;
   return *this;
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
tVoid fi_tcl_RoadNameElement::vDestroy()
{
   RoadName.vDestroy();
}

tU32 fi_tcl_RoadNameElement::u32GetSize(tU16 u16MajorVersion) const
{
   return 0+RoadName.u32GetSize(u16MajorVersion);
}

tBool fi_tcl_RoadNameElement::operator==(const fi_tcl_RoadNameElement& rfoCmp) const
{
   tBool bResult = true;
      bResult = bResult && (RoadName == rfoCmp.RoadName);
   return bResult;
}

fi_tclInContext& fi_tcl_RoadNameElement::oRead(fi_tclInContext& oIn)
{
   oIn >> RoadName;
   return oIn;
}

fi_tclOutContext& fi_tcl_RoadNameElement::oWrite(fi_tclOutContext& oOut) const
{
   oOut << RoadName;
   return oOut;
}

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
fi_tcl_RoadNumber::fi_tcl_RoadNumber(const fi_tcl_RoadNumber& coRef):fi_tclVisitableTypeBase(coRef)
{
   Status = coRef.Status;
   CountryCode = coRef.CountryCode;
   State = coRef.State;
   StateCode = coRef.StateCode;
   NumberHierarchy = coRef.NumberHierarchy;
   NumberPrefix = coRef.NumberPrefix;
   RoadNumber = coRef.RoadNumber;
   NumberSuffix = coRef.NumberSuffix;
   CompassDirection = coRef.CompassDirection;
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
fi_tcl_RoadNumber& fi_tcl_RoadNumber::operator=(const fi_tcl_RoadNumber& coRef)
{
   if (this == &coRef) return *this;
   Status = coRef.Status;
   CountryCode = coRef.CountryCode;
   State = coRef.State;
   StateCode = coRef.StateCode;
   NumberHierarchy = coRef.NumberHierarchy;
   NumberPrefix = coRef.NumberPrefix;
   RoadNumber = coRef.RoadNumber;
   NumberSuffix = coRef.NumberSuffix;
   CompassDirection = coRef.CompassDirection;
   return *this;
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
tVoid fi_tcl_RoadNumber::vDestroy()
{
   NumberPrefix.vDestroy();
   RoadNumber.vDestroy();
   NumberSuffix.vDestroy();
   CompassDirection.vDestroy(); 
}

tU32 fi_tcl_RoadNumber::u32GetSize(tU16 u16MajorVersion) const
{
   tU32 u32DynamicSize = 0;
   if (u16MajorVersion <= 10)
   {
      u32DynamicSize += 2;
   }
   if (11 <= u16MajorVersion)
   {
      u32DynamicSize += 4;
   }
   return u32DynamicSize+4+NumberPrefix.u32GetSize(u16MajorVersion)+RoadNumber.u32GetSize(u16MajorVersion)+NumberSuffix.u32GetSize(u16MajorVersion)+CompassDirection.u32GetSize(u16MajorVersion);
}

tBool fi_tcl_RoadNumber::operator==(const fi_tcl_RoadNumber& rfoCmp) const
{
   tBool bResult = true;
      bResult = bResult && (Status == rfoCmp.Status);
      bResult = bResult && (CountryCode == rfoCmp.CountryCode);
      bResult = bResult && (State == rfoCmp.State);
      bResult = bResult && (StateCode == rfoCmp.StateCode);
      bResult = bResult && (NumberHierarchy == rfoCmp.NumberHierarchy);
      bResult = bResult && (NumberPrefix == rfoCmp.NumberPrefix);
      bResult = bResult && (RoadNumber == rfoCmp.RoadNumber);
      bResult = bResult && (NumberSuffix == rfoCmp.NumberSuffix);
      bResult = bResult && (CompassDirection == rfoCmp.CompassDirection);
   return bResult;
}

fi_tclInContext& fi_tcl_RoadNumber::oRead(fi_tclInContext& oIn)
{
   oIn >> Status;
   oIn >> CountryCode;
   if (oIn.u16GetMajorVersion() <= 10)
   {
      oIn >> State;
   }
   if (11 <= oIn.u16GetMajorVersion())
   {
      oIn >> StateCode;
   }
   oIn >> NumberHierarchy;
   oIn >> NumberPrefix;
   oIn >> RoadNumber;
   oIn >> NumberSuffix;
   oIn >> CompassDirection;
   return oIn;
}

fi_tclOutContext& fi_tcl_RoadNumber::oWrite(fi_tclOutContext& oOut) const
{
   oOut << Status;
   oOut << CountryCode;
   if (oOut.u16GetMajorVersion() <= 10)
   {
      oOut << State;
   }
   if (11 <= oOut.u16GetMajorVersion())
   {
      oOut << StateCode;
   }
   oOut << NumberHierarchy;
   oOut << NumberPrefix;
   oOut << RoadNumber;
   oOut << NumberSuffix;
   oOut << CompassDirection;
   return oOut;
}

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
fi_tcl_IntersectionNumberElement::fi_tcl_IntersectionNumberElement(const fi_tcl_IntersectionNumberElement& coRef):fi_tclVisitableTypeBase(coRef)
{
   IntersectionType = coRef.IntersectionType;
   IntersectionNumber = coRef.IntersectionNumber;
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
fi_tcl_IntersectionNumberElement& fi_tcl_IntersectionNumberElement::operator=(const fi_tcl_IntersectionNumberElement& coRef)
{
   if (this == &coRef) return *this;
   IntersectionType = coRef.IntersectionType;
   IntersectionNumber = coRef.IntersectionNumber;
   return *this;
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
tVoid fi_tcl_IntersectionNumberElement::vDestroy()
{
   IntersectionNumber.vDestroy(); 
}

tU32 fi_tcl_IntersectionNumberElement::u32GetSize(tU16 u16MajorVersion) const
{
   return 1+IntersectionNumber.u32GetSize(u16MajorVersion);
}

tBool fi_tcl_IntersectionNumberElement::operator==(const fi_tcl_IntersectionNumberElement& rfoCmp) const
{
   tBool bResult = true;
      bResult = bResult && (IntersectionType == rfoCmp.IntersectionType);
      bResult = bResult && (IntersectionNumber == rfoCmp.IntersectionNumber);
   return bResult;
}

fi_tclInContext& fi_tcl_IntersectionNumberElement::oRead(fi_tclInContext& oIn)
{
   oIn >> IntersectionType;
   oIn >> IntersectionNumber;
   return oIn;
}

fi_tclOutContext& fi_tcl_IntersectionNumberElement::oWrite(fi_tclOutContext& oOut) const
{
   oOut << IntersectionType;
   oOut << IntersectionNumber;
   return oOut;
}

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
fi_tcl_MapDescriptionListSet::fi_tcl_MapDescriptionListSet(const fi_tcl_MapDescriptionListSet& coRef):fi_tclVisitableTypeBase(coRef)
{
   ElementRefList = coRef.ElementRefList;
   MapElementRefList = coRef.MapElementRefList;
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
fi_tcl_MapDescriptionListSet& fi_tcl_MapDescriptionListSet::operator=(const fi_tcl_MapDescriptionListSet& coRef)
{
   if (this == &coRef) return *this;
   ElementRefList = coRef.ElementRefList;
   MapElementRefList = coRef.MapElementRefList;
   return *this;
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
tVoid fi_tcl_MapDescriptionListSet::vDestroy()
{
   ElementRefList.clear();
   {
      for (tU32 u32Idx = 0; u32Idx < MapElementRefList.size(); ++u32Idx)
         MapElementRefList[u32Idx].vDestroy();
   }
   MapElementRefList.clear();
}

tU32 fi_tcl_MapDescriptionListSet::u32GetSize(tU16 u16MajorVersion) const
{
   tU32 u32DynamicSize = 0;
   tU32 u32ListIdx;
   for (u32ListIdx = 0; u32ListIdx < MapElementRefList.size(); ++u32ListIdx)
      u32DynamicSize += MapElementRefList[u32ListIdx].u32GetSize(u16MajorVersion);
   return u32DynamicSize+8+ElementRefList.size()*2;
}

tBool fi_tcl_MapDescriptionListSet::operator==(const fi_tcl_MapDescriptionListSet& rfoCmp) const
{
   tBool bResult = true;
      bResult = bResult && (ElementRefList.size() == rfoCmp.ElementRefList.size());
      if (bResult)
      {
         for (tU32 u32Idx = 0; bResult && (u32Idx < ElementRefList.size()); ++u32Idx)
            bResult = bResult && (ElementRefList[u32Idx] == rfoCmp.ElementRefList[u32Idx]);
      }
      bResult = bResult && (MapElementRefList.size() == rfoCmp.MapElementRefList.size());
      if (bResult)
      {
         for (tU32 u32Idx = 0; bResult && (u32Idx < MapElementRefList.size()); ++u32Idx)
            bResult = bResult && (MapElementRefList[u32Idx] == rfoCmp.MapElementRefList[u32Idx]);
      }
   return bResult;
}

fi_tclInContext& fi_tcl_MapDescriptionListSet::oRead(fi_tclInContext& oIn)
{
   {
      tU32 u32Length;
      tU32 u32Idx;
      oIn >> u32Length;
      ElementRefList.resize(u32Length);
      for (u32Idx = 0; u32Idx < u32Length; ++u32Idx)
      {
         oIn >> ElementRefList[u32Idx];
      }
   }
   {
      tU32 u32Length;
      tU32 u32Idx;
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
      for (u32Idx = 0; u32Idx < MapElementRefList.size(); ++u32Idx)
      {
         MapElementRefList[u32Idx].vDestroy();
      }
#endif // !VARIANT_S_FTR_ENABLE_DEEP_COPY
      oIn >> u32Length;
      MapElementRefList.resize(u32Length);
      for (u32Idx = 0; u32Idx < u32Length; ++u32Idx)
      {
         oIn >> MapElementRefList[u32Idx];
      }
   }
   return oIn;
}

fi_tclOutContext& fi_tcl_MapDescriptionListSet::oWrite(fi_tclOutContext& oOut) const
{
   oOut << (tU32)ElementRefList.size();
   {
      for (tU32 u32Idx = 0; u32Idx < ElementRefList.size(); ++u32Idx)
         oOut << ElementRefList[u32Idx];
   }
   oOut << (tU32)MapElementRefList.size();
   {
      for (tU32 u32Idx = 0; u32Idx < MapElementRefList.size(); ++u32Idx)
         oOut << MapElementRefList[u32Idx];
   }
   return oOut;
}

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
fi_tcl_CountryNameListSet::fi_tcl_CountryNameListSet(const fi_tcl_CountryNameListSet& coRef):fi_tclVisitableTypeBase(coRef)
{
   ElementRefList = coRef.ElementRefList;
   CountryNameRefList = coRef.CountryNameRefList;
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
fi_tcl_CountryNameListSet& fi_tcl_CountryNameListSet::operator=(const fi_tcl_CountryNameListSet& coRef)
{
   if (this == &coRef) return *this;
   ElementRefList = coRef.ElementRefList;
   CountryNameRefList = coRef.CountryNameRefList;
   return *this;
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
tVoid fi_tcl_CountryNameListSet::vDestroy()
{
   ElementRefList.clear();
   {
      for (tU32 u32Idx = 0; u32Idx < CountryNameRefList.size(); ++u32Idx)
         CountryNameRefList[u32Idx].vDestroy();
   }
   CountryNameRefList.clear();
}

tU32 fi_tcl_CountryNameListSet::u32GetSize(tU16 u16MajorVersion) const
{
   tU32 u32DynamicSize = 0;
   tU32 u32ListIdx;
   for (u32ListIdx = 0; u32ListIdx < CountryNameRefList.size(); ++u32ListIdx)
      u32DynamicSize += CountryNameRefList[u32ListIdx].u32GetSize(u16MajorVersion);
   return u32DynamicSize+8+ElementRefList.size()*2;
}

tBool fi_tcl_CountryNameListSet::operator==(const fi_tcl_CountryNameListSet& rfoCmp) const
{
   tBool bResult = true;
      bResult = bResult && (ElementRefList.size() == rfoCmp.ElementRefList.size());
      if (bResult)
      {
         for (tU32 u32Idx = 0; bResult && (u32Idx < ElementRefList.size()); ++u32Idx)
            bResult = bResult && (ElementRefList[u32Idx] == rfoCmp.ElementRefList[u32Idx]);
      }
      bResult = bResult && (CountryNameRefList.size() == rfoCmp.CountryNameRefList.size());
      if (bResult)
      {
         for (tU32 u32Idx = 0; bResult && (u32Idx < CountryNameRefList.size()); ++u32Idx)
            bResult = bResult && (CountryNameRefList[u32Idx] == rfoCmp.CountryNameRefList[u32Idx]);
      }
   return bResult;
}

fi_tclInContext& fi_tcl_CountryNameListSet::oRead(fi_tclInContext& oIn)
{
   {
      tU32 u32Length;
      tU32 u32Idx;
      oIn >> u32Length;
      ElementRefList.resize(u32Length);
      for (u32Idx = 0; u32Idx < u32Length; ++u32Idx)
      {
         oIn >> ElementRefList[u32Idx];
      }
   }
   {
      tU32 u32Length;
      tU32 u32Idx;
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
      for (u32Idx = 0; u32Idx < CountryNameRefList.size(); ++u32Idx)
      {
         CountryNameRefList[u32Idx].vDestroy();
      }
#endif // !VARIANT_S_FTR_ENABLE_DEEP_COPY
      oIn >> u32Length;
      CountryNameRefList.resize(u32Length);
      for (u32Idx = 0; u32Idx < u32Length; ++u32Idx)
      {
         oIn >> CountryNameRefList[u32Idx];
      }
   }
   return oIn;
}

fi_tclOutContext& fi_tcl_CountryNameListSet::oWrite(fi_tclOutContext& oOut) const
{
   oOut << (tU32)ElementRefList.size();
   {
      for (tU32 u32Idx = 0; u32Idx < ElementRefList.size(); ++u32Idx)
         oOut << ElementRefList[u32Idx];
   }
   oOut << (tU32)CountryNameRefList.size();
   {
      for (tU32 u32Idx = 0; u32Idx < CountryNameRefList.size(); ++u32Idx)
         oOut << CountryNameRefList[u32Idx];
   }
   return oOut;
}

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
fi_tcl_CityNameListSet::fi_tcl_CityNameListSet(const fi_tcl_CityNameListSet& coRef):fi_tclVisitableTypeBase(coRef)
{
   ElementInRefList = coRef.ElementInRefList;
   CityNameRefList = coRef.CityNameRefList;
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
fi_tcl_CityNameListSet& fi_tcl_CityNameListSet::operator=(const fi_tcl_CityNameListSet& coRef)
{
   if (this == &coRef) return *this;
   ElementInRefList = coRef.ElementInRefList;
   CityNameRefList = coRef.CityNameRefList;
   return *this;
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
tVoid fi_tcl_CityNameListSet::vDestroy()
{
   {
      for (tU32 u32Idx = 0; u32Idx < ElementInRefList.size(); ++u32Idx)
         ElementInRefList[u32Idx].vDestroy();
   }
   ElementInRefList.clear();
   {
      for (tU32 u32Idx = 0; u32Idx < CityNameRefList.size(); ++u32Idx)
         CityNameRefList[u32Idx].vDestroy();
   }
   CityNameRefList.clear();
}

tU32 fi_tcl_CityNameListSet::u32GetSize(tU16 u16MajorVersion) const
{
   tU32 u32DynamicSize = 0;
   tU32 u32ListIdx;
   for (u32ListIdx = 0; u32ListIdx < CityNameRefList.size(); ++u32ListIdx)
      u32DynamicSize += CityNameRefList[u32ListIdx].u32GetSize(u16MajorVersion);
   return u32DynamicSize+8+ElementInRefList.size()*3;
}

tBool fi_tcl_CityNameListSet::operator==(const fi_tcl_CityNameListSet& rfoCmp) const
{
   tBool bResult = true;
      bResult = bResult && (ElementInRefList.size() == rfoCmp.ElementInRefList.size());
      if (bResult)
      {
         for (tU32 u32Idx = 0; bResult && (u32Idx < ElementInRefList.size()); ++u32Idx)
            bResult = bResult && (ElementInRefList[u32Idx] == rfoCmp.ElementInRefList[u32Idx]);
      }
      bResult = bResult && (CityNameRefList.size() == rfoCmp.CityNameRefList.size());
      if (bResult)
      {
         for (tU32 u32Idx = 0; bResult && (u32Idx < CityNameRefList.size()); ++u32Idx)
            bResult = bResult && (CityNameRefList[u32Idx] == rfoCmp.CityNameRefList[u32Idx]);
      }
   return bResult;
}

fi_tclInContext& fi_tcl_CityNameListSet::oRead(fi_tclInContext& oIn)
{
   {
      tU32 u32Length;
      tU32 u32Idx;
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
      for (u32Idx = 0; u32Idx < ElementInRefList.size(); ++u32Idx)
      {
         ElementInRefList[u32Idx].vDestroy();
      }
#endif // !VARIANT_S_FTR_ENABLE_DEEP_COPY
      oIn >> u32Length;
      ElementInRefList.resize(u32Length);
      for (u32Idx = 0; u32Idx < u32Length; ++u32Idx)
      {
         oIn >> ElementInRefList[u32Idx];
      }
   }
   {
      tU32 u32Length;
      tU32 u32Idx;
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
      for (u32Idx = 0; u32Idx < CityNameRefList.size(); ++u32Idx)
      {
         CityNameRefList[u32Idx].vDestroy();
      }
#endif // !VARIANT_S_FTR_ENABLE_DEEP_COPY
      oIn >> u32Length;
      CityNameRefList.resize(u32Length);
      for (u32Idx = 0; u32Idx < u32Length; ++u32Idx)
      {
         oIn >> CityNameRefList[u32Idx];
      }
   }
   return oIn;
}

fi_tclOutContext& fi_tcl_CityNameListSet::oWrite(fi_tclOutContext& oOut) const
{
   oOut << (tU32)ElementInRefList.size();
   {
      for (tU32 u32Idx = 0; u32Idx < ElementInRefList.size(); ++u32Idx)
         oOut << ElementInRefList[u32Idx];
   }
   oOut << (tU32)CityNameRefList.size();
   {
      for (tU32 u32Idx = 0; u32Idx < CityNameRefList.size(); ++u32Idx)
         oOut << CityNameRefList[u32Idx];
   }
   return oOut;
}

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
fi_tcl_SignPostListSet::fi_tcl_SignPostListSet(const fi_tcl_SignPostListSet& coRef):fi_tclVisitableTypeBase(coRef)
{
   AlternativRefList = coRef.AlternativRefList;
   SignPostElement = coRef.SignPostElement;
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
fi_tcl_SignPostListSet& fi_tcl_SignPostListSet::operator=(const fi_tcl_SignPostListSet& coRef)
{
   if (this == &coRef) return *this;
   AlternativRefList = coRef.AlternativRefList;
   SignPostElement = coRef.SignPostElement;
   return *this;
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
tVoid fi_tcl_SignPostListSet::vDestroy()
{
   {
      for (tU32 u32Idx = 0; u32Idx < AlternativRefList.size(); ++u32Idx)
         AlternativRefList[u32Idx].vDestroy();
   }
   AlternativRefList.clear();
   {
      for (tU32 u32Idx = 0; u32Idx < SignPostElement.size(); ++u32Idx)
         SignPostElement[u32Idx].vDestroy();
   }
   SignPostElement.clear();
}

tU32 fi_tcl_SignPostListSet::u32GetSize(tU16 u16MajorVersion) const
{
   tU32 u32DynamicSize = 0;
   tU32 u32ListIdx;
   for (u32ListIdx = 0; u32ListIdx < SignPostElement.size(); ++u32ListIdx)
      u32DynamicSize += SignPostElement[u32ListIdx].u32GetSize(u16MajorVersion);
   return u32DynamicSize+8+AlternativRefList.size()*4;
}

tBool fi_tcl_SignPostListSet::operator==(const fi_tcl_SignPostListSet& rfoCmp) const
{
   tBool bResult = true;
      bResult = bResult && (AlternativRefList.size() == rfoCmp.AlternativRefList.size());
      if (bResult)
      {
         for (tU32 u32Idx = 0; bResult && (u32Idx < AlternativRefList.size()); ++u32Idx)
            bResult = bResult && (AlternativRefList[u32Idx] == rfoCmp.AlternativRefList[u32Idx]);
      }
      bResult = bResult && (SignPostElement.size() == rfoCmp.SignPostElement.size());
      if (bResult)
      {
         for (tU32 u32Idx = 0; bResult && (u32Idx < SignPostElement.size()); ++u32Idx)
            bResult = bResult && (SignPostElement[u32Idx] == rfoCmp.SignPostElement[u32Idx]);
      }
   return bResult;
}

fi_tclInContext& fi_tcl_SignPostListSet::oRead(fi_tclInContext& oIn)
{
   {
      tU32 u32Length;
      tU32 u32Idx;
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
      for (u32Idx = 0; u32Idx < AlternativRefList.size(); ++u32Idx)
      {
         AlternativRefList[u32Idx].vDestroy();
      }
#endif // !VARIANT_S_FTR_ENABLE_DEEP_COPY
      oIn >> u32Length;
      AlternativRefList.resize(u32Length);
      for (u32Idx = 0; u32Idx < u32Length; ++u32Idx)
      {
         oIn >> AlternativRefList[u32Idx];
      }
   }
   {
      tU32 u32Length;
      tU32 u32Idx;
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
      for (u32Idx = 0; u32Idx < SignPostElement.size(); ++u32Idx)
      {
         SignPostElement[u32Idx].vDestroy();
      }
#endif // !VARIANT_S_FTR_ENABLE_DEEP_COPY
      oIn >> u32Length;
      SignPostElement.resize(u32Length);
      for (u32Idx = 0; u32Idx < u32Length; ++u32Idx)
      {
         oIn >> SignPostElement[u32Idx];
      }
   }
   return oIn;
}

fi_tclOutContext& fi_tcl_SignPostListSet::oWrite(fi_tclOutContext& oOut) const
{
   oOut << (tU32)AlternativRefList.size();
   {
      for (tU32 u32Idx = 0; u32Idx < AlternativRefList.size(); ++u32Idx)
         oOut << AlternativRefList[u32Idx];
   }
   oOut << (tU32)SignPostElement.size();
   {
      for (tU32 u32Idx = 0; u32Idx < SignPostElement.size(); ++u32Idx)
         oOut << SignPostElement[u32Idx];
   }
   return oOut;
}

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
fi_tcl_IntersectionNumberListSet::fi_tcl_IntersectionNumberListSet(const fi_tcl_IntersectionNumberListSet& coRef):fi_tclVisitableTypeBase(coRef)
{
   AlternativRefList = coRef.AlternativRefList;
   IntersectionNumberRefList = coRef.IntersectionNumberRefList;
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
fi_tcl_IntersectionNumberListSet& fi_tcl_IntersectionNumberListSet::operator=(const fi_tcl_IntersectionNumberListSet& coRef)
{
   if (this == &coRef) return *this;
   AlternativRefList = coRef.AlternativRefList;
   IntersectionNumberRefList = coRef.IntersectionNumberRefList;
   return *this;
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
tVoid fi_tcl_IntersectionNumberListSet::vDestroy()
{
   {
      for (tU32 u32Idx = 0; u32Idx < AlternativRefList.size(); ++u32Idx)
         AlternativRefList[u32Idx].vDestroy();
   }
   AlternativRefList.clear();
   {
      for (tU32 u32Idx = 0; u32Idx < IntersectionNumberRefList.size(); ++u32Idx)
         IntersectionNumberRefList[u32Idx].vDestroy();
   }
   IntersectionNumberRefList.clear();
}

tU32 fi_tcl_IntersectionNumberListSet::u32GetSize(tU16 u16MajorVersion) const
{
   tU32 u32DynamicSize = 0;
   tU32 u32ListIdx;
   for (u32ListIdx = 0; u32ListIdx < IntersectionNumberRefList.size(); ++u32ListIdx)
      u32DynamicSize += IntersectionNumberRefList[u32ListIdx].u32GetSize(u16MajorVersion);
   return u32DynamicSize+8+AlternativRefList.size()*4;
}

tBool fi_tcl_IntersectionNumberListSet::operator==(const fi_tcl_IntersectionNumberListSet& rfoCmp) const
{
   tBool bResult = true;
      bResult = bResult && (AlternativRefList.size() == rfoCmp.AlternativRefList.size());
      if (bResult)
      {
         for (tU32 u32Idx = 0; bResult && (u32Idx < AlternativRefList.size()); ++u32Idx)
            bResult = bResult && (AlternativRefList[u32Idx] == rfoCmp.AlternativRefList[u32Idx]);
      }
      bResult = bResult && (IntersectionNumberRefList.size() == rfoCmp.IntersectionNumberRefList.size());
      if (bResult)
      {
         for (tU32 u32Idx = 0; bResult && (u32Idx < IntersectionNumberRefList.size()); ++u32Idx)
            bResult = bResult && (IntersectionNumberRefList[u32Idx] == rfoCmp.IntersectionNumberRefList[u32Idx]);
      }
   return bResult;
}

fi_tclInContext& fi_tcl_IntersectionNumberListSet::oRead(fi_tclInContext& oIn)
{
   {
      tU32 u32Length;
      tU32 u32Idx;
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
      for (u32Idx = 0; u32Idx < AlternativRefList.size(); ++u32Idx)
      {
         AlternativRefList[u32Idx].vDestroy();
      }
#endif // !VARIANT_S_FTR_ENABLE_DEEP_COPY
      oIn >> u32Length;
      AlternativRefList.resize(u32Length);
      for (u32Idx = 0; u32Idx < u32Length; ++u32Idx)
      {
         oIn >> AlternativRefList[u32Idx];
      }
   }
   {
      tU32 u32Length;
      tU32 u32Idx;
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
      for (u32Idx = 0; u32Idx < IntersectionNumberRefList.size(); ++u32Idx)
      {
         IntersectionNumberRefList[u32Idx].vDestroy();
      }
#endif // !VARIANT_S_FTR_ENABLE_DEEP_COPY
      oIn >> u32Length;
      IntersectionNumberRefList.resize(u32Length);
      for (u32Idx = 0; u32Idx < u32Length; ++u32Idx)
      {
         oIn >> IntersectionNumberRefList[u32Idx];
      }
   }
   return oIn;
}

fi_tclOutContext& fi_tcl_IntersectionNumberListSet::oWrite(fi_tclOutContext& oOut) const
{
   oOut << (tU32)AlternativRefList.size();
   {
      for (tU32 u32Idx = 0; u32Idx < AlternativRefList.size(); ++u32Idx)
         oOut << AlternativRefList[u32Idx];
   }
   oOut << (tU32)IntersectionNumberRefList.size();
   {
      for (tU32 u32Idx = 0; u32Idx < IntersectionNumberRefList.size(); ++u32Idx)
         oOut << IntersectionNumberRefList[u32Idx];
   }
   return oOut;
}

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
fi_tcl_RoadNumberElementList::fi_tcl_RoadNumberElementList(const fi_tcl_RoadNumberElementList& coRef):fi_tclVisitableTypeBase(coRef)
{
   RoadNumberList = coRef.RoadNumberList;
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
fi_tcl_RoadNumberElementList& fi_tcl_RoadNumberElementList::operator=(const fi_tcl_RoadNumberElementList& coRef)
{
   if (this == &coRef) return *this;
   RoadNumberList = coRef.RoadNumberList;
   return *this;
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
tVoid fi_tcl_RoadNumberElementList::vDestroy()
{
   {
      for (tU32 u32Idx = 0; u32Idx < RoadNumberList.size(); ++u32Idx)
         RoadNumberList[u32Idx].vDestroy();
   }
   RoadNumberList.clear();
}

tU32 fi_tcl_RoadNumberElementList::u32GetSize(tU16 u16MajorVersion) const
{
   tU32 u32DynamicSize = 0;
   tU32 u32ListIdx;
   for (u32ListIdx = 0; u32ListIdx < RoadNumberList.size(); ++u32ListIdx)
      u32DynamicSize += RoadNumberList[u32ListIdx].u32GetSize(u16MajorVersion);
   return u32DynamicSize+4;
}

tBool fi_tcl_RoadNumberElementList::operator==(const fi_tcl_RoadNumberElementList& rfoCmp) const
{
   tBool bResult = true;
      bResult = bResult && (RoadNumberList.size() == rfoCmp.RoadNumberList.size());
      if (bResult)
      {
         for (tU32 u32Idx = 0; bResult && (u32Idx < RoadNumberList.size()); ++u32Idx)
            bResult = bResult && (RoadNumberList[u32Idx] == rfoCmp.RoadNumberList[u32Idx]);
      }
   return bResult;
}

fi_tclInContext& fi_tcl_RoadNumberElementList::oRead(fi_tclInContext& oIn)
{
   {
      tU32 u32Length;
      tU32 u32Idx;
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
      for (u32Idx = 0; u32Idx < RoadNumberList.size(); ++u32Idx)
      {
         RoadNumberList[u32Idx].vDestroy();
      }
#endif // !VARIANT_S_FTR_ENABLE_DEEP_COPY
      oIn >> u32Length;
      RoadNumberList.resize(u32Length);
      for (u32Idx = 0; u32Idx < u32Length; ++u32Idx)
      {
         oIn >> RoadNumberList[u32Idx];
      }
   }
   return oIn;
}

fi_tclOutContext& fi_tcl_RoadNumberElementList::oWrite(fi_tclOutContext& oOut) const
{
   oOut << (tU32)RoadNumberList.size();
   {
      for (tU32 u32Idx = 0; u32Idx < RoadNumberList.size(); ++u32Idx)
         oOut << RoadNumberList[u32Idx];
   }
   return oOut;
}

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
fi_tcl_RoadNumberListSet::fi_tcl_RoadNumberListSet(const fi_tcl_RoadNumberListSet& coRef):fi_tclVisitableTypeBase(coRef)
{
   ElementRefList = coRef.ElementRefList;
   AlternativRefList = coRef.AlternativRefList;
   RoadNumberRefList = coRef.RoadNumberRefList;
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
fi_tcl_RoadNumberListSet& fi_tcl_RoadNumberListSet::operator=(const fi_tcl_RoadNumberListSet& coRef)
{
   if (this == &coRef) return *this;
   ElementRefList = coRef.ElementRefList;
   AlternativRefList = coRef.AlternativRefList;
   RoadNumberRefList = coRef.RoadNumberRefList;
   return *this;
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
tVoid fi_tcl_RoadNumberListSet::vDestroy()
{
   ElementRefList.clear();
   {
      for (tU32 u32Idx = 0; u32Idx < AlternativRefList.size(); ++u32Idx)
         AlternativRefList[u32Idx].vDestroy();
   }
   AlternativRefList.clear();
   {
      for (tU32 u32Idx = 0; u32Idx < RoadNumberRefList.size(); ++u32Idx)
         RoadNumberRefList[u32Idx].vDestroy();
   }
   RoadNumberRefList.clear();
}

tU32 fi_tcl_RoadNumberListSet::u32GetSize(tU16 u16MajorVersion) const
{
   tU32 u32DynamicSize = 0;
   tU32 u32ListIdx;
   for (u32ListIdx = 0; u32ListIdx < RoadNumberRefList.size(); ++u32ListIdx)
      u32DynamicSize += RoadNumberRefList[u32ListIdx].u32GetSize(u16MajorVersion);
   return u32DynamicSize+12+ElementRefList.size()*2+AlternativRefList.size()*4;
}

tBool fi_tcl_RoadNumberListSet::operator==(const fi_tcl_RoadNumberListSet& rfoCmp) const
{
   tBool bResult = true;
      bResult = bResult && (ElementRefList.size() == rfoCmp.ElementRefList.size());
      if (bResult)
      {
         for (tU32 u32Idx = 0; bResult && (u32Idx < ElementRefList.size()); ++u32Idx)
            bResult = bResult && (ElementRefList[u32Idx] == rfoCmp.ElementRefList[u32Idx]);
      }
      bResult = bResult && (AlternativRefList.size() == rfoCmp.AlternativRefList.size());
      if (bResult)
      {
         for (tU32 u32Idx = 0; bResult && (u32Idx < AlternativRefList.size()); ++u32Idx)
            bResult = bResult && (AlternativRefList[u32Idx] == rfoCmp.AlternativRefList[u32Idx]);
      }
      bResult = bResult && (RoadNumberRefList.size() == rfoCmp.RoadNumberRefList.size());
      if (bResult)
      {
         for (tU32 u32Idx = 0; bResult && (u32Idx < RoadNumberRefList.size()); ++u32Idx)
            bResult = bResult && (RoadNumberRefList[u32Idx] == rfoCmp.RoadNumberRefList[u32Idx]);
      }
   return bResult;
}

fi_tclInContext& fi_tcl_RoadNumberListSet::oRead(fi_tclInContext& oIn)
{
   {
      tU32 u32Length;
      tU32 u32Idx;
      oIn >> u32Length;
      ElementRefList.resize(u32Length);
      for (u32Idx = 0; u32Idx < u32Length; ++u32Idx)
      {
         oIn >> ElementRefList[u32Idx];
      }
   }
   {
      tU32 u32Length;
      tU32 u32Idx;
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
      for (u32Idx = 0; u32Idx < AlternativRefList.size(); ++u32Idx)
      {
         AlternativRefList[u32Idx].vDestroy();
      }
#endif // !VARIANT_S_FTR_ENABLE_DEEP_COPY
      oIn >> u32Length;
      AlternativRefList.resize(u32Length);
      for (u32Idx = 0; u32Idx < u32Length; ++u32Idx)
      {
         oIn >> AlternativRefList[u32Idx];
      }
   }
   {
      tU32 u32Length;
      tU32 u32Idx;
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
      for (u32Idx = 0; u32Idx < RoadNumberRefList.size(); ++u32Idx)
      {
         RoadNumberRefList[u32Idx].vDestroy();
      }
#endif // !VARIANT_S_FTR_ENABLE_DEEP_COPY
      oIn >> u32Length;
      RoadNumberRefList.resize(u32Length);
      for (u32Idx = 0; u32Idx < u32Length; ++u32Idx)
      {
         oIn >> RoadNumberRefList[u32Idx];
      }
   }
   return oIn;
}

fi_tclOutContext& fi_tcl_RoadNumberListSet::oWrite(fi_tclOutContext& oOut) const
{
   oOut << (tU32)ElementRefList.size();
   {
      for (tU32 u32Idx = 0; u32Idx < ElementRefList.size(); ++u32Idx)
         oOut << ElementRefList[u32Idx];
   }
   oOut << (tU32)AlternativRefList.size();
   {
      for (tU32 u32Idx = 0; u32Idx < AlternativRefList.size(); ++u32Idx)
         oOut << AlternativRefList[u32Idx];
   }
   oOut << (tU32)RoadNumberRefList.size();
   {
      for (tU32 u32Idx = 0; u32Idx < RoadNumberRefList.size(); ++u32Idx)
         oOut << RoadNumberRefList[u32Idx];
   }
   return oOut;
}

tU32 fi_tcl_b16_RoadAttribute::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 2;
}

tBool fi_tcl_b16_RoadAttribute::operator==(const fi_tcl_b16_RoadAttribute& rfoCmp) const
{
   return u16Value == rfoCmp.u16Value;
}

fi_tclInContext& fi_tcl_b16_RoadAttribute::oRead(fi_tclInContext& oIn)
{
   return oIn >> u16Value;
}

fi_tclOutContext& fi_tcl_b16_RoadAttribute::oWrite(fi_tclOutContext& oOut) const
{
   return oOut << u16Value;
}

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
fi_tcl_EDMOneCell::fi_tcl_EDMOneCell(const fi_tcl_EDMOneCell& coRef):fi_tclVisitableTypeBase(coRef)
{
   OneCellId = coRef.OneCellId;
   IndexInClusterList = coRef.IndexInClusterList;
   OCProperties = coRef.OCProperties;
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
fi_tcl_EDMOneCell& fi_tcl_EDMOneCell::operator=(const fi_tcl_EDMOneCell& coRef)
{
   if (this == &coRef) return *this;
   OneCellId = coRef.OneCellId;
   IndexInClusterList = coRef.IndexInClusterList;
   OCProperties = coRef.OCProperties;
   return *this;
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
tVoid fi_tcl_EDMOneCell::vDestroy()
{
   OCProperties.vDestroy(); 
}

tU32 fi_tcl_EDMOneCell::u32GetSize(tU16 u16MajorVersion) const
{
   return 4+OCProperties.u32GetSize(u16MajorVersion);
}

tBool fi_tcl_EDMOneCell::operator==(const fi_tcl_EDMOneCell& rfoCmp) const
{
   tBool bResult = true;
      bResult = bResult && (OneCellId == rfoCmp.OneCellId);
      bResult = bResult && (IndexInClusterList == rfoCmp.IndexInClusterList);
      bResult = bResult && (OCProperties == rfoCmp.OCProperties);
   return bResult;
}

fi_tclInContext& fi_tcl_EDMOneCell::oRead(fi_tclInContext& oIn)
{
   oIn >> OneCellId;
   oIn >> IndexInClusterList;
   oIn >> OCProperties;
   return oIn;
}

fi_tclOutContext& fi_tcl_EDMOneCell::oWrite(fi_tclOutContext& oOut) const
{
   oOut << OneCellId;
   oOut << IndexInClusterList;
   oOut << OCProperties;
   return oOut;
}

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
fi_tcl_NavPosOnecellSectionDescription::fi_tcl_NavPosOnecellSectionDescription(const fi_tcl_NavPosOnecellSectionDescription& coRef):fi_tclVisitableTypeBase(coRef)
{
   Cluster = coRef.Cluster;
   OneCell = coRef.OneCell;
   OneCellProperty = coRef.OneCellProperty;
   SectionIndex = coRef.SectionIndex;
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
fi_tcl_NavPosOnecellSectionDescription& fi_tcl_NavPosOnecellSectionDescription::operator=(const fi_tcl_NavPosOnecellSectionDescription& coRef)
{
   if (this == &coRef) return *this;
   Cluster = coRef.Cluster;
   OneCell = coRef.OneCell;
   OneCellProperty = coRef.OneCellProperty;
   SectionIndex = coRef.SectionIndex;
   return *this;
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
tVoid fi_tcl_NavPosOnecellSectionDescription::vDestroy()
{
   Cluster.vDestroy(); 
   OneCell.vDestroy(); 
   OneCellProperty.vDestroy(); 
}

tU32 fi_tcl_NavPosOnecellSectionDescription::u32GetSize(tU16 u16MajorVersion) const
{
   return 16+OneCellProperty.u32GetSize(u16MajorVersion);
}

tBool fi_tcl_NavPosOnecellSectionDescription::operator==(const fi_tcl_NavPosOnecellSectionDescription& rfoCmp) const
{
   tBool bResult = true;
      bResult = bResult && (Cluster == rfoCmp.Cluster);
      bResult = bResult && (OneCell == rfoCmp.OneCell);
      bResult = bResult && (OneCellProperty == rfoCmp.OneCellProperty);
      bResult = bResult && (SectionIndex == rfoCmp.SectionIndex);
   return bResult;
}

fi_tclInContext& fi_tcl_NavPosOnecellSectionDescription::oRead(fi_tclInContext& oIn)
{
   oIn >> Cluster;
   oIn >> OneCell;
   oIn >> OneCellProperty;
   oIn >> SectionIndex;
   return oIn;
}

fi_tclOutContext& fi_tcl_NavPosOnecellSectionDescription::oWrite(fi_tclOutContext& oOut) const
{
   oOut << Cluster;
   oOut << OneCell;
   oOut << OneCellProperty;
   oOut << SectionIndex;
   return oOut;
}

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
fi_tcl_EntryPoint::fi_tcl_EntryPoint(const fi_tcl_EntryPoint& coRef):fi_tclVisitableTypeBase(coRef)
{
   EntryPointStatus = coRef.EntryPointStatus;
   PositionCoord = coRef.PositionCoord;
   MapAngle = coRef.MapAngle;
   OnecellSection = coRef.OnecellSection;
   LengthToOnecellEnd = coRef.LengthToOnecellEnd;
   ResistanceManipulator = coRef.ResistanceManipulator;
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
fi_tcl_EntryPoint& fi_tcl_EntryPoint::operator=(const fi_tcl_EntryPoint& coRef)
{
   if (this == &coRef) return *this;
   EntryPointStatus = coRef.EntryPointStatus;
   PositionCoord = coRef.PositionCoord;
   MapAngle = coRef.MapAngle;
   OnecellSection = coRef.OnecellSection;
   LengthToOnecellEnd = coRef.LengthToOnecellEnd;
   ResistanceManipulator = coRef.ResistanceManipulator;
   return *this;
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
tVoid fi_tcl_EntryPoint::vDestroy()
{
   PositionCoord.vDestroy(); 
   OnecellSection.vDestroy(); 
}

tU32 fi_tcl_EntryPoint::u32GetSize(tU16 u16MajorVersion) const
{
   return 19+OnecellSection.u32GetSize(u16MajorVersion);
}

tBool fi_tcl_EntryPoint::operator==(const fi_tcl_EntryPoint& rfoCmp) const
{
   tBool bResult = true;
      bResult = bResult && (EntryPointStatus == rfoCmp.EntryPointStatus);
      bResult = bResult && (PositionCoord == rfoCmp.PositionCoord);
      bResult = bResult && (MapAngle == rfoCmp.MapAngle);
      bResult = bResult && (OnecellSection == rfoCmp.OnecellSection);
      bResult = bResult && (LengthToOnecellEnd == rfoCmp.LengthToOnecellEnd);
      bResult = bResult && (ResistanceManipulator == rfoCmp.ResistanceManipulator);
   return bResult;
}

fi_tclInContext& fi_tcl_EntryPoint::oRead(fi_tclInContext& oIn)
{
   oIn >> EntryPointStatus;
   oIn >> PositionCoord;
   oIn >> MapAngle;
   oIn >> OnecellSection;
   oIn >> LengthToOnecellEnd;
   oIn >> ResistanceManipulator;
   return oIn;
}

fi_tclOutContext& fi_tcl_EntryPoint::oWrite(fi_tclOutContext& oOut) const
{
   oOut << EntryPointStatus;
   oOut << PositionCoord;
   oOut << MapAngle;
   oOut << OnecellSection;
   oOut << LengthToOnecellEnd;
   oOut << ResistanceManipulator;
   return oOut;
}

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
fi_tcl_PositionDescription::fi_tcl_PositionDescription(const fi_tcl_PositionDescription& coRef):fi_tclVisitableTypeBase(coRef)
{
   PositionCoord = coRef.PositionCoord;
   OnecellSection = coRef.OnecellSection;
   LengthToIntersection = coRef.LengthToIntersection;
   Icourse = coRef.Icourse;
   MapAngle = coRef.MapAngle;
   IndexInHorizon = coRef.IndexInHorizon;
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
fi_tcl_PositionDescription& fi_tcl_PositionDescription::operator=(const fi_tcl_PositionDescription& coRef)
{
   if (this == &coRef) return *this;
   PositionCoord = coRef.PositionCoord;
   OnecellSection = coRef.OnecellSection;
   LengthToIntersection = coRef.LengthToIntersection;
   Icourse = coRef.Icourse;
   MapAngle = coRef.MapAngle;
   IndexInHorizon = coRef.IndexInHorizon;
   return *this;
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
tVoid fi_tcl_PositionDescription::vDestroy()
{
   PositionCoord.vDestroy(); 
   OnecellSection.vDestroy(); 
}

tU32 fi_tcl_PositionDescription::u32GetSize(tU16 u16MajorVersion) const
{
   tU32 u32DynamicSize = 0;
   if (9 <= u16MajorVersion)
   {
      u32DynamicSize += 2;
   }
   return u32DynamicSize+16+OnecellSection.u32GetSize(u16MajorVersion);
}

tBool fi_tcl_PositionDescription::operator==(const fi_tcl_PositionDescription& rfoCmp) const
{
   tBool bResult = true;
      bResult = bResult && (PositionCoord == rfoCmp.PositionCoord);
      bResult = bResult && (OnecellSection == rfoCmp.OnecellSection);
      bResult = bResult && (LengthToIntersection == rfoCmp.LengthToIntersection);
      bResult = bResult && (Icourse == rfoCmp.Icourse);
      bResult = bResult && (MapAngle == rfoCmp.MapAngle);
      bResult = bResult && (IndexInHorizon == rfoCmp.IndexInHorizon);
   return bResult;
}

fi_tclInContext& fi_tcl_PositionDescription::oRead(fi_tclInContext& oIn)
{
   oIn >> PositionCoord;
   oIn >> OnecellSection;
   oIn >> LengthToIntersection;
   oIn >> Icourse;
   oIn >> MapAngle;
   if (9 <= oIn.u16GetMajorVersion())
   {
      oIn >> IndexInHorizon;
   }
   return oIn;
}

fi_tclOutContext& fi_tcl_PositionDescription::oWrite(fi_tclOutContext& oOut) const
{
   oOut << PositionCoord;
   oOut << OnecellSection;
   oOut << LengthToIntersection;
   oOut << Icourse;
   oOut << MapAngle;
   if (9 <= oOut.u16GetMajorVersion())
   {
      oOut << IndexInHorizon;
   }
   return oOut;
}

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
fi_tcl_RoadAttributes::fi_tcl_RoadAttributes(const fi_tcl_RoadAttributes& coRef):fi_tclVisitableTypeBase(coRef)
{
   RoadClass = coRef.RoadClass;
   RoadProperty = coRef.RoadProperty;
   RoadType = coRef.RoadType;
   RoadNetworkClass = coRef.RoadNetworkClass;
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
fi_tcl_RoadAttributes& fi_tcl_RoadAttributes::operator=(const fi_tcl_RoadAttributes& coRef)
{
   if (this == &coRef) return *this;
   RoadClass = coRef.RoadClass;
   RoadProperty = coRef.RoadProperty;
   RoadType = coRef.RoadType;
   RoadNetworkClass = coRef.RoadNetworkClass;
   return *this;
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
tU32 fi_tcl_RoadAttributes::u32GetSize(tU16 u16MajorVersion) const
{
   tU32 u32DynamicSize = 0;
   if (9 <= u16MajorVersion)
   {
      u32DynamicSize += 1;
   }
   return u32DynamicSize+6;
}

tBool fi_tcl_RoadAttributes::operator==(const fi_tcl_RoadAttributes& rfoCmp) const
{
   tBool bResult = true;
      bResult = bResult && (RoadClass == rfoCmp.RoadClass);
      bResult = bResult && (RoadProperty == rfoCmp.RoadProperty);
      bResult = bResult && (RoadType == rfoCmp.RoadType);
      bResult = bResult && (RoadNetworkClass == rfoCmp.RoadNetworkClass);
   return bResult;
}

fi_tclInContext& fi_tcl_RoadAttributes::oRead(fi_tclInContext& oIn)
{
   oIn >> RoadClass;
   oIn >> RoadProperty;
   oIn >> RoadType;
   if (9 <= oIn.u16GetMajorVersion())
   {
      oIn >> RoadNetworkClass;
   }
   return oIn;
}

fi_tclOutContext& fi_tcl_RoadAttributes::oWrite(fi_tclOutContext& oOut) const
{
   oOut << RoadClass;
   oOut << RoadProperty;
   oOut << RoadType;
   if (9 <= oOut.u16GetMajorVersion())
   {
      oOut << RoadNetworkClass;
   }
   return oOut;
}

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
fi_tcl_RoadId::fi_tcl_RoadId(const fi_tcl_RoadId& coRef):fi_tclVisitableTypeBase(coRef)
{
   OneCellId = coRef.OneCellId;
   ClusterFileId = coRef.ClusterFileId;
   ClusterLength = coRef.ClusterLength;
   ClusterFileOffset = coRef.ClusterFileOffset;
   NavDataSetID = coRef.NavDataSetID;
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
fi_tcl_RoadId& fi_tcl_RoadId::operator=(const fi_tcl_RoadId& coRef)
{
   if (this == &coRef) return *this;
   OneCellId = coRef.OneCellId;
   ClusterFileId = coRef.ClusterFileId;
   ClusterLength = coRef.ClusterLength;
   ClusterFileOffset = coRef.ClusterFileOffset;
   NavDataSetID = coRef.NavDataSetID;
   return *this;
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
tU32 fi_tcl_RoadId::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 14;
}

tBool fi_tcl_RoadId::operator==(const fi_tcl_RoadId& rfoCmp) const
{
   tBool bResult = true;
      bResult = bResult && (OneCellId == rfoCmp.OneCellId);
      bResult = bResult && (ClusterFileId == rfoCmp.ClusterFileId);
      bResult = bResult && (ClusterLength == rfoCmp.ClusterLength);
      bResult = bResult && (ClusterFileOffset == rfoCmp.ClusterFileOffset);
      bResult = bResult && (NavDataSetID == rfoCmp.NavDataSetID);
   return bResult;
}

fi_tclInContext& fi_tcl_RoadId::oRead(fi_tclInContext& oIn)
{
   oIn >> OneCellId;
   oIn >> ClusterFileId;
   oIn >> ClusterLength;
   oIn >> ClusterFileOffset;
   oIn >> NavDataSetID;
   return oIn;
}

fi_tclOutContext& fi_tcl_RoadId::oWrite(fi_tclOutContext& oOut) const
{
   oOut << OneCellId;
   oOut << ClusterFileId;
   oOut << ClusterLength;
   oOut << ClusterFileOffset;
   oOut << NavDataSetID;
   return oOut;
}

tU32 fi_tcl_e8_ExtraDescElementType::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 1;
}

tBool fi_tcl_e8_ExtraDescElementType::operator==(const fi_tcl_e8_ExtraDescElementType& rfoCmp) const
{
   return enType == rfoCmp.enType;
}

fi_tclInContext& fi_tcl_e8_ExtraDescElementType::oRead(fi_tclInContext& oIn)
{
   tU8 u8Value;
   oIn >> u8Value;
   enType = (tenType)u8Value;
   return oIn;
}

fi_tclOutContext& fi_tcl_e8_ExtraDescElementType::oWrite(fi_tclOutContext& oOut) const
{
   return oOut.oWrite((tU8)enType);
}

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
fi_tcl_ExtraDescElement::fi_tcl_ExtraDescElement(const fi_tcl_ExtraDescElement& coRef):fi_tclVisitableTypeBase(coRef)
{
   Type = coRef.Type;
   ShortDescription = coRef.ShortDescription;
   LongDescription = coRef.LongDescription;
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
fi_tcl_ExtraDescElement& fi_tcl_ExtraDescElement::operator=(const fi_tcl_ExtraDescElement& coRef)
{
   if (this == &coRef) return *this;
   Type = coRef.Type;
   ShortDescription = coRef.ShortDescription;
   LongDescription = coRef.LongDescription;
   return *this;
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
tVoid fi_tcl_ExtraDescElement::vDestroy()
{
   ShortDescription.vDestroy();
   LongDescription.vDestroy();
}

tU32 fi_tcl_ExtraDescElement::u32GetSize(tU16 u16MajorVersion) const
{
   return 1+ShortDescription.u32GetSize(u16MajorVersion)+LongDescription.u32GetSize(u16MajorVersion);
}

tBool fi_tcl_ExtraDescElement::operator==(const fi_tcl_ExtraDescElement& rfoCmp) const
{
   tBool bResult = true;
      bResult = bResult && (Type == rfoCmp.Type);
      bResult = bResult && (ShortDescription == rfoCmp.ShortDescription);
      bResult = bResult && (LongDescription == rfoCmp.LongDescription);
   return bResult;
}

fi_tclInContext& fi_tcl_ExtraDescElement::oRead(fi_tclInContext& oIn)
{
   oIn >> Type;
   oIn >> ShortDescription;
   oIn >> LongDescription;
   return oIn;
}

fi_tclOutContext& fi_tcl_ExtraDescElement::oWrite(fi_tclOutContext& oOut) const
{
   oOut << Type;
   oOut << ShortDescription;
   oOut << LongDescription;
   return oOut;
}

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
fi_tcl_ExtraDescListSet::fi_tcl_ExtraDescListSet(const fi_tcl_ExtraDescListSet& coRef):fi_tclVisitableTypeBase(coRef)
{
   AlternativRefList = coRef.AlternativRefList;
   ExtraDescRefList = coRef.ExtraDescRefList;
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
fi_tcl_ExtraDescListSet& fi_tcl_ExtraDescListSet::operator=(const fi_tcl_ExtraDescListSet& coRef)
{
   if (this == &coRef) return *this;
   AlternativRefList = coRef.AlternativRefList;
   ExtraDescRefList = coRef.ExtraDescRefList;
   return *this;
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
tVoid fi_tcl_ExtraDescListSet::vDestroy()
{
   {
      for (tU32 u32Idx = 0; u32Idx < AlternativRefList.size(); ++u32Idx)
         AlternativRefList[u32Idx].vDestroy();
   }
   AlternativRefList.clear();
   {
      for (tU32 u32Idx = 0; u32Idx < ExtraDescRefList.size(); ++u32Idx)
         ExtraDescRefList[u32Idx].vDestroy();
   }
   ExtraDescRefList.clear();
}

tU32 fi_tcl_ExtraDescListSet::u32GetSize(tU16 u16MajorVersion) const
{
   tU32 u32DynamicSize = 0;
   tU32 u32ListIdx;
   for (u32ListIdx = 0; u32ListIdx < ExtraDescRefList.size(); ++u32ListIdx)
      u32DynamicSize += ExtraDescRefList[u32ListIdx].u32GetSize(u16MajorVersion);
   return u32DynamicSize+8+AlternativRefList.size()*4;
}

tBool fi_tcl_ExtraDescListSet::operator==(const fi_tcl_ExtraDescListSet& rfoCmp) const
{
   tBool bResult = true;
      bResult = bResult && (AlternativRefList.size() == rfoCmp.AlternativRefList.size());
      if (bResult)
      {
         for (tU32 u32Idx = 0; bResult && (u32Idx < AlternativRefList.size()); ++u32Idx)
            bResult = bResult && (AlternativRefList[u32Idx] == rfoCmp.AlternativRefList[u32Idx]);
      }
      bResult = bResult && (ExtraDescRefList.size() == rfoCmp.ExtraDescRefList.size());
      if (bResult)
      {
         for (tU32 u32Idx = 0; bResult && (u32Idx < ExtraDescRefList.size()); ++u32Idx)
            bResult = bResult && (ExtraDescRefList[u32Idx] == rfoCmp.ExtraDescRefList[u32Idx]);
      }
   return bResult;
}

fi_tclInContext& fi_tcl_ExtraDescListSet::oRead(fi_tclInContext& oIn)
{
   {
      tU32 u32Length;
      tU32 u32Idx;
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
      for (u32Idx = 0; u32Idx < AlternativRefList.size(); ++u32Idx)
      {
         AlternativRefList[u32Idx].vDestroy();
      }
#endif // !VARIANT_S_FTR_ENABLE_DEEP_COPY
      oIn >> u32Length;
      AlternativRefList.resize(u32Length);
      for (u32Idx = 0; u32Idx < u32Length; ++u32Idx)
      {
         oIn >> AlternativRefList[u32Idx];
      }
   }
   {
      tU32 u32Length;
      tU32 u32Idx;
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
      for (u32Idx = 0; u32Idx < ExtraDescRefList.size(); ++u32Idx)
      {
         ExtraDescRefList[u32Idx].vDestroy();
      }
#endif // !VARIANT_S_FTR_ENABLE_DEEP_COPY
      oIn >> u32Length;
      ExtraDescRefList.resize(u32Length);
      for (u32Idx = 0; u32Idx < u32Length; ++u32Idx)
      {
         oIn >> ExtraDescRefList[u32Idx];
      }
   }
   return oIn;
}

fi_tclOutContext& fi_tcl_ExtraDescListSet::oWrite(fi_tclOutContext& oOut) const
{
   oOut << (tU32)AlternativRefList.size();
   {
      for (tU32 u32Idx = 0; u32Idx < AlternativRefList.size(); ++u32Idx)
         oOut << AlternativRefList[u32Idx];
   }
   oOut << (tU32)ExtraDescRefList.size();
   {
      for (tU32 u32Idx = 0; u32Idx < ExtraDescRefList.size(); ++u32Idx)
         oOut << ExtraDescRefList[u32Idx];
   }
   return oOut;
}

tU32 fi_tcl_b32_DataProperties::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 4;
}

tBool fi_tcl_b32_DataProperties::operator==(const fi_tcl_b32_DataProperties& rfoCmp) const
{
   return u32Value == rfoCmp.u32Value;
}

fi_tclInContext& fi_tcl_b32_DataProperties::oRead(fi_tclInContext& oIn)
{
   return oIn >> u32Value;
}

fi_tclOutContext& fi_tcl_b32_DataProperties::oWrite(fi_tclOutContext& oOut) const
{
   return oOut << u32Value;
}

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
fi_tcl_DataDescElement::fi_tcl_DataDescElement(const fi_tcl_DataDescElement& coRef):fi_tclVisitableTypeBase(coRef)
{
   RNWDataProperties = coRef.RNWDataProperties;
   CandyProductCode = coRef.CandyProductCode;
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
fi_tcl_DataDescElement& fi_tcl_DataDescElement::operator=(const fi_tcl_DataDescElement& coRef)
{
   if (this == &coRef) return *this;
   RNWDataProperties = coRef.RNWDataProperties;
   CandyProductCode = coRef.CandyProductCode;
   return *this;
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
tU32 fi_tcl_DataDescElement::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 8;
}

tBool fi_tcl_DataDescElement::operator==(const fi_tcl_DataDescElement& rfoCmp) const
{
   tBool bResult = true;
      bResult = bResult && (RNWDataProperties == rfoCmp.RNWDataProperties);
      bResult = bResult && (CandyProductCode == rfoCmp.CandyProductCode);
   return bResult;
}

fi_tclInContext& fi_tcl_DataDescElement::oRead(fi_tclInContext& oIn)
{
   oIn >> RNWDataProperties;
   oIn >> CandyProductCode;
   return oIn;
}

fi_tclOutContext& fi_tcl_DataDescElement::oWrite(fi_tclOutContext& oOut) const
{
   oOut << RNWDataProperties;
   oOut << CandyProductCode;
   return oOut;
}

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
fi_tcl_DataDescListSet::fi_tcl_DataDescListSet(const fi_tcl_DataDescListSet& coRef):fi_tclVisitableTypeBase(coRef)
{
   ElementRefList = coRef.ElementRefList;
   AlternativRefList = coRef.AlternativRefList;
   DataDescRefList = coRef.DataDescRefList;
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
fi_tcl_DataDescListSet& fi_tcl_DataDescListSet::operator=(const fi_tcl_DataDescListSet& coRef)
{
   if (this == &coRef) return *this;
   ElementRefList = coRef.ElementRefList;
   AlternativRefList = coRef.AlternativRefList;
   DataDescRefList = coRef.DataDescRefList;
   return *this;
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
tVoid fi_tcl_DataDescListSet::vDestroy()
{
   ElementRefList.clear();
   {
      for (tU32 u32Idx = 0; u32Idx < AlternativRefList.size(); ++u32Idx)
         AlternativRefList[u32Idx].vDestroy();
   }
   AlternativRefList.clear();
   {
      for (tU32 u32Idx = 0; u32Idx < DataDescRefList.size(); ++u32Idx)
         DataDescRefList[u32Idx].vDestroy();
   }
   DataDescRefList.clear();
}

tU32 fi_tcl_DataDescListSet::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 12+ElementRefList.size()*2+AlternativRefList.size()*4+DataDescRefList.size()*8;
}

tBool fi_tcl_DataDescListSet::operator==(const fi_tcl_DataDescListSet& rfoCmp) const
{
   tBool bResult = true;
      bResult = bResult && (ElementRefList.size() == rfoCmp.ElementRefList.size());
      if (bResult)
      {
         for (tU32 u32Idx = 0; bResult && (u32Idx < ElementRefList.size()); ++u32Idx)
            bResult = bResult && (ElementRefList[u32Idx] == rfoCmp.ElementRefList[u32Idx]);
      }
      bResult = bResult && (AlternativRefList.size() == rfoCmp.AlternativRefList.size());
      if (bResult)
      {
         for (tU32 u32Idx = 0; bResult && (u32Idx < AlternativRefList.size()); ++u32Idx)
            bResult = bResult && (AlternativRefList[u32Idx] == rfoCmp.AlternativRefList[u32Idx]);
      }
      bResult = bResult && (DataDescRefList.size() == rfoCmp.DataDescRefList.size());
      if (bResult)
      {
         for (tU32 u32Idx = 0; bResult && (u32Idx < DataDescRefList.size()); ++u32Idx)
            bResult = bResult && (DataDescRefList[u32Idx] == rfoCmp.DataDescRefList[u32Idx]);
      }
   return bResult;
}

fi_tclInContext& fi_tcl_DataDescListSet::oRead(fi_tclInContext& oIn)
{
   {
      tU32 u32Length;
      tU32 u32Idx;
      oIn >> u32Length;
      ElementRefList.resize(u32Length);
      for (u32Idx = 0; u32Idx < u32Length; ++u32Idx)
      {
         oIn >> ElementRefList[u32Idx];
      }
   }
   {
      tU32 u32Length;
      tU32 u32Idx;
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
      for (u32Idx = 0; u32Idx < AlternativRefList.size(); ++u32Idx)
      {
         AlternativRefList[u32Idx].vDestroy();
      }
#endif // !VARIANT_S_FTR_ENABLE_DEEP_COPY
      oIn >> u32Length;
      AlternativRefList.resize(u32Length);
      for (u32Idx = 0; u32Idx < u32Length; ++u32Idx)
      {
         oIn >> AlternativRefList[u32Idx];
      }
   }
   {
      tU32 u32Length;
      tU32 u32Idx;
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
      for (u32Idx = 0; u32Idx < DataDescRefList.size(); ++u32Idx)
      {
         DataDescRefList[u32Idx].vDestroy();
      }
#endif // !VARIANT_S_FTR_ENABLE_DEEP_COPY
      oIn >> u32Length;
      DataDescRefList.resize(u32Length);
      for (u32Idx = 0; u32Idx < u32Length; ++u32Idx)
      {
         oIn >> DataDescRefList[u32Idx];
      }
   }
   return oIn;
}

fi_tclOutContext& fi_tcl_DataDescListSet::oWrite(fi_tclOutContext& oOut) const
{
   oOut << (tU32)ElementRefList.size();
   {
      for (tU32 u32Idx = 0; u32Idx < ElementRefList.size(); ++u32Idx)
         oOut << ElementRefList[u32Idx];
   }
   oOut << (tU32)AlternativRefList.size();
   {
      for (tU32 u32Idx = 0; u32Idx < AlternativRefList.size(); ++u32Idx)
         oOut << AlternativRefList[u32Idx];
   }
   oOut << (tU32)DataDescRefList.size();
   {
      for (tU32 u32Idx = 0; u32Idx < DataDescRefList.size(); ++u32Idx)
         oOut << DataDescRefList[u32Idx];
   }
   return oOut;
}

tU32 fi_tcl_b8_CrossroadProperties::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 1;
}

tBool fi_tcl_b8_CrossroadProperties::operator==(const fi_tcl_b8_CrossroadProperties& rfoCmp) const
{
   return u8Value == rfoCmp.u8Value;
}

fi_tclInContext& fi_tcl_b8_CrossroadProperties::oRead(fi_tclInContext& oIn)
{
   return oIn >> u8Value;
}

fi_tclOutContext& fi_tcl_b8_CrossroadProperties::oWrite(fi_tclOutContext& oOut) const
{
   return oOut << u8Value;
}

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
fi_tcl_CrossroadDesc::fi_tcl_CrossroadDesc(const fi_tcl_CrossroadDesc& coRef):fi_tclVisitableTypeBase(coRef)
{
   IsDirectionValid = coRef.IsDirectionValid;
   Direction = coRef.Direction;
   DirectionOfConnectedElement = coRef.DirectionOfConnectedElement;
   CrossroadProperty = coRef.CrossroadProperty;
   CrossroadInfoRefElement = coRef.CrossroadInfoRefElement;
   CrossroadAttributes = coRef.CrossroadAttributes;
   IndexOfTwinElement = coRef.IndexOfTwinElement;
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
fi_tcl_CrossroadDesc& fi_tcl_CrossroadDesc::operator=(const fi_tcl_CrossroadDesc& coRef)
{
   if (this == &coRef) return *this;
   IsDirectionValid = coRef.IsDirectionValid;
   Direction = coRef.Direction;
   DirectionOfConnectedElement = coRef.DirectionOfConnectedElement;
   CrossroadProperty = coRef.CrossroadProperty;
   CrossroadInfoRefElement = coRef.CrossroadInfoRefElement;
   CrossroadAttributes = coRef.CrossroadAttributes;
   IndexOfTwinElement = coRef.IndexOfTwinElement;
   return *this;
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
tVoid fi_tcl_CrossroadDesc::vDestroy()
{
   CrossroadAttributes.vDestroy(); 
}

tU32 fi_tcl_CrossroadDesc::u32GetSize(tU16 u16MajorVersion) const
{
   tU32 u32DynamicSize = 0;
   if (9 <= u16MajorVersion)
   {
      u32DynamicSize += 1;
   }
   if (9 <= u16MajorVersion)
   {
      u32DynamicSize += CrossroadAttributes.u32GetSize(u16MajorVersion);
   }
   if (9 <= u16MajorVersion)
   {
      u32DynamicSize += 2;
   }
   return u32DynamicSize+5;
}

tBool fi_tcl_CrossroadDesc::operator==(const fi_tcl_CrossroadDesc& rfoCmp) const
{
   tBool bResult = true;
      bResult = bResult && (IsDirectionValid == rfoCmp.IsDirectionValid);
      bResult = bResult && (Direction == rfoCmp.Direction);
      bResult = bResult && (DirectionOfConnectedElement == rfoCmp.DirectionOfConnectedElement);
      bResult = bResult && (CrossroadProperty == rfoCmp.CrossroadProperty);
      bResult = bResult && (CrossroadInfoRefElement == rfoCmp.CrossroadInfoRefElement);
      bResult = bResult && (CrossroadAttributes == rfoCmp.CrossroadAttributes);
      bResult = bResult && (IndexOfTwinElement == rfoCmp.IndexOfTwinElement);
   return bResult;
}

fi_tclInContext& fi_tcl_CrossroadDesc::oRead(fi_tclInContext& oIn)
{
   oIn >> IsDirectionValid;
   oIn >> Direction;
   if (9 <= oIn.u16GetMajorVersion())
   {
      oIn >> DirectionOfConnectedElement;
   }
   oIn >> CrossroadProperty;
   oIn >> CrossroadInfoRefElement;
   if (9 <= oIn.u16GetMajorVersion())
   {
      oIn >> CrossroadAttributes;
   }
   if (9 <= oIn.u16GetMajorVersion())
   {
      oIn >> IndexOfTwinElement;
   }
   return oIn;
}

fi_tclOutContext& fi_tcl_CrossroadDesc::oWrite(fi_tclOutContext& oOut) const
{
   oOut << IsDirectionValid;
   oOut << Direction;
   if (9 <= oOut.u16GetMajorVersion())
   {
      oOut << DirectionOfConnectedElement;
   }
   oOut << CrossroadProperty;
   oOut << CrossroadInfoRefElement;
   if (9 <= oOut.u16GetMajorVersion())
   {
      oOut << CrossroadAttributes;
   }
   if (9 <= oOut.u16GetMajorVersion())
   {
      oOut << IndexOfTwinElement;
   }
   return oOut;
}

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
fi_tcl_CrossroadInfo::fi_tcl_CrossroadInfo(const fi_tcl_CrossroadInfo& coRef):fi_tclVisitableTypeBase(coRef)
{
   CrossroadInfoType = coRef.CrossroadInfoType;
   if  (coRef.poCrossroadInfoData)
   {
      switch(CrossroadInfoType.enType)
      {
      case fi_tcl_e8_CrossroadInfoCategory::FI_EN_T_RESERVED:
         poCrossroadInfoData = OSAL_NEW fi_tcl_Reserved((const fi_tcl_Reserved&)*coRef.poCrossroadInfoData);
         break;
      case fi_tcl_e8_CrossroadInfoCategory::FI_EN_T_ROADNAMELISTSET:
         poCrossroadInfoData = OSAL_NEW fi_tcl_RoadNameListSet((const fi_tcl_RoadNameListSet&)*coRef.poCrossroadInfoData);
         break;
      case fi_tcl_e8_CrossroadInfoCategory::FI_EN_T_ROADNUMBERLISTSET:
         poCrossroadInfoData = OSAL_NEW fi_tcl_RoadNumberListSet((const fi_tcl_RoadNumberListSet&)*coRef.poCrossroadInfoData);
         break;
      default:
         poCrossroadInfoData = OSAL_NULL;
      }
   }
   else
   {
      poCrossroadInfoData = OSAL_NULL;
   }
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
fi_tcl_CrossroadInfo& fi_tcl_CrossroadInfo::operator=(const fi_tcl_CrossroadInfo& coRef)
{
   if (this == &coRef) return *this;
   OSAL_DELETE poCrossroadInfoData;
   CrossroadInfoType = coRef.CrossroadInfoType;
   if  (coRef.poCrossroadInfoData)
   {
      switch(CrossroadInfoType.enType)
      {
      case fi_tcl_e8_CrossroadInfoCategory::FI_EN_T_RESERVED:
         poCrossroadInfoData = OSAL_NEW fi_tcl_Reserved((const fi_tcl_Reserved&)*coRef.poCrossroadInfoData);
         break;
      case fi_tcl_e8_CrossroadInfoCategory::FI_EN_T_ROADNAMELISTSET:
         poCrossroadInfoData = OSAL_NEW fi_tcl_RoadNameListSet((const fi_tcl_RoadNameListSet&)*coRef.poCrossroadInfoData);
         break;
      case fi_tcl_e8_CrossroadInfoCategory::FI_EN_T_ROADNUMBERLISTSET:
         poCrossroadInfoData = OSAL_NEW fi_tcl_RoadNumberListSet((const fi_tcl_RoadNumberListSet&)*coRef.poCrossroadInfoData);
         break;
      default:
         poCrossroadInfoData = OSAL_NULL;
      }
   }
   else
   {
      poCrossroadInfoData = OSAL_NULL;
   }
   return *this;
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
fi_tcl_CrossroadInfo::~fi_tcl_CrossroadInfo()
{
   OSAL_DELETE poCrossroadInfoData;
   poCrossroadInfoData = OSAL_NULL;
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
tVoid fi_tcl_CrossroadInfo::vDestroy()
{
   if (poCrossroadInfoData)
   {
      poCrossroadInfoData->vDestroy();
      OSAL_DELETE poCrossroadInfoData;
      poCrossroadInfoData = OSAL_NULL;
   }
}

tU32 fi_tcl_CrossroadInfo::u32GetSize(tU16 u16MajorVersion) const
{
   return 1+(poCrossroadInfoData?poCrossroadInfoData->u32GetSize(u16MajorVersion):0);
}

tBool fi_tcl_CrossroadInfo::operator==(const fi_tcl_CrossroadInfo& rfoCmp) const
{
   tBool bResult = true;
   bResult = bResult && (CrossroadInfoType == rfoCmp.CrossroadInfoType);
   if (bResult && poCrossroadInfoData && rfoCmp.poCrossroadInfoData) 
   {
      switch (CrossroadInfoType.enType)
      {
      case fi_tcl_e8_CrossroadInfoCategory::FI_EN_T_RESERVED:
         bResult = bResult && (*(const fi_tcl_Reserved*)poCrossroadInfoData == *(const fi_tcl_Reserved*)rfoCmp.poCrossroadInfoData); //lint !e826
      break;
      case fi_tcl_e8_CrossroadInfoCategory::FI_EN_T_ROADNAMELISTSET:
         bResult = bResult && (*(const fi_tcl_RoadNameListSet*)poCrossroadInfoData == *(const fi_tcl_RoadNameListSet*)rfoCmp.poCrossroadInfoData); //lint !e826
      break;
      case fi_tcl_e8_CrossroadInfoCategory::FI_EN_T_ROADNUMBERLISTSET:
         bResult = bResult && (*(const fi_tcl_RoadNumberListSet*)poCrossroadInfoData == *(const fi_tcl_RoadNumberListSet*)rfoCmp.poCrossroadInfoData); //lint !e826
      break;
      }
   }
   else
   {
      bResult = bResult && (poCrossroadInfoData == rfoCmp.poCrossroadInfoData);
   }
   return bResult;
}

fi_tclInContext& fi_tcl_CrossroadInfo::oRead(fi_tclInContext& oIn)
{
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   OSAL_DELETE poCrossroadInfoData;
#else
   if (poCrossroadInfoData)
   {
      poCrossroadInfoData->vDestroy();
      OSAL_DELETE poCrossroadInfoData;
   }
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
   oIn >> CrossroadInfoType;
   switch(CrossroadInfoType.enType)
   {
   case fi_tcl_e8_CrossroadInfoCategory::FI_EN_T_RESERVED:
      poCrossroadInfoData = OSAL_NEW fi_tcl_Reserved;
      break;
   case fi_tcl_e8_CrossroadInfoCategory::FI_EN_T_ROADNAMELISTSET:
      poCrossroadInfoData = OSAL_NEW fi_tcl_RoadNameListSet;
      break;
   case fi_tcl_e8_CrossroadInfoCategory::FI_EN_T_ROADNUMBERLISTSET:
      poCrossroadInfoData = OSAL_NEW fi_tcl_RoadNumberListSet;
      break;
   default:
      oIn.Invalidate();
      poCrossroadInfoData = OSAL_NULL;
   }
   if (poCrossroadInfoData && oIn.bIsValid())
      poCrossroadInfoData->oRead(oIn);
   else
      oIn.Invalidate();
   return oIn;
}

fi_tclOutContext& fi_tcl_CrossroadInfo::oWrite(fi_tclOutContext& oOut) const
{
   oOut << CrossroadInfoType;
   if (poCrossroadInfoData)
   {
      poCrossroadInfoData->oWrite(oOut);
   }
   else
   {
      oOut.Invalidate();
   }
   return oOut;
}

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
fi_tcl_IntersectionDenotation::fi_tcl_IntersectionDenotation(const fi_tcl_IntersectionDenotation& coRef):fi_tclVisitableTypeBase(coRef)
{
   IntersectionNumber = coRef.IntersectionNumber;
   IntersectionNamePrefix = coRef.IntersectionNamePrefix;
   IntersectionNameBody = coRef.IntersectionNameBody;
   IntersectionNameSuffix = coRef.IntersectionNameSuffix;
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
fi_tcl_IntersectionDenotation& fi_tcl_IntersectionDenotation::operator=(const fi_tcl_IntersectionDenotation& coRef)
{
   if (this == &coRef) return *this;
   IntersectionNumber = coRef.IntersectionNumber;
   IntersectionNamePrefix = coRef.IntersectionNamePrefix;
   IntersectionNameBody = coRef.IntersectionNameBody;
   IntersectionNameSuffix = coRef.IntersectionNameSuffix;
   return *this;
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
tVoid fi_tcl_IntersectionDenotation::vDestroy()
{
   IntersectionNumber.vDestroy(); 
   IntersectionNamePrefix.vDestroy();
   IntersectionNameBody.vDestroy();
   IntersectionNameSuffix.vDestroy();
}

tU32 fi_tcl_IntersectionDenotation::u32GetSize(tU16 u16MajorVersion) const
{
   return 0+IntersectionNumber.u32GetSize(u16MajorVersion)+IntersectionNamePrefix.u32GetSize(u16MajorVersion)+IntersectionNameBody.u32GetSize(u16MajorVersion)+IntersectionNameSuffix.u32GetSize(u16MajorVersion);
}

tBool fi_tcl_IntersectionDenotation::operator==(const fi_tcl_IntersectionDenotation& rfoCmp) const
{
   tBool bResult = true;
      bResult = bResult && (IntersectionNumber == rfoCmp.IntersectionNumber);
      bResult = bResult && (IntersectionNamePrefix == rfoCmp.IntersectionNamePrefix);
      bResult = bResult && (IntersectionNameBody == rfoCmp.IntersectionNameBody);
      bResult = bResult && (IntersectionNameSuffix == rfoCmp.IntersectionNameSuffix);
   return bResult;
}

fi_tclInContext& fi_tcl_IntersectionDenotation::oRead(fi_tclInContext& oIn)
{
   oIn >> IntersectionNumber;
   oIn >> IntersectionNamePrefix;
   oIn >> IntersectionNameBody;
   oIn >> IntersectionNameSuffix;
   return oIn;
}

fi_tclOutContext& fi_tcl_IntersectionDenotation::oWrite(fi_tclOutContext& oOut) const
{
   oOut << IntersectionNumber;
   oOut << IntersectionNamePrefix;
   oOut << IntersectionNameBody;
   oOut << IntersectionNameSuffix;
   return oOut;
}

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
fi_tcl_IntersectionPathDenotation::fi_tcl_IntersectionPathDenotation(const fi_tcl_IntersectionPathDenotation& coRef):fi_tclVisitableTypeBase(coRef)
{
   EntranceMask = coRef.EntranceMask;
   ExitMask = coRef.ExitMask;
   IntersectionDenotation = coRef.IntersectionDenotation;
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
fi_tcl_IntersectionPathDenotation& fi_tcl_IntersectionPathDenotation::operator=(const fi_tcl_IntersectionPathDenotation& coRef)
{
   if (this == &coRef) return *this;
   EntranceMask = coRef.EntranceMask;
   ExitMask = coRef.ExitMask;
   IntersectionDenotation = coRef.IntersectionDenotation;
   return *this;
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
tVoid fi_tcl_IntersectionPathDenotation::vDestroy()
{
   IntersectionDenotation.vDestroy(); 
}

tU32 fi_tcl_IntersectionPathDenotation::u32GetSize(tU16 u16MajorVersion) const
{
   return 8+IntersectionDenotation.u32GetSize(u16MajorVersion);
}

tBool fi_tcl_IntersectionPathDenotation::operator==(const fi_tcl_IntersectionPathDenotation& rfoCmp) const
{
   tBool bResult = true;
      bResult = bResult && (EntranceMask == rfoCmp.EntranceMask);
      bResult = bResult && (ExitMask == rfoCmp.ExitMask);
      bResult = bResult && (IntersectionDenotation == rfoCmp.IntersectionDenotation);
   return bResult;
}

fi_tclInContext& fi_tcl_IntersectionPathDenotation::oRead(fi_tclInContext& oIn)
{
   oIn >> EntranceMask;
   oIn >> ExitMask;
   oIn >> IntersectionDenotation;
   return oIn;
}

fi_tclOutContext& fi_tcl_IntersectionPathDenotation::oWrite(fi_tclOutContext& oOut) const
{
   oOut << EntranceMask;
   oOut << ExitMask;
   oOut << IntersectionDenotation;
   return oOut;
}

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
fi_tcl_IntersectionPathDesc::fi_tcl_IntersectionPathDesc(const fi_tcl_IntersectionPathDesc& coRef):fi_tclVisitableTypeBase(coRef)
{
   IntersectionType = coRef.IntersectionType;
   IntersectionDenotationList = coRef.IntersectionDenotationList;
   IntersectionDiameter = coRef.IntersectionDiameter;
   IntersectionCenterCoordinates = coRef.IntersectionCenterCoordinates;
   CrossroadList = coRef.CrossroadList;
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
fi_tcl_IntersectionPathDesc& fi_tcl_IntersectionPathDesc::operator=(const fi_tcl_IntersectionPathDesc& coRef)
{
   if (this == &coRef) return *this;
   IntersectionType = coRef.IntersectionType;
   IntersectionDenotationList = coRef.IntersectionDenotationList;
   IntersectionDiameter = coRef.IntersectionDiameter;
   IntersectionCenterCoordinates = coRef.IntersectionCenterCoordinates;
   CrossroadList = coRef.CrossroadList;
   return *this;
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
tVoid fi_tcl_IntersectionPathDesc::vDestroy()
{
   {
      for (tU32 u32Idx = 0; u32Idx < IntersectionDenotationList.size(); ++u32Idx)
         IntersectionDenotationList[u32Idx].vDestroy();
   }
   IntersectionDenotationList.clear();
   IntersectionCenterCoordinates.vDestroy(); 
   {
      for (tU32 u32Idx = 0; u32Idx < CrossroadList.size(); ++u32Idx)
         CrossroadList[u32Idx].vDestroy();
   }
   CrossroadList.clear();
}

tU32 fi_tcl_IntersectionPathDesc::u32GetSize(tU16 u16MajorVersion) const
{
   tU32 u32DynamicSize = 0;
   tU32 u32ListIdx;
   for (u32ListIdx = 0; u32ListIdx < IntersectionDenotationList.size(); ++u32ListIdx)
      u32DynamicSize += IntersectionDenotationList[u32ListIdx].u32GetSize(u16MajorVersion);
   if (9 <= u16MajorVersion)
   {
      u32DynamicSize += 4;
   }
   if (9 <= u16MajorVersion)
   {
      u32DynamicSize += 8;
   }
   for (u32ListIdx = 0; u32ListIdx < CrossroadList.size(); ++u32ListIdx)
      u32DynamicSize += CrossroadList[u32ListIdx].u32GetSize(u16MajorVersion);
   return u32DynamicSize+9;
}

tBool fi_tcl_IntersectionPathDesc::operator==(const fi_tcl_IntersectionPathDesc& rfoCmp) const
{
   tBool bResult = true;
      bResult = bResult && (IntersectionType == rfoCmp.IntersectionType);
      bResult = bResult && (IntersectionDenotationList.size() == rfoCmp.IntersectionDenotationList.size());
      if (bResult)
      {
         for (tU32 u32Idx = 0; bResult && (u32Idx < IntersectionDenotationList.size()); ++u32Idx)
            bResult = bResult && (IntersectionDenotationList[u32Idx] == rfoCmp.IntersectionDenotationList[u32Idx]);
      }
      bResult = bResult && (IntersectionDiameter == rfoCmp.IntersectionDiameter);
      bResult = bResult && (IntersectionCenterCoordinates == rfoCmp.IntersectionCenterCoordinates);
      bResult = bResult && (CrossroadList.size() == rfoCmp.CrossroadList.size());
      if (bResult)
      {
         for (tU32 u32Idx = 0; bResult && (u32Idx < CrossroadList.size()); ++u32Idx)
            bResult = bResult && (CrossroadList[u32Idx] == rfoCmp.CrossroadList[u32Idx]);
      }
   return bResult;
}

fi_tclInContext& fi_tcl_IntersectionPathDesc::oRead(fi_tclInContext& oIn)
{
   oIn >> IntersectionType;
   {
      tU32 u32Length;
      tU32 u32Idx;
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
      for (u32Idx = 0; u32Idx < IntersectionDenotationList.size(); ++u32Idx)
      {
         IntersectionDenotationList[u32Idx].vDestroy();
      }
#endif // !VARIANT_S_FTR_ENABLE_DEEP_COPY
      oIn >> u32Length;
      IntersectionDenotationList.resize(u32Length);
      for (u32Idx = 0; u32Idx < u32Length; ++u32Idx)
      {
         oIn >> IntersectionDenotationList[u32Idx];
      }
   }
   if (9 <= oIn.u16GetMajorVersion())
   {
      oIn >> IntersectionDiameter;
   }
   if (9 <= oIn.u16GetMajorVersion())
   {
      oIn >> IntersectionCenterCoordinates;
   }
   {
      tU32 u32Length;
      tU32 u32Idx;
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
      for (u32Idx = 0; u32Idx < CrossroadList.size(); ++u32Idx)
      {
         CrossroadList[u32Idx].vDestroy();
      }
#endif // !VARIANT_S_FTR_ENABLE_DEEP_COPY
      oIn >> u32Length;
      CrossroadList.resize(u32Length);
      for (u32Idx = 0; u32Idx < u32Length; ++u32Idx)
      {
         oIn >> CrossroadList[u32Idx];
      }
   }
   return oIn;
}

fi_tclOutContext& fi_tcl_IntersectionPathDesc::oWrite(fi_tclOutContext& oOut) const
{
   oOut << IntersectionType;
   oOut << (tU32)IntersectionDenotationList.size();
   {
      for (tU32 u32Idx = 0; u32Idx < IntersectionDenotationList.size(); ++u32Idx)
         oOut << IntersectionDenotationList[u32Idx];
   }
   if (9 <= oOut.u16GetMajorVersion())
   {
      oOut << IntersectionDiameter;
   }
   if (9 <= oOut.u16GetMajorVersion())
   {
      oOut << IntersectionCenterCoordinates;
   }
   oOut << (tU32)CrossroadList.size();
   {
      for (tU32 u32Idx = 0; u32Idx < CrossroadList.size(); ++u32Idx)
         oOut << CrossroadList[u32Idx];
   }
   return oOut;
}

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
fi_tcl_IntersectionDescElement::fi_tcl_IntersectionDescElement(const fi_tcl_IntersectionDescElement& coRef):fi_tclVisitableTypeBase(coRef)
{
   IntersectionType = coRef.IntersectionType;
   IntersectionDenotation = coRef.IntersectionDenotation;
   IntersectionDiameter = coRef.IntersectionDiameter;
   IntersectionCenterCoordinates = coRef.IntersectionCenterCoordinates;
   CrossroadList = coRef.CrossroadList;
   CrossroadInfoList = coRef.CrossroadInfoList;
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
fi_tcl_IntersectionDescElement& fi_tcl_IntersectionDescElement::operator=(const fi_tcl_IntersectionDescElement& coRef)
{
   if (this == &coRef) return *this;
   IntersectionType = coRef.IntersectionType;
   IntersectionDenotation = coRef.IntersectionDenotation;
   IntersectionDiameter = coRef.IntersectionDiameter;
   IntersectionCenterCoordinates = coRef.IntersectionCenterCoordinates;
   CrossroadList = coRef.CrossroadList;
   CrossroadInfoList = coRef.CrossroadInfoList;
   return *this;
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
tVoid fi_tcl_IntersectionDescElement::vDestroy()
{
   IntersectionDenotation.vDestroy(); 
   IntersectionCenterCoordinates.vDestroy(); 
   {
      for (tU32 u32Idx = 0; u32Idx < CrossroadList.size(); ++u32Idx)
         CrossroadList[u32Idx].vDestroy();
   }
   CrossroadList.clear();
   {
      for (tU32 u32Idx = 0; u32Idx < CrossroadInfoList.size(); ++u32Idx)
         CrossroadInfoList[u32Idx].vDestroy();
   }
   CrossroadInfoList.clear();
}

tU32 fi_tcl_IntersectionDescElement::u32GetSize(tU16 u16MajorVersion) const
{
   tU32 u32DynamicSize = 0;
   if (9 <= u16MajorVersion)
   {
      u32DynamicSize += 4;
   }
   if (9 <= u16MajorVersion)
   {
      u32DynamicSize += 8;
   }
   tU32 u32ListIdx;
   for (u32ListIdx = 0; u32ListIdx < CrossroadList.size(); ++u32ListIdx)
      u32DynamicSize += CrossroadList[u32ListIdx].u32GetSize(u16MajorVersion);
   for (u32ListIdx = 0; u32ListIdx < CrossroadInfoList.size(); ++u32ListIdx)
      u32DynamicSize += CrossroadInfoList[u32ListIdx].u32GetSize(u16MajorVersion);
   return u32DynamicSize+9+IntersectionDenotation.u32GetSize(u16MajorVersion);
}

tBool fi_tcl_IntersectionDescElement::operator==(const fi_tcl_IntersectionDescElement& rfoCmp) const
{
   tBool bResult = true;
      bResult = bResult && (IntersectionType == rfoCmp.IntersectionType);
      bResult = bResult && (IntersectionDenotation == rfoCmp.IntersectionDenotation);
      bResult = bResult && (IntersectionDiameter == rfoCmp.IntersectionDiameter);
      bResult = bResult && (IntersectionCenterCoordinates == rfoCmp.IntersectionCenterCoordinates);
      bResult = bResult && (CrossroadList.size() == rfoCmp.CrossroadList.size());
      if (bResult)
      {
         for (tU32 u32Idx = 0; bResult && (u32Idx < CrossroadList.size()); ++u32Idx)
            bResult = bResult && (CrossroadList[u32Idx] == rfoCmp.CrossroadList[u32Idx]);
      }
      bResult = bResult && (CrossroadInfoList.size() == rfoCmp.CrossroadInfoList.size());
      if (bResult)
      {
         for (tU32 u32Idx = 0; bResult && (u32Idx < CrossroadInfoList.size()); ++u32Idx)
            bResult = bResult && (CrossroadInfoList[u32Idx] == rfoCmp.CrossroadInfoList[u32Idx]);
      }
   return bResult;
}

fi_tclInContext& fi_tcl_IntersectionDescElement::oRead(fi_tclInContext& oIn)
{
   oIn >> IntersectionType;
   oIn >> IntersectionDenotation;
   if (9 <= oIn.u16GetMajorVersion())
   {
      oIn >> IntersectionDiameter;
   }
   if (9 <= oIn.u16GetMajorVersion())
   {
      oIn >> IntersectionCenterCoordinates;
   }
   {
      tU32 u32Length;
      tU32 u32Idx;
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
      for (u32Idx = 0; u32Idx < CrossroadList.size(); ++u32Idx)
      {
         CrossroadList[u32Idx].vDestroy();
      }
#endif // !VARIANT_S_FTR_ENABLE_DEEP_COPY
      oIn >> u32Length;
      CrossroadList.resize(u32Length);
      for (u32Idx = 0; u32Idx < u32Length; ++u32Idx)
      {
         oIn >> CrossroadList[u32Idx];
      }
   }
   {
      tU32 u32Length;
      tU32 u32Idx;
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
      for (u32Idx = 0; u32Idx < CrossroadInfoList.size(); ++u32Idx)
      {
         CrossroadInfoList[u32Idx].vDestroy();
      }
#endif // !VARIANT_S_FTR_ENABLE_DEEP_COPY
      oIn >> u32Length;
      CrossroadInfoList.resize(u32Length);
      for (u32Idx = 0; u32Idx < u32Length; ++u32Idx)
      {
         oIn >> CrossroadInfoList[u32Idx];
      }
   }
   return oIn;
}

fi_tclOutContext& fi_tcl_IntersectionDescElement::oWrite(fi_tclOutContext& oOut) const
{
   oOut << IntersectionType;
   oOut << IntersectionDenotation;
   if (9 <= oOut.u16GetMajorVersion())
   {
      oOut << IntersectionDiameter;
   }
   if (9 <= oOut.u16GetMajorVersion())
   {
      oOut << IntersectionCenterCoordinates;
   }
   oOut << (tU32)CrossroadList.size();
   {
      for (tU32 u32Idx = 0; u32Idx < CrossroadList.size(); ++u32Idx)
         oOut << CrossroadList[u32Idx];
   }
   oOut << (tU32)CrossroadInfoList.size();
   {
      for (tU32 u32Idx = 0; u32Idx < CrossroadInfoList.size(); ++u32Idx)
         oOut << CrossroadInfoList[u32Idx];
   }
   return oOut;
}

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
fi_tcl_NavIntersectionListSet::fi_tcl_NavIntersectionListSet(const fi_tcl_NavIntersectionListSet& coRef):fi_tclVisitableTypeBase(coRef)
{
   ElementInRefList = coRef.ElementInRefList;
   IntersectionPathRefList = coRef.IntersectionPathRefList;
   CrossroadInfoElementRefList = coRef.CrossroadInfoElementRefList;
   CrossroadInfoList = coRef.CrossroadInfoList;
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
fi_tcl_NavIntersectionListSet& fi_tcl_NavIntersectionListSet::operator=(const fi_tcl_NavIntersectionListSet& coRef)
{
   if (this == &coRef) return *this;
   ElementInRefList = coRef.ElementInRefList;
   IntersectionPathRefList = coRef.IntersectionPathRefList;
   CrossroadInfoElementRefList = coRef.CrossroadInfoElementRefList;
   CrossroadInfoList = coRef.CrossroadInfoList;
   return *this;
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
tVoid fi_tcl_NavIntersectionListSet::vDestroy()
{
   {
      for (tU32 u32Idx = 0; u32Idx < ElementInRefList.size(); ++u32Idx)
         ElementInRefList[u32Idx].vDestroy();
   }
   ElementInRefList.clear();
   {
      for (tU32 u32Idx = 0; u32Idx < IntersectionPathRefList.size(); ++u32Idx)
         IntersectionPathRefList[u32Idx].vDestroy();
   }
   IntersectionPathRefList.clear();
   CrossroadInfoElementRefList.vDestroy(); 
   {
      for (tU32 u32Idx = 0; u32Idx < CrossroadInfoList.size(); ++u32Idx)
         CrossroadInfoList[u32Idx].vDestroy();
   }
   CrossroadInfoList.clear();
}

tU32 fi_tcl_NavIntersectionListSet::u32GetSize(tU16 u16MajorVersion) const
{
   tU32 u32DynamicSize = 0;
   tU32 u32ListIdx;
   for (u32ListIdx = 0; u32ListIdx < IntersectionPathRefList.size(); ++u32ListIdx)
      u32DynamicSize += IntersectionPathRefList[u32ListIdx].u32GetSize(u16MajorVersion);
   for (u32ListIdx = 0; u32ListIdx < CrossroadInfoList.size(); ++u32ListIdx)
      u32DynamicSize += CrossroadInfoList[u32ListIdx].u32GetSize(u16MajorVersion);
   return u32DynamicSize+12+ElementInRefList.size()*3+CrossroadInfoElementRefList.u32GetSize(u16MajorVersion);
}

tBool fi_tcl_NavIntersectionListSet::operator==(const fi_tcl_NavIntersectionListSet& rfoCmp) const
{
   tBool bResult = true;
      bResult = bResult && (ElementInRefList.size() == rfoCmp.ElementInRefList.size());
      if (bResult)
      {
         for (tU32 u32Idx = 0; bResult && (u32Idx < ElementInRefList.size()); ++u32Idx)
            bResult = bResult && (ElementInRefList[u32Idx] == rfoCmp.ElementInRefList[u32Idx]);
      }
      bResult = bResult && (IntersectionPathRefList.size() == rfoCmp.IntersectionPathRefList.size());
      if (bResult)
      {
         for (tU32 u32Idx = 0; bResult && (u32Idx < IntersectionPathRefList.size()); ++u32Idx)
            bResult = bResult && (IntersectionPathRefList[u32Idx] == rfoCmp.IntersectionPathRefList[u32Idx]);
      }
      bResult = bResult && (CrossroadInfoElementRefList == rfoCmp.CrossroadInfoElementRefList);
      bResult = bResult && (CrossroadInfoList.size() == rfoCmp.CrossroadInfoList.size());
      if (bResult)
      {
         for (tU32 u32Idx = 0; bResult && (u32Idx < CrossroadInfoList.size()); ++u32Idx)
            bResult = bResult && (CrossroadInfoList[u32Idx] == rfoCmp.CrossroadInfoList[u32Idx]);
      }
   return bResult;
}

fi_tclInContext& fi_tcl_NavIntersectionListSet::oRead(fi_tclInContext& oIn)
{
   {
      tU32 u32Length;
      tU32 u32Idx;
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
      for (u32Idx = 0; u32Idx < ElementInRefList.size(); ++u32Idx)
      {
         ElementInRefList[u32Idx].vDestroy();
      }
#endif // !VARIANT_S_FTR_ENABLE_DEEP_COPY
      oIn >> u32Length;
      ElementInRefList.resize(u32Length);
      for (u32Idx = 0; u32Idx < u32Length; ++u32Idx)
      {
         oIn >> ElementInRefList[u32Idx];
      }
   }
   {
      tU32 u32Length;
      tU32 u32Idx;
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
      for (u32Idx = 0; u32Idx < IntersectionPathRefList.size(); ++u32Idx)
      {
         IntersectionPathRefList[u32Idx].vDestroy();
      }
#endif // !VARIANT_S_FTR_ENABLE_DEEP_COPY
      oIn >> u32Length;
      IntersectionPathRefList.resize(u32Length);
      for (u32Idx = 0; u32Idx < u32Length; ++u32Idx)
      {
         oIn >> IntersectionPathRefList[u32Idx];
      }
   }
   oIn >> CrossroadInfoElementRefList;
   {
      tU32 u32Length;
      tU32 u32Idx;
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
      for (u32Idx = 0; u32Idx < CrossroadInfoList.size(); ++u32Idx)
      {
         CrossroadInfoList[u32Idx].vDestroy();
      }
#endif // !VARIANT_S_FTR_ENABLE_DEEP_COPY
      oIn >> u32Length;
      CrossroadInfoList.resize(u32Length);
      for (u32Idx = 0; u32Idx < u32Length; ++u32Idx)
      {
         oIn >> CrossroadInfoList[u32Idx];
      }
   }
   return oIn;
}

fi_tclOutContext& fi_tcl_NavIntersectionListSet::oWrite(fi_tclOutContext& oOut) const
{
   oOut << (tU32)ElementInRefList.size();
   {
      for (tU32 u32Idx = 0; u32Idx < ElementInRefList.size(); ++u32Idx)
         oOut << ElementInRefList[u32Idx];
   }
   oOut << (tU32)IntersectionPathRefList.size();
   {
      for (tU32 u32Idx = 0; u32Idx < IntersectionPathRefList.size(); ++u32Idx)
         oOut << IntersectionPathRefList[u32Idx];
   }
   oOut << CrossroadInfoElementRefList;
   oOut << (tU32)CrossroadInfoList.size();
   {
      for (tU32 u32Idx = 0; u32Idx < CrossroadInfoList.size(); ++u32Idx)
         oOut << CrossroadInfoList[u32Idx];
   }
   return oOut;
}

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
fi_tcl_IntersectionListSet::fi_tcl_IntersectionListSet(const fi_tcl_IntersectionListSet& coRef):fi_tclVisitableTypeBase(coRef)
{
   ElementInRefList = coRef.ElementInRefList;
   IntersectionRefList = coRef.IntersectionRefList;
   CrossroadInfoList = coRef.CrossroadInfoList;
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
fi_tcl_IntersectionListSet& fi_tcl_IntersectionListSet::operator=(const fi_tcl_IntersectionListSet& coRef)
{
   if (this == &coRef) return *this;
   ElementInRefList = coRef.ElementInRefList;
   IntersectionRefList = coRef.IntersectionRefList;
   CrossroadInfoList = coRef.CrossroadInfoList;
   return *this;
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
tVoid fi_tcl_IntersectionListSet::vDestroy()
{
   {
      for (tU32 u32Idx = 0; u32Idx < ElementInRefList.size(); ++u32Idx)
         ElementInRefList[u32Idx].vDestroy();
   }
   ElementInRefList.clear();
   {
      for (tU32 u32Idx = 0; u32Idx < IntersectionRefList.size(); ++u32Idx)
         IntersectionRefList[u32Idx].vDestroy();
   }
   IntersectionRefList.clear();
   {
      for (tU32 u32Idx = 0; u32Idx < CrossroadInfoList.size(); ++u32Idx)
         CrossroadInfoList[u32Idx].vDestroy();
   }
   CrossroadInfoList.clear();
}

tU32 fi_tcl_IntersectionListSet::u32GetSize(tU16 u16MajorVersion) const
{
   tU32 u32DynamicSize = 0;
   tU32 u32ListIdx;
   for (u32ListIdx = 0; u32ListIdx < IntersectionRefList.size(); ++u32ListIdx)
      u32DynamicSize += IntersectionRefList[u32ListIdx].u32GetSize(u16MajorVersion);
   for (u32ListIdx = 0; u32ListIdx < CrossroadInfoList.size(); ++u32ListIdx)
      u32DynamicSize += CrossroadInfoList[u32ListIdx].u32GetSize(u16MajorVersion);
   return u32DynamicSize+12+ElementInRefList.size()*3;
}

tBool fi_tcl_IntersectionListSet::operator==(const fi_tcl_IntersectionListSet& rfoCmp) const
{
   tBool bResult = true;
      bResult = bResult && (ElementInRefList.size() == rfoCmp.ElementInRefList.size());
      if (bResult)
      {
         for (tU32 u32Idx = 0; bResult && (u32Idx < ElementInRefList.size()); ++u32Idx)
            bResult = bResult && (ElementInRefList[u32Idx] == rfoCmp.ElementInRefList[u32Idx]);
      }
      bResult = bResult && (IntersectionRefList.size() == rfoCmp.IntersectionRefList.size());
      if (bResult)
      {
         for (tU32 u32Idx = 0; bResult && (u32Idx < IntersectionRefList.size()); ++u32Idx)
            bResult = bResult && (IntersectionRefList[u32Idx] == rfoCmp.IntersectionRefList[u32Idx]);
      }
      bResult = bResult && (CrossroadInfoList.size() == rfoCmp.CrossroadInfoList.size());
      if (bResult)
      {
         for (tU32 u32Idx = 0; bResult && (u32Idx < CrossroadInfoList.size()); ++u32Idx)
            bResult = bResult && (CrossroadInfoList[u32Idx] == rfoCmp.CrossroadInfoList[u32Idx]);
      }
   return bResult;
}

fi_tclInContext& fi_tcl_IntersectionListSet::oRead(fi_tclInContext& oIn)
{
   {
      tU32 u32Length;
      tU32 u32Idx;
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
      for (u32Idx = 0; u32Idx < ElementInRefList.size(); ++u32Idx)
      {
         ElementInRefList[u32Idx].vDestroy();
      }
#endif // !VARIANT_S_FTR_ENABLE_DEEP_COPY
      oIn >> u32Length;
      ElementInRefList.resize(u32Length);
      for (u32Idx = 0; u32Idx < u32Length; ++u32Idx)
      {
         oIn >> ElementInRefList[u32Idx];
      }
   }
   {
      tU32 u32Length;
      tU32 u32Idx;
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
      for (u32Idx = 0; u32Idx < IntersectionRefList.size(); ++u32Idx)
      {
         IntersectionRefList[u32Idx].vDestroy();
      }
#endif // !VARIANT_S_FTR_ENABLE_DEEP_COPY
      oIn >> u32Length;
      IntersectionRefList.resize(u32Length);
      for (u32Idx = 0; u32Idx < u32Length; ++u32Idx)
      {
         oIn >> IntersectionRefList[u32Idx];
      }
   }
   {
      tU32 u32Length;
      tU32 u32Idx;
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
      for (u32Idx = 0; u32Idx < CrossroadInfoList.size(); ++u32Idx)
      {
         CrossroadInfoList[u32Idx].vDestroy();
      }
#endif // !VARIANT_S_FTR_ENABLE_DEEP_COPY
      oIn >> u32Length;
      CrossroadInfoList.resize(u32Length);
      for (u32Idx = 0; u32Idx < u32Length; ++u32Idx)
      {
         oIn >> CrossroadInfoList[u32Idx];
      }
   }
   return oIn;
}

fi_tclOutContext& fi_tcl_IntersectionListSet::oWrite(fi_tclOutContext& oOut) const
{
   oOut << (tU32)ElementInRefList.size();
   {
      for (tU32 u32Idx = 0; u32Idx < ElementInRefList.size(); ++u32Idx)
         oOut << ElementInRefList[u32Idx];
   }
   oOut << (tU32)IntersectionRefList.size();
   {
      for (tU32 u32Idx = 0; u32Idx < IntersectionRefList.size(); ++u32Idx)
         oOut << IntersectionRefList[u32Idx];
   }
   oOut << (tU32)CrossroadInfoList.size();
   {
      for (tU32 u32Idx = 0; u32Idx < CrossroadInfoList.size(); ++u32Idx)
         oOut << CrossroadInfoList[u32Idx];
   }
   return oOut;
}

tU32 fi_tcl_e16_BaseTrafficSign::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 2;
}

tBool fi_tcl_e16_BaseTrafficSign::operator==(const fi_tcl_e16_BaseTrafficSign& rfoCmp) const
{
   return enType == rfoCmp.enType;
}

fi_tclInContext& fi_tcl_e16_BaseTrafficSign::oRead(fi_tclInContext& oIn)
{
   tU16 u16Value;
   oIn >> u16Value;
   enType = (tenType)u16Value;
   return oIn;
}

fi_tclOutContext& fi_tcl_e16_BaseTrafficSign::oWrite(fi_tclOutContext& oOut) const
{
   return oOut.oWrite((tU16)enType);
}

tU32 fi_tcl_e8_BaseTrafficSignCategory::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 1;
}

tBool fi_tcl_e8_BaseTrafficSignCategory::operator==(const fi_tcl_e8_BaseTrafficSignCategory& rfoCmp) const
{
   return enType == rfoCmp.enType;
}

fi_tclInContext& fi_tcl_e8_BaseTrafficSignCategory::oRead(fi_tclInContext& oIn)
{
   tU8 u8Value;
   oIn >> u8Value;
   enType = (tenType)u8Value;
   return oIn;
}

fi_tclOutContext& fi_tcl_e8_BaseTrafficSignCategory::oWrite(fi_tclOutContext& oOut) const
{
   fi_tcl_e8_BaseTrafficSignCategory::tenType enData = enType;
   if ((enData == FI_EN_T_E16_REGULATORYSIGN) && !(7 <= oOut.u16GetMajorVersion()))
   {
      enData = FI_EN_T_RESERVED;
   }
   return oOut.oWrite((tU8)enData);
}

tU32 fi_tcl_e8_SpeedSign::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 1;
}

tBool fi_tcl_e8_SpeedSign::operator==(const fi_tcl_e8_SpeedSign& rfoCmp) const
{
   return enType == rfoCmp.enType;
}

fi_tclInContext& fi_tcl_e8_SpeedSign::oRead(fi_tclInContext& oIn)
{
   tU8 u8Value;
   oIn >> u8Value;
   enType = (tenType)u8Value;
   return oIn;
}

fi_tclOutContext& fi_tcl_e8_SpeedSign::oWrite(fi_tclOutContext& oOut) const
{
   return oOut.oWrite((tU8)enType);
}

tU32 fi_tcl_e16_WarningSign::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 2;
}

tBool fi_tcl_e16_WarningSign::operator==(const fi_tcl_e16_WarningSign& rfoCmp) const
{
   return enType == rfoCmp.enType;
}

fi_tclInContext& fi_tcl_e16_WarningSign::oRead(fi_tclInContext& oIn)
{
   tU16 u16Value;
   oIn >> u16Value;
   enType = (tenType)u16Value;
   return oIn;
}

fi_tclOutContext& fi_tcl_e16_WarningSign::oWrite(fi_tclOutContext& oOut) const
{
   return oOut.oWrite((tU16)enType);
}

tU32 fi_tcl_e16_RegulatorySign::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 2;
}

tBool fi_tcl_e16_RegulatorySign::operator==(const fi_tcl_e16_RegulatorySign& rfoCmp) const
{
   return enType == rfoCmp.enType;
}

fi_tclInContext& fi_tcl_e16_RegulatorySign::oRead(fi_tclInContext& oIn)
{
   tU16 u16Value;
   oIn >> u16Value;
   enType = (tenType)u16Value;
   return oIn;
}

fi_tclOutContext& fi_tcl_e16_RegulatorySign::oWrite(fi_tclOutContext& oOut) const
{
   return oOut.oWrite((tU16)enType);
}

tU32 fi_tcl_e16_AdditionalTrafficSign::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 2;
}

tBool fi_tcl_e16_AdditionalTrafficSign::operator==(const fi_tcl_e16_AdditionalTrafficSign& rfoCmp) const
{
   return enType == rfoCmp.enType;
}

fi_tclInContext& fi_tcl_e16_AdditionalTrafficSign::oRead(fi_tclInContext& oIn)
{
   tU16 u16Value;
   oIn >> u16Value;
   enType = (tenType)u16Value;
   return oIn;
}

fi_tclOutContext& fi_tcl_e16_AdditionalTrafficSign::oWrite(fi_tclOutContext& oOut) const
{
   return oOut.oWrite((tU16)enType);
}

tVoid fi_tcl_TimeDependentString::vDestroy()
{
   szValue.vDestroy();
}

tU32 fi_tcl_TimeDependentString::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 0+ szValue.u32GetSize(0);
}

tBool fi_tcl_TimeDependentString::operator==(const fi_tcl_TimeDependentString& rfoCmp) const
{
   return szValue == rfoCmp.szValue;
}

fi_tclInContext& fi_tcl_TimeDependentString::oRead(fi_tclInContext& oIn)
{
   return oIn >> szValue;
}

fi_tclOutContext& fi_tcl_TimeDependentString::oWrite(fi_tclOutContext& oOut) const
{
   return oOut << szValue;
}

tU32 fi_tcl_b8_LaneDependentValidity::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 1;
}

tBool fi_tcl_b8_LaneDependentValidity::operator==(const fi_tcl_b8_LaneDependentValidity& rfoCmp) const
{
   return u8Value == rfoCmp.u8Value;
}

fi_tclInContext& fi_tcl_b8_LaneDependentValidity::oRead(fi_tclInContext& oIn)
{
   return oIn >> u8Value;
}

fi_tclOutContext& fi_tcl_b8_LaneDependentValidity::oWrite(fi_tclOutContext& oOut) const
{
   return oOut << u8Value;
}

tU32 fi_tcl_e8_TrafficSignQuantifier::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 1;
}

tBool fi_tcl_e8_TrafficSignQuantifier::operator==(const fi_tcl_e8_TrafficSignQuantifier& rfoCmp) const
{
   return enType == rfoCmp.enType;
}

fi_tclInContext& fi_tcl_e8_TrafficSignQuantifier::oRead(fi_tclInContext& oIn)
{
   tU8 u8Value;
   oIn >> u8Value;
   enType = (tenType)u8Value;
   return oIn;
}

fi_tclOutContext& fi_tcl_e8_TrafficSignQuantifier::oWrite(fi_tclOutContext& oOut) const
{
   fi_tcl_e8_TrafficSignQuantifier::tenType enData = enType;
   if ((enData == FI_EN_T_S32_POUND) && !(7 <= oOut.u16GetMajorVersion()))
   {
      enData = FI_EN_T_RESERVED;
   }
   if ((enData == FI_EN_T_S32_KILOGRAM) && !(7 <= oOut.u16GetMajorVersion()))
   {
      enData = FI_EN_T_RESERVED;
   }
   if ((enData == FI_EN_T_S32_INCH) && !(7 <= oOut.u16GetMajorVersion()))
   {
      enData = FI_EN_T_RESERVED;
   }
   if ((enData == FI_EN_T_S32_CENTIMETER) && !(7 <= oOut.u16GetMajorVersion()))
   {
      enData = FI_EN_T_RESERVED;
   }
   return oOut.oWrite((tU8)enData);
}

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
fi_tcl_AdditionalTrafficSign::fi_tcl_AdditionalTrafficSign(const fi_tcl_AdditionalTrafficSign& coRef):fi_tclVisitableTypeBase(coRef)
{
   AdditionalSign = coRef.AdditionalSign;
   QuantifierOfAddSignType = coRef.QuantifierOfAddSignType;
   if  (coRef.poQuantifierOfAddSignData)
   {
      switch(QuantifierOfAddSignType.enType)
      {
      case fi_tcl_e8_TrafficSignQuantifier::FI_EN_T_RESERVED:
         poQuantifierOfAddSignData = OSAL_NEW fi_tcl_Reserved((const fi_tcl_Reserved&)*coRef.poQuantifierOfAddSignData);
         break;
      case fi_tcl_e8_TrafficSignQuantifier::FI_EN_T_S16_KMPERHOUR:
         poQuantifierOfAddSignData = OSAL_NEW fi_tcl_s16_KmPerHour((const fi_tcl_s16_KmPerHour&)*coRef.poQuantifierOfAddSignData);
         break;
      case fi_tcl_e8_TrafficSignQuantifier::FI_EN_T_S16_MILESPERHOUR:
         poQuantifierOfAddSignData = OSAL_NEW fi_tcl_s16_MilesPerHour((const fi_tcl_s16_MilesPerHour&)*coRef.poQuantifierOfAddSignData);
         break;
      case fi_tcl_e8_TrafficSignQuantifier::FI_EN_TSTRING:
         poQuantifierOfAddSignData = OSAL_NEW fi_tclString((const fi_tclString&)*coRef.poQuantifierOfAddSignData);
         break;
      case fi_tcl_e8_TrafficSignQuantifier::FI_EN_T_U8_PERCENT:
         poQuantifierOfAddSignData = OSAL_NEW fi_tcl_u8_Percent((const fi_tcl_u8_Percent&)*coRef.poQuantifierOfAddSignData);
         break;
      case fi_tcl_e8_TrafficSignQuantifier::FI_EN_T_B8_LANEDEPENDENTVALIDITY:
         poQuantifierOfAddSignData = OSAL_NEW fi_tcl_b8_LaneDependentValidity((const fi_tcl_b8_LaneDependentValidity&)*coRef.poQuantifierOfAddSignData);
         break;
      case fi_tcl_e8_TrafficSignQuantifier::FI_EN_T_TIMEDEPENDENTSTRING:
         poQuantifierOfAddSignData = OSAL_NEW fi_tcl_TimeDependentString((const fi_tcl_TimeDependentString&)*coRef.poQuantifierOfAddSignData);
         break;
      case fi_tcl_e8_TrafficSignQuantifier::FI_EN_T_S32_METER:
         poQuantifierOfAddSignData = OSAL_NEW fi_tcl_s32_Meter((const fi_tcl_s32_Meter&)*coRef.poQuantifierOfAddSignData);
         break;
      case fi_tcl_e8_TrafficSignQuantifier::FI_EN_T_S32_YARDS:
         poQuantifierOfAddSignData = OSAL_NEW fi_tcl_s32_Yards((const fi_tcl_s32_Yards&)*coRef.poQuantifierOfAddSignData);
         break;
      case fi_tcl_e8_TrafficSignQuantifier::FI_EN_TMULTILANGUAGESTRING:
         poQuantifierOfAddSignData = OSAL_NEW fi_tclMultiLanguageString((const fi_tclMultiLanguageString&)*coRef.poQuantifierOfAddSignData);
         break;
      case fi_tcl_e8_TrafficSignQuantifier::FI_EN_T_S32_CENTIMETER:
         poQuantifierOfAddSignData = OSAL_NEW fi_tcl_s32_Centimeter((const fi_tcl_s32_Centimeter&)*coRef.poQuantifierOfAddSignData);
         break;
      case fi_tcl_e8_TrafficSignQuantifier::FI_EN_T_S32_INCH:
         poQuantifierOfAddSignData = OSAL_NEW fi_tcl_s32_Inch((const fi_tcl_s32_Inch&)*coRef.poQuantifierOfAddSignData);
         break;
      case fi_tcl_e8_TrafficSignQuantifier::FI_EN_T_S32_KILOGRAM:
         poQuantifierOfAddSignData = OSAL_NEW fi_tcl_s32_Kilogram((const fi_tcl_s32_Kilogram&)*coRef.poQuantifierOfAddSignData);
         break;
      case fi_tcl_e8_TrafficSignQuantifier::FI_EN_T_S32_POUND:
         poQuantifierOfAddSignData = OSAL_NEW fi_tcl_s32_Pound((const fi_tcl_s32_Pound&)*coRef.poQuantifierOfAddSignData);
         break;
      default:
         poQuantifierOfAddSignData = OSAL_NULL;
      }
   }
   else
   {
      poQuantifierOfAddSignData = OSAL_NULL;
   }
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
fi_tcl_AdditionalTrafficSign& fi_tcl_AdditionalTrafficSign::operator=(const fi_tcl_AdditionalTrafficSign& coRef)
{
   if (this == &coRef) return *this;
   AdditionalSign = coRef.AdditionalSign;
   OSAL_DELETE poQuantifierOfAddSignData;
   QuantifierOfAddSignType = coRef.QuantifierOfAddSignType;
   if  (coRef.poQuantifierOfAddSignData)
   {
      switch(QuantifierOfAddSignType.enType)
      {
      case fi_tcl_e8_TrafficSignQuantifier::FI_EN_T_RESERVED:
         poQuantifierOfAddSignData = OSAL_NEW fi_tcl_Reserved((const fi_tcl_Reserved&)*coRef.poQuantifierOfAddSignData);
         break;
      case fi_tcl_e8_TrafficSignQuantifier::FI_EN_T_S16_KMPERHOUR:
         poQuantifierOfAddSignData = OSAL_NEW fi_tcl_s16_KmPerHour((const fi_tcl_s16_KmPerHour&)*coRef.poQuantifierOfAddSignData);
         break;
      case fi_tcl_e8_TrafficSignQuantifier::FI_EN_T_S16_MILESPERHOUR:
         poQuantifierOfAddSignData = OSAL_NEW fi_tcl_s16_MilesPerHour((const fi_tcl_s16_MilesPerHour&)*coRef.poQuantifierOfAddSignData);
         break;
      case fi_tcl_e8_TrafficSignQuantifier::FI_EN_TSTRING:
         poQuantifierOfAddSignData = OSAL_NEW fi_tclString((const fi_tclString&)*coRef.poQuantifierOfAddSignData);
         break;
      case fi_tcl_e8_TrafficSignQuantifier::FI_EN_T_U8_PERCENT:
         poQuantifierOfAddSignData = OSAL_NEW fi_tcl_u8_Percent((const fi_tcl_u8_Percent&)*coRef.poQuantifierOfAddSignData);
         break;
      case fi_tcl_e8_TrafficSignQuantifier::FI_EN_T_B8_LANEDEPENDENTVALIDITY:
         poQuantifierOfAddSignData = OSAL_NEW fi_tcl_b8_LaneDependentValidity((const fi_tcl_b8_LaneDependentValidity&)*coRef.poQuantifierOfAddSignData);
         break;
      case fi_tcl_e8_TrafficSignQuantifier::FI_EN_T_TIMEDEPENDENTSTRING:
         poQuantifierOfAddSignData = OSAL_NEW fi_tcl_TimeDependentString((const fi_tcl_TimeDependentString&)*coRef.poQuantifierOfAddSignData);
         break;
      case fi_tcl_e8_TrafficSignQuantifier::FI_EN_T_S32_METER:
         poQuantifierOfAddSignData = OSAL_NEW fi_tcl_s32_Meter((const fi_tcl_s32_Meter&)*coRef.poQuantifierOfAddSignData);
         break;
      case fi_tcl_e8_TrafficSignQuantifier::FI_EN_T_S32_YARDS:
         poQuantifierOfAddSignData = OSAL_NEW fi_tcl_s32_Yards((const fi_tcl_s32_Yards&)*coRef.poQuantifierOfAddSignData);
         break;
      case fi_tcl_e8_TrafficSignQuantifier::FI_EN_TMULTILANGUAGESTRING:
         poQuantifierOfAddSignData = OSAL_NEW fi_tclMultiLanguageString((const fi_tclMultiLanguageString&)*coRef.poQuantifierOfAddSignData);
         break;
      case fi_tcl_e8_TrafficSignQuantifier::FI_EN_T_S32_CENTIMETER:
         poQuantifierOfAddSignData = OSAL_NEW fi_tcl_s32_Centimeter((const fi_tcl_s32_Centimeter&)*coRef.poQuantifierOfAddSignData);
         break;
      case fi_tcl_e8_TrafficSignQuantifier::FI_EN_T_S32_INCH:
         poQuantifierOfAddSignData = OSAL_NEW fi_tcl_s32_Inch((const fi_tcl_s32_Inch&)*coRef.poQuantifierOfAddSignData);
         break;
      case fi_tcl_e8_TrafficSignQuantifier::FI_EN_T_S32_KILOGRAM:
         poQuantifierOfAddSignData = OSAL_NEW fi_tcl_s32_Kilogram((const fi_tcl_s32_Kilogram&)*coRef.poQuantifierOfAddSignData);
         break;
      case fi_tcl_e8_TrafficSignQuantifier::FI_EN_T_S32_POUND:
         poQuantifierOfAddSignData = OSAL_NEW fi_tcl_s32_Pound((const fi_tcl_s32_Pound&)*coRef.poQuantifierOfAddSignData);
         break;
      default:
         poQuantifierOfAddSignData = OSAL_NULL;
      }
   }
   else
   {
      poQuantifierOfAddSignData = OSAL_NULL;
   }
   return *this;
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
fi_tcl_AdditionalTrafficSign::~fi_tcl_AdditionalTrafficSign()
{
   OSAL_DELETE poQuantifierOfAddSignData;
   poQuantifierOfAddSignData = OSAL_NULL;
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
tVoid fi_tcl_AdditionalTrafficSign::vDestroy()
{
   if (poQuantifierOfAddSignData)
   {
      poQuantifierOfAddSignData->vDestroy();
      OSAL_DELETE poQuantifierOfAddSignData;
      poQuantifierOfAddSignData = OSAL_NULL;
   }
}

tU32 fi_tcl_AdditionalTrafficSign::u32GetSize(tU16 u16MajorVersion) const
{
   tU32 u32DynamicSize = 0;
   if (QuantifierOfAddSignType.enType == fi_tcl_e8_TrafficSignQuantifier::FI_EN_T_RESERVED)
      u32DynamicSize += (poQuantifierOfAddSignData?poQuantifierOfAddSignData->u32GetSize(u16MajorVersion):0);
   if (QuantifierOfAddSignType.enType == fi_tcl_e8_TrafficSignQuantifier::FI_EN_T_S16_KMPERHOUR)
      u32DynamicSize += (poQuantifierOfAddSignData?poQuantifierOfAddSignData->u32GetSize(u16MajorVersion):0);
   if (QuantifierOfAddSignType.enType == fi_tcl_e8_TrafficSignQuantifier::FI_EN_T_S16_MILESPERHOUR)
      u32DynamicSize += (poQuantifierOfAddSignData?poQuantifierOfAddSignData->u32GetSize(u16MajorVersion):0);
   if (QuantifierOfAddSignType.enType == fi_tcl_e8_TrafficSignQuantifier::FI_EN_TSTRING)
      u32DynamicSize += (poQuantifierOfAddSignData?poQuantifierOfAddSignData->u32GetSize(u16MajorVersion):0);
   if (QuantifierOfAddSignType.enType == fi_tcl_e8_TrafficSignQuantifier::FI_EN_T_U8_PERCENT)
      u32DynamicSize += (poQuantifierOfAddSignData?poQuantifierOfAddSignData->u32GetSize(u16MajorVersion):0);
   if (QuantifierOfAddSignType.enType == fi_tcl_e8_TrafficSignQuantifier::FI_EN_T_B8_LANEDEPENDENTVALIDITY)
      u32DynamicSize += (poQuantifierOfAddSignData?poQuantifierOfAddSignData->u32GetSize(u16MajorVersion):0);
   if (QuantifierOfAddSignType.enType == fi_tcl_e8_TrafficSignQuantifier::FI_EN_T_TIMEDEPENDENTSTRING)
      u32DynamicSize += (poQuantifierOfAddSignData?poQuantifierOfAddSignData->u32GetSize(u16MajorVersion):0);
   if (QuantifierOfAddSignType.enType == fi_tcl_e8_TrafficSignQuantifier::FI_EN_T_S32_METER)
      u32DynamicSize += (poQuantifierOfAddSignData?poQuantifierOfAddSignData->u32GetSize(u16MajorVersion):0);
   if (QuantifierOfAddSignType.enType == fi_tcl_e8_TrafficSignQuantifier::FI_EN_T_S32_YARDS)
      u32DynamicSize += (poQuantifierOfAddSignData?poQuantifierOfAddSignData->u32GetSize(u16MajorVersion):0);
   if (QuantifierOfAddSignType.enType == fi_tcl_e8_TrafficSignQuantifier::FI_EN_TMULTILANGUAGESTRING)
      u32DynamicSize += (poQuantifierOfAddSignData?poQuantifierOfAddSignData->u32GetSize(u16MajorVersion):0);
   if ((QuantifierOfAddSignType.enType == fi_tcl_e8_TrafficSignQuantifier::FI_EN_T_S32_CENTIMETER) &&
       (7 <= u16MajorVersion))
      u32DynamicSize += (poQuantifierOfAddSignData?poQuantifierOfAddSignData->u32GetSize(u16MajorVersion):0);
   if ((QuantifierOfAddSignType.enType == fi_tcl_e8_TrafficSignQuantifier::FI_EN_T_S32_INCH) &&
       (7 <= u16MajorVersion))
      u32DynamicSize += (poQuantifierOfAddSignData?poQuantifierOfAddSignData->u32GetSize(u16MajorVersion):0);
   if ((QuantifierOfAddSignType.enType == fi_tcl_e8_TrafficSignQuantifier::FI_EN_T_S32_KILOGRAM) &&
       (7 <= u16MajorVersion))
      u32DynamicSize += (poQuantifierOfAddSignData?poQuantifierOfAddSignData->u32GetSize(u16MajorVersion):0);
   if ((QuantifierOfAddSignType.enType == fi_tcl_e8_TrafficSignQuantifier::FI_EN_T_S32_POUND) &&
       (7 <= u16MajorVersion))
      u32DynamicSize += (poQuantifierOfAddSignData?poQuantifierOfAddSignData->u32GetSize(u16MajorVersion):0);
   return u32DynamicSize+3;
}

tBool fi_tcl_AdditionalTrafficSign::operator==(const fi_tcl_AdditionalTrafficSign& rfoCmp) const
{
   tBool bResult = true;
      bResult = bResult && (AdditionalSign == rfoCmp.AdditionalSign);
   bResult = bResult && (QuantifierOfAddSignType == rfoCmp.QuantifierOfAddSignType);
   if (bResult && poQuantifierOfAddSignData && rfoCmp.poQuantifierOfAddSignData) 
   {
      switch (QuantifierOfAddSignType.enType)
      {
      case fi_tcl_e8_TrafficSignQuantifier::FI_EN_T_RESERVED:
         bResult = bResult && (*(const fi_tcl_Reserved*)poQuantifierOfAddSignData == *(const fi_tcl_Reserved*)rfoCmp.poQuantifierOfAddSignData); //lint !e826
      break;
      case fi_tcl_e8_TrafficSignQuantifier::FI_EN_T_S16_KMPERHOUR:
         bResult = bResult && (*(const fi_tcl_s16_KmPerHour*)poQuantifierOfAddSignData == *(const fi_tcl_s16_KmPerHour*)rfoCmp.poQuantifierOfAddSignData); //lint !e826
      break;
      case fi_tcl_e8_TrafficSignQuantifier::FI_EN_T_S16_MILESPERHOUR:
         bResult = bResult && (*(const fi_tcl_s16_MilesPerHour*)poQuantifierOfAddSignData == *(const fi_tcl_s16_MilesPerHour*)rfoCmp.poQuantifierOfAddSignData); //lint !e826
      break;
      case fi_tcl_e8_TrafficSignQuantifier::FI_EN_TSTRING:
         bResult = bResult && (*(const fi_tclString*)poQuantifierOfAddSignData == *(const fi_tclString*)rfoCmp.poQuantifierOfAddSignData); //lint !e826
      break;
      case fi_tcl_e8_TrafficSignQuantifier::FI_EN_T_U8_PERCENT:
         bResult = bResult && (*(const fi_tcl_u8_Percent*)poQuantifierOfAddSignData == *(const fi_tcl_u8_Percent*)rfoCmp.poQuantifierOfAddSignData); //lint !e826
      break;
      case fi_tcl_e8_TrafficSignQuantifier::FI_EN_T_B8_LANEDEPENDENTVALIDITY:
         bResult = bResult && (*(const fi_tcl_b8_LaneDependentValidity*)poQuantifierOfAddSignData == *(const fi_tcl_b8_LaneDependentValidity*)rfoCmp.poQuantifierOfAddSignData); //lint !e826
      break;
      case fi_tcl_e8_TrafficSignQuantifier::FI_EN_T_TIMEDEPENDENTSTRING:
         bResult = bResult && (*(const fi_tcl_TimeDependentString*)poQuantifierOfAddSignData == *(const fi_tcl_TimeDependentString*)rfoCmp.poQuantifierOfAddSignData); //lint !e826
      break;
      case fi_tcl_e8_TrafficSignQuantifier::FI_EN_T_S32_METER:
         bResult = bResult && (*(const fi_tcl_s32_Meter*)poQuantifierOfAddSignData == *(const fi_tcl_s32_Meter*)rfoCmp.poQuantifierOfAddSignData); //lint !e826
      break;
      case fi_tcl_e8_TrafficSignQuantifier::FI_EN_T_S32_YARDS:
         bResult = bResult && (*(const fi_tcl_s32_Yards*)poQuantifierOfAddSignData == *(const fi_tcl_s32_Yards*)rfoCmp.poQuantifierOfAddSignData); //lint !e826
      break;
      case fi_tcl_e8_TrafficSignQuantifier::FI_EN_TMULTILANGUAGESTRING:
         bResult = bResult && (*(const fi_tclMultiLanguageString*)poQuantifierOfAddSignData == *(const fi_tclMultiLanguageString*)rfoCmp.poQuantifierOfAddSignData); //lint !e826
      break;
      case fi_tcl_e8_TrafficSignQuantifier::FI_EN_T_S32_CENTIMETER:
         bResult = bResult && (*(const fi_tcl_s32_Centimeter*)poQuantifierOfAddSignData == *(const fi_tcl_s32_Centimeter*)rfoCmp.poQuantifierOfAddSignData); //lint !e826
      break;
      case fi_tcl_e8_TrafficSignQuantifier::FI_EN_T_S32_INCH:
         bResult = bResult && (*(const fi_tcl_s32_Inch*)poQuantifierOfAddSignData == *(const fi_tcl_s32_Inch*)rfoCmp.poQuantifierOfAddSignData); //lint !e826
      break;
      case fi_tcl_e8_TrafficSignQuantifier::FI_EN_T_S32_KILOGRAM:
         bResult = bResult && (*(const fi_tcl_s32_Kilogram*)poQuantifierOfAddSignData == *(const fi_tcl_s32_Kilogram*)rfoCmp.poQuantifierOfAddSignData); //lint !e826
      break;
      case fi_tcl_e8_TrafficSignQuantifier::FI_EN_T_S32_POUND:
         bResult = bResult && (*(const fi_tcl_s32_Pound*)poQuantifierOfAddSignData == *(const fi_tcl_s32_Pound*)rfoCmp.poQuantifierOfAddSignData); //lint !e826
      break;
      }
   }
   else
   {
      bResult = bResult && (poQuantifierOfAddSignData == rfoCmp.poQuantifierOfAddSignData);
   }
   return bResult;
}

fi_tclInContext& fi_tcl_AdditionalTrafficSign::oRead(fi_tclInContext& oIn)
{
   oIn >> AdditionalSign;
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   OSAL_DELETE poQuantifierOfAddSignData;
#else
   if (poQuantifierOfAddSignData)
   {
      poQuantifierOfAddSignData->vDestroy();
      OSAL_DELETE poQuantifierOfAddSignData;
   }
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
   oIn >> QuantifierOfAddSignType;
   switch(QuantifierOfAddSignType.enType)
   {
   case fi_tcl_e8_TrafficSignQuantifier::FI_EN_T_RESERVED:
      poQuantifierOfAddSignData = OSAL_NEW fi_tcl_Reserved;
      break;
   case fi_tcl_e8_TrafficSignQuantifier::FI_EN_T_S16_KMPERHOUR:
      poQuantifierOfAddSignData = OSAL_NEW fi_tcl_s16_KmPerHour;
      break;
   case fi_tcl_e8_TrafficSignQuantifier::FI_EN_T_S16_MILESPERHOUR:
      poQuantifierOfAddSignData = OSAL_NEW fi_tcl_s16_MilesPerHour;
      break;
   case fi_tcl_e8_TrafficSignQuantifier::FI_EN_TSTRING:
      poQuantifierOfAddSignData = OSAL_NEW fi_tclString;
      break;
   case fi_tcl_e8_TrafficSignQuantifier::FI_EN_T_U8_PERCENT:
      poQuantifierOfAddSignData = OSAL_NEW fi_tcl_u8_Percent;
      break;
   case fi_tcl_e8_TrafficSignQuantifier::FI_EN_T_B8_LANEDEPENDENTVALIDITY:
      poQuantifierOfAddSignData = OSAL_NEW fi_tcl_b8_LaneDependentValidity;
      break;
   case fi_tcl_e8_TrafficSignQuantifier::FI_EN_T_TIMEDEPENDENTSTRING:
      poQuantifierOfAddSignData = OSAL_NEW fi_tcl_TimeDependentString;
      break;
   case fi_tcl_e8_TrafficSignQuantifier::FI_EN_T_S32_METER:
      poQuantifierOfAddSignData = OSAL_NEW fi_tcl_s32_Meter;
      break;
   case fi_tcl_e8_TrafficSignQuantifier::FI_EN_T_S32_YARDS:
      poQuantifierOfAddSignData = OSAL_NEW fi_tcl_s32_Yards;
      break;
   case fi_tcl_e8_TrafficSignQuantifier::FI_EN_TMULTILANGUAGESTRING:
      poQuantifierOfAddSignData = OSAL_NEW fi_tclMultiLanguageString;
      break;
   case fi_tcl_e8_TrafficSignQuantifier::FI_EN_T_S32_CENTIMETER:
      poQuantifierOfAddSignData = OSAL_NEW fi_tcl_s32_Centimeter;
      break;
   case fi_tcl_e8_TrafficSignQuantifier::FI_EN_T_S32_INCH:
      poQuantifierOfAddSignData = OSAL_NEW fi_tcl_s32_Inch;
      break;
   case fi_tcl_e8_TrafficSignQuantifier::FI_EN_T_S32_KILOGRAM:
      poQuantifierOfAddSignData = OSAL_NEW fi_tcl_s32_Kilogram;
      break;
   case fi_tcl_e8_TrafficSignQuantifier::FI_EN_T_S32_POUND:
      poQuantifierOfAddSignData = OSAL_NEW fi_tcl_s32_Pound;
      break;
   default:
      oIn.Invalidate();
      poQuantifierOfAddSignData = OSAL_NULL;
   }
   if (poQuantifierOfAddSignData && oIn.bIsValid())
      poQuantifierOfAddSignData->oRead(oIn);
   else
      oIn.Invalidate();
   return oIn;
}

fi_tclOutContext& fi_tcl_AdditionalTrafficSign::oWrite(fi_tclOutContext& oOut) const
{
   oOut << AdditionalSign;
   oOut << QuantifierOfAddSignType;
   if (poQuantifierOfAddSignData)
   {
      if (QuantifierOfAddSignType.enType == fi_tcl_e8_TrafficSignQuantifier::FI_EN_T_RESERVED)
      {
         poQuantifierOfAddSignData->oWrite(oOut);
      }
      if (QuantifierOfAddSignType.enType == fi_tcl_e8_TrafficSignQuantifier::FI_EN_T_S16_KMPERHOUR)
      {
         poQuantifierOfAddSignData->oWrite(oOut);
      }
      if (QuantifierOfAddSignType.enType == fi_tcl_e8_TrafficSignQuantifier::FI_EN_T_S16_MILESPERHOUR)
      {
         poQuantifierOfAddSignData->oWrite(oOut);
      }
      if (QuantifierOfAddSignType.enType == fi_tcl_e8_TrafficSignQuantifier::FI_EN_TSTRING)
      {
         poQuantifierOfAddSignData->oWrite(oOut);
      }
      if (QuantifierOfAddSignType.enType == fi_tcl_e8_TrafficSignQuantifier::FI_EN_T_U8_PERCENT)
      {
         poQuantifierOfAddSignData->oWrite(oOut);
      }
      if (QuantifierOfAddSignType.enType == fi_tcl_e8_TrafficSignQuantifier::FI_EN_T_B8_LANEDEPENDENTVALIDITY)
      {
         poQuantifierOfAddSignData->oWrite(oOut);
      }
      if (QuantifierOfAddSignType.enType == fi_tcl_e8_TrafficSignQuantifier::FI_EN_T_TIMEDEPENDENTSTRING)
      {
         poQuantifierOfAddSignData->oWrite(oOut);
      }
      if (QuantifierOfAddSignType.enType == fi_tcl_e8_TrafficSignQuantifier::FI_EN_T_S32_METER)
      {
         poQuantifierOfAddSignData->oWrite(oOut);
      }
      if (QuantifierOfAddSignType.enType == fi_tcl_e8_TrafficSignQuantifier::FI_EN_T_S32_YARDS)
      {
         poQuantifierOfAddSignData->oWrite(oOut);
      }
      if (QuantifierOfAddSignType.enType == fi_tcl_e8_TrafficSignQuantifier::FI_EN_TMULTILANGUAGESTRING)
      {
         poQuantifierOfAddSignData->oWrite(oOut);
      }
      if (QuantifierOfAddSignType.enType == fi_tcl_e8_TrafficSignQuantifier::FI_EN_T_S32_CENTIMETER)
      {
         if (!(7 <= oOut.u16GetMajorVersion()))
         {
            fi_tcl_Reserved oDefault;
            oOut << oDefault;
         }
         else
         {
            poQuantifierOfAddSignData->oWrite(oOut);
         }
      }
      if (QuantifierOfAddSignType.enType == fi_tcl_e8_TrafficSignQuantifier::FI_EN_T_S32_INCH)
      {
         if (!(7 <= oOut.u16GetMajorVersion()))
         {
            fi_tcl_Reserved oDefault;
            oOut << oDefault;
         }
         else
         {
            poQuantifierOfAddSignData->oWrite(oOut);
         }
      }
      if (QuantifierOfAddSignType.enType == fi_tcl_e8_TrafficSignQuantifier::FI_EN_T_S32_KILOGRAM)
      {
         if (!(7 <= oOut.u16GetMajorVersion()))
         {
            fi_tcl_Reserved oDefault;
            oOut << oDefault;
         }
         else
         {
            poQuantifierOfAddSignData->oWrite(oOut);
         }
      }
      if (QuantifierOfAddSignType.enType == fi_tcl_e8_TrafficSignQuantifier::FI_EN_T_S32_POUND)
      {
         if (!(7 <= oOut.u16GetMajorVersion()))
         {
            fi_tcl_Reserved oDefault;
            oOut << oDefault;
         }
         else
         {
            poQuantifierOfAddSignData->oWrite(oOut);
         }
      }
   }
   else
   {
      oOut.Invalidate();
   }
   return oOut;
}

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
fi_tcl_TrafficSignElement::fi_tcl_TrafficSignElement(const fi_tcl_TrafficSignElement& coRef):fi_tclVisitableTypeBase(coRef)
{
   DynamicTrafficSign = coRef.DynamicTrafficSign;
   VirtualTrafficSign = coRef.VirtualTrafficSign;
   BaseSignUnionType = coRef.BaseSignUnionType;
   if  (coRef.poBaseSignUnionData)
   {
      switch(BaseSignUnionType.enType)
      {
      case fi_tcl_e8_BaseTrafficSignCategory::FI_EN_T_RESERVED:
         poBaseSignUnionData = OSAL_NEW fi_tcl_Reserved((const fi_tcl_Reserved&)*coRef.poBaseSignUnionData);
         break;
      case fi_tcl_e8_BaseTrafficSignCategory::FI_EN_T_E8_SPEEDSIGN:
         poBaseSignUnionData = OSAL_NEW fi_tcl_e8_SpeedSign((const fi_tcl_e8_SpeedSign&)*coRef.poBaseSignUnionData);
         break;
      case fi_tcl_e8_BaseTrafficSignCategory::FI_EN_T_E16_WARNINGSIGN:
         poBaseSignUnionData = OSAL_NEW fi_tcl_e16_WarningSign((const fi_tcl_e16_WarningSign&)*coRef.poBaseSignUnionData);
         break;
      case fi_tcl_e8_BaseTrafficSignCategory::FI_EN_T_E16_REGULATORYSIGN:
         poBaseSignUnionData = OSAL_NEW fi_tcl_e16_RegulatorySign((const fi_tcl_e16_RegulatorySign&)*coRef.poBaseSignUnionData);
         break;
      default:
         poBaseSignUnionData = OSAL_NULL;
      }
   }
   else
   {
      poBaseSignUnionData = OSAL_NULL;
   }
   QuantifierOfBaseSignType = coRef.QuantifierOfBaseSignType;
   if  (coRef.poQuantifierOfBaseSignData)
   {
      switch(QuantifierOfBaseSignType.enType)
      {
      case fi_tcl_e8_TrafficSignQuantifier::FI_EN_T_RESERVED:
         poQuantifierOfBaseSignData = OSAL_NEW fi_tcl_Reserved((const fi_tcl_Reserved&)*coRef.poQuantifierOfBaseSignData);
         break;
      case fi_tcl_e8_TrafficSignQuantifier::FI_EN_T_S16_KMPERHOUR:
         poQuantifierOfBaseSignData = OSAL_NEW fi_tcl_s16_KmPerHour((const fi_tcl_s16_KmPerHour&)*coRef.poQuantifierOfBaseSignData);
         break;
      case fi_tcl_e8_TrafficSignQuantifier::FI_EN_T_S16_MILESPERHOUR:
         poQuantifierOfBaseSignData = OSAL_NEW fi_tcl_s16_MilesPerHour((const fi_tcl_s16_MilesPerHour&)*coRef.poQuantifierOfBaseSignData);
         break;
      case fi_tcl_e8_TrafficSignQuantifier::FI_EN_TSTRING:
         poQuantifierOfBaseSignData = OSAL_NEW fi_tclString((const fi_tclString&)*coRef.poQuantifierOfBaseSignData);
         break;
      case fi_tcl_e8_TrafficSignQuantifier::FI_EN_T_U8_PERCENT:
         poQuantifierOfBaseSignData = OSAL_NEW fi_tcl_u8_Percent((const fi_tcl_u8_Percent&)*coRef.poQuantifierOfBaseSignData);
         break;
      case fi_tcl_e8_TrafficSignQuantifier::FI_EN_T_B8_LANEDEPENDENTVALIDITY:
         poQuantifierOfBaseSignData = OSAL_NEW fi_tcl_b8_LaneDependentValidity((const fi_tcl_b8_LaneDependentValidity&)*coRef.poQuantifierOfBaseSignData);
         break;
      case fi_tcl_e8_TrafficSignQuantifier::FI_EN_T_TIMEDEPENDENTSTRING:
         poQuantifierOfBaseSignData = OSAL_NEW fi_tcl_TimeDependentString((const fi_tcl_TimeDependentString&)*coRef.poQuantifierOfBaseSignData);
         break;
      case fi_tcl_e8_TrafficSignQuantifier::FI_EN_T_S32_METER:
         poQuantifierOfBaseSignData = OSAL_NEW fi_tcl_s32_Meter((const fi_tcl_s32_Meter&)*coRef.poQuantifierOfBaseSignData);
         break;
      case fi_tcl_e8_TrafficSignQuantifier::FI_EN_T_S32_YARDS:
         poQuantifierOfBaseSignData = OSAL_NEW fi_tcl_s32_Yards((const fi_tcl_s32_Yards&)*coRef.poQua