#include "precompiled.hh"
#include "alltypefactory.h"

fi_tclTypeBase* fi_poGetFIObject(tU16 u16ServiceId, tU16 u16FunctionId, tU8 u8Opcode)
{
   fi_tclTypeBase *poRetType = OSAL_NULL;
   fi_tclMessageBase* poType = OSAL_NULL;
   poType = fi_poGetMessageBaseObject(u16ServiceId, u16FunctionId, u8Opcode);
   if (poType)
   {
      poRetType = &poType->rfoGetTypeBase();
   }
   return poRetType;
}

fi_tclMessageBase* fi_poGetMessageBaseObject(tU16 u16ServiceId, tU16 u16FunctionId, tU8 u8Opcode)
{
   fi_tclMessageBase* poRetType = OSAL_NULL;
   switch(u16ServiceId)
   {
   case CATALOGUEFI_C_U16_SERVICE_ID:
      switch ((u16FunctionId << 16) + (u8Opcode << 8))
      {
      case cataloguefi_tclToken::EN_MSG_GETFILECONTENTMETHODSTART:
         poRetType = OSAL_NEW cataloguefi_tclMsgGetFileContentMethodStart;
         break;
      case cataloguefi_tclToken::EN_MSG_GETFILECONTENTMETHODRESULT:
         poRetType = OSAL_NEW cataloguefi_tclMsgGetFileContentMethodResult;
         break;
      case cataloguefi_tclToken::EN_MSG_GETCATALOGUEFILEMETHODSTART:
         poRetType = OSAL_NEW cataloguefi_tclMsgGetCatalogueFileMethodStart;
         break;
      case cataloguefi_tclToken::EN_MSG_GETCATALOGUEFILEMETHODRESULT:
         poRetType = OSAL_NEW cataloguefi_tclMsgGetCatalogueFileMethodResult;
         break;
      case cataloguefi_tclToken::EN_MSG_FIREACTIONMETHODSTART:
         poRetType = OSAL_NEW cataloguefi_tclMsgFireActionMethodStart;
         break;
      case cataloguefi_tclToken::EN_MSG_FIREACTIONMETHODRESULT:
         poRetType = OSAL_NEW cataloguefi_tclMsgFireActionMethodResult;
         break;
      case cataloguefi_tclToken::EN_MSG_FILESYSTEMLISTENERUPREG:
         poRetType = OSAL_NEW cataloguefi_tclMsgFileSystemListenerUpReg;
         break;
      case cataloguefi_tclToken::EN_MSG_FILESYSTEMLISTENERSTATUS:
         poRetType = OSAL_NEW cataloguefi_tclMsgFileSystemListenerStatus;
         break;
      case cataloguefi_tclToken::EN_MSG_FILESYSTEMLISTENERRELUPREG:
         poRetType = OSAL_NEW cataloguefi_tclMsgFileSystemListenerRelUpReg;
         break;
      default: 
         poRetType = OSAL_NULL;
      }
      break;
   case DAP_DEVMANFI_C_U16_SERVICE_ID:
      switch ((u16FunctionId << 16) + (u8Opcode << 8))
      {
      case dap_devmanfi_tclToken::EN_MSG_WRITETOFILEMETHODSTART:
         poRetType = OSAL_NEW dap_devmanfi_tclMsgWriteToFileMethodStart;
         break;
      case dap_devmanfi_tclToken::EN_MSG_WRITETOFILEMETHODRESULT:
         poRetType = OSAL_NEW dap_devmanfi_tclMsgWriteToFileMethodResult;
         break;
      case dap_devmanfi_tclToken::EN_MSG_TIMERPROCESSEDMETHODSTART:
         poRetType = OSAL_NEW dap_devmanfi_tclMsgTimerProcessedMethodStart;
         break;
      case dap_devmanfi_tclToken::EN_MSG_TIMERPROCESSEDMETHODRESULT:
         poRetType = OSAL_NEW dap_devmanfi_tclMsgTimerProcessedMethodResult;
         break;
      case dap_devmanfi_tclToken::EN_MSG_RENAMEMETHODSTART:
         poRetType = OSAL_NEW dap_devmanfi_tclMsgRenameMethodStart;
         break;
      case dap_devmanfi_tclToken::EN_MSG_RENAMEMETHODRESULT:
         poRetType = OSAL_NEW dap_devmanfi_tclMsgRenameMethodResult;
         break;
      case dap_devmanfi_tclToken::EN_MSG_REMOVEFILESMETHODSTART:
         poRetType = OSAL_NEW dap_devmanfi_tclMsgRemoveFilesMethodStart;
         break;
      case dap_devmanfi_tclToken::EN_MSG_REMOVEFILESMETHODRESULT:
         poRetType = OSAL_NEW dap_devmanfi_tclMsgRemoveFilesMethodResult;
         break;
      case dap_devmanfi_tclToken::EN_MSG_REMOVEDIRECTORYMETHODSTART:
         poRetType = OSAL_NEW dap_devmanfi_tclMsgRemoveDirectoryMethodStart;
         break;
      case dap_devmanfi_tclToken::EN_MSG_REMOVEDIRECTORYMETHODRESULT:
         poRetType = OSAL_NEW dap_devmanfi_tclMsgRemoveDirectoryMethodResult;
         break;
      case dap_devmanfi_tclToken::EN_MSG_REGIONMETADATAUPREG:
         poRetType = OSAL_NEW dap_devmanfi_tclMsgRegionMetaDataUpReg;
         break;
      case dap_devmanfi_tclToken::EN_MSG_REGIONMETADATASTATUS:
         poRetType = OSAL_NEW dap_devmanfi_tclMsgRegionMetaDataStatus;
         break;
      case dap_devmanfi_tclToken::EN_MSG_REGIONMETADATARELUPREG:
         poRetType = OSAL_NEW dap_devmanfi_tclMsgRegionMetaDataRelUpReg;
         break;
      case dap_devmanfi_tclToken::EN_MSG_REGIONDESCRIPTIONSUPREG:
         poRetType = OSAL_NEW dap_devmanfi_tclMsgRegionDescriptionsUpReg;
         break;
      case dap_devmanfi_tclToken::EN_MSG_REGIONDESCRIPTIONSSTATUS:
         poRetType = OSAL_NEW dap_devmanfi_tclMsgRegionDescriptionsStatus;
         break;
      case dap_devmanfi_tclToken::EN_MSG_REGIONDESCRIPTIONSRELUPREG:
         poRetType = OSAL_NEW dap_devmanfi_tclMsgRegionDescriptionsRelUpReg;
         break;
      case dap_devmanfi_tclToken::EN_MSG_READDATABLOCKSMETHODSTART:
         poRetType = OSAL_NEW dap_devmanfi_tclMsgReadDataBlocksMethodStart;
         break;
      case dap_devmanfi_tclToken::EN_MSG_READDATABLOCKSMETHODRESULT:
         poRetType = OSAL_NEW dap_devmanfi_tclMsgReadDataBlocksMethodResult;
         break;
      case dap_devmanfi_tclToken::EN_MSG_PRMNOTIFICATIONSTATUS:
         poRetType = OSAL_NEW dap_devmanfi_tclMsgPRMNotificationStatus;
         break;
      case dap_devmanfi_tclToken::EN_MSG_MEDIAINFOUPREG:
         poRetType = OSAL_NEW dap_devmanfi_tclMsgMediaInfoUpReg;
         break;
      case dap_devmanfi_tclToken::EN_MSG_MEDIAINFOSTATUS:
         poRetType = OSAL_NEW dap_devmanfi_tclMsgMediaInfoStatus;
         break;
      case dap_devmanfi_tclToken::EN_MSG_MEDIAINFORELUPREG:
         poRetType = OSAL_NEW dap_devmanfi_tclMsgMediaInfoRelUpReg;
         break;
      case dap_devmanfi_tclToken::EN_MSG_GETFREEDISKSPACEMETHODSTART:
         poRetType = OSAL_NEW dap_devmanfi_tclMsgGetFreeDiskSpaceMethodStart;
         break;
      case dap_devmanfi_tclToken::EN_MSG_GETFREEDISKSPACEMETHODRESULT:
         poRetType = OSAL_NEW dap_devmanfi_tclMsgGetFreeDiskSpaceMethodResult;
         break;
      case dap_devmanfi_tclToken::EN_MSG_GETFILESIZEMETHODSTART:
         poRetType = OSAL_NEW dap_devmanfi_tclMsgGetFileSizeMethodStart;
         break;
      case dap_devmanfi_tclToken::EN_MSG_GETFILESIZEMETHODRESULT:
         poRetType = OSAL_NEW dap_devmanfi_tclMsgGetFileSizeMethodResult;
         break;
      case dap_devmanfi_tclToken::EN_MSG_GETDISCSPACEMETHODSTART:
         poRetType = OSAL_NEW dap_devmanfi_tclMsgGetDiscSpaceMethodStart;
         break;
      case dap_devmanfi_tclToken::EN_MSG_GETDISCSPACEMETHODRESULT:
         poRetType = OSAL_NEW dap_devmanfi_tclMsgGetDiscSpaceMethodResult;
         break;
      case dap_devmanfi_tclToken::EN_MSG_GETDIRECTORYMETHODSTART:
         poRetType = OSAL_NEW dap_devmanfi_tclMsgGetDirectoryMethodStart;
         break;
      case dap_devmanfi_tclToken::EN_MSG_GETDIRECTORYMETHODRESULT:
         poRetType = OSAL_NEW dap_devmanfi_tclMsgGetDirectoryMethodResult;
         break;
      case dap_devmanfi_tclToken::EN_MSG_DEVICESTATUSINFOUPREG:
         poRetType = OSAL_NEW dap_devmanfi_tclMsgDeviceStatusInfoUpReg;
         break;
      case dap_devmanfi_tclToken::EN_MSG_DEVICESTATUSINFOSTATUS:
         poRetType = OSAL_NEW dap_devmanfi_tclMsgDeviceStatusInfoStatus;
         break;
      case dap_devmanfi_tclToken::EN_MSG_DEVICESTATUSINFORELUPREG:
         poRetType = OSAL_NEW dap_devmanfi_tclMsgDeviceStatusInfoRelUpReg;
         break;
      case dap_devmanfi_tclToken::EN_MSG_DEFAULTDEVICESTATUS:
         poRetType = OSAL_NEW dap_devmanfi_tclMsgDefaultDeviceStatus;
         break;
      case dap_devmanfi_tclToken::EN_MSG_DEFAULTDEVICESET:
         poRetType = OSAL_NEW dap_devmanfi_tclMsgDefaultDeviceSet;
         break;
      case dap_devmanfi_tclToken::EN_MSG_DEFAULTDATAINFOUPREG:
         poRetType = OSAL_NEW dap_devmanfi_tclMsgDefaultDataInfoUpReg;
         break;
      case dap_devmanfi_tclToken::EN_MSG_DEFAULTDATAINFOSTATUS:
         poRetType = OSAL_NEW dap_devmanfi_tclMsgDefaultDataInfoStatus;
         break;
      case dap_devmanfi_tclToken::EN_MSG_DEFAULTDATAINFORELUPREG:
         poRetType = OSAL_NEW dap_devmanfi_tclMsgDefaultDataInfoRelUpReg;
         break;
      case dap_devmanfi_tclToken::EN_MSG_DATAVISIBILITYUPREG:
         poRetType = OSAL_NEW dap_devmanfi_tclMsgDataVisibilityUpReg;
         break;
      case dap_devmanfi_tclToken::EN_MSG_DATAVISIBILITYSTATUS:
         poRetType = OSAL_NEW dap_devmanfi_tclMsgDataVisibilityStatus;
         break;
      case dap_devmanfi_tclToken::EN_MSG_DATAVISIBILITYSET:
         poRetType = OSAL_NEW dap_devmanfi_tclMsgDataVisibilitySet;
         break;
      case dap_devmanfi_tclToken::EN_MSG_DATAVISIBILITYRELUPREG:
         poRetType = OSAL_NEW dap_devmanfi_tclMsgDataVisibilityRelUpReg;
         break;
      case dap_devmanfi_tclToken::EN_MSG_DATATYPEINFOUPREG:
         poRetType = OSAL_NEW dap_devmanfi_tclMsgDataTypeInfoUpReg;
         break;
      case dap_devmanfi_tclToken::EN_MSG_DATATYPEINFOSTATUS:
         poRetType = OSAL_NEW dap_devmanfi_tclMsgDataTypeInfoStatus;
         break;
      case dap_devmanfi_tclToken::EN_MSG_DATATYPEINFORELUPREG:
         poRetType = OSAL_NEW dap_devmanfi_tclMsgDataTypeInfoRelUpReg;
         break;
      case dap_devmanfi_tclToken::EN_MSG_CREATEDIRECTORYMETHODSTART:
         poRetType = OSAL_NEW dap_devmanfi_tclMsgCreateDirectoryMethodStart;
         break;
      case dap_devmanfi_tclToken::EN_MSG_CREATEDIRECTORYMETHODRESULT:
         poRetType = OSAL_NEW dap_devmanfi_tclMsgCreateDirectoryMethodResult;
         break;
      case dap_devmanfi_tclToken::EN_MSG_COPYFILESMETHODSTART:
         poRetType = OSAL_NEW dap_devmanfi_tclMsgCopyFilesMethodStart;
         break;
      case dap_devmanfi_tclToken::EN_MSG_COPYFILESMETHODRESULT:
         poRetType = OSAL_NEW dap_devmanfi_tclMsgCopyFilesMethodResult;
         break;
      default: 
         poRetType = OSAL_NULL;
      }
      break;
   case DAP_LIFI_C_U16_SERVICE_ID:
      switch ((u16FunctionId << 16) + (u8Opcode << 8))
      {
      case dap_lifi_tclToken::EN_MSG_SETCURRENTLANGUAGEMETHODSTART:
         poRetType = OSAL_NEW dap_lifi_tclMsgSetCurrentLanguageMethodStart;
         break;
      case dap_lifi_tclToken::EN_MSG_SETCURRENTLANGUAGEMETHODRESULT:
         poRetType = OSAL_NEW dap_lifi_tclMsgSetCurrentLanguageMethodResult;
         break;
      case dap_lifi_tclToken::EN_MSG_RESOLVELOCATIONDESCRIPTIONMETHODSTART:
         poRetType = OSAL_NEW dap_lifi_tclMsgResolveLocationDescriptionMethodStart;
         break;
      case dap_lifi_tclToken::EN_MSG_RESOLVELOCATIONDESCRIPTIONMETHODRESULT:
         poRetType = OSAL_NEW dap_lifi_tclMsgResolveLocationDescriptionMethodResult;
         break;
      case dap_lifi_tclToken::EN_MSG_READLANGUAGESMETHODSTART:
         poRetType = OSAL_NEW dap_lifi_tclMsgReadLanguagesMethodStart;
         break;
      case dap_lifi_tclToken::EN_MSG_READLANGUAGESMETHODRESULT:
         poRetType = OSAL_NEW dap_lifi_tclMsgReadLanguagesMethodResult;
         break;
      case dap_lifi_tclToken::EN_MSG_READBINARYDESTINATIONMETHODSTART:
         poRetType = OSAL_NEW dap_lifi_tclMsgReadBinaryDestinationMethodStart;
         break;
      case dap_lifi_tclToken::EN_MSG_READBINARYDESTINATIONMETHODRESULT:
         poRetType = OSAL_NEW dap_lifi_tclMsgReadBinaryDestinationMethodResult;
         break;
      case dap_lifi_tclToken::EN_MSG_GETOBJECTSMETHODSTART:
         poRetType = OSAL_NEW dap_lifi_tclMsgGetObjectsMethodStart;
         break;
      case dap_lifi_tclToken::EN_MSG_GETOBJECTSMETHODRESULT:
         poRetType = OSAL_NEW dap_lifi_tclMsgGetObjectsMethodResult;
         break;
      case dap_lifi_tclToken::EN_MSG_GETOBJECTDETAILMETHODSTART:
         poRetType = OSAL_NEW dap_lifi_tclMsgGetObjectDetailMethodStart;
         break;
      case dap_lifi_tclToken::EN_MSG_GETOBJECTDETAILMETHODRESULT:
         poRetType = OSAL_NEW dap_lifi_tclMsgGetObjectDetailMethodResult;
         break;
      case dap_lifi_tclToken::EN_MSG_GETOBJECTDESCRIPTIONMETHODSTART:
         poRetType = OSAL_NEW dap_lifi_tclMsgGetObjectDescriptionMethodStart;
         break;
      case dap_lifi_tclToken::EN_MSG_GETOBJECTDESCRIPTIONMETHODRESULT:
         poRetType = OSAL_NEW dap_lifi_tclMsgGetObjectDescriptionMethodResult;
         break;
      case dap_lifi_tclToken::EN_MSG_GETNEARBYSTATESORCOUNTRIESMETHODSTART:
         poRetType = OSAL_NEW dap_lifi_tclMsgGetNearbyStatesOrCountriesMethodStart;
         break;
      case dap_lifi_tclToken::EN_MSG_GETNEARBYSTATESORCOUNTRIESMETHODRESULT:
         poRetType = OSAL_NEW dap_lifi_tclMsgGetNearbyStatesOrCountriesMethodResult;
         break;
      case dap_lifi_tclToken::EN_MSG_GETENTRYLISTMETHODSTART:
         poRetType = OSAL_NEW dap_lifi_tclMsgGetEntryListMethodStart;
         break;
      case dap_lifi_tclToken::EN_MSG_GETENTRYLISTMETHODRESULTMIDDLE:
         poRetType = OSAL_NEW dap_lifi_tclMsgGetEntryListMethodResultMiddle;
         break;
      case dap_lifi_tclToken::EN_MSG_GETENTRYLISTMETHODRESULTLAST:
         poRetType = OSAL_NEW dap_lifi_tclMsgGetEntryListMethodResultLast;
         break;
      case dap_lifi_tclToken::EN_MSG_GETENTRYLISTMETHODRESULTFIRST:
         poRetType = OSAL_NEW dap_lifi_tclMsgGetEntryListMethodResultFirst;
         break;
      case dap_lifi_tclToken::EN_MSG_GETENTRYLISTMETHODRESULT:
         poRetType = OSAL_NEW dap_lifi_tclMsgGetEntryListMethodResult;
         break;
      case dap_lifi_tclToken::EN_MSG_GETELEMENTNUMBERMETHODSTART:
         poRetType = OSAL_NEW dap_lifi_tclMsgGetElementNumberMethodStart;
         break;
      case dap_lifi_tclToken::EN_MSG_GETELEMENTNUMBERMETHODRESULT:
         poRetType = OSAL_NEW dap_lifi_tclMsgGetElementNumberMethodResult;
         break;
      case dap_lifi_tclToken::EN_MSG_GETDATASETSMETHODSTART:
         poRetType = OSAL_NEW dap_lifi_tclMsgGetDataSetsMethodStart;
         break;
      case dap_lifi_tclToken::EN_MSG_GETDATASETSMETHODRESULT:
         poRetType = OSAL_NEW dap_lifi_tclMsgGetDataSetsMethodResult;
         break;
      case dap_lifi_tclToken::EN_MSG_GETADDRESSFORMATTABLEMETHODSTART:
         poRetType = OSAL_NEW dap_lifi_tclMsgGetAddressFormatTableMethodStart;
         break;
      case dap_lifi_tclToken::EN_MSG_GETADDRESSFORMATTABLEMETHODRESULT:
         poRetType = OSAL_NEW dap_lifi_tclMsgGetAddressFormatTableMethodResult;
         break;
      case dap_lifi_tclToken::EN_MSG_GETADDRESSFORMATMETHODSTART:
         poRetType = OSAL_NEW dap_lifi_tclMsgGetAddressFormatMethodStart;
         break;
      case dap_lifi_tclToken::EN_MSG_GETADDRESSFORMATMETHODRESULT:
         poRetType = OSAL_NEW dap_lifi_tclMsgGetAddressFormatMethodResult;
         break;
      case dap_lifi_tclToken::EN_MSG_GETASFCHARACTERSMETHODSTART:
         poRetType = OSAL_NEW dap_lifi_tclMsgGetASFCharactersMethodStart;
         break;
      case dap_lifi_tclToken::EN_MSG_GETASFCHARACTERSMETHODRESULT:
         poRetType = OSAL_NEW dap_lifi_tclMsgGetASFCharactersMethodResult;
         break;
      case dap_lifi_tclToken::EN_MSG_CURRENTSEARCHPROGRESSSTATUS:
         poRetType = OSAL_NEW dap_lifi_tclMsgCurrentSearchProgressStatus;
         break;
      case dap_lifi_tclToken::EN_MSG_CLOSECONTEXTMETHODSTART:
         poRetType = OSAL_NEW dap_lifi_tclMsgCloseContextMethodStart;
         break;
      case dap_lifi_tclToken::EN_MSG_CLOSECONTEXTMETHODRESULT:
         poRetType = OSAL_NEW dap_lifi_tclMsgCloseContextMethodResult;
         break;
      default: 
         poRetType = OSAL_NULL;
      }
      break;
   case DAP_POIFI_C_U16_SERVICE_ID:
      switch ((u16FunctionId << 16) + (u8Opcode << 8))
      {
      case dap_poifi_tclToken::EN_MSG_REASSIGNCATEGORYMETHODSTART:
         poRetType = OSAL_NEW dap_poifi_tclMsgReAssignCategoryMethodStart;
         break;
      case dap_poifi_tclToken::EN_MSG_REASSIGNCATEGORYMETHODRESULT:
         poRetType = OSAL_NEW dap_poifi_tclMsgReAssignCategoryMethodResult;
         break;
      case dap_poifi_tclToken::EN_MSG_OPENFASTMAPCHANNELMETHODSTART:
         poRetType = OSAL_NEW dap_poifi_tclMsgOpenFastMapChannelMethodStart;
         break;
      case dap_poifi_tclToken::EN_MSG_OPENFASTMAPCHANNELMETHODRESULT:
         poRetType = OSAL_NEW dap_poifi_tclMsgOpenFastMapChannelMethodResult;
         break;
      case dap_poifi_tclToken::EN_MSG_IMPORTUPOISMETHODSTART:
         poRetType = OSAL_NEW dap_poifi_tclMsgImportUPOIsMethodStart;
         break;
      case dap_poifi_tclToken::EN_MSG_IMPORTUPOISMETHODRESULT:
         poRetType = OSAL_NEW dap_poifi_tclMsgImportUPOIsMethodResult;
         break;
      case dap_poifi_tclToken::EN_MSG_IMPORTUPOISMETHODABORT:
         poRetType = OSAL_NEW dap_poifi_tclMsgImportUPOIsMethodAbort;
         break;
      case dap_poifi_tclToken::EN_MSG_IMPORTPROGRESSUPREG:
         poRetType = OSAL_NEW dap_poifi_tclMsgImportProgressUpReg;
         break;
      case dap_poifi_tclToken::EN_MSG_IMPORTPROGRESSSTATUS:
         poRetType = OSAL_NEW dap_poifi_tclMsgImportProgressStatus;
         break;
      case dap_poifi_tclToken::EN_MSG_IMPORTPROGRESSRELUPREG:
         poRetType = OSAL_NEW dap_poifi_tclMsgImportProgressRelUpReg;
         break;
      case dap_poifi_tclToken::EN_MSG_IMPORTPROGRESSGET:
         poRetType = OSAL_NEW dap_poifi_tclMsgImportProgressGet;
         break;
      case dap_poifi_tclToken::EN_MSG_IMPORTPOISMETHODSTART:
         poRetType = OSAL_NEW dap_poifi_tclMsgImportPOIsMethodStart;
         break;
      case dap_poifi_tclToken::EN_MSG_IMPORTPOISMETHODRESULT:
         poRetType = OSAL_NEW dap_poifi_tclMsgImportPOIsMethodResult;
         break;
      case dap_poifi_tclToken::EN_MSG_IMPORTPOISMETHODABORT:
         poRetType = OSAL_NEW dap_poifi_tclMsgImportPOIsMethodAbort;
         break;
      case dap_poifi_tclToken::EN_MSG_GETPOIDATABYTILEIDSMETHODSTART:
         poRetType = OSAL_NEW dap_poifi_tclMsgGetPOIDataByTileIDsMethodStart;
         break;
      case dap_poifi_tclToken::EN_MSG_GETPOIDATABYTILEIDSMETHODRESULTMIDDLE:
         poRetType = OSAL_NEW dap_poifi_tclMsgGetPOIDataByTileIDsMethodResultMiddle;
         break;
      case dap_poifi_tclToken::EN_MSG_GETPOIDATABYTILEIDSMETHODRESULTLAST:
         poRetType = OSAL_NEW dap_poifi_tclMsgGetPOIDataByTileIDsMethodResultLast;
         break;
      case dap_poifi_tclToken::EN_MSG_GETPOIDATABYTILEIDSMETHODRESULTFIRST:
         poRetType = OSAL_NEW dap_poifi_tclMsgGetPOIDataByTileIDsMethodResultFirst;
         break;
      case dap_poifi_tclToken::EN_MSG_GETPOIDATABYTILEIDSMETHODRESULT:
         poRetType = OSAL_NEW dap_poifi_tclMsgGetPOIDataByTileIDsMethodResult;
         break;
      case dap_poifi_tclToken::EN_MSG_GETPOIDATABYOUTLINEMETHODSTART:
         poRetType = OSAL_NEW dap_poifi_tclMsgGetPOIDataByOutlineMethodStart;
         break;
      case dap_poifi_tclToken::EN_MSG_GETPOIDATABYOUTLINEMETHODRESULTMIDDLE:
         poRetType = OSAL_NEW dap_poifi_tclMsgGetPOIDataByOutlineMethodResultMiddle;
         break;
      case dap_poifi_tclToken::EN_MSG_GETPOIDATABYOUTLINEMETHODRESULTLAST:
         poRetType = OSAL_NEW dap_poifi_tclMsgGetPOIDataByOutlineMethodResultLast;
         break;
      case dap_poifi_tclToken::EN_MSG_GETPOIDATABYOUTLINEMETHODRESULTFIRST:
         poRetType = OSAL_NEW dap_poifi_tclMsgGetPOIDataByOutlineMethodResultFirst;
         break;
      case dap_poifi_tclToken::EN_MSG_GETPOIDATABYOUTLINEMETHODRESULT:
         poRetType = OSAL_NEW dap_poifi_tclMsgGetPOIDataByOutlineMethodResult;
         break;
      case dap_poifi_tclToken::EN_MSG_GETMAPIDSMETHODSTART:
         poRetType = OSAL_NEW dap_poifi_tclMsgGetMapIdsMethodStart;
         break;
      case dap_poifi_tclToken::EN_MSG_GETMAPIDSMETHODRESULT:
         poRetType = OSAL_NEW dap_poifi_tclMsgGetMapIdsMethodResult;
         break;
      case dap_poifi_tclToken::EN_MSG_EXPORTUPOISMETHODSTART:
         poRetType = OSAL_NEW dap_poifi_tclMsgExportUPOIsMethodStart;
         break;
      case dap_poifi_tclToken::EN_MSG_EXPORTUPOISMETHODRESULT:
         poRetType = OSAL_NEW dap_poifi_tclMsgExportUPOIsMethodResult;
         break;
      case dap_poifi_tclToken::EN_MSG_EXPORTUPOISMETHODABORT:
         poRetType = OSAL_NEW dap_poifi_tclMsgExportUPOIsMethodAbort;
         break;
      case dap_poifi_tclToken::EN_MSG_DELETEPOISMETHODSTART:
         poRetType = OSAL_NEW dap_poifi_tclMsgDeletePOIsMethodStart;
         break;
      case dap_poifi_tclToken::EN_MSG_DELETEPOISMETHODRESULT:
         poRetType = OSAL_NEW dap_poifi_tclMsgDeletePOIsMethodResult;
         break;
      case dap_poifi_tclToken::EN_MSG_DELETECATEGORYMETHODSTART:
         poRetType = OSAL_NEW dap_poifi_tclMsgDeleteCategoryMethodStart;
         break;
      case dap_poifi_tclToken::EN_MSG_DELETECATEGORYMETHODRESULT:
         poRetType = OSAL_NEW dap_poifi_tclMsgDeleteCategoryMethodResult;
         break;
      case dap_poifi_tclToken::EN_MSG_DELETEALLPOISMETHODSTART:
         poRetType = OSAL_NEW dap_poifi_tclMsgDeleteAllPOIsMethodStart;
         break;
      case dap_poifi_tclToken::EN_MSG_DELETEALLPOISMETHODRESULT:
         poRetType = OSAL_NEW dap_poifi_tclMsgDeleteAllPOIsMethodResult;
         break;
      case dap_poifi_tclToken::EN_MSG_CURRENTUPOIDATASETIDUPREG:
         poRetType = OSAL_NEW dap_poifi_tclMsgCurrentUPOIDataSetIdUpReg;
         break;
      case dap_poifi_tclToken::EN_MSG_CURRENTUPOIDATASETIDSTATUS:
         poRetType = OSAL_NEW dap_poifi_tclMsgCurrentUPOIDataSetIdStatus;
         break;
      case dap_poifi_tclToken::EN_MSG_CURRENTUPOIDATASETIDRELUPREG:
         poRetType = OSAL_NEW dap_poifi_tclMsgCurrentUPOIDataSetIdRelUpReg;
         break;
      case dap_poifi_tclToken::EN_MSG_CURRENTUPOIDATASETIDGET:
         poRetType = OSAL_NEW dap_poifi_tclMsgCurrentUPOIDataSetIdGet;
         break;
      case dap_poifi_tclToken::EN_MSG_CLOSEFASTMAPCHANNELMETHODSTART:
         poRetType = OSAL_NEW dap_poifi_tclMsgCloseFastMapChannelMethodStart;
         break;
      case dap_poifi_tclToken::EN_MSG_CLOSEFASTMAPCHANNELMETHODRESULT:
         poRetType = OSAL_NEW dap_poifi_tclMsgCloseFastMapChannelMethodResult;
         break;
      case dap_poifi_tclToken::EN_MSG_AVAILABLEPOITYPESUPREG:
         poRetType = OSAL_NEW dap_poifi_tclMsgAvailablePOITypesUpReg;
         break;
      case dap_poifi_tclToken::EN_MSG_AVAILABLEPOITYPESSTATUS:
         poRetType = OSAL_NEW dap_poifi_tclMsgAvailablePOITypesStatus;
         break;
      case dap_poifi_tclToken::EN_MSG_AVAILABLEPOITYPESRELUPREG:
         poRetType = OSAL_NEW dap_poifi_tclMsgAvailablePOITypesRelUpReg;
         break;
      case dap_poifi_tclToken::EN_MSG_AVAILABLEPOITYPESGET:
         poRetType = OSAL_NEW dap_poifi_tclMsgAvailablePOITypesGet;
         break;
      case dap_poifi_tclToken::EN_MSG_ADDPOISMETHODSTART:
         poRetType = OSAL_NEW dap_poifi_tclMsgAddPOIsMethodStart;
         break;
      case dap_poifi_tclToken::EN_MSG_ADDPOISMETHODRESULT:
         poRetType = OSAL_NEW dap_poifi_tclMsgAddPOIsMethodResult;
         break;
      default: 
         poRetType = OSAL_NULL;
      }
      break;
   case DAP_RAWDATAFI_C_U16_SERVICE_ID:
      switch ((u16FunctionId << 16) + (u8Opcode << 8))
      {
      case dap_rawdatafi_tclToken::EN_MSG_DAP_RD_READBLOCKMETHODSTART:
         poRetType = OSAL_NEW dap_rawdatafi_tclMsgdap_rd_readblockMethodStart;
         break;
      case dap_rawdatafi_tclToken::EN_MSG_DAP_RD_READBLOCKMETHODRESULT:
         poRetType = OSAL_NEW dap_rawdatafi_tclMsgdap_rd_readblockMethodResult;
         break;
      case dap_rawdatafi_tclToken::EN_MSG_DAP_RD_MEDIASPACEMETHODSTART:
         poRetType = OSAL_NEW dap_rawdatafi_tclMsgdap_rd_mediaspaceMethodStart;
         break;
      case dap_rawdatafi_tclToken::EN_MSG_DAP_RD_MEDIASPACEMETHODRESULT:
         poRetType = OSAL_NEW dap_rawdatafi_tclMsgdap_rd_mediaspaceMethodResult;
         break;
      case dap_rawdatafi_tclToken::EN_MSG_DAP_RD_FREEMEDIASPACEMETHODSTART:
         poRetType = OSAL_NEW dap_rawdatafi_tclMsgdap_rd_freemediaspaceMethodStart;
         break;
      case dap_rawdatafi_tclToken::EN_MSG_DAP_RD_FREEMEDIASPACEMETHODRESULT:
         poRetType = OSAL_NEW dap_rawdatafi_tclMsgdap_rd_freemediaspaceMethodResult;
         break;
      case dap_rawdatafi_tclToken::EN_MSG_DAP_RD_FILESIZEMETHODSTART:
         poRetType = OSAL_NEW dap_rawdatafi_tclMsgdap_rd_filesizeMethodStart;
         break;
      case dap_rawdatafi_tclToken::EN_MSG_DAP_RD_FILESIZEMETHODRESULT:
         poRetType = OSAL_NEW dap_rawdatafi_tclMsgdap_rd_filesizeMethodResult;
         break;
      case dap_rawdatafi_tclToken::EN_MSG_DAP_RD_DIRECTORYMETHODSTART:
         poRetType = OSAL_NEW dap_rawdatafi_tclMsgdap_rd_directoryMethodStart;
         break;
      case dap_rawdatafi_tclToken::EN_MSG_DAP_RD_DIRECTORYMETHODRESULT:
         poRetType = OSAL_NEW dap_rawdatafi_tclMsgdap_rd_directoryMethodResult;
         break;
      default: 
         poRetType = OSAL_NULL;
      }
      break;
   case DAP_RESINFFI_C_U16_SERVICE_ID:
      switch ((u16FunctionId << 16) + (u8Opcode << 8))
      {
      case dap_resinffi_tclToken::EN_MSG_DAP_RI_STATEOFWRITEPROTECTIONUPREG:
         poRetType = OSAL_NEW dap_resinffi_tclMsgdap_ri_StateOfWriteProtectionUpReg;
         break;
      case dap_resinffi_tclToken::EN_MSG_DAP_RI_STATEOFWRITEPROTECTIONSTATUS:
         poRetType = OSAL_NEW dap_resinffi_tclMsgdap_ri_StateOfWriteProtectionStatus;
         break;
      case dap_resinffi_tclToken::EN_MSG_DAP_RI_STATEOFWRITEPROTECTIONRELUPREG:
         poRetType = OSAL_NEW dap_resinffi_tclMsgdap_ri_StateOfWriteProtectionRelUpReg;
         break;
      case dap_resinffi_tclToken::EN_MSG_DAP_RI_STATEOFWRITEPROTECTIONGET:
         poRetType = OSAL_NEW dap_resinffi_tclMsgdap_ri_StateOfWriteProtectionGet;
         break;
      case dap_resinffi_tclToken::EN_MSG_DAP_RI_STATEOFDEVICEUPREG:
         poRetType = OSAL_NEW dap_resinffi_tclMsgdap_ri_StateOfDeviceUpReg;
         break;
      case dap_resinffi_tclToken::EN_MSG_DAP_RI_STATEOFDEVICESTATUS:
         poRetType = OSAL_NEW dap_resinffi_tclMsgdap_ri_StateOfDeviceStatus;
         break;
      case dap_resinffi_tclToken::EN_MSG_DAP_RI_STATEOFDEVICERELUPREG:
         poRetType = OSAL_NEW dap_resinffi_tclMsgdap_ri_StateOfDeviceRelUpReg;
         break;
      case dap_resinffi_tclToken::EN_MSG_DAP_RI_STATEOFDEVICEGET:
         poRetType = OSAL_NEW dap_resinffi_tclMsgdap_ri_StateOfDeviceGet;
         break;
      case dap_resinffi_tclToken::EN_MSG_DAP_RI_STATEOFDATAUPREG:
         poRetType = OSAL_NEW dap_resinffi_tclMsgdap_ri_StateOfDataUpReg;
         break;
      case dap_resinffi_tclToken::EN_MSG_DAP_RI_STATEOFDATASTATUS:
         poRetType = OSAL_NEW dap_resinffi_tclMsgdap_ri_StateOfDataStatus;
         break;
      case dap_resinffi_tclToken::EN_MSG_DAP_RI_STATEOFDATARELUPREG:
         poRetType = OSAL_NEW dap_resinffi_tclMsgdap_ri_StateOfDataRelUpReg;
         break;
      case dap_resinffi_tclToken::EN_MSG_DAP_RI_STATEOFDATAGET:
         poRetType = OSAL_NEW dap_resinffi_tclMsgdap_ri_StateOfDataGet;
         break;
      case dap_resinffi_tclToken::EN_MSG_DAP_RI_STATEOFALLDEVICESSTATUS:
         poRetType = OSAL_NEW dap_resinffi_tclMsgdap_ri_StateOfAllDevicesStatus;
         break;
      case dap_resinffi_tclToken::EN_MSG_DAP_RI_STATEOFALLDEVICESGET:
         poRetType = OSAL_NEW dap_resinffi_tclMsgdap_ri_StateOfAllDevicesGet;
         break;
      case dap_resinffi_tclToken::EN_MSG_DAP_RI_STATEOFALLDATASTATUS:
         poRetType = OSAL_NEW dap_resinffi_tclMsgdap_ri_StateOfAllDataStatus;
         break;
      case dap_resinffi_tclToken::EN_MSG_DAP_RI_STATEOFALLDATAGET:
         poRetType = OSAL_NEW dap_resinffi_tclMsgdap_ri_StateOfAllDataGet;
         break;
      case dap_resinffi_tclToken::EN_MSG_DAP_RI_REGIONSOFDEFAULTDATASETUPREG:
         poRetType = OSAL_NEW dap_resinffi_tclMsgdap_ri_RegionsOfDefaultDatasetUpReg;
         break;
      case dap_resinffi_tclToken::EN_MSG_DAP_RI_REGIONSOFDEFAULTDATASETSTATUS:
         poRetType = OSAL_NEW dap_resinffi_tclMsgdap_ri_RegionsOfDefaultDatasetStatus;
         break;
      case dap_resinffi_tclToken::EN_MSG_DAP_RI_REGIONSOFDEFAULTDATASETRELUPREG:
         poRetType = OSAL_NEW dap_resinffi_tclMsgdap_ri_RegionsOfDefaultDatasetRelUpReg;
         break;
      case dap_resinffi_tclToken::EN_MSG_DAP_RI_REGIONSOFDEFAULTDATASETGET:
         poRetType = OSAL_NEW dap_resinffi_tclMsgdap_ri_RegionsOfDefaultDatasetGet;
         break;
      case dap_resinffi_tclToken::EN_MSG_DAP_RI_MEDIASTATEOFDEVICEUPREG:
         poRetType = OSAL_NEW dap_resinffi_tclMsgdap_ri_MediaStateOfDeviceUpReg;
         break;
      case dap_resinffi_tclToken::EN_MSG_DAP_RI_MEDIASTATEOFDEVICESTATUS:
         poRetType = OSAL_NEW dap_resinffi_tclMsgdap_ri_MediaStateOfDeviceStatus;
         break;
      case dap_resinffi_tclToken::EN_MSG_DAP_RI_MEDIASTATEOFDEVICERELUPREG:
         poRetType = OSAL_NEW dap_resinffi_tclMsgdap_ri_MediaStateOfDeviceRelUpReg;
         break;
      case dap_resinffi_tclToken::EN_MSG_DAP_RI_MEDIASTATEOFDEVICEGET:
         poRetType = OSAL_NEW dap_resinffi_tclMsgdap_ri_MediaStateOfDeviceGet;
         break;
      case dap_resinffi_tclToken::EN_MSG_DAP_RI_MEDIASTATEOFALLDEVICESUPREG:
         poRetType = OSAL_NEW dap_resinffi_tclMsgdap_ri_MediaStateOfAllDevicesUpReg;
         break;
      case dap_resinffi_tclToken::EN_MSG_DAP_RI_MEDIASTATEOFALLDEVICESSTATUS:
         poRetType = OSAL_NEW dap_resinffi_tclMsgdap_ri_MediaStateOfAllDevicesStatus;
         break;
      case dap_resinffi_tclToken::EN_MSG_DAP_RI_MEDIASTATEOFALLDEVICESRELUPREG:
         poRetType = OSAL_NEW dap_resinffi_tclMsgdap_ri_MediaStateOfAllDevicesRelUpReg;
         break;
      case dap_resinffi_tclToken::EN_MSG_DAP_RI_MEDIASTATEOFALLDEVICESGET:
         poRetType = OSAL_NEW dap_resinffi_tclMsgdap_ri_MediaStateOfAllDevicesGet;
         break;
      case dap_resinffi_tclToken::EN_MSG_DAP_RI_ENGINEERINGTEXTUPREG:
         poRetType = OSAL_NEW dap_resinffi_tclMsgdap_ri_EngineeringTextUpReg;
         break;
      case dap_resinffi_tclToken::EN_MSG_DAP_RI_ENGINEERINGTEXTSTATUS:
         poRetType = OSAL_NEW dap_resinffi_tclMsgdap_ri_EngineeringTextStatus;
         break;
      case dap_resinffi_tclToken::EN_MSG_DAP_RI_ENGINEERINGTEXTSET:
         poRetType = OSAL_NEW dap_resinffi_tclMsgdap_ri_EngineeringTextSet;
         break;
      case dap_resinffi_tclToken::EN_MSG_DAP_RI_ENGINEERINGTEXTRELUPREG:
         poRetType = OSAL_NEW dap_resinffi_tclMsgdap_ri_EngineeringTextRelUpReg;
         break;
      case dap_resinffi_tclToken::EN_MSG_DAP_RI_ENGINEERINGTEXTGET:
         poRetType = OSAL_NEW dap_resinffi_tclMsgdap_ri_EngineeringTextGet;
         break;
      case dap_resinffi_tclToken::EN_MSG_DAP_RI_DEFAULTREGIONMETADATAUPREG:
         poRetType = OSAL_NEW dap_resinffi_tclMsgdap_ri_DefaultRegionMetaDataUpReg;
         break;
      case dap_resinffi_tclToken::EN_MSG_DAP_RI_DEFAULTREGIONMETADATASTATUS:
         poRetType = OSAL_NEW dap_resinffi_tclMsgdap_ri_DefaultRegionMetaDataStatus;
         break;
      case dap_resinffi_tclToken::EN_MSG_DAP_RI_DEFAULTREGIONMETADATARELUPREG:
         poRetType = OSAL_NEW dap_resinffi_tclMsgdap_ri_DefaultRegionMetaDataRelUpReg;
         break;
      case dap_resinffi_tclToken::EN_MSG_DAP_RI_DEFAULTREGIONMETADATAGET:
         poRetType = OSAL_NEW dap_resinffi_tclMsgdap_ri_DefaultRegionMetaDataGet;
         break;
      case dap_resinffi_tclToken::EN_MSG_DAP_RI_DEFAULTDEVICESTATUS:
         poRetType = OSAL_NEW dap_resinffi_tclMsgdap_ri_DefaultDeviceStatus;
         break;
      case dap_resinffi_tclToken::EN_MSG_DAP_RI_DEFAULTDEVICESET:
         poRetType = OSAL_NEW dap_resinffi_tclMsgdap_ri_DefaultDeviceSet;
         break;
      case dap_resinffi_tclToken::EN_MSG_DAP_RI_DEFAULTDATASETUPREG:
         poRetType = OSAL_NEW dap_resinffi_tclMsgdap_ri_DefaultDatasetUpReg;
         break;
      case dap_resinffi_tclToken::EN_MSG_DAP_RI_DEFAULTDATASETSTATUS:
         poRetType = OSAL_NEW dap_resinffi_tclMsgdap_ri_DefaultDatasetStatus;
         break;
      case dap_resinffi_tclToken::EN_MSG_DAP_RI_DEFAULTDATASETSET:
         poRetType = OSAL_NEW dap_resinffi_tclMsgdap_ri_DefaultDatasetSet;
         break;
      case dap_resinffi_tclToken::EN_MSG_DAP_RI_DEFAULTDATASETRELUPREG:
         poRetType = OSAL_NEW dap_resinffi_tclMsgdap_ri_DefaultDatasetRelUpReg;
         break;
      case dap_resinffi_tclToken::EN_MSG_DAP_RI_DEFAULTDATASETGET:
         poRetType = OSAL_NEW dap_resinffi_tclMsgdap_ri_DefaultDatasetGet;
         break;
      case dap_resinffi_tclToken::EN_MSG_DAP_RI_DEFAULTDATAINFOUPREG:
         poRetType = OSAL_NEW dap_resinffi_tclMsgdap_ri_DefaultDataInfoUpReg;
         break;
      case dap_resinffi_tclToken::EN_MSG_DAP_RI_DEFAULTDATAINFOSTATUS:
         poRetType = OSAL_NEW dap_resinffi_tclMsgdap_ri_DefaultDataInfoStatus;
         break;
      case dap_resinffi_tclToken::EN_MSG_DAP_RI_DEFAULTDATAINFORELUPREG:
         poRetType = OSAL_NEW dap_resinffi_tclMsgdap_ri_DefaultDataInfoRelUpReg;
         break;
      case dap_resinffi_tclToken::EN_MSG_DAP_RI_CTRLDEFAULTDATASETSTATUS:
         poRetType = OSAL_NEW dap_resinffi_tclMsgdap_ri_CtrlDefaultDatasetStatus;
         break;
      case dap_resinffi_tclToken::EN_MSG_DAP_RI_CTRLDEFAULTDATASETSET:
         poRetType = OSAL_NEW dap_resinffi_tclMsgdap_ri_CtrlDefaultDatasetSet;
         break;
      case dap_resinffi_tclToken::EN_MSG_GETLANGUAGEDESCRIPTIONMETHODSTART:
         poRetType = OSAL_NEW dap_resinffi_tclMsgGetLanguageDescriptionMethodStart;
         break;
      case dap_resinffi_tclToken::EN_MSG_GETLANGUAGEDESCRIPTIONMETHODRESULT:
         poRetType = OSAL_NEW dap_resinffi_tclMsgGetLanguageDescriptionMethodResult;
         break;
      case dap_resinffi_tclToken::EN_MSG_GETFILEDESCRIPTIONMETHODSTART:
         poRetType = OSAL_NEW dap_resinffi_tclMsgGetFileDescriptionMethodStart;
         break;
      case dap_resinffi_tclToken::EN_MSG_GETFILEDESCRIPTIONMETHODRESULT:
         poRetType = OSAL_NEW dap_resinffi_tclMsgGetFileDescriptionMethodResult;
         break;
      default: 
         poRetType = OSAL_NULL;
      }
      break;
   case DAP_REGIONSELECTIONFI_C_U16_SERVICE_ID:
      switch ((u16FunctionId << 16) + (u8Opcode << 8))
      {
      case dap_regionselectionfi_tclToken::EN_MSG_STOREREGIONSMETHODSTART:
         poRetType = OSAL_NEW dap_regionselectionfi_tclMsgStoreRegionsMethodStart;
         break;
      case dap_regionselectionfi_tclToken::EN_MSG_STOREREGIONSMETHODRESULT:
         poRetType = OSAL_NEW dap_regionselectionfi_tclMsgStoreRegionsMethodResult;
         break;
      case dap_regionselectionfi_tclToken::EN_MSG_STOREREGIONSMETHODABORT:
         poRetType = OSAL_NEW dap_regionselectionfi_tclMsgStoreRegionsMethodAbort;
         break;
      case dap_regionselectionfi_tclToken::EN_MSG_STOREREGIONSABORTRESULT:
         poRetType = OSAL_NEW dap_regionselectionfi_tclMsgStoreRegionsAbortResult;
         break;
      case dap_regionselectionfi_tclToken::EN_MSG_STORAGEPROGRESSUPREG:
         poRetType = OSAL_NEW dap_regionselectionfi_tclMsgStorageProgressUpReg;
         break;
      case dap_regionselectionfi_tclToken::EN_MSG_STORAGEPROGRESSSTATUS:
         poRetType = OSAL_NEW dap_regionselectionfi_tclMsgStorageProgressStatus;
         break;
      case dap_regionselectionfi_tclToken::EN_MSG_STORAGEPROGRESSRELUPREG:
         poRetType = OSAL_NEW dap_regionselectionfi_tclMsgStorageProgressRelUpReg;
         break;
      case dap_regionselectionfi_tclToken::EN_MSG_STORAGEPROGRESSGET:
         poRetType = OSAL_NEW dap_regionselectionfi_tclMsgStorageProgressGet;
         break;
      case dap_regionselectionfi_tclToken::EN_MSG_RESUMESTORAGEMETHODSTART:
         poRetType = OSAL_NEW dap_regionselectionfi_tclMsgResumeStorageMethodStart;
         break;
      case dap_regionselectionfi_tclToken::EN_MSG_RESUMESTORAGEMETHODRESULT:
         poRetType = OSAL_NEW dap_regionselectionfi_tclMsgResumeStorageMethodResult;
         break;
      case dap_regionselectionfi_tclToken::EN_MSG_RESUMESTORAGEMETHODABORT:
         poRetType = OSAL_NEW dap_regionselectionfi_tclMsgResumeStorageMethodAbort;
         break;
      case dap_regionselectionfi_tclToken::EN_MSG_RESUMESTORAGEABORTRESULT:
         poRetType = OSAL_NEW dap_regionselectionfi_tclMsgResumeStorageAbortResult;
         break;
      case dap_regionselectionfi_tclToken::EN_MSG_LASTORDERLISTSTATUS:
         poRetType = OSAL_NEW dap_regionselectionfi_tclMsgLastOrderListStatus;
         break;
      case dap_regionselectionfi_tclToken::EN_MSG_LASTORDERLISTGET:
         poRetType = OSAL_NEW dap_regionselectionfi_tclMsgLastOrderListGet;
         break;
      case dap_regionselectionfi_tclToken::EN_MSG_GETREGIONOUTLINESMETHODSTART:
         poRetType = OSAL_NEW dap_regionselectionfi_tclMsgGetRegionOutlinesMethodStart;
         break;
      case dap_regionselectionfi_tclToken::EN_MSG_GETREGIONOUTLINESMETHODRESULT:
         poRetType = OSAL_NEW dap_regionselectionfi_tclMsgGetRegionOutlinesMethodResult;
         break;
      case dap_regionselectionfi_tclToken::EN_MSG_GETREGIONLISTMETHODSTART:
         poRetType = OSAL_NEW dap_regionselectionfi_tclMsgGetRegionListMethodStart;
         break;
      case dap_regionselectionfi_tclToken::EN_MSG_GETREGIONLISTMETHODRESULT:
         poRetType = OSAL_NEW dap_regionselectionfi_tclMsgGetRegionListMethodResult;
         break;
      case dap_regionselectionfi_tclToken::EN_MSG_GETLINKDEVICESTATUS:
         poRetType = OSAL_NEW dap_regionselectionfi_tclMsgGetLinkDeviceStatus;
         break;
      case dap_regionselectionfi_tclToken::EN_MSG_GETLINKDEVICEGET:
         poRetType = OSAL_NEW dap_regionselectionfi_tclMsgGetLinkDeviceGet;
         break;
      case dap_regionselectionfi_tclToken::EN_MSG_GETFREEMEMORYMETHODSTART:
         poRetType = OSAL_NEW dap_regionselectionfi_tclMsgGetFreeMemoryMethodStart;
         break;
      case dap_regionselectionfi_tclToken::EN_MSG_GETFREEMEMORYMETHODRESULT:
         poRetType = OSAL_NEW dap_regionselectionfi_tclMsgGetFreeMemoryMethodResult;
         break;
      case dap_regionselectionfi_tclToken::EN_MSG_ENGINEERINGTEXTUPREG:
         poRetType = OSAL_NEW dap_regionselectionfi_tclMsgEngineeringTextUpReg;
         break;
      case dap_regionselectionfi_tclToken::EN_MSG_ENGINEERINGTEXTSTATUS:
         poRetType = OSAL_NEW dap_regionselectionfi_tclMsgEngineeringTextStatus;
         break;
      case dap_regionselectionfi_tclToken::EN_MSG_ENGINEERINGTEXTRELUPREG:
         poRetType = OSAL_NEW dap_regionselectionfi_tclMsgEngineeringTextRelUpReg;
         break;
      case dap_regionselectionfi_tclToken::EN_MSG_ENGINEERINGTEXTGET:
         poRetType = OSAL_NEW dap_regionselectionfi_tclMsgEngineeringTextGet;
         break;
      default: 
         poRetType = OSAL_NULL;
      }
      break;
   case DAP_RNWFI_C_U16_SERVICE_ID:
      switch ((u16FunctionId << 16) + (u8Opcode << 8))
      {
      case dap_rnwfi_tclToken::EN_MSG_DAP_RNW_READCLUSTERMETHODSTART:
         poRetType = OSAL_NEW dap_rnwfi_tclMsgdap_rnw_readclusterMethodStart;
         break;
      case dap_rnwfi_tclToken::EN_MSG_DAP_RNW_READCLUSTERMETHODRESULT:
         poRetType = OSAL_NEW dap_rnwfi_tclMsgdap_rnw_readclusterMethodResult;
         break;
      case dap_rnwfi_tclToken::EN_MSG_REQUESTUSERIDENTMETHODSTART:
         poRetType = OSAL_NEW dap_rnwfi_tclMsgRequestUserIdentMethodStart;
         break;
      case dap_rnwfi_tclToken::EN_MSG_REQUESTUSERIDENTMETHODRESULT:
         poRetType = OSAL_NEW dap_rnwfi_tclMsgRequestUserIdentMethodResult;
         break;
      case dap_rnwfi_tclToken::EN_MSG_REQUESTGLOBALDATAMETHODSTART:
         poRetType = OSAL_NEW dap_rnwfi_tclMsgRequestGlobalDataMethodStart;
         break;
      case dap_rnwfi_tclToken::EN_MSG_REQUESTGLOBALDATAMETHODRESULT:
         poRetType = OSAL_NEW dap_rnwfi_tclMsgRequestGlobalDataMethodResult;
         break;
      case dap_rnwfi_tclToken::EN_MSG_REQUESTDATAMETHODSTART:
         poRetType = OSAL_NEW dap_rnwfi_tclMsgRequestDataMethodStart;
         break;
      case dap_rnwfi_tclToken::EN_MSG_REQUESTDATAMETHODRESULT:
         poRetType = OSAL_NEW dap_rnwfi_tclMsgRequestDataMethodResult;
         break;
      case dap_rnwfi_tclToken::EN_MSG_RELEASEUSERIDENTMETHODSTART:
         poRetType = OSAL_NEW dap_rnwfi_tclMsgReleaseUserIdentMethodStart;
         break;
      case dap_rnwfi_tclToken::EN_MSG_RELEASEUSERIDENTMETHODRESULT:
         poRetType = OSAL_NEW dap_rnwfi_tclMsgReleaseUserIdentMethodResult;
         break;
      case dap_rnwfi_tclToken::EN_MSG_RELEASEGLOBALDATAMETHODSTART:
         poRetType = OSAL_NEW dap_rnwfi_tclMsgReleaseGlobalDataMethodStart;
         break;
      case dap_rnwfi_tclToken::EN_MSG_RELEASEGLOBALDATAMETHODRESULT:
         poRetType = OSAL_NEW dap_rnwfi_tclMsgReleaseGlobalDataMethodResult;
         break;
      case dap_rnwfi_tclToken::EN_MSG_RELEASEDATAMETHODSTART:
         poRetType = OSAL_NEW dap_rnwfi_tclMsgReleaseDataMethodStart;
         break;
      case dap_rnwfi_tclToken::EN_MSG_RELEASEDATAMETHODRESULT:
         poRetType = OSAL_NEW dap_rnwfi_tclMsgReleaseDataMethodResult;
         break;
      case dap_rnwfi_tclToken::EN_MSG_GETROOTFILEHEADERMETHODSTART:
         poRetType = OSAL_NEW dap_rnwfi_tclMsgGetRootFileHeaderMethodStart;
         break;
      case dap_rnwfi_tclToken::EN_MSG_GETROOTFILEHEADERMETHODRESULT:
         poRetType = OSAL_NEW dap_rnwfi_tclMsgGetRootFileHeaderMethodResult;
         break;
      case dap_rnwfi_tclToken::EN_MSG_GETREGPROFOUTLINEMETHODSTART:
         poRetType = OSAL_NEW dap_rnwfi_tclMsgGetRegProfOutlineMethodStart;
         break;
      case dap_rnwfi_tclToken::EN_MSG_GETREGPROFOUTLINEMETHODRESULT:
         poRetType = OSAL_NEW dap_rnwfi_tclMsgGetRegProfOutlineMethodResult;
         break;
      case dap_rnwfi_tclToken::EN_MSG_GETPREFIXTABLEMETHODSTART:
         poRetType = OSAL_NEW dap_rnwfi_tclMsgGetPrefixTableMethodStart;
         break;
      case dap_rnwfi_tclToken::EN_MSG_GETPREFIXTABLEMETHODRESULT:
         poRetType = OSAL_NEW dap_rnwfi_tclMsgGetPrefixTableMethodResult;
         break;
      case dap_rnwfi_tclToken::EN_MSG_GETMAPBLOCKSMETHODSTART:
         poRetType = OSAL_NEW dap_rnwfi_tclMsgGetMapBlocksMethodStart;
         break;
      case dap_rnwfi_tclToken::EN_MSG_GETMAPBLOCKSMETHODRESULT:
         poRetType = OSAL_NEW dap_rnwfi_tclMsgGetMapBlocksMethodResult;
         break;
      case dap_rnwfi_tclToken::EN_MSG_GETGLOBALINSTRUCTIONRECORDMETHODSTART:
         poRetType = OSAL_NEW dap_rnwfi_tclMsgGetGlobalInstructionRecordMethodStart;
         break;
      case dap_rnwfi_tclToken::EN_MSG_GETGLOBALINSTRUCTIONRECORDMETHODRESULT:
         poRetType = OSAL_NEW dap_rnwfi_tclMsgGetGlobalInstructionRecordMethodResult;
         break;
      case dap_rnwfi_tclToken::EN_MSG_GETGLOBALAREARECORDMETHODSTART:
         poRetType = OSAL_NEW dap_rnwfi_tclMsgGetGlobalAreaRecordMethodStart;
         break;
      case dap_rnwfi_tclToken::EN_MSG_GETGLOBALAREARECORDMETHODRESULT:
         poRetType = OSAL_NEW dap_rnwfi_tclMsgGetGlobalAreaRecordMethodResult;
         break;
      case dap_rnwfi_tclToken::EN_MSG_GETDATASTORAGEINFOMETHODSTART:
         poRetType = OSAL_NEW dap_rnwfi_tclMsgGetDataStorageInfoMethodStart;
         break;
      case dap_rnwfi_tclToken::EN_MSG_GETDATASTORAGEINFOMETHODRESULT:
         poRetType = OSAL_NEW dap_rnwfi_tclMsgGetDataStorageInfoMethodResult;
         break;
      case dap_rnwfi_tclToken::EN_MSG_DEFAULTDATASETIDUPREG:
         poRetType = OSAL_NEW dap_rnwfi_tclMsgDefaultDatasetIdUpReg;
         break;
      case dap_rnwfi_tclToken::EN_MSG_DEFAULTDATASETIDSTATUS:
         poRetType = OSAL_NEW dap_rnwfi_tclMsgDefaultDatasetIdStatus;
         break;
      case dap_rnwfi_tclToken::EN_MSG_DEFAULTDATASETIDRELUPREG:
         poRetType = OSAL_NEW dap_rnwfi_tclMsgDefaultDatasetIdRelUpReg;
         break;
      case dap_rnwfi_tclToken::EN_MSG_DEFAULTDATASETIDGET:
         poRetType = OSAL_NEW dap_rnwfi_tclMsgDefaultDatasetIdGet;
         break;
      case dap_rnwfi_tclToken::EN_MSG_CONVERTONECELLLISTMETHODSTART:
         poRetType = OSAL_NEW dap_rnwfi_tclMsgConvertOnecellListMethodStart;
         break;
      case dap_rnwfi_tclToken::EN_MSG_CONVERTONECELLLISTMETHODRESULT:
         poRetType = OSAL_NEW dap_rnwfi_tclMsgConvertOnecellListMethodResult;
         break;
      case dap_rnwfi_tclToken::EN_MSG_BREAKDOWNROUTEOCMETHODSTART:
         poRetType = OSAL_NEW dap_rnwfi_tclMsgBreakDownRouteOCMethodStart;
         break;
      case dap_rnwfi_tclToken::EN_MSG_BREAKDOWNROUTEOCMETHODRESULT:
         poRetType = OSAL_NEW dap_rnwfi_tclMsgBreakDownRouteOCMethodResult;
         break;
      default: 
         poRetType = OSAL_NULL;
      }
      break;
   case DAP_TMCFI_C_U16_SERVICE_ID:
      switch ((u16FunctionId << 16) + (u8Opcode << 8))
      {
      case dap_tmcfi_tclToken::EN_MSG_PREFIXTABLEMETHODSTART:
         poRetType = OSAL_NEW dap_tmcfi_tclMsgPrefixTableMethodStart;
         break;
      case dap_tmcfi_tclToken::EN_MSG_PREFIXTABLEMETHODRESULT:
         poRetType = OSAL_NEW dap_tmcfi_tclMsgPrefixTableMethodResult;
         break;
      case dap_tmcfi_tclToken::EN_MSG_LOCATIONTABLELISTMETHODSTART:
         poRetType = OSAL_NEW dap_tmcfi_tclMsgLocationTableListMethodStart;
         break;
      case dap_tmcfi_tclToken::EN_MSG_LOCATIONTABLELISTMETHODRESULT:
         poRetType = OSAL_NEW dap_tmcfi_tclMsgLocationTableListMethodResult;
         break;
      case dap_tmcfi_tclToken::EN_MSG_LANGUAGEIDLISTMETHODSTART:
         poRetType = OSAL_NEW dap_tmcfi_tclMsgLanguageIdListMethodStart;
         break;
      case dap_tmcfi_tclToken::EN_MSG_LANGUAGEIDLISTMETHODRESULT:
         poRetType = OSAL_NEW dap_tmcfi_tclMsgLanguageIdListMethodResult;
         break;
      case dap_tmcfi_tclToken::EN_MSG_GETLOCATIONMETHODSTART:
         poRetType = OSAL_NEW dap_tmcfi_tclMsgGetLocationMethodStart;
         break;
      case dap_tmcfi_tclToken::EN_MSG_GETLOCATIONMETHODRESULT:
         poRetType = OSAL_NEW dap_tmcfi_tclMsgGetLocationMethodResult;
         break;
      case dap_tmcfi_tclToken::EN_MSG_BSAIDLISTMETHODSTART:
         poRetType = OSAL_NEW dap_tmcfi_tclMsgBSAIdListMethodStart;
         break;
      case dap_tmcfi_tclToken::EN_MSG_BSAIDLISTMETHODRESULT:
         poRetType = OSAL_NEW dap_tmcfi_tclMsgBSAIdListMethodResult;
         break;
      default: 
         poRetType = OSAL_NULL;
      }
      break;
   case FASTMAPFI_C_U16_SERVICE_ID:
      switch ((u16FunctionId << 16) + (u8Opcode << 8))
      {
      case fastmapfi_tclToken::EN_MSG_RESERVECLIENTUSEIDRANGEMETHODSTART:
         poRetType = OSAL_NEW fastmapfi_tclMsgReserveClientUseIdRangeMethodStart;
         break;
      case fastmapfi_tclToken::EN_MSG_RESERVECLIENTUSEIDRANGEMETHODRESULT:
         poRetType = OSAL_NEW fastmapfi_tclMsgReserveClientUseIdRangeMethodResult;
         break;
      case fastmapfi_tclToken::EN_MSG_OPENFASTMAPCHANNELMETHODSTART:
         poRetType = OSAL_NEW fastmapfi_tclMsgOpenFastMapChannelMethodStart;
         break;
      case fastmapfi_tclToken::EN_MSG_OPENFASTMAPCHANNELMETHODRESULT:
         poRetType = OSAL_NEW fastmapfi_tclMsgOpenFastMapChannelMethodResult;
         break;
      case fastmapfi_tclToken::EN_MSG_LOADBLOCKSMETHODSTART:
         poRetType = OSAL_NEW fastmapfi_tclMsgLoadBlocksMethodStart;
         break;
      case fastmapfi_tclToken::EN_MSG_LOADBLOCKSMETHODRESULT:
         poRetType = OSAL_NEW fastmapfi_tclMsgLoadBlocksMethodResult;
         break;
      case fastmapfi_tclToken::EN_MSG_LOADBLOCKSMETHODABORT:
         poRetType = OSAL_NEW fastmapfi_tclMsgLoadBlocksMethodAbort;
         break;
      case fastmapfi_tclToken::EN_MSG_LOADBLOCKSABORTRESULT:
         poRetType = OSAL_NEW fastmapfi_tclMsgLoadBlocksAbortResult;
         break;
      case fastmapfi_tclToken::EN_MSG_GETCLIENTIDRANGEBYNAMEMETHODSTART:
         poRetType = OSAL_NEW fastmapfi_tclMsgGetClientIdRangeByNameMethodStart;
         break;
      case fastmapfi_tclToken::EN_MSG_GETCLIENTIDRANGEBYNAMEMETHODRESULT:
         poRetType = OSAL_NEW fastmapfi_tclMsgGetClientIdRangeByNameMethodResult;
         break;
      case fastmapfi_tclToken::EN_MSG_GETBLOCKIDSMETHODSTART:
         poRetType = OSAL_NEW fastmapfi_tclMsgGetBlockIDsMethodStart;
         break;
      case fastmapfi_tclToken::EN_MSG_GETBLOCKIDSMETHODRESULT:
         poRetType = OSAL_NEW fastmapfi_tclMsgGetBlockIDsMethodResult;
         break;
      case fastmapfi_tclToken::EN_MSG_FREECLIENTUSEDIDRANGEMETHODSTART:
         poRetType = OSAL_NEW fastmapfi_tclMsgFreeClientUsedIdRangeMethodStart;
         break;
      case fastmapfi_tclToken::EN_MSG_FREECLIENTUSEDIDRANGEMETHODRESULT:
         poRetType = OSAL_NEW fastmapfi_tclMsgFreeClientUsedIdRangeMethodResult;
         break;
      case fastmapfi_tclToken::EN_MSG_ENGINEERINGTEXTUPREG:
         poRetType = OSAL_NEW fastmapfi_tclMsgEngineeringTextUpReg;
         break;
      case fastmapfi_tclToken::EN_MSG_ENGINEERINGTEXTSTATUS:
         poRetType = OSAL_NEW fastmapfi_tclMsgEngineeringTextStatus;
         break;
      case fastmapfi_tclToken::EN_MSG_ENGINEERINGTEXTRELUPREG:
         poRetType = OSAL_NEW fastmapfi_tclMsgEngineeringTextRelUpReg;
         break;
      case fastmapfi_tclToken::EN_MSG_ENGINEERINGTEXTGET:
         poRetType = OSAL_NEW fastmapfi_tclMsgEngineeringTextGet;
         break;
      case fastmapfi_tclToken::EN_MSG_DATABLOCKSCHANGEDUPREG:
         poRetType = OSAL_NEW fastmapfi_tclMsgDatablocksChangedUpReg;
         break;
      case fastmapfi_tclToken::EN_MSG_DATABLOCKSCHANGEDSTATUS:
         poRetType = OSAL_NEW fastmapfi_tclMsgDatablocksChangedStatus;
         break;
      case fastmapfi_tclToken::EN_MSG_DATABLOCKSCHANGEDRELUPREG:
         poRetType = OSAL_NEW fastmapfi_tclMsgDatablocksChangedRelUpReg;
         break;
      case fastmapfi_tclToken::EN_MSG_CONVERTONECELLLISTMETHODSTART:
         poRetType = OSAL_NEW fastmapfi_tclMsgConvertOnecellListMethodStart;
         break;
      case fastmapfi_tclToken::EN_MSG_CONVERTONECELLLISTMETHODRESULT:
         poRetType = OSAL_NEW fastmapfi_tclMsgConvertOnecellListMethodResult;
         break;
      case fastmapfi_tclToken::EN_MSG_CLOSEFASTMAPCHANNELMETHODSTART:
         poRetType = OSAL_NEW fastmapfi_tclMsgCloseFastMapChannelMethodStart;
         break;
      case fastmapfi_tclToken::EN_MSG_CLOSEFASTMAPCHANNELMETHODRESULT:
         poRetType = OSAL_NEW fastmapfi_tclMsgCloseFastMapChannelMethodResult;
         break;
      case fastmapfi_tclToken::EN_MSG_BREAKDOWNROUTEOCMETHODSTART:
         poRetType = OSAL_NEW fastmapfi_tclMsgBreakDownRouteOCMethodStart;
         break;
      case fastmapfi_tclToken::EN_MSG_BREAKDOWNROUTEOCMETHODRESULT:
         poRetType = OSAL_NEW fastmapfi_tclMsgBreakDownRouteOCMethodResult;
         break;
      default: 
         poRetType = OSAL_NULL;
      }
      break;
   case FUELFI_C_U16_SERVICE_ID:
      switch ((u16FunctionId << 16) + (u8Opcode << 8))
      {
      case fuelfi_tclToken::EN_MSG_NEWFUELPRICESAVAILABLEUPREG:
         poRetType = OSAL_NEW fuelfi_tclMsgNewFuelPricesAvailableUpReg;
         break;
      case fuelfi_tclToken::EN_MSG_NEWFUELPRICESAVAILABLESTATUS:
         poRetType = OSAL_NEW fuelfi_tclMsgNewFuelPricesAvailableStatus;
         break;
      case fuelfi_tclToken::EN_MSG_NEWFUELPRICESAVAILABLERELUPREG:
         poRetType = OSAL_NEW fuelfi_tclMsgNewFuelPricesAvailableRelUpReg;
         break;
      case fuelfi_tclToken::EN_MSG_NEWFUELPRICESAVAILABLEGET:
         poRetType = OSAL_NEW fuelfi_tclMsgNewFuelPricesAvailableGet;
         break;
      case fuelfi_tclToken::EN_MSG_GETLISTOFFUELTYPESMETHODSTART:
         poRetType = OSAL_NEW fuelfi_tclMsgGetListOfFuelTypesMethodStart;
         break;
      case fuelfi_tclToken::EN_MSG_GETLISTOFFUELTYPESMETHODRESULT:
         poRetType = OSAL_NEW fuelfi_tclMsgGetListOfFuelTypesMethodResult;
         break;
      case fuelfi_tclToken::EN_MSG_GETLISTOFFUELSTATIONDESCRIPTIONMETHODSTART:
         poRetType = OSAL_NEW fuelfi_tclMsgGetListOfFuelStationDescriptionMethodStart;
         break;
      case fuelfi_tclToken::EN_MSG_GETLISTOFFUELSTATIONDESCRIPTIONMETHODRESULT:
         poRetType = OSAL_NEW fuelfi_tclMsgGetListOfFuelStationDescriptionMethodResult;
         break;
      case fuelfi_tclToken::EN_MSG_GETLISTOFFUELPRICEDATABYPOSITIONMETHODSTART:
         poRetType = OSAL_NEW fuelfi_tclMsgGetListOfFuelPriceDataByPositionMethodStart;
         break;
      case fuelfi_tclToken::EN_MSG_GETLISTOFFUELPRICEDATABYPOSITIONMETHODRESULT:
         poRetType = OSAL_NEW fuelfi_tclMsgGetListOfFuelPriceDataByPositionMethodResult;
         break;
      case fuelfi_tclToken::EN_MSG_GETFUELPRICEDATAMETHODSTART:
         poRetType = OSAL_NEW fuelfi_tclMsgGetFuelPriceDataMethodStart;
         break;
      case fuelfi_tclToken::EN_MSG_GETFUELPRICEDATAMETHODRESULT:
         poRetType = OSAL_NEW fuelfi_tclMsgGetFuelPriceDataMethodResult;
         break;
      case fuelfi_tclToken::EN_MSG_ENGINEERINGTEXTUPREG:
         poRetType = OSAL_NEW fuelfi_tclMsgEngineeringTextUpReg;
         break;
      case fuelfi_tclToken::EN_MSG_ENGINEERINGTEXTSTATUS:
         poRetType = OSAL_NEW fuelfi_tclMsgEngineeringTextStatus;
         break;
      case fuelfi_tclToken::EN_MSG_ENGINEERINGTEXTRELUPREG:
         poRetType = OSAL_NEW fuelfi_tclMsgEngineeringTextRelUpReg;
         break;
      case fuelfi_tclToken::EN_MSG_ENGINEERINGTEXTGET:
         poRetType = OSAL_NEW fuelfi_tclMsgEngineeringTextGet;
         break;
      default: 
         poRetType = OSAL_NULL;
      }
      break;
   case INTEDMFI_C_U16_SERVICE_ID:
      switch ((u16FunctionId << 16) + (u8Opcode << 8))
      {
      case intedmfi_tclToken::EN_MSG_TRAFFICMESSAGEDATASETSTATUS:
         poRetType = OSAL_NEW intedmfi_tclMsgTrafficMessageDataSetStatus;
         break;
      case intedmfi_tclToken::EN_MSG_TRAFFICMESSAGEDATASETGET:
         poRetType = OSAL_NEW intedmfi_tclMsgTrafficMessageDataSetGet;
         break;
      case intedmfi_tclToken::EN_MSG_GETTRAFFICMESSAGEONECELLSMETHODSTART:
         poRetType = OSAL_NEW intedmfi_tclMsgGetTrafficMessageOneCellsMethodStart;
         break;
      case intedmfi_tclToken::EN_MSG_GETTRAFFICMESSAGEONECELLSMETHODRESULT:
         poRetType = OSAL_NEW intedmfi_tclMsgGetTrafficMessageOneCellsMethodResult;
         break;
      case intedmfi_tclToken::EN_MSG_GETTRAFFICMESSAGEINTERSECTIONONECELLSMETHODSTART:
         poRetType = OSAL_NEW intedmfi_tclMsgGetTrafficMessageIntersectionOneCellsMethodStart;
         break;
      case intedmfi_tclToken::EN_MSG_GETTRAFFICMESSAGEINTERSECTIONONECELLSMETHODRESULT:
         poRetType = OSAL_NEW intedmfi_tclMsgGetTrafficMessageIntersectionOneCellsMethodResult;
         break;
      case intedmfi_tclToken::EN_MSG_GETEXISTINGRDBSMETHODSTART:
         poRetType = OSAL_NEW intedmfi_tclMsgGetExistingRDBsMethodStart;
         break;
      case intedmfi_tclToken::EN_MSG_GETEXISTINGRDBSMETHODRESULT:
         poRetType = OSAL_NEW intedmfi_tclMsgGetExistingRDBsMethodResult;
         break;
      case intedmfi_tclToken::EN_MSG_ENGINEERINGTEXTUPREG:
         poRetType = OSAL_NEW intedmfi_tclMsgEngineeringTextUpReg;
         break;
      case intedmfi_tclToken::EN_MSG_ENGINEERINGTEXTSTATUS:
         poRetType = OSAL_NEW intedmfi_tclMsgEngineeringTextStatus;
         break;
      case intedmfi_tclToken::EN_MSG_ENGINEERINGTEXTRELUPREG:
         poRetType = OSAL_NEW intedmfi_tclMsgEngineeringTextRelUpReg;
         break;
      case intedmfi_tclToken::EN_MSG_ENGINEERINGTEXTGET:
         poRetType = OSAL_NEW intedmfi_tclMsgEngineeringTextGet;
         break;
      case intedmfi_tclToken::EN_MSG_CHECKTRAFFICMESSAGESTRANSLATABLETOTEXTMETHODSTART:
         poRetType = OSAL_NEW intedmfi_tclMsgCheckTrafficMessagesTranslatableToTextMethodStart;
         break;
      case intedmfi_tclToken::EN_MSG_CHECKTRAFFICMESSAGESTRANSLATABLETOTEXTMETHODRESULT:
         poRetType = OSAL_NEW intedmfi_tclMsgCheckTrafficMessagesTranslatableToTextMethodResult;
         break;
      case intedmfi_tclToken::EN_MSG_CHECKMOCDBCLIENTSMETHODSTART:
         poRetType = OSAL_NEW intedmfi_tclMsgCheckMOCDBClientsMethodStart;
         break;
      case intedmfi_tclToken::EN_MSG_CHECKMOCDBCLIENTSMETHODRESULT:
         poRetType = OSAL_NEW intedmfi_tclMsgCheckMOCDBClientsMethodResult;
         break;
      default: 
         poRetType = OSAL_NULL;
      }
      break;
   case INTNAVIFI_C_U16_SERVICE_ID:
      switch ((u16FunctionId << 16) + (u8Opcode << 8))
      {
      case intnavifi_tclToken::EN_MSG_WAKEUPSTATUS:
         poRetType = OSAL_NEW intnavifi_tclMsgWakeUpStatus;
         break;
      case intnavifi_tclToken::EN_MSG_UPDATEMEDIAIDMETHODSTART:
         poRetType = OSAL_NEW intnavifi_tclMsgUpdateMediaIdMethodStart;
         break;
      case intnavifi_tclToken::EN_MSG_UPDATEMEDIAIDMETHODRESULT:
         poRetType = OSAL_NEW intnavifi_tclMsgUpdateMediaIdMethodResult;
         break;
      case intnavifi_tclToken::EN_MSG_SMTIMEOUTMETHODSTART:
         poRetType = OSAL_NEW intnavifi_tclMsgSMTimeOutMethodStart;
         break;
      case intnavifi_tclToken::EN_MSG_SMTIMEOUTMETHODRESULT:
         poRetType = OSAL_NEW intnavifi_tclMsgSMTimeOutMethodResult;
         break;
      case intnavifi_tclToken::EN_MSG_MEDIUMAVAILSTATUS:
         poRetType = OSAL_NEW intnavifi_tclMsgMediumAvailStatus;
         break;
      case intnavifi_tclToken::EN_MSG_MEDIUMAVAILGET:
         poRetType = OSAL_NEW intnavifi_tclMsgMediumAvailGet;
         break;
      case intnavifi_tclToken::EN_MSG_LOCDATABASESTATUS:
         poRetType = OSAL_NEW intnavifi_tclMsgLocDatabaseStatus;
         break;
      case intnavifi_tclToken::EN_MSG_LOCDATABASEGET:
         poRetType = OSAL_NEW intnavifi_tclMsgLocDatabaseGet;
         break;
      case intnavifi_tclToken::EN_MSG_GETUPOISMETHODSTART:
         poRetType = OSAL_NEW intnavifi_tclMsgGetUPOIsMethodStart;
         break;
      case intnavifi_tclToken::EN_MSG_GETUPOISMETHODRESULTMIDDLE:
         poRetType = OSAL_NEW intnavifi_tclMsgGetUPOIsMethodResultMiddle;
         break;
      case intnavifi_tclToken::EN_MSG_GETUPOISMETHODRESULTLAST:
         poRetType = OSAL_NEW intnavifi_tclMsgGetUPOIsMethodResultLast;
         break;
      case intnavifi_tclToken::EN_MSG_GETUPOISMETHODRESULTFIRST:
         poRetType = OSAL_NEW intnavifi_tclMsgGetUPOIsMethodResultFirst;
         break;
      case intnavifi_tclToken::EN_MSG_GETUPOISMETHODRESULT:
         poRetType = OSAL_NEW intnavifi_tclMsgGetUPOIsMethodResult;
         break;
      case intnavifi_tclToken::EN_MSG_GETSPECIFICTRAFFICMESSAGESMETHODSTART:
         poRetType = OSAL_NEW intnavifi_tclMsgGetSpecificTrafficMessagesMethodStart;
         break;
      case intnavifi_tclToken::EN_MSG_GETSPECIFICTRAFFICMESSAGESMETHODRESULT:
         poRetType = OSAL_NEW intnavifi_tclMsgGetSpecificTrafficMessagesMethodResult;
         break;
      case intnavifi_tclToken::EN_MSG_GETROADPATHINFOMETHODSTART:
         poRetType = OSAL_NEW intnavifi_tclMsgGetRoadPathInfoMethodStart;
         break;
      case intnavifi_tclToken::EN_MSG_GETROADPATHINFOMETHODRESULTMIDDLE:
         poRetType = OSAL_NEW intnavifi_tclMsgGetRoadPathInfoMethodResultMiddle;
         break;
      case intnavifi_tclToken::EN_MSG_GETROADPATHINFOMETHODRESULTLAST:
         poRetType = OSAL_NEW intnavifi_tclMsgGetRoadPathInfoMethodResultLast;
         break;
      case intnavifi_tclToken::EN_MSG_GETROADPATHINFOMETHODRESULTFIRST:
         poRetType = OSAL_NEW intnavifi_tclMsgGetRoadPathInfoMethodResultFirst;
         break;
      case intnavifi_tclToken::EN_MSG_GETROADPATHINFOMETHODRESULT:
         poRetType = OSAL_NEW intnavifi_tclMsgGetRoadPathInfoMethodResult;
         break;
      case intnavifi_tclToken::EN_MSG_FORCELOCDATABASEUPDATEMETHODSTART:
         poRetType = OSAL_NEW intnavifi_tclMsgForceLocDatabaseUpdateMethodStart;
         break;
      case intnavifi_tclToken::EN_MSG_FORCELOCDATABASEUPDATEMETHODRESULT:
         poRetType = OSAL_NEW intnavifi_tclMsgForceLocDatabaseUpdateMethodResult;
         break;
      case intnavifi_tclToken::EN_MSG_ENGINEERINGTEXTUPREG:
         poRetType = OSAL_NEW intnavifi_tclMsgEngineeringTextUpReg;
         break;
      case intnavifi_tclToken::EN_MSG_ENGINEERINGTEXTSTATUS:
         poRetType = OSAL_NEW intnavifi_tclMsgEngineeringTextStatus;
         break;
      case intnavifi_tclToken::EN_MSG_ENGINEERINGTEXTRELUPREG:
         poRetType = OSAL_NEW intnavifi_tclMsgEngineeringTextRelUpReg;
         break;
      case intnavifi_tclToken::EN_MSG_ENGINEERINGTEXTGET:
         poRetType = OSAL_NEW intnavifi_tclMsgEngineeringTextGet;
         break;
      default: 
         poRetType = OSAL_NULL;
      }
      break;
   case INTWDBFI_C_U16_SERVICE_ID:
      switch ((u16FunctionId << 16) + (u8Opcode << 8))
      {
      case intwdbfi_tclToken::EN_MSG_WEATHERDATACHANGEDUPREG:
         poRetType = OSAL_NEW intwdbfi_tclMsgWeatherDataChangedUpReg;
         break;
      case intwdbfi_tclToken::EN_MSG_WEATHERDATACHANGEDSTATUS:
         poRetType = OSAL_NEW intwdbfi_tclMsgWeatherDataChangedStatus;
         break;
      case intwdbfi_tclToken::EN_MSG_WEATHERDATACHANGEDRELUPREG:
         poRetType = OSAL_NEW intwdbfi_tclMsgWeatherDataChangedRelUpReg;
         break;
      case intwdbfi_tclToken::EN_MSG_WEATHERDATACHANGEDGET:
         poRetType = OSAL_NEW intwdbfi_tclMsgWeatherDataChangedGet;
         break;
      case intwdbfi_tclToken::EN_MSG_ENGINEERINGTEXTUPREG:
         poRetType = OSAL_NEW intwdbfi_tclMsgEngineeringTextUpReg;
         break;
      case intwdbfi_tclToken::EN_MSG_ENGINEERINGTEXTSTATUS:
         poRetType = OSAL_NEW intwdbfi_tclMsgEngineeringTextStatus;
         break;
      case intwdbfi_tclToken::EN_MSG_ENGINEERINGTEXTRELUPREG:
         poRetType = OSAL_NEW intwdbfi_tclMsgEngineeringTextRelUpReg;
         break;
      case intwdbfi_tclToken::EN_MSG_ENGINEERINGTEXTGET:
         poRetType = OSAL_NEW intwdbfi_tclMsgEngineeringTextGet;
         break;
      case intwdbfi_tclToken::EN_MSG_DATAAVAILABILITYCHANGEDUPREG:
         poRetType = OSAL_NEW intwdbfi_tclMsgDataAvailabilityChangedUpReg;
         break;
      case intwdbfi_tclToken::EN_MSG_DATAAVAILABILITYCHANGEDSTATUS:
         poRetType = OSAL_NEW intwdbfi_tclMsgDataAvailabilityChangedStatus;
         break;
      case intwdbfi_tclToken::EN_MSG_DATAAVAILABILITYCHANGEDRELUPREG:
         poRetType = OSAL_NEW intwdbfi_tclMsgDataAvailabilityChangedRelUpReg;
         break;
      case intwdbfi_tclToken::EN_MSG_DATAAVAILABILITYCHANGEDGET:
         poRetType = OSAL_NEW intwdbfi_tclMsgDataAvailabilityChangedGet;
         break;
      default: 
         poRetType = OSAL_NULL;
      }
      break;
   case LIFI_C_U16_SERVICE_ID:
      switch ((u16FunctionId << 16) + (u8Opcode << 8))
      {
      case lifi_tclToken::EN_MSG_USEDDATASETUPREG:
         poRetType = OSAL_NEW lifi_tclMsgUsedDatasetUpReg;
         break;
      case lifi_tclToken::EN_MSG_USEDDATASETSTATUS:
         poRetType = OSAL_NEW lifi_tclMsgUsedDatasetStatus;
         break;
      case lifi_tclToken::EN_MSG_USEDDATASETRELUPREG:
         poRetType = OSAL_NEW lifi_tclMsgUsedDatasetRelUpReg;
         break;
      case lifi_tclToken::EN_MSG_USEDDATASETGET:
         poRetType = OSAL_NEW lifi_tclMsgUsedDatasetGet;
         break;
      case lifi_tclToken::EN_MSG_TRANSFORMLOCATIONDESCRIPTIONMATCHEDPOSMETHODSTART:
         poRetType = OSAL_NEW lifi_tclMsgTransformLocationDescriptionMatchedPosMethodStart;
         break;
      case lifi_tclToken::EN_MSG_TRANSFORMLOCATIONDESCRIPTIONMATCHEDPOSMETHODRESULT:
         poRetType = OSAL_NEW lifi_tclMsgTransformLocationDescriptionMatchedPosMethodResult;
         break;
      case lifi_tclToken::EN_MSG_TRANSFORMLOCATIONDESCRIPTIONMETHODSTART:
         poRetType = OSAL_NEW lifi_tclMsgTransformLocationDescriptionMethodStart;
         break;
      case lifi_tclToken::EN_MSG_TRANSFORMLOCATIONDESCRIPTIONMETHODRESULT:
         poRetType = OSAL_NEW lifi_tclMsgTransformLocationDescriptionMethodResult;
         break;
      case lifi_tclToken::EN_MSG_GETSPELLERCHARACTERSMETHODSTART:
         poRetType = OSAL_NEW lifi_tclMsgGetSpellerCharactersMethodStart;
         break;
      case lifi_tclToken::EN_MSG_GETSPELLERCHARACTERSMETHODRESULT:
         poRetType = OSAL_NEW lifi_tclMsgGetSpellerCharactersMethodResult;
         break;
      case lifi_tclToken::EN_MSG_GETSELECTIONCRITERIADESCRIPTIONMETHODSTART:
         poRetType = OSAL_NEW lifi_tclMsgGetSelectionCriteriaDescriptionMethodStart;
         break;
      case lifi_tclToken::EN_MSG_GETSELECTIONCRITERIADESCRIPTIONMETHODRESULT:
         poRetType = OSAL_NEW lifi_tclMsgGetSelectionCriteriaDescriptionMethodResult;
         break;
      case lifi_tclToken::EN_MSG_GETSELECTIONCRITERIAMETHODSTART:
         poRetType = OSAL_NEW lifi_tclMsgGetSelectionCriteriaMethodStart;
         break;
      case lifi_tclToken::EN_MSG_GETSELECTIONCRITERIAMETHODRESULT:
         poRetType = OSAL_NEW lifi_tclMsgGetSelectionCriteriaMethodResult;
         break;
      case lifi_tclToken::EN_MSG_GETNEARBYSTATESORCOUNTRIESMETHODSTART:
         poRetType = OSAL_NEW lifi_tclMsgGetNearbyStatesOrCountriesMethodStart;
         break;
      case lifi_tclToken::EN_MSG_GETNEARBYSTATESORCOUNTRIESMETHODRESULT:
         poRetType = OSAL_NEW lifi_tclMsgGetNearbyStatesOrCountriesMethodResult;
         break;
      case lifi_tclToken::EN_MSG_GETELEMENTNAMELISTMETHODSTART:
         poRetType = OSAL_NEW lifi_tclMsgGetElementNameListMethodStart;
         break;
      case lifi_tclToken::EN_MSG_GETELEMENTNAMELISTMETHODRESULT:
         poRetType = OSAL_NEW lifi_tclMsgGetElementNameListMethodResult;
         break;
      case lifi_tclToken::EN_MSG_GETELEMENTCOUNTMETHODSTART:
         poRetType = OSAL_NEW lifi_tclMsgGetElementCountMethodStart;
         break;
      case lifi_tclToken::EN_MSG_GETELEMENTCOUNTMETHODRESULT:
         poRetType = OSAL_NEW lifi_tclMsgGetElementCountMethodResult;
         break;
      case lifi_tclToken::EN_MSG_GETDETAILEDELEMENTDESCRIPTIONMETHODSTART:
         poRetType = OSAL_NEW lifi_tclMsgGetDetailedElementDescriptionMethodStart;
         break;
      case lifi_tclToken::EN_MSG_GETDETAILEDELEMENTDESCRIPTIONMETHODRESULT:
         poRetType = OSAL_NEW lifi_tclMsgGetDetailedElementDescriptionMethodResult;
         break;
      case lifi_tclToken::EN_MSG_GETAVAILABLEUILANGUAGESMETHODSTART:
         poRetType = OSAL_NEW lifi_tclMsgGetAvailableUILanguagesMethodStart;
         break;
      case lifi_tclToken::EN_MSG_GETAVAILABLEUILANGUAGESMETHODRESULT:
         poRetType = OSAL_NEW lifi_tclMsgGetAvailableUILanguagesMethodResult;
         break;
      case lifi_tclToken::EN_MSG_GETATTRIBUTEHIERARCHYMETHODSTART:
         poRetType = OSAL_NEW lifi_tclMsgGetAttributeHierarchyMethodStart;
         break;
      case lifi_tclToken::EN_MSG_GETATTRIBUTEHIERARCHYMETHODRESULT:
         poRetType = OSAL_NEW lifi_tclMsgGetAttributeHierarchyMethodResult;
         break;
      case lifi_tclToken::EN_MSG_GETALLSPELLERCHARACTERSMETHODSTART:
         poRetType = OSAL_NEW lifi_tclMsgGetAllSpellerCharactersMethodStart;
         break;
      case lifi_tclToken::EN_MSG_GETALLSPELLERCHARACTERSMETHODRESULT:
         poRetType = OSAL_NEW lifi_tclMsgGetAllSpellerCharactersMethodResult;
         break;
      case lifi_tclToken::EN_MSG_GETADDRESSFORMATTABLEMETHODSTART:
         poRetType = OSAL_NEW lifi_tclMsgGetAddressFormatTableMethodStart;
         break;
      case lifi_tclToken::EN_MSG_GETADDRESSFORMATTABLEMETHODRESULT:
         poRetType = OSAL_NEW lifi_tclMsgGetAddressFormatTableMethodResult;
         break;
      case lifi_tclToken::EN_MSG_GETADDRESSFORMATMETHODSTART:
         poRetType = OSAL_NEW lifi_tclMsgGetAddressFormatMethodStart;
         break;
      case lifi_tclToken::EN_MSG_GETADDRESSFORMATMETHODRESULT:
         poRetType = OSAL_NEW lifi_tclMsgGetAddressFormatMethodResult;
         break;
      case lifi_tclToken::EN_MSG_ENGINEERINGTEXTUPREG:
         poRetType = OSAL_NEW lifi_tclMsgEngineeringTextUpReg;
         break;
      case lifi_tclToken::EN_MSG_ENGINEERINGTEXTSTATUS:
         poRetType = OSAL_NEW lifi_tclMsgEngineeringTextStatus;
         break;
      case lifi_tclToken::EN_MSG_ENGINEERINGTEXTRELUPREG:
         poRetType = OSAL_NEW lifi_tclMsgEngineeringTextRelUpReg;
         break;
      case lifi_tclToken::EN_MSG_ENGINEERINGTEXTGET:
         poRetType = OSAL_NEW lifi_tclMsgEngineeringTextGet;
         break;
      case lifi_tclToken::EN_MSG_DESTINATIONINPUTINPROGRESSSTATUS:
         poRetType = OSAL_NEW lifi_tclMsgDestinationInputInProgressStatus;
         break;
      case lifi_tclToken::EN_MSG_DESTINATIONINPUTINPROGRESSGET:
         poRetType = OSAL_NEW lifi_tclMsgDestinationInputInProgressGet;
         break;
      case lifi_tclToken::EN_MSG_CURRENTSEARCHPROGRESSUPREG:
         poRetType = OSAL_NEW lifi_tclMsgCurrentSearchProgressUpReg;
         break;
      case lifi_tclToken::EN_MSG_CURRENTSEARCHPROGRESSSTATUS:
         poRetType = OSAL_NEW lifi_tclMsgCurrentSearchProgressStatus;
         break;
      case lifi_tclToken::EN_MSG_CURRENTSEARCHPROGRESSRELUPREG:
         poRetType = OSAL_NEW lifi_tclMsgCurrentSearchProgressRelUpReg;
         break;
      case lifi_tclToken::EN_MSG_CURRENTSEARCHPROGRESSGET:
         poRetType = OSAL_NEW lifi_tclMsgCurrentSearchProgressGet;
         break;
      default: 
         poRetType = OSAL_NULL;
      }
      break;
   case INTMAPFI_C_U16_SERVICE_ID:
      switch ((u16FunctionId << 16) + (u8Opcode << 8))
      {
      case intmapfi_tclToken::EN_MSG_USEDDATASETUPREG:
         poRetType = OSAL_NEW intmapfi_tclMsgUsedDatasetUpReg;
         break;
      case intmapfi_tclToken::EN_MSG_USEDDATASETSTATUS:
         poRetType = OSAL_NEW intmapfi_tclMsgUsedDatasetStatus;
         break;
      case intmapfi_tclToken::EN_MSG_USEDDATASETRELUPREG:
         poRetType = OSAL_NEW intmapfi_tclMsgUsedDatasetRelUpReg;
         break;
      case intmapfi_tclToken::EN_MSG_USEDDATASETGET:
         poRetType = OSAL_NEW intmapfi_tclMsgUsedDatasetGet;
         break;
      case intmapfi_tclToken::EN_MSG_SETSCALECONFIGMETHODSTART:
         poRetType = OSAL_NEW intmapfi_tclMsgSetScaleConfigMethodStart;
         break;
      case intmapfi_tclToken::EN_MSG_SETSCALECONFIGMETHODRESULT:
         poRetType = OSAL_NEW intmapfi_tclMsgSetScaleConfigMethodResult;
         break;
      case intmapfi_tclToken::EN_MSG_SETRESERVEDCACHINGAREASMETHODSTART:
         poRetType = OSAL_NEW intmapfi_tclMsgSetReservedCachingAreasMethodStart;
         break;
      case intmapfi_tclToken::EN_MSG_SETRESERVEDCACHINGAREASMETHODRESULT:
         poRetType = OSAL_NEW intmapfi_tclMsgSetReservedCachingAreasMethodResult;
         break;
      case intmapfi_tclToken::EN_MSG_PARAMETERCHANGESTATUS:
         poRetType = OSAL_NEW intmapfi_tclMsgParameterChangeStatus;
         break;
      case intmapfi_tclToken::EN_MSG_PARAMETERCHANGEGET:
         poRetType = OSAL_NEW intmapfi_tclMsgParameterChangeGet;
         break;
      case intmapfi_tclToken::EN_MSG_GETREGIONMETHODSTART:
         poRetType = OSAL_NEW intmapfi_tclMsgGetRegionMethodStart;
         break;
      case intmapfi_tclToken::EN_MSG_GETREGIONMETHODRESULT:
         poRetType = OSAL_NEW intmapfi_tclMsgGetRegionMethodResult;
         break;
      case intmapfi_tclToken::EN_MSG_GETDIRECTORYMETHODSTART:
         poRetType = OSAL_NEW intmapfi_tclMsgGetDirectoryMethodStart;
         break;
      case intmapfi_tclToken::EN_MSG_GETDIRECTORYMETHODRESULT:
         poRetType = OSAL_NEW intmapfi_tclMsgGetDirectoryMethodResult;
         break;
      case intmapfi_tclToken::EN_MSG_ENGINEERINGTEXTUPREG:
         poRetType = OSAL_NEW intmapfi_tclMsgEngineeringTextUpReg;
         break;
      case intmapfi_tclToken::EN_MSG_ENGINEERINGTEXTSTATUS:
         poRetType = OSAL_NEW intmapfi_tclMsgEngineeringTextStatus;
         break;
      case intmapfi_tclToken::EN_MSG_ENGINEERINGTEXTRELUPREG:
         poRetType = OSAL_NEW intmapfi_tclMsgEngineeringTextRelUpReg;
         break;
      case intmapfi_tclToken::EN_MSG_ENGINEERINGTEXTGET:
         poRetType = OSAL_NEW intmapfi_tclMsgEngineeringTextGet;
         break;
      case intmapfi_tclToken::EN_MSG_ENGENABLEFEATUREMETHODSTART:
         poRetType = OSAL_NEW intmapfi_tclMsgEngEnableFeatureMethodStart;
         break;
      case intmapfi_tclToken::EN_MSG_ENGENABLEFEATUREMETHODRESULT:
         poRetType = OSAL_NEW intmapfi_tclMsgEngEnableFeatureMethodResult;
         break;
      case intmapfi_tclToken::EN_MSG_ENGCONFIGFEATUREMETHODSTART:
         poRetType = OSAL_NEW intmapfi_tclMsgEngConfigFeatureMethodStart;
         break;
      case intmapfi_tclToken::EN_MSG_ENGCONFIGFEATUREMETHODRESULT:
         poRetType = OSAL_NEW intmapfi_tclMsgEngConfigFeatureMethodResult;
         break;
      case intmapfi_tclToken::EN_MSG_DRAWMAPMETHODSTART:
         poRetType = OSAL_NEW intmapfi_tclMsgDrawMapMethodStart;
         break;
      case intmapfi_tclToken::EN_MSG_DRAWMAPMETHODRESULT:
         poRetType = OSAL_NEW intmapfi_tclMsgDrawMapMethodResult;
         break;
      case intmapfi_tclToken::EN_MSG_DIRECTORYSTATUS:
         poRetType = OSAL_NEW intmapfi_tclMsgDirectoryStatus;
         break;
      case intmapfi_tclToken::EN_MSG_DIRECTORYGET:
         poRetType = OSAL_NEW intmapfi_tclMsgDirectoryGet;
         break;
      case intmapfi_tclToken::EN_MSG_DATAUPDATESTATUS:
         poRetType = OSAL_NEW intmapfi_tclMsgDataUpdateStatus;
         break;
      case intmapfi_tclToken::EN_MSG_DATAUPDATEGET:
         poRetType = OSAL_NEW intmapfi_tclMsgDataUpdateGet;
         break;
      default: 
         poRetType = OSAL_NULL;
      }
      break;
   case MAPCTRLFI_C_U16_SERVICE_ID:
      switch ((u16FunctionId << 16) + (u8Opcode << 8))
      {
      case mapctrlfi_tclToken::EN_MSG_USEDDATASETUPREG:
         poRetType = OSAL_NEW mapctrlfi_tclMsgUsedDatasetUpReg;
         break;
      case mapctrlfi_tclToken::EN_MSG_USEDDATASETSTATUS:
         poRetType = OSAL_NEW mapctrlfi_tclMsgUsedDatasetStatus;
         break;
      case mapctrlfi_tclToken::EN_MSG_USEDDATASETRELUPREG:
         poRetType = OSAL_NEW mapctrlfi_tclMsgUsedDatasetRelUpReg;
         break;
      case mapctrlfi_tclToken::EN_MSG_USEDDATASETGET:
         poRetType = OSAL_NEW mapctrlfi_tclMsgUsedDatasetGet;
         break;
      case mapctrlfi_tclToken::EN_MSG_UPDATEMAPSIZEMETHODSTART:
         poRetType = OSAL_NEW mapctrlfi_tclMsgUpdateMapSizeMethodStart;
         break;
      case mapctrlfi_tclToken::EN_MSG_UPDATEMAPSIZEMETHODRESULT:
         poRetType = OSAL_NEW mapctrlfi_tclMsgUpdateMapSizeMethodResult;
         break;
      case mapctrlfi_tclToken::EN_MSG_SETMAPLANGUAGEMETHODSTART:
         poRetType = OSAL_NEW mapctrlfi_tclMsgSetMapLanguageMethodStart;
         break;
      case mapctrlfi_tclToken::EN_MSG_SETMAPLANGUAGEMETHODRESULT:
         poRetType = OSAL_NEW mapctrlfi_tclMsgSetMapLanguageMethodResult;
         break;
      case mapctrlfi_tclToken::EN_MSG_SETDESTINATIONFLAGMETHODSTART:
         poRetType = OSAL_NEW mapctrlfi_tclMsgSetDestinationFlagMethodStart;
         break;
      case mapctrlfi_tclToken::EN_MSG_SETDESTINATIONFLAGMETHODRESULT:
         poRetType = OSAL_NEW mapctrlfi_tclMsgSetDestinationFlagMethodResult;
         break;
      case mapctrlfi_tclToken::EN_MSG_SETCURSORMETHODSTART:
         poRetType = OSAL_NEW mapctrlfi_tclMsgSetCursorMethodStart;
         break;
      case mapctrlfi_tclToken::EN_MSG_SETCURSORMETHODRESULT:
         poRetType = OSAL_NEW mapctrlfi_tclMsgSetCursorMethodResult;
         break;
      case mapctrlfi_tclToken::EN_MSG_SELECTVISIBLEROUTESMETHODSTART:
         poRetType = OSAL_NEW mapctrlfi_tclMsgSelectVisibleRoutesMethodStart;
         break;
      case mapctrlfi_tclToken::EN_MSG_SELECTVISIBLEROUTESMETHODRESULT:
         poRetType = OSAL_NEW mapctrlfi_tclMsgSelectVisibleRoutesMethodResult;
         break;
      case mapctrlfi_tclToken::EN_MSG_SCALEBARSIZESMETHODSTART:
         poRetType = OSAL_NEW mapctrlfi_tclMsgScalebarSizesMethodStart;
         break;
      case mapctrlfi_tclToken::EN_MSG_SCALEBARSIZESMETHODRESULT:
         poRetType = OSAL_NEW mapctrlfi_tclMsgScalebarSizesMethodResult;
         break;
      case mapctrlfi_tclToken::EN_MSG_MAPDRAWINTERSECTIONZOOMMETHODSTART:
         poRetType = OSAL_NEW mapctrlfi_tclMsgMapDrawIntersectionZoomMethodStart;
         break;
      case mapctrlfi_tclToken::EN_MSG_MAPDRAWINTERSECTIONZOOMMETHODRESULT:
         poRetType = OSAL_NEW mapctrlfi_tclMsgMapDrawIntersectionZoomMethodResult;
         break;
      case mapctrlfi_tclToken::EN_MSG_MAPDRAWMETHODSTART:
         poRetType = OSAL_NEW mapctrlfi_tclMsgMapDrawMethodStart;
         break;
      case mapctrlfi_tclToken::EN_MSG_MAPDRAWMETHODRESULT:
         poRetType = OSAL_NEW mapctrlfi_tclMsgMapDrawMethodResult;
         break;
      case mapctrlfi_tclToken::EN_MSG_MAPDIRECTIONSTATUS:
         poRetType = OSAL_NEW mapctrlfi_tclMsgMapDirectionStatus;
         break;
      case mapctrlfi_tclToken::EN_MSG_MAPDIRECTIONGET:
         poRetType = OSAL_NEW mapctrlfi_tclMsgMapDirectionGet;
         break;
      case mapctrlfi_tclToken::EN_MSG_LABELFILTERMETHODSTART:
         poRetType = OSAL_NEW mapctrlfi_tclMsgLabelFilterMethodStart;
         break;
      case mapctrlfi_tclToken::EN_MSG_LABELFILTERMETHODRESULT:
         poRetType = OSAL_NEW mapctrlfi_tclMsgLabelFilterMethodResult;
         break;
      case mapctrlfi_tclToken::EN_MSG_INITMAPSCREENINTERSECTIONZOOMMETHODSTART:
         poRetType = OSAL_NEW mapctrlfi_tclMsgInitMapScreenIntersectionZoomMethodStart;
         break;
      case mapctrlfi_tclToken::EN_MSG_INITMAPSCREENINTERSECTIONZOOMMETHODRESULT:
         poRetType = OSAL_NEW mapctrlfi_tclMsgInitMapScreenIntersectionZoomMethodResult;
         break;
      case mapctrlfi_tclToken::EN_MSG_INITMAPSCREENMETHODSTART:
         poRetType = OSAL_NEW mapctrlfi_tclMsgInitMapScreenMethodStart;
         break;
      case mapctrlfi_tclToken::EN_MSG_INITMAPSCREENMETHODRESULT:
         poRetType = OSAL_NEW mapctrlfi_tclMsgInitMapScreenMethodResult;
         break;
      case mapctrlfi_tclToken::EN_MSG_GETZOOMLEVELCONFIGMETHODSTART:
         poRetType = OSAL_NEW mapctrlfi_tclMsgGetZoomLevelConfigMethodStart;
         break;
      case mapctrlfi_tclToken::EN_MSG_GETZOOMLEVELCONFIGMETHODRESULT:
         poRetType = OSAL_NEW mapctrlfi_tclMsgGetZoomLevelConfigMethodResult;
         break;
      case mapctrlfi_tclToken::EN_MSG_GETSCREENINFOMETHODSTART:
         poRetType = OSAL_NEW mapctrlfi_tclMsgGetScreenInfoMethodStart;
         break;
      case mapctrlfi_tclToken::EN_MSG_GETSCREENINFOMETHODRESULT:
         poRetType = OSAL_NEW mapctrlfi_tclMsgGetScreenInfoMethodResult;
         break;
      case mapctrlfi_tclToken::EN_MSG_GETCURSORINFOMETHODSTART:
         poRetType = OSAL_NEW mapctrlfi_tclMsgGetCursorInfoMethodStart;
         break;
      case mapctrlfi_tclToken::EN_MSG_GETCURSORINFOMETHODRESULT:
         poRetType = OSAL_NEW mapctrlfi_tclMsgGetCursorInfoMethodResult;
         break;
      case mapctrlfi_tclToken::EN_MSG_ENGINEERINGTEXTUPREG:
         poRetType = OSAL_NEW mapctrlfi_tclMsgEngineeringTextUpReg;
         break;
      case mapctrlfi_tclToken::EN_MSG_ENGINEERINGTEXTSTATUS:
         poRetType = OSAL_NEW mapctrlfi_tclMsgEngineeringTextStatus;
         break;
      case mapctrlfi_tclToken::EN_MSG_ENGINEERINGTEXTRELUPREG:
         poRetType = OSAL_NEW mapctrlfi_tclMsgEngineeringTextRelUpReg;
         break;
      case mapctrlfi_tclToken::EN_MSG_ENGINEERINGTEXTGET:
         poRetType = OSAL_NEW mapctrlfi_tclMsgEngineeringTextGet;
         break;
      case mapctrlfi_tclToken::EN_MSG_CLEARUSEDTRACKMETHODSTART:
         poRetType = OSAL_NEW mapctrlfi_tclMsgClearUsedTrackMethodStart;
         break;
      case mapctrlfi_tclToken::EN_MSG_CLEARUSEDTRACKMETHODRESULT:
         poRetType = OSAL_NEW mapctrlfi_tclMsgClearUsedTrackMethodResult;
         break;
      default: 
         poRetType = OSAL_NULL;
      }
      break;
   case MOVIETIMESFI_C_U16_SERVICE_ID:
      switch ((u16FunctionId << 16) + (u8Opcode << 8))
      {
      case movietimesfi_tclToken::EN_MSG_GETMOVIETIMESMETHODSTART:
         poRetType = OSAL_NEW movietimesfi_tclMsgGetMovieTimesMethodStart;
         break;
      case movietimesfi_tclToken::EN_MSG_GETMOVIETIMESMETHODRESULT:
         poRetType = OSAL_NEW movietimesfi_tclMsgGetMovieTimesMethodResult;
         break;
      case movietimesfi_tclToken::EN_MSG_GETMOVIELISTMETHODSTART:
         poRetType = OSAL_NEW movietimesfi_tclMsgGetMovieListMethodStart;
         break;
      case movietimesfi_tclToken::EN_MSG_GETMOVIELISTMETHODRESULT:
         poRetType = OSAL_NEW movietimesfi_tclMsgGetMovieListMethodResult;
         break;
      case movietimesfi_tclToken::EN_MSG_GETLISTOFTHEATERDESCRIPTIONMETHODSTART:
         poRetType = OSAL_NEW movietimesfi_tclMsgGetListOfTheaterDescriptionMethodStart;
         break;
      case movietimesfi_tclToken::EN_MSG_GETLISTOFTHEATERDESCRIPTIONMETHODRESULT:
         poRetType = OSAL_NEW movietimesfi_tclMsgGetListOfTheaterDescriptionMethodResult;
         break;
      case movietimesfi_tclToken::EN_MSG_GETLISTOFMOVIETIMESBYPOSITIONMETHODSTART:
         poRetType = OSAL_NEW movietimesfi_tclMsgGetListOfMovieTimesByPositionMethodStart;
         break;
      case movietimesfi_tclToken::EN_MSG_GETLISTOFMOVIETIMESBYPOSITIONMETHODRESULT:
         poRetType = OSAL_NEW movietimesfi_tclMsgGetListOfMovieTimesByPositionMethodResult;
         break;
      default: 
         poRetType = OSAL_NULL;
      }
      break;
   case NAVIFI_C_U16_SERVICE_ID:
      switch ((u16FunctionId << 16) + (u8Opcode << 8))
      {
      case navifi_tclToken::EN_MSG_VERSIONINFOSTATUS:
         poRetType = OSAL_NEW navifi_tclMsgVersionInfoStatus;
         break;
      case navifi_tclToken::EN_MSG_VERSIONINFOGET:
         poRetType = OSAL_NEW navifi_tclMsgVersionInfoGet;
         break;
      case navifi_tclToken::EN_MSG_USERTRAFFICMESSAGESSTATUSSTATUS:
         poRetType = OSAL_NEW navifi_tclMsgUserTrafficMessagesStatusStatus;
         break;
      case navifi_tclToken::EN_MSG_USERTRAFFICMESSAGESSTATUSGET:
         poRetType = OSAL_NEW navifi_tclMsgUserTrafficMessagesStatusGet;
         break;
      case navifi_tclToken::EN_MSG_USEDDATASETUPREG:
         poRetType = OSAL_NEW navifi_tclMsgUsedDatasetUpReg;
         break;
      case navifi_tclToken::EN_MSG_USEDDATASETSTATUS:
         poRetType = OSAL_NEW navifi_tclMsgUsedDatasetStatus;
         break;
      case navifi_tclToken::EN_MSG_USEDDATASETRELUPREG:
         poRetType = OSAL_NEW navifi_tclMsgUsedDatasetRelUpReg;
         break;
      case navifi_tclToken::EN_MSG_USEDDATASETGET:
         poRetType = OSAL_NEW navifi_tclMsgUsedDatasetGet;
         break;
      case navifi_tclToken::EN_MSG_TRAFFICMSGMEMORYSTATISTICSUPREG:
         poRetType = OSAL_NEW navifi_tclMsgTrafficMsgMemoryStatisticsUpReg;
         break;
      case navifi_tclToken::EN_MSG_TRAFFICMSGMEMORYSTATISTICSSTATUS:
         poRetType = OSAL_NEW navifi_tclMsgTrafficMsgMemoryStatisticsStatus;
         break;
      case navifi_tclToken::EN_MSG_TRAFFICMSGMEMORYSTATISTICSRELUPREG:
         poRetType = OSAL_NEW navifi_tclMsgTrafficMsgMemoryStatisticsRelUpReg;
         break;
      case navifi_tclToken::EN_MSG_TRAFFICMESSAGESOURCEAVAILABLESTATUS:
         poRetType = OSAL_NEW navifi_tclMsgTrafficMessageSourceAvailableStatus;
         break;
      case navifi_tclToken::EN_MSG_TRAFFICMESSAGESOURCEAVAILABLEGET:
         poRetType = OSAL_NEW navifi_tclMsgTrafficMessageSourceAvailableGet;
         break;
      case navifi_tclToken::EN_MSG_GETTRAFFICMESSAGESMETHODSTART:
         poRetType = OSAL_NEW navifi_tclMsgGetTrafficMessagesMethodStart;
         break;
      case navifi_tclToken::EN_MSG_GETTRAFFICMESSAGESMETHODRESULT:
         poRetType = OSAL_NEW navifi_tclMsgGetTrafficMessagesMethodResult;
         break;
      case navifi_tclToken::EN_MSG_GETTIMEZONEINFOMETHODSTART:
         poRetType = OSAL_NEW navifi_tclMsgGetTimeZoneInfoMethodStart;
         break;
      case navifi_tclToken::EN_MSG_GETTIMEZONEINFOMETHODRESULT:
         poRetType = OSAL_NEW navifi_tclMsgGetTimeZoneInfoMethodResult;
         break;
      case navifi_tclToken::EN_MSG_GETGLOBALANNOTATIONTABLESMETHODSTART:
         poRetType = OSAL_NEW navifi_tclMsgGetGlobalAnnotationTablesMethodStart;
         break;
      case navifi_tclToken::EN_MSG_GETGLOBALANNOTATIONTABLESMETHODRESULT:
         poRetType = OSAL_NEW navifi_tclMsgGetGlobalAnnotationTablesMethodResult;
         break;
      case navifi_tclToken::EN_MSG_GETAVAILABLEPERMISSIONSMETHODSTART:
         poRetType = OSAL_NEW navifi_tclMsgGetAvailablePermissionsMethodStart;
         break;
      case navifi_tclToken::EN_MSG_GETAVAILABLEPERMISSIONSMETHODRESULT:
         poRetType = OSAL_NEW navifi_tclMsgGetAvailablePermissionsMethodResult;
         break;
      case navifi_tclToken::EN_MSG_GETALLTRAFFICMESSAGESMETHODSTART:
         poRetType = OSAL_NEW navifi_tclMsgGetAllTrafficMessagesMethodStart;
         break;
      case navifi_tclToken::EN_MSG_GETALLTRAFFICMESSAGESMETHODRESULT:
         poRetType = OSAL_NEW navifi_tclMsgGetAllTrafficMessagesMethodResult;
         break;
      case navifi_tclToken::EN_MSG_GETALLTMCLOCATIONSMETHODSTART:
         poRetType = OSAL_NEW navifi_tclMsgGetAllTMCLocationsMethodStart;
         break;
      case navifi_tclToken::EN_MSG_GETALLTMCLOCATIONSMETHODRESULT:
         poRetType = OSAL_NEW navifi_tclMsgGetAllTMCLocationsMethodResult;
         break;
      case navifi_tclToken::EN_MSG_ENGINEERINGTEXTUPREG:
         poRetType = OSAL_NEW navifi_tclMsgEngineeringTextUpReg;
         break;
      case navifi_tclToken::EN_MSG_ENGINEERINGTEXTSTATUS:
         poRetType = OSAL_NEW navifi_tclMsgEngineeringTextStatus;
         break;
      case navifi_tclToken::EN_MSG_ENGINEERINGTEXTRELUPREG:
         poRetType = OSAL_NEW navifi_tclMsgEngineeringTextRelUpReg;
         break;
      case navifi_tclToken::EN_MSG_ENGINEERINGTEXTGET:
         poRetType = OSAL_NEW navifi_tclMsgEngineeringTextGet;
         break;
      case navifi_tclToken::EN_MSG_DELETEUSERTRAFFICMESSAGESMETHODSTART:
         poRetType = OSAL_NEW navifi_tclMsgDeleteUserTrafficMessagesMethodStart;
         break;
      case navifi_tclToken::EN_MSG_DELETEUSERTRAFFICMESSAGESMETHODRESULT:
         poRetType = OSAL_NEW navifi_tclMsgDeleteUserTrafficMessagesMethodResult;
         break;
      case navifi_tclToken::EN_MSG_CREATEUSERTRAFFICMESSAGESMETHODSTART:
         poRetType = OSAL_NEW navifi_tclMsgCreateUserTrafficMessagesMethodStart;
         break;
      case navifi_tclToken::EN_MSG_CREATEUSERTRAFFICMESSAGESMETHODRESULT:
         poRetType = OSAL_NEW navifi_tclMsgCreateUserTrafficMessagesMethodResult;
         break;
      case navifi_tclToken::EN_MSG_CHANGETRAFFICMESSAGEHANDLINGMETHODSTART:
         poRetType = OSAL_NEW navifi_tclMsgChangeTrafficMessageHandlingMethodStart;
         break;
      case navifi_tclToken::EN_MSG_CHANGETRAFFICMESSAGEHANDLINGMETHODRESULT:
         poRetType = OSAL_NEW navifi_tclMsgChangeTrafficMessageHandlingMethodResult;
         break;
      case navifi_tclToken::EN_MSG_AVAILABLEPOISOURCESUPREG:
         poRetType = OSAL_NEW navifi_tclMsgAvailablePOISourcesUpReg;
         break;
      case navifi_tclToken::EN_MSG_AVAILABLEPOISOURCESSTATUS:
         poRetType = OSAL_NEW navifi_tclMsgAvailablePOISourcesStatus;
         break;
      case navifi_tclToken::EN_MSG_AVAILABLEPOISOURCESRELUPREG:
         poRetType = OSAL_NEW navifi_tclMsgAvailablePOISourcesRelUpReg;
         break;
      case navifi_tclToken::EN_MSG_AVAILABLEPOISOURCESGET:
         poRetType = OSAL_NEW navifi_tclMsgAvailablePOISourcesGet;
         break;
      case navifi_tclToken::EN_MSG_ALLTRAFFICMESSAGESSTATUSSTATUS:
         poRetType = OSAL_NEW navifi_tclMsgAllTrafficMessagesStatusStatus;
         break;
      case navifi_tclToken::EN_MSG_ALLTRAFFICMESSAGESSTATUSGET:
         poRetType = OSAL_NEW navifi_tclMsgAllTrafficMessagesStatusGet;
         break;
      default: 
         poRetType = OSAL_NULL;
      }
      break;
   case POSFI_C_U16_SERVICE_ID:
      switch ((u16FunctionId << 16) + (u8Opcode << 8))
      {
      case posfi_tclToken::EN_MSG_WAKEUPSTATUS:
         poRetType = OSAL_NEW posfi_tclMsgWakeUpStatus;
         break;
      case posfi_tclToken::EN_MSG_USEDDATASETUPREG:
         poRetType = OSAL_NEW posfi_tclMsgUsedDatasetUpReg;
         break;
      case posfi_tclToken::EN_MSG_USEDDATASETSTATUS:
         poRetType = OSAL_NEW posfi_tclMsgUsedDatasetStatus;
         break;
      case posfi_tclToken::EN_MSG_USEDDATASETRELUPREG:
         poRetType = OSAL_NEW posfi_tclMsgUsedDatasetRelUpReg;
         break;
      case posfi_tclToken::EN_MSG_USEDDATASETGET:
         poRetType = OSAL_NEW posfi_tclMsgUsedDatasetGet;
         break;
      case posfi_tclToken::EN_MSG_UPDATEPRESENTATIONPOSITIONMETHODSTART:
         poRetType = OSAL_NEW posfi_tclMsgUpdatePresentationPositionMethodStart;
         break;
      case posfi_tclToken::EN_MSG_UPDATEPRESENTATIONPOSITIONMETHODRESULT:
         poRetType = OSAL_NEW posfi_tclMsgUpdatePresentationPositionMethodResult;
         break;
      case posfi_tclToken::EN_MSG_SWITCHPOSITIONTONEXTPOSSIBLEPOSITIONMETHODSTART:
         poRetType = OSAL_NEW posfi_tclMsgSwitchPositionToNextPossiblePositionMethodStart;
         break;
      case posfi_tclToken::EN_MSG_SWITCHPOSITIONTONEXTPOSSIBLEPOSITIONMETHODRESULT:
         poRetType = OSAL_NEW posfi_tclMsgSwitchPositionToNextPossiblePositionMethodResult;
         break;
      case posfi_tclToken::EN_MSG_SWITCHPOSITIONLISTCOUNTUPREG:
         poRetType = OSAL_NEW posfi_tclMsgSwitchPositionListCountUpReg;
         break;
      case posfi_tclToken::EN_MSG_SWITCHPOSITIONLISTCOUNTSTATUS:
         poRetType = OSAL_NEW posfi_tclMsgSwitchPositionListCountStatus;
         break;
      case posfi_tclToken::EN_MSG_SWITCHPOSITIONLISTCOUNTRELUPREG:
         poRetType = OSAL_NEW posfi_tclMsgSwitchPositionListCountRelUpReg;
         break;
      case posfi_tclToken::EN_MSG_SWITCHPOSITIONLISTCOUNTGET:
         poRetType = OSAL_NEW posfi_tclMsgSwitchPositionListCountGet;
         break;
      case posfi_tclToken::EN_MSG_SWITCHPOSITIONDEACTIVATEMETHODSTART:
         poRetType = OSAL_NEW posfi_tclMsgSwitchPositionDeactivateMethodStart;
         break;
      case posfi_tclToken::EN_MSG_SWITCHPOSITIONDEACTIVATEMETHODRESULT:
         poRetType = OSAL_NEW posfi_tclMsgSwitchPositionDeactivateMethodResult;
         break;
      case posfi_tclToken::EN_MSG_SWITCHPOSITIONACTIVATEMETHODSTART:
         poRetType = OSAL_NEW posfi_tclMsgSwitchPositionActivateMethodStart;
         break;
      case posfi_tclToken::EN_MSG_SWITCHPOSITIONACTIVATEMETHODRESULT:
         poRetType = OSAL_NEW posfi_tclMsgSwitchPositionActivateMethodResult;
         break;
      case posfi_tclToken::EN_MSG_SETUSEDPOSITIONPATHMETHODSTART:
         poRetType = OSAL_NEW posfi_tclMsgSetUsedPositionPathMethodStart;
         break;
      case posfi_tclToken::EN_MSG_SETUSEDPOSITIONPATHMETHODRESULT:
         poRetType = OSAL_NEW posfi_tclMsgSetUsedPositionPathMethodResult;
         break;
      case posfi_tclToken::EN_MSG_SETPOSITIONBYLOCATIONMETHODSTART:
         poRetType = OSAL_NEW posfi_tclMsgSetPositionByLocationMethodStart;
         break;
      case posfi_tclToken::EN_MSG_SETPOSITIONBYLOCATIONMETHODRESULT:
         poRetType = OSAL_NEW posfi_tclMsgSetPositionByLocationMethodResult;
         break;
      case posfi_tclToken::EN_MSG_SETPOSITIONBYCOORDINATESMETHODSTART:
         poRetType = OSAL_NEW posfi_tclMsgSetPositionByCoordinatesMethodStart;
         break;
      case posfi_tclToken::EN_MSG_SETPOSITIONBYCOORDINATESMETHODRESULT:
         poRetType = OSAL_NEW posfi_tclMsgSetPositionByCoordinatesMethodResult;
         break;
      case posfi_tclToken::EN_MSG_SETMATCHINGPERMISSIONMETHODSTART:
         poRetType = OSAL_NEW posfi_tclMsgSetMatchingPermissionMethodStart;
         break;
      case posfi_tclToken::EN_MSG_SETMATCHINGPERMISSIONMETHODRESULT:
         poRetType = OSAL_NEW posfi_tclMsgSetMatchingPermissionMethodResult;
         break;
      case posfi_tclToken::EN_MSG_SETDATA2DEFAULTMETHODSTART:
         poRetType = OSAL_NEW posfi_tclMsgSetData2DefaultMethodStart;
         break;
      case posfi_tclToken::EN_MSG_SETDATA2DEFAULTMETHODRESULT:
         poRetType = OSAL_NEW posfi_tclMsgSetData2DefaultMethodResult;
         break;
      case posfi_tclToken::EN_MSG_PRESENTATIONUPREG:
         poRetType = OSAL_NEW posfi_tclMsgPresentationUpReg;
         break;
      case posfi_tclToken::EN_MSG_PRESENTATIONSTATUS:
         poRetType = OSAL_NEW posfi_tclMsgPresentationStatus;
         break;
      case posfi_tclToken::EN_MSG_PRESENTATIONRELUPREG:
         poRetType = OSAL_NEW posfi_tclMsgPresentationRelUpReg;
         break;
      case posfi_tclToken::EN_MSG_PRESENTATIONGET:
         poRetType = OSAL_NEW posfi_tclMsgPresentationGet;
         break;
      case posfi_tclToken::EN_MSG_POSSIBLEENTRYPOINTSUPREG:
         poRetType = OSAL_NEW posfi_tclMsgPossibleEntryPointsUpReg;
         break;
      case posfi_tclToken::EN_MSG_POSSIBLEENTRYPOINTSSTATUS:
         poRetType = OSAL_NEW posfi_tclMsgPossibleEntryPointsStatus;
         break;
      case posfi_tclToken::EN_MSG_POSSIBLEENTRYPOINTSRELUPREG:
         poRetType = OSAL_NEW posfi_tclMsgPossibleEntryPointsRelUpReg;
         break;
      case posfi_tclToken::EN_MSG_POSSIBLEENTRYPOINTSGET:
         poRetType = OSAL_NEW posfi_tclMsgPossibleEntryPointsGet;
         break;
      case posfi_tclToken::EN_MSG_POSITIONPATHESUPREG:
         poRetType = OSAL_NEW posfi_tclMsgPositionPathesUpReg;
         break;
      case posfi_tclToken::EN_MSG_POSITIONPATHESSTATUS:
         poRetType = OSAL_NEW posfi_tclMsgPositionPathesStatus;
         break;
      case posfi_tclToken::EN_MSG_POSITIONPATHESRELUPREG:
         poRetType = OSAL_NEW posfi_tclMsgPositionPathesRelUpReg;
         break;
      case posfi_tclToken::EN_MSG_POSITIONPATHESGET:
         poRetType = OSAL_NEW posfi_tclMsgPositionPathesGet;
         break;
      case posfi_tclToken::EN_MSG_POSITIONINFOUPREG:
         poRetType = OSAL_NEW posfi_tclMsgPositionInfoUpReg;
         break;
      case posfi_tclToken::EN_MSG_POSITIONINFOSTATUS:
         poRetType = OSAL_NEW posfi_tclMsgPositionInfoStatus;
         break;
      case posfi_tclToken::EN_MSG_POSITIONINFORELUPREG:
         poRetType = OSAL_NEW posfi_tclMsgPositionInfoRelUpReg;
         break;
      case posfi_tclToken::EN_MSG_POSITIONINFOGET:
         poRetType = OSAL_NEW posfi_tclMsgPositionInfoGet;
         break;
      case posfi_tclToken::EN_MSG_POSITIONHORIZON_CALLBACKSTATUS:
         poRetType = OSAL_NEW posfi_tclMsgPositionHorizon_CallbackStatus;
         break;
      case posfi_tclToken::EN_MSG_POSITIONUPREG:
         poRetType = OSAL_NEW posfi_tclMsgPositionUpReg;
         break;
      case posfi_tclToken::EN_MSG_POSITIONSTATUS:
         poRetType = OSAL_NEW posfi_tclMsgPositionStatus;
         break;
      case posfi_tclToken::EN_MSG_POSITIONRELUPREG:
         poRetType = OSAL_NEW posfi_tclMsgPositionRelUpReg;
         break;
      case posfi_tclToken::EN_MSG_POSITIONGET:
         poRetType = OSAL_NEW posfi_tclMsgPositionGet;
         break;
      case posfi_tclToken::EN_MSG_NAVPOSITIONUPREG:
         poRetType = OSAL_NEW posfi_tclMsgNavPositionUpReg;
         break;
      case posfi_tclToken::EN_MSG_NAVPOSITIONSTATUS:
         poRetType = OSAL_NEW posfi_tclMsgNavPositionStatus;
         break;
      case posfi_tclToken::EN_MSG_NAVPOSITIONRELUPREG:
         poRetType = OSAL_NEW posfi_tclMsgNavPositionRelUpReg;
         break;
      case posfi_tclToken::EN_MSG_NAVPOSITIONGET:
         poRetType = OSAL_NEW posfi_tclMsgNavPositionGet;
         break;
      case posfi_tclToken::EN_MSG_MOSTSTRAIGHTPATHUPREG:
         poRetType = OSAL_NEW posfi_tclMsgMostStraightPathUpReg;
         break;
      case posfi_tclToken::EN_MSG_MOSTSTRAIGHTPATHSTATUS:
         poRetType = OSAL_NEW posfi_tclMsgMostStraightPathStatus;
         break;
      case posfi_tclToken::EN_MSG_MOSTSTRAIGHTPATHRELUPREG:
         poRetType = OSAL_NEW posfi_tclMsgMostStraightPathRelUpReg;
         break;
      case posfi_tclToken::EN_MSG_MOSTSTRAIGHTPATHGET:
         poRetType = OSAL_NEW posfi_tclMsgMostStraightPathGet;
         break;
      case posfi_tclToken::EN_MSG_GETPOSITIONDESCRIPTIONMETHODSTART:
         poRetType = OSAL_NEW posfi_tclMsgGetPositionDescriptionMethodStart;
         break;
      case posfi_tclToken::EN_MSG_GETPOSITIONDESCRIPTIONMETHODRESULT:
         poRetType = OSAL_NEW posfi_tclMsgGetPositionDescriptionMethodResult;
         break;
      case posfi_tclToken::EN_MSG_EXTRAPOLATEDPOSITIONSUPREG:
         poRetType = OSAL_NEW posfi_tclMsgExtrapolatedPositionsUpReg;
         break;
      case posfi_tclToken::EN_MSG_EXTRAPOLATEDPOSITIONSSTATUS:
         poRetType = OSAL_NEW posfi_tclMsgExtrapolatedPositionsStatus;
         break;
      case posfi_tclToken::EN_MSG_EXTRAPOLATEDPOSITIONSRELUPREG:
         poRetType = OSAL_NEW posfi_tclMsgExtrapolatedPositionsRelUpReg;
         break;
      case posfi_tclToken::EN_MSG_EXTRAPOLATEDPOSITIONSGET:
         poRetType = OSAL_NEW posfi_tclMsgExtrapolatedPositionsGet;
         break;
      case posfi_tclToken::EN_MSG_EXTENDEDPOSITIONHORIZONUPREG:
         poRetType = OSAL_NEW posfi_tclMsgExtendedPositionHorizonUpReg;
         break;
      case posfi_tclToken::EN_MSG_EXTENDEDPOSITIONHORIZONSTATUS:
         poRetType = OSAL_NEW posfi_tclMsgExtendedPositionHorizonStatus;
         break;
      case posfi_tclToken::EN_MSG_EXTENDEDPOSITIONHORIZONRELUPREG:
         poRetType = OSAL_NEW posfi_tclMsgExtendedPositionHorizonRelUpReg;
         break;
      case posfi_tclToken::EN_MSG_EXTENDEDPOSITIONUPREG:
         poRetType = OSAL_NEW posfi_tclMsgExtendedPositionUpReg;
         break;
      case posfi_tclToken::EN_MSG_EXTENDEDPOSITIONSTATUS:
         poRetType = OSAL_NEW posfi_tclMsgExtendedPositionStatus;
         break;
      case posfi_tclToken::EN_MSG_EXTENDEDPOSITIONRELUPREG:
         poRetType = OSAL_NEW posfi_tclMsgExtendedPositionRelUpReg;
         break;
      case posfi_tclToken::EN_MSG_ENGINEERINGTEXTUPREG:
         poRetType = OSAL_NEW posfi_tclMsgEngineeringTextUpReg;
         break;
      case posfi_tclToken::EN_MSG_ENGINEERINGTEXTSTATUS:
         poRetType = OSAL_NEW posfi_tclMsgEngineeringTextStatus;
         break;
      case posfi_tclToken::EN_MSG_ENGINEERINGTEXTRELUPREG:
         poRetType = OSAL_NEW posfi_tclMsgEngineeringTextRelUpReg;
         break;
      case posfi_tclToken::EN_MSG_ENGINEERINGTEXTGET:
         poRetType = OSAL_NEW posfi_tclMsgEngineeringTextGet;
         break;
      case posfi_tclToken::EN_MSG_DEADRECKONINGPOSITIONUPREG:
         poRetType = OSAL_NEW posfi_tclMsgDeadReckoningPositionUpReg;
         break;
      case posfi_tclToken::EN_MSG_DEADRECKONINGPOSITIONSTATUS:
         poRetType = OSAL_NEW posfi_tclMsgDeadReckoningPositionStatus;
         break;
      case posfi_tclToken::EN_MSG_DEADRECKONINGPOSITIONRELUPREG:
         poRetType = OSAL_NEW posfi_tclMsgDeadReckoningPositionRelUpReg;
         break;
      case posfi_tclToken::EN_MSG_DEADRECKONINGPOSITIONGET:
         poRetType = OSAL_NEW posfi_tclMsgDeadReckoningPositionGet;
         break;
      case posfi_tclToken::EN_MSG_DEACTIVATEPRESENTATIONMETHODSTART:
         poRetType = OSAL_NEW posfi_tclMsgDeactivatePresentationMethodStart;
         break;
      case posfi_tclToken::EN_MSG_DEACTIVATEPRESENTATIONMETHODRESULT:
         poRetType = OSAL_NEW posfi_tclMsgDeactivatePresentationMethodResult;
         break;
      case posfi_tclToken::EN_MSG_COUNTRYCODEUPREG:
         poRetType = OSAL_NEW posfi_tclMsgCountryCodeUpReg;
         break;
      case posfi_tclToken::EN_MSG_COUNTRYCODESTATUS:
         poRetType = OSAL_NEW posfi_tclMsgCountryCodeStatus;
         break;
      case posfi_tclToken::EN_MSG_COUNTRYCODERELUPREG:
         poRetType = OSAL_NEW posfi_tclMsgCountryCodeRelUpReg;
         break;
      case posfi_tclToken::EN_MSG_COUNTRYCODEGET:
         poRetType = OSAL_NEW posfi_tclMsgCountryCodeGet;
         break;
      case posfi_tclToken::EN_MSG_CONTROLAUTOMODOMETERCALIBRATIONMETHODSTART:
         poRetType = OSAL_NEW posfi_tclMsgControlAutomOdometerCalibrationMethodStart;
         break;
      case posfi_tclToken::EN_MSG_CONTROLAUTOMODOMETERCALIBRATIONMETHODRESULT:
         poRetType = OSAL_NEW posfi_tclMsgControlAutomOdometerCalibrationMethodResult;
         break;
      case posfi_tclToken::EN_MSG_CANCELPRESENTATIONUPDATEMETHODSTART:
         poRetType = OSAL_NEW posfi_tclMsgCancelPresentationUpdateMethodStart;
         break;
      case posfi_tclToken::EN_MSG_CANCELPRESENTATIONUPDATEMETHODRESULT:
         poRetType = OSAL_NEW posfi_tclMsgCancelPresentationUpdateMethodResult;
         break;
      case posfi_tclToken::EN_MSG_AUTOMODOMETERCALIBRATIONUPREG:
         poRetType = OSAL_NEW posfi_tclMsgAutomOdometerCalibrationUpReg;
         break;
      case posfi_tclToken::EN_MSG_AUTOMODOMETERCALIBRATIONSTATUS:
         poRetType = OSAL_NEW posfi_tclMsgAutomOdometerCalibrationStatus;
         break;
      case posfi_tclToken::EN_MSG_AUTOMODOMETERCALIBRATIONRELUPREG:
         poRetType = OSAL_NEW posfi_tclMsgAutomOdometerCalibrationRelUpReg;
         break;
      case posfi_tclToken::EN_MSG_AUTOMODOMETERCALIBRATIONGET:
         poRetType = OSAL_NEW posfi_tclMsgAutomOdometerCalibrationGet;
         break;
      case posfi_tclToken::EN_MSG_ACTIVATEPRESENTATIONMETHODSTART:
         poRetType = OSAL_NEW posfi_tclMsgActivatePresentationMethodStart;
         break;
      case posfi_tclToken::EN_MSG_ACTIVATEPRESENTATIONMETHODRESULT:
         poRetType = OSAL_NEW posfi_tclMsgActivatePresentationMethodResult;
         break;
      default: 
         poRetType = OSAL_NULL;
      }
      break;
   case RCFI_C_U16_SERVICE_ID:
      switch ((u16FunctionId << 16) + (u8Opcode << 8))
      {
      case rcfi_tclToken::EN_MSG_VERIFYNEWTRAFFICMESSAGESMETHODSTART:
         poRetType = OSAL_NEW rcfi_tclMsgVerifyNewTrafficMessagesMethodStart;
         break;
      case rcfi_tclToken::EN_MSG_VERIFYNEWTRAFFICMESSAGESMETHODRESULT:
         poRetType = OSAL_NEW rcfi_tclMsgVerifyNewTrafficMessagesMethodResult;
         break;
      case rcfi_tclToken::EN_MSG_USEDDATASETUPREG:
         poRetType = OSAL_NEW rcfi_tclMsgUsedDatasetUpReg;
         break;
      case rcfi_tclToken::EN_MSG_USEDDATASETSTATUS:
         poRetType = OSAL_NEW rcfi_tclMsgUsedDatasetStatus;
         break;
      case rcfi_tclToken::EN_MSG_USEDDATASETRELUPREG:
         poRetType = OSAL_NEW rcfi_tclMsgUsedDatasetRelUpReg;
         break;
      case rcfi_tclToken::EN_MSG_USEDDATASETGET:
         poRetType = OSAL_NEW rcfi_tclMsgUsedDatasetGet;
         break;
      case rcfi_tclToken::EN_MSG_UPDATEROUTEINFOMETHODSTART:
         poRetType = OSAL_NEW rcfi_tclMsgUpdateRouteInfoMethodStart;
         break;
      case rcfi_tclToken::EN_MSG_UPDATEROUTEINFOMETHODRESULT:
         poRetType = OSAL_NEW rcfi_tclMsgUpdateRouteInfoMethodResult;
         break;
      case rcfi_tclToken::EN_MSG_UPDATEPOSITIONMETHODSTART:
         poRetType = OSAL_NEW rcfi_tclMsgUpdatePositionMethodStart;
         break;
      case rcfi_tclToken::EN_MSG_UPDATEPOSITIONMETHODRESULT:
         poRetType = OSAL_NEW rcfi_tclMsgUpdatePositionMethodResult;
         break;
      case rcfi_tclToken::EN_MSG_TRIPSTATUSSTATUS:
         poRetType = OSAL_NEW rcfi_tclMsgTripStatusStatus;
         break;
      case rcfi_tclToken::EN_MSG_TRIPSTATUSGET:
         poRetType = OSAL_NEW rcfi_tclMsgTripStatusGet;
         break;
      case rcfi_tclToken::EN_MSG_TRAVELVALUESCHANGEUPREG:
         poRetType = OSAL_NEW rcfi_tclMsgTravelValuesChangeUpReg;
         break;
      case rcfi_tclToken::EN_MSG_TRAVELVALUESCHANGESTATUS:
         poRetType = OSAL_NEW rcfi_tclMsgTravelValuesChangeStatus;
         break;
      case rcfi_tclToken::EN_MSG_SWITCHMISSIONMETHODSTART:
         poRetType = OSAL_NEW rcfi_tclMsgSwitchMissionMethodStart;
         break;
      case rcfi_tclToken::EN_MSG_SWITCHMISSIONMETHODRESULT:
         poRetType = OSAL_NEW rcfi_tclMsgSwitchMissionMethodResult;
         break;
      case rcfi_tclToken::EN_MSG_STOPROUTECALCULATIONMETHODSTART:
         poRetType = OSAL_NEW rcfi_tclMsgStopRouteCalculationMethodStart;
         break;
      case rcfi_tclToken::EN_MSG_STOPROUTECALCULATIONMETHODRESULT:
         poRetType = OSAL_NEW rcfi_tclMsgStopRouteCalculationMethodResult;
         break;
      case rcfi_tclToken::EN_MSG_STOPLOADINGMETHODSTART:
         poRetType = OSAL_NEW rcfi_tclMsgStopLoadingMethodStart;
         break;
      case rcfi_tclToken::EN_MSG_STOPLOADINGMETHODRESULT:
         poRetType = OSAL_NEW rcfi_tclMsgStopLoadingMethodResult;
         break;
      case rcfi_tclToken::EN_MSG_STARTROUTECALCULATIONMETHODSTART:
         poRetType = OSAL_NEW rcfi_tclMsgStartRouteCalculationMethodStart;
         break;
      case rcfi_tclToken::EN_MSG_STARTROUTECALCULATIONMETHODRESULT:
         poRetType = OSAL_NEW rcfi_tclMsgStartRouteCalculationMethodResult;
         break;
      case rcfi_tclToken::EN_MSG_STARTLOADINGMETHODSTART:
         poRetType = OSAL_NEW rcfi_tclMsgStartLoadingMethodStart;
         break;
      case rcfi_tclToken::EN_MSG_STARTLOADINGMETHODRESULT:
         poRetType = OSAL_NEW rcfi_tclMsgStartLoadingMethodResult;
         break;
      case rcfi_tclToken::EN_MSG_SETTRAVELADVANTAGETHRESHOLDSMETHODSTART:
         poRetType = OSAL_NEW rcfi_tclMsgSetTravelAdvantageThresholdsMethodStart;
         break;
      case rcfi_tclToken::EN_MSG_SETTRAVELADVANTAGETHRESHOLDSMETHODRESULT:
         poRetType = OSAL_NEW rcfi_tclMsgSetTravelAdvantageThresholdsMethodResult;
         break;
      case rcfi_tclToken::EN_MSG_SETTRAFFICMESSAGESANDUPDATEROUTEMETHODSTART:
         poRetType = OSAL_NEW rcfi_tclMsgSetTrafficMessagesAndUpdateRouteMethodStart;
         break;
      case rcfi_tclToken::EN_MSG_SETTRAFFICMESSAGESANDUPDATEROUTEMETHODRESULT:
         poRetType = OSAL_NEW rcfi_tclMsgSetTrafficMessagesAndUpdateRouteMethodResult;
         break;
      case rcfi_tclToken::EN_MSG_SETTRACKEDSEGMENTMETHODSTART:
         poRetType = OSAL_NEW rcfi_tclMsgSetTrackedSegmentMethodStart;
         break;
      case rcfi_tclToken::EN_MSG_SETTRACKEDSEGMENTMETHODRESULT:
         poRetType = OSAL_NEW rcfi_tclMsgSetTrackedSegmentMethodResult;
         break;
      case rcfi_tclToken::EN_MSG_SETTHRESHOLDDEFINITIONPROFILEMETHODSTART:
         poRetType = OSAL_NEW rcfi_tclMsgSetThresholdDefinitionProfileMethodStart;
         break;
      case rcfi_tclToken::EN_MSG_SETTHRESHOLDDEFINITIONPROFILEMETHODRESULT:
         poRetType = OSAL_NEW rcfi_tclMsgSetThresholdDefinitionProfileMethodResult;
         break;
      case rcfi_tclToken::EN_MSG_SETPOSITIONANDUPDATEROUTEMETHODSTART:
         poRetType = OSAL_NEW rcfi_tclMsgSetPositionAndUpdateRouteMethodStart;
         break;
      case rcfi_tclToken::EN_MSG_SETPOSITIONANDUPDATEROUTEMETHODRESULT:
         poRetType = OSAL_NEW rcfi_tclMsgSetPositionAndUpdateRouteMethodResult;
         break;
      case rcfi_tclToken::EN_MSG_SETENTRYPOINTSANDUPDATEROUTEMETHODSTART:
         poRetType = OSAL_NEW rcfi_tclMsgSetEntryPointsAndUpdateRouteMethodStart;
         break;
      case rcfi_tclToken::EN_MSG_SETENTRYPOINTSANDUPDATEROUTEMETHODRESULT:
         poRetType = OSAL_NEW rcfi_tclMsgSetEntryPointsAndUpdateRouteMethodResult;
         break;
      case rcfi_tclToken::EN_MSG_SETCRITERIONANDUPDATEROUTEMETHODSTART:
         poRetType = OSAL_NEW rcfi_tclMsgSetCriterionAndUpdateRouteMethodStart;
         break;
      case rcfi_tclToken::EN_MSG_SETCRITERIONANDUPDATEROUTEMETHODRESULT:
         poRetType = OSAL_NEW rcfi_tclMsgSetCriterionAndUpdateRouteMethodResult;
         break;
      case rcfi_tclToken::EN_MSG_SETCALCULATIONMODEMETHODSTART:
         poRetType = OSAL_NEW rcfi_tclMsgSetCalculationModeMethodStart;
         break;
      case rcfi_tclToken::EN_MSG_SETCALCULATIONMODEMETHODRESULT:
         poRetType = OSAL_NEW rcfi_tclMsgSetCalculationModeMethodResult;
         break;
      case rcfi_tclToken::EN_MSG_SETCALCULATIONJOBANDACTIVATEROUTEMETHODSTART:
         poRetType = OSAL_NEW rcfi_tclMsgSetCalculationJobAndActivateRouteMethodStart;
         break;
      case rcfi_tclToken::EN_MSG_SETCALCULATIONJOBANDACTIVATEROUTEMETHODRESULT:
         poRetType = OSAL_NEW rcfi_tclMsgSetCalculationJobAndActivateRouteMethodResult;
         break;
      case rcfi_tclToken::EN_MSG_SELECTTRAFFICSCENARIOMETHODSTART:
         poRetType = OSAL_NEW rcfi_tclMsgSelectTrafficScenarioMethodStart;
         break;
      case rcfi_tclToken::EN_MSG_SELECTTRAFFICSCENARIOMETHODRESULT:
         poRetType = OSAL_NEW rcfi_tclMsgSelectTrafficScenarioMethodResult;
         break;
      case rcfi_tclToken::EN_MSG_ROUTESTATUSSTATUS:
         poRetType = OSAL_NEW rcfi_tclMsgRouteStatusStatus;
         break;
      case rcfi_tclToken::EN_MSG_ROUTESTATUSGET:
         poRetType = OSAL_NEW rcfi_tclMsgRouteStatusGet;
         break;
      case rcfi_tclToken::EN_MSG_ROUTEINFOSTATUSSTATUS:
         poRetType = OSAL_NEW rcfi_tclMsgRouteInfoStatusStatus;
         break;
      case rcfi_tclToken::EN_MSG_ROUTEINFOSTATUSGET:
         poRetType = OSAL_NEW rcfi_tclMsgRouteInfoStatusGet;
         break;
      case rcfi_tclToken::EN_MSG_ROUTECALCULATIONSTATUSSTATUS:
         poRetType = OSAL_NEW rcfi_tclMsgRouteCalculationStatusStatus;
         break;
      case rcfi_tclToken::EN_MSG_ROUTECALCULATIONSTATUSGET:
         poRetType = OSAL_NEW rcfi_tclMsgRouteCalculationStatusGet;
         break;
      case rcfi_tclToken::EN_MSG_RDBLOADERSTATUSSTATUS:
         poRetType = OSAL_NEW rcfi_tclMsgRDBLoaderStatusStatus;
         break;
      case rcfi_tclToken::EN_MSG_RDBLOADERSTATUSGET:
         poRetType = OSAL_NEW rcfi_tclMsgRDBLoaderStatusGet;
         break;
      case rcfi_tclToken::EN_MSG_RDBACCESSIBILITYSTATUS:
         poRetType = OSAL_NEW rcfi_tclMsgRDBAccessibilityStatus;
         break;
      case rcfi_tclToken::EN_MSG_RDBACCESSIBILITYGET:
         poRetType = OSAL_NEW rcfi_tclMsgRDBAccessibilityGet;
         break;
      case rcfi_tclToken::EN_MSG_KILLTRIPMETHODSTART:
         poRetType = OSAL_NEW rcfi_tclMsgKillTripMethodStart;
         break;
      case rcfi_tclToken::EN_MSG_KILLTRIPMETHODRESULT:
         poRetType = OSAL_NEW rcfi_tclMsgKillTripMethodResult;
         break;
      case rcfi_tclToken::EN_MSG_GETTRIPMETHODSTART:
         poRetType = OSAL_NEW rcfi_tclMsgGetTripMethodStart;
         break;
      case rcfi_tclToken::EN_MSG_GETTRIPMETHODRESULT:
         poRetType = OSAL_NEW rcfi_tclMsgGetTripMethodResult;
         break;
      case rcfi_tclToken::EN_MSG_GETSTANDARDSPEEDHISTOGRAMMETHODSTART:
         poRetType = OSAL_NEW rcfi_tclMsgGetStandardSpeedHistogramMethodStart;
         break;
      case rcfi_tclToken::EN_MSG_GETSTANDARDSPEEDHISTOGRAMMETHODRESULT:
         poRetType = OSAL_NEW rcfi_tclMsgGetStandardSpeedHistogramMethodResult;
         break;
      case rcfi_tclToken::EN_MSG_GETROUTEINFOMETHODSTART:
         poRetType = OSAL_NEW rcfi_tclMsgGetRouteInfoMethodStart;
         break;
      case rcfi_tclToken::EN_MSG_GETROUTEINFOMETHODRESULT:
         poRetType = OSAL_NEW rcfi_tclMsgGetRouteInfoMethodResult;
         break;
      case rcfi_tclToken::EN_MSG_GETROUTECAPABILITIESMETHODSTART:
         poRetType = OSAL_NEW rcfi_tclMsgGetRouteCapabilitiesMethodStart;
         break;
      case rcfi_tclToken::EN_MSG_GETROUTECAPABILITIESMETHODRESULT:
         poRetType = OSAL_NEW rcfi_tclMsgGetRouteCapabilitiesMethodResult;
         break;
      case rcfi_tclToken::EN_MSG_GETROUTECALCOPTIONSMETHODSTART:
         poRetType = OSAL_NEW rcfi_tclMsgGetRouteCalcOptionsMethodStart;
         break;
      case rcfi_tclToken::EN_MSG_GETROUTECALCOPTIONSMETHODRESULT:
         poRetType = OSAL_NEW rcfi_tclMsgGetRouteCalcOptionsMethodResult;
         break;
      case rcfi_tclToken::EN_MSG_GETNAVROUTELISTDEPICTIONMETHODSTART:
         poRetType = OSAL_NEW rcfi_tclMsgGetNavRouteListDepictionMethodStart;
         break;
      case rcfi_tclToken::EN_MSG_GETNAVROUTELISTDEPICTIONMETHODRESULT:
         poRetType = OSAL_NEW rcfi_tclMsgGetNavRouteListDepictionMethodResult;
         break;
      case rcfi_tclToken::EN_MSG_GETGLUEAREADESCRIPTIONMETHODSTART:
         poRetType = OSAL_NEW rcfi_tclMsgGetGlueAreaDescriptionMethodStart;
         break;
      case rcfi_tclToken::EN_MSG_GETGLUEAREADESCRIPTIONMETHODRESULT:
         poRetType = OSAL_NEW rcfi_tclMsgGetGlueAreaDescriptionMethodResult;
         break;
      case rcfi_tclToken::EN_MSG_GETEXISTINGTRIPHANDLESMETHODSTART:
         poRetType = OSAL_NEW rcfi_tclMsgGetExistingTripHandlesMethodStart;
         break;
      case rcfi_tclToken::EN_MSG_GETEXISTINGTRIPHANDLESMETHODRESULT:
         poRetType = OSAL_NEW rcfi_tclMsgGetExistingTripHandlesMethodResult;
         break;
      case rcfi_tclToken::EN_MSG_GETDEFAULTVEHICLEPARAMETERMETHODSTART:
         poRetType = OSAL_NEW rcfi_tclMsgGetDefaultVehicleParameterMethodStart;
         break;
      case rcfi_tclToken::EN_MSG_GETDEFAULTVEHICLEPARAMETERMETHODRESULT:
         poRetType = OSAL_NEW rcfi_tclMsgGetDefaultVehicleParameterMethodResult;
         break;
      case rcfi_tclToken::EN_MSG_GETCLUSTERLISTSMETHODSTART:
         poRetType = OSAL_NEW rcfi_tclMsgGetClusterListsMethodStart;
         break;
      case rcfi_tclToken::EN_MSG_GETCLUSTERLISTSMETHODRESULT:
         poRetType = OSAL_NEW rcfi_tclMsgGetClusterListsMethodResult;
         break;
      case rcfi_tclToken::EN_MSG_GETCALCULATIONMODEMETHODSTART:
         poRetType = OSAL_NEW rcfi_tclMsgGetCalculationModeMethodStart;
         break;
      case rcfi_tclToken::EN_MSG_GETCALCULATIONMODEMETHODRESULT:
         poRetType = OSAL_NEW rcfi_tclMsgGetCalculationModeMethodResult;
         break;
      case rcfi_tclToken::EN_MSG_GETAVAILABLEROUTEINFOMETHODSTART:
         poRetType = OSAL_NEW rcfi_tclMsgGetAvailableRouteInfoMethodStart;
         break;
      case rcfi_tclToken::EN_MSG_GETAVAILABLEROUTEINFOMETHODRESULT:
         poRetType = OSAL_NEW rcfi_tclMsgGetAvailableRouteInfoMethodResult;
         break;
      case rcfi_tclToken::EN_MSG_EVALUATEPOSITIONSMETHODSTART:
         poRetType = OSAL_NEW rcfi_tclMsgEvaluatePositionsMethodStart;
         break;
      case rcfi_tclToken::EN_MSG_EVALUATEPOSITIONSMETHODRESULT:
         poRetType = OSAL_NEW rcfi_tclMsgEvaluatePositionsMethodResult;
         break;
      case rcfi_tclToken::EN_MSG_ENGINEERINGTEXTUPREG:
         poRetType = OSAL_NEW rcfi_tclMsgEngineeringTextUpReg;
         break;
      case rcfi_tclToken::EN_MSG_ENGINEERINGTEXTSTATUS:
         poRetType = OSAL_NEW rcfi_tclMsgEngineeringTextStatus;
         break;
      case rcfi_tclToken::EN_MSG_ENGINEERINGTEXTRELUPREG:
         poRetType = OSAL_NEW rcfi_tclMsgEngineeringTextRelUpReg;
         break;
      case rcfi_tclToken::EN_MSG_ENGINEERINGTEXTGET:
         poRetType = OSAL_NEW rcfi_tclMsgEngineeringTextGet;
         break;
      case rcfi_tclToken::EN_MSG_DISTANCETIMEINFOSTATUS:
         poRetType = OSAL_NEW rcfi_tclMsgDistanceTimeInfoStatus;
         break;
      case rcfi_tclToken::EN_MSG_DISTANCETIMEINFOGET:
         poRetType = OSAL_NEW rcfi_tclMsgDistanceTimeInfoGet;
         break;
      case rcfi_tclToken::EN_MSG_DEPICTNAVDATALISTMETHODSTART:
         poRetType = OSAL_NEW rcfi_tclMsgDepictNavDataListMethodStart;
         break;
      case rcfi_tclToken::EN_MSG_DEPICTNAVDATALISTMETHODRESULT:
         poRetType = OSAL_NEW rcfi_tclMsgDepictNavDataListMethodResult;
         break;
      case rcfi_tclToken::EN_MSG_DEACTIVATEROUTECALCULATIONMETHODSTART:
         poRetType = OSAL_NEW rcfi_tclMsgDeactivateRouteCalculationMethodStart;
         break;
      case rcfi_tclToken::EN_MSG_DEACTIVATEROUTECALCULATIONMETHODRESULT:
         poRetType = OSAL_NEW rcfi_tclMsgDeactivateRouteCalculationMethodResult;
         break;
      case rcfi_tclToken::EN_MSG_CREATETRIPMETHODSTART:
         poRetType = OSAL_NEW rcfi_tclMsgCreateTripMethodStart;
         break;
      case rcfi_tclToken::EN_MSG_CREATETRIPMETHODRESULT:
         poRetType = OSAL_NEW rcfi_tclMsgCreateTripMethodResult;
         break;
      case rcfi_tclToken::EN_MSG_COPYCALCULATIONJOBMETHODSTART:
         poRetType = OSAL_NEW rcfi_tclMsgCopyCalculationJobMethodStart;
         break;
      case rcfi_tclToken::EN_MSG_COPYCALCULATIONJOBMETHODRESULT:
         poRetType = OSAL_NEW rcfi_tclMsgCopyCalculationJobMethodResult;
         break;
      case rcfi_tclToken::EN_MSG_CHECKPROFILEVALIDITYMETHODSTART:
         poRetType = OSAL_NEW rcfi_tclMsgCheckProfileValidityMethodStart;
         break;
      case rcfi_tclToken::EN_MSG_CHECKPROFILEVALIDITYMETHODRESULT:
         poRetType = OSAL_NEW rcfi_tclMsgCheckProfileValidityMethodResult;
         break;
      case rcfi_tclToken::EN_MSG_CHANGEDYNAMICROUTECALCMODEMETHODSTART:
         poRetType = OSAL_NEW rcfi_tclMsgChangeDynamicRouteCalcModeMethodStart;
         break;
      case rcfi_tclToken::EN_MSG_CHANGEDYNAMICROUTECALCMODEMETHODRESULT:
         poRetType = OSAL_NEW rcfi_tclMsgChangeDynamicRouteCalcModeMethodResult;
         break;
      case rcfi_tclToken::EN_MSG_ADDTRIPSEGMENTTOTRIPMETHODSTART:
         poRetType = OSAL_NEW rcfi_tclMsgAddTripSegmentToTripMethodStart;
         break;
      case rcfi_tclToken::EN_MSG_ADDTRIPSEGMENTTOTRIPMETHODRESULT:
         poRetType = OSAL_NEW rcfi_tclMsgAddTripSegmentToTripMethodResult;
         break;
      case rcfi_tclToken::EN_MSG_ACTIVATEROUTECALCULATIONMETHODSTART:
         poRetType = OSAL_NEW rcfi_tclMsgActivateRouteCalculationMethodStart;
         break;
      case rcfi_tclToken::EN_MSG_ACTIVATEROUTECALCULATIONMETHODRESULT:
         poRetType = OSAL_NEW rcfi_tclMsgActivateRouteCalculationMethodResult;
         break;
      default: 
         poRetType = OSAL_NULL;
      }
      break;
   case REGIONKNITTERFI_C_U16_SERVICE_ID:
      switch ((u16FunctionId << 16) + (u8Opcode << 8))
      {
      case regionknitterfi_tclToken::EN_MSG_UNKNITREGIONSMETHODSTART:
         poRetType = OSAL_NEW regionknitterfi_tclMsgUnknitRegionsMethodStart;
         break;
      case regionknitterfi_tclToken::EN_MSG_UNKNITREGIONSMETHODRESULT:
         poRetType = OSAL_NEW regionknitterfi_tclMsgUnknitRegionsMethodResult;
         break;
      case regionknitterfi_tclToken::EN_MSG_RESUMEMETHODSTART:
         poRetType = OSAL_NEW regionknitterfi_tclMsgResumeMethodStart;
         break;
      case regionknitterfi_tclToken::EN_MSG_RESUMEMETHODRESULT:
         poRetType = OSAL_NEW regionknitterfi_tclMsgResumeMethodResult;
         break;
      case regionknitterfi_tclToken::EN_MSG_PREKNITREGIONMETHODSTART:
         poRetType = OSAL_NEW regionknitterfi_tclMsgPreKnitRegionMethodStart;
         break;
      case regionknitterfi_tclToken::EN_MSG_PREKNITREGIONMETHODRESULT:
         poRetType = OSAL_NEW regionknitterfi_tclMsgPreKnitRegionMethodResult;
         break;
      case regionknitterfi_tclToken::EN_MSG_POSTUNKNITREGIONSMETHODSTART:
         poRetType = OSAL_NEW regionknitterfi_tclMsgPostUnknitRegionsMethodStart;
         break;
      case regionknitterfi_tclToken::EN_MSG_POSTUNKNITREGIONSMETHODRESULT:
         poRetType = OSAL_NEW regionknitterfi_tclMsgPostUnknitRegionsMethodResult;
         break;
      case regionknitterfi_tclToken::EN_MSG_KNITREGIONMETHODSTART:
         poRetType = OSAL_NEW regionknitterfi_tclMsgKnitRegionMethodStart;
         break;
      case regionknitterfi_tclToken::EN_MSG_KNITREGIONMETHODRESULT:
         poRetType = OSAL_NEW regionknitterfi_tclMsgKnitRegionMethodResult;
         break;
      default: 
         poRetType = OSAL_NULL;
      }
      break;
   case RFDFI_C_U16_SERVICE_ID:
      switch ((u16FunctionId << 16) + (u8Opcode << 8))
      {
      case rfdfi_tclToken::EN_MSG_TABWEATHERDBUPDATEDUPREG:
         poRetType = OSAL_NEW rfdfi_tclMsgTabWeatherDBUpdatedUpReg;
         break;
      case rfdfi_tclToken::EN_MSG_TABWEATHERDBUPDATEDSTATUS:
         poRetType = OSAL_NEW rfdfi_tclMsgTabWeatherDBUpdatedStatus;
         break;
      case rfdfi_tclToken::EN_MSG_TABWEATHERDBUPDATEDRELUPREG:
         poRetType = OSAL_NEW rfdfi_tclMsgTabWeatherDBUpdatedRelUpReg;
         break;
      case rfdfi_tclToken::EN_MSG_TABWEATHERDBUPDATEDGET:
         poRetType = OSAL_NEW rfdfi_tclMsgTabWeatherDBUpdatedGet;
         break;
      case rfdfi_tclToken::EN_MSG_REVERTEXISTINGDATABASEMETHODSTART:
         poRetType = OSAL_NEW rfdfi_tclMsgRevertExistingDataBaseMethodStart;
         break;
      case rfdfi_tclToken::EN_MSG_REVERTEXISTINGDATABASEMETHODRESULT:
         poRetType = OSAL_NEW rfdfi_tclMsgRevertExistingDataBaseMethodResult;
         break;
      case rfdfi_tclToken::EN_MSG_RELEASEDATAACCESSMETHODSTART:
         poRetType = OSAL_NEW rfdfi_tclMsgReleaseDataAccessMethodStart;
         break;
      case rfdfi_tclToken::EN_MSG_RELEASEDATAACCESSMETHODRESULT:
         poRetType = OSAL_NEW rfdfi_tclMsgReleaseDataAccessMethodResult;
         break;
      case rfdfi_tclToken::EN_MSG_EXCHANGEDIRECTORYCONTENTUPREG:
         poRetType = OSAL_NEW rfdfi_tclMsgExchangeDirectoryContentUpReg;
         break;
      case rfdfi_tclToken::EN_MSG_EXCHANGEDIRECTORYCONTENTSTATUS:
         poRetType = OSAL_NEW rfdfi_tclMsgExchangeDirectoryContentStatus;
         break;
      case rfdfi_tclToken::EN_MSG_EXCHANGEDIRECTORYCONTENTRELUPREG:
         poRetType = OSAL_NEW rfdfi_tclMsgExchangeDirectoryContentRelUpReg;
         break;
      case rfdfi_tclToken::EN_MSG_EXCHANGEDIRECTORYCONTENTGET:
         poRetType = OSAL_NEW rfdfi_tclMsgExchangeDirectoryContentGet;
         break;
      case rfdfi_tclToken::EN_MSG_DELETETABWEATHERDBFILEMETHODSTART:
         poRetType = OSAL_NEW rfdfi_tclMsgDeleteTabWeatherDBFileMethodStart;
         break;
      case rfdfi_tclToken::EN_MSG_DELETETABWEATHERDBFILEMETHODRESULT:
         poRetType = OSAL_NEW rfdfi_tclMsgDeleteTabWeatherDBFileMethodResult;
         break;
      case rfdfi_tclToken::EN_MSG_CURRTABWEATHERDBINFOMETHODSTART:
         poRetType = OSAL_NEW rfdfi_tclMsgCurrTabWeatherDBInfoMethodStart;
         break;
      case rfdfi_tclToken::EN_MSG_CURRTABWEATHERDBINFOMETHODRESULT:
         poRetType = OSAL_NEW rfdfi_tclMsgCurrTabWeatherDBInfoMethodResult;
         break;
      case rfdfi_tclToken::EN_MSG_ACQUIREDATAACCESSMETHODSTART:
         poRetType = OSAL_NEW rfdfi_tclMsgAcquireDataAccessMethodStart;
         break;
      case rfdfi_tclToken::EN_MSG_ACQUIREDATAACCESSMETHODRESULT:
         poRetType = OSAL_NEW rfdfi_tclMsgAcquireDataAccessMethodResult;
         break;
      default: 
         poRetType = OSAL_NULL;
      }
      break;
   case RGFI_C_U16_SERVICE_ID:
      switch ((u16FunctionId << 16) + (u8Opcode << 8))
      {
      case rgfi_tclToken::EN_MSG_WARNINGSONHORIZONMODESTATUS:
         poRetType = OSAL_NEW rgfi_tclMsgWarningsOnHorizonModeStatus;
         break;
      case rgfi_tclToken::EN_MSG_WARNINGSONHORIZONMODEGET:
         poRetType = OSAL_NEW rgfi_tclMsgWarningsOnHorizonModeGet;
         break;
      case rgfi_tclToken::EN_MSG_UPOIANNOUNCEMENTCATEGORIESSTATUS:
         poRetType = OSAL_NEW rgfi_tclMsgUPOIAnnouncementCategoriesStatus;
         break;
      case rgfi_tclToken::EN_MSG_UPOIANNOUNCEMENTCATEGORIESGET:
         poRetType = OSAL_NEW rgfi_tclMsgUPOIAnnouncementCategoriesGet;
         break;
      case rgfi_tclToken::EN_MSG_TURNTOINFOSTATUS:
         poRetType = OSAL_NEW rgfi_tclMsgTurnToInfoStatus;
         break;
      case rgfi_tclToken::EN_MSG_TURNTOINFOGET:
         poRetType = OSAL_NEW rgfi_tclMsgTurnToInfoGet;
         break;
      case rgfi_tclToken::EN_MSG_TRAFFICANNOUNCEMENTCONFIGURATIONUPREG:
         poRetType = OSAL_NEW rgfi_tclMsgTrafficAnnouncementConfigurationUpReg;
         break;
      case rgfi_tclToken::EN_MSG_TRAFFICANNOUNCEMENTCONFIGURATIONSTATUS:
         poRetType = OSAL_NEW rgfi_tclMsgTrafficAnnouncementConfigurationStatus;
         break;
      case rgfi_tclToken::EN_MSG_TRAFFICANNOUNCEMENTCONFIGURATIONSET:
         poRetType = OSAL_NEW rgfi_tclMsgTrafficAnnouncementConfigurationSet;
         break;
      case rgfi_tclToken::EN_MSG_TRAFFICANNOUNCEMENTCONFIGURATIONRELUPREG:
         poRetType = OSAL_NEW rgfi_tclMsgTrafficAnnouncementConfigurationRelUpReg;
         break;
      case rgfi_tclToken::EN_MSG_TRAFFICANNOUNCEMENTCONFIGURATIONGET:
         poRetType = OSAL_NEW rgfi_tclMsgTrafficAnnouncementConfigurationGet;
         break;
      case rgfi_tclToken::EN_MSG_TM_HORIZONEVENTS_FILTERUPREG:
         poRetType = OSAL_NEW rgfi_tclMsgTM_HorizonEvents_FilterUpReg;
         break;
      case rgfi_tclToken::EN_MSG_TM_HORIZONEVENTS_FILTERSTATUS:
         poRetType = OSAL_NEW rgfi_tclMsgTM_HorizonEvents_FilterStatus;
         break;
      case rgfi_tclToken::EN_MSG_TM_HORIZONEVENTS_FILTERSET:
         poRetType = OSAL_NEW rgfi_tclMsgTM_HorizonEvents_FilterSet;
         break;
      case rgfi_tclToken::EN_MSG_TM_HORIZONEVENTS_FILTERRELUPREG:
         poRetType = OSAL_NEW rgfi_tclMsgTM_HorizonEvents_FilterRelUpReg;
         break;
      case rgfi_tclToken::EN_MSG_TM_HORIZONEVENTS_FILTERGET:
         poRetType = OSAL_NEW rgfi_tclMsgTM_HorizonEvents_FilterGet;
         break;
      case rgfi_tclToken::EN_MSG_STOPGUIDANCEMETHODSTART:
         poRetType = OSAL_NEW rgfi_tclMsgStopGuidanceMethodStart;
         break;
      case rgfi_tclToken::EN_MSG_STOPGUIDANCEMETHODRESULT:
         poRetType = OSAL_NEW rgfi_tclMsgStopGuidanceMethodResult;
         break;
      case rgfi_tclToken::EN_MSG_STARTGUIDANCEMETHODSTART:
         poRetType = OSAL_NEW rgfi_tclMsgStartGuidanceMethodStart;
         break;
      case rgfi_tclToken::EN_MSG_STARTGUIDANCEMETHODRESULT:
         poRetType = OSAL_NEW rgfi_tclMsgStartGuidanceMethodResult;
         break;
      case rgfi_tclToken::EN_MSG_SPEEDLIMITEXCEEDINGCONFIGURATIONSTATUS:
         poRetType = OSAL_NEW rgfi_tclMsgSpeedLimitExceedingConfigurationStatus;
         break;
      case rgfi_tclToken::EN_MSG_SPEEDLIMITEXCEEDINGCONFIGURATIONSET:
         poRetType = OSAL_NEW rgfi_tclMsgSpeedLimitExceedingConfigurationSet;
         break;
      case rgfi_tclToken::EN_MSG_SPEEDLIMITEXCEEDINGCONFIGURATIONGET:
         poRetType = OSAL_NEW rgfi_tclMsgSpeedLimitExceedingConfigurationGet;
         break;
      case rgfi_tclToken::EN_MSG_SPEEDADVICECONFIGURATIONUPREG:
         poRetType = OSAL_NEW rgfi_tclMsgSpeedAdviceConfigurationUpReg;
         break;
      case rgfi_tclToken::EN_MSG_SPEEDADVICECONFIGURATIONSTATUS:
         poRetType = OSAL_NEW rgfi_tclMsgSpeedAdviceConfigurationStatus;
         break;
      case rgfi_tclToken::EN_MSG_SPEEDADVICECONFIGURATIONSET:
         poRetType = OSAL_NEW rgfi_tclMsgSpeedAdviceConfigurationSet;
         break;
      case rgfi_tclToken::EN_MSG_SPEEDADVICECONFIGURATIONRELUPREG:
         poRetType = OSAL_NEW rgfi_tclMsgSpeedAdviceConfigurationRelUpReg;
         break;
      case rgfi_tclToken::EN_MSG_SPEEDADVICECONFIGURATIONGET:
         poRetType = OSAL_NEW rgfi_tclMsgSpeedAdviceConfigurationGet;
         break;
      case rgfi_tclToken::EN_MSG_SPEECHMETRICSYSTEMSTATUS:
         poRetType = OSAL_NEW rgfi_tclMsgSpeechMetricSystemStatus;
         break;
      case rgfi_tclToken::EN_MSG_SPEECHMETRICSYSTEMGET:
         poRetType = OSAL_NEW rgfi_tclMsgSpeechMetricSystemGet;
         break;
      case rgfi_tclToken::EN_MSG_SPEECHLANGUAGESTATUS:
         poRetType = OSAL_NEW rgfi_tclMsgSpeechLanguageStatus;
         break;
      case rgfi_tclToken::EN_MSG_SPEECHLANGUAGEGET:
         poRetType = OSAL_NEW rgfi_tclMsgSpeechLanguageGet;
         break;
      case rgfi_tclToken::EN_MSG_SPEECHFEATURESTATUS:
         poRetType = OSAL_NEW rgfi_tclMsgSpeechFeatureStatus;
         break;
      case rgfi_tclToken::EN_MSG_SPEECHFEATUREGET:
         poRetType = OSAL_NEW rgfi_tclMsgSpeechFeatureGet;
         break;
      case rgfi_tclToken::EN_MSG_SPEAKTMINFOMETHODSTART:
         poRetType = OSAL_NEW rgfi_tclMsgSpeakTMInfoMethodStart;
         break;
      case rgfi_tclToken::EN_MSG_SPEAKTMINFOMETHODRESULT:
         poRetType = OSAL_NEW rgfi_tclMsgSpeakTMInfoMethodResult;
         break;
      case rgfi_tclToken::EN_MSG_SPEAKTMINFOMETHODABORT:
         poRetType = OSAL_NEW rgfi_tclMsgSpeakTMInfoMethodAbort;
         break;
      case rgfi_tclToken::EN_MSG_SPEAKTMINFOABORTRESULT:
         poRetType = OSAL_NEW rgfi_tclMsgSpeakTMInfoAbortResult;
         break;
      case rgfi_tclToken::EN_MSG_SPEAKSENTENCEMETHODSTART:
         poRetType = OSAL_NEW rgfi_tclMsgSpeakSentenceMethodStart;
         break;
      case rgfi_tclToken::EN_MSG_SPEAKSENTENCEMETHODRESULT:
         poRetType = OSAL_NEW rgfi_tclMsgSpeakSentenceMethodResult;
         break;
      case rgfi_tclToken::EN_MSG_SIGNPOSTANDLANEINFOSTATUS:
         poRetType = OSAL_NEW rgfi_tclMsgSignPostAndLaneInfoStatus;
         break;
      case rgfi_tclToken::EN_MSG_SIGNPOSTANDLANEINFOGET:
         poRetType = OSAL_NEW rgfi_tclMsgSignPostAndLaneInfoGet;
         break;
      case rgfi_tclToken::EN_MSG_SETUSERPROFILESMETHODSTART:
         poRetType = OSAL_NEW rgfi_tclMsgSetUserProfilesMethodStart;
         break;
      case rgfi_tclToken::EN_MSG_SETUSERPROFILESMETHODRESULT:
         poRetType = OSAL_NEW rgfi_tclMsgSetUserProfilesMethodResult;
         break;
      case rgfi_tclToken::EN_MSG_SETPREDICTIVECCMODEMETHODSTART:
         poRetType = OSAL_NEW rgfi_tclMsgSetPredictiveCCModeMethodStart;
         break;
      case rgfi_tclToken::EN_MSG_SETPREDICTIVECCMODEMETHODRESULT:
         poRetType = OSAL_NEW rgfi_tclMsgSetPredictiveCCModeMethodResult;
         break;
      case rgfi_tclToken::EN_MSG_RETRIGGERACOUSTICOUTPUTMETHODSTART:
         poRetType = OSAL_NEW rgfi_tclMsgRetriggerAcousticOutputMethodStart;
         break;
      case rgfi_tclToken::EN_MSG_RETRIGGERACOUSTICOUTPUTMETHODRESULT:
         poRetType = OSAL_NEW rgfi_tclMsgRetriggerAcousticOutputMethodResult;
         break;
      case rgfi_tclToken::EN_MSG_PREDICTIVECCSTATEUPREG:
         poRetType = OSAL_NEW rgfi_tclMsgPredictiveCCStateUpReg;
         break;
      case rgfi_tclToken::EN_MSG_PREDICTIVECCSTATESTATUS:
         poRetType = OSAL_NEW rgfi_tclMsgPredictiveCCStateStatus;
         break;
      case rgfi_tclToken::EN_MSG_PREDICTIVECCSTATERELUPREG:
         poRetType = OSAL_NEW rgfi_tclMsgPredictiveCCStateRelUpReg;
         break;
      case rgfi_tclToken::EN_MSG_PREDICTIVECCSTATEGET:
         poRetType = OSAL_NEW rgfi_tclMsgPredictiveCCStateGet;
         break;
      case rgfi_tclToken::EN_MSG_PREDICTIVECCSPEEDRECOMMENDATIONUPREG:
         poRetType = OSAL_NEW rgfi_tclMsgPredictiveCCSpeedRecommendationUpReg;
         break;
      case rgfi_tclToken::EN_MSG_PREDICTIVECCSPEEDRECOMMENDATIONSTATUS:
         poRetType = OSAL_NEW rgfi_tclMsgPredictiveCCSpeedRecommendationStatus;
         break;
      case rgfi_tclToken::EN_MSG_PREDICTIVECCSPEEDRECOMMENDATIONRELUPREG:
         poRetType = OSAL_NEW rgfi_tclMsgPredictiveCCSpeedRecommendationRelUpReg;
         break;
      case rgfi_tclToken::EN_MSG_PLAYDEBUGSOUNDMETHODSTART:
         poRetType = OSAL_NEW rgfi_tclMsgPlayDebugSoundMethodStart;
         break;
      case rgfi_tclToken::EN_MSG_NEXTWARNINGPOINTDELTASTATUS:
         poRetType = OSAL_NEW rgfi_tclMsgNextWarningPointDeltaStatus;
         break;
      case rgfi_tclToken::EN_MSG_NEXTWARNINGPOINTDELTAGET:
         poRetType = OSAL_NEW rgfi_tclMsgNextWarningPointDeltaGet;
         break;
      case rgfi_tclToken::EN_MSG_NEXTWARNINGPOINTSTATUS:
         poRetType = OSAL_NEW rgfi_tclMsgNextWarningPointStatus;
         break;
      case rgfi_tclToken::EN_MSG_NEXTWARNINGPOINTGET:
         poRetType = OSAL_NEW rgfi_tclMsgNextWarningPointGet;
         break;
      case rgfi_tclToken::EN_MSG_NEXTMAPMANEUVERDESCRIPTORSTATUS:
         poRetType = OSAL_NEW rgfi_tclMsgNextMapManeuverDescriptorStatus;
         break;
      case rgfi_tclToken::EN_MSG_NEXTMAPMANEUVERDESCRIPTORGET:
         poRetType = OSAL_NEW rgfi_tclMsgNextMapManeuverDescriptorGet;
         break;
      case rgfi_tclToken::EN_MSG_NEXTMANEUVERDESCRIPTORSTATUS:
         poRetType = OSAL_NEW rgfi_tclMsgNextManeuverDescriptorStatus;
         break;
      case rgfi_tclToken::EN_MSG_NEXTMANEUVERDESCRIPTORGET:
         poRetType = OSAL_NEW rgfi_tclMsgNextManeuverDescriptorGet;
         break;
      case rgfi_tclToken::EN_MSG_NEXTGUIDANCEDESCRIPTORSSTATUS:
         poRetType = OSAL_NEW rgfi_tclMsgNextGuidanceDescriptorsStatus;
         break;
      case rgfi_tclToken::EN_MSG_NEXTGUIDANCEDESCRIPTORSGET:
         poRetType = OSAL_NEW rgfi_tclMsgNextGuidanceDescriptorsGet;
         break;
      case rgfi_tclToken::EN_MSG_MULTIMEDIAINFORMATIONSTATUS:
         poRetType = OSAL_NEW rgfi_tclMsgMultiMediaInformationStatus;
         break;
      case rgfi_tclToken::EN_MSG_MULTIMEDIAINFORMATIONGET:
         poRetType = OSAL_NEW rgfi_tclMsgMultiMediaInformationGet;
         break;
      case rgfi_tclToken::EN_MSG_LASTPROCESSEDTEAMPPUPREG:
         poRetType = OSAL_NEW rgfi_tclMsgLastProcessedTEAMPPUpReg;
         break;
      case rgfi_tclToken::EN_MSG_LASTPROCESSEDTEAMPPSTATUS:
         poRetType = OSAL_NEW rgfi_tclMsgLastProcessedTEAMPPStatus;
         break;
      case rgfi_tclToken::EN_MSG_LASTPROCESSEDTEAMPPRELUPREG:
         poRetType = OSAL_NEW rgfi_tclMsgLastProcessedTEAMPPRelUpReg;
         break;
      case rgfi_tclToken::EN_MSG_LASTPROCESSEDTEAMPPGET:
         poRetType = OSAL_NEW rgfi_tclMsgLastProcessedTEAMPPGet;
         break;
      case rgfi_tclToken::EN_MSG_LASTPROCESSEDTEAHORIZONUPREG:
         poRetType = OSAL_NEW rgfi_tclMsgLastProcessedTEAHorizonUpReg;
         break;
      case rgfi_tclToken::EN_MSG_LASTPROCESSEDTEAHORIZONSTATUS:
         poRetType = OSAL_NEW rgfi_tclMsgLastProcessedTEAHorizonStatus;
         break;
      case rgfi_tclToken::EN_MSG_LASTPROCESSEDTEAHORIZONRELUPREG:
         poRetType = OSAL_NEW rgfi_tclMsgLastProcessedTEAHorizonRelUpReg;
         break;
      case rgfi_tclToken::EN_MSG_LASTPROCESSEDTEAHORIZONGET:
         poRetType = OSAL_NEW rgfi_tclMsgLastProcessedTEAHorizonGet;
         break;
      case rgfi_tclToken::EN_MSG_LASTPROCESSEDROUTEINFOLISTUPREG:
         poRetType = OSAL_NEW rgfi_tclMsgLastProcessedRouteInfoListUpReg;
         break;
      case rgfi_tclToken::EN_MSG_LASTPROCESSEDROUTEINFOLISTSTATUS:
         poRetType = OSAL_NEW rgfi_tclMsgLastProcessedRouteInfoListStatus;
         break;
      case rgfi_tclToken::EN_MSG_LASTPROCESSEDROUTEINFOLISTRELUPREG:
         poRetType = OSAL_NEW rgfi_tclMsgLastProcessedRouteInfoListRelUpReg;
         break;
      case rgfi_tclToken::EN_MSG_LASTPROCESSEDROUTEINFOLISTGET:
         poRetType = OSAL_NEW rgfi_tclMsgLastProcessedRouteInfoListGet;
         break;
      case rgfi_tclToken::EN_MSG_LASTDRIVINGRECOMMENDATIONSTATUS:
         poRetType = OSAL_NEW rgfi_tclMsgLastDrivingRecommendationStatus;
         break;
      case rgfi_tclToken::EN_MSG_LASTDRIVINGRECOMMENDATIONGET:
         poRetType = OSAL_NEW rgfi_tclMsgLastDrivingRecommendationGet;
         break;
      case rgfi_tclToken::EN_MSG_HORIZONEVENTSSTATUS:
         poRetType = OSAL_NEW rgfi_tclMsgHorizonEventsStatus;
         break;
      case rgfi_tclToken::EN_MSG_HORIZONEVENTSGET:
         poRetType = OSAL_NEW rgfi_tclMsgHorizonEventsGet;
         break;
      case rgfi_tclToken::EN_MSG_HORIZONDELTADISTANCESTATUS:
         poRetType = OSAL_NEW rgfi_tclMsgHorizonDeltaDistanceStatus;
         break;
      case rgfi_tclToken::EN_MSG_HORIZONDELTADISTANCEGET:
         poRetType = OSAL_NEW rgfi_tclMsgHorizonDeltaDistanceGet;
         break;
      case rgfi_tclToken::EN_MSG_GUIDANCESTATUSSTATUS:
         poRetType = OSAL_NEW rgfi_tclMsgGuidanceStatusStatus;
         break;
      case rgfi_tclToken::EN_MSG_GUIDANCESTATUSGET:
         poRetType = OSAL_NEW rgfi_tclMsgGuidanceStatusGet;
         break;
      case rgfi_tclToken::EN_MSG_GUIDANCEMODESTATUS:
         poRetType = OSAL_NEW rgfi_tclMsgGuidanceModeStatus;
         break;
      case rgfi_tclToken::EN_MSG_GUIDANCEMODEGET:
         poRetType = OSAL_NEW rgfi_tclMsgGuidanceModeGet;
         break;
      case rgfi_tclToken::EN_MSG_GETSUPPORTEDFUNCTIONALITYSTATESMETHODSTART:
         poRetType = OSAL_NEW rgfi_tclMsgGetSupportedFunctionalityStatesMethodStart;
         break;
      case rgfi_tclToken::EN_MSG_GETSUPPORTEDFUNCTIONALITYSTATESMETHODRESULT:
         poRetType = OSAL_NEW rgfi_tclMsgGetSupportedFunctionalityStatesMethodResult;
         break;
      case rgfi_tclToken::EN_MSG_GETAVAILABLESPEECHMETRICSYSTEMSMETHODSTART:
         poRetType = OSAL_NEW rgfi_tclMsgGetAvailableSpeechMetricSystemsMethodStart;
         break;
      case rgfi_tclToken::EN_MSG_GETAVAILABLESPEECHMETRICSYSTEMSMETHODRESULT:
         poRetType = OSAL_NEW rgfi_tclMsgGetAvailableSpeechMetricSystemsMethodResult;
         break;
      case rgfi_tclToken::EN_MSG_GETAVAILABLESPEECHLANGUAGESMETHODSTART:
         poRetType = OSAL_NEW rgfi_tclMsgGetAvailableSpeechLanguagesMethodStart;
         break;
      case rgfi_tclToken::EN_MSG_GETAVAILABLESPEECHLANGUAGESMETHODRESULT:
         poRetType = OSAL_NEW rgfi_tclMsgGetAvailableSpeechLanguagesMethodResult;
         break;
      case rgfi_tclToken::EN_MSG_GETAVAILABLESPEECHFEATUREMETHODSTART:
         poRetType = OSAL_NEW rgfi_tclMsgGetAvailableSpeechFeatureMethodStart;
         break;
      case rgfi_tclToken::EN_MSG_GETAVAILABLESPEECHFEATUREMETHODRESULT:
         poRetType = OSAL_NEW rgfi_tclMsgGetAvailableSpeechFeatureMethodResult;
         break;
      case rgfi_tclToken::EN_MSG_FUNCTIONALITYSTATESSTATUS:
         poRetType = OSAL_NEW rgfi_tclMsgFunctionalityStatesStatus;
         break;
      case rgfi_tclToken::EN_MSG_FUNCTIONALITYSTATESSET:
         poRetType = OSAL_NEW rgfi_tclMsgFunctionalityStatesSet;
         break;
      case rgfi_tclToken::EN_MSG_FUNCTIONALITYSTATESGET:
         poRetType = OSAL_NEW rgfi_tclMsgFunctionalityStatesGet;
         break;
      case rgfi_tclToken::EN_MSG_ENGINEERINGTEXTUPREG:
         poRetType = OSAL_NEW rgfi_tclMsgEngineeringTextUpReg;
         break;
      case rgfi_tclToken::EN_MSG_ENGINEERINGTEXTSTATUS:
         poRetType = OSAL_NEW rgfi_tclMsgEngineeringTextStatus;
         break;
      case rgfi_tclToken::EN_MSG_ENGINEERINGTEXTRELUPREG:
         poRetType = OSAL_NEW rgfi_tclMsgEngineeringTextRelUpReg;
         break;
      case rgfi_tclToken::EN_MSG_ENGINEERINGTEXTGET:
         poRetType = OSAL_NEW rgfi_tclMsgEngineeringTextGet;
         break;
      case rgfi_tclToken::EN_MSG_DRIVERSPEEDADVICEUPREG:
         poRetType = OSAL_NEW rgfi_tclMsgDriverSpeedAdviceUpReg;
         break;
      case rgfi_tclToken::EN_MSG_DRIVERSPEEDADVICESTATUS:
         poRetType = OSAL_NEW rgfi_tclMsgDriverSpeedAdviceStatus;
         break;
      case rgfi_tclToken::EN_MSG_DRIVERSPEEDADVICERELUPREG:
         poRetType = OSAL_NEW rgfi_tclMsgDriverSpeedAdviceRelUpReg;
         break;
      case rgfi_tclToken::EN_MSG_DRIVERSPEEDADVICEGET:
         poRetType = OSAL_NEW rgfi_tclMsgDriverSpeedAdviceGet;
         break;
      case rgfi_tclToken::EN_MSG_DISTANCETONEXTMANEUVERSTATUS:
         poRetType = OSAL_NEW rgfi_tclMsgDistanceToNextManeuverStatus;
         break;
      case rgfi_tclToken::EN_MSG_DISTANCETONEXTMANEUVERGET:
         poRetType = OSAL_NEW rgfi_tclMsgDistanceToNextManeuverGet;
         break;
      case rgfi_tclToken::EN_MSG_DISTANCETOCURRENTMANOEUVRESTATUS:
         poRetType = OSAL_NEW rgfi_tclMsgDistanceToCurrentManoeuvreStatus;
         break;
      case rgfi_tclToken::EN_MSG_DISTANCETOCURRENTMANOEUVREGET:
         poRetType = OSAL_NEW rgfi_tclMsgDistanceToCurrentManoeuvreGet;
         break;
      case rgfi_tclToken::EN_MSG_DATAPROCESSEDUPREG:
         poRetType = OSAL_NEW rgfi_tclMsgDataProcessedUpReg;
         break;
      case rgfi_tclToken::EN_MSG_DATAPROCESSEDSTATUS:
         poRetType = OSAL_NEW rgfi_tclMsgDataProcessedStatus;
         break;
      case rgfi_tclToken::EN_MSG_DATAPROCESSEDRELUPREG:
         poRetType = OSAL_NEW rgfi_tclMsgDataProcessedRelUpReg;
         break;
      case rgfi_tclToken::EN_MSG_DATACARRIERREQUESTSTATUS:
         poRetType = OSAL_NEW rgfi_tclMsgDataCarrierRequestStatus;
         break;
      case rgfi_tclToken::EN_MSG_DATACARRIERREQUESTGET:
         poRetType = OSAL_NEW rgfi_tclMsgDataCarrierRequestGet;
         break;
      case rgfi_tclToken::EN_MSG_CURVEWARNINGCONFIGURATIONSTATUS:
         poRetType = OSAL_NEW rgfi_tclMsgCurveWarningConfigurationStatus;
         break;
      case rgfi_tclToken::EN_MSG_CURVEWARNINGCONFIGURATIONSET:
         poRetType = OSAL_NEW rgfi_tclMsgCurveWarningConfigurationSet;
         break;
      case rgfi_tclToken::EN_MSG_CURVEWARNINGCONFIGURATIONGET:
         poRetType = OSAL_NEW rgfi_tclMsgCurveWarningConfigurationGet;
         break;
      case rgfi_tclToken::EN_MSG_CURRENTLANEINFOSTATUS:
         poRetType = OSAL_NEW rgfi_tclMsgCurrentLaneInfoStatus;
         break;
      case rgfi_tclToken::EN_MSG_CURRENTLANEINFOGET:
         poRetType = OSAL_NEW rgfi_tclMsgCurrentLaneInfoGet;
         break;
      case rgfi_tclToken::EN_MSG_CURRENTGUIDANCEDESCRIPTORSTATUS:
         poRetType = OSAL_NEW rgfi_tclMsgCurrentGuidanceDescriptorStatus;
         break;
      case rgfi_tclToken::EN_MSG_CURRENTGUIDANCEDESCRIPTORGET:
         poRetType = OSAL_NEW rgfi_tclMsgCurrentGuidanceDescriptorGet;
         break;
      case rgfi_tclToken::EN_MSG_COASTINGADVICECONFIGURATIONUPREG:
         poRetType = OSAL_NEW rgfi_tclMsgCoastingAdviceConfigurationUpReg;
         break;
      case rgfi_tclToken::EN_MSG_COASTINGADVICECONFIGURATIONSTATUS:
         poRetType = OSAL_NEW rgfi_tclMsgCoastingAdviceConfigurationStatus;
         break;
      case rgfi_tclToken::EN_MSG_COASTINGADVICECONFIGURATIONSET:
         poRetType = OSAL_NEW rgfi_tclMsgCoastingAdviceConfigurationSet;
         break;
      case rgfi_tclToken::EN_MSG_COASTINGADVICECONFIGURATIONRELUPREG:
         poRetType = OSAL_NEW rgfi_tclMsgCoastingAdviceConfigurationRelUpReg;
         break;
      case rgfi_tclToken::EN_MSG_COASTINGADVICECONFIGURATIONGET:
         poRetType = OSAL_NEW rgfi_tclMsgCoastingAdviceConfigurationGet;
         break;
      case rgfi_tclToken::EN_MSG_CHANGEWARNINGSONHORIZONMODEMETHODSTART:
         poRetType = OSAL_NEW rgfi_tclMsgChangeWarningsOnHorizonModeMethodStart;
         break;
      case rgfi_tclToken::EN_MSG_CHANGEWARNINGSONHORIZONMODEMETHODRESULT:
         poRetType = OSAL_NEW rgfi_tclMsgChangeWarningsOnHorizonModeMethodResult;
         break;
      case rgfi_tclToken::EN_MSG_CHANGESPEECHMETRICSYSTEMMETHODSTART:
         poRetType = OSAL_NEW rgfi_tclMsgChangeSpeechMetricSystemMethodStart;
         break;
      case rgfi_tclToken::EN_MSG_CHANGESPEECHMETRICSYSTEMMETHODRESULT:
         poRetType = OSAL_NEW rgfi_tclMsgChangeSpeechMetricSystemMethodResult;
         break;
      case rgfi_tclToken::EN_MSG_CHANGESPEECHLANGUAGEMETHODSTART:
         poRetType = OSAL_NEW rgfi_tclMsgChangeSpeechLanguageMethodStart;
         break;
      case rgfi_tclToken::EN_MSG_CHANGESPEECHLANGUAGEMETHODRESULT:
         poRetType = OSAL_NEW rgfi_tclMsgChangeSpeechLanguageMethodResult;
         break;
      case rgfi_tclToken::EN_MSG_CHANGESPEECHFEATUREMETHODSTART:
         poRetType = OSAL_NEW rgfi_tclMsgChangeSpeechFeatureMethodStart;
         break;
      case rgfi_tclToken::EN_MSG_CHANGESPEECHFEATUREMETHODRESULT:
         poRetType = OSAL_NEW rgfi_tclMsgChangeSpeechFeatureMethodResult;
         break;
      case rgfi_tclToken::EN_MSG_CHANGEGUIDANCEMODEMETHODSTART:
         poRetType = OSAL_NEW rgfi_tclMsgChangeGuidanceModeMethodStart;
         break;
      case rgfi_tclToken::EN_MSG_CHANGEGUIDANCEMODEMETHODRESULT:
         poRetType = OSAL_NEW rgfi_tclMsgChangeGuidanceModeMethodResult;
         break;
      default: 
         poRetType = OSAL_NULL;
      }
      break;
   case RTFFI_C_U16_SERVICE_ID:
      switch ((u16FunctionId << 16) + (u8Opcode << 8))
      {
      case rtffi_tclToken::EN_MSG_TRANSITIONREQUESTSTATUS:
         poRetType = OSAL_NEW rtffi_tclMsgTransitionRequestStatus;
         break;
      case rtffi_tclToken::EN_MSG_TRANSITIONREQUESTGET:
         poRetType = OSAL_NEW rtffi_tclMsgTransitionRequestGet;
         break;
      case rtffi_tclToken::EN_MSG_REQUESTSHUTDOWNMETHODSTART:
         poRetType = OSAL_NEW rtffi_tclMsgRequestShutdownMethodStart;
         break;
      case rtffi_tclToken::EN_MSG_REQUESTSHUTDOWNMETHODRESULT:
         poRetType = OSAL_NEW rtffi_tclMsgRequestShutdownMethodResult;
         break;
      case rtffi_tclToken::EN_MSG_INTERNALMESSAGEMETHODSTART:
         poRetType = OSAL_NEW rtffi_tclMsgInternalMessageMethodStart;
         break;
      case rtffi_tclToken::EN_MSG_INTERNALMESSAGEMETHODRESULT:
         poRetType = OSAL_NEW rtffi_tclMsgInternalMessageMethodResult;
         break;
      case rtffi_tclToken::EN_MSG_DISCONNECTTASKMETHODSTART:
         poRetType = OSAL_NEW rtffi_tclMsgDisconnectTaskMethodStart;
         break;
      case rtffi_tclToken::EN_MSG_DISCONNECTTASKMETHODRESULT:
         poRetType = OSAL_NEW rtffi_tclMsgDisconnectTaskMethodResult;
         break;
      case rtffi_tclToken::EN_MSG_CONNECTTASKMETHODSTART:
         poRetType = OSAL_NEW rtffi_tclMsgConnectTaskMethodStart;
         break;
      case rtffi_tclToken::EN_MSG_CONNECTTASKMETHODRESULT:
         poRetType = OSAL_NEW rtffi_tclMsgConnectTaskMethodResult;
         break;
      case rtffi_tclToken::EN_MSG_CONFIRMSTATEREACHEDMETHODSTART:
         poRetType = OSAL_NEW rtffi_tclMsgConfirmStateReachedMethodStart;
         break;
      case rtffi_tclToken::EN_MSG_CONFIRMSTATEREACHEDMETHODRESULT:
         poRetType = OSAL_NEW rtffi_tclMsgConfirmStateReachedMethodResult;
         break;
      default: 
         poRetType = OSAL_NULL;
      }
      break;
   case STATFI_C_U16_SERVICE_ID:
      switch ((u16FunctionId << 16) + (u8Opcode << 8))
      {
      case statfi_tclToken::EN_MSG_SETRECORDINGMODEANDSTARTRECORDINGMETHODSTART:
         poRetType = OSAL_NEW statfi_tclMsgSetRecordingModeAndStartRecordingMethodStart;
         break;
      case statfi_tclToken::EN_MSG_SETRECORDINGMODEANDSTARTRECORDINGMETHODRESULT:
         poRetType = OSAL_NEW statfi_tclMsgSetRecordingModeAndStartRecordingMethodResult;
         break;
      case statfi_tclToken::EN_MSG_RECORDINGSTATUSUPREG:
         poRetType = OSAL_NEW statfi_tclMsgRecordingStatusUpReg;
         break;
      case statfi_tclToken::EN_MSG_RECORDINGSTATUSSTATUS:
         poRetType = OSAL_NEW statfi_tclMsgRecordingStatusStatus;
         break;
      case statfi_tclToken::EN_MSG_RECORDINGSTATUSRELUPREG:
         poRetType = OSAL_NEW statfi_tclMsgRecordingStatusRelUpReg;
         break;
      case statfi_tclToken::EN_MSG_RECORDINGSTATUSGET:
         poRetType = OSAL_NEW statfi_tclMsgRecordingStatusGet;
         break;
      case statfi_tclToken::EN_MSG_PROFILEDATAAVAILABLEUPREG:
         poRetType = OSAL_NEW statfi_tclMsgProfileDataAvailableUpReg;
         break;
      case statfi_tclToken::EN_MSG_PROFILEDATAAVAILABLESTATUS:
         poRetType = OSAL_NEW statfi_tclMsgProfileDataAvailableStatus;
         break;
      case statfi_tclToken::EN_MSG_PROFILEDATAAVAILABLERELUPREG:
         poRetType = OSAL_NEW statfi_tclMsgProfileDataAvailableRelUpReg;
         break;
      case statfi_tclToken::EN_MSG_NBOFWRONGCURRENTPOSITIONSUPREG:
         poRetType = OSAL_NEW statfi_tclMsgNbofWrongCurrentPositionsUpReg;
         break;
      case statfi_tclToken::EN_MSG_NBOFWRONGCURRENTPOSITIONSSTATUS:
         poRetType = OSAL_NEW statfi_tclMsgNbofWrongCurrentPositionsStatus;
         break;
      case statfi_tclToken::EN_MSG_NBOFWRONGCURRENTPOSITIONSRELUPREG:
         poRetType = OSAL_NEW statfi_tclMsgNbofWrongCurrentPositionsRelUpReg;
         break;
      case statfi_tclToken::EN_MSG_NBOFFREEBREADCRUMBSUPREG:
         poRetType = OSAL_NEW statfi_tclMsgNbofFreeBreadCrumbsUpReg;
         break;
      case statfi_tclToken::EN_MSG_NBOFFREEBREADCRUMBSSTATUS:
         poRetType = OSAL_NEW statfi_tclMsgNbofFreeBreadCrumbsStatus;
         break;
      case statfi_tclToken::EN_MSG_NBOFFREEBREADCRUMBSRELUPREG:
         poRetType = OSAL_NEW statfi_tclMsgNbofFreeBreadCrumbsRelUpReg;
         break;
      case statfi_tclToken::EN_MSG_NBOFFREEBREADCRUMBSGET:
         poRetType = OSAL_NEW statfi_tclMsgNbofFreeBreadCrumbsGet;
         break;
      case statfi_tclToken::EN_MSG_GETRECORDEDDATAMETHODSTART:
         poRetType = OSAL_NEW statfi_tclMsgGetRecordedDataMethodStart;
         break;
      case statfi_tclToken::EN_MSG_GETRECORDEDDATAMETHODRESULTMIDDLE:
         poRetType = OSAL_NEW statfi_tclMsgGetRecordedDataMethodResultMiddle;
         break;
      case statfi_tclToken::EN_MSG_GETRECORDEDDATAMETHODRESULTLAST:
         poRetType = OSAL_NEW statfi_tclMsgGetRecordedDataMethodResultLast;
         break;
      case statfi_tclToken::EN_MSG_GETRECORDEDDATAMETHODRESULTFIRST:
         poRetType = OSAL_NEW statfi_tclMsgGetRecordedDataMethodResultFirst;
         break;
      case statfi_tclToken::EN_MSG_GETRECORDEDDATAMETHODRESULT:
         poRetType = OSAL_NEW statfi_tclMsgGetRecordedDataMethodResult;
         break;
      case statfi_tclToken::EN_MSG_GETPROFILEDATAMETHODSTART:
         poRetType = OSAL_NEW statfi_tclMsgGetProfileDataMethodStart;
         break;
      case statfi_tclToken::EN_MSG_GETPROFILEDATAMETHODRESULT:
         poRetType = OSAL_NEW statfi_tclMsgGetProfileDataMethodResult;
         break;
      case statfi_tclToken::EN_MSG_GETDRIVENROUTEDATAMETHODSTART:
         poRetType = OSAL_NEW statfi_tclMsgGetDrivenRouteDataMethodStart;
         break;
      case statfi_tclToken::EN_MSG_GETDRIVENROUTEDATAMETHODRESULTMIDDLE:
         poRetType = OSAL_NEW statfi_tclMsgGetDrivenRouteDataMethodResultMiddle;
         break;
      case statfi_tclToken::EN_MSG_GETDRIVENROUTEDATAMETHODRESULTLAST:
         poRetType = OSAL_NEW statfi_tclMsgGetDrivenRouteDataMethodResultLast;
         break;
      case statfi_tclToken::EN_MSG_GETDRIVENROUTEDATAMETHODRESULTFIRST:
         poRetType = OSAL_NEW statfi_tclMsgGetDrivenRouteDataMethodResultFirst;
         break;
      case statfi_tclToken::EN_MSG_GETDRIVENROUTEDATAMETHODRESULT:
         poRetType = OSAL_NEW statfi_tclMsgGetDrivenRouteDataMethodResult;
         break;
      case statfi_tclToken::EN_MSG_ENGINEERINGTEXTUPREG:
         poRetType = OSAL_NEW statfi_tclMsgEngineeringTextUpReg;
         break;
      case statfi_tclToken::EN_MSG_ENGINEERINGTEXTSTATUS:
         poRetType = OSAL_NEW statfi_tclMsgEngineeringTextStatus;
         break;
      case statfi_tclToken::EN_MSG_ENGINEERINGTEXTRELUPREG:
         poRetType = OSAL_NEW statfi_tclMsgEngineeringTextRelUpReg;
         break;
      case statfi_tclToken::EN_MSG_ENGINEERINGTEXTGET:
         poRetType = OSAL_NEW statfi_tclMsgEngineeringTextGet;
         break;
      case statfi_tclToken::EN_MSG_DELETEALLBREADCRUMBSMETHODSTART:
         poRetType = OSAL_NEW statfi_tclMsgDeleteAllBreadCrumbsMethodStart;
         break;
      case statfi_tclToken::EN_MSG_DELETEALLBREADCRUMBSMETHODRESULT:
         poRetType = OSAL_NEW statfi_tclMsgDeleteAllBreadCrumbsMethodResult;
         break;
      case statfi_tclToken::EN_MSG_CURRENTPOSITIONUPREG:
         poRetType = OSAL_NEW statfi_tclMsgCurrentPositionUpReg;
         break;
      case statfi_tclToken::EN_MSG_CURRENTPOSITIONSTATUS:
         poRetType = OSAL_NEW statfi_tclMsgCurrentPositionStatus;
         break;
      case statfi_tclToken::EN_MSG_CURRENTPOSITIONRELUPREG:
         poRetType = OSAL_NEW statfi_tclMsgCurrentPositionRelUpReg;
         break;
      case statfi_tclToken::EN_MSG_CURRENTPOSITIONGET:
         poRetType = OSAL_NEW statfi_tclMsgCurrentPositionGet;
         break;
      default: 
         poRetType = OSAL_NULL;
      }
      break;
   case SXMFUELFI_C_U16_SERVICE_ID:
      switch ((u16FunctionId << 16) + (u8Opcode << 8))
      {
      case sxmfuelfi_tclToken::EN_MSG_TRANSFERFUELPRICEDATAMETHODSTART:
         poRetType = OSAL_NEW sxmfuelfi_tclMsgTransferFuelPriceDataMethodStart;
         break;
      case sxmfuelfi_tclToken::EN_MSG_TRANSFERFUELPRICEDATAMETHODRESULT:
         poRetType = OSAL_NEW sxmfuelfi_tclMsgTransferFuelPriceDataMethodResult;
         break;
      case sxmfuelfi_tclToken::EN_MSG_SXMSIGNALINFOUPREG:
         poRetType = OSAL_NEW sxmfuelfi_tclMsgSXMSignalInfoUpReg;
         break;
      case sxmfuelfi_tclToken::EN_MSG_SXMSIGNALINFOSTATUS:
         poRetType = OSAL_NEW sxmfuelfi_tclMsgSXMSignalInfoStatus;
         break;
      case sxmfuelfi_tclToken::EN_MSG_SXMSIGNALINFORELUPREG:
         poRetType = OSAL_NEW sxmfuelfi_tclMsgSXMSignalInfoRelUpReg;
         break;
      case sxmfuelfi_tclToken::EN_MSG_SXMSIGNALINFOGET:
         poRetType = OSAL_NEW sxmfuelfi_tclMsgSXMSignalInfoGet;
         break;
      case sxmfuelfi_tclToken::EN_MSG_REGIONWISHLISTMETHODSTART:
         poRetType = OSAL_NEW sxmfuelfi_tclMsgRegionWishListMethodStart;
         break;
      case sxmfuelfi_tclToken::EN_MSG_REGIONWISHLISTMETHODRESULT:
         poRetType = OSAL_NEW sxmfuelfi_tclMsgRegionWishListMethodResult;
         break;
      case sxmfuelfi_tclToken::EN_MSG_FUELTYPEDATAUPREG:
         poRetType = OSAL_NEW sxmfuelfi_tclMsgFuelTypeDataUpReg;
         break;
      case sxmfuelfi_tclToken::EN_MSG_FUELTYPEDATASTATUS:
         poRetType = OSAL_NEW sxmfuelfi_tclMsgFuelTypeDataStatus;
         break;
      case sxmfuelfi_tclToken::EN_MSG_FUELTYPEDATARELUPREG:
         poRetType = OSAL_NEW sxmfuelfi_tclMsgFuelTypeDataRelUpReg;
         break;
      case sxmfuelfi_tclToken::EN_MSG_FUELTYPEDATAGET:
         poRetType = OSAL_NEW sxmfuelfi_tclMsgFuelTypeDataGet;
         break;
      case sxmfuelfi_tclToken::EN_MSG_FUELPRICEDATAUPREG:
         poRetType = OSAL_NEW sxmfuelfi_tclMsgFuelPriceDataUpReg;
         break;
      case sxmfuelfi_tclToken::EN_MSG_FUELPRICEDATASTATUS:
         poRetType = OSAL_NEW sxmfuelfi_tclMsgFuelPriceDataStatus;
         break;
      case sxmfuelfi_tclToken::EN_MSG_FUELPRICEDATARELUPREG:
         poRetType = OSAL_NEW sxmfuelfi_tclMsgFuelPriceDataRelUpReg;
         break;
      case sxmfuelfi_tclToken::EN_MSG_FUELPRICEDATAGET:
         poRetType = OSAL_NEW sxmfuelfi_tclMsgFuelPriceDataGet;
         break;
      case sxmfuelfi_tclToken::EN_MSG_FUELDATAAUTHINFOUPREG:
         poRetType = OSAL_NEW sxmfuelfi_tclMsgFuelDataAuthInfoUpReg;
         break;
      case sxmfuelfi_tclToken::EN_MSG_FUELDATAAUTHINFOSTATUS:
         poRetType = OSAL_NEW sxmfuelfi_tclMsgFuelDataAuthInfoStatus;
         break;
      case sxmfuelfi_tclToken::EN_MSG_FUELDATAAUTHINFORELUPREG:
         poRetType = OSAL_NEW sxmfuelfi_tclMsgFuelDataAuthInfoRelUpReg;
         break;
      case sxmfuelfi_tclToken::EN_MSG_FUELDATAAUTHINFOGET:
         poRetType = OSAL_NEW sxmfuelfi_tclMsgFuelDataAuthInfoGet;
         break;
      default: 
         poRetType = OSAL_NULL;
      }
      break;
   case SXMMOVIEFI_C_U16_SERVICE_ID:
      switch ((u16FunctionId << 16) + (u8Opcode << 8))
      {
      case sxmmoviefi_tclToken::EN_MSG_TRANSFERMOVIETIMESDATAMETHODSTART:
         poRetType = OSAL_NEW sxmmoviefi_tclMsgTransferMovieTimesDataMethodStart;
         break;
      case sxmmoviefi_tclToken::EN_MSG_TRANSFERMOVIETIMESDATAMETHODRESULT:
         poRetType = OSAL_NEW sxmmoviefi_tclMsgTransferMovieTimesDataMethodResult;
         break;
      case sxmmoviefi_tclToken::EN_MSG_TRANSFERMOVIEDESCRIPTIONDATAMETHODSTART:
         poRetType = OSAL_NEW sxmmoviefi_tclMsgTransferMovieDescriptionDataMethodStart;
         break;
      case sxmmoviefi_tclToken::EN_MSG_TRANSFERMOVIEDESCRIPTIONDATAMETHODRESULT:
         poRetType = OSAL_NEW sxmmoviefi_tclMsgTransferMovieDescriptionDataMethodResult;
         break;
      case sxmmoviefi_tclToken::EN_MSG_SIGNALINFOUPREG:
         poRetType = OSAL_NEW sxmmoviefi_tclMsgSignalInfoUpReg;
         break;
      case sxmmoviefi_tclToken::EN_MSG_SIGNALINFOSTATUS:
         poRetType = OSAL_NEW sxmmoviefi_tclMsgSignalInfoStatus;
         break;
      case sxmmoviefi_tclToken::EN_MSG_SIGNALINFORELUPREG:
         poRetType = OSAL_NEW sxmmoviefi_tclMsgSignalInfoRelUpReg;
         break;
      case sxmmoviefi_tclToken::EN_MSG_SIGNALINFOGET:
         poRetType = OSAL_NEW sxmmoviefi_tclMsgSignalInfoGet;
         break;
      case sxmmoviefi_tclToken::EN_MSG_MOVIETIMESDATAUPREG:
         poRetType = OSAL_NEW sxmmoviefi_tclMsgMovieTimesDataUpReg;
         break;
      case sxmmoviefi_tclToken::EN_MSG_MOVIETIMESDATASTATUS:
         poRetType = OSAL_NEW sxmmoviefi_tclMsgMovieTimesDataStatus;
         break;
      case sxmmoviefi_tclToken::EN_MSG_MOVIETIMESDATARELUPREG:
         poRetType = OSAL_NEW sxmmoviefi_tclMsgMovieTimesDataRelUpReg;
         break;
      case sxmmoviefi_tclToken::EN_MSG_MOVIETIMESDATAGET:
         poRetType = OSAL_NEW sxmmoviefi_tclMsgMovieTimesDataGet;
         break;
      case sxmmoviefi_tclToken::EN_MSG_MOVIEDESCRIPTIONDATAUPREG:
         poRetType = OSAL_NEW sxmmoviefi_tclMsgMovieDescriptionDataUpReg;
         break;
      case sxmmoviefi_tclToken::EN_MSG_MOVIEDESCRIPTIONDATASTATUS:
         poRetType = OSAL_NEW sxmmoviefi_tclMsgMovieDescriptionDataStatus;
         break;
      case sxmmoviefi_tclToken::EN_MSG_MOVIEDESCRIPTIONDATARELUPREG:
         poRetType = OSAL_NEW sxmmoviefi_tclMsgMovieDescriptionDataRelUpReg;
         break;
      case sxmmoviefi_tclToken::EN_MSG_MOVIEDESCRIPTIONDATAGET:
         poRetType = OSAL_NEW sxmmoviefi_tclMsgMovieDescriptionDataGet;
         break;
      case sxmmoviefi_tclToken::EN_MSG_MOVIEDATAAUTHINFOUPREG:
         poRetType = OSAL_NEW sxmmoviefi_tclMsgMovieDataAuthInfoUpReg;
         break;
      case sxmmoviefi_tclToken::EN_MSG_MOVIEDATAAUTHINFOSTATUS:
         poRetType = OSAL_NEW sxmmoviefi_tclMsgMovieDataAuthInfoStatus;
         break;
      case sxmmoviefi_tclToken::EN_MSG_MOVIEDATAAUTHINFORELUPREG:
         poRetType = OSAL_NEW sxmmoviefi_tclMsgMovieDataAuthInfoRelUpReg;
         break;
      case sxmmoviefi_tclToken::EN_MSG_MOVIEDATAAUTHINFOGET:
         poRetType = OSAL_NEW sxmmoviefi_tclMsgMovieDataAuthInfoGet;
         break;
      default: 
         poRetType = OSAL_NULL;
      }
      break;
   case SXMWEATHERFI_C_U16_SERVICE_ID:
      switch ((u16FunctionId << 16) + (u8Opcode << 8))
      {
      case sxmweatherfi_tclToken::EN_MSG_XCHNGECAPABILITIESMETHODSTART:
         poRetType = OSAL_NEW sxmweatherfi_tclMsgXchngeCapabilitiesMethodStart;
         break;
      case sxmweatherfi_tclToken::EN_MSG_XCHNGECAPABILITIESMETHODRESULT:
         poRetType = OSAL_NEW sxmweatherfi_tclMsgXchngeCapabilitiesMethodResult;
         break;
      case sxmweatherfi_tclToken::EN_MSG_WEATHERALERTSAUTHINFOUPREG:
         poRetType = OSAL_NEW sxmweatherfi_tclMsgWeatherAlertsAuthInfoUpReg;
         break;
      case sxmweatherfi_tclToken::EN_MSG_WEATHERALERTSAUTHINFOSTATUS:
         poRetType = OSAL_NEW sxmweatherfi_tclMsgWeatherAlertsAuthInfoStatus;
         break;
      case sxmweatherfi_tclToken::EN_MSG_WEATHERALERTSAUTHINFORELUPREG:
         poRetType = OSAL_NEW sxmweatherfi_tclMsgWeatherAlertsAuthInfoRelUpReg;
         break;
      case sxmweatherfi_tclToken::EN_MSG_WEATHERALERTSAUTHINFOGET:
         poRetType = OSAL_NEW sxmweatherfi_tclMsgWeatherAlertsAuthInfoGet;
         break;
      case sxmweatherfi_tclToken::EN_MSG_WEATHERALERTSAUUPREG:
         poRetType = OSAL_NEW sxmweatherfi_tclMsgWeatherAlertsAUUpReg;
         break;
      case sxmweatherfi_tclToken::EN_MSG_WEATHERALERTSAUSTATUS:
         poRetType = OSAL_NEW sxmweatherfi_tclMsgWeatherAlertsAUStatus;
         break;
      case sxmweatherfi_tclToken::EN_MSG_WEATHERALERTSAURELUPREG:
         poRetType = OSAL_NEW sxmweatherfi_tclMsgWeatherAlertsAURelUpReg;
         break;
      case sxmweatherfi_tclToken::EN_MSG_TRANSFERUPDATEFILEINFOMETHODSTART:
         poRetType = OSAL_NEW sxmweatherfi_tclMsgTransferUpdateFileInfoMethodStart;
         break;
      case sxmweatherfi_tclToken::EN_MSG_TRANSFERUPDATEFILEINFOMETHODRESULT:
         poRetType = OSAL_NEW sxmweatherfi_tclMsgTransferUpdateFileInfoMethodResult;
         break;
      case sxmweatherfi_tclToken::EN_MSG_TABWEATHERDATAUPREG:
         poRetType = OSAL_NEW sxmweatherfi_tclMsgTabWeatherDataUpReg;
         break;
      case sxmweatherfi_tclToken::EN_MSG_TABWEATHERDATASTATUS:
         poRetType = OSAL_NEW sxmweatherfi_tclMsgTabWeatherDataStatus;
         break;
      case sxmweatherfi_tclToken::EN_MSG_TABWEATHERDATARELUPREG:
         poRetType = OSAL_NEW sxmweatherfi_tclMsgTabWeatherDataRelUpReg;
         break;
      case sxmweatherfi_tclToken::EN_MSG_TABWEATHERAUTHINFOUPREG:
         poRetType = OSAL_NEW sxmweatherfi_tclMsgTabWeatherAuthInfoUpReg;
         break;
      case sxmweatherfi_tclToken::EN_MSG_TABWEATHERAUTHINFOSTATUS:
         poRetType = OSAL_NEW sxmweatherfi_tclMsgTabWeatherAuthInfoStatus;
         break;
      case sxmweatherfi_tclToken::EN_MSG_TABWEATHERAUTHINFORELUPREG:
         poRetType = OSAL_NEW sxmweatherfi_tclMsgTabWeatherAuthInfoRelUpReg;
         break;
      case sxmweatherfi_tclToken::EN_MSG_TABWEATHERAUTHINFOGET:
         poRetType = OSAL_NEW sxmweatherfi_tclMsgTabWeatherAuthInfoGet;
         break;
      case sxmweatherfi_tclToken::EN_MSG_SXMSIGNALINFOUPREG:
         poRetType = OSAL_NEW sxmweatherfi_tclMsgSXMSignalInfoUpReg;
         break;
      case sxmweatherfi_tclToken::EN_MSG_SXMSIGNALINFOSTATUS:
         poRetType = OSAL_NEW sxmweatherfi_tclMsgSXMSignalInfoStatus;
         break;
      case sxmweatherfi_tclToken::EN_MSG_SXMSIGNALINFORELUPREG:
         poRetType = OSAL_NEW sxmweatherfi_tclMsgSXMSignalInfoRelUpReg;
         break;
      case sxmweatherfi_tclToken::EN_MSG_SXMSIGNALINFOGET:
         poRetType = OSAL_NEW sxmweatherfi_tclMsgSXMSignalInfoGet;
         break;
      case sxmweatherfi_tclToken::EN_MSG_RELEASEUPDATEFILEMETHODSTART:
         poRetType = OSAL_NEW sxmweatherfi_tclMsgReleaseUpdateFileMethodStart;
         break;
      case sxmweatherfi_tclToken::EN_MSG_RELEASEUPDATEFILEMETHODRESULT:
         poRetType = OSAL_NEW sxmweatherfi_tclMsgReleaseUpdateFileMethodResult;
         break;
      case sxmweatherfi_tclToken::EN_MSG_RELEASEGRAPHICALAUMETHODSTART:
         poRetType = OSAL_NEW sxmweatherfi_tclMsgReleaseGraphicalAUMethodStart;
         break;
      case sxmweatherfi_tclToken::EN_MSG_RELEASEGRAPHICALAUMETHODRESULT:
         poRetType = OSAL_NEW sxmweatherfi_tclMsgReleaseGraphicalAUMethodResult;
         break;
      case sxmweatherfi_tclToken::EN_MSG_NEWUPDATEFILEAVAILABLEUPREG:
         poRetType = OSAL_NEW sxmweatherfi_tclMsgNewUpdateFileAvailableUpReg;
         break;
      case sxmweatherfi_tclToken::EN_MSG_NEWUPDATEFILEAVAILABLESTATUS:
         poRetType = OSAL_NEW sxmweatherfi_tclMsgNewUpdateFileAvailableStatus;
         break;
      case sxmweatherfi_tclToken::EN_MSG_NEWUPDATEFILEAVAILABLERELUPREG:
         poRetType = OSAL_NEW sxmweatherfi_tclMsgNewUpdateFileAvailableRelUpReg;
         break;
      case sxmweatherfi_tclToken::EN_MSG_GRAPHICALWEATHERDATAUPREG:
         poRetType = OSAL_NEW sxmweatherfi_tclMsgGraphicalWeatherDataUpReg;
         break;
      case sxmweatherfi_tclToken::EN_MSG_GRAPHICALWEATHERDATASTATUS:
         poRetType = OSAL_NEW sxmweatherfi_tclMsgGraphicalWeatherDataStatus;
         break;
      case sxmweatherfi_tclToken::EN_MSG_GRAPHICALWEATHERDATARELUPREG:
         poRetType = OSAL_NEW sxmweatherfi_tclMsgGraphicalWeatherDataRelUpReg;
         break;
      case sxmweatherfi_tclToken::EN_MSG_GRAPHICALWEATHERAUTHINFOUPREG:
         poRetType = OSAL_NEW sxmweatherfi_tclMsgGraphicalWeatherAuthInfoUpReg;
         break;
      case sxmweatherfi_tclToken::EN_MSG_GRAPHICALWEATHERAUTHINFOSTATUS:
         poRetType = OSAL_NEW sxmweatherfi_tclMsgGraphicalWeatherAuthInfoStatus;
         break;
      case sxmweatherfi_tclToken::EN_MSG_GRAPHICALWEATHERAUTHINFORELUPREG:
         poRetType = OSAL_NEW sxmweatherfi_tclMsgGraphicalWeatherAuthInfoRelUpReg;
         break;
      case sxmweatherfi_tclToken::EN_MSG_GRAPHICALWEATHERAUTHINFOGET:
         poRetType = OSAL_NEW sxmweatherfi_tclMsgGraphicalWeatherAuthInfoGet;
         break;
      case sxmweatherfi_tclToken::EN_MSG_GRAPHICALWEATHERAUUPREG:
         poRetType = OSAL_NEW sxmweatherfi_tclMsgGraphicalWeatherAUUpReg;
         break;
      case sxmweatherfi_tclToken::EN_MSG_GRAPHICALWEATHERAUSTATUS:
         poRetType = OSAL_NEW sxmweatherfi_tclMsgGraphicalWeatherAUStatus;
         break;
      case sxmweatherfi_tclToken::EN_MSG_GRAPHICALWEATHERAURELUPREG:
         poRetType = OSAL_NEW sxmweatherfi_tclMsgGraphicalWeatherAURelUpReg;
         break;
      case sxmweatherfi_tclToken::EN_MSG_ACQUIREGRAPHICALAUMETHODSTART:
         poRetType = OSAL_NEW sxmweatherfi_tclMsgAcquireGraphicalAUMethodStart;
         break;
      case sxmweatherfi_tclToken::EN_MSG_ACQUIREGRAPHICALAUMETHODRESULT:
         poRetType = OSAL_NEW sxmweatherfi_tclMsgAcquireGraphicalAUMethodResult;
         break;
      default: 
         poRetType = OSAL_NULL;
      }
      break;
   case SXM_SMS_WEATHERFI_C_U16_SERVICE_ID:
      switch ((u16FunctionId << 16) + (u8Opcode << 8))
      {
      case sxm_sms_weatherfi_tclToken::EN_MSG_WINDMAGNITUDEDATAUPREG:
         poRetType = OSAL_NEW sxm_sms_weatherfi_tclMsgWindMagnitudeDataUpReg;
         break;
      case sxm_sms_weatherfi_tclToken::EN_MSG_WINDMAGNITUDEDATASTATUS:
         poRetType = OSAL_NEW sxm_sms_weatherfi_tclMsgWindMagnitudeDataStatus;
         break;
      case sxm_sms_weatherfi_tclToken::EN_MSG_WINDMAGNITUDEDATARELUPREG:
         poRetType = OSAL_NEW sxm_sms_weatherfi_tclMsgWindMagnitudeDataRelUpReg;
         break;
      case sxm_sms_weatherfi_tclToken::EN_MSG_WINDMAGNITUDEDATAGET:
         poRetType = OSAL_NEW sxm_sms_weatherfi_tclMsgWindMagnitudeDataGet;
         break;
      case sxm_sms_weatherfi_tclToken::EN_MSG_WINDDIRECTIONDATAUPREG:
         poRetType = OSAL_NEW sxm_sms_weatherfi_tclMsgWindDirectionDataUpReg;
         break;
      case sxm_sms_weatherfi_tclToken::EN_MSG_WINDDIRECTIONDATASTATUS:
         poRetType = OSAL_NEW sxm_sms_weatherfi_tclMsgWindDirectionDataStatus;
         break;
      case sxm_sms_weatherfi_tclToken::EN_MSG_WINDDIRECTIONDATARELUPREG:
         poRetType = OSAL_NEW sxm_sms_weatherfi_tclMsgWindDirectionDataRelUpReg;
         break;
      case sxm_sms_weatherfi_tclToken::EN_MSG_WINDDIRECTIONDATAGET:
         poRetType = OSAL_NEW sxm_sms_weatherfi_tclMsgWindDirectionDataGet;
         break;
      case sxm_sms_weatherfi_tclToken::EN_MSG_SURFACEDATAUPREG:
         poRetType = OSAL_NEW sxm_sms_weatherfi_tclMsgSurfaceDataUpReg;
         break;
      case sxm_sms_weatherfi_tclToken::EN_MSG_SURFACEDATASTATUS:
         poRetType = OSAL_NEW sxm_sms_weatherfi_tclMsgSurfaceDataStatus;
         break;
      case sxm_sms_weatherfi_tclToken::EN_MSG_SURFACEDATARELUPREG:
         poRetType = OSAL_NEW sxm_sms_weatherfi_tclMsgSurfaceDataRelUpReg;
         break;
      case sxm_sms_weatherfi_tclToken::EN_MSG_SURFACEDATAGET:
         poRetType = OSAL_NEW sxm_sms_weatherfi_tclMsgSurfaceDataGet;
         break;
      case sxm_sms_weatherfi_tclToken::EN_MSG_STORMTRACKDATAUPREG:
         poRetType = OSAL_NEW sxm_sms_weatherfi_tclMsgStormTrackDataUpReg;
         break;
      case sxm_sms_weatherfi_tclToken::EN_MSG_STORMTRACKDATASTATUS:
         poRetType = OSAL_NEW sxm_sms_weatherfi_tclMsgStormTrackDataStatus;
         break;
      case sxm_sms_weatherfi_tclToken::EN_MSG_STORMTRACKDATARELUPREG:
         poRetType = OSAL_NEW sxm_sms_weatherfi_tclMsgStormTrackDataRelUpReg;
         break;
      case sxm_sms_weatherfi_tclToken::EN_MSG_STORMTRACKDATAGET:
         poRetType = OSAL_NEW sxm_sms_weatherfi_tclMsgStormTrackDataGet;
         break;
      case sxm_sms_weatherfi_tclToken::EN_MSG_STORMATTRIBUTESDATAUPREG:
         poRetType = OSAL_NEW sxm_sms_weatherfi_tclMsgStormAttributesDataUpReg;
         break;
      case sxm_sms_weatherfi_tclToken::EN_MSG_STORMATTRIBUTESDATASTATUS:
         poRetType = OSAL_NEW sxm_sms_weatherfi_tclMsgStormAttributesDataStatus;
         break;
      case sxm_sms_weatherfi_tclToken::EN_MSG_STORMATTRIBUTESDATARELUPREG:
         poRetType = OSAL_NEW sxm_sms_weatherfi_tclMsgStormAttributesDataRelUpReg;
         break;
      case sxm_sms_weatherfi_tclToken::EN_MSG_STORMATTRIBUTESDATAGET:
         poRetType = OSAL_NEW sxm_sms_weatherfi_tclMsgStormAttributesDataGet;
         break;
      case sxm_sms_weatherfi_tclToken::EN_MSG_RELEASEACCESSFROMSHAREDMEMORYMETHODSTART:
         poRetType = OSAL_NEW sxm_sms_weatherfi_tclMsgReleaseAccessFromSharedMemoryMethodStart;
         break;
      case sxm_sms_weatherfi_tclToken::EN_MSG_RELEASEACCESSFROMSHAREDMEMORYMETHODRESULT:
         poRetType = OSAL_NEW sxm_sms_weatherfi_tclMsgReleaseAccessFromSharedMemoryMethodResult;
         break;
      case sxm_sms_weatherfi_tclToken::EN_MSG_NOWRADDATAUPREG:
         poRetType = OSAL_NEW sxm_sms_weatherfi_tclMsgNowradDataUpReg;
         break;
      case sxm_sms_weatherfi_tclToken::EN_MSG_NOWRADDATASTATUS:
         poRetType = OSAL_NEW sxm_sms_weatherfi_tclMsgNowradDataStatus;
         break;
      case sxm_sms_weatherfi_tclToken::EN_MSG_NOWRADDATARELUPREG:
         poRetType = OSAL_NEW sxm_sms_weatherfi_tclMsgNowradDataRelUpReg;
         break;
      case sxm_sms_weatherfi_tclToken::EN_MSG_NOWRADDATAGET:
         poRetType = OSAL_NEW sxm_sms_weatherfi_tclMsgNowradDataGet;
         break;
      case sxm_sms_weatherfi_tclToken::EN_MSG_GETSURFACEDATAMETHODSTART:
         poRetType = OSAL_NEW sxm_sms_weatherfi_tclMsgGetSurfaceDataMethodStart;
         break;
      case sxm_sms_weatherfi_tclToken::EN_MSG_GETSURFACEDATAMETHODRESULT:
         poRetType = OSAL_NEW sxm_sms_weatherfi_tclMsgGetSurfaceDataMethodResult;
         break;
      case sxm_sms_weatherfi_tclToken::EN_MSG_GETSTORMTRACKDATAMETHODSTART:
         poRetType = OSAL_NEW sxm_sms_weatherfi_tclMsgGetStormTrackDataMethodStart;
         break;
      case sxm_sms_weatherfi_tclToken::EN_MSG_GETSTORMTRACKDATAMETHODRESULT:
         poRetType = OSAL_NEW sxm_sms_weatherfi_tclMsgGetStormTrackDataMethodResult;
         break;
      case sxm_sms_weatherfi_tclToken::EN_MSG_GETSTORMATTRIBUTESDATAMETHODSTART:
         poRetType = OSAL_NEW sxm_sms_weatherfi_tclMsgGetStormAttributesDataMethodStart;
         break;
      case sxm_sms_weatherfi_tclToken::EN_MSG_GETSTORMATTRIBUTESDATAMETHODRESULT:
         poRetType = OSAL_NEW sxm_sms_weatherfi_tclMsgGetStormAttributesDataMethodResult;
         break;
      case sxm_sms_weatherfi_tclToken::EN_MSG_EXCHANGECAPABILITIESMETHODSTART:
         poRetType = OSAL_NEW sxm_sms_weatherfi_tclMsgExchangeCapabilitiesMethodStart;
         break;
      case sxm_sms_weatherfi_tclToken::EN_MSG_EXCHANGECAPABILITIESMETHODRESULT:
         poRetType = OSAL_NEW sxm_sms_weatherfi_tclMsgExchangeCapabilitiesMethodResult;
         break;
      case sxm_sms_weatherfi_tclToken::EN_MSG_ACQUIREACCESSTOSHAREDMEMORYMETHODSTART:
         poRetType = OSAL_NEW sxm_sms_weatherfi_tclMsgAcquireAccessToSharedMemoryMethodStart;
         break;
      case sxm_sms_weatherfi_tclToken::EN_MSG_ACQUIREACCESSTOSHAREDMEMORYMETHODRESULT:
         poRetType = OSAL_NEW sxm_sms_weatherfi_tclMsgAcquireAccessToSharedMemoryMethodResult;
         break;
      default: 
         poRetType = OSAL_NULL;
      }
      break;
   case TEAFI_C_U16_SERVICE_ID:
      switch ((u16FunctionId << 16) + (u8Opcode << 8))
      {
      case teafi_tclToken::EN_MSG_TEAHORIZONSTATEUPREG:
         poRetType = OSAL_NEW teafi_tclMsgTEAHorizonStateUpReg;
         break;
      case teafi_tclToken::EN_MSG_TEAHORIZONSTATESTATUS:
         poRetType = OSAL_NEW teafi_tclMsgTEAHorizonStateStatus;
         break;
      case teafi_tclToken::EN_MSG_TEAHORIZONSTATERELUPREG:
         poRetType = OSAL_NEW teafi_tclMsgTEAHorizonStateRelUpReg;
         break;
      case teafi_tclToken::EN_MSG_TEAHORIZONSTATEGET:
         poRetType = OSAL_NEW teafi_tclMsgTEAHorizonStateGet;
         break;
      case teafi_tclToken::EN_MSG_TEAHORIZONUPREG:
         poRetType = OSAL_NEW teafi_tclMsgTEAHorizonUpReg;
         break;
      case teafi_tclToken::EN_MSG_TEAHORIZONSTATUS:
         poRetType = OSAL_NEW teafi_tclMsgTEAHorizonStatus;
         break;
      case teafi_tclToken::EN_MSG_TEAHORIZONRELUPREG:
         poRetType = OSAL_NEW teafi_tclMsgTEAHorizonRelUpReg;
         break;
      case teafi_tclToken::EN_MSG_TEAHORIZONGET:
         poRetType = OSAL_NEW teafi_tclMsgTEAHorizonGet;
         break;
      case teafi_tclToken::EN_MSG_MOSTPROBABLETEAPATHUPREG:
         poRetType = OSAL_NEW teafi_tclMsgMostProbableTEAPathUpReg;
         break;
      case teafi_tclToken::EN_MSG_MOSTPROBABLETEAPATHSTATUS:
         poRetType = OSAL_NEW teafi_tclMsgMostProbableTEAPathStatus;
         break;
      case teafi_tclToken::EN_MSG_MOSTPROBABLETEAPATHRELUPREG:
         poRetType = OSAL_NEW teafi_tclMsgMostProbableTEAPathRelUpReg;
         break;
      case teafi_tclToken::EN_MSG_MOSTPROBABLETEAPATHGET:
         poRetType = OSAL_NEW teafi_tclMsgMostProbableTEAPathGet;
         break;
      case teafi_tclToken::EN_MSG_GETUPOISMETHODSTART:
         poRetType = OSAL_NEW teafi_tclMsgGetUPOIsMethodStart;
         break;
      case teafi_tclToken::EN_MSG_GETUPOISMETHODRESULT:
         poRetType = OSAL_NEW teafi_tclMsgGetUPOIsMethodResult;
         break;
      case teafi_tclToken::EN_MSG_GETTEAHORIZONMETHODSTART:
         poRetType = OSAL_NEW teafi_tclMsgGetTEAHorizonMethodStart;
         break;
      case teafi_tclToken::EN_MSG_GETTEAHORIZONMETHODRESULT:
         poRetType = OSAL_NEW teafi_tclMsgGetTEAHorizonMethodResult;
         break;
      case teafi_tclToken::EN_MSG_ENGINEERINGTEXTUPREG:
         poRetType = OSAL_NEW teafi_tclMsgEngineeringTextUpReg;
         break;
      case teafi_tclToken::EN_MSG_ENGINEERINGTEXTSTATUS:
         poRetType = OSAL_NEW teafi_tclMsgEngineeringTextStatus;
         break;
      case teafi_tclToken::EN_MSG_ENGINEERINGTEXTRELUPREG:
         poRetType = OSAL_NEW teafi_tclMsgEngineeringTextRelUpReg;
         break;
      case teafi_tclToken::EN_MSG_ENGINEERINGTEXTGET:
         poRetType = OSAL_NEW teafi_tclMsgEngineeringTextGet;
         break;
      default: 
         poRetType = OSAL_NULL;
      }
      break;
   case TMCTUNERFI_C_U16_SERVICE_ID:
      switch ((u16FunctionId << 16) + (u8Opcode << 8))
      {
      case tmctunerfi_tclToken::EN_MSG_TUNERSTATEANDMODEUPREG:
         poRetType = OSAL_NEW tmctunerfi_tclMsgTunerStateAndModeUpReg;
         break;
      case tmctunerfi_tclToken::EN_MSG_TUNERSTATEANDMODESTATUS:
         poRetType = OSAL_NEW tmctunerfi_tclMsgTunerStateAndModeStatus;
         break;
      case tmctunerfi_tclToken::EN_MSG_TUNERSTATEANDMODERELUPREG:
         poRetType = OSAL_NEW tmctunerfi_tclMsgTunerStateAndModeRelUpReg;
         break;
      case tmctunerfi_tclToken::EN_MSG_TUNERSTATEANDMODEGET:
         poRetType = OSAL_NEW tmctunerfi_tclMsgTunerStateAndModeGet;
         break;
      case tmctunerfi_tclToken::EN_MSG_TUNERMODEUPREG:
         poRetType = OSAL_NEW tmctunerfi_tclMsgTunerModeUpReg;
         break;
      case tmctunerfi_tclToken::EN_MSG_TUNERMODESTATUS:
         poRetType = OSAL_NEW tmctunerfi_tclMsgTunerModeStatus;
         break;
      case tmctunerfi_tclToken::EN_MSG_TUNERMODERELUPREG:
         poRetType = OSAL_NEW tmctunerfi_tclMsgTunerModeRelUpReg;
         break;
      case tmctunerfi_tclToken::EN_MSG_TUNERMODEGET:
         poRetType = OSAL_NEW tmctunerfi_tclMsgTunerModeGet;
         break;
      case tmctunerfi_tclToken::EN_MSG_TPEGDATAUPREG:
         poRetType = OSAL_NEW tmctunerfi_tclMsgTpegDataUpReg;
         break;
      case tmctunerfi_tclToken::EN_MSG_TPEGDATASTATUS:
         poRetType = OSAL_NEW tmctunerfi_tclMsgTpegDataStatus;
         break;
      case tmctunerfi_tclToken::EN_MSG_TPEGDATARELUPREG:
         poRetType = OSAL_NEW tmctunerfi_tclMsgTpegDataRelUpReg;
         break;
      case tmctunerfi_tclToken::EN_MSG_TPEGDATAGET:
         poRetType = OSAL_NEW tmctunerfi_tclMsgTpegDataGet;
         break;
      case tmctunerfi_tclToken::EN_MSG_TMCDATAUPREG:
         poRetType = OSAL_NEW tmctunerfi_tclMsgTmcDataUpReg;
         break;
      case tmctunerfi_tclToken::EN_MSG_TMCDATASTATUS:
         poRetType = OSAL_NEW tmctunerfi_tclMsgTmcDataStatus;
         break;
      case tmctunerfi_tclToken::EN_MSG_TMCDATARELUPREG:
         poRetType = OSAL_NEW tmctunerfi_tclMsgTmcDataRelUpReg;
         break;
      case tmctunerfi_tclToken::EN_MSG_TMCDATAGET:
         poRetType = OSAL_NEW tmctunerfi_tclMsgTmcDataGet;
         break;
      case tmctunerfi_tclToken::EN_MSG_SWITCHONOFFMETHODSTART:
         poRetType = OSAL_NEW tmctunerfi_tclMsgSwitchOnOffMethodStart;
         break;
      case tmctunerfi_tclToken::EN_MSG_SWITCHONOFFMETHODRESULT:
         poRetType = OSAL_NEW tmctunerfi_tclMsgSwitchOnOffMethodResult;
         break;
      case tmctunerfi_tclToken::EN_MSG_SETRDBIDWISHLISTMETHODSTART:
         poRetType = OSAL_NEW tmctunerfi_tclMsgSetRdbIdWishListMethodStart;
         break;
      case tmctunerfi_tclToken::EN_MSG_SETRDBIDWISHLISTMETHODRESULT:
         poRetType = OSAL_NEW tmctunerfi_tclMsgSetRdbIdWishListMethodResult;
         break;
      case tmctunerfi_tclToken::EN_MSG_RDBIDACTUALLISTUPREG:
         poRetType = OSAL_NEW tmctunerfi_tclMsgRdbIdActualListUpReg;
         break;
      case tmctunerfi_tclToken::EN_MSG_RDBIDACTUALLISTSTATUS:
         poRetType = OSAL_NEW tmctunerfi_tclMsgRdbIdActualListStatus;
         break;
      case tmctunerfi_tclToken::EN_MSG_RDBIDACTUALLISTRELUPREG:
         poRetType = OSAL_NEW tmctunerfi_tclMsgRdbIdActualListRelUpReg;
         break;
      case tmctunerfi_tclToken::EN_MSG_RDBIDACTUALLISTGET:
         poRetType = OSAL_NEW tmctunerfi_tclMsgRdbIdActualListGet;
         break;
      case tmctunerfi_tclToken::EN_MSG_OPERATIONMODEUPREG:
         poRetType = OSAL_NEW tmctunerfi_tclMsgOperationModeUpReg;
         break;
      case tmctunerfi_tclToken::EN_MSG_OPERATIONMODESTATUS:
         poRetType = OSAL_NEW tmctunerfi_tclMsgOperationModeStatus;
         break;
      case tmctunerfi_tclToken::EN_MSG_OPERATIONMODERELUPREG:
         poRetType = OSAL_NEW tmctunerfi_tclMsgOperationModeRelUpReg;
         break;
      case tmctunerfi_tclToken::EN_MSG_OPERATIONMODEGET:
         poRetType = OSAL_NEW tmctunerfi_tclMsgOperationModeGet;
         break;
      case tmctunerfi_tclToken::EN_MSG_EXCHANGETMCCAPABILITIESMETHODSTART:
         poRetType = OSAL_NEW tmctunerfi_tclMsgExchangeTmcCapabilitiesMethodStart;
         break;
      case tmctunerfi_tclToken::EN_MSG_EXCHANGETMCCAPABILITIESMETHODRESULT:
         poRetType = OSAL_NEW tmctunerfi_tclMsgExchangeTmcCapabilitiesMethodResult;
         break;
      case tmctunerfi_tclToken::EN_MSG_EXCHANGECAPABILITIESMETHODSTART:
         poRetType = OSAL_NEW tmctunerfi_tclMsgExchangeCapabilitiesMethodStart;
         break;
      case tmctunerfi_tclToken::EN_MSG_EXCHANGECAPABILITIESMETHODRESULT:
         poRetType = OSAL_NEW tmctunerfi_tclMsgExchangeCapabilitiesMethodResult;
         break;
      case tmctunerfi_tclToken::EN_MSG_CURRENTUSERSELECTEDTMCSTATIONUPREG:
         poRetType = OSAL_NEW tmctunerfi_tclMsgCurrentUserSelectedTmcStationUpReg;
         break;
      case tmctunerfi_tclToken::EN_MSG_CURRENTUSERSELECTEDTMCSTATIONSTATUS:
         poRetType = OSAL_NEW tmctunerfi_tclMsgCurrentUserSelectedTmcStationStatus;
         break;
      case tmctunerfi_tclToken::EN_MSG_CURRENTUSERSELECTEDTMCSTATIONRELUPREG:
         poRetType = OSAL_NEW tmctunerfi_tclMsgCurrentUserSelectedTmcStationRelUpReg;
         break;
      case tmctunerfi_tclToken::EN_MSG_CURRENTUSERSELECTEDTMCSTATIONGET:
         poRetType = OSAL_NEW tmctunerfi_tclMsgCurrentUserSelectedTmcStationGet;
         break;
      default: 
         poRetType = OSAL_NULL;
      }
      break;
   case TMDATAFI_C_U16_SERVICE_ID:
      switch ((u16FunctionId << 16) + (u8Opcode << 8))
      {
      case tmdatafi_tclToken::EN_MSG_NAVTIMA_TRAFFICMSGMEMORYSTATISTICSUPREG:
         poRetType = OSAL_NEW tmdatafi_tclMsgNavTima_TrafficMsgMemoryStatisticsUpReg;
         break;
      case tmdatafi_tclToken::EN_MSG_NAVTIMA_TRAFFICMSGMEMORYSTATISTICSSTATUS:
         poRetType = OSAL_NEW tmdatafi_tclMsgNavTima_TrafficMsgMemoryStatisticsStatus;
         break;
      case tmdatafi_tclToken::EN_MSG_NAVTIMA_TRAFFICMSGMEMORYSTATISTICSRELUPREG:
         poRetType = OSAL_NEW tmdatafi_tclMsgNavTima_TrafficMsgMemoryStatisticsRelUpReg;
         break;
      case tmdatafi_tclToken::EN_MSG_NAVTIMA_TMCMESSAGECHANGEDUPREG:
         poRetType = OSAL_NEW tmdatafi_tclMsgNavTima_TmcMessageChangedUpReg;
         break;
      case tmdatafi_tclToken::EN_MSG_NAVTIMA_TMCMESSAGECHANGEDSTATUS:
         poRetType = OSAL_NEW tmdatafi_tclMsgNavTima_TmcMessageChangedStatus;
         break;
      case tmdatafi_tclToken::EN_MSG_NAVTIMA_TMCMESSAGECHANGEDRELUPREG:
         poRetType = OSAL_NEW tmdatafi_tclMsgNavTima_TmcMessageChangedRelUpReg;
         break;
      case tmdatafi_tclToken::EN_MSG_NAVTIMA_SWITCHRELFILTERMETHODSTART:
         poRetType = OSAL_NEW tmdatafi_tclMsgNavTima_SwitchRelFilterMethodStart;
         break;
      case tmdatafi_tclToken::EN_MSG_NAVTIMA_SWITCHRELFILTERMETHODRESULT:
         poRetType = OSAL_NEW tmdatafi_tclMsgNavTima_SwitchRelFilterMethodResult;
         break;
      case tmdatafi_tclToken::EN_MSG_NAVTIMA_SWITCHABSFILTERMETHODSTART:
         poRetType = OSAL_NEW tmdatafi_tclMsgNavTima_SwitchAbsFilterMethodStart;
         break;
      case tmdatafi_tclToken::EN_MSG_NAVTIMA_SWITCHABSFILTERMETHODRESULT:
         poRetType = OSAL_NEW tmdatafi_tclMsgNavTima_SwitchAbsFilterMethodResult;
         break;
      case tmdatafi_tclToken::EN_MSG_NAVTIMA_STATUSUPREG:
         poRetType = OSAL_NEW tmdatafi_tclMsgNavTima_StatusUpReg;
         break;
      case tmdatafi_tclToken::EN_MSG_NAVTIMA_STATUSSTATUS:
         poRetType = OSAL_NEW tmdatafi_tclMsgNavTima_StatusStatus;
         break;
      case tmdatafi_tclToken::EN_MSG_NAVTIMA_STATUSRELUPREG:
         poRetType = OSAL_NEW tmdatafi_tclMsgNavTima_StatusRelUpReg;
         break;
      case tmdatafi_tclToken::EN_MSG_NAVTIMA_STATUSGET:
         poRetType = OSAL_NEW tmdatafi_tclMsgNavTima_StatusGet;
         break;
      case tmdatafi_tclToken::EN_MSG_NAVTIMA_SETRELFILTERMETHODSTART:
         poRetType = OSAL_NEW tmdatafi_tclMsgNavTima_SetRelFilterMethodStart;
         break;
      case tmdatafi_tclToken::EN_MSG_NAVTIMA_SETRELFILTERMETHODRESULT:
         poRetType = OSAL_NEW tmdatafi_tclMsgNavTima_SetRelFilterMethodResult;
         break;
      case tmdatafi_tclToken::EN_MSG_NAVTIMA_SETABSFILTERMETHODSTART:
         poRetType = OSAL_NEW tmdatafi_tclMsgNavTima_SetAbsFilterMethodStart;
         break;
      case tmdatafi_tclToken::EN_MSG_NAVTIMA_SETABSFILTERMETHODRESULT:
         poRetType = OSAL_NEW tmdatafi_tclMsgNavTima_SetAbsFilterMethodResult;
         break;
      case tmdatafi_tclToken::EN_MSG_NAVTIMA_RESETMETHODSTART:
         poRetType = OSAL_NEW tmdatafi_tclMsgNavTima_ResetMethodStart;
         break;
      case tmdatafi_tclToken::EN_MSG_NAVTIMA_RESETMETHODRESULT:
         poRetType = OSAL_NEW tmdatafi_tclMsgNavTima_ResetMethodResult;
         break;
      case tmdatafi_tclToken::EN_MSG_NAVTIMA_RDBIDNOTIFICATIONUPREG:
         poRetType = OSAL_NEW tmdatafi_tclMsgNavTima_RdbIdNotificationUpReg;
         break;
      case tmdatafi_tclToken::EN_MSG_NAVTIMA_RDBIDNOTIFICATIONSTATUS:
         poRetType = OSAL_NEW tmdatafi_tclMsgNavTima_RdbIdNotificationStatus;
         break;
      case tmdatafi_tclToken::EN_MSG_NAVTIMA_RDBIDNOTIFICATIONRELUPREG:
         poRetType = OSAL_NEW tmdatafi_tclMsgNavTima_RdbIdNotificationRelUpReg;
         break;
      case tmdatafi_tclToken::EN_MSG_NAVTIMA_RDBIDHANDLINGMETHODSTART:
         poRetType = OSAL_NEW tmdatafi_tclMsgNavTima_RdbIdHandlingMethodStart;
         break;
      case tmdatafi_tclToken::EN_MSG_NAVTIMA_RDBIDHANDLINGMETHODRESULT:
         poRetType = OSAL_NEW tmdatafi_tclMsgNavTima_RdbIdHandlingMethodResult;
         break;
      case tmdatafi_tclToken::EN_MSG_NAVTIMA_MESSAGEMEMORYMETHODSTART:
         poRetType = OSAL_NEW tmdatafi_tclMsgNavTima_MessageMemoryMethodStart;
         break;
      case tmdatafi_tclToken::EN_MSG_NAVTIMA_MESSAGEMEMORYMETHODRESULT:
         poRetType = OSAL_NEW tmdatafi_tclMsgNavTima_MessageMemoryMethodResult;
         break;
      case tmdatafi_tclToken::EN_MSG_NAVTIMA_EXPIREDTMCMESSAGELISTUPREG:
         poRetType = OSAL_NEW tmdatafi_tclMsgNavTima_ExpiredTmcMessageListUpReg;
         break;
      case tmdatafi_tclToken::EN_MSG_NAVTIMA_EXPIREDTMCMESSAGELISTSTATUS:
         poRetType = OSAL_NEW tmdatafi_tclMsgNavTima_ExpiredTmcMessageListStatus;
         break;
      case tmdatafi_tclToken::EN_MSG_NAVTIMA_EXPIREDTMCMESSAGELISTRELUPREG:
         poRetType = OSAL_NEW tmdatafi_tclMsgNavTima_ExpiredTmcMessageListRelUpReg;
         break;
      case tmdatafi_tclToken::EN_MSG_NAVTIMA_CURRENTRDBIDAVAILABILITYUPREG:
         poRetType = OSAL_NEW tmdatafi_tclMsgNavTima_CurrentRdbIdAvailabilityUpReg;
         break;
      case tmdatafi_tclToken::EN_MSG_NAVTIMA_CURRENTRDBIDAVAILABILITYSTATUS:
         poRetType = OSAL_NEW tmdatafi_tclMsgNavTima_CurrentRdbIdAvailabilityStatus;
         break;
      case tmdatafi_tclToken::EN_MSG_NAVTIMA_CURRENTRDBIDAVAILABILITYRELUPREG:
         poRetType = OSAL_NEW tmdatafi_tclMsgNavTima_CurrentRdbIdAvailabilityRelUpReg;
         break;
      default: 
         poRetType = OSAL_NULL;
      }
      break;
   case TMPRESFI_C_U16_SERVICE_ID:
      switch ((u16FunctionId << 16) + (u8Opcode << 8))
      {
      case tmpresfi_tclToken::EN_MSG_TRANSLATEEXTENDEDMESSAGEMETHODSTART:
         poRetType = OSAL_NEW tmpresfi_tclMsgTranslateExtendedMessageMethodStart;
         break;
      case tmpresfi_tclToken::EN_MSG_TRANSLATEEXTENDEDMESSAGEMETHODRESULT:
         poRetType = OSAL_NEW tmpresfi_tclMsgTranslateExtendedMessageMethodResult;
         break;
      case tmpresfi_tclToken::EN_MSG_TRAFFICSOURCESTATUS:
         poRetType = OSAL_NEW tmpresfi_tclMsgTrafficSourceStatus;
         break;
      case tmpresfi_tclToken::EN_MSG_TRAFFICSOURCEGET:
         poRetType = OSAL_NEW tmpresfi_tclMsgTrafficSourceGet;
         break;
      case tmpresfi_tclToken::EN_MSG_TRAFFICINFOSOURCEMETHODSTART:
         poRetType = OSAL_NEW tmpresfi_tclMsgTrafficInfoSourceMethodStart;
         break;
      case tmpresfi_tclToken::EN_MSG_TRAFFICINFOSOURCEMETHODRESULT:
         poRetType = OSAL_NEW tmpresfi_tclMsgTrafficInfoSourceMethodResult;
         break;
      case tmpresfi_tclToken::EN_MSG_ENGINEERINGTEXTUPREG:
         poRetType = OSAL_NEW tmpresfi_tclMsgEngineeringTextUpReg;
         break;
      case tmpresfi_tclToken::EN_MSG_ENGINEERINGTEXTSTATUS:
         poRetType = OSAL_NEW tmpresfi_tclMsgEngineeringTextStatus;
         break;
      case tmpresfi_tclToken::EN_MSG_ENGINEERINGTEXTRELUPREG:
         poRetType = OSAL_NEW tmpresfi_tclMsgEngineeringTextRelUpReg;
         break;
      case tmpresfi_tclToken::EN_MSG_ENGINEERINGTEXTGET:
         poRetType = OSAL_NEW tmpresfi_tclMsgEngineeringTextGet;
         break;
      case tmpresfi_tclToken::EN_MSG_AVAILABLELANGUAGESSTATUS:
         poRetType = OSAL_NEW tmpresfi_tclMsgAvailableLanguagesStatus;
         break;
      case tmpresfi_tclToken::EN_MSG_AVAILABLELANGUAGESGET:
         poRetType = OSAL_NEW tmpresfi_tclMsgAvailableLanguagesGet;
         break;
      default: 
         poRetType = OSAL_NULL;
      }
      break;
   case VEHICLECFGFI_C_U16_SERVICE_ID:
      switch ((u16FunctionId << 16) + (u8Opcode << 8))
      {
      case vehiclecfgfi_tclToken::EN_MSG_VEHICLECONFIGURATIONUPREG:
         poRetType = OSAL_NEW vehiclecfgfi_tclMsgVehicleConfigurationUpReg;
         break;
      case vehiclecfgfi_tclToken::EN_MSG_VEHICLECONFIGURATIONSTATUS:
         poRetType = OSAL_NEW vehiclecfgfi_tclMsgVehicleConfigurationStatus;
         break;
      case vehiclecfgfi_tclToken::EN_MSG_VEHICLECONFIGURATIONRELUPREG:
         poRetType = OSAL_NEW vehiclecfgfi_tclMsgVehicleConfigurationRelUpReg;
         break;
      case vehiclecfgfi_tclToken::EN_MSG_VEHICLECONFIGURATIONGET:
         poRetType = OSAL_NEW vehiclecfgfi_tclMsgVehicleConfigurationGet;
         break;
      default: 
         poRetType = OSAL_NULL;
      }
      break;
   case WEATHERFI_C_U16_SERVICE_ID:
      switch ((u16FunctionId << 16) + (u8Opcode << 8))
      {
      case weatherfi_tclToken::EN_MSG_WINDSTATICPICTUREDATAUPREG:
         poRetType = OSAL_NEW weatherfi_tclMsgWindStaticPictureDataUpReg;
         break;
      case weatherfi_tclToken::EN_MSG_WINDSTATICPICTUREDATASTATUS:
         poRetType = OSAL_NEW weatherfi_tclMsgWindStaticPictureDataStatus;
         break;
      case weatherfi_tclToken::EN_MSG_WINDSTATICPICTUREDATARELUPREG:
         poRetType = OSAL_NEW weatherfi_tclMsgWindStaticPictureDataRelUpReg;
         break;
      case weatherfi_tclToken::EN_MSG_WINDSTATICPICTUREDATAGET:
         poRetType = OSAL_NEW weatherfi_tclMsgWindStaticPictureDataGet;
         break;
      case weatherfi_tclToken::EN_MSG_WEATHERFORECASTDATACHANGEDUPREG:
         poRetType = OSAL_NEW weatherfi_tclMsgWeatherForecastDataChangedUpReg;
         break;
      case weatherfi_tclToken::EN_MSG_WEATHERFORECASTDATACHANGEDSTATUS:
         poRetType = OSAL_NEW weatherfi_tclMsgWeatherForecastDataChangedStatus;
         break;
      case weatherfi_tclToken::EN_MSG_WEATHERFORECASTDATACHANGEDRELUPREG:
         poRetType = OSAL_NEW weatherfi_tclMsgWeatherForecastDataChangedRelUpReg;
         break;
      case weatherfi_tclToken::EN_MSG_WEATHERFORECASTDATACHANGEDGET:
         poRetType = OSAL_NEW weatherfi_tclMsgWeatherForecastDataChangedGet;
         break;
      case weatherfi_tclToken::EN_MSG_WEATHERALERTDATAUPREG:
         poRetType = OSAL_NEW weatherfi_tclMsgWeatherAlertDataUpReg;
         break;
      case weatherfi_tclToken::EN_MSG_WEATHERALERTDATASTATUS:
         poRetType = OSAL_NEW weatherfi_tclMsgWeatherAlertDataStatus;
         break;
      case weatherfi_tclToken::EN_MSG_WEATHERALERTDATARELUPREG:
         poRetType = OSAL_NEW weatherfi_tclMsgWeatherAlertDataRelUpReg;
         break;
      case weatherfi_tclToken::EN_MSG_WEATHERALERTDATAGET:
         poRetType = OSAL_NEW weatherfi_tclMsgWeatherAlertDataGet;
         break;
      case weatherfi_tclToken::EN_MSG_TABULARWEATHERSKICONDITIONDATAUPREG:
         poRetType = OSAL_NEW weatherfi_tclMsgTabularWeatherSkiConditionDataUpReg;
         break;
      case weatherfi_tclToken::EN_MSG_TABULARWEATHERSKICONDITIONDATASTATUS:
         poRetType = OSAL_NEW weatherfi_tclMsgTabularWeatherSkiConditionDataStatus;
         break;
      case weatherfi_tclToken::EN_MSG_TABULARWEATHERSKICONDITIONDATARELUPREG:
         poRetType = OSAL_NEW weatherfi_tclMsgTabularWeatherSkiConditionDataRelUpReg;
         break;
      case weatherfi_tclToken::EN_MSG_TABULARWEATHERSKICONDITIONDATAGET:
         poRetType = OSAL_NEW weatherfi_tclMsgTabularWeatherSkiConditionDataGet;
         break;
      case weatherfi_tclToken::EN_MSG_TABULARWEATHERDATAUPREG:
         poRetType = OSAL_NEW weatherfi_tclMsgTabularWeatherDataUpReg;
         break;
      case weatherfi_tclToken::EN_MSG_TABULARWEATHERDATASTATUS:
         poRetType = OSAL_NEW weatherfi_tclMsgTabularWeatherDataStatus;
         break;
      case weatherfi_tclToken::EN_MSG_TABULARWEATHERDATARELUPREG:
         poRetType = OSAL_NEW weatherfi_tclMsgTabularWeatherDataRelUpReg;
         break;
      case weatherfi_tclToken::EN_MSG_TABULARWEATHERDATAGET:
         poRetType = OSAL_NEW weatherfi_tclMsgTabularWeatherDataGet;
         break;
      case weatherfi_tclToken::EN_MSG_SURFACEDATAUPREG:
         poRetType = OSAL_NEW weatherfi_tclMsgSurfaceDataUpReg;
         break;
      case weatherfi_tclToken::EN_MSG_SURFACEDATASTATUS:
         poRetType = OSAL_NEW weatherfi_tclMsgSurfaceDataStatus;
         break;
      case weatherfi_tclToken::EN_MSG_SURFACEDATARELUPREG:
         poRetType = OSAL_NEW weatherfi_tclMsgSurfaceDataRelUpReg;
         break;
      case weatherfi_tclToken::EN_MSG_SURFACEDATAGET:
         poRetType = OSAL_NEW weatherfi_tclMsgSurfaceDataGet;
         break;
      case weatherfi_tclToken::EN_MSG_STORMTRACKDATAUPREG:
         poRetType = OSAL_NEW weatherfi_tclMsgStormTrackDataUpReg;
         break;
      case weatherfi_tclToken::EN_MSG_STORMTRACKDATASTATUS:
         poRetType = OSAL_NEW weatherfi_tclMsgStormTrackDataStatus;
         break;
      case weatherfi_tclToken::EN_MSG_STORMTRACKDATARELUPREG:
         poRetType = OSAL_NEW weatherfi_tclMsgStormTrackDataRelUpReg;
         break;
      case weatherfi_tclToken::EN_MSG_STORMTRACKDATAGET:
         poRetType = OSAL_NEW weatherfi_tclMsgStormTrackDataGet;
         break;
      case weatherfi_tclToken::EN_MSG_STORMATTRIBUTESDATAUPREG:
         poRetType = OSAL_NEW weatherfi_tclMsgStormAttributesDataUpReg;
         break;
      case weatherfi_tclToken::EN_MSG_STORMATTRIBUTESDATASTATUS:
         poRetType = OSAL_NEW weatherfi_tclMsgStormAttributesDataStatus;
         break;
      case weatherfi_tclToken::EN_MSG_STORMATTRIBUTESDATARELUPREG:
         poRetType = OSAL_NEW weatherfi_tclMsgStormAttributesDataRelUpReg;
         break;
      case weatherfi_tclToken::EN_MSG_STORMATTRIBUTESDATAGET:
         poRetType = OSAL_NEW weatherfi_tclMsgStormAttributesDataGet;
         break;
      case weatherfi_tclToken::EN_MSG_RASTERTILESHAREDMEMORIESUPREG:
         poRetType = OSAL_NEW weatherfi_tclMsgRasterTileSharedMemoriesUpReg;
         break;
      case weatherfi_tclToken::EN_MSG_RASTERTILESHAREDMEMORIESSTATUS:
         poRetType = OSAL_NEW weatherfi_tclMsgRasterTileSharedMemoriesStatus;
         break;
      case weatherfi_tclToken::EN_MSG_RASTERTILESHAREDMEMORIESRELUPREG:
         poRetType = OSAL_NEW weatherfi_tclMsgRasterTileSharedMemoriesRelUpReg;
         break;
      case weatherfi_tclToken::EN_MSG_RASTERTILESHAREDMEMORIESGET:
         poRetType = OSAL_NEW weatherfi_tclMsgRasterTileSharedMemoriesGet;
         break;
      case weatherfi_tclToken::EN_MSG_RADARSTATICPICTUREDATAUPREG:
         poRetType = OSAL_NEW weatherfi_tclMsgRadarStaticPictureDataUpReg;
         break;
      case weatherfi_tclToken::EN_MSG_RADARSTATICPICTUREDATASTATUS:
         poRetType = OSAL_NEW weatherfi_tclMsgRadarStaticPictureDataStatus;
         break;
      case weatherfi_tclToken::EN_MSG_RADARSTATICPICTUREDATARELUPREG:
         poRetType = OSAL_NEW weatherfi_tclMsgRadarStaticPictureDataRelUpReg;
         break;
      case weatherfi_tclToken::EN_MSG_RADARSTATICPICTUREDATAGET:
         poRetType = OSAL_NEW weatherfi_tclMsgRadarStaticPictureDataGet;
         break;
      case weatherfi_tclToken::EN_MSG_RADARANIMATIONDATAUPREG:
         poRetType = OSAL_NEW weatherfi_tclMsgRadarAnimationDataUpReg;
         break;
      case weatherfi_tclToken::EN_MSG_RADARANIMATIONDATASTATUS:
         poRetType = OSAL_NEW weatherfi_tclMsgRadarAnimationDataStatus;
         break;
      case weatherfi_tclToken::EN_MSG_RADARANIMATIONDATARELUPREG:
         poRetType = OSAL_NEW weatherfi_tclMsgRadarAnimationDataRelUpReg;
         break;
      case weatherfi_tclToken::EN_MSG_RADARANIMATIONDATAGET:
         poRetType = OSAL_NEW weatherfi_tclMsgRadarAnimationDataGet;
         break;
      case weatherfi_tclToken::EN_MSG_GRAPHICALWEATHERTILEPICTUREDATAUPREG:
         poRetType = OSAL_NEW weatherfi_tclMsgGraphicalWeatherTilePictureDataUpReg;
         break;
      case weatherfi_tclToken::EN_MSG_GRAPHICALWEATHERTILEPICTUREDATASTATUS:
         poRetType = OSAL_NEW weatherfi_tclMsgGraphicalWeatherTilePictureDataStatus;
         break;
      case weatherfi_tclToken::EN_MSG_GRAPHICALWEATHERTILEPICTUREDATARELUPREG:
         poRetType = OSAL_NEW weatherfi_tclMsgGraphicalWeatherTilePictureDataRelUpReg;
         break;
      case weatherfi_tclToken::EN_MSG_GRAPHICALWEATHERTILEPICTUREDATAGET:
         poRetType = OSAL_NEW weatherfi_tclMsgGraphicalWeatherTilePictureDataGet;
         break;
      case weatherfi_tclToken::EN_MSG_GRAPHICALWEATHERRASTERTILESHAREDMEMORYUPREG:
         poRetType = OSAL_NEW weatherfi_tclMsgGraphicalWeatherRasterTileSharedMemoryUpReg;
         break;
      case weatherfi_tclToken::EN_MSG_GRAPHICALWEATHERRASTERTILESHAREDMEMORYSTATUS:
         poRetType = OSAL_NEW weatherfi_tclMsgGraphicalWeatherRasterTileSharedMemoryStatus;
         break;
      case weatherfi_tclToken::EN_MSG_GRAPHICALWEATHERRASTERTILESHAREDMEMORYRELUPREG:
         poRetType = OSAL_NEW weatherfi_tclMsgGraphicalWeatherRasterTileSharedMemoryRelUpReg;
         break;
      case weatherfi_tclToken::EN_MSG_GRAPHICALWEATHERRASTERTILESHAREDMEMORYGET:
         poRetType = OSAL_NEW weatherfi_tclMsgGraphicalWeatherRasterTileSharedMemoryGet;
         break;
      case weatherfi_tclToken::EN_MSG_GRAPHICALWEATHERRADARANIMATIONSHAREDMEMORYUPREG:
         poRetType = OSAL_NEW weatherfi_tclMsgGraphicalWeatherRadarAnimationSharedMemoryUpReg;
         break;
      case weatherfi_tclToken::EN_MSG_GRAPHICALWEATHERRADARANIMATIONSHAREDMEMORYSTATUS:
         poRetType = OSAL_NEW weatherfi_tclMsgGraphicalWeatherRadarAnimationSharedMemoryStatus;
         break;
      case weatherfi_tclToken::EN_MSG_GRAPHICALWEATHERRADARANIMATIONSHAREDMEMORYRELUPREG:
         poRetType = OSAL_NEW weatherfi_tclMsgGraphicalWeatherRadarAnimationSharedMemoryRelUpReg;
         break;
      case weatherfi_tclToken::EN_MSG_GRAPHICALWEATHERRADARANIMATIONSHAREDMEMORYGET:
         poRetType = OSAL_NEW weatherfi_tclMsgGraphicalWeatherRadarAnimationSharedMemoryGet;
         break;
      case weatherfi_tclToken::EN_MSG_GRAPHICALWEATHERRADARANIMATIONPICTUREDATAUPREG:
         poRetType = OSAL_NEW weatherfi_tclMsgGraphicalWeatherRadarAnimationPictureDataUpReg;
         break;
      case weatherfi_tclToken::EN_MSG_GRAPHICALWEATHERRADARANIMATIONPICTUREDATASTATUS:
         poRetType = OSAL_NEW weatherfi_tclMsgGraphicalWeatherRadarAnimationPictureDataStatus;
         break;
      case weatherfi_tclToken::EN_MSG_GRAPHICALWEATHERRADARANIMATIONPICTUREDATARELUPREG:
         poRetType = OSAL_NEW weatherfi_tclMsgGraphicalWeatherRadarAnimationPictureDataRelUpReg;
         break;
      case weatherfi_tclToken::EN_MSG_GRAPHICALWEATHERRADARANIMATIONPICTUREDATAGET:
         poRetType = OSAL_NEW weatherfi_tclMsgGraphicalWeatherRadarAnimationPictureDataGet;
         break;
      case weatherfi_tclToken::EN_MSG_GETWEATHERFORECASTDATAMETHODSTART:
         poRetType = OSAL_NEW weatherfi_tclMsgGetWeatherForecastDataMethodStart;
         break;
      case weatherfi_tclToken::EN_MSG_GETWEATHERFORECASTDATAMETHODRESULT:
         poRetType = OSAL_NEW weatherfi_tclMsgGetWeatherForecastDataMethodResult;
         break;
      case weatherfi_tclToken::EN_MSG_GETWEATHERALERTDATAMETHODSTART:
         poRetType = OSAL_NEW weatherfi_tclMsgGetWeatherAlertDataMethodStart;
         break;
      case weatherfi_tclToken::EN_MSG_GETWEATHERALERTDATAMETHODRESULT:
         poRetType = OSAL_NEW weatherfi_tclMsgGetWeatherAlertDataMethodResult;
         break;
      case weatherfi_tclToken::EN_MSG_GETTABULARWEATHERSKICONDITIONDATAMETHODSTART:
         poRetType = OSAL_NEW weatherfi_tclMsgGetTabularWeatherSkiConditionDataMethodStart;
         break;
      case weatherfi_tclToken::EN_MSG_GETTABULARWEATHERSKICONDITIONDATAMETHODRESULT:
         poRetType = OSAL_NEW weatherfi_tclMsgGetTabularWeatherSkiConditionDataMethodResult;
         break;
      case weatherfi_tclToken::EN_MSG_GETTABULARWEATHERDATAMETHODSTART:
         poRetType = OSAL_NEW weatherfi_tclMsgGetTabularWeatherDataMethodStart;
         break;
      case weatherfi_tclToken::EN_MSG_GETTABULARWEATHERDATAMETHODRESULT:
         poRetType = OSAL_NEW weatherfi_tclMsgGetTabularWeatherDataMethodResult;
         break;
      case weatherfi_tclToken::EN_MSG_GETSURFACEDATAMETHODSTART:
         poRetType = OSAL_NEW weatherfi_tclMsgGetSurfaceDataMethodStart;
         break;
      case weatherfi_tclToken::EN_MSG_GETSURFACEDATAMETHODRESULT:
         poRetType = OSAL_NEW weatherfi_tclMsgGetSurfaceDataMethodResult;
         break;
      case weatherfi_tclToken::EN_MSG_GETSTORMTRACKDATAMETHODSTART:
         poRetType = OSAL_NEW weatherfi_tclMsgGetStormTrackDataMethodStart;
         break;
      case weatherfi_tclToken::EN_MSG_GETSTORMTRACKDATAMETHODRESULT:
         poRetType = OSAL_NEW weatherfi_tclMsgGetStormTrackDataMethodResult;
         break;
      case weatherfi_tclToken::EN_MSG_GETSTORMATTRIBUTESDATAMETHODSTART:
         poRetType = OSAL_NEW weatherfi_tclMsgGetStormAttributesDataMethodStart;
         break;
      case weatherfi_tclToken::EN_MSG_GETSTORMATTRIBUTESDATAMETHODRESULT:
         poRetType = OSAL_NEW weatherfi_tclMsgGetStormAttributesDataMethodResult;
         break;
      case weatherfi_tclToken::EN_MSG_GETFORECASTFORCITYMETHODSTART:
         poRetType = OSAL_NEW weatherfi_tclMsgGetForecastForCityMethodStart;
         break;
      case weatherfi_tclToken::EN_MSG_GETFORECASTFORCITYMETHODRESULT:
         poRetType = OSAL_NEW weatherfi_tclMsgGetForecastForCityMethodResult;
         break;
      case weatherfi_tclToken::EN_MSG_GETFORECASTCITYLISTMETHODSTART:
         poRetType = OSAL_NEW weatherfi_tclMsgGetForecastCityListMethodStart;
         break;
      case weatherfi_tclToken::EN_MSG_GETFORECASTCITYLISTMETHODRESULT:
         poRetType = OSAL_NEW weatherfi_tclMsgGetForecastCityListMethodResult;
         break;
      case weatherfi_tclToken::EN_MSG_GETCURRENTWEATHERDATAMETHODSTART:
         poRetType = OSAL_NEW weatherfi_tclMsgGetCurrentWeatherDataMethodStart;
         break;
      case weatherfi_tclToken::EN_MSG_GETCURRENTWEATHERDATAMETHODRESULT:
         poRetType = OSAL_NEW weatherfi_tclMsgGetCurrentWeatherDataMethodResult;
         break;
      case weatherfi_tclToken::EN_MSG_GETCOUNTYWARNINGDATAMETHODSTART:
         poRetType = OSAL_NEW weatherfi_tclMsgGetCountyWarningDataMethodStart;
         break;
      case weatherfi_tclToken::EN_MSG_GETCOUNTYWARNINGDATAMETHODRESULT:
         poRetType = OSAL_NEW weatherfi_tclMsgGetCountyWarningDataMethodResult;
         break;
      case weatherfi_tclToken::EN_MSG_ENGINEERINGTEXTUPREG:
         poRetType = OSAL_NEW weatherfi_tclMsgEngineeringTextUpReg;
         break;
      case weatherfi_tclToken::EN_MSG_ENGINEERINGTEXTSTATUS:
         poRetType = OSAL_NEW weatherfi_tclMsgEngineeringTextStatus;
         break;
      case weatherfi_tclToken::EN_MSG_ENGINEERINGTEXTRELUPREG:
         poRetType = OSAL_NEW weatherfi_tclMsgEngineeringTextRelUpReg;
         break;
      case weatherfi_tclToken::EN_MSG_ENGINEERINGTEXTGET:
         poRetType = OSAL_NEW weatherfi_tclMsgEngineeringTextGet;
         break;
      case weatherfi_tclToken::EN_MSG_CURRENTWEATHERDATACHANGEDUPREG:
         poRetType = OSAL_NEW weatherfi_tclMsgCurrentWeatherDataChangedUpReg;
         break;
      case weatherfi_tclToken::EN_MSG_CURRENTWEATHERDATACHANGEDSTATUS:
         poRetType = OSAL_NEW weatherfi_tclMsgCurrentWeatherDataChangedStatus;
         break;
      case weatherfi_tclToken::EN_MSG_CURRENTWEATHERDATACHANGEDRELUPREG:
         poRetType = OSAL_NEW weatherfi_tclMsgCurrentWeatherDataChangedRelUpReg;
         break;
      case weatherfi_tclToken::EN_MSG_CURRENTWEATHERDATACHANGEDGET:
         poRetType = OSAL_NEW weatherfi_tclMsgCurrentWeatherDataChangedGet;
         break;
      case weatherfi_tclToken::EN_MSG_COUNTYWARNINGDATACHANGEDUPREG:
         poRetType = OSAL_NEW weatherfi_tclMsgCountyWarningDataChangedUpReg;
         break;
      case weatherfi_tclToken::EN_MSG_COUNTYWARNINGDATACHANGEDSTATUS:
         poRetType = OSAL_NEW weatherfi_tclMsgCountyWarningDataChangedStatus;
         break;
      case weatherfi_tclToken::EN_MSG_COUNTYWARNINGDATACHANGEDRELUPREG:
         poRetType = OSAL_NEW weatherfi_tclMsgCountyWarningDataChangedRelUpReg;
         break;
      case weatherfi_tclToken::EN_MSG_COUNTYWARNINGDATACHANGEDGET:
         poRetType = OSAL_NEW weatherfi_tclMsgCountyWarningDataChangedGet;
         break;
      case weatherfi_tclToken::EN_MSG_CONFIRMRASTERTILESHAREDMEMORYMETHODSTART:
         poRetType = OSAL_NEW weatherfi_tclMsgConfirmRasterTileSharedMemoryMethodStart;
         break;
      case weatherfi_tclToken::EN_MSG_CONFIRMRASTERTILESHAREDMEMORYMETHODRESULT:
         poRetType = OSAL_NEW weatherfi_tclMsgConfirmRasterTileSharedMemoryMethodResult;
         break;
      case weatherfi_tclToken::EN_MSG_CONFIRMRASTERTILEPICTURESMETHODSTART:
         poRetType = OSAL_NEW weatherfi_tclMsgConfirmRasterTilePicturesMethodStart;
         break;
      case weatherfi_tclToken::EN_MSG_CONFIRMRASTERTILEPICTURESMETHODRESULT:
         poRetType = OSAL_NEW weatherfi_tclMsgConfirmRasterTilePicturesMethodResult;
         break;
      case weatherfi_tclToken::EN_MSG_CONFIRMGRAPHICALWEATHERTILEPICTUREDATAMETHODSTART:
         poRetType = OSAL_NEW weatherfi_tclMsgConfirmGraphicalWeatherTilePictureDataMethodStart;
         break;
      case weatherfi_tclToken::EN_MSG_CONFIRMGRAPHICALWEATHERTILEPICTUREDATAMETHODRESULT:
         poRetType = OSAL_NEW weatherfi_tclMsgConfirmGraphicalWeatherTilePictureDataMethodResult;
         break;
      case weatherfi_tclToken::EN_MSG_CONFIRMGRAPHICALWEATHERRASTERTILESHAREDMEMORYMETHODSTART:
         poRetType = OSAL_NEW weatherfi_tclMsgConfirmGraphicalWeatherRasterTileSharedMemoryMethodStart;
         break;
      case weatherfi_tclToken::EN_MSG_CONFIRMGRAPHICALWEATHERRASTERTILESHAREDMEMORYMETHODRESULT:
         poRetType = OSAL_NEW weatherfi_tclMsgConfirmGraphicalWeatherRasterTileSharedMemoryMethodResult;
         break;
      default: 
         poRetType = OSAL_NULL;
      }
      break;
   case WEATHERTUNERFI_C_U16_SERVICE_ID:
      switch ((u16FunctionId << 16) + (u8Opcode << 8))
      {
      case weathertunerfi_tclToken::EN_MSG_METARDATACHANGEDUPREG:
         poRetType = OSAL_NEW weathertunerfi_tclMsgMetarDataChangedUpReg;
         break;
      case weathertunerfi_tclToken::EN_MSG_METARDATACHANGEDSTATUS:
         poRetType = OSAL_NEW weathertunerfi_tclMsgMetarDataChangedStatus;
         break;
      case weathertunerfi_tclToken::EN_MSG_METARDATACHANGEDRELUPREG:
         poRetType = OSAL_NEW weathertunerfi_tclMsgMetarDataChangedRelUpReg;
         break;
      case weathertunerfi_tclToken::EN_MSG_METARDATACHANGEDGET:
         poRetType = OSAL_NEW weathertunerfi_tclMsgMetarDataChangedGet;
         break;
      case weathertunerfi_tclToken::EN_MSG_GETMETARDATAMETHODSTART:
         poRetType = OSAL_NEW weathertunerfi_tclMsgGetMetarDataMethodStart;
         break;
      case weathertunerfi_tclToken::EN_MSG_GETMETARDATAMETHODRESULTMIDDLE:
         poRetType = OSAL_NEW weathertunerfi_tclMsgGetMetarDataMethodResultMiddle;
         break;
      case weathertunerfi_tclToken::EN_MSG_GETMETARDATAMETHODRESULTLAST:
         poRetType = OSAL_NEW weathertunerfi_tclMsgGetMetarDataMethodResultLast;
         break;
      case weathertunerfi_tclToken::EN_MSG_GETMETARDATAMETHODRESULTFIRST:
         poRetType = OSAL_NEW weathertunerfi_tclMsgGetMetarDataMethodResultFirst;
         break;
      case weathertunerfi_tclToken::EN_MSG_GETMETARDATAMETHODRESULT:
         poRetType = OSAL_NEW weathertunerfi_tclMsgGetMetarDataMethodResult;
         break;
      case weathertunerfi_tclToken::EN_MSG_GETCCFDATAMETHODSTART:
         poRetType = OSAL_NEW weathertunerfi_tclMsgGetCCFDataMethodStart;
         break;
      case weathertunerfi_tclToken::EN_MSG_GETCCFDATAMETHODRESULT:
         poRetType = OSAL_NEW weathertunerfi_tclMsgGetCCFDataMethodResult;
         break;
      case weathertunerfi_tclToken::EN_MSG_COUNTYWARNINGDATACHANGEDUPREG:
         poRetType = OSAL_NEW weathertunerfi_tclMsgCountyWarningDataChangedUpReg;
         break;
      case weathertunerfi_tclToken::EN_MSG_COUNTYWARNINGDATACHANGEDSTATUS:
         poRetType = OSAL_NEW weathertunerfi_tclMsgCountyWarningDataChangedStatus;
         break;
      case weathertunerfi_tclToken::EN_MSG_COUNTYWARNINGDATACHANGEDRELUPREG:
         poRetType = OSAL_NEW weathertunerfi_tclMsgCountyWarningDataChangedRelUpReg;
         break;
      case weathertunerfi_tclToken::EN_MSG_COUNTYWARNINGDATACHANGEDGET:
         poRetType = OSAL_NEW weathertunerfi_tclMsgCountyWarningDataChangedGet;
         break;
      case weathertunerfi_tclToken::EN_MSG_CCFDATACHANGEDUPREG:
         poRetType = OSAL_NEW weathertunerfi_tclMsgCCFDataChangedUpReg;
         break;
      case weathertunerfi_tclToken::EN_MSG_CCFDATACHANGEDSTATUS:
         poRetType = OSAL_NEW weathertunerfi_tclMsgCCFDataChangedStatus;
         break;
      case weathertunerfi_tclToken::EN_MSG_CCFDATACHANGEDRELUPREG:
         poRetType = OSAL_NEW weathertunerfi_tclMsgCCFDataChangedRelUpReg;
         break;
      case weathertunerfi_tclToken::EN_MSG_CCFDATACHANGEDGET:
         poRetType = OSAL_NEW weathertunerfi_tclMsgCCFDataChangedGet;
         break;
      default: 
         poRetType = OSAL_NULL;
      }
      break;
   default: 
      poRetType = OSAL_NULL;
   }
   return poRetType;
}

