/************************************************************************
 
 *FILE:           navifitypes.cpp
 
 *SW-COMPONENT:   NaviFI, Navigation Functional Interface
 
 *DESCRIPTION:    Interface fuer allgemeine Typdefinitionen des Nafi
                  
 *AUTHOR:         Jochen Bruns (CM-DI/ENS41)
 
 *COPYRIGHT:      (c) 2001 Blaupunkt GmbH
 
 ************************************************************************/

#include "precompiled.hh"
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
tmpresfi_tclMsgTrafficInfoSourceMethodStart::tmpresfi_tclMsgTrafficInfoSourceMethodStart(const tmpresfi_tclMsgTrafficInfoSourceMethodStart& coRef):fi_tclVisitableTypeBase(coRef)
{
   TrafficMessageSource = coRef.TrafficMessageSource;
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
tmpresfi_tclMsgTrafficInfoSourceMethodStart& tmpresfi_tclMsgTrafficInfoSourceMethodStart::operator=(const tmpresfi_tclMsgTrafficInfoSourceMethodStart& coRef)
{
   if (this == &coRef) return *this;
   TrafficMessageSource = coRef.TrafficMessageSource;
   return *this;
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
tU16 tmpresfi_tclMsgTrafficInfoSourceMethodStart::u16GetServiceID() const {return TMPRESFI_C_U16_SERVICE_ID;}
tU16 tmpresfi_tclMsgTrafficInfoSourceMethodStart::u16GetFunctionID() const {return TMPRESFI_C_U16_TRAFFICINFOSOURCE;}
tU8 tmpresfi_tclMsgTrafficInfoSourceMethodStart::u8GetOpCode() const {return CCA_C_U8_OPCODE_METHODSTART;}

tU32 tmpresfi_tclMsgTrafficInfoSourceMethodStart::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 4;
}

tBool tmpresfi_tclMsgTrafficInfoSourceMethodStart::operator==(const tmpresfi_tclMsgTrafficInfoSourceMethodStart& rfoCmp) const
{
   tBool bResult = true;
      bResult = bResult && (TrafficMessageSource == rfoCmp.TrafficMessageSource);
   return bResult;
}

fi_tclInContext& tmpresfi_tclMsgTrafficInfoSourceMethodStart::oRead(fi_tclInContext& oIn)
{
   oIn >> TrafficMessageSource;
   return oIn;
}

fi_tclOutContext& tmpresfi_tclMsgTrafficInfoSourceMethodStart::oWrite(fi_tclOutContext& oOut) const
{
   oOut << TrafficMessageSource;
   return oOut;
}

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
tmpresfi_tclMsgTrafficInfoSourceMethodResult::tmpresfi_tclMsgTrafficInfoSourceMethodResult(const tmpresfi_tclMsgTrafficInfoSourceMethodResult& coRef):fi_tclVisitableTypeBase(coRef)
{
   TrafficMessageSource = coRef.TrafficMessageSource;
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
tmpresfi_tclMsgTrafficInfoSourceMethodResult& tmpresfi_tclMsgTrafficInfoSourceMethodResult::operator=(const tmpresfi_tclMsgTrafficInfoSourceMethodResult& coRef)
{
   if (this == &coRef) return *this;
   TrafficMessageSource = coRef.TrafficMessageSource;
   return *this;
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
tU16 tmpresfi_tclMsgTrafficInfoSourceMethodResult::u16GetServiceID() const {return TMPRESFI_C_U16_SERVICE_ID;}
tU16 tmpresfi_tclMsgTrafficInfoSourceMethodResult::u16GetFunctionID() const {return TMPRESFI_C_U16_TRAFFICINFOSOURCE;}
tU8 tmpresfi_tclMsgTrafficInfoSourceMethodResult::u8GetOpCode() const {return CCA_C_U8_OPCODE_METHODRESULT;}

tU32 tmpresfi_tclMsgTrafficInfoSourceMethodResult::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 4;
}

tBool tmpresfi_tclMsgTrafficInfoSourceMethodResult::operator==(const tmpresfi_tclMsgTrafficInfoSourceMethodResult& rfoCmp) const
{
   tBool bResult = true;
      bResult = bResult && (TrafficMessageSource == rfoCmp.TrafficMessageSource);
   return bResult;
}

fi_tclInContext& tmpresfi_tclMsgTrafficInfoSourceMethodResult::oRead(fi_tclInContext& oIn)
{
   oIn >> TrafficMessageSource;
   return oIn;
}

fi_tclOutContext& tmpresfi_tclMsgTrafficInfoSourceMethodResult::oWrite(fi_tclOutContext& oOut) const
{
   oOut << TrafficMessageSource;
   return oOut;
}

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
tmpresfi_tclMsgTranslateExtendedMessageMethodStart::tmpresfi_tclMsgTranslateExtendedMessageMethodStart(const tmpresfi_tclMsgTranslateExtendedMessageMethodStart& coRef):fi_tclVisitableTypeBase(coRef)
{
   CodedMessage = coRef.CodedMessage;
   LanguageId = coRef.LanguageId;
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
tmpresfi_tclMsgTranslateExtendedMessageMethodStart& tmpresfi_tclMsgTranslateExtendedMessageMethodStart::operator=(const tmpresfi_tclMsgTranslateExtendedMessageMethodStart& coRef)
{
   if (this == &coRef) return *this;
   CodedMessage = coRef.CodedMessage;
   LanguageId = coRef.LanguageId;
   return *this;
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
tU16 tmpresfi_tclMsgTranslateExtendedMessageMethodStart::u16GetServiceID() const {return TMPRESFI_C_U16_SERVICE_ID;}
tU16 tmpresfi_tclMsgTranslateExtendedMessageMethodStart::u16GetFunctionID() const {return TMPRESFI_C_U16_TRANSLATEEXTENDEDMESSAGE;}
tU8 tmpresfi_tclMsgTranslateExtendedMessageMethodStart::u8GetOpCode() const {return CCA_C_U8_OPCODE_METHODSTART;}

tVoid tmpresfi_tclMsgTranslateExtendedMessageMethodStart::vDestroy()
{
   CodedMessage.vDestroy(); 
   LanguageId.vDestroy(); 
}

tU32 tmpresfi_tclMsgTranslateExtendedMessageMethodStart::u32GetSize(tU16 u16MajorVersion) const
{
   return 4+CodedMessage.u32GetSize(u16MajorVersion);
}

tBool tmpresfi_tclMsgTranslateExtendedMessageMethodStart::operator==(const tmpresfi_tclMsgTranslateExtendedMessageMethodStart& rfoCmp) const
{
   tBool bResult = true;
      bResult = bResult && (CodedMessage == rfoCmp.CodedMessage);
      bResult = bResult && (LanguageId == rfoCmp.LanguageId);
   return bResult;
}

fi_tclInContext& tmpresfi_tclMsgTranslateExtendedMessageMethodStart::oRead(fi_tclInContext& oIn)
{
   oIn >> CodedMessage;
   oIn >> LanguageId;
   return oIn;
}

fi_tclOutContext& tmpresfi_tclMsgTranslateExtendedMessageMethodStart::oWrite(fi_tclOutContext& oOut) const
{
   oOut << CodedMessage;
   oOut << LanguageId;
   return oOut;
}

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
tmpresfi_tclMsgTranslateExtendedMessageMethodResult::tmpresfi_tclMsgTranslateExtendedMessageMethodResult(const tmpresfi_tclMsgTranslateExtendedMessageMethodResult& coRef):fi_tclVisitableTypeBase(coRef)
{
   StringInXML = coRef.StringInXML;
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
tmpresfi_tclMsgTranslateExtendedMessageMethodResult& tmpresfi_tclMsgTranslateExtendedMessageMethodResult::operator=(const tmpresfi_tclMsgTranslateExtendedMessageMethodResult& coRef)
{
   if (this == &coRef) return *this;
   StringInXML = coRef.StringInXML;
   return *this;
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
tU16 tmpresfi_tclMsgTranslateExtendedMessageMethodResult::u16GetServiceID() const {return TMPRESFI_C_U16_SERVICE_ID;}
tU16 tmpresfi_tclMsgTranslateExtendedMessageMethodResult::u16GetFunctionID() const {return TMPRESFI_C_U16_TRANSLATEEXTENDEDMESSAGE;}
tU8 tmpresfi_tclMsgTranslateExtendedMessageMethodResult::u8GetOpCode() const {return CCA_C_U8_OPCODE_METHODRESULT;}

tVoid tmpresfi_tclMsgTranslateExtendedMessageMethodResult::vDestroy()
{
   StringInXML.vDestroy();
}

tU32 tmpresfi_tclMsgTranslateExtendedMessageMethodResult::u32GetSize(tU16 u16MajorVersion) const
{
   return 0+StringInXML.u32GetSize(u16MajorVersion);
}

tBool tmpresfi_tclMsgTranslateExtendedMessageMethodResult::operator==(const tmpresfi_tclMsgTranslateExtendedMessageMethodResult& rfoCmp) const
{
   tBool bResult = true;
      bResult = bResult && (StringInXML == rfoCmp.StringInXML);
   return bResult;
}

fi_tclInContext& tmpresfi_tclMsgTranslateExtendedMessageMethodResult::oRead(fi_tclInContext& oIn)
{
   oIn >> StringInXML;
   return oIn;
}

fi_tclOutContext& tmpresfi_tclMsgTranslateExtendedMessageMethodResult::oWrite(fi_tclOutContext& oOut) const
{
   oOut << StringInXML;
   return oOut;
}

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
tmpresfi_tclMsgTrafficSourceGet::tmpresfi_tclMsgTrafficSourceGet(const tmpresfi_tclMsgTrafficSourceGet& coRef):fi_tclVisitableTypeBase(coRef)
{
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
tmpresfi_tclMsgTrafficSourceGet& tmpresfi_tclMsgTrafficSourceGet::operator=(const tmpresfi_tclMsgTrafficSourceGet& coRef)
{
   if (this == &coRef) return *this;
   return *this;
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
tU16 tmpresfi_tclMsgTrafficSourceGet::u16GetServiceID() const {return TMPRESFI_C_U16_SERVICE_ID;}
tU16 tmpresfi_tclMsgTrafficSourceGet::u16GetFunctionID() const {return TMPRESFI_C_U16_TRAFFICSOURCE;}
tU8 tmpresfi_tclMsgTrafficSourceGet::u8GetOpCode() const {return CCA_C_U8_OPCODE_GET;}

tU32 tmpresfi_tclMsgTrafficSourceGet::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 0;
}

tBool tmpresfi_tclMsgTrafficSourceGet::operator==(const tmpresfi_tclMsgTrafficSourceGet& /* rfoCmp */) const
{
   tBool bResult = true;
   return bResult;
}

fi_tclInContext& tmpresfi_tclMsgTrafficSourceGet::oRead(fi_tclInContext& oIn)
{
   return oIn;
}

fi_tclOutContext& tmpresfi_tclMsgTrafficSourceGet::oWrite(fi_tclOutContext& oOut) const
{
   return oOut;
}

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
tmpresfi_tclMsgTrafficSourceStatus::tmpresfi_tclMsgTrafficSourceStatus(const tmpresfi_tclMsgTrafficSourceStatus& coRef):fi_tclVisitableTypeBase(coRef)
{
   TrafficMessageSource = coRef.TrafficMessageSource;
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
tmpresfi_tclMsgTrafficSourceStatus& tmpresfi_tclMsgTrafficSourceStatus::operator=(const tmpresfi_tclMsgTrafficSourceStatus& coRef)
{
   if (this == &coRef) return *this;
   TrafficMessageSource = coRef.TrafficMessageSource;
   return *this;
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
tU16 tmpresfi_tclMsgTrafficSourceStatus::u16GetServiceID() const {return TMPRESFI_C_U16_SERVICE_ID;}
tU16 tmpresfi_tclMsgTrafficSourceStatus::u16GetFunctionID() const {return TMPRESFI_C_U16_TRAFFICSOURCE;}
tU8 tmpresfi_tclMsgTrafficSourceStatus::u8GetOpCode() const {return CCA_C_U8_OPCODE_STATUS;}

tU32 tmpresfi_tclMsgTrafficSourceStatus::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 4;
}

tBool tmpresfi_tclMsgTrafficSourceStatus::operator==(const tmpresfi_tclMsgTrafficSourceStatus& rfoCmp) const
{
   tBool bResult = true;
      bResult = bResult && (TrafficMessageSource == rfoCmp.TrafficMessageSource);
   return bResult;
}

fi_tclInContext& tmpresfi_tclMsgTrafficSourceStatus::oRead(fi_tclInContext& oIn)
{
   oIn >> TrafficMessageSource;
   return oIn;
}

fi_tclOutContext& tmpresfi_tclMsgTrafficSourceStatus::oWrite(fi_tclOutContext& oOut) const
{
   oOut << TrafficMessageSource;
   return oOut;
}

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
tmpresfi_tclMsgAvailableLanguagesGet::tmpresfi_tclMsgAvailableLanguagesGet(const tmpresfi_tclMsgAvailableLanguagesGet& coRef):fi_tclVisitableTypeBase(coRef)
{
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
tmpresfi_tclMsgAvailableLanguagesGet& tmpresfi_tclMsgAvailableLanguagesGet::operator=(const tmpresfi_tclMsgAvailableLanguagesGet& coRef)
{
   if (this == &coRef) return *this;
   return *this;
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
tU16 tmpresfi_tclMsgAvailableLanguagesGet::u16GetServiceID() const {return TMPRESFI_C_U16_SERVICE_ID;}
tU16 tmpresfi_tclMsgAvailableLanguagesGet::u16GetFunctionID() const {return TMPRESFI_C_U16_AVAILABLELANGUAGES;}
tU8 tmpresfi_tclMsgAvailableLanguagesGet::u8GetOpCode() const {return CCA_C_U8_OPCODE_GET;}

tU32 tmpresfi_tclMsgAvailableLanguagesGet::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 0;
}

tBool tmpresfi_tclMsgAvailableLanguagesGet::operator==(const tmpresfi_tclMsgAvailableLanguagesGet& /* rfoCmp */) const
{
   tBool bResult = true;
   return bResult;
}

fi_tclInContext& tmpresfi_tclMsgAvailableLanguagesGet::oRead(fi_tclInContext& oIn)
{
   return oIn;
}

fi_tclOutContext& tmpresfi_tclMsgAvailableLanguagesGet::oWrite(fi_tclOutContext& oOut) const
{
   return oOut;
}

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
tmpresfi_tclMsgAvailableLanguagesStatus::tmpresfi_tclMsgAvailableLanguagesStatus(const tmpresfi_tclMsgAvailableLanguagesStatus& coRef):fi_tclVisitableTypeBase(coRef)
{
   ListOfLanguageIds = coRef.ListOfLanguageIds;
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
tmpresfi_tclMsgAvailableLanguagesStatus& tmpresfi_tclMsgAvailableLanguagesStatus::operator=(const tmpresfi_tclMsgAvailableLanguagesStatus& coRef)
{
   if (this == &coRef) return *this;
   ListOfLanguageIds = coRef.ListOfLanguageIds;
   return *this;
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
tU16 tmpresfi_tclMsgAvailableLanguagesStatus::u16GetServiceID() const {return TMPRESFI_C_U16_SERVICE_ID;}
tU16 tmpresfi_tclMsgAvailableLanguagesStatus::u16GetFunctionID() const {return TMPRESFI_C_U16_AVAILABLELANGUAGES;}
tU8 tmpresfi_tclMsgAvailableLanguagesStatus::u8GetOpCode() const {return CCA_C_U8_OPCODE_STATUS;}

tVoid tmpresfi_tclMsgAvailableLanguagesStatus::vDestroy()
{
   {
      for (tU32 u32Idx = 0; u32Idx < ListOfLanguageIds.size(); ++u32Idx)
         ListOfLanguageIds[u32Idx].vDestroy();
   }
   ListOfLanguageIds.clear();
}

tU32 tmpresfi_tclMsgAvailableLanguagesStatus::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 4+ListOfLanguageIds.size()*4;
}

tBool tmpresfi_tclMsgAvailableLanguagesStatus::operator==(const tmpresfi_tclMsgAvailableLanguagesStatus& rfoCmp) const
{
   tBool bResult = true;
      bResult = bResult && (ListOfLanguageIds.size() == rfoCmp.ListOfLanguageIds.size());
      if (bResult)
      {
         for (tU32 u32Idx = 0; bResult && (u32Idx < ListOfLanguageIds.size()); ++u32Idx)
            bResult = bResult && (ListOfLanguageIds[u32Idx] == rfoCmp.ListOfLanguageIds[u32Idx]);
      }
   return bResult;
}

fi_tclInContext& tmpresfi_tclMsgAvailableLanguagesStatus::oRead(fi_tclInContext& oIn)
{
   {
      tU32 u32Length;
      tU32 u32Idx;
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
      for (u32Idx = 0; u32Idx < ListOfLanguageIds.size(); ++u32Idx)
      {
         ListOfLanguageIds[u32Idx].vDestroy();
      }
#endif // !VARIANT_S_FTR_ENABLE_DEEP_COPY
      oIn >> u32Length;
      ListOfLanguageIds.resize(u32Length);
      for (u32Idx = 0; u32Idx < u32Length; ++u32Idx)
      {
         oIn >> ListOfLanguageIds[u32Idx];
      }
   }
   return oIn;
}

fi_tclOutContext& tmpresfi_tclMsgAvailableLanguagesStatus::oWrite(fi_tclOutContext& oOut) const
{
   oOut << (tU32)ListOfLanguageIds.size();
   {
      for (tU32 u32Idx = 0; u32Idx < ListOfLanguageIds.size(); ++u32Idx)
         oOut << ListOfLanguageIds[u32Idx];
   }
   return oOut;
}

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
tmpresfi_tclMsgEngineeringTextGet::tmpresfi_tclMsgEngineeringTextGet(const tmpresfi_tclMsgEngineeringTextGet& coRef):fi_tclVisitableTypeBase(coRef)
{
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
tmpresfi_tclMsgEngineeringTextGet& tmpresfi_tclMsgEngineeringTextGet::operator=(const tmpresfi_tclMsgEngineeringTextGet& coRef)
{
   if (this == &coRef) return *this;
   return *this;
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
tU16 tmpresfi_tclMsgEngineeringTextGet::u16GetServiceID() const {return TMPRESFI_C_U16_SERVICE_ID;}
tU16 tmpresfi_tclMsgEngineeringTextGet::u16GetFunctionID() const {return TMPRESFI_C_U16_ENGINEERINGTEXT;}
tU8 tmpresfi_tclMsgEngineeringTextGet::u8GetOpCode() const {return CCA_C_U8_OPCODE_GET;}

tU32 tmpresfi_tclMsgEngineeringTextGet::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 0;
}

tBool tmpresfi_tclMsgEngineeringTextGet::operator==(const tmpresfi_tclMsgEngineeringTextGet& /* rfoCmp */) const
{
   tBool bResult = true;
   return bResult;
}

fi_tclInContext& tmpresfi_tclMsgEngineeringTextGet::oRead(fi_tclInContext& oIn)
{
   return oIn;
}

fi_tclOutContext& tmpresfi_tclMsgEngineeringTextGet::oWrite(fi_tclOutContext& oOut) const
{
   return oOut;
}

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
tmpresfi_tclMsgEngineeringTextUpReg::tmpresfi_tclMsgEngineeringTextUpReg(const tmpresfi_tclMsgEngineeringTextUpReg& coRef):fi_tclVisitableTypeBase(coRef)
{
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
tmpresfi_tclMsgEngineeringTextUpReg& tmpresfi_tclMsgEngineeringTextUpReg::operator=(const tmpresfi_tclMsgEngineeringTextUpReg& coRef)
{
   if (this == &coRef) return *this;
   return *this;
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
tU16 tmpresfi_tclMsgEngineeringTextUpReg::u16GetServiceID() const {return TMPRESFI_C_U16_SERVICE_ID;}
tU16 tmpresfi_tclMsgEngineeringTextUpReg::u16GetFunctionID() const {return TMPRESFI_C_U16_ENGINEERINGTEXT;}
tU8 tmpresfi_tclMsgEngineeringTextUpReg::u8GetOpCode() const {return CCA_C_U8_OPCODE_UPREG;}

tU32 tmpresfi_tclMsgEngineeringTextUpReg::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 0;
}

tBool tmpresfi_tclMsgEngineeringTextUpReg::operator==(const tmpresfi_tclMsgEngineeringTextUpReg& /* rfoCmp */) const
{
   tBool bResult = true;
   return bResult;
}

fi_tclInContext& tmpresfi_tclMsgEngineeringTextUpReg::oRead(fi_tclInContext& oIn)
{
   return oIn;
}

fi_tclOutContext& tmpresfi_tclMsgEngineeringTextUpReg::oWrite(fi_tclOutContext& oOut) const
{
   return oOut;
}

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
tmpresfi_tclMsgEngineeringTextRelUpReg::tmpresfi_tclMsgEngineeringTextRelUpReg(const tmpresfi_tclMsgEngineeringTextRelUpReg& coRef):fi_tclVisitableTypeBase(coRef)
{
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
tmpresfi_tclMsgEngineeringTextRelUpReg& tmpresfi_tclMsgEngineeringTextRelUpReg::operator=(const tmpresfi_tclMsgEngineeringTextRelUpReg& coRef)
{
   if (this == &coRef) return *this;
   return *this;
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
tU16 tmpresfi_tclMsgEngineeringTextRelUpReg::u16GetServiceID() const {return TMPRESFI_C_U16_SERVICE_ID;}
tU16 tmpresfi_tclMsgEngineeringTextRelUpReg::u16GetFunctionID() const {return TMPRESFI_C_U16_ENGINEERINGTEXT;}
tU8 tmpresfi_tclMsgEngineeringTextRelUpReg::u8GetOpCode() const {return CCA_C_U8_OPCODE_RELUPREG;}

tU32 tmpresfi_tclMsgEngineeringTextRelUpReg::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 0;
}

tBool tmpresfi_tclMsgEngineeringTextRelUpReg::operator==(const tmpresfi_tclMsgEngineeringTextRelUpReg& /* rfoCmp */) const
{
   tBool bResult = true;
   return bResult;
}

fi_tclInContext& tmpresfi_tclMsgEngineeringTextRelUpReg::oRead(fi_tclInContext& oIn)
{
   return oIn;
}

fi_tclOutContext& tmpresfi_tclMsgEngineeringTextRelUpReg::oWrite(fi_tclOutContext& oOut) const
{
   return oOut;
}

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
tmpresfi_tclMsgEngineeringTextStatus::tmpresfi_tclMsgEngineeringTextStatus(const tmpresfi_tclMsgEngineeringTextStatus& coRef):fi_tclVisitableTypeBase(coRef)
{
   Message = coRef.Message;
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
tmpresfi_tclMsgEngineeringTextStatus& tmpresfi_tclMsgEngineeringTextStatus::operator=(const tmpresfi_tclMsgEngineeringTextStatus& coRef)
{
   if (this == &coRef) return *this;
   Message = coRef.Message;
   return *this;
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
tU16 tmpresfi_tclMsgEngineeringTextStatus::u16GetServiceID() const {return TMPRESFI_C_U16_SERVICE_ID;}
tU16 tmpresfi_tclMsgEngineeringTextStatus::u16GetFunctionID() const {return TMPRESFI_C_U16_ENGINEERINGTEXT;}
tU8 tmpresfi_tclMsgEngineeringTextStatus::u8GetOpCode() const {return CCA_C_U8_OPCODE_STATUS;}

tVoid tmpresfi_tclMsgEngineeringTextStatus::vDestroy()
{
   Message.vDestroy();
}

tU32 tmpresfi_tclMsgEngineeringTextStatus::u32GetSize(tU16 u16MajorVersion) const
{
   return 0+Message.u32GetSize(u16MajorVersion);
}

tBool tmpresfi_tclMsgEngineeringTextStatus::operator==(const tmpresfi_tclMsgEngineeringTextStatus& rfoCmp) const
{
   tBool bResult = true;
      bResult = bResult && (Message == rfoCmp.Message);
   return bResult;
}

fi_tclInContext& tmpresfi_tclMsgEngineeringTextStatus::oRead(fi_tclInContext& oIn)
{
   oIn >> Message;
   return oIn;
}

fi_tclOutContext& tmpresfi_tclMsgEngineeringTextStatus::oWrite(fi_tclOutContext& oOut) const
{
   oOut << Message;
   return oOut;
}

