#ifndef TMPRESFILANGUAGE_HEADER
#define TMPRESFILANGUAGE_HEADER

class tmpresfi_tclInContext;
class tmpresfi_tclOutContext;
class tmpresfi_tclVisitorBase;

class MY_DECL tmpresfi_tclDescription {
 public:
  enum tenType { EN_PARSING, EN_GENERATING };	
  
  tmpresfi_tclDescription(fi_tclInContext* poIn, tmpresfi_tclVisitorBase* poVisit);
  tmpresfi_tclDescription(fi_tclOutContext* poOut, tmpresfi_tclVisitorBase* poVisit);
  
  /* --Hier kommen nun die Methoden, die einzelne Nachrichten entspr. NaFI 
		erzeugen (EN_GENERATING) bzw. einlesen (EN_PARSING). */

  tBool bInitMessage(tmpresfi_tclToken::tenType enMsgToken);
  tBool bProcessMessage();

  // tBool bProcessElement(); 

  tBool bDoIt(fi_tclVisitableTypeBase& poBaseType);
#ifndef FI_S_EXTERNAL_FI
  void vEnableSpecialBinContainer() { bUseSpecialBinContainer = true; }
#endif

 private:
  /* default constructor */ tmpresfi_tclDescription();  //lint !e1704 // always use parameters
  tenType enType; //--read or write?

  union {
    fi_tclInContext* poInContext;
    fi_tclOutContext* poOutContext;
  };

  tmpresfi_tclVisitorBase* poVisitor;

  // typedef navifi_tclTraversePath::tclKnot tclKnot;

  tBool bUseSpecialBinContainer;  
  
 public:
  
  // --Traversierungspfad
  fi_tclTraversePath<tmpresfi_tclKnot> oPath;
  //   navifi_tclTraversePath oPath;
  fi_tclTraversePath<tmpresfi_tclKnot> oCallStack;
   //  navifi_tclTraversePath oCallStack;
  
};

// --Inline-Implementierungen
inline tmpresfi_tclDescription::tmpresfi_tclDescription(fi_tclInContext* poIn, tmpresfi_tclVisitorBase* poVisit):
  enType(EN_PARSING),poInContext(poIn),poVisitor(poVisit),bUseSpecialBinContainer(false) {}

inline tmpresfi_tclDescription::tmpresfi_tclDescription(fi_tclOutContext* poOut, tmpresfi_tclVisitorBase* poVisit):
  enType(EN_GENERATING),poOutContext(poOut),poVisitor(poVisit),bUseSpecialBinContainer(false) {}

#endif

