#include "precompiled.hh"

tBool tmpresfi_tclDescription::bInitMessage(tmpresfi_tclToken::tenType enMsgToken) {
   tBool bResult = TRUE;
   switch (enMsgToken) {
   case tmpresfi_tclToken::EN_LAST_TOKEN:
   case tmpresfi_tclToken::EN_LIST:
   case tmpresfi_tclToken::EN_END_OF_STRUCT:
   case tmpresfi_tclToken::EN_UNKNOWN:
      bResult=FALSE;   
   break;
      // include the expansions for the messages
   case tmpresfi_tclToken::EN_MSG_TRAFFICINFOSOURCEMETHODSTART:
   {
      bResult &= oPath.bGoDown(tmpresfi_tclKnot(tmpresfi_tclToken::EN_B32_TRAFFICMESSAGESOURCE,tmpresfi_tclSemanticDomain::EN_MSG_TRAFFICMESSAGESOURCE));
   } break;
   case tmpresfi_tclToken::EN_MSG_TRAFFICINFOSOURCEMETHODRESULT:
   {
      bResult &= oPath.bGoDown(tmpresfi_tclKnot(tmpresfi_tclToken::EN_B32_TRAFFICMESSAGESOURCE,tmpresfi_tclSemanticDomain::EN_MSG_TRAFFICMESSAGESOURCE));
   } break;
   case tmpresfi_tclToken::EN_MSG_TRANSLATEEXTENDEDMESSAGEMETHODSTART:
   {
      bResult &= oPath.bGoDown(tmpresfi_tclKnot(tmpresfi_tclToken::EN_LANGUAGEID,tmpresfi_tclSemanticDomain::EN_MSG_LANGUAGEID));
      bResult &= oPath.bGoDown(tmpresfi_tclKnot(tmpresfi_tclToken::EN_BINCONTAINER,tmpresfi_tclSemanticDomain::EN_MSG_CODEDMESSAGE));
   } break;
   case tmpresfi_tclToken::EN_MSG_TRANSLATEEXTENDEDMESSAGEMETHODRESULT:
   {
      bResult &= oPath.bGoDown(tmpresfi_tclKnot(tmpresfi_tclToken::EN_STRING,tmpresfi_tclSemanticDomain::EN_MSG_STRINGINXML));
   } break;
   case tmpresfi_tclToken::EN_MSG_TRAFFICSOURCESTATUS:
   {
      bResult &= oPath.bGoDown(tmpresfi_tclKnot(tmpresfi_tclToken::EN_B32_TRAFFICMESSAGESOURCE,tmpresfi_tclSemanticDomain::EN_MSG_TRAFFICMESSAGESOURCE));
   } break;
   case tmpresfi_tclToken::EN_MSG_AVAILABLELANGUAGESSTATUS:
   {
      bResult &= oPath.bGoDown(tmpresfi_tclKnot(tmpresfi_tclToken::EN_LANGUAGEID,tmpresfi_tclSemanticDomain::EN_LIST_ELEMENT,0));
      bResult &= oPath.bGoDown(tmpresfi_tclKnot(tmpresfi_tclToken::EN_LIST,tmpresfi_tclSemanticDomain::EN_MSG_LISTOFLANGUAGEIDS));
   } break;
   case tmpresfi_tclToken::EN_MSG_ENGINEERINGTEXTSTATUS:
   {
      bResult &= oPath.bGoDown(tmpresfi_tclKnot(tmpresfi_tclToken::EN_STRING,tmpresfi_tclSemanticDomain::EN_MSG_MESSAGE));
   } break;
   case tmpresfi_tclToken::EN_BINCONTAINER:
   case tmpresfi_tclToken::EN_S32_METER:
   case tmpresfi_tclToken::EN_S32_SECOND:
   case tmpresfi_tclToken::EN_S16_KMPERHOUR:
   case tmpresfi_tclToken::EN_S16_CENTIMETERSECOND:
   case tmpresfi_tclToken::EN_FIVERSION:
   case tmpresfi_tclToken::EN_E16_ISOCOUNTRYCODE:
   case tmpresfi_tclToken::EN_E16_ISOLANGUAGECODE:
   case tmpresfi_tclToken::EN_LANGUAGEID:
   case tmpresfi_tclToken::EN_E8_BINCONTAINERTYPES:
   case tmpresfi_tclToken::EN_E16_NAVIEVENTVALUE:
   case tmpresfi_tclToken::EN_E8_TMLOCATIONTYPE:
   case tmpresfi_tclToken::EN_E8_EVENTTYPE:
   case tmpresfi_tclToken::EN_E16_EFFECTCODE:
   case tmpresfi_tclToken::EN_E16_CAUSECODE:
   case tmpresfi_tclToken::EN_E8_TENDENCY:
   case tmpresfi_tclToken::EN_RDBID:
   case tmpresfi_tclToken::EN_TMEVENT:
   case tmpresfi_tclToken::EN_B32_TRAFFICMESSAGESOURCE:
   case tmpresfi_tclToken::EN_TMCODEDMESSAGE:
   case tmpresfi_tclToken::EN_TMCODEDMESSAGEBINCONTAINER:
   case tmpresfi_tclToken::EN_U8:   
   case tmpresfi_tclToken::EN_S8:   
   case tmpresfi_tclToken::EN_U16:   
   case tmpresfi_tclToken::EN_S16:   
   case tmpresfi_tclToken::EN_U24:   
   case tmpresfi_tclToken::EN_S24:   
   case tmpresfi_tclToken::EN_U32:   
   case tmpresfi_tclToken::EN_S32:   
   case tmpresfi_tclToken::EN_U64:   
   case tmpresfi_tclToken::EN_S64:   
   case tmpresfi_tclToken::EN_F32:   
   case tmpresfi_tclToken::EN_F64:   
   case tmpresfi_tclToken::EN_BOOL:   
   case tmpresfi_tclToken::EN_STRING:   
   case tmpresfi_tclToken::EN_MULTILANGUAGESTRING:   
   default:
      oPath.bGoDown(tmpresfi_tclKnot(enMsgToken,tmpresfi_tclSemanticDomain::EN_UNKNOWN));
      bResult = TRUE;
   }	
   return bResult;
}

tBool tmpresfi_tclDescription::bDoIt(fi_tclVisitableTypeBase& oTypeBase)
{
   // --read or write?
   if (enType==EN_PARSING)
   {
     // --read first, then pass visitor
     (*poInContext) >> oTypeBase;
     oTypeBase.vTakeVisitor(*poVisitor);
   }
   else
   {
     // --first pass visitor, then stream 
	 oTypeBase.vTakeVisitor(*poVisitor);
     (*poOutContext) << oTypeBase;
   }
   return poVisitor->bIsValid();
}

tBool tmpresfi_tclDescription::bProcessMessage() {
   tBool bResult = TRUE;
   tBool bInsideBinContainerVersion = false;
   tU16 u16MajorVersion;
   if (enType == EN_GENERATING)
   {
      u16MajorVersion = poOutContext->u16GetMajorVersion();
   }
   else
   {
      u16MajorVersion = poInContext->u16GetMajorVersion();
   }
   if (u16MajorVersion > 0x8000)
   {
      return FALSE;
   }
   tU16 u16SavedMajorVersion = u16MajorVersion;
   poVisitor->vReleaseBreak();
   while ((oPath.u32Position>0) && 
      bResult &&
      !poVisitor->bBreak() )    {
      // get current context (name, type, list index of next element)
      tmpresfi_tclKnot oKnot = oPath.oGetIterator().oKnot();
      tmpresfi_tclSemanticDomain::tenType enSemanticDomain = oKnot.enSemanticDomain;
      tmpresfi_tclToken::tenType enToken = oKnot.enToken;
      tU32 u32Index = oKnot.u32Index;
      
      // lists need special handling
      if (enSemanticDomain == tmpresfi_tclSemanticDomain::EN_LIST_ELEMENT) {
         oPath.bGoUp();
         // has list remaining elements?
         if (u32Index < oPath.oGetIterator().oKnot().u32Index) {
            // create next list element
            oPath.bGoDown(tmpresfi_tclKnot(enToken,enSemanticDomain,u32Index+1));
            oPath.bGoDown(tmpresfi_tclKnot(enToken,enSemanticDomain,u32Index));
         } else {
            // remove list, clean up
            oPath.bGoUp();
            oCallStack.bGoUp();
            continue;	
         }
      }
      // push current context on stack for visitor
      oCallStack.bGoDown(tmpresfi_tclKnot(enToken,enSemanticDomain,u32Index));
      poVisitor->oIterator=oCallStack.oGetIterator();
      
      // now, process element
      switch (enToken) {
      case tmpresfi_tclToken::EN_END_OF_STRUCT: 
      {
         // clean up after structures
         if (enSemanticDomain == tmpresfi_tclSemanticDomain::EN_BINCONTAINER)
         {
            u16MajorVersion = u16SavedMajorVersion;
            if (enType == EN_GENERATING)
            {
               poOutContext->u16SetMajorVersion(u16MajorVersion);
            }
            else
            {
               poInContext->u16SetMajorVersion(u16MajorVersion);
            }
         }
         oPath.bGoUp();
         oCallStack.bGoUp();
         oCallStack.bGoUp();
      } break;
      case tmpresfi_tclToken::EN_LIST: 
      {
         fi_tclList oList;
         // get list size
         if (!bDoIt(oList)) {
            // rearrange LIST and LIST_ELEMENT knots
            // pop "old" LIST knot
            oPath.bGoUp();
            // pop and backup LIST_ELEMENT knot
            tmpresfi_tclKnot saveKnot;
            oPath.bGoUp(saveKnot);
            // push LIST knot
            oPath.bGoDown(tmpresfi_tclKnot(enToken,enSemanticDomain,oList.u32ListSize));
            // push LIST_ELEMENT knot
            oPath.bGoDown(saveKnot);
            return FALSE;
         } else {
            // rearrange LIST and LIST_ELEMENT knots
            // pop "old" LIST knot
            oPath.bGoUp();
            // pop and backup LIST_ELEMENT knot
            tmpresfi_tclKnot saveKnot;
            oPath.bGoUp(saveKnot);
            // push LIST knot
            oPath.bGoDown(tmpresfi_tclKnot(enToken,enSemanticDomain,oList.u32ListSize));
            // push LIST_ELEMENT knot
            oPath.bGoDown(saveKnot);
         }
      } break;
      case tmpresfi_tclToken::EN_U8: 
      {
         fi_tclU8 oU8;
         if (!bDoIt(oU8))
            return FALSE;
         oCallStack.bGoUp();
         oPath.bGoUp();
         if (bInsideBinContainerVersion)
         {
            bInsideBinContainerVersion = false;
            u16SavedMajorVersion = u16MajorVersion;
            u16MajorVersion = oU8.u8Value;
            if (enType == EN_GENERATING)
            {
               poOutContext->u16SetMajorVersion(u16MajorVersion);
            }
            else
            {
               poInContext->u16SetMajorVersion(u16MajorVersion);
            }
         }
      } break;
      case tmpresfi_tclToken::EN_U16: 
      {
         fi_tclU16 oU16;
         if (!bDoIt(oU16))
            return FALSE;
         oCallStack.bGoUp();
         oPath.bGoUp();
      } break;
      case tmpresfi_tclToken::EN_U24: 
      {
         fi_tclU24 oU24;
         if (!bDoIt(oU24))
            return FALSE;
         oCallStack.bGoUp();
         oPath.bGoUp();
      } break;
      case tmpresfi_tclToken::EN_U32: 
      {
         fi_tclU32 oU32;
         if (!bDoIt(oU32))
            return FALSE;
         oCallStack.bGoUp();
         oPath.bGoUp();
      } break;
      case tmpresfi_tclToken::EN_U64: 
      {
         fi_tclU64 oU64;
         if (!bDoIt(oU64))
            return FALSE;
         oCallStack.bGoUp();
         oPath.bGoUp();
      } break;
      case tmpresfi_tclToken::EN_S8: 
      {
         fi_tclS8 oS8;
         if (!bDoIt(oS8))
            return FALSE;
         oCallStack.bGoUp();
         oPath.bGoUp();
      } break;
      case tmpresfi_tclToken::EN_S16: 
      {
         fi_tclS16 oS16;
         if (!bDoIt(oS16))
            return FALSE;
         oCallStack.bGoUp();
         oPath.bGoUp();
      } break;
      case tmpresfi_tclToken::EN_S24: 
      {
         fi_tclS24 oS24;
         if (!bDoIt(oS24))
            return FALSE;
         oCallStack.bGoUp();
         oPath.bGoUp();
      } break;
      case tmpresfi_tclToken::EN_S32: 
      {
         fi_tclS32 oS32;
         if (!bDoIt(oS32))
            return FALSE;
         oCallStack.bGoUp();
         oPath.bGoUp();
      } break;
      case tmpresfi_tclToken::EN_S64: 
      {
         fi_tclS64 oS64;
         if (!bDoIt(oS64))
            return FALSE;
         oCallStack.bGoUp();
         oPath.bGoUp();
      } break;
      case tmpresfi_tclToken::EN_F32: 
      {
         fi_tclF32 oF32;
         if (!bDoIt(oF32))
            return FALSE;
         oCallStack.bGoUp();
         oPath.bGoUp();
      } break;
      case tmpresfi_tclToken::EN_F64: 
      {
         fi_tclF64 oF64;
         if (!bDoIt(oF64))
            return FALSE;
         oCallStack.bGoUp();
         oPath.bGoUp();
      } break;
      case tmpresfi_tclToken::EN_BOOL: 
      {
         fi_tclBool oBool;
         if (!bDoIt(oBool))
            return FALSE;
         oCallStack.bGoUp();
         oPath.bGoUp();
      } break;
      case tmpresfi_tclToken::EN_STRING: 
      {
         fi_tclString oString;
         if (!bDoIt(oString)) {
            oString.vDestroy();
            return FALSE;
         }
         oString.vDestroy();
         oCallStack.bGoUp();
         oPath.bGoUp();
      } break;
      case tmpresfi_tclToken::EN_MULTILANGUAGESTRING: 
      {
         fi_tclMultiLanguageString oString;
         if (!bDoIt(oString)) {
            oString.vDestroy();
            return FALSE;
         }
         oString.vDestroy();
         oCallStack.bGoUp();
         oPath.bGoUp();
      } break;
      // include rest of type expansions/processing
   case tmpresfi_tclToken::EN_MSG_TRAFFICINFOSOURCEMETHODSTART:
   case tmpresfi_tclToken::EN_MSG_TRAFFICINFOSOURCEMETHODRESULT:
   case tmpresfi_tclToken::EN_MSG_TRANSLATEEXTENDEDMESSAGEMETHODSTART:
   case tmpresfi_tclToken::EN_MSG_TRANSLATEEXTENDEDMESSAGEMETHODRESULT:
   case tmpresfi_tclToken::EN_MSG_TRAFFICSOURCEGET:
   case tmpresfi_tclToken::EN_MSG_TRAFFICSOURCESTATUS:
   case tmpresfi_tclToken::EN_MSG_AVAILABLELANGUAGESGET:
   case tmpresfi_tclToken::EN_MSG_AVAILABLELANGUAGESSTATUS:
   case tmpresfi_tclToken::EN_MSG_ENGINEERINGTEXTGET:
   case tmpresfi_tclToken::EN_MSG_ENGINEERINGTEXTUPREG:
   case tmpresfi_tclToken::EN_MSG_ENGINEERINGTEXTRELUPREG:
   case tmpresfi_tclToken::EN_MSG_ENGINEERINGTEXTSTATUS:
      bInitMessage(enToken);
      break;
   case tmpresfi_tclToken::EN_BINCONTAINER:
   {
      if (poVisitor->bDoExpand_BinContainer(enSemanticDomain))
      {
         oPath.bGoUp();
         oPath.bGoDown(tmpresfi_tclKnot(tmpresfi_tclToken::EN_END_OF_STRUCT,tmpresfi_tclSemanticDomain::EN_UNKNOWN));
         oPath.bGoDown(tmpresfi_tclKnot(tmpresfi_tclToken::EN_U8,tmpresfi_tclSemanticDomain::EN_LIST_ELEMENT,0));
         oPath.bGoDown(tmpresfi_tclKnot(tmpresfi_tclToken::EN_LIST,tmpresfi_tclSemanticDomain::EN_CONTAINERDATALIST));
      }
      else
      {
         fi_tcl_BinContainer o_BinContainer;
         if (!bDoIt(o_BinContainer))
         {
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
            o_BinContainer.vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
            return FALSE;
         }
         else
         {
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
            o_BinContainer.vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
            oCallStack.bGoUp();
            oPath.bGoUp();
         }
      }
   } break;
   case tmpresfi_tclToken::EN_S32_METER:
   {
      fi_tcl_s32_Meter o_s32_Meter;
      if (!bDoIt(o_s32_Meter))
         return FALSE;
      oCallStack.bGoUp();
      oPath.bGoUp();
   } break;
   case tmpresfi_tclToken::EN_S32_SECOND:
   {
      fi_tcl_s32_Second o_s32_Second;
      if (!bDoIt(o_s32_Second))
         return FALSE;
      oCallStack.bGoUp();
      oPath.bGoUp();
   } break;
   case tmpresfi_tclToken::EN_S16_KMPERHOUR:
   {
      fi_tcl_s16_KmPerHour o_s16_KmPerHour;
      if (!bDoIt(o_s16_KmPerHour))
         return FALSE;
      oCallStack.bGoUp();
      oPath.bGoUp();
   } break;
   case tmpresfi_tclToken::EN_S16_CENTIMETERSECOND:
   {
      fi_tcl_s16_CentimeterSecond o_s16_CentimeterSecond;
      if (!bDoIt(o_s16_CentimeterSecond))
         return FALSE;
      oCallStack.bGoUp();
      oPath.bGoUp();
   } break;
   case tmpresfi_tclToken::EN_FIVERSION:
   {
      if (poVisitor->bDoExpand_FIVersion(enSemanticDomain))
      {
         oPath.bGoUp();
         oPath.bGoDown(tmpresfi_tclKnot(tmpresfi_tclToken::EN_END_OF_STRUCT,tmpresfi_tclSemanticDomain::EN_UNKNOWN));
         oPath.bGoDown(tmpresfi_tclKnot(tmpresfi_tclToken::EN_U8,tmpresfi_tclSemanticDomain::EN_PATCHVERSION));
         oPath.bGoDown(tmpresfi_tclKnot(tmpresfi_tclToken::EN_U8,tmpresfi_tclSemanticDomain::EN_MINORVERSION));
         oPath.bGoDown(tmpresfi_tclKnot(tmpresfi_tclToken::EN_U8,tmpresfi_tclSemanticDomain::EN_MAJORVERSION));
      }
      else
      {
         fi_tcl_FIVersion o_FIVersion;
         if (!bDoIt(o_FIVersion))
         {
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
            o_FIVersion.vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
            return FALSE;
         }
         else
         {
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
            o_FIVersion.vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
            oCallStack.bGoUp();
            oPath.bGoUp();
         }
      }
   } break;
   case tmpresfi_tclToken::EN_E16_ISOCOUNTRYCODE:
   {
      fi_tcl_e16_ISOCountryCode o_e16_ISOCountryCode;
      if (!bDoIt(o_e16_ISOCountryCode))
         return FALSE;
      oCallStack.bGoUp();
      oPath.bGoUp();
   } break;
   case tmpresfi_tclToken::EN_E16_ISOLANGUAGECODE:
   {
      fi_tcl_e16_ISOLanguageCode o_e16_ISOLanguageCode;
      if (!bDoIt(o_e16_ISOLanguageCode))
         return FALSE;
      oCallStack.bGoUp();
      oPath.bGoUp();
   } break;
   case tmpresfi_tclToken::EN_LANGUAGEID:
   {
      if (poVisitor->bDoExpand_LanguageID(enSemanticDomain))
      {
         oPath.bGoUp();
         oPath.bGoDown(tmpresfi_tclKnot(tmpresfi_tclToken::EN_END_OF_STRUCT,tmpresfi_tclSemanticDomain::EN_UNKNOWN));
         oPath.bGoDown(tmpresfi_tclKnot(tmpresfi_tclToken::EN_E16_ISOCOUNTRYCODE,tmpresfi_tclSemanticDomain::EN_ISO3166_COUNTRYCODE));
         oPath.bGoDown(tmpresfi_tclKnot(tmpresfi_tclToken::EN_E16_ISOLANGUAGECODE,tmpresfi_tclSemanticDomain::EN_ISO639_LANGUAGECODE));
      }
      else
      {
         fi_tcl_LanguageID o_LanguageID;
         if (!bDoIt(o_LanguageID))
         {
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
            o_LanguageID.vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
            return FALSE;
         }
         else
         {
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
            o_LanguageID.vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
            oCallStack.bGoUp();
            oPath.bGoUp();
         }
      }
   } break;
   case tmpresfi_tclToken::EN_E8_BINCONTAINERTYPES:
   {
      fi_tcl_e8_BinContainerTypes o_e8_BinContainerTypes;
      if (!bDoIt(o_e8_BinContainerTypes))
         return FALSE;
      oCallStack.bGoUp();
      oPath.bGoUp();
   } break;
   case tmpresfi_tclToken::EN_E16_NAVIEVENTVALUE:
   {
      fi_tcl_e16_NaviEventValue o_e16_NaviEventValue;
      if (!bDoIt(o_e16_NaviEventValue))
         return FALSE;
      oCallStack.bGoUp();
      oPath.bGoUp();
   } break;
   case tmpresfi_tclToken::EN_E8_TMLOCATIONTYPE:
   {
      fi_tcl_e8_TMLocationType o_e8_TMLocationType;
      if (!bDoIt(o_e8_TMLocationType))
         return FALSE;
      oCallStack.bGoUp();
      oPath.bGoUp();
   } break;
   case tmpresfi_tclToken::EN_E8_EVENTTYPE:
   {
      fi_tcl_e8_EventType o_e8_EventType;
      if (!bDoIt(o_e8_EventType))
         return FALSE;
      oCallStack.bGoUp();
      oPath.bGoUp();
   } break;
   case tmpresfi_tclToken::EN_E16_EFFECTCODE:
   {
      fi_tcl_e16_EffectCode o_e16_EffectCode;
      if (!bDoIt(o_e16_EffectCode))
         return FALSE;
      oCallStack.bGoUp();
      oPath.bGoUp();
   } break;
   case tmpresfi_tclToken::EN_E16_CAUSECODE:
   {
      fi_tcl_e16_CauseCode o_e16_CauseCode;
      if (!bDoIt(o_e16_CauseCode))
         return FALSE;
      oCallStack.bGoUp();
      oPath.bGoUp();
   } break;
   case tmpresfi_tclToken::EN_E8_TENDENCY:
   {
      fi_tcl_e8_Tendency o_e8_Tendency;
      if (!bDoIt(o_e8_Tendency))
         return FALSE;
      oCallStack.bGoUp();
      oPath.bGoUp();
   } break;
   case tmpresfi_tclToken::EN_RDBID:
   {
      if (poVisitor->bDoExpand_RDBId(enSemanticDomain))
      {
         oPath.bGoUp();
         oPath.bGoDown(tmpresfi_tclKnot(tmpresfi_tclToken::EN_END_OF_STRUCT,tmpresfi_tclSemanticDomain::EN_UNKNOWN));
         if (11 <= u16MajorVersion)
         {
            oPath.bGoDown(tmpresfi_tclKnot(tmpresfi_tclToken::EN_U16,tmpresfi_tclSemanticDomain::EN_BSA));
         }
         oPath.bGoDown(tmpresfi_tclKnot(tmpresfi_tclToken::EN_U8,tmpresfi_tclSemanticDomain::EN_TABLENO));
         oPath.bGoDown(tmpresfi_tclKnot(tmpresfi_tclToken::EN_U8,tmpresfi_tclSemanticDomain::EN_TMCCOUNTRYCODE));
      }
      else
      {
         fi_tcl_RDBId o_RDBId;
         if (!bDoIt(o_RDBId))
         {
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
            o_RDBId.vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
            return FALSE;
         }
         else
         {
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
            o_RDBId.vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
            oCallStack.bGoUp();
            oPath.bGoUp();
         }
      }
   } break;
   case tmpresfi_tclToken::EN_TMEVENT:
   {
      if (poVisitor->bDoExpand_TMEvent(enSemanticDomain))
      {
         oPath.bGoUp();
         oPath.bGoDown(tmpresfi_tclKnot(tmpresfi_tclToken::EN_END_OF_STRUCT,tmpresfi_tclSemanticDomain::EN_UNKNOWN));
         oPath.bGoDown(tmpresfi_tclKnot(tmpresfi_tclToken::EN_U8,tmpresfi_tclSemanticDomain::EN_PRIORITY));
         if (38 <= u16MajorVersion)
         {
            oPath.bGoDown(tmpresfi_tclKnot(tmpresfi_tclToken::EN_S16_CENTIMETERSECOND,tmpresfi_tclSemanticDomain::EN_AVERAGESPEEDCMPERSEC));
         }
         oPath.bGoDown(tmpresfi_tclKnot(tmpresfi_tclToken::EN_S16_KMPERHOUR,tmpresfi_tclSemanticDomain::EN_AVERAGESPEED));
         if (38 <= u16MajorVersion)
         {
            oPath.bGoDown(tmpresfi_tclKnot(tmpresfi_tclToken::EN_S16_CENTIMETERSECOND,tmpresfi_tclSemanticDomain::EN_SPEEDLIMITADVICECMPERSEC));
         }
         oPath.bGoDown(tmpresfi_tclKnot(tmpresfi_tclToken::EN_S16_KMPERHOUR,tmpresfi_tclSemanticDomain::EN_SPEEDLIMITADVICE));
         if (36 <= u16MajorVersion)
         {
            oPath.bGoDown(tmpresfi_tclKnot(tmpresfi_tclToken::EN_S32_SECOND,tmpresfi_tclSemanticDomain::EN_DELAYINFORMATION));
         }
         oPath.bGoDown(tmpresfi_tclKnot(tmpresfi_tclToken::EN_S32_METER,tmpresfi_tclSemanticDomain::EN_LENGTHINFORMATION));
         if (38 <= u16MajorVersion)
         {
            oPath.bGoDown(tmpresfi_tclKnot(tmpresfi_tclToken::EN_E16_CAUSECODE,tmpresfi_tclSemanticDomain::EN_CAUSE));
         }
         if (38 <= u16MajorVersion)
         {
            oPath.bGoDown(tmpresfi_tclKnot(tmpresfi_tclToken::EN_E8_TENDENCY,tmpresfi_tclSemanticDomain::EN_TENDENCY));
         }
         if (38 <= u16MajorVersion)
         {
            oPath.bGoDown(tmpresfi_tclKnot(tmpresfi_tclToken::EN_E16_EFFECTCODE,tmpresfi_tclSemanticDomain::EN_EFFECT));
         }
         oPath.bGoDown(tmpresfi_tclKnot(tmpresfi_tclToken::EN_E16_NAVIEVENTVALUE,tmpresfi_tclSemanticDomain::EN_NAVIEVENTVALUE));
         if (38 <= u16MajorVersion)
         {
            oPath.bGoDown(tmpresfi_tclKnot(tmpresfi_tclToken::EN_E8_EVENTTYPE,tmpresfi_tclSemanticDomain::EN_EVENTTYPE));
         }
      }
      else
      {
         fi_tcl_TMEvent o_TMEvent;
         if (!bDoIt(o_TMEvent))
         {
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
            o_TMEvent.vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
            return FALSE;
         }
         else
         {
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
            o_TMEvent.vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
            oCallStack.bGoUp();
            oPath.bGoUp();
         }
      }
   } break;
   case tmpresfi_tclToken::EN_B32_TRAFFICMESSAGESOURCE:
   {
      fi_tcl_b32_TrafficMessageSource o_b32_TrafficMessageSource;
      if (!bDoIt(o_b32_TrafficMessageSource))
         return FALSE;
      oCallStack.bGoUp();
      oPath.bGoUp();
   } break;
   case tmpresfi_tclToken::EN_TMCODEDMESSAGE:
   {
      if (poVisitor->bDoExpand_TMCodedMessage(enSemanticDomain))
      {
         oPath.bGoUp();
         oPath.bGoDown(tmpresfi_tclKnot(tmpresfi_tclToken::EN_END_OF_STRUCT,tmpresfi_tclSemanticDomain::EN_UNKNOWN));
         oPath.bGoDown(tmpresfi_tclKnot(tmpresfi_tclToken::EN_RDBID,tmpresfi_tclSemanticDomain::EN_RDBID));
         if (38 <= u16MajorVersion)
         {
            oPath.bGoDown(tmpresfi_tclKnot(tmpresfi_tclToken::EN_TMEVENT,tmpresfi_tclSemanticDomain::EN_LIST_ELEMENT,0));
            oPath.bGoDown(tmpresfi_tclKnot(tmpresfi_tclToken::EN_LIST,tmpresfi_tclSemanticDomain::EN_EVENTS));
         }
         if (38 <= u16MajorVersion)
         {
            oPath.bGoDown(tmpresfi_tclKnot(tmpresfi_tclToken::EN_BOOL,tmpresfi_tclSemanticDomain::EN_BIDIRECTIONAL));
         }
         if (38 <= u16MajorVersion)
         {
            oPath.bGoDown(tmpresfi_tclKnot(tmpresfi_tclToken::EN_BOOL,tmpresfi_tclSemanticDomain::EN_DIRECTIONAGAINSTTMC));
         }
         if (38 <= u16MajorVersion)
         {
            oPath.bGoDown(tmpresfi_tclKnot(tmpresfi_tclToken::EN_U8,tmpresfi_tclSemanticDomain::EN_EXTENT));
         }
         if (38 <= u16MajorVersion)
         {
            oPath.bGoDown(tmpresfi_tclKnot(tmpresfi_tclToken::EN_E8_TMLOCATIONTYPE,tmpresfi_tclSemanticDomain::EN_PRIMARYLOCATIONTYPE));
         }
         if (38 <= u16MajorVersion)
         {
            oPath.bGoDown(tmpresfi_tclKnot(tmpresfi_tclToken::EN_U16,tmpresfi_tclSemanticDomain::EN_SECONDARYLOCATIONCODE));
         }
         if (38 <= u16MajorVersion)
         {
            oPath.bGoDown(tmpresfi_tclKnot(tmpresfi_tclToken::EN_U16,tmpresfi_tclSemanticDomain::EN_PRIMARYLOCATIONCODE));
         }
         if (u16MajorVersion <= 36)
         {
            oPath.bGoDown(tmpresfi_tclKnot(tmpresfi_tclToken::EN_U8,tmpresfi_tclSemanticDomain::EN_AVERAGESPEED));
         }
         if (u16MajorVersion <= 36)
         {
            oPath.bGoDown(tmpresfi_tclKnot(tmpresfi_tclToken::EN_U8,tmpresfi_tclSemanticDomain::EN_SPEEDLIMITADVICE));
         }
         if (u16MajorVersion <= 36)
         {
            oPath.bGoDown(tmpresfi_tclKnot(tmpresfi_tclToken::EN_U8,tmpresfi_tclSemanticDomain::EN_LENGTHINFOANDLABEL2));
         }
         if (u16MajorVersion <= 36)
         {
            oPath.bGoDown(tmpresfi_tclKnot(tmpresfi_tclToken::EN_U8,tmpresfi_tclSemanticDomain::EN_ROADNUMBERSUFFIX));
         }
         if (u16MajorVersion <= 36)
         {
            oPath.bGoDown(tmpresfi_tclKnot(tmpresfi_tclToken::EN_U16,tmpresfi_tclSemanticDomain::EN_ROADNUMBER));
         }
         if (u16MajorVersion <= 36)
         {
            oPath.bGoDown(tmpresfi_tclKnot(tmpresfi_tclToken::EN_U16,tmpresfi_tclSemanticDomain::EN_ROADCLASS));
         }
         if (u16MajorVersion <= 36)
         {
            oPath.bGoDown(tmpresfi_tclKnot(tmpresfi_tclToken::EN_E16_NAVIEVENTVALUE,tmpresfi_tclSemanticDomain::EN_ADDITIONALNEV7));
         }
         if (u16MajorVersion <= 36)
         {
            oPath.bGoDown(tmpresfi_tclKnot(tmpresfi_tclToken::EN_E16_NAVIEVENTVALUE,tmpresfi_tclSemanticDomain::EN_ADDITIONALNEV6));
         }
         if (u16MajorVersion <= 36)
         {
            oPath.bGoDown(tmpresfi_tclKnot(tmpresfi_tclToken::EN_E16_NAVIEVENTVALUE,tmpresfi_tclSemanticDomain::EN_ADDITIONALNEV5));
         }
         if (u16MajorVersion <= 36)
         {
            oPath.bGoDown(tmpresfi_tclKnot(tmpresfi_tclToken::EN_E16_NAVIEVENTVALUE,tmpresfi_tclSemanticDomain::EN_ADDITIONALNEV4));
         }
         if (u16MajorVersion <= 36)
         {
            oPath.bGoDown(tmpresfi_tclKnot(tmpresfi_tclToken::EN_E16_NAVIEVENTVALUE,tmpresfi_tclSemanticDomain::EN_ADDITIONALNEV3));
         }
         if (u16MajorVersion <= 36)
         {
            oPath.bGoDown(tmpresfi_tclKnot(tmpresfi_tclToken::EN_E16_NAVIEVENTVALUE,tmpresfi_tclSemanticDomain::EN_ADDITIONALNEV2));
         }
         if (u16MajorVersion <= 36)
         {
            oPath.bGoDown(tmpresfi_tclKnot(tmpresfi_tclToken::EN_E16_NAVIEVENTVALUE,tmpresfi_tclSemanticDomain::EN_ADDITIONALNEV1));
         }
         if (u16MajorVersion <= 36)
         {
            oPath.bGoDown(tmpresfi_tclKnot(tmpresfi_tclToken::EN_E16_NAVIEVENTVALUE,tmpresfi_tclSemanticDomain::EN_MAINNEV));
         }
         if (u16MajorVersion <= 36)
         {
            oPath.bGoDown(tmpresfi_tclKnot(tmpresfi_tclToken::EN_U8,tmpresfi_tclSemanticDomain::EN_DIRECTIONALITY));
         }
         if (u16MajorVersion <= 36)
         {
            oPath.bGoDown(tmpresfi_tclKnot(tmpresfi_tclToken::EN_U8,tmpresfi_tclSemanticDomain::EN_DIRANDEXTENT));
         }
         if (u16MajorVersion <= 36)
         {
            oPath.bGoDown(tmpresfi_tclKnot(tmpresfi_tclToken::EN_U8,tmpresfi_tclSemanticDomain::EN_LOCATIONTYPE));
         }
         if (u16MajorVersion <= 36)
         {
            oPath.bGoDown(tmpresfi_tclKnot(tmpresfi_tclToken::EN_U16,tmpresfi_tclSemanticDomain::EN_LOCATION2));
         }
         if (u16MajorVersion <= 36)
         {
            oPath.bGoDown(tmpresfi_tclKnot(tmpresfi_tclToken::EN_U16,tmpresfi_tclSemanticDomain::EN_LOCATION1));
         }
      }
      else
      {
         fi_tcl_TMCodedMessage o_TMCodedMessage;
         if (!bDoIt(o_TMCodedMessage))
         {
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
            o_TMCodedMessage.vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
            return FALSE;
         }
         else
         {
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
            o_TMCodedMessage.vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
            oCallStack.bGoUp();
            oPath.bGoUp();
         }
      }
   } break;
#ifndef FI_S_EXTERNAL_FI
   case tmpresfi_tclToken::EN_TMCODEDMESSAGEBINCONTAINER:
   {
      if (poVisitor->bDoExpand_TMCodedMessageBinContainer(enSemanticDomain))
      {
         oPath.bGoUp();
         bInsideBinContainerVersion = true;
         oPath.bGoDown(tmpresfi_tclKnot(tmpresfi_tclToken::EN_END_OF_STRUCT,tmpresfi_tclSemanticDomain::EN_BINCONTAINER));
         oPath.bGoDown(tmpresfi_tclKnot(tmpresfi_tclToken::EN_TMCODEDMESSAGE,tmpresfi_tclSemanticDomain::EN_TMCODEDMESSAGE));
         oPath.bGoDown(tmpresfi_tclKnot(tmpresfi_tclToken::EN_E8_BINCONTAINERTYPES,tmpresfi_tclSemanticDomain::EN_CONTAINERTYPE));
         oPath.bGoDown(tmpresfi_tclKnot(tmpresfi_tclToken::EN_FIVERSION,tmpresfi_tclSemanticDomain::EN_CONTAINERFIVERSION));
         oPath.bGoDown(tmpresfi_tclKnot(tmpresfi_tclToken::EN_U16,tmpresfi_tclSemanticDomain::EN_SERVICEID));
         oPath.bGoDown(tmpresfi_tclKnot(tmpresfi_tclToken::EN_U32,tmpresfi_tclSemanticDomain::EN_CONTAINERLENGTH));
      }
      else
      {
         fi_tcl_TMCodedMessageBinContainer o_TMCodedMessageBinContainer;
         if (!bDoIt(o_TMCodedMessageBinContainer))
         {
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
            o_TMCodedMessageBinContainer.vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
            return FALSE;
         }
         else
         {
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
            o_TMCodedMessageBinContainer.vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
            oCallStack.bGoUp();
            oPath.bGoUp();
         }
      }
   } break;
#endif // FI_S_EXTERNAL_FI
      case tmpresfi_tclToken::EN_UNKNOWN:
      case tmpresfi_tclToken::EN_LAST_TOKEN:         
      default:
         return FALSE;
      }
  }
  return bResult;
}

