/************************************************************************
 
 *FILE:           navifitypes.cpp
 
 *SW-COMPONENT:   NaviFI, Navigation Functional Interface
 
 *DESCRIPTION:    Interface fuer allgemeine Typdefinitionen des Nafi
                  
 *AUTHOR:         Jochen Bruns (CM-DI/ENS41)
 
 *COPYRIGHT:      (c) 2001 Blaupunkt GmbH
 
 ************************************************************************/

#include "precompiled.hh"
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
tmdatafi_tclMsgNavTima_RdbIdHandlingMethodStart::tmdatafi_tclMsgNavTima_RdbIdHandlingMethodStart(const tmdatafi_tclMsgNavTima_RdbIdHandlingMethodStart& coRef):fi_tclVisitableTypeBase(coRef)
{
   ListOfRdbIdLight = coRef.ListOfRdbIdLight;
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
tmdatafi_tclMsgNavTima_RdbIdHandlingMethodStart& tmdatafi_tclMsgNavTima_RdbIdHandlingMethodStart::operator=(const tmdatafi_tclMsgNavTima_RdbIdHandlingMethodStart& coRef)
{
   if (this == &coRef) return *this;
   ListOfRdbIdLight = coRef.ListOfRdbIdLight;
   return *this;
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
tU16 tmdatafi_tclMsgNavTima_RdbIdHandlingMethodStart::u16GetServiceID() const {return TMDATAFI_C_U16_SERVICE_ID;}
tU16 tmdatafi_tclMsgNavTima_RdbIdHandlingMethodStart::u16GetFunctionID() const {return TMDATAFI_C_U16_NAVTIMA_RDBIDHANDLING;}
tU8 tmdatafi_tclMsgNavTima_RdbIdHandlingMethodStart::u8GetOpCode() const {return CCA_C_U8_OPCODE_METHODSTART;}

tVoid tmdatafi_tclMsgNavTima_RdbIdHandlingMethodStart::vDestroy()
{
   {
      for (tU32 u32Idx = 0; u32Idx < ListOfRdbIdLight.size(); ++u32Idx)
         ListOfRdbIdLight[u32Idx].vDestroy();
   }
   ListOfRdbIdLight.clear();
}

tU32 tmdatafi_tclMsgNavTima_RdbIdHandlingMethodStart::u32GetSize(tU16 u16MajorVersion) const
{
   tU32 u32DynamicSize = 0;
   tU32 u32ListIdx;
   for (u32ListIdx = 0; u32ListIdx < ListOfRdbIdLight.size(); ++u32ListIdx)
      u32DynamicSize += ListOfRdbIdLight[u32ListIdx].u32GetSize(u16MajorVersion);
   return u32DynamicSize+4;
}

tBool tmdatafi_tclMsgNavTima_RdbIdHandlingMethodStart::operator==(const tmdatafi_tclMsgNavTima_RdbIdHandlingMethodStart& rfoCmp) const
{
   tBool bResult = true;
      bResult = bResult && (ListOfRdbIdLight.size() == rfoCmp.ListOfRdbIdLight.size());
      if (bResult)
      {
         for (tU32 u32Idx = 0; bResult && (u32Idx < ListOfRdbIdLight.size()); ++u32Idx)
            bResult = bResult && (ListOfRdbIdLight[u32Idx] == rfoCmp.ListOfRdbIdLight[u32Idx]);
      }
   return bResult;
}

fi_tclInContext& tmdatafi_tclMsgNavTima_RdbIdHandlingMethodStart::oRead(fi_tclInContext& oIn)
{
   {
      tU32 u32Length;
      tU32 u32Idx;
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
      for (u32Idx = 0; u32Idx < ListOfRdbIdLight.size(); ++u32Idx)
      {
         ListOfRdbIdLight[u32Idx].vDestroy();
      }
#endif // !VARIANT_S_FTR_ENABLE_DEEP_COPY
      oIn >> u32Length;
      ListOfRdbIdLight.resize(u32Length);
      for (u32Idx = 0; u32Idx < u32Length; ++u32Idx)
      {
         oIn >> ListOfRdbIdLight[u32Idx];
      }
   }
   return oIn;
}

fi_tclOutContext& tmdatafi_tclMsgNavTima_RdbIdHandlingMethodStart::oWrite(fi_tclOutContext& oOut) const
{
   oOut << (tU32)ListOfRdbIdLight.size();
   {
      for (tU32 u32Idx = 0; u32Idx < ListOfRdbIdLight.size(); ++u32Idx)
         oOut << ListOfRdbIdLight[u32Idx];
   }
   return oOut;
}

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
tmdatafi_tclMsgNavTima_RdbIdHandlingMethodResult::tmdatafi_tclMsgNavTima_RdbIdHandlingMethodResult(const tmdatafi_tclMsgNavTima_RdbIdHandlingMethodResult& coRef):fi_tclVisitableTypeBase(coRef)
{
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
tmdatafi_tclMsgNavTima_RdbIdHandlingMethodResult& tmdatafi_tclMsgNavTima_RdbIdHandlingMethodResult::operator=(const tmdatafi_tclMsgNavTima_RdbIdHandlingMethodResult& coRef)
{
   if (this == &coRef) return *this;
   return *this;
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
tU16 tmdatafi_tclMsgNavTima_RdbIdHandlingMethodResult::u16GetServiceID() const {return TMDATAFI_C_U16_SERVICE_ID;}
tU16 tmdatafi_tclMsgNavTima_RdbIdHandlingMethodResult::u16GetFunctionID() const {return TMDATAFI_C_U16_NAVTIMA_RDBIDHANDLING;}
tU8 tmdatafi_tclMsgNavTima_RdbIdHandlingMethodResult::u8GetOpCode() const {return CCA_C_U8_OPCODE_METHODRESULT;}

tU32 tmdatafi_tclMsgNavTima_RdbIdHandlingMethodResult::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 0;
}

tBool tmdatafi_tclMsgNavTima_RdbIdHandlingMethodResult::operator==(const tmdatafi_tclMsgNavTima_RdbIdHandlingMethodResult& /* rfoCmp */) const
{
   tBool bResult = true;
   return bResult;
}

fi_tclInContext& tmdatafi_tclMsgNavTima_RdbIdHandlingMethodResult::oRead(fi_tclInContext& oIn)
{
   return oIn;
}

fi_tclOutContext& tmdatafi_tclMsgNavTima_RdbIdHandlingMethodResult::oWrite(fi_tclOutContext& oOut) const
{
   return oOut;
}

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
tmdatafi_tclMsgNavTima_SetAbsFilterMethodStart::tmdatafi_tclMsgNavTima_SetAbsFilterMethodStart(const tmdatafi_tclMsgNavTima_SetAbsFilterMethodStart& coRef):fi_tclVisitableTypeBase(coRef)
{
   SwitchOnOff = coRef.SwitchOnOff;
   BottomLeft = coRef.BottomLeft;
   UpperRight = coRef.UpperRight;
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
tmdatafi_tclMsgNavTima_SetAbsFilterMethodStart& tmdatafi_tclMsgNavTima_SetAbsFilterMethodStart::operator=(const tmdatafi_tclMsgNavTima_SetAbsFilterMethodStart& coRef)
{
   if (this == &coRef) return *this;
   SwitchOnOff = coRef.SwitchOnOff;
   BottomLeft = coRef.BottomLeft;
   UpperRight = coRef.UpperRight;
   return *this;
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
tU16 tmdatafi_tclMsgNavTima_SetAbsFilterMethodStart::u16GetServiceID() const {return TMDATAFI_C_U16_SERVICE_ID;}
tU16 tmdatafi_tclMsgNavTima_SetAbsFilterMethodStart::u16GetFunctionID() const {return TMDATAFI_C_U16_NAVTIMA_SETABSFILTER;}
tU8 tmdatafi_tclMsgNavTima_SetAbsFilterMethodStart::u8GetOpCode() const {return CCA_C_U8_OPCODE_METHODSTART;}

tVoid tmdatafi_tclMsgNavTima_SetAbsFilterMethodStart::vDestroy()
{
   BottomLeft.vDestroy(); 
   UpperRight.vDestroy(); 
}

tU32 tmdatafi_tclMsgNavTima_SetAbsFilterMethodStart::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 17;
}

tBool tmdatafi_tclMsgNavTima_SetAbsFilterMethodStart::operator==(const tmdatafi_tclMsgNavTima_SetAbsFilterMethodStart& rfoCmp) const
{
   tBool bResult = true;
      bResult = bResult && (SwitchOnOff == rfoCmp.SwitchOnOff);
      bResult = bResult && (BottomLeft == rfoCmp.BottomLeft);
      bResult = bResult && (UpperRight == rfoCmp.UpperRight);
   return bResult;
}

fi_tclInContext& tmdatafi_tclMsgNavTima_SetAbsFilterMethodStart::oRead(fi_tclInContext& oIn)
{
   oIn >> SwitchOnOff;
   oIn >> BottomLeft;
   oIn >> UpperRight;
   return oIn;
}

fi_tclOutContext& tmdatafi_tclMsgNavTima_SetAbsFilterMethodStart::oWrite(fi_tclOutContext& oOut) const
{
   oOut << SwitchOnOff;
   oOut << BottomLeft;
   oOut << UpperRight;
   return oOut;
}

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
tmdatafi_tclMsgNavTima_SetAbsFilterMethodResult::tmdatafi_tclMsgNavTima_SetAbsFilterMethodResult(const tmdatafi_tclMsgNavTima_SetAbsFilterMethodResult& coRef):fi_tclVisitableTypeBase(coRef)
{
   FilterValid = coRef.FilterValid;
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
tmdatafi_tclMsgNavTima_SetAbsFilterMethodResult& tmdatafi_tclMsgNavTima_SetAbsFilterMethodResult::operator=(const tmdatafi_tclMsgNavTima_SetAbsFilterMethodResult& coRef)
{
   if (this == &coRef) return *this;
   FilterValid = coRef.FilterValid;
   return *this;
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
tU16 tmdatafi_tclMsgNavTima_SetAbsFilterMethodResult::u16GetServiceID() const {return TMDATAFI_C_U16_SERVICE_ID;}
tU16 tmdatafi_tclMsgNavTima_SetAbsFilterMethodResult::u16GetFunctionID() const {return TMDATAFI_C_U16_NAVTIMA_SETABSFILTER;}
tU8 tmdatafi_tclMsgNavTima_SetAbsFilterMethodResult::u8GetOpCode() const {return CCA_C_U8_OPCODE_METHODRESULT;}

tU32 tmdatafi_tclMsgNavTima_SetAbsFilterMethodResult::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 1;
}

tBool tmdatafi_tclMsgNavTima_SetAbsFilterMethodResult::operator==(const tmdatafi_tclMsgNavTima_SetAbsFilterMethodResult& rfoCmp) const
{
   tBool bResult = true;
      bResult = bResult && (FilterValid == rfoCmp.FilterValid);
   return bResult;
}

fi_tclInContext& tmdatafi_tclMsgNavTima_SetAbsFilterMethodResult::oRead(fi_tclInContext& oIn)
{
   oIn >> FilterValid;
   return oIn;
}

fi_tclOutContext& tmdatafi_tclMsgNavTima_SetAbsFilterMethodResult::oWrite(fi_tclOutContext& oOut) const
{
   oOut << FilterValid;
   return oOut;
}

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
tmdatafi_tclMsgNavTima_SetRelFilterMethodStart::tmdatafi_tclMsgNavTima_SetRelFilterMethodStart(const tmdatafi_tclMsgNavTima_SetRelFilterMethodStart& coRef):fi_tclVisitableTypeBase(coRef)
{
   SwitchOnOff = coRef.SwitchOnOff;
   Width = coRef.Width;
   Height = coRef.Height;
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
tmdatafi_tclMsgNavTima_SetRelFilterMethodStart& tmdatafi_tclMsgNavTima_SetRelFilterMethodStart::operator=(const tmdatafi_tclMsgNavTima_SetRelFilterMethodStart& coRef)
{
   if (this == &coRef) return *this;
   SwitchOnOff = coRef.SwitchOnOff;
   Width = coRef.Width;
   Height = coRef.Height;
   return *this;
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
tU16 tmdatafi_tclMsgNavTima_SetRelFilterMethodStart::u16GetServiceID() const {return TMDATAFI_C_U16_SERVICE_ID;}
tU16 tmdatafi_tclMsgNavTima_SetRelFilterMethodStart::u16GetFunctionID() const {return TMDATAFI_C_U16_NAVTIMA_SETRELFILTER;}
tU8 tmdatafi_tclMsgNavTima_SetRelFilterMethodStart::u8GetOpCode() const {return CCA_C_U8_OPCODE_METHODSTART;}

tU32 tmdatafi_tclMsgNavTima_SetRelFilterMethodStart::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 9;
}

tBool tmdatafi_tclMsgNavTima_SetRelFilterMethodStart::operator==(const tmdatafi_tclMsgNavTima_SetRelFilterMethodStart& rfoCmp) const
{
   tBool bResult = true;
      bResult = bResult && (SwitchOnOff == rfoCmp.SwitchOnOff);
      bResult = bResult && (Width == rfoCmp.Width);
      bResult = bResult && (Height == rfoCmp.Height);
   return bResult;
}

fi_tclInContext& tmdatafi_tclMsgNavTima_SetRelFilterMethodStart::oRead(fi_tclInContext& oIn)
{
   oIn >> SwitchOnOff;
   oIn >> Width;
   oIn >> Height;
   return oIn;
}

fi_tclOutContext& tmdatafi_tclMsgNavTima_SetRelFilterMethodStart::oWrite(fi_tclOutContext& oOut) const
{
   oOut << SwitchOnOff;
   oOut << Width;
   oOut << Height;
   return oOut;
}

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
tmdatafi_tclMsgNavTima_SetRelFilterMethodResult::tmdatafi_tclMsgNavTima_SetRelFilterMethodResult(const tmdatafi_tclMsgNavTima_SetRelFilterMethodResult& coRef):fi_tclVisitableTypeBase(coRef)
{
   FilterValid = coRef.FilterValid;
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
tmdatafi_tclMsgNavTima_SetRelFilterMethodResult& tmdatafi_tclMsgNavTima_SetRelFilterMethodResult::operator=(const tmdatafi_tclMsgNavTima_SetRelFilterMethodResult& coRef)
{
   if (this == &coRef) return *this;
   FilterValid = coRef.FilterValid;
   return *this;
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
tU16 tmdatafi_tclMsgNavTima_SetRelFilterMethodResult::u16GetServiceID() const {return TMDATAFI_C_U16_SERVICE_ID;}
tU16 tmdatafi_tclMsgNavTima_SetRelFilterMethodResult::u16GetFunctionID() const {return TMDATAFI_C_U16_NAVTIMA_SETRELFILTER;}
tU8 tmdatafi_tclMsgNavTima_SetRelFilterMethodResult::u8GetOpCode() const {return CCA_C_U8_OPCODE_METHODRESULT;}

tU32 tmdatafi_tclMsgNavTima_SetRelFilterMethodResult::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 1;
}

tBool tmdatafi_tclMsgNavTima_SetRelFilterMethodResult::operator==(const tmdatafi_tclMsgNavTima_SetRelFilterMethodResult& rfoCmp) const
{
   tBool bResult = true;
      bResult = bResult && (FilterValid == rfoCmp.FilterValid);
   return bResult;
}

fi_tclInContext& tmdatafi_tclMsgNavTima_SetRelFilterMethodResult::oRead(fi_tclInContext& oIn)
{
   oIn >> FilterValid;
   return oIn;
}

fi_tclOutContext& tmdatafi_tclMsgNavTima_SetRelFilterMethodResult::oWrite(fi_tclOutContext& oOut) const
{
   oOut << FilterValid;
   return oOut;
}

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
tmdatafi_tclMsgNavTima_SwitchAbsFilterMethodStart::tmdatafi_tclMsgNavTima_SwitchAbsFilterMethodStart(const tmdatafi_tclMsgNavTima_SwitchAbsFilterMethodStart& coRef):fi_tclVisitableTypeBase(coRef)
{
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
tmdatafi_tclMsgNavTima_SwitchAbsFilterMethodStart& tmdatafi_tclMsgNavTima_SwitchAbsFilterMethodStart::operator=(const tmdatafi_tclMsgNavTima_SwitchAbsFilterMethodStart& coRef)
{
   if (this == &coRef) return *this;
   return *this;
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
tU16 tmdatafi_tclMsgNavTima_SwitchAbsFilterMethodStart::u16GetServiceID() const {return TMDATAFI_C_U16_SERVICE_ID;}
tU16 tmdatafi_tclMsgNavTima_SwitchAbsFilterMethodStart::u16GetFunctionID() const {return TMDATAFI_C_U16_NAVTIMA_SWITCHABSFILTER;}
tU8 tmdatafi_tclMsgNavTima_SwitchAbsFilterMethodStart::u8GetOpCode() const {return CCA_C_U8_OPCODE_METHODSTART;}

tU32 tmdatafi_tclMsgNavTima_SwitchAbsFilterMethodStart::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 0;
}

tBool tmdatafi_tclMsgNavTima_SwitchAbsFilterMethodStart::operator==(const tmdatafi_tclMsgNavTima_SwitchAbsFilterMethodStart& /* rfoCmp */) const
{
   tBool bResult = true;
   return bResult;
}

fi_tclInContext& tmdatafi_tclMsgNavTima_SwitchAbsFilterMethodStart::oRead(fi_tclInContext& oIn)
{
   return oIn;
}

fi_tclOutContext& tmdatafi_tclMsgNavTima_SwitchAbsFilterMethodStart::oWrite(fi_tclOutContext& oOut) const
{
   return oOut;
}

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
tmdatafi_tclMsgNavTima_SwitchAbsFilterMethodResult::tmdatafi_tclMsgNavTima_SwitchAbsFilterMethodResult(const tmdatafi_tclMsgNavTima_SwitchAbsFilterMethodResult& coRef):fi_tclVisitableTypeBase(coRef)
{
   FilterSwitched = coRef.FilterSwitched;
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
tmdatafi_tclMsgNavTima_SwitchAbsFilterMethodResult& tmdatafi_tclMsgNavTima_SwitchAbsFilterMethodResult::operator=(const tmdatafi_tclMsgNavTima_SwitchAbsFilterMethodResult& coRef)
{
   if (this == &coRef) return *this;
   FilterSwitched = coRef.FilterSwitched;
   return *this;
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
tU16 tmdatafi_tclMsgNavTima_SwitchAbsFilterMethodResult::u16GetServiceID() const {return TMDATAFI_C_U16_SERVICE_ID;}
tU16 tmdatafi_tclMsgNavTima_SwitchAbsFilterMethodResult::u16GetFunctionID() const {return TMDATAFI_C_U16_NAVTIMA_SWITCHABSFILTER;}
tU8 tmdatafi_tclMsgNavTima_SwitchAbsFilterMethodResult::u8GetOpCode() const {return CCA_C_U8_OPCODE_METHODRESULT;}

tU32 tmdatafi_tclMsgNavTima_SwitchAbsFilterMethodResult::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 1;
}

tBool tmdatafi_tclMsgNavTima_SwitchAbsFilterMethodResult::operator==(const tmdatafi_tclMsgNavTima_SwitchAbsFilterMethodResult& rfoCmp) const
{
   tBool bResult = true;
      bResult = bResult && (FilterSwitched == rfoCmp.FilterSwitched);
   return bResult;
}

fi_tclInContext& tmdatafi_tclMsgNavTima_SwitchAbsFilterMethodResult::oRead(fi_tclInContext& oIn)
{
   oIn >> FilterSwitched;
   return oIn;
}

fi_tclOutContext& tmdatafi_tclMsgNavTima_SwitchAbsFilterMethodResult::oWrite(fi_tclOutContext& oOut) const
{
   oOut << FilterSwitched;
   return oOut;
}

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
tmdatafi_tclMsgNavTima_SwitchRelFilterMethodStart::tmdatafi_tclMsgNavTima_SwitchRelFilterMethodStart(const tmdatafi_tclMsgNavTima_SwitchRelFilterMethodStart& coRef):fi_tclVisitableTypeBase(coRef)
{
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
tmdatafi_tclMsgNavTima_SwitchRelFilterMethodStart& tmdatafi_tclMsgNavTima_SwitchRelFilterMethodStart::operator=(const tmdatafi_tclMsgNavTima_SwitchRelFilterMethodStart& coRef)
{
   if (this == &coRef) return *this;
   return *this;
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
tU16 tmdatafi_tclMsgNavTima_SwitchRelFilterMethodStart::u16GetServiceID() const {return TMDATAFI_C_U16_SERVICE_ID;}
tU16 tmdatafi_tclMsgNavTima_SwitchRelFilterMethodStart::u16GetFunctionID() const {return TMDATAFI_C_U16_NAVTIMA_SWITCHRELFILTER;}
tU8 tmdatafi_tclMsgNavTima_SwitchRelFilterMethodStart::u8GetOpCode() const {return CCA_C_U8_OPCODE_METHODSTART;}

tU32 tmdatafi_tclMsgNavTima_SwitchRelFilterMethodStart::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 0;
}

tBool tmdatafi_tclMsgNavTima_SwitchRelFilterMethodStart::operator==(const tmdatafi_tclMsgNavTima_SwitchRelFilterMethodStart& /* rfoCmp */) const
{
   tBool bResult = true;
   return bResult;
}

fi_tclInContext& tmdatafi_tclMsgNavTima_SwitchRelFilterMethodStart::oRead(fi_tclInContext& oIn)
{
   return oIn;
}

fi_tclOutContext& tmdatafi_tclMsgNavTima_SwitchRelFilterMethodStart::oWrite(fi_tclOutContext& oOut) const
{
   return oOut;
}

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
tmdatafi_tclMsgNavTima_SwitchRelFilterMethodResult::tmdatafi_tclMsgNavTima_SwitchRelFilterMethodResult(const tmdatafi_tclMsgNavTima_SwitchRelFilterMethodResult& coRef):fi_tclVisitableTypeBase(coRef)
{
   FilterSwitched = coRef.FilterSwitched;
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
tmdatafi_tclMsgNavTima_SwitchRelFilterMethodResult& tmdatafi_tclMsgNavTima_SwitchRelFilterMethodResult::operator=(const tmdatafi_tclMsgNavTima_SwitchRelFilterMethodResult& coRef)
{
   if (this == &coRef) return *this;
   FilterSwitched = coRef.FilterSwitched;
   return *this;
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
tU16 tmdatafi_tclMsgNavTima_SwitchRelFilterMethodResult::u16GetServiceID() const {return TMDATAFI_C_U16_SERVICE_ID;}
tU16 tmdatafi_tclMsgNavTima_SwitchRelFilterMethodResult::u16GetFunctionID() const {return TMDATAFI_C_U16_NAVTIMA_SWITCHRELFILTER;}
tU8 tmdatafi_tclMsgNavTima_SwitchRelFilterMethodResult::u8GetOpCode() const {return CCA_C_U8_OPCODE_METHODRESULT;}

tU32 tmdatafi_tclMsgNavTima_SwitchRelFilterMethodResult::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 1;
}

tBool tmdatafi_tclMsgNavTima_SwitchRelFilterMethodResult::operator==(const tmdatafi_tclMsgNavTima_SwitchRelFilterMethodResult& rfoCmp) const
{
   tBool bResult = true;
      bResult = bResult && (FilterSwitched == rfoCmp.FilterSwitched);
   return bResult;
}

fi_tclInContext& tmdatafi_tclMsgNavTima_SwitchRelFilterMethodResult::oRead(fi_tclInContext& oIn)
{
   oIn >> FilterSwitched;
   return oIn;
}

fi_tclOutContext& tmdatafi_tclMsgNavTima_SwitchRelFilterMethodResult::oWrite(fi_tclOutContext& oOut) const
{
   oOut << FilterSwitched;
   return oOut;
}

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
tmdatafi_tclMsgNavTima_MessageMemoryMethodStart::tmdatafi_tclMsgNavTima_MessageMemoryMethodStart(const tmdatafi_tclMsgNavTima_MessageMemoryMethodStart& coRef):fi_tclVisitableTypeBase(coRef)
{
   MsgMemMajorId = coRef.MsgMemMajorId;
   MsgMemMinorId = coRef.MsgMemMinorId;
   ForceAlignment = coRef.ForceAlignment;
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
tmdatafi_tclMsgNavTima_MessageMemoryMethodStart& tmdatafi_tclMsgNavTima_MessageMemoryMethodStart::operator=(const tmdatafi_tclMsgNavTima_MessageMemoryMethodStart& coRef)
{
   if (this == &coRef) return *this;
   MsgMemMajorId = coRef.MsgMemMajorId;
   MsgMemMinorId = coRef.MsgMemMinorId;
   ForceAlignment = coRef.ForceAlignment;
   return *this;
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
tU16 tmdatafi_tclMsgNavTima_MessageMemoryMethodStart::u16GetServiceID() const {return TMDATAFI_C_U16_SERVICE_ID;}
tU16 tmdatafi_tclMsgNavTima_MessageMemoryMethodStart::u16GetFunctionID() const {return TMDATAFI_C_U16_NAVTIMA_MESSAGEMEMORY;}
tU8 tmdatafi_tclMsgNavTima_MessageMemoryMethodStart::u8GetOpCode() const {return CCA_C_U8_OPCODE_METHODSTART;}

tU32 tmdatafi_tclMsgNavTima_MessageMemoryMethodStart::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 9;
}

tBool tmdatafi_tclMsgNavTima_MessageMemoryMethodStart::operator==(const tmdatafi_tclMsgNavTima_MessageMemoryMethodStart& rfoCmp) const
{
   tBool bResult = true;
      bResult = bResult && (MsgMemMajorId == rfoCmp.MsgMemMajorId);
      bResult = bResult && (MsgMemMinorId == rfoCmp.MsgMemMinorId);
      bResult = bResult && (ForceAlignment == rfoCmp.ForceAlignment);
   return bResult;
}

fi_tclInContext& tmdatafi_tclMsgNavTima_MessageMemoryMethodStart::oRead(fi_tclInContext& oIn)
{
   oIn >> MsgMemMajorId;
   oIn >> MsgMemMinorId;
   oIn >> ForceAlignment;
   return oIn;
}

fi_tclOutContext& tmdatafi_tclMsgNavTima_MessageMemoryMethodStart::oWrite(fi_tclOutContext& oOut) const
{
   oOut << MsgMemMajorId;
   oOut << MsgMemMinorId;
   oOut << ForceAlignment;
   return oOut;
}

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
tmdatafi_tclMsgNavTima_MessageMemoryMethodResult::tmdatafi_tclMsgNavTima_MessageMemoryMethodResult(const tmdatafi_tclMsgNavTima_MessageMemoryMethodResult& coRef):fi_tclVisitableTypeBase(coRef)
{
   AmountOfSelectedMessages = coRef.AmountOfSelectedMessages;
   MsgMemMajorId = coRef.MsgMemMajorId;
   MsgMemMinorId = coRef.MsgMemMinorId;
   AlignmentTriggered = coRef.AlignmentTriggered;
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
tmdatafi_tclMsgNavTima_MessageMemoryMethodResult& tmdatafi_tclMsgNavTima_MessageMemoryMethodResult::operator=(const tmdatafi_tclMsgNavTima_MessageMemoryMethodResult& coRef)
{
   if (this == &coRef) return *this;
   AmountOfSelectedMessages = coRef.AmountOfSelectedMessages;
   MsgMemMajorId = coRef.MsgMemMajorId;
   MsgMemMinorId = coRef.MsgMemMinorId;
   AlignmentTriggered = coRef.AlignmentTriggered;
   return *this;
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
tU16 tmdatafi_tclMsgNavTima_MessageMemoryMethodResult::u16GetServiceID() const {return TMDATAFI_C_U16_SERVICE_ID;}
tU16 tmdatafi_tclMsgNavTima_MessageMemoryMethodResult::u16GetFunctionID() const {return TMDATAFI_C_U16_NAVTIMA_MESSAGEMEMORY;}
tU8 tmdatafi_tclMsgNavTima_MessageMemoryMethodResult::u8GetOpCode() const {return CCA_C_U8_OPCODE_METHODRESULT;}

tU32 tmdatafi_tclMsgNavTima_MessageMemoryMethodResult::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 11;
}

tBool tmdatafi_tclMsgNavTima_MessageMemoryMethodResult::operator==(const tmdatafi_tclMsgNavTima_MessageMemoryMethodResult& rfoCmp) const
{
   tBool bResult = true;
      bResult = bResult && (AmountOfSelectedMessages == rfoCmp.AmountOfSelectedMessages);
      bResult = bResult && (MsgMemMajorId == rfoCmp.MsgMemMajorId);
      bResult = bResult && (MsgMemMinorId == rfoCmp.MsgMemMinorId);
      bResult = bResult && (AlignmentTriggered == rfoCmp.AlignmentTriggered);
   return bResult;
}

fi_tclInContext& tmdatafi_tclMsgNavTima_MessageMemoryMethodResult::oRead(fi_tclInContext& oIn)
{
   oIn >> AmountOfSelectedMessages;
   oIn >> MsgMemMajorId;
   oIn >> MsgMemMinorId;
   oIn >> AlignmentTriggered;
   return oIn;
}

fi_tclOutContext& tmdatafi_tclMsgNavTima_MessageMemoryMethodResult::oWrite(fi_tclOutContext& oOut) const
{
   oOut << AmountOfSelectedMessages;
   oOut << MsgMemMajorId;
   oOut << MsgMemMinorId;
   oOut << AlignmentTriggered;
   return oOut;
}

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
tmdatafi_tclMsgNavTima_ResetMethodStart::tmdatafi_tclMsgNavTima_ResetMethodStart(const tmdatafi_tclMsgNavTima_ResetMethodStart& coRef):fi_tclVisitableTypeBase(coRef)
{
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
tmdatafi_tclMsgNavTima_ResetMethodStart& tmdatafi_tclMsgNavTima_ResetMethodStart::operator=(const tmdatafi_tclMsgNavTima_ResetMethodStart& coRef)
{
   if (this == &coRef) return *this;
   return *this;
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
tU16 tmdatafi_tclMsgNavTima_ResetMethodStart::u16GetServiceID() const {return TMDATAFI_C_U16_SERVICE_ID;}
tU16 tmdatafi_tclMsgNavTima_ResetMethodStart::u16GetFunctionID() const {return TMDATAFI_C_U16_NAVTIMA_RESET;}
tU8 tmdatafi_tclMsgNavTima_ResetMethodStart::u8GetOpCode() const {return CCA_C_U8_OPCODE_METHODSTART;}

tU32 tmdatafi_tclMsgNavTima_ResetMethodStart::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 0;
}

tBool tmdatafi_tclMsgNavTima_ResetMethodStart::operator==(const tmdatafi_tclMsgNavTima_ResetMethodStart& /* rfoCmp */) const
{
   tBool bResult = true;
   return bResult;
}

fi_tclInContext& tmdatafi_tclMsgNavTima_ResetMethodStart::oRead(fi_tclInContext& oIn)
{
   return oIn;
}

fi_tclOutContext& tmdatafi_tclMsgNavTima_ResetMethodStart::oWrite(fi_tclOutContext& oOut) const
{
   return oOut;
}

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
tmdatafi_tclMsgNavTima_ResetMethodResult::tmdatafi_tclMsgNavTima_ResetMethodResult(const tmdatafi_tclMsgNavTima_ResetMethodResult& coRef):fi_tclVisitableTypeBase(coRef)
{
   ResetSucceed = coRef.ResetSucceed;
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
tmdatafi_tclMsgNavTima_ResetMethodResult& tmdatafi_tclMsgNavTima_ResetMethodResult::operator=(const tmdatafi_tclMsgNavTima_ResetMethodResult& coRef)
{
   if (this == &coRef) return *this;
   ResetSucceed = coRef.ResetSucceed;
   return *this;
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
tU16 tmdatafi_tclMsgNavTima_ResetMethodResult::u16GetServiceID() const {return TMDATAFI_C_U16_SERVICE_ID;}
tU16 tmdatafi_tclMsgNavTima_ResetMethodResult::u16GetFunctionID() const {return TMDATAFI_C_U16_NAVTIMA_RESET;}
tU8 tmdatafi_tclMsgNavTima_ResetMethodResult::u8GetOpCode() const {return CCA_C_U8_OPCODE_METHODRESULT;}

tU32 tmdatafi_tclMsgNavTima_ResetMethodResult::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 1;
}

tBool tmdatafi_tclMsgNavTima_ResetMethodResult::operator==(const tmdatafi_tclMsgNavTima_ResetMethodResult& rfoCmp) const
{
   tBool bResult = true;
      bResult = bResult && (ResetSucceed == rfoCmp.ResetSucceed);
   return bResult;
}

fi_tclInContext& tmdatafi_tclMsgNavTima_ResetMethodResult::oRead(fi_tclInContext& oIn)
{
   oIn >> ResetSucceed;
   return oIn;
}

fi_tclOutContext& tmdatafi_tclMsgNavTima_ResetMethodResult::oWrite(fi_tclOutContext& oOut) const
{
   oOut << ResetSucceed;
   return oOut;
}

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
tmdatafi_tclMsgNavTima_StatusGet::tmdatafi_tclMsgNavTima_StatusGet(const tmdatafi_tclMsgNavTima_StatusGet& coRef):fi_tclVisitableTypeBase(coRef)
{
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
tmdatafi_tclMsgNavTima_StatusGet& tmdatafi_tclMsgNavTima_StatusGet::operator=(const tmdatafi_tclMsgNavTima_StatusGet& coRef)
{
   if (this == &coRef) return *this;
   return *this;
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
tU16 tmdatafi_tclMsgNavTima_StatusGet::u16GetServiceID() const {return TMDATAFI_C_U16_SERVICE_ID;}
tU16 tmdatafi_tclMsgNavTima_StatusGet::u16GetFunctionID() const {return TMDATAFI_C_U16_NAVTIMA_STATUS;}
tU8 tmdatafi_tclMsgNavTima_StatusGet::u8GetOpCode() const {return CCA_C_U8_OPCODE_GET;}

tU32 tmdatafi_tclMsgNavTima_StatusGet::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 0;
}

tBool tmdatafi_tclMsgNavTima_StatusGet::operator==(const tmdatafi_tclMsgNavTima_StatusGet& /* rfoCmp */) const
{
   tBool bResult = true;
   return bResult;
}

fi_tclInContext& tmdatafi_tclMsgNavTima_StatusGet::oRead(fi_tclInContext& oIn)
{
   return oIn;
}

fi_tclOutContext& tmdatafi_tclMsgNavTima_StatusGet::oWrite(fi_tclOutContext& oOut) const
{
   return oOut;
}

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
tmdatafi_tclMsgNavTima_StatusUpReg::tmdatafi_tclMsgNavTima_StatusUpReg(const tmdatafi_tclMsgNavTima_StatusUpReg& coRef):fi_tclVisitableTypeBase(coRef)
{
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
tmdatafi_tclMsgNavTima_StatusUpReg& tmdatafi_tclMsgNavTima_StatusUpReg::operator=(const tmdatafi_tclMsgNavTima_StatusUpReg& coRef)
{
   if (this == &coRef) return *this;
   return *this;
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
tU16 tmdatafi_tclMsgNavTima_StatusUpReg::u16GetServiceID() const {return TMDATAFI_C_U16_SERVICE_ID;}
tU16 tmdatafi_tclMsgNavTima_StatusUpReg::u16GetFunctionID() const {return TMDATAFI_C_U16_NAVTIMA_STATUS;}
tU8 tmdatafi_tclMsgNavTima_StatusUpReg::u8GetOpCode() const {return CCA_C_U8_OPCODE_UPREG;}

tU32 tmdatafi_tclMsgNavTima_StatusUpReg::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 0;
}

tBool tmdatafi_tclMsgNavTima_StatusUpReg::operator==(const tmdatafi_tclMsgNavTima_StatusUpReg& /* rfoCmp */) const
{
   tBool bResult = true;
   return bResult;
}

fi_tclInContext& tmdatafi_tclMsgNavTima_StatusUpReg::oRead(fi_tclInContext& oIn)
{
   return oIn;
}

fi_tclOutContext& tmdatafi_tclMsgNavTima_StatusUpReg::oWrite(fi_tclOutContext& oOut) const
{
   return oOut;
}

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
tmdatafi_tclMsgNavTima_StatusRelUpReg::tmdatafi_tclMsgNavTima_StatusRelUpReg(const tmdatafi_tclMsgNavTima_StatusRelUpReg& coRef):fi_tclVisitableTypeBase(coRef)
{
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
tmdatafi_tclMsgNavTima_StatusRelUpReg& tmdatafi_tclMsgNavTima_StatusRelUpReg::operator=(const tmdatafi_tclMsgNavTima_StatusRelUpReg& coRef)
{
   if (this == &coRef) return *this;
   return *this;
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
tU16 tmdatafi_tclMsgNavTima_StatusRelUpReg::u16GetServiceID() const {return TMDATAFI_C_U16_SERVICE_ID;}
tU16 tmdatafi_tclMsgNavTima_StatusRelUpReg::u16GetFunctionID() const {return TMDATAFI_C_U16_NAVTIMA_STATUS;}
tU8 tmdatafi_tclMsgNavTima_StatusRelUpReg::u8GetOpCode() const {return CCA_C_U8_OPCODE_RELUPREG;}

tU32 tmdatafi_tclMsgNavTima_StatusRelUpReg::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 0;
}

tBool tmdatafi_tclMsgNavTima_StatusRelUpReg::operator==(const tmdatafi_tclMsgNavTima_StatusRelUpReg& /* rfoCmp */) const
{
   tBool bResult = true;
   return bResult;
}

fi_tclInContext& tmdatafi_tclMsgNavTima_StatusRelUpReg::oRead(fi_tclInContext& oIn)
{
   return oIn;
}

fi_tclOutContext& tmdatafi_tclMsgNavTima_StatusRelUpReg::oWrite(fi_tclOutContext& oOut) const
{
   return oOut;
}

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
tmdatafi_tclMsgNavTima_StatusStatus::tmdatafi_tclMsgNavTima_StatusStatus(const tmdatafi_tclMsgNavTima_StatusStatus& coRef):fi_tclVisitableTypeBase(coRef)
{
   TIMAStatus = coRef.TIMAStatus;
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
tmdatafi_tclMsgNavTima_StatusStatus& tmdatafi_tclMsgNavTima_StatusStatus::operator=(const tmdatafi_tclMsgNavTima_StatusStatus& coRef)
{
   if (this == &coRef) return *this;
   TIMAStatus = coRef.TIMAStatus;
   return *this;
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
tU16 tmdatafi_tclMsgNavTima_StatusStatus::u16GetServiceID() const {return TMDATAFI_C_U16_SERVICE_ID;}
tU16 tmdatafi_tclMsgNavTima_StatusStatus::u16GetFunctionID() const {return TMDATAFI_C_U16_NAVTIMA_STATUS;}
tU8 tmdatafi_tclMsgNavTima_StatusStatus::u8GetOpCode() const {return CCA_C_U8_OPCODE_STATUS;}

tU32 tmdatafi_tclMsgNavTima_StatusStatus::u32GetSize(tU16 u16MajorVersion) const
{
   tU32 u32DynamicSize = 0;
   if (u16MajorVersion <= 36)
   {
      u32DynamicSize += 4;
   }
   return u32DynamicSize+0;
}

tBool tmdatafi_tclMsgNavTima_StatusStatus::operator==(const tmdatafi_tclMsgNavTima_StatusStatus& rfoCmp) const
{
   tBool bResult = true;
      bResult = bResult && (TIMAStatus == rfoCmp.TIMAStatus);
   return bResult;
}

fi_tclInContext& tmdatafi_tclMsgNavTima_StatusStatus::oRead(fi_tclInContext& oIn)
{
   if (oIn.u16GetMajorVersion() <= 36)
   {
      oIn >> TIMAStatus;
   }
   return oIn;
}

fi_tclOutContext& tmdatafi_tclMsgNavTima_StatusStatus::oWrite(fi_tclOutContext& oOut) const
{
   if (oOut.u16GetMajorVersion() <= 36)
   {
      oOut << TIMAStatus;
   }
   return oOut;
}

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
tmdatafi_tclMsgNavTima_RdbIdNotificationUpReg::tmdatafi_tclMsgNavTima_RdbIdNotificationUpReg(const tmdatafi_tclMsgNavTima_RdbIdNotificationUpReg& coRef):fi_tclVisitableTypeBase(coRef)
{
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
tmdatafi_tclMsgNavTima_RdbIdNotificationUpReg& tmdatafi_tclMsgNavTima_RdbIdNotificationUpReg::operator=(const tmdatafi_tclMsgNavTima_RdbIdNotificationUpReg& coRef)
{
   if (this == &coRef) return *this;
   return *this;
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
tU16 tmdatafi_tclMsgNavTima_RdbIdNotificationUpReg::u16GetServiceID() const {return TMDATAFI_C_U16_SERVICE_ID;}
tU16 tmdatafi_tclMsgNavTima_RdbIdNotificationUpReg::u16GetFunctionID() const {return TMDATAFI_C_U16_NAVTIMA_RDBIDNOTIFICATION;}
tU8 tmdatafi_tclMsgNavTima_RdbIdNotificationUpReg::u8GetOpCode() const {return CCA_C_U8_OPCODE_UPREG;}

tU32 tmdatafi_tclMsgNavTima_RdbIdNotificationUpReg::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 0;
}

tBool tmdatafi_tclMsgNavTima_RdbIdNotificationUpReg::operator==(const tmdatafi_tclMsgNavTima_RdbIdNotificationUpReg& /* rfoCmp */) const
{
   tBool bResult = true;
   return bResult;
}

fi_tclInContext& tmdatafi_tclMsgNavTima_RdbIdNotificationUpReg::oRead(fi_tclInContext& oIn)
{
   return oIn;
}

fi_tclOutContext& tmdatafi_tclMsgNavTima_RdbIdNotificationUpReg::oWrite(fi_tclOutContext& oOut) const
{
   return oOut;
}

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
tmdatafi_tclMsgNavTima_RdbIdNotificationRelUpReg::tmdatafi_tclMsgNavTima_RdbIdNotificationRelUpReg(const tmdatafi_tclMsgNavTima_RdbIdNotificationRelUpReg& coRef):fi_tclVisitableTypeBase(coRef)
{
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
tmdatafi_tclMsgNavTima_RdbIdNotificationRelUpReg& tmdatafi_tclMsgNavTima_RdbIdNotificationRelUpReg::operator=(const tmdatafi_tclMsgNavTima_RdbIdNotificationRelUpReg& coRef)
{
   if (this == &coRef) return *this;
   return *this;
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
tU16 tmdatafi_tclMsgNavTima_RdbIdNotificationRelUpReg::u16GetServiceID() const {return TMDATAFI_C_U16_SERVICE_ID;}
tU16 tmdatafi_tclMsgNavTima_RdbIdNotificationRelUpReg::u16GetFunctionID() const {return TMDATAFI_C_U16_NAVTIMA_RDBIDNOTIFICATION;}
tU8 tmdatafi_tclMsgNavTima_RdbIdNotificationRelUpReg::u8GetOpCode() const {return CCA_C_U8_OPCODE_RELUPREG;}

tU32 tmdatafi_tclMsgNavTima_RdbIdNotificationRelUpReg::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 0;
}

tBool tmdatafi_tclMsgNavTima_RdbIdNotificationRelUpReg::operator==(const tmdatafi_tclMsgNavTima_RdbIdNotificationRelUpReg& /* rfoCmp */) const
{
   tBool bResult = true;
   return bResult;
}

fi_tclInContext& tmdatafi_tclMsgNavTima_RdbIdNotificationRelUpReg::oRead(fi_tclInContext& oIn)
{
   return oIn;
}

fi_tclOutContext& tmdatafi_tclMsgNavTima_RdbIdNotificationRelUpReg::oWrite(fi_tclOutContext& oOut) const
{
   return oOut;
}

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
tmdatafi_tclMsgNavTima_RdbIdNotificationStatus::tmdatafi_tclMsgNavTima_RdbIdNotificationStatus(const tmdatafi_tclMsgNavTima_RdbIdNotificationStatus& coRef):fi_tclVisitableTypeBase(coRef)
{
   ListOfRdbIdsLight = coRef.ListOfRdbIdsLight;
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
tmdatafi_tclMsgNavTima_RdbIdNotificationStatus& tmdatafi_tclMsgNavTima_RdbIdNotificationStatus::operator=(const tmdatafi_tclMsgNavTima_RdbIdNotificationStatus& coRef)
{
   if (this == &coRef) return *this;
   ListOfRdbIdsLight = coRef.ListOfRdbIdsLight;
   return *this;
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
tU16 tmdatafi_tclMsgNavTima_RdbIdNotificationStatus::u16GetServiceID() const {return TMDATAFI_C_U16_SERVICE_ID;}
tU16 tmdatafi_tclMsgNavTima_RdbIdNotificationStatus::u16GetFunctionID() const {return TMDATAFI_C_U16_NAVTIMA_RDBIDNOTIFICATION;}
tU8 tmdatafi_tclMsgNavTima_RdbIdNotificationStatus::u8GetOpCode() const {return CCA_C_U8_OPCODE_STATUS;}

tVoid tmdatafi_tclMsgNavTima_RdbIdNotificationStatus::vDestroy()
{
   {
      for (tU32 u32Idx = 0; u32Idx < ListOfRdbIdsLight.size(); ++u32Idx)
         ListOfRdbIdsLight[u32Idx].vDestroy();
   }
   ListOfRdbIdsLight.clear();
}

tU32 tmdatafi_tclMsgNavTima_RdbIdNotificationStatus::u32GetSize(tU16 u16MajorVersion) const
{
   tU32 u32DynamicSize = 0;
   tU32 u32ListIdx;
   for (u32ListIdx = 0; u32ListIdx < ListOfRdbIdsLight.size(); ++u32ListIdx)
      u32DynamicSize += ListOfRdbIdsLight[u32ListIdx].u32GetSize(u16MajorVersion);
   return u32DynamicSize+4;
}

tBool tmdatafi_tclMsgNavTima_RdbIdNotificationStatus::operator==(const tmdatafi_tclMsgNavTima_RdbIdNotificationStatus& rfoCmp) const
{
   tBool bResult = true;
      bResult = bResult && (ListOfRdbIdsLight.size() == rfoCmp.ListOfRdbIdsLight.size());
      if (bResult)
      {
         for (tU32 u32Idx = 0; bResult && (u32Idx < ListOfRdbIdsLight.size()); ++u32Idx)
            bResult = bResult && (ListOfRdbIdsLight[u32Idx] == rfoCmp.ListOfRdbIdsLight[u32Idx]);
      }
   return bResult;
}

fi_tclInContext& tmdatafi_tclMsgNavTima_RdbIdNotificationStatus::oRead(fi_tclInContext& oIn)
{
   {
      tU32 u32Length;
      tU32 u32Idx;
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
      for (u32Idx = 0; u32Idx < ListOfRdbIdsLight.size(); ++u32Idx)
      {
         ListOfRdbIdsLight[u32Idx].vDestroy();
      }
#endif // !VARIANT_S_FTR_ENABLE_DEEP_COPY
      oIn >> u32Length;
      ListOfRdbIdsLight.resize(u32Length);
      for (u32Idx = 0; u32Idx < u32Length; ++u32Idx)
      {
         oIn >> ListOfRdbIdsLight[u32Idx];
      }
   }
   return oIn;
}

fi_tclOutContext& tmdatafi_tclMsgNavTima_RdbIdNotificationStatus::oWrite(fi_tclOutContext& oOut) const
{
   oOut << (tU32)ListOfRdbIdsLight.size();
   {
      for (tU32 u32Idx = 0; u32Idx < ListOfRdbIdsLight.size(); ++u32Idx)
         oOut << ListOfRdbIdsLight[u32Idx];
   }
   return oOut;
}

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
tmdatafi_tclMsgNavTima_CurrentRdbIdAvailabilityUpReg::tmdatafi_tclMsgNavTima_CurrentRdbIdAvailabilityUpReg(const tmdatafi_tclMsgNavTima_CurrentRdbIdAvailabilityUpReg& coRef):fi_tclVisitableTypeBase(coRef)
{
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
tmdatafi_tclMsgNavTima_CurrentRdbIdAvailabilityUpReg& tmdatafi_tclMsgNavTima_CurrentRdbIdAvailabilityUpReg::operator=(const tmdatafi_tclMsgNavTima_CurrentRdbIdAvailabilityUpReg& coRef)
{
   if (this == &coRef) return *this;
   return *this;
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
tU16 tmdatafi_tclMsgNavTima_CurrentRdbIdAvailabilityUpReg::u16GetServiceID() const {return TMDATAFI_C_U16_SERVICE_ID;}
tU16 tmdatafi_tclMsgNavTima_CurrentRdbIdAvailabilityUpReg::u16GetFunctionID() const {return TMDATAFI_C_U16_NAVTIMA_CURRENTRDBIDAVAILABILITY;}
tU8 tmdatafi_tclMsgNavTima_CurrentRdbIdAvailabilityUpReg::u8GetOpCode() const {return CCA_C_U8_OPCODE_UPREG;}

tU32 tmdatafi_tclMsgNavTima_CurrentRdbIdAvailabilityUpReg::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 0;
}

tBool tmdatafi_tclMsgNavTima_CurrentRdbIdAvailabilityUpReg::operator==(const tmdatafi_tclMsgNavTima_CurrentRdbIdAvailabilityUpReg& /* rfoCmp */) const
{
   tBool bResult = true;
   return bResult;
}

fi_tclInContext& tmdatafi_tclMsgNavTima_CurrentRdbIdAvailabilityUpReg::oRead(fi_tclInContext& oIn)
{
   return oIn;
}

fi_tclOutContext& tmdatafi_tclMsgNavTima_CurrentRdbIdAvailabilityUpReg::oWrite(fi_tclOutContext& oOut) const
{
   return oOut;
}

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
tmdatafi_tclMsgNavTima_CurrentRdbIdAvailabilityRelUpReg::tmdatafi_tclMsgNavTima_CurrentRdbIdAvailabilityRelUpReg(const tmdatafi_tclMsgNavTima_CurrentRdbIdAvailabilityRelUpReg& coRef):fi_tclVisitableTypeBase(coRef)
{
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
tmdatafi_tclMsgNavTima_CurrentRdbIdAvailabilityRelUpReg& tmdatafi_tclMsgNavTima_CurrentRdbIdAvailabilityRelUpReg::operator=(const tmdatafi_tclMsgNavTima_CurrentRdbIdAvailabilityRelUpReg& coRef)
{
   if (this == &coRef) return *this;
   return *this;
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
tU16 tmdatafi_tclMsgNavTima_CurrentRdbIdAvailabilityRelUpReg::u16GetServiceID() const {return TMDATAFI_C_U16_SERVICE_ID;}
tU16 tmdatafi_tclMsgNavTima_CurrentRdbIdAvailabilityRelUpReg::u16GetFunctionID() const {return TMDATAFI_C_U16_NAVTIMA_CURRENTRDBIDAVAILABILITY;}
tU8 tmdatafi_tclMsgNavTima_CurrentRdbIdAvailabilityRelUpReg::u8GetOpCode() const {return CCA_C_U8_OPCODE_RELUPREG;}

tU32 tmdatafi_tclMsgNavTima_CurrentRdbIdAvailabilityRelUpReg::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 0;
}

tBool tmdatafi_tclMsgNavTima_CurrentRdbIdAvailabilityRelUpReg::operator==(const tmdatafi_tclMsgNavTima_CurrentRdbIdAvailabilityRelUpReg& /* rfoCmp */) const
{
   tBool bResult = true;
   return bResult;
}

fi_tclInContext& tmdatafi_tclMsgNavTima_CurrentRdbIdAvailabilityRelUpReg::oRead(fi_tclInContext& oIn)
{
   return oIn;
}

fi_tclOutContext& tmdatafi_tclMsgNavTima_CurrentRdbIdAvailabilityRelUpReg::oWrite(fi_tclOutContext& oOut) const
{
   return oOut;
}

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
tmdatafi_tclMsgNavTima_CurrentRdbIdAvailabilityStatus::tmdatafi_tclMsgNavTima_CurrentRdbIdAvailabilityStatus(const tmdatafi_tclMsgNavTima_CurrentRdbIdAvailabilityStatus& coRef):fi_tclVisitableTypeBase(coRef)
{
   SupportedRdbIds = coRef.SupportedRdbIds;
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
tmdatafi_tclMsgNavTima_CurrentRdbIdAvailabilityStatus& tmdatafi_tclMsgNavTima_CurrentRdbIdAvailabilityStatus::operator=(const tmdatafi_tclMsgNavTima_CurrentRdbIdAvailabilityStatus& coRef)
{
   if (this == &coRef) return *this;
   SupportedRdbIds = coRef.SupportedRdbIds;
   return *this;
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
tU16 tmdatafi_tclMsgNavTima_CurrentRdbIdAvailabilityStatus::u16GetServiceID() const {return TMDATAFI_C_U16_SERVICE_ID;}
tU16 tmdatafi_tclMsgNavTima_CurrentRdbIdAvailabilityStatus::u16GetFunctionID() const {return TMDATAFI_C_U16_NAVTIMA_CURRENTRDBIDAVAILABILITY;}
tU8 tmdatafi_tclMsgNavTima_CurrentRdbIdAvailabilityStatus::u8GetOpCode() const {return CCA_C_U8_OPCODE_STATUS;}

tVoid tmdatafi_tclMsgNavTima_CurrentRdbIdAvailabilityStatus::vDestroy()
{
   {
      for (tU32 u32Idx = 0; u32Idx < SupportedRdbIds.size(); ++u32Idx)
         SupportedRdbIds[u32Idx].vDestroy();
   }
   SupportedRdbIds.clear();
}

tU32 tmdatafi_tclMsgNavTima_CurrentRdbIdAvailabilityStatus::u32GetSize(tU16 u16MajorVersion) const
{
   tU32 u32DynamicSize = 0;
   tU32 u32ListIdx;
   for (u32ListIdx = 0; u32ListIdx < SupportedRdbIds.size(); ++u32ListIdx)
      u32DynamicSize += SupportedRdbIds[u32ListIdx].u32GetSize(u16MajorVersion);
   return u32DynamicSize+4;
}

tBool tmdatafi_tclMsgNavTima_CurrentRdbIdAvailabilityStatus::operator==(const tmdatafi_tclMsgNavTima_CurrentRdbIdAvailabilityStatus& rfoCmp) const
{
   tBool bResult = true;
      bResult = bResult && (SupportedRdbIds.size() == rfoCmp.SupportedRdbIds.size());
      if (bResult)
      {
         for (tU32 u32Idx = 0; bResult && (u32Idx < SupportedRdbIds.size()); ++u32Idx)
            bResult = bResult && (SupportedRdbIds[u32Idx] == rfoCmp.SupportedRdbIds[u32Idx]);
      }
   return bResult;
}

fi_tclInContext& tmdatafi_tclMsgNavTima_CurrentRdbIdAvailabilityStatus::oRead(fi_tclInContext& oIn)
{
   {
      tU32 u32Length;
      tU32 u32Idx;
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
      for (u32Idx = 0; u32Idx < SupportedRdbIds.size(); ++u32Idx)
      {
         SupportedRdbIds[u32Idx].vDestroy();
      }
#endif // !VARIANT_S_FTR_ENABLE_DEEP_COPY
      oIn >> u32Length;
      SupportedRdbIds.resize(u32Length);
      for (u32Idx = 0; u32Idx < u32Length; ++u32Idx)
      {
         oIn >> SupportedRdbIds[u32Idx];
      }
   }
   return oIn;
}

fi_tclOutContext& tmdatafi_tclMsgNavTima_CurrentRdbIdAvailabilityStatus::oWrite(fi_tclOutContext& oOut) const
{
   oOut << (tU32)SupportedRdbIds.size();
   {
      for (tU32 u32Idx = 0; u32Idx < SupportedRdbIds.size(); ++u32Idx)
         oOut << SupportedRdbIds[u32Idx];
   }
   return oOut;
}

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
tmdatafi_tclMsgNavTima_ExpiredTmcMessageListUpReg::tmdatafi_tclMsgNavTima_ExpiredTmcMessageListUpReg(const tmdatafi_tclMsgNavTima_ExpiredTmcMessageListUpReg& coRef):fi_tclVisitableTypeBase(coRef)
{
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
tmdatafi_tclMsgNavTima_ExpiredTmcMessageListUpReg& tmdatafi_tclMsgNavTima_ExpiredTmcMessageListUpReg::operator=(const tmdatafi_tclMsgNavTima_ExpiredTmcMessageListUpReg& coRef)
{
   if (this == &coRef) return *this;
   return *this;
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
tU16 tmdatafi_tclMsgNavTima_ExpiredTmcMessageListUpReg::u16GetServiceID() const {return TMDATAFI_C_U16_SERVICE_ID;}
tU16 tmdatafi_tclMsgNavTima_ExpiredTmcMessageListUpReg::u16GetFunctionID() const {return TMDATAFI_C_U16_NAVTIMA_EXPIREDTMCMESSAGELIST;}
tU8 tmdatafi_tclMsgNavTima_ExpiredTmcMessageListUpReg::u8GetOpCode() const {return CCA_C_U8_OPCODE_UPREG;}

tU32 tmdatafi_tclMsgNavTima_ExpiredTmcMessageListUpReg::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 0;
}

tBool tmdatafi_tclMsgNavTima_ExpiredTmcMessageListUpReg::operator==(const tmdatafi_tclMsgNavTima_ExpiredTmcMessageListUpReg& /* rfoCmp */) const
{
   tBool bResult = true;
   return bResult;
}

fi_tclInContext& tmdatafi_tclMsgNavTima_ExpiredTmcMessageListUpReg::oRead(fi_tclInContext& oIn)
{
   return oIn;
}

fi_tclOutContext& tmdatafi_tclMsgNavTima_ExpiredTmcMessageListUpReg::oWrite(fi_tclOutContext& oOut) const
{
   return oOut;
}

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
tmdatafi_tclMsgNavTima_ExpiredTmcMessageListRelUpReg::tmdatafi_tclMsgNavTima_ExpiredTmcMessageListRelUpReg(const tmdatafi_tclMsgNavTima_ExpiredTmcMessageListRelUpReg& coRef):fi_tclVisitableTypeBase(coRef)
{
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
tmdatafi_tclMsgNavTima_ExpiredTmcMessageListRelUpReg& tmdatafi_tclMsgNavTima_ExpiredTmcMessageListRelUpReg::operator=(const tmdatafi_tclMsgNavTima_ExpiredTmcMessageListRelUpReg& coRef)
{
   if (this == &coRef) return *this;
   return *this;
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
tU16 tmdatafi_tclMsgNavTima_ExpiredTmcMessageListRelUpReg::u16GetServiceID() const {return TMDATAFI_C_U16_SERVICE_ID;}
tU16 tmdatafi_tclMsgNavTima_ExpiredTmcMessageListRelUpReg::u16GetFunctionID() const {return TMDATAFI_C_U16_NAVTIMA_EXPIREDTMCMESSAGELIST;}
tU8 tmdatafi_tclMsgNavTima_ExpiredTmcMessageListRelUpReg::u8GetOpCode() const {return CCA_C_U8_OPCODE_RELUPREG;}

tU32 tmdatafi_tclMsgNavTima_ExpiredTmcMessageListRelUpReg::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 0;
}

tBool tmdatafi_tclMsgNavTima_ExpiredTmcMessageListRelUpReg::operator==(const tmdatafi_tclMsgNavTima_ExpiredTmcMessageListRelUpReg& /* rfoCmp */) const
{
   tBool bResult = true;
   return bResult;
}

fi_tclInContext& tmdatafi_tclMsgNavTima_ExpiredTmcMessageListRelUpReg::oRead(fi_tclInContext& oIn)
{
   return oIn;
}

fi_tclOutContext& tmdatafi_tclMsgNavTima_ExpiredTmcMessageListRelUpReg::oWrite(fi_tclOutContext& oOut) const
{
   return oOut;
}

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
tmdatafi_tclMsgNavTima_ExpiredTmcMessageListStatus::tmdatafi_tclMsgNavTima_ExpiredTmcMessageListStatus(const tmdatafi_tclMsgNavTima_ExpiredTmcMessageListStatus& coRef):fi_tclVisitableTypeBase(coRef)
{
   NumberOfSelectedMessages = coRef.NumberOfSelectedMessages;
   MsgMemMajorId = coRef.MsgMemMajorId;
   MsgMemMinorId = coRef.MsgMemMinorId;
   MessageStockUnaligned = coRef.MessageStockUnaligned;
   EraseAllTrafficMessages = coRef.EraseAllTrafficMessages;
   ErasedTrafficMessages = coRef.ErasedTrafficMessages;
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
tmdatafi_tclMsgNavTima_ExpiredTmcMessageListStatus& tmdatafi_tclMsgNavTima_ExpiredTmcMessageListStatus::operator=(const tmdatafi_tclMsgNavTima_ExpiredTmcMessageListStatus& coRef)
{
   if (this == &coRef) return *this;
   NumberOfSelectedMessages = coRef.NumberOfSelectedMessages;
   MsgMemMajorId = coRef.MsgMemMajorId;
   MsgMemMinorId = coRef.MsgMemMinorId;
   MessageStockUnaligned = coRef.MessageStockUnaligned;
   EraseAllTrafficMessages = coRef.EraseAllTrafficMessages;
   ErasedTrafficMessages = coRef.ErasedTrafficMessages;
   return *this;
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
tU16 tmdatafi_tclMsgNavTima_ExpiredTmcMessageListStatus::u16GetServiceID() const {return TMDATAFI_C_U16_SERVICE_ID;}
tU16 tmdatafi_tclMsgNavTima_ExpiredTmcMessageListStatus::u16GetFunctionID() const {return TMDATAFI_C_U16_NAVTIMA_EXPIREDTMCMESSAGELIST;}
tU8 tmdatafi_tclMsgNavTima_ExpiredTmcMessageListStatus::u8GetOpCode() const {return CCA_C_U8_OPCODE_STATUS;}

tVoid tmdatafi_tclMsgNavTima_ExpiredTmcMessageListStatus::vDestroy()
{
   ErasedTrafficMessages.clear();
}

tU32 tmdatafi_tclMsgNavTima_ExpiredTmcMessageListStatus::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 16+ErasedTrafficMessages.size()*2;
}

tBool tmdatafi_tclMsgNavTima_ExpiredTmcMessageListStatus::operator==(const tmdatafi_tclMsgNavTima_ExpiredTmcMessageListStatus& rfoCmp) const
{
   tBool bResult = true;
      bResult = bResult && (NumberOfSelectedMessages == rfoCmp.NumberOfSelectedMessages);
      bResult = bResult && (MsgMemMajorId == rfoCmp.MsgMemMajorId);
      bResult = bResult && (MsgMemMinorId == rfoCmp.MsgMemMinorId);
      bResult = bResult && (MessageStockUnaligned == rfoCmp.MessageStockUnaligned);
      bResult = bResult && (EraseAllTrafficMessages == rfoCmp.EraseAllTrafficMessages);
      bResult = bResult && (ErasedTrafficMessages.size() == rfoCmp.ErasedTrafficMessages.size());
      if (bResult)
      {
         for (tU32 u32Idx = 0; bResult && (u32Idx < ErasedTrafficMessages.size()); ++u32Idx)
            bResult = bResult && (ErasedTrafficMessages[u32Idx] == rfoCmp.ErasedTrafficMessages[u32Idx]);
      }
   return bResult;
}

fi_tclInContext& tmdatafi_tclMsgNavTima_ExpiredTmcMessageListStatus::oRead(fi_tclInContext& oIn)
{
   oIn >> NumberOfSelectedMessages;
   oIn >> MsgMemMajorId;
   oIn >> MsgMemMinorId;
   oIn >> MessageStockUnaligned;
   oIn >> EraseAllTrafficMessages;
   {
      tU32 u32Length;
      tU32 u32Idx;
      oIn >> u32Length;
      ErasedTrafficMessages.resize(u32Length);
      for (u32Idx = 0; u32Idx < u32Length; ++u32Idx)
      {
         oIn >> ErasedTrafficMessages[u32Idx];
      }
   }
   return oIn;
}

fi_tclOutContext& tmdatafi_tclMsgNavTima_ExpiredTmcMessageListStatus::oWrite(fi_tclOutContext& oOut) const
{
   oOut << NumberOfSelectedMessages;
   oOut << MsgMemMajorId;
   oOut << MsgMemMinorId;
   oOut << MessageStockUnaligned;
   oOut << EraseAllTrafficMessages;
   oOut << (tU32)ErasedTrafficMessages.size();
   {
      for (tU32 u32Idx = 0; u32Idx < ErasedTrafficMessages.size(); ++u32Idx)
         oOut << ErasedTrafficMessages[u32Idx];
   }
   return oOut;
}

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
tmdatafi_tclMsgNavTima_TmcMessageChangedUpReg::tmdatafi_tclMsgNavTima_TmcMessageChangedUpReg(const tmdatafi_tclMsgNavTima_TmcMessageChangedUpReg& coRef):fi_tclVisitableTypeBase(coRef)
{
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
tmdatafi_tclMsgNavTima_TmcMessageChangedUpReg& tmdatafi_tclMsgNavTima_TmcMessageChangedUpReg::operator=(const tmdatafi_tclMsgNavTima_TmcMessageChangedUpReg& coRef)
{
   if (this == &coRef) return *this;
   return *this;
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
tU16 tmdatafi_tclMsgNavTima_TmcMessageChangedUpReg::u16GetServiceID() const {return TMDATAFI_C_U16_SERVICE_ID;}
tU16 tmdatafi_tclMsgNavTima_TmcMessageChangedUpReg::u16GetFunctionID() const {return TMDATAFI_C_U16_NAVTIMA_TMCMESSAGECHANGED;}
tU8 tmdatafi_tclMsgNavTima_TmcMessageChangedUpReg::u8GetOpCode() const {return CCA_C_U8_OPCODE_UPREG;}

tU32 tmdatafi_tclMsgNavTima_TmcMessageChangedUpReg::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 0;
}

tBool tmdatafi_tclMsgNavTima_TmcMessageChangedUpReg::operator==(const tmdatafi_tclMsgNavTima_TmcMessageChangedUpReg& /* rfoCmp */) const
{
   tBool bResult = true;
   return bResult;
}

fi_tclInContext& tmdatafi_tclMsgNavTima_TmcMessageChangedUpReg::oRead(fi_tclInContext& oIn)
{
   return oIn;
}

fi_tclOutContext& tmdatafi_tclMsgNavTima_TmcMessageChangedUpReg::oWrite(fi_tclOutContext& oOut) const
{
   return oOut;
}

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
tmdatafi_tclMsgNavTima_TmcMessageChangedRelUpReg::tmdatafi_tclMsgNavTima_TmcMessageChangedRelUpReg(const tmdatafi_tclMsgNavTima_TmcMessageChangedRelUpReg& coRef):fi_tclVisitableTypeBase(coRef)
{
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
tmdatafi_tclMsgNavTima_TmcMessageChangedRelUpReg& tmdatafi_tclMsgNavTima_TmcMessageChangedRelUpReg::operator=(const tmdatafi_tclMsgNavTima_TmcMessageChangedRelUpReg& coRef)
{
   if (this == &coRef) return *this;
   return *this;
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
tU16 tmdatafi_tclMsgNavTima_TmcMessageChangedRelUpReg::u16GetServiceID() const {return TMDATAFI_C_U16_SERVICE_ID;}
tU16 tmdatafi_tclMsgNavTima_TmcMessageChangedRelUpReg::u16GetFunctionID() const {return TMDATAFI_C_U16_NAVTIMA_TMCMESSAGECHANGED;}
tU8 tmdatafi_tclMsgNavTima_TmcMessageChangedRelUpReg::u8GetOpCode() const {return CCA_C_U8_OPCODE_RELUPREG;}

tU32 tmdatafi_tclMsgNavTima_TmcMessageChangedRelUpReg::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 0;
}

tBool tmdatafi_tclMsgNavTima_TmcMessageChangedRelUpReg::operator==(const tmdatafi_tclMsgNavTima_TmcMessageChangedRelUpReg& /* rfoCmp */) const
{
   tBool bResult = true;
   return bResult;
}

fi_tclInContext& tmdatafi_tclMsgNavTima_TmcMessageChangedRelUpReg::oRead(fi_tclInContext& oIn)
{
   return oIn;
}

fi_tclOutContext& tmdatafi_tclMsgNavTima_TmcMessageChangedRelUpReg::oWrite(fi_tclOutContext& oOut) const
{
   return oOut;
}

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
tmdatafi_tclMsgNavTima_TmcMessageChangedStatus::tmdatafi_tclMsgNavTima_TmcMessageChangedStatus(const tmdatafi_tclMsgNavTima_TmcMessageChangedStatus& coRef):fi_tclVisitableTypeBase(coRef)
{
   NumberOfSelectedMessages = coRef.NumberOfSelectedMessages;
   MsgMemMajorId = coRef.MsgMemMajorId;
   MsgMemMinorId = coRef.MsgMemMinorId;
   MessageStockUnaligned = coRef.MessageStockUnaligned;
   TrafficMessageList = coRef.TrafficMessageList;
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
tmdatafi_tclMsgNavTima_TmcMessageChangedStatus& tmdatafi_tclMsgNavTima_TmcMessageChangedStatus::operator=(const tmdatafi_tclMsgNavTima_TmcMessageChangedStatus& coRef)
{
   if (this == &coRef) return *this;
   NumberOfSelectedMessages = coRef.NumberOfSelectedMessages;
   MsgMemMajorId = coRef.MsgMemMajorId;
   MsgMemMinorId = coRef.MsgMemMinorId;
   MessageStockUnaligned = coRef.MessageStockUnaligned;
   TrafficMessageList = coRef.TrafficMessageList;
   return *this;
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
tU16 tmdatafi_tclMsgNavTima_TmcMessageChangedStatus::u16GetServiceID() const {return TMDATAFI_C_U16_SERVICE_ID;}
tU16 tmdatafi_tclMsgNavTima_TmcMessageChangedStatus::u16GetFunctionID() const {return TMDATAFI_C_U16_NAVTIMA_TMCMESSAGECHANGED;}
tU8 tmdatafi_tclMsgNavTima_TmcMessageChangedStatus::u8GetOpCode() const {return CCA_C_U8_OPCODE_STATUS;}

tVoid tmdatafi_tclMsgNavTima_TmcMessageChangedStatus::vDestroy()
{
   {
      for (tU32 u32Idx = 0; u32Idx < TrafficMessageList.size(); ++u32Idx)
         TrafficMessageList[u32Idx].vDestroy();
   }
   TrafficMessageList.clear();
}

tU32 tmdatafi_tclMsgNavTima_TmcMessageChangedStatus::u32GetSize(tU16 u16MajorVersion) const
{
   tU32 u32DynamicSize = 0;
   tU32 u32ListIdx;
   for (u32ListIdx = 0; u32ListIdx < TrafficMessageList.size(); ++u32ListIdx)
      u32DynamicSize += TrafficMessageList[u32ListIdx].u32GetSize(u16MajorVersion);
   return u32DynamicSize+15;
}

tBool tmdatafi_tclMsgNavTima_TmcMessageChangedStatus::operator==(const tmdatafi_tclMsgNavTima_TmcMessageChangedStatus& rfoCmp) const
{
   tBool bResult = true;
      bResult = bResult && (NumberOfSelectedMessages == rfoCmp.NumberOfSelectedMessages);
      bResult = bResult && (MsgMemMajorId == rfoCmp.MsgMemMajorId);
      bResult = bResult && (MsgMemMinorId == rfoCmp.MsgMemMinorId);
      bResult = bResult && (MessageStockUnaligned == rfoCmp.MessageStockUnaligned);
      bResult = bResult && (TrafficMessageList.size() == rfoCmp.TrafficMessageList.size());
      if (bResult)
      {
         for (tU32 u32Idx = 0; bResult && (u32Idx < TrafficMessageList.size()); ++u32Idx)
            bResult = bResult && (TrafficMessageList[u32Idx] == rfoCmp.TrafficMessageList[u32Idx]);
      }
   return bResult;
}

fi_tclInContext& tmdatafi_tclMsgNavTima_TmcMessageChangedStatus::oRead(fi_tclInContext& oIn)
{
   oIn >> NumberOfSelectedMessages;
   oIn >> MsgMemMajorId;
   oIn >> MsgMemMinorId;
   oIn >> MessageStockUnaligned;
   {
      tU32 u32Length;
      tU32 u32Idx;
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
      for (u32Idx = 0; u32Idx < TrafficMessageList.size(); ++u32Idx)
      {
         TrafficMessageList[u32Idx].vDestroy();
      }
#endif // !VARIANT_S_FTR_ENABLE_DEEP_COPY
      oIn >> u32Length;
      TrafficMessageList.resize(u32Length);
      for (u32Idx = 0; u32Idx < u32Length; ++u32Idx)
      {
         oIn >> TrafficMessageList[u32Idx];
      }
   }
   return oIn;
}

fi_tclOutContext& tmdatafi_tclMsgNavTima_TmcMessageChangedStatus::oWrite(fi_tclOutContext& oOut) const
{
   oOut << NumberOfSelectedMessages;
   oOut << MsgMemMajorId;
   oOut << MsgMemMinorId;
   oOut << MessageStockUnaligned;
   oOut << (tU32)TrafficMessageList.size();
   {
      for (tU32 u32Idx = 0; u32Idx < TrafficMessageList.size(); ++u32Idx)
         oOut << TrafficMessageList[u32Idx];
   }
   return oOut;
}

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
tmdatafi_tclMsgNavTima_TrafficMsgMemoryStatisticsUpReg::tmdatafi_tclMsgNavTima_TrafficMsgMemoryStatisticsUpReg(const tmdatafi_tclMsgNavTima_TrafficMsgMemoryStatisticsUpReg& coRef):fi_tclVisitableTypeBase(coRef)
{
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
tmdatafi_tclMsgNavTima_TrafficMsgMemoryStatisticsUpReg& tmdatafi_tclMsgNavTima_TrafficMsgMemoryStatisticsUpReg::operator=(const tmdatafi_tclMsgNavTima_TrafficMsgMemoryStatisticsUpReg& coRef)
{
   if (this == &coRef) return *this;
   return *this;
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
tU16 tmdatafi_tclMsgNavTima_TrafficMsgMemoryStatisticsUpReg::u16GetServiceID() const {return TMDATAFI_C_U16_SERVICE_ID;}
tU16 tmdatafi_tclMsgNavTima_TrafficMsgMemoryStatisticsUpReg::u16GetFunctionID() const {return TMDATAFI_C_U16_NAVTIMA_TRAFFICMSGMEMORYSTATISTICS;}
tU8 tmdatafi_tclMsgNavTima_TrafficMsgMemoryStatisticsUpReg::u8GetOpCode() const {return CCA_C_U8_OPCODE_UPREG;}

tU32 tmdatafi_tclMsgNavTima_TrafficMsgMemoryStatisticsUpReg::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 0;
}

tBool tmdatafi_tclMsgNavTima_TrafficMsgMemoryStatisticsUpReg::operator==(const tmdatafi_tclMsgNavTima_TrafficMsgMemoryStatisticsUpReg& /* rfoCmp */) const
{
   tBool bResult = true;
   return bResult;
}

fi_tclInContext& tmdatafi_tclMsgNavTima_TrafficMsgMemoryStatisticsUpReg::oRead(fi_tclInContext& oIn)
{
   return oIn;
}

fi_tclOutContext& tmdatafi_tclMsgNavTima_TrafficMsgMemoryStatisticsUpReg::oWrite(fi_tclOutContext& oOut) const
{
   return oOut;
}

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
tmdatafi_tclMsgNavTima_TrafficMsgMemoryStatisticsRelUpReg::tmdatafi_tclMsgNavTima_TrafficMsgMemoryStatisticsRelUpReg(const tmdatafi_tclMsgNavTima_TrafficMsgMemoryStatisticsRelUpReg& coRef):fi_tclVisitableTypeBase(coRef)
{
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
tmdatafi_tclMsgNavTima_TrafficMsgMemoryStatisticsRelUpReg& tmdatafi_tclMsgNavTima_TrafficMsgMemoryStatisticsRelUpReg::operator=(const tmdatafi_tclMsgNavTima_TrafficMsgMemoryStatisticsRelUpReg& coRef)
{
   if (this == &coRef) return *this;
   return *this;
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
tU16 tmdatafi_tclMsgNavTima_TrafficMsgMemoryStatisticsRelUpReg::u16GetServiceID() const {return TMDATAFI_C_U16_SERVICE_ID;}
tU16 tmdatafi_tclMsgNavTima_TrafficMsgMemoryStatisticsRelUpReg::u16GetFunctionID() const {return TMDATAFI_C_U16_NAVTIMA_TRAFFICMSGMEMORYSTATISTICS;}
tU8 tmdatafi_tclMsgNavTima_TrafficMsgMemoryStatisticsRelUpReg::u8GetOpCode() const {return CCA_C_U8_OPCODE_RELUPREG;}

tU32 tmdatafi_tclMsgNavTima_TrafficMsgMemoryStatisticsRelUpReg::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 0;
}

tBool tmdatafi_tclMsgNavTima_TrafficMsgMemoryStatisticsRelUpReg::operator==(const tmdatafi_tclMsgNavTima_TrafficMsgMemoryStatisticsRelUpReg& /* rfoCmp */) const
{
   tBool bResult = true;
   return bResult;
}

fi_tclInContext& tmdatafi_tclMsgNavTima_TrafficMsgMemoryStatisticsRelUpReg::oRead(fi_tclInContext& oIn)
{
   return oIn;
}

fi_tclOutContext& tmdatafi_tclMsgNavTima_TrafficMsgMemoryStatisticsRelUpReg::oWrite(fi_tclOutContext& oOut) const
{
   return oOut;
}

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
tmdatafi_tclMsgNavTima_TrafficMsgMemoryStatisticsStatus::tmdatafi_tclMsgNavTima_TrafficMsgMemoryStatisticsStatus(const tmdatafi_tclMsgNavTima_TrafficMsgMemoryStatisticsStatus& coRef):fi_tclVisitableTypeBase(coRef)
{
   TrafficMsgMemoryStatistics = coRef.TrafficMsgMemoryStatistics;
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
tmdatafi_tclMsgNavTima_TrafficMsgMemoryStatisticsStatus& tmdatafi_tclMsgNavTima_TrafficMsgMemoryStatisticsStatus::operator=(const tmdatafi_tclMsgNavTima_TrafficMsgMemoryStatisticsStatus& coRef)
{
   if (this == &coRef) return *this;
   TrafficMsgMemoryStatistics = coRef.TrafficMsgMemoryStatistics;
   return *this;
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
tU16 tmdatafi_tclMsgNavTima_TrafficMsgMemoryStatisticsStatus::u16GetServiceID() const {return TMDATAFI_C_U16_SERVICE_ID;}
tU16 tmdatafi_tclMsgNavTima_TrafficMsgMemoryStatisticsStatus::u16GetFunctionID() const {return TMDATAFI_C_U16_NAVTIMA_TRAFFICMSGMEMORYSTATISTICS;}
tU8 tmdatafi_tclMsgNavTima_TrafficMsgMemoryStatisticsStatus::u8GetOpCode() const {return CCA_C_U8_OPCODE_STATUS;}

tVoid tmdatafi_tclMsgNavTima_TrafficMsgMemoryStatisticsStatus::vDestroy()
{
   TrafficMsgMemoryStatistics.vDestroy(); 
}

tU32 tmdatafi_tclMsgNavTima_TrafficMsgMemoryStatisticsStatus::u32GetSize(tU16 u16MajorVersion) const
{
   return 0+TrafficMsgMemoryStatistics.u32GetSize(u16MajorVersion);
}

tBool tmdatafi_tclMsgNavTima_TrafficMsgMemoryStatisticsStatus::operator==(const tmdatafi_tclMsgNavTima_TrafficMsgMemoryStatisticsStatus& rfoCmp) const
{
   tBool bResult = true;
      bResult = bResult && (TrafficMsgMemoryStatistics == rfoCmp.TrafficMsgMemoryStatistics);
   return bResult;
}

fi_tclInContext& tmdatafi_tclMsgNavTima_TrafficMsgMemoryStatisticsStatus::oRead(fi_tclInContext& oIn)
{
   oIn >> TrafficMsgMemoryStatistics;
   return oIn;
}

fi_tclOutContext& tmdatafi_tclMsgNavTima_TrafficMsgMemoryStatisticsStatus::oWrite(fi_tclOutContext& oOut) const
{
   oOut << TrafficMsgMemoryStatistics;
   return oOut;
}

