/************************************************************************
 
 *FILE:           navifitypes.cpp
 
 *SW-COMPONENT:   NaviFI, Navigation Functional Interface
 
 *DESCRIPTION:    Interface fuer allgemeine Typdefinitionen des Nafi
                  
 *AUTHOR:         Jochen Bruns (CM-DI/ENS41)
 
 *COPYRIGHT:      (c) 2001 Blaupunkt GmbH
 
 ************************************************************************/

#include "precompiled.hh"
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
tmctunerfi_tclMsgSwitchOnOffMethodStart::tmctunerfi_tclMsgSwitchOnOffMethodStart(const tmctunerfi_tclMsgSwitchOnOffMethodStart& coRef):fi_tclVisitableTypeBase(coRef)
{
   TmcOnOff = coRef.TmcOnOff;
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
tmctunerfi_tclMsgSwitchOnOffMethodStart& tmctunerfi_tclMsgSwitchOnOffMethodStart::operator=(const tmctunerfi_tclMsgSwitchOnOffMethodStart& coRef)
{
   if (this == &coRef) return *this;
   TmcOnOff = coRef.TmcOnOff;
   return *this;
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
tU16 tmctunerfi_tclMsgSwitchOnOffMethodStart::u16GetServiceID() const {return TMCTUNERFI_C_U16_SERVICE_ID;}
tU16 tmctunerfi_tclMsgSwitchOnOffMethodStart::u16GetFunctionID() const {return TMCTUNERFI_C_U16_SWITCHONOFF;}
tU8 tmctunerfi_tclMsgSwitchOnOffMethodStart::u8GetOpCode() const {return CCA_C_U8_OPCODE_METHODSTART;}

tU32 tmctunerfi_tclMsgSwitchOnOffMethodStart::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 1;
}

tBool tmctunerfi_tclMsgSwitchOnOffMethodStart::operator==(const tmctunerfi_tclMsgSwitchOnOffMethodStart& rfoCmp) const
{
   tBool bResult = true;
      bResult = bResult && (TmcOnOff == rfoCmp.TmcOnOff);
   return bResult;
}

fi_tclInContext& tmctunerfi_tclMsgSwitchOnOffMethodStart::oRead(fi_tclInContext& oIn)
{
   oIn >> TmcOnOff;
   return oIn;
}

fi_tclOutContext& tmctunerfi_tclMsgSwitchOnOffMethodStart::oWrite(fi_tclOutContext& oOut) const
{
   oOut << TmcOnOff;
   return oOut;
}

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
tmctunerfi_tclMsgSwitchOnOffMethodResult::tmctunerfi_tclMsgSwitchOnOffMethodResult(const tmctunerfi_tclMsgSwitchOnOffMethodResult& coRef):fi_tclVisitableTypeBase(coRef)
{
   Success = coRef.Success;
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
tmctunerfi_tclMsgSwitchOnOffMethodResult& tmctunerfi_tclMsgSwitchOnOffMethodResult::operator=(const tmctunerfi_tclMsgSwitchOnOffMethodResult& coRef)
{
   if (this == &coRef) return *this;
   Success = coRef.Success;
   return *this;
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
tU16 tmctunerfi_tclMsgSwitchOnOffMethodResult::u16GetServiceID() const {return TMCTUNERFI_C_U16_SERVICE_ID;}
tU16 tmctunerfi_tclMsgSwitchOnOffMethodResult::u16GetFunctionID() const {return TMCTUNERFI_C_U16_SWITCHONOFF;}
tU8 tmctunerfi_tclMsgSwitchOnOffMethodResult::u8GetOpCode() const {return CCA_C_U8_OPCODE_METHODRESULT;}

tU32 tmctunerfi_tclMsgSwitchOnOffMethodResult::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 1;
}

tBool tmctunerfi_tclMsgSwitchOnOffMethodResult::operator==(const tmctunerfi_tclMsgSwitchOnOffMethodResult& rfoCmp) const
{
   tBool bResult = true;
      bResult = bResult && (Success == rfoCmp.Success);
   return bResult;
}

fi_tclInContext& tmctunerfi_tclMsgSwitchOnOffMethodResult::oRead(fi_tclInContext& oIn)
{
   oIn >> Success;
   return oIn;
}

fi_tclOutContext& tmctunerfi_tclMsgSwitchOnOffMethodResult::oWrite(fi_tclOutContext& oOut) const
{
   oOut << Success;
   return oOut;
}

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
tmctunerfi_tclMsgSetRdbIdWishListMethodStart::tmctunerfi_tclMsgSetRdbIdWishListMethodStart(const tmctunerfi_tclMsgSetRdbIdWishListMethodStart& coRef):fi_tclVisitableTypeBase(coRef)
{
   ListOfRdbIds = coRef.ListOfRdbIds;
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
tmctunerfi_tclMsgSetRdbIdWishListMethodStart& tmctunerfi_tclMsgSetRdbIdWishListMethodStart::operator=(const tmctunerfi_tclMsgSetRdbIdWishListMethodStart& coRef)
{
   if (this == &coRef) return *this;
   ListOfRdbIds = coRef.ListOfRdbIds;
   return *this;
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
tU16 tmctunerfi_tclMsgSetRdbIdWishListMethodStart::u16GetServiceID() const {return TMCTUNERFI_C_U16_SERVICE_ID;}
tU16 tmctunerfi_tclMsgSetRdbIdWishListMethodStart::u16GetFunctionID() const {return TMCTUNERFI_C_U16_SETRDBIDWISHLIST;}
tU8 tmctunerfi_tclMsgSetRdbIdWishListMethodStart::u8GetOpCode() const {return CCA_C_U8_OPCODE_METHODSTART;}

tVoid tmctunerfi_tclMsgSetRdbIdWishListMethodStart::vDestroy()
{
   {
      for (tU32 u32Idx = 0; u32Idx < ListOfRdbIds.size(); ++u32Idx)
         ListOfRdbIds[u32Idx].vDestroy();
   }
   ListOfRdbIds.clear();
}

tU32 tmctunerfi_tclMsgSetRdbIdWishListMethodStart::u32GetSize(tU16 u16MajorVersion) const
{
   tU32 u32DynamicSize = 0;
   tU32 u32ListIdx;
   for (u32ListIdx = 0; u32ListIdx < ListOfRdbIds.size(); ++u32ListIdx)
      u32DynamicSize += ListOfRdbIds[u32ListIdx].u32GetSize(u16MajorVersion);
   return u32DynamicSize+4;
}

tBool tmctunerfi_tclMsgSetRdbIdWishListMethodStart::operator==(const tmctunerfi_tclMsgSetRdbIdWishListMethodStart& rfoCmp) const
{
   tBool bResult = true;
      bResult = bResult && (ListOfRdbIds.size() == rfoCmp.ListOfRdbIds.size());
      if (bResult)
      {
         for (tU32 u32Idx = 0; bResult && (u32Idx < ListOfRdbIds.size()); ++u32Idx)
            bResult = bResult && (ListOfRdbIds[u32Idx] == rfoCmp.ListOfRdbIds[u32Idx]);
      }
   return bResult;
}

fi_tclInContext& tmctunerfi_tclMsgSetRdbIdWishListMethodStart::oRead(fi_tclInContext& oIn)
{
   {
      tU32 u32Length;
      tU32 u32Idx;
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
      for (u32Idx = 0; u32Idx < ListOfRdbIds.size(); ++u32Idx)
      {
         ListOfRdbIds[u32Idx].vDestroy();
      }
#endif // !VARIANT_S_FTR_ENABLE_DEEP_COPY
      oIn >> u32Length;
      ListOfRdbIds.resize(u32Length);
      for (u32Idx = 0; u32Idx < u32Length; ++u32Idx)
      {
         oIn >> ListOfRdbIds[u32Idx];
      }
   }
   return oIn;
}

fi_tclOutContext& tmctunerfi_tclMsgSetRdbIdWishListMethodStart::oWrite(fi_tclOutContext& oOut) const
{
   oOut << (tU32)ListOfRdbIds.size();
   {
      for (tU32 u32Idx = 0; u32Idx < ListOfRdbIds.size(); ++u32Idx)
         oOut << ListOfRdbIds[u32Idx];
   }
   return oOut;
}

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
tmctunerfi_tclMsgSetRdbIdWishListMethodResult::tmctunerfi_tclMsgSetRdbIdWishListMethodResult(const tmctunerfi_tclMsgSetRdbIdWishListMethodResult& coRef):fi_tclVisitableTypeBase(coRef)
{
   ListOfRdbIds = coRef.ListOfRdbIds;
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
tmctunerfi_tclMsgSetRdbIdWishListMethodResult& tmctunerfi_tclMsgSetRdbIdWishListMethodResult::operator=(const tmctunerfi_tclMsgSetRdbIdWishListMethodResult& coRef)
{
   if (this == &coRef) return *this;
   ListOfRdbIds = coRef.ListOfRdbIds;
   return *this;
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
tU16 tmctunerfi_tclMsgSetRdbIdWishListMethodResult::u16GetServiceID() const {return TMCTUNERFI_C_U16_SERVICE_ID;}
tU16 tmctunerfi_tclMsgSetRdbIdWishListMethodResult::u16GetFunctionID() const {return TMCTUNERFI_C_U16_SETRDBIDWISHLIST;}
tU8 tmctunerfi_tclMsgSetRdbIdWishListMethodResult::u8GetOpCode() const {return CCA_C_U8_OPCODE_METHODRESULT;}

tVoid tmctunerfi_tclMsgSetRdbIdWishListMethodResult::vDestroy()
{
   {
      for (tU32 u32Idx = 0; u32Idx < ListOfRdbIds.size(); ++u32Idx)
         ListOfRdbIds[u32Idx].vDestroy();
   }
   ListOfRdbIds.clear();
}

tU32 tmctunerfi_tclMsgSetRdbIdWishListMethodResult::u32GetSize(tU16 u16MajorVersion) const
{
   tU32 u32DynamicSize = 0;
   tU32 u32ListIdx;
   if (u16MajorVersion <= 3)
   {
      u32DynamicSize += 4;
      for (u32ListIdx = 0; u32ListIdx < ListOfRdbIds.size(); ++u32ListIdx)
         u32DynamicSize += ListOfRdbIds[u32ListIdx].u32GetSize(u16MajorVersion);
   }
   return u32DynamicSize+0;
}

tBool tmctunerfi_tclMsgSetRdbIdWishListMethodResult::operator==(const tmctunerfi_tclMsgSetRdbIdWishListMethodResult& rfoCmp) const
{
   tBool bResult = true;
      bResult = bResult && (ListOfRdbIds.size() == rfoCmp.ListOfRdbIds.size());
      if (bResult)
      {
         for (tU32 u32Idx = 0; bResult && (u32Idx < ListOfRdbIds.size()); ++u32Idx)
            bResult = bResult && (ListOfRdbIds[u32Idx] == rfoCmp.ListOfRdbIds[u32Idx]);
      }
   return bResult;
}

fi_tclInContext& tmctunerfi_tclMsgSetRdbIdWishListMethodResult::oRead(fi_tclInContext& oIn)
{
   if (oIn.u16GetMajorVersion() <= 3)
   {
      {
         tU32 u32Length;
         tU32 u32Idx;
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
         for (u32Idx = 0; u32Idx < ListOfRdbIds.size(); ++u32Idx)
         {
            ListOfRdbIds[u32Idx].vDestroy();
         }
#endif // !VARIANT_S_FTR_ENABLE_DEEP_COPY
         oIn >> u32Length;
         ListOfRdbIds.resize(u32Length);
         for (u32Idx = 0; u32Idx < u32Length; ++u32Idx)
         {
            oIn >> ListOfRdbIds[u32Idx];
         }
      }
   }
   return oIn;
}

fi_tclOutContext& tmctunerfi_tclMsgSetRdbIdWishListMethodResult::oWrite(fi_tclOutContext& oOut) const
{
   if (oOut.u16GetMajorVersion() <= 3)
   {
      oOut << (tU32)ListOfRdbIds.size();
      {
         for (tU32 u32Idx = 0; u32Idx < ListOfRdbIds.size(); ++u32Idx)
            oOut << ListOfRdbIds[u32Idx];
      }
   }
   return oOut;
}

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
tmctunerfi_tclMsgExchangeTmcCapabilitiesMethodStart::tmctunerfi_tclMsgExchangeTmcCapabilitiesMethodStart(const tmctunerfi_tclMsgExchangeTmcCapabilitiesMethodStart& coRef):fi_tclVisitableTypeBase(coRef)
{
   ListOfTmcCapabilities = coRef.ListOfTmcCapabilities;
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
tmctunerfi_tclMsgExchangeTmcCapabilitiesMethodStart& tmctunerfi_tclMsgExchangeTmcCapabilitiesMethodStart::operator=(const tmctunerfi_tclMsgExchangeTmcCapabilitiesMethodStart& coRef)
{
   if (this == &coRef) return *this;
   ListOfTmcCapabilities = coRef.ListOfTmcCapabilities;
   return *this;
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
tU16 tmctunerfi_tclMsgExchangeTmcCapabilitiesMethodStart::u16GetServiceID() const {return TMCTUNERFI_C_U16_SERVICE_ID;}
tU16 tmctunerfi_tclMsgExchangeTmcCapabilitiesMethodStart::u16GetFunctionID() const {return TMCTUNERFI_C_U16_EXCHANGETMCCAPABILITIES;}
tU8 tmctunerfi_tclMsgExchangeTmcCapabilitiesMethodStart::u8GetOpCode() const {return CCA_C_U8_OPCODE_METHODSTART;}

tVoid tmctunerfi_tclMsgExchangeTmcCapabilitiesMethodStart::vDestroy()
{
   {
      for (tU32 u32Idx = 0; u32Idx < ListOfTmcCapabilities.size(); ++u32Idx)
         ListOfTmcCapabilities[u32Idx].vDestroy();
   }
   ListOfTmcCapabilities.clear();
}

tU32 tmctunerfi_tclMsgExchangeTmcCapabilitiesMethodStart::u32GetSize(tU16 u16MajorVersion) const
{
   tU32 u32DynamicSize = 0;
   tU32 u32ListIdx;
   for (u32ListIdx = 0; u32ListIdx < ListOfTmcCapabilities.size(); ++u32ListIdx)
      u32DynamicSize += ListOfTmcCapabilities[u32ListIdx].u32GetSize(u16MajorVersion);
   return u32DynamicSize+4;
}

tBool tmctunerfi_tclMsgExchangeTmcCapabilitiesMethodStart::operator==(const tmctunerfi_tclMsgExchangeTmcCapabilitiesMethodStart& rfoCmp) const
{
   tBool bResult = true;
      bResult = bResult && (ListOfTmcCapabilities.size() == rfoCmp.ListOfTmcCapabilities.size());
      if (bResult)
      {
         for (tU32 u32Idx = 0; bResult && (u32Idx < ListOfTmcCapabilities.size()); ++u32Idx)
            bResult = bResult && (ListOfTmcCapabilities[u32Idx] == rfoCmp.ListOfTmcCapabilities[u32Idx]);
      }
   return bResult;
}

fi_tclInContext& tmctunerfi_tclMsgExchangeTmcCapabilitiesMethodStart::oRead(fi_tclInContext& oIn)
{
   {
      tU32 u32Length;
      tU32 u32Idx;
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
      for (u32Idx = 0; u32Idx < ListOfTmcCapabilities.size(); ++u32Idx)
      {
         ListOfTmcCapabilities[u32Idx].vDestroy();
      }
#endif // !VARIANT_S_FTR_ENABLE_DEEP_COPY
      oIn >> u32Length;
      ListOfTmcCapabilities.resize(u32Length);
      for (u32Idx = 0; u32Idx < u32Length; ++u32Idx)
      {
         oIn >> ListOfTmcCapabilities[u32Idx];
      }
   }
   return oIn;
}

fi_tclOutContext& tmctunerfi_tclMsgExchangeTmcCapabilitiesMethodStart::oWrite(fi_tclOutContext& oOut) const
{
   oOut << (tU32)ListOfTmcCapabilities.size();
   {
      for (tU32 u32Idx = 0; u32Idx < ListOfTmcCapabilities.size(); ++u32Idx)
         oOut << ListOfTmcCapabilities[u32Idx];
   }
   return oOut;
}

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
tmctunerfi_tclMsgExchangeTmcCapabilitiesMethodResult::tmctunerfi_tclMsgExchangeTmcCapabilitiesMethodResult(const tmctunerfi_tclMsgExchangeTmcCapabilitiesMethodResult& coRef):fi_tclVisitableTypeBase(coRef)
{
   ListOfTmcCapabilities = coRef.ListOfTmcCapabilities;
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
tmctunerfi_tclMsgExchangeTmcCapabilitiesMethodResult& tmctunerfi_tclMsgExchangeTmcCapabilitiesMethodResult::operator=(const tmctunerfi_tclMsgExchangeTmcCapabilitiesMethodResult& coRef)
{
   if (this == &coRef) return *this;
   ListOfTmcCapabilities = coRef.ListOfTmcCapabilities;
   return *this;
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
tU16 tmctunerfi_tclMsgExchangeTmcCapabilitiesMethodResult::u16GetServiceID() const {return TMCTUNERFI_C_U16_SERVICE_ID;}
tU16 tmctunerfi_tclMsgExchangeTmcCapabilitiesMethodResult::u16GetFunctionID() const {return TMCTUNERFI_C_U16_EXCHANGETMCCAPABILITIES;}
tU8 tmctunerfi_tclMsgExchangeTmcCapabilitiesMethodResult::u8GetOpCode() const {return CCA_C_U8_OPCODE_METHODRESULT;}

tVoid tmctunerfi_tclMsgExchangeTmcCapabilitiesMethodResult::vDestroy()
{
   {
      for (tU32 u32Idx = 0; u32Idx < ListOfTmcCapabilities.size(); ++u32Idx)
         ListOfTmcCapabilities[u32Idx].vDestroy();
   }
   ListOfTmcCapabilities.clear();
}

tU32 tmctunerfi_tclMsgExchangeTmcCapabilitiesMethodResult::u32GetSize(tU16 u16MajorVersion) const
{
   tU32 u32DynamicSize = 0;
   tU32 u32ListIdx;
   for (u32ListIdx = 0; u32ListIdx < ListOfTmcCapabilities.size(); ++u32ListIdx)
      u32DynamicSize += ListOfTmcCapabilities[u32ListIdx].u32GetSize(u16MajorVersion);
   return u32DynamicSize+4;
}

tBool tmctunerfi_tclMsgExchangeTmcCapabilitiesMethodResult::operator==(const tmctunerfi_tclMsgExchangeTmcCapabilitiesMethodResult& rfoCmp) const
{
   tBool bResult = true;
      bResult = bResult && (ListOfTmcCapabilities.size() == rfoCmp.ListOfTmcCapabilities.size());
      if (bResult)
      {
         for (tU32 u32Idx = 0; bResult && (u32Idx < ListOfTmcCapabilities.size()); ++u32Idx)
            bResult = bResult && (ListOfTmcCapabilities[u32Idx] == rfoCmp.ListOfTmcCapabilities[u32Idx]);
      }
   return bResult;
}

fi_tclInContext& tmctunerfi_tclMsgExchangeTmcCapabilitiesMethodResult::oRead(fi_tclInContext& oIn)
{
   {
      tU32 u32Length;
      tU32 u32Idx;
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
      for (u32Idx = 0; u32Idx < ListOfTmcCapabilities.size(); ++u32Idx)
      {
         ListOfTmcCapabilities[u32Idx].vDestroy();
      }
#endif // !VARIANT_S_FTR_ENABLE_DEEP_COPY
      oIn >> u32Length;
      ListOfTmcCapabilities.resize(u32Length);
      for (u32Idx = 0; u32Idx < u32Length; ++u32Idx)
      {
         oIn >> ListOfTmcCapabilities[u32Idx];
      }
   }
   return oIn;
}

fi_tclOutContext& tmctunerfi_tclMsgExchangeTmcCapabilitiesMethodResult::oWrite(fi_tclOutContext& oOut) const
{
   oOut << (tU32)ListOfTmcCapabilities.size();
   {
      for (tU32 u32Idx = 0; u32Idx < ListOfTmcCapabilities.size(); ++u32Idx)
         oOut << ListOfTmcCapabilities[u32Idx];
   }
   return oOut;
}

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
tmctunerfi_tclMsgExchangeCapabilitiesMethodStart::tmctunerfi_tclMsgExchangeCapabilitiesMethodStart(const tmctunerfi_tclMsgExchangeCapabilitiesMethodStart& coRef):fi_tclVisitableTypeBase(coRef)
{
   ListOfCommonCapabilities = coRef.ListOfCommonCapabilities;
   ListOfTmcCapabilities = coRef.ListOfTmcCapabilities;
   ListOfTpegCapabilities = coRef.ListOfTpegCapabilities;
   SupportedTpegApplications = coRef.SupportedTpegApplications;
   SupportedTpegLocReferencing = coRef.SupportedTpegLocReferencing;
   SupportedTpegTfpMethods = coRef.SupportedTpegTfpMethods;
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
tmctunerfi_tclMsgExchangeCapabilitiesMethodStart& tmctunerfi_tclMsgExchangeCapabilitiesMethodStart::operator=(const tmctunerfi_tclMsgExchangeCapabilitiesMethodStart& coRef)
{
   if (this == &coRef) return *this;
   ListOfCommonCapabilities = coRef.ListOfCommonCapabilities;
   ListOfTmcCapabilities = coRef.ListOfTmcCapabilities;
   ListOfTpegCapabilities = coRef.ListOfTpegCapabilities;
   SupportedTpegApplications = coRef.SupportedTpegApplications;
   SupportedTpegLocReferencing = coRef.SupportedTpegLocReferencing;
   SupportedTpegTfpMethods = coRef.SupportedTpegTfpMethods;
   return *this;
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
tU16 tmctunerfi_tclMsgExchangeCapabilitiesMethodStart::u16GetServiceID() const {return TMCTUNERFI_C_U16_SERVICE_ID;}
tU16 tmctunerfi_tclMsgExchangeCapabilitiesMethodStart::u16GetFunctionID() const {return TMCTUNERFI_C_U16_EXCHANGECAPABILITIES;}
tU8 tmctunerfi_tclMsgExchangeCapabilitiesMethodStart::u8GetOpCode() const {return CCA_C_U8_OPCODE_METHODSTART;}

tVoid tmctunerfi_tclMsgExchangeCapabilitiesMethodStart::vDestroy()
{
   {
      for (tU32 u32Idx = 0; u32Idx < ListOfCommonCapabilities.size(); ++u32Idx)
         ListOfCommonCapabilities[u32Idx].vDestroy();
   }
   ListOfCommonCapabilities.clear();
   {
      for (tU32 u32Idx = 0; u32Idx < ListOfTmcCapabilities.size(); ++u32Idx)
         ListOfTmcCapabilities[u32Idx].vDestroy();
   }
   ListOfTmcCapabilities.clear();
   {
      for (tU32 u32Idx = 0; u32Idx < ListOfTpegCapabilities.size(); ++u32Idx)
         ListOfTpegCapabilities[u32Idx].vDestroy();
   }
   ListOfTpegCapabilities.clear();
   {
      for (tU32 u32Idx = 0; u32Idx < SupportedTpegApplications.size(); ++u32Idx)
         SupportedTpegApplications[u32Idx].vDestroy();
   }
   SupportedTpegApplications.clear();
   SupportedTpegLocReferencing.clear();
   SupportedTpegTfpMethods.clear();
}

tU32 tmctunerfi_tclMsgExchangeCapabilitiesMethodStart::u32GetSize(tU16 u16MajorVersion) const
{
   tU32 u32DynamicSize = 0;
   tU32 u32ListIdx;
   for (u32ListIdx = 0; u32ListIdx < ListOfTmcCapabilities.size(); ++u32ListIdx)
      u32DynamicSize += ListOfTmcCapabilities[u32ListIdx].u32GetSize(u16MajorVersion);
   for (u32ListIdx = 0; u32ListIdx < SupportedTpegApplications.size(); ++u32ListIdx)
      u32DynamicSize += SupportedTpegApplications[u32ListIdx].u32GetSize(u16MajorVersion);
   return u32DynamicSize+24+ListOfCommonCapabilities.size()*2+ListOfTpegCapabilities.size()*2+SupportedTpegLocReferencing.size()*1+SupportedTpegTfpMethods.size()*1;
}

tBool tmctunerfi_tclMsgExchangeCapabilitiesMethodStart::operator==(const tmctunerfi_tclMsgExchangeCapabilitiesMethodStart& rfoCmp) const
{
   tBool bResult = true;
      bResult = bResult && (ListOfCommonCapabilities.size() == rfoCmp.ListOfCommonCapabilities.size());
      if (bResult)
      {
         for (tU32 u32Idx = 0; bResult && (u32Idx < ListOfCommonCapabilities.size()); ++u32Idx)
            bResult = bResult && (ListOfCommonCapabilities[u32Idx] == rfoCmp.ListOfCommonCapabilities[u32Idx]);
      }
      bResult = bResult && (ListOfTmcCapabilities.size() == rfoCmp.ListOfTmcCapabilities.size());
      if (bResult)
      {
         for (tU32 u32Idx = 0; bResult && (u32Idx < ListOfTmcCapabilities.size()); ++u32Idx)
            bResult = bResult && (ListOfTmcCapabilities[u32Idx] == rfoCmp.ListOfTmcCapabilities[u32Idx]);
      }
      bResult = bResult && (ListOfTpegCapabilities.size() == rfoCmp.ListOfTpegCapabilities.size());
      if (bResult)
      {
         for (tU32 u32Idx = 0; bResult && (u32Idx < ListOfTpegCapabilities.size()); ++u32Idx)
            bResult = bResult && (ListOfTpegCapabilities[u32Idx] == rfoCmp.ListOfTpegCapabilities[u32Idx]);
      }
      bResult = bResult && (SupportedTpegApplications.size() == rfoCmp.SupportedTpegApplications.size());
      if (bResult)
      {
         for (tU32 u32Idx = 0; bResult && (u32Idx < SupportedTpegApplications.size()); ++u32Idx)
            bResult = bResult && (SupportedTpegApplications[u32Idx] == rfoCmp.SupportedTpegApplications[u32Idx]);
      }
      bResult = bResult && (SupportedTpegLocReferencing.size() == rfoCmp.SupportedTpegLocReferencing.size());
      if (bResult)
      {
         for (tU32 u32Idx = 0; bResult && (u32Idx < SupportedTpegLocReferencing.size()); ++u32Idx)
            bResult = bResult && (SupportedTpegLocReferencing[u32Idx] == rfoCmp.SupportedTpegLocReferencing[u32Idx]);
      }
      bResult = bResult && (SupportedTpegTfpMethods.size() == rfoCmp.SupportedTpegTfpMethods.size());
      if (bResult)
      {
         for (tU32 u32Idx = 0; bResult && (u32Idx < SupportedTpegTfpMethods.size()); ++u32Idx)
            bResult = bResult && (SupportedTpegTfpMethods[u32Idx] == rfoCmp.SupportedTpegTfpMethods[u32Idx]);
      }
   return bResult;
}

fi_tclInContext& tmctunerfi_tclMsgExchangeCapabilitiesMethodStart::oRead(fi_tclInContext& oIn)
{
   {
      tU32 u32Length;
      tU32 u32Idx;
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
      for (u32Idx = 0; u32Idx < ListOfCommonCapabilities.size(); ++u32Idx)
      {
         ListOfCommonCapabilities[u32Idx].vDestroy();
      }
#endif // !VARIANT_S_FTR_ENABLE_DEEP_COPY
      oIn >> u32Length;
      ListOfCommonCapabilities.resize(u32Length);
      for (u32Idx = 0; u32Idx < u32Length; ++u32Idx)
      {
         oIn >> ListOfCommonCapabilities[u32Idx];
      }
   }
   {
      tU32 u32Length;
      tU32 u32Idx;
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
      for (u32Idx = 0; u32Idx < ListOfTmcCapabilities.size(); ++u32Idx)
      {
         ListOfTmcCapabilities[u32Idx].vDestroy();
      }
#endif // !VARIANT_S_FTR_ENABLE_DEEP_COPY
      oIn >> u32Length;
      ListOfTmcCapabilities.resize(u32Length);
      for (u32Idx = 0; u32Idx < u32Length; ++u32Idx)
      {
         oIn >> ListOfTmcCapabilities[u32Idx];
      }
   }
   {
      tU32 u32Length;
      tU32 u32Idx;
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
      for (u32Idx = 0; u32Idx < ListOfTpegCapabilities.size(); ++u32Idx)
      {
         ListOfTpegCapabilities[u32Idx].vDestroy();
      }
#endif // !VARIANT_S_FTR_ENABLE_DEEP_COPY
      oIn >> u32Length;
      ListOfTpegCapabilities.resize(u32Length);
      for (u32Idx = 0; u32Idx < u32Length; ++u32Idx)
      {
         oIn >> ListOfTpegCapabilities[u32Idx];
      }
   }
   {
      tU32 u32Length;
      tU32 u32Idx;
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
      for (u32Idx = 0; u32Idx < SupportedTpegApplications.size(); ++u32Idx)
      {
         SupportedTpegApplications[u32Idx].vDestroy();
      }
#endif // !VARIANT_S_FTR_ENABLE_DEEP_COPY
      oIn >> u32Length;
      SupportedTpegApplications.resize(u32Length);
      for (u32Idx = 0; u32Idx < u32Length; ++u32Idx)
      {
         oIn >> SupportedTpegApplications[u32Idx];
      }
   }
   {
      tU32 u32Length;
      tU32 u32Idx;
      oIn >> u32Length;
      SupportedTpegLocReferencing.resize(u32Length);
      for (u32Idx = 0; u32Idx < u32Length; ++u32Idx)
      {
         oIn >> SupportedTpegLocReferencing[u32Idx];
      }
   }
   {
      tU32 u32Length;
      tU32 u32Idx;
      oIn >> u32Length;
      SupportedTpegTfpMethods.resize(u32Length);
      for (u32Idx = 0; u32Idx < u32Length; ++u32Idx)
      {
         oIn >> SupportedTpegTfpMethods[u32Idx];
      }
   }
   return oIn;
}

fi_tclOutContext& tmctunerfi_tclMsgExchangeCapabilitiesMethodStart::oWrite(fi_tclOutContext& oOut) const
{
   oOut << (tU32)ListOfCommonCapabilities.size();
   {
      for (tU32 u32Idx = 0; u32Idx < ListOfCommonCapabilities.size(); ++u32Idx)
         oOut << ListOfCommonCapabilities[u32Idx];
   }
   oOut << (tU32)ListOfTmcCapabilities.size();
   {
      for (tU32 u32Idx = 0; u32Idx < ListOfTmcCapabilities.size(); ++u32Idx)
         oOut << ListOfTmcCapabilities[u32Idx];
   }
   oOut << (tU32)ListOfTpegCapabilities.size();
   {
      for (tU32 u32Idx = 0; u32Idx < ListOfTpegCapabilities.size(); ++u32Idx)
         oOut << ListOfTpegCapabilities[u32Idx];
   }
   oOut << (tU32)SupportedTpegApplications.size();
   {
      for (tU32 u32Idx = 0; u32Idx < SupportedTpegApplications.size(); ++u32Idx)
         oOut << SupportedTpegApplications[u32Idx];
   }
   oOut << (tU32)SupportedTpegLocReferencing.size();
   {
      for (tU32 u32Idx = 0; u32Idx < SupportedTpegLocReferencing.size(); ++u32Idx)
         oOut << SupportedTpegLocReferencing[u32Idx];
   }
   oOut << (tU32)SupportedTpegTfpMethods.size();
   {
      for (tU32 u32Idx = 0; u32Idx < SupportedTpegTfpMethods.size(); ++u32Idx)
         oOut << SupportedTpegTfpMethods[u32Idx];
   }
   return oOut;
}

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
tmctunerfi_tclMsgExchangeCapabilitiesMethodResult::tmctunerfi_tclMsgExchangeCapabilitiesMethodResult(const tmctunerfi_tclMsgExchangeCapabilitiesMethodResult& coRef):fi_tclVisitableTypeBase(coRef)
{
   ListOfCommonCapabilities = coRef.ListOfCommonCapabilities;
   ListOfTmcCapabilities = coRef.ListOfTmcCapabilities;
   ListOfTpegCapabilities = coRef.ListOfTpegCapabilities;
   SupportedTpegApplications = coRef.SupportedTpegApplications;
   SupportedTpegLocReferencing = coRef.SupportedTpegLocReferencing;
   SupportedTpegTfpMethods = coRef.SupportedTpegTfpMethods;
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
tmctunerfi_tclMsgExchangeCapabilitiesMethodResult& tmctunerfi_tclMsgExchangeCapabilitiesMethodResult::operator=(const tmctunerfi_tclMsgExchangeCapabilitiesMethodResult& coRef)
{
   if (this == &coRef) return *this;
   ListOfCommonCapabilities = coRef.ListOfCommonCapabilities;
   ListOfTmcCapabilities = coRef.ListOfTmcCapabilities;
   ListOfTpegCapabilities = coRef.ListOfTpegCapabilities;
   SupportedTpegApplications = coRef.SupportedTpegApplications;
   SupportedTpegLocReferencing = coRef.SupportedTpegLocReferencing;
   SupportedTpegTfpMethods = coRef.SupportedTpegTfpMethods;
   return *this;
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
tU16 tmctunerfi_tclMsgExchangeCapabilitiesMethodResult::u16GetServiceID() const {return TMCTUNERFI_C_U16_SERVICE_ID;}
tU16 tmctunerfi_tclMsgExchangeCapabilitiesMethodResult::u16GetFunctionID() const {return TMCTUNERFI_C_U16_EXCHANGECAPABILITIES;}
tU8 tmctunerfi_tclMsgExchangeCapabilitiesMethodResult::u8GetOpCode() const {return CCA_C_U8_OPCODE_METHODRESULT;}

tVoid tmctunerfi_tclMsgExchangeCapabilitiesMethodResult::vDestroy()
{
   {
      for (tU32 u32Idx = 0; u32Idx < ListOfCommonCapabilities.size(); ++u32Idx)
         ListOfCommonCapabilities[u32Idx].vDestroy();
   }
   ListOfCommonCapabilities.clear();
   {
      for (tU32 u32Idx = 0; u32Idx < ListOfTmcCapabilities.size(); ++u32Idx)
         ListOfTmcCapabilities[u32Idx].vDestroy();
   }
   ListOfTmcCapabilities.clear();
   {
      for (tU32 u32Idx = 0; u32Idx < ListOfTpegCapabilities.size(); ++u32Idx)
         ListOfTpegCapabilities[u32Idx].vDestroy();
   }
   ListOfTpegCapabilities.clear();
   {
      for (tU32 u32Idx = 0; u32Idx < SupportedTpegApplications.size(); ++u32Idx)
         SupportedTpegApplications[u32Idx].vDestroy();
   }
   SupportedTpegApplications.clear();
   SupportedTpegLocReferencing.clear();
   SupportedTpegTfpMethods.clear();
}

tU32 tmctunerfi_tclMsgExchangeCapabilitiesMethodResult::u32GetSize(tU16 u16MajorVersion) const
{
   tU32 u32DynamicSize = 0;
   tU32 u32ListIdx;
   for (u32ListIdx = 0; u32ListIdx < ListOfTmcCapabilities.size(); ++u32ListIdx)
      u32DynamicSize += ListOfTmcCapabilities[u32ListIdx].u32GetSize(u16MajorVersion);
   for (u32ListIdx = 0; u32ListIdx < SupportedTpegApplications.size(); ++u32ListIdx)
      u32DynamicSize += SupportedTpegApplications[u32ListIdx].u32GetSize(u16MajorVersion);
   return u32DynamicSize+24+ListOfCommonCapabilities.size()*2+ListOfTpegCapabilities.size()*2+SupportedTpegLocReferencing.size()*1+SupportedTpegTfpMethods.size()*1;
}

tBool tmctunerfi_tclMsgExchangeCapabilitiesMethodResult::operator==(const tmctunerfi_tclMsgExchangeCapabilitiesMethodResult& rfoCmp) const
{
   tBool bResult = true;
      bResult = bResult && (ListOfCommonCapabilities.size() == rfoCmp.ListOfCommonCapabilities.size());
      if (bResult)
      {
         for (tU32 u32Idx = 0; bResult && (u32Idx < ListOfCommonCapabilities.size()); ++u32Idx)
            bResult = bResult && (ListOfCommonCapabilities[u32Idx] == rfoCmp.ListOfCommonCapabilities[u32Idx]);
      }
      bResult = bResult && (ListOfTmcCapabilities.size() == rfoCmp.ListOfTmcCapabilities.size());
      if (bResult)
      {
         for (tU32 u32Idx = 0; bResult && (u32Idx < ListOfTmcCapabilities.size()); ++u32Idx)
            bResult = bResult && (ListOfTmcCapabilities[u32Idx] == rfoCmp.ListOfTmcCapabilities[u32Idx]);
      }
      bResult = bResult && (ListOfTpegCapabilities.size() == rfoCmp.ListOfTpegCapabilities.size());
      if (bResult)
      {
         for (tU32 u32Idx = 0; bResult && (u32Idx < ListOfTpegCapabilities.size()); ++u32Idx)
            bResult = bResult && (ListOfTpegCapabilities[u32Idx] == rfoCmp.ListOfTpegCapabilities[u32Idx]);
      }
      bResult = bResult && (SupportedTpegApplications.size() == rfoCmp.SupportedTpegApplications.size());
      if (bResult)
      {
         for (tU32 u32Idx = 0; bResult && (u32Idx < SupportedTpegApplications.size()); ++u32Idx)
            bResult = bResult && (SupportedTpegApplications[u32Idx] == rfoCmp.SupportedTpegApplications[u32Idx]);
      }
      bResult = bResult && (SupportedTpegLocReferencing.size() == rfoCmp.SupportedTpegLocReferencing.size());
      if (bResult)
      {
         for (tU32 u32Idx = 0; bResult && (u32Idx < SupportedTpegLocReferencing.size()); ++u32Idx)
            bResult = bResult && (SupportedTpegLocReferencing[u32Idx] == rfoCmp.SupportedTpegLocReferencing[u32Idx]);
      }
      bResult = bResult && (SupportedTpegTfpMethods.size() == rfoCmp.SupportedTpegTfpMethods.size());
      if (bResult)
      {
         for (tU32 u32Idx = 0; bResult && (u32Idx < SupportedTpegTfpMethods.size()); ++u32Idx)
            bResult = bResult && (SupportedTpegTfpMethods[u32Idx] == rfoCmp.SupportedTpegTfpMethods[u32Idx]);
      }
   return bResult;
}

fi_tclInContext& tmctunerfi_tclMsgExchangeCapabilitiesMethodResult::oRead(fi_tclInContext& oIn)
{
   {
      tU32 u32Length;
      tU32 u32Idx;
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
      for (u32Idx = 0; u32Idx < ListOfCommonCapabilities.size(); ++u32Idx)
      {
         ListOfCommonCapabilities[u32Idx].vDestroy();
      }
#endif // !VARIANT_S_FTR_ENABLE_DEEP_COPY
      oIn >> u32Length;
      ListOfCommonCapabilities.resize(u32Length);
      for (u32Idx = 0; u32Idx < u32Length; ++u32Idx)
      {
         oIn >> ListOfCommonCapabilities[u32Idx];
      }
   }
   {
      tU32 u32Length;
      tU32 u32Idx;
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
      for (u32Idx = 0; u32Idx < ListOfTmcCapabilities.size(); ++u32Idx)
      {
         ListOfTmcCapabilities[u32Idx].vDestroy();
      }
#endif // !VARIANT_S_FTR_ENABLE_DEEP_COPY
      oIn >> u32Length;
      ListOfTmcCapabilities.resize(u32Length);
      for (u32Idx = 0; u32Idx < u32Length; ++u32Idx)
      {
         oIn >> ListOfTmcCapabilities[u32Idx];
      }
   }
   {
      tU32 u32Length;
      tU32 u32Idx;
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
      for (u32Idx = 0; u32Idx < ListOfTpegCapabilities.size(); ++u32Idx)
      {
         ListOfTpegCapabilities[u32Idx].vDestroy();
      }
#endif // !VARIANT_S_FTR_ENABLE_DEEP_COPY
      oIn >> u32Length;
      ListOfTpegCapabilities.resize(u32Length);
      for (u32Idx = 0; u32Idx < u32Length; ++u32Idx)
      {
         oIn >> ListOfTpegCapabilities[u32Idx];
      }
   }
   {
      tU32 u32Length;
      tU32 u32Idx;
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
      for (u32Idx = 0; u32Idx < SupportedTpegApplications.size(); ++u32Idx)
      {
         SupportedTpegApplications[u32Idx].vDestroy();
      }
#endif // !VARIANT_S_FTR_ENABLE_DEEP_COPY
      oIn >> u32Length;
      SupportedTpegApplications.resize(u32Length);
      for (u32Idx = 0; u32Idx < u32Length; ++u32Idx)
      {
         oIn >> SupportedTpegApplications[u32Idx];
      }
   }
   {
      tU32 u32Length;
      tU32 u32Idx;
      oIn >> u32Length;
      SupportedTpegLocReferencing.resize(u32Length);
      for (u32Idx = 0; u32Idx < u32Length; ++u32Idx)
      {
         oIn >> SupportedTpegLocReferencing[u32Idx];
      }
   }
   {
      tU32 u32Length;
      tU32 u32Idx;
      oIn >> u32Length;
      SupportedTpegTfpMethods.resize(u32Length);
      for (u32Idx = 0; u32Idx < u32Length; ++u32Idx)
      {
         oIn >> SupportedTpegTfpMethods[u32Idx];
      }
   }
   return oIn;
}

fi_tclOutContext& tmctunerfi_tclMsgExchangeCapabilitiesMethodResult::oWrite(fi_tclOutContext& oOut) const
{
   oOut << (tU32)ListOfCommonCapabilities.size();
   {
      for (tU32 u32Idx = 0; u32Idx < ListOfCommonCapabilities.size(); ++u32Idx)
         oOut << ListOfCommonCapabilities[u32Idx];
   }
   oOut << (tU32)ListOfTmcCapabilities.size();
   {
      for (tU32 u32Idx = 0; u32Idx < ListOfTmcCapabilities.size(); ++u32Idx)
         oOut << ListOfTmcCapabilities[u32Idx];
   }
   oOut << (tU32)ListOfTpegCapabilities.size();
   {
      for (tU32 u32Idx = 0; u32Idx < ListOfTpegCapabilities.size(); ++u32Idx)
         oOut << ListOfTpegCapabilities[u32Idx];
   }
   oOut << (tU32)SupportedTpegApplications.size();
   {
      for (tU32 u32Idx = 0; u32Idx < SupportedTpegApplications.size(); ++u32Idx)
         oOut << SupportedTpegApplications[u32Idx];
   }
   oOut << (tU32)SupportedTpegLocReferencing.size();
   {
      for (tU32 u32Idx = 0; u32Idx < SupportedTpegLocReferencing.size(); ++u32Idx)
         oOut << SupportedTpegLocReferencing[u32Idx];
   }
   oOut << (tU32)SupportedTpegTfpMethods.size();
   {
      for (tU32 u32Idx = 0; u32Idx < SupportedTpegTfpMethods.size(); ++u32Idx)
         oOut << SupportedTpegTfpMethods[u32Idx];
   }
   return oOut;
}

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
tmctunerfi_tclMsgTunerModeGet::tmctunerfi_tclMsgTunerModeGet(const tmctunerfi_tclMsgTunerModeGet& coRef):fi_tclVisitableTypeBase(coRef)
{
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
tmctunerfi_tclMsgTunerModeGet& tmctunerfi_tclMsgTunerModeGet::operator=(const tmctunerfi_tclMsgTunerModeGet& coRef)
{
   if (this == &coRef) return *this;
   return *this;
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
tU16 tmctunerfi_tclMsgTunerModeGet::u16GetServiceID() const {return TMCTUNERFI_C_U16_SERVICE_ID;}
tU16 tmctunerfi_tclMsgTunerModeGet::u16GetFunctionID() const {return TMCTUNERFI_C_U16_TUNERMODE;}
tU8 tmctunerfi_tclMsgTunerModeGet::u8GetOpCode() const {return CCA_C_U8_OPCODE_GET;}

tU32 tmctunerfi_tclMsgTunerModeGet::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 0;
}

tBool tmctunerfi_tclMsgTunerModeGet::operator==(const tmctunerfi_tclMsgTunerModeGet& /* rfoCmp */) const
{
   tBool bResult = true;
   return bResult;
}

fi_tclInContext& tmctunerfi_tclMsgTunerModeGet::oRead(fi_tclInContext& oIn)
{
   return oIn;
}

fi_tclOutContext& tmctunerfi_tclMsgTunerModeGet::oWrite(fi_tclOutContext& oOut) const
{
   return oOut;
}

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
tmctunerfi_tclMsgTunerModeUpReg::tmctunerfi_tclMsgTunerModeUpReg(const tmctunerfi_tclMsgTunerModeUpReg& coRef):fi_tclVisitableTypeBase(coRef)
{
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
tmctunerfi_tclMsgTunerModeUpReg& tmctunerfi_tclMsgTunerModeUpReg::operator=(const tmctunerfi_tclMsgTunerModeUpReg& coRef)
{
   if (this == &coRef) return *this;
   return *this;
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
tU16 tmctunerfi_tclMsgTunerModeUpReg::u16GetServiceID() const {return TMCTUNERFI_C_U16_SERVICE_ID;}
tU16 tmctunerfi_tclMsgTunerModeUpReg::u16GetFunctionID() const {return TMCTUNERFI_C_U16_TUNERMODE;}
tU8 tmctunerfi_tclMsgTunerModeUpReg::u8GetOpCode() const {return CCA_C_U8_OPCODE_UPREG;}

tU32 tmctunerfi_tclMsgTunerModeUpReg::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 0;
}

tBool tmctunerfi_tclMsgTunerModeUpReg::operator==(const tmctunerfi_tclMsgTunerModeUpReg& /* rfoCmp */) const
{
   tBool bResult = true;
   return bResult;
}

fi_tclInContext& tmctunerfi_tclMsgTunerModeUpReg::oRead(fi_tclInContext& oIn)
{
   return oIn;
}

fi_tclOutContext& tmctunerfi_tclMsgTunerModeUpReg::oWrite(fi_tclOutContext& oOut) const
{
   return oOut;
}

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
tmctunerfi_tclMsgTunerModeRelUpReg::tmctunerfi_tclMsgTunerModeRelUpReg(const tmctunerfi_tclMsgTunerModeRelUpReg& coRef):fi_tclVisitableTypeBase(coRef)
{
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
tmctunerfi_tclMsgTunerModeRelUpReg& tmctunerfi_tclMsgTunerModeRelUpReg::operator=(const tmctunerfi_tclMsgTunerModeRelUpReg& coRef)
{
   if (this == &coRef) return *this;
   return *this;
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
tU16 tmctunerfi_tclMsgTunerModeRelUpReg::u16GetServiceID() const {return TMCTUNERFI_C_U16_SERVICE_ID;}
tU16 tmctunerfi_tclMsgTunerModeRelUpReg::u16GetFunctionID() const {return TMCTUNERFI_C_U16_TUNERMODE;}
tU8 tmctunerfi_tclMsgTunerModeRelUpReg::u8GetOpCode() const {return CCA_C_U8_OPCODE_RELUPREG;}

tU32 tmctunerfi_tclMsgTunerModeRelUpReg::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 0;
}

tBool tmctunerfi_tclMsgTunerModeRelUpReg::operator==(const tmctunerfi_tclMsgTunerModeRelUpReg& /* rfoCmp */) const
{
   tBool bResult = true;
   return bResult;
}

fi_tclInContext& tmctunerfi_tclMsgTunerModeRelUpReg::oRead(fi_tclInContext& oIn)
{
   return oIn;
}

fi_tclOutContext& tmctunerfi_tclMsgTunerModeRelUpReg::oWrite(fi_tclOutContext& oOut) const
{
   return oOut;
}

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
tmctunerfi_tclMsgTunerModeStatus::tmctunerfi_tclMsgTunerModeStatus(const tmctunerfi_tclMsgTunerModeStatus& coRef):fi_tclVisitableTypeBase(coRef)
{
   TmcMode = coRef.TmcMode;
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
tmctunerfi_tclMsgTunerModeStatus& tmctunerfi_tclMsgTunerModeStatus::operator=(const tmctunerfi_tclMsgTunerModeStatus& coRef)
{
   if (this == &coRef) return *this;
   TmcMode = coRef.TmcMode;
   return *this;
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
tU16 tmctunerfi_tclMsgTunerModeStatus::u16GetServiceID() const {return TMCTUNERFI_C_U16_SERVICE_ID;}
tU16 tmctunerfi_tclMsgTunerModeStatus::u16GetFunctionID() const {return TMCTUNERFI_C_U16_TUNERMODE;}
tU8 tmctunerfi_tclMsgTunerModeStatus::u8GetOpCode() const {return CCA_C_U8_OPCODE_STATUS;}

tU32 tmctunerfi_tclMsgTunerModeStatus::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 1;
}

tBool tmctunerfi_tclMsgTunerModeStatus::operator==(const tmctunerfi_tclMsgTunerModeStatus& rfoCmp) const
{
   tBool bResult = true;
      bResult = bResult && (TmcMode == rfoCmp.TmcMode);
   return bResult;
}

fi_tclInContext& tmctunerfi_tclMsgTunerModeStatus::oRead(fi_tclInContext& oIn)
{
   oIn >> TmcMode;
   return oIn;
}

fi_tclOutContext& tmctunerfi_tclMsgTunerModeStatus::oWrite(fi_tclOutContext& oOut) const
{
   oOut << TmcMode;
   return oOut;
}

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
tmctunerfi_tclMsgTmcDataGet::tmctunerfi_tclMsgTmcDataGet(const tmctunerfi_tclMsgTmcDataGet& coRef):fi_tclVisitableTypeBase(coRef)
{
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
tmctunerfi_tclMsgTmcDataGet& tmctunerfi_tclMsgTmcDataGet::operator=(const tmctunerfi_tclMsgTmcDataGet& coRef)
{
   if (this == &coRef) return *this;
   return *this;
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
tU16 tmctunerfi_tclMsgTmcDataGet::u16GetServiceID() const {return TMCTUNERFI_C_U16_SERVICE_ID;}
tU16 tmctunerfi_tclMsgTmcDataGet::u16GetFunctionID() const {return TMCTUNERFI_C_U16_TMCDATA;}
tU8 tmctunerfi_tclMsgTmcDataGet::u8GetOpCode() const {return CCA_C_U8_OPCODE_GET;}

tU32 tmctunerfi_tclMsgTmcDataGet::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 0;
}

tBool tmctunerfi_tclMsgTmcDataGet::operator==(const tmctunerfi_tclMsgTmcDataGet& /* rfoCmp */) const
{
   tBool bResult = true;
   return bResult;
}

fi_tclInContext& tmctunerfi_tclMsgTmcDataGet::oRead(fi_tclInContext& oIn)
{
   return oIn;
}

fi_tclOutContext& tmctunerfi_tclMsgTmcDataGet::oWrite(fi_tclOutContext& oOut) const
{
   return oOut;
}

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
tmctunerfi_tclMsgTmcDataUpReg::tmctunerfi_tclMsgTmcDataUpReg(const tmctunerfi_tclMsgTmcDataUpReg& coRef):fi_tclVisitableTypeBase(coRef)
{
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
tmctunerfi_tclMsgTmcDataUpReg& tmctunerfi_tclMsgTmcDataUpReg::operator=(const tmctunerfi_tclMsgTmcDataUpReg& coRef)
{
   if (this == &coRef) return *this;
   return *this;
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
tU16 tmctunerfi_tclMsgTmcDataUpReg::u16GetServiceID() const {return TMCTUNERFI_C_U16_SERVICE_ID;}
tU16 tmctunerfi_tclMsgTmcDataUpReg::u16GetFunctionID() const {return TMCTUNERFI_C_U16_TMCDATA;}
tU8 tmctunerfi_tclMsgTmcDataUpReg::u8GetOpCode() const {return CCA_C_U8_OPCODE_UPREG;}

tU32 tmctunerfi_tclMsgTmcDataUpReg::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 0;
}

tBool tmctunerfi_tclMsgTmcDataUpReg::operator==(const tmctunerfi_tclMsgTmcDataUpReg& /* rfoCmp */) const
{
   tBool bResult = true;
   return bResult;
}

fi_tclInContext& tmctunerfi_tclMsgTmcDataUpReg::oRead(fi_tclInContext& oIn)
{
   return oIn;
}

fi_tclOutContext& tmctunerfi_tclMsgTmcDataUpReg::oWrite(fi_tclOutContext& oOut) const
{
   return oOut;
}

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
tmctunerfi_tclMsgTmcDataRelUpReg::tmctunerfi_tclMsgTmcDataRelUpReg(const tmctunerfi_tclMsgTmcDataRelUpReg& coRef):fi_tclVisitableTypeBase(coRef)
{
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
tmctunerfi_tclMsgTmcDataRelUpReg& tmctunerfi_tclMsgTmcDataRelUpReg::operator=(const tmctunerfi_tclMsgTmcDataRelUpReg& coRef)
{
   if (this == &coRef) return *this;
   return *this;
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
tU16 tmctunerfi_tclMsgTmcDataRelUpReg::u16GetServiceID() const {return TMCTUNERFI_C_U16_SERVICE_ID;}
tU16 tmctunerfi_tclMsgTmcDataRelUpReg::u16GetFunctionID() const {return TMCTUNERFI_C_U16_TMCDATA;}
tU8 tmctunerfi_tclMsgTmcDataRelUpReg::u8GetOpCode() const {return CCA_C_U8_OPCODE_RELUPREG;}

tU32 tmctunerfi_tclMsgTmcDataRelUpReg::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 0;
}

tBool tmctunerfi_tclMsgTmcDataRelUpReg::operator==(const tmctunerfi_tclMsgTmcDataRelUpReg& /* rfoCmp */) const
{
   tBool bResult = true;
   return bResult;
}

fi_tclInContext& tmctunerfi_tclMsgTmcDataRelUpReg::oRead(fi_tclInContext& oIn)
{
   return oIn;
}

fi_tclOutContext& tmctunerfi_tclMsgTmcDataRelUpReg::oWrite(fi_tclOutContext& oOut) const
{
   return oOut;
}

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
tmctunerfi_tclMsgTmcDataStatus::tmctunerfi_tclMsgTmcDataStatus(const tmctunerfi_tclMsgTmcDataStatus& coRef):fi_tclVisitableTypeBase(coRef)
{
   CycleStart = coRef.CycleStart;
   RDBId = coRef.RDBId;
   DataForRdbIdComplete = coRef.DataForRdbIdComplete;
   Duplicate = coRef.Duplicate;
   ListOfTrafficInfo = coRef.ListOfTrafficInfo;
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
tmctunerfi_tclMsgTmcDataStatus& tmctunerfi_tclMsgTmcDataStatus::operator=(const tmctunerfi_tclMsgTmcDataStatus& coRef)
{
   if (this == &coRef) return *this;
   CycleStart = coRef.CycleStart;
   RDBId = coRef.RDBId;
   DataForRdbIdComplete = coRef.DataForRdbIdComplete;
   Duplicate = coRef.Duplicate;
   ListOfTrafficInfo = coRef.ListOfTrafficInfo;
   return *this;
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
tU16 tmctunerfi_tclMsgTmcDataStatus::u16GetServiceID() const {return TMCTUNERFI_C_U16_SERVICE_ID;}
tU16 tmctunerfi_tclMsgTmcDataStatus::u16GetFunctionID() const {return TMCTUNERFI_C_U16_TMCDATA;}
tU8 tmctunerfi_tclMsgTmcDataStatus::u8GetOpCode() const {return CCA_C_U8_OPCODE_STATUS;}

tVoid tmctunerfi_tclMsgTmcDataStatus::vDestroy()
{
   RDBId.vDestroy(); 
   {
      for (tU32 u32Idx = 0; u32Idx < ListOfTrafficInfo.size(); ++u32Idx)
         ListOfTrafficInfo[u32Idx].vDestroy();
   }
   ListOfTrafficInfo.clear();
}

tU32 tmctunerfi_tclMsgTmcDataStatus::u32GetSize(tU16 u16MajorVersion) const
{
   tU32 u32DynamicSize = 0;
   if ((2 <= u16MajorVersion) && (u16MajorVersion <= 3))
   {
      u32DynamicSize += 1;
   }
   if ((2 <= u16MajorVersion) && (u16MajorVersion <= 3))
   {
      u32DynamicSize += RDBId.u32GetSize(u16MajorVersion);
   }
   if ((2 <= u16MajorVersion) && (u16MajorVersion <= 3))
   {
      u32DynamicSize += 1;
   }
   if ((2 <= u16MajorVersion) && (u16MajorVersion <= 3))
   {
      u32DynamicSize += 1;
   }
   tU32 u32ListIdx;
   for (u32ListIdx = 0; u32ListIdx < ListOfTrafficInfo.size(); ++u32ListIdx)
      u32DynamicSize += ListOfTrafficInfo[u32ListIdx].u32GetSize(u16MajorVersion);
   return u32DynamicSize+4;
}

tBool tmctunerfi_tclMsgTmcDataStatus::operator==(const tmctunerfi_tclMsgTmcDataStatus& rfoCmp) const
{
   tBool bResult = true;
      bResult = bResult && (CycleStart == rfoCmp.CycleStart);
      bResult = bResult && (RDBId == rfoCmp.RDBId);
      bResult = bResult && (DataForRdbIdComplete == rfoCmp.DataForRdbIdComplete);
      bResult = bResult && (Duplicate == rfoCmp.Duplicate);
      bResult = bResult && (ListOfTrafficInfo.size() == rfoCmp.ListOfTrafficInfo.size());
      if (bResult)
      {
         for (tU32 u32Idx = 0; bResult && (u32Idx < ListOfTrafficInfo.size()); ++u32Idx)
            bResult = bResult && (ListOfTrafficInfo[u32Idx] == rfoCmp.ListOfTrafficInfo[u32Idx]);
      }
   return bResult;
}

fi_tclInContext& tmctunerfi_tclMsgTmcDataStatus::oRead(fi_tclInContext& oIn)
{
   if ((2 <= oIn.u16GetMajorVersion()) && (oIn.u16GetMajorVersion() <= 3))
   {
      oIn >> CycleStart;
   }
   if ((2 <= oIn.u16GetMajorVersion()) && (oIn.u16GetMajorVersion() <= 3))
   {
      oIn >> RDBId;
   }
   if ((2 <= oIn.u16GetMajorVersion()) && (oIn.u16GetMajorVersion() <= 3))
   {
      oIn >> DataForRdbIdComplete;
   }
   if ((2 <= oIn.u16GetMajorVersion()) && (oIn.u16GetMajorVersion() <= 3))
   {
      oIn >> Duplicate;
   }
   {
      tU32 u32Length;
      tU32 u32Idx;
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
      for (u32Idx = 0; u32Idx < ListOfTrafficInfo.size(); ++u32Idx)
      {
         ListOfTrafficInfo[u32Idx].vDestroy();
      }
#endif // !VARIANT_S_FTR_ENABLE_DEEP_COPY
      oIn >> u32Length;
      ListOfTrafficInfo.resize(u32Length);
      for (u32Idx = 0; u32Idx < u32Length; ++u32Idx)
      {
         oIn >> ListOfTrafficInfo[u32Idx];
      }
   }
   return oIn;
}

fi_tclOutContext& tmctunerfi_tclMsgTmcDataStatus::oWrite(fi_tclOutContext& oOut) const
{
   if ((2 <= oOut.u16GetMajorVersion()) && (oOut.u16GetMajorVersion() <= 3))
   {
      oOut << CycleStart;
   }
   if ((2 <= oOut.u16GetMajorVersion()) && (oOut.u16GetMajorVersion() <= 3))
   {
      oOut << RDBId;
   }
   if ((2 <= oOut.u16GetMajorVersion()) && (oOut.u16GetMajorVersion() <= 3))
   {
      oOut << DataForRdbIdComplete;
   }
   if ((2 <= oOut.u16GetMajorVersion()) && (oOut.u16GetMajorVersion() <= 3))
   {
      oOut << Duplicate;
   }
   oOut << (tU32)ListOfTrafficInfo.size();
   {
      for (tU32 u32Idx = 0; u32Idx < ListOfTrafficInfo.size(); ++u32Idx)
         oOut << ListOfTrafficInfo[u32Idx];
   }
   return oOut;
}

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
tmctunerfi_tclMsgOperationModeGet::tmctunerfi_tclMsgOperationModeGet(const tmctunerfi_tclMsgOperationModeGet& coRef):fi_tclVisitableTypeBase(coRef)
{
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
tmctunerfi_tclMsgOperationModeGet& tmctunerfi_tclMsgOperationModeGet::operator=(const tmctunerfi_tclMsgOperationModeGet& coRef)
{
   if (this == &coRef) return *this;
   return *this;
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
tU16 tmctunerfi_tclMsgOperationModeGet::u16GetServiceID() const {return TMCTUNERFI_C_U16_SERVICE_ID;}
tU16 tmctunerfi_tclMsgOperationModeGet::u16GetFunctionID() const {return TMCTUNERFI_C_U16_OPERATIONMODE;}
tU8 tmctunerfi_tclMsgOperationModeGet::u8GetOpCode() const {return CCA_C_U8_OPCODE_GET;}

tU32 tmctunerfi_tclMsgOperationModeGet::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 0;
}

tBool tmctunerfi_tclMsgOperationModeGet::operator==(const tmctunerfi_tclMsgOperationModeGet& /* rfoCmp */) const
{
   tBool bResult = true;
   return bResult;
}

fi_tclInContext& tmctunerfi_tclMsgOperationModeGet::oRead(fi_tclInContext& oIn)
{
   return oIn;
}

fi_tclOutContext& tmctunerfi_tclMsgOperationModeGet::oWrite(fi_tclOutContext& oOut) const
{
   return oOut;
}

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
tmctunerfi_tclMsgOperationModeUpReg::tmctunerfi_tclMsgOperationModeUpReg(const tmctunerfi_tclMsgOperationModeUpReg& coRef):fi_tclVisitableTypeBase(coRef)
{
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
tmctunerfi_tclMsgOperationModeUpReg& tmctunerfi_tclMsgOperationModeUpReg::operator=(const tmctunerfi_tclMsgOperationModeUpReg& coRef)
{
   if (this == &coRef) return *this;
   return *this;
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
tU16 tmctunerfi_tclMsgOperationModeUpReg::u16GetServiceID() const {return TMCTUNERFI_C_U16_SERVICE_ID;}
tU16 tmctunerfi_tclMsgOperationModeUpReg::u16GetFunctionID() const {return TMCTUNERFI_C_U16_OPERATIONMODE;}
tU8 tmctunerfi_tclMsgOperationModeUpReg::u8GetOpCode() const {return CCA_C_U8_OPCODE_UPREG;}

tU32 tmctunerfi_tclMsgOperationModeUpReg::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 0;
}

tBool tmctunerfi_tclMsgOperationModeUpReg::operator==(const tmctunerfi_tclMsgOperationModeUpReg& /* rfoCmp */) const
{
   tBool bResult = true;
   return bResult;
}

fi_tclInContext& tmctunerfi_tclMsgOperationModeUpReg::oRead(fi_tclInContext& oIn)
{
   return oIn;
}

fi_tclOutContext& tmctunerfi_tclMsgOperationModeUpReg::oWrite(fi_tclOutContext& oOut) const
{
   return oOut;
}

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
tmctunerfi_tclMsgOperationModeRelUpReg::tmctunerfi_tclMsgOperationModeRelUpReg(const tmctunerfi_tclMsgOperationModeRelUpReg& coRef):fi_tclVisitableTypeBase(coRef)
{
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
tmctunerfi_tclMsgOperationModeRelUpReg& tmctunerfi_tclMsgOperationModeRelUpReg::operator=(const tmctunerfi_tclMsgOperationModeRelUpReg& coRef)
{
   if (this == &coRef) return *this;
   return *this;
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
tU16 tmctunerfi_tclMsgOperationModeRelUpReg::u16GetServiceID() const {return TMCTUNERFI_C_U16_SERVICE_ID;}
tU16 tmctunerfi_tclMsgOperationModeRelUpReg::u16GetFunctionID() const {return TMCTUNERFI_C_U16_OPERATIONMODE;}
tU8 tmctunerfi_tclMsgOperationModeRelUpReg::u8GetOpCode() const {return CCA_C_U8_OPCODE_RELUPREG;}

tU32 tmctunerfi_tclMsgOperationModeRelUpReg::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 0;
}

tBool tmctunerfi_tclMsgOperationModeRelUpReg::operator==(const tmctunerfi_tclMsgOperationModeRelUpReg& /* rfoCmp */) const
{
   tBool bResult = true;
   return bResult;
}

fi_tclInContext& tmctunerfi_tclMsgOperationModeRelUpReg::oRead(fi_tclInContext& oIn)
{
   return oIn;
}

fi_tclOutContext& tmctunerfi_tclMsgOperationModeRelUpReg::oWrite(fi_tclOutContext& oOut) const
{
   return oOut;
}

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
tmctunerfi_tclMsgOperationModeStatus::tmctunerfi_tclMsgOperationModeStatus(const tmctunerfi_tclMsgOperationModeStatus& coRef):fi_tclVisitableTypeBase(coRef)
{
   TmcOperationMode = coRef.TmcOperationMode;
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
tmctunerfi_tclMsgOperationModeStatus& tmctunerfi_tclMsgOperationModeStatus::operator=(const tmctunerfi_tclMsgOperationModeStatus& coRef)
{
   if (this == &coRef) return *this;
   TmcOperationMode = coRef.TmcOperationMode;
   return *this;
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
tU16 tmctunerfi_tclMsgOperationModeStatus::u16GetServiceID() const {return TMCTUNERFI_C_U16_SERVICE_ID;}
tU16 tmctunerfi_tclMsgOperationModeStatus::u16GetFunctionID() const {return TMCTUNERFI_C_U16_OPERATIONMODE;}
tU8 tmctunerfi_tclMsgOperationModeStatus::u8GetOpCode() const {return CCA_C_U8_OPCODE_STATUS;}

tU32 tmctunerfi_tclMsgOperationModeStatus::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 1;
}

tBool tmctunerfi_tclMsgOperationModeStatus::operator==(const tmctunerfi_tclMsgOperationModeStatus& rfoCmp) const
{
   tBool bResult = true;
      bResult = bResult && (TmcOperationMode == rfoCmp.TmcOperationMode);
   return bResult;
}

fi_tclInContext& tmctunerfi_tclMsgOperationModeStatus::oRead(fi_tclInContext& oIn)
{
   oIn >> TmcOperationMode;
   return oIn;
}

fi_tclOutContext& tmctunerfi_tclMsgOperationModeStatus::oWrite(fi_tclOutContext& oOut) const
{
   oOut << TmcOperationMode;
   return oOut;
}

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
tmctunerfi_tclMsgRdbIdActualListGet::tmctunerfi_tclMsgRdbIdActualListGet(const tmctunerfi_tclMsgRdbIdActualListGet& coRef):fi_tclVisitableTypeBase(coRef)
{
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
tmctunerfi_tclMsgRdbIdActualListGet& tmctunerfi_tclMsgRdbIdActualListGet::operator=(const tmctunerfi_tclMsgRdbIdActualListGet& coRef)
{
   if (this == &coRef) return *this;
   return *this;
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
tU16 tmctunerfi_tclMsgRdbIdActualListGet::u16GetServiceID() const {return TMCTUNERFI_C_U16_SERVICE_ID;}
tU16 tmctunerfi_tclMsgRdbIdActualListGet::u16GetFunctionID() const {return TMCTUNERFI_C_U16_RDBIDACTUALLIST;}
tU8 tmctunerfi_tclMsgRdbIdActualListGet::u8GetOpCode() const {return CCA_C_U8_OPCODE_GET;}

tU32 tmctunerfi_tclMsgRdbIdActualListGet::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 0;
}

tBool tmctunerfi_tclMsgRdbIdActualListGet::operator==(const tmctunerfi_tclMsgRdbIdActualListGet& /* rfoCmp */) const
{
   tBool bResult = true;
   return bResult;
}

fi_tclInContext& tmctunerfi_tclMsgRdbIdActualListGet::oRead(fi_tclInContext& oIn)
{
   return oIn;
}

fi_tclOutContext& tmctunerfi_tclMsgRdbIdActualListGet::oWrite(fi_tclOutContext& oOut) const
{
   return oOut;
}

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
tmctunerfi_tclMsgRdbIdActualListUpReg::tmctunerfi_tclMsgRdbIdActualListUpReg(const tmctunerfi_tclMsgRdbIdActualListUpReg& coRef):fi_tclVisitableTypeBase(coRef)
{
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
tmctunerfi_tclMsgRdbIdActualListUpReg& tmctunerfi_tclMsgRdbIdActualListUpReg::operator=(const tmctunerfi_tclMsgRdbIdActualListUpReg& coRef)
{
   if (this == &coRef) return *this;
   return *this;
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
tU16 tmctunerfi_tclMsgRdbIdActualListUpReg::u16GetServiceID() const {return TMCTUNERFI_C_U16_SERVICE_ID;}
tU16 tmctunerfi_tclMsgRdbIdActualListUpReg::u16GetFunctionID() const {return TMCTUNERFI_C_U16_RDBIDACTUALLIST;}
tU8 tmctunerfi_tclMsgRdbIdActualListUpReg::u8GetOpCode() const {return CCA_C_U8_OPCODE_UPREG;}

tU32 tmctunerfi_tclMsgRdbIdActualListUpReg::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 0;
}

tBool tmctunerfi_tclMsgRdbIdActualListUpReg::operator==(const tmctunerfi_tclMsgRdbIdActualListUpReg& /* rfoCmp */) const
{
   tBool bResult = true;
   return bResult;
}

fi_tclInContext& tmctunerfi_tclMsgRdbIdActualListUpReg::oRead(fi_tclInContext& oIn)
{
   return oIn;
}

fi_tclOutContext& tmctunerfi_tclMsgRdbIdActualListUpReg::oWrite(fi_tclOutContext& oOut) const
{
   return oOut;
}

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
tmctunerfi_tclMsgRdbIdActualListRelUpReg::tmctunerfi_tclMsgRdbIdActualListRelUpReg(const tmctunerfi_tclMsgRdbIdActualListRelUpReg& coRef):fi_tclVisitableTypeBase(coRef)
{
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
tmctunerfi_tclMsgRdbIdActualListRelUpReg& tmctunerfi_tclMsgRdbIdActualListRelUpReg::operator=(const tmctunerfi_tclMsgRdbIdActualListRelUpReg& coRef)
{
   if (this == &coRef) return *this;
   return *this;
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
tU16 tmctunerfi_tclMsgRdbIdActualListRelUpReg::u16GetServiceID() const {return TMCTUNERFI_C_U16_SERVICE_ID;}
tU16 tmctunerfi_tclMsgRdbIdActualListRelUpReg::u16GetFunctionID() const {return TMCTUNERFI_C_U16_RDBIDACTUALLIST;}
tU8 tmctunerfi_tclMsgRdbIdActualListRelUpReg::u8GetOpCode() const {return CCA_C_U8_OPCODE_RELUPREG;}

tU32 tmctunerfi_tclMsgRdbIdActualListRelUpReg::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 0;
}

tBool tmctunerfi_tclMsgRdbIdActualListRelUpReg::operator==(const tmctunerfi_tclMsgRdbIdActualListRelUpReg& /* rfoCmp */) const
{
   tBool bResult = true;
   return bResult;
}

fi_tclInContext& tmctunerfi_tclMsgRdbIdActualListRelUpReg::oRead(fi_tclInContext& oIn)
{
   return oIn;
}

fi_tclOutContext& tmctunerfi_tclMsgRdbIdActualListRelUpReg::oWrite(fi_tclOutContext& oOut) const
{
   return oOut;
}

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
tmctunerfi_tclMsgRdbIdActualListStatus::tmctunerfi_tclMsgRdbIdActualListStatus(const tmctunerfi_tclMsgRdbIdActualListStatus& coRef):fi_tclVisitableTypeBase(coRef)
{
   ReceptionState = coRef.ReceptionState;
   ListOfRdbIds = coRef.ListOfRdbIds;
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
tmctunerfi_tclMsgRdbIdActualListStatus& tmctunerfi_tclMsgRdbIdActualListStatus::operator=(const tmctunerfi_tclMsgRdbIdActualListStatus& coRef)
{
   if (this == &coRef) return *this;
   ReceptionState = coRef.ReceptionState;
   ListOfRdbIds = coRef.ListOfRdbIds;
   return *this;
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
tU16 tmctunerfi_tclMsgRdbIdActualListStatus::u16GetServiceID() const {return TMCTUNERFI_C_U16_SERVICE_ID;}
tU16 tmctunerfi_tclMsgRdbIdActualListStatus::u16GetFunctionID() const {return TMCTUNERFI_C_U16_RDBIDACTUALLIST;}
tU8 tmctunerfi_tclMsgRdbIdActualListStatus::u8GetOpCode() const {return CCA_C_U8_OPCODE_STATUS;}

tVoid tmctunerfi_tclMsgRdbIdActualListStatus::vDestroy()
{
   {
      for (tU32 u32Idx = 0; u32Idx < ListOfRdbIds.size(); ++u32Idx)
         ListOfRdbIds[u32Idx].vDestroy();
   }
   ListOfRdbIds.clear();
}

tU32 tmctunerfi_tclMsgRdbIdActualListStatus::u32GetSize(tU16 u16MajorVersion) const
{
   tU32 u32DynamicSize = 0;
   if (4 <= u16MajorVersion)
   {
      u32DynamicSize += 1;
   }
   tU32 u32ListIdx;
   for (u32ListIdx = 0; u32ListIdx < ListOfRdbIds.size(); ++u32ListIdx)
      u32DynamicSize += ListOfRdbIds[u32ListIdx].u32GetSize(u16MajorVersion);
   return u32DynamicSize+4;
}

tBool tmctunerfi_tclMsgRdbIdActualListStatus::operator==(const tmctunerfi_tclMsgRdbIdActualListStatus& rfoCmp) const
{
   tBool bResult = true;
      bResult = bResult && (ReceptionState == rfoCmp.ReceptionState);
      bResult = bResult && (ListOfRdbIds.size() == rfoCmp.ListOfRdbIds.size());
      if (bResult)
      {
         for (tU32 u32Idx = 0; bResult && (u32Idx < ListOfRdbIds.size()); ++u32Idx)
            bResult = bResult && (ListOfRdbIds[u32Idx] == rfoCmp.ListOfRdbIds[u32Idx]);
      }
   return bResult;
}

fi_tclInContext& tmctunerfi_tclMsgRdbIdActualListStatus::oRead(fi_tclInContext& oIn)
{
   if (4 <= oIn.u16GetMajorVersion())
   {
      oIn >> ReceptionState;
   }
   {
      tU32 u32Length;
      tU32 u32Idx;
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
      for (u32Idx = 0; u32Idx < ListOfRdbIds.size(); ++u32Idx)
      {
         ListOfRdbIds[u32Idx].vDestroy();
      }
#endif // !VARIANT_S_FTR_ENABLE_DEEP_COPY
      oIn >> u32Length;
      ListOfRdbIds.resize(u32Length);
      for (u32Idx = 0; u32Idx < u32Length; ++u32Idx)
      {
         oIn >> ListOfRdbIds[u32Idx];
      }
   }
   return oIn;
}

fi_tclOutContext& tmctunerfi_tclMsgRdbIdActualListStatus::oWrite(fi_tclOutContext& oOut) const
{
   if (4 <= oOut.u16GetMajorVersion())
   {
      oOut << ReceptionState;
   }
   oOut << (tU32)ListOfRdbIds.size();
   {
      for (tU32 u32Idx = 0; u32Idx < ListOfRdbIds.size(); ++u32Idx)
         oOut << ListOfRdbIds[u32Idx];
   }
   return oOut;
}

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
tmctunerfi_tclMsgTunerStateAndModeGet::tmctunerfi_tclMsgTunerStateAndModeGet(const tmctunerfi_tclMsgTunerStateAndModeGet& coRef):fi_tclVisitableTypeBase(coRef)
{
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
tmctunerfi_tclMsgTunerStateAndModeGet& tmctunerfi_tclMsgTunerStateAndModeGet::operator=(const tmctunerfi_tclMsgTunerStateAndModeGet& coRef)
{
   if (this == &coRef) return *this;
   return *this;
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
tU16 tmctunerfi_tclMsgTunerStateAndModeGet::u16GetServiceID() const {return TMCTUNERFI_C_U16_SERVICE_ID;}
tU16 tmctunerfi_tclMsgTunerStateAndModeGet::u16GetFunctionID() const {return TMCTUNERFI_C_U16_TUNERSTATEANDMODE;}
tU8 tmctunerfi_tclMsgTunerStateAndModeGet::u8GetOpCode() const {return CCA_C_U8_OPCODE_GET;}

tU32 tmctunerfi_tclMsgTunerStateAndModeGet::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 0;
}

tBool tmctunerfi_tclMsgTunerStateAndModeGet::operator==(const tmctunerfi_tclMsgTunerStateAndModeGet& /* rfoCmp */) const
{
   tBool bResult = true;
   return bResult;
}

fi_tclInContext& tmctunerfi_tclMsgTunerStateAndModeGet::oRead(fi_tclInContext& oIn)
{
   return oIn;
}

fi_tclOutContext& tmctunerfi_tclMsgTunerStateAndModeGet::oWrite(fi_tclOutContext& oOut) const
{
   return oOut;
}

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
tmctunerfi_tclMsgTunerStateAndModeUpReg::tmctunerfi_tclMsgTunerStateAndModeUpReg(const tmctunerfi_tclMsgTunerStateAndModeUpReg& coRef):fi_tclVisitableTypeBase(coRef)
{
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
tmctunerfi_tclMsgTunerStateAndModeUpReg& tmctunerfi_tclMsgTunerStateAndModeUpReg::operator=(const tmctunerfi_tclMsgTunerStateAndModeUpReg& coRef)
{
   if (this == &coRef) return *this;
   return *this;
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
tU16 tmctunerfi_tclMsgTunerStateAndModeUpReg::u16GetServiceID() const {return TMCTUNERFI_C_U16_SERVICE_ID;}
tU16 tmctunerfi_tclMsgTunerStateAndModeUpReg::u16GetFunctionID() const {return TMCTUNERFI_C_U16_TUNERSTATEANDMODE;}
tU8 tmctunerfi_tclMsgTunerStateAndModeUpReg::u8GetOpCode() const {return CCA_C_U8_OPCODE_UPREG;}

tU32 tmctunerfi_tclMsgTunerStateAndModeUpReg::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 0;
}

tBool tmctunerfi_tclMsgTunerStateAndModeUpReg::operator==(const tmctunerfi_tclMsgTunerStateAndModeUpReg& /* rfoCmp */) const
{
   tBool bResult = true;
   return bResult;
}

fi_tclInContext& tmctunerfi_tclMsgTunerStateAndModeUpReg::oRead(fi_tclInContext& oIn)
{
   return oIn;
}

fi_tclOutContext& tmctunerfi_tclMsgTunerStateAndModeUpReg::oWrite(fi_tclOutContext& oOut) const
{
   return oOut;
}

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
tmctunerfi_tclMsgTunerStateAndModeRelUpReg::tmctunerfi_tclMsgTunerStateAndModeRelUpReg(const tmctunerfi_tclMsgTunerStateAndModeRelUpReg& coRef):fi_tclVisitableTypeBase(coRef)
{
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
tmctunerfi_tclMsgTunerStateAndModeRelUpReg& tmctunerfi_tclMsgTunerStateAndModeRelUpReg::operator=(const tmctunerfi_tclMsgTunerStateAndModeRelUpReg& coRef)
{
   if (this == &coRef) return *this;
   return *this;
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
tU16 tmctunerfi_tclMsgTunerStateAndModeRelUpReg::u16GetServiceID() const {return TMCTUNERFI_C_U16_SERVICE_ID;}
tU16 tmctunerfi_tclMsgTunerStateAndModeRelUpReg::u16GetFunctionID() const {return TMCTUNERFI_C_U16_TUNERSTATEANDMODE;}
tU8 tmctunerfi_tclMsgTunerStateAndModeRelUpReg::u8GetOpCode() const {return CCA_C_U8_OPCODE_RELUPREG;}

tU32 tmctunerfi_tclMsgTunerStateAndModeRelUpReg::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 0;
}

tBool tmctunerfi_tclMsgTunerStateAndModeRelUpReg::operator==(const tmctunerfi_tclMsgTunerStateAndModeRelUpReg& /* rfoCmp */) const
{
   tBool bResult = true;
   return bResult;
}

fi_tclInContext& tmctunerfi_tclMsgTunerStateAndModeRelUpReg::oRead(fi_tclInContext& oIn)
{
   return oIn;
}

fi_tclOutContext& tmctunerfi_tclMsgTunerStateAndModeRelUpReg::oWrite(fi_tclOutContext& oOut) const
{
   return oOut;
}

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
tmctunerfi_tclMsgTunerStateAndModeStatus::tmctunerfi_tclMsgTunerStateAndModeStatus(const tmctunerfi_tclMsgTunerStateAndModeStatus& coRef):fi_tclVisitableTypeBase(coRef)
{
   TunerState = coRef.TunerState;
   OperationMode = coRef.OperationMode;
   Message = coRef.Message;
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
tmctunerfi_tclMsgTunerStateAndModeStatus& tmctunerfi_tclMsgTunerStateAndModeStatus::operator=(const tmctunerfi_tclMsgTunerStateAndModeStatus& coRef)
{
   if (this == &coRef) return *this;
   TunerState = coRef.TunerState;
   OperationMode = coRef.OperationMode;
   Message = coRef.Message;
   return *this;
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
tU16 tmctunerfi_tclMsgTunerStateAndModeStatus::u16GetServiceID() const {return TMCTUNERFI_C_U16_SERVICE_ID;}
tU16 tmctunerfi_tclMsgTunerStateAndModeStatus::u16GetFunctionID() const {return TMCTUNERFI_C_U16_TUNERSTATEANDMODE;}
tU8 tmctunerfi_tclMsgTunerStateAndModeStatus::u8GetOpCode() const {return CCA_C_U8_OPCODE_STATUS;}

tVoid tmctunerfi_tclMsgTunerStateAndModeStatus::vDestroy()
{
   Message.vDestroy();
}

tU32 tmctunerfi_tclMsgTunerStateAndModeStatus::u32GetSize(tU16 u16MajorVersion) const
{
   tU32 u32DynamicSize = 0;
   if (u16MajorVersion <= 2)
   {
      u32DynamicSize += 1;
   }
   if (u16MajorVersion <= 2)
   {
      u32DynamicSize += 1;
   }
   if (3 <= u16MajorVersion)
   {
      u32DynamicSize += Message.u32GetSize(u16MajorVersion);
   }
   return u32DynamicSize+0;
}

tBool tmctunerfi_tclMsgTunerStateAndModeStatus::operator==(const tmctunerfi_tclMsgTunerStateAndModeStatus& rfoCmp) const
{
   tBool bResult = true;
      bResult = bResult && (TunerState == rfoCmp.TunerState);
      bResult = bResult && (OperationMode == rfoCmp.OperationMode);
      bResult = bResult && (Message == rfoCmp.Message);
   return bResult;
}

fi_tclInContext& tmctunerfi_tclMsgTunerStateAndModeStatus::oRead(fi_tclInContext& oIn)
{
   if (oIn.u16GetMajorVersion() <= 2)
   {
      oIn >> TunerState;
   }
   if (oIn.u16GetMajorVersion() <= 2)
   {
      oIn >> OperationMode;
   }
   if (3 <= oIn.u16GetMajorVersion())
   {
      oIn >> Message;
   }
   return oIn;
}

fi_tclOutContext& tmctunerfi_tclMsgTunerStateAndModeStatus::oWrite(fi_tclOutContext& oOut) const
{
   if (oOut.u16GetMajorVersion() <= 2)
   {
      oOut << TunerState;
   }
   if (oOut.u16GetMajorVersion() <= 2)
   {
      oOut << OperationMode;
   }
   if (3 <= oOut.u16GetMajorVersion())
   {
      oOut << Message;
   }
   return oOut;
}

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
tmctunerfi_tclMsgCurrentUserSelectedTmcStationGet::tmctunerfi_tclMsgCurrentUserSelectedTmcStationGet(const tmctunerfi_tclMsgCurrentUserSelectedTmcStationGet& coRef):fi_tclVisitableTypeBase(coRef)
{
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
tmctunerfi_tclMsgCurrentUserSelectedTmcStationGet& tmctunerfi_tclMsgCurrentUserSelectedTmcStationGet::operator=(const tmctunerfi_tclMsgCurrentUserSelectedTmcStationGet& coRef)
{
   if (this == &coRef) return *this;
   return *this;
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
tU16 tmctunerfi_tclMsgCurrentUserSelectedTmcStationGet::u16GetServiceID() const {return TMCTUNERFI_C_U16_SERVICE_ID;}
tU16 tmctunerfi_tclMsgCurrentUserSelectedTmcStationGet::u16GetFunctionID() const {return TMCTUNERFI_C_U16_CURRENTUSERSELECTEDTMCSTATION;}
tU8 tmctunerfi_tclMsgCurrentUserSelectedTmcStationGet::u8GetOpCode() const {return CCA_C_U8_OPCODE_GET;}

tU32 tmctunerfi_tclMsgCurrentUserSelectedTmcStationGet::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 0;
}

tBool tmctunerfi_tclMsgCurrentUserSelectedTmcStationGet::operator==(const tmctunerfi_tclMsgCurrentUserSelectedTmcStationGet& /* rfoCmp */) const
{
   tBool bResult = true;
   return bResult;
}

fi_tclInContext& tmctunerfi_tclMsgCurrentUserSelectedTmcStationGet::oRead(fi_tclInContext& oIn)
{
   return oIn;
}

fi_tclOutContext& tmctunerfi_tclMsgCurrentUserSelectedTmcStationGet::oWrite(fi_tclOutContext& oOut) const
{
   return oOut;
}

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
tmctunerfi_tclMsgCurrentUserSelectedTmcStationUpReg::tmctunerfi_tclMsgCurrentUserSelectedTmcStationUpReg(const tmctunerfi_tclMsgCurrentUserSelectedTmcStationUpReg& coRef):fi_tclVisitableTypeBase(coRef)
{
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
tmctunerfi_tclMsgCurrentUserSelectedTmcStationUpReg& tmctunerfi_tclMsgCurrentUserSelectedTmcStationUpReg::operator=(const tmctunerfi_tclMsgCurrentUserSelectedTmcStationUpReg& coRef)
{
   if (this == &coRef) return *this;
   return *this;
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
tU16 tmctunerfi_tclMsgCurrentUserSelectedTmcStationUpReg::u16GetServiceID() const {return TMCTUNERFI_C_U16_SERVICE_ID;}
tU16 tmctunerfi_tclMsgCurrentUserSelectedTmcStationUpReg::u16GetFunctionID() const {return TMCTUNERFI_C_U16_CURRENTUSERSELECTEDTMCSTATION;}
tU8 tmctunerfi_tclMsgCurrentUserSelectedTmcStationUpReg::u8GetOpCode() const {return CCA_C_U8_OPCODE_UPREG;}

tU32 tmctunerfi_tclMsgCurrentUserSelectedTmcStationUpReg::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 0;
}

tBool tmctunerfi_tclMsgCurrentUserSelectedTmcStationUpReg::operator==(const tmctunerfi_tclMsgCurrentUserSelectedTmcStationUpReg& /* rfoCmp */) const
{
   tBool bResult = true;
   return bResult;
}

fi_tclInContext& tmctunerfi_tclMsgCurrentUserSelectedTmcStationUpReg::oRead(fi_tclInContext& oIn)
{
   return oIn;
}

fi_tclOutContext& tmctunerfi_tclMsgCurrentUserSelectedTmcStationUpReg::oWrite(fi_tclOutContext& oOut) const
{
   return oOut;
}

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
tmctunerfi_tclMsgCurrentUserSelectedTmcStationRelUpReg::tmctunerfi_tclMsgCurrentUserSelectedTmcStationRelUpReg(const tmctunerfi_tclMsgCurrentUserSelectedTmcStationRelUpReg& coRef):fi_tclVisitableTypeBase(coRef)
{
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
tmctunerfi_tclMsgCurrentUserSelectedTmcStationRelUpReg& tmctunerfi_tclMsgCurrentUserSelectedTmcStationRelUpReg::operator=(const tmctunerfi_tclMsgCurrentUserSelectedTmcStationRelUpReg& coRef)
{
   if (this == &coRef) return *this;
   return *this;
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
tU16 tmctunerfi_tclMsgCurrentUserSelectedTmcStationRelUpReg::u16GetServiceID() const {return TMCTUNERFI_C_U16_SERVICE_ID;}
tU16 tmctunerfi_tclMsgCurrentUserSelectedTmcStationRelUpReg::u16GetFunctionID() const {return TMCTUNERFI_C_U16_CURRENTUSERSELECTEDTMCSTATION;}
tU8 tmctunerfi_tclMsgCurrentUserSelectedTmcStationRelUpReg::u8GetOpCode() const {return CCA_C_U8_OPCODE_RELUPREG;}

tU32 tmctunerfi_tclMsgCurrentUserSelectedTmcStationRelUpReg::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 0;
}

tBool tmctunerfi_tclMsgCurrentUserSelectedTmcStationRelUpReg::operator==(const tmctunerfi_tclMsgCurrentUserSelectedTmcStationRelUpReg& /* rfoCmp */) const
{
   tBool bResult = true;
   return bResult;
}

fi_tclInContext& tmctunerfi_tclMsgCurrentUserSelectedTmcStationRelUpReg::oRead(fi_tclInContext& oIn)
{
   return oIn;
}

fi_tclOutContext& tmctunerfi_tclMsgCurrentUserSelectedTmcStationRelUpReg::oWrite(fi_tclOutContext& oOut) const
{
   return oOut;
}

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
tmctunerfi_tclMsgCurrentUserSelectedTmcStationStatus::tmctunerfi_tclMsgCurrentUserSelectedTmcStationStatus(const tmctunerfi_tclMsgCurrentUserSelectedTmcStationStatus& coRef):fi_tclVisitableTypeBase(coRef)
{
   RDBId = coRef.RDBId;
   ProgramId = coRef.ProgramId;
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
tmctunerfi_tclMsgCurrentUserSelectedTmcStationStatus& tmctunerfi_tclMsgCurrentUserSelectedTmcStationStatus::operator=(const tmctunerfi_tclMsgCurrentUserSelectedTmcStationStatus& coRef)
{
   if (this == &coRef) return *this;
   RDBId = coRef.RDBId;
   ProgramId = coRef.ProgramId;
   return *this;
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
tU16 tmctunerfi_tclMsgCurrentUserSelectedTmcStationStatus::u16GetServiceID() const {return TMCTUNERFI_C_U16_SERVICE_ID;}
tU16 tmctunerfi_tclMsgCurrentUserSelectedTmcStationStatus::u16GetFunctionID() const {return TMCTUNERFI_C_U16_CURRENTUSERSELECTEDTMCSTATION;}
tU8 tmctunerfi_tclMsgCurrentUserSelectedTmcStationStatus::u8GetOpCode() const {return CCA_C_U8_OPCODE_STATUS;}

tVoid tmctunerfi_tclMsgCurrentUserSelectedTmcStationStatus::vDestroy()
{
   RDBId.vDestroy(); 
}

tU32 tmctunerfi_tclMsgCurrentUserSelectedTmcStationStatus::u32GetSize(tU16 u16MajorVersion) const
{
   return 2+RDBId.u32GetSize(u16MajorVersion);
}

tBool tmctunerfi_tclMsgCurrentUserSelectedTmcStationStatus::operator==(const tmctunerfi_tclMsgCurrentUserSelectedTmcStationStatus& rfoCmp) const
{
   tBool bResult = true;
      bResult = bResult && (RDBId == rfoCmp.RDBId);
      bResult = bResult && (ProgramId == rfoCmp.ProgramId);
   return bResult;
}

fi_tclInContext& tmctunerfi_tclMsgCurrentUserSelectedTmcStationStatus::oRead(fi_tclInContext& oIn)
{
   oIn >> RDBId;
   oIn >> ProgramId;
   return oIn;
}

fi_tclOutContext& tmctunerfi_tclMsgCurrentUserSelectedTmcStationStatus::oWrite(fi_tclOutContext& oOut) const
{
   oOut << RDBId;
   oOut << ProgramId;
   return oOut;
}

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
tmctunerfi_tclMsgTpegDataGet::tmctunerfi_tclMsgTpegDataGet(const tmctunerfi_tclMsgTpegDataGet& coRef):fi_tclVisitableTypeBase(coRef)
{
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
tmctunerfi_tclMsgTpegDataGet& tmctunerfi_tclMsgTpegDataGet::operator=(const tmctunerfi_tclMsgTpegDataGet& coRef)
{
   if (this == &coRef) return *this;
   return *this;
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
tU16 tmctunerfi_tclMsgTpegDataGet::u16GetServiceID() const {return TMCTUNERFI_C_U16_SERVICE_ID;}
tU16 tmctunerfi_tclMsgTpegDataGet::u16GetFunctionID() const {return TMCTUNERFI_C_U16_TPEGDATA;}
tU8 tmctunerfi_tclMsgTpegDataGet::u8GetOpCode() const {return CCA_C_U8_OPCODE_GET;}

tU32 tmctunerfi_tclMsgTpegDataGet::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 0;
}

tBool tmctunerfi_tclMsgTpegDataGet::operator==(const tmctunerfi_tclMsgTpegDataGet& /* rfoCmp */) const
{
   tBool bResult = true;
   return bResult;
}

fi_tclInContext& tmctunerfi_tclMsgTpegDataGet::oRead(fi_tclInContext& oIn)
{
   return oIn;
}

fi_tclOutContext& tmctunerfi_tclMsgTpegDataGet::oWrite(fi_tclOutContext& oOut) const
{
   return oOut;
}

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
tmctunerfi_tclMsgTpegDataUpReg::tmctunerfi_tclMsgTpegDataUpReg(const tmctunerfi_tclMsgTpegDataUpReg& coRef):fi_tclVisitableTypeBase(coRef)
{
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
tmctunerfi_tclMsgTpegDataUpReg& tmctunerfi_tclMsgTpegDataUpReg::operator=(const tmctunerfi_tclMsgTpegDataUpReg& coRef)
{
   if (this == &coRef) return *this;
   return *this;
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
tU16 tmctunerfi_tclMsgTpegDataUpReg::u16GetServiceID() const {return TMCTUNERFI_C_U16_SERVICE_ID;}
tU16 tmctunerfi_tclMsgTpegDataUpReg::u16GetFunctionID() const {return TMCTUNERFI_C_U16_TPEGDATA;}
tU8 tmctunerfi_tclMsgTpegDataUpReg::u8GetOpCode() const {return CCA_C_U8_OPCODE_UPREG;}

tU32 tmctunerfi_tclMsgTpegDataUpReg::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 0;
}

tBool tmctunerfi_tclMsgTpegDataUpReg::operator==(const tmctunerfi_tclMsgTpegDataUpReg& /* rfoCmp */) const
{
   tBool bResult = true;
   return bResult;
}

fi_tclInContext& tmctunerfi_tclMsgTpegDataUpReg::oRead(fi_tclInContext& oIn)
{
   return oIn;
}

fi_tclOutContext& tmctunerfi_tclMsgTpegDataUpReg::oWrite(fi_tclOutContext& oOut) const
{
   return oOut;
}

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
tmctunerfi_tclMsgTpegDataRelUpReg::tmctunerfi_tclMsgTpegDataRelUpReg(const tmctunerfi_tclMsgTpegDataRelUpReg& coRef):fi_tclVisitableTypeBase(coRef)
{
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
tmctunerfi_tclMsgTpegDataRelUpReg& tmctunerfi_tclMsgTpegDataRelUpReg::operator=(const tmctunerfi_tclMsgTpegDataRelUpReg& coRef)
{
   if (this == &coRef) return *this;
   return *this;
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
tU16 tmctunerfi_tclMsgTpegDataRelUpReg::u16GetServiceID() const {return TMCTUNERFI_C_U16_SERVICE_ID;}
tU16 tmctunerfi_tclMsgTpegDataRelUpReg::u16GetFunctionID() const {return TMCTUNERFI_C_U16_TPEGDATA;}
tU8 tmctunerfi_tclMsgTpegDataRelUpReg::u8GetOpCode() const {return CCA_C_U8_OPCODE_RELUPREG;}

tU32 tmctunerfi_tclMsgTpegDataRelUpReg::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 0;
}

tBool tmctunerfi_tclMsgTpegDataRelUpReg::operator==(const tmctunerfi_tclMsgTpegDataRelUpReg& /* rfoCmp */) const
{
   tBool bResult = true;
   return bResult;
}

fi_tclInContext& tmctunerfi_tclMsgTpegDataRelUpReg::oRead(fi_tclInContext& oIn)
{
   return oIn;
}

fi_tclOutContext& tmctunerfi_tclMsgTpegDataRelUpReg::oWrite(fi_tclOutContext& oOut) const
{
   return oOut;
}

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
tmctunerfi_tclMsgTpegDataStatus::tmctunerfi_tclMsgTpegDataStatus(const tmctunerfi_tclMsgTpegDataStatus& coRef):fi_tclVisitableTypeBase(coRef)
{
   ListOfTpegMessages = coRef.ListOfTpegMessages;
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
tmctunerfi_tclMsgTpegDataStatus& tmctunerfi_tclMsgTpegDataStatus::operator=(const tmctunerfi_tclMsgTpegDataStatus& coRef)
{
   if (this == &coRef) return *this;
   ListOfTpegMessages = coRef.ListOfTpegMessages;
   return *this;
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
tU16 tmctunerfi_tclMsgTpegDataStatus::u16GetServiceID() const {return TMCTUNERFI_C_U16_SERVICE_ID;}
tU16 tmctunerfi_tclMsgTpegDataStatus::u16GetFunctionID() const {return TMCTUNERFI_C_U16_TPEGDATA;}
tU8 tmctunerfi_tclMsgTpegDataStatus::u8GetOpCode() const {return CCA_C_U8_OPCODE_STATUS;}

tVoid tmctunerfi_tclMsgTpegDataStatus::vDestroy()
{
   {
      for (tU32 u32Idx = 0; u32Idx < ListOfTpegMessages.size(); ++u32Idx)
         ListOfTpegMessages[u32Idx].vDestroy();
   }
   ListOfTpegMessages.clear();
}

tU32 tmctunerfi_tclMsgTpegDataStatus::u32GetSize(tU16 u16MajorVersion) const
{
   tU32 u32DynamicSize = 0;
   tU32 u32ListIdx;
   for (u32ListIdx = 0; u32ListIdx < ListOfTpegMessages.size(); ++u32ListIdx)
      u32DynamicSize += ListOfTpegMessages[u32ListIdx].u32GetSize(u16MajorVersion);
   return u32DynamicSize+4;
}

tBool tmctunerfi_tclMsgTpegDataStatus::operator==(const tmctunerfi_tclMsgTpegDataStatus& rfoCmp) const
{
   tBool bResult = true;
      bResult = bResult && (ListOfTpegMessages.size() == rfoCmp.ListOfTpegMessages.size());
      if (bResult)
      {
         for (tU32 u32Idx = 0; bResult && (u32Idx < ListOfTpegMessages.size()); ++u32Idx)
            bResult = bResult && (ListOfTpegMessages[u32Idx] == rfoCmp.ListOfTpegMessages[u32Idx]);
      }
   return bResult;
}

fi_tclInContext& tmctunerfi_tclMsgTpegDataStatus::oRead(fi_tclInContext& oIn)
{
   {
      tU32 u32Length;
      tU32 u32Idx;
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
      for (u32Idx = 0; u32Idx < ListOfTpegMessages.size(); ++u32Idx)
      {
         ListOfTpegMessages[u32Idx].vDestroy();
      }
#endif // !VARIANT_S_FTR_ENABLE_DEEP_COPY
      oIn >> u32Length;
      ListOfTpegMessages.resize(u32Length);
      for (u32Idx = 0; u32Idx < u32Length; ++u32Idx)
      {
         oIn >> ListOfTpegMessages[u32Idx];
      }
   }
   return oIn;
}

fi_tclOutContext& tmctunerfi_tclMsgTpegDataStatus::oWrite(fi_tclOutContext& oOut) const
{
   oOut << (tU32)ListOfTpegMessages.size();
   {
      for (tU32 u32Idx = 0; u32Idx < ListOfTpegMessages.size(); ++u32Idx)
         oOut << ListOfTpegMessages[u32Idx];
   }
   return oOut;
}

