#include "precompiled.hh"

tBool tmctunerfi_tclDescription::bInitMessage(tmctunerfi_tclToken::tenType enMsgToken) {
   tBool bResult = TRUE;
   switch (enMsgToken) {
   case tmctunerfi_tclToken::EN_LAST_TOKEN:
   case tmctunerfi_tclToken::EN_LIST:
   case tmctunerfi_tclToken::EN_END_OF_STRUCT:
   case tmctunerfi_tclToken::EN_UNKNOWN:
      bResult=FALSE;   
   break;
      // include the expansions for the messages
   case tmctunerfi_tclToken::EN_MSG_SWITCHONOFFMETHODSTART:
   {
      bResult &= oPath.bGoDown(tmctunerfi_tclKnot(tmctunerfi_tclToken::EN_BOOL,tmctunerfi_tclSemanticDomain::EN_MSG_TMCONOFF));
   } break;
   case tmctunerfi_tclToken::EN_MSG_SWITCHONOFFMETHODRESULT:
   {
      bResult &= oPath.bGoDown(tmctunerfi_tclKnot(tmctunerfi_tclToken::EN_BOOL,tmctunerfi_tclSemanticDomain::EN_MSG_SUCCESS));
   } break;
   case tmctunerfi_tclToken::EN_MSG_SETRDBIDWISHLISTMETHODSTART:
   {
      bResult &= oPath.bGoDown(tmctunerfi_tclKnot(tmctunerfi_tclToken::EN_TUNERRDBID,tmctunerfi_tclSemanticDomain::EN_LIST_ELEMENT,0));
      bResult &= oPath.bGoDown(tmctunerfi_tclKnot(tmctunerfi_tclToken::EN_LIST,tmctunerfi_tclSemanticDomain::EN_MSG_LISTOFRDBIDS));
   } break;
   case tmctunerfi_tclToken::EN_MSG_SETRDBIDWISHLISTMETHODRESULT:
   {
      if (poOutContext->u16GetMajorVersion() <= 3)
      {
         bResult &= oPath.bGoDown(tmctunerfi_tclKnot(tmctunerfi_tclToken::EN_TUNERRDBID,tmctunerfi_tclSemanticDomain::EN_LIST_ELEMENT,0));
         bResult &= oPath.bGoDown(tmctunerfi_tclKnot(tmctunerfi_tclToken::EN_LIST,tmctunerfi_tclSemanticDomain::EN_MSG_LISTOFRDBIDS));
      }
   } break;
   case tmctunerfi_tclToken::EN_MSG_EXCHANGETMCCAPABILITIESMETHODSTART:
   {
      bResult &= oPath.bGoDown(tmctunerfi_tclKnot(tmctunerfi_tclToken::EN_TMCCAPABILITY,tmctunerfi_tclSemanticDomain::EN_LIST_ELEMENT,0));
      bResult &= oPath.bGoDown(tmctunerfi_tclKnot(tmctunerfi_tclToken::EN_LIST,tmctunerfi_tclSemanticDomain::EN_MSG_LISTOFTMCCAPABILITIES));
   } break;
   case tmctunerfi_tclToken::EN_MSG_EXCHANGETMCCAPABILITIESMETHODRESULT:
   {
      bResult &= oPath.bGoDown(tmctunerfi_tclKnot(tmctunerfi_tclToken::EN_TMCCAPABILITY,tmctunerfi_tclSemanticDomain::EN_LIST_ELEMENT,0));
      bResult &= oPath.bGoDown(tmctunerfi_tclKnot(tmctunerfi_tclToken::EN_LIST,tmctunerfi_tclSemanticDomain::EN_MSG_LISTOFTMCCAPABILITIES));
   } break;
   case tmctunerfi_tclToken::EN_MSG_EXCHANGECAPABILITIESMETHODSTART:
   {
      bResult &= oPath.bGoDown(tmctunerfi_tclKnot(tmctunerfi_tclToken::EN_E8_TPEGTFPMETHOD,tmctunerfi_tclSemanticDomain::EN_LIST_ELEMENT,0));
      bResult &= oPath.bGoDown(tmctunerfi_tclKnot(tmctunerfi_tclToken::EN_LIST,tmctunerfi_tclSemanticDomain::EN_MSG_SUPPORTEDTPEGTFPMETHODS));
      bResult &= oPath.bGoDown(tmctunerfi_tclKnot(tmctunerfi_tclToken::EN_E8_TPEGLOCREFERENCING,tmctunerfi_tclSemanticDomain::EN_LIST_ELEMENT,0));
      bResult &= oPath.bGoDown(tmctunerfi_tclKnot(tmctunerfi_tclToken::EN_LIST,tmctunerfi_tclSemanticDomain::EN_MSG_SUPPORTEDTPEGLOCREFERENCING));
      bResult &= oPath.bGoDown(tmctunerfi_tclKnot(tmctunerfi_tclToken::EN_VERSIONEDTPEGAPPLICATION,tmctunerfi_tclSemanticDomain::EN_LIST_ELEMENT,0));
      bResult &= oPath.bGoDown(tmctunerfi_tclKnot(tmctunerfi_tclToken::EN_LIST,tmctunerfi_tclSemanticDomain::EN_MSG_SUPPORTEDTPEGAPPLICATIONS));
      bResult &= oPath.bGoDown(tmctunerfi_tclKnot(tmctunerfi_tclToken::EN_TPEGCAPABILITY,tmctunerfi_tclSemanticDomain::EN_LIST_ELEMENT,0));
      bResult &= oPath.bGoDown(tmctunerfi_tclKnot(tmctunerfi_tclToken::EN_LIST,tmctunerfi_tclSemanticDomain::EN_MSG_LISTOFTPEGCAPABILITIES));
      bResult &= oPath.bGoDown(tmctunerfi_tclKnot(tmctunerfi_tclToken::EN_TMCCAPABILITY,tmctunerfi_tclSemanticDomain::EN_LIST_ELEMENT,0));
      bResult &= oPath.bGoDown(tmctunerfi_tclKnot(tmctunerfi_tclToken::EN_LIST,tmctunerfi_tclSemanticDomain::EN_MSG_LISTOFTMCCAPABILITIES));
      bResult &= oPath.bGoDown(tmctunerfi_tclKnot(tmctunerfi_tclToken::EN_COMMONCAPABILITY,tmctunerfi_tclSemanticDomain::EN_LIST_ELEMENT,0));
      bResult &= oPath.bGoDown(tmctunerfi_tclKnot(tmctunerfi_tclToken::EN_LIST,tmctunerfi_tclSemanticDomain::EN_MSG_LISTOFCOMMONCAPABILITIES));
   } break;
   case tmctunerfi_tclToken::EN_MSG_EXCHANGECAPABILITIESMETHODRESULT:
   {
      bResult &= oPath.bGoDown(tmctunerfi_tclKnot(tmctunerfi_tclToken::EN_E8_TPEGTFPMETHOD,tmctunerfi_tclSemanticDomain::EN_LIST_ELEMENT,0));
      bResult &= oPath.bGoDown(tmctunerfi_tclKnot(tmctunerfi_tclToken::EN_LIST,tmctunerfi_tclSemanticDomain::EN_MSG_SUPPORTEDTPEGTFPMETHODS));
      bResult &= oPath.bGoDown(tmctunerfi_tclKnot(tmctunerfi_tclToken::EN_E8_TPEGLOCREFERENCING,tmctunerfi_tclSemanticDomain::EN_LIST_ELEMENT,0));
      bResult &= oPath.bGoDown(tmctunerfi_tclKnot(tmctunerfi_tclToken::EN_LIST,tmctunerfi_tclSemanticDomain::EN_MSG_SUPPORTEDTPEGLOCREFERENCING));
      bResult &= oPath.bGoDown(tmctunerfi_tclKnot(tmctunerfi_tclToken::EN_VERSIONEDTPEGAPPLICATION,tmctunerfi_tclSemanticDomain::EN_LIST_ELEMENT,0));
      bResult &= oPath.bGoDown(tmctunerfi_tclKnot(tmctunerfi_tclToken::EN_LIST,tmctunerfi_tclSemanticDomain::EN_MSG_SUPPORTEDTPEGAPPLICATIONS));
      bResult &= oPath.bGoDown(tmctunerfi_tclKnot(tmctunerfi_tclToken::EN_TPEGCAPABILITY,tmctunerfi_tclSemanticDomain::EN_LIST_ELEMENT,0));
      bResult &= oPath.bGoDown(tmctunerfi_tclKnot(tmctunerfi_tclToken::EN_LIST,tmctunerfi_tclSemanticDomain::EN_MSG_LISTOFTPEGCAPABILITIES));
      bResult &= oPath.bGoDown(tmctunerfi_tclKnot(tmctunerfi_tclToken::EN_TMCCAPABILITY,tmctunerfi_tclSemanticDomain::EN_LIST_ELEMENT,0));
      bResult &= oPath.bGoDown(tmctunerfi_tclKnot(tmctunerfi_tclToken::EN_LIST,tmctunerfi_tclSemanticDomain::EN_MSG_LISTOFTMCCAPABILITIES));
      bResult &= oPath.bGoDown(tmctunerfi_tclKnot(tmctunerfi_tclToken::EN_COMMONCAPABILITY,tmctunerfi_tclSemanticDomain::EN_LIST_ELEMENT,0));
      bResult &= oPath.bGoDown(tmctunerfi_tclKnot(tmctunerfi_tclToken::EN_LIST,tmctunerfi_tclSemanticDomain::EN_MSG_LISTOFCOMMONCAPABILITIES));
   } break;
   case tmctunerfi_tclToken::EN_MSG_TUNERMODESTATUS:
   {
      bResult &= oPath.bGoDown(tmctunerfi_tclKnot(tmctunerfi_tclToken::EN_E8_TMCMODE,tmctunerfi_tclSemanticDomain::EN_MSG_TMCMODE));
   } break;
   case tmctunerfi_tclToken::EN_MSG_TMCDATASTATUS:
   {
      bResult &= oPath.bGoDown(tmctunerfi_tclKnot(tmctunerfi_tclToken::EN_TRAFFICINFO,tmctunerfi_tclSemanticDomain::EN_LIST_ELEMENT,0));
      bResult &= oPath.bGoDown(tmctunerfi_tclKnot(tmctunerfi_tclToken::EN_LIST,tmctunerfi_tclSemanticDomain::EN_MSG_LISTOFTRAFFICINFO));
      if ((2 <= poOutContext->u16GetMajorVersion()) && (poOutContext->u16GetMajorVersion() <= 3))
      {
         bResult &= oPath.bGoDown(tmctunerfi_tclKnot(tmctunerfi_tclToken::EN_BOOL,tmctunerfi_tclSemanticDomain::EN_MSG_DUPLICATE));
      }
      if ((2 <= poOutContext->u16GetMajorVersion()) && (poOutContext->u16GetMajorVersion() <= 3))
      {
         bResult &= oPath.bGoDown(tmctunerfi_tclKnot(tmctunerfi_tclToken::EN_BOOL,tmctunerfi_tclSemanticDomain::EN_MSG_DATAFORRDBIDCOMPLETE));
      }
      if ((2 <= poOutContext->u16GetMajorVersion()) && (poOutContext->u16GetMajorVersion() <= 3))
      {
         bResult &= oPath.bGoDown(tmctunerfi_tclKnot(tmctunerfi_tclToken::EN_TUNERRDBID,tmctunerfi_tclSemanticDomain::EN_MSG_RDBID));
      }
      if ((2 <= poOutContext->u16GetMajorVersion()) && (poOutContext->u16GetMajorVersion() <= 3))
      {
         bResult &= oPath.bGoDown(tmctunerfi_tclKnot(tmctunerfi_tclToken::EN_BOOL,tmctunerfi_tclSemanticDomain::EN_MSG_CYCLESTART));
      }
   } break;
   case tmctunerfi_tclToken::EN_MSG_OPERATIONMODESTATUS:
   {
      bResult &= oPath.bGoDown(tmctunerfi_tclKnot(tmctunerfi_tclToken::EN_E8_TMCOPERATIONMODE,tmctunerfi_tclSemanticDomain::EN_MSG_TMCOPERATIONMODE));
   } break;
   case tmctunerfi_tclToken::EN_MSG_RDBIDACTUALLISTSTATUS:
   {
      bResult &= oPath.bGoDown(tmctunerfi_tclKnot(tmctunerfi_tclToken::EN_TUNERRDBID,tmctunerfi_tclSemanticDomain::EN_LIST_ELEMENT,0));
      bResult &= oPath.bGoDown(tmctunerfi_tclKnot(tmctunerfi_tclToken::EN_LIST,tmctunerfi_tclSemanticDomain::EN_MSG_LISTOFRDBIDS));
      if (4 <= poOutContext->u16GetMajorVersion())
      {
         bResult &= oPath.bGoDown(tmctunerfi_tclKnot(tmctunerfi_tclToken::EN_E8_TUNERRECEPTIONSTATE,tmctunerfi_tclSemanticDomain::EN_MSG_RECEPTIONSTATE));
      }
   } break;
   case tmctunerfi_tclToken::EN_MSG_TUNERSTATEANDMODESTATUS:
   {
      if (3 <= poOutContext->u16GetMajorVersion())
      {
         bResult &= oPath.bGoDown(tmctunerfi_tclKnot(tmctunerfi_tclToken::EN_STRING,tmctunerfi_tclSemanticDomain::EN_MSG_MESSAGE));
      }
      if (poOutContext->u16GetMajorVersion() <= 2)
      {
         bResult &= oPath.bGoDown(tmctunerfi_tclKnot(tmctunerfi_tclToken::EN_E8_OPERATIONMODE,tmctunerfi_tclSemanticDomain::EN_MSG_OPERATIONMODE));
      }
      if (poOutContext->u16GetMajorVersion() <= 2)
      {
         bResult &= oPath.bGoDown(tmctunerfi_tclKnot(tmctunerfi_tclToken::EN_E8_TUNERSTATE,tmctunerfi_tclSemanticDomain::EN_MSG_TUNERSTATE));
      }
   } break;
   case tmctunerfi_tclToken::EN_MSG_CURRENTUSERSELECTEDTMCSTATIONSTATUS:
   {
      bResult &= oPath.bGoDown(tmctunerfi_tclKnot(tmctunerfi_tclToken::EN_U16,tmctunerfi_tclSemanticDomain::EN_MSG_PROGRAMID));
      bResult &= oPath.bGoDown(tmctunerfi_tclKnot(tmctunerfi_tclToken::EN_TUNERRDBID,tmctunerfi_tclSemanticDomain::EN_MSG_RDBID));
   } break;
   case tmctunerfi_tclToken::EN_MSG_TPEGDATASTATUS:
   {
      bResult &= oPath.bGoDown(tmctunerfi_tclKnot(tmctunerfi_tclToken::EN_TPEGMESSAGE,tmctunerfi_tclSemanticDomain::EN_LIST_ELEMENT,0));
      bResult &= oPath.bGoDown(tmctunerfi_tclKnot(tmctunerfi_tclToken::EN_LIST,tmctunerfi_tclSemanticDomain::EN_MSG_LISTOFTPEGMESSAGES));
   } break;
   case tmctunerfi_tclToken::EN_BINCONTAINER:
   case tmctunerfi_tclToken::EN_E8_TMCMEDIUMTYPE:
   case tmctunerfi_tclToken::EN_E16_TMCAPPLICATIONID:
   case tmctunerfi_tclToken::EN_E8_TMCMODE:
   case tmctunerfi_tclToken::EN_E8_TUNERSTATE:
   case tmctunerfi_tclToken::EN_E8_TMCOPERATIONMODE:
   case tmctunerfi_tclToken::EN_E8_OPERATIONMODE:
   case tmctunerfi_tclToken::EN_E8_TMCCAPABILITY:
   case tmctunerfi_tclToken::EN_E8_TPEGCAPABILITY:
   case tmctunerfi_tclToken::EN_E8_COMMONCAPABILITY:
   case tmctunerfi_tclToken::EN_E8_TPEGAPPLICATION:
   case tmctunerfi_tclToken::EN_E8_TPEGLOCREFERENCING:
   case tmctunerfi_tclToken::EN_E8_TPEGTFPMETHOD:
   case tmctunerfi_tclToken::EN_E8_MESSAGETYPE:
   case tmctunerfi_tclToken::EN_E8_TUNERRECEPTIONSTATE:
   case tmctunerfi_tclToken::EN_VERSIONEDTPEGAPPLICATION:
   case tmctunerfi_tclToken::EN_TPEGSID:
   case tmctunerfi_tclToken::EN_TPEGACID:
   case tmctunerfi_tclToken::EN_TMCSERVICEIDENTIFICATION:
   case tmctunerfi_tclToken::EN_TUNERRDBID:
   case tmctunerfi_tclToken::EN_ENCRYPTION:
   case tmctunerfi_tclToken::EN_MSGSOURCE:
   case tmctunerfi_tclToken::EN_TRAFFICINFO:
   case tmctunerfi_tclToken::EN_TMCCAPABILITY:
   case tmctunerfi_tclToken::EN_TPEGCAPABILITY:
   case tmctunerfi_tclToken::EN_COMMONCAPABILITY:
   case tmctunerfi_tclToken::EN_TPEGAPPLICATIONVERSION:
   case tmctunerfi_tclToken::EN_TPEGMESSAGE:
   case tmctunerfi_tclToken::EN_U8:   
   case tmctunerfi_tclToken::EN_S8:   
   case tmctunerfi_tclToken::EN_U16:   
   case tmctunerfi_tclToken::EN_S16:   
   case tmctunerfi_tclToken::EN_U24:   
   case tmctunerfi_tclToken::EN_S24:   
   case tmctunerfi_tclToken::EN_U32:   
   case tmctunerfi_tclToken::EN_S32:   
   case tmctunerfi_tclToken::EN_U64:   
   case tmctunerfi_tclToken::EN_S64:   
   case tmctunerfi_tclToken::EN_F32:   
   case tmctunerfi_tclToken::EN_F64:   
   case tmctunerfi_tclToken::EN_BOOL:   
   case tmctunerfi_tclToken::EN_STRING:   
   case tmctunerfi_tclToken::EN_MULTILANGUAGESTRING:   
   default:
      oPath.bGoDown(tmctunerfi_tclKnot(enMsgToken,tmctunerfi_tclSemanticDomain::EN_UNKNOWN));
      bResult = TRUE;
   }	
   return bResult;
}

tBool tmctunerfi_tclDescription::bDoIt(fi_tclVisitableTypeBase& oTypeBase)
{
   // --read or write?
   if (enType==EN_PARSING)
   {
     // --read first, then pass visitor
     (*poInContext) >> oTypeBase;
     oTypeBase.vTakeVisitor(*poVisitor);
   }
   else
   {
     // --first pass visitor, then stream 
	 oTypeBase.vTakeVisitor(*poVisitor);
     (*poOutContext) << oTypeBase;
   }
   return poVisitor->bIsValid();
}

tBool tmctunerfi_tclDescription::bProcessMessage() {
   tBool bResult = TRUE;
   tBool bInsideBinContainerVersion = false;
   tU16 u16MajorVersion;
   if (enType == EN_GENERATING)
   {
      u16MajorVersion = poOutContext->u16GetMajorVersion();
   }
   else
   {
      u16MajorVersion = poInContext->u16GetMajorVersion();
   }
   if (u16MajorVersion > 0x8000)
   {
      return FALSE;
   }
   tU16 u16SavedMajorVersion = u16MajorVersion;
   poVisitor->vReleaseBreak();
   while ((oPath.u32Position>0) && 
      bResult &&
      !poVisitor->bBreak() )    {
      // get current context (name, type, list index of next element)
      tmctunerfi_tclKnot oKnot = oPath.oGetIterator().oKnot();
      tmctunerfi_tclSemanticDomain::tenType enSemanticDomain = oKnot.enSemanticDomain;
      tmctunerfi_tclToken::tenType enToken = oKnot.enToken;
      tU32 u32Index = oKnot.u32Index;
      
      // lists need special handling
      if (enSemanticDomain == tmctunerfi_tclSemanticDomain::EN_LIST_ELEMENT) {
         oPath.bGoUp();
         // has list remaining elements?
         if (u32Index < oPath.oGetIterator().oKnot().u32Index) {
            // create next list element
            oPath.bGoDown(tmctunerfi_tclKnot(enToken,enSemanticDomain,u32Index+1));
            oPath.bGoDown(tmctunerfi_tclKnot(enToken,enSemanticDomain,u32Index));
         } else {
            // remove list, clean up
            oPath.bGoUp();
            oCallStack.bGoUp();
            continue;	
         }
      }
      // push current context on stack for visitor
      oCallStack.bGoDown(tmctunerfi_tclKnot(enToken,enSemanticDomain,u32Index));
      poVisitor->oIterator=oCallStack.oGetIterator();
      
      // now, process element
      switch (enToken) {
      case tmctunerfi_tclToken::EN_END_OF_STRUCT: 
      {
         // clean up after structures
         if (enSemanticDomain == tmctunerfi_tclSemanticDomain::EN_BINCONTAINER)
         {
            u16MajorVersion = u16SavedMajorVersion;
            if (enType == EN_GENERATING)
            {
               poOutContext->u16SetMajorVersion(u16MajorVersion);
            }
            else
            {
               poInContext->u16SetMajorVersion(u16MajorVersion);
            }
         }
         oPath.bGoUp();
         oCallStack.bGoUp();
         oCallStack.bGoUp();
      } break;
      case tmctunerfi_tclToken::EN_LIST: 
      {
         fi_tclList oList;
         // get list size
         if (!bDoIt(oList)) {
            // rearrange LIST and LIST_ELEMENT knots
            // pop "old" LIST knot
            oPath.bGoUp();
            // pop and backup LIST_ELEMENT knot
            tmctunerfi_tclKnot saveKnot;
            oPath.bGoUp(saveKnot);
            // push LIST knot
            oPath.bGoDown(tmctunerfi_tclKnot(enToken,enSemanticDomain,oList.u32ListSize));
            // push LIST_ELEMENT knot
            oPath.bGoDown(saveKnot);
            return FALSE;
         } else {
            // rearrange LIST and LIST_ELEMENT knots
            // pop "old" LIST knot
            oPath.bGoUp();
            // pop and backup LIST_ELEMENT knot
            tmctunerfi_tclKnot saveKnot;
            oPath.bGoUp(saveKnot);
            // push LIST knot
            oPath.bGoDown(tmctunerfi_tclKnot(enToken,enSemanticDomain,oList.u32ListSize));
            // push LIST_ELEMENT knot
            oPath.bGoDown(saveKnot);
         }
      } break;
      case tmctunerfi_tclToken::EN_U8: 
      {
         fi_tclU8 oU8;
         if (!bDoIt(oU8))
            return FALSE;
         oCallStack.bGoUp();
         oPath.bGoUp();
         if (bInsideBinContainerVersion)
         {
            bInsideBinContainerVersion = false;
            u16SavedMajorVersion = u16MajorVersion;
            u16MajorVersion = oU8.u8Value;
            if (enType == EN_GENERATING)
            {
               poOutContext->u16SetMajorVersion(u16MajorVersion);
            }
            else
            {
               poInContext->u16SetMajorVersion(u16MajorVersion);
            }
         }
      } break;
      case tmctunerfi_tclToken::EN_U16: 
      {
         fi_tclU16 oU16;
         if (!bDoIt(oU16))
            return FALSE;
         oCallStack.bGoUp();
         oPath.bGoUp();
      } break;
      case tmctunerfi_tclToken::EN_U24: 
      {
         fi_tclU24 oU24;
         if (!bDoIt(oU24))
            return FALSE;
         oCallStack.bGoUp();
         oPath.bGoUp();
      } break;
      case tmctunerfi_tclToken::EN_U32: 
      {
         fi_tclU32 oU32;
         if (!bDoIt(oU32))
            return FALSE;
         oCallStack.bGoUp();
         oPath.bGoUp();
      } break;
      case tmctunerfi_tclToken::EN_U64: 
      {
         fi_tclU64 oU64;
         if (!bDoIt(oU64))
            return FALSE;
         oCallStack.bGoUp();
         oPath.bGoUp();
      } break;
      case tmctunerfi_tclToken::EN_S8: 
      {
         fi_tclS8 oS8;
         if (!bDoIt(oS8))
            return FALSE;
         oCallStack.bGoUp();
         oPath.bGoUp();
      } break;
      case tmctunerfi_tclToken::EN_S16: 
      {
         fi_tclS16 oS16;
         if (!bDoIt(oS16))
            return FALSE;
         oCallStack.bGoUp();
         oPath.bGoUp();
      } break;
      case tmctunerfi_tclToken::EN_S24: 
      {
         fi_tclS24 oS24;
         if (!bDoIt(oS24))
            return FALSE;
         oCallStack.bGoUp();
         oPath.bGoUp();
      } break;
      case tmctunerfi_tclToken::EN_S32: 
      {
         fi_tclS32 oS32;
         if (!bDoIt(oS32))
            return FALSE;
         oCallStack.bGoUp();
         oPath.bGoUp();
      } break;
      case tmctunerfi_tclToken::EN_S64: 
      {
         fi_tclS64 oS64;
         if (!bDoIt(oS64))
            return FALSE;
         oCallStack.bGoUp();
         oPath.bGoUp();
      } break;
      case tmctunerfi_tclToken::EN_F32: 
      {
         fi_tclF32 oF32;
         if (!bDoIt(oF32))
            return FALSE;
         oCallStack.bGoUp();
         oPath.bGoUp();
      } break;
      case tmctunerfi_tclToken::EN_F64: 
      {
         fi_tclF64 oF64;
         if (!bDoIt(oF64))
            return FALSE;
         oCallStack.bGoUp();
         oPath.bGoUp();
      } break;
      case tmctunerfi_tclToken::EN_BOOL: 
      {
         fi_tclBool oBool;
         if (!bDoIt(oBool))
            return FALSE;
         oCallStack.bGoUp();
         oPath.bGoUp();
      } break;
      case tmctunerfi_tclToken::EN_STRING: 
      {
         fi_tclString oString;
         if (!bDoIt(oString)) {
            oString.vDestroy();
            return FALSE;
         }
         oString.vDestroy();
         oCallStack.bGoUp();
         oPath.bGoUp();
      } break;
      case tmctunerfi_tclToken::EN_MULTILANGUAGESTRING: 
      {
         fi_tclMultiLanguageString oString;
         if (!bDoIt(oString)) {
            oString.vDestroy();
            return FALSE;
         }
         oString.vDestroy();
         oCallStack.bGoUp();
         oPath.bGoUp();
      } break;
      // include rest of type expansions/processing
   case tmctunerfi_tclToken::EN_MSG_SWITCHONOFFMETHODSTART:
   case tmctunerfi_tclToken::EN_MSG_SWITCHONOFFMETHODRESULT:
   case tmctunerfi_tclToken::EN_MSG_SETRDBIDWISHLISTMETHODSTART:
   case tmctunerfi_tclToken::EN_MSG_SETRDBIDWISHLISTMETHODRESULT:
   case tmctunerfi_tclToken::EN_MSG_EXCHANGETMCCAPABILITIESMETHODSTART:
   case tmctunerfi_tclToken::EN_MSG_EXCHANGETMCCAPABILITIESMETHODRESULT:
   case tmctunerfi_tclToken::EN_MSG_EXCHANGECAPABILITIESMETHODSTART:
   case tmctunerfi_tclToken::EN_MSG_EXCHANGECAPABILITIESMETHODRESULT:
   case tmctunerfi_tclToken::EN_MSG_TUNERMODEGET:
   case tmctunerfi_tclToken::EN_MSG_TUNERMODEUPREG:
   case tmctunerfi_tclToken::EN_MSG_TUNERMODERELUPREG:
   case tmctunerfi_tclToken::EN_MSG_TUNERMODESTATUS:
   case tmctunerfi_tclToken::EN_MSG_TMCDATAGET:
   case tmctunerfi_tclToken::EN_MSG_TMCDATAUPREG:
   case tmctunerfi_tclToken::EN_MSG_TMCDATARELUPREG:
   case tmctunerfi_tclToken::EN_MSG_TMCDATASTATUS:
   case tmctunerfi_tclToken::EN_MSG_OPERATIONMODEGET:
   case tmctunerfi_tclToken::EN_MSG_OPERATIONMODEUPREG:
   case tmctunerfi_tclToken::EN_MSG_OPERATIONMODERELUPREG:
   case tmctunerfi_tclToken::EN_MSG_OPERATIONMODESTATUS:
   case tmctunerfi_tclToken::EN_MSG_RDBIDACTUALLISTGET:
   case tmctunerfi_tclToken::EN_MSG_RDBIDACTUALLISTUPREG:
   case tmctunerfi_tclToken::EN_MSG_RDBIDACTUALLISTRELUPREG:
   case tmctunerfi_tclToken::EN_MSG_RDBIDACTUALLISTSTATUS:
   case tmctunerfi_tclToken::EN_MSG_TUNERSTATEANDMODEGET:
   case tmctunerfi_tclToken::EN_MSG_TUNERSTATEANDMODEUPREG:
   case tmctunerfi_tclToken::EN_MSG_TUNERSTATEANDMODERELUPREG:
   case tmctunerfi_tclToken::EN_MSG_TUNERSTATEANDMODESTATUS:
   case tmctunerfi_tclToken::EN_MSG_CURRENTUSERSELECTEDTMCSTATIONGET:
   case tmctunerfi_tclToken::EN_MSG_CURRENTUSERSELECTEDTMCSTATIONUPREG:
   case tmctunerfi_tclToken::EN_MSG_CURRENTUSERSELECTEDTMCSTATIONRELUPREG:
   case tmctunerfi_tclToken::EN_MSG_CURRENTUSERSELECTEDTMCSTATIONSTATUS:
   case tmctunerfi_tclToken::EN_MSG_TPEGDATAGET:
   case tmctunerfi_tclToken::EN_MSG_TPEGDATAUPREG:
   case tmctunerfi_tclToken::EN_MSG_TPEGDATARELUPREG:
   case tmctunerfi_tclToken::EN_MSG_TPEGDATASTATUS:
      bInitMessage(enToken);
      break;
   case tmctunerfi_tclToken::EN_BINCONTAINER:
   {
      if (poVisitor->bDoExpand_BinContainer(enSemanticDomain))
      {
         oPath.bGoUp();
         oPath.bGoDown(tmctunerfi_tclKnot(tmctunerfi_tclToken::EN_END_OF_STRUCT,tmctunerfi_tclSemanticDomain::EN_UNKNOWN));
         oPath.bGoDown(tmctunerfi_tclKnot(tmctunerfi_tclToken::EN_U8,tmctunerfi_tclSemanticDomain::EN_LIST_ELEMENT,0));
         oPath.bGoDown(tmctunerfi_tclKnot(tmctunerfi_tclToken::EN_LIST,tmctunerfi_tclSemanticDomain::EN_CONTAINERDATALIST));
      }
      else
      {
         fi_tcl_BinContainer o_BinContainer;
         if (!bDoIt(o_BinContainer))
         {
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
            o_BinContainer.vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
            return FALSE;
         }
         else
         {
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
            o_BinContainer.vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
            oCallStack.bGoUp();
            oPath.bGoUp();
         }
      }
   } break;
   case tmctunerfi_tclToken::EN_E8_TMCMEDIUMTYPE:
   {
      fi_tcl_e8_TmcMediumType o_e8_TmcMediumType;
      if (!bDoIt(o_e8_TmcMediumType))
         return FALSE;
      oCallStack.bGoUp();
      oPath.bGoUp();
   } break;
   case tmctunerfi_tclToken::EN_E16_TMCAPPLICATIONID:
   {
      fi_tcl_e16_TmcApplicationId o_e16_TmcApplicationId;
      if (!bDoIt(o_e16_TmcApplicationId))
         return FALSE;
      oCallStack.bGoUp();
      oPath.bGoUp();
   } break;
   case tmctunerfi_tclToken::EN_E8_TMCMODE:
   {
      fi_tcl_e8_TmcMode o_e8_TmcMode;
      if (!bDoIt(o_e8_TmcMode))
         return FALSE;
      oCallStack.bGoUp();
      oPath.bGoUp();
   } break;
   case tmctunerfi_tclToken::EN_E8_TUNERSTATE:
   {
      fi_tcl_e8_TunerState o_e8_TunerState;
      if (!bDoIt(o_e8_TunerState))
         return FALSE;
      oCallStack.bGoUp();
      oPath.bGoUp();
   } break;
   case tmctunerfi_tclToken::EN_E8_TMCOPERATIONMODE:
   {
      fi_tcl_e8_TmcOperationMode o_e8_TmcOperationMode;
      if (!bDoIt(o_e8_TmcOperationMode))
         return FALSE;
      oCallStack.bGoUp();
      oPath.bGoUp();
   } break;
   case tmctunerfi_tclToken::EN_E8_OPERATIONMODE:
   {
      fi_tcl_e8_OperationMode o_e8_OperationMode;
      if (!bDoIt(o_e8_OperationMode))
         return FALSE;
      oCallStack.bGoUp();
      oPath.bGoUp();
   } break;
   case tmctunerfi_tclToken::EN_E8_TMCCAPABILITY:
   {
      fi_tcl_e8_TmcCapability o_e8_TmcCapability;
      if (!bDoIt(o_e8_TmcCapability))
         return FALSE;
      oCallStack.bGoUp();
      oPath.bGoUp();
   } break;
   case tmctunerfi_tclToken::EN_E8_TPEGCAPABILITY:
   {
      fi_tcl_e8_TpegCapability o_e8_TpegCapability;
      if (!bDoIt(o_e8_TpegCapability))
         return FALSE;
      oCallStack.bGoUp();
      oPath.bGoUp();
   } break;
   case tmctunerfi_tclToken::EN_E8_COMMONCAPABILITY:
   {
      fi_tcl_e8_CommonCapability o_e8_CommonCapability;
      if (!bDoIt(o_e8_CommonCapability))
         return FALSE;
      oCallStack.bGoUp();
      oPath.bGoUp();
   } break;
   case tmctunerfi_tclToken::EN_E8_TPEGAPPLICATION:
   {
      fi_tcl_e8_TpegApplication o_e8_TpegApplication;
      if (!bDoIt(o_e8_TpegApplication))
         return FALSE;
      oCallStack.bGoUp();
      oPath.bGoUp();
   } break;
   case tmctunerfi_tclToken::EN_E8_TPEGLOCREFERENCING:
   {
      fi_tcl_e8_TpegLocReferencing o_e8_TpegLocReferencing;
      if (!bDoIt(o_e8_TpegLocReferencing))
         return FALSE;
      oCallStack.bGoUp();
      oPath.bGoUp();
   } break;
   case tmctunerfi_tclToken::EN_E8_TPEGTFPMETHOD:
   {
      fi_tcl_e8_TpegTfpMethod o_e8_TpegTfpMethod;
      if (!bDoIt(o_e8_TpegTfpMethod))
         return FALSE;
      oCallStack.bGoUp();
      oPath.bGoUp();
   } break;
   case tmctunerfi_tclToken::EN_E8_MESSAGETYPE:
   {
      fi_tcl_e8_MessageType o_e8_MessageType;
      if (!bDoIt(o_e8_MessageType))
         return FALSE;
      oCallStack.bGoUp();
      oPath.bGoUp();
   } break;
   case tmctunerfi_tclToken::EN_E8_TUNERRECEPTIONSTATE:
   {
      fi_tcl_e8_TunerReceptionState o_e8_TunerReceptionState;
      if (!bDoIt(o_e8_TunerReceptionState))
         return FALSE;
      oCallStack.bGoUp();
      oPath.bGoUp();
   } break;
   case tmctunerfi_tclToken::EN_VERSIONEDTPEGAPPLICATION:
   {
      if (poVisitor->bDoExpand_VersionedTpegApplication(enSemanticDomain))
      {
         oPath.bGoUp();
         oPath.bGoDown(tmctunerfi_tclKnot(tmctunerfi_tclToken::EN_END_OF_STRUCT,tmctunerfi_tclSemanticDomain::EN_UNKNOWN));
         oPath.bGoDown(tmctunerfi_tclKnot(tmctunerfi_tclToken::EN_U8,tmctunerfi_tclSemanticDomain::EN_LIST_ELEMENT,0));
         oPath.bGoDown(tmctunerfi_tclKnot(tmctunerfi_tclToken::EN_LIST,tmctunerfi_tclSemanticDomain::EN_SUPPORTEDMAJORVERSIONS));
         oPath.bGoDown(tmctunerfi_tclKnot(tmctunerfi_tclToken::EN_E8_TPEGAPPLICATION,tmctunerfi_tclSemanticDomain::EN_APPLICATIONID));
      }
      else
      {
         fi_tcl_VersionedTpegApplication o_VersionedTpegApplication;
         if (!bDoIt(o_VersionedTpegApplication))
         {
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
            o_VersionedTpegApplication.vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
            return FALSE;
         }
         else
         {
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
            o_VersionedTpegApplication.vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
            oCallStack.bGoUp();
            oPath.bGoUp();
         }
      }
   } break;
   case tmctunerfi_tclToken::EN_TPEGSID:
   {
      if (poVisitor->bDoExpand_TpegSid(enSemanticDomain))
      {
         oPath.bGoUp();
         oPath.bGoDown(tmctunerfi_tclKnot(tmctunerfi_tclToken::EN_END_OF_STRUCT,tmctunerfi_tclSemanticDomain::EN_UNKNOWN));
         oPath.bGoDown(tmctunerfi_tclKnot(tmctunerfi_tclToken::EN_U8,tmctunerfi_tclSemanticDomain::EN_SIDC));
         oPath.bGoDown(tmctunerfi_tclKnot(tmctunerfi_tclToken::EN_U8,tmctunerfi_tclSemanticDomain::EN_SIDB));
         oPath.bGoDown(tmctunerfi_tclKnot(tmctunerfi_tclToken::EN_U8,tmctunerfi_tclSemanticDomain::EN_SIDA));
      }
      else
      {
         fi_tcl_TpegSid o_TpegSid;
         if (!bDoIt(o_TpegSid))
         {
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
            o_TpegSid.vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
            return FALSE;
         }
         else
         {
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
            o_TpegSid.vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
            oCallStack.bGoUp();
            oPath.bGoUp();
         }
      }
   } break;
   case tmctunerfi_tclToken::EN_TPEGACID:
   {
      if (poVisitor->bDoExpand_TpegAcid(enSemanticDomain))
      {
         oPath.bGoUp();
         oPath.bGoDown(tmctunerfi_tclKnot(tmctunerfi_tclToken::EN_END_OF_STRUCT,tmctunerfi_tclSemanticDomain::EN_UNKNOWN));
         oPath.bGoDown(tmctunerfi_tclKnot(tmctunerfi_tclToken::EN_U8,tmctunerfi_tclSemanticDomain::EN_CONTENTID));
         oPath.bGoDown(tmctunerfi_tclKnot(tmctunerfi_tclToken::EN_E8_TPEGAPPLICATION,tmctunerfi_tclSemanticDomain::EN_APPLICATIONID));
         oPath.bGoDown(tmctunerfi_tclKnot(tmctunerfi_tclToken::EN_TPEGSID,tmctunerfi_tclSemanticDomain::EN_ORIGINATORSID));
      }
      else
      {
         fi_tcl_TpegAcid o_TpegAcid;
         if (!bDoIt(o_TpegAcid))
         {
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
            o_TpegAcid.vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
            return FALSE;
         }
         else
         {
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
            o_TpegAcid.vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
            oCallStack.bGoUp();
            oPath.bGoUp();
         }
      }
   } break;
   case tmctunerfi_tclToken::EN_TMCSERVICEIDENTIFICATION:
   {
      if (poVisitor->bDoExpand_TmcServiceIdentification(enSemanticDomain))
      {
         oPath.bGoUp();
         oPath.bGoDown(tmctunerfi_tclKnot(tmctunerfi_tclToken::EN_END_OF_STRUCT,tmctunerfi_tclSemanticDomain::EN_UNKNOWN));
         oPath.bGoDown(tmctunerfi_tclKnot(tmctunerfi_tclToken::EN_BOOL,tmctunerfi_tclSemanticDomain::EN_ENCRYPTED));
         oPath.bGoDown(tmctunerfi_tclKnot(tmctunerfi_tclToken::EN_U8,tmctunerfi_tclSemanticDomain::EN_SERVICEID));
      }
      else
      {
         fi_tcl_TmcServiceIdentification o_TmcServiceIdentification;
         if (!bDoIt(o_TmcServiceIdentification))
         {
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
            o_TmcServiceIdentification.vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
            return FALSE;
         }
         else
         {
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
            o_TmcServiceIdentification.vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
            oCallStack.bGoUp();
            oPath.bGoUp();
         }
      }
   } break;
   case tmctunerfi_tclToken::EN_TUNERRDBID:
   {
      if (poVisitor->bDoExpand_TunerRdbId(enSemanticDomain))
      {
         oPath.bGoUp();
         oPath.bGoDown(tmctunerfi_tclKnot(tmctunerfi_tclToken::EN_END_OF_STRUCT,tmctunerfi_tclSemanticDomain::EN_UNKNOWN));
         if (3 <= u16MajorVersion)
         {
            oPath.bGoDown(tmctunerfi_tclKnot(tmctunerfi_tclToken::EN_TPEGACID,tmctunerfi_tclSemanticDomain::EN_ACID));
         }
         if (3 <= u16MajorVersion)
         {
            oPath.bGoDown(tmctunerfi_tclKnot(tmctunerfi_tclToken::EN_TMCSERVICEIDENTIFICATION,tmctunerfi_tclSemanticDomain::EN_TMCSERVICE));
         }
         if (u16MajorVersion <= 2)
         {
            oPath.bGoDown(tmctunerfi_tclKnot(tmctunerfi_tclToken::EN_BOOL,tmctunerfi_tclSemanticDomain::EN_ENCRYPTED));
         }
         if (u16MajorVersion <= 2)
         {
            oPath.bGoDown(tmctunerfi_tclKnot(tmctunerfi_tclToken::EN_U8,tmctunerfi_tclSemanticDomain::EN_SERVICEID));
         }
         if (2 <= u16MajorVersion)
         {
            oPath.bGoDown(tmctunerfi_tclKnot(tmctunerfi_tclToken::EN_U16,tmctunerfi_tclSemanticDomain::EN_BSA));
         }
         oPath.bGoDown(tmctunerfi_tclKnot(tmctunerfi_tclToken::EN_U8,tmctunerfi_tclSemanticDomain::EN_TABLENO));
         oPath.bGoDown(tmctunerfi_tclKnot(tmctunerfi_tclToken::EN_U8,tmctunerfi_tclSemanticDomain::EN_TMCCOUNTRYCODE));
         if (3 <= u16MajorVersion)
         {
            oPath.bGoDown(tmctunerfi_tclKnot(tmctunerfi_tclToken::EN_E8_MESSAGETYPE,tmctunerfi_tclSemanticDomain::EN_MSGTYPE));
         }
      }
      else
      {
         fi_tcl_TunerRdbId o_TunerRdbId;
         if (!bDoIt(o_TunerRdbId))
         {
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
            o_TunerRdbId.vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
            return FALSE;
         }
         else
         {
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
            o_TunerRdbId.vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
            oCallStack.bGoUp();
            oPath.bGoUp();
         }
      }
   } break;
   case tmctunerfi_tclToken::EN_ENCRYPTION:
   {
      if (poVisitor->bDoExpand_Encryption(enSemanticDomain))
      {
         oPath.bGoUp();
         oPath.bGoDown(tmctunerfi_tclKnot(tmctunerfi_tclToken::EN_END_OF_STRUCT,tmctunerfi_tclSemanticDomain::EN_UNKNOWN));
         oPath.bGoDown(tmctunerfi_tclKnot(tmctunerfi_tclToken::EN_U8,tmctunerfi_tclSemanticDomain::EN_TESTBITS));
         oPath.bGoDown(tmctunerfi_tclKnot(tmctunerfi_tclToken::EN_U8,tmctunerfi_tclSemanticDomain::EN_ENCID));
         oPath.bGoDown(tmctunerfi_tclKnot(tmctunerfi_tclToken::EN_BOOL,tmctunerfi_tclSemanticDomain::EN_ENCRYPTED));
      }
      else
      {
         fi_tcl_Encryption o_Encryption;
         if (!bDoIt(o_Encryption))
         {
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
            o_Encryption.vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
            return FALSE;
         }
         else
         {
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
            o_Encryption.vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
            oCallStack.bGoUp();
            oPath.bGoUp();
         }
      }
   } break;
   case tmctunerfi_tclToken::EN_MSGSOURCE:
   {
      if (poVisitor->bDoExpand_MsgSource(enSemanticDomain))
      {
         oPath.bGoUp();
         oPath.bGoDown(tmctunerfi_tclKnot(tmctunerfi_tclToken::EN_END_OF_STRUCT,tmctunerfi_tclSemanticDomain::EN_UNKNOWN));
         oPath.bGoDown(tmctunerfi_tclKnot(tmctunerfi_tclToken::EN_U8,tmctunerfi_tclSemanticDomain::EN_NUMBER));
         oPath.bGoDown(tmctunerfi_tclKnot(tmctunerfi_tclToken::EN_E8_TMCMEDIUMTYPE,tmctunerfi_tclSemanticDomain::EN_MEDIUMTYPEID));
      }
      else
      {
         fi_tcl_MsgSource o_MsgSource;
         if (!bDoIt(o_MsgSource))
         {
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
            o_MsgSource.vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
            return FALSE;
         }
         else
         {
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
            o_MsgSource.vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
            oCallStack.bGoUp();
            oPath.bGoUp();
         }
      }
   } break;
   case tmctunerfi_tclToken::EN_TRAFFICINFO:
   {
      if (poVisitor->bDoExpand_TrafficInfo(enSemanticDomain))
      {
         oPath.bGoUp();
         oPath.bGoDown(tmctunerfi_tclKnot(tmctunerfi_tclToken::EN_END_OF_STRUCT,tmctunerfi_tclSemanticDomain::EN_UNKNOWN));
         oPath.bGoDown(tmctunerfi_tclKnot(tmctunerfi_tclToken::EN_STRING,tmctunerfi_tclSemanticDomain::EN_SERVICEPROVIDERNAME));
         oPath.bGoDown(tmctunerfi_tclKnot(tmctunerfi_tclToken::EN_STRING,tmctunerfi_tclSemanticDomain::EN_PROGRAMSERVICENAME));
         oPath.bGoDown(tmctunerfi_tclKnot(tmctunerfi_tclToken::EN_MSGSOURCE,tmctunerfi_tclSemanticDomain::EN_MSGSOURCE));
         oPath.bGoDown(tmctunerfi_tclKnot(tmctunerfi_tclToken::EN_ENCRYPTION,tmctunerfi_tclSemanticDomain::EN_ENCRYPTION));
         oPath.bGoDown(tmctunerfi_tclKnot(tmctunerfi_tclToken::EN_U16,tmctunerfi_tclSemanticDomain::EN_PROGRAMID));
         oPath.bGoDown(tmctunerfi_tclKnot(tmctunerfi_tclToken::EN_U8,tmctunerfi_tclSemanticDomain::EN_LIST_ELEMENT,0));
         oPath.bGoDown(tmctunerfi_tclKnot(tmctunerfi_tclToken::EN_LIST,tmctunerfi_tclSemanticDomain::EN_LISTOF8ADATA));
         oPath.bGoDown(tmctunerfi_tclKnot(tmctunerfi_tclToken::EN_E16_TMCAPPLICATIONID,tmctunerfi_tclSemanticDomain::EN_APPLICATIONID));
         oPath.bGoDown(tmctunerfi_tclKnot(tmctunerfi_tclToken::EN_S16,tmctunerfi_tclSemanticDomain::EN_ECC));
         oPath.bGoDown(tmctunerfi_tclKnot(tmctunerfi_tclToken::EN_TUNERRDBID,tmctunerfi_tclSemanticDomain::EN_RDBID));
      }
      else
      {
         fi_tcl_TrafficInfo o_TrafficInfo;
         if (!bDoIt(o_TrafficInfo))
         {
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
            o_TrafficInfo.vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
            return FALSE;
         }
         else
         {
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
            o_TrafficInfo.vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
            oCallStack.bGoUp();
            oPath.bGoUp();
         }
      }
   } break;
   case tmctunerfi_tclToken::EN_TMCCAPABILITY:
   {
      if (poVisitor->bDoExpand_TmcCapability(enSemanticDomain))
      {
         oPath.bGoUp();
         oPath.bGoDown(tmctunerfi_tclKnot(tmctunerfi_tclToken::EN_END_OF_STRUCT,tmctunerfi_tclSemanticDomain::EN_UNKNOWN));
         oPath.bGoDown(tmctunerfi_tclKnot(tmctunerfi_tclToken::EN_U8,tmctunerfi_tclSemanticDomain::EN_VALUE));
         if (3 <= u16MajorVersion)
         {
            oPath.bGoDown(tmctunerfi_tclKnot(tmctunerfi_tclToken::EN_E8_TMCCAPABILITY,tmctunerfi_tclSemanticDomain::EN_CAPABILITYID));
         }
         if (u16MajorVersion <= 2)
         {
            oPath.bGoDown(tmctunerfi_tclKnot(tmctunerfi_tclToken::EN_E8_TMCCAPABILITY,tmctunerfi_tclSemanticDomain::EN_TMCCAPABILITYID));
         }
      }
      else
      {
         fi_tcl_TmcCapability o_TmcCapability;
         if (!bDoIt(o_TmcCapability))
         {
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
            o_TmcCapability.vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
            return FALSE;
         }
         else
         {
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
            o_TmcCapability.vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
            oCallStack.bGoUp();
            oPath.bGoUp();
         }
      }
   } break;
   case tmctunerfi_tclToken::EN_TPEGCAPABILITY:
   {
      if (poVisitor->bDoExpand_TpegCapability(enSemanticDomain))
      {
         oPath.bGoUp();
         oPath.bGoDown(tmctunerfi_tclKnot(tmctunerfi_tclToken::EN_END_OF_STRUCT,tmctunerfi_tclSemanticDomain::EN_UNKNOWN));
         oPath.bGoDown(tmctunerfi_tclKnot(tmctunerfi_tclToken::EN_U8,tmctunerfi_tclSemanticDomain::EN_VALUE));
         oPath.bGoDown(tmctunerfi_tclKnot(tmctunerfi_tclToken::EN_E8_TPEGCAPABILITY,tmctunerfi_tclSemanticDomain::EN_CAPABILITYID));
      }
      else
      {
         fi_tcl_TpegCapability o_TpegCapability;
         if (!bDoIt(o_TpegCapability))
         {
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
            o_TpegCapability.vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
            return FALSE;
         }
         else
         {
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
            o_TpegCapability.vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
            oCallStack.bGoUp();
            oPath.bGoUp();
         }
      }
   } break;
   case tmctunerfi_tclToken::EN_COMMONCAPABILITY:
   {
      if (poVisitor->bDoExpand_CommonCapability(enSemanticDomain))
      {
         oPath.bGoUp();
         oPath.bGoDown(tmctunerfi_tclKnot(tmctunerfi_tclToken::EN_END_OF_STRUCT,tmctunerfi_tclSemanticDomain::EN_UNKNOWN));
         oPath.bGoDown(tmctunerfi_tclKnot(tmctunerfi_tclToken::EN_U8,tmctunerfi_tclSemanticDomain::EN_VALUE));
         oPath.bGoDown(tmctunerfi_tclKnot(tmctunerfi_tclToken::EN_E8_COMMONCAPABILITY,tmctunerfi_tclSemanticDomain::EN_CAPABILITYID));
      }
      else
      {
         fi_tcl_CommonCapability o_CommonCapability;
         if (!bDoIt(o_CommonCapability))
         {
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
            o_CommonCapability.vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
            return FALSE;
         }
         else
         {
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
            o_CommonCapability.vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
            oCallStack.bGoUp();
            oPath.bGoUp();
         }
      }
   } break;
   case tmctunerfi_tclToken::EN_TPEGAPPLICATIONVERSION:
   {
      if (poVisitor->bDoExpand_TpegApplicationVersion(enSemanticDomain))
      {
         oPath.bGoUp();
         oPath.bGoDown(tmctunerfi_tclKnot(tmctunerfi_tclToken::EN_END_OF_STRUCT,tmctunerfi_tclSemanticDomain::EN_UNKNOWN));
         oPath.bGoDown(tmctunerfi_tclKnot(tmctunerfi_tclToken::EN_U8,tmctunerfi_tclSemanticDomain::EN_MINOR));
         oPath.bGoDown(tmctunerfi_tclKnot(tmctunerfi_tclToken::EN_U8,tmctunerfi_tclSemanticDomain::EN_MAJOR));
      }
      else
      {
         fi_tcl_TpegApplicationVersion o_TpegApplicationVersion;
         if (!bDoIt(o_TpegApplicationVersion))
         {
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
            o_TpegApplicationVersion.vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
            return FALSE;
         }
         else
         {
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
            o_TpegApplicationVersion.vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
            oCallStack.bGoUp();
            oPath.bGoUp();
         }
      }
   } break;
   case tmctunerfi_tclToken::EN_TPEGMESSAGE:
   {
      if (poVisitor->bDoExpand_TpegMessage(enSemanticDomain))
      {
         oPath.bGoUp();
         oPath.bGoDown(tmctunerfi_tclKnot(tmctunerfi_tclToken::EN_END_OF_STRUCT,tmctunerfi_tclSemanticDomain::EN_UNKNOWN));
         oPath.bGoDown(tmctunerfi_tclKnot(tmctunerfi_tclToken::EN_STRING,tmctunerfi_tclSemanticDomain::EN_SERVICEPROVIDERNAME));
         oPath.bGoDown(tmctunerfi_tclKnot(tmctunerfi_tclToken::EN_STRING,tmctunerfi_tclSemanticDomain::EN_PROGRAMSERVICENAME));
         oPath.bGoDown(tmctunerfi_tclKnot(tmctunerfi_tclToken::EN_U16,tmctunerfi_tclSemanticDomain::EN_PROGRAMID));
         oPath.bGoDown(tmctunerfi_tclKnot(tmctunerfi_tclToken::EN_MSGSOURCE,tmctunerfi_tclSemanticDomain::EN_MSGSOURCE));
         oPath.bGoDown(tmctunerfi_tclKnot(tmctunerfi_tclToken::EN_U8,tmctunerfi_tclSemanticDomain::EN_LIST_ELEMENT,0));
         oPath.bGoDown(tmctunerfi_tclKnot(tmctunerfi_tclToken::EN_LIST,tmctunerfi_tclSemanticDomain::EN_TPEGMESSAGESTREAM));
         oPath.bGoDown(tmctunerfi_tclKnot(tmctunerfi_tclToken::EN_TPEGAPPLICATIONVERSION,tmctunerfi_tclSemanticDomain::EN_VERSION));
         oPath.bGoDown(tmctunerfi_tclKnot(tmctunerfi_tclToken::EN_TUNERRDBID,tmctunerfi_tclSemanticDomain::EN_RDBID));
      }
      else
      {
         fi_tcl_TpegMessage o_TpegMessage;
         if (!bDoIt(o_TpegMessage))
         {
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
            o_TpegMessage.vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
            return FALSE;
         }
         else
         {
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
            o_TpegMessage.vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
            oCallStack.bGoUp();
            oPath.bGoUp();
         }
      }
   } break;
      case tmctunerfi_tclToken::EN_UNKNOWN:
      case tmctunerfi_tclToken::EN_LAST_TOKEN:         
      default:
         return FALSE;
      }
  }
  return bResult;
}

