#ifndef __TMCTUNERFIDEBUGVISITOR_H__
#define __TMCTUNERFIDEBUGVISITOR_H__

class MY_DECL tmctunerfi_tclPrintVisitor : public tmctunerfi_tclVisitorBase {

private:
   /* default constructor */ tmctunerfi_tclPrintVisitor();  //lint !e1704   // use constructor with parameter

public:
   tmctunerfi_tclPrintVisitor(fi_tclOutput* poOut):poOutput(poOut) { line[0] = '\0'; }

   // --Besuche allgemeine Objekte	
   virtual tVoid vVisitU8(fi_tclU8& oU8);
   virtual tVoid vVisitS8(fi_tclS8& oS8);
   virtual tVoid vVisitU16(fi_tclU16& oU16);
   virtual tVoid vVisitS16(fi_tclS16& oS16);
   virtual tVoid vVisitU24(fi_tclU24& oU24);
   virtual tVoid vVisitS24(fi_tclS24& oS24);
   virtual tVoid vVisitU32(fi_tclU32& oU32);
   virtual tVoid vVisitS32(fi_tclS32& oS32);
   virtual tVoid vVisitU64(fi_tclU64& oU64);
   virtual tVoid vVisitS64(fi_tclS64& oS64);
   virtual tVoid vVisitBool(fi_tclBool& oBool);
   virtual tVoid vVisitString(fi_tclString& oString);
   virtual tVoid vVisitMultiLanguageString(fi_tclMultiLanguageString& oString);
   virtual tVoid vVisitList(fi_tclList& oList);

   // Besuche die generierten Typen
   virtual tBool bDoExpand_BinContainer(tmctunerfi_tclSemanticDomain::tenType enSemantic);
   virtual tVoid vVisit_e8_TmcMediumType(fi_tcl_e8_TmcMediumType& o_e8_TmcMediumType);
   virtual tVoid vVisit_e16_TmcApplicationId(fi_tcl_e16_TmcApplicationId& o_e16_TmcApplicationId);
   virtual tVoid vVisit_e8_TmcMode(fi_tcl_e8_TmcMode& o_e8_TmcMode);
   virtual tVoid vVisit_e8_TunerState(fi_tcl_e8_TunerState& o_e8_TunerState);
   virtual tVoid vVisit_e8_TmcOperationMode(fi_tcl_e8_TmcOperationMode& o_e8_TmcOperationMode);
   virtual tVoid vVisit_e8_OperationMode(fi_tcl_e8_OperationMode& o_e8_OperationMode);
   virtual tVoid vVisit_e8_TmcCapability(fi_tcl_e8_TmcCapability& o_e8_TmcCapability);
   virtual tVoid vVisit_e8_TpegCapability(fi_tcl_e8_TpegCapability& o_e8_TpegCapability);
   virtual tVoid vVisit_e8_CommonCapability(fi_tcl_e8_CommonCapability& o_e8_CommonCapability);
   virtual tVoid vVisit_e8_TpegApplication(fi_tcl_e8_TpegApplication& o_e8_TpegApplication);
   virtual tVoid vVisit_e8_TpegLocReferencing(fi_tcl_e8_TpegLocReferencing& o_e8_TpegLocReferencing);
   virtual tVoid vVisit_e8_TpegTfpMethod(fi_tcl_e8_TpegTfpMethod& o_e8_TpegTfpMethod);
   virtual tVoid vVisit_e8_MessageType(fi_tcl_e8_MessageType& o_e8_MessageType);
   virtual tVoid vVisit_e8_TunerReceptionState(fi_tcl_e8_TunerReceptionState& o_e8_TunerReceptionState);
   virtual tBool bDoExpand_VersionedTpegApplication(tmctunerfi_tclSemanticDomain::tenType enSemantic);
   virtual tBool bDoExpand_TpegSid(tmctunerfi_tclSemanticDomain::tenType enSemantic);
   virtual tBool bDoExpand_TpegAcid(tmctunerfi_tclSemanticDomain::tenType enSemantic);
   virtual tBool bDoExpand_TmcServiceIdentification(tmctunerfi_tclSemanticDomain::tenType enSemantic);
   virtual tBool bDoExpand_TunerRdbId(tmctunerfi_tclSemanticDomain::tenType enSemantic);
   virtual tBool bDoExpand_Encryption(tmctunerfi_tclSemanticDomain::tenType enSemantic);
   virtual tBool bDoExpand_MsgSource(tmctunerfi_tclSemanticDomain::tenType enSemantic);
   virtual tBool bDoExpand_TrafficInfo(tmctunerfi_tclSemanticDomain::tenType enSemantic);
   virtual tBool bDoExpand_TmcCapability(tmctunerfi_tclSemanticDomain::tenType enSemantic);
   virtual tBool bDoExpand_TpegCapability(tmctunerfi_tclSemanticDomain::tenType enSemantic);
   virtual tBool bDoExpand_CommonCapability(tmctunerfi_tclSemanticDomain::tenType enSemantic);
   virtual tBool bDoExpand_TpegApplicationVersion(tmctunerfi_tclSemanticDomain::tenType enSemantic);
   virtual tBool bDoExpand_TpegMessage(tmctunerfi_tclSemanticDomain::tenType enSemantic);
private:
	// ostream& oOut;
   tChar line[256];
   /*
	OSAL_tIODescriptor fd;
   char *ps8PrintBuf;
   tU32 u32BufSize;
   static const tU32 C_U32_MAXLINELENGTH;
   */
   fi_tclOutput* poOutput;
};


class MY_DECL tmctunerfi_tclRandomInitVisitor : public tmctunerfi_tclVisitorBase {
public:

   tmctunerfi_tclRandomInitVisitor(tU32 u32Seed=1):u32ListSize(3) { srand(u32Seed); }
   tVoid vSetSeed(tU32 u32Seed) const { srand(u32Seed); }
   // --Besuche allgemeine Objekte	
   virtual tVoid vVisitU8(fi_tclU8& oU8);
   virtual tVoid vVisitS8(fi_tclS8& oS8);
   virtual tVoid vVisitU16(fi_tclU16& oU16);
   virtual tVoid vVisitS16(fi_tclS16& oS16);
   virtual tVoid vVisitU24(fi_tclU24& oU24);
   virtual tVoid vVisitS24(fi_tclS24& oS24);
   virtual tVoid vVisitU32(fi_tclU32& oU32);
   virtual tVoid vVisitS32(fi_tclS32& oS32);
   virtual tVoid vVisitU64(fi_tclU64& oU64);
   virtual tVoid vVisitS64(fi_tclS64& oS64);
   virtual tVoid vVisitBool(fi_tclBool& oBool);
   virtual tVoid vVisitString(fi_tclString& oString);
   virtual tVoid vVisitMultiLanguageString(fi_tclMultiLanguageString& oString);
   virtual tVoid vVisitList(fi_tclList& oList);

	// Besuche die generierten Typen
   virtual tVoid vVisit_e8_TmcMediumType(fi_tcl_e8_TmcMediumType& o_e8_TmcMediumType);
   virtual tVoid vVisit_e16_TmcApplicationId(fi_tcl_e16_TmcApplicationId& o_e16_TmcApplicationId);
   virtual tVoid vVisit_e8_TmcMode(fi_tcl_e8_TmcMode& o_e8_TmcMode);
   virtual tVoid vVisit_e8_TunerState(fi_tcl_e8_TunerState& o_e8_TunerState);
   virtual tVoid vVisit_e8_TmcOperationMode(fi_tcl_e8_TmcOperationMode& o_e8_TmcOperationMode);
   virtual tVoid vVisit_e8_OperationMode(fi_tcl_e8_OperationMode& o_e8_OperationMode);
   virtual tVoid vVisit_e8_TmcCapability(fi_tcl_e8_TmcCapability& o_e8_TmcCapability);
   virtual tVoid vVisit_e8_TpegCapability(fi_tcl_e8_TpegCapability& o_e8_TpegCapability);
   virtual tVoid vVisit_e8_CommonCapability(fi_tcl_e8_CommonCapability& o_e8_CommonCapability);
   virtual tVoid vVisit_e8_TpegApplication(fi_tcl_e8_TpegApplication& o_e8_TpegApplication);
   virtual tVoid vVisit_e8_TpegLocReferencing(fi_tcl_e8_TpegLocReferencing& o_e8_TpegLocReferencing);
   virtual tVoid vVisit_e8_TpegTfpMethod(fi_tcl_e8_TpegTfpMethod& o_e8_TpegTfpMethod);
   virtual tVoid vVisit_e8_MessageType(fi_tcl_e8_MessageType& o_e8_MessageType);
   virtual tVoid vVisit_e8_TunerReceptionState(fi_tcl_e8_TunerReceptionState& o_e8_TunerReceptionState);
	tU32 u32ListSize;
};

#endif
