#include "precompiled.hh"

tBool teafi_tclDescription::bInitMessage(teafi_tclToken::tenType enMsgToken) {
   tBool bResult = TRUE;
   switch (enMsgToken) {
   case teafi_tclToken::EN_LAST_TOKEN:
   case teafi_tclToken::EN_LIST:
   case teafi_tclToken::EN_END_OF_STRUCT:
   case teafi_tclToken::EN_UNKNOWN:
      bResult=FALSE;   
   break;
      // include the expansions for the messages
   case teafi_tclToken::EN_MSG_GETTEAHORIZONMETHODSTART:
   {
      bResult &= oPath.bGoDown(teafi_tclKnot(teafi_tclToken::EN_B32_ROADINFOCATEGORYINDICATOR,teafi_tclSemanticDomain::EN_MSG_REQUESTEDMDBDATA));
   } break;
   case teafi_tclToken::EN_MSG_GETTEAHORIZONMETHODRESULT:
   {
      bResult &= oPath.bGoDown(teafi_tclKnot(teafi_tclToken::EN_HORIZONROADINFOUNION,teafi_tclSemanticDomain::EN_LIST_ELEMENT,0));
      bResult &= oPath.bGoDown(teafi_tclKnot(teafi_tclToken::EN_LIST,teafi_tclSemanticDomain::EN_MSG_ROADINFO));
      if (11 <= poOutContext->u16GetMajorVersion())
      {
         bResult &= oPath.bGoDown(teafi_tclKnot(teafi_tclToken::EN_HORIZONMOSTPROBABLEPATH,teafi_tclSemanticDomain::EN_LIST_ELEMENT,0));
         bResult &= oPath.bGoDown(teafi_tclKnot(teafi_tclToken::EN_LIST,teafi_tclSemanticDomain::EN_MSG_MOSTPROBABLEPATHESLIST));
      }
      bResult &= oPath.bGoDown(teafi_tclKnot(teafi_tclToken::EN_ALTERNATIVTEAEVENTIDLIST,teafi_tclSemanticDomain::EN_LIST_ELEMENT,0));
      bResult &= oPath.bGoDown(teafi_tclKnot(teafi_tclToken::EN_LIST,teafi_tclSemanticDomain::EN_MSG_ALTERNATIVTEAEVENTLIST));
      bResult &= oPath.bGoDown(teafi_tclKnot(teafi_tclToken::EN_TEAEVENTID,teafi_tclSemanticDomain::EN_LIST_ELEMENT,0));
      bResult &= oPath.bGoDown(teafi_tclKnot(teafi_tclToken::EN_LIST,teafi_tclSemanticDomain::EN_MSG_TEAEVENTIDLIST));
      bResult &= oPath.bGoDown(teafi_tclKnot(teafi_tclToken::EN_NAVCLUSTERDESC,teafi_tclSemanticDomain::EN_LIST_ELEMENT,0));
      bResult &= oPath.bGoDown(teafi_tclKnot(teafi_tclToken::EN_LIST,teafi_tclSemanticDomain::EN_MSG_CLUSTERREFLIST));
      bResult &= oPath.bGoDown(teafi_tclKnot(teafi_tclToken::EN_POSHORIZONONECELLSECTION,teafi_tclSemanticDomain::EN_LIST_ELEMENT,0));
      bResult &= oPath.bGoDown(teafi_tclKnot(teafi_tclToken::EN_LIST,teafi_tclSemanticDomain::EN_MSG_ONECELLREFLIST));
      bResult &= oPath.bGoDown(teafi_tclKnot(teafi_tclToken::EN_POSHORIZONPATHSECTION,teafi_tclSemanticDomain::EN_LIST_ELEMENT,0));
      bResult &= oPath.bGoDown(teafi_tclKnot(teafi_tclToken::EN_LIST,teafi_tclSemanticDomain::EN_MSG_PATHSECTIONLIST));
      if (9 <= poOutContext->u16GetMajorVersion())
      {
         bResult &= oPath.bGoDown(teafi_tclKnot(teafi_tclToken::EN_U32,teafi_tclSemanticDomain::EN_MSG_ROUTEINFOID));
      }
      if (9 <= poOutContext->u16GetMajorVersion())
      {
         bResult &= oPath.bGoDown(teafi_tclKnot(teafi_tclToken::EN_U16_TRIPSEGMENTNUMBER,teafi_tclSemanticDomain::EN_MSG_TRIPSEGMENTNUMBER));
      }
      if (9 <= poOutContext->u16GetMajorVersion())
      {
         bResult &= oPath.bGoDown(teafi_tclKnot(teafi_tclToken::EN_U16_ROUTEHANDLE,teafi_tclSemanticDomain::EN_MSG_ROUTEHANDLE));
      }
      if (9 <= poOutContext->u16GetMajorVersion())
      {
         bResult &= oPath.bGoDown(teafi_tclKnot(teafi_tclToken::EN_U16_TRIPHANDLE,teafi_tclSemanticDomain::EN_MSG_TRIPHANDLE));
      }
      if (19 <= poOutContext->u16GetMajorVersion())
      {
         bResult &= oPath.bGoDown(teafi_tclKnot(teafi_tclToken::EN_U16_INDEXINREFERENCELIST,teafi_tclSemanticDomain::EN_LIST_ELEMENT,0));
         bResult &= oPath.bGoDown(teafi_tclKnot(teafi_tclToken::EN_LIST,teafi_tclSemanticDomain::EN_MSG_INDICESOFLASTROOTSINCURRENTHORIZON));
      }
      if ((11 <= poOutContext->u16GetMajorVersion()) && (poOutContext->u16GetMajorVersion() <= 18))
      {
         bResult &= oPath.bGoDown(teafi_tclKnot(teafi_tclToken::EN_U16_INDEXINREFERENCELIST,teafi_tclSemanticDomain::EN_MSG_INDEXOFLASTROOTINCURRENTHORIZON));
      }
      if (19 <= poOutContext->u16GetMajorVersion())
      {
         bResult &= oPath.bGoDown(teafi_tclKnot(teafi_tclToken::EN_POSHORIZONROOTELEMENT,teafi_tclSemanticDomain::EN_LIST_ELEMENT,0));
         bResult &= oPath.bGoDown(teafi_tclKnot(teafi_tclToken::EN_LIST,teafi_tclSemanticDomain::EN_MSG_ROOTLIST));
      }
      if (poOutContext->u16GetMajorVersion() <= 18)
      {
         bResult &= oPath.bGoDown(teafi_tclKnot(teafi_tclToken::EN_U16_INDEXINREFERENCELIST,teafi_tclSemanticDomain::EN_MSG_INDEXOFROOTINLASTHORIZON));
      }
      bResult &= oPath.bGoDown(teafi_tclKnot(teafi_tclToken::EN_U32,teafi_tclSemanticDomain::EN_MSG_DATABASEID));
      bResult &= oPath.bGoDown(teafi_tclKnot(teafi_tclToken::EN_B8_TEAPRESENCEINDICATOR,teafi_tclSemanticDomain::EN_LIST_ELEMENT,0));
      bResult &= oPath.bGoDown(teafi_tclKnot(teafi_tclToken::EN_LIST,teafi_tclSemanticDomain::EN_MSG_PATHSECTIONSTATELIST));
      bResult &= oPath.bGoDown(teafi_tclKnot(teafi_tclToken::EN_B32_ROADINFOCATEGORYINDICATOR,teafi_tclSemanticDomain::EN_MSG_REQUESTEDMDBDATA));
      bResult &= oPath.bGoDown(teafi_tclKnot(teafi_tclToken::EN_E8_POSHORIZONSTATE,teafi_tclSemanticDomain::EN_MSG_POSITIONHORIZONSTATE));
      bResult &= oPath.bGoDown(teafi_tclKnot(teafi_tclToken::EN_U32,teafi_tclSemanticDomain::EN_MSG_RELEASEID));
   } break;
   case teafi_tclToken::EN_MSG_GETUPOISMETHODSTART:
   {
      bResult &= oPath.bGoDown(teafi_tclKnot(teafi_tclToken::EN_UPOI_FILTERLIST,teafi_tclSemanticDomain::EN_MSG_FILTERLIST));
   } break;
   case teafi_tclToken::EN_MSG_GETUPOISMETHODRESULT:
   {
      bResult &= oPath.bGoDown(teafi_tclKnot(teafi_tclToken::EN_UPOI_LISTSET,teafi_tclSemanticDomain::EN_MSG_UPOILISTSET));
      if (15 <= poOutContext->u16GetMajorVersion())
      {
         bResult &= oPath.bGoDown(teafi_tclKnot(teafi_tclToken::EN_U8_PERCENT,teafi_tclSemanticDomain::EN_MSG_LISTSETINFOPERCENTAGEUPOI));
      }
      bResult &= oPath.bGoDown(teafi_tclKnot(teafi_tclToken::EN_U32,teafi_tclSemanticDomain::EN_MSG_RELEASEID));
   } break;
   case teafi_tclToken::EN_MSG_TEAHORIZONSTATUS:
   {
      bResult &= oPath.bGoDown(teafi_tclKnot(teafi_tclToken::EN_HORIZONROADINFOUNION,teafi_tclSemanticDomain::EN_LIST_ELEMENT,0));
      bResult &= oPath.bGoDown(teafi_tclKnot(teafi_tclToken::EN_LIST,teafi_tclSemanticDomain::EN_MSG_ROADINFO));
      bResult &= oPath.bGoDown(teafi_tclKnot(teafi_tclToken::EN_NAVCLUSTERDESC,teafi_tclSemanticDomain::EN_LIST_ELEMENT,0));
      bResult &= oPath.bGoDown(teafi_tclKnot(teafi_tclToken::EN_LIST,teafi_tclSemanticDomain::EN_MSG_CLUSTERREFLIST));
      bResult &= oPath.bGoDown(teafi_tclKnot(teafi_tclToken::EN_POSHORIZONONECELLSECTION,teafi_tclSemanticDomain::EN_LIST_ELEMENT,0));
      bResult &= oPath.bGoDown(teafi_tclKnot(teafi_tclToken::EN_LIST,teafi_tclSemanticDomain::EN_MSG_ONECELLREFLIST));
      bResult &= oPath.bGoDown(teafi_tclKnot(teafi_tclToken::EN_POSHORIZONPATHSECTION,teafi_tclSemanticDomain::EN_LIST_ELEMENT,0));
      bResult &= oPath.bGoDown(teafi_tclKnot(teafi_tclToken::EN_LIST,teafi_tclSemanticDomain::EN_MSG_PATHSECTIONLIST));
      bResult &= oPath.bGoDown(teafi_tclKnot(teafi_tclToken::EN_U16_INDEXINREFERENCELIST,teafi_tclSemanticDomain::EN_MSG_INDEXOFROOTINLASTHORIZON));
      bResult &= oPath.bGoDown(teafi_tclKnot(teafi_tclToken::EN_U32,teafi_tclSemanticDomain::EN_MSG_DATABASEID));
      bResult &= oPath.bGoDown(teafi_tclKnot(teafi_tclToken::EN_B8_TEAPRESENCEINDICATOR,teafi_tclSemanticDomain::EN_LIST_ELEMENT,0));
      bResult &= oPath.bGoDown(teafi_tclKnot(teafi_tclToken::EN_LIST,teafi_tclSemanticDomain::EN_MSG_PATHSECTIONSTATELIST));
      bResult &= oPath.bGoDown(teafi_tclKnot(teafi_tclToken::EN_B32_ROADINFOCATEGORYINDICATOR,teafi_tclSemanticDomain::EN_MSG_REQUESTEDMDBDATA));
      bResult &= oPath.bGoDown(teafi_tclKnot(teafi_tclToken::EN_E8_POSHORIZONSTATE,teafi_tclSemanticDomain::EN_MSG_POSITIONHORIZONSTATE));
      bResult &= oPath.bGoDown(teafi_tclKnot(teafi_tclToken::EN_U32,teafi_tclSemanticDomain::EN_MSG_RELEASEID));
   } break;
   case teafi_tclToken::EN_MSG_TEAHORIZONSTATESTATUS:
   {
      if (17 <= poOutContext->u16GetMajorVersion())
      {
         bResult &= oPath.bGoDown(teafi_tclKnot(teafi_tclToken::EN_B16_UPOI_SOURCE,teafi_tclSemanticDomain::EN_MSG_CHANGEDPOISOURCES));
      }
      if (17 <= poOutContext->u16GetMajorVersion())
      {
         bResult &= oPath.bGoDown(teafi_tclKnot(teafi_tclToken::EN_B16_UPOI_SOURCE,teafi_tclSemanticDomain::EN_MSG_AVAILABLEPOISOURCES));
      }
      if (17 <= poOutContext->u16GetMajorVersion())
      {
         bResult &= oPath.bGoDown(teafi_tclKnot(teafi_tclToken::EN_U32,teafi_tclSemanticDomain::EN_MSG_ROUTEINFOID));
      }
      if (17 <= poOutContext->u16GetMajorVersion())
      {
         bResult &= oPath.bGoDown(teafi_tclKnot(teafi_tclToken::EN_U16_TRIPSEGMENTNUMBER,teafi_tclSemanticDomain::EN_MSG_TRIPSEGMENTNUMBER));
      }
      if (17 <= poOutContext->u16GetMajorVersion())
      {
         bResult &= oPath.bGoDown(teafi_tclKnot(teafi_tclToken::EN_U16_ROUTEHANDLE,teafi_tclSemanticDomain::EN_MSG_ROUTEHANDLE));
      }
      if (17 <= poOutContext->u16GetMajorVersion())
      {
         bResult &= oPath.bGoDown(teafi_tclKnot(teafi_tclToken::EN_U16_TRIPHANDLE,teafi_tclSemanticDomain::EN_MSG_TRIPHANDLE));
      }
      bResult &= oPath.bGoDown(teafi_tclKnot(teafi_tclToken::EN_U32,teafi_tclSemanticDomain::EN_MSG_DATABASEID));
      if (15 <= poOutContext->u16GetMajorVersion())
      {
         bResult &= oPath.bGoDown(teafi_tclKnot(teafi_tclToken::EN_U8_PERCENT,teafi_tclSemanticDomain::EN_MSG_LISTSETINFOPERCENTAGEUPOI));
      }
      bResult &= oPath.bGoDown(teafi_tclKnot(teafi_tclToken::EN_U8_PERCENT,teafi_tclSemanticDomain::EN_MSG_LISTSETINFOPERCENTAGEEDM));
      bResult &= oPath.bGoDown(teafi_tclKnot(teafi_tclToken::EN_U8_PERCENT,teafi_tclSemanticDomain::EN_MSG_LISTSETINFOPERCENTAGEMDB));
      bResult &= oPath.bGoDown(teafi_tclKnot(teafi_tclToken::EN_B8_TEAPRESENCEINDICATOR,teafi_tclSemanticDomain::EN_LIST_ELEMENT,0));
      bResult &= oPath.bGoDown(teafi_tclKnot(teafi_tclToken::EN_LIST,teafi_tclSemanticDomain::EN_MSG_PATHSECTIONSTATELIST));
      bResult &= oPath.bGoDown(teafi_tclKnot(teafi_tclToken::EN_B32_ROADINFOCATEGORYINDICATOR,teafi_tclSemanticDomain::EN_MSG_REQUESTABLEMDBDATA));
      bResult &= oPath.bGoDown(teafi_tclKnot(teafi_tclToken::EN_E8_POSHORIZONSTATE,teafi_tclSemanticDomain::EN_MSG_POSITIONHORIZONSTATE));
      bResult &= oPath.bGoDown(teafi_tclKnot(teafi_tclToken::EN_U32,teafi_tclSemanticDomain::EN_MSG_RELEASEID));
   } break;
   case teafi_tclToken::EN_MSG_MOSTPROBABLETEAPATHSTATUS:
   {
      if (13 <= poOutContext->u16GetMajorVersion())
      {
         bResult &= oPath.bGoDown(teafi_tclKnot(teafi_tclToken::EN_E8_MPPSTATE,teafi_tclSemanticDomain::EN_MSG_MPPSTATE));
      }
      if (13 <= poOutContext->u16GetMajorVersion())
      {
         bResult &= oPath.bGoDown(teafi_tclKnot(teafi_tclToken::EN_MPPDATA,teafi_tclSemanticDomain::EN_LIST_ELEMENT,0));
         bResult &= oPath.bGoDown(teafi_tclKnot(teafi_tclToken::EN_LIST,teafi_tclSemanticDomain::EN_MSG_MPPLIST));
      }
      if (poOutContext->u16GetMajorVersion() <= 12)
      {
         bResult &= oPath.bGoDown(teafi_tclKnot(teafi_tclToken::EN_U16,teafi_tclSemanticDomain::EN_LIST_ELEMENT,0));
         bResult &= oPath.bGoDown(teafi_tclKnot(teafi_tclToken::EN_LIST,teafi_tclSemanticDomain::EN_MSG_PATHSECTIONLISTINDICES));
      }
      bResult &= oPath.bGoDown(teafi_tclKnot(teafi_tclToken::EN_U32,teafi_tclSemanticDomain::EN_MSG_RELEASEID));
   } break;
   case teafi_tclToken::EN_MSG_ENGINEERINGTEXTSTATUS:
   {
      bResult &= oPath.bGoDown(teafi_tclKnot(teafi_tclToken::EN_STRING,teafi_tclSemanticDomain::EN_MSG_MESSAGE));
   } break;
   case teafi_tclToken::EN_BINCONTAINER:
   case teafi_tclToken::EN_RESERVED:
   case teafi_tclToken::EN_U8_PERCENT:
   case teafi_tclToken::EN_S16_PERTHOUSAND:
   case teafi_tclToken::EN_U16_INDEXINREFERENCELIST:
   case teafi_tclToken::EN_S32_KILOGRAM:
   case teafi_tclToken::EN_S32_POUND:
   case teafi_tclToken::EN_S16_METER:
   case teafi_tclToken::EN_S32_METER:
   case teafi_tclToken::EN_S32_YARDS:
   case teafi_tclToken::EN_S32_CENTIMETER:
   case teafi_tclToken::EN_S32_INCH:
   case teafi_tclToken::EN_S32_SECOND:
   case teafi_tclToken::EN_POSIXTIME:
   case teafi_tclToken::EN_E8_DST_STATE:
   case teafi_tclToken::EN_TIMEZONEELEMENT:
   case teafi_tclToken::EN_S16_KMPERHOUR:
   case teafi_tclToken::EN_S16_MILESPERHOUR:
   case teafi_tclToken::EN_S16_CENTIMETERSECOND:
   case teafi_tclToken::EN_FIVERSION:
   case teafi_tclToken::EN_S32_LONGITUDE:
   case teafi_tclToken::EN_S32_LATITUDE:
   case teafi_tclToken::EN_POSITIONWGS84:
   case teafi_tclToken::EN_E16_ISOCOUNTRYCODE:
   case teafi_tclToken::EN_U8_DIRECTIONABSOLUTE:
   case teafi_tclToken::EN_S16_CENTIDEGREE:
   case teafi_tclToken::EN_E8_BINCONTAINERTYPES:
   case teafi_tclToken::EN_S32_MEMU:
   case teafi_tclToken::EN_NAVCLUSTERDESC:
   case teafi_tclToken::EN_S32_EMU:
   case teafi_tclToken::EN_E8_NAVONECELLDIRECTION:
   case teafi_tclToken::EN_S16_CURVATUREVALUE:
   case teafi_tclToken::EN_NAVONECELLDESC:
   case teafi_tclToken::EN_E8_ROADCLASSCODE:
   case teafi_tclToken::EN_NAVPLAINPATHLISTSET:
   case teafi_tclToken::EN_E8_SIGNPOSTDESTTYPE:
   case teafi_tclToken::EN_E8_SIGNPOSTDESTINATIONCATEGORY:
   case teafi_tclToken::EN_E8_SIGNPOSTDESTSTATUS:
   case teafi_tclToken::EN_E8_DIRECTIONSTATUS:
   case teafi_tclToken::EN_SIGNPOSTDESTDIRECTION:
   case teafi_tclToken::EN_E8_DIRECTIONCATEGORY:
   case teafi_tclToken::EN_E8_NAVONECELLCATEGORY:
   case teafi_tclToken::EN_DIRECTIONCATEGORY:
   case teafi_tclToken::EN_DIRECTIONCATEGORYUNION0:
   case teafi_tclToken::EN_B8_DIRECTIONINFOSTATUS:
   case teafi_tclToken::EN_DIRECTIONINFO:
   case teafi_tclToken::EN_SIGNPOSTDESTINATION:
   case teafi_tclToken::EN_SIGNPOSTDESTINATIONUNION0:
   case teafi_tclToken::EN_REFERENCEELEMENT:
   case teafi_tclToken::EN_E8_CROSSROADINFOCATEGORY:
   case teafi_tclToken::EN_B32_ROADPROPERTY:
   case teafi_tclToken::EN_E8_NAVSTREETTYPE:
   case teafi_tclToken::EN_E8_ROADNETWORKCLASS:
   case teafi_tclToken::EN_NAVONECELL:
   case teafi_tclToken::EN_SIGNPOSTELEMENT:
   case teafi_tclToken::EN_SIGNPOSTELEMENTUNION0:
   case teafi_tclToken::EN_DIRECTIONINFOLISTSET:
   case teafi_tclToken::EN_REFERENCEELEMENTWITHID:
   case teafi_tclToken::EN_STATENAMEELEMENT:
   case teafi_tclToken::EN_COUNTYNAMEELEMENT:
   case teafi_tclToken::EN_CITYDISTRICTNAMEELEMENT:
   case teafi_tclToken::EN_BUILDUPAREANAMEELEMENT:
   case teafi_tclToken::EN_B8_ROADNUMBERSTATUS:
   case teafi_tclToken::EN_REQUIREDTAXDISC:
   case teafi_tclToken::EN_E8_REQUIREDPERMISSIONTYPE:
   case teafi_tclToken::EN_E8_REQUIREDPERMISSION:
   case teafi_tclToken::EN_GENERICREQUIREDPERMISSION:
   case teafi_tclToken::EN_REQUIREDPERMISSION:
   case teafi_tclToken::EN_REQUIREDPERMISSIONUNION0:
   case teafi_tclToken::EN_COUNTRYNAMEELEMENT:
   case teafi_tclToken::EN_STATENAMELISTSET:
   case teafi_tclToken::EN_COUNTYNAMELISTSET:
   case teafi_tclToken::EN_CITYNAMEELEMENT:
   case teafi_tclToken::EN_INDEXINREFERENCELIST:
   case teafi_tclToken::EN_BUILDUPAREANAMELISTSET:
   case teafi_tclToken::EN_ROADNAMELISTSET:
   case teafi_tclToken::EN_COMPASSDIRECTION:
   case teafi_tclToken::EN_REQUIREDPERMISSIONLISTSET:
   case teafi_tclToken::EN_E8_INTERSECTIONTYPE:
   case teafi_tclToken::EN_TIMEZONELISTSET:
   case teafi_tclToken::EN_INTERSECTIONNAMEELEMENT:
   case teafi_tclToken::EN_ROADNAMEELEMENT:
   case teafi_tclToken::EN_ROADNUMBER:
   case teafi_tclToken::EN_INTERSECTIONNUMBERELEMENT:
   case teafi_tclToken::EN_B8_PRESENCEINDICATOR:
   case teafi_tclToken::EN_COUNTRYNAMELISTSET:
   case teafi_tclToken::EN_CITYNAMELISTSET:
   case teafi_tclToken::EN_SIGNPOSTLISTSET:
   case teafi_tclToken::EN_ROADNUMBERLISTSET:
   case teafi_tclToken::EN_B16_ROADATTRIBUTE:
   case teafi_tclToken::EN_NAVPOSONECELLPROPERTY:
   case teafi_tclToken::EN_ROADATTRIBUTES:
   case teafi_tclToken::EN_E8_EXTRADESCELEMENTTYPE:
   case teafi_tclToken::EN_EXTRADESCELEMENT:
   case teafi_tclToken::EN_EXTRADESCLISTSET:
   case teafi_tclToken::EN_B32_DATAPROPERTIES:
   case teafi_tclToken::EN_DATADESCELEMENT:
   case teafi_tclToken::EN_DATADESCLISTSET:
   case teafi_tclToken::EN_B8_CROSSROADPROPERTIES:
   case teafi_tclToken::EN_CROSSROADDESC:
   case teafi_tclToken::EN_CROSSROADINFO:
   case teafi_tclToken::EN_CROSSROADINFOUNION0:
   case teafi_tclToken::EN_INTERSECTIONDENOTATION:
   case teafi_tclToken::EN_INTERSECTIONPATHDENOTATION:
   case teafi_tclToken::EN_INTERSECTIONPATHDESC:
   case teafi_tclToken::EN_NAVINTERSECTIONLISTSET:
   case teafi_tclToken::EN_E8_BASETRAFFICSIGNCATEGORY:
   case teafi_tclToken::EN_E8_SPEEDSIGN:
   case teafi_tclToken::EN_E16_WARNINGSIGN:
   case teafi_tclToken::EN_E16_REGULATORYSIGN:
   case teafi_tclToken::EN_E16_ADDITIONALTRAFFICSIGN:
   case teafi_tclToken::EN_TIMEDEPENDENTSTRING:
   case teafi_tclToken::EN_B8_LANEDEPENDENTVALIDITY:
   case teafi_tclToken::EN_E8_TRAFFICSIGNQUANTIFIER:
   case teafi_tclToken::EN_ADDITIONALTRAFFICSIGN:
   case teafi_tclToken::EN_ADDITIONALTRAFFICSIGNUNION0:
   case teafi_tclToken::EN_TRAFFICSIGNELEMENT:
   case teafi_tclToken::EN_TRAFFICSIGNELEMENTUNION0:
   case teafi_tclToken::EN_TRAFFICSIGNELEMENTUNION1:
   case teafi_tclToken::EN_ROADINFOCOMBINATION:
   case teafi_tclToken::EN_TRAFFICSIGNLISTSET:
   case teafi_tclToken::EN_B32_POICATEGORY:
   case teafi_tclToken::EN_POIELEMENT:
   case teafi_tclToken::EN_POILISTSET:
   case teafi_tclToken::EN_TOLLBOOTHELEMENT:
   case teafi_tclToken::EN_TOLLBOOTHLISTSET:
   case teafi_tclToken::EN_CITYDISTRICTNAMELISTSET:
   case teafi_tclToken::EN_MAPCODEDELEMENT:
   case teafi_tclToken::EN_MAPCODEDELEMENTUNION0:
   case teafi_tclToken::EN_POINTOFINTERESTELEMENT:
   case teafi_tclToken::EN_UNSPECIFIEDTEXT:
   case teafi_tclToken::EN_E8_POSHORIZONSTATE:
   case teafi_tclToken::EN_OFFSETSLOPEVALUE:
   case teafi_tclToken::EN_OFFSETHEIGHTVALUE:
   case teafi_tclToken::EN_E8_DIGITALMAPSPEEDCATEGORYTYPE:
   case teafi_tclToken::EN_E8_POSHORIZONSUCCESSORSTATE:
   case teafi_tclToken::EN_B32_PATHSECTIONSTATUS:
   case teafi_tclToken::EN_B8_POSHORIZONSUCCESSORSTATE:
   case teafi_tclToken::EN_POSHORIZONPATHSUCCESSOR:
   case teafi_tclToken::EN_POSHORIZONPATHSECTION:
   case teafi_tclToken::EN_POSHORIZONONECELLDESC:
   case teafi_tclToken::EN_B8_HORIZONONECELLPROPERTYSTATUS:
   case teafi_tclToken::EN_HORIZONMOSTPROBABLEPATH:
   case teafi_tclToken::EN_POSHORIZONROOTELEMENT:
   case teafi_tclToken::EN_POSHORIZONONECELLSECTION:
   case teafi_tclToken::EN_B8_TEAPRESENCEINDICATOR:
   case teafi_tclToken::EN_B32_ROADINFOCATEGORYINDICATOR:
   case teafi_tclToken::EN_E8_HORIZONROADINFOCATEGORY:
   case teafi_tclToken::EN_HORIZONROADINFOUNION:
   case teafi_tclToken::EN_HORIZONROADINFOUNIONUNION0:
   case teafi_tclToken::EN_B8_CURVATURESTATUS:
   case teafi_tclToken::EN_CURVATURE:
   case teafi_tclToken::EN_CURVATURELIST:
   case teafi_tclToken::EN_E8_MPPSTATE:
   case teafi_tclToken::EN_MPPDATA:
   case teafi_tclToken::EN_ALTERNATIVTEAEVENTIDLIST:
   case teafi_tclToken::EN_E8_TEAEVENTTYPE:
   case teafi_tclToken::EN_TEAEVENTID:
   case teafi_tclToken::EN_MAPCOORDINATES:
   case teafi_tclToken::EN_S8_MAPDISPLAYZLEVEL:
   case teafi_tclToken::EN_S8_MAPDISPLAYPRIORITY:
   case teafi_tclToken::EN_MAPDESCRIPTIONLISTSET:
   case teafi_tclToken::EN_E8_MAPELEMENTDESCRTYPE:
   case teafi_tclToken::EN_MAPELEMENTDESCRIPTOR:
   case teafi_tclToken::EN_MAPELEMENTDESCRIPTORUNION0:
   case teafi_tclToken::EN_MAPELEMENTDESCRIPTION:
   case teafi_tclToken::EN_E8_MAPGEOMETRICTYPE:
   case teafi_tclToken::EN_E16_SELECTIONCRITERIONTYPE:
   case teafi_tclToken::EN_E8_SURFACECOVERCODE:
   case teafi_tclToken::EN_U16_USERTRAFFICMESSAGEHANDLE:
   case teafi_tclToken::EN_E8_LANESTATUS:
   case teafi_tclToken::EN_B8_LANETYPE:
   case teafi_tclToken::EN_B8_LANECHANGERESTRICTION:
   case teafi_tclToken::EN_U8_INDEXINLANEINFOSEGMENTLIST:
   case teafi_tclToken::EN_U8_INDEXINLANEINFOLIST:
   case teafi_tclToken::EN_U8_DRIVINGDIRECTION:
   case teafi_tclToken::EN_LANEDIRECTION:
   case teafi_tclToken::EN_LANEINFOONECELLREFERENCE:
   case teafi_tclToken::EN_LANEINFOONECELLINDEXREFERENCE:
   case teafi_tclToken::EN_LANEINFOPATHSECTIONINDEXREFERENCE:
   case teafi_tclToken::EN_LANEINFOELEMENTREFERENCE:
   case teafi_tclToken::EN_E8_LANEREFERENCECATEGORY:
   case teafi_tclToken::EN_LANEREFERENCE:
   case teafi_tclToken::EN_LANEREFERENCEUNION0:
   case teafi_tclToken::EN_LANEINFO:
   case teafi_tclToken::EN_LANEINFOSEGMENT:
   case teafi_tclToken::EN_LANEINFOSEGMENTLIST:
   case teafi_tclToken::EN_LANEINFOLISTSET:
   case teafi_tclToken::EN_E8_TMGEOMETRICMESSAGETYPE:
   case teafi_tclToken::EN_E16_NAVIEVENTVALUE:
   case teafi_tclToken::EN_E8_TMAFFECTIONTYPE:
   case teafi_tclToken::EN_UPOI_CATEGORY:
   case teafi_tclToken::EN_E8_UPOI_SOURCE:
   case teafi_tclToken::EN_B16_UPOI_SOURCE:
   case teafi_tclToken::EN_B8_UPOI_FILTERSETSTATUS:
   case teafi_tclToken::EN_B8_UPOI_VALIDITY:
   case teafi_tclToken::EN_UPOI_ELEMENT:
   case teafi_tclToken::EN_B8_UPOI_FILTERSET_FIELDRELEVANCE:
   case teafi_tclToken::EN_UPOI_FILTERSET:
   case teafi_tclToken::EN_UPOI_FILTERLIST:
   case teafi_tclToken::EN_B8_UPOI_STATUS:
   case teafi_tclToken::EN_UPOI_COMBINATION:
   case teafi_tclToken::EN_UPOI_LISTSET:
   case teafi_tclToken::EN_E8_SHAPETYPE:
   case teafi_tclToken::EN_SHAPE:
   case teafi_tclToken::EN_RDBID:
   case teafi_tclToken::EN_TMPROGRAMSERVICE:
   case teafi_tclToken::EN_TMSERVICEPROVIDER:
   case teafi_tclToken::EN_E8_TMCATEGORY:
   case teafi_tclToken::EN_B8_TMMAPPINGPOSSIBILITY:
   case teafi_tclToken::EN_B8_TMMAPPINGSTATUS:
   case teafi_tclToken::EN_B8_TMONECELLATTRIBUTE:
   case teafi_tclToken::EN_TMONECELLPORTION:
   case teafi_tclToken::EN_E8_TMVALUESTATUS:
   case teafi_tclToken::EN_E8_TMCINTERSECTIONPATHTYPE:
   case teafi_tclToken::EN_TMCSTRUCTUREDTEXT:
   case teafi_tclToken::EN_E8_TMFLOWIMPACT:
   case teafi_tclToken::EN_E8_TMURGENCY:
   case teafi_tclToken::EN_E8_TMGEOGRAPHICALPATHRELATIONTYPE:
   case teafi_tclToken::EN_B8_TMRELEVANCE:
   case teafi_tclToken::EN_E8_TRAFFICMSGTYPE:
   case teafi_tclToken::EN_E8_EVENTTYPE:
   case teafi_tclToken::EN_B32_TRAFFICMESSAGESOURCE:
   case teafi_tclToken::EN_U16_TRIPHANDLE:
   case teafi_tclToken::EN_U16_TRIPSEGMENTNUMBER:
   case teafi_tclToken::EN_U16_ROUTEHANDLE:
   case teafi_tclToken::EN_E8_TMLOCATIONTYPE:
   case teafi_tclToken::EN_E16_EFFECTCODE:
   case teafi_tclToken::EN_E16_CAUSECODE:
   case teafi_tclToken::EN_E8_TENDENCY:
   case teafi_tclToken::EN_TMEVENT:
   case teafi_tclToken::EN_TMINFO:
   case teafi_tclToken::EN_TMCODEDMESSAGE:
   case teafi_tclToken::EN_TMCODEDMESSAGEBINCONTAINER:
   case teafi_tclToken::EN_TMCOMBINATION:
   case teafi_tclToken::EN_TMINFOLISTSET:
   case teafi_tclToken::EN_MAPGEOGRAPHICTYPE:
   case teafi_tclToken::EN_U8:   
   case teafi_tclToken::EN_S8:   
   case teafi_tclToken::EN_U16:   
   case teafi_tclToken::EN_S16:   
   case teafi_tclToken::EN_U24:   
   case teafi_tclToken::EN_S24:   
   case teafi_tclToken::EN_U32:   
   case teafi_tclToken::EN_S32:   
   case teafi_tclToken::EN_U64:   
   case teafi_tclToken::EN_S64:   
   case teafi_tclToken::EN_F32:   
   case teafi_tclToken::EN_F64:   
   case teafi_tclToken::EN_BOOL:   
   case teafi_tclToken::EN_STRING:   
   case teafi_tclToken::EN_MULTILANGUAGESTRING:   
   default:
      oPath.bGoDown(teafi_tclKnot(enMsgToken,teafi_tclSemanticDomain::EN_UNKNOWN));
      bResult = TRUE;
   }	
   return bResult;
}

tBool teafi_tclDescription::bDoIt(fi_tclVisitableTypeBase& oTypeBase)
{
   // --read or write?
   if (enType==EN_PARSING)
   {
     // --read first, then pass visitor
     (*poInContext) >> oTypeBase;
     oTypeBase.vTakeVisitor(*poVisitor);
   }
   else
   {
     // --first pass visitor, then stream 
	 oTypeBase.vTakeVisitor(*poVisitor);
     (*poOutContext) << oTypeBase;
   }
   return poVisitor->bIsValid();
}

tBool teafi_tclDescription::bProcessMessage() {
   tBool bResult = TRUE;
   tBool bInsideBinContainerVersion = false;
   tU16 u16MajorVersion;
   if (enType == EN_GENERATING)
   {
      u16MajorVersion = poOutContext->u16GetMajorVersion();
   }
   else
   {
      u16MajorVersion = poInContext->u16GetMajorVersion();
   }
   if (u16MajorVersion > 0x8000)
   {
      return FALSE;
   }
   tU16 u16SavedMajorVersion = u16MajorVersion;
   poVisitor->vReleaseBreak();
   while ((oPath.u32Position>0) && 
      bResult &&
      !poVisitor->bBreak() )    {
      // get current context (name, type, list index of next element)
      teafi_tclKnot oKnot = oPath.oGetIterator().oKnot();
      teafi_tclSemanticDomain::tenType enSemanticDomain = oKnot.enSemanticDomain;
      teafi_tclToken::tenType enToken = oKnot.enToken;
      tU32 u32Index = oKnot.u32Index;
      
      // lists need special handling
      if (enSemanticDomain == teafi_tclSemanticDomain::EN_LIST_ELEMENT) {
         oPath.bGoUp();
         // has list remaining elements?
         if (u32Index < oPath.oGetIterator().oKnot().u32Index) {
            // create next list element
            oPath.bGoDown(teafi_tclKnot(enToken,enSemanticDomain,u32Index+1));
            oPath.bGoDown(teafi_tclKnot(enToken,enSemanticDomain,u32Index));
         } else {
            // remove list, clean up
            oPath.bGoUp();
            oCallStack.bGoUp();
            continue;	
         }
      }
      // push current context on stack for visitor
      oCallStack.bGoDown(teafi_tclKnot(enToken,enSemanticDomain,u32Index));
      poVisitor->oIterator=oCallStack.oGetIterator();
      
      // now, process element
      switch (enToken) {
      case teafi_tclToken::EN_END_OF_STRUCT: 
      {
         // clean up after structures
         if (enSemanticDomain == teafi_tclSemanticDomain::EN_BINCONTAINER)
         {
            u16MajorVersion = u16SavedMajorVersion;
            if (enType == EN_GENERATING)
            {
               poOutContext->u16SetMajorVersion(u16MajorVersion);
            }
            else
            {
               poInContext->u16SetMajorVersion(u16MajorVersion);
            }
         }
         oPath.bGoUp();
         oCallStack.bGoUp();
         oCallStack.bGoUp();
      } break;
      case teafi_tclToken::EN_LIST: 
      {
         fi_tclList oList;
         // get list size
         if (!bDoIt(oList)) {
            // rearrange LIST and LIST_ELEMENT knots
            // pop "old" LIST knot
            oPath.bGoUp();
            // pop and backup LIST_ELEMENT knot
            teafi_tclKnot saveKnot;
            oPath.bGoUp(saveKnot);
            // push LIST knot
            oPath.bGoDown(teafi_tclKnot(enToken,enSemanticDomain,oList.u32ListSize));
            // push LIST_ELEMENT knot
            oPath.bGoDown(saveKnot);
            return FALSE;
         } else {
            // rearrange LIST and LIST_ELEMENT knots
            // pop "old" LIST knot
            oPath.bGoUp();
            // pop and backup LIST_ELEMENT knot
            teafi_tclKnot saveKnot;
            oPath.bGoUp(saveKnot);
            // push LIST knot
            oPath.bGoDown(teafi_tclKnot(enToken,enSemanticDomain,oList.u32ListSize));
            // push LIST_ELEMENT knot
            oPath.bGoDown(saveKnot);
         }
      } break;
      case teafi_tclToken::EN_U8: 
      {
         fi_tclU8 oU8;
         if (!bDoIt(oU8))
            return FALSE;
         oCallStack.bGoUp();
         oPath.bGoUp();
         if (bInsideBinContainerVersion)
         {
            bInsideBinContainerVersion = false;
            u16SavedMajorVersion = u16MajorVersion;
            u16MajorVersion = oU8.u8Value;
            if (enType == EN_GENERATING)
            {
               poOutContext->u16SetMajorVersion(u16MajorVersion);
            }
            else
            {
               poInContext->u16SetMajorVersion(u16MajorVersion);
            }
         }
      } break;
      case teafi_tclToken::EN_U16: 
      {
         fi_tclU16 oU16;
         if (!bDoIt(oU16))
            return FALSE;
         oCallStack.bGoUp();
         oPath.bGoUp();
      } break;
      case teafi_tclToken::EN_U24: 
      {
         fi_tclU24 oU24;
         if (!bDoIt(oU24))
            return FALSE;
         oCallStack.bGoUp();
         oPath.bGoUp();
      } break;
      case teafi_tclToken::EN_U32: 
      {
         fi_tclU32 oU32;
         if (!bDoIt(oU32))
            return FALSE;
         oCallStack.bGoUp();
         oPath.bGoUp();
      } break;
      case teafi_tclToken::EN_U64: 
      {
         fi_tclU64 oU64;
         if (!bDoIt(oU64))
            return FALSE;
         oCallStack.bGoUp();
         oPath.bGoUp();
      } break;
      case teafi_tclToken::EN_S8: 
      {
         fi_tclS8 oS8;
         if (!bDoIt(oS8))
            return FALSE;
         oCallStack.bGoUp();
         oPath.bGoUp();
      } break;
      case teafi_tclToken::EN_S16: 
      {
         fi_tclS16 oS16;
         if (!bDoIt(oS16))
            return FALSE;
         oCallStack.bGoUp();
         oPath.bGoUp();
      } break;
      case teafi_tclToken::EN_S24: 
      {
         fi_tclS24 oS24;
         if (!bDoIt(oS24))
            return FALSE;
         oCallStack.bGoUp();
         oPath.bGoUp();
      } break;
      case teafi_tclToken::EN_S32: 
      {
         fi_tclS32 oS32;
         if (!bDoIt(oS32))
            return FALSE;
         oCallStack.bGoUp();
         oPath.bGoUp();
      } break;
      case teafi_tclToken::EN_S64: 
      {
         fi_tclS64 oS64;
         if (!bDoIt(oS64))
            return FALSE;
         oCallStack.bGoUp();
         oPath.bGoUp();
      } break;
      case teafi_tclToken::EN_F32: 
      {
         fi_tclF32 oF32;
         if (!bDoIt(oF32))
            return FALSE;
         oCallStack.bGoUp();
         oPath.bGoUp();
      } break;
      case teafi_tclToken::EN_F64: 
      {
         fi_tclF64 oF64;
         if (!bDoIt(oF64))
            return FALSE;
         oCallStack.bGoUp();
         oPath.bGoUp();
      } break;
      case teafi_tclToken::EN_BOOL: 
      {
         fi_tclBool oBool;
         if (!bDoIt(oBool))
            return FALSE;
         oCallStack.bGoUp();
         oPath.bGoUp();
      } break;
      case teafi_tclToken::EN_STRING: 
      {
         fi_tclString oString;
         if (!bDoIt(oString)) {
            oString.vDestroy();
            return FALSE;
         }
         oString.vDestroy();
         oCallStack.bGoUp();
         oPath.bGoUp();
      } break;
      case teafi_tclToken::EN_MULTILANGUAGESTRING: 
      {
         fi_tclMultiLanguageString oString;
         if (!bDoIt(oString)) {
            oString.vDestroy();
            return FALSE;
         }
         oString.vDestroy();
         oCallStack.bGoUp();
         oPath.bGoUp();
      } break;
      // include rest of type expansions/processing
   case teafi_tclToken::EN_MSG_GETTEAHORIZONMETHODSTART:
   case teafi_tclToken::EN_MSG_GETTEAHORIZONMETHODRESULT:
   case teafi_tclToken::EN_MSG_GETUPOISMETHODSTART:
   case teafi_tclToken::EN_MSG_GETUPOISMETHODRESULT:
   case teafi_tclToken::EN_MSG_TEAHORIZONGET:
   case teafi_tclToken::EN_MSG_TEAHORIZONUPREG:
   case teafi_tclToken::EN_MSG_TEAHORIZONRELUPREG:
   case teafi_tclToken::EN_MSG_TEAHORIZONSTATUS:
   case teafi_tclToken::EN_MSG_TEAHORIZONSTATEGET:
   case teafi_tclToken::EN_MSG_TEAHORIZONSTATEUPREG:
   case teafi_tclToken::EN_MSG_TEAHORIZONSTATERELUPREG:
   case teafi_tclToken::EN_MSG_TEAHORIZONSTATESTATUS:
   case teafi_tclToken::EN_MSG_MOSTPROBABLETEAPATHGET:
   case teafi_tclToken::EN_MSG_MOSTPROBABLETEAPATHUPREG:
   case teafi_tclToken::EN_MSG_MOSTPROBABLETEAPATHRELUPREG:
   case teafi_tclToken::EN_MSG_MOSTPROBABLETEAPATHSTATUS:
   case teafi_tclToken::EN_MSG_ENGINEERINGTEXTGET:
   case teafi_tclToken::EN_MSG_ENGINEERINGTEXTUPREG:
   case teafi_tclToken::EN_MSG_ENGINEERINGTEXTRELUPREG:
   case teafi_tclToken::EN_MSG_ENGINEERINGTEXTSTATUS:
      bInitMessage(enToken);
      break;
   case teafi_tclToken::EN_BINCONTAINER:
   {
      if (poVisitor->bDoExpand_BinContainer(enSemanticDomain))
      {
         oPath.bGoUp();
         oPath.bGoDown(teafi_tclKnot(teafi_tclToken::EN_END_OF_STRUCT,teafi_tclSemanticDomain::EN_UNKNOWN));
         oPath.bGoDown(teafi_tclKnot(teafi_tclToken::EN_U8,teafi_tclSemanticDomain::EN_LIST_ELEMENT,0));
         oPath.bGoDown(teafi_tclKnot(teafi_tclToken::EN_LIST,teafi_tclSemanticDomain::EN_CONTAINERDATALIST));
      }
      else
      {
         fi_tcl_BinContainer o_BinContainer;
         if (!bDoIt(o_BinContainer))
         {
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
            o_BinContainer.vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
            return FALSE;
         }
         else
         {
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
            o_BinContainer.vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
            oCallStack.bGoUp();
            oPath.bGoUp();
         }
      }
   } break;
   case teafi_tclToken::EN_RESERVED:
   {
      oCallStack.bGoUp();
      oPath.bGoUp();
   } break;
   case teafi_tclToken::EN_U8_PERCENT:
   {
      fi_tcl_u8_Percent o_u8_Percent;
      if (!bDoIt(o_u8_Percent))
         return FALSE;
      oCallStack.bGoUp();
      oPath.bGoUp();
   } break;
   case teafi_tclToken::EN_S16_PERTHOUSAND:
   {
      fi_tcl_s16_PerThousand o_s16_PerThousand;
      if (!bDoIt(o_s16_PerThousand))
         return FALSE;
      oCallStack.bGoUp();
      oPath.bGoUp();
   } break;
   case teafi_tclToken::EN_U16_INDEXINREFERENCELIST:
   {
      fi_tcl_u16_IndexInReferenceList o_u16_IndexInReferenceList;
      if (!bDoIt(o_u16_IndexInReferenceList))
         return FALSE;
      oCallStack.bGoUp();
      oPath.bGoUp();
   } break;
   case teafi_tclToken::EN_S32_KILOGRAM:
   {
      fi_tcl_s32_Kilogram o_s32_Kilogram;
      if (!bDoIt(o_s32_Kilogram))
         return FALSE;
      oCallStack.bGoUp();
      oPath.bGoUp();
   } break;
   case teafi_tclToken::EN_S32_POUND:
   {
      fi_tcl_s32_Pound o_s32_Pound;
      if (!bDoIt(o_s32_Pound))
         return FALSE;
      oCallStack.bGoUp();
      oPath.bGoUp();
   } break;
   case teafi_tclToken::EN_S16_METER:
   {
      fi_tcl_s16_Meter o_s16_Meter;
      if (!bDoIt(o_s16_Meter))
         return FALSE;
      oCallStack.bGoUp();
      oPath.bGoUp();
   } break;
   case teafi_tclToken::EN_S32_METER:
   {
      fi_tcl_s32_Meter o_s32_Meter;
      if (!bDoIt(o_s32_Meter))
         return FALSE;
      oCallStack.bGoUp();
      oPath.bGoUp();
   } break;
   case teafi_tclToken::EN_S32_YARDS:
   {
      fi_tcl_s32_Yards o_s32_Yards;
      if (!bDoIt(o_s32_Yards))
         return FALSE;
      oCallStack.bGoUp();
      oPath.bGoUp();
   } break;
   case teafi_tclToken::EN_S32_CENTIMETER:
   {
      fi_tcl_s32_Centimeter o_s32_Centimeter;
      if (!bDoIt(o_s32_Centimeter))
         return FALSE;
      oCallStack.bGoUp();
      oPath.bGoUp();
   } break;
   case teafi_tclToken::EN_S32_INCH:
   {
      fi_tcl_s32_Inch o_s32_Inch;
      if (!bDoIt(o_s32_Inch))
         return FALSE;
      oCallStack.bGoUp();
      oPath.bGoUp();
   } break;
   case teafi_tclToken::EN_S32_SECOND:
   {
      fi_tcl_s32_Second o_s32_Second;
      if (!bDoIt(o_s32_Second))
         return FALSE;
      oCallStack.bGoUp();
      oPath.bGoUp();
   } break;
   case teafi_tclToken::EN_POSIXTIME:
   {
      if (poVisitor->bDoExpand_POSIXTime(enSemanticDomain))
      {
         oPath.bGoUp();
         oPath.bGoDown(teafi_tclKnot(teafi_tclToken::EN_END_OF_STRUCT,teafi_tclSemanticDomain::EN_UNKNOWN));
         oPath.bGoDown(teafi_tclKnot(teafi_tclToken::EN_S32,teafi_tclSemanticDomain::EN_TIME));
      }
      else
      {
         fi_tcl_POSIXTime o_POSIXTime;
         if (!bDoIt(o_POSIXTime))
         {
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
            o_POSIXTime.vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
            return FALSE;
         }
         else
         {
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
            o_POSIXTime.vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
            oCallStack.bGoUp();
            oPath.bGoUp();
         }
      }
   } break;
   case teafi_tclToken::EN_E8_DST_STATE:
   {
      fi_tcl_e8_DST_State o_e8_DST_State;
      if (!bDoIt(o_e8_DST_State))
         return FALSE;
      oCallStack.bGoUp();
      oPath.bGoUp();
   } break;
   case teafi_tclToken::EN_TIMEZONEELEMENT:
   {
      if (poVisitor->bDoExpand_TimeZoneElement(enSemanticDomain))
      {
         oPath.bGoUp();
         oPath.bGoDown(teafi_tclKnot(teafi_tclToken::EN_END_OF_STRUCT,teafi_tclSemanticDomain::EN_UNKNOWN));
         oPath.bGoDown(teafi_tclKnot(teafi_tclToken::EN_U8,teafi_tclSemanticDomain::EN_LIST_ELEMENT,0));
         oPath.bGoDown(teafi_tclKnot(teafi_tclToken::EN_LIST,teafi_tclSemanticDomain::EN_DST_TIMEDOMAIN));
         oPath.bGoDown(teafi_tclKnot(teafi_tclToken::EN_S32_SECOND,teafi_tclSemanticDomain::EN_DSTDIFFERENCE));
         oPath.bGoDown(teafi_tclKnot(teafi_tclToken::EN_E8_DST_STATE,teafi_tclSemanticDomain::EN_DST_STATE));
         oPath.bGoDown(teafi_tclKnot(teafi_tclToken::EN_S32_SECOND,teafi_tclSemanticDomain::EN_TIMEZONEDIFFERENCE));
         oPath.bGoDown(teafi_tclKnot(teafi_tclToken::EN_MULTILANGUAGESTRING,teafi_tclSemanticDomain::EN_ABBREVIATION_DST_IN_EFFECT));
         oPath.bGoDown(teafi_tclKnot(teafi_tclToken::EN_MULTILANGUAGESTRING,teafi_tclSemanticDomain::EN_ABBREVIATION_STANDARDTIME));
      }
      else
      {
         fi_tcl_TimeZoneElement o_TimeZoneElement;
         if (!bDoIt(o_TimeZoneElement))
         {
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
            o_TimeZoneElement.vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
            return FALSE;
         }
         else
         {
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
            o_TimeZoneElement.vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
            oCallStack.bGoUp();
            oPath.bGoUp();
         }
      }
   } break;
   case teafi_tclToken::EN_S16_KMPERHOUR:
   {
      fi_tcl_s16_KmPerHour o_s16_KmPerHour;
      if (!bDoIt(o_s16_KmPerHour))
         return FALSE;
      oCallStack.bGoUp();
      oPath.bGoUp();
   } break;
   case teafi_tclToken::EN_S16_MILESPERHOUR:
   {
      fi_tcl_s16_MilesPerHour o_s16_MilesPerHour;
      if (!bDoIt(o_s16_MilesPerHour))
         return FALSE;
      oCallStack.bGoUp();
      oPath.bGoUp();
   } break;
   case teafi_tclToken::EN_S16_CENTIMETERSECOND:
   {
      fi_tcl_s16_CentimeterSecond o_s16_CentimeterSecond;
      if (!bDoIt(o_s16_CentimeterSecond))
         return FALSE;
      oCallStack.bGoUp();
      oPath.bGoUp();
   } break;
   case teafi_tclToken::EN_FIVERSION:
   {
      if (poVisitor->bDoExpand_FIVersion(enSemanticDomain))
      {
         oPath.bGoUp();
         oPath.bGoDown(teafi_tclKnot(teafi_tclToken::EN_END_OF_STRUCT,teafi_tclSemanticDomain::EN_UNKNOWN));
         oPath.bGoDown(teafi_tclKnot(teafi_tclToken::EN_U8,teafi_tclSemanticDomain::EN_PATCHVERSION));
         oPath.bGoDown(teafi_tclKnot(teafi_tclToken::EN_U8,teafi_tclSemanticDomain::EN_MINORVERSION));
         oPath.bGoDown(teafi_tclKnot(teafi_tclToken::EN_U8,teafi_tclSemanticDomain::EN_MAJORVERSION));
      }
      else
      {
         fi_tcl_FIVersion o_FIVersion;
         if (!bDoIt(o_FIVersion))
         {
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
            o_FIVersion.vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
            return FALSE;
         }
         else
         {
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
            o_FIVersion.vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
            oCallStack.bGoUp();
            oPath.bGoUp();
         }
      }
   } break;
   case teafi_tclToken::EN_S32_LONGITUDE:
   {
      fi_tcl_s32_Longitude o_s32_Longitude;
      if (!bDoIt(o_s32_Longitude))
         return FALSE;
      oCallStack.bGoUp();
      oPath.bGoUp();
   } break;
   case teafi_tclToken::EN_S32_LATITUDE:
   {
      fi_tcl_s32_Latitude o_s32_Latitude;
      if (!bDoIt(o_s32_Latitude))
         return FALSE;
      oCallStack.bGoUp();
      oPath.bGoUp();
   } break;
   case teafi_tclToken::EN_POSITIONWGS84:
   {
      if (poVisitor->bDoExpand_PositionWGS84(enSemanticDomain))
      {
         oPath.bGoUp();
         oPath.bGoDown(teafi_tclKnot(teafi_tclToken::EN_END_OF_STRUCT,teafi_tclSemanticDomain::EN_UNKNOWN));
         oPath.bGoDown(teafi_tclKnot(teafi_tclToken::EN_S32_LATITUDE,teafi_tclSemanticDomain::EN_LATITUDE));
         oPath.bGoDown(teafi_tclKnot(teafi_tclToken::EN_S32_LONGITUDE,teafi_tclSemanticDomain::EN_LONGITUDE));
      }
      else
      {
         fi_tcl_PositionWGS84 o_PositionWGS84;
         if (!bDoIt(o_PositionWGS84))
         {
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
            o_PositionWGS84.vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
            return FALSE;
         }
         else
         {
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
            o_PositionWGS84.vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
            oCallStack.bGoUp();
            oPath.bGoUp();
         }
      }
   } break;
   case teafi_tclToken::EN_E16_ISOCOUNTRYCODE:
   {
      fi_tcl_e16_ISOCountryCode o_e16_ISOCountryCode;
      if (!bDoIt(o_e16_ISOCountryCode))
         return FALSE;
      oCallStack.bGoUp();
      oPath.bGoUp();
   } break;
   case teafi_tclToken::EN_U8_DIRECTIONABSOLUTE:
   {
      fi_tcl_u8_DirectionAbsolute o_u8_DirectionAbsolute;
      if (!bDoIt(o_u8_DirectionAbsolute))
         return FALSE;
      oCallStack.bGoUp();
      oPath.bGoUp();
   } break;
   case teafi_tclToken::EN_S16_CENTIDEGREE:
   {
      fi_tcl_s16_CentiDegree o_s16_CentiDegree;
      if (!bDoIt(o_s16_CentiDegree))
         return FALSE;
      oCallStack.bGoUp();
      oPath.bGoUp();
   } break;
   case teafi_tclToken::EN_E8_BINCONTAINERTYPES:
   {
      fi_tcl_e8_BinContainerTypes o_e8_BinContainerTypes;
      if (!bDoIt(o_e8_BinContainerTypes))
         return FALSE;
      oCallStack.bGoUp();
      oPath.bGoUp();
   } break;
   case teafi_tclToken::EN_S32_MEMU:
   {
      fi_tcl_s32_MEMU o_s32_MEMU;
      if (!bDoIt(o_s32_MEMU))
         return FALSE;
      oCallStack.bGoUp();
      oPath.bGoUp();
   } break;
   case teafi_tclToken::EN_NAVCLUSTERDESC:
   {
      if (poVisitor->bDoExpand_NavClusterDesc(enSemanticDomain))
      {
         oPath.bGoUp();
         oPath.bGoDown(teafi_tclKnot(teafi_tclToken::EN_END_OF_STRUCT,teafi_tclSemanticDomain::EN_UNKNOWN));
         oPath.bGoDown(teafi_tclKnot(teafi_tclToken::EN_U16,teafi_tclSemanticDomain::EN_LENGTH));
         oPath.bGoDown(teafi_tclKnot(teafi_tclToken::EN_U32,teafi_tclSemanticDomain::EN_FILEOFFSET));
         oPath.bGoDown(teafi_tclKnot(teafi_tclToken::EN_U16,teafi_tclSemanticDomain::EN_FILEID));
         oPath.bGoDown(teafi_tclKnot(teafi_tclToken::EN_U8,teafi_tclSemanticDomain::EN_LEVEL));
      }
      else
      {
         fi_tcl_NavClusterDesc o_NavClusterDesc;
         if (!bDoIt(o_NavClusterDesc))
         {
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
            o_NavClusterDesc.vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
            return FALSE;
         }
         else
         {
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
            o_NavClusterDesc.vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
            oCallStack.bGoUp();
            oPath.bGoUp();
         }
      }
   } break;
   case teafi_tclToken::EN_S32_EMU:
   {
      fi_tcl_s32_EMU o_s32_EMU;
      if (!bDoIt(o_s32_EMU))
         return FALSE;
      oCallStack.bGoUp();
      oPath.bGoUp();
   } break;
   case teafi_tclToken::EN_E8_NAVONECELLDIRECTION:
   {
      fi_tcl_e8_NavOneCellDirection o_e8_NavOneCellDirection;
      if (!bDoIt(o_e8_NavOneCellDirection))
         return FALSE;
      oCallStack.bGoUp();
      oPath.bGoUp();
   } break;
   case teafi_tclToken::EN_S16_CURVATUREVALUE:
   {
      fi_tcl_s16_CurvatureValue o_s16_CurvatureValue;
      if (!bDoIt(o_s16_CurvatureValue))
         return FALSE;
      oCallStack.bGoUp();
      oPath.bGoUp();
   } break;
   case teafi_tclToken::EN_NAVONECELLDESC:
   {
      if (poVisitor->bDoExpand_NavOneCellDesc(enSemanticDomain))
      {
         oPath.bGoUp();
         oPath.bGoDown(teafi_tclKnot(teafi_tclToken::EN_END_OF_STRUCT,teafi_tclSemanticDomain::EN_UNKNOWN));
         oPath.bGoDown(teafi_tclKnot(teafi_tclToken::EN_U16_INDEXINREFERENCELIST,teafi_tclSemanticDomain::EN_INDEXINCLUSTERREFLIST));
         oPath.bGoDown(teafi_tclKnot(teafi_tclToken::EN_E8_NAVONECELLDIRECTION,teafi_tclSemanticDomain::EN_USEDIRECTION));
         oPath.bGoDown(teafi_tclKnot(teafi_tclToken::EN_U16,teafi_tclSemanticDomain::EN_ONECELLID));
      }
      else
      {
         fi_tcl_NavOneCellDesc o_NavOneCellDesc;
         if (!bDoIt(o_NavOneCellDesc))
         {
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
            o_NavOneCellDesc.vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
            return FALSE;
         }
         else
         {
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
            o_NavOneCellDesc.vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
            oCallStack.bGoUp();
            oPath.bGoUp();
         }
      }
   } break;
   case teafi_tclToken::EN_E8_ROADCLASSCODE:
   {
      fi_tcl_e8_RoadClassCode o_e8_RoadClassCode;
      if (!bDoIt(o_e8_RoadClassCode))
         return FALSE;
      oCallStack.bGoUp();
      oPath.bGoUp();
   } break;
   case teafi_tclToken::EN_NAVPLAINPATHLISTSET:
   {
      if (poVisitor->bDoExpand_NavPlainPathListSet(enSemanticDomain))
      {
         oPath.bGoUp();
         oPath.bGoDown(teafi_tclKnot(teafi_tclToken::EN_END_OF_STRUCT,teafi_tclSemanticDomain::EN_UNKNOWN));
         oPath.bGoDown(teafi_tclKnot(teafi_tclToken::EN_NAVONECELLDESC,teafi_tclSemanticDomain::EN_LIST_ELEMENT,0));
         oPath.bGoDown(teafi_tclKnot(teafi_tclToken::EN_LIST,teafi_tclSemanticDomain::EN_ONECELL));
         oPath.bGoDown(teafi_tclKnot(teafi_tclToken::EN_NAVCLUSTERDESC,teafi_tclSemanticDomain::EN_LIST_ELEMENT,0));
         oPath.bGoDown(teafi_tclKnot(teafi_tclToken::EN_LIST,teafi_tclSemanticDomain::EN_CLUSTER));
      }
      else
      {
         fi_tcl_NavPlainPathListSet o_NavPlainPathListSet;
         if (!bDoIt(o_NavPlainPathListSet))
         {
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
            o_NavPlainPathListSet.vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
            return FALSE;
         }
         else
         {
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
            o_NavPlainPathListSet.vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
            oCallStack.bGoUp();
            oPath.bGoUp();
         }
      }
   } break;
   case teafi_tclToken::EN_E8_SIGNPOSTDESTTYPE:
   {
      fi_tcl_e8_SignPostDestType o_e8_SignPostDestType;
      if (!bDoIt(o_e8_SignPostDestType))
         return FALSE;
      oCallStack.bGoUp();
      oPath.bGoUp();
   } break;
   case teafi_tclToken::EN_E8_SIGNPOSTDESTINATIONCATEGORY:
   {
      fi_tcl_e8_SignPostDestinationCategory o_e8_SignPostDestinationCategory;
      if (!bDoIt(o_e8_SignPostDestinationCategory))
         return FALSE;
      oCallStack.bGoUp();
      oPath.bGoUp();
   } break;
   case teafi_tclToken::EN_E8_SIGNPOSTDESTSTATUS:
   {
      fi_tcl_e8_SignPostDestStatus o_e8_SignPostDestStatus;
      if (!bDoIt(o_e8_SignPostDestStatus))
         return FALSE;
      oCallStack.bGoUp();
      oPath.bGoUp();
   } break;
   case teafi_tclToken::EN_E8_DIRECTIONSTATUS:
   {
      fi_tcl_e8_DirectionStatus o_e8_DirectionStatus;
      if (!bDoIt(o_e8_DirectionStatus))
         return FALSE;
      oCallStack.bGoUp();
      oPath.bGoUp();
   } break;
   case teafi_tclToken::EN_SIGNPOSTDESTDIRECTION:
   {
      if (poVisitor->bDoExpand_SignPostDestDirection(enSemanticDomain))
      {
         oPath.bGoUp();
         oPath.bGoDown(teafi_tclKnot(teafi_tclToken::EN_END_OF_STRUCT,teafi_tclSemanticDomain::EN_UNKNOWN));
         oPath.bGoDown(teafi_tclKnot(teafi_tclToken::EN_MULTILANGUAGESTRING,teafi_tclSemanticDomain::EN_DIRECTIONDESC));
         oPath.bGoDown(teafi_tclKnot(teafi_tclToken::EN_U8_DIRECTIONABSOLUTE,teafi_tclSemanticDomain::EN_DIRECTION));
         if (u16MajorVersion <= 8)
         {
            oPath.bGoDown(teafi_tclKnot(teafi_tclToken::EN_BOOL,teafi_tclSemanticDomain::EN_DIRECTIONISVALID));
         }
      }
      else
      {
         fi_tcl_SignPostDestDirection o_SignPostDestDirection;
         if (!bDoIt(o_SignPostDestDirection))
         {
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
            o_SignPostDestDirection.vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
            return FALSE;
         }
         else
         {
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
            o_SignPostDestDirection.vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
            oCallStack.bGoUp();
            oPath.bGoUp();
         }
      }
   } break;
   case teafi_tclToken::EN_E8_DIRECTIONCATEGORY:
   {
      fi_tcl_e8_DirectionCategory o_e8_DirectionCategory;
      if (!bDoIt(o_e8_DirectionCategory))
         return FALSE;
      oCallStack.bGoUp();
      oPath.bGoUp();
   } break;
   case teafi_tclToken::EN_E8_NAVONECELLCATEGORY:
   {
      fi_tcl_e8_NavOneCellCategory o_e8_NavOneCellCategory;
      if (!bDoIt(o_e8_NavOneCellCategory))
         return FALSE;
      oCallStack.bGoUp();
      oPath.bGoUp();
   } break;
   case teafi_tclToken::EN_DIRECTIONCATEGORYUNION0:
   {
      oPath.bGoUp();
      oCallStack.bGoUp();
      fi_tcl_e8_DirectionCategory oDataType;
      oCallStack.bGoDown(teafi_tclKnot(teafi_tclToken::EN_E8_DIRECTIONCATEGORY,teafi_tclSemanticDomain::EN_DATA_TYPE));
      poVisitor->oIterator = oCallStack.oGetIterator();
      bDoIt(oDataType);
      oCallStack.bGoUp();
      if ((oDataType.enType == fi_tcl_e8_DirectionCategory::FI_EN_T_COMPASSDIRECTION) &&
          !(9 <= u16MajorVersion))
      {
         oDataType.enType = fi_tcl_e8_DirectionCategory::FI_EN_T_RESERVED;
      }
      switch (oDataType.enType)
      {
      case fi_tcl_e8_DirectionCategory::FI_EN_T_RESERVED:
         oPath.bGoDown(teafi_tclKnot(teafi_tclToken::EN_RESERVED,teafi_tclSemanticDomain::EN_DIRECTIONCATEGORY));
         break;
      case fi_tcl_e8_DirectionCategory::FI_EN_T_COUNTRYNAMEELEMENT:
         oPath.bGoDown(teafi_tclKnot(teafi_tclToken::EN_COUNTRYNAMEELEMENT,teafi_tclSemanticDomain::EN_DIRECTIONCATEGORY));
         break;
      case fi_tcl_e8_DirectionCategory::FI_EN_T_STATENAMEELEMENT:
         oPath.bGoDown(teafi_tclKnot(teafi_tclToken::EN_STATENAMEELEMENT,teafi_tclSemanticDomain::EN_DIRECTIONCATEGORY));
         break;
      case fi_tcl_e8_DirectionCategory::FI_EN_T_COUNTYNAMEELEMENT:
         oPath.bGoDown(teafi_tclKnot(teafi_tclToken::EN_COUNTYNAMEELEMENT,teafi_tclSemanticDomain::EN_DIRECTIONCATEGORY));
         break;
      case fi_tcl_e8_DirectionCategory::FI_EN_T_CITYNAMEELEMENT:
         oPath.bGoDown(teafi_tclKnot(teafi_tclToken::EN_CITYNAMEELEMENT,teafi_tclSemanticDomain::EN_DIRECTIONCATEGORY));
         break;
      case fi_tcl_e8_DirectionCategory::FI_EN_T_CITYDISTRICTNAMEELEMENT:
         oPath.bGoDown(teafi_tclKnot(teafi_tclToken::EN_CITYDISTRICTNAMEELEMENT,teafi_tclSemanticDomain::EN_DIRECTIONCATEGORY));
         break;
      case fi_tcl_e8_DirectionCategory::FI_EN_T_BUILDUPAREANAMEELEMENT:
         oPath.bGoDown(teafi_tclKnot(teafi_tclToken::EN_BUILDUPAREANAMEELEMENT,teafi_tclSemanticDomain::EN_DIRECTIONCATEGORY));
         break;
      case fi_tcl_e8_DirectionCategory::FI_EN_T_ROADNAMEELEMENT:
         oPath.bGoDown(teafi_tclKnot(teafi_tclToken::EN_ROADNAMEELEMENT,teafi_tclSemanticDomain::EN_DIRECTIONCATEGORY));
         break;
      case fi_tcl_e8_DirectionCategory::FI_EN_T_ROADNUMBER:
         oPath.bGoDown(teafi_tclKnot(teafi_tclToken::EN_ROADNUMBER,teafi_tclSemanticDomain::EN_DIRECTIONCATEGORY));
         break;
      case fi_tcl_e8_DirectionCategory::FI_EN_T_INTERSECTIONNAMEELEMENT:
         oPath.bGoDown(teafi_tclKnot(teafi_tclToken::EN_INTERSECTIONNAMEELEMENT,teafi_tclSemanticDomain::EN_DIRECTIONCATEGORY));
         break;
      case fi_tcl_e8_DirectionCategory::FI_EN_T_INTERSECTIONNUMBERELEMENT:
         oPath.bGoDown(teafi_tclKnot(teafi_tclToken::EN_INTERSECTIONNUMBERELEMENT,teafi_tclSemanticDomain::EN_DIRECTIONCATEGORY));
         break;
      case fi_tcl_e8_DirectionCategory::FI_EN_T_POINTOFINTERESTELEMENT:
         oPath.bGoDown(teafi_tclKnot(teafi_tclToken::EN_POINTOFINTERESTELEMENT,teafi_tclSemanticDomain::EN_DIRECTIONCATEGORY));
         break;
      case fi_tcl_e8_DirectionCategory::FI_EN_T_UNSPECIFIEDTEXT:
         oPath.bGoDown(teafi_tclKnot(teafi_tclToken::EN_UNSPECIFIEDTEXT,teafi_tclSemanticDomain::EN_DIRECTIONCATEGORY));
         break;
      case fi_tcl_e8_DirectionCategory::FI_EN_T_COMPASSDIRECTION:
         oPath.bGoDown(teafi_tclKnot(teafi_tclToken::EN_COMPASSDIRECTION,teafi_tclSemanticDomain::EN_DIRECTIONCATEGORY));
         break;
      }
   } break;
   case teafi_tclToken::EN_DIRECTIONCATEGORY:
   {
      if (poVisitor->bDoExpand_DirectionCategory(enSemanticDomain))
      {
         oPath.bGoUp();
         oPath.bGoDown(teafi_tclKnot(teafi_tclToken::EN_END_OF_STRUCT,teafi_tclSemanticDomain::EN_UNKNOWN));
         oPath.bGoDown(teafi_tclKnot(teafi_tclToken::EN_DIRECTIONCATEGORYUNION0,teafi_tclSemanticDomain::EN_DIRECTIONCATEGORY));
      }
      else
      {
         fi_tcl_DirectionCategory o_DirectionCategory;
         if (!bDoIt(o_DirectionCategory))
         {
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
            o_DirectionCategory.vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
            return FALSE;
         }
         else
         {
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
            o_DirectionCategory.vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
            oCallStack.bGoUp();
            oPath.bGoUp();
         }
      }
   } break;
   case teafi_tclToken::EN_B8_DIRECTIONINFOSTATUS:
   {
      fi_tcl_b8_DirectionInfoStatus o_b8_DirectionInfoStatus;
      if (!bDoIt(o_b8_DirectionInfoStatus))
         return FALSE;
      oCallStack.bGoUp();
      oPath.bGoUp();
   } break;
   case teafi_tclToken::EN_DIRECTIONINFO:
   {
      if (poVisitor->bDoExpand_DirectionInfo(enSemanticDomain))
      {
         oPath.bGoUp();
         oPath.bGoDown(teafi_tclKnot(teafi_tclToken::EN_END_OF_STRUCT,teafi_tclSemanticDomain::EN_UNKNOWN));
         if (21 <= u16MajorVersion)
         {
            oPath.bGoDown(teafi_tclKnot(teafi_tclToken::EN_B8_DIRECTIONINFOSTATUS,teafi_tclSemanticDomain::EN_STATUS));
         }
         oPath.bGoDown(teafi_tclKnot(teafi_tclToken::EN_E8_DIRECTIONSTATUS,teafi_tclSemanticDomain::EN_DIRECTIONSTATUS));
         oPath.bGoDown(teafi_tclKnot(teafi_tclToken::EN_DIRECTIONCATEGORY,teafi_tclSemanticDomain::EN_DIRECTIONCATEGORY));
         oPath.bGoDown(teafi_tclKnot(teafi_tclToken::EN_U32,teafi_tclSemanticDomain::EN_DIRECTIONID));
      }
      else
      {
         fi_tcl_DirectionInfo o_DirectionInfo;
         if (!bDoIt(o_DirectionInfo))
         {
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
            o_DirectionInfo.vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
            return FALSE;
         }
         else
         {
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
            o_DirectionInfo.vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
            oCallStack.bGoUp();
            oPath.bGoUp();
         }
      }
   } break;
   case teafi_tclToken::EN_SIGNPOSTDESTINATIONUNION0:
   {
      oPath.bGoUp();
      oCallStack.bGoUp();
      fi_tcl_e8_SignPostDestinationCategory oDataType;
      oCallStack.bGoDown(teafi_tclKnot(teafi_tclToken::EN_E8_SIGNPOSTDESTINATIONCATEGORY,teafi_tclSemanticDomain::EN_DATA_TYPE));
      poVisitor->oIterator = oCallStack.oGetIterator();
      bDoIt(oDataType);
      oCallStack.bGoUp();
      if ((oDataType.enType == fi_tcl_e8_SignPostDestinationCategory::FI_EN_T_COMPASSDIRECTION) &&
          !(9 <= u16MajorVersion))
      {
         oDataType.enType = fi_tcl_e8_SignPostDestinationCategory::FI_EN_T_RESERVED;
      }
      switch (oDataType.enType)
      {
      case fi_tcl_e8_SignPostDestinationCategory::FI_EN_T_RESERVED:
         oPath.bGoDown(teafi_tclKnot(teafi_tclToken::EN_RESERVED,teafi_tclSemanticDomain::EN_SIGNPOSTDESTINATIONCATEGORY));
         break;
      case fi_tcl_e8_SignPostDestinationCategory::FI_EN_T_COUNTRYNAMEELEMENT:
         oPath.bGoDown(teafi_tclKnot(teafi_tclToken::EN_COUNTRYNAMEELEMENT,teafi_tclSemanticDomain::EN_SIGNPOSTDESTINATIONCATEGORY));
         break;
      case fi_tcl_e8_SignPostDestinationCategory::FI_EN_T_STATENAMEELEMENT:
         oPath.bGoDown(teafi_tclKnot(teafi_tclToken::EN_STATENAMEELEMENT,teafi_tclSemanticDomain::EN_SIGNPOSTDESTINATIONCATEGORY));
         break;
      case fi_tcl_e8_SignPostDestinationCategory::FI_EN_T_COUNTYNAMEELEMENT:
         oPath.bGoDown(teafi_tclKnot(teafi_tclToken::EN_COUNTYNAMEELEMENT,teafi_tclSemanticDomain::EN_SIGNPOSTDESTINATIONCATEGORY));
         break;
      case fi_tcl_e8_SignPostDestinationCategory::FI_EN_T_CITYNAMEELEMENT:
         oPath.bGoDown(teafi_tclKnot(teafi_tclToken::EN_CITYNAMEELEMENT,teafi_tclSemanticDomain::EN_SIGNPOSTDESTINATIONCATEGORY));
         break;
      case fi_tcl_e8_SignPostDestinationCategory::FI_EN_T_CITYDISTRICTNAMEELEMENT:
         oPath.bGoDown(teafi_tclKnot(teafi_tclToken::EN_CITYDISTRICTNAMEELEMENT,teafi_tclSemanticDomain::EN_SIGNPOSTDESTINATIONCATEGORY));
         break;
      case fi_tcl_e8_SignPostDestinationCategory::FI_EN_T_BUILDUPAREANAMEELEMENT:
         oPath.bGoDown(teafi_tclKnot(teafi_tclToken::EN_BUILDUPAREANAMEELEMENT,teafi_tclSemanticDomain::EN_SIGNPOSTDESTINATIONCATEGORY));
         break;
      case fi_tcl_e8_SignPostDestinationCategory::FI_EN_T_ROADNAMEELEMENT:
         oPath.bGoDown(teafi_tclKnot(teafi_tclToken::EN_ROADNAMEELEMENT,teafi_tclSemanticDomain::EN_SIGNPOSTDESTINATIONCATEGORY));
         break;
      case fi_tcl_e8_SignPostDestinationCategory::FI_EN_T_ROADNUMBER:
         oPath.bGoDown(teafi_tclKnot(teafi_tclToken::EN_ROADNUMBER,teafi_tclSemanticDomain::EN_SIGNPOSTDESTINATIONCATEGORY));
         break;
      case fi_tcl_e8_SignPostDestinationCategory::FI_EN_T_INTERSECTIONNAMEELEMENT:
         oPath.bGoDown(teafi_tclKnot(teafi_tclToken::EN_INTERSECTIONNAMEELEMENT,teafi_tclSemanticDomain::EN_SIGNPOSTDESTINATIONCATEGORY));
         break;
      case fi_tcl_e8_SignPostDestinationCategory::FI_EN_T_INTERSECTIONNUMBERELEMENT:
         oPath.bGoDown(teafi_tclKnot(teafi_tclToken::EN_INTERSECTIONNUMBERELEMENT,teafi_tclSemanticDomain::EN_SIGNPOSTDESTINATIONCATEGORY));
         break;
      case fi_tcl_e8_SignPostDestinationCategory::FI_EN_T_POINTOFINTERESTELEMENT:
         oPath.bGoDown(teafi_tclKnot(teafi_tclToken::EN_POINTOFINTERESTELEMENT,teafi_tclSemanticDomain::EN_SIGNPOSTDESTINATIONCATEGORY));
         break;
      case fi_tcl_e8_SignPostDestinationCategory::FI_EN_T_UNSPECIFIEDTEXT:
         oPath.bGoDown(teafi_tclKnot(teafi_tclToken::EN_UNSPECIFIEDTEXT,teafi_tclSemanticDomain::EN_SIGNPOSTDESTINATIONCATEGORY));
         break;
      case fi_tcl_e8_SignPostDestinationCategory::FI_EN_T_COMPASSDIRECTION:
         oPath.bGoDown(teafi_tclKnot(teafi_tclToken::EN_COMPASSDIRECTION,teafi_tclSemanticDomain::EN_SIGNPOSTDESTINATIONCATEGORY));
         break;
      }
   } break;
   case teafi_tclToken::EN_SIGNPOSTDESTINATION:
   {
      if (poVisitor->bDoExpand_SignPostDestination(enSemanticDomain))
      {
         oPath.bGoUp();
         oPath.bGoDown(teafi_tclKnot(teafi_tclToken::EN_END_OF_STRUCT,teafi_tclSemanticDomain::EN_UNKNOWN));
         if (9 <= u16MajorVersion)
         {
            oPath.bGoDown(teafi_tclKnot(teafi_tclToken::EN_DIRECTIONINFO,teafi_tclSemanticDomain::EN_LIST_ELEMENT,0));
            oPath.bGoDown(teafi_tclKnot(teafi_tclToken::EN_LIST,teafi_tclSemanticDomain::EN_DIRECTIONINFOLIST));
         }
         if (u16MajorVersion <= 8)
         {
            oPath.bGoDown(teafi_tclKnot(teafi_tclToken::EN_SIGNPOSTDESTDIRECTION,teafi_tclSemanticDomain::EN_SIGNPOSTDESTINATIONDIRECTION));
         }
         if (u16MajorVersion <= 8)
         {
            oPath.bGoDown(teafi_tclKnot(teafi_tclToken::EN_SIGNPOSTDESTINATIONUNION0,teafi_tclSemanticDomain::EN_SIGNPOSTDESTINATIONCATEGORY));
         }
         oPath.bGoDown(teafi_tclKnot(teafi_tclToken::EN_E8_SIGNPOSTDESTTYPE,teafi_tclSemanticDomain::EN_TYPE));
      }
      else
      {
         fi_tcl_SignPostDestination o_SignPostDestination;
         if (!bDoIt(o_SignPostDestination))
         {
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
            o_SignPostDestination.vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
            return FALSE;
         }
         else
         {
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
            o_SignPostDestination.vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
            oCallStack.bGoUp();
            oPath.bGoUp();
         }
      }
   } break;
   case teafi_tclToken::EN_REFERENCEELEMENT:
   {
      if (poVisitor->bDoExpand_ReferenceElement(enSemanticDomain))
      {
         oPath.bGoUp();
         oPath.bGoDown(teafi_tclKnot(teafi_tclToken::EN_END_OF_STRUCT,teafi_tclSemanticDomain::EN_UNKNOWN));
         oPath.bGoDown(teafi_tclKnot(teafi_tclToken::EN_U16_INDEXINREFERENCELIST,teafi_tclSemanticDomain::EN_REFLIST));
         oPath.bGoDown(teafi_tclKnot(teafi_tclToken::EN_U16_INDEXINREFERENCELIST,teafi_tclSemanticDomain::EN_BASELIST));
      }
      else
      {
         fi_tcl_ReferenceElement o_ReferenceElement;
         if (!bDoIt(o_ReferenceElement))
         {
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
            o_ReferenceElement.vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
            return FALSE;
         }
         else
         {
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
            o_ReferenceElement.vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
            oCallStack.bGoUp();
            oPath.bGoUp();
         }
      }
   } break;
   case teafi_tclToken::EN_E8_CROSSROADINFOCATEGORY:
   {
      fi_tcl_e8_CrossroadInfoCategory o_e8_CrossroadInfoCategory;
      if (!bDoIt(o_e8_CrossroadInfoCategory))
         return FALSE;
      oCallStack.bGoUp();
      oPath.bGoUp();
   } break;
   case teafi_tclToken::EN_B32_ROADPROPERTY:
   {
      fi_tcl_b32_RoadProperty o_b32_RoadProperty;
      if (!bDoIt(o_b32_RoadProperty))
         return FALSE;
      oCallStack.bGoUp();
      oPath.bGoUp();
   } break;
   case teafi_tclToken::EN_E8_NAVSTREETTYPE:
   {
      fi_tcl_e8_NavStreetType o_e8_NavStreetType;
      if (!bDoIt(o_e8_NavStreetType))
         return FALSE;
      oCallStack.bGoUp();
      oPath.bGoUp();
   } break;
   case teafi_tclToken::EN_E8_ROADNETWORKCLASS:
   {
      fi_tcl_e8_RoadNetworkClass o_e8_RoadNetworkClass;
      if (!bDoIt(o_e8_RoadNetworkClass))
         return FALSE;
      oCallStack.bGoUp();
      oPath.bGoUp();
   } break;
   case teafi_tclToken::EN_NAVONECELL:
   {
      if (poVisitor->bDoExpand_NavOneCell(enSemanticDomain))
      {
         oPath.bGoUp();
         oPath.bGoDown(teafi_tclKnot(teafi_tclToken::EN_END_OF_STRUCT,teafi_tclSemanticDomain::EN_UNKNOWN));
         oPath.bGoDown(teafi_tclKnot(teafi_tclToken::EN_U16,teafi_tclSemanticDomain::EN_CLUSTERLENGTH));
         oPath.bGoDown(teafi_tclKnot(teafi_tclToken::EN_U32,teafi_tclSemanticDomain::EN_CLUSTERFILEOFFSET));
         oPath.bGoDown(teafi_tclKnot(teafi_tclToken::EN_U16,teafi_tclSemanticDomain::EN_CLUSTERFILEID));
         oPath.bGoDown(teafi_tclKnot(teafi_tclToken::EN_E8_NAVONECELLDIRECTION,teafi_tclSemanticDomain::EN_USEDIRECTION));
         oPath.bGoDown(teafi_tclKnot(teafi_tclToken::EN_U16,teafi_tclSemanticDomain::EN_ONECELLID));
      }
      else
      {
         fi_tcl_NavOneCell o_NavOneCell;
         if (!bDoIt(o_NavOneCell))
         {
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
            o_NavOneCell.vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
            return FALSE;
         }
         else
         {
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
            o_NavOneCell.vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
            oCallStack.bGoUp();
            oPath.bGoUp();
         }
      }
   } break;
   case teafi_tclToken::EN_SIGNPOSTELEMENTUNION0:
   {
      oPath.bGoUp();
      oCallStack.bGoUp();
      fi_tcl_e8_NavOneCellCategory oDataType;
      oCallStack.bGoDown(teafi_tclKnot(teafi_tclToken::EN_E8_NAVONECELLCATEGORY,teafi_tclSemanticDomain::EN_DATA_TYPE));
      poVisitor->oIterator = oCallStack.oGetIterator();
      bDoIt(oDataType);
      oCallStack.bGoUp();
      switch (oDataType.enType)
      {
      case fi_tcl_e8_NavOneCellCategory::FI_EN_T_RESERVED:
         oPath.bGoDown(teafi_tclKnot(teafi_tclToken::EN_RESERVED,teafi_tclSemanticDomain::EN_NAVONECELLCATEGORY));
         break;
      case fi_tcl_e8_NavOneCellCategory::FI_EN_T_NAVONECELL:
         oPath.bGoDown(teafi_tclKnot(teafi_tclToken::EN_NAVONECELL,teafi_tclSemanticDomain::EN_NAVONECELLCATEGORY));
         break;
      case fi_tcl_e8_NavOneCellCategory::FI_EN_T_U16_INDEXINREFERENCELIST:
         oPath.bGoDown(teafi_tclKnot(teafi_tclToken::EN_U16_INDEXINREFERENCELIST,teafi_tclSemanticDomain::EN_NAVONECELLCATEGORY));
         break;
      }
   } break;
   case teafi_tclToken::EN_SIGNPOSTELEMENT:
   {
      if (poVisitor->bDoExpand_SignPostElement(enSemanticDomain))
      {
         oPath.bGoUp();
         oPath.bGoDown(teafi_tclKnot(teafi_tclToken::EN_END_OF_STRUCT,teafi_tclSemanticDomain::EN_UNKNOWN));
         oPath.bGoDown(teafi_tclKnot(teafi_tclToken::EN_SIGNPOSTDESTINATION,teafi_tclSemanticDomain::EN_LIST_ELEMENT,0));
         oPath.bGoDown(teafi_tclKnot(teafi_tclToken::EN_LIST,teafi_tclSemanticDomain::EN_SIGNPOSTDESTINATION));
         if (u16MajorVersion <= 8)
         {
            oPath.bGoDown(teafi_tclKnot(teafi_tclToken::EN_E8_SIGNPOSTDESTSTATUS,teafi_tclSemanticDomain::EN_STATUS));
         }
         oPath.bGoDown(teafi_tclKnot(teafi_tclToken::EN_SIGNPOSTELEMENTUNION0,teafi_tclSemanticDomain::EN_NAVONECELLCATEGORY));
      }
      else
      {
         fi_tcl_SignPostElement o_SignPostElement;
         if (!bDoIt(o_SignPostElement))
         {
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
            o_SignPostElement.vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
            return FALSE;
         }
         else
         {
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
            o_SignPostElement.vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
            oCallStack.bGoUp();
            oPath.bGoUp();
         }
      }
   } break;
   case teafi_tclToken::EN_DIRECTIONINFOLISTSET:
   {
      if (poVisitor->bDoExpand_DirectionInfoListSet(enSemanticDomain))
      {
         oPath.bGoUp();
         oPath.bGoDown(teafi_tclKnot(teafi_tclToken::EN_END_OF_STRUCT,teafi_tclSemanticDomain::EN_UNKNOWN));
         oPath.bGoDown(teafi_tclKnot(teafi_tclToken::EN_DIRECTIONINFO,teafi_tclSemanticDomain::EN_LIST_ELEMENT,0));
         oPath.bGoDown(teafi_tclKnot(teafi_tclToken::EN_LIST,teafi_tclSemanticDomain::EN_DIRECTIONINFOLIST));
         oPath.bGoDown(teafi_tclKnot(teafi_tclToken::EN_REFERENCEELEMENT,teafi_tclSemanticDomain::EN_LIST_ELEMENT,0));
         oPath.bGoDown(teafi_tclKnot(teafi_tclToken::EN_LIST,teafi_tclSemanticDomain::EN_ALTERNATIVREFLIST));
      }
      else
      {
         fi_tcl_DirectionInfoListSet o_DirectionInfoListSet;
         if (!bDoIt(o_DirectionInfoListSet))
         {
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
            o_DirectionInfoListSet.vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
            return FALSE;
         }
         else
         {
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
            o_DirectionInfoListSet.vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
            oCallStack.bGoUp();
            oPath.bGoUp();
         }
      }
   } break;
   case teafi_tclToken::EN_REFERENCEELEMENTWITHID:
   {
      if (poVisitor->bDoExpand_ReferenceElementWithID(enSemanticDomain))
      {
         oPath.bGoUp();
         oPath.bGoDown(teafi_tclKnot(teafi_tclToken::EN_END_OF_STRUCT,teafi_tclSemanticDomain::EN_UNKNOWN));
         oPath.bGoDown(teafi_tclKnot(teafi_tclToken::EN_U32,teafi_tclSemanticDomain::EN_ID));
         oPath.bGoDown(teafi_tclKnot(teafi_tclToken::EN_U16_INDEXINREFERENCELIST,teafi_tclSemanticDomain::EN_REFLIST));
         oPath.bGoDown(teafi_tclKnot(teafi_tclToken::EN_U16_INDEXINREFERENCELIST,teafi_tclSemanticDomain::EN_BASELIST));
      }
      else
      {
         fi_tcl_ReferenceElementWithID o_ReferenceElementWithID;
         if (!bDoIt(o_ReferenceElementWithID))
         {
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
            o_ReferenceElementWithID.vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
            return FALSE;
         }
         else
         {
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
            o_ReferenceElementWithID.vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
            oCallStack.bGoUp();
            oPath.bGoUp();
         }
      }
   } break;
   case teafi_tclToken::EN_STATENAMEELEMENT:
   {
      if (poVisitor->bDoExpand_StateNameElement(enSemanticDomain))
      {
         oPath.bGoUp();
         oPath.bGoDown(teafi_tclKnot(teafi_tclToken::EN_END_OF_STRUCT,teafi_tclSemanticDomain::EN_UNKNOWN));
         if (11 <= u16MajorVersion)
         {
            oPath.bGoDown(teafi_tclKnot(teafi_tclToken::EN_U32,teafi_tclSemanticDomain::EN_STATECODE));
         }
         if (u16MajorVersion <= 10)
         {
            oPath.bGoDown(teafi_tclKnot(teafi_tclToken::EN_U16,teafi_tclSemanticDomain::EN_STATECODE_OLD));
         }
         oPath.bGoDown(teafi_tclKnot(teafi_tclToken::EN_MULTILANGUAGESTRING,teafi_tclSemanticDomain::EN_STATENAME));
      }
      else
      {
         fi_tcl_StateNameElement o_StateNameElement;
         if (!bDoIt(o_StateNameElement))
         {
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
            o_StateNameElement.vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
            return FALSE;
         }
         else
         {
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
            o_StateNameElement.vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
            oCallStack.bGoUp();
            oPath.bGoUp();
         }
      }
   } break;
   case teafi_tclToken::EN_COUNTYNAMEELEMENT:
   {
      if (poVisitor->bDoExpand_CountyNameElement(enSemanticDomain))
      {
         oPath.bGoUp();
         oPath.bGoDown(teafi_tclKnot(teafi_tclToken::EN_END_OF_STRUCT,teafi_tclSemanticDomain::EN_UNKNOWN));
         oPath.bGoDown(teafi_tclKnot(teafi_tclToken::EN_MULTILANGUAGESTRING,teafi_tclSemanticDomain::EN_COUNTYNAME));
      }
      else
      {
         fi_tcl_CountyNameElement o_CountyNameElement;
         if (!bDoIt(o_CountyNameElement))
         {
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
            o_CountyNameElement.vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
            return FALSE;
         }
         else
         {
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
            o_CountyNameElement.vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
            oCallStack.bGoUp();
            oPath.bGoUp();
         }
      }
   } break;
   case teafi_tclToken::EN_CITYDISTRICTNAMEELEMENT:
   {
      if (poVisitor->bDoExpand_CityDistrictNameElement(enSemanticDomain))
      {
         oPath.bGoUp();
         oPath.bGoDown(teafi_tclKnot(teafi_tclToken::EN_END_OF_STRUCT,teafi_tclSemanticDomain::EN_UNKNOWN));
         oPath.bGoDown(teafi_tclKnot(teafi_tclToken::EN_U32,teafi_tclSemanticDomain::EN_POPULATION));
         oPath.bGoDown(teafi_tclKnot(teafi_tclToken::EN_S8,teafi_tclSemanticDomain::EN_PRIORITY));
         oPath.bGoDown(teafi_tclKnot(teafi_tclToken::EN_MULTILANGUAGESTRING,teafi_tclSemanticDomain::EN_NAME));
      }
      else
      {
         fi_tcl_CityDistrictNameElement o_CityDistrictNameElement;
         if (!bDoIt(o_CityDistrictNameElement))
         {
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
            o_CityDistrictNameElement.vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
            return FALSE;
         }
         else
         {
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
            o_CityDistrictNameElement.vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
            oCallStack.bGoUp();
            oPath.bGoUp();
         }
      }
   } break;
   case teafi_tclToken::EN_BUILDUPAREANAMEELEMENT:
   {
      if (poVisitor->bDoExpand_BuildUpAreaNameElement(enSemanticDomain))
      {
         oPath.bGoUp();
         oPath.bGoDown(teafi_tclKnot(teafi_tclToken::EN_END_OF_STRUCT,teafi_tclSemanticDomain::EN_UNKNOWN));
         oPath.bGoDown(teafi_tclKnot(teafi_tclToken::EN_U32,teafi_tclSemanticDomain::EN_POPULATION));
         oPath.bGoDown(teafi_tclKnot(teafi_tclToken::EN_S8,teafi_tclSemanticDomain::EN_PRIORITY));
         oPath.bGoDown(teafi_tclKnot(teafi_tclToken::EN_MULTILANGUAGESTRING,teafi_tclSemanticDomain::EN_NAME));
      }
      else
      {
         fi_tcl_BuildUpAreaNameElement o_BuildUpAreaNameElement;
         if (!bDoIt(o_BuildUpAreaNameElement))
         {
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
            o_BuildUpAreaNameElement.vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
            return FALSE;
         }
         else
         {
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
            o_BuildUpAreaNameElement.vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
            oCallStack.bGoUp();
            oPath.bGoUp();
         }
      }
   } break;
   case teafi_tclToken::EN_B8_ROADNUMBERSTATUS:
   {
      fi_tcl_b8_RoadNumberStatus o_b8_RoadNumberStatus;
      if (!bDoIt(o_b8_RoadNumberStatus))
         return FALSE;
      oCallStack.bGoUp();
      oPath.bGoUp();
   } break;
   case teafi_tclToken::EN_REQUIREDTAXDISC:
   {
      if (poVisitor->bDoExpand_RequiredTaxDisc(enSemanticDomain))
      {
         oPath.bGoUp();
         oPath.bGoDown(teafi_tclKnot(teafi_tclToken::EN_END_OF_STRUCT,teafi_tclSemanticDomain::EN_UNKNOWN));
         oPath.bGoDown(teafi_tclKnot(teafi_tclToken::EN_MULTILANGUAGESTRING,teafi_tclSemanticDomain::EN_DESCRIPTION));
         oPath.bGoDown(teafi_tclKnot(teafi_tclToken::EN_MULTILANGUAGESTRING,teafi_tclSemanticDomain::EN_REQUIREDPERMISSIONNAME));
         if (9 <= u16MajorVersion)
         {
            oPath.bGoDown(teafi_tclKnot(teafi_tclToken::EN_U16,teafi_tclSemanticDomain::EN_REGION));
         }
         oPath.bGoDown(teafi_tclKnot(teafi_tclToken::EN_E16_ISOCOUNTRYCODE,teafi_tclSemanticDomain::EN_COUNTRYCODE));
         oPath.bGoDown(teafi_tclKnot(teafi_tclToken::EN_S32,teafi_tclSemanticDomain::EN_REQUIREDPERMISSIONID));
      }
      else
      {
         fi_tcl_RequiredTaxDisc o_RequiredTaxDisc;
         if (!bDoIt(o_RequiredTaxDisc))
         {
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
            o_RequiredTaxDisc.vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
            return FALSE;
         }
         else
         {
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
            o_RequiredTaxDisc.vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
            oCallStack.bGoUp();
            oPath.bGoUp();
         }
      }
   } break;
   case teafi_tclToken::EN_E8_REQUIREDPERMISSIONTYPE:
   {
      fi_tcl_e8_RequiredPermissionType o_e8_RequiredPermissionType;
      if (!bDoIt(o_e8_RequiredPermissionType))
         return FALSE;
      oCallStack.bGoUp();
      oPath.bGoUp();
   } break;
   case teafi_tclToken::EN_E8_REQUIREDPERMISSION:
   {
      fi_tcl_e8_RequiredPermission o_e8_RequiredPermission;
      if (!bDoIt(o_e8_RequiredPermission))
         return FALSE;
      oCallStack.bGoUp();
      oPath.bGoUp();
   } break;
   case teafi_tclToken::EN_GENERICREQUIREDPERMISSION:
   {
      if (poVisitor->bDoExpand_GenericRequiredPermission(enSemanticDomain))
      {
         oPath.bGoUp();
         oPath.bGoDown(teafi_tclKnot(teafi_tclToken::EN_END_OF_STRUCT,teafi_tclSemanticDomain::EN_UNKNOWN));
         oPath.bGoDown(teafi_tclKnot(teafi_tclToken::EN_E8_REQUIREDPERMISSIONTYPE,teafi_tclSemanticDomain::EN_REQUIREDPERMISSIONTYPE));
         oPath.bGoDown(teafi_tclKnot(teafi_tclToken::EN_MULTILANGUAGESTRING,teafi_tclSemanticDomain::EN_DESCRIPTION));
         oPath.bGoDown(teafi_tclKnot(teafi_tclToken::EN_MULTILANGUAGESTRING,teafi_tclSemanticDomain::EN_REQUIREDPERMISSIONNAME));
         oPath.bGoDown(teafi_tclKnot(teafi_tclToken::EN_U16,teafi_tclSemanticDomain::EN_REGIONID));
         oPath.bGoDown(teafi_tclKnot(teafi_tclToken::EN_E16_ISOCOUNTRYCODE,teafi_tclSemanticDomain::EN_COUNTRYCODE));
         oPath.bGoDown(teafi_tclKnot(teafi_tclToken::EN_S32,teafi_tclSemanticDomain::EN_REQUIREDPERMISSIONID));
      }
      else
      {
         fi_tcl_GenericRequiredPermission o_GenericRequiredPermission;
         if (!bDoIt(o_GenericRequiredPermission))
         {
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
            o_GenericRequiredPermission.vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
            return FALSE;
         }
         else
         {
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
            o_GenericRequiredPermission.vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
            oCallStack.bGoUp();
            oPath.bGoUp();
         }
      }
   } break;
   case teafi_tclToken::EN_REQUIREDPERMISSIONUNION0:
   {
      oPath.bGoUp();
      oCallStack.bGoUp();
      fi_tcl_e8_RequiredPermission oDataType;
      oCallStack.bGoDown(teafi_tclKnot(teafi_tclToken::EN_E8_REQUIREDPERMISSION,teafi_tclSemanticDomain::EN_DATA_TYPE));
      poVisitor->oIterator = oCallStack.oGetIterator();
      bDoIt(oDataType);
      oCallStack.bGoUp();
      if ((oDataType.enType == fi_tcl_e8_RequiredPermission::FI_EN_T_GENERICREQUIREDPERMISSION) &&
          !(13 <= u16MajorVersion))
      {
         oDataType.enType = fi_tcl_e8_RequiredPermission::FI_EN_T_RESERVED;
      }
      if ((oDataType.enType == fi_tcl_e8_RequiredPermission::FI_EN_T_REQUIREDTAXDISC) &&
          !(u16MajorVersion <= 12))
      {
         oDataType.enType = fi_tcl_e8_RequiredPermission::FI_EN_T_RESERVED;
      }
      switch (oDataType.enType)
      {
      case fi_tcl_e8_RequiredPermission::FI_EN_T_RESERVED:
         oPath.bGoDown(teafi_tclKnot(teafi_tclToken::EN_RESERVED,teafi_tclSemanticDomain::EN_CATEGORY));
         break;
      case fi_tcl_e8_RequiredPermission::FI_EN_T_REQUIREDTAXDISC:
         oPath.bGoDown(teafi_tclKnot(teafi_tclToken::EN_REQUIREDTAXDISC,teafi_tclSemanticDomain::EN_CATEGORY));
         break;
      case fi_tcl_e8_RequiredPermission::FI_EN_T_GENERICREQUIREDPERMISSION:
         oPath.bGoDown(teafi_tclKnot(teafi_tclToken::EN_GENERICREQUIREDPERMISSION,teafi_tclSemanticDomain::EN_CATEGORY));
         break;
      }
   } break;
   case teafi_tclToken::EN_REQUIREDPERMISSION:
   {
      if (poVisitor->bDoExpand_RequiredPermission(enSemanticDomain))
      {
         oPath.bGoUp();
         oPath.bGoDown(teafi_tclKnot(teafi_tclToken::EN_END_OF_STRUCT,teafi_tclSemanticDomain::EN_UNKNOWN));
         oPath.bGoDown(teafi_tclKnot(teafi_tclToken::EN_REQUIREDPERMISSIONUNION0,teafi_tclSemanticDomain::EN_CATEGORY));
      }
      else
      {
         fi_tcl_RequiredPermission o_RequiredPermission;
         if (!bDoIt(o_RequiredPermission))
         {
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
            o_RequiredPermission.vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
            return FALSE;
         }
         else
         {
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
            o_RequiredPermission.vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
            oCallStack.bGoUp();
            oPath.bGoUp();
         }
      }
   } break;
   case teafi_tclToken::EN_COUNTRYNAMEELEMENT:
   {
      if (poVisitor->bDoExpand_CountryNameElement(enSemanticDomain))
      {
         oPath.bGoUp();
         oPath.bGoDown(teafi_tclKnot(teafi_tclToken::EN_END_OF_STRUCT,teafi_tclSemanticDomain::EN_UNKNOWN));
         oPath.bGoDown(teafi_tclKnot(teafi_tclToken::EN_MULTILANGUAGESTRING,teafi_tclSemanticDomain::EN_NAME));
         oPath.bGoDown(teafi_tclKnot(teafi_tclToken::EN_E16_ISOCOUNTRYCODE,teafi_tclSemanticDomain::EN_CODE));
      }
      else
      {
         fi_tcl_CountryNameElement o_CountryNameElement;
         if (!bDoIt(o_CountryNameElement))
         {
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
            o_CountryNameElement.vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
            return FALSE;
         }
         else
         {
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
            o_CountryNameElement.vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
            oCallStack.bGoUp();
            oPath.bGoUp();
         }
      }
   } break;
   case teafi_tclToken::EN_STATENAMELISTSET:
   {
      if (poVisitor->bDoExpand_StateNameListSet(enSemanticDomain))
      {
         oPath.bGoUp();
         oPath.bGoDown(teafi_tclKnot(teafi_tclToken::EN_END_OF_STRUCT,teafi_tclSemanticDomain::EN_UNKNOWN));
         oPath.bGoDown(teafi_tclKnot(teafi_tclToken::EN_STATENAMEELEMENT,teafi_tclSemanticDomain::EN_LIST_ELEMENT,0));
         oPath.bGoDown(teafi_tclKnot(teafi_tclToken::EN_LIST,teafi_tclSemanticDomain::EN_STATENAMEREFLIST));
         oPath.bGoDown(teafi_tclKnot(teafi_tclToken::EN_U16_INDEXINREFERENCELIST,teafi_tclSemanticDomain::EN_LIST_ELEMENT,0));
         oPath.bGoDown(teafi_tclKnot(teafi_tclToken::EN_LIST,teafi_tclSemanticDomain::EN_ELEMENTREFLIST));
      }
      else
      {
         fi_tcl_StateNameListSet o_StateNameListSet;
         if (!bDoIt(o_StateNameListSet))
         {
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
            o_StateNameListSet.vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
            return FALSE;
         }
         else
         {
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
            o_StateNameListSet.vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
            oCallStack.bGoUp();
            oPath.bGoUp();
         }
      }
   } break;
   case teafi_tclToken::EN_COUNTYNAMELISTSET:
   {
      if (poVisitor->bDoExpand_CountyNameListSet(enSemanticDomain))
      {
         oPath.bGoUp();
         oPath.bGoDown(teafi_tclKnot(teafi_tclToken::EN_END_OF_STRUCT,teafi_tclSemanticDomain::EN_UNKNOWN));
         oPath.bGoDown(teafi_tclKnot(teafi_tclToken::EN_MULTILANGUAGESTRING,teafi_tclSemanticDomain::EN_LIST_ELEMENT,0));
         oPath.bGoDown(teafi_tclKnot(teafi_tclToken::EN_LIST,teafi_tclSemanticDomain::EN_COUNTYNAMEREFLIST));
         oPath.bGoDown(teafi_tclKnot(teafi_tclToken::EN_U16_INDEXINREFERENCELIST,teafi_tclSemanticDomain::EN_LIST_ELEMENT,0));
         oPath.bGoDown(teafi_tclKnot(teafi_tclToken::EN_LIST,teafi_tclSemanticDomain::EN_ELEMENTREFLIST));
      }
      else
      {
         fi_tcl_CountyNameListSet o_CountyNameListSet;
         if (!bDoIt(o_CountyNameListSet))
         {
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
            o_CountyNameListSet.vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
            return FALSE;
         }
         else
         {
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
            o_CountyNameListSet.vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
            oCallStack.bGoUp();
            oPath.bGoUp();
         }
      }
   } break;
   case teafi_tclToken::EN_CITYNAMEELEMENT:
   {
      if (poVisitor->bDoExpand_CityNameElement(enSemanticDomain))
      {
         oPath.bGoUp();
         oPath.bGoDown(teafi_tclKnot(teafi_tclToken::EN_END_OF_STRUCT,teafi_tclSemanticDomain::EN_UNKNOWN));
         oPath.bGoDown(teafi_tclKnot(teafi_tclToken::EN_U32,teafi_tclSemanticDomain::EN_POPULATION));
         oPath.bGoDown(teafi_tclKnot(teafi_tclToken::EN_S8,teafi_tclSemanticDomain::EN_PRIORITY));
         oPath.bGoDown(teafi_tclKnot(teafi_tclToken::EN_MULTILANGUAGESTRING,teafi_tclSemanticDomain::EN_NAME));
      }
      else
      {
         fi_tcl_CityNameElement o_CityNameElement;
         if (!bDoIt(o_CityNameElement))
         {
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
            o_CityNameElement.vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
            return FALSE;
         }
         else
         {
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
            o_CityNameElement.vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
            oCallStack.bGoUp();
            oPath.bGoUp();
         }
      }
   } break;
   case teafi_tclToken::EN_INDEXINREFERENCELIST:
   {
      if (poVisitor->bDoExpand_IndexInReferenceList(enSemanticDomain))
      {
         oPath.bGoUp();
         oPath.bGoDown(teafi_tclKnot(teafi_tclToken::EN_END_OF_STRUCT,teafi_tclSemanticDomain::EN_UNKNOWN));
         oPath.bGoDown(teafi_tclKnot(teafi_tclToken::EN_BOOL,teafi_tclSemanticDomain::EN_DESCRIPTIONONNEXTNODE));
         oPath.bGoDown(teafi_tclKnot(teafi_tclToken::EN_U16_INDEXINREFERENCELIST,teafi_tclSemanticDomain::EN_REFELEMENT));
      }
      else
      {
         fi_tcl_IndexInReferenceList o_IndexInReferenceList;
         if (!bDoIt(o_IndexInReferenceList))
         {
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
            o_IndexInReferenceList.vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
            return FALSE;
         }
         else
         {
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
            o_IndexInReferenceList.vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
            oCallStack.bGoUp();
            oPath.bGoUp();
         }
      }
   } break;
   case teafi_tclToken::EN_BUILDUPAREANAMELISTSET:
   {
      if (poVisitor->bDoExpand_BuildUpAreaNameListSet(enSemanticDomain))
      {
         oPath.bGoUp();
         oPath.bGoDown(teafi_tclKnot(teafi_tclToken::EN_END_OF_STRUCT,teafi_tclSemanticDomain::EN_UNKNOWN));
         oPath.bGoDown(teafi_tclKnot(teafi_tclToken::EN_BUILDUPAREANAMEELEMENT,teafi_tclSemanticDomain::EN_LIST_ELEMENT,0));
         oPath.bGoDown(teafi_tclKnot(teafi_tclToken::EN_LIST,teafi_tclSemanticDomain::EN_BUILDUPAREANAMEREFLIST));
         oPath.bGoDown(teafi_tclKnot(teafi_tclToken::EN_INDEXINREFERENCELIST,teafi_tclSemanticDomain::EN_LIST_ELEMENT,0));
         oPath.bGoDown(teafi_tclKnot(teafi_tclToken::EN_LIST,teafi_tclSemanticDomain::EN_ELEMENTINREFLIST));
      }
      else
      {
         fi_tcl_BuildUpAreaNameListSet o_BuildUpAreaNameListSet;
         if (!bDoIt(o_BuildUpAreaNameListSet))
         {
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
            o_BuildUpAreaNameListSet.vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
            return FALSE;
         }
         else
         {
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
            o_BuildUpAreaNameListSet.vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
            oCallStack.bGoUp();
            oPath.bGoUp();
         }
      }
   } break;
   case teafi_tclToken::EN_ROADNAMELISTSET:
   {
      if (poVisitor->bDoExpand_RoadNameListSet(enSemanticDomain))
      {
         oPath.bGoUp();
         oPath.bGoDown(teafi_tclKnot(teafi_tclToken::EN_END_OF_STRUCT,teafi_tclSemanticDomain::EN_UNKNOWN));
         oPath.bGoDown(teafi_tclKnot(teafi_tclToken::EN_MULTILANGUAGESTRING,teafi_tclSemanticDomain::EN_LIST_ELEMENT,0));
         oPath.bGoDown(teafi_tclKnot(teafi_tclToken::EN_LIST,teafi_tclSemanticDomain::EN_ROADNAMEREFLIST));
         oPath.bGoDown(teafi_tclKnot(teafi_tclToken::EN_REFERENCEELEMENT,teafi_tclSemanticDomain::EN_LIST_ELEMENT,0));
         oPath.bGoDown(teafi_tclKnot(teafi_tclToken::EN_LIST,teafi_tclSemanticDomain::EN_ALTERNATIVREFLIST));
         oPath.bGoDown(teafi_tclKnot(teafi_tclToken::EN_U16_INDEXINREFERENCELIST,teafi_tclSemanticDomain::EN_LIST_ELEMENT,0));
         oPath.bGoDown(teafi_tclKnot(teafi_tclToken::EN_LIST,teafi_tclSemanticDomain::EN_ELEMENTREFLIST));
      }
      else
      {
         fi_tcl_RoadNameListSet o_RoadNameListSet;
         if (!bDoIt(o_RoadNameListSet))
         {
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
            o_RoadNameListSet.vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
            return FALSE;
         }
         else
         {
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
            o_RoadNameListSet.vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
            oCallStack.bGoUp();
            oPath.bGoUp();
         }
      }
   } break;
   case teafi_tclToken::EN_COMPASSDIRECTION:
   {
      if (poVisitor->bDoExpand_CompassDirection(enSemanticDomain))
      {
         oPath.bGoUp();
         oPath.bGoDown(teafi_tclKnot(teafi_tclToken::EN_END_OF_STRUCT,teafi_tclSemanticDomain::EN_UNKNOWN));
         oPath.bGoDown(teafi_tclKnot(teafi_tclToken::EN_MULTILANGUAGESTRING,teafi_tclSemanticDomain::EN_DIRECTIONDESC));
         oPath.bGoDown(teafi_tclKnot(teafi_tclToken::EN_U8_DIRECTIONABSOLUTE,teafi_tclSemanticDomain::EN_DIRECTION));
         if (u16MajorVersion <= 8)
         {
            oPath.bGoDown(teafi_tclKnot(teafi_tclToken::EN_BOOL,teafi_tclSemanticDomain::EN_DIRECTIONISVALID));
         }
      }
      else
      {
         fi_tcl_CompassDirection o_CompassDirection;
         if (!bDoIt(o_CompassDirection))
         {
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
            o_CompassDirection.vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
            return FALSE;
         }
         else
         {
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
            o_CompassDirection.vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
            oCallStack.bGoUp();
            oPath.bGoUp();
         }
      }
   } break;
   case teafi_tclToken::EN_REQUIREDPERMISSIONLISTSET:
   {
      if (poVisitor->bDoExpand_RequiredPermissionListSet(enSemanticDomain))
      {
         oPath.bGoUp();
         oPath.bGoDown(teafi_tclKnot(teafi_tclToken::EN_END_OF_STRUCT,teafi_tclSemanticDomain::EN_UNKNOWN));
         oPath.bGoDown(teafi_tclKnot(teafi_tclToken::EN_REQUIREDPERMISSION,teafi_tclSemanticDomain::EN_LIST_ELEMENT,0));
         oPath.bGoDown(teafi_tclKnot(teafi_tclToken::EN_LIST,teafi_tclSemanticDomain::EN_REQUIREDPERMISSIONREFLIST));
         if (11 <= u16MajorVersion)
         {
            oPath.bGoDown(teafi_tclKnot(teafi_tclToken::EN_REFERENCEELEMENTWITHID,teafi_tclSemanticDomain::EN_LIST_ELEMENT,0));
            oPath.bGoDown(teafi_tclKnot(teafi_tclToken::EN_LIST,teafi_tclSemanticDomain::EN_ALTERNATIVREFIDLIST));
         }
         if (u16MajorVersion <= 10)
         {
            oPath.bGoDown(teafi_tclKnot(teafi_tclToken::EN_REFERENCEELEMENT,teafi_tclSemanticDomain::EN_LIST_ELEMENT,0));
            oPath.bGoDown(teafi_tclKnot(teafi_tclToken::EN_LIST,teafi_tclSemanticDomain::EN_ALTERNATIVREFLIST));
         }
      }
      else
      {
         fi_tcl_RequiredPermissionListSet o_RequiredPermissionListSet;
         if (!bDoIt(o_RequiredPermissionListSet))
         {
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
            o_RequiredPermissionListSet.vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
            return FALSE;
         }
         else
         {
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
            o_RequiredPermissionListSet.vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
            oCallStack.bGoUp();
            oPath.bGoUp();
         }
      }
   } break;
   case teafi_tclToken::EN_E8_INTERSECTIONTYPE:
   {
      fi_tcl_e8_IntersectionType o_e8_IntersectionType;
      if (!bDoIt(o_e8_IntersectionType))
         return FALSE;
      oCallStack.bGoUp();
      oPath.bGoUp();
   } break;
   case teafi_tclToken::EN_TIMEZONELISTSET:
   {
      if (poVisitor->bDoExpand_TimeZoneListSet(enSemanticDomain))
      {
         oPath.bGoUp();
         oPath.bGoDown(teafi_tclKnot(teafi_tclToken::EN_END_OF_STRUCT,teafi_tclSemanticDomain::EN_UNKNOWN));
         oPath.bGoDown(teafi_tclKnot(teafi_tclToken::EN_TIMEZONEELEMENT,teafi_tclSemanticDomain::EN_LIST_ELEMENT,0));
         oPath.bGoDown(teafi_tclKnot(teafi_tclToken::EN_LIST,teafi_tclSemanticDomain::EN_TIMEZONELIST));
         oPath.bGoDown(teafi_tclKnot(teafi_tclToken::EN_U16_INDEXINREFERENCELIST,teafi_tclSemanticDomain::EN_LIST_ELEMENT,0));
         oPath.bGoDown(teafi_tclKnot(teafi_tclToken::EN_LIST,teafi_tclSemanticDomain::EN_ELEMENTREFLIST));
      }
      else
      {
         fi_tcl_TimeZoneListSet o_TimeZoneListSet;
         if (!bDoIt(o_TimeZoneListSet))
         {
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
            o_TimeZoneListSet.vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
            return FALSE;
         }
         else
         {
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
            o_TimeZoneListSet.vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
            oCallStack.bGoUp();
            oPath.bGoUp();
         }
      }
   } break;
   case teafi_tclToken::EN_INTERSECTIONNAMEELEMENT:
   {
      if (poVisitor->bDoExpand_IntersectionNameElement(enSemanticDomain))
      {
         oPath.bGoUp();
         oPath.bGoDown(teafi_tclKnot(teafi_tclToken::EN_END_OF_STRUCT,teafi_tclSemanticDomain::EN_UNKNOWN));
         oPath.bGoDown(teafi_tclKnot(teafi_tclToken::EN_STRING,teafi_tclSemanticDomain::EN_INTERSECTIONSUFFIX));
         oPath.bGoDown(teafi_tclKnot(teafi_tclToken::EN_MULTILANGUAGESTRING,teafi_tclSemanticDomain::EN_INTERSECTIONNAME));
         oPath.bGoDown(teafi_tclKnot(teafi_tclToken::EN_STRING,teafi_tclSemanticDomain::EN_INTERSECTIONPREFIX));
         oPath.bGoDown(teafi_tclKnot(teafi_tclToken::EN_E8_INTERSECTIONTYPE,teafi_tclSemanticDomain::EN_INTERSECTIONTYPE));
      }
      else
      {
         fi_tcl_IntersectionNameElement o_IntersectionNameElement;
         if (!bDoIt(o_IntersectionNameElement))
         {
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
            o_IntersectionNameElement.vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
            return FALSE;
         }
         else
         {
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
            o_IntersectionNameElement.vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
            oCallStack.bGoUp();
            oPath.bGoUp();
         }
      }
   } break;
   case teafi_tclToken::EN_ROADNAMEELEMENT:
   {
      if (poVisitor->bDoExpand_RoadNameElement(enSemanticDomain))
      {
         oPath.bGoUp();
         oPath.bGoDown(teafi_tclKnot(teafi_tclToken::EN_END_OF_STRUCT,teafi_tclSemanticDomain::EN_UNKNOWN));
         oPath.bGoDown(teafi_tclKnot(teafi_tclToken::EN_MULTILANGUAGESTRING,teafi_tclSemanticDomain::EN_ROADNAME));
      }
      else
      {
         fi_tcl_RoadNameElement o_RoadNameElement;
         if (!bDoIt(o_RoadNameElement))
         {
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
            o_RoadNameElement.vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
            return FALSE;
         }
         else
         {
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
            o_RoadNameElement.vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
            oCallStack.bGoUp();
            oPath.bGoUp();
         }
      }
   } break;
   case teafi_tclToken::EN_ROADNUMBER:
   {
      if (poVisitor->bDoExpand_RoadNumber(enSemanticDomain))
      {
         oPath.bGoUp();
         oPath.bGoDown(teafi_tclKnot(teafi_tclToken::EN_END_OF_STRUCT,teafi_tclSemanticDomain::EN_UNKNOWN));
         oPath.bGoDown(teafi_tclKnot(teafi_tclToken::EN_COMPASSDIRECTION,teafi_tclSemanticDomain::EN_COMPASSDIRECTION));
         oPath.bGoDown(teafi_tclKnot(teafi_tclToken::EN_STRING,teafi_tclSemanticDomain::EN_NUMBERSUFFIX));
         oPath.bGoDown(teafi_tclKnot(teafi_tclToken::EN_STRING,teafi_tclSemanticDomain::EN_ROADNUMBER));
         oPath.bGoDown(teafi_tclKnot(teafi_tclToken::EN_STRING,teafi_tclSemanticDomain::EN_NUMBERPREFIX));
         oPath.bGoDown(teafi_tclKnot(teafi_tclToken::EN_U8,teafi_tclSemanticDomain::EN_NUMBERHIERARCHY));
         if (11 <= u16MajorVersion)
         {
            oPath.bGoDown(teafi_tclKnot(teafi_tclToken::EN_U32,teafi_tclSemanticDomain::EN_STATECODE));
         }
         if (u16MajorVersion <= 10)
         {
            oPath.bGoDown(teafi_tclKnot(teafi_tclToken::EN_U16,teafi_tclSemanticDomain::EN_STATE));
         }
         oPath.bGoDown(teafi_tclKnot(teafi_tclToken::EN_E16_ISOCOUNTRYCODE,teafi_tclSemanticDomain::EN_COUNTRYCODE));
         oPath.bGoDown(teafi_tclKnot(teafi_tclToken::EN_B8_ROADNUMBERSTATUS,teafi_tclSemanticDomain::EN_STATUS));
      }
      else
      {
         fi_tcl_RoadNumber o_RoadNumber;
         if (!bDoIt(o_RoadNumber))
         {
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
            o_RoadNumber.vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
            return FALSE;
         }
         else
         {
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
            o_RoadNumber.vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
            oCallStack.bGoUp();
            oPath.bGoUp();
         }
      }
   } break;
   case teafi_tclToken::EN_INTERSECTIONNUMBERELEMENT:
   {
      if (poVisitor->bDoExpand_IntersectionNumberElement(enSemanticDomain))
      {
         oPath.bGoUp();
         oPath.bGoDown(teafi_tclKnot(teafi_tclToken::EN_END_OF_STRUCT,teafi_tclSemanticDomain::EN_UNKNOWN));
         oPath.bGoDown(teafi_tclKnot(teafi_tclToken::EN_ROADNUMBER,teafi_tclSemanticDomain::EN_INTERSECTIONNUMBER));
         oPath.bGoDown(teafi_tclKnot(teafi_tclToken::EN_E8_INTERSECTIONTYPE,teafi_tclSemanticDomain::EN_INTERSECTIONTYPE));
      }
      else
      {
         fi_tcl_IntersectionNumberElement o_IntersectionNumberElement;
         if (!bDoIt(o_IntersectionNumberElement))
         {
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
            o_IntersectionNumberElement.vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
            return FALSE;
         }
         else
         {
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
            o_IntersectionNumberElement.vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
            oCallStack.bGoUp();
            oPath.bGoUp();
         }
      }
   } break;
   case teafi_tclToken::EN_B8_PRESENCEINDICATOR:
   {
      fi_tcl_b8_PresenceIndicator o_b8_PresenceIndicator;
      if (!bDoIt(o_b8_PresenceIndicator))
         return FALSE;
      oCallStack.bGoUp();
      oPath.bGoUp();
   } break;
   case teafi_tclToken::EN_COUNTRYNAMELISTSET:
   {
      if (poVisitor->bDoExpand_CountryNameListSet(enSemanticDomain))
      {
         oPath.bGoUp();
         oPath.bGoDown(teafi_tclKnot(teafi_tclToken::EN_END_OF_STRUCT,teafi_tclSemanticDomain::EN_UNKNOWN));
         oPath.bGoDown(teafi_tclKnot(teafi_tclToken::EN_COUNTRYNAMEELEMENT,teafi_tclSemanticDomain::EN_LIST_ELEMENT,0));
         oPath.bGoDown(teafi_tclKnot(teafi_tclToken::EN_LIST,teafi_tclSemanticDomain::EN_COUNTRYNAMEREFLIST));
         oPath.bGoDown(teafi_tclKnot(teafi_tclToken::EN_U16_INDEXINREFERENCELIST,teafi_tclSemanticDomain::EN_LIST_ELEMENT,0));
         oPath.bGoDown(teafi_tclKnot(teafi_tclToken::EN_LIST,teafi_tclSemanticDomain::EN_ELEMENTREFLIST));
      }
      else
      {
         fi_tcl_CountryNameListSet o_CountryNameListSet;
         if (!bDoIt(o_CountryNameListSet))
         {
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
            o_CountryNameListSet.vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
            return FALSE;
         }
         else
         {
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
            o_CountryNameListSet.vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
            oCallStack.bGoUp();
            oPath.bGoUp();
         }
      }
   } break;
   case teafi_tclToken::EN_CITYNAMELISTSET:
   {
      if (poVisitor->bDoExpand_CityNameListSet(enSemanticDomain))
      {
         oPath.bGoUp();
         oPath.bGoDown(teafi_tclKnot(teafi_tclToken::EN_END_OF_STRUCT,teafi_tclSemanticDomain::EN_UNKNOWN));
         oPath.bGoDown(teafi_tclKnot(teafi_tclToken::EN_CITYNAMEELEMENT,teafi_tclSemanticDomain::EN_LIST_ELEMENT,0));
         oPath.bGoDown(teafi_tclKnot(teafi_tclToken::EN_LIST,teafi_tclSemanticDomain::EN_CITYNAMEREFLIST));
         oPath.bGoDown(teafi_tclKnot(teafi_tclToken::EN_INDEXINREFERENCELIST,teafi_tclSemanticDomain::EN_LIST_ELEMENT,0));
         oPath.bGoDown(teafi_tclKnot(teafi_tclToken::EN_LIST,teafi_tclSemanticDomain::EN_ELEMENTINREFLIST));
      }
      else
      {
         fi_tcl_CityNameListSet o_CityNameListSet;
         if (!bDoIt(o_CityNameListSet))
         {
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
            o_CityNameListSet.vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
            return FALSE;
         }
         else
         {
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
            o_CityNameListSet.vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
            oCallStack.bGoUp();
            oPath.bGoUp();
         }
      }
   } break;
   case teafi_tclToken::EN_SIGNPOSTLISTSET:
   {
      if (poVisitor->bDoExpand_SignPostListSet(enSemanticDomain))
      {
         oPath.bGoUp();
         oPath.bGoDown(teafi_tclKnot(teafi_tclToken::EN_END_OF_STRUCT,teafi_tclSemanticDomain::EN_UNKNOWN));
         oPath.bGoDown(teafi_tclKnot(teafi_tclToken::EN_SIGNPOSTELEMENT,teafi_tclSemanticDomain::EN_LIST_ELEMENT,0));
         oPath.bGoDown(teafi_tclKnot(teafi_tclToken::EN_LIST,teafi_tclSemanticDomain::EN_SIGNPOSTELEMENT));
         oPath.bGoDown(teafi_tclKnot(teafi_tclToken::EN_REFERENCEELEMENT,teafi_tclSemanticDomain::EN_LIST_ELEMENT,0));
         oPath.bGoDown(teafi_tclKnot(teafi_tclToken::EN_LIST,teafi_tclSemanticDomain::EN_ALTERNATIVREFLIST));
      }
      else
      {
         fi_tcl_SignPostListSet o_SignPostListSet;
         if (!bDoIt(o_SignPostListSet))
         {
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
            o_SignPostListSet.vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
            return FALSE;
         }
         else
         {
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
            o_SignPostListSet.vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
            oCallStack.bGoUp();
            oPath.bGoUp();
         }
      }
   } break;
   case teafi_tclToken::EN_ROADNUMBERLISTSET:
   {
      if (poVisitor->bDoExpand_RoadNumberListSet(enSemanticDomain))
      {
         oPath.bGoUp();
         oPath.bGoDown(teafi_tclKnot(teafi_tclToken::EN_END_OF_STRUCT,teafi_tclSemanticDomain::EN_UNKNOWN));
         oPath.bGoDown(teafi_tclKnot(teafi_tclToken::EN_ROADNUMBER,teafi_tclSemanticDomain::EN_LIST_ELEMENT,0));
         oPath.bGoDown(teafi_tclKnot(teafi_tclToken::EN_LIST,teafi_tclSemanticDomain::EN_ROADNUMBERREFLIST));
         oPath.bGoDown(teafi_tclKnot(teafi_tclToken::EN_REFERENCEELEMENT,teafi_tclSemanticDomain::EN_LIST_ELEMENT,0));
         oPath.bGoDown(teafi_tclKnot(teafi_tclToken::EN_LIST,teafi_tclSemanticDomain::EN_ALTERNATIVREFLIST));
         oPath.bGoDown(teafi_tclKnot(teafi_tclToken::EN_U16_INDEXINREFERENCELIST,teafi_tclSemanticDomain::EN_LIST_ELEMENT,0));
         oPath.bGoDown(teafi_tclKnot(teafi_tclToken::EN_LIST,teafi_tclSemanticDomain::EN_ELEMENTREFLIST));
      }
      else
      {
         fi_tcl_RoadNumberListSet o_RoadNumberListSet;
         if (!bDoIt(o_RoadNumberListSet))
         {
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
            o_RoadNumberListSet.vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
            return FALSE;
         }
         else
         {
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
            o_RoadNumberListSet.vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
            oCallStack.bGoUp();
            oPath.bGoUp();
         }
      }
   } break;
   case teafi_tclToken::EN_B16_ROADATTRIBUTE:
   {
      fi_tcl_b16_RoadAttribute o_b16_RoadAttribute;
      if (!bDoIt(o_b16_RoadAttribute))
         return FALSE;
      oCallStack.bGoUp();
      oPath.bGoUp();
   } break;
   case teafi_tclToken::EN_NAVPOSONECELLPROPERTY:
   {
      if (poVisitor->bDoExpand_NavPosOneCellProperty(enSemanticDomain))
      {
         oPath.bGoUp();
         oPath.bGoDown(teafi_tclKnot(teafi_tclToken::EN_END_OF_STRUCT,teafi_tclSemanticDomain::EN_UNKNOWN));
         if (11 <= u16MajorVersion)
         {
            oPath.bGoDown(teafi_tclKnot(teafi_tclToken::EN_U32,teafi_tclSemanticDomain::EN_STATECODE));
         }
         oPath.bGoDown(teafi_tclKnot(teafi_tclToken::EN_B32_ROADPROPERTY,teafi_tclSemanticDomain::EN_ONECELLSTATUS));
         if (11 <= u16MajorVersion)
         {
            oPath.bGoDown(teafi_tclKnot(teafi_tclToken::EN_E8_ROADNETWORKCLASS,teafi_tclSemanticDomain::EN_ROADNETWORKCLASS));
         }
         oPath.bGoDown(teafi_tclKnot(teafi_tclToken::EN_E8_NAVSTREETTYPE,teafi_tclSemanticDomain::EN_ROADTYPE));
         oPath.bGoDown(teafi_tclKnot(teafi_tclToken::EN_E8_ROADCLASSCODE,teafi_tclSemanticDomain::EN_ROADCLASS));
         oPath.bGoDown(teafi_tclKnot(teafi_tclToken::EN_S32_EMU,teafi_tclSemanticDomain::EN_ONECELLLENGTH));
         oPath.bGoDown(teafi_tclKnot(teafi_tclToken::EN_E16_ISOCOUNTRYCODE,teafi_tclSemanticDomain::EN_COUNTRYCODE));
      }
      else
      {
         fi_tcl_NavPosOneCellProperty o_NavPosOneCellProperty;
         if (!bDoIt(o_NavPosOneCellProperty))
         {
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
            o_NavPosOneCellProperty.vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
            return FALSE;
         }
         else
         {
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
            o_NavPosOneCellProperty.vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
            oCallStack.bGoUp();
            oPath.bGoUp();
         }
      }
   } break;
   case teafi_tclToken::EN_ROADATTRIBUTES:
   {
      if (poVisitor->bDoExpand_RoadAttributes(enSemanticDomain))
      {
         oPath.bGoUp();
         oPath.bGoDown(teafi_tclKnot(teafi_tclToken::EN_END_OF_STRUCT,teafi_tclSemanticDomain::EN_UNKNOWN));
         if (9 <= u16MajorVersion)
         {
            oPath.bGoDown(teafi_tclKnot(teafi_tclToken::EN_E8_ROADNETWORKCLASS,teafi_tclSemanticDomain::EN_ROADNETWORKCLASS));
         }
         oPath.bGoDown(teafi_tclKnot(teafi_tclToken::EN_E8_NAVSTREETTYPE,teafi_tclSemanticDomain::EN_ROADTYPE));
         oPath.bGoDown(teafi_tclKnot(teafi_tclToken::EN_B32_ROADPROPERTY,teafi_tclSemanticDomain::EN_ROADPROPERTY));
         oPath.bGoDown(teafi_tclKnot(teafi_tclToken::EN_E8_ROADCLASSCODE,teafi_tclSemanticDomain::EN_ROADCLASS));
      }
      else
      {
         fi_tcl_RoadAttributes o_RoadAttributes;
         if (!bDoIt(o_RoadAttributes))
         {
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
            o_RoadAttributes.vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
            return FALSE;
         }
         else
         {
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
            o_RoadAttributes.vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
            oCallStack.bGoUp();
            oPath.bGoUp();
         }
      }
   } break;
   case teafi_tclToken::EN_E8_EXTRADESCELEMENTTYPE:
   {
      fi_tcl_e8_ExtraDescElementType o_e8_ExtraDescElementType;
      if (!bDoIt(o_e8_ExtraDescElementType))
         return FALSE;
      oCallStack.bGoUp();
      oPath.bGoUp();
   } break;
   case teafi_tclToken::EN_EXTRADESCELEMENT:
   {
      if (poVisitor->bDoExpand_ExtraDescElement(enSemanticDomain))
      {
         oPath.bGoUp();
         oPath.bGoDown(teafi_tclKnot(teafi_tclToken::EN_END_OF_STRUCT,teafi_tclSemanticDomain::EN_UNKNOWN));
         oPath.bGoDown(teafi_tclKnot(teafi_tclToken::EN_MULTILANGUAGESTRING,teafi_tclSemanticDomain::EN_LONGDESCRIPTION));
         oPath.bGoDown(teafi_tclKnot(teafi_tclToken::EN_MULTILANGUAGESTRING,teafi_tclSemanticDomain::EN_SHORTDESCRIPTION));
         oPath.bGoDown(teafi_tclKnot(teafi_tclToken::EN_E8_EXTRADESCELEMENTTYPE,teafi_tclSemanticDomain::EN_TYPE));
      }
      else
      {
         fi_tcl_ExtraDescElement o_ExtraDescElement;
         if (!bDoIt(o_ExtraDescElement))
         {
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
            o_ExtraDescElement.vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
            return FALSE;
         }
         else
         {
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
            o_ExtraDescElement.vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
            oCallStack.bGoUp();
            oPath.bGoUp();
         }
      }
   } break;
   case teafi_tclToken::EN_EXTRADESCLISTSET:
   {
      if (poVisitor->bDoExpand_ExtraDescListSet(enSemanticDomain))
      {
         oPath.bGoUp();
         oPath.bGoDown(teafi_tclKnot(teafi_tclToken::EN_END_OF_STRUCT,teafi_tclSemanticDomain::EN_UNKNOWN));
         oPath.bGoDown(teafi_tclKnot(teafi_tclToken::EN_EXTRADESCELEMENT,teafi_tclSemanticDomain::EN_LIST_ELEMENT,0));
         oPath.bGoDown(teafi_tclKnot(teafi_tclToken::EN_LIST,teafi_tclSemanticDomain::EN_EXTRADESCREFLIST));
         oPath.bGoDown(teafi_tclKnot(teafi_tclToken::EN_REFERENCEELEMENT,teafi_tclSemanticDomain::EN_LIST_ELEMENT,0));
         oPath.bGoDown(teafi_tclKnot(teafi_tclToken::EN_LIST,teafi_tclSemanticDomain::EN_ALTERNATIVREFLIST));
      }
      else
      {
         fi_tcl_ExtraDescListSet o_ExtraDescListSet;
         if (!bDoIt(o_ExtraDescListSet))
         {
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
            o_ExtraDescListSet.vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
            return FALSE;
         }
         else
         {
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
            o_ExtraDescListSet.vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
            oCallStack.bGoUp();
            oPath.bGoUp();
         }
      }
   } break;
   case teafi_tclToken::EN_B32_DATAPROPERTIES:
   {
      fi_tcl_b32_DataProperties o_b32_DataProperties;
      if (!bDoIt(o_b32_DataProperties))
         return FALSE;
      oCallStack.bGoUp();
      oPath.bGoUp();
   } break;
   case teafi_tclToken::EN_DATADESCELEMENT:
   {
      if (poVisitor->bDoExpand_DataDescElement(enSemanticDomain))
      {
         oPath.bGoUp();
         oPath.bGoDown(teafi_tclKnot(teafi_tclToken::EN_END_OF_STRUCT,teafi_tclSemanticDomain::EN_UNKNOWN));
         oPath.bGoDown(teafi_tclKnot(teafi_tclToken::EN_U32,teafi_tclSemanticDomain::EN_CANDYPRODUCTCODE));
         oPath.bGoDown(teafi_tclKnot(teafi_tclToken::EN_B32_DATAPROPERTIES,teafi_tclSemanticDomain::EN_RNWDATAPROPERTIES));
      }
      else
      {
         fi_tcl_DataDescElement o_DataDescElement;
         if (!bDoIt(o_DataDescElement))
         {
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
            o_DataDescElement.vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
            return FALSE;
         }
         else
         {
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
            o_DataDescElement.vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
            oCallStack.bGoUp();
            oPath.bGoUp();
         }
      }
   } break;
   case teafi_tclToken::EN_DATADESCLISTSET:
   {
      if (poVisitor->bDoExpand_DataDescListSet(enSemanticDomain))
      {
         oPath.bGoUp();
         oPath.bGoDown(teafi_tclKnot(teafi_tclToken::EN_END_OF_STRUCT,teafi_tclSemanticDomain::EN_UNKNOWN));
         oPath.bGoDown(teafi_tclKnot(teafi_tclToken::EN_DATADESCELEMENT,teafi_tclSemanticDomain::EN_LIST_ELEMENT,0));
         oPath.bGoDown(teafi_tclKnot(teafi_tclToken::EN_LIST,teafi_tclSemanticDomain::EN_DATADESCREFLIST));
         oPath.bGoDown(teafi_tclKnot(teafi_tclToken::EN_REFERENCEELEMENT,teafi_tclSemanticDomain::EN_LIST_ELEMENT,0));
         oPath.bGoDown(teafi_tclKnot(teafi_tclToken::EN_LIST,teafi_tclSemanticDomain::EN_ALTERNATIVREFLIST));
         oPath.bGoDown(teafi_tclKnot(teafi_tclToken::EN_U16_INDEXINREFERENCELIST,teafi_tclSemanticDomain::EN_LIST_ELEMENT,0));
         oPath.bGoDown(teafi_tclKnot(teafi_tclToken::EN_LIST,teafi_tclSemanticDomain::EN_ELEMENTREFLIST));
      }
      else
      {
         fi_tcl_DataDescListSet o_DataDescListSet;
         if (!bDoIt(o_DataDescListSet))
         {
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
            o_DataDescListSet.vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
            return FALSE;
         }
         else
         {
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
            o_DataDescListSet.vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
            oCallStack.bGoUp();
            oPath.bGoUp();
         }
      }
   } break;
   case teafi_tclToken::EN_B8_CROSSROADPROPERTIES:
   {
      fi_tcl_b8_CrossroadProperties o_b8_CrossroadProperties;
      if (!bDoIt(o_b8_CrossroadProperties))
         return FALSE;
      oCallStack.bGoUp();
      oPath.bGoUp();
   } break;
   case teafi_tclToken::EN_CROSSROADDESC:
   {
      if (poVisitor->bDoExpand_CrossroadDesc(enSemanticDomain))
      {
         oPath.bGoUp();
         oPath.bGoDown(teafi_tclKnot(teafi_tclToken::EN_END_OF_STRUCT,teafi_tclSemanticDomain::EN_UNKNOWN));
         if (9 <= u16MajorVersion)
         {
            oPath.bGoDown(teafi_tclKnot(teafi_tclToken::EN_U16_INDEXINREFERENCELIST,teafi_tclSemanticDomain::EN_INDEXOFTWINELEMENT));
         }
         if (9 <= u16MajorVersion)
         {
            oPath.bGoDown(teafi_tclKnot(teafi_tclToken::EN_ROADATTRIBUTES,teafi_tclSemanticDomain::EN_CROSSROADATTRIBUTES));
         }
         oPath.bGoDown(teafi_tclKnot(teafi_tclToken::EN_U16_INDEXINREFERENCELIST,teafi_tclSemanticDomain::EN_CROSSROADINFOREFELEMENT));
         oPath.bGoDown(teafi_tclKnot(teafi_tclToken::EN_B8_CROSSROADPROPERTIES,teafi_tclSemanticDomain::EN_CROSSROADPROPERTY));
         if (9 <= u16MajorVersion)
         {
            oPath.bGoDown(teafi_tclKnot(teafi_tclToken::EN_U8_DIRECTIONABSOLUTE,teafi_tclSemanticDomain::EN_DIRECTIONOFCONNECTEDELEMENT));
         }
         oPath.bGoDown(teafi_tclKnot(teafi_tclToken::EN_U8_DIRECTIONABSOLUTE,teafi_tclSemanticDomain::EN_DIRECTION));
         oPath.bGoDown(teafi_tclKnot(teafi_tclToken::EN_BOOL,teafi_tclSemanticDomain::EN_ISDIRECTIONVALID));
      }
      else
      {
         fi_tcl_CrossroadDesc o_CrossroadDesc;
         if (!bDoIt(o_CrossroadDesc))
         {
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
            o_CrossroadDesc.vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
            return FALSE;
         }
         else
         {
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
            o_CrossroadDesc.vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
            oCallStack.bGoUp();
            oPath.bGoUp();
         }
      }
   } break;
   case teafi_tclToken::EN_CROSSROADINFOUNION0:
   {
      oPath.bGoUp();
      oCallStack.bGoUp();
      fi_tcl_e8_CrossroadInfoCategory oDataType;
      oCallStack.bGoDown(teafi_tclKnot(teafi_tclToken::EN_E8_CROSSROADINFOCATEGORY,teafi_tclSemanticDomain::EN_DATA_TYPE));
      poVisitor->oIterator = oCallStack.oGetIterator();
      bDoIt(oDataType);
      oCallStack.bGoUp();
      switch (oDataType.enType)
      {
      case fi_tcl_e8_CrossroadInfoCategory::FI_EN_T_RESERVED:
         oPath.bGoDown(teafi_tclKnot(teafi_tclToken::EN_RESERVED,teafi_tclSemanticDomain::EN_CROSSROADINFO));
         break;
      case fi_tcl_e8_CrossroadInfoCategory::FI_EN_T_ROADNAMELISTSET:
         oPath.bGoDown(teafi_tclKnot(teafi_tclToken::EN_ROADNAMELISTSET,teafi_tclSemanticDomain::EN_CROSSROADINFO));
         break;
      case fi_tcl_e8_CrossroadInfoCategory::FI_EN_T_ROADNUMBERLISTSET:
         oPath.bGoDown(teafi_tclKnot(teafi_tclToken::EN_ROADNUMBERLISTSET,teafi_tclSemanticDomain::EN_CROSSROADINFO));
         break;
      }
   } break;
   case teafi_tclToken::EN_CROSSROADINFO:
   {
      if (poVisitor->bDoExpand_CrossroadInfo(enSemanticDomain))
      {
         oPath.bGoUp();
         oPath.bGoDown(teafi_tclKnot(teafi_tclToken::EN_END_OF_STRUCT,teafi_tclSemanticDomain::EN_UNKNOWN));
         oPath.bGoDown(teafi_tclKnot(teafi_tclToken::EN_CROSSROADINFOUNION0,teafi_tclSemanticDomain::EN_CROSSROADINFO));
      }
      else
      {
         fi_tcl_CrossroadInfo o_CrossroadInfo;
         if (!bDoIt(o_CrossroadInfo))
         {
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
            o_CrossroadInfo.vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
            return FALSE;
         }
         else
         {
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
            o_CrossroadInfo.vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
            oCallStack.bGoUp();
            oPath.bGoUp();
         }
      }
   } break;
   case teafi_tclToken::EN_INTERSECTIONDENOTATION:
   {
      if (poVisitor->bDoExpand_IntersectionDenotation(enSemanticDomain))
      {
         oPath.bGoUp();
         oPath.bGoDown(teafi_tclKnot(teafi_tclToken::EN_END_OF_STRUCT,teafi_tclSemanticDomain::EN_UNKNOWN));
         oPath.bGoDown(teafi_tclKnot(teafi_tclToken::EN_STRING,teafi_tclSemanticDomain::EN_INTERSECTIONNAMESUFFIX));
         oPath.bGoDown(teafi_tclKnot(teafi_tclToken::EN_MULTILANGUAGESTRING,teafi_tclSemanticDomain::EN_INTERSECTIONNAMEBODY));
         oPath.bGoDown(teafi_tclKnot(teafi_tclToken::EN_STRING,teafi_tclSemanticDomain::EN_INTERSECTIONNAMEPREFIX));
         oPath.bGoDown(teafi_tclKnot(teafi_tclToken::EN_ROADNUMBER,teafi_tclSemanticDomain::EN_INTERSECTIONNUMBER));
      }
      else
      {
         fi_tcl_IntersectionDenotation o_IntersectionDenotation;
         if (!bDoIt(o_IntersectionDenotation))
         {
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
            o_IntersectionDenotation.vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
            return FALSE;
         }
         else
         {
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
            o_IntersectionDenotation.vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
            oCallStack.bGoUp();
            oPath.bGoUp();
         }
      }
   } break;
   case teafi_tclToken::EN_INTERSECTIONPATHDENOTATION:
   {
      if (poVisitor->bDoExpand_IntersectionPathDenotation(enSemanticDomain))
      {
         oPath.bGoUp();
         oPath.bGoDown(teafi_tclKnot(teafi_tclToken::EN_END_OF_STRUCT,teafi_tclSemanticDomain::EN_UNKNOWN));
         oPath.bGoDown(teafi_tclKnot(teafi_tclToken::EN_INTERSECTIONDENOTATION,teafi_tclSemanticDomain::EN_INTERSECTIONDENOTATION));
         oPath.bGoDown(teafi_tclKnot(teafi_tclToken::EN_U32,teafi_tclSemanticDomain::EN_EXITMASK));
         oPath.bGoDown(teafi_tclKnot(teafi_tclToken::EN_U32,teafi_tclSemanticDomain::EN_ENTRANCEMASK));
      }
      else
      {
         fi_tcl_IntersectionPathDenotation o_IntersectionPathDenotation;
         if (!bDoIt(o_IntersectionPathDenotation))
         {
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
            o_IntersectionPathDenotation.vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
            return FALSE;
         }
         else
         {
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
            o_IntersectionPathDenotation.vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
            oCallStack.bGoUp();
            oPath.bGoUp();
         }
      }
   } break;
   case teafi_tclToken::EN_INTERSECTIONPATHDESC:
   {
      if (poVisitor->bDoExpand_IntersectionPathDesc(enSemanticDomain))
      {
         oPath.bGoUp();
         oPath.bGoDown(teafi_tclKnot(teafi_tclToken::EN_END_OF_STRUCT,teafi_tclSemanticDomain::EN_UNKNOWN));
         oPath.bGoDown(teafi_tclKnot(teafi_tclToken::EN_CROSSROADDESC,teafi_tclSemanticDomain::EN_LIST_ELEMENT,0));
         oPath.bGoDown(teafi_tclKnot(teafi_tclToken::EN_LIST,teafi_tclSemanticDomain::EN_CROSSROADLIST));
         if (9 <= u16MajorVersion)
         {
            oPath.bGoDown(teafi_tclKnot(teafi_tclToken::EN_POSITIONWGS84,teafi_tclSemanticDomain::EN_INTERSECTIONCENTERCOORDINATES));
         }
         if (9 <= u16MajorVersion)
         {
            oPath.bGoDown(teafi_tclKnot(teafi_tclToken::EN_S32_EMU,teafi_tclSemanticDomain::EN_INTERSECTIONDIAMETER));
         }
         oPath.bGoDown(teafi_tclKnot(teafi_tclToken::EN_INTERSECTIONPATHDENOTATION,teafi_tclSemanticDomain::EN_LIST_ELEMENT,0));
         oPath.bGoDown(teafi_tclKnot(teafi_tclToken::EN_LIST,teafi_tclSemanticDomain::EN_INTERSECTIONDENOTATIONLIST));
         oPath.bGoDown(teafi_tclKnot(teafi_tclToken::EN_E8_INTERSECTIONTYPE,teafi_tclSemanticDomain::EN_INTERSECTIONTYPE));
      }
      else
      {
         fi_tcl_IntersectionPathDesc o_IntersectionPathDesc;
         if (!bDoIt(o_IntersectionPathDesc))
         {
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
            o_IntersectionPathDesc.vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
            return FALSE;
         }
         else
         {
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
            o_IntersectionPathDesc.vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
            oCallStack.bGoUp();
            oPath.bGoUp();
         }
      }
   } break;
   case teafi_tclToken::EN_NAVINTERSECTIONLISTSET:
   {
      if (poVisitor->bDoExpand_NavIntersectionListSet(enSemanticDomain))
      {
         oPath.bGoUp();
         oPath.bGoDown(teafi_tclKnot(teafi_tclToken::EN_END_OF_STRUCT,teafi_tclSemanticDomain::EN_UNKNOWN));
         oPath.bGoDown(teafi_tclKnot(teafi_tclToken::EN_CROSSROADINFO,teafi_tclSemanticDomain::EN_LIST_ELEMENT,0));
         oPath.bGoDown(teafi_tclKnot(teafi_tclToken::EN_LIST,teafi_tclSemanticDomain::EN_CROSSROADINFOLIST));
         oPath.bGoDown(teafi_tclKnot(teafi_tclToken::EN_NAVPLAINPATHLISTSET,teafi_tclSemanticDomain::EN_CROSSROADINFOELEMENTREFLIST));
         oPath.bGoDown(teafi_tclKnot(teafi_tclToken::EN_INTERSECTIONPATHDESC,teafi_tclSemanticDomain::EN_LIST_ELEMENT,0));
         oPath.bGoDown(teafi_tclKnot(teafi_tclToken::EN_LIST,teafi_tclSemanticDomain::EN_INTERSECTIONPATHREFLIST));
         oPath.bGoDown(teafi_tclKnot(teafi_tclToken::EN_INDEXINREFERENCELIST,teafi_tclSemanticDomain::EN_LIST_ELEMENT,0));
         oPath.bGoDown(teafi_tclKnot(teafi_tclToken::EN_LIST,teafi_tclSemanticDomain::EN_ELEMENTINREFLIST));
      }
      else
      {
         fi_tcl_NavIntersectionListSet o_NavIntersectionListSet;
         if (!bDoIt(o_NavIntersectionListSet))
         {
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
            o_NavIntersectionListSet.vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
            return FALSE;
         }
         else
         {
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
            o_NavIntersectionListSet.vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
            oCallStack.bGoUp();
            oPath.bGoUp();
         }
      }
   } break;
   case teafi_tclToken::EN_E8_BASETRAFFICSIGNCATEGORY:
   {
      fi_tcl_e8_BaseTrafficSignCategory o_e8_BaseTrafficSignCategory;
      if (!bDoIt(o_e8_BaseTrafficSignCategory))
         return FALSE;
      oCallStack.bGoUp();
      oPath.bGoUp();
   } break;
   case teafi_tclToken::EN_E8_SPEEDSIGN:
   {
      fi_tcl_e8_SpeedSign o_e8_SpeedSign;
      if (!bDoIt(o_e8_SpeedSign))
         return FALSE;
      oCallStack.bGoUp();
      oPath.bGoUp();
   } break;
   case teafi_tclToken::EN_E16_WARNINGSIGN:
   {
      fi_tcl_e16_WarningSign o_e16_WarningSign;
      if (!bDoIt(o_e16_WarningSign))
         return FALSE;
      oCallStack.bGoUp();
      oPath.bGoUp();
   } break;
   case teafi_tclToken::EN_E16_REGULATORYSIGN:
   {
      fi_tcl_e16_RegulatorySign o_e16_RegulatorySign;
      if (!bDoIt(o_e16_RegulatorySign))
         return FALSE;
      oCallStack.bGoUp();
      oPath.bGoUp();
   } break;
   case teafi_tclToken::EN_E16_ADDITIONALTRAFFICSIGN:
   {
      fi_tcl_e16_AdditionalTrafficSign o_e16_AdditionalTrafficSign;
      if (!bDoIt(o_e16_AdditionalTrafficSign))
         return FALSE;
      oCallStack.bGoUp();
      oPath.bGoUp();
   } break;
   case teafi_tclToken::EN_TIMEDEPENDENTSTRING:
   {
      fi_tcl_TimeDependentString o_TimeDependentString;
      if (!bDoIt(o_TimeDependentString))
         return FALSE;
      oCallStack.bGoUp();
      oPath.bGoUp();
   } break;
   case teafi_tclToken::EN_B8_LANEDEPENDENTVALIDITY:
   {
      fi_tcl_b8_LaneDependentValidity o_b8_LaneDependentValidity;
      if (!bDoIt(o_b8_LaneDependentValidity))
         return FALSE;
      oCallStack.bGoUp();
      oPath.bGoUp();
   } break;
   case teafi_tclToken::EN_E8_TRAFFICSIGNQUANTIFIER:
   {
      fi_tcl_e8_TrafficSignQuantifier o_e8_TrafficSignQuantifier;
      if (!bDoIt(o_e8_TrafficSignQuantifier))
         return FALSE;
      oCallStack.bGoUp();
      oPath.bGoUp();
   } break;
   case teafi_tclToken::EN_ADDITIONALTRAFFICSIGNUNION0:
   {
      oPath.bGoUp();
      oCallStack.bGoUp();
      fi_tcl_e8_TrafficSignQuantifier oDataType;
      oCallStack.bGoDown(teafi_tclKnot(teafi_tclToken::EN_E8_TRAFFICSIGNQUANTIFIER,teafi_tclSemanticDomain::EN_DATA_TYPE));
      poVisitor->oIterator = oCallStack.oGetIterator();
      bDoIt(oDataType);
      oCallStack.bGoUp();
      if ((oDataType.enType == fi_tcl_e8_TrafficSignQuantifier::FI_EN_T_S32_POUND) &&
          !(7 <= u16MajorVersion))
      {
         oDataType.enType = fi_tcl_e8_TrafficSignQuantifier::FI_EN_T_RESERVED;
      }
      if ((oDataType.enType == fi_tcl_e8_TrafficSignQuantifier::FI_EN_T_S32_KILOGRAM) &&
          !(7 <= u16MajorVersion))
      {
         oDataType.enType = fi_tcl_e8_TrafficSignQuantifier::FI_EN_T_RESERVED;
      }
      if ((oDataType.enType == fi_tcl_e8_TrafficSignQuantifier::FI_EN_T_S32_INCH) &&
          !(7 <= u16MajorVersion))
      {
         oDataType.enType = fi_tcl_e8_TrafficSignQuantifier::FI_EN_T_RESERVED;
      }
      if ((oDataType.enType == fi_tcl_e8_TrafficSignQuantifier::FI_EN_T_S32_CENTIMETER) &&
          !(7 <= u16MajorVersion))
      {
         oDataType.enType = fi_tcl_e8_TrafficSignQuantifier::FI_EN_T_RESERVED;
      }
      switch (oDataType.enType)
      {
      case fi_tcl_e8_TrafficSignQuantifier::FI_EN_T_RESERVED:
         oPath.bGoDown(teafi_tclKnot(teafi_tclToken::EN_RESERVED,teafi_tclSemanticDomain::EN_QUANTIFIEROFADDSIGN));
         break;
      case fi_tcl_e8_TrafficSignQuantifier::FI_EN_T_S16_KMPERHOUR:
         oPath.bGoDown(teafi_tclKnot(teafi_tclToken::EN_S16_KMPERHOUR,teafi_tclSemanticDomain::EN_QUANTIFIEROFADDSIGN));
         break;
      case fi_tcl_e8_TrafficSignQuantifier::FI_EN_T_S16_MILESPERHOUR:
         oPath.bGoDown(teafi_tclKnot(teafi_tclToken::EN_S16_MILESPERHOUR,teafi_tclSemanticDomain::EN_QUANTIFIEROFADDSIGN));
         break;
      case fi_tcl_e8_TrafficSignQuantifier::FI_EN_TSTRING:
         oPath.bGoDown(teafi_tclKnot(teafi_tclToken::EN_STRING,teafi_tclSemanticDomain::EN_QUANTIFIEROFADDSIGN));
         break;
      case fi_tcl_e8_TrafficSignQuantifier::FI_EN_T_U8_PERCENT:
         oPath.bGoDown(teafi_tclKnot(teafi_tclToken::EN_U8_PERCENT,teafi_tclSemanticDomain::EN_QUANTIFIEROFADDSIGN));
         break;
      case fi_tcl_e8_TrafficSignQuantifier::FI_EN_T_B8_LANEDEPENDENTVALIDITY:
         oPath.bGoDown(teafi_tclKnot(teafi_tclToken::EN_B8_LANEDEPENDENTVALIDITY,teafi_tclSemanticDomain::EN_QUANTIFIEROFADDSIGN));
         break;
      case fi_tcl_e8_TrafficSignQuantifier::FI_EN_T_TIMEDEPENDENTSTRING:
         oPath.bGoDown(teafi_tclKnot(teafi_tclToken::EN_TIMEDEPENDENTSTRING,teafi_tclSemanticDomain::EN_QUANTIFIEROFADDSIGN));
         break;
      case fi_tcl_e8_TrafficSignQuantifier::FI_EN_T_S32_METER:
         oPath.bGoDown(teafi_tclKnot(teafi_tclToken::EN_S32_METER,teafi_tclSemanticDomain::EN_QUANTIFIEROFADDSIGN));
         break;
      case fi_tcl_e8_TrafficSignQuantifier::FI_EN_T_S32_YARDS:
         oPath.bGoDown(teafi_tclKnot(teafi_tclToken::EN_S32_YARDS,teafi_tclSemanticDomain::EN_QUANTIFIEROFADDSIGN));
         break;
      case fi_tcl_e8_TrafficSignQuantifier::FI_EN_TMULTILANGUAGESTRING:
         oPath.bGoDown(teafi_tclKnot(teafi_tclToken::EN_MULTILANGUAGESTRING,teafi_tclSemanticDomain::EN_QUANTIFIEROFADDSIGN));
         break;
      case fi_tcl_e8_TrafficSignQuantifier::FI_EN_T_S32_CENTIMETER:
         oPath.bGoDown(teafi_tclKnot(teafi_tclToken::EN_S32_CENTIMETER,teafi_tclSemanticDomain::EN_QUANTIFIEROFADDSIGN));
         break;
      case fi_tcl_e8_TrafficSignQuantifier::FI_EN_T_S32_INCH:
         oPath.bGoDown(teafi_tclKnot(teafi_tclToken::EN_S32_INCH,teafi_tclSemanticDomain::EN_QUANTIFIEROFADDSIGN));
         break;
      case fi_tcl_e8_TrafficSignQuantifier::FI_EN_T_S32_KILOGRAM:
         oPath.bGoDown(teafi_tclKnot(teafi_tclToken::EN_S32_KILOGRAM,teafi_tclSemanticDomain::EN_QUANTIFIEROFADDSIGN));
         break;
      case fi_tcl_e8_TrafficSignQuantifier::FI_EN_T_S32_POUND:
         oPath.bGoDown(teafi_tclKnot(teafi_tclToken::EN_S32_POUND,teafi_tclSemanticDomain::EN_QUANTIFIEROFADDSIGN));
         break;
      }
   } break;
   case teafi_tclToken::EN_ADDITIONALTRAFFICSIGN:
   {
      if (poVisitor->bDoExpand_AdditionalTrafficSign(enSemanticDomain))
      {
         oPath.bGoUp();
         oPath.bGoDown(teafi_tclKnot(teafi_tclToken::EN_END_OF_STRUCT,teafi_tclSemanticDomain::EN_UNKNOWN));
         oPath.bGoDown(teafi_tclKnot(teafi_tclToken::EN_ADDITIONALTRAFFICSIGNUNION0,teafi_tclSemanticDomain::EN_QUANTIFIEROFADDSIGN));
         oPath.bGoDown(teafi_tclKnot(teafi_tclToken::EN_E16_ADDITIONALTRAFFICSIGN,teafi_tclSemanticDomain::EN_ADDITIONALSIGN));
      }
      else
      {
         fi_tcl_AdditionalTrafficSign o_AdditionalTrafficSign;
         if (!bDoIt(o_AdditionalTrafficSign))
         {
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
            o_AdditionalTrafficSign.vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
            return FALSE;
         }
         else
         {
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
            o_AdditionalTrafficSign.vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
            oCallStack.bGoUp();
            oPath.bGoUp();
         }
      }
   } break;
   case teafi_tclToken::EN_TRAFFICSIGNELEMENTUNION0:
   {
      oPath.bGoUp();
      oCallStack.bGoUp();
      fi_tcl_e8_BaseTrafficSignCategory oDataType;
      oCallStack.bGoDown(teafi_tclKnot(teafi_tclToken::EN_E8_BASETRAFFICSIGNCATEGORY,teafi_tclSemanticDomain::EN_DATA_TYPE));
      poVisitor->oIterator = oCallStack.oGetIterator();
      bDoIt(oDataType);
      oCallStack.bGoUp();
      if ((oDataType.enType == fi_tcl_e8_BaseTrafficSignCategory::FI_EN_T_E16_REGULATORYSIGN) &&
          !(7 <= u16MajorVersion))
      {
         oDataType.enType = fi_tcl_e8_BaseTrafficSignCategory::FI_EN_T_RESERVED;
      }
      switch (oDataType.enType)
      {
      case fi_tcl_e8_BaseTrafficSignCategory::FI_EN_T_RESERVED:
         oPath.bGoDown(teafi_tclKnot(teafi_tclToken::EN_RESERVED,teafi_tclSemanticDomain::EN_BASESIGNUNION));
         break;
      case fi_tcl_e8_BaseTrafficSignCategory::FI_EN_T_E8_SPEEDSIGN:
         oPath.bGoDown(teafi_tclKnot(teafi_tclToken::EN_E8_SPEEDSIGN,teafi_tclSemanticDomain::EN_BASESIGNUNION));
         break;
      case fi_tcl_e8_BaseTrafficSignCategory::FI_EN_T_E16_WARNINGSIGN:
         oPath.bGoDown(teafi_tclKnot(teafi_tclToken::EN_E16_WARNINGSIGN,teafi_tclSemanticDomain::EN_BASESIGNUNION));
         break;
      case fi_tcl_e8_BaseTrafficSignCategory::FI_EN_T_E16_REGULATORYSIGN:
         oPath.bGoDown(teafi_tclKnot(teafi_tclToken::EN_E16_REGULATORYSIGN,teafi_tclSemanticDomain::EN_BASESIGNUNION));
         break;
      }
   } break;
   case teafi_tclToken::EN_TRAFFICSIGNELEMENTUNION1:
   {
      oPath.bGoUp();
      oCallStack.bGoUp();
      fi_tcl_e8_TrafficSignQuantifier oDataType;
      oCallStack.bGoDown(teafi_tclKnot(teafi_tclToken::EN_E8_TRAFFICSIGNQUANTIFIER,teafi_tclSemanticDomain::EN_DATA_TYPE));
      poVisitor->oIterator = oCallStack.oGetIterator();
      bDoIt(oDataType);
      oCallStack.bGoUp();
      if ((oDataType.enType == fi_tcl_e8_TrafficSignQuantifier::FI_EN_T_S32_POUND) &&
          !(7 <= u16MajorVersion))
      {
         oDataType.enType = fi_tcl_e8_TrafficSignQuantifier::FI_EN_T_RESERVED;
      }
      if ((oDataType.enType == fi_tcl_e8_TrafficSignQuantifier::FI_EN_T_S32_KILOGRAM) &&
          !(7 <= u16MajorVersion))
      {
         oDataType.enType = fi_tcl_e8_TrafficSignQuantifier::FI_EN_T_RESERVED;
      }
      if ((oDataType.enType == fi_tcl_e8_TrafficSignQuantifier::FI_EN_T_S32_INCH) &&
          !(7 <= u16MajorVersion))
      {
         oDataType.enType = fi_tcl_e8_TrafficSignQuantifier::FI_EN_T_RESERVED;
      }
      if ((oDataType.enType == fi_tcl_e8_TrafficSignQuantifier::FI_EN_T_S32_CENTIMETER) &&
          !(7 <= u16MajorVersion))
      {
         oDataType.enType = fi_tcl_e8_TrafficSignQuantifier::FI_EN_T_RESERVED;
      }
      switch (oDataType.enType)
      {
      case fi_tcl_e8_TrafficSignQuantifier::FI_EN_T_RESERVED:
         oPath.bGoDown(teafi_tclKnot(teafi_tclToken::EN_RESERVED,teafi_tclSemanticDomain::EN_QUANTIFIEROFBASESIGN));
         break;
      case fi_tcl_e8_TrafficSignQuantifier::FI_EN_T_S16_KMPERHOUR:
         oPath.bGoDown(teafi_tclKnot(teafi_tclToken::EN_S16_KMPERHOUR,teafi_tclSemanticDomain::EN_QUANTIFIEROFBASESIGN));
         break;
      case fi_tcl_e8_TrafficSignQuantifier::FI_EN_T_S16_MILESPERHOUR:
         oPath.bGoDown(teafi_tclKnot(teafi_tclToken::EN_S16_MILESPERHOUR,teafi_tclSemanticDomain::EN_QUANTIFIEROFBASESIGN));
         break;
      case fi_tcl_e8_TrafficSignQuantifier::FI_EN_TSTRING:
         oPath.bGoDown(teafi_tclKnot(teafi_tclToken::EN_STRING,teafi_tclSemanticDomain::EN_QUANTIFIEROFBASESIGN));
         break;
      case fi_tcl_e8_TrafficSignQuantifier::FI_EN_T_U8_PERCENT:
         oPath.bGoDown(teafi_tclKnot(teafi_tclToken::EN_U8_PERCENT,teafi_tclSemanticDomain::EN_QUANTIFIEROFBASESIGN));
         break;
      case fi_tcl_e8_TrafficSignQuantifier::FI_EN_T_B8_LANEDEPENDENTVALIDITY:
         oPath.bGoDown(teafi_tclKnot(teafi_tclToken::EN_B8_LANEDEPENDENTVALIDITY,teafi_tclSemanticDomain::EN_QUANTIFIEROFBASESIGN));
         break;
      case fi_tcl_e8_TrafficSignQuantifier::FI_EN_T_TIMEDEPENDENTSTRING:
         oPath.bGoDown(teafi_tclKnot(teafi_tclToken::EN_TIMEDEPENDENTSTRING,teafi_tclSemanticDomain::EN_QUANTIFIEROFBASESIGN));
         break;
      case fi_tcl_e8_TrafficSignQuantifier::FI_EN_T_S32_METER:
         oPath.bGoDown(teafi_tclKnot(teafi_tclToken::EN_S32_METER,teafi_tclSemanticDomain::EN_QUANTIFIEROFBASESIGN));
         break;
      case fi_tcl_e8_TrafficSignQuantifier::FI_EN_T_S32_YARDS:
         oPath.bGoDown(teafi_tclKnot(teafi_tclToken::EN_S32_YARDS,teafi_tclSemanticDomain::EN_QUANTIFIEROFBASESIGN));
         break;
      case fi_tcl_e8_TrafficSignQuantifier::FI_EN_TMULTILANGUAGESTRING:
         oPath.bGoDown(teafi_tclKnot(teafi_tclToken::EN_MULTILANGUAGESTRING,teafi_tclSemanticDomain::EN_QUANTIFIEROFBASESIGN));
         break;
      case fi_tcl_e8_TrafficSignQuantifier::FI_EN_T_S32_CENTIMETER:
         oPath.bGoDown(teafi_tclKnot(teafi_tclToken::EN_S32_CENTIMETER,teafi_tclSemanticDomain::EN_QUANTIFIEROFBASESIGN));
         break;
      case fi_tcl_e8_TrafficSignQuantifier::FI_EN_T_S32_INCH:
         oPath.bGoDown(teafi_tclKnot(teafi_tclToken::EN_S32_INCH,teafi_tclSemanticDomain::EN_QUANTIFIEROFBASESIGN));
         break;
      case fi_tcl_e8_TrafficSignQuantifier::FI_EN_T_S32_KILOGRAM:
         oPath.bGoDown(teafi_tclKnot(teafi_tclToken::EN_S32_KILOGRAM,teafi_tclSemanticDomain::EN_QUANTIFIEROFBASESIGN));
         break;
      case fi_tcl_e8_TrafficSignQuantifier::FI_EN_T_S32_POUND:
         oPath.bGoDown(teafi_tclKnot(teafi_tclToken::EN_S32_POUND,teafi_tclSemanticDomain::EN_QUANTIFIEROFBASESIGN));
         break;
      }
   } break;
   case teafi_tclToken::EN_TRAFFICSIGNELEMENT:
   {
      if (poVisitor->bDoExpand_TrafficSignElement(enSemanticDomain))
      {
         oPath.bGoUp();
         oPath.bGoDown(teafi_tclKnot(teafi_tclToken::EN_END_OF_STRUCT,teafi_tclSemanticDomain::EN_UNKNOWN));
         oPath.bGoDown(teafi_tclKnot(teafi_tclToken::EN_ADDITIONALTRAFFICSIGN,teafi_tclSemanticDomain::EN_LIST_ELEMENT,0));
         oPath.bGoDown(teafi_tclKnot(teafi_tclToken::EN_LIST,teafi_tclSemanticDomain::EN_ADDITIONALSIGNLIST));
         oPath.bGoDown(teafi_tclKnot(teafi_tclToken::EN_TRAFFICSIGNELEMENTUNION1,teafi_tclSemanticDomain::EN_QUANTIFIEROFBASESIGN));
         oPath.bGoDown(teafi_tclKnot(teafi_tclToken::EN_TRAFFICSIGNELEMENTUNION0,teafi_tclSemanticDomain::EN_BASESIGNUNION));
         oPath.bGoDown(teafi_tclKnot(teafi_tclToken::EN_BOOL,teafi_tclSemanticDomain::EN_VIRTUALTRAFFICSIGN));
         oPath.bGoDown(teafi_tclKnot(teafi_tclToken::EN_BOOL,teafi_tclSemanticDomain::EN_DYNAMICTRAFFICSIGN));
      }
      else
      {
         fi_tcl_TrafficSignElement o_TrafficSignElement;
         if (!bDoIt(o_TrafficSignElement))
         {
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
            o_TrafficSignElement.vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
            return FALSE;
         }
         else
         {
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
            o_TrafficSignElement.vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
            oCallStack.bGoUp();
            oPath.bGoUp();
         }
      }
   } break;
   case teafi_tclToken::EN_ROADINFOCOMBINATION:
   {
      if (poVisitor->bDoExpand_RoadInfoCombination(enSemanticDomain))
      {
         oPath.bGoUp();
         oPath.bGoDown(teafi_tclKnot(teafi_tclToken::EN_END_OF_STRUCT,teafi_tclSemanticDomain::EN_UNKNOWN));
         if (9 <= u16MajorVersion)
         {
            oPath.bGoDown(teafi_tclKnot(teafi_tclToken::EN_U32,teafi_tclSemanticDomain::EN_ID));
         }
         oPath.bGoDown(teafi_tclKnot(teafi_tclToken::EN_S32_METER,teafi_tclSemanticDomain::EN_LENGTH));
         oPath.bGoDown(teafi_tclKnot(teafi_tclToken::EN_S32_METER,teafi_tclSemanticDomain::EN_STARTOFFSET));
         oPath.bGoDown(teafi_tclKnot(teafi_tclToken::EN_U16_INDEXINREFERENCELIST,teafi_tclSemanticDomain::EN_INFOELEMENT));
         oPath.bGoDown(teafi_tclKnot(teafi_tclToken::EN_U16_INDEXINREFERENCELIST,teafi_tclSemanticDomain::EN_ROADELEMENT));
      }
      else
      {
         fi_tcl_RoadInfoCombination o_RoadInfoCombination;
         if (!bDoIt(o_RoadInfoCombination))
         {
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
            o_RoadInfoCombination.vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
            return FALSE;
         }
         else
         {
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
            o_RoadInfoCombination.vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
            oCallStack.bGoUp();
            oPath.bGoUp();
         }
      }
   } break;
   case teafi_tclToken::EN_TRAFFICSIGNLISTSET:
   {
      if (poVisitor->bDoExpand_TrafficSignListSet(enSemanticDomain))
      {
         oPath.bGoUp();
         oPath.bGoDown(teafi_tclKnot(teafi_tclToken::EN_END_OF_STRUCT,teafi_tclSemanticDomain::EN_UNKNOWN));
         oPath.bGoDown(teafi_tclKnot(teafi_tclToken::EN_TRAFFICSIGNELEMENT,teafi_tclSemanticDomain::EN_LIST_ELEMENT,0));
         oPath.bGoDown(teafi_tclKnot(teafi_tclToken::EN_LIST,teafi_tclSemanticDomain::EN_TRAFFICSIGNLIST));
         oPath.bGoDown(teafi_tclKnot(teafi_tclToken::EN_ROADINFOCOMBINATION,teafi_tclSemanticDomain::EN_LIST_ELEMENT,0));
         oPath.bGoDown(teafi_tclKnot(teafi_tclToken::EN_LIST,teafi_tclSemanticDomain::EN_COMBINATIONLIST));
      }
      else
      {
         fi_tcl_TrafficSignListSet o_TrafficSignListSet;
         if (!bDoIt(o_TrafficSignListSet))
         {
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
            o_TrafficSignListSet.vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
            return FALSE;
         }
         else
         {
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
            o_TrafficSignListSet.vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
            oCallStack.bGoUp();
            oPath.bGoUp();
         }
      }
   } break;
   case teafi_tclToken::EN_B32_POICATEGORY:
   {
      fi_tcl_b32_POICategory o_b32_POICategory;
      if (!bDoIt(o_b32_POICategory))
         return FALSE;
      oCallStack.bGoUp();
      oPath.bGoUp();
   } break;
   case teafi_tclToken::EN_POIELEMENT:
   {
      if (poVisitor->bDoExpand_POIElement(enSemanticDomain))
      {
         oPath.bGoUp();
         oPath.bGoDown(teafi_tclKnot(teafi_tclToken::EN_END_OF_STRUCT,teafi_tclSemanticDomain::EN_UNKNOWN));
         oPath.bGoDown(teafi_tclKnot(teafi_tclToken::EN_POSITIONWGS84,teafi_tclSemanticDomain::EN_POSITION));
         oPath.bGoDown(teafi_tclKnot(teafi_tclToken::EN_S32_METER,teafi_tclSemanticDomain::EN_LOCATION));
         oPath.bGoDown(teafi_tclKnot(teafi_tclToken::EN_BOOL,teafi_tclSemanticDomain::EN_ISLOCATIONVALID));
         oPath.bGoDown(teafi_tclKnot(teafi_tclToken::EN_MULTILANGUAGESTRING,teafi_tclSemanticDomain::EN_NAME));
         oPath.bGoDown(teafi_tclKnot(teafi_tclToken::EN_B32_POICATEGORY,teafi_tclSemanticDomain::EN_CATEGORY));
      }
      else
      {
         fi_tcl_POIElement o_POIElement;
         if (!bDoIt(o_POIElement))
         {
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
            o_POIElement.vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
            return FALSE;
         }
         else
         {
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
            o_POIElement.vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
            oCallStack.bGoUp();
            oPath.bGoUp();
         }
      }
   } break;
   case teafi_tclToken::EN_POILISTSET:
   {
      if (poVisitor->bDoExpand_POIListSet(enSemanticDomain))
      {
         oPath.bGoUp();
         oPath.bGoDown(teafi_tclKnot(teafi_tclToken::EN_END_OF_STRUCT,teafi_tclSemanticDomain::EN_UNKNOWN));
         oPath.bGoDown(teafi_tclKnot(teafi_tclToken::EN_POIELEMENT,teafi_tclSemanticDomain::EN_LIST_ELEMENT,0));
         oPath.bGoDown(teafi_tclKnot(teafi_tclToken::EN_LIST,teafi_tclSemanticDomain::EN_POILIST));
         if (9 <= u16MajorVersion)
         {
            oPath.bGoDown(teafi_tclKnot(teafi_tclToken::EN_REFERENCEELEMENTWITHID,teafi_tclSemanticDomain::EN_LIST_ELEMENT,0));
            oPath.bGoDown(teafi_tclKnot(teafi_tclToken::EN_LIST,teafi_tclSemanticDomain::EN_ALTERNATIVREFIDLIST));
         }
         if (u16MajorVersion <= 8)
         {
            oPath.bGoDown(teafi_tclKnot(teafi_tclToken::EN_REFERENCEELEMENT,teafi_tclSemanticDomain::EN_LIST_ELEMENT,0));
            oPath.bGoDown(teafi_tclKnot(teafi_tclToken::EN_LIST,teafi_tclSemanticDomain::EN_ALTERNATIVREFLIST));
         }
      }
      else
      {
         fi_tcl_POIListSet o_POIListSet;
         if (!bDoIt(o_POIListSet))
         {
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
            o_POIListSet.vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
            return FALSE;
         }
         else
         {
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
            o_POIListSet.vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
            oCallStack.bGoUp();
            oPath.bGoUp();
         }
      }
   } break;
   case teafi_tclToken::EN_TOLLBOOTHELEMENT:
   {
      if (poVisitor->bDoExpand_TollBoothElement(enSemanticDomain))
      {
         oPath.bGoUp();
         oPath.bGoDown(teafi_tclKnot(teafi_tclToken::EN_END_OF_STRUCT,teafi_tclSemanticDomain::EN_UNKNOWN));
         oPath.bGoDown(teafi_tclKnot(teafi_tclToken::EN_S32_METER,teafi_tclSemanticDomain::EN_TOLLBOOTHPOSITION));
      }
      else
      {
         fi_tcl_TollBoothElement o_TollBoothElement;
         if (!bDoIt(o_TollBoothElement))
         {
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
            o_TollBoothElement.vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
            return FALSE;
         }
         else
         {
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
            o_TollBoothElement.vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
            oCallStack.bGoUp();
            oPath.bGoUp();
         }
      }
   } break;
   case teafi_tclToken::EN_TOLLBOOTHLISTSET:
   {
      if (poVisitor->bDoExpand_TollBoothListSet(enSemanticDomain))
      {
         oPath.bGoUp();
         oPath.bGoDown(teafi_tclKnot(teafi_tclToken::EN_END_OF_STRUCT,teafi_tclSemanticDomain::EN_UNKNOWN));
         oPath.bGoDown(teafi_tclKnot(teafi_tclToken::EN_TOLLBOOTHELEMENT,teafi_tclSemanticDomain::EN_LIST_ELEMENT,0));
         oPath.bGoDown(teafi_tclKnot(teafi_tclToken::EN_LIST,teafi_tclSemanticDomain::EN_TOLLBOOTHELEMENTLIST));
         oPath.bGoDown(teafi_tclKnot(teafi_tclToken::EN_REFERENCEELEMENTWITHID,teafi_tclSemanticDomain::EN_LIST_ELEMENT,0));
         oPath.bGoDown(teafi_tclKnot(teafi_tclToken::EN_LIST,teafi_tclSemanticDomain::EN_ALTERNATIVREFIDLIST));
      }
      else
      {
         fi_tcl_TollBoothListSet o_TollBoothListSet;
         if (!bDoIt(o_TollBoothListSet))
         {
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
            o_TollBoothListSet.vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
            return FALSE;
         }
         else
         {
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
            o_TollBoothListSet.vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
            oCallStack.bGoUp();
            oPath.bGoUp();
         }
      }
   } break;
   case teafi_tclToken::EN_CITYDISTRICTNAMELISTSET:
   {
      if (poVisitor->bDoExpand_CityDistrictNameListSet(enSemanticDomain))
      {
         oPath.bGoUp();
         oPath.bGoDown(teafi_tclKnot(teafi_tclToken::EN_END_OF_STRUCT,teafi_tclSemanticDomain::EN_UNKNOWN));
         oPath.bGoDown(teafi_tclKnot(teafi_tclToken::EN_CITYDISTRICTNAMEELEMENT,teafi_tclSemanticDomain::EN_LIST_ELEMENT,0));
         oPath.bGoDown(teafi_tclKnot(teafi_tclToken::EN_LIST,teafi_tclSemanticDomain::EN_CITYDISTRICTNAMEREFLIST));
         oPath.bGoDown(teafi_tclKnot(teafi_tclToken::EN_INDEXINREFERENCELIST,teafi_tclSemanticDomain::EN_LIST_ELEMENT,0));
         oPath.bGoDown(teafi_tclKnot(teafi_tclToken::EN_LIST,teafi_tclSemanticDomain::EN_ELEMENTINREFLIST));
      }
      else
      {
         fi_tcl_CityDistrictNameListSet o_CityDistrictNameListSet;
         if (!bDoIt(o_CityDistrictNameListSet))
         {
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
            o_CityDistrictNameListSet.vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
            return FALSE;
         }
         else
         {
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
            o_CityDistrictNameListSet.vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
            oCallStack.bGoUp();
            oPath.bGoUp();
         }
      }
   } break;
   case teafi_tclToken::EN_MAPCODEDELEMENTUNION0:
   {
      oPath.bGoUp();
      oCallStack.bGoUp();
      fi_tcl_b8_PresenceIndicator oDataMask;
      oCallStack.bGoDown(teafi_tclKnot(teafi_tclToken::EN_B8_PRESENCEINDICATOR,teafi_tclSemanticDomain::EN_DATA_MASK));
      poVisitor->oIterator = oCallStack.oGetIterator();
      bDoIt(oDataMask);
      oCallStack.bGoUp();
      if (oDataMask.u8Value & fi_tcl_b8_PresenceIndicator::FI_C_U8_BIT_T_MAPCOORDINATES)
      {
         oPath.bGoDown(teafi_tclKnot(teafi_tclToken::EN_MAPCOORDINATES,teafi_tclSemanticDomain::EN_MAPCODEDELEMENT));
      }
      if (oDataMask.u8Value & fi_tcl_b8_PresenceIndicator::FI_C_U8_BIT_T_S8_MAPDISPLAYZLEVEL)
      {
         oPath.bGoDown(teafi_tclKnot(teafi_tclToken::EN_S8_MAPDISPLAYZLEVEL,teafi_tclSemanticDomain::EN_MAPCODEDELEMENT));
      }
      if (oDataMask.u8Value & fi_tcl_b8_PresenceIndicator::FI_C_U8_BIT_T_S8_MAPDISPLAYPRIORITY)
      {
         oPath.bGoDown(teafi_tclKnot(teafi_tclToken::EN_S8_MAPDISPLAYPRIORITY,teafi_tclSemanticDomain::EN_MAPCODEDELEMENT));
      }
      if (oDataMask.u8Value & fi_tcl_b8_PresenceIndicator::FI_C_U8_BIT_T_MAPELEMENTDESCRIPTION)
      {
         oPath.bGoDown(teafi_tclKnot(teafi_tclToken::EN_MAPELEMENTDESCRIPTION,teafi_tclSemanticDomain::EN_MAPCODEDELEMENT));
      }
      if (oDataMask.u8Value & fi_tcl_b8_PresenceIndicator::FI_C_U8_BIT_T_MAPGEOGRAPHICTYPE)
      {
         oPath.bGoDown(teafi_tclKnot(teafi_tclToken::EN_MAPGEOGRAPHICTYPE,teafi_tclSemanticDomain::EN_MAPCODEDELEMENT));
      }
      if (oDataMask.u8Value & fi_tcl_b8_PresenceIndicator::FI_C_U8_BIT_T_E8_MAPGEOMETRICTYPE)
      {
         oPath.bGoDown(teafi_tclKnot(teafi_tclToken::EN_E8_MAPGEOMETRICTYPE,teafi_tclSemanticDomain::EN_MAPCODEDELEMENT));
      }
      if (oDataMask.u8Value & fi_tcl_b8_PresenceIndicator::FI_C_U8_BIT_T_E16_ISOCOUNTRYCODE)
      {
         oPath.bGoDown(teafi_tclKnot(teafi_tclToken::EN_E16_ISOCOUNTRYCODE,teafi_tclSemanticDomain::EN_MAPCODEDELEMENT));
      }
   } break;
   case teafi_tclToken::EN_MAPCODEDELEMENT:
   {
      if (poVisitor->bDoExpand_MapCodedElement(enSemanticDomain))
      {
         oPath.bGoUp();
         oPath.bGoDown(teafi_tclKnot(teafi_tclToken::EN_END_OF_STRUCT,teafi_tclSemanticDomain::EN_UNKNOWN));
         oPath.bGoDown(teafi_tclKnot(teafi_tclToken::EN_MAPCODEDELEMENTUNION0,teafi_tclSemanticDomain::EN_MAPCODEDELEMENT));
      }
      else
      {
         fi_tcl_MapCodedElement o_MapCodedElement;
         if (!bDoIt(o_MapCodedElement))
         {
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
            o_MapCodedElement.vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
            return FALSE;
         }
         else
         {
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
            o_MapCodedElement.vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
            oCallStack.bGoUp();
            oPath.bGoUp();
         }
      }
   } break;
   case teafi_tclToken::EN_POINTOFINTERESTELEMENT:
   {
      if (poVisitor->bDoExpand_PointOfInterestElement(enSemanticDomain))
      {
         oPath.bGoUp();
         oPath.bGoDown(teafi_tclKnot(teafi_tclToken::EN_END_OF_STRUCT,teafi_tclSemanticDomain::EN_UNKNOWN));
         if (9 <= u16MajorVersion)
         {
            oPath.bGoDown(teafi_tclKnot(teafi_tclToken::EN_B32_POICATEGORY,teafi_tclSemanticDomain::EN_CATEGORY));
         }
         oPath.bGoDown(teafi_tclKnot(teafi_tclToken::EN_MULTILANGUAGESTRING,teafi_tclSemanticDomain::EN_NAME));
      }
      else
      {
         fi_tcl_PointOfInterestElement o_PointOfInterestElement;
         if (!bDoIt(o_PointOfInterestElement))
         {
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
            o_PointOfInterestElement.vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
            return FALSE;
         }
         else
         {
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
            o_PointOfInterestElement.vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
            oCallStack.bGoUp();
            oPath.bGoUp();
         }
      }
   } break;
   case teafi_tclToken::EN_UNSPECIFIEDTEXT:
   {
      if (poVisitor->bDoExpand_UnspecifiedText(enSemanticDomain))
      {
         oPath.bGoUp();
         oPath.bGoDown(teafi_tclKnot(teafi_tclToken::EN_END_OF_STRUCT,teafi_tclSemanticDomain::EN_UNKNOWN));
         oPath.bGoDown(teafi_tclKnot(teafi_tclToken::EN_MULTILANGUAGESTRING,teafi_tclSemanticDomain::EN_DESCRIPTION));
      }
      else
      {
         fi_tcl_UnspecifiedText o_UnspecifiedText;
         if (!bDoIt(o_UnspecifiedText))
         {
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
            o_UnspecifiedText.vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
            return FALSE;
         }
         else
         {
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
            o_UnspecifiedText.vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
            oCallStack.bGoUp();
            oPath.bGoUp();
         }
      }
   } break;
   case teafi_tclToken::EN_E8_POSHORIZONSTATE:
   {
      fi_tcl_e8_PosHorizonState o_e8_PosHorizonState;
      if (!bDoIt(o_e8_PosHorizonState))
         return FALSE;
      oCallStack.bGoUp();
      oPath.bGoUp();
   } break;
   case teafi_tclToken::EN_OFFSETSLOPEVALUE:
   {
      if (poVisitor->bDoExpand_OffsetSlopeValue(enSemanticDomain))
      {
         oPath.bGoUp();
         oPath.bGoDown(teafi_tclKnot(teafi_tclToken::EN_END_OF_STRUCT,teafi_tclSemanticDomain::EN_UNKNOWN));
         oPath.bGoDown(teafi_tclKnot(teafi_tclToken::EN_S16_CENTIDEGREE,teafi_tclSemanticDomain::EN_SLOPE));
         oPath.bGoDown(teafi_tclKnot(teafi_tclToken::EN_S32_CENTIMETER,teafi_tclSemanticDomain::EN_OFFSET));
      }
      else
      {
         fi_tcl_OffsetSlopeValue o_OffsetSlopeValue;
         if (!bDoIt(o_OffsetSlopeValue))
         {
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
            o_OffsetSlopeValue.vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
            return FALSE;
         }
         else
         {
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
            o_OffsetSlopeValue.vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
            oCallStack.bGoUp();
            oPath.bGoUp();
         }
      }
   } break;
   case teafi_tclToken::EN_OFFSETHEIGHTVALUE:
   {
      if (poVisitor->bDoExpand_OffsetHeightValue(enSemanticDomain))
      {
         oPath.bGoUp();
         oPath.bGoDown(teafi_tclKnot(teafi_tclToken::EN_END_OF_STRUCT,teafi_tclSemanticDomain::EN_UNKNOWN));
         oPath.bGoDown(teafi_tclKnot(teafi_tclToken::EN_S16_METER,teafi_tclSemanticDomain::EN_HEIGHT));
         oPath.bGoDown(teafi_tclKnot(teafi_tclToken::EN_S32_CENTIMETER,teafi_tclSemanticDomain::EN_OFFSET));
      }
      else
      {
         fi_tcl_OffsetHeightValue o_OffsetHeightValue;
         if (!bDoIt(o_OffsetHeightValue))
         {
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
            o_OffsetHeightValue.vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
            return FALSE;
         }
         else
         {
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
            o_OffsetHeightValue.vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
            oCallStack.bGoUp();
            oPath.bGoUp();
         }
      }
   } break;
   case teafi_tclToken::EN_E8_DIGITALMAPSPEEDCATEGORYTYPE:
   {
      fi_tcl_e8_DigitalMapSpeedCategoryType o_e8_DigitalMapSpeedCategoryType;
      if (!bDoIt(o_e8_DigitalMapSpeedCategoryType))
         return FALSE;
      oCallStack.bGoUp();
      oPath.bGoUp();
   } break;
   case teafi_tclToken::EN_E8_POSHORIZONSUCCESSORSTATE:
   {
      fi_tcl_e8_PosHorizonSuccessorState o_e8_PosHorizonSuccessorState;
      if (!bDoIt(o_e8_PosHorizonSuccessorState))
         return FALSE;
      oCallStack.bGoUp();
      oPath.bGoUp();
   } break;
   case teafi_tclToken::EN_B32_PATHSECTIONSTATUS:
   {
      fi_tcl_b32_PathSectionStatus o_b32_PathSectionStatus;
      if (!bDoIt(o_b32_PathSectionStatus))
         return FALSE;
      oCallStack.bGoUp();
      oPath.bGoUp();
   } break;
   case teafi_tclToken::EN_B8_POSHORIZONSUCCESSORSTATE:
   {
      fi_tcl_b8_PosHorizonSuccessorState o_b8_PosHorizonSuccessorState;
      if (!bDoIt(o_b8_PosHorizonSuccessorState))
         return FALSE;
      oCallStack.bGoUp();
      oPath.bGoUp();
   } break;
   case teafi_tclToken::EN_POSHORIZONPATHSUCCESSOR:
   {
      if (poVisitor->bDoExpand_PosHorizonPathSuccessor(enSemanticDomain))
      {
         oPath.bGoUp();
         oPath.bGoDown(teafi_tclKnot(teafi_tclToken::EN_END_OF_STRUCT,teafi_tclSemanticDomain::EN_UNKNOWN));
         oPath.bGoDown(teafi_tclKnot(teafi_tclToken::EN_S16_CURVATUREVALUE,teafi_tclSemanticDomain::EN_TRANSITIONCURVATURE));
         oPath.bGoDown(teafi_tclKnot(teafi_tclToken::EN_U8_PERCENT,teafi_tclSemanticDomain::EN_RELPROBABILITY));
         oPath.bGoDown(teafi_tclKnot(teafi_tclToken::EN_U16_INDEXINREFERENCELIST,teafi_tclSemanticDomain::EN_PATHID));
         if (9 <= u16MajorVersion)
         {
            oPath.bGoDown(teafi_tclKnot(teafi_tclToken::EN_B8_POSHORIZONSUCCESSORSTATE,teafi_tclSemanticDomain::EN_SUCCESSORSTATUS));
         }
         if (u16MajorVersion <= 8)
         {
            oPath.bGoDown(teafi_tclKnot(teafi_tclToken::EN_E8_POSHORIZONSUCCESSORSTATE,teafi_tclSemanticDomain::EN_SUCCESSORSTATE));
         }
      }
      else
      {
         fi_tcl_PosHorizonPathSuccessor o_PosHorizonPathSuccessor;
         if (!bDoIt(o_PosHorizonPathSuccessor))
         {
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
            o_PosHorizonPathSuccessor.vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
            return FALSE;
         }
         else
         {
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
            o_PosHorizonPathSuccessor.vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
            oCallStack.bGoUp();
            oPath.bGoUp();
         }
      }
   } break;
   case teafi_tclToken::EN_POSHORIZONPATHSECTION:
   {
      if (poVisitor->bDoExpand_PosHorizonPathSection(enSemanticDomain))
      {
         oPath.bGoUp();
         oPath.bGoDown(teafi_tclKnot(teafi_tclToken::EN_END_OF_STRUCT,teafi_tclSemanticDomain::EN_UNKNOWN));
         if (37 <= u16MajorVersion)
         {
            oPath.bGoDown(teafi_tclKnot(teafi_tclToken::EN_E8_DIGITALMAPSPEEDCATEGORYTYPE,teafi_tclSemanticDomain::EN_SPEEDCATEGORY));
         }
         oPath.bGoDown(teafi_tclKnot(teafi_tclToken::EN_POSHORIZONPATHSUCCESSOR,teafi_tclSemanticDomain::EN_LIST_ELEMENT,0));
         oPath.bGoDown(teafi_tclKnot(teafi_tclToken::EN_LIST,teafi_tclSemanticDomain::EN_SUCCESSORLIST));
         if (9 <= u16MajorVersion)
         {
            oPath.bGoDown(teafi_tclKnot(teafi_tclToken::EN_U8,teafi_tclSemanticDomain::EN_NUMBEROFMOSTPROBABLEPATHES));
         }
         if (9 <= u16MajorVersion)
         {
            oPath.bGoDown(teafi_tclKnot(teafi_tclToken::EN_U16_INDEXINREFERENCELIST,teafi_tclSemanticDomain::EN_INDEXOFFIRSTMOSTPROBABLEPATH));
         }
         if (9 <= u16MajorVersion)
         {
            oPath.bGoDown(teafi_tclKnot(teafi_tclToken::EN_U16_INDEXINREFERENCELIST,teafi_tclSemanticDomain::EN_OCINDEXINROUTELIST));
         }
         if (9 <= u16MajorVersion)
         {
            oPath.bGoDown(teafi_tclKnot(teafi_tclToken::EN_B32_PATHSECTIONSTATUS,teafi_tclSemanticDomain::EN_PATHSECTIONSTATUS));
         }
         if (u16MajorVersion <= 8)
         {
            oPath.bGoDown(teafi_tclKnot(teafi_tclToken::EN_BOOL,teafi_tclSemanticDomain::EN_ISPARTOFROUTE));
         }
         oPath.bGoDown(teafi_tclKnot(teafi_tclToken::EN_E8_NAVONECELLDIRECTION,teafi_tclSemanticDomain::EN_USEDDIRECTION));
         oPath.bGoDown(teafi_tclKnot(teafi_tclToken::EN_U16_INDEXINREFERENCELIST,teafi_tclSemanticDomain::EN_INDEXINONECELLREFLIST));
      }
      else
      {
         fi_tcl_PosHorizonPathSection o_PosHorizonPathSection;
         if (!bDoIt(o_PosHorizonPathSection))
         {
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
            o_PosHorizonPathSection.vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
            return FALSE;
         }
         else
         {
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
            o_PosHorizonPathSection.vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
            oCallStack.bGoUp();
            oPath.bGoUp();
         }
      }
   } break;
   case teafi_tclToken::EN_POSHORIZONONECELLDESC:
   {
      if (poVisitor->bDoExpand_PosHorizonOneCellDesc(enSemanticDomain))
      {
         oPath.bGoUp();
         oPath.bGoDown(teafi_tclKnot(teafi_tclToken::EN_END_OF_STRUCT,teafi_tclSemanticDomain::EN_UNKNOWN));
         oPath.bGoDown(teafi_tclKnot(teafi_tclToken::EN_U16_INDEXINREFERENCELIST,teafi_tclSemanticDomain::EN_INDEXINCLUSTERREFLIST));
         oPath.bGoDown(teafi_tclKnot(teafi_tclToken::EN_U16,teafi_tclSemanticDomain::EN_ONECELLID));
      }
      else
      {
         fi_tcl_PosHorizonOneCellDesc o_PosHorizonOneCellDesc;
         if (!bDoIt(o_PosHorizonOneCellDesc))
         {
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
            o_PosHorizonOneCellDesc.vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
            return FALSE;
         }
         else
         {
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
            o_PosHorizonOneCellDesc.vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
            oCallStack.bGoUp();
            oPath.bGoUp();
         }
      }
   } break;
   case teafi_tclToken::EN_B8_HORIZONONECELLPROPERTYSTATUS:
   {
      fi_tcl_b8_HorizonOneCellPropertyStatus o_b8_HorizonOneCellPropertyStatus;
      if (!bDoIt(o_b8_HorizonOneCellPropertyStatus))
         return FALSE;
      oCallStack.bGoUp();
      oPath.bGoUp();
   } break;
   case teafi_tclToken::EN_HORIZONMOSTPROBABLEPATH:
   {
      if (poVisitor->bDoExpand_HorizonMostProbablePath(enSemanticDomain))
      {
         oPath.bGoUp();
         oPath.bGoDown(teafi_tclKnot(teafi_tclToken::EN_END_OF_STRUCT,teafi_tclSemanticDomain::EN_UNKNOWN));
         oPath.bGoDown(teafi_tclKnot(teafi_tclToken::EN_U16_INDEXINREFERENCELIST,teafi_tclSemanticDomain::EN_LIST_ELEMENT,0));
         oPath.bGoDown(teafi_tclKnot(teafi_tclToken::EN_LIST,teafi_tclSemanticDomain::EN_PATHLIST));
         oPath.bGoDown(teafi_tclKnot(teafi_tclToken::EN_U16_INDEXINREFERENCELIST,teafi_tclSemanticDomain::EN_INDEXOFLASTCOMMONPREDECESSOR));
         oPath.bGoDown(teafi_tclKnot(teafi_tclToken::EN_U16_INDEXINREFERENCELIST,teafi_tclSemanticDomain::EN_INDEXOFPREDECESSORLIST));
         oPath.bGoDown(teafi_tclKnot(teafi_tclToken::EN_U8_PERCENT,teafi_tclSemanticDomain::EN_RELPROBABILITY));
      }
      else
      {
         fi_tcl_HorizonMostProbablePath o_HorizonMostProbablePath;
         if (!bDoIt(o_HorizonMostProbablePath))
         {
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
            o_HorizonMostProbablePath.vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
            return FALSE;
         }
         else
         {
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
            o_HorizonMostProbablePath.vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
            oCallStack.bGoUp();
            oPath.bGoUp();
         }
      }
   } break;
   case teafi_tclToken::EN_POSHORIZONROOTELEMENT:
   {
      if (poVisitor->bDoExpand_PosHorizonRootElement(enSemanticDomain))
      {
         oPath.bGoUp();
         oPath.bGoDown(teafi_tclKnot(teafi_tclToken::EN_END_OF_STRUCT,teafi_tclSemanticDomain::EN_UNKNOWN));
         oPath.bGoDown(teafi_tclKnot(teafi_tclToken::EN_U8_PERCENT,teafi_tclSemanticDomain::EN_ROOTPROBABILITY));
         oPath.bGoDown(teafi_tclKnot(teafi_tclToken::EN_U16_INDEXINREFERENCELIST,teafi_tclSemanticDomain::EN_INDEXOFROOTINLASTHORIZON));
         oPath.bGoDown(teafi_tclKnot(teafi_tclToken::EN_U16_INDEXINREFERENCELIST,teafi_tclSemanticDomain::EN_INDEXOFROOT));
      }
      else
      {
         fi_tcl_PosHorizonRootElement o_PosHorizonRootElement;
         if (!bDoIt(o_PosHorizonRootElement))
         {
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
            o_PosHorizonRootElement.vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
            return FALSE;
         }
         else
         {
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
            o_PosHorizonRootElement.vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
            oCallStack.bGoUp();
            oPath.bGoUp();
         }
      }
   } break;
   case teafi_tclToken::EN_POSHORIZONONECELLSECTION:
   {
      if (poVisitor->bDoExpand_PosHorizonOneCellSection(enSemanticDomain))
      {
         oPath.bGoUp();
         oPath.bGoDown(teafi_tclKnot(teafi_tclToken::EN_END_OF_STRUCT,teafi_tclSemanticDomain::EN_UNKNOWN));
         if (9 <= u16MajorVersion)
         {
            oPath.bGoDown(teafi_tclKnot(teafi_tclToken::EN_U32,teafi_tclSemanticDomain::EN_LIST_ELEMENT,0));
            oPath.bGoDown(teafi_tclKnot(teafi_tclToken::EN_LIST,teafi_tclSemanticDomain::EN_IDLIST));
         }
         if ((19 <= u16MajorVersion) && (u16MajorVersion <= 20))
         {
            oPath.bGoDown(teafi_tclKnot(teafi_tclToken::EN_OFFSETHEIGHTVALUE,teafi_tclSemanticDomain::EN_LIST_ELEMENT,0));
            oPath.bGoDown(teafi_tclKnot(teafi_tclToken::EN_LIST,teafi_tclSemanticDomain::EN_OCHEIGHTS));
         }
         if ((19 <= u16MajorVersion) && (u16MajorVersion <= 20))
         {
            oPath.bGoDown(teafi_tclKnot(teafi_tclToken::EN_OFFSETSLOPEVALUE,teafi_tclSemanticDomain::EN_LIST_ELEMENT,0));
            oPath.bGoDown(teafi_tclKnot(teafi_tclToken::EN_LIST,teafi_tclSemanticDomain::EN_OCSLOPES));
         }
         oPath.bGoDown(teafi_tclKnot(teafi_tclToken::EN_POSITIONWGS84,teafi_tclSemanticDomain::EN_LIST_ELEMENT,0));
         oPath.bGoDown(teafi_tclKnot(teafi_tclToken::EN_LIST,teafi_tclSemanticDomain::EN_OCSHAPE));
         oPath.bGoDown(teafi_tclKnot(teafi_tclToken::EN_NAVPOSONECELLPROPERTY,teafi_tclSemanticDomain::EN_OCPROPERTIES));
         if (9 <= u16MajorVersion)
         {
            oPath.bGoDown(teafi_tclKnot(teafi_tclToken::EN_B8_HORIZONONECELLPROPERTYSTATUS,teafi_tclSemanticDomain::EN_OCPROPERTYSTATUS));
         }
         if (u16MajorVersion <= 8)
         {
            oPath.bGoDown(teafi_tclKnot(teafi_tclToken::EN_BOOL,teafi_tclSemanticDomain::EN_OCPROPERTIESVALID));
         }
         oPath.bGoDown(teafi_tclKnot(teafi_tclToken::EN_POSHORIZONONECELLDESC,teafi_tclSemanticDomain::EN_OCDESC));
      }
      else
      {
         fi_tcl_PosHorizonOneCellSection o_PosHorizonOneCellSection;
         if (!bDoIt(o_PosHorizonOneCellSection))
         {
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
            o_PosHorizonOneCellSection.vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
            return FALSE;
         }
         else
         {
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
            o_PosHorizonOneCellSection.vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
            oCallStack.bGoUp();
            oPath.bGoUp();
         }
      }
   } break;
   case teafi_tclToken::EN_B8_TEAPRESENCEINDICATOR:
   {
      fi_tcl_b8_TEAPresenceIndicator o_b8_TEAPresenceIndicator;
      if (!bDoIt(o_b8_TEAPresenceIndicator))
         return FALSE;
      oCallStack.bGoUp();
      oPath.bGoUp();
   } break;
   case teafi_tclToken::EN_B32_ROADINFOCATEGORYINDICATOR:
   {
      fi_tcl_b32_RoadInfoCategoryIndicator o_b32_RoadInfoCategoryIndicator;
      if (!bDoIt(o_b32_RoadInfoCategoryIndicator))
         return FALSE;
      oCallStack.bGoUp();
      oPath.bGoUp();
   } break;
   case teafi_tclToken::EN_E8_HORIZONROADINFOCATEGORY:
   {
      fi_tcl_e8_HorizonRoadInfoCategory o_e8_HorizonRoadInfoCategory;
      if (!bDoIt(o_e8_HorizonRoadInfoCategory))
         return FALSE;
      oCallStack.bGoUp();
      oPath.bGoUp();
   } break;
   case teafi_tclToken::EN_HORIZONROADINFOUNIONUNION0:
   {
      oPath.bGoUp();
      oCallStack.bGoUp();
      fi_tcl_e8_HorizonRoadInfoCategory oDataType;
      oCallStack.bGoDown(teafi_tclKnot(teafi_tclToken::EN_E8_HORIZONROADINFOCATEGORY,teafi_tclSemanticDomain::EN_DATA_TYPE));
      poVisitor->oIterator = oCallStack.oGetIterator();
      bDoIt(oDataType);
      oCallStack.bGoUp();
      if ((oDataType.enType == fi_tcl_e8_HorizonRoadInfoCategory::FI_EN_T_REQUIREDPERMISSIONLISTSET) &&
          !(9 <= u16MajorVersion))
      {
         oDataType.enType = fi_tcl_e8_HorizonRoadInfoCategory::FI_EN_T_RESERVED;
      }
      if ((oDataType.enType == fi_tcl_e8_HorizonRoadInfoCategory::FI_EN_T_DIRECTIONINFOLISTSET) &&
          !(9 <= u16MajorVersion))
      {
         oDataType.enType = fi_tcl_e8_HorizonRoadInfoCategory::FI_EN_T_RESERVED;
      }
      if ((oDataType.enType == fi_tcl_e8_HorizonRoadInfoCategory::FI_EN_T_TOLLBOOTHLISTSET) &&
          !(36 <= u16MajorVersion))
      {
         oDataType.enType = fi_tcl_e8_HorizonRoadInfoCategory::FI_EN_T_RESERVED;
      }
      if ((oDataType.enType == fi_tcl_e8_HorizonRoadInfoCategory::FI_EN_T_TIMEZONELISTSET) &&
          !(21 <= u16MajorVersion))
      {
         oDataType.enType = fi_tcl_e8_HorizonRoadInfoCategory::FI_EN_T_RESERVED;
      }
      switch (oDataType.enType)
      {
      case fi_tcl_e8_HorizonRoadInfoCategory::FI_EN_T_RESERVED:
         oPath.bGoDown(teafi_tclKnot(teafi_tclToken::EN_RESERVED,teafi_tclSemanticDomain::EN_ROADINFOUNION));
         break;
      case fi_tcl_e8_HorizonRoadInfoCategory::FI_EN_T_COUNTRYNAMELISTSET:
         oPath.bGoDown(teafi_tclKnot(teafi_tclToken::EN_COUNTRYNAMELISTSET,teafi_tclSemanticDomain::EN_ROADINFOUNION));
         break;
      case fi_tcl_e8_HorizonRoadInfoCategory::FI_EN_T_STATENAMELISTSET:
         oPath.bGoDown(teafi_tclKnot(teafi_tclToken::EN_STATENAMELISTSET,teafi_tclSemanticDomain::EN_ROADINFOUNION));
         break;
      case fi_tcl_e8_HorizonRoadInfoCategory::FI_EN_T_COUNTYNAMELISTSET:
         oPath.bGoDown(teafi_tclKnot(teafi_tclToken::EN_COUNTYNAMELISTSET,teafi_tclSemanticDomain::EN_ROADINFOUNION));
         break;
      case fi_tcl_e8_HorizonRoadInfoCategory::FI_EN_T_CITYNAMELISTSET:
         oPath.bGoDown(teafi_tclKnot(teafi_tclToken::EN_CITYNAMELISTSET,teafi_tclSemanticDomain::EN_ROADINFOUNION));
         break;
      case fi_tcl_e8_HorizonRoadInfoCategory::FI_EN_T_CITYDISTRICTNAMELISTSET:
         oPath.bGoDown(teafi_tclKnot(teafi_tclToken::EN_CITYDISTRICTNAMELISTSET,teafi_tclSemanticDomain::EN_ROADINFOUNION));
         break;
      case fi_tcl_e8_HorizonRoadInfoCategory::FI_EN_T_BUILDUPAREANAMELISTSET:
         oPath.bGoDown(teafi_tclKnot(teafi_tclToken::EN_BUILDUPAREANAMELISTSET,teafi_tclSemanticDomain::EN_ROADINFOUNION));
         break;
      case fi_tcl_e8_HorizonRoadInfoCategory::FI_EN_T_ROADNAMELISTSET:
         oPath.bGoDown(teafi_tclKnot(teafi_tclToken::EN_ROADNAMELISTSET,teafi_tclSemanticDomain::EN_ROADINFOUNION));
         break;
      case fi_tcl_e8_HorizonRoadInfoCategory::FI_EN_T_ROADNUMBERLISTSET:
         oPath.bGoDown(teafi_tclKnot(teafi_tclToken::EN_ROADNUMBERLISTSET,teafi_tclSemanticDomain::EN_ROADINFOUNION));
         break;
      case fi_tcl_e8_HorizonRoadInfoCategory::FI_EN_T_TIMEZONELISTSET:
         oPath.bGoDown(teafi_tclKnot(teafi_tclToken::EN_TIMEZONELISTSET,teafi_tclSemanticDomain::EN_ROADINFOUNION));
         break;
      case fi_tcl_e8_HorizonRoadInfoCategory::FI_EN_T_TOLLBOOTHLISTSET:
         oPath.bGoDown(teafi_tclKnot(teafi_tclToken::EN_TOLLBOOTHLISTSET,teafi_tclSemanticDomain::EN_ROADINFOUNION));
         break;
      case fi_tcl_e8_HorizonRoadInfoCategory::FI_EN_T_MAPDESCRIPTIONLISTSET:
         oPath.bGoDown(teafi_tclKnot(teafi_tclToken::EN_MAPDESCRIPTIONLISTSET,teafi_tclSemanticDomain::EN_ROADINFOUNION));
         break;
      case fi_tcl_e8_HorizonRoadInfoCategory::FI_EN_T_TMINFOLISTSET:
         oPath.bGoDown(teafi_tclKnot(teafi_tclToken::EN_TMINFOLISTSET,teafi_tclSemanticDomain::EN_ROADINFOUNION));
         break;
      case fi_tcl_e8_HorizonRoadInfoCategory::FI_EN_T_SIGNPOSTLISTSET:
         oPath.bGoDown(teafi_tclKnot(teafi_tclToken::EN_SIGNPOSTLISTSET,teafi_tclSemanticDomain::EN_ROADINFOUNION));
         break;
      case fi_tcl_e8_HorizonRoadInfoCategory::FI_EN_T_EXTRADESCLISTSET:
         oPath.bGoDown(teafi_tclKnot(teafi_tclToken::EN_EXTRADESCLISTSET,teafi_tclSemanticDomain::EN_ROADINFOUNION));
         break;
      case fi_tcl_e8_HorizonRoadInfoCategory::FI_EN_T_DATADESCLISTSET:
         oPath.bGoDown(teafi_tclKnot(teafi_tclToken::EN_DATADESCLISTSET,teafi_tclSemanticDomain::EN_ROADINFOUNION));
         break;
      case fi_tcl_e8_HorizonRoadInfoCategory::FI_EN_T_NAVINTERSECTIONLISTSET:
         oPath.bGoDown(teafi_tclKnot(teafi_tclToken::EN_NAVINTERSECTIONLISTSET,teafi_tclSemanticDomain::EN_ROADINFOUNION));
         break;
      case fi_tcl_e8_HorizonRoadInfoCategory::FI_EN_T_TRAFFICSIGNLISTSET:
         oPath.bGoDown(teafi_tclKnot(teafi_tclToken::EN_TRAFFICSIGNLISTSET,teafi_tclSemanticDomain::EN_ROADINFOUNION));
         break;
      case fi_tcl_e8_HorizonRoadInfoCategory::FI_EN_T_POILISTSET:
         oPath.bGoDown(teafi_tclKnot(teafi_tclToken::EN_POILISTSET,teafi_tclSemanticDomain::EN_ROADINFOUNION));
         break;
      case fi_tcl_e8_HorizonRoadInfoCategory::FI_EN_T_LANEINFOLISTSET:
         oPath.bGoDown(teafi_tclKnot(teafi_tclToken::EN_LANEINFOLISTSET,teafi_tclSemanticDomain::EN_ROADINFOUNION));
         break;
      case fi_tcl_e8_HorizonRoadInfoCategory::FI_EN_T_DIRECTIONINFOLISTSET:
         oPath.bGoDown(teafi_tclKnot(teafi_tclToken::EN_DIRECTIONINFOLISTSET,teafi_tclSemanticDomain::EN_ROADINFOUNION));
         break;
      case fi_tcl_e8_HorizonRoadInfoCategory::FI_EN_T_REQUIREDPERMISSIONLISTSET:
         oPath.bGoDown(teafi_tclKnot(teafi_tclToken::EN_REQUIREDPERMISSIONLISTSET,teafi_tclSemanticDomain::EN_ROADINFOUNION));
         break;
      }
   } break;
   case teafi_tclToken::EN_HORIZONROADINFOUNION:
   {
      if (poVisitor->bDoExpand_HorizonRoadInfoUnion(enSemanticDomain))
      {
         oPath.bGoUp();
         oPath.bGoDown(teafi_tclKnot(teafi_tclToken::EN_END_OF_STRUCT,teafi_tclSemanticDomain::EN_UNKNOWN));
         oPath.bGoDown(teafi_tclKnot(teafi_tclToken::EN_HORIZONROADINFOUNIONUNION0,teafi_tclSemanticDomain::EN_ROADINFOUNION));
      }
      else
      {
         fi_tcl_HorizonRoadInfoUnion o_HorizonRoadInfoUnion;
         if (!bDoIt(o_HorizonRoadInfoUnion))
         {
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
            o_HorizonRoadInfoUnion.vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
            return FALSE;
         }
         else
         {
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
            o_HorizonRoadInfoUnion.vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
            oCallStack.bGoUp();
            oPath.bGoUp();
         }
      }
   } break;
   case teafi_tclToken::EN_B8_CURVATURESTATUS:
   {
      fi_tcl_b8_CurvatureStatus o_b8_CurvatureStatus;
      if (!bDoIt(o_b8_CurvatureStatus))
         return FALSE;
      oCallStack.bGoUp();
      oPath.bGoUp();
   } break;
   case teafi_tclToken::EN_CURVATURE:
   {
      if (poVisitor->bDoExpand_Curvature(enSemanticDomain))
      {
         oPath.bGoUp();
         oPath.bGoDown(teafi_tclKnot(teafi_tclToken::EN_END_OF_STRUCT,teafi_tclSemanticDomain::EN_UNKNOWN));
         if (13 <= u16MajorVersion)
         {
            oPath.bGoDown(teafi_tclKnot(teafi_tclToken::EN_B8_CURVATURESTATUS,teafi_tclSemanticDomain::EN_CURVATURESTATUS));
         }
         if (13 <= u16MajorVersion)
         {
            oPath.bGoDown(teafi_tclKnot(teafi_tclToken::EN_U32,teafi_tclSemanticDomain::EN_CONNECTIVITYID));
         }
         if (13 <= u16MajorVersion)
         {
            oPath.bGoDown(teafi_tclKnot(teafi_tclToken::EN_U32,teafi_tclSemanticDomain::EN_ID));
         }
         if (13 <= u16MajorVersion)
         {
            oPath.bGoDown(teafi_tclKnot(teafi_tclToken::EN_S16_CENTIMETERSECOND,teafi_tclSemanticDomain::EN_CRITICALSPEED));
         }
         oPath.bGoDown(teafi_tclKnot(teafi_tclToken::EN_S16_CURVATUREVALUE,teafi_tclSemanticDomain::EN_CURVATUREVALUE));
         oPath.bGoDown(teafi_tclKnot(teafi_tclToken::EN_S32_MEMU,teafi_tclSemanticDomain::EN_DISTANCEOFFSET));
      }
      else
      {
         fi_tcl_Curvature o_Curvature;
         if (!bDoIt(o_Curvature))
         {
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
            o_Curvature.vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
            return FALSE;
         }
         else
         {
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
            o_Curvature.vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
            oCallStack.bGoUp();
            oPath.bGoUp();
         }
      }
   } break;
   case teafi_tclToken::EN_CURVATURELIST:
   {
      if (poVisitor->bDoExpand_CurvatureList(enSemanticDomain))
      {
         oPath.bGoUp();
         oPath.bGoDown(teafi_tclKnot(teafi_tclToken::EN_END_OF_STRUCT,teafi_tclSemanticDomain::EN_UNKNOWN));
         oPath.bGoDown(teafi_tclKnot(teafi_tclToken::EN_CURVATURE,teafi_tclSemanticDomain::EN_LIST_ELEMENT,0));
         oPath.bGoDown(teafi_tclKnot(teafi_tclToken::EN_LIST,teafi_tclSemanticDomain::EN_CURVATURELIST));
      }
      else
      {
         fi_tcl_CurvatureList o_CurvatureList;
         if (!bDoIt(o_CurvatureList))
         {
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
            o_CurvatureList.vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
            return FALSE;
         }
         else
         {
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
            o_CurvatureList.vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
            oCallStack.bGoUp();
            oPath.bGoUp();
         }
      }
   } break;
   case teafi_tclToken::EN_E8_MPPSTATE:
   {
      fi_tcl_e8_MPPState o_e8_MPPState;
      if (!bDoIt(o_e8_MPPState))
         return FALSE;
      oCallStack.bGoUp();
      oPath.bGoUp();
   } break;
   case teafi_tclToken::EN_MPPDATA:
   {
      if (poVisitor->bDoExpand_MPPData(enSemanticDomain))
      {
         oPath.bGoUp();
         oPath.bGoDown(teafi_tclKnot(teafi_tclToken::EN_END_OF_STRUCT,teafi_tclSemanticDomain::EN_UNKNOWN));
         oPath.bGoDown(teafi_tclKnot(teafi_tclToken::EN_CURVATURELIST,teafi_tclSemanticDomain::EN_CURVATURES));
         oPath.bGoDown(teafi_tclKnot(teafi_tclToken::EN_U16,teafi_tclSemanticDomain::EN_PATHSECTIONINDEX));
      }
      else
      {
         fi_tcl_MPPData o_MPPData;
         if (!bDoIt(o_MPPData))
         {
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
            o_MPPData.vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
            return FALSE;
         }
         else
         {
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
            o_MPPData.vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
            oCallStack.bGoUp();
            oPath.bGoUp();
         }
      }
   } break;
   case teafi_tclToken::EN_ALTERNATIVTEAEVENTIDLIST:
   {
      if (poVisitor->bDoExpand_AlternativTEAEventIDList(enSemanticDomain))
      {
         oPath.bGoUp();
         oPath.bGoDown(teafi_tclKnot(teafi_tclToken::EN_END_OF_STRUCT,teafi_tclSemanticDomain::EN_UNKNOWN));
         oPath.bGoDown(teafi_tclKnot(teafi_tclToken::EN_U32,teafi_tclSemanticDomain::EN_LIST_ELEMENT,0));
         oPath.bGoDown(teafi_tclKnot(teafi_tclToken::EN_LIST,teafi_tclSemanticDomain::EN_ALTERNATIVIDLIST));
      }
      else
      {
         fi_tcl_AlternativTEAEventIDList o_AlternativTEAEventIDList;
         if (!bDoIt(o_AlternativTEAEventIDList))
         {
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
            o_AlternativTEAEventIDList.vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
            return FALSE;
         }
         else
         {
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
            o_AlternativTEAEventIDList.vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
            oCallStack.bGoUp();
            oPath.bGoUp();
         }
      }
   } break;
   case teafi_tclToken::EN_E8_TEAEVENTTYPE:
   {
      fi_tcl_e8_TEAEventType o_e8_TEAEventType;
      if (!bDoIt(o_e8_TEAEventType))
         return FALSE;
      oCallStack.bGoUp();
      oPath.bGoUp();
   } break;
   case teafi_tclToken::EN_TEAEVENTID:
   {
      if (poVisitor->bDoExpand_TEAEventID(enSemanticDomain))
      {
         oPath.bGoUp();
         oPath.bGoDown(teafi_tclKnot(teafi_tclToken::EN_END_OF_STRUCT,teafi_tclSemanticDomain::EN_UNKNOWN));
         oPath.bGoDown(teafi_tclKnot(teafi_tclToken::EN_E8_TEAEVENTTYPE,teafi_tclSemanticDomain::EN_TEAEVENTTYPE));
         oPath.bGoDown(teafi_tclKnot(teafi_tclToken::EN_U32,teafi_tclSemanticDomain::EN_ID));
      }
      else
      {
         fi_tcl_TEAEventID o_TEAEventID;
         if (!bDoIt(o_TEAEventID))
         {
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
            o_TEAEventID.vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
            return FALSE;
         }
         else
         {
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
            o_TEAEventID.vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
            oCallStack.bGoUp();
            oPath.bGoUp();
         }
      }
   } break;
   case teafi_tclToken::EN_MAPCOORDINATES:
   {
      if (poVisitor->bDoExpand_MapCoordinates(enSemanticDomain))
      {
         oPath.bGoUp();
         oPath.bGoDown(teafi_tclKnot(teafi_tclToken::EN_END_OF_STRUCT,teafi_tclSemanticDomain::EN_UNKNOWN));
         oPath.bGoDown(teafi_tclKnot(teafi_tclToken::EN_POSITIONWGS84,teafi_tclSemanticDomain::EN_LIST_ELEMENT,0));
         oPath.bGoDown(teafi_tclKnot(teafi_tclToken::EN_LIST,teafi_tclSemanticDomain::EN_COORDINATES));
      }
      else
      {
         fi_tcl_MapCoordinates o_MapCoordinates;
         if (!bDoIt(o_MapCoordinates))
         {
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
            o_MapCoordinates.vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
            return FALSE;
         }
         else
         {
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
            o_MapCoordinates.vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
            oCallStack.bGoUp();
            oPath.bGoUp();
         }
      }
   } break;
   case teafi_tclToken::EN_S8_MAPDISPLAYZLEVEL:
   {
      fi_tcl_s8_MapDisplayZLevel o_s8_MapDisplayZLevel;
      if (!bDoIt(o_s8_MapDisplayZLevel))
         return FALSE;
      oCallStack.bGoUp();
      oPath.bGoUp();
   } break;
   case teafi_tclToken::EN_S8_MAPDISPLAYPRIORITY:
   {
      fi_tcl_s8_MapDisplayPriority o_s8_MapDisplayPriority;
      if (!bDoIt(o_s8_MapDisplayPriority))
         return FALSE;
      oCallStack.bGoUp();
      oPath.bGoUp();
   } break;
   case teafi_tclToken::EN_MAPDESCRIPTIONLISTSET:
   {
      if (poVisitor->bDoExpand_MapDescriptionListSet(enSemanticDomain))
      {
         oPath.bGoUp();
         oPath.bGoDown(teafi_tclKnot(teafi_tclToken::EN_END_OF_STRUCT,teafi_tclSemanticDomain::EN_UNKNOWN));
         oPath.bGoDown(teafi_tclKnot(teafi_tclToken::EN_MAPCODEDELEMENT,teafi_tclSemanticDomain::EN_LIST_ELEMENT,0));
         oPath.bGoDown(teafi_tclKnot(teafi_tclToken::EN_LIST,teafi_tclSemanticDomain::EN_MAPELEMENTREFLIST));
         oPath.bGoDown(teafi_tclKnot(teafi_tclToken::EN_U16_INDEXINREFERENCELIST,teafi_tclSemanticDomain::EN_LIST_ELEMENT,0));
         oPath.bGoDown(teafi_tclKnot(teafi_tclToken::EN_LIST,teafi_tclSemanticDomain::EN_ELEMENTREFLIST));
      }
      else
      {
         fi_tcl_MapDescriptionListSet o_MapDescriptionListSet;
         if (!bDoIt(o_MapDescriptionListSet))
         {
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
            o_MapDescriptionListSet.vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
            return FALSE;
         }
         else
         {
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
            o_MapDescriptionListSet.vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
            oCallStack.bGoUp();
            oPath.bGoUp();
         }
      }
   } break;
   case teafi_tclToken::EN_E8_MAPELEMENTDESCRTYPE:
   {
      fi_tcl_e8_MapElementDescrType o_e8_MapElementDescrType;
      if (!bDoIt(o_e8_MapElementDescrType))
         return FALSE;
      oCallStack.bGoUp();
      oPath.bGoUp();
   } break;
   case teafi_tclToken::EN_MAPELEMENTDESCRIPTORUNION0:
   {
      oPath.bGoUp();
      oCallStack.bGoUp();
      fi_tcl_e8_MapElementDescrType oDataType;
      oCallStack.bGoDown(teafi_tclKnot(teafi_tclToken::EN_E8_MAPELEMENTDESCRTYPE,teafi_tclSemanticDomain::EN_DATA_TYPE));
      poVisitor->oIterator = oCallStack.oGetIterator();
      bDoIt(oDataType);
      oCallStack.bGoUp();
      switch (oDataType.enType)
      {
      case fi_tcl_e8_MapElementDescrType::FI_EN_T_RESERVED:
         oPath.bGoDown(teafi_tclKnot(teafi_tclToken::EN_RESERVED,teafi_tclSemanticDomain::EN_MAPELEMENTDESCRDATA));
         break;
      case fi_tcl_e8_MapElementDescrType::FI_EN_TSTRING:
         oPath.bGoDown(teafi_tclKnot(teafi_tclToken::EN_STRING,teafi_tclSemanticDomain::EN_MAPELEMENTDESCRDATA));
         break;
      case fi_tcl_e8_MapElementDescrType::FI_EN_T_MAPGEOGRAPHICTYPE:
         oPath.bGoDown(teafi_tclKnot(teafi_tclToken::EN_MAPGEOGRAPHICTYPE,teafi_tclSemanticDomain::EN_MAPELEMENTDESCRDATA));
         break;
      case fi_tcl_e8_MapElementDescrType::FI_EN_T_E8_ROADCLASSCODE:
         oPath.bGoDown(teafi_tclKnot(teafi_tclToken::EN_E8_ROADCLASSCODE,teafi_tclSemanticDomain::EN_MAPELEMENTDESCRDATA));
         break;
      case fi_tcl_e8_MapElementDescrType::FI_EN_T_B16_ROADATTRIBUTE:
         oPath.bGoDown(teafi_tclKnot(teafi_tclToken::EN_B16_ROADATTRIBUTE,teafi_tclSemanticDomain::EN_MAPELEMENTDESCRDATA));
         break;
      case fi_tcl_e8_MapElementDescrType::FI_EN_T_ROADNUMBER:
         oPath.bGoDown(teafi_tclKnot(teafi_tclToken::EN_ROADNUMBER,teafi_tclSemanticDomain::EN_MAPELEMENTDESCRDATA));
         break;
      case fi_tcl_e8_MapElementDescrType::FI_EN_T_E8_SURFACECOVERCODE:
         oPath.bGoDown(teafi_tclKnot(teafi_tclToken::EN_E8_SURFACECOVERCODE,teafi_tclSemanticDomain::EN_MAPELEMENTDESCRDATA));
         break;
      case fi_tcl_e8_MapElementDescrType::FI_EN_T_E16_NAVIEVENTVALUE:
         oPath.bGoDown(teafi_tclKnot(teafi_tclToken::EN_E16_NAVIEVENTVALUE,teafi_tclSemanticDomain::EN_MAPELEMENTDESCRDATA));
         break;
      case fi_tcl_e8_MapElementDescrType::FI_EN_TMULTILANGUAGESTRING:
         oPath.bGoDown(teafi_tclKnot(teafi_tclToken::EN_MULTILANGUAGESTRING,teafi_tclSemanticDomain::EN_MAPELEMENTDESCRDATA));
         break;
      }
   } break;
   case teafi_tclToken::EN_MAPELEMENTDESCRIPTOR:
   {
      if (poVisitor->bDoExpand_MapElementDescriptor(enSemanticDomain))
      {
         oPath.bGoUp();
         oPath.bGoDown(teafi_tclKnot(teafi_tclToken::EN_END_OF_STRUCT,teafi_tclSemanticDomain::EN_UNKNOWN));
         oPath.bGoDown(teafi_tclKnot(teafi_tclToken::EN_MAPELEMENTDESCRIPTORUNION0,teafi_tclSemanticDomain::EN_MAPELEMENTDESCRDATA));
      }
      else
      {
         fi_tcl_MapElementDescriptor o_MapElementDescriptor;
         if (!bDoIt(o_MapElementDescriptor))
         {
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
            o_MapElementDescriptor.vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
            return FALSE;
         }
         else
         {
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
            o_MapElementDescriptor.vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
            oCallStack.bGoUp();
            oPath.bGoUp();
         }
      }
   } break;
   case teafi_tclToken::EN_MAPELEMENTDESCRIPTION:
   {
      if (poVisitor->bDoExpand_MapElementDescription(enSemanticDomain))
      {
         oPath.bGoUp();
         oPath.bGoDown(teafi_tclKnot(teafi_tclToken::EN_END_OF_STRUCT,teafi_tclSemanticDomain::EN_UNKNOWN));
         oPath.bGoDown(teafi_tclKnot(teafi_tclToken::EN_MAPELEMENTDESCRIPTOR,teafi_tclSemanticDomain::EN_LIST_ELEMENT,0));
         oPath.bGoDown(teafi_tclKnot(teafi_tclToken::EN_LIST,teafi_tclSemanticDomain::EN_DESCRIPTION));
      }
      else
      {
         fi_tcl_MapElementDescription o_MapElementDescription;
         if (!bDoIt(o_MapElementDescription))
         {
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
            o_MapElementDescription.vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
            return FALSE;
         }
         else
         {
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
            o_MapElementDescription.vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
            oCallStack.bGoUp();
            oPath.bGoUp();
         }
      }
   } break;
   case teafi_tclToken::EN_E8_MAPGEOMETRICTYPE:
   {
      fi_tcl_e8_MapGeometricType o_e8_MapGeometricType;
      if (!bDoIt(o_e8_MapGeometricType))
         return FALSE;
      oCallStack.bGoUp();
      oPath.bGoUp();
   } break;
   case teafi_tclToken::EN_E16_SELECTIONCRITERIONTYPE:
   {
      fi_tcl_e16_SelectionCriterionType o_e16_SelectionCriterionType;
      if (!bDoIt(o_e16_SelectionCriterionType))
         return FALSE;
      oCallStack.bGoUp();
      oPath.bGoUp();
   } break;
   case teafi_tclToken::EN_E8_SURFACECOVERCODE:
   {
      fi_tcl_e8_SurfaceCoverCode o_e8_SurfaceCoverCode;
      if (!bDoIt(o_e8_SurfaceCoverCode))
         return FALSE;
      oCallStack.bGoUp();
      oPath.bGoUp();
   } break;
   case teafi_tclToken::EN_U16_USERTRAFFICMESSAGEHANDLE:
   {
      fi_tcl_u16_UserTrafficMessageHandle o_u16_UserTrafficMessageHandle;
      if (!bDoIt(o_u16_UserTrafficMessageHandle))
         return FALSE;
      oCallStack.bGoUp();
      oPath.bGoUp();
   } break;
   case teafi_tclToken::EN_E8_LANESTATUS:
   {
      fi_tcl_e8_LaneStatus o_e8_LaneStatus;
      if (!bDoIt(o_e8_LaneStatus))
         return FALSE;
      oCallStack.bGoUp();
      oPath.bGoUp();
   } break;
   case teafi_tclToken::EN_B8_LANETYPE:
   {
      fi_tcl_b8_LaneType o_b8_LaneType;
      if (!bDoIt(o_b8_LaneType))
         return FALSE;
      oCallStack.bGoUp();
      oPath.bGoUp();
   } break;
   case teafi_tclToken::EN_B8_LANECHANGERESTRICTION:
   {
      fi_tcl_b8_LaneChangeRestriction o_b8_LaneChangeRestriction;
      if (!bDoIt(o_b8_LaneChangeRestriction))
         return FALSE;
      oCallStack.bGoUp();
      oPath.bGoUp();
   } break;
   case teafi_tclToken::EN_U8_INDEXINLANEINFOSEGMENTLIST:
   {
      fi_tcl_u8_IndexInLaneInfoSegmentList o_u8_IndexInLaneInfoSegmentList;
      if (!bDoIt(o_u8_IndexInLaneInfoSegmentList))
         return FALSE;
      oCallStack.bGoUp();
      oPath.bGoUp();
   } break;
   case teafi_tclToken::EN_U8_INDEXINLANEINFOLIST:
   {
      fi_tcl_u8_IndexInLaneInfoList o_u8_IndexInLaneInfoList;
      if (!bDoIt(o_u8_IndexInLaneInfoList))
         return FALSE;
      oCallStack.bGoUp();
      oPath.bGoUp();
   } break;
   case teafi_tclToken::EN_U8_DRIVINGDIRECTION:
   {
      fi_tcl_u8_DrivingDirection o_u8_DrivingDirection;
      if (!bDoIt(o_u8_DrivingDirection))
         return FALSE;
      oCallStack.bGoUp();
      oPath.bGoUp();
   } break;
   case teafi_tclToken::EN_LANEDIRECTION:
   {
      if (poVisitor->bDoExpand_LaneDirection(enSemanticDomain))
      {
         oPath.bGoUp();
         oPath.bGoDown(teafi_tclKnot(teafi_tclToken::EN_END_OF_STRUCT,teafi_tclSemanticDomain::EN_UNKNOWN));
         oPath.bGoDown(teafi_tclKnot(teafi_tclToken::EN_B8_LANETYPE,teafi_tclSemanticDomain::EN_FOLLOWINGLANETYPE));
         oPath.bGoDown(teafi_tclKnot(teafi_tclToken::EN_E8_LANESTATUS,teafi_tclSemanticDomain::EN_FOLLOWINGLANESTATUS));
         oPath.bGoDown(teafi_tclKnot(teafi_tclToken::EN_U8_DRIVINGDIRECTION,teafi_tclSemanticDomain::EN_DIRECTIONTOFOLLOWINGLANE));
      }
      else
      {
         fi_tcl_LaneDirection o_LaneDirection;
         if (!bDoIt(o_LaneDirection))
         {
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
            o_LaneDirection.vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
            return FALSE;
         }
         else
         {
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
            o_LaneDirection.vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
            oCallStack.bGoUp();
            oPath.bGoUp();
         }
      }
   } break;
   case teafi_tclToken::EN_LANEINFOONECELLREFERENCE:
   {
      if (poVisitor->bDoExpand_LaneInfoOneCellReference(enSemanticDomain))
      {
         oPath.bGoUp();
         oPath.bGoDown(teafi_tclKnot(teafi_tclToken::EN_END_OF_STRUCT,teafi_tclSemanticDomain::EN_UNKNOWN));
         oPath.bGoDown(teafi_tclKnot(teafi_tclToken::EN_U8_INDEXINLANEINFOLIST,teafi_tclSemanticDomain::EN_LANEINDEX));
         oPath.bGoDown(teafi_tclKnot(teafi_tclToken::EN_U8_INDEXINLANEINFOSEGMENTLIST,teafi_tclSemanticDomain::EN_SEGMENTINDEX));
         oPath.bGoDown(teafi_tclKnot(teafi_tclToken::EN_NAVONECELL,teafi_tclSemanticDomain::EN_ONECELL));
      }
      else
      {
         fi_tcl_LaneInfoOneCellReference o_LaneInfoOneCellReference;
         if (!bDoIt(o_LaneInfoOneCellReference))
         {
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
            o_LaneInfoOneCellReference.vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
            return FALSE;
         }
         else
         {
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
            o_LaneInfoOneCellReference.vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
            oCallStack.bGoUp();
            oPath.bGoUp();
         }
      }
   } break;
   case teafi_tclToken::EN_LANEINFOONECELLINDEXREFERENCE:
   {
      if (poVisitor->bDoExpand_LaneInfoOneCellIndexReference(enSemanticDomain))
      {
         oPath.bGoUp();
         oPath.bGoDown(teafi_tclKnot(teafi_tclToken::EN_END_OF_STRUCT,teafi_tclSemanticDomain::EN_UNKNOWN));
         oPath.bGoDown(teafi_tclKnot(teafi_tclToken::EN_U8_INDEXINLANEINFOLIST,teafi_tclSemanticDomain::EN_LANEINDEX));
         oPath.bGoDown(teafi_tclKnot(teafi_tclToken::EN_U8_INDEXINLANEINFOSEGMENTLIST,teafi_tclSemanticDomain::EN_SEGMENTINDEX));
         oPath.bGoDown(teafi_tclKnot(teafi_tclToken::EN_U16_INDEXINREFERENCELIST,teafi_tclSemanticDomain::EN_ONECELLINDEX));
      }
      else
      {
         fi_tcl_LaneInfoOneCellIndexReference o_LaneInfoOneCellIndexReference;
         if (!bDoIt(o_LaneInfoOneCellIndexReference))
         {
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
            o_LaneInfoOneCellIndexReference.vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
            return FALSE;
         }
         else
         {
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
            o_LaneInfoOneCellIndexReference.vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
            oCallStack.bGoUp();
            oPath.bGoUp();
         }
      }
   } break;
   case teafi_tclToken::EN_LANEINFOPATHSECTIONINDEXREFERENCE:
   {
      if (poVisitor->bDoExpand_LaneInfoPathSectionIndexReference(enSemanticDomain))
      {
         oPath.bGoUp();
         oPath.bGoDown(teafi_tclKnot(teafi_tclToken::EN_END_OF_STRUCT,teafi_tclSemanticDomain::EN_UNKNOWN));
         oPath.bGoDown(teafi_tclKnot(teafi_tclToken::EN_U8_INDEXINLANEINFOLIST,teafi_tclSemanticDomain::EN_LANEINDEX));
         oPath.bGoDown(teafi_tclKnot(teafi_tclToken::EN_U8_INDEXINLANEINFOSEGMENTLIST,teafi_tclSemanticDomain::EN_SEGMENTINDEX));
         oPath.bGoDown(teafi_tclKnot(teafi_tclToken::EN_U16_INDEXINREFERENCELIST,teafi_tclSemanticDomain::EN_PATHSECTIONINDEX));
      }
      else
      {
         fi_tcl_LaneInfoPathSectionIndexReference o_LaneInfoPathSectionIndexReference;
         if (!bDoIt(o_LaneInfoPathSectionIndexReference))
         {
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
            o_LaneInfoPathSectionIndexReference.vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
            return FALSE;
         }
         else
         {
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
            o_LaneInfoPathSectionIndexReference.vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
            oCallStack.bGoUp();
            oPath.bGoUp();
         }
      }
   } break;
   case teafi_tclToken::EN_LANEINFOELEMENTREFERENCE:
   {
      if (poVisitor->bDoExpand_LaneInfoElementReference(enSemanticDomain))
      {
         oPath.bGoUp();
         oPath.bGoDown(teafi_tclKnot(teafi_tclToken::EN_END_OF_STRUCT,teafi_tclSemanticDomain::EN_UNKNOWN));
         oPath.bGoDown(teafi_tclKnot(teafi_tclToken::EN_U8_INDEXINLANEINFOLIST,teafi_tclSemanticDomain::EN_LANEINDEX));
         oPath.bGoDown(teafi_tclKnot(teafi_tclToken::EN_U16,teafi_tclSemanticDomain::EN_ELEMENTID));
      }
      else
      {
         fi_tcl_LaneInfoElementReference o_LaneInfoElementReference;
         if (!bDoIt(o_LaneInfoElementReference))
         {
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
            o_LaneInfoElementReference.vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
            return FALSE;
         }
         else
         {
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
            o_LaneInfoElementReference.vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
            oCallStack.bGoUp();
            oPath.bGoUp();
         }
      }
   } break;
   case teafi_tclToken::EN_E8_LANEREFERENCECATEGORY:
   {
      fi_tcl_e8_LaneReferenceCategory o_e8_LaneReferenceCategory;
      if (!bDoIt(o_e8_LaneReferenceCategory))
         return FALSE;
      oCallStack.bGoUp();
      oPath.bGoUp();
   } break;
   case teafi_tclToken::EN_LANEREFERENCEUNION0:
   {
      oPath.bGoUp();
      oCallStack.bGoUp();
      fi_tcl_e8_LaneReferenceCategory oDataType;
      oCallStack.bGoDown(teafi_tclKnot(teafi_tclToken::EN_E8_LANEREFERENCECATEGORY,teafi_tclSemanticDomain::EN_DATA_TYPE));
      poVisitor->oIterator = oCallStack.oGetIterator();
      bDoIt(oDataType);
      oCallStack.bGoUp();
      if ((oDataType.enType == fi_tcl_e8_LaneReferenceCategory::FI_EN_T_LANEINFOPATHSECTIONINDEXREFERENCE) &&
          !(11 <= u16MajorVersion))
      {
         oDataType.enType = fi_tcl_e8_LaneReferenceCategory::FI_EN_T_LANEINFOONECELLINDEXREFERENCE;
      }
      switch (oDataType.enType)
      {
      case fi_tcl_e8_LaneReferenceCategory::FI_EN_T_RESERVED:
         oPath.bGoDown(teafi_tclKnot(teafi_tclToken::EN_RESERVED,teafi_tclSemanticDomain::EN_LANEREFERENCECATEGORY));
         break;
      case fi_tcl_e8_LaneReferenceCategory::FI_EN_T_LANEINFOONECELLREFERENCE:
         oPath.bGoDown(teafi_tclKnot(teafi_tclToken::EN_LANEINFOONECELLREFERENCE,teafi_tclSemanticDomain::EN_LANEREFERENCECATEGORY));
         break;
      case fi_tcl_e8_LaneReferenceCategory::FI_EN_T_LANEINFOONECELLINDEXREFERENCE:
         oPath.bGoDown(teafi_tclKnot(teafi_tclToken::EN_LANEINFOONECELLINDEXREFERENCE,teafi_tclSemanticDomain::EN_LANEREFERENCECATEGORY));
         break;
      case fi_tcl_e8_LaneReferenceCategory::FI_EN_T_LANEINFOELEMENTREFERENCE:
         oPath.bGoDown(teafi_tclKnot(teafi_tclToken::EN_LANEINFOELEMENTREFERENCE,teafi_tclSemanticDomain::EN_LANEREFERENCECATEGORY));
         break;
      case fi_tcl_e8_LaneReferenceCategory::FI_EN_T_LANEINFOPATHSECTIONINDEXREFERENCE:
         oPath.bGoDown(teafi_tclKnot(teafi_tclToken::EN_LANEINFOPATHSECTIONINDEXREFERENCE,teafi_tclSemanticDomain::EN_LANEREFERENCECATEGORY));
         break;
      }
   } break;
   case teafi_tclToken::EN_LANEREFERENCE:
   {
      if (poVisitor->bDoExpand_LaneReference(enSemanticDomain))
      {
         oPath.bGoUp();
         oPath.bGoDown(teafi_tclKnot(teafi_tclToken::EN_END_OF_STRUCT,teafi_tclSemanticDomain::EN_UNKNOWN));
         oPath.bGoDown(teafi_tclKnot(teafi_tclToken::EN_LANEDIRECTION,teafi_tclSemanticDomain::EN_LANEDIRECTION));
         oPath.bGoDown(teafi_tclKnot(teafi_tclToken::EN_LANEREFERENCEUNION0,teafi_tclSemanticDomain::EN_LANEREFERENCECATEGORY));
      }
      else
      {
         fi_tcl_LaneReference o_LaneReference;
         if (!bDoIt(o_LaneReference))
         {
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
            o_LaneReference.vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
            return FALSE;
         }
         else
         {
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
            o_LaneReference.vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
            oCallStack.bGoUp();
            oPath.bGoUp();
         }
      }
   } break;
   case teafi_tclToken::EN_LANEINFO:
   {
      if (poVisitor->bDoExpand_LaneInfo(enSemanticDomain))
      {
         oPath.bGoUp();
         oPath.bGoDown(teafi_tclKnot(teafi_tclToken::EN_END_OF_STRUCT,teafi_tclSemanticDomain::EN_UNKNOWN));
         oPath.bGoDown(teafi_tclKnot(teafi_tclToken::EN_LANEREFERENCE,teafi_tclSemanticDomain::EN_LIST_ELEMENT,0));
         oPath.bGoDown(teafi_tclKnot(teafi_tclToken::EN_LIST,teafi_tclSemanticDomain::EN_FOLLOWINGLANELIST));
         oPath.bGoDown(teafi_tclKnot(teafi_tclToken::EN_B8_LANECHANGERESTRICTION,teafi_tclSemanticDomain::EN_CHANGERESTRICTION));
         oPath.bGoDown(teafi_tclKnot(teafi_tclToken::EN_B8_LANETYPE,teafi_tclSemanticDomain::EN_TYPE));
         oPath.bGoDown(teafi_tclKnot(teafi_tclToken::EN_E8_LANESTATUS,teafi_tclSemanticDomain::EN_STATUS));
      }
      else
      {
         fi_tcl_LaneInfo o_LaneInfo;
         if (!bDoIt(o_LaneInfo))
         {
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
            o_LaneInfo.vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
            return FALSE;
         }
         else
         {
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
            o_LaneInfo.vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
            oCallStack.bGoUp();
            oPath.bGoUp();
         }
      }
   } break;
   case teafi_tclToken::EN_LANEINFOSEGMENT:
   {
      if (poVisitor->bDoExpand_LaneInfoSegment(enSemanticDomain))
      {
         oPath.bGoUp();
         oPath.bGoDown(teafi_tclKnot(teafi_tclToken::EN_END_OF_STRUCT,teafi_tclSemanticDomain::EN_UNKNOWN));
         oPath.bGoDown(teafi_tclKnot(teafi_tclToken::EN_LANEINFO,teafi_tclSemanticDomain::EN_LIST_ELEMENT,0));
         oPath.bGoDown(teafi_tclKnot(teafi_tclToken::EN_LIST,teafi_tclSemanticDomain::EN_LANEINFOLIST));
         oPath.bGoDown(teafi_tclKnot(teafi_tclToken::EN_S32_EMU,teafi_tclSemanticDomain::EN_OFFSET));
      }
      else
      {
         fi_tcl_LaneInfoSegment o_LaneInfoSegment;
         if (!bDoIt(o_LaneInfoSegment))
         {
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
            o_LaneInfoSegment.vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
            return FALSE;
         }
         else
         {
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
            o_LaneInfoSegment.vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
            oCallStack.bGoUp();
            oPath.bGoUp();
         }
      }
   } break;
   case teafi_tclToken::EN_LANEINFOSEGMENTLIST:
   {
      if (poVisitor->bDoExpand_LaneInfoSegmentList(enSemanticDomain))
      {
         oPath.bGoUp();
         oPath.bGoDown(teafi_tclKnot(teafi_tclToken::EN_END_OF_STRUCT,teafi_tclSemanticDomain::EN_UNKNOWN));
         oPath.bGoDown(teafi_tclKnot(teafi_tclToken::EN_LANEINFOSEGMENT,teafi_tclSemanticDomain::EN_LIST_ELEMENT,0));
         oPath.bGoDown(teafi_tclKnot(teafi_tclToken::EN_LIST,teafi_tclSemanticDomain::EN_LANEINFOSEGMENTLIST));
      }
      else
      {
         fi_tcl_LaneInfoSegmentList o_LaneInfoSegmentList;
         if (!bDoIt(o_LaneInfoSegmentList))
         {
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
            o_LaneInfoSegmentList.vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
            return FALSE;
         }
         else
         {
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
            o_LaneInfoSegmentList.vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
            oCallStack.bGoUp();
            oPath.bGoUp();
         }
      }
   } break;
   case teafi_tclToken::EN_LANEINFOLISTSET:
   {
      if (poVisitor->bDoExpand_LaneInfoListSet(enSemanticDomain))
      {
         oPath.bGoUp();
         oPath.bGoDown(teafi_tclKnot(teafi_tclToken::EN_END_OF_STRUCT,teafi_tclSemanticDomain::EN_UNKNOWN));
         oPath.bGoDown(teafi_tclKnot(teafi_tclToken::EN_LANEINFOSEGMENTLIST,teafi_tclSemanticDomain::EN_LIST_ELEMENT,0));
         oPath.bGoDown(teafi_tclKnot(teafi_tclToken::EN_LIST,teafi_tclSemanticDomain::EN_LANEINFOSEGMENTLISTLIST));
         oPath.bGoDown(teafi_tclKnot(teafi_tclToken::EN_REFERENCEELEMENT,teafi_tclSemanticDomain::EN_LIST_ELEMENT,0));
         oPath.bGoDown(teafi_tclKnot(teafi_tclToken::EN_LIST,teafi_tclSemanticDomain::EN_ALTERNATIVREFLIST));
      }
      else
      {
         fi_tcl_LaneInfoListSet o_LaneInfoListSet;
         if (!bDoIt(o_LaneInfoListSet))
         {
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
            o_LaneInfoListSet.vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
            return FALSE;
         }
         else
         {
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
            o_LaneInfoListSet.vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
            oCallStack.bGoUp();
            oPath.bGoUp();
         }
      }
   } break;
   case teafi_tclToken::EN_E8_TMGEOMETRICMESSAGETYPE:
   {
      fi_tcl_e8_TMGeometricMessageType o_e8_TMGeometricMessageType;
      if (!bDoIt(o_e8_TMGeometricMessageType))
         return FALSE;
      oCallStack.bGoUp();
      oPath.bGoUp();
   } break;
   case teafi_tclToken::EN_E16_NAVIEVENTVALUE:
   {
      fi_tcl_e16_NaviEventValue o_e16_NaviEventValue;
      if (!bDoIt(o_e16_NaviEventValue))
         return FALSE;
      oCallStack.bGoUp();
      oPath.bGoUp();
   } break;
   case teafi_tclToken::EN_E8_TMAFFECTIONTYPE:
   {
      fi_tcl_e8_TMAffectionType o_e8_TMAffectionType;
      if (!bDoIt(o_e8_TMAffectionType))
         return FALSE;
      oCallStack.bGoUp();
      oPath.bGoUp();
   } break;
   case teafi_tclToken::EN_UPOI_CATEGORY:
   {
      if (poVisitor->bDoExpand_UPOI_Category(enSemanticDomain))
      {
         oPath.bGoUp();
         oPath.bGoDown(teafi_tclKnot(teafi_tclToken::EN_END_OF_STRUCT,teafi_tclSemanticDomain::EN_UNKNOWN));
         oPath.bGoDown(teafi_tclKnot(teafi_tclToken::EN_U32,teafi_tclSemanticDomain::EN_VALUE));
      }
      else
      {
         fi_tcl_UPOI_Category o_UPOI_Category;
         if (!bDoIt(o_UPOI_Category))
         {
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
            o_UPOI_Category.vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
            return FALSE;
         }
         else
         {
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
            o_UPOI_Category.vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
            oCallStack.bGoUp();
            oPath.bGoUp();
         }
      }
   } break;
   case teafi_tclToken::EN_E8_UPOI_SOURCE:
   {
      fi_tcl_e8_UPOI_Source o_e8_UPOI_Source;
      if (!bDoIt(o_e8_UPOI_Source))
         return FALSE;
      oCallStack.bGoUp();
      oPath.bGoUp();
   } break;
   case teafi_tclToken::EN_B16_UPOI_SOURCE:
   {
      fi_tcl_b16_UPOI_Source o_b16_UPOI_Source;
      if (!bDoIt(o_b16_UPOI_Source))
         return FALSE;
      oCallStack.bGoUp();
      oPath.bGoUp();
   } break;
   case teafi_tclToken::EN_B8_UPOI_FILTERSETSTATUS:
   {
      fi_tcl_b8_UPOI_FilterSetStatus o_b8_UPOI_FilterSetStatus;
      if (!bDoIt(o_b8_UPOI_FilterSetStatus))
         return FALSE;
      oCallStack.bGoUp();
      oPath.bGoUp();
   } break;
   case teafi_tclToken::EN_B8_UPOI_VALIDITY:
   {
      fi_tcl_b8_UPOI_Validity o_b8_UPOI_Validity;
      if (!bDoIt(o_b8_UPOI_Validity))
         return FALSE;
      oCallStack.bGoUp();
      oPath.bGoUp();
   } break;
   case teafi_tclToken::EN_UPOI_ELEMENT:
   {
      if (poVisitor->bDoExpand_UPOI_Element(enSemanticDomain))
      {
         oPath.bGoUp();
         oPath.bGoDown(teafi_tclKnot(teafi_tclToken::EN_END_OF_STRUCT,teafi_tclSemanticDomain::EN_UNKNOWN));
         if (17 <= u16MajorVersion)
         {
            oPath.bGoDown(teafi_tclKnot(teafi_tclToken::EN_POSITIONWGS84,teafi_tclSemanticDomain::EN_PERPENDICULARPOINTPOSITION));
         }
         oPath.bGoDown(teafi_tclKnot(teafi_tclToken::EN_POSITIONWGS84,teafi_tclSemanticDomain::EN_POSITION));
         oPath.bGoDown(teafi_tclKnot(teafi_tclToken::EN_STRING,teafi_tclSemanticDomain::EN_SHORTDESCRIPTION));
         oPath.bGoDown(teafi_tclKnot(teafi_tclToken::EN_STRING,teafi_tclSemanticDomain::EN_NAME));
         oPath.bGoDown(teafi_tclKnot(teafi_tclToken::EN_E8_UPOI_SOURCE,teafi_tclSemanticDomain::EN_SOURCE));
         oPath.bGoDown(teafi_tclKnot(teafi_tclToken::EN_UPOI_CATEGORY,teafi_tclSemanticDomain::EN_CATEGORY));
         oPath.bGoDown(teafi_tclKnot(teafi_tclToken::EN_U32,teafi_tclSemanticDomain::EN_UNIQUEID));
      }
      else
      {
         fi_tcl_UPOI_Element o_UPOI_Element;
         if (!bDoIt(o_UPOI_Element))
         {
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
            o_UPOI_Element.vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
            return FALSE;
         }
         else
         {
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
            o_UPOI_Element.vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
            oCallStack.bGoUp();
            oPath.bGoUp();
         }
      }
   } break;
   case teafi_tclToken::EN_B8_UPOI_FILTERSET_FIELDRELEVANCE:
   {
      fi_tcl_b8_UPOI_FilterSet_FieldRelevance o_b8_UPOI_FilterSet_FieldRelevance;
      if (!bDoIt(o_b8_UPOI_FilterSet_FieldRelevance))
         return FALSE;
      oCallStack.bGoUp();
      oPath.bGoUp();
   } break;
   case teafi_tclToken::EN_UPOI_FILTERSET:
   {
      if (poVisitor->bDoExpand_UPOI_FilterSet(enSemanticDomain))
      {
         oPath.bGoUp();
         oPath.bGoDown(teafi_tclKnot(teafi_tclToken::EN_END_OF_STRUCT,teafi_tclSemanticDomain::EN_UNKNOWN));
         oPath.bGoDown(teafi_tclKnot(teafi_tclToken::EN_B8_UPOI_FILTERSETSTATUS,teafi_tclSemanticDomain::EN_STATUS));
         oPath.bGoDown(teafi_tclKnot(teafi_tclToken::EN_UPOI_CATEGORY,teafi_tclSemanticDomain::EN_CATEGORY));
         oPath.bGoDown(teafi_tclKnot(teafi_tclToken::EN_E8_UPOI_SOURCE,teafi_tclSemanticDomain::EN_SOURCE));
         oPath.bGoDown(teafi_tclKnot(teafi_tclToken::EN_B8_UPOI_FILTERSET_FIELDRELEVANCE,teafi_tclSemanticDomain::EN_RELEVANCE));
      }
      else
      {
         fi_tcl_UPOI_FilterSet o_UPOI_FilterSet;
         if (!bDoIt(o_UPOI_FilterSet))
         {
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
            o_UPOI_FilterSet.vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
            return FALSE;
         }
         else
         {
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
            o_UPOI_FilterSet.vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
            oCallStack.bGoUp();
            oPath.bGoUp();
         }
      }
   } break;
   case teafi_tclToken::EN_UPOI_FILTERLIST:
   {
      if (poVisitor->bDoExpand_UPOI_FilterList(enSemanticDomain))
      {
         oPath.bGoUp();
         oPath.bGoDown(teafi_tclKnot(teafi_tclToken::EN_END_OF_STRUCT,teafi_tclSemanticDomain::EN_UNKNOWN));
         oPath.bGoDown(teafi_tclKnot(teafi_tclToken::EN_UPOI_FILTERSET,teafi_tclSemanticDomain::EN_LIST_ELEMENT,0));
         oPath.bGoDown(teafi_tclKnot(teafi_tclToken::EN_LIST,teafi_tclSemanticDomain::EN_LIST));
      }
      else
      {
         fi_tcl_UPOI_FilterList o_UPOI_FilterList;
         if (!bDoIt(o_UPOI_FilterList))
         {
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
            o_UPOI_FilterList.vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
            return FALSE;
         }
         else
         {
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
            o_UPOI_FilterList.vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
            oCallStack.bGoUp();
            oPath.bGoUp();
         }
      }
   } break;
   case teafi_tclToken::EN_B8_UPOI_STATUS:
   {
      fi_tcl_b8_UPOI_Status o_b8_UPOI_Status;
      if (!bDoIt(o_b8_UPOI_Status))
         return FALSE;
      oCallStack.bGoUp();
      oPath.bGoUp();
   } break;
   case teafi_tclToken::EN_UPOI_COMBINATION:
   {
      if (poVisitor->bDoExpand_UPOI_Combination(enSemanticDomain))
      {
         oPath.bGoUp();
         oPath.bGoDown(teafi_tclKnot(teafi_tclToken::EN_END_OF_STRUCT,teafi_tclSemanticDomain::EN_UNKNOWN));
         if (17 <= u16MajorVersion)
         {
            oPath.bGoDown(teafi_tclKnot(teafi_tclToken::EN_B8_UPOI_STATUS,teafi_tclSemanticDomain::EN_UPOISTATUS));
         }
         oPath.bGoDown(teafi_tclKnot(teafi_tclToken::EN_POSITIONWGS84,teafi_tclSemanticDomain::EN_PERPENDICULARPOINTPOSITION));
         oPath.bGoDown(teafi_tclKnot(teafi_tclToken::EN_S16_PERTHOUSAND,teafi_tclSemanticDomain::EN_ONROADOFFSET));
         oPath.bGoDown(teafi_tclKnot(teafi_tclToken::EN_B8_UPOI_VALIDITY,teafi_tclSemanticDomain::EN_DATAVALIDITY));
         oPath.bGoDown(teafi_tclKnot(teafi_tclToken::EN_U32,teafi_tclSemanticDomain::EN_ID));
         oPath.bGoDown(teafi_tclKnot(teafi_tclToken::EN_U16_INDEXINREFERENCELIST,teafi_tclSemanticDomain::EN_REFLIST));
         oPath.bGoDown(teafi_tclKnot(teafi_tclToken::EN_U16_INDEXINREFERENCELIST,teafi_tclSemanticDomain::EN_BASELIST));
      }
      else
      {
         fi_tcl_UPOI_Combination o_UPOI_Combination;
         if (!bDoIt(o_UPOI_Combination))
         {
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
            o_UPOI_Combination.vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
            return FALSE;
         }
         else
         {
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
            o_UPOI_Combination.vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
            oCallStack.bGoUp();
            oPath.bGoUp();
         }
      }
   } break;
   case teafi_tclToken::EN_UPOI_LISTSET:
   {
      if (poVisitor->bDoExpand_UPOI_ListSet(enSemanticDomain))
      {
         oPath.bGoUp();
         oPath.bGoDown(teafi_tclKnot(teafi_tclToken::EN_END_OF_STRUCT,teafi_tclSemanticDomain::EN_UNKNOWN));
         oPath.bGoDown(teafi_tclKnot(teafi_tclToken::EN_UPOI_ELEMENT,teafi_tclSemanticDomain::EN_LIST_ELEMENT,0));
         oPath.bGoDown(teafi_tclKnot(teafi_tclToken::EN_LIST,teafi_tclSemanticDomain::EN_UPOI_REFLIST));
         oPath.bGoDown(teafi_tclKnot(teafi_tclToken::EN_UPOI_COMBINATION,teafi_tclSemanticDomain::EN_LIST_ELEMENT,0));
         oPath.bGoDown(teafi_tclKnot(teafi_tclToken::EN_LIST,teafi_tclSemanticDomain::EN_COMBINATIONLIST));
      }
      else
      {
         fi_tcl_UPOI_ListSet o_UPOI_ListSet;
         if (!bDoIt(o_UPOI_ListSet))
         {
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
            o_UPOI_ListSet.vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
            return FALSE;
         }
         else
         {
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
            o_UPOI_ListSet.vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
            oCallStack.bGoUp();
            oPath.bGoUp();
         }
      }
   } break;
   case teafi_tclToken::EN_E8_SHAPETYPE:
   {
      fi_tcl_e8_ShapeType o_e8_ShapeType;
      if (!bDoIt(o_e8_ShapeType))
         return FALSE;
      oCallStack.bGoUp();
      oPath.bGoUp();
   } break;
   case teafi_tclToken::EN_SHAPE:
   {
      if (poVisitor->bDoExpand_Shape(enSemanticDomain))
      {
         oPath.bGoUp();
         oPath.bGoDown(teafi_tclKnot(teafi_tclToken::EN_END_OF_STRUCT,teafi_tclSemanticDomain::EN_UNKNOWN));
         oPath.bGoDown(teafi_tclKnot(teafi_tclToken::EN_POSITIONWGS84,teafi_tclSemanticDomain::EN_LIST_ELEMENT,0));
         oPath.bGoDown(teafi_tclKnot(teafi_tclToken::EN_LIST,teafi_tclSemanticDomain::EN_SHAPEPOINTS));
         oPath.bGoDown(teafi_tclKnot(teafi_tclToken::EN_E8_SHAPETYPE,teafi_tclSemanticDomain::EN_SHAPETYPE));
      }
      else
      {
         fi_tcl_Shape o_Shape;
         if (!bDoIt(o_Shape))
         {
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
            o_Shape.vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
            return FALSE;
         }
         else
         {
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
            o_Shape.vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
            oCallStack.bGoUp();
            oPath.bGoUp();
         }
      }
   } break;
   case teafi_tclToken::EN_RDBID:
   {
      if (poVisitor->bDoExpand_RDBId(enSemanticDomain))
      {
         oPath.bGoUp();
         oPath.bGoDown(teafi_tclKnot(teafi_tclToken::EN_END_OF_STRUCT,teafi_tclSemanticDomain::EN_UNKNOWN));
         if (11 <= u16MajorVersion)
         {
            oPath.bGoDown(teafi_tclKnot(teafi_tclToken::EN_U16,teafi_tclSemanticDomain::EN_BSA));
         }
         oPath.bGoDown(teafi_tclKnot(teafi_tclToken::EN_U8,teafi_tclSemanticDomain::EN_TABLENO));
         oPath.bGoDown(teafi_tclKnot(teafi_tclToken::EN_U8,teafi_tclSemanticDomain::EN_TMCCOUNTRYCODE));
      }
      else
      {
         fi_tcl_RDBId o_RDBId;
         if (!bDoIt(o_RDBId))
         {
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
            o_RDBId.vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
            return FALSE;
         }
         else
         {
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
            o_RDBId.vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
            oCallStack.bGoUp();
            oPath.bGoUp();
         }
      }
   } break;
   case teafi_tclToken::EN_TMPROGRAMSERVICE:
   {
      if (poVisitor->bDoExpand_TMProgramService(enSemanticDomain))
      {
         oPath.bGoUp();
         oPath.bGoDown(teafi_tclKnot(teafi_tclToken::EN_END_OF_STRUCT,teafi_tclSemanticDomain::EN_UNKNOWN));
         oPath.bGoDown(teafi_tclKnot(teafi_tclToken::EN_STRING,teafi_tclSemanticDomain::EN_PROGRAMSERVICENAME));
         oPath.bGoDown(teafi_tclKnot(teafi_tclToken::EN_E16_ISOCOUNTRYCODE,teafi_tclSemanticDomain::EN_COUNTRYCODE));
         if (38 <= u16MajorVersion)
         {
            oPath.bGoDown(teafi_tclKnot(teafi_tclToken::EN_U32,teafi_tclSemanticDomain::EN_EXTENDEDPROGRAMID));
         }
         oPath.bGoDown(teafi_tclKnot(teafi_tclToken::EN_U16,teafi_tclSemanticDomain::EN_PROGRAMID));
      }
      else
      {
         fi_tcl_TMProgramService o_TMProgramService;
         if (!bDoIt(o_TMProgramService))
         {
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
            o_TMProgramService.vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
            return FALSE;
         }
         else
         {
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
            o_TMProgramService.vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
            oCallStack.bGoUp();
            oPath.bGoUp();
         }
      }
   } break;
   case teafi_tclToken::EN_TMSERVICEPROVIDER:
   {
      if (poVisitor->bDoExpand_TMServiceProvider(enSemanticDomain))
      {
         oPath.bGoUp();
         oPath.bGoDown(teafi_tclKnot(teafi_tclToken::EN_END_OF_STRUCT,teafi_tclSemanticDomain::EN_UNKNOWN));
         oPath.bGoDown(teafi_tclKnot(teafi_tclToken::EN_STRING,teafi_tclSemanticDomain::EN_SERVICEPROVIDERNAME));
         oPath.bGoDown(teafi_tclKnot(teafi_tclToken::EN_E16_ISOCOUNTRYCODE,teafi_tclSemanticDomain::EN_COUNTRYCODE));
         if (38 <= u16MajorVersion)
         {
            oPath.bGoDown(teafi_tclKnot(teafi_tclToken::EN_U32,teafi_tclSemanticDomain::EN_EXTENDEDSERVICEID));
         }
         oPath.bGoDown(teafi_tclKnot(teafi_tclToken::EN_U8,teafi_tclSemanticDomain::EN_SERVICEID));
      }
      else
      {
         fi_tcl_TMServiceProvider o_TMServiceProvider;
         if (!bDoIt(o_TMServiceProvider))
         {
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
            o_TMServiceProvider.vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
            return FALSE;
         }
         else
         {
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
            o_TMServiceProvider.vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
            oCallStack.bGoUp();
            oPath.bGoUp();
         }
      }
   } break;
   case teafi_tclToken::EN_E8_TMCATEGORY:
   {
      fi_tcl_e8_TMCategory o_e8_TMCategory;
      if (!bDoIt(o_e8_TMCategory))
         return FALSE;
      oCallStack.bGoUp();
      oPath.bGoUp();
   } break;
   case teafi_tclToken::EN_B8_TMMAPPINGPOSSIBILITY:
   {
      fi_tcl_b8_TMMappingPossibility o_b8_TMMappingPossibility;
      if (!bDoIt(o_b8_TMMappingPossibility))
         return FALSE;
      oCallStack.bGoUp();
      oPath.bGoUp();
   } break;
   case teafi_tclToken::EN_B8_TMMAPPINGSTATUS:
   {
      fi_tcl_b8_TMMappingStatus o_b8_TMMappingStatus;
      if (!bDoIt(o_b8_TMMappingStatus))
         return FALSE;
      oCallStack.bGoUp();
      oPath.bGoUp();
   } break;
   case teafi_tclToken::EN_B8_TMONECELLATTRIBUTE:
   {
      fi_tcl_b8_TMOneCellAttribute o_b8_TMOneCellAttribute;
      if (!bDoIt(o_b8_TMOneCellAttribute))
         return FALSE;
      oCallStack.bGoUp();
      oPath.bGoUp();
   } break;
   case teafi_tclToken::EN_TMONECELLPORTION:
   {
      if (poVisitor->bDoExpand_TMOneCellPortion(enSemanticDomain))
      {
         oPath.bGoUp();
         oPath.bGoDown(teafi_tclKnot(teafi_tclToken::EN_END_OF_STRUCT,teafi_tclSemanticDomain::EN_UNKNOWN));
         oPath.bGoDown(teafi_tclKnot(teafi_tclToken::EN_U8_PERCENT,teafi_tclSemanticDomain::EN_LENGTH));
         oPath.bGoDown(teafi_tclKnot(teafi_tclToken::EN_U8_PERCENT,teafi_tclSemanticDomain::EN_OFFSET));
      }
      else
      {
         fi_tcl_TMOneCellPortion o_TMOneCellPortion;
         if (!bDoIt(o_TMOneCellPortion))
         {
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
            o_TMOneCellPortion.vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
            return FALSE;
         }
         else
         {
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
            o_TMOneCellPortion.vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
            oCallStack.bGoUp();
            oPath.bGoUp();
         }
      }
   } break;
   case teafi_tclToken::EN_E8_TMVALUESTATUS:
   {
      fi_tcl_e8_TMValueStatus o_e8_TMValueStatus;
      if (!bDoIt(o_e8_TMValueStatus))
         return FALSE;
      oCallStack.bGoUp();
      oPath.bGoUp();
   } break;
   case teafi_tclToken::EN_E8_TMCINTERSECTIONPATHTYPE:
   {
      fi_tcl_e8_TMCIntersectionPathType o_e8_TMCIntersectionPathType;
      if (!bDoIt(o_e8_TMCIntersectionPathType))
         return FALSE;
      oCallStack.bGoUp();
      oPath.bGoUp();
   } break;
   case teafi_tclToken::EN_TMCSTRUCTUREDTEXT:
   {
      if (poVisitor->bDoExpand_TMCStructuredText(enSemanticDomain))
      {
         oPath.bGoUp();
         oPath.bGoDown(teafi_tclKnot(teafi_tclToken::EN_END_OF_STRUCT,teafi_tclSemanticDomain::EN_UNKNOWN));
         oPath.bGoDown(teafi_tclKnot(teafi_tclToken::EN_STRING,teafi_tclSemanticDomain::EN_LONGSUFFIX));
         oPath.bGoDown(teafi_tclKnot(teafi_tclToken::EN_STRING,teafi_tclSemanticDomain::EN_SHORTSUFFIX));
         oPath.bGoDown(teafi_tclKnot(teafi_tclToken::EN_STRING,teafi_tclSemanticDomain::EN_LONGBODY));
         oPath.bGoDown(teafi_tclKnot(teafi_tclToken::EN_STRING,teafi_tclSemanticDomain::EN_SHORTBODY));
         oPath.bGoDown(teafi_tclKnot(teafi_tclToken::EN_STRING,teafi_tclSemanticDomain::EN_LONGPREFIX));
         oPath.bGoDown(teafi_tclKnot(teafi_tclToken::EN_STRING,teafi_tclSemanticDomain::EN_SHORTPREFIX));
      }
      else
      {
         fi_tcl_TMCStructuredText o_TMCStructuredText;
         if (!bDoIt(o_TMCStructuredText))
         {
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
            o_TMCStructuredText.vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
            return FALSE;
         }
         else
         {
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
            o_TMCStructuredText.vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
            oCallStack.bGoUp();
            oPath.bGoUp();
         }
      }
   } break;
   case teafi_tclToken::EN_E8_TMFLOWIMPACT:
   {
      fi_tcl_e8_TMFlowImpact o_e8_TMFlowImpact;
      if (!bDoIt(o_e8_TMFlowImpact))
         return FALSE;
      oCallStack.bGoUp();
      oPath.bGoUp();
   } break;
   case teafi_tclToken::EN_E8_TMURGENCY:
   {
      fi_tcl_e8_TMUrgency o_e8_TMUrgency;
      if (!bDoIt(o_e8_TMUrgency))
         return FALSE;
      oCallStack.bGoUp();
      oPath.bGoUp();
   } break;
   case teafi_tclToken::EN_E8_TMGEOGRAPHICALPATHRELATIONTYPE:
   {
      fi_tcl_e8_TMGeographicalPathRelationType o_e8_TMGeographicalPathRelationType;
      if (!bDoIt(o_e8_TMGeographicalPathRelationType))
         return FALSE;
      oCallStack.bGoUp();
      oPath.bGoUp();
   } break;
   case teafi_tclToken::EN_B8_TMRELEVANCE:
   {
      fi_tcl_b8_TMRelevance o_b8_TMRelevance;
      if (!bDoIt(o_b8_TMRelevance))
         return FALSE;
      oCallStack.bGoUp();
      oPath.bGoUp();
   } break;
   case teafi_tclToken::EN_E8_TRAFFICMSGTYPE:
   {
      fi_tcl_e8_TrafficMsgType o_e8_TrafficMsgType;
      if (!bDoIt(o_e8_TrafficMsgType))
         return FALSE;
      oCallStack.bGoUp();
      oPath.bGoUp();
   } break;
   case teafi_tclToken::EN_E8_EVENTTYPE:
   {
      fi_tcl_e8_EventType o_e8_EventType;
      if (!bDoIt(o_e8_EventType))
         return FALSE;
      oCallStack.bGoUp();
      oPath.bGoUp();
   } break;
   case teafi_tclToken::EN_B32_TRAFFICMESSAGESOURCE:
   {
      fi_tcl_b32_TrafficMessageSource o_b32_TrafficMessageSource;
      if (!bDoIt(o_b32_TrafficMessageSource))
         return FALSE;
      oCallStack.bGoUp();
      oPath.bGoUp();
   } break;
   case teafi_tclToken::EN_U16_TRIPHANDLE:
   {
      fi_tcl_u16_TripHandle o_u16_TripHandle;
      if (!bDoIt(o_u16_TripHandle))
         return FALSE;
      oCallStack.bGoUp();
      oPath.bGoUp();
   } break;
   case teafi_tclToken::EN_U16_TRIPSEGMENTNUMBER:
   {
      fi_tcl_u16_TripSegmentNumber o_u16_TripSegmentNumber;
      if (!bDoIt(o_u16_TripSegmentNumber))
         return FALSE;
      oCallStack.bGoUp();
      oPath.bGoUp();
   } break;
   case teafi_tclToken::EN_U16_ROUTEHANDLE:
   {
      fi_tcl_u16_RouteHandle o_u16_RouteHandle;
      if (!bDoIt(o_u16_RouteHandle))
         return FALSE;
      oCallStack.bGoUp();
      oPath.bGoUp();
   } break;
   case teafi_tclToken::EN_E8_TMLOCATIONTYPE:
   {
      fi_tcl_e8_TMLocationType o_e8_TMLocationType;
      if (!bDoIt(o_e8_TMLocationType))
         return FALSE;
      oCallStack.bGoUp();
      oPath.bGoUp();
   } break;
   case teafi_tclToken::EN_E16_EFFECTCODE:
   {
      fi_tcl_e16_EffectCode o_e16_EffectCode;
      if (!bDoIt(o_e16_EffectCode))
         return FALSE;
      oCallStack.bGoUp();
      oPath.bGoUp();
   } break;
   case teafi_tclToken::EN_E16_CAUSECODE:
   {
      fi_tcl_e16_CauseCode o_e16_CauseCode;
      if (!bDoIt(o_e16_CauseCode))
         return FALSE;
      oCallStack.bGoUp();
      oPath.bGoUp();
   } break;
   case teafi_tclToken::EN_E8_TENDENCY:
   {
      fi_tcl_e8_Tendency o_e8_Tendency;
      if (!bDoIt(o_e8_Tendency))
         return FALSE;
      oCallStack.bGoUp();
      oPath.bGoUp();
   } break;
   case teafi_tclToken::EN_TMEVENT:
   {
      if (poVisitor->bDoExpand_TMEvent(enSemanticDomain))
      {
         oPath.bGoUp();
         oPath.bGoDown(teafi_tclKnot(teafi_tclToken::EN_END_OF_STRUCT,teafi_tclSemanticDomain::EN_UNKNOWN));
         oPath.bGoDown(teafi_tclKnot(teafi_tclToken::EN_U8,teafi_tclSemanticDomain::EN_PRIORITY));
         if (38 <= u16MajorVersion)
         {
            oPath.bGoDown(teafi_tclKnot(teafi_tclToken::EN_S16_CENTIMETERSECOND,teafi_tclSemanticDomain::EN_AVERAGESPEEDCMPERSEC));
         }
         oPath.bGoDown(teafi_tclKnot(teafi_tclToken::EN_S16_KMPERHOUR,teafi_tclSemanticDomain::EN_AVERAGESPEED));
         if (38 <= u16MajorVersion)
         {
            oPath.bGoDown(teafi_tclKnot(teafi_tclToken::EN_S16_CENTIMETERSECOND,teafi_tclSemanticDomain::EN_SPEEDLIMITADVICECMPERSEC));
         }
         oPath.bGoDown(teafi_tclKnot(teafi_tclToken::EN_S16_KMPERHOUR,teafi_tclSemanticDomain::EN_SPEEDLIMITADVICE));
         if (36 <= u16MajorVersion)
         {
            oPath.bGoDown(teafi_tclKnot(teafi_tclToken::EN_S32_SECOND,teafi_tclSemanticDomain::EN_DELAYINFORMATION));
         }
         oPath.bGoDown(teafi_tclKnot(teafi_tclToken::EN_S32_METER,teafi_tclSemanticDomain::EN_LENGTHINFORMATION));
         if (38 <= u16MajorVersion)
         {
            oPath.bGoDown(teafi_tclKnot(teafi_tclToken::EN_E16_CAUSECODE,teafi_tclSemanticDomain::EN_CAUSE));
         }
         if (38 <= u16MajorVersion)
         {
            oPath.bGoDown(teafi_tclKnot(teafi_tclToken::EN_E8_TENDENCY,teafi_tclSemanticDomain::EN_TENDENCY));
         }
         if (38 <= u16MajorVersion)
         {
            oPath.bGoDown(teafi_tclKnot(teafi_tclToken::EN_E16_EFFECTCODE,teafi_tclSemanticDomain::EN_EFFECT));
         }
         oPath.bGoDown(teafi_tclKnot(teafi_tclToken::EN_E16_NAVIEVENTVALUE,teafi_tclSemanticDomain::EN_NAVIEVENTVALUE));
         if (38 <= u16MajorVersion)
         {
            oPath.bGoDown(teafi_tclKnot(teafi_tclToken::EN_E8_EVENTTYPE,teafi_tclSemanticDomain::EN_EVENTTYPE));
         }
      }
      else
      {
         fi_tcl_TMEvent o_TMEvent;
         if (!bDoIt(o_TMEvent))
         {
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
            o_TMEvent.vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
            return FALSE;
         }
         else
         {
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
            o_TMEvent.vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
            oCallStack.bGoUp();
            oPath.bGoUp();
         }
      }
   } break;
   case teafi_tclToken::EN_TMINFO:
   {
      if (poVisitor->bDoExpand_TMInfo(enSemanticDomain))
      {
         oPath.bGoUp();
         oPath.bGoDown(teafi_tclKnot(teafi_tclToken::EN_END_OF_STRUCT,teafi_tclSemanticDomain::EN_UNKNOWN));
         oPath.bGoDown(teafi_tclKnot(teafi_tclToken::EN_E8_TMGEOGRAPHICALPATHRELATIONTYPE,teafi_tclSemanticDomain::EN_GEOGRAPHICALPATHRELATION));
         oPath.bGoDown(teafi_tclKnot(teafi_tclToken::EN_POSIXTIME,teafi_tclSemanticDomain::EN_LATESTDECODETIME));
         oPath.bGoDown(teafi_tclKnot(teafi_tclToken::EN_POSIXTIME,teafi_tclSemanticDomain::EN_STOPTIME));
         oPath.bGoDown(teafi_tclKnot(teafi_tclToken::EN_POSIXTIME,teafi_tclSemanticDomain::EN_STARTTIME));
         oPath.bGoDown(teafi_tclKnot(teafi_tclToken::EN_U16_INDEXINREFERENCELIST,teafi_tclSemanticDomain::EN_INDEXINSERVICEPROVIDERLIST));
         oPath.bGoDown(teafi_tclKnot(teafi_tclToken::EN_U16_INDEXINREFERENCELIST,teafi_tclSemanticDomain::EN_LIST_ELEMENT,0));
         oPath.bGoDown(teafi_tclKnot(teafi_tclToken::EN_LIST,teafi_tclSemanticDomain::EN_INDICESINPROGRAMSERVICELIST));
         oPath.bGoDown(teafi_tclKnot(teafi_tclToken::EN_BOOL,teafi_tclSemanticDomain::EN_BIDIRECTIONAL));
         if (32 <= u16MajorVersion)
         {
            oPath.bGoDown(teafi_tclKnot(teafi_tclToken::EN_BOOL,teafi_tclSemanticDomain::EN_DIRECTIONAGAINSTTMC));
         }
         oPath.bGoDown(teafi_tclKnot(teafi_tclToken::EN_RDBID,teafi_tclSemanticDomain::EN_RDBID));
         if (32 <= u16MajorVersion)
         {
            oPath.bGoDown(teafi_tclKnot(teafi_tclToken::EN_TMCSTRUCTUREDTEXT,teafi_tclSemanticDomain::EN_ROADNAME));
         }
         oPath.bGoDown(teafi_tclKnot(teafi_tclToken::EN_ROADNUMBER,teafi_tclSemanticDomain::EN_ROADNUMBER));
         oPath.bGoDown(teafi_tclKnot(teafi_tclToken::EN_E8_ROADCLASSCODE,teafi_tclSemanticDomain::EN_ROADCLASS));
         oPath.bGoDown(teafi_tclKnot(teafi_tclToken::EN_U8,teafi_tclSemanticDomain::EN_PREFIXPRIORITY));
         if (9 <= u16MajorVersion)
         {
            oPath.bGoDown(teafi_tclKnot(teafi_tclToken::EN_U16,teafi_tclSemanticDomain::EN_LOCATIONSEGMENTIDX));
         }
         oPath.bGoDown(teafi_tclKnot(teafi_tclToken::EN_U16,teafi_tclSemanticDomain::EN_SEGMENTID));
         oPath.bGoDown(teafi_tclKnot(teafi_tclToken::EN_E8_TMURGENCY,teafi_tclSemanticDomain::EN_URGENCYOFEVENT));
         oPath.bGoDown(teafi_tclKnot(teafi_tclToken::EN_U16_USERTRAFFICMESSAGEHANDLE,teafi_tclSemanticDomain::EN_UTMHANDLE));
         if (15 <= u16MajorVersion)
         {
            oPath.bGoDown(teafi_tclKnot(teafi_tclToken::EN_B8_TMRELEVANCE,teafi_tclSemanticDomain::EN_TMRELEVANCE));
         }
         oPath.bGoDown(teafi_tclKnot(teafi_tclToken::EN_B32_TRAFFICMESSAGESOURCE,teafi_tclSemanticDomain::EN_TRAFFICINFOSOURCE));
         if (36 <= u16MajorVersion)
         {
            oPath.bGoDown(teafi_tclKnot(teafi_tclToken::EN_E8_TMVALUESTATUS,teafi_tclSemanticDomain::EN_LENGTHSTATUS));
         }
         if (30 <= u16MajorVersion)
         {
            oPath.bGoDown(teafi_tclKnot(teafi_tclToken::EN_S32_METER,teafi_tclSemanticDomain::EN_LENGTH));
         }
         if (36 <= u16MajorVersion)
         {
            oPath.bGoDown(teafi_tclKnot(teafi_tclToken::EN_E8_TMVALUESTATUS,teafi_tclSemanticDomain::EN_DELAYSTATUS));
         }
         oPath.bGoDown(teafi_tclKnot(teafi_tclToken::EN_S32_SECOND,teafi_tclSemanticDomain::EN_DELAY));
         oPath.bGoDown(teafi_tclKnot(teafi_tclToken::EN_SHAPE,teafi_tclSemanticDomain::EN_SHAPE));
         oPath.bGoDown(teafi_tclKnot(teafi_tclToken::EN_E8_TMGEOMETRICMESSAGETYPE,teafi_tclSemanticDomain::EN_GEOMETRICMESSAGETYPE));
         if (36 <= u16MajorVersion)
         {
            oPath.bGoDown(teafi_tclKnot(teafi_tclToken::EN_U8,teafi_tclSemanticDomain::EN_FLOWVALUE));
         }
         if (11 <= u16MajorVersion)
         {
            oPath.bGoDown(teafi_tclKnot(teafi_tclToken::EN_E8_TMFLOWIMPACT,teafi_tclSemanticDomain::EN_TMFLOWIMPACT));
         }
         oPath.bGoDown(teafi_tclKnot(teafi_tclToken::EN_E8_TMCATEGORY,teafi_tclSemanticDomain::EN_TMCATEGORY));
         oPath.bGoDown(teafi_tclKnot(teafi_tclToken::EN_B8_TMMAPPINGSTATUS,teafi_tclSemanticDomain::EN_TMMAPPINGSTATUS));
         oPath.bGoDown(teafi_tclKnot(teafi_tclToken::EN_B8_TMMAPPINGPOSSIBILITY,teafi_tclSemanticDomain::EN_TMMAPPINGPOSSIBILITY));
         oPath.bGoDown(teafi_tclKnot(teafi_tclToken::EN_TMEVENT,teafi_tclSemanticDomain::EN_LIST_ELEMENT,0));
         oPath.bGoDown(teafi_tclKnot(teafi_tclToken::EN_LIST,teafi_tclSemanticDomain::EN_EVENTLIST));
         if (38 <= u16MajorVersion)
         {
            oPath.bGoDown(teafi_tclKnot(teafi_tclToken::EN_E8_TRAFFICMSGTYPE,teafi_tclSemanticDomain::EN_MESSAGETYPE));
         }
         oPath.bGoDown(teafi_tclKnot(teafi_tclToken::EN_U32,teafi_tclSemanticDomain::EN_TRAFFICMESSAGEID));
      }
      else
      {
         fi_tcl_TMInfo o_TMInfo;
         if (!bDoIt(o_TMInfo))
         {
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
            o_TMInfo.vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
            return FALSE;
         }
         else
         {
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
            o_TMInfo.vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
            oCallStack.bGoUp();
            oPath.bGoUp();
         }
      }
   } break;
   case teafi_tclToken::EN_TMCODEDMESSAGE:
   {
      if (poVisitor->bDoExpand_TMCodedMessage(enSemanticDomain))
      {
         oPath.bGoUp();
         oPath.bGoDown(teafi_tclKnot(teafi_tclToken::EN_END_OF_STRUCT,teafi_tclSemanticDomain::EN_UNKNOWN));
         oPath.bGoDown(teafi_tclKnot(teafi_tclToken::EN_RDBID,teafi_tclSemanticDomain::EN_RDBID));
         if (38 <= u16MajorVersion)
         {
            oPath.bGoDown(teafi_tclKnot(teafi_tclToken::EN_TMEVENT,teafi_tclSemanticDomain::EN_LIST_ELEMENT,0));
            oPath.bGoDown(teafi_tclKnot(teafi_tclToken::EN_LIST,teafi_tclSemanticDomain::EN_EVENTS));
         }
         if (38 <= u16MajorVersion)
         {
            oPath.bGoDown(teafi_tclKnot(teafi_tclToken::EN_BOOL,teafi_tclSemanticDomain::EN_BIDIRECTIONAL));
         }
         if (38 <= u16MajorVersion)
         {
            oPath.bGoDown(teafi_tclKnot(teafi_tclToken::EN_BOOL,teafi_tclSemanticDomain::EN_DIRECTIONAGAINSTTMC));
         }
         if (38 <= u16MajorVersion)
         {
            oPath.bGoDown(teafi_tclKnot(teafi_tclToken::EN_U8,teafi_tclSemanticDomain::EN_EXTENT));
         }
         if (38 <= u16MajorVersion)
         {
            oPath.bGoDown(teafi_tclKnot(teafi_tclToken::EN_E8_TMLOCATIONTYPE,teafi_tclSemanticDomain::EN_PRIMARYLOCATIONTYPE));
         }
         if (38 <= u16MajorVersion)
         {
            oPath.bGoDown(teafi_tclKnot(teafi_tclToken::EN_U16,teafi_tclSemanticDomain::EN_SECONDARYLOCATIONCODE));
         }
         if (38 <= u16MajorVersion)
         {
            oPath.bGoDown(teafi_tclKnot(teafi_tclToken::EN_U16,teafi_tclSemanticDomain::EN_PRIMARYLOCATIONCODE));
         }
         if (u16MajorVersion <= 36)
         {
            oPath.bGoDown(teafi_tclKnot(teafi_tclToken::EN_U8,teafi_tclSemanticDomain::EN_AVERAGESPEED));
         }
         if (u16MajorVersion <= 36)
         {
            oPath.bGoDown(teafi_tclKnot(teafi_tclToken::EN_U8,teafi_tclSemanticDomain::EN_SPEEDLIMITADVICE));
         }
         if (u16MajorVersion <= 36)
         {
            oPath.bGoDown(teafi_tclKnot(teafi_tclToken::EN_U8,teafi_tclSemanticDomain::EN_LENGTHINFOANDLABEL2));
         }
         if (u16MajorVersion <= 36)
         {
            oPath.bGoDown(teafi_tclKnot(teafi_tclToken::EN_U8,teafi_tclSemanticDomain::EN_ROADNUMBERSUFFIX));
         }
         if (u16MajorVersion <= 36)
         {
            oPath.bGoDown(teafi_tclKnot(teafi_tclToken::EN_U16,teafi_tclSemanticDomain::EN_ROADNUMBER));
         }
         if (u16MajorVersion <= 36)
         {
            oPath.bGoDown(teafi_tclKnot(teafi_tclToken::EN_U16,teafi_tclSemanticDomain::EN_ROADCLASS));
         }
         if (u16MajorVersion <= 36)
         {
            oPath.bGoDown(teafi_tclKnot(teafi_tclToken::EN_E16_NAVIEVENTVALUE,teafi_tclSemanticDomain::EN_ADDITIONALNEV7));
         }
         if (u16MajorVersion <= 36)
         {
            oPath.bGoDown(teafi_tclKnot(teafi_tclToken::EN_E16_NAVIEVENTVALUE,teafi_tclSemanticDomain::EN_ADDITIONALNEV6));
         }
         if (u16MajorVersion <= 36)
         {
            oPath.bGoDown(teafi_tclKnot(teafi_tclToken::EN_E16_NAVIEVENTVALUE,teafi_tclSemanticDomain::EN_ADDITIONALNEV5));
         }
         if (u16MajorVersion <= 36)
         {
            oPath.bGoDown(teafi_tclKnot(teafi_tclToken::EN_E16_NAVIEVENTVALUE,teafi_tclSemanticDomain::EN_ADDITIONALNEV4));
         }
         if (u16MajorVersion <= 36)
         {
            oPath.bGoDown(teafi_tclKnot(teafi_tclToken::EN_E16_NAVIEVENTVALUE,teafi_tclSemanticDomain::EN_ADDITIONALNEV3));
         }
         if (u16MajorVersion <= 36)
         {
            oPath.bGoDown(teafi_tclKnot(teafi_tclToken::EN_E16_NAVIEVENTVALUE,teafi_tclSemanticDomain::EN_ADDITIONALNEV2));
         }
         if (u16MajorVersion <= 36)
         {
            oPath.bGoDown(teafi_tclKnot(teafi_tclToken::EN_E16_NAVIEVENTVALUE,teafi_tclSemanticDomain::EN_ADDITIONALNEV1));
         }
         if (u16MajorVersion <= 36)
         {
            oPath.bGoDown(teafi_tclKnot(teafi_tclToken::EN_E16_NAVIEVENTVALUE,teafi_tclSemanticDomain::EN_MAINNEV));
         }
         if (u16MajorVersion <= 36)
         {
            oPath.bGoDown(teafi_tclKnot(teafi_tclToken::EN_U8,teafi_tclSemanticDomain::EN_DIRECTIONALITY));
         }
         if (u16MajorVersion <= 36)
         {
            oPath.bGoDown(teafi_tclKnot(teafi_tclToken::EN_U8,teafi_tclSemanticDomain::EN_DIRANDEXTENT));
         }
         if (u16MajorVersion <= 36)
         {
            oPath.bGoDown(teafi_tclKnot(teafi_tclToken::EN_U8,teafi_tclSemanticDomain::EN_LOCATIONTYPE));
         }
         if (u16MajorVersion <= 36)
         {
            oPath.bGoDown(teafi_tclKnot(teafi_tclToken::EN_U16,teafi_tclSemanticDomain::EN_LOCATION2));
         }
         if (u16MajorVersion <= 36)
         {
            oPath.bGoDown(teafi_tclKnot(teafi_tclToken::EN_U16,teafi_tclSemanticDomain::EN_LOCATION1));
         }
      }
      else
      {
         fi_tcl_TMCodedMessage o_TMCodedMessage;
         if (!bDoIt(o_TMCodedMessage))
         {
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
            o_TMCodedMessage.vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
            return FALSE;
         }
         else
         {
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
            o_TMCodedMessage.vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
            oCallStack.bGoUp();
            oPath.bGoUp();
         }
      }
   } break;
#ifndef FI_S_EXTERNAL_FI
   case teafi_tclToken::EN_TMCODEDMESSAGEBINCONTAINER:
   {
      if (poVisitor->bDoExpand_TMCodedMessageBinContainer(enSemanticDomain))
      {
         oPath.bGoUp();
         bInsideBinContainerVersion = true;
         oPath.bGoDown(teafi_tclKnot(teafi_tclToken::EN_END_OF_STRUCT,teafi_tclSemanticDomain::EN_BINCONTAINER));
         oPath.bGoDown(teafi_tclKnot(teafi_tclToken::EN_TMCODEDMESSAGE,teafi_tclSemanticDomain::EN_TMCODEDMESSAGE));
         oPath.bGoDown(teafi_tclKnot(teafi_tclToken::EN_E8_BINCONTAINERTYPES,teafi_tclSemanticDomain::EN_CONTAINERTYPE));
         oPath.bGoDown(teafi_tclKnot(teafi_tclToken::EN_FIVERSION,teafi_tclSemanticDomain::EN_CONTAINERFIVERSION));
         oPath.bGoDown(teafi_tclKnot(teafi_tclToken::EN_U16,teafi_tclSemanticDomain::EN_SERVICEID));
         oPath.bGoDown(teafi_tclKnot(teafi_tclToken::EN_U32,teafi_tclSemanticDomain::EN_CONTAINERLENGTH));
      }
      else
      {
         fi_tcl_TMCodedMessageBinContainer o_TMCodedMessageBinContainer;
         if (!bDoIt(o_TMCodedMessageBinContainer))
         {
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
            o_TMCodedMessageBinContainer.vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
            return FALSE;
         }
         else
         {
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
            o_TMCodedMessageBinContainer.vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
            oCallStack.bGoUp();
            oPath.bGoUp();
         }
      }
   } break;
#endif // FI_S_EXTERNAL_FI
   case teafi_tclToken::EN_TMCOMBINATION:
   {
      if (poVisitor->bDoExpand_TMCombination(enSemanticDomain))
      {
         oPath.bGoUp();
         oPath.bGoDown(teafi_tclKnot(teafi_tclToken::EN_END_OF_STRUCT,teafi_tclSemanticDomain::EN_UNKNOWN));
         if (9 <= u16MajorVersion)
         {
            oPath.bGoDown(teafi_tclKnot(teafi_tclToken::EN_E8_TMCINTERSECTIONPATHTYPE,teafi_tclSemanticDomain::EN_INTERSECTIONPATHTYPE));
         }
         oPath.bGoDown(teafi_tclKnot(teafi_tclToken::EN_E8_TMAFFECTIONTYPE,teafi_tclSemanticDomain::EN_AFFECTIONTYPE));
         oPath.bGoDown(teafi_tclKnot(teafi_tclToken::EN_TMONECELLPORTION,teafi_tclSemanticDomain::EN_PORTION));
         oPath.bGoDown(teafi_tclKnot(teafi_tclToken::EN_B8_TMONECELLATTRIBUTE,teafi_tclSemanticDomain::EN_TMATTRIBUTES));
         oPath.bGoDown(teafi_tclKnot(teafi_tclToken::EN_U16_INDEXINREFERENCELIST,teafi_tclSemanticDomain::EN_INDEXINTMINFOLIST));
         oPath.bGoDown(teafi_tclKnot(teafi_tclToken::EN_U16_INDEXINREFERENCELIST,teafi_tclSemanticDomain::EN_INDEXINTMPATHLIST));
      }
      else
      {
         fi_tcl_TMCombination o_TMCombination;
         if (!bDoIt(o_TMCombination))
         {
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
            o_TMCombination.vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
            return FALSE;
         }
         else
         {
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
            o_TMCombination.vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
            oCallStack.bGoUp();
            oPath.bGoUp();
         }
      }
   } break;
   case teafi_tclToken::EN_TMINFOLISTSET:
   {
      if (poVisitor->bDoExpand_TMInfoListSet(enSemanticDomain))
      {
         oPath.bGoUp();
         oPath.bGoDown(teafi_tclKnot(teafi_tclToken::EN_END_OF_STRUCT,teafi_tclSemanticDomain::EN_UNKNOWN));
         oPath.bGoDown(teafi_tclKnot(teafi_tclToken::EN_TMCOMBINATION,teafi_tclSemanticDomain::EN_LIST_ELEMENT,0));
         oPath.bGoDown(teafi_tclKnot(teafi_tclToken::EN_LIST,teafi_tclSemanticDomain::EN_TMCOMBINATION));
         oPath.bGoDown(teafi_tclKnot(teafi_tclToken::EN_TMSERVICEPROVIDER,teafi_tclSemanticDomain::EN_LIST_ELEMENT,0));
         oPath.bGoDown(teafi_tclKnot(teafi_tclToken::EN_LIST,teafi_tclSemanticDomain::EN_SERVICEPROVIDERLIST));
         oPath.bGoDown(teafi_tclKnot(teafi_tclToken::EN_TMPROGRAMSERVICE,teafi_tclSemanticDomain::EN_LIST_ELEMENT,0));
         oPath.bGoDown(teafi_tclKnot(teafi_tclToken::EN_LIST,teafi_tclSemanticDomain::EN_PROGRAMSERVICELIST));
         oPath.bGoDown(teafi_tclKnot(teafi_tclToken::EN_TMINFO,teafi_tclSemanticDomain::EN_LIST_ELEMENT,0));
         oPath.bGoDown(teafi_tclKnot(teafi_tclToken::EN_LIST,teafi_tclSemanticDomain::EN_TMINFO));
         oPath.bGoDown(teafi_tclKnot(teafi_tclToken::EN_BINCONTAINER,teafi_tclSemanticDomain::EN_LIST_ELEMENT,0));
         oPath.bGoDown(teafi_tclKnot(teafi_tclToken::EN_LIST,teafi_tclSemanticDomain::EN_TMCODEDTEXTMESSAGE));
      }
      else
      {
         fi_tcl_TMInfoListSet o_TMInfoListSet;
         if (!bDoIt(o_TMInfoListSet))
         {
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
            o_TMInfoListSet.vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
            return FALSE;
         }
         else
         {
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
            o_TMInfoListSet.vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
            oCallStack.bGoUp();
            oPath.bGoUp();
         }
      }
   } break;
   case teafi_tclToken::EN_MAPGEOGRAPHICTYPE:
   {
      if (poVisitor->bDoExpand_MapGeographicType(enSemanticDomain))
      {
         oPath.bGoUp();
         oPath.bGoDown(teafi_tclKnot(teafi_tclToken::EN_END_OF_STRUCT,teafi_tclSemanticDomain::EN_UNKNOWN));
         oPath.bGoDown(teafi_tclKnot(teafi_tclToken::EN_E16_SELECTIONCRITERIONTYPE,teafi_tclSemanticDomain::EN_MAPGEOGRAPHICTYPE));
      }
      else
      {
         fi_tcl_MapGeographicType o_MapGeographicType;
         if (!bDoIt(o_MapGeographicType))
         {
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
            o_MapGeographicType.vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
            return FALSE;
         }
         else
         {
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
            o_MapGeographicType.vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
            oCallStack.bGoUp();
            oPath.bGoUp();
         }
      }
   } break;
      case teafi_tclToken::EN_UNKNOWN:
      case teafi_tclToken::EN_LAST_TOKEN:         
      default:
         return FALSE;
      }
  }
  return bResult;
}

