#ifndef __TEAFIDEBUGVISITOR_H__
#define __TEAFIDEBUGVISITOR_H__

class MY_DECL teafi_tclPrintVisitor : public teafi_tclVisitorBase {

private:
   /* default constructor */ teafi_tclPrintVisitor();  //lint !e1704   // use constructor with parameter

public:
   teafi_tclPrintVisitor(fi_tclOutput* poOut):poOutput(poOut) { line[0] = '\0'; }

   // --Besuche allgemeine Objekte	
   virtual tVoid vVisitU8(fi_tclU8& oU8);
   virtual tVoid vVisitS8(fi_tclS8& oS8);
   virtual tVoid vVisitU16(fi_tclU16& oU16);
   virtual tVoid vVisitS16(fi_tclS16& oS16);
   virtual tVoid vVisitU24(fi_tclU24& oU24);
   virtual tVoid vVisitS24(fi_tclS24& oS24);
   virtual tVoid vVisitU32(fi_tclU32& oU32);
   virtual tVoid vVisitS32(fi_tclS32& oS32);
   virtual tVoid vVisitU64(fi_tclU64& oU64);
   virtual tVoid vVisitS64(fi_tclS64& oS64);
   virtual tVoid vVisitBool(fi_tclBool& oBool);
   virtual tVoid vVisitString(fi_tclString& oString);
   virtual tVoid vVisitMultiLanguageString(fi_tclMultiLanguageString& oString);
   virtual tVoid vVisitList(fi_tclList& oList);

   // Besuche die generierten Typen
   virtual tBool bDoExpand_BinContainer(teafi_tclSemanticDomain::tenType enSemantic);
   virtual tBool bDoExpand_Reserved(teafi_tclSemanticDomain::tenType enSemantic);
   virtual tVoid vVisit_u8_Percent(fi_tcl_u8_Percent& o_u8_Percent);
   virtual tVoid vVisit_s16_PerThousand(fi_tcl_s16_PerThousand& o_s16_PerThousand);
   virtual tVoid vVisit_u16_IndexInReferenceList(fi_tcl_u16_IndexInReferenceList& o_u16_IndexInReferenceList);
   virtual tVoid vVisit_s32_Kilogram(fi_tcl_s32_Kilogram& o_s32_Kilogram);
   virtual tVoid vVisit_s32_Pound(fi_tcl_s32_Pound& o_s32_Pound);
   virtual tVoid vVisit_s16_Meter(fi_tcl_s16_Meter& o_s16_Meter);
   virtual tVoid vVisit_s32_Meter(fi_tcl_s32_Meter& o_s32_Meter);
   virtual tVoid vVisit_s32_Yards(fi_tcl_s32_Yards& o_s32_Yards);
   virtual tVoid vVisit_s32_Centimeter(fi_tcl_s32_Centimeter& o_s32_Centimeter);
   virtual tVoid vVisit_s32_Inch(fi_tcl_s32_Inch& o_s32_Inch);
   virtual tVoid vVisit_s32_Second(fi_tcl_s32_Second& o_s32_Second);
   virtual tBool bDoExpand_POSIXTime(teafi_tclSemanticDomain::tenType enSemantic);
   virtual tVoid vVisit_e8_DST_State(fi_tcl_e8_DST_State& o_e8_DST_State);
   virtual tBool bDoExpand_TimeZoneElement(teafi_tclSemanticDomain::tenType enSemantic);
   virtual tVoid vVisit_s16_KmPerHour(fi_tcl_s16_KmPerHour& o_s16_KmPerHour);
   virtual tVoid vVisit_s16_MilesPerHour(fi_tcl_s16_MilesPerHour& o_s16_MilesPerHour);
   virtual tVoid vVisit_s16_CentimeterSecond(fi_tcl_s16_CentimeterSecond& o_s16_CentimeterSecond);
   virtual tBool bDoExpand_FIVersion(teafi_tclSemanticDomain::tenType enSemantic);
   virtual tVoid vVisit_s32_Longitude(fi_tcl_s32_Longitude& o_s32_Longitude);
   virtual tVoid vVisit_s32_Latitude(fi_tcl_s32_Latitude& o_s32_Latitude);
   virtual tBool bDoExpand_PositionWGS84(teafi_tclSemanticDomain::tenType enSemantic);
   virtual tVoid vVisit_e16_ISOCountryCode(fi_tcl_e16_ISOCountryCode& o_e16_ISOCountryCode);
   virtual tVoid vVisit_u8_DirectionAbsolute(fi_tcl_u8_DirectionAbsolute& o_u8_DirectionAbsolute);
   virtual tVoid vVisit_s16_CentiDegree(fi_tcl_s16_CentiDegree& o_s16_CentiDegree);
   virtual tVoid vVisit_e8_BinContainerTypes(fi_tcl_e8_BinContainerTypes& o_e8_BinContainerTypes);
   virtual tVoid vVisit_s32_MEMU(fi_tcl_s32_MEMU& o_s32_MEMU);
   virtual tBool bDoExpand_NavClusterDesc(teafi_tclSemanticDomain::tenType enSemantic);
   virtual tVoid vVisit_s32_EMU(fi_tcl_s32_EMU& o_s32_EMU);
   virtual tVoid vVisit_e8_NavOneCellDirection(fi_tcl_e8_NavOneCellDirection& o_e8_NavOneCellDirection);
   virtual tVoid vVisit_s16_CurvatureValue(fi_tcl_s16_CurvatureValue& o_s16_CurvatureValue);
   virtual tBool bDoExpand_NavOneCellDesc(teafi_tclSemanticDomain::tenType enSemantic);
   virtual tVoid vVisit_e8_RoadClassCode(fi_tcl_e8_RoadClassCode& o_e8_RoadClassCode);
   virtual tBool bDoExpand_NavPlainPathListSet(teafi_tclSemanticDomain::tenType enSemantic);
   virtual tVoid vVisit_e8_SignPostDestType(fi_tcl_e8_SignPostDestType& o_e8_SignPostDestType);
   virtual tVoid vVisit_e8_SignPostDestinationCategory(fi_tcl_e8_SignPostDestinationCategory& o_e8_SignPostDestinationCategory);
   virtual tVoid vVisit_e8_SignPostDestStatus(fi_tcl_e8_SignPostDestStatus& o_e8_SignPostDestStatus);
   virtual tVoid vVisit_e8_DirectionStatus(fi_tcl_e8_DirectionStatus& o_e8_DirectionStatus);
   virtual tBool bDoExpand_SignPostDestDirection(teafi_tclSemanticDomain::tenType enSemantic);
   virtual tVoid vVisit_e8_DirectionCategory(fi_tcl_e8_DirectionCategory& o_e8_DirectionCategory);
   virtual tVoid vVisit_e8_NavOneCellCategory(fi_tcl_e8_NavOneCellCategory& o_e8_NavOneCellCategory);
   virtual tBool bDoExpand_DirectionCategory(teafi_tclSemanticDomain::tenType enSemantic);
   virtual tVoid vVisit_b8_DirectionInfoStatus(fi_tcl_b8_DirectionInfoStatus& o_b8_DirectionInfoStatus);
   virtual tBool bDoExpand_DirectionInfo(teafi_tclSemanticDomain::tenType enSemantic);
   virtual tBool bDoExpand_SignPostDestination(teafi_tclSemanticDomain::tenType enSemantic);
   virtual tBool bDoExpand_ReferenceElement(teafi_tclSemanticDomain::tenType enSemantic);
   virtual tVoid vVisit_e8_CrossroadInfoCategory(fi_tcl_e8_CrossroadInfoCategory& o_e8_CrossroadInfoCategory);
   virtual tVoid vVisit_b32_RoadProperty(fi_tcl_b32_RoadProperty& o_b32_RoadProperty);
   virtual tVoid vVisit_e8_NavStreetType(fi_tcl_e8_NavStreetType& o_e8_NavStreetType);
   virtual tVoid vVisit_e8_RoadNetworkClass(fi_tcl_e8_RoadNetworkClass& o_e8_RoadNetworkClass);
   virtual tBool bDoExpand_NavOneCell(teafi_tclSemanticDomain::tenType enSemantic);
   virtual tBool bDoExpand_SignPostElement(teafi_tclSemanticDomain::tenType enSemantic);
   virtual tBool bDoExpand_DirectionInfoListSet(teafi_tclSemanticDomain::tenType enSemantic);
   virtual tBool bDoExpand_ReferenceElementWithID(teafi_tclSemanticDomain::tenType enSemantic);
   virtual tBool bDoExpand_StateNameElement(teafi_tclSemanticDomain::tenType enSemantic);
   virtual tBool bDoExpand_CountyNameElement(teafi_tclSemanticDomain::tenType enSemantic);
   virtual tBool bDoExpand_CityDistrictNameElement(teafi_tclSemanticDomain::tenType enSemantic);
   virtual tBool bDoExpand_BuildUpAreaNameElement(teafi_tclSemanticDomain::tenType enSemantic);
   virtual tVoid vVisit_b8_RoadNumberStatus(fi_tcl_b8_RoadNumberStatus& o_b8_RoadNumberStatus);
   virtual tBool bDoExpand_RequiredTaxDisc(teafi_tclSemanticDomain::tenType enSemantic);
   virtual tVoid vVisit_e8_RequiredPermissionType(fi_tcl_e8_RequiredPermissionType& o_e8_RequiredPermissionType);
   virtual tVoid vVisit_e8_RequiredPermission(fi_tcl_e8_RequiredPermission& o_e8_RequiredPermission);
   virtual tBool bDoExpand_GenericRequiredPermission(teafi_tclSemanticDomain::tenType enSemantic);
   virtual tBool bDoExpand_RequiredPermission(teafi_tclSemanticDomain::tenType enSemantic);
   virtual tBool bDoExpand_CountryNameElement(teafi_tclSemanticDomain::tenType enSemantic);
   virtual tBool bDoExpand_StateNameListSet(teafi_tclSemanticDomain::tenType enSemantic);
   virtual tBool bDoExpand_CountyNameListSet(teafi_tclSemanticDomain::tenType enSemantic);
   virtual tBool bDoExpand_CityNameElement(teafi_tclSemanticDomain::tenType enSemantic);
   virtual tBool bDoExpand_IndexInReferenceList(teafi_tclSemanticDomain::tenType enSemantic);
   virtual tBool bDoExpand_BuildUpAreaNameListSet(teafi_tclSemanticDomain::tenType enSemantic);
   virtual tBool bDoExpand_RoadNameListSet(teafi_tclSemanticDomain::tenType enSemantic);
   virtual tBool bDoExpand_CompassDirection(teafi_tclSemanticDomain::tenType enSemantic);
   virtual tBool bDoExpand_RequiredPermissionListSet(teafi_tclSemanticDomain::tenType enSemantic);
   virtual tVoid vVisit_e8_IntersectionType(fi_tcl_e8_IntersectionType& o_e8_IntersectionType);
   virtual tBool bDoExpand_TimeZoneListSet(teafi_tclSemanticDomain::tenType enSemantic);
   virtual tBool bDoExpand_IntersectionNameElement(teafi_tclSemanticDomain::tenType enSemantic);
   virtual tBool bDoExpand_RoadNameElement(teafi_tclSemanticDomain::tenType enSemantic);
   virtual tBool bDoExpand_RoadNumber(teafi_tclSemanticDomain::tenType enSemantic);
   virtual tBool bDoExpand_IntersectionNumberElement(teafi_tclSemanticDomain::tenType enSemantic);
   virtual tVoid vVisit_b8_PresenceIndicator(fi_tcl_b8_PresenceIndicator& o_b8_PresenceIndicator);
   virtual tBool bDoExpand_CountryNameListSet(teafi_tclSemanticDomain::tenType enSemantic);
   virtual tBool bDoExpand_CityNameListSet(teafi_tclSemanticDomain::tenType enSemantic);
   virtual tBool bDoExpand_SignPostListSet(teafi_tclSemanticDomain::tenType enSemantic);
   virtual tBool bDoExpand_RoadNumberListSet(teafi_tclSemanticDomain::tenType enSemantic);
   virtual tVoid vVisit_b16_RoadAttribute(fi_tcl_b16_RoadAttribute& o_b16_RoadAttribute);
   virtual tBool bDoExpand_NavPosOneCellProperty(teafi_tclSemanticDomain::tenType enSemantic);
   virtual tBool bDoExpand_RoadAttributes(teafi_tclSemanticDomain::tenType enSemantic);
   virtual tVoid vVisit_e8_ExtraDescElementType(fi_tcl_e8_ExtraDescElementType& o_e8_ExtraDescElementType);
   virtual tBool bDoExpand_ExtraDescElement(teafi_tclSemanticDomain::tenType enSemantic);
   virtual tBool bDoExpand_ExtraDescListSet(teafi_tclSemanticDomain::tenType enSemantic);
   virtual tVoid vVisit_b32_DataProperties(fi_tcl_b32_DataProperties& o_b32_DataProperties);
   virtual tBool bDoExpand_DataDescElement(teafi_tclSemanticDomain::tenType enSemantic);
   virtual tBool bDoExpand_DataDescListSet(teafi_tclSemanticDomain::tenType enSemantic);
   virtual tVoid vVisit_b8_CrossroadProperties(fi_tcl_b8_CrossroadProperties& o_b8_CrossroadProperties);
   virtual tBool bDoExpand_CrossroadDesc(teafi_tclSemanticDomain::tenType enSemantic);
   virtual tBool bDoExpand_CrossroadInfo(teafi_tclSemanticDomain::tenType enSemantic);
   virtual tBool bDoExpand_IntersectionDenotation(teafi_tclSemanticDomain::tenType enSemantic);
   virtual tBool bDoExpand_IntersectionPathDenotation(teafi_tclSemanticDomain::tenType enSemantic);
   virtual tBool bDoExpand_IntersectionPathDesc(teafi_tclSemanticDomain::tenType enSemantic);
   virtual tBool bDoExpand_NavIntersectionListSet(teafi_tclSemanticDomain::tenType enSemantic);
   virtual tVoid vVisit_e8_BaseTrafficSignCategory(fi_tcl_e8_BaseTrafficSignCategory& o_e8_BaseTrafficSignCategory);
   virtual tVoid vVisit_e8_SpeedSign(fi_tcl_e8_SpeedSign& o_e8_SpeedSign);
   virtual tVoid vVisit_e16_WarningSign(fi_tcl_e16_WarningSign& o_e16_WarningSign);
   virtual tVoid vVisit_e16_RegulatorySign(fi_tcl_e16_RegulatorySign& o_e16_RegulatorySign);
   virtual tVoid vVisit_e16_AdditionalTrafficSign(fi_tcl_e16_AdditionalTrafficSign& o_e16_AdditionalTrafficSign);
   virtual tVoid vVisit_TimeDependentString(fi_tcl_TimeDependentString& o_TimeDependentString);
   virtual tVoid vVisit_b8_LaneDependentValidity(fi_tcl_b8_LaneDependentValidity& o_b8_LaneDependentValidity);
   virtual tVoid vVisit_e8_TrafficSignQuantifier(fi_tcl_e8_TrafficSignQuantifier& o_e8_TrafficSignQuantifier);
   virtual tBool bDoExpand_AdditionalTrafficSign(teafi_tclSemanticDomain::tenType enSemantic);
   virtual tBool bDoExpand_TrafficSignElement(teafi_tclSemanticDomain::tenType enSemantic);
   virtual tBool bDoExpand_RoadInfoCombination(teafi_tclSemanticDomain::tenType enSemantic);
   virtual tBool bDoExpand_TrafficSignListSet(teafi_tclSemanticDomain::tenType enSemantic);
   virtual tVoid vVisit_b32_POICategory(fi_tcl_b32_POICategory& o_b32_POICategory);
   virtual tBool bDoExpand_POIElement(teafi_tclSemanticDomain::tenType enSemantic);
   virtual tBool bDoExpand_POIListSet(teafi_tclSemanticDomain::tenType enSemantic);
   virtual tBool bDoExpand_TollBoothElement(teafi_tclSemanticDomain::tenType enSemantic);
   virtual tBool bDoExpand_TollBoothListSet(teafi_tclSemanticDomain::tenType enSemantic);
   virtual tBool bDoExpand_CityDistrictNameListSet(teafi_tclSemanticDomain::tenType enSemantic);
   virtual tBool bDoExpand_MapCodedElement(teafi_tclSemanticDomain::tenType enSemantic);
   virtual tBool bDoExpand_PointOfInterestElement(teafi_tclSemanticDomain::tenType enSemantic);
   virtual tBool bDoExpand_UnspecifiedText(teafi_tclSemanticDomain::tenType enSemantic);
   virtual tVoid vVisit_e8_PosHorizonState(fi_tcl_e8_PosHorizonState& o_e8_PosHorizonState);
   virtual tBool bDoExpand_OffsetSlopeValue(teafi_tclSemanticDomain::tenType enSemantic);
   virtual tBool bDoExpand_OffsetHeightValue(teafi_tclSemanticDomain::tenType enSemantic);
   virtual tVoid vVisit_e8_DigitalMapSpeedCategoryType(fi_tcl_e8_DigitalMapSpeedCategoryType& o_e8_DigitalMapSpeedCategoryType);
   virtual tVoid vVisit_e8_PosHorizonSuccessorState(fi_tcl_e8_PosHorizonSuccessorState& o_e8_PosHorizonSuccessorState);
   virtual tVoid vVisit_b32_PathSectionStatus(fi_tcl_b32_PathSectionStatus& o_b32_PathSectionStatus);
   virtual tVoid vVisit_b8_PosHorizonSuccessorState(fi_tcl_b8_PosHorizonSuccessorState& o_b8_PosHorizonSuccessorState);
   virtual tBool bDoExpand_PosHorizonPathSuccessor(teafi_tclSemanticDomain::tenType enSemantic);
   virtual tBool bDoExpand_PosHorizonPathSection(teafi_tclSemanticDomain::tenType enSemantic);
   virtual tBool bDoExpand_PosHorizonOneCellDesc(teafi_tclSemanticDomain::tenType enSemantic);
   virtual tVoid vVisit_b8_HorizonOneCellPropertyStatus(fi_tcl_b8_HorizonOneCellPropertyStatus& o_b8_HorizonOneCellPropertyStatus);
   virtual tBool bDoExpand_HorizonMostProbablePath(teafi_tclSemanticDomain::tenType enSemantic);
   virtual tBool bDoExpand_PosHorizonRootElement(teafi_tclSemanticDomain::tenType enSemantic);
   virtual tBool bDoExpand_PosHorizonOneCellSection(teafi_tclSemanticDomain::tenType enSemantic);
   virtual tVoid vVisit_b8_TEAPresenceIndicator(fi_tcl_b8_TEAPresenceIndicator& o_b8_TEAPresenceIndicator);
   virtual tVoid vVisit_b32_RoadInfoCategoryIndicator(fi_tcl_b32_RoadInfoCategoryIndicator& o_b32_RoadInfoCategoryIndicator);
   virtual tVoid vVisit_e8_HorizonRoadInfoCategory(fi_tcl_e8_HorizonRoadInfoCategory& o_e8_HorizonRoadInfoCategory);
   virtual tBool bDoExpand_HorizonRoadInfoUnion(teafi_tclSemanticDomain::tenType enSemantic);
   virtual tVoid vVisit_b8_CurvatureStatus(fi_tcl_b8_CurvatureStatus& o_b8_CurvatureStatus);
   virtual tBool bDoExpand_Curvature(teafi_tclSemanticDomain::tenType enSemantic);
   virtual tBool bDoExpand_CurvatureList(teafi_tclSemanticDomain::tenType enSemantic);
   virtual tVoid vVisit_e8_MPPState(fi_tcl_e8_MPPState& o_e8_MPPState);
   virtual tBool bDoExpand_MPPData(teafi_tclSemanticDomain::tenType enSemantic);
   virtual tBool bDoExpand_AlternativTEAEventIDList(teafi_tclSemanticDomain::tenType enSemantic);
   virtual tVoid vVisit_e8_TEAEventType(fi_tcl_e8_TEAEventType& o_e8_TEAEventType);
   virtual tBool bDoExpand_TEAEventID(teafi_tclSemanticDomain::tenType enSemantic);
   virtual tBool bDoExpand_MapCoordinates(teafi_tclSemanticDomain::tenType enSemantic);
   virtual tVoid vVisit_s8_MapDisplayZLevel(fi_tcl_s8_MapDisplayZLevel& o_s8_MapDisplayZLevel);
   virtual tVoid vVisit_s8_MapDisplayPriority(fi_tcl_s8_MapDisplayPriority& o_s8_MapDisplayPriority);
   virtual tBool bDoExpand_MapDescriptionListSet(teafi_tclSemanticDomain::tenType enSemantic);
   virtual tVoid vVisit_e8_MapElementDescrType(fi_tcl_e8_MapElementDescrType& o_e8_MapElementDescrType);
   virtual tBool bDoExpand_MapElementDescriptor(teafi_tclSemanticDomain::tenType enSemantic);
   virtual tBool bDoExpand_MapElementDescription(teafi_tclSemanticDomain::tenType enSemantic);
   virtual tVoid vVisit_e8_MapGeometricType(fi_tcl_e8_MapGeometricType& o_e8_MapGeometricType);
   virtual tVoid vVisit_e16_SelectionCriterionType(fi_tcl_e16_SelectionCriterionType& o_e16_SelectionCriterionType);
   virtual tVoid vVisit_e8_SurfaceCoverCode(fi_tcl_e8_SurfaceCoverCode& o_e8_SurfaceCoverCode);
   virtual tVoid vVisit_u16_UserTrafficMessageHandle(fi_tcl_u16_UserTrafficMessageHandle& o_u16_UserTrafficMessageHandle);
   virtual tVoid vVisit_e8_LaneStatus(fi_tcl_e8_LaneStatus& o_e8_LaneStatus);
   virtual tVoid vVisit_b8_LaneType(fi_tcl_b8_LaneType& o_b8_LaneType);
   virtual tVoid vVisit_b8_LaneChangeRestriction(fi_tcl_b8_LaneChangeRestriction& o_b8_LaneChangeRestriction);
   virtual tVoid vVisit_u8_IndexInLaneInfoSegmentList(fi_tcl_u8_IndexInLaneInfoSegmentList& o_u8_IndexInLaneInfoSegmentList);
   virtual tVoid vVisit_u8_IndexInLaneInfoList(fi_tcl_u8_IndexInLaneInfoList& o_u8_IndexInLaneInfoList);
   virtual tVoid vVisit_u8_DrivingDirection(fi_tcl_u8_DrivingDirection& o_u8_DrivingDirection);
   virtual tBool bDoExpand_LaneDirection(teafi_tclSemanticDomain::tenType enSemantic);
   virtual tBool bDoExpand_LaneInfoOneCellReference(teafi_tclSemanticDomain::tenType enSemantic);
   virtual tBool bDoExpand_LaneInfoOneCellIndexReference(teafi_tclSemanticDomain::tenType enSemantic);
   virtual tBool bDoExpand_LaneInfoPathSectionIndexReference(teafi_tclSemanticDomain::tenType enSemantic);
   virtual tBool bDoExpand_LaneInfoElementReference(teafi_tclSemanticDomain::tenType enSemantic);
   virtual tVoid vVisit_e8_LaneReferenceCategory(fi_tcl_e8_LaneReferenceCategory& o_e8_LaneReferenceCategory);
   virtual tBool bDoExpand_LaneReference(teafi_tclSemanticDomain::tenType enSemantic);
   virtual tBool bDoExpand_LaneInfo(teafi_tclSemanticDomain::tenType enSemantic);
   virtual tBool bDoExpand_LaneInfoSegment(teafi_tclSemanticDomain::tenType enSemantic);
   virtual tBool bDoExpand_LaneInfoSegmentList(teafi_tclSemanticDomain::tenType enSemantic);
   virtual tBool bDoExpand_LaneInfoListSet(teafi_tclSemanticDomain::tenType enSemantic);
   virtual tVoid vVisit_e8_TMGeometricMessageType(fi_tcl_e8_TMGeometricMessageType& o_e8_TMGeometricMessageType);
   virtual tVoid vVisit_e16_NaviEventValue(fi_tcl_e16_NaviEventValue& o_e16_NaviEventValue);
   virtual tVoid vVisit_e8_TMAffectionType(fi_tcl_e8_TMAffectionType& o_e8_TMAffectionType);
   virtual tBool bDoExpand_UPOI_Category(teafi_tclSemanticDomain::tenType enSemantic);
   virtual tVoid vVisit_e8_UPOI_Source(fi_tcl_e8_UPOI_Source& o_e8_UPOI_Source);
   virtual tVoid vVisit_b16_UPOI_Source(fi_tcl_b16_UPOI_Source& o_b16_UPOI_Source);
   virtual tVoid vVisit_b8_UPOI_FilterSetStatus(fi_tcl_b8_UPOI_FilterSetStatus& o_b8_UPOI_FilterSetStatus);
   virtual tVoid vVisit_b8_UPOI_Validity(fi_tcl_b8_UPOI_Validity& o_b8_UPOI_Validity);
   virtual tBool bDoExpand_UPOI_Element(teafi_tclSemanticDomain::tenType enSemantic);
   virtual tVoid vVisit_b8_UPOI_FilterSet_FieldRelevance(fi_tcl_b8_UPOI_FilterSet_FieldRelevance& o_b8_UPOI_FilterSet_FieldRelevance);
   virtual tBool bDoExpand_UPOI_FilterSet(teafi_tclSemanticDomain::tenType enSemantic);
   virtual tBool bDoExpand_UPOI_FilterList(teafi_tclSemanticDomain::tenType enSemantic);
   virtual tVoid vVisit_b8_UPOI_Status(fi_tcl_b8_UPOI_Status& o_b8_UPOI_Status);
   virtual tBool bDoExpand_UPOI_Combination(teafi_tclSemanticDomain::tenType enSemantic);
   virtual tBool bDoExpand_UPOI_ListSet(teafi_tclSemanticDomain::tenType enSemantic);
   virtual tVoid vVisit_e8_ShapeType(fi_tcl_e8_ShapeType& o_e8_ShapeType);
   virtual tBool bDoExpand_Shape(teafi_tclSemanticDomain::tenType enSemantic);
   virtual tBool bDoExpand_RDBId(teafi_tclSemanticDomain::tenType enSemantic);
   virtual tBool bDoExpand_TMProgramService(teafi_tclSemanticDomain::tenType enSemantic);
   virtual tBool bDoExpand_TMServiceProvider(teafi_tclSemanticDomain::tenType enSemantic);
   virtual tVoid vVisit_e8_TMCategory(fi_tcl_e8_TMCategory& o_e8_TMCategory);
   virtual tVoid vVisit_b8_TMMappingPossibility(fi_tcl_b8_TMMappingPossibility& o_b8_TMMappingPossibility);
   virtual tVoid vVisit_b8_TMMappingStatus(fi_tcl_b8_TMMappingStatus& o_b8_TMMappingStatus);
   virtual tVoid vVisit_b8_TMOneCellAttribute(fi_tcl_b8_TMOneCellAttribute& o_b8_TMOneCellAttribute);
   virtual tBool bDoExpand_TMOneCellPortion(teafi_tclSemanticDomain::tenType enSemantic);
   virtual tVoid vVisit_e8_TMValueStatus(fi_tcl_e8_TMValueStatus& o_e8_TMValueStatus);
   virtual tVoid vVisit_e8_TMCIntersectionPathType(fi_tcl_e8_TMCIntersectionPathType& o_e8_TMCIntersectionPathType);
   virtual tBool bDoExpand_TMCStructuredText(teafi_tclSemanticDomain::tenType enSemantic);
   virtual tVoid vVisit_e8_TMFlowImpact(fi_tcl_e8_TMFlowImpact& o_e8_TMFlowImpact);
   virtual tVoid vVisit_e8_TMUrgency(fi_tcl_e8_TMUrgency& o_e8_TMUrgency);
   virtual tVoid vVisit_e8_TMGeographicalPathRelationType(fi_tcl_e8_TMGeographicalPathRelationType& o_e8_TMGeographicalPathRelationType);
   virtual tVoid vVisit_b8_TMRelevance(fi_tcl_b8_TMRelevance& o_b8_TMRelevance);
   virtual tVoid vVisit_e8_TrafficMsgType(fi_tcl_e8_TrafficMsgType& o_e8_TrafficMsgType);
   virtual tVoid vVisit_e8_EventType(fi_tcl_e8_EventType& o_e8_EventType);
   virtual tVoid vVisit_b32_TrafficMessageSource(fi_tcl_b32_TrafficMessageSource& o_b32_TrafficMessageSource);
   virtual tVoid vVisit_u16_TripHandle(fi_tcl_u16_TripHandle& o_u16_TripHandle);
   virtual tVoid vVisit_u16_TripSegmentNumber(fi_tcl_u16_TripSegmentNumber& o_u16_TripSegmentNumber);
   virtual tVoid vVisit_u16_RouteHandle(fi_tcl_u16_RouteHandle& o_u16_RouteHandle);
   virtual tVoid vVisit_e8_TMLocationType(fi_tcl_e8_TMLocationType& o_e8_TMLocationType);
   virtual tVoid vVisit_e16_EffectCode(fi_tcl_e16_EffectCode& o_e16_EffectCode);
   virtual tVoid vVisit_e16_CauseCode(fi_tcl_e16_CauseCode& o_e16_CauseCode);
   virtual tVoid vVisit_e8_Tendency(fi_tcl_e8_Tendency& o_e8_Tendency);
   virtual tBool bDoExpand_TMEvent(teafi_tclSemanticDomain::tenType enSemantic);
   virtual tBool bDoExpand_TMInfo(teafi_tclSemanticDomain::tenType enSemantic);
   virtual tBool bDoExpand_TMCodedMessage(teafi_tclSemanticDomain::tenType enSemantic);
#ifndef FI_S_EXTERNAL_FI
   virtual tBool bDoExpand_TMCodedMessageBinContainer(teafi_tclSemanticDomain::tenType enSemantic);
#endif // FI_S_EXTERNAL_FI
   virtual tBool bDoExpand_TMCombination(teafi_tclSemanticDomain::tenType enSemantic);
   virtual tBool bDoExpand_TMInfoListSet(teafi_tclSemanticDomain::tenType enSemantic);
   virtual tBool bDoExpand_MapGeographicType(teafi_tclSemanticDomain::tenType enSemantic);
private:
	// ostream& oOut;
   tChar line[256];
   /*
	OSAL_tIODescriptor fd;
   char *ps8PrintBuf;
   tU32 u32BufSize;
   static const tU32 C_U32_MAXLINELENGTH;
   */
   fi_tclOutput* poOutput;
};


class MY_DECL teafi_tclRandomInitVisitor : public teafi_tclVisitorBase {
public:

   teafi_tclRandomInitVisitor(tU32 u32Seed=1):u32ListSize(3) { srand(u32Seed); }
   tVoid vSetSeed(tU32 u32Seed) const { srand(u32Seed); }
   // --Besuche allgemeine Objekte	
   virtual tVoid vVisitU8(fi_tclU8& oU8);
   virtual tVoid vVisitS8(fi_tclS8& oS8);
   virtual tVoid vVisitU16(fi_tclU16& oU16);
   virtual tVoid vVisitS16(fi_tclS16& oS16);
   virtual tVoid vVisitU24(fi_tclU24& oU24);
   virtual tVoid vVisitS24(fi_tclS24& oS24);
   virtual tVoid vVisitU32(fi_tclU32& oU32);
   virtual tVoid vVisitS32(fi_tclS32& oS32);
   virtual tVoid vVisitU64(fi_tclU64& oU64);
   virtual tVoid vVisitS64(fi_tclS64& oS64);
   virtual tVoid vVisitBool(fi_tclBool& oBool);
   virtual tVoid vVisitString(fi_tclString& oString);
   virtual tVoid vVisitMultiLanguageString(fi_tclMultiLanguageString& oString);
   virtual tVoid vVisitList(fi_tclList& oList);

	// Besuche die generierten Typen
   virtual tVoid vVisit_u8_Percent(fi_tcl_u8_Percent& o_u8_Percent);
   virtual tVoid vVisit_s16_PerThousand(fi_tcl_s16_PerThousand& o_s16_PerThousand);
   virtual tVoid vVisit_u16_IndexInReferenceList(fi_tcl_u16_IndexInReferenceList& o_u16_IndexInReferenceList);
   virtual tVoid vVisit_s32_Kilogram(fi_tcl_s32_Kilogram& o_s32_Kilogram);
   virtual tVoid vVisit_s32_Pound(fi_tcl_s32_Pound& o_s32_Pound);
   virtual tVoid vVisit_s16_Meter(fi_tcl_s16_Meter& o_s16_Meter);
   virtual tVoid vVisit_s32_Meter(fi_tcl_s32_Meter& o_s32_Meter);
   virtual tVoid vVisit_s32_Yards(fi_tcl_s32_Yards& o_s32_Yards);
   virtual tVoid vVisit_s32_Centimeter(fi_tcl_s32_Centimeter& o_s32_Centimeter);
   virtual tVoid vVisit_s32_Inch(fi_tcl_s32_Inch& o_s32_Inch);
   virtual tVoid vVisit_s32_Second(fi_tcl_s32_Second& o_s32_Second);
   virtual tVoid vVisit_e8_DST_State(fi_tcl_e8_DST_State& o_e8_DST_State);
   virtual tVoid vVisit_s16_KmPerHour(fi_tcl_s16_KmPerHour& o_s16_KmPerHour);
   virtual tVoid vVisit_s16_MilesPerHour(fi_tcl_s16_MilesPerHour& o_s16_MilesPerHour);
   virtual tVoid vVisit_s16_CentimeterSecond(fi_tcl_s16_CentimeterSecond& o_s16_CentimeterSecond);
   virtual tVoid vVisit_s32_Longitude(fi_tcl_s32_Longitude& o_s32_Longitude);
   virtual tVoid vVisit_s32_Latitude(fi_tcl_s32_Latitude& o_s32_Latitude);
   virtual tVoid vVisit_e16_ISOCountryCode(fi_tcl_e16_ISOCountryCode& o_e16_ISOCountryCode);
   virtual tVoid vVisit_u8_DirectionAbsolute(fi_tcl_u8_DirectionAbsolute& o_u8_DirectionAbsolute);
   virtual tVoid vVisit_s16_CentiDegree(fi_tcl_s16_CentiDegree& o_s16_CentiDegree);
   virtual tVoid vVisit_e8_BinContainerTypes(fi_tcl_e8_BinContainerTypes& o_e8_BinContainerTypes);
   virtual tVoid vVisit_s32_MEMU(fi_tcl_s32_MEMU& o_s32_MEMU);
   virtual tVoid vVisit_s32_EMU(fi_tcl_s32_EMU& o_s32_EMU);
   virtual tVoid vVisit_e8_NavOneCellDirection(fi_tcl_e8_NavOneCellDirection& o_e8_NavOneCellDirection);
   virtual tVoid vVisit_s16_CurvatureValue(fi_tcl_s16_CurvatureValue& o_s16_CurvatureValue);
   virtual tVoid vVisit_e8_RoadClassCode(fi_tcl_e8_RoadClassCode& o_e8_RoadClassCode);
   virtual tVoid vVisit_e8_SignPostDestType(fi_tcl_e8_SignPostDestType& o_e8_SignPostDestType);
   virtual tVoid vVisit_e8_SignPostDestinationCategory(fi_tcl_e8_SignPostDestinationCategory& o_e8_SignPostDestinationCategory);
   virtual tVoid vVisit_e8_SignPostDestStatus(fi_tcl_e8_SignPostDestStatus& o_e8_SignPostDestStatus);
   virtual tVoid vVisit_e8_DirectionStatus(fi_tcl_e8_DirectionStatus& o_e8_DirectionStatus);
   virtual tVoid vVisit_e8_DirectionCategory(fi_tcl_e8_DirectionCategory& o_e8_DirectionCategory);
   virtual tVoid vVisit_e8_NavOneCellCategory(fi_tcl_e8_NavOneCellCategory& o_e8_NavOneCellCategory);
   virtual tVoid vVisit_b8_DirectionInfoStatus(fi_tcl_b8_DirectionInfoStatus& o_b8_DirectionInfoStatus);
   virtual tVoid vVisit_e8_CrossroadInfoCategory(fi_tcl_e8_CrossroadInfoCategory& o_e8_CrossroadInfoCategory);
   virtual tVoid vVisit_b32_RoadProperty(fi_tcl_b32_RoadProperty& o_b32_RoadProperty);
   virtual tVoid vVisit_e8_NavStreetType(fi_tcl_e8_NavStreetType& o_e8_NavStreetType);
   virtual tVoid vVisit_e8_RoadNetworkClass(fi_tcl_e8_RoadNetworkClass& o_e8_RoadNetworkClass);
   virtual tVoid vVisit_b8_RoadNumberStatus(fi_tcl_b8_RoadNumberStatus& o_b8_RoadNumberStatus);
   virtual tVoid vVisit_e8_RequiredPermissionType(fi_tcl_e8_RequiredPermissionType& o_e8_RequiredPermissionType);
   virtual tVoid vVisit_e8_RequiredPermission(fi_tcl_e8_RequiredPermission& o_e8_RequiredPermission);
   virtual tVoid vVisit_e8_IntersectionType(fi_tcl_e8_IntersectionType& o_e8_IntersectionType);
   virtual tVoid vVisit_b8_PresenceIndicator(fi_tcl_b8_PresenceIndicator& o_b8_PresenceIndicator);
   virtual tVoid vVisit_b16_RoadAttribute(fi_tcl_b16_RoadAttribute& o_b16_RoadAttribute);
   virtual tVoid vVisit_e8_ExtraDescElementType(fi_tcl_e8_ExtraDescElementType& o_e8_ExtraDescElementType);
   virtual tVoid vVisit_b32_DataProperties(fi_tcl_b32_DataProperties& o_b32_DataProperties);
   virtual tVoid vVisit_b8_CrossroadProperties(fi_tcl_b8_CrossroadProperties& o_b8_CrossroadProperties);
   virtual tVoid vVisit_e8_BaseTrafficSignCategory(fi_tcl_e8_BaseTrafficSignCategory& o_e8_BaseTrafficSignCategory);
   virtual tVoid vVisit_e8_SpeedSign(fi_tcl_e8_SpeedSign& o_e8_SpeedSign);
   virtual tVoid vVisit_e16_WarningSign(fi_tcl_e16_WarningSign& o_e16_WarningSign);
   virtual tVoid vVisit_e16_RegulatorySign(fi_tcl_e16_RegulatorySign& o_e16_RegulatorySign);
   virtual tVoid vVisit_e16_AdditionalTrafficSign(fi_tcl_e16_AdditionalTrafficSign& o_e16_AdditionalTrafficSign);
   virtual tVoid vVisit_TimeDependentString(fi_tcl_TimeDependentString& o_TimeDependentString);
   virtual tVoid vVisit_b8_LaneDependentValidity(fi_tcl_b8_LaneDependentValidity& o_b8_LaneDependentValidity);
   virtual tVoid vVisit_e8_TrafficSignQuantifier(fi_tcl_e8_TrafficSignQuantifier& o_e8_TrafficSignQuantifier);
   virtual tVoid vVisit_b32_POICategory(fi_tcl_b32_POICategory& o_b32_POICategory);
   virtual tVoid vVisit_e8_PosHorizonState(fi_tcl_e8_PosHorizonState& o_e8_PosHorizonState);
   virtual tVoid vVisit_e8_DigitalMapSpeedCategoryType(fi_tcl_e8_DigitalMapSpeedCategoryType& o_e8_DigitalMapSpeedCategoryType);
   virtual tVoid vVisit_e8_PosHorizonSuccessorState(fi_tcl_e8_PosHorizonSuccessorState& o_e8_PosHorizonSuccessorState);
   virtual tVoid vVisit_b32_PathSectionStatus(fi_tcl_b32_PathSectionStatus& o_b32_PathSectionStatus);
   virtual tVoid vVisit_b8_PosHorizonSuccessorState(fi_tcl_b8_PosHorizonSuccessorState& o_b8_PosHorizonSuccessorState);
   virtual tVoid vVisit_b8_HorizonOneCellPropertyStatus(fi_tcl_b8_HorizonOneCellPropertyStatus& o_b8_HorizonOneCellPropertyStatus);
   virtual tVoid vVisit_b8_TEAPresenceIndicator(fi_tcl_b8_TEAPresenceIndicator& o_b8_TEAPresenceIndicator);
   virtual tVoid vVisit_b32_RoadInfoCategoryIndicator(fi_tcl_b32_RoadInfoCategoryIndicator& o_b32_RoadInfoCategoryIndicator);
   virtual tVoid vVisit_e8_HorizonRoadInfoCategory(fi_tcl_e8_HorizonRoadInfoCategory& o_e8_HorizonRoadInfoCategory);
   virtual tVoid vVisit_b8_CurvatureStatus(fi_tcl_b8_CurvatureStatus& o_b8_CurvatureStatus);
   virtual tVoid vVisit_e8_MPPState(fi_tcl_e8_MPPState& o_e8_MPPState);
   virtual tVoid vVisit_e8_TEAEventType(fi_tcl_e8_TEAEventType& o_e8_TEAEventType);
   virtual tVoid vVisit_s8_MapDisplayZLevel(fi_tcl_s8_MapDisplayZLevel& o_s8_MapDisplayZLevel);
   virtual tVoid vVisit_s8_MapDisplayPriority(fi_tcl_s8_MapDisplayPriority& o_s8_MapDisplayPriority);
   virtual tVoid vVisit_e8_MapElementDescrType(fi_tcl_e8_MapElementDescrType& o_e8_MapElementDescrType);
   virtual tVoid vVisit_e8_MapGeometricType(fi_tcl_e8_MapGeometricType& o_e8_MapGeometricType);
   virtual tVoid vVisit_e16_SelectionCriterionType(fi_tcl_e16_SelectionCriterionType& o_e16_SelectionCriterionType);
   virtual tVoid vVisit_e8_SurfaceCoverCode(fi_tcl_e8_SurfaceCoverCode& o_e8_SurfaceCoverCode);
   virtual tVoid vVisit_u16_UserTrafficMessageHandle(fi_tcl_u16_UserTrafficMessageHandle& o_u16_UserTrafficMessageHandle);
   virtual tVoid vVisit_e8_LaneStatus(fi_tcl_e8_LaneStatus& o_e8_LaneStatus);
   virtual tVoid vVisit_b8_LaneType(fi_tcl_b8_LaneType& o_b8_LaneType);
   virtual tVoid vVisit_b8_LaneChangeRestriction(fi_tcl_b8_LaneChangeRestriction& o_b8_LaneChangeRestriction);
   virtual tVoid vVisit_u8_IndexInLaneInfoSegmentList(fi_tcl_u8_IndexInLaneInfoSegmentList& o_u8_IndexInLaneInfoSegmentList);
   virtual tVoid vVisit_u8_IndexInLaneInfoList(fi_tcl_u8_IndexInLaneInfoList& o_u8_IndexInLaneInfoList);
   virtual tVoid vVisit_u8_DrivingDirection(fi_tcl_u8_DrivingDirection& o_u8_DrivingDirection);
   virtual tVoid vVisit_e8_LaneReferenceCategory(fi_tcl_e8_LaneReferenceCategory& o_e8_LaneReferenceCategory);
   virtual tVoid vVisit_e8_TMGeometricMessageType(fi_tcl_e8_TMGeometricMessageType& o_e8_TMGeometricMessageType);
   virtual tVoid vVisit_e16_NaviEventValue(fi_tcl_e16_NaviEventValue& o_e16_NaviEventValue);
   virtual tVoid vVisit_e8_TMAffectionType(fi_tcl_e8_TMAffectionType& o_e8_TMAffectionType);
   virtual tVoid vVisit_e8_UPOI_Source(fi_tcl_e8_UPOI_Source& o_e8_UPOI_Source);
   virtual tVoid vVisit_b16_UPOI_Source(fi_tcl_b16_UPOI_Source& o_b16_UPOI_Source);
   virtual tVoid vVisit_b8_UPOI_FilterSetStatus(fi_tcl_b8_UPOI_FilterSetStatus& o_b8_UPOI_FilterSetStatus);
   virtual tVoid vVisit_b8_UPOI_Validity(fi_tcl_b8_UPOI_Validity& o_b8_UPOI_Validity);
   virtual tVoid vVisit_b8_UPOI_FilterSet_FieldRelevance(fi_tcl_b8_UPOI_FilterSet_FieldRelevance& o_b8_UPOI_FilterSet_FieldRelevance);
   virtual tVoid vVisit_b8_UPOI_Status(fi_tcl_b8_UPOI_Status& o_b8_UPOI_Status);
   virtual tVoid vVisit_e8_ShapeType(fi_tcl_e8_ShapeType& o_e8_ShapeType);
   virtual tVoid vVisit_e8_TMCategory(fi_tcl_e8_TMCategory& o_e8_TMCategory);
   virtual tVoid vVisit_b8_TMMappingPossibility(fi_tcl_b8_TMMappingPossibility& o_b8_TMMappingPossibility);
   virtual tVoid vVisit_b8_TMMappingStatus(fi_tcl_b8_TMMappingStatus& o_b8_TMMappingStatus);
   virtual tVoid vVisit_b8_TMOneCellAttribute(fi_tcl_b8_TMOneCellAttribute& o_b8_TMOneCellAttribute);
   virtual tVoid vVisit_e8_TMValueStatus(fi_tcl_e8_TMValueStatus& o_e8_TMValueStatus);
   virtual tVoid vVisit_e8_TMCIntersectionPathType(fi_tcl_e8_TMCIntersectionPathType& o_e8_TMCIntersectionPathType);
   virtual tVoid vVisit_e8_TMFlowImpact(fi_tcl_e8_TMFlowImpact& o_e8_TMFlowImpact);
   virtual tVoid vVisit_e8_TMUrgency(fi_tcl_e8_TMUrgency& o_e8_TMUrgency);
   virtual tVoid vVisit_e8_TMGeographicalPathRelationType(fi_tcl_e8_TMGeographicalPathRelationType& o_e8_TMGeographicalPathRelationType);
   virtual tVoid vVisit_b8_TMRelevance(fi_tcl_b8_TMRelevance& o_b8_TMRelevance);
   virtual tVoid vVisit_e8_TrafficMsgType(fi_tcl_e8_TrafficMsgType& o_e8_TrafficMsgType);
   virtual tVoid vVisit_e8_EventType(fi_tcl_e8_EventType& o_e8_EventType);
   virtual tVoid vVisit_b32_TrafficMessageSource(fi_tcl_b32_TrafficMessageSource& o_b32_TrafficMessageSource);
   virtual tVoid vVisit_u16_TripHandle(fi_tcl_u16_TripHandle& o_u16_TripHandle);
   virtual tVoid vVisit_u16_TripSegmentNumber(fi_tcl_u16_TripSegmentNumber& o_u16_TripSegmentNumber);
   virtual tVoid vVisit_u16_RouteHandle(fi_tcl_u16_RouteHandle& o_u16_RouteHandle);
   virtual tVoid vVisit_e8_TMLocationType(fi_tcl_e8_TMLocationType& o_e8_TMLocationType);
   virtual tVoid vVisit_e16_EffectCode(fi_tcl_e16_EffectCode& o_e16_EffectCode);
   virtual tVoid vVisit_e16_CauseCode(fi_tcl_e16_CauseCode& o_e16_CauseCode);
   virtual tVoid vVisit_e8_Tendency(fi_tcl_e8_Tendency& o_e8_Tendency);
#ifndef FI_S_EXTERNAL_FI
#endif // FI_S_EXTERNAL_FI
	tU32 u32ListSize;
};

#endif
